(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    218558,       5391]
NotebookOptionsPosition[    173949,       4593]
NotebookOutlinePosition[    176411,       4656]
CellTagsIndexPosition[    176324,       4651]
WindowTitle->PetrovType
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["X IDEAL SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "c9cbc7fd-1401-5d4b-adc6-2434aaaada2c"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "13d33895-cd1e-cb49-bb75-296e38b7fe74"],
        Background->RGBColor[0.490196, 0.576471, 0.690196],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[Cell[BoxData[
     TagBox[
      ActionMenuBox[
       FrameBox[Cell[TextData[{
         "URL",
         " ",
         Cell[BoxData[
          GraphicsBox[
           {GrayLevel[0.66667], Thickness[0.13], 
            LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
           AspectRatio->1,
           ImageSize->20,
           PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
          "0898071d-237e-0942-b14a-065ea0f1857f"]
        }],ExpressionUUID->"e59841ad-03f5-7e4b-beeb-04ea5a888ef7"],
        StripOnInput->False],{
       "\"xIdeal/ref/PetrovType\"" :> None, 
        "\"Copy Wolfram Documentation Center URL\"" :> 
        Module[{DocumentationSearch`Private`nb$}, 
          DocumentationSearch`Private`nb$ = 
           NotebookPut[
            Notebook[{Cell["xIdeal/ref/PetrovType"]}, Visible -> False]]; 
          SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
          FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
          NotebookClose[DocumentationSearch`Private`nb$]; Null], Delimiter, 
        "\"Copy web URL\"" :> 
        Module[{DocumentationSearch`Private`nb$}, 
          DocumentationSearch`Private`nb$ = 
           NotebookPut[
            Notebook[{
              Cell[BoxData[
                MakeBoxes[
                 Hyperlink[
                  "http://reference.wolfram.com/language/xIdeal/ref/\
PetrovType.html"], StandardForm]], "Input", TextClipboardType -> 
                "PlainText"]}, Visible -> False]]; 
          SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
          FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
          NotebookClose[DocumentationSearch`Private`nb$]; Null], 
        "\"Go to web URL\"" :> 
        FrontEndExecute[{
          NotebookLocate[{
            URL[(If[TrueQ[False], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "xIdeal/ref/PetrovType") <> ".html"], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"],
      MouseAppearanceTag["LinkHand"]]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "cc226ef9-1f9a-764d-8ec4-548d0ec7acec"]], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "15366f0b-1b88-9248-9e8b-2db09ce14a68"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"df1157f3-8d14-bc4d-9505-0f6de17be8fc"],

Cell["xAct`xIdeal`", "ContextNameCell",ExpressionUUID->"a8fc0dd2-de89-6342-88d4-55a6fc6cdc4c"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "PetrovType", "ObjectName",ExpressionUUID->
      "58ae77b0-6e50-2342-881f-62c4645dda4c"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"6f056da9-2779-0b46-9326-a56f4c29eaa4"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "be593ab9-012f-ad48-8011-35da64fec6de"]
    }],ExpressionUUID->"c8702326-8a6c-9b48-9c99-528610f7e0a9"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"2696c91c-27e9-a94b-a893-\
afd8720002a3"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PetrovType", "[", 
       RowBox[{"metric", ",", " ", "opts"}], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a0469e6a-13cb-474d-a524-2a90da8e1a71"],
     " returns the Petrov type  of metric."
    }],ExpressionUUID->"fc8a9f3c-e44d-3b4c-a07e-3a2ee5f56bb9"]}
  }]], "Usage",
 CellID->423578463,ExpressionUUID->"fd252f38-fda2-5d4f-806d-d1938c47a771"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[
       MatchQ[
        CurrentValue[
         EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, 
         Closed], 
        Alternatives[Open, True]], 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
    ExpressionUUID->"0d7b9692-1ffa-074f-a1da-65c364559e20"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"964d0502-8669-bb46-be24-971312e2b70e"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"31103f62-05a7-fd45-8058-c435dd2779bb"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"c2f2ab27-0c03-6444-a3c7-a1b022f8a41b"]], \
"NotesSection",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->59259393,ExpressionUUID->"336a9765-5fa4-9440-8085-0a9649cb16e1"],

Cell["The following options can be given: ", "Notes",
 CellID->354734344,ExpressionUUID->"a8686e9f-4815-5e40-917c-cfcdb96eb3cc"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "9955fa8a-380f-384f-a49e-e79d6f426f0c"], "Method", "\"\<Default\>\"", 
    Cell["\<\
Method is an option for various algorithm-intensive functions that specifies \
what internal methods they should use.\
\>", "TableText",ExpressionUUID->"bfb15915-c630-2e47-a904-9dbecbe45b89"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "48a51e14-a40f-ad4c-b901-4fc23d9c2944"], "PSimplify", "$CVSimplify", 
    Cell["\<\
PSimplify is an option to choose the function used to simplify expressions.\
\>", "TableText",ExpressionUUID->"43400b3a-21df-9645-8001-49ee39eb9036"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "cbefb74f-3285-2249-8366-5b47e993da28"], "Parallelize", 
    TemplateBox[{
      Cell[
       TextData["True"]], "paclet:ref/True"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Parallelize", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "5ac5f26c-4799-c246-a605-2c6a22cc83fb"],
     " evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "e1b5d33c-3383-1e43-89ac-dc6e7cb71228"],
     " using automatic parallelization."
    }], "TableText",ExpressionUUID->"99a57cd9-fdc2-8b40-80b3-b91c77f5295f"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "3b32562e-a3c6-4541-9f08-78a8ade97c5a"], "Verbose", 
    TemplateBox[{
      Cell[
       TextData["True"]], "paclet:ref/True"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell["\<\
Verbose is a Boolean option for MakeRule, AutomaticRules and ToCanonical. \
Verbose->True gives lots of log-info about the internals of the calculation. \
Its default value is False. \
\>", "TableText",ExpressionUUID->"e8979d83-cb08-ed48-aa4b-b759c9c7b5e4"]},
   {Cell["      ", "TableRowIcon",ExpressionUUID->
     "f428a29e-7ef2-3940-99ef-32438c78d5b4"], "\"\<Observer\>\"", 
    TemplateBox[{
      Cell[
       TextData["Null"]], "paclet:ref/Null"},
     "RefLink",
     BaseStyle->{"3ColumnTableMod"}], Cell["\<\
Arbitrary time-like rank 1 CTensor needed if the \"PetrovMatrix\" Method is \
used.\
\>", "TableText",ExpressionUUID->"8998e37b-2c0e-454f-b14e-3ec8207844cf"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "Rows" -> {None, None, None, None, {None}}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->55188794,ExpressionUUID->"32b23f81-6d76-ee41-b041-f65d0d146cfc"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"521a1f4e-b325-834b-8a26-d94ea6af78c3"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c0624346-9e16-1349-aa24-6e61b4084421"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(7)", "ExampleCount",ExpressionUUID->
  "8ff52774-35e5-7d45-94ae-cdae824af05c"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->161879769,ExpressionUUID->"6b0d8679-991d-b243-8859-989fa6576993"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xIdeal`\>\"", "]"}]], "Input", "ExampleInitialization",
 Evaluatable->True,
 CellLabel->"In[1]:=",ExpressionUUID->"3c28868e-892b-394c-a4b2-89e438ee4a5f"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {5., 8.600000000000001}}]],
  ExpressionUUID->"b1f2124c-94dd-f44a-a9c2-05121f22044b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"74f25570-eabb-fe48-9f79-0e9d71626b8a"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a8c77b91-85ac-a445-9e73-2449396c4a7f"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->160607604,ExpressionUUID->"01fecb36-4dcb-4d4b-8893-a0959d81ec54"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"bbec9c68-63bd-9a41-b20b-5c90d4f4530c"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"e5c64e9b-b7cf-fb4b-ac08-c363e3fb30c1"],
 "Schwarzschild metric:",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "edd46126-ed09-1641-9f45-27e8e6a6870f"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->127660352,ExpressionUUID->"370365f9-f0da-6543-90e5-23df18a40364"],

Cell["\<\
Here, we will determine the Petrov Type of the Schwarzschild metric. We start \
by defining the coordinates and the metric:\
\>", "ExampleText",
 CellID->50967587,ExpressionUUID->"448295ce-e6fe-3040-8dd5-353641a32eb3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->172691151,ExpressionUUID->"f7d2d7b6-c377-0340-8616-efb8c6e9b886"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"Schw", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"\[Theta]", "[", "]"}], ",", 
      RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"mm", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<m\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "]"}], ">", "0"}], "&&", " ", 
    RowBox[{"mm", ">", "0"}], "&&", " ", 
    RowBox[{"Pi", ">", 
     RowBox[{"\[Theta]", "[", "]"}], ">", "0"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "mm"}], 
          RowBox[{"r", "[", "]"}]]}], ")"}]}], ",", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "mm"}], 
          RowBox[{"r", "[", "]"}]]}], ")"}], 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox[
       RowBox[{"r", "[", "]"}], "2"], ",", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"r", "[", "]"}], "2"], 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Schw"}], ",", 
       RowBox[{"-", "Schw"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "Schw", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",ExpressionUUID->"b1ccd84e-3342-7640-aa0a-325e4fc7669b"],

Cell["Now we use the function PetrovType:", "ExampleText",
 CellID->257215541,ExpressionUUID->"29a99349-ea5d-ac46-bb95-937e9631740f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PetrovType", "[", "metric", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",ExpressionUUID->"e4392ba7-4b92-2843-a07b-36374d48ccb8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->36758870,ExpressionUUID->"3a811eac-b52d-804a-84b9-12cff9c5a1c5"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->542454271,ExpressionUUID->"cabad5e5-6495-a945-b2a0-575f056bf8b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->45731199,ExpressionUUID->"8aa2db2c-ec38-0c44-9e89-b2748c056b4f"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->557289745,ExpressionUUID->"bb16cec0-a7b4-b243-9c26-508e75ac6435"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->197665391,ExpressionUUID->"483831fd-e408-a84e-a87c-797d208b566a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0010461`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0010461, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->314407021,ExpressionUUID->"60f3c948-10e7-1b45-ab6e-679b3f761b7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "3.4076393`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 3.4076393, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->100829430,ExpressionUUID->"5dd04f74-6e89-fa4a-b642-1c707fefe593"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->193228818,ExpressionUUID->"443d9b05-1116-0049-be36-4c28f3009de9"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->141055764,ExpressionUUID->"541be4d0-78ed-c140-adc2-f300fb57be9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->267616005,ExpressionUUID->"7b01c936-da12-e04e-ad47-3df7ea8e8da1"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->125999497,ExpressionUUID->"8efe272c-a84a-3e4d-a65e-3a4efe167489"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->395680676,ExpressionUUID->"a660f1c4-99b0-fd4c-a88e-4b68e0651dff"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->865966132,ExpressionUUID->"a4a383aa-9a0d-8748-b469-83e897e34d53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->400912798,ExpressionUUID->"7ea47932-ebd3-904c-8e7b-3f59334f14f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0006264`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0006264, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->477217340,ExpressionUUID->"e662d7d8-4019-414f-af85-8e7297a48968"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0245184`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0245184, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->277836256,ExpressionUUID->"4fa307c5-6366-754a-ac07-d0496fef871a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0006592`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "15040",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0006592, " seconds and ", 15040, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->408740174,ExpressionUUID->"2cd543e5-94a4-c740-acc3-e3bf2d8c3a5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->223342549,ExpressionUUID->"d91f41bd-4f9d-7841-9298-d58bf73d06ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0017609`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0017609, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->579341332,ExpressionUUID->"98a31503-afaa-f44b-a523-a532f38c74f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.025837`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.025837, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->275936458,ExpressionUUID->"8cd7a24c-3b1e-d44d-87df-cdb0c71e211a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0006799`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "14432",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0006799, " seconds and ", 14432, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->551052386,ExpressionUUID->"424ae6af-0e70-8241-9a2c-4094e6312c9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->554628866,ExpressionUUID->"729ed562-362e-364a-9568-53f0c93138d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0001444`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0001444, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->366350287,ExpressionUUID->"607156c8-670a-a349-adac-ca1c65af7f7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0103137`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0103137, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->373924390,ExpressionUUID->"1f9ec3f5-c1a0-f14f-9581-3c75edf3afb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0001472`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0001472, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->249768020,ExpressionUUID->"d6f74ccb-0653-4440-ae01-ef06dde34f51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->32080861,ExpressionUUID->"a5c592b1-bff3-3d48-a655-59ad9f637691"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0001814`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0001814, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->95668145,ExpressionUUID->"9bd755b9-885a-c34f-beb5-28345db28d33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.01909`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.01909, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->89755013,ExpressionUUID->"eb422405-7609-8346-b1c7-ee59e67df42e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0001509`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0001509, " seconds and ", 64, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->51727277,ExpressionUUID->"2b93f5bf-7773-e34e-a6a7-5c62a013e26d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->477881498,ExpressionUUID->"2e76a6b6-f082-a940-99b6-9f0756d2346f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000424`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000424, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->324159421,ExpressionUUID->"be3c723b-088b-f346-8be4-34d295b6ee51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0224433`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0224433, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->196665839,ExpressionUUID->"572eadfc-3a7e-3747-b597-a945916b5314"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0006504`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "15040",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0006504, " seconds and ", 15040, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->439990130,ExpressionUUID->"17b6cc48-2b62-514a-a0b0-b0b5146c34b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.0372129`6.022238509390161", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.0372129`6.022238509390161, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->280313044,ExpressionUUID->"497a88d3-0035-8741-b423-177a94887c54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0256617`5.860830417014371", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.0256617`5.860830417014371, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->44859336,ExpressionUUID->"d25c05ea-3add-1144-af63-537dbdc558ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->77430255,ExpressionUUID->"bd8fbd70-e48f-4444-9d3c-60cabe069669"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.0317544`5.953348904645983", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.0317544`5.953348904645983, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->402995305,ExpressionUUID->"527bec55-990b-6845-9ab5-58f0bd6a1a2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->75259359,ExpressionUUID->"2209ff57-bfcc-f947-a14a-aef625d9538a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0422339`6.0772061807762965", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"G2Form\" in ", 0.0422339`6.0772061807762965, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->348010637,ExpressionUUID->"08dd3b65-9878-e24c-8576-ca63479c3b4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.0994609`6.449197378246041", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.0994609`6.449197378246041, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->173996492,ExpressionUUID->"eb6ab387-0e56-f740-8c69-8c5122ab02ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.0634048`6.253667130472406", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.0634048`6.253667130472406, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->70886171,ExpressionUUID->"2f2eeb0f-1a03-3744-bab8-bfda06049ee5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.1269156000000000001`6.555060000756331", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.1269156000000000001`6.555060000756331, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1040856,ExpressionUUID->"86d08b02-4e21-4549-ade4-6dbe69fcd035"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->417065052,ExpressionUUID->"a6ecb1a0-50ae-654c-9cac-9ccfe95c06a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.0159694`5.654833592691169", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.0159694`5.654833592691169, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->686343053,ExpressionUUID->"975266b5-e5e8-dd44-b6a9-2f5b912ac8ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.0641108`6.258476189712379", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.0641108`6.258476189712379, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->36630883,ExpressionUUID->"759c34d7-0aae-4d44-8329-04b2a452f17f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.1258217`6.551300542216774", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.1258217`6.551300542216774, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->565183869,ExpressionUUID->"ceeb7a30-b950-9b41-87d7-92ef48ea30c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->447858985,ExpressionUUID->"54498170-b0ad-f34d-af5c-32252d7ae13a"]
}, Open  ]],

Cell[BoxData["\<\"Type D\"\>"], "Output",
 CellLabel->"Out[3]=",
 CellID->133103006,ExpressionUUID->"79aeca75-a8d8-7445-96ee-cfb11423c350"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"TODO", ":", " ", 
   RowBox[{
   "Homogeneize", " ", "messages", " ", "of", " ", "ReportCompute"}]}], 
  "*)"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",
 CellID->532150,ExpressionUUID->"c95bfe38-408f-9e48-a409-72624aedd5fd"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"e11f221a-9128-d74b-a124-0a68f4aada35"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"ed25014b-3b88-f54f-9dc3-5ba18bbbba08"],
 "Scope",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "faa93d7c-7f7b-6148-beeb-6dfdd4b80d7a"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"cddd1792-72d0-144f-b7b4-1ae463ad06bb"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"4d632b98-dfa7-1f41-ae7a-7d20fbb97b31"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c7d179b8-99c3-6749-9b83-23f7deb92b51"],
 "Petrov  and type II metrics:",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "47359e80-eb50-4d48-80e7-a14612185b82"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->76226682,ExpressionUUID->"e86d4502-323b-6c4a-959b-b0a34cecf470"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Manual", " ", "kernel", " ", "restart", " ", "is", " ", "required", " ", 
   "to", " ", "run", " ", "this", " ", "subsection"}], "*)"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->158258572,ExpressionUUID->"daedd326-cccc-e04d-8531-8f9d167cb9ae"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->539079816,ExpressionUUID->"b48ccde6-3284-904f-b61a-004c36177b8b"],

Cell["\<\
Now, we consider the Petrov metric (see Stephani H, Kramer D, MacCallum M A \
H, Hoenselaers C and Herlt E 2003 Exact Solutions of the Einstein\
\[CloseCurlyQuote]s Field Equation (Cambridge University Press) eq. (12.14)):\
\>", "ExampleText",
 CellID->46613096,ExpressionUUID->"a84fb2e0-0344-2b49-9462-e4df198d85fd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"ch", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"x", "[", "]"}], ",", 
      RowBox[{"y", "[", "]"}], ",", 
      RowBox[{"z", "[", "]"}]}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"kk", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<k\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"kk", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["E", 
             RowBox[{"x", "[", "]"}]]}], 
           RowBox[{"Cos", "[", 
            RowBox[{
             SqrtBox["3"], 
             RowBox[{"x", "[", "]"}]}], "]"}]}], ",", "0", ",", "0", ",", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["E", 
             RowBox[{"x", "[", "]"}]]}], 
           RowBox[{"Sin", "[", 
            RowBox[{
             SqrtBox["3"], 
             RowBox[{"x", "[", "]"}]}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          SuperscriptBox["E", 
           RowBox[{
            RowBox[{"-", "2"}], 
            RowBox[{"x", "[", "]"}]}]], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["E", 
             RowBox[{"x", "[", "]"}]]}], 
           RowBox[{"Sin", "[", 
            RowBox[{
             SqrtBox["3"], 
             RowBox[{"x", "[", "]"}]}], "]"}]}], ",", "0", ",", "0", ",", 
          RowBox[{
           SuperscriptBox["E", 
            RowBox[{"x", "[", "]"}]], 
           RowBox[{"Cos", "[", 
            RowBox[{
             SqrtBox["3"], 
             RowBox[{"x", "[", "]"}]}], "]"}]}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "ch"}], ",", 
       RowBox[{"-", "ch"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "ch", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",ExpressionUUID->"d7398ea3-f98a-7942-9749-6d26f0a6caee"],

Cell["And determine its Petrov Type:", "ExampleText",
 CellID->98290569,ExpressionUUID->"9d39d46c-a163-9c43-9a19-17679abdcdd4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PetrovType", "[", "metric", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",ExpressionUUID->"2424a42f-a1af-9b47-a964-7c4e3ca9c06a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->439429089,ExpressionUUID->"a267decd-e5fe-874f-a857-9abead5d61e0"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->83399039,ExpressionUUID->"1f43acd3-548b-644e-8e8a-fc2975546475"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->686717446,ExpressionUUID->"b3a26278-a070-7445-baeb-a266ffd04075"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->6460991,ExpressionUUID->"31f81b8d-46b4-e043-957f-4bde7976256e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->152649542,ExpressionUUID->"a3d3cf24-3c0b-674c-bbf7-015bbe364532"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000671`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000671, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->277460285,ExpressionUUID->"933124de-79a6-2144-b301-d5fcdc896b81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "3.3418925`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 3.3418925, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->430312814,ExpressionUUID->"e3afe70b-d5a9-3144-8f36-cb8c9a414365"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->340147670,ExpressionUUID->"7cd4076c-5894-af43-8d99-ef30a2de424f"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->44715888,ExpressionUUID->"c173f57e-822f-694d-a95c-cfd0d1fd8a0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->565652185,ExpressionUUID->"0b838e43-49e7-f041-bde8-9347f03ac30e"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->21861524,ExpressionUUID->"eb4c5eaf-3cf0-c144-933c-8487588eac22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->187798252,ExpressionUUID->"ae98584f-3028-7a41-9c89-6409d8b2ccd7"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->425194980,ExpressionUUID->"7b2acc7c-bd15-ca42-8ab4-63de283ab0d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->313610998,ExpressionUUID->"f7934527-5ad9-704f-96d8-eb70e857095f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0013104`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0013104, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->78962131,ExpressionUUID->"0caf334d-7198-984a-b643-a55648aec408"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0517551`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0517551, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->6515154,ExpressionUUID->"45b03789-f683-b245-92f7-40a175c48a93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0008308`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "41888",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0008308, " seconds and ", 41888, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->135200560,ExpressionUUID->"1b743e0a-f802-ce48-bba0-d85e6dcb924c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->63148,ExpressionUUID->"a8dac537-1cf8-d644-bb42-fc0de96c9f50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0020478`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0020478, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->209418160,ExpressionUUID->"405f328d-6217-e749-a9a0-89472c69423e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0410846`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0410846, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->626307160,ExpressionUUID->"4577233b-0178-0549-9a34-3689b2421425"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0008299`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "29944",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0008299, " seconds and ", 29944, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->730606735,ExpressionUUID->"39222411-d0fa-474c-adc1-bdf63a7ffcdf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->285943789,ExpressionUUID->"9920573d-70e8-f247-a72f-8144a92e707d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0001538`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0001538, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->671134652,ExpressionUUID->"4d5cb77f-d0b2-c54a-b2e7-f0dd48811df3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0099926`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0099926, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->125019452,ExpressionUUID->"08a8e36e-b01f-d442-bafe-fa628022e560"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0001663`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0001663, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->733827319,ExpressionUUID->"e181cf00-a290-5d4c-b491-1cb8a2c81767"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->624382770,ExpressionUUID->"1abc597b-9a85-594b-8d62-0fc1656e4634"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000068`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000068, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->17824522,ExpressionUUID->"3e30580c-038e-b544-8c5c-4edf0d7829a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0210066`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0210066, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->39429224,ExpressionUUID->"3d9a68c2-8a75-264c-a1ae-d077f157e65b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0001697`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0001697, " seconds and ", 64, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->124631426,ExpressionUUID->"1c98381d-dc14-e64c-b385-66530553dacc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->440032392,ExpressionUUID->"3a43b04d-e34d-dd41-a66a-906978bfd9d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0005891`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0005891, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->6230739,ExpressionUUID->"f68c5bac-6ae9-534f-8bd6-89369af220f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0429411`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0429411, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->227400439,ExpressionUUID->"3d68a385-dc2e-fc4b-9b5a-148503324501"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0011443`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "41888",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0011443, " seconds and ", 41888, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->228865095,ExpressionUUID->"021633aa-6b31-d74b-9ef0-6efae8f6a6c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.0942616`6.4258798007132825", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.0942616`6.4258798007132825, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->202121300,ExpressionUUID->"ff247395-c88c-2543-a8a6-0bf83922d33f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0791573`6.3500359658027", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.0791573`6.3500359658027, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->734404075,ExpressionUUID->"86cbd86f-893f-874d-b39d-6c81cdee5f34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0155276`5.642649328342127", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0.0155276`5.642649328342127, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->220825984,ExpressionUUID->"a1faa753-209f-7d4c-aae8-3810aa220600"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.0630201`6.251024081470954", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.0630201`6.251024081470954, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->47633791,ExpressionUUID->"0501caae-d35b-684e-9b59-15d8412cdcde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->24008194,ExpressionUUID->"01f51d33-7cbd-354a-b40d-0a4a3828448c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.031161`5.945156379836464", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"G2Form\" in ", 0.031161`5.945156379836464, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->69511007,ExpressionUUID->"83185cfa-8806-9d4b-ab64-c38e49175f75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.408793`7.063048444009612", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.408793`7.063048444009612, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->171269636,ExpressionUUID->"1fc95928-6c2b-8044-9925-0e89f1aaa637"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.0786509`6.347248690103052", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.0786509`6.347248690103052, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->225601642,ExpressionUUID->"2ffffe1a-7a9b-9b47-b115-8b4523d064fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.3296919`6.969653270852908", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.3296919`6.969653270852908, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->371050589,ExpressionUUID->"97f8ad6c-1b0c-d941-a8cc-d8f061dccd58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->389358143,ExpressionUUID->"f2dd383a-1f67-104d-98ac-be2d6a552093"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.0317613`5.953443263424583", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.0317613`5.953443263424583, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->38509784,ExpressionUUID->"ba721038-89e0-a24d-bdbb-e8060ed72da4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.046989`6.12354119614601", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.046989`6.12354119614601, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->404978493,ExpressionUUID->"5bbbaa28-bac9-674b-a556-aa1c521a8053"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.1099043`6.492559678000803", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.1099043`6.492559678000803, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->303180542,ExpressionUUID->"c72252b5-8699-9143-beab-71cd3656ec82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->16034834,ExpressionUUID->"9dbaa98b-62e9-e840-9405-6f43a7c77b49"]
}, Open  ]],

Cell[BoxData["\<\"Type I\"\>"], "Output",
 CellLabel->"Out[4]=",
 CellID->531771314,ExpressionUUID->"878d375b-c0d6-344c-9ae1-50961554378d"]
}, Open  ]],

Cell["\<\
If we now want to declare a new metric on the manifold, we need to unset the \
previous one and clear the Weyl concomitants saved on the cache:\
\>", "ExampleText",
 CellID->383569643,ExpressionUUID->"de04a004-d8c0-2441-8667-ddd79b54db25"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"UnsetCMetric", "/@", "$Metrics"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[5]:=",ExpressionUUID->"87c58e44-7e15-7e4f-947b-f83d91afaa0d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"TODO", ":", " ", 
    RowBox[{
    "Add", " ", "the", " ", "option", " ", "of", " ", "clearing", " ", "all", 
     " ", "the", " ", "concomitants"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"TODO", ":", " ", 
    RowBox[{
    "It", " ", "is", " ", "a", " ", "bit", " ", "tiresome", " ", "to", " ", 
     "use", " ", "ClearxIdealCache", " ", "each", " ", "time"}]}], 
   "*)"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[6]:=",
 CellID->267828646,ExpressionUUID->"c383a8ea-8150-d84c-b7b5-ee3ab620d614"],

Cell["\<\
Now we can declare a metric of Petrov type II (see Stephani H, Kramer D, \
MacCallum M A H, Hoenselaers C and Herlt E 2003 Exact Solutions of the \
Einstein\[CloseCurlyQuote]s Field Equation (Cambridge University Press) eqs. \
(33.25) and (33.30)):\
\>", "ExampleText",
 CellID->36750435,ExpressionUUID->"d44da09c-6ba8-ba4d-b3ef-fbd05b050d33"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"ch2", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"v", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"x", "[", "]"}], ",", 
      RowBox[{"y", "[", "]"}]}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"\[Kappa]", ",", 
    RowBox[{
    "PrintAs", "->", " ", 
     "\"\<\!\(\*SubscriptBox[\(\[Kappa]\), \(0\)]\)\>\""}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Kappa]", " ", 
           RowBox[{"x", "[", "]"}]}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", 
          FractionBox[
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SqrtBox["2"]}], 
           RowBox[{"4", " ", 
            RowBox[{"x", "[", "]"}]}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
          FractionBox[
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SqrtBox["2"]}], 
           RowBox[{"4", " ", "\[Kappa]", " ", 
            SuperscriptBox[
             RowBox[{"x", "[", "]"}], "2"]}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          FractionBox["3", 
           RowBox[{"2", "\[Kappa]", " ", 
            SuperscriptBox[
             RowBox[{"x", "[", "]"}], "3"]}]], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SqrtBox["2"]}], 
           RowBox[{"4", " ", 
            RowBox[{"x", "[", "]"}]}]], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SqrtBox["2"]}], 
           RowBox[{"4", " ", "\[Kappa]", " ", 
            SuperscriptBox[
             RowBox[{"x", "[", "]"}], "2"]}]], ",", "0", ",", 
          FractionBox[
           RowBox[{"-", "15"}], 
           RowBox[{"8", "\[Kappa]", " ", 
            SuperscriptBox[
             RowBox[{"x", "[", "]"}], "3"]}]]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "ch2"}], ",", 
       RowBox[{"-", "ch2"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "ch2", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[7]:=",ExpressionUUID->"8cfae815-74c8-674c-83fe-781dd4d5b79e"],

Cell["and determine its Petrov Type:", "ExampleText",
 CellID->314375278,ExpressionUUID->"4785c1ae-3bdf-c64f-a1b5-e478270a67a9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PetrovType", "[", "metric", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[8]:=",ExpressionUUID->"86e3acbf-d337-9b4d-8036-a1f89bc4bbb7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->54699648,ExpressionUUID->"1c99c4ee-4bc7-8944-ae17-4eb4de3c302b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->98611768,ExpressionUUID->"770d4a9a-d669-0448-a131-6903e8e7235e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->59022032,ExpressionUUID->"5c1159a5-7b1b-dd4f-bef1-6f091d2f20f9"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->116465742,ExpressionUUID->"314a1a4f-8b97-604c-9b0c-7bfdad7665a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->450919699,ExpressionUUID->"f629966c-fa41-ad4f-941e-ffe12e6074ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0005914`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0005914, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->170526698,ExpressionUUID->"632e8ac2-3b6b-2742-a3c5-382b7c2507af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0426276`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0426276, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->171927905,ExpressionUUID->"a475c4b6-cc04-d547-945b-f36a76244558"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->342007586,ExpressionUUID->"210b2dc7-fe07-9b4b-915d-a081eb62b06e"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->663703864,ExpressionUUID->"845cd379-57c7-3948-ae8b-ead2b0317e2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->192043008,ExpressionUUID->"0d25aad2-6a01-764a-ae59-c31580bcbe30"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->19821274,ExpressionUUID->"93d0a880-a2cb-2741-b3fb-f4eabc5d31ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->619735940,ExpressionUUID->"3997287b-d918-8d47-ae6d-0459b198d810"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->155895278,ExpressionUUID->"bfbbdfc6-6c52-b44a-8957-b23d6f15245b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->3856477,ExpressionUUID->"3dba1ef6-e288-d046-b539-c7b2511abde9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0007942`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0007942, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->52719810,ExpressionUUID->"b75de234-87b3-f743-b636-40749cfec0fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0407061`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0407061, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->374270265,ExpressionUUID->"1f6591ec-8edb-a94e-94f8-488872fc2478"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0010442`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "21120",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0010442, " seconds and ", 21120, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->428654040,ExpressionUUID->"fa14c21d-2f49-7d48-a241-a26b9aa52311"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->92495796,ExpressionUUID->"5aee344b-0f0d-9342-b5ce-48850ba03a41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0046132`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0046132, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->502149336,ExpressionUUID->"bf58c596-c512-254d-84be-41baa4c0c25a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0210659`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0210659, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->20523092,ExpressionUUID->"3eb46218-0d4c-b342-8f14-755b8d67940f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0008639`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "23840",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0008639, " seconds and ", 23840, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->200028980,ExpressionUUID->"007b4ce9-7aec-7c40-b04d-ea7da94f1b82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->543430168,ExpressionUUID->"20689bfc-263a-8847-839a-7dafcfc58ef2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0001564`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0001564, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->34609275,ExpressionUUID->"bc314bfd-7f8e-de46-a9dd-786e0fb30b23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0140674`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0140674, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->89441627,ExpressionUUID->"842ba19b-bbb0-1d41-b975-b2aaaa68f2b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0001865`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "1240", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0001865, " seconds and ", 1240, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->27811845,ExpressionUUID->"ecbe05a3-2410-f847-9e62-0006cf464655"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->337506462,ExpressionUUID->"a99c0e2a-ce5d-af42-83a6-58382131543e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0001154`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0001154, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->440398188,ExpressionUUID->"f71220d1-88a7-8d4a-a5cd-29d476651229"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0176333`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0176333, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->359147706,ExpressionUUID->"73438c58-717a-4447-9d24-d4a94fdf564f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0001588`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "144", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0001588, " seconds and ", 144, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->752612746,ExpressionUUID->"e43e297b-b1f4-764e-a559-053277d9bc8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->452928495,ExpressionUUID->"356411ec-4920-7845-ae39-0642ab897160"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0008185`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0008185, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->1266384,ExpressionUUID->"7d375f27-f14f-4144-a861-4dd1492db54a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0246319`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0246319, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->568193402,ExpressionUUID->"31e80afd-d407-c34d-a3be-dd2dfd3dba20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0013421`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "22000",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0013421, " seconds and ", 22000, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->62106715,ExpressionUUID->"5519b4c2-b4b0-384c-bee9-289d0743733f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.0477874`6.130858395718585", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.0477874`6.130858395718585, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->734246141,ExpressionUUID->"ad0f3fa8-ce41-dc48-b1c2-67fd08d2c9a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0164077`5.666592700245868", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.0164077`5.666592700245868, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->460882041,ExpressionUUID->"cbf4ea74-e901-474f-bebd-d76abff64554"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->391848758,ExpressionUUID->"e04d3fa4-5454-0744-9d8f-9bfa01483654"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.0305268`5.936226274860467", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.0305268`5.936226274860467, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->801250070,ExpressionUUID->"0f7f8d2a-28ee-8c4c-9fa2-27ffd45970b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->84189710,ExpressionUUID->"b6958db8-8347-3648-84d6-0084a668956b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.015637`5.645698429661067", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"G2Form\" in ", 0.015637`5.645698429661067, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->96727752,ExpressionUUID->"98787b7e-f5e7-7943-950b-7051693775eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.2367225`6.825784532208499", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.2367225`6.825784532208499, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->1010910000,ExpressionUUID->"75d023b2-fa32-4f4d-9bba-7f75077d2c28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.0628825`6.2500747929812315", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.0628825`6.2500747929812315,
    " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->323502364,ExpressionUUID->"4dbd31a8-7848-f14f-8b4c-5a5efa5be241"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.2055502`6.764462897180345", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.2055502`6.764462897180345, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->235743712,ExpressionUUID->"99dcb87a-561b-1943-8ab4-b48a323c52c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->784081525,ExpressionUUID->"b6d69f0c-4442-854e-9af9-85fd6775e298"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.0655834`6.268338921275529", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.0655834`6.268338921275529, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->608875062,ExpressionUUID->"90a27004-9b16-6345-a4a0-9e21ccab2429"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.0757763`6.331078389251348", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.0757763`6.331078389251348, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->698153081,ExpressionUUID->"d3e45348-2ffe-f842-ab0d-9073da556b40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.2377267`6.827622955247145", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.2377267`6.827622955247145, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->19744106,ExpressionUUID->"5991cd29-fcba-2443-ba63-a7282ffdc2f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[14]:=",
 CellID->154778797,ExpressionUUID->"a51fb8e2-fca4-f242-bc0b-bd06cfc26d0b"]
}, Open  ]],

Cell[BoxData["\<\"Type II\"\>"], "Output",
 CellLabel->"Out[8]=",
 CellID->351924309,ExpressionUUID->"553af455-1825-724c-8e98-7303839e8757"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"4da3ea94-c2cb-084a-b8e9-6f9e4a6e8c37"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"c1619210-bbfe-744d-830b-787476f6f2d4"],
 "Options",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount",ExpressionUUID->
  "d6b0e178-3e0b-004c-827d-3a4ba7f917df"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"8621b7c4-cc1f-394c-94ee-dc6c7bddb1e7"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"cafbeec0-c25b-2c48-908f-0483d5f60888"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"a85c2c70-34e6-8b4b-962c-ddc3923d643c"],
 "\nRowBox[{\"Method\", \" \", \"and\", \" \", \"Observer\"}]",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount",ExpressionUUID->
  "1c60399d-6643-f34b-ad53-e966e8486156"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"0472748a-946a-7041-a960-456f931ec35d"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsubsection", "0"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"2614e568-d4a8-ab41-a01c-dd5e4aaed603"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"f6af1140-9e6b-784d-b600-8d9dd9ec5e13"],
 "WeylSelfdual",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "891bf688-7b33-ac4f-b1fd-2beb6a11f230"]
}], "ExampleSubsubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->101096468,ExpressionUUID->"143b0fa3-a57f-9347-bdcc-44c985abdfa0"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Manual", " ", "kernel", " ", "restart", " ", "is", " ", "required", " ", 
   "to", " ", "run", " ", "this", " ", "subsection"}], "*)"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellID->397006184,ExpressionUUID->"a157d663-a316-3b4c-8bc2-b38cbce47c02"],

Cell["\<\
This is the method used by default, but we can also specify it. Let us \
declare the Schwarzschild metric:\
\>", "ExampleText",
 CellID->56015443,ExpressionUUID->"48fa4569-1e51-cd47-af05-11c86aec1702"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"Schw", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"\[Theta]", "[", "]"}], ",", 
      RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"mm", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<m\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "]"}], ">", "0"}], "&&", " ", 
    RowBox[{"mm", ">", "0"}], "&&", " ", 
    RowBox[{"Pi", ">", 
     RowBox[{"\[Theta]", "[", "]"}], ">", "0"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "mm"}], 
          RowBox[{"r", "[", "]"}]]}], ")"}]}], ",", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "mm"}], 
          RowBox[{"r", "[", "]"}]]}], ")"}], 
       RowBox[{"-", "1"}]], ",", 
      SuperscriptBox[
       RowBox[{"r", "[", "]"}], "2"], ",", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"r", "[", "]"}], "2"], 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], "2"]}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Schw"}], ",", 
       RowBox[{"-", "Schw"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "Schw", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->55503591,ExpressionUUID->"39d4f151-b706-df41-a53d-f1f4500cbeed"],

Cell["\<\
Now, we specify the desired method to determine the Petrov Type by using the \
following syntax:\
\>", "ExampleText",
 CellID->353703688,ExpressionUUID->"556fdc57-ab78-794f-b257-8fc759c9508d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PetrovType", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"Method", "->", " ", "\"\<WeylSelfdual\>\""}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[9]:=",
 CellID->16297071,ExpressionUUID->"0bc31972-9478-874f-ae29-8816cdb3c53a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->494737596,ExpressionUUID->"91baa5e9-de1b-4144-9dfe-cf8fe03193b8"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->180080164,ExpressionUUID->"991974a1-da74-d249-9c6a-18d6e313b2be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->133340884,ExpressionUUID->"0027d487-a6f4-204d-9ae6-eebef506465d"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->440953130,ExpressionUUID->"615f1dbc-fbc1-1449-9029-e854f8064866"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->780074226,ExpressionUUID->"95720abc-f1c5-a440-a9eb-d27682a15ff1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0003888`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0003888, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->94782328,ExpressionUUID->"06368020-eace-b645-960c-30e8c5755dc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "2.9673773`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 2.9673773, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->374068930,ExpressionUUID->"53cdee64-aea5-f44c-95cd-49819b654949"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->39073586,ExpressionUUID->"f6e98f24-d865-8841-8477-10929911dfab"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->13580455,ExpressionUUID->"98c7ac21-6bd6-464e-ad28-cb4bce28615a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->178467582,ExpressionUUID->"5bcb7855-9b7b-6242-9acf-629c8f007351"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->50261718,ExpressionUUID->"2d1d942c-1c5a-754c-bc08-5175f8427fad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->650364275,ExpressionUUID->"fd93ac6f-ea09-1b42-a002-0d8a171b1c7e"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->76883460,ExpressionUUID->"5ae44453-19cf-ac41-9266-43e952b3dfc5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->87512521,ExpressionUUID->"e06b9433-e03b-8d42-8d1c-0714b863e9eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0005441`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0005441, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->500978989,ExpressionUUID->"5b8d8d7c-3d18-6a49-87b1-84eb864cb46b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.026943`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.026943, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->217813219,ExpressionUUID->"6db8cf02-b6fb-174a-84f4-68d97f442370"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0006877`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "15040",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0006877, " seconds and ", 15040, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->232605866,ExpressionUUID->"df33157b-5865-2541-8f34-43e254c89754"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->226113254,ExpressionUUID->"375dee6e-ff33-b44c-bff5-5e488d54a5f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.001535`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.001535, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->843573,ExpressionUUID->"aa605c3c-e116-df41-92d3-6024fffa1c9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0270702`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0270702, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->790607361,ExpressionUUID->"803f4637-493c-d94f-b2bd-ff9fb022b6a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0004625`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "14432",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0004625, " seconds and ", 14432, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->937714680,ExpressionUUID->"6872f71a-9887-b343-96a3-ed28db50a848"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->10293579,ExpressionUUID->"e121a29c-8004-744b-90e7-69d0056fe179"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0001034`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0001034, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->654161343,ExpressionUUID->"dad6016f-6b03-c24b-b9c2-e575170ecb19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0079057`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0079057, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->53947886,ExpressionUUID->"8c125549-89dd-1b43-9b39-675d2402d581"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000112`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000112, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->492396258,ExpressionUUID->"29f7fed0-9685-f645-a469-505b90998f2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->13155563,ExpressionUUID->"e38952aa-873e-8147-a588-78b266bfee4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0000562`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0000562, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->24930369,ExpressionUUID->"2b3c89e3-8fc7-1246-80b5-23380e4c52cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.0178366`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.0178366, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->72668728,ExpressionUUID->"69611e4f-2166-7843-8e80-a4d3ee029277"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0001402`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0001402, " seconds and ", 64, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->503137211,ExpressionUUID->"98179dff-94d2-b548-9eab-ee6555b92fa0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->18018325,ExpressionUUID->"b0166dc0-0dd9-d042-8a11-470ee141e6c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.0003252`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.0003252, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->263529995,ExpressionUUID->"630e9053-3855-1144-849d-f8d89ff2deb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.02069`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.02069, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->702035631,ExpressionUUID->"0263c637-92f8-6142-b8bc-0c3595e0252d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.0004563`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "15040",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.0004563, " seconds and ", 15040, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->141502553,ExpressionUUID->"b55be37f-5b38-4c49-94c0-d7514a20db29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.0317875`5.9538013666797385", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.0317875`5.9538013666797385, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->86874292,ExpressionUUID->"8baff00b-7562-b449-a72b-475956e7f8e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0225921`5.805501595200899", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.0225921`5.805501595200899, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->571061288,ExpressionUUID->"82b05650-9355-b14e-bcae-1da616233517"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->58042308,ExpressionUUID->"8abdf494-4838-4848-9463-c87bead1486f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.0246539`5.843430623580025", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.0246539`5.843430623580025, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->315257790,ExpressionUUID->"9862bd64-8541-5f49-bdd8-d40ef1e1152e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->120443633,ExpressionUUID->"14602103-db83-c241-aea1-0d7a14eabc7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0327896`5.9672811122436435", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"G2Form\" in ", 0.0327896`5.9672811122436435, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->723801734,ExpressionUUID->"5d9421fb-52d7-3b4a-b905-b7e99ccb4e66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.0931517`6.420735778588482", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.0931517`6.420735778588482, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->249367196,ExpressionUUID->"bb8de94c-d625-c74e-856c-eb72714e90aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.0472938`6.126349203953114", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.0472938`6.126349203953114, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->38136149,ExpressionUUID->"d06a1799-ba04-5d4c-99aa-c76a8bbc6bb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.0944632`6.426807646983131", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0.0944632`6.426807646983131, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->36395963,ExpressionUUID->"1600f7ca-cef3-a941-be10-919de2f58be4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->731353014,ExpressionUUID->"114769dd-4516-6c48-84a7-690e8dd53f7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0.0156304`5.645515085755074", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0.0156304`5.645515085755074, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->408173423,ExpressionUUID->"c664a941-1960-ba41-bf42-8828b4ac6f79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.0498149`6.148904256334484", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.0498149`6.148904256334484, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->377949878,ExpressionUUID->"16e7ac64-9204-e746-9b00-76f92fc8a3ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0.1074791`6.482869014611493", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0.1074791`6.482869014611493, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->34040318,ExpressionUUID->"c70aa5b8-a915-534a-a89b-a5cb89e8d4d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->542495057,ExpressionUUID->"7644a4ca-594a-7a4e-a9fd-72c347447990"]
}, Open  ]],

Cell[BoxData["\<\"Type D\"\>"], "Output",
 CellLabel->"Out[9]=",
 CellID->116892313,ExpressionUUID->"901c5f3d-eb72-8d4e-852c-db189ae9a288"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsubsection", "0"},
   Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsubsection", "1"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"d216a939-fe19-7440-82b7-20af9ee9285d"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"983135c6-5cd8-544a-bb96-5509b8464420"],
 "PetrovMatrix",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "e41232f8-48c9-3c48-b14c-aee715fc1803"]
}], "ExampleSubsubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->17838787,ExpressionUUID->"b43b699a-69e3-2842-8132-617617a4a925"],

Cell[TextData[{
 "The ",
 StyleBox["PetrovType", "Input"],
 " function can also determine the Petrov Type of a metric by using the \
Petrov Matrix method. In that case however, it needs an arbitrary observer \
with respect to which compute the Petrov Matrix. Let us first clear the cache:"
}], "ExampleText",
 CellID->487371356,ExpressionUUID->"ee204e81-2718-f54b-85e2-29583acf704e"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[10]:=",
 CellID->132427965,ExpressionUUID->"224c8b30-e524-894c-9e30-904273388906"],

Cell["Now, we define an arbitrary unitary observer:", "ExampleText",
 CellID->461760098,ExpressionUUID->"5d141355-2874-e84a-99ae-da3636ab25ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "mm"}], 
           RowBox[{"r", "[", "]"}]]}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]], ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", "Schw", "}"}]}], "]"}]}], ";"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[11]:=",
 CellID->734009666,ExpressionUUID->"23014108-4b3f-234e-bde4-23676cf122c3"],

Cell["We check that it is indeed timelike and unitary:", "ExampleText",
 CellID->65060658,ExpressionUUID->"cec2a05d-5114-6b4f-94fc-b198da7e52e3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "a", "]"}], 
   RowBox[{"u", "[", 
    RowBox[{"-", "a"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[12]:=",
 CellID->636051244,ExpressionUUID->"9760ac05-2c1c-6e42-89fe-7c029ee907a0"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->"Out[12]=",
 CellID->713918819,ExpressionUUID->"e8443a72-0fc7-ff40-b820-c6c59842a5df"]
}, Open  ]],

Cell[TextData[{
 "and now use the ",
 StyleBox["PetrovType", "Input"],
 " function:"
}], "ExampleText",
 CellID->174738434,ExpressionUUID->"28351ed1-4c70-8647-a381-0291fe14948e"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"TODO", ":", " ", 
   RowBox[{
   "\"\<Observer\>\"", " ", "should", " ", "be", " ", "part", " ", "of", " ", 
    "\"\<PetrovMatrix\>\"", " ", "option"}]}], "*)"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellID->274420143,ExpressionUUID->"767099e4-c2cc-0444-96fc-05b7201a59a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PetrovType", "[", 
  RowBox[{"metric", ",", 
   RowBox[{"Method", "->", " ", "\"\<PetrovMatrix\>\""}], ",", " ", 
   RowBox[{"\"\<Observer\>\"", "->", "u"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[13]:=",
 CellID->416385384,ExpressionUUID->"1b5340eb-18c6-8640-bcca-c8f8f9f6756b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->50629375,ExpressionUUID->"86479d7a-ba93-7a4c-81c3-588038452af8"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->143844544,ExpressionUUID->"a8ba60cf-2f0b-3140-9bdd-94ace041b5ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->149134019,ExpressionUUID->"76be417f-87ab-5740-82a9-1b2a7c22984a"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->935135858,ExpressionUUID->"dc0cf45d-7e8e-5a4c-adb9-1a78a565cf2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->205235292,ExpressionUUID->"7bcc0161-a39f-b147-8872-2a9e278c36ee"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->20759940,ExpressionUUID->"3e732e3c-bfec-af4a-82b8-37e283861721"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->372690847,ExpressionUUID->"0b28e5bc-11fe-b740-86b8-b1a6d3017379"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->328048896,ExpressionUUID->"c269334f-9484-894e-b7b2-099e9d32c18b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->3004571,ExpressionUUID->"fe850369-cfa8-1e41-95f4-73546309dda6"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->81612350,ExpressionUUID->"2fb2b233-66ea-1143-910d-f61375a77242"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->20317740,ExpressionUUID->"e74b2edc-dbe7-ec49-ac25-b4adae41c86c"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->168299045,ExpressionUUID->"43e55ac0-6413-b14b-b3c6-0a61833d2c12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->148826744,ExpressionUUID->"00db777b-b487-304d-87bd-4a2be1ee6bf4"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->207261497,ExpressionUUID->"925d2330-3c0b-d24d-b6aa-6cb8a98ca719"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->61762378,ExpressionUUID->"63eea9ef-8c51-8840-aa7f-c27a53e3ba03"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->50320754,ExpressionUUID->"a7935159-9d04-1645-9a8d-578f20b38b6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->180702699,ExpressionUUID->"9183335d-39e7-5f4c-a5c9-cc62d2d0f2b5"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->44463056,ExpressionUUID->"a648265b-4bed-f445-a142-3c687c404792"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->169424031,ExpressionUUID->"b96893bc-1197-a74e-8f81-861760c5bbe2"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->724839740,ExpressionUUID->"d747e96d-47fb-0d4e-858f-4e9c1c0bacb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->229035032,ExpressionUUID->"8d24ed02-335f-604d-8e78-8a086e99fbe4"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->13118413,ExpressionUUID->"fec3982c-cda4-db44-a775-6406bad5f76c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0.0156619`5.6463894402001475", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0.0156619`5.6463894402001475, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->74950341,ExpressionUUID->"d8a945a7-61ff-ee4c-9641-54e248b5b6e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->448135817,ExpressionUUID->"e3d38849-1edb-ce4e-89a9-09b44d9cf0dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->5247080,ExpressionUUID->"19cd6c90-64ad-8148-8ddd-a084bc96c9af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->65525672,ExpressionUUID->"19dd4279-2701-7a4e-be24-9c1bcbc35108"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylMatrixQ\\\
\" in \"\>", "\[InvisibleSpace]", "0.0156619`5.6463894402001475", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ\" in ", 
   0.0156619`5.6463894402001475, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2548652,ExpressionUUID->"ffe3b1e3-022c-8b42-bd93-1b1a10006389"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->774600174,ExpressionUUID->"c0c4c3e6-65e6-ca47-9413-5f882204804e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"SpatialMetric\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"SpatialMetric\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->20829703,ExpressionUUID->"597c5c29-ff8f-a74f-ae34-8a40a973b58d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"SpatialMetric\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"SpatialMetric\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->548362522,ExpressionUUID->"6cf8835a-9fef-3044-9814-a46dc96576b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ2\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->4289295,ExpressionUUID->"8a404c68-9117-d24a-a518-dcb039f04dc5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ2\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ2\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->26443107,ExpressionUUID->"1d860afe-ed20-0644-9b5b-5cfb5f9c909c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ2\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495968", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ2\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->516795339,ExpressionUUID->"393fe969-19e4-c34e-920e-348000b1072c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ2\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ2\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->59200275,ExpressionUUID->"b6ef6b81-0d3f-ea4f-a0ca-09959009d9a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylMatrixQ3\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->846488578,ExpressionUUID->"2396804f-192a-5c4f-86e3-c1700b82d033"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylMatrixQ3\\\" in \
\"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"WeylMatrixQ3\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->61695691,ExpressionUUID->"4a3692fc-cba5-174b-ac6a-fbfdb453000c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylMatrixQ3\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495968", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylMatrixQ3\" in ", 
   0``7.451544993495968, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->167986428,ExpressionUUID->"dd6f7741-fcd4-9846-823c-f285df6f32c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylMatrixQ3\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495968", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to Weyl concomitant \"TraceWeylMatrixQ3\" in ", 0``7.451544993495968, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->85363181,ExpressionUUID->"b3675659-454f-fd40-aadb-b39e394b4a4a"]
}, Open  ]],

Cell[BoxData["\<\"Type D\"\>"], "Output",
 CellLabel->"Out[13]=",
 CellID->516185056,ExpressionUUID->"d80dda78-ba1b-3f4e-a79a-ee6deace9356"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsubsection", "1"},
   Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "3"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"06bf7fc5-884b-f943-8f17-32c3ada3e8e2"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"b3ee0854-c63d-5e4d-9022-2f86c9141ef5"],
 "PSimplify",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "16758304-2509-3b4d-afc5-feb1b8983d2d"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"127f980c-2fad-f049-9d59-86d6afedb412"],

Cell[TextData[{
 "This option allows us to choose a function that is applied to expressions \
in computations. By default, it coincides with the value of ",
 Cell[BoxData[
  StyleBox["$CVSimplify", "Input"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "2f2b9c89-cb80-2448-bc7a-d4195461aac5"],
 ":"
}], "ExampleText",
 CellID->8693097,ExpressionUUID->"2cb25aeb-6c7e-fc4e-a0bb-17a3a3f4ee1f"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->111291632,ExpressionUUID->"b3b7605c-1482-9e44-98fa-fb83eb406413"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PetrovType", "[", 
  RowBox[{"metric", ",", " ", 
   RowBox[{"PSimplify", "->", "FullSimplify"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->296067258,ExpressionUUID->"75b20b24-6e43-9d45-827c-affe32fd0aaf"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->225525428,ExpressionUUID->"b37b2812-c525-4c4f-a868-8697cd60be3a"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->848391055,ExpressionUUID->"b2afb7e4-db52-0f4d-ab7b-0f73dc47c653"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->33916236,ExpressionUUID->"c6c77bd5-9b53-0044-8aa6-a0c1e9d6cd24"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->191838205,ExpressionUUID->"8a30f039-85c4-6f47-a099-dc2d47f7492b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->619653401,ExpressionUUID->"4d1f584c-504b-3042-bac4-18e051291d45"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->581036793,ExpressionUUID->"8878de53-2712-2844-b9c5-cebc2ca6f86f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->107580814,ExpressionUUID->"a17adf19-ad0e-0946-930c-1be07a405586"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->120777626,ExpressionUUID->"921ed870-9dc4-4441-88a3-455bbabbf15b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->227160012,ExpressionUUID->"89edd9c5-8df0-4f4f-8df5-c1b093eef8c6"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->809168002,ExpressionUUID->"cd90ec7c-61a7-e24f-af5f-e649471484d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->12274597,ExpressionUUID->"0e64d18a-595f-924e-9aca-a0e8a0df36f5"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->5376086,ExpressionUUID->"e04b60f0-5c4a-9a42-acb0-3e9055d57d68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->277214145,ExpressionUUID->"2cf5c7c3-383a-4740-ae03-1f499a4ffdb5"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->242827565,ExpressionUUID->"dab87ff3-218e-6048-aa23-58163442573c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->25769490,ExpressionUUID->"b7d32bf3-7b25-334a-a561-a2af10ab54ba"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->15108577,ExpressionUUID->"1dbfa4ab-d2e9-c74b-b891-47d35e72bdfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->115640967,ExpressionUUID->"7fe10992-f308-2144-9109-9df508954221"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->578680567,ExpressionUUID->"b7c7bd2a-827e-8b43-bb23-0b32e3ab22f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->682329047,ExpressionUUID->"fe88618b-28e9-bb48-a18d-70e079e3f7fc"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->86137381,ExpressionUUID->"ff912bf9-fb9f-3c47-b19e-0c9673c971e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->496896571,ExpressionUUID->"1c1c1309-b86b-4a4b-87ea-e2a872469bc4"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->288548082,ExpressionUUID->"55114cd1-39f1-f440-bb4d-4f3bf58451c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylDual\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylDual\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->551048,ExpressionUUID->"71345ceb-9539-3d40-bc1b-5e453d17a299"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylDual\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0479737`6.132548208472505", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WeylDual\" in ", 0.0479737`6.132548208472505, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->79623905,ExpressionUUID->"2a502736-1cdb-614d-be3d-7dd4f045e276"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"WeylSelfDual\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->506641028,ExpressionUUID->"163d82a6-cdbf-2048-a05c-af20ac90715c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual\\\" in \
\"\>", "\[InvisibleSpace]", "0.1256076`6.550560911067582", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WeylSelfDual\" in ", 0.1256076`6.550560911067582, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->144762672,ExpressionUUID->"a8ebdcc0-23f5-c644-bdcd-4fe6fe7da6d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"G2Form\\\" \
in \"\>", "\[InvisibleSpace]", "0.0157277`5.648210210058092", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"G2Form\" in ", 
   0.0157277`5.648210210058092, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->286253593,ExpressionUUID->"bbe36960-4d34-5746-b54c-3661ccda57bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"G2Form\\\" in \"\>", 
   "\[InvisibleSpace]", "0.0788242`6.348204565210888", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to metric concomitant \"G2Form\" in ", 0.0788242`6.348204565210888, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->328076179,ExpressionUUID->"edba83f9-e70b-4f4d-bdd0-beabb1876690"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual2\
\\\" in \"\>", "\[InvisibleSpace]", "0.0156317`5.64555120507059", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual2\" in ", 
   0.0156317`5.64555120507059, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->350950308,ExpressionUUID->"1a89b816-f744-354c-8e07-96ddb35f3dba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual2\\\" in \"\
\>", "\[InvisibleSpace]", "0.173109`6.689864641086728", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WeylSelfDual2\" in ", 0.173109`6.689864641086728, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->278165138,ExpressionUUID->"ae859f35-9fe9-784f-a84b-4087b1660ae4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual2\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual2\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->268827892,ExpressionUUID->"6cfcca37-1cb9-f147-bfde-c4888bcb6374"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual2\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"TraceWeylSelfDual2\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->383852461,ExpressionUUID->"2b4c7076-1067-da48-8f49-68c92333869f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \\\"WeylSelfDual3\
\\\" in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"WeylSelfDual3\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->72942656,ExpressionUUID->"f2f9d7fd-dc55-e942-ac3d-2e037692e0eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"WeylSelfDual3\\\" in \"\
\>", "\[InvisibleSpace]", "0.1730088`6.689613187342932", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"WeylSelfDual3\" in ", 0.1730088`6.689613187342932, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->247514218,ExpressionUUID->"16dba69d-9ca3-4e4f-83e2-1149cf80508e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing Weyl concomitant \
\\\"TraceWeylSelfDual3\\\" in \"\>", "\[InvisibleSpace]", 
   "0``7.451544993495973", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing Weyl concomitant \"TraceWeylSelfDual3\" in ", 
   0``7.451544993495973, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->488489422,ExpressionUUID->"b2572af5-ab76-ea4d-8dea-a5a165a034d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "FullSimplify", 
   "\[InvisibleSpace]", "\<\" to Weyl concomitant \\\"TraceWeylSelfDual3\\\" \
in \"\>", "\[InvisibleSpace]", "0``7.451544993495973", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", FullSimplify, 
   " to Weyl concomitant \"TraceWeylSelfDual3\" in ", 0``7.451544993495973, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[15]:=",
 CellID->236910826,ExpressionUUID->"5ece5084-c0c9-5045-bca3-25541656cbfc"]
}, Open  ]],

Cell[BoxData["\<\"Type D\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->352341793,ExpressionUUID->"ba0eddc4-a2ba-9845-ac24-6dbee2782223"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "3"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "4"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"8f31cc06-ae27-cd45-82c4-63dc6a23b588"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"1aa63f7f-0000-304d-a479-41cf83ca31d3"],
 "Verbose",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a7d618c6-0ab8-e643-90be-a10a127501cf"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->365788128,ExpressionUUID->"2e8b8971-21d0-814a-89c5-391218bc5bab"],

Cell["\<\
If we do not want to see the printed messages from xIdeal, we need to set \
this option to False:\
\>", "ExampleText",
 CellID->346332891,ExpressionUUID->"24cfbe3a-8eb2-2b4c-81e7-aa148d95301e"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->292193654,ExpressionUUID->"fce60e89-f05c-6b42-a8e7-ea321ac9a0aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PetrovType", "[", 
  RowBox[{"metric", ",", " ", 
   RowBox[{"Verbose", "->", "False"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->47016605,ExpressionUUID->"f6c8bcb2-cd4f-e54a-9330-f44d1930a45e"],

Cell[BoxData["\<\"Type D\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->33233982,ExpressionUUID->"c26ff356-5277-c644-b359-7da41b6d5e55"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "4"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"9a40faa9-1b1c-f64e-8fb1-d2be25f83c4b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"fff45576-4983-044d-8811-a39adaad7965"],
 "Neat Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "08e41895-8883-f044-8f90-b09f171b46f3"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,ExpressionUUID->"246e4bb9-f2cf-bf4a-a898-1f75b3881b05"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "5"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.5800000000000001, 13.020000000000001`}}]],
  ExpressionUUID->"55d067f3-8339-ee46-90ea-746a89e7362b"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"6344c8a9-8ec6-7043-b543-01c5bf211033"],
 "\nRowBox[{\"Type\", \"-\", RowBox[{\"III\", \" \", \"metric\"}]}]",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "4545a3ce-a5ca-2044-9955-d358e17b8612"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->622495240,ExpressionUUID->"c2232f25-7052-c84a-b839-9325e789b738"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Manual", " ", "kernel", " ", "restart", " ", "is", " ", "required", " ", 
   "to", " ", "run", " ", "this", " ", "subsection"}], "*)"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->295466414,ExpressionUUID->"43e9c33a-ba1d-0f40-9d5f-5a6a503779ca"],

Cell["\<\
Let us consider the following metric (see Stephani H, Kramer D, MacCallum M A \
H, Hoenselaers C and Herlt E 2003 Exact Solutions of the Einstein\
\[CloseCurlyQuote]s Field Equation (Cambridge University Press) eqs. (31.34)):\
\>", "ExampleText",
 CellID->307242428,ExpressionUUID->"31f32371-011b-1249-8856-63e113fd6a68"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"TODO", ":", " ", 
   RowBox[{"Add", " ", "reference"}]}], "*)"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->87942249,ExpressionUUID->"01925815-ef9d-4940-ba7f-bfe3f4e49f11"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefChart", "[", 
   RowBox[{"chart", ",", "M", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[ScriptU]", "[", "]"}], ",", 
      RowBox[{"v", "[", "]"}], ",", 
      RowBox[{"x", "[", "]"}], ",", 
      RowBox[{"y", "[", "]"}]}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"DefScalarFunction", "[", 
   RowBox[{"ReW", ",", 
    RowBox[{"PrintAs", "->", "\"\<Re(W)\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefScalarFunction", "[", 
   RowBox[{"ImW", ",", 
    RowBox[{"PrintAs", "->", "\"\<Im(W)\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefScalarFunction", "[", 
   RowBox[{"H", ",", 
    RowBox[{
    "PrintAs", "->", " ", "\"\<\!\(\*SuperscriptBox[\(H\), \(0\)]\)\>\""}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"ReW", "\[Element]", "Reals"}], "&&", 
    RowBox[{"ImW", "\[Element]", "Reals"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metricMatrix", "=", 
   RowBox[{"-", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"v", "[", "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Derivative", "[", 
               RowBox[{"0", ",", "1", ",", "0"}], "]"}], "[", "ReW", "]"}], 
             "[", 
             RowBox[{
              RowBox[{"\[ScriptU]", "[", "]"}], ",", 
              RowBox[{"x", "[", "]"}], ",", 
              RowBox[{"y", "[", "]"}]}], "]"}], "-", 
            RowBox[{
             RowBox[{
              RowBox[{"Derivative", "[", 
               RowBox[{"0", ",", "0", ",", "1"}], "]"}], "[", "ImW", "]"}], 
             "[", 
             RowBox[{
              RowBox[{"\[ScriptU]", "[", "]"}], ",", 
              RowBox[{"x", "[", "]"}], ",", 
              RowBox[{"y", "[", "]"}]}], "]"}]}], ")"}]}], "+", 
         RowBox[{"2", 
          RowBox[{"H", "[", 
           RowBox[{
            RowBox[{"\[ScriptU]", "[", "]"}], ",", 
            RowBox[{"x", "[", "]"}], ",", 
            RowBox[{"y", "[", "]"}]}], "]"}]}]}], ",", "1", ",", 
        RowBox[{"2", 
         RowBox[{"ReW", "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], 
         RowBox[{"ImW", "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"ReW", "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}], ",", "0", ",", 
        RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], 
         RowBox[{"ImW", "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}], ",", "0", ",", "0", ",", 
        RowBox[{"-", "2"}]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"CTensor", "[", 
    RowBox[{"metricMatrix", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "chart"}], ",", 
       RowBox[{"-", "chart"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetCMetric", "[", 
   RowBox[{"metric", ",", "chart", ",", 
    RowBox[{"SignatureOfMetric", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "0"}], "}"}]}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->332248030,ExpressionUUID->"64fcf62a-2c98-b545-86ae-2fce11a08620"],

Cell["In general, it is of Petrov Type III:", "ExampleText",
 CellID->14173559,ExpressionUUID->"a166d2b4-18da-c041-a7e4-d31aa5a7c128"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PetrovType", "[", 
  RowBox[{"metric", ",", " ", 
   RowBox[{"Verbose", "->", "False"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",
 CellID->119349642,ExpressionUUID->"da98675c-267a-b940-938f-1fd9a697afe5"],

Cell[BoxData["\<\"Type III\"\>"], "Output",
 CellLabel->"Out[4]=",
 CellID->341724654,ExpressionUUID->"dc294710-5e6f-c745-852a-457be0f191bb"]
}, Open  ]],

Cell["However, it includes a particular case of Petrov Type N:", "ExampleText",
 CellID->272807690,ExpressionUUID->"730f7cd7-f44a-a040-aa97-8ea6c63ec3a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{"ReW", "\[Element]", "Reals"}], "&&", 
    RowBox[{"ImW", "\[Element]", "Reals"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1", ",", "1"}], "]"}], "[", "ImW", "]"}], "[", 
       RowBox[{
        RowBox[{"\[ScriptU]", "[", "]"}], ",", 
        RowBox[{"x", "[", "]"}], ",", 
        RowBox[{"y", "[", "]"}]}], "]"}], "-", 
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", 
            RowBox[{"0", ",", "2", ",", "0"}], "]"}], "[", "ReW", "]"}], "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", 
            RowBox[{"0", ",", "0", ",", "2"}], "]"}], "[", "ReW", "]"}], "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}], ")"}]}]}], "==", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1", ",", "1"}], "]"}], "[", "ReW", "]"}], "[", 
       RowBox[{
        RowBox[{"\[ScriptU]", "[", "]"}], ",", 
        RowBox[{"x", "[", "]"}], ",", 
        RowBox[{"y", "[", "]"}]}], "]"}], "-", 
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", 
             RowBox[{"0", ",", "2", ",", "0"}], "]"}], "[", "ImW", "]"}], "[", 
           RowBox[{
            RowBox[{"\[ScriptU]", "[", "]"}], ",", 
            RowBox[{"x", "[", "]"}], ",", 
            RowBox[{"y", "[", "]"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", 
            RowBox[{"0", ",", "0", ",", "2"}], "]"}], "[", "ImW", "]"}], "[", 
          RowBox[{
           RowBox[{"\[ScriptU]", "[", "]"}], ",", 
           RowBox[{"x", "[", "]"}], ",", 
           RowBox[{"y", "[", "]"}]}], "]"}]}], ")"}]}]}], "==", "0"}]}]}], 
  ";"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[5]:=",
 CellID->758395483,ExpressionUUID->"3a9584f6-a079-5345-839d-6b0131400b49"],

Cell["\<\
We need to clear the appropriate cache to do the computations again:\
\>", "ExampleText",
 CellID->184310691,ExpressionUUID->"067197ee-1f6c-6246-97d7-8e4044ad5db5"],

Cell[BoxData[
 RowBox[{"ClearxIdealCache", "[", "\"\<WeylConcomitants\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[6]:=",
 CellID->14481688,ExpressionUUID->"7d380b7c-1c37-5445-b335-b254dee90d77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PetrovType", "[", 
  RowBox[{"metric", ",", " ", 
   RowBox[{"Verbose", "->", "False"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[7]:=",
 CellID->171618941,ExpressionUUID->"73289285-1413-f044-879f-c198fdb31ab7"],

Cell[BoxData["\<\"Type N\"\>"], "Output",
 CellLabel->"Out[7]=",
 CellID->371377859,ExpressionUUID->"640e7a16-0295-ab4a-ba99-dcea6509366a"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "5"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[BoxData[GridBox[{
   {
    DynamicBox[FEPrivate`ImportImage[
      FrontEnd`FileName[{"Documentation", "FooterIcons"}, 
       "RelatedFunction.png"]],
     ImageSizeCache->{50., {27., 33.}}], GridBox[{
      {
       StyleBox[
        RowBox[{"See", " ", "Also"}], "SeeAlsoSection"]}
     }]}
  }]], "SeeAlsoSection",ExpressionUUID->"810ba5fa-1ea2-2041-b0bc-\
aa65974c7250"],

Cell[" ", "FooterCell",ExpressionUUID->"46b99f6d-1604-ee40-b0aa-ce0ef8de4dd5"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 765.75},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PetrovType",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {
     "0" -> Open, "1" -> Closed, "2" -> Closed, "3" -> Closed}, 
    "AllOptsTable" -> Closed, "NotesSection" -> Closed, 
    "ExampleSubsection" -> {
     "0" -> Closed, "1" -> Closed, "2" -> Closed, "3" -> Closed, "4" -> 
      Closed, "5" -> Closed}, 
    "ExampleSubsubsection" -> {"0" -> Closed, "1" -> Closed}}, "NewStyles" -> 
  True, "CitationPopupData" -> $Failed, "ShowCitation" -> False, 
  "RootCaptions" -> "", "HeaderCoreAreaLink" -> {}, 
  "Metadata" -> {
   "built" -> "{2024, 5, 22, 16, 32, 52.2905433}", 
    "history" -> {"XX", "", "", ""}, "context" -> "xAct`xIdeal`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "x Ideal Symbol", "language" -> "en", "paclet" -> "xIdeal", "status" -> 
    "None", "summary" -> 
    "PetrovType[metric, opts] returns the Petrov type of metric.", 
    "synonyms" -> {}, "tabletags" -> {}, "title" -> "PetrovType", 
    "titlemodifier" -> "", "metadescription" -> "", "windowtitle" -> 
    "PetrovType", "type" -> "Symbol", "uri" -> "xIdeal/ref/PetrovType", 
    "WorkflowDockedCell" -> ""}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> 
  "14.0 for Microsoft Windows (64-bit) (December 12, 2023)", StyleDefinitions -> 
  "Default.nb"],
ExpressionUUID->"cfbd2ad5-b4ef-7547-bd65-86ee8e47fee1"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9842, 251, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6b0d8679-991d-b243-8859-989fa6576993",
   CellTags->"PrimaryExamplesSection",
   CellID->161879769]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 176125, 4644}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[582, 21, 3278, 77, 57, "AnchorBarGrid",ExpressionUUID->"df1157f3-8d14-bc4d-9505-0f6de17be8fc",
 CellID->1],
Cell[3863, 100, 94, 0, 23, "ContextNameCell",ExpressionUUID->"a8fc0dd2-de89-6342-88d4-55a6fc6cdc4c"],
Cell[CellGroupData[{
Cell[3982, 104, 553, 14, 56, "ObjectNameGrid",ExpressionUUID->"2696c91c-27e9-a94b-a893-afd8720002a3"],
Cell[4538, 120, 468, 10, 89, "Usage",ExpressionUUID->"fd252f38-fda2-5d4f-806d-d1938c47a771",
 CellID->423578463]
}, Open  ]],
Cell[CellGroupData[{
Cell[5043, 135, 1906, 48, 37, "NotesSection",ExpressionUUID->"336a9765-5fa4-9440-8085-0a9649cb16e1",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->59259393],
Cell[6952, 185, 128, 1, 70, "Notes",ExpressionUUID->"a8686e9f-4815-5e40-917c-cfcdb96eb3cc",
 CellID->354734344],
Cell[7083, 188, 2632, 57, 70, "3ColumnTableMod",ExpressionUUID->"32b23f81-6d76-ee41-b041-f65d0d146cfc",
 CellID->55188794]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[9842, 251, 1420, 37, 35, "PrimaryExamplesSection",ExpressionUUID->"6b0d8679-991d-b243-8859-989fa6576993",
 CellTags->"PrimaryExamplesSection",
 CellID->161879769],
Cell[11265, 290, 200, 3, 26, "Input",ExpressionUUID->"3c28868e-892b-394c-a4b2-89e438ee4a5f",
 Evaluatable->True],
Cell[CellGroupData[{
Cell[11490, 297, 1398, 36, 30, "ExampleSection",ExpressionUUID->"01fecb36-4dcb-4d4b-8893-a0959d81ec54",
 CellID->160607604],
Cell[CellGroupData[{
Cell[12913, 337, 1437, 37, 29, "ExampleSubsection",ExpressionUUID->"370365f9-f0da-6543-90e5-23df18a40364",
 CellID->127660352],
Cell[14353, 376, 228, 4, 70, "ExampleText",ExpressionUUID->"448295ce-e6fe-3040-8dd5-353641a32eb3",
 CellID->50967587],
Cell[14584, 382, 397, 10, 70, "Input",ExpressionUUID->"f7d2d7b6-c377-0340-8616-efb8c6e9b886",
 CellID->172691151],
Cell[14984, 394, 2164, 68, 70, "Input",ExpressionUUID->"b1ccd84e-3342-7640-aa0a-325e4fc7669b"],
Cell[17151, 464, 133, 1, 70, "ExampleText",ExpressionUUID->"29a99349-ea5d-ac46-bb95-937e9631740f",
 CellID->257215541],
Cell[CellGroupData[{
Cell[17309, 469, 182, 3, 70, "Input",ExpressionUUID->"e4392ba7-4b92-2843-a07b-36374d48ccb8"],
Cell[CellGroupData[{
Cell[17516, 476, 374, 9, 70, "Print",ExpressionUUID->"3a811eac-b52d-804a-84b9-12cff9c5a1c5",
 CellID->36758870],
Cell[17893, 487, 171, 2, 70, "Print",ExpressionUUID->"cabad5e5-6495-a945-b2a0-575f056bf8b5",
 CellID->542454271],
Cell[18067, 491, 455, 12, 70, "Print",ExpressionUUID->"8aa2db2c-ec38-0c44-9e89-b2748c056b4f",
 CellID->45731199],
Cell[18525, 505, 171, 2, 70, "Print",ExpressionUUID->"bb16cec0-a7b4-b243-9c26-508e75ac6435",
 CellID->557289745],
Cell[18699, 509, 493, 13, 70, "Print",ExpressionUUID->"483831fd-e408-a84e-a87c-797d208b566a",
 CellID->197665391],
Cell[19195, 524, 367, 7, 70, "Print",ExpressionUUID->"60f3c948-10e7-1b45-ab6e-679b3f761b7a",
 CellID->314407021],
Cell[19565, 533, 445, 8, 70, "Print",ExpressionUUID->"5dd04f74-6e89-fa4a-b642-1c707fefe593",
 CellID->100829430],
Cell[20013, 543, 464, 12, 70, "Print",ExpressionUUID->"443d9b05-1116-0049-be36-4c28f3009de9",
 CellID->193228818],
Cell[20480, 557, 171, 2, 70, "Print",ExpressionUUID->"541be4d0-78ed-c140-adc2-f300fb57be9b",
 CellID->141055764],
Cell[20654, 561, 442, 11, 70, "Print",ExpressionUUID->"7b01c936-da12-e04e-ad47-3df7ea8e8da1",
 CellID->267616005],
Cell[21099, 574, 171, 2, 70, "Print",ExpressionUUID->"8efe272c-a84a-3e4d-a65e-3a4efe167489",
 CellID->125999497],
Cell[21273, 578, 327, 7, 70, "Print",ExpressionUUID->"a660f1c4-99b0-fd4c-a88e-4b68e0651dff",
 CellID->395680676],
Cell[21603, 587, 171, 2, 70, "Print",ExpressionUUID->"a4a383aa-9a0d-8748-b469-83e897e34d53",
 CellID->865966132],
Cell[21777, 591, 491, 13, 70, "Print",ExpressionUUID->"7ea47932-ebd3-904c-8e7b-3f59334f14f7",
 CellID->400912798],
Cell[22271, 606, 367, 7, 70, "Print",ExpressionUUID->"e662d7d8-4019-414f-af85-8e7297a48968",
 CellID->477217340],
Cell[22641, 615, 445, 8, 70, "Print",ExpressionUUID->"4fa307c5-6366-754a-ac07-d0496fef871a",
 CellID->277836256],
Cell[23089, 625, 457, 8, 70, "Print",ExpressionUUID->"2cd543e5-94a4-c740-acc3-e3bf2d8c3a5a",
 CellID->408740174],
Cell[23549, 635, 469, 12, 70, "Print",ExpressionUUID->"d91f41bd-4f9d-7841-9298-d58bf73d06ac",
 CellID->223342549],
Cell[24021, 649, 367, 7, 70, "Print",ExpressionUUID->"98a31503-afaa-f44b-a523-a532f38c74f9",
 CellID->579341332],
Cell[24391, 658, 443, 8, 70, "Print",ExpressionUUID->"8cd7a24c-3b1e-d44d-87df-cdb0c71e211a",
 CellID->275936458],
Cell[24837, 668, 457, 8, 70, "Print",ExpressionUUID->"424ae6af-0e70-8241-9a2c-4094e6312c9b",
 CellID->551052386],
Cell[25297, 678, 417, 11, 70, "Print",ExpressionUUID->"729ed562-362e-364a-9568-53f0c93138d9",
 CellID->554628866],
Cell[25717, 691, 367, 7, 70, "Print",ExpressionUUID->"607156c8-670a-a349-adac-ca1c65af7f7f",
 CellID->366350287],
Cell[26087, 700, 445, 8, 70, "Print",ExpressionUUID->"1f9ec3f5-c1a0-f14f-9581-3c75edf3afb3",
 CellID->373924390],
Cell[26535, 710, 453, 8, 70, "Print",ExpressionUUID->"d6f74ccb-0653-4440-ae01-ef06dde34f51",
 CellID->249768020],
Cell[26991, 720, 350, 8, 70, "Print",ExpressionUUID->"a5c592b1-bff3-3d48-a655-59ad9f637691",
 CellID->32080861],
Cell[27344, 730, 366, 7, 70, "Print",ExpressionUUID->"9bd755b9-885a-c34f-beb5-28345db28d33",
 CellID->95668145],
Cell[27713, 739, 440, 8, 70, "Print",ExpressionUUID->"eb422405-7609-8346-b1c7-ee59e67df42e",
 CellID->89755013],
Cell[28156, 749, 450, 8, 70, "Print",ExpressionUUID->"2b93f5bf-7773-e34e-a6a7-5c62a013e26d",
 CellID->51727277],
Cell[28609, 759, 485, 13, 70, "Print",ExpressionUUID->"2e76a6b6-f082-a940-99b6-9f0756d2346f",
 CellID->477881498],
Cell[29097, 774, 365, 7, 70, "Print",ExpressionUUID->"be3c723b-088b-f346-8be4-34d295b6ee51",
 CellID->324159421],
Cell[29465, 783, 445, 8, 70, "Print",ExpressionUUID->"572eadfc-3a7e-3747-b597-a945916b5314",
 CellID->196665839],
Cell[29913, 793, 457, 8, 70, "Print",ExpressionUUID->"17b6cc48-2b62-514a-a0b0-b0b5146c34b9",
 CellID->439990130],
Cell[30373, 803, 501, 10, 70, "Print",ExpressionUUID->"497a88d3-0035-8741-b423-177a94887c54",
 CellID->280313044],
Cell[30877, 815, 602, 13, 70, "Print",ExpressionUUID->"d25c05ea-3add-1144-af63-537dbdc558ee",
 CellID->44859336],
Cell[31482, 830, 494, 10, 70, "Print",ExpressionUUID->"bd8fbd70-e48f-4444-9d3c-60cabe069669",
 CellID->77430255],
Cell[31979, 842, 609, 13, 70, "Print",ExpressionUUID->"527bec55-990b-6845-9ab5-58f0bd6a1a2a",
 CellID->402995305],
Cell[32591, 857, 486, 10, 70, "Print",ExpressionUUID->"2209ff57-bfcc-f947-a14a-aef625d9538a",
 CellID->75259359],
Cell[33080, 869, 605, 13, 70, "Print",ExpressionUUID->"08dd3b65-9878-e24c-8576-ca63479c3b4a",
 CellID->348010637],
Cell[33688, 884, 511, 10, 70, "Print",ExpressionUUID->"eb6ab387-0e56-f740-8c69-8c5122ab02ee",
 CellID->173996492],
Cell[34202, 896, 610, 13, 70, "Print",ExpressionUUID->"2f2eeb0f-1a03-3744-bab8-bfda06049ee5",
 CellID->70886171],
Cell[34815, 911, 547, 11, 70, "Print",ExpressionUUID->"86d08b02-4e21-4549-ade4-6dbe69fcd035",
 CellID->1040856],
Cell[35365, 924, 607, 13, 70, "Print",ExpressionUUID->"a6ecb1a0-50ae-654c-9cac-9ccfe95c06a0",
 CellID->417065052],
Cell[35975, 939, 511, 10, 70, "Print",ExpressionUUID->"975266b5-e5e8-dd44-b6a9-2f5b912ac8ae",
 CellID->686343053],
Cell[36489, 951, 610, 13, 70, "Print",ExpressionUUID->"759c34d7-0aae-4d44-8329-04b2a452f17f",
 CellID->36630883],
Cell[37102, 966, 521, 10, 70, "Print",ExpressionUUID->"ceeb7a30-b950-9b41-87d7-92ef48ea30c0",
 CellID->565183869],
Cell[37626, 978, 607, 13, 70, "Print",ExpressionUUID->"54498170-b0ad-f34d-af5c-32252d7ae13a",
 CellID->447858985]
}, Open  ]],
Cell[38248, 994, 139, 2, 70, "Output",ExpressionUUID->"79aeca75-a8d8-7445-96ee-cfb11423c350",
 CellID->133103006]
}, Open  ]],
Cell[38402, 999, 294, 8, 70, "Input",ExpressionUUID->"c95bfe38-408f-9e48-a409-72624aedd5fd",
 CellID->532150]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[38948, 1017, 1392, 36, 30, "ExampleSection",ExpressionUUID->"cddd1792-72d0-144f-b7b4-1ae463ad06bb"],
Cell[CellGroupData[{
Cell[40365, 1057, 1443, 37, 70, "ExampleSubsection",ExpressionUUID->"e86d4502-323b-6c4a-959b-b0a34cecf470",
 CellID->76226682],
Cell[41811, 1096, 324, 7, 70, "Input",ExpressionUUID->"daedd326-cccc-e04d-8531-8f9d167cb9ae",
 CellID->158258572],
Cell[42138, 1105, 397, 10, 70, "Input",ExpressionUUID->"b48ccde6-3284-904f-b61a-004c36177b8b",
 CellID->539079816],
Cell[42538, 1117, 327, 5, 70, "ExampleText",ExpressionUUID->"a84fb2e0-0344-2b49-9462-e4df198d85fd",
 CellID->46613096],
Cell[42868, 1124, 2568, 78, 70, "Input",ExpressionUUID->"d7398ea3-f98a-7942-9749-6d26f0a6caee"],
Cell[45439, 1204, 127, 1, 70, "ExampleText",ExpressionUUID->"9d39d46c-a163-9c43-9a19-17679abdcdd4",
 CellID->98290569],
Cell[CellGroupData[{
Cell[45591, 1209, 182, 3, 70, "Input",ExpressionUUID->"2424a42f-a1af-9b47-a964-7c4e3ca9c06a"],
Cell[CellGroupData[{
Cell[45798, 1216, 375, 9, 70, "Print",ExpressionUUID->"a267decd-e5fe-874f-a857-9abead5d61e0",
 CellID->439429089],
Cell[46176, 1227, 170, 2, 70, "Print",ExpressionUUID->"1f43acd3-548b-644e-8e8a-fc2975546475",
 CellID->83399039],
Cell[46349, 1231, 456, 12, 70, "Print",ExpressionUUID->"b3a26278-a070-7445-baeb-a266ffd04075",
 CellID->686717446],
Cell[46808, 1245, 169, 2, 70, "Print",ExpressionUUID->"31f81b8d-46b4-e043-957f-4bde7976256e",
 CellID->6460991],
Cell[46980, 1249, 493, 13, 70, "Print",ExpressionUUID->"a3d3cf24-3c0b-674c-bbf7-015bbe364532",
 CellID->152649542],
Cell[47476, 1264, 365, 7, 70, "Print",ExpressionUUID->"933124de-79a6-2144-b301-d5fcdc896b81",
 CellID->277460285],
Cell[47844, 1273, 445, 8, 70, "Print",ExpressionUUID->"e3afe70b-d5a9-3144-8f36-cb8c9a414365",
 CellID->430312814],
Cell[48292, 1283, 464, 12, 70, "Print",ExpressionUUID->"7cd4076c-5894-af43-8d99-ef30a2de424f",
 CellID->340147670],
Cell[48759, 1297, 170, 2, 70, "Print",ExpressionUUID->"c173f57e-822f-694d-a95c-cfd0d1fd8a0d",
 CellID->44715888],
Cell[48932, 1301, 442, 11, 70, "Print",ExpressionUUID->"0b838e43-49e7-f041-bde8-9347f03ac30e",
 CellID->565652185],
Cell[49377, 1314, 170, 2, 70, "Print",ExpressionUUID->"eb4c5eaf-3cf0-c144-933c-8487588eac22",
 CellID->21861524],
Cell[49550, 1318, 327, 7, 70, "Print",ExpressionUUID->"ae98584f-3028-7a41-9c89-6409d8b2ccd7",
 CellID->187798252],
Cell[49880, 1327, 171, 2, 70, "Print",ExpressionUUID->"7b2acc7c-bd15-ca42-8ab4-63de283ab0d5",
 CellID->425194980],
Cell[50054, 1331, 491, 13, 70, "Print",ExpressionUUID->"f7934527-5ad9-704f-96d8-eb70e857095f",
 CellID->313610998],
Cell[50548, 1346, 366, 7, 70, "Print",ExpressionUUID->"0caf334d-7198-984a-b643-a55648aec408",
 CellID->78962131],
Cell[50917, 1355, 443, 8, 70, "Print",ExpressionUUID->"45b03789-f683-b245-92f7-40a175c48a93",
 CellID->6515154],
Cell[51363, 1365, 457, 8, 70, "Print",ExpressionUUID->"1b743e0a-f802-ce48-bba0-d85e6dcb924c",
 CellID->135200560],
Cell[51823, 1375, 465, 12, 70, "Print",ExpressionUUID->"a8dac537-1cf8-d644-bb42-fc0de96c9f50",
 CellID->63148],
Cell[52291, 1389, 367, 7, 70, "Print",ExpressionUUID->"405f328d-6217-e749-a9a0-89472c69423e",
 CellID->209418160],
Cell[52661, 1398, 445, 8, 70, "Print",ExpressionUUID->"4577233b-0178-0549-9a34-3689b2421425",
 CellID->626307160],
Cell[53109, 1408, 457, 8, 70, "Print",ExpressionUUID->"39222411-d0fa-474c-adc1-bdf63a7ffcdf",
 CellID->730606735],
Cell[53569, 1418, 417, 11, 70, "Print",ExpressionUUID->"9920573d-70e8-f247-a72f-8144a92e707d",
 CellID->285943789],
Cell[53989, 1431, 367, 7, 70, "Print",ExpressionUUID->"4d5cb77f-d0b2-c54a-b2e7-f0dd48811df3",
 CellID->671134652],
Cell[54359, 1440, 445, 8, 70, "Print",ExpressionUUID->"08a8e36e-b01f-d442-bafe-fa628022e560",
 CellID->125019452],
Cell[54807, 1450, 453, 8, 70, "Print",ExpressionUUID->"e181cf00-a290-5d4c-b491-1cb8a2c81767",
 CellID->733827319],
Cell[55263, 1460, 351, 8, 70, "Print",ExpressionUUID->"1abc597b-9a85-594b-8d62-0fc1656e4634",
 CellID->624382770],
Cell[55617, 1470, 364, 7, 70, "Print",ExpressionUUID->"3e30580c-038e-b544-8c5c-4edf0d7829a6",
 CellID->17824522],
Cell[55984, 1479, 444, 8, 70, "Print",ExpressionUUID->"3d9a68c2-8a75-264c-a1ae-d077f157e65b",
 CellID->39429224],
Cell[56431, 1489, 451, 8, 70, "Print",ExpressionUUID->"1c98381d-dc14-e64c-b385-66530553dacc",
 CellID->124631426],
Cell[56885, 1499, 485, 13, 70, "Print",ExpressionUUID->"3a43b04d-e34d-dd41-a66a-906978bfd9d4",
 CellID->440032392],
Cell[57373, 1514, 365, 7, 70, "Print",ExpressionUUID->"f68c5bac-6ae9-534f-8bd6-89369af220f4",
 CellID->6230739],
Cell[57741, 1523, 445, 8, 70, "Print",ExpressionUUID->"3d68a385-dc2e-fc4b-9b5a-148503324501",
 CellID->227400439],
Cell[58189, 1533, 457, 8, 70, "Print",ExpressionUUID->"021633aa-6b31-d74b-9ef0-6efae8f6a6c7",
 CellID->228865095],
Cell[58649, 1543, 503, 10, 70, "Print",ExpressionUUID->"ff247395-c88c-2543-a8a6-0bf83922d33f",
 CellID->202121300],
Cell[59155, 1555, 599, 13, 70, "Print",ExpressionUUID->"86cbd86f-893f-874d-b39d-6c81cdee5f34",
 CellID->734404075],
Cell[59757, 1570, 509, 10, 70, "Print",ExpressionUUID->"a1faa753-209f-7d4c-aae8-3810aa220600",
 CellID->220825984],
Cell[60269, 1582, 608, 13, 70, "Print",ExpressionUUID->"0501caae-d35b-684e-9b59-15d8412cdcde",
 CellID->47633791],
Cell[60880, 1597, 486, 10, 70, "Print",ExpressionUUID->"01f51d33-7cbd-354a-b40d-0a4a3828448c",
 CellID->24008194],
Cell[61369, 1609, 600, 13, 70, "Print",ExpressionUUID->"83185cfa-8806-9d4b-ab64-c38e49175f75",
 CellID->69511007],
Cell[61972, 1624, 509, 10, 70, "Print",ExpressionUUID->"1fc95928-6c2b-8044-9925-0e89f1aaa637",
 CellID->171269636],
Cell[62484, 1636, 611, 13, 70, "Print",ExpressionUUID->"2ffffe1a-7a9b-9b47-b115-8b4523d064fe",
 CellID->225601642],
Cell[63098, 1651, 521, 10, 70, "Print",ExpressionUUID->"97f8ad6c-1b0c-d941-a8cc-d8f061dccd58",
 CellID->371050589],
Cell[63622, 1663, 607, 13, 70, "Print",ExpressionUUID->"f2dd383a-1f67-104d-98ac-be2d6a552093",
 CellID->389358143],
Cell[64232, 1678, 510, 10, 70, "Print",ExpressionUUID->"ba721038-89e0-a24d-bdbb-e8060ed72da4",
 CellID->38509784],
Cell[64745, 1690, 607, 13, 70, "Print",ExpressionUUID->"5bbbaa28-bac9-674b-a556-aa1c521a8053",
 CellID->404978493],
Cell[65355, 1705, 521, 10, 70, "Print",ExpressionUUID->"c72252b5-8699-9143-beab-71cd3656ec82",
 CellID->303180542],
Cell[65879, 1717, 606, 13, 70, "Print",ExpressionUUID->"9dbaa98b-62e9-e840-9405-6f43a7c77b49",
 CellID->16034834]
}, Open  ]],
Cell[66500, 1733, 139, 2, 70, "Output",ExpressionUUID->"878d375b-c0d6-344c-9ae1-50961554378d",
 CellID->531771314]
}, Open  ]],
Cell[66654, 1738, 249, 4, 70, "ExampleText",ExpressionUUID->"de04a004-d8c0-2441-8667-ddd79b54db25",
 CellID->383569643],
Cell[66906, 1744, 295, 5, 70, "Input",ExpressionUUID->"87c58e44-7e15-7e4f-947b-f83d91afaa0d"],
Cell[67204, 1751, 598, 15, 70, "Input",ExpressionUUID->"c383a8ea-8150-d84c-b7b5-ee3ab620d614",
 CellID->267828646],
Cell[67805, 1768, 353, 6, 70, "ExampleText",ExpressionUUID->"d44da09c-6ba8-ba4d-b3ef-fbd05b050d33",
 CellID->36750435],
Cell[68161, 1776, 2780, 84, 70, "Input",ExpressionUUID->"8cfae815-74c8-674c-83fe-781dd4d5b79e"],
Cell[70944, 1862, 128, 1, 70, "ExampleText",ExpressionUUID->"4785c1ae-3bdf-c64f-a1b5-e478270a67a9",
 CellID->314375278],
Cell[CellGroupData[{
Cell[71097, 1867, 182, 3, 70, "Input",ExpressionUUID->"86e3acbf-d337-9b4d-8036-a1f89bc4bbb7"],
Cell[CellGroupData[{
Cell[71304, 1874, 375, 9, 70, "Print",ExpressionUUID->"1c99c4ee-4bc7-8944-ae17-4eb4de3c302b",
 CellID->54699648],
Cell[71682, 1885, 171, 2, 70, "Print",ExpressionUUID->"770d4a9a-d669-0448-a131-6903e8e7235e",
 CellID->98611768],
Cell[71856, 1889, 456, 12, 70, "Print",ExpressionUUID->"5c1159a5-7b1b-dd4f-bef1-6f091d2f20f9",
 CellID->59022032],
Cell[72315, 1903, 172, 2, 70, "Print",ExpressionUUID->"314a1a4f-8b97-604c-9b0c-7bfdad7665a4",
 CellID->116465742],
Cell[72490, 1907, 494, 13, 70, "Print",ExpressionUUID->"f629966c-fa41-ad4f-941e-ffe12e6074ec",
 CellID->450919699],
Cell[72987, 1922, 368, 7, 70, "Print",ExpressionUUID->"632e8ac2-3b6b-2742-a3c5-382b7c2507af",
 CellID->170526698],
Cell[73358, 1931, 446, 8, 70, "Print",ExpressionUUID->"a475c4b6-cc04-d547-945b-f36a76244558",
 CellID->171927905],
Cell[73807, 1941, 465, 12, 70, "Print",ExpressionUUID->"210b2dc7-fe07-9b4b-915d-a081eb62b06e",
 CellID->342007586],
Cell[74275, 1955, 172, 2, 70, "Print",ExpressionUUID->"845cd379-57c7-3948-ae8b-ead2b0317e2e",
 CellID->663703864],
Cell[74450, 1959, 443, 11, 70, "Print",ExpressionUUID->"0d25aad2-6a01-764a-ae59-c31580bcbe30",
 CellID->192043008],
Cell[74896, 1972, 171, 2, 70, "Print",ExpressionUUID->"93d0a880-a2cb-2741-b3fb-f4eabc5d31ee",
 CellID->19821274],
Cell[75070, 1976, 328, 7, 70, "Print",ExpressionUUID->"3997287b-d918-8d47-ae6d-0459b198d810",
 CellID->619735940],
Cell[75401, 1985, 172, 2, 70, "Print",ExpressionUUID->"bfbbdfc6-6c52-b44a-8957-b23d6f15245b",
 CellID->155895278],
Cell[75576, 1989, 490, 13, 70, "Print",ExpressionUUID->"3dba1ef6-e288-d046-b539-c7b2511abde9",
 CellID->3856477],
Cell[76069, 2004, 367, 7, 70, "Print",ExpressionUUID->"b75de234-87b3-f743-b636-40749cfec0fb",
 CellID->52719810],
Cell[76439, 2013, 446, 8, 70, "Print",ExpressionUUID->"1f6591ec-8edb-a94e-94f8-488872fc2478",
 CellID->374270265],
Cell[76888, 2023, 458, 8, 70, "Print",ExpressionUUID->"fa14c21d-2f49-7d48-a241-a26b9aa52311",
 CellID->428654040],
Cell[77349, 2033, 469, 12, 70, "Print",ExpressionUUID->"5aee344b-0f0d-9342-b5ce-48850ba03a41",
 CellID->92495796],
Cell[77821, 2047, 368, 7, 70, "Print",ExpressionUUID->"bf58c596-c512-254d-84be-41baa4c0c25a",
 CellID->502149336],
Cell[78192, 2056, 445, 8, 70, "Print",ExpressionUUID->"3eb46218-0d4c-b342-8f14-755b8d67940f",
 CellID->20523092],
Cell[78640, 2066, 458, 8, 70, "Print",ExpressionUUID->"007b4ce9-7aec-7c40-b04d-ea7da94f1b82",
 CellID->200028980],
Cell[79101, 2076, 418, 11, 70, "Print",ExpressionUUID->"20689bfc-263a-8847-839a-7dafcfc58ef2",
 CellID->543430168],
Cell[79522, 2089, 367, 7, 70, "Print",ExpressionUUID->"bc314bfd-7f8e-de46-a9dd-786e0fb30b23",
 CellID->34609275],
Cell[79892, 2098, 445, 8, 70, "Print",ExpressionUUID->"842ba19b-bbb0-1d41-b975-b2aaaa68f2b3",
 CellID->89441627],
Cell[80340, 2108, 455, 8, 70, "Print",ExpressionUUID->"ecbe05a3-2410-f847-9e62-0006cf464655",
 CellID->27811845],
Cell[80798, 2118, 352, 8, 70, "Print",ExpressionUUID->"a99c0e2a-ce5d-af42-83a6-58382131543e",
 CellID->337506462],
Cell[81153, 2128, 368, 7, 70, "Print",ExpressionUUID->"f71220d1-88a7-8d4a-a5cd-29d476651229",
 CellID->440398188],
Cell[81524, 2137, 446, 8, 70, "Print",ExpressionUUID->"73438c58-717a-4447-9d24-d4a94fdf564f",
 CellID->359147706],
Cell[81973, 2147, 454, 8, 70, "Print",ExpressionUUID->"e43e297b-b1f4-764e-a559-053277d9bc8e",
 CellID->752612746],
Cell[82430, 2157, 486, 13, 70, "Print",ExpressionUUID->"356411ec-4920-7845-ae39-0642ab897160",
 CellID->452928495],
Cell[82919, 2172, 366, 7, 70, "Print",ExpressionUUID->"7d375f27-f14f-4144-a861-4dd1492db54a",
 CellID->1266384],
Cell[83288, 2181, 446, 8, 70, "Print",ExpressionUUID->"31e80afd-d407-c34d-a3be-dd2dfd3dba20",
 CellID->568193402],
Cell[83737, 2191, 457, 8, 70, "Print",ExpressionUUID->"5519b4c2-b4b0-384c-bee9-289d0743733f",
 CellID->62106715],
Cell[84197, 2201, 502, 10, 70, "Print",ExpressionUUID->"ad0f3fa8-ce41-dc48-b1c2-67fd08d2c9a5",
 CellID->734246141],
Cell[84702, 2213, 604, 13, 70, "Print",ExpressionUUID->"cbf4ea74-e901-474f-bebd-d76abff64554",
 CellID->460882041],
Cell[85309, 2228, 496, 10, 70, "Print",ExpressionUUID->"e04d3fa4-5454-0744-9d8f-9bfa01483654",
 CellID->391848758],
Cell[85808, 2240, 610, 13, 70, "Print",ExpressionUUID->"0f7f8d2a-28ee-8c4c-9fa2-27ffd45970b0",
 CellID->801250070],
Cell[86421, 2255, 487, 10, 70, "Print",ExpressionUUID->"b6958db8-8347-3648-84d6-0084a668956b",
 CellID->84189710],
Cell[86911, 2267, 601, 13, 70, "Print",ExpressionUUID->"98787b7e-f5e7-7943-950b-7051693775eb",
 CellID->96727752],
Cell[87515, 2282, 513, 10, 70, "Print",ExpressionUUID->"75d023b2-fa32-4f4d-9bba-7f75077d2c28",
 CellID->1010910000],
Cell[88031, 2294, 614, 13, 70, "Print",ExpressionUUID->"4dbd31a8-7848-f14f-8b4c-5a5efa5be241",
 CellID->323502364],
Cell[88648, 2309, 522, 10, 70, "Print",ExpressionUUID->"99dcb87a-561b-1943-8ab4-b48a323c52c1",
 CellID->235743712],
Cell[89173, 2321, 608, 13, 70, "Print",ExpressionUUID->"b6d69f0c-4442-854e-9af9-85fd6775e298",
 CellID->784081525],
Cell[89784, 2336, 512, 10, 70, "Print",ExpressionUUID->"90a27004-9b16-6345-a4a0-9e21ccab2429",
 CellID->608875062],
Cell[90299, 2348, 612, 13, 70, "Print",ExpressionUUID->"d3e45348-2ffe-f842-ab0d-9073da556b40",
 CellID->698153081],
Cell[90914, 2363, 521, 10, 70, "Print",ExpressionUUID->"5991cd29-fcba-2443-ba63-a7282ffdc2f8",
 CellID->19744106],
Cell[91438, 2375, 608, 13, 70, "Print",ExpressionUUID->"a51fb8e2-fca4-f242-bc0b-bd06cfc26d0b",
 CellID->154778797]
}, Open  ]],
Cell[92061, 2391, 140, 2, 70, "Output",ExpressionUUID->"553af455-1825-724c-8e98-7303839e8757",
 CellID->351924309]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, Closed]]]],
Cell[CellGroupData[{
Cell[92465, 2404, 1394, 36, 24, "ExampleSection",ExpressionUUID->"8621b7c4-cc1f-394c-94ee-dc6c7bddb1e7"],
Cell[CellGroupData[{
Cell[93884, 2444, 1455, 36, 70, "ExampleSubsection",ExpressionUUID->"0472748a-946a-7041-a960-456f931ec35d"],
Cell[CellGroupData[{
Cell[95364, 2484, 1413, 37, 70, "ExampleSubsubsection",ExpressionUUID->"143b0fa3-a57f-9347-bdcc-44c985abdfa0",
 CellID->101096468],
Cell[96780, 2523, 301, 6, 70, "Input",ExpressionUUID->"a157d663-a316-3b4c-8bc2-b38cbce47c02",
 CellID->397006184],
Cell[97084, 2531, 211, 4, 70, "ExampleText",ExpressionUUID->"48fa4569-1e51-cd47-af05-11c86aec1702",
 CellID->56015443],
Cell[97298, 2537, 2183, 69, 70, "Input",ExpressionUUID->"39d4f151-b706-df41-a53d-f1f4500cbeed",
 CellID->55503591],
Cell[99484, 2608, 202, 4, 70, "ExampleText",ExpressionUUID->"556fdc57-ab78-794f-b257-8fc759c9508d",
 CellID->353703688],
Cell[CellGroupData[{
Cell[99711, 2616, 278, 6, 70, "Input",ExpressionUUID->"0bc31972-9478-874f-ae29-8816cdb3c53a",
 CellID->16297071],
Cell[CellGroupData[{
Cell[100014, 2626, 375, 9, 70, "Print",ExpressionUUID->"91baa5e9-de1b-4144-9dfe-cf8fe03193b8",
 CellID->494737596],
Cell[100392, 2637, 171, 2, 70, "Print",ExpressionUUID->"991974a1-da74-d249-9c6a-18d6e313b2be",
 CellID->180080164],
Cell[100566, 2641, 456, 12, 70, "Print",ExpressionUUID->"0027d487-a6f4-204d-9ae6-eebef506465d",
 CellID->133340884],
Cell[101025, 2655, 171, 2, 70, "Print",ExpressionUUID->"615f1dbc-fbc1-1449-9029-e854f8064866",
 CellID->440953130],
Cell[101199, 2659, 493, 13, 70, "Print",ExpressionUUID->"95720abc-f1c5-a440-a9eb-d27682a15ff1",
 CellID->780074226],
Cell[101695, 2674, 366, 7, 70, "Print",ExpressionUUID->"06368020-eace-b645-960c-30e8c5755dc9",
 CellID->94782328],
Cell[102064, 2683, 445, 8, 70, "Print",ExpressionUUID->"53cdee64-aea5-f44c-95cd-49819b654949",
 CellID->374068930],
Cell[102512, 2693, 463, 12, 70, "Print",ExpressionUUID->"f6e98f24-d865-8841-8477-10929911dfab",
 CellID->39073586],
Cell[102978, 2707, 170, 2, 70, "Print",ExpressionUUID->"98c7ac21-6bd6-464e-ad28-cb4bce28615a",
 CellID->13580455],
Cell[103151, 2711, 442, 11, 70, "Print",ExpressionUUID->"5bcb7855-9b7b-6242-9acf-629c8f007351",
 CellID->178467582],
Cell[103596, 2724, 170, 2, 70, "Print",ExpressionUUID->"2d1d942c-1c5a-754c-bc08-5175f8427fad",
 CellID->50261718],
Cell[103769, 2728, 327, 7, 70, "Print",ExpressionUUID->"fd93ac6f-ea09-1b42-a002-0d8a171b1c7e",
 CellID->650364275],
Cell[104099, 2737, 170, 2, 70, "Print",ExpressionUUID->"5ae44453-19cf-ac41-9266-43e952b3dfc5",
 CellID->76883460],
Cell[104272, 2741, 490, 13, 70, "Print",ExpressionUUID->"e06b9433-e03b-8d42-8d1c-0714b863e9eb",
 CellID->87512521],
Cell[104765, 2756, 367, 7, 70, "Print",ExpressionUUID->"5b8d8d7c-3d18-6a49-87b1-84eb864cb46b",
 CellID->500978989],
Cell[105135, 2765, 443, 8, 70, "Print",ExpressionUUID->"6db8cf02-b6fb-174a-84f4-68d97f442370",
 CellID->217813219],
Cell[105581, 2775, 457, 8, 70, "Print",ExpressionUUID->"df33157b-5865-2541-8f34-43e254c89754",
 CellID->232605866],
Cell[106041, 2785, 469, 12, 70, "Print",ExpressionUUID->"375dee6e-ff33-b44c-bff5-5e488d54a5f7",
 CellID->226113254],
Cell[106513, 2799, 362, 7, 70, "Print",ExpressionUUID->"aa605c3c-e116-df41-92d3-6024fffa1c9c",
 CellID->843573],
Cell[106878, 2808, 445, 8, 70, "Print",ExpressionUUID->"803f4637-493c-d94f-b2bd-ff9fb022b6a7",
 CellID->790607361],
Cell[107326, 2818, 457, 8, 70, "Print",ExpressionUUID->"6872f71a-9887-b343-96a3-ed28db50a848",
 CellID->937714680],
Cell[107786, 2828, 416, 11, 70, "Print",ExpressionUUID->"e121a29c-8004-744b-90e7-69d0056fe179",
 CellID->10293579],
Cell[108205, 2841, 367, 7, 70, "Print",ExpressionUUID->"dad6016f-6b03-c24b-b9c2-e575170ecb19",
 CellID->654161343],
Cell[108575, 2850, 444, 8, 70, "Print",ExpressionUUID->"8c125549-89dd-1b43-9b39-675d2402d581",
 CellID->53947886],
Cell[109022, 2860, 451, 8, 70, "Print",ExpressionUUID->"29f7fed0-9685-f645-a469-505b90998f2b",
 CellID->492396258],
Cell[109476, 2870, 350, 8, 70, "Print",ExpressionUUID->"e38952aa-873e-8147-a588-78b266bfee4d",
 CellID->13155563],
Cell[109829, 2880, 366, 7, 70, "Print",ExpressionUUID->"2b3c89e3-8fc7-1246-80b5-23380e4c52cb",
 CellID->24930369],
Cell[110198, 2889, 444, 8, 70, "Print",ExpressionUUID->"69611e4f-2166-7843-8e80-a4d3ee029277",
 CellID->72668728],
Cell[110645, 2899, 451, 8, 70, "Print",ExpressionUUID->"98179dff-94d2-b548-9eab-ee6555b92fa0",
 CellID->503137211],
Cell[111099, 2909, 484, 13, 70, "Print",ExpressionUUID->"b0166dc0-0dd9-d042-8a11-470ee141e6c6",
 CellID->18018325],
Cell[111586, 2924, 367, 7, 70, "Print",ExpressionUUID->"630e9053-3855-1144-849d-f8d89ff2deb5",
 CellID->263529995],
Cell[111956, 2933, 441, 8, 70, "Print",ExpressionUUID->"0263c637-92f8-6142-b8bc-0c3595e0252d",
 CellID->702035631],
Cell[112400, 2943, 457, 8, 70, "Print",ExpressionUUID->"b55be37f-5b38-4c49-94c0-d7514a20db29",
 CellID->141502553],
Cell[112860, 2953, 502, 10, 70, "Print",ExpressionUUID->"8baff00b-7562-b449-a72b-475956e7f8e6",
 CellID->86874292],
Cell[113365, 2965, 603, 13, 70, "Print",ExpressionUUID->"82b05650-9355-b14e-bcae-1da616233517",
 CellID->571061288],
Cell[113971, 2980, 494, 10, 70, "Print",ExpressionUUID->"8abdf494-4838-4848-9463-c87bead1486f",
 CellID->58042308],
Cell[114468, 2992, 609, 13, 70, "Print",ExpressionUUID->"9862bd64-8541-5f49-bdd8-d40ef1e1152e",
 CellID->315257790],
Cell[115080, 3007, 487, 10, 70, "Print",ExpressionUUID->"14602103-db83-c241-aea1-0d7a14eabc7f",
 CellID->120443633],
Cell[115570, 3019, 605, 13, 70, "Print",ExpressionUUID->"5d9421fb-52d7-3b4a-b905-b7e99ccb4e66",
 CellID->723801734],
Cell[116178, 3034, 511, 10, 70, "Print",ExpressionUUID->"bb8de94c-d625-c74e-856c-eb72714e90aa",
 CellID->249367196],
Cell[116692, 3046, 610, 13, 70, "Print",ExpressionUUID->"d06a1799-ba04-5d4c-99aa-c76a8bbc6bb0",
 CellID->38136149],
Cell[117305, 3061, 520, 10, 70, "Print",ExpressionUUID->"1600f7ca-cef3-a941-be10-919de2f58be4",
 CellID->36395963],
Cell[117828, 3073, 607, 13, 70, "Print",ExpressionUUID->"114769dd-4516-6c48-84a7-690e8dd53f7f",
 CellID->731353014],
Cell[118438, 3088, 511, 10, 70, "Print",ExpressionUUID->"c664a941-1960-ba41-bf42-8828b4ac6f79",
 CellID->408173423],
Cell[118952, 3100, 611, 13, 70, "Print",ExpressionUUID->"16e7ac64-9204-e746-9b00-76f92fc8a3ca",
 CellID->377949878],
Cell[119566, 3115, 520, 10, 70, "Print",ExpressionUUID->"c70aa5b8-a915-534a-a89b-a5cb89e8d4d1",
 CellID->34040318],
Cell[120089, 3127, 607, 13, 70, "Print",ExpressionUUID->"7644a4ca-594a-7a4e-a9fd-72c347447990",
 CellID->542495057]
}, Open  ]],
Cell[120711, 3143, 139, 2, 70, "Output",ExpressionUUID->"901c5f3d-eb72-8d4e-852c-db189ae9a288",
 CellID->116892313]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsubsection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[121005, 3153, 1412, 37, 70, "ExampleSubsubsection",ExpressionUUID->"b43b699a-69e3-2842-8132-617617a4a925",
 CellID->17838787],
Cell[122420, 3192, 383, 7, 70, "ExampleText",ExpressionUUID->"ee204e81-2718-f54b-85e2-29583acf704e",
 CellID->487371356],
Cell[122806, 3201, 227, 4, 70, "Input",ExpressionUUID->"224c8b30-e524-894c-9e30-904273388906",
 CellID->132427965],
Cell[123036, 3207, 143, 1, 70, "ExampleText",ExpressionUUID->"5d141355-2874-e84a-99ae-da3636ab25ab",
 CellID->461760098],
Cell[123182, 3210, 602, 19, 70, "Input",ExpressionUUID->"23014108-4b3f-234e-bde4-23676cf122c3",
 CellID->734009666],
Cell[123787, 3231, 145, 1, 70, "ExampleText",ExpressionUUID->"cec2a05d-5114-6b4f-94fc-b198da7e52e3",
 CellID->65060658],
Cell[CellGroupData[{
Cell[123957, 3236, 288, 8, 70, "Input",ExpressionUUID->"9760ac05-2c1c-6e42-89fe-7c029ee907a0",
 CellID->636051244],
Cell[124248, 3246, 144, 3, 70, "Output",ExpressionUUID->"e8443a72-0fc7-ff40-b820-c6c59842a5df",
 CellID->713918819]
}, Open  ]],
Cell[124407, 3252, 178, 5, 70, "ExampleText",ExpressionUUID->"28351ed1-4c70-8647-a381-0291fe14948e",
 CellID->174738434],
Cell[124588, 3259, 325, 7, 70, "Input",ExpressionUUID->"767099e4-c2cc-0444-96fc-05b7201a59a4",
 CellID->274420143],
Cell[CellGroupData[{
Cell[124938, 3270, 335, 7, 70, "Input",ExpressionUUID->"1b5340eb-18c6-8640-bcca-c8f8f9f6756b",
 CellID->416385384],
Cell[CellGroupData[{
Cell[125298, 3281, 375, 9, 70, "Print",ExpressionUUID->"86479d7a-ba93-7a4c-81c3-588038452af8",
 CellID->50629375],
Cell[125676, 3292, 172, 2, 70, "Print",ExpressionUUID->"a8ba60cf-2f0b-3140-9bdd-94ace041b5ae",
 CellID->143844544],
Cell[125851, 3296, 457, 12, 70, "Print",ExpressionUUID->"76be417f-87ab-5740-82a9-1b2a7c22984a",
 CellID->149134019],
Cell[126311, 3310, 172, 2, 70, "Print",ExpressionUUID->"dc0cf45d-7e8e-5a4c-adb9-1a78a565cf2b",
 CellID->935135858],
Cell[126486, 3314, 494, 13, 70, "Print",ExpressionUUID->"7bcc0161-a39f-b147-8872-2a9e278c36ee",
 CellID->205235292],
Cell[126983, 3329, 171, 2, 70, "Print",ExpressionUUID->"3e732e3c-bfec-af4a-82b8-37e283861721",
 CellID->20759940],
Cell[127157, 3333, 465, 12, 70, "Print",ExpressionUUID->"0b28e5bc-11fe-b740-86b8-b1a6d3017379",
 CellID->372690847],
Cell[127625, 3347, 172, 2, 70, "Print",ExpressionUUID->"c269334f-9484-894e-b7b2-099e9d32c18b",
 CellID->328048896],
Cell[127800, 3351, 441, 11, 70, "Print",ExpressionUUID->"fe850369-cfa8-1e41-95f4-73546309dda6",
 CellID->3004571],
Cell[128244, 3364, 171, 2, 70, "Print",ExpressionUUID->"2fb2b233-66ea-1143-910d-f61375a77242",
 CellID->81612350],
Cell[128418, 3368, 327, 7, 70, "Print",ExpressionUUID->"e74b2edc-dbe7-ec49-ac25-b4adae41c86c",
 CellID->20317740],
Cell[128748, 3377, 172, 2, 70, "Print",ExpressionUUID->"43e55ac0-6413-b14b-b3c6-0a61833d2c12",
 CellID->168299045],
Cell[128923, 3381, 492, 13, 70, "Print",ExpressionUUID->"00db777b-b487-304d-87bd-4a2be1ee6bf4",
 CellID->148826744],
Cell[129418, 3396, 172, 2, 70, "Print",ExpressionUUID->"925d2330-3c0b-d24d-b6aa-6cb8a98ca719",
 CellID->207261497],
Cell[129593, 3400, 469, 12, 70, "Print",ExpressionUUID->"63eea9ef-8c51-8840-aa7f-c27a53e3ba03",
 CellID->61762378],
Cell[130065, 3414, 171, 2, 70, "Print",ExpressionUUID->"a7935159-9d04-1645-9a8d-578f20b38b6e",
 CellID->50320754],
Cell[130239, 3418, 418, 11, 70, "Print",ExpressionUUID->"9183335d-39e7-5f4c-a5c9-cc62d2d0f2b5",
 CellID->180702699],
Cell[130660, 3431, 171, 2, 70, "Print",ExpressionUUID->"a648265b-4bed-f445-a142-3c687c404792",
 CellID->44463056],
Cell[130834, 3435, 352, 8, 70, "Print",ExpressionUUID->"b96893bc-1197-a74e-8f81-861760c5bbe2",
 CellID->169424031],
Cell[131189, 3445, 172, 2, 70, "Print",ExpressionUUID->"d747e96d-47fb-0d4e-858f-4e9c1c0bacb2",
 CellID->724839740],
Cell[131364, 3449, 486, 13, 70, "Print",ExpressionUUID->"8d24ed02-335f-604d-8e78-8a086e99fbe4",
 CellID->229035032],
Cell[131853, 3464, 171, 2, 70, "Print",ExpressionUUID->"fec3982c-cda4-db44-a775-6406bad5f76c",
 CellID->13118413],
Cell[132027, 3468, 503, 10, 70, "Print",ExpressionUUID->"d8a945a7-61ff-ee4c-9641-54e248b5b6e4",
 CellID->74950341],
Cell[132533, 3480, 586, 12, 70, "Print",ExpressionUUID->"e3d38849-1edb-ce4e-89a9-09b44d9cf0dc",
 CellID->448135817],
Cell[133122, 3494, 494, 10, 70, "Print",ExpressionUUID->"19cd6c90-64ad-8148-8ddd-a084bc96c9af",
 CellID->5247080],
Cell[133619, 3506, 595, 13, 70, "Print",ExpressionUUID->"19dd4279-2701-7a4e-be24-9c1bcbc35108",
 CellID->65525672],
Cell[134217, 3521, 508, 10, 70, "Print",ExpressionUUID->"ffe3b1e3-022c-8b42-bd93-1b1a10006389",
 CellID->2548652],
Cell[134728, 3533, 594, 13, 70, "Print",ExpressionUUID->"c0c4c3e6-65e6-ca47-9413-5f882204804e",
 CellID->774600174],
Cell[135325, 3548, 501, 10, 70, "Print",ExpressionUUID->"597c5c29-ff8f-a74f-ae34-8a40a973b58d",
 CellID->20829703],
Cell[135829, 3560, 602, 13, 70, "Print",ExpressionUUID->"6cf8835a-9fef-3044-9814-a46dc96576b7",
 CellID->548362522],
Cell[136434, 3575, 494, 10, 70, "Print",ExpressionUUID->"8a404c68-9117-d24a-a518-dcb039f04dc5",
 CellID->4289295],
Cell[136931, 3587, 595, 13, 70, "Print",ExpressionUUID->"1d860afe-ed20-0644-9b5b-5cfb5f9c909c",
 CellID->26443107],
Cell[137529, 3602, 506, 10, 70, "Print",ExpressionUUID->"393fe969-19e4-c34e-920e-348000b1072c",
 CellID->516795339],
Cell[138038, 3614, 605, 13, 70, "Print",ExpressionUUID->"b6ef6b81-0d3f-ea4f-a0ca-09959009d9a6",
 CellID->59200275],
Cell[138646, 3629, 496, 10, 70, "Print",ExpressionUUID->"2396804f-192a-5c4f-86e3-c1700b82d033",
 CellID->846488578],
Cell[139145, 3641, 595, 13, 70, "Print",ExpressionUUID->"4a3692fc-cba5-174b-ac6a-fbfdb453000c",
 CellID->61695691],
Cell[139743, 3656, 506, 10, 70, "Print",ExpressionUUID->"dd6f7741-fcd4-9846-823c-f285df6f32c9",
 CellID->167986428],
Cell[140252, 3668, 605, 13, 70, "Print",ExpressionUUID->"b3675659-454f-fd40-aadb-b39e394b4a4a",
 CellID->85363181]
}, Open  ]],
Cell[140872, 3684, 140, 2, 70, "Output",ExpressionUUID->"d80dda78-ba1b-3f4e-a79a-ee6deace9356",
 CellID->516185056]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsubsection", "1"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed]]]],
Cell[CellGroupData[{
Cell[141282, 3697, 1405, 36, 70, "ExampleSubsection",ExpressionUUID->"127f980c-2fad-f049-9d59-86d6afedb412"],
Cell[142690, 3735, 414, 9, 70, "ExampleText",ExpressionUUID->"2cb25aeb-6c7e-fc4e-a0bb-17a3a3f4ee1f",
 CellID->8693097],
Cell[143107, 3746, 226, 4, 70, "Input",ExpressionUUID->"b3b7605c-1482-9e44-98fa-fb83eb406413",
 CellID->111291632],
Cell[CellGroupData[{
Cell[143358, 3754, 274, 6, 70, "Input",ExpressionUUID->"75b20b24-6e43-9d45-827c-affe32fd0aaf",
 CellID->296067258],
Cell[CellGroupData[{
Cell[143657, 3764, 376, 9, 70, "Print",ExpressionUUID->"b37b2812-c525-4c4f-a868-8697cd60be3a",
 CellID->225525428],
Cell[144036, 3775, 172, 2, 70, "Print",ExpressionUUID->"b2afb7e4-db52-0f4d-ab7b-0f73dc47c653",
 CellID->848391055],
Cell[144211, 3779, 456, 12, 70, "Print",ExpressionUUID->"c6c77bd5-9b53-0044-8aa6-a0c1e9d6cd24",
 CellID->33916236],
Cell[144670, 3793, 172, 2, 70, "Print",ExpressionUUID->"8a30f039-85c4-6f47-a099-dc2d47f7492b",
 CellID->191838205],
Cell[144845, 3797, 494, 13, 70, "Print",ExpressionUUID->"4d1f584c-504b-3042-bac4-18e051291d45",
 CellID->619653401],
Cell[145342, 3812, 172, 2, 70, "Print",ExpressionUUID->"8878de53-2712-2844-b9c5-cebc2ca6f86f",
 CellID->581036793],
Cell[145517, 3816, 465, 12, 70, "Print",ExpressionUUID->"a17adf19-ad0e-0946-930c-1be07a405586",
 CellID->107580814],
Cell[145985, 3830, 172, 2, 70, "Print",ExpressionUUID->"921ed870-9dc4-4441-88a3-455bbabbf15b",
 CellID->120777626],
Cell[146160, 3834, 443, 11, 70, "Print",ExpressionUUID->"89edd9c5-8df0-4f4f-8df5-c1b093eef8c6",
 CellID->227160012],
Cell[146606, 3847, 172, 2, 70, "Print",ExpressionUUID->"cd90ec7c-61a7-e24f-af5f-e649471484d9",
 CellID->809168002],
Cell[146781, 3851, 327, 7, 70, "Print",ExpressionUUID->"0e64d18a-595f-924e-9aca-a0e8a0df36f5",
 CellID->12274597],
Cell[147111, 3860, 170, 2, 70, "Print",ExpressionUUID->"e04b60f0-5c4a-9a42-acb0-3e9055d57d68",
 CellID->5376086],
Cell[147284, 3864, 492, 13, 70, "Print",ExpressionUUID->"2cf5c7c3-383a-4740-ae03-1f499a4ffdb5",
 CellID->277214145],
Cell[147779, 3879, 172, 2, 70, "Print",ExpressionUUID->"dab87ff3-218e-6048-aa23-58163442573c",
 CellID->242827565],
Cell[147954, 3883, 469, 12, 70, "Print",ExpressionUUID->"b7d32bf3-7b25-334a-a561-a2af10ab54ba",
 CellID->25769490],
Cell[148426, 3897, 171, 2, 70, "Print",ExpressionUUID->"1dbfa4ab-d2e9-c74b-b891-47d35e72bdfc",
 CellID->15108577],
Cell[148600, 3901, 418, 11, 70, "Print",ExpressionUUID->"7fe10992-f308-2144-9109-9df508954221",
 CellID->115640967],
Cell[149021, 3914, 172, 2, 70, "Print",ExpressionUUID->"b7c7bd2a-827e-8b43-bb23-0b32e3ab22f0",
 CellID->578680567],
Cell[149196, 3918, 352, 8, 70, "Print",ExpressionUUID->"fe88618b-28e9-bb48-a18d-70e079e3f7fc",
 CellID->682329047],
Cell[149551, 3928, 171, 2, 70, "Print",ExpressionUUID->"ff912bf9-fb9f-3c47-b19e-0c9673c971e6",
 CellID->86137381],
Cell[149725, 3932, 486, 13, 70, "Print",ExpressionUUID->"1c1c1309-b86b-4a4b-87ea-e2a872469bc4",
 CellID->496896571],
Cell[150214, 3947, 172, 2, 70, "Print",ExpressionUUID->"55114cd1-39f1-f440-bb4d-4f3bf58451c9",
 CellID->288548082],
Cell[150389, 3951, 485, 10, 70, "Print",ExpressionUUID->"71345ceb-9539-3d40-bc1b-5e453d17a299",
 CellID->551048],
Cell[150877, 3963, 611, 13, 70, "Print",ExpressionUUID->"2a502736-1cdb-614d-be3d-7dd4f045e276",
 CellID->79623905],
Cell[151491, 3978, 496, 10, 70, "Print",ExpressionUUID->"163d82a6-cdbf-2048-a05c-af20ac90715c",
 CellID->506641028],
Cell[151990, 3990, 618, 13, 70, "Print",ExpressionUUID->"a8ebdcc0-23f5-c644-bdcd-4fe6fe7da6d5",
 CellID->144762672],
Cell[152611, 4005, 502, 10, 70, "Print",ExpressionUUID->"bbe36960-4d34-5746-b54c-3661ccda57bf",
 CellID->286253593],
Cell[153116, 4017, 612, 13, 70, "Print",ExpressionUUID->"edba83f9-e70b-4f4d-bdd0-beabb1876690",
 CellID->328076179],
Cell[153731, 4032, 510, 10, 70, "Print",ExpressionUUID->"1a89b816-f744-354c-8e07-96ddb35f3dba",
 CellID->350950308],
Cell[154244, 4044, 618, 13, 70, "Print",ExpressionUUID->"ae859f35-9fe9-784f-a84b-4087b1660ae4",
 CellID->278165138],
Cell[154865, 4059, 508, 10, 70, "Print",ExpressionUUID->"6cfcca37-1cb9-f147-bfde-c4888bcb6374",
 CellID->268827892],
Cell[155376, 4071, 616, 13, 70, "Print",ExpressionUUID->"2b4c7076-1067-da48-8f49-68c92333869f",
 CellID->383852461],
Cell[155995, 4086, 497, 10, 70, "Print",ExpressionUUID->"f2f9d7fd-dc55-e942-ac3d-2e037692e0eb",
 CellID->72942656],
Cell[156495, 4098, 620, 13, 70, "Print",ExpressionUUID->"16dba69d-9ca3-4e4f-83e2-1149cf80508e",
 CellID->247514218],
Cell[157118, 4113, 508, 10, 70, "Print",ExpressionUUID->"b2572af5-ab76-ea4d-8dea-a5a165a034d3",
 CellID->488489422],
Cell[157629, 4125, 616, 13, 70, "Print",ExpressionUUID->"5ece5084-c0c9-5045-bca3-25541656cbfc",
 CellID->236910826]
}, Open  ]],
Cell[158260, 4141, 139, 2, 70, "Output",ExpressionUUID->"ba0eddc4-a2ba-9845-ac24-6dbee2782223",
 CellID->352341793]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "3"}, Closed]]]],
Cell[CellGroupData[{
Cell[158551, 4151, 1423, 37, 70, "ExampleSubsection",ExpressionUUID->"2e8b8971-21d0-814a-89c5-391218bc5bab",
 CellID->365788128],
Cell[159977, 4190, 203, 4, 70, "ExampleText",ExpressionUUID->"24cfbe3a-8eb2-2b4c-81e7-aa148d95301e",
 CellID->346332891],
Cell[160183, 4196, 226, 4, 70, "Input",ExpressionUUID->"fce60e89-f05c-6b42-a8e7-ea321ac9a0aa",
 CellID->292193654],
Cell[CellGroupData[{
Cell[160434, 4204, 264, 6, 70, "Input",ExpressionUUID->"f6c8bcb2-cd4f-e54a-9330-f44d1930a45e",
 CellID->47016605],
Cell[160701, 4212, 138, 2, 70, "Output",ExpressionUUID->"c26ff356-5277-c644-b359-7da41b6d5e55",
 CellID->33233982]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "4"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "2"}, Closed]]]],
Cell[CellGroupData[{
Cell[161103, 4225, 1400, 36, 24, "ExampleSection",ExpressionUUID->"246e4bb9-f2cf-bf4a-a898-1f75b3881b05"],
Cell[CellGroupData[{
Cell[162528, 4265, 1481, 37, 70, "ExampleSubsection",ExpressionUUID->"c2232f25-7052-c84a-b839-9325e789b738",
 CellID->622495240],
Cell[164012, 4304, 324, 7, 70, "Input",ExpressionUUID->"43e9c33a-ba1d-0f40-9d5f-5a6a503779ca",
 CellID->295466414],
Cell[164339, 4313, 331, 5, 70, "ExampleText",ExpressionUUID->"31f32371-011b-1249-8856-63e113fd6a68",
 CellID->307242428],
Cell[164673, 4320, 249, 6, 70, "Input",ExpressionUUID->"01925815-ef9d-4940-ba7f-bfe3f4e49f11",
 CellID->87942249],
Cell[164925, 4328, 4133, 120, 70, "Input",ExpressionUUID->"64fcf62a-2c98-b545-86ae-2fce11a08620",
 CellID->332248030],
Cell[169061, 4450, 134, 1, 70, "ExampleText",ExpressionUUID->"a166d2b4-18da-c041-a7e4-d31aa5a7c128",
 CellID->14173559],
Cell[CellGroupData[{
Cell[169220, 4455, 265, 6, 70, "Input",ExpressionUUID->"da98675c-267a-b940-938f-1fd9a697afe5",
 CellID->119349642],
Cell[169488, 4463, 141, 2, 70, "Output",ExpressionUUID->"dc294710-5e6f-c745-852a-457be0f191bb",
 CellID->341724654]
}, Open  ]],
Cell[169644, 4468, 154, 1, 70, "ExampleText",ExpressionUUID->"730f7cd7-f44a-a040-aa97-8ea6c63ec3a6",
 CellID->272807690],
Cell[169801, 4471, 2489, 70, 70, "Input",ExpressionUUID->"3a9584f6-a079-5345-839d-6b0131400b49",
 CellID->758395483],
Cell[172293, 4543, 174, 3, 70, "ExampleText",ExpressionUUID->"067197ee-1f6c-6246-97d7-8e4044ad5db5",
 CellID->184310691],
Cell[172470, 4548, 225, 4, 70, "Input",ExpressionUUID->"7d380b7c-1c37-5445-b335-b254dee90d77",
 CellID->14481688],
Cell[CellGroupData[{
Cell[172720, 4556, 265, 6, 70, "Input",ExpressionUUID->"73289285-1413-f044-879f-c198fdb31ab7",
 CellID->171618941],
Cell[172988, 4564, 139, 2, 70, "Output",ExpressionUUID->"640e7a16-0295-ab4a-ba99-dcea6509366a",
 CellID->371377859]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "5"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "3"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[173484, 4578, 380, 11, 114, "SeeAlsoSection",ExpressionUUID->"810ba5fa-1ea2-2041-b0bc-aa65974c7250"],
Cell[173867, 4591, 78, 0, 25, "FooterCell",ExpressionUUID->"46b99f6d-1604-ee40-b0aa-ce0ef8de4dd5"]
}
]
*)

(* End of internal cache information *)

