(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    281717,       7437]
NotebookOptionsPosition[    231369,       6471]
NotebookOutlinePosition[    234217,       6531]
CellTagsIndexPosition[    234130,       6526]
WindowTitle->xActSolutionData
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {GridBox[{
      {
       ItemBox[Cell[BoxData[
         RowBox[{
          TemplateBox[{12},
           "Spacer1"], Cell["X IDEAL SYMBOL", "PacletNameCell",
           TextAlignment->Center,ExpressionUUID->
           "2552c5c3-9767-44d1-bdd6-cada0bfebbca"], 
          TemplateBox[{8},
           "Spacer1"]}]],
         TextAlignment->Center,ExpressionUUID->
         "28f22d1f-f055-4f71-ae78-1eee0be8e6ad"],
        Background->LightDarkSwitched[
          RGBColor[0.490196, 0.576471, 0.690196]],
        ItemSize->Full], ""}
     },
     GridBoxAlignment->{"Rows" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {Full, 
         Scaled[0.02]}, "Rows" -> {{2.5}}}], Cell[TextData[Cell[BoxData[
     TagBox[
      ActionMenuBox[
       FrameBox[Cell[TextData[{
         "URL",
         " ",
         Cell[BoxData[
          GraphicsBox[
           {GrayLevel[0.66667], Thickness[0.13], 
            LineBox[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]},
           AspectRatio->1,
           ImageSize->20,
           PlotRange->{{-3, 4}, {-1, 1}}]],ExpressionUUID->
          "ed27a917-9cd3-4289-b8a7-8916986d8c15"]
        }],ExpressionUUID->"6786c304-c95b-42cc-86de-d1176158bd6c"],
        StripOnInput->False],{
       "\"xIdeal/ref/xActSolutionData\"" :> None, 
        "\"Copy Wolfram Documentation Center URL\"" :> 
        CopyToClipboard["xIdeal/ref/xActSolutionData"], Delimiter, 
        "\"Copy web URL\"" :> 
        Module[{DocumentationSearch`Private`nb$}, 
          DocumentationSearch`Private`nb$ = 
           NotebookPut[
            Notebook[{
              Cell[BoxData[
                MakeBoxes[
                 Hyperlink[
                  "http://reference.wolfram.com/language/xIdeal/ref/\
xActSolutionData.html"], StandardForm]], "Input", TextClipboardType -> 
                "PlainText"]}, Visible -> False]]; 
          SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
          FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
          NotebookClose[DocumentationSearch`Private`nb$]; Null], 
        "\"Go to web URL\"" :> 
        FrontEndExecute[{
          NotebookLocate[{
            URL[(If[TrueQ[False], 
                 "http://reference.wolfram.com/system-modeler/", 
                 "http://reference.wolfram.com/language/"] <> 
               "xIdeal/ref/xActSolutionData") <> ".html"], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"URLMenu"],
      MouseAppearanceTag["LinkHand"]]],
     LineSpacing->{1.4, 0},ExpressionUUID->
     "436b83e4-298a-4b42-bdb7-5640197b4b5e"]], "AnchorBar",
     CacheGraphics->False,ExpressionUUID->
     "84a705f7-24df-4749-88fc-30bc9428e5f0"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1,ExpressionUUID->"430fd6ad-bd5b-4ebc-abaa-a3933b1a7eda"],

Cell["xAct`xIdeal`", "ContextNameCell",ExpressionUUID->"bb9ab4dd-30de-46a2-9595-6ab7fd9926ce"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[
     "xActSolutionData", "ObjectName",ExpressionUUID->
      "b8eff4f9-6abd-45f4-a6a1-7dc1b4f3fccb"],
     Cell[BoxData[
      TemplateBox[{8},
       "Spacer1"]],ExpressionUUID->"9988cab1-e165-4f9d-a47e-d0b79b9e7479"],
     Cell[BoxData[
     ""], "ObjectNameTranslation",ExpressionUUID->
      "e595bdc4-94da-4fef-b1a6-188676a85c18"]
    }],ExpressionUUID->"8f9ff24e-1619-416a-82cc-02cbb56ba0f6"], 
    "\[SpanFromLeft]"}
  }]], "ObjectNameGrid",ExpressionUUID->"cab40871-3414-4584-9e31-\
77ce593cb031"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"xActSolutionData", "[", "args", "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "9ed0c4cd-7476-4df7-b0c8-a0670be4608c"],
     "  returns information about an the exact solution as queried by ",
     Cell[BoxData[
      RowBox[{"args", " "}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "6d9c2f2a-4d3c-4152-a611-7abea979420a"],
     "."
    }],ExpressionUUID->"df96288a-5d4a-4462-bfda-fcc60b800c0e"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"xActSolutionData", " ", "[", "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "74a4fd95-f166-4d72-b5a6-129239e994c8"],
     "\[LineSeparator]gives the list of all exact solutions available for \
querying."
    }],ExpressionUUID->"701618d1-ac0d-413d-b362-ec54288a34b1"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"xActSolutionData", " ", "[", "\"\<Classes\>\"", "]"}], " "}]],
       "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "36ab7c3b-bf5a-4d2f-8915-f93a34cadfa1"],
     "\[LineSeparator]gives the list of all available classes for exact \
solutions."
    }],ExpressionUUID->"3ee9ab17-a23c-4f97-9301-2b2fa62be799"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"xActSolutionData", " ", "[", "class", "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "069411c3-2719-4c7e-ae01-9abae0c7e81c"],
     "\[LineSeparator]  gives the list of exact solutions belonging to the \
class ",
     Cell[BoxData["class"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "dcf9eda1-fe9b-4444-9052-d4ce4b87c381"],
     "."
    }],ExpressionUUID->"8ccddf39-af66-490a-9af7-c20c98196382"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"xActSolutionData", " ", "[", "sol", "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a1d7912d-4261-49e7-b0bb-fb275c167620"],
     "\[LineSeparator]gives the list of available coordinate systems for the \
exact solution ",
     Cell[BoxData["sol"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "8f581448-5e0c-4d8b-a429-f6628dfad5d4"],
     "."
    }],ExpressionUUID->"7d71251e-4204-4599-bb0d-ef5357bb8c37"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"xActSolutionData", " ", "[", 
       RowBox[{"sol", ",", " ", "prop"}], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "98ad6f89-0180-4ed6-a010-6fbfacde36cc"],
     "\[LineSeparator]queries the property ",
     Cell[BoxData["prop"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "7df4e15f-df1a-4cfb-bdaa-8511a6a0d02d"],
     " of the exact solution ",
     Cell[BoxData["sol"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "c83dd7ef-3a21-41de-8c2b-c38afdfe4e37"],
     "."
    }],ExpressionUUID->"f5534d0a-c832-44a5-b5f4-0d201973da4c"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"xActSolutionData", " ", "[", 
       RowBox[{"sol", ",", " ", "\"\<Properties\>\""}], "]"}]], 
      "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "e0583a8d-7ffa-4ed2-ab48-1e9122dad292"],
     "\[LineSeparator]gives the list of available properties for querying of \
the exact solution ",
     Cell[BoxData["sol"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "a54fd430-1acb-484d-a5e5-7e7cf372a0f4"],
     "."
    }],ExpressionUUID->"2a2d0282-14e1-42ee-9602-3ff8a190db98"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"xActSolutionData", " ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"sol", ",", " ", "coord"}], "}"}], ",", " ", "prop"}], 
       "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "3be0f962-4163-4c6f-b0cf-319e1ad690d1"],
     "\[LineSeparator]queries the property  ",
     Cell[BoxData["prop"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "794acef7-fcc7-43f8-a751-ff5e580715be"],
     "  of the exact solution ",
     Cell[BoxData["sol"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "0a27b987-8b15-44ac-ab3c-fce11fcc492a"],
     " in the coordinate system  ",
     Cell[BoxData["coord"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "997a2cb8-27d2-44af-879f-c657cdfcef8b"],
     " ."
    }],ExpressionUUID->"59343a75-9005-4963-a92c-42a3bb2e585f"]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{
        RowBox[{"xActSolutionData", " ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"sol", ",", " ", "coord"}], "}"}], ",", 
          " ", "\"\<Properties\>\""}]}], "}"}], "]"}]], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "6ac34df0-f030-4d1a-8cc7-66e562c1fe72"],
     "\[LineSeparator]gives the list of available properties of the exact \
solution ",
     Cell[BoxData["sol"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "b0eb76ff-d6af-4c1d-98cd-fdaabea9591a"],
     "  in the coordinate system  ",
     Cell[BoxData["coords"], "InlineFormula",
      FontFamily->"Source Sans Pro",ExpressionUUID->
      "1fad8d31-b65d-41ea-b773-bd716d4ce3da"],
     "  ."
    }],ExpressionUUID->"8c5b0872-39bf-4384-81cb-ddce0c3f80da"]}
  }]], "Usage",
 CellID->947225108,ExpressionUUID->"cdfe0471-4fcb-41c2-bc18-c916677370ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[Cell[TextData[{
   Cell[BoxData[
    DynamicBox[ToBoxes[
      If[CurrentValue[
         EvaluationCell[], "CellGroupOpen"] =!= Closed, 
       Style[
        Graphics[{
          Thickness[0.18], 
          RGBColor[0.8509803921568627, 0.396078431372549, 0], 
          Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
         PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
        0.68 Inherited], 
       Rotate[
        Style[
         Graphics[{
           Thickness[0.18], 
           RGBColor[0.8509803921568627, 0.396078431372549, 0], 
           Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
          PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
         0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
     ImageSizeCache->{
      13.600000000000001`, {-0.09851562499999922, 13.698515625}}]],
    ExpressionUUID->"316ac4a1-d4cb-450d-ba95-ecc25b7ad8c4"],
   Cell[BoxData[
    TemplateBox[{1},
     "Spacer1"]],ExpressionUUID->"45145edf-a78f-4bd1-b7b5-d984f72f1668"],
   "Details"
  }], "NotesFrameText",ExpressionUUID->"db9faf0f-bbdd-4ab1-b673-c1a01c45f0bd"],
  Appearance->{Automatic, None, "Normal", Automatic},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->
   "Preemptive"]],ExpressionUUID->"39497ac7-b728-4c21-854f-e23c8179cc58"]], \
"NotesSection",
 ShowGroupOpener->"Thumbnail",
 WholeCellGroupOpener->True,
 CellGroupingRules->{"SectionGrouping", 50},
 CacheGraphics->False,
 CellID->1197403115,ExpressionUUID->"3baca0e1-fe2c-457f-801d-e61ddeae86c3"],

Cell["  ", "Notes",
 CellID->308140725,ExpressionUUID->"7d7734d8-b9b9-4e7a-8813-5a6615c3edec"],

Cell["  ", "Notes",
 CellID->464222344,ExpressionUUID->"951cdbb8-2eae-46f6-8e1f-b6d0433c52fb"],

Cell["  ", "Notes",
 CellID->629813785,ExpressionUUID->"f8e0e994-374d-49a9-9e04-45f4549ca4ce"]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "PrimaryExamplesSection"}, Open], 
      Alternatives[True, Open]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{13.600000000000001`, {4.321484375000001, 9.278515625}}]],
  ExpressionUUID->"8bf09b5b-4bfc-44b1-8ed5-e1fc813e1536"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"3cae81ca-b593-49d8-ab27-3a51e5e2f4a0"],
 "Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount",ExpressionUUID->
  "7744a6c6-025f-4ec5-8920-5138a5a91f4b"]
}], "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellTags->"PrimaryExamplesSection",
 CellID->1111486702,ExpressionUUID->"807d3862-a925-4aa9-85f7-17477a0643ec"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xIdeal`\>\"", "]"}]], "Input", "ExampleInitialization",
 CellLabel->"In[1]:=",
 CellID->817605420,ExpressionUUID->"c2a7e76c-b24d-4591-9a84-ea07119a5ab1"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.06554687500000078, 13.534453125}}]],
  ExpressionUUID->"bc988ebc-7e36-4555-8d15-440662e72ec6"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"68e7860c-f5a6-42ad-981c-03f4331c844c"],
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "2e772aa6-fa52-493d-8503-b0fcb433615a"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1150199918,ExpressionUUID->"b3fe45d1-e610-4a59-8e87-d0a9cca06d40"],

Cell["\<\
Let us take the Friedmann solution in its default coordinates: \
\>", "ExampleText",
 CellID->846928249,ExpressionUUID->"de307e4b-023e-4050-9cef-3dae4658304f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", "\"\<Friedmann\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->372709450,ExpressionUUID->"0c258428-78ab-4a26-a22e-6d9376319680"],

Cell[BoxData[
 RowBox[{"{", "\<\"ReducedCircumferencePolarCoordinates\"\>", "}"}]], "Output",\

 CellLabel->"Out[1]=",
 CellID->750567566,ExpressionUUID->"c8f885cf-038f-4012-b05c-f659eed26f7e"]
}, Open  ]],

Cell["Let us carry out some computations with it:", "ExampleText",
 CellID->1695234636,ExpressionUUID->"cdd74e8a-ae12-45b8-8766-a6dc227b672d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->172691151,ExpressionUUID->"51c6db88-0d1d-4dbb-8f8c-feace1418b4f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Friedmann\>\"", ",", "\"\<CoordinateNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->806496087,ExpressionUUID->"4b7a3758-26fe-464c-9e22-a9d7ed05f0d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"t\"\>", ",", "\<\"r\"\>", ",", "\<\"\[Theta]\"\>", 
   ",", "\<\"\[Phi]\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1115273353,ExpressionUUID->"f8fc0a07-2623-44fb-850b-412f112d89d5"]
}, Open  ]],

Cell["Use these names to introduce a  chart:", "ExampleText",
 CellID->1472014302,ExpressionUUID->"34990319-461b-4610-8b93-b31297e3ca50"],

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"Cp", ",", "M", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "[", "]"}], ",", 
     RowBox[{"r", "[", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",
 CellID->1410191844,ExpressionUUID->"da290031-fff0-4c03-bfba-faf907095210"],

Cell["There is one parameter and one scalar function:", "ExampleText",
 CellID->2120853183,ExpressionUUID->"596f901a-a0ad-445b-9f4f-19d925acc684"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Friedmann\>\"", ",", "\"\<ParameterNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[5]:=",
 CellID->1525506234,ExpressionUUID->"cd402abe-333e-4aec-b0b9-70ad4b82d5de"],

Cell[BoxData[
 RowBox[{"{", "\<\"k\"\>", "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->2099870811,ExpressionUUID->"110831b6-e9dd-4081-82b0-e6b8574e7a9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Friedmann\>\"", ",", "\"\<ScalarFunctionNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[6]:=",
 CellID->384715940,ExpressionUUID->"2a61aa4c-c6ae-4178-97fc-3114216f7bca"],

Cell[BoxData[
 RowBox[{"{", "\<\"R\"\>", "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->696643655,ExpressionUUID->"2b881d98-43ef-412e-8f72-1e2e37261466"]
}, Open  ]],

Cell[TextData[{
 "We need to define the parameter and the scalar function (note that the \
symbol ",
 StyleBox["k", "Input"],
 " is already used as an abstract index):"
}], "ExampleText",
 CellID->845433962,ExpressionUUID->"88a11232-0d8e-4e2f-8104-90957f118305"],

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"kk", ",", 
   RowBox[{"PrintAs", "->", "\"\<k\>\""}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[7]:=",
 CellID->941509497,ExpressionUUID->"d4647e90-3aad-45da-8d44-bb5ddc0bdd61"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefScalarFunction", "[", "R", "]"}], ";"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[8]:=",
 CellID->804830991,ExpressionUUID->"aa349ef6-5190-42dd-96fb-b93bf898cf4a"],

Cell["\<\
With the previous ingredients, we can get the matrix expression of the metric \
tensor:\
\>", "ExampleText",
 CellID->2056787353,ExpressionUUID->"07139d3e-7aab-4619-b82d-e5aa290069c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metric", "=", 
  RowBox[{
   RowBox[{"xActSolutionData", "[", 
    RowBox[{"\"\<Friedmann\>\"", ",", "\"\<Metric\>\""}], "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "[", "]"}], ",", 
      RowBox[{"r", "[", "]"}], ",", 
      RowBox[{"\[Theta]", "[", "]"}], ",", 
      RowBox[{"\[Phi]", "[", "]"}]}], "}"}], ",", 
    RowBox[{"{", "kk", "}"}], ",", 
    RowBox[{"{", "R", "}"}]}], "]"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[9]:=",
 CellID->2043656533,ExpressionUUID->"901bfda0-f093-4b55-8ca8-366f9796fff4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["R",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`R,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["t",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`t[],
         Editable->False], "]"}], "2"], 
      RowBox[{"1", "-", 
       RowBox[{
        InterpretationBox[
         StyleBox["k",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`kk,
         Editable->False], " ", 
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"]}]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["R",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`R,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["t",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`t[],
         Editable->False], "]"}], "2"]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["R",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`R,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["t",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`t[],
         Editable->False], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          ShowAutoStyles->False,
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox["\[Theta]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Theta][],
         Editable->False], "]"}], "2"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->468730751,ExpressionUUID->"a14b4151-62eb-43f5-8d2b-6a64a0068c8b"]
}, Open  ]],

Cell[TextData[{
 "We can also get the ",
 Cell[BoxData["CTensor"], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "76a3002f-1336-4aa9-9cfa-e27ac31ff434"],
 " expression which is ",
 StyleBox["xCoba's",
  FontSlant->"Italic"],
 " native way of handling tensor components: "
}], "ExampleText",
 CellID->1816261334,ExpressionUUID->"4b055b07-b519-4b60-bce7-b5dd49d8a78f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metricTensor", "=", 
  RowBox[{"xActSolutionData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Friedmann\>\"", ",", 
      RowBox[{"\"\<ReducedCircumferencePolarCoordinates\>\"", "->", "Cp"}], ",", 
      RowBox[{"\"\<ScalarFunctionNames\>\"", "->", 
       RowBox[{"{", 
        InterpretationBox[
         StyleBox["R",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`R,
         Editable->False], "}"}]}], ",", 
      RowBox[{"\"\<ParameterNames\>\"", "->", 
       RowBox[{"{", 
        InterpretationBox[
         StyleBox["k",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`kk,
         Editable->False], "}"}]}]}], "}"}], ",", "\"\<Metric\>\""}], 
   "]"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[10]:=",
 CellID->1839978071,ExpressionUUID->"d6055232-0929-44d6-b0a4-a7e127924992"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox[
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["R",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`R,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["t",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`t[],
           Editable->False], "]"}], "2"], 
        RowBox[{"1", "-", 
         RowBox[{
          InterpretationBox[
           StyleBox["k",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`kk,
           Editable->False], " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["R",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`R,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["t",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`t[],
           Editable->False], "]"}], "2"]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["R",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`R,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["t",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`t[],
           Editable->False], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "Cp"}], ",", 
     RowBox[{"-", "Cp"}]}], "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->638705748,ExpressionUUID->"46dfa453-19f2-40b8-9d06-e1d75e005b71"]
}, Open  ]],

Cell["\<\
We can carry out explicit computations with this metric. For example we can \
compute its Ricci tensor:\
\>", "ExampleText",
 CellID->1542706052,ExpressionUUID->"cdb01f0b-e97c-4005-b239-4fa7a6b4b585"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ricciTensor", "=", 
  RowBox[{"xActSolutionData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Friedmann\>\"", ",", 
      RowBox[{"\"\<ReducedCircumferencePolarCoordinates\>\"", "->", "Cp"}], ",", 
      RowBox[{"\"\<ScalarFunctionNames\>\"", "->", 
       RowBox[{"{", 
        InterpretationBox[
         StyleBox["R",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`R,
         Editable->False], "}"}]}], ",", 
      RowBox[{"\"\<ParameterNames\>\"", "->", 
       RowBox[{"{", 
        InterpretationBox[
         StyleBox["k",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`kk,
         Editable->False], "}"}]}]}], "}"}], ",", "\"\<Ricci\>\"", ",", 
    RowBox[{"Parallelize", "\[Rule]", "True"}], ",", 
    RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[11]:=",
 CellID->560556497,ExpressionUUID->"94d7de56-9071-4dff-9ad8-a46a073723f3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1193091896,ExpressionUUID->"5a1b6869-d8ae-4e95-b201-1027d15edf5c"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1409186749,ExpressionUUID->"a49e1546-474e-4589-a9ad-5604e4d23644"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1666403000,ExpressionUUID->"d64e9052-4e1e-4f79-9974-2481f4f71dc4"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1649880750,ExpressionUUID->"50554a74-61e2-4dc2-9382-f01f8d540f01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1714842000,ExpressionUUID->"21debb3a-4dfe-4a8c-ba0d-2716043cf7d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.002196`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.002196, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->617199753,ExpressionUUID->"a8c44dc5-f38f-4ffc-8e73-f19ce0e0275b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "3.169356`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 3.169356, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->757682803,ExpressionUUID->"a98107a7-b1a7-4078-a1e0-42b915e38eb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1877628108,ExpressionUUID->"bab488b3-edf5-4191-9ce6-446d37ac7d11"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1303736867,ExpressionUUID->"8da5f06b-5289-4ecc-af0e-105501f7b6d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1146953269,ExpressionUUID->"5a0ba46f-5ac4-4022-a005-8301d7007085"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2099860739,ExpressionUUID->"b03e2f9c-7508-400a-9c5f-463067be1050"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->406789880,ExpressionUUID->"8cbaeb54-c70a-4d13-8560-3c5f350f0601"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1446460519,ExpressionUUID->"a4fe5d9f-c6d4-4e5c-98a4-d7a852703573"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->282698571,ExpressionUUID->"d7a8dfa9-ab91-4ce6-8671-d8c8155bfb3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.001026`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.001026, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->299968610,ExpressionUUID->"a28e2e59-970a-4d82-8634-a800d01c5017"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.041637`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.041637, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->7038138,ExpressionUUID->"a661e82f-9450-409b-af3e-2ee37d92e383"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000967`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "25088",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000967, " seconds and ", 25088, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1769788736,ExpressionUUID->"9463c01d-7072-429d-95bf-2e55b80c076c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->739701584,ExpressionUUID->"ea4cb093-8046-4cfd-9b10-dae0a75a037e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.00233`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.00233, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1539923312,ExpressionUUID->"c0e0297c-05af-42ba-b3f7-319e437821ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.034509`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.034509, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1473040141,ExpressionUUID->"054cd4dc-d808-4e37-b224-2a364a426cc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.001098`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "19712",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.001098, " seconds and ", 19712, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->667525444,ExpressionUUID->"978ff479-037b-4c3a-a1ab-6acd35b4b5a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->106684966,ExpressionUUID->"26fd02f9-3253-4911-8fd9-0d2469ef8962"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000269`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000269, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->2108361481,ExpressionUUID->"2ce28fff-df22-4eb8-9b96-881049108417"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.033725`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.033725, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1418093011,ExpressionUUID->"b8203688-6b0a-4ac9-9787-8f7c9035c1f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000389`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "4120", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000389, " seconds and ", 4120, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1221958319,ExpressionUUID->"3c60a2b6-fc57-410b-a62f-4751d0a49796"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["R",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`R,
             Editable->False], "\[Prime]\[Prime]",
            MultilineFunction->None], "[", 
           InterpretationBox[
            StyleBox["t",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`t[],
            Editable->False], "]"}]}], 
         RowBox[{
          InterpretationBox[
           StyleBox["R",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`R,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["t",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`t[],
           Editable->False], "]"}]]}], ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["k",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`kk,
           Editable->False]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["R",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`R,
              Editable->False], "\[Prime]",
             MultilineFunction->None], "[", 
            InterpretationBox[
             StyleBox["t",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`t[],
             Editable->False], "]"}], "2"]}], "+", 
         RowBox[{
          RowBox[{
           InterpretationBox[
            StyleBox["R",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`R,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox["t",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`t[],
            Editable->False], "]"}], " ", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["R",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`R,
             Editable->False], "\[Prime]\[Prime]",
            MultilineFunction->None], "[", 
           InterpretationBox[
            StyleBox["t",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`t[],
            Editable->False], "]"}]}]}], 
        RowBox[{"1", "-", 
         RowBox[{
          InterpretationBox[
           StyleBox["k",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`kk,
           Editable->False], " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["r",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`r[],
            Editable->False], "2"]}]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             InterpretationBox[
              StyleBox["k",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`kk,
              Editable->False], "+", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["R",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`R,
                 Editable->False], "\[Prime]",
                MultilineFunction->None], "[", 
               InterpretationBox[
                StyleBox["t",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`t[],
                Editable->False], "]"}], "2"]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{
            InterpretationBox[
             StyleBox["R",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`R,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["t",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`t[],
             Editable->False], "]"}], " ", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["R",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`R,
              Editable->False], "\[Prime]\[Prime]",
             MultilineFunction->None], "[", 
            InterpretationBox[
             StyleBox["t",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`t[],
             Editable->False], "]"}]}]}], ")"}]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             InterpretationBox[
              StyleBox["k",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`kk,
              Editable->False], "+", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox[
                InterpretationBox[
                 StyleBox["R",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`R,
                 Editable->False], "\[Prime]",
                MultilineFunction->None], "[", 
               InterpretationBox[
                StyleBox["t",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`t[],
                Editable->False], "]"}], "2"]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{
            InterpretationBox[
             StyleBox["R",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`R,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox["t",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`t[],
             Editable->False], "]"}], " ", 
           RowBox[{
            SuperscriptBox[
             InterpretationBox[
              StyleBox["R",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`R,
              Editable->False], "\[Prime]\[Prime]",
             MultilineFunction->None], "[", 
            InterpretationBox[
             StyleBox["t",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`t[],
             Editable->False], "]"}]}]}], ")"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "Cp"}], ",", 
     RowBox[{"-", "Cp"}]}], "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[11]=",
 CellID->2060748644,ExpressionUUID->"bf76c66b-3fe1-4868-b01f-4ab4c1af82cc"]
}, Open  ]],

Cell["We add the abstract indices to the result:", "ExampleText",
 CellID->635890570,ExpressionUUID->"ab48392d-845c-43dd-8350-9167b789e6ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ricciTensor", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[12]:=",
 CellID->1461989129,ExpressionUUID->"76840364-3a67-43e6-b169-8025cc5f3728"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      StyleBox[GridBox[{
         {
          TagBox[
           TooltipBox[
            RowBox[{"-", 
             FractionBox[
              RowBox[{"3", " ", 
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["R",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`R,
                  Editable->False], "\[Prime]\[Prime]",
                 MultilineFunction->None], "[", 
                InterpretationBox[
                 StyleBox["t",
                  ShowAutoStyles->False,
                  AutoSpacing->False],
                 $CellContext`t[],
                 Editable->False], "]"}]}], 
              RowBox[{
               InterpretationBox[
                StyleBox["R",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`R,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox["t",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`t[],
                Editable->False], "]"}]]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
              RowBox[{"-", 
                FractionBox[
                 RowBox[{"3", " ", 
                   RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], 
                    "\[Prime]\[Prime]", MultilineFunction -> None], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}]}], 
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], "[", 
                   InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}]]}]}]],
           Annotation[#, {1, 1} -> (-3) $CellContext`R[
                $CellContext`t[]]^(-1) Derivative[2][$CellContext`R][
               $CellContext`t[]], "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {1, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
              FractionBox[
               RowBox[{
                 RowBox[{"2", " ", 
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"k"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`kk, Editable -> False]}], "+", 
                 RowBox[{"2", " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], "\[Prime]", 
                    MultilineFunction -> None], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}], "2"]}], "+", 
                 
                 RowBox[{
                   RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], 
                    "\[Prime]\[Prime]", MultilineFunction -> None], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}]}]}], 
               RowBox[{"1", "-", 
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"k"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`kk, Editable -> False], " ", 
                   SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`r[], Editable -> False], "2"]}]}]]}]],
           
           Annotation[#, {2, 
             2} -> (1 - $CellContext`kk $CellContext`r[]^2)^(-1) (
              2 $CellContext`kk + 2 Derivative[1][$CellContext`R][
                  $CellContext`t[]]^2 + $CellContext`R[
                 $CellContext`t[]] Derivative[2][$CellContext`R][
                 $CellContext`t[]]), "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {2, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[
            RowBox[{
             SuperscriptBox[
              InterpretationBox[
               StyleBox["r",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`r[],
               Editable->False], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "+", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox["R",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`R,
                    Editable->False], "\[Prime]",
                    MultilineFunction->None], "[", 
                    InterpretationBox[
                    StyleBox["t",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`t[],
                    Editable->False], "]"}], "2"]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{
                 InterpretationBox[
                  StyleBox["R",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`R,
                  Editable->False], "[", 
                 InterpretationBox[
                  StyleBox["t",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`t[],
                  Editable->False], "]"}], " ", 
                RowBox[{
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["R",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`R,
                   Editable->False], "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", 
                 InterpretationBox[
                  StyleBox["t",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`t[],
                  Editable->False], "]"}]}]}], ")"}]}],
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
              RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False], "2"], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"k"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`kk, Editable -> False], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], "\[Prime]", 
                    MultilineFunction -> None], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}], "2"]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], 
                    "\[Prime]\[Prime]", MultilineFunction -> None], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}]}]}], 
                  ")"}]}]}]],
           
           Annotation[#, {3, 
             3} -> $CellContext`r[]^2 (
              2 ($CellContext`kk + Derivative[1][$CellContext`R][
                   $CellContext`t[]]^2) + $CellContext`R[
                 $CellContext`t[]] Derivative[2][$CellContext`R][
                 $CellContext`t[]]), "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {3, 4} -> 0, "Tooltip"]& ]},
         {
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 1} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 2} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["0",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "0"}]],
           Annotation[#, {4, 3} -> 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox["\<\"\[GrayCircle]\"\>",
            RowBox[{
              RowBox[{"{", 
                RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", 
              RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox[
                  "r", AutoSpacing -> False, ShowAutoStyles -> False], 
                  $CellContext`r[], Editable -> False], "2"], " ", 
                SuperscriptBox[
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    RowBox[{"Sin"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], Sin, Editable -> False], "[", 
                   InterpretationBox[
                    StyleBox[
                    "\[Theta]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`\[Theta][], Editable -> False], "]"}], "2"], 
                " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"k"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`kk, Editable -> False], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], "\[Prime]", 
                    MultilineFunction -> None], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}], "2"]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"R"}], AutoSpacing -> False, ShowAutoStyles -> 
                    False], $CellContext`R, Editable -> False], 
                    "\[Prime]\[Prime]", MultilineFunction -> None], "[", 
                    InterpretationBox[
                    StyleBox[
                    "t", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`t[], Editable -> False], "]"}]}]}], 
                  ")"}]}]}]],
           Annotation[#, {4, 4} -> $CellContext`r[]^2 Sin[
                $CellContext`\[Theta][]]^2 (
              2 ($CellContext`kk + Derivative[1][$CellContext`R][
                   $CellContext`t[]]^2) + $CellContext`R[
                 $CellContext`t[]] Derivative[2][$CellContext`R][
                 $CellContext`t[]]), "Tooltip"]& ]}
        },
        AutoDelete->False,
        GridBoxDividers->{
         "ColumnsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]},
           "RowsIndexed" -> {1 -> RGBColor[1, 0, 0], 5 -> RGBColor[1, 0, 0]}}],
       FontSize->Small], 
      StyleBox[GridBox[{
         {" ", " "},
         {"a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xCoba`CTensor[{{(-3) $CellContext`R[
        $CellContext`t[]]^(-1) Derivative[2][$CellContext`R][
       $CellContext`t[]], 0, 0, 0}, {
    0, (1 - $CellContext`kk $CellContext`r[]^2)^(-1) (2 $CellContext`kk + 
      2 Derivative[1][$CellContext`R][
          $CellContext`t[]]^2 + $CellContext`R[
         $CellContext`t[]] Derivative[2][$CellContext`R][
         $CellContext`t[]]), 0, 0}, {
    0, 0, $CellContext`r[]^2 (
      2 ($CellContext`kk + Derivative[1][$CellContext`R][
           $CellContext`t[]]^2) + $CellContext`R[
         $CellContext`t[]] Derivative[2][$CellContext`R][
         $CellContext`t[]]), 0}, {0, 0, 0, $CellContext`r[]^2 Sin[
        $CellContext`\[Theta][]]^2 (
      2 ($CellContext`kk + Derivative[1][$CellContext`R][
           $CellContext`t[]]^2) + $CellContext`R[
         $CellContext`t[]] Derivative[2][$CellContext`R][
         $CellContext`t[]])}}, {-$CellContext`Cp, -$CellContext`Cp}, 
   0][-$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[12]=",
 CellID->2114736666,ExpressionUUID->"5e87ee5a-02e9-4c94-91f0-3b5e60e13991"]
}, Open  ]],

Cell["\<\
We set the Friedmann metric obtained above as our default metric:\
\>", "ExampleText",
 CellID->1528148855,ExpressionUUID->"e53240dc-885c-4b3e-b216-a8ee13a34a00"],

Cell[BoxData[
 RowBox[{"SetCMetric", "[", 
  RowBox[{"metricTensor", ",", "Cp", ",", 
   RowBox[{"SignatureOfMetric", "->", 
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Friedmann\>\"", ",", "\"\<SignatureOfMetric\>\""}], 
     "]"}]}]}], "\n", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[13]:=",
 CellID->1541416965,ExpressionUUID->"344afaeb-33b1-43ba-8290-c07d317e1aa4"],

Cell["\<\
We define a unit vector tangent to the comoving cosmological observer: \
\>", "ExampleText",
 CellID->91844987,ExpressionUUID->"9235428f-9b2b-40c0-82b1-ac5c011f66eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "=", 
  RowBox[{"CTensor", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", "Cp", "}"}]}], "]"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[14]:=",
 CellID->373845153,ExpressionUUID->"326f5a2e-9c24-4bef-97bb-abd83b3e3ed7"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "Cp", "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[14]=",
 CellID->1690689070,ExpressionUUID->"36282482-6433-49be-a276-752bea8d2d5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "a", "]"}], 
  RowBox[{"w", "[", 
   RowBox[{"-", "a"}], "]"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[15]:=",
 CellID->384632792,ExpressionUUID->"27a4eb4c-dcba-45af-b43b-5fa2994db8b5"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->"Out[15]=",
 CellID->1238817752,ExpressionUUID->"e5d44de8-31a1-4996-8d65-946d5d0254b6"]
}, Open  ]],

Cell["\<\
We test that the Friedmann solution has a perfect fluid as the matter \
content. The vector just defined is the fluid velocity:\
\>", "ExampleText",
 CellID->107166659,ExpressionUUID->"6d9bec55-860b-4a57-910f-605b7bf30a9e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerfectFluidQ", "[", 
  RowBox[{"metricTensor", ",", 
   RowBox[{"\"\<Vector\>\"", "->", "w"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[16]:=",
 CellID->1160946677,ExpressionUUID->"1b53dbe8-be1b-47ad-9c45-664086b03ad5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->605958766,ExpressionUUID->"7e85a23b-d29e-4930-9476-7d52e20685ec"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->736297318,ExpressionUUID->"76fb25e2-23a1-499b-abeb-73e20c1c9c05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->500520854,ExpressionUUID->"5bea44dc-3003-439b-a379-90faa7f3d8b2"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->124878119,ExpressionUUID->"1463d3dc-6acb-466c-890a-8f5b4cd06f22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->238694420,ExpressionUUID->"34704674-dd57-4cee-86e1-b6a282368569"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->67879206,ExpressionUUID->"92ad3dfc-5d16-48a5-8d52-56bfd9671bac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->742077872,ExpressionUUID->"b3e53a60-e1b9-4fe2-af3d-0a3128e0e8a0"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1499136800,ExpressionUUID->"8fc83f21-0ce5-4b8c-916f-15167831cbff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->825562009,ExpressionUUID->"a5535bbf-f687-415e-9ac5-5b24bdba3263"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->472222332,ExpressionUUID->"9250bfa0-99d4-4586-9b40-c12d68b75eb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->655390019,ExpressionUUID->"3a3cb643-99ac-4ce8-ab2f-cc004d9b8f9b"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1972515278,ExpressionUUID->"5bdcdfb2-69ab-415d-8e62-2c07c23a93b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->424599424,ExpressionUUID->"020505f7-fa33-4f13-931e-a086dda63229"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1062179899,ExpressionUUID->"8b7059aa-ecf3-4bdc-8188-a504c679a9fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1271492150,ExpressionUUID->"205dc41d-1587-462a-97f1-319da10abc71"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->707297995,ExpressionUUID->"dc261ee6-ec75-41de-99d3-90e062a71c8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1362148509,ExpressionUUID->"f21291ba-5f71-4016-9dec-d7329357f7ba"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1278530288,ExpressionUUID->"1a6c3e53-70b9-4839-bf9e-1ff46d8c8597"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"RicciScalar\"\>", "[", "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "RicciScalar"[]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->329603083,ExpressionUUID->"ed4d68e4-baca-4de7-8219-b0cedf983eb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000114`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000114, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->2101850093,ExpressionUUID->"25978bb5-dad4-4ce1-8df6-17644f4cb4a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.030778`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.030778, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->670969952,ExpressionUUID->"9dc14ab4-d836-4a23-9c59-fb5d3426ad57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000224`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "968", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000224, " seconds and ", 968, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1802643224,ExpressionUUID->"12a41542-2c7d-4486-ae6e-df38f4ece596"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Weyl\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Weyl"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->621891890,ExpressionUUID->"47e1ec60-e5ce-4878-abbf-2723057b0faa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000687`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000687, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->777654918,ExpressionUUID->"db7a58b9-43c1-466d-833d-9f773a4bcf32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.01099`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.01099, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1763521058,ExpressionUUID->"0b4ca7e0-b494-4b50-99f0-d85a7e830ef7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000967`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "6272", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000967, " seconds and ", 6272, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->2039984901,ExpressionUUID->"3204d7d3-8555-4161-a18f-c2c22e7f7c90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"STensor\\\" \
in \"\>", "\[InvisibleSpace]", "0.000911`3.4110633704689715", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor\" in ", 
   0.000911`3.4110633704689715, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1999613237,ExpressionUUID->"2a5b8f1e-009a-44cd-a40d-fc9e646fc7f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0.020065`4.753984157565831", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"STensor\" in ", 0.020065`4.753984157565831, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1676786054,ExpressionUUID->"81cd0a7f-e073-4c31-850c-4cfcb5b2798d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"STensor2\\\" in \"\>", "\[InvisibleSpace]", "0.003826`4.03428995918725", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor2\" in ", 
   0.003826`4.03428995918725, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->2007237919,ExpressionUUID->"b2f2d70c-434d-4957-83aa-91e3a50de23a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor2\\\" in \"\>",
    "\[InvisibleSpace]", "0.017831`4.702720693502713", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"STensor2\" in ", 0.017831`4.702720693502713, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1542818659,ExpressionUUID->"81ca5639-c795-4ad3-8f46-84c04a22ab33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"STensor3\\\" in \"\>", "\[InvisibleSpace]", "0.000904`3.4077134239713387",
    "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"STensor3\" in ", 
   0.000904`3.4077134239713387, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->768120159,ExpressionUUID->"bd4d45df-c224-4d89-9181-5fbdfc82c215"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"STensor3\\\" in \"\>",
    "\[InvisibleSpace]", "0.018871`4.727339908126976", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"STensor3\" in ", 0.018871`4.727339908126976, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->465713038,ExpressionUUID->"8d8f8566-ae23-4e2c-b083-8cf1cf613a88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"TrSTensor2\\\" in \"\>", "\[InvisibleSpace]", 
   "0.005108`4.159795882087351", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"TrSTensor2\" in ", 
   0.005108`4.159795882087351, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->131632330,ExpressionUUID->"ef5f62e5-2500-415b-a72e-274033c11d3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"TrSTensor2\\\" in \
\"\>", "\[InvisibleSpace]", "0.001767`3.698781543002737", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"TrSTensor2\" in ", 0.001767`3.698781543002737, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1268641013,ExpressionUUID->"ee164e4c-1c95-45da-9270-26e2c9fa3b7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"TrSTensor3\\\" in \"\>", "\[InvisibleSpace]", "0.006871`4.28856494203688",
    "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"TrSTensor3\" in ", 
   0.006871`4.28856494203688, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->590591157,ExpressionUUID->"4c41562a-f228-41c4-9db3-f7e93c0ee4ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"TrSTensor3\\\" in \
\"\>", "\[InvisibleSpace]", "0.002908`3.9151393956829734", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"TrSTensor3\" in ", 0.002908`3.9151393956829734, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->370326750,ExpressionUUID->"5cec42d2-1295-4f6f-a026-fa41ee5d7091"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"qScalar\\\" \
in \"\>", "\[InvisibleSpace]", "0.000025`1.8494850021680107", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"qScalar\" in ", 
   0.000025`1.8494850021680107, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1336520219,ExpressionUUID->"1239f0bd-e4f5-4db5-9f3a-b27b3bc8b967"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"qScalar\\\" in \"\>", 
   "\[InvisibleSpace]", "0.00115`3.5122428338495846", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"qScalar\" in ", 0.00115`3.5122428338495846, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1332669029,ExpressionUUID->"8d3cf666-3e44-4c5c-9d15-601cc11a2d42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"QTensor\\\" \
in \"\>", "\[InvisibleSpace]", "0.00032`2.9566949718158786", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"QTensor\" in ", 
   0.00032`2.9566949718158786, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1869463550,ExpressionUUID->"b723ec97-45fb-447d-963d-bc3068e2553b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"QTensor\\\" in \"\>", 
   "\[InvisibleSpace]", "0.000496`3.1470266699861704", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"QTensor\" in ", 0.000496`3.1470266699861704, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->14598581,ExpressionUUID->"941763a4-34dc-4d2a-bd25-e2fe5f7a483b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"QTensor2\\\" in \"\>", "\[InvisibleSpace]", "0.002244`3.802567846080099", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"QTensor2\" in ", 
   0.002244`3.802567846080099, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1804891361,ExpressionUUID->"1fc1f580-11bd-4ff7-bff4-c0de849012ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"QTensor2\\\" in \"\>",
    "\[InvisibleSpace]", "0.001828`3.7135211848937835", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"QTensor2\" in ", 0.001828`3.7135211848937835, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->377369921,ExpressionUUID->"f6360120-d350-4c33-b12d-a2f6dc581d87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"FluPerCond1\
\\\" in \"\>", "\[InvisibleSpace]", "0.000222`2.7978979679466116", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerCond1\" in ", 
   0.000222`2.7978979679466116, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1987113859,ExpressionUUID->"ac6064cf-48ba-4f66-a483-61ef2a33fa35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerCond1\\\" in \"\
\>", "\[InvisibleSpace]", "0.000027`1.8829087576549601", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FluPerCond1\" in ", 0.000027`1.8829087576549601, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->82007137,ExpressionUUID->"089edef3-ec85-4694-a219-0902157baaee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"FluPerCond2\
\\\" in \"\>", "\[InvisibleSpace]", "0.000814`3.3621693983851744", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerCond2\" in ", 
   0.000814`3.3621693983851744, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1439549821,ExpressionUUID->"64da7842-b0b2-4691-824e-991414021a84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerCond2\\\" in \"\
\>", "\[InvisibleSpace]", "0.001993`3.751052292196458", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FluPerCond2\" in ", 0.001993`3.751052292196458, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->1111122361,ExpressionUUID->"b9b96f58-eef9-40e6-808d-5a843e8c749d"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[16]=",
 CellID->789305133,ExpressionUUID->"50119f13-32e2-4bd0-8061-01a36d4e7b85"]
}, Open  ]],

Cell["\<\
We also heck that the perfect fluid is a thermodynamic perfect fluid:\
\>", "ExampleText",
 CellID->1541371525,ExpressionUUID->"60346335-99d3-4804-abc5-040c4e1b6abb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThermodynamicPerfectFluidQ", "[", 
  RowBox[{"metricTensor", ",", 
   RowBox[{"\"\<Vector\>\"", "->", "w"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[17]:=",
 CellID->592591902,ExpressionUUID->"31cfcec9-68f0-4992-a9af-cfb2ec562783"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \\\"rScalar\\\" \
in \"\>", "\[InvisibleSpace]", "0.003533`3.9996886309308164", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"rScalar\" in ", 
   0.003533`3.9996886309308164, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->654214682,ExpressionUUID->"962be5b0-4171-4442-9df1-a14d949c6959"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"rScalar\\\" in \"\>", 
   "\[InvisibleSpace]", "0.001676`3.675819007790231", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"rScalar\" in ", 0.001676`3.675819007790231, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->242169001,ExpressionUUID->"c060ec2f-825c-4e92-99d3-3932dbf20db8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", "0.000016`1.6556649761518967",
    "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"Pressure\" in ", 
   0.000016`1.6556649761518967, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1118908216,ExpressionUUID->"961b210a-d147-421d-9fbc-1990f6d3602a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"Pressure\\\" in \"\>",
    "\[InvisibleSpace]", "0.002514`3.85191026684591", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"Pressure\" in ", 0.002514`3.85191026684591, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->608581128,ExpressionUUID->"e93a48aa-8b5b-4531-b10b-dc6cc87ff7df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000018`1.706817498599279", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"EnergyDensity\" in ", 
   0.000018`1.706817498599279, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->913138954,ExpressionUUID->"3c4b890e-51c4-41f2-9a7a-044b7cef30cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"EnergyDensity\\\" in \
\"\>", "\[InvisibleSpace]", "0.000795`3.3519121221524415", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"EnergyDensity\" in ", 
   0.000795`3.3519121221524415, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->774067793,ExpressionUUID->"337a3a60-fa23-4943-904e-4fd5f2a9dc3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"FlowProjector\\\" in \"\>", "\[InvisibleSpace]", 
   "0.00017`2.6819939148742487", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FlowProjector\" in ", 
   0.00017`2.6819939148742487, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1230473018,ExpressionUUID->"fa9c9dae-3aa9-4b11-82c2-f3ea29c5f573"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FlowProjector\\\" in \
\"\>", "\[InvisibleSpace]", "0.000106`2.476850858760743", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FlowProjector\" in ", 0.000106`2.476850858760743,
    " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1690793872,ExpressionUUID->"54fc6094-7610-4ad3-b8d9-13de0070159f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"FluPerFlow\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000748`3.3254465913604365", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"FluPerFlow\" in ", 
   0.000748`3.3254465913604365, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->390105203,ExpressionUUID->"8c924d7a-6b31-49fa-b30b-b3f31183a8b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"FluPerFlow\\\" in \
\"\>", "\[InvisibleSpace]", "0.000108`2.484968748982925", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"FluPerFlow\" in ", 0.000108`2.484968748982925, 
   " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1122974271,ExpressionUUID->"18c81fd4-dded-46bd-b4c5-00bb8c095e56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.017815`4.702330820183008", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"IndicatrixFunction\" in ",
    0.017815`4.702330820183008, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1542923462,ExpressionUUID->"e963d39b-987e-43b0-b1a2-e3b5427ae37d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \
\\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.003035`3.9337036889072516", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"IndicatrixFunction\" in ", 
   0.003035`3.9337036889072516, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->2066891257,ExpressionUUID->"d13edba5-13c3-4289-ad26-91c9b5ce77f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000115`2.512242833849587", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"Pressure\" in ", 0.000115`2.512242833849587, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->982728542,ExpressionUUID->"488b5aa4-54d6-4277-a41f-afe73dfd1cb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"Pressure\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000105`2.4727342925659106", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"Pressure\" in ", 
   0.000105`2.4727342925659106, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->938258473,ExpressionUUID->"a218a40e-78ff-4930-8ce5-c1c3f2c7c92f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000101`2.455866367278616", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"EnergyDensity\" in ", 0.000101`2.455866367278616, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->687527768,ExpressionUUID->"246675e1-74d8-4bc0-a7b5-74a9e5146c77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"EnergyDensity\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000099`2.4471801880935224", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"EnergyDensity\" in ", 
   0.000099`2.4471801880935224, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1448441580,ExpressionUUID->"2d5a83c8-522e-482c-b902-085f9bc3bdee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.039621`5.049470426056432", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing the exterior derivative of metric concomitant \
\"IndicatrixFunction\" in ", 0.039621`5.049470426056432, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1069890803,ExpressionUUID->"c42d17a9-7410-4e5f-9de4-16efbcd11376"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to the exterior derivative of metric \
concomitant \\\"IndicatrixFunction\\\" in \"\>", "\[InvisibleSpace]", 
   "0.000252`2.852945534277517", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to the exterior derivative of metric concomitant \"IndicatrixFunction\" \
in ", 0.000252`2.852945534277517, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1956168781,ExpressionUUID->"b2b44cf8-5be7-4a0a-b9b8-50733c927c47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: computing metric concomitant \
\\\"ThermoFluPerCond\\\" in \"\>", "\[InvisibleSpace]", 
   "0.005851`4.218775091606689", "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: computing metric concomitant \"ThermoFluPerCond\" in ", 
   0.005851`4.218775091606689, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->2039032737,ExpressionUUID->"622abc6b-f6d0-4558-a159-54e8447cc0fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: applying  \"\>", "\[InvisibleSpace]", 
   "Simplify", 
   "\[InvisibleSpace]", "\<\" to metric concomitant \\\"ThermoFluPerCond\\\" \
in \"\>", "\[InvisibleSpace]", "0.000036`2.007847494263258", 
   "\[InvisibleSpace]", "\<\" seconds:\"\>"}],
  SequenceForm[
  "** ReportCompute: applying  ", Simplify, 
   " to metric concomitant \"ThermoFluPerCond\" in ", 
   0.000036`2.007847494263258, " seconds:"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1440217554,ExpressionUUID->"938e6022-64b7-4d83-baf7-fad03399f9f9"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[17]=",
 CellID->1145205353,ExpressionUUID->"a9f3eddf-f67d-45c3-b80a-203fcc329121"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"},
        Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]],
   ImageSizeCache->{
    13.600000000000001`, {0.06554687500000078, 13.534453125}}]],
  ExpressionUUID->"175d4bcd-4172-472a-8476-82c6c8cedd13"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"41451f67-20a7-4f55-ae08-a3675e0ae236"],
 "Scope",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount",ExpressionUUID->
  "b5710966-1656-4968-8e0d-7af02ed79fba"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1426763492,ExpressionUUID->"46ede997-752f-40af-95e0-065e40897ba1"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]]]],ExpressionUUID->
  "5d512a55-5327-4fec-b6c4-431d251e87f1"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"6c972c4a-dc25-4455-b28d-775e0ae73d88"],
 "Basic usage",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "cea7874e-73b7-4e73-b220-0d18b0e9c06c"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->2136504387,ExpressionUUID->"f14c53c2-eeb9-4748-bc07-7fe9a1ab2aa7"],

Cell["\<\
By default the list of available exact solutions is displayed:\
\>", "ExampleText",
 CellID->364132405,ExpressionUUID->"39dfa786-0569-4c32-adfb-cb639b56598b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->1562364985,ExpressionUUID->"51be8d0d-7d54-48fb-906d-a5b6b5437db8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BertottiRobinsonSolution\"\>", ",", "\<\"ElectroVacTypeD\"\>", 
   ",", "\<\"Friedmann\"\>", ",", "\<\"FarnsworthKerrI\"\>", 
   ",", "\<\"FarnsworthKerrII\"\>", ",", "\<\"FarnsworthKerrIII\"\>", 
   ",", "\<\"GeneralSphericalSymmetry\"\>", 
   ",", "\<\"GeneralSzekeresSzafron\"\>", ",", "\<\"KantowskiSachs\"\>", 
   ",", "\<\"KasnerI\"\>", ",", "\<\"KasnerII\"\>", ",", "\<\"KasnerIII\"\>", 
   ",", "\<\"Kerr\"\>", ",", "\<\"KerrNUT\"\>", ",", "\<\"LemaitreTolman\"\>",
    ",", "\<\"TaubI\"\>", ",", "\<\"TaubII\"\>", 
   ",", "\<\"ThermodynamicStephani\"\>", ",", "\<\"OsvathKoutrasI\"\>", 
   ",", "\<\"OsvathKoutrasII\"\>", ",", "\<\"OsvathKoutrasIII\"\>", 
   ",", "\<\"PetrovSolution\"\>", ",", "\<\"PPWave\"\>", 
   ",", "\<\"ReissnerNordstrom\"\>", ",", "\<\"Schwarzschild\"\>", 
   ",", "\<\"Stephani\"\>", ",", "\<\"StephaniThermodynamic\"\>", 
   ",", "\<\"StephaniThermodynamicSpherical\"\>", 
   ",", "\<\"SzekeresSzafronI\"\>", ",", "\<\"SzekeresSzafronII\"\>", 
   ",", "\<\"Wills\"\>", ",", "\<\"WindmillI\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1162197456,ExpressionUUID->"02a773d7-50a1-4421-8821-1074d942fe9c"]
}, Open  ]],

Cell["Pick one of the exact solutions and query its properties:", \
"ExampleText",
 CellID->765471262,ExpressionUUID->"5bde9d0a-c9e7-4e5b-ad8e-d663d88683c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Kerr\>\"", ",", "\"\<Properties\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->605461210,ExpressionUUID->"3d185ee4-6aca-4dc5-a9ac-e21f0200e2e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Classes\"\>", ",", "\<\"CoordinateAssumptions\"\>", 
   ",", "\<\"CoordinateNames\"\>", ",", "\<\"CoordinateSystemName\"\>", 
   ",", "\<\"CoordinateSystems\"\>", ",", "\<\"IsIDEAL\"\>", 
   ",", "\<\"Metric\"\>", ",", "\<\"ParameterAssumptions\"\>", 
   ",", "\<\"ParameterNames\"\>", ",", "\<\"ScalarFunctionValues\"\>", 
   ",", "\<\"ScalarFunctionNames\"\>", ",", "\<\"SignatureOfMetric\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1159803934,ExpressionUUID->"75799e66-1559-4693-aaa4-442e8f690f6f"]
}, Open  ]],

Cell["These are the classes this solution belongs to:", "ExampleText",
 CellID->145811587,ExpressionUUID->"0c5d5d64-1bba-415b-9ac5-5c0f0558410f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Kerr\>\"", ",", "\"\<Classes\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->766243994,ExpressionUUID->"f7fc90f2-4891-4bf7-ad8b-7833cc326e90"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DMetrics\"\>", ",", "\<\"PetrovTypeD\"\>", 
   ",", "\<\"AxialSymmetry\"\>", ",", "\<\"Vacuum\"\>", 
   ",", "\<\"Stationary\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->881625832,ExpressionUUID->"b3ae452e-0edc-4c6a-a576-3016927c0dc7"]
}, Open  ]],

Cell["\<\
We can select one of these classes and display the exact solutions it \
contains:\
\>", "ExampleText",
 CellID->512540497,ExpressionUUID->"0e3928dd-66f2-49b1-8636-5837a8636e90"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", "\"\<DMetrics\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",
 CellID->186456889,ExpressionUUID->"93c6e691-cee0-4b4f-8241-9fca272aaeed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"FarnsworthKerrIII\"\>", 
   ",", "\<\"GeneralSphericalSymmetry\"\>", ",", "\<\"Kerr\"\>", 
   ",", "\<\"KerrNUT\"\>", ",", "\<\"LemaitreTolman\"\>", 
   ",", "\<\"ReissnerNordstrom\"\>"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->1539567378,ExpressionUUID->"145e4908-d899-482a-9ea8-6e9cb4a00788"]
}, Open  ]],

Cell["Default coordinate system for the Kerr solution:", "ExampleText",
 CellID->1654332481,ExpressionUUID->"7ec36462-b48f-4cd5-9edc-6e0f6a4d0a9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", "\"\<Kerr\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[5]:=",
 CellID->983525746,ExpressionUUID->"7f2781ed-355c-488a-91cb-f8ffc7b5bf0f"],

Cell[BoxData[
 RowBox[{"{", "\<\"BoyerLindquistCoordinates\"\>", "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->999434145,ExpressionUUID->"f117045f-6543-40a3-bb06-c67018cb2f4b"]
}, Open  ]],

Cell["\<\
To work in these coordinates, we need the names of the coordinates, the names \
of the parameters (if any) and the names of the scalar functions (if any):\
\>", "ExampleText",
 CellID->2139715476,ExpressionUUID->"75034fb1-c456-4e52-b14c-3ae2dfbaeae3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Kerr\>\"", ",", "\"\<CoordinateNames\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[6]:=",
 CellID->747039788,ExpressionUUID->"c4cdc9a2-cb29-4eda-a25f-1b56c79a65cc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"t\"\>", ",", "\<\"r\"\>", ",", "\<\"\[Theta]\"\>", 
   ",", "\<\"\[Phi]\"\>"}], "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->963632969,ExpressionUUID->"c551106b-8e91-424a-ab0e-3bd58fb822ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Kerr\>\"", ",", "\"\<ParameterNames\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[7]:=",
 CellID->2076562432,ExpressionUUID->"a4548daa-7ccc-4778-9761-11ba9fea0298"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"m\"\>", ",", "\<\"a\"\>"}], "}"}]], "Output",
 CellLabel->"Out[7]=",
 CellID->831633551,ExpressionUUID->"2cc93b75-b60c-4f2b-ac26-acd9018592f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Kerr\>\"", ",", "\"\<ScalarFunctionNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[8]:=",
 CellID->1844538083,ExpressionUUID->"2cd04f90-1634-4077-87b9-33b27f5bd9ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[CapitalSigma]\"\>", ",", "\<\"\[CapitalDelta]\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->2110556507,ExpressionUUID->"3c7b1190-d314-4cca-81c5-84be0ba36711"]
}, Open  ]],

Cell["\<\
We may also need to extract the values of the scalar functions in the default \
Boyer-Lindquist coordinates. This is a list of functions whose first argument \
is the list of coordinates and the second argument the list of parameters (if \
any):\
\>", "ExampleText",
 CellID->1041180973,ExpressionUUID->"f3964183-efc1-48e5-8c56-03ffdd95071e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xActSolutionData", "[", 
   RowBox[{"\"\<Kerr\>\"", ",", "\"\<ScalarFunctionValues\>\""}], "]"}], "[", 
  
  RowBox[{
   RowBox[{"xActSolutionData", "[", 
    RowBox[{"\"\<Kerr\>\"", ",", "\"\<CoordinateNames\>\""}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"xActSolutionData", "[", 
    RowBox[{"\"\<Kerr\>\"", ",", "\"\<ParameterNames\>\""}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[9]:=",
 CellID->457000053,ExpressionUUID->"a1c16587-16bb-471c-86a4-d96b6039f906"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\<\"r\"\>", "2"], "+", 
    RowBox[{
     SuperscriptBox["\<\"a\"\>", "2"], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         ShowAutoStyles->False,
         AutoSpacing->False],
        Cos,
        Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}]}], ",", 
   RowBox[{
    SuperscriptBox["\<\"a\"\>", "2"], "-", 
    RowBox[{"2", " ", "\<\"m\"\>", " ", "\<\"r\"\>"}], "+", 
    SuperscriptBox["\<\"r\"\>", "2"]}]}], "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->1752938102,ExpressionUUID->"211ace30-e327-43c3-ba79-cc1ebe8f33b8"]
}, Open  ]],

Cell["\<\
We can now display the metric tensor in these coordinates. Again this is a \
matrix of functions whose first argument is the coordinate list, whose second \
argument is the parameter list and whose third argument is the scalar \
functions list:\
\>", "ExampleText",
 CellID->1647306824,ExpressionUUID->"b37429e7-d3d4-4ae3-a557-a530bec6bf74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xActSolutionData", "[", 
    RowBox[{"\"\<Kerr\>\"", ",", "\"\<Metric\>\""}], "]"}], "[", 
   RowBox[{
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Kerr\>\"", ",", "\"\<CoordinateNames\>\""}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Kerr\>\"", ",", "\"\<ParameterNames\>\""}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Kerr\>\"", ",", "\"\<ScalarFunctionNames\>\""}], "]"}]}], 
   "\[IndentingNewLine]", "]"}], "//", "MatrixForm"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[10]:=",
 CellID->1160374838,ExpressionUUID->"017143cc-7647-4ca4-9fd3-096faf249735"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox[
        RowBox[{"2", " ", "\<\"m\"\>", " ", "\<\"r\"\>"}], 
        RowBox[{"\<\"\[CapitalSigma]\"\>", "[", 
         RowBox[{"\<\"r\"\>", ",", "\<\"a\"\>", ",", "\<\"\[Theta]\"\>"}], 
         "]"}]]}], "0", "0", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "\<\"a\"\>", " ", "\<\"m\"\>", " ", "\<\"r\"\>", " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}], 
        RowBox[{"\<\"\[CapitalSigma]\"\>", "[", 
         RowBox[{"\<\"r\"\>", ",", "\<\"a\"\>", ",", "\<\"\[Theta]\"\>"}], 
         "]"}]]}]},
     {"0", 
      FractionBox[
       RowBox[{"\<\"\[CapitalSigma]\"\>", "[", 
        RowBox[{"\<\"r\"\>", ",", "\<\"a\"\>", ",", "\<\"\[Theta]\"\>"}], 
        "]"}], 
       RowBox[{"\<\"\[CapitalDelta]\"\>", "[", 
        RowBox[{"\<\"r\"\>", ",", "\<\"m\"\>", ",", "\<\"a\"\>"}], "]"}]], 
      "0", "0"},
     {"0", "0", 
      RowBox[{"\<\"\[CapitalSigma]\"\>", "[", 
       RowBox[{"\<\"r\"\>", ",", "\<\"a\"\>", ",", "\<\"\[Theta]\"\>"}], 
       "]"}], "0"},
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "\<\"a\"\>", " ", "\<\"m\"\>", " ", "\<\"r\"\>", " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}], 
        RowBox[{"\<\"\[CapitalSigma]\"\>", "[", 
         RowBox[{"\<\"r\"\>", ",", "\<\"a\"\>", ",", "\<\"\[Theta]\"\>"}], 
         "]"}]]}], "0", "0", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Sin,
          Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\<\"a\"\>", "2"], "+", 
         SuperscriptBox["\<\"r\"\>", "2"], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["\<\"a\"\>", "2"], " ", "\<\"m\"\>", 
           " ", "\<\"r\"\>", " ", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox["Sin",
               ShowAutoStyles->False,
               AutoSpacing->False],
              Sin,
              Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}], 
          RowBox[{"\<\"\[CapitalSigma]\"\>", "[", 
           RowBox[{"\<\"r\"\>", ",", "\<\"a\"\>", ",", "\<\"\[Theta]\"\>"}], 
           "]"}]]}], ")"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[10]//MatrixForm=",
 CellID->1485848233,ExpressionUUID->"1ce0125f-fbe4-499d-8725-de4637459aa3"]
}, Open  ]],

Cell["\<\
Also we can display the metric tensor with all the scalar functions replaced \
by their explicit values: \
\>", "ExampleText",
 CellID->314682110,ExpressionUUID->"ba13fa44-8933-4a5b-a944-3eb6956c478f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xActSolutionData", "[", 
    RowBox[{"\"\<Kerr\>\"", ",", "\"\<Metric\>\""}], "]"}], "[", 
   RowBox[{
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Kerr\>\"", ",", "\"\<CoordinateNames\>\""}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Kerr\>\"", ",", "\"\<ParameterNames\>\""}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "@", 
     RowBox[{"xActSolutionData", "[", 
      RowBox[{"\"\<Kerr\>\"", ",", "\"\<ScalarFunctionNames\>\""}], "]"}]}]}],
    "\[IndentingNewLine]", "]"}], "//", "MatrixForm"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[11]:=",
 CellID->1694185590,ExpressionUUID->"a1480860-3955-4a8e-b07b-0e3a064e4193"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox[
        RowBox[{"2", " ", "\<\"m\"\>", " ", "\<\"r\"\>"}], 
        RowBox[{
         SuperscriptBox["\<\"r\"\>", "2"], "+", 
         RowBox[{
          SuperscriptBox["\<\"a\"\>", "2"], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}]}]]}], 
      "0", "0", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "\<\"a\"\>", " ", "\<\"m\"\>", " ", "\<\"r\"\>", " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}], 
        RowBox[{
         SuperscriptBox["\<\"r\"\>", "2"], "+", 
         RowBox[{
          SuperscriptBox["\<\"a\"\>", "2"], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}]}]]}]},
     {"0", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\<\"r\"\>", "2"], "+", 
        RowBox[{
         SuperscriptBox["\<\"a\"\>", "2"], " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Cos,
            Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}]}], 
       RowBox[{
        SuperscriptBox["\<\"a\"\>", "2"], "-", 
        RowBox[{"2", " ", "\<\"m\"\>", " ", "\<\"r\"\>"}], "+", 
        SuperscriptBox["\<\"r\"\>", "2"]}]], "0", "0"},
     {"0", "0", 
      RowBox[{
       SuperscriptBox["\<\"r\"\>", "2"], "+", 
       RowBox[{
        SuperscriptBox["\<\"a\"\>", "2"], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Cos,
           Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}]}], "0"},
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "\<\"a\"\>", " ", "\<\"m\"\>", " ", "\<\"r\"\>", " ", 
         SuperscriptBox[
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             ShowAutoStyles->False,
             AutoSpacing->False],
            Sin,
            Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}], 
        RowBox[{
         SuperscriptBox["\<\"r\"\>", "2"], "+", 
         RowBox[{
          SuperscriptBox["\<\"a\"\>", "2"], " ", 
          SuperscriptBox[
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              ShowAutoStyles->False,
              AutoSpacing->False],
             Cos,
             Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}]}]]}], 
      "0", "0", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Sin,
          Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\<\"a\"\>", "2"], "+", 
         SuperscriptBox["\<\"r\"\>", "2"], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["\<\"a\"\>", "2"], " ", "\<\"m\"\>", 
           " ", "\<\"r\"\>", " ", 
           SuperscriptBox[
            RowBox[{
             InterpretationBox[
              StyleBox["Sin",
               ShowAutoStyles->False,
               AutoSpacing->False],
              Sin,
              Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}], 
          RowBox[{
           SuperscriptBox["\<\"r\"\>", "2"], "+", 
           RowBox[{
            SuperscriptBox["\<\"a\"\>", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              InterpretationBox[
               StyleBox["Cos",
                ShowAutoStyles->False,
                AutoSpacing->False],
               Cos,
               Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}]}]]}], 
        ")"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[11]//MatrixForm=",
 CellID->205241860,ExpressionUUID->"02585814-435a-4df3-879b-5e37aa8b422e"]
}, Open  ]],

Cell["\<\
Exact solutions may have more than one available coordinate system: \
\>", "ExampleText",
 CellID->1193162250,ExpressionUUID->"4b16cd90-38de-4f51-aa12-9afd4ec19f6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", "\"\<Schwarzschild\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[12]:=",
 CellID->1215793266,ExpressionUUID->"96d1cc59-1fe6-4c39-a0e8-829dc43a4513"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"SchwarzschildCoordinates\"\>", 
   ",", "\<\"IsotropicCoordinates\"\>", ",", "\<\"HarmonicCoordinates\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[12]=",
 CellID->724362671,ExpressionUUID->"2d93291c-5345-4459-8a65-f7cf8b885cfc"]
}, Open  ]],

Cell["\<\
If no coordinate system is specified, the default one is assumed which always \
is the first one of the list:\
\>", "ExampleText",
 CellID->675823636,ExpressionUUID->"9a826388-a0c1-487a-9f13-867c92976fa4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<CoordinateNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[13]:=",
 CellID->527315707,ExpressionUUID->"055bfc42-0e21-4d91-96d9-fee00f1b18eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"t\"\>", ",", "\<\"r\"\>", ",", "\<\"\[Theta]\"\>", 
   ",", "\<\"\[Phi]\"\>"}], "}"}]], "Output",
 CellLabel->"Out[13]=",
 CellID->2094429361,ExpressionUUID->"d117982a-5a3f-43ef-9d9e-8349b596d2a6"]
}, Open  ]],

Cell["Metric in the default coordinate system:", "ExampleText",
 CellID->1118380814,ExpressionUUID->"4ea511d5-351b-4517-a695-e8210c6c312d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xActSolutionData", "[", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<Metric\>\""}], "]"}], "[", 
   RowBox[{
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<CoordinateNames\>\""}], "]"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<ParameterNames\>\""}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<ScalarFunctionNames\>\""}], 
     "]"}]}], "\[IndentingNewLine]", "]"}], "//", "MatrixForm"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[14]:=",
 CellID->1884676213,ExpressionUUID->"2ec5dbf0-17f5-4be8-bf78-57dcaf041733"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox[
        RowBox[{"2", " ", "\<\"m\"\>"}], "\<\"r\"\>"]}], "0", "0", "0"},
     {"0", 
      FractionBox["1", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"2", " ", "\<\"m\"\>"}], "\<\"r\"\>"]}]], "0", "0"},
     {"0", "0", 
      SuperscriptBox["\<\"r\"\>", "2"], "0"},
     {"0", "0", "0", 
      RowBox[{
       SuperscriptBox["\<\"r\"\>", "2"], " ", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Sin,
          Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[14]//MatrixForm=",
 CellID->1498430464,ExpressionUUID->"23b8c556-d6da-4551-b327-b8e0a7e00dad"]
}, Open  ]],

Cell["\<\
Since the Schwarzschild coordinates have no scalar functions then the \
corresponding argument may be replaced by an empty list:\
\>", "ExampleText",
 CellID->369627294,ExpressionUUID->"50ce5f81-85d3-4bd9-86b3-87b862d3ee0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xActSolutionData", "[", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<Metric\>\""}], "]"}], "[", 
   RowBox[{
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<CoordinateNames\>\""}], "]"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"xActSolutionData", "[", 
     RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<ParameterNames\>\""}], "]"}], 
    ",", 
    RowBox[{"{", "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[15]:=",
 CellID->29398679,ExpressionUUID->"b2a1239b-0f8a-4931-bce4-82c3f68a7124"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox[
        RowBox[{"2", " ", "\<\"m\"\>"}], "\<\"r\"\>"]}], "0", "0", "0"},
     {"0", 
      FractionBox["1", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"2", " ", "\<\"m\"\>"}], "\<\"r\"\>"]}]], "0", "0"},
     {"0", "0", 
      SuperscriptBox["\<\"r\"\>", "2"], "0"},
     {"0", "0", "0", 
      RowBox[{
       SuperscriptBox["\<\"r\"\>", "2"], " ", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           ShowAutoStyles->False,
           AutoSpacing->False],
          Sin,
          Editable->False], "[", "\<\"\[Theta]\"\>", "]"}], "2"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[15]//MatrixForm=",
 CellID->1177418731,ExpressionUUID->"90a572ff-2253-442e-81dd-355c0909ba95"]
}, Open  ]],

Cell["\<\
Let us pick up the isotropic coordinates for the Schwarzschild solution and \
extract coordinates, parameters and scalar functions. Since we are not \
working with the default Schwarzschild coordinates, we need to specify the \
chosen coordinates at each step:\
\>", "ExampleText",
 CellID->2128620423,ExpressionUUID->"1366e0ab-3505-4962-bd6a-0ffc3a5e0efc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
    "}"}], ",", "\"\<CoordinateNames\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[16]:=",
 CellID->960006848,ExpressionUUID->"82dccf2c-366b-49f9-a675-5896e717349c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"t\"\>", ",", "\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}],
   "}"}]], "Output",
 CellLabel->"Out[16]=",
 CellID->661691039,ExpressionUUID->"a7d67658-28a7-4b90-b0cf-42c0ca10f475"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
    "}"}], ",", "\"\<ParameterNames\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[17]:=",
 CellID->936214639,ExpressionUUID->"9bfc3197-ed15-4d2e-9f70-042e7f12e7a8"],

Cell[BoxData[
 RowBox[{"{", "\<\"m\"\>", "}"}]], "Output",
 CellLabel->"Out[17]=",
 CellID->1888535667,ExpressionUUID->"ae987c28-0f7e-467a-baf3-01c374e1733a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
    "}"}], ",", "\"\<ScalarFunctionNames\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[18]:=",
 CellID->1117869723,ExpressionUUID->"5fa1a79b-aa47-4fa9-881b-8673241af52c"],

Cell[BoxData[
 RowBox[{"{", "\<\"R\"\>", "}"}]], "Output",
 CellLabel->"Out[18]=",
 CellID->152909354,ExpressionUUID->"70487e21-0eab-4238-8dd9-319f81f19f07"]
}, Open  ]],

Cell["\<\
The explicit restrictions on the coordinates are (again these are functions \
whose first argument is the coordinate list, whose second argument is the \
parameter list and whose third argument is the scalar functions list: :\
\>", "ExampleText",
 CellID->253567167,ExpressionUUID->"b964f614-d2c0-4786-96ce-539e922fac2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xActSolutionData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
     "}"}], ",", "\"\<CoordinateAssumptions\>\""}], "]"}], "[", 
  RowBox[{
   RowBox[{"xActSolutionData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
      "}"}], ",", "\"\<CoordinateNames\>\""}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"xActSolutionData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
      "}"}], ",", "\"\<ParameterNames\>\""}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"xActSolutionData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
      "}"}], ",", "\"\<ScalarFunctionNames\>\""}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[19]:=",
 CellID->2051281499,ExpressionUUID->"5d859b89-8536-4915-8570-4f9a36b8a55a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\<\"m\"\>", "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"\<\"R\"\>", "[", 
    RowBox[{"\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], "]"}], ">", 
   RowBox[{"2", " ", "\<\"m\"\>"}]}]}]], "Output",
 CellLabel->"Out[19]=",
 CellID->57130853,ExpressionUUID->"8aa2e73b-f39c-4c45-b79c-9a100b58d80c"]
}, Open  ]],

Cell["The metric tensor in isotropic coordinates reads:", "ExampleText",
 CellID->1790150459,ExpressionUUID->"6f4b8da4-5345-4a52-8ea0-5d64d01aecc1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metricIsotropic", "=", 
  RowBox[{
   RowBox[{"xActSolutionData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
      "}"}], ",", "\"\<Metric\>\""}], "]"}], "[", 
   RowBox[{
    RowBox[{"xActSolutionData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}],
        "}"}], ",", "\"\<CoordinateNames\>\""}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"xActSolutionData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}],
        "}"}], ",", "\"\<ParameterNames\>\""}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"xActSolutionData", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}],
        "}"}], ",", "\"\<ScalarFunctionNames\>\""}], "]"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[20]:=",
 CellID->1671101656,ExpressionUUID->"65f1d3ea-b2f2-48e7-9dd1-494693006557"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox["\<\"m\"\>", 
           RowBox[{"2", " ", 
            RowBox[{"\<\"R\"\>", "[", 
             RowBox[{"\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], 
             "]"}]}]]}], ")"}], "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["\<\"m\"\>", 
           RowBox[{"2", " ", 
            RowBox[{"\<\"R\"\>", "[", 
             RowBox[{"\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], 
             "]"}]}]]}], ")"}], "2"]]}], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["\<\"m\"\>", 
         RowBox[{"2", " ", 
          RowBox[{"\<\"R\"\>", "[", 
           RowBox[{"\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], 
           "]"}]}]]}], ")"}], "4"], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["\<\"m\"\>", 
         RowBox[{"2", " ", 
          RowBox[{"\<\"R\"\>", "[", 
           RowBox[{"\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], 
           "]"}]}]]}], ")"}], "4"], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["\<\"m\"\>", 
         RowBox[{"2", " ", 
          RowBox[{"\<\"R\"\>", "[", 
           RowBox[{"\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], 
           "]"}]}]]}], ")"}], "4"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[20]=",
 CellID->1807943276,ExpressionUUID->"92400ab9-87f7-4e8b-add5-a59ee8bf240a"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]]]],ExpressionUUID->
  "9153e2f7-8ec7-4609-ab38-05fbf1fc1157"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"515dac6e-8240-448c-a8b6-1949c8da19d7"],
 "Explicit computations with exact solutions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount",ExpressionUUID->
  "7e3d3b8a-d042-49fd-b150-7c4d9492e632"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1575759718,ExpressionUUID->"7cb423ce-1675-4a42-a8b8-f8f0fd84ed27"],

Cell["We carry out actual computations with exact solutions:", "ExampleText",
 CellID->627613756,ExpressionUUID->"d04aabdc-686d-4d24-bb68-d2c609becb13"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->1174477421,ExpressionUUID->"f8952d3b-63da-4c44-a3e0-4e335b6d8b1f"],

Cell["\<\
Let us take the Schwarzschild solution in isotropic coordinates:\
\>", "ExampleText",
 CellID->772175812,ExpressionUUID->"e466508d-7e29-4537-a370-d7f26fb6d386"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
    "}"}], ",", "\"\<CoordinateNames\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->1767104182,ExpressionUUID->"0c6644a2-b60e-43c0-8dfd-032539b7962d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"t\"\>", ",", "\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}],
   "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1593425816,ExpressionUUID->"c38297f2-21ae-4639-828d-2541fdc3adec"]
}, Open  ]],

Cell["Define the corresponding coordinate chart:", "ExampleText",
 CellID->180962701,ExpressionUUID->"bd808789-a3b3-4124-a1aa-2a0540361c34"],

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"Is", ",", "M", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "[", "]"}], ",", 
     RowBox[{"x", "[", "]"}], ",", 
     RowBox[{"y", "[", "]"}], ",", 
     RowBox[{"z", "[", "]"}]}], "}"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->598286335,ExpressionUUID->"821d4d0c-3c85-4d1d-acac-37ce6a518a81"],

Cell["\<\
Next we define the corresponding scalar functions and parameters:\
\>", "ExampleText",
 CellID->1711626820,ExpressionUUID->"a215c7f4-0d15-49f0-8030-5d073c9b056f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
    "}"}], ",", "\"\<ScalarFunctionNames\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",
 CellID->1880489417,ExpressionUUID->"61246576-b23d-4ac9-9e9e-fd18d2f3ea48"],

Cell[BoxData[
 RowBox[{"{", "\<\"R\"\>", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->715411880,ExpressionUUID->"61c35e11-77bc-461c-8f87-a6a00f770462"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
    "}"}], ",", "\"\<ParameterNames\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[5]:=",
 CellID->89910732,ExpressionUUID->"bab687ea-98df-4266-b84a-06de5854720b"],

Cell[BoxData[
 RowBox[{"{", "\<\"m\"\>", "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->1169212898,ExpressionUUID->"9f012ee0-489b-4dee-b5f8-023914971d48"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DefScalarFunction", "[", "R", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[6]:=",
 CellID->2052448431,ExpressionUUID->"80f876d7-4f56-4885-bd48-523f01e3f72b"],

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"mass", ",", 
   RowBox[{"PrintAs", "->", "\"\<m\>\""}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[7]:=",
 CellID->704308732,ExpressionUUID->"5e129f53-35ca-4290-a189-3946260a0ca0"],

Cell["\<\
We have now all the ingredients to construct the metric tensor:\
\>", "ExampleText",
 CellID->1378926138,ExpressionUUID->"8305167c-d7f4-4680-9609-25e2428b98b1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metricIsotropic", "=", 
  RowBox[{"xActSolutionData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Schwarzschild\>\"", ",", 
      RowBox[{"\"\<IsotropicCoordinates\>\"", "->", "Is"}], ",", 
      RowBox[{"\"\<ParameterNames\>\"", "->", 
       RowBox[{"{", "mass", "}"}]}], ",", 
      RowBox[{"\"\<ScalarFunctionNames\>\"", "->", 
       RowBox[{"{", "R", "}"}]}]}], "}"}], ",", "\"\<Metric\>\""}], 
   "]"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[8]:=",
 CellID->469269385,ExpressionUUID->"a48ffd90-59d7-467c-8b58-c6c2b0d9068c"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            FractionBox[
             InterpretationBox[
              StyleBox["m",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mass,
              Editable->False], 
             RowBox[{"2", " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["z",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`z[],
                  Editable->False], "2"]}]]}]]}], ")"}], "2"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            FractionBox[
             InterpretationBox[
              StyleBox["m",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`mass,
              Editable->False], 
             RowBox[{"2", " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["x",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`x[],
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["y",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`y[],
                  Editable->False], "2"], "+", 
                SuperscriptBox[
                 InterpretationBox[
                  StyleBox["z",
                   ShowAutoStyles->False,
                   AutoSpacing->False],
                  $CellContext`z[],
                  Editable->False], "2"]}]]}]]}], ")"}], "2"]]}], ",", "0", ",",
        "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox[
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mass,
            Editable->False], 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False], "2"], "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False], "2"], "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["z",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`z[],
                Editable->False], "2"]}]]}]]}], ")"}], "4"], ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox[
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mass,
            Editable->False], 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False], "2"], "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False], "2"], "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["z",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`z[],
                Editable->False], "2"]}]]}]]}], ")"}], "4"], ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox[
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mass,
            Editable->False], 
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False], "2"], "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False], "2"], "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["z",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`z[],
                Editable->False], "2"]}]]}]]}], ")"}], "4"]}], "}"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "Is"}], ",", 
     RowBox[{"-", "Is"}]}], "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->1069457000,ExpressionUUID->"bfd4a1b9-9903-4d67-9e4c-60a40993c18d"]
}, Open  ]],

Cell["\<\
We can also construct the explicit relation between the scalar function, the \
coordinates and the parameters:\
\>", "ExampleText",
 CellID->1229376872,ExpressionUUID->"4d10925e-2715-4c05-b22a-11f194a4f546"],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarfunctions", "=", 
   RowBox[{"xActSolutionData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<IsotropicCoordinates\>\""}], 
      "}"}], ",", "\"\<ScalarFunctionValues\>\""}], "]"}]}], ";"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[9]:=",
 CellID->1342131151,ExpressionUUID->"dad72cd8-6e8e-4541-8822-9ce305f671ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"scalarfunctions", "[", 
  RowBox[{
   RowBox[{"ScalarsOfChart", "[", "Is", "]"}], ",", 
   RowBox[{"{", "mass", "}"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[10]:=",
 CellID->313793529,ExpressionUUID->"041bec57-1b02-422b-909d-209f25042e53"],

Cell[BoxData[
 RowBox[{"{", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["x",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`x[],
      Editable->False], "2"], "+", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["y",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`y[],
      Editable->False], "2"], "+", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["z",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`z[],
      Editable->False], "2"]}]], "}"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->879599042,ExpressionUUID->"f9183390-42fb-4a99-bbe3-aaeb6b32ec8c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Rule", ",", 
   RowBox[{"xActSolutionData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<HarmonicCoordinates\>\""}], 
      "}"}], ",", "\"\<ScalarFunctionNames\>\""}], "]"}], ",", 
   RowBox[{"scalarfunctions", "[", 
    RowBox[{
     RowBox[{"ScalarsOfChart", "[", "Is", "]"}], ",", 
     RowBox[{"{", "mass", "}"}]}], "]"}], ",", "List"}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[11]:=",
 CellID->1964980169,ExpressionUUID->"3bbf0610-3969-4aa1-98e6-a634f6bf0623"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"R\"\>", "\[Rule]", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["x",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`x[],
       Editable->False], "2"], "+", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["y",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`y[],
       Editable->False], "2"], "+", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["z",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`z[],
       Editable->False], "2"]}]]}], "}"}]], "Output",
 CellLabel->"Out[11]=",
 CellID->2115788446,ExpressionUUID->"24a9e0b7-5639-4f87-a335-6b43396d0225"]
}, Open  ]],

Cell["Now we compute the Ricci tensor. As expected it vanishes:", \
"ExampleText",
 CellID->882573653,ExpressionUUID->"7c6d56f3-6314-486d-a460-0670f2c25305"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RicciIsotropic", "=", 
  RowBox[{"xActSolutionData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Schwarzschild\>\"", ",", 
      RowBox[{"\"\<IsotropicCoordinates\>\"", "->", "Is"}], ",", 
      RowBox[{"\"\<ParameterNames\>\"", "->", 
       RowBox[{"{", "mass", "}"}]}], ",", 
      RowBox[{"\"\<ScalarFunctionNames\>\"", "->", 
       RowBox[{"{", "R", "}"}]}]}], "}"}], ",", "\"\<Ricci\>\"", ",", 
    RowBox[{"Verbose", "->", "True"}], ",", 
    RowBox[{"Parallelize", "->", "True"}]}], "]"}]}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[12]:=",
 CellID->314270606,ExpressionUUID->"f641fe49-8a67-402f-935b-fdb824312fcb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->283057013,ExpressionUUID->"643cd05f-d260-4519-bd09-d8f1e9dc013e"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1162895898,ExpressionUUID->"457f6d7b-1c67-4fd7-950c-4dbdf613c6b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->840787806,ExpressionUUID->"45a48451-8b09-4abc-860d-87b08eaa84ea"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1662107411,ExpressionUUID->"56a93dfc-d76f-4c59-aba3-8a31aa9a39b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->320934702,ExpressionUUID->"83a8d49c-7e4c-4520-958d-03e9ab26c741"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.001084`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.001084, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1567713321,ExpressionUUID->"8c611291-1062-4a25-b95d-8828cb458c93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.091999`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.091999, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->2490664,ExpressionUUID->"eefc147e-1922-45aa-9791-52811adb8840"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->634509932,ExpressionUUID->"d9367a7d-d19c-4416-bdaa-c6e4299ead17"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1929364740,ExpressionUUID->"7d830153-1559-446e-8d7d-05b8dda687c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->452516443,ExpressionUUID->"564638d5-9cfe-4acd-9d9e-d4f4158d3a30"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->88853025,ExpressionUUID->"35dda08e-d254-4e59-b6d4-734801f4df9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1460018657,ExpressionUUID->"2ca31cb7-dabf-4989-9fde-33c4e445934e"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->2060411631,ExpressionUUID->"0d7abfda-cf79-45d2-8006-3d5e90d176c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1560572553,ExpressionUUID->"52f3476f-6a77-4ab6-8f07-cccffc6e34c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.001797`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.001797, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1123297694,ExpressionUUID->"af478b32-239b-4238-ae3d-3fc16a0fe927"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.057663`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.057663, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1171434293,ExpressionUUID->"1681df4a-b120-46b5-9315-2be2e7a0c5ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.002257`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", 
   "161792", "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.002257, " seconds and ", 161792, " bytes"],
  
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->336781630,ExpressionUUID->"040ac977-2188-4cc1-aa6f-9dc1db66f74e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->950763892,ExpressionUUID->"9652f0c1-26bd-4058-9d47-73ae1930679f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.003721`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.003721, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1229032503,ExpressionUUID->"64b9f279-a9af-48a9-821f-6da4f3c03410"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.074277`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.074277, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->158389721,ExpressionUUID->"bdaab01c-8c47-43d0-ac53-c5787b7a8b27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.002367`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", 
   "160640", "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.002367, " seconds and ", 160640, " bytes"],
  
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1657829133,ExpressionUUID->"fd2c4c05-5a14-4cd7-8d18-1a16528bc3fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->1254935512,ExpressionUUID->"a9602cc1-a78e-4d1e-9262-f6f10d4e3e51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000276`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000276, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->128923853,ExpressionUUID->"961eab00-3d66-4884-bcc8-fc5099ff1311"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.030637`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.030637, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->105222840,ExpressionUUID->"654fb3d2-73ef-481c-a469-3a4a843414b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000258`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000258, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->717704907,ExpressionUUID->"ce610a25-b1a7-4447-8f4c-4142029cc25a"]
}, Open  ]],

Cell[BoxData["Zero"], "Output",
 CellLabel->"Out[12]=",
 CellID->1439764459,ExpressionUUID->"a9af63ea-a0d9-467f-a5e0-f938b0005be4"]
}, Open  ]],

Cell[TextData[{
 "These are the objects that can be currently computed with ",
 StyleBox["xActSolutionData ", "Input"],
 "once a coordinate system has been defined with ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->100452798,ExpressionUUID->"e3108d95-7e4c-4e93-8452-ad16ab8fa7ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", 
     RowBox[{"\"\<IsotropicCoordinates\>\"", "->", "Is"}], ",", 
     RowBox[{"\"\<ParameterNames\>\"", "->", 
      RowBox[{"{", "mass", "}"}]}], ",", 
     RowBox[{"\"\<ScalarFunctionNames\>\"", "->", 
      RowBox[{"{", "R", "}"}]}]}], "}"}], ",", "\"\<Properties\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[13]:=",
 CellID->1553958542,ExpressionUUID->"b42cbe27-3e94-4ad5-ba6b-91549dc7647f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Metric\"\>", ",", "\<\"Christoffel\"\>", 
   ",", "\<\"Riemann\"\>", ",", "\<\"Weyl\"\>", ",", "\<\"Ricci\"\>", 
   ",", "\<\"Einstein\"\>"}], "}"}]], "Output",
 CellLabel->"Out[13]=",
 CellID->592542694,ExpressionUUID->"7d086395-8709-4bfb-b419-c44ba5247a07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "81eac913-0851-4d34-b3a2-bea13ee93657"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1006782030,ExpressionUUID->"92d0bd85-0e5c-403a-85c3-383cbe2d7472"],

Cell["\<\
Another example: the same Schwarzschild solution but now in the default \
Schwarzschild coordinates:\
\>", "ExampleText",
 CellID->1950229257,ExpressionUUID->"d8c4932b-f3c8-4ab1-a581-589578012ae4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->739398804,ExpressionUUID->"15a0550c-e150-4f00-a95e-863f80659012"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<CoordinateNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->1614799796,ExpressionUUID->"ece31abb-6647-4b24-b22e-fbce823b905d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"t\"\>", ",", "\<\"r\"\>", ",", "\<\"\[Theta]\"\>", 
   ",", "\<\"\[Phi]\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->846446184,ExpressionUUID->"615933b5-1878-4fd7-b61f-bc113cdaf283"]
}, Open  ]],

Cell["Define the corresponding coordinate chart:", "ExampleText",
 CellID->744331517,ExpressionUUID->"c71767df-8cba-4189-a031-875e848325ce"],

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"Sch", ",", "M", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "[", "]"}], ",", 
     RowBox[{"r", "[", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->1754000017,ExpressionUUID->"149ae47f-2f90-4ec9-b5ca-9fcc97c37fab"],

Cell["\<\
Next we define the corresponding scalar functions and parameters:\
\>", "ExampleText",
 CellID->173144395,ExpressionUUID->"b9ec8d12-3999-4380-8e60-497206c84d7b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<ParameterNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",
 CellID->676263427,ExpressionUUID->"7b2b5430-4df9-4987-865a-fb7db1172206"],

Cell[BoxData[
 RowBox[{"{", "\<\"m\"\>", "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->1929557848,ExpressionUUID->"0e3cb6fa-a9a5-46f3-a4e4-9e52de70525d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"mass", ",", 
   RowBox[{"PrintAs", "->", "\"\<m\>\""}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[5]:=",
 CellID->264605598,ExpressionUUID->"be4349cb-47f3-4201-8b2d-02a9b0b2e214"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", 
     RowBox[{"\"\<SchwarzschildCoordinates\>\"", "->", "Sch"}], ",", 
     RowBox[{"\"\<ParameterNames\>\"", "->", 
      RowBox[{"{", "mass", "}"}]}]}], "}"}], ",", "\"\<Metric\>\"", ",", 
   RowBox[{"Parallelize", "->", "True"}], ",", 
   RowBox[{"Verbose", "->", "True"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[6]:=",
 CellID->1859794150,ExpressionUUID->"f1b9e49e-2c17-44cc-8640-5aa8631c2fab"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox["m",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`mass,
           Editable->False]}], 
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False]]}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox["m",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`mass,
            Editable->False]}], 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False]]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       SuperscriptBox[
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "2"], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{
        SuperscriptBox[
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "2"], " ", 
        SuperscriptBox[
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            ShowAutoStyles->False,
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}], "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "Sch"}], ",", 
     RowBox[{"-", "Sch"}]}], "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->1407002681,ExpressionUUID->"fb88983c-1338-475c-a229-7229628f2067"]
}, Open  ]],

Cell["We run a similar computation as above:", "ExampleText",
 CellID->1564574589,ExpressionUUID->"d7ed1101-f5fb-4d77-ab18-cddcc323bb04"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Schwarzschild\>\"", ",", 
     RowBox[{"\"\<SchwarzschildCoordinates\>\"", "->", "Sch"}], ",", 
     RowBox[{"\"\<ParameterNames\>\"", "->", 
      RowBox[{"{", "mass", "}"}]}]}], "}"}], ",", "\"\<Ricci\>\"", ",", 
   RowBox[{"Parallelize", "->", "True"}], ",", 
   RowBox[{"Verbose", "->", "True"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[7]:=",
 CellID->63816491,ExpressionUUID->"efe30895-39e6-4b82-b5ca-462cf5911c10"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1332239541,ExpressionUUID->"143ddbef-8c57-4b9a-89bf-2ee1eb52b561"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1802969734,ExpressionUUID->"6838a84b-dd2b-411f-a498-f3c0375bed37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->465222075,ExpressionUUID->"bf0520c7-eea8-4f4f-a2ad-1b91b413903f"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1843059213,ExpressionUUID->"685309ce-d4ae-4d7f-8a57-c399d12dbf04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1398762266,ExpressionUUID->"fea26a98-2c11-41f8-82d0-9106e0281c24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000608`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000608, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->848861383,ExpressionUUID->"5f4c8f28-fb44-4dfa-9b98-9916d97a82a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.025178`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.025178, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->450185254,ExpressionUUID->"7a925560-b3e8-4e5c-8a83-90c50f3637d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1453896655,ExpressionUUID->"0484b224-29f4-4f3c-8cd6-440c50564e87"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1088729128,ExpressionUUID->"d8b17088-b25c-4e3e-b640-7eeabffe7fb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->36406164,ExpressionUUID->"a8d145c0-2bbc-4e81-a5fa-576e6342f3b7"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1779397693,ExpressionUUID->"79290c43-6c33-434e-b5b7-5e9dfb9f89b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1157864263,ExpressionUUID->"4470e1c4-216b-4a35-842a-c32b24fddfd7"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->273739226,ExpressionUUID->"621f55c1-2154-4e3b-aff6-4b1bc8e8f096"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1223891163,ExpressionUUID->"c50f9684-6bb6-4952-a008-d3442307680f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000769`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000769, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1726660191,ExpressionUUID->"b2a87729-22e5-4778-8a91-5f0001833e6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.021391`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.021391, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1152462313,ExpressionUUID->"d4e558dd-686d-42ed-a7e6-c57dde500f15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000901`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "15040",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000901, " seconds and ", 15040, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1002391986,ExpressionUUID->"bd7dccb9-40ac-4d2b-ae88-e1b75a480dab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1878061810,ExpressionUUID->"64f2ad81-72a8-4e0e-a354-0587fe2a67e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.002255`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.002255, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1030409548,ExpressionUUID->"14a974b8-eb65-4da9-a2d1-63942148e475"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.022752`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.022752, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->814810312,ExpressionUUID->"edb88029-0b97-41c0-b6d1-0f9b0010b503"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.00086`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "14432",
    "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.00086, " seconds and ", 14432, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1559446990,ExpressionUUID->"ae9f6fac-46b8-4a98-a458-17c200477261"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->521259256,ExpressionUUID->"9820ecb6-5baa-4388-a053-1e748b0e859d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000158`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000158, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->709727060,ExpressionUUID->"84d5e8f4-f053-431f-a867-2a938308a644"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.022554`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.022554, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->2008826732,ExpressionUUID->"395f26ef-b381-4eea-92cb-bc23fcc2c4cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.00018`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.00018, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->478856958,ExpressionUUID->"6e553553-72e4-4ed6-9e72-32f022028e46"]
}, Open  ]],

Cell[BoxData["Zero"], "Output",
 CellLabel->"Out[7]=",
 CellID->510558652,ExpressionUUID->"3a6428fb-2bc7-426d-bc32-3b780b9dcef5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "\t", "ExampleDelimiter",ExpressionUUID->
   "d461ab3b-cf33-47a2-8f39-f221de185ea8"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26560194,ExpressionUUID->"9aeb7b1a-9997-489d-a32a-a3619a4ee184"],

Cell["We finally consider the KerrNUT solution:", "ExampleText",
 CellID->1428433302,ExpressionUUID->"dbeeea31-8b2a-489e-9e90-acd8c2ca83e0"],

Cell["We follow a pattern similar to the previous two examples:", \
"ExampleText",
 CellID->1876895984,ExpressionUUID->"db27784f-2d6e-49b1-b4d7-931016773374"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefManifold", "[", 
   RowBox[{"M", ",", "4", ",", 
    RowBox[{"IndexRange", "[", 
     RowBox[{"a", ",", "n"}], "]"}]}], "]"}], ";"}]}], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->697279325,ExpressionUUID->"0804bf35-df00-43ce-a324-657072f61104"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<KerrNUT\>\"", ",", "\"\<CoordinateNames\>\""}], "]"}]], "Input",\

 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->1303076876,ExpressionUUID->"8805f8b9-038c-49b3-9803-775debda98d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"t\"\>", ",", "\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}],
   "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->906298517,ExpressionUUID->"80528df2-9548-41b2-b041-dbe3143caa51"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"Ex", ",", "M", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "[", "]"}], ",", 
     RowBox[{"x", "[", "]"}], ",", 
     RowBox[{"y", "[", "]"}], ",", 
     RowBox[{"z", "[", "]"}]}], "}"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->1028563305,ExpressionUUID->"fbcbe1c9-51bc-429c-ac3d-ce8e4f324f91"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<KerrNUT\>\"", ",", "\"\<ParameterNames\>\""}], "]"}]], "Input",\

 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",
 CellID->87605643,ExpressionUUID->"2ceb5444-26c5-4055-9358-ba36c5cf6a72"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"p\"\>", ",", "\<\"k\"\>", ",", "\<\"s\"\>"}], "}"}]], "Output",\

 CellLabel->"Out[4]=",
 CellID->1661999694,ExpressionUUID->"2f9fe227-4008-4a80-adfc-bea4bd14fa09"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefConstantSymbol", "/@", 
   RowBox[{"{", 
    RowBox[{"p", ",", "kk", ",", "s"}], "}"}]}], ";"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[5]:=",
 CellID->1582813412,ExpressionUUID->"5e4c257e-3191-4c6e-b142-a180ec118887"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "kk", "]"}], "^=", "\"\<k\>\""}], ";"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[6]:=",
 CellID->1648988072,ExpressionUUID->"8a83792b-a3f0-4546-a0cb-11d8c06261c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<KerrNUT\>\"", ",", "\"\<ScalarFunctionNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[7]:=",
 CellID->2137620324,ExpressionUUID->"7401c074-77ee-48e0-bbda-f1babe081416"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[Alpha]\"\>", ",", "\<\"\[Beta]\"\>"}], "}"}]], "Output",
 CellLabel->"Out[7]=",
 CellID->383509811,ExpressionUUID->"4f3d4059-b91b-4613-8389-cabeccf6e1ea"]
}, Open  ]],

Cell["We display the scalar function values:", "ExampleText",
 CellID->1442181122,ExpressionUUID->"641ce64e-095d-4a85-9102-875c089efdfc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xActSolutionData", "[", 
   RowBox[{"\"\<KerrNUT\>\"", ",", "\"\<ScalarFunctionValues\>\""}], "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", ",", "x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "k", ",", "s"}], "}"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[8]:=",
 CellID->2106134881,ExpressionUUID->"9450cdc9-0024-4545-9901-f218c9e490b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s,
     Editable->False], "+", 
    FractionBox[
     RowBox[{"k", " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SuperscriptBox["k", "2"]}], ")"}], " ", "x"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["k", "2"]}], ")"}], "3"]], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox["p",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`p,
      Editable->False], " ", 
     SuperscriptBox["x", "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox["s",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`s,
     Editable->False], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["k", "2"]}]}], ")"}], " ", "y"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["k", "2"]}], ")"}], "3"]], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox["p",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`p,
      Editable->False], " ", 
     SuperscriptBox["y", "2"]}]}]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->2069194415,ExpressionUUID->"5ab8ef32-42eb-4c88-b85c-fd796d81d5ef"]
}, Open  ]],

Cell["Definition of the scalar functions:", "ExampleText",
 CellID->1760082945,ExpressionUUID->"101efcff-fa7e-424a-b578-8220df39bf44"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefScalarFunction", "/@", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}]}], ";"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[9]:=",
 CellID->1932626767,ExpressionUUID->"a50d0e3c-fe56-414c-b45d-dc89b06f5bf1"],

Cell["Metric tensor:", "ExampleText",
 CellID->355303852,ExpressionUUID->"42551e02-ccd9-4f06-a21f-f410530c8262"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<KerrNUT\>\"", ",", 
     RowBox[{"\"\<ExpansionGradientAdaptedCoordinates\>\"", "->", "Ex"}], ",", 
     RowBox[{"\"\<ParameterNames\>\"", "->", 
      RowBox[{"{", 
       RowBox[{"p", ",", "kk", ",", "s"}], "}"}]}], ",", " ", 
     RowBox[{"\"\<ScalarFunctionNames\>\"", "->", 
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}]}]}], "}"}], 
   ",", "\"\<Metric\>\"", ",", 
   RowBox[{"Parallelize", "->", "True"}], ",", 
   RowBox[{"Verbose", "->", "True"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[10]:=",
 CellID->354247573,ExpressionUUID->"30c41cd2-ef82-42d8-a495-2b68b959b2f5"],

Cell[BoxData[
 RowBox[{"CTensor", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s,
              Editable->False], "+", 
             FractionBox[
              RowBox[{
               InterpretationBox[
                StyleBox["k",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`kk,
                Editable->False], " ", 
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "2"]}], ")"}], " ", 
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "2"]}], ")"}], "3"]], "+", 
             RowBox[{
              InterpretationBox[
               StyleBox["p",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`p,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False], "2"]}]}], ")"}], " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False], "4"]}], "-", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s,
              Editable->False], "+", 
             FractionBox[
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`kk,
                    Editable->False], "2"]}]}], ")"}], " ", 
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "2"]}], ")"}], "3"]], "-", 
             RowBox[{
              InterpretationBox[
               StyleBox["p",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`p,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False], "2"]}]}], ")"}]}]}], 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], "2"], "+", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False], "2"]}]]}], ",", "0", ",", "0", ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s,
              Editable->False], "+", 
             FractionBox[
              RowBox[{
               InterpretationBox[
                StyleBox["k",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`kk,
                Editable->False], " ", 
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "2"]}], ")"}], " ", 
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "2"]}], ")"}], "3"]], "+", 
             RowBox[{
              InterpretationBox[
               StyleBox["p",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`p,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False], "2"]}]}], ")"}], " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False], "2"]}], "+", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s,
              Editable->False], "+", 
             FractionBox[
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`kk,
                    Editable->False], "2"]}]}], ")"}], " ", 
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "2"]}], ")"}], "3"]], "-", 
             RowBox[{
              InterpretationBox[
               StyleBox["p",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`p,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False], "2"]}]}], ")"}]}]}], 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], "2"], "+", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False], "2"]}]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["x",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`x[],
           Editable->False], "2"], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["y",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`y[],
           Editable->False], "2"]}], 
        RowBox[{
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s,
          Editable->False], "+", 
         FractionBox[
          RowBox[{
           InterpretationBox[
            StyleBox["k",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`kk,
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{"3", "-", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["k",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`kk,
               Editable->False], "2"]}], ")"}], " ", 
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["k",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`kk,
               Editable->False], "2"]}], ")"}], "3"]], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox["p",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`p,
           Editable->False], " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], "2"]}]}]], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["x",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`x[],
           Editable->False], "2"], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["y",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`y[],
           Editable->False], "2"]}], 
        RowBox[{
         InterpretationBox[
          StyleBox["s",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`s,
          Editable->False], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["k",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`kk,
                Editable->False], "2"]}]}], ")"}], " ", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["k",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`kk,
               Editable->False], "2"]}], ")"}], "3"]], "-", 
         RowBox[{
          InterpretationBox[
           StyleBox["p",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`p,
           Editable->False], " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False], "2"]}]}]], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s,
              Editable->False], "+", 
             FractionBox[
              RowBox[{
               InterpretationBox[
                StyleBox["k",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`kk,
                Editable->False], " ", 
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "2"]}], ")"}], " ", 
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "2"]}], ")"}], "3"]], "+", 
             RowBox[{
              InterpretationBox[
               StyleBox["p",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`p,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["x",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`x[],
                Editable->False], "2"]}]}], ")"}], " ", 
           SuperscriptBox[
            InterpretationBox[
             StyleBox["y",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`y[],
             Editable->False], "2"]}], "+", 
          RowBox[{
           SuperscriptBox[
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             InterpretationBox[
              StyleBox["s",
               ShowAutoStyles->False,
               AutoSpacing->False],
              $CellContext`s,
              Editable->False], "+", 
             FractionBox[
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox[
                   InterpretationBox[
                    StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`kk,
                    Editable->False], "2"]}]}], ")"}], " ", 
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  InterpretationBox[
                   StyleBox["k",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                   $CellContext`kk,
                   Editable->False], "2"]}], ")"}], "3"]], "-", 
             RowBox[{
              InterpretationBox[
               StyleBox["p",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`p,
               Editable->False], " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["y",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`y[],
                Editable->False], "2"]}]}], ")"}]}]}], 
         RowBox[{
          SuperscriptBox[
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], "2"], "+", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False], "2"]}]]}], ",", "0", ",", "0", ",", 
       FractionBox[
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            InterpretationBox[
             StyleBox["k",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`kk,
             Editable->False], " ", 
            RowBox[{"(", 
             RowBox[{"3", "-", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["k",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`kk,
                Editable->False], "2"]}], ")"}], " ", 
            InterpretationBox[
             StyleBox["x",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`x[],
             Editable->False]}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["k",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`kk,
                Editable->False], "2"]}], ")"}], "3"]]}], "-", 
         RowBox[{
          InterpretationBox[
           StyleBox["p",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`p,
           Editable->False], " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["x",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`x[],
            Editable->False], "2"]}], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox[
               InterpretationBox[
                StyleBox["k",
                 ShowAutoStyles->False,
                 AutoSpacing->False],
                $CellContext`kk,
                Editable->False], "2"]}]}], ")"}], " ", 
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox[
              InterpretationBox[
               StyleBox["k",
                ShowAutoStyles->False,
                AutoSpacing->False],
               $CellContext`kk,
               Editable->False], "2"]}], ")"}], "3"]], "-", 
         RowBox[{
          InterpretationBox[
           StyleBox["p",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`p,
           Editable->False], " ", 
          SuperscriptBox[
           InterpretationBox[
            StyleBox["y",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`y[],
            Editable->False], "2"]}]}], 
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["x",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`x[],
           Editable->False], "2"], "+", 
         SuperscriptBox[
          InterpretationBox[
           StyleBox["y",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`y[],
           Editable->False], "2"]}]]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "Ex"}], ",", 
     RowBox[{"-", "Ex"}]}], "}"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->2045617222,ExpressionUUID->"fe520329-8265-4480-8339-3c77d2fe62c9"]
}, Open  ]],

Cell["Ricci tensor: as expected it vanishes:", "ExampleText",
 CellID->973951945,ExpressionUUID->"f6050ba6-2dba-40ac-8559-e4ab21ef9328"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<KerrNUT\>\"", ",", 
     RowBox[{"\"\<ExpansionGradientAdaptedCoordinates\>\"", "->", "Ex"}], ",", 
     RowBox[{"\"\<ParameterNames\>\"", "->", 
      RowBox[{"{", 
       RowBox[{"p", ",", "kk", ",", "s"}], "}"}]}], ",", " ", 
     RowBox[{"\"\<ScalarFunctionNames\>\"", "->", 
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}]}]}], "}"}], 
   ",", "\"\<Ricci\>\"", ",", 
   RowBox[{"Parallelize", "->", "True"}], ",", 
   RowBox[{"Verbose", "->", "True"}]}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[11]:=",
 CellID->242645470,ExpressionUUID->"cbf4cf61-3d06-49c8-9c65-12285eadd9d9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Metric\"\>", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Metric"[1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1923017173,ExpressionUUID->"946ca8d7-3191-4057-a961-17c93e9a0dbd"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->2048107886,ExpressionUUID->"7d63ee4c-ab1a-48ff-a80d-1c8be5f67997"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DMetric"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->877155402,ExpressionUUID->"35c4f9d8-a75e-4c88-b328-29015061a05d"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1704898266,ExpressionUUID->"3c3e0765-ad4e-4578-a87e-6125fa6a7705"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"DDMetric\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "DDMetric"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->353140681,ExpressionUUID->"ce351a9e-ef70-42af-b286-09506cafccac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.001303`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.001303, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->966008427,ExpressionUUID->"7d7798b1-e3dd-42ac-9143-f9c23965a47f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.236077`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.236077, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1017433275,ExpressionUUID->"1abe67a8-c467-41e7-ab7c-0da2e4566f07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[-1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->266068664,ExpressionUUID->"cee65919-c128-4404-a280-552fcc9b23f6"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->379097332,ExpressionUUID->"0c5b4ddb-6a8b-4534-b3f2-9cfb79cd41ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Christoffel\"\>", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Christoffel"[1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->2140730969,ExpressionUUID->"8a5f5b9b-bc22-4150-a219-30e6b5092b71"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1437502958,ExpressionUUID->"9aa1ba59-9f7a-4950-9f55-78d7d9ebd6e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", 
   "\[InvisibleSpace]", "\<\"CovDOfMetric\"\>"}],
  SequenceForm["** ReportCompute: ", "CovDOfMetric"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->715878962,ExpressionUUID->"bcc38c45-3874-4d8d-a4ea-8e56caeaf1f7"],

Cell[BoxData["\<\"    Already cached\"\>"], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->944011214,ExpressionUUID->"036ef515-a8ff-40c5-8992-71afe9820c33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->519051813,ExpressionUUID->"58e10189-7596-4f7a-b825-15fe4d5b34e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.001409`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.001409, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->874268684,ExpressionUUID->"428d7653-13ca-4bed-a5ee-71b8361c9646"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.259329`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.259329, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->454356699,ExpressionUUID->"9fcf344f-91b7-4273-91b5-a998f5ec610b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.004557`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", 
   "366368", "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.004557, " seconds and ", 366368, " bytes"],
  
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1773987325,ExpressionUUID->"c14b9ca6-a7a9-4047-a1b1-63e588443082"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Riemann\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Riemann"[-1, -1, -1, 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->1003192537,ExpressionUUID->"2078019c-f635-4c99-b7a8-092b9003d125"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.007014`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.007014, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->559579540,ExpressionUUID->"dd91255b-8a11-4d3f-ab9b-f2c5433aa1a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.438824`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.438824, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->344208585,ExpressionUUID->"d7bdd692-98d2-4997-9ab0-c27321536e31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.003318`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", 
   "453552", "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.003318, " seconds and ", 453552, " bytes"],
  
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->295473349,ExpressionUUID->"f05622be-3ad5-4d1d-a5f1-a3ec36ed979d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** ReportCompute: \"\>", "\[InvisibleSpace]", 
   RowBox[{"\<\"Ricci\"\>", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}]}],
  SequenceForm["** ReportCompute: ", 
   "Ricci"[-1, -1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->2113538082,ExpressionUUID->"01b5c646-3859-4558-a136-6f3146cfcbe8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Constructed in \"\>", "\[InvisibleSpace]", "0.000199`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Constructed in ", 0.000199, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->936751279,ExpressionUUID->"3d4d0742-ade1-402d-a0c4-856ca285967f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Applied \"\>", "\[InvisibleSpace]", "Simplify", 
   "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]", "0.029452`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["    Applied ", Simplify, " in ", 0.029452, " seconds"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->395926147,ExpressionUUID->"c0353513-b588-4610-b92d-5abc246efc05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    Stored in \"\>", "\[InvisibleSpace]", "0.000448`", 
   "\[InvisibleSpace]", "\<\" seconds and \"\>", "\[InvisibleSpace]", "424", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["    Stored in ", 0.000448, " seconds and ", 424, " bytes"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[12]:=",
 CellID->872352952,ExpressionUUID->"6c4a2704-5a83-4fcb-9daa-b595a39277d4"]
}, Open  ]],

Cell[BoxData["Zero"], "Output",
 CellLabel->"Out[11]=",
 CellID->451267325,ExpressionUUID->"7c3cb86b-54ff-4c96-a47c-fe825c470bcd"]
}, Open  ]]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, 
  Closed]]]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  DynamicBox[ToBoxes[
    If[
     MatchQ[
      CurrentValue[
       EvaluationNotebook[], {
       TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed], 
      Alternatives[Open, True]], 
     Style[
      Graphics[{
        Thickness[0.18], 
        RGBColor[0.8509803921568627, 0.396078431372549, 0], 
        Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
       PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
      0.68 Inherited], 
     Rotate[
      Style[
       Graphics[{
         Thickness[0.18], 
         RGBColor[0.8509803921568627, 0.396078431372549, 0], 
         Line[{{-1.8, 0.5}, {0, 0}, {1.8, 0.5}}]}, AspectRatio -> 1, 
        PlotRange -> {{-3, 4}, {-1, 1}}, ImageSize -> 20], Magnification -> 
       0.68 Inherited], Rational[1, 2] Pi, {-1.65, -1}]]]]],ExpressionUUID->
  "353b3692-7c30-4f6a-a2d4-440537ddd1cf"],
 Cell[BoxData[
  TemplateBox[{1},
   "Spacer1"]],ExpressionUUID->"ae23f8bf-5eea-4f86-b6da-5ecb5dc83d90"],
 "Classification of exact solutions",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount",ExpressionUUID->
  "a49cbab4-f7e6-4fd3-8329-8bbbc6e11723"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CacheGraphics->False,
 CellID->1813521204,ExpressionUUID->"18751f84-911f-44bd-be05-5cf119f85ff4"],

Cell["This is the available list of classes:", "ExampleText",
 CellID->1959965972,ExpressionUUID->"2015bd5c-8db3-4f4b-8ac0-4322303ad75b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", "\"\<Classes\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[1]:=",
 CellID->1146987898,ExpressionUUID->"3dd409d2-389e-4efe-a070-f8beca3c4b0d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AbelianG3onT3\"\>", ",", "\<\"AxialSymmetry\"\>", 
   ",", "\<\"BarotropicPerfectFluid\"\>", ",", "\<\"ConformallyFlat\"\>", 
   ",", "\<\"ConformallyStatic\"\>", ",", "\<\"ConformallyStationary\"\>", 
   ",", "\<\"DMetrics\"\>", ",", "\<\"Dust\"\>", 
   ",", "\<\"EinsteinMaxwellSolution\"\>", ",", "\<\"G1\"\>", 
   ",", "\<\"G2\"\>", ",", "\<\"G3\"\>", ",", "\<\"G3onS2\"\>", 
   ",", "\<\"G3IonS3\"\>", ",", "\<\"G3IIonS3\"\>", ",", "\<\"G3IIIonS3\"\>", 
   ",", "\<\"G3IVonS3\"\>", ",", "\<\"G3VonS3\"\>", ",", "\<\"G3VI0onS3\"\>", 
   ",", "\<\"G3VIhonS3\"\>", ",", "\<\"G3VII0onS3\"\>", 
   ",", "\<\"G3VIIhonS3\"\>", ",", "\<\"G3VIIIonS3\"\>", 
   ",", "\<\"G3IXonS3\"\>", ",", "\<\"G3IonT3\"\>", ",", "\<\"G3IIonT3\"\>", 
   ",", "\<\"G3IIIonT3\"\>", ",", "\<\"G3IVonT3\"\>", ",", "\<\"G3VonT3\"\>", 
   ",", "\<\"G3VIonT3\"\>", ",", "\<\"G3VI0onT3\"\>", 
   ",", "\<\"G3VIhonT3\"\>", ",", "\<\"G3VII0onT3\"\>", 
   ",", "\<\"G3VIIhonT3\"\>", ",", "\<\"G3VIIIonT3\"\>", 
   ",", "\<\"G3IXonT3\"\>", ",", "\<\"G4\"\>", ",", "\<\"G5\"\>", 
   ",", "\<\"G6\"\>", ",", "\<\"G7\"\>", ",", "\<\"G8\"\>", ",", "\<\"G9\"\>",
    ",", "\<\"G10\"\>", ",", "\<\"Geodesic\"\>", ",", "\<\"PerfectFluid\"\>", 
   ",", "\<\"PetrovTypeI\"\>", ",", "\<\"PetrovTypeII\"\>", 
   ",", "\<\"PetrovTypeIII\"\>", ",", "\<\"PetrovTypeN\"\>", 
   ",", "\<\"PetrovTypeD\"\>", ",", "\<\"SpatialG1\"\>", 
   ",", "\<\"SpatialG2\"\>", ",", "\<\"SpatialG3\"\>", 
   ",", "\<\"SpatialG4\"\>", ",", "\<\"SpatialG5\"\>", 
   ",", "\<\"SpatialG6\"\>", ",", "\<\"SphericalSymmetry\"\>", 
   ",", "\<\"Static\"\>", ",", "\<\"Stationary\"\>", 
   ",", "\<\"ThermodynamicPerfectFluid\"\>", ",", "\<\"Vacuum\"\>", 
   ",", "\<\"VacuumTypeD\"\>", ",", "\<\"Warped22\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->779435958,ExpressionUUID->"7faac6de-b627-462e-97ae-0b2e06f35ce8"]
}, Open  ]],

Cell["Pick up classes and show the exact solutions they contain:", \
"ExampleText",
 CellID->888601957,ExpressionUUID->"4446d8e6-c2d8-42d3-9e04-e4cf712dabb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", "\"\<PerfectFluid\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[2]:=",
 CellID->1159615630,ExpressionUUID->"16a0d7b6-d1d4-41ee-8480-5afa955e5a95"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Friedmann\"\>", ",", "\<\"FarnsworthKerrI\"\>", 
   ",", "\<\"FarnsworthKerrII\"\>", ",", "\<\"FarnsworthKerrIII\"\>", 
   ",", "\<\"GeneralSphericalSymmetry\"\>", ",", "\<\"LemaitreTolman\"\>", 
   ",", "\<\"OsvathKoutrasI\"\>", ",", "\<\"OsvathKoutrasII\"\>", 
   ",", "\<\"OsvathKoutrasIII\"\>", ",", "\<\"Stephani\"\>", 
   ",", "\<\"StephaniThermodynamic\"\>", 
   ",", "\<\"StephaniThermodynamicSpherical\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->794063719,ExpressionUUID->"a9234b82-ccf2-42e3-8de3-d7f7e8818d16"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", "\"\<Vacuum\>\"", "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[3]:=",
 CellID->238552055,ExpressionUUID->"f5eb6ac0-3397-4016-806b-de75c8b50634"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"KasnerI\"\>", ",", "\<\"KasnerII\"\>", ",", "\<\"Kerr\"\>", 
   ",", "\<\"KerrNUT\"\>", ",", "\<\"PetrovSolution\"\>", 
   ",", "\<\"Schwarzschild\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->806571178,ExpressionUUID->"c4e67129-394d-403e-8801-9680276cfdec"]
}, Open  ]],

Cell["Pick up exact solutions and show the classes they belong to:", \
"ExampleText",
 CellID->630997382,ExpressionUUID->"e870494d-9b64-44c7-bb40-54902162b86b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Kerr\>\"", ",", "\"\<Classes\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[4]:=",
 CellID->727866619,ExpressionUUID->"8bc99a68-9e5e-4cef-9e85-ff6c6cff64ca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DMetrics\"\>", ",", "\<\"PetrovTypeD\"\>", 
   ",", "\<\"AxialSymmetry\"\>", ",", "\<\"Vacuum\"\>", 
   ",", "\<\"Stationary\"\>"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->677569532,ExpressionUUID->"2607f5a6-8980-401f-a92c-2ab7f010f021"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<Classes\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[5]:=",
 CellID->711265452,ExpressionUUID->"5dd23a84-5a08-4aee-8565-36d00f87f375"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PetrovTypeD\"\>", ",", "\<\"Static\"\>", 
   ",", "\<\"SphericalSymmetry\"\>", ",", "\<\"Vacuum\"\>", 
   ",", "\<\"VacuumTypeD\"\>"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->1036709189,ExpressionUUID->"788b7861-3c5e-410c-b0c0-c278ca7accbb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Friedmann\>\"", ",", "\"\<Classes\>\""}], "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[6]:=",
 CellID->2098165431,ExpressionUUID->"5fc3bc19-d82e-4b11-8616-8b633b37297d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PerfectFluid\"\>", ",", "\<\"ThermodynamicPerfectFluid\"\>", 
   ",", "\<\"ConformallyFlat\"\>", ",", "\<\"SpatiallyHomogeneous\"\>", 
   ",", "\<\"SpatialG6\"\>", ",", "\<\"BarotropicPerfectFluid\"\>", 
   ",", "\<\"ConformallyStatic\"\>"}], "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->582104703,ExpressionUUID->"e8acb5a6-9402-4758-88cb-d8ef12887cc5"]
}, Open  ]],

Cell["Available properties for a given exact solution:", "ExampleText",
 CellID->1162852654,ExpressionUUID->"ab43f5f4-539d-40a1-bbfb-f295736eca6f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<Properties\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[7]:=",
 CellID->1968009751,ExpressionUUID->"ad039c1e-f218-47f7-bca1-eaf5f0f185ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Classes\"\>", ",", "\<\"CoordinateAssumptions\"\>", 
   ",", "\<\"CoordinateNames\"\>", ",", "\<\"CoordinateSystemName\"\>", 
   ",", "\<\"CoordinateSystems\"\>", ",", "\<\"IsIDEAL\"\>", 
   ",", "\<\"Metric\"\>", ",", "\<\"ParameterAssumptions\"\>", 
   ",", "\<\"ParameterNames\"\>", ",", "\<\"ScalarFunctionValues\"\>", 
   ",", "\<\"ScalarFunctionNames\"\>", ",", "\<\"SignatureOfMetric\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[7]=",
 CellID->578193770,ExpressionUUID->"a87a5cd3-529b-49fd-8f85-f9fcef3ae8e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Friedmann\>\"", ",", "\"\<CoordinateSystems\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[8]:=",
 CellID->2055609263,ExpressionUUID->"d1977b7a-dd8d-4487-b5fd-d8cc5ed92f85"],

Cell[BoxData[
 RowBox[{"{", "\<\"ReducedCircumferencePolarCoordinates\"\>", "}"}]], "Output",\

 CellLabel->"Out[8]=",
 CellID->139519321,ExpressionUUID->"7d25d169-6a6a-4754-bec8-20d0aad99555"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Schwarzschild\>\"", ",", "\"\<CoordinateSystems\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[9]:=",
 CellID->931334451,ExpressionUUID->"6331d0b3-6d34-4704-843e-738cfdb88fbc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"SchwarzschildCoordinates\"\>", 
   ",", "\<\"IsotropicCoordinates\"\>", ",", "\<\"HarmonicCoordinates\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->732389370,ExpressionUUID->"6744a597-716f-482a-bf5f-125c84e978fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Friedmann\>\"", ",", "\"\<CoordinateNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[10]:=",
 CellID->1122148095,ExpressionUUID->"61284ae5-c8d6-4b31-b81f-60fc730fa84b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"t\"\>", ",", "\<\"r\"\>", ",", "\<\"\[Theta]\"\>", 
   ",", "\<\"\[Phi]\"\>"}], "}"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->1156952597,ExpressionUUID->"d92d1606-5df8-4874-8656-29912f0f8bc7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Friedmann\>\"", ",", "\"\<ParameterNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[11]:=",
 CellID->2106857486,ExpressionUUID->"8619adac-dfb2-4319-9ba1-38e233d3261d"],

Cell[BoxData[
 RowBox[{"{", "\<\"k\"\>", "}"}]], "Output",
 CellLabel->"Out[11]=",
 CellID->1919752574,ExpressionUUID->"0ba56849-ac1a-45ef-9b4d-cbe5f7098ce6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xActSolutionData", "[", 
  RowBox[{"\"\<Friedmann\>\"", ",", "\"\<ScalarFunctionNames\>\""}], 
  "]"}]], "Input",
 CellProlog:>Needs["xAct`xIdeal`"],
 CellLabel->"In[12]:=",
 CellID->1145673053,ExpressionUUID->"daf953d4-8cbc-42fa-9f19-08fba36a7654"],

Cell[BoxData[
 RowBox[{"{", "\<\"R\"\>", "}"}]], "Output",
 CellLabel->"Out[12]=",
 CellID->1431409139,ExpressionUUID->"948d7118-fe04-4bdc-a0d4-e3a3b1c451f9"]
}, Open  ]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, 
  Closed]]]]
}, Dynamic[CurrentValue[
 EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, 
  Closed]]]],

Cell[" ", "FooterCell",ExpressionUUID->"9fe12d11-38e2-4708-86c6-d96c30237aca"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{900, 750.75},
WindowMargins->{{-1440, Automatic}, {Automatic, 0}},
WindowTitle->"xActSolutionData",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "", "LinkTrails" -> "", 
  "ExampleCounter" -> 1, 
  "Openers" -> {
   "PrimaryExamplesSection" -> Open, 
    "ExampleSection" -> {"0" -> Closed, "1" -> Closed}, "AllOptsTable" -> 
    Closed, "NotesSection" -> Closed, 
    "ExampleSubsection" -> {"0" -> Closed, "1" -> Closed, "2" -> Closed}}, 
  "NewStyles" -> True, "CitationPopupData" -> $Failed, "ShowCitation" -> 
  False, "RootCaptions" -> "", "HeaderCoreAreaLink" -> {}, 
  "Metadata" -> {
   "built" -> "{2025, 8, 25, 19, 37, 58.417254}", 
    "history" -> {"XX", "", "", ""}, "context" -> "xAct`xIdeal`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "x Ideal Symbol", "language" -> "en", "paclet" -> "xIdeal", "status" -> 
    "None", "summary" -> 
    "xActSolutionData[args] returns information about an the exact solution \
as queried by args . xActSolutionData [] gives the list of all exact \
solutions available for querying. xActSolutionData [Classes] gives the list \
of all available classes for exact solutions. xActSolutionData [class] gives \
the list of exact solutions belonging to the class class. xActSolutionData \
[sol] gives the list of available coordinate systems for the exact solution \
sol. xActSolutionData [sol, prop] queries the property prop of the exact \
solution sol. xActSolutionData [sol, Properties] gives the list of available \
properties for querying of the exact solution sol. xActSolutionData [{sol, \
coord}, prop] queries the property prop of the exact solution sol in the \
coordinate system coord . xActSolutionData [{sol, coord}, Properties}] gives \
the list of available properties of the exact solution sol in the coordinate \
system coords .", "synonyms" -> {}, "tabletags" -> {}, "title" -> 
    "xActSolutionData", "titlemodifier" -> "", "metadescription" -> "", 
    "windowtitle" -> "xActSolutionData", "type" -> "Symbol", "uri" -> 
    "xIdeal/ref/xActSolutionData", "WorkflowDockedCell" -> ""}, 
  "SearchTextTranslated" -> ""},
FrontEndVersion->"14.3 for Linux x86 (64-bit) (July 8, 2025)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb"],
ExpressionUUID->"9d37c5ee-2742-4446-bbfa-1956b11087db"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12137, 311, 1430, 37, 34, "PrimaryExamplesSection",ExpressionUUID->"807d3862-a925-4aa9-85f7-17477a0643ec",
   CellTags->"PrimaryExamplesSection",
   CellID->1111486702]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 233929, 6519}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[584, 21, 2974, 72, 51, "AnchorBarGrid",ExpressionUUID->"430fd6ad-bd5b-4ebc-abaa-a3933b1a7eda",
 CellID->1],
Cell[3561, 95, 94, 0, 22, "ContextNameCell",ExpressionUUID->"bb9ab4dd-30de-46a2-9595-6ab7fd9926ce"],
Cell[CellGroupData[{
Cell[3680, 99, 559, 14, 57, "ObjectNameGrid",ExpressionUUID->"cab40871-3414-4584-9e31-77ce593cb031"],
Cell[4242, 115, 5603, 131, 672, "Usage",ExpressionUUID->"cdfe0471-4fcb-41c2-bc18-c916677370ae",
 CellID->947225108]
}, Open  ]],
Cell[CellGroupData[{
Cell[9882, 251, 1837, 45, 104, "NotesSection",ExpressionUUID->"3baca0e1-fe2c-457f-801d-e61ddeae86c3",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1197403115],
Cell[11722, 298, 94, 1, 70, "Notes",ExpressionUUID->"7d7734d8-b9b9-4e7a-8813-5a6615c3edec",
 CellID->308140725],
Cell[11819, 301, 94, 1, 70, "Notes",ExpressionUUID->"951cdbb8-2eae-46f6-8e1f-b6d0433c52fb",
 CellID->464222344],
Cell[11916, 304, 94, 1, 70, "Notes",ExpressionUUID->"f8e0e994-374d-49a9-9e04-45f4549ca4ce",
 CellID->629813785]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "NotesSection"}, Closed]]]],
Cell[CellGroupData[{
Cell[12137, 311, 1430, 37, 34, "PrimaryExamplesSection",ExpressionUUID->"807d3862-a925-4aa9-85f7-17477a0643ec",
 CellTags->"PrimaryExamplesSection",
 CellID->1111486702],
Cell[13570, 350, 200, 3, 27, "Input",ExpressionUUID->"c2a7e76c-b24d-4591-9a84-ea07119a5ab1",
 CellID->817605420],
Cell[CellGroupData[{
Cell[13795, 357, 1416, 37, 28, "ExampleSection",ExpressionUUID->"b3fe45d1-e610-4a59-8e87-d0a9cca06d40",
 CellID->1150199918],
Cell[15214, 396, 169, 3, 37, "ExampleText",ExpressionUUID->"de307e4b-023e-4050-9cef-3dae4658304f",
 CellID->846928249],
Cell[CellGroupData[{
Cell[15408, 403, 219, 4, 27, "Input",ExpressionUUID->"0c258428-78ab-4a26-a22e-6d9376319680",
 CellID->372709450],
Cell[15630, 409, 193, 4, 36, "Output",ExpressionUUID->"c8f885cf-038f-4012-b05c-f659eed26f7e",
 CellID->750567566]
}, Open  ]],
Cell[15838, 416, 142, 1, 37, "ExampleText",ExpressionUUID->"cdd74e8a-ae12-45b8-8766-a6dc227b672d",
 CellID->1695234636],
Cell[15983, 419, 397, 10, 43, "Input",ExpressionUUID->"51c6db88-0d1d-4dbb-8f8c-feace1418b4f",
 CellID->172691151],
Cell[CellGroupData[{
Cell[16405, 433, 267, 6, 27, "Input",ExpressionUUID->"4b7a3758-26fe-464c-9e22-a9d7ed05f0d0",
 CellID->806496087],
Cell[16675, 441, 240, 5, 36, "Output",ExpressionUUID->"f8fc0a07-2623-44fb-850b-412f112d89d5",
 CellID->1115273353]
}, Open  ]],
Cell[16930, 449, 137, 1, 37, "ExampleText",ExpressionUUID->"34990319-461b-4610-8b93-b31297e3ca50",
 CellID->1472014302],
Cell[17070, 452, 494, 13, 27, "Input",ExpressionUUID->"da290031-fff0-4c03-bfba-faf907095210",
 CellID->1410191844],
Cell[17567, 467, 146, 1, 37, "ExampleText",ExpressionUUID->"596f901a-a0ad-445b-9f4f-19d925acc684",
 CellID->2120853183],
Cell[CellGroupData[{
Cell[17738, 472, 267, 6, 27, "Input",ExpressionUUID->"cd402abe-333e-4aec-b0b9-70ad4b82d5de",
 CellID->1525506234],
Cell[18008, 480, 157, 3, 36, "Output",ExpressionUUID->"110831b6-e9dd-4081-82b0-e6b8574e7a9f",
 CellID->2099870811]
}, Open  ]],
Cell[CellGroupData[{
Cell[18202, 488, 271, 6, 27, "Input",ExpressionUUID->"2a61aa4c-c6ae-4178-97fc-3114216f7bca",
 CellID->384715940],
Cell[18476, 496, 156, 3, 36, "Output",ExpressionUUID->"2b881d98-43ef-412e-8f72-1e2e37261466",
 CellID->696643655]
}, Open  ]],
Cell[18647, 502, 262, 6, 37, "ExampleText",ExpressionUUID->"88a11232-0d8e-4e2f-8104-90957f118305",
 CellID->845433962],
Cell[18912, 510, 267, 6, 27, "Input",ExpressionUUID->"d4647e90-3aad-45da-8d44-bb5ddc0bdd61",
 CellID->941509497],
Cell[19182, 518, 222, 5, 27, "Input",ExpressionUUID->"aa349ef6-5190-42dd-96fb-b93bf898cf4a",
 CellID->804830991],
Cell[19407, 525, 194, 4, 37, "ExampleText",ExpressionUUID->"07139d3e-7aab-4619-b82d-e5aa290069c5",
 CellID->2056787353],
Cell[CellGroupData[{
Cell[19626, 533, 591, 16, 27, "Input",ExpressionUUID->"901bfda0-f093-4b55-8ca8-366f9796fff4",
 CellID->2043656533],
Cell[20220, 551, 2917, 101, 57, "Output",ExpressionUUID->"a14b4151-62eb-43f5-8d2b-6a64a0068c8b",
 CellID->468730751]
}, Open  ]],
Cell[23152, 655, 388, 10, 37, "ExampleText",ExpressionUUID->"4b055b07-b519-4b60-bce7-b5dd49d8a78f",
 CellID->1816261334],
Cell[CellGroupData[{
Cell[23565, 669, 923, 26, 43, "Input",ExpressionUUID->"d6055232-0929-44d6-b0a4-a7e127924992",
 CellID->1839978071],
Cell[24491, 697, 3275, 107, 57, "Output",ExpressionUUID->"46dfa453-19f2-40b8-9d06-e1d75e005b71",
 CellID->638705748]
}, Open  ]],
Cell[27781, 807, 210, 4, 37, "ExampleText",ExpressionUUID->"cdb01f0b-e97c-4005-b239-4fa7a6b4b585",
 CellID->1542706052],
Cell[CellGroupData[{
Cell[28016, 815, 1020, 27, 43, "Input",ExpressionUUID->"94d7de56-9071-4dff-9ad8-a46a073723f3",
 CellID->560556497],
Cell[CellGroupData[{
Cell[29061, 846, 377, 9, 70, "Print",ExpressionUUID->"5a1b6869-d8ae-4e95-b201-1027d15edf5c",
 CellID->1193091896],
Cell[29441, 857, 173, 2, 70, "Print",ExpressionUUID->"a49e1546-474e-4589-a9ad-5604e4d23644",
 CellID->1409186749],
Cell[29617, 861, 458, 12, 70, "Print",ExpressionUUID->"d64e9052-4e1e-4f79-9974-2481f4f71dc4",
 CellID->1666403000],
Cell[30078, 875, 173, 2, 70, "Print",ExpressionUUID->"50554a74-61e2-4dc2-9382-f01f8d540f01",
 CellID->1649880750],
Cell[30254, 879, 495, 13, 70, "Print",ExpressionUUID->"21debb3a-4dfe-4a8c-ba0d-2716043cf7d3",
 CellID->1714842000],
Cell[30752, 894, 366, 7, 70, "Print",ExpressionUUID->"a8c44dc5-f38f-4ffc-8e73-f19ce0e0275b",
 CellID->617199753],
Cell[31121, 903, 444, 8, 70, "Print",ExpressionUUID->"a98107a7-b1a7-4078-a1e0-42b915e38eb3",
 CellID->757682803],
Cell[31568, 913, 466, 12, 70, "Print",ExpressionUUID->"bab488b3-edf5-4191-9ce6-446d37ac7d11",
 CellID->1877628108],
Cell[32037, 927, 173, 2, 70, "Print",ExpressionUUID->"8da5f06b-5289-4ecc-af0e-105501f7b6d9",
 CellID->1303736867],
Cell[32213, 931, 444, 11, 70, "Print",ExpressionUUID->"5a0ba46f-5ac4-4022-a005-8301d7007085",
 CellID->1146953269],
Cell[32660, 944, 173, 2, 70, "Print",ExpressionUUID->"b03e2f9c-7508-400a-9c5f-463067be1050",
 CellID->2099860739],
Cell[32836, 948, 328, 7, 70, "Print",ExpressionUUID->"8cbaeb54-c70a-4d13-8560-3c5f350f0601",
 CellID->406789880],
Cell[33167, 957, 173, 2, 70, "Print",ExpressionUUID->"a4fe5d9f-c6d4-4e5c-98a4-d7a852703573",
 CellID->1446460519],
Cell[33343, 961, 492, 13, 70, "Print",ExpressionUUID->"d7a8dfa9-ab91-4ce6-8671-d8c8155bfb3a",
 CellID->282698571],
Cell[33838, 976, 366, 7, 70, "Print",ExpressionUUID->"a28e2e59-970a-4d82-8634-a800d01c5017",
 CellID->299968610],
Cell[34207, 985, 442, 8, 70, "Print",ExpressionUUID->"a661e82f-9450-409b-af3e-2ee37d92e383",
 CellID->7038138],
Cell[34652, 995, 457, 8, 70, "Print",ExpressionUUID->"9463c01d-7072-429d-95bf-2e55b80c076c",
 CellID->1769788736],
Cell[35112, 1005, 470, 12, 70, "Print",ExpressionUUID->"ea4cb093-8046-4cfd-9b10-dae0a75a037e",
 CellID->739701584],
Cell[35585, 1019, 365, 7, 70, "Print",ExpressionUUID->"c0e0297c-05af-42ba-b3f7-319e437821ac",
 CellID->1539923312],
Cell[35953, 1028, 445, 8, 70, "Print",ExpressionUUID->"054cd4dc-d808-4e37-b224-2a364a426cc6",
 CellID->1473040141],
Cell[36401, 1038, 456, 8, 70, "Print",ExpressionUUID->"978ff479-037b-4c3a-a1ab-6acd35b4b5a7",
 CellID->667525444],
Cell[36860, 1048, 418, 11, 70, "Print",ExpressionUUID->"26fd02f9-3253-4911-8fd9-0d2469ef8962",
 CellID->106684966],
Cell[37281, 1061, 367, 7, 70, "Print",ExpressionUUID->"2ce28fff-df22-4eb8-9b96-881049108417",
 CellID->2108361481],
Cell[37651, 1070, 445, 8, 70, "Print",ExpressionUUID->"b8203688-6b0a-4ac9-9787-8f7c9035c1f1",
 CellID->1418093011],
Cell[38099, 1080, 455, 8, 70, "Print",ExpressionUUID->"3c60a2b6-fc57-410b-a62f-4751d0a49796",
 CellID->1221958319]
}, Open  ]],
Cell[38569, 1091, 8427, 262, 70, "Output",ExpressionUUID->"bf76c66b-3fe1-4868-b01f-4ab4c1af82cc",
 CellID->2060748644]
}, Open  ]],
Cell[47011, 1356, 140, 1, 70, "ExampleText",ExpressionUUID->"ab48392d-845c-43dd-8350-9167b789e6ac",
 CellID->635890570],
Cell[CellGroupData[{
Cell[47176, 1361, 261, 7, 70, "Input",ExpressionUUID->"76840364-3a67-43e6-b169-8025cc5f3728",
 CellID->1461989129],
Cell[47440, 1370, 18926, 455, 70, "Output",ExpressionUUID->"5e87ee5a-02e9-4c94-91f0-3b5e60e13991",
 CellID->2114736666]
}, Open  ]],
Cell[66381, 1828, 172, 3, 70, "ExampleText",ExpressionUUID->"e53240dc-885c-4b3e-b216-a8ee13a34a00",
 CellID->1528148855],
Cell[66556, 1833, 408, 9, 70, "Input",ExpressionUUID->"344afaeb-33b1-43ba-8290-c07d317e1aa4",
 CellID->1541416965],
Cell[66967, 1844, 176, 3, 70, "ExampleText",ExpressionUUID->"9235428f-9b2b-40c0-82b1-ac5c011f66eb",
 CellID->91844987],
Cell[CellGroupData[{
Cell[67168, 1851, 361, 10, 70, "Input",ExpressionUUID->"326f5a2e-9c24-4bef-97bb-abd83b3e3ed7",
 CellID->373845153],
Cell[67532, 1863, 309, 8, 70, "Output",ExpressionUUID->"36282482-6433-49be-a276-752bea8d2d5e",
 CellID->1690689070]
}, Open  ]],
Cell[CellGroupData[{
Cell[67878, 1876, 254, 7, 70, "Input",ExpressionUUID->"27a4eb4c-dcba-45af-b43b-5fa2994db8b5",
 CellID->384632792],
Cell[68135, 1885, 145, 3, 70, "Output",ExpressionUUID->"e5d44de8-31a1-4996-8d65-946d5d0254b6",
 CellID->1238817752]
}, Open  ]],
Cell[68295, 1891, 233, 4, 70, "ExampleText",ExpressionUUID->"6d9bec55-860b-4a57-910f-605b7bf30a9e",
 CellID->107166659],
Cell[CellGroupData[{
Cell[68553, 1899, 274, 6, 70, "Input",ExpressionUUID->"1b53dbe8-be1b-47ad-9c45-664086b03ad5",
 CellID->1160946677],
Cell[CellGroupData[{
Cell[68852, 1909, 376, 9, 70, "Print",ExpressionUUID->"7e85a23b-d29e-4930-9476-7d52e20685ec",
 CellID->605958766],
Cell[69231, 1920, 172, 2, 70, "Print",ExpressionUUID->"76fb25e2-23a1-499b-abeb-73e20c1c9c05",
 CellID->736297318],
Cell[69406, 1924, 457, 12, 70, "Print",ExpressionUUID->"5bea44dc-3003-439b-a379-90faa7f3d8b2",
 CellID->500520854],
Cell[69866, 1938, 172, 2, 70, "Print",ExpressionUUID->"1463d3dc-6acb-466c-890a-8f5b4cd06f22",
 CellID->124878119],
Cell[70041, 1942, 494, 13, 70, "Print",ExpressionUUID->"34704674-dd57-4cee-86e1-b6a282368569",
 CellID->238694420],
Cell[70538, 1957, 171, 2, 70, "Print",ExpressionUUID->"92ad3dfc-5d16-48a5-8d52-56bfd9671bac",
 CellID->67879206],
Cell[70712, 1961, 465, 12, 70, "Print",ExpressionUUID->"b3e53a60-e1b9-4fe2-af3d-0a3128e0e8a0",
 CellID->742077872],
Cell[71180, 1975, 173, 2, 70, "Print",ExpressionUUID->"8fc83f21-0ce5-4b8c-916f-15167831cbff",
 CellID->1499136800],
Cell[71356, 1979, 443, 11, 70, "Print",ExpressionUUID->"a5535bbf-f687-415e-9ac5-5b24bdba3263",
 CellID->825562009],
Cell[71802, 1992, 172, 2, 70, "Print",ExpressionUUID->"9250bfa0-99d4-4586-9b40-c12d68b75eb1",
 CellID->472222332],
Cell[71977, 1996, 328, 7, 70, "Print",ExpressionUUID->"3a3cb643-99ac-4ce8-ab2f-cc004d9b8f9b",
 CellID->655390019],
Cell[72308, 2005, 173, 2, 70, "Print",ExpressionUUID->"5bdcdfb2-69ab-415d-8e62-2c07c23a93b0",
 CellID->1972515278],
Cell[72484, 2009, 492, 13, 70, "Print",ExpressionUUID->"020505f7-fa33-4f13-931e-a086dda63229",
 CellID->424599424],
Cell[72979, 2024, 173, 2, 70, "Print",ExpressionUUID->"8b7059aa-ecf3-4bdc-8188-a504c679a9fb",
 CellID->1062179899],
Cell[73155, 2028, 471, 12, 70, "Print",ExpressionUUID->"205dc41d-1587-462a-97f1-319da10abc71",
 CellID->1271492150],
Cell[73629, 2042, 172, 2, 70, "Print",ExpressionUUID->"dc261ee6-ec75-41de-99d3-90e062a71c8a",
 CellID->707297995],
Cell[73804, 2046, 419, 11, 70, "Print",ExpressionUUID->"f21291ba-5f71-4016-9dec-d7329357f7ba",
 CellID->1362148509],
Cell[74226, 2059, 173, 2, 70, "Print",ExpressionUUID->"1a6c3e53-70b9-4839-bf9e-1ff46d8c8597",
 CellID->1278530288],
Cell[74402, 2063, 352, 8, 70, "Print",ExpressionUUID->"ed4d68e4-baca-4de7-8219-b0cedf983eb5",
 CellID->329603083],
Cell[74757, 2073, 367, 7, 70, "Print",ExpressionUUID->"25978bb5-dad4-4ce1-8df6-17644f4cb4a0",
 CellID->2101850093],
Cell[75127, 2082, 444, 8, 70, "Print",ExpressionUUID->"9dc14ab4-d836-4a23-9c59-fb5d3426ad57",
 CellID->670969952],
Cell[75574, 2092, 453, 8, 70, "Print",ExpressionUUID->"12a41542-2c7d-4486-ae6e-df38f4ece596",
 CellID->1802643224],
Cell[76030, 2102, 486, 13, 70, "Print",ExpressionUUID->"47e1ec60-e5ce-4878-abbf-2723057b0faa",
 CellID->621891890],
Cell[76519, 2117, 366, 7, 70, "Print",ExpressionUUID->"db7a58b9-43c1-466d-833d-9f773a4bcf32",
 CellID->777654918],
Cell[76888, 2126, 443, 8, 70, "Print",ExpressionUUID->"0b4ca7e0-b494-4b50-99f0-d85a7e830ef7",
 CellID->1763521058],
Cell[77334, 2136, 455, 8, 70, "Print",ExpressionUUID->"3204d7d3-8555-4161-a18f-c2c22e7f7c90",
 CellID->2039984901],
Cell[77792, 2146, 505, 10, 70, "Print",ExpressionUUID->"2a5b8f1e-009a-44cd-a40d-fc9e646fc7f5",
 CellID->1999613237],
Cell[78300, 2158, 605, 13, 70, "Print",ExpressionUUID->"81cd0a7f-e073-4c31-850c-4cfcb5b2798d",
 CellID->1676786054],
Cell[78908, 2173, 503, 10, 70, "Print",ExpressionUUID->"b2f2d70c-434d-4957-83aa-91e3a50de23a",
 CellID->2007237919],
Cell[79414, 2185, 607, 13, 70, "Print",ExpressionUUID->"81ca5639-c795-4ad3-8f46-84c04a22ab33",
 CellID->1542818659],
Cell[80024, 2200, 506, 10, 70, "Print",ExpressionUUID->"bd4d45df-c224-4d89-9181-5fbdfc82c215",
 CellID->768120159],
Cell[80533, 2212, 606, 13, 70, "Print",ExpressionUUID->"8d8f8566-ae23-4e2c-b083-8cf1cf613a88",
 CellID->465713038],
Cell[81142, 2227, 508, 10, 70, "Print",ExpressionUUID->"ef5f62e5-2500-415b-a72e-274033c11d3f",
 CellID->131632330],
Cell[81653, 2239, 609, 13, 70, "Print",ExpressionUUID->"ee164e4c-1c95-45da-9270-26e2c9fa3b7d",
 CellID->1268641013],
Cell[82265, 2254, 506, 10, 70, "Print",ExpressionUUID->"4c41562a-f228-41c4-9db3-f7e93c0ee4ba",
 CellID->590591157],
Cell[82774, 2266, 610, 13, 70, "Print",ExpressionUUID->"5cec42d2-1295-4f6f-a026-fa41ee5d7091",
 CellID->370326750],
Cell[83387, 2281, 505, 10, 70, "Print",ExpressionUUID->"1239f0bd-e4f5-4db5-9f3a-b27b3bc8b967",
 CellID->1336520219],
Cell[83895, 2293, 605, 13, 70, "Print",ExpressionUUID->"8d3cf666-3e44-4c5c-9d15-601cc11a2d42",
 CellID->1332669029],
Cell[84503, 2308, 503, 10, 70, "Print",ExpressionUUID->"b723ec97-45fb-447d-963d-bc3068e2553b",
 CellID->1869463550],
Cell[85009, 2320, 605, 13, 70, "Print",ExpressionUUID->"941763a4-34dc-4d2a-bd25-e2fe5f7a483b",
 CellID->14598581],
Cell[85617, 2335, 505, 10, 70, "Print",ExpressionUUID->"1fc1f580-11bd-4ff7-bff4-c0de849012ad",
 CellID->1804891361],
Cell[86125, 2347, 608, 13, 70, "Print",ExpressionUUID->"f6360120-d350-4c33-b12d-a2f6dc581d87",
 CellID->377369921],
Cell[86736, 2362, 513, 10, 70, "Print",ExpressionUUID->"ac6064cf-48ba-4f66-a483-61ef2a33fa35",
 CellID->1987113859],
Cell[87252, 2374, 611, 13, 70, "Print",ExpressionUUID->"089edef3-ec85-4694-a219-0902157baaee",
 CellID->82007137],
Cell[87866, 2389, 513, 10, 70, "Print",ExpressionUUID->"64da7842-b0b2-4691-824e-991414021a84",
 CellID->1439549821],
Cell[88382, 2401, 611, 13, 70, "Print",ExpressionUUID->"b9b96f58-eef9-40e6-808d-5a843e8c749d",
 CellID->1111122361]
}, Open  ]],
Cell[89008, 2417, 130, 2, 70, "Output",ExpressionUUID->"50119f13-32e2-4bd0-8061-01a36d4e7b85",
 CellID->789305133]
}, Open  ]],
Cell[89153, 2422, 176, 3, 70, "ExampleText",ExpressionUUID->"60346335-99d3-4804-abc5-040c4e1b6abb",
 CellID->1541371525],
Cell[CellGroupData[{
Cell[89354, 2429, 286, 6, 70, "Input",ExpressionUUID->"31cfcec9-68f0-4992-a9af-cfb2ec562783",
 CellID->592591902],
Cell[CellGroupData[{
Cell[89665, 2439, 504, 10, 70, "Print",ExpressionUUID->"962be5b0-4171-4442-9df1-a14d949c6959",
 CellID->654214682],
Cell[90172, 2451, 604, 13, 70, "Print",ExpressionUUID->"c060ec2f-825c-4e92-99d3-3932dbf20db8",
 CellID->242169001],
Cell[90779, 2466, 507, 10, 70, "Print",ExpressionUUID->"961b210a-d147-421d-9fbc-1990f6d3602a",
 CellID->1118908216],
Cell[91289, 2478, 604, 13, 70, "Print",ExpressionUUID->"e93a48aa-8b5b-4531-b10b-dc6cc87ff7df",
 CellID->608581128],
Cell[91896, 2493, 514, 10, 70, "Print",ExpressionUUID->"3c4b890e-51c4-41f2-9a7a-044b7cef30cc",
 CellID->913138954],
Cell[92413, 2505, 616, 13, 70, "Print",ExpressionUUID->"337a3a60-fa23-4943-904e-4fd5f2a9dc3d",
 CellID->774067793],
Cell[93032, 2520, 515, 10, 70, "Print",ExpressionUUID->"fa9c9dae-3aa9-4b11-82c2-f3ea29c5f573",
 CellID->1230473018],
Cell[93550, 2532, 615, 13, 70, "Print",ExpressionUUID->"54fc6094-7610-4ad3-b8d9-13de0070159f",
 CellID->1690793872],
Cell[94168, 2547, 510, 10, 70, "Print",ExpressionUUID->"8c924d7a-6b31-49fa-b30b-b3f31183a8b1",
 CellID->390105203],
Cell[94681, 2559, 609, 13, 70, "Print",ExpressionUUID->"18c81fd4-dded-46bd-b4c5-00bb8c095e56",
 CellID->1122974271],
Cell[95293, 2574, 525, 10, 70, "Print",ExpressionUUID->"e963d39b-987e-43b0-b1a2-e3b5427ae37d",
 CellID->1542923462],
Cell[95821, 2586, 627, 13, 70, "Print",ExpressionUUID->"d13edba5-13c3-4289-ad26-91c9b5ce77f6",
 CellID->2066891257],
Cell[96451, 2601, 556, 10, 70, "Print",ExpressionUUID->"488b5aa4-54d6-4277-a41f-afe73dfd1cb5",
 CellID->982728542],
Cell[97010, 2613, 660, 13, 70, "Print",ExpressionUUID->"a218a40e-78ff-4930-8ce5-c1c3f2c7c92f",
 CellID->938258473],
Cell[97673, 2628, 566, 10, 70, "Print",ExpressionUUID->"246675e1-74d8-4bc0-a7b5-74a9e5146c77",
 CellID->687527768],
Cell[98242, 2640, 671, 13, 70, "Print",ExpressionUUID->"2d5a83c8-522e-482c-b902-085f9bc3bdee",
 CellID->1448441580],
Cell[98916, 2655, 577, 10, 70, "Print",ExpressionUUID->"c42d17a9-7410-4e5f-9de4-16efbcd11376",
 CellID->1069890803],
Cell[99496, 2667, 677, 13, 70, "Print",ExpressionUUID->"b2b44cf8-5be7-4a0a-b9b8-50733c927c47",
 CellID->1956168781],
Cell[100176, 2682, 521, 10, 70, "Print",ExpressionUUID->"622abc6b-f6d0-4558-a159-54e8447cc0fe",
 CellID->2039032737],
Cell[100700, 2694, 621, 13, 70, "Print",ExpressionUUID->"938e6022-64b7-4d83-baf7-fad03399f9f9",
 CellID->1440217554]
}, Open  ]],
Cell[101336, 2710, 131, 2, 70, "Output",ExpressionUUID->"a9f3eddf-f67d-45c3-b80a-203fcc329121",
 CellID->1145205353]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[101616, 2720, 1407, 37, 22, "ExampleSection",ExpressionUUID->"46ede997-752f-40af-95e0-065e40897ba1",
 CellID->1426763492],
Cell[CellGroupData[{
Cell[103048, 2761, 1338, 35, 70, "ExampleSubsection",ExpressionUUID->"f14c53c2-eeb9-4748-bc07-7fe9a1ab2aa7",
 CellID->2136504387],
Cell[104389, 2798, 168, 3, 70, "ExampleText",ExpressionUUID->"39dfa786-0569-4c32-adfb-cb639b56598b",
 CellID->364132405],
Cell[CellGroupData[{
Cell[104582, 2805, 199, 4, 70, "Input",ExpressionUUID->"51be8d0d-7d54-48fb-906d-a5b6b5437db8",
 CellID->1562364985],
Cell[104784, 2811, 1194, 19, 70, "Output",ExpressionUUID->"02a773d7-50a1-4421-8821-1074d942fe9c",
 CellID->1162197456]
}, Open  ]],
Cell[105993, 2833, 157, 2, 70, "ExampleText",ExpressionUUID->"5bde9d0a-c9e7-4e5b-ad8e-d663d88683c2",
 CellID->765471262],
Cell[CellGroupData[{
Cell[106175, 2839, 254, 5, 70, "Input",ExpressionUUID->"3d185ee4-6aca-4dc5-a9ac-e21f0200e2e2",
 CellID->605461210],
Cell[106432, 2846, 562, 10, 70, "Output",ExpressionUUID->"75799e66-1559-4693-aaa4-442e8f690f6f",
 CellID->1159803934]
}, Open  ]],
Cell[107009, 2859, 145, 1, 70, "ExampleText",ExpressionUUID->"0c5d5d64-1bba-415b-9ac5-5c0f0558410f",
 CellID->145811587],
Cell[CellGroupData[{
Cell[107179, 2864, 251, 5, 70, "Input",ExpressionUUID->"f7fc90f2-4891-4bf7-ad8b-7833cc326e90",
 CellID->766243994],
Cell[107433, 2871, 292, 6, 70, "Output",ExpressionUUID->"b3ae452e-0edc-4c6a-a576-3016927c0dc7",
 CellID->881625832]
}, Open  ]],
Cell[107740, 2880, 187, 4, 70, "ExampleText",ExpressionUUID->"0e3928dd-66f2-49b1-8636-5837a8636e90",
 CellID->512540497],
Cell[CellGroupData[{
Cell[107952, 2888, 218, 4, 70, "Input",ExpressionUUID->"93c6e691-cee0-4b4f-8241-9fca272aaeed",
 CellID->186456889],
Cell[108173, 2894, 349, 7, 70, "Output",ExpressionUUID->"145e4908-d899-482a-9ea8-6e9cb4a00788",
 CellID->1539567378]
}, Open  ]],
Cell[108537, 2904, 147, 1, 70, "ExampleText",ExpressionUUID->"7ec36462-b48f-4cd5-9edc-6e0f6a4d0a9a",
 CellID->1654332481],
Cell[CellGroupData[{
Cell[108709, 2909, 214, 4, 70, "Input",ExpressionUUID->"7f2781ed-355c-488a-91cb-f8ffc7b5bf0f",
 CellID->983525746],
Cell[108926, 2915, 180, 3, 70, "Output",ExpressionUUID->"f117045f-6543-40a3-bb06-c67018cb2f4b",
 CellID->999434145]
}, Open  ]],
Cell[109121, 2921, 261, 4, 70, "ExampleText",ExpressionUUID->"75034fb1-c456-4e52-b14c-3ae2dfbaeae3",
 CellID->2139715476],
Cell[CellGroupData[{
Cell[109407, 2929, 259, 5, 70, "Input",ExpressionUUID->"c4cdc9a2-cb29-4eda-a25f-1b56c79a65cc",
 CellID->747039788],
Cell[109669, 2936, 239, 5, 70, "Output",ExpressionUUID->"c551106b-8e91-424a-ab0e-3bd58fb822ed",
 CellID->963632969]
}, Open  ]],
Cell[CellGroupData[{
Cell[109945, 2946, 259, 5, 70, "Input",ExpressionUUID->"a4548daa-7ccc-4778-9761-11ba9fea0298",
 CellID->2076562432],
Cell[110207, 2953, 187, 4, 70, "Output",ExpressionUUID->"2cc93b75-b60c-4f2b-ac26-acd9018592f0",
 CellID->831633551]
}, Open  ]],
Cell[CellGroupData[{
Cell[110431, 2962, 267, 6, 70, "Input",ExpressionUUID->"2cd04f90-1634-4077-87b9-33b27f5bd9ea",
 CellID->1844538083],
Cell[110701, 2970, 219, 5, 70, "Output",ExpressionUUID->"3c7b1190-d314-4cca-81c5-84be0ba36711",
 CellID->2110556507]
}, Open  ]],
Cell[110935, 2978, 352, 6, 70, "ExampleText",ExpressionUUID->"f3964183-efc1-48e5-8c56-03ffdd95071e",
 CellID->1041180973],
Cell[CellGroupData[{
Cell[111312, 2988, 575, 14, 70, "Input",ExpressionUUID->"a1c16587-16bb-471c-86a4-d96b6039f906",
 CellID->457000053],
Cell[111890, 3004, 664, 20, 70, "Output",ExpressionUUID->"211ace30-e327-43c3-ba79-cc1ebe8f33b8",
 CellID->1752938102]
}, Open  ]],
Cell[112569, 3027, 351, 6, 70, "ExampleText",ExpressionUUID->"b37429e7-d3d4-4ae3-a557-a530bec6bf74",
 CellID->1647306824],
Cell[CellGroupData[{
Cell[112945, 3037, 748, 17, 70, "Input",ExpressionUUID->"017143cc-7647-4ca4-9fd3-096faf249735",
 CellID->1160374838],
Cell[113696, 3056, 3372, 92, 70, "Output",ExpressionUUID->"1ce0125f-fbe4-499d-8725-de4637459aa3",
 CellID->1485848233]
}, Open  ]],
Cell[117083, 3151, 211, 4, 70, "ExampleText",ExpressionUUID->"ba13fa44-8933-4a5b-a944-3eb6956c478f",
 CellID->314682110],
Cell[CellGroupData[{
Cell[117319, 3159, 786, 18, 70, "Input",ExpressionUUID->"a1480860-3955-4a8e-b07b-0e3a064e4193",
 CellID->1694185590],
Cell[118108, 3179, 5001, 150, 70, "Output",ExpressionUUID->"02585814-435a-4df3-879b-5e37aa8b422e",
 CellID->205241860]
}, Open  ]],
Cell[123124, 3332, 175, 3, 70, "ExampleText",ExpressionUUID->"4b16cd90-38de-4f51-aa12-9afd4ec19f6b",
 CellID->1193162250],
Cell[CellGroupData[{
Cell[123324, 3339, 225, 4, 70, "Input",ExpressionUUID->"96d1cc59-1fe6-4c39-a0e8-829dc43a4513",
 CellID->1215793266],
Cell[123552, 3345, 273, 6, 70, "Output",ExpressionUUID->"2d93291c-5345-4459-8a65-f7cf8b885cfc",
 CellID->724362671]
}, Open  ]],
Cell[123840, 3354, 215, 4, 70, "ExampleText",ExpressionUUID->"9a826388-a0c1-487a-9f13-867c92976fa4",
 CellID->675823636],
Cell[CellGroupData[{
Cell[124080, 3362, 272, 6, 70, "Input",ExpressionUUID->"055bfc42-0e21-4d91-96d9-fee00f1b18eb",
 CellID->527315707],
Cell[124355, 3370, 241, 5, 70, "Output",ExpressionUUID->"d117982a-5a3f-43ef-9d9e-8349b596d2a6",
 CellID->2094429361]
}, Open  ]],
Cell[124611, 3378, 139, 1, 70, "ExampleText",ExpressionUUID->"4ea511d5-351b-4517-a695-e8210c6c312d",
 CellID->1118380814],
Cell[CellGroupData[{
Cell[124775, 3383, 786, 17, 70, "Input",ExpressionUUID->"2ec5dbf0-17f5-4be8-bf78-57dcaf041733",
 CellID->1884676213],
Cell[125564, 3402, 1252, 38, 70, "Output",ExpressionUUID->"23b8c556-d6da-4551-b327-b8e0a7e00dad",
 CellID->1498430464]
}, Open  ]],
Cell[126831, 3443, 234, 4, 70, "ExampleText",ExpressionUUID->"50ce5f81-85d3-4bd9-86b3-87b862d3ee0d",
 CellID->369627294],
Cell[CellGroupData[{
Cell[127090, 3451, 635, 15, 70, "Input",ExpressionUUID->"b2a1239b-0f8a-4931-bce4-82c3f68a7124",
 CellID->29398679],
Cell[127728, 3468, 1252, 38, 70, "Output",ExpressionUUID->"90a572ff-2253-442e-81dd-355c0909ba95",
 CellID->1177418731]
}, Open  ]],
Cell[128995, 3509, 367, 6, 70, "ExampleText",ExpressionUUID->"1366e0ab-3505-4962-bd6a-0ffc3a5e0efc",
 CellID->2128620423],
Cell[CellGroupData[{
Cell[129387, 3519, 350, 8, 70, "Input",ExpressionUUID->"82dccf2c-366b-49f9-a675-5896e717349c",
 CellID->960006848],
Cell[129740, 3529, 227, 5, 70, "Output",ExpressionUUID->"a7d67658-28a7-4b90-b0cf-42c0ca10f475",
 CellID->661691039]
}, Open  ]],
Cell[CellGroupData[{
Cell[130004, 3539, 349, 8, 70, "Input",ExpressionUUID->"9bfc3197-ed15-4d2e-9f70-042e7f12e7a8",
 CellID->936214639],
Cell[130356, 3549, 158, 3, 70, "Output",ExpressionUUID->"ae987c28-0f7e-467a-baf3-01c374e1733a",
 CellID->1888535667]
}, Open  ]],
Cell[CellGroupData[{
Cell[130551, 3557, 355, 8, 70, "Input",ExpressionUUID->"5fa1a79b-aa47-4fa9-881b-8673241af52c",
 CellID->1117869723],
Cell[130909, 3567, 157, 3, 70, "Output",ExpressionUUID->"70487e21-0eab-4238-8dd9-319f81f19f07",
 CellID->152909354]
}, Open  ]],
Cell[131081, 3573, 331, 5, 70, "ExampleText",ExpressionUUID->"b964f614-d2c0-4786-96ce-539e922fac2c",
 CellID->253567167],
Cell[CellGroupData[{
Cell[131437, 3582, 1099, 28, 70, "Input",ExpressionUUID->"5d859b89-8536-4915-8570-4f9a36b8a55a",
 CellID->2051281499],
Cell[132539, 3612, 345, 8, 70, "Output",ExpressionUUID->"8aa2e73b-f39c-4c45-b79c-9a100b58d80c",
 CellID->57130853]
}, Open  ]],
Cell[132899, 3623, 148, 1, 70, "ExampleText",ExpressionUUID->"6f4b8da4-5345-4a52-8ea0-5d64d01aecc1",
 CellID->1790150459],
Cell[CellGroupData[{
Cell[133072, 3628, 1145, 29, 70, "Input",ExpressionUUID->"65f1d3ea-b2f2-48e7-9dd1-494693006557",
 CellID->1671101656],
Cell[134220, 3659, 1897, 55, 70, "Output",ExpressionUUID->"92400ab9-87f7-4e8b-add5-a59ee8bf240a",
 CellID->1807943276]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "0"}, Closed]]]],
Cell[CellGroupData[{
Cell[136269, 3722, 1369, 35, 70, "ExampleSubsection",ExpressionUUID->"7cb423ce-1675-4a42-a8b8-f8f0fd84ed27",
 CellID->1575759718],
Cell[137641, 3759, 152, 1, 70, "ExampleText",ExpressionUUID->"d04aabdc-686d-4d24-bb68-d2c609becb13",
 CellID->627613756],
Cell[137796, 3762, 398, 10, 70, "Input",ExpressionUUID->"f8952d3b-63da-4c44-a3e0-4e335b6d8b1f",
 CellID->1174477421],
Cell[138197, 3774, 170, 3, 70, "ExampleText",ExpressionUUID->"e466508d-7e29-4537-a370-d7f26fb6d386",
 CellID->772175812],
Cell[CellGroupData[{
Cell[138392, 3781, 350, 8, 70, "Input",ExpressionUUID->"0c6644a2-b60e-43c0-8dfd-032539b7962d",
 CellID->1767104182],
Cell[138745, 3791, 227, 5, 70, "Output",ExpressionUUID->"c38297f2-21ae-4639-828d-2541fdc3adec",
 CellID->1593425816]
}, Open  ]],
Cell[138987, 3799, 140, 1, 70, "ExampleText",ExpressionUUID->"bd808789-a3b3-4124-a1aa-2a0540361c34",
 CellID->180962701],
Cell[139130, 3802, 481, 13, 70, "Input",ExpressionUUID->"821d4d0c-3c85-4d1d-acac-37ce6a518a81",
 CellID->598286335],
Cell[139614, 3817, 172, 3, 70, "ExampleText",ExpressionUUID->"a215c7f4-0d15-49f0-8030-5d073c9b056f",
 CellID->1711626820],
Cell[CellGroupData[{
Cell[139811, 3824, 354, 8, 70, "Input",ExpressionUUID->"61246576-b23d-4ac9-9e9e-fd18d2f3ea48",
 CellID->1880489417],
Cell[140168, 3834, 156, 3, 70, "Output",ExpressionUUID->"61c35e11-77bc-461c-8f87-a6a00f770462",
 CellID->715411880]
}, Open  ]],
Cell[CellGroupData[{
Cell[140361, 3842, 347, 8, 70, "Input",ExpressionUUID->"bab687ea-98df-4266-b84a-06de5854720b",
 CellID->89910732],
Cell[140711, 3852, 157, 3, 70, "Output",ExpressionUUID->"9f012ee0-489b-4dee-b5f8-023914971d48",
 CellID->1169212898]
}, Open  ]],
Cell[140883, 3858, 205, 4, 70, "Input",ExpressionUUID->"80f876d7-4f56-4885-bd48-523f01e3f72b",
 CellID->2052448431],
Cell[141091, 3864, 269, 6, 70, "Input",ExpressionUUID->"5e129f53-35ca-4290-a189-3946260a0ca0",
 CellID->704308732],
Cell[141363, 3872, 170, 3, 70, "ExampleText",ExpressionUUID->"8305167c-d7f4-4680-9609-25e2428b98b1",
 CellID->1378926138],
Cell[CellGroupData[{
Cell[141558, 3879, 590, 14, 70, "Input",ExpressionUUID->"a48ffd90-59d7-467c-8b58-c6c2b0d9068c",
 CellID->469269385],
Cell[142151, 3895, 6480, 194, 70, "Output",ExpressionUUID->"bfd4a1b9-9903-4d67-9e4c-60a40993c18d",
 CellID->1069457000]
}, Open  ]],
Cell[148646, 4092, 217, 4, 70, "ExampleText",ExpressionUUID->"4d10925e-2715-4c05-b22a-11f194a4f546",
 CellID->1229376872],
Cell[148866, 4098, 419, 10, 70, "Input",ExpressionUUID->"dad72cd8-6e8e-4541-8822-9ce305f671ff",
 CellID->1342131151],
Cell[CellGroupData[{
Cell[149310, 4112, 296, 7, 70, "Input",ExpressionUUID->"041bec57-1b02-422b-909d-209f25042e53",
 CellID->313793529],
Cell[149609, 4121, 711, 26, 70, "Output",ExpressionUUID->"f9183390-42fb-4a99-bbe3-aaeb6b32ec8c",
 CellID->879599042]
}, Open  ]],
Cell[CellGroupData[{
Cell[150357, 4152, 586, 14, 70, "Input",ExpressionUUID->"3bbf0610-3969-4aa1-98e6-a634f6bf0623",
 CellID->1964980169],
Cell[150946, 4168, 772, 27, 70, "Output",ExpressionUUID->"24a9e0b7-5639-4f87-a335-6b43396d0225",
 CellID->2115788446]
}, Open  ]],
Cell[151733, 4198, 157, 2, 70, "ExampleText",ExpressionUUID->"7c6d56f3-6314-486d-a460-0670f2c25305",
 CellID->882573653],
Cell[CellGroupData[{
Cell[151915, 4204, 679, 15, 70, "Input",ExpressionUUID->"f641fe49-8a67-402f-935b-fdb824312fcb",
 CellID->314270606],
Cell[CellGroupData[{
Cell[152619, 4223, 376, 9, 70, "Print",ExpressionUUID->"643cd05f-d260-4519-bd09-d8f1e9dc013e",
 CellID->283057013],
Cell[152998, 4234, 173, 2, 70, "Print",ExpressionUUID->"457f6d7b-1c67-4fd7-950c-4dbdf613c6b5",
 CellID->1162895898],
Cell[153174, 4238, 457, 12, 70, "Print",ExpressionUUID->"45a48451-8b09-4abc-860d-87b08eaa84ea",
 CellID->840787806],
Cell[153634, 4252, 173, 2, 70, "Print",ExpressionUUID->"56a93dfc-d76f-4c59-aba3-8a31aa9a39b0",
 CellID->1662107411],
Cell[153810, 4256, 494, 13, 70, "Print",ExpressionUUID->"83a8d49c-7e4c-4520-958d-03e9ab26c741",
 CellID->320934702],
Cell[154307, 4271, 367, 7, 70, "Print",ExpressionUUID->"8c611291-1062-4a25-b95d-8828cb458c93",
 CellID->1567713321],
Cell[154677, 4280, 442, 8, 70, "Print",ExpressionUUID->"eefc147e-1922-45aa-9791-52811adb8840",
 CellID->2490664],
Cell[155122, 4290, 465, 12, 70, "Print",ExpressionUUID->"d9367a7d-d19c-4416-bdaa-c6e4299ead17",
 CellID->634509932],
Cell[155590, 4304, 173, 2, 70, "Print",ExpressionUUID->"7d830153-1559-446e-8d7d-05b8dda687c2",
 CellID->1929364740],
Cell[155766, 4308, 443, 11, 70, "Print",ExpressionUUID->"564638d5-9cfe-4acd-9d9e-d4f4158d3a30",
 CellID->452516443],
Cell[156212, 4321, 171, 2, 70, "Print",ExpressionUUID->"35dda08e-d254-4e59-b6d4-734801f4df9a",
 CellID->88853025],
Cell[156386, 4325, 329, 7, 70, "Print",ExpressionUUID->"2ca31cb7-dabf-4989-9fde-33c4e445934e",
 CellID->1460018657],
Cell[156718, 4334, 173, 2, 70, "Print",ExpressionUUID->"0d7abfda-cf79-45d2-8006-3d5e90d176c2",
 CellID->2060411631],
Cell[156894, 4338, 493, 13, 70, "Print",ExpressionUUID->"52f3476f-6a77-4ab6-8f07-cccffc6e34c0",
 CellID->1560572553],
Cell[157390, 4353, 367, 7, 70, "Print",ExpressionUUID->"af478b32-239b-4238-ae3d-3fc16a0fe927",
 CellID->1123297694],
Cell[157760, 4362, 445, 8, 70, "Print",ExpressionUUID->"1681df4a-b120-46b5-9315-2be2e7a0c5ac",
 CellID->1171434293],
Cell[158208, 4372, 461, 9, 70, "Print",ExpressionUUID->"040ac977-2188-4cc1-aa6f-9dc1db66f74e",
 CellID->336781630],
Cell[158672, 4383, 470, 12, 70, "Print",ExpressionUUID->"9652f0c1-26bd-4058-9d47-73ae1930679f",
 CellID->950763892],
Cell[159145, 4397, 367, 7, 70, "Print",ExpressionUUID->"64b9f279-a9af-48a9-821f-6da4f3c03410",
 CellID->1229032503],
Cell[159515, 4406, 444, 8, 70, "Print",ExpressionUUID->"bdaab01c-8c47-43d0-ac53-c5787b7a8b27",
 CellID->158389721],
Cell[159962, 4416, 462, 9, 70, "Print",ExpressionUUID->"fd2c4c05-5a14-4cd7-8d18-1a16528bc3fe",
 CellID->1657829133],
Cell[160427, 4427, 419, 11, 70, "Print",ExpressionUUID->"a9602cc1-a78e-4d1e-9262-f6f10d4e3e51",
 CellID->1254935512],
Cell[160849, 4440, 366, 7, 70, "Print",ExpressionUUID->"961eab00-3d66-4884-bcc8-fc5099ff1311",
 CellID->128923853],
Cell[161218, 4449, 444, 8, 70, "Print",ExpressionUUID->"654fb3d2-73ef-481c-a469-3a4a843414b0",
 CellID->105222840],
Cell[161665, 4459, 452, 8, 70, "Print",ExpressionUUID->"ce610a25-b1a7-4447-8f4c-4142029cc25a",
 CellID->717704907]
}, Open  ]],
Cell[162132, 4470, 131, 2, 70, "Output",ExpressionUUID->"a9af63ea-a0d9-467f-a5e0-f938b0005be4",
 CellID->1439764459]
}, Open  ]],
Cell[162278, 4475, 313, 8, 70, "ExampleText",ExpressionUUID->"e3108d95-7e4c-4e93-8452-ad16ab8fa7ed",
 CellID->100452798],
Cell[CellGroupData[{
Cell[162616, 4487, 550, 13, 70, "Input",ExpressionUUID->"b42cbe27-3e94-4ad5-ba6b-91549dc7647f",
 CellID->1553958542],
Cell[163169, 4502, 303, 6, 70, "Output",ExpressionUUID->"7d086395-8709-4bfb-b419-c44ba5247a07",
 CellID->592542694]
}, Open  ]],
Cell[CellGroupData[{
Cell[163509, 4513, 243, 5, 70, "ExampleDelimiter",ExpressionUUID->"92d0bd85-0e5c-403a-85c3-383cbe2d7472",
 CellID->1006782030],
Cell[163755, 4520, 207, 4, 70, "ExampleText",ExpressionUUID->"d8c4932b-f3c8-4ab1-a581-589578012ae4",
 CellID->1950229257],
Cell[163965, 4526, 397, 10, 70, "Input",ExpressionUUID->"15a0550c-e150-4f00-a95e-863f80659012",
 CellID->739398804],
Cell[CellGroupData[{
Cell[164387, 4540, 272, 6, 70, "Input",ExpressionUUID->"ece31abb-6647-4b24-b22e-fbce823b905d",
 CellID->1614799796],
Cell[164662, 4548, 239, 5, 70, "Output",ExpressionUUID->"615933b5-1878-4fd7-b61f-bc113cdaf283",
 CellID->846446184]
}, Open  ]],
Cell[164916, 4556, 140, 1, 70, "ExampleText",ExpressionUUID->"c71767df-8cba-4189-a031-875e848325ce",
 CellID->744331517],
Cell[165059, 4559, 495, 13, 70, "Input",ExpressionUUID->"149ae47f-2f90-4ec9-b5ca-9fcc97c37fab",
 CellID->1754000017],
Cell[165557, 4574, 171, 3, 70, "ExampleText",ExpressionUUID->"b9ec8d12-3999-4380-8e60-497206c84d7b",
 CellID->173144395],
Cell[CellGroupData[{
Cell[165753, 4581, 270, 6, 70, "Input",ExpressionUUID->"7b2b5430-4df9-4987-865a-fb7db1172206",
 CellID->676263427],
Cell[166026, 4589, 157, 3, 70, "Output",ExpressionUUID->"0e3cb6fa-a9a5-46f3-a4e4-9e52de70525d",
 CellID->1929557848]
}, Open  ]],
Cell[166198, 4595, 269, 6, 70, "Input",ExpressionUUID->"be4349cb-47f3-4201-8b2d-02a9b0b2e214",
 CellID->264605598],
Cell[CellGroupData[{
Cell[166492, 4605, 549, 12, 70, "Input",ExpressionUUID->"f1b9e49e-2c17-44cc-8640-5aa8631c2fab",
 CellID->1859794150],
Cell[167044, 4619, 2419, 79, 70, "Output",ExpressionUUID->"fb88983c-1338-475c-a229-7229628f2067",
 CellID->1407002681]
}, Open  ]],
Cell[169478, 4701, 137, 1, 70, "ExampleText",ExpressionUUID->"d7ed1101-f5fb-4d77-ab18-cddcc323bb04",
 CellID->1564574589],
Cell[CellGroupData[{
Cell[169640, 4706, 546, 12, 70, "Input",ExpressionUUID->"efe30895-39e6-4b82-b5ca-462cf5911c10",
 CellID->63816491],
Cell[CellGroupData[{
Cell[170211, 4722, 376, 9, 70, "Print",ExpressionUUID->"143ddbef-8c57-4b9a-89bf-2ee1eb52b561",
 CellID->1332239541],
Cell[170590, 4733, 172, 2, 70, "Print",ExpressionUUID->"6838a84b-dd2b-411f-a498-f3c0375bed37",
 CellID->1802969734],
Cell[170765, 4737, 456, 12, 70, "Print",ExpressionUUID->"bf0520c7-eea8-4f4f-a2ad-1b91b413903f",
 CellID->465222075],
Cell[171224, 4751, 172, 2, 70, "Print",ExpressionUUID->"685309ce-d4ae-4d7f-8a57-c399d12dbf04",
 CellID->1843059213],
Cell[171399, 4755, 494, 13, 70, "Print",ExpressionUUID->"fea26a98-2c11-41f8-82d0-9106e0281c24",
 CellID->1398762266],
Cell[171896, 4770, 365, 7, 70, "Print",ExpressionUUID->"5f4c8f28-fb44-4dfa-9b98-9916d97a82a2",
 CellID->848861383],
Cell[172264, 4779, 443, 8, 70, "Print",ExpressionUUID->"7a925560-b3e8-4e5c-8a83-90c50f3637d4",
 CellID->450185254],
Cell[172710, 4789, 465, 12, 70, "Print",ExpressionUUID->"0484b224-29f4-4f3c-8cd6-440c50564e87",
 CellID->1453896655],
Cell[173178, 4803, 172, 2, 70, "Print",ExpressionUUID->"d8b17088-b25c-4e3e-b640-7eeabffe7fb9",
 CellID->1088729128],
Cell[173353, 4807, 441, 11, 70, "Print",ExpressionUUID->"a8d145c0-2bbc-4e81-a5fa-576e6342f3b7",
 CellID->36406164],
Cell[173797, 4820, 172, 2, 70, "Print",ExpressionUUID->"79290c43-6c33-434e-b5b7-5e9dfb9f89b1",
 CellID->1779397693],
Cell[173972, 4824, 328, 7, 70, "Print",ExpressionUUID->"4470e1c4-216b-4a35-842a-c32b24fddfd7",
 CellID->1157864263],
Cell[174303, 4833, 171, 2, 70, "Print",ExpressionUUID->"621f55c1-2154-4e3b-aff6-4b1bc8e8f096",
 CellID->273739226],
Cell[174477, 4837, 492, 13, 70, "Print",ExpressionUUID->"c50f9684-6bb6-4952-a008-d3442307680f",
 CellID->1223891163],
Cell[174972, 4852, 366, 7, 70, "Print",ExpressionUUID->"b2a87729-22e5-4778-8a91-5f0001833e6e",
 CellID->1726660191],
Cell[175341, 4861, 444, 8, 70, "Print",ExpressionUUID->"d4e558dd-686d-42ed-a7e6-c57dde500f15",
 CellID->1152462313],
Cell[175788, 4871, 456, 8, 70, "Print",ExpressionUUID->"bd7dccb9-40ac-4d2b-ae88-e1b75a480dab",
 CellID->1002391986],
Cell[176247, 4881, 470, 12, 70, "Print",ExpressionUUID->"64f2ad81-72a8-4e0e-a354-0587fe2a67e3",
 CellID->1878061810],
Cell[176720, 4895, 366, 7, 70, "Print",ExpressionUUID->"14a974b8-eb65-4da9-a2d1-63942148e475",
 CellID->1030409548],
Cell[177089, 4904, 443, 8, 70, "Print",ExpressionUUID->"edb88029-0b97-41c0-b6d1-0f9b0010b503",
 CellID->814810312],
Cell[177535, 4914, 454, 8, 70, "Print",ExpressionUUID->"ae9f6fac-46b8-4a98-a458-17c200477261",
 CellID->1559446990],
Cell[177992, 4924, 417, 11, 70, "Print",ExpressionUUID->"9820ecb6-5baa-4388-a053-1e748b0e859d",
 CellID->521259256],
Cell[178412, 4937, 365, 7, 70, "Print",ExpressionUUID->"84d5e8f4-f053-431f-a867-2a938308a644",
 CellID->709727060],
Cell[178780, 4946, 444, 8, 70, "Print",ExpressionUUID->"395f26ef-b381-4eea-92cb-bc23fcc2c4cd",
 CellID->2008826732],
Cell[179227, 4956, 449, 8, 70, "Print",ExpressionUUID->"6e553553-72e4-4ed6-9e72-32f022028e46",
 CellID->478856958]
}, Open  ]],
Cell[179691, 4967, 129, 2, 70, "Output",ExpressionUUID->"3a6428fb-2bc7-426d-bc32-3b780b9dcef5",
 CellID->510558652]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[179869, 4975, 241, 5, 70, "ExampleDelimiter",ExpressionUUID->"9aeb7b1a-9997-489d-a32a-a3619a4ee184",
 CellID->26560194],
Cell[180113, 4982, 140, 1, 70, "ExampleText",ExpressionUUID->"dbeeea31-8b2a-489e-9e90-acd8c2ca83e0",
 CellID->1428433302],
Cell[180256, 4985, 158, 2, 70, "ExampleText",ExpressionUUID->"db27784f-2d6e-49b1-b4d7-931016773374",
 CellID->1876895984],
Cell[180417, 4989, 397, 10, 70, "Input",ExpressionUUID->"0804bf35-df00-43ce-a324-657072f61104",
 CellID->697279325],
Cell[CellGroupData[{
Cell[180839, 5003, 265, 6, 70, "Input",ExpressionUUID->"8805f8b9-038c-49b3-9803-775debda98d9",
 CellID->1303076876],
Cell[181107, 5011, 226, 5, 70, "Output",ExpressionUUID->"80528df2-9548-41b2-b041-dbe3143caa51",
 CellID->906298517]
}, Open  ]],
Cell[181348, 5019, 482, 13, 70, "Input",ExpressionUUID->"fbcbe1c9-51bc-429c-ac3d-ce8e4f324f91",
 CellID->1028563305],
Cell[CellGroupData[{
Cell[181855, 5036, 262, 6, 70, "Input",ExpressionUUID->"2ceb5444-26c5-4055-9358-ba36c5cf6a72",
 CellID->87605643],
Cell[182120, 5044, 208, 5, 70, "Output",ExpressionUUID->"2f9fe227-4008-4a80-adfc-bea4bd14fa09",
 CellID->1661999694]
}, Open  ]],
Cell[182343, 5052, 279, 7, 70, "Input",ExpressionUUID->"5e4c257e-3191-4c6e-b142-a180ec118887",
 CellID->1582813412],
Cell[182625, 5061, 247, 6, 70, "Input",ExpressionUUID->"8a83792b-a3f0-4546-a0cb-11d8c06261c0",
 CellID->1648988072],
Cell[CellGroupData[{
Cell[182897, 5071, 270, 6, 70, "Input",ExpressionUUID->"7401c074-77ee-48e0-bbda-f1babe081416",
 CellID->2137620324],
Cell[183170, 5079, 200, 4, 70, "Output",ExpressionUUID->"4f3d4059-b91b-4613-8389-cabeccf6e1ea",
 CellID->383509811]
}, Open  ]],
Cell[183385, 5086, 137, 1, 70, "ExampleText",ExpressionUUID->"641ce64e-095d-4a85-9102-875c089efdfc",
 CellID->1442181122],
Cell[CellGroupData[{
Cell[183547, 5091, 448, 11, 70, "Input",ExpressionUUID->"9450cdc9-0024-4545-9901-f218c9e490b2",
 CellID->2106134881],
Cell[183998, 5104, 1464, 54, 70, "Output",ExpressionUUID->"5ab8ef32-42eb-4c88-b85c-fd796d81d5ef",
 CellID->2069194415]
}, Open  ]],
Cell[185477, 5161, 134, 1, 70, "ExampleText",ExpressionUUID->"101efcff-fa7e-424a-b578-8220df39bf44",
 CellID->1760082945],
Cell[185614, 5164, 281, 7, 70, "Input",ExpressionUUID->"a50d0e3c-fe56-414c-b45d-dc89b06f5bf1",
 CellID->1932626767],
Cell[185898, 5173, 112, 1, 70, "ExampleText",ExpressionUUID->"42551e02-ccd9-4f06-a21f-f410530c8262",
 CellID->355303852],
Cell[CellGroupData[{
Cell[186035, 5178, 729, 17, 70, "Input",ExpressionUUID->"30c41cd2-ef82-42d8-a495-2b68b959b2f5",
 CellID->354247573],
Cell[186767, 5197, 22573, 682, 70, "Output",ExpressionUUID->"fe520329-8265-4480-8339-3c77d2fe62c9",
 CellID->2045617222]
}, Open  ]],
Cell[209355, 5882, 136, 1, 70, "ExampleText",ExpressionUUID->"f6050ba6-2dba-40ac-8559-e4ab21ef9328",
 CellID->973951945],
Cell[CellGroupData[{
Cell[209516, 5887, 728, 17, 70, "Input",ExpressionUUID->"cbf4cf61-3d06-49c8-9c65-12285eadd9d9",
 CellID->242645470],
Cell[CellGroupData[{
Cell[210269, 5908, 377, 9, 70, "Print",ExpressionUUID->"946ca8d7-3191-4057-a961-17c93e9a0dbd",
 CellID->1923017173],
Cell[210649, 5919, 173, 2, 70, "Print",ExpressionUUID->"7d63ee4c-ab1a-48ff-a80d-1c8be5f67997",
 CellID->2048107886],
Cell[210825, 5923, 457, 12, 70, "Print",ExpressionUUID->"35c4f9d8-a75e-4c88-b328-29015061a05d",
 CellID->877155402],
Cell[211285, 5937, 173, 2, 70, "Print",ExpressionUUID->"3c3e0765-ad4e-4578-a87e-6125fa6a7705",
 CellID->1704898266],
Cell[211461, 5941, 494, 13, 70, "Print",ExpressionUUID->"ce351a9e-ef70-42af-b286-09506cafccac",
 CellID->353140681],
Cell[211958, 5956, 366, 7, 70, "Print",ExpressionUUID->"7d7798b1-e3dd-42ac-9143-f9c23965a47f",
 CellID->966008427],
Cell[212327, 5965, 445, 8, 70, "Print",ExpressionUUID->"1abe67a8-c467-41e7-ab7c-0da2e4566f07",
 CellID->1017433275],
Cell[212775, 5975, 465, 12, 70, "Print",ExpressionUUID->"cee65919-c128-4404-a280-552fcc9b23f6",
 CellID->266068664],
Cell[213243, 5989, 172, 2, 70, "Print",ExpressionUUID->"0c5b4ddb-6a8b-4534-b3f2-9cfb79cd41ea",
 CellID->379097332],
Cell[213418, 5993, 444, 11, 70, "Print",ExpressionUUID->"8a5f5b9b-bc22-4150-a219-30e6b5092b71",
 CellID->2140730969],
Cell[213865, 6006, 173, 2, 70, "Print",ExpressionUUID->"9aa1ba59-9f7a-4950-9f55-78d7d9ebd6e1",
 CellID->1437502958],
Cell[214041, 6010, 328, 7, 70, "Print",ExpressionUUID->"bcc38c45-3874-4d8d-a4ea-8e56caeaf1f7",
 CellID->715878962],
Cell[214372, 6019, 172, 2, 70, "Print",ExpressionUUID->"036ef515-a8ff-40c5-8992-71afe9820c33",
 CellID->944011214],
Cell[214547, 6023, 492, 13, 70, "Print",ExpressionUUID->"58e10189-7596-4f7a-b825-15fe4d5b34e0",
 CellID->519051813],
Cell[215042, 6038, 366, 7, 70, "Print",ExpressionUUID->"428d7653-13ca-4bed-a5ee-71b8361c9646",
 CellID->874268684],
Cell[215411, 6047, 444, 8, 70, "Print",ExpressionUUID->"9fcf344f-91b7-4273-91b5-a998f5ec610b",
 CellID->454356699],
Cell[215858, 6057, 462, 9, 70, "Print",ExpressionUUID->"c14b9ca6-a7a9-4047-a1b1-63e588443082",
 CellID->1773987325],
Cell[216323, 6068, 471, 12, 70, "Print",ExpressionUUID->"2078019c-f635-4c99-b7a8-092b9003d125",
 CellID->1003192537],
Cell[216797, 6082, 366, 7, 70, "Print",ExpressionUUID->"dd91255b-8a11-4d3f-ab9b-f2c5433aa1a7",
 CellID->559579540],
Cell[217166, 6091, 444, 8, 70, "Print",ExpressionUUID->"d7bdd692-98d2-4997-9ab0-c27321536e31",
 CellID->344208585],
Cell[217613, 6101, 461, 9, 70, "Print",ExpressionUUID->"f05622be-3ad5-4d1d-a5f1-a3ec36ed979d",
 CellID->295473349],
Cell[218077, 6112, 419, 11, 70, "Print",ExpressionUUID->"01b5c646-3859-4558-a136-6f3146cfcbe8",
 CellID->2113538082],
Cell[218499, 6125, 366, 7, 70, "Print",ExpressionUUID->"3d4d0742-ade1-402d-a0c4-856ca285967f",
 CellID->936751279],
Cell[218868, 6134, 444, 8, 70, "Print",ExpressionUUID->"c0353513-b588-4610-b92d-5abc246efc05",
 CellID->395926147],
Cell[219315, 6144, 452, 8, 70, "Print",ExpressionUUID->"6c4a2704-5a83-4fcb-9daa-b595a39277d4",
 CellID->872352952]
}, Open  ]],
Cell[219782, 6155, 130, 2, 70, "Output",ExpressionUUID->"7c3cb86b-54ff-4c96-a47c-fe825c470bcd",
 CellID->451267325]
}, Open  ]]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "1"}, Closed]]]],
Cell[CellGroupData[{
Cell[220076, 6166, 1360, 35, 70, "ExampleSubsection",ExpressionUUID->"18751f84-911f-44bd-be05-5cf119f85ff4",
 CellID->1813521204],
Cell[221439, 6203, 137, 1, 70, "ExampleText",ExpressionUUID->"2015bd5c-8db3-4f4b-8ac0-4322303ad75b",
 CellID->1959965972],
Cell[CellGroupData[{
Cell[221601, 6208, 218, 4, 70, "Input",ExpressionUUID->"3dd409d2-389e-4efe-a070-f8beca3c4b0d",
 CellID->1146987898],
Cell[221822, 6214, 1902, 30, 70, "Output",ExpressionUUID->"7faac6de-b627-462e-97ae-0b2e06f35ce8",
 CellID->779435958]
}, Open  ]],
Cell[223739, 6247, 158, 2, 70, "ExampleText",ExpressionUUID->"4446d8e6-c2d8-42d3-9e04-e4cf712dabb2",
 CellID->888601957],
Cell[CellGroupData[{
Cell[223922, 6253, 223, 4, 70, "Input",ExpressionUUID->"16a0d7b6-d1d4-41ee-8480-5afa955e5a95",
 CellID->1159615630],
Cell[224148, 6259, 578, 10, 70, "Output",ExpressionUUID->"a9234b82-ccf2-42e3-8de3-d7f7e8818d16",
 CellID->794063719]
}, Open  ]],
Cell[CellGroupData[{
Cell[224763, 6274, 216, 4, 70, "Input",ExpressionUUID->"f5eb6ac0-3397-4016-806b-de75c8b50634",
 CellID->238552055],
Cell[224982, 6280, 314, 6, 70, "Output",ExpressionUUID->"c4e67129-394d-403e-8801-9680276cfdec",
 CellID->806571178]
}, Open  ]],
Cell[225311, 6289, 160, 2, 70, "ExampleText",ExpressionUUID->"e870494d-9b64-44c7-bb40-54902162b86b",
 CellID->630997382],
Cell[CellGroupData[{
Cell[225496, 6295, 251, 5, 70, "Input",ExpressionUUID->"8bc99a68-9e5e-4cef-9e85-ff6c6cff64ca",
 CellID->727866619],
Cell[225750, 6302, 292, 6, 70, "Output",ExpressionUUID->"2607f5a6-8980-401f-a92c-2ab7f010f021",
 CellID->677569532]
}, Open  ]],
Cell[CellGroupData[{
Cell[226079, 6313, 260, 5, 70, "Input",ExpressionUUID->"5dd23a84-5a08-4aee-8565-36d00f87f375",
 CellID->711265452],
Cell[226342, 6320, 296, 6, 70, "Output",ExpressionUUID->"788b7861-3c5e-410c-b0c0-c278ca7accbb",
 CellID->1036709189]
}, Open  ]],
Cell[CellGroupData[{
Cell[226675, 6331, 257, 5, 70, "Input",ExpressionUUID->"5fc3bc19-d82e-4b11-8616-8b633b37297d",
 CellID->2098165431],
Cell[226935, 6338, 402, 7, 70, "Output",ExpressionUUID->"e8acb5a6-9402-4758-88cb-d8ef12887cc5",
 CellID->582104703]
}, Open  ]],
Cell[227352, 6348, 147, 1, 70, "ExampleText",ExpressionUUID->"ab43f5f4-539d-40a1-bbfb-f295736eca6f",
 CellID->1162852654],
Cell[CellGroupData[{
Cell[227524, 6353, 267, 6, 70, "Input",ExpressionUUID->"ad039c1e-f218-47f7-bca1-eaf5f0f185ed",
 CellID->1968009751],
Cell[227794, 6361, 561, 10, 70, "Output",ExpressionUUID->"a87a5cd3-529b-49fd-8f85-f9fcef3ae8e6",
 CellID->578193770]
}, Open  ]],
Cell[CellGroupData[{
Cell[228392, 6376, 270, 6, 70, "Input",ExpressionUUID->"d1977b7a-dd8d-4487-b5fd-d8cc5ed92f85",
 CellID->2055609263],
Cell[228665, 6384, 193, 4, 70, "Output",ExpressionUUID->"7d25d169-6a6a-4754-bec8-20d0aad99555",
 CellID->139519321]
}, Open  ]],
Cell[CellGroupData[{
Cell[228895, 6393, 273, 6, 70, "Input",ExpressionUUID->"6331d0b3-6d34-4704-843e-738cfdb88fbc",
 CellID->931334451],
Cell[229171, 6401, 272, 6, 70, "Output",ExpressionUUID->"6744a597-716f-482a-bf5f-125c84e978fb",
 CellID->732389370]
}, Open  ]],
Cell[CellGroupData[{
Cell[229480, 6412, 269, 6, 70, "Input",ExpressionUUID->"61284ae5-c8d6-4b31-b81f-60fc730fa84b",
 CellID->1122148095],
Cell[229752, 6420, 241, 5, 70, "Output",ExpressionUUID->"d92d1606-5df8-4874-8656-29912f0f8bc7",
 CellID->1156952597]
}, Open  ]],
Cell[CellGroupData[{
Cell[230030, 6430, 268, 6, 70, "Input",ExpressionUUID->"8619adac-dfb2-4319-9ba1-38e233d3261d",
 CellID->2106857486],
Cell[230301, 6438, 158, 3, 70, "Output",ExpressionUUID->"0ba56849-ac1a-45ef-9b4d-cbe5f7098ce6",
 CellID->1919752574]
}, Open  ]],
Cell[CellGroupData[{
Cell[230496, 6446, 273, 6, 70, "Input",ExpressionUUID->"daf953d4-8cbc-42fa-9f19-08fba36a7654",
 CellID->1145673053],
Cell[230772, 6454, 158, 3, 70, "Output",ExpressionUUID->"948d7118-fe04-4bdc-a0d4-e3a3b1c451f9",
 CellID->1431409139]
}, Open  ]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSubsection", "2"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "ExampleSection", "1"}, Closed]]]]
}, Dynamic[CurrentValue[EvaluationNotebook[], {TaggingRules, "Openers", "PrimaryExamplesSection"}, Closed]]]],
Cell[231287, 6469, 78, 0, 40, "FooterCell",ExpressionUUID->"9fe12d11-38e2-4708-86c6-d96c30237aca"]
}
]
*)

(* End of internal cache information *)

