(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    860135,      22149]
NotebookOptionsPosition[    732713,      20335]
NotebookOutlinePosition[    737263,      20447]
CellTagsIndexPosition[    736977,      20435]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "xAct",
 StyleBox["`", "MB"],
 "xPerm",
 StyleBox["`", "MB"]
}], "Subsection",
 FontSize->18,
 CellTags->{
  "S5.18.1", "1.1"},ExpressionUUID->"766dbcbd-18c0-43c3-be2c-40f283008ea4"],

Cell[TextData[StyleBox["This is the doc file xPermDoc.nb of version 1.2.3 of \
xPerm`. Last update on 28 February 2018.",
 FontFamily->"Arial"]], "Text",ExpressionUUID->"f6925233-5dcf-4315-bf74-\
87fe9521f420"],

Cell[CellGroupData[{

Cell["Author", "SubsubsectionIcon",ExpressionUUID->"a400b7c5-162b-4efa-a199-6efd34692a6e"],

Cell[TextData[{
 StyleBox["\[Copyright] 2003-2018, under the GNU General Public License (GPL)",
  FontFamily->"Arial"],
 "\n     ",
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a",
  FontWeight->"Bold"],
 "\n\t",
 StyleBox["jose@xact.es",
  FontFamily->"Courier"],
 "\n\t",
 StyleBox["https://xact.es\n",
  FontFamily->"Courier"],
 StyleBox["xPerm`", "MR"],
 " is a scientific project, and has been published in the article\n\tJos\
\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a, \"",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 ": fast index canonicalization for tensor computer algebra\", Comp. Phys. \
Commun. 179 (2008) 597-603.\nUsers of ",
 StyleBox["xPerm`", "MR"],
 " are requested to cite that article in any work in which the package is \
used."
}], "Text",ExpressionUUID->"e90ff518-5dce-4e53-a147-88ebb67fbdbe"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Intro", "SubsubsectionIcon",ExpressionUUID->"a1a3087b-0f0a-4824-8073-8aa7da3614ac"],

Cell[TextData[{
 StyleBox["xPerm`", "MR"],
 " extends ",
 StyleBox["Mathematica", "TI"],
 " capabilities in computations with large groups of permutations. This \
package can be used independently, but it has been created as a tool for its \
twin package ",
 StyleBox["xTensor`", "MR"],
 " of abstract tensor manipulations. There are two main objectives in the \
package:\n\t1) Computation of a Strong Generating Set (SGS) for a group of \
permutations, given a generating set (GS) for that group. We use the \
Schreier-Sims algorithm, as encoded by Butler:\n\t\tG. Butler, \"Fundamental \
Algorithms for Permutation Groups\", Springer-Verlag, Berlin Heidelberg 1991.\
\n\t     The companion notebook ",
 StyleBox["ButlerExamples.nb",
  FontFamily->"Courier"],
 " contains the solutions (worked out with ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 ") of many examples in that book. Some of them have wrong answers in the \
book and have been corrected.\n\t2) Computation of canonical representatives \
of cosets and double cosets. We use Portugal's algorithms:\n\t\tR. Portugal \
and B.F. Svaiter, \"Group-theoretic Approach for Symbolic Tensor \
Manipulation: I. Free indices\", math-ph/0107031\n\t\tL.R.U. Manssur and R. \
Portugal, \"Group-theoretic Approach for Symbolic Tensor Manipulation: II. \
Dummy indices\", math-ph/0107032\n\t\tL.R.U. Manssur, R. Portugal and B.F. \
Svaiter, \"Group-theoretic Approach for Symbolic Tensor Manipulation\", Int. \
J. Mod. Phys. C13 (2002), 859--880.\n",
 StyleBox["xPerm`", "MR"],
 " is not, and will never be, a serious alternative to professional packages \
like GAP or MAGMA for algebraic computations. It just solves those two issues \
needed in ",
 StyleBox["xTensor`", "MR"],
 ", plus adding some commodity tools.\n",
 StyleBox["xPerm`", "MR"],
 " is directly coded up in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language, which is interpreted and hence rather slow. Executables called \
xperm.linux, xperm.mac or xperm.win (depending on your system) are given to \
improve significantly the speed of the hardest computations. A ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "  connection is set up to communicate MathKernel with that executable. Note \
that the Windows executable can only be linked with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " versions 6.0 or later because the cygwin compilers were not supported by \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in previous versions.\nI thank\n\t- Paolo Matteucci for suggesting the use \
of Portugal's algorithms to do index canonicalization.\n\t- Alfonso Garc\
\[IAcute]a-Parrado, Kasper Peeters, Renato Portugal and David Yllanes for \
helpful comments and suggestions, and for their help in testing the system."
}], "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"690e39f3-7ba5-459a-b536-bb58a3383d93"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load the package", "SubsubsectionIcon",ExpressionUUID->"f6c91643-d159-4c9c-bc31-f84aa9d94542"],

Cell[TextData[{
 "This loads the package from the default directory ",
 StyleBox["$HOME/.Mathematica/Applications/xAct",
  FontFamily->"Courier"],
 " for a single-user implementation under Linux, or from ",
 StyleBox["/user/local/Wolfram/Mathematica/5.2/AddOns/Applications/xAct",
  FontFamily->"Courier"],
 " for a system-wide installation. For installation under Windows or Mac see \
the Installation Notes."
}], "MathCaption",
 CellTags->{
  "S5.18.1", "1.3"},ExpressionUUID->"267183c5-1c79-4a81-ba01-ed2a262e6fbf"],

Cell[CellGroupData[{

Cell["<<xAct`xPerm`", "Input",
 CellTags->"S5.18.1",
 CellLabel->"In[1]:=",ExpressionUUID->"81cd42e2-30e0-40c3-b1cc-46e55ecb16b7"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"be915988-13db-4109-8901-a91082cb0bed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"c991fd0d-7b91-4e92-8ec0-623c14ef8ab5"],

Cell[BoxData["\<\"CopyRight (C) 2003-2018, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"24888a6e-ce67-417d-a159-0d626ed3d58f"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a754bf74-2e8f-4783-9e2a-c0df7d7c002c"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7f76a2a7-486b-47e9-8bd9-b39638671f64"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"0a19d73f-7334-432f-855e-aa368f7d2453"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"b526af1b-91a1-431e-a5a4-21f0f1c7c758"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"183d17af-2f3d-4bd5-9040-e22cbe31b263"]
}, Open  ]],

Cell[TextData[{
 "We append the Doc directory of ",
 StyleBox["xAct`",
  FontFamily->"Courier"],
 " to the file path to find example files below:"
}], "MathCaption",ExpressionUUID->"ae2042a4-3e1d-4887-814a-12e99e806075"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$Path", ",", "$xActDocDirectory"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"a4c4cfcd-f39a-4742-8a5d-3290092a52b2"],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " built-in ",
 StyleBox["Timing",
  FontFamily->"Courier"],
 " does not include the time spent in the external executables, though ",
 StyleBox["AbsoluteTiming",
  FontFamily->"Courier"],
 " does it. We introduce our own timing function:"
}], "MathCaption",ExpressionUUID->"ccf67b49-8aa3-4096-ad51-6bdbe7418efd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"myTiming", ",", "HoldFirst"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myTiming", "[", "expr_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"time", ",", "result"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"time", "=", 
      RowBox[{"SessionTime", "[", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"result", "=", "expr"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"SessionTime", "[", "]"}], "-", "time"}], ")"}], "Second"}], 
      "]"}], ";", "\[IndentingNewLine]", "result"}]}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"971655d6-323d-4d03-b736-87c0d0dd89fb"],

Cell[TextData[{
 StyleBox["Technical notes:\n",
  FontWeight->"Bold"],
 "There are three global variables storing information on the connection to \
the external executable:"
}], "Text",ExpressionUUID->"daa62e7e-37e8-423a-b87d-703d58e30790"],

Cell["Whether the connection was possible or not is stored in", "MathCaption",ExpressionUUID->"85c79bb1-e8f3-41aa-a820-ba04f90ec244"],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"64084757-d5ef-4451-a6de-a27863b9100d"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[5]=",ExpressionUUID->"81ffc939-e150-41f1-a5b4-845fedc312cb"]
}, Open  ]],

Cell["The name of the executable is given by", "MathCaption",ExpressionUUID->"451ce6f1-1664-4160-82a1-812829d4b5bb"],

Cell[CellGroupData[{

Cell[BoxData["$xpermExecutable"], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"e4fb52cf-281c-4c5b-8637-1413698b9c9e"],

Cell[BoxData["\<\"/Users/jose/Library/Mathematica/Applications/xAct//xPerm/\
mathlink/xperm.mac\"\>"], "Output",
 CellLabel->"Out[6]=",ExpressionUUID->"9b39a2c3-2541-4a2a-91fd-bbae09b64b41"]
}, Open  ]],

Cell["The full description of the link is", "MathCaption",ExpressionUUID->"ad13f2d1-44e2-4ab5-9387-cadb7a348e62"],

Cell[CellGroupData[{

Cell[BoxData["$xpermLink"], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"b87387da-19e8-4036-8c6a-f23e52a9fb92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["LinkObject",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEBitmaps", "SquarePlusIconMedium"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              Evaluator -> Automatic, Method -> "Preemptive"], 
             Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 3.5 CurrentValue["FontCapHeight"]/
                AbsoluteCurrentValue[Magnification]}]], 
            GraphicsBox[{
              Thickness[0.038461538461538464`], {
               FaceForm[{
                 GrayLevel[0.93], 
                 Opacity[1.]}], 
               
               FilledCurveBox[{{{1, 4, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
                1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}}}, {{{
                25.499999999999996`, 2.5}, {25.499999999999996`, 
                1.3953100000000003`}, {24.604699999999998`, 
                0.49999999999999994`}, {23.5, 0.49999999999999994`}, {2.5, 
                0.49999999999999994`}, {1.3953100000000003`, 
                0.49999999999999994`}, {0.49999999999999994`, 
                1.3953100000000003`}, {0.49999999999999994`, 2.5}, {
                0.49999999999999994`, 23.5}, {0.49999999999999994`, 
                24.604699999999998`}, {1.3953100000000003`, 
                25.499999999999996`}, {2.5, 25.499999999999996`}, {23.5, 
                25.499999999999996`}, {24.604699999999998`, 
                25.499999999999996`}, {25.499999999999996`, 
                24.604699999999998`}, {25.499999999999996`, 23.5}, {
                25.499999999999996`, 2.5}}}]}, {
               FaceForm[{
                 RGBColor[0.5, 0.5, 0.5], 
                 Opacity[1.]}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{20.5426, 
                19.116799999999998`}, {16.3832, 21.876199999999997`}, {
                16.3832, 20.021499999999996`}, {6.930469999999999, 
                20.021499999999996`}, {6.930469999999999, 
                18.212100000000003`}, {16.3832, 18.212100000000003`}, {
                16.3832, 16.357399999999995`}, {20.5426, 
                19.116799999999998`}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{5.30508, 13.8391}, {
                9.46445, 11.079700000000003`}, {9.46445, 
                12.933999999999997`}, {18.917199999999998`, 
                12.933999999999997`}, {18.917199999999998`, 14.7438}, {
                9.46445, 14.7438}, {9.46445, 16.598}, {5.30508, 13.8391}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{5.30508, 13.8391}, {
                9.46445, 11.079700000000003`}, {9.46445, 
                12.933999999999997`}, {18.917199999999998`, 
                12.933999999999997`}, {18.917199999999998`, 14.7438}, {
                9.46445, 14.7438}, {9.46445, 16.598}, {5.30508, 13.8391}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
                0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0,
                 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIRIGYC4sIjUTVcAooO8+XdOPpnKDg8YkwNXuen7JA2
W/qycJSgw5sbHEde31CB82PFhGf3n1V1aFVgVz0zR8oBrF9czWFHsFXE/9Wy
Dje0Dj4qiFWDy7cVLYptDVKH65/g6Xbu0HMNOB9sn4I23H6w+SWacD5De8DS
tDQNB7ldC/alskg4aD2+nx6joeFgnPFi/oMZog5B9vlaQa/UHao9k7f0KUhA
+D/UUPVbqML5jCB+oIpDzJHypGv8Eg4eGad3ikiqwM2T57H5LndPGW6eya7m
GzMvKcH1o4cXABG3d/Y=
                "]], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}}}, {{{14.163129999999999`, 
                4.337966249999999}, {16.96813, 4.337966249999999}, {16.96813, 
                5.047809999999999}, {14.98813, 5.047809999999999}, {14.98813, 
                8.29796625}, {14.163129999999999`, 8.29796625}, {
                14.163129999999999`, 4.337966249999999}}}]}}, Background -> 
             GrayLevel[0.93], Axes -> False, AspectRatio -> 1, 
             ImageSize -> {Automatic, 
               Dynamic[
               3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification]), ImageSizeCache -> {45., {0., 9.}}]}, Frame -> 
             True, FrameTicks -> None, FrameStyle -> Directive[
               Thickness[Tiny], 
               GrayLevel[0.7]]], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  StyleBox[
                   PaneBox[
                   "\"'/Users/jose/Library/Mathematica/Applications/xAct//\
xPerm/mathlink/xperm.mac'\"", ContentPadding -> False, FrameMargins -> 0, 
                    StripOnInput -> True, BaselinePosition -> Baseline, 
                    ImageSize -> {{1, 300}, Automatic}], LineBreakWithin -> 
                   False], "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Link mode: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["Listen", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEBitmaps", "SquareMinusIconMedium"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              Evaluator -> Automatic, Method -> "Preemptive"], 
             Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 3.5 CurrentValue["FontCapHeight"]/
                AbsoluteCurrentValue[Magnification]}]], 
            GraphicsBox[{
              Thickness[0.038461538461538464`], {
               FaceForm[{
                 GrayLevel[0.93], 
                 Opacity[1.]}], 
               
               FilledCurveBox[{{{1, 4, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
                1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}}}, {{{
                25.499999999999996`, 2.5}, {25.499999999999996`, 
                1.3953100000000003`}, {24.604699999999998`, 
                0.49999999999999994`}, {23.5, 0.49999999999999994`}, {2.5, 
                0.49999999999999994`}, {1.3953100000000003`, 
                0.49999999999999994`}, {0.49999999999999994`, 
                1.3953100000000003`}, {0.49999999999999994`, 2.5}, {
                0.49999999999999994`, 23.5}, {0.49999999999999994`, 
                24.604699999999998`}, {1.3953100000000003`, 
                25.499999999999996`}, {2.5, 25.499999999999996`}, {23.5, 
                25.499999999999996`}, {24.604699999999998`, 
                25.499999999999996`}, {25.499999999999996`, 
                24.604699999999998`}, {25.499999999999996`, 23.5}, {
                25.499999999999996`, 2.5}}}]}, {
               FaceForm[{
                 RGBColor[0.5, 0.5, 0.5], 
                 Opacity[1.]}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{20.5426, 
                19.116799999999998`}, {16.3832, 21.876199999999997`}, {
                16.3832, 20.021499999999996`}, {6.930469999999999, 
                20.021499999999996`}, {6.930469999999999, 
                18.212100000000003`}, {16.3832, 18.212100000000003`}, {
                16.3832, 16.357399999999995`}, {20.5426, 
                19.116799999999998`}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{5.30508, 13.8391}, {
                9.46445, 11.079700000000003`}, {9.46445, 
                12.933999999999997`}, {18.917199999999998`, 
                12.933999999999997`}, {18.917199999999998`, 14.7438}, {
                9.46445, 14.7438}, {9.46445, 16.598}, {5.30508, 13.8391}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{5.30508, 13.8391}, {
                9.46445, 11.079700000000003`}, {9.46445, 
                12.933999999999997`}, {18.917199999999998`, 
                12.933999999999997`}, {18.917199999999998`, 14.7438}, {
                9.46445, 14.7438}, {9.46445, 16.598}, {5.30508, 13.8391}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
                0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0,
                 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIRIGYC4sIjUTVcAooO8+XdOPpnKDg8YkwNXuen7JA2
W/qycJSgw5sbHEde31CB82PFhGf3n1V1aFVgVz0zR8oBrF9czWFHsFXE/9Wy
Dje0Dj4qiFWDy7cVLYptDVKH65/g6Xbu0HMNOB9sn4I23H6w+SWacD5De8DS
tDQNB7ldC/alskg4aD2+nx6joeFgnPFi/oMZog5B9vlaQa/UHao9k7f0KUhA
+D/UUPVbqML5jCB+oIpDzJHypGv8Eg4eGad3ikiqwM2T57H5LndPGW6eya7m
GzMvKcH1o4cXABG3d/Y=
                "]], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}}}, {{{14.163129999999999`, 
                4.337966249999999}, {16.96813, 4.337966249999999}, {16.96813, 
                5.047809999999999}, {14.98813, 5.047809999999999}, {14.98813, 
                8.29796625}, {14.163129999999999`, 8.29796625}, {
                14.163129999999999`, 4.337966249999999}}}]}}, Background -> 
             GrayLevel[0.93], Axes -> False, AspectRatio -> 1, 
             ImageSize -> {Automatic, 
               Dynamic[
               3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification]), ImageSizeCache -> {45., {0., 9.}}]}, Frame -> 
             True, FrameTicks -> None, FrameStyle -> Directive[
               Thickness[Tiny], 
               GrayLevel[0.7]]], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  PaneBox[
                  "\"'/Users/jose/Library/Mathematica/Applications/xAct//\
xPerm/mathlink/xperm.mac'\"", ImageSize -> {{1, 500}, Automatic}, 
                   BaselinePosition -> Baseline, ContentPadding -> False, 
                   FrameMargins -> 0, StripOnInput -> True], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Link mode: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["Listen", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Link protocol: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"SharedMemory\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel",
     DisplayFunction->(
      ButtonBox[#, Active -> False, Alignment -> Left, 
       Appearance -> {
        "Default" -> 
         FrontEnd`FileName[{"Typeset", "SummaryBox"}, "Panel.9.png"]}, 
       FrameMargins -> 7, BaseStyle -> {}, 
       DefaultBaseStyle -> {"Panel", Background -> None}, BaselinePosition -> 
       Baseline]& )],
    DynamicModuleValues:>{}], "]"}],
  LinkObject[
  "'/Users/jose/Library/Mathematica/Applications/xAct//xPerm/mathlink/xperm.\
mac'", 183, 7],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->"Out[7]=",ExpressionUUID->"42270b78-2afc-4e02-b995-c4687eab8590"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell["Basic group theory", "Subsection",ExpressionUUID->"cdc867de-209c-4285-9480-dc3cde6cc69a"],

Cell[CellGroupData[{

Cell["0. Mathematical notes", "SubsectionIcon",ExpressionUUID->"6730f55b-8726-4dd6-9514-ae654baec150"],

Cell["\<\
This is a very brief (and highly compact) recollection of definitions and \
results in permutation-group theory, taken from Butler 1991.
\t- A permutation group G acts on a set of points P on the right.
\t- The image of p in P under g in G is denoted p^g and (p^g)^h = p^(gh) for \
all p, g and h.
\t- The orbit of p under G is the set p^G={p^g | g in G} of images of p.
\t- The pointwise stabilizer of p in G is the group G_p={g in G | p^g=p} of \
elements that fix p.
\t- A base for G is a sequence B={b1, b2, ..., bk} of points such that only \
the identity element of G fixes all points in the base.
\t- Associated with a base there is a chain of subgroup stabilizers G^(i), \
i=1, 2, ..., k+1, where G^(i)=G_{b1, b2, ..., b_(i-1)}.
\t- A subset S of G is a strong generating set of G relative to B if S \
contains a generating set for each stabilizer G^(i) in the chain.
\t- If we define a total order on P, then there is an induced lexicographical \
order on G and on the base images B^G. If we insist that b1, b2, ..., bk are \
the first k points of P then the order on G corresponds to the order on the \
base images. In any case, the identity element is the smallest element of the \
group.
\t- Given a group G and a stabilizer G_b there is a one-to-one correspondence \
between the cosets of G_b in G and the points of the orbit b^G. Using the \
order of permutations defined in the previous point we can choose a \
representative in each of those cosets. 
\t- An element g of G is uniquely determined by its base image B^g = {b1^g, \
b2^g, ..., bk^g}. Actually there is a unique decomposition of g as a product \
of the representatives of the cosets identified by those images.
\t- This equivalence between permutations and base images is the key for a \
plethora of highly efficient algorithms which can answer any question on the \
group by using backtracking through the hierarchy of cosets and stabilizers.\
\>", "Text",ExpressionUUID->"cadb087c-b8ec-443a-ad5a-135a016cd44a"]
}, Closed]],

Cell[CellGroupData[{

Cell["1. Notations for permutations", "SubsectionIcon",ExpressionUUID->"394e66dc-327d-4adf-a23b-45a0a1f31b94"],

Cell[TextData[{
 "There are many ways to encode a permutation of several objects. This \
package uses four of them. For example suppose that the collection of six \
objects\n\t\[HeartSuit]\t\[WatchIcon]\t\[EmptySquare]\t\[EmptyCircle]\t\
\[HappySmiley]\t\[EmptyUpTriangle]\nis reordered to\n\t\[EmptySquare]\t\
\[WatchIcon]\t\[EmptyCircle]\t\[HeartSuit]\t\[EmptyUpTriangle]\t\
\[HappySmiley]\n1) We can say that the first object (a heart) has gone to the \
fourth place (it is conventional to say that the \"image\" of \"point\" 1 is \
point 4), and so on. If we number the initial objects from 1 to 6, one \
natural way of encoding this permutation would be\n\t",
 StyleBox["Perm[{3, 2, 4, 1, 6, 5}]\n", "Input"],
 "Note that the point 2 is not moved by the permutation. It is called a \
\"singleton\".",
 StyleBox["\n", "Input"],
 "2) Another natural way of encoding the permutation would be just listing \
the images of the six points:\n\t",
 StyleBox["Images[{4, 2, 1, 3, 6, 5}]\n", "Input"],
 "3) It is well known that any permutation can be understood as a set of \
disjoint cycles where the image of each point is written on its right and the \
image of the last point of the cycle is the first one:\n\t",
 StyleBox["Cycles[{1, 4, 3}, {5, 6}]\n", "Input"],
 "By convention, singleton cycles like {2} are removed from the cyclic \
notation.\n4) Finally, it is particularly efficient in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to represent permutations using rules:\n\t",
 StyleBox["Rules[1->4, 4->3, 3->1, 5->6, 6->5]\n", "Input"],
 "Again, note that the singleton has not been included."
}], "Text",ExpressionUUID->"97d83658-2938-4793-99bb-68e8a44b8be4"],

Cell[TextData[StyleBox["Perm[list]\t\t\t\tImages[list]\nCycles[cycles]\t\t\t\
Rules[rules]", "DisplayMath"]], "DefinitionBox",ExpressionUUID->"a9f9dd65-\
943d-43ee-a81e-71bf87220eb9"],

Cell[TextData[StyleBox["Notations for permutations.", "SmallText"]], "Text",ExpressionUUID->"1c301353-8ac4-41d8-b1ac-1938375966d5"],

Cell[TextData[{
 "Naturally, permutations form a group under the law of multiplication. For \
example all permutations of n points form the so-called symmetric group ",
 Cell[BoxData[
  SubscriptBox["S", "n"]],ExpressionUUID->
  "32a85097-0e89-487e-8b7c-4102a2b818a9"],
 ". However there is another important superstructure that will be very \
useful when working with tensor symmetries: an algebra. We shall define laws \
of addition of permutations and of multiplication by scalars. At the moment \
we only assume that permutations can be given a sign (-1 or +1). It that \
sense, following R. Portugal, we are working on {-1,1}\[Times]",
 Cell[BoxData[
  SubscriptBox["S", "n"]],ExpressionUUID->
  "985d6910-23b9-4ad7-a3c5-ef04f00c7134"],
 ". An example of signed permutation is:\n\t",
 StyleBox["- Perm[{2, 3, 4, 1}]", "Input"]
}], "Text",ExpressionUUID->"b6cfba51-1d2d-40a7-832a-bc83f85a5838"],

Cell["We can translate from one notation to other notation:", "MathCaption",ExpressionUUID->"136ef75f-7919-4aa5-a107-0a94037e9a75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  StyleBox[
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{
      "3", ",", " ", "2", ",", " ", "4", ",", " ", "1", ",", " ", "6", ",", 
       " ", "5"}], "}"}], "]"}], ",", " ", "Images"}], "Input"], 
  StyleBox["]", "Input"]}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"384feb8e-4222-4699-a29b-e6992b2151a9"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "2", ",", "1", ",", "3", ",", "6", ",", "5"}], "}"}], 
  "]"}]], "Output",
 CellLabel->"Out[14]=",ExpressionUUID->"6fc00a5b-3369-48ea-a4a1-f6ae9bf7ae63"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  StyleBox[
   RowBox[{"%", ",", " ", "Cycles"}], "Input"], 
  StyleBox["]", "Input"]}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"118e3998-080b-48aa-953a-576e270cb528"],

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[15]=",ExpressionUUID->"62b451b3-c898-44d9-9275-4660f45d49e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  StyleBox[
   RowBox[{"%", ",", "Rules"}], "Input"], 
  StyleBox["]", "Input"]}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"e5867821-dae0-4313-aecf-02d6beea7fdc"],

Cell[BoxData[
 RowBox[{"Rules", "[", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "4"}], ",", 
   RowBox[{"4", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "1"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}], ",", 
   RowBox[{"6", "\[Rule]", "5"}]}], "]"}]], "Output",
 CellLabel->"Out[16]=",ExpressionUUID->"3516a7cf-f129-40d2-ae16-955c4276b647"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  RowBox[{"%", ",", "Perm"}], "]"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"717942f3-a9c6-4948-87fe-b4b2713c14c8"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "2", ",", "4", ",", "1", ",", "6", ",", "5"}], "}"}], 
  "]"}]], "Output",
 CellLabel->"Out[17]=",ExpressionUUID->"b9f441e1-a504-4f24-9d14-2366a82d9805"]
}, Open  ]],

Cell["The sign just remains untouched:", "MathCaption",ExpressionUUID->"ca73af2e-cfe6-472d-b36c-36d3198eb1ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  RowBox[{
   RowBox[{"-", 
    StyleBox[
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{
       "3", ",", " ", "2", ",", " ", "4", ",", " ", "1", ",", " ", "6", ",", 
        " ", "5"}], "}"}], "]"}], "Input"]}], 
   StyleBox[",", "Input"], 
   StyleBox[" ", "Input"], 
   StyleBox["Images", "Input"]}], 
  StyleBox["]", "Input"]}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"5660a704-e26e-4c9b-82f2-40dd20935108"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Images", "[", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "1", ",", "3", ",", "6", ",", "5"}], "}"}], 
   "]"}]}]], "Output",
 CellLabel->"Out[18]=",ExpressionUUID->"6a3f2cac-777c-4046-a3fa-f7c587d0fca0"]
}, Open  ]],

Cell["The notation of a permutation is given by", "MathCaption",ExpressionUUID->"07aa7054-9563-4d11-8bbd-31f584e7833a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotationOfPerm", "[", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"4640fd99-4891-4579-973e-39d3fac48b6a"],

Cell[BoxData["Cycles"], "Output",
 CellLabel->"Out[19]=",ExpressionUUID->"0c1e3b1b-940d-46f2-a928-a27608665346"]
}, Open  ]],

Cell[TextData[{
 StyleBox["TranslatePerm\t\t", "DisplayMath"],
 StyleBox["Change permutation to a given notation\n", "Text"],
 StyleBox["NotationOfPerm\t\t", "DisplayMath"],
 StyleBox["Returns the notation of a permutation", "Text"]
}], "DefinitionBox",ExpressionUUID->"670f6be3-5d9f-4c56-9af0-a716d005d291"],

Cell["Translation and notation of permutations.", "SmallText",ExpressionUUID->"c78fa8a1-db2b-4a54-b75f-39c668bbbe5b"]
}, Closed]],

Cell[CellGroupData[{

Cell["2. Operations with permutations", "SubsectionIcon",ExpressionUUID->"266002ce-4afe-44c9-80c9-2a23c61a01c1"],

Cell[TextData[{
 "By default, ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " does not check at every step that the objects we are working with are \
actually permutations because it would take quite some time. The function ",
 StyleBox["PermQ",
  FontFamily->"Courier"],
 " is supplied to do that when you require it."
}], "Text",ExpressionUUID->"78b426b3-013b-409c-975c-a9aef321d544"],

Cell[TextData[{
 "We can validate a permutation with ",
 StyleBox["PermQ",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"95c8abf0-1375-4201-be34-197752f35d67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermQ", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "0"}], "}"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[20]:=",ExpressionUUID->"6d9deed0-2ffc-42df-97b7-7e388f35c05e"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[20]=",ExpressionUUID->"f2d07f47-d7d1-49b7-b95d-933e39c6a860"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermQ", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[21]:=",ExpressionUUID->"5c7aefb7-cba9-4586-8054-3ef7ad206878"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[21]=",ExpressionUUID->"8cb5ad6a-918a-48b3-a81c-a35ceab85eb9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermQ", "[", 
  RowBox[{"Images", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[22]:=",ExpressionUUID->"20dce1de-9e92-4c4d-843c-3734d173dee7"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[22]=",ExpressionUUID->"5acf6cc3-76b0-4529-8a6e-905d8de1d669"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermQ", "[", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2."}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"cedf2015-108f-453b-b6ab-1e9fbfe7ced0"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[23]=",ExpressionUUID->"427f2235-648b-431c-acc5-8e53b182e0ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermQ", "[", 
  RowBox[{"Rules", "[", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"e4814fa0-486b-4cd1-b9c3-97efa38a9479"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[24]=",ExpressionUUID->"e64c6316-e75c-431a-bb4f-685c4ec5639a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermQ", "[", 
  RowBox[{"-", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"055eb1cb-8573-4fb1-a002-3dbbccf01ac0"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[25]=",ExpressionUUID->"c5dace5c-8c9e-49cc-b008-1facd6c5cb7d"]
}, Open  ]],

Cell["\<\
Every permutation has a degree, defined as the largest moved point (signs are \
not relevant):\
\>", "MathCaption",ExpressionUUID->"7d828137-a565-4e94-a5d2-8c02b87cd9cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "5", ",", "2", ",", "1"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"f637bff0-9b88-4a50-b2ee-ac14ef89506f"],

Cell[BoxData["5"], "Output",
 CellLabel->"Out[26]=",ExpressionUUID->"b3f03ff0-043d-4ec1-8cc1-cbddc405787a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "[", 
  RowBox[{"-", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5", ",", "6", ",", "2", ",", "1"}], "}"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"541243ea-3174-4d80-8788-bbc966eea53c"],

Cell[BoxData["6"], "Output",
 CellLabel->"Out[27]=",ExpressionUUID->"c66b74ca-6267-40d8-ae78-4f5f865afafa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "[", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"55", ",", "78"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"3553de0d-7a0d-45ae-91d5-c3f444944a3b"],

Cell[BoxData["78"], "Output",
 CellLabel->"Out[28]=",ExpressionUUID->"8e022931-422a-42be-b5b6-4b41cf60d0c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"7112c407-3777-471c-a4ed-5b7258c43beb"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[29]=",ExpressionUUID->"1c583623-4149-4ee4-97b3-c60ae35e92ab"]
}, Open  ]],

Cell["The identity permutation has degree zero:", "MathCaption",ExpressionUUID->"a0d3a600-51ac-499c-96b6-697b772f6a12"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "[", 
  RowBox[{"Cycles", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"f8c78275-88a5-4eaa-aadf-01c64c54f070"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[30]=",ExpressionUUID->"ccd71de0-690e-49d6-bf23-0f7caf83215f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"ff7422d6-092c-47d6-a69b-0beb17c238d8"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[31]=",ExpressionUUID->"14ecf498-702f-4513-b69f-5cd507d16068"]
}, Open  ]],

Cell[TextData[{
 "A different concept is that of \"length\" of a permutation, defined only \
for notations ",
 StyleBox["Perm",
  FontFamily->"Courier"],
 " and ",
 StyleBox["Images",
  FontFamily->"Courier"],
 ": it is the length of the list of points. On ",
 StyleBox["Cycles",
  FontFamily->"Courier"],
 " and ",
 StyleBox["Rules",
  FontFamily->"Courier"],
 " notations length is defined as the degree. This concept is used in \
internal computations to avoid recomputing the degree of a permutation many \
times."
}], "MathCaption",ExpressionUUID->"4765603a-1ce4-4965-97ff-ce8db2a0cd7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"fca3b646-490d-497f-acaf-8ecd0dab3f25"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[32]=",ExpressionUUID->"70a5ad29-fab9-47cc-a7d3-5587345242d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermLength", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[33]:=",ExpressionUUID->"a10ce58a-5532-4d5c-bc44-aec5cb84daf7"],

Cell[BoxData["5"], "Output",
 CellLabel->"Out[33]=",ExpressionUUID->"f62cb94f-0e16-44df-b5ba-c2981ad44613"]
}, Open  ]],

Cell[TextData[{
 "On notations ",
 StyleBox["Perm",
  FontFamily->"Courier"],
 " and ",
 StyleBox["Images",
  FontFamily->"Courier"],
 " the function ",
 StyleBox["NotationOfPerm",
  FontFamily->"Courier"],
 " returns the length (not the degree):"
}], "MathCaption",ExpressionUUID->"9d07680c-93b3-48c9-876f-54663e80c672"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotationOfPerm", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"64cc5821-a972-437b-8321-7a8d53b6fc07"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Perm", ",", "5"}], "}"}]], "Output",
 CellLabel->"Out[34]=",ExpressionUUID->"232b6dbf-4211-4a4f-817c-f23397bdccf8"]
}, Open  ]],

Cell["\<\
It is possible to generate random permutations, of any notation\
\>", "MathCaption",ExpressionUUID->"f69d4967-56d9-478f-8634-15636002b558"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPerm", "[", 
  RowBox[{"10", ",", "Cycles"}], "]"}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"1cef3716-0f68-4771-8776-86a9be53033b"],

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "4", ",", "10", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7", ",", "5"}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[35]=",ExpressionUUID->"107c399a-f7b0-4809-920f-bcce6d6847ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPerm", "[", 
  RowBox[{"8", ",", "Images"}], "]"}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"7674427f-c9ff-47ab-b016-ae96a90513c1"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{
   "4", ",", "3", ",", "6", ",", "8", ",", "1", ",", "2", ",", "7", ",", 
    "5"}], "}"}], "]"}]], "Output",
 CellLabel->"Out[36]=",ExpressionUUID->"2a4b7438-0039-4013-b24f-f7fc00bbb5fb"]
}, Open  ]],

Cell["\<\
The most important operation with permutations is that of their product. I \
don't like names like Times or similar. I choose a name which is associated \
only with permutations:\
\>", "Text",ExpressionUUID->"bc546de5-7809-4620-87d2-1f76ad992177"],

Cell[TextData[{
 "Product of two permutations in the same notation. The (noncommutative) \
product is from right to left. This means that the product permutation ",
 StyleBox["PermProduct[",
  FontFamily->"Courier"],
 StyleBox["p1",
  FontVariations->{"CompatibilityType"->0}],
 ", ",
 StyleBox["p2",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["]",
  FontFamily->"Courier"],
 " applied on a given list is equivalent to the application of p1 on that \
list and then p2 on the result."
}], "MathCaption",ExpressionUUID->"218b1773-b509-4c34-a807-673bafaf165c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",ExpressionUUID->"cbc8d348-d9e6-4a76-bbae-0b41c36910a0"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "1", ",", "3"}], "}"}], "]"}]], "Output",
 CellLabel->"Out[37]=",ExpressionUUID->"6c761486-66f4-4d3e-976e-24b79fbc4dcf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",ExpressionUUID->"4ebfea04-2323-4d3a-9780-1e7d759fcdff"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "2"}], "}"}], "]"}]], "Output",
 CellLabel->"Out[38]=",ExpressionUUID->"87b37c15-b181-429f-8c4e-5d53d6ce1d6d"]
}, Open  ]],

Cell["\<\
That is the choice in GAP. This example is taken from its manual:\
\>", "MathCaption",ExpressionUUID->"7dee5af4-fd3d-4170-9a6d-aab07fcfc42c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermEqual", "[", 
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"d0826aaa-3d7e-47b8-8ae2-2702fe1c8949"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[39]=",ExpressionUUID->"d1c66253-fd08-476f-add3-bc0620451766"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermEqual", "[", 
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"96c4fc27-4e54-4781-b694-f4b799f49c89"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[40]=",ExpressionUUID->"5d1f78f2-8111-42fd-b92a-b6e3a0f52eef"]
}, Open  ]],

Cell["Inverse permutation:", "MathCaption",ExpressionUUID->"d54874c3-569e-423d-b8af-64a4b08977d8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InversePerm", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[41]:=",ExpressionUUID->"ca2fc7e2-376b-456e-8228-35c53a2b7a0a"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}]], "Output",
 CellLabel->"Out[41]=",ExpressionUUID->"e881a466-199f-4a87-8951-19374fbd5cfe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}], ",", "%"}], 
  "]"}]], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"b15b07bf-0627-4c5c-ae3b-3367f46cf24d"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Output",
 CellLabel->"Out[42]=",ExpressionUUID->"4f4728dd-18c2-4204-b1f0-fe95c66290cb"]
}, Open  ]],

Cell["\<\
Powers of a permutation (equivalent to repeated product with itself). \
Negative exponents mean powers of the inverse. Note the high efficiency of \
this function:\
\>", "MathCaption",ExpressionUUID->"63948a0f-e413-4527-9901-868f4b7abfce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{"PermPower", "[", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
    ",", "27"}], "]"}], "]"}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"aac93864-aa7c-440e-aefd-69a970e68e8f"],

Cell[BoxData[
 RowBox[{"0.000448`2.8017930118301377", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"57138a98-6308-40cd-8810-09abc7f988e3"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], 
  "]"}]], "Output",
 CellLabel->"Out[43]=",ExpressionUUID->"fd49a309-c36c-4ed2-a876-02dd72dcbfd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{"PermPower", "[", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
    ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"10", "^", "10"}]}], "-", "27"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"83e18eda-69b1-45f6-a8ae-82256bb6a5ff"],

Cell[BoxData[
 RowBox[{"0.001882`3.425134616923232", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[44]:=",ExpressionUUID->"1687423b-5030-4104-adb3-cebbc5468970"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], 
  "]"}]], "Output",
 CellLabel->"Out[44]=",ExpressionUUID->"c6fa0c24-71cf-4d0b-8c94-f70ee36c686d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{"%", ",", "%%"}], "]"}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"fe8d54a1-f39c-4fe0-9fe1-73aa50e32e3a"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], 
  "]"}]], "Output",
 CellLabel->"Out[45]=",ExpressionUUID->"4ed15727-8236-43ea-86d0-a3071458a1b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermPower", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",",
    "0"}], "]"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"4d15fd08-1832-47e2-af9f-ef2c2e772068"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], 
  "]"}]], "Output",
 CellLabel->"Out[46]=",ExpressionUUID->"62c198ce-5c7e-4fd0-9d08-e65eead78b13"]
}, Open  ]],

Cell["\<\
Permutations can be sorted and compared according to their lists of images:\
\>", "MathCaption",ExpressionUUID->"304bf320-177b-4986-b779-fb037a5a09ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"06b284ca-8d44-48ac-8104-405eda884be0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[47]=",ExpressionUUID->"aeefaa82-d8a5-4f5b-9dd9-34159dd18707"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  RowBox[{"%", ",", "Images"}], "]"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"9c926595-7180-44e8-b031-1fddcba7b424"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[48]=",ExpressionUUID->"c77d7c9f-be66-45e4-b96b-e4a40dc328de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermLess", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"b7f8a6f2-2ccf-4d4a-b2b7-8d08e43e339e"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[49]=",ExpressionUUID->"9986aa89-4e81-4bb6-8067-180609da4a42"]
}, Open  ]],

Cell[TextData[{
 "The function Perm",
 StyleBox["Equal",
  FontFamily->"Courier"],
 " checks mathematical equality of permutations comparing images of points \
and it is thus notation independent:"
}], "MathCaption",ExpressionUUID->"36ebcf76-db3d-4d53-8205-7d594cdbc714"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermEqual", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"c1758240-0c84-408f-962f-9e58f507f873"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[50]=",ExpressionUUID->"210b14ec-ccc3-4c2d-bbf1-c356072ed107"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cycles", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], "===", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"0b6ff003-cbe8-434d-8480-dc436d750ab7"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[51]=",ExpressionUUID->"5db88318-e27c-4468-b5f1-bff31cf27aa1"]
}, Open  ]],

Cell[TextData[{
 "All comparatives have been generalized: ",
 StyleBox["PermEqual",
  FontFamily->"Courier"],
 ", ",
 StyleBox["PermLess",
  FontFamily->"Courier"],
 ", ",
 StyleBox["PermGreater",
  FontFamily->"Courier"],
 ", ",
 StyleBox["PermLessEqual",
  FontFamily->"Courier"],
 ", ",
 StyleBox["PermGreaterEqual",
  FontFamily->"Courier"],
 ", ",
 StyleBox["PermOrderedQ",
  FontFamily->"Courier"],
 ", and we can also sort points and permutations as given by a base."
}], "MathCaption",ExpressionUUID->"640d1624-3eda-43bf-a3ad-1c8317851eb1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PermOrderedQ"}]], "Input",
 CellLabel->"In[52]:=",ExpressionUUID->"733c10cf-3878-4edf-9a01-13bbfc845c0d"],

Cell[BoxData[
 StyleBox["\<\"PermOrderedQ[h[perm1, perm2]] gives True if perm1 maps \
integers to smaller points than perm2. It gives False if perm1 maps integers \
to larger points than perm2. It gives Null if perm1 and perm2 maps integers \
to the same points. PermOrderedQ[h[perm1, perm2], B] gives True if perm1 maps \
the points of base B to smaller (according to B) images than perm2. It gives \
False if perm1 maps the points of B to larger (according to B) images than \
perm2. It gives Null if perm1 and perm2 map the points of B to the same \
images.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3568058412-2493619",ExpressionUUID->"a2a357f7-547e-4a68-be5f-\
c751f87c6a6e"]
}, Open  ]],

Cell["Images of points or lists of points:", "MathCaption",ExpressionUUID->"975aa5e3-3a4e-44f7-acee-7ecb24bc9b05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{"4", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"d5747306-d40b-4a62-94ff-733dff6fa7c2"],

Cell[BoxData["5"], "Output",
 CellLabel->"Out[53]=",ExpressionUUID->"4dee7540-1857-4e41-9d50-8bd6dbc3cab6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"Rules", "[", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"46eaf66d-ae26-4e6d-b1ba-5667fd5327e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[54]=",ExpressionUUID->"a650429c-ac88-4bd5-b271-1e9ec00ffb68"]
}, Open  ]],

Cell["\<\
There is a simple way to generate the identity corresponding to any notation, \
degree and sign:\
\>", "MathCaption",ExpressionUUID->"d1c85db8-a1f8-4517-b0f3-6c4cc87360d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ID", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[55]:=",ExpressionUUID->"b6f4eb1f-12ae-418f-8907-a89b9d10acc8"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Output",
 CellLabel->"Out[55]=",ExpressionUUID->"a7e27d7d-37e4-4041-bea9-5546cafa550a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ID", "[", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[56]:=",ExpressionUUID->"1afbd04b-8362-4756-bd37-13957be6830e"],

Cell[BoxData[
 RowBox[{"Cycles", "[", "]"}]], "Output",
 CellLabel->"Out[56]=",ExpressionUUID->"6c2d9162-eb74-4df7-833d-d38e4560a1dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ID", "[", 
  RowBox[{"-", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"4efea453-7e44-4226-b7ce-8d5380f29f58"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], 
  "]"}]], "Output",
 CellLabel->"Out[57]=",ExpressionUUID->"3eeb620d-9144-44e2-8a75-bd414d7b14b8"]
}, Open  ]],

Cell[TextData[{
 StyleBox["ID",
  FontFamily->"Courier"],
 " also represents the identity:"
}], "MathCaption",ExpressionUUID->"3ce9026e-ff2a-46ed-b470-3248bdc605a9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{"ID", ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"71ec8aee-a2d8-4fe5-a0a4-d649939d27c8"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}]], "Output",
 CellLabel->"Out[58]=",ExpressionUUID->"28401e9c-1005-4b63-8077-fd90dc30bab4"]
}, Open  ]],

Cell["\<\
We can permute any kind of list, even with repeated elements:\
\>", "MathCaption",ExpressionUUID->"4ed7aa29-3c0d-4ae3-ae69-1f53a9047c73"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermuteList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "b"}], "}"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"79b6fbbc-e08d-40a8-ac5e-ac1fe2a4b661"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "c", ",", "b", ",", "b", ",", "a"}], "}"}]], "Output",
 CellLabel->"Out[59]=",ExpressionUUID->"0c731639-18f3-4ffb-a184-9c6aaf43b1c7"]
}, Open  ]],

Cell[TextData[{
 "Or find a permutation linking two different lists. The result is given in \
",
 StyleBox["Images",
  FontFamily->"Courier"],
 " notation:"
}], "MathCaption",ExpressionUUID->"f8e61af3-0f10-4119-b513-0bd396fd8995"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermutationFromTo", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "c", ",", "b", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[60]:=",ExpressionUUID->"3526fc57-4d70-45cf-9df6-5d4e9c367c95"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}]], "Output",
 CellLabel->"Out[60]=",ExpressionUUID->"a82356c2-bc60-4cbc-88d9-32ddb4aaa36e"]
}, Open  ]],

Cell["Again, note that the order of permutation is very important:", \
"MathCaption",ExpressionUUID->"5638a5f0-dff2-4551-acab-08f919486cea"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"ffb3103d-0395-4512-beb9-8dd7c371257e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "//", 
   RowBox[{
    RowBox[{"OnPoints", "[", 
     RowBox[{"#", ",", "p1"}], "]"}], "&"}]}], "//", 
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"#", ",", "p2"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"cc632a85-d3e4-4e92-8cfb-8c622a518b2b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5"}], "}"}]], "Output",
 CellLabel->"Out[63]=",ExpressionUUID->"946400ad-0c7e-4815-985b-6329e1091695"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "//", 
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"#", ",", 
     RowBox[{"PermProduct", "[", 
      RowBox[{"p1", ",", "p2"}], "]"}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[64]:=",ExpressionUUID->"1fea20f4-1ee7-4025-8a83-2091cf9f8eea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5"}], "}"}]], "Output",
 CellLabel->"Out[64]=",ExpressionUUID->"f7c39d6a-0b00-40ab-9b54-77ebb88e2a17"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "//", 
  RowBox[{
   RowBox[{"OnPoints", "[", 
    RowBox[{"#", ",", "p1"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"a8b255c1-3500-43bb-a705-48b48f03c491"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[65]=",ExpressionUUID->"edd5c9eb-2ae0-4adb-89f5-6f064c46fc40"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermuteList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"InversePerm", "[", "p1", "]"}]}], "]"}]], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"5342bdec-7f44-43bf-b0b9-f1d9907e0dea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[66]=",ExpressionUUID->"8e577301-99e7-400d-adfd-6d56a67b0a18"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PermQ\t\t\t\t\t", "DisplayMath"],
 StyleBox["Validate a permutation", "Text"],
 StyleBox["\nPermDeg\t\t\t\t\t", "DisplayMath"],
 StyleBox["Give the degree of a permutation\n", "Text"],
 StyleBox["PermLength\t\t\t\t", "DisplayMath"],
 StyleBox["Give the length of a permutation\n", "Text"],
 StyleBox["RandomPerm\t\t\t\t", "DisplayMath"],
 StyleBox["Construct a random permutation of a given degree", "Text"],
 StyleBox["\nPermProduct\t\t\t\t", "DisplayMath"],
 StyleBox["Product of several permutations", "Text"],
 StyleBox["\nInversePerm\t\t\t\t", "DisplayMath"],
 StyleBox["Inverse of a permutation", "Text"],
 StyleBox["\nPermutePower\t\t\t", "DisplayMath"],
 StyleBox["Repeated product of a permutation", "Text"],
 StyleBox["\nPermSort\t\t\t\t", "DisplayMath"],
 StyleBox["Order permutations according to their images", "Text"],
 StyleBox["\nOnPoints\t\t\t\t", "DisplayMath"],
 StyleBox["Compute images of points under a permutation", "Text"],
 StyleBox["\nID\t\t\t\t\t\t", "DisplayMath"],
 StyleBox["Identity permutation\n", "Text"],
 StyleBox["PermuteList\t\t\t\t", "DisplayMath"],
 StyleBox["Apply permutation on a given list\n", "Text"],
 StyleBox["PermutationFromTo\t\t", "DisplayMath"],
 StyleBox["Calculate permutation changing one list into other", "Text"]
}], "DefinitionBox",ExpressionUUID->"f36c45a2-1031-427c-bc44-5757873d0b20"],

Cell[TextData[StyleBox["Basic operations with permutations.", "SmallText"]], \
"Text",ExpressionUUID->"dfdde587-2894-4d79-bad8-f6daaaf4d828"],

Cell[TextData[{
 StyleBox["SortB\t\t\t\t\t", "DisplayMath"],
 StyleBox["Sort points as given by a base", "Text"],
 StyleBox["\nMinB\t\t\t\t\t", "DisplayMath"],
 StyleBox["Least point of a list as given by a base\n", "Text"],
 StyleBox["PermEqual\t\t\t\t", "DisplayMath"],
 StyleBox["Compare permutations\n", "Text"],
 StyleBox["PermGreater\t\t\t\t", "DisplayMath"],
 StyleBox["Compare permutations", "Text"],
 StyleBox["\nPermLess\t\t\t\t", "DisplayMath"],
 StyleBox["Compare permutations\n", "Text"],
 StyleBox["PermGreaterqual\t\t\t", "DisplayMath"],
 StyleBox["Compare permutations\n", "Text"],
 StyleBox["PermLessEqual\t\t\t", "DisplayMath"],
 StyleBox["Compare permutations", "Text"],
 StyleBox["\nPermOrderedQ\t\t\t", "DisplayMath"],
 StyleBox["Check whether a list of permuations is sorted", "Text"],
 StyleBox["\nPermSort\t\t\t\t", "DisplayMath"],
 StyleBox["Sort permutations according to their images", "Text"]
}], "DefinitionBox",ExpressionUUID->"11ac50ce-d3fe-4ab8-b891-091ecd8af219"],

Cell["Sorting and comparing permutations.", "SmallText",ExpressionUUID->"da821241-890f-443d-a6df-be529a6d442b"]
}, Closed]],

Cell[CellGroupData[{

Cell["3. Groups of permutations and Generating Sets", "SubsectionIcon",
 CellTags->{
  "S5.18.1", "1.4"},ExpressionUUID->"d24cdbe1-b2d0-4a6b-902e-39106e095d65"],

Cell[CellGroupData[{

Cell["3.1. Groups by generators", "SubsubsectionIcon",ExpressionUUID->"4d517d70-8871-42c4-9845-48e7e344d879"],

Cell["\<\
Every finite group is isomorphic to some subgroup of a symmetric group of \
permutations (Cayley theorem). Hence, provided we can find a permutation \
representation, working with groups of permutations is generic.\
\>", "Text",ExpressionUUID->"b4eb114a-6b25-47b9-a820-366e2c8d84cf"],

Cell[TextData[{
 "Groups of permutations can be extremely large. The order (number of \
elements) of the group ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "n"], TraditionalForm]],ExpressionUUID->
  "1d950ae4-570d-477f-b89a-e1d58eb9092b"],
 " of permutations of n points is n!. In general we will be interested in \
(still very large) subgroups of a given ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "n"], TraditionalForm]],ExpressionUUID->
  "abcf7e52-4a74-4f3c-9afc-337ceb806d87"],
 ". For example, the number of permutations of the 48 moving squares of a \
Rubik's cube is"
}], "MathCaption",
 CellTags->{
  "S5.18.1", "1.5"},ExpressionUUID->"e6317de9-7228-463a-9f84-f20ee8cd7689"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"48", "!"}], "//", "N"}]], "Input",
 CellLabel->"In[67]:=",ExpressionUUID->"577e379d-4020-4db4-b534-718b33db0b41"],

Cell[BoxData["1.2413915592536073`*^61"], "Output",
 CellLabel->"Out[67]=",ExpressionUUID->"c12052c6-6db0-42f8-b411-be1444ded194"]
}, Open  ]],

Cell["\<\
On the other hand, the number of allowed permutations of a \"clean\" cube \
(forming a subgroup) turns out to be, as we will see below,\
\>", "MathCaption",ExpressionUUID->"95480643-3850-402e-91e2-449566b0c109"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"43252003274489856000", "//", "N"}]], "Input",
 CellLabel->"In[68]:=",ExpressionUUID->"b7acfec8-8467-4658-8719-53472edeb023"],

Cell[BoxData["4.325200327448986`*^19"], "Output",
 CellLabel->"Out[68]=",ExpressionUUID->"39d7b7f7-ecf6-46cf-b5ab-358cc55ed0c9"]
}, Open  ]],

Cell[TextData[{
 "However we can describe the whole subgroup with just six permutations, \
corresponding to each rotation of the six faces of the cube. The subgroup can \
be constructed by repeated multiplication of the six \"generators\". We shall \
describe groups using generating sets, expressions with head ",
 StyleBox["GenSet ",
  FontFamily->"Courier"],
 "where the elements are the generators. By convention, the identity \
permutation never belongs to a generating set. For example the group ",
 Cell[BoxData[
  SubscriptBox["S", "4"]],ExpressionUUID->
  "f1548bb1-5984-46cb-bbd7-f9ccae834eec"],
 "can be generated with just 2 permutations using Diminos's algorithm:"
}], "MathCaption",ExpressionUUID->"314c0be4-8ff6-4f9c-8d69-d27ce3eefb1d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimino", "[", 
  RowBox[{"GenSet", "[", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[69]:=",ExpressionUUID->"e64b011e-8287-47af-9c90-8c5303b65301"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[69]=",ExpressionUUID->"ec451499-a7f6-429d-9b8c-3ac6321fb04c"]
}, Open  ]],

Cell[TextData[{
 "And actually any ",
 Cell[BoxData[
  SubscriptBox["S", "n"]],ExpressionUUID->
  "ec0f5197-76dd-4dd4-ab18-0c39fd97167a"],
 " can be generated with just 2 permutations. For example ",
 Cell[BoxData[
  SubscriptBox["S", "6"]],ExpressionUUID->
  "fa8e0fc4-cb2a-460f-bee6-dfa3f4c6efd2"],
 ":"
}], "MathCaption",ExpressionUUID->"a176125e-2c10-4f55-a400-54a25033c32c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Dimino", "[", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}],
       "]"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[70]:=",ExpressionUUID->"4d604646-94d8-4b6d-9103-71aa19d69d00"],

Cell[BoxData["720"], "Output",
 CellLabel->"Out[70]=",ExpressionUUID->"08cbc7a9-b6fd-4733-9624-c57ec1c3bad2"]
}, Open  ]],

Cell["\<\
A group generated by a single permutation is called a cyclic group:\
\>", "MathCaption",ExpressionUUID->"6fb82c64-19ba-4988-ba19-ee5773cdf484"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"group", "=", 
  RowBox[{"Dimino", "[", 
   RowBox[{"GenSet", "[", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], 
    "]"}], "]"}]}]], "Input",
 CellLabel->"In[71]:=",ExpressionUUID->"b01f0851-568f-4d01-8f04-6e763a95a00e"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[71]=",ExpressionUUID->"817c5189-93be-4600-a9e2-c95eda373d20"]
}, Open  ]],

Cell["We can form left and right cosets:", "MathCaption",ExpressionUUID->"aa44097f-a629-4ba7-8075-018efcffa33c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"leftcoset", "=", 
  RowBox[{"PermProduct", "[", 
   RowBox[{
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], 
    ",", "group"}], "]"}]}]], "Input",
 CellLabel->"In[72]:=",ExpressionUUID->"920c4c7b-e3a8-4e72-9dc9-97ece510caea"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[72]=",ExpressionUUID->"652094d3-5d81-4f52-a5a5-ba8dc260de20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rightcoset", "=", 
  RowBox[{"PermProduct", "[", 
   RowBox[{"group", ",", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[73]:=",ExpressionUUID->"a2153d3e-19d3-44ac-93e9-3938cf146cb6"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "5", ",", "4", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[73]=",ExpressionUUID->"2fd2d626-afb8-481f-a52d-ed184cf3547e"]
}, Open  ]],

Cell["\<\
If the permutation already belongs to the group, the coset is actually the \
original group:\
\>", "MathCaption",ExpressionUUID->"4ee97267-7c34-4827-95c2-27a4b7314768"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermProduct", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], ",",
    "group"}], "]"}]], "Input",
 CellLabel->"In[74]:=",ExpressionUUID->"228b6b73-588f-4ba0-a764-82ee9fd00971"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[74]=",ExpressionUUID->"fb41452d-d7ab-4efb-9873-c105d2c29851"]
}, Open  ]],

Cell[TextData[{
 StyleBox["GenSet\t\t\t\t", "DisplayMath"],
 StyleBox["Head for a generating set", "Text"],
 StyleBox["\nGroup\t\t\t\t", "DisplayMath"],
 StyleBox["Head for a group of permutations\n", "Text"],
 StyleBox["Coset\t\t\t\t", "DisplayMath"],
 StyleBox["Head for a coset", "Text"],
 StyleBox["\nDimino\t\t\t\t", "DisplayMath"],
 StyleBox["Algorithm to construct a group of permutations from one of its \
generating sets", "Text"]
}], "DefinitionBox",ExpressionUUID->"433f5519-49b4-4f13-93be-4ac8f9d97664"],

Cell[TextData[StyleBox["Generating Sets.", "SmallText"]], "Text",ExpressionUUID->"362fd3f8-28c9-4166-9dea-8f10ee4b0839"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. Cosets and double cosets", "SubsubsectionIcon",ExpressionUUID->"5d07217d-35fc-4fe1-acbf-b5daf548fa16"],

Cell["\<\
All cosets of a given subgroup of permutations have the same order, and \
partition the full group. Hence the order of a subgroup divides the order of \
the full group (Lagrange theorem).\
\>", "Text",ExpressionUUID->"67d257f8-0b31-4f66-aa0d-aaa2ac519d93"],

Cell["Suppose we start with the full group S5 of permutations:", "MathCaption",ExpressionUUID->"c6af736b-e906-4f6e-b7eb-6b8827fb4948"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"S5", "=", 
   RowBox[{"Sort", "@", 
    RowBox[{"Dimino", "[", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], 
        "]"}]}], "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[75]:=",ExpressionUUID->"3a73d3b1-cef8-48ba-9d78-88fbdda23014"],

Cell[BoxData["120"], "Output",
 CellLabel->"Out[75]=",ExpressionUUID->"1f35b0ef-edac-4db8-9ca5-5aa9485005eb"]
}, Open  ]],

Cell["One of its subgroups is S3:", "MathCaption",ExpressionUUID->"dd74e4b1-520f-43f8-8f61-c44a6b5754f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"S3", "=", 
   RowBox[{"Sort", "@", 
    RowBox[{"Dimino", "[", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5"}], "}"}], 
        "]"}]}], "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[76]:=",ExpressionUUID->"cdc61a27-8ded-456c-8551-cb45d193f540"],

Cell[BoxData["6"], "Output",
 CellLabel->"Out[76]=",ExpressionUUID->"a434e140-496f-4ed3-9ecf-2c540329d1a2"]
}, Open  ]],

Cell["\<\
There are therefore 20 left-cosets of S4 in S5, that we call L1...L20:\
\>", "MathCaption",ExpressionUUID->"2a8c77f3-40cb-48f4-8b16-a50fed43afb1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColumnForm", "[", 
  RowBox[{"S3cosets", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"Sort", "/@", 
     RowBox[{"Outer", "[", 
      RowBox[{"PermProduct", ",", 
       RowBox[{"List", "@@", "S5"}], ",", 
       RowBox[{"List", "@@", "S3"}]}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[77]:=",ExpressionUUID->"f48e4efd-7729-488f-8498-1382eef8a2d5"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "1", ",", "5", ",", "4"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "4", ",", "1", ",", "5"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "4", ",", "5", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "5", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "5", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "5", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "5", ",", "1", ",", "4"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "5", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "5", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "5", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "5", ",", "4", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "2", ",", "1", ",", "5"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "3", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "1", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "3", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "1", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "2", ",", "5", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "5", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "5", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5", ",", "2", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "2", ",", "1", ",", "4"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "2", ",", "4", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "1", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "2", ",", "1", ",", "5"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "2", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "3", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "1", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "1", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "5", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "5", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "5", ",", "2", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "2", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "3", ",", "2", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "2", ",", "1", ",", "4"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "2", ",", "4", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "4", ",", "2", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "2", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}], 
        "]"}]}], "}"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{{
     xAct`xPerm`Images[{1, 2, 3, 4, 5}], 
     xAct`xPerm`Images[{1, 3, 2, 4, 5}], 
     xAct`xPerm`Images[{2, 1, 3, 4, 5}], 
     xAct`xPerm`Images[{2, 3, 1, 4, 5}], 
     xAct`xPerm`Images[{3, 1, 2, 4, 5}], 
     xAct`xPerm`Images[{3, 2, 1, 4, 5}]}, {
     xAct`xPerm`Images[{1, 2, 3, 5, 4}], 
     xAct`xPerm`Images[{1, 3, 2, 5, 4}], 
     xAct`xPerm`Images[{2, 1, 3, 5, 4}], 
     xAct`xPerm`Images[{2, 3, 1, 5, 4}], 
     xAct`xPerm`Images[{3, 1, 2, 5, 4}], 
     xAct`xPerm`Images[{3, 2, 1, 5, 4}]}, {
     xAct`xPerm`Images[{1, 2, 4, 3, 5}], 
     xAct`xPerm`Images[{1, 3, 4, 2, 5}], 
     xAct`xPerm`Images[{2, 1, 4, 3, 5}], 
     xAct`xPerm`Images[{2, 3, 4, 1, 5}], 
     xAct`xPerm`Images[{3, 1, 4, 2, 5}], 
     xAct`xPerm`Images[{3, 2, 4, 1, 5}]}, {
     xAct`xPerm`Images[{1, 2, 4, 5, 3}], 
     xAct`xPerm`Images[{1, 3, 4, 5, 2}], 
     xAct`xPerm`Images[{2, 1, 4, 5, 3}], 
     xAct`xPerm`Images[{2, 3, 4, 5, 1}], 
     xAct`xPerm`Images[{3, 1, 4, 5, 2}], 
     xAct`xPerm`Images[{3, 2, 4, 5, 1}]}, {
     xAct`xPerm`Images[{1, 2, 5, 3, 4}], 
     xAct`xPerm`Images[{1, 3, 5, 2, 4}], 
     xAct`xPerm`Images[{2, 1, 5, 3, 4}], 
     xAct`xPerm`Images[{2, 3, 5, 1, 4}], 
     xAct`xPerm`Images[{3, 1, 5, 2, 4}], 
     xAct`xPerm`Images[{3, 2, 5, 1, 4}]}, {
     xAct`xPerm`Images[{1, 2, 5, 4, 3}], 
     xAct`xPerm`Images[{1, 3, 5, 4, 2}], 
     xAct`xPerm`Images[{2, 1, 5, 4, 3}], 
     xAct`xPerm`Images[{2, 3, 5, 4, 1}], 
     xAct`xPerm`Images[{3, 1, 5, 4, 2}], 
     xAct`xPerm`Images[{3, 2, 5, 4, 1}]}, {
     xAct`xPerm`Images[{1, 4, 2, 3, 5}], 
     xAct`xPerm`Images[{1, 4, 3, 2, 5}], 
     xAct`xPerm`Images[{2, 4, 1, 3, 5}], 
     xAct`xPerm`Images[{2, 4, 3, 1, 5}], 
     xAct`xPerm`Images[{3, 4, 1, 2, 5}], 
     xAct`xPerm`Images[{3, 4, 2, 1, 5}]}, {
     xAct`xPerm`Images[{1, 4, 2, 5, 3}], 
     xAct`xPerm`Images[{1, 4, 3, 5, 2}], 
     xAct`xPerm`Images[{2, 4, 1, 5, 3}], 
     xAct`xPerm`Images[{2, 4, 3, 5, 1}], 
     xAct`xPerm`Images[{3, 4, 1, 5, 2}], 
     xAct`xPerm`Images[{3, 4, 2, 5, 1}]}, {
     xAct`xPerm`Images[{1, 4, 5, 2, 3}], 
     xAct`xPerm`Images[{1, 4, 5, 3, 2}], 
     xAct`xPerm`Images[{2, 4, 5, 1, 3}], 
     xAct`xPerm`Images[{2, 4, 5, 3, 1}], 
     xAct`xPerm`Images[{3, 4, 5, 1, 2}], 
     xAct`xPerm`Images[{3, 4, 5, 2, 1}]}, {
     xAct`xPerm`Images[{1, 5, 2, 3, 4}], 
     xAct`xPerm`Images[{1, 5, 3, 2, 4}], 
     xAct`xPerm`Images[{2, 5, 1, 3, 4}], 
     xAct`xPerm`Images[{2, 5, 3, 1, 4}], 
     xAct`xPerm`Images[{3, 5, 1, 2, 4}], 
     xAct`xPerm`Images[{3, 5, 2, 1, 4}]}, {
     xAct`xPerm`Images[{1, 5, 2, 4, 3}], 
     xAct`xPerm`Images[{1, 5, 3, 4, 2}], 
     xAct`xPerm`Images[{2, 5, 1, 4, 3}], 
     xAct`xPerm`Images[{2, 5, 3, 4, 1}], 
     xAct`xPerm`Images[{3, 5, 1, 4, 2}], 
     xAct`xPerm`Images[{3, 5, 2, 4, 1}]}, {
     xAct`xPerm`Images[{1, 5, 4, 2, 3}], 
     xAct`xPerm`Images[{1, 5, 4, 3, 2}], 
     xAct`xPerm`Images[{2, 5, 4, 1, 3}], 
     xAct`xPerm`Images[{2, 5, 4, 3, 1}], 
     xAct`xPerm`Images[{3, 5, 4, 1, 2}], 
     xAct`xPerm`Images[{3, 5, 4, 2, 1}]}, {
     xAct`xPerm`Images[{4, 1, 2, 3, 5}], 
     xAct`xPerm`Images[{4, 1, 3, 2, 5}], 
     xAct`xPerm`Images[{4, 2, 1, 3, 5}], 
     xAct`xPerm`Images[{4, 2, 3, 1, 5}], 
     xAct`xPerm`Images[{4, 3, 1, 2, 5}], 
     xAct`xPerm`Images[{4, 3, 2, 1, 5}]}, {
     xAct`xPerm`Images[{4, 1, 2, 5, 3}], 
     xAct`xPerm`Images[{4, 1, 3, 5, 2}], 
     xAct`xPerm`Images[{4, 2, 1, 5, 3}], 
     xAct`xPerm`Images[{4, 2, 3, 5, 1}], 
     xAct`xPerm`Images[{4, 3, 1, 5, 2}], 
     xAct`xPerm`Images[{4, 3, 2, 5, 1}]}, {
     xAct`xPerm`Images[{4, 1, 5, 2, 3}], 
     xAct`xPerm`Images[{4, 1, 5, 3, 2}], 
     xAct`xPerm`Images[{4, 2, 5, 1, 3}], 
     xAct`xPerm`Images[{4, 2, 5, 3, 1}], 
     xAct`xPerm`Images[{4, 3, 5, 1, 2}], 
     xAct`xPerm`Images[{4, 3, 5, 2, 1}]}, {
     xAct`xPerm`Images[{4, 5, 1, 2, 3}], 
     xAct`xPerm`Images[{4, 5, 1, 3, 2}], 
     xAct`xPerm`Images[{4, 5, 2, 1, 3}], 
     xAct`xPerm`Images[{4, 5, 2, 3, 1}], 
     xAct`xPerm`Images[{4, 5, 3, 1, 2}], 
     xAct`xPerm`Images[{4, 5, 3, 2, 1}]}, {
     xAct`xPerm`Images[{5, 1, 2, 3, 4}], 
     xAct`xPerm`Images[{5, 1, 3, 2, 4}], 
     xAct`xPerm`Images[{5, 2, 1, 3, 4}], 
     xAct`xPerm`Images[{5, 2, 3, 1, 4}], 
     xAct`xPerm`Images[{5, 3, 1, 2, 4}], 
     xAct`xPerm`Images[{5, 3, 2, 1, 4}]}, {
     xAct`xPerm`Images[{5, 1, 2, 4, 3}], 
     xAct`xPerm`Images[{5, 1, 3, 4, 2}], 
     xAct`xPerm`Images[{5, 2, 1, 4, 3}], 
     xAct`xPerm`Images[{5, 2, 3, 4, 1}], 
     xAct`xPerm`Images[{5, 3, 1, 4, 2}], 
     xAct`xPerm`Images[{5, 3, 2, 4, 1}]}, {
     xAct`xPerm`Images[{5, 1, 4, 2, 3}], 
     xAct`xPerm`Images[{5, 1, 4, 3, 2}], 
     xAct`xPerm`Images[{5, 2, 4, 1, 3}], 
     xAct`xPerm`Images[{5, 2, 4, 3, 1}], 
     xAct`xPerm`Images[{5, 3, 4, 1, 2}], 
     xAct`xPerm`Images[{5, 3, 4, 2, 1}]}, {
     xAct`xPerm`Images[{5, 4, 1, 2, 3}], 
     xAct`xPerm`Images[{5, 4, 1, 3, 2}], 
     xAct`xPerm`Images[{5, 4, 2, 1, 3}], 
     xAct`xPerm`Images[{5, 4, 2, 3, 1}], 
     xAct`xPerm`Images[{5, 4, 3, 1, 2}], 
     xAct`xPerm`Images[{5, 4, 3, 2, 1}]}}],
  Editable->False]], "Output",
 CellLabel->"Out[77]=",ExpressionUUID->"83f742b4-23aa-4158-8c09-248eaca5c9a9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "L1", ",", "L2", ",", "L3", ",", "L4", ",", "L5", ",", "L6", ",", "L7", 
     ",", "L8", ",", "L9", ",", "L10", ",", "L11", ",", "L12", ",", "L13", 
     ",", "L14", ",", "L15", ",", "L16", ",", "L17", ",", "L18", ",", "L19", 
     ",", "L20"}], "}"}], "=", "S3cosets"}], ";"}]], "Input",
 CellLabel->"In[78]:=",ExpressionUUID->"fb7de7bc-c3be-4604-a0a3-551ff59238cf"],

Cell["And they all form the full S5 group:", "MathCaption",ExpressionUUID->"85f94f04-231c-4bb0-b2db-890088a93213"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sort", "[", 
   RowBox[{"Group", "@@", 
    RowBox[{"Union", "@@", "S3cosets"}]}], "]"}], "===", "S5"}]], "Input",
 CellLabel->"In[79]:=",ExpressionUUID->"83199aa5-6317-4172-94df-42af888f26c7"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[79]=",ExpressionUUID->"26be769d-fc92-43bd-b921-a9a5630dc0b2"]
}, Open  ]],

Cell["\<\
The concept of double coset will be important for us later. A double coset of \
two subgroups H and K in the full group G is the set of permutations of the \
form h.g.k for all h in H, all k in K and a particular g in G. The double \
cosets also partition the full group G, but unfortunately they do not all \
have the same size, and therefore there is not an equivalent of the Lagrange \
theorem for double cosets. The computation of the number of double cosets in \
a group G is a nontrivial task.\
\>", "Text",ExpressionUUID->"e2ec0946-5961-4e18-ba0e-c74fc979da4b"],

Cell["Construct another subgroup of S5:", "MathCaption",ExpressionUUID->"203335c8-6f9b-425c-9ced-6fb60477af82"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"H", "=", 
   RowBox[{"Dimino", "[", 
    RowBox[{"GenSet", "[", 
     RowBox[{
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
      ",", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
      ",", 
      RowBox[{"Images", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}]}],
      "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[80]:=",ExpressionUUID->"1fc34ddc-d2db-4a24-8cd3-9effc3db84d0"],

Cell[BoxData["8"], "Output",
 CellLabel->"Out[80]=",ExpressionUUID->"0c967b8e-4b45-4ec1-b1bd-a6b1acb508fc"]
}, Open  ]],

Cell["\<\
That means that there are 15 right-cosets of H in S5, that we call R1...R15:\
\>", "MathCaption",ExpressionUUID->"970f3803-b535-4c55-912d-79d8c14513af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColumnForm", "[", 
  RowBox[{"Hcosets", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"Sort", "/@", 
     RowBox[{"Transpose", "@", 
      RowBox[{"Outer", "[", 
       RowBox[{"PermProduct", ",", 
        RowBox[{"List", "@@", "H"}], ",", 
        RowBox[{"List", "@@", "S5"}]}], "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[81]:=",ExpressionUUID->"dfa2c95e-3cab-48c1-91be-e0a73c05a389"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "2", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "1", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "2", ",", "1", ",", "5"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "5", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "2", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "1", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "2", ",", "1", ",", "4"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "4", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "5", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "2", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "2", ",", "1", ",", "3"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "3", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "4", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "1", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "1", ",", "5"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "5", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "3", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "2", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "5", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "3", ",", "1", ",", "4"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "5", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "4", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "5", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "3", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "1", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "3", ",", "1", ",", "2"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "4", ",", "1", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "5", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "4", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "2", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "5", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "1", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "4", ",", "1", ",", "3"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "3", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "3", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1", ",", "5", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "1", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "5", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "1", ",", "5", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "5", ",", "1", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "3", ",", "2", ",", "4"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "1", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "5", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "1", ",", "5", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "5", ",", "1", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "4", ",", "2", ",", "3"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5", ",", "4", ",", "3", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "1", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "1", ",", "5", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "3", ",", "4", ",", "2"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1", ",", "4", ",", "3", ",", "2"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "5", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "4", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "2", ",", "5", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "3", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "3", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2", ",", "5", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "2", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "3", ",", "4", ",", "2", ",", "1"}], "}"}], 
        "]"}]}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5", ",", "4", ",", "3", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "2", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5", ",", "2", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", "3", ",", "5", ",", "2", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}], 
       ",", 
       RowBox[{"Images", "[", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2", ",", "4", ",", "3", ",", "1"}], "}"}], 
        "]"}]}], "}"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{{
     xAct`xPerm`Images[{1, 2, 3, 4, 5}], 
     xAct`xPerm`Images[{1, 2, 4, 3, 5}], 
     xAct`xPerm`Images[{2, 1, 3, 4, 5}], 
     xAct`xPerm`Images[{2, 1, 4, 3, 5}], 
     xAct`xPerm`Images[{3, 4, 1, 2, 5}], 
     xAct`xPerm`Images[{3, 4, 2, 1, 5}], 
     xAct`xPerm`Images[{4, 3, 1, 2, 5}], 
     xAct`xPerm`Images[{4, 3, 2, 1, 5}]}, {
     xAct`xPerm`Images[{1, 2, 3, 5, 4}], 
     xAct`xPerm`Images[{1, 2, 5, 3, 4}], 
     xAct`xPerm`Images[{2, 1, 3, 5, 4}], 
     xAct`xPerm`Images[{2, 1, 5, 3, 4}], 
     xAct`xPerm`Images[{3, 5, 1, 2, 4}], 
     xAct`xPerm`Images[{3, 5, 2, 1, 4}], 
     xAct`xPerm`Images[{5, 3, 1, 2, 4}], 
     xAct`xPerm`Images[{5, 3, 2, 1, 4}]}, {
     xAct`xPerm`Images[{1, 2, 4, 5, 3}], 
     xAct`xPerm`Images[{1, 2, 5, 4, 3}], 
     xAct`xPerm`Images[{2, 1, 4, 5, 3}], 
     xAct`xPerm`Images[{2, 1, 5, 4, 3}], 
     xAct`xPerm`Images[{4, 5, 1, 2, 3}], 
     xAct`xPerm`Images[{4, 5, 2, 1, 3}], 
     xAct`xPerm`Images[{5, 4, 1, 2, 3}], 
     xAct`xPerm`Images[{5, 4, 2, 1, 3}]}, {
     xAct`xPerm`Images[{1, 3, 2, 4, 5}], 
     xAct`xPerm`Images[{1, 3, 4, 2, 5}], 
     xAct`xPerm`Images[{2, 4, 1, 3, 5}], 
     xAct`xPerm`Images[{2, 4, 3, 1, 5}], 
     xAct`xPerm`Images[{3, 1, 2, 4, 5}], 
     xAct`xPerm`Images[{3, 1, 4, 2, 5}], 
     xAct`xPerm`Images[{4, 2, 1, 3, 5}], 
     xAct`xPerm`Images[{4, 2, 3, 1, 5}]}, {
     xAct`xPerm`Images[{1, 3, 2, 5, 4}], 
     xAct`xPerm`Images[{1, 3, 5, 2, 4}], 
     xAct`xPerm`Images[{2, 5, 1, 3, 4}], 
     xAct`xPerm`Images[{2, 5, 3, 1, 4}], 
     xAct`xPerm`Images[{3, 1, 2, 5, 4}], 
     xAct`xPerm`Images[{3, 1, 5, 2, 4}], 
     xAct`xPerm`Images[{5, 2, 1, 3, 4}], 
     xAct`xPerm`Images[{5, 2, 3, 1, 4}]}, {
     xAct`xPerm`Images[{1, 3, 4, 5, 2}], 
     xAct`xPerm`Images[{1, 3, 5, 4, 2}], 
     xAct`xPerm`Images[{3, 1, 4, 5, 2}], 
     xAct`xPerm`Images[{3, 1, 5, 4, 2}], 
     xAct`xPerm`Images[{4, 5, 1, 3, 2}], 
     xAct`xPerm`Images[{4, 5, 3, 1, 2}], 
     xAct`xPerm`Images[{5, 4, 1, 3, 2}], 
     xAct`xPerm`Images[{5, 4, 3, 1, 2}]}, {
     xAct`xPerm`Images[{1, 4, 2, 3, 5}], 
     xAct`xPerm`Images[{1, 4, 3, 2, 5}], 
     xAct`xPerm`Images[{2, 3, 1, 4, 5}], 
     xAct`xPerm`Images[{2, 3, 4, 1, 5}], 
     xAct`xPerm`Images[{3, 2, 1, 4, 5}], 
     xAct`xPerm`Images[{3, 2, 4, 1, 5}], 
     xAct`xPerm`Images[{4, 1, 2, 3, 5}], 
     xAct`xPerm`Images[{4, 1, 3, 2, 5}]}, {
     xAct`xPerm`Images[{1, 4, 2, 5, 3}], 
     xAct`xPerm`Images[{1, 4, 5, 2, 3}], 
     xAct`xPerm`Images[{2, 5, 1, 4, 3}], 
     xAct`xPerm`Images[{2, 5, 4, 1, 3}], 
     xAct`xPerm`Images[{4, 1, 2, 5, 3}], 
     xAct`xPerm`Images[{4, 1, 5, 2, 3}], 
     xAct`xPerm`Images[{5, 2, 1, 4, 3}], 
     xAct`xPerm`Images[{5, 2, 4, 1, 3}]}, {
     xAct`xPerm`Images[{1, 4, 3, 5, 2}], 
     xAct`xPerm`Images[{1, 4, 5, 3, 2}], 
     xAct`xPerm`Images[{3, 5, 1, 4, 2}], 
     xAct`xPerm`Images[{3, 5, 4, 1, 2}], 
     xAct`xPerm`Images[{4, 1, 3, 5, 2}], 
     xAct`xPerm`Images[{4, 1, 5, 3, 2}], 
     xAct`xPerm`Images[{5, 3, 1, 4, 2}], 
     xAct`xPerm`Images[{5, 3, 4, 1, 2}]}, {
     xAct`xPerm`Images[{1, 5, 2, 3, 4}], 
     xAct`xPerm`Images[{1, 5, 3, 2, 4}], 
     xAct`xPerm`Images[{2, 3, 1, 5, 4}], 
     xAct`xPerm`Images[{2, 3, 5, 1, 4}], 
     xAct`xPerm`Images[{3, 2, 1, 5, 4}], 
     xAct`xPerm`Images[{3, 2, 5, 1, 4}], 
     xAct`xPerm`Images[{5, 1, 2, 3, 4}], 
     xAct`xPerm`Images[{5, 1, 3, 2, 4}]}, {
     xAct`xPerm`Images[{1, 5, 2, 4, 3}], 
     xAct`xPerm`Images[{1, 5, 4, 2, 3}], 
     xAct`xPerm`Images[{2, 4, 1, 5, 3}], 
     xAct`xPerm`Images[{2, 4, 5, 1, 3}], 
     xAct`xPerm`Images[{4, 2, 1, 5, 3}], 
     xAct`xPerm`Images[{4, 2, 5, 1, 3}], 
     xAct`xPerm`Images[{5, 1, 2, 4, 3}], 
     xAct`xPerm`Images[{5, 1, 4, 2, 3}]}, {
     xAct`xPerm`Images[{1, 5, 3, 4, 2}], 
     xAct`xPerm`Images[{1, 5, 4, 3, 2}], 
     xAct`xPerm`Images[{3, 4, 1, 5, 2}], 
     xAct`xPerm`Images[{3, 4, 5, 1, 2}], 
     xAct`xPerm`Images[{4, 3, 1, 5, 2}], 
     xAct`xPerm`Images[{4, 3, 5, 1, 2}], 
     xAct`xPerm`Images[{5, 1, 3, 4, 2}], 
     xAct`xPerm`Images[{5, 1, 4, 3, 2}]}, {
     xAct`xPerm`Images[{2, 3, 4, 5, 1}], 
     xAct`xPerm`Images[{2, 3, 5, 4, 1}], 
     xAct`xPerm`Images[{3, 2, 4, 5, 1}], 
     xAct`xPerm`Images[{3, 2, 5, 4, 1}], 
     xAct`xPerm`Images[{4, 5, 2, 3, 1}], 
     xAct`xPerm`Images[{4, 5, 3, 2, 1}], 
     xAct`xPerm`Images[{5, 4, 2, 3, 1}], 
     xAct`xPerm`Images[{5, 4, 3, 2, 1}]}, {
     xAct`xPerm`Images[{2, 4, 3, 5, 1}], 
     xAct`xPerm`Images[{2, 4, 5, 3, 1}], 
     xAct`xPerm`Images[{3, 5, 2, 4, 1}], 
     xAct`xPerm`Images[{3, 5, 4, 2, 1}], 
     xAct`xPerm`Images[{4, 2, 3, 5, 1}], 
     xAct`xPerm`Images[{4, 2, 5, 3, 1}], 
     xAct`xPerm`Images[{5, 3, 2, 4, 1}], 
     xAct`xPerm`Images[{5, 3, 4, 2, 1}]}, {
     xAct`xPerm`Images[{2, 5, 3, 4, 1}], 
     xAct`xPerm`Images[{2, 5, 4, 3, 1}], 
     xAct`xPerm`Images[{3, 4, 2, 5, 1}], 
     xAct`xPerm`Images[{3, 4, 5, 2, 1}], 
     xAct`xPerm`Images[{4, 3, 2, 5, 1}], 
     xAct`xPerm`Images[{4, 3, 5, 2, 1}], 
     xAct`xPerm`Images[{5, 2, 3, 4, 1}], 
     xAct`xPerm`Images[{5, 2, 4, 3, 1}]}}],
  Editable->False]], "Output",
 CellLabel->"Out[81]=",ExpressionUUID->"af14a6b6-9957-4295-af43-7f639c98a5da"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "R1", ",", "R2", ",", "R3", ",", "R4", ",", "R5", ",", "R6", ",", "R7", 
     ",", "R8", ",", "R9", ",", "R10", ",", "R11", ",", "R12", ",", "R13", 
     ",", "R14", ",", "R15"}], "}"}], "=", "Hcosets"}], ";"}]], "Input",
 CellLabel->"In[82]:=",ExpressionUUID->"c8b38ebc-1bbd-49ae-a844-4ccf70383254"],

Cell["\<\
Now we want to find the number of double cosets of H and S3 in S5. The key \
idea is that a permutation in H acting on a left coset Li gives another \
(perhaps the same) left coset Lj. Therefore permutations in H now act as \
permutations on a set in which the points are the left cosets L1...L20. Each \
orbit in this set corresponds to a double coset. Note that double cosets are \
disjoint unions of single-cosets of each of the two subgroups.\
\>", "Text",ExpressionUUID->"4ecb443e-3858-4edf-8423-213b40f2c32a"],

Cell["\<\
We first have the product group, with 24 elements (it is actually S4):\
\>", "MathCaption",ExpressionUUID->"84b8aeb2-469d-4b3c-b54e-cb20c6a23f0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"doublecoset1", "=", 
   RowBox[{"List", "@@", 
    RowBox[{"Union", "@", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Outer", "[", 
       RowBox[{"PermProduct", ",", "H", ",", "S3"}], "]"}], "]"}]}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[83]:=",ExpressionUUID->"0b50bf73-04d8-49d0-9d27-226be8cec1cb"],

Cell[BoxData["24"], "Output",
 CellLabel->"Out[83]=",ExpressionUUID->"0b04a70e-696d-4f2f-8c50-3dd0a92a095d"]
}, Open  ]],

Cell["This double coset contains the following single cosets:", "MathCaption",ExpressionUUID->"20ca14d5-550b-44a9-895d-f57a0db877ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"doublecoset1", "===", 
  RowBox[{"Union", "[", 
   RowBox[{"L1", ",", "L3", ",", "L7", ",", "L13"}], "]"}]}]], "Input",
 CellLabel->"In[84]:=",ExpressionUUID->"e471da5d-fc4d-481a-95d1-b48ffe3d8f5d"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[84]=",ExpressionUUID->"c614a761-b06c-48ba-a84a-1bfb81dcd661"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"doublecoset1", "===", 
  RowBox[{"Union", "[", 
   RowBox[{"R1", ",", "R4", ",", "R7"}], "]"}]}]], "Input",
 CellLabel->"In[85]:=",ExpressionUUID->"a770b6fa-6113-4fa1-8a15-4682ed813a1c"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[85]=",ExpressionUUID->"8ca93177-fb5e-4907-a352-893fbcb171c1"]
}, Open  ]],

Cell["\<\
Now we look for the double coset containing L2. It is again S4 with points 4 \
and 5 exchanged:\
\>", "MathCaption",ExpressionUUID->"5f230558-7355-44ca-9d3a-fcdc4e65acb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"Sort", ",", 
    RowBox[{"Outer", "[", 
     RowBox[{"PermProduct", ",", 
      RowBox[{"List", "@@", "H"}], ",", 
      RowBox[{"{", 
       RowBox[{"L2", ",", "L5", ",", "L10", ",", "L17"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "===", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"L2", "L5", "L10", "L17"},
      {"L2", "L5", "L17", "L10"},
      {"L5", "L2", "L10", "L17"},
      {"L5", "L2", "L17", "L10"},
      {"L10", "L17", "L2", "L5"},
      {"L17", "L10", "L2", "L5"},
      {"L10", "L17", "L5", "L2"},
      {"L17", "L10", "L5", "L2"}
     }], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Input",
 CellLabel->"In[86]:=",ExpressionUUID->"5ca7ae62-fc49-4c39-afac-3016b7f48a41"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[86]=",ExpressionUUID->"da40d42d-9b4f-4a6c-a701-57e3c4e739b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"doublecoset2", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"L2", ",", "L5", ",", "L10", ",", "L17"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[87]:=",ExpressionUUID->"42cea9a5-1f25-4053-a79e-4a0aab1b4635"],

Cell[BoxData["24"], "Output",
 CellLabel->"Out[87]=",ExpressionUUID->"dddcddb1-ee10-422d-9e11-03ae49082fff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"doublecoset2", "===", 
  RowBox[{"Union", "[", 
   RowBox[{"R2", ",", "R5", ",", "R10"}], "]"}]}]], "Input",
 CellLabel->"In[88]:=",ExpressionUUID->"6eb6f4e1-64a2-4e06-b1e3-de84b92ea5c0"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[88]=",ExpressionUUID->"0fda5007-6075-4784-8e32-4fcdd8510b8b"]
}, Open  ]],

Cell["Now we look for the double coset containing L4:", "MathCaption",ExpressionUUID->"ab119ba6-415f-45e1-9d3a-9bd3cd6e4965"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"Sort", ",", 
    RowBox[{"Outer", "[", 
     RowBox[{"PermProduct", ",", 
      RowBox[{"List", "@@", "H"}], ",", 
      RowBox[{"{", 
       RowBox[{"L4", ",", "L6", ",", "L16", ",", "L20"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "===", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"L4", "L6", "L16", "L20"},
      {"L4", "L6", "L20", "L16"},
      {"L6", "L4", "L16", "L20"},
      {"L6", "L4", "L20", "L16"},
      {"L16", "L20", "L4", "L6"},
      {"L20", "L16", "L4", "L6"},
      {"L16", "L20", "L6", "L4"},
      {"L20", "L16", "L6", "L4"}
     }], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Input",
 CellLabel->"In[89]:=",ExpressionUUID->"9349b193-91fc-4e00-bcde-fe87147661f1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[89]=",ExpressionUUID->"d4fd9187-7fb5-493e-8c14-0ad65ddb3301"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"doublecoset3", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"L4", ",", "L6", ",", "L16", ",", "L20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[90]:=",ExpressionUUID->"03a63364-4616-4c5c-b469-bf6ba33db288"],

Cell[BoxData["24"], "Output",
 CellLabel->"Out[90]=",ExpressionUUID->"705a70ef-327b-4036-93d8-8478a4b330e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"doublecoset3", "===", 
  RowBox[{"Union", "[", 
   RowBox[{"R3", ",", "R6", ",", "R13"}], "]"}]}]], "Input",
 CellLabel->"In[91]:=",ExpressionUUID->"fc622a9d-bf51-41cb-a725-7fbdeb9ff8ea"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[91]=",ExpressionUUID->"3131bab1-2349-4fdf-bb13-19c219c65073"]
}, Open  ]],

Cell["Now we look for the double coset containing L8:", "MathCaption",ExpressionUUID->"66bd5f6b-3000-442a-98ee-94b69a71e36c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"Sort", ",", 
    RowBox[{"Outer", "[", 
     RowBox[{"PermProduct", ",", 
      RowBox[{"List", "@@", "H"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "L8", ",", "L9", ",", "L11", ",", "L12", ",", "L14", ",", "L15", ",", 
        "L18", ",", "L19"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "===", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"L8", "L9", "L11", "L12", "L14", "L15", "L18", "L19"},
      {"L14", "L15", "L18", "L19", "L8", "L9", "L11", "L12"},
      {"L9", "L8", "L12", "L11", "L15", "L14", "L19", "L18"},
      {"L15", "L14", "L19", "L18", "L9", "L8", "L12", "L11"},
      {"L11", "L18", "L8", "L14", "L12", "L19", "L9", "L15"},
      {"L18", "L11", "L14", "L8", "L19", "L12", "L15", "L9"},
      {"L12", "L19", "L9", "L15", "L11", "L18", "L8", "L14"},
      {"L19", "L12", "L15", "L9", "L18", "L11", "L14", "L8"}
     }], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Input",
 CellLabel->"In[92]:=",ExpressionUUID->"1c0ceff0-84eb-42c5-b5d0-5ff8a544a7b8"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[92]=",ExpressionUUID->"413b9cdc-c145-4daa-8570-4e5c3e3e3938"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"doublecoset4", "=", 
   RowBox[{"Union", "[", 
    RowBox[{
    "L8", ",", "L9", ",", "L11", ",", "L12", ",", "L14", ",", "L15", ",", 
     "L18", ",", "L19"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[93]:=",ExpressionUUID->"ba2fc2c1-4807-412a-b981-ddd2c5b14a51"],

Cell[BoxData["48"], "Output",
 CellLabel->"Out[93]=",ExpressionUUID->"429c45f8-9fa0-4835-a7d4-8d12a97a6a63"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"doublecoset4", "===", 
  RowBox[{"Union", "[", 
   RowBox[{"R8", ",", "R9", ",", "R11", ",", "R12", ",", "R14", ",", "R15"}], 
   "]"}]}]], "Input",
 CellLabel->"In[94]:=",ExpressionUUID->"a713fa48-36dc-4b00-9472-3de144d0ea93"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[94]=",ExpressionUUID->"a2c3cb9e-4de5-4d26-b818-12f9df844e11"]
}, Open  ]],

Cell["\<\
We conclude that there are 4 double cosets, three of them with order 24 and \
the last one with order 48. They all form the full group S5:\
\>", "MathCaption",ExpressionUUID->"ed5918b1-dab7-4c2f-b0e5-686cc88cd846"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"List", "@@", "S5"}], "===", 
  RowBox[{"Union", "[", 
   RowBox[{
   "doublecoset1", ",", "doublecoset2", ",", "doublecoset3", ",", 
    "doublecoset4"}], "]"}]}]], "Input",
 CellLabel->"In[95]:=",ExpressionUUID->"cef51bf9-297d-4693-9c39-7b3b5306f238"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[95]=",ExpressionUUID->"d8075769-1e5d-4dc0-87d5-025795e44b7b"]
}, Open  ]],

Cell["Tidy up:", "MathCaption",ExpressionUUID->"a077ee23-48a1-4936-95b5-7e2beb4e36fa"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "L1", ",", "L2", ",", "L3", ",", "L4", ",", "L5", ",", "L6", ",", "L7", ",",
    "L8", ",", "L9", ",", "L10", ",", "L11", ",", "L12", ",", "L13", ",", 
   "L14", ",", "L15", ",", "L16", ",", "L17", ",", "L18", ",", "L19", ",", 
   "L20", ",", "R1", ",", "R2", ",", "R3", ",", "R4", ",", "R5", ",", "R6", 
   ",", "R7", ",", "R8", ",", "R9", ",", "R10", ",", "R11", ",", "R12", ",", 
   "R13", ",", "R14", ",", "R15"}], "]"}]], "Input",
 CellLabel->"In[96]:=",ExpressionUUID->"4fea7567-e903-41ce-a5d5-36aba6a1989f"],

Cell["There are also commands to form transversals.", "Text",ExpressionUUID->"85cd4332-38e0-4d38-bf5a-7dd46d1022c7"],

Cell[TextData[{
 StyleBox["LeftTransversal\t\t\t\t", "DisplayMath"],
 StyleBox["Transversal of left cosets", "Text"],
 StyleBox["\nRightTransversal\t\t\t", "DisplayMath"],
 StyleBox["Transversal of right cosets\n", "Text"],
 StyleBox["DoubleTransversal\t\t\t", "DisplayMath"],
 StyleBox["Transversal of double cosets", "Text"]
}], "DefinitionBox",ExpressionUUID->"05f50b9a-1c72-4b06-9b24-a298b8cff5b7"],

Cell["Transversals.", "SmallText",ExpressionUUID->"e52d1756-450f-40e1-b1c5-fb37c559eb54"]
}, Closed]]
}, Closed]],

Cell["Strong Generating Sets", "Subsection",ExpressionUUID->"f9c026d3-a11c-409b-968d-399174033848"],

Cell[CellGroupData[{

Cell["4. Orbits and Schreier vectors", "SubsectionIcon",ExpressionUUID->"5273e9b8-d25a-452b-8e8f-9f1e81d88307"],

Cell["\<\
An essential tool in the analysis of the structure of a group of permutations \
is the concept of orbit of a point. It is just the set of images of that \
point which can be obtained by repeated action of the members of the group.\
\>", "Text",ExpressionUUID->"f83bfb93-d604-42e8-9ace-c27f0b0efc72"],

Cell[TextData[{
 "The command ",
 StyleBox["Orbit",
  FontFamily->"Courier"],
 " gives the orbit of a point under a group generated by a generating set:"
}], "MathCaption",ExpressionUUID->"15fbaa22-ce40-4425-b59c-739beae98231"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Orbit", "[", 
  RowBox[{"2", ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "6", ",", "5"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5", ",", "6"}], "}"}],
       "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[97]:=",ExpressionUUID->"e68fc463-c0f5-4262-8e3b-d7acf9e73430"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[97]=",ExpressionUUID->"3b8f3692-aae4-40ce-9563-9419b364d474"]
}, Open  ]],

Cell["\<\
We can compute all orbits of a group. This can be understood as a partition \
of a range of integers which by default has the length of the highest degree \
of the permutations\
\>", "MathCaption",ExpressionUUID->"fdb1a73d-a5ad-485a-bdbf-11c21ee66d5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Orbits", "[", 
  RowBox[{"GenSet", "[", 
   RowBox[{
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "6", ",", "5"}], "}"}], 
     "]"}], ",", 
    RowBox[{"Perm", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5", ",", "6"}], "}"}], 
     "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[98]:=",ExpressionUUID->"24cffec3-f39a-498e-b352-bc85d57bf03f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[98]=",ExpressionUUID->"04711e63-49a9-4ddb-89fb-64bea7af003a"]
}, Open  ]],

Cell["\<\
but can supply the length as a second argument. Many functions in the package \
have an additional argument to specify the length of the underlying set of \
points. See the documentation of each command for details:\
\>", "MathCaption",ExpressionUUID->"a0635a20-c06f-45ec-98bc-65d1ae2ecea7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Orbits", "[", 
  RowBox[{
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "6", ",", "5"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5", ",", "6"}], "}"}],
       "]"}]}], "]"}], ",", "8"}], "]"}]], "Input",
 CellLabel->"In[99]:=",ExpressionUUID->"dfa70c04-38bd-4fba-9410-feae3b12cb95"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", "7", "}"}], ",", 
   RowBox[{"{", "8", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[99]=",ExpressionUUID->"e8e55f44-6e0f-4740-9ec4-0d4277a53f92"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Orbit\t\t\t\t", "DisplayMath"],
 StyleBox["Orbit of a point under a GS", "Text"],
 StyleBox["\nOrbits\t\t\t\t", "DisplayMath"],
 StyleBox["All orbits of a group", "Text"]
}], "DefinitionBox",ExpressionUUID->"fb1284d0-6322-47a9-9ef3-d3674b9c436c"],

Cell[TextData[StyleBox["Compute orbits of a group.", "SmallText"]], "Text",ExpressionUUID->"07e983d9-10aa-4e3c-bbfd-efc4fdf6e12f"],

Cell["\<\
Given an orbit of a group it is very useful to be able to find a permutation \
of the group linking two points of the orbit, that is, such that the latter \
point is the image of the former under that permutation. Schreier introduced \
a nice way to do that: together with the points of the orbit we store two \
vectors:\
\>", "Text",ExpressionUUID->"3c1ddd70-2ca3-41a8-a080-5ca29e09c37f"],

Cell[TextData[{
 "Same orbit, now with its Schreier vectors. Point 2 is the first point of \
the orbit. Point 4 can be obtained from point 2 (see second vector) usign \
permutation ",
 StyleBox["Perm[{",
  FontFamily->"Courier"],
 "4,1,3,2,6,5",
 StyleBox["}] ",
  FontFamily->"Courier"],
 "(see first vector). Point 1 can be obtained from point 4 (see second \
vector) using the same permutation (see first vector). Again we "
}], "MathCaption",ExpressionUUID->"27e1a785-f433-4a61-a058-7f2f6be39a7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchreierOrbit", "[", 
  RowBox[{"2", ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "6", ",", "5"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "3", ",", "2", ",", "5", ",", "6"}], "}"}],
       "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[100]:=",ExpressionUUID->"241e2636-fd99-4ae0-be33-6bc931c914bb"],

Cell[BoxData[
 RowBox[{"Schreier", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "6", ",", "5"}], "}"}],
       "]"}], ",", "0", ",", "0", ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "6", ",", "5"}], "}"}],
       "]"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->
  "Out[100]=",ExpressionUUID->"5646e33e-bd58-4b5a-941d-af830623fb70"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 StyleBox["TraceSchreier",
  FontFamily->"Courier"],
 " gives the permutation that links the first point of the orbit with a given \
point:"
}], "MathCaption",ExpressionUUID->"596cf15f-519e-4520-9a3b-eadae0728fca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraceSchreier", "[", 
  RowBox[{"1", ",", "%"}], "]"}]], "Input",
 CellLabel->
  "In[101]:=",ExpressionUUID->"2c38f8fe-dc21-4729-9a14-8505e49da5b9"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "3", ",", "1", ",", "5", ",", "6"}], "}"}], 
  "]"}]], "Output",
 CellLabel->
  "Out[101]=",ExpressionUUID->"1d7c97dd-f03e-42b7-9f77-e944e0f6aadd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{"2", ",", "%"}], "]"}]], "Input",
 CellLabel->
  "In[102]:=",ExpressionUUID->"20074d6a-8e92-4880-9470-f0f54934785e"],

Cell[BoxData["1"], "Output",
 CellLabel->
  "Out[102]=",ExpressionUUID->"cfca804e-a138-4b0d-82fc-279a8b120d90"]
}, Open  ]],

Cell[TextData[{
 StyleBox["SchreierOrbit\t\t\t", "DisplayMath"],
 StyleBox["Calculate orbit with its Schreier vectors", "Text"],
 StyleBox["\nSchreier\t\t\t\t", "DisplayMath"],
 StyleBox["Head of an orbit with its Schreier vectors\n", "Text"],
 StyleBox["SchreierOrbits\t\t\t", "DisplayMath"],
 StyleBox["Calculate all orbits with a compound Schreier vector\n", "Text"],
 StyleBox["TraceSchreier\t\t\t", "DisplayMath"],
 StyleBox["Trace an orbit to find a permutation linking two points", "Text"]
}], "DefinitionBox",ExpressionUUID->"8bd4e20b-5d65-42b1-8fb0-4bc6ed670d62"],

Cell[TextData[StyleBox["Schreier vectors.", "SmallText"]], "Text",ExpressionUUID->"e7a68b48-544a-416b-a9cd-835f758c787f"]
}, Closed]],

Cell[CellGroupData[{

Cell["5. Stabilization and Strong Generating Sets", "SubsectionIcon",ExpressionUUID->"8121d062-0033-49df-b56f-43f51e5ea387"],

Cell["\<\
A second essential tool to analyze a group of permutations is the concept of \
stability.\
\>", "Text",ExpressionUUID->"a9bbcb65-eaf6-4957-9041-048d729b754e"],

Cell["Given a permutation, there can be points that are not moved:", \
"MathCaption",ExpressionUUID->"9b29c318-fd6b-4c80-a70c-5ca83e02f614"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StablePoints", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "4", ",", "6", ",", "5", ",", "7"}], "}"}],
     "]"}], ",", "7"}], "]"}]], "Input",
 CellLabel->
  "In[103]:=",ExpressionUUID->"dd326f1b-9991-49ac-bbe5-50c324d0b7f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "7"}], "}"}]], "Output",
 CellLabel->
  "Out[103]=",ExpressionUUID->"38a3953a-7c3c-4d7d-9bbd-93fc4eb43189"]
}, Open  ]],

Cell["\<\
Of course, points over the degree of the permutation are not moved:\
\>", "MathCaption",ExpressionUUID->"368edde2-c9c2-4332-91d3-118ae8051804"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StablePoints", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "4", ",", "6", ",", "5", ",", "7"}], "}"}],
     "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->
  "In[104]:=",ExpressionUUID->"fbfe2b76-5220-461e-b7c1-40fba1c4c125"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "7", ",", "8", ",", "9", ",", "10"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[104]=",ExpressionUUID->"c9686b34-dda8-4847-8dd3-d36b8d95a767"]
}, Open  ]],

Cell["\<\
Given a generating set GS and a list of points, we call pointwise stabilizer \
of those points to the subset of GS such that none of the permutations in the \
subset moves none of the points in the list:\
\>", "MathCaption",ExpressionUUID->"b0536373-06ff-42b4-bc59-b13a94aff2f7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stabilizer", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
     ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
     ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}]}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[105]:=",ExpressionUUID->"bb81d8bb-0822-425b-9cf4-dca67daaa01b"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  RowBox[{"Perm", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
  "]"}]], "Output",
 CellLabel->
  "Out[105]=",ExpressionUUID->"09bf9eeb-ed54-4784-9a29-89f595abf9ed"]
}, Open  ]],

Cell["\<\
There is a different concept, that of set-stabilization, requiring that \
points do not leave the set, though they can move:\
\>", "MathCaption",ExpressionUUID->"80fa6b37-1512-40e6-9f93-8db385840f17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetStabilizer", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], 
     ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], "]"}], 
     ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}]}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[106]:=",ExpressionUUID->"653d3089-82e4-408e-8f02-bed7b2d33061"],

Cell[BoxData[
 RowBox[{"GenSet", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1", ",", "4", ",", "5"}], "}"}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->
  "Out[106]=",ExpressionUUID->"2fd38a15-7261-417b-a792-462025ffae60"]
}, Open  ]],

Cell[TextData[{
 "The stabilizer of a group S is a subgroup. However, the stabilizer of a \
generating set of S is not necessarily a generating set of the subgroup. To \
solve that problem, Sims introduced the concept of strong generating set: we \
give a pair formed by a list of points B={",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]],ExpressionUUID->
  "911c894a-059f-4a1f-beda-4108a2fc04cb"],
 ", ..., ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "k"], TraditionalForm]],ExpressionUUID->
  "a5c3e3e5-cf62-4e28-b02c-a1761fcefaa6"],
 "} (called \"base\") and a generating set GS of the group. The generating \
set is strong with respect to that base if 1) the stabilizer S(",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]],ExpressionUUID->
  "d3697787-1abb-4b53-91c9-d5be3737e5b4"],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "m"], TraditionalForm]],ExpressionUUID->
  "4a38cb3d-9d57-448e-b72c-f804dd944b2c"],
 ") of any sorted sublist {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]],ExpressionUUID->
  "153d6c56-f4fa-4cc6-a676-00ce1f1cc75a"],
 ", ..., ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "m"], TraditionalForm]],ExpressionUUID->
  "5c282a66-b0c0-4fa2-bf1b-e1dbd7c2b1b8"],
 "}, with m",
 Cell[BoxData[
 "\[LessEqual]"], "Input",ExpressionUUID->
  "4b2b4475-f6d5-446a-97cf-1901351c8d7e"],
 "k, can be generated by a subset of the permutations in GS, and 2) no \
permutation in GS fixes all points in the base. The order of points in the \
base is relevant. This allows us to form a hierarchy of subgroups: S = S() \
\[SupersetEqual] S(",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]],ExpressionUUID->
  "ef83890d-1ee3-4edd-b46b-b86c12ed0045"],
 ") \[SupersetEqual] S(",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]],ExpressionUUID->
  "1a1f771e-baf1-4d81-9f47-337b6c882a96"],
 ",",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "2"], TraditionalForm]],ExpressionUUID->
  "096f5693-744b-46b5-8b48-851ea8b0910a"],
 ") \[SupersetEqual] ... \[SupersetEqual] S(",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]],ExpressionUUID->
  "480725e3-c308-4095-9949-f082e3c39a48"],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "k"], TraditionalForm]],ExpressionUUID->
  "0697e9aa-3fb0-455f-8222-6ec3b240fc82"],
 ") = {ID}."
}], "Text",ExpressionUUID->"2eec9b0f-d34c-4e93-bb53-18fa34a990a2"],

Cell["\<\
Hierarchy of subgroups associated to a simple strong generating set:\
\>", "MathCaption",ExpressionUUID->"55c09970-acf1-4a01-99bd-d740f66a8e98"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
       RowBox[{"Perm", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}]}], "]"}]}],
     "]"}], "]"}], "//", "ColumnForm"}]], "Input",
 CellLabel->
  "In[107]:=",ExpressionUUID->"db87f9a7-157a-4307-8afb-8930bdb087f2"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Perm", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
         RowBox[{"Perm", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], ",", 
         RowBox[{"Perm", "[", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}]}], 
        "]"}]}], "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "3", "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], "]"}], "]"}]}], 
      "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Perm[{2, 1, 3, 4}], 
      xAct`xPerm`Perm[{1, 2, 4, 3}], 
      xAct`xPerm`Perm[{3, 4, 1, 2}]]], 
    xAct`xPerm`StrongGenSet[{3}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Perm[{1, 2, 4, 3}]]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->False]], "Output",
 CellLabel->
  "Out[107]=",ExpressionUUID->"46e449b7-6920-4ad7-a63a-12f74d74da2d"]
}, Open  ]],

Cell["\<\
Strong generating sets can be calculated from a generating set using the \
Schreier-Sims algorithm. Example taken from Butler's book:\
\>", "MathCaption",ExpressionUUID->"2c1be2f3-8c3c-4bf1-b98a-f7d8b4b7b08d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}]}], ";"}]}], "Input",\

 CellLabel->
  "In[108]:=",ExpressionUUID->"7c5ffd82-edad-4bdd-ad38-52ebf440fd49"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GS", "=", 
   RowBox[{"GenSet", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[111]:=",ExpressionUUID->"6904a0c3-289c-46fb-a1a2-97b7fae4d99e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{"SGS", "=", 
   RowBox[{"SchreierSims", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "GS"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[112]:=",ExpressionUUID->"dc27b723-3347-43a4-ad91-9004895b397a"],

Cell[BoxData[
 RowBox[{"0.003323`3.672045339110705", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[112]:=",ExpressionUUID->"d5b4427e-d672-4ebc-a951-2a8e981e0b5d"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "9", ",", "10", ",", "8", ",", "2", ",", "12"}], "}"}], 
   ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "16", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "14", ",", "21"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->
  "Out[112]=",ExpressionUUID->"be9242cb-f6a8-43e1-9939-2b81fc3573e1"]
}, Open  ]],

Cell[TextData[{
 "We can give several initial points of the base. Using ",
 StyleBox["MathLink",
  FontFamily->"Courier"],
 " is faster, but always returns the result in Images notation:"
}], "MathCaption",ExpressionUUID->"78dcf9e9-6ca1-4bec-8292-62f93f16e17d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{"SGS2", "=", 
   RowBox[{"SchreierSims", "[", 
    RowBox[{
     RowBox[{"{", "8", "}"}], ",", "GS", ",", "21", ",", 
     RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[113]:=",ExpressionUUID->"dc18f298-0b62-4cc7-bd97-d7b6cfd33a9f"],

Cell[BoxData[
 RowBox[{"0.015771`4.348374229570082", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[113]:=",ExpressionUUID->"6ca8c903-c39a-41e7-903b-0ad3db377ee4"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "9", ",", "10", ",", "2", ",", "1", ",", "12"}], "}"}], 
   ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "7", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->
  "Out[113]=",ExpressionUUID->"8c36b2bb-916b-448a-80b3-e30fe33ac786"]
}, Open  ]],

Cell["\<\
We can also change the base points of a given SGS. This typically introduces \
many redundant generators and additional points in the base:\
\>", "MathCaption",ExpressionUUID->"db374996-f1f4-4c58-b2c5-d39bc1b75011"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseChange", "[", 
  RowBox[{"SGS2", ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[114]:=",ExpressionUUID->"86d069b3-5853-4b33-aa3b-888d044d438b"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "9", ",", "10", ",", "1", ",", "12", ",", "11", ",", "8", ",", "3"}], 
    "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "5", ",", "7"}], 
       "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "7", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "6", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "7"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "16", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "14", ",", "21"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "15", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "18", ",", "19"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->
  "Out[114]=",ExpressionUUID->"c0f185fb-eaeb-461a-bf96-b041f57dded0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS3", "=", 
  RowBox[{"DeleteRedundantGenerators", "[", "%", "]"}]}]], "Input",
 CellLabel->
  "In[115]:=",ExpressionUUID->"daadc813-741b-4d7d-a399-a234b30fb928"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "9", ",", "10", ",", "1", ",", "12", ",", "11", ",", "8", ",", "3"}], 
    "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "16", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "14", ",", "21"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"12", ",", "15", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "18", ",", "19"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "5", ",", "7"}], 
       "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->
  "Out[115]=",ExpressionUUID->"89060fc4-ac98-4688-b0ac-912ecef1eddb"]
}, Open  ]],

Cell["\<\
Once we have the SGS we can solve any question related to the group:\
\>", "MathCaption",ExpressionUUID->"7824ff7b-3832-446f-bc47-548483e9ea78"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StabilizerChain", "[", "SGS", "]"}], "//", "ColumnForm"}]], "Input",\

 CellLabel->
  "In[116]:=",ExpressionUUID->"b5d7edc5-7423-4d4b-884f-393dfa0eb828"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "9", ",", "10", ",", "8", ",", "2", ",", "12"}], 
        "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"8", ",", "16", ",", "11"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"13", ",", "14", ",", "21"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
      "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9", ",", "10", ",", "8", ",", "2", ",", "12"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"9", ",", "18", ",", "20"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"12", ",", "19", ",", "17"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"8", ",", "16", ",", "11"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"13", ",", "14", ",", "21"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
      "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "8", ",", "2", ",", "12"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"10", ",", "21", ",", "11"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"13", ",", "16", ",", "14"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"8", ",", "16", ",", "11"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"13", ",", "14", ",", "21"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
      "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "2", ",", "12"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"8", ",", "16", ",", "11"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"13", ",", "14", ",", "21"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
      "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "12"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", 
         RowBox[{"Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}]}], "]"}]}], 
      "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "12", "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"12", ",", "20", ",", "15"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"17", ",", "19", ",", "18"}], "}"}]}], "]"}], "]"}]}], 
      "]"}]},
    {
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"GenSet", "[", "]"}]}], "]"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{
    xAct`xPerm`StrongGenSet[{1, 9, 10, 8, 2, 12}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{1, 8, 9}, {2, 11, 15}, {3, 10, 12}, {4, 14, 19}, {5, 
       16, 17}, {6, 21, 20}, {7, 13, 18}], 
      xAct`xPerm`Cycles[{9, 18, 20}, {12, 19, 17}], 
      xAct`xPerm`Cycles[{10, 21, 11}, {13, 16, 14}], 
      xAct`xPerm`Cycles[{8, 13, 21}, {10, 14, 16}], 
      xAct`xPerm`Cycles[{8, 16, 11}, {13, 14, 21}], 
      xAct`xPerm`Cycles[{2, 3, 6}, {4, 7, 5}], 
      xAct`xPerm`Cycles[{12, 20, 15}, {17, 19, 18}]]], 
    xAct`xPerm`StrongGenSet[{9, 10, 8, 2, 12}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{9, 18, 20}, {12, 19, 17}], 
      xAct`xPerm`Cycles[{10, 21, 11}, {13, 16, 14}], 
      xAct`xPerm`Cycles[{8, 13, 21}, {10, 14, 16}], 
      xAct`xPerm`Cycles[{8, 16, 11}, {13, 14, 21}], 
      xAct`xPerm`Cycles[{2, 3, 6}, {4, 7, 5}], 
      xAct`xPerm`Cycles[{12, 20, 15}, {17, 19, 18}]]], 
    xAct`xPerm`StrongGenSet[{10, 8, 2, 12}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{10, 21, 11}, {13, 16, 14}], 
      xAct`xPerm`Cycles[{8, 13, 21}, {10, 14, 16}], 
      xAct`xPerm`Cycles[{8, 16, 11}, {13, 14, 21}], 
      xAct`xPerm`Cycles[{2, 3, 6}, {4, 7, 5}], 
      xAct`xPerm`Cycles[{12, 20, 15}, {17, 19, 18}]]], 
    xAct`xPerm`StrongGenSet[{8, 2, 12}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{8, 16, 11}, {13, 14, 21}], 
      xAct`xPerm`Cycles[{2, 3, 6}, {4, 7, 5}], 
      xAct`xPerm`Cycles[{12, 20, 15}, {17, 19, 18}]]], 
    xAct`xPerm`StrongGenSet[{2, 12}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{2, 3, 6}, {4, 7, 5}], 
      xAct`xPerm`Cycles[{12, 20, 15}, {17, 19, 18}]]], 
    xAct`xPerm`StrongGenSet[{12}, 
     xAct`xPerm`GenSet[
      xAct`xPerm`Cycles[{12, 20, 15}, {17, 19, 18}]]], 
    xAct`xPerm`StrongGenSet[{}, 
     xAct`xPerm`GenSet[]]}],
  Editable->False]], "Output",
 CellLabel->
  "Out[116]=",ExpressionUUID->"8ab8744b-7b6c-42f5-9ce9-93f57169134b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "/@", 
  RowBox[{"{", 
   RowBox[{"SGS", ",", "SGS2", ",", "SGS3"}], "}"}]}]], "Input",
 CellLabel->
  "In[117]:=",ExpressionUUID->"fd88547a-d4d3-49dd-8ff0-535a173e4f28"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27783", ",", "27783", ",", "27783"}], "}"}]], "Output",
 CellLabel->
  "Out[117]=",ExpressionUUID->"de607489-0645-49e7-b08e-bf8caa06f148"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "SGS"}], "]"}]], "Input",
 CellLabel->
  "In[118]:=",ExpressionUUID->"c6444f88-3b1d-404b-b855-f0a06fd5fc4f"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[118]=",ExpressionUUID->"f56721eb-65fc-4f3d-b539-0a72393691d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", "SGS"}], "]"}]], "Input",
 CellLabel->
  "In[119]:=",ExpressionUUID->"1c99ca69-2373-45a7-b049-d4d216d460de"],

Cell[BoxData["False"], "Output",
 CellLabel->
  "Out[119]=",ExpressionUUID->"a59bbe49-bb16-4fef-ae87-53925f291ca4"]
}, Open  ]],

Cell["\<\
A permutation in the group can be uniquely decomposed according to the chain \
of stabilizers:\
\>", "MathCaption",ExpressionUUID->"1601cb96-fa04-4631-9d2f-3033a5a9b705"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm", "=", 
  RowBox[{"PermProduct", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]], "Input",
 CellLabel->
  "In[120]:=",ExpressionUUID->"f49131ca-3979-4a89-91c5-9176c21c8953"],

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "8", ",", "18", ",", "7", ",", "16", ",", "12", ",", "3", ",", 
     "21", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "10", ",", "19", ",", "4", ",", "13", ",", "20", ",", "6", ",", 
     "11", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "14", ",", "17"}], "}"}]}], "]"}]], "Output",
 CellLabel->
  "Out[120]=",ExpressionUUID->"c7009601-7b24-43a0-8ff7-a49538361af9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermWord", "[", 
  RowBox[{"perm", ",", "SGS"}], "]"}]], "Input",
 CellLabel->
  "In[121]:=",ExpressionUUID->"2bd04581-dde7-44ec-993f-539428cc2ef0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cycles", "[", "]"}], ",", "ID", ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "7", ",", "5"}], "}"}]}], "]"}], ",", "ID", ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "13", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "14", ",", "16"}], "}"}]}], "]"}], ",", "ID", ",", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "11", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "10", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "14", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "16", ",", "17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "21", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "13", ",", "18"}], "}"}]}], "]"}]}], "}"}]], "Output",\

 CellLabel->
  "Out[121]=",ExpressionUUID->"815e1278-f158-481a-9832-fecaebc667aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm", "===", 
  RowBox[{"PermProduct", "@@", "%"}]}]], "Input",
 CellLabel->
  "In[122]:=",ExpressionUUID->"9a834438-792b-474c-b110-7d9e8082545d"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[122]=",ExpressionUUID->"3e4f3907-d3aa-415f-a457-2e99adb534ef"]
}, Open  ]],

Cell["or identified from its base images:", "MathCaption",ExpressionUUID->"c67bdb0a-de40-46cd-a178-fec0d62f7410"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{
   RowBox[{"SGS", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", "perm"}], "]"}]], "Input",
 CellLabel->
  "In[123]:=",ExpressionUUID->"84962411-3de1-482f-aaa6-487e296faf24"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "1", ",", "19", ",", "18", ",", "10", ",", "3"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[123]=",ExpressionUUID->"44ad4f1c-6ee9-4acb-96cf-9b7376986f4d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm", "===", 
  RowBox[{"FromBaseImage", "[", 
   RowBox[{"%", ",", "SGS"}], "]"}]}]], "Input",
 CellLabel->
  "In[124]:=",ExpressionUUID->"0506549a-fae7-4d5b-9087-48483092d3d5"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[124]=",ExpressionUUID->"7eae9006-0939-419f-b528-13b9dd5b335e"]
}, Open  ]],

Cell["Not every list of images defines a permutation:", "MathCaption",ExpressionUUID->"66a97a06-d6bc-416b-ad37-166029852331"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"FromBaseImage", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    ",", "SGS"}], "]"}]}]], "Input",
 CellLabel->
  "In[125]:=",ExpressionUUID->"1af9885d-effd-4d9d-8812-bd56979935fd"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FromBaseImage", "::", "noimgs"}], "MessageName"], ":", 
  " ", "\<\"Invalid list of images \[NoBreak]\\!\\({1, 2, 3, 4, 5, 6}\\)\
\[NoBreak].\"\>"}]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[125]:=",ExpressionUUID->"a871a941-f863-4af0-baf6-57ea162605da"]
}, Open  ]],

Cell["\<\
As we said, there is a one to one correspondence between base images and \
permutations in a group:\
\>", "MathCaption",ExpressionUUID->"86cce9a7-7b4f-4fc8-890a-31df10af2555"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AllBaseImages", "[", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
       RowBox[{"-", 
        RowBox[{"Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}], "]"}], "//",
   "ColumnForm"}]], "Input",
 CellLabel->
  "In[126]:=",ExpressionUUID->"887b1172-0c1d-4687-8fb7-edb212bb39b2"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "ID"}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"-", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], "]"}]}]}]},
    {
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{{1, 3} -> 
    xAct`xPerm`ID, {1, 4} -> -xAct`xPerm`Cycles[{3, 4}], {2, 3} -> -
     xAct`xPerm`Cycles[{1, 2}], {2, 4} -> 
    xAct`xPerm`Cycles[{1, 2}, {3, 4}], {3, 1} -> 
    xAct`xPerm`Cycles[{1, 3}, {2, 4}], {3, 2} -> -
     xAct`xPerm`Cycles[{1, 3, 2, 4}], {4, 1} -> -
     xAct`xPerm`Cycles[{1, 4, 2, 3}], {4, 2} -> 
    xAct`xPerm`Cycles[{1, 4}, {2, 3}]}],
  Editable->False]], "Output",
 CellLabel->
  "Out[126]=",ExpressionUUID->"76b6e823-d08e-477d-8203-a0773be4fd31"]
}, Open  ]],

Cell[TextData[{
 StyleBox["StablePoints\t\t\t\t", "DisplayMath"],
 StyleBox["Points that are not moved by a permutation\n", "Text"],
 StyleBox["NonStablePoints\t\t\t\t", "DisplayMath"],
 StyleBox["Construct a base for a group", "Text"],
 StyleBox["\n", "DisplayMath"],
 StyleBox["Sta", "DisplayMath",
  FontFamily->"Courier"],
 StyleBox["biliz",
  FontFamily->"Courier"],
 StyleBox["er", "DisplayMath",
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t\t", "DisplayMath"],
 StyleBox["Subset of permutations that do not move a list of points\n", 
  "Text"],
 StyleBox["SetSta", "DisplayMath",
  FontFamily->"Courier"],
 StyleBox["biliz",
  FontFamily->"Courier"],
 StyleBox["er", "DisplayMath",
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Subset of permutations that do not move a list of points within a \
set", "Text"],
 StyleBox["\n", "DisplayMath"],
 StyleBox["Sta", "DisplayMath",
  FontFamily->"Courier"],
 StyleBox["biliz",
  FontFamily->"Courier"],
 StyleBox["erChain", "DisplayMath",
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Chain of sta", "Text"],
 "biliz",
 StyleBox["ers of a Strong Generating Set\n", "Text"],
 StyleBox["StrongGenSet\t\t\t\t", "DisplayMath"],
 StyleBox["Head for a Strong Generating Set\n", "Text"],
 StyleBox["SchreierSims\t\t\t\t", "DisplayMath"],
 StyleBox["Algorithm to compute a SGS from a GS\n", "Text"],
 StyleBox["BaseChange\t\t\t\t\t", "DisplayMath"],
 StyleBox["Change base of a SGS\n", "Text"],
 StyleBox["DeleteRedundantGenerators\t", "DisplayMath"],
 StyleBox["Drop unnecessary permutations in a SGS\n", "Text"],
 StyleBox["JoinSGS\t\t\t\t\t\t", "DisplayMath"],
 StyleBox["Form SGS for product group\n", "Text"],
 StyleBox["OrderOfGroup\t\t\t\t", "DisplayMath"],
 StyleBox["Compute order of group described by a SGS\n", "Text"],
 StyleBox["PermMemberQ\t\t\t\t\t", "DisplayMath"],
 StyleBox["Check whether a permutation belongs to a group described by a SGS\n\
", "Text"],
 StyleBox["PermWord\t\t\t\t\t", "DisplayMath"],
 StyleBox["Decompose a permutation as a unique product of coset \
representatives in a SGS hierarchy\n", "Text"],
 StyleBox["FromBaseImage\t\t\t\t", "DisplayMath"],
 StyleBox["Construct the unique permutation associated to a list of base \
images\n", "Text"],
 StyleBox["AllBaseImages\t\t\t\t", "DisplayMath"],
 StyleBox["List all possible base images and their corresponding \
permutations", "Text"]
}], "DefinitionBox",ExpressionUUID->"c29ee663-7f80-4b62-8e6d-1c4a1cc2b1b3"],

Cell["Strong Generating Sets.", "SmallText",ExpressionUUID->"7b84964c-bca6-4892-ab88-6245a29c2e85"],

Cell["\<\
The main idea behind the Schreier-Sims algorithm is that of \"backtrack \
search\". Using the one-to-one mapping between permutations and base images, \
it is possible to organize all permutations in a group in a tree whose nodes \
are the possible images of the points in the base. The Schreier vectors allow \
us to traverse the tree up and down, and the identification between cosets \
and points of orbits allows us to discard all leaves of the tree below a \
given node by testing just a single leave. See Butler's book for full details.\
\>", "Text",ExpressionUUID->"ced172a7-5716-47aa-bdc9-46961e79f551"],

Cell[TextData[{
 "The function ",
 StyleBox["Search",
  FontFamily->"Courier"],
 " implements backtracking to search for a SGS of a subgroup of a given group:"
}], "MathCaption",ExpressionUUID->"7bf829fc-00b3-4b18-b702-ea1dba327cff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Search"}]], "Input",
 CellLabel->
  "In[127]:=",ExpressionUUID->"ac3d5c01-ebae-4d7d-8f39-1dbe4e98918a"],

Cell[BoxData[
 StyleBox["\<\"Search[SGS, P, s, SGSK] returns the s-th stabilizer in the \
stabilizer-chain of the subgroup K of permutations obeying the property P in \
the group G (described by the strong generating set SGS). It is assumed \
P[perm] returns True or False on any permutation of the group G. The fourth \
argument is a strong generating set for a subgroup of K, possibly a deeper \
stabilizer in its stabilizer-chain.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3568058560-2493619",ExpressionUUID->"e663917b-b9c4-4351-a8f1-\
c51f8abf05a3"]
}, Open  ]],

Cell[TextData[{
 "For instance, let us suppose we start from the group ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "4"], TraditionalForm]],ExpressionUUID->
  "60a91add-bbc5-4644-9d0a-add6ae5a79d9"],
 "."
}], "MathCaption",ExpressionUUID->"c26bab11-05ff-4d88-905f-540dffab4baf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SGS", "=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
       RowBox[{"Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->
  "In[128]:=",ExpressionUUID->"f1420991-8c54-4d78-9351-4ff7326d024d"],

Cell[TextData[{
 "and we want to find a sgs for the subgroup of permutations commuting with \
permutation ",
 StyleBox["z",
  FontFamily->"Courier"],
 " (the so-called centralizer of ",
 StyleBox["z",
  FontFamily->"Courier"],
 "):"
}], "MathCaption",ExpressionUUID->"d06b4bc8-3df6-4e73-9a08-e6835363efd6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[129]:=",ExpressionUUID->"34823c75-9631-42c9-af84-4ccb1d4a7860"],

Cell[TextData[{
 "We define the property ",
 StyleBox["P",
  FontFamily->"Courier"],
 " identifying the permutations commuting with ",
 StyleBox["z",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"756209b8-f663-4217-bea9-849bedf52896"],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", "perm_", "]"}], ":=", 
  RowBox[{"PermEqual", "[", 
   RowBox[{
    RowBox[{"PermProduct", "[", 
     RowBox[{"z", ",", "perm"}], "]"}], ",", 
    RowBox[{"PermProduct", "[", 
     RowBox[{"perm", ",", "z"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[130]:=",ExpressionUUID->"ffc5a695-3726-40fd-a28d-66f4aeba47ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P", "[", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[131]:=",ExpressionUUID->"419a95c3-3700-465a-8ede-2e3534a708c4"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[131]=",ExpressionUUID->"c434ba0a-af7c-41bd-ab75-62c297233e79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P", "[", 
  RowBox[{"Cycles", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[132]:=",ExpressionUUID->"e5daf9a3-fe1c-45aa-9204-9e39fe9738d3"],

Cell[BoxData["False"], "Output",
 CellLabel->
  "Out[132]=",ExpressionUUID->"d7febfbb-2ed7-4073-9057-9e0c1cf34097"]
}, Open  ]],

Cell[TextData[{
 "The first stabilizer in the chain coincides with the group itself and so we \
search for the first stabilizer of the subgroup of ",
 StyleBox["SGS",
  FontFamily->"Courier"],
 " obeying property ",
 StyleBox["P",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"fa7249cf-1383-4a17-81bb-25389686564b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Search", "[", 
  RowBox[{"SGS", ",", "P", ",", "1", ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[133]:=",ExpressionUUID->"dde78319-7d80-4898-a24b-e6693fa3ea07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Branching over points ", {3, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"a5974a61-7815-4ecd-8c1b-c3f8d820deab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   "ID"}],
  SequenceForm[
  "Generate at level ", 3, " with i=", 4, ". We have list ", {1, 2, 3}, 
   " and permutation ", xAct`xPerm`ID],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"39e9b21f-35ea-46db-92af-d8cb2a379144"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 3, " with i=", 4, ". We have list ", {1, 2, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{3, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"6922e8e3-503b-4675-af5d-1fa720a577de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Branching over points ", {2, 3, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"64546e21-c2d4-49e5-aaf8-853b2faa750c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {2, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"cceab7c1-44a6-4200-96c0-e9f550cbe638"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 3, 2}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 3}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"74bd60fc-68d9-4b1e-b6ab-4d4aa1986c19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 3, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 3, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"e3ca30b1-3b21-4842-b61b-9ae0ea73062f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}],
  SequenceForm["Generating over points ", {2, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"b335344d-a839-4014-962b-8c0ebc305973"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "3"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 4, 2}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 4, 3}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"bcd8f9dc-43fb-4ff9-a8ec-3eebd34bf22d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 2, " with i=", 4, ". We have list ", {1, 4, 3}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{2, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"3e1fd313-5695-4860-a329-ffc283d55972"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Cycles[{2, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"82058e1a-d2ce-4fd6-920f-86898b87a5e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Branching over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}]}],
  SequenceForm["Branching over points ", {1, 2, 4, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"19aadb57-08f5-4653-a69d-575140294476"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {1, 3, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"f64c8b5d-fe0e-45ae-a9e9-d812cdaa77fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generating over points \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Generating over points ", {3, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"f1fbee1a-1774-4fa8-b0b1-fd3bab435a03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {2, 1, 3}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 2}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"c77ee091-a4a5-41c8-9874-61c0966718bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generate at level \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" with i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\". We have list \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}],
  SequenceForm[
  "Generate at level ", 1, " with i=", 4, ". We have list ", {2, 1, 4}, 
   " and permutation ", 
   xAct`xPerm`Cycles[{1, 2}, {3, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"381f89fe-31cb-4a89-85a0-9addade735bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Added permutation \"\>", "\[InvisibleSpace]", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}],
  SequenceForm["  Added permutation ", 
   xAct`xPerm`Cycles[{1, 2}, {3, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[133]:=",ExpressionUUID->"f731ea13-4091-4fa7-994b-40621d87c3ab"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[133]=",ExpressionUUID->"70372eb9-25cf-4449-8516-faa09c81e406"]
}, Open  ]],

Cell["\<\
We see that we have tested 8 permutations in a group of order 24. Only 2 of \
those 8 form the final sgs of the centralizer, which has order 8:\
\>", "MathCaption",ExpressionUUID->"e8be86bc-f2ad-4b61-b7e5-4b48b87e6528"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[134]:=",ExpressionUUID->"80cc5235-9bbc-4300-9099-8ff775a0184b"],

Cell[BoxData["8"], "Output",
 CellLabel->
  "Out[134]=",ExpressionUUID->"312c1ede-8d58-4bcf-8ee6-dc6d5a819c67"]
}, Open  ]],

Cell["Clean up:", "MathCaption",ExpressionUUID->"2ef41235-99b2-4e7f-a8c6-e2eb5e2ead08"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"SGS", ",", "z", ",", "P", ",", "a", ",", "b", ",", "c"}], 
  "]"}]], "Input",
 CellLabel->
  "In[135]:=",ExpressionUUID->"38ba9e70-8482-4043-a1c3-d9c54e7df5eb"],

Cell[TextData[{
 StyleBox["Search\t\t\t\t", "DisplayMath"],
 StyleBox["Compute subgroup of permutations obeying a given property", 
  "Text"]
}], "DefinitionBox",ExpressionUUID->"da2b2665-4df2-40a8-a7ec-fda6228f899c"],

Cell["Search subgroups.", "SmallText",ExpressionUUID->"fae043d0-7892-4c92-8158-091c18afbcf2"]
}, Closed]],

Cell[CellGroupData[{

Cell["6. Some important groups of symmetry", "SubsectionIcon",ExpressionUUID->"1def0d81-1477-4803-bb48-81f6316ed6a3"],

Cell[TextData[{
 "There are some groups which are used very often. ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " defines special ways to generate their associated SGSs. By default the \
permutations are given in ",
 StyleBox["Cycles",
  FontFamily->"Courier"],
 " notation:"
}], "Text",ExpressionUUID->"c98840ae-7141-441d-99fa-b110610d42d2"],

Cell["\<\
Strong Generating Set for the symmetric or antisymmetric groups of several \
points:\
\>", "MathCaption",ExpressionUUID->"49ef2fb2-e0fa-4d30-9a33-0611f8bf1603"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", "Cycles"}], 
  "]"}]], "Input",
 CellLabel->
  "In[136]:=",ExpressionUUID->"6c48c0e1-dd88-48bf-a06c-35ac19570af0"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"x2", ",", "x3"}], "}"}], "]"}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[136]=",ExpressionUUID->"8a164af8-c539-48d0-b67d-086dc68b6150"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Antisymmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], "}"}], ",", "Cycles"}], 
  "]"}]], "Input",
 CellLabel->
  "In[137]:=",ExpressionUUID->"1ed84713-a6be-49db-8e54-3a697cc64f92"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"x1", ",", "x2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"x2", ",", "x3"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"x3", ",", "x4"}], "}"}], "]"}]}]}], "]"}]}], "]"}]], "Output",\

 CellLabel->
  "Out[137]=",ExpressionUUID->"464f997f-0f3d-4a78-85da-00b360f6f5b5"]
}, Open  ]],

Cell["\<\
Strong Generating Set for the Riemann symmetry group of four points. Note the \
position of the two antisymmetric pairs:\
\>", "MathCaption",ExpressionUUID->"95f58489-b731-4b76-8a19-293b983c232c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSymmetric", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "5", ",", "2", ",", "9"}], "}"}], "]"}]], "Input",
 CellLabel->
  "In[138]:=",ExpressionUUID->"9b47f5b2-324d-474f-aec5-55ffe9e844ad"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5", ",", "9"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "9"}], "}"}], "]"}]}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[138]=",ExpressionUUID->"1f798d97-fa0e-4e81-ac49-8902f7909126"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 StyleBox["PairSymmetric",
  FontFamily->"Courier"],
 " is far more general. It has two switches which control symmetry and \
antisymmetry under exchange of pairs and of members of a given pair."
}], "MathCaption",ExpressionUUID->"5e2f12bd-c5b2-497f-b221-2b37f0c02c0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairSymmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"-", "1"}], ",", "0"}], "]"}]], "Input",
 CellLabel->
  "In[139]:=",ExpressionUUID->"152cc1ba-3f7d-450b-86aa-4f3a3436e32e"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "5", ",", "7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "6", ",", "8"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "6", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "8"}], "}"}]}], "]"}]}]}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->
  "Out[139]=",ExpressionUUID->"2735946a-0bec-46ee-a041-385e1b13e8ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairSymmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}]}], "}"}], ",", "0", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->
  "In[140]:=",ExpressionUUID->"f75a3a9c-c98c-4705-a8a9-eac8642675bf"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8"}], "}"}], "]"}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[140]=",ExpressionUUID->"5579a48f-9029-44cd-a7b0-2ef2c7c29e1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairSymmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"-", "1"}], ",", "1"}], "]"}]], "Input",
 CellLabel->
  "In[141]:=",ExpressionUUID->"7095e420-f7ca-4c94-ba5f-c36fd06caae1"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "5", ",", "7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4", ",", "6", ",", "8"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "5", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "6", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "8"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8"}], "}"}], "]"}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[141]=",ExpressionUUID->"cfd81f5a-032e-4dd7-976e-998e972708bb"]
}, Open  ]],

Cell[TextData[{
 "The symmetry of a Riemann tensor would be given as follows, and differs \
from ",
 StyleBox["RiemannSymmetric",
  FontFamily->"Courier"],
 " in the base:"
}], "MathCaption",ExpressionUUID->"67be236f-858e-4f0a-9e05-5dd9acf2e848"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairSymmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "1", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->
  "In[142]:=",ExpressionUUID->"2c96f3f9-9b7b-44ee-ad1e-256f67ed50db"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[142]=",ExpressionUUID->"43a26463-550e-4985-a736-8fae89c2854e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSymmetric", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->
  "In[143]:=",ExpressionUUID->"7c73dc24-f185-4b2e-9809-35c23af56dfc"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[143]=",ExpressionUUID->"4ff0bc26-191e-470d-b555-0e1545cd1bd8"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Symmetric\t\t\t\t", "DisplayMath"],
 StyleBox["Give a SGS for a symmetric group\n", "Text"],
 StyleBox["Antisymmetric\t\t\t", "DisplayMath"],
 StyleBox["Give a SGS for an alternating group\n", "Text"],
 StyleBox["PairSymmetric\t\t\t", "DisplayMath"],
 StyleBox["Give a SGS for an group of permutations of pairs and/or their \
elements\n", "Text"],
 StyleBox["RiemannSymmetric",
  FontFamily->"Courier"],
 StyleBox["\t\t", "DisplayMath"],
 StyleBox["Give a SGS for the group of symmetries of the Riemann tensor", 
  "Text"]
}], "DefinitionBox",ExpressionUUID->"d94ec330-134a-4b26-a49d-8790fe529b57"],

Cell["Some important SGSs.", "SmallText",ExpressionUUID->"2d19ffe0-ff67-4afa-b35f-6f4321e14e98"]
}, Closed]],

Cell[CellGroupData[{

Cell["7. Examples of Schreier-Sims algorithm", "SubsectionIcon",ExpressionUUID->"bcb35650-2846-49e8-a9ca-3b2b49114ae6"],

Cell["\<\
This section contains a number of very hard examples to show the power of our \
implementation of the algorithms. We do not expect, however, to need these \
groups in tensor computer algebra applications.\
\>", "Text",ExpressionUUID->"746d6343-1185-4833-8deb-607ee162db35"],

Cell[TextData[{
 "Here we shall always use the external canonicalizer. It would be too slow \
for our ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code."
}], "MathCaption",ExpressionUUID->"4673e4fc-6482-4fac-9b7f-77300920ff06"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Orbit", ",", 
    RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"SchreierSims", ",", 
    RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input",
 CellLabel->
  "In[144]:=",ExpressionUUID->"889ae6d3-35d8-4f47-93c6-6372a931163d"],

Cell[TextData[{
 StyleBox["MathLink", "DisplayMath"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Option for Orbit, SchreierSims and CanonicalPerm to use an \
external, faster executable code", "Text"]
}], "DefinitionBox",ExpressionUUID->"966b1d70-9189-4ec4-a09e-bc6c9b605632"],

Cell["External executable.", "SmallText",ExpressionUUID->"fa14ff3b-a488-49fb-997d-1ad110333936"],

Cell[CellGroupData[{

Cell["7.1. Rubik's cube", "SubsubsectionIcon",ExpressionUUID->"3a96018f-3e2c-416a-afeb-e95ab25670c9"],

Cell["\<\
Let us suppose that we number from 1 to 48 the non-central coloured squares \
of a Rubik's cube. There are six basic rotations, corresponding to each of \
the six faces:\
\>", "Text",ExpressionUUID->"b091f804-71ab-4dfe-bc5c-6df269503a4a"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .75 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.255952 0.238095 [
[ 0 0 0 0 ]
[ 1 .75 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .75 L
0 .75 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.02381 .25595 m
.97619 .25595 L
.97619 .49405 L
.02381 .49405 L
.02381 .25595 L
s
.2619 .01786 m
.5 .01786 L
.5 .73214 L
.2619 .73214 L
.2619 .01786 L
s
.7381 .25595 m
.7381 .49405 L
s
.5 Mabswid
.02381 .33532 m
.97619 .33532 L
s
.02381 .41468 m
.97619 .41468 L
s
.2619 .57341 m
.5 .57341 L
s
.2619 .65278 m
.5 .65278 L
s
.2619 .17659 m
.5 .17659 L
s
.2619 .09722 m
.5 .09722 L
s
.10317 .25595 m
.10317 .49405 L
s
.18254 .25595 m
.18254 .49405 L
s
.34127 .01786 m
.34127 .73214 L
s
.42063 .01786 m
.42063 .73214 L
s
.57937 .25595 m
.57937 .49405 L
s
.65873 .25595 m
.65873 .49405 L
s
.81746 .25595 m
.81746 .49405 L
s
.89683 .25595 m
.89683 .49405 L
s
gsave
.30159 .45437 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
gsave
.38095 .45437 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
gsave
.46032 .45437 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
gsave
.30159 .375 -67.5938 -11.1563 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.3125 translate 1 -1 scale
63.000 14.438 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
gsave
.46032 .375 -67.5938 -11.1563 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.3125 translate 1 -1 scale
63.000 14.438 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
gsave
.30159 .29563 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
1.000 setlinewidth
grestore
gsave
.38095 .29563 -67.5938 -11.1563 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.3125 translate 1 -1 scale
63.000 14.438 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
1.000 setlinewidth
grestore
gsave
.46032 .29563 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(8) show
1.000 setlinewidth
grestore
gsave
.22222 .45437 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(9) show
1.000 setlinewidth
grestore
gsave
.22222 .375 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
1.000 setlinewidth
grestore
gsave
.22222 .29563 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
1.000 setlinewidth
grestore
gsave
.30159 .21627 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(12) show
1.000 setlinewidth
grestore
gsave
.38095 .21627 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(13) show
1.000 setlinewidth
grestore
gsave
.46032 .21627 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
1.000 setlinewidth
grestore
gsave
.53968 .29563 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(15) show
1.000 setlinewidth
grestore
gsave
.53968 .375 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(16) show
1.000 setlinewidth
grestore
gsave
.53968 .45437 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(17) show
1.000 setlinewidth
grestore
gsave
.14286 .45437 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(18) show
1.000 setlinewidth
grestore
gsave
.14286 .29563 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(19) show
1.000 setlinewidth
grestore
gsave
.30159 .1369 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
1.000 setlinewidth
grestore
gsave
.46032 .1369 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(21) show
1.000 setlinewidth
grestore
gsave
.61905 .29563 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(22) show
1.000 setlinewidth
grestore
gsave
.61905 .45437 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(23) show
1.000 setlinewidth
grestore
gsave
.06349 .45437 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(24) show
1.000 setlinewidth
grestore
gsave
.06349 .375 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(25) show
1.000 setlinewidth
grestore
gsave
.06349 .29563 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(26) show
1.000 setlinewidth
grestore
gsave
.30159 .05754 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(27) show
1.000 setlinewidth
grestore
gsave
.38095 .05754 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(28) show
1.000 setlinewidth
grestore
gsave
.46032 .05754 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(29) show
1.000 setlinewidth
grestore
gsave
.69841 .29563 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(30) show
1.000 setlinewidth
grestore
gsave
.69841 .375 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(31) show
1.000 setlinewidth
grestore
gsave
.69841 .45437 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(32) show
1.000 setlinewidth
grestore
gsave
.93651 .29563 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(33) show
1.000 setlinewidth
grestore
gsave
.85714 .29563 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(34) show
1.000 setlinewidth
grestore
gsave
.77778 .29563 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(35) show
1.000 setlinewidth
grestore
gsave
.93651 .375 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(36) show
1.000 setlinewidth
grestore
gsave
.77778 .375 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(37) show
1.000 setlinewidth
grestore
gsave
.93651 .45437 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(38) show
1.000 setlinewidth
grestore
gsave
.85714 .45437 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(39) show
1.000 setlinewidth
grestore
gsave
.77778 .45437 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(40) show
1.000 setlinewidth
grestore
gsave
.30159 .69246 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(41) show
1.000 setlinewidth
grestore
gsave
.38095 .69246 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(42) show
1.000 setlinewidth
grestore
gsave
.46032 .69246 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(43) show
1.000 setlinewidth
grestore
gsave
.30159 .6131 -72.1875 -11.1563 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.3125 translate 1 -1 scale
63.000 14.438 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(44) show
1.000 setlinewidth
grestore
gsave
.46032 .6131 -72.1875 -11.1563 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.3125 translate 1 -1 scale
63.000 14.438 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(45) show
1.000 setlinewidth
grestore
gsave
.30159 .53373 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(46) show
1.000 setlinewidth
grestore
gsave
.38095 .53373 -72.1875 -11.1563 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.3125 translate 1 -1 scale
63.000 14.438 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(47) show
1.000 setlinewidth
grestore
gsave
.46032 .53373 -72.1875 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(48) show
1.000 setlinewidth
grestore
gsave
.38095 .375 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
gsave
.38095 .1369 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
gsave
.14286 .375 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
gsave
.38095 .6131 -67.5938 -11.1563 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.3125 translate 1 -1 scale
63.000 14.438 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
gsave
.61905 .375 -67.5938 -11.1563 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.3125 translate 1 -1 scale
63.000 14.438 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
gsave
.85714 .375 -67.5938 -11.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 22.5625 translate 1 -1 scale
63.000 14.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 15.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(6) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{402.438, 301.625},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[75]:=",ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ImageRangeCache->{{{136., 537.438}, {410.625, 110.}} -> {-1.5282, \
0.0776004, 0.0104782, \
0.0104782}},ExpressionUUID->"c7c4bafc-7eb0-44a4-87a5-b5c90a5d42ba"],

Cell["\<\
We introduce the following notation for quarter-turns, with clockwise \
rotations:\
\>", "MathCaption",ExpressionUUID->"a18964f8-f71c-4937-ac6b-ec51b304add8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rot1", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "8", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "7", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "48", ",", "15", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "47", ",", "16", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "46", ",", "17", ",", "14"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rot2", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "15", ",", "35", ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "22", ",", "34", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "30", ",", "33", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "14", ",", "29", ",", "27"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "21", ",", "28", ",", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rot3", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "12", ",", "33", ",", "41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "20", ",", "36", ",", "44"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "27", ",", "38", ",", "46"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "11", ",", "26", ",", "24"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "19", ",", "25", ",", "18"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rot4", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "24", ",", "40", ",", "17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "18", ",", "39", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "38", ",", "32"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"41", ",", "43", ",", "48", ",", "46"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"42", ",", "45", ",", "47", ",", "44"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rot5", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "43", ",", "35", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "45", ",", "37", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "48", ",", "40", ",", "29"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "17", ",", "32", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"16", ",", "23", ",", "31", ",", "22"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rot6", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"24", ",", "27", ",", "30", ",", "43"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "28", ",", "31", ",", "42"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "29", ",", "32", ",", "41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"33", ",", "35", ",", "40", ",", "38"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"34", ",", "37", ",", "39", ",", "36"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RubikGS", "=", 
   RowBox[{"GenSet", "[", 
    RowBox[{
    "rot1", ",", "rot2", ",", "rot3", ",", "rot4", ",", "rot5", ",", "rot6"}],
     "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[146]:=",ExpressionUUID->"15261f1f-656c-4576-a3bf-0fada7bbcaf3"],

Cell["\<\
It is customary to define the following face-turns (the initials stand for \
Front, Down, Left, Up, Right, Back for obvious reasons):\
\>", "MathCaption",ExpressionUUID->"967ce616-e3dc-4a97-ade1-7579a19f6c4a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"faceturns", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"F1", "\[Rule]", "rot1"}], ",", 
     RowBox[{"F2", "\[Rule]", 
      RowBox[{"PermProduct", "[", 
       RowBox[{"rot1", ",", "rot1"}], "]"}]}], ",", 
     RowBox[{"Fp", "\[Rule]", 
      RowBox[{"InversePerm", "[", "rot1", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"D1", "\[Rule]", "rot2"}], ",", 
     RowBox[{"D2", "\[Rule]", 
      RowBox[{"PermProduct", "[", 
       RowBox[{"rot2", ",", "rot2"}], "]"}]}], ",", 
     RowBox[{"Dp", "\[Rule]", 
      RowBox[{"InversePerm", "[", "rot2", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"L1", "\[Rule]", "rot3"}], ",", 
     RowBox[{"L2", "\[Rule]", 
      RowBox[{"PermProduct", "[", 
       RowBox[{"rot3", ",", "rot3"}], "]"}]}], ",", 
     RowBox[{"Lp", "\[Rule]", 
      RowBox[{"InversePerm", "[", "rot3", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"U1", "\[Rule]", "rot4"}], ",", 
     RowBox[{"U2", "\[Rule]", 
      RowBox[{"PermProduct", "[", 
       RowBox[{"rot4", ",", "rot4"}], "]"}]}], ",", 
     RowBox[{"Up", "\[Rule]", 
      RowBox[{"InversePerm", "[", "rot4", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"R1", "\[Rule]", "rot5"}], ",", 
     RowBox[{"R2", "\[Rule]", 
      RowBox[{"PermProduct", "[", 
       RowBox[{"rot5", ",", "rot5"}], "]"}]}], ",", 
     RowBox[{"Rp", "\[Rule]", 
      RowBox[{"InversePerm", "[", "rot5", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"B1", "\[Rule]", "rot6"}], ",", 
     RowBox[{"B2", "\[Rule]", 
      RowBox[{"PermProduct", "[", 
       RowBox[{"rot6", ",", "rot6"}], "]"}]}], ",", 
     RowBox[{"Bp", "\[Rule]", 
      RowBox[{"InversePerm", "[", "rot6", "]"}]}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->
  "In[153]:=",ExpressionUUID->"37374ad2-d711-42f4-b67e-6a8ebe7336c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RubikPoints", "=", 
   RowBox[{"{", 
    RowBox[{
    "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f", ",", "f",
      ",", "l", ",", "l", ",", "l", ",", "d", ",", "d", ",", "d", ",", "r", 
     ",", "r", ",", "r", ",", "l", ",", "l", ",", "d", ",", "d", ",", "r", 
     ",", "r", ",", "l", ",", "l", ",", "l", ",", "d", ",", "d", ",", "d", 
     ",", "r", ",", "r", ",", "r", ",", "b", ",", "b", ",", "b", ",", "b", 
     ",", "b", ",", "b", ",", "b", ",", "b", ",", "u", ",", "u", ",", "u", 
     ",", "u", ",", "u", ",", "u", ",", "u", ",", "u"}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->
  "In[154]:=",ExpressionUUID->"7bbc541c-ba3d-4888-96d7-8032cb9e374b"],

Cell["\<\
With a normal Linux box we can compute a strong generating set in a few \
seconds:\
\>", "MathCaption",ExpressionUUID->"c539992c-7804-4b8e-86cd-04a08e8aeee2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"RubikSGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "RubikGS", ",", "48"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[155]:=",ExpressionUUID->"e8823e88-f6af-4255-9759-d7a73ec8bc0c"],

Cell[BoxData[
 RowBox[{"2.355138`6.522531357654694", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[155]:=",ExpressionUUID->"9ccca9ce-0e6e-4760-a879-a7d2c7f63608"]
}, Open  ]],

Cell[TextData[{
 "We translate it to ",
 StyleBox["Cycles",
  FontFamily->"Courier"],
 " notation. We see that there are 18 points in the base and 99 generators (a \
SGS with only 19 generators is known for the Rubik's group):"
}], "MathCaption",ExpressionUUID->"7e2e4dcf-cb71-4238-a1fe-a09c126fb699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RubikSGS", "=", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"RubikSGS", ",", "Cycles"}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[156]:=",ExpressionUUID->"14d6f30e-1316-4cc7-8b06-cccf6f0556a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "RubikSGS"}]], "Input",
 CellLabel->
  "In[157]:=",ExpressionUUID->"ae6cddfa-25b0-42de-a763-995ab0a4d8bf"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"18", ",", "99"}], "]"}]], "Output",
 CellLabel->
  "Out[157]=",ExpressionUUID->"9f7ee4f5-c3d3-44d8-8723-3ae8f122208e"]
}, Open  ]],

Cell["\<\
Reordering the base we can get this reduced SGS (this is taken from Butler's \
book):\
\>", "MathCaption",ExpressionUUID->"835499ef-6344-4a34-83b5-38d38029648a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Rubikbase2", "=", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "6", ",", "3", ",", "8", ",", "21", ",", "23", ",", "26", ",", 
     "5", ",", "29", ",", "19", ",", "7", ",", "24", ",", "25", ",", "28", 
     ",", "31", ",", "18", ",", "4", ",", "2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RubikGS2", "=", 
   RowBox[{"GenSet", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "8", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "5", ",", "7", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "48", ",", "15", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "47", ",", "16", ",", "13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "46", ",", "17", ",", "14"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", "15", ",", "35", ",", "26"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "22", ",", "34", ",", "19"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "30", ",", "33", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "14", ",", "29", ",", "27"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "21", ",", "28", ",", "20"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "43", ",", "35", ",", "14"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "45", ",", "37", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "48", ",", "40", ",", "29"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "17", ",", "32", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "23", ",", "31", ",", "22"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "37", ",", "28", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "26", ",", "29", ",", "32"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "33", ",", "35", ",", "40"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "27", ",", "30", ",", "43"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "31", ",", "34", ",", "22"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "45", ",", "13", ",", "37", ",", "21"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "31", ",", "22", ",", "16", ",", "23"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"26", ",", "27", ",", "33"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"29", ",", "35", ",", "30"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"19", ",", "23", ",", "34"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "45", ",", "28"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"24", ",", "27", ",", "30", ",", "43"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"25", ",", "28", ",", "31", ",", "42"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"26", ",", "29", ",", "32", ",", "41"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"33", ",", "35", ",", "40", ",", "38"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"34", ",", "37", ",", "39", ",", "36"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "28", ",", "37"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "34", ",", "31"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "28", ",", "47", ",", "34"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"24", ",", "41", ",", "38"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"25", ",", "39", ",", "31", ",", "36", ",", "42", ",", "37"}],
         "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"29", ",", "43", ",", "30", ",", "40", ",", "35", ",", "32"}],
         "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"19", ",", "31", ",", "34"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "37", ",", "28"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "31", ",", "34"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "37", ",", "28"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"24", ",", "41", ",", "38"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "43", ",", "40"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"24", ",", "40"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"25", ",", "39", ",", "34", ",", "37"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"28", ",", "31", ",", "36", ",", "42"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "38"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"41", ",", "43"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"25", ",", "28", ",", "31"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"34", ",", "37", ",", "36"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "31", ",", "34"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"28", ",", "47", ",", "37"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "31", ",", "39"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"37", ",", "42", ",", "47"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "18", ",", "39"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"42", ",", "47", ",", "44"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "10", ",", "39"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "42", ",", "47"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "47"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"39", ",", "42"}], "}"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",\

 CellLabel->
  "In[158]:=",ExpressionUUID->"ec2f9534-9334-4601-9d1c-a82ac998b840"],

Cell["We check that it is a strong generating set indeed:", "MathCaption",ExpressionUUID->"068aa033-b6bd-4067-9956-d9e20282ffc7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"RubikSGS2", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{"Rubikbase2", ",", "RubikGS2", ",", "48"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[160]:=",ExpressionUUID->"2803a144-36f1-4c9e-843b-0dbe96509018"],

Cell[BoxData[
 RowBox[{"0.518441`5.8652143374724215", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[160]:=",ExpressionUUID->"b888c10a-8b47-4290-ba31-18255f25c125"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"RubikSGS2", "=", 
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"RubikSGS2", ",", "Cycles"}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[161]:=",ExpressionUUID->"7487f24e-0f55-4880-b9fe-067fb82ab1cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "RubikSGS2"}]], "Input",
 CellLabel->
  "In[162]:=",ExpressionUUID->"4da2402d-5a38-46e1-925b-46deabf64ede"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"18", ",", "19"}], "]"}]], "Output",
 CellLabel->
  "Out[162]=",ExpressionUUID->"cf851973-3e78-47fd-8d42-6245b85ba854"]
}, Open  ]],

Cell["As we said, it is a huge group:", "MathCaption",ExpressionUUID->"908d3761-9a8c-49b0-afa4-f1924ff85219"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", 
  RowBox[{"OrderOfGroup", "[", "RubikSGS2", "]"}]}]], "Input",
 CellLabel->
  "In[163]:=",ExpressionUUID->"b6f76842-e112-41df-8dec-4537165fa0f7"],

Cell[BoxData["43252003274489856000"], "Output",
 CellLabel->
  "Out[163]=",ExpressionUUID->"908267ef-83da-4efd-ae15-8152333a7602"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "order", "]"}]], "Input",
 CellLabel->
  "In[164]:=",ExpressionUUID->"ff2c792e-16b9-4047-9d9f-c1caf41204e8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->
  "Out[164]=",ExpressionUUID->"4a0d789d-f1bf-448a-bc65-31d57022f54e"]
}, Open  ]],

Cell["Orders of the chain of stabilizers:", "MathCaption",ExpressionUUID->"4e6804a2-7553-4040-8e18-14b5e44b4e73"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RubikSGS2Chain", "=", 
   RowBox[{"StabilizerChain", "[", "RubikSGS2", "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[165]:=",ExpressionUUID->"fbf6416c-f49e-4082-bf6f-8f7d701d905b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "/@", "RubikSGS2Chain"}]], "Input",
 CellLabel->
  "In[166]:=",ExpressionUUID->"68d0da33-4839-401c-b14f-0325a1884f7c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "43252003274489856000", ",", "1802166803103744000", ",", 
   "85817466814464000", ",", "4767637045248000", ",", "317842469683200", ",", 
   "13243436236800", ",", "601974374400", ",", "50164531200", ",", 
   "2508226560", ",", "278691840", ",", "15482880", ",", "967680", ",", 
   "161280", ",", "11520", ",", "960", ",", "96", ",", "12", ",", "2", ",", 
   "1"}], "}"}]], "Output",
 CellLabel->
  "Out[166]=",ExpressionUUID->"269e666f-2b21-44e5-bcc1-8855ea892e79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"basicindices", "=", 
  RowBox[{"Drop", "[", 
   RowBox[{
    RowBox[{"%", "/", 
     RowBox[{"RotateLeft", "[", "%", "]"}]}], ",", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[167]:=",ExpressionUUID->"334d1b3b-64c1-48f5-8997-27d21e7bdc1e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "24", ",", "21", ",", "18", ",", "15", ",", "24", ",", "22", ",", "12", ",",
    "20", ",", "9", ",", "18", ",", "16", ",", "6", ",", "14", ",", "12", ",",
    "10", ",", "8", ",", "6", ",", "2"}], "}"}]], "Output",
 CellLabel->
  "Out[167]=",ExpressionUUID->"eece891a-35d0-4720-9458-b3ee0fa73629"]
}, Open  ]],

Cell["Now we can check potential configurations:", "Text",ExpressionUUID->"98d93f9b-ae0d-4539-a07b-8c3700654884"],

Cell["\<\
A rotation in a single corner or the exchange of two side-neighbours are not \
possible:\
\>", "MathCaption",ExpressionUUID->"34ef6cce-946c-408a-897f-9a67daff4a86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"8", ",", "15", ",", "14"}], "}"}], "]"}], ",", "RubikSGS"}], 
  "]"}]], "Input",
 CellLabel->
  "In[168]:=",ExpressionUUID->"f066e5c1-b4d4-4eb8-8f50-6883f7d7f42e"],

Cell[BoxData["False"], "Output",
 CellLabel->
  "Out[168]=",ExpressionUUID->"c430de6f-4b0d-4a99-b7d3-c383d52ffeda"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{"10", ",", "4"}], "}"}], "]"}], ",", "RubikSGS"}], 
  "]"}]], "Input",
 CellLabel->
  "In[169]:=",ExpressionUUID->"70cc7689-8fdb-4c81-8534-cbf89050076a"],

Cell[BoxData["False"], "Output",
 CellLabel->
  "Out[169]=",ExpressionUUID->"fddb53bd-e57d-450c-8e5a-08ce8f7c3244"]
}, Open  ]],

Cell["But pairs of them are allowed, in adequate directions:", "MathCaption",ExpressionUUID->"9b036c4b-7977-4601-91c2-bf69abffbe74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "13"}], "}"}]}], "]"}], ",", "RubikSGS"}], 
  "]"}]], "Input",
 CellLabel->
  "In[170]:=",ExpressionUUID->"66bc3e89-2338-47fb-8a48-69ee275a4bb5"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[170]=",ExpressionUUID->"9b1f9d73-1a64-450a-ae3f-2627081a3211"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "15", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"24", ",", "41", ",", "38"}], "}"}]}], "]"}], ",", "RubikSGS"}],
   "]"}]], "Input",
 CellLabel->
  "In[171]:=",ExpressionUUID->"b1e3a0a4-b565-4405-8ab5-898899e51b4e"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[171]=",ExpressionUUID->"245283e8-75f7-48c5-95bf-ec51a77a5bbb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "15", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"24", ",", "38", ",", "41"}], "}"}]}], "]"}], ",", "RubikSGS"}],
   "]"}]], "Input",
 CellLabel->
  "In[172]:=",ExpressionUUID->"32043480-8c13-4d6a-9e7a-dba6891b55be"],

Cell[BoxData["False"], "Output",
 CellLabel->
  "Out[172]=",ExpressionUUID->"66021e52-8b96-47b8-afa5-648131ef57e6"]
}, Open  ]],

Cell["A combination of both is impossible:", "MathCaption",ExpressionUUID->"b3d5060f-267c-42c6-8bfe-1190113715e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "15", ",", "14"}], "}"}]}], "]"}], ",", "RubikSGS"}], 
  "]"}]], "Input",
 CellLabel->
  "In[173]:=",ExpressionUUID->"21be3a81-715b-43c6-a88f-4bf26beb5c6f"],

Cell[BoxData["False"], "Output",
 CellLabel->
  "Out[173]=",ExpressionUUID->"30e616dd-e86d-4bb1-ad2c-44fdcd7d5621"]
}, Open  ]],

Cell["\<\
There is the famous question on the minimum number of moves which allows \
solving any configuration of the Rubik cube. Here it is very important to \
distinguish between face turns and quarter turns. An f-turn can be equal to \
one or two q-turns depending on the case. In what follows we only consider \
q-turns. There is a simple lower bound to the minimum number of q-turns \
required to solve any configuration, obtained by branching over 7 \
possibilities (the identity and the six rotations) that number of times: 24\
\>", "Text",ExpressionUUID->"537bc1ab-9c54-4e7d-8bb1-8f20cab147d2"],

Cell["\<\
24 is the first power of 7 which is larger than the order of the group:\
\>", "MathCaption",ExpressionUUID->"a45b2f9a-e3d7-4f03-bbd9-9284cefcef95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"order", "/", 
   RowBox[{"7", "^", "24"}]}], "//", "N"}]], "Input",
 CellLabel->
  "In[174]:=",ExpressionUUID->"f91ff741-8bdd-470f-bf7d-48c930bb58f7"],

Cell[BoxData["0.2257632595991198`"], "Output",
 CellLabel->
  "Out[174]=",ExpressionUUID->"0986f33f-76ea-41bf-acb2-de3eb6088c9f"]
}, Open  ]],

Cell["The superflip position requires 24 moves (see wikipedia):", \
"MathCaption",ExpressionUUID->"eeafce63-8500-45ca-86ba-bacde2ab904f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"superflip", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "47"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "44"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "36"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"45", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"42", ",", "39"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "37"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[175]:=",ExpressionUUID->"de9c4b9f-ea48-4474-b4e4-676d0202425f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{"superflip", ",", "RubikSGS2"}], "]"}]], "Input",
 CellLabel->
  "In[176]:=",ExpressionUUID->"ab8dd423-b146-4822-a1f4-5794f8ea0291"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[176]=",ExpressionUUID->"6c4c313a-a6cd-4993-824b-5061903fe487"]
}, Open  ]],

Cell["\<\
Interestingly, this is the only nontrivial permutation which commutes with \
every other permutation in the Rubik group:\
\>", "MathCaption",ExpressionUUID->"17868b2a-9dd7-4ea3-af3c-74880ff0968a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermEqual", "[", 
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"superflip", ",", "rot1", ",", "superflip"}], "]"}], ",", 
   "rot1"}], "]"}]], "Input",
 CellLabel->
  "In[177]:=",ExpressionUUID->"5a965e29-c56f-4e7e-bdd8-08efa8a1206e"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[177]=",ExpressionUUID->"533e989a-d4dc-4c2c-95fc-e0898e37cdcf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermEqual", "[", 
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"superflip", ",", "rot2", ",", "superflip"}], "]"}], ",", 
   "rot2"}], "]"}]], "Input",
 CellLabel->
  "In[178]:=",ExpressionUUID->"5f0001fe-69b9-43d2-9096-b82be7ce77e0"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[178]=",ExpressionUUID->"3ff8f6c3-8a55-47d6-979d-576bb13dd63a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermEqual", "[", 
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"superflip", ",", "rot3", ",", "superflip"}], "]"}], ",", 
   "rot3"}], "]"}]], "Input",
 CellLabel->
  "In[179]:=",ExpressionUUID->"527a34c5-7e89-4b25-aea3-d7ee8724988a"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[179]=",ExpressionUUID->"34b0e4fc-4b92-47dd-b9e4-0b2c4ebbacc5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermEqual", "[", 
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"superflip", ",", "rot4", ",", "superflip"}], "]"}], ",", 
   "rot4"}], "]"}]], "Input",
 CellLabel->
  "In[180]:=",ExpressionUUID->"eaa67740-dd1a-44c8-9588-9a51265bb506"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[180]=",ExpressionUUID->"af7475e8-626c-4b50-9bca-40caed37df02"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermEqual", "[", 
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"superflip", ",", "rot5", ",", "superflip"}], "]"}], ",", 
   "rot5"}], "]"}]], "Input",
 CellLabel->
  "In[181]:=",ExpressionUUID->"a40a993f-5694-4193-99cc-4afcf3dbf5b8"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[181]=",ExpressionUUID->"38a0b183-f9cc-4b15-9411-667a79d4d020"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermEqual", "[", 
  RowBox[{
   RowBox[{"PermProduct", "[", 
    RowBox[{"superflip", ",", "rot6", ",", "superflip"}], "]"}], ",", 
   "rot6"}], "]"}]], "Input",
 CellLabel->
  "In[182]:=",ExpressionUUID->"1e574a56-5d79-4a6a-83db-de3d20abadf4"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[182]=",ExpressionUUID->"59c8b972-522b-4422-8824-a5e20d463bdf"]
}, Open  ]],

Cell["A position requiring 26 q-turns is known.", "MathCaption",ExpressionUUID->"7deea22c-aa03-4cfd-8258-d8a1a92243e6"],

Cell["\<\
Another frequent question whether a SGS can be used to actually solve an \
arbitrary configuration of the Rubik cube and the answer is of course \
positive. The algorithm PermWord can decompose any configuration in a product \
of 19 coset representatives, but then we need to decompose each of those 19 \
representatives in terms of the original 6 rotations. The final algorithm is, \
however, far from optimal, and actually very simple \"human\" algorithms \
perform better than this.\
\>", "Text",ExpressionUUID->"d0764290-11b0-4100-a434-2b9deffe56e8"],

Cell["There are 239 possible nontrivial coset representatives:", "MathCaption",ExpressionUUID->"4ca0684c-f974-45b1-af0f-b1ba5789c15b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", "basicindices"}], "-", "18"}]], "Input",
 CellLabel->
  "In[183]:=",ExpressionUUID->"2acd102e-777d-44dd-a6a0-c1d6110ab159"],

Cell[BoxData["239"], "Output",
 CellLabel->
  "Out[183]=",ExpressionUUID->"c4ad8da1-962e-423d-95d1-079441eb7b2d"]
}, Open  ]],

Cell["Let us construct the canonical representatives:", "MathCaption",ExpressionUUID->"2cd63d81-5cc4-4687-97c7-72f9608b9557"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"reprs", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"orbit", "=", 
      RowBox[{"Orbit", "[", 
       RowBox[{
        RowBox[{"Rubikbase2", "[", 
         RowBox[{"[", 
          RowBox[{"-", "count"}], "]"}], "]"}], ",", 
        RowBox[{"RubikSGS2Chain", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "count"}], "-", "1"}], ",", "2"}], "]"}], "]"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sorbit", "=", 
      RowBox[{"SchreierOrbit", "[", 
       RowBox[{
        RowBox[{"Rubikbase2", "[", 
         RowBox[{"[", 
          RowBox[{"-", "count"}], "]"}], "]"}], ",", 
        RowBox[{"RubikSGS2Chain", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "count"}], "-", "1"}], ",", "2"}], "]"}], "]"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"reprs", ",", 
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"TraceSchreier", "[", 
            RowBox[{"#", ",", "sorbit"}], "]"}], "&"}], "/@", "orbit"}], ",", 
         "1"}], "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"count", ",", "1", ",", "18"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"reprs", "=", 
   RowBox[{"Flatten", "[", "reprs", "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[184]:=",ExpressionUUID->"68a37083-607c-4b6d-97c2-7c3961acf76a"],

Cell["\<\
Those moves can be expressed in terms of face turns. For simplicity, we use \
an external solver to do it (we use kociemba.org). This function transforms a \
permutation into a chain of facelets that can be fed to that solver:\
\>", "MathCaption",ExpressionUUID->"d99c0748-3596-40a7-a8fc-1e2542144de7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tochain", "[", "list_", "]"}], ":=", 
  RowBox[{"SymbolJoin", "@@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"list", "[", 
      RowBox[{"[", "41", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "42", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "43", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "44", "]"}], "]"}], ",", "u", ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "45", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "46", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "47", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "48", "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"list", "[", 
      RowBox[{"[", "17", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "23", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "32", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "16", "]"}], "]"}], ",", "r", ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "31", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "15", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "22", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "30", "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"list", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "3", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "4", "]"}], "]"}], ",", "f", ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "5", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "6", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "7", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "8", "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"list", "[", 
      RowBox[{"[", "12", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "13", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "14", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "20", "]"}], "]"}], ",", "d", ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "21", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "27", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "28", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "29", "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"list", "[", 
      RowBox[{"[", "24", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "18", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "9", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "25", "]"}], "]"}], ",", "l", ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "10", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "26", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "19", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "11", "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"list", "[", 
      RowBox[{"[", "40", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "39", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "38", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "37", "]"}], "]"}], ",", "b", ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "36", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "35", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "34", "]"}], "]"}], ",", 
     RowBox[{"list", "[", 
      RowBox[{"[", "33", "]"}], "]"}]}], "}"}]}]}]], "Input",
 CellLabel->
  "In[187]:=",ExpressionUUID->"512dacc8-5f2a-4bf8-a575-5c8aadaca696"],

Cell["For example:", "MathCaption",ExpressionUUID->"be36fd18-4b4f-48e8-ae57-51157474d853"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tochain", "[", 
  RowBox[{"PermuteList", "[", 
   RowBox[{"RubikPoints", ",", 
    RowBox[{"InversePerm", "@", 
     RowBox[{"reprs", "[", 
      RowBox[{"[", "235", "]"}], "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[188]:=",ExpressionUUID->"ab4a5ce5-247f-4311-8b0c-b048c460c46f"],

Cell[BoxData["uuduudurrubbdrrdrdrbbffffffllldddrflllflluflurbbubbbrd"], \
"Output",
 CellLabel->
  "Out[188]=",ExpressionUUID->"5be8592e-d90f-41e2-9b84-da631b344ab5"]
}, Open  ]],

Cell["\<\
and relate them with the collections of face-turns that we have previously \
stored in a file:\
\>", "MathCaption",ExpressionUUID->"32da9bf1-7451-4869-b788-a01201f94254"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"RubikFaceTurns", "=", 
    RowBox[{"<<", "\"\<data/RubikFaceTurns\>\""}]}], ")"}], "//", 
  "ColumnForm"}]], "Input",
 CellLabel->
  "In[189]:=",ExpressionUUID->"4f042705-c403-47eb-9a8b-c45ca71bc573"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   PanelBox[GridBox[{
      {
       StyleBox[
        StyleBox[
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
           StandardForm],
          ImageSizeCache->{280., {2., 8.}}],
         StripOnInput->False,
         DynamicUpdating->True], "Panel",
        StripOnInput->False,
        Background->None]},
      {
       ItemBox[
        TagBox[
         RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}],
         Short[#, 5]& ],
        Background->GrayLevel[1],
        BaseStyle->{Deployed -> False},
        Frame->True,
        FrameStyle->GrayLevel[0, 0.2],
        StripOnInput->False]},
      {
       RowBox[{
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
             StandardForm],
            ImageSizeCache->{47., {0., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 189, 29231903181700457306, 5/2],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
             StandardForm],
            ImageSizeCache->{52., {0., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 189, 29231903181700457306, 5 2],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
             StandardForm],
            ImageSizeCache->{39., {0., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 189, 29231903181700457306, Infinity],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
             StandardForm],
            ImageSizeCache->{69., {0., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetOptions[
            FrontEnd`$FrontEnd, 
             FrontEnd`PreferencesSettings -> {"Page" -> "Evaluation"}], 
            FrontEnd`FrontEndToken["PreferencesDialog"]}],
         Evaluator->None,
         Method->"Preemptive"]}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[1.2]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    DefaultBaseStyle->{},
    FrameMargins->5],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  Out[189]]], "Output",
 CellLabel->
  "Out[189]=",ExpressionUUID->"66231311-e3b3-4321-8291-ff7d87865be6"]
}, Open  ]],

Cell["Check that the relations are correct:", "MathCaption",ExpressionUUID->"639c2da5-f19a-4862-b684-2f4c32aaafcd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"And", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"RubikFaceTurns", "/.", 
      RowBox[{"permute", "\[Rule]", "PermProduct"}]}], "/.", "faceturns"}], "/.", 
    RowBox[{"Rule", "\[Rule]", "PermEqual"}]}]}], "]"}]], "Input",
 CellLabel->
  "In[190]:=",ExpressionUUID->"1210471e-52b2-4dee-8be9-b94e4a3169c8"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[190]=",ExpressionUUID->"861b6623-85e3-4c6f-83a8-ee6fef0a7356"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["7.2. Alternating groups", "SubsubsectionIcon",ExpressionUUID->"fe1fa1a5-d94e-49d9-bf99-7fe8e6bc0004"],

Cell["\<\
The alternating group A(n>3), of order n!/2, can be generated using two \
permutaions of degree n. They are always\
\>", "Text",ExpressionUUID->"8f4c9552-43f4-4753-a5ce-090322aa4f5b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AltGS", "[", "n_", "]"}], ":=", 
  RowBox[{"GenSet", "[", 
   RowBox[{
    RowBox[{"Cycles", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
    RowBox[{"Cycles", "[", 
     RowBox[{"Range", "[", 
      RowBox[{"2", ",", "n"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[191]:=",ExpressionUUID->"e2207b85-f03d-4296-a423-7b2ecff66dbf"],

Cell["\<\
The largest alternating group explicitly described in the Atlas is A(14):\
\>", "MathCaption",ExpressionUUID->"de1cc188-3c85-48a0-824c-4e4b83692864"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"A14SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"AltGS", "[", "14", "]"}], ",", "14"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[192]:=",ExpressionUUID->"b484aff8-21b7-4294-b149-6bde464bd46d"],

Cell[BoxData[
 RowBox[{"0.008892`4.099514451858947", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[192]:=",ExpressionUUID->"922929de-e827-4706-8de5-72109448fbcb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "A14SGS"}]], "Input",
 CellLabel->
  "In[193]:=",ExpressionUUID->"2b29e6f6-d61a-43e0-9339-2c585f46f85a"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"12", ",", "22"}], "]"}]], "Output",
 CellLabel->
  "Out[193]=",ExpressionUUID->"0065bbec-c3bc-4fbd-b90d-773255e14caa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "A14SGS", "]"}]], "Input",
 CellLabel->
  "In[194]:=",ExpressionUUID->"c2641da1-06c8-4585-8a93-46c725ec13ba"],

Cell[BoxData["43589145600"], "Output",
 CellLabel->
  "Out[194]=",ExpressionUUID->"8f7ab3d0-50ad-48b5-b8ad-82d71fd809a4"]
}, Open  ]],

Cell[TextData[{
 "With ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " we can manipulate within seconds groups which are much larger"
}], "MathCaption",ExpressionUUID->"6884c724-1ea5-4b33-9e8f-01a9aa383b55"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"A30SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"AltGS", "[", "30", "]"}], ",", "30"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[195]:=",ExpressionUUID->"6e7fde8f-6422-4559-848b-440b28afe60d"],

Cell[BoxData[
 RowBox[{"0.561066`5.899528949551352", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[195]:=",ExpressionUUID->"061aeed8-1201-41dd-8426-b2c6c54a8188"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "A30SGS"}]], "Input",
 CellLabel->
  "In[196]:=",ExpressionUUID->"4a171603-d5df-4600-b092-b6a9a4041361"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"28", ",", "54"}], "]"}]], "Output",
 CellLabel->
  "Out[196]=",ExpressionUUID->"2392e6ac-38ad-4f77-a0da-a02c0b3f8736"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "A30SGS", "]"}]], "Input",
 CellLabel->
  "In[197]:=",ExpressionUUID->"141d01e4-36b8-4113-90ba-eef75c7ca06c"],

Cell[BoxData["132626429906095529318154240000000"], "Output",
 CellLabel->
  "Out[197]=",ExpressionUUID->"1690ca9f-07bf-4912-bc2e-6a6ad0031962"]
}, Open  ]],

Cell["Going further takes longer:", "MathCaption",ExpressionUUID->"86aca13a-2f16-4c8b-9cda-6ff036f92b78"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"A50SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"AltGS", "[", "50", "]"}], ",", "50"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[198]:=",ExpressionUUID->"85e1cb96-1dfc-4cef-b322-898eb7a45b06"],

Cell[BoxData[
 RowBox[{"17.472194`7.392862441009896", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[198]:=",ExpressionUUID->"feccb648-66e1-4b0f-94d5-88e100a2712a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "A50SGS"}]], "Input",
 CellLabel->
  "In[199]:=",ExpressionUUID->"8eda8ff5-e1a3-4b31-b2f4-d97e34da77b3"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"48", ",", "94"}], "]"}]], "Output",
 CellLabel->
  "Out[199]=",ExpressionUUID->"b954e351-b8b3-48fa-9397-37f8aef91b77"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "A50SGS", "]"}]], "Input",
 CellLabel->
  "In[200]:=",ExpressionUUID->"0a210c92-4113-4ef5-bfa6-3de2a63bd698"],

Cell[BoxData[\
"15207046600856689021806304083032384422188820784480256000000000000"], "Output",\

 CellLabel->
  "Out[200]=",ExpressionUUID->"b2bdc890-4a56-4ab6-a3db-d07b7e5577e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "N"}]], "Input",
 CellLabel->
  "In[201]:=",ExpressionUUID->"328acddc-a1d3-4600-b316-818f8c2482b4"],

Cell[BoxData["1.5207046600856688`*^64"], "Output",
 CellLabel->
  "Out[201]=",ExpressionUUID->"4a1cd7f0-5e8a-442b-8ffa-fa07f16744c7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["7.2. Some \"small\" sporadic simple groups", "SubsubsectionIcon",ExpressionUUID->"d6a0468b-051a-4404-bdd7-6370a51b967c"],

Cell["\<\
As further examples of manipulation of nontrivial finite groups, here you \
find the construction of strong generating sets for some of the 26 sporadic \
simple groups:\
\>", "Text",ExpressionUUID->"6a27bf49-ef7d-4121-91da-b4b3ab0bc9a2"],

Cell["\<\
M24 is the largest of the five sporadic simple Mathieu groups, with a \
permutation representation of degree 24. It was found by Mathieu in 1873. \
Frobenious showed that the other four simple Mathieu groups (M11, M12, M22, \
M23) are subgroups of M24.\
\>", "MathCaption",ExpressionUUID->"b25108ec-833f-434e-9270-358aacaad31b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "4", ",", "7", ",", "17", ",", "1", ",", "13", ",", "9", ",", "2", ",", 
      "15", ",", "6", ",", "19", ",", "18", ",", "21", ",", "5", ",", "16", 
      ",", "8", ",", "14", ",", "3", ",", "11", ",", "10", ",", "24", ",", 
      "12", ",", "23", ",", "22", ",", "20"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "4", ",", "21", ",", "9", ",", "6", ",", "18", ",", "1", ",", "7", ",", 
      "8", ",", "15", ",", "5", ",", "11", ",", "12", ",", "17", ",", "2", 
      ",", "3", ",", "13", ",", "16", ",", "10", ",", "24", ",", "20", ",", 
      "14", ",", "22", ",", "19", ",", "23"}], "}"}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->
  "In[202]:=",ExpressionUUID->"d8d42f8b-5990-4d32-8630-91296e180e89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[204]:=",ExpressionUUID->"0ff804ca-810a-47ba-8147-39beb108248c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"24", ",", "24"}], "}"}]], "Output",
 CellLabel->
  "Out[204]=",ExpressionUUID->"ec51358a-8d0f-4e51-877e-1aa8948cbe3a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"Mathieu24SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "24"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[205]:=",ExpressionUUID->"08054c5e-9b8b-4bc9-a638-51b037ea071f"],

Cell[BoxData[
 RowBox[{"0.007462`4.023370242536805", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[205]:=",ExpressionUUID->"b54ca770-3ff9-4f75-95d1-2107510273ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "Mathieu24SGS"}]], "Input",
 CellLabel->
  "In[206]:=",ExpressionUUID->"8432be84-264e-460b-9c00-e7dcc8aa7081"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"7", ",", "13"}], "]"}]], "Output",
 CellLabel->
  "Out[206]=",ExpressionUUID->"62cc17f8-b4d0-45cd-9ae3-4d8a335d5a60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "Mathieu24SGS", "]"}]], "Input",
 CellLabel->
  "In[207]:=",ExpressionUUID->"91286954-7f32-4dbb-bc54-fdf70f222062"],

Cell[BoxData["244823040"], "Output",
 CellLabel->
  "Out[207]=",ExpressionUUID->"071fded8-c4d9-43ef-a939-fd0e0788280d"]
}, Open  ]],

Cell["\<\
The sixth sporadic simple group was discovered by Z. Janko in 1965 and it is \
called Janko1. It can be given in terms of a permutation representation of \
degree 266:\
\>", "MathCaption",ExpressionUUID->"c3bcd8c0-a6b5-446d-92ca-68b99c0c91bb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "262"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "107"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "213"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "191"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "22"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "133"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "234"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "232"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "151"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "139"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "176"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "202"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "253"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "222"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "195"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "206"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"19", ",", "68"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "55"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "179"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"24", ",", "217"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "216"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "256"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"27", ",", "87"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "70"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"29", ",", "131"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "44"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "105"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"32", ",", "170"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"33", ",", "77"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"34", ",", "104"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"35", ",", "198"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"36", ",", "137"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"37", ",", "243"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"38", ",", "56"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"39", ",", "124"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "223"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"41", ",", "134"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"43", ",", "174"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"46", ",", "51"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"47", ",", "128"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"48", ",", "94"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"49", ",", "250"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "264"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"52", ",", "183"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"53", ",", "231"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"54", ",", "115"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"57", ",", "85"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"58", ",", "233"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"59", ",", "261"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"60", ",", "95"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"61", ",", "235"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"62", ",", "177"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"63", ",", "249"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"64", ",", "91"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"65", ",", "247"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"66", ",", "155"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"69", ",", "219"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"71", ",", "237"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"72", ",", "211"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"73", ",", "84"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"74", ",", "192"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"75", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"76", ",", "251"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"79", ",", "260"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "112"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"81", ",", "193"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"82", ",", "156"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"83", ",", "242"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"86", ",", "238"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"88", ",", "143"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"89", ",", "168"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"90", ",", "148"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"92", ",", "119"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"93", ",", "212"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"96", ",", "150"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"97", ",", "199"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"98", ",", "140"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"99", ",", "189"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "180"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"101", ",", "147"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"102", ",", "111"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"103", ",", "159"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"106", ",", "162"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"108", ",", "194"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"109", ",", "166"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"110", ",", "200"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"113", ",", "120"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"114", ",", "141"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"116", ",", "182"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"117", ",", "181"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"118", ",", "225"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"121", ",", "254"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"122", ",", "125"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"123", ",", "146"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"126", ",", "208"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"127", ",", "221"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"129", ",", "210"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"132", ",", "255"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"136", ",", "175"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"138", ",", "207"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"142", ",", "240"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"144", ",", "172"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"145", ",", "185"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"149", ",", "224"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"152", ",", "169"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"153", ",", "241"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"154", ",", "190"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"157", ",", "214"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"158", ",", "161"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"160", ",", "236"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"163", ",", "239"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"164", ",", "229"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"165", ",", "230"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"167", ",", "188"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"171", ",", "258"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"173", ",", "186"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"178", ",", "245"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"184", ",", "205"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"187", ",", "228"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"197", ",", "203"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"201", ",", "252"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"209", ",", "248"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"215", ",", "259"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"218", ",", "246"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"220", ",", "227"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"257", ",", "263"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"265", ",", "266"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "146", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "132", ",", "82"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "156", ",", "166"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "242", ",", "253"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "107", ",", "28"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "125", ",", "76"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "245", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "174", ",", "42"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "241", ",", "244"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "264", ",", "63"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "248", ",", "234"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "36", ",", "44"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "116", ",", "128"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "47", ",", "25"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"16", ",", "178", ",", "112"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "170", ",", "110"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "197", ",", "74"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"19", ",", "233", ",", "180"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "121", ",", "96"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"22", ",", "228", ",", "155"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "48", ",", "173"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"24", ",", "201", ",", "187"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "136", ",", "190"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"27", ",", "212", ",", "94"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"29", ",", "175", ",", "52"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "77", ",", "32"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "237", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"33", ",", "226", ",", "90"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"35", ",", "129", ",", "54"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"37", ",", "161", ",", "114"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"38", ",", "232", ",", "87"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"39", ",", "219", ",", "192"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "78", ",", "159"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"41", ",", "139", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"43", ",", "211", ",", "251"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"45", ",", "222", ",", "240"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"46", ",", "97", ",", "135"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"49", ",", "70", ",", "131"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "153", ",", "200"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"51", ",", "186", ",", "209"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"53", ",", "203", ",", "216"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"55", ",", "169", ",", "64"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"56", ",", "140", ",", "230"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"57", ",", "260", ",", "118"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"58", ",", "91", ",", "243"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"59", ",", "199", ",", "227"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"60", ",", "108", ",", "164"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"61", ",", "208", ",", "101"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"62", ",", "206", ",", "106"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"65", ",", "103", ",", "66"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"67", ",", "95", ",", "205"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"68", ",", "73", ",", "225"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"69", ",", "151", ",", "113"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"72", ",", "221", ",", "152"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"75", ",", "143", ",", "202"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"79", ",", "217", ",", "254"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "93", ",", "122"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"81", ",", "181", ",", "252"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"83", ",", "258", ",", "126"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"84", ",", "163", ",", "177"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"85", ",", "154", ",", "213"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"86", ",", "182", ",", "196"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"88", ",", "133", ",", "215"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"89", ",", "117", ",", "247"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"92", ",", "191", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"99", ",", "229", ",", "263"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "138", ",", "188"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"102", ",", "194", ",", "157"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"105", ",", "149", ",", "184"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"109", ",", "123", ",", "193"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"111", ",", "137", ",", "183"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"115", ",", "238", ",", "235"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"119", ",", "167", ",", "147"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"120", ",", "134", ",", "189"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"124", ",", "185", ",", "265"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"127", ",", "218", ",", "261"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"141", ",", "231", ",", "210"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"142", ",", "239", ",", "236"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"144", ",", "224", ",", "249"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"145", ",", "158", ",", "220"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"148", ",", "214", ",", "172"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"150", ",", "250", ",", "259"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"162", ",", "257", ",", "256"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"165", ",", "179", ",", "246"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"176", ",", "195", ",", "266"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"198", ",", "204", ",", "207"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"223", ",", "262", ",", "255"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->
  "In[208]:=",ExpressionUUID->"567c199f-ff7d-48e3-889e-f7d46de47823"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[210]:=",ExpressionUUID->"ac3305e3-bcd2-4e1f-9ebf-b469f3d40206"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"266", ",", "266"}], "}"}]], "Output",
 CellLabel->
  "Out[210]=",ExpressionUUID->"4162f6b3-22fa-429a-b04f-7e3f0c2f4ba8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"Janko1SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "266"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[211]:=",ExpressionUUID->"32feac64-30b3-4a8c-b645-59125f044c28"],

Cell[BoxData[
 RowBox[{"0.088746`5.098663785282208", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[211]:=",ExpressionUUID->"b3dda9b7-932d-4c7e-a737-e8fe3f6a7646"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "Janko1SGS"}]], "Input",
 CellLabel->
  "In[212]:=",ExpressionUUID->"663bd295-e425-4c52-88d8-92cee075bca1"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"3", ",", "7"}], "]"}]], "Output",
 CellLabel->
  "Out[212]=",ExpressionUUID->"882ccd7a-0b05-4db5-b222-42eb7ce9aadb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "Janko1SGS", "]"}]], "Input",
 CellLabel->
  "In[213]:=",ExpressionUUID->"45b91b24-b5aa-4ade-a316-2a66099dcd3a"],

Cell[BoxData["175560"], "Output",
 CellLabel->
  "Out[213]=",ExpressionUUID->"6d2303b7-8946-4dd0-bce1-c6eba9037491"]
}, Open  ]],

Cell["\<\
The Janko2 group can be given in terms of a permutation representation of \
degree 100:\
\>", "MathCaption",ExpressionUUID->"84b22a90-8829-49e2-a674-18f620358b68"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "84"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "48"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "56"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "82"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "67"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "55"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "35"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "78"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "49"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "37"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "94"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"16", ",", "76"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "44"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"22", ",", "85"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "92"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"24", ",", "57"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "75"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "28"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"27", ",", "64"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"29", ",", "90"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "97"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "38"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"32", ",", "68"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"33", ",", "69"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"36", ",", "53"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"39", ",", "61"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"42", ",", "73"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"43", ",", "91"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"45", ",", "86"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"46", ",", "81"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"47", ",", "89"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "93"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"51", ",", "96"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"52", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"54", ",", "74"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"58", ",", "99"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"59", ",", "95"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"60", ",", "63"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"62", ",", "83"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"65", ",", "70"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"66", ",", "88"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"71", ",", "87"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"77", ",", "98"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"79", ",", "80"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "80", ",", "22"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "9", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "53", ",", "87"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "23", ",", "78"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "51", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "37", ",", "24"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "27", ",", "60"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "62", ",", "47"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "65", ",", "31"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "64", ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "61", ",", "52"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "98", ",", "25"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"16", ",", "73", ",", "32"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "39", ",", "33"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "97", ",", "58"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "96", ",", "67"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "93", ",", "99"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "57", ",", "35"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"29", ",", "71", ",", "55"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "69", ",", "45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"34", ",", "86", ",", "82"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"38", ",", "59", ",", "94"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "43", ",", "91"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"42", ",", "68", ",", "44"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"46", ",", "85", ",", "89"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"48", ",", "76", ",", "90"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"49", ",", "92", ",", "77"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "66", ",", "88"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"54", ",", "95", ",", "56"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"63", ",", "74", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"70", ",", "81", ",", "75"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"79", ",", "100", ",", "83"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->
  "In[214]:=",ExpressionUUID->"37a479bc-b8cf-413c-91ce-175b8df6c429"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[216]:=",ExpressionUUID->"4d22824e-2d5a-4a14-9451-9d301ca3df43"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "100"}], "}"}]], "Output",
 CellLabel->
  "Out[216]=",ExpressionUUID->"17067c77-0ee5-4fe2-89be-530a93d7be03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"Janko2SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "100"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[217]:=",ExpressionUUID->"d311cdf5-4748-4cb2-b5ed-b67bdc2057cf"],

Cell[BoxData[
 RowBox[{"0.018182`4.410156651260855", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[217]:=",ExpressionUUID->"60ff3032-4d7a-4c35-9e56-5519acf2f067"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "Janko2SGS"}]], "Input",
 CellLabel->
  "In[218]:=",ExpressionUUID->"3e8da662-5a77-4ec4-8877-670b31100a4d"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"4", ",", "8"}], "]"}]], "Output",
 CellLabel->
  "Out[218]=",ExpressionUUID->"20286807-278e-4b19-a1ad-c79176f51765"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "Janko2SGS", "]"}]], "Input",
 CellLabel->
  "In[219]:=",ExpressionUUID->"bad8bde1-bfa9-4832-98dd-936352b3ec93"],

Cell[BoxData["604800"], "Output",
 CellLabel->
  "Out[219]=",ExpressionUUID->"8b9f82fd-c1d6-401f-8c9b-b569c678920d"]
}, Open  ]],

Cell["\<\
This is the smallest of the three sporadic simple Conway groups, with a \
permutation representation of degree 276:\
\>", "MathCaption",ExpressionUUID->"c2732ed5-0e3b-4c50-ab80-02a63c6194fa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "245", ",", "42", ",", "112", ",", "15", ",", "131", ",", "7", ",", 
      "188", ",", "75", ",", "132", ",", "10", ",", "11", ",", "187", ",", 
      "186", ",", "265", ",", "22", ",", "159", ",", "256", ",", "43", ",", 
      "101", ",", "123", ",", "134", ",", "4", ",", "32", ",", "209", ",", 
      "238", ",", "35", ",", "45", ",", "235", ",", "126", ",", "5", ",", 
      "19", ",", "60", ",", "66", ",", "80", ",", "154", ",", "251", ",", 
      "117", ",", "206", ",", "71", ",", "118", ",", "93", ",", "87", ",", 
      "167", ",", "271", ",", "221", ",", "261", ",", "182", ",", "155", ",", 
      "47", ",", "230", ",", "172", ",", "236", ",", "109", ",", "191", ",", 
      "76", ",", "156", ",", "73", ",", "116", ",", "147", ",", "23", ",", 
      "127", ",", "231", ",", "38", ",", "53", ",", "122", ",", "210", ",", 
      "24", ",", "68", ",", "86", ",", "255", ",", "196", ",", "139", ",", 
      "149", ",", "21", ",", "111", ",", "203", ",", "252", ",", "72", ",", 
      "262", ",", "114", ",", "214", ",", "9", ",", "181", ",", "174", ",", 
      "85", ",", "95", ",", "2", ",", "250", ",", "257", ",", "243", ",", 
      "90", ",", "158", ",", "170", ",", "148", ",", "69", ",", "105", ",", 
      "249", ",", "263", ",", "16", ",", "54", ",", "31", ",", "115", ",", 
      "51", ",", "104", ",", "125", ",", "219", ",", "92", ",", "46", ",", 
      "64", ",", "204", ",", "8", ",", "266", ",", "225", ",", "34", ",", 
      "175", ",", "145", ",", "161", ",", "180", ",", "237", ",", "241", ",", 
      "224", ",", "169", ",", "269", ",", "12", ",", "96", ",", "129", ",", 
      "189", ",", "190", ",", "29", ",", "17", ",", "30", ",", "82", ",", 
      "143", ",", "74", ",", "168", ",", "13", ",", "227", ",", "217", ",", 
      "78", ",", "258", ",", "220", ",", "178", ",", "228", ",", "146", ",", 
      "58", ",", "254", ",", "273", ",", "215", ",", "57", ",", "106", ",", 
      "77", ",", "110", ",", "50", ",", "26", ",", "248", ",", "260", ",", 
      "274", ",", "107", ",", "99", ",", "253", ",", "37", ",", "25", ",", 
      "272", ",", "44", ",", "52", ",", "119", ",", "18", ",", "201", ",", 
      "65", ",", "41", ",", "233", ",", "103", ",", "246", ",", "200", ",", 
      "102", ",", "160", ",", "198", ",", "207", ",", "157", ",", "40", ",", 
      "223", ",", "49", ",", "267", ",", "79", ",", "1", ",", "136", ",", 
      "124", ",", "6", ",", "61", ",", "268", ",", "100", ",", "70", ",", 
      "98", ",", "171", ",", "121", ",", "39", ",", "62", ",", "211", ",", 
      "208", ",", "84", ",", "135", ",", "97", ",", "55", ",", "152", ",", 
      "141", ",", "63", ",", "142", ",", "259", ",", "67", ",", "33", ",", 
      "177", ",", "173", ",", "14", ",", "242", ",", "94", ",", "113", ",", 
      "240", ",", "264", ",", "150", ",", "205", ",", "27", ",", "183", ",", 
      "83", ",", "195", ",", "216", ",", "163", ",", "247", ",", "133", ",", 
      "36", ",", "153", ",", "197", ",", "140", ",", "194", ",", "120", ",", 
      "270", ",", "165", ",", "166", ",", "162", ",", "218", ",", "138", ",", 
      "234", ",", "81", ",", "91", ",", "89", ",", "185", ",", "212", ",", 
      "137", ",", "48", ",", "202", ",", "276", ",", "229", ",", "151", ",", 
      "176", ",", "144", ",", "192", ",", "130", ",", "244", ",", "232", ",", 
      "199", ",", "56", ",", "108", ",", "184", ",", "193", ",", "239", ",", 
      "213", ",", "3", ",", "222", ",", "128", ",", "20", ",", "28", ",", 
      "164", ",", "226", ",", "59", ",", "179", ",", "275", ",", "88"}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "204", ",", "203", ",", "33", ",", "236", ",", "5", ",", "172", ",", 
      "77", ",", "76", ",", "47", ",", "146", ",", "133", ",", "224", ",", 
      "229", ",", "53", ",", "84", ",", "16", ",", "223", ",", "228", ",", 
      "130", ",", "131", ",", "252", ",", "190", ",", "13", ",", "263", ",", 
      "242", ",", "10", ",", "32", ",", "196", ",", "199", ",", "65", ",", 
      "246", ",", "209", ",", "40", ",", "99", ",", "241", ",", "198", ",", 
      "269", ",", "251", ",", "75", ",", "118", ",", "176", ",", "271", ",", 
      "183", ",", "116", ",", "197", ",", "238", ",", "22", ",", "29", ",", 
      "178", ",", "26", ",", "174", ",", "129", ",", "2", ",", "153", ",", 
      "272", ",", "257", ",", "41", ",", "12", ",", "59", ",", "20", ",", 
      "27", ",", "175", ",", "106", ",", "159", ",", "218", ",", "259", ",", 
      "137", ",", "258", ",", "261", ",", "164", ",", "262", ",", "189", ",", 
      "45", ",", "177", ",", "260", ",", "85", ",", "25", ",", "15", ",", 
      "226", ",", "96", ",", "24", ",", "1", ",", "274", ",", "148", ",", 
      "264", ",", "132", ",", "48", ",", "117", ",", "36", ",", "60", ",", 
      "171", ",", "201", ",", "101", ",", "253", ",", "95", ",", "120", ",", 
      "142", ",", "213", ",", "165", ",", "51", ",", "115", ",", "44", ",", 
      "103", ",", "167", ",", "243", ",", "66", ",", "141", ",", "108", ",", 
      "88", ",", "97", ",", "276", ",", "30", ",", "139", ",", "222", ",", 
      "166", ",", "173", ",", "231", ",", "3", ",", "73", ",", "239", ",", 
      "56", ",", "170", ",", "82", ",", "162", ",", "163", ",", "207", ",", 
      "145", ",", "128", ",", "52", ",", "104", ",", "90", ",", "216", ",", 
      "220", ",", "155", ",", "74", ",", "237", ",", "28", ",", "4", ",", 
      "113", ",", "273", ",", "230", ",", "270", ",", "248", ",", "180", ",", 
      "206", ",", "50", ",", "250", ",", "78", ",", "127", ",", "150", ",", 
      "54", ",", "232", ",", "217", ",", "121", ",", "69", ",", "156", ",", 
      "6", ",", "125", ",", "210", ",", "86", ",", "89", ",", "46", ",", 
      "184", ",", "211", ",", "265", ",", "93", ",", "19", ",", "138", ",", 
      "23", ",", "126", ",", "43", ",", "188", ",", "102", ",", "244", ",", 
      "219", ",", "192", ",", "256", ",", "83", ",", "58", ",", "144", ",", 
      "181", ",", "187", ",", "91", ",", "158", ",", "205", ",", "235", ",", 
      "147", ",", "157", ",", "114", ",", "9", ",", "152", ",", "57", ",", 
      "39", ",", "64", ",", "143", ",", "67", ",", "119", ",", "161", ",", 
      "87", ",", "200", ",", "111", ",", "79", ",", "14", ",", "123", ",", 
      "21", ",", "149", ",", "122", ",", "191", ",", "61", ",", "194", ",", 
      "266", ",", "225", ",", "31", ",", "81", ",", "62", ",", "160", ",", 
      "151", ",", "112", ",", "215", ",", "254", ",", "234", ",", "72", ",", 
      "17", ",", "179", ",", "105", ",", "267", ",", "227", ",", "18", ",", 
      "169", ",", "249", ",", "109", ",", "208", ",", "275", ",", "68", ",", 
      "233", ",", "168", ",", "55", ",", "124", ",", "80", ",", "240", ",", 
      "35", ",", "7", ",", "212", ",", "100", ",", "245", ",", "98", ",", 
      "195", ",", "247", ",", "107", ",", "182", ",", "42", ",", "185", ",", 
      "94", ",", "11", ",", "255", ",", "135", ",", "154", ",", "221", ",", 
      "63", ",", "193", ",", "134", ",", "71", ",", "214", ",", "8", ",", 
      "34", ",", "70", ",", "202", ",", "268", ",", "37", ",", "110", ",", 
      "38", ",", "136", ",", "140", ",", "49", ",", "186", ",", "92"}], "}"}],
     "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[220]:=",ExpressionUUID->"43372d98-c1a3-438c-b19a-137b8cc496fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[222]:=",ExpressionUUID->"9056373a-181a-41af-ba62-9d0f803289ec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"276", ",", "276"}], "}"}]], "Output",
 CellLabel->
  "Out[222]=",ExpressionUUID->"8a864e1c-16f2-4131-943a-d7804b8a7b0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"Conway3SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "276"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[223]:=",ExpressionUUID->"025a2238-dda5-4e4f-8f09-335226a92152"],

Cell[BoxData[
 RowBox[{"1.019711`6.158992102055315", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[223]:=",ExpressionUUID->"b003fa74-47c3-4dce-926e-0bcc0be5aac4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "Conway3SGS"}]], "Input",
 CellLabel->
  "In[224]:=",ExpressionUUID->"7535d7d2-61b3-4eea-936b-2c8952cd9edc"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"6", ",", "13"}], "]"}]], "Output",
 CellLabel->
  "Out[224]=",ExpressionUUID->"0d83dadd-ddfe-4cf2-9241-e20713a59cfd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "Conway3SGS", "]"}]], "Input",
 CellLabel->
  "In[225]:=",ExpressionUUID->"34f09f1d-a594-463c-9b60-ab886ff44c1b"],

Cell[BoxData["495766656000"], "Output",
 CellLabel->
  "Out[225]=",ExpressionUUID->"9f1afbab-1ecd-4bb5-9961-dbfcf484f230"]
}, Open  ]],

Cell[TextData[{
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " can also handle bigger sporadic groups, but it takes very long, or much \
memory:"
}], "Text",ExpressionUUID->"547e2f93-f281-4d99-a67a-e7ca671e0429"],

Cell["\<\
This is the smallest of the four sporadic simple Fischer groups. It can be \
given in terms of a permutation representation of degree 3510. The \
computation of a SGS requires 400 Mbyte RAM. (The SchreierSims command is \
deactivated; we read the result from a file.)\
\>", "MathCaption",ExpressionUUID->"d0b40a4c-4e8f-47cc-b388-6b24fad3c7a9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"<<", "\"\<data/F22p3510.1\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"<<", "\"\<data/F22p3510.2\>\""}], "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[226]:=",ExpressionUUID->"b996f061-b16b-469e-9d2f-ac5fcf118433"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[228]:=",ExpressionUUID->"f883dff4-3045-48d2-9975-5c00b742216f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3510", ",", "3510"}], "}"}]], "Output",
 CellLabel->
  "Out[228]=",ExpressionUUID->"d88f4600-79f9-475d-be20-ca11ef2b7025"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"Fischer22SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "3510"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[229]:=",ExpressionUUID->"81abbbbe-131e-4af7-a6e4-7d4661592a1f"],

Cell[BoxData[
 RowBox[{"4382.478105`9.792234752854203", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[229]:=",ExpressionUUID->"e0d1f33c-09fe-4317-9184-07613472f17a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"base", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GS", "=", 
   RowBox[{"<<", "\"\<data/Fischer22SGS\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fischer22SGS", "=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{"base", ",", "GS"}], "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[231]:=",ExpressionUUID->"09b9601d-2384-405a-a2ec-900abccf98f1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "Fischer22SGS"}]], "Input",
 CellLabel->
  "In[233]:=",ExpressionUUID->"5d139d05-f6df-410b-92c5-75a08c55bc99"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"5", ",", "18"}], "]"}]], "Output",
 CellLabel->
  "Out[233]=",ExpressionUUID->"560951db-fa10-46e9-8c8c-f58a77257f5f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "Fischer22SGS", "]"}]], "Input",
 CellLabel->
  "In[234]:=",ExpressionUUID->"3266b32c-b6d6-4a21-995e-f5b83e54ba43"],

Cell[BoxData["64561751654400"], "Output",
 CellLabel->
  "Out[234]=",ExpressionUUID->"cbc72091-40b7-4010-a50b-6fdec0af7ecf"]
}, Open  ]],

Cell["\<\
The Janko3 group can be given in terms of a permutation representation of \
degree 6156. This computation requires almost 900 Mbyte of memory:\
\>", "MathCaption",ExpressionUUID->"c1d1b610-967d-4863-b568-32b65e60fa8c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"<<", "\"\<data/J3G1-p6156B0.g1\>\""}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"<<", "\"\<data/J3G1-p6156B0.g2\>\""}]}], ";"}]}], "Input",
 CellLabel->
  "In[235]:=",ExpressionUUID->"e211045a-a6b5-40cf-9f0a-a0c6935dc1a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[237]:=",ExpressionUUID->"17650e83-f8a1-4838-85df-940255f17b0d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6156", ",", "6156"}], "}"}]], "Output",
 CellLabel->
  "Out[237]=",ExpressionUUID->"851969d0-2bd6-4fc8-8a61-d202e41757aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"Janko3SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "6156"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[238]:=",ExpressionUUID->"44cb1bc9-7156-49df-a372-1cd9dd85a62a"],

Cell[BoxData[
 RowBox[{"986.135594`9.144451632527012", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[238]:=",ExpressionUUID->"a294e11d-4170-453e-8040-58d06d790f37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "Janko3SGS"}]], "Input",
 CellLabel->
  "In[239]:=",ExpressionUUID->"e2f59ae1-eed5-4cdf-84a3-74380ba63825"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"3", ",", "7"}], "]"}]], "Output",
 CellLabel->
  "Out[239]=",ExpressionUUID->"a74a7991-824e-479e-b985-5c53c7218c0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "Janko3SGS", "]"}]], "Input",
 CellLabel->
  "In[240]:=",ExpressionUUID->"abbb9546-63f2-4892-a5af-c3a69c064980"],

Cell[BoxData["50232960"], "Output",
 CellLabel->
  "Out[240]=",ExpressionUUID->"f689a4f1-e7d6-4459-8afd-230c72f2b75e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3. Other groups", "SubsubsectionIcon",ExpressionUUID->"e671debd-122a-460d-8f10-9afb40e85408"],

Cell[TextData[{
 "These are groups taken from the Atlas of Finite Group Representations (",
 StyleBox["http://for.mat.bham.ac.uk/atlas/",
  FontFamily->"Courier"],
 "), in the section Miscellaneous Groups."
}], "Text",ExpressionUUID->"34d80ecc-ab26-445a-ad3c-03783210ef26"],

Cell["\<\
This is the exceptional twisted group Sz8 (the Suzuki group), which can be \
given in terms of permutations on 65 points.\
\>", "MathCaption",ExpressionUUID->"f8968092-e402-4a3c-bac6-4f6376ca52d9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "1", ",", "4", ",", "3", ",", "7", ",", "9", ",", "5", ",", 
      "12", ",", "6", ",", "13", ",", "15", ",", "8", ",", "10", ",", "19", 
      ",", "11", ",", "21", ",", "23", ",", "25", ",", "14", ",", "28", ",", 
      "16", ",", "31", ",", "17", ",", "33", ",", "18", ",", "35", ",", "32", 
      ",", "20", ",", "37", ",", "39", ",", "22", ",", "27", ",", "24", ",", 
      "43", ",", "26", ",", "46", ",", "29", ",", "48", ",", "30", ",", "40", 
      ",", "51", ",", "44", ",", "34", ",", "42", ",", "55", ",", "36", ",", 
      "50", ",", "38", ",", "58", ",", "47", ",", "41", ",", "60", ",", "61", 
      ",", "59", ",", "45", ",", "62", ",", "63", ",", "49", ",", "54", ",", 
      "52", ",", "53", ",", "56", ",", "57", ",", "65", ",", "64"}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "5", ",", "6", ",", "8", ",", "10", ",", "11", ",", 
      "1", ",", "12", ",", "14", ",", "16", ",", "17", ",", "18", ",", "4", 
      ",", "20", ",", "22", ",", "24", ",", "26", ",", "27", ",", "29", ",", 
      "30", ",", "7", ",", "32", ",", "9", ",", "34", ",", "36", ",", "31", 
      ",", "19", ",", "38", ",", "40", ",", "28", ",", "41", ",", "42", ",", 
      "44", ",", "45", ",", "13", ",", "47", ",", "15", ",", "49", ",", "50", 
      ",", "52", ",", "53", ",", "33", ",", "54", ",", "56", ",", "37", ",", 
      "51", ",", "57", ",", "59", ",", "21", ",", "46", ",", "23", ",", "43", 
      ",", "25", ",", "58", ",", "63", ",", "55", ",", "48", ",", "60", ",", 
      "39", ",", "64", ",", "65", ",", "35", ",", "62", ",", "61"}], "}"}], 
    "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[241]:=",ExpressionUUID->"49636455-a38a-47a8-9a87-c2db3623e3ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[243]:=",ExpressionUUID->"6264b8e0-0e7e-4bfa-bdbe-ee104dc0f045"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"65", ",", "65"}], "}"}]], "Output",
 CellLabel->
  "Out[243]=",ExpressionUUID->"6123c7d1-248a-4571-bb9a-f9d031396669"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"Sz8SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "65"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[244]:=",ExpressionUUID->"0ceab5a0-884b-48fb-9aa0-bd2c7d586901"],

Cell[BoxData[
 RowBox[{"0.006236`3.9454211043487977", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[244]:=",ExpressionUUID->"fa9666ea-9cb5-428f-9e4e-d7cbff9430e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "Sz8SGS"}]], "Input",
 CellLabel->
  "In[245]:=",ExpressionUUID->"60cae9b7-50ef-435b-b9e7-2d9286c2eaa6"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"3", ",", "5"}], "]"}]], "Output",
 CellLabel->
  "Out[245]=",ExpressionUUID->"9ae30b73-46ac-496a-a3f8-cf8bea357702"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "Sz8SGS", "]"}]], "Input",
 CellLabel->
  "In[246]:=",ExpressionUUID->"45136663-337d-41e6-814d-cc9e440be60d"],

Cell[BoxData["29120"], "Output",
 CellLabel->
  "Out[246]=",ExpressionUUID->"6aa08c0a-8b51-486f-bab9-b047411eb4a7"]
}, Open  ]],

Cell["\<\
This is the exceptional untwisted group G2(4), which can be given in terms of \
permutations on 416 points.\
\>", "MathCaption",ExpressionUUID->"3dd7774f-a4bf-4ce8-bba9-874421c5249b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "1", ",", "5", ",", "7", ",", "3", ",", "10", ",", "4", ",", 
      "13", ",", "12", ",", "6", ",", "11", ",", "9", ",", "8", ",", "20", 
      ",", "22", ",", "24", ",", "26", ",", "27", ",", "29", ",", "14", ",", 
      "32", ",", "15", ",", "23", ",", "16", ",", "36", ",", "17", ",", "18", 
      ",", "40", ",", "19", ",", "43", ",", "31", ",", "21", ",", "47", ",", 
      "49", ",", "50", ",", "25", ",", "53", ",", "55", ",", "57", ",", "28", 
      ",", "60", ",", "42", ",", "30", ",", "62", ",", "64", ",", "66", ",", 
      "33", ",", "69", ",", "34", ",", "35", ",", "72", ",", "74", ",", "37", 
      ",", "77", ",", "38", ",", "79", ",", "39", ",", "82", ",", "84", ",", 
      "41", ",", "87", ",", "44", ",", "90", ",", "45", ",", "92", ",", "46", 
      ",", "95", ",", "97", ",", "48", ",", "100", ",", "101", ",", "51", ",",
       "104", ",", "52", ",", "107", ",", "76", ",", "54", ",", "111", ",", 
      "56", ",", "109", ",", "114", ",", "58", ",", "117", ",", "59", ",", 
      "120", ",", "122", ",", "61", ",", "125", ",", "89", ",", "63", ",", 
      "128", ",", "65", ",", "131", ",", "132", ",", "67", ",", "135", ",", 
      "68", ",", "138", ",", "99", ",", "70", ",", "71", ",", "140", ",", 
      "142", ",", "73", ",", "143", ",", "144", ",", "75", ",", "147", ",", 
      "80", ",", "150", ",", "78", ",", "153", ",", "155", ",", "81", ",", 
      "156", ",", "158", ",", "83", ",", "133", ",", "161", ",", "85", ",", 
      "164", ",", "86", ",", "166", ",", "167", ",", "88", ",", "170", ",", 
      "171", ",", "91", ",", "174", ",", "176", ",", "93", ",", "94", ",", 
      "118", ",", "181", ",", "96", ",", "184", ",", "137", ",", "98", ",", 
      "186", ",", "102", ",", "188", ",", "103", ",", "105", ",", "106", ",", 
      "145", ",", "192", ",", "108", ",", "195", ",", "196", ",", "110", ",", 
      "179", ",", "200", ",", "112", ",", "203", ",", "113", ",", "115", ",", 
      "157", ",", "116", ",", "208", ",", "209", ",", "119", ",", "212", ",", 
      "211", ",", "121", ",", "165", ",", "123", ",", "124", ",", "217", ",", 
      "219", ",", "126", ",", "127", ",", "223", ",", "225", ",", "129", ",", 
      "228", ",", "130", ",", "230", ",", "232", ",", "151", ",", "235", ",", 
      "134", ",", "238", ",", "183", ",", "136", ",", "241", ",", "139", ",", 
      "244", ",", "141", ",", "193", ",", "248", ",", "250", ",", "146", ",", 
      "189", ",", "252", ",", "148", ",", "149", ",", "254", ",", "255", ",", 
      "257", ",", "152", ",", "220", ",", "259", ",", "154", ",", "262", ",", 
      "214", ",", "240", ",", "264", ",", "159", ",", "160", ",", "267", ",", 
      "163", ",", "162", ",", "221", ",", "205", ",", "263", ",", "274", ",", 
      "168", ",", "276", ",", "169", ",", "201", ",", "213", ",", "224", ",", 
      "172", ",", "222", ",", "173", ",", "280", ",", "282", ",", "175", ",", 
      "247", ",", "177", ",", "266", ",", "178", ",", "287", ",", "289", ",", 
      "180", ",", "277", ",", "291", ",", "182", ",", "294", ",", "206", ",", 
      "185", ",", "284", ",", "278", ",", "187", ",", "301", ",", "302", ",", 
      "229", ",", "190", ",", "304", ",", "191", ",", "307", ",", "194", ",", 
      "308", ",", "197", ",", "198", ",", "311", ",", "199", ",", "313", ",", 
      "202", ",", "275", ",", "261", ",", "204", ",", "215", ",", "207", ",", 
      "319", ",", "231", ",", "210", ",", "322", ",", "324", ",", "326", ",", 
      "327", ",", "328", ",", "330", ",", "216", ",", "260", ",", "218", ",", 
      "236", ",", "243", ",", "333", ",", "226", ",", "281", ",", "227", ",", 
      "336", ",", "242", ",", "339", ",", "340", ",", "233", ",", "299", ",", 
      "234", ",", "343", ",", "237", ",", "345", ",", "347", ",", "239", ",", 
      "349", ",", "296", ",", "351", ",", "352", ",", "288", ",", "354", ",", 
      "245", ",", "246", ",", "356", ",", "249", ",", "359", ",", "306", ",", 
      "251", ",", "253", ",", "362", ",", "310", ",", "256", ",", "365", ",", 
      "258", ",", "314", ",", "315", ",", "316", ",", "368", ",", "370", ",", 
      "265", ",", "373", ",", "350", ",", "268", ",", "375", ",", "269", ",", 
      "325", ",", "270", ",", "271", ",", "272", ",", "377", ",", "273", ",", 
      "338", ",", "376", ",", "279", ",", "379", ",", "363", ",", "283", ",", 
      "348", ",", "331", ",", "285", ",", "286", ",", "384", ",", "383", ",", 
      "290", ",", "353", ",", "292", ",", "387", ",", "293", ",", "337", ",", 
      "295", ",", "321", ",", "297", ",", "298", ",", "344", ",", "300", ",", 
      "392", ",", "303", ",", "357", ",", "395", ",", "305", ",", "396", ",", 
      "389", ",", "309", ",", "335", ",", "398", ",", "312", ",", "381", ",", 
      "397", ",", "317", ",", "369", ",", "318", ",", "399", ",", "380", ",", 
      "320", ",", "401", ",", "323", ",", "332", ",", "329", ",", "403", ",", 
      "334", ",", "372", ",", "366", ",", "382", ",", "342", ",", "341", ",", 
      "405", ",", "393", ",", "346", ",", "388", ",", "361", ",", "390", ",", 
      "394", ",", "355", ",", "386", ",", "391", ",", "358", ",", "360", ",", 
      "367", ",", "364", ",", "371", ",", "400", ",", "374", ",", "407", ",", 
      "378", ",", "411", ",", "385", ",", "408", ",", "402", ",", "406", ",", 
      "409", ",", "410", ",", "404", ",", "412", ",", "414", ",", "413", ",", 
      "415", ",", "416"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "4", ",", "6", ",", "8", ",", "9", ",", "11", ",", "12", ",", 
      "14", ",", "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", "21", 
      ",", "23", ",", "25", ",", "1", ",", "28", ",", "30", ",", "31", ",", 
      "2", ",", "33", ",", "34", ",", "35", ",", "37", ",", "38", ",", "39", 
      ",", "41", ",", "42", ",", "44", ",", "45", ",", "46", ",", "48", ",", 
      "5", ",", "51", ",", "52", ",", "54", ",", "56", ",", "58", ",", "59", 
      ",", "7", ",", "61", ",", "22", ",", "63", ",", "65", ",", "67", ",", 
      "68", ",", "70", ",", "71", ",", "50", ",", "73", ",", "75", ",", "76", 
      ",", "10", ",", "78", ",", "80", ",", "81", ",", "83", ",", "85", ",", 
      "86", ",", "88", ",", "89", ",", "13", ",", "91", ",", "93", ",", "94", 
      ",", "96", ",", "98", ",", "99", ",", "43", ",", "102", ",", "103", ",",
       "105", ",", "106", ",", "108", ",", "109", ",", "110", ",", "60", ",", 
      "112", ",", "113", ",", "115", ",", "116", ",", "118", ",", "119", ",", 
      "121", ",", "123", ",", "124", ",", "126", ",", "82", ",", "127", ",", 
      "129", ",", "130", ",", "20", ",", "133", ",", "134", ",", "136", ",", 
      "137", ",", "139", ",", "140", ",", "64", ",", "47", ",", "141", ",", 
      "107", ",", "104", ",", "24", ",", "145", ",", "146", ",", "148", ",", 
      "149", ",", "151", ",", "152", ",", "154", ",", "26", ",", "74", ",", 
      "157", ",", "159", ",", "160", ",", "27", ",", "162", ",", "163", ",", 
      "165", ",", "90", ",", "55", ",", "168", ",", "169", ",", "29", ",", 
      "172", ",", "173", ",", "175", ",", "177", ",", "178", ",", "179", ",", 
      "180", ",", "182", ",", "183", ",", "32", ",", "185", ",", "132", ",", 
      "101", ",", "187", ",", "143", ",", "189", ",", "49", ",", "190", ",", 
      "191", ",", "193", ",", "194", ",", "36", ",", "197", ",", "198", ",", 
      "199", ",", "201", ",", "202", ",", "204", ",", "77", ",", "205", ",", 
      "206", ",", "207", ",", "62", ",", "210", ",", "211", ",", "213", ",", 
      "214", ",", "79", ",", "40", ",", "215", ",", "216", ",", "218", ",", 
      "220", ",", "221", ",", "222", ",", "224", ",", "226", ",", "227", ",", 
      "100", ",", "229", ",", "231", ",", "233", ",", "234", ",", "236", ",", 
      "237", ",", "239", ",", "166", ",", "240", ",", "242", ",", "243", ",", 
      "245", ",", "246", ",", "247", ",", "249", ",", "114", ",", "251", ",", 
      "72", ",", "238", ",", "230", ",", "253", ",", "53", ",", "256", ",", 
      "155", ",", "195", ",", "258", ",", "260", ",", "261", ",", "164", ",", 
      "263", ",", "57", ",", "265", ",", "266", ",", "181", ",", "268", ",", 
      "269", ",", "270", ",", "271", ",", "272", ",", "273", ",", "228", ",", 
      "275", ",", "267", ",", "219", ",", "241", ",", "277", ",", "278", ",", 
      "279", ",", "122", ",", "262", ",", "281", ",", "283", ",", "250", ",", 
      "284", ",", "235", ",", "285", ",", "286", ",", "288", ",", "290", ",", 
      "287", ",", "66", ",", "292", ",", "293", ",", "295", ",", "296", ",", 
      "297", ",", "298", ",", "299", ",", "300", ",", "69", ",", "252", ",", 
      "223", ",", "303", ",", "305", ",", "306", ",", "188", ",", "192", ",", 
      "309", ",", "208", ",", "310", ",", "212", ",", "312", ",", "314", ",", 
      "315", ",", "316", ",", "276", ",", "317", ",", "244", ",", "318", ",", 
      "320", ",", "321", ",", "87", ",", "323", ",", "325", ",", "150", ",", 
      "84", ",", "329", ",", "135", ",", "259", ",", "313", ",", "331", ",", 
      "328", ",", "332", ",", "142", ",", "304", ",", "334", ",", "335", ",", 
      "337", ",", "338", ",", "92", ",", "341", ",", "200", ",", "342", ",", 
      "282", ",", "138", ",", "344", ",", "346", ",", "322", ",", "348", ",", 
      "95", ",", "350", ",", "125", ",", "97", ",", "353", ",", "156", ",", 
      "355", ",", "170", ",", "357", ",", "358", ",", "360", ",", "167", ",", 
      "361", ",", "161", ",", "363", ",", "280", ",", "364", ",", "366", ",", 
      "294", ",", "111", ",", "347", ",", "367", ",", "369", ",", "371", ",", 
      "372", ",", "365", ",", "374", ",", "147", ",", "117", ",", "339", ",", 
      "308", ",", "171", ",", "376", ",", "302", ",", "120", ",", "352", ",", 
      "378", ",", "326", ",", "377", ",", "128", ",", "380", ",", "381", ",", 
      "382", ",", "362", ",", "383", ",", "340", ",", "327", ",", "131", ",", 
      "379", ",", "385", ",", "386", ",", "209", ",", "388", ",", "217", ",", 
      "319", ",", "389", ",", "390", ",", "373", ",", "391", ",", "264", ",", 
      "393", ",", "225", ",", "394", ",", "255", ",", "307", ",", "144", ",", 
      "397", ",", "176", ",", "392", ",", "291", ",", "158", ",", "351", ",", 
      "153", ",", "289", ",", "356", ",", "248", ",", "400", ",", "398", ",", 
      "387", ",", "254", ",", "349", ",", "232", ",", "402", ",", "203", ",", 
      "345", ",", "368", ",", "333", ",", "174", ",", "404", ",", "384", ",", 
      "311", ",", "403", ",", "406", ",", "274", ",", "184", ",", "257", ",", 
      "186", ",", "196", ",", "407", ",", "370", ",", "408", ",", "396", ",", 
      "409", ",", "375", ",", "405", ",", "354", ",", "410", ",", "336", ",", 
      "343", ",", "412", ",", "413", ",", "330", ",", "411", ",", "401", ",", 
      "359", ",", "414", ",", "301", ",", "324", ",", "415", ",", "395", ",", 
      "416", ",", "399"}], "}"}], "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[247]:=",ExpressionUUID->"e2e64d4d-5a3b-44ce-a761-3bfd067913e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[249]:=",ExpressionUUID->"6c2637bb-d9de-4693-945d-770a10ae2e1b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"414", ",", "416"}], "}"}]], "Output",
 CellLabel->
  "Out[249]=",ExpressionUUID->"98c2ca4f-d538-49ce-b10e-2598658742cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"G24SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "416"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[250]:=",ExpressionUUID->"bdf8c9f7-8dab-41b7-9ba2-5ad62c551c06"],

Cell[BoxData[
 RowBox[{"0.933595`6.120673514950044", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[250]:=",ExpressionUUID->"340214a9-d7eb-423d-bb4c-4016e1016bcb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "G24SGS"}]], "Input",
 CellLabel->
  "In[251]:=",ExpressionUUID->"0e00b51d-6162-40e0-a016-f56d128f0a31"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"4", ",", "11"}], "]"}]], "Output",
 CellLabel->
  "Out[251]=",ExpressionUUID->"1b9fbc61-6ea5-4c03-9b95-2e7c5403b7f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "G24SGS", "]"}]], "Input",
 CellLabel->
  "In[252]:=",ExpressionUUID->"87d1bbd3-09d1-4ba3-9ade-98da2d9a8847"],

Cell[BoxData["251596800"], "Output",
 CellLabel->
  "Out[252]=",ExpressionUUID->"1f6ff5f3-ae49-4c12-9a36-67a1b6fa097b"]
}, Open  ]],

Cell["\<\
The largest symplectic group given in the Atlas is S10. It can be represented \
using permutations of 496 points.\
\>", "MathCaption",ExpressionUUID->"71a8f442-8d5c-4978-99d0-939901b41a93"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "3", ",", "2", ",", "5", ",", "6", ",", "7", ",", 
      "8", ",", "11", ",", "10", ",", "9", ",", "12", ",", "15", ",", "17", 
      ",", "13", ",", "16", ",", "14", ",", "18", ",", "25", ",", "20", ",", 
      "21", ",", "22", ",", "30", ",", "24", ",", "19", ",", "26", ",", "35", 
      ",", "28", ",", "38", ",", "23", ",", "31", ",", "32", ",", "33", ",", 
      "34", ",", "27", ",", "36", ",", "37", ",", "29", ",", "39", ",", "40", 
      ",", "41", ",", "42", ",", "43", ",", "44", ",", "54", ",", "48", ",", 
      "47", ",", "46", ",", "49", ",", "50", ",", "51", ",", "61", ",", "60", 
      ",", "45", ",", "55", ",", "66", ",", "57", ",", "68", ",", "69", ",", 
      "53", ",", "52", ",", "62", ",", "63", ",", "64", ",", "74", ",", "56", 
      ",", "77", ",", "58", ",", "59", ",", "70", ",", "80", ",", "81", ",", 
      "83", ",", "65", ",", "87", ",", "76", ",", "67", ",", "78", ",", "93", 
      ",", "71", ",", "72", ",", "82", ",", "73", ",", "84", ",", "101", ",", 
      "86", ",", "75", ",", "88", ",", "89", ",", "90", ",", "108", ",", "92",
       ",", "79", ",", "94", ",", "113", ",", "115", ",", "105", ",", "118", 
      ",", "112", ",", "121", ",", "85", ",", "116", ",", "126", ",", "104", 
      ",", "97", ",", "106", ",", "114", ",", "91", ",", "109", ",", "110", 
      ",", "136", ",", "99", ",", "95", ",", "107", ",", "96", ",", "102", 
      ",", "145", ",", "98", ",", "119", ",", "149", ",", "100", ",", "122", 
      ",", "123", ",", "124", ",", "155", ",", "103", ",", "153", ",", "128", 
      ",", "129", ",", "130", ",", "163", ",", "132", ",", "133", ",", "134", 
      ",", "135", ",", "111", ",", "166", ",", "138", ",", "139", ",", "140", 
      ",", "141", ",", "142", ",", "143", ",", "144", ",", "117", ",", "146", 
      ",", "182", ",", "184", ",", "120", ",", "150", ",", "189", ",", "191", 
      ",", "127", ",", "154", ",", "125", ",", "156", ",", "157", ",", "158", 
      ",", "159", ",", "160", ",", "161", ",", "162", ",", "131", ",", "164", 
      ",", "165", ",", "137", ",", "167", ",", "168", ",", "169", ",", "170", 
      ",", "171", ",", "172", ",", "173", ",", "210", ",", "175", ",", "213", 
      ",", "177", ",", "178", ",", "217", ",", "180", ",", "181", ",", "147", 
      ",", "183", ",", "148", ",", "190", ",", "186", ",", "224", ",", "188", 
      ",", "151", ",", "185", ",", "152", ",", "192", ",", "231", ",", "211", 
      ",", "195", ",", "234", ",", "197", ",", "198", ",", "199", ",", "200", 
      ",", "240", ",", "202", ",", "214", ",", "243", ",", "205", ",", "206", 
      ",", "207", ",", "208", ",", "209", ",", "174", ",", "194", ",", "212", 
      ",", "176", ",", "203", ",", "215", ",", "216", ",", "179", ",", "218", 
      ",", "259", ",", "220", ",", "262", ",", "222", ",", "223", ",", "187", 
      ",", "225", ",", "226", ",", "227", ",", "228", ",", "271", ",", "273", 
      ",", "193", ",", "232", ",", "276", ",", "196", ",", "235", ",", "236", 
      ",", "237", ",", "283", ",", "284", ",", "201", ",", "241", ",", "288", 
      ",", "204", ",", "244", ",", "292", ",", "246", ",", "247", ",", "295", 
      ",", "249", ",", "296", ",", "251", ",", "252", ",", "253", ",", "254", 
      ",", "255", ",", "301", ",", "257", ",", "258", ",", "219", ",", "279", 
      ",", "307", ",", "221", ",", "263", ",", "311", ",", "265", ",", "266", 
      ",", "314", ",", "268", ",", "316", ",", "318", ",", "229", ",", "285", 
      ",", "230", ",", "325", ",", "291", ",", "233", ",", "329", ",", "278", 
      ",", "260", ",", "280", ",", "333", ",", "282", ",", "238", ",", "239", 
      ",", "272", ",", "286", ",", "287", ",", "242", ",", "342", ",", "343", 
      ",", "275", ",", "245", ",", "293", ",", "348", ",", "248", ",", "250", 
      ",", "297", ",", "353", ",", "299", ",", "355", ",", "256", ",", "302", 
      ",", "303", ",", "304", ",", "305", ",", "306", ",", "261", ",", "358", 
      ",", "324", ",", "366", ",", "264", ",", "312", ",", "313", ",", "267", 
      ",", "315", ",", "269", ",", "317", ",", "270", ",", "369", ",", "320", 
      ",", "321", ",", "322", ",", "379", ",", "309", ",", "274", ",", "382", 
      ",", "327", ",", "328", ",", "277", ",", "330", ",", "331", ",", "387", 
      ",", "281", ",", "334", ",", "388", ",", "346", ",", "337", ",", "338", 
      ",", "339", ",", "340", ",", "341", ",", "289", ",", "290", ",", "384", 
      ",", "345", ",", "336", ",", "397", ",", "294", ",", "349", ",", "350", 
      ",", "351", ",", "400", ",", "298", ",", "402", ",", "300", ",", "404", 
      ",", "357", ",", "308", ",", "359", ",", "360", ",", "361", ",", "411", 
      ",", "363", ",", "364", ",", "365", ",", "310", ",", "416", ",", "417", 
      ",", "319", ",", "370", ",", "420", ",", "422", ",", "414", ",", "374", 
      ",", "375", ",", "376", ",", "377", ",", "378", ",", "323", ",", "380", 
      ",", "381", ",", "326", ",", "430", ",", "344", ",", "385", ",", "386", 
      ",", "332", ",", "335", ",", "389", ",", "390", ",", "391", ",", "392", 
      ",", "393", ",", "439", ",", "395", ",", "396", ",", "347", ",", "398", 
      ",", "399", ",", "352", ",", "401", ",", "354", ",", "403", ",", "356", 
      ",", "448", ",", "406", ",", "418", ",", "408", ",", "451", ",", "410", 
      ",", "362", ",", "412", ",", "413", ",", "373", ",", "415", ",", "367", 
      ",", "368", ",", "407", ",", "419", ",", "371", ",", "459", ",", "372", 
      ",", "423", ",", "424", ",", "462", ",", "426", ",", "427", ",", "428", 
      ",", "429", ",", "383", ",", "442", ",", "432", ",", "437", ",", "434", 
      ",", "435", ",", "436", ",", "433", ",", "438", ",", "394", ",", "440", 
      ",", "441", ",", "431", ",", "443", ",", "444", ",", "445", ",", "446", 
      ",", "447", ",", "405", ",", "449", ",", "450", ",", "409", ",", "452", 
      ",", "453", ",", "454", ",", "455", ",", "456", ",", "457", ",", "458", 
      ",", "421", ",", "460", ",", "461", ",", "425", ",", "463", ",", "464", 
      ",", "465", ",", "466", ",", "467", ",", "468", ",", "481", ",", "483", 
      ",", "471", ",", "485", ",", "486", ",", "474", ",", "488", ",", "476", 
      ",", "477", ",", "489", ",", "479", ",", "480", ",", "469", ",", "482", 
      ",", "470", ",", "484", ",", "472", ",", "473", ",", "490", ",", "475", 
      ",", "478", ",", "487", ",", "491", ",", "492", ",", "493", ",", "494", 
      ",", "496", ",", "495"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "4", ",", "1", ",", "6", ",", "3", ",", "8", ",", "5", ",", 
      "10", ",", "7", ",", "12", ",", "13", ",", "9", ",", "16", ",", "11", 
      ",", "19", ",", "21", ",", "22", ",", "14", ",", "26", ",", "15", ",", 
      "28", ",", "29", ",", "17", ",", "18", ",", "30", ",", "34", ",", "20", 
      ",", "37", ",", "39", ",", "40", ",", "23", ",", "24", ",", "25", ",", 
      "44", ",", "45", ",", "27", ",", "42", ",", "48", ",", "49", ",", "50", 
      ",", "31", ",", "32", ",", "33", ",", "53", ",", "38", ",", "35", ",", 
      "36", ",", "57", ",", "58", ",", "59", ",", "41", ",", "43", ",", "56", 
      ",", "63", ",", "46", ",", "47", ",", "67", ",", "60", ",", "70", ",", 
      "51", ",", "65", ",", "52", ",", "72", ",", "54", ",", "55", ",", "75", 
      ",", "69", ",", "78", ",", "61", ",", "71", ",", "62", ",", "82", ",", 
      "64", ",", "85", ",", "88", ",", "66", ",", "90", ",", "92", ",", "68", 
      ",", "95", ",", "97", ",", "98", ",", "91", ",", "73", ",", "81", ",", 
      "74", ",", "103", ",", "105", ",", "76", ",", "107", ",", "77", ",", 
      "109", ",", "110", ",", "79", ",", "114", ",", "80", ",", "117", ",", 
      "119", ",", "83", ",", "84", ",", "123", ",", "86", ",", "127", ",", 
      "87", ",", "129", ",", "89", ",", "131", ",", "132", ",", "134", ",", 
      "135", ",", "93", ",", "94", ",", "139", ",", "141", ",", "142", ",", 
      "96", ",", "146", ",", "147", ",", "122", ",", "99", ",", "151", ",", 
      "100", ",", "153", ",", "101", ",", "102", ",", "157", ",", "159", ",", 
      "104", ",", "161", ",", "106", ",", "164", ",", "165", ",", "108", ",", 
      "167", ",", "168", ",", "169", ",", "111", ",", "112", ",", "173", ",", 
      "113", ",", "175", ",", "176", ",", "115", ",", "116", ",", "179", ",", 
      "181", ",", "183", ",", "118", ",", "186", ",", "120", ",", "190", ",", 
      "121", ",", "193", ",", "124", ",", "195", ",", "125", ",", "197", ",", 
      "126", ",", "199", ",", "128", ",", "162", ",", "130", ",", "201", ",", 
      "188", ",", "203", ",", "133", ",", "172", ",", "205", ",", "206", ",", 
      "136", ",", "137", ",", "138", ",", "209", ",", "140", ",", "212", ",", 
      "214", ",", "143", ",", "144", ",", "218", ",", "145", ",", "156", ",", 
      "219", ",", "221", ",", "222", ",", "148", ",", "185", ",", "149", ",", 
      "150", ",", "226", ",", "180", ",", "228", ",", "152", ",", "232", ",", 
      "154", ",", "202", ",", "155", ",", "236", ",", "158", ",", "238", ",", 
      "160", ",", "241", ",", "163", ",", "242", ",", "166", ",", "245", ",", 
      "246", ",", "170", ",", "171", ",", "249", ",", "250", ",", "174", ",", 
      "216", ",", "253", ",", "254", ",", "177", ",", "178", ",", "256", ",", 
      "258", ",", "260", ",", "182", ",", "263", ",", "264", ",", "184", ",", 
      "266", ",", "187", ",", "268", ",", "189", ",", "270", ",", "191", ",", 
      "192", ",", "274", ",", "275", ",", "194", ",", "278", ",", "196", ",", 
      "281", ",", "198", ",", "239", ",", "200", ",", "285", ",", "287", ",", 
      "289", ",", "265", ",", "204", ",", "248", ",", "293", ",", "207", ",", 
      "208", ",", "295", ",", "213", ",", "210", ",", "211", ",", "299", ",", 
      "300", ",", "215", ",", "302", ",", "217", ",", "230", ",", "304", ",", 
      "306", ",", "220", ",", "309", ",", "225", ",", "312", ",", "223", ",", 
      "313", ",", "224", ",", "231", ",", "227", ",", "319", ",", "320", ",", 
      "229", ",", "323", ",", "326", ",", "277", ",", "327", ",", "233", ",", 
      "330", ",", "234", ",", "235", ",", "334", ",", "237", ",", "255", ",", 
      "336", ",", "338", ",", "240", ",", "332", ",", "340", ",", "291", ",", 
      "243", ",", "244", ",", "345", ",", "347", ",", "247", ",", "298", ",", 
      "350", ",", "251", ",", "252", ",", "354", ",", "283", ",", "356", ",", 
      "343", ",", "257", ",", "359", ",", "259", ",", "361", ",", "362", ",", 
      "261", ",", "365", ",", "262", ",", "367", ",", "368", ",", "369", ",", 
      "370", ",", "267", ",", "372", ",", "269", ",", "374", ",", "375", ",", 
      "376", ",", "271", ",", "272", ",", "310", ",", "273", ",", "315", ",", 
      "383", ",", "339", ",", "276", ",", "385", ",", "341", ",", "279", ",", 
      "280", ",", "348", ",", "335", ",", "282", ",", "389", ",", "284", ",", 
      "366", ",", "286", ",", "382", ",", "288", ",", "391", ",", "393", ",", 
      "290", ",", "395", ",", "292", ",", "349", ",", "352", ",", "294", ",", 
      "398", ",", "296", ",", "297", ",", "397", ",", "333", ",", "403", ",", 
      "405", ",", "301", ",", "303", ",", "408", ",", "305", ",", "410", ",", 
      "311", ",", "307", ",", "308", ",", "414", ",", "415", ",", "316", ",", 
      "394", ",", "418", ",", "419", ",", "314", ",", "318", ",", "317", ",", 
      "423", ",", "424", ",", "425", ",", "321", ",", "322", ",", "331", ",", 
      "324", ",", "325", ",", "428", ",", "373", ",", "328", ",", "431", ",", 
      "329", ",", "417", ",", "355", ",", "434", ",", "337", ",", "436", ",", 
      "342", ",", "438", ",", "344", ",", "440", ",", "346", ",", "442", ",", 
      "443", ",", "351", ",", "402", ",", "353", ",", "446", ",", "426", ",", 
      "435", ",", "432", ",", "357", ",", "358", ",", "401", ",", "360", ",", 
      "413", ",", "452", ",", "363", ",", "364", ",", "387", ",", "384", ",", 
      "454", ",", "380", ",", "456", ",", "457", ",", "458", ",", "371", ",", 
      "460", ",", "412", ",", "427", ",", "433", ",", "377", ",", "378", ",", 
      "379", ",", "381", ",", "463", ",", "449", ",", "386", ",", "388", ",", 
      "465", ",", "390", ",", "421", ",", "392", ",", "450", ",", "466", ",", 
      "420", ",", "396", ",", "409", ",", "469", ",", "399", ",", "400", ",", 
      "451", ",", "404", ",", "459", ",", "406", ",", "407", ",", "472", ",", 
      "473", ",", "411", ",", "475", ",", "416", ",", "429", ",", "437", ",", 
      "476", ",", "464", ",", "477", ",", "422", ",", "445", ",", "479", ",", 
      "430", ",", "471", ",", "448", ",", "439", ",", "441", ",", "482", ",", 
      "444", ",", "447", ",", "455", ",", "487", ",", "453", ",", "462", ",", 
      "468", ",", "474", ",", "461", ",", "490", ",", "467", ",", "486", ",", 
      "484", ",", "488", ",", "470", ",", "481", ",", "492", ",", "478", ",", 
      "493", ",", "483", ",", "480", ",", "485", ",", "495", ",", "491", ",", 
      "489", ",", "494", ",", "496"}], "}"}], "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[253]:=",ExpressionUUID->"8e10d198-c638-4dd8-b826-5ae5be6df077"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[255]:=",ExpressionUUID->"867ed90e-49c9-401d-a098-170c0a4ca9b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"496", ",", "495"}], "}"}]], "Output",
 CellLabel->
  "Out[255]=",ExpressionUUID->"3ca340ad-e9f6-40a6-9b1a-6cbc13a5ee06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"S10SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "496"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[256]:=",ExpressionUUID->"44d2b7d9-226b-47ec-8161-f29726786d77"],

Cell[BoxData[
 RowBox[{"11.02911`7.1930554660578805", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[256]:=",ExpressionUUID->"4bd52f77-cd3b-4a6e-9112-70ce9fff0903"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "S10SGS"}]], "Input",
 CellLabel->
  "In[257]:=",ExpressionUUID->"5dfa7574-e0f5-4e6d-a636-30753af2716f"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"10", ",", "20"}], "]"}]], "Output",
 CellLabel->
  "Out[257]=",ExpressionUUID->"a198012d-b043-48f4-ba76-817743925a95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "S10SGS", "]"}]], "Input",
 CellLabel->
  "In[258]:=",ExpressionUUID->"7e7c646d-c548-4f87-9d60-3d04b42302db"],

Cell[BoxData["24815256521932800"], "Output",
 CellLabel->
  "Out[258]=",ExpressionUUID->"e34fb959-d95c-4dbd-8050-c78f50fb8c0c"]
}, Open  ]],

Cell["\<\
This is the exceptional twisted group T3D4, represented with permutations on \
819 points.\
\>", "MathCaption",ExpressionUUID->"310a4ffb-7605-4a37-9c63-566fa9873648"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "1", ",", "5", ",", "7", ",", "3", ",", "10", ",", "4", ",", 
      "13", ",", "15", ",", "6", ",", "18", ",", "20", ",", "8", ",", "23", 
      ",", "9", ",", "26", ",", "28", ",", "11", ",", "31", ",", "12", ",", 
      "34", ",", "35", ",", "14", ",", "38", ",", "33", ",", "16", ",", "42", 
      ",", "17", ",", "45", ",", "47", ",", "19", ",", "50", ",", "25", ",", 
      "21", ",", "22", ",", "55", ",", "57", ",", "24", ",", "60", ",", "62", 
      ",", "64", ",", "27", ",", "67", ",", "54", ",", "29", ",", "71", ",", 
      "30", ",", "74", ",", "49", ",", "32", ",", "78", ",", "80", ",", "82", 
      ",", "44", ",", "36", ",", "86", ",", "37", ",", "89", ",", "91", ",", 
      "39", ",", "94", ",", "40", ",", "96", ",", "41", ",", "99", ",", "98", 
      ",", "43", ",", "103", ",", "104", ",", "106", ",", "46", ",", "109", 
      ",", "111", ",", "48", ",", "114", ",", "116", ",", "118", ",", "51", 
      ",", "121", ",", "52", ",", "124", ",", "53", ",", "127", ",", "129", 
      ",", "131", ",", "56", ",", "87", ",", "135", ",", "58", ",", "138", 
      ",", "59", ",", "141", ",", "143", ",", "61", ",", "146", ",", "63", 
      ",", "148", ",", "66", ",", "65", ",", "152", ",", "154", ",", "156", 
      ",", "68", ",", "69", ",", "159", ",", "70", ",", "162", ",", "164", 
      ",", "72", ",", "165", ",", "73", ",", "167", ",", "169", ",", "75", 
      ",", "171", ",", "76", ",", "174", ",", "77", ",", "177", ",", "179", 
      ",", "79", ",", "182", ",", "183", ",", "81", ",", "186", ",", "188", 
      ",", "83", ",", "190", ",", "84", ",", "193", ",", "85", ",", "196", 
      ",", "198", ",", "200", ",", "88", ",", "203", ",", "205", ",", "90", 
      ",", "207", ",", "209", ",", "92", ",", "212", ",", "93", ",", "215", 
      ",", "217", ",", "95", ",", "220", ",", "97", ",", "222", ",", "224", 
      ",", "226", ",", "100", ",", "229", ",", "101", ",", "232", ",", "102", 
      ",", "235", ",", "236", ",", "105", ",", "239", ",", "241", ",", "107", 
      ",", "244", ",", "108", ",", "110", ",", "247", ",", "112", ",", "250", 
      ",", "113", ",", "253", ",", "115", ",", "255", ",", "257", ",", "117", 
      ",", "260", ",", "262", ",", "119", ",", "265", ",", "120", ",", "180", 
      ",", "269", ",", "122", ",", "123", ",", "273", ",", "275", ",", "125", 
      ",", "277", ",", "126", ",", "189", ",", "128", ",", "281", ",", "283", 
      ",", "130", ",", "194", ",", "242", ",", "132", ",", "288", ",", "133", 
      ",", "290", ",", "134", ",", "293", ",", "295", ",", "136", ",", "297", 
      ",", "137", ",", "300", ",", "139", ",", "303", ",", "140", ",", "305", 
      ",", "307", ",", "142", ",", "310", ",", "311", ",", "144", ",", "274", 
      ",", "145", ",", "316", ",", "318", ",", "147", ",", "321", ",", "149", 
      ",", "285", ",", "150", ",", "325", ",", "151", ",", "328", ",", "330", 
      ",", "153", ",", "280", ",", "334", ",", "155", ",", "336", ",", "338", 
      ",", "157", ",", "158", ",", "339", ",", "341", ",", "160", ",", "344", 
      ",", "161", ",", "195", ",", "346", ",", "163", ",", "349", ",", "351", 
      ",", "166", ",", "354", ",", "356", ",", "168", ",", "359", ",", "361", 
      ",", "170", ",", "364", ",", "172", ",", "367", ",", "173", ",", "263", 
      ",", "371", ",", "175", ",", "373", ",", "176", ",", "258", ",", "376", 
      ",", "178", ",", "317", ",", "379", ",", "375", ",", "181", ",", "383", 
      ",", "385", ",", "387", ",", "184", ",", "216", ",", "185", ",", "391", 
      ",", "187", ",", "358", ",", "393", ",", "230", ",", "191", ",", "397", 
      ",", "192", ",", "399", ",", "223", ",", "401", ",", "403", ",", "197", 
      ",", "406", ",", "199", ",", "408", ",", "410", ",", "201", ",", "413", 
      ",", "202", ",", "416", ",", "204", ",", "419", ",", "421", ",", "206", 
      ",", "340", ",", "302", ",", "208", ",", "426", ",", "210", ",", "429", 
      ",", "211", ",", "312", ",", "432", ",", "213", ",", "214", ",", "308", 
      ",", "436", ",", "437", ",", "439", ",", "218", ",", "266", ",", "219", 
      ",", "444", ",", "446", ",", "221", ",", "448", ",", "323", ",", "450", 
      ",", "225", ",", "402", ",", "452", ",", "227", ",", "455", ",", "228", 
      ",", "457", ",", "332", ",", "333", ",", "231", ",", "462", ",", "233", 
      ",", "463", ",", "234", ",", "237", ",", "301", ",", "238", ",", "465", 
      ",", "467", ",", "240", ",", "380", ",", "243", ",", "352", ",", "471", 
      ",", "245", ",", "474", ",", "246", ",", "347", ",", "476", ",", "248", 
      ",", "478", ",", "249", ",", "480", ",", "278", ",", "251", ",", "422", 
      ",", "252", ",", "386", ",", "484", ",", "254", ",", "425", ",", "423", 
      ",", "256", ",", "487", ",", "488", ",", "370", ",", "259", ",", "491", 
      ",", "261", ",", "492", ",", "268", ",", "264", ",", "495", ",", "496", 
      ",", "267", ",", "345", ",", "497", ",", "499", ",", "270", ",", "502", 
      ",", "271", ",", "362", ",", "272", ",", "506", ",", "508", ",", "510", 
      ",", "276", ",", "513", ",", "279", ",", "516", ",", "459", ",", "396", 
      ",", "282", ",", "518", ",", "284", ",", "521", ",", "286", ",", "326", 
      ",", "287", ",", "524", ",", "525", ",", "289", ",", "515", ",", "291", 
      ",", "529", ",", "292", ",", "532", ",", "534", ",", "294", ",", "536", 
      ",", "537", ",", "296", ",", "540", ",", "539", ",", "298", ",", "544", 
      ",", "299", ",", "360", ",", "366", ",", "546", ",", "365", ",", "304", 
      ",", "549", ",", "551", ",", "306", ",", "553", ",", "550", ",", "309", 
      ",", "557", ",", "559", ",", "561", ",", "313", ",", "314", ",", "565", 
      ",", "315", ",", "568", ",", "569", ",", "571", ",", "573", ",", "319", 
      ",", "576", ",", "320", ",", "578", ",", "322", ",", "579", ",", "324", 
      ",", "581", ",", "327", ",", "584", ",", "586", ",", "329", ",", "589", 
      ",", "331", ",", "591", ",", "395", ",", "594", ",", "545", ",", "335", 
      ",", "337", ",", "596", ",", "342", ",", "466", ",", "343", ",", "585", 
      ",", "483", ",", "601", ",", "348", ",", "602", ",", "604", ",", "350", 
      ",", "606", ",", "353", ",", "608", ",", "355", ",", "609", ",", "357", 
      ",", "612", ",", "614", ",", "469", ",", "363", ",", "485", ",", "616", 
      ",", "368", ",", "369", ",", "595", ",", "619", ",", "372", ",", "374", 
      ",", "621", ",", "519", ",", "377", ",", "378", ",", "381", ",", "625", 
      ",", "382", ",", "620", ",", "628", ",", "384", ",", "503", ",", "629", 
      ",", "631", ",", "388", ",", "632", ",", "389", ",", "634", ",", "390", 
      ",", "600", ",", "638", ",", "392", ",", "641", ",", "407", ",", "394", 
      ",", "535", ",", "398", ",", "494", ",", "592", ",", "400", ",", "647", 
      ",", "640", ",", "404", ",", "405", ",", "651", ",", "563", ",", "654", 
      ",", "409", ",", "657", ",", "603", ",", "411", ",", "643", ",", "412", 
      ",", "517", ",", "414", ",", "415", ",", "661", ",", "418", ",", "417", 
      ",", "659", ",", "653", ",", "543", ",", "420", ",", "461", ",", "424", 
      ",", "574", ",", "635", ",", "427", ",", "431", ",", "428", ",", "618", 
      ",", "430", ",", "665", ",", "673", ",", "660", ",", "433", ",", "676", 
      ",", "434", ",", "679", ",", "435", ",", "682", ",", "527", ",", "633", 
      ",", "438", ",", "658", ",", "613", ",", "440", ",", "441", ",", "688", 
      ",", "442", ",", "666", ",", "443", ",", "547", ",", "693", ",", "445", 
      ",", "694", ",", "447", ",", "449", ",", "697", ",", "451", ",", "698", 
      ",", "639", ",", "453", ",", "468", ",", "454", ",", "683", ",", "588", 
      ",", "456", ",", "704", ",", "458", ",", "520", ",", "663", ",", "460", 
      ",", "489", ",", "464", ",", "691", ",", "702", ",", "709", ",", "511", 
      ",", "470", ",", "472", ",", "531", ",", "473", ",", "715", ",", "475", 
      ",", "717", ",", "477", ",", "479", ",", "687", ",", "720", ",", "481", 
      ",", "567", ",", "482", ",", "723", ",", "486", ",", "669", ",", "552", 
      ",", "490", ",", "500", ",", "493", ",", "727", ",", "623", ",", "728", 
      ",", "498", ",", "675", ",", "730", ",", "501", ",", "504", ",", "732", 
      ",", "505", ",", "507", ",", "564", ",", "509", ",", "548", ",", "648", 
      ",", "736", ",", "512", ",", "583", ",", "523", ",", "514", ",", "664", 
      ",", "533", ",", "655", ",", "722", ",", "672", ",", "522", ",", "636", 
      ",", "745", ",", "746", ",", "526", ",", "716", ",", "542", ",", "528", 
      ",", "644", ",", "749", ",", "530", ",", "566", ",", "541", ",", "556", 
      ",", "538", ",", "701", ",", "593", ",", "642", ",", "554", ",", "572", 
      ",", "708", ",", "754", ",", "617", ",", "707", ",", "695", ",", "646", 
      ",", "555", ",", "719", ",", "626", ",", "558", ",", "755", ",", "737", 
      ",", "560", ",", "726", ",", "681", ",", "562", ",", "587", ",", "706", 
      ",", "765", ",", "767", ",", "610", ",", "570", ",", "770", ",", "690", 
      ",", "597", ",", "773", ",", "575", ",", "577", ",", "671", ",", "775", 
      ",", "580", ",", "582", ",", "712", ",", "739", ",", "662", ",", "598", 
      ",", "778", ",", "590", ",", "763", ",", "684", ",", "670", ",", "667", 
      ",", "599", ",", "782", ",", "783", ",", "699", ",", "784", ",", "785", 
      ",", "605", ",", "652", ",", "607", ",", "786", ",", "674", ",", "611", 
      ",", "789", ",", "645", ",", "615", ",", "791", ",", "757", ",", "680", 
      ",", "622", ",", "624", ",", "793", ",", "627", ",", "794", ",", "630", 
      ",", "760", ",", "795", ",", "787", ",", "637", ",", "678", ",", "798", 
      ",", "700", ",", "799", ",", "801", ",", "753", ",", "744", ",", "743", 
      ",", "649", ",", "650", ",", "796", ",", "756", ",", "656", ",", "772", 
      ",", "804", ",", "805", ",", "742", ",", "668", ",", "677", ",", "748", 
      ",", "725", ",", "780", ",", "777", ",", "733", ",", "766", ",", "807", 
      ",", "705", ",", "790", ",", "685", ",", "761", ",", "686", ",", "808", 
      ",", "809", ",", "689", ",", "810", ",", "750", ",", "692", ",", "797", 
      ",", "696", ",", "800", ",", "759", ",", "703", ",", "788", ",", "758", 
      ",", "812", ",", "710", ",", "711", ",", "713", ",", "714", ",", "718", 
      ",", "735", ",", "779", ",", "721", ",", "764", ",", "724", ",", "816", 
      ",", "729", ",", "731", ",", "734", ",", "747", ",", "774", ",", "738", 
      ",", "740", ",", "776", ",", "741", ",", "817", ",", "811", ",", "751", 
      ",", "752", ",", "815", ",", "762", ",", "768", ",", "769", ",", "771", 
      ",", "803", ",", "781", ",", "818", ",", "819", ",", "806", ",", "792", 
      ",", "802", ",", "813", ",", "814"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "4", ",", "6", ",", "8", ",", "9", ",", "11", ",", "12", ",", 
      "14", ",", "16", ",", "17", ",", "19", ",", "21", ",", "22", ",", "24", 
      ",", "25", ",", "27", ",", "29", ",", "30", ",", "32", ",", "33", ",", 
      "7", ",", "36", ",", "37", ",", "39", ",", "40", ",", "41", ",", "43", 
      ",", "44", ",", "46", ",", "48", ",", "49", ",", "51", ",", "52", ",", 
      "53", ",", "54", ",", "56", ",", "58", ",", "59", ",", "61", ",", "63", 
      ",", "65", ",", "66", ",", "68", ",", "69", ",", "70", ",", "72", ",", 
      "73", ",", "75", ",", "76", ",", "77", ",", "79", ",", "81", ",", "83", 
      ",", "84", ",", "85", ",", "87", ",", "88", ",", "90", ",", "92", ",", 
      "93", ",", "95", ",", "31", ",", "97", ",", "98", ",", "100", ",", 
      "101", ",", "102", ",", "67", ",", "105", ",", "107", ",", "108", ",", 
      "110", ",", "112", ",", "113", ",", "115", ",", "117", ",", "119", ",", 
      "120", ",", "122", ",", "123", ",", "125", ",", "126", ",", "128", ",", 
      "130", ",", "132", ",", "133", ",", "134", ",", "136", ",", "137", ",", 
      "139", ",", "140", ",", "142", ",", "144", ",", "145", ",", "147", ",", 
      "121", ",", "149", ",", "150", ",", "151", ",", "153", ",", "155", ",", 
      "157", ",", "99", ",", "158", ",", "160", ",", "161", ",", "163", ",", 
      "28", ",", "15", ",", "166", ",", "131", ",", "168", ",", "138", ",", 
      "170", ",", "172", ",", "173", ",", "175", ",", "176", ",", "178", ",", 
      "180", ",", "181", ",", "1", ",", "184", ",", "185", ",", "187", ",", 
      "189", ",", "177", ",", "191", ",", "192", ",", "194", ",", "195", ",", 
      "197", ",", "199", ",", "201", ",", "202", ",", "204", ",", "20", ",", 
      "206", ",", "208", ",", "210", ",", "211", ",", "213", ",", "214", ",", 
      "216", ",", "218", ",", "219", ",", "2", ",", "221", ",", "223", ",", 
      "225", ",", "227", ",", "228", ",", "230", ",", "231", ",", "233", ",", 
      "234", ",", "5", ",", "237", ",", "238", ",", "240", ",", "242", ",", 
      "243", ",", "245", ",", "246", ",", "135", ",", "248", ",", "249", ",", 
      "251", ",", "252", ",", "164", ",", "254", ",", "256", ",", "258", ",", 
      "259", ",", "261", ",", "263", ",", "264", ",", "266", ",", "267", ",", 
      "268", ",", "270", ",", "271", ",", "272", ",", "274", ",", "276", ",", 
      "143", ",", "278", ",", "279", ",", "280", ",", "193", ",", "282", ",", 
      "174", ",", "284", ",", "285", ",", "286", ",", "287", ",", "224", ",", 
      "289", ",", "291", ",", "292", ",", "294", ",", "229", ",", "296", ",", 
      "298", ",", "299", ",", "301", ",", "302", ",", "179", ",", "304", ",", 
      "306", ",", "308", ",", "309", ",", "167", ",", "312", ",", "313", ",", 
      "314", ",", "315", ",", "317", ",", "319", ",", "320", ",", "322", ",", 
      "323", ",", "324", ",", "156", ",", "326", ",", "327", ",", "329", ",", 
      "331", ",", "332", ",", "333", ",", "335", ",", "207", ",", "337", ",", 
      "300", ",", "82", ",", "118", ",", "340", ",", "342", ",", "343", ",", 
      "260", ",", "345", ",", "42", ",", "347", ",", "348", ",", "350", ",", 
      "352", ",", "353", ",", "355", ",", "357", ",", "358", ",", "360", ",", 
      "362", ",", "363", ",", "365", ",", "366", ",", "368", ",", "369", ",", 
      "370", ",", "372", ",", "71", ",", "361", ",", "374", ",", "375", ",", 
      "377", ",", "378", ",", "159", ",", "380", ",", "381", ",", "382", ",", 
      "384", ",", "386", ",", "310", ",", "388", ",", "389", ",", "390", ",", 
      "104", ",", "392", ",", "89", ",", "394", ",", "395", ",", "396", ",", 
      "257", ",", "398", ",", "400", ",", "182", ",", "402", ",", "404", ",", 
      "405", ",", "239", ",", "407", ",", "409", ",", "411", ",", "412", ",", 
      "414", ",", "415", ",", "417", ",", "418", ",", "420", ",", "422", ",", 
      "423", ",", "424", ",", "425", ",", "148", ",", "427", ",", "428", ",", 
      "269", ",", "430", ",", "431", ",", "433", ",", "86", ",", "434", ",", 
      "435", ",", "341", ",", "438", ",", "440", ",", "441", ",", "442", ",", 
      "443", ",", "445", ",", "351", ",", "447", ",", "449", ",", "198", ",", 
      "109", ",", "235", ",", "451", ",", "453", ",", "454", ",", "200", ",", 
      "456", ",", "458", ",", "459", ",", "460", ",", "461", ",", "339", ",", 
      "305", ",", "106", ",", "336", ",", "367", ",", "464", ",", "290", ",", 
      "466", ",", "265", ",", "468", ",", "469", ",", "273", ",", "470", ",", 
      "472", ",", "473", ",", "475", ",", "387", ",", "471", ",", "477", ",", 
      "38", ",", "10", ",", "479", ",", "354", ",", "247", ",", "462", ",", 
      "481", ",", "482", ",", "483", ",", "80", ",", "485", ",", "262", ",", 
      "45", ",", "486", ",", "446", ",", "489", ",", "379", ",", "490", ",", 
      "436", ",", "205", ",", "493", ",", "346", ",", "494", ",", "406", ",", 
      "492", ",", "196", ",", "23", ",", "498", ",", "500", ",", "501", ",", 
      "503", ",", "504", ",", "35", ",", "505", ",", "507", ",", "509", ",", 
      "511", ",", "512", ",", "514", ",", "515", ",", "283", ",", "517", ",", 
      "397", ",", "518", ",", "519", ",", "520", ",", "522", ",", "338", ",", 
      "523", ",", "215", ",", "502", ",", "526", ",", "527", ",", "496", ",", 
      "528", ",", "530", ",", "531", ",", "533", ",", "535", ",", "448", ",", 
      "13", ",", "538", ",", "539", ",", "541", ",", "542", ",", "543", ",", 
      "437", ",", "545", ",", "457", ",", "55", ",", "547", ",", "190", ",", 
      "548", ",", "550", ",", "552", ",", "450", ",", "554", ",", "555", ",", 
      "556", ",", "558", ",", "560", ",", "562", ",", "563", ",", "564", ",", 
      "566", ",", "567", ",", "444", ",", "570", ",", "572", ",", "574", ",", 
      "575", ",", "577", ",", "18", ",", "288", ",", "91", ",", "580", ",", 
      "484", ",", "582", ",", "583", ",", "585", ",", "587", ",", "588", ",", 
      "590", ",", "455", ",", "592", ",", "593", ",", "595", ",", "408", ",", 
      "78", ",", "373", ",", "597", ",", "598", ",", "50", ",", "599", ",", 
      "600", ",", "601", ",", "429", ",", "452", ",", "603", ",", "605", ",", 
      "169", ",", "255", ",", "607", ",", "209", ",", "165", ",", "610", ",", 
      "611", ",", "613", ",", "62", ",", "349", ",", "615", ",", "303", ",", 
      "617", ",", "385", ",", "618", ",", "34", ",", "620", ",", "506", ",", 
      "222", ",", "622", ",", "623", ",", "465", ",", "488", ",", "624", ",", 
      "626", ",", "627", ",", "413", ",", "293", ",", "116", ",", "399", ",", 
      "630", ",", "416", ",", "410", ",", "236", ",", "633", ",", "635", ",", 
      "636", ",", "637", ",", "639", ",", "640", ",", "642", ",", "569", ",", 
      "281", ",", "643", ",", "644", ",", "594", ",", "645", ",", "646", ",", 
      "232", ",", "648", ",", "649", ",", "650", ",", "652", ",", "653", ",", 
      "655", ",", "656", ",", "183", ",", "658", ",", "557", ",", "103", ",", 
      "659", ",", "660", ",", "421", ",", "508", ",", "540", ",", "662", ",", 
      "663", ",", "664", ",", "665", ",", "666", ",", "661", ",", "516", ",", 
      "667", ",", "608", ",", "668", ",", "669", ",", "250", ",", "670", ",", 
      "671", ",", "672", ",", "94", ",", "674", ",", "480", ",", "675", ",", 
      "677", ",", "678", ",", "680", ",", "681", ",", "467", ",", "683", ",", 
      "684", ",", "685", ",", "686", ",", "383", ",", "687", ",", "657", ",", 
      "689", ",", "690", ",", "307", ",", "691", ",", "692", ",", "679", ",", 
      "241", ",", "621", ",", "695", ",", "696", ",", "651", ",", "474", ",", 
      "604", ",", "699", ",", "371", ",", "700", ",", "701", ",", "203", ",", 
      "702", ",", "703", ",", "596", ",", "705", ",", "499", ",", "706", ",", 
      "707", ",", "26", ",", "708", ",", "124", ",", "426", ",", "710", ",", 
      "146", ",", "711", ",", "712", ",", "713", ",", "714", ",", "581", ",", 
      "716", ",", "718", ",", "719", ",", "573", ",", "576", ",", "546", ",", 
      "721", ",", "722", ",", "723", ",", "724", ",", "561", ",", "497", ",", 
      "403", ",", "725", ",", "726", ",", "344", ",", "586", ",", "682", ",", 
      "154", ",", "729", ",", "359", ",", "731", ",", "632", ",", "188", ",", 
      "733", ",", "734", ",", "571", ",", "491", ",", "735", ",", "253", ",", 
      "334", ",", "737", ",", "738", ",", "532", ",", "739", ",", "740", ",", 
      "741", ",", "325", ",", "536", ",", "96", ",", "742", ",", "743", ",", 
      "744", ",", "612", ",", "747", ",", "364", ",", "748", ",", "647", ",", 
      "495", ",", "578", ",", "432", ",", "750", ",", "751", ",", "752", ",", 
      "753", ",", "419", ",", "754", ",", "619", ",", "755", ",", "277", ",", 
      "756", ",", "757", ",", "758", ",", "244", ",", "614", ",", "759", ",", 
      "609", ",", "141", ",", "760", ",", "513", ",", "761", ",", "602", ",", 
      "762", ",", "534", ",", "763", ",", "544", ",", "727", ",", "764", ",", 
      "57", ",", "766", ",", "768", ",", "769", ",", "728", ",", "771", ",", 
      "393", ",", "772", ",", "311", ",", "774", ",", "321", ",", "510", ",", 
      "226", ",", "776", ",", "698", ",", "114", ",", "777", ",", "171", ",", 
      "463", ",", "553", ",", "779", ",", "780", ",", "478", ",", "629", ",", 
      "730", ",", "781", ",", "186", ",", "356", ",", "606", ",", "775", ",", 
      "64", ",", "641", ",", "212", ",", "152", ",", "787", ",", "74", ",", 
      "788", ",", "790", ",", "47", ",", "487", ",", "162", ",", "792", ",", 
      "521", ",", "591", ",", "525", ",", "676", ",", "782", ",", "717", ",", 
      "111", ",", "551", ",", "565", ",", "796", ",", "797", ",", "778", ",", 
      "794", ",", "391", ",", "800", ",", "297", ",", "802", ",", "127", ",", 
      "732", ",", "589", ",", "803", ",", "704", ",", "791", ",", "631", ",", 
      "628", ",", "537", ",", "217", ",", "439", ",", "220", ",", "328", ",", 
      "616", ",", "529", ",", "806", ",", "785", ",", "783", ",", "799", ",", 
      "275", ",", "318", ",", "129", ",", "801", ",", "805", ",", "715", ",", 
      "60", ",", "476", ",", "767", ",", "784", ",", "745", ",", "524", ",", 
      "688", ",", "786", ",", "316", ",", "808", ",", "559", ",", "693", ",", 
      "811", ",", "625", ",", "813", ",", "673", ",", "814", ",", "401", ",", 
      "549", ",", "815", ",", "809", ",", "295", ",", "638", ",", "694", ",", 
      "789", ",", "793", ",", "773", ",", "634", ",", "807", ",", "749", ",", 
      "812", ",", "746", ",", "817", ",", "795", ",", "584", ",", "709", ",", 
      "330", ",", "736", ",", "654", ",", "818", ",", "579", ",", "720", ",", 
      "765", ",", "376", ",", "770", ",", "804", ",", "697", ",", "816", ",", 
      "568", ",", "798", ",", "810", ",", "819"}], "}"}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->
  "In[259]:=",ExpressionUUID->"f3822196-30b2-4e9b-bb6f-af382ffe47af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermDeg", "/@", 
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}]}]], "Input",
 CellLabel->
  "In[261]:=",ExpressionUUID->"e6a43e6f-5779-4512-af5d-bef784d7b664"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"819", ",", "818"}], "}"}]], "Output",
 CellLabel->
  "Out[261]=",ExpressionUUID->"e51338c3-0b77-40a0-962d-69410e5e5e7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myTiming", "[", 
  RowBox[{
   RowBox[{"T3D4SGS", "=", 
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{"g1", ",", "g2"}], "]"}], ",", "819"}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->
  "In[262]:=",ExpressionUUID->"e4080953-dcde-4158-8adf-847bf3bf6f40"],

Cell[BoxData[
 RowBox[{"4.802477`6.83198029144964", " ", "Second"}]], "Print",
 CellLabel->
  "During evaluation of \
In[262]:=",ExpressionUUID->"4ab021fc-4f69-4032-862e-e2b0214d644a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", "T3D4SGS"}]], "Input",
 CellLabel->
  "In[263]:=",ExpressionUUID->"ea6439df-df33-4648-bdef-1320b07e65c0"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{"5", ",", "14"}], "]"}]], "Output",
 CellLabel->
  "Out[263]=",ExpressionUUID->"9de36d82-eb2b-427d-8f3a-94d47abc842d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "T3D4SGS", "]"}]], "Input",
 CellLabel->
  "In[264]:=",ExpressionUUID->"48a7daff-87db-4c0b-8107-8ae6e5b5f9f5"],

Cell[BoxData["211341312"], "Output",
 CellLabel->
  "Out[264]=",ExpressionUUID->"9b25c907-8d9a-426f-b5ad-599478135bf1"]
}, Open  ]],

Cell["Go back to the original settings:", "MathCaption",ExpressionUUID->"0e6a4813-7f3b-4835-a5b1-167ad887c57e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Orbit", ",", 
    RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"SchreierSims", ",", 
    RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ";"}]}], "Input",
 CellLabel->
  "In[265]:=",ExpressionUUID->"d701b816-4fc9-465c-807e-56d7d53e6df7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Canonicalization", "Subsection",ExpressionUUID->"4ff88c70-06eb-4b86-bbf5-f623958c8076"],

Cell[CellGroupData[{

Cell["The meaning of canonicalization. Tensor indices and slots", \
"SubsubsectionIcon",ExpressionUUID->"236b19d2-9ac0-4e6d-bb12-cbeec7ab785a"],

Cell[TextData[{
 "Before describing the algorithms for \"canonicalization\" of a permutation \
we want to introduce what we mean by it. Given some equivalence relation \
which decomposes a group of permutations into disjoint classes we want to \
identify uniquely a representative per class. That representative will be \
called the \"canonical representative\" of the class, and the process of \
finding the representative of the class of a given permutation ",
 StyleBox["perm",
  FontSlant->"Italic"],
 " will be referred to as the \"canonicalization\" of ",
 StyleBox["perm",
  FontSlant->"Italic"],
 ". The main criterium for canonicalization is that the identity permutation \
must always be the representative of its class; the secondary criterium will \
choose the permutation which is \"closest\" to the identity. This will be \
done by defining a total ordering among the permutations of the group and \
choosing the smallest permutation of the class. There are many ways to define \
that ordering, with the only restriction that the identity must be always the \
first one in any set containing it. As you can imagine, we will choose an \
ordering based on the base of an SGS describing the full group.\nThe special \
role of the identity poses a small but important problem, because the \
identity is its own inverse. So, given a sorted set of permutations, are \
their inverses automatically sorted with respect to the same ordering? The \
answer is no, and therefore we must always know whether we are sorting the \
permutations themselves or their inverses. Here we shall follow the \
convention in the papers by R. Portugal et al, which are the main source for \
the algorithms implemented here."
}], "Text",ExpressionUUID->"75dca098-de5a-494a-b6fd-17da02d7f5af"],

Cell["\<\
In relation to tensors, this amounts to the following: for example, given the \
collection of sorted indices a,b,c,d,... (renamed as 1,2,3,4,...) Renato says \
that permutation Cycles[{1,3,2,4}] represents the tensor T^{cdba} (at first \
slot we find third index; at third slot we find second index; etc.). The \
opposite view would represent that tensor with the inverse permutation \
Cycles[{1,4,2,3}] (the first index goes to the fourth slot; the fourth index \
goes to the second slot; etc).\
\>", "Text",ExpressionUUID->"40a0b969-0913-4b6d-9b4a-aa0afcf4dce0"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["8. Canonical representative of a right coset", "SubsectionIcon",ExpressionUUID->"a265778e-2b5e-4e13-8280-cb023d9175ba"],

Cell["\<\
Given a permutation g and a group S of permutations we can construct the \
right coset S.g, which is not a group in general. Here we want to choose a \
canonical representant of S.g. `Canonical\.b4 means the first according to a \
given ordering of the points of the \[CapitalOmega] set.  That ordering is \
defined through the base of the SGS.\
\>", "Text",ExpressionUUID->"314172ab-0c82-434f-9158-9cc5c1b849ee"],

Cell["\<\
Suppose a group generated by two permutations. We construct a SGS. Note that \
we can give the first points of the base of the SGS or not:\
\>", "MathCaption",ExpressionUUID->"87e19719-8f49-430f-b11d-3c6e23eae8e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS1", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], 
          "}"}], "]"}], ",", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], 
          "}"}], "]"}]}], "]"}], ",", "6"}], "]"}], ",", "Perm"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.44794547353012*^9, 3.447945483085292*^9}},
 CellLabel->
  "In[267]:=",ExpressionUUID->"24eff7da-f61a-4c64-a3d2-29cba97e5ffc"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], "}"}],
       "]"}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[267]=",ExpressionUUID->"a74e2240-b351-4978-89a9-93353ef61f8a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGS2", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"SchreierSims", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], 
          "}"}], "]"}], ",", 
        RowBox[{"Perm", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], 
          "}"}], "]"}]}], "]"}], ",", "6"}], "]"}], ",", "Perm"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.447945485698738*^9, 3.4479454915290194`*^9}},
 CellLabel->
  "In[268]:=",ExpressionUUID->"a3c80aaf-db50-4f42-9a8c-8cd8c343d620"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], "}"}],
       "]"}], ",", 
     RowBox[{"Perm", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], "}"}],
       "]"}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[268]=",ExpressionUUID->"5a9905bd-ef08-43ee-a108-30af8f3d69bc"]
}, Open  ]],

Cell["\<\
The group generated by those SGSs has order 8 and therefore there are 90 \
cosets of that group in S6:\
\>", "MathCaption",ExpressionUUID->"63adf1fb-9fe6-434d-890f-e98df666a8fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderOfGroup", "[", "SGS1", "]"}]], "Input",
 CellLabel->
  "In[269]:=",ExpressionUUID->"f64245b9-98ea-49e5-8ee0-c80863652b36"],

Cell[BoxData["8"], "Output",
 CellLabel->
  "Out[269]=",ExpressionUUID->"b7e788d0-fd75-4686-a0f4-078029a80101"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"group", "=", 
  RowBox[{"Dimino", "[", 
   RowBox[{"SGS1", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4479454138159523`*^9, 3.4479454241773252`*^9}},
 CellLabel->
  "In[270]:=",ExpressionUUID->"59ebf7a3-65e9-442a-ba23-1385f16b71ad"],

Cell[BoxData[
 RowBox[{"Group", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2", ",", "1", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "1", ",", "2", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2", ",", "1", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "4", ",", "3", ",", "5", ",", "6"}], "}"}], 
    "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[270]=",ExpressionUUID->"7bc50acd-77d6-429f-8999-a53557cdf8ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"6", "!"}], "/", "8"}]], "Input",
 CellLabel->
  "In[271]:=",ExpressionUUID->"2acd7df0-9b03-405f-9262-1be1da852e24"],

Cell[BoxData["90"], "Output",
 CellLabel->
  "Out[271]=",ExpressionUUID->"e2048e7d-6530-4cb4-bd2f-6bde3c4181e2"]
}, Open  ]],

Cell["\<\
Now we take one permutation which does not belong to the group and construct \
the corresponding right coset, sorting the permutations:\
\>", "MathCaption",ExpressionUUID->"4e326b5b-4d32-4e21-afdc-7a47e9b99789"],

Cell[BoxData[
 RowBox[{
  RowBox[{"perm", "=", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4479454339280252`*^9, 3.447945465325028*^9}},
 CellLabel->
  "In[272]:=",ExpressionUUID->"ec9ef587-fbf7-44c3-a615-345ddf878539"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermMemberQ", "[", 
  RowBox[{"perm", ",", "SGS1"}], "]"}]], "Input",
 CellLabel->
  "In[273]:=",ExpressionUUID->"7688a9b2-6960-47d1-9ce4-ab80bce26a2f"],

Cell[BoxData["False"], "Output",
 CellLabel->
  "Out[273]=",ExpressionUUID->"be3d9ef8-7a9d-43e0-b598-20d6fe475f33"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coset", "=", 
  RowBox[{"PermProduct", "[", 
   RowBox[{"group", ",", "perm"}], "]"}]}]], "Input",
 CellLabel->
  "In[274]:=",ExpressionUUID->"15257a5d-1f8b-4b78-bf92-18f2e645c832"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "1", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4", ",", "2", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3", ",", "5", ",", "6"}], "}"}], 
    "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[274]=",ExpressionUUID->"0c034aa1-2cf6-49f2-8369-da8cdcae6840"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", "coset", "]"}]], "Input",
 CellLabel->
  "In[275]:=",ExpressionUUID->"18f8f9ff-6f2a-4fdc-9f22-1994c6db83e5"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4", ",", "2", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "1", ",", "6", ",", "5"}], "}"}], 
    "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[275]=",ExpressionUUID->"33d6f2c0-b4ea-4227-88b1-14c3585ff412"]
}, Open  ]],

Cell[TextData[{
 "The sorting is only evident in ",
 StyleBox["Images",
  FontFamily->"Courier"],
 " notation. The first permutation is our canonical representative:"
}], "MathCaption",ExpressionUUID->"dbee0d35-c9d9-42ce-9edc-aa8ba29d4b8e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TranslatePerm", "[", 
    RowBox[{"#", ",", "Images"}], "]"}], "&"}], "/@", "%"}]], "Input",
 CellLabel->
  "In[276]:=",ExpressionUUID->"42d9cefe-2bb4-4f02-9683-9a1b4d928d49"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "3", ",", "1", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4", ",", "2", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "1", ",", "3", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "1", ",", "6", ",", "5"}], "}"}], 
    "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[276]=",ExpressionUUID->"d2d7c893-66b6-4a09-8c72-17984cfc4ced"]
}, Open  ]],

Cell["It can also be computed using Portugal's algorithms.", "MathCaption",ExpressionUUID->"6cd03c89-6f8f-4166-9419-b705c6497511"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RightCosetRepresentative", "[", 
  RowBox[{"perm", ",", "6", ",", "SGS1"}], "]"}]], "Input",
 CellLabel->
  "In[277]:=",ExpressionUUID->"3dd22d53-0f31-4f9e-a0c7-7494454ee489"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->
  "Out[277]=",ExpressionUUID->"290e7177-047f-4630-a037-e49769f49dbb"]
}, Open  ]],

Cell["\<\
There is an additional argument which assigns special priority to some points \
(\"free slots\" below). The default is Range[deg], assigning that special \
priority to all points (\"all slots are free\"):\
\>", "MathCaption",ExpressionUUID->"515b26d1-96e1-4304-b38b-3a870d24b743"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RightCosetRepresentative", "[", 
  RowBox[{"perm", ",", "6", ",", "SGS1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[278]:=",ExpressionUUID->"3d447ac0-2ea0-4a15-a776-5c64057208bf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellLabel->
  "Out[278]=",ExpressionUUID->"137c4bd9-c044-4a89-aaee-6715b5adca4a"]
}, Open  ]],

Cell["\<\
Together with the canonical representative, the algorithm returns a SGS for \
the stabilizer of the special points, and the new positions of the special \
points under the change of coset element (performed by the permutation h in G \
taking the old permutation to the new permutation):\
\>", "MathCaption",ExpressionUUID->"23a31183-d619-446b-b057-6d096847adf5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RightCosetRepresentative", "[", 
  RowBox[{"perm", ",", "6", ",", "SGS1", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[279]:=",ExpressionUUID->"8fa833e8-4e12-45c7-b1bb-e5cf3a60ce8a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"Perm", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "6", ",", "5"}], 
        "}"}], "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->
  "Out[279]=",ExpressionUUID->"47e33fc3-eaf7-45c6-8210-bb18a7a8392f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"PermProduct", "[", 
   RowBox[{
    RowBox[{"First", "[", "%", "]"}], ",", 
    RowBox[{"InversePerm", "[", "perm", "]"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[280]:=",ExpressionUUID->"0928ad5e-a9bb-450d-bf38-79ad437b58a1"],

Cell[BoxData[
 RowBox[{"Perm", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "4", ",", "1", ",", "2", ",", "5", ",", "6"}], "}"}], 
  "]"}]], "Output",
 CellLabel->
  "Out[280]=",ExpressionUUID->"e4549eb3-a450-43c5-9ced-686a262eeb07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OnPoints", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], ",", "h"}], "]"}]], "Input",
 CellLabel->
  "In[281]:=",ExpressionUUID->"86848e96-d666-407a-bcc0-27d3a98eb15f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Output",
 CellLabel->
  "Out[281]=",ExpressionUUID->"95666fb8-c3e9-4095-9e1c-643650f12f8c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "h", "]"}]], "Input",
 CellLabel->
  "In[282]:=",ExpressionUUID->"8bbee783-0c48-4d00-bd6a-294e82799250"],

Cell[TextData[{
 "It is important to stress that ",
 StyleBox["PermSort",
  FontFamily->"Courier"],
 " uses by default the trivial ordering of points {1, 2, 3,...}, which in \
this case coincide with the base of SGS1. However, if we want to use other \
bases, then we need a second argument:"
}], "MathCaption",ExpressionUUID->"9dfa7939-01b8-4e55-be5c-f5a6e2975e32"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermSort", "[", 
  RowBox[{"coset", ",", 
   RowBox[{"SGS2", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[283]:=",ExpressionUUID->"8452f0ef-8dd8-49f8-8d96-12b0d1db2ede"],

Cell[BoxData[
 RowBox[{"Coset", "[", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "2", ",", "3", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "1", ",", "3", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4", ",", "2", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "3", ",", "2", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "4", ",", "1", ",", "5", ",", "6"}], "}"}], 
    "]"}], ",", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "3", ",", "1", ",", "6", ",", "5"}], "}"}], 
    "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[283]=",ExpressionUUID->"5e7615da-e479-487f-800e-8f9259c3ad90"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RightCosetRepresentative", "[", 
  RowBox[{"perm", ",", "6", ",", "SGS2"}], "]"}]], "Input",
 CellLabel->
  "In[284]:=",ExpressionUUID->"dfb74d24-cbeb-4e8b-9244-676265945b79"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->
  "Out[284]=",ExpressionUUID->"7ecbe2da-1995-474e-8297-5c99d355eb3b"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PermSort",
  FontFamily->"Courier"],
 " with a base uses the ordering given by ",
 StyleBox["PermOrderedQ",
  FontFamily->"Courier"],
 ". In any case the identity must always be the least permutation. Here we \
check that all permutations of degree four with all bases come after the \
identity:"
}], "MathCaption",ExpressionUUID->"48700219-e143-4068-9566-fc0a99ed941f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Outer", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"PermOrderedQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"ID", ",", 
          RowBox[{"Perm", "[", "#1", "]"}]}], "}"}], ",", "#2"}], "]"}], 
      "&"}], ",", 
     RowBox[{"Drop", "[", 
      RowBox[{
       RowBox[{"Permutations", "@", 
        RowBox[{"Range", "[", "4", "]"}]}], ",", "1"}], "]"}], ",", 
     RowBox[{"Permutations", "@", 
      RowBox[{"Range", "[", "4", "]"}]}], ",", "1"}], "]"}], "]"}]}]], "Input",\

 CellLabel->
  "In[285]:=",ExpressionUUID->"0c0f0a64-ea77-4783-a415-48e0feece673"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[285]=",ExpressionUUID->"ae27011c-8a0e-4000-a472-ce37c41fbb8d"]
}, Open  ]],

Cell[TextData[{
 "It is possible to follow the internals of ",
 StyleBox["CosetRepresentative",
  FontFamily->"Courier"],
 " using the option ",
 StyleBox["xPermVerbose",
  FontFamily->"Courier"],
 ". Note that we use the terminology of tensor computations (tensor, slots, \
indices, etc.):"
}], "MathCaption",ExpressionUUID->"d1c5f86f-1156-4f5b-a98c-305590620551"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RightCosetRepresentative", "[", 
  RowBox[{"perm", ",", "6", ",", "SGS2", ",", 
   RowBox[{"Range", "[", "6", "]"}], ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[286]:=",ExpressionUUID->"25ca32cc-ffc1-4580-893e-15bad99f603b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"RIGHT-COSET-REPRESENTATIVE ALGORITHM for \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}],
  SequenceForm["RIGHT-COSET-REPRESENTATIVE ALGORITHM for ", 
   xAct`xPerm`Perm[{2, 3, 1, 4, 5, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"fca105c5-36bc-4eb0-ad94-4326c0495041"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"which corresponds to the index list: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}],
  SequenceForm["which corresponds to the index list: ", 
   xAct`xPerm`Perm[{3, 1, 2, 4, 5, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"6eaf2893-1664-4558-b64d-986cff341f6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"base: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["base: ", {1, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"a986235d-eb2f-4694-8168-99f80b719bf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 1, " of base: slot ", 1, " ******"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"fc4d61bb-be29-45db-a583-8e3bf9a4d99b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {1, 2, 3, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"49752565-1f29-49bd-b773-649f31b5bcea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]}],
  SequenceForm["Free slots: ", {1, 2, 3, 4, 5, 6}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"afabea94-3a1d-4d5c-9e86-9ab4fafc739b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {1, 2, 3, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"fe28c260-7685-4b27-aad8-a54d3e534d3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"At those slots we respectively find indices Deltap: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm[
  "At those slots we respectively find indices Deltap: ", {3, 1, 2, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"c8452b0c-fc08-42d7-ac0c-ee7c3014789d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The least index is \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", found at position pk: \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" of Deltap\"\>"}],
  SequenceForm[
  "The least index is ", 1, ", found at position pk: ", 2, " of Deltap"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"bab51776-e000-4946-ab00-781c4c47ae17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"That index is found in tensor at slot pp: \"\>", 
   "\[InvisibleSpace]", "2"}],
  SequenceForm["That index is found in tensor at slot pp: ", 2],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"a160d82f-b745-4e4e-b093-6f22ee3762fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"We can move slot \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" to slot \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" using permutation om: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}], "\[InvisibleSpace]", "\<\" in S\"\>"}],
  SequenceForm[
  "We can move slot ", 2, " to slot ", 1, " using permutation om: ", 
   xAct`xPerm`Perm[{2, 1, 3, 4, 6, 5}], " in S"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"adc29fac-3dae-4759-81e7-54ef156eb0b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New indices list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}]}],
  SequenceForm["New indices list: ", 
   xAct`xPerm`Perm[{1, 3, 2, 4, 6, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"682e2f28-96ad-4c08-9a21-97f0eb97c683"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computing stabilizer in S of slot \"\>", "\[InvisibleSpace]", 
   "1"}],
  SequenceForm["Computing stabilizer in S of slot ", 1],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"fa028bac-b8f1-4d37-9675-d8aeed1ebc2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase before change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["newbase before change: ", {1, 3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"7920f770-c6fa-489b-aba3-ea5b413211d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase after change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "3", "}"}]}],
  SequenceForm["newbase after change: ", {3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"1ff9d20e-3933-40f0-a15b-ac35b7318f90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"****** Analysing element i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" of base: slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" ******\"\>"}],
  SequenceForm[
  "****** Analysing element i=", 2, " of base: slot ", 3, " ******"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"42b4fc0a-31ac-4947-92b7-c3208857e677"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Symmetry orbit Delta of slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Symmetry orbit Delta of slots: ", {3, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"26771284-1806-4a2a-bde0-0b2fb47449c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}]}],
  SequenceForm["Free slots: ", {2, 1, 3, 4, 6, 5}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"730fb917-1ce4-4ceb-ad2f-316921175104"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free slots that can go to that slot: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}],
  SequenceForm["Free slots that can go to that slot: ", {3, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"c134dd9f-cebb-4c90-9f8e-05991a378101"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"At those slots we respectively find indices Deltap: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["At those slots we respectively find indices Deltap: ", {2, 4}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"5779c7d5-5eef-413f-8bff-b32b674ee039"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The least index is \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", found at position pk: \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" of Deltap\"\>"}],
  SequenceForm[
  "The least index is ", 2, ", found at position pk: ", 1, " of Deltap"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"442e2574-a78e-45ae-be64-5f6186f9415f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"That index is found in tensor at slot pp: \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["That index is found in tensor at slot pp: ", 3],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"de253faf-60e3-4a1a-b7b4-083dea925ea3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"We can move slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" to slot \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" using permutation om: \"\>", 
   "\[InvisibleSpace]", "ID", "\[InvisibleSpace]", "\<\" in S\"\>"}],
  SequenceForm[
  "We can move slot ", 3, " to slot ", 3, " using permutation om: ", 
   xAct`xPerm`ID, " in S"],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"32cb49a7-c76e-4266-ae55-48d88144c6bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New indices list: \"\>", "\[InvisibleSpace]", 
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}]}],
  SequenceForm["New indices list: ", 
   xAct`xPerm`Perm[{1, 3, 2, 4, 6, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"8f7161f6-a1da-4a70-913d-56300abeb27a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computing stabilizer in S of slot \"\>", "\[InvisibleSpace]", 
   "3"}],
  SequenceForm["Computing stabilizer in S of slot ", 3],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"0cd766d1-d945-4b78-8126-b6430cda5785"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase before change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "3", "}"}]}],
  SequenceForm["newbase before change: ", {3}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"67112b96-c061-4f1f-a098-4f9a861732dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"newbase after change: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["newbase after change: ", {}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[286]:=",ExpressionUUID->"fe38b342-05fb-411d-9fe9-3b54dd5205f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Perm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3", ",", "2", ",", "4", ",", "6", ",", "5"}], "}"}], 
    "]"}], ",", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->
  "Out[286]=",ExpressionUUID->"d49ba32b-d051-4f48-87b3-3bb95979d769"]
}, Open  ]],

Cell[TextData[{
 StyleBox["RightCosetRepresentative\t\t\t", "DisplayMath"],
 StyleBox["Compute a canonical representative of a coset", "Text"]
}], "DefinitionBox",ExpressionUUID->"daa0b8bf-3f8b-411a-8915-5258f8d42fa7"],

Cell["Canonicalization of free indices.", "SmallText",ExpressionUUID->"c38e3a2a-c385-4303-a2c7-b3d24b9b264c"]
}, Closed]],

Cell[CellGroupData[{

Cell["9. Canonical representative of a double coset", "SubsectionIcon",ExpressionUUID->"4b4a6e54-e6d3-4a5f-868a-523d8675d77f"],

Cell["\<\
In this and the next section we shall use tensor terminology: the points will \
be either indices or slots, with the convention that the permutation g acts \
on slots and its images are indices. That is, 3^g = 7 will now be read \"the \
third slot contains the seventh index\".\
\>", "Text",ExpressionUUID->"9c18b54d-bc28-41e3-87aa-3304ff708b2d"],

Cell[TextData[{
 "When including dummy indices in a tensor there are two different kinds of \
symmetries: apart from those coming from the intrinsic symmetries of the \
tensor slots (the group S), we have more symmetries due to exchange of names \
of dummy indices and to the exchange of up/down indices of a pair when a \
metric is present (we shall call D the group of those new symmetries). Now we \
need to work with the double coset S.g.D, and again we need to find a \
canonical representative. It is important to note that this code is prepared \
to work only with a special type of group D: that needed to canonicalize \
tensors, and that the S group acts from the left of g while the D group acts \
from the right of g.\nThe most general situation we need to handle for the D \
group is the following:\n\t- We can have dummies coming from several \
different vbundles. The D symmetries cannot mix them and so the D group can \
be reduced as a direct product of smaller groups. Therefore the strong \
generating sets can be easily constructed independently and then joined \
together.\n\t- Inside each vbundle there are two types of \"dummies\": \
pair-dummies, each pair having a S_2 or A_2 group or nothing, and then \
repeated indices, each type of repeated index having a S_n symmetry group, \
with n being the number of times that a given index is repeated. All \
pair-dummies in a vbundle can be exchanged. Therefore the D symmetry group \
for a vbundle is also the product of symmetric and pair-symmetric groups. \
(Note: sometimes I call \"drummies\" the combined type of dummies and \"repes\
\").\nThis is an important simplification because we do not need to worry \
about what is happenning to the generating set of the D group, but only to \
its base. That is, given the base of the D group we know how to construct an \
adequate generating set. This is done using the concepts of ",
 StyleBox["DummySet",
  FontFamily->"Courier"],
 " and ",
 StyleBox["RepeatedSet",
  FontFamily->"Courier"],
 "."
}], "Text",ExpressionUUID->"f8ce0f13-8ba6-4bf8-a908-8aa62520d9af"],

Cell[TextData[{
 "Suppose a tensor with 12 indices where there are 5 pairs of dummies of the \
same vbundle TM. We encode the situation in a ",
 StyleBox["DummySet",
  FontFamily->"Courier"],
 " expression. The first pair {7,11} means that the seventh index in the \
canonical configuration is an up-index paired with the eleventh index (which \
is hence a down-index). The number 0 at the end means that there is no metric:"
}], "MathCaption",ExpressionUUID->"d590f20e-12c0-47b1-9087-2bbcf996325e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dummyset", "=", 
   RowBox[{"DummySet", "[", 
    RowBox[{"TM", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "1"}], "}"}]}], "}"}], ",", "0"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->
  "In[287]:=",ExpressionUUID->"b6895d1e-1dae-4d69-8261-1bf0992b9663"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSOfDummySet", "[", "dummyset", "]"}]], "Input",
 CellLabel->
  "In[288]:=",ExpressionUUID->"f1edb386-1791-4591-ab08-1d2e0d385610"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "4", ",", "10", ",", "8", ",", "12"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "1"}], "}"}]}], "]"}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[288]=",ExpressionUUID->"389e1e1d-04b1-4264-b21e-fa35b8dbe71c"]
}, Open  ]],

Cell["\<\
We include a symmetric metric with a 1 at the end (-1 would give an \
antisymmetric metric):\
\>", "MathCaption",ExpressionUUID->"6420bac4-ff49-4fa7-9685-55cace705bc1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dummyset", "=", 
   RowBox[{"DummySet", "[", 
    RowBox[{"TM", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "1"}], "}"}]}], "}"}], ",", "1"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->
  "In[289]:=",ExpressionUUID->"20e02350-d31d-4367-bca3-c1c7266c8866"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSD", "=", 
  RowBox[{"SGSOfDummySet", "[", "dummyset", "]"}]}]], "Input",
 CellLabel->
  "In[290]:=",ExpressionUUID->"9856fa79-77fc-4338-b7b6-608253723df2"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "4", ",", "10", ",", "8", ",", "12"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"7", ",", "11"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"10", ",", "6"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"8", ",", "9"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"12", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "1"}], "}"}]}], "]"}]}], "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[290]=",ExpressionUUID->"c20d5b99-1e5c-4b9f-a71c-a0c6c656d3c1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"groupD", "=", 
   RowBox[{"Dimino", "[", 
    RowBox[{"TranslatePerm", "[", 
     RowBox[{
      RowBox[{"SGSD", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Images", ",", "12"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",\

 CellLabel->
  "In[291]:=",ExpressionUUID->"0afb6ddb-4f49-42ee-81ab-f7274dcb83d4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "groupD", "]"}]], "Input",
 CellLabel->
  "In[292]:=",ExpressionUUID->"6a12841e-1a98-4330-a2d3-ce4e6e7433ba"],

Cell[BoxData["3840"], "Output",
 CellLabel->
  "Out[292]=",ExpressionUUID->"7951e814-e7ca-4981-b808-9762553ee7cb"]
}, Open  ]],

Cell["\<\
Now suppose this configuration, where the free indices 2 and 3 are at the \
third and fifth slots. The canonicalization process (assuming no additional \
symmetry in the tensor) exchanges the pair {4,5} and changes the pair {10,6} \
with the pair {8,9}. The pair {11,7} is also exchanged. Compare the timing of \
the \"brute-force\" method and that of Portugal's algorithm.\
\>", "MathCaption",ExpressionUUID->"17f560dd-633b-421e-8bb9-244c0fa035db"],

Cell[BoxData[
 RowBox[{
  RowBox[{"perm", "=", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "2", ",", "12", ",", "3", ",", "9", ",", "6", ",", 
      "8", ",", "4", ",", "11", ",", "7", ",", "10"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->
  "In[293]:=",ExpressionUUID->"81507411-4711-4f1f-b97d-41263ba35aaa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"coset", "=", 
   RowBox[{"PermProduct", "[", 
    RowBox[{"perm", ",", "groupD"}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[294]:=",ExpressionUUID->"708dbb67-3005-46e2-bd66-34ee04869585"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "@", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", 
       RowBox[{"First", "[", "coset", "]"}]}], ",", "i"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PermLess", "[", 
          RowBox[{
           RowBox[{"coset", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "p"}], "]"}], ",", 
         RowBox[{
          RowBox[{"p", "=", 
           RowBox[{"coset", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ";", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<Change at i=\>\"", ",", "i", ",", "\"\< to \>\"", ",", "p"}], 
           "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"Length", "@", "coset"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "p"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[295]:=",ExpressionUUID->"e8f40b35-e027-4872-9893-02bd95cb7261"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "2", ",", "12", ",", "3", ",", "9", ",", "6", ",", 
      "8", ",", "4", ",", "7", ",", "11", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 2, " to ", 
   xAct`xPerm`Images[{1, 5, 2, 12, 3, 9, 6, 8, 4, 7, 11, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"e35f5be3-d375-4a4e-907b-60237dd3744a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "9", ",", "6", ",", 
      "8", ",", "5", ",", "11", ",", "7", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 3, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 9, 6, 8, 5, 11, 7, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"d6c1b384-5e29-4103-bf3f-4746eddcced7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "9", ",", "6", ",", 
      "8", ",", "5", ",", "7", ",", "11", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 4, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 9, 6, 8, 5, 7, 11, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"5cac4b64-d111-4873-8752-3f3c9872e735"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "8", ",", "6", ",", 
      "9", ",", "5", ",", "11", ",", "7", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 11, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 8, 6, 9, 5, 11, 7, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"87dd6a6e-4a74-425f-8057-16ab4db8eb62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "8", ",", "6", ",", 
      "9", ",", "5", ",", "7", ",", "11", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 12, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 8, 6, 9, 5, 7, 11, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"3e181737-0a1f-4867-a1bf-1d62f8d73345"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "195", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "6", ",", "9", ",", 
      "10", ",", "5", ",", "11", ",", "7", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 195, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 6, 9, 10, 5, 11, 7, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"0b277d8e-6984-494c-8bfe-ad5329d8b8b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "196", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "6", ",", "9", ",", 
      "10", ",", "5", ",", "7", ",", "11", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 196, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 6, 9, 10, 5, 7, 11, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"512048db-0dc7-49af-a47e-b346c9a36a69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "199", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "6", ",", "8", ",", 
      "10", ",", "5", ",", "11", ",", "7", ",", "9"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 199, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 6, 8, 10, 5, 11, 7, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"5368956c-6e62-4228-831c-089390628d06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "200", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "6", ",", "8", ",", 
      "10", ",", "5", ",", "7", ",", "11", ",", "9"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 200, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 6, 8, 10, 5, 7, 11, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"8894bf59-d095-4336-8595-1850936eac3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "359", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "6", ",", "7", ",", 
      "10", ",", "5", ",", "9", ",", "8", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 359, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 6, 7, 10, 5, 9, 8, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"1c0c094d-e972-4a0a-8a82-5929a88f8e76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "360", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "6", ",", "7", ",", 
      "10", ",", "5", ",", "8", ",", "9", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 360, " to ", 
   xAct`xPerm`Images[{1, 4, 2, 12, 3, 6, 7, 10, 5, 8, 9, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[295]:=",ExpressionUUID->"efca8420-e945-4f64-93e6-a0857baeaf5a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.27877200000000001978150976356118917465`5.4658490641397295", ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "6", ",", "7", ",", 
      "10", ",", "5", ",", "8", ",", "9", ",", "11"}], "}"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->
  "Out[295]=",ExpressionUUID->"0118060f-d561-47f3-9c22-6a1892a456d5"]
}, Open  ]],

Cell["\<\
The base for sorting of permutations is taken from the SGS of group S. If the \
base does not include all positions of dummies, then it is expanded to cover \
them all, sorting the missing dummies.\
\>", "MathCaption",ExpressionUUID->"27dd0914-10b3-42e1-afda-705b22470a1f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "@", 
  RowBox[{"DoubleCosetRepresentative", "[", 
   RowBox[{"perm", ",", "12", ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
    RowBox[{"{", "dummyset", "}"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[296]:=",ExpressionUUID->"c6fe0830-88f2-4499-949d-fd0fe2bd48ee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.05273900000000000115596421323971298989`4.742731804027156", ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "12", ",", "3", ",", "6", ",", "7", ",", 
      "10", ",", "5", ",", "8", ",", "9", ",", "11"}], "}"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->
  "Out[296]=",ExpressionUUID->"77b06926-5464-422e-a879-37a2a5d2a7cf"]
}, Open  ]],

Cell["The external C code would be even faster.", "MathCaption",ExpressionUUID->"b0710b03-0e6e-48b4-b6a7-baee3e36c6d5"],

Cell[TextData[{
 StyleBox["DummySet\t\t\t\t\t", "DisplayMath"],
 StyleBox["Head for a set of dummy indices\n", "Text"],
 StyleBox["RepeatedSet\t\t\t\t\t", "DisplayMath"],
 StyleBox["Head for a set of repeated indices\n", "Text"],
 StyleBox["SGSOfDummySet\t\t\t\t", "DisplayMath"],
 StyleBox["Compute SGS for the group associated to a set of dummy indices\n", 
  "Text"],
 StyleBox["DoubleCosetRepresentative\t", "DisplayMath"],
 StyleBox["Compute a canonical representative of a double coset", "Text"]
}], "DefinitionBox",ExpressionUUID->"d98a5496-941c-472c-8fbb-7ed284446fa5"],

Cell["Canonicalization of dummy and repeated indices.", "SmallText",ExpressionUUID->"e6d7cd78-d07e-421a-a26a-98307aaa7b51"]
}, Closed]],

Cell[CellGroupData[{

Cell["10. Canonical permutation", "SubsectionIcon",ExpressionUUID->"c69f9be8-5879-47c5-9544-feab4dd4c115"],

Cell["\<\
Finally, we give an algorithm that canonicalize simultaneously the free and \
the dummy/repeated indices. The algorithm always canonicalizes first the free \
indices and then the dummy/repeated indices.\
\>", "Text",ExpressionUUID->"68131c1c-d7f8-4d2c-a27b-2acc9da15332"],

Cell["\<\
Portugal's example in paper II. Suppose a tensor with 12 indices whose \
index-configuration is described by the following permutation:\
\>", "MathCaption",ExpressionUUID->"ce8f605e-d710-49a5-a5b4-b2261e2192de"],

Cell[BoxData[
 RowBox[{
  RowBox[{"perm", "=", 
   RowBox[{"Cycles", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "12", ",", "11", ",", "4", ",", "5", ",", "6", ",", "8", ",", 
      "9", ",", "10", ",", "7", ",", "3"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[297]:=",ExpressionUUID->"6f2b8bf0-4f26-473a-a17c-aad921d11b27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  RowBox[{"perm", ",", "Images"}], "]"}]], "Input",
 CellLabel->
  "In[298]:=",ExpressionUUID->"fb3a81b3-5082-4df6-ac31-154213942ca7"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{
   "12", ",", "2", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", "9",
     ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]], "Output",
 CellLabel->
  "Out[298]=",ExpressionUUID->"9b4abd7d-5ee2-4796-8166-f739b4e76e69"]
}, Open  ]],

Cell["The symmetries of the tensor are described by this GS:", "MathCaption",ExpressionUUID->"c54edf6c-ab6a-4b88-8618-256d9ad3a6a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GS", "=", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"7", ",", "8"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"9", ",", "10"}], "}"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"11", ",", "12"}], "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "12"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Cycles", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "12"}], "}"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[299]:=",ExpressionUUID->"534e3833-6fad-4f5f-88ac-fd5f560b1c22"],

Cell[TextData[{
 "1) Canonical configuration assuming that all indices are free (empty ",
 StyleBox["DummySet/RepeatedSet",
  FontFamily->"Courier"],
 " expressions):"
}], "MathCaption",ExpressionUUID->"313082cb-1216-49d6-83a3-c4aa6aac4527"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanonicalPerm", "[", 
  RowBox[{"perm", ",", "12", ",", "GS", ",", 
   RowBox[{"Range", "[", "12", "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"TimeVerbose", "\[Rule]", "True"}], ",", 
   RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->
  "In[300]:=",ExpressionUUID->"b118b57f-68b3-4dc3-8984-00f3ea47a131"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SGS for group of order \"\>", "\[InvisibleSpace]", "1024", 
   "\[InvisibleSpace]", "\<\" computed in \"\>", "\[InvisibleSpace]", 
   "0.5773679999999999`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm[
  "SGS for group of order ", 1024, " computed in ", 0.5773679999999999, 
   " secs."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[300]:=",ExpressionUUID->"0ebd8e4b-a865-41bc-817c-3fe215be4f0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free algorithm applied in \"\>", "\[InvisibleSpace]", 
   "0.012242999999998005`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm["Free algorithm applied in ", 0.012242999999998005`, " secs."],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[300]:=",ExpressionUUID->"dd801899-5c5f-4a46-a34f-f24aa10ea33f"],

Cell[BoxData[
 RowBox[{"Cycles", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "12", ",", "10", ",", "11", ",", "7", ",", "6", ",", "9"}], 
    "}"}]}], "]"}]], "Output",
 CellLabel->
  "Out[300]=",ExpressionUUID->"de257b64-0c31-4b2e-be97-eba75f4fcdb6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  RowBox[{"%", ",", "Images"}], "]"}]], "Input",
 CellLabel->
  "In[301]:=",ExpressionUUID->"cad58b04-f539-4e0e-973e-24bb82a4b6d4"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "5", ",", "2", ",", "12", ",", "3", ",", "9", ",", "6", ",", "8",
     ",", "4", ",", "11", ",", "7", ",", "10"}], "}"}], "]"}]], "Output",
 CellLabel->
  "Out[301]=",ExpressionUUID->"3fda665e-8c95-4e47-b166-fc458b978126"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanonicalPerm", "[", 
  RowBox[{"perm", ",", "12", ",", "GS", ",", 
   RowBox[{"Range", "[", "12", "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[302]:=",ExpressionUUID->"287f2852-e4fe-4fa9-8077-67a15c3e8f26"],

Cell[BoxData[
 RowBox[{"Images", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "5", ",", "2", ",", "12", ",", "3", ",", "9", ",", "6", ",", "8",
     ",", "4", ",", "11", ",", "7", ",", "10"}], "}"}], "]"}]], "Output",
 CellLabel->
  "Out[302]=",ExpressionUUID->"bda0d5d6-000f-4d3a-88cf-c426bbdeec0d"]
}, Open  ]],

Cell[TextData[{
 "Let us check that this is the smallest permutation in the right coset S.g. \
We work in ",
 StyleBox["Images",
  FontFamily->"Courier"],
 " notation because only then the sorting process is apparent:"
}], "MathCaption",ExpressionUUID->"1ce0b9ef-3fe4-4a35-be29-ccc38042f7bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"groupS", "=", 
   RowBox[{"Dimino", "[", 
    RowBox[{"TranslatePerm", "[", 
     RowBox[{"GS", ",", 
      RowBox[{"{", 
       RowBox[{"Images", ",", "12"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",\

 CellLabel->
  "In[303]:=",ExpressionUUID->"80ef7555-ad7e-4cbe-9cfa-ab4c6fa684a9"],

Cell[BoxData["1024"], "Output",
 CellLabel->
  "Out[303]=",ExpressionUUID->"a4f0f6da-afe4-40e1-92d4-f3ba57028755"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"g", "=", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{"perm", ",", "Images"}], "]"}]}], ",", "ming", ",", "gg"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ming", "=", "g"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"gg", "=", 
         RowBox[{"PermProduct", "[", 
          RowBox[{
           RowBox[{"groupS", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", "g"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"PermLess", "[", 
           RowBox[{"gg", ",", "ming"}], "]"}], ",", 
          RowBox[{
           RowBox[{"ming", "=", "gg"}], ";", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<Change at i=\>\"", ",", "i", ",", "\"\< to \>\"", ",", 
             "ming"}], "]"}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "groupS", "]"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "ming"}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->
  "In[304]:=",ExpressionUUID->"041f1c94-977e-442e-b0ee-872ca3790161"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "12", ",", "5", ",", "1", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 4, " to ", 
   xAct`xPerm`Images[{2, 12, 5, 1, 6, 8, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"f5e9c301-0e74-4867-8880-ead82d5e73f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "12", ",", "1", ",", "5", ",", "8", ",", "6", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 6, " to ", 
   xAct`xPerm`Images[{2, 12, 1, 5, 8, 6, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"80f8dc1b-818f-427b-9aa3-03ec62a5af12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "12", ",", "1", ",", "5", ",", "6", ",", "8", ",", "9", ",", 
      "3", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 10, " to ", 
   xAct`xPerm`Images[{2, 12, 1, 5, 6, 8, 9, 3, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"364c3c0c-d764-4388-966e-9bd3b8260549"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "12", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "7", ",", "10", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 18, " to ", 
   xAct`xPerm`Images[{2, 12, 1, 5, 6, 8, 3, 9, 7, 10, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"238a4cc2-f22d-4b04-874a-a7bafd432170"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "12", ",", "2", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, " to ", 
   xAct`xPerm`Images[{1, 5, 12, 2, 6, 8, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"22e2311d-6bdf-401d-bbdd-62d3c868673d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "2", ",", "12", ",", "8", ",", "6", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 71, " to ", 
   xAct`xPerm`Images[{1, 5, 2, 12, 8, 6, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"84ee2e1e-10e7-4c76-aeb3-94fe74a33212"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "75", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "2", ",", "12", ",", "6", ",", "8", ",", "9", ",", 
      "3", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 75, " to ", 
   xAct`xPerm`Images[{1, 5, 2, 12, 6, 8, 9, 3, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"7de4ac4a-0a5f-4e66-a782-d7ca446fca25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "83", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "2", ",", "12", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "7", ",", "10", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 83, " to ", 
   xAct`xPerm`Images[{1, 5, 2, 12, 6, 8, 3, 9, 7, 10, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"f53910ff-a8e1-478c-a92d-66d1edbe6abe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "203", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "2", ",", "12", ",", "3", ",", "9", ",", "8", ",", 
      "6", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 203, " to ", 
   xAct`xPerm`Images[{1, 5, 2, 12, 3, 9, 8, 6, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"a6eaeeb4-c9bd-4887-979a-b1e871a88231"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "211", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "2", ",", "12", ",", "3", ",", "9", ",", "6", ",", 
      "8", ",", "7", ",", "10", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 211, " to ", 
   xAct`xPerm`Images[{1, 5, 2, 12, 3, 9, 6, 8, 7, 10, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"68681721-fcd4-4e3b-a006-20ba0cc370dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "483", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "2", ",", "12", ",", "3", ",", "9", ",", "6", ",", 
      "8", ",", "4", ",", "11", ",", "7", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 483, " to ", 
   xAct`xPerm`Images[{1, 5, 2, 12, 3, 9, 6, 8, 4, 11, 7, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[304]:=",ExpressionUUID->"3fa3dbce-7544-4977-91bd-6de0ad42a184"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.13878599999999999270450246058317134157`5.162945572270206", ",", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "2", ",", "12", ",", "3", ",", "9", ",", "6", ",", 
      "8", ",", "4", ",", "11", ",", "7", ",", "10"}], "}"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->
  "Out[304]=",ExpressionUUID->"83c9a00a-2732-406d-9a8b-af94dee7a211"]
}, Open  ]],

Cell["\<\
2) Now suppose that indices 1,2 (in the canonical list) are free while the \
others are contracted as given by the list of pairs or slots \
{{3,4},{5,6},{7,8},{9,10},{11,12}}. The canonical configuration is (note that \
this is the result quoted by Portugal et al.):\
\>", "MathCaption",ExpressionUUID->"b425167d-9fe4-4213-8fcf-2c09e57766e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanonicalPerm", "[", 
  RowBox[{"perm", ",", "12", ",", "GS", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"DummySet", "[", 
     RowBox[{"M", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"7", ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"9", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"11", ",", "12"}], "}"}]}], "}"}], ",", "1"}], "]"}], "}"}], 
   ",", 
   RowBox[{"TimeVerbose", "\[Rule]", "True"}], ",", 
   RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->
  "In[305]:=",ExpressionUUID->"dbe9fc23-6002-4d0f-b4d5-4855d0eae6ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SGS for group of order \"\>", "\[InvisibleSpace]", "1024", 
   "\[InvisibleSpace]", "\<\" computed in \"\>", "\[InvisibleSpace]", 
   "0.5773549999999972`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm[
  "SGS for group of order ", 1024, " computed in ", 0.5773549999999972, 
   " secs."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[305]:=",ExpressionUUID->"950c50fd-3a88-424a-8cea-e6046b799f59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free algorithm applied in \"\>", "\[InvisibleSpace]", 
   "0.006242000000000303`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm["Free algorithm applied in ", 0.006242000000000303, " secs."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[305]:=",ExpressionUUID->"6754ac49-9a40-44b9-a1c2-f13d24673a40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dummy algorithm applied in \"\>", "\[InvisibleSpace]", 
   "0.07445500000000038`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm["Dummy algorithm applied in ", 0.07445500000000038, " secs."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[305]:=",ExpressionUUID->"245a5b55-dbc8-42b5-ba08-37c4a21b15a0"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "7", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "11"}], "}"}]}], "]"}]}]], "Output",
 CellLabel->
  "Out[305]=",ExpressionUUID->"03859529-ebd6-4176-91ee-7a1e4f2c2b85"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"Images", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[306]:=",ExpressionUUID->"b549be36-ac87-4cec-9520-33fc61d9ed0c"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Images", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
     "11", ",", "6", ",", "10", ",", "8", ",", "12"}], "}"}], 
   "]"}]}]], "Output",
 CellLabel->
  "Out[306]=",ExpressionUUID->"1308f2a7-21c7-4485-a505-bc639170c98b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanonicalPerm", "[", 
  RowBox[{"perm", ",", "12", ",", "GS", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"DummySet", "[", 
     RowBox[{"M", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"7", ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"9", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"11", ",", "12"}], "}"}]}], "}"}], ",", "1"}], "]"}], "}"}], 
   ",", 
   RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[307]:=",ExpressionUUID->"429af4fa-5918-4491-9baa-89e8b34bc4c7"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Images", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
     "11", ",", "6", ",", "10", ",", "8", ",", "12"}], "}"}], 
   "]"}]}]], "Output",
 CellLabel->
  "Out[307]=",ExpressionUUID->"ba89510b-320f-4748-a0f5-a0144b946495"]
}, Open  ]],

Cell["\<\
Note that this permutation is smaller than the one obtained using only the \
right coset S.g. This is obvious because the double coset S.g.D contains the \
right coset S.g. Again, we check that this is the right answer by brute \
force. We construct the SGS of the group D and search for the least of the \
permutations of the double coset S.g.D. Do not evaluate the Module below \
because it takes very long (the cell has been made nonevaluatable):\
\>", "MathCaption",ExpressionUUID->"3cd8cf8c-5420-494b-8da4-078aa8306926"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SGSD", "=", 
  RowBox[{"TranslatePerm", "[", 
   RowBox[{
    RowBox[{"SGSOfDummySet", "[", 
     RowBox[{"DummySet", "[", 
      RowBox[{"M", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "10"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"11", ",", "12"}], "}"}]}], "}"}], ",", "1"}], "]"}], "]"}],
     ",", 
    RowBox[{"{", 
     RowBox[{"Images", ",", "12"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[308]:=",ExpressionUUID->"19aba3b4-da65-4f8a-a6bd-d4de3f3e4c4d"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "7", ",", "9", ",", "11"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "4", ",", "3", ",", "5", ",", "6", ",", "7", ",", 
        "8", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "5", ",", "7", ",", 
        "8", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "8", ",", 
        "7", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
        "8", ",", "10", ",", "9", ",", "11", ",", "12"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
        "8", ",", "9", ",", "10", ",", "12", ",", "11"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "5", ",", "6", ",", "3", ",", "4", ",", "7", ",", 
        "8", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "7", ",", "8", ",", "5", ",", 
        "6", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "9", ",", 
        "10", ",", "7", ",", "8", ",", "11", ",", "12"}], "}"}], "]"}], ",", 
     RowBox[{"Images", "[", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
        "8", ",", "11", ",", "12", ",", "9", ",", "10"}], "}"}], "]"}]}], 
    "]"}]}], "]"}]], "Output",
 CellLabel->
  "Out[308]=",ExpressionUUID->"dfac5d4a-c09f-47d5-9e41-2ce52b9e11a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"groupD", "=", 
   RowBox[{"Dimino", "[", 
    RowBox[{"SGSD", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[309]:=",ExpressionUUID->"1ea8e88d-eb6c-481c-a178-fbac955ee9ed"],

Cell[BoxData["3840"], "Output",
 CellLabel->
  "Out[309]=",ExpressionUUID->"50975641-b311-497a-aabe-5de2d550db42"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"g", "=", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{"perm", ",", "Images"}], "]"}]}], ",", "ming", ",", "gg"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ming", "=", "g"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"gg", "=", 
           RowBox[{"PermProduct", "[", 
            RowBox[{
             RowBox[{"groupS", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "g", ",", 
             RowBox[{"groupD", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"PermLess", "[", 
             RowBox[{"gg", ",", "ming"}], "]"}], ",", 
            RowBox[{
             RowBox[{"ming", "=", "gg"}], ";", 
             RowBox[{"Print", "[", 
              RowBox[{
              "\"\<Change at i=\>\"", ",", "i", ",", "\"\<, j=\>\"", ",", "j",
                ",", "\"\< to \>\"", ",", "ming"}], "]"}]}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Length", "[", "groupD", "]"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "groupS", "]"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "ming"}]}], "]"}], "//", "Timing"}]], "Input",
 Evaluatable->False,
 CellLabel->
  "In[310]:=",ExpressionUUID->"245a4ada-2e7a-4b05-aa54-d5034b463c2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "12", ",", "2", ",", "1", ",", "5", ",", "6", ",", "7", ",", "3", ",", 
      "9", ",", "10", ",", "8", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 5, " to ", 
   Images[{12, 2, 1, 5, 6, 7, 3, 9, 10, 8, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ac75d8f4-f72b-4216-80b1-8c2a0232ab1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 17, " to ", 
   Images[{11, 2, 1, 5, 6, 8, 3, 9, 10, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"6658f8ea-99ac-490f-a450-1dff7e768fa6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "5", ",", "6", ",", "7", ",", "3", ",", 
      "9", ",", "10", ",", "8", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 21, " to ", 
   Images[{11, 2, 1, 5, 6, 7, 3, 9, 10, 8, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"de32b194-062f-444c-8787-db89dcb58b21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "3", ",", "4", ",", "8", ",", "5", ",", 
      "9", ",", "10", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 49, " to ", 
   Images[{11, 2, 1, 3, 4, 8, 5, 9, 10, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ad57bb2d-2dd7-402b-9623-aeba44813bcd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "3", ",", "4", ",", "7", ",", "5", ",", 
      "9", ",", "10", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 53, " to ", 
   Images[{11, 2, 1, 3, 4, 7, 5, 9, 10, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"e914f56f-f23a-4766-b1cf-aef81569a83d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "113", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "7", ",", 
      "9", ",", "10", ",", "5", ",", "8", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 113, " to ", 
   Images[{11, 2, 1, 3, 4, 6, 7, 9, 10, 5, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"d776dbd6-eaa1-439b-8522-029d460b98d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "117", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "7", ",", 
      "9", ",", "10", ",", "6", ",", "8", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 117, " to ", 
   Images[{11, 2, 1, 3, 4, 5, 7, 9, 10, 6, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"c499c843-8008-417c-93e7-2075e093afbf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "769", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "10", ",", "2", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
      "11", ",", "12", ",", "7", ",", "4", ",", "9"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 769, " to ", 
   Images[{10, 2, 1, 5, 6, 8, 3, 11, 12, 7, 4, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"587f7d3f-7437-4aaa-bde9-30d6972b85bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "773", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "10", ",", "2", ",", "1", ",", "5", ",", "6", ",", "7", ",", "3", ",", 
      "11", ",", "12", ",", "8", ",", "4", ",", "9"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 773, " to ", 
   Images[{10, 2, 1, 5, 6, 7, 3, 11, 12, 8, 4, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"55483ba6-24ec-4d2b-a3df-fb48ca3b9be3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "785", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
      "11", ",", "12", ",", "7", ",", "4", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 785, " to ", 
   Images[{9, 2, 1, 5, 6, 8, 3, 11, 12, 7, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"19ea771e-e833-46b0-b1c2-a52ff4b2e0a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "789", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "5", ",", "6", ",", "7", ",", "3", ",", 
      "11", ",", "12", ",", "8", ",", "4", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 789, " to ", 
   Images[{9, 2, 1, 5, 6, 7, 3, 11, 12, 8, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"39d0e689-3c84-4e51-9051-27fd8b87681a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "817", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "3", ",", "4", ",", "8", ",", "5", ",", 
      "11", ",", "12", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 817, " to ", 
   Images[{9, 2, 1, 3, 4, 8, 5, 11, 12, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"fdc18bb5-418d-44f4-a39b-aa0bf4ad6569"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "821", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "3", ",", "4", ",", "7", ",", "5", ",", 
      "11", ",", "12", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 821, " to ", 
   Images[{9, 2, 1, 3, 4, 7, 5, 11, 12, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"2dc400d0-0b52-4d91-86e5-822620dcd17f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "881", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "7", ",", 
      "11", ",", "12", ",", "5", ",", "8", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 881, " to ", 
   Images[{9, 2, 1, 3, 4, 6, 7, 11, 12, 5, 8, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"adc6a379-56c8-495b-8a30-760fb4b6f260"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "885", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "7", ",", 
      "11", ",", "12", ",", "6", ",", "8", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 885, " to ", 
   Images[{9, 2, 1, 3, 4, 5, 7, 11, 12, 6, 8, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"d6865478-9642-401b-adc3-32aefc42fe63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1537", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "8", ",", "2", ",", "1", ",", "5", ",", "6", ",", "10", ",", "3", ",", 
      "11", ",", "12", ",", "9", ",", "4", ",", "7"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1537, " to ", 
   Images[{8, 2, 1, 5, 6, 10, 3, 11, 12, 9, 4, 7}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"0d26ad58-ccba-4c1e-8f39-1fdf057e6612"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1541", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "8", ",", "2", ",", "1", ",", "5", ",", "6", ",", "9", ",", "3", ",", 
      "11", ",", "12", ",", "10", ",", "4", ",", "7"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1541, " to ", 
   Images[{8, 2, 1, 5, 6, 9, 3, 11, 12, 10, 4, 7}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"12e79465-0f8a-4385-b117-4417ee9de326"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1553", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "5", ",", "6", ",", "10", ",", "3", ",", 
      "11", ",", "12", ",", "9", ",", "4", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1553, " to ", 
   Images[{7, 2, 1, 5, 6, 10, 3, 11, 12, 9, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"fac34c74-05dc-4e6b-ad31-79b8ff259ca4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1557", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "5", ",", "6", ",", "9", ",", "3", ",", 
      "11", ",", "12", ",", "10", ",", "4", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1557, " to ", 
   Images[{7, 2, 1, 5, 6, 9, 3, 11, 12, 10, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ffbeaf07-663c-480d-b8ef-01bce2ff98be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1585", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "3", ",", "4", ",", "10", ",", "5", ",", 
      "11", ",", "12", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1585, " to ", 
   Images[{7, 2, 1, 3, 4, 10, 5, 11, 12, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"a850db82-06b6-4ffc-bb95-1bfbbf93367d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1589", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "3", ",", "4", ",", "9", ",", "5", ",", 
      "11", ",", "12", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1589, " to ", 
   Images[{7, 2, 1, 3, 4, 9, 5, 11, 12, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"3ff88c00-b1a2-4fd7-9354-466097f1063d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1649", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "3", ",", "4", ",", "6", ",", "9", ",", 
      "11", ",", "12", ",", "5", ",", "10", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1649, " to ", 
   Images[{7, 2, 1, 3, 4, 6, 9, 11, 12, 5, 10, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"8173a7f4-d968-4ea8-b142-8111e5a55629"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1653", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "3", ",", "4", ",", "5", ",", "9", ",", 
      "11", ",", "12", ",", "6", ",", "10", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1653, " to ", 
   Images[{7, 2, 1, 3, 4, 5, 9, 11, 12, 6, 10, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"c83d69f5-0335-4d66-a0ef-8f8318c4423e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2305", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "6", ",", "2", ",", "1", ",", "7", ",", "8", ",", "10", ",", "3", ",", 
      "11", ",", "12", ",", "9", ",", "4", ",", "5"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2305, " to ", 
   Images[{6, 2, 1, 7, 8, 10, 3, 11, 12, 9, 4, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"28872fb6-8429-49b3-bc63-d8e4f09c3fa3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2309", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "6", ",", "2", ",", "1", ",", "7", ",", "8", ",", "9", ",", "3", ",", 
      "11", ",", "12", ",", "10", ",", "4", ",", "5"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2309, " to ", 
   Images[{6, 2, 1, 7, 8, 9, 3, 11, 12, 10, 4, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"350fe177-7c64-4895-9ca7-135518a2541c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2321", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "7", ",", "8", ",", "10", ",", "3", ",", 
      "11", ",", "12", ",", "9", ",", "4", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2321, " to ", 
   Images[{5, 2, 1, 7, 8, 10, 3, 11, 12, 9, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"827cdc39-70fd-452e-84a3-f752e42139a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2325", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "7", ",", "8", ",", "9", ",", "3", ",", 
      "11", ",", "12", ",", "10", ",", "4", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2325, " to ", 
   Images[{5, 2, 1, 7, 8, 9, 3, 11, 12, 10, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"78f8d6d5-8810-41e5-ade1-122d1a52a638"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2353", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "3", ",", "4", ",", "10", ",", "7", ",", 
      "11", ",", "12", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2353, " to ", 
   Images[{5, 2, 1, 3, 4, 10, 7, 11, 12, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"0c7a211e-0ebc-416a-ad3a-cc1809e752fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2357", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "3", ",", "4", ",", "9", ",", "7", ",", 
      "11", ",", "12", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2357, " to ", 
   Images[{5, 2, 1, 3, 4, 9, 7, 11, 12, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"3a33d99f-ff52-4936-9704-6d9da9133429"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2417", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "3", ",", "4", ",", "8", ",", "9", ",", 
      "11", ",", "12", ",", "7", ",", "10", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2417, " to ", 
   Images[{5, 2, 1, 3, 4, 8, 9, 11, 12, 7, 10, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"d1c8b629-1b35-463e-948e-9ff895bd42e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2421", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "3", ",", "4", ",", "7", ",", "9", ",", 
      "11", ",", "12", ",", "8", ",", "10", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2421, " to ", 
   Images[{5, 2, 1, 3, 4, 7, 9, 11, 12, 8, 10, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ea2f9cbb-c908-4cdd-b746-e3c06ea60314"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3073", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "4", ",", "2", ",", "1", ",", "7", ",", "8", ",", "10", ",", "5", ",", 
      "11", ",", "12", ",", "9", ",", "6", ",", "3"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3073, " to ", 
   Images[{4, 2, 1, 7, 8, 10, 5, 11, 12, 9, 6, 3}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"92069e23-e6bb-4db1-a630-d7999e6b8e94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3077", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "4", ",", "2", ",", "1", ",", "7", ",", "8", ",", "9", ",", "5", ",", 
      "11", ",", "12", ",", "10", ",", "6", ",", "3"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3077, " to ", 
   Images[{4, 2, 1, 7, 8, 9, 5, 11, 12, 10, 6, 3}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"1a1351fd-a9f5-4bc2-8ad5-edbda982aa40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3089", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "7", ",", "8", ",", "10", ",", "5", ",", 
      "11", ",", "12", ",", "9", ",", "6", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3089, " to ", 
   Images[{3, 2, 1, 7, 8, 10, 5, 11, 12, 9, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"48b7429d-3386-4e61-9c15-9c10366e86dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3093", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "7", ",", "8", ",", "9", ",", "5", ",", 
      "11", ",", "12", ",", "10", ",", "6", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3093, " to ", 
   Images[{3, 2, 1, 7, 8, 9, 5, 11, 12, 10, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"e2d00cd6-d8bd-4d82-b6d7-696c847b4eca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3121", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "5", ",", "6", ",", "10", ",", "7", ",", 
      "11", ",", "12", ",", "9", ",", "8", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3121, " to ", 
   Images[{3, 2, 1, 5, 6, 10, 7, 11, 12, 9, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"e3c2d39b-c066-458a-b6c0-d68ae686e99a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3125", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "5", ",", "6", ",", "9", ",", "7", ",", 
      "11", ",", "12", ",", "10", ",", "8", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3125, " to ", 
   Images[{3, 2, 1, 5, 6, 9, 7, 11, 12, 10, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"4f7f5c51-0f34-4a9e-bff1-91a6cff3b5dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3185", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "5", ",", "6", ",", "8", ",", "9", ",", 
      "11", ",", "12", ",", "7", ",", "10", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3185, " to ", 
   Images[{3, 2, 1, 5, 6, 8, 9, 11, 12, 7, 10, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"e9372b8e-98c0-4243-a118-193e4d8e0bfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3189", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "5", ",", "6", ",", "7", ",", "9", ",", 
      "11", ",", "12", ",", "8", ",", "10", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3189, " to ", 
   Images[{3, 2, 1, 5, 6, 7, 9, 11, 12, 8, 10, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"280217a1-1a8a-48d2-990e-0fa9b4463e9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "12", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
       "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1, " to ", -
   Images[{2, 12, 1, 5, 6, 8, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"3bab190b-fd95-4ccd-913b-c6d7e3337d8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "12", ",", "1", ",", "5", ",", "6", ",", "7", ",", "3", ",", 
       "9", ",", "10", ",", "8", ",", "4", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 5, " to ", -
   Images[{2, 12, 1, 5, 6, 7, 3, 9, 10, 8, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"751c6b19-4bbb-4c33-b862-a64858f43dfd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
       "9", ",", "10", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 17, " to ", -
   Images[{2, 11, 1, 5, 6, 8, 3, 9, 10, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"c914bc0a-72cd-4de8-92c6-79e71ceed6aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "5", ",", "6", ",", "7", ",", "3", ",", 
       "9", ",", "10", ",", "8", ",", "4", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 21, " to ", -
   Images[{2, 11, 1, 5, 6, 7, 3, 9, 10, 8, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"e7839efc-6335-4b74-a797-bf0fec44e2ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "3", ",", "4", ",", "8", ",", "5", ",", 
       "9", ",", "10", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 49, " to ", -
   Images[{2, 11, 1, 3, 4, 8, 5, 9, 10, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"1b51481a-b2ec-48e4-a650-231ba0e6137b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "3", ",", "4", ",", "7", ",", "5", ",", 
       "9", ",", "10", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 53, " to ", -
   Images[{2, 11, 1, 3, 4, 7, 5, 9, 10, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"c04b703a-ae57-4d82-aca3-1463fd18be50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "113", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "3", ",", "4", ",", "6", ",", "7", ",", 
       "9", ",", "10", ",", "5", ",", "8", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 113, " to ", -
   Images[{2, 11, 1, 3, 4, 6, 7, 9, 10, 5, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"09566996-fe1a-486f-9efd-567baa416d00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "117", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "3", ",", "4", ",", "5", ",", "7", ",", 
       "9", ",", "10", ",", "6", ",", "8", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 117, " to ", -
   Images[{2, 11, 1, 3, 4, 5, 7, 9, 10, 6, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"e4be9a0d-59aa-4123-b56f-2f7a182f4cde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "769", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "10", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
       "11", ",", "12", ",", "7", ",", "4", ",", "9"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 769, " to ", -
   Images[{2, 10, 1, 5, 6, 8, 3, 11, 12, 7, 4, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"736d70b1-7276-4a75-a2a6-02d4b233d211"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "773", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "10", ",", "1", ",", "5", ",", "6", ",", "7", ",", "3", ",", 
       "11", ",", "12", ",", "8", ",", "4", ",", "9"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 773, " to ", -
   Images[{2, 10, 1, 5, 6, 7, 3, 11, 12, 8, 4, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"271401cb-2c71-4eec-b9ec-5ae888ad2020"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "785", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
       "11", ",", "12", ",", "7", ",", "4", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 785, " to ", -
   Images[{2, 9, 1, 5, 6, 8, 3, 11, 12, 7, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"06aad58c-3ecf-423d-9e92-08b0c781a7fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "789", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "5", ",", "6", ",", "7", ",", "3", ",", 
       "11", ",", "12", ",", "8", ",", "4", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 789, " to ", -
   Images[{2, 9, 1, 5, 6, 7, 3, 11, 12, 8, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"75f5fa72-fec1-43f1-b5ac-a8b6525d3723"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "817", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "3", ",", "4", ",", "8", ",", "5", ",", 
       "11", ",", "12", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 817, " to ", -
   Images[{2, 9, 1, 3, 4, 8, 5, 11, 12, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"c207c821-eccc-4fde-84c8-b610f952c003"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "821", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "3", ",", "4", ",", "7", ",", "5", ",", 
       "11", ",", "12", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 821, " to ", -
   Images[{2, 9, 1, 3, 4, 7, 5, 11, 12, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"b9820d3a-d0ef-4c3a-a943-061067f76dff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "881", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "3", ",", "4", ",", "6", ",", "7", ",", 
       "11", ",", "12", ",", "5", ",", "8", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 881, " to ", -
   Images[{2, 9, 1, 3, 4, 6, 7, 11, 12, 5, 8, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"c35baa51-68b1-42ab-8c4b-41ac1ad5ba4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "885", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "3", ",", "4", ",", "5", ",", "7", ",", 
       "11", ",", "12", ",", "6", ",", "8", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 885, " to ", -
   Images[{2, 9, 1, 3, 4, 5, 7, 11, 12, 6, 8, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"d115c052-c325-4c1b-b76a-063ae1ce887d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1537", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "8", ",", "1", ",", "5", ",", "6", ",", "10", ",", "3", ",", 
       "11", ",", "12", ",", "9", ",", "4", ",", "7"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1537, " to ", -
   Images[{2, 8, 1, 5, 6, 10, 3, 11, 12, 9, 4, 7}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"2aeac8f6-1b05-49f0-8bf8-08f42741de69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1541", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "8", ",", "1", ",", "5", ",", "6", ",", "9", ",", "3", ",", 
       "11", ",", "12", ",", "10", ",", "4", ",", "7"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1541, " to ", -
   Images[{2, 8, 1, 5, 6, 9, 3, 11, 12, 10, 4, 7}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"26f9a33c-0e89-4be9-97a4-08371477c40b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1553", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "5", ",", "6", ",", "10", ",", "3", ",", 
       "11", ",", "12", ",", "9", ",", "4", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1553, " to ", -
   Images[{2, 7, 1, 5, 6, 10, 3, 11, 12, 9, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ef7619fd-abef-4821-bc65-85914afc40aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1557", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "5", ",", "6", ",", "9", ",", "3", ",", 
       "11", ",", "12", ",", "10", ",", "4", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1557, " to ", -
   Images[{2, 7, 1, 5, 6, 9, 3, 11, 12, 10, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"4eed1fa2-8b2c-44da-9300-c3b0a14d37bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1585", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "3", ",", "4", ",", "10", ",", "5", ",", 
       "11", ",", "12", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1585, " to ", -
   Images[{2, 7, 1, 3, 4, 10, 5, 11, 12, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"b4e2a9a7-4f3b-4a95-ac41-2f7e61f8789a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1589", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "3", ",", "4", ",", "9", ",", "5", ",", 
       "11", ",", "12", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1589, " to ", -
   Images[{2, 7, 1, 3, 4, 9, 5, 11, 12, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"9110d436-4796-4875-9c8d-ecf0dd1b89b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1649", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "3", ",", "4", ",", "6", ",", "9", ",", 
       "11", ",", "12", ",", "5", ",", "10", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1649, " to ", -
   Images[{2, 7, 1, 3, 4, 6, 9, 11, 12, 5, 10, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"1b932b92-dd41-4783-b3fa-dd0d0d9e7873"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1653", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "3", ",", "4", ",", "5", ",", "9", ",", 
       "11", ",", "12", ",", "6", ",", "10", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1653, " to ", -
   Images[{2, 7, 1, 3, 4, 5, 9, 11, 12, 6, 10, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"cb98d28d-bd4d-4343-a5e7-73dac49d58ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2305", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "6", ",", "1", ",", "7", ",", "8", ",", "10", ",", "3", ",", 
       "11", ",", "12", ",", "9", ",", "4", ",", "5"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2305, " to ", -
   Images[{2, 6, 1, 7, 8, 10, 3, 11, 12, 9, 4, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"e7cad0f2-9c7f-4f11-b518-31e8e227d270"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2309", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "6", ",", "1", ",", "7", ",", "8", ",", "9", ",", "3", ",", 
       "11", ",", "12", ",", "10", ",", "4", ",", "5"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2309, " to ", -
   Images[{2, 6, 1, 7, 8, 9, 3, 11, 12, 10, 4, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"51cf418c-0903-4e78-997b-b67d91b5180f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2321", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "7", ",", "8", ",", "10", ",", "3", ",", 
       "11", ",", "12", ",", "9", ",", "4", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2321, " to ", -
   Images[{2, 5, 1, 7, 8, 10, 3, 11, 12, 9, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"39c8aefa-94a3-4a8b-850d-f82268c13bf0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2325", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "7", ",", "8", ",", "9", ",", "3", ",", 
       "11", ",", "12", ",", "10", ",", "4", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2325, " to ", -
   Images[{2, 5, 1, 7, 8, 9, 3, 11, 12, 10, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ab2850a7-35f0-46a3-977d-8b311d3562c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2353", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "3", ",", "4", ",", "10", ",", "7", ",", 
       "11", ",", "12", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2353, " to ", -
   Images[{2, 5, 1, 3, 4, 10, 7, 11, 12, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"b337b4fe-02a0-44e9-b926-b0663097499b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2357", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "3", ",", "4", ",", "9", ",", "7", ",", 
       "11", ",", "12", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2357, " to ", -
   Images[{2, 5, 1, 3, 4, 9, 7, 11, 12, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"b524b50d-834b-4bac-bd72-8382dd6e1dfa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2417", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "3", ",", "4", ",", "8", ",", "9", ",", 
       "11", ",", "12", ",", "7", ",", "10", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2417, " to ", -
   Images[{2, 5, 1, 3, 4, 8, 9, 11, 12, 7, 10, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"eea6d523-a9c8-4023-a0ea-08397c17a361"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2421", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "3", ",", "4", ",", "7", ",", "9", ",", 
       "11", ",", "12", ",", "8", ",", "10", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2421, " to ", -
   Images[{2, 5, 1, 3, 4, 7, 9, 11, 12, 8, 10, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"7d60adbb-9849-4f4f-9475-10d6201a98a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3073", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "4", ",", "1", ",", "7", ",", "8", ",", "10", ",", "5", ",", 
       "11", ",", "12", ",", "9", ",", "6", ",", "3"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3073, " to ", -
   Images[{2, 4, 1, 7, 8, 10, 5, 11, 12, 9, 6, 3}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"2d3cdedc-cd35-4a74-bdc6-d915cd3b8f6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3077", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "4", ",", "1", ",", "7", ",", "8", ",", "9", ",", "5", ",", 
       "11", ",", "12", ",", "10", ",", "6", ",", "3"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3077, " to ", -
   Images[{2, 4, 1, 7, 8, 9, 5, 11, 12, 10, 6, 3}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"7b9335f4-5761-4af0-95a9-68746cc008fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3089", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "7", ",", "8", ",", "10", ",", "5", ",", 
       "11", ",", "12", ",", "9", ",", "6", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3089, " to ", -
   Images[{2, 3, 1, 7, 8, 10, 5, 11, 12, 9, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"9345a2e4-e2a0-4acf-b169-c1aa2310325d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3093", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "7", ",", "8", ",", "9", ",", "5", ",", 
       "11", ",", "12", ",", "10", ",", "6", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3093, " to ", -
   Images[{2, 3, 1, 7, 8, 9, 5, 11, 12, 10, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"dc1a00af-0011-4355-8297-30b59536dfde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3121", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "5", ",", "6", ",", "10", ",", "7", ",", 
       "11", ",", "12", ",", "9", ",", "8", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3121, " to ", -
   Images[{2, 3, 1, 5, 6, 10, 7, 11, 12, 9, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"6356618d-b7aa-4791-ad6d-c6b8e1dc3f5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3125", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "5", ",", "6", ",", "9", ",", "7", ",", 
       "11", ",", "12", ",", "10", ",", "8", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3125, " to ", -
   Images[{2, 3, 1, 5, 6, 9, 7, 11, 12, 10, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"f2b55119-ab47-4c31-9e80-eba3a658e6e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3185", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "5", ",", "6", ",", "8", ",", "9", ",", 
       "11", ",", "12", ",", "7", ",", "10", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3185, " to ", -
   Images[{2, 3, 1, 5, 6, 8, 9, 11, 12, 7, 10, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"721d4a00-e1b6-44f3-a2c5-25bd5b0802a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3189", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "5", ",", "6", ",", "7", ",", "9", ",", 
       "11", ",", "12", ",", "8", ",", "10", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3189, " to ", -
   Images[{2, 3, 1, 5, 6, 7, 9, 11, 12, 8, 10, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"c42c5b7e-a689-47cd-ad2d-f6d95c41ae8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3381", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "3", ",", "1", ",", "5", ",", "6", ",", "7", ",", "9", ",", 
      "11", ",", "10", ",", "8", ",", "12", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 10, ", j=", 3381, " to ", 
   Images[{2, 3, 1, 5, 6, 7, 9, 11, 10, 8, 12, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"2b88937e-9d52-44be-887d-e4a05f9f941e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3189", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "3", ",", "1", ",", "5", ",", "6", ",", "7", ",", "9", ",", 
      "11", ",", "8", ",", "12", ",", "10", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 18, ", j=", 3189, " to ", 
   Images[{2, 3, 1, 5, 6, 7, 9, 11, 8, 12, 10, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"9268e148-475c-42fb-b16f-f658717c835a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3381", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "5", ",", "6", ",", "7", ",", "9", ",", 
       "11", ",", "8", ",", "10", ",", "12", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 26, ", j=", 3381, " to ", -
   Images[{2, 3, 1, 5, 6, 7, 9, 11, 8, 10, 12, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ccbb8139-688c-4f47-8fb9-4801220d8e71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "58", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3381", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "3", ",", "1", ",", "5", ",", "6", ",", "7", ",", "9", ",", 
      "11", ",", "8", ",", "10", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 58, ", j=", 3381, " to ", 
   Images[{2, 3, 1, 5, 6, 7, 9, 11, 8, 10, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"e2cd604e-c773-411f-8af1-b0673a209598"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "12", ",", "2", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1, " to ", 
   Images[{1, 5, 12, 2, 6, 8, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"21877248-9166-4c41-bb7f-b85026f2da15"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "12", ",", "2", ",", "6", ",", "7", ",", "3", ",", 
      "9", ",", "10", ",", "8", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 5, " to ", 
   Images[{1, 5, 12, 2, 6, 7, 3, 9, 10, 8, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"168ecdb5-835a-4857-95ad-e06be9165e3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "11", ",", "2", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 17, " to ", 
   Images[{1, 5, 11, 2, 6, 8, 3, 9, 10, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"25d3bf05-cc75-4ced-9175-2aa2312f57f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "11", ",", "2", ",", "6", ",", "7", ",", "3", ",", 
      "9", ",", "10", ",", "8", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 21, " to ", 
   Images[{1, 5, 11, 2, 6, 7, 3, 9, 10, 8, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"be4ca7e9-8854-48f1-b792-7e6a657b2a2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "12", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "9", ",", "10", ",", "7", ",", "6", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 33, " to ", 
   Images[{1, 3, 12, 2, 4, 8, 5, 9, 10, 7, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"f68c71dc-156f-46c7-9023-7dde78542c20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "12", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "9", ",", "10", ",", "8", ",", "6", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 37, " to ", 
   Images[{1, 3, 12, 2, 4, 7, 5, 9, 10, 8, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"08d881b8-f7a3-416d-ac5f-fe9401f82376"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "9", ",", "10", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 49, " to ", 
   Images[{1, 3, 11, 2, 4, 8, 5, 9, 10, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"7f21b458-eab9-48bc-a731-7405e168a221"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "9", ",", "10", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 53, " to ", 
   Images[{1, 3, 11, 2, 4, 7, 5, 9, 10, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"9f6277ff-d387-453c-aa87-53408ec65da8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "113", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "6", ",", "7", ",", 
      "9", ",", "10", ",", "5", ",", "8", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 113, " to ", 
   Images[{1, 3, 11, 2, 4, 6, 7, 9, 10, 5, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"3c165d22-889f-4733-9025-b59c6770e3af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "117", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "5", ",", "7", ",", 
      "9", ",", "10", ",", "6", ",", "8", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 117, " to ", 
   Images[{1, 3, 11, 2, 4, 5, 7, 9, 10, 6, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ea738360-3d70-4cf9-b908-3b0e565cca06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "801", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "10", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "11", ",", "12", ",", "7", ",", "6", ",", "9"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 801, " to ", 
   Images[{1, 3, 10, 2, 4, 8, 5, 11, 12, 7, 6, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"1a4f9795-e5aa-42fb-a034-3e25d402dff4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "805", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "10", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "11", ",", "12", ",", "8", ",", "6", ",", "9"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 805, " to ", 
   Images[{1, 3, 10, 2, 4, 7, 5, 11, 12, 8, 6, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"7555b455-94b3-40a4-abc7-5f5000533962"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "817", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "11", ",", "12", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 817, " to ", 
   Images[{1, 3, 9, 2, 4, 8, 5, 11, 12, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"a4c360d3-8afb-49ab-8d6b-d3df471baabc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "821", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "11", ",", "12", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 821, " to ", 
   Images[{1, 3, 9, 2, 4, 7, 5, 11, 12, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"8abd07c9-e32b-4096-b0df-fa93fe676991"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "881", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "6", ",", "7", ",", 
      "11", ",", "12", ",", "5", ",", "8", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 881, " to ", 
   Images[{1, 3, 9, 2, 4, 6, 7, 11, 12, 5, 8, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"2912c7d3-bac1-4d82-8b96-e493e759887b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "885", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "5", ",", "7", ",", 
      "11", ",", "12", ",", "6", ",", "8", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 885, " to ", 
   Images[{1, 3, 9, 2, 4, 5, 7, 11, 12, 6, 8, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"0a36f418-2d71-447e-842d-cfc7d7106bb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1569", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "8", ",", "2", ",", "4", ",", "10", ",", "5", ",", 
      "11", ",", "12", ",", "9", ",", "6", ",", "7"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1569, " to ", 
   Images[{1, 3, 8, 2, 4, 10, 5, 11, 12, 9, 6, 7}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"1083bfa2-1bac-4374-a82c-4bd0824d7a5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1573", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "8", ",", "2", ",", "4", ",", "9", ",", "5", ",", 
      "11", ",", "12", ",", "10", ",", "6", ",", "7"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1573, " to ", 
   Images[{1, 3, 8, 2, 4, 9, 5, 11, 12, 10, 6, 7}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"13cea854-0854-46f7-b4ba-a155a358a261"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1585", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "10", ",", "5", ",", 
      "11", ",", "12", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1585, " to ", 
   Images[{1, 3, 7, 2, 4, 10, 5, 11, 12, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"b4b5159d-552e-4808-9dbb-b216fc5a4e1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1589", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "9", ",", "5", ",", 
      "11", ",", "12", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1589, " to ", 
   Images[{1, 3, 7, 2, 4, 9, 5, 11, 12, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"3a33d2ab-7985-4800-b901-d259fdde9cc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1649", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "6", ",", "9", ",", 
      "11", ",", "12", ",", "5", ",", "10", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1649, " to ", 
   Images[{1, 3, 7, 2, 4, 6, 9, 11, 12, 5, 10, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"c23af089-1c98-4d79-a81d-99ab6485800d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1653", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "5", ",", "9", ",", 
      "11", ",", "12", ",", "6", ",", "10", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1653, " to ", 
   Images[{1, 3, 7, 2, 4, 5, 9, 11, 12, 6, 10, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ffa9e9a1-50ab-46e5-b2d2-d1a093d7b522"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2337", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "6", ",", "2", ",", "4", ",", "10", ",", "7", ",", 
      "11", ",", "12", ",", "9", ",", "8", ",", "5"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2337, " to ", 
   Images[{1, 3, 6, 2, 4, 10, 7, 11, 12, 9, 8, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"416fa9ad-b42f-42ae-a8b3-55d04c181edd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2341", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "6", ",", "2", ",", "4", ",", "9", ",", "7", ",", 
      "11", ",", "12", ",", "10", ",", "8", ",", "5"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2341, " to ", 
   Images[{1, 3, 6, 2, 4, 9, 7, 11, 12, 10, 8, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"804ae60d-8e66-449c-afb9-f3aab381325c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2353", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "10", ",", "7", ",", 
      "11", ",", "12", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2353, " to ", 
   Images[{1, 3, 5, 2, 4, 10, 7, 11, 12, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"963e5b81-603e-4f3a-95f0-ab31c7dd9398"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2357", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "9", ",", "7", ",", 
      "11", ",", "12", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2357, " to ", 
   Images[{1, 3, 5, 2, 4, 9, 7, 11, 12, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"175ec45f-e5e0-4336-9262-87f2e7c004f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2417", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "8", ",", "9", ",", 
      "11", ",", "12", ",", "7", ",", "10", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2417, " to ", 
   Images[{1, 3, 5, 2, 4, 8, 9, 11, 12, 7, 10, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ba8b5970-f5a3-4a3c-9f51-44a4bf1495b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2421", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "7", ",", "9", ",", 
      "11", ",", "12", ",", "8", ",", "10", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2421, " to ", 
   Images[{1, 3, 5, 2, 4, 7, 9, 11, 12, 8, 10, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"9a6b89ad-74ae-4bac-a8b9-03c97a064d7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "12", ",", "4", ",", "8", ",", "5", ",", 
       "9", ",", "10", ",", "7", ",", "6", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 33, " to ", -
   Images[{1, 3, 2, 12, 4, 8, 5, 9, 10, 7, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"30d7eabf-dda6-4ab9-95b6-904dffed2f66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "12", ",", "4", ",", "7", ",", "5", ",", 
       "9", ",", "10", ",", "8", ",", "6", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 37, " to ", -
   Images[{1, 3, 2, 12, 4, 7, 5, 9, 10, 8, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"39e42763-41f0-4963-8293-2b2620ddc99c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "11", ",", "4", ",", "8", ",", "5", ",", 
       "9", ",", "10", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 49, " to ", -
   Images[{1, 3, 2, 11, 4, 8, 5, 9, 10, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"45e757ac-5613-4812-a543-6c9fb247bea9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "11", ",", "4", ",", "7", ",", "5", ",", 
       "9", ",", "10", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 53, " to ", -
   Images[{1, 3, 2, 11, 4, 7, 5, 9, 10, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"ff24cf5c-8b7a-4100-a42e-0cf563beb945"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "113", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "11", ",", "4", ",", "6", ",", "7", ",", 
       "9", ",", "10", ",", "5", ",", "8", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 113, " to ", -
   Images[{1, 3, 2, 11, 4, 6, 7, 9, 10, 5, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"906ed593-3f15-47fb-8340-06fc6aaf454c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "117", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "11", ",", "4", ",", "5", ",", "7", ",", 
       "9", ",", "10", ",", "6", ",", "8", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 117, " to ", -
   Images[{1, 3, 2, 11, 4, 5, 7, 9, 10, 6, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"77aa19ba-d53b-4a9b-bb32-f9ebb840bf06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "801", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "10", ",", "4", ",", "8", ",", "5", ",", 
       "11", ",", "12", ",", "7", ",", "6", ",", "9"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 801, " to ", -
   Images[{1, 3, 2, 10, 4, 8, 5, 11, 12, 7, 6, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"4bf41b1c-039a-4b61-8b01-a3560b8ed1b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "805", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "10", ",", "4", ",", "7", ",", "5", ",", 
       "11", ",", "12", ",", "8", ",", "6", ",", "9"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 805, " to ", -
   Images[{1, 3, 2, 10, 4, 7, 5, 11, 12, 8, 6, 9}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"b4d9257b-5910-4307-8ac3-85526a86033b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "817", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "9", ",", "4", ",", "8", ",", "5", ",", 
       "11", ",", "12", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 817, " to ", -
   Images[{1, 3, 2, 9, 4, 8, 5, 11, 12, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"cd437c3f-65b3-4597-9b03-b51936a73a32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "821", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "9", ",", "4", ",", "7", ",", "5", ",", 
       "11", ",", "12", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 821, " to ", -
   Images[{1, 3, 2, 9, 4, 7, 5, 11, 12, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"288630be-d36a-40db-a668-d5a5b19cb347"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "881", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "9", ",", "4", ",", "6", ",", "7", ",", 
       "11", ",", "12", ",", "5", ",", "8", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 881, " to ", -
   Images[{1, 3, 2, 9, 4, 6, 7, 11, 12, 5, 8, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"96bb96bc-a940-49cc-96f3-3f5fd20f7ac0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "885", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "9", ",", "4", ",", "5", ",", "7", ",", 
       "11", ",", "12", ",", "6", ",", "8", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 885, " to ", -
   Images[{1, 3, 2, 9, 4, 5, 7, 11, 12, 6, 8, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"c5eee1e8-168e-4caa-9ca1-bd654a7481d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1569", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "8", ",", "4", ",", "10", ",", "5", ",", 
       "11", ",", "12", ",", "9", ",", "6", ",", "7"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 1569, " to ", -
   Images[{1, 3, 2, 8, 4, 10, 5, 11, 12, 9, 6, 7}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"4d959a07-9375-47af-be2f-f42e6888e918"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1573", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "8", ",", "4", ",", "9", ",", "5", ",", 
       "11", ",", "12", ",", "10", ",", "6", ",", "7"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 1573, " to ", -
   Images[{1, 3, 2, 8, 4, 9, 5, 11, 12, 10, 6, 7}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"da73022e-e031-4e2e-900c-646582d368aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1585", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "7", ",", "4", ",", "10", ",", "5", ",", 
       "11", ",", "12", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 1585, " to ", -
   Images[{1, 3, 2, 7, 4, 10, 5, 11, 12, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"f13817b8-288f-4fe8-a6bc-ea61de77af5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1589", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "7", ",", "4", ",", "9", ",", "5", ",", 
       "11", ",", "12", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 1589, " to ", -
   Images[{1, 3, 2, 7, 4, 9, 5, 11, 12, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"a248f03a-5fdc-445d-a4dc-a5f76de599e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1649", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "7", ",", "4", ",", "6", ",", "9", ",", 
       "11", ",", "12", ",", "5", ",", "10", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 1649, " to ", -
   Images[{1, 3, 2, 7, 4, 6, 9, 11, 12, 5, 10, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"907fdbda-4392-4d75-a806-4829ff36f00f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1653", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "7", ",", "4", ",", "5", ",", "9", ",", 
       "11", ",", "12", ",", "6", ",", "10", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 1653, " to ", -
   Images[{1, 3, 2, 7, 4, 5, 9, 11, 12, 6, 10, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"a4fa9d59-7239-4fed-b3b2-c0912d4523c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2337", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "6", ",", "4", ",", "10", ",", "7", ",", 
       "11", ",", "12", ",", "9", ",", "8", ",", "5"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 2337, " to ", -
   Images[{1, 3, 2, 6, 4, 10, 7, 11, 12, 9, 8, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"8e5b8c9e-5b37-4d0f-8119-28746cecce32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2341", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "6", ",", "4", ",", "9", ",", "7", ",", 
       "11", ",", "12", ",", "10", ",", "8", ",", "5"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 2341, " to ", -
   Images[{1, 3, 2, 6, 4, 9, 7, 11, 12, 10, 8, 5}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"d8b2de50-162d-4899-8681-a5f214ba2464"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2353", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "10", ",", "7", ",", 
       "11", ",", "12", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 2353, " to ", -
   Images[{1, 3, 2, 5, 4, 10, 7, 11, 12, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"b51e6466-5511-414d-a53a-dbff91d1f423"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2357", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "9", ",", "7", ",", 
       "11", ",", "12", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 2357, " to ", -
   Images[{1, 3, 2, 5, 4, 9, 7, 11, 12, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"1f6426c1-49c5-4f16-b16e-367139b3d0fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2417", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "8", ",", "9", ",", 
       "11", ",", "12", ",", "7", ",", "10", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 2417, " to ", -
   Images[{1, 3, 2, 5, 4, 8, 9, 11, 12, 7, 10, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"cf660a6b-9c12-4314-8752-1c549622ba00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2421", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
       "11", ",", "12", ",", "8", ",", "10", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 2421, " to ", -
   Images[{1, 3, 2, 5, 4, 7, 9, 11, 12, 8, 10, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"2578ab4d-debc-4982-8003-243ef51572e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "75", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2613", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
      "11", ",", "10", ",", "8", ",", "12", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 75, ", j=", 2613, " to ", 
   Images[{1, 3, 2, 5, 4, 7, 9, 11, 10, 8, 12, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"6b59e007-59b6-4ac6-941e-c108a8763dcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "83", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2421", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
      "11", ",", "8", ",", "12", ",", "10", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 83, ", j=", 2421, " to ", 
   Images[{1, 3, 2, 5, 4, 7, 9, 11, 8, 12, 10, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"40631057-4e57-4f40-aec3-ff385fbaf167"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "91", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2613", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
       "11", ",", "8", ",", "10", ",", "12", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 91, ", j=", 2613, " to ", -
   Images[{1, 3, 2, 5, 4, 7, 9, 11, 8, 10, 12, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"70bed940-ff70-4b9d-bbb2-dbf95c75f9cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "123", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2613", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
      "11", ",", "8", ",", "10", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 123, ", j=", 2613, " to ", 
   Images[{1, 3, 2, 5, 4, 7, 9, 11, 8, 10, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"573ea414-741a-4202-8f5e-b2d16848f93b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "339", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2421", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
      "11", ",", "6", ",", "10", ",", "12", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 339, ", j=", 2421, " to ", 
   Images[{1, 3, 2, 5, 4, 7, 9, 11, 6, 10, 12, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"dbdea3d2-8bc2-4c4c-a9f7-3615409bab5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "371", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2421", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
       "11", ",", "6", ",", "10", ",", "8", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 371, ", j=", 2421, " to ", -
   Images[{1, 3, 2, 5, 4, 7, 9, 11, 6, 10, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[310]:=",ExpressionUUID->"30fb8391-5edb-481c-931c-f6120952d30b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2187.896735`", " ", "Second"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "5", ",", "4", ",", "7", ",", "9", ",", 
       "11", ",", "6", ",", "10", ",", "8", ",", "12"}], "}"}], "]"}]}]}], 
  "}"}]], "Output",
 CellLabel->
  "Out[310]=",ExpressionUUID->"9de5771f-1580-4c86-bf9f-44edf9541e0a"]
}, Open  ]],

Cell["\<\
3) With OrderedBase\[Rule]False we can get a different result, because we are \
sorting indices with a different base:\
\>", "MathCaption",ExpressionUUID->"c25bca1b-ddaa-4bdd-a7ea-8365c92eb0c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanonicalPerm", "[", 
  RowBox[{"perm", ",", "12", ",", "GS", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"DummySet", "[", 
     RowBox[{"M", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"7", ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"9", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"11", ",", "12"}], "}"}]}], "}"}], ",", "1"}], "]"}], "}"}], 
   ",", 
   RowBox[{"OrderedBase", "\[Rule]", "False"}], ",", 
   RowBox[{"TimeVerbose", "\[Rule]", "True"}], ",", 
   RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->
  "In[311]:=",ExpressionUUID->"d1a2ab22-859d-4fef-8adc-dd79e89d8725"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SGS for group of order \"\>", "\[InvisibleSpace]", "1024", 
   "\[InvisibleSpace]", "\<\" computed in \"\>", "\[InvisibleSpace]", 
   "0.3214100000000002`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm[
  "SGS for group of order ", 1024, " computed in ", 0.3214100000000002, 
   " secs."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[311]:=",ExpressionUUID->"b710cf10-f523-4b15-8b44-f75717903d7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free algorithm applied in \"\>", "\[InvisibleSpace]", 
   "0.0036619999999985`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm["Free algorithm applied in ", 0.0036619999999985, " secs."],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[311]:=",ExpressionUUID->"3fe9e1da-7a56-4eef-a3b0-4879359e6f32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dummy algorithm applied in \"\>", "\[InvisibleSpace]", 
   "0.16629600000000266`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm["Dummy algorithm applied in ", 0.16629600000000266`, " secs."],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[311]:=",ExpressionUUID->"a7c5fd71-db8d-46f2-b459-a562268b2376"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cycles", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "6", ",", "10", ",", "8", ",", "12"}], "}"}]}], 
   "]"}]}]], "Output",
 CellLabel->
  "Out[311]=",ExpressionUUID->"54ff1c9a-1c3e-4d04-b548-f42121dd715d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TranslatePerm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"Images", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[312]:=",ExpressionUUID->"e498508c-f8f9-4d49-9214-dafe1ac9b37d"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Images", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "6", ",", "5", ",", "10", ",", "7", ",", 
     "12", ",", "9", ",", "8", ",", "11", ",", "4"}], "}"}], 
   "]"}]}]], "Output",
 CellLabel->
  "Out[312]=",ExpressionUUID->"fd3e373e-24e4-4d69-9c37-dcf40db490de"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CanonicalPerm", "[", 
  RowBox[{"perm", ",", "12", ",", "GS", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"DummySet", "[", 
     RowBox[{"M", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"7", ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"9", ",", "10"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"11", ",", "12"}], "}"}]}], "}"}], ",", "1"}], "]"}], "}"}], 
   ",", 
   RowBox[{"OrderedBase", "\[Rule]", "False"}], ",", 
   RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[313]:=",ExpressionUUID->"b7e79e6d-5ca6-4a7a-a10d-503b28b3fd25"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Images", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "6", ",", "5", ",", "10", ",", "7", ",", 
     "12", ",", "9", ",", "8", ",", "11", ",", "4"}], "}"}], 
   "]"}]}]], "Output",
 CellLabel->
  "Out[313]=",ExpressionUUID->"1b0dafb2-f3ba-4f7c-a920-83f3e8a8546e"]
}, Open  ]],

Cell["\<\
That result can also be interpreted in terms of an ordering of permutations \
with respect to a particular base. In this case the dummy indices are sorted \
differently (again, this cell has been made nonevaluatable):\
\>", "MathCaption",ExpressionUUID->"f20841c6-cdcf-4a6f-8bbf-e2c0ba296de2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"g", "=", 
       RowBox[{"TranslatePerm", "[", 
        RowBox[{"perm", ",", "Images"}], "]"}]}], ",", "ming", ",", "gg"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ming", "=", "g"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"gg", "=", 
           RowBox[{"PermProduct", "[", 
            RowBox[{
             RowBox[{"groupS", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "g", ",", 
             RowBox[{"groupD", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"PermOrderedQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"gg", ",", "ming"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
               "1", ",", "2", ",", "3", ",", "5", ",", "7", ",", "9", ",", 
                "11", ",", "4", ",", "6", ",", "8", ",", "10", ",", "12"}], 
               "}"}]}], "]"}], ",", 
            RowBox[{
             RowBox[{"ming", "=", "gg"}], ";", 
             RowBox[{"Print", "[", 
              RowBox[{
              "\"\<Change at i=\>\"", ",", "i", ",", "\"\<, j=\>\"", ",", "j",
                ",", "\"\< to \>\"", ",", "ming"}], "]"}]}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Length", "[", "groupD", "]"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "groupS", "]"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "ming"}]}], "]"}], "//", "Timing"}]], "Input",
 Evaluatable->False,
 CellLabel->
  "In[314]:=",ExpressionUUID->"57d26a9a-876f-46b1-b2bb-9904157558e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "12", ",", "2", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3, " to ", 
   Images[{12, 2, 1, 6, 5, 8, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"a5b78caf-d02e-4ec7-aea5-84e71bddf45b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "12", ",", "2", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
      "9", ",", "10", ",", "8", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 7, " to ", 
   Images[{12, 2, 1, 6, 5, 7, 3, 9, 10, 8, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"53c82e08-f440-4ef0-a646-0b29f15a614e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "12", ",", "2", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
      "10", ",", "9", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 11, " to ", 
   Images[{12, 2, 1, 6, 5, 8, 3, 10, 9, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"d3ed6b74-a310-45bd-bd1d-45f3da4b77e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "12", ",", "2", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
      "10", ",", "9", ",", "8", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 15, " to ", 
   Images[{12, 2, 1, 6, 5, 7, 3, 10, 9, 8, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"5a4b82aa-be8d-45ee-843a-a37e8492404e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 17, " to ", 
   Images[{11, 2, 1, 5, 6, 8, 3, 9, 10, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"10af3743-dff8-4343-bd4d-8a3e9070e868"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 19, " to ", 
   Images[{11, 2, 1, 6, 5, 8, 3, 9, 10, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ba5adb18-c3b9-4c0c-b3af-999b0ab23165"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
      "9", ",", "10", ",", "8", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 23, " to ", 
   Images[{11, 2, 1, 6, 5, 7, 3, 9, 10, 8, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"79b63931-e0aa-4d4d-8be3-1f74a213d155"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
      "10", ",", "9", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 27, " to ", 
   Images[{11, 2, 1, 6, 5, 8, 3, 10, 9, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"922e9751-7e0d-4ad0-b1ab-018b2b940c1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
      "10", ",", "9", ",", "8", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 31, " to ", 
   Images[{11, 2, 1, 6, 5, 7, 3, 10, 9, 8, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"1ad3a93e-9aae-4001-a33e-2f4039ba6690"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "51", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "4", ",", "3", ",", "8", ",", "5", ",", 
      "9", ",", "10", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 51, " to ", 
   Images[{11, 2, 1, 4, 3, 8, 5, 9, 10, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"21ea07aa-bae4-41d7-8e66-3adff85ab877"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "55", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "4", ",", "3", ",", "7", ",", "5", ",", 
      "9", ",", "10", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 55, " to ", 
   Images[{11, 2, 1, 4, 3, 7, 5, 9, 10, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"4b87181d-d6de-4202-9eb4-b5dee1ad59d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "59", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "4", ",", "3", ",", "8", ",", "5", ",", 
      "10", ",", "9", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 59, " to ", 
   Images[{11, 2, 1, 4, 3, 8, 5, 10, 9, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"5aed7d11-1f60-4d00-91a2-656784a53d65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "63", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "4", ",", "3", ",", "7", ",", "5", ",", 
      "10", ",", "9", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 63, " to ", 
   Images[{11, 2, 1, 4, 3, 7, 5, 10, 9, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"627fabac-90f7-4e18-8a69-d07f627437c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "251", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "4", ",", "3", ",", "10", ",", "5", ",", 
      "8", ",", "7", ",", "9", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 251, " to ", 
   Images[{11, 2, 1, 4, 3, 10, 5, 8, 7, 9, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"271775ef-551b-4245-af55-7de01b86cfd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "255", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "11", ",", "2", ",", "1", ",", "4", ",", "3", ",", "9", ",", "5", ",", 
      "8", ",", "7", ",", "10", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 255, " to ", 
   Images[{11, 2, 1, 4, 3, 9, 5, 8, 7, 10, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"3f46a84c-2b0d-4db0-b017-789cd36ee71f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "785", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
      "11", ",", "12", ",", "7", ",", "4", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 785, " to ", 
   Images[{9, 2, 1, 5, 6, 8, 3, 11, 12, 7, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"58cd3138-656d-41c6-9f63-684b3c52f0b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "787", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
      "11", ",", "12", ",", "7", ",", "4", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 787, " to ", 
   Images[{9, 2, 1, 6, 5, 8, 3, 11, 12, 7, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"20c45b96-8109-4f30-8b99-86f76d539878"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "791", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
      "11", ",", "12", ",", "8", ",", "4", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 791, " to ", 
   Images[{9, 2, 1, 6, 5, 7, 3, 11, 12, 8, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"0402a020-bef3-4a07-b6c6-1c082e46ed87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "795", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
      "12", ",", "11", ",", "7", ",", "4", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 795, " to ", 
   Images[{9, 2, 1, 6, 5, 8, 3, 12, 11, 7, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"9505d6d2-a82b-4eb5-aa8b-f0f52df1c891"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "799", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
      "12", ",", "11", ",", "8", ",", "4", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 799, " to ", 
   Images[{9, 2, 1, 6, 5, 7, 3, 12, 11, 8, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"d64d073f-247e-4722-bacf-8220b752ce1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "819", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "4", ",", "3", ",", "8", ",", "5", ",", 
      "11", ",", "12", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 819, " to ", 
   Images[{9, 2, 1, 4, 3, 8, 5, 11, 12, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"66ca6f56-8fa7-4a10-aace-3fd5de3ec34c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "823", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "4", ",", "3", ",", "7", ",", "5", ",", 
      "11", ",", "12", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 823, " to ", 
   Images[{9, 2, 1, 4, 3, 7, 5, 11, 12, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ccf7325c-b23a-4f61-ba6a-c281618aa7b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "827", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "4", ",", "3", ",", "8", ",", "5", ",", 
      "12", ",", "11", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 827, " to ", 
   Images[{9, 2, 1, 4, 3, 8, 5, 12, 11, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"c991b571-fa64-4e23-8915-7436f877a68a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "831", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "4", ",", "3", ",", "7", ",", "5", ",", 
      "12", ",", "11", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 831, " to ", 
   Images[{9, 2, 1, 4, 3, 7, 5, 12, 11, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ed46a29c-62c5-49e5-9652-57722bb7c9db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1019", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "4", ",", "3", ",", "12", ",", "5", ",", 
      "8", ",", "7", ",", "11", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1019, " to ", 
   Images[{9, 2, 1, 4, 3, 12, 5, 8, 7, 11, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"eec91b51-f92d-4687-93fe-2d5a90271964"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1023", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "9", ",", "2", ",", "1", ",", "4", ",", "3", ",", "11", ",", "5", ",", 
      "8", ",", "7", ",", "12", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1023, " to ", 
   Images[{9, 2, 1, 4, 3, 11, 5, 8, 7, 12, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"68ac73cc-1ff8-4f98-95df-accfa07d5c99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1553", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "5", ",", "6", ",", "10", ",", "3", ",", 
      "11", ",", "12", ",", "9", ",", "4", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1553, " to ", 
   Images[{7, 2, 1, 5, 6, 10, 3, 11, 12, 9, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"b7f84d82-de01-48b5-beb7-b4b975a51372"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1555", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "6", ",", "5", ",", "10", ",", "3", ",", 
      "11", ",", "12", ",", "9", ",", "4", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1555, " to ", 
   Images[{7, 2, 1, 6, 5, 10, 3, 11, 12, 9, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"5e485d32-acee-48d3-9bdb-1ff9d7981e46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1559", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "6", ",", "5", ",", "9", ",", "3", ",", 
      "11", ",", "12", ",", "10", ",", "4", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1559, " to ", 
   Images[{7, 2, 1, 6, 5, 9, 3, 11, 12, 10, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"86ae7c5a-15d4-4c09-995c-ab0203114b08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1563", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "6", ",", "5", ",", "10", ",", "3", ",", 
      "12", ",", "11", ",", "9", ",", "4", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1563, " to ", 
   Images[{7, 2, 1, 6, 5, 10, 3, 12, 11, 9, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"60770844-1a4c-4122-815e-f32b8f60892d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1567", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "6", ",", "5", ",", "9", ",", "3", ",", 
      "12", ",", "11", ",", "10", ",", "4", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1567, " to ", 
   Images[{7, 2, 1, 6, 5, 9, 3, 12, 11, 10, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"0567334c-5318-4365-b576-07c5bbc8b794"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1587", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "4", ",", "3", ",", "10", ",", "5", ",", 
      "11", ",", "12", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1587, " to ", 
   Images[{7, 2, 1, 4, 3, 10, 5, 11, 12, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"bf811118-b861-4e9d-94b0-33b411058fb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1591", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "4", ",", "3", ",", "9", ",", "5", ",", 
      "11", ",", "12", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1591, " to ", 
   Images[{7, 2, 1, 4, 3, 9, 5, 11, 12, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"75aad003-7bbb-4c3d-a1e9-8ca92186e5d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1595", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "4", ",", "3", ",", "10", ",", "5", ",", 
      "12", ",", "11", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1595, " to ", 
   Images[{7, 2, 1, 4, 3, 10, 5, 12, 11, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"029a07c0-7a5f-479a-90d3-0e9948a7ee0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1599", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "4", ",", "3", ",", "9", ",", "5", ",", 
      "12", ",", "11", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1599, " to ", 
   Images[{7, 2, 1, 4, 3, 9, 5, 12, 11, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"bde9f774-9621-48e0-935c-6d94445e41a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1787", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "4", ",", "3", ",", "12", ",", "5", ",", 
      "10", ",", "9", ",", "11", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1787, " to ", 
   Images[{7, 2, 1, 4, 3, 12, 5, 10, 9, 11, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"25304f3c-c087-4cb5-b92e-522fd780804d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1791", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "7", ",", "2", ",", "1", ",", "4", ",", "3", ",", "11", ",", "5", ",", 
      "10", ",", "9", ",", "12", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 1791, " to ", 
   Images[{7, 2, 1, 4, 3, 11, 5, 10, 9, 12, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"1611689e-5fbd-459e-8f8f-0bd85f991929"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2321", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "7", ",", "8", ",", "10", ",", "3", ",", 
      "11", ",", "12", ",", "9", ",", "4", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2321, " to ", 
   Images[{5, 2, 1, 7, 8, 10, 3, 11, 12, 9, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"fc0044d8-7675-4d1b-8d2f-536c708bec09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2323", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "8", ",", "7", ",", "10", ",", "3", ",", 
      "11", ",", "12", ",", "9", ",", "4", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2323, " to ", 
   Images[{5, 2, 1, 8, 7, 10, 3, 11, 12, 9, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"a02ba323-5431-4dc3-925c-3f2be2eebe5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2327", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "8", ",", "7", ",", "9", ",", "3", ",", 
      "11", ",", "12", ",", "10", ",", "4", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2327, " to ", 
   Images[{5, 2, 1, 8, 7, 9, 3, 11, 12, 10, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"64c10f77-6e8f-489b-9e64-063247cd6226"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2331", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "8", ",", "7", ",", "10", ",", "3", ",", 
      "12", ",", "11", ",", "9", ",", "4", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2331, " to ", 
   Images[{5, 2, 1, 8, 7, 10, 3, 12, 11, 9, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"cec4c06c-925b-4c54-aea1-5d9f09375170"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2335", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "8", ",", "7", ",", "9", ",", "3", ",", 
      "12", ",", "11", ",", "10", ",", "4", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2335, " to ", 
   Images[{5, 2, 1, 8, 7, 9, 3, 12, 11, 10, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ddaa5764-666f-47f0-abe8-7fc452fe32c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2355", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "4", ",", "3", ",", "10", ",", "7", ",", 
      "11", ",", "12", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2355, " to ", 
   Images[{5, 2, 1, 4, 3, 10, 7, 11, 12, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"453098d0-a810-491d-ba93-e454792e416b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2359", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "4", ",", "3", ",", "9", ",", "7", ",", 
      "11", ",", "12", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2359, " to ", 
   Images[{5, 2, 1, 4, 3, 9, 7, 11, 12, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"58e65d2d-8e75-4d73-bba7-9c9f79214865"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2363", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "4", ",", "3", ",", "10", ",", "7", ",", 
      "12", ",", "11", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2363, " to ", 
   Images[{5, 2, 1, 4, 3, 10, 7, 12, 11, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ba9e2876-f59b-4e32-a97e-43fb79253b11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2367", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "4", ",", "3", ",", "9", ",", "7", ",", 
      "12", ",", "11", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2367, " to ", 
   Images[{5, 2, 1, 4, 3, 9, 7, 12, 11, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"fc2d28af-2ae4-402a-bf67-20606f08aa3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2555", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "4", ",", "3", ",", "12", ",", "7", ",", 
      "10", ",", "9", ",", "11", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2555, " to ", 
   Images[{5, 2, 1, 4, 3, 12, 7, 10, 9, 11, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"080217ab-5683-43da-a359-c0aa83c55909"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2559", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "5", ",", "2", ",", "1", ",", "4", ",", "3", ",", "11", ",", "7", ",", 
      "10", ",", "9", ",", "12", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 2559, " to ", 
   Images[{5, 2, 1, 4, 3, 11, 7, 10, 9, 12, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"b6d65cf2-185a-4c19-8a0c-bf5dbb1f9c99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3089", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "7", ",", "8", ",", "10", ",", "5", ",", 
      "11", ",", "12", ",", "9", ",", "6", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3089, " to ", 
   Images[{3, 2, 1, 7, 8, 10, 5, 11, 12, 9, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"94214897-e5cc-4d4b-bb11-dc7e0df34866"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3091", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "8", ",", "7", ",", "10", ",", "5", ",", 
      "11", ",", "12", ",", "9", ",", "6", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3091, " to ", 
   Images[{3, 2, 1, 8, 7, 10, 5, 11, 12, 9, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"d6193336-e1d8-43da-9fcd-2972ae60d4b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3095", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "8", ",", "7", ",", "9", ",", "5", ",", 
      "11", ",", "12", ",", "10", ",", "6", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3095, " to ", 
   Images[{3, 2, 1, 8, 7, 9, 5, 11, 12, 10, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"e968f378-f560-482e-bf63-dc11d93c9c38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3099", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "8", ",", "7", ",", "10", ",", "5", ",", 
      "12", ",", "11", ",", "9", ",", "6", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3099, " to ", 
   Images[{3, 2, 1, 8, 7, 10, 5, 12, 11, 9, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ed032ee9-27cf-43ac-8d7f-692f83fdbbe4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3103", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "8", ",", "7", ",", "9", ",", "5", ",", 
      "12", ",", "11", ",", "10", ",", "6", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3103, " to ", 
   Images[{3, 2, 1, 8, 7, 9, 5, 12, 11, 10, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"bcd23380-6e55-4274-a3ad-a7fedeab99db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3123", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "6", ",", "5", ",", "10", ",", "7", ",", 
      "11", ",", "12", ",", "9", ",", "8", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3123, " to ", 
   Images[{3, 2, 1, 6, 5, 10, 7, 11, 12, 9, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"8b26fee5-bf30-4d5d-9144-858a1e41d1e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3127", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "6", ",", "5", ",", "9", ",", "7", ",", 
      "11", ",", "12", ",", "10", ",", "8", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3127, " to ", 
   Images[{3, 2, 1, 6, 5, 9, 7, 11, 12, 10, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"20ffc308-e681-408f-aae3-e273271e0983"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3131", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "6", ",", "5", ",", "10", ",", "7", ",", 
      "12", ",", "11", ",", "9", ",", "8", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3131, " to ", 
   Images[{3, 2, 1, 6, 5, 10, 7, 12, 11, 9, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"d5c0801c-7c32-4f72-be79-9e115774fed1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3135", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "6", ",", "5", ",", "9", ",", "7", ",", 
      "12", ",", "11", ",", "10", ",", "8", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3135, " to ", 
   Images[{3, 2, 1, 6, 5, 9, 7, 12, 11, 10, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"c382016f-949b-4bba-8887-67a3c9f53a5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3323", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "6", ",", "5", ",", "12", ",", "7", ",", 
      "10", ",", "9", ",", "11", ",", "8", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3323, " to ", 
   Images[{3, 2, 1, 6, 5, 12, 7, 10, 9, 11, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"62aed591-a17a-4913-ae93-4b15630bf935"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3327", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "3", ",", "2", ",", "1", ",", "6", ",", "5", ",", "11", ",", "7", ",", 
      "10", ",", "9", ",", "12", ",", "8", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 1, ", j=", 3327, " to ", 
   Images[{3, 2, 1, 6, 5, 11, 7, 10, 9, 12, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"bfd087f8-505b-434e-906d-eab69208d8bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "12", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
       "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1, " to ", -
   Images[{2, 12, 1, 5, 6, 8, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"0fb54525-9bd3-4b2b-8700-7c7ea5120d91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "12", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
       "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3, " to ", -
   Images[{2, 12, 1, 6, 5, 8, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"afe4b49b-b604-4c6e-9296-6ccf0ef3ecd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "12", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
       "9", ",", "10", ",", "8", ",", "4", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 7, " to ", -
   Images[{2, 12, 1, 6, 5, 7, 3, 9, 10, 8, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"2728e7e1-560a-471f-96bb-f439137d895a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "12", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
       "10", ",", "9", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 11, " to ", -
   Images[{2, 12, 1, 6, 5, 8, 3, 10, 9, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"5da2c369-a60a-4fac-b286-c3d1b9d9eaa5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "12", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
       "10", ",", "9", ",", "8", ",", "4", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 15, " to ", -
   Images[{2, 12, 1, 6, 5, 7, 3, 10, 9, 8, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"c3a50f30-f471-40f0-820a-aaa95547b394"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
       "9", ",", "10", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 17, " to ", -
   Images[{2, 11, 1, 5, 6, 8, 3, 9, 10, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"d0e26858-2664-4481-8206-ef5bd7019990"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
       "9", ",", "10", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 19, " to ", -
   Images[{2, 11, 1, 6, 5, 8, 3, 9, 10, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"157423e6-a565-4442-ae60-8945c6488cbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
       "9", ",", "10", ",", "8", ",", "4", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 23, " to ", -
   Images[{2, 11, 1, 6, 5, 7, 3, 9, 10, 8, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"e43629a4-9ac1-40fa-9a25-f57944df4d76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
       "10", ",", "9", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 27, " to ", -
   Images[{2, 11, 1, 6, 5, 8, 3, 10, 9, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"5a7972a2-3c80-43c1-bd6b-565121d50639"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
       "10", ",", "9", ",", "8", ",", "4", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 31, " to ", -
   Images[{2, 11, 1, 6, 5, 7, 3, 10, 9, 8, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"d9086629-2ce2-4103-892d-dca485f12e0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "51", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "4", ",", "3", ",", "8", ",", "5", ",", 
       "9", ",", "10", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 51, " to ", -
   Images[{2, 11, 1, 4, 3, 8, 5, 9, 10, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"035d0022-fa11-4c54-8142-3e2618f30154"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "55", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "4", ",", "3", ",", "7", ",", "5", ",", 
       "9", ",", "10", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 55, " to ", -
   Images[{2, 11, 1, 4, 3, 7, 5, 9, 10, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"20eb675b-1684-4aee-aacb-7680e4f056d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "59", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "4", ",", "3", ",", "8", ",", "5", ",", 
       "10", ",", "9", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 59, " to ", -
   Images[{2, 11, 1, 4, 3, 8, 5, 10, 9, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"98c415bc-8a77-4e1c-8cd0-d99922f8c208"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "63", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "4", ",", "3", ",", "7", ",", "5", ",", 
       "10", ",", "9", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 63, " to ", -
   Images[{2, 11, 1, 4, 3, 7, 5, 10, 9, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"2a77afdc-05c3-4109-bc8b-73a008760f92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "251", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "4", ",", "3", ",", "10", ",", "5", ",", 
       "8", ",", "7", ",", "9", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 251, " to ", -
   Images[{2, 11, 1, 4, 3, 10, 5, 8, 7, 9, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"58e23aeb-df4c-4ccc-9603-1fb7e24074d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "255", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "11", ",", "1", ",", "4", ",", "3", ",", "9", ",", "5", ",", 
       "8", ",", "7", ",", "10", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 255, " to ", -
   Images[{2, 11, 1, 4, 3, 9, 5, 8, 7, 10, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"404c4ef4-d7fa-416e-86cd-b350902f11f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "785", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "5", ",", "6", ",", "8", ",", "3", ",", 
       "11", ",", "12", ",", "7", ",", "4", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 785, " to ", -
   Images[{2, 9, 1, 5, 6, 8, 3, 11, 12, 7, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"9ea71777-df11-49bf-901b-5110139dcecb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "787", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
       "11", ",", "12", ",", "7", ",", "4", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 787, " to ", -
   Images[{2, 9, 1, 6, 5, 8, 3, 11, 12, 7, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"5a89da19-3bb7-4055-b5f9-587588866540"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "791", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
       "11", ",", "12", ",", "8", ",", "4", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 791, " to ", -
   Images[{2, 9, 1, 6, 5, 7, 3, 11, 12, 8, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"fb9867eb-081c-433b-bff4-5945697f811e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "795", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "6", ",", "5", ",", "8", ",", "3", ",", 
       "12", ",", "11", ",", "7", ",", "4", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 795, " to ", -
   Images[{2, 9, 1, 6, 5, 8, 3, 12, 11, 7, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"8219a651-b654-4819-ac9e-d791124054b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "799", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "6", ",", "5", ",", "7", ",", "3", ",", 
       "12", ",", "11", ",", "8", ",", "4", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 799, " to ", -
   Images[{2, 9, 1, 6, 5, 7, 3, 12, 11, 8, 4, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"27fbf619-0f98-40fb-94af-df3a7d61529c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "819", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "4", ",", "3", ",", "8", ",", "5", ",", 
       "11", ",", "12", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 819, " to ", -
   Images[{2, 9, 1, 4, 3, 8, 5, 11, 12, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"d3ac0d92-4b2f-4e81-9f57-ab2c65d479c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "823", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "4", ",", "3", ",", "7", ",", "5", ",", 
       "11", ",", "12", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 823, " to ", -
   Images[{2, 9, 1, 4, 3, 7, 5, 11, 12, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"e5f62877-1807-4844-8dcb-7dbed6eaff1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "827", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "4", ",", "3", ",", "8", ",", "5", ",", 
       "12", ",", "11", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 827, " to ", -
   Images[{2, 9, 1, 4, 3, 8, 5, 12, 11, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"23ed5c57-fc52-4228-a7d0-fe5256d2e2eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "831", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "4", ",", "3", ",", "7", ",", "5", ",", 
       "12", ",", "11", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 831, " to ", -
   Images[{2, 9, 1, 4, 3, 7, 5, 12, 11, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"eab09f46-5e4f-46e0-a8c1-7aed72f16ea1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1019", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "4", ",", "3", ",", "12", ",", "5", ",", 
       "8", ",", "7", ",", "11", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1019, " to ", -
   Images[{2, 9, 1, 4, 3, 12, 5, 8, 7, 11, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"66041728-97f6-44c9-a37d-5cb4eaa6763b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1023", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "9", ",", "1", ",", "4", ",", "3", ",", "11", ",", "5", ",", 
       "8", ",", "7", ",", "12", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1023, " to ", -
   Images[{2, 9, 1, 4, 3, 11, 5, 8, 7, 12, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"c2e884d9-c3a4-4dd4-9931-c6b48bffe3df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1553", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "5", ",", "6", ",", "10", ",", "3", ",", 
       "11", ",", "12", ",", "9", ",", "4", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1553, " to ", -
   Images[{2, 7, 1, 5, 6, 10, 3, 11, 12, 9, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"7f5c6812-1abf-4868-acf9-242fd33f859d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1555", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "6", ",", "5", ",", "10", ",", "3", ",", 
       "11", ",", "12", ",", "9", ",", "4", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1555, " to ", -
   Images[{2, 7, 1, 6, 5, 10, 3, 11, 12, 9, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"b2c2cd61-8ec6-4aff-ae1a-efc169862ab5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1559", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "6", ",", "5", ",", "9", ",", "3", ",", 
       "11", ",", "12", ",", "10", ",", "4", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1559, " to ", -
   Images[{2, 7, 1, 6, 5, 9, 3, 11, 12, 10, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"96aaf06d-1ae1-445c-a7f0-75b98df8eaf4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1563", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "6", ",", "5", ",", "10", ",", "3", ",", 
       "12", ",", "11", ",", "9", ",", "4", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1563, " to ", -
   Images[{2, 7, 1, 6, 5, 10, 3, 12, 11, 9, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ab8807df-3afe-4996-91c5-89e5ac58dea3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1567", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "6", ",", "5", ",", "9", ",", "3", ",", 
       "12", ",", "11", ",", "10", ",", "4", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1567, " to ", -
   Images[{2, 7, 1, 6, 5, 9, 3, 12, 11, 10, 4, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"0bd8d6c1-ea64-4bff-9c6a-323fa7bafe62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1587", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "4", ",", "3", ",", "10", ",", "5", ",", 
       "11", ",", "12", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1587, " to ", -
   Images[{2, 7, 1, 4, 3, 10, 5, 11, 12, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"06168a18-36ee-46ad-902b-1b8308818bd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1591", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "4", ",", "3", ",", "9", ",", "5", ",", 
       "11", ",", "12", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1591, " to ", -
   Images[{2, 7, 1, 4, 3, 9, 5, 11, 12, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"84132d52-03ff-4421-be4c-0740b5269816"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1595", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "4", ",", "3", ",", "10", ",", "5", ",", 
       "12", ",", "11", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1595, " to ", -
   Images[{2, 7, 1, 4, 3, 10, 5, 12, 11, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"8741ccde-1508-40ad-8a88-cf0ec7c20f43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1599", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "4", ",", "3", ",", "9", ",", "5", ",", 
       "12", ",", "11", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1599, " to ", -
   Images[{2, 7, 1, 4, 3, 9, 5, 12, 11, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"d9d54674-792e-4252-ad72-19c0f833fca3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1787", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "4", ",", "3", ",", "12", ",", "5", ",", 
       "10", ",", "9", ",", "11", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1787, " to ", -
   Images[{2, 7, 1, 4, 3, 12, 5, 10, 9, 11, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"e9441f0c-31fe-4930-913c-fbff5ef64582"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1791", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "7", ",", "1", ",", "4", ",", "3", ",", "11", ",", "5", ",", 
       "10", ",", "9", ",", "12", ",", "6", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 1791, " to ", -
   Images[{2, 7, 1, 4, 3, 11, 5, 10, 9, 12, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"00c7cd21-7226-417d-a0a9-56dd20638a86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2321", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "7", ",", "8", ",", "10", ",", "3", ",", 
       "11", ",", "12", ",", "9", ",", "4", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2321, " to ", -
   Images[{2, 5, 1, 7, 8, 10, 3, 11, 12, 9, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"faa04311-2eb8-4fa0-ab24-2357f1c47590"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2323", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "8", ",", "7", ",", "10", ",", "3", ",", 
       "11", ",", "12", ",", "9", ",", "4", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2323, " to ", -
   Images[{2, 5, 1, 8, 7, 10, 3, 11, 12, 9, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"b8b05b7c-79db-476d-ac1f-29a955f4e5b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2327", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "8", ",", "7", ",", "9", ",", "3", ",", 
       "11", ",", "12", ",", "10", ",", "4", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2327, " to ", -
   Images[{2, 5, 1, 8, 7, 9, 3, 11, 12, 10, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"8f06ce99-8f84-4358-86a0-e4706096af19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2331", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "8", ",", "7", ",", "10", ",", "3", ",", 
       "12", ",", "11", ",", "9", ",", "4", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2331, " to ", -
   Images[{2, 5, 1, 8, 7, 10, 3, 12, 11, 9, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"e1d8cff1-c061-4364-aa33-ac230ef7e589"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2335", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "8", ",", "7", ",", "9", ",", "3", ",", 
       "12", ",", "11", ",", "10", ",", "4", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2335, " to ", -
   Images[{2, 5, 1, 8, 7, 9, 3, 12, 11, 10, 4, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"56b6aa31-ffd7-4991-96ea-474ae22fdebc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2355", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "4", ",", "3", ",", "10", ",", "7", ",", 
       "11", ",", "12", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2355, " to ", -
   Images[{2, 5, 1, 4, 3, 10, 7, 11, 12, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"4330e4de-e98e-4c36-b7f0-5b93c2950724"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2359", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "4", ",", "3", ",", "9", ",", "7", ",", 
       "11", ",", "12", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2359, " to ", -
   Images[{2, 5, 1, 4, 3, 9, 7, 11, 12, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"f3c05e13-0766-4fd3-95bb-ac5496b1e53f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2363", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "4", ",", "3", ",", "10", ",", "7", ",", 
       "12", ",", "11", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2363, " to ", -
   Images[{2, 5, 1, 4, 3, 10, 7, 12, 11, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"c4920958-13ed-4c41-afe3-c2a8967bcf36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2367", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "4", ",", "3", ",", "9", ",", "7", ",", 
       "12", ",", "11", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2367, " to ", -
   Images[{2, 5, 1, 4, 3, 9, 7, 12, 11, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"63466ba6-03dd-4906-8964-7c260f255369"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2555", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "4", ",", "3", ",", "12", ",", "7", ",", 
       "10", ",", "9", ",", "11", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2555, " to ", -
   Images[{2, 5, 1, 4, 3, 12, 7, 10, 9, 11, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"9349aad4-4e86-4ae4-be54-6d142e01756f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2559", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "5", ",", "1", ",", "4", ",", "3", ",", "11", ",", "7", ",", 
       "10", ",", "9", ",", "12", ",", "8", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 2559, " to ", -
   Images[{2, 5, 1, 4, 3, 11, 7, 10, 9, 12, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"7eead643-1260-4861-aa4d-b568ab5fe653"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3089", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "7", ",", "8", ",", "10", ",", "5", ",", 
       "11", ",", "12", ",", "9", ",", "6", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3089, " to ", -
   Images[{2, 3, 1, 7, 8, 10, 5, 11, 12, 9, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"e22731d0-3c4a-4d30-8b74-09a83ba30346"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3091", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "8", ",", "7", ",", "10", ",", "5", ",", 
       "11", ",", "12", ",", "9", ",", "6", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3091, " to ", -
   Images[{2, 3, 1, 8, 7, 10, 5, 11, 12, 9, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"7af477b5-8d34-4b17-97d0-cd952cf924bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3095", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "8", ",", "7", ",", "9", ",", "5", ",", 
       "11", ",", "12", ",", "10", ",", "6", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3095, " to ", -
   Images[{2, 3, 1, 8, 7, 9, 5, 11, 12, 10, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"3ef0fe73-6e01-4b65-87b0-94987a34b8ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3099", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "8", ",", "7", ",", "10", ",", "5", ",", 
       "12", ",", "11", ",", "9", ",", "6", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3099, " to ", -
   Images[{2, 3, 1, 8, 7, 10, 5, 12, 11, 9, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"8164c638-3b36-44cf-8f5b-9d937b7cd8de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3103", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "8", ",", "7", ",", "9", ",", "5", ",", 
       "12", ",", "11", ",", "10", ",", "6", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3103, " to ", -
   Images[{2, 3, 1, 8, 7, 9, 5, 12, 11, 10, 6, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"52274af2-90b5-4b07-8fe7-c3d030e72fb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3123", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "6", ",", "5", ",", "10", ",", "7", ",", 
       "11", ",", "12", ",", "9", ",", "8", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3123, " to ", -
   Images[{2, 3, 1, 6, 5, 10, 7, 11, 12, 9, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"35362014-940c-4cff-b841-2bbadcf33ff1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3127", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "6", ",", "5", ",", "9", ",", "7", ",", 
       "11", ",", "12", ",", "10", ",", "8", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3127, " to ", -
   Images[{2, 3, 1, 6, 5, 9, 7, 11, 12, 10, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"fbcc06b1-78df-440d-96bc-6870bd22c280"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3131", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "6", ",", "5", ",", "10", ",", "7", ",", 
       "12", ",", "11", ",", "9", ",", "8", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3131, " to ", -
   Images[{2, 3, 1, 6, 5, 10, 7, 12, 11, 9, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"628b89b0-8319-43bd-9556-1fb5910abc4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3135", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "6", ",", "5", ",", "9", ",", "7", ",", 
       "12", ",", "11", ",", "10", ",", "8", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3135, " to ", -
   Images[{2, 3, 1, 6, 5, 9, 7, 12, 11, 10, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"689e6638-77ad-4fda-80c3-fa48b76b0a0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3323", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "6", ",", "5", ",", "12", ",", "7", ",", 
       "10", ",", "9", ",", "11", ",", "8", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3323, " to ", -
   Images[{2, 3, 1, 6, 5, 12, 7, 10, 9, 11, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ce780f8c-3813-470d-9bb8-76bfc122eeb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3327", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "6", ",", "5", ",", "11", ",", "7", ",", 
       "10", ",", "9", ",", "12", ",", "8", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 2, ", j=", 3327, " to ", -
   Images[{2, 3, 1, 6, 5, 11, 7, 10, 9, 12, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"6f3813b0-29a8-44c1-80cb-f9c8013bc6b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3421", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "2", ",", "3", ",", "1", ",", "11", ",", "5", ",", "12", ",", "7", ",", 
      "10", ",", "9", ",", "6", ",", "8", ",", "4"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 6, ", j=", 3421, " to ", 
   Images[{2, 3, 1, 11, 5, 12, 7, 10, 9, 6, 8, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"8ed26a27-9cab-4794-9958-610bf2a2bb66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "3572", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "3", ",", "1", ",", "6", ",", "5", ",", "10", ",", "7", ",", 
       "12", ",", "9", ",", "8", ",", "11", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 26, ", j=", 3572, " to ", -
   Images[{2, 3, 1, 6, 5, 10, 7, 12, 9, 8, 11, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"992c8a28-e5dc-4e1c-862c-8f3dfe76a913"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "12", ",", "2", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1, " to ", 
   Images[{1, 5, 12, 2, 6, 8, 3, 9, 10, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"f78d7696-c120-4b3a-8b25-57298e350f68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "12", ",", "2", ",", "6", ",", "7", ",", "3", ",", 
      "9", ",", "10", ",", "8", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 5, " to ", 
   Images[{1, 5, 12, 2, 6, 7, 3, 9, 10, 8, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"86700af1-d0cd-4c2d-aca8-30d9be34cdb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "12", ",", "2", ",", "6", ",", "8", ",", "3", ",", 
      "10", ",", "9", ",", "7", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 9, " to ", 
   Images[{1, 5, 12, 2, 6, 8, 3, 10, 9, 7, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"022fad44-553a-49a1-b143-a22f79dca231"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "12", ",", "2", ",", "6", ",", "7", ",", "3", ",", 
      "10", ",", "9", ",", "8", ",", "4", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 13, " to ", 
   Images[{1, 5, 12, 2, 6, 7, 3, 10, 9, 8, 4, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"f2fde46d-3a66-49a6-86a3-dfbd13ee6f9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "11", ",", "2", ",", "6", ",", "8", ",", "3", ",", 
      "9", ",", "10", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 17, " to ", 
   Images[{1, 5, 11, 2, 6, 8, 3, 9, 10, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"9367cd96-8428-499f-9fdb-6bc08750af2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "11", ",", "2", ",", "6", ",", "7", ",", "3", ",", 
      "9", ",", "10", ",", "8", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 21, " to ", 
   Images[{1, 5, 11, 2, 6, 7, 3, 9, 10, 8, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"e4ff66e9-a70d-485a-81c7-f54411bfc438"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "11", ",", "2", ",", "6", ",", "8", ",", "3", ",", 
      "10", ",", "9", ",", "7", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 25, " to ", 
   Images[{1, 5, 11, 2, 6, 8, 3, 10, 9, 7, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"2a5bec36-5cc4-4f76-a086-63bc191d93c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "5", ",", "11", ",", "2", ",", "6", ",", "7", ",", "3", ",", 
      "10", ",", "9", ",", "8", ",", "4", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 29, " to ", 
   Images[{1, 5, 11, 2, 6, 7, 3, 10, 9, 8, 4, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"86dac42f-50ac-405c-9497-76ca721d1522"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "12", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "9", ",", "10", ",", "7", ",", "6", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 33, " to ", 
   Images[{1, 3, 12, 2, 4, 8, 5, 9, 10, 7, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"757ec900-3c4e-4fd6-8376-e505e017af25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "12", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "9", ",", "10", ",", "8", ",", "6", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 37, " to ", 
   Images[{1, 3, 12, 2, 4, 7, 5, 9, 10, 8, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"b4887bcb-3d3a-401b-af2f-3079e0c2d3c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "12", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "10", ",", "9", ",", "7", ",", "6", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 41, " to ", 
   Images[{1, 3, 12, 2, 4, 8, 5, 10, 9, 7, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"4457f3f9-142e-4966-b3e4-f06d4ae1a54c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "45", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "12", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "10", ",", "9", ",", "8", ",", "6", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 45, " to ", 
   Images[{1, 3, 12, 2, 4, 7, 5, 10, 9, 8, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"d36846e8-a66b-44c1-99b0-2bd864c8079b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "9", ",", "10", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 49, " to ", 
   Images[{1, 3, 11, 2, 4, 8, 5, 9, 10, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"feed1df5-fcf4-4c68-9809-4d9fc3f40701"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "9", ",", "10", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 53, " to ", 
   Images[{1, 3, 11, 2, 4, 7, 5, 9, 10, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"6e80ea38-9d36-45c7-afa5-784e1596fd69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "10", ",", "9", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 57, " to ", 
   Images[{1, 3, 11, 2, 4, 8, 5, 10, 9, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"46053d05-0af0-48b9-b8ea-d990c63ed4b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "61", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "10", ",", "9", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 61, " to ", 
   Images[{1, 3, 11, 2, 4, 7, 5, 10, 9, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"747ee0eb-9566-4995-973d-8af707c8d1c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "249", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "10", ",", "5", ",", 
      "8", ",", "7", ",", "9", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 249, " to ", 
   Images[{1, 3, 11, 2, 4, 10, 5, 8, 7, 9, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"e62206cb-cff1-40e1-9f22-a3f6cb011e21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "253", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "11", ",", "2", ",", "4", ",", "9", ",", "5", ",", 
      "8", ",", "7", ",", "10", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 253, " to ", 
   Images[{1, 3, 11, 2, 4, 9, 5, 8, 7, 10, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"bca4a601-887a-4512-9713-b385f3377ba3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "817", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "11", ",", "12", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 817, " to ", 
   Images[{1, 3, 9, 2, 4, 8, 5, 11, 12, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"0156ac4c-5fd1-42f3-94a0-81e7f458d843"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "821", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "11", ",", "12", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 821, " to ", 
   Images[{1, 3, 9, 2, 4, 7, 5, 11, 12, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"6b893e11-c5e4-476c-ac62-28a9873342f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "825", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "8", ",", "5", ",", 
      "12", ",", "11", ",", "7", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 825, " to ", 
   Images[{1, 3, 9, 2, 4, 8, 5, 12, 11, 7, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"4668a91c-ee1e-4002-bbaf-4663b6cf7d3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "829", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "7", ",", "5", ",", 
      "12", ",", "11", ",", "8", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 829, " to ", 
   Images[{1, 3, 9, 2, 4, 7, 5, 12, 11, 8, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"f5a19231-97cb-4de0-ab9b-0a217f000766"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1017", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "12", ",", "5", ",", 
      "8", ",", "7", ",", "11", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1017, " to ", 
   Images[{1, 3, 9, 2, 4, 12, 5, 8, 7, 11, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"b182f76a-ee47-44a7-8b59-69630199d836"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1021", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "9", ",", "2", ",", "4", ",", "11", ",", "5", ",", 
      "8", ",", "7", ",", "12", ",", "6", ",", "10"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1021, " to ", 
   Images[{1, 3, 9, 2, 4, 11, 5, 8, 7, 12, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"4ca5cb9e-9ae5-40a5-aafb-6bef67e632a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1585", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "10", ",", "5", ",", 
      "11", ",", "12", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1585, " to ", 
   Images[{1, 3, 7, 2, 4, 10, 5, 11, 12, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"80f176c5-5f13-4931-a49e-f366b69039f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1589", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "9", ",", "5", ",", 
      "11", ",", "12", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1589, " to ", 
   Images[{1, 3, 7, 2, 4, 9, 5, 11, 12, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"695effaf-7a58-4839-988e-5b4a65f49cc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1593", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "10", ",", "5", ",", 
      "12", ",", "11", ",", "9", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1593, " to ", 
   Images[{1, 3, 7, 2, 4, 10, 5, 12, 11, 9, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"c466f69a-f7d3-42cd-92fb-d063a8d11cf1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1597", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "9", ",", "5", ",", 
      "12", ",", "11", ",", "10", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1597, " to ", 
   Images[{1, 3, 7, 2, 4, 9, 5, 12, 11, 10, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"04e5e79c-2979-4ab8-8e38-ae7c898993d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1785", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "12", ",", "5", ",", 
      "10", ",", "9", ",", "11", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1785, " to ", 
   Images[{1, 3, 7, 2, 4, 12, 5, 10, 9, 11, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"96c183bf-1409-4bee-95e7-f73f83a0c8a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1789", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "7", ",", "2", ",", "4", ",", "11", ",", "5", ",", 
      "10", ",", "9", ",", "12", ",", "6", ",", "8"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 1789, " to ", 
   Images[{1, 3, 7, 2, 4, 11, 5, 10, 9, 12, 6, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"9a2a3101-935d-40a8-bfd4-bec1c624b48b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2353", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "10", ",", "7", ",", 
      "11", ",", "12", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2353, " to ", 
   Images[{1, 3, 5, 2, 4, 10, 7, 11, 12, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ad7f8c37-b541-44a2-adb6-ebdf5f90fe16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2357", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "9", ",", "7", ",", 
      "11", ",", "12", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2357, " to ", 
   Images[{1, 3, 5, 2, 4, 9, 7, 11, 12, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"9ca16481-e5a6-449b-a89b-14a932ae9fdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2361", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "10", ",", "7", ",", 
      "12", ",", "11", ",", "9", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2361, " to ", 
   Images[{1, 3, 5, 2, 4, 10, 7, 12, 11, 9, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"47ec38f6-5d9a-42ad-8c04-88bbc51be69f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2365", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "9", ",", "7", ",", 
      "12", ",", "11", ",", "10", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2365, " to ", 
   Images[{1, 3, 5, 2, 4, 9, 7, 12, 11, 10, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"fe2fac16-cb5e-4bc8-967f-bde288c547b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2553", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "12", ",", "7", ",", 
      "10", ",", "9", ",", "11", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2553, " to ", 
   Images[{1, 3, 5, 2, 4, 12, 7, 10, 9, 11, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"80724425-7dd6-409f-a1a6-9b707aa320b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2557", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "5", ",", "2", ",", "4", ",", "11", ",", "7", ",", 
      "10", ",", "9", ",", "12", ",", "8", ",", "6"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 65, ", j=", 2557, " to ", 
   Images[{1, 3, 5, 2, 4, 11, 7, 10, 9, 12, 8, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"fcc871d2-b4ef-42f1-b5ba-2bd2b9e96d96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "12", ",", "4", ",", "8", ",", "5", ",", 
       "9", ",", "10", ",", "7", ",", "6", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 33, " to ", -
   Images[{1, 3, 2, 12, 4, 8, 5, 9, 10, 7, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"960496c8-0d83-4ca0-be7d-b4f77786f5ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "12", ",", "4", ",", "7", ",", "5", ",", 
       "9", ",", "10", ",", "8", ",", "6", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 37, " to ", -
   Images[{1, 3, 2, 12, 4, 7, 5, 9, 10, 8, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"fad0c8b4-9e82-4985-8151-1a3dd7484207"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "12", ",", "4", ",", "8", ",", "5", ",", 
       "10", ",", "9", ",", "7", ",", "6", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 41, " to ", -
   Images[{1, 3, 2, 12, 4, 8, 5, 10, 9, 7, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"b02eae82-0a1b-41d3-8987-92375697515d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "45", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "12", ",", "4", ",", "7", ",", "5", ",", 
       "10", ",", "9", ",", "8", ",", "6", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 45, " to ", -
   Images[{1, 3, 2, 12, 4, 7, 5, 10, 9, 8, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"17f51a4c-ba2f-4dab-8ca4-5fcccfddcae4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "11", ",", "4", ",", "8", ",", "5", ",", 
       "10", ",", "9", ",", "7", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 57, " to ", -
   Images[{1, 3, 2, 11, 4, 8, 5, 10, 9, 7, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"f024039d-6cc9-4300-a40e-17daecdbae89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "61", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "11", ",", "4", ",", "7", ",", "5", ",", 
       "10", ",", "9", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 61, " to ", -
   Images[{1, 3, 2, 11, 4, 7, 5, 10, 9, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"2ee6bbd7-58c1-457b-8613-ea3e46b39e08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "233", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "12", ",", "4", ",", "10", ",", "5", ",", 
       "8", ",", "7", ",", "9", ",", "6", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 233, " to ", -
   Images[{1, 3, 2, 12, 4, 10, 5, 8, 7, 9, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"51033bad-66e4-47c9-aac0-f3b0765f4493"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "237", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "12", ",", "4", ",", "9", ",", "5", ",", 
       "8", ",", "7", ",", "10", ",", "6", ",", "11"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 237, " to ", -
   Images[{1, 3, 2, 12, 4, 9, 5, 8, 7, 10, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"ce51ab72-534d-4296-a311-deae8371e8a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "249", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "11", ",", "4", ",", "10", ",", "5", ",", 
       "8", ",", "7", ",", "9", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 249, " to ", -
   Images[{1, 3, 2, 11, 4, 10, 5, 8, 7, 9, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"74abf0f0-8daf-4bca-91d0-72540f6f2116"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "253", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "11", ",", "4", ",", "9", ",", "5", ",", 
       "8", ",", "7", ",", "10", ",", "6", ",", "12"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 253, " to ", -
   Images[{1, 3, 2, 11, 4, 9, 5, 8, 7, 10, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"3dcf19e6-07d6-4f33-8def-7a589fd7988c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1017", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "9", ",", "4", ",", "12", ",", "5", ",", 
       "8", ",", "7", ",", "11", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 1017, " to ", -
   Images[{1, 3, 2, 9, 4, 12, 5, 8, 7, 11, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"332331fe-630e-46db-8676-14907a196577"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "1021", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "9", ",", "4", ",", "11", ",", "5", ",", 
       "8", ",", "7", ",", "12", ",", "6", ",", "10"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 67, ", j=", 1021, " to ", -
   Images[{1, 3, 2, 9, 4, 11, 5, 8, 7, 12, 6, 10}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"5798e3d1-0a8c-4a28-bdb8-5640f41280bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "12", ",", "7", ",", "4", ",", "5", ",", 
      "9", ",", "10", ",", "8", ",", "6", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 71, ", j=", 37, " to ", 
   Images[{1, 3, 2, 12, 7, 4, 5, 9, 10, 8, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"5e52d878-5455-4be9-a10b-d9b27cf5e6ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "45", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "12", ",", "7", ",", "4", ",", "5", ",", 
      "10", ",", "9", ",", "8", ",", "6", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 71, ", j=", 45, " to ", 
   Images[{1, 3, 2, 12, 7, 4, 5, 10, 9, 8, 6, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"dba924e2-65cd-4434-a6aa-3a411b5eb3f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "61", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "11", ",", "7", ",", "4", ",", "5", ",", 
      "10", ",", "9", ",", "8", ",", "6", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 71, ", j=", 61, " to ", 
   Images[{1, 3, 2, 11, 7, 4, 5, 10, 9, 8, 6, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"43dcdc1c-2335-4dc0-9109-e99da0ab981a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "101", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "12", ",", "5", ",", "4", ",", "7", ",", 
      "9", ",", "10", ",", "6", ",", "8", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 71, ", j=", 101, " to ", 
   Images[{1, 3, 2, 12, 5, 4, 7, 9, 10, 6, 8, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"59a91341-87af-4308-b40e-e2dda9deb6bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "109", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "12", ",", "5", ",", "4", ",", "7", ",", 
      "10", ",", "9", ",", "6", ",", "8", ",", "11"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 71, ", j=", 109, " to ", 
   Images[{1, 3, 2, 12, 5, 4, 7, 10, 9, 6, 8, 11}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"1af73d1a-0fc5-415c-bfa8-01cfe32a8281"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "125", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"Images", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "3", ",", "2", ",", "11", ",", "5", ",", "4", ",", "7", ",", 
      "10", ",", "9", ",", "6", ",", "8", ",", "12"}], "}"}], "]"}]}],
  SequenceForm["Change at i=", 71, ", j=", 125, " to ", 
   Images[{1, 3, 2, 11, 5, 4, 7, 10, 9, 6, 8, 12}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"2381a1f8-da78-46a0-9bec-23d3c9855b23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "103", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "109", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "12", ",", "5", ",", "4", ",", "7", ",", 
       "10", ",", "9", ",", "6", ",", "11", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 103, ", j=", 109, " to ", -
   Images[{1, 3, 2, 12, 5, 4, 7, 10, 9, 6, 11, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"a5586fde-74fd-42b4-9f5d-a7c1d2140512"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "343", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "877", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "10", ",", "5", ",", "4", ",", "7", ",", 
       "12", ",", "9", ",", "8", ",", "11", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 343, ", j=", 877, " to ", -
   Images[{1, 3, 2, 10, 5, 4, 7, 12, 9, 8, 11, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"bdc5be45-2581-4d06-aaa5-f9b810c71d0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "603", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2029", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "8", ",", "5", ",", "10", ",", "7", ",", 
       "12", ",", "9", ",", "4", ",", "11", ",", "6"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 603, ", j=", 2029, " to ", -
   Images[{1, 3, 2, 8, 5, 10, 7, 12, 9, 4, 11, 6}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"dbc4fdb2-7328-43f1-8fc3-05feaf8fd5d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "727", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2797", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "6", ",", "5", ",", "12", ",", "7", ",", 
       "10", ",", "9", ",", "4", ",", "11", ",", "8"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 727, ", j=", 2797, " to ", -
   Images[{1, 3, 2, 6, 5, 12, 7, 10, 9, 4, 11, 8}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"0c2f027e-84b0-468d-b2f2-2b8dbeeee7f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Change at i=\"\>", "\[InvisibleSpace]", "999", 
   "\[InvisibleSpace]", "\<\", j=\"\>", "\[InvisibleSpace]", "2733", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "6", ",", "5", ",", "10", ",", "7", ",", 
       "12", ",", "9", ",", "8", ",", "11", ",", "4"}], "}"}], "]"}]}]}],
  SequenceForm[
  "Change at i=", 999, ", j=", 2733, " to ", -
   Images[{1, 3, 2, 6, 5, 10, 7, 12, 9, 8, 11, 4}]],
  Editable->False]], "Print",
 CellLabel->
  "From In[314]:=",ExpressionUUID->"a8c1e984-ec47-427b-a66f-7892a8196a67"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1990.21638`", " ", "Second"}], ",", 
   RowBox[{"-", 
    RowBox[{"Images", "[", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "3", ",", "2", ",", "6", ",", "5", ",", "10", ",", "7", ",", 
       "12", ",", "9", ",", "8", ",", "11", ",", "4"}], "}"}], "]"}]}]}], 
  "}"}]], "Output",
 CellLabel->
  "Out[314]=",ExpressionUUID->"f9c45e5f-8035-4d88-8c82-adce5b09284b"]
}, Open  ]],

Cell[TextData[{
 StyleBox["CanonicalPerm\t\t\t\t", "DisplayMath"],
 StyleBox["Compute a canonical representative given the free and dummy \
indices of an object\n", "Text"],
 StyleBox["TimeVerbose\t\t\t\t\t", "DisplayMath"],
 StyleBox["Timings information\n", "Text"],
 StyleBox["xPermVerbose\t\t\t\t", "DisplayMath"],
 StyleBox["Detailed information of the internal processes\n", "Text"],
 StyleBox["OrderedBase\t\t\t\t\t", "DisplayMath"],
 StyleBox["Fill missing points in base with sorted points", "Text"]
}], "DefinitionBox",ExpressionUUID->"896a908b-0f1d-4aa9-89d5-7e3e6e5bd5ca"],

Cell["Index canonicalization", "SmallText",ExpressionUUID->"03876faf-b6af-4232-9b00-a191ea9a2e82"]
}, Closed]],

Cell["Final comments", "Subsection",ExpressionUUID->"6c4aafca-9dd7-48d6-9640-ea3e6eab6dab"],

Cell[CellGroupData[{

Cell["Statistics", "SubsectionIcon",ExpressionUUID->"a0b7fca0-4dc9-444a-b2d3-64ae35324918"],

Cell["\<\
This is the time used inside the Mathematica session, not counting the time \
in the external executable:\
\>", "MathCaption",ExpressionUUID->"61de75c9-e107-4c49-8711-aaeb52c72758"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeUsed", "[", "]"}]], "Input",
 CellLabel->
  "In[315]:=",ExpressionUUID->"641322be-624a-4d94-b5af-b8cbf3d78092"],

Cell[BoxData["40.943437`"], "Output",
 CellLabel->
  "Out[315]=",ExpressionUUID->"06acec31-2ae2-4ce1-9d9a-40356c469aae"]
}, Open  ]],

Cell["\<\
and again, this is the maximum memory used in the session, not counting the \
external executable:\
\>", "MathCaption",ExpressionUUID->"64b4e402-005f-4b50-acd9-4d79f10804bf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MaxMemoryUsed", "[", "]"}], "/", "1000"}], "/", 
  "1024."}]], "Input",
 CellLabel->
  "In[316]:=",ExpressionUUID->"81a47113-d3ac-49ba-aafb-2f24c48fafe1"],

Cell[BoxData["51.79371875`"], "Output",
 CellLabel->
  "Out[316]=",ExpressionUUID->"ca04403e-23ae-4fb4-b866-5fe8f4a319ed"]
}, Open  ]],

Cell["The package has these public reserved words:", "MathCaption",ExpressionUUID->"6ff45b8e-42ec-449d-970b-58566441dc85"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "xAct`xPerm`*"}]], "Input",
 CellLabel->
  "In[317]:=",ExpressionUUID->"7ff14b04-22ab-4ba6-8cd6-c604561c16ae"],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["xAct`xPerm`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["xAct`xPerm`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["AllBaseImages",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"AllBaseImages", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Orbits",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Orbits", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RightCosetRepresentative",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {
            "RightCosetRepresentative", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["BaseChange",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"BaseChange", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["OrderedBase",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"OrderedBase", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RightTransversal",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"RightTransversal", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["BaseChangeCheck",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"BaseChangeCheck", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["OrderOfGroup",
          BaseStyle->"InformationLink",
          ButtonData:>{
           "Info3568065452-2493619", {"OrderOfGroup", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Rules",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Rules", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["CanonicalPerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"CanonicalPerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PairSymmetric",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PairSymmetric", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Schreier",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Schreier", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Coset",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Coset", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Perm",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Perm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SchreierOrbit",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"SchreierOrbit", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Cycles",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Cycles", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermDeg",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"PermDeg", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SchreierOrbits",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"SchreierOrbits", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["DeleteRedundantGenerators",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {
            "DeleteRedundantGenerators", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermEqual",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"PermEqual", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SchreierSims",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"SchreierSims", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Dimino",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Dimino", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermGreater",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermGreater", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Search",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Search", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Disclaimer",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"Disclaimer", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermGreaterEqual",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermGreaterEqual", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SetStabilizer",
          BaseStyle->"InformationLink",
          ButtonData:>{
           "Info3568065452-2493619", {"SetStabilizer", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["DoubleCosetRepresentative",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {
            "DoubleCosetRepresentative", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermLength",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermLength", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SGSOfDummySet",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"SGSOfDummySet", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["DoubleTransversal",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"DoubleTransversal", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermLess",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"PermLess", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["SortB",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"SortB", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["DummySet",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"DummySet", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermLessEqual",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermLessEqual", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["Stabilizer",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"Stabilizer", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["FromBaseImage",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"FromBaseImage", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermMemberQ",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermMemberQ", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["StabilizerChain",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"StabilizerChain", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["GenSet",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"GenSet", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermOrderedQ",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermOrderedQ", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["StablePoints",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"StablePoints", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Group",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Group", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermPower",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"PermPower", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["StrongGenSet",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"StrongGenSet", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["ID",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"ID", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermProduct",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermProduct", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["TimeVerbose",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"TimeVerbose", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["Images",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Images", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermQ",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"PermQ", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["TraceSchreier",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"TraceSchreier", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["InversePerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"InversePerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermSignature",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermSignature", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["TranslatePerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"TranslatePerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["JoinSGS",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"JoinSGS", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermSort",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"PermSort", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["UseRules",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"UseRules", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["LeftTransversal",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"LeftTransversal", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermutationFromTo",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermutationFromTo", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["xPermVerbose",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"xPermVerbose", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["MathLink",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"MathLink", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermuteList",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"PermuteList", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["$Version",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"$Version", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["MinB",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"MinB", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["PermWord",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"PermWord", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["$xpermExecutable",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"$xpermExecutable", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["NonStablePoints",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"NonStablePoints", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RandomPerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"RandomPerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["$xpermLink",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"$xpermLink", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["NotationOfPerm",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"NotationOfPerm", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RepeatedSet",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"RepeatedSet", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["$xpermQ",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"$xpermQ", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"]},
        {
         ButtonBox["OnPoints",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"OnPoints", "xAct`xPerm`"}},
          
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RiemannSymmetric",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"RiemannSymmetric", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], ""},
        {
         ButtonBox["Orbit",
          BaseStyle->"InformationLink",
          ButtonData:>{"Info3568065452-2493619", {"Orbit", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], 
         ButtonBox["RiemannSymmetry",
          BaseStyle->"InformationLink",
          
          ButtonData:>{
           "Info3568065452-2493619", {"RiemannSymmetry", "xAct`xPerm`"}},
          ButtonNote->"xAct`xPerm`"], ""}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.31666666666666665`]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->Automatic]]], "Print", \
"InfoCell",ExpressionUUID->"4044e671-0ae1-4167-98d7-72dcbcae215b"]
}, Open  ]]
}, Closed]]
},
WindowSize->{1098, 696},
WindowMargins->{{Automatic, 90}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{
      ValueBox["FileName"]}], "Header"]}, {
   Cell[
    TextData[{
      ValueBox["FileName"]}], "Header"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, 
   Cell[
    TextData[{
     "\[Copyright]2003-2007 Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a"}], 
    "PageFooter"], Inherited}, {Inherited, 
   Cell[
    TextData[{
     "\[Copyright]2003-2004 Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a"}], 
    "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"FacingPages"->True,
"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{597.562, 842.375},
"PostScriptOutputFile":>FrontEnd`FileName[{"home", "jmm", "xTensor"}, 
  "xPermDoc.nb.ps", CharacterEncoding -> "iso8859-1"],
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->True,
"PrintingMargins"->{{54, 54}, {108, 108}}},
ShowSelection->True,
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"HelpBrowser.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S5.18.1"->{
  Cell[567, 22, 199, 8, 37, "Subsection",ExpressionUUID->"766dbcbd-18c0-43c3-be2c-40f283008ea4",
   CellTags->{"S5.18.1", "1.1"}],
  Cell[2054, 70, 2869, 57, 340, "Text",ExpressionUUID->"690e39f3-7ba5-459a-b536-bb58a3383d93",
   CellTags->{"S5.18.1", "1.2"}],
  Cell[5063, 134, 518, 11, 52, "MathCaption",ExpressionUUID->"267183c5-1c79-4a81-ba01-ed2a262e6fbf",
   CellTags->{"S5.18.1", "1.3"}],
  Cell[5606, 149, 130, 2, 24, "Input",ExpressionUUID->"81cd42e2-30e0-40c3-b1cc-46e55ecb16b7",
   CellTags->"S5.18.1"],
  Cell[5739, 153, 222, 5, 19, "Print",ExpressionUUID->"be915988-13db-4109-8901-a91082cb0bed",
   CellTags->"S5.18.1"],
  Cell[5964, 160, 494, 13, 20, "Print",ExpressionUUID->"c991fd0d-7b91-4e92-8ec0-623c14ef8ab5",
   CellTags->"S5.18.1"],
  Cell[6461, 175, 243, 5, 20, "Print",ExpressionUUID->"24888a6e-ce67-417d-a159-0d626ed3d58f",
   CellTags->"S5.18.1"],
  Cell[6707, 182, 222, 5, 19, "Print",ExpressionUUID->"a754bf74-2e8f-4783-9e2a-c0df7d7c002c",
   CellTags->"S5.18.1"],
  Cell[6932, 189, 377, 7, 36, "Print",ExpressionUUID->"7f76a2a7-486b-47e9-8bd9-b39638671f64",
   CellTags->"S5.18.1"],
  Cell[7312, 198, 222, 5, 19, "Print",ExpressionUUID->"0a19d73f-7334-432f-855e-aa368f7d2453",
   CellTags->"S5.18.1"],
  Cell[7537, 205, 200, 4, 20, "Print",ExpressionUUID->"b526af1b-91a1-431e-a5a4-21f0f1c7c758",
   CellTags->"S5.18.1"],
  Cell[7740, 211, 183, 4, 19, "Print",ExpressionUUID->"183d17af-2f3d-4bd5-9040-e22cbe31b263",
   CellTags->"S5.18.1"],
  Cell[66159, 1829, 160, 2, 25, "SubsectionIcon",ExpressionUUID->"d24cdbe1-b2d0-4a6b-902e-39106e095d65",
   CellTags->{"S5.18.1", "1.4"}],
  Cell[66752, 1843, 695, 17, 49, "MathCaption",ExpressionUUID->"e6317de9-7228-463a-9f84-f20ee8cd7689",
   CellTags->{"S5.18.1", "1.5"}]},
 "1.1"->{
  Cell[567, 22, 199, 8, 37, "Subsection",ExpressionUUID->"766dbcbd-18c0-43c3-be2c-40f283008ea4",
   CellTags->{"S5.18.1", "1.1"}]},
 "1.2"->{
  Cell[2054, 70, 2869, 57, 340, "Text",ExpressionUUID->"690e39f3-7ba5-459a-b536-bb58a3383d93",
   CellTags->{"S5.18.1", "1.2"}]},
 "1.3"->{
  Cell[5063, 134, 518, 11, 52, "MathCaption",ExpressionUUID->"267183c5-1c79-4a81-ba01-ed2a262e6fbf",
   CellTags->{"S5.18.1", "1.3"}]},
 "Info3568058412-2493619"->{
  Cell[54966, 1500, 695, 11, 95, "Print",ExpressionUUID->"a2a357f7-547e-4a68-be5f-c751f87c6a6e",
   CellTags->"Info3568058412-2493619"]},
 "1.4"->{
  Cell[66159, 1829, 160, 2, 25, "SubsectionIcon",ExpressionUUID->"d24cdbe1-b2d0-4a6b-902e-39106e095d65",
   CellTags->{"S5.18.1", "1.4"}]},
 "1.5"->{
  Cell[66752, 1843, 695, 17, 49, "MathCaption",ExpressionUUID->"e6317de9-7228-463a-9f84-f20ee8cd7689",
   CellTags->{"S5.18.1", "1.5"}]},
 "Info3568058560-2493619"->{
  Cell[194946, 5557, 568, 9, 77, "Print",ExpressionUUID->"e663917b-b9c4-4351-a8f1-c51f8abf05a3",
   CellTags->"Info3568058560-2493619"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S5.18.1", 734150, 20382},
 {"1.1", 735904, 20411},
 {"1.2", 736046, 20414},
 {"1.3", 736186, 20417},
 {"Info3568058412-2493619", 736351, 20420},
 {"1.4", 736499, 20423},
 {"1.5", 736649, 20426},
 {"Info3568058560-2493619", 736816, 20429}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 199, 8, 37, "Subsection",ExpressionUUID->"766dbcbd-18c0-43c3-be2c-40f283008ea4",
 CellTags->{"S5.18.1", "1.1"}],
Cell[769, 32, 210, 3, 22, "Text",ExpressionUUID->"f6925233-5dcf-4315-bf74-87fe9521f420"],
Cell[CellGroupData[{
Cell[1004, 39, 90, 0, 21, "SubsubsectionIcon",ExpressionUUID->"a400b7c5-162b-4efa-a199-6efd34692a6e"],
Cell[1097, 41, 828, 22, 149, "Text",ExpressionUUID->"e90ff518-5dce-4e53-a147-88ebb67fbdbe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1962, 68, 89, 0, 21, "SubsubsectionIcon",ExpressionUUID->"a1a3087b-0f0a-4824-8073-8aa7da3614ac"],
Cell[2054, 70, 2869, 57, 340, "Text",ExpressionUUID->"690e39f3-7ba5-459a-b536-bb58a3383d93",
 CellTags->{"S5.18.1", "1.2"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[4960, 132, 100, 0, 21, "SubsubsectionIcon",ExpressionUUID->"f6c91643-d159-4c9c-bc31-f84aa9d94542"],
Cell[5063, 134, 518, 11, 52, "MathCaption",ExpressionUUID->"267183c5-1c79-4a81-ba01-ed2a262e6fbf",
 CellTags->{"S5.18.1", "1.3"}],
Cell[CellGroupData[{
Cell[5606, 149, 130, 2, 24, "Input",ExpressionUUID->"81cd42e2-30e0-40c3-b1cc-46e55ecb16b7",
 CellTags->"S5.18.1"],
Cell[5739, 153, 222, 5, 19, "Print",ExpressionUUID->"be915988-13db-4109-8901-a91082cb0bed",
 CellTags->"S5.18.1"],
Cell[5964, 160, 494, 13, 20, "Print",ExpressionUUID->"c991fd0d-7b91-4e92-8ec0-623c14ef8ab5",
 CellTags->"S5.18.1"],
Cell[6461, 175, 243, 5, 20, "Print",ExpressionUUID->"24888a6e-ce67-417d-a159-0d626ed3d58f",
 CellTags->"S5.18.1"],
Cell[6707, 182, 222, 5, 19, "Print",ExpressionUUID->"a754bf74-2e8f-4783-9e2a-c0df7d7c002c",
 CellTags->"S5.18.1"],
Cell[6932, 189, 377, 7, 36, "Print",ExpressionUUID->"7f76a2a7-486b-47e9-8bd9-b39638671f64",
 CellTags->"S5.18.1"],
Cell[7312, 198, 222, 5, 19, "Print",ExpressionUUID->"0a19d73f-7334-432f-855e-aa368f7d2453",
 CellTags->"S5.18.1"],
Cell[7537, 205, 200, 4, 20, "Print",ExpressionUUID->"b526af1b-91a1-431e-a5a4-21f0f1c7c758",
 CellTags->"S5.18.1"],
Cell[7740, 211, 183, 4, 19, "Print",ExpressionUUID->"183d17af-2f3d-4bd5-9040-e22cbe31b263",
 CellTags->"S5.18.1"]
}, Open  ]],
Cell[7938, 218, 220, 5, 38, "MathCaption",ExpressionUUID->"ae2042a4-3e1d-4887-814a-12e99e806075"],
Cell[8161, 225, 201, 4, 25, "Input",ExpressionUUID->"a4c4cfcd-f39a-4742-8a5d-3290092a52b2"],
Cell[8365, 231, 387, 11, 38, "MathCaption",ExpressionUUID->"ccf67b49-8aa3-4096-ad51-6bdbe7418efd"],
Cell[8755, 244, 823, 21, 105, "Input",ExpressionUUID->"971655d6-323d-4d03-b736-87c0d0dd89fb"],
Cell[9581, 267, 241, 5, 41, "Text",ExpressionUUID->"daa62e7e-37e8-423a-b87d-703d58e30790"],
Cell[9825, 274, 133, 0, 37, "MathCaption",ExpressionUUID->"85c79bb1-e8f3-41aa-a820-ba04f90ec244"],
Cell[CellGroupData[{
Cell[9983, 278, 111, 1, 25, "Input",ExpressionUUID->"64084757-d5ef-4451-a6de-a27863b9100d"],
Cell[10097, 281, 109, 1, 23, "Output",ExpressionUUID->"81ffc939-e150-41f1-a5b4-845fedc312cb"]
}, Open  ]],
Cell[10221, 285, 116, 0, 37, "MathCaption",ExpressionUUID->"451ce6f1-1664-4160-82a1-812829d4b5bb"],
Cell[CellGroupData[{
Cell[10362, 289, 120, 1, 25, "Input",ExpressionUUID->"e4fb52cf-281c-4c5b-8637-1413698b9c9e"],
Cell[10485, 292, 190, 2, 24, "Output",ExpressionUUID->"9b39a2c3-2541-4a2a-91fd-bbae09b64b41"]
}, Open  ]],
Cell[10690, 297, 113, 0, 37, "MathCaption",ExpressionUUID->"ad13f2d1-44e2-4ab5-9387-cadb7a348e62"],
Cell[CellGroupData[{
Cell[10828, 301, 114, 1, 25, "Input",ExpressionUUID->"b87387da-19e8-4036-8c6a-f23e52a9fb92"],
Cell[10945, 304, 13473, 254, 57, "Output",ExpressionUUID->"42270b78-2afc-4e02-b995-c4687eab8590"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[24457, 563, 95, 0, 35, "Subsection",ExpressionUUID->"cdc867de-209c-4285-9480-dc3cde6cc69a"],
Cell[CellGroupData[{
Cell[24577, 567, 102, 0, 25, "SubsectionIcon",ExpressionUUID->"6730f55b-8726-4dd6-9514-ae654baec150"],
Cell[24682, 569, 2000, 30, 303, "Text",ExpressionUUID->"cadb087c-b8ec-443a-ad5a-135a016cd44a"]
}, Closed]],
Cell[CellGroupData[{
Cell[26719, 604, 110, 0, 25, "SubsectionIcon",ExpressionUUID->"394e66dc-327d-4adf-a23b-45a0a1f31b94"],
Cell[26832, 606, 1676, 28, 349, "Text",ExpressionUUID->"97d83658-2938-4793-99bb-68e8a44b8be4"],
Cell[28511, 636, 183, 2, 52, "DefinitionBox",ExpressionUUID->"a9f9dd65-943d-43ee-a81e-71bf87220eb9"],
Cell[28697, 640, 131, 0, 20, "Text",ExpressionUUID->"1c301353-8ac4-41d8-b1ac-1938375966d5"],
Cell[28831, 642, 898, 16, 87, "Text",ExpressionUUID->"b6cfba51-1d2d-40a7-832a-bc83f85a5838"],
Cell[29732, 660, 131, 0, 36, "MathCaption",ExpressionUUID->"136ef75f-7919-4aa5-a107-0a94037e9a75"],
Cell[CellGroupData[{
Cell[29888, 664, 389, 10, 25, "Input",ExpressionUUID->"384feb8e-4222-4699-a29b-e6992b2151a9"],
Cell[30280, 676, 229, 5, 24, "Output",ExpressionUUID->"6fc00a5b-3369-48ea-a4a1-f6ae9bf7ae63"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30546, 686, 223, 5, 25, "Input",ExpressionUUID->"118e3998-080b-48aa-953a-576e270cb528"],
Cell[30772, 693, 270, 7, 24, "Output",ExpressionUUID->"62b451b3-c898-44d9-9275-4660f45d49e2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31079, 705, 217, 5, 24, "Input",ExpressionUUID->"e5867821-dae0-4313-aecf-02d6beea7fdc"],
Cell[31299, 712, 341, 8, 23, "Output",ExpressionUUID->"3516a7cf-f129-40d2-ae16-955c4276b647"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31677, 725, 171, 3, 24, "Input",ExpressionUUID->"717942f3-a9c6-4948-87fe-b4b2713c14c8"],
Cell[31851, 730, 227, 5, 23, "Output",ExpressionUUID->"b9f441e1-a504-4f24-9d14-2366a82d9805"]
}, Open  ]],
Cell[32093, 738, 110, 0, 36, "MathCaption",ExpressionUUID->"ca73af2e-cfe6-472d-b36c-36d3198eb1ae"],
Cell[CellGroupData[{
Cell[32228, 742, 483, 14, 25, "Input",ExpressionUUID->"5660a704-e26e-4c9b-82f2-40dd20935108"],
Cell[32714, 758, 250, 6, 24, "Output",ExpressionUUID->"6a3f2cac-777c-4046-a3fa-f7c587d0fca0"]
}, Open  ]],
Cell[32979, 767, 119, 0, 36, "MathCaption",ExpressionUUID->"07aa7054-9563-4d11-8bbd-31f584e7833a"],
Cell[CellGroupData[{
Cell[33123, 771, 315, 8, 25, "Input",ExpressionUUID->"4640fd99-4891-4579-973e-39d3fac48b6a"],
Cell[33441, 781, 112, 1, 24, "Output",ExpressionUUID->"0c1e3b1b-940d-46f2-a928-a27608665346"]
}, Open  ]],
Cell[33568, 785, 308, 5, 52, "DefinitionBox",ExpressionUUID->"670f6be3-5d9f-4c56-9af0-a716d005d291"],
Cell[33879, 792, 117, 0, 20, "SmallText",ExpressionUUID->"c78fa8a1-db2b-4a54-b75f-39c668bbbe5b"]
}, Closed]],
Cell[CellGroupData[{
Cell[34033, 797, 112, 0, 25, "SubsectionIcon",ExpressionUUID->"266002ce-4afe-44c9-80c9-2a23c61a01c1"],
Cell[34148, 799, 390, 9, 34, "Text",ExpressionUUID->"78b426b3-013b-409c-975c-a9aef321d544"],
Cell[34541, 810, 179, 5, 37, "MathCaption",ExpressionUUID->"95c8abf0-1375-4201-be34-197752f35d67"],
Cell[CellGroupData[{
Cell[34745, 819, 239, 6, 24, "Input",ExpressionUUID->"6d9deed0-2ffc-42df-97b7-7e388f35c05e"],
Cell[34987, 827, 111, 1, 23, "Output",ExpressionUUID->"f2d07f47-d7d1-49b7-b95d-933e39c6a860"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35135, 833, 239, 6, 24, "Input",ExpressionUUID->"5c7aefb7-cba9-4586-8054-3ef7ad206878"],
Cell[35377, 841, 110, 1, 23, "Output",ExpressionUUID->"8cb5ad6a-918a-48b3-a81c-a35ceab85eb9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35524, 847, 241, 6, 25, "Input",ExpressionUUID->"20dce1de-9e92-4c4d-843c-3734d173dee7"],
Cell[35768, 855, 111, 1, 23, "Output",ExpressionUUID->"5acf6cc3-76b0-4529-8a6e-905d8de1d669"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35916, 861, 297, 8, 25, "Input",ExpressionUUID->"cedf2015-108f-453b-b6ab-1e9fbfe7ced0"],
Cell[36216, 871, 111, 1, 23, "Output",ExpressionUUID->"427f2235-648b-431c-acc5-8e53b182e0ca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36364, 877, 296, 7, 24, "Input",ExpressionUUID->"e4814fa0-486b-4cd1-b9c3-97efa38a9479"],
Cell[36663, 886, 111, 1, 23, "Output",ExpressionUUID->"e64c6316-e75c-431a-bb4f-685c4ec5639a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36811, 892, 320, 9, 25, "Input",ExpressionUUID->"055eb1cb-8573-4fb1-a002-3dbbccf01ac0"],
Cell[37134, 903, 110, 1, 23, "Output",ExpressionUUID->"c5dace5c-8c9e-49cc-b008-1facd6c5cb7d"]
}, Open  ]],
Cell[37259, 907, 180, 3, 36, "MathCaption",ExpressionUUID->"7d828137-a565-4e94-a5d2-8c02b87cd9cf"],
Cell[CellGroupData[{
Cell[37464, 914, 252, 6, 25, "Input",ExpressionUUID->"f637bff0-9b88-4a50-b2ee-ac14ef89506f"],
Cell[37719, 922, 107, 1, 23, "Output",ExpressionUUID->"b3f03ff0-043d-4ec1-8cc1-cbddc405787a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37863, 928, 287, 7, 25, "Input",ExpressionUUID->"541243ea-3174-4d80-8788-bbc966eea53c"],
Cell[38153, 937, 107, 1, 23, "Output",ExpressionUUID->"c66b74ca-6267-40d8-ae78-4f5f865afafa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38297, 943, 310, 8, 25, "Input",ExpressionUUID->"3553de0d-7a0d-45ae-91d5-c3f444944a3b"],
Cell[38610, 953, 108, 1, 23, "Output",ExpressionUUID->"8e022931-422a-42be-b5b6-4b41cf60d0c5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38755, 959, 252, 6, 25, "Input",ExpressionUUID->"7112c407-3777-471c-a4ed-5b7258c43beb"],
Cell[39010, 967, 107, 1, 23, "Output",ExpressionUUID->"1c583623-4149-4ee4-97b3-c60ae35e92ab"]
}, Open  ]],
Cell[39132, 971, 119, 0, 36, "MathCaption",ExpressionUUID->"a0d3a600-51ac-499c-96b6-697b772f6a12"],
Cell[CellGroupData[{
Cell[39276, 975, 167, 3, 25, "Input",ExpressionUUID->"f8c78275-88a5-4eaa-aadf-01c64c54f070"],
Cell[39446, 980, 107, 1, 23, "Output",ExpressionUUID->"ccd71de0-690e-49d6-bf23-0f7caf83215f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39590, 986, 252, 6, 25, "Input",ExpressionUUID->"ff7422d6-092c-47d6-a69b-0beb17c238d8"],
Cell[39845, 994, 107, 1, 23, "Output",ExpressionUUID->"14ecf498-702f-4513-b69f-5cd507d16068"]
}, Open  ]],
Cell[39967, 998, 592, 17, 50, "MathCaption",ExpressionUUID->"4765603a-1ce4-4965-97ff-ce8db2a0cd7c"],
Cell[CellGroupData[{
Cell[40584, 1019, 252, 6, 25, "Input",ExpressionUUID->"fca3b646-490d-497f-acaf-8ecd0dab3f25"],
Cell[40839, 1027, 107, 1, 23, "Output",ExpressionUUID->"70a5ad29-fab9-47cc-a7d3-5587345242d3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40983, 1033, 255, 6, 25, "Input",ExpressionUUID->"a10ce58a-5532-4d5c-bc44-aec5cb84daf7"],
Cell[41241, 1041, 107, 1, 23, "Output",ExpressionUUID->"f62cb94f-0e16-44df-b5ba-c2981ad44613"]
}, Open  ]],
Cell[41363, 1045, 321, 11, 37, "MathCaption",ExpressionUUID->"9d07680c-93b3-48c9-876f-54663e80c672"],
Cell[CellGroupData[{
Cell[41709, 1060, 259, 6, 24, "Input",ExpressionUUID->"64cc5821-a972-437b-8321-7a8d53b6fc07"],
Cell[41971, 1068, 155, 3, 23, "Output",ExpressionUUID->"232b6dbf-4211-4a4f-817c-f23397bdccf8"]
}, Open  ]],
Cell[42141, 1074, 149, 2, 36, "MathCaption",ExpressionUUID->"f69d4967-56d9-478f-8634-15636002b558"],
Cell[CellGroupData[{
Cell[42315, 1080, 171, 3, 25, "Input",ExpressionUUID->"1cef3716-0f68-4771-8776-86a9be53033b"],
Cell[42489, 1085, 360, 9, 24, "Output",ExpressionUUID->"107c399a-f7b0-4809-920f-bcce6d6847ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42886, 1099, 170, 3, 25, "Input",ExpressionUUID->"7674427f-c9ff-47ab-b016-ae96a90513c1"],
Cell[43059, 1104, 255, 6, 24, "Output",ExpressionUUID->"2a4b7438-0039-4013-b24f-f7fc00bbb5fb"]
}, Open  ]],
Cell[43329, 1113, 257, 4, 20, "Text",ExpressionUUID->"bc546de5-7809-4620-87d2-1f76ad992177"],
Cell[43589, 1119, 569, 14, 50, "MathCaption",ExpressionUUID->"218b1773-b509-4c34-a807-673bafaf165c"],
Cell[CellGroupData[{
Cell[44183, 1137, 352, 9, 24, "Input",ExpressionUUID->"cbc8d348-d9e6-4a76-bbae-0b41c36910a0"],
Cell[44538, 1148, 194, 4, 23, "Output",ExpressionUUID->"6c761486-66f4-4d3e-976e-24b79fbc4dcf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44769, 1157, 352, 9, 24, "Input",ExpressionUUID->"4ebfea04-2323-4d3a-9780-1e7d759fcdff"],
Cell[45124, 1168, 194, 4, 23, "Output",ExpressionUUID->"87b37c15-b181-429f-8c4e-5d53d6ce1d6d"]
}, Open  ]],
Cell[45333, 1175, 151, 2, 36, "MathCaption",ExpressionUUID->"7dee5af4-fd3d-4170-9a6d-aab07fcfc42c"],
Cell[CellGroupData[{
Cell[45509, 1181, 505, 14, 25, "Input",ExpressionUUID->"d0826aaa-3d7e-47b8-8ae2-2702fe1c8949"],
Cell[46017, 1197, 110, 1, 23, "Output",ExpressionUUID->"d1c66253-fd08-476f-add3-bc0620451766"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46164, 1203, 505, 14, 25, "Input",ExpressionUUID->"96c4fc27-4e54-4781-b694-f4b799f49c89"],
Cell[46672, 1219, 110, 1, 23, "Output",ExpressionUUID->"5d1f78f2-8111-42fd-b92a-b6e3a0f52eef"]
}, Open  ]],
Cell[46797, 1223, 98, 0, 36, "MathCaption",ExpressionUUID->"d54874c3-569e-423d-b8af-64a4b08977d8"],
Cell[CellGroupData[{
Cell[46920, 1227, 245, 6, 24, "Input",ExpressionUUID->"ca2fc7e2-376b-456e-8228-35c53a2b7a0a"],
Cell[47168, 1235, 204, 4, 23, "Output",ExpressionUUID->"e881a466-199f-4a87-8951-19374fbd5cfe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47409, 1244, 272, 7, 24, "Input",ExpressionUUID->"b15b07bf-0627-4c5c-ae3b-3367f46cf24d"],
Cell[47684, 1253, 204, 4, 23, "Output",ExpressionUUID->"4f4728dd-18c2-4204-b1f0-fe95c66290cb"]
}, Open  ]],
Cell[47903, 1260, 249, 4, 36, "MathCaption",ExpressionUUID->"63948a0f-e413-4527-9901-868f4b7abfce"],
Cell[CellGroupData[{
Cell[48177, 1268, 322, 8, 25, "Input",ExpressionUUID->"aac93864-aa7c-440e-aefd-69a970e68e8f"],
Cell[48502, 1278, 185, 4, 19, "Print",ExpressionUUID->"57138a98-6308-40cd-8810-09abc7f988e3"],
Cell[48690, 1284, 217, 5, 23, "Output",ExpressionUUID->"fd49a309-c36c-4ed2-a876-02dd72dcbfd9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48944, 1294, 397, 11, 25, "Input",ExpressionUUID->"83e18eda-69b1-45f6-a8ae-82256bb6a5ff"],
Cell[49344, 1307, 184, 4, 19, "Print",ExpressionUUID->"1687423b-5030-4104-adb3-cebbc5468970"],
Cell[49531, 1313, 217, 5, 23, "Output",ExpressionUUID->"c6fa0c24-71cf-4d0b-8c94-f70ee36c686d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49785, 1323, 167, 3, 24, "Input",ExpressionUUID->"fe8d54a1-f39c-4fe0-9fe1-73aa50e32e3a"],
Cell[49955, 1328, 217, 5, 23, "Output",ExpressionUUID->"4ed15727-8236-43ea-86d0-a3071458a1b4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50209, 1338, 281, 7, 24, "Input",ExpressionUUID->"4d15fd08-1832-47e2-af9f-ef2c2e772068"],
Cell[50493, 1347, 217, 5, 23, "Output",ExpressionUUID->"62c198ce-5c7e-4fd0-9d08-e65eead78b13"]
}, Open  ]],
Cell[50725, 1355, 161, 2, 36, "MathCaption",ExpressionUUID->"304bf320-177b-4986-b779-fb037a5a09ea"],
Cell[CellGroupData[{
Cell[50911, 1361, 488, 14, 24, "Input",ExpressionUUID->"06b284ca-8d44-48ac-8104-405eda884be0"],
Cell[51402, 1377, 441, 12, 23, "Output",ExpressionUUID->"aeefaa82-d8a5-4f5b-9dd9-34159dd18707"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51880, 1394, 173, 3, 25, "Input",ExpressionUUID->"9c926595-7180-44e8-b031-1fddcba7b424"],
Cell[52056, 1399, 447, 12, 24, "Output",ExpressionUUID->"c77d7c9f-be66-45e4-b96b-e4a40dc328de"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52540, 1416, 349, 9, 24, "Input",ExpressionUUID->"b7f8a6f2-2ccf-4d4a-b2b7-8d08e43e339e"],
Cell[52892, 1427, 110, 1, 23, "Output",ExpressionUUID->"9986aa89-4e81-4bb6-8067-180609da4a42"]
}, Open  ]],
Cell[53017, 1431, 271, 6, 37, "MathCaption",ExpressionUUID->"36ebcf76-db3d-4d53-8205-7d594cdbc714"],
Cell[CellGroupData[{
Cell[53313, 1441, 352, 9, 25, "Input",ExpressionUUID->"c1758240-0c84-408f-962f-9e58f507f873"],
Cell[53668, 1452, 110, 1, 23, "Output",ExpressionUUID->"210b14ec-ccc3-4c2d-bbf1-c356072ed107"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53815, 1458, 312, 8, 25, "Input",ExpressionUUID->"0b6ff003-cbe8-434d-8480-dc436d750ab7"],
Cell[54130, 1468, 111, 1, 23, "Output",ExpressionUUID->"5db88318-e27c-4468-b5f1-bff31cf27aa1"]
}, Open  ]],
Cell[54256, 1472, 548, 20, 50, "MathCaption",ExpressionUUID->"640d1624-3eda-43bf-a3ad-1c8317851eb1"],
Cell[CellGroupData[{
Cell[54829, 1496, 134, 2, 24, "Input",ExpressionUUID->"733c10cf-3878-4edf-9a01-13bbfc845c0d"],
Cell[54966, 1500, 695, 11, 95, "Print",ExpressionUUID->"a2a357f7-547e-4a68-be5f-c751f87c6a6e",
 CellTags->"Info3568058412-2493619"]
}, Open  ]],
Cell[55676, 1514, 114, 0, 36, "MathCaption",ExpressionUUID->"975aa5e3-3a4e-44f7-acee-7ecb24bc9b05"],
Cell[CellGroupData[{
Cell[55815, 1518, 279, 7, 24, "Input",ExpressionUUID->"d5747306-d40b-4a62-94ff-733dff6fa7c2"],
Cell[56097, 1527, 107, 1, 23, "Output",ExpressionUUID->"4dee7540-1857-4e41-9d50-8bd6dbc3cab6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56241, 1533, 386, 10, 24, "Input",ExpressionUUID->"46eaf66d-ae26-4e6d-b1ba-5667fd5327e2"],
Cell[56630, 1545, 162, 3, 23, "Output",ExpressionUUID->"a650429c-ac88-4bd5-b271-1e9ec00ffb68"]
}, Open  ]],
Cell[56807, 1551, 182, 3, 36, "MathCaption",ExpressionUUID->"d1c85db8-a1f8-4517-b0f3-6c4cc87360d9"],
Cell[CellGroupData[{
Cell[57014, 1558, 236, 6, 24, "Input",ExpressionUUID->"b6f4eb1f-12ae-418f-8907-a89b9d10acc8"],
Cell[57253, 1566, 204, 4, 23, "Output",ExpressionUUID->"a7e27d7d-37e4-4041-bea9-5546cafa550a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57494, 1575, 303, 8, 25, "Input",ExpressionUUID->"1afbd04b-8362-4756-bd37-13957be6830e"],
Cell[57800, 1585, 134, 2, 24, "Output",ExpressionUUID->"6c2d9162-eb74-4df7-833d-d38e4560a1dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57971, 1592, 270, 7, 25, "Input",ExpressionUUID->"4efea453-7e44-4226-b7ce-8d5380f29f58"],
Cell[58244, 1601, 219, 5, 24, "Output",ExpressionUUID->"3eeb620d-9144-44e2-8a75-bd414d7b14b8"]
}, Open  ]],
Cell[58478, 1609, 165, 4, 37, "MathCaption",ExpressionUUID->"3ce9026e-ff2a-46ed-b470-3248bdc605a9"],
Cell[CellGroupData[{
Cell[58668, 1617, 273, 7, 24, "Input",ExpressionUUID->"71ec8aee-a2d8-4fe5-a0a4-d649939d27c8"],
Cell[58944, 1626, 204, 4, 23, "Output",ExpressionUUID->"28401e9c-1005-4b63-8077-fd90dc30bab4"]
}, Open  ]],
Cell[59163, 1633, 147, 2, 36, "MathCaption",ExpressionUUID->"4ed7aa29-3c0d-4ae3-ae69-1f53a9047c73"],
Cell[CellGroupData[{
Cell[59335, 1639, 361, 9, 24, "Input",ExpressionUUID->"79b6fbbc-e08d-40a8-ac5e-ac1fe2a4b661"],
Cell[59699, 1650, 182, 3, 23, "Output",ExpressionUUID->"0c731639-18f3-4ffb-a184-9c6aaf43b1c7"]
}, Open  ]],
Cell[59896, 1656, 230, 6, 37, "MathCaption",ExpressionUUID->"f8e61af3-0f10-4119-b513-0bd396fd8995"],
Cell[CellGroupData[{
Cell[60151, 1666, 310, 7, 24, "Input",ExpressionUUID->"3526fc57-4d70-45cf-9df6-5d4e9c367c95"],
Cell[60464, 1675, 206, 4, 24, "Output",ExpressionUUID->"a82356c2-bc60-4cbc-88d9-32ddb4aaa36e"]
}, Open  ]],
Cell[60685, 1682, 140, 1, 36, "MathCaption",ExpressionUUID->"5638a5f0-dff2-4551-acab-08f919486cea"],
Cell[60828, 1685, 454, 13, 41, "Input",ExpressionUUID->"ffb3103d-0395-4512-beb9-8dd7c371257e"],
Cell[CellGroupData[{
Cell[61307, 1702, 395, 11, 25, "Input",ExpressionUUID->"cc632a85-d3e4-4e92-8cfb-8c622a518b2b"],
Cell[61705, 1715, 182, 3, 23, "Output",ExpressionUUID->"946400ad-0c7e-4815-985b-6329e1091695"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61924, 1723, 355, 9, 25, "Input",ExpressionUUID->"1fea20f4-1ee7-4025-8a83-2091cf9f8eea"],
Cell[62282, 1734, 182, 3, 23, "Output",ExpressionUUID->"f7c39d6a-0b00-40ab-9b54-77ebb88e2a17"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62501, 1742, 286, 7, 25, "Input",ExpressionUUID->"a8b255c1-3500-43bb-a705-48b48f03c491"],
Cell[62790, 1751, 182, 3, 23, "Output",ExpressionUUID->"edd5c9eb-2ae0-4adb-89f5-6f064c46fc40"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63009, 1759, 285, 6, 25, "Input",ExpressionUUID->"5342bdec-7f44-43bf-b0b9-f1d9907e0dea"],
Cell[63297, 1767, 182, 3, 23, "Output",ExpressionUUID->"8e577301-99e7-400d-adfd-6d56a67b0a18"]
}, Open  ]],
Cell[63494, 1773, 1371, 25, 192, "DefinitionBox",ExpressionUUID->"f36c45a2-1031-427c-bc44-5757873d0b20"],
Cell[64868, 1800, 141, 1, 20, "Text",ExpressionUUID->"dfdde587-2894-4d79-bad8-f6daaaf4d828"],
Cell[65012, 1803, 996, 19, 150, "DefinitionBox",ExpressionUUID->"11ac50ce-d3fe-4ab8-b891-091ecd8af219"],
Cell[66011, 1824, 111, 0, 20, "SmallText",ExpressionUUID->"da821241-890f-443d-a6df-be529a6d442b"]
}, Closed]],
Cell[CellGroupData[{
Cell[66159, 1829, 160, 2, 25, "SubsectionIcon",ExpressionUUID->"d24cdbe1-b2d0-4a6b-902e-39106e095d65",
 CellTags->{"S5.18.1", "1.4"}],
Cell[CellGroupData[{
Cell[66344, 1835, 109, 0, 21, "SubsubsectionIcon",ExpressionUUID->"4d517d70-8871-42c4-9845-48e7e344d879"],
Cell[66456, 1837, 293, 4, 33, "Text",ExpressionUUID->"b4eb114a-6b25-47b9-a820-366e2c8d84cf"],
Cell[66752, 1843, 695, 17, 49, "MathCaption",ExpressionUUID->"e6317de9-7228-463a-9f84-f20ee8cd7689",
 CellTags->{"S5.18.1", "1.5"}],
Cell[CellGroupData[{
Cell[67472, 1864, 148, 3, 24, "Input",ExpressionUUID->"577e379d-4020-4db4-b534-718b33db0b41"],
Cell[67623, 1869, 129, 1, 25, "Output",ExpressionUUID->"c12052c6-6db0-42f8-b411-be1444ded194"]
}, Open  ]],
Cell[67767, 1873, 221, 3, 36, "MathCaption",ExpressionUUID->"95480643-3850-402e-91e2-449566b0c109"],
Cell[CellGroupData[{
Cell[68013, 1880, 148, 2, 24, "Input",ExpressionUUID->"b7acfec8-8467-4658-8719-53472edeb023"],
Cell[68164, 1884, 128, 1, 25, "Output",ExpressionUUID->"39d7b7f7-ecf6-46cf-b5ab-358cc55ed0c9"]
}, Open  ]],
Cell[68307, 1888, 751, 13, 65, "MathCaption",ExpressionUUID->"314c0be4-8ff6-4f9c-8d69-d27ce3eefb1d"],
Cell[CellGroupData[{
Cell[69083, 1905, 410, 11, 24, "Input",ExpressionUUID->"e64b011e-8287-47af-9c90-8c5303b65301"],
Cell[69496, 1918, 2856, 76, 85, "Output",ExpressionUUID->"ec451499-a7f6-429d-9b8c-3ac6321fb04c"]
}, Open  ]],
Cell[72367, 1997, 379, 10, 38, "MathCaption",ExpressionUUID->"a176125e-2c10-4f55-a400-54a25033c32c"],
Cell[CellGroupData[{
Cell[72771, 2011, 459, 12, 25, "Input",ExpressionUUID->"4d604646-94d8-4b6d-9103-71aa19d69d00"],
Cell[73233, 2025, 109, 1, 23, "Output",ExpressionUUID->"08cbc7a9-b6fd-4733-9624-c57ec1c3bad2"]
}, Open  ]],
Cell[73357, 2029, 153, 2, 36, "MathCaption",ExpressionUUID->"6fb82c64-19ba-4988-ba19-ee5773cdf484"],
Cell[CellGroupData[{
Cell[73535, 2035, 322, 8, 25, "Input",ExpressionUUID->"b01f0851-568f-4d01-8f04-6e763a95a00e"],
Cell[73860, 2045, 769, 19, 40, "Output",ExpressionUUID->"817c5189-93be-4600-a9e2-c95eda373d20"]
}, Open  ]],
Cell[74644, 2067, 112, 0, 36, "MathCaption",ExpressionUUID->"aa44097f-a629-4ba7-8075-018efcffa33c"],
Cell[CellGroupData[{
Cell[74781, 2071, 325, 8, 25, "Input",ExpressionUUID->"920c4c7b-e3a8-4e72-9dc9-97ece510caea"],
Cell[75109, 2081, 769, 19, 40, "Output",ExpressionUUID->"652094d3-5d81-4f52-a5a5-ba8dc260de20"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75915, 2105, 325, 8, 25, "Input",ExpressionUUID->"a2153d3e-19d3-44ac-93e9-3938cf146cb6"],
Cell[76243, 2115, 769, 19, 40, "Output",ExpressionUUID->"2fd2d626-afb8-481f-a52d-ed184cf3547e"]
}, Open  ]],
Cell[77027, 2137, 178, 3, 36, "MathCaption",ExpressionUUID->"4ee97267-7c34-4827-95c2-27a4b7314768"],
Cell[CellGroupData[{
Cell[77230, 2144, 289, 7, 25, "Input",ExpressionUUID->"228b6b73-588f-4ba0-a764-82ee9fd00971"],
Cell[77522, 2153, 769, 19, 40, "Output",ExpressionUUID->"fb41452d-d7ab-4efb-9873-c105d2c29851"]
}, Open  ]],
Cell[78306, 2175, 515, 10, 80, "DefinitionBox",ExpressionUUID->"433f5519-49b4-4f13-93be-4ac8f9d97664"],
Cell[78824, 2187, 120, 0, 20, "Text",ExpressionUUID->"362fd3f8-28c9-4166-9dea-8f10ee4b0839"]
}, Closed]],
Cell[CellGroupData[{
Cell[78981, 2192, 113, 0, 17, "SubsubsectionIcon",ExpressionUUID->"5d07217d-35fc-4fe1-acbf-b5daf548fa16"],
Cell[79097, 2194, 266, 4, 33, "Text",ExpressionUUID->"67d257f8-0b31-4f66-aa0d-aaa2ac519d93"],
Cell[79366, 2200, 134, 0, 36, "MathCaption",ExpressionUUID->"c6af736b-e906-4f6e-b7eb-6b8827fb4948"],
Cell[CellGroupData[{
Cell[79525, 2204, 558, 15, 25, "Input",ExpressionUUID->"3a73d3b1-cef8-48ba-9d78-88fbdda23014"],
Cell[80086, 2221, 109, 1, 23, "Output",ExpressionUUID->"1f35b0ef-edac-4db8-9ca5-5aa9485005eb"]
}, Open  ]],
Cell[80210, 2225, 105, 0, 36, "MathCaption",ExpressionUUID->"dd74e4b1-520f-43f8-8f61-c44a6b5754f6"],
Cell[CellGroupData[{
Cell[80340, 2229, 558, 15, 25, "Input",ExpressionUUID->"cdc61a27-8ded-456c-8551-cb45d193f540"],
Cell[80901, 2246, 107, 1, 23, "Output",ExpressionUUID->"a434e140-496f-4ed3-9ecf-2c540329d1a2"]
}, Open  ]],
Cell[81023, 2250, 156, 2, 36, "MathCaption",ExpressionUUID->"2a8c77f3-40cb-48f4-8b16-a50fed43afb1"],
Cell[CellGroupData[{
Cell[81204, 2256, 382, 9, 24, "Input",ExpressionUUID->"f48e4efd-7729-488f-8498-1382eef8a2d5"],
Cell[81589, 2267, 23721, 669, 328, "Output",ExpressionUUID->"83f742b4-23aa-4158-8c09-248eaca5c9a9"]
}, Open  ]],
Cell[105325, 2939, 436, 9, 24, "Input",ExpressionUUID->"fb7de7bc-c3be-4604-a0a3-551ff59238cf"],
Cell[105764, 2950, 114, 0, 36, "MathCaption",ExpressionUUID->"85f94f04-231c-4bb0-b2db-890088a93213"],
Cell[CellGroupData[{
Cell[105903, 2954, 228, 5, 25, "Input",ExpressionUUID->"83199aa5-6317-4172-94df-42af888f26c7"],
Cell[106134, 2961, 110, 1, 23, "Output",ExpressionUUID->"26be769d-fc92-43bd-b921-a9a5630dc0b2"]
}, Open  ]],
Cell[106259, 2965, 578, 8, 46, "Text",ExpressionUUID->"e2ec0946-5961-4e18-ba0e-c74fc979da4b"],
Cell[106840, 2975, 111, 0, 36, "MathCaption",ExpressionUUID->"203335c8-6f9b-425c-9ced-6fb60477af82"],
Cell[CellGroupData[{
Cell[106976, 2979, 658, 18, 25, "Input",ExpressionUUID->"1fc34ddc-d2db-4a24-8cd3-9effc3db84d0"],
Cell[107637, 2999, 107, 1, 23, "Output",ExpressionUUID->"0c967b8e-4b45-4ec1-b1bd-a6b1acb508fc"]
}, Open  ]],
Cell[107759, 3003, 162, 2, 36, "MathCaption",ExpressionUUID->"970f3803-b535-4c55-912d-79d8c14513af"],
Cell[CellGroupData[{
Cell[107946, 3009, 418, 10, 25, "Input",ExpressionUUID->"dfa2c95e-3cab-48c1-91be-e0a73c05a389"],
Cell[108367, 3021, 23486, 654, 248, "Output",ExpressionUUID->"af14a6b6-9957-4295-af43-7f639c98a5da"]
}, Open  ]],
Cell[131868, 3678, 369, 8, 24, "Input",ExpressionUUID->"c8b38ebc-1bbd-49ae-a844-4ccf70383254"],
Cell[132240, 3688, 525, 7, 46, "Text",ExpressionUUID->"4ecb443e-3858-4edf-8423-213b40f2c32a"],
Cell[132768, 3697, 156, 2, 36, "MathCaption",ExpressionUUID->"84b8aeb2-469d-4b3c-b54e-cb20c6a23f0b"],
Cell[CellGroupData[{
Cell[132949, 3703, 354, 9, 25, "Input",ExpressionUUID->"0b50bf73-04d8-49d0-9d27-226be8cec1cb"],
Cell[133306, 3714, 108, 1, 23, "Output",ExpressionUUID->"0b04a70e-696d-4f2f-8c50-3dd0a92a095d"]
}, Open  ]],
Cell[133429, 3718, 133, 0, 36, "MathCaption",ExpressionUUID->"20ca14d5-550b-44a9-895d-f57a0db877ee"],
Cell[CellGroupData[{
Cell[133587, 3722, 222, 4, 24, "Input",ExpressionUUID->"e471da5d-fc4d-481a-95d1-b48ffe3d8f5d"],
Cell[133812, 3728, 110, 1, 23, "Output",ExpressionUUID->"c614a761-b06c-48ba-a84a-1bfb81dcd661"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133959, 3734, 210, 4, 24, "Input",ExpressionUUID->"a770b6fa-6113-4fa1-8a15-4682ed813a1c"],
Cell[134172, 3740, 110, 1, 23, "Output",ExpressionUUID->"8ca93177-fb5e-4907-a352-893fbcb171c1"]
}, Open  ]],
Cell[134297, 3744, 181, 3, 36, "MathCaption",ExpressionUUID->"5f230558-7355-44ca-9d3a-fcdc4e65acb2"],
Cell[CellGroupData[{
Cell[134503, 3751, 816, 23, 137, "Input",ExpressionUUID->"5ca7ae62-fc49-4c39-afac-3016b7f48a41"],
Cell[135322, 3776, 110, 1, 23, "Output",ExpressionUUID->"da40d42d-9b4f-4a6c-a701-57e3c4e739b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135469, 3782, 259, 6, 25, "Input",ExpressionUUID->"42cea9a5-1f25-4053-a79e-4a0aab1b4635"],
Cell[135731, 3790, 108, 1, 23, "Output",ExpressionUUID->"dddcddb1-ee10-422d-9e11-03ae49082fff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135876, 3796, 211, 4, 24, "Input",ExpressionUUID->"6eb6f4e1-64a2-4e06-b1e3-de84b92ea5c0"],
Cell[136090, 3802, 110, 1, 23, "Output",ExpressionUUID->"0fda5007-6075-4784-8e32-4fcdd8510b8b"]
}, Open  ]],
Cell[136215, 3806, 125, 0, 36, "MathCaption",ExpressionUUID->"ab119ba6-415f-45e1-9d3a-9bd3cd6e4965"],
Cell[CellGroupData[{
Cell[136365, 3810, 816, 23, 137, "Input",ExpressionUUID->"9349b193-91fc-4e00-bcde-fe87147661f1"],
Cell[137184, 3835, 110, 1, 23, "Output",ExpressionUUID->"d4fd9187-7fb5-493e-8c14-0ad65ddb3301"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137331, 3841, 259, 6, 25, "Input",ExpressionUUID->"03a63364-4616-4c5c-b469-bf6ba33db288"],
Cell[137593, 3849, 108, 1, 23, "Output",ExpressionUUID->"705a70ef-327b-4036-93d8-8478a4b330e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137738, 3855, 211, 4, 24, "Input",ExpressionUUID->"fc622a9d-bf51-41cb-a725-7fbdeb9ff8ea"],
Cell[137952, 3861, 110, 1, 23, "Output",ExpressionUUID->"3131bab1-2349-4fdf-bb13-19c219c65073"]
}, Open  ]],
Cell[138077, 3865, 125, 0, 36, "MathCaption",ExpressionUUID->"66bd5f6b-3000-442a-98ee-94b69a71e36c"],
Cell[CellGroupData[{
Cell[138227, 3869, 1105, 25, 158, "Input",ExpressionUUID->"1c0ceff0-84eb-42c5-b5d0-5ff8a544a7b8"],
Cell[139335, 3896, 110, 1, 23, "Output",ExpressionUUID->"413b9cdc-c145-4daa-8570-4e5c3e3e3938"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139482, 3902, 315, 7, 25, "Input",ExpressionUUID->"ba2fc2c1-4807-412a-b981-ddd2c5b14a51"],
Cell[139800, 3911, 108, 1, 23, "Output",ExpressionUUID->"429c45f8-9fa0-4835-a7d4-8d12a97a6a63"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139945, 3917, 251, 5, 24, "Input",ExpressionUUID->"a713fa48-36dc-4b00-9472-3de144d0ea93"],
Cell[140199, 3924, 110, 1, 23, "Output",ExpressionUUID->"a2c3cb9e-4de5-4d26-b818-12f9df844e11"]
}, Open  ]],
Cell[140324, 3928, 224, 3, 36, "MathCaption",ExpressionUUID->"ed5918b1-dab7-4c2f-b0e5-686cc88cd846"],
Cell[CellGroupData[{
Cell[140573, 3935, 287, 7, 24, "Input",ExpressionUUID->"cef51bf9-297d-4693-9c39-7b3b5306f238"],
Cell[140863, 3944, 110, 1, 23, "Output",ExpressionUUID->"d8075769-1e5d-4dc0-87d5-025795e44b7b"]
}, Open  ]],
Cell[140988, 3948, 86, 0, 36, "MathCaption",ExpressionUUID->"a077ee23-48a1-4936-95b5-7e2beb4e36fa"],
Cell[141077, 3950, 565, 9, 40, "Input",ExpressionUUID->"4fea7567-e903-41ce-a5d5-36aba6a1989f"],
Cell[141645, 3961, 116, 0, 20, "Text",ExpressionUUID->"85cd4332-38e0-4d38-bf5a-7dd46d1022c7"],
Cell[141764, 3963, 402, 7, 66, "DefinitionBox",ExpressionUUID->"05f50b9a-1c72-4b06-9b24-a298b8cff5b7"],
Cell[142169, 3972, 89, 0, 20, "SmallText",ExpressionUUID->"e52d1756-450f-40e1-b1c5-fb37c559eb54"]
}, Closed]]
}, Closed]],
Cell[142285, 3976, 99, 0, 35, "Subsection",ExpressionUUID->"f9c026d3-a11c-409b-968d-399174033848"],
Cell[CellGroupData[{
Cell[142409, 3980, 111, 0, 25, "SubsectionIcon",ExpressionUUID->"5273e9b8-d25a-452b-8e8f-9f1e81d88307"],
Cell[142523, 3982, 309, 4, 33, "Text",ExpressionUUID->"f83bfb93-d604-42e8-9ace-c27f0b0efc72"],
Cell[142835, 3988, 227, 5, 37, "MathCaption",ExpressionUUID->"15fbaa22-ce40-4425-b59c-739beae98231"],
Cell[CellGroupData[{
Cell[143087, 3997, 491, 13, 24, "Input",ExpressionUUID->"e68fc463-c0f5-4262-8e3b-d7acf9e73430"],
Cell[143581, 4012, 162, 3, 23, "Output",ExpressionUUID->"3b8f3692-aae4-40ce-9563-9419b364d474"]
}, Open  ]],
Cell[143758, 4018, 262, 4, 36, "MathCaption",ExpressionUUID->"fdb1a73d-a5ad-485a-bdbf-11c21ee66d5d"],
Cell[CellGroupData[{
Cell[144045, 4026, 459, 12, 24, "Input",ExpressionUUID->"24cffec3-f39a-498e-b352-bc85d57bf03f"],
Cell[144507, 4040, 294, 8, 23, "Output",ExpressionUUID->"04711e63-49a9-4ddb-89fb-64bea7af003a"]
}, Open  ]],
Cell[144816, 4051, 301, 4, 49, "MathCaption",ExpressionUUID->"a0635a20-c06f-45ec-98bc-65d1ae2ecea7"],
Cell[CellGroupData[{
Cell[145142, 4059, 492, 13, 24, "Input",ExpressionUUID->"dfa70c04-38bd-4fba-9410-feae3b12cb95"],
Cell[145637, 4074, 362, 10, 23, "Output",ExpressionUUID->"e8e55f44-6e0f-4740-9ec4-0d4277a53f92"]
}, Open  ]],
Cell[146014, 4087, 273, 5, 52, "DefinitionBox",ExpressionUUID->"fb1284d0-6322-47a9-9ef3-d3674b9c436c"],
Cell[146290, 4094, 130, 0, 20, "Text",ExpressionUUID->"07e983d9-10aa-4e3c-bbfd-efc4fdf6e12f"],
Cell[146423, 4096, 399, 6, 33, "Text",ExpressionUUID->"3c1ddd70-2ca3-41a8-a080-5ca29e09c37f"],
Cell[146825, 4104, 501, 11, 51, "MathCaption",ExpressionUUID->"27e1a785-f433-4a61-a058-7f2f6be39a7f"],
Cell[CellGroupData[{
Cell[147351, 4119, 503, 14, 24, "Input",ExpressionUUID->"241e2636-fd99-4ae0-be33-6bc931c914bb"],
Cell[147857, 4135, 690, 19, 23, "Output",ExpressionUUID->"5646e33e-bd58-4b5a-941d-af830623fb70"]
}, Open  ]],
Cell[148562, 4157, 248, 6, 37, "MathCaption",ExpressionUUID->"596cf15f-519e-4520-9a3b-eadae0728fca"],
Cell[CellGroupData[{
Cell[148835, 4167, 172, 4, 24, "Input",ExpressionUUID->"2c38f8fe-dc21-4729-9a14-8505e49da5b9"],
Cell[149010, 4173, 231, 6, 23, "Output",ExpressionUUID->"1d7c97dd-f03e-42b7-9f77-e944e0f6aadd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149278, 4184, 167, 4, 24, "Input",ExpressionUUID->"20074d6a-8e92-4880-9470-f0f54934785e"],
Cell[149448, 4190, 111, 2, 23, "Output",ExpressionUUID->"cfca804e-a138-4b0d-82fc-279a8b120d90"]
}, Open  ]],
Cell[149574, 4195, 572, 9, 80, "DefinitionBox",ExpressionUUID->"8bd4e20b-5d65-42b1-8fb0-4bc6ed670d62"],
Cell[150149, 4206, 121, 0, 20, "Text",ExpressionUUID->"e7a68b48-544a-416b-a9cd-835f758c787f"]
}, Closed]],
Cell[CellGroupData[{
Cell[150307, 4211, 124, 0, 25, "SubsectionIcon",ExpressionUUID->"8121d062-0033-49df-b56f-43f51e5ea387"],
Cell[150434, 4213, 168, 3, 20, "Text",ExpressionUUID->"a9bbcb65-eaf6-4957-9041-048d729b754e"],
Cell[150605, 4218, 140, 1, 36, "MathCaption",ExpressionUUID->"9b29c318-fd6b-4c80-a70c-5ca83e02f614"],
Cell[CellGroupData[{
Cell[150770, 4223, 317, 9, 25, "Input",ExpressionUUID->"dd326f1b-9991-49ac-bbe5-50c324d0b7f3"],
Cell[151090, 4234, 166, 4, 23, "Output",ExpressionUUID->"38a3953a-7c3c-4d7d-9bbd-93fc4eb43189"]
}, Open  ]],
Cell[151271, 4241, 153, 2, 36, "MathCaption",ExpressionUUID->"368edde2-c9c2-4332-91d3-118ae8051804"],
Cell[CellGroupData[{
Cell[151449, 4247, 318, 9, 25, "Input",ExpressionUUID->"fbfe2b76-5220-461e-b7c1-40fba1c4c125"],
Cell[151770, 4258, 200, 5, 23, "Output",ExpressionUUID->"c9686b34-dda8-4847-8dd3-d36b8d95a767"]
}, Open  ]],
Cell[151985, 4266, 289, 4, 49, "MathCaption",ExpressionUUID->"b0536373-06ff-42b4-bc59-b13a94aff2f7"],
Cell[CellGroupData[{
Cell[152299, 4274, 661, 20, 24, "Input",ExpressionUUID->"bb81d8bb-0822-425b-9cf4-dca67daaa01b"],
Cell[152963, 4296, 256, 7, 23, "Output",ExpressionUUID->"09bf9eeb-ed54-4784-9a29-89f595abf9ed"]
}, Open  ]],
Cell[153234, 4306, 210, 3, 36, "MathCaption",ExpressionUUID->"80fa6b37-1512-40e6-9f93-8db385840f17"],
Cell[CellGroupData[{
Cell[153469, 4313, 664, 20, 24, "Input",ExpressionUUID->"653d3089-82e4-408e-8f02-bed7b2d33061"],
Cell[154136, 4335, 395, 11, 23, "Output",ExpressionUUID->"2fd38a15-7261-417b-a792-462025ffae60"]
}, Open  ]],
Cell[154546, 4349, 2474, 68, 73, "Text",ExpressionUUID->"2eec9b0f-d34c-4e93-bb53-18fa34a990a2"],
Cell[157023, 4419, 154, 2, 36, "MathCaption",ExpressionUUID->"55c09970-acf1-4a01-99bd-d740f66a8e98"],
Cell[CellGroupData[{
Cell[157202, 4425, 725, 20, 25, "Input",ExpressionUUID->"db87f9a7-157a-4307-8afb-8930bdb087f2"],
Cell[157930, 4447, 1674, 51, 56, "Output",ExpressionUUID->"46e449b7-6920-4ad7-a63a-12f74d74da2d"]
}, Open  ]],
Cell[159619, 4501, 219, 3, 36, "MathCaption",ExpressionUUID->"2c1be2f3-8c3c-4bf1-b98a-f7d8b4b7b08d"],
Cell[159841, 4506, 1199, 37, 57, "Input",ExpressionUUID->"7c5ffd82-edad-4bdd-ad38-52ebf440fd49"],
Cell[161043, 4545, 220, 6, 24, "Input",ExpressionUUID->"6904a0c3-289c-46fb-a1a2-97b7fae4d99e"],
Cell[CellGroupData[{
Cell[161288, 4555, 256, 7, 25, "Input",ExpressionUUID->"dc27b723-3347-43a4-ad91-9004895b397a"],
Cell[161547, 4564, 185, 4, 19, "Print",ExpressionUUID->"d5b4427e-d672-4ebc-a951-2a8e981e0b5d"],
Cell[161735, 4570, 2182, 62, 72, "Output",ExpressionUUID->"be9242cb-f6a8-43e1-9939-2b81fc3573e1"]
}, Open  ]],
Cell[163932, 4635, 261, 5, 37, "MathCaption",ExpressionUUID->"78dcf9e9-6ca1-4bec-8292-62f93f16e17d"],
Cell[CellGroupData[{
Cell[164218, 4644, 325, 8, 25, "Input",ExpressionUUID->"dc18f298-0b62-4cc7-bd97-d7b6cfd33a9f"],
Cell[164546, 4654, 185, 4, 19, "Print",ExpressionUUID->"6ca8c903-c39a-41e7-903b-0ad3db377ee4"],
Cell[164734, 4660, 1965, 56, 72, "Output",ExpressionUUID->"8c36b2bb-916b-448a-80b3-e30fe33ac786"]
}, Open  ]],
Cell[166714, 4719, 225, 3, 36, "MathCaption",ExpressionUUID->"db374996-f1f4-4c58-b2c5-d39bc1b75011"],
Cell[CellGroupData[{
Cell[166964, 4726, 222, 6, 25, "Input",ExpressionUUID->"86d069b3-5853-4b33-aa3b-888d044d438b"],
Cell[167189, 4734, 2781, 80, 88, "Output",ExpressionUUID->"c0f185fb-eaeb-461a-bf96-b041f57dded0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170007, 4819, 187, 4, 24, "Input",ExpressionUUID->"daadc813-741b-4d7d-a399-a234b30fb928"],
Cell[170197, 4825, 1941, 56, 56, "Output",ExpressionUUID->"89060fc4-ac98-4688-b0ac-912ecef1eddb"]
}, Open  ]],
Cell[172153, 4884, 154, 2, 36, "MathCaption",ExpressionUUID->"7824ff7b-3832-446f-bc47-548483e9ea78"],
Cell[CellGroupData[{
Cell[172332, 4890, 188, 5, 24, "Input",ExpressionUUID->"b5d7edc5-7423-4d4b-884f-393dfa0eb828"],
Cell[172523, 4897, 9572, 255, 120, "Output",ExpressionUUID->"8ab8744b-7b6c-42f5-9ce9-93f57169134b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182132, 5157, 209, 5, 25, "Input",ExpressionUUID->"fd88547a-d4d3-49dd-8ff0-535a173e4f28"],
Cell[182344, 5164, 178, 4, 23, "Output",ExpressionUUID->"de607489-0645-49e7-b08e-bf8caa06f148"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182559, 5173, 246, 6, 24, "Input",ExpressionUUID->"c6444f88-3b1d-404b-b855-f0a06fd5fc4f"],
Cell[182808, 5181, 114, 2, 23, "Output",ExpressionUUID->"f56721eb-65fc-4f3d-b539-0a72393691d6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182959, 5188, 257, 7, 25, "Input",ExpressionUUID->"1c99ca69-2373-45a7-b049-d4d216d460de"],
Cell[183219, 5197, 115, 2, 23, "Output",ExpressionUUID->"a59bbe49-bb16-4fef-ae87-53925f291ca4"]
}, Open  ]],
Cell[183349, 5202, 180, 3, 36, "MathCaption",ExpressionUUID->"1601cb96-fa04-4631-9d2f-3033a5a9b705"],
Cell[CellGroupData[{
Cell[183554, 5209, 207, 5, 25, "Input",ExpressionUUID->"f49131ca-3979-4a89-91c5-9176c21c8953"],
Cell[183764, 5216, 507, 14, 24, "Output",ExpressionUUID->"c7009601-7b24-43a0-8ff7-a49538361af9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184308, 5235, 172, 4, 25, "Input",ExpressionUUID->"2bd04581-dde7-44ec-993f-539428cc2ef0"],
Cell[184483, 5241, 1177, 34, 40, "Output",ExpressionUUID->"815e1278-f158-481a-9832-fecaebc667aa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[185697, 5280, 171, 4, 25, "Input",ExpressionUUID->"9a834438-792b-474c-b110-7d9e8082545d"],
Cell[185871, 5286, 114, 2, 23, "Output",ExpressionUUID->"3e4f3907-d3aa-415f-a457-2e99adb534ef"]
}, Open  ]],
Cell[186000, 5291, 113, 0, 36, "MathCaption",ExpressionUUID->"c67bdb0a-de40-46cd-a178-fec0d62f7410"],
Cell[CellGroupData[{
Cell[186138, 5295, 226, 6, 25, "Input",ExpressionUUID->"84962411-3de1-482f-aaa6-487e296faf24"],
Cell[186367, 5303, 202, 5, 23, "Output",ExpressionUUID->"44ad4f1c-6ee9-4acb-96cf-9b7376986f4d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186606, 5313, 203, 5, 25, "Input",ExpressionUUID->"0506549a-fae7-4d5b-9087-48483092d3d5"],
Cell[186812, 5320, 114, 2, 23, "Output",ExpressionUUID->"7eae9006-0939-419f-b528-13b9dd5b335e"]
}, Open  ]],
Cell[186941, 5325, 125, 0, 36, "MathCaption",ExpressionUUID->"66a97a06-d6bc-416b-ad37-166029852331"],
Cell[CellGroupData[{
Cell[187091, 5329, 298, 8, 25, "Input",ExpressionUUID->"1af9885d-effd-4d9d-8812-bd56979935fd"],
Cell[187392, 5339, 322, 8, 22, "Message",ExpressionUUID->"a871a941-f863-4af0-baf6-57ea162605da"]
}, Open  ]],
Cell[187729, 5350, 185, 3, 36, "MathCaption",ExpressionUUID->"86cce9a7-7b4f-4fc8-890a-31df10af2555"],
Cell[CellGroupData[{
Cell[187939, 5357, 811, 25, 25, "Input",ExpressionUUID->"887b1172-0c1d-4687-8fb7-edb212bb39b2"],
Cell[188753, 5384, 2557, 83, 136, "Output",ExpressionUUID->"76b6e823-d08e-477d-8203-a0773be4fd31"]
}, Open  ]],
Cell[191325, 5470, 2499, 59, 234, "DefinitionBox",ExpressionUUID->"c29ee663-7f80-4b62-8e6d-1c4a1cc2b1b3"],
Cell[193827, 5531, 99, 0, 20, "SmallText",ExpressionUUID->"7b84964c-bca6-4892-ab88-6245a29c2e85"],
Cell[193929, 5533, 621, 8, 59, "Text",ExpressionUUID->"ced172a7-5716-47aa-bdc9-46961e79f551"],
Cell[194553, 5543, 233, 5, 37, "MathCaption",ExpressionUUID->"7bf829fc-00b3-4b18-b702-ea1dba327cff"],
Cell[CellGroupData[{
Cell[194811, 5552, 132, 3, 24, "Input",ExpressionUUID->"ac3d5c01-ebae-4d7d-8f39-1dbe4e98918a"],
Cell[194946, 5557, 568, 9, 77, "Print",ExpressionUUID->"e663917b-b9c4-4351-a8f1-c51f8abf05a3",
 CellTags->"Info3568058560-2493619"]
}, Open  ]],
Cell[195529, 5569, 283, 7, 36, "MathCaption",ExpressionUUID->"c26bab11-05ff-4d88-905f-540dffab4baf"],
Cell[195815, 5578, 754, 23, 25, "Input",ExpressionUUID->"f1420991-8c54-4d78-9351-4ff7326d024d"],
Cell[196572, 5603, 306, 9, 37, "MathCaption",ExpressionUUID->"d06b4bc8-3df6-4e73-9a08-e6835363efd6"],
Cell[196881, 5614, 315, 10, 25, "Input",ExpressionUUID->"34823c75-9631-42c9-af84-4ccb1d4a7860"],
Cell[197199, 5626, 254, 8, 37, "MathCaption",ExpressionUUID->"756209b8-f663-4217-bea9-849bedf52896"],
Cell[197456, 5636, 363, 10, 25, "Input",ExpressionUUID->"ffc5a695-3726-40fd-a28d-66f4aeba47ad"],
Cell[CellGroupData[{
Cell[197844, 5650, 296, 9, 25, "Input",ExpressionUUID->"419a95c3-3700-465a-8ede-2e3534a708c4"],
Cell[198143, 5661, 114, 2, 23, "Output",ExpressionUUID->"c434ba0a-af7c-41bd-ab75-62c297233e79"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198294, 5668, 219, 6, 25, "Input",ExpressionUUID->"e5daf9a3-fe1c-45aa-9204-9e39fe9738d3"],
Cell[198516, 5676, 115, 2, 23, "Output",ExpressionUUID->"d7febfbb-2ed7-4073-9057-9e0c1cf34097"]
}, Open  ]],
Cell[198646, 5681, 335, 9, 37, "MathCaption",ExpressionUUID->"fa7249cf-1383-4a17-81bb-25389686564b"],
Cell[CellGroupData[{
Cell[199006, 5694, 358, 9, 25, "Input",ExpressionUUID->"dde78319-7d80-4898-a24b-e6693fa3ea07"],
Cell[199367, 5705, 340, 9, 20, "Print",ExpressionUUID->"a5974a61-7815-4ecd-8c1b-c3f8d820deab"],
Cell[199710, 5716, 659, 15, 20, "Print",ExpressionUUID->"39e9b21f-35ea-46db-92af-d8cb2a379144"],
Cell[200372, 5733, 755, 18, 20, "Print",ExpressionUUID->"6922e8e3-503b-4675-af5d-1fa720a577de"],
Cell[201130, 5753, 353, 9, 20, "Print",ExpressionUUID->"64546e21-c2d4-49e5-aaf8-853b2faa750c"],
Cell[201486, 5764, 342, 9, 20, "Print",ExpressionUUID->"cceab7c1-44a6-4200-96c0-e9f550cbe638"],
Cell[201831, 5775, 755, 18, 20, "Print",ExpressionUUID->"74bd60fc-68d9-4b1e-b6ab-4d4aa1986c19"],
Cell[202589, 5795, 768, 18, 20, "Print",ExpressionUUID->"e3ca30b1-3b21-4842-b61b-9ae0ea73062f"],
Cell[203360, 5815, 342, 9, 20, "Print",ExpressionUUID->"b335344d-a839-4014-962b-8c0ebc305973"],
Cell[203705, 5826, 768, 18, 20, "Print",ExpressionUUID->"bcd8f9dc-43fb-4ff9-a8ec-3eebd34bf22d"],
Cell[204476, 5846, 755, 18, 20, "Print",ExpressionUUID->"3e1fd313-5695-4860-a329-ffc283d55972"],
Cell[205234, 5866, 395, 11, 20, "Print",ExpressionUUID->"82058e1a-d2ce-4fd6-920f-86898b87a5e7"],
Cell[205632, 5879, 366, 9, 20, "Print",ExpressionUUID->"19aadb57-08f5-4653-a69d-575140294476"],
Cell[206001, 5890, 355, 9, 20, "Print",ExpressionUUID->"f64c8b5d-fe0e-45ae-a9e9-d812cdaa77fa"],
Cell[206359, 5901, 342, 9, 20, "Print",ExpressionUUID->"f1fbee1a-1774-4fa8-b0b1-fd3bab435a03"],
Cell[206704, 5912, 755, 18, 20, "Print",ExpressionUUID->"c77ee091-a4a5-41c8-9874-61c0966718bf"],
Cell[207462, 5932, 843, 21, 20, "Print",ExpressionUUID->"381f89fe-31cb-4a89-85a0-9addade735bc"],
Cell[208308, 5955, 483, 14, 20, "Print",ExpressionUUID->"f731ea13-4091-4fa7-994b-40621d87c3ab"],
Cell[208794, 5971, 558, 17, 24, "Output",ExpressionUUID->"70372eb9-25cf-4449-8516-faa09c81e406"]
}, Open  ]],
Cell[209367, 5991, 229, 3, 36, "MathCaption",ExpressionUUID->"e8be86bc-f2ad-4b61-b7e5-4b48b87e6528"],
Cell[CellGroupData[{
Cell[209621, 5998, 148, 3, 25, "Input",ExpressionUUID->"80cc5235-9bbc-4300-9099-8ff775a0184b"],
Cell[209772, 6003, 111, 2, 23, "Output",ExpressionUUID->"312c1ede-8d58-4bcf-8ee6-dc6d5a819c67"]
}, Open  ]],
Cell[209898, 6008, 87, 0, 36, "MathCaption",ExpressionUUID->"2ef41235-99b2-4e7f-a8c6-e2eb5e2ead08"],
Cell[209988, 6010, 209, 5, 24, "Input",ExpressionUUID->"38ba9e70-8482-4043-a1c3-d9c54e7df5eb"],
Cell[210200, 6017, 217, 4, 38, "DefinitionBox",ExpressionUUID->"da2b2665-4df2-40a8-a7ec-fda6228f899c"],
Cell[210420, 6023, 93, 0, 20, "SmallText",ExpressionUUID->"fae043d0-7892-4c92-8158-091c18afbcf2"]
}, Closed]],
Cell[CellGroupData[{
Cell[210550, 6028, 117, 0, 25, "SubsectionIcon",ExpressionUUID->"1def0d81-1477-4803-bb48-81f6316ed6a3"],
Cell[210670, 6030, 347, 9, 21, "Text",ExpressionUUID->"c98840ae-7141-441d-99fa-b110610d42d2"],
Cell[211020, 6041, 170, 3, 36, "MathCaption",ExpressionUUID->"49ef2fb2-e0fa-4d30-9a33-0611f8bf1603"],
Cell[CellGroupData[{
Cell[211215, 6048, 238, 7, 25, "Input",ExpressionUUID->"6c48c0e1-dd88-48bf-a06c-35ac19570af0"],
Cell[211456, 6057, 479, 14, 24, "Output",ExpressionUUID->"8a164af8-c539-48d0-b67d-086dc68b6150"]
}, Open  ]],
Cell[CellGroupData[{
Cell[211972, 6076, 253, 7, 25, "Input",ExpressionUUID->"1ed84713-a6be-49db-8e54-3a697cc64f92"],
Cell[212228, 6085, 667, 21, 24, "Output",ExpressionUUID->"464f997f-0f3d-4a78-85da-00b360f6f5b5"]
}, Open  ]],
Cell[212910, 6109, 206, 3, 36, "MathCaption",ExpressionUUID->"95f58489-b731-4b76-8a19-293b983c232c"],
Cell[CellGroupData[{
Cell[213141, 6116, 219, 5, 25, "Input",ExpressionUUID->"9b47f5b2-324d-474f-aec5-55ffe9e844ad"],
Cell[213363, 6123, 717, 22, 24, "Output",ExpressionUUID->"1f798d97-fa0e-4e81-ac49-8902f7909126"]
}, Open  ]],
Cell[214095, 6148, 303, 6, 50, "MathCaption",ExpressionUUID->"5e2f12bd-c5b2-497f-b221-2b37f0c02c0b"],
Cell[CellGroupData[{
Cell[214423, 6158, 482, 15, 25, "Input",ExpressionUUID->"152cc1ba-3f7d-450b-86aa-4f3a3436e32e"],
Cell[214908, 6175, 1009, 31, 40, "Output",ExpressionUUID->"2735946a-0bec-46ee-a041-385e1b13e8ed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[215954, 6211, 466, 15, 25, "Input",ExpressionUUID->"f75a3a9c-c98c-4705-a8a9-eac8642675bf"],
Cell[216423, 6228, 735, 22, 24, "Output",ExpressionUUID->"5579a48f-9029-44cd-a7b0-2ef2c7c29e1a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217195, 6255, 482, 15, 25, "Input",ExpressionUUID->"7095e420-f7ca-4c94-ba5f-c36fd06caae1"],
Cell[217680, 6272, 1410, 42, 40, "Output",ExpressionUUID->"cfd81f5a-032e-4dd7-976e-998e972708bb"]
}, Open  ]],
Cell[219105, 6317, 246, 6, 37, "MathCaption",ExpressionUUID->"67be236f-858e-4f0a-9e05-5dd9acf2e848"],
Cell[CellGroupData[{
Cell[219376, 6327, 356, 11, 25, "Input",ExpressionUUID->"2c96f3f9-9b7b-44ee-ad1e-256f67ed50db"],
Cell[219735, 6340, 717, 22, 24, "Output",ExpressionUUID->"43a26463-550e-4985-a736-8fae89c2854e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[220489, 6367, 219, 5, 25, "Input",ExpressionUUID->"7c73dc24-f185-4b2e-9809-35c23af56dfc"],
Cell[220711, 6374, 717, 22, 24, "Output",ExpressionUUID->"4ff0bc26-191e-470d-b555-0e1545cd1bd8"]
}, Open  ]],
Cell[221443, 6399, 625, 13, 80, "DefinitionBox",ExpressionUUID->"d94ec330-134a-4b26-a49d-8790fe529b57"],
Cell[222071, 6414, 96, 0, 20, "SmallText",ExpressionUUID->"2d19ffe0-ff67-4afa-b35f-6f4321e14e98"]
}, Closed]],
Cell[CellGroupData[{
Cell[222204, 6419, 119, 0, 25, "SubsectionIcon",ExpressionUUID->"bcb35650-2846-49e8-a9ca-3b2b49114ae6"],
Cell[222326, 6421, 283, 4, 33, "Text",ExpressionUUID->"746d6343-1185-4833-8deb-607ee162db35"],
Cell[222612, 6427, 237, 6, 36, "MathCaption",ExpressionUUID->"4673e4fc-6482-4fac-9b7f-77300920ff06"],
Cell[222852, 6435, 396, 11, 41, "Input",ExpressionUUID->"889ae6d3-35d8-4f47-93c6-6372a931163d"],
Cell[223251, 6448, 282, 5, 38, "DefinitionBox",ExpressionUUID->"966b1d70-9189-4ec4-a09e-bc6c9b605632"],
Cell[223536, 6455, 96, 0, 20, "SmallText",ExpressionUUID->"fa14ff3b-a488-49fb-997d-1ad110333936"],
Cell[CellGroupData[{
Cell[223657, 6459, 101, 0, 21, "SubsubsectionIcon",ExpressionUUID->"3a96018f-3e2c-416a-afeb-e95ab25670c9"],
Cell[223761, 6461, 248, 4, 20, "Text",ExpressionUUID->"b091f804-71ab-4dfe-bc5c-6df269503a4a"],
Cell[224012, 6467, 37644, 1721, 308, 34211, 1663, "GraphicsData", "PostScript", "Graphics",ExpressionUUID->"c7c4bafc-7eb0-44a4-87a5-b5c90a5d42ba"],
Cell[261659, 8190, 168, 3, 36, "MathCaption",ExpressionUUID->"a18964f8-f71c-4937-ac6b-ec51b304add8"],
Cell[261830, 8195, 3550, 98, 121, "Input",ExpressionUUID->"15261f1f-656c-4576-a3bf-0fada7bbcaf3"],
Cell[265383, 8295, 219, 3, 36, "MathCaption",ExpressionUUID->"967ce616-e3dc-4a97-ade1-7579a19f6c4a"],
Cell[265605, 8300, 1845, 43, 121, "Input",ExpressionUUID->"37374ad2-d711-42f4-b67e-6a8ebe7336c2"],
Cell[267453, 8345, 713, 14, 40, "Input",ExpressionUUID->"7bbc541c-ba3d-4888-96d7-8032cb9e374b"],
Cell[268169, 8361, 168, 3, 36, "MathCaption",ExpressionUUID->"c539992c-7804-4b8e-86cd-04a08e8aeee2"],
Cell[CellGroupData[{
Cell[268362, 8368, 302, 9, 25, "Input",ExpressionUUID->"e8823e88-f6af-4255-9759-d7a73ec8bc0c"],
Cell[268667, 8379, 185, 4, 19, "Print",ExpressionUUID->"9ccca9ce-0e6e-4760-a879-a7d2c7f63608"]
}, Open  ]],
Cell[268867, 8386, 301, 6, 37, "MathCaption",ExpressionUUID->"7e2e4dcf-cb71-4238-a1fe-a09c126fb699"],
Cell[269171, 8394, 235, 6, 25, "Input",ExpressionUUID->"14d6f30e-1316-4cc7-8b06-cccf6f0556a8"],
Cell[CellGroupData[{
Cell[269431, 8404, 145, 3, 25, "Input",ExpressionUUID->"ae6cddfa-25b0-42de-a763-995ab0a4d8bf"],
Cell[269579, 8409, 174, 4, 24, "Output",ExpressionUUID->"9f7ee4f5-c3d3-44d8-8723-3ae8f122208e"]
}, Open  ]],
Cell[269768, 8416, 171, 3, 36, "MathCaption",ExpressionUUID->"835499ef-6344-4a34-83b5-38d38029648a"],
Cell[269942, 8421, 7209, 191, 344, "Input",ExpressionUUID->"ec2f9534-9334-4601-9d1c-a82ac998b840"],
Cell[277154, 8614, 129, 0, 36, "MathCaption",ExpressionUUID->"068aa033-b6bd-4067-9956-d9e20282ffc7"],
Cell[CellGroupData[{
Cell[277308, 8618, 291, 8, 25, "Input",ExpressionUUID->"2803a144-36f1-4c9e-843b-0dbe96509018"],
Cell[277602, 8628, 186, 4, 19, "Print",ExpressionUUID->"b888c10a-8b47-4290-ba31-18255f25c125"]
}, Open  ]],
Cell[277803, 8635, 237, 6, 25, "Input",ExpressionUUID->"7487f24e-0f55-4880-b9fe-067fb82ab1cc"],
Cell[CellGroupData[{
Cell[278065, 8645, 146, 3, 25, "Input",ExpressionUUID->"4da2402d-5a38-46e1-925b-46deabf64ede"],
Cell[278214, 8650, 174, 4, 24, "Output",ExpressionUUID->"cf851973-3e78-47fd-8d42-6245b85ba854"]
}, Open  ]],
Cell[278403, 8657, 109, 0, 36, "MathCaption",ExpressionUUID->"908d3761-9a8c-49b0-afa4-f1924ff85219"],
Cell[CellGroupData[{
Cell[278537, 8661, 183, 4, 25, "Input",ExpressionUUID->"b6f76842-e112-41df-8dec-4537165fa0f7"],
Cell[278723, 8667, 130, 2, 23, "Output",ExpressionUUID->"908267ef-83da-4efd-ae15-8152333a7602"]
}, Open  ]],
Cell[CellGroupData[{
Cell[278890, 8674, 153, 3, 25, "Input",ExpressionUUID->"ff2c792e-16b9-4047-9d9f-c1caf41204e8"],
Cell[279046, 8679, 434, 14, 23, "Output",ExpressionUUID->"4a0d789d-f1bf-448a-bc65-31d57022f54e"]
}, Open  ]],
Cell[279495, 8696, 113, 0, 36, "MathCaption",ExpressionUUID->"4e6804a2-7553-4040-8e18-14b5e44b4e73"],
Cell[279611, 8698, 214, 5, 24, "Input",ExpressionUUID->"fbf6416c-f49e-4082-bf6f-8f7d701d905b"],
Cell[CellGroupData[{
Cell[279850, 8707, 157, 3, 25, "Input",ExpressionUUID->"68d0da33-4839-401c-b14f-0325a1884f7c"],
Cell[280010, 8712, 507, 10, 54, "Output",ExpressionUUID->"269e666f-2b21-44e5-bcc1-8855ea892e79"]
}, Open  ]],
Cell[CellGroupData[{
Cell[280554, 8727, 283, 8, 25, "Input",ExpressionUUID->"334d1b3b-64c1-48f5-8997-27d21e7bdc1e"],
Cell[280840, 8737, 340, 7, 23, "Output",ExpressionUUID->"eece891a-35d0-4720-9458-b3ee0fa73629"]
}, Open  ]],
Cell[281195, 8747, 113, 0, 20, "Text",ExpressionUUID->"98d93f9b-ae0d-4539-a07b-8c3700654884"],
Cell[281311, 8749, 174, 3, 36, "MathCaption",ExpressionUUID->"34ef6cce-946c-408a-897f-9a67daff4a86"],
Cell[CellGroupData[{
Cell[281510, 8756, 277, 8, 25, "Input",ExpressionUUID->"f066e5c1-b4d4-4eb8-8f50-6883f7d7f42e"],
Cell[281790, 8766, 115, 2, 23, "Output",ExpressionUUID->"c430de6f-4b0d-4a99-b7d3-c383d52ffeda"]
}, Open  ]],
Cell[CellGroupData[{
Cell[281942, 8773, 266, 8, 25, "Input",ExpressionUUID->"70cc7689-8fdb-4c81-8534-cbf89050076a"],
Cell[282211, 8783, 115, 2, 23, "Output",ExpressionUUID->"fddb53bd-e57d-450c-8e5a-08ce8f7c3244"]
}, Open  ]],
Cell[282341, 8788, 132, 0, 36, "MathCaption",ExpressionUUID->"9b036c4b-7977-4601-91c2-bf69abffbe74"],
Cell[CellGroupData[{
Cell[282498, 8792, 347, 11, 25, "Input",ExpressionUUID->"66bc3e89-2338-47fb-8a48-69ee275a4bb5"],
Cell[282848, 8805, 114, 2, 23, "Output",ExpressionUUID->"9b1f9d73-1a64-450a-ae3f-2627081a3211"]
}, Open  ]],
Cell[CellGroupData[{
Cell[282999, 8812, 370, 11, 25, "Input",ExpressionUUID->"b1e3a0a4-b565-4405-8ab5-898899e51b4e"],
Cell[283372, 8825, 114, 2, 23, "Output",ExpressionUUID->"245283e8-75f7-48c5-95bf-ec51a77a5bbb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[283523, 8832, 370, 11, 25, "Input",ExpressionUUID->"32043480-8c13-4d6a-9e7a-dba6891b55be"],
Cell[283896, 8845, 115, 2, 23, "Output",ExpressionUUID->"66021e52-8b96-47b8-afa5-648131ef57e6"]
}, Open  ]],
Cell[284026, 8850, 114, 0, 36, "MathCaption",ExpressionUUID->"b3d5060f-267c-42c6-8bfe-1190113715e6"],
Cell[CellGroupData[{
Cell[284165, 8854, 358, 11, 25, "Input",ExpressionUUID->"21be3a81-715b-43c6-a88f-4bf26beb5c6f"],
Cell[284526, 8867, 115, 2, 23, "Output",ExpressionUUID->"30e616dd-e86d-4bb1-ad2c-44fdcd7d5621"]
}, Open  ]],
Cell[284656, 8872, 602, 8, 46, "Text",ExpressionUUID->"537bc1ab-9c54-4e7d-8bb1-8f20cab147d2"],
Cell[285261, 8882, 157, 2, 36, "MathCaption",ExpressionUUID->"a45b2f9a-e3d7-4f03-bbd9-9284cefcef95"],
Cell[CellGroupData[{
Cell[285443, 8888, 185, 5, 24, "Input",ExpressionUUID->"f91ff741-8bdd-470f-bf7d-48c930bb58f7"],
Cell[285631, 8895, 129, 2, 23, "Output",ExpressionUUID->"0986f33f-76ea-41bf-acb2-de3eb6088c9f"]
}, Open  ]],
Cell[285775, 8900, 137, 1, 36, "MathCaption",ExpressionUUID->"eeafce63-8500-45ca-86ba-bacde2ab904f"],
Cell[285915, 8903, 973, 30, 41, "Input",ExpressionUUID->"de9c4b9f-ea48-4474-b4e4-676d0202425f"],
Cell[CellGroupData[{
Cell[286913, 8937, 186, 4, 25, "Input",ExpressionUUID->"ab8dd423-b146-4822-a1f4-5794f8ea0291"],
Cell[287102, 8943, 114, 2, 23, "Output",ExpressionUUID->"6c4c313a-a6cd-4993-824b-5061903fe487"]
}, Open  ]],
Cell[287231, 8948, 206, 3, 36, "MathCaption",ExpressionUUID->"17868b2a-9dd7-4ea3-af3c-74880ff0968a"],
Cell[CellGroupData[{
Cell[287462, 8955, 268, 7, 25, "Input",ExpressionUUID->"5a965e29-c56f-4e7e-bdd8-08efa8a1206e"],
Cell[287733, 8964, 114, 2, 23, "Output",ExpressionUUID->"533e989a-d4dc-4c2c-95fc-e0898e37cdcf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[287884, 8971, 268, 7, 25, "Input",ExpressionUUID->"5f0001fe-69b9-43d2-9096-b82be7ce77e0"],
Cell[288155, 8980, 114, 2, 23, "Output",ExpressionUUID->"3ff8f6c3-8a55-47d6-979d-576bb13dd63a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[288306, 8987, 268, 7, 25, "Input",ExpressionUUID->"527a34c5-7e89-4b25-aea3-d7ee8724988a"],
Cell[288577, 8996, 114, 2, 23, "Output",ExpressionUUID->"34b0e4fc-4b92-47dd-b9e4-0b2c4ebbacc5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[288728, 9003, 268, 7, 25, "Input",ExpressionUUID->"eaa67740-dd1a-44c8-9588-9a51265bb506"],
Cell[288999, 9012, 114, 2, 23, "Output",ExpressionUUID->"af7475e8-626c-4b50-9bca-40caed37df02"]
}, Open  ]],
Cell[CellGroupData[{
Cell[289150, 9019, 268, 7, 25, "Input",ExpressionUUID->"a40a993f-5694-4193-99cc-4afcf3dbf5b8"],
Cell[289421, 9028, 114, 2, 23, "Output",ExpressionUUID->"38a0b183-f9cc-4b15-9411-667a79d4d020"]
}, Open  ]],
Cell[CellGroupData[{
Cell[289572, 9035, 268, 7, 25, "Input",ExpressionUUID->"1e574a56-5d79-4a6a-83db-de3d20abadf4"],
Cell[289843, 9044, 114, 2, 23, "Output",ExpressionUUID->"59c8b972-522b-4422-8824-a5e20d463bdf"]
}, Open  ]],
Cell[289972, 9049, 119, 0, 36, "MathCaption",ExpressionUUID->"7deea22c-aa03-4cfd-8258-d8a1a92243e6"],
Cell[290094, 9051, 564, 8, 46, "Text",ExpressionUUID->"d0764290-11b0-4100-a434-2b9deffe56e8"],
Cell[290661, 9061, 134, 0, 36, "MathCaption",ExpressionUUID->"4ca0684c-f974-45b1-af0f-b1ba5789c15b"],
Cell[CellGroupData[{
Cell[290820, 9065, 171, 4, 24, "Input",ExpressionUUID->"2acd102e-777d-44dd-a6a0-c1d6110ab159"],
Cell[290994, 9071, 113, 2, 23, "Output",ExpressionUUID->"c4ad8da1-962e-423d-95d1-079441eb7b2d"]
}, Open  ]],
Cell[291122, 9076, 125, 0, 36, "MathCaption",ExpressionUUID->"2cd63d81-5cc4-4687-97c7-72f9608b9557"],
Cell[291250, 9078, 1635, 48, 119, "Input",ExpressionUUID->"68a37083-607c-4b6d-97c2-7c3961acf76a"],
Cell[292888, 9128, 312, 4, 49, "MathCaption",ExpressionUUID->"d99c0748-3596-40a7-a8fc-1e2542144de7"],
Cell[293203, 9134, 3855, 103, 117, "Input",ExpressionUUID->"512dacc8-5f2a-4bf8-a575-5c8aadaca696"],
Cell[297061, 9239, 90, 0, 36, "MathCaption",ExpressionUUID->"be36fd18-4b4f-48e8-ae57-51157474d853"],
Cell[CellGroupData[{
Cell[297176, 9243, 314, 8, 25, "Input",ExpressionUUID->"ab4a5ce5-247f-4311-8b0c-b048c460c46f"],
Cell[297493, 9253, 166, 3, 23, "Output",ExpressionUUID->"5be8592e-d90f-41e2-9b84-da631b344ab5"]
}, Open  ]],
Cell[297674, 9259, 180, 3, 36, "MathCaption",ExpressionUUID->"32da9bf1-7451-4869-b788-a01201f94254"],
Cell[CellGroupData[{
Cell[297879, 9266, 252, 7, 24, "Input",ExpressionUUID->"4f042705-c403-47eb-9a8b-c45ca71bc573"],
Cell[298134, 9275, 4192, 121, 101, "Output",ExpressionUUID->"66231311-e3b3-4321-8291-ff7d87865be6"]
}, Open  ]],
Cell[302341, 9399, 115, 0, 36, "MathCaption",ExpressionUUID->"639c2da5-f19a-4862-b684-2f4c32aaafcd"],
Cell[CellGroupData[{
Cell[302481, 9403, 356, 9, 25, "Input",ExpressionUUID->"1210471e-52b2-4dee-8be9-b94e4a3169c8"],
Cell[302840, 9414, 114, 2, 23, "Output",ExpressionUUID->"861b6623-85e3-4c6f-83a8-ee6fef0a7356"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[303003, 9422, 107, 0, 17, "SubsubsectionIcon",ExpressionUUID->"fe1fa1a5-d94e-49d9-bf99-7fe8e6bc0004"],
Cell[303113, 9424, 193, 3, 20, "Text",ExpressionUUID->"8f4c9552-43f4-4753-a5ce-090322aa4f5b"],
Cell[303309, 9429, 418, 12, 25, "Input",ExpressionUUID->"e2207b85-f03d-4296-a423-7b2ecff66dbf"],
Cell[303730, 9443, 159, 2, 36, "MathCaption",ExpressionUUID->"de1cc188-3c85-48a0-824c-4e4b83692864"],
Cell[CellGroupData[{
Cell[303914, 9449, 331, 10, 25, "Input",ExpressionUUID->"b484aff8-21b7-4294-b149-6bde464bd46d"],
Cell[304248, 9461, 185, 4, 19, "Print",ExpressionUUID->"922929de-e827-4706-8de5-72109448fbcb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[304470, 9470, 143, 3, 25, "Input",ExpressionUUID->"2b29e6f6-d61a-43e0-9339-2c585f46f85a"],
Cell[304616, 9475, 174, 4, 24, "Output",ExpressionUUID->"0065bbec-c3bc-4fbd-b90d-773255e14caa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[304827, 9484, 153, 3, 25, "Input",ExpressionUUID->"c2641da1-06c8-4585-8a93-46c725ec13ba"],
Cell[304983, 9489, 121, 2, 23, "Output",ExpressionUUID->"8f7ab3d0-50ad-48b5-b8ad-82d71fd809a4"]
}, Open  ]],
Cell[305119, 9494, 211, 5, 37, "MathCaption",ExpressionUUID->"6884c724-1ea5-4b33-9e8f-01a9aa383b55"],
Cell[CellGroupData[{
Cell[305355, 9503, 331, 10, 25, "Input",ExpressionUUID->"6e7fde8f-6422-4559-848b-440b28afe60d"],
Cell[305689, 9515, 185, 4, 19, "Print",ExpressionUUID->"061aeed8-1201-41dd-8426-b2c6c54a8188"]
}, Open  ]],
Cell[CellGroupData[{
Cell[305911, 9524, 143, 3, 25, "Input",ExpressionUUID->"4a171603-d5df-4600-b092-b6a9a4041361"],
Cell[306057, 9529, 174, 4, 24, "Output",ExpressionUUID->"2392e6ac-38ad-4f77-a0da-a02c0b3f8736"]
}, Open  ]],
Cell[CellGroupData[{
Cell[306268, 9538, 153, 3, 25, "Input",ExpressionUUID->"141d01e4-36b8-4113-90ba-eef75c7ca06c"],
Cell[306424, 9543, 143, 2, 23, "Output",ExpressionUUID->"1690ca9f-07bf-4912-bc2e-6a6ad0031962"]
}, Open  ]],
Cell[306582, 9548, 105, 0, 36, "MathCaption",ExpressionUUID->"86aca13a-2f16-4c8b-9cda-6ff036f92b78"],
Cell[CellGroupData[{
Cell[306712, 9552, 331, 10, 25, "Input",ExpressionUUID->"85e1cb96-1dfc-4cef-b322-898eb7a45b06"],
Cell[307046, 9564, 186, 4, 19, "Print",ExpressionUUID->"feccb648-66e1-4b0f-94d5-88e100a2712a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[307269, 9573, 143, 3, 25, "Input",ExpressionUUID->"8eda8ff5-e1a3-4b31-b2f4-d97e34da77b3"],
Cell[307415, 9578, 174, 4, 24, "Output",ExpressionUUID->"b954e351-b8b3-48fa-9397-37f8aef91b77"]
}, Open  ]],
Cell[CellGroupData[{
Cell[307626, 9587, 153, 3, 25, "Input",ExpressionUUID->"0a210c92-4113-4ef5-bfa6-3de2a63bd698"],
Cell[307782, 9592, 179, 4, 23, "Output",ExpressionUUID->"b2bdc890-4a56-4ab6-a3db-d07b7e5577e5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[307998, 9601, 133, 3, 24, "Input",ExpressionUUID->"328acddc-a1d3-4600-b316-818f8c2482b4"],
Cell[308134, 9606, 133, 2, 25, "Output",ExpressionUUID->"4a1cd7f0-5e8a-442b-8ffa-fa07f16744c7"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[308316, 9614, 126, 0, 17, "SubsubsectionIcon",ExpressionUUID->"d6a0468b-051a-4404-bdd7-6370a51b967c"],
Cell[308445, 9616, 247, 4, 20, "Text",ExpressionUUID->"6a27bf49-ef7d-4121-91da-b4b3ab0bc9a2"],
Cell[308695, 9622, 338, 5, 49, "MathCaption",ExpressionUUID->"b25108ec-833f-434e-9270-358aacaad31b"],
Cell[309036, 9629, 922, 22, 41, "Input",ExpressionUUID->"d8d42f8b-5990-4d32-8630-91296e180e89"],
Cell[CellGroupData[{
Cell[309983, 9655, 188, 5, 25, "Input",ExpressionUUID->"0ff804ca-810a-47ba-8147-39beb108248c"],
Cell[310174, 9662, 158, 4, 23, "Output",ExpressionUUID->"ec51358a-8d0f-4e51-877e-1aa8948cbe3a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[310369, 9671, 367, 11, 25, "Input",ExpressionUUID->"08054c5e-9b8b-4bc9-a638-51b037ea071f"],
Cell[310739, 9684, 185, 4, 19, "Print",ExpressionUUID->"b54ca770-3ff9-4f75-95d1-2107510273ad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[310961, 9693, 149, 3, 25, "Input",ExpressionUUID->"8432be84-264e-460b-9c00-e7dcc8aa7081"],
Cell[311113, 9698, 173, 4, 24, "Output",ExpressionUUID->"62cc17f8-b4d0-45cd-9ae3-4d8a335d5a60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[311323, 9707, 159, 3, 25, "Input",ExpressionUUID->"91286954-7f32-4dbb-bc54-fdf70f222062"],
Cell[311485, 9712, 119, 2, 23, "Output",ExpressionUUID->"071fded8-c4d9-43ef-a939-fd0e0788280d"]
}, Open  ]],
Cell[311619, 9717, 253, 4, 36, "MathCaption",ExpressionUUID->"c3bcd8c0-a6b5-446d-92ca-68b99c0c91bb"],
Cell[311875, 9723, 15527, 441, 403, "Input",ExpressionUUID->"567c199f-ff7d-48e3-889e-f7d46de47823"],
Cell[CellGroupData[{
Cell[327427, 10168, 188, 5, 25, "Input",ExpressionUUID->"ac3305e3-bcd2-4e1f-9ebf-b469f3d40206"],
Cell[327618, 10175, 160, 4, 23, "Output",ExpressionUUID->"4162f6b3-22fa-429a-b04f-7e3f0c2f4ba8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[327815, 10184, 365, 11, 25, "Input",ExpressionUUID->"32feac64-30b3-4a8c-b645-59125f044c28"],
Cell[328183, 10197, 185, 4, 19, "Print",ExpressionUUID->"b3dda9b7-932d-4c7e-a737-e8fe3f6a7646"]
}, Open  ]],
Cell[CellGroupData[{
Cell[328405, 10206, 146, 3, 25, "Input",ExpressionUUID->"663bd295-e425-4c52-88d8-92cee075bca1"],
Cell[328554, 10211, 172, 4, 24, "Output",ExpressionUUID->"882ccd7a-0b05-4db5-b222-42eb7ce9aadb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[328763, 10220, 156, 3, 25, "Input",ExpressionUUID->"45b91b24-b5aa-4ade-a316-2a66099dcd3a"],
Cell[328922, 10225, 116, 2, 23, "Output",ExpressionUUID->"6d2303b7-8946-4dd0-bce1-c6eba9037491"]
}, Open  ]],
Cell[329053, 10230, 173, 3, 36, "MathCaption",ExpressionUUID->"84b22a90-8829-49e2-a674-18f620358b68"],
Cell[329229, 10235, 5953, 175, 148, "Input",ExpressionUUID->"37a479bc-b8cf-413c-91ce-175b8df6c429"],
Cell[CellGroupData[{
Cell[335207, 10414, 188, 5, 25, "Input",ExpressionUUID->"4d22824e-2d5a-4a14-9451-9d301ca3df43"],
Cell[335398, 10421, 160, 4, 23, "Output",ExpressionUUID->"17067c77-0ee5-4fe2-89be-530a93d7be03"]
}, Open  ]],
Cell[CellGroupData[{
Cell[335595, 10430, 365, 11, 25, "Input",ExpressionUUID->"d311cdf5-4748-4cb2-b5ed-b67bdc2057cf"],
Cell[335963, 10443, 185, 4, 19, "Print",ExpressionUUID->"60ff3032-4d7a-4c35-9e56-5519acf2f067"]
}, Open  ]],
Cell[CellGroupData[{
Cell[336185, 10452, 146, 3, 25, "Input",ExpressionUUID->"3e8da662-5a77-4ec4-8877-670b31100a4d"],
Cell[336334, 10457, 172, 4, 24, "Output",ExpressionUUID->"20286807-278e-4b19-a1ad-c79176f51765"]
}, Open  ]],
Cell[CellGroupData[{
Cell[336543, 10466, 156, 3, 25, "Input",ExpressionUUID->"bad8bde1-bfa9-4832-98dd-936352b3ec93"],
Cell[336702, 10471, 116, 2, 23, "Output",ExpressionUUID->"8b9f82fd-c1d6-401f-8c9b-b569c678920d"]
}, Open  ]],
Cell[336833, 10476, 201, 3, 36, "MathCaption",ExpressionUUID->"c2732ed5-0e3b-4c50-ab80-02a63c6194fa"],
Cell[337037, 10481, 7413, 106, 374, "Input",ExpressionUUID->"43372d98-c1a3-438c-b19a-137b8cc496fa"],
Cell[CellGroupData[{
Cell[344475, 10591, 188, 5, 25, "Input",ExpressionUUID->"9056373a-181a-41af-ba62-9d0f803289ec"],
Cell[344666, 10598, 160, 4, 23, "Output",ExpressionUUID->"8a864e1c-16f2-4131-943a-d7804b8a7b0e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[344863, 10607, 366, 11, 25, "Input",ExpressionUUID->"025a2238-dda5-4e4f-8f09-335226a92152"],
Cell[345232, 10620, 185, 4, 19, "Print",ExpressionUUID->"b003fa74-47c3-4dce-926e-0bcc0be5aac4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[345454, 10629, 147, 3, 25, "Input",ExpressionUUID->"7535d7d2-61b3-4eea-936b-2c8952cd9edc"],
Cell[345604, 10634, 173, 4, 24, "Output",ExpressionUUID->"0d83dadd-ddfe-4cf2-9241-e20713a59cfd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[345814, 10643, 157, 3, 25, "Input",ExpressionUUID->"34f09f1d-a594-463c-9b60-ab886ff44c1b"],
Cell[345974, 10648, 122, 2, 23, "Output",ExpressionUUID->"9f1afbab-1ecd-4bb5-9961-dbfcf484f230"]
}, Open  ]],
Cell[346111, 10653, 214, 5, 21, "Text",ExpressionUUID->"547e2f93-f281-4d99-a67a-e7ca671e0429"],
Cell[346328, 10660, 353, 5, 49, "MathCaption",ExpressionUUID->"d0b40a4c-4e8f-47cc-b388-6b24fad3c7a9"],
Cell[346684, 10667, 379, 11, 41, "Input",ExpressionUUID->"b996f061-b16b-469e-9d2f-ac5fcf118433"],
Cell[CellGroupData[{
Cell[347088, 10682, 188, 5, 25, "Input",ExpressionUUID->"f883dff4-3045-48d2-9975-5c00b742216f"],
Cell[347279, 10689, 162, 4, 23, "Output",ExpressionUUID->"d88f4600-79f9-475d-be20-ca11ef2b7025"]
}, Open  ]],
Cell[CellGroupData[{
Cell[347478, 10698, 369, 11, 25, "Input",ExpressionUUID->"81abbbbe-131e-4af7-a6e4-7d4661592a1f"],
Cell[347850, 10711, 188, 4, 19, "Print",ExpressionUUID->"e0d1f33c-09fe-4317-9184-07613472f17a"]
}, Open  ]],
Cell[348053, 10718, 501, 15, 56, "Input",ExpressionUUID->"09b9601d-2384-405a-a2ec-900abccf98f1"],
Cell[CellGroupData[{
Cell[348579, 10737, 149, 3, 25, "Input",ExpressionUUID->"5d139d05-f6df-410b-92c5-75a08c55bc99"],
Cell[348731, 10742, 173, 4, 24, "Output",ExpressionUUID->"560951db-fa10-46e9-8c8c-f58a77257f5f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[348941, 10751, 159, 3, 25, "Input",ExpressionUUID->"3266b32c-b6d6-4a21-995e-f5b83e54ba43"],
Cell[349103, 10756, 124, 2, 23, "Output",ExpressionUUID->"cbc72091-40b7-4010-a50b-6fdec0af7ecf"]
}, Open  ]],
Cell[349242, 10761, 228, 3, 36, "MathCaption",ExpressionUUID->"c1d1b610-967d-4863-b568-32b65e60fa8c"],
Cell[349473, 10766, 299, 8, 41, "Input",ExpressionUUID->"e211045a-a6b5-40cf-9f0a-a0c6935dc1a4"],
Cell[CellGroupData[{
Cell[349797, 10778, 188, 5, 25, "Input",ExpressionUUID->"17650e83-f8a1-4838-85df-940255f17b0d"],
Cell[349988, 10785, 162, 4, 23, "Output",ExpressionUUID->"851969d0-2bd6-4fc8-8a61-d202e41757aa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[350187, 10794, 366, 11, 25, "Input",ExpressionUUID->"44cb1bc9-7156-49df-a372-1cd9dd85a62a"],
Cell[350556, 10807, 187, 4, 19, "Print",ExpressionUUID->"a294e11d-4170-453e-8040-58d06d790f37"]
}, Open  ]],
Cell[CellGroupData[{
Cell[350780, 10816, 146, 3, 25, "Input",ExpressionUUID->"e2f59ae1-eed5-4cdf-84a3-74380ba63825"],
Cell[350929, 10821, 172, 4, 24, "Output",ExpressionUUID->"a74a7991-824e-479e-b985-5c53c7218c0d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[351138, 10830, 156, 3, 25, "Input",ExpressionUUID->"abbb9546-63f2-4892-a5af-c3a69c064980"],
Cell[351297, 10835, 118, 2, 23, "Output",ExpressionUUID->"f689a4f1-e7d6-4459-8afd-230c72f2b75e"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[351464, 10843, 101, 0, 17, "SubsubsectionIcon",ExpressionUUID->"e671debd-122a-460d-8f10-9afb40e85408"],
Cell[351568, 10845, 273, 5, 21, "Text",ExpressionUUID->"34d80ecc-ab26-445a-ad3c-03783210ef26"],
Cell[351844, 10852, 207, 3, 36, "MathCaption",ExpressionUUID->"f8968092-e402-4a3c-bac6-4f6376ca52d9"],
Cell[352054, 10857, 1912, 34, 103, "Input",ExpressionUUID->"49636455-a38a-47a8-9a87-c2db3623e3ff"],
Cell[CellGroupData[{
Cell[353991, 10895, 188, 5, 25, "Input",ExpressionUUID->"6264b8e0-0e7e-4bfa-bdbe-ee104dc0f045"],
Cell[354182, 10902, 158, 4, 23, "Output",ExpressionUUID->"6123c7d1-248a-4571-bb9a-f9d031396669"]
}, Open  ]],
Cell[CellGroupData[{
Cell[354377, 10911, 361, 11, 25, "Input",ExpressionUUID->"0ceab5a0-884b-48fb-9aa0-bd2c7d586901"],
Cell[354741, 10924, 186, 4, 19, "Print",ExpressionUUID->"fa9666ea-9cb5-428f-9e4e-d7cbff9430e2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[354964, 10933, 143, 3, 25, "Input",ExpressionUUID->"60cae9b7-50ef-435b-b9e7-2d9286c2eaa6"],
Cell[355110, 10938, 172, 4, 24, "Output",ExpressionUUID->"9ae30b73-46ac-496a-a3f8-cf8bea357702"]
}, Open  ]],
Cell[CellGroupData[{
Cell[355319, 10947, 153, 3, 25, "Input",ExpressionUUID->"45136663-337d-41e6-814d-cc9e440be60d"],
Cell[355475, 10952, 115, 2, 23, "Output",ExpressionUUID->"6aa08c0a-8b51-486f-bab9-b047411eb4a7"]
}, Open  ]],
Cell[355605, 10957, 193, 3, 36, "MathCaption",ExpressionUUID->"3dd7774f-a4bf-4ce8-bba9-874421c5249b"],
Cell[355801, 10962, 11084, 150, 553, "Input",ExpressionUUID->"e2e64d4d-5a3b-44ce-a761-3bfd067913e7"],
Cell[CellGroupData[{
Cell[366910, 11116, 188, 5, 25, "Input",ExpressionUUID->"6c2637bb-d9de-4693-945d-770a10ae2e1b"],
Cell[367101, 11123, 160, 4, 23, "Output",ExpressionUUID->"98c2ca4f-d538-49ce-b10e-2598658742cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[367298, 11132, 362, 11, 25, "Input",ExpressionUUID->"bdf8c9f7-8dab-41b7-9ba2-5ad62c551c06"],
Cell[367663, 11145, 185, 4, 19, "Print",ExpressionUUID->"340214a9-d7eb-423d-bb4c-4016e1016bcb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[367885, 11154, 143, 3, 25, "Input",ExpressionUUID->"0e00b51d-6162-40e0-a016-f56d128f0a31"],
Cell[368031, 11159, 173, 4, 24, "Output",ExpressionUUID->"1b9fbc61-6ea5-4c03-9b95-2e7c5403b7f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[368241, 11168, 153, 3, 25, "Input",ExpressionUUID->"87d1bbd3-09d1-4ba3-9ade-98da2d9a8847"],
Cell[368397, 11173, 119, 2, 23, "Output",ExpressionUUID->"1f6ff5f3-ae49-4c12-9a36-67a1b6fa097b"]
}, Open  ]],
Cell[368531, 11178, 199, 3, 36, "MathCaption",ExpressionUUID->"71a8f442-8d5c-4978-99d0-939901b41a93"],
Cell[368733, 11183, 13189, 177, 673, "Input",ExpressionUUID->"8e10d198-c638-4dd8-b826-5ae5be6df077"],
Cell[CellGroupData[{
Cell[381947, 11364, 188, 5, 25, "Input",ExpressionUUID->"867ed90e-49c9-401d-a098-170c0a4ca9b9"],
Cell[382138, 11371, 160, 4, 23, "Output",ExpressionUUID->"3ca340ad-e9f6-40a6-9b1a-6cbc13a5ee06"]
}, Open  ]],
Cell[CellGroupData[{
Cell[382335, 11380, 362, 11, 25, "Input",ExpressionUUID->"44d2b7d9-226b-47ec-8161-f29726786d77"],
Cell[382700, 11393, 186, 4, 19, "Print",ExpressionUUID->"4bd52f77-cd3b-4a6e-9112-70ce9fff0903"]
}, Open  ]],
Cell[CellGroupData[{
Cell[382923, 11402, 143, 3, 25, "Input",ExpressionUUID->"5dfa7574-e0f5-4e6d-a636-30753af2716f"],
Cell[383069, 11407, 174, 4, 24, "Output",ExpressionUUID->"a198012d-b043-48f4-ba76-817743925a95"]
}, Open  ]],
Cell[CellGroupData[{
Cell[383280, 11416, 153, 3, 25, "Input",ExpressionUUID->"7e7c646d-c548-4f87-9d60-3d04b42302db"],
Cell[383436, 11421, 127, 2, 23, "Output",ExpressionUUID->"e34fb959-d95c-4dbd-8050-c78f50fb8c0c"]
}, Open  ]],
Cell[383578, 11426, 176, 3, 36, "MathCaption",ExpressionUUID->"310a4ffb-7605-4a37-9c63-566fa9873648"],
Cell[383757, 11431, 21680, 285, 1123, "Input",ExpressionUUID->"f3822196-30b2-4e9b-bb6f-af382ffe47af"],
Cell[CellGroupData[{
Cell[405462, 11720, 188, 5, 25, "Input",ExpressionUUID->"e6a43e6f-5779-4512-af5d-bef784d7b664"],
Cell[405653, 11727, 160, 4, 23, "Output",ExpressionUUID->"e51338c3-0b77-40a0-962d-69410e5e5e7f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[405850, 11736, 363, 11, 25, "Input",ExpressionUUID->"e4080953-dcde-4158-8adf-847bf3bf6f40"],
Cell[406216, 11749, 184, 4, 19, "Print",ExpressionUUID->"4ab021fc-4f69-4032-862e-e2b0214d644a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[406437, 11758, 144, 3, 25, "Input",ExpressionUUID->"ea6439df-df33-4648-bdef-1320b07e65c0"],
Cell[406584, 11763, 173, 4, 24, "Output",ExpressionUUID->"9de36d82-eb2b-427d-8f3a-94d47abc842d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[406794, 11772, 154, 3, 25, "Input",ExpressionUUID->"48a7daff-87db-4c0b-8107-8ae6e5b5f9f5"],
Cell[406951, 11777, 119, 2, 23, "Output",ExpressionUUID->"9b25c907-8d9a-426f-b5ad-599478135bf1"]
}, Open  ]],
Cell[407085, 11782, 111, 0, 36, "MathCaption",ExpressionUUID->"0e6a4813-7f3b-4835-a5b1-167ad887c57e"],
Cell[407199, 11784, 398, 11, 41, "Input",ExpressionUUID->"d701b816-4fc9-465c-807e-56d7d53e6df7"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[407646, 11801, 93, 0, 35, "Subsection",ExpressionUUID->"4ff88c70-06eb-4b86-bbf5-f623958c8076"],
Cell[CellGroupData[{
Cell[407764, 11805, 143, 1, 21, "SubsubsectionIcon",ExpressionUUID->"236b19d2-9ac0-4e6d-bb12-cbeec7ab785a"],
Cell[407910, 11808, 1779, 27, 145, "Text",ExpressionUUID->"75dca098-de5a-494a-b6fd-17da02d7f5af"],
Cell[409692, 11837, 574, 8, 46, "Text",ExpressionUUID->"40a0b969-0913-4b6d-9b4a-aa0afcf4dce0"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[410315, 11851, 125, 0, 35, "SubsectionIcon",ExpressionUUID->"a265778e-2b5e-4e13-8280-cb023d9175ba"],
Cell[410443, 11853, 423, 6, 33, "Text",ExpressionUUID->"314172ab-0c82-434f-9158-9cc5c1b849ee"],
Cell[410869, 11861, 224, 3, 36, "MathCaption",ExpressionUUID->"87e19719-8f49-430f-b11d-3c6e23eae8e6"],
Cell[CellGroupData[{
Cell[411118, 11868, 766, 21, 24, "Input",ExpressionUUID->"24eff7da-f61a-4c64-a3d2-29cba97e5ffc"],
Cell[411887, 11891, 708, 20, 24, "Output",ExpressionUUID->"a74e2240-b351-4978-89a9-93353ef61f8a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[412632, 11916, 736, 20, 24, "Input",ExpressionUUID->"a3c80aaf-db50-4f42-9a8c-8cd8c343d620"],
Cell[413371, 11938, 698, 20, 24, "Output",ExpressionUUID->"5a9905bd-ef08-43ee-a108-30af8f3d69bc"]
}, Open  ]],
Cell[414084, 11961, 188, 3, 36, "MathCaption",ExpressionUUID->"63adf1fb-9fe6-434d-890f-e98df666a8fc"],
Cell[CellGroupData[{
Cell[414297, 11968, 151, 3, 25, "Input",ExpressionUUID->"f64245b9-98ea-49e5-8ee0-c80863652b36"],
Cell[414451, 11973, 111, 2, 23, "Output",ExpressionUUID->"b7e788d0-fd75-4686-a0f4-078029a80101"]
}, Open  ]],
Cell[CellGroupData[{
Cell[414599, 11980, 296, 7, 25, "Input",ExpressionUUID->"59ebf7a3-65e9-442a-ba23-1385f16b71ad"],
Cell[414898, 11989, 1249, 36, 40, "Output",ExpressionUUID->"7bc50acd-77d6-429f-8999-a53557cdf8ca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[416184, 12030, 150, 4, 24, "Input",ExpressionUUID->"2acd7df0-9b03-405f-9262-1be1da852e24"],
Cell[416337, 12036, 112, 2, 23, "Output",ExpressionUUID->"e2048e7d-6530-4cb4-bd2f-6bde3c4181e2"]
}, Open  ]],
Cell[416464, 12041, 221, 3, 36, "MathCaption",ExpressionUUID->"4e326b5b-4d32-4e21-afdc-7a47e9b99789"],
Cell[416688, 12046, 349, 9, 25, "Input",ExpressionUUID->"ec9ef587-fbf7-44c3-a615-345ddf878539"],
Cell[CellGroupData[{
Cell[417062, 12059, 176, 4, 25, "Input",ExpressionUUID->"7688a9b2-6960-47d1-9ce4-ab80bce26a2f"],
Cell[417241, 12065, 115, 2, 23, "Output",ExpressionUUID->"be3d9ef8-7a9d-43e0-b598-20d6fe475f33"]
}, Open  ]],
Cell[CellGroupData[{
Cell[417393, 12072, 205, 5, 25, "Input",ExpressionUUID->"15257a5d-1f8b-4b78-bf92-18f2e645c832"],
Cell[417601, 12079, 1249, 36, 39, "Output",ExpressionUUID->"0c034aa1-2cf6-49f2-8369-da8cdcae6840"]
}, Open  ]],
Cell[CellGroupData[{
Cell[418887, 12120, 148, 3, 24, "Input",ExpressionUUID->"18f8f9ff-6f2a-4fdc-9f22-1994c6db83e5"],
Cell[419038, 12125, 1249, 36, 39, "Output",ExpressionUUID->"33d6f2c0-b4ea-4227-88b1-14c3585ff412"]
}, Open  ]],
Cell[420302, 12164, 240, 5, 37, "MathCaption",ExpressionUUID->"dbee0d35-c9d9-42ce-9edc-aa8ba29d4b8e"],
Cell[CellGroupData[{
Cell[420567, 12173, 222, 6, 25, "Input",ExpressionUUID->"42d9cefe-2bb4-4f02-9683-9a1b4d928d49"],
Cell[420792, 12181, 1265, 36, 40, "Output",ExpressionUUID->"d2d7c893-66b6-4a09-8c72-17984cfc4ced"]
}, Open  ]],
Cell[422072, 12220, 130, 0, 36, "MathCaption",ExpressionUUID->"6cd03c89-6f8f-4166-9419-b705c6497511"],
Cell[CellGroupData[{
Cell[422227, 12224, 199, 4, 25, "Input",ExpressionUUID->"3dd22d53-0f31-4f9e-a0c7-7494454ee489"],
Cell[422429, 12230, 503, 15, 24, "Output",ExpressionUUID->"290e7177-047f-4630-a037-e49769f49dbb"]
}, Open  ]],
Cell[422947, 12248, 290, 4, 49, "MathCaption",ExpressionUUID->"515b26d1-96e1-4304-b38b-3a870d24b743"],
Cell[CellGroupData[{
Cell[423262, 12256, 268, 6, 25, "Input",ExpressionUUID->"3d447ac0-2ea0-4a15-a776-5c64057208bf"],
Cell[423533, 12264, 475, 14, 24, "Output",ExpressionUUID->"137c4bd9-c044-4a89-aaee-6715b5adca4a"]
}, Open  ]],
Cell[424023, 12281, 372, 5, 49, "MathCaption",ExpressionUUID->"23a31183-d619-446b-b057-6d096847adf5"],
Cell[CellGroupData[{
Cell[424420, 12290, 258, 6, 25, "Input",ExpressionUUID->"8fa833e8-4e12-45c7-b1bb-e5cf3a60ce8a"],
Cell[424681, 12298, 611, 18, 24, "Output",ExpressionUUID->"47e33fc3-eaf7-45c6-8210-bb18a7a8392f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[425329, 12321, 271, 7, 25, "Input",ExpressionUUID->"0928ad5e-a9bb-450d-bf38-79ad437b58a1"],
Cell[425603, 12330, 231, 6, 23, "Output",ExpressionUUID->"e4549eb3-a450-43c5-9ced-686a262eeb07"]
}, Open  ]],
Cell[CellGroupData[{
Cell[425871, 12341, 216, 6, 24, "Input",ExpressionUUID->"86848e96-d666-407a-bcc0-27d3a98eb15f"],
Cell[426090, 12349, 156, 4, 23, "Output",ExpressionUUID->"95666fb8-c3e9-4095-9e1c-643650f12f8c"]
}, Open  ]],
Cell[426261, 12356, 141, 3, 24, "Input",ExpressionUUID->"8bbee783-0c48-4d00-bd6a-294e82799250"],
Cell[426405, 12361, 366, 7, 50, "MathCaption",ExpressionUUID->"9dfa7939-01b8-4e55-be5c-f5a6e2975e32"],
Cell[CellGroupData[{
Cell[426796, 12372, 228, 6, 24, "Input",ExpressionUUID->"8452f0ef-8dd8-49f8-8d96-12b0d1db2ede"],
Cell[427027, 12380, 1249, 36, 39, "Output",ExpressionUUID->"5e7615da-e479-487f-800e-8f9259c3ad90"]
}, Open  ]],
Cell[CellGroupData[{
Cell[428313, 12421, 199, 4, 25, "Input",ExpressionUUID->"dfb74d24-cbeb-4e8b-9244-676265945b79"],
Cell[428515, 12427, 503, 15, 24, "Output",ExpressionUUID->"7ecbe2da-1995-474e-8297-5c99d355eb3b"]
}, Open  ]],
Cell[429033, 12445, 397, 9, 50, "MathCaption",ExpressionUUID->"48700219-e143-4068-9566-fc0a99ed941f"],
Cell[CellGroupData[{
Cell[429455, 12458, 660, 20, 25, "Input",ExpressionUUID->"0c0f0a64-ea77-4783-a415-48e0feece673"],
Cell[430118, 12480, 114, 2, 23, "Output",ExpressionUUID->"ae27011c-8a0e-4000-a472-ce37c41fbb8d"]
}, Open  ]],
Cell[430247, 12485, 365, 9, 50, "MathCaption",ExpressionUUID->"d1c5f86f-1156-4f5b-a98c-305590620551"],
Cell[CellGroupData[{
Cell[430637, 12498, 296, 6, 25, "Input",ExpressionUUID->"25ca32cc-ffc1-4580-893e-15bad99f603b"],
Cell[430936, 12506, 494, 13, 19, "Print",ExpressionUUID->"fca105c5-36bc-4eb0-ad94-4326c0495041"],
Cell[431433, 12521, 486, 13, 20, "Print",ExpressionUUID->"6eaf2893-1664-4558-b64d-986cff341f6f"],
Cell[431922, 12536, 308, 9, 19, "Print",ExpressionUUID->"a986235d-eb2f-4694-8168-99f80b719bf7"],
Cell[432233, 12547, 454, 10, 20, "Print",ExpressionUUID->"fc4d61bb-be29-45db-a583-8e3bf9a4d99b"],
Cell[432690, 12559, 384, 9, 20, "Print",ExpressionUUID->"49752565-1f29-49bd-b773-649f31b5bcea"],
Cell[433077, 12570, 372, 9, 19, "Print",ExpressionUUID->"afabea94-3a1d-4d5c-9e86-9ab4fafc739b"],
Cell[433452, 12581, 400, 10, 20, "Print",ExpressionUUID->"fe28c260-7685-4b27-aad8-a54d3e534d3a"],
Cell[433855, 12593, 433, 11, 20, "Print",ExpressionUUID->"c8452b0c-fc08-42d7-ac0c-ee7c3014789d"],
Cell[434291, 12606, 462, 10, 20, "Print",ExpressionUUID->"bab51776-e000-4946-ab00-781c4c47ae17"],
Cell[434756, 12618, 330, 8, 20, "Print",ExpressionUUID->"a160d82f-b745-4e4e-b093-6f22ee3762fd"],
Cell[435089, 12628, 700, 16, 20, "Print",ExpressionUUID->"adc29fac-3dae-4759-81e7-54ef156eb0b4"],
Cell[435792, 12646, 444, 12, 19, "Print",ExpressionUUID->"682e2f28-96ad-4c08-9a21-97f0eb97c683"],
Cell[436239, 12660, 314, 8, 20, "Print",ExpressionUUID->"fa028bac-b8f1-4d37-9675-d8aeed1ebc2c"],
Cell[436556, 12670, 342, 9, 20, "Print",ExpressionUUID->"7920f770-c6fa-489b-aba3-ea5b413211d5"],
Cell[436901, 12681, 312, 8, 20, "Print",ExpressionUUID->"1ff9d20e-3933-40f0-a15b-ac35b7318f90"],
Cell[437216, 12691, 454, 10, 20, "Print",ExpressionUUID->"42b4fc0a-31ac-4947-92b7-c3208857e677"],
Cell[437673, 12703, 358, 9, 20, "Print",ExpressionUUID->"26771284-1806-4a2a-bde0-0b2fb47449c9"],
Cell[438034, 12714, 372, 9, 19, "Print",ExpressionUUID->"730fb917-1ce4-4ceb-ad2f-316921175104"],
Cell[438409, 12725, 374, 10, 20, "Print",ExpressionUUID->"c134dd9f-cebb-4c90-9f8e-05991a378101"],
Cell[438786, 12737, 404, 10, 20, "Print",ExpressionUUID->"5779c7d5-5eef-413f-8bff-b32b674ee039"],
Cell[439193, 12749, 462, 10, 20, "Print",ExpressionUUID->"442e2574-a78e-45ae-be64-5f6186f9415f"],
Cell[439658, 12761, 330, 8, 20, "Print",ExpressionUUID->"de253faf-60e3-4a1a-b7b4-083dea925ea3"],
Cell[439991, 12771, 551, 12, 20, "Print",ExpressionUUID->"32cb49a7-c76e-4266-ae55-48d88144c6bc"],
Cell[440545, 12785, 444, 12, 19, "Print",ExpressionUUID->"8f7161f6-a1da-4a70-913d-56300abeb27a"],
Cell[440992, 12799, 314, 8, 20, "Print",ExpressionUUID->"0cd766d1-d945-4b78-8126-b6430cda5785"],
Cell[441309, 12809, 314, 8, 20, "Print",ExpressionUUID->"67112b96-c061-4f1f-a098-4f9a861732dd"],
Cell[441626, 12819, 306, 8, 20, "Print",ExpressionUUID->"fe38b342-05fb-411d-9fe9-3b54dd5205f0"],
Cell[441935, 12829, 503, 15, 24, "Output",ExpressionUUID->"d49ba32b-d051-4f48-87b3-3bb95979d769"]
}, Open  ]],
Cell[442453, 12847, 218, 3, 38, "DefinitionBox",ExpressionUUID->"daa0b8bf-3f8b-411a-8915-5258f8d42fa7"],
Cell[442674, 12852, 109, 0, 20, "SmallText",ExpressionUUID->"c38e3a2a-c385-4303-a2c7-b3d24b9b264c"]
}, Closed]],
Cell[CellGroupData[{
Cell[442820, 12857, 126, 0, 25, "SubsectionIcon",ExpressionUUID->"4b4a6e54-e6d3-4a5f-868a-523d8675d77f"],
Cell[442949, 12859, 356, 5, 33, "Text",ExpressionUUID->"9c18b54d-bc28-41e3-87aa-3304ff708b2d"],
Cell[443308, 12866, 2084, 32, 196, "Text",ExpressionUUID->"f8ce0f13-8ba6-4bf8-a908-8aa62520d9af"],
Cell[445395, 12900, 499, 8, 63, "MathCaption",ExpressionUUID->"d590f20e-12c0-47b1-9087-2bbcf996325e"],
Cell[445897, 12910, 603, 19, 25, "Input",ExpressionUUID->"b6895d1e-1dae-4d69-8261-1bf0992b9663"],
Cell[CellGroupData[{
Cell[446525, 12933, 156, 3, 25, "Input",ExpressionUUID->"f1edb386-1791-4591-ab08-1d2e0d385610"],
Cell[446684, 12938, 1044, 32, 40, "Output",ExpressionUUID->"389e1e1d-04b1-4264-b21e-fa35b8dbe71c"]
}, Open  ]],
Cell[447743, 12973, 178, 3, 36, "MathCaption",ExpressionUUID->"6420bac4-ff49-4fa7-9685-55cace705bc1"],
Cell[447924, 12978, 603, 19, 25, "Input",ExpressionUUID->"20e02350-d31d-4367-bca3-c1c7266c8866"],
Cell[CellGroupData[{
Cell[448552, 13001, 182, 4, 25, "Input",ExpressionUUID->"9856fa79-77fc-4338-b7b6-608253723df2"],
Cell[448737, 13007, 1552, 47, 40, "Output",ExpressionUUID->"c20d5b99-1e5c-4b9f-a71c-a0c6c656d3c1"]
}, Open  ]],
Cell[450304, 13057, 383, 12, 25, "Input",ExpressionUUID->"0afb6ddb-4f49-42ee-81ab-f7274dcb83d4"],
Cell[CellGroupData[{
Cell[450712, 13073, 147, 3, 25, "Input",ExpressionUUID->"6a12841e-1a98-4330-a2d3-ce4e6e7433ba"],
Cell[450862, 13078, 114, 2, 23, "Output",ExpressionUUID->"7951e814-e7ca-4981-b808-9762553ee7cb"]
}, Open  ]],
Cell[450991, 13083, 459, 6, 62, "MathCaption",ExpressionUUID->"17f560dd-633b-421e-8bb9-244c0fa035db"],
Cell[451453, 13091, 357, 10, 25, "Input",ExpressionUUID->"81507411-4711-4f1f-b97d-41263ba35aaa"],
Cell[451813, 13103, 226, 6, 25, "Input",ExpressionUUID->"708dbb67-3005-46e2-bd66-34ee04869585"],
Cell[CellGroupData[{
Cell[452064, 13113, 1120, 31, 105, "Input",ExpressionUUID->"e8f40b35-e027-4872-9893-02bd95cb7261"],
Cell[453187, 13146, 606, 14, 20, "Print",ExpressionUUID->"e35f5be3-d375-4a4e-907b-60237dd3744a"],
Cell[453796, 13162, 606, 14, 20, "Print",ExpressionUUID->"d6c1b384-5e29-4103-bf3f-4746eddcced7"],
Cell[454405, 13178, 606, 14, 20, "Print",ExpressionUUID->"5cac4b64-d111-4873-8752-3f3c9872e735"],
Cell[455014, 13194, 608, 14, 20, "Print",ExpressionUUID->"87dd6a6e-4a74-425f-8057-16ab4db8eb62"],
Cell[455625, 13210, 608, 14, 20, "Print",ExpressionUUID->"3e181737-0a1f-4867-a1bf-1d62f8d73345"],
Cell[456236, 13226, 610, 14, 20, "Print",ExpressionUUID->"0b277d8e-6984-494c-8bfe-ad5329d8b8b5"],
Cell[456849, 13242, 610, 14, 20, "Print",ExpressionUUID->"512048db-0dc7-49af-a47e-b346c9a36a69"],
Cell[457462, 13258, 610, 14, 20, "Print",ExpressionUUID->"5368956c-6e62-4228-831c-089390628d06"],
Cell[458075, 13274, 610, 14, 20, "Print",ExpressionUUID->"8894bf59-d095-4336-8595-1850936eac3e"],
Cell[458688, 13290, 610, 14, 20, "Print",ExpressionUUID->"1c0c094d-e972-4a0a-8a82-5929a88f8e76"],
Cell[459301, 13306, 610, 14, 20, "Print",ExpressionUUID->"efca8420-e945-4f64-93e6-a0857baeaf5a"],
Cell[459914, 13322, 421, 11, 24, "Output",ExpressionUUID->"0118060f-d561-47f3-9c22-6a1892a456d5"]
}, Open  ]],
Cell[460350, 13336, 283, 4, 49, "MathCaption",ExpressionUUID->"27dd0914-10b3-42e1-afda-705b22470a1f"],
Cell[CellGroupData[{
Cell[460658, 13344, 390, 10, 25, "Input",ExpressionUUID->"c6fe0830-88f2-4499-949d-fd0fe2bd48ee"],
Cell[461051, 13356, 417, 10, 24, "Output",ExpressionUUID->"77b06926-5464-422e-a879-37a2a5d2a7cf"]
}, Open  ]],
Cell[461483, 13369, 119, 0, 36, "MathCaption",ExpressionUUID->"b0710b03-0e6e-48b4-b6a7-baee3e36c6d5"],
Cell[461605, 13371, 577, 10, 80, "DefinitionBox",ExpressionUUID->"d98a5496-941c-472c-8fbb-7ed284446fa5"],
Cell[462185, 13383, 123, 0, 20, "SmallText",ExpressionUUID->"e6d7cd78-d07e-421a-a26a-98307aaa7b51"]
}, Closed]],
Cell[CellGroupData[{
Cell[462345, 13388, 106, 0, 25, "SubsectionIcon",ExpressionUUID->"c69f9be8-5879-47c5-9544-feab4dd4c115"],
Cell[462454, 13390, 281, 4, 33, "Text",ExpressionUUID->"68131c1c-d7f8-4d2c-a27b-2acc9da15332"],
Cell[462738, 13396, 221, 3, 36, "MathCaption",ExpressionUUID->"ce8f605e-d710-49a5-a5b4-b2261e2192de"],
Cell[462962, 13401, 344, 9, 25, "Input",ExpressionUUID->"6f2b8bf0-4f26-473a-a17c-aad921d11b27"],
Cell[CellGroupData[{
Cell[463331, 13414, 180, 4, 25, "Input",ExpressionUUID->"fb3a81b3-5082-4df6-ac31-154213942ca7"],
Cell[463514, 13420, 302, 7, 24, "Output",ExpressionUUID->"9b4abd7d-5ee2-4796-8166-f739b4e76e69"]
}, Open  ]],
Cell[463831, 13430, 132, 0, 36, "MathCaption",ExpressionUUID->"c54edf6c-ab6a-4b88-8618-256d9ad3a6a9"],
Cell[463966, 13432, 1877, 58, 57, "Input",ExpressionUUID->"534e3833-6fad-4f5f-88ac-fd5f560b1c22"],
Cell[465846, 13492, 241, 5, 37, "MathCaption",ExpressionUUID->"313082cb-1216-49d6-83a3-c4aa6aac4527"],
Cell[CellGroupData[{
Cell[466112, 13501, 364, 8, 25, "Input",ExpressionUUID->"b118b57f-68b3-4dc3-8984-00f3ea47a131"],
Cell[466479, 13511, 485, 11, 20, "Print",ExpressionUUID->"0ebd8e4b-a865-41bc-817c-3fe215be4f0f"],
Cell[466967, 13524, 390, 9, 20, "Print",ExpressionUUID->"dd801899-5c5f-4a46-a34f-f24aa10ea33f"],
Cell[467360, 13535, 337, 10, 24, "Output",ExpressionUUID->"de257b64-0c31-4b2e-be97-eba75f4fcdb6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[467734, 13550, 177, 4, 25, "Input",ExpressionUUID->"cad58b04-f539-4e0e-973e-24bb82a4b6d4"],
Cell[467914, 13556, 302, 7, 24, "Output",ExpressionUUID->"3fda665e-8c95-4e47-b166-fc458b978126"]
}, Open  ]],
Cell[CellGroupData[{
Cell[468253, 13568, 310, 7, 25, "Input",ExpressionUUID->"287f2852-e4fe-4fa9-8077-67a15c3e8f26"],
Cell[468566, 13577, 302, 7, 24, "Output",ExpressionUUID->"bda0d5d6-000f-4d3a-88cf-c426bbdeec0d"]
}, Open  ]],
Cell[468883, 13587, 292, 6, 37, "MathCaption",ExpressionUUID->"1ce0b9ef-3fe4-4a35-be29-ccc38042f7bb"],
Cell[CellGroupData[{
Cell[469200, 13597, 336, 10, 25, "Input",ExpressionUUID->"80ef7555-ad7e-4cbe-9cfa-ab4c6fa684a9"],
Cell[469539, 13609, 114, 2, 23, "Output",ExpressionUUID->"a4f0f6da-afe4-40e1-92d4-f3ba57028755"]
}, Open  ]],
Cell[CellGroupData[{
Cell[469690, 13616, 1330, 36, 121, "Input",ExpressionUUID->"041f1c94-977e-442e-b0ee-872ca3790161"],
Cell[471023, 13654, 606, 14, 20, "Print",ExpressionUUID->"f5e9c301-0e74-4867-8880-ead82d5e73f7"],
Cell[471632, 13670, 606, 14, 20, "Print",ExpressionUUID->"80f8dc1b-818f-427b-9aa3-03ec62a5af12"],
Cell[472241, 13686, 608, 14, 20, "Print",ExpressionUUID->"364c3c0c-d764-4388-966e-9bd3b8260549"],
Cell[472852, 13702, 608, 14, 20, "Print",ExpressionUUID->"238a4cc2-f22d-4b04-874a-a7bafd432170"],
Cell[473463, 13718, 608, 14, 20, "Print",ExpressionUUID->"22e2311d-6bdf-401d-bbdd-62d3c868673d"],
Cell[474074, 13734, 608, 14, 20, "Print",ExpressionUUID->"84ee2e1e-10e7-4c76-aeb3-94fe74a33212"],
Cell[474685, 13750, 608, 14, 20, "Print",ExpressionUUID->"7de4ac4a-0a5f-4e66-a782-d7ca446fca25"],
Cell[475296, 13766, 608, 14, 20, "Print",ExpressionUUID->"f53910ff-a8e1-478c-a92d-66d1edbe6abe"],
Cell[475907, 13782, 610, 14, 20, "Print",ExpressionUUID->"a6eaeeb4-c9bd-4887-979a-b1e871a88231"],
Cell[476520, 13798, 610, 14, 20, "Print",ExpressionUUID->"68681721-fcd4-4e3b-a006-20ba0cc370dc"],
Cell[477133, 13814, 610, 14, 20, "Print",ExpressionUUID->"3fa3dbce-7544-4977-91bd-6de0ad42a184"],
Cell[477746, 13830, 417, 10, 24, "Output",ExpressionUUID->"83c9a00a-2732-406d-9a8b-af94dee7a211"]
}, Open  ]],
Cell[478178, 13843, 352, 5, 49, "MathCaption",ExpressionUUID->"b425167d-9fe4-4213-8fcf-2c09e57766e4"],
Cell[CellGroupData[{
Cell[478555, 13852, 844, 24, 41, "Input",ExpressionUUID->"dbe9fc23-6002-4d0f-b4d5-4855d0eae6ea"],
Cell[479402, 13878, 485, 11, 20, "Print",ExpressionUUID->"950c50fd-3a88-424a-8cea-e6046b799f59"],
Cell[479890, 13891, 386, 8, 20, "Print",ExpressionUUID->"6754ac49-9a40-44b9-a1c2-f13d24673a40"],
Cell[480279, 13901, 386, 8, 20, "Print",ExpressionUUID->"245a5b55-dbc8-42b5-ba08-37c4a21b15a0"],
Cell[480668, 13911, 420, 13, 24, "Output",ExpressionUUID->"03859529-ebd6-4176-91ee-7a1e4f2c2b85"]
}, Open  ]],
Cell[CellGroupData[{
Cell[481125, 13929, 227, 6, 25, "Input",ExpressionUUID->"b549be36-ac87-4cec-9520-33fc61d9ed0c"],
Cell[481355, 13937, 328, 9, 24, "Output",ExpressionUUID->"1308f2a7-21c7-4485-a505-bc639170c98b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[481720, 13951, 790, 23, 25, "Input",ExpressionUUID->"429af4fa-5918-4491-9baa-89e8b34bc4c7"],
Cell[482513, 13976, 328, 9, 24, "Output",ExpressionUUID->"ba89510b-320f-4748-a0f5-a0144b946495"]
}, Open  ]],
Cell[482856, 13988, 535, 7, 62, "MathCaption",ExpressionUUID->"3cd8cf8c-5420-494b-8da4-078aa8306926"],
Cell[CellGroupData[{
Cell[483416, 13999, 773, 23, 25, "Input",ExpressionUUID->"19aba3b4-da65-4f8a-a6bd-d4de3f3e4c4d"],
Cell[484192, 14024, 2285, 54, 88, "Output",ExpressionUUID->"dfac5d4a-c09f-47d5-9e41-2ce52b9e11a4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[486514, 14083, 263, 7, 25, "Input",ExpressionUUID->"1ea8e88d-eb6c-481c-a178-fbac955ee9ed"],
Cell[486780, 14092, 114, 2, 23, "Output",ExpressionUUID->"50975641-b311-497a-aabe-5de2d550db42"]
}, Open  ]],
Cell[CellGroupData[{
Cell[486931, 14099, 1740, 46, 152, "Input",ExpressionUUID->"245a4ada-2e7a-4b05-aa54-d5034b463c2c",
 Evaluatable->False],
Cell[488674, 14147, 655, 14, 20, "Print",ExpressionUUID->"ac75d8f4-f72b-4216-80b1-8c2a0232ab1f"],
Cell[489332, 14163, 657, 14, 20, "Print",ExpressionUUID->"6658f8ea-99ac-490f-a450-1dff7e768fa6"],
Cell[489992, 14179, 657, 14, 20, "Print",ExpressionUUID->"de32b194-062f-444c-8787-db89dcb58b21"],
Cell[490652, 14195, 657, 14, 20, "Print",ExpressionUUID->"ad57bb2d-2dd7-402b-9623-aeba44813bcd"],
Cell[491312, 14211, 657, 14, 20, "Print",ExpressionUUID->"e914f56f-f23a-4766-b1cf-aef81569a83d"],
Cell[491972, 14227, 659, 14, 20, "Print",ExpressionUUID->"d776dbd6-eaa1-439b-8522-029d460b98d5"],
Cell[492634, 14243, 659, 14, 20, "Print",ExpressionUUID->"c499c843-8008-417c-93e7-2075e093afbf"],
Cell[493296, 14259, 659, 14, 20, "Print",ExpressionUUID->"587f7d3f-7437-4aaa-bde9-30d6972b85bb"],
Cell[493958, 14275, 659, 14, 20, "Print",ExpressionUUID->"55483ba6-24ec-4d2b-a3df-fb48ca3b9be3"],
Cell[494620, 14291, 659, 14, 20, "Print",ExpressionUUID->"19ea771e-e833-46b0-b1c2-a52ff4b2e0a5"],
Cell[495282, 14307, 659, 14, 20, "Print",ExpressionUUID->"39d0e689-3c84-4e51-9051-27fd8b87681a"],
Cell[495944, 14323, 659, 14, 20, "Print",ExpressionUUID->"fdc18bb5-418d-44f4-a39b-aa0bf4ad6569"],
Cell[496606, 14339, 659, 14, 20, "Print",ExpressionUUID->"2dc400d0-0b52-4d91-86e5-822620dcd17f"],
Cell[497268, 14355, 659, 14, 20, "Print",ExpressionUUID->"adc6a379-56c8-495b-8a30-760fb4b6f260"],
Cell[497930, 14371, 659, 14, 20, "Print",ExpressionUUID->"d6865478-9642-401b-adc3-32aefc42fe63"],
Cell[498592, 14387, 661, 14, 20, "Print",ExpressionUUID->"0d26ad58-ccba-4c1e-8f39-1fdf057e6612"],
Cell[499256, 14403, 661, 14, 20, "Print",ExpressionUUID->"12e79465-0f8a-4385-b117-4417ee9de326"],
Cell[499920, 14419, 661, 14, 20, "Print",ExpressionUUID->"fac34c74-05dc-4e6b-ad31-79b8ff259ca4"],
Cell[500584, 14435, 661, 14, 20, "Print",ExpressionUUID->"ffbeaf07-663c-480d-b8ef-01bce2ff98be"],
Cell[501248, 14451, 661, 14, 20, "Print",ExpressionUUID->"a850db82-06b6-4ffc-bb95-1bfbbf93367d"],
Cell[501912, 14467, 661, 14, 20, "Print",ExpressionUUID->"3ff88c00-b1a2-4fd7-9354-466097f1063d"],
Cell[502576, 14483, 661, 14, 20, "Print",ExpressionUUID->"8173a7f4-d968-4ea8-b142-8111e5a55629"],
Cell[503240, 14499, 661, 14, 20, "Print",ExpressionUUID->"c83d69f5-0335-4d66-a0ef-8f8318c4423e"],
Cell[503904, 14515, 661, 14, 20, "Print",ExpressionUUID->"28872fb6-8429-49b3-bc63-d8e4f09c3fa3"],
Cell[504568, 14531, 661, 14, 20, "Print",ExpressionUUID->"350fe177-7c64-4895-9ca7-135518a2541c"],
Cell[505232, 14547, 661, 14, 20, "Print",ExpressionUUID->"827cdc39-70fd-452e-84a3-f752e42139a9"],
Cell[505896, 14563, 661, 14, 20, "Print",ExpressionUUID->"78f8d6d5-8810-41e5-ade1-122d1a52a638"],
Cell[506560, 14579, 661, 14, 20, "Print",ExpressionUUID->"0c7a211e-0ebc-416a-ad3a-cc1809e752fd"],
Cell[507224, 14595, 661, 14, 20, "Print",ExpressionUUID->"3a33d99f-ff52-4936-9704-6d9da9133429"],
Cell[507888, 14611, 661, 14, 20, "Print",ExpressionUUID->"d1c8b629-1b35-463e-948e-9ff895bd42e0"],
Cell[508552, 14627, 661, 14, 20, "Print",ExpressionUUID->"ea2f9cbb-c908-4cdd-b746-e3c06ea60314"],
Cell[509216, 14643, 661, 14, 20, "Print",ExpressionUUID->"92069e23-e6bb-4db1-a630-d7999e6b8e94"],
Cell[509880, 14659, 661, 14, 20, "Print",ExpressionUUID->"1a1351fd-a9f5-4bc2-8ad5-edbda982aa40"],
Cell[510544, 14675, 661, 14, 20, "Print",ExpressionUUID->"48b7429d-3386-4e61-9c15-9c10366e86dc"],
Cell[511208, 14691, 661, 14, 20, "Print",ExpressionUUID->"e2d00cd6-d8bd-4d82-b6d7-696c847b4eca"],
Cell[511872, 14707, 661, 14, 20, "Print",ExpressionUUID->"e3c2d39b-c066-458a-b6c0-d68ae686e99a"],
Cell[512536, 14723, 661, 14, 20, "Print",ExpressionUUID->"4f7f5c51-0f34-4a9e-bff1-91a6cff3b5dc"],
Cell[513200, 14739, 661, 14, 20, "Print",ExpressionUUID->"e9372b8e-98c0-4243-a118-193e4d8e0bfe"],
Cell[513864, 14755, 661, 14, 20, "Print",ExpressionUUID->"280217a1-1a8a-48d2-990e-0fa9b4463e9a"],
Cell[514528, 14771, 683, 16, 20, "Print",ExpressionUUID->"3bab190b-fd95-4ccd-913b-c6d7e3337d8a"],
Cell[515214, 14789, 683, 16, 20, "Print",ExpressionUUID->"751c6b19-4bbb-4c33-b862-a64858f43dfd"],
Cell[515900, 14807, 685, 16, 20, "Print",ExpressionUUID->"c914bc0a-72cd-4de8-92c6-79e71ceed6aa"],
Cell[516588, 14825, 685, 16, 20, "Print",ExpressionUUID->"e7839efc-6335-4b74-a797-bf0fec44e2ae"],
Cell[517276, 14843, 685, 16, 20, "Print",ExpressionUUID->"1b51481a-b2ec-48e4-a650-231ba0e6137b"],
Cell[517964, 14861, 685, 16, 20, "Print",ExpressionUUID->"c04b703a-ae57-4d82-aca3-1463fd18be50"],
Cell[518652, 14879, 687, 16, 20, "Print",ExpressionUUID->"09566996-fe1a-486f-9efd-567baa416d00"],
Cell[519342, 14897, 687, 16, 20, "Print",ExpressionUUID->"e4be9a0d-59aa-4123-b56f-2f7a182f4cde"],
Cell[520032, 14915, 687, 16, 20, "Print",ExpressionUUID->"736d70b1-7276-4a75-a2a6-02d4b233d211"],
Cell[520722, 14933, 687, 16, 20, "Print",ExpressionUUID->"271401cb-2c71-4eec-b9ec-5ae888ad2020"],
Cell[521412, 14951, 687, 16, 20, "Print",ExpressionUUID->"06aad58c-3ecf-423d-9e92-08b0c781a7fb"],
Cell[522102, 14969, 687, 16, 20, "Print",ExpressionUUID->"75f5fa72-fec1-43f1-b5ac-a8b6525d3723"],
Cell[522792, 14987, 687, 16, 20, "Print",ExpressionUUID->"c207c821-eccc-4fde-84c8-b610f952c003"],
Cell[523482, 15005, 687, 16, 20, "Print",ExpressionUUID->"b9820d3a-d0ef-4c3a-a943-061067f76dff"],
Cell[524172, 15023, 687, 16, 20, "Print",ExpressionUUID->"c35baa51-68b1-42ab-8c4b-41ac1ad5ba4e"],
Cell[524862, 15041, 687, 16, 20, "Print",ExpressionUUID->"d115c052-c325-4c1b-b76a-063ae1ce887d"],
Cell[525552, 15059, 689, 16, 20, "Print",ExpressionUUID->"2aeac8f6-1b05-49f0-8bf8-08f42741de69"],
Cell[526244, 15077, 689, 16, 20, "Print",ExpressionUUID->"26f9a33c-0e89-4be9-97a4-08371477c40b"],
Cell[526936, 15095, 689, 16, 20, "Print",ExpressionUUID->"ef7619fd-abef-4821-bc65-85914afc40aa"],
Cell[527628, 15113, 689, 16, 20, "Print",ExpressionUUID->"4eed1fa2-8b2c-44da-9300-c3b0a14d37bd"],
Cell[528320, 15131, 689, 16, 20, "Print",ExpressionUUID->"b4e2a9a7-4f3b-4a95-ac41-2f7e61f8789a"],
Cell[529012, 15149, 689, 16, 20, "Print",ExpressionUUID->"9110d436-4796-4875-9c8d-ecf0dd1b89b1"],
Cell[529704, 15167, 689, 16, 20, "Print",ExpressionUUID->"1b932b92-dd41-4783-b3fa-dd0d0d9e7873"],
Cell[530396, 15185, 689, 16, 20, "Print",ExpressionUUID->"cb98d28d-bd4d-4343-a5e7-73dac49d58ef"],
Cell[531088, 15203, 689, 16, 20, "Print",ExpressionUUID->"e7cad0f2-9c7f-4f11-b518-31e8e227d270"],
Cell[531780, 15221, 689, 16, 20, "Print",ExpressionUUID->"51cf418c-0903-4e78-997b-b67d91b5180f"],
Cell[532472, 15239, 689, 16, 20, "Print",ExpressionUUID->"39c8aefa-94a3-4a8b-850d-f82268c13bf0"],
Cell[533164, 15257, 689, 16, 20, "Print",ExpressionUUID->"ab2850a7-35f0-46a3-977d-8b311d3562c3"],
Cell[533856, 15275, 689, 16, 20, "Print",ExpressionUUID->"b337b4fe-02a0-44e9-b926-b0663097499b"],
Cell[534548, 15293, 689, 16, 20, "Print",ExpressionUUID->"b524b50d-834b-4bac-bd72-8382dd6e1dfa"],
Cell[535240, 15311, 689, 16, 20, "Print",ExpressionUUID->"eea6d523-a9c8-4023-a0ea-08397c17a361"],
Cell[535932, 15329, 689, 16, 20, "Print",ExpressionUUID->"7d60adbb-9849-4f4f-9475-10d6201a98a6"],
Cell[536624, 15347, 689, 16, 20, "Print",ExpressionUUID->"2d3cdedc-cd35-4a74-bdc6-d915cd3b8f6d"],
Cell[537316, 15365, 689, 16, 20, "Print",ExpressionUUID->"7b9335f4-5761-4af0-95a9-68746cc008fb"],
Cell[538008, 15383, 689, 16, 20, "Print",ExpressionUUID->"9345a2e4-e2a0-4acf-b169-c1aa2310325d"],
Cell[538700, 15401, 689, 16, 20, "Print",ExpressionUUID->"dc1a00af-0011-4355-8297-30b59536dfde"],
Cell[539392, 15419, 689, 16, 20, "Print",ExpressionUUID->"6356618d-b7aa-4791-ad6d-c6b8e1dc3f5b"],
Cell[540084, 15437, 689, 16, 20, "Print",ExpressionUUID->"f2b55119-ab47-4c31-9e80-eba3a658e6e0"],
Cell[540776, 15455, 689, 16, 20, "Print",ExpressionUUID->"721d4a00-e1b6-44f3-a2c5-25bd5b0802a9"],
Cell[541468, 15473, 689, 16, 20, "Print",ExpressionUUID->"c42c5b7e-a689-47cd-ad2d-f6d95c41ae8c"],
Cell[542160, 15491, 663, 14, 20, "Print",ExpressionUUID->"2b88937e-9d52-44be-887d-e4a05f9f941e"],
Cell[542826, 15507, 663, 14, 20, "Print",ExpressionUUID->"9268e148-475c-42fb-b16f-f658717c835a"],
Cell[543492, 15523, 691, 16, 20, "Print",ExpressionUUID->"ccbb8139-688c-4f47-8fb9-4801220d8e71"],
Cell[544186, 15541, 663, 14, 20, "Print",ExpressionUUID->"e2cd604e-c773-411f-8af1-b0673a209598"],
Cell[544852, 15557, 657, 14, 20, "Print",ExpressionUUID->"21877248-9166-4c41-bb7f-b85026f2da15"],
Cell[545512, 15573, 657, 14, 20, "Print",ExpressionUUID->"168ecdb5-835a-4857-95ad-e06be9165e3d"],
Cell[546172, 15589, 659, 14, 20, "Print",ExpressionUUID->"25d3bf05-cc75-4ced-9175-2aa2312f57f3"],
Cell[546834, 15605, 659, 14, 20, "Print",ExpressionUUID->"be4ca7e9-8854-48f1-b792-7e6a657b2a2e"],
Cell[547496, 15621, 659, 14, 20, "Print",ExpressionUUID->"f68c71dc-156f-46c7-9023-7dde78542c20"],
Cell[548158, 15637, 659, 14, 20, "Print",ExpressionUUID->"08d881b8-f7a3-416d-ac5f-fe9401f82376"],
Cell[548820, 15653, 659, 14, 20, "Print",ExpressionUUID->"7f21b458-eab9-48bc-a731-7405e168a221"],
Cell[549482, 15669, 659, 14, 20, "Print",ExpressionUUID->"9f6277ff-d387-453c-aa87-53408ec65da8"],
Cell[550144, 15685, 661, 14, 20, "Print",ExpressionUUID->"3c165d22-889f-4733-9025-b59c6770e3af"],
Cell[550808, 15701, 661, 14, 20, "Print",ExpressionUUID->"ea738360-3d70-4cf9-b908-3b0e565cca06"],
Cell[551472, 15717, 661, 14, 20, "Print",ExpressionUUID->"1a4f9795-e5aa-42fb-a034-3e25d402dff4"],
Cell[552136, 15733, 661, 14, 20, "Print",ExpressionUUID->"7555b455-94b3-40a4-abc7-5f5000533962"],
Cell[552800, 15749, 661, 14, 20, "Print",ExpressionUUID->"a4c360d3-8afb-49ab-8d6b-d3df471baabc"],
Cell[553464, 15765, 661, 14, 20, "Print",ExpressionUUID->"8abd07c9-e32b-4096-b0df-fa93fe676991"],
Cell[554128, 15781, 661, 14, 20, "Print",ExpressionUUID->"2912c7d3-bac1-4d82-8b96-e493e759887b"],
Cell[554792, 15797, 661, 14, 20, "Print",ExpressionUUID->"0a36f418-2d71-447e-842d-cfc7d7106bb0"],
Cell[555456, 15813, 663, 14, 20, "Print",ExpressionUUID->"1083bfa2-1bac-4374-a82c-4bd0824d7a5d"],
Cell[556122, 15829, 663, 14, 20, "Print",ExpressionUUID->"13cea854-0854-46f7-b4ba-a155a358a261"],
Cell[556788, 15845, 663, 14, 20, "Print",ExpressionUUID->"b4b5159d-552e-4808-9dbb-b216fc5a4e1d"],
Cell[557454, 15861, 663, 14, 20, "Print",ExpressionUUID->"3a33d2ab-7985-4800-b901-d259fdde9cc3"],
Cell[558120, 15877, 663, 14, 20, "Print",ExpressionUUID->"c23af089-1c98-4d79-a81d-99ab6485800d"],
Cell[558786, 15893, 663, 14, 20, "Print",ExpressionUUID->"ffa9e9a1-50ab-46e5-b2d2-d1a093d7b522"],
Cell[559452, 15909, 663, 14, 20, "Print",ExpressionUUID->"416fa9ad-b42f-42ae-a8b3-55d04c181edd"],
Cell[560118, 15925, 663, 14, 20, "Print",ExpressionUUID->"804ae60d-8e66-449c-afb9-f3aab381325c"],
Cell[560784, 15941, 663, 14, 20, "Print",ExpressionUUID->"963e5b81-603e-4f3a-95f0-ab31c7dd9398"],
Cell[561450, 15957, 663, 14, 20, "Print",ExpressionUUID->"175ec45f-e5e0-4336-9262-87f2e7c004f9"],
Cell[562116, 15973, 663, 14, 20, "Print",ExpressionUUID->"ba8b5970-f5a3-4a3c-9f51-44a4bf1495b2"],
Cell[562782, 15989, 663, 14, 20, "Print",ExpressionUUID->"9a6b89ad-74ae-4bac-a8b9-03c97a064d7e"],
Cell[563448, 16005, 687, 16, 20, "Print",ExpressionUUID->"30d7eabf-dda6-4ab9-95b6-904dffed2f66"],
Cell[564138, 16023, 687, 16, 20, "Print",ExpressionUUID->"39e42763-41f0-4963-8293-2b2620ddc99c"],
Cell[564828, 16041, 687, 16, 20, "Print",ExpressionUUID->"45e757ac-5613-4812-a543-6c9fb247bea9"],
Cell[565518, 16059, 687, 16, 20, "Print",ExpressionUUID->"ff24cf5c-8b7a-4100-a42e-0cf563beb945"],
Cell[566208, 16077, 689, 16, 20, "Print",ExpressionUUID->"906ed593-3f15-47fb-8340-06fc6aaf454c"],
Cell[566900, 16095, 689, 16, 20, "Print",ExpressionUUID->"77aa19ba-d53b-4a9b-bb32-f9ebb840bf06"],
Cell[567592, 16113, 689, 16, 20, "Print",ExpressionUUID->"4bf41b1c-039a-4b61-8b01-a3560b8ed1b2"],
Cell[568284, 16131, 689, 16, 20, "Print",ExpressionUUID->"b4d9257b-5910-4307-8ac3-85526a86033b"],
Cell[568976, 16149, 689, 16, 20, "Print",ExpressionUUID->"cd437c3f-65b3-4597-9b03-b51936a73a32"],
Cell[569668, 16167, 689, 16, 20, "Print",ExpressionUUID->"288630be-d36a-40db-a668-d5a5b19cb347"],
Cell[570360, 16185, 689, 16, 20, "Print",ExpressionUUID->"96bb96bc-a940-49cc-96f3-3f5fd20f7ac0"],
Cell[571052, 16203, 689, 16, 20, "Print",ExpressionUUID->"c5eee1e8-168e-4caa-9ca1-bd654a7481d2"],
Cell[571744, 16221, 691, 16, 20, "Print",ExpressionUUID->"4d959a07-9375-47af-be2f-f42e6888e918"],
Cell[572438, 16239, 691, 16, 20, "Print",ExpressionUUID->"da73022e-e031-4e2e-900c-646582d368aa"],
Cell[573132, 16257, 691, 16, 20, "Print",ExpressionUUID->"f13817b8-288f-4fe8-a6bc-ea61de77af5d"],
Cell[573826, 16275, 691, 16, 20, "Print",ExpressionUUID->"a248f03a-5fdc-445d-a4dc-a5f76de599e7"],
Cell[574520, 16293, 691, 16, 20, "Print",ExpressionUUID->"907fdbda-4392-4d75-a806-4829ff36f00f"],
Cell[575214, 16311, 691, 16, 20, "Print",ExpressionUUID->"a4fa9d59-7239-4fed-b3b2-c0912d4523c0"],
Cell[575908, 16329, 691, 16, 20, "Print",ExpressionUUID->"8e5b8c9e-5b37-4d0f-8119-28746cecce32"],
Cell[576602, 16347, 691, 16, 20, "Print",ExpressionUUID->"d8b2de50-162d-4899-8681-a5f214ba2464"],
Cell[577296, 16365, 691, 16, 20, "Print",ExpressionUUID->"b51e6466-5511-414d-a53a-dbff91d1f423"],
Cell[577990, 16383, 691, 16, 20, "Print",ExpressionUUID->"1f6426c1-49c5-4f16-b16e-367139b3d0fb"],
Cell[578684, 16401, 691, 16, 20, "Print",ExpressionUUID->"cf660a6b-9c12-4314-8752-1c549622ba00"],
Cell[579378, 16419, 691, 16, 20, "Print",ExpressionUUID->"2578ab4d-debc-4982-8003-243ef51572e4"],
Cell[580072, 16437, 663, 14, 20, "Print",ExpressionUUID->"6b59e007-59b6-4ac6-941e-c108a8763dcb"],
Cell[580738, 16453, 663, 14, 20, "Print",ExpressionUUID->"40631057-4e57-4f40-aec3-ff385fbaf167"],
Cell[581404, 16469, 691, 16, 20, "Print",ExpressionUUID->"70bed940-ff70-4b9d-bbb2-dbf95c75f9cb"],
Cell[582098, 16487, 665, 14, 20, "Print",ExpressionUUID->"573ea414-741a-4202-8f5e-b2d16848f93b"],
Cell[582766, 16503, 665, 14, 20, "Print",ExpressionUUID->"dbdea3d2-8bc2-4c4c-a9f7-3615409bab5a"],
Cell[583434, 16519, 693, 16, 20, "Print",ExpressionUUID->"30fb8391-5edb-481c-931c-f6120952d30b"],
Cell[584130, 16537, 424, 12, 24, "Output",ExpressionUUID->"9de5771f-1580-4c86-bf9f-44edf9541e0a"]
}, Open  ]],
Cell[584569, 16552, 204, 3, 36, "MathCaption",ExpressionUUID->"c25bca1b-ddaa-4bdd-a7ea-8365c92eb0c5"],
Cell[CellGroupData[{
Cell[584798, 16559, 898, 25, 41, "Input",ExpressionUUID->"d1a2ab22-859d-4fef-8adc-dd79e89d8725"],
Cell[585699, 16586, 485, 11, 20, "Print",ExpressionUUID->"b710cf10-f523-4b15-8b44-f75717903d7d"],
Cell[586187, 16599, 382, 8, 20, "Print",ExpressionUUID->"3fe9e1da-7a56-4eef-a3b0-4879359e6f32"],
Cell[586572, 16609, 390, 9, 20, "Print",ExpressionUUID->"a7c5fd71-db8d-46f2-b459-a562268b2376"],
Cell[586965, 16620, 323, 10, 24, "Output",ExpressionUUID->"54ff1c9a-1c3e-4d04-b548-f42121dd715d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[587325, 16635, 227, 6, 25, "Input",ExpressionUUID->"e498508c-f8f9-4d49-9214-dafe1ac9b37d"],
Cell[587555, 16643, 328, 9, 24, "Output",ExpressionUUID->"fd3e373e-24e4-4d69-9c37-dcf40db490de"]
}, Open  ]],
Cell[CellGroupData[{
Cell[587920, 16657, 844, 24, 41, "Input",ExpressionUUID->"b7e79e6d-5ca6-4a7a-a10d-503b28b3fd25"],
Cell[588767, 16683, 328, 9, 24, "Output",ExpressionUUID->"1b0dafb2-f3ba-4f7c-a920-83f3e8a8546e"]
}, Open  ]],
Cell[589110, 16695, 303, 4, 49, "MathCaption",ExpressionUUID->"f20841c6-cdcf-4a6f-8bbf-e2c0ba296de2"],
Cell[CellGroupData[{
Cell[589438, 16703, 2038, 53, 168, "Input",ExpressionUUID->"57d26a9a-876f-46b1-b2bb-9904157558e1",
 Evaluatable->False],
Cell[591479, 16758, 655, 14, 20, "Print",ExpressionUUID->"a5b78caf-d02e-4ec7-aea5-84e71bddf45b"],
Cell[592137, 16774, 655, 14, 20, "Print",ExpressionUUID->"53c82e08-f440-4ef0-a646-0b29f15a614e"],
Cell[592795, 16790, 657, 14, 20, "Print",ExpressionUUID->"d3ed6b74-a310-45bd-bd1d-45f3da4b77e7"],
Cell[593455, 16806, 657, 14, 20, "Print",ExpressionUUID->"5a4b82aa-be8d-45ee-843a-a37e8492404e"],
Cell[594115, 16822, 657, 14, 20, "Print",ExpressionUUID->"10af3743-dff8-4343-bd4d-8a3e9070e868"],
Cell[594775, 16838, 657, 14, 20, "Print",ExpressionUUID->"ba5adb18-c3b9-4c0c-b3af-999b0ab23165"],
Cell[595435, 16854, 657, 14, 20, "Print",ExpressionUUID->"79b63931-e0aa-4d4d-8be3-1f74a213d155"],
Cell[596095, 16870, 657, 14, 20, "Print",ExpressionUUID->"922e9751-7e0d-4ad0-b1ab-018b2b940c1c"],
Cell[596755, 16886, 657, 14, 20, "Print",ExpressionUUID->"1ad3a93e-9aae-4001-a33e-2f4039ba6690"],
Cell[597415, 16902, 657, 14, 20, "Print",ExpressionUUID->"21ea07aa-bae4-41d7-8e66-3adff85ab877"],
Cell[598075, 16918, 657, 14, 20, "Print",ExpressionUUID->"4b87181d-d6de-4202-9eb4-b5dee1ad59d2"],
Cell[598735, 16934, 657, 14, 20, "Print",ExpressionUUID->"5aed7d11-1f60-4d00-91a2-656784a53d65"],
Cell[599395, 16950, 657, 14, 20, "Print",ExpressionUUID->"627fabac-90f7-4e18-8a69-d07f627437c9"],
Cell[600055, 16966, 659, 14, 20, "Print",ExpressionUUID->"271775ef-551b-4245-af55-7de01b86cfd4"],
Cell[600717, 16982, 659, 14, 20, "Print",ExpressionUUID->"3f46a84c-2b0d-4db0-b017-789cd36ee71f"],
Cell[601379, 16998, 659, 14, 20, "Print",ExpressionUUID->"58cd3138-656d-41c6-9f63-684b3c52f0b8"],
Cell[602041, 17014, 659, 14, 20, "Print",ExpressionUUID->"20c45b96-8109-4f30-8b99-86f76d539878"],
Cell[602703, 17030, 659, 14, 20, "Print",ExpressionUUID->"0402a020-bef3-4a07-b6c6-1c082e46ed87"],
Cell[603365, 17046, 659, 14, 20, "Print",ExpressionUUID->"9505d6d2-a82b-4eb5-aa8b-f0f52df1c891"],
Cell[604027, 17062, 659, 14, 20, "Print",ExpressionUUID->"d64d073f-247e-4722-bacf-8220b752ce1f"],
Cell[604689, 17078, 659, 14, 20, "Print",ExpressionUUID->"66ca6f56-8fa7-4a10-aace-3fd5de3ec34c"],
Cell[605351, 17094, 659, 14, 20, "Print",ExpressionUUID->"ccf7325c-b23a-4f61-ba6a-c281618aa7b2"],
Cell[606013, 17110, 659, 14, 20, "Print",ExpressionUUID->"c991b571-fa64-4e23-8915-7436f877a68a"],
Cell[606675, 17126, 659, 14, 20, "Print",ExpressionUUID->"ed46a29c-62c5-49e5-9652-57722bb7c9db"],
Cell[607337, 17142, 661, 14, 20, "Print",ExpressionUUID->"eec91b51-f92d-4687-93fe-2d5a90271964"],
Cell[608001, 17158, 661, 14, 20, "Print",ExpressionUUID->"68ac73cc-1ff8-4f98-95df-accfa07d5c99"],
Cell[608665, 17174, 661, 14, 20, "Print",ExpressionUUID->"b7f84d82-de01-48b5-beb7-b4b975a51372"],
Cell[609329, 17190, 661, 14, 20, "Print",ExpressionUUID->"5e485d32-acee-48d3-9bdb-1ff9d7981e46"],
Cell[609993, 17206, 661, 14, 20, "Print",ExpressionUUID->"86ae7c5a-15d4-4c09-995c-ab0203114b08"],
Cell[610657, 17222, 661, 14, 20, "Print",ExpressionUUID->"60770844-1a4c-4122-815e-f32b8f60892d"],
Cell[611321, 17238, 661, 14, 20, "Print",ExpressionUUID->"0567334c-5318-4365-b576-07c5bbc8b794"],
Cell[611985, 17254, 661, 14, 20, "Print",ExpressionUUID->"bf811118-b861-4e9d-94b0-33b411058fb1"],
Cell[612649, 17270, 661, 14, 20, "Print",ExpressionUUID->"75aad003-7bbb-4c3d-a1e9-8ca92186e5d5"],
Cell[613313, 17286, 661, 14, 20, "Print",ExpressionUUID->"029a07c0-7a5f-479a-90d3-0e9948a7ee0c"],
Cell[613977, 17302, 661, 14, 20, "Print",ExpressionUUID->"bde9f774-9621-48e0-935c-6d94445e41a5"],
Cell[614641, 17318, 661, 14, 20, "Print",ExpressionUUID->"25304f3c-c087-4cb5-b92e-522fd780804d"],
Cell[615305, 17334, 661, 14, 20, "Print",ExpressionUUID->"1611689e-5fbd-459e-8f8f-0bd85f991929"],
Cell[615969, 17350, 661, 14, 20, "Print",ExpressionUUID->"fc0044d8-7675-4d1b-8d2f-536c708bec09"],
Cell[616633, 17366, 661, 14, 20, "Print",ExpressionUUID->"a02ba323-5431-4dc3-925c-3f2be2eebe5f"],
Cell[617297, 17382, 661, 14, 20, "Print",ExpressionUUID->"64c10f77-6e8f-489b-9e64-063247cd6226"],
Cell[617961, 17398, 661, 14, 20, "Print",ExpressionUUID->"cec4c06c-925b-4c54-aea1-5d9f09375170"],
Cell[618625, 17414, 661, 14, 20, "Print",ExpressionUUID->"ddaa5764-666f-47f0-abe8-7fc452fe32c3"],
Cell[619289, 17430, 661, 14, 20, "Print",ExpressionUUID->"453098d0-a810-491d-ba93-e454792e416b"],
Cell[619953, 17446, 661, 14, 20, "Print",ExpressionUUID->"58e65d2d-8e75-4d73-bba7-9c9f79214865"],
Cell[620617, 17462, 661, 14, 20, "Print",ExpressionUUID->"ba9e2876-f59b-4e32-a97e-43fb79253b11"],
Cell[621281, 17478, 661, 14, 20, "Print",ExpressionUUID->"fc2d28af-2ae4-402a-bf67-20606f08aa3d"],
Cell[621945, 17494, 661, 14, 20, "Print",ExpressionUUID->"080217ab-5683-43da-a359-c0aa83c55909"],
Cell[622609, 17510, 661, 14, 20, "Print",ExpressionUUID->"b6d65cf2-185a-4c19-8a0c-bf5dbb1f9c99"],
Cell[623273, 17526, 661, 14, 20, "Print",ExpressionUUID->"94214897-e5cc-4d4b-bb11-dc7e0df34866"],
Cell[623937, 17542, 661, 14, 20, "Print",ExpressionUUID->"d6193336-e1d8-43da-9fcd-2972ae60d4b6"],
Cell[624601, 17558, 661, 14, 20, "Print",ExpressionUUID->"e968f378-f560-482e-bf63-dc11d93c9c38"],
Cell[625265, 17574, 661, 14, 20, "Print",ExpressionUUID->"ed032ee9-27cf-43ac-8d7f-692f83fdbbe4"],
Cell[625929, 17590, 661, 14, 20, "Print",ExpressionUUID->"bcd23380-6e55-4274-a3ad-a7fedeab99db"],
Cell[626593, 17606, 661, 14, 20, "Print",ExpressionUUID->"8b26fee5-bf30-4d5d-9144-858a1e41d1e1"],
Cell[627257, 17622, 661, 14, 20, "Print",ExpressionUUID->"20ffc308-e681-408f-aae3-e273271e0983"],
Cell[627921, 17638, 661, 14, 20, "Print",ExpressionUUID->"d5c0801c-7c32-4f72-be79-9e115774fed1"],
Cell[628585, 17654, 661, 14, 20, "Print",ExpressionUUID->"c382016f-949b-4bba-8887-67a3c9f53a5f"],
Cell[629249, 17670, 661, 14, 20, "Print",ExpressionUUID->"62aed591-a17a-4913-ae93-4b15630bf935"],
Cell[629913, 17686, 661, 14, 20, "Print",ExpressionUUID->"bfd087f8-505b-434e-906d-eab69208d8bf"],
Cell[630577, 17702, 683, 16, 20, "Print",ExpressionUUID->"0fb54525-9bd3-4b2b-8700-7c7ea5120d91"],
Cell[631263, 17720, 683, 16, 20, "Print",ExpressionUUID->"afe4b49b-b604-4c6e-9296-6ccf0ef3ecd7"],
Cell[631949, 17738, 683, 16, 20, "Print",ExpressionUUID->"2728e7e1-560a-471f-96bb-f439137d895a"],
Cell[632635, 17756, 685, 16, 20, "Print",ExpressionUUID->"5da2c369-a60a-4fac-b286-c3d1b9d9eaa5"],
Cell[633323, 17774, 685, 16, 20, "Print",ExpressionUUID->"c3a50f30-f471-40f0-820a-aaa95547b394"],
Cell[634011, 17792, 685, 16, 20, "Print",ExpressionUUID->"d0e26858-2664-4481-8206-ef5bd7019990"],
Cell[634699, 17810, 685, 16, 20, "Print",ExpressionUUID->"157423e6-a565-4442-ae60-8945c6488cbd"],
Cell[635387, 17828, 685, 16, 20, "Print",ExpressionUUID->"e43629a4-9ac1-40fa-9a25-f57944df4d76"],
Cell[636075, 17846, 685, 16, 20, "Print",ExpressionUUID->"5a7972a2-3c80-43c1-bd6b-565121d50639"],
Cell[636763, 17864, 685, 16, 20, "Print",ExpressionUUID->"d9086629-2ce2-4103-892d-dca485f12e0c"],
Cell[637451, 17882, 685, 16, 20, "Print",ExpressionUUID->"035d0022-fa11-4c54-8142-3e2618f30154"],
Cell[638139, 17900, 685, 16, 20, "Print",ExpressionUUID->"20eb675b-1684-4aee-aacb-7680e4f056d6"],
Cell[638827, 17918, 685, 16, 20, "Print",ExpressionUUID->"98c415bc-8a77-4e1c-8cd0-d99922f8c208"],
Cell[639515, 17936, 685, 16, 20, "Print",ExpressionUUID->"2a77afdc-05c3-4109-bc8b-73a008760f92"],
Cell[640203, 17954, 687, 16, 20, "Print",ExpressionUUID->"58e23aeb-df4c-4ccc-9603-1fb7e24074d1"],
Cell[640893, 17972, 687, 16, 20, "Print",ExpressionUUID->"404c4ef4-d7fa-416e-86cd-b350902f11f2"],
Cell[641583, 17990, 687, 16, 20, "Print",ExpressionUUID->"9ea71777-df11-49bf-901b-5110139dcecb"],
Cell[642273, 18008, 687, 16, 20, "Print",ExpressionUUID->"5a89da19-3bb7-4055-b5f9-587588866540"],
Cell[642963, 18026, 687, 16, 20, "Print",ExpressionUUID->"fb9867eb-081c-433b-bff4-5945697f811e"],
Cell[643653, 18044, 687, 16, 20, "Print",ExpressionUUID->"8219a651-b654-4819-ac9e-d791124054b4"],
Cell[644343, 18062, 687, 16, 20, "Print",ExpressionUUID->"27fbf619-0f98-40fb-94af-df3a7d61529c"],
Cell[645033, 18080, 687, 16, 20, "Print",ExpressionUUID->"d3ac0d92-4b2f-4e81-9f57-ab2c65d479c2"],
Cell[645723, 18098, 687, 16, 20, "Print",ExpressionUUID->"e5f62877-1807-4844-8dcb-7dbed6eaff1f"],
Cell[646413, 18116, 687, 16, 20, "Print",ExpressionUUID->"23ed5c57-fc52-4228-a7d0-fe5256d2e2eb"],
Cell[647103, 18134, 687, 16, 20, "Print",ExpressionUUID->"eab09f46-5e4f-46e0-a8c1-7aed72f16ea1"],
Cell[647793, 18152, 689, 16, 20, "Print",ExpressionUUID->"66041728-97f6-44c9-a37d-5cb4eaa6763b"],
Cell[648485, 18170, 689, 16, 20, "Print",ExpressionUUID->"c2e884d9-c3a4-4dd4-9931-c6b48bffe3df"],
Cell[649177, 18188, 689, 16, 20, "Print",ExpressionUUID->"7f5c6812-1abf-4868-acf9-242fd33f859d"],
Cell[649869, 18206, 689, 16, 20, "Print",ExpressionUUID->"b2c2cd61-8ec6-4aff-ae1a-efc169862ab5"],
Cell[650561, 18224, 689, 16, 20, "Print",ExpressionUUID->"96aaf06d-1ae1-445c-a7f0-75b98df8eaf4"],
Cell[651253, 18242, 689, 16, 20, "Print",ExpressionUUID->"ab8807df-3afe-4996-91c5-89e5ac58dea3"],
Cell[651945, 18260, 689, 16, 20, "Print",ExpressionUUID->"0bd8d6c1-ea64-4bff-9c6a-323fa7bafe62"],
Cell[652637, 18278, 689, 16, 20, "Print",ExpressionUUID->"06168a18-36ee-46ad-902b-1b8308818bd4"],
Cell[653329, 18296, 689, 16, 20, "Print",ExpressionUUID->"84132d52-03ff-4421-be4c-0740b5269816"],
Cell[654021, 18314, 689, 16, 20, "Print",ExpressionUUID->"8741ccde-1508-40ad-8a88-cf0ec7c20f43"],
Cell[654713, 18332, 689, 16, 20, "Print",ExpressionUUID->"d9d54674-792e-4252-ad72-19c0f833fca3"],
Cell[655405, 18350, 689, 16, 20, "Print",ExpressionUUID->"e9441f0c-31fe-4930-913c-fbff5ef64582"],
Cell[656097, 18368, 689, 16, 20, "Print",ExpressionUUID->"00c7cd21-7226-417d-a0a9-56dd20638a86"],
Cell[656789, 18386, 689, 16, 20, "Print",ExpressionUUID->"faa04311-2eb8-4fa0-ab24-2357f1c47590"],
Cell[657481, 18404, 689, 16, 20, "Print",ExpressionUUID->"b8b05b7c-79db-476d-ac1f-29a955f4e5b7"],
Cell[658173, 18422, 689, 16, 20, "Print",ExpressionUUID->"8f06ce99-8f84-4358-86a0-e4706096af19"],
Cell[658865, 18440, 689, 16, 20, "Print",ExpressionUUID->"e1d8cff1-c061-4364-aa33-ac230ef7e589"],
Cell[659557, 18458, 689, 16, 20, "Print",ExpressionUUID->"56b6aa31-ffd7-4991-96ea-474ae22fdebc"],
Cell[660249, 18476, 689, 16, 20, "Print",ExpressionUUID->"4330e4de-e98e-4c36-b7f0-5b93c2950724"],
Cell[660941, 18494, 689, 16, 20, "Print",ExpressionUUID->"f3c05e13-0766-4fd3-95bb-ac5496b1e53f"],
Cell[661633, 18512, 689, 16, 20, "Print",ExpressionUUID->"c4920958-13ed-4c41-afe3-c2a8967bcf36"],
Cell[662325, 18530, 689, 16, 20, "Print",ExpressionUUID->"63466ba6-03dd-4906-8964-7c260f255369"],
Cell[663017, 18548, 689, 16, 20, "Print",ExpressionUUID->"9349aad4-4e86-4ae4-be54-6d142e01756f"],
Cell[663709, 18566, 689, 16, 20, "Print",ExpressionUUID->"7eead643-1260-4861-aa4d-b568ab5fe653"],
Cell[664401, 18584, 689, 16, 20, "Print",ExpressionUUID->"e22731d0-3c4a-4d30-8b74-09a83ba30346"],
Cell[665093, 18602, 689, 16, 20, "Print",ExpressionUUID->"7af477b5-8d34-4b17-97d0-cd952cf924bf"],
Cell[665785, 18620, 689, 16, 20, "Print",ExpressionUUID->"3ef0fe73-6e01-4b65-87b0-94987a34b8ae"],
Cell[666477, 18638, 689, 16, 20, "Print",ExpressionUUID->"8164c638-3b36-44cf-8f5b-9d937b7cd8de"],
Cell[667169, 18656, 689, 16, 20, "Print",ExpressionUUID->"52274af2-90b5-4b07-8fe7-c3d030e72fb4"],
Cell[667861, 18674, 689, 16, 20, "Print",ExpressionUUID->"35362014-940c-4cff-b841-2bbadcf33ff1"],
Cell[668553, 18692, 689, 16, 20, "Print",ExpressionUUID->"fbcc06b1-78df-440d-96bc-6870bd22c280"],
Cell[669245, 18710, 689, 16, 20, "Print",ExpressionUUID->"628b89b0-8319-43bd-9556-1fb5910abc4a"],
Cell[669937, 18728, 689, 16, 20, "Print",ExpressionUUID->"689e6638-77ad-4fda-80c3-fa48b76b0a0b"],
Cell[670629, 18746, 689, 16, 20, "Print",ExpressionUUID->"ce780f8c-3813-470d-9bb8-76bfc122eeb3"],
Cell[671321, 18764, 689, 16, 20, "Print",ExpressionUUID->"6f3813b0-29a8-44c1-80cb-f9c8013bc6b5"],
Cell[672013, 18782, 661, 14, 20, "Print",ExpressionUUID->"8ed26a27-9cab-4794-9958-610bf2a2bb66"],
Cell[672677, 18798, 691, 16, 20, "Print",ExpressionUUID->"992c8a28-e5dc-4e1c-862c-8f3dfe76a913"],
Cell[673371, 18816, 657, 14, 20, "Print",ExpressionUUID->"f78d7696-c120-4b3a-8b25-57298e350f68"],
Cell[674031, 18832, 657, 14, 20, "Print",ExpressionUUID->"86700af1-d0cd-4c2d-aca8-30d9be34cdb1"],
Cell[674691, 18848, 657, 14, 20, "Print",ExpressionUUID->"022fad44-553a-49a1-b143-a22f79dca231"],
Cell[675351, 18864, 659, 14, 20, "Print",ExpressionUUID->"f2fde46d-3a66-49a6-86a3-dfbd13ee6f9d"],
Cell[676013, 18880, 659, 14, 20, "Print",ExpressionUUID->"9367cd96-8428-499f-9fdb-6bc08750af2f"],
Cell[676675, 18896, 659, 14, 20, "Print",ExpressionUUID->"e4ff66e9-a70d-485a-81c7-f54411bfc438"],
Cell[677337, 18912, 659, 14, 20, "Print",ExpressionUUID->"2a5bec36-5cc4-4f76-a086-63bc191d93c1"],
Cell[677999, 18928, 659, 14, 20, "Print",ExpressionUUID->"86dac42f-50ac-405c-9497-76ca721d1522"],
Cell[678661, 18944, 659, 14, 20, "Print",ExpressionUUID->"757ec900-3c4e-4fd6-8376-e505e017af25"],
Cell[679323, 18960, 659, 14, 20, "Print",ExpressionUUID->"b4887bcb-3d3a-401b-af2f-3079e0c2d3c4"],
Cell[679985, 18976, 659, 14, 20, "Print",ExpressionUUID->"4457f3f9-142e-4966-b3e4-f06d4ae1a54c"],
Cell[680647, 18992, 659, 14, 20, "Print",ExpressionUUID->"d36846e8-a66b-44c1-99b0-2bd864c8079b"],
Cell[681309, 19008, 659, 14, 20, "Print",ExpressionUUID->"feed1df5-fcf4-4c68-9809-4d9fc3f40701"],
Cell[681971, 19024, 659, 14, 20, "Print",ExpressionUUID->"6e80ea38-9d36-45c7-afa5-784e1596fd69"],
Cell[682633, 19040, 659, 14, 20, "Print",ExpressionUUID->"46053d05-0af0-48b9-b8ea-d990c63ed4b6"],
Cell[683295, 19056, 659, 14, 20, "Print",ExpressionUUID->"747ee0eb-9566-4995-973d-8af707c8d1c7"],
Cell[683957, 19072, 661, 14, 20, "Print",ExpressionUUID->"e62206cb-cff1-40e1-9f22-a3f6cb011e21"],
Cell[684621, 19088, 661, 14, 20, "Print",ExpressionUUID->"bca4a601-887a-4512-9713-b385f3377ba3"],
Cell[685285, 19104, 661, 14, 20, "Print",ExpressionUUID->"0156ac4c-5fd1-42f3-94a0-81e7f458d843"],
Cell[685949, 19120, 661, 14, 20, "Print",ExpressionUUID->"6b893e11-c5e4-476c-ac62-28a9873342f4"],
Cell[686613, 19136, 661, 14, 20, "Print",ExpressionUUID->"4668a91c-ee1e-4002-bbaf-4663b6cf7d3d"],
Cell[687277, 19152, 661, 14, 20, "Print",ExpressionUUID->"f5a19231-97cb-4de0-ab9b-0a217f000766"],
Cell[687941, 19168, 663, 14, 20, "Print",ExpressionUUID->"b182f76a-ee47-44a7-8b59-69630199d836"],
Cell[688607, 19184, 663, 14, 20, "Print",ExpressionUUID->"4ca5cb9e-9ae5-40a5-aafb-6bef67e632a3"],
Cell[689273, 19200, 663, 14, 20, "Print",ExpressionUUID->"80f176c5-5f13-4931-a49e-f366b69039f9"],
Cell[689939, 19216, 663, 14, 20, "Print",ExpressionUUID->"695effaf-7a58-4839-988e-5b4a65f49cc9"],
Cell[690605, 19232, 663, 14, 20, "Print",ExpressionUUID->"c466f69a-f7d3-42cd-92fb-d063a8d11cf1"],
Cell[691271, 19248, 663, 14, 20, "Print",ExpressionUUID->"04e5e79c-2979-4ab8-8e38-ae7c898993d4"],
Cell[691937, 19264, 663, 14, 20, "Print",ExpressionUUID->"96c183bf-1409-4bee-95e7-f73f83a0c8a3"],
Cell[692603, 19280, 663, 14, 20, "Print",ExpressionUUID->"9a2a3101-935d-40a8-bfd4-bec1c624b48b"],
Cell[693269, 19296, 663, 14, 20, "Print",ExpressionUUID->"ad7f8c37-b541-44a2-adb6-ebdf5f90fe16"],
Cell[693935, 19312, 663, 14, 20, "Print",ExpressionUUID->"9ca16481-e5a6-449b-a89b-14a932ae9fdc"],
Cell[694601, 19328, 663, 14, 20, "Print",ExpressionUUID->"47ec38f6-5d9a-42ad-8c04-88bbc51be69f"],
Cell[695267, 19344, 663, 14, 20, "Print",ExpressionUUID->"fe2fac16-cb5e-4bc8-967f-bde288c547b9"],
Cell[695933, 19360, 663, 14, 20, "Print",ExpressionUUID->"80724425-7dd6-409f-a1a6-9b707aa320b7"],
Cell[696599, 19376, 663, 14, 20, "Print",ExpressionUUID->"fcc871d2-b4ef-42f1-b5ba-2bd2b9e96d96"],
Cell[697265, 19392, 687, 16, 20, "Print",ExpressionUUID->"960496c8-0d83-4ca0-be7d-b4f77786f5ea"],
Cell[697955, 19410, 687, 16, 20, "Print",ExpressionUUID->"fad0c8b4-9e82-4985-8151-1a3dd7484207"],
Cell[698645, 19428, 687, 16, 20, "Print",ExpressionUUID->"b02eae82-0a1b-41d3-8987-92375697515d"],
Cell[699335, 19446, 687, 16, 20, "Print",ExpressionUUID->"17f51a4c-ba2f-4dab-8ca4-5fcccfddcae4"],
Cell[700025, 19464, 687, 16, 20, "Print",ExpressionUUID->"f024039d-6cc9-4300-a40e-17daecdbae89"],
Cell[700715, 19482, 687, 16, 20, "Print",ExpressionUUID->"2ee6bbd7-58c1-457b-8613-ea3e46b39e08"],
Cell[701405, 19500, 689, 16, 20, "Print",ExpressionUUID->"51033bad-66e4-47c9-aac0-f3b0765f4493"],
Cell[702097, 19518, 689, 16, 20, "Print",ExpressionUUID->"ce51ab72-534d-4296-a311-deae8371e8a5"],
Cell[702789, 19536, 689, 16, 20, "Print",ExpressionUUID->"74abf0f0-8daf-4bca-91d0-72540f6f2116"],
Cell[703481, 19554, 689, 16, 20, "Print",ExpressionUUID->"3dcf19e6-07d6-4f33-8def-7a589fd7988c"],
Cell[704173, 19572, 691, 16, 20, "Print",ExpressionUUID->"332331fe-630e-46db-8676-14907a196577"],
Cell[704867, 19590, 691, 16, 20, "Print",ExpressionUUID->"5798e3d1-0a8c-4a28-bdb8-5640f41280bc"],
Cell[705561, 19608, 659, 14, 20, "Print",ExpressionUUID->"5e52d878-5455-4be9-a10b-d9b27cf5e6ca"],
Cell[706223, 19624, 659, 14, 20, "Print",ExpressionUUID->"dba924e2-65cd-4434-a6aa-3a411b5eb3f3"],
Cell[706885, 19640, 659, 14, 20, "Print",ExpressionUUID->"43dcdc1c-2335-4dc0-9109-e99da0ab981a"],
Cell[707547, 19656, 661, 14, 20, "Print",ExpressionUUID->"59a91341-87af-4308-b40e-e2dda9deb6bd"],
Cell[708211, 19672, 661, 14, 20, "Print",ExpressionUUID->"1af73d1a-0fc5-415c-bfa8-01cfe32a8281"],
Cell[708875, 19688, 661, 14, 20, "Print",ExpressionUUID->"2381a1f8-da78-46a0-9bec-23d3c9855b23"],
Cell[709539, 19704, 691, 16, 20, "Print",ExpressionUUID->"a5586fde-74fd-42b4-9f5d-a7c1d2140512"],
Cell[710233, 19722, 691, 16, 20, "Print",ExpressionUUID->"bdc5be45-2581-4d06-aaa5-f9b810c71d0d"],
Cell[710927, 19740, 693, 16, 20, "Print",ExpressionUUID->"dbc4fdb2-7328-43f1-8fc3-05feaf8fd5d3"],
Cell[711623, 19758, 693, 16, 20, "Print",ExpressionUUID->"0c2f027e-84b0-468d-b2f2-2b8dbeeee7f8"],
Cell[712319, 19776, 693, 16, 20, "Print",ExpressionUUID->"a8c1e984-ec47-427b-a66f-7892a8196a67"],
Cell[713015, 19794, 423, 12, 24, "Output",ExpressionUUID->"f9c45e5f-8035-4d88-8c82-adce5b09284b"]
}, Open  ]],
Cell[713453, 19809, 584, 10, 80, "DefinitionBox",ExpressionUUID->"896a908b-0f1d-4aa9-89d5-7e3e6e5bd5ca"],
Cell[714040, 19821, 98, 0, 20, "SmallText",ExpressionUUID->"03876faf-b6af-4232-9b00-a191ea9a2e82"]
}, Closed]],
Cell[714153, 19824, 91, 0, 35, "Subsection",ExpressionUUID->"6c4aafca-9dd7-48d6-9640-ea3e6eab6dab"],
Cell[CellGroupData[{
Cell[714269, 19828, 91, 0, 25, "SubsectionIcon",ExpressionUUID->"a0b7fca0-4dc9-444a-b2d3-64ae35324918"],
Cell[714363, 19830, 191, 3, 37, "MathCaption",ExpressionUUID->"61de75c9-e107-4c49-8711-aaeb52c72758"],
Cell[CellGroupData[{
Cell[714579, 19837, 139, 3, 25, "Input",ExpressionUUID->"641322be-624a-4d94-b5af-b8cbf3d78092"],
Cell[714721, 19842, 120, 2, 23, "Output",ExpressionUUID->"06acec31-2ae2-4ce1-9d9a-40356c469aae"]
}, Open  ]],
Cell[714856, 19847, 184, 3, 37, "MathCaption",ExpressionUUID->"64b4e402-005f-4b50-acd9-4d79f10804bf"],
Cell[CellGroupData[{
Cell[715065, 19854, 201, 6, 25, "Input",ExpressionUUID->"81a47113-d3ac-49ba-aafb-2f24c48fafe1"],
Cell[715269, 19862, 122, 2, 23, "Output",ExpressionUUID->"ca04403e-23ae-4fb4-b866-5fe8f4a319ed"]
}, Open  ]],
Cell[715406, 19867, 122, 0, 37, "MathCaption",ExpressionUUID->"6ff45b8e-42ec-449d-970b-58566441dc85"],
Cell[CellGroupData[{
Cell[715553, 19871, 138, 3, 24, "Input",ExpressionUUID->"7ff14b04-22ab-4ba6-8cd6-c604561c16ae"],
Cell[715694, 19876, 16991, 455, 629, "Print",ExpressionUUID->"4044e671-0ae1-4167-98d7-72dcbcae215b"]
}, Open  ]]
}, Closed]]
}
]
*)

