(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   6873820,     185983]
NotebookOptionsPosition[   6780317,     184111]
NotebookOutlinePosition[   6785282,     184235]
CellTagsIndexPosition[   6785153,     184228]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData["Exit"], "Input",
 CellChangeTimes->{{3.7289931265364656`*^9, 3.728993127054985*^9}},
 CellLabel->"In[347]:=",
 CellID->404285871,ExpressionUUID->"3c7b2289-2b4c-41a5-9565-289b88f5e3b6"],

Cell[CellGroupData[{

Cell["xAct`xPert`", "Section",
 CellChangeTimes->{{3.7289798285097446`*^9, 3.728979830061956*^9}},
 FontSize->24,
 CellTags->{"S5.18.1", "1.1"},
 CellID->1487142718,ExpressionUUID->"103e4b2f-1354-401d-9a77-7bc2836ddbf8"],

Cell[CellGroupData[{

Cell["Authors", "Subsection",ExpressionUUID->"0fe65fb3-9ffb-4c97-8196-a0c37f2bd899"],

Cell["\[Copyright] 2005-2018, under the GNU General Public License (GPL)", \
"Text",
 CellChangeTimes->{{3.601053781650763*^9, 3.60105378282517*^9}, {
  3.728979850398628*^9, 3.7289798508209753`*^9}},
 FontFamily->"Arial",ExpressionUUID->"1a87c7e3-2494-4fd7-9442-fd3af39df5f4"],

Cell[TextData[{
 StyleBox["David Brizuela",
  FontWeight->"Bold"],
 ", david.brizuela@ehu.eus\n",
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a",
  FontWeight->"Bold"],
 ", jose@xact.es\n",
 StyleBox["Guillermo A. Mena Marug\[AAcute]n",
  FontWeight->"Bold"],
 ", mena@iem.cfmac.csic.es"
}], "Text",
 CellChangeTimes->{3.729018230660512*^9},
 CellID->1049425430,ExpressionUUID->"4a1a6f2c-c9bb-4b54-812d-585ebc84e3d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Intro", "Subsection",ExpressionUUID->"e75380b2-a75c-4d1e-b637-7ffa5283ff5d"],

Cell[TextData[{
 StyleBox["xPert`",
  FontFamily->"Courier"],
 " is a package for efficient construction and manipulation of high-order \
perturbations of the curvature tensors of a Riemannian manifold. Its main \
application is Perturbation Theory in General Relativity.\n",
 StyleBox["xPert`",
  FontFamily->"Courier"],
 " is part of the ",
 StyleBox["xAct`",
  FontFamily->"Courier"],
 " framework for Tensor Computer Algebra in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and in particular it needs the underlying package ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " for abstract tensor manipulations."
}], "Text",ExpressionUUID->"05090f72-63b4-40f6-9357-390916bbcaa9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load the package", "Subsection",ExpressionUUID->"c7acb4a4-a0e4-4a79-bf90-f4cb345ea1ac"],

Cell[CellGroupData[{

Cell[TextData[{
 "This loads the package from the default directory, for example $HOME/.",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "/Applications/xAct/ for a single-user installation under Linux. ",
 StyleBox["xTensor`", "MR"],
 " and ",
 StyleBox["xPerm` ", "MR"],
 "are automatically loaded."
}], "MathCaption",
 CellChangeTimes->{{3.728979862308568*^9, 3.728979863308855*^9}},
 CellTags->{
  "S5.18.1", "1.3"},ExpressionUUID->"e238eaf1-4a0d-4894-aae3-5d5de407da20"],

Cell[CellGroupData[{

Cell["<<xAct`xPert`", "Input",
 CellTags->"S5.18.1",
 CellLabel->"In[1]:=",ExpressionUUID->"a44c03c8-75ef-41f8-a4e9-3b9c2252c082"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139603064*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1512455577,ExpressionUUID->"f52885d9-135b-4865-b4e4-7c532ce3ff75"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139615893*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->76953100,ExpressionUUID->"5f65cc65-36bc-4093-b1f3-0fe967f5d4a8"],

Cell[BoxData["\<\"CopyRight (C) 2003-2015, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139635593*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->565596206,ExpressionUUID->"ba9344e2-7cdc-44d3-b30a-9fc3ba093c2d"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139647546*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1212812620,ExpressionUUID->"ce7fc1f4-0b57-4a26-a1f4-eefd37d5edd8"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139658256*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1974410663,ExpressionUUID->"5e040c3c-817b-4fb2-afe5-9904a94ff987"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139668817*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1002699597,ExpressionUUID->"ae2a5653-1e3a-42eb-9742-ede4bbbc6dbf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.3", ", ", {2018, 2, 28}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.7289931396796427`*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1067948770,ExpressionUUID->"4f4fcaad-5eec-4ac0-a0a0-7ac20ed3829e"],

Cell[BoxData["\<\"CopyRight (C) 2002-2018, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.72899313969061*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->346655764,ExpressionUUID->"68e6ce1a-cdae-45e6-b3fd-14bbc1bbfd0a"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139782399*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->120291237,ExpressionUUID->"33bb4bdc-9514-42d0-96af-6ce9200c5be2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPert`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2018", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xPert`  version ", "1.0.6", ", ", {2018, 2, 28}],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139794899*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->952708432,ExpressionUUID->"2b14172a-2e4a-4f54-b1a5-1bbf67669e46"],

Cell[BoxData["\<\"CopyRight (C) 2005-2018, David Brizuela, Jose M. \
Martin-Garcia and Guillermo A. Mena Marugan, under the General Public \
License.\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139806615*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->532544592,ExpressionUUID->"4af658bf-33ac-47b2-b3b0-836f03729f40"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139821206*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1912600695,ExpressionUUID->"d694d6d6-cdbe-456b-9a3d-1d6b5aba7891"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.7289931398318*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1544652569,ExpressionUUID->"97c474b3-8ac9-41e7-8ead-8f6998b5128b"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139843424*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->45918600,ExpressionUUID->"5912981b-762d-44c6-aff9-41b5a318d9cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$PrePrint", 
   "\[InvisibleSpace]", "\<\" assigned value \"\>", "\[InvisibleSpace]", 
   "ScreenDollarIndices"}],
  SequenceForm[
  "** Variable ", $PrePrint, " assigned value ", 
   xAct`xTensor`ScreenDollarIndices],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139855196*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->807280927,ExpressionUUID->"91896a71-7232-4d36-8e98-ff0bff093fc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$CovDFormat", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", 
   "\[InvisibleSpace]", "\<\"Prefix\"\>", "\[InvisibleSpace]", "\<\" to \"\>",
    "\[InvisibleSpace]", "\<\"Postfix\"\>"}],
  SequenceForm[
  "** Variable ", xAct`xTensor`$CovDFormat, " changed from ", "Prefix", 
   " to ", "Postfix"],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139863812*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->168858343,ExpressionUUID->"d238b700-dc25-4923-864d-997ae8b0f4e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139872451*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1176273114,ExpressionUUID->"0ccc3328-dad2-4185-98da-0d22b19383d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "MetricOn", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "MakeRule", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "None",
    "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "All"}],
  SequenceForm[
  "** Option ", xAct`xTensor`MetricOn, " of ", xAct`xTensor`MakeRule, 
   " changed from ", None, " to ", All],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.7289931398809*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->2035256363,ExpressionUUID->"e5a416a2-71ac-4f6b-b1a4-2e278138925f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "ContractMetrics", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "MakeRule", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`ContractMetrics, " of ", xAct`xTensor`MakeRule, 
   " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289798734651318`*^9, 3.728980439768797*^9, 
  3.728980806469676*^9, 3.728981099473596*^9, 3.728993139889192*^9},
 CellTags->"S5.18.1",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1434163525,ExpressionUUID->"30e8b68d-37bf-42ea-a8e1-832309a90592"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The default options of ",
 StyleBox["MakeRule",
  FontFamily->"Courier"],
 " and ",
 StyleBox["ContractMetric",
  FontFamily->"Courier"],
 " have been changed:"
}], "MathCaption",ExpressionUUID->"9864c9e2-1358-4066-a132-3718411ae3f7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "MakeRule", "]"}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"611f2bfd-096b-4585-a5b9-8a41e59d5aec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PatternIndices", "\[Rule]", "All"}], ",", 
   RowBox[{"TestIndices", "\[Rule]", "True"}], ",", 
   RowBox[{"MetricOn", "\[Rule]", "All"}], ",", 
   RowBox[{"UseSymmetries", "\[Rule]", "True"}], ",", 
   RowBox[{"Verbose", "\[Rule]", "False"}], ",", 
   RowBox[{"ContractMetrics", "\[Rule]", "True"}], ",", 
   RowBox[{"Evaluate", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728979888040847*^9, 3.728980440335247*^9, 
  3.728980806995476*^9, 3.728981100048821*^9, 3.7289931401040277`*^9},
 CellLabel->"Out[2]=",
 CellID->629910747,ExpressionUUID->"082d9477-303e-4012-b85a-b6d753405af0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "ContractMetric", "]"}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"9b44e45d-0b20-475f-9770-183bfed4e19a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AllowUpperDerivatives", "\[Rule]", "True"}], ",", 
   RowBox[{"OverDerivatives", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7289798907567472`*^9, 3.7289804404701853`*^9, 
  3.7289808074648123`*^9, 3.728981100182184*^9, 3.728993140554443*^9},
 CellLabel->"Out[3]=",
 CellID->1963028766,ExpressionUUID->"00b628ca-e842-4572-9e50-390b07a47b95"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We also load the timing package and lower its default threshold of 1 second \
to 0.1 seconds\
\>", "MathCaption",ExpressionUUID->"ffb4b4af-1845-4d07-b123-9205f42ffcda"],

Cell[BoxData[
 RowBox[{"<<", "xAct`ShowTime1`"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"8c3a5b0e-722b-490e-9689-ad4e5ff0df2d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$ShowTimeThreshold", "=", "0.1"}], ";"}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"874d92b2-5224-46d7-91c4-9a32263c5afc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We define a function to collect and canonicalize equal-order terms:\
\>", "MathCaption",ExpressionUUID->"d5fc1c8b-2bea-4ed3-9c70-0937d84d2a59"],

Cell[BoxData[
 RowBox[{
  RowBox[{"org", "[", "expr_", "]"}], ":=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"ContractMetric", "[", "expr", "]"}], ",", 
    "$PerturbationParameter", ",", "ToCanonical"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"4b660671-40b4-423c-bb04-d206bb68d4aa"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["0. Set up", "Section",ExpressionUUID->"85613ade-2f0d-474f-b3b4-074dae2fdb6b"],

Cell[TextData[{
 StyleBox["xPert`",
  FontFamily->"Courier"],
 "  has been built on ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 "  and shares its notation. Then, a session with ",
 StyleBox["xPert`",
  FontFamily->"Courier"],
 " begins just like one with ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", defining one or more manifolds and vector bundles and the objects living \
on them:"
}], "Text",ExpressionUUID->"f326be3f-8fa2-4875-8214-5ec9ece8b310"],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a 4d manifold ",
 StyleBox["M",
  FontFamily->"Courier"],
 ". Note that most of the results will not depend on the chosen dimension."
}], "MathCaption",ExpressionUUID->"58dbc8a3-bb23-451d-bf97-499157200f65"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"42e2c6db-fe78-406c-83f3-c4791699344b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979903265436*^9, 3.72898044087015*^9, 
  3.728980807828395*^9, 3.728981100533153*^9},
 CellLabel->"During evaluation of In[7]:=",
 CellID->799290875,ExpressionUUID->"27641990-751b-4654-ab9f-b1230771848f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979903265436*^9, 3.72898044087015*^9, 
  3.728980807828395*^9, 3.728981100547739*^9},
 CellLabel->"During evaluation of In[7]:=",
 CellID->1171524140,ExpressionUUID->"e86361d0-54c9-43c7-a122-3bc81aadfad0"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "We also define a metric on this manifold, with negative determinant and \
associated covariant derivative ",
 StyleBox["CD",
  FontFamily->"Courier"],
 ". This derivative is extended to act on tensor densities defined using the \
determinant of the metric ",
 StyleBox["g",
  FontFamily->"Courier"],
 " in the basis ",
 StyleBox["AIndex",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"f3642770-20aa-4b4a-a5be-7c1c55d0e3e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<D\>\""}], "}"}], ",", 
   RowBox[{"WeightedWithBasis", "\[Rule]", "AIndex"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"81d951d3-244f-4797-be32-312eded9a24d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101380692*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1676145284,ExpressionUUID->"05075244-bc7c-419f-8ed4-1c22aa85f32a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101390902*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->283306842,ExpressionUUID->"3e7af814-dca1-4896-8995-28bf6510fe6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.7289811014029007`*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->566848095,ExpressionUUID->"de90355f-2ce4-448b-ba57-1f23fe40e5fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101414289*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->778474573,ExpressionUUID->"c481b71b-47c1-4ad4-9aa7-93d090c3f89c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.7289811014260283`*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1351770887,ExpressionUUID->"36fa036c-1e2d-47ee-af25-371f05200ba1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101438696*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->983796196,ExpressionUUID->"eafef483-b1b9-454f-8d97-15ac86447339"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101451413*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1186067919,ExpressionUUID->"e2ec9ecb-bfdb-4e6b-8340-3dacdb89f35d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101463125*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1300303179,ExpressionUUID->"c3d29f78-c1aa-4025-9ee1-ba2fb8087486"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101474842*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1401937581,ExpressionUUID->"77f7328c-586b-47e9-97fc-257bae7dfadf"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101485997*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->174348983,ExpressionUUID->"b9cea110-1f65-4730-8961-8d7825a7d865"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.72898110149753*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1115662773,ExpressionUUID->"9a743e0f-a0a7-4b12-a811-60ab3ca2e8c2"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101509513*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1264503854,ExpressionUUID->"d1f7ec21-6e94-484c-ad9c-aaac86415d25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.7289811015212193`*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1018103466,ExpressionUUID->"def5198f-fa72-4ccc-844f-f136593e9323"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101533592*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->115253766,ExpressionUUID->"fa06ff2e-99c1-49a9-8a71-2a94ea8d88b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101585671*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->39795568,ExpressionUUID->"3d460c3e-596a-4ae6-835d-3a58d22466be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.72898110159826*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->976697159,ExpressionUUID->"76adc02c-a84a-4a46-9cfb-162e4216c366"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.72898110161036*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->2131637292,ExpressionUUID->"4211471d-3685-4717-93b4-9922acc46261"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101693948*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->2105767390,ExpressionUUID->"64f0b88d-ca0a-4974-8425-e59939d338b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.72898110170649*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1102021170,ExpressionUUID->"05fce37d-e71c-4701-b808-ee99b21157c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.728981101739744*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->1770832462,ExpressionUUID->"a6c00408-3406-4aa6-836e-af568298f22a"],

Cell[BoxData["0.365443`"], "Print",
 CellChangeTimes->{3.728979904455243*^9, 3.728980441018622*^9, 
  3.728980808043098*^9, 3.7289811017517223`*^9},
 CellLabel->"During evaluation of In[8]:=",
 CellID->405325061,ExpressionUUID->"76f36f6a-433b-4af4-9c02-8febe47c4b9b"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The absolute value of its determinant in the basis ",
 StyleBox["AIndex",
  FontFamily->"Courier"],
 " is obtained as"
}], "MathCaption",ExpressionUUID->"05939f58-1bd2-4d79-b575-b080378f9c8e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Determinant", "[", "g", "]"}], "[", "]"}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"15e4948b-4032-4e7d-b515-674fbb547e70"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   OverscriptBox["g", 
    OverscriptBox[
     StyleBox["~",
      FontColor->RGBColor[0, 0, 0]], 
     StyleBox["~",
      FontColor->RGBColor[0, 0, 0]]]],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Detg[],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289799073483562`*^9, 3.728980441570436*^9, 
  3.728980809242319*^9, 3.728981101881708*^9},
 CellLabel->"Out[9]=",
 CellID->480171943,ExpressionUUID->"bc174ce7-3770-4d77-bc55-aac0c0311fb4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["and it is actually called", "MathCaption",ExpressionUUID->"22e2e9e7-588a-4502-9b6b-6fb1f9e1a8ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"7c9e2112-ec27-462d-819a-785c4b325949"],

Cell["Detg[]", "Output",
 CellChangeTimes->{3.7289799083229218`*^9, 3.728980441703537*^9, 
  3.728980809359831*^9, 3.728981101987357*^9},
 CellLabel->"Out[10]//InputForm=",
 CellID->6300575,ExpressionUUID->"b12d6d9f-a94c-4f81-b3d1-63ea6e489330"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
By default, curvature tensors are output showing the name of the derivative \
they are associated to:\
\>", "MathCaption",ExpressionUUID->"07d35218-8e3b-4c07-a76e-f3dc780769ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", "d"}], "]"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"e6104e97-79e2-4cdb-8a97-77891ccdbeba"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "D", "]"}], 
      StyleBox[GridBox[{
         {" ", " ", " ", "d"},
         {"a", "b", "c", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d],
  Editable->False]], "Output",
 CellChangeTimes->{3.728979909299814*^9, 3.728980441836423*^9, 
  3.728980809493884*^9, 3.728981102101727*^9},
 CellLabel->"Out[11]=",
 CellID->667065322,ExpressionUUID->"28a0c9de-5c70-4117-9d23-b58f5a9bad42"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Because we shall work with a single covariant derivative operator, we can \
choose a simpler output for the geometric tensors\
\>", "MathCaption",ExpressionUUID->"52998450-6d90-4f6d-9c2f-ff6cd96eb45a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RiemannCD", "]"}], "^=", "\"\<R\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RicciCD", "]"}], "^=", "\"\<R\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RicciScalarCD", "]"}], "^=", "\"\<R\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "ChristoffelCD", "]"}], "^=", 
   "\"\<\[CapitalGamma]\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "EinsteinCD", "]"}], "^=", "\"\<G\>\""}], 
  ";"}]}], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"10cf5fe5-cff1-4490-b531-205b717d6c2b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["so that now", "MathCaption",ExpressionUUID->"b2ccb556-4c30-47cd-97af-bbfb98d06b32"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannCD", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", "d"}], "]"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"176083b2-64cd-488c-b865-3bfbeaca4bf7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"R", 
      StyleBox[GridBox[{
         {" ", " ", " ", "d"},
         {"a", "b", "c", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d],
  Editable->False]], "Output",
 CellChangeTimes->{3.728979911395714*^9, 3.7289804420554256`*^9, 
  3.728980809667906*^9, 3.728981102271471*^9},
 CellLabel->"Out[17]=",
 CellID->1502229514,ExpressionUUID->"33711e2d-a20c-431e-8c5a-8fce8a9f90bc"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "After defining the background manifold in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", we now define the perturbative structure with the command ",
 StyleBox["DefMetricPerturbation",
  FontFamily->"Courier"],
 " of ",
 StyleBox["xPert`",
  FontFamily->"Courier"],
 "."
}], "Text",ExpressionUUID->"0349fe76-8d24-4184-92a2-3cc93cd97182"],

Cell[CellGroupData[{

Cell[TextData[{
 "We define the symmetric two-tensor ",
 StyleBox["h",
  FontFamily->"Courier"],
 " that will be understood as the perturbation of the metric. As can be seen \
in the output, the first index of this tensor is a label index (",
 StyleBox["LI",
  FontFamily->"Courier"],
 "), which will encode the perturbative order."
}], "MathCaption",ExpressionUUID->"f17c6eaa-d358-4577-815d-24f0586723f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetricPerturbation", "[", 
  RowBox[{"g", ",", "h", ",", "\[Epsilon]"}], "]"}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"5cc4aa74-909a-495e-b32d-4724fd603aa0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefParameter", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parameter \"\>", "\[InvisibleSpace]", 
   "\[Epsilon]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefParameter, ": Defining ", 
   "parameter ", $CellContext`\[Epsilon], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979912938879*^9, 3.7289804421726294`*^9, 
  3.728980809776726*^9, 3.728981102382728*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->6204019,ExpressionUUID->"6ae24946-e75d-46bc-acec-f43dfce0002f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"h", "[", 
    RowBox[{
     RowBox[{"LI", "[", "\<\"order\"\>", "]"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`h[
    xAct`xTensor`LI["order"], -$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728979912938879*^9, 3.7289804421726294`*^9, 
  3.728980809776726*^9, 3.7289811023939447`*^9},
 CellLabel->"During evaluation of In[18]:=",
 CellID->1191732277,ExpressionUUID->"11a91931-80d1-408d-8df3-ea74f6e14840"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The perturbative parameter ",
 StyleBox["\[Epsilon]",
  FontFamily->"Courier"],
 " is stored in the global variable"
}], "MathCaption",ExpressionUUID->"95192ec0-5783-4f3e-9f90-1f4a9324bcc2"],

Cell[CellGroupData[{

Cell[BoxData["$PerturbationParameter"], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"4fc73631-08b8-46f5-8143-0e5a17302930"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["\[Epsilon]",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Epsilon],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289799139555264`*^9, 3.728980442305237*^9, 
  3.728980809892939*^9, 3.728981102517477*^9},
 CellLabel->"Out[19]=",
 CellID->2011887617,ExpressionUUID->"8d3b2cb0-fcb2-4a83-b5c0-28d1fdc737f8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finally, we colour in blue the perturbative orders", "MathCaption",ExpressionUUID->"ccc9069d-dcbb-4e2d-a51b-86d89a09e64f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "IndexForm", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IndexForm", "[", 
    RowBox[{"LI", "[", "x_", "]"}], "]"}], ":=", 
   RowBox[{"ColorString", "[", 
    RowBox[{
     RowBox[{"ToString", "[", "x", "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "IndexForm", "]"}], ";"}]}], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"98ef6def-7539-4f14-8691-767f393faf49"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndexForm", "[", 
  RowBox[{"LI", "[", "n", "]"}], "]"}]], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"7b20319f-86b2-44de-b6e0-2b1b9bf3c6aa"],

Cell[BoxData["\<\"\\!\\(\\*StyleBox[\\\"n\\\",FontColor->RGBColor[0., 0., \
1.]]\\)\"\>"], "Output",
 CellChangeTimes->{3.7289799159647427`*^9, 3.728980442489718*^9, 
  3.728980810033586*^9, 3.7289811027030563`*^9},
 CellLabel->"Out[23]=",
 CellID->1665156904,ExpressionUUID->"ab300b6c-586e-48e5-9f36-12fdd12d3df3"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1. Perturbations of the metric and fundamental properties", "Section",ExpressionUUID->"45d96001-9bfb-4d38-8348-7e6f93a6f880"],

Cell[TextData[{
 "The main objective of ",
 StyleBox["xPert`",
  FontFamily->"Courier"],
 " is giving the ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-th perturbation of any object in terms of metric perturbations of order ",
 StyleBox["n",
  FontSlant->"Italic"],
 " and lower. Here we introduce the ",
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 " head and give examples of use of different perturbative orders. For those \
readers already familiar with ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", let us point out that the symbol ",
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 " is a linear inert-head."
}], "Text",ExpressionUUID->"ea9c6002-9aec-47a7-9439-1037d53d29bb"],

Cell[CellGroupData[{

Cell["The perturbation of the metric is represented as follows:", \
"MathCaption",ExpressionUUID->"11a68621-e5d3-4087-b023-d1232dc9a822"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", " ", 
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], " ", "]"}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"64907755-a67c-4f6c-9cbf-12f46eb4606f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"h", 
      StyleBox[GridBox[{
         {
          StyleBox["1",
           FontColor->RGBColor[0., 0., 1.]], " ", " "},
         {" ", "a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`h[
   xAct`xTensor`LI[1], -$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellChangeTimes->{3.728979927075612*^9, 3.728980442611227*^9, 
  3.7289808101769257`*^9, 3.728981102859089*^9},
 CellLabel->"Out[24]=",
 CellID->285197824,ExpressionUUID->"3b055467-8be5-4ccd-adb0-a8be0c4b2524"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 " has actually two argumens in general. The first one is the expression we \
want to perturb and the second one the perturbative order (with default 1 \
when it is not specified, as in the previous case). For instance, acting on \
the metric at fifth perturbative order returns"
}], "MathCaption",ExpressionUUID->"e16899b0-3f0e-41e6-9513-abe83c00b627"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"bf9981eb-bf5a-455f-99e7-213f1aceb25b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"h", 
      StyleBox[GridBox[{
         {
          StyleBox["5",
           FontColor->RGBColor[0., 0., 1.]], " ", " "},
         {" ", "a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`h[
   xAct`xTensor`LI[5], -$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289799283574667`*^9, 3.728980442751915*^9, 
  3.72898081032761*^9, 3.728981102963481*^9},
 CellLabel->"Out[25]=",
 CellID->136327864,ExpressionUUID->"736ac7ae-7e61-4ba2-ad81-00e2b5e2ec82"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Or on the perturbed tensor itself,", "MathCaption",ExpressionUUID->"ed124207-954e-4791-b506-3f31ea5dee35"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{
     RowBox[{"LI", "[", "3", "]"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"c613a083-9721-408a-9c61-eefca572c891"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"h", 
      StyleBox[GridBox[{
         {
          StyleBox["8",
           FontColor->RGBColor[0., 0., 1.]], " ", " "},
         {" ", "a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`h[
   xAct`xTensor`LI[8], -$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellChangeTimes->{3.728979929364855*^9, 3.728980443078766*^9, 
  3.728980810425873*^9, 3.7289811030604973`*^9},
 CellLabel->"Out[26]=",
 CellID->2044842546,ExpressionUUID->"7b411c92-b5d6-443c-ad79-0d1a5b1d7d1d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["It also knows how to act on a Kronecker delta", "MathCaption",ExpressionUUID->"bdcfc1b8-34f3-4a58-a98d-45bb8665f2ef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{"delta", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"08de89bb-2ba0-4062-a5d5-a270e330b14c"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.72897993055798*^9, 3.728980443377492*^9, 
  3.7289808105263433`*^9, 3.728981103182108*^9},
 CellLabel->"Out[27]=",
 CellID->1487867681,ExpressionUUID->"b6e4cbdc-9dab-47d2-9bd9-1855a85164bf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 " uses the fundamental properties of a derivative: linearity and Leibnitz \
rule. When it does not know the answer of the action on a given tensor, for \
example the inverse of the metric or the Ricci tensor, the head ",
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 " is kept (this is where its inert-head character plays a role):"
}], "MathCaption",ExpressionUUID->"952d8817-fa5d-4690-a3c4-9b13a14cf014"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "+", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"c", ",", "d"}], "]"}], 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "b"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"85af7115-e340-40d4-98a0-dc8101845e4b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]], " ", " "},
          {" ", "a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`h[
    xAct`xTensor`LI[1], -$CellContext`a, -$CellContext`b],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728979931967345*^9, 3.72898044374023*^9, 
  3.728980810656563*^9, 3.7289811033144703`*^9},
 CellLabel->"Out[28]=",
 CellID->1292528899,ExpressionUUID->"42da5fd0-db37-4d7f-988b-63aec30f29bd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We can consider the same case but at a higher perturbative order, for \
instance at seveteenth order and see that the calculation is almost immediate.\
\>", "MathCaption",ExpressionUUID->"f5902ceb-bc3d-47d2-9067-184e3c55c258"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "+", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"c", ",", "d"}], "]"}], 
     RowBox[{"RicciCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], 
     RowBox[{"RicciCD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}]}], ",", "17"}], "]"}]], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"e04b317a-b2a5-48ea-aaba-63b7f5ef987c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {
           StyleBox["17",
            FontColor->RGBColor[0., 0., 1.]], " ", " "},
          {" ", "a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`h[
    xAct`xTensor`LI[17], -$CellContext`a, -$CellContext`b],
   Editable->False], "+", 
  RowBox[{"272", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "15"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 15],
    Editable->False]}], "+", 
  RowBox[{"2040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 14],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False]}], "+", 
  RowBox[{"9520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False]}], "+", 
  RowBox[{"30940", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False]}], "+", 
  RowBox[{"74256", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False]}], "+", 
  RowBox[{"136136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False]}], "+", 
  RowBox[{"194480", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False]}], "+", 
  RowBox[{"218790", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False]}], "+", 
  RowBox[{"194480", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 9],
    Editable->False]}], "+", 
  RowBox[{"136136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 10],
    Editable->False]}], "+", 
  RowBox[{"74256", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 11],
    Editable->False]}], "+", 
  RowBox[{"30940", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 12],
    Editable->False]}], "+", 
  RowBox[{"9520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 13],
    Editable->False]}], "+", 
  RowBox[{"2040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 14],
    Editable->False]}], "+", 
  RowBox[{"272", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "15"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 15],
    Editable->False]}], "+", 
  RowBox[{"17", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "16"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 16],
    Editable->False]}], "+", 
  RowBox[{"2040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 14],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"14280", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"61880", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"185640", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"408408", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"875160", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"875160", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"408408", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"185640", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"61880", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"14280", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"2040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 14],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"136", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "15"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 15],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False]}], "+", 
  RowBox[{"9520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"61880", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"247520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"1361360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"2042040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"2333760", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"2042040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"1361360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"247520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"61880", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"9520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"680", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 14],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False]}], "+", 
  RowBox[{"30940", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"185640", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"1701700", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"3063060", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"4084080", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"4084080", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"3063060", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"1701700", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"185640", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"30940", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"2380", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False]}], "+", 
  RowBox[{"74256", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"408408", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"1361360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"3063060", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"4900896", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"5717712", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"4900896", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"3063060", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"1361360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"408408", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"74256", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"6188", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False]}], "+", 
  RowBox[{"136136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"2042040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"4084080", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"5717712", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"5717712", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"4084080", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"2042040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"136136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"12376", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False]}], "+", 
  RowBox[{"194480", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"875160", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"2333760", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"4084080", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"4900896", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"4084080", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"2333760", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"875160", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"194480", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"19448", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False]}], "+", 
  RowBox[{"218790", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False]}], "+", 
  RowBox[{"875160", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False]}], "+", 
  RowBox[{"2042040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False]}], "+", 
  RowBox[{"3063060", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False]}], "+", 
  RowBox[{"3063060", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False]}], "+", 
  RowBox[{"2042040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False]}], "+", 
  RowBox[{"875160", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False]}], "+", 
  RowBox[{"218790", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False]}], "+", 
  RowBox[{"24310", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False]}], "+", 
  RowBox[{"194480", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 9],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 9],
    Editable->False]}], "+", 
  RowBox[{"1361360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 9],
    Editable->False]}], "+", 
  RowBox[{"1701700", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 9],
    Editable->False]}], "+", 
  RowBox[{"1361360", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 9],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 9],
    Editable->False]}], "+", 
  RowBox[{"194480", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 9],
    Editable->False]}], "+", 
  RowBox[{"24310", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 9],
    Editable->False]}], "+", 
  RowBox[{"136136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 10],
    Editable->False]}], "+", 
  RowBox[{"408408", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 10],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 10],
    Editable->False]}], "+", 
  RowBox[{"680680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 10],
    Editable->False]}], "+", 
  RowBox[{"408408", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 10],
    Editable->False]}], "+", 
  RowBox[{"136136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 10],
    Editable->False]}], "+", 
  RowBox[{"19448", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 10],
    Editable->False]}], "+", 
  RowBox[{"74256", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 11],
    Editable->False]}], "+", 
  RowBox[{"185640", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 11],
    Editable->False]}], "+", 
  RowBox[{"247520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 11],
    Editable->False]}], "+", 
  RowBox[{"185640", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 11],
    Editable->False]}], "+", 
  RowBox[{"74256", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 11],
    Editable->False]}], "+", 
  RowBox[{"12376", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 11],
    Editable->False]}], "+", 
  RowBox[{"30940", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 12],
    Editable->False]}], "+", 
  RowBox[{"61880", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 12],
    Editable->False]}], "+", 
  RowBox[{"61880", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 12],
    Editable->False]}], "+", 
  RowBox[{"30940", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 12],
    Editable->False]}], "+", 
  RowBox[{"6188", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 12],
    Editable->False]}], "+", 
  RowBox[{"9520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 13],
    Editable->False]}], "+", 
  RowBox[{"14280", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 13],
    Editable->False]}], "+", 
  RowBox[{"9520", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 13],
    Editable->False]}], "+", 
  RowBox[{"2380", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 13],
    Editable->False]}], "+", 
  RowBox[{"2040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 14],
    Editable->False]}], "+", 
  RowBox[{"2040", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 14],
    Editable->False]}], "+", 
  RowBox[{"680", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 14],
    Editable->False]}], "+", 
  RowBox[{"272", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "15"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 15],
    Editable->False]}], "+", 
  RowBox[{"136", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "15"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 15],
    Editable->False]}], "+", 
  RowBox[{"17", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "16"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 16],
    Editable->False]}], "+", 
  RowBox[{"17", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "16"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 16],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "15"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 15],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 14],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"2380", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"6188", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"12376", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"19448", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"24310", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"24310", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"19448", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"12376", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"6188", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"2380", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 14],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "15"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 15],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"17", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "16"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 16],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "17"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`d, -$CellContext`b], 17],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"17", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "16"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 16],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "15"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 15],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 14],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"2380", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"6188", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"12376", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"19448", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"24310", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"24310", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "8"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "9"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 9],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"19448", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "7"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 7],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "10"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 10],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"12376", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 6],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "11"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 11],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"6188", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "12"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 12],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"2380", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "13"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 13],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"680", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 3],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "14"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 14],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"136", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "15"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 15],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"17", " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "16"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 16],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "17"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`RicciCD[-$CellContext`a, -$CellContext`c], 17],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyUpTriangle]", "17"], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"c", "d"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`c, $CellContext`d], 17],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`b],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728979933668264*^9, 3.72898044443401*^9, 
  3.7289808111939383`*^9, 3.728981103781855*^9},
 CellLabel->"Out[29]=",
 CellID->1736116088,ExpressionUUID->"14b0e046-5e22-41f6-9d1d-dc6c781b7144"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The perturbative order of an expression can be computed with", \
"MathCaption",ExpressionUUID->"9298d431-bf69-4880-86ac-a96e4e47fa12"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerturbationOrder", "[", "%", "]"}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"1346980a-3984-467d-a97c-0ee66ccf20f4"],

Cell[BoxData["17"], "Output",
 CellChangeTimes->{3.728979935187017*^9, 3.728980447640802*^9, 
  3.728980811378599*^9, 3.728981103915512*^9},
 CellLabel->"Out[30]=",
 CellID->1042779227,ExpressionUUID->"90b9a325-4246-418b-9dbb-7ca517ef3c34"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "By definition, ",
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 " commutes with partial derivatives,"
}], "MathCaption",ExpressionUUID->"521ef4d2-4049-47e2-8364-f7eb3d9175fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"d8e660f6-dba2-4df7-8e15-9a0f8783b2c0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[PartialD]", "a"], 
    SuperscriptBox["\[EmptyUpTriangle]", "5"], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {" ", " "},
            {"c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciCD[-$CellContext`c, -$CellContext`d],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`PD[-$CellContext`a][
   xAct`xPert`Perturbation[
    $CellContext`RicciCD[-$CellContext`c, -$CellContext`d], 5]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728979936438036*^9, 3.728980448773109*^9, 
  3.7289808115453987`*^9, 3.7289811040674133`*^9},
 CellLabel->"Out[31]=",
 CellID->376425022,ExpressionUUID->"d3d21843-c80b-4a4e-b7df-b47f889a73ad"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["and with covariant derivatives acting on scalars,", "MathCaption",ExpressionUUID->"6160a098-3ce4-415f-8f89-367791ae6c4d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"RicciScalarCD", "[", "]"}], "]"}], ",", "6"}], "]"}]], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"df975d3d-b8bb-4a85-9338-3ab3faf01cc0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["D", "a"], 
    SuperscriptBox["\[EmptyUpTriangle]", "6"], "[", 
    InterpretationBox[
     StyleBox["R",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[-$CellContext`a][
   xAct`xPert`Perturbation[
    $CellContext`RicciScalarCD[], 6]],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289799392781553`*^9, 3.728980449871715*^9, 
  3.7289808116950083`*^9, 3.728981104239584*^9},
 CellLabel->"Out[32]=",
 CellID->88520692,ExpressionUUID->"04bb037a-9ac6-47c6-b2f4-b2e9afa88a51"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["but not with covariant derivatives acting on tensors,", "MathCaption",ExpressionUUID->"1029f97d-cc5d-4625-8a2f-33ea9a8f3b30"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"RicciCD", "[", 
     RowBox[{"a", ",", 
      RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[33]:=",ExpressionUUID->"6d776873-6855-4cae-82d1-f9afe157e975"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"a", " ", "  "},
            {" ", "b", 
             RowBox[{";", "a"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`a][
      $CellContext`RicciCD[$CellContext`a, -$CellContext`b]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   $CellContext`CD[-$CellContext`a][
    $CellContext`RicciCD[$CellContext`a, -$CellContext`b]], 3],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289799460210752`*^9, 3.728980450956489*^9, 
  3.7289808118458548`*^9, 3.7289811043632603`*^9},
 CellLabel->"Out[33]=",
 CellID->1708586720,ExpressionUUID->"494fa09f-7904-4244-bcd7-0221d58b5424"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "It is essential to have in mind that the ",
 StyleBox["ToCanonical",
  FontFamily->"Courier"],
 " or ",
 StyleBox["Simplification",
  FontFamily->"Courier"],
 " commands cannot be used as long as there is any ",
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 " head in the expression because internal indices of the expression inside \
",
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 " could be moved improperly. A warning reminds us of the danger:"
}], "Text",ExpressionUUID->"3aaff977-7096-4275-8b08-f5ed413d63c4"],

Cell[CellGroupData[{

Cell["For example the expression", "MathCaption",ExpressionUUID->"64f62c57-bd8a-4f0c-8145-cab6abe202a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"LI", "[", "3", "]"}], ",", 
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "e"}]}], "]"}], 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "d"}], "]"}], "[", 
   RowBox[{"Perturbation", "[", 
    RowBox[{"RicciCD", "[", 
     RowBox[{"a", ",", "e"}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"6913c5d7-24e4-4936-a3c1-f9d3fb862849"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {
           StyleBox["3",
            FontColor->RGBColor[0., 0., 1.]], " ", " "},
          {" ", "a", "e"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`h[
    xAct`xTensor`LI[3], -$CellContext`a, -$CellContext`e],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["D", "d"], "\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {"a", "e"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[$CellContext`a, $CellContext`e],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`d][
     xAct`xPert`Perturbation[
      $CellContext`RicciCD[$CellContext`a, $CellContext`e]]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{3.728980452721834*^9, 3.728980812024262*^9, 
  3.7289811044629707`*^9},
 CellLabel->"Out[34]=",
 CellID->65675356,ExpressionUUID->"deef0050-a774-4e01-8b0d-26594c26e700"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["is not properly canonicalized here:", "MathCaption",ExpressionUUID->"380812be-d939-4fff-80f4-7a5555fa07a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"d336f91c-13bf-4c0d-bdc3-1c48a7003f37"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {
           StyleBox["3",
            FontColor->RGBColor[0., 0., 1.]], "a", "e"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`h[
    xAct`xTensor`LI[3], $CellContext`a, $CellContext`e],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["D", "d"], "\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"R", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "e"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`e],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`d][
     xAct`xPert`Perturbation[
      $CellContext`RicciCD[-$CellContext`a, -$CellContext`e]]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{3.728980454025844*^9, 3.728980812146343*^9, 
  3.728981104710661*^9},
 CellLabel->"Out[35]=",
 CellID->2146597381,ExpressionUUID->"c43cfdcb-311a-487b-bbf2-c74d17d643b2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
This is not a restriction at all. It just means that the perturbations must \
be replaced by other tensor expression before canonicalization. How this is \
done is shown next. In case canonicalization at this stage is really needed \
the right sequence of commands is\
\>", "MathCaption",ExpressionUUID->"41b45666-84b6-4157-b8d0-fcb102847257"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"%%", "//", 
     RowBox[{"SeparateMetric", "[", "]"}]}], "//", "ContractMetric"}], ",", 
   RowBox[{"UseMetricOnVBundle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"496c3e06-6b05-4cc5-bfa7-831b211b9e9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "a", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[3], -$CellContext`a, -$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["D", "d"], "\[EmptyUpTriangle]", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"g", 
            StyleBox[GridBox[{
               {"e", "b"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`g[$CellContext`e, $CellContext`b],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      xAct`xPert`Perturbation[
       $CellContext`g[$CellContext`e, $CellContext`b]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]], "a", "e"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[3], $CellContext`a, $CellContext`e],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["D", "d"], "\[EmptyUpTriangle]", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"R", 
            StyleBox[GridBox[{
               {" ", " "},
               {"a", "e"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`RicciCD[-$CellContext`a, -$CellContext`e],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      xAct`xPert`Perturbation[
       $CellContext`RicciCD[-$CellContext`a, -$CellContext`e]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "a", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[3], -$CellContext`a, -$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[EmptyUpTriangle]", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"a", "b"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`g[$CellContext`a, $CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xPert`Perturbation[
     $CellContext`g[$CellContext`a, $CellContext`b]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {"e", " ", "  "},
           {" ", "b", 
            RowBox[{";", "d"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`d][
     $CellContext`RicciCD[$CellContext`e, -$CellContext`b]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.72898046228582*^9, 3.728980812307486*^9, 
  3.728981104879833*^9},
 CellLabel->"Out[36]=",
 CellID->136912867,ExpressionUUID->"6ade6cda-f2f4-4c2f-a89a-abfaabeacb7b"]
}, Open  ]]
}, Open  ]],

Cell["\<\
which uses explicit metric factors instead of moving indices up and down.\
\>", "MathCaption",ExpressionUUID->"30106edf-f88b-4e16-b0a4-32e5f345f49e"]
}, Closed]],

Cell[CellGroupData[{

Cell["2. ExpandPerturbation", "Section",ExpressionUUID->"8aaa0c63-fda5-43f2-a255-44712802f0b4"],

Cell[TextData[{
 "The command ",
 StyleBox["ExpandPerturbation",
  FontFamily->"Courier"],
 " is the most powerful one of this package. As we have seen, the ",
 StyleBox["Perturbation",
  FontFamily->"Courier"],
 " operator automatically uses linearity and the Leibnitz rule to expand \
expressions. But up to now it only knows how to act on the metric with \
covariant indices. All other cases are handled by ",
 StyleBox["ExpandPerturbation",
  FontFamily->"Courier"],
 ", which makes use of exact formulas to expand the perturbations of any \
geometric object. "
}], "Text",ExpressionUUID->"4f56bc56-06ce-4f16-a256-e415c15eb80e"],

Cell[CellGroupData[{

Cell["The perturbations of the inverse metric are", "MathCaption",ExpressionUUID->"f1cb1443-8a9b-41eb-bdef-c1fef311f543"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{"g", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[37]:=",ExpressionUUID->"89e6a0b2-804f-4dd9-92dc-97bc37711af4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"\[EmptyUpTriangle]", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"a", "b"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`a, $CellContext`b],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   $CellContext`g[$CellContext`a, $CellContext`b]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728980471942523*^9, 3.728980812428751*^9, 
  3.728981105031541*^9},
 CellLabel->"Out[37]=",
 CellID->1139569732,ExpressionUUID->"bc243938-b37b-4b98-964f-deab78c2cf4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ExpandPerturbation"}]], "Input",
 CellLabel->"In[38]:=",ExpressionUUID->"9f9ac7f5-c17c-442c-a95a-fcb74881ca2c"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]], "a", "b"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`h[
    xAct`xTensor`LI[1], $CellContext`a, $CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728980472709619*^9, 3.728980812595098*^9, 
  3.7289811051657124`*^9},
 CellLabel->"Out[38]=",
 CellID->1489321778,ExpressionUUID->"03f14a2f-dce7-43b7-ba37-2090c523a90f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"5f7bb2a3-b82e-4daf-bdb4-a195600037ca"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"a", "b"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`a, $CellContext`b],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   $CellContext`g[$CellContext`a, $CellContext`b], 4],
  Editable->False]], "Output",
 CellChangeTimes->{3.728980473410501*^9, 3.7289808127630053`*^9, 
  3.728981105282372*^9},
 CellLabel->"Out[39]=",
 CellID->2109217061,ExpressionUUID->"d6af3b39-6e4e-411f-ab9e-d0ad725c3cb3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ExpandPerturbation"}]], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"a64ad235-31bd-45c9-8a03-5df6a5d28aa7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"24", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "d"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "e"},
           {" ", "d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`d, $CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "b"},
           {" ", "e", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`e, $CellContext`b],
    Editable->False]}], "-", 
  RowBox[{"12", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "d"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "b"},
           {" ", "d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`d, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`a, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"6", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " ", "b"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], -$CellContext`c, $CellContext`b],
    Editable->False]}], "-", 
  RowBox[{"12", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "b"},
           {" ", "d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`d, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " ", "d"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], -$CellContext`c, $CellContext`d],
    Editable->False]}], "-", 
  RowBox[{"12", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "d"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " ", "b"},
           {" ", "d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], -$CellContext`d, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{"4", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "b"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[3], $CellContext`a, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"4", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]], " ", "b"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[3], -$CellContext`c, $CellContext`b],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {
           StyleBox["4",
            FontColor->RGBColor[0., 0., 1.]], "a", "b"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`h[
    xAct`xTensor`LI[4], $CellContext`a, $CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289804741117077`*^9, 3.7289808129406757`*^9, 
  3.7289811053943033`*^9},
 CellLabel->"Out[40]=",
 CellID->1098583198,ExpressionUUID->"1c3cbd99-184a-4ff8-a70c-3df63c289c67"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["or the perturbations of the Ricci tensor are", "MathCaption",ExpressionUUID->"4bbfcb36-c32e-402c-a323-d0cb84a88fe4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Perturbation", "[", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "]"}], "//", 
  "ExpandPerturbation"}]], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"86779581-8265-466c-8837-f20c620b3406"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"h", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], "c", " ", "  ", "  "},
              {" ", " ", "c", 
               RowBox[{";", "b"}], 
               RowBox[{";", "a"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`a][
        $CellContext`CD[-$CellContext`b][
         $CellContext`h[
          xAct`xTensor`LI[1], $CellContext`c, -$CellContext`c]]],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "c", " ", "  ", "  "},
             {" ", " ", "b", 
              RowBox[{";", "c"}], 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[-$CellContext`c][
        $CellContext`h[
         xAct`xTensor`LI[1], $CellContext`c, -$CellContext`b]]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " ", 
              RowBox[{";", "c"}], "  "},
             {" ", "b", "c", "  ", 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[$CellContext`c][
        $CellContext`h[
         xAct`xTensor`LI[1], -$CellContext`b, -$CellContext`c]]],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "c", " ", "  ", "  "},
             {" ", " ", "b", 
              RowBox[{";", "a"}], 
              RowBox[{";", "c"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`c][
       $CellContext`CD[-$CellContext`a][
        $CellContext`h[
         xAct`xTensor`LI[1], $CellContext`c, -$CellContext`b]]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "c", " ", "  ", "  "},
             {" ", " ", "a", 
              RowBox[{";", "b"}], 
              RowBox[{";", "c"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`c][
       $CellContext`CD[-$CellContext`b][
        $CellContext`h[
         xAct`xTensor`LI[1], $CellContext`c, -$CellContext`a]]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " ", 
              RowBox[{";", "c"}], "  "},
             {" ", "b", "a", "  ", 
              RowBox[{";", "c"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`c][
       $CellContext`CD[$CellContext`c][
        $CellContext`h[
         xAct`xTensor`LI[1], -$CellContext`b, -$CellContext`a]]],
      Editable->False]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.72898047526035*^9, 3.7289808130753183`*^9, 
  3.728981105562703*^9},
 CellLabel->"Out[41]=",
 CellID->1970895527,ExpressionUUID->"b45ccad0-5087-4468-a733-971d6d4b487c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Perturbation", "[", 
   RowBox[{
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], ",", "2"}], "]"}], "//", 
  "ExpandPerturbation"}]], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"16bb4f1d-2b83-4233-98b4-781ea85a4149"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"h", 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[0., 0., 1.]], "c", " ", "  ", "  "},
              {" ", " ", "c", 
               RowBox[{";", "b"}], 
               RowBox[{";", "a"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`a][
        $CellContext`CD[-$CellContext`b][
         $CellContext`h[
          xAct`xTensor`LI[2], $CellContext`c, -$CellContext`c]]],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], "c", " ", "  ", "  "},
             {" ", " ", "b", 
              RowBox[{";", "c"}], 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[-$CellContext`c][
        $CellContext`h[
         xAct`xTensor`LI[2], $CellContext`c, -$CellContext`b]]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " ", 
              RowBox[{";", "c"}], "  "},
             {" ", "b", "c", "  ", 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[$CellContext`c][
        $CellContext`h[
         xAct`xTensor`LI[2], -$CellContext`b, -$CellContext`c]]],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], "c", " ", "  ", "  "},
             {" ", " ", "b", 
              RowBox[{";", "a"}], 
              RowBox[{";", "c"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`c][
       $CellContext`CD[-$CellContext`a][
        $CellContext`h[
         xAct`xTensor`LI[2], $CellContext`c, -$CellContext`b]]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], "c", " ", "  ", "  "},
             {" ", " ", "a", 
              RowBox[{";", "b"}], 
              RowBox[{";", "c"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`c][
       $CellContext`CD[-$CellContext`b][
        $CellContext`h[
         xAct`xTensor`LI[2], $CellContext`c, -$CellContext`a]]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " ", 
              RowBox[{";", "c"}], "  "},
             {" ", "b", "a", "  ", 
              RowBox[{";", "c"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`c][
       $CellContext`CD[$CellContext`c][
        $CellContext`h[
         xAct`xTensor`LI[2], -$CellContext`b, -$CellContext`a]]],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"h", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], "c", "d"},
              {" ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`h[
        xAct`xTensor`LI[1], $CellContext`c, $CellContext`d],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  ", "  "},
                {" ", "d", "c", 
                 RowBox[{";", "b"}], 
                 RowBox[{";", "a"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`a][
          $CellContext`CD[-$CellContext`b][
           $CellContext`h[
            xAct`xTensor`LI[1], -$CellContext`d, -$CellContext`c]]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  ", "  "},
                {" ", "d", "b", 
                 RowBox[{";", "c"}], 
                 RowBox[{";", "a"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`a][
          $CellContext`CD[-$CellContext`c][
           $CellContext`h[
            xAct`xTensor`LI[1], -$CellContext`d, -$CellContext`b]]],
         Editable->False], "-", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  ", "  "},
                {" ", "b", "c", 
                 RowBox[{";", "d"}], 
                 RowBox[{";", "a"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`a][
          $CellContext`CD[-$CellContext`d][
           $CellContext`h[
            xAct`xTensor`LI[1], -$CellContext`b, -$CellContext`c]]],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  "},
                {" ", "e", "c", 
                 RowBox[{";", "b"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`b][
          $CellContext`h[
           xAct`xTensor`LI[1], -$CellContext`e, -$CellContext`c]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  "},
                {" ", "e", "b", 
                 RowBox[{";", "c"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`h[
           xAct`xTensor`LI[1], -$CellContext`e, -$CellContext`b]],
         Editable->False], "-", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  "},
                {" ", "c", "b", 
                 RowBox[{";", "e"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`e][
          $CellContext`h[
           xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`b]],
         Editable->False]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], "e", "c", "  "},
                {" ", " ", " ", 
                 RowBox[{";", "a"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`a][
          $CellContext`h[
           xAct`xTensor`LI[1], $CellContext`e, $CellContext`c]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], "e", " ", 
                 RowBox[{";", "c"}]},
                {" ", " ", "a", "  "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[$CellContext`c][
          $CellContext`h[
           xAct`xTensor`LI[1], $CellContext`e, -$CellContext`a]],
         Editable->False], "-", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], "c", " ", 
                 RowBox[{";", "e"}]},
                {" ", " ", "a", "  "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[$CellContext`e][
          $CellContext`h[
           xAct`xTensor`LI[1], $CellContext`c, -$CellContext`a]],
         Editable->False]}], ")"}]}]}], ")"}]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"h", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], "c", "d"},
              {" ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`h[
        xAct`xTensor`LI[1], $CellContext`c, $CellContext`d],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  ", "  "},
                {" ", "d", "b", 
                 RowBox[{";", "a"}], 
                 RowBox[{";", "c"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`CD[-$CellContext`a][
           $CellContext`h[
            xAct`xTensor`LI[1], -$CellContext`d, -$CellContext`b]]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  ", "  "},
                {" ", "d", "a", 
                 RowBox[{";", "b"}], 
                 RowBox[{";", "c"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`CD[-$CellContext`b][
           $CellContext`h[
            xAct`xTensor`LI[1], -$CellContext`d, -$CellContext`a]]],
         Editable->False], "-", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  ", "  "},
                {" ", "b", "a", 
                 RowBox[{";", "d"}], 
                 RowBox[{";", "c"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`CD[-$CellContext`d][
           $CellContext`h[
            xAct`xTensor`LI[1], -$CellContext`b, -$CellContext`a]]],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  "},
                {" ", "e", "b", 
                 RowBox[{";", "a"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`a][
          $CellContext`h[
           xAct`xTensor`LI[1], -$CellContext`e, -$CellContext`b]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  "},
                {" ", "e", "a", 
                 RowBox[{";", "b"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`b][
          $CellContext`h[
           xAct`xTensor`LI[1], -$CellContext`e, -$CellContext`a]],
         Editable->False], "-", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", "  "},
                {" ", "a", "b", 
                 RowBox[{";", "e"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`e][
          $CellContext`h[
           xAct`xTensor`LI[1], -$CellContext`a, -$CellContext`b]],
         Editable->False]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], "e", "c", "  "},
                {" ", " ", " ", 
                 RowBox[{";", "c"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`h[
           xAct`xTensor`LI[1], $CellContext`e, $CellContext`c]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], "e", " ", 
                 RowBox[{";", "c"}]},
                {" ", " ", "c", "  "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[$CellContext`c][
          $CellContext`h[
           xAct`xTensor`LI[1], $CellContext`e, -$CellContext`c]],
         Editable->False], "-", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], "c", " ", 
                 RowBox[{";", "e"}]},
                {" ", " ", "c", "  "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[$CellContext`e][
          $CellContext`h[
           xAct`xTensor`LI[1], $CellContext`c, -$CellContext`c]],
         Editable->False]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.728980476043317*^9, 3.728980813258889*^9, 
  3.728981105717618*^9},
 CellLabel->"Out[42]=",
 CellID->2053350961,ExpressionUUID->"9a552a97-e50d-4e1f-a57a-bc3fa69a9198"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["ExpandPerturbation",
  FontFamily->"Courier"],
 " command has been only predefined on certain tensors, and only when those \
have indices with their expected characters (for the Ricci tensor, for \
example, both indices are expected to be covariant; all characters are \
accepted for the metric). All other cases and derivatives of the tensors are \
handled through optional internal algorithms."
}], "Text",ExpressionUUID->"b8d0015c-508d-4c69-ace7-dcbeb51aecdc"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["ExpandPerturbation",
  FontFamily->"Courier"],
 " has two options, which are by default switched on:"
}], "MathCaption",ExpressionUUID->"c0608024-1248-46ae-b286-fd5f875896e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "ExpandPerturbation", "]"}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"0acfd585-c08f-40e6-a959-a3f892efdb2b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SeparateMetric", "\[Rule]", "True"}], ",", 
   RowBox[{"OverDerivatives", "\[Rule]", "True"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728980480294045*^9, 3.7289808133836327`*^9, 
  3.7289811058652782`*^9},
 CellLabel->"Out[43]=",
 CellID->607394237,ExpressionUUID->"de4038dd-f85b-4673-97f0-d71d581c17d4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["SeparateMetric",
  FontFamily->"Courier"],
 " moves indices into their character (covariant or contravariant) specified \
at definition time,  introducing metric factors if required (this is \
performed using the ",
 StyleBox["SeparateMetric",
  FontFamily->"Courier"],
 " command in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", hence the name of the option). For instance:"
}], "MathCaption",ExpressionUUID->"d58193d1-f56e-4000-936f-3c8759e29b28"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"f51fb3d4-ba10-414a-ac35-6aaa4208b0e3"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"\[EmptyUpTriangle]", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"a", "b"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciCD[$CellContext`a, $CellContext`b],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   $CellContext`RicciCD[$CellContext`a, $CellContext`b]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728980481726198*^9, 3.7289808135482492`*^9, 
  3.728981105997854*^9},
 CellLabel->"Out[44]=",
 CellID->1485167068,ExpressionUUID->"55a2d4ee-0f73-4b6c-b0f8-9e2bcf4f6b47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ExpandPerturbation"}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"04d45a56-bad1-44c3-90f9-4513f38100f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"b", "d"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`b, $CellContext`d],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`c, -$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`c, -$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"b", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`b, $CellContext`d],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"h", 
              StyleBox[GridBox[{
                 {
                  StyleBox["1",
                   FontColor->RGBColor[0., 0., 1.]], "e", " ", "  ", "  "},
                 {" ", " ", "e", 
                  RowBox[{";", "d"}], 
                  RowBox[{";", "c"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`c][
           $CellContext`CD[-$CellContext`d][
            $CellContext`h[
             xAct`xTensor`LI[1], $CellContext`e, -$CellContext`e]]],
          Editable->False]}], "-", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], "e", " ", "  ", "  "},
                {" ", " ", "d", 
                 RowBox[{";", "e"}], 
                 RowBox[{";", "c"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`CD[-$CellContext`e][
           $CellContext`h[
            xAct`xTensor`LI[1], $CellContext`e, -$CellContext`d]]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", 
                 RowBox[{";", "e"}], "  "},
                {" ", "d", "e", "  ", 
                 RowBox[{";", "c"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`CD[$CellContext`e][
           $CellContext`h[
            xAct`xTensor`LI[1], -$CellContext`d, -$CellContext`e]]],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], "e", " ", "  ", "  "},
                {" ", " ", "d", 
                 RowBox[{";", "c"}], 
                 RowBox[{";", "e"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`e][
          $CellContext`CD[-$CellContext`c][
           $CellContext`h[
            xAct`xTensor`LI[1], $CellContext`e, -$CellContext`d]]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], "e", " ", "  ", "  "},
                {" ", " ", "c", 
                 RowBox[{";", "d"}], 
                 RowBox[{";", "e"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`e][
          $CellContext`CD[-$CellContext`d][
           $CellContext`h[
            xAct`xTensor`LI[1], $CellContext`e, -$CellContext`c]]],
         Editable->False], "-", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"h", 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[0., 0., 1.]], " ", " ", 
                 RowBox[{";", "e"}], "  "},
                {" ", "d", "c", "  ", 
                 RowBox[{";", "e"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`e][
          $CellContext`CD[$CellContext`e][
           $CellContext`h[
            xAct`xTensor`LI[1], -$CellContext`d, -$CellContext`c]]],
         Editable->False]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.7289804823966227`*^9, 3.728980813725515*^9, 
  3.7289811061179943`*^9},
 CellLabel->"Out[45]=",
 CellID->1000482795,ExpressionUUID->"c0ff2446-8608-4e3d-a5ae-2b8c533c40e5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The additional metric factors can be absorbed using ",
 StyleBox["ContractMetric",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"2ee96fc6-0d94-46fc-b150-16273c170208"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ContractMetric"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"c12692e4-4bde-41bd-b5ab-b8896d4c4484"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"h", 
         StyleBox[GridBox[{
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]], "b", "c"},
            {" ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`h[
      xAct`xTensor`LI[1], $CellContext`b, $CellContext`c],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[$CellContext`a, -$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", "b"},
           {"c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`c, $CellContext`b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "c", " ", 
            RowBox[{";", "b"}], 
            RowBox[{";", "a"}]},
           {" ", " ", "c", "  ", "  "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`a][
     $CellContext`CD[$CellContext`b][
      $CellContext`h[
       xAct`xTensor`LI[1], $CellContext`c, -$CellContext`c]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "c", "b", "  ", 
            RowBox[{";", "a"}]},
           {" ", " ", " ", 
            RowBox[{";", "c"}], "  "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`a][
     $CellContext`CD[-$CellContext`c][
      $CellContext`h[
       xAct`xTensor`LI[1], $CellContext`c, $CellContext`b]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", " ", 
            RowBox[{";", "c"}], 
            RowBox[{";", "a"}]},
           {" ", " ", "c", "  ", "  "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`a][
     $CellContext`CD[$CellContext`c][
      $CellContext`h[
       xAct`xTensor`LI[1], $CellContext`b, -$CellContext`c]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "c", "b", 
            RowBox[{";", "a"}], "  "},
           {" ", " ", " ", "  ", 
            RowBox[{";", "c"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`c][
     $CellContext`CD[$CellContext`a][
      $CellContext`h[
       xAct`xTensor`LI[1], $CellContext`c, $CellContext`b]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "c", "a", 
            RowBox[{";", "b"}], "  "},
           {" ", " ", " ", "  ", 
            RowBox[{";", "c"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`c][
     $CellContext`CD[$CellContext`b][
      $CellContext`h[
       xAct`xTensor`LI[1], $CellContext`c, $CellContext`a]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "a", 
            RowBox[{";", "c"}], "  "},
           {" ", " ", " ", "  ", 
            RowBox[{";", "c"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`c][
     $CellContext`CD[$CellContext`c][
      $CellContext`h[
       xAct`xTensor`LI[1], $CellContext`b, $CellContext`a]]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728980483524419*^9, 3.728980813902017*^9, 
  3.728981106284379*^9},
 CellLabel->"Out[46]=",
 CellID->317379555,ExpressionUUID->"a1a52ac9-3603-4be2-81a2-906e71ac89c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPerturbation", "[", 
  RowBox[{"%%%", ",", 
   RowBox[{"SeparateMetric", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"5b3f34ef-870c-4ebf-aae4-524d893c8d2f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"\[EmptyUpTriangle]", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {"a", "b"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciCD[$CellContext`a, $CellContext`b],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   $CellContext`RicciCD[$CellContext`a, $CellContext`b]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728980484345644*^9, 3.7289808140889263`*^9, 
  3.728981106383417*^9},
 CellLabel->"Out[47]=",
 CellID->1996285384,ExpressionUUID->"9a515862-bb72-40a2-ba2c-e0d5b75a4991"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["OverDerivatives",
  FontFamily->"Courier"],
 " allows to jump over Lie or covariant derivatives. The latter gives \
perturbations of the Christoffel symbols, that are also expanded into \
derivatives of metric perturbations. For example,"
}], "MathCaption",ExpressionUUID->"8263a55a-4895-4f46-a8d1-8b36561b2e54"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", " ", "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "[", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"3fddcaaf-3cbf-4310-a015-740871911b5a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"\[EmptyUpTriangle]", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {" ", " ", "  "},
            {"b", "c", 
             RowBox[{";", "a"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`a][
      $CellContext`RicciCD[-$CellContext`b, -$CellContext`c]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   $CellContext`CD[-$CellContext`a][
    $CellContext`RicciCD[-$CellContext`b, -$CellContext`c]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728980487095501*^9, 3.7289808142279587`*^9, 
  3.728981106496213*^9},
 CellLabel->"Out[48]=",
 CellID->1431431807,ExpressionUUID->"3a623b42-6f4d-4e5a-84b4-3f263d544be1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ExpandPerturbation"}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"11f97f70-c04c-42d5-8964-68b6e549dd35"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"h", 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[0., 0., 1.]], "d", " ", "  ", "  ", 
               "  "},
              {" ", " ", "d", 
               RowBox[{";", "c"}], 
               RowBox[{";", "b"}], 
               RowBox[{";", "a"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`a][
        $CellContext`CD[-$CellContext`b][
         $CellContext`CD[-$CellContext`c][
          $CellContext`h[
           xAct`xTensor`LI[1], $CellContext`d, -$CellContext`d]]]],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "d", " ", "  ", "  ", "  "},
             {" ", " ", "c", 
              RowBox[{";", "d"}], 
              RowBox[{";", "b"}], 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[-$CellContext`b][
        $CellContext`CD[-$CellContext`d][
         $CellContext`h[
          xAct`xTensor`LI[1], $CellContext`d, -$CellContext`c]]]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " ", 
              RowBox[{";", "d"}], "  ", "  "},
             {" ", "c", "d", "  ", 
              RowBox[{";", "b"}], 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[-$CellContext`b][
        $CellContext`CD[$CellContext`d][
         $CellContext`h[
          xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`d]]]],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "d", " ", "  ", "  ", "  "},
             {" ", " ", "c", 
              RowBox[{";", "b"}], 
              RowBox[{";", "d"}], 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[-$CellContext`d][
        $CellContext`CD[-$CellContext`b][
         $CellContext`h[
          xAct`xTensor`LI[1], $CellContext`d, -$CellContext`c]]]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "d", " ", "  ", "  ", "  "},
             {" ", " ", "b", 
              RowBox[{";", "c"}], 
              RowBox[{";", "d"}], 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[-$CellContext`d][
        $CellContext`CD[-$CellContext`c][
         $CellContext`h[
          xAct`xTensor`LI[1], $CellContext`d, -$CellContext`b]]]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " ", 
              RowBox[{";", "d"}], "  ", "  "},
             {" ", "c", "b", "  ", 
              RowBox[{";", "d"}], 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[-$CellContext`d][
        $CellContext`CD[$CellContext`d][
         $CellContext`h[
          xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`b]]]],
      Editable->False]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`d, -$CellContext`c],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "d", " ", "  "},
             {" ", " ", "b", 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`h[
        xAct`xTensor`LI[1], $CellContext`d, -$CellContext`b]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "d", " ", "  "},
             {" ", " ", "a", 
              RowBox[{";", "b"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`b][
       $CellContext`h[
        xAct`xTensor`LI[1], $CellContext`d, -$CellContext`a]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " ", 
              RowBox[{";", "d"}]},
             {" ", "a", "b", "  "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[$CellContext`d][
       $CellContext`h[
        xAct`xTensor`LI[1], -$CellContext`a, -$CellContext`b]],
      Editable->False]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"R", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`b, -$CellContext`d],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "d", " ", "  "},
             {" ", " ", "c", 
              RowBox[{";", "a"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`h[
        xAct`xTensor`LI[1], $CellContext`d, -$CellContext`c]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], "d", " ", "  "},
             {" ", " ", "a", 
              RowBox[{";", "c"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`c][
       $CellContext`h[
        xAct`xTensor`LI[1], $CellContext`d, -$CellContext`a]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " ", 
              RowBox[{";", "d"}]},
             {" ", "a", "c", "  "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[$CellContext`d][
       $CellContext`h[
        xAct`xTensor`LI[1], -$CellContext`a, -$CellContext`c]],
      Editable->False]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.728980487751747*^9, 3.728980814374732*^9, 
  3.7289811066989603`*^9},
 CellLabel->"Out[49]=",
 CellID->1962566555,ExpressionUUID->"63fa5fab-4de0-464b-a6ad-aa877ae61816"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPerturbation", "[", 
  RowBox[{"%%", ",", 
   RowBox[{"OverDerivatives", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"6dbd03a9-5392-4930-8e5e-b764c4d94c6f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"\[EmptyUpTriangle]", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"R", 
         StyleBox[GridBox[{
            {" ", " ", "  "},
            {"b", "c", 
             RowBox[{";", "a"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`a][
      $CellContext`RicciCD[-$CellContext`b, -$CellContext`c]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   $CellContext`CD[-$CellContext`a][
    $CellContext`RicciCD[-$CellContext`b, -$CellContext`c]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728980488594741*^9, 3.72898081450548*^9, 
  3.728981106864585*^9},
 CellLabel->"Out[50]=",
 CellID->1654755612,ExpressionUUID->"2341e24c-f026-4855-a976-657d98faab63"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
In order to show an example with Lie derivatives, we need a vector-field\
\>", "MathCaption",ExpressionUUID->"ffb2649f-76f0-4ef5-a954-6ecb8fdcd405"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M"}], "]"}]], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"68c2afbd-ec16-46be-899b-d93bcbfc0065"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728980489695774*^9, 3.728980814645989*^9, 
  3.728981107012952*^9},
 CellLabel->"During evaluation of In[51]:=",
 CellID->1564342234,ExpressionUUID->"453311ee-6351-4884-a849-e039a99e41e7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We perturb now at fourth-order the Lie derivative of the metric along a \
vector field:\
\>", "MathCaption",
 CellChangeTimes->{{3.72898074096556*^9, 
  3.728980746939437*^9}},ExpressionUUID->"6b064ecb-7d33-4e0d-bcdb-\
eefe0e9042f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", " ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LieD", "[", 
     RowBox[{"v", "[", "a", "]"}], "]"}], "[", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "4"}], "]"}]], "Input",
 CellChangeTimes->{{3.728980755707823*^9, 3.728980757555202*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"46ecc8b3-227d-452a-819b-08f9d1043a24"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[ScriptCapitalL]", "v"], GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`LieD[
      $CellContext`v[$CellContext`a]][
      $CellContext`g[-$CellContext`a, -$CellContext`b]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   xAct`xTensor`LieD[
    $CellContext`v[$CellContext`a]][
    $CellContext`g[-$CellContext`a, -$CellContext`b]], 4],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289804908452253`*^9, 3.728980757945744*^9, 
  3.728980814792691*^9, 3.728981107157776*^9},
 CellLabel->"Out[52]=",
 CellID->257636617,ExpressionUUID->"5e21c0ff-9f57-4b3c-b0f6-9e77bd8c5bfc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Note that the perturbation of a Lie derivative can be written in terms of Lie \
derivatives only\
\>", "MathCaption",ExpressionUUID->"0630940b-394f-4aad-805c-ec3f97f6a870"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ExpandPerturbation"}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"7f6c6227-0521-4289-8d28-f1fc1121c514"],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[ScriptCapitalL]", 
        TagBox[
         InterpretationBox[
          StyleBox[
           RowBox[{"\[EmptyUpTriangle]", "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {"a"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[$CellContext`a],
             Editable->False], "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xPert`Perturbation[
           $CellContext`v[$CellContext`a]],
          Editable->False],
         Short]], GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["3",
               FontColor->RGBColor[0., 0., 1.]], " ", " "},
             {" ", "a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`LieD[
      xAct`xPert`Perturbation[
       $CellContext`v[$CellContext`a]]][
      $CellContext`h[
       xAct`xTensor`LI[3], -$CellContext`a, -$CellContext`b]],
     Editable->False], ")"}]}], "+", 
  RowBox[{"6", " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[ScriptCapitalL]", 
        TagBox[
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyUpTriangle]", "2"], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {"a"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[$CellContext`a],
             Editable->False], "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xPert`Perturbation[
           $CellContext`v[$CellContext`a], 2],
          Editable->False],
         Short]], GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["2",
               FontColor->RGBColor[0., 0., 1.]], " ", " "},
             {" ", "a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`LieD[
      xAct`xPert`Perturbation[
       $CellContext`v[$CellContext`a], 2]][
      $CellContext`h[
       xAct`xTensor`LI[2], -$CellContext`a, -$CellContext`b]],
     Editable->False], ")"}]}], "+", 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[ScriptCapitalL]", 
        TagBox[
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyUpTriangle]", "3"], "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"v", 
                 StyleBox[GridBox[{
                    {"a"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}, "RowsIndexed" -> {}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`v[$CellContext`a],
             Editable->False], "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xPert`Perturbation[
           $CellContext`v[$CellContext`a], 3],
          Editable->False],
         Short]], GridBox[{
         {"h", 
          StyleBox[GridBox[{
             {
              StyleBox["1",
               FontColor->RGBColor[0., 0., 1.]], " ", " "},
             {" ", "a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`LieD[
      xAct`xPert`Perturbation[
       $CellContext`v[$CellContext`a], 3]][
      $CellContext`h[
       xAct`xTensor`LI[1], -$CellContext`a, -$CellContext`b]],
     Editable->False], ")"}]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[ScriptCapitalL]", 
      TagBox[
       InterpretationBox[
        StyleBox[
         RowBox[{
          SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"v", 
               StyleBox[GridBox[{
                  {"a"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`v[$CellContext`a],
           Editable->False], "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xPert`Perturbation[
         $CellContext`v[$CellContext`a], 4],
        Editable->False],
       Short]], GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`LieD[
    xAct`xPert`Perturbation[
     $CellContext`v[$CellContext`a], 4]][
    $CellContext`g[-$CellContext`a, -$CellContext`b]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[ScriptCapitalL]", "v"], GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["4",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`LieD[
    $CellContext`v[$CellContext`a]][
    $CellContext`h[
     xAct`xTensor`LI[4], -$CellContext`a, -$CellContext`b]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289807603409557`*^9, 3.7289808149739943`*^9, 
  3.7289811072785892`*^9},
 CellLabel->"Out[53]=",
 CellID->771589567,ExpressionUUID->"ac0f2550-1578-4836-a308-b09eb12f9356"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Again, nothing happens when switching-off the option ",
 StyleBox["OverDerivatives",
  FontFamily->"Courier"]
}], "MathCaption",ExpressionUUID->"cffa5126-f6f3-4663-9578-268f5339fd44"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPerturbation", "[", 
  RowBox[{"%%", ",", 
   RowBox[{"OverDerivatives", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"92555dc8-8556-46de-b970-850e52ebb1d3"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SuperscriptBox["\[EmptyUpTriangle]", "4"], "[", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[ScriptCapitalL]", "v"], GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`LieD[
      $CellContext`v[$CellContext`a]][
      $CellContext`g[-$CellContext`a, -$CellContext`b]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   xAct`xTensor`LieD[
    $CellContext`v[$CellContext`a]][
    $CellContext`g[-$CellContext`a, -$CellContext`b]], 4],
  Editable->False]], "Output",
 CellChangeTimes->{3.728980780711162*^9, 3.7289808150957823`*^9, 
  3.728981107397834*^9},
 CellLabel->"Out[54]=",
 CellID->1599591983,ExpressionUUID->"924e184e-2004-422a-9b87-3655d07de5a9"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3. Perturbations of curvature tensors", "Section",ExpressionUUID->"5e96047a-9b59-485a-bdea-f876d69d46dc"],

Cell[TextData[{
 "In this section we show how ",
 StyleBox["ExpandPerturbation",
  FontFamily->"Courier"],
 " acts on the most important geometric tensors of a Riemannian manifold, at \
any perturbative order. We shall compare its direct action at a particular \
order with a recursive computation of that order from lower orders. This is \
both a consistency check and an example of the efficiency of the direct \
action."
}], "Text",ExpressionUUID->"5743c077-8582-435e-a89b-9a80896aea83"],

Cell[CellGroupData[{

Cell["3.1. Perturbations of the inverse metric", "Subsection",ExpressionUUID->"b0a4c7f9-78b1-4a2d-b5a8-e1c7c154cadc"],

Cell["\<\
Let us start comparing the seventh-order recursive and direct perturbations \
of the inverse of our metric tensor field.\
\>", "Text",ExpressionUUID->"2601e80b-f231-43ac-932e-a1a2af86a95f"],

Cell[CellGroupData[{

Cell["Recursively :", "MathCaption",ExpressionUUID->"322ac5a2-6b2c-46a3-b690-ee58eb33e956"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Perturbation", "[", 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "]"}], "//", 
  "ExpandPerturbation"}]], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"03dc37ac-ae4f-4d19-9fdc-0c6c59b5c57e"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {
           StyleBox["1",
            FontColor->RGBColor[0., 0., 1.]], "a", "b"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`h[
    xAct`xTensor`LI[1], $CellContext`a, $CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728980826670763*^9},
 CellLabel->"Out[55]=",
 CellID->741670029,ExpressionUUID->"df3dbea3-7231-46fa-b277-1809916a575d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "Perturbation"}], "//", "ExpandPerturbation"}]], "Input",\

 CellLabel->"In[56]:=",ExpressionUUID->"07923ef0-3353-46ae-9ded-3e0744ec66ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"b", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"b", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], -$CellContext`c, -$CellContext`d],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.7289808276316547`*^9},
 CellLabel->"Out[56]=",
 CellID->905665646,ExpressionUUID->"a8498ca4-7d49-444d-905e-9a9812af688c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "Perturbation"}], "//", "ExpandPerturbation"}], "//", 
  "org"}]], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"e18486de-b5da-49e3-ae39-7329aae60b53"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "6"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", " "},
           {" ", " ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`a, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "b", " "},
           {" ", " ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`b, -$CellContext`c],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {
           StyleBox["3",
            FontColor->RGBColor[0., 0., 1.]], "a", "b"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`h[
    xAct`xTensor`LI[3], $CellContext`a, $CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289808283748703`*^9},
 CellLabel->"Out[57]=",
 CellID->512234132,ExpressionUUID->"bbb82ef1-ace1-4d5b-9819-c9749f750b3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "Perturbation"}], "//", "ExpandPerturbation"}], "//", 
  "org"}]], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"32e840d9-8e8c-4c95-991c-81db7081b797"],

Cell[BoxData[
 RowBox[{
  RowBox[{"24", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "e"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, $CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "d", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`d, -$CellContext`e],
    Editable->False]}], "-", 
  RowBox[{"12", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`a, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"6", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "b", " "},
           {" ", " ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`b, -$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{"12", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`b, $CellContext`d],
    Editable->False]}], "-", 
  RowBox[{"12", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], -$CellContext`c, -$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{"4", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", " "},
           {" ", " ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[3], $CellContext`a, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"4", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]], "b", " "},
           {" ", " ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[3], $CellContext`b, -$CellContext`c],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {
           StyleBox["4",
            FontColor->RGBColor[0., 0., 1.]], "a", "b"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`h[
    xAct`xTensor`LI[4], $CellContext`a, $CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289808291720457`*^9},
 CellLabel->"Out[58]=",
 CellID->888758499,ExpressionUUID->"3c1df317-d012-41f7-8d8e-ea0bbf910f18"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "Perturbation"}], "//", "ExpandPerturbation"}], "//", 
  "org"}]], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"6678f2b8-1f36-403a-bbca-2617873866ae"],

Cell[BoxData["0.221228`"], "Print",
 CellChangeTimes->{3.728980830512999*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->512853800,ExpressionUUID->"d0adbf72-4cda-4a18-81ab-bd7cf2cc7042"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "120"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "e"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, $CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "f"},
           {" ", "d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`d, $CellContext`f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "e", "f"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`e, -$CellContext`f],
    Editable->False]}], "+", 
  RowBox[{"60", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "e"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, $CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "d", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`d, -$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`a, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"60", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "e"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, $CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "d", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`d, -$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`b, $CellContext`d],
    Editable->False]}], "-", 
  RowBox[{"30", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`b, $CellContext`d],
    Editable->False]}], "-", 
  RowBox[{"30", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], -$CellContext`c, -$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{"30", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], -$CellContext`c, -$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{"60", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "e"},
           {" ", "d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`d, $CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], -$CellContext`c, -$CellContext`e],
    Editable->False]}], "+", 
  RowBox[{"60", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", "e"},
           {" ", "c", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, $CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "d", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], -$CellContext`d, -$CellContext`e],
    Editable->False]}], "-", 
  RowBox[{"20", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], "b", "d"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], $CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["1",
             FontColor->RGBColor[0., 0., 1.]], " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[1], -$CellContext`c, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[3], $CellContext`a, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"10", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "b", " "},
           {" ", " ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[2], $CellContext`b, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["3",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`h[
     xAct`xTensor`LI[3], $CellContext`a, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{"10", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {
            StyleBox["2",
             FontColor->RGBColor[0., 0., 1.]], "a", "c"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.