(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4790,        155]*)
(*NotebookOutlinePosition[      5459,        178]*)
(*  CellTagsIndexPosition[      5415,        174]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["ChristoffelToGradMetric", "ObjectName"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ChristoffelToGradMetric[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["metric",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["covd",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " expresses the Christoffel tensors from ",
  StyleBox["covd",
    FontSlant->"Italic"],
  " to the Levi-Civita connection of ",
  StyleBox["metric",
    FontSlant->"Italic"],
  " (or viceversa) in ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " as c",
  StyleBox["ovd",
    FontSlant->"Italic"],
  "-derivatives of ",
  StyleBox["metric",
    FontSlant->"Italic"],
  ", and possible ",
  StyleBox["covd",
    FontSlant->"Italic"],
  "-torsion terms if ",
  StyleBox["covd",
    FontSlant->"Italic"],
  " has torsion.\n\[FilledSmallSquare] ",
  StyleBox["ChristoffelToGradMetric[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["metric",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " performs the same operation for all covariant derivatives.\n\
\[FilledSmallSquare] ",
  StyleBox["ChristoffelToGradMetric[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " performs the same operation for all metrics and for all covariant \
derivatives."
}], "Usage"],

Cell[TextData[{
  "\[FilledSmallSquare] The second and third arguments are listable.\n\
\[FilledSmallSquare] `All covariant derivatives\.b4 means those in the list \
",
  StyleBox["$",
    FontFamily->"Courier"],
  StyleBox[ButtonBox["CovDs",
    ButtonData:>{"$CovDs.nb", None},
    ButtonStyle->"Hyperlink"],
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] `All metrics\.b4 means those in the list ",
  StyleBox[ButtonBox["$Metrics",
    ButtonData:>{"$Metrics.nb", None},
    ButtonStyle->"Hyperlink"],
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] This function is also called ",
  StyleBox[ButtonBox["ChristoffelToMetric",
    ButtonData:>{"ChristoffelToMetric.nb", None},
    ButtonStyle->"Hyperlink"],
    FontFamily->"Courier"],
  " for backward compatibility.\n\[FilledSmallSquare] See: ",
  ButtonBox["Section 4.5",
    ButtonData:>{
      FrontEnd`FileName[ {
        ParentDirectory[ ]}, "xTensorRefGuide.nb", CharacterEncoding -> 
        "iso8859-1"], "Covariant derivatives"},
    ButtonStyle->"Hyperlink"],
  ".\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GradMetricToChristoffel",
    ButtonData:>{"GradMetricToChristoffel.nb", None},
    ButtonStyle->"Hyperlink"],
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] New in version 0.\n",
  "\[FilledSmallSquare] Last update: 25-X-2007 for version 0.9.3 of ",
  StyleBox["xTensor`",
    FontFamily->"Courier"],
  "."
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{520, 600},
WindowMargins->{{355, Automatic}, {40, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 45, 0, 38, "ObjectName"],
Cell[1824, 55, 1519, 58, 140, "Usage"],
Cell[3346, 115, 1428, 37, 192, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

