(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   8203308,     230506]
NotebookOptionsPosition[   7654365,     219918]
NotebookOutlinePosition[   7673339,     220310]
CellTagsIndexPosition[   7671505,     220268]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["xAct`xTensor`", "Section",
 CellChangeTimes->{{3.72897608609194*^9, 3.728976087819756*^9}},
 FontSize->24,
 CellTags->{"S5.18.1", "1.1"},
 CellID->733679349,ExpressionUUID->"8f751253-cb93-40fd-ba41-fbaa77bd1a49"],

Cell[CellGroupData[{

Cell["Author", "Subsection",ExpressionUUID->"9bdcbc5a-2e86-4a77-9fb5-564dc8632094"],

Cell[TextData[{
 "\[Copyright] 2002-2018, under the GNU General Public License (GPL)\n     ",
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a",
  FontWeight->"Bold"],
 "\n\t",
 StyleBox["jose@xact.es",
  FontFamily->"Courier"],
 "\n\t",
 StyleBox[ButtonBox["http://www.xAct.es",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.xact.es/"], None},
  ButtonNote->"http://www.xact.es/"],
  FontFamily->"Courier"],
 StyleBox["\n\t",
  FontFamily->"Courier"],
 "\t",
 StyleBox[ButtonBox["http://groups.google.com/group/xAct/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://groups.google.com/group/xAct/"], None},
  ButtonNote->"http://groups.google.com/group/xAct/"],
  FontFamily->"Courier"]
}], "Text",
 FontFamily->"Arial",ExpressionUUID->"e5ed7587-e24d-4f73-b8f3-63f0c64152fc"],

Cell[TextData[{
 "Helped by:\n\t",
 StyleBox["Alfonso Garc\[IAcute]a-Parrado",
  FontWeight->"Bold"],
 " : design of vector bundles, complex structure, products and mappings.\n\t\
",
 StyleBox["Guillaume Faye",
  FontWeight->"Bold"],
 " : design of n+m decompositions."
}], "Text",ExpressionUUID->"55526d07-7028-4064-b2ac-5696ca58a58a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Intro", "Subsection",ExpressionUUID->"58295eb0-9c58-4bc2-922e-93dc4f966c53"],

Cell[TextData[{
 StyleBox["xTensor`", "MR"],
 " extends ",
 StyleBox["Mathematica", "TI"],
 " capabilities in abstract tensor calculus, focusing on General Relativity. \
It works with tensor fields with arbitrary symmetries under permutations of \
indices, defined on one or more vector bundles and manifolds. It computes \
covariant derivatives with respect to multiple connections, including gauge \
connections in complex vector bundles. ",
 StyleBox["xTensor`", "MR"],
 " can work with Lie derivatives, parametric derivatives and variational \
derivatives. It allows the presence of a metric in each manifold and defines \
all the associated torsion and curvature tensors (Riemann, Ricci, Einstein, \
Weyl, etc.), handling automatically their definitions and relations in terms \
of Christoffel objects. It can work with mappings between any two manifolds \
and push/pull tensor fields along those maps.\n",
 StyleBox["xTensor`", "MR"],
 " does not perform component calculations. See the twin package ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ".\n",
 StyleBox["xTensor`", "MR"],
 " needs the twin package ",
 StyleBox["xPerm`", "MR"],
 " in order to compute the canonical form of a list of indices under certain \
symmetry group.\n",
 StyleBox["xTensor`", "MR"],
 " has been designed with the following priorities in mind:\n\t1.- \
Mathematical structure\n\t2.- Efficiency\n\t3.- Compliance with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " style\n\t4.- Simplicity of input/output\nIn particular, concerning the \
mathematical structure, ",
 StyleBox["xTensor`", "MR"],
 " imitates the usual cycle in mathematics ``let ",
 StyleBox["X", "Input"],
 " be a (",
 StyleBox["Type", "Input"],
 ") with properties ",
 StyleBox["props", "Input"],
 "; then use it to do some ",
 StyleBox["computations", "Input"],
 "\.b4\.b4 with the general form of declaration\n\t",
 StyleBox["DefType[X, props]", "Input"],
 "\n\t",
 StyleBox["computations", "Input"]
}], "Text",ExpressionUUID->"dacae0c5-11a2-4fcd-a41c-5ae57fcad21a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load the package", "Subsection",ExpressionUUID->"8914d7d8-31e0-4a20-a60f-843051cb7ed6"],

Cell[CellGroupData[{

Cell["\<\
This loads the package from the default directory, for example \
$HOME/.Mathematica/Applications/xAct/ for a single-user installation under \
Linux (see the installation notes for other possibilities),\
\>", "MathCaption",
 CellChangeTimes->{{3.728977519955257*^9, 
  3.728977521376769*^9}},ExpressionUUID->"63a736e0-39af-4e8d-9b57-\
37c116af6eb8"],

Cell[CellGroupData[{

Cell["<<xAct`xTensor`", "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"1fb58714-653b-4365-aa43-7b82564c3a6d"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.7928040618302517`*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->551875384,ExpressionUUID->"37e67236-d784-488e-b78b-539616ac34ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.792804061838923*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->387707495,ExpressionUUID->"96aae411-9519-4432-ad32-11c55c5de4dc"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.792804061847281*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->734483467,ExpressionUUID->"a7e6bf32-dba2-4298-bbcd-4fd1c90f3784"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.7928040618534327`*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->727626913,ExpressionUUID->"b5e01409-19db-4b30-985d-669d58f2ae42"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.792804061903558*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->1453640773,ExpressionUUID->"2cd76ea9-cff8-44c3-87a5-3eb8839e6499"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.7928040619097023`*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->1566503539,ExpressionUUID->"71b7ba64-d48e-4e69-90ab-9547595f46c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2020", ",", "2", ",", "16"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.4", ", ", {2020, 2, 16}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.792804061915328*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->75467753,ExpressionUUID->"6cf8339f-c224-46ca-9cbc-91d7126fc1ca"],

Cell[BoxData["\<\"CopyRight (C) 2002-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.7928040619210787`*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->1371172941,ExpressionUUID->"1fddaec9-f1f6-420e-912d-b2569353640f"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.792804061927359*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->656603430,ExpressionUUID->"5f1102af-0d9a-4abf-ab95-163e9b78483a"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.7928040619336157`*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->1762869724,ExpressionUUID->"cb79e0ae-c180-4725-bb3a-218a63bce74d"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.7289775339237213`*^9, 3.728977542747715*^9}, 
   3.7928040619392548`*^9},
 CellLabel->"During evaluation of In[1]:=",
 CellID->1867057256,ExpressionUUID->"32c53a62-a534-4654-8d67-c2495637767f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["0. Basics", "Section",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.7286627354220657`*^9, 3.728662748172317*^9}, {
  3.728664037492599*^9, 3.72866403885896*^9}, {3.7286704747855062`*^9, 
  3.728670480415387*^9}, {3.728670889883876*^9, 3.728670893540101*^9}, {
  3.728673410238123*^9, 3.728673425886174*^9}, {3.7289761721698513`*^9, 
  3.7289761765432653`*^9}},
 FontSize->18,
 FontColor->GrayLevel[0],
 CellTags->{"S5.18.1", "1.4"},
 CellID->853073756,ExpressionUUID->"ca3135f0-5abf-4775-a4fc-678f1dffad3e"],

Cell[CellGroupData[{

Cell["0.1. Example session", "Subsection",ExpressionUUID->"49ccbd85-b1ee-4ab9-957e-62b0ff70d533"],

Cell[TextData[{
 "This is a very simple example of the use of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ". We start by defining a manifold and some tensor fields on its tangent \
bundle."
}], "Text",ExpressionUUID->"23d37c49-4c87-4fd8-8d70-984ab004bf6e"],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a 3d manifold ",
 StyleBox["M3",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"733d4119-e5b1-4b6b-8ed7-5c97b457d9d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M3", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"67a3701a-8ac8-4629-aa60-772ddf0caed8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977572682373*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->280435421,ExpressionUUID->"a9b233b4-d6a5-4736-b9bd-6d4662bf9526"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977572701936*^9},
 CellLabel->"During evaluation of In[2]:=",
 CellID->1698999229,ExpressionUUID->"c96430fd-4926-488a-b3f2-2d098ec42435"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a contravariant vector ",
 StyleBox["v",
  FontFamily->"Courier"],
 " and a covariant antisymmetric tensor ",
 StyleBox["F",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"008634dc-0c9e-4eb9-9a34-e678dec0fab0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"F", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "}"}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"eaa10a04-da2d-4175-bb11-da65b21403e2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977574012474*^9},
 CellLabel->"During evaluation of In[3]:=",
 CellID->1672621724,ExpressionUUID->"9cc31f94-3ae3-4381-ae36-b22473dbeef1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"F", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`F[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289775740317717`*^9},
 CellLabel->"During evaluation of In[3]:=",
 CellID->1192376038,ExpressionUUID->"77953aca-f5eb-4a0d-bb4b-0ad8ddd8843f"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Tensor product of both tensors, based on the abstract index notation:\
\>", "MathCaption",ExpressionUUID->"979b6ed1-be88-4046-84bd-753c6f388b2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], 
  RowBox[{"v", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"6b294b34-4699-4a9f-b31f-f5523ab89b3b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"F", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`F[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.72897757504585*^9},
 CellLabel->"Out[5]=",
 CellID->41016295,ExpressionUUID->"4bc2242d-cd73-45a7-a86b-249b53db34f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", 
  RowBox[{"v", "[", "a", "]"}]}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"74ab546e-7541-401f-b7a8-89446501a6b4"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"F", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`F[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977575711482*^9},
 CellLabel->"Out[6]=",
 CellID->378027064,ExpressionUUID->"46e5f676-c74b-4032-8930-c05720f5e47b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
There is no automatic simplification. It must be explicitly asked for:\
\>", "MathCaption",ExpressionUUID->"ea0f31b7-36a9-4045-b483-43613ab687c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplification", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"18eb2e93-cb8e-4c33-b436-517c3a4c17d7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.728977576723857*^9},
 CellLabel->"Out[7]=",
 CellID->1898734097,ExpressionUUID->"53fe00b1-86b1-4a8d-9b45-f3b363f21829"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example of dummy handling:", "MathCaption",ExpressionUUID->"3fd18b89-5491-4bc0-8950-24f3dccb5d5a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"F", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], 
   RowBox[{"v", "[", "d", "]"}], 
   RowBox[{"v", "[", "b", "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"-", "b"}], "]"}]}], "+", 
  RowBox[{"3", 
   RowBox[{"v", "[", "b", "]"}], 
   RowBox[{"v", "[", "c", "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"-", "c"}], "]"}], 
   RowBox[{"F", "[", 
    RowBox[{
     RowBox[{"-", "b"}], ",", "d"}], "]"}], 
   RowBox[{"F", "[", 
    RowBox[{
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "a"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"76307278-faac-44e1-907f-0f2948d60a9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"F", 
        StyleBox[GridBox[{
           {" ", "d"},
           {"b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`F[-$CellContext`b, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"F", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`F[-$CellContext`d, -$CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {"c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[-$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"F", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`F[-$CellContext`a, -$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {"b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"d"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`d],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.7289775778040648`*^9},
 CellLabel->"Out[8]=",
 CellID->1570938722,ExpressionUUID->"ccc3b734-4654-40e2-b0b6-4574e306b524"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplification"}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"2c856d83-a0bf-4f3c-ac46-75e5062541f5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"F", 
         StyleBox[GridBox[{
            {" ", " "},
            {"a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`F[-$CellContext`a, -$CellContext`c],
     Editable->False], "-", 
    RowBox[{"3", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"F", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F[-$CellContext`a, -$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"F", 
          StyleBox[GridBox[{
             {" ", "d"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F[-$CellContext`c, $CellContext`d],
      Editable->False]}]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" "},
          {"b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"c"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`c],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977579827976*^9},
 CellLabel->"Out[9]=",
 CellID->136888559,ExpressionUUID->"9e732302-e714-475a-88c4-36f34c51e7d1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "There is not a metric and hence ",
 StyleBox["v",
  FontFamily->"Courier"],
 " cannot be covariant. Note the position of the head ",
 Cell[BoxData[
  StyleBox["ERROR",
   FontColor->RGBColor[1, 0, 0]]], "Output",ExpressionUUID->
  "cf231807-8085-4d29-9f69-f6ad6cc466aa"],
 ":"
}], "MathCaption",ExpressionUUID->"86bdeab5-7032-45af-ae1e-7e5083ca90a9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", "%", "]"}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"e1714e59-b838-40c8-95a5-b1120d3c6fd6"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor F\\\\\
\\\"\\\"}]\\)\"", 2, 10, 1, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977580963031*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->276709775,ExpressionUUID->"a22bf1ed-0245-4f15-9d91-91dd92545138"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor v\\\\\
\\\"\\\"}]\\)\"", 2, 10, 2, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977581048689*^9},
 CellLabel->"During evaluation of In[10]:=",
 CellID->1359092670,ExpressionUUID->"f982f1fb-0bbf-486f-8511-146b6ba801cc"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["ERROR",
      FontColor->Hue[0.]], "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {" "},
             {"b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[-$CellContext`b],
      Editable->False], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`ERROR[
    $CellContext`v[-$CellContext`b]],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"F", 
         StyleBox[GridBox[{
            {" ", " "},
            {"a", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`F[-$CellContext`a, -$CellContext`c],
     Editable->False], "-", 
    RowBox[{"3", " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["ERROR",
         FontColor->Hue[0.]], "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"F", 
             StyleBox[GridBox[{
                {" ", "d"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`F[-$CellContext`c, $CellContext`d],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`ERROR[
       $CellContext`F[-$CellContext`c, $CellContext`d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"F", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F[-$CellContext`a, -$CellContext`d],
      Editable->False]}]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"c"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`c],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977581114188*^9},
 CellLabel->"Out[10]=",
 CellID->1634435198,ExpressionUUID->"c8dc07e1-6548-42dc-bda7-bc1f06ba7eb9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Internal structure:", "MathCaption",ExpressionUUID->"cfe5bdde-9bf4-4c42-962e-fa585d6d69fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%%", "]"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"0a91f51a-3d40-43b9-acec-8beb86650730"],

Cell["(F[-a, -c] - 3*F[-a, -d]*F[-c, d])*v[-b]*v[b]*v[c]", "Output",
 CellChangeTimes->{3.728977582567274*^9},
 CellLabel->"Out[11]//InputForm=",
 CellID->9239946,ExpressionUUID->"e272e9ab-b216-43ab-9d1d-924ae292e416"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Now we define a covariant derivative operator and check the first Bianchi \
identity (valid for any symmetric connection). Note that ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " uses unique (dollar-) variables as internal dummy indices to avoid index \
collisions. The function ",
 StyleBox["ScreenDollarIndices",
  FontFamily->"Courier"],
 " hides those indices replacing them by \"normal\" indices. "
}], "Text",ExpressionUUID->"e18353cd-049b-480f-baa8-56723d506293"],

Cell[CellGroupData[{

Cell["\<\
Covariant derivatives are defined by default with curvature but without \
torsion. Note also the default associated symbols: semicolon in Postfix \
notation and nabla in Prefix notation:\
\>", "MathCaption",ExpressionUUID->"af4360a0-05fb-459c-933d-7b0d5575970d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DefCovD", "]"}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"7746ad4a-dbf0-481b-b66c-676aab67bc23"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SymbolOfCovD", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\";\"\>", ",", "\<\"\[EmptyDownTriangle]\"\>"}], "}"}]}], ",", 
   RowBox[{"Torsion", "\[Rule]", "False"}], ",", 
   RowBox[{"Curvature", "\[Rule]", "True"}], ",", 
   RowBox[{"FromMetric", "\[Rule]", "Null"}], ",", 
   RowBox[{"CurvatureRelations", "\[Rule]", "True"}], ",", 
   RowBox[{"ExtendedFrom", "\[Rule]", "Null"}], ",", 
   RowBox[{"OtherDependencies", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"OrthogonalTo", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"ProjectedWith", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"WeightedWithBasis", "\[Rule]", "Null"}], ",", 
   RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
   
   RowBox[{"Master", "\[Rule]", "Null"}], ",", 
   RowBox[{"DefInfo", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"covariant derivative\"\>", ",", "\<\"\"\>"}], "}"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.728977586485179*^9},
 CellLabel->"Out[12]=",
 CellID->1951053507,ExpressionUUID->"8a759938-1bbc-4c24-9eb4-169bff48d812"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefCovD", "[", 
  RowBox[{"Cd", "[", 
   RowBox[{"-", "a"}], "]"}], "]"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"bec91a2d-7597-45cf-ba53-e02d48a72bf7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"Cd", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`Cd[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977587231658*^9},
 CellLabel->"During evaluation of In[13]:=",
 CellID->2078150768,ExpressionUUID->"80e097f9-1af2-4673-9cad-fe343f30725b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCd[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289775872500896`*^9},
 CellLabel->"During evaluation of In[13]:=",
 CellID->805922968,ExpressionUUID->"3c6ed23c-f5e7-4c4d-86b3-5c6ac9216fac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977587267672*^9},
 CellLabel->"During evaluation of In[13]:=",
 CellID->967961547,ExpressionUUID->"86c37c43-9cd6-4ff3-8c98-034d338fe7d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCd[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977587284672*^9},
 CellLabel->"During evaluation of In[13]:=",
 CellID->1341094404,ExpressionUUID->"825ddd1b-2bbc-4ad2-8d31-52e1d933b591"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`RicciCd[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289775873021*^9},
 CellLabel->"During evaluation of In[13]:=",
 CellID->1932772763,ExpressionUUID->"18cd6e80-9b20-4e8b-997f-d8de4fab9462"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellChangeTimes->{3.728977587319776*^9},
 CellLabel->"During evaluation of In[13]:=",
 CellID->1274183219,ExpressionUUID->"4b2e3e33-9cf9-4be1-acea-008a936c0deb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Leibnitz rule is automatic:", "MathCaption",ExpressionUUID->"3a2a50f3-9824-47ba-b62e-832dea04f25a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cd", "[", 
   RowBox[{"-", "a"}], "]"}], "[", " ", 
  RowBox[{
   RowBox[{"F", "[", 
    RowBox[{
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], 
   RowBox[{"v", "[", "c", "]"}]}], " ", "]"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"cebc62b2-b1ef-48b4-8815-3d59f557291c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`c],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"F", 
          StyleBox[GridBox[{
             {" ", " "},
             {"b", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Cd[-$CellContext`a][
      $CellContext`F[-$CellContext`b, -$CellContext`c]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"F", 
        StyleBox[GridBox[{
           {" ", " "},
           {"b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`F[-$CellContext`b, -$CellContext`c],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {"c"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Cd[-$CellContext`a][
      $CellContext`v[$CellContext`c]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{3.728977588480983*^9},
 CellLabel->"Out[14]=",
 CellID->94542730,ExpressionUUID->"1c81698b-9f28-4553-aefb-c433f14b9e3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", " ", 
   RowBox[{"v", "[", "b", "]"}]}], "//", "Simplification"}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"80c61803-d97e-40f7-84bb-9afdfe0934e9"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"F", 
       StyleBox[GridBox[{
          {" ", " "},
          {"b", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`F[-$CellContext`b, -$CellContext`c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {"c"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Cd[-$CellContext`a][
     $CellContext`v[$CellContext`c]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{3.7289775891127853`*^9},
 CellLabel->"Out[15]=",
 CellID->170734857,ExpressionUUID->"288343d5-ce25-4c41-bcd1-211a6280a42e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The tensors have been defined with their expected symmetries:\
\>", "MathCaption",ExpressionUUID->"93dd870e-0f51-4948-a667-ca0fc7cbfaf7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RiemannCd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
   RowBox[{"RiemannCd", "[", 
    RowBox[{
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}]}], "//", 
  "Simplification"}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"1a9c7bde-e83e-4455-a414-9c8430fec8ec"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.7289775911757*^9},
 CellLabel->"Out[16]=",
 CellID->1527135633,ExpressionUUID->"b02ea8d3-2324-463b-ab74-25874d16cf63"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
but it is possible to deduce them from more basic principles:\
\>", "MathCaption",ExpressionUUID->"8dd8161c-5d40-40c2-aeac-7216f5523a2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RiemannCd", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
    RowBox[{"RiemannCd", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}], ",", "d"}], "]"}]}], "//", "RiemannToChristoffel"}],
   "//", "Simplification"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"11a3a435-4ae6-42db-bdea-c0e37b4d6181"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.728977592291641*^9},
 CellLabel->"Out[17]=",
 CellID->1550310597,ExpressionUUID->"40d712c8-5e76-454e-abf2-344a3f6e3f03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RiemannCd", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
    RowBox[{"RiemannCd", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", "d"}], "]"}], "+", 
    RowBox[{"RiemannCd", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "d"}], "]"}]}], "//", "RiemannToChristoffel"}],
   "//", "Simplification"}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"04ae657f-ef8f-481b-90f2-04e18cd0faa3"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.72897759312184*^9},
 CellLabel->"Out[18]=",
 CellID->1920925839,ExpressionUUID->"c65979cb-e594-4aa7-bff5-d9b4ebba6cfa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check of the second Bianchi identity:", "MathCaption",ExpressionUUID->"f2445a32-362f-49d2-9e09-ba5fd0af47d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Antisymmetrize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "e"}], "]"}], "[", 
    RowBox[{"RiemannCd", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "e"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"6dddded9-a24e-4f60-bf55-ca1d47508409"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", "a"},
             {"d", "e", "b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Cd[-$CellContext`c][
      $CellContext`RiemannCd[-$CellContext`d, -$CellContext`e, \
-$CellContext`b, $CellContext`a]],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", "a"},
             {"e", "d", "b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Cd[-$CellContext`c][
      $CellContext`RiemannCd[-$CellContext`e, -$CellContext`d, \
-$CellContext`b, $CellContext`a]],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", "a"},
             {"c", "e", "b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Cd[-$CellContext`d][
      $CellContext`RiemannCd[-$CellContext`c, -$CellContext`e, \
-$CellContext`b, $CellContext`a]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", "a"},
             {"e", "c", "b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Cd[-$CellContext`d][
      $CellContext`RiemannCd[-$CellContext`e, -$CellContext`c, \
-$CellContext`b, $CellContext`a]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", "a"},
             {"c", "d", "b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Cd[-$CellContext`e][
      $CellContext`RiemannCd[-$CellContext`c, -$CellContext`d, \
-$CellContext`b, $CellContext`a]],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {" ", " ", " ", "a"},
             {"d", "c", "b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Cd[-$CellContext`e][
      $CellContext`RiemannCd[-$CellContext`d, -$CellContext`c, \
-$CellContext`b, $CellContext`a]],
     Editable->False]}], ")"}]}]], "Output",
 CellChangeTimes->{3.728977594674554*^9},
 CellLabel->"Out[19]=",
 CellID->668680751,ExpressionUUID->"726abc39-2aa2-4162-a69a-986a72514773"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "%"}], "//", "Simplification"}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"6863af84-7e1b-4a1b-9378-08de11211671"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"d", "e", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Cd[-$CellContext`c][
    $CellContext`RiemannCd[-$CellContext`d, -$CellContext`e, -$CellContext`b, \
$CellContext`a]],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"c", "e", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Cd[-$CellContext`d][
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`e, -$CellContext`b, \
$CellContext`a]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"c", "d", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Cd[-$CellContext`e][
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
$CellContext`a]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289775953432837`*^9},
 CellLabel->"Out[20]=",
 CellID->904014618,ExpressionUUID->"bc3317e6-ea2a-45cf-98e4-2816c9180f38"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "CovDToChristoffel"}]], "Input",
 CellLabel->"In[21]:=",ExpressionUUID->"ae6f8bce-4062-45bc-9de5-24742e3cb5d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "e", "e$2842"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e$2842],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "e$2842"},
           {"c", "d", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
$CellContext`e$2842],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e$2843", " ", " "},
           {" ", "e", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e$2843, -$CellContext`e, \
-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"c", "d", "e$2843", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`d, \
-$CellContext`e$2843, $CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "d", "e$2833"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e$2833],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "e$2833"},
           {"c", "e", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`e, -$CellContext`b, \
$CellContext`e$2833],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e$2834", " ", " "},
           {" ", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e$2834, -$CellContext`d, \
-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"c", "e", "e$2834", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`e, \
-$CellContext`e$2834, $CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e$2836", " ", " "},
           {" ", "d", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e$2836, -$CellContext`d, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"c", "e$2836", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`e$2836, \
-$CellContext`b, $CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e$2845", " ", " "},
           {" ", "e", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e$2845, -$CellContext`e, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"c", "e$2845", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`e$2845, \
-$CellContext`b, $CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "c", "e$2824"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e$2824],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "e$2824"},
           {"d", "e", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`d, -$CellContext`e, -$CellContext`b, \
$CellContext`e$2824],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e$2825", " ", " "},
           {" ", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e$2825, -$CellContext`c, \
-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"d", "e", "e$2825", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`d, -$CellContext`e, \
-$CellContext`e$2825, $CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e$2827", " ", " "},
           {" ", "c", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e$2827, -$CellContext`c, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"d", "e$2827", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`d, -$CellContext`e$2827, \
-$CellContext`b, $CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e$2826", " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e$2826, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"e$2826", "e", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`e$2826, -$CellContext`e, \
-$CellContext`b, $CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e$2835", " ", " "},
           {" ", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e$2835, -$CellContext`d, \
-$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"e$2835", "e", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`e$2835, -$CellContext`e, \
-$CellContext`b, $CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e$2844", " ", " "},
           {" ", "e", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e$2844, -$CellContext`e, \
-$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"e$2844", "d", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`e$2844, -$CellContext`d, \
-$CellContext`b, $CellContext`a],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "c"], GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"d", "e", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`c][
    $CellContext`RiemannCd[-$CellContext`d, -$CellContext`e, -$CellContext`b, \
$CellContext`a]],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "d"], GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"c", "e", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`d][
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`e, -$CellContext`b, \
$CellContext`a]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "e"], GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "a"},
           {"c", "d", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`e][
    $CellContext`RiemannCd[-$CellContext`c, -$CellContext`d, -$CellContext`b, \
$CellContext`a]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977597281951*^9},
 CellLabel->"Out[21]=",
 CellID->1314426350,ExpressionUUID->"2cd089c2-762c-4ee3-a704-c928c26b9289"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "RiemannToChristoffel"}], "//", 
  "ScreenDollarIndices"}]], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"2d413902-e71d-4cdd-adbf-cb5808b0d9b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"e1", " ", " "},
            {" ", "e", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`b],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "c"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"a", " ", " "},
            {" ", "d", "e1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`c][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e1]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "c"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"a", " ", " "},
            {" ", "e", "e1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`c][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e1]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "e", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "c"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"e1", " ", " "},
            {" ", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`c][
     $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`b]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "d", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "c"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"e1", " ", " "},
            {" ", "e", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`c][
     $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`b]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "c"], 
     SubscriptBox["\[PartialD]", "d"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "e", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`c][
    xAct`xTensor`PD[-$CellContext`d][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`b]]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "c"], 
     SubscriptBox["\[PartialD]", "e"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`c][
    xAct`xTensor`PD[-$CellContext`e][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`b]]],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "e", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "d"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"a", " ", " "},
            {" ", "c", "e1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`d][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e1]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "e", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "d", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "c", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`c, \
-$CellContext`e1],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "c", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "d", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`d, \
-$CellContext`e1],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "c"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "d", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`c][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e1]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "d"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "c", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`d][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e1]],
      Editable->False]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "d"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"a", " ", " "},
            {" ", "e", "e1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`d][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e1]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "e", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "d"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"e1", " ", " "},
            {" ", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`d][
     $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`b]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "e", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e1],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "d", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "c", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`c, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "c", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`d, \
-$CellContext`b],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "c"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`c][
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`b]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "d"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "c", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`d][
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`b]],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "c", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "d"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"e1", " ", " "},
            {" ", "e", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`d][
     $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`b]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "d"], 
     SubscriptBox["\[PartialD]", "c"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "e", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`d][
    xAct`xTensor`PD[-$CellContext`c][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`b]]],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "d"], 
     SubscriptBox["\[PartialD]", "e"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`d][
    xAct`xTensor`PD[-$CellContext`e][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`b]]],
   Editable->False], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "e"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"a", " ", " "},
            {" ", "c", "e1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`e][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e1]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "c", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`c, \
-$CellContext`e1],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "c", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e, \
-$CellContext`e1],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "c"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`c][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e1]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "c", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e1]],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "e"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"a", " ", " "},
            {" ", "d", "e1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`e][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e1]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "d", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`d, \
-$CellContext`e1],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "d", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e, \
-$CellContext`e1],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "d"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`d][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e1]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "d", "e1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e1]],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "d", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "e"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"e1", " ", " "},
            {" ", "c", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`e][
     $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`b]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "d", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e1],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "e", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "c", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`c, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "c", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e, \
-$CellContext`b],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "c"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "e", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`c][
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`b]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "c", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e][
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`b]],
      Editable->False]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "c", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "e"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
         StyleBox[GridBox[{
            {"e1", " ", " "},
            {" ", "d", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`e][
     $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`b]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "c", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e1],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "e", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`d, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "d", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e, \
-$CellContext`b],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "d"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "e", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`d][
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`b]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e1", " ", " "},
              {" ", "d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e][
       $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`b]],
      Editable->False]}], ")"}]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "e"], 
     SubscriptBox["\[PartialD]", "c"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "d", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`e][
    xAct`xTensor`PD[-$CellContext`c][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`b]]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "e"], 
     SubscriptBox["\[PartialD]", "d"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "c", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`e][
    xAct`xTensor`PD[-$CellContext`d][
     $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`b]]],
   Editable->False], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "d", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`e],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e1", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "c", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`c, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "c", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e1, \
-$CellContext`b],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "c"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`c][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`b]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e1"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "c", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e1][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`b]],
      Editable->False]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "e", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`d],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e1", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "c", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`c, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "c", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e1, \
-$CellContext`b],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "c"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`c][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`b]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e1"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "c", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e1][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`c, \
-$CellContext`b]],
      Editable->False]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "e", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`e, \
-$CellContext`c],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", " ", " "},
               {" ", "e1", "e2"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`e2],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`d, \
-$CellContext`b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "d", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e1, \
-$CellContext`b],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "d"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`d][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`b]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e1"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e1][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`b]],
      Editable->False]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "c", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`e],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e1", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`d, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "d", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e1, \
-$CellContext`b],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "d"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`d][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`b]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e1"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "d", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e1][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`d, \
-$CellContext`b]],
      Editable->False]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "c", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`c, \
-$CellContext`d],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", " ", " "},
               {" ", "e1", "e2"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`e2],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e, \
-$CellContext`b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e1, \
-$CellContext`b],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`b]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e1"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e1][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`b]],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "d", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCd[$CellContext`e1, -$CellContext`d, \
-$CellContext`c],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", " ", " "},
               {" ", "e1", "e2"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`e2],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e, \
-$CellContext`b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e", "e2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`e2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"e2", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCd[$CellContext`e2, -$CellContext`e1, \
-$CellContext`b],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e1", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e1, \
-$CellContext`b]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[PartialD]", "e1"], GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "e", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`PD[-$CellContext`e1][
       $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`e, \
-$CellContext`b]],
      Editable->False]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.728977598133354*^9},
 CellLabel->"Out[22]=",
 CellID->582528635,ExpressionUUID->"25be150a-b1e1-4eb5-9854-99f870cd86e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplification", "[", "%", "]"}], "//", 
  "AbsoluteTiming"}]], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"d823ac90-1c4b-4d64-bf23-46879bb96cad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.174235`", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.728977599928913*^9},
 CellLabel->"Out[23]=",
 CellID->112544729,ExpressionUUID->"2ca7c995-2ce7-4fe5-89cf-c8aa071b9346"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Commutation of covariant derivatives. It is possible to choose the indices \
(use ",
 StyleBox["CommuteCovDs",
  FontFamily->"Courier"],
 ") or just let ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " to bring the derivative indices into canonical order (use \[LineSeparator]",
 StyleBox["SortCovDs",
  FontFamily->"Courier"],
 "):"
}], "MathCaption",ExpressionUUID->"4d7774b3-33c3-457c-be81-ab513a1cd1a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cd", "[", 
   RowBox[{"-", "a"}], "]"}], "@", 
  RowBox[{
   RowBox[{"Cd", "[", 
    RowBox[{"-", "b"}], "]"}], "@", 
   RowBox[{"v", "[", "c", "]"}]}]}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"c94edf35-faa8-4fd7-8444-acc6ad3f86f9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[EmptyDownTriangle]", "a"], 
    SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"c"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Cd[-$CellContext`a][
   $CellContext`Cd[-$CellContext`b][
    $CellContext`v[$CellContext`c]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289776028339863`*^9},
 CellLabel->"Out[24]=",
 CellID->1474478125,ExpressionUUID->"a1983510-b84c-48f2-801d-6560ef830e6d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CommuteCovDs", "[", 
   RowBox[{"%", ",", "Cd", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "a"}]}], "}"}]}], "]"}], "//", 
  "ScreenDollarIndices"}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"cb171f09-f5a5-440e-9e92-c9952c3f6c7b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "c"},
           {"b", "a", "d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"d"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`d],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[EmptyDownTriangle]", "b"], 
     SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Cd[-$CellContext`b][
    $CellContext`Cd[-$CellContext`a][
     $CellContext`v[$CellContext`c]]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977603548317*^9},
 CellLabel->"Out[25]=",
 CellID->603282111,ExpressionUUID->"5c8fbeca-a455-4972-9450-e02b2b6de003"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SortCovDs", "[", "%%", "]"}], "//", 
  "ScreenDollarIndices"}]], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"1b96d04a-0ec9-47a2-bdae-5d5758cf4214"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "c"},
           {"b", "a", "d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCd[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"d"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[$CellContext`d],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[EmptyDownTriangle]", "b"], 
     SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Cd[-$CellContext`b][
    $CellContext`Cd[-$CellContext`a][
     $CellContext`v[$CellContext`c]]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977604234456*^9},
 CellLabel->"Out[26]=",
 CellID->1412296109,ExpressionUUID->"37cab0ed-b2d1-4d83-bc57-a414052bcace"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Now we introduce a metric on the manifold. Its associated curvature tensors \
are defined: ",
 StyleBox["RiemannCD",
  FontFamily->"Courier"],
 ", ",
 StyleBox["RiciCD",
  FontFamily->"Courier"],
 ", ",
 StyleBox["EinsteinCD",
  FontFamily->"Courier"],
 ", etc:"
}], "Text",ExpressionUUID->"51e18220-a1c8-4ed2-b295-357653e5fbaf"],

Cell[CellGroupData[{

Cell[TextData[{
 "Define the metric ",
 StyleBox["g",
  FontFamily->"Courier"],
 ", with negative determinant. Its Levi-Civita connection will be called ",
 StyleBox["CD",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"3271f7c4-a29c-4892-8b8b-ec36185f6654"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"SymbolOfCovD", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<|\>\"", ",", "\"\<D\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"ac761454-d7f9-4d33-9eed-0dad0b039e15"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977605760187*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->60842753,ExpressionUUID->"cd4a8451-9375-48df-a0eb-8a364f4841e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977605777892*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->381933699,ExpressionUUID->"6bff225e-8ec5-43b9-ab2f-57985493db0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977605796771*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->331058210,ExpressionUUID->"5fbc85a6-50d0-40e5-968d-e37598c06121"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977605817031*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->2112689740,ExpressionUUID->"514c17b8-75ef-4170-b500-49b022339039"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977605836664*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->1481840682,ExpressionUUID->"876ec043-77b4-46ab-a983-87051b44317f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977605856462*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->928488115,ExpressionUUID->"c25eacb1-13f8-491e-9f34-482431b3227e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977605875146*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->1483569703,ExpressionUUID->"e24d0c23-7a7d-40b9-9ab7-15e0b71d2165"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellChangeTimes->{3.7289776058945932`*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->2070856651,ExpressionUUID->"9b1348f6-aaf0-49f8-8d89-8b310913d49c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977605915947*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->620266428,ExpressionUUID->"8aff0875-f24a-4b75-ad64-a11d063fb7d8"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellChangeTimes->{3.7289776059368057`*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->932232858,ExpressionUUID->"5f799f0e-b882-4d37-92d1-0033bbfbed60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977605956944*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->2144439541,ExpressionUUID->"4883ee58-57ef-4a85-b54b-03e1edf78e1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776059788027`*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->377317986,ExpressionUUID->"10d712eb-17e0-41d0-b476-672ea12170b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977606000885*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->64181111,ExpressionUUID->"bf248ee2-2699-41b2-9513-57190ffb4409"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977606021306*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->655141783,ExpressionUUID->"e7295a78-6d23-491e-9f21-6f252da0b3e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977606041692*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->819288712,ExpressionUUID->"cc479cf0-18e6-4b31-a4e2-30bf036da699"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977606061721*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->120238020,ExpressionUUID->"7fd59c0a-7e0f-4627-ba0d-efd4564d1800"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977606082439*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->58290313,ExpressionUUID->"8d634f01-72dc-4572-866f-3c47ad9863f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897760610283*^9},
 CellLabel->"During evaluation of In[27]:=",
 CellID->432747559,ExpressionUUID->"d3012688-4195-4d92-a883-598285d5af02"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Standard properties of the metric and its associated objects:\
\>", "MathCaption",ExpressionUUID->"a0034d48-2255-40ac-abff-8e8cefcfa0cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CD", "[", 
   RowBox[{"-", "a"}], "]"}], "[", " ", 
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}], " ", "]"}]], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"e931d299-b6fe-4d3c-93bd-cf0902fb6299"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.728977608043634*^9},
 CellLabel->"Out[28]=",
 CellID->994858890,ExpressionUUID->"f541b0d6-0f48-4277-8807-48b4859e9d62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CD", "[", 
   RowBox[{"-", "a"}], "]"}], "[", " ", 
  RowBox[{"EinsteinCD", "[", 
   RowBox[{"a", ",", "b"}], "]"}], " ", "]"}]], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"c17da91a-18b8-44db-a347-2cdcb8ab1800"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.728977608869609*^9},
 CellLabel->"Out[29]=",
 CellID->945402066,ExpressionUUID->"3f28828a-aa7e-45e8-9197-8f9f556c3ea9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "a"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"12cb5df4-aab9-4a7f-a5b8-4e3f3fd5e041"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.728977609716557*^9},
 CellLabel->"Out[30]=",
 CellID->2032759218,ExpressionUUID->"430ca87d-03b6-4250-adbd-dbc43d3bb04c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"a", ",", "b"}], "]"}], 
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}]}], "]"}]}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"e6d23bb3-801f-4340-925c-9fa6adb26f72"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Delta]", 
      StyleBox[GridBox[{
         {" ", "a"},
         {"c", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`delta[-$CellContext`c, $CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.72897761048624*^9},
 CellLabel->"Out[31]=",
 CellID->1928400476,ExpressionUUID->"6af945d8-0592-445c-b8f3-000e55be5d3d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Let us check the antisymmetry of the second pair of indices in the Riemann \
tensor:\
\>", "MathCaption",ExpressionUUID->"17a21e64-ee23-46dc-b27f-a0e8c5598a4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannCD", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}]}], "]"}], "+", 
  RowBox[{"RiemannCD", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "d"}], ",", 
    RowBox[{"-", "c"}]}], "]"}]}]], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"3f44d07e-b351-4f9f-876b-b747f7d0ebd0"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "D", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "c", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "D", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"a", "b", "d", "c"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`d, \
-$CellContext`c],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977615082753*^9},
 CellLabel->"Out[32]=",
 CellID->773979084,ExpressionUUID->"9adf5748-ee7d-4a27-b08e-44fb57a1214f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Because canonicalization is not automatic, the previous expression is not \
automatically zero. We expand it in derivatives of Christoffels and \
canonicalize. The partial derivative does not commute with the metric, so \
that internally the code replaces temporarily those derivatives with \
Levi-Civita connections:\
\>", "MathCaption",ExpressionUUID->"a9007a20-2ac3-4bae-ab9f-f32f221dc61a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "RiemannToChristoffel"}], "//", "Simplification"}], "//",
   "ScreenDollarIndices"}]], "Input",
 CellLabel->"In[33]:=",ExpressionUUID->"4d13ad75-10b3-453f-bf3b-dcfbbc50d6f2"],

Cell[BoxData[
 TemplateBox[{
  "ToCanonical", "cmods", 
   "\"Detected metric-incompatible derivatives \\!\\(\\*RowBox[{\\\"{\\\", \\\
\"PD\\\", \\\"}\\\"}]\\).\"", 2, 33, 3, 19253573948027831207, "Local", 
   "xAct`xTensor`ToCanonical"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977616773161*^9},
 CellLabel->"During evaluation of In[33]:=",
 CellID->901495669,ExpressionUUID->"3ebbfba0-68a6-4c4c-ae0e-5e8770c0a313"],

Cell[BoxData[
 TemplateBox[{
  "ToCanonical", "cmods", 
   "\"Detected metric-incompatible derivatives \\!\\(\\*RowBox[{\\\"{\\\", \\\
\"PD\\\", \\\"}\\\"}]\\).\"", 2, 33, 4, 19253573948027831207, "Local", 
   "xAct`xTensor`ToCanonical"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977616828382*^9},
 CellLabel->"During evaluation of In[33]:=",
 CellID->940579298,ExpressionUUID->"3109e3f3-3662-49e9-9ca7-d57187803cea"],

Cell[BoxData[
 TemplateBox[{
  "ToCanonical", "cmods", 
   "\"Detected metric-incompatible derivatives \\!\\(\\*RowBox[{\\\"{\\\", \\\
\"PD\\\", \\\"}\\\"}]\\).\"", 2, 33, 5, 19253573948027831207, "Local", 
   "xAct`xTensor`ToCanonical"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.7289776169045067`*^9},
 CellLabel->"During evaluation of In[33]:=",
 CellID->689135919,ExpressionUUID->"e1c40249-2ec5-496f-9f12-dc516588d066"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"ToCanonical\\\", \\\"::\
\\\", \\\"cmods\\\"}], \\\"MessageName\\\"]\\) will be suppressed during this \
calculation.\"", 2, 33, 6, 19253573948027831207, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.728977616931631*^9},
 CellLabel->"During evaluation of In[33]:=",
 CellID->928082362,ExpressionUUID->"b59aac10-b288-4ec5-a390-2d93b0189ed0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "e"},
           {"d", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`b, \
$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"e", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`e, -$CellContext`a, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "e"},
           {"c", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`b, \
$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"e", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`e, -$CellContext`a, \
-$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "e"},
           {"d", "a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`a, \
$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"e", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`e, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "e"},
           {"c", "a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`a, \
$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"e", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`e, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e", " ", " "},
           {" ", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e, -$CellContext`b, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "a", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e1, -$CellContext`a, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`c, -$CellContext`e1],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e", " ", " "},
           {" ", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e, -$CellContext`a, \
-$CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "b", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e1, -$CellContext`b, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"c", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`c, -$CellContext`e1],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e", " ", " "},
           {" ", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e, -$CellContext`b, \
-$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "a", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e1, -$CellContext`a, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`d, -$CellContext`e1],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e", " ", " "},
           {" ", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e, -$CellContext`a, \
-$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e1", " ", " "},
           {" ", "b", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e1, -$CellContext`b, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"d", "e1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`d, -$CellContext`e1],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "a"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"c", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`a][
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`b, \
-$CellContext`d]],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "a"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"d", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`a][
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`b, \
-$CellContext`c]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "b"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"c", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`b][
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`a, \
-$CellContext`d]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "b"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"d", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`b][
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`a, \
-$CellContext`c]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289776170000973`*^9},
 CellLabel->"Out[33]=",
 CellID->1106529973,ExpressionUUID->"17eb4c04-ed79-44dd-a6f5-b598c1fb6b10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Metric contraction is not automatic either. The resulting expression is not \
obviously zero:\
\>", "MathCaption",ExpressionUUID->"9acd67ce-9b8f-4773-bd43-7d014da9f836"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "ContractMetric"}], "//", "Simplification"}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"d29c4f3d-bc25-43f4-9a45-f6305c49c24c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "a"], GridBox[{
        {
         RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
         StyleBox[GridBox[{
            {" ", " ", " "},
            {"c", "b", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`a][
     $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`b, \
-$CellContext`d]],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "a"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"d", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`a][
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`b, \
-$CellContext`c]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "b"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"c", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`b][
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`a, \
-$CellContext`d]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "b"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"d", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`b][
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`a, \
-$CellContext`c]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289776188033953`*^9},
 CellLabel->"Out[34]=",
 CellID->1308641128,ExpressionUUID->"c13f4b23-11c7-43c5-8278-4ec635c0f151"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Actually it is only zero for connections deriving from a metric:\
\>", "MathCaption",ExpressionUUID->"71998cc3-cd1d-4173-88eb-8ca18b5a5173"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "ChristoffelToGradMetric"}], "//", "Expand"}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"ea659810-066e-48e3-8459-279068cdef0b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "a"], 
      SubscriptBox["\[PartialD]", "b"], GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`a][
     xAct`xTensor`PD[-$CellContext`b][
      $CellContext`g[-$CellContext`c, -$CellContext`d]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "a"], 
      SubscriptBox["\[PartialD]", "b"], GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`a][
     xAct`xTensor`PD[-$CellContext`b][
      $CellContext`g[-$CellContext`d, -$CellContext`c]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "b"], 
      SubscriptBox["\[PartialD]", "a"], GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"c", "d"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`b][
     xAct`xTensor`PD[-$CellContext`a][
      $CellContext`g[-$CellContext`c, -$CellContext`d]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[PartialD]", "b"], 
      SubscriptBox["\[PartialD]", "a"], GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"d", "c"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`PD[-$CellContext`b][
     xAct`xTensor`PD[-$CellContext`a][
      $CellContext`g[-$CellContext`d, -$CellContext`c]]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.7289776201840467`*^9},
 CellLabel->"Out[35]=",
 CellID->1675831686,ExpressionUUID->"9851259a-4014-4d4b-b3a6-fb13c32eaf04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplification"}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"765c0c44-a175-4bd6-aade-764ecee082b1"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.7289776209335938`*^9},
 CellLabel->"Out[36]=",
 CellID->1541888581,ExpressionUUID->"6f9dafc6-7ca6-4916-9e22-43a8e646edf0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
In this case a simple reordering of the partial derivatives (this is not \
automatic) would have been enough:\
\>", "MathCaption",ExpressionUUID->"4d479e15-4ba2-4b16-8537-f5dd10af7403"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%%", "//", "SortCovDs"}]], "Input",
 CellLabel->"In[37]:=",ExpressionUUID->"084f69a4-8874-48c6-9086-571b72382de7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.728977622139701*^9},
 CellLabel->"Out[37]=",
 CellID->588011226,ExpressionUUID->"0fc2aabc-9475-44b8-b32d-78834a554db7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples of Lie derivative and bracket:", "MathCaption",ExpressionUUID->"db3e68e8-3010-4329-979f-789cb337196a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LieD", "[", 
   RowBox[{"3", 
    RowBox[{"v", "[", "a", "]"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"F", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], 
   RowBox[{"v", "[", "b", "]"}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",ExpressionUUID->"abdd0cc2-c5c4-4a11-bf96-26120436579b"],

Cell[BoxData[
 RowBox[{"3", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[ScriptCapitalL]", "v"], GridBox[{
        {"F", 
         StyleBox[GridBox[{
            {" ", " "},
            {"a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`LieD[
     $CellContext`v[$CellContext`a]][
     $CellContext`F[-$CellContext`a, -$CellContext`b]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{3.728977623367653*^9},
 CellLabel->"Out[38]=",
 CellID->887726534,ExpressionUUID->"7683e2d6-d063-4c43-bd0b-37b4b87caf19"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Bracket", "[", 
   RowBox[{
    RowBox[{"v", "[", "a", "]"}], ",", 
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"v", "[", "b", "]"}]}]}], "]"}], "[", "a", "]"}]], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"1bbfeb63-fe02-4dd5-90f1-24f64e4f141c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"[", GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], ",", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"F", 
             StyleBox[GridBox[{
                {"a", " "},
                {" ", "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`F[$CellContext`a, -$CellContext`b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[$CellContext`b],
         Editable->False]}], "]"}], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Bracket[
   $CellContext`v[$CellContext`a], $CellContext`F[$CellContext`a, \
-$CellContext`b] $CellContext`v[$CellContext`b]][$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289776241010838`*^9},
 CellLabel->"Out[39]=",
 CellID->207576009,ExpressionUUID->"2ac1cfa7-707c-4ca0-ab41-9e276c415056"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Undefine all objects on the manifold and the manifold itself:\
\>", "MathCaption",ExpressionUUID->"3f77be99-090a-49e6-b0c5-bb118d0b1692"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefMetric", "[", "g", "]"}]], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"abeaa576-2e54-4724-9711-781417301268"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Detg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "weight +2 density", 
   " ", $CellContext`Detg],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776253131*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->1828814815,ExpressionUUID->"3a29ab3d-9582-41e9-b8ea-a295e535af89"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977625331307*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->2104639841,ExpressionUUID->"48cff370-5f01-49b5-a6a2-f99863def3c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "EinsteinCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Einstein tensor", " ", $CellContext`EinsteinCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977625350045*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->1478657950,ExpressionUUID->"09cfae9b-700a-4eef-9153-05e38e820a3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "KretschmannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Kretschmann scalar", 
   " ", $CellContext`KretschmannCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776253719397`*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->1123402566,ExpressionUUID->"dba1c412-6958-4141-af3d-bf8af67bf99c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric Ricci tensor", 
   " ", $CellContext`RicciCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776253898783`*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->350702338,ExpressionUUID->"d59ed287-1150-420e-9b0e-e534ffe442ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciScalarCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci scalar", 
   " ", $CellContext`RicciScalarCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977625411035*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->1559067398,ExpressionUUID->"7ac86513-5211-4652-9b5c-ac92ee705cf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977625432012*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->1797781139,ExpressionUUID->"0161eb23-2136-4ae0-9553-4238645f5e8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TFRicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric TFRicci tensor",
    " ", $CellContext`TFRicciCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977625451996*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->212689883,ExpressionUUID->"2c3c0f16-270b-4dc9-a3ed-9586f457b607"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977625473542*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->1266074973,ExpressionUUID->"e7809ed8-dbb8-4cea-9717-950f98cbf247"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "WeylCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl tensor", 
   " ", $CellContext`WeylCD],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977625494875*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->1654096735,ExpressionUUID->"84270404-7932-4fcc-b76d-c401e8c5fa07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CD],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776255162086`*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->1228014730,ExpressionUUID->"d0e91fcb-64c8-4210-b4fc-1f3d772ff66e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "epsilong"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric tensor", 
   " ", $CellContext`epsilong],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897762553723*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->1925719440,ExpressionUUID->"dbfea2e9-e9bb-45e6-8527-48bad9dee745"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "g"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric metric tensor", 
   " ", $CellContext`g],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977625560272*^9},
 CellLabel->"During evaluation of In[40]:=",
 CellID->840584143,ExpressionUUID->"4245844c-4c89-43fd-a30d-817c279304d4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"UndefTensor", "/@", 
   RowBox[{"{", 
    RowBox[{"v", ",", "F"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"UndefCovD", "[", "Cd", "]"}]}], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"91e11ed1-820b-4c86-89df-2be8b24baa86"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "v"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`v],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897762647059*^9},
 CellLabel->"During evaluation of In[41]:=",
 CellID->1457251913,ExpressionUUID->"e9715e34-33d3-4607-8ff6-7438d65a1aa6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "F"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`F],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977626487185*^9},
 CellLabel->"During evaluation of In[41]:=",
 CellID->2129391403,ExpressionUUID->"1418575a-76a2-44c3-b12b-e04cb38f80a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelCd],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977626505556*^9},
 CellLabel->"During evaluation of In[41]:=",
 CellID->866332966,ExpressionUUID->"ca333a7e-fc91-43a0-a37c-fedf286fdeb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Ricci tensor", " ", $CellContext`RicciCd],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977626523974*^9},
 CellLabel->"During evaluation of In[41]:=",
 CellID->519032902,ExpressionUUID->"9bdb7152-61f3-4137-b7a5-6f8a1be95005"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCd],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776265424023`*^9},
 CellLabel->"During evaluation of In[41]:=",
 CellID->307409800,ExpressionUUID->"50a7d844-5da4-41ee-8c0f-1b760a96adf2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCd],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977626563184*^9},
 CellLabel->"During evaluation of In[41]:=",
 CellID->1938337565,ExpressionUUID->"5e36962d-7b18-4d18-a363-9076df425baf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Cd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`Cd],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977626584396*^9},
 CellLabel->"During evaluation of In[41]:=",
 CellID->312529965,ExpressionUUID->"ac560e78-b987-458f-a447-57c1f6c03c6b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "M3", "]"}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"5a9af476-fba0-4d6d-a72e-c1eabd4c9ce8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M3",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM3,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM3],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776278574057`*^9},
 CellLabel->"During evaluation of In[43]:=",
 CellID->132224728,ExpressionUUID->"543a0863-baf2-4e44-87b4-8a91dc82adb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M3"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M3],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776278788967`*^9},
 CellLabel->"During evaluation of In[43]:=",
 CellID->1802912498,ExpressionUUID->"a8f07585-618c-4e5a-befa-d81792a06a29"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "There are no symbols left in the ",
 StyleBox["Global`",
  FontFamily->"Courier"],
 " context"
}], "MathCaption",ExpressionUUID->"701669b9-41a3-46d5-abd1-294561a8e615"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"e8679f61-e704-4ff9-a662-fa5da7ef1d14"],

Cell["Global`$UseTextSearchQ", "Print", "PrintUsage",
 CellChangeTimes->{3.7289776289837217`*^9},
 CellTags->"Info443728981228-9181623",
 CellID->1995674241,ExpressionUUID->"94eae8c2-9b3a-4e88-b43e-adc509ad506c"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["0.2. Summary", "Subsection",ExpressionUUID->"5889dd12-3523-4e67-99cd-4929c03562c1"],

Cell[TextData[{
 "These are the objects that currently can be defined in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ".\n\t- Manifolds\n\t- Mappings\n\t- Vector bundles\n\t- Indices (of \
different types)\n\t- Tensors (in particular, Metrics)\n\t- Covariant \
derivative operators (including partial derivatives)\n\t- Constant symbols\n\t\
- Parameters\n\t- Inert heads (wrappers for tensors)\n\t- Scalar functions\n\t\
- Charts (coordinate systems): use the twin package ",
 StyleBox["xCoba` ",
  FontFamily->"Courier"],
 "(in collaboration with D. Yllanes)\n\t- Bases (frames): use the twin \
package ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 "\nWe also have predefined mathematical operators:\n\t- Lie derivative\n\t- \
Lie bracket\n\t- Parametric derivative\n\t- Variational derivative\nand \
useful mathematical operations:\n\t- Relations and rules among indexed \
objects\n\t- Indexed equations solving\n\t- Canonicalization and \
simplification of expressions\n\t- Automatic definition of curvature tensors, \
and relations among them\n\t- Complex conjugation\nThere are also specialized \
algorithms, frequently used in General Relativity:\n\t- Warped metric \
decomposition\n\t- ADM-like decomposition\n\t- Perturbation theory in General \
Relativity: use the twin package ",
 StyleBox["xPert` ",
  FontFamily->"Courier"],
 "(in collaboration with D. Brizuela and G. Mena Marug\[AAcute]n)\n\t- \
Spherical tensor harmonics: use the twin package ",
 StyleBox["Harmonics` ",
  FontFamily->"Courier"],
 "(in collaboration with D. Brizuela and G. Mena Marug\[AAcute]n)\n\t- \
Manipulation of invariants of the Riemann tensor: use the twin package ",
 StyleBox["Invar` ",
  FontFamily->"Courier"],
 "(in collaboration with R. Portugal, L. Manssur and D. Yllanes)\n\t- Spinor \
calculus (in collaboration with A. Garc\[IAcute]a-Parrado)"
}], "Text",ExpressionUUID->"6d0e05f7-f5f5-43a1-9fe1-f0b6022a9853"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.3. Getting info", "Subsection",ExpressionUUID->"49d482a0-f3b5-4c3e-8b1f-dc27e05614d1"],

Cell[CellGroupData[{

Cell[TextData[{
 "Every piece of information in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is associated to a symbol and can be obtained using the ",
 StyleBox["?",
  FontFamily->"Courier"],
 " and ",
 StyleBox["??",
  FontFamily->"Courier"],
 " symbols (see the command ",
 StyleBox["Information",
  FontFamily->"Courier"],
 " in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " help). ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " strictly follows that rule. (In particular, we have explicitly avoided \
notations based on string input/output which would require a parser, much \
restricting the capabilities of the user.)"
}], "Text",ExpressionUUID->"cd41f060-d80b-4635-8e01-65bab609a452"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DefManifold"}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"89d6fdb0-314a-4340-85fe-3cecc475cf03"],

Cell[BoxData["\<\"DefManifold[M, dim, {a, b, c,...}] defines M to be an \
n-dimensional differentiable manifold with dimension dim (a positive integer \
or a constant symbol) and tensor abstract indices a, b, c, ... .  \
DefManifold[M, {M1, ..., Mm}, {a, b, c,...}] defines M to be the product \
manifold of previously defined manifolds M1 ... Mm. For backward \
compatibility dim can be a list of positive integers, whose length is \
interpreted as the dimension of the defined manifold.\"\>"], "Print", \
"PrintUsage",
 CellChangeTimes->{3.728977653717033*^9},
 CellTags->"Info453728981253-9181623",
 CellID->1862154774,ExpressionUUID->"e4d5af28-bacd-48e1-a58c-0f67bfc59604"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "ERROR"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"fc20be92-4173-4af0-95d3-9b1a35edd183"],

Cell[CellGroupData[{

Cell[BoxData["\<\"ERROR[expr] is an expression where an error has been \
detected. ERROR is an inert head with a single argument.\"\>"], "Print", \
"PrintUsage",
 CellChangeTimes->{3.728977653918168*^9},
 CellTags->"Info463728981253-9181623",
 CellID->1956098887,ExpressionUUID->"61ca6cff-8a7c-4bca-b966-a93a55cad7c9"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "ERROR", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldFirst", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "ERROR", "]"}], "^=", 
         RowBox[{"{", 
          
          RowBox[{"\<\"inert head\"\>", 
           ",", "\<\"Generic head to wrap expressions with errors.\"\>"}], 
          "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"InertHeadQ", "[", "ERROR", "]"}], "^=", "True"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"LinearQ", "[", "ERROR", "]"}], "^=", "False"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "ERROR", "]"}], 
         "^=", "\<\"\\!\\(\\*StyleBox[\\\"ERROR\\\",FontColor->Hue[0.]]\\)\"\>\
"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[xAct`xTensor`ERROR],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776539419117`*^9},
 CellTags->"Info463728981253-9181623",
 CellID->326841886,ExpressionUUID->"560a3844-0f62-4961-bffb-79612314e255"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["0.4. Too many brackets!", "Subsection",ExpressionUUID->"421f06b6-b5e8-46e6-9b8c-07e14a614d08"],

Cell[TextData[{
 "This is a common complaint from most users after their first contact with \
",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ". My answer to that is the following:"
}], "Text",ExpressionUUID->"5cffb5aa-7bf8-46f7-9de6-c8a1c83f4f25"],

Cell[CellGroupData[{

Cell[TextData[{
 "1. That is how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " internally works. For example, did you expect this simple derivative \
having internally six pairs of brackets, when it has just one in the \
\"user-notation\"?"
}], "MathCaption",ExpressionUUID->"8f8513b0-163c-471e-a39e-3e01852ab6c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "'"}], "[", 
   RowBox[{
    RowBox[{"2", "x"}], "-", "y"}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"3483e09f-16f4-4b30-b162-c683f4ed5e3a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}], "[", 
    RowBox[{"Plus", "[", 
     RowBox[{
      RowBox[{"Times", "[", 
       RowBox[{"2", ",", "x"}], "]"}], ",", 
      RowBox[{"Times", "[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "y"}], "]"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellChangeTimes->{3.728977658205041*^9},
 CellLabel->"Out[47]//FullForm=",
 CellID->1240949882,ExpressionUUID->"6919d85c-3f2b-4b91-a9d2-0b8ac99f42b1"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "2. ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " does not have different internal and external notations (at least not \
now). This helps understanding what is happening internally and allows the \
user to build pattern rules which always work. However, you are continually \
exposed to the internal notation."
}], "MathCaption",ExpressionUUID->"4d9bf58f-f25b-4a42-b26d-97acdd4601dd"],

Cell[TextData[{
 "3. The highest accummulation of brackets happens in derivatives. This \
simply follows the general idea in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (made clear in the example above) of treating a derivative as an operator \
on an expression, and not as a simple additional argument of the expression, \
as the traditional \"comma-index\" notation might suggest."
}], "MathCaption",ExpressionUUID->"403cc0c0-39e7-440d-ac09-bfcd7e3d1699"],

Cell[TextData[{
 "4. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language is very similar to LISP, in which you have a lot of parenthesis."
}], "MathCaption",
 CellChangeTimes->{
  3.494606778168723*^9},ExpressionUUID->"36e8529a-7053-4ef3-a291-\
9628ad03698f"],

Cell[CellGroupData[{

Cell["\<\
5. If you are still not convinced by the previous three arguments, then I \
must say that it is possible to construct whatever other notation you like \
for a derivative, or for any other operator, and several examples of this are \
given in section 6.1 below.\
\>", "MathCaption",ExpressionUUID->"47104d1e-2ff2-4c2c-9286-76126b9bf7ee"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"f", ",", "x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"e615b8ea-04d7-41a0-8745-10fae41ccf8a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["0.5. Warnings", "Subsection",ExpressionUUID->"326cef8c-f330-45b8-9cd1-30477fc02a2d"],

Cell[TextData[{
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is a very powerful tool in the hands of an average ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " user, but could be difficult for an unexperienced ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " user. This is because I have not tried to hide ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " subtleties (like delayed assignments, unique symbols or upvalues), but \
rather I have tried to make as much use as possible of such powerful \
instruments. If you don't understand those three listed concepts, please \
spend some (not really much) time with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tutorial. It will pay off, even if you finally don't use ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 "."
}], "Text",ExpressionUUID->"795b24da-db86-46d7-acda-cf427ab5e34a"],

Cell[TextData[{
 "If you think you can do your tensor computation by hand in a few lines, \
then ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is probably too much. This system is designed to be efficient when \
developing big projects, not small computations: a general-purpose tensor \
computer algebra system always has hundreds of commands, and only big \
projects give you enough motivation to learn them."
}], "Text",ExpressionUUID->"23fc648e-4045-4311-b83d-7549addc71c7"],

Cell[TextData[{
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is a manipulator of abstract expressions. It does not compute (at least \
easily) the components of the Riemann tensor associated with a given matrix \
of metric components, and things like that. ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is specialized in the manipulation of identities obeyed by families of \
objects with some properties (like being antisymmetric). Many users feel \
dissapointed at the beginning because they were expecting component-type \
computations. Use the twin package ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 " for that."
}], "Text",ExpressionUUID->"9e78cb1c-454f-4695-b5d1-507e97f3f100"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Manifolds, vector bundles and parameters", "Section",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.7286627354220657`*^9, 3.728662748172317*^9}, {
  3.728664037492599*^9, 3.72866403885896*^9}, {3.7286704747855062`*^9, 
  3.728670480415387*^9}, {3.728670889883876*^9, 3.728670893540101*^9}, {
  3.728673410238123*^9, 3.728673425886174*^9}, {3.7289761721698513`*^9, 
  3.7289761765432653`*^9}, {3.728976277988899*^9, 3.728976287866613*^9}},
 FontSize->18,
 FontColor->GrayLevel[0],
 CellTags->{"S5.18.1", "1.4"},
 CellID->390546124,ExpressionUUID->"f7d60e03-9b2e-438d-919f-8d580da78398"],

Cell[CellGroupData[{

Cell["1.1. Define a manifold and its tangent bundle", "Subsection",ExpressionUUID->"e8030db3-1fe6-4a08-824b-ae44525c0ac0"],

Cell[TextData[{
 "Just after loading,  ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " does not have any manifold defined. Here we see how to declare our own \
abstract manifolds, on which tensor fields will be defined."
}], "Text",ExpressionUUID->"0e6cf3af-6b03-4690-9088-015deab2bb53"],

Cell[TextData[{
 StyleBox[ButtonBox["DefManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefManifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Define a manifold or a product of manifolds\n", "Text"],
 StyleBox[ButtonBox["UndefManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefManifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["Undefine a manifold\n", "Text"],
 StyleBox[ButtonBox["ManifoldQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ManifoldQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Check manifold", "Text"],
 StyleBox["\n", "DisplayMath"],
 StyleBox[ButtonBox["$Manifolds",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Manifolds.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["List of defined manifolds\n", "Text"],
 StyleBox[ButtonBox["$ProductManifolds",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ProductManifolds.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t", "DisplayMath"],
 StyleBox["List of defined product manifolds", "Text"]
}], "DefinitionBox",ExpressionUUID->"1ef92702-7204-4829-825f-4d0221cb4c06"],

Cell["Definition of a manifold.", "Text",ExpressionUUID->"98f97fb0-2352-438c-9eee-7798834bb3fd"],

Cell[CellGroupData[{

Cell[TextData[{
 "We define a 3-dimensional manifold ",
 StyleBox["M3",
  FontFamily->"Courier"],
 " with abstract indices {a, b, ..., h} associated to its tangent vector \
bundle:"
}], "MathCaption",ExpressionUUID->"a102bb63-2a7b-4eae-8d1b-25fabc2ddb5a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M3", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"d39feba1-d953-4465-be4f-f38923b0a0ad"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776736609592`*^9},
 CellLabel->"During evaluation of In[49]:=",
 CellID->894423641,ExpressionUUID->"c0dd4935-216e-43a3-81ba-4651922e51f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977673681849*^9},
 CellLabel->"During evaluation of In[49]:=",
 CellID->192605287,ExpressionUUID->"af7cc6fa-cafc-4978-8540-2cced64763b0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DimOfManifold", "[", "M3", "]"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"39af99de-0f20-4702-96c6-86ce614679e2"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.728977673836411*^9},
 CellLabel->"Out[50]=",
 CellID->859202580,ExpressionUUID->"7079644f-84ec-4707-bbb3-c2328f7b02a9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "We can ask ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " about this manifold using the question mark ",
 StyleBox["?",
  FontFamily->"Courier"],
 " (command ",
 StyleBox["Information",
  FontFamily->"Courier"],
 "). We see that the data is stored in several property-functions using the \
concept of \"upvalue\" (this is why we find the  ^= sign below)"
}], "MathCaption",ExpressionUUID->"8ad557fd-7d55-44df-b518-57f5ee4392ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "M3"}]], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"97c5c513-db25-4ea5-9b9f-083bc3d3e4cd"],

Cell[CellGroupData[{

Cell["Global`M3", "Print", "PrintUsage",
 CellChangeTimes->{3.728977675687475*^9},
 CellTags->"Info513728981275-9181623",
 CellID->580545217,ExpressionUUID->"0c64b26f-1b6a-426c-8169-13f835a49e44"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "M3", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"manifold\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DimOfManifold", "[", "M3", "]"}], "^=", "3"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ManifoldQ", "[", "M3", "]"}], "^=", "True"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "M3", "]"}], "^=", "\<\"M3\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ServantsOf", "[", "M3", "]"}], "^=", 
         RowBox[{"{", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SplittingsOfManifold", "[", "M3", "]"}], "^=", 
         RowBox[{"{", "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`M3],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776757100477`*^9},
 CellTags->"Info513728981275-9181623",
 CellID->1205253798,ExpressionUUID->"794dc6e3-9199-42ce-b23c-afc9b0990f95"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Together with the manifold we have also defined its tangent vector bundle, \
which stores all the information related to indices and indexed objects. By \
default, the tangent bundle is named by joining the symbol ",
 StyleBox["Tangent",
  FontFamily->"Courier"],
 " with the name of the manifold, but that name can be freely choosen. To \
conform with the standard notation, it is typeset by default as the character \
",
 StyleBox["\[DoubleStruckCapitalT]",
  FontFamily->"Courier"],
 " followed by the typesetting of the manifold, but the typsetting can also \
be freely chosen. Note that we shall often abbreviate \"vector bundle\" to \
\"vbundle\"."
}], "Text",ExpressionUUID->"9a5ff845-8fc9-4b04-966b-e13a0861acde"],

Cell[TextData[{
 StyleBox[ButtonBox["Tangent",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TangentReals.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["[M]\t\t", "DisplayMath"],
 StyleBox["Tangent bundle of the manifold M", "Text"]
}], "DefinitionBox",ExpressionUUID->"93c7beb0-5818-4811-b987-edb23c890510"],

Cell["Tangent bundle of a manifold.", "Text",ExpressionUUID->"ec987b65-22b9-4127-82c4-1ff98ca47192"],

Cell[CellGroupData[{

Cell["\<\
By default, tangent bundles are real and have no metric. The dimension of the \
tangent bundle is defined as that of the vector space at each point, and \
coincides with the dimension of the base manifold.\
\>", "MathCaption",ExpressionUUID->"4387b72c-5344-483c-9fc7-70a077da29a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tangent", "[", "M3", "]"}]], "Input",
 CellLabel->"In[52]:=",ExpressionUUID->"6a3d6e27-68d1-4ed0-b12f-b7b5f0d81b17"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["\[DoubleStruckCapitalT]M3",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TangentM3,
  Editable->False]], "Output",
 CellChangeTimes->{3.728977684825652*^9},
 CellLabel->"Out[52]=",
 CellID->702233062,ExpressionUUID->"49510770-32ed-48b3-a843-9df916670925"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"77e79572-07a7-407f-8d75-25de623e6c28"],

Cell["TangentM3", "Output",
 CellChangeTimes->{3.728977686296956*^9},
 CellLabel->"Out[53]//InputForm=",
 CellID->163721661,ExpressionUUID->"a922cc88-5ad6-4a59-9153-80931a54f97c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "TangentM3"}]], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"d8756b4b-befd-4be5-98f3-fca67301574e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  StyleBox["\[DoubleStruckCapitalT]M3",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TangentM3,
  Editable->False]], "Print", "PrintUsage",
 CellChangeTimes->{3.728977686955414*^9},
 CellTags->"Info543728981286-9181623",
 CellID->76239291,ExpressionUUID->"a14a8109-2565-4fe7-84ec-88b5522828b6"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"BaseOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], "^=", "M3"}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]M3",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentM3,
             Editable->False], "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`TangentM3],
          Editable->False], "^=", 
         InterpretationBox[
          StyleBox["\[DoubleStruckCapitalT]M3",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`TangentM3,
          Editable->False]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"vbundle\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DimOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], "^=", "3"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"IndicesOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", 
             ",", "h"}], "}"}], ",", 
           RowBox[{"{", "}"}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"LastIndex", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"h", ",", "1"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MasterOf", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], "^=", "M3"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MetricsOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], 
         "^=", "\<\"\[DoubleStruckCapitalT]M3\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SplittingsOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"VBundleQ", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M3",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM3,
           Editable->False], "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`TangentM3],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977686980287*^9},
 CellTags->"Info543728981286-9181623",
 CellID->1453510225,ExpressionUUID->"2ec7dae1-8a02-4a21-a5a7-9fd5c71f3517"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "We define a second manifold ",
 StyleBox["S2",
  FontFamily->"Courier"],
 ". Note that we can use ",
 StyleBox["C",
  FontFamily->"Courier"],
 ", ",
 StyleBox["D",
  FontFamily->"Courier"],
 ", ",
 StyleBox["K",
  FontFamily->"Courier"],
 ", ",
 StyleBox["N",
  FontFamily->"Courier"],
 ", ",
 StyleBox["O",
  FontFamily->"Courier"],
 " as indices, even though ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has reserved meanings for those symbols. The capitals ",
 StyleBox["E",
  FontFamily->"Courier"],
 " and ",
 StyleBox["I",
  FontFamily->"Courier"],
 " cannot be used as indices because they are always understood as the base \
of natural logarithms and the square root of -1, respectively. ",
 StyleBox["xTensor`", "DisplayMath"],
 " issues warnings to remind you of this point:"
}], "MathCaption",ExpressionUUID->"045d3424-06d0-4dc2-b568-5739921d2361"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"S2", ",", " ", "2", ",", " ", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "G", ",", "H"}],
     "}"}]}], "]"}]], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"c829f48e-d04d-4c93-bf2a-d1bb043cdf03"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "S2", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`S2, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776889445963`*^9},
 CellLabel->"During evaluation of In[55]:=",
 CellID->391777724,ExpressionUUID->"96aa42ed-b72f-4b51-8ebc-18fbe500705d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentS2", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentS2, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977688962801*^9},
 CellLabel->"During evaluation of In[55]:=",
 CellID->423345566,ExpressionUUID->"70605633-1a52-4f41-95cf-52a2d3d355c9"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"C\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 55, 7, 19253573948027831207, "Local", 
   "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977688991045*^9},
 CellLabel->"During evaluation of In[55]:=",
 CellID->555605251,ExpressionUUID->"0e4c297c-4466-49fc-98f1-255a4fe9dcda"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"D\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 55, 8, 19253573948027831207, "Local", 
   "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977689016057*^9},
 CellLabel->"During evaluation of In[55]:=",
 CellID->798556401,ExpressionUUID->"3ac2529b-dc46-4b1a-bdab-d9a8bcb005a6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The lists of manifolds and vbundles defined in the current session are \
given by the global variables ",
 StyleBox["$Manifolds",
  FontFamily->"Courier"],
 " and ",
 StyleBox["$VBundles",
  FontFamily->"Courier"],
 ", respectively:"
}], "MathCaption",ExpressionUUID->"b035769e-73b9-4ef0-8395-d8fa1b839b26"],

Cell[CellGroupData[{

Cell[BoxData["$Manifolds"], "Input",
 CellLabel->"In[56]:=",ExpressionUUID->"5c36480d-b101-471e-90cb-85cdc6a583e1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"M3", ",", "S2"}], "}"}]], "Output",
 CellChangeTimes->{3.728977690706039*^9},
 CellLabel->"Out[56]=",
 CellID->1667145854,ExpressionUUID->"aa376e0c-a3ea-4522-b6ab-259052088c62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$VBundles"], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"374d1cc9-99d6-48b1-87e5-0c7b36bc0c82"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M3",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM3,
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentS2,
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.728977691314704*^9},
 CellLabel->"Out[57]=",
 CellID->2144759790,ExpressionUUID->"c310b3d2-229c-46b7-9e58-826d511bbc1a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A manifold can be undefined (its properties are lost and the symbol is \
removed). In the process, the associated tangent bundle is also undefined:\
\>", "MathCaption",ExpressionUUID->"7ec5d8f7-916b-4409-a627-cbed7a34d8c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "M3", "]"}]], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"d628234a-4a57-4cf7-8f87-bd66ea255b24"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M3",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM3,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM3],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776926395283`*^9},
 CellLabel->"During evaluation of In[58]:=",
 CellID->390229355,ExpressionUUID->"accd7dfe-6599-404b-ac43-3a3fe8ac4b64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M3"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M3],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776926583223`*^9},
 CellLabel->"During evaluation of In[58]:=",
 CellID->169711547,ExpressionUUID->"a7a278e1-17e9-438d-8a92-6e3862171a1a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "M3"}]], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"d14ddd2c-fbda-4970-bdf8-38eafa357efd"],

Cell[BoxData[
 TemplateBox[{
  "Information", "notfound", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"M3\\\\\\\"\\\"}]\\) not found.\"", 
   2, 59, 9, 19253573948027831207, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.728977693143483*^9},
 CellLabel->"During evaluation of In[59]:=",
 CellID->111960166,ExpressionUUID->"16d090a3-6e27-402c-9f0c-7d3148fa067e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Manifolds"], "Input",
 CellLabel->"In[60]:=",ExpressionUUID->"1f4fe908-f907-469c-bebb-69cb37f5e101"],

Cell[BoxData[
 RowBox[{"{", "S2", "}"}]], "Output",
 CellChangeTimes->{3.728977693744076*^9},
 CellLabel->"Out[60]=",
 CellID->730204304,ExpressionUUID->"3c5798aa-4f7b-46c8-b82b-58bd42b5b6fa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "And redefined (note the use of the command ",
 StyleBox["IndexRange",
  FontFamily->"Courier"],
 ", quite handy for long lists of indices):"
}], "MathCaption",
 CellChangeTimes->{{3.494606924743266*^9, 3.4946069429822206`*^9}, {
  3.494606979734871*^9, 
  3.494606985640581*^9}},ExpressionUUID->"2865d1d0-4b87-4877-a573-\
37bb04904229"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M3", ",", " ", "3", ",", " ", 
   RowBox[{"IndexRange", "[", 
    RowBox[{"a", ",", "h"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"66c7fb81-9d85-4f47-b94b-23f14098af8e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289776952238607`*^9},
 CellLabel->"During evaluation of In[61]:=",
 CellID->442594184,ExpressionUUID->"bd1f5700-9263-42b6-909a-c1f719d85a2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977695243499*^9},
 CellLabel->"During evaluation of In[61]:=",
 CellID->1944580927,ExpressionUUID->"31490e21-67ca-4617-adac-be7e1b06701b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Manifolds"], "Input",
 CellLabel->"In[62]:=",ExpressionUUID->"d208da62-5962-4155-93ee-f6e9ea12979b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"S2", ",", "M3"}], "}"}]], "Output",
 CellChangeTimes->{3.72897769581172*^9},
 CellLabel->"Out[62]=",
 CellID->863685934,ExpressionUUID->"cbd49fc0-aad4-45da-bc9e-481109a90198"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "It is possible to define 1-dimensional manifolds, with a corresponding \
1-dimensional tangent vbundle. They are treated in exactly the same way as \
other manifolds and vbundles. Other systems, like ",
 StyleBox["Ricci`", "MR"],
 ", only allow a single abstract index (which can be repeated), but that is a \
large internal exception, and ",
 StyleBox["xTensor`", "MR"],
 "does not follow that idea. Instead, we shall declare all indices of the \
same 1-dimensional space to be symmetric. See subsection 4.4 below."
}], "Text",ExpressionUUID->"87931585-5c99-4960-96b8-0cbc8e05ae00"],

Cell["\<\
The dimension of a manifold does not have to be an integer necessarily. It \
can be any expression. It is advisable to use constant-symbols (see 6.5 \
below) as manifold dimensions.\
\>", "Text",ExpressionUUID->"899896a8-1b63-4664-9c40-f6a921808b78"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "1.2. Product manifolds. ",
 StyleBox["V1.1.0 UPDATE",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsection",ExpressionUUID->"cf275d8f-dc19-4950-a603-a03bd3072d50"],

Cell[TextData[{
 "Given two manifolds, it is always possible to define another manifold as \
the Cartesian product of those. The tangent bundle of the product will be \
then constructed as the (external, or disjoint) direct sum of the tangent \
bundles of the submanifolds. There are two ways to approach this problem, and \
we will find this duality repeatedly in all of ",
 StyleBox["xAct`",
  FontFamily->"Courier"],
 ". On the one hand we can declare a new symbolic manifold using a ",
 StyleBox["DefType",
  FontFamily->"Courier"],
 " command, which will prepare everything for us in advance. On the other \
hand we can describe the new manifold using a ",
 StyleBox["CartesianProduct",
  FontFamily->"Courier"],
 " command, whose properties will be computed in real time whenever they are \
needed."
}], "Text",ExpressionUUID->"33450aa3-d5e7-4cc4-ac55-fcb1bd7e05bd"],

Cell[CellGroupData[{

Cell["We define a product manifold as", "MathCaption",ExpressionUUID->"b118a9ae-0d52-4943-91b2-0cc2f95370a6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M5", ",", 
   RowBox[{"{", 
    RowBox[{"M3", ",", "S2"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
    "\[Mu]", ",", " ", "\[Nu]", ",", " ", "\[Lambda]", ",", " ", "\[Sigma]", 
     ",", " ", "\[Eta]", ",", " ", "\[Rho]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"e62bf63c-d578-475a-88d2-b90e2f37f7ef"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M5", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M5, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897770371828*^9},
 CellLabel->"During evaluation of In[63]:=",
 CellID->422190744,ExpressionUUID->"50c1bd67-8f9b-4465-96ed-1712efdb71cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM5", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM5, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977703736231*^9},
 CellLabel->"During evaluation of In[63]:=",
 CellID->473864720,ExpressionUUID->"bafbbe97-0fae-440d-9a24-d7ec43e0b226"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "M5"}]], "Input",
 CellLabel->"In[64]:=",ExpressionUUID->"2b6c1e02-5bab-41b5-ac57-419456dcbcec"],

Cell[CellGroupData[{

Cell["Global`M5", "Print", "PrintUsage",
 CellChangeTimes->{3.728977704745297*^9},
 CellTags->"Info643728981304-9181623",
 CellID->1678239341,ExpressionUUID->"495fb146-4919-4a2e-a6a9-01c1ea7ad2db"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "M5", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"manifold\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DimOfManifold", "[", "M5", "]"}], "^=", "5"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ManifoldQ", "[", "M5", "]"}], "^=", "True"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "M5", "]"}], "^=", "\<\"M5\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ServantsOf", "[", "M5", "]"}], "^=", 
         RowBox[{"{", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SplittingsOfManifold", "[", "M5", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"M3", "\[Times]", "S2"}], "}"}]}]},
       {" "},
       {
        RowBox[{"M5", "/:", 
         RowBox[{"SubmanifoldQ", "[", 
          RowBox[{"M5", ",", "M3"}], "]"}], "=", "True"}]},
       {" "},
       {
        RowBox[{"M5", "/:", 
         RowBox[{"SubmanifoldQ", "[", 
          RowBox[{"M5", ",", "S2"}], "]"}], "=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`M5],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777047699747`*^9},
 CellTags->"Info643728981304-9181623",
 CellID->1118384489,ExpressionUUID->"696209d9-520d-4605-8a2b-cc1e264a6a62"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
whose tangent bundle is a direct sum of the corresponding subvbundles:\
\>", "MathCaption",ExpressionUUID->"7b872029-8c5d-42c0-b8c4-bbe8ae53acfa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "TangentM5"}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"819acafa-417f-4430-b4a2-8cde5aee1b6e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  StyleBox["\[DoubleStruckCapitalT]M5",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TangentM5,
  Editable->False]], "Print", "PrintUsage",
 CellChangeTimes->{3.7289777059244003`*^9},
 CellTags->"Info653728981305-9181623",
 CellID->1548585086,ExpressionUUID->"c67e0a3a-aab2-4e76-b372-ae1b984fb9b1"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"BaseOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], "^=", "M5"}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]M5",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentM5,
             Editable->False], "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`TangentM5],
          Editable->False], "^=", 
         InterpretationBox[
          StyleBox["\[DoubleStruckCapitalT]M5",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`TangentM5,
          Editable->False]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"vbundle\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DimOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], "^=", "5"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"IndicesOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\[Mu]", ",", "\[Nu]", ",", "\[Lambda]", ",", "\[Sigma]", ",", 
             "\[Eta]", ",", "\[Rho]"}], "}"}], ",", 
           RowBox[{"{", "}"}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"LastIndex", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\[Rho]", ",", "1"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MasterOf", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], "^=", "M5"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MetricsOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], 
         "^=", "\<\"\[DoubleStruckCapitalT]M5\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SplittingsOfVBundle", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], "\[CirclePlus]", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]S2",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentS2,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox["\[DoubleStruckCapitalT]M5",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`TangentM5,
          Editable->False], "/:", 
         RowBox[{"SubvbundleQ", "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M5",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM5,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False]}], "]"}], "=", "True"}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox["\[DoubleStruckCapitalT]M5",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`TangentM5,
          Editable->False], "/:", 
         RowBox[{"SubvbundleQ", "[", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M5",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM5,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]S2",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentS2,
            Editable->False]}], "]"}], "=", "True"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"VBundleQ", "[", 
          InterpretationBox[
           StyleBox["\[DoubleStruckCapitalT]M5",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`TangentM5,
           Editable->False], "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`TangentM5],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777059798737`*^9},
 CellTags->"Info653728981305-9181623",
 CellID->1715222409,ExpressionUUID->"4f8c5a66-9828-4a8c-a4c2-2c05d8fba923"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The list of product manifolds is given by another global variable:\
\>", "MathCaption",ExpressionUUID->"19b5b905-c580-4aaa-8d99-1fa6e4b1cd0f"],

Cell[CellGroupData[{

Cell[BoxData["$ProductManifolds"], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"8a20050f-5b08-40ba-ac20-3a2851925ba5"],

Cell[BoxData[
 RowBox[{"{", "M5", "}"}]], "Output",
 CellChangeTimes->{3.728977707212233*^9},
 CellLabel->"Out[66]=",
 CellID->1383227708,ExpressionUUID->"572978e1-b92a-47e1-b5e1-87f76555d6c8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The command ",
 StyleBox["SplitManifold",
  FontFamily->"Courier"],
 " also allows constructing a product manifold, or splitting a previously \
existing manifold."
}], "Text",ExpressionUUID->"3f032dea-7b04-4075-bf98-58359ab38213"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SplitManifold"}]], "Input",
 CellLabel->"In[67]:=",ExpressionUUID->"a82a7eff-216c-4076-ada8-b0c9515a073e"],

Cell[BoxData["\<\"SplitManifold[M, {m1, ..., mn}] identifies the manifold M \
as the (external) Cartesian product of the manifolds mi. Both the M manifold \
and the mi manifolds are assumed to exist already. The dimension of M must \
coincide with the sum of the dimensions of the mi manifolds.\"\>"], "Print", \
"PrintUsage",
 CellChangeTimes->{3.72897770837747*^9},
 CellTags->"Info673728981308-9181623",
 CellID->1069478814,ExpressionUUID->"f89e4fe2-2986-45ad-b58e-63513099d114"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We can also work directly with an expression representing the product \
manifold.\
\>", "Text",ExpressionUUID->"c5abdda0-498c-44d1-9cee-e7f2ca7d7d83"],

Cell[TextData[{
 StyleBox[ButtonBox["CartesianProduct",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TangentReals.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["[M1, M2, ...]\t\t", "DisplayMath"],
 StyleBox["Cartesian product of the manifolds M1, M2, ...", "Text"]
}], "DefinitionBox",ExpressionUUID->"2b1d3866-bcef-4cf6-9cfc-536e2910f6bb"],

Cell["Cartesian product of manifolds.", "Text",ExpressionUUID->"6bbcb532-2ca1-4ca1-9dc2-dec86556317b"],

Cell[CellGroupData[{

Cell["Cartesian product of our two manifolds :", "MathCaption",ExpressionUUID->"80005056-4171-41b4-9f96-b546be1999e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"prod", "=", 
  RowBox[{"CartesianProduct", "[", 
   RowBox[{"M3", ",", "S2"}], "]"}]}]], "Input",
 CellLabel->"In[68]:=",ExpressionUUID->"933e0218-cae1-4abb-b4b7-17711468fe81"],

Cell[BoxData[
 RowBox[{"M3", "\[Times]", "S2"}]], "Output",
 CellChangeTimes->{3.7289777153598022`*^9},
 CellLabel->"Out[68]=",
 CellID->839651,ExpressionUUID->"837146aa-d13f-4041-b227-6069f282aa7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ManifoldQ", "[", "prod", "]"}]], "Input",
 CellLabel->"In[69]:=",ExpressionUUID->"ceee3743-da5b-4f41-a2b8-f82e37c94a6b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.728977717134571*^9},
 CellLabel->"Out[69]=",
 CellID->1946601836,ExpressionUUID->"c2853399-a2a9-47a4-be99-edf76576abdb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DimOfManifold", "[", "prod", "]"}]], "Input",
 CellLabel->"In[70]:=",ExpressionUUID->"38297d9f-4f24-4c5a-b946-0dd0e2432b18"],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.728977719151785*^9},
 CellLabel->"Out[70]=",
 CellID->1089153226,ExpressionUUID->"b1828f0b-4666-4361-ac7b-9dc736f33796"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tangent", "[", "prod", "]"}]], "Input",
 CellLabel->"In[71]:=",ExpressionUUID->"bdede592-7995-498d-aa4d-f58c7be3bf5d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox["\[DoubleStruckCapitalT]M3",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TangentM3,
   Editable->False], "\[CirclePlus]", 
  InterpretationBox[
   StyleBox["\[DoubleStruckCapitalT]S2",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TangentS2,
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289777197591763`*^9},
 CellLabel->"Out[71]=",
 CellID->718487895,ExpressionUUID->"ec06b306-d0f0-4217-ad59-0120d74adccb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[72]:=",ExpressionUUID->"ad47a5b6-d7e8-40c3-8c03-ca9a42bee6d3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"CirclePlus", "[", 
    RowBox[{"TangentM3", ",", "TangentS2"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellChangeTimes->{3.7289777203193283`*^9},
 CellLabel->"Out[72]//FullForm=",
 CellID->2004106280,ExpressionUUID->"a5049b68-0212-412c-8656-d998e2a2dd32"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clean up:", "MathCaption",ExpressionUUID->"4405d533-bd0c-4e8e-9732-2b0026dda536"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "M5", "]"}]], "Input",
 CellLabel->"In[73]:=",ExpressionUUID->"b46e64fa-0fdb-4f84-85e1-2343055f28f4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M5",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM5,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM5],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777214320993`*^9},
 CellLabel->"During evaluation of In[73]:=",
 CellID->1972642216,ExpressionUUID->"9461cfbc-d200-4bfd-ba4f-c6d0962844f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M5"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M5],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977721452014*^9},
 CellLabel->"During evaluation of In[73]:=",
 CellID->1345181926,ExpressionUUID->"fcd65b7e-ed9b-4d27-b95d-8e2edaebfae4"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "prod", "]"}]], "Input",
 CellLabel->"In[74]:=",ExpressionUUID->"9372b455-0c25-43f5-bda9-2d171282f8c9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. Inner vector bundles", "Subsection",ExpressionUUID->"41df9b57-d4a7-402c-a52f-449095ba56f2"],

Cell[TextData[{
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " allows the definition of vector bundles other than tangent bundles. These \
``inner vbundles\.b4\.b4 can be real or complex, which forces the definition \
of the complex conjugated vbundle. Complex conjugation is controlled by the \
function ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 "."
}], "Text",ExpressionUUID->"4dcae6d3-f9c5-4c84-a1c5-aa7d6ce12852"],

Cell[TextData[{
 StyleBox[ButtonBox["DefVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Define a vbundle or a sum of vbundles\n", "Text"],
 StyleBox[ButtonBox["UndefVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["Undefine a vbundle\n", "Text"],
 StyleBox[ButtonBox["VBundleQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundleQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Check a vbundle", "Text"],
 StyleBox["\n", "DisplayMath"],
 StyleBox[ButtonBox["$VBundles",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$VBundles.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["List of defined vbundles\n", "Text"],
 StyleBox[ButtonBox["$SumVBundles",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$SumVBundles.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["List of defined sum vbundles", "Text"]
}], "DefinitionBox",ExpressionUUID->"e41db040-0eeb-4478-8fa3-25c3c0a85e46"],

Cell["Definition of a vbundle.", "Text",ExpressionUUID->"41d0679c-1a13-485d-b03c-a867b3250886"],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a complex inner vbundle with dimension 4 (this is the fiber \
dimension) and base manifold ",
 StyleBox["M3",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"a610520d-1f6c-4913-96fc-32f9ceab89c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefVBundle", "[", 
  RowBox[{"InnerC", ",", "M3", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", "\[GothicCapitalC]", 
     ",", "\[GothicCapitalD]", ",", "\[GothicCapitalE]", ",", 
     "\[GothicCapitalF]", ",", "\[GothicCapitalG]", ",", 
     "\[GothicCapitalH]"}], "}"}], ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->"In[75]:=",ExpressionUUID->"e1f8cde2-3386-4628-9c85-b2d541380ea4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "InnerC", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`InnerC, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977734125264*^9},
 CellLabel->"During evaluation of In[75]:=",
 CellID->960640895,ExpressionUUID->"24e59c23-5cf5-4355-9fa4-771438c3c4e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "InnerC\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between InnerC \
and InnerC\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`InnerC\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between InnerC and InnerC\[Dagger]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977734146121*^9},
 CellLabel->"During evaluation of In[75]:=",
 CellID->709464119,ExpressionUUID->"a8cd3616-0b7a-4b96-a654-72359909efb5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "InnerC"}]], "Input",
 CellLabel->"In[76]:=",ExpressionUUID->"49a3e91a-e823-44b0-bcc3-c0adf147d061"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  StyleBox["InnerC",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`InnerC,
  Editable->False]], "Print", "PrintUsage",
 CellChangeTimes->{3.7289777343278437`*^9},
 CellTags->"Info763728981334-9181623",
 CellID->1134239889,ExpressionUUID->"78f21f23-a24d-4d19-9550-1ea66aeba6ec"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"BaseOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", "M3"}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", 
            InterpretationBox[
             StyleBox["InnerC",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`InnerC,
             Editable->False], "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`InnerC],
          Editable->False], "^=", 
         InterpretationBox[
          StyleBox["InnerC\[Dagger]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`InnerC\[Dagger],
          Editable->False]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"vbundle\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DimOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", "4"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", "M3", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"IndicesOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
             "\[GothicCapitalC]", ",", "\[GothicCapitalD]", ",", 
             "\[GothicCapitalE]", ",", "\[GothicCapitalF]", ",", 
             "\[GothicCapitalG]", ",", "\[GothicCapitalH]"}], "}"}], ",", 
           RowBox[{"{", "}"}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"LastIndex", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\[GothicCapitalH]", ",", "1"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MetricsOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", "\<\"InnerC\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ServantsOf", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SplittingsOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"VBundleQ", "[", 
          InterpretationBox[
           StyleBox["InnerC",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC,
           Editable->False], "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`InnerC],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777344030867`*^9},
 CellTags->"Info763728981334-9181623",
 CellID->2104963651,ExpressionUUID->"86d299a7-dd5d-4f3d-ba67-a9c99a8f3c23"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "In the process of definition, the conjugated vbundle ",
 StyleBox["InnerC\[Dagger]",
  FontFamily->"Courier"],
 ", with corresponding conjugated indices, has been created. It is a servant \
of ",
 StyleBox["InnerC",
  FontFamily->"Courier"],
 ", and hence can only be undefined through undefinition of the latter. By \
default, all conjugated symbols are constructed by appending the dagger \
character ",
 StyleBox["\[Dagger]",
  FontFamily->"Courier"],
 ". (This character is stored in the goblal variable ",
 StyleBox["$DaggerCharacter",
  FontFamily->"Courier"],
 ", which can be changed.)"
}], "MathCaption",ExpressionUUID->"51b25888-11e0-4f34-9197-3d72c4553576"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "InnerC\[Dagger]"}]], "Input",
 CellLabel->"In[77]:=",ExpressionUUID->"27f253d2-1c2f-4182-a2a5-a4d6b96ff92c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  StyleBox["InnerC\[Dagger]",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`InnerC\[Dagger],
  Editable->False]], "Print", "PrintUsage",
 CellChangeTimes->{3.728977734573596*^9},
 CellTags->"Info773728981334-9181623",
 CellID->478481679,ExpressionUUID->"e45eb883-9712-4a14-bb63-71266d89737a"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"BaseOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", "M3"}]},
       {" "},
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", 
            InterpretationBox[
             StyleBox["InnerC\[Dagger]",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`InnerC\[Dagger],
             Editable->False], "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`InnerC\[Dagger]],
          Editable->False], "^=", 
         InterpretationBox[
          StyleBox["InnerC",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`InnerC,
          Editable->False]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          
          RowBox[{"\<\"conjugated vbundle\"\>", 
           ",", "\<\"Assuming fixed anti-isomorphism between InnerC and \
InnerC\[Dagger]\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DimOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", "4"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", 
         RowBox[{"{", "M3", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"IndicesOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", 
             ",", "\[GothicCapitalC]\[Dagger]", ",", 
             "\[GothicCapitalD]\[Dagger]", ",", "\[GothicCapitalE]\[Dagger]", 
             ",", "\[GothicCapitalF]\[Dagger]", ",", 
             "\[GothicCapitalG]\[Dagger]", ",", 
             "\[GothicCapitalH]\[Dagger]"}], "}"}], ",", 
           RowBox[{"{", "}"}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"LastIndex", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\[GothicCapitalH]\[Dagger]", ",", "1"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MasterOf", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", 
         InterpretationBox[
          StyleBox["InnerC",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`InnerC,
          Editable->False]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MetricsOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", "\<\"InnerC\[Dagger]\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SplittingsOfVBundle", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"VBundleQ", "[", 
          InterpretationBox[
           StyleBox["InnerC\[Dagger]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`InnerC\[Dagger],
           Editable->False], "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`InnerC\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977734631353*^9},
 CellTags->"Info773728981334-9181623",
 CellID->1662804585,ExpressionUUID->"1b43b27e-5ef8-4e34-ad3f-b46f987e1e90"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["We have already defined four different vector bundles:", "MathCaption",ExpressionUUID->"281293b9-d69c-4c8b-8a41-b10a3c4440fb"],

Cell[CellGroupData[{

Cell[BoxData["$VBundles"], "Input",
 CellLabel->"In[78]:=",ExpressionUUID->"a4e76137-ed7d-4a74-b496-6490cc2cc946"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentS2,
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M3",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM3,
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["InnerC",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC,
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["InnerC\[Dagger]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC\[Dagger],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.728977734778001*^9},
 CellLabel->"Out[78]=",
 CellID->1551961684,ExpressionUUID->"c3a2e3f5-8e19-4730-a516-9a28e96094d1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "There is also a function ",
 StyleBox["SplitVBundle",
  FontFamily->"Courier"],
 ", parallel to ",
 StyleBox["SplitManifold",
  FontFamily->"Courier"],
 "."
}], "Text",ExpressionUUID->"fa959902-aa79-407c-940f-2285556b445f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SplitVBundle"}]], "Input",
 CellLabel->"In[79]:=",ExpressionUUID->"3c96b45f-e102-4392-bf32-84e64578de9c"],

Cell[BoxData["\<\"SplitVBundle[V, {v1, ..., vn}] identifies the vbundle V as \
the direct sum of the vbundles vi. Both the V vbundle and the vi vbundles are \
assumed to exist already. The dimension of V must coincide with the sum of \
the dimensions of the vi vbundles.\"\>"], "Print", "PrintUsage",
 CellChangeTimes->{3.728977734943226*^9},
 CellTags->"Info793728981334-9181623",
 CellID->483646526,ExpressionUUID->"b624df61-586c-41cd-84c6-be2034fb0f05"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. Parameters", "Subsection",ExpressionUUID->"e88af057-5080-4dba-a53c-e91d18080d3c"],

Cell[TextData[{
 "In ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " the indexed objects can be fields on manifolds and/or functions of real \
parameters (for example proper time)."
}], "Text",ExpressionUUID->"ecadba5a-a0cd-4981-ae56-1e080a567e56"],

Cell[TextData[{
 StyleBox[ButtonBox["DefParameter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefParameter.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["Define a real parameter\n", "Text"],
 StyleBox[ButtonBox["UndefParameter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefParameter.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["Undefine a parameter\n", "Text"],
 StyleBox[ButtonBox["ParameterQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ParameterQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Check a real parameter", "Text"],
 StyleBox["\n", "DisplayMath"],
 StyleBox[ButtonBox["$Parameters",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Parameters.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["List of defined parameters", "Text"]
}], "DefinitionBox",ExpressionUUID->"7b133ce1-4008-486c-bf5b-9db872b0a2db"],

Cell["Definition of a parameter", "Text",ExpressionUUID->"af2f997a-c293-4dc2-abb5-f953b1d04d9b"],

Cell[CellGroupData[{

Cell[TextData[{
 "We define a real parameter that will be used below to compute parametric \
derivatives (see ",
 StyleBox["ParamD",
  FontFamily->"Courier"],
 " in subsection 6.6)."
}], "MathCaption",ExpressionUUID->"703ba00d-9850-441c-a4d1-fa1478287f89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefParameter", "[", "time", "]"}]], "Input",
 CellLabel->"In[80]:=",ExpressionUUID->"17213dac-b2f6-46c4-bafe-dc0ad267bac7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefParameter", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parameter \"\>", "\[InvisibleSpace]", "time", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefParameter, ": Defining ", 
   "parameter ", $CellContext`time, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777427296352`*^9},
 CellLabel->"During evaluation of In[80]:=",
 CellID->229219215,ExpressionUUID->"af4bb84c-e5cf-4949-8f6d-962879c7ad1d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "time"}]], "Input",
 CellLabel->"In[81]:=",ExpressionUUID->"ad324b11-367e-4fda-bdea-1eaf4530fe4d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  StyleBox["time",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`time,
  Editable->False]], "Print", "PrintUsage",
 CellChangeTimes->{3.728977742871666*^9},
 CellTags->"Info813728981342-9181623",
 CellID->2049167434,ExpressionUUID->"c8622f06-4d6e-4201-bb88-bb26ce55c8ab"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"DefInfo", "[", 
          InterpretationBox[
           StyleBox["time",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`time,
           Editable->False], "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"parameter\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ParameterQ", "[", 
          InterpretationBox[
           StyleBox["time",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`time,
           Editable->False], "]"}], "^=", "True"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", 
          InterpretationBox[
           StyleBox["time",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`time,
           Editable->False], "]"}], "^=", "\<\"time\"\>"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`time],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977742895159*^9},
 CellTags->"Info813728981342-9181623",
 CellID->1161816299,ExpressionUUID->"3f1bc420-c985-4a39-be0e-84a2da604eb8"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Manifolds and parameters are the only possible \"dependencies\" of the \
objects in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ". We shall later explain this in more detail."
}], "Text",ExpressionUUID->"b54369c3-fed7-4946-bce8-8e08a33b3a19"],

Cell["\<\
An important question is the relation between fields on 1d manifolds and \
functions of a parameter. In decompositions of ADM-type it would be nice to \
have a way of going from a 4d structure to a 3+1 structure and then from here \
to a 3d structure plus a time parameter. I still don't know how to program \
this idea. There are many things to change in a nontrivial way: tensor \
fields, covariant derivatives, metrics, etc. Please, let me know if you have \
suggestions.\
\>", "Text",
 CellChangeTimes->{{3.4946070715633287`*^9, 
  3.4946070970365133`*^9}},ExpressionUUID->"869cb9c3-a5d7-4433-a5c8-\
0af58d5e7af5"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5. Vector spaces: bundles over a point", "Subsection",ExpressionUUID->"f4a065ec-8746-4f74-990d-0ab375474513"],

Cell[TextData[{
 "It is possible to work  ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " with a single vector space, considered as a bundle over a manifold that \
happens to be a point."
}], "Text",ExpressionUUID->"5bf2dfdc-8a1a-4613-9ba4-36ee49938748"],

Cell[CellGroupData[{

Cell["\<\
Define a zero-dimensional manifold, a point. We do not need to specify \
indices because there is no tangent space:\
\>", "MathCaption",ExpressionUUID->"c7cf903b-a7b6-4bfd-a118-2acc357d11a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"P", ",", "0", ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Input",
 CellLabel->"In[82]:=",ExpressionUUID->"24f3f38a-1ee0-4ea8-8948-eb7857b82456"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "P", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`P,
    ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777467353354`*^9},
 CellLabel->"During evaluation of In[82]:=",
 CellID->2012913861,ExpressionUUID->"877caff4-d563-41eb-8204-14522d3e65f3"],

Cell[BoxData["\<\"** DefManifold:  Tangent bundle does not exist for a 0-dim \
manifold\"\>"], "Print",
 CellChangeTimes->{3.7289777467546864`*^9},
 CellLabel->"During evaluation of In[82]:=",
 CellID->1733370636,ExpressionUUID->"45226275-4177-442a-97af-57c5f2c2008a"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Now we can define a vector bundle over this point. It has a single fiber, \
which is a vector space of the required dimension:\
\>", "MathCaption",ExpressionUUID->"8071bcb4-9e39-4e02-9c88-eaff93fed879"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefVBundle", "[", 
  RowBox[{"V", ",", "P", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{"\[GothicA]", ",", "\[GothicB]", ",", "\[GothicC]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[83]:=",ExpressionUUID->"36d36bdc-c191-40c9-a208-1e01bfb4120e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "V", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", "vbundle ", $CellContext`V, 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977746918551*^9},
 CellLabel->"During evaluation of In[83]:=",
 CellID->2144607697,ExpressionUUID->"d3397308-8b78-4841-bb77-be581f7cfcae"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
And now we can define vectors and tensors on this space, with no dependencies:\
\>", "MathCaption",ExpressionUUID->"b85a38d6-fa67-46e7-b45d-96783d8b665a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"X", "[", "\[GothicA]", "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Input",
 CellLabel->"In[84]:=",ExpressionUUID->"b069a155-d510-4b25-bc89-3e5500b1c931"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"X", "[", "\[GothicA]", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`X[$CellContext`\[GothicA]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977747050667*^9},
 CellLabel->"During evaluation of In[84]:=",
 CellID->1056032231,ExpressionUUID->"20f1dcde-4f43-4ee5-bcdf-6e76b39e110f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Undefine all objects:", "MathCaption",ExpressionUUID->"e293c462-6e57-4668-b017-4a2de63c24dd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "X", "]"}]], "Input",
 CellLabel->"In[85]:=",ExpressionUUID->"4747e910-5168-427c-9784-59dd97f21fc5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "X"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`X],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977747163076*^9},
 CellLabel->"During evaluation of In[85]:=",
 CellID->1928847609,ExpressionUUID->"e9753a4c-e1bb-463f-bcdf-0d23b383f27a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefVBundle", "[", "V", "]"}]], "Input",
 CellLabel->"In[86]:=",ExpressionUUID->"b2001d89-3fa4-49a6-bc39-dfb1098e92c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["V",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`V,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`V],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977747311757*^9},
 CellLabel->"During evaluation of In[86]:=",
 CellID->1876112998,ExpressionUUID->"da90fa35-b075-4eab-ae0b-ec9c68303200"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "P", "]"}]], "Input",
 CellLabel->"In[87]:=",ExpressionUUID->"b02d2530-6567-4f11-8dd4-445ef9080e93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "P"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`P],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977747428424*^9},
 CellLabel->"During evaluation of In[87]:=",
 CellID->328768485,ExpressionUUID->"a03abb13-cb34-493a-9369-4f47f122a6a7"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Indices", "Section",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.7286627354220657`*^9, 3.728662748172317*^9}, {
  3.728664037492599*^9, 3.72866403885896*^9}, {3.7286704747855062`*^9, 
  3.728670480415387*^9}, {3.728670889883876*^9, 3.728670893540101*^9}, {
  3.728673410238123*^9, 3.728673425886174*^9}, {3.7289761721698513`*^9, 
  3.7289761765432653`*^9}, {3.728976277988899*^9, 3.728976287866613*^9}, {
  3.728976341130004*^9, 3.728976342960009*^9}},
 FontSize->18,
 FontColor->GrayLevel[0],
 CellTags->{"S5.18.1", "1.4"},
 CellID->1215012216,ExpressionUUID->"e50a4bbd-8e74-4fce-82b6-11d15ef76e1d"],

Cell[CellGroupData[{

Cell["2.0. Important comments", "Subsection",ExpressionUUID->"f3e6e9da-0f4e-40b2-b1ed-c50ec9fe6a74"],

Cell[TextData[{
 "1) Indices are the key objects in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", and the source of the generality of the system. They are carriers of \
contextual information, much like the decimal digits in numerical \
computations, or the letters in a text. An index by itself has little \
information (only an association to a vector space), but a group of indices \
together can encode a lot of information (rank, symmetries, metrics, bases, \
etc). In general, an index is anything which can be placed at an index-slot: \
that is, we shall later define four places in which we can put indices and \
anything which we can meaningfully put there will be called an index."
}], "Text",ExpressionUUID->"e6ece487-8eb2-43a6-ace3-ff0e4f43fa3c"],

Cell[TextData[{
 "2) Starting version 0.9 of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", indices are associated to vbundles, and not to manifolds, as was the case \
in previous versions. This allows us to work with vbundles other than tangent \
bundles to manifolds."
}], "Text",ExpressionUUID->"d4d91dd1-913d-4b76-a80e-e65db9625f77"],

Cell["\<\
3) We need a \"language\" to talk about indices, and though we usually \
understand what a dummy index or a covariant index is, such a language is not \
rigorously defined anywhere. I have invented my own language for this. \
Please, suggest changes if you find inconsistencies, gaps or bad choices.\
\>", "Text",ExpressionUUID->"0499bb65-c6b2-43a8-bc89-8dece0141f98"],

Cell["\<\
4) Taken from the Internet:
\tThe plural of \"index\" for books, journals and newspapers is \"indexes\"; \
the plural of \"index\" for graphs and benchmarks for economics for example, \
is \"indices\"; but the plural of \"appendix\" is always \"appendices\".
I think the \"index\" of a tensor must follow the rule for the second group, \
and hence its plural will be \"indices\".\
\>", "Text",ExpressionUUID->"ba883f62-4a3d-4909-9d34-4850e872ed9d"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1. Properties of indices: type, character, state", "Subsection",ExpressionUUID->"1d6d10f7-5284-4d78-8010-4890039bf855"],

Cell[TextData[{
 "1) There are five known types of index in ",
 StyleBox["xTensor` ",
  FontFamily->"Courier"],
 "(other types could be added, but there is no user-defined way to do this):\n\
\t- Abstract index (",
 StyleBox[ButtonBox["AIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "). See subsection 2.2.\n\t- Basis index (",
 StyleBox[ButtonBox["BIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "), associated to some basis (coordinated or not) of vector fields. \
Described in ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ".\n\t- Component index (",
 StyleBox[ButtonBox["CIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "), also associated to some basis. Described in ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ".\n\t- Directional index (",
 StyleBox[ButtonBox["DIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "). See subsection 3.7.\n\t- Label index (",
 StyleBox[ButtonBox["LIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "). See subsection 3.8.\nCollectively we refer to all five classes as \
\"generalized indices\" (",
 StyleBox["GIndex",
  FontFamily->"Courier"],
 "). Additionally, we can have patterns (",
 StyleBox[ButtonBox["PIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ") for g-indices at those positions where g-indices are expected, but \
patterns are not considered as g-indices. In the following \"indices\" will \
mean \"g-indices\" unless we specify the type."
}], "Text",ExpressionUUID->"78c412bc-f1ee-408f-a244-2126222cca9b"],

Cell[TextData[{
 "2) All indices have a \"character\", which can be either covariant (",
 StyleBox[ButtonBox["Down",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Down.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "-index) or contravariant (",
 StyleBox[ButtonBox["Up",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Up.nb", CharacterEncoding -> "iso8859-1"],
     None}],
  FontFamily->"Courier"],
 "-index)."
}], "Text",ExpressionUUID->"7bcc6a39-f7e2-45a5-9117-6844b149e1cb"],

Cell[TextData[{
 "3) Some indices can be used to represent contractions, following the \
Einstein convention: two repeated indices in the same tensor or tensor \
product, but each having a different character.  We call them \
\"contractible\" or \"Einstein\" indices (",
 StyleBox["EIndex",
  FontFamily->"Courier"],
 ") and currently only abstract and basis indices are allowed to be \
contractible. (Note that having contractible indices with the same character \
is a syntactic error in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ".) E-indices have a \"state\": they can be ",
 StyleBox[ButtonBox["Free",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Free.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " or contracted (aka ",
 StyleBox[ButtonBox["Dummy",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dummy.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "). For completeness, the state of components, directions and labels is said \
to be always \"",
 StyleBox[ButtonBox["Blocked",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Blocked.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\", what in particular means that they can be repeated (i.e. truly \
repeated, not simply staggered)."
}], "Text",ExpressionUUID->"c9dc8329-8018-4ea8-a951-b43f659228d4"],

Cell[TextData[{
 "4) Basis and component indices are known by part of the routines of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " (for example the formatting routines, the index selectors, the \
canonicalizer or the constructors of rules), but used in the twin package ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ". From now on we shall not consider those two types of indices. See ",
 StyleBox["xCobaDoc.nb",
  FontFamily->"Courier"],
 " for further information.\n5) There is a further property of an index, only \
used internally: its metric-state, saying whether an index can be raised or \
lowered using a given metric (not whether it has been or not actually raised \
already). This will be important in section 7.3."
}], "Text",ExpressionUUID->"5979c260-3a9b-46c4-9832-5a7d8bb9dd1e"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. Covariant and contravariant abstract indices", "Subsection",ExpressionUUID->"05082b76-880a-4928-83c2-67d4901eca40"],

Cell[TextData[{
 "Ab",
 "stract ind",
 "ices in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " are valid atomic symbols without numeric value (excluding therefore ",
 StyleBox["E",
  FontFamily->"Courier"],
 " and ",
 StyleBox["I",
  FontFamily->"Courier"],
 ") and with no special output (excluding symbols like ",
 StyleBox["Space",
  FontFamily->"Courier"],
 ", ",
 StyleBox["Tab",
  FontFamily->"Courier"],
 ", etc.) One of the most important decisions when working with tensors is \
the notation for covariant and contravariant indices. Given the binary \
character of the problem there is only one natural simple choice: the use of \
signs ",
 StyleBox["+",
  FontFamily->"Courier"],
 " and ",
 StyleBox["-",
  FontFamily->"Courier"],
 " . We shall denote contravariant indices as ",
 StyleBox["+a",
  FontFamily->"Courier"],
 " or ",
 StyleBox["a",
  FontFamily->"Courier"],
 ", and covariant indices as ",
 StyleBox["-a",
  FontFamily->"Courier"],
 ". This choice is very simple, but not particularly convenient when doing \
pattern matching, due to the asymmetry of ",
 StyleBox["a",
  FontFamily->"Courier"],
 " being a symbol but ",
 StyleBox["-a",
  FontFamily->"Courier"],
 " being a composite expression."
}], "Text",ExpressionUUID->"0384c176-8639-4d9d-bcff-4069a4f44e53"],

Cell[TextData[{
 StyleBox[ButtonBox["AIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t\t", "DisplayMath"],
 StyleBox["Validate an ab", "Text"],
 "stract ind",
 StyleBox["ex", "Text"],
 StyleBox["\nVB`Q\t\t\t\t\t\t", "DisplayMath"],
 StyleBox["Check that an abstract up-index belongs to vbundle", "Text"],
 StyleBox[" VB\nVB`pmQ\t\t\t\t\t", "DisplayMath"],
 StyleBox["Check that an abstract (up- or down-) index belongs to vbundle", 
  "Text"],
 StyleBox[" VB", "DisplayMath"]
}], "DefinitionBox",
 CellChangeTimes->{
  3.7289777607842493`*^9},ExpressionUUID->"4360fc4d-6fca-4955-90c0-\
3a73c56ba2de"],

Cell["Validation of indices.", "Text",ExpressionUUID->"965569c5-aac7-4c15-9732-9ccba76719fc"],

Cell[CellGroupData[{

Cell[TextData[{
 "We can check whether a symbol has been registered as an abstract index \
using the function ",
 StyleBox["AIndexQ",
  FontFamily->"Courier"]
}], "MathCaption",ExpressionUUID->"e7ce011f-252a-484a-b040-bb1673e24c97"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AIndexQ", "[", "A", "]"}]], "Input",
 CellLabel->"In[88]:=",ExpressionUUID->"80c5e0ea-d526-4a38-8257-b213c41e432d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.728977766549274*^9},
 CellLabel->"Out[88]=",
 CellID->1077251231,ExpressionUUID->"397657ef-c0bb-4fb7-98d5-84c48bf79008"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AIndexQ", "[", 
  RowBox[{"-", "b"}], "]"}]], "Input",
 CellLabel->"In[89]:=",ExpressionUUID->"71a605ae-4f3e-4c73-8f9e-3d25178f3cc9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.72897776663459*^9},
 CellLabel->"Out[89]=",
 CellID->2074295207,ExpressionUUID->"0e7c5339-1ef9-43bd-a44e-ef433d673c19"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AIndexQ", "[", "q", "]"}]], "Input",
 CellLabel->"In[90]:=",ExpressionUUID->"721b5a43-7732-4161-817e-96026db6d291"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.728977766723879*^9},
 CellLabel->"Out[90]=",
 CellID->430018651,ExpressionUUID->"0d5eb9fd-25d8-47b8-bda6-1928e31800df"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "q", "]"}]], "Input",
 CellLabel->"In[91]:=",ExpressionUUID->"9546b9f7-b9d9-4966-9d1f-79a7adf1f4f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["In particular, we can specify the vbundle it must belong to:", \
"MathCaption",ExpressionUUID->"81bd29c2-5f25-41da-8ecd-d8a5ab274c11"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AIndexQ", "[", 
  RowBox[{"A", ",", "TangentS2"}], "]"}]], "Input",
 CellLabel->"In[92]:=",ExpressionUUID->"3fdf3655-d045-4c16-9085-809d392e337b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.728977766881269*^9},
 CellLabel->"Out[92]=",
 CellID->1040995202,ExpressionUUID->"44b8a245-1440-459f-9abe-3ae9e96fa183"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AIndexQ", "[", 
  RowBox[{"\[GothicCapitalA]", ",", "TangentM3"}], "]"}]], "Input",
 CellLabel->"In[93]:=",ExpressionUUID->"b52ffada-af64-4caf-bcee-7d5d4b44afa4"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.7289777670221148`*^9},
 CellLabel->"Out[93]=",
 CellID->457087905,ExpressionUUID->"3f4c39d4-08f4-4a80-b461-b85d542f94df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AIndexQ", "[", 
  RowBox[{"\[GothicCapitalA]", ",", "InnerC"}], "]"}]], "Input",
 CellLabel->"In[94]:=",ExpressionUUID->"4523e501-bcf2-44ca-84c5-8d130fd60953"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.728977767390678*^9},
 CellLabel->"Out[94]=",
 CellID->727414016,ExpressionUUID->"dfdb62b5-4db2-4525-8d5e-bf8d2599b854"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AIndexQ", "[", 
  RowBox[{"\[GothicCapitalA]\[Dagger]", ",", "InnerC"}], "]"}]], "Input",
 CellLabel->"In[95]:=",ExpressionUUID->"e6831a30-14c5-4617-98bf-db129f2a99bb"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.72897776769016*^9},
 CellLabel->"Out[95]=",
 CellID->22964541,ExpressionUUID->"7803c63a-3420-4271-b6e9-971bb2fcce3b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AIndexQ", "[", 
  RowBox[{"\[GothicCapitalA]\[Dagger]", ",", "InnerC\[Dagger]"}], 
  "]"}]], "Input",
 CellLabel->"In[96]:=",ExpressionUUID->"5a1dba44-ace2-434d-9f99-d5f162116f4a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.728977767919726*^9},
 CellLabel->"Out[96]=",
 CellID->1565467774,ExpressionUUID->"396e0ea3-8712-4e7b-bce8-654dec092a3e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Each vbundle has two special functions that select abstract indices on that \
manifold. For example for the vbundle ",
 StyleBox["TangentM3",
  FontFamily->"Courier"],
 " they are ",
 StyleBox["TangentM3`Q",
  FontFamily->"Courier"],
 " and ",
 StyleBox["TangentM3`pmQ",
  FontFamily->"Courier"],
 ". The former only accepts contravariant indices; the latter accepts both \
characters. The use of context notation (the ` ) is purely historical : \
before using upvalues to store information I tried to use contexts, but it is \
less convenient."
}], "MathCaption",ExpressionUUID->"b8055217-df79-4c70-bd9b-bb7fe710db97"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TangentM3`Q", "[", "a", "]"}]], "Input",
 CellLabel->"In[97]:=",ExpressionUUID->"dad30ed6-0200-4030-8551-9bb366ebb246"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.7289777680481977`*^9},
 CellLabel->"Out[97]=",
 CellID->1994718221,ExpressionUUID->"fd6f2a5d-fd49-48ef-aba8-e713f1cdee68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TangentM3`Q", "[", 
  RowBox[{"-", "a"}], "]"}]], "Input",
 CellLabel->"In[98]:=",ExpressionUUID->"454c5e63-6461-496f-b8d3-f13466121428"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.7289777682948627`*^9},
 CellLabel->"Out[98]=",
 CellID->861927030,ExpressionUUID->"0529e84c-04d4-4088-9a8e-03f6e590dbe5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TangentM3`Q", "[", "A", "]"}]], "Input",
 CellLabel->"In[99]:=",ExpressionUUID->"a2fc3080-0eb3-4b50-a88e-afe72570ae57"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.7289777684142857`*^9},
 CellLabel->"Out[99]=",
 CellID->1630394195,ExpressionUUID->"2623b412-737b-4874-9c53-ccb18932f5d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TangentM3`pmQ", "[", "a", "]"}]], "Input",
 CellLabel->
  "In[100]:=",ExpressionUUID->"a0dcff7c-244e-4028-9ca0-29524d13b40c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.728977768521274*^9},
 CellLabel->"Out[100]=",
 CellID->143899645,ExpressionUUID->"e0fb5b01-4b2e-4d13-8f42-45af8107588b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TangentM3`pmQ", "[", 
  RowBox[{"-", "a"}], "]"}]], "Input",
 CellLabel->
  "In[101]:=",ExpressionUUID->"812c0777-64e1-4c21-ac43-2d4636fce7e3"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.7289777687744207`*^9},
 CellLabel->"Out[101]=",
 CellID->454746993,ExpressionUUID->"55567e55-84f0-4f2a-aaf2-a057c5fdedca"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3. Get (new) indices", "Subsection",ExpressionUUID->"8c80a1fc-ae59-4563-9ed8-74a9291dbd67"],

Cell[TextData[{
 "Sometimes we need to use many indices. There are two ways to do it. We can \
register more symbols using ",
 StyleBox["AddIndices",
  FontFamily->"Courier"],
 " or we can ask ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " to generate new indices for a vbundle using ",
 StyleBox["NewIndexIn",
  FontFamily->"Courier"],
 " (it uses a combination of the last registered symbol and integer numbers). \
User-defined indices and computer-defined indices are kept in two different \
lists."
}], "Text",ExpressionUUID->"abf05f7d-06d5-41e5-84d5-fb9be5879686"],

Cell[TextData[{
 StyleBox[ButtonBox["AddIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AddIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Add user-defined indices to a vbundle", "Text"],
 StyleBox["\n", "DisplayMath"],
 StyleBox[ButtonBox["RemoveIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RemoveIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["Remove user-defined indices from a vbundle\n", "Text"],
 StyleBox[ButtonBox["NewIndexIn",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "NewIndexIn.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Generate a computer-defined index", "Text"],
 StyleBox["\n", "DisplayMath"],
 StyleBox[ButtonBox["GetIndicesOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GetIndicesOfVBundle.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["Give ", "Text"],
 StyleBox["n", "Text",
  FontFamily->"Courier"],
 StyleBox[" indices", "Text"]
}], "DefinitionBox",
 CellChangeTimes->{
  3.72897777804665*^9},ExpressionUUID->"c3266cf3-6f91-4b2f-bc1c-b8156c655034"],

Cell["Functions that return or change the available indices.", "Text",ExpressionUUID->"afe27f77-65c3-4bd6-981b-82149b8b6a85"],

Cell[CellGroupData[{

Cell["\<\
Currently there are only user-defined indices. We add some more:\
\>", "MathCaption",ExpressionUUID->"d5be2c62-63d1-4d6d-a3c0-9998bb7664e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}]], "Input",
 CellLabel->
  "In[102]:=",ExpressionUUID->"55710039-c479-47a7-b899-8d71ae9e59e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728977780854219*^9},
 CellLabel->"Out[102]=",
 CellID->391059037,ExpressionUUID->"077638e7-1096-4d3c-b211-46856bc1d771"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"AddIndices", "[", 
  RowBox[{"TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[103]:=",ExpressionUUID->"604a62e1-604b-408e-b03c-cf0fbe723691"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}]], "Input",
 CellLabel->
  "In[104]:=",ExpressionUUID->"c452fb46-83d3-45b7-a523-573fb51ae540"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h",
      ",", "i", ",", "j", ",", "k", ",", "l"}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728977781043365*^9},
 CellLabel->"Out[104]=",
 CellID->1229275039,ExpressionUUID->"865fcbc3-138c-43e9-b678-60093bcab966"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We can also remove indices, but this is a very dangerous operation because \
some previous expressions could get corrupted if they contain removed \
indices. There is no built-in command to check whether this is happening or \
not.\
\>", "MathCaption",ExpressionUUID->"fe691718-bca7-490d-810f-0e942c00e537"],

Cell[BoxData[
 RowBox[{"RemoveIndices", "[", 
  RowBox[{"TangentM3", ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "i", ",", "l", ",", "k"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[105]:=",ExpressionUUID->"82c84a3a-3c9b-4bc5-ac1d-227eb375a76d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}]], "Input",
 CellLabel->
  "In[106]:=",ExpressionUUID->"f875e084-0440-429b-870c-7f0247c6e44f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728977781234248*^9},
 CellLabel->"Out[106]=",
 CellID->1632896333,ExpressionUUID->"8b2ccf57-90e0-4b2c-983a-e04cbc5807bc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " generates new indices using ",
 StyleBox["NewIndexIn",
  FontFamily->"Courier"]
}], "MathCaption",ExpressionUUID->"4baf3557-ec02-446c-bbdf-962e9c3128bf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewIndexIn", "[", "TangentM3", "]"}]], "Input",
 CellLabel->
  "In[107]:=",ExpressionUUID->"39cc2e40-646d-4538-8615-073d65df5cf3"],

Cell[BoxData["h1"], "Output",
 CellChangeTimes->{3.728977781475079*^9},
 CellLabel->"Out[107]=",
 CellID->1395143718,ExpressionUUID->"4dc095b7-56c6-4548-8b0e-57086340a0c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}]], "Input",
 CellLabel->
  "In[108]:=",ExpressionUUID->"82886089-dd34-47f4-815f-ea7b75deb5f5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", 
   RowBox[{"{", "h1", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728977781742084*^9},
 CellLabel->"Out[108]=",
 CellID->1954010480,ExpressionUUID->"9aba1e9d-6933-42b7-aa8a-ff59927dcc6c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The user-function to get any number of indices is ",
 StyleBox["GetIndicesOfVBundle",
  FontFamily->"Courier"],
 ". Note that the last argument is a list of symbols that we do not want to \
get:"
}], "MathCaption",ExpressionUUID->"a0ea6373-2bad-4d25-bee0-9053c79469c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetIndicesOfVBundle", "[", 
  RowBox[{"TangentM3", ",", "14", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "h3"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[109]:=",ExpressionUUID->"438e6e57-0cde-47b7-a514-ca941c825f25"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "f", ",", "g", ",", "h", ",", "h1", ",", "h2",
    ",", "h4", ",", "h5", ",", "h6", ",", "h7", ",", "h8", ",", "h9"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.72897778201334*^9},
 CellLabel->"Out[109]=",
 CellID->1734207436,ExpressionUUID->"8211a7e3-a7a6-4cc6-9ef0-1124f422f01a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}]], "Input",
 CellLabel->
  "In[110]:=",ExpressionUUID->"0a2288d1-079a-4af0-847c-7c30de238ef1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "h1", ",", "h2", ",", "h3", ",", "h4", ",", "h5", ",", "h6", ",", "h7", 
     ",", "h8", ",", "h9"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7289777821868963`*^9},
 CellLabel->"Out[110]=",
 CellID->1176319768,ExpressionUUID->"1bdc9522-c8a1-464b-8788-d3f155c0f8b7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The indices of complex conjugated vbundles are paired, and therefore if we \
generate an index in one of them, automatically the complex conjugated index \
is generated in the other one:\
\>", "MathCaption",ExpressionUUID->"45b89367-4d86-4a1d-a75f-ea3654f77f5c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewIndexIn", "[", "InnerC", "]"}]], "Input",
 CellLabel->
  "In[111]:=",ExpressionUUID->"ec29ef21-2bac-478f-b4a9-e1751f168b64"],

Cell[BoxData["\[GothicCapitalH]1"], "Output",
 CellChangeTimes->{3.728977782609326*^9},
 CellLabel->"Out[111]=",
 CellID->671886494,ExpressionUUID->"ac8f83d9-0c91-49ba-b023-d82be5b0f99e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "InnerC", "]"}]], "Input",
 CellLabel->
  "In[112]:=",ExpressionUUID->"30d30216-18dc-4d89-90ef-f0f90582887c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", "\[GothicCapitalC]", 
     ",", "\[GothicCapitalD]", ",", "\[GothicCapitalE]", ",", 
     "\[GothicCapitalF]", ",", "\[GothicCapitalG]", ",", 
     "\[GothicCapitalH]"}], "}"}], ",", 
   RowBox[{"{", "\[GothicCapitalH]1", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728977782769821*^9},
 CellLabel->"Out[112]=",
 CellID->927288732,ExpressionUUID->"1d7446f7-5815-4f36-8b31-4bc84990cb50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "InnerC\[Dagger]", "]"}]], "Input",
 CellLabel->
  "In[113]:=",ExpressionUUID->"325aebc8-1c3b-4e25-a3ae-62faf917301a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
     "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
     "\[GothicCapitalE]\[Dagger]", ",", "\[GothicCapitalF]\[Dagger]", ",", 
     "\[GothicCapitalG]\[Dagger]", ",", "\[GothicCapitalH]\[Dagger]"}], "}"}],
    ",", 
   RowBox[{"{", "\[GothicCapitalH]1\[Dagger]", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728977782932928*^9},
 CellLabel->"Out[113]=",
 CellID->652892445,ExpressionUUID->"c9fa1af9-cab6-4c31-b82a-fbc0f0914464"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetIndicesOfVBundle", "[", 
  RowBox[{"InnerC\[Dagger]", ",", "10"}], "]"}]], "Input",
 CellLabel->
  "In[114]:=",ExpressionUUID->"8de04d3a-5ca4-47ae-8ef3-87ed5685e24e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
   "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
   "\[GothicCapitalE]\[Dagger]", ",", "\[GothicCapitalF]\[Dagger]", ",", 
   "\[GothicCapitalG]\[Dagger]", ",", "\[GothicCapitalH]1\[Dagger]", ",", 
   "\[GothicCapitalH]\[Dagger]", ",", "\[GothicCapitalH]2"}], "}"}]], "Output",\

 CellChangeTimes->{3.728977783054936*^9},
 CellLabel->"Out[114]=",
 CellID->1669370592,ExpressionUUID->"916ea33a-4ee0-48db-b622-b0b015a67b2d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "InnerC", "]"}]], "Input",
 CellLabel->
  "In[115]:=",ExpressionUUID->"909ff47a-feb3-49a9-9fcb-f832d17797de"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", "\[GothicCapitalC]", 
     ",", "\[GothicCapitalD]", ",", "\[GothicCapitalE]", ",", 
     "\[GothicCapitalF]", ",", "\[GothicCapitalG]", ",", 
     "\[GothicCapitalH]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[GothicCapitalH]1", ",", "\[GothicCapitalH]2"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.72897778315714*^9},
 CellLabel->"Out[115]=",
 CellID->237691689,ExpressionUUID->"ca4b4e19-05c6-407d-8e66-253b4e4167b5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Note the information associated to an abstract index:", "MathCaption",ExpressionUUID->"684bdef6-822b-477a-8bf3-54d8fbcc0ec1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "\[GothicCapitalA]"}]], "Input",
 CellLabel->
  "In[116]:=",ExpressionUUID->"ca31c5f4-8ea5-457c-96ef-72abed459a54"],

Cell[CellGroupData[{

Cell["Global`\[GothicCapitalA]", "Print", "PrintUsage",
 CellChangeTimes->{3.728977783291326*^9},
 CellTags->"Info1163728981383-9181623",
 CellID->564633603,ExpressionUUID->"58195580-63ce-46a6-9406-193b5711864f"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"AbstractIndexQ", "[", "\[GothicCapitalA]", "]"}], "^=", 
         "True"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DaggerIndex", "[", "\[GothicCapitalA]", "]"}], "^=", 
         "\[GothicCapitalA]\[Dagger]"}]},
       {" "},
       {
        RowBox[{
         RowBox[{
         "xAct`xTensor`Private`NoDollar", "[", "\[GothicCapitalA]", "]"}], "^=",
          "\[GothicCapitalA]"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "\[GothicCapitalA]", "]"}], 
         "^=", "\<\"\[GothicCapitalA]\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"InnerC`Q", "[", "\[GothicCapitalA]", "]"}], "^=", 
         "True"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"VBundleOfIndex", "[", "\[GothicCapitalA]", "]"}], "^=", 
         InterpretationBox[
          StyleBox["InnerC",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`InnerC,
          Editable->False]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`\[GothicCapitalA]],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977783312869*^9},
 CellTags->"Info1163728981383-9181623",
 CellID->66729528,ExpressionUUID->"0c3eff53-b245-4530-b9f2-53af8ab16efe"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Tensors and tensor slots", "Section",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.7286627354220657`*^9, 3.728662748172317*^9}, {
  3.728664037492599*^9, 3.72866403885896*^9}, {3.7286704747855062`*^9, 
  3.728670480415387*^9}, {3.728670889883876*^9, 3.728670893540101*^9}, {
  3.728673410238123*^9, 3.728673425886174*^9}, {3.7289761721698513`*^9, 
  3.7289761765432653`*^9}, {3.728976277988899*^9, 3.728976287866613*^9}, {
  3.728976341130004*^9, 3.728976342960009*^9}, {3.72897639317553*^9, 
  3.728976399469426*^9}},
 FontSize->18,
 FontColor->GrayLevel[0],
 CellTags->{"S5.18.1", "1.4"},
 CellID->1339531280,ExpressionUUID->"f4f44c18-1ef4-4eff-98cd-53767a44bc77"],

Cell[CellGroupData[{

Cell["3.1. Define a tensor", "Subsection",ExpressionUUID->"6e665f91-497f-409e-85c8-983c34cca83a"],

Cell[TextData[{
 "Now we can define tensors. In ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " we always work with tensor fields on zero, one or several manifolds, \
having indices on zero, one or several of their vbundles."
}], "Text",ExpressionUUID->"b6150745-e0ba-469a-bd7c-7fa6677052d8"],

Cell[TextData[{
 StyleBox[ButtonBox["DefTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Define a tensor\n", "Text"],
 StyleBox[ButtonBox["UndefTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Undefine a tensor\n", "Text"],
 StyleBox[ButtonBox["xTensorQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "xTensorQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Check a tensor\n", "Text"],
 StyleBox[ButtonBox["$Tensors",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Tensors.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["List of defined tensors", "Text"]
}], "DefinitionBox",ExpressionUUID->"77b34b2e-6302-4f68-8cb8-b9dec729d00a"],

Cell["Definition of tensors.", "Text",ExpressionUUID->"52e4347c-1f61-48cc-96cf-1d5af49db5ed"],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a tensor field ",
 StyleBox["T",
  FontFamily->"Courier"],
 " on ",
 StyleBox["M3",
  FontFamily->"Courier"],
 " with two contravariant indices and one covariant index, and two other \
tensors. The actual indices used in the definition are irrelevant, and are \
only meant to specify the vbundle associated to each slot"
}], "MathCaption",ExpressionUUID->"cb266cfd-184e-44cb-b1ab-3d2cd4c92074"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", "M3"}], "]"}]], "Input",
 CellLabel->
  "In[117]:=",ExpressionUUID->"e909f5d5-4eb4-4e66-aba4-6c821b279003"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[$CellContext`a, $CellContext`b, -$CellContext`c], ". ", ""],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.728977796474069*^9},
 CellLabel->"During evaluation of In[117]:=",
 CellID->1083110202,ExpressionUUID->"1e41444b-094e-4b97-964c-4d443f6a9be6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "M3"}], "]"}]], "Input",
 CellLabel->
  "In[118]:=",ExpressionUUID->"23ddea17-1aa7-4ccd-8c2c-534254357ebd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[$CellContext`a, $CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977796624576*^9},
 CellLabel->"During evaluation of In[118]:=",
 CellID->1761773042,ExpressionUUID->"7622fc00-a7ba-483e-9758-0f9fdc824475"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M3"}], "]"}]], "Input",
 CellLabel->
  "In[119]:=",ExpressionUUID->"bc8594f3-abaa-44d1-b2d7-49f49663aa87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777967579813`*^9},
 CellLabel->"During evaluation of In[119]:=",
 CellID->614992058,ExpressionUUID->"e8c8137e-392b-4e08-b7cf-be74ce60110d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a scalar field ",
 StyleBox["r",
  FontFamily->"Courier"],
 " (do not forget the empty pair of brackets!)"
}], "MathCaption",ExpressionUUID->"6986e7f3-fc49-4f57-b7fd-35cc6fd8a5c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"r", "[", "]"}], ",", "M3"}], "]"}]], "Input",
 CellLabel->
  "In[120]:=",ExpressionUUID->"3b7640fa-e6ef-4593-8ddb-ab5073518a94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"r", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`r[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777968733473`*^9},
 CellLabel->"During evaluation of In[120]:=",
 CellID->332725795,ExpressionUUID->"1d47e5f9-33a7-4449-9f5e-7ff8aff31037"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a tensor ",
 StyleBox["U",
  FontFamily->"Courier"],
 " on ",
 StyleBox["M3",
  FontFamily->"Courier"],
 " and ",
 StyleBox["S2",
  FontFamily->"Courier"],
 " with two contravariant indices and one covariant index, The tensor is also \
a function of the parameter time:"
}], "MathCaption",ExpressionUUID->"f22202b1-e4a5-4b3d-a847-f93f27bfc2ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "C"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"M3", ",", "S2", ",", "time"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[121]:=",ExpressionUUID->"20af02d0-e91b-4822-904e-334ddfcd005d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "C"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[$CellContext`a, $CellContext`b, -C], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977796991355*^9},
 CellLabel->"During evaluation of In[121]:=",
 CellID->75019777,ExpressionUUID->"4b4d64c5-3907-4145-9d39-5a9fecca207e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The tensor is identified by a symbol and we shall associate to that symbol \
all definitions related to the tensor. This is internally done using ",
 StyleBox["UpSet",
  FontFamily->"Courier"],
 " (^=) rather than ",
 StyleBox["Set",
  FontFamily->"Courier"],
 " (=). The definitions can then be collected using ",
 StyleBox["?",
  FontFamily->"Courier"]
}], "Text",ExpressionUUID->"a932613c-c10f-409d-bce5-8b63a0006442"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "U"}]], "Input",
 CellLabel->
  "In[122]:=",ExpressionUUID->"3325b290-4960-4c9d-bcc0-7bee99df921f"],

Cell[CellGroupData[{

Cell["Global`U", "Print", "PrintUsage",
 CellChangeTimes->{3.7289777971240253`*^9},
 CellTags->"Info1223728981397-9181623",
 CellID->284491250,ExpressionUUID->"51354a4a-940d-40e8-8e3e-9b1c29871105"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "U", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`U],
          Editable->False], "^=", "U"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["time",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`time,
            Editable->False], ",", "M3", ",", "S2"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"M3", ",", "S2", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]S2",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentS2,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["time",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`time,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "U", "]"}], "^=", "\<\"U\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], ",", 
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]S2",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentS2,
             Editable->False]}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "U", "]"}], "^=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"GenSet", "[", "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "U", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "U", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`U],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977797147203*^9},
 CellTags->"Info1223728981397-9181623",
 CellID->1145840528,ExpressionUUID->"14242c38-c27d-43a7-955c-6a18caddad3f"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A tensor can be undefined. Its properties are lost, and the symbol is removed.\
\>", "MathCaption",ExpressionUUID->"5bec7d37-3441-42aa-ac77-fe2c5ff31cb9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "U", "]"}]], "Input",
 CellLabel->
  "In[123]:=",ExpressionUUID->"44a1d28c-a478-43de-b726-175b2cbe502b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "U"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`U],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777973574677`*^9},
 CellLabel->"During evaluation of In[123]:=",
 CellID->1655891447,ExpressionUUID->"04722cc1-71bb-48de-bba7-38ed39adda76"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "U"}]], "Input",
 CellLabel->
  "In[124]:=",ExpressionUUID->"372ddd7d-2650-4c09-9477-f0fcfeae250d"],

Cell[BoxData[
 TemplateBox[{
  "Information", "notfound", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"\\\\\\\"U\\\\\\\"\\\"}]\\) not found.\"", 2,
    124, 10, 19253573948027831207, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.728977797693821*^9},
 CellLabel->"During evaluation of In[124]:=",
 CellID->1326968256,ExpressionUUID->"45eed1e1-1aaa-479b-8f10-034e7d87737f"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "An object with indices on a given vbundle is considered to be necessarily a \
field on the base manifold of that vbundle. ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " checks that point. See the discussion below on Constant objects."
}], "Text",ExpressionUUID->"eac2a4fa-aaf4-46e1-8eb8-fac4551dd604"],

Cell[CellGroupData[{

Cell[TextData[{
 "The tensor ",
 StyleBox["U",
  FontFamily->"Courier"],
 " with indices on vbundles ",
 StyleBox["TangentM3",
  FontFamily->"Courier"],
 " and ",
 StyleBox["TangentS2",
  FontFamily->"Courier"],
 " is defined to live only on ",
 StyleBox["M3",
  FontFamily->"Courier"],
 ". ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " adds the manifold ",
 StyleBox["S2",
  FontFamily->"Courier"],
 " to the list ",
 StyleBox["DependenciesOfTensor[U].",
  FontFamily->"Courier"]
}], "MathCaption",ExpressionUUID->"43e5cec0-c28c-457a-b300-2ba1c20f74e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{"a", ",", "A"}], "]"}], ",", "M3"}], "]"}]], "Input",
 CellLabel->
  "In[125]:=",ExpressionUUID->"d9bacb74-5924-467a-9802-2a4ff6b729a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{"a", ",", "A"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[$CellContext`a, $CellContext`A], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977797853896*^9},
 CellLabel->"During evaluation of In[125]:=",
 CellID->737804497,ExpressionUUID->"1203a021-fd2d-4d39-872b-2692e1646fc9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "U"}]], "Input",
 CellLabel->
  "In[126]:=",ExpressionUUID->"2a6b19c0-33cf-4265-968a-23e42c6a4d2c"],

Cell[CellGroupData[{

Cell["Global`U", "Print", "PrintUsage",
 CellChangeTimes->{3.7289777979419537`*^9},
 CellTags->"Info1263728981397-9181623",
 CellID->709603301,ExpressionUUID->"125cac5c-4025-4a7f-a7b8-a2538f16f51f"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "U", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`U],
          Editable->False], "^=", "U"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "U", "]"}], "^=", 
         RowBox[{"{", "M3", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"M3", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]S2",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentS2,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "U", "]"}], "^=", "\<\"U\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]S2",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentS2,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "U", "]"}], "^=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"GenSet", "[", "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "U", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "U", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`U],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977797967342*^9},
 CellTags->"Info1263728981397-9181623",
 CellID->1325988116,ExpressionUUID->"493ff12b-20ae-40f5-99b4-5f0b62a6615a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["UndefTensor[U]", "Input",
 CellLabel->
  "In[127]:=",ExpressionUUID->"b7df524a-d99c-4041-8abb-9cbaca17e715"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "U"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`U],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289777981022*^9},
 CellLabel->"During evaluation of In[127]:=",
 CellID->1444460693,ExpressionUUID->"25395c65-cc6f-46bd-8ab8-6a451c4d2ffc"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Note that, from version 1.0 of",
 StyleBox[" xTensor`",
  FontFamily->"Courier"],
 ", it is now possible to work with tensors whose head is not a symbol, but a \
more complicated expression. See the update in section 3.7."
}], "Text",ExpressionUUID->"c8c17be7-a18e-43f2-8cd3-4b7a909f5c69"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. Standard output", "Subsection",ExpressionUUID->"46b8adf0-3b18-4471-8061-37060ea25fd1"],

Cell[TextData[{
 "It is important to have nice-looking output expressions, mainly when we \
deal with very large expressions. ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " has built-in rules to convert tensors and derivatives into 2-dimensional \
boxes for ",
 StyleBox["StandardForm",
  FontFamily->"Courier"],
 " output. Those boxes can be cut and pasted, using ",
 StyleBox["InterpretationBox",
  FontFamily->"Courier"],
 ". Additionally, translation to ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"L", 
    StyleBox[
     AdjustmentBox["A",
      BoxBaselineShift->-0.2,
      BoxMargins->{{-0.36, -0.1}, {0, 0}}],
     FontSize->Smaller], "T", 
    AdjustmentBox["E",
     BoxBaselineShift->0.5,
     BoxMargins->{{-0.075, -0.085}, {0, 0}}], "X"}]]],ExpressionUUID->
  "9834a37d-1481-4be5-a931-06d4e16d22da"],
 " will be shown below."
}], "Text",ExpressionUUID->"a8f8d757-5dbf-417d-8a23-8240bd97d0c1"],

Cell[CellGroupData[{

Cell[TextData[{
 "The output of tensors in ",
 StyleBox["StandardForm",
  FontFamily->"Courier"],
 " has been defined with 2-dimensional boxes, but the internal structure is \
kept in 1-dimensional form (as usual in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "):"
}], "MathCaption",ExpressionUUID->"9e6f37b7-0fbd-4a21-8e30-f2652596eaaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"v", "[", 
    RowBox[{"-", "a"}], "]"}], ",", 
   RowBox[{"r", "[", "]"}]}], "}"}]], "Input",
 CellLabel->
  "In[128]:=",ExpressionUUID->"cebd0320-5f16-4328-9816-e722b7b75061"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {"a", "b", " "},
           {" ", " ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[$CellContext`a, $CellContext`b, -$CellContext`c],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[$CellContext`a, $CellContext`b],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"v", 
        StyleBox[GridBox[{
           {" "},
           {"a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`v[-$CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["r",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`r[],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.7289778087250147`*^9},
 CellLabel->"Out[128]=",
 CellID->713664600,ExpressionUUID->"71ec79e4-14b4-4f43-a8b2-63acb13d242d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[129]:=",ExpressionUUID->"697f1067-67f7-4b49-82b5-bad6dacbd53e"],

Cell["{T[a, b, -c], S[a, b], v[-a], r[]}", "Output",
 CellChangeTimes->{3.7289778088743753`*^9},
 CellLabel->"Out[129]//InputForm=",
 CellID->864763705,ExpressionUUID->"e2de2219-b328-4620-b812-354bc0a1597c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "No rules have been defined for ",
 StyleBox["OutputForm",
  FontFamily->"Courier"],
 " because the output is simple enough:"
}], "MathCaption",ExpressionUUID->"14262219-47b3-426f-a774-55ed1891688f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", "%%", "]"}]], "Input",
 CellLabel->
  "In[130]:=",ExpressionUUID->"b9f3d553-d9ac-4b3b-b24e-8396dd824f22"],

Cell[OutputFormData["\<\
{T[a, b, -c], S[a, b], v[-a], r[]}\
\>", "\<\
{T[a, b, -c], S[a, b], v[-a], r[]}\
\>"], "Output",
 CellChangeTimes->{3.728977809003673*^9},
 CellLabel->"Out[130]//OutputForm=",
 CellID->2061750686,ExpressionUUID->"bc22edc7-46e3-45e7-b207-5cc70217bf74"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The ouput representation of the heads can be given at definition time, or \
changed later. Again, this is only possible in ",
 StyleBox["StandardForm",
  FontFamily->"Courier"],
 ". When using this option, it is very important to remember that the input \
and output names of the same tensor are different!"
}], "Text",ExpressionUUID->"2ddfb04f-79b2-4628-8a54-be7dd6c5d127"],

Cell[TextData[{
 StyleBox[ButtonBox["PrintAs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PrintAs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t\t", "DisplayMath"],
 StyleBox["Option of ", "Text"],
 StyleBox["DefType", "Text",
  FontFamily->"Courier"],
 StyleBox[" functions to define the output of a head", "Text"]
}], "DefinitionBox",ExpressionUUID->"1fa6c783-fc39-42cb-a9e6-0fadd5dabb13"],

Cell["Output of defined heads.", "Text",ExpressionUUID->"dfc0d1ae-5874-420d-81a8-7f54fde2895f"],

Cell[CellGroupData[{

Cell[TextData[{
 "The tensor ",
 StyleBox["TT",
  FontFamily->"Courier"],
 " will be output as ",
 StyleBox["\[Tau]",
  FontFamily->"Courier"],
 ". ",
 StyleBox["PrintAs",
  FontFamily->"Courier"],
 " must give a string or a function that applied on the defined symbol gives \
a string"
}], "MathCaption",ExpressionUUID->"a35238a9-4a66-4702-9e53-5dc85bd52dc6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"TT", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", " ", "M3", ",", " ", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<\[Tau]\>\""}]}], "]"}]], "Input",
 CellLabel->
  "In[131]:=",ExpressionUUID->"34e02ad1-a042-44c9-9e4c-81a5b7cb5bcc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TT", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TT[$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778091252203`*^9},
 CellLabel->"During evaluation of In[131]:=",
 CellID->47651610,ExpressionUUID->"3240a1b8-1453-41c1-9b58-db31ae5c1d0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TT", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "c"}]}], "]"}]], "Input",
 CellLabel->
  "In[132]:=",ExpressionUUID->"d9ac9c61-3d48-4166-8427-2d96affd6e96"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Tau]", 
      StyleBox[GridBox[{
         {"a", " "},
         {" ", "c"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TT[$CellContext`a, -$CellContext`c],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977809395767*^9},
 CellLabel->"Out[132]=",
 CellID->2016692586,ExpressionUUID->"3d862ef4-be35-4b67-80cc-e593b9070726"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[133]:=",ExpressionUUID->"069da075-c092-4052-a1f2-7d90e01fe546"],

Cell["TT[a, -c]", "Output",
 CellChangeTimes->{3.728977809696003*^9},
 CellLabel->"Out[133]//InputForm=",
 CellID->817892301,ExpressionUUID->"fb4f208e-488c-48ac-8ab1-7a871566ffea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["As an example of a printas function we can use:", "MathCaption",ExpressionUUID->"dc0a0313-a72b-46d0-9678-ef1987cf6b04"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FirstCharacter", "[", "symbol_", "]"}], ":=", 
  RowBox[{"First", "[", 
   RowBox[{"Characters", "[", 
    RowBox[{"ToString", "[", "symbol", "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->
  "In[134]:=",ExpressionUUID->"f4f3cf21-8ae1-400e-8d8c-071acd584d55"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"Force", "[", "a", "]"}], ",", " ", "M3", ",", " ", 
   RowBox[{"PrintAs", "\[Rule]", "FirstCharacter"}]}], "]"}]], "Input",
 CellLabel->
  "In[135]:=",ExpressionUUID->"9db0fada-cdf3-40eb-b024-f57f8c6e6539"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Force", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Force[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977810108201*^9},
 CellLabel->"During evaluation of In[135]:=",
 CellID->273078460,ExpressionUUID->"335e854b-29c4-4062-b84b-0e61fbaab3fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Force", "[", "a", "]"}]], "Input",
 CellLabel->
  "In[136]:=",ExpressionUUID->"f957743c-546a-43ae-a38c-a06061a88412"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"F", 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Force[$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289778102434187`*^9},
 CellLabel->"Out[136]=",
 CellID->457123581,ExpressionUUID->"08818c66-c99a-48ca-b9ac-3e5c24b6a929"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The formatting of a tensor can be manually changed at any time:\
\>", "MathCaption",ExpressionUUID->"a7509d5c-c4bf-4d58-88f5-9155a82b7505"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrintAs", "[", "Force", "]"}], "^=", 
  "\"\<\[ScriptCapitalF]\>\""}]], "Input",
 CellLabel->
  "In[137]:=",ExpressionUUID->"e4a72725-8685-4ace-a4f0-ff911667b4e2"],

Cell[BoxData["\<\"\[ScriptCapitalF]\"\>"], "Output",
 CellChangeTimes->{3.7289778104118433`*^9},
 CellLabel->"Out[137]=",
 CellID->1327020548,ExpressionUUID->"f2898a4f-b588-42d6-95e9-4d5a9d8fb805"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Force", "[", "a", "]"}]], "Input",
 CellLabel->
  "In[138]:=",ExpressionUUID->"addd8d6b-1be4-43e2-be3c-d488149b96e7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[ScriptCapitalF]", 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Force[$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977810845522*^9},
 CellLabel->"Out[138]=",
 CellID->1616676141,ExpressionUUID->"031a0caf-12e7-4ec4-b794-3660389bac1c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The 2-dimensional boxes are based on a combination of three built-in's: \n\t\
",
 StyleBox["SubsuperscriptBox/GridBox",
  FontFamily->"Courier"],
 ", which construct the sub/super-indices structures,\n\t",
 StyleBox["StyleBox",
  FontFamily->"Courier"],
 ", which arranges the indices with the proper interspaces, and\n\t",
 StyleBox["InterpretationBox",
  FontFamily->"Courier"],
 ", which stores both the box-form and the input-form of the expression. Note \
the option ",
 StyleBox["Editable->False",
  FontFamily->"Courier"],
 ", which prevents desynchronization. \nBefore version 1.0.0 we always used a \
formatting based on ",
 StyleBox["SubsuperscriptBox",
  FontFamily->"Courier"],
 ". Now we use a formatting based on ",
 StyleBox["GridBox",
  FontFamily->"Courier"],
 ", which allows vertical alignment of indices. This can be controlled with a \
global variable:"
}], "MathCaption",
 CellChangeTimes->{{3.494607480806465*^9, 3.494607484000292*^9}, {
  3.494607534420059*^9, 3.49460753608278*^9}, {3.494607574200631*^9, 
  3.494607584272273*^9}},ExpressionUUID->"87db2a4b-67fc-4759-a55e-\
3009a584e9df"],

Cell[CellGroupData[{

Cell[BoxData["$TensorBoxes"], "Input",
 CellChangeTimes->{{3.494607345412532*^9, 3.494607386932415*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"9410297d-59b2-4490-a6df-4f3c20857999"],

Cell[BoxData["\<\"GridBox\"\>"], "Output",
 CellChangeTimes->{3.7289778111741877`*^9},
 CellLabel->"Out[139]=",
 CellID->1512799943,ExpressionUUID->"2439ebe4-7ad2-441a-93f8-178a2e3caa29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Force", "[", "a", "]"}]], "Input",
 CellChangeTimes->{{3.494607407743402*^9, 3.4946074100472403`*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"393998c1-3a41-44f3-a7ad-22def2da8c61"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[ScriptCapitalF]", 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Force[$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977811356537*^9},
 CellLabel->"Out[140]=",
 CellID->1569745168,ExpressionUUID->"b2fed207-b25e-4660-9772-2e601c5da022"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[141]:=",ExpressionUUID->"e67ac65b-ec58-4095-80dd-11bf04d39008"],

Cell[BoxData[
 RowBox[{"InterpretationBox", "[", 
  RowBox[{
   RowBox[{"StyleBox", "[", 
    RowBox[{
     RowBox[{"GridBox", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\<\"\[ScriptCapitalF]\"\>", ",", 
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"GridBox", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "\<\"a\"\>", "}"}], ",", 
                RowBox[{"{", "\<\" \"\>", "}"}]}], "}"}], ",", 
              RowBox[{"RowSpacings", "\[Rule]", "0"}], ",", 
              RowBox[{"ColumnSpacings", "\[Rule]", "0.05`"}], ",", 
              RowBox[{"GridFrameMargins", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}], ",", 
            RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}]}], "}"}], "}"}], 
       ",", 
       RowBox[{"ColumnSpacings", "\[Rule]", "0.05`"}], ",", 
       RowBox[{"RowAlignments", "\[Rule]", "Center"}]}], "]"}], ",", 
     RowBox[{"AutoSpacing", "\[Rule]", "False"}], ",", 
     RowBox[{"ShowAutoStyles", "\[Rule]", "False"}]}], "]"}], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalF]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Force[$CellContext`a],
    Editable->False], ",", 
   RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]], "Output",
 CellChangeTimes->{3.7289778115604753`*^9},
 CellLabel->"Out[141]=",
 CellID->870435181,ExpressionUUID->"0f371ab1-ed8f-49ce-b193-3141a4b7f69d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$TensorBoxes", "=", "\"\<ScriptBox\>\""}]], "Input",
 CellChangeTimes->{{3.4946074131505013`*^9, 3.494607440428686*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"506b43dd-d44b-42ab-a324-bb96123030a9"],

Cell[BoxData["\<\"ScriptBox\"\>"], "Output",
 CellChangeTimes->{3.728977811692133*^9},
 CellLabel->"Out[142]=",
 CellID->745483703,ExpressionUUID->"43b9f0f4-6917-4366-887c-97c2d0fa29fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Force", "[", "a", "]"}]], "Input",
 CellChangeTimes->{{3.494607427005692*^9, 3.4946074286021557`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"ba03388a-e27c-4842-8b54-5886190efa55"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["\[ScriptCapitalF]", " ", "a"],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Force[$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977811819394*^9},
 CellLabel->"Out[143]=",
 CellID->924999723,ExpressionUUID->"2b055c64-9192-4499-a02b-d53c578b909a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.494607447216296*^9, 3.4946074492725477`*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"f5b63544-f31a-4d9e-9dd2-9df447de8ecf"],

Cell[BoxData[
 RowBox[{"InterpretationBox", "[", 
  RowBox[{
   RowBox[{"StyleBox", "[", 
    RowBox[{
     RowBox[{"SubsuperscriptBox", "[", 
      RowBox[{"\<\"\[ScriptCapitalF]\"\>", ",", "\<\" \"\>", 
       ",", "\<\"a\"\>"}], "]"}], ",", 
     RowBox[{"AutoSpacing", "\[Rule]", "False"}], ",", 
     RowBox[{"ShowAutoStyles", "\[Rule]", "False"}]}], "]"}], ",", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[ScriptCapitalF]", " ", "a"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Force[$CellContext`a],
    Editable->False], ",", 
   RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]], "Output",
 CellChangeTimes->{3.7289778119795628`*^9},
 CellLabel->"Out[144]=",
 CellID->836223828,ExpressionUUID->"6bcf6bcd-c4db-4dcb-8fee-bb29a0a7dd4a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TensorBoxes", "=", "\"\<GridBox\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.494607453298777*^9, 3.4946074658144817`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"0d58476b-aa43-4d92-a113-7f9bffbce3ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We can cut-and-paste the output, but not edit it, nor construct a tensor \
directly in box-form (do this manually; the \"help\" format of this notebook \
does not allow cut and paste through different sessions):\
\>", "MathCaption",ExpressionUUID->"8fa345cd-27c2-48f9-82e7-c7044c3487d4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["\[ScriptCapitalF]", " ", "a"],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Force[$CellContext`a],
  Editable->False]], "Input",
 CellLabel->
  "In[146]:=",ExpressionUUID->"49841c43-6c3c-4ed6-a911-1f859d13a4cb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[ScriptCapitalF]", 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Force[$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289778123386993`*^9},
 CellLabel->"Out[146]=",
 CellID->1280891228,ExpressionUUID->"ff67b1e0-c66c-4bb9-bfe8-0e6ad18750a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[147]:=",ExpressionUUID->"cfccd1c6-a210-40b1-a1f2-e191d5504a3c"],

Cell["Force[a]", "Output",
 CellChangeTimes->{3.728977812655814*^9},
 CellLabel->"Out[147]//InputForm=",
 CellID->1562791468,ExpressionUUID->"1d42a209-0066-4317-8506-ac987e7738c2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clean up:", "MathCaption",ExpressionUUID->"4820e426-b458-4fec-a2cb-fefb100c0a0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "Force", "]"}]], "Input",
 CellLabel->
  "In[148]:=",ExpressionUUID->"268521b9-9c50-43e9-a5a4-953628137e2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Force"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Force],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977812786703*^9},
 CellLabel->"During evaluation of In[148]:=",
 CellID->2111199866,ExpressionUUID->"e0b88a5b-6ddf-4927-a354-4a04b4b52a3a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "TT", "]"}]], "Input",
 CellLabel->
  "In[149]:=",ExpressionUUID->"6ab9ba5c-51fb-45df-8ac5-ad6366316025"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "TT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`TT],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977812894014*^9},
 CellLabel->"During evaluation of In[149]:=",
 CellID->63848481,ExpressionUUID->"1f52acbc-edfe-4289-aa1c-14500633e66d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"FirstCharacter", ",", "symbol"}], "]"}]], "Input",
 CellLabel->
  "In[150]:=",ExpressionUUID->"f371e37b-52dc-43a6-9e13-b1aed7548114"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. Expressions and validation", "Subsection",ExpressionUUID->"017626f1-d144-499d-99e2-9e9a8cf6e2f6"],

Cell[TextData[{
 "Once we use abstract indices, there is no need to have a special \
TensorTimes. The usual ",
 StyleBox["Times",
  FontFamily->"Courier"],
 " product is enough and has one important advantage: we can use many \
built-in rules in ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "to simplify ",
 StyleBox["Times",
  FontFamily->"Courier"],
 " expressions. As usual, contractions are given using Einstein rule of \
staggered up/down repeated indices."
}], "Text",ExpressionUUID->"e1a6ff6a-6972-41d5-b2c0-8f6244714a7e"],

Cell[CellGroupData[{

Cell[TextData[{
 "The order of factors is irrelevant in ",
 StyleBox["Times",
  FontFamily->"Courier"],
 " expressions:"
}], "MathCaption",ExpressionUUID->"f070f89e-4c73-4430-a12f-a750214df2b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"-", "a"}], "]"}], 
  RowBox[{"T", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Input",
 CellLabel->
  "In[151]:=",ExpressionUUID->"fa8c85c3-cc64-4834-b23f-9cd7f4af216e"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[$CellContext`a, $CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977820557081*^9},
 CellLabel->"Out[151]=",
 CellID->123842069,ExpressionUUID->"f4c9549e-60ca-4461-95c0-1e2d16be9f11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"-", "a"}], "]"}], 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b"}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"-", "a"}], "]"}]}]}]], "Input",
 CellLabel->
  "In[152]:=",ExpressionUUID->"a02e5133-37f8-4ce1-b18a-7f9d4b09d9c9"],

Cell[BoxData[
 RowBox[{"2", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[$CellContext`a, $CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" "},
          {"a"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289778207075033`*^9},
 CellLabel->"Out[152]=",
 CellID->501999740,ExpressionUUID->"fd0ce06f-9dd5-4d6d-bba0-773ca51b9900"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The syntax of any expression can be checked using the function ",
 StyleBox["Validate",
  FontFamily->"Courier"],
 ". This function works recursively from the most external structures to the \
most internal ones, calling private functions ",
 StyleBox["ValidateTensor",
  FontFamily->"Courier"],
 ", ",
 StyleBox["ValidateCovD",
  FontFamily->"Courier"],
 ", etc. That gives you an idea of which problems will be detected first."
}], "Text",ExpressionUUID->"cc580805-3a9b-48f6-9f1c-49130c8d2f70"],

Cell[TextData[{
 StyleBox[ButtonBox["Validate",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Validate.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Validate an input expression", "Text"]
}], "DefinitionBox",ExpressionUUID->"40129e61-34b7-4eed-b175-dd7b2996c8ae"],

Cell["Functions that deal with validation.", "Text",ExpressionUUID->"b47508f7-78da-4e01-84bd-9fee7e825728"],

Cell[CellGroupData[{

Cell["If we get no errors, the input is syntactically correct:", "MathCaption",ExpressionUUID->"befda43b-6f4b-4822-9008-0849e2738b6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"a", ",", "b", ",", 
      RowBox[{"-", "c"}]}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{"c", ",", "d"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "d"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "]"}], "^", "3"}], 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->
  "In[153]:=",ExpressionUUID->"4956aadf-f9da-4fcb-b9c7-5b0b99bf9fa2"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor v\\\\\
\\\"\\\"}]\\)\"", 2, 153, 11, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977820848768*^9},
 CellLabel->"During evaluation of In[153]:=",
 CellID->1793864764,ExpressionUUID->"2be0e124-2f12-49a2-8156-7d6047845521"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox["r",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`r[],
     Editable->False], "3"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[$CellContext`a, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["ERROR",
       FontColor->Hue[0.]], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {"d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[-$CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`ERROR[
     $CellContext`v[-$CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {"c", "d"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[$CellContext`c, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {"a", "b", " "},
           {" ", " ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[$CellContext`a, $CellContext`b, -$CellContext`c],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.7289778209255743`*^9},
 CellLabel->"Out[153]=",
 CellID->962168315,ExpressionUUID->"d5bcfe7d-3aab-4be6-b30c-a1a6fbba3e61"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", "d"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "d"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "]"}], "^", "3"}], 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->
  "In[154]:=",ExpressionUUID->"01322a7f-0a83-41ff-ac7f-5d6c21a6ddb8"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor T\\\\\
\\\"\\\"}]\\)\"", 2, 154, 12, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977821147854*^9},
 CellLabel->"During evaluation of In[154]:=",
 CellID->611008295,ExpressionUUID->"d0656a01-a745-4c40-8c04-cbfad3c5af75"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor S\\\\\
\\\"\\\"}]\\)\"", 2, 154, 13, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.72897782126476*^9},
 CellLabel->"During evaluation of In[154]:=",
 CellID->2097097758,ExpressionUUID->"ba717ef6-1131-4b02-acfa-9386fe6852b7"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor v\\\\\
\\\"\\\"}]\\)\"", 2, 154, 14, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977821317252*^9},
 CellLabel->"During evaluation of In[154]:=",
 CellID->1420404142,ExpressionUUID->"bbf1aa9a-b438-4ec3-9410-c70092f3ba68"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Validate\\\", \
\\\"::\\\", \\\"error\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 154, 15, 19253573948027831207, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7289778213421164`*^9},
 CellLabel->"During evaluation of In[154]:=",
 CellID->1304194542,ExpressionUUID->"c411dd95-1b9e-4b8b-8991-0897856f2c60"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["ERROR",
       FontColor->Hue[0.]], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"S", 
           StyleBox[GridBox[{
              {" ", "d"},
              {"c", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[-$CellContext`c, $CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`ERROR[
     $CellContext`S[-$CellContext`c, $CellContext`d]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["ERROR",
       FontColor->Hue[0.]], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {"a", "b", "c"},
              {" ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[$CellContext`a, $CellContext`b, $CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`ERROR[
     $CellContext`T[$CellContext`a, $CellContext`b, $CellContext`c]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox["ERROR",
       FontColor->Hue[0.]], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {"d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[-$CellContext`d],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`ERROR[
     $CellContext`v[-$CellContext`d]],
    Editable->False]}], "+", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox["r",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`r[],
     Editable->False], "3"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[$CellContext`a, $CellContext`b],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728977821547344*^9},
 CellLabel->"Out[154]=",
 CellID->232082465,ExpressionUUID->"9118eedc-3111-4f41-b860-c22a1798fa23"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Some errors cannot be always localized in a single object. We do not return \
the expression:\
\>", "MathCaption",ExpressionUUID->"536827e2-c1d8-4869-8491-d688c27cabf4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "c"}]}], "]"}], 
   RowBox[{"v", "[", 
    RowBox[{"-", "c"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[155]:=",ExpressionUUID->"3af3fe6f-bd80-450b-b313-a5e88fe9b355"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "repeated", 
   "\"Found indices with the same name \
\\!\\(\\*RowBox[{\\\"\\\\\\\"-c\\\\\\\"\\\"}]\\).\"", 2, 155, 16, 
   19253573948027831207, "Local", "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.7289778217031927`*^9},
 CellLabel->"During evaluation of In[155]:=",
 CellID->779686303,ExpressionUUID->"077c2b58-223e-4f52-8d28-ec7954fee910"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], "+", 
   RowBox[{"v", "[", 
    RowBox[{"-", "a"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[156]:=",ExpressionUUID->"3449fe64-203f-44fa-a558-cb77be406c9c"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "inhom", 
   "\"Found inhomogeneous \
\\!\\(\\*RowBox[{\\\"\\\\\\\"indices\\\\\\\"\\\"}]\\): \
\\!\\(\\*RowBox[{\\\"\\\\\\\"{IndexList[-a], \
IndexList[a]}\\\\\\\"\\\"}]\\).\"", 2, 156, 17, 19253573948027831207, "Local",
    "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977822039587*^9},
 CellLabel->"During evaluation of In[156]:=",
 CellID->242480527,ExpressionUUID->"1f63d481-27fd-4ed1-a644-1ba8f8164e21"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Because validation takes up some time, it is not automatic. ",
 StyleBox["xTensor`", "DisplayMath"],
 " has the command ",
 StyleBox["Validate",
  FontFamily->"Courier"],
 " to be used by the user as required. However, if validation is needed in \
all computations it is possible to switch on automatic validation, by acting \
on the ",
 StyleBox["$Pre",
  FontFamily->"Courier"],
 " variable:"
}], "Text",ExpressionUUID->"5e6710a7-dc09-44b1-8fa2-06705999d232"],

Cell[CellGroupData[{

Cell["Here, there is not automatic validation:", "MathCaption",ExpressionUUID->"305da4d5-e080-41b0-8e15-3d2100d9a205"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"a", ",", "b"}], "]"}], 
  RowBox[{"v", "[", "b", "]"}]}]], "Input",
 CellLabel->
  "In[157]:=",ExpressionUUID->"42e5d121-21ae-4256-b11c-fe044e3262b7"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[$CellContext`a, $CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.72897782233939*^9},
 CellLabel->"Out[157]=",
 CellID->1593738930,ExpressionUUID->"1f832a38-7fd8-4c23-992f-44282a76e042"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[158]:=",ExpressionUUID->"acb84b21-d6d6-45ec-96ef-f30ebc1c8529"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "repeated", 
   "\"Found indices with the same name \\!\\(\\*RowBox[{\\\"\\\\\\\"b\\\\\\\"\
\\\"}]\\).\"", 2, 158, 18, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.72897782248877*^9},
 CellLabel->"During evaluation of In[158]:=",
 CellID->406667479,ExpressionUUID->"22466f4f-fd2c-425d-aaec-702be3ba7b60"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["This switches on automatic validation:", "MathCaption",ExpressionUUID->"ca259f97-b295-45a4-996b-160232aef5aa"],

Cell[CellGroupData[{

Cell[BoxData["$Pre"], "Input",
 CellLabel->
  "In[159]:=",ExpressionUUID->"34a653ac-1b3f-449a-8729-badfd84b360b"],

Cell[BoxData["$Pre"], "Output",
 CellChangeTimes->{3.728977822621489*^9},
 CellLabel->"Out[159]=",
 CellID->1567354799,ExpressionUUID->"158d8a28-b8ee-4cad-aa8d-86c0729509a0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Pre", "=", "Validate"}], ";"}]], "Input",
 CellLabel->
  "In[160]:=",ExpressionUUID->"844c637f-5953-432c-b8bf-3f04eeb8154b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"a", ",", "b"}], "]"}], 
  RowBox[{"v", "[", "b", "]"}]}]], "Input",
 CellLabel->
  "In[161]:=",ExpressionUUID->"6636582f-d60b-4b13-a9e6-0fc4c5341dae"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "repeated", 
   "\"Found indices with the same name \\!\\(\\*RowBox[{\\\"\\\\\\\"b\\\\\\\"\
\\\"}]\\).\"", 2, 161, 19, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977822928875*^9},
 CellLabel->"During evaluation of In[161]:=",
 CellID->1497692691,ExpressionUUID->"2388bc2d-ab73-442a-a79d-862836bed025"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["This switches off automatic validation:", "MathCaption",ExpressionUUID->"3aebedc9-4ca5-4337-b640-2bab07ef3774"],

Cell[BoxData[
 RowBox[{"$Pre", "=."}]], "Input",
 CellLabel->
  "In[162]:=",ExpressionUUID->"26ec62f1-c428-4513-8ce6-5b8470b1ff54"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"a", ",", "b"}], "]"}], 
  RowBox[{"v", "[", "b", "]"}]}]], "Input",
 CellLabel->
  "In[163]:=",ExpressionUUID->"1156007c-1e8b-4b2b-ac7d-b53b586c1164"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[$CellContext`a, $CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977823492058*^9},
 CellLabel->"Out[163]=",
 CellID->1065231150,ExpressionUUID->"c14e54cf-6bd0-4ec8-b99b-b29eb18daa5a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Note the ",
 StyleBox["HoldFirst",
  FontFamily->"Courier"],
 "  attribute of ",
 StyleBox["Validate",
  FontFamily->"Courier"],
 ", to make sure that we validate the input expression, and not whatever it \
evaluates to. That means that ",
 StyleBox["Evaluate",
  FontFamily->"Courier"],
 " must be used when the expression is not explicit:"
}], "MathCaption",
 CellChangeTimes->{{3.494607640047133*^9, 3.494607707850284*^9}, {
  3.4946079169214354`*^9, 
  3.4946080112297497`*^9}},ExpressionUUID->"b6c5c2b8-a08e-4a7f-bae0-\
f2098ca48b36"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Validate", "]"}]], "Input",
 CellChangeTimes->{{3.494607625005177*^9, 3.494607629182807*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"3b7f4ae2-cd4a-4d7b-a804-b6f8929f371e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldFirst", ",", "Protected"}], "}"}]], "Output",
 CellChangeTimes->{3.7289778236211357`*^9},
 CellLabel->"Out[164]=",
 CellID->1916256658,ExpressionUUID->"f191540b-7955-46b8-a972-70276d7e7d9e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"v", "[", "b", "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.494607881583022*^9, 3.4946078879440603`*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"fe93f975-ccb6-4219-88ca-fdfe1dcd00e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", "expr", "]"}]], "Input",
 CellChangeTimes->{{3.4946078898602533`*^9, 3.4946078918098183`*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"4174f44f-7bfd-426a-b259-e9f1853fee8f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[$CellContext`a, $CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289778239259357`*^9},
 CellLabel->"Out[166]=",
 CellID->713396947,ExpressionUUID->"3afbc5ff-cbb4-4716-a67d-58a02e723225"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", 
  RowBox[{"Evaluate", "[", "expr", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4946078938599787`*^9, 3.494607898075199*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"c83ef039-57cb-4f2f-a087-d860f334c746"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "repeated", 
   "\"Found indices with the same name \\!\\(\\*RowBox[{\\\"\\\\\\\"b\\\\\\\"\
\\\"}]\\).\"", 2, 167, 20, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977824040086*^9},
 CellLabel->"During evaluation of In[167]:=",
 CellID->661287028,ExpressionUUID->"fc08460c-4b2d-4862-97ec-117ad058d10b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "expr", "]"}]], "Input",
 CellLabel->
  "In[168]:=",ExpressionUUID->"10db3ef5-88a4-4dc2-b2ac-3b432b42e8a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "S", "]"}]], "Input",
 CellLabel->
  "In[169]:=",ExpressionUUID->"0c53c218-9311-4fad-83b2-f6041a1654da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`S],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977824254533*^9},
 CellLabel->"During evaluation of In[169]:=",
 CellID->1023206371,ExpressionUUID->"1b056f06-41f5-46d8-b32b-4a3434ab21be"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4. Symmetries", "Subsection",ExpressionUUID->"39425ff7-2e00-4f6f-9dc3-2e26809f04cc"],

Cell[TextData[{
 "There are two kinds of symmetries for a tensor. We can have monoterm (or \
permutation) symmetries, such that a tensor remains equal or changes sign \
under a permutation of its indices. Or we can have multiterm (for example \
cyclic) symmetries, such that a linear combination of several of those \
permuted tensors is equal to zero. In the former case the symmetry of a \
tensor of n indices can be described as a subgroup of the group {1,-1}x S_n. \
In the latter, the symmetry can be described as an algebra. Currently ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " can deal with an arbitrary case (n not too large: say 200 indices at most) \
of monoterm symmetries. However, it does not implement any general algorithm \
for multiterm symmetries, because no efficient algorithm is known for that \
case.\nThe twin package ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " is used to work with permutations. See ",
 StyleBox["xPermDoc.nb",
  FontFamily->"Courier"],
 " for further information."
}], "Text",ExpressionUUID->"16786579-b120-4641-8f02-b8857c0e200d"],

Cell[TextData[{
 StyleBox["GenSet\t\t\t\t\t", "DisplayMath"],
 StyleBox["Generating set of a permutations group", "Text"],
 StyleBox["\nStrongGenSet\t\t\t", "DisplayMath"],
 StyleBox["Strong generating set of a permutations group", "Text"],
 StyleBox["\nSymmetric\t\t\t\t", "DisplayMath"],
 StyleBox["Completely symmetric permutation group", "Text"],
 StyleBox["\nAntisymmetric\t\t\t", "DisplayMath"],
 StyleBox["Completely antisymmetric permutation group\n", "Text"],
 StyleBox["RiemannSymmetric\t\t", "DisplayMath"],
 StyleBox["Group of symmetry of the Riemann tensor\t", "Text"],
 StyleBox["\n", "DisplayMath"],
 StyleBox[ButtonBox["SymmetryOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymmetryOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Symmetry properties of an expression.\n", "Text"],
 StyleBox[ButtonBox["ForceSymmetries",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ForceSymmetries.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["Option of ", "Text"],
 StyleBox["DefTensor", "Text",
  FontFamily->"Courier"],
 StyleBox[" to allow for symmetries among up/down indices", "Text"]
}], "DefinitionBox",ExpressionUUID->"453cb721-f0a1-4ea4-8d34-26a216b7be59"],

Cell["Functions related to symmetries", "Text",ExpressionUUID->"819c8d03-ab78-40e2-b22b-81a1753ffb63"],

Cell[CellGroupData[{

Cell[TextData[{
 "Any permutation group on a set of n points can be given using a set of \
generators (head ",
 StyleBox["GenSet",
  FontFamily->"Courier"],
 ") or, better, a strong set of generators (head ",
 StyleBox["StrongGenSet",
  FontFamily->"Courier"],
 "). The functions ",
 StyleBox["Symmetric",
  FontFamily->"Courier"],
 " and ",
 StyleBox["Antisymmetric",
  FontFamily->"Courier"],
 " are example: ",
 StyleBox["From version 1.0.5, following ",
  FontColor->GrayLevel[0]],
 StyleBox["Mathematica",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" 9, the expressions ",
  FontColor->GrayLevel[0]],
 StyleBox["Symmetric[inds]",
  FontFamily->"Courier"],
 StyleBox[" and ",
  FontColor->GrayLevel[0]],
 StyleBox["Antisymmetric[inds]",
  FontFamily->"Courier"],
 StyleBox[" are inert. The use of a second argument is needed to produce \
actually a strong generating set. The second argument will be in red, but \
that is a harmless issue.",
  FontColor->GrayLevel[0]]
}], "MathCaption",ExpressionUUID->"d2ff414e-6268-45ff-b8e5-d7a6a227c370"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "Cycles"}], "]"}]], "Input",
 CellLabel->
  "In[170]:=",ExpressionUUID->"3b28144c-f079-463e-bef9-d1d71dd7d723"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    InterpretationBox[
     StyleBox[
      RowBox[{"(", "a", ",", "b", ")"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xPerm`Cycles[{$CellContext`a, $CellContext`b}],
     Editable->False], "]"}]}], "]"}]], "Output",
 CellChangeTimes->{3.728977831810829*^9},
 CellLabel->"Out[170]=",
 CellID->1356062270,ExpressionUUID->"86b51675-63c7-4700-af43-c76ddbe9662d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Antisymmetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "Cycles"}], "]"}]], "Input",
 CellLabel->
  "In[171]:=",ExpressionUUID->"b110fb19-8a02-41c4-a9df-484a1974f4ac"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"GenSet", "[", 
    InterpretationBox[
     StyleBox[
      RowBox[{"-", 
       RowBox[{"(", "a", ",", "b", ")"}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     -xAct`xPerm`Cycles[{$CellContext`a, $CellContext`b}],
     Editable->False], "]"}]}], "]"}]], "Output",
 CellChangeTimes->{3.7289778319301023`*^9},
 CellLabel->"Out[171]=",
 CellID->94626279,ExpressionUUID->"0b170118-49a9-4dfe-b528-c58eb4102ee2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a symmetric tensor ",
 StyleBox["S",
  FontFamily->"Courier"],
 " on ",
 StyleBox["M3",
  FontFamily->"Courier"]
}], "MathCaption",ExpressionUUID->"283dc12e-c20d-4c3a-9071-0e8b7bd7488e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", " ", "M3", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[172]:=",ExpressionUUID->"2f768cee-963c-41c4-a51e-395c139dda24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[$CellContext`a, $CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977832062229*^9},
 CellLabel->"During evaluation of In[172]:=",
 CellID->1245972373,ExpressionUUID->"169e4780-3f91-4f30-ba4d-3ad8d73c477e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "S"}]], "Input",
 CellLabel->
  "In[173]:=",ExpressionUUID->"8dd2f949-19f4-451c-96f5-37969fe1aa56"],

Cell[CellGroupData[{

Cell["Global`S", "Print", "PrintUsage",
 CellChangeTimes->{3.7289778321776447`*^9},
 CellTags->"Info1733728981432-9181623",
 CellID->944631114,ExpressionUUID->"ab3ee4a8-7bf1-41bf-a3b2-652eaf0137c9"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "S", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`S],
          Editable->False], "^=", "S"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "S", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "S", "]"}], "^=", 
         RowBox[{"{", "M3", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "S", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"M3", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "S", "]"}], "^=", "\<\"S\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "S", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "S", "]"}], "^=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], ",", 
           RowBox[{"GenSet", "[", 
            InterpretationBox[
             StyleBox[
              RowBox[{"(", "1", ",", "2", ")"}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xPerm`Cycles[{1, 2}],
             Editable->False], "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "S", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "S", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`S],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977832202317*^9},
 CellTags->"Info1733728981432-9181623",
 CellID->68530727,ExpressionUUID->"579ee2dc-80f0-49f8-9e65-24f5efae300c"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a totally antisymmetric tensor ",
 StyleBox["U",
  FontFamily->"Courier"],
 " on ",
 StyleBox["M3",
  FontFamily->"Courier"],
 ". We can use the names of the indices or their positions in the tensor"
}], "MathCaption",ExpressionUUID->"1617e0b4-1388-459a-be01-55a7eed330b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", " ", "M3", ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[174]:=",ExpressionUUID->"1ef15a81-375b-4a70-be6c-b3b4374cc5da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[-$CellContext`a, -$CellContext`b, -$CellContext`c], ". ", 
   ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778324726*^9},
 CellLabel->"During evaluation of In[174]:=",
 CellID->744693897,ExpressionUUID->"27d19452-2983-48a0-9792-a6c3c013858f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "U"}]], "Input",
 CellLabel->
  "In[175]:=",ExpressionUUID->"1a077c8d-5660-4c49-ad01-4030aa0bf0b8"],

Cell[CellGroupData[{

Cell["Global`U", "Print", "PrintUsage",
 CellChangeTimes->{3.728977832911667*^9},
 CellTags->"Info1753728981432-9181623",
 CellID->535632163,ExpressionUUID->"a67b04c3-c3c7-4ac1-8a2a-674cc955be23"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "U", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`U],
          Editable->False], "^=", "U"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "U", "]"}], "^=", 
         RowBox[{"{", "M3", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"M3", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "U", "]"}], "^=", "\<\"U\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "U", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]M3",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentM3,
             Editable->False]}], ",", 
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]M3",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentM3,
             Editable->False]}], ",", 
           RowBox[{"-", 
            InterpretationBox[
             StyleBox["\[DoubleStruckCapitalT]M3",
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`TangentM3,
             Editable->False]}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "U", "]"}], "^=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
           RowBox[{"GenSet", "[", 
            RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{"-", 
                RowBox[{"(", "1", ",", "2", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              -xAct`xPerm`Cycles[{1, 2}],
              Editable->False], ",", 
             InterpretationBox[
              StyleBox[
               RowBox[{"-", 
                RowBox[{"(", "2", ",", "3", ")"}]}],
               ShowAutoStyles->False,
               AutoSpacing->False],
              -xAct`xPerm`Cycles[{2, 3}],
              Editable->False]}], "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "U", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "U", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`U],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778329350767`*^9},
 CellTags->"Info1753728981432-9181623",
 CellID->118315317,ExpressionUUID->"78dd0d02-24ec-4d49-9b35-f8d81c30bc4b"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "For example, for the tensor ",
 StyleBox["U",
  FontFamily->"Courier"],
 " the group is generated by the two signed permutations -",
 StyleBox["Cycles",
  FontFamily->"Courier"],
 "[{1,2}] (representing a change of sign under the exchange of slots 1 and 2) \
and -",
 StyleBox["Cycles",
  FontFamily->"Courier"],
 "[{2,3}] (representing a change of sign under the exchange of slots 2 and \
3). Again, ",
 StyleBox["Cycles",
  FontFamily->"Courier"],
 " is colored in red because there is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbol with the same name. "
}], "Text",ExpressionUUID->"a6abed5b-67e9-4968-b506-10e9f89ff031"],

Cell["Note however that not every generating set is valid:", "Text",ExpressionUUID->"e415ec05-ead8-47aa-9cf4-ce605f0a1841"],

Cell[CellGroupData[{

Cell["\<\
For example, in a group of three indices, antisymmetry in the first two \
indices is not consistent with symmetry in the second and third indices, \
unless the whole tensor is zero:\
\>", "MathCaption",ExpressionUUID->"b2a6ac3f-ae13-4448-adea-85f6ca073e36"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"W", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "M3", ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[176]:=",ExpressionUUID->"0c245624-a1f5-404a-889e-0815cb126fd1"],

Cell[BoxData[
 TemplateBox[{
  "DefTensor", "zero", 
   "\"Symmetry makes tensor zero. Use VanishingQ instead.\"", 2, 176, 21, 
   19253573948027831207, "Local", "xAct`xTensor`DefTensor"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977833166712*^9},
 CellLabel->"During evaluation of In[176]:=",
 CellID->2103159344,ExpressionUUID->"93b808d8-1d22-4f0b-a682-11b237aa5ea7"]
}, Open  ]]
}, Open  ]],

Cell["\<\
The symmetries must be consistent with the character of the indices \
(irrespectively of whether there is a metric or not). This is checked.\
\>", "Text",ExpressionUUID->"f6d502ca-da3b-422b-9dd4-34a538cb82a2"],

Cell[CellGroupData[{

Cell["\<\
We cannot define a symmetric tensor with two indices of different character:\
\>", "MathCaption",ExpressionUUID->"69bcd9ca-2ef7-44df-b030-faa030a529ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"Q", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[177]:=",ExpressionUUID->"193fa296-2a2f-4655-87ec-91cfd5a8c8a8"],

Cell[BoxData[
 TemplateBox[{
  "DefTensor", "wrongsym", 
   "\"Symmetry properties are inconsistent with indices of tensor.\"", 2, 177,
    22, 19253573948027831207, "Local", "xAct`xTensor`DefTensor"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.7289778334498796`*^9},
 CellLabel->"During evaluation of In[177]:=",
 CellID->218264988,ExpressionUUID->"2a3d9b51-3e5e-4126-9965-ef065f2714d1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["unless we force it (so that the check is not performed):", "MathCaption",ExpressionUUID->"e5709dcc-1cf8-4aa9-8d43-01c6fc204c2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"Q", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"ForceSymmetries", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[178]:=",ExpressionUUID->"f805382a-8507-41e8-9736-3487e5adf1f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Q", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Q[$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977833694573*^9},
 CellLabel->"During evaluation of In[178]:=",
 CellID->477584240,ExpressionUUID->"8bfeaef2-2de7-4fd6-a814-87005107fcc7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
For symmetry groups of order larger than 10000 the check would take too long \
and is not performed:\
\>", "MathCaption",ExpressionUUID->"ef20c19f-bdf0-4443-84dc-bd477feedc20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"supereta", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", 
     RowBox[{"-", "f"}], ",", 
     RowBox[{"-", "g"}], ",", 
     RowBox[{"-", "h"}], ",", 
     RowBox[{"-", "h1"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"Range", "[", "8", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[179]:=",ExpressionUUID->"578b54ef-1fa1-436f-af19-ac42c58fb1b8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Order of group of symmetry: \"\>", "\[InvisibleSpace]", 
   "40320", "\[InvisibleSpace]", "\<\" > 10000. ForceSymmetry check not \
performed.\"\>"}],
  SequenceForm[
  "  Order of group of symmetry: ", 40320, 
   " > 10000. ForceSymmetry check not performed."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778339522038`*^9},
 CellLabel->"During evaluation of In[179]:=",
 CellID->1611932841,ExpressionUUID->"779ed934-9078-4257-abea-a144b075fd31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"supereta", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", 
     RowBox[{"-", "f"}], ",", 
     RowBox[{"-", "g"}], ",", 
     RowBox[{"-", "h"}], ",", 
     RowBox[{"-", "h1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`supereta[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d, $CellContext`e, -$CellContext`f, -$CellContext`g, \
-$CellContext`h, -$CellContext`h1], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977833970067*^9},
 CellLabel->"During evaluation of In[179]:=",
 CellID->1249051782,ExpressionUUID->"acae08af-1839-4f77-8dc7-978450fb1098"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefTensor", "/@", 
   RowBox[{"{", 
    RowBox[{"Q", ",", "supereta", ",", "U"}], "}"}]}], ";"}]], "Input",
 CellLabel->
  "In[180]:=",ExpressionUUID->"545b076d-d3be-4b68-8acb-4c0166b5fd8a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Q"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Q],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897783411943*^9},
 CellLabel->"During evaluation of In[180]:=",
 CellID->1160650649,ExpressionUUID->"5e14588e-2f8d-49ef-bd33-b9b801e998c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "supereta"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`supereta],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778341372747`*^9},
 CellLabel->"During evaluation of In[180]:=",
 CellID->1461492042,ExpressionUUID->"54908e96-ff70-48c2-b1d9-ee06bf3ac8bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "U"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`U],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977834156289*^9},
 CellLabel->"During evaluation of In[180]:=",
 CellID->378795508,ExpressionUUID->"8cd86757-6047-4c48-bbb8-fa507b9c5aa0"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "W", "]"}]], "Input",
 CellLabel->
  "In[181]:=",ExpressionUUID->"426b0a8c-5cea-49d7-b87d-6103d81733c3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "3.5. delta, Gdelta and Sdelta. ",
 StyleBox["V1.1.0 UPDATE",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsection",ExpressionUUID->"8149cdd7-01de-4e5a-a962-368625084a4c"],

Cell[TextData[{
 "The identity tensor on vbundles is called ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " and is the same for all vbundles. This has changed from old versions of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", in which each vbundle had its own identity tensor.\nThe ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " is a very special object. For example Penrose & Rindler use a delta object \
with one index on top of the other, rather than staggered, not following the \
\"sorted slots\" convention. That means that indices of such an object cannot \
be moved up and down with a metric. Such a construction is not natural in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " and hence we must look for an alternative. Up to version 0.9.6 ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " was considered to be always a symmetric tensor, though this didn't make \
much sense in the absence of a metric, because an object with mixed indices \
cannot have symmetry. The problem becomes even worse in the presence of an \
antisymmetric metric (spinor and symplectic calculus), and hence this has now \
changed. The main requirement is that ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " is a tensor and has a preferred index configuration, which will be taken \
as ",
 StyleBox["delta[-a, b]",
  FontFamily->"Courier"],
 ", which is more natural in the usual conventions of spinor calculus. In the \
presence of a metric other configurations are possible, and actually ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " becomes equal to the metric. That means that in the presence of a \
symmetric metric ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " is symmetric, and in the presence of an antisymmetric metric ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " is antisymmetric."
}], "Text",ExpressionUUID->"e31ffbb3-2a58-491f-8c79-34c63a181061"],

Cell[TextData[{
 StyleBox[ButtonBox["delta",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "delta.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t\t", "DisplayMath"],
 StyleBox["Identity tensor on every vbundle", "Text"],
 StyleBox["\n", "DisplayMath"],
 StyleBox[ButtonBox["Gdelta",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Gdelta.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t\t", "DisplayMath"],
 StyleBox["Generalized ", "Text"],
 StyleBox["delta", "Text",
  FontFamily->"Courier"],
 StyleBox[" tensor on every vbundle\n", "Text"],
 StyleBox[ButtonBox["ExpandGdelta",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExpandGdelta.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Expansion of ", "Text"],
 StyleBox["Gdelta", "Text",
  FontFamily->"Courier"],
 StyleBox[" in products of ", "Text"],
 StyleBox["delta", "Text",
  FontFamily->"Courier"],
 StyleBox["'s", "Text"]
}], "DefinitionBox",
 CellChangeTimes->{
  3.728977840948724*^9},ExpressionUUID->"1f261d1d-2917-4ae1-b6ee-\
54bc6f595eb0"],

Cell["Identity tensors.", "Text",ExpressionUUID->"72ef4872-06ea-48da-b3b6-afb1ab2c255c"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " tensor on the the vector bundle ",
 StyleBox["TangentM3",
  FontFamily->"Courier"],
 ":"
}], "MathCaption",ExpressionUUID->"c45cc6ad-6baa-44ca-9d48-154461fc9297"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"delta", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", "b"}], "]"}]], "Input",
 CellLabel->
  "In[182]:=",ExpressionUUID->"366abbff-f545-4141-a509-5e0b85de9b47"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Delta]", 
      StyleBox[GridBox[{
         {" ", "b"},
         {"a", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`delta[-$CellContext`a, $CellContext`b],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977843895678*^9},
 CellLabel->"Out[182]=",
 CellID->732934548,ExpressionUUID->"cd4a9c43-f473-4fef-8b4a-4a4da31f78a6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The opposite configuration is forbidden without a metric:", \
"MathCaption",ExpressionUUID->"0d09ccd5-64ff-4b3f-9b4b-f3315184fe41"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"delta", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "b"}]}], "]"}], "//", "Validate"}]], "Input",
 CellLabel->
  "In[183]:=",ExpressionUUID->"7dc92267-4c32-4279-a993-0e54963e03a1"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor delta\
\\\\\\\"\\\"}]\\)\"", 2, 183, 23, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.7289778440457287`*^9},
 CellLabel->"During evaluation of In[183]:=",
 CellID->464749044,ExpressionUUID->"6a3b8160-081e-41d8-a69e-dfd42390d676"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["ERROR",
     FontColor->Hue[0.]], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {"a", " "},
            {" ", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[$CellContext`a, -$CellContext`b],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`ERROR[
   xAct`xTensor`delta[$CellContext`a, -$CellContext`b]],
  Editable->False]], "Output",
 CellChangeTimes->{3.72897784407661*^9},
 CellLabel->"Out[183]=",
 CellID->639158369,ExpressionUUID->"73175e5d-beaf-4346-8221-18586e9f4390"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "There is automatic simplification with most of the expected rules for the \
",
 StyleBox["delta",
  FontFamily->"Courier"],
 " tensors:"
}], "MathCaption",ExpressionUUID->"157e4412-5a39-43b4-a985-82ca3495540e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"delta", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", "a"}], "]"}]], "Input",
 CellLabel->
  "In[184]:=",ExpressionUUID->"755d651c-c673-41b5-8f5c-80a7583a391b"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.728977844196336*^9},
 CellLabel->"Out[184]=",
 CellID->621505489,ExpressionUUID->"bf619c5f-bb3f-4f3e-8adf-3aadc847ecf3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"delta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", "b"}], "]"}], 
  RowBox[{"delta", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", "c"}], "]"}]}]], "Input",
 CellLabel->
  "In[185]:=",ExpressionUUID->"6784a59f-6539-4a7b-bf2b-2d5c4c65213d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Delta]", 
      StyleBox[GridBox[{
         {" ", "c"},
         {"a", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`delta[-$CellContext`a, $CellContext`c],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289778443316708`*^9},
 CellLabel->"Out[185]=",
 CellID->282294615,ExpressionUUID->"3d056001-eccf-4097-b2d5-2bfd63fce57f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"delta", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", "a"}], "]"}], 
  RowBox[{"v", "[", 
   RowBox[{"-", "a"}], "]"}]}]], "Input",
 CellLabel->
  "In[186]:=",ExpressionUUID->"343a025f-5253-43dc-9409-35f5abf9ddb0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {" "},
         {"b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[-$CellContext`b],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977844442029*^9},
 CellLabel->"Out[186]=",
 CellID->734218082,ExpressionUUID->"67fedc8b-b7b8-438b-b291-02765d56a23f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "When both indices can be contracted, the second index of ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " is contracted first:"
}], "MathCaption",ExpressionUUID->"726a0338-d3d6-4ba2-810a-f4507b70c42a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"delta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", "b"}], "]"}], 
  RowBox[{"S", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "b"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[187]:=",ExpressionUUID->"a847ef3d-b428-44b6-8e14-9ffb14882973"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {"a", " "},
         {" ", "a"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[$CellContext`a, -$CellContext`a],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977844717101*^9},
 CellLabel->"Out[187]=",
 CellID->562268512,ExpressionUUID->"b307c2f2-4cd9-4554-aed8-73e61afd5207"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The indices of ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " can never have the same character, unless automatic conversion to a metric \
is possible:"
}], "MathCaption",ExpressionUUID->"5dc6d362-d4d8-4cc4-818a-4fe61da0798d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"delta", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "//", "Catch"}]], "Input",
 CellLabel->
  "In[188]:=",ExpressionUUID->"71ce46af-1159-4ac5-85eb-571ad624f945"],

Cell[BoxData[
 TemplateBox[{
  "MetricsOfVBundle", "missing", 
   "\"There is no \\!\\(\\*RowBox[{\\\"\\\\\\\"metric\\\\\\\"\\\"}]\\) in \\!\
\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M3\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM3, \
Rule[Editable, False]]\\).\"", 2, 188, 24, 19253573948027831207, "Local", 
   "xAct`xTensor`MetricsOfVBundle"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977845114039*^9},
 CellLabel->"During evaluation of In[188]:=",
 CellID->1118834384,ExpressionUUID->"8fe1e60f-c66f-4ea8-8c49-61ae816d53fa"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "In version 0.9.0 ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " added a generalized delta tensor, with two sets of antisymmetric slots. In \
version 1.1.0 its contraction properties have been improved. In particular we \
now try to avoid expanding generalized deltas into single deltas whenever \
possible."
}], "Text",ExpressionUUID->"a4ed2797-8ad1-4985-b7ea-46784be6a640"],

Cell[CellGroupData[{

Cell["\<\
This is the generalized tensor with 2 lower indices and 2 upper indices:\
\>", "MathCaption",ExpressionUUID->"98862426-6ea5-4f99-81ff-4a54255b1f23"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gdelta", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->
  "In[189]:=",ExpressionUUID->"1c3da9f7-cd50-46bd-b11f-9d4d8584573f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Delta]", 
      StyleBox[GridBox[{
         {" ", " ", "c", "d"},
         {"a", "b", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Gdelta[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`d],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977845378893*^9},
 CellLabel->"Out[189]=",
 CellID->882678756,ExpressionUUID->"d868bf2b-aff7-40e2-bbf1-9e3db75aadc8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
It is antisymmetric in the first group of indices and separately \
antisymmetric in the second group of indices. Note that there is no \
group-exchange symmetry because there is no metric on this vbundle yet.\
\>", "MathCaption",ExpressionUUID->"e15c1a03-1540-4b6b-b08d-72c240c353f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Gdelta", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "a"}], ",", "c", ",", "d"}], "]"}], ",", 
    RowBox[{"Gdelta", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "d", ",", "c"}], "]"}], ",", 
    RowBox[{"Gdelta", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "c"}], ",", "b", ",", "a"}], "]"}]}], "}"}], "//", 
  "ToCanonical"}]], "Input",
 CellLabel->
  "In[190]:=",ExpressionUUID->"e12c9aee-b83d-4156-a0ff-03a9cbff5b0d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", " ", "c", "d"},
            {"a", "b", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Gdelta[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`d],
     Editable->False]}], ",", 
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", " ", "c", "d"},
            {"a", "b", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Gdelta[-$CellContext`a, -$CellContext`b, $CellContext`c, \
$CellContext`d],
     Editable->False]}], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", " ", "a", "b"},
           {"c", "d", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`Gdelta[-$CellContext`c, -$CellContext`d, $CellContext`a, \
$CellContext`b],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.728977845523748*^9},
 CellLabel->"Out[190]=",
 CellID->364818616,ExpressionUUID->"f53f8d93-7578-4196-bcc5-0cf42b58e1f7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Staggered indices are automatically contracted (there is no need of a metric \
for this):\
\>", "MathCaption",ExpressionUUID->"72cbd1b8-6a92-4701-b5bc-d0c4cc2f4075"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gdelta", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", "a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->
  "In[191]:=",ExpressionUUID->"98ef51f8-6244-49af-a06a-656ae2311db1"],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{3.7289778456619368`*^9},
 CellLabel->"Out[191]=",
 CellID->440666927,ExpressionUUID->"210705cc-2b56-43d1-a859-0ac1785174df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gdelta", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", "d", ",", "e", ",", "c"}], "]"}]], "Input",
 CellLabel->
  "In[192]:=",ExpressionUUID->"9dd30a31-f8ea-4d1f-850b-861ccf17b282"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Delta]", 
      StyleBox[GridBox[{
         {" ", " ", "d", "e"},
         {"a", "b", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Gdelta[-$CellContext`a, -$CellContext`b, $CellContext`d, \
$CellContext`e],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977845907393*^9},
 CellLabel->"Out[192]=",
 CellID->1765427233,ExpressionUUID->"c554b6b6-5dfa-44e8-b4e7-10c6016bae22"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Contractions in the same group give zero. A metric is actually needed here, \
and Gdelta does not check its existence.\
\>", "MathCaption",ExpressionUUID->"3b3bc965-2ee0-495d-be14-a74b91891f73"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gdelta", "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", "a", ",", 
   RowBox[{"-", "c"}], ",", "d", ",", "e"}], "]"}]], "Input",
 CellLabel->
  "In[193]:=",ExpressionUUID->"0021ce72-5cab-4323-85fb-230a79a5d574"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.728977846045349*^9},
 CellLabel->"Out[193]=",
 CellID->1901438079,ExpressionUUID->"839bb3e3-92a8-4c0b-9bd2-5d144a5e3219"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
It is always possible to convert it into a determinant of normal delta \
tensors:\
\>", "MathCaption",ExpressionUUID->"0b0ba427-fb05-4c18-9116-1fdc8f0ef43e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandGdelta", "[", 
  RowBox[{"Gdelta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", "d", ",", "e"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[194]:=",ExpressionUUID->"7e41b45b-70d7-4105-94bd-5f73ee803904"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "e"},
            {"a", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`a, $CellContext`e],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "d"},
           {"b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`b, $CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "d"},
           {"a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`a, $CellContext`d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {" ", "e"},
           {"b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[-$CellContext`b, $CellContext`e],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{3.728977846499954*^9},
 CellLabel->"Out[194]=",
 CellID->765642746,ExpressionUUID->"ee0cc355-b587-47ed-be74-c069785507dc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conversion into delta is automatic:", "MathCaption",ExpressionUUID->"25d26999-d31f-4671-be2c-11c244552727"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gdelta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", "b"}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->
  "In[195]:=",ExpressionUUID->"3d9ab215-f7d9-4e34-9a2a-3c2af8cdc9bf"],

Cell["delta[-a, b]", "Output",
 CellChangeTimes->{3.728977846727206*^9},
 CellLabel->"Out[195]//InputForm=",
 CellID->435619198,ExpressionUUID->"e116bce3-18ed-4cb6-9378-2281b5458da8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We can contract two generalized deltas into another generalized delta:\
\>", "MathCaption",ExpressionUUID->"28251a08-e568-4e50-881a-657ad1f6af19"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gdelta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], 
  RowBox[{"Gdelta", "[", 
   RowBox[{
    RowBox[{"-", "c"}], ",", 
    RowBox[{"-", "d"}], ",", "e", ",", "f"}], "]"}]}]], "Input",
 CellLabel->
  "In[196]:=",ExpressionUUID->"09a691f4-571b-48ec-9bad-578ffb55b9b5"],

Cell[BoxData[
 RowBox[{"2", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Delta]", 
       StyleBox[GridBox[{
          {" ", " ", "e", "f"},
          {"a", "b", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Gdelta[-$CellContext`a, -$CellContext`b, $CellContext`e, \
$CellContext`f],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289778468670607`*^9},
 CellLabel->"Out[196]=",
 CellID->680108163,ExpressionUUID->"14fc77f9-3179-4615-b67c-5c8c28d7c5af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gdelta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", "d", ",", "e", ",", "f"}], "]"}], 
  RowBox[{"Gdelta", "[", 
   RowBox[{
    RowBox[{"-", "d"}], ",", 
    RowBox[{"-", "e"}], ",", 
    RowBox[{"-", "f"}], ",", "g", ",", "h", ",", "h1"}], "]"}]}]], "Input",
 CellLabel->
  "In[197]:=",ExpressionUUID->"16151d9c-97cf-49e7-bad8-bdc4a3b1176d"],

Cell[BoxData[
 RowBox[{"6", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Delta]", 
       StyleBox[GridBox[{
          {" ", " ", " ", "g", "h", "h1"},
          {"a", "b", "c", " ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Gdelta[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`g, $CellContext`h, $CellContext`h1],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977846981103*^9},
 CellLabel->"Out[197]=",
 CellID->1669926207,ExpressionUUID->"91962f4e-9b68-4ac4-831d-f1487261b83c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gdelta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", "d", ",", "e", ",", "f"}], "]"}], 
  RowBox[{"Gdelta", "[", 
   RowBox[{
    RowBox[{"-", "d"}], ",", 
    RowBox[{"-", "e"}], ",", 
    RowBox[{"-", "g"}], ",", "h", ",", "h1", ",", "h2"}], "]"}]}]], "Input",
 CellLabel->
  "In[198]:=",ExpressionUUID->"10c5c03d-e424-4675-823e-44b6aaca6fe9"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", " ", " ", "h", "h1", "h2"},
             {"a", "b", "g", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Gdelta[-$CellContext`a, -$CellContext`b, -$CellContext`g, \
$CellContext`h, $CellContext`h1, $CellContext`h2],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", " ", " ", "h", "h1", "h2"},
             {"a", "c", "g", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Gdelta[-$CellContext`a, -$CellContext`c, -$CellContext`g, \
$CellContext`h, $CellContext`h1, $CellContext`h2],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", " ", " ", "h", "h1", "h2"},
             {"b", "c", "g", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Gdelta[-$CellContext`b, -$CellContext`c, -$CellContext`g, \
$CellContext`h, $CellContext`h1, $CellContext`h2],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.7289778474838247`*^9},
 CellLabel->"Out[198]=",
 CellID->985978406,ExpressionUUID->"a7cda249-47e2-48fb-a5aa-7a0add85a3e9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Let us check this last result.", "MathCaption",ExpressionUUID->"5a9f661f-51fa-4b51-af0a-47294192773f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandGdelta", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[199]:=",ExpressionUUID->"e8e57c9a-eddb-49a3-90e6-c5b2161937b4"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`f],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h2],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h2],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h2],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h2],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
         Editable->False]}]}], ")"}]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h2],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h2],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h2],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h2],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
         Editable->False]}]}], ")"}]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`f],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h2],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h2],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h2],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h2],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h"},
                {"b", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h1"},
                {"c", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`c, $CellContext`h1],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "h2"},
                {"g", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
         Editable->False]}]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.728977848052606*^9},
 CellLabel->"Out[199]=",
 CellID->1355249390,ExpressionUUID->"a362d989-54ec-4920-aa0b-6ebcfadb8aef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", 
  RowBox[{
   RowBox[{"ExpandGdelta", "[", 
    RowBox[{"Gdelta", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", "d", ",", "e", ",", "f"}], "]"}], "]"}], 
   RowBox[{"ExpandGdelta", "[", 
    RowBox[{"Gdelta", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "g"}], ",", "h", ",", "h1", ",", "h2"}], "]"}], 
    "]"}]}]}]], "Input",
 CellLabel->
  "In[200]:=",ExpressionUUID->"d463af76-bfd5-436a-8d5a-7ebf8b92edc6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Delta]", 
             StyleBox[GridBox[{
                {" ", "f"},
                {"a", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTensor`delta[-$CellContext`a, $CellContext`f],
         Editable->False]}], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "e"},
               {"b", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`b, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "d"},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`c, $CellContext`d],
        Editable->False]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "e"},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`a, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "f"},
               {"b", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "d"},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`c, $CellContext`d],
        Editable->False]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "f"},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`a, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "d"},
               {"b", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`b, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "e"},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`c, $CellContext`e],
        Editable->False]}], "-", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "d"},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`a, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "f"},
               {"b", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "e"},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`c, $CellContext`e],
        Editable->False]}], "-", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "e"},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`a, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "d"},
               {"b", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`b, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "f"},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`c, $CellContext`f],
        Editable->False]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "d"},
               {"a", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`a, $CellContext`d],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "e"},
               {"b", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`b, $CellContext`e],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "f"},
               {"c", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`c, $CellContext`f],
        Editable->False]}]}], ")"}]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Delta]", 
            StyleBox[GridBox[{
               {" ", "h2"},
               {"d", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTensor`delta[-$CellContext`d, $CellContext`h2],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h1"},
              {"e", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`e, $CellContext`h1],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h"},
              {"g", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h1"},
              {"d", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`d, $CellContext`h1],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h2"},
              {"e", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`e, $CellContext`h2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h"},
              {"g", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h2"},
              {"d", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`d, $CellContext`h2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h"},
              {"e", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`e, $CellContext`h],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h1"},
              {"g", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h"},
              {"d", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`d, $CellContext`h],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h2"},
              {"e", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`e, $CellContext`h2],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h1"},
              {"g", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h1"},
              {"d", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`d, $CellContext`h1],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h"},
              {"e", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`e, $CellContext`h],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h2"},
              {"g", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h"},
              {"d", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`d, $CellContext`h],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h1"},
              {"e", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`e, $CellContext`h1],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "h2"},
              {"g", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "f"},
              {"c", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`c, $CellContext`f],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Delta]", 
               StyleBox[GridBox[{
                  {" ", "h2"},
                  {"a", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           xAct`xTensor`delta[-$CellContext`a, $CellContext`h2],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h2],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h2],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
          Editable->False]}], "-", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h2],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
          Editable->False]}], "-", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
          Editable->False]}]}], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "f"},
              {"b", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Delta]", 
               StyleBox[GridBox[{
                  {" ", "h2"},
                  {"a", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           xAct`xTensor`delta[-$CellContext`a, $CellContext`h2],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h2],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h2],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
          Editable->False]}], "-", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h2],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
          Editable->False]}], "-", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"a", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
          Editable->False]}]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "f"},
              {"a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`a, $CellContext`f],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Delta]", 
               StyleBox[GridBox[{
                  {" ", "h2"},
                  {"b", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           xAct`xTensor`delta[-$CellContext`b, $CellContext`h2],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h2],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h2],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
          Editable->False]}], "-", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h2],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h1],
          Editable->False]}], "-", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h"},
                 {"b", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h1"},
                 {"c", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`c, $CellContext`h1],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Delta]", 
              StyleBox[GridBox[{
                 {" ", "h2"},
                 {"g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`delta[-$CellContext`g, $CellContext`h2],
          Editable->False]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.728977848560082*^9},
 CellLabel->"Out[200]=",
 CellID->1464937648,ExpressionUUID->"cf1b929f-8cc6-4925-8133-f37dbd7acf27"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input",
 CellLabel->
  "In[201]:=",ExpressionUUID->"fa5ae39d-4fb6-4938-a829-4150b5c4ade0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.728977848900332*^9},
 CellLabel->"Out[201]=",
 CellID->307037081,ExpressionUUID->"29b782fa-86be-469d-bbef-006de51552bd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We can also contract generalized deltas with antisymmetric tensors, without \
expanding into standard deltas:\
\>", "MathCaption",ExpressionUUID->"e2e35eb6-332c-4f4e-8d88-9eb3057813e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "M3", ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[202]:=",ExpressionUUID->"76ecc4d4-f804-4230-9c93-e82e2a1c80c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[$CellContext`a, $CellContext`b, $CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897784906539*^9},
 CellLabel->"During evaluation of In[202]:=",
 CellID->2116500273,ExpressionUUID->"43303e10-cfc4-41c9-bb86-f92a0c2797fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"U", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
  RowBox[{"Gdelta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}], ",", 
    RowBox[{"-", "c"}], ",", "e", ",", "f", ",", "g"}], "]"}]}]], "Input",
 CellLabel->
  "In[203]:=",ExpressionUUID->"d1e0b314-4b3b-4963-b343-05780c425cd9"],

Cell[BoxData[
 RowBox[{"6", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {"e", "f", "g"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[$CellContext`e, $CellContext`f, $CellContext`g],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289778492329893`*^9},
 CellLabel->"Out[203]=",
 CellID->1100959403,ExpressionUUID->"6ff29cb9-2753-410d-9f64-3fdf16552c45"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Again, let us check the result:", "MathCaption",ExpressionUUID->"86d20593-4145-416e-91d0-37390eb6c98c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"U", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
  RowBox[{"ExpandGdelta", "[", 
   RowBox[{"Gdelta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "e", ",", "f", ",", "g"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->
  "In[204]:=",ExpressionUUID->"a3a4479d-daa2-4923-8612-a8a2a7906341"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Delta]", 
           StyleBox[GridBox[{
              {" ", "g"},
              {"a", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`delta[-$CellContext`a, $CellContext`g],
       Editable->False]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`e],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`e],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`f],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`f],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`g],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`g],
      Editable->False]}]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {"a", "b", "c"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[$CellContext`a, $CellContext`b, $CellContext`c],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977849948433*^9},
 CellLabel->"Out[204]=",
 CellID->1105583669,ExpressionUUID->"2c26fab6-a96e-462f-8340-145e0ee3c7f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Expand"}]], "Input",
 CellLabel->
  "In[205]:=",ExpressionUUID->"66652138-f1d8-4903-b1f6-e3d5da7825d4"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {"e", "f", "g"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[$CellContext`e, $CellContext`f, $CellContext`g],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {"e", "g", "f"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[$CellContext`e, $CellContext`g, $CellContext`f],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {"f", "e", "g"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[$CellContext`f, $CellContext`e, $CellContext`g],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {"f", "g", "e"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[$CellContext`f, $CellContext`g, $CellContext`e],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {"g", "e", "f"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[$CellContext`g, $CellContext`e, $CellContext`f],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {"g", "f", "e"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[$CellContext`g, $CellContext`f, $CellContext`e],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977850113667*^9},
 CellLabel->"Out[205]=",
 CellID->1516211039,ExpressionUUID->"be4c3da9-440e-4b89-a4a9-598f0b07f3d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->
  "In[206]:=",ExpressionUUID->"8791f0ad-41ea-4796-9cd5-530d3a6e8512"],

Cell[BoxData[
 RowBox[{"6", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {"e", "f", "g"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[$CellContext`e, $CellContext`f, $CellContext`g],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977850278228*^9},
 CellLabel->"Out[206]=",
 CellID->917977171,ExpressionUUID->"41c15348-4ae4-4a05-b22a-62dc81984341"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "U", "]"}]], "Input",
 CellLabel->
  "In[207]:=",ExpressionUUID->"47b8b85c-2421-4c20-b56d-adc94d7c0e33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "U"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`U],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977850580768*^9},
 CellLabel->"During evaluation of In[207]:=",
 CellID->919792949,ExpressionUUID->"c36347f0-a8d6-43d2-bc01-bc2234b6976a"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "In version 1.0.0, ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " has added yet another delta tensor, the \"superdelta\", which accepts any \
symmetry group. This object is still under development."
}], "Text",ExpressionUUID->"bc3c20b0-8a9d-47cf-863d-7c09c054085c"],

Cell[CellGroupData[{

Cell["\<\
This tensor projects any other tensor onto an expression with the symmetries \
of the Riemann tensor :\
\>", "MathCaption",
 CellChangeTimes->{{3.4946082225858593`*^9, 
  3.494608249178817*^9}},ExpressionUUID->"699aa6cc-c06d-4108-99d4-\
60028dfac6c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sdelta", "[", 
   RowBox[{"RiemannSymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], "]"}], "[", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{"-", "b"}], ",", 
   RowBox[{"-", "c"}], ",", 
   RowBox[{"-", "d"}], ",", "e", ",", "f", ",", "g", ",", "h"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.494608169706142*^9, 3.494608189645891*^9}},
 CellLabel->
  "In[208]:=",ExpressionUUID->"f76963c5-a5ff-4f92-bfd8-1ddbb8ba850c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Delta]", 
      StyleBox[GridBox[{
         {" ", " ", " ", " ", "e", "f", "g", "h"},
         {"a", "b", "c", "d", " ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Sdelta[
   xAct`xPerm`StrongGenSet[{1, 2, 3, 4}, 
    xAct`xPerm`GenSet[
     xAct`xPerm`Cycles[{1, 3}, {2, 4}], -xAct`xPerm`Cycles[{1, 2}], -
     xAct`xPerm`Cycles[{3, 
       4}]]]][-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d, $CellContext`e, $CellContext`f, $CellContext`g, \
$CellContext`h],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977850934519*^9},
 CellLabel->"Out[208]=",
 CellID->1372802737,ExpressionUUID->"9a3eba78-774d-450c-84e9-4c10988d96c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ExpandSdelta"}]], "Input",
 CellChangeTimes->{{3.494608209390026*^9, 3.4946082133171883`*^9}},
 CellLabel->
  "In[209]:=",ExpressionUUID->"06139917-d37f-46b5-8d9b-afe2b7303981"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "h"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`d, $CellContext`e],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "h"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`d, $CellContext`e],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "h"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`d, $CellContext`f],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "h"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`d, $CellContext`f],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "h"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`d, $CellContext`g],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "h"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`d, $CellContext`g],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "h"},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`d, $CellContext`h],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "e"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`a, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "f"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`b, $CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "g"},
             {"c", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`c, $CellContext`g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "h"},
             {"d", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`d, $CellContext`h],
      Editable->False]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.728977851197719*^9},
 CellLabel->"Out[209]=",
 CellID->131297391,ExpressionUUID->"47795137-627c-42fb-8617-858465a90876"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.6. Directional indices", "Subsection",ExpressionUUID->"cee63d08-2f11-43e6-a4bc-9b8db80f5a44"],

Cell[TextData[{
 "From the abstract point of view, covariant (contravariant) indices of \
tensors represent slots where vectors (covectors) can be \"contracted\". It \
is interesting sometimes to write that contraction explicitly: ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " uses the head ",
 StyleBox["Dir",
  FontFamily->"Courier"],
 " to denote that kind of \"directional index\". The introduction of a \
special head is a technical decision: we expect this feature to be seldom \
used and therefore it makes no sense to force ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " to check continuously whether a given slot contains an ab",
 "stract ind",
 "ex or a vector. All definitions concerning directional-indices are \
associated to ",
 StyleBox["Dir",
  FontFamily->"Courier"],
 ", and hence they are not even considered unless the head ",
 StyleBox["Dir",
  FontFamily->"Courier"],
 " is found."
}], "Text",ExpressionUUID->"dae88e9f-94c7-466a-b8a0-987970ef7265"],

Cell[TextData[{
 StyleBox[ButtonBox["Dir",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dir.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t\t\t", "DisplayMath"],
 StyleBox["Head denoting directional slots in tensors", "Text"]
}], "DefinitionBox",ExpressionUUID->"1ff6fab4-5050-41f8-b2f5-d1b26ae8b70f"],

Cell["Directional indices.", "Text",ExpressionUUID->"4882a813-adcd-480b-9aaf-e30e26795a3b"],

Cell[CellGroupData[{

Cell["This is the usual representation for a contraction:", "MathCaption",ExpressionUUID->"092e5e45-7da0-4d07-a504-9698540dd06e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"-", "b"}], "]"}], 
  RowBox[{"S", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Input",
 CellLabel->
  "In[210]:=",ExpressionUUID->"7120c12d-c856-431e-a321-b43f633d8a94"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[$CellContext`a, $CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" "},
          {"b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977861231162*^9},
 CellLabel->"Out[210]=",
 CellID->923251014,ExpressionUUID->"423213de-2dc4-40e8-ab9a-46d3a6588a72"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
But it can also be given as (note the different results of the validation \
routine below)\
\>", "MathCaption",ExpressionUUID->"05a19e42-7531-406c-a3df-d2c31fa5bbe0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Dir", "[", 
    RowBox[{"v", "[", 
     RowBox[{"-", "c"}], "]"}], "]"}]}], " ", "]"}]], "Input",
 CellLabel->
  "In[211]:=",ExpressionUUID->"6ccf66fd-e2b0-48b9-ba72-1da7e66739ab"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {"a", "v"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[$CellContext`a, 
   xAct`xTensor`Dir[
    $CellContext`v[-$CellContext`c]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977861366091*^9},
 CellLabel->"Out[211]=",
 CellID->1510442723,ExpressionUUID->"0bd88b6e-44c7-4e12-800c-d09d143242fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[212]:=",ExpressionUUID->"84a69629-63e3-467d-94d2-cffbfeedea99"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor v\\\\\
\\\"\\\"}]\\)\"", 2, 212, 25, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977861514696*^9},
 CellLabel->"During evaluation of In[212]:=",
 CellID->606654274,ExpressionUUID->"29eda692-6e50-417b-8e3d-5f0fdce60f07"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {"a", "v"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[$CellContext`a, 
   xAct`xTensor`Dir[
    $CellContext`v[-$CellContext`c]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977861544901*^9},
 CellLabel->"Out[212]=",
 CellID->1933510809,ExpressionUUID->"8824e6ab-bda5-48d9-83ef-c50c9dcea625"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Directional slots containing vectors are represented downstairs, and slots \
containing covectors are represented upstairs:\
\>", "MathCaption",ExpressionUUID->"a4ebcff7-4407-4381-9825-209611ee90b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Dir", "[", 
    RowBox[{"v", "[", "c", "]"}], "]"}]}], " ", "]"}]], "Input",
 CellLabel->
  "In[213]:=",ExpressionUUID->"d3df5355-2307-473c-a818-af8f0aea3651"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {"a", " "},
         {" ", "v"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[$CellContext`a, 
   xAct`xTensor`Dir[
    $CellContext`v[$CellContext`c]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977861665*^9},
 CellLabel->"Out[213]=",
 CellID->793620459,ExpressionUUID->"3a8634b7-4bb6-4d11-a99f-57a34efeded1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[214]:=",ExpressionUUID->"2ad9d6db-cc99-4e6b-8ffb-62caf9d74a9a"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor S\\\\\
\\\"\\\"}]\\)\"", 2, 214, 26, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.7289778619528*^9},
 CellLabel->"During evaluation of In[214]:=",
 CellID->358122896,ExpressionUUID->"8de8e366-bc8a-45ba-afd4-5208958efdb1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["ERROR",
     FontColor->Hue[0.]], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"S", 
         StyleBox[GridBox[{
            {"a", " "},
            {" ", "v"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[$CellContext`a, 
      xAct`xTensor`Dir[
       $CellContext`v[$CellContext`c]]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`ERROR[
   $CellContext`S[$CellContext`a, 
    xAct`xTensor`Dir[
     $CellContext`v[$CellContext`c]]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977861983584*^9},
 CellLabel->"Out[214]=",
 CellID->1722334178,ExpressionUUID->"e0a7ee8c-6c48-4550-b190-f04da1e89f06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Dir", "[", 
    RowBox[{"v", "[", 
     RowBox[{"-", "c"}], "]"}], "]"}]}], " ", "]"}]], "Input",
 CellLabel->
  "In[215]:=",ExpressionUUID->"b8f584b9-a518-4ae7-9e9f-96139f65c0a9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {"a", "v"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[$CellContext`a, 
   xAct`xTensor`Dir[
    $CellContext`v[-$CellContext`c]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977862353179*^9},
 CellLabel->"Out[215]=",
 CellID->1338451733,ExpressionUUID->"4189be2a-852b-41da-8ad0-f4180255af00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Validate", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[216]:=",ExpressionUUID->"366ee27f-f619-4c08-9667-7cc58346bbd9"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "error", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Invalid character of index in tensor v\\\\\
\\\"\\\"}]\\)\"", 2, 216, 27, 19253573948027831207, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977862669281*^9},
 CellLabel->"During evaluation of In[216]:=",
 CellID->467074206,ExpressionUUID->"65dcb444-608b-4a8b-9a2d-070df1c03e24"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {"a", "v"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[$CellContext`a, 
   xAct`xTensor`Dir[
    $CellContext`v[-$CellContext`c]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977862700863*^9},
 CellLabel->"Out[216]=",
 CellID->1063450457,ExpressionUUID->"1386a5b6-b773-40cc-bbd2-74c5435b44e9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["It has the expected properties for a tensorial slot:", "MathCaption",ExpressionUUID->"c37cbf54-17b1-4660-ac3c-48e8fce6feca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"w", "[", "a", "]"}], ",", "M3"}], "]"}]], "Input",
 CellLabel->
  "In[217]:=",ExpressionUUID->"39c61074-f698-423c-b63e-fbdf19c13967"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"w", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`w[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977862969079*^9},
 CellLabel->"During evaluation of In[217]:=",
 CellID->2052920465,ExpressionUUID->"81c123f3-d8b8-4bf8-b2bb-b85a5ee6e89a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Dir", "[", 
    RowBox[{
     RowBox[{"3", 
      RowBox[{"v", "[", 
       RowBox[{"-", "c"}], "]"}]}], "+", 
     RowBox[{"w", "[", 
      RowBox[{"-", "c"}], "]"}]}], "]"}]}], " ", "]"}]], "Input",
 CellLabel->
  "In[218]:=",ExpressionUUID->"b8e3ceec-38d5-4fb2-aa3b-889cd257c8ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"S", 
        StyleBox[GridBox[{
           {"a", "v"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[$CellContext`a, 
     xAct`xTensor`Dir[
      $CellContext`v[-$CellContext`c]]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {"a", "w"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[$CellContext`a, 
    xAct`xTensor`Dir[
     $CellContext`w[-$CellContext`c]]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977863100268*^9},
 CellLabel->"Out[218]=",
 CellID->1961982553,ExpressionUUID->"21651e12-eb84-4a6a-bb97-4d85a7b5065e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "w", "]"}]], "Input",
 CellLabel->
  "In[219]:=",ExpressionUUID->"3716cbf8-85e4-4d70-8284-d73d1f695200"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "w"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`w],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977863227611*^9},
 CellLabel->"During evaluation of In[219]:=",
 CellID->429368586,ExpressionUUID->"db977d41-2503-4ec2-86d6-5c720a6f0297"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "In particular, ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " understands the whole expression as a vector, and not as a 2-tensor:"
}], "MathCaption",ExpressionUUID->"52eb0882-e869-4c24-8ba9-47a038d4b5b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpVectorQ", "[", 
  RowBox[{"S", "[", 
   RowBox[{"a", ",", 
    RowBox[{"Dir", "[", 
     RowBox[{"v", "[", 
      RowBox[{"-", "c"}], "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[220]:=",ExpressionUUID->"67cd41f0-8aeb-4eff-a6f6-699f8c96edb4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.728977863348957*^9},
 CellLabel->"Out[220]=",
 CellID->852770982,ExpressionUUID->"908c2215-0161-4142-a94a-02eba1119bcc"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "It is important to realize that the free index ",
 StyleBox["c",
  FontFamily->"Courier"],
 " in ",
 StyleBox["Dir[v[c]]",
  FontFamily->"Courier"],
 " is completely irrelevant except for its sign and the tangent bundle it \
belongs to. It is there for consistency reasons: it identifies the argument \
of ",
 StyleBox["Dir",
  FontFamily->"Courier"],
 " as an upvector on ",
 StyleBox["TangentM3",
  FontFamily->"Courier"],
 ". I call those indices \"ultraindices\"."
}], "Text",ExpressionUUID->"6608ce0a-e5ee-491a-8663-9165f031c619"],

Cell[CellGroupData[{

Cell[TextData[{
 "If you find annoying to write ",
 StyleBox["Dir[v[c]]",
  FontFamily->"Courier"],
 " many times, you can name this expression:"
}], "MathCaption",ExpressionUUID->"742c9853-0aee-4193-aeeb-203e626202cf"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dirv", "=", 
   RowBox[{"Dir", "[", 
    RowBox[{"v", "[", "c", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"S", "[", 
  RowBox[{"a", ",", "dirv"}], "]"}]}], "Input",
 CellLabel->
  "In[221]:=",ExpressionUUID->"d278930a-0155-492b-9fcb-723efc59c857"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {"a", " "},
         {" ", "v"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[$CellContext`a, 
   xAct`xTensor`Dir[
    $CellContext`v[$CellContext`c]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977863580779*^9},
 CellLabel->"Out[222]=",
 CellID->216034396,ExpressionUUID->"dc01e41e-9864-4c36-bcc1-39a215b4ed7c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Finally, there is a pair of functions to convert the Dir indices into normal \
contractions, and viceversa :\
\>", "MathCaption",
 CellChangeTimes->{{3.461934006077577*^9, 
  3.4619340174393377`*^9}},ExpressionUUID->"41c015fd-f582-4c55-90f0-\
e6f4af8adef3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateDir", "[", 
   RowBox[{"%", ",", "v"}], "]"}], "//", "ScreenDollarIndices"}]], "Input",
 CellChangeTimes->{{3.4619340245346127`*^9, 3.461934024837811*^9}},
 CellLabel->
  "In[223]:=",ExpressionUUID->"abb6c5fc-d64a-458f-acc4-d056b6fe3fce"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {"a", " "},
          {" ", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977863765894*^9},
 CellLabel->"Out[223]=",
 CellID->1642730142,ExpressionUUID->"f2107841-ef55-43ad-9162-bc3066ef2b42"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractDir", "[", 
  RowBox[{"%", ",", "v"}], "]"}]], "Input",
 CellChangeTimes->{{3.461934029883997*^9, 3.461934034911304*^9}},
 CellLabel->
  "In[224]:=",ExpressionUUID->"6047e091-bcef-4164-85c5-fa5638b79224"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"S", 
      StyleBox[GridBox[{
         {"a", " "},
         {" ", "v"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`S[$CellContext`a, 
   xAct`xTensor`Dir[
    $CellContext`v[$CellContext`b]]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977863883071*^9},
 CellLabel->"Out[224]=",
 CellID->1315730762,ExpressionUUID->"ec13ccc4-8d12-4a50-b4e1-b805742c0685"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "dirv", "]"}]], "Input",
 CellLabel->
  "In[225]:=",ExpressionUUID->"1dea45a0-20ba-4a4e-8326-86027e224e7d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.7. Label indices", "Subsection",ExpressionUUID->"5bcbb47f-5dd2-4b4c-a475-129578912a65"],

Cell[TextData[{
 "Sometimes we want to have indices with no tensorial meaning. For instance \
the labels l, m of the spherical harmonics can be defined as label indices. \
This is done using a new head ",
 StyleBox["LI",
  FontFamily->"Courier"],
 ", following similar ideas to those bringing us to the head ",
 StyleBox["Dir",
  FontFamily->"Courier"],
 ". There are no definitions associated to ",
 StyleBox["LI",
  FontFamily->"Courier"],
 "; the user can use ",
 StyleBox["LI",
  FontFamily->"Courier"],
 " for any purpose he likes."
}], "Text",ExpressionUUID->"cee59409-3b4a-4d59-822f-63cc0832e3e6"],

Cell[TextData[{
 StyleBox[ButtonBox["LI",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LI.nb", CharacterEncoding -> "iso8859-1"],
     None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t\t\t", "DisplayMath"],
 StyleBox["Head denoting label slots in tensors\n", "Text"],
 StyleBox[ButtonBox["Labels",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Labels.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t\t", "Text",
  FontFamily->"Courier"],
 StyleBox["A ficticious vbundle to which all label indices belong", "Text"]
}], "DefinitionBox",ExpressionUUID->"f77ec4b8-27b1-4d56-9f5b-4d842fa65f7d"],

Cell["Label indices.", "Text",ExpressionUUID->"2cc6deed-6db7-4c12-b135-12b8060806f1"],

Cell[CellGroupData[{

Cell["We can define the spherical harmonics as", "MathCaption",ExpressionUUID->"d0c96438-ab0b-4de1-847b-cf9aaea23a4a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"Y", "[", 
    RowBox[{
     RowBox[{"LI", "@", "l"}], ",", 
     RowBox[{"LI", "@", "m"}]}], "]"}], ",", "S2"}], "]"}]], "Input",
 CellLabel->
  "In[226]:=",ExpressionUUID->"3917762c-0856-45e2-8a62-473dccb37ee9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Y", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Y[
    xAct`xTensor`LI[$CellContext`l], 
    xAct`xTensor`LI[$CellContext`m]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977869603508*^9},
 CellLabel->"During evaluation of In[226]:=",
 CellID->736429224,ExpressionUUID->"9bfd987d-3644-454e-bd9f-7362b6c6ed41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Y"}]], "Input",
 CellLabel->
  "In[227]:=",ExpressionUUID->"9201c517-efba-4712-b236-84adf1bbfe92"],

Cell[CellGroupData[{

Cell["Global`Y", "Print", "PrintUsage",
 CellChangeTimes->{3.7289778697823763`*^9},
 CellTags->"Info2273728981469-9181623",
 CellID->1217710107,ExpressionUUID->"d09061f2-d245-4708-9251-86b611186377"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "Y", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`Y],
          Editable->False], "^=", "Y"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "Y", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "Y", "]"}], "^=", 
         RowBox[{"{", "S2", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "Y", "]"}], "^=", 
         RowBox[{"{", "S2", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "Y", "]"}], "^=", "\<\"Y\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "Y", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["xAct`xTensor`Labels",
             ShowAutoStyles->False,
             AutoSpacing->False],
            xAct`xTensor`Labels,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["xAct`xTensor`Labels",
             ShowAutoStyles->False,
             AutoSpacing->False],
            xAct`xTensor`Labels,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "Y", "]"}], "^=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"GenSet", "[", "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "Y", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "Y", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`Y],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977869806344*^9},
 CellTags->"Info2273728981469-9181623",
 CellID->534612439,ExpressionUUID->"17855b62-38ea-437b-aaa7-7df201779033"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The up/down character of the labels only indicates the output position of \
the indices. Note that the signs inside ",
 StyleBox["LI",
  FontFamily->"Courier"],
 " are part of the label, and do not indicate the character."
}], "MathCaption",ExpressionUUID->"2b50a1c0-7f05-4f3c-a83b-e3913ff7ab34"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Y", "[", 
  RowBox[{
   RowBox[{"LI", "@", "L"}], ",", 
   RowBox[{"LI", "@", "M"}]}], "]"}]], "Input",
 CellLabel->
  "In[228]:=",ExpressionUUID->"323759bd-c4a0-4395-8b17-1d69a22c20e1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"Y", 
      StyleBox[GridBox[{
         {"L", "M"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Y[
   xAct`xTensor`LI[$CellContext`L], 
   xAct`xTensor`LI[$CellContext`M]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977869925173*^9},
 CellLabel->"Out[228]=",
 CellID->159683225,ExpressionUUID->"342c4704-c948-4176-ae45-511858e7b0e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Y", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"LI", "[", "L", "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"LI", "[", "2", "]"}]}]}], "]"}], ",", 
   RowBox[{"Y", "[", 
    RowBox[{
     RowBox[{"LI", "[", 
      RowBox[{"-", "L"}], "]"}], ",", 
     RowBox[{"LI", "[", 
      RowBox[{"-", "2"}], "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->
  "In[229]:=",ExpressionUUID->"4380e29d-41c7-48a5-af56-629b92f3aab4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"Y", 
        StyleBox[GridBox[{
           {" ", " "},
           {"L", "2"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Y[-xAct`xTensor`LI[$CellContext`L], -xAct`xTensor`LI[2]],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"Y", 
        StyleBox[GridBox[{
           {
            RowBox[{"-", "L"}], 
            RowBox[{"-", "2"}]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Y[
     xAct`xTensor`LI[-$CellContext`L], 
     xAct`xTensor`LI[-2]],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.72897787004317*^9},
 CellLabel->"Out[229]=",
 CellID->1588887472,ExpressionUUID->"2c7a8f35-cb62-4308-9956-320fe89a669b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "Y", "]"}]], "Input",
 CellLabel->
  "In[230]:=",ExpressionUUID->"399acf47-e35f-47a7-b7de-9b5cc6a2ab37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Y"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Y],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977870184417*^9},
 CellLabel->"During evaluation of In[230]:=",
 CellID->472591459,ExpressionUUID->"396107e9-6a05-45c0-b1ed-f6579ab9a925"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "In version 1.0.0 ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " has added the possibility of having tensors with nonatomic heads. However, \
this is not accepted in ",
 StyleBox["DefTensor",
  FontFamily->"Courier"],
 ", which means that we need to declare by hand all properties of the tensors."
}], "Text",ExpressionUUID->"8b831627-c064-4d91-b9df-20c4447657ba"],

Cell[CellGroupData[{

Cell["\<\
For example, we could have (symmetric) tensor spherical harmonics, with a \
variable number of indices, expressed as (note the use of upvalues)\
\>", "MathCaption",
 CellChangeTimes->{{3.494608378815723*^9, 3.494608393260377*^9}, {
  3.494608430088417*^9, 3.494608432445478*^9}, {3.494608499378916*^9, 
  3.494608503771892*^9}, {3.494608595644052*^9, 3.494608621812394*^9}, {
  3.4946086559276447`*^9, 
  3.494608660664278*^9}},ExpressionUUID->"05837fd2-6990-400e-85af-\
320fda22566d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"Y", "[", 
     RowBox[{"l_", ",", "m_", ",", "s_"}], "]"}], "]"}], "^=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"Y", "[", 
     RowBox[{"l_", ",", "m_", ",", "s_"}], "]"}], "]"}], "^:=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"-", "TangentS2"}], ",", 
     RowBox[{"{", "s", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"Y", "[", 
     RowBox[{"l_", ",", "m_", ",", "s_"}], "]"}], "]"}], "^=", 
   RowBox[{"{", "S2", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{
     RowBox[{"Y", "[", 
      RowBox[{"l_", ",", "m_", ",", "s_"}], "]"}], "[", "inds___", "]"}], 
    "]"}], "^:=", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", 
      RowBox[{"{", "inds", "}"}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"Y", "[", 
     RowBox[{"l_", ",", "m_", ",", "s_"}], "]"}], "]"}], "^:=", 
   RowBox[{"SubscriptBox", "[", 
    RowBox[{"\"\<Y\>\"", ",", 
     RowBox[{"ToBoxes", "[", 
      RowBox[{"{", 
       RowBox[{"l", ",", "m", ",", "s"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->
  "In[231]:=",ExpressionUUID->"fd427259-6fb3-4f69-a6e1-5b856b707520"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Y", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "2"}], ",", "1"}], "]"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellChangeTimes->{{3.4946084074152927`*^9, 3.494608427147748*^9}, {
  3.4946086661771183`*^9, 3.494608680361247*^9}},
 CellLabel->
  "In[236]:=",ExpressionUUID->"ee6e225e-5363-4f55-ab8e-7e15915a4868"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      SubscriptBox["Y", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "2"}], ",", "1"}], "}"}]], 
      StyleBox[GridBox[{
         {"a", "b", "c"},
         {" ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Y[3, -2, 1][$CellContext`a, $CellContext`b, $CellContext`c],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977870617581*^9},
 CellLabel->"Out[236]=",
 CellID->1450124807,ExpressionUUID->"c2f754ea-eadb-440f-acd9-a9d8b5653437"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Sometimes we do not need to define values for all functions. The only \
essential functions are ",
 StyleBox["xTensorQ",
  FontFamily->"Courier"],
 ", ",
 StyleBox["SlotsOfTensor",
  FontFamily->"Courier"],
 " and",
 StyleBox[" DependenciesOfTensor",
  FontFamily->"Courier"],
 ", that identify the tensor field character of the object. Then ",
 StyleBox["SymmetryGroupOfTensor",
  FontFamily->"Courier"],
 " is needed if the tensor has a symmetry, and ",
 StyleBox["PrintAs",
  FontFamily->"Courier"],
 " if special formatting is needed. The only other functions that might be \
needed are ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 " and ",
 StyleBox["WeightOfTensor",
  FontFamily->"Courier"],
 ", the latter having a default of zero. The remaining function are used by \
",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " for bookkeping purposes, namely ",
 StyleBox["DefInfo",
  FontFamily->"Courier"],
 ", ",
 StyleBox["HostsOf",
  FontFamily->"Courier"],
 " and ",
 StyleBox["TensorID",
  FontFamily->"Courier"],
 ". These non-atomic-head tensors cannot be defined via ",
 StyleBox["DefTensor",
  FontFamily->"Courier"],
 ". They must necessarily be defined by hand."
}], "Text",ExpressionUUID->"8ac046d8-9cb4-4b92-ba43-d7ee9f63bc36"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{
  "Y", ",", "l", ",", "m", ",", "s", ",", "inds", ",", "L", ",", "M"}], 
  "]"}]], "Input",
 CellLabel->
  "In[237]:=",ExpressionUUID->"d840339c-6241-45e3-962e-97933d64631d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.8. Complex conjugation", "Subsection",ExpressionUUID->"ea33d657-7f0c-4e11-b67d-e460d1a2abaf"],

Cell[TextData[{
 "Complex conjugation is performed by the function ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 ", except on indices, where we shall use the variant ",
 StyleBox["DaggerIndex",
  FontFamily->"Courier"],
 ", to avoid overloading ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 " too much."
}], "Text",ExpressionUUID->"eb2c7916-e5c5-4dde-a668-0bc55813358f"],

Cell[TextData[{
 StyleBox[ButtonBox["Dagger",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dagger.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Complex conjugation of tensor expressions\n", "Text"],
 StyleBox[ButtonBox["DaggerIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DaggerIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["Complex conjugation of indices\n", "Text"],
 StyleBox[ButtonBox["DaggerQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DaggerQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Check for complex objects\n", "Text"],
 StyleBox[ButtonBox["TransposeDagger",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TransposeDagger.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t", "DisplayMath"],
 StyleBox["Transposition of indices of complex conjugate vbundles\n", 
  "Text"],
 StyleBox[ButtonBox["$DaggerCharacter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$DaggerCharacter.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t", "DisplayMath"],
 StyleBox["Character which denotes complex conjugates of other objects", 
  "Text"]
}], "DefinitionBox",ExpressionUUID->"159dc468-ea03-412f-b8d2-10faa70ec4a4"],

Cell["Complex conjugation", "Text",ExpressionUUID->"687e2a48-aee8-46e3-88a2-b01d2d89ee12"],

Cell[CellGroupData[{

Cell["\<\
A tensor with indices on a complex vbundle always has a dagger pair:\
\>", "MathCaption",ExpressionUUID->"e31ec0b5-a939-48cb-843b-1ad3f66cb1df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], ",", "TangentM3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->
  "In[238]:=",ExpressionUUID->"234e76b2-f59f-4f60-915a-a90ed8a4347c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", 
    RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`a, $CellContext`\[GothicCapitalB]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977879434466*^9},
 CellLabel->"During evaluation of In[238]:=",
 CellID->34886677,ExpressionUUID->"5f3cd4d9-0c91-4c79-a027-27aba6f3165d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", 
    RowBox[{"a", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`a, $CellContext`\[GothicCapitalB]\
\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977879452157*^9},
 CellLabel->"During evaluation of In[238]:=",
 CellID->77344708,ExpressionUUID->"bf2013e1-2abd-4a10-8895-95a7e3f8d863"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "V"}]], "Input",
 CellLabel->
  "In[239]:=",ExpressionUUID->"46acec2c-8acb-4ee1-864f-be8dc3d9316e"],

Cell[CellGroupData[{

Cell["Global`V", "Print", "PrintUsage",
 CellChangeTimes->{3.728977879613552*^9},
 CellTags->"Info2393728981479-9181623",
 CellID->704900921,ExpressionUUID->"729ec76a-285d-4e29-a392-3a0b59f569e5"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "V", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`V],
          Editable->False], "^=", "V\[Dagger]"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "V", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "V", "]"}], "^=", 
         RowBox[{"{", "M3", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "V", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["InnerC",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`InnerC,
            Editable->False], ",", "M3", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "V", "]"}], "^=", "\<\"V\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"ServantsOf", "[", "V", "]"}], "^=", 
         RowBox[{"{", "V\[Dagger]", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "V", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["InnerC",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`InnerC,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "V", "]"}], "^=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"GenSet", "[", "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "V", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "V", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`V],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897787963589*^9},
 CellTags->"Info2393728981479-9181623",
 CellID->1749982395,ExpressionUUID->"55bb2ae3-f92f-49b6-a6b4-e800ab4bf2c8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "V\[Dagger]"}]], "Input",
 CellLabel->
  "In[240]:=",ExpressionUUID->"3ff8171b-7faa-4e1a-b515-08f53ee376dd"],

Cell[CellGroupData[{

Cell["Global`V\[Dagger]", "Print", "PrintUsage",
 CellChangeTimes->{3.728977879795273*^9},
 CellTags->"Info2403728981479-9181623",
 CellID->18083453,ExpressionUUID->"f4ae4598-eca7-4561-b34c-69b4a8d91214"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "V\[Dagger]", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`V\[Dagger]],
          Editable->False], "^=", "V"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "V\[Dagger]", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "V\[Dagger]", "]"}], "^=", 
         RowBox[{"{", "M3", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "V\[Dagger]", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["InnerC\[Dagger]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`InnerC\[Dagger],
            Editable->False], ",", "M3", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"MasterOf", "[", "V\[Dagger]", "]"}], "^=", "V"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "V\[Dagger]", "]"}], 
         "^=", "\<\"V\[Dagger]\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "V\[Dagger]", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], ",", 
           InterpretationBox[
            StyleBox["InnerC\[Dagger]",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`InnerC\[Dagger],
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SymmetryGroupOfTensor", "[", "V\[Dagger]", "]"}], "^=", 
         RowBox[{"StrongGenSet", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{"GenSet", "[", "]"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "V\[Dagger]", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "V\[Dagger]", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`V\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778798193073`*^9},
 CellTags->"Info2403728981479-9181623",
 CellID->1133400344,ExpressionUUID->"50884fe2-237c-4232-b241-7b33a9fb2528"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Complex conjugation acts on the name of the tensor and on its indices as well:\
\>", "MathCaption",ExpressionUUID->"4868cfeb-8e11-41dc-82b0-fa75de150ccd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", " ", 
  RowBox[{"V", "[", 
   RowBox[{"a", ",", "\[GothicCapitalC]"}], "]"}], " ", "]"}]], "Input",
 CellLabel->
  "In[241]:=",ExpressionUUID->"99cccb93-2181-412a-b0f6-257cc8584006"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"V\[Dagger]", 
      StyleBox[GridBox[{
         {"a", "\[GothicCapitalC]\[Dagger]"},
         {" ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`V\[Dagger][$CellContext`a, $CellContext`\[GothicCapitalC]\
\[Dagger]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977880170309*^9},
 CellLabel->"Out[241]=",
 CellID->879632718,ExpressionUUID->"eae13a93-1ae9-482b-a738-13895d0fad76"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "V", "]"}]], "Input",
 CellLabel->
  "In[242]:=",ExpressionUUID->"69d3165b-e826-4dbe-89cb-cbe7731681f8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897788053129*^9},
 CellLabel->"During evaluation of In[242]:=",
 CellID->709665478,ExpressionUUID->"7c23daf0-2746-4780-b2b1-8d7343ea062b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977880551731*^9},
 CellLabel->"During evaluation of In[242]:=",
 CellID->223513308,ExpressionUUID->"12b06724-e87f-4d37-b0a7-6e1be6257e48"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Conjugation of indices (this should be used only for programming):\
\>", "MathCaption",ExpressionUUID->"57c9d282-d824-46e2-92d7-5f5219f6f197"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaggerIndex", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"-", "b"}], ",", "\[GothicCapitalA]", ",", 
    RowBox[{"-", "\[GothicCapitalB]\[Dagger]"}]}], "}"}]}]], "Input",
 CellLabel->
  "In[243]:=",ExpressionUUID->"f4ae1704-1355-4c19-b0ac-ebc7d50ba99e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}], ",", "\[GothicCapitalA]\[Dagger]", ",", 
   RowBox[{"-", "\[GothicCapitalB]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7289778807171717`*^9},
 CellLabel->"Out[243]=",
 CellID->639268953,ExpressionUUID->"bd61ac98-b6ce-4fa7-86c5-37011cb7da88"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Tensors can be defined with different properties against complex conjugation.\
\
\>", "Text",ExpressionUUID->"5f6c124e-74f3-4d15-bcc5-1bc82c7c10f9"],

Cell[CellGroupData[{

Cell["On real vbundles tensors are real by default:", "MathCaption",ExpressionUUID->"8ee12e9d-f5dc-4751-a553-eba159640d0a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DefTensor", "]"}]], "Input",
 CellLabel->
  "In[244]:=",ExpressionUUID->"ba71e427-4a2a-4770-9a44-9e4da06317b9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Dagger", "\[Rule]", "Real"}], ",", 
   RowBox[{"Master", "\[Rule]", "Null"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", 
   RowBox[{"VanishingQ", "\[Rule]", "False"}], ",", 
   RowBox[{"ForceSymmetries", "\[Rule]", "False"}], ",", 
   RowBox[{"WeightOfTensor", "\[Rule]", "0"}], ",", 
   RowBox[{"GradeOfTensor", "\[Rule]", "0"}], ",", 
   RowBox[{"FrobeniusQ", "\[Rule]", "False"}], ",", 
   RowBox[{"OrthogonalTo", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"ProjectedWith", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
   
   RowBox[{"DefInfo", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}], ",", 
   RowBox[{"TensorID", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.728977880993339*^9},
 CellLabel->"Out[244]=",
 CellID->332607130,ExpressionUUID->"d467c0fc-2330-4794-a200-34f5434b5c0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"V", "[", "a", "]"}], ",", "M3"}], "]"}]], "Input",
 CellLabel->
  "In[245]:=",ExpressionUUID->"0b10d262-d244-44b9-932b-72be1dba2bc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778813214293`*^9},
 CellLabel->"During evaluation of In[245]:=",
 CellID->228100769,ExpressionUUID->"676b09d7-1fdc-4fb7-a628-0f7f99a861b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"3", "I", " ", 
   RowBox[{"V", "[", "a", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[246]:=",ExpressionUUID->"521a9185-17fa-4e06-8e11-9081d4d46fa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"V", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`V[$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.7289778815615053`*^9},
 CellLabel->"Out[246]=",
 CellID->431314688,ExpressionUUID->"3bb42abd-eab7-4305-a2cf-1305b38ec1ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "V", "]"}]], "Input",
 CellLabel->
  "In[247]:=",ExpressionUUID->"ced94c9d-6356-4fdb-8eee-75b5e7c18ab2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977881750795*^9},
 CellLabel->"During evaluation of In[247]:=",
 CellID->1348652591,ExpressionUUID->"a291bb32-be87-4f18-b9aa-77c5980dd45b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
However, it is possible to \"complexify\" a real vbundle, in such a way that \
we duplicate its real dimension. Then vectors can have nontrivial complex \
conjugates:\
\>", "MathCaption",ExpressionUUID->"68df0777-34c1-4a2e-b230-8c62e528c97f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"V", "[", "a", "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->
  "In[248]:=",ExpressionUUID->"e90deda9-b906-4960-a78f-8434db06178e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778818866673`*^9},
 CellLabel->"During evaluation of In[248]:=",
 CellID->114202852,ExpressionUUID->"ac33456f-e11c-4ae1-9c50-6a4516561df6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778819059477`*^9},
 CellLabel->"During evaluation of In[248]:=",
 CellID->1704436793,ExpressionUUID->"9baa71f6-8bde-42bf-9826-efd354a4580b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"3", "I", " ", 
   RowBox[{"V", "[", "a", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[249]:=",ExpressionUUID->"544a2b37-a264-429b-8c03-2e884a1e6c95"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"V\[Dagger]", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`V\[Dagger][$CellContext`a],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977882052754*^9},
 CellLabel->"Out[249]=",
 CellID->1184812618,ExpressionUUID->"024d95dd-ce4f-4e67-ab15-0e7d50851c2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "V", "]"}]], "Input",
 CellLabel->
  "In[250]:=",ExpressionUUID->"d5c3ee27-e635-4347-ab22-78bf4f8bf4d3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778821951847`*^9},
 CellLabel->"During evaluation of In[250]:=",
 CellID->1677295742,ExpressionUUID->"320d4b5b-3a58-40a1-b36e-9043996b2719"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778822137337`*^9},
 CellLabel->"During evaluation of In[250]:=",
 CellID->291701625,ExpressionUUID->"f2899bff-c11b-4843-bb66-53e086f9b551"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
If the vbundle is complex then all tensors on it must be complex:\
\>", "MathCaption",ExpressionUUID->"8fb825ea-90cb-4f52-b12f-bd6f233b4ee5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"V", "[", "\[GothicCapitalA]", "]"}], ",", "M3"}], "]"}]], "Input",\

 CellLabel->
  "In[251]:=",ExpressionUUID->"51615578-25c7-4472-819c-fc996d122322"],

Cell[BoxData[
 TemplateBox[{
  "DefTensor", "invalid", 
   "\"\\!\\(\\*RowBox[{\\\"Real\\\"}]\\) is not a valid \\!\\(\\*RowBox[{\\\"\
\\\\\\\"value for Dagger: complex indices\\\\\\\"\\\"}]\\).\"", 2, 251, 28, 
   19253573948027831207, "Local", "xAct`xTensor`DefTensor"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.728977882469781*^9},
 CellLabel->"During evaluation of In[251]:=",
 CellID->2071528921,ExpressionUUID->"8398fd3c-ec66-4827-8e80-54be58173303"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"V", "[", "\[GothicCapitalA]", "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}]], "Input",
 CellLabel->
  "In[252]:=",ExpressionUUID->"572a8af7-b017-43af-9a35-bcd91804c95d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", "\[GothicCapitalA]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`\[GothicCapitalA]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977882921338*^9},
 CellLabel->"During evaluation of In[252]:=",
 CellID->1181690083,ExpressionUUID->"dc81dfc3-bbbc-4d3f-8390-40848bfde7be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", "\[GothicCapitalA]\[Dagger]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`\[GothicCapitalA]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778829402323`*^9},
 CellLabel->"During evaluation of In[252]:=",
 CellID->736457525,ExpressionUUID->"a4c429ee-fcf1-494e-bb12-0b9c89159343"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"3", "I", " ", 
   RowBox[{"V", "[", "\[GothicCapitalA]", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[253]:=",ExpressionUUID->"e38a45d1-4b2c-4184-8703-2cea9adc08c8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"V\[Dagger]", 
       StyleBox[GridBox[{
          {"\[GothicCapitalA]\[Dagger]"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`V\[Dagger][$CellContext`\[GothicCapitalA]\[Dagger]],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977883115734*^9},
 CellLabel->"Out[253]=",
 CellID->1693365014,ExpressionUUID->"dec04b48-cfde-4a66-8a02-849b265f337a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "V", "]"}]], "Input",
 CellLabel->
  "In[254]:=",ExpressionUUID->"eece5558-b330-469d-ae57-2da5e8bf9946"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897788326652*^9},
 CellLabel->"During evaluation of In[254]:=",
 CellID->1932500254,ExpressionUUID->"2ba7993c-bfb3-45d9-bbda-466b265efa57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977883284461*^9},
 CellLabel->"During evaluation of In[254]:=",
 CellID->989091750,ExpressionUUID->"f0363b49-b156-4437-b21b-920cf0851a5f"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
On complex vbundles it is possible to define Hermitian tensors if they have \
equal number of indices on both conjugated vbundles (though there is no \
built-in operation of Hermitian conjugation):\
\>", "MathCaption",ExpressionUUID->"94d5af63-1576-430f-96ee-ba46a6d17bb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
     "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]"}], "]"}],
    ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Hermitian"}]}], "]"}]], "Input",
 CellLabel->
  "In[255]:=",ExpressionUUID->"49de26f0-e4b5-465d-bb04-9fcda065a04c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
     "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]"}], "]"}],
    "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`\[GothicCapitalA], $CellContext`\
\[GothicCapitalB], $CellContext`\[GothicCapitalC]\[Dagger], $CellContext`\
\[GothicCapitalD]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977883422408*^9},
 CellLabel->"During evaluation of In[255]:=",
 CellID->2141614470,ExpressionUUID->"fa48d62d-7b46-4675-acc0-65b2103e9c80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", 
    RowBox[{
    "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
     "\[GothicCapitalC]", ",", "\[GothicCapitalD]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`\[GothicCapitalA]\[Dagger], \
$CellContext`\[GothicCapitalB]\[Dagger], $CellContext`\[GothicCapitalC], \
$CellContext`\[GothicCapitalD]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778834406853`*^9},
 CellLabel->"During evaluation of In[255]:=",
 CellID->140989923,ExpressionUUID->"1b982c69-2c28-4e35-8298-13f45a5f6191"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"V", "[", 
   RowBox[{
   "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
    "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->
  "In[256]:=",ExpressionUUID->"f2be409f-f389-4683-945f-166b3198ef4f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"V", 
      StyleBox[GridBox[{
         {"\[GothicCapitalC]", "\[GothicCapitalD]", 
          "\[GothicCapitalA]\[Dagger]", "\[GothicCapitalB]\[Dagger]"},
         {" ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`V[$CellContext`\[GothicCapitalC], $CellContext`\
\[GothicCapitalD], $CellContext`\[GothicCapitalA]\[Dagger], $CellContext`\
\[GothicCapitalB]\[Dagger]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977883586383*^9},
 CellLabel->"Out[256]=",
 CellID->943173220,ExpressionUUID->"91ecfb7a-e9a1-4728-b042-288a0f2f39fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"V\[Dagger]", "[", 
   RowBox[{
   "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
    "\[GothicCapitalC]", ",", "\[GothicCapitalD]"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[257]:=",ExpressionUUID->"0af59942-68cd-4700-b253-5b265ecddbac"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"V", 
      StyleBox[GridBox[{
         {"\[GothicCapitalA]", "\[GothicCapitalB]", 
          "\[GothicCapitalC]\[Dagger]", "\[GothicCapitalD]\[Dagger]"},
         {" ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`V[$CellContext`\[GothicCapitalA], $CellContext`\
\[GothicCapitalB], $CellContext`\[GothicCapitalC]\[Dagger], $CellContext`\
\[GothicCapitalD]\[Dagger]],
  Editable->False]], "Output",
 CellChangeTimes->{3.7289778837092113`*^9},
 CellLabel->"Out[257]=",
 CellID->1335510033,ExpressionUUID->"3353dae0-284c-4fdf-b6ae-98619fd6c94d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"W", "[", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
     "\[GothicCapitalC]\[Dagger]"}], "]"}], ",", "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Hermitian"}]}], "]"}]], "Input",
 CellLabel->
  "In[258]:=",ExpressionUUID->"a174b86d-f4e2-4ed3-abd6-365721f1981d"],

Cell[BoxData[
 TemplateBox[{
  "TransposeDagger", "error3", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Different number of indices \
of\\\\\\\"\\\"}]\\) \\!\\(\\*InterpretationBox[StyleBox[\\\"InnerC\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], InnerC, \
Rule[Editable, False]]\\) \\!\\(\\*RowBox[{\\\"\\\\\\\"and its \
conjugate\\\\\\\"\\\"}]\\) \\!\\(\\*InterpretationBox[StyleBox[\\\"InnerC\
\[Dagger]\\\", Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], InnerC\
\\\\[Dagger], Rule[Editable, False]]\\)\"", 2, 258, 29, 19253573948027831207, 
   "Local", "xAct`xTensor`TransposeDagger"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.7289778838262053`*^9},
 CellLabel->"During evaluation of In[258]:=",
 CellID->418046187,ExpressionUUID->"54c70a22-939f-404f-8183-91e1b9716b23"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefTensor", "[", "V", "]"}], ";"}]], "Input",
 CellLabel->
  "In[259]:=",ExpressionUUID->"a8cac00d-fec6-48a4-9511-791a28520dcf"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778842217007`*^9},
 CellLabel->"During evaluation of In[259]:=",
 CellID->1683255572,ExpressionUUID->"80d5bd83-3433-4cc4-8ae3-4eed20bfc38d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977884240902*^9},
 CellLabel->"During evaluation of In[259]:=",
 CellID->1674316673,ExpressionUUID->"469395c4-fc63-4ef3-b2ef-b5022b75d228"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Note that the transposition involved for Hermitian objects does not require \
any particular ordering of indices of the tensors. However it follows the \
convention of exchanging the first slot of a given complex vbundle with the \
first slot of its complex conjugate:\
\>", "MathCaption",ExpressionUUID->"1468d4f7-eedf-43ee-854c-0616d4346519"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"V", "[", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
     "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
     "\[GothicCapitalE]", ",", "\[GothicCapitalF]\[Dagger]"}], "]"}], ",", 
   "M3", ",", 
   RowBox[{"Dagger", "\[Rule]", "Hermitian"}]}], "]"}]], "Input",
 CellLabel->
  "In[260]:=",ExpressionUUID->"91584caa-7b9b-4295-90a2-dbc7dd057173"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
     "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
     "\[GothicCapitalE]", ",", "\[GothicCapitalF]\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`\[GothicCapitalA], $CellContext`\
\[GothicCapitalB], $CellContext`\[GothicCapitalC]\[Dagger], $CellContext`\
\[GothicCapitalD]\[Dagger], $CellContext`\[GothicCapitalE], $CellContext`\
\[GothicCapitalF]\[Dagger]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778845830593`*^9},
 CellLabel->"During evaluation of In[260]:=",
 CellID->1762096470,ExpressionUUID->"fb5b66ba-32e6-4d91-8d1f-ba55870a25e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", 
    RowBox[{
    "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
     "\[GothicCapitalC]", ",", "\[GothicCapitalD]", ",", 
     "\[GothicCapitalE]\[Dagger]", ",", "\[GothicCapitalF]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`\[GothicCapitalA]\[Dagger], \
$CellContext`\[GothicCapitalB]\[Dagger], $CellContext`\[GothicCapitalC], \
$CellContext`\[GothicCapitalD], $CellContext`\[GothicCapitalE]\[Dagger], \
$CellContext`\[GothicCapitalF]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897788460075*^9},
 CellLabel->"During evaluation of In[260]:=",
 CellID->1755879160,ExpressionUUID->"be4c0973-0c7e-4c18-a0b5-d63de7433988"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", 
  RowBox[{"V", "[", 
   RowBox[{
   "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
    "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
    "\[GothicCapitalE]", ",", "\[GothicCapitalF]\[Dagger]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->
  "In[261]:=",ExpressionUUID->"43aa06d0-6176-4176-ae70-09442e01734e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"V", 
      StyleBox[GridBox[{
         {"\[GothicCapitalC]", "\[GothicCapitalD]", 
          "\[GothicCapitalA]\[Dagger]", "\[GothicCapitalB]\[Dagger]", 
          "\[GothicCapitalF]", "\[GothicCapitalE]\[Dagger]"},
         {" ", " ", " ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`V[$CellContext`\[GothicCapitalC], $CellContext`\
\[GothicCapitalD], $CellContext`\[GothicCapitalA]\[Dagger], $CellContext`\
\[GothicCapitalB]\[Dagger], $CellContext`\[GothicCapitalF], $CellContext`\
\[GothicCapitalE]\[Dagger]],
  Editable->False]], "Output",
 CellChangeTimes->{3.728977884736393*^9},
 CellLabel->"Out[261]=",
 CellID->340765046,ExpressionUUID->"aa333319-0399-4a6c-aa64-32743ea920ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "V", "]"}]], "Input",
 CellLabel->
  "In[262]:=",ExpressionUUID->"561e6c71-f23b-404f-8fed-141a9cb9aaf5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977884863521*^9},
 CellLabel->"During evaluation of In[262]:=",
 CellID->2046725220,ExpressionUUID->"577390e9-8641-4691-8755-fec59989f09e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977884882667*^9},
 CellLabel->"During evaluation of In[262]:=",
 CellID->917714894,ExpressionUUID->"79c1785d-d182-47de-8b28-6101ba8ba080"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The symbol for conjugation can be changed using the global variable ",
 StyleBox["$DaggerCharacter",
  FontFamily->"Courier"],
 ", but of course the command for complex conjugation will still be called ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 "."
}], "MathCaption",ExpressionUUID->"3aa3f2c4-eaf9-424f-b420-7f34e6bae3fd"],

Cell[CellGroupData[{

Cell[BoxData["$DaggerCharacter"], "Input",
 CellLabel->
  "In[263]:=",ExpressionUUID->"24820903-b510-4139-a564-1360d91496f7"],

Cell[BoxData["\<\"\[Dagger]\"\>"], "Output",
 CellChangeTimes->{3.728977885048777*^9},
 CellLabel->"Out[263]=",
 CellID->806670704,ExpressionUUID->"0612ca62-1934-467e-bbd6-038136d4c3c0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "W", "]"}]], "Input",
 CellLabel->
  "In[264]:=",ExpressionUUID->"08a20120-5f20-4b41-b7e4-95cc4ebb2320"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.9. Tensors with a variable number of slots", "Subsection",ExpressionUUID->"85b1e558-0468-4c77-849b-9e1fc7db8f9e"],

Cell[TextData[{
 "Sometimes it is desirable to work with tensors with a variable number of \
slots, and ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " supports it. For example, this is important when dealing with tensor \
harmonics, and actually the special package ",
 StyleBox["xAct`Harmonics`",
  FontFamily->"Courier"],
 " makes use of it.\nIn general, once a tensor has been defined with a number \
of slots and the symmetry properties of those slots, it is possible to use \
the tensor with more slots, and the system will assume that there are no \
additional symmetry properties on the added slots. The problem, however, \
comes when we want all slots to participate in the symmetry of the tensor. \
The solution is very simple:\nThe symmetry of a tensor is given by the \
function ",
 StyleBox["SymmetryGroupOfTensor",
  FontFamily->"Courier"],
 ", which stores the symmetry as an upvalue for the name of the tensor. \
However, this function tries first to get the symmetry from the whole \
expression of the tensor (indices included), and only if this is not defined \
it will use the stored definition. Therefore we can give additional symmetry \
definitions for the tensor which will overwrite the initial symmetry \
assignment. From version 0.9.4 we include a special notation to indicate from \
the beginning the presence of a variable number of slots in vbundle."
}], "Text",ExpressionUUID->"0d0845de-9f05-4c78-8761-3b37fb35c005"],

Cell[CellGroupData[{

Cell["\<\
Define a tensor with a variable number of indices on a given vbundle:\
\>", "MathCaption",ExpressionUUID->"a673768f-7822-4a7c-bfcc-e01965389728"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"Z", "[", 
    RowBox[{"AnyIndices", "@", "TangentM3"}], "]"}], ",", "M3"}], 
  "]"}]], "Input",
 CellLabel->
  "In[265]:=",ExpressionUUID->"66ddc65a-3c82-4c76-9e58-c165170672ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Z", "[", 
    RowBox[{"AnyIndices", "[", 
     InterpretationBox[
      StyleBox["\[DoubleStruckCapitalT]M3",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`TangentM3,
      Editable->False], "]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Z[
    xAct`xTensor`AnyIndices[$CellContext`TangentM3]], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977892327051*^9},
 CellLabel->"During evaluation of In[265]:=",
 CellID->432104373,ExpressionUUID->"8a06c4a2-ebca-4f41-82b0-bfe02d4a4f82"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Z"}]], "Input",
 CellLabel->
  "In[266]:=",ExpressionUUID->"5c0076a7-85aa-4dcd-94d3-ef9a7df51381"],

Cell[CellGroupData[{

Cell["Global`Z", "Print", "PrintUsage",
 CellChangeTimes->{3.728977892498336*^9},
 CellTags->"Info2663728981492-9181623",
 CellID->1735986504,ExpressionUUID->"8b37f71b-9bc8-4c6b-a966-48e42cfdf8b6"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "Z", "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTensor`Dagger[$CellContext`Z],
          Editable->False], "^=", "Z"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DefInfo", "[", "Z", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "Z", "]"}], "^=", 
         RowBox[{"{", "M3", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "Z", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"M3", ",", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "Z", "]"}], "^=", "\<\"Z\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "Z", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"AnyIndices", "[", 
           InterpretationBox[
            StyleBox["\[DoubleStruckCapitalT]M3",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`TangentM3,
            Editable->False], "]"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "Z", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "Z", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`Z],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977892524729*^9},
 CellTags->"Info2663728981492-9181623",
 CellID->1012344586,ExpressionUUID->"bf829cfa-6dbb-4861-8773-7a3aefbd4dba"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The tensor is given no symmetry. By default we return the identity group:\
\>", "MathCaption",ExpressionUUID->"64da12c3-3e4e-4553-8e4d-699d0b9dd4ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "[", "Z", "]"}]], "Input",
 CellLabel->
  "In[267]:=",ExpressionUUID->"11ed7705-3f7a-47e5-a176-de2207f51c74"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", "]"}]}], "]"}]], "Output",
 CellChangeTimes->{3.728977892680461*^9},
 CellLabel->"Out[267]=",
 CellID->2110005368,ExpressionUUID->"d6204b88-6155-4d78-a651-9589f277ada0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "[", 
  RowBox[{"Z", "[", "]"}], "]"}]], "Input",
 CellLabel->
  "In[268]:=",ExpressionUUID->"6ed271e6-2d44-4b7f-9aab-7280d936bcc7"],

Cell[BoxData[
 RowBox[{"StrongGenSet", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"GenSet", "[", "]"}]}], "]"}]], "Output",
 CellChangeTimes->{3.728977892807494*^9},
 CellLabel->"Out[268]=",
 CellID->1462757065,ExpressionUUID->"dd655c45-e0bf-4bec-84be-2427894cf6ac"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Now make it symmetric for any number of indices:", "MathCaption",ExpressionUUID->"23d0c9d9-168f-4b4a-b6f5-e6472fa42c9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryGroupOfTensor", "[", 
   RowBox[{"Z", "[", "inds___", "]"}], "]"}], "^:=", 
  RowBox[{"Symmetric", "[", 
   RowBox[{"Range", "[", 
    RowBox[{"Length", "[", 
     RowBox[{"{", "inds", "}"}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->
  "In[269]:=",ExpressionUUID->"611f91bc-969d-4a77-bf4b-c0da37358482"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "[", 
  RowBox[{"Z", "[", "]"}], "]"}]], "Input",
 CellLabel->
  "In[270]:=",ExpressionUUID->"7a70475a-99e6-40bc-bc9b-6ad0244aaed7"],

Cell[BoxData[
 RowBox[{"Symmetric", "[", 
  RowBox[{"{", "}"}], "]"}]], "Output",
 CellChangeTimes->{3.7289778929727707`*^9},
 CellLabel->"Out[270]=",
 CellID->165200599,ExpressionUUID->"56378924-4e4f-4098-a161-52e53ad92f97"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "[", 
  RowBox[{"Z", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[271]:=",ExpressionUUID->"c4949cd5-aee2-45f2-afb9-e3010500ed40"],

Cell[BoxData[
 RowBox[{"Symmetric", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], "]"}]], "Output",
 CellChangeTimes->{3.728977893103332*^9},
 CellLabel->"Out[271]=",
 CellID->1977595469,ExpressionUUID->"8491ec76-bc40-40c1-b887-5bccc693370b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetryGroupOfTensor", "[", 
  RowBox[{"Z", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[272]:=",ExpressionUUID->"b8ef38d1-a6ac-418c-bf18-3d7aaddbffb6"],

Cell[BoxData[
 RowBox[{"Symmetric", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Output",
 CellChangeTimes->{3.728977893252224*^9},
 CellLabel->"Out[272]=",
 CellID->842642864,ExpressionUUID->"cd5ebad8-825d-4576-85ed-dd14ce98fbcf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clean up:", "MathCaption",ExpressionUUID->"2e9d9408-7cc3-455e-b0c2-f382085b96da"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefTensor", "[", "Z", "]"}]], "Input",
 CellLabel->
  "In[273]:=",ExpressionUUID->"d701fdee-130c-48f5-bfa9-7a7f34e3dcd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Z"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Z],
  Editable->False]], "Print",
 CellChangeTimes->{3.72897789336397*^9},
 CellLabel->"During evaluation of In[273]:=",
 CellID->1791446930,ExpressionUUID->"f03f6b90-fbe8-43bd-a0d9-33862eede570"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "inds", "]"}]], "Input",
 CellLabel->
  "In[274]:=",ExpressionUUID->"6ca2900a-4c7f-4594-98ef-910509f5c712"]
}, Open  ]],

Cell[TextData[{
 "In case you need symmetries other  than total symmetry or total \
antisymmetry, you will need to use the general notation for permutation \
groups (see ",
 StyleBox["xPermDoc.nb",
  FontFamily->"Courier"],
 " for a description)."
}], "Text",ExpressionUUID->"e71a8723-3263-4bf9-ab2d-372e7953824e"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.10. Clean up", "Subsection",ExpressionUUID->"f35a0194-1aa1-46e0-a2f9-7b2af9e581fa"],

Cell[TextData[{
 "It is good practice in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", and in all of ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 ", to remove those symbols that are no longer needed. This makes the symbols \
available for other uses, and also frees memory that may be used to store \
properties of those symbols.\nThis documentation notebook is quite large, and \
hence at the end of some sections we will have \[OpenCurlyDoubleQuote]Clean \
up\[CloseCurlyDoubleQuote] sections removing symbols used in examples in the \
previous sections."
}], "Text",ExpressionUUID->"f3ad4d17-e94d-4713-a7e2-d0f8e9f17935"],

Cell[CellGroupData[{

Cell["Undefine tensors:", "MathCaption",ExpressionUUID->"399f8699-c3cc-44b3-a2e0-64736fb7b37f"],

Cell[CellGroupData[{

Cell[BoxData["$Tensors"], "Input",
 CellLabel->
  "In[275]:=",ExpressionUUID->"f6fe5140-dea6-415a-a0c0-a1156ed9cb59"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"T", ",", "v", ",", "r", ",", "S"}], "}"}]], "Output",
 CellChangeTimes->{3.728977896905465*^9},
 CellLabel->"Out[275]=",
 CellID->1584742292,ExpressionUUID->"37d12554-7e46-4621-9f53-f7d8b1e0793e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefTensor", "/@", "%"}], ";"}]], "Input",
 CellLabel->
  "In[276]:=",ExpressionUUID->"470f14bf-c925-403c-9055-0f1752574e97"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778970201883`*^9},
 CellLabel->"During evaluation of In[276]:=",
 CellID->1671511550,ExpressionUUID->"bbcf6719-8d9a-4f1d-b4bc-b363589df69f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "v"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`v],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977897040285*^9},
 CellLabel->"During evaluation of In[276]:=",
 CellID->1861034443,ExpressionUUID->"104d60d0-4c44-495e-ae8d-424a96a8547e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "r"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`r],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977897057859*^9},
 CellLabel->"During evaluation of In[276]:=",
 CellID->306564946,ExpressionUUID->"0603fbf9-f633-4904-b585-769e13837363"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`S],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977897074111*^9},
 CellLabel->"During evaluation of In[276]:=",
 CellID->623778269,ExpressionUUID->"5523e2f4-1511-42f4-ae27-ebcc4277cf2d"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We cannot yet undefine the manifold M3 because other geometric structures (in \
this case an inner vector bundle) are defined on it. We call them \
\[OpenCurlyDoubleQuote]visitors\[CloseCurlyDoubleQuote] of the \
\[OpenCurlyDoubleQuote]host\[CloseCurlyDoubleQuote] structure, the manifold \
M3 in this case.\
\>", "MathCaption",ExpressionUUID->"d25fb823-4acb-427a-92a2-b9b7348d71c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"UndefManifold", "[", "M3", "]"}], "]"}]], "Input",
 CellLabel->
  "In[277]:=",ExpressionUUID->"12570b0e-504c-4e69-8a89-5d8f2024ca5e"],

Cell[BoxData[
 TemplateBox[{
  "General", "noundef", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Symbol\\\\\\\"\\\"}]\\) \
\\!\\(\\*RowBox[{\\\"M3\\\"}]\\) cannot be undefined because \
\\!\\(\\*RowBox[{\\\"\\\\\\\"it has visitors\\\\\\\"\\\"}]\\).\"", 2, 277, 30,
    19253573948027831207, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.728977897217198*^9},
 CellLabel->"During evaluation of In[277]:=",
 CellID->1973686076,ExpressionUUID->"0cea6aed-94ef-44f7-85d0-83ba02f74565"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Undefine the inner vbundle explicitly:", "MathCaption",ExpressionUUID->"ce746ea1-b3f1-444b-9406-bed61163aebe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefVBundle", "[", "InnerC", "]"}]], "Input",
 CellLabel->
  "In[278]:=",ExpressionUUID->"ad50ddba-0e40-4de4-a129-4c668b7df482"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["InnerC\[Dagger]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC\[Dagger],
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "conjugated vbundle", 
   " ", $CellContext`InnerC\[Dagger]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778975046177`*^9},
 CellLabel->"During evaluation of In[278]:=",
 CellID->1709467770,ExpressionUUID->"cdf7af0e-9284-423d-ae18-328219308bd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["InnerC",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`InnerC],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778976230783`*^9},
 CellLabel->"During evaluation of In[278]:=",
 CellID->1988580824,ExpressionUUID->"2c9db178-cfb9-447e-aef8-8e22dab60246"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Now we can undefine the manifolds:", "MathCaption",ExpressionUUID->"e03a86d6-80c1-4fb6-a2d0-5dd23d7c5510"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "S2", "]"}]], "Input",
 CellLabel->
  "In[279]:=",ExpressionUUID->"7bf774fe-644d-4207-93c7-e7de4221511b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentS2,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentS2],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977898043635*^9},
 CellLabel->"During evaluation of In[279]:=",
 CellID->789910707,ExpressionUUID->"ab857645-62ec-40cc-9e08-a5bb4f418850"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`S2],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977898066807*^9},
 CellLabel->"During evaluation of In[279]:=",
 CellID->285346795,ExpressionUUID->"da4651e4-a813-4773-b8dd-6eefcd6914ad"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefManifold", "[", "M3", "]"}]], "Input",
 CellLabel->
  "In[280]:=",ExpressionUUID->"d06634ee-92e5-474e-a3f1-a4c25d21fa70"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M3",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM3,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM3],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289778984385033`*^9},
 CellLabel->"During evaluation of In[280]:=",
 CellID->492599814,ExpressionUUID->"a48e0cb1-6e38-467e-8c27-fabfae5bc59c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M3"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M3],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977898461198*^9},
 CellLabel->"During evaluation of In[280]:=",
 CellID->575614713,ExpressionUUID->"83f604d3-0a00-436d-9637-383d92a0f904"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["And the parameter:", "MathCaption",ExpressionUUID->"ba377a37-bed2-41da-b013-76cb48ccc3a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefParameter", "[", "time", "]"}]], "Input",
 CellLabel->
  "In[281]:=",ExpressionUUID->"3fea85b3-4646-4287-afc8-ebe1f75c26bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefParameter", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parameter\"\>", "\[InvisibleSpace]", "\<\" \"\>",
    "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["time",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`time,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefParameter, ": Undefined ", "parameter", 
   " ", $CellContext`time],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977898581707*^9},
 CellLabel->"During evaluation of In[281]:=",
 CellID->2090135303,ExpressionUUID->"311ad552-186b-43a2-88e4-c83072ef668b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Our session is empty again:", "MathCaption",ExpressionUUID->"d925ef7f-fc5c-49c6-86bf-1742ab62a8fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellLabel->
  "In[282]:=",ExpressionUUID->"560455fe-a648-4382-b925-9c27aa88e4f2"],

Cell["Global`$UseTextSearchQ", "Print", "PrintUsage",
 CellChangeTimes->{3.7289778987059317`*^9},
 CellTags->"Info2823728981498-9181623",
 CellID->366539895,ExpressionUUID->"944a01b4-5f58-4e66-a631-2beb8f017d35"]
}, Open  ]]
}, Open  ]],

Cell["\<\
TODO: Where are those two symbols coming from? They should not be there...\
\>", "Text",ExpressionUUID->"37ab47cf-a37b-466f-872f-1400001b4863"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. Canonicalization", "Section",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.7286627354220657`*^9, 3.728662748172317*^9}, {
  3.728664037492599*^9, 3.72866403885896*^9}, {3.7286704747855062`*^9, 
  3.728670480415387*^9}, {3.728670889883876*^9, 3.728670893540101*^9}, {
  3.728673410238123*^9, 3.728673425886174*^9}, {3.7289761721698513`*^9, 
  3.7289761765432653`*^9}, {3.728976277988899*^9, 3.728976287866613*^9}, {
  3.728976341130004*^9, 3.728976342960009*^9}, {3.72897639317553*^9, 
  3.728976399469426*^9}, {3.728976517721738*^9, 3.7289765237113934`*^9}},
 FontSize->18,
 FontColor->GrayLevel[0],
 CellTags->{"S5.18.1", "1.4"},
 CellID->1330943070,ExpressionUUID->"e07ebc50-8899-4702-bbbe-f4d58d3ca5cc"],

Cell[CellGroupData[{

Cell["4.1. Basics", "Subsection",ExpressionUUID->"27be6501-297f-4c01-a07b-643e49a7ce19"],

Cell[TextData[{
 "In any calculation it is essential to bring all tensors and products of \
tensors down to a canonical form, in order to be compared. This is done by \
the function ",
 StyleBox["ToCanonical",
  FontFamily->"Courier"],
 ", probably the most important ingredient of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", and certainly the most complicated function.\nDo not confuse the \
canonicalization proces, by which an expression is brought to a canonical \
form (not necessarily simple) from the simplification process, by which an \
expression is rewritten as an equivalent, but simpler form. The former is \
uniquely defined once the canonical form of every sintactycally correct \
expression is decided. The latter is largely subjective, and generally more \
difficult to work with. Fortunately ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a very good algorithm for simplification (",
 StyleBox["Simplify",
  FontFamily->"Courier"],
 "). This is one of the main reasons to avoid introducing TensorTimes or \
TensorPlus, which would force us to build a new TensorSimplify, and another \
strong reason to use abstract index notation. In ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " we have defined a command ",
 StyleBox["Simplification",
  FontFamily->"Courier"],
 ", which simply applies ",
 StyleBox["ToCanonical",
  FontFamily->"Courier"],
 " first, and then ",
 StyleBox["Simplify",
  FontFamily->"Courier"],
 ".\nThe hardest part of the process (the canonicalization of indices) is \
performed by the companion package ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 ". The canonicalization code is duplicated in that package: there is first a \
pure ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " version of the code, and then there is an external C-executable, which is \
much faster, but requires a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection, which does not work for some operating systems. Which code is \
used is controlled with several switches, as we will see later on."
}], "Text",ExpressionUUID->"0fc444e8-cd2c-4c05-a2ac-fa11fa4967e1"],

Cell[TextData[{
 StyleBox[ButtonBox["ToCanonical",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ToCanonical.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Canonicalization of indices of an expression\n", "Text"],
 StyleBox[ButtonBox["Simplification",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Simplification.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t", "DisplayMath"],
 StyleBox["Apply ", "Text"],
 StyleBox["ToCanonical", "Text",
  FontFamily->"Courier"],
 StyleBox[" and then ", "Text"],
 StyleBox["Simplify", "Text",
  FontFamily->"Courier"]
}], "DefinitionBox",ExpressionUUID->"a4853172-1344-4f00-a08e-1d0f978a6c6b"],

Cell["Simplification functions", "Text",ExpressionUUID->"ae327cb7-0805-4d8f-a39a-36c11b296e46"],

Cell[CellGroupData[{

Cell["Define a manifold and some tensors fields:", "MathCaption",ExpressionUUID->"86ecd186-81dc-4d3f-b9be-378a3ba87e08"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M3", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h",
      ",", "i", ",", "j"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[283]:=",ExpressionUUID->"9528b0dc-60db-4da0-a1f8-7bad3c6faab4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289779077202787`*^9},
 CellLabel->"During evaluation of In[283]:=",
 CellID->985284070,ExpressionUUID->"ba18926e-63ab-46ea-bd00-bd15d6d59c87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289779077382593`*^9},
 CellLabel->"During evaluation of In[283]:=",
 CellID->422962473,ExpressionUUID->"d0c3d622-7ff1-4eef-8750-2f106d0d466b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", "M3", ",", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[284]:=",ExpressionUUID->"41ba7f86-db7d-4177-bd90-7743bf5e9519"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[-$CellContext`a, -$CellContext`b, -$CellContext`c], ". ", 
   ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977907888639*^9},
 CellLabel->"During evaluation of In[284]:=",
 CellID->559412141,ExpressionUUID->"f96744ac-c004-4ac5-96b7-00ca5d603efd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "M3"}], "]"}]], "Input",
 CellLabel->
  "In[285]:=",ExpressionUUID->"362271f3-1082-489b-a812-99f1a5ed85d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[$CellContext`a, $CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.7289779080213137`*^9},
 CellLabel->"During evaluation of In[285]:=",
 CellID->356447221,ExpressionUUID->"aa088c12-f943-4acb-8d22-b9661ba00c6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M3"}], "]"}]], "Input",
 CellLabel->
  "In[286]:=",ExpressionUUID->"f8413efe-4e9d-4480-9a74-52c66952f1c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977908137731*^9},
 CellLabel->"During evaluation of In[286]:=",
 CellID->1476551864,ExpressionUUID->"4573a8e6-df04-4851-82a3-cf83084f370b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Canonical form of the totally antisymmetric tensor ",
 StyleBox["U",
  FontFamily->"Courier"],
 ": sort indices in alphabetical order:"
}], "MathCaption",ExpressionUUID->"4123c80d-f87b-4825-ba5d-1a693af48dbf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", " ", 
  RowBox[{"U", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "d"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], " ", "]"}]], "Input",
 CellLabel->
  "In[287]:=",ExpressionUUID->"f5c1bc7a-1e28-48db-a0ad-afefe3521473"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"U", 
       StyleBox[GridBox[{
          {" ", " ", " "},
          {"a", "b", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`U[-$CellContext`a, -$CellContext`b, -$CellContext`d],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977908408895*^9},
 CellLabel->"Out[287]=",
 CellID->86153516,ExpressionUUID->"ced005e8-4ea8-4813-ba0d-e3039a0f927d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "+", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "a"}]}], "]"}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->
  "In[288]:=",ExpressionUUID->"97fc91d0-dbe0-4991-a802-ba00273cb21f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.72897790889884*^9},
 CellLabel->"Out[288]=",
 CellID->578165334,ExpressionUUID->"3178cd84-80d9-4780-840e-6bf9e9c0b296"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Dummy indices are replaced so that the total number of different dummies is \
minimal:\
\>", "MathCaption",ExpressionUUID->"8b0e0cc6-8067-48ad-9c1d-7adeb12e7a26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "c"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "c"}], "]"}]}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->
  "In[289]:=",ExpressionUUID->"1cf5e7ce-0395-4517-83f9-621717c4b8ed"],

Cell[BoxData[
 RowBox[{"2", " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[$CellContext`a, $CellContext`b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" "},
          {"b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977909121375*^9},
 CellLabel->"Out[289]=",
 CellID->2008749510,ExpressionUUID->"e1be20c2-0433-4c46-98a2-64c9f1bfe34f"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The process of canonicalization is far from trivial (see next section). We \
can monitor it using ",
 StyleBox["Verbose",
  FontFamily->"Courier"],
 " options."
}], "Text",ExpressionUUID->"51d3dc2d-1f73-404e-991c-653ffde168ef"],

Cell[TextData[{
 StyleBox[ButtonBox["Verbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Verbose.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["\t\t\t\t", "DisplayMath"],
 StyleBox["Gives a real-time report of the tensorial canonicalization process\
\n", "Text"],
 StyleBox["TimeVerbose\t\t\t\t", "DisplayMath"],
 StyleBox["Gives timings of several canonicalization steps\n", "Text"],
 StyleBox["xPermVerbose\t\t\t\t", "DisplayMath"],
 StyleBox["Gives a real-time report of the permutation canonicalization \
process", "Text"]
}], "DefinitionBox",
 CellChangeTimes->{{3.7289779174249477`*^9, 
  3.728977919327373*^9}},ExpressionUUID->"4ff7dfea-d01e-40d7-85e9-\
92d66ceb3358"],

Cell[TextData[{
 "Verbosing options of ",
 StyleBox["ToCanonical",
  FontFamily->"Courier"],
 "."
}], "Text",ExpressionUUID->"03367d2e-3fd7-494d-8711-ac60fa5e1ecd"],

Cell[CellGroupData[{

Cell[TextData[{
 "These three cells show the output of the three ",
 StyleBox["Verbose",
  FontFamily->"Courier"],
 " options of ",
 StyleBox["ToCanonical",
  FontFamily->"Courier"],
 " in a simple case. The output of ",
 StyleBox["xPermVerbose",
  FontFamily->"Courier"],
 " can be very large even for small expressions. We do not use the external \
executable because there is not verbose information from it:"
}], "MathCaption",ExpressionUUID->"e92c0676-9ea4-404d-bd5a-65b63e06582e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"CanonicalPerm", ",", 
   RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->
  "In[290]:=",ExpressionUUID->"a467c9e8-2413-4cb1-b28b-884dd2a2a75a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MathLink", "\[Rule]", "False"}], ",", 
   RowBox[{"TimeVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"OrderedBase", "\[Rule]", "True"}]}], "}"}]], "Output",
 CellChangeTimes->{3.728977909255715*^9},
 CellLabel->"Out[290]=",
 CellID->462600083,ExpressionUUID->"25b1023d-bb6c-438f-9caa-2de7678b0675"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"U", "[", 
     RowBox[{"b", ",", "c", ",", "a"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], ",", 
   RowBox[{"TimeVerbose", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[291]:=",ExpressionUUID->"df9663b7-68f8-44d2-a111-46dabfd5ed75"],

Cell[BoxData[
 TemplateBox[{
  "OptionValue", "nodef", 
   "\"Unknown option \
\\!\\(\\*RowBox[{\\\"\\\\\\\"TimeVerbose\\\\\\\"\\\"}]\\) for \
\\!\\(\\*RowBox[{\\\"RightCosetRepresentative\\\"}]\\).\"", 2, 291, 31, 
   19253573948027831207, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.728977909388124*^9},
 CellLabel->"During evaluation of In[291]:=",
 CellID->1028792841,ExpressionUUID->"22d685c6-29dd-496a-a846-88629da5daf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Free algorithm applied in \"\>", "\[InvisibleSpace]", 
   "0.009223000000000425`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm["Free algorithm applied in ", 0.009223000000000425, " secs."],
  Editable->False]], "Print",
 CellChangeTimes->{3.728977909467868*^9},
 CellLabel->"During evaluation of In[291]:=",
 CellID->1530436690,ExpressionUUID->"21d29b50-cad9-47ce-9775-2d17f3c4e66c"],

Cell[BoxData[
 TemplateBox[{
  "OptionValue", "nodef", 
   "\"Unknown option \
\\!\\(\\*RowBox[{\\\"\\\\\\\"TimeVerbose\\\\\\\"\\\"}]\\) for \
\\!\\(\\*RowBox[{\\\"DoubleCosetRepresentative\\\"}]\\).\"", 2, 291, 32, 
   19253573948027831207, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.728977909507205*^9},
 CellLabel->"During evaluation of In[291]:=",
 CellID->1637808711,ExpressionUUID->"5a44fe39-3612-4fd7-8ad9-058c1dd8927c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dummy algorithm applied in \"\>", "\[InvisibleSpace]", 
   "0.007001000000000701`", "\[InvisibleSpace]", "\<\" secs.\"\>"}],
  SequenceForm["Dummy algorithm applied in ", 0.007001000000000701, " secs."],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.7289779095209217`*^9},
 CellLabel->"During evaluation of In[291]:=",
 CellID->205618531,ExpressionUUID->"bde5710b-d9f1-4b13-abb0-0cd668c66e91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"U", 
        StyleBox[GridBox[{
           {"a", "c", "b"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`U[$CellContext`a, $CellContext`c, $CellContext`b],
    Editable->False]}], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" "},
          {"b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`b],
   Editable->False]}]], "Output",
 CellChangeTimes->{3.728977909590954*^9},
 CellLabel->"Out[291]=",
 CellID->529462494,ExpressionUUID->"abf6fbcc-a539-4231-a624-bcdffc4488af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"U", "[", 
     RowBox[{"b", ",", "c", ",", "a"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], ",", 
   RowBox[{"Verbose", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[292]:=",ExpressionUUID->"14565ad5-3787-4fce-9650-543266d8ea7c"],

Cell[CellGroupData[{

Cell[BoxData["\<\"***********************************************************\
\"\>"], "Print",
 CellChangeTimes->{3.7289779097215233`*^9},
 CellLabel->"During evaluation of In[292]:=",
 CellID->1651387137,ExpressionUUID->"b4c221b4-4f7b-49b5-825f-3eb0399bdc57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ToCanonical:: object: \"\>", "\[InvisibleSpace]", 
   TagBox[
    TooltipBox[
     UnderscriptBox[
      RowBox[{
       RowBox[{"(", 
        TagBox[
         TooltipBox[
          UnderscriptBox["Times", "_"],
          RowBox[{"\"VerbatimProduct\"", "[", "Times", "]"}]],
         #& ], ")"}], "[", 
       RowBox[{
        TagBox[
         TooltipBox[
          UnderscriptBox[
           InterpretationBox[
            StyleBox[GridBox[{
               {"v", 
                StyleBox[GridBox[{
                   {" "},
                   {"b"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`v[-$CellContext`b],
            Editable->False], "_"],
          RowBox[{"\"Object\"", "[", 
            RowBox[{
              InterpretationBox[
               StyleBox[
                GridBox[{{"v", 
                   StyleBox[
                    
                    GridBox[{{" "}, {"b"}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    9]}}, ColumnSpacings -> 0.05, RowAlignments -> Center], 
                AutoSpacing -> False, ShowAutoStyles -> False], 
               $CellContext`v[-$CellContext`b], Editable -> False], ",", 
              RowBox[{"{", 
                RowBox[{"Tensor", ",", "1", ",", "v"}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{
                    RowBox[{"-", "b"}]}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   xAct`xTensor`IndexList[-$CellContext`b], Editable -> 
                   False], ",", 
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{
                    RowBox[{"-", "b"}]}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   xAct`xTensor`IndexList[-$CellContext`b], Editable -> 
                   False], ",", 
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   xAct`xTensor`IndexList[], Editable -> False], ",", 
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   xAct`xTensor`IndexList[], Editable -> False], ",", 
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False]}], ",", "Null"}], "}"}]}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   xAct`xTensor`IndexList[{-$CellContext`TangentM3, Null}], 
                   Editable -> False]}], "}"}]}], "]"}]],
         #& ], ",", 
        TagBox[
         TooltipBox[
          UnderscriptBox[
           InterpretationBox[
            StyleBox[GridBox[{
               {"U", 
                StyleBox[GridBox[{
                   {"b", "c", "a"},
                   {" ", " ", " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`U[$CellContext`b, $CellContext`c, $CellContext`a],
            Editable->False], "_"],
          RowBox[{"\"Object\"", "[", 
            RowBox[{
              InterpretationBox[
               StyleBox[
                GridBox[{{"U", 
                   StyleBox[
                    
                    GridBox[{{"b", "c", "a"}, {" ", " ", " "}}, RowSpacings -> 
                    0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                 ColumnSpacings -> 0.05, RowAlignments -> Center], 
                AutoSpacing -> False, ShowAutoStyles -> False], 
               $CellContext`U[$CellContext`b, $CellContext`c, $CellContext`a],
                Editable -> False], ",", 
              RowBox[{"{", 
                RowBox[{"Tensor", ",", "6", ",", "U"}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{"b", ",\[ThinSpace]", "c", ",\[ThinSpace]", "a"}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   
                   xAct`xTensor`IndexList[$CellContext`b, $CellContext`c, \
$CellContext`a], Editable -> False], ",", 
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{"a", ",\[ThinSpace]", "b", ",\[ThinSpace]", "c"}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   
                   xAct`xTensor`IndexList[$CellContext`a, $CellContext`b, \
$CellContext`c], Editable -> False], ",", 
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   xAct`xTensor`IndexList[], Editable -> False], ",", 
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   xAct`xTensor`IndexList[], Editable -> False], ",", 
                  InterpretationBox[
                   StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False], ",", "Null"}], "}"}], ",\[ThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False], ",", "Null"}], "}"}], ",\[ThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False], ",", "Null"}], "}"}]}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                   xAct`xTensor`IndexList[{$CellContext`TangentM3, 
                    Null}, {$CellContext`TangentM3, 
                    Null}, {$CellContext`TangentM3, Null}], Editable -> 
                   False]}], "}"}]}], "]"}]],
         #& ]}], "]"}], "_"],
     RowBox[{"\"Object\"", "[", 
       RowBox[{
         RowBox[{
           RowBox[{"(", 
             TagBox[
              TooltipBox[
               UnderscriptBox["Times", "_"], 
               RowBox[{"\"VerbatimProduct\"", "[", "Times", "]"}]], #& ], 
             ")"}], "[", 
           RowBox[{
             TagBox[
              TooltipBox[
               UnderscriptBox[
                InterpretationBox[
                 StyleBox[
                  GridBox[{{"v", 
                    StyleBox[
                    
                    GridBox[{{" "}, {"b"}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    9]}}, ColumnSpacings -> 0.05, RowAlignments -> Center], 
                  AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`v[-$CellContext`b], Editable -> False], "_"], 
               RowBox[{"\"Object\"", "[", 
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    GridBox[{{"v", 
                    StyleBox[
                    
                    GridBox[{{" "}, {"b"}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    9]}}, ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`v[-$CellContext`b], Editable -> False], ",", 
                   
                   RowBox[{"{", 
                    RowBox[{"Tensor", ",", "1", ",", "v"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{
                    RowBox[{"-", "b"}]}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`IndexList[-$CellContext`b], Editable -> 
                    False], ",", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{
                    RowBox[{"-", "b"}]}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`IndexList[-$CellContext`b], Editable -> 
                    False], ",", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`IndexList[], Editable -> False], ",", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`IndexList[], Editable -> False], ",", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False]}], ",", "Null"}], "}"}]}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`IndexList[{-$CellContext`TangentM3, Null}], 
                    Editable -> False]}], "}"}]}], "]"}]], #& ], ",", 
             TagBox[
              TooltipBox[
               UnderscriptBox[
                InterpretationBox[
                 StyleBox[
                  GridBox[{{"U", 
                    StyleBox[
                    
                    GridBox[{{"b", "c", "a"}, {" ", " ", " "}}, RowSpacings -> 
                    0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                   ColumnSpacings -> 0.05, RowAlignments -> Center], 
                  AutoSpacing -> False, ShowAutoStyles -> False], 
                 $CellContext`U[$CellContext`b, $CellContext`c, \
$CellContext`a], Editable -> False], "_"], 
               RowBox[{"\"Object\"", "[", 
                 RowBox[{
                   InterpretationBox[
                    StyleBox[
                    GridBox[{{"U", 
                    StyleBox[
                    
                    GridBox[{{"b", "c", "a"}, {" ", " ", " "}}, RowSpacings -> 
                    0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`U[$CellContext`b, $CellContext`c, \
$CellContext`a], Editable -> False], ",", 
                   RowBox[{"{", 
                    RowBox[{"Tensor", ",", "6", ",", "U"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{"b", ",\[ThinSpace]", "c", ",\[ThinSpace]", "a"}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    
                    xAct`xTensor`IndexList[$CellContext`b, $CellContext`c, \
$CellContext`a], Editable -> False], ",", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{"a", ",\[ThinSpace]", "b", ",\[ThinSpace]", "c"}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    
                    xAct`xTensor`IndexList[$CellContext`a, $CellContext`b, \
$CellContext`c], Editable -> False], ",", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`IndexList[], Editable -> False], ",", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`IndexList[], Editable -> False], ",", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False], ",", "Null"}], "}"}], ",\[ThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False], ",", "Null"}], "}"}], ",\[ThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False], ",", "Null"}], "}"}]}], 
                    StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    
                    xAct`xTensor`IndexList[{$CellContext`TangentM3, 
                    Null}, {$CellContext`TangentM3, 
                    Null}, {$CellContext`TangentM3, Null}], Editable -> 
                    False]}], "}"}]}], "]"}]], #& ]}], "]"}], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"Times", ",", 
                 RowBox[{"{", 
                   RowBox[{"Tensor", ",", "Tensor"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", "6", "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"Times", ",", 
                 RowBox[{"{", 
                   RowBox[{"v", ",", "U"}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              StyleBox[
               RowBox[{
                 StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                 RowBox[{
                   RowBox[{"-", "b"}], ",\[ThinSpace]", "b", ",\[ThinSpace]", 
                   "c", ",\[ThinSpace]", "a"}], 
                 StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], AutoSpacing -> 
               False, ShowAutoStyles -> False], 
              
              xAct`xTensor`IndexList[-$CellContext`b, $CellContext`b, \
$CellContext`c, $CellContext`a], Editable -> False], ",", 
             InterpretationBox[
              StyleBox[
               RowBox[{
                 StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                 RowBox[{"a", ",\[ThinSpace]", "c"}], 
                 StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], AutoSpacing -> 
               False, ShowAutoStyles -> False], 
              xAct`xTensor`IndexList[$CellContext`a, $CellContext`c], 
              Editable -> False], ",", 
             InterpretationBox[
              StyleBox[
               RowBox[{
                 StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                 RowBox[{
                   RowBox[{"-", "b"}], ",\[ThinSpace]", "b"}], 
                 StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], AutoSpacing -> 
               False, ShowAutoStyles -> False], 
              xAct`xTensor`IndexList[-$CellContext`b, $CellContext`b], 
              Editable -> False], ",", 
             InterpretationBox[
              StyleBox[
               RowBox[{
                 StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                 RowBox[{}], 
                 StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], AutoSpacing -> 
               False, ShowAutoStyles -> False], 
              xAct`xTensor`IndexList[], Editable -> False], ",", 
             InterpretationBox[
              StyleBox[
               RowBox[{
                 StyleBox["{", FontColor -> RGBColor[0, 0, 1]], 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False]}], ",", "Null"}], "}"}], 
                   ",\[ThinSpace]", 
                   RowBox[{"{", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    "\[DoubleStruckCapitalT]M3", AutoSpacing -> False, 
                    ShowAutoStyles -> False], $CellContext`TangentM3, 
                    Editable -> False], ",", "Null"}], "}"}]}], 
                 StyleBox["}", FontColor -> RGBColor[0, 0, 1]]}], AutoSpacing -> 
               False, ShowAutoStyles -> False], 
              
              xAct`xTensor`IndexList[{-$CellContext`TangentM3, 
                Null}, {$CellContext`TangentM3, Null}], Editable -> False]}], 
           "}"}]}], "]"}]],
    #& ]}],
  SequenceForm["ToCanonical:: object: ", 
   xAct`xTensor`Private`Object[
    xAct`xTensor`Private`VerbatimProduct[Times][
     xAct`xTensor`Private`Object[
      $CellContext`v[-$CellContext`b], {
      xAct`xTensor`Tensor, 1, $CellContext`v}, {
       xAct`xTensor`IndexList[-