(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    397115,      12052]
NotebookOptionsPosition[    306722,       9728]
NotebookOutlinePosition[    358207,      10972]
CellTagsIndexPosition[    356654,      10925]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xTensorRefGuide",
 FontColor->RGBColor[1, 0, 0]]], "Title"],

Cell[TextData[StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a",
 FontColor->RGBColor[0, 0, 1]]], "Subtitle"],

Cell["\<\
\tjose@xact.es
\thttp://www.xact.es
\thttp://groups.google.com/group/xAct/\
\>", "Subsubtitle"],

Cell[TextData[{
 "This the Reference Guide of the package ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", now in version 1.1.0. It is a quick recollection of all commands in the \
package, with their mutual relations and links to individual help pages. \
There are no examples: see the notebook ",
 StyleBox["xTensorDoc.nb",
  FontFamily->"Courier"],
 " for an introduction to the system. There are no formulas: see the ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"L", 
    StyleBox[
     AdjustmentBox["A",
      BoxBaselineShift->-0.2,
      BoxMargins->{{-0.36, -0.1}, {0, 0}}],
     FontSize->Smaller], "T", 
    AdjustmentBox["E",
     BoxBaselineShift->0.5,
     BoxMargins->{{-0.075, -0.085}, {0, 0}}], "X"}]]]],
 " document ",
 StyleBox["xTensorMaths",
  FontFamily->"Courier"],
 " for the mathematics underlying the system.\n\nFunctions still to be \
documented are marked with TODOCUMENT.\n\nPlease report  errors, omissions, \
suggestions or comments to the author (jose@xact.es). Any kind of help is \
welcome!"
}], "Text"],

Cell[CellGroupData[{

Cell["0. Loading", "Section",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1],
 CellTags->"Loading"],

Cell[TextData[{
 "The package ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is installed under the directory xAct/ containing all ",
 StyleBox["xAct`",
  FontFamily->"Courier"],
 " packages. This directory can be installed anywhere and loaded into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " giving the full path of installation. However, there are two recommended \
places for installation of add-ons in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":\n\t- For a single-user installation use:\n\t\t- Linux:    \
$HOME/.Mathematica/Applications/\n\t\t- Windows:    C:\\Documents and \
Settings\\USER\\Program Data\\Mathematica\\Applications\\\n\t\t- Mac:    \
/Users/USER/Library/Mathematica/Applications/\n\t- For a system-wide \
installation use:\n\t\t- Linux:    /usr/share/Mathematica/Applications/\n\t\t\
- Windows:    C:\\Documents and Settings\\All Users\\Program \
Data\\Mathematica\\Applications\\\n\t\t- Mac:    \
/Library/Mathematica/Applications/\nUsing one of these directories there is \
no need to configure any path.\n\t\t\nThe loaded version of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is contained in the global variable ",
 StyleBox["xAct`xTensor`",
  FontFamily->"Courier"],
 StyleBox[ButtonBox["$Version",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Version.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " itself loads the package ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " of manipulations of large groups of permutations. The minimum version of \
",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " required is given by the variable ",
 StyleBox[ButtonBox["$xPermVersionExpected",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$xPermVersionExpected.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The loaded version of ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " is given by ",
 StyleBox["xAct`xPerm`$Version",
  FontFamily->"Courier"],
 ".\n\nIf the variable ",
 StyleBox["xAct`xTensor`",
  FontFamily->"Courier"],
 StyleBox[ButtonBox["$ReadingVerbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ReadingVerbose.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " is defined and has value ",
 StyleBox["True",
  FontFamily->"Courier"],
 " before loading the package, then several messages are printed while \
reading the package. This can be used to debug the input file in case there \
are errors at that point.\n\n",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is free software. It is copyrighted by the author (JMM) under the General \
Public License (see the file gpl.txt that you should have received along with \
this file, and in particular the ouptut of ",
 StyleBox["xAct`xTensor`",
  FontFamily->"Courier"],
 StyleBox[ButtonBox["Disclaimer",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Disclaimer.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["[]",
  FontFamily->"Courier"],
 ")."
}], "Text",
 CellTags->"Loading"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1. Symbols and types",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->18,
 CellTags->"Symbols and types"],

Cell[CellGroupData[{

Cell["1.1. Type information: symbols", "Subsection",
 CellTags->"Symbols and types"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is a basically untyped system (except for the primitive types), in which \
any symbol can stand for every type of object. Symbolic tensor calculus is \
more naturally developed in a typed system, and hence ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " needs to start constructing type-declaration infrastructure."
}], "Text"],

Cell[TextData[{
 "There are three primitive types of values in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": symbols (head ",
 StyleBox["Symbol",
  FontFamily->"Courier"],
 "), strings (head ",
 StyleBox["String",
  FontFamily->"Courier"],
 ") and numbers (heads ",
 StyleBox["Integer",
  FontFamily->"Courier"],
 ", ",
 StyleBox["Rational",
  FontFamily->"Courier"],
 ", ",
 StyleBox["Real",
  FontFamily->"Courier"],
 " and ",
 StyleBox["Complex",
  FontFamily->"Courier"],
 "). Unfortunatlely it is not possible to define new primitive types. Tensors \
and other types of values must be composite types. What follows in this \
section refers to tensors, but can also be applied to other ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " types of values, to be listed below.\n\nInformation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is associated to symbols only (not to strings, numbers or composite \
expressions as a whole). In ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " we take the following important decision: information on a tensor will be \
associated to a symbol identifying that tensor. This has two important \
consequences:\n\t- Tensors are identified using symbols, and not strings.\n\t\
- We cannot have two different tensors identified by the same symbol, to \
avoid conflicting information.\nThis decision has also two important \
advantages:\n\t- Information on a tensor is only used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when the tensor appears in the expression being evaluated.\n\t- At any \
time we can collect all the information known about a tensor, using ",
 StyleBox["Information",
  FontFamily->"Courier"],
 " (the ",
 StyleBox["?",
  FontFamily->"Courier"],
 " command).\nAs a consequence, ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " implements a simple type-definition system. As we said, this is rather \
alien to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but very useful.\n\t\nThere is a harsh limitation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": an expression can be associated to a symbol if and only if the symbol is \
present in the expression at levels 0 or 1, but no deeper. This leads us to \
introduce a second important decision: symbols with some  ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " type will always appear in the composite expression at level 0; in other \
words, the symbol identifying a tensor will be the head of the tensor, and so \
on: we shall use A[...] rather than, for example, the more natural notation \
Tensor[A][...] suggested by Maeder.\n\nIt could seem reasonable to use \
contexts to separate Tensor`A from Manifold`A or Index`A. This simply means \
using longer names for the objects defined. We could use as well TensorA, \
ManifoldA, IndexA, or perhaps TenA, ManiA, IndA. In ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " we do not force any particular solution, leaving the decision to the user. \
The only general recommendation is using long names for tensors (like \
MaxwellF for the electromagnetic Faraday tensor) and short names (a, b, C, \
etc.) for abstract indices. We will see that tensors can be represented in \
output with an arbitrary string, in particular having different tensors \
printed in the same way, like Riemann and Ricci, both printed as \"R\".\n\nIt \
could also seem reasonable to define tensors as abstract types (arbitrary \
expressions answering to a collection of \"method\" functions), instead of \
fixing a particular structure from the very beginning. However, this would be \
slow for pattern matching. We shall simply try to write code having the \
abstract model in mind. Update 2011: tensors are now not restricted to be \
symbols, to allow for further flexibility."
}], "Text",
 CellTags->"Symbols and types"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2. Valid symbols. Attributes", "Subsection",
 CellTags->{"Symbols and types", "Valid symbols"}],

Cell[TextData[{
 "Copied from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Reference Guide (A.1.2): The name of a symbol must be a sequence of \
letters, letter\[Hyphen]like forms and digits, not starting with a digit. ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " adds a few more restrictions on the symbols that can be used to identify \
tensors and so on. These restrictions are checked by the ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " function ",
 StyleBox[ButtonBox["ValidateSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xCore"}, "ValidateSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", called by all ",
 StyleBox["DefType",
  FontFamily->"Courier"],
 " commands:\n\t1. The symbol is not numeric (checked with ",
 StyleBox["NumericQ",
  FontFamily->"Courier"],
 ").\n\t2. The symbol does not have values (checked with ",
 StyleBox["ValueQ",
  FontFamily->"Courier"],
 ").\n\t3. The symbol does not have a ",
 StyleBox["Locked",
  FontFamily->"Courier"],
 " attribute.\n\t4. The symbol is not already used by ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 ", ",
 StyleBox["xCore`",
  FontFamily->"Courier"],
 " or ",
 StyleBox["ExpressionManipulation`",
  FontFamily->"Courier"],
 ".\n\t5. The symbol is not protected, readprotected or used by ",
 StyleBox["Mathematica.\n",
  FontSlant->"Italic"],
 StyleBox["There is an exception to restriction 5: the capitals C, D, K, N, O \
are used by ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" but are accepted as valid symbols for indices and overloaded \
(that is, without changing their context), issuing a warning message. The \
capitals E and I are numeric and cannot be used, not even as indices.\n\nOnce \
a symbol is used to identify an object, it cannot be used to identify another \
object. We use the function ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[ButtonBox["ValidateSymbolInSession",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ValidateSymbolInSession.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox[" to check whether a symbol is currently being used or not. This \
function is called by all ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DefType",
  FontFamily->"Courier"],
 " commands",
 StyleBox[".\n\nAll ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DefType",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" commands have the option ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[ButtonBox["ProtectNewSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProtectNewSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox[", whose default value is given by the global variable ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[ButtonBox["$ProtectNewSymbols",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ProtectNewSymbols.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox[" (initialized to  ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["False",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["), which allows the user to protect the defined symbol right after \
all its properties have been assigned. This is a security feature, and, if \
used, then any protected symbol must be unprotected (with ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["'s ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Unprotect",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[") before new definitions can be associated to it.",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",
 CellTags->{"Symbols and types", "Valid symbols"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3. Type managing", "Subsection",
 CellTags->{"Symbols and types", "Type managing"}],

Cell[TextData[{
 "As we said, ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " implements its own way to deal with symbol types. It is certainly nor \
ellegant nor efficient, but it is the only way to use upvalues and keep a \
simple input, at the expense of harder patterns. Currently there are the \
following 13 symbol types, whose mathematical meaning of each type will be \
explained in detail in the following sections:\n\n",
 Cell[BoxData[GridBox[{
    {
     StyleBox[
      RowBox[{"Symbol", "  ", "Type"}],
      FontFamily->"Times",
      FontSlant->"Italic"], 
     StyleBox[
      RowBox[{"Q", "-", "function"}],
      FontFamily->"Times",
      FontSlant->"Italic"], 
     StyleBox[
      RowBox[{"Global", " ", "list"}],
      FontFamily->"Times",
      FontSlant->"Italic"], 
     StyleBox["Definition",
      FontFamily->"Times",
      FontSlant->"Italic"], 
     StyleBox["Meaning",
      FontFamily->"Times",
      FontSlant->"Italic"]},
    {
     ButtonBox["ConstantSymbol",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "ConstantSymbol.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["ConstantSymbolQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "ConstantSymbolQ.nb", 
         CharacterEncoding -> "iso8859-1"], None}], 
     ButtonBox["$ConstantSymbols",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$ConstantSymbols.nb", 
         CharacterEncoding -> "iso8859-1"], None}], 
     ButtonBox["DefConstantSymbol",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefConstantSymbol.nb", 
         CharacterEncoding -> "iso8859-1"], None}], 
     StyleBox[
      RowBox[{
      "Constant", " ", "with", " ", "respect", " ", "to", " ", "all", " ", 
       "derivatives"}],
      FontFamily->"Times"]},
    {
     ButtonBox["Parameter",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "Parameter.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["ParameterQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "ParameterQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$Parameters",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$Parameters.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["DefParameter",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefParameter.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     StyleBox[
      RowBox[{"Parametric", " ", "dependency"}],
      FontFamily->"Times"]},
    {
     ButtonBox["Manifold",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "Manifold.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["ManifoldQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "ManifoldQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$Manifolds",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$Manifolds.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["DefManifold",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefManifold.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     StyleBox[
      RowBox[{
       RowBox[{"Smooth", " ", "n"}], "-", 
       RowBox[{"dim", " ", "manifold"}]}],
      FontFamily->"Times"]},
    {
     ButtonBox["Mapping",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "Mapping.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["MappingQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "MappingQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$Mappings",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$Mappings.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["DefMapping",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefMapping.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     StyleBox[
      RowBox[{"Vector", " ", "bundle"}],
      FontFamily->"Times"]},
    {
     ButtonBox["VBundle",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "VBundle.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["VBundleQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "VBundleQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$VBundles",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$VBundles.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["DefVBundle",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefVBundle.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     StyleBox[
      RowBox[{"Mapping", " ", "between", " ", "manifolds"}],
      FontFamily->"Times"]},
    {
     ButtonBox["AbstractIndex",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "AbstractIndex.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["AbstractIndexQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "AbstractIndexQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$AbstractIndices",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$AbstractIndices.nb", 
         CharacterEncoding -> "iso8859-1"], None}], 
     ButtonBox["DefAbstractIndex",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefAbstractIndex.nb", 
         CharacterEncoding -> "iso8859-1"], None}], 
     StyleBox[
      RowBox[{
      "Index", " ", "associated", " ", "to", " ", "a", " ", "vbundle"}],
      FontFamily->"Times"]},
    {
     ButtonBox["Tensor",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "Tensor.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["xTensorQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "xTensorQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$Tensors",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$Tensors.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["DefTensor",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefTensor.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     StyleBox[
      RowBox[{"Tensor", " ", "field", " ", "on", " ", "a", " ", "manifold"}],
      FontFamily->"Times"]},
    {
     ButtonBox["CovD",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "CovD.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["CovDQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "CovDQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$CovDs",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$CovDs.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["DefCovD",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefCovD.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     StyleBox[
      RowBox[{"Connection", " ", "on", " ", "a", " ", "manifold"}],
      FontFamily->"Times"]},
    {
     ButtonBox["Metric",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "Metric.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["MetricQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "MetricQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$Metrics",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$Metrics.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["DefMetric",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefMetric.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     StyleBox[
      RowBox[{"Metric", " ", "tensor", " ", "field"}],
      FontFamily->"Times"]},
    {
     ButtonBox["InertHead",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "InertHead.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["InertHeadQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "InertHeadQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$InertHeads",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$InertHeads.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["DefInertHead",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefInertHead.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     StyleBox[
      RowBox[{"Linear", " ", "operator", " ", "on", " ", "tensors"}],
      FontFamily->"Times"]},
    {
     ButtonBox["ScalarFunction",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "ScalarFunction.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["ScalarFunctionQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "ScalarFunctionQ.nb", 
         CharacterEncoding -> "iso8859-1"], None}], 
     ButtonBox["$ScalarFunctions",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$ScalarFunctions.nb", 
         CharacterEncoding -> "iso8859-1"], None}], 
     ButtonBox["DefScalarFunction",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "DefScalarFunction.nb", 
         CharacterEncoding -> "iso8859-1"], None}], 
     StyleBox[
      RowBox[{"Scalar", " ", "function", " ", "on", " ", "scalars"}],
      FontFamily->"Times"]},
    {
     ButtonBox["Basis",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "Basis.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["BasisQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "BasisQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$Bases",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$Bases.nb", CharacterEncoding -> 
         "iso8859-1"], None}], "DefBasis", 
     StyleBox[
      RowBox[{"Frame", " ", "of", " ", "vector", " ", "fields"}],
      FontFamily->"Times"]},
    {
     ButtonBox["Chart",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "Chart.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["ChartQ",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "ChartQ.nb", CharacterEncoding -> 
         "iso8859-1"], None}], 
     ButtonBox["$Charts",
      BaseStyle->"Hyperlink",
      ButtonData:>{
        FrontEnd`FileName[{"xTensor"}, "$Charts.nb", CharacterEncoding -> 
         "iso8859-1"], None}], "DefChart", 
     StyleBox[
      RowBox[{
      "Coordinate", " ", "chart", " ", "on", " ", "a", " ", "manifold"}],
      FontFamily->"Times"]}
   }]]],
 "\n\nEach type has an associated Q-function to identify the symbol type: \
each user-defined symbol has an upvalue ",
 StyleBox["True",
  FontFamily->"Courier"],
 " for the corresponding Q-function, giving ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on the other Q-functions. The name of the Q-function is always constructed \
appending Q to the type name (note the exception of ",
 StyleBox["xTensorQ",
  FontFamily->"Courier"],
 ", to avoid conflict with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 StyleBox["TensorQ",
  FontFamily->"Courier"],
 "). The list of symbols of each type is contained in a global variable whose \
name is constructed using a ",
 StyleBox["$",
  FontFamily->"Courier"],
 " and the plural of the symbol type (note that the plural of Index is \
Indices, and the plural of Basis is Bases). Objects of the corresponding type \
are defined (undefined) using ",
 StyleBox["DefType",
  FontFamily->"Courier"],
 " (",
 StyleBox["UndefType",
  FontFamily->"Courier"],
 ") commands, where ",
 StyleBox["Type",
  FontFamily->"Courier"],
 " must be replaced by the corresponding symbol type. The option ",
 StyleBox["DefInfo",
  FontFamily->"Courier"],
 " allows us to store some information on the type and nature of the defined \
symbol. The global variables ",
 StyleBox["$DefInfoQ",
  FontFamily->"Courier"],
 " and ",
 StyleBox["$UndefInfoQ",
  FontFamily->"Courier"],
 " allow setting and unsetting globally the info messages. The function ",
 StyleBox[ButtonBox["Undef",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Undef.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " can undefine any symbol, except for abstract indices.\n\nBases and charts \
are defined and dealt with in the companion package ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ". In particular the functions ",
 StyleBox["DefBasis",
  FontFamily->"Courier"],
 " and ",
 StyleBox["DefChart",
  FontFamily->"Courier"],
 " are defined in there. However the type management is done by ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ".\n\nGiven an expression, we can find all instances of a given type using \
the function ",
 StyleBox[ButtonBox["FindAllOfType",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindAllOfType.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Symbols and types", "Type managing"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4. Relations among symbols", "Subsection",
 CellTags->{"Symbols and types", "Relations among symbols"}],

Cell[TextData[{
 "There are mathematical objects that can only be defined if other objects \
have already been defined before. For example defining a scalar field ",
 StyleBox["T",
  FontSlant->"Italic"],
 " requires the previously defined manifold ",
 StyleBox["M",
  FontSlant->"Italic"],
 " where it lives. We shall say the symbol ",
 StyleBox["T",
  FontSlant->"Italic"],
 " is a \"visitor\" of the symbol ",
 StyleBox["M",
  FontSlant->"Italic"],
 ", which itself will be called a \"host\" of ",
 StyleBox["T",
  FontSlant->"Italic"],
 ". The lists of visitors and hosts associated to a symbol are respectively \
given by the functions ",
 StyleBox[ButtonBox["VisitorsOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VisitorsOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["HostsOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "HostsOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". A symbol can only be removed when the list of its visitors is empty.\n\n\
Some objects are automatically defined. For example the tangent bundle of a \
manifold is automatically defined when the manifold is defined. We say that \
the tangent bundle is a \"servant\" of the manifold, and that the manifold is \
the \"master\" of the tangent bundle. The list of servants associated to a \
symbol is given by the function ",
 StyleBox[ButtonBox["ServantsOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ServantsOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The master of a symbol is given by the function ",
 StyleBox[ButtonBox["MasterOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MasterOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The master of a symbol is specified at definition time using the option \
",
 StyleBox[ButtonBox["Master",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Master.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " of the ",
 StyleBox["DefType",
  FontFamily->"Courier"],
 " commands. Currently a symbol can have only one master. A symbol can only \
be removed when its master has an empty list of servants, which is \
interpreted as a sign that the master is also being removed."
}], "Text",
 CellTags->{"Relations among symbols", "Symbols and types"}],

Cell[TextData[{
 "Visitors of a symbol frequently have that symbol in their own name. For \
instance, the ",
 StyleBox["Riemann",
  FontFamily->"Courier"],
 " tensor of the covariant derivative ",
 StyleBox["CD",
  FontSlant->"Italic"],
 " is called by default ",
 StyleBox["RiemannCD",
  FontSlant->"Italic"],
 ". This is controlled through the function ",
 StyleBox[ButtonBox["GiveSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GiveSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which in that example would be called as ",
 StyleBox["GiveSymbol",
  FontFamily->"Courier"],
 "[",
 StyleBox["Riemann",
  FontFamily->"Courier"],
 ", ",
 StyleBox["CD",
  FontSlant->"Italic"],
 "], and has explicit instructions on how to proceed in each case."
}], "Text",
 CellTags->{"Relations among symbols", "Symbols and types"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2. Generalized indices",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->18,
 CellTags->"Generalized indices"],

Cell[CellGroupData[{

Cell["2.1. Introduction", "Subsection",
 CellTags->{"Generalized indices", "GIndexQ"}],

Cell[TextData[{
 "The main objective of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is the manipulation of indexed objects. From the mathematical point of \
view we shall always use the notation of abstract indices for abstract \
expressions (see Penrose & Rindler, or Wald), where the indices denote the \
type and symmetries of a tensor, and not its components in a given frame (we \
use a different type of indices for components). This notation is very \
general and powerful, though sometimes cumbersome. From the computational \
point of view, however, we need a more general concept of index, with several \
properties:\n\n1) We define the concept of ",
 StyleBox["generalized index",
  FontSlant->"Italic"],
 " as any expression found at an ",
 StyleBox["index-slot",
  FontSlant->"Italic"],
 ". Currently index-slots are those with lower case letters in\n\t",
 StyleBox["tensor",
  FontSlant->"Italic"],
 "[a,b,c]\n\t",
 StyleBox["covd",
  FontSlant->"Italic"],
 "[a][...]\n\t",
 StyleBox["Bracket",
  FontFamily->"Courier"],
 "[a][..., ...]\nand the indexed arguments of the inert-heads, to be \
explained later, but nothing else. At those index-slots we can put anything, \
but the system has been already trained to manipulate five types of \
expressions, which we now review in detail. This is called the index ",
 StyleBox["type ",
  FontSlant->"Italic"],
 "(these are logic types, not actual symbol types):\n\t- ",
 StyleBox[ButtonBox["AIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": abstract indices: a, -b, d$101\n\t- ",
 StyleBox[ButtonBox["BIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": basis indices: {a, polar}, {-b, -polar}\n\t- ",
 StyleBox[ButtonBox["CIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": component indices: {0, polar}, {2, -polar}\n\t- ",
 StyleBox[ButtonBox["DIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": directions: ",
 StyleBox["Dir",
  FontFamily->"Courier"],
 "[vector]\n\t- ",
 StyleBox[ButtonBox["LIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": labels: ",
 StyleBox["LI",
  FontFamily->"Courier"],
 "[hello]\nThey all give ",
 StyleBox["True",
  FontFamily->"Courier"],
 " when the function ",
 StyleBox[ButtonBox["GIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " is applied, and ",
 StyleBox["False",
  FontFamily->"Courier"],
 " otherwise. There is a sixth type of index, not accepted by ",
 StyleBox["GIndexQ",
  FontFamily->"Courier"],
 ":\n\t- ",
 StyleBox[ButtonBox["PIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": patterns with head ",
 StyleBox["Blank",
  FontFamily->"Courier"],
 ", ",
 StyleBox["Pattern",
  FontFamily->"Courier"],
 " or ",
 StyleBox["PatternTest",
  FontFamily->"Courier"],
 ", but no other pattern head\nIt is possible to introduce new index types \
but then you would need to specify which values they have for the following \
index properties (contact JMM to discuss why a new type of index is \
required):\n\n2) All indices have a ",
 StyleBox["character",
  FontSlant->"Italic"],
 ", which can be ",
 StyleBox[ButtonBox["Down",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Down.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (",
 StyleBox["covariant)",
  FontSlant->"Italic"],
 " or ",
 StyleBox[ButtonBox["Up",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Up.nb", CharacterEncoding -> "iso8859-1"],
     None}],
  FontFamily->"Courier"],
 " (",
 StyleBox["contravariant)",
  FontSlant->"Italic"],
 ". Nameless patterns like _ or ",
 StyleBox["a_",
  FontSlant->"Italic"],
 " do not have a well-defined character. However, by convention,  they are \
treated by the formatting routines as if they were contravariant. The \
character can be detected with the functions ",
 StyleBox[ButtonBox["UpIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UpIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["DownIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DownIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". They both always give ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on all patterns. Any index can be made contravariant using the function ",
 StyleBox[ButtonBox["UpIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UpIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and covariant using ",
 StyleBox[ButtonBox["DownIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DownIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The character of any index can be reversed using ",
 StyleBox[ButtonBox["ChangeIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\n3) Contractible indices are those which obey the Einstein convention \
and are detected by the function ",
 StyleBox[ButtonBox["EIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "EIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Actual pairs of indices are detected with ",
 StyleBox[ButtonBox["PairQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PairQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Currently only abstract indices and basis indices belong to this special \
type (though in the future we might consider having non-contracted basis \
indices). They have a ",
 StyleBox["state",
  FontSlant->"Italic"],
 ", which can be ",
 StyleBox[ButtonBox["Free",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Free.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " or ",
 StyleBox[ButtonBox["Dummy",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dummy.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (aka ",
 StyleBox["contracted",
  FontSlant->"Italic"],
 "). Non-contractible indices are said to have state ",
 StyleBox[ButtonBox["Blocked",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Blocked.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and can be detected with the function ",
 StyleBox[ButtonBox["BlockedQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BlockedQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which always gives opposite answers to ",
 StyleBox["EIndexQ",
  FontFamily->"Courier"],
 ".\n\n4) Apart from those three `public\.b4 properties (type, character and \
state), ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " uses a fourth property internally: the ",
 StyleBox["metric-state",
  FontSlant->"Italic"],
 " of an index, saying whether an index has been moved with a metric with \
respect to the character of the corresponding slot at definition time.\n\n5) \
To avoid index collisions we use the (",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " recommended) method of unique variables, having indices like a$123. This \
is useful but produces ugly expressions. To hide away those \
\"dollar-indices\" use the function ",
 StyleBox[ButtonBox["ScreenDollarIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ScreenDollarIndices.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", either explicitly or by setting ",
 StyleBox["$PrePrint",
  FontFamily->"Courier"],
 " or ",
 StyleBox["$Post",
  FontFamily->"Courier"],
 ".\n\n6) Finally, we shall distinguish between indices on a complex vbundle \
and \"conjugated indices\" on the complex conjugated vbundle.\n\nAs a general \
recommendation, manipulation of indices must be done using mathematical \
commands to do that, and not tinkering directly with the indices. The \
2-dimensional-boxes output of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is not editable and hence there is no possibility of changing indices in \
the formatted output."
}], "Text",
 CellTags->{"GIndexQ", "Generalized indices"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2. Abstract indices", "Subsection",
 CellTags->{"Generalized indices", "Abstract Indices"}],

Cell[TextData[{
 "Abstract indices are labels that indicate tensorial slots (i. e. \
contraction with vectors or covectors). In principle we should have indices \
a, b, c, ..., contravariant indices Up[a], Up[b], Up[c], ..., and covariant \
indices Down[a], Down[b], Down[c], ... To simplify the input/output of \
tensors we represent both indices and contravariant indices as a, b, c, ... \
and covariant indices as -a, -b, -c, ... This is the simplest choice, but the \
treatment of patterns becomes harder because we loose the symmetry between \
upindices and downindices (the former being atoms and the latter being \
composite expressions).\n\nThe symbol type associated to abstract indices is ",
 StyleBox[ButtonBox["AbstractIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AbstractIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". (This is a *symbol type* and therefore an expression like -a cannot have \
this  symbol type. See below.) The list of all currently defined abstract \
indices is given by the global variable ",
 StyleBox[ButtonBox["$AbstractIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$AbstractIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". All of them have associated upvalues ",
 StyleBox["True",
  FontFamily->"Courier"],
 " for the function ",
 StyleBox[ButtonBox["AbstractIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AbstractIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Abstract indices are defined using the function ",
 StyleBox[ButtonBox["DefAbstractIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefAbstractIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined using ",
 StyleBox[ButtonBox["UndefAbstractIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefAbstractIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Defining an abstract index just involves checking the validity of the \
symbol and registering the corresponding upvalue for the Q-function. This \
should never be done directly by the user. These functions are made public \
only for consistency of the symbol type management.\n\nDo not confuse the \
function ",
 StyleBox["AbstractIndexQ",
  FontFamily->"Courier"],
 ", which gives ",
 StyleBox["True",
  FontFamily->"Courier"],
 " only on symbols defined as abstract indices (like a, b, ...), and the \
function ",
 StyleBox[ButtonBox["AIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which gives ",
 StyleBox["True",
  FontFamily->"Courier"],
 " on all abstract indices(a, -b, a$125, ...).\n\nWe may consider in the \
future to allow for more general (composite) abstract indices, like indexed \
indices or multiindices, but currently this is not possible.\n\nIn ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " abstract indices are always associated to vector bundles through the \
function ",
 StyleBox[ButtonBox["VBundleOfIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundleOfIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is sort of inverse of ",
 StyleBox[ButtonBox["IndicesOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndicesOfVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The association to manifolds is implicit through their tangent vector \
bundles.\n\nA simple way to generate a list of abstract indices is provided \
by the function ",
 StyleBox[ButtonBox["IndexRange",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexRange.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Generalized indices", "Abstract Indices"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3. Basis indices and component indices", "Subsection",
 CellTags->{"Generalized indices", "Basis indices"}],

Cell[TextData[{
 "Almost everything related to bases and components is done by the twin \
package ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ". However, the internal manipulation of basis indices is already prepared \
in advance in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", to avoid a slow process of overloading of functions when loading ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ". Following Schouten, Dodson & Poston, and Penrose & Rindler, basis-indices \
contain the information of the basis they belong to. This is called the ",
 StyleBox["marked index",
  FontSlant->"Italic"],
 " notation. That avoids defining different indices for different bases, but \
makes basis-indices a bit cumbersome: {",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["basis",
  FontSlant->"Italic"],
 "} where ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is an abstract index. There is no type associated to basis-indices because \
they are always composite structures.\n\nThe function ",
 StyleBox[ButtonBox["BIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " checks whether a given expression is a valid basis-index. It has a second \
argument to check whether the basis index belongs to a given basis or to a \
given vbundle.\n\nComponent indices are defined in parallel with basis \
indices {",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["basis",
  FontSlant->"Italic"],
 "} but ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is now an integer, one of those c-numbers (\"c\" from component and \
coordinate; no intended connection with Quantum Mechanics) defined with the \
basis. The function ",
 StyleBox[ButtonBox["CIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " checks whether a given expression is a valid component-index. It also has \
a second argument to check whether the component index belongs to a given \
basis or to a given vbundle. The index {1, ",
 StyleBox["basis",
  FontSlant->"Italic"],
 "} is contravariant and the index {1, -",
 StyleBox["basis",
  FontSlant->"Italic"],
 "} is covariant. The integer number can be positive, negative or zero \
because the character is stored as the sign of the basis, and not of the \
integer itself. Beware that this was different in pre-0.8 versions of ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ".\n\nThe function ",
 StyleBox[ButtonBox["BCIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BCIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " checks whether an index is a basis-index or a component-index. The \
function ",
 Cell[BoxData[
  ButtonBox["ABIndexQ",
   BaseStyle->"Hyperlink",
   ButtonData:>{
     FrontEnd`FileName[{"xTensor"}, "ABIndexQ.nb", CharacterEncoding -> 
      "iso8859-1"], None}]], "Input",
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 " checks whether an index is an abstract-index or a basis-index, currently \
the only two types of indices which are contractible."
}], "Text",
 CellTags->{"Generalized indices", "Basis indices"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4. Directional indices", "Subsection",
 CellTags->{"Generalized indices", "Directional indices"}],

Cell[TextData[{
 "Directional indices represent the mathematical notation that sees tensorial \
slots as slots for vectors and covectors. Because it is seldom used, we want \
to avoid ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " checking continuosly if a given index is directional. Hence we introduce \
the head ",
 StyleBox[ButtonBox["Dir",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dir.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " to pinpoint the directional indices.\n\nThe vector argument of a \
directional index has its own index, which is not an index of the whole \
expression. The index must belong to the correct vector bundle, but the name \
of the index itself is irrelevant; it is some kind of dummy index; we call it \
an ultraindex.\n\nThe function ",
 StyleBox[ButtonBox["DIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " checks whether a given expression is a valid directional-index. Vectors \
can be contracted to ",
 StyleBox["Dir",
  FontFamily->"Courier"],
 " expressions using ",
 StyleBox[ButtonBox["ContractDir",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractDir.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and separated using ",
 StyleBox[ButtonBox["SeparateDir",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SeparateDir.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Generalized indices", "Directional indices"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5. Label indices", "Subsection",
 CellTags->{"Generalized indices", "Label Indices"}],

Cell[TextData[{
 "There are indices which are not associated to vector bundles. We call them ",
 StyleBox["labels",
  FontSlant->"Italic"],
 " or ",
 StyleBox["label-indices",
  FontSlant->"Italic"],
 ". An example could be the ",
 StyleBox["l, m",
  FontSlant->"Italic"],
 " labels of the spherical harmonics. Because they are used only every now \
and then, we denote them with a special head: ",
 StyleBox[ButtonBox["LI",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LI.nb", CharacterEncoding -> "iso8859-1"],
     None}],
  FontFamily->"Courier"],
 ". An ",
 StyleBox["LI",
  FontFamily->"Courier"],
 " expression can have any internal structure; in particular they can have \
several elements. It is possible to associate a character for them using ",
 StyleBox["LI",
  FontFamily->"Courier"],
 "[a] and -",
 StyleBox["LI",
  FontFamily->"Courier"],
 "[a] (",
 StyleBox["LI",
  FontFamily->"Courier"],
 "[-a] is not interpreted as a \"covariant label\") but they are defined as \
not obeying the Einstein convention (blocked indices).\n\nThe function ",
 StyleBox[ButtonBox["LIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " checks whether a given expression is a valid label-index."
}], "Text",
 CellTags->{"Generalized indices", "Label Indices"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6. Patterns", "Subsection",
 CellTags->{"Generalized indices", "Pattern Indices"}],

Cell[TextData[{
 "At index-slots we can also find patterns for g-indices (even patterns for \
patterns). Not all patterns are allowed: only those with head ",
 StyleBox["Blank",
  FontFamily->"Courier"],
 ", ",
 StyleBox["Pattern",
  FontFamily->"Courier"],
 " or ",
 StyleBox["PatternTest",
  FontFamily->"Courier"],
 ". The function ",
 StyleBox[ButtonBox["PIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " validates the allowed patterns. The function ",
 StyleBox[ButtonBox["PatternIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PatternIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " constructs patterns of the required form.\n\nFor a description of the \
patterns to be used in rules, see ",
 ButtonBox["Section 6",
  BaseStyle->"Hyperlink",
  ButtonData:>"Rules"],
 " below."
}], "Text",
 CellTags->{"Generalized indices", "Pattern Indices"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7. Finding indices", "Subsection",
 CellTags->{"Generalized indices", "Findind indices"}],

Cell[TextData[{
 "All indices of an expression, including patterns, can be extracted using \
the function ",
 StyleBox[ButtonBox["FindIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". This function has attribute ",
 StyleBox["HoldFirst",
  FontFamily->"Courier"],
 " to allow it getting the indices of input expressions, before they start to \
evaluate. ",
 StyleBox["FindIndices",
  FontFamily->"Courier"],
 " always returns a list of indices with head ",
 StyleBox[ButtonBox["IndexList",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexList.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", to avoid confusion with the notation for basis and component indices. ",
 StyleBox["FindIndices[0]",
  FontFamily->"Courier"],
 " returns ",
 StyleBox["IndexList[",
  FontFamily->"Courier"],
 StyleBox[ButtonBox["AnyIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AnyIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["]",
  FontFamily->"Courier"],
 ".  ",
 StyleBox["FindIndices",
  FontFamily->"Courier"],
 " works recursively, checking the heads of the elements of expressions, and \
complaining when it finds an unknown head. New \"known\" heads can be added \
to the list ",
 StyleBox[ButtonBox["$FindIndicesAcceptedHeads",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$FindIndicesAcceptedHeads.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nWhen searching for the indices of a tensor, covariant derivative of a \
tensor or a tensor product we check that none of the indices are repeated \
with the internal function ",
 StyleBox["CheckRepeated",
  FontFamily->"Courier"],
 ". When searching for the indices of a sum of tensor expressions, or a list, \
equation or rule of them, we check homogeneity of free indices with the \
internal function ",
 StyleBox["CheckHomogeneity",
  FontFamily->"Courier"],
 ".\n\nThree related functions, based on ",
 StyleBox["FindIndices",
  FontFamily->"Courier"],
 ", are ",
 StyleBox[ButtonBox["FindFreeIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindFreeIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["FindDummyIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindDummyIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["FindBlockedIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindBlockedIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". They give disjoint lists of indices. The second one returns only the \
up-member of the pairs of dummies.\n\nA very friendly driver for ",
 StyleBox["FindIndices",
  FontFamily->"Courier"],
 " is ",
 StyleBox[ButtonBox["IndicesOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndicesOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The general syntax is ",
 StyleBox["IndicesOf",
  FontFamily->"Courier"],
 "[",
 StyleBox["selectors",
  FontSlant->"Italic"],
 "][",
 StyleBox["expr",
  FontSlant->"Italic"],
 "], where ",
 StyleBox["selectors",
  FontSlant->"Italic"],
 " are one or several of the following:\n\t- ",
 StyleBox[ButtonBox["Free",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Free.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": free indices\n\t- ",
 StyleBox[ButtonBox["Dummy",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dummy.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": dummy indices\n\t- ",
 StyleBox[ButtonBox["Blocked",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Blocked.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": blocked indices\n\t- ",
 StyleBox[ButtonBox["Up",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Up.nb", CharacterEncoding -> "iso8859-1"],
     None}],
  FontFamily->"Courier"],
 ": contravariant indices\n\t- ",
 StyleBox[ButtonBox["Down",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Down.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": covariant indices\n\t- ",
 StyleBox[ButtonBox["AIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": abstract indices\n\t- ",
 StyleBox[ButtonBox["BIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": basis indices\n\t- ",
 StyleBox[ButtonBox["CIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": component indices\n\t- ",
 StyleBox[ButtonBox["DIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": directional indices\n\t- ",
 StyleBox[ButtonBox["LIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": label indices:\n\t- ",
 StyleBox["vbundle",
  FontSlant->"Italic"],
 ": indices of the given vbundle\n\t- ",
 StyleBox["basis",
  FontSlant->"Italic"],
 ": indices of the given basis\n\t- ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 ": indices on the given tensor\n\t- ",
 StyleBox["covd",
  FontSlant->"Italic"],
 ": indices on the given covariant derivative\n\t- ",
 StyleBox[ButtonBox["Basis",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Basis.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "[",
 StyleBox["basis",
  FontSlant->"Italic"],
 "]: (both) indices on ",
 StyleBox["Basis",
  FontFamily->"Courier"],
 " objects of the given basis\n\t- ",
 StyleBox["Not",
  FontFamily->"Courier"],
 "[any of the previous]: complement of the previous\nA sequence of several \
selectors represents the ",
 StyleBox["And",
  FontFamily->"Courier"],
 " of all selectors (smaller result). A list of several selectors represents \
the ",
 StyleBox["Or",
  FontFamily->"Courier"],
 " of all selectors (bigger result).\n\nAn alternative and completely \
independent way of looking for indices, very useful for recursive algorithms \
of index contraction, is the function ",
 StyleBox[ButtonBox["IsIndexOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IsIndexOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nFor some applications dealing with Hermitian objects, we need to \
handle Hermitian pairs of indices. We use the head ",
 StyleBox["Pair",
  FontFamily->"Courier"],
 " (TODOCUMENT)."
}], "Text",
 CellTags->{"Generalized indices", "Findind indices"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.8. Sorting indices", "Subsection",
 CellTags->{"Generalized indices", "Sorting Indices"}],

Cell[TextData[{
 "The canonicalization of an indexed object essentially entails to a \
reordering of the indices according to the symmetries of the object and a \
predefined ordering for the indices. The function ",
 StyleBox[ButtonBox["IndexSort",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexSort.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " returns the preferred order for a list of indices. With the function ",
 StyleBox[ButtonBox["SetIndexSortPriorities",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SetIndexSortPriorities.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " we can decide which particular order we want to have. Possible priorities \
are the strings ",
 StyleBox["\"up\"/\"down\"",
  FontFamily->"Courier"],
 ", ",
 StyleBox["\"free\"/\"dummy\"",
  FontFamily->"Courier"],
 ", ",
 StyleBox["\"lexicographic\"/\"antilexicographic\"",
  FontFamily->"Courier"],
 ", ",
 StyleBox["\"positional\"/\"antipositional\"",
  FontFamily->"Courier"],
 ".\n\nSimple functions derived from ",
 StyleBox["IndexSort",
  FontFamily->"Courier"],
 " are ",
 StyleBox[ButtonBox["IndexOrderedQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexOrderedQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["DisorderedPairQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DisorderedPairQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Generalized indices", "Sorting Indices"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9. Replacing indices", "Subsection",
 CellTags->{"Generalized indices", "Replacing indices"}],

Cell[TextData[{
 "The basic function for index replacement in a generic expression is ",
 StyleBox[ButtonBox["ReplaceIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ReplaceIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Every valid index can be changed by any other thing, not necessarily an \
index (though that would inmediately produce many errors). ",
 StyleBox["ReplaceIndex",
  FontFamily->"Courier"],
 " has attribute ",
 StyleBox["HoldFirst",
  FontFamily->"Courier"],
 ". The syntax is ",
 StyleBox["ReplaceIndex",
  FontFamily->"Courier"],
 "[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["rules",
  FontSlant->"Italic"],
 "], where the ",
 StyleBox["rules",
  FontSlant->"Italic"],
 " are of the form ",
 StyleBox["index",
  FontSlant->"Italic"],
 StyleBox["->",
  FontFamily->"Courier"],
 StyleBox["newindex",
  FontSlant->"Italic"],
 ". The rule ",
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["->",
  FontFamily->"Courier"],
 StyleBox["b",
  FontSlant->"Italic"],
 " and ",
 StyleBox["-a",
  FontSlant->"Italic"],
 StyleBox["->",
  FontFamily->"Courier"],
 StyleBox["-b",
  FontSlant->"Italic"],
 " are considered independent, and both must be specified if that is what we \
need.\n\nDerived functions are:\n\t- ",
 StyleBox[ButtonBox["ReplaceDummies",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ReplaceDummies.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": replacement of all dummies in an expression by indices in a given list, \
or by new dollar-indices. Indices belonging to different vbundles are not \
mixed up. In computations with intensive generation of dollar-indices the \
memory of the computer could be filled after a while and the global variable ",
 StyleBox[ButtonBox["$ComputeNewDummies",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ComputeNewDummies.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " has been introduced to avoid this. There is also a private function ",
 StyleBox["RemoveDollarIndices",
  FontFamily->"Courier"],
 ".\n\t- ",
 StyleBox[ButtonBox["SameDummies",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SameDummies.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": returns an expression minimizing the number of different dummies used in \
different terms.\n\t- ",
 StyleBox[ButtonBox["PermuteIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PermuteIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": replace indices in an expression as given by a permutation or a linear \
combination of them.\n\t- ",
 StyleBox[ButtonBox["SplitIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SplitIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": returns a list of expressions where a given free index has been \
respectively replaced by each of a list of indices. This is useful to expand \
component ranges or to expand sums of vbundles.\n\t- ",
 StyleBox[ButtonBox["TraceDummy",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TraceDummy.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": converts an expression with a dummy pair into a sum of expressions with \
different dummy pairs. Log messages can be controlled with ",
 StyleBox[ButtonBox["$TraceDummyVerbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$TraceDummyVerbose.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Generalized indices", "Replacing indices"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3. Formatting of indexed objects",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->18,
 CellTags->"Formatting of indexed objects"],

Cell[TextData[{
 "Formatting in versions 0.7and 0.8 was rather limited. Version 0.9 has \
introduced cut-and-paste,  but still no editing of the tensor expressions. \
This section will be much expanded in future versions.\n\nMost symbols in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " can be formatted in ",
 StyleBox["StandardForm",
  FontFamily->"Courier"],
 ". The output form of a symbol is a string \"<output>\" chosen at definition \
time using the option ",
 StyleBox[ButtonBox["PrintAs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PrintAs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which defines an upvalue ",
 StyleBox["PrintAs[",
  FontFamily->"Courier"],
 StyleBox["symbol",
  FontSlant->"Italic"],
 StyleBox["]",
  FontFamily->"Courier"],
 "=\"<output>\". The value of the option can be directly the string \
\"<output>\" or a function which returns the string when applied on symbol. \
Formatting of a type of objects (or of all allowed objects to be formatted) \
can be turned on/off using the functions ",
 StyleBox[ButtonBox["xTensorFormStart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "xTensorFormStart.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["[",
  FontFamily->"Courier"],
 StyleBox["type",
  FontSlant->"Italic"],
 StyleBox["]",
  FontFamily->"Courier"],
 " / ",
 StyleBox[ButtonBox["xTensorFormStop",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "xTensorFormStop.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox["[",
  FontFamily->"Courier"],
 StyleBox["type",
  FontSlant->"Italic"],
 StyleBox["]",
  FontFamily->"Courier"],
 ".\n\nThose symbols automatically generated with ",
 StyleBox[ButtonBox["GiveSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GiveSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " have a parallel function to generate their output strings, called ",
 StyleBox[ButtonBox["GiveOutputString",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GiveOutputString.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\nIndices are always formatted if a ",
 StyleBox["PrintAs",
  FontFamily->"Courier"],
 " upvalue has been given for them. Note that the formatting of indices is \
not given at definition time; it must be explicitly set as upvalues for ",
 StyleBox["PrintAs",
  FontFamily->"Courier"],
 ".\n\nBasis and component indices are formatted using a color associated to \
the corresponding basis. Components are numbered, but for coordinate systems \
it is possible to use the name of the corresponding coordinate (",
 StyleBox[ButtonBox["CIndexForm",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CIndexForm.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["$CIndexForm",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CIndexForm.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ").\n\nCovariant derivatives and their indices can be formatted in ",
 StyleBox["StandardForm",
  FontFamily->"Courier"],
 " in two possible ways, stored as values in the global variable ",
 StyleBox[ButtonBox["$CovDFormat",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CovDFormat.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": ",
 StyleBox["\"Prefix\"",
  FontFamily->"Courier"],
 " and ",
 StyleBox["\"Postfix\"",
  FontFamily->"Courier"],
 ", with obvious meanings. The associated symbols to be used in each of those \
cases are stored in ",
 StyleBox[ButtonBox["SymbolOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymbolOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " for each covariant derivative.\n\nTODOCUMENT: ",
 StyleBox["Tex",
  FontFamily->"Courier"],
 ", ",
 StyleBox["TexPrint",
  FontFamily->"Courier"],
 ", ",
 StyleBox["TexBreak",
  FontFamily->"Courier"],
 ". Update 2012: Functionality excised to new package ",
 StyleBox["TexAct`",
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->"Formatting of indexed objects"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["4. Mathematical entities",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->18,
 CellTags->"Mathematical entities"],

Cell[TextData[{
 "Elementary mathematical objects in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->"Mathematical entities"],

Cell[CellGroupData[{

Cell["4.1. Constant-symbols", "Subsection",
 CellTags->{"Mathematical entities", "Constant symbols"}],

Cell[TextData[{
 "Symbols defined with type ",
 StyleBox[ButtonBox["ConstantSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ConstantSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represent constants with respect to all kinds of derivatives. In \
particular, they are given attribute ",
 StyleBox["Constant",
  FontFamily->"Courier"],
 ".\n\nConstant-symbols are defined with ",
 StyleBox[ButtonBox["DefConstantSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefConstantSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined with ",
 StyleBox[ButtonBox["UndefConstantSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefConstantSymbol.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Possible options at definition time are ",
 StyleBox[ButtonBox["Dagger",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dagger.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and those generic for all Def-commands: ",
 StyleBox[ButtonBox["DefInfo",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefInfo.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Master",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Master.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["ProtectNewSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProtectNewSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["PrintAs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PrintAs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nThe list of all currently defined constant-symbols is stored in the \
global variable ",
 StyleBox[ButtonBox["$ConstantSymbols",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ConstantSymbols.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nAny symbol defined as a constant-symbol is given a ",
 StyleBox["True",
  FontFamily->"Courier"],
 " upvalue for the function ",
 StyleBox[ButtonBox["ConstantSymbolQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ConstantSymbolQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input.\n\nA constant-symbol is a particular kind of constant. \
A constant is either a constant-symbol, a numeric symbol or a number. We use \
the function ",
 StyleBox[ButtonBox["ConstantQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ConstantQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " to check that something is a constant. Do not confuse ",
 StyleBox["ConstantQ",
  FontFamily->"Courier"],
 " and ",
 StyleBox["ConstantSymbolQ",
  FontFamily->"Courier"],
 ". Replacing constant-symbols by constants is safe. For instance, there is \
no problem in using a rule like ",
 StyleBox["Mass->2",
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Constant symbols", "Mathematical entities"}]
}, Closed]],

Cell[CellGroupData[{

Cell["4.2. Parameters", "Subsection",
 CellTags->{"Parameters", "Mathematical entities"}],

Cell[TextData[{
 "Symbols defined with type ",
 StyleBox[ButtonBox["Parameter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Parameter.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represent real parameters with some undefined range of values. Essentially \
they will be used as dependencies of other objects (tensors, for instance), \
and we will be able to take parametric derivatives of expressions (see ",
 StyleBox["ParamD",
  FontFamily->"Courier"],
 " below).\n\nParameters are defined with ",
 StyleBox[ButtonBox["DefParameter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefParameter.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined with ",
 StyleBox[ButtonBox["UndefParameter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefParameter.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". There are no particular options at definition time, apart from those \
generic for all ",
 StyleBox["DefType",
  FontFamily->"Courier"],
 " commands: ",
 StyleBox[ButtonBox["DefInfo",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefInfo.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Master",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Master.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["ProtectNewSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProtectNewSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["PrintAs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PrintAs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nWe do not expect parameters to be master symbols (i.e. have servants). \
However they can have objects, those objects which depend on the parameter. A \
parameter cannot be undefined if it has objects.\n\nThe list of all currently \
defined parameters is stored in the global variable ",
 StyleBox[ButtonBox["$Parameters",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Parameters.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nAny symbol defined as a parameter is given a ",
 StyleBox["True",
  FontFamily->"Courier"],
 " upvalue for the function ",
 StyleBox[ButtonBox["ParameterQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ParameterQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other output.\n\nThe parameter dependencies of a generic expression \
expr are obtained applying ",
 StyleBox[ButtonBox["ParametersOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ParametersOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " on ",
 StyleBox["expr",
  FontSlant->"Italic"],
 ". This is just a call to ",
 StyleBox[ButtonBox["DependenciesOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DependenciesOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " on ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " and then a selection (using ",
 StyleBox["Select",
  FontFamily->"Courier"],
 " and ",
 StyleBox["ParameterQ",
  FontFamily->"Courier"],
 ") of the parameters. Parameter dependencies of a tensor are obtained, \
following a parallel path, using the private function ",
 StyleBox["ParametersOfTensor",
  FontFamily->"Courier"],
 ". Note that the latter function expects a symbol (the tensor head), but the \
former expects a generic expression."
}], "Text",
 CellTags->{"Parameters", "Mathematical entities"}]
}, Closed]],

Cell[CellGroupData[{

Cell["4.3. Manifolds, vector bundles and mappings", "Subsection",
 CellTags->{"Mathematical entities", "Manifolds"}],

Cell[CellGroupData[{

Cell["4.3.1. Manifolds", "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],

Cell[TextData[{
 "A symbol ",
 StyleBox["manifold",
  FontSlant->"Italic"],
 " with type ",
 StyleBox[ButtonBox["Manifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Manifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represents a smooth, differentiable real manifold of fixed dimension.\n\n\
The only predefined manifolds are those of the form ",
 StyleBox["Reals[dim]",
  FontFamily->"Courier"],
 ", where dim is a nonnegative integer or a constant-symbol.\n\nManifolds are \
defined with ",
 StyleBox[ButtonBox["DefManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefManifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined with ",
 StyleBox[ButtonBox["UndefManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefManifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The syntax for definition of ",
 StyleBox["manifold",
  FontSlant->"Italic"],
 " is\n",
 StyleBox["DefManifold[",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["manifold",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["dim",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["indices",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["]",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", where:\n \t",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["manifold",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" is the symbol to be defined,\n \t",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["dim ",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["is a nonnegative integer or a constant-symbol, and\n \t",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["indices ",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["is the list of abstract indices associated to the tangent vbundle \
of ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["manifold",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[".\n \n",
  FontVariations->{"CompatibilityType"->0}],
 "The list of all currently defined manifolds is stored in the global \
variable ",
 StyleBox[ButtonBox["$Manifolds",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Manifolds.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". All of them have associated upvalues ",
 StyleBox["True",
  FontFamily->"Courier"],
 " for the function ",
 StyleBox[ButtonBox["ManifoldQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ManifoldQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input.",
 StyleBox["\n \nThe dimensionality of the manifold is stored as an upvalue of \
",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["manifold",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" for the function ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[ButtonBox["DimOfManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DimOfManifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox[".  0-dim and 1-dim manifolds have not been fully implemented yet.",
  
  FontVariations->{"CompatibilityType"->0}]
}], "Text",
 CellTags->{"Manifolds", "Mathematical entities"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.2. Product manifolds", "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],

Cell[TextData[{
 "Given several manifolds it is possible to define their \"product-manifold\" \
structure. This is done using again ",
 StyleBox[ButtonBox["DefManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefManifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", but now the second argument is a list of the (previously defined) \
submanifolds. The list of submanifolds is stored as an upvalue for the \
function ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    ButtonBox["SubmanifoldsOfManifold",
     BaseStyle->"Hyperlink",
     ButtonData:>{
       FrontEnd`FileName[{"xTensor"}, "SubmanifoldsOfManifold.nb", 
        CharacterEncoding -> "iso8859-1"], None}],
    FontFamily->"Courier"], ","}]], "Text"],
 "and give ",
 StyleBox["True",
  FontFamily->"Courier"],
 " when asked by ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubmanifoldQ",
    BaseStyle->"Hyperlink",
    ButtonData:>{
      FrontEnd`FileName[{"xTensor"}, "SubmanifoldQ.nb", CharacterEncoding -> 
       "iso8859-1"], None}],
   FontFamily->"Courier"]], "Text"],
 ". The list of all defined product-manifolds is stored in the global \
variable ",
 StyleBox[ButtonBox["$ProductManifolds",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ProductManifolds.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is a subset of ",
 StyleBox[ButtonBox["$Manifolds",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Manifolds.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Mathematical entities", "Manifolds"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.3. Dependencies", "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],

Cell[TextData[{
 "The manifold dependencies of a generic expression ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " are obtained applying ",
 StyleBox[ButtonBox["ManifoldsOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ManifoldsOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " on ",
 StyleBox["expr",
  FontSlant->"Italic"],
 ". This is just a call to ",
 StyleBox[ButtonBox["DependenciesOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DependenciesOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " on ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " and then a selection (using ",
 StyleBox["Select",
  FontFamily->"Courier"],
 " and ",
 StyleBox["ManifoldQ",
  FontFamily->"Courier"],
 ") of the parameters. Manifold dependencies of a tensor are obtained, \
following a parallel path, using the private function ",
 StyleBox["ManifoldsOfTensor",
  FontFamily->"Courier"],
 ". Note that the latter function expects a symbol (the tensor head), but the \
former expects a generic expression.\n\nDependencies are specially relevant \
for derivatives, where it is always important to know whether a derivative on \
some expression shares dependencies with that expression. This is computed \
via the function ",
 StyleBox[ButtonBox["DisjointManifoldsQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DisjointManifoldsQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Manifolds", "Mathematical entities"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.4. Vector bundles (\"vbundles\")", "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],

Cell[TextData[{
 "Each manifold has an associated vbundle (its tangent bundle) with the same \
dimension, whose name is formed by joining the symbol ",
 StyleBox[ButtonBox["Tangent",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Tangent.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and the name of the manifold, and which is stored as an upvalue for the \
function ",
 StyleBox[ButtonBox["TangentBundleOfManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TangentBundleOfManifold.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nHowever, in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " it is possible to define more general (\"inner\") vbundles, of the type \
that are used in gauge theories. As usual in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " we only worry about local properties, and therefore all our vbundles are \
considered products of an inner vector space and the base manifold. This is a \
new type of symbol:\n\nA symbol ",
 StyleBox["vbundle",
  FontSlant->"Italic"],
 " with type ",
 StyleBox[ButtonBox["VBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represents a smooth vector bundle of fixed dimension.\n\nVbundles are \
defined with ",
 StyleBox[ButtonBox["DefVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined with ",
 StyleBox[ButtonBox["UndefVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The syntax for definition of ",
 StyleBox["vbundle",
  FontSlant->"Italic"],
 " is\n",
 StyleBox["DefVBundle[",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["vbundle",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["manifold, dim",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["indices",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["]",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", where:\n \t",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["vbundle",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" is the symbol to be defined,\n \t",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["manifold",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" is the base manifold of ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["vbundle",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[",\n \t",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["dim ",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["is a nonnegative integer or a constant-symbol, the dimension of \
the vector space, and\n \t",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["indices ",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["is the list of abstract indices associated to ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["vbundle",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[".\n \n",
  FontVariations->{"CompatibilityType"->0}],
 "The list of all currently defined vbundles is stored in the global variable \
",
 StyleBox[ButtonBox["$VBundles",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$VBundles.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". All of them have associated upvalues ",
 StyleBox["True",
  FontFamily->"Courier"],
 " for the function ",
 StyleBox[ButtonBox["VBundleQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundleQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input.",
 StyleBox["\n \nThe dimensionality of the vbundle (that is, that of its \
vector space) is stored as an upvalue of ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["vbundle",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" for the function ",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[ButtonBox["DimOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DimOfVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox[".  0-dim and 1-dim vbundles have not been implemented yet. ",
  FontVariations->{"CompatibilityType"->0}],
 "The base manifold is stored as an upvalue of the vbundle for the function \
",
 StyleBox[ButtonBox["BaseOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BaseOfVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 StyleBox[".",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",
 CellTags->{"Mathematical entities", "Manifolds"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.5. Sum vbundles", "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],

Cell[TextData[{
 "Given several vbundles it is possible to define their \"sum-vbundle\" \
structure. This is done using again ",
 StyleBox[ButtonBox["DefVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", but now the third argument is a list of the (previously defined) \
subvbundles. The list of subvbundles is stored as an upvalue for the function \
",
 StyleBox[ButtonBox["SubvbundlesOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SubvbundlesOfVBundle.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 Cell[BoxData[","], "Text"],
 "and give ",
 StyleBox["True",
  FontFamily->"Courier"],
 " when asked by ",
 StyleBox[ButtonBox["SubvbundleQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SubvbundleQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The list of all defined sum-vbundles is stored in the global variable ",
 StyleBox[ButtonBox["$SumVBundles",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$SumVBundles.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is a subset of ",
 StyleBox[ButtonBox["$VBundles",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$VBundles.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nDummy pairs in a vbundle can be converted into sums of dummy pairs of \
its vbundles using the function ",
 StyleBox[ButtonBox["TraceProductDummy",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TraceProductDummy.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (with infix notation ",
 StyleBox[ButtonBox["CircleDot",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CircleDot.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ")."
}], "Text",
 CellTags->{"Mathematical entities", "Manifolds"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.6. Indices and vbundles", "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],

Cell[TextData[{
 "The list ",
 StyleBox["indices",
  FontSlant->"Italic"],
 " is stored as the first element of two in the list ",
 StyleBox[ButtonBox["IndicesOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndicesOfVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The second element will be the list of indices internally generated when \
the number of registered indices in not enough. See the function ",
 StyleBox[ButtonBox["NewIndexIn",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "NewIndexIn.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Indices can be added to the first list (",
 StyleBox[ButtonBox["AddIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AddIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ") or removed from it (",
 StyleBox[ButtonBox["RemoveIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RemoveIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "), even though the latter is very dangerous because previous expressions \
are likely to get corrupted if they contain removed indices. We can get any \
number of abstract indices using the function ",
 StyleBox[ButtonBox["GetIndicesOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GetIndicesOfVBundle.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Unique (dollar-) dummy indices can be generated using ",
 StyleBox[ButtonBox["DummyIn",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DummyIn.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". A list of respective dollar-indices on the subvbundles of a vbundle can \
be obtained with ",
 StyleBox[ButtonBox["SubdummiesIn",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SubdummiesIn.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Mathematical entities", "Manifolds"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.7. Mappings", "Subsubsection"],

Cell["\<\
TODOCUMENT:

DefMapping
InclusionMapping
ImmersionQ
InverseMapping
Mapping
MappingDomain
MappingImage
MappingQ
PullBack
PushForward
SubmersionQ
TangentTensor
$Mappings
UndefMapping\
\>", "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.4. Tensors", "Subsection",
 CellTags->{"Mathematical entities", "Tensors"}],

Cell[CellGroupData[{

Cell["4.4.1. Type", "Subsubsection",
 CellTags->{"Mathematical entities", "Tensors"}],

Cell[TextData[{
 "A symbol ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " with type ",
 StyleBox[ButtonBox["Tensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Tensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represents a smooth tensor field living on some ",
 StyleBox["manifold",
  FontSlant->"Italic"],
 ". If ",
 StyleBox["manifold",
  FontSlant->"Italic"],
 " is 0-dim, then ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " is actually not a field but an algebraic object (in that situation the \
tangent vbundle is trivial, and other \"vbundles\" must be defined).\n\n\
Tensors are defined with ",
 StyleBox[ButtonBox["DefTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined with ",
 StyleBox[ButtonBox["UndefTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The syntax for definition of ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " is ",
 StyleBox["DefTensor[",
  FontFamily->"Courier"],
 StyleBox["tensor",
  FontSlant->"Italic"],
 "[",
 StyleBox["indices",
  FontSlant->"Italic"],
 "], ",
 StyleBox["dependencies",
  FontSlant->"Italic"],
 StyleBox["]",
  FontFamily->"Courier"],
 " for a tensor without symmetries and  ",
 StyleBox["DefTensor[",
  FontFamily->"Courier"],
 StyleBox["tensor",
  FontSlant->"Italic"],
 "[",
 StyleBox["indices",
  FontSlant->"Italic"],
 "], ",
 StyleBox["dependencies",
  FontSlant->"Italic"],
 ", ",
 StyleBox["symmetry",
  FontSlant->"Italic"],
 StyleBox["]",
  FontFamily->"Courier"],
 " in general, where:\n\t",
 StyleBox["indices",
  FontSlant->"Italic"],
 " is the a sequence of abstract indices denoting the type of tensor\n\t",
 StyleBox["dependencies",
  FontSlant->"Italic"],
 " is a list (or a single symbol) containing the manifolds ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " lives on, and/or parameters it depends upon.\n\t",
 StyleBox["symmetry",
  FontSlant->"Italic"],
 " is a generating set or a strong generating set describing the symmetry \
properties of the tensor.\n\nThe list of all currently defined tensors is \
stored in the global variable ",
 StyleBox[ButtonBox["$Tensors",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Tensors.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". All of them have associated upvalues ",
 StyleBox["True",
  FontFamily->"Courier"],
 " for the function ",
 StyleBox[ButtonBox["xTensorQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "xTensorQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input. Note the difference between this function and the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " built-in ",
 StyleBox["TensorQ",
  FontFamily->"Courier"],
 " (new in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.0)."
}], "Text",
 CellTags->{"Tensors", "Mathematical entities"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.4.2. Properties and options", "Subsubsection",
 CellTags->{"Mathematical entities", "Tensors"}],

Cell[TextData[{
 "The slot structure of the tensor (",
 StyleBox[ButtonBox["SlotsOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SlotsOfTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ") is stored as ",
 StyleBox["{-M1, M1, M2, ...}",
  FontFamily->"Courier",
  FontVariations->{"CompatibilityType"->0}],
 ", such that the first slot is a covariant index on manifold M1, the third \
slot is a contravariant index on M2, etc.\n\nThe list ",
 StyleBox["dependencies",
  FontSlant->"Italic"],
 " of manifolds and/or parameters is stored as an upvalue of ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " for the function ",
 StyleBox[ButtonBox["DependenciesOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DependenciesOfTensor.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The order in the list is irrelevant because it is overwritten using the \
private function ",
 StyleBox["SortDependencies",
  FontFamily->"Courier"],
 ", which sorts parameters before manifolds, and uses lexicographic order in \
both sets",
 StyleBox[".",
  FontFamily->"Courier"],
 "If the tensor has no dependencies then use ",
 StyleBox["{}.",
  FontFamily->"Courier"],
 "A tensor is always a tensor field on the manifolds corresponding to its \
indices; that is, we consider that a nonscalar tensor cannot be a constant on \
a given manifold. This is because we need additional structure to show that a \
tensor field does not depend on that manifold (for example a vector field, in \
order to take Lie derivatives). The list of parameter dependencies can be \
obtained with the private function ",
 StyleBox["ParametersOfTensor",
  FontFamily->"Courier"],
 "; the list of manifold dependencies can be obtained with the private \
function ",
 StyleBox["ManifoldsOfTensor",
  FontFamily->"Courier"],
 ".\n\nUsing option ",
 StyleBox[ButtonBox["WeightOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "WeightOfTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (default value 0) we can define tensorial densities, defined as a linear \
combination of bases. The weight is stored as an upvalue of ",
 StyleBox["tensor ",
  FontSlant->"Italic"],
 "for the function ",
 StyleBox[ButtonBox["WeightOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "WeightOfTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Tensor densities are represented in output using Ashtekar's notation: \
weight n positive (negative) is represented adding n tildes above (below) the \
name of the tensor. The tildes are colored according to the bases they \
represent. The weight of a generic expression is computed using ",
 StyleBox[ButtonBox["WeightOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "WeightOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nThe ",
 StyleBox["symmetry",
  FontSlant->"Italic"],
 " description of the tensor is assumed to be a generating set (head ",
 StyleBox["GenSet",
  FontFamily->"Courier"],
 ") or a strong generating set (head ",
 StyleBox["StrongGenSet",
  FontFamily->"Courier"],
 ") of the symmetry group of slot permutations. Simple cases can be \
constructed using the functions ",
 StyleBox["Symmetric",
  FontFamily->"Courier"],
 ", ",
 StyleBox["Antisymmetric",
  FontFamily->"Courier"],
 " and ",
 StyleBox["RiemannSymmetry",
  FontFamily->"Courier"],
 ". The information is always stored as a strong generating set being an \
upvalue of ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " for the function ",
 StyleBox[ButtonBox["SymmetryGroupOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymmetryGroupOfTensor.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Handling of multiterm symmetries through Young tableaux is under \
development, and will be stored using the function ",
 StyleBox[ButtonBox["SymmetryTableauxOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymmetryTableauxOfTensor.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Any perm notation can be used on input, but it will always be changed to ",
 StyleBox["Cycles",
  FontFamily->"Courier"],
 " notation on numeric slots. Different slots belonging to the same orbit of \
the symmetry group must have the same slot structure (same manifold and same \
up/down character) at definition time, but this can be overwritten using the \
option ",
 StyleBox[ButtonBox["ForceSymmetries",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ForceSymmetries.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (default is ",
 StyleBox["False",
  FontFamily->"Courier"],
 ").\n\nUnder complex conjugation (with ",
 StyleBox[ButtonBox["Dagger",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dagger.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ") tensors can behave in four different ways. They can be\n\t- ",
 StyleBox[ButtonBox["Real",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Real.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (the default): the tensor is invariant under complex conjugation.\n\t- ",
 StyleBox[ButtonBox["Imaginary",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Imaginary.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": the tensor changes sign under complex conjugation.\n\t- ",
 StyleBox[ButtonBox["Hermitian",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Hermitian.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": the tensor is invariant under simultaneous complex conjugation of indices \
and exchange of indices between a vbundle and its conjugate.\n\t- ",
 StyleBox[ButtonBox["Complex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Complex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": generic case.\nThis is given through the option ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 " and stored as an upvalue of ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 " for the tensor. There are now also ",
 StyleBox["HermitianQ",
  FontFamily->"Courier"],
 " and ",
 StyleBox["AntihermitianQ",
  FontFamily->"Courier"],
 " (TODOCUMENT).\n\nApart from the usual ",
 StyleBox["DefType",
  FontFamily->"Courier"],
 " options (",
 StyleBox[ButtonBox["DefInfo",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefInfo.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Master",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Master.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["ProtectNewSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProtectNewSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["PrintAs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PrintAs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "), there are other options:\n\t ",
 StyleBox[ButtonBox["FrobeniusQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FrobeniusQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": not functional now\n\t ",
 StyleBox[ButtonBox["OrthogonalTo",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "OrthogonalTo.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": vectors to which the tensor is orthogonal\n\t ",
 StyleBox[ButtonBox["ProjectedWith",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProjectedWith.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": projectors leaving the tensor invariant\n\t ",
 StyleBox[ButtonBox["TensorID",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TensorID.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": information on how to compute components\n\t ",
 StyleBox[ButtonBox["VanishingQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VanishingQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ":  if a tensor vanishes, a delayed definition of the form ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 StyleBox["[___]:=0",
  FontFamily->"Courier"],
 " is set."
}], "Text",
 CellTags->{"Tensors", "Mathematical entities"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.4.3. Special tensors", "Subsubsection",
 CellTags->{"Mathematical entities", "Tensors"}],

Cell[TextData[{
 "There are three heads with special tensorial meaning. Two of them are the \
",
 StyleBox[ButtonBox["delta",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "delta.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and the \"generalized delta\" ",
 StyleBox[ButtonBox["Gdelta",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Gdelta.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " tensors:\n\n",
 StyleBox["delta",
  FontFamily->"Courier"],
 "[-",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 "] is the identity tensor on the vbundle of its indices. The object ",
 StyleBox["delta",
  FontFamily->"Courier"],
 "[",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["-b",
  FontSlant->"Italic"],
 "] is not initially defined, because it is constructed from a the previous \
one and two metric factors. When a (first-) metric is defined, then delta \
inherits all properties of that metric tensor, in particular its symmetry. \
That is, if the metric defined is symmetric, then ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " becomes symmetric, but if the metric is antisymmetric (like in spinor \
calculus), then ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " becomes antisymmetric. If both its indices have the same character, then \
",
 StyleBox["delta",
  FontFamily->"Courier"],
 " is inmediately converted into the first-metric tensor of the vbundle of \
its indices. If one of its indices is a basis index then ",
 StyleBox["delta",
  FontFamily->"Courier"],
 " is converted into ",
 StyleBox[ButtonBox["Basis",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Basis.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is formally equivalent, and hence also inheriting the properties of \
the first-metric.\n\n",
 StyleBox["Gdelta",
  FontFamily->"Courier"],
 "[",
 StyleBox["a1,...,an, -b1,...,-bn",
  FontSlant->"Italic"],
 "] is the generalized delta tensor on any vector bundle. Its first half of \
indices is antisymmetric, and so it is the second half, independently. The \
function ",
 StyleBox[ButtonBox["ExpandGdelta",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExpandGdelta.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " converts the ",
 StyleBox["Gdelta",
  FontFamily->"Courier"],
 " tensor into a linear combination of products of ",
 StyleBox["n",
  FontSlant->"Italic"],
 " ",
 StyleBox["delta",
  FontFamily->"Courier"],
 "'s, as given by a determinant.\n\nThe other one has been created only for \
convenience: ",
 StyleBox[ButtonBox["Zero",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Zero.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represents the 0 tensor, for any indices."
}], "Text",
 CellTags->{"Mathematical entities", "Tensors"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.4.4. Name generation", "Subsubsection",
 CellTags->{"Mathematical entities", "Tensors"}],

Cell[TextData[{
 "There are a number of tensors which are automatically defined. They are \
associated to other objects (vbundles, bases, connections, etc.) and their \
names are constructed using the function ",
 StyleBox[ButtonBox["GiveSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GiveSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", with syntax ",
 StyleBox["GiveSymbol[",
  FontFamily->"Courier"],
 StyleBox["tensor",
  FontSlant->"Italic"],
 ", ",
 StyleBox["object",
  FontSlant->"Italic"],
 StyleBox["]",
  FontFamily->"Courier"],
 ", where ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " is one of the following reserved words:\n\t",
 StyleBox[ButtonBox["epsilon",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "epsilon.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t",
 StyleBox["metric",
  FontSlant->"Italic"],
 "\t\ttotally antisymmetric tensor covariantly constant with respect to the \
metric\n\t",
 StyleBox[ButtonBox["Christoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Christoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t",
 StyleBox["covd",
  FontSlant->"Italic"],
 "\t\tChristoffel symbol associated to the connection covd and the fiducial \
",
 StyleBox[ButtonBox["PD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PD.nb", CharacterEncoding -> "iso8859-1"],
     None}],
  FontFamily->"Courier"],
 "\n\t",
 StyleBox[ButtonBox["AChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AChristoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t",
 StyleBox["covd",
  FontSlant->"Italic"],
 "\t\tinternal Christoffel symbol associated to the connection covd\n\t",
 StyleBox[ButtonBox["Torsion",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Torsion.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t",
 StyleBox["covd",
  FontSlant->"Italic"],
 "\t\ttorsion tensor associated to the connection ",
 StyleBox["covd",
  FontSlant->"Italic"],
 "\n\t",
 StyleBox[ButtonBox["Riemann",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Riemann.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t",
 StyleBox["covd",
  FontSlant->"Italic"],
 "\t\tcurvature tensor associated to the connection ",
 StyleBox["covd\n\t",
  FontSlant->"Italic"],
 StyleBox[ButtonBox["FRiemann",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FRiemann.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t",
 StyleBox["covd",
  FontSlant->"Italic"],
 "\t\tinternal curvature tensor associated to the connection ",
 StyleBox["covd",
  FontSlant->"Italic"],
 "\n\t",
 StyleBox[ButtonBox["Ricci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Ricci.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t\t",
 StyleBox["covd",
  FontSlant->"Italic"],
 "\t\tRicci tensor associated to the connection ",
 StyleBox["covd\n\t",
  FontSlant->"Italic"],
 StyleBox[ButtonBox["TFRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TFRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t",
 StyleBox["metric-covd",
  FontSlant->"Italic"],
 "\tTrace-free Ricci tensor associated to the connection ",
 StyleBox["metric-covd",
  FontSlant->"Italic"],
 "\n\t",
 StyleBox[ButtonBox["RicciScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RicciScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t",
 StyleBox["metric-covd",
  FontSlant->"Italic"],
 "\tRicci scalar associated to the metric connection ",
 StyleBox["metric-covd",
  FontSlant->"Italic"],
 "\n\t",
 StyleBox[ButtonBox["Einstein",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Einstein.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t",
 StyleBox["metric-covd",
  FontSlant->"Italic"],
 "\tEinstein tensor associated to the metric connection ",
 StyleBox["metric-covd",
  FontSlant->"Italic"],
 "\n\t",
 StyleBox[ButtonBox["Weyl",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Weyl.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t\t",
 StyleBox["metric-covd",
  FontSlant->"Italic"],
 "\tWeyl tensor associated to the metric connection ",
 StyleBox["metric-covd",
  FontSlant->"Italic"],
 "\n\t",
 StyleBox[ButtonBox["Projector",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Projector.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t",
 StyleBox["induc-metric",
  FontSlant->"Italic"],
 "\tProjector tensor on a codimension-1 surface with induced metric ",
 StyleBox["induc-metric",
  FontSlant->"Italic"],
 "\n\t",
 StyleBox[ButtonBox["ExtrinsicK",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExtrinsicK.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t\t",
 StyleBox["induc-metric",
  FontSlant->"Italic"],
 "\tExtrinsic curvature tensor of a codimension-1 surface with induced metric \
",
 StyleBox["induc-metric",
  FontSlant->"Italic"],
 "\n\t",
 StyleBox[ButtonBox["Acceleration",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Acceleration.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\t",
 StyleBox["vector",
  FontSlant->"Italic"],
 "\t\tAcceleration of ",
 StyleBox["vector\n",
  FontSlant->"Italic"],
 "The symbol ",
 StyleBox["Christoffel",
  FontFamily->"Courier"],
 " can be also associated to two different covds. Finally we have the head ",
 StyleBox["Determinant",
  FontFamily->"Courier"],
 " to construct the determinant of a metric in a given basis, and hence has \
two arguments (the basis defaults to the special basis ",
 StyleBox["AIndex",
  FontFamily->"Courier"],
 ")."
}], "Text",
 CellTags->{"Mathematical entities", "Tensors"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.5. Covariant derivatives", "Subsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],

Cell[CellGroupData[{

Cell["4.5.1. Internal format for covariant derivatives", "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],

Cell[TextData[{
 "The format for a covariant derivative is ",
 StyleBox["CD[-a][expr]",
  FontFamily->"Courier"],
 ". The double pair of brackets roughly follows ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s structure for derivatives: ",
 StyleBox["f'[x]",
  FontFamily->"Courier"],
 " is represented as ",
 StyleBox["Derivative[1][f][x]",
  FontFamily->"Courier"],
 ", separating the derivative operator ",
 StyleBox["Derivative[1]",
  FontFamily->"Courier"],
 " from the object being differentiated. However we do not want to \
distinguish between the differentiation operator (",
 StyleBox["D",
  FontFamily->"Courier"],
 ") and the internal representation for a derivative (",
 StyleBox["Derivative",
  FontFamily->"Courier"],
 "). Nor we can separate the abstract object being differentiated (",
 StyleBox["f",
  FontFamily->"Courier"],
 ") from the field variable or the indices (that would require a complete \
change of philosophy in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 "). All this means that higher derivatives must be stored as nested \
derivatives: ",
 StyleBox["CD[-a][CD[-b][expr]]",
  FontFamily->"Courier"],
 ". This is natural with respect to the multiple possible derivative \
operators, but has several drawbacks:\n\t1. Many pairs of brackets are \
needed. This is partially alleviated using the prefix notation ",
 StyleBox["CD[-a]@CD[-b]@expr",
  FontFamily->"Courier"],
 ".\n\t2. Even though ",
 StyleBox["CD[-a][T[-b]]",
  FontFamily->"Courier"],
 " is a tensor, as well as ",
 StyleBox["T[-b]",
  FontFamily->"Courier"],
 ", the notations are very different. Every function acting on tensorial \
inputs must be prepared to receive a covariant derivative.\n\t3. Rules for ",
 StyleBox["T[-a]",
  FontFamily->"Courier"],
 " will be replaced in derivatives of ",
 StyleBox["T[-a]",
  FontFamily->"Courier"],
 ". This can be considered a drawback or an advantage, depending on the case.\
\n\t4. Because of the depth restriction in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", rules for second-or-higher derivatives of ",
 StyleBox["T[-a]",
  FontFamily->"Courier"],
 " cannot be upvalues for ",
 StyleBox["T",
  FontFamily->"Courier"],
 ".\nThis could be extended to other simpler formats in future versions if \
required by a large fraction of the users of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ".\n\nSince 0.9.7 this is partially solved by the commands ",
 StyleBox["Implode",
  FontFamily->"Courier"],
 " and ",
 StyleBox["Explode",
  FontFamily->"Courier"],
 " (TODOCUMENT)."
}], "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.5.2. Type", "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],

Cell[TextData[{
 "A symbol ",
 StyleBox["covd",
  FontSlant->"Italic"],
 " with type ",
 StyleBox[ButtonBox["CovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represents a smooth connection or covariant derivative living on some ",
 StyleBox["manifold",
  FontSlant->"Italic"],
 ", and acting on tensor fields with indices in some ",
 StyleBox["vbundle",
  FontSlant->"Italic"],
 " having that ",
 StyleBox["manifold",
  FontSlant->"Italic"],
 " as base.  If ",
 StyleBox["manifold",
  FontSlant->"Italic"],
 " is 0-dim then connections are not allowed. Rather than working with a \
single derivative operator and Christoffel symbols for different derivatives, \
we define different derivative operators for different connections, following \
Wald.\n\nCovariant derivatives are defined with ",
 StyleBox[ButtonBox["DefCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined with ",
 StyleBox[ButtonBox["UndefCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The syntax for definition of ",
 StyleBox["covd",
  FontSlant->"Italic"],
 " is ",
 StyleBox["DefCovD",
  FontFamily->"Courier"],
 "[",
 StyleBox["covd",
  FontSlant->"Italic"],
 "[",
 StyleBox["-a",
  FontSlant->"Italic"],
 "], ",
 StyleBox["symbol",
  FontSlant->"Italic"],
 "] or  ",
 StyleBox["DefCovD",
  FontFamily->"Courier"],
 "[",
 StyleBox["covd",
  FontSlant->"Italic"],
 "[",
 StyleBox["-a",
  FontSlant->"Italic"],
 "], ",
 StyleBox["vbundle, symbol",
  FontSlant->"Italic"],
 "], where:\n\t",
 StyleBox["a",
  FontSlant->"Italic"],
 " is an index on a tangent vbundle which identifies the manifold where the \
covariant derivative lives.\n\t",
 StyleBox["vbundle",
  FontSlant->"Italic"],
 " is the vbundle on which the covariant derivative acts. If not given it is \
assumed to be the (tangent) vbundle of the index ",
 StyleBox["a",
  FontSlant->"Italic"],
 ".\n\t",
 StyleBox["symbol",
  FontSlant->"Italic"],
 " is a list containing two strings: the first / last one gives the ",
 StyleBox["\"Postfix\"",
  FontFamily->"Courier"],
 " / ",
 StyleBox["\"Prefix\"",
  FontFamily->"Courier"],
 " output in StandardForm. This argument is kept for backwards compatibility, \
but it has been replaced in version 0.9.8 by the option ",
 StyleBox["SymbolOfCovD",
  FontFamily->"Courier"],
 " with default ",
 StyleBox["{\";\", \"\[EmptyDownTriangle]\"}",
  FontFamily->"Courier"],
 ".\n\nThe list of all currently defined covariant derivatives is stored in \
the global variable ",
 StyleBox[ButtonBox["$CovDs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CovDs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". All of them have associated upvalues ",
 StyleBox["True",
  FontFamily->"Courier"],
 " for the function ",
 StyleBox[ButtonBox["CovDQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CovDQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input. Do not confuse ",
 StyleBox["CovDQ",
  FontFamily->"Courier"],
 " with ",
 StyleBox["FirstDerQ",
  FontFamily->"Courier"],
 ", to be explained below."
}], "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.5.2. Properties and options", "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],

Cell[TextData[{
 "The manifold on which the connection lives is stored as an upvalue for ",
 StyleBox["covd",
  FontSlant->"Italic"],
 " of the function  ",
 StyleBox[ButtonBox["ManifoldOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ManifoldOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". It is currently not possible in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " to define a parameter dependency for a connection. The list of ",
 StyleBox["vbundles",
  FontSlant->"Italic"],
 " on which the connection acts is stored as an upvalue for ",
 StyleBox["covd",
  FontSlant->"Italic"],
 " of the function ",
 StyleBox[ButtonBox["VBundlesOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundlesOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (the first one is always the tangent vbundle of that ",
 StyleBox["manifold)",
  FontSlant->"Italic"],
 ". The ",
 StyleBox["symbol",
  FontSlant->"Italic"],
 " of ",
 StyleBox["covd",
  FontSlant->"Italic"],
 " is stored as an upvalue of ",
 StyleBox[ButtonBox["SymbolOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymbolOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Which of the  ",
 StyleBox["\"Postfix\"",
  FontFamily->"Courier"],
 " / ",
 StyleBox["\"Prefix\"",
  FontFamily->"Courier"],
 " formats is used is decided by the global variable ",
 StyleBox[ButtonBox["$CovDFormat",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CovDFormat.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". A number of options are possible at definition time, concerning whether \
the covariant derivative has or not ",
 StyleBox[ButtonBox["Torsion",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Torsion.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Curvature",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Curvature.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " or derives ",
 StyleBox[ButtonBox["FromMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FromMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", among other. The information related to these options is stored as \
upvalues for ",
 StyleBox["covd",
  FontSlant->"Italic"],
 " of the functions ",
 StyleBox[ButtonBox["TorsionQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TorsionQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["CurvatureQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CurvatureQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["MetricOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", respectively. Another option is ",
 StyleBox[ButtonBox["CurvatureRelations",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CurvatureRelations.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which determines whether the contractions of the ",
 StyleBox["Riemann",
  FontFamily->"Courier"],
 " tensor must be replaced by the ",
 StyleBox["Ricci",
  FontFamily->"Courier"],
 " tensor, and the contractions of ",
 StyleBox["Ricci",
  FontFamily->"Courier"],
 " by the ",
 StyleBox["RicciScalar",
  FontFamily->"Courier"],
 ". When this option is set to False then those relations must be explicitly \
implemented using the function ",
 StyleBox[ButtonBox["ContractCurvature",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractCurvature.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Another option is ",
 StyleBox[ButtonBox["ExtendedFrom",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExtendedFrom.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which allows defining a derivative acting on an inner vbundle and whose \
action on the corresponding tangent vbundle is exactly that of a previously \
defined covariant derivative. Finally, Levi-Civita connections can be \
modified to act on densities associated to a given basis, specified through \
the option ",
 StyleBox[ButtonBox["WeightedWithBasis",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "WeightedWithBasis.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", typically used through ",
 StyleBox["DefMetric",
  FontFamily->"Courier"],
 ".\n\nNow covariant derivatives also have symmetry: ",
 StyleBox["SymmetryGroupOfCovD",
  FontFamily->"Courier"],
 " (TODOCUMENT).\n\nAll connections are assumed to be real, and so there is \
no need to use the ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 " option.\n\nAs usual, there are also the options ",
 StyleBox[ButtonBox["ProtectNewSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProtectNewSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Master",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Master.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["DefInfo",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefInfo.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.5.3. The fiducial derivative", "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],

Cell[TextData[{
 "The space of covariant derivatives is an affine space, with no preferred \
point. It is customary, however, to choose as origin for this space a \
particular but unspecified ordinary derivative. We will call it ",
 StyleBox[ButtonBox["PD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PD.nb", CharacterEncoding -> "iso8859-1"],
     None}],
  FontFamily->"Courier"],
 ". It has zero torsion and zero curvature. By convention, it is the origin \
for Christoffel tensors, as we will see below. These \"partial derivatives\" \
are not automatically commuted (see below how to do it). The canonicalization \
process has the option ",
 StyleBox[ButtonBox["CommutePDs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CommutePDs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (default ",
 StyleBox["True",
  FontFamily->"Courier"],
 ") to control this issue. There is no metric associated to ",
 StyleBox["PD",
  FontFamily->"Courier"],
 " by default, but the user can add it.\n\nThe PD derivative is associated to \
a ficticious coordinated basis called ",
 StyleBox["AIndex",
  FontFamily->"Courier"],
 ", which is also the default basis to construct densities."
}], "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.5.4. Associated tensors", "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],

Cell[TextData[{
 "A number of tensors are automatically associated to each derivative: ",
 StyleBox[ButtonBox["Torsion",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Torsion.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Riemann",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Riemann.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Ricci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Ricci.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and the ",
 StyleBox[ButtonBox["Christoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Christoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " tensor relating it to the fiducial ",
 StyleBox[ButtonBox["PD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PD.nb", CharacterEncoding -> "iso8859-1"],
     None}],
  FontFamily->"Courier"],
 ". If the derivative comes from a metric then we have additionally: ",
 StyleBox[ButtonBox["TFRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TFRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["RicciScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RicciScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Einstein",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Einstein.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Weyl",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Weyl.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". If the derivative acts on an inner vbundle then the tensors ",
 StyleBox[ButtonBox["FRiemann",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FRiemann.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["AChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AChristoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " are also automatically associated. What follows is valid for all those \
tensors but we use the example of ",
 StyleBox["Torsion",
  FontFamily->"Courier"],
 ": the torsion tensor associated to a connection ",
 StyleBox["CD",
  FontSlant->"Italic"],
 " is denoted with the symbol ",
 StyleBox["TorsionCD",
  FontSlant->"Italic"],
 " and this is done by calling the function ",
 StyleBox["GiveSymbol",
  FontFamily->"Courier"],
 "[",
 StyleBox["Torsion",
  FontFamily->"Courier"],
 ", ",
 StyleBox["CD",
  FontSlant->"Italic"],
 "], whose behaviour can be freely chosen. We can also use ",
 StyleBox["Torsion",
  FontFamily->"Courier"],
 "[",
 StyleBox["CD",
  FontSlant->"Italic"],
 "][",
 StyleBox["inds",
  FontSlant->"Italic"],
 "], which is automatically converted into ",
 StyleBox["GiveSymbol",
  FontFamily->"Courier"],
 "[",
 StyleBox["Torsion",
  FontFamily->"Courier"],
 ", ",
 StyleBox["CD",
  FontSlant->"Italic"],
 "][",
 StyleBox["inds",
  FontSlant->"Italic"],
 "] and hence, by default, into ",
 StyleBox["TorsionCD",
  FontSlant->"Italic"],
 "[",
 StyleBox["inds",
  FontSlant->"Italic"],
 "].\n\nThe ",
 StyleBox[ButtonBox["Christoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Christoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " tensor is special because it is actually associated to two covariant \
derivatives and can be denoted as ",
 StyleBox["Christoffel",
  FontFamily->"Courier"],
 "[",
 StyleBox["CD1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["CD2",
  FontSlant->"Italic"],
 "][",
 StyleBox["inds",
  FontSlant->"Italic"],
 "] (antisymmetric in the derivatives), which we call the Christoffel of ",
 StyleBox["CD1",
  FontSlant->"Italic"],
 " from ",
 StyleBox["CD2",
  FontSlant->"Italic"],
 ". By ",
 StyleBox["Christoffel",
  FontFamily->"Courier"],
 "[",
 StyleBox["CD",
  FontSlant->"Italic"],
 "][",
 StyleBox["inds",
  FontSlant->"Italic"],
 "] we understand ",
 StyleBox["Christoffel",
  FontFamily->"Courier"],
 "[",
 StyleBox["CD",
  FontSlant->"Italic"],
 ", ",
 StyleBox["PD",
  FontFamily->"Courier"],
 "][",
 StyleBox["inds",
  FontSlant->"Italic"],
 "]. The expression ",
 StyleBox["Christoffel",
  FontFamily->"Courier"],
 "[",
 StyleBox["CD1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["CD2",
  FontSlant->"Italic"],
 "][",
 StyleBox["inds",
  FontSlant->"Italic"],
 "] is automatically converted into the tensor ",
 StyleBox["ChristoffelCD1CD2",
  FontSlant->"Italic"],
 "[",
 StyleBox["inds",
  FontSlant->"Italic"],
 "] if {",
 StyleBox["CD1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["CD2",
  FontSlant->"Italic"],
 "} are sorted lexicographically or into -",
 StyleBox["ChristoffelCD2CD1",
  FontSlant->"Italic"],
 "[",
 StyleBox["inds",
  FontSlant->"Italic"],
 "] in the opposite case. The tensor is defined during the process if it did \
not exist before. The derivative ",
 StyleBox["PD",
  FontFamily->"Courier"],
 " is always sorted last. Any Christoffel tensor (of ",
 StyleBox["CD1",
  FontSlant->"Italic"],
 " from ",
 StyleBox["CD2",
  FontSlant->"Italic"],
 ") can be rewritten using the function ",
 StyleBox[ButtonBox["BreakChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BreakChristoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " as the sum of two Christoffel tensors, the first of ",
 StyleBox["CD1",
  FontSlant->"Italic"],
 " from ",
 StyleBox["CD3",
  FontSlant->"Italic"],
 " and the second of ",
 StyleBox["CD3",
  FontSlant->"Italic"],
 " from ",
 StyleBox["CD2",
  FontSlant->"Italic"],
 ", for any ",
 StyleBox["CD3",
  FontSlant->"Italic"],
 " on the same manifold as ",
 StyleBox["CD1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["CD2",
  FontSlant->"Italic"],
 ".\n\nNot any two covariant derivatives can be related via a Christoffel \
tensor. This is only possible if the derivatives are \"compatible\" (checked \
with the private function ",
 StyleBox["CompatibleCovDsQ",
  FontFamily->"Courier"],
 "): they act on the same base manifold and they share the vbundles or at \
least one of them does not act on any inner vbundle.\n",
 "\n",
 "We need several commands to change the order of derivatives acting on a \
tensor. The command ",
 StyleBox[ButtonBox["CommuteCovDs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CommuteCovDs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " exchanges the order of two (equal) derivatives identified by the user \
through their respective indices. ",
 StyleBox[ButtonBox["SortCovDs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SortCovDs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " brings the derivative operators to canonical order of their indices. \
Commands ",
 StyleBox[ButtonBox["SortCovDsStart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SortCovDsStart.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["SortCovDsStop",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SortCovDsStop.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " turn on and off, respectively, the automatization of the function ",
 StyleBox["SortCovDs",
  FontFamily->"Courier"],
 ". The canonicalization routines commute equal covds on scalars by default, \
but this behaviour can be changed using ",
 StyleBox[ButtonBox["$CommuteCovDsOnScalars",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CommuteCovDsOnScalars.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".",
 "\n\n",
 "There is a number of commands which change some tensors into equivalent \
expressions. These are: ",
 StyleBox[ButtonBox["ChangeCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (previously known as ",
 StyleBox[ButtonBox["CovDToChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CovDToChristoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "), ",
 StyleBox[ButtonBox["ChangeTorsion",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeTorsion.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (previously known as ",
 StyleBox[ButtonBox["TorsionToChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TorsionToChristoffel.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 "), ",
 StyleBox[ButtonBox["ChangeCurvature",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeCurvature.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (previously known as ",
 StyleBox[ButtonBox["RiemannToChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RiemannToChristoffel.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 "), and the pairs ",
 StyleBox[ButtonBox["RiemannToWeyl",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RiemannToWeyl.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " / ",
 StyleBox[ButtonBox["WeylToRiemman",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "WeylToRiemann.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["RicciToEinstein",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RicciToEinstein.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " / ",
 StyleBox[ButtonBox["EinsteinToRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "EinsteinToRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["RicciToTFRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RicciToTFRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " / ",
 StyleBox[ButtonBox["TFRicciToRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TFRicciToRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". When there is a metric we also have the pair ",
 StyleBox[ButtonBox["ChristoffelToGradMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChristoffelToGradMetric.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " / ",
 StyleBox[ButtonBox["GradMetricToChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GradMetricToChristoffel.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (the first of the pair was previously known as ",
 StyleBox[ButtonBox["ChristoffelToMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChristoffelToMetric.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ").",
 "\n\n",
 "Finally, there are several variables controlling convention signs: ",
 StyleBox[ButtonBox["$RiemannSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$RiemannSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["$RicciSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$RicciSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["$TorsionSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$TorsionSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". We will find some more of these later."
}], "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.5.5. Dependencies", "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],

Cell[TextData[{
 "Each derivative lives on a given manifold. On objects not having that \
manifold as a dependency the derivative gives zero. Checking this fact takes \
some time and ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " does not do it automatically. The function ",
 StyleBox[ButtonBox["CheckZeroDerivative",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CheckZeroDerivative.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " is in charge of that, and its action can be automatized using ",
 StyleBox[ButtonBox["CheckZeroDerivativeStart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CheckZeroDerivativeStart.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["CheckZeroDerivativeStop",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CheckZeroDerivativeStop.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The global variable ",
 StyleBox[ButtonBox["$CheckZeroDerivativeVerbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CheckZeroDerivativeVerbose.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " turns on/off the messages reporting when ",
 StyleBox["CheckZeroDerivative",
  FontFamily->"Courier"],
 " is being used and on which object.\n\nDependencies of an expression are \
computed as follows:\n\ta) dependencies of a sum or a product are the union \
of the dependencies of its terms or factors.\n\tb) dependencies of a tensor \
are the union of those of its head (",
 StyleBox["DependenciesOfTensor",
  FontFamily->"Courier"],
 ") and those of its indices (private function ",
 StyleBox["DependenciesOfIndex",
  FontFamily->"Courier"],
 ").\n\tc) dependencies of a covariant derivative are the union of those of \
its head (",
 StyleBox["DependenciesOfCovD",
  FontFamily->"Courier"],
 "), its index and those of the expression being differentiated.\n\td) other \
structures do not add dependencies. Use upvalues for ",
 StyleBox["DependenciesOf",
  FontFamily->"Courier"],
 " to overwrite this behaviour."
}], "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.6. Metrics", "Subsection",
 CellTags->{"Mathematical entities", "Metrics"}],

Cell[CellGroupData[{

Cell["4.6.1. Type", "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],

Cell[TextData[{
 "A symbol ",
 StyleBox["metric",
  FontSlant->"Italic"],
 " with type ",
 StyleBox[ButtonBox["Metric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Metric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represents a smooth 2-symmetric field living on some ",
 StyleBox["manifold",
  FontSlant->"Italic"],
 ".\n\nMetrics are defined with ",
 StyleBox[ButtonBox["DefMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined with ",
 StyleBox[ButtonBox["UndefMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The syntax for definition of ",
 StyleBox["metric",
  FontSlant->"Italic"],
 " is ",
 StyleBox["DefMetric[",
  FontFamily->"Courier"],
 StyleBox["signdet, metric",
  FontSlant->"Italic"],
 "[",
 StyleBox["-a, -b",
  FontSlant->"Italic"],
 "], ",
 StyleBox["covd, covdsymbols",
  FontSlant->"Italic"],
 "], where:\n\t",
 StyleBox["signdet",
  FontSlant->"Italic"],
 " gives information on the signature of the metric: it is either 0, 1, -1 or \
a list of integers {pluses, minuses, zeroes}\n\t",
 StyleBox["-a, -b",
  FontSlant->"Italic"],
 " are covariant abstract indices on the vbundle where ",
 StyleBox["metric",
  FontSlant->"Italic"],
 " is being defined\n\t",
 StyleBox["covd",
  FontSlant->"Italic"],
 " is the Levi-Civita connection associated to ",
 StyleBox["metric",
  FontSlant->"Italic"],
 ", with symbols ",
 StyleBox["covdsymbols ",
  FontSlant->"Italic"],
 "(this argument is kept for backwards compatibility. Use the option ",
 StyleBox["SymbolOfCovD",
  FontFamily->"Courier"],
 ").",
 "\n\nThe list of all currently defined metrics is stored in the global \
variable ",
 StyleBox[ButtonBox["$Metrics",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Metrics.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". All of them have associated upvalues ",
 StyleBox["True",
  FontFamily->"Courier"],
 " for the function ",
 StyleBox[ButtonBox["MetricQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input."
}], "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.6.2. Properties and options", "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],

Cell[TextData[{
 "A metric is always defined on a given vbundle (that of its abstract indices \
at definition time), which is stored as an upvalue for the function ",
 StyleBox[ButtonBox["VBundleOfMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundleOfMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". However, a vbundle can have several metrics (stored in the function ",
 StyleBox[ButtonBox["MetricsOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricsOfVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "). A vbundle with at least one metric gives ",
 StyleBox["True",
  FontFamily->"Courier"],
 " under the function ",
 StyleBox[ButtonBox["MetricEndowedQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricEndowedQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", and ",
 StyleBox["False",
  FontFamily->"Courier"],
 " if it has not got any metric. If there are several metrics only the first \
one will be used to raise and lower indices; all other metrics are called \
\"frozen\" and do not have all the expected properties for the first-metric. \
In particular, the inverse of a frozen metric ",
 StyleBox["frozen",
  FontSlant->"Italic"],
 "[",
 StyleBox["-a, -b",
  FontSlant->"Italic"],
 "] is not ",
 StyleBox["frozen",
  FontSlant->"Italic"],
 "[a, b] (which is actually ",
 StyleBox["g",
  FontSlant->"Italic"],
 "[",
 StyleBox["a, c",
  FontSlant->"Italic"],
 "] ",
 StyleBox["g",
  FontSlant->"Italic"],
 "[",
 StyleBox["b, d",
  FontSlant->"Italic"],
 "] ",
 StyleBox["frozen",
  FontSlant->"Italic"],
 "[",
 StyleBox["-c, -d",
  FontSlant->"Italic"],
 "], with ",
 StyleBox["g",
  FontSlant->"Italic"],
 " being the first-metric), but is defined as ",
 StyleBox["Invfrozen",
  FontSlant->"Italic"],
 "[",
 StyleBox["a, b",
  FontSlant->"Italic"],
 "], using the head ",
 StyleBox[ButtonBox["Inv",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Inv.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nEvery metric has a unique torsionless covariant derivative, called its \
Levi-Civita connection and stored as an upvalue of the metric for the \
function ",
 StyleBox[ButtonBox["CovDOfMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CovDOfMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Covariant derivatives can be or not associated to a metric, and this is \
stored in the function ",
 StyleBox[ButtonBox["MetricOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which returns ",
 StyleBox["Null",
  FontFamily->"Courier"],
 " if the connection does not derive from a metric. If this associated \
connection is flat then we say that the metric is flat, and this can be \
specified at definition time with the Boolean option ",
 StyleBox[ButtonBox["FlatMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FlatMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", whose value is stored as an upvalue for ",
 StyleBox[ButtonBox["FlatMetricQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FlatMetricQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nThe only invariant information associated to a metric is its \
signature, defined as a list of +1's, -1's and 0`s, which can be specified at \
definition time as the first argument of ",
 StyleBox["DefMetric",
  FontFamily->"Courier"],
 ", and is stored as an upvalue for the function ",
 StyleBox[ButtonBox["SignatureOfMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SignatureOfMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The product of those numbers is the sign of the determinant of the metric \
(in any basis), and is given by the function ",
 StyleBox[ButtonBox["SignDetOfMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SignDetOfMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nAssociated to the metric we have the ",
 StyleBox[ButtonBox["epsilon",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "epsilon.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " tensor, the uniquely defined (up to global constant) totally antisymmetric \
tensor. Its global sign is given by the variable ",
 StyleBox[ButtonBox["$epsilonSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$epsilonSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The curvature tensors associated to the metric are actually those \
associated to its Levi-Civita connection (",
 StyleBox[ButtonBox["Riemann",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Riemann.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["Ricci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Ricci.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "). Having a metric gives us a number of additional curvature tensors: ",
 StyleBox[ButtonBox["RicciScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RicciScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Einstein",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Einstein.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["TFRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TFRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["Weyl",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Weyl.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". There is also the ",
 StyleBox["Tetra",
  FontFamily->"Courier"],
 " tensor, and its rule in terms of the metric and ",
 StyleBox["epsilon",
  FontFamily->"Courier"],
 " tensors, called ",
 StyleBox["TetraRule",
  FontFamily->"Courier"],
 " (TODOCUMENT)."
}], "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.6.3. Product metrics", "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],

Cell[TextData[{
 "Given a number of vbundles with their respective metrics, it is possible to \
define a block-form \"product-metric\" of them using the syntax ",
 StyleBox[ButtonBox["DefProductMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefProductMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "[",
 StyleBox["metric",
  FontSlant->"Italic"],
 "[",
 StyleBox["-a, -b",
  FontSlant->"Italic"],
 "], { {",
 StyleBox["vbundle1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["scalar1",
  FontSlant->"Italic"],
 "[]}, {",
 StyleBox["vbundle2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["scalar2",
  FontSlant->"Italic"],
 "[]}, ... }, ",
 StyleBox["covd",
  FontSlant->"Italic"],
 ", ",
 StyleBox["covdsymbol",
  FontSlant->"Italic"],
 "], where:\n\t",
 StyleBox["metric",
  FontSlant->"Italic"],
 "[",
 StyleBox["-a, -b",
  FontSlant->"Italic"],
 "] is the metric being defined, with indices on a previously defined \
sum-vbundle\n\t",
 StyleBox["scalar1",
  FontSlant->"Italic"],
 "[] is a scalar field on the base manifolds of ",
 StyleBox["vbundle2, ...",
  FontSlant->"Italic"],
 ", but not of ",
 StyleBox["vbundle1\n\tcovd",
  FontSlant->"Italic"],
 " is the Levi-Civita connection of ",
 StyleBox["metric\n\tcovdsymbol",
  FontSlant->"Italic"],
 " is the pair of symbols used for ",
 StyleBox["covd",
  FontSlant->"Italic"],
 " in ",
 StyleBox["StandardForm",
  FontFamily->"Courier"],
 "\nThe defined metric is, essentially,\n\t",
 StyleBox["scalar1",
  FontSlant->"Italic"],
 "[]^2 ",
 StyleBox["metric1",
  FontSlant->"Italic"],
 "[., .] + ",
 StyleBox["scalar2",
  FontSlant->"Italic"],
 "[]^2 ",
 StyleBox["metric2",
  FontSlant->"Italic"],
 "[., .]",
 " + ...\nwith ",
 StyleBox["metric1",
  FontSlant->"Italic"],
 " being the first-metric of ",
 StyleBox["vbundle1",
  FontSlant->"Italic"],
 ", etc. The scalars are stored using the function ",
 StyleBox[ButtonBox["MetricScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The list of defined all product-metrics is given by the global variable \
",
 StyleBox[ButtonBox["$ProductMetrics",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ProductMetrics.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and it is always a subset of the metrics in ",
 StyleBox[ButtonBox["$Metrics",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Metrics.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nThe function ",
 StyleBox[ButtonBox["ExpandProductMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExpandProductMetric.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " converts objects associated to the product-metric into combinations of the \
objects associated to the sub-metrics."
}], "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.6.4. Induced metrics", "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],

Cell[TextData[{
 "Given a metric field ",
 StyleBox["g",
  FontSlant->"Italic"],
 " and a surface-orthogonal (see ",
 StyleBox[ButtonBox["FrobeniusQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FrobeniusQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ") vector field ",
 StyleBox["v",
  FontSlant->"Italic"],
 ", it is possible to induce a metric ",
 StyleBox["h",
  FontSlant->"Italic"],
 " on that surface. This structure can be defined using the option ",
 StyleBox[ButtonBox["InducedFrom",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "InducedFrom.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " of ",
 StyleBox["DefMetric",
  FontFamily->"Courier"],
 ". The association with the vector field ",
 StyleBox["v",
  FontSlant->"Italic"],
 " is stored in ",
 StyleBox[ButtonBox["VectorOfInducedMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VectorOfInducedMetric.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". It is only possible to associate induced metrics to the first-metric of a \
vbundle. Induced metrics are never considered frozen metrics.\n\nWorking with \
induced metrics is based on the use of four objects:\n\t- The projector onto \
the hypersuface. There is an inert-head acting as a formal projector, and \
this is constructed using the head ",
 StyleBox[ButtonBox["Projector",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Projector.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and the name of the induced metric. The projector ",
 StyleBox["h",
  FontSlant->"Italic"],
 "[",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["-b",
  FontSlant->"Italic"],
 "] can be introduce using ",
 StyleBox[ButtonBox["ProjectWith",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProjectWith.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "[",
 StyleBox["h",
  FontSlant->"Italic"],
 "], and can be converted into a tensorial expression ",
 StyleBox["g",
  FontSlant->"Italic"],
 "[",
 StyleBox["a, -b",
  FontSlant->"Italic"],
 "] - ",
 StyleBox["v",
  FontSlant->"Italic"],
 "[",
 StyleBox["a",
  FontSlant->"Italic"],
 "] ",
 StyleBox["v",
  FontSlant->"Italic"],
 "[",
 StyleBox["-b",
  FontSlant->"Italic"],
 "] / ",
 StyleBox["norm",
  FontSlant->"Italic"],
 " (where ",
 StyleBox["norm",
  FontSlant->"Italic"],
 " is the norm of ",
 StyleBox["v",
  FontSlant->"Italic"],
 " in the metric ",
 StyleBox["g",
  FontSlant->"Italic"],
 ") using ",
 StyleBox[ButtonBox["ProjectorToMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProjectorToMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and its inverse ",
 StyleBox[ButtonBox["MetricToProjector",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricToProjector.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Any tensor can be decomposed in parts which are parallel or orthogonal to \
",
 StyleBox["v",
  FontSlant->"Italic"],
 " using ",
 StyleBox[ButtonBox["InducedDecomposition",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "InducedDecomposition.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\t-  As with any other metric, ",
 StyleBox["h",
  FontSlant->"Italic"],
 " has an associated Levi-Civita connection, but in this case this operator \
is a true derivative only when acting on tensors orthogonal to ",
 StyleBox["v",
  FontSlant->"Italic"],
 ". This connection can be expressed in terms of the connection of ",
 StyleBox["g",
  FontSlant->"Italic"],
 " and projectors using ",
 StyleBox[ButtonBox["ProjectDerivative",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProjectDerivative.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The \"ambient\" connection can be also expressed in terms of the induced \
derivative plus a Lie derivative and extrinsic curvature terms using the \
function ",
 StyleBox[ButtonBox["ToInducedDerivative",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ToInducedDerivative.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\t- The ",
 StyleBox[ButtonBox["Acceleration",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Acceleration.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " vector of ",
 StyleBox["v",
  FontSlant->"Italic"],
 ". Its sign is given by a convention stored in the variable ",
 StyleBox[ButtonBox["$AccelerationSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$AccelerationSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\t- The extrinsic curvature of ",
 StyleBox["h",
  FontSlant->"Italic"],
 ", formed with the symbol ",
 StyleBox[ButtonBox["ExtrinsicK",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExtrinsicK.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Its sign is given by a convention stored in the variable ",
 StyleBox[ButtonBox["$ExtrinsicKSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ExtrinsicKSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". It is possible to change from the extrinsic curvature tensor to \
derivatives of ",
 StyleBox["v",
  FontSlant->"Italic"],
 " using the function ",
 StyleBox[ButtonBox["ExtrinsicKToGradNormal",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExtrinsicKToGradNormal.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and its inverse ",
 StyleBox[ButtonBox["GradNormalToExtrinsicK",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GradNormalToExtrinsicK.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". In terms of these objects, and using all previous functions, it is \
possible to decompose the Riemann tensor into projected objects, using the ",
 StyleBox["GaussCodazzi",
  FontFamily->"Courier"],
 " function (TODOCUMENT)."
}], "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.6.5. Metric contraction", "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],

Cell[TextData[{
 "Given the metric ",
 StyleBox["g",
  FontSlant->"Italic"],
 "[",
 StyleBox["-a, -b",
  FontSlant->"Italic"],
 "] and the vector field ",
 StyleBox["T",
  FontSlant->"Italic"],
 "[",
 StyleBox["b",
  FontSlant->"Italic"],
 "], it is customary to denote the expression ",
 StyleBox["g",
  FontSlant->"Italic"],
 "[-",
 StyleBox["a",
  FontSlant->"Italic"],
 ", -",
 StyleBox["b",
  FontSlant->"Italic"],
 "]",
 StyleBox["T",
  FontSlant->"Italic"],
 "[",
 StyleBox["b",
  FontSlant->"Italic"],
 "] as ",
 StyleBox["T",
  FontSlant->"Italic"],
 "[-",
 StyleBox["a",
  FontSlant->"Italic"],
 "], and the change from the former to the latter is called \"contraction\" \
in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ". Contractions with a metric are never automatic (compare with the \
automatic contraction of ",
 StyleBox["delta",
  FontFamily->"Courier"],
 "), and are inforced using the command ",
 StyleBox[ButtonBox["ContractMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The inverse operation is implemented in ",
 StyleBox[ButtonBox["SeparateMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SeparateMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". When there are several metrics on the same vbundle, only the first-metric \
can be contracted and separated. All other metrics are called \"frozen\".\n\n\
There are two options for ",
 StyleBox["ContractMetric",
  FontFamily->"Courier"],
 ": ",
 StyleBox[ButtonBox["OverDerivatives",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "OverDerivatives.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["AllowUpperDerivatives",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AllowUpperDerivatives.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", with obvious meanings.\n\nA second form of separating metrics is using \
the function ",
 StyleBox[ButtonBox["SetCharacters",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SetCharacters.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which introduces metric factors to change the characters of the indices \
of one or several tensors."
}], "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.6.6. Conformal relations", "Subsubsection"],

Cell[TextData[{
 "After declaring a metric ",
 StyleBox["g",
  FontSlant->"Italic"],
 " we can define other metric ",
 StyleBox["g2",
  FontSlant->"Italic"],
 " to be conformal to ",
 StyleBox["g",
  FontSlant->"Italic"],
 ". This can be done using the option ",
 StyleBox["ConformalTo",
  FontFamily->"Courier"],
 " (TODOCUMENT) of ",
 StyleBox["DefMetric",
  FontFamily->"Courier"],
 ", with syntax ",
 StyleBox["ConformalTo",
  FontFamily->"Courier"],
 "->{g[-a, -b], f[]} meaning that g2[-a,-b]==f[] g[-a,-b]. The same can be \
achieved a posteriori by using the command (TODOCUMENT) ",
 StyleBox["SetConformalTo",
  FontFamily->"Courier"],
 "[g2[-a, -b], {g[-a, -b], f[]}]. The information is stored in two places: \
first we will have the following upvalues of ",
 StyleBox["g2",
  FontSlant->"Italic"],
 " for the function ",
 StyleBox["ConformalFactor",
  FontFamily->"Courier"],
 " (TODOCUMENT): ",
 StyleBox["ConformalFactor",
  FontFamily->"Courier"],
 "[g2, g] = f[] and ",
 StyleBox["ConformalFactor",
  FontFamily->"Courier"],
 "[g, g2]= 1/f[]. Then we will store the actual transformation rules for the \
metrics and their inverses as respective upvalues of g2 for the function ",
 StyleBox["ConformalRules",
  FontFamily->"Courier"],
 " (TODOCUMENT).\n\nIn practical computations we need to know the relation \
between the Christoffel tensors of the two metrics related by conformal \
transformations. This is implemented using the command (TODOCUMENT) ",
 StyleBox["ChristoffelToGradConformal",
  FontFamily->"Courier"],
 "[expr, g, g2] to transform the Christoffels of ",
 StyleBox["g",
  FontSlant->"Italic"],
 " into those of ",
 StyleBox["g2",
  FontSlant->"Italic"],
 " plus derivatives of the conformal factor."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4.7. Bases and charts", "Subsection",
 CellTags->{"Mathematical entities", "Bases and charts"}],

Cell[TextData[{
 "It is not always enough to arrive at an abstract tensor field expression. \
Very often we need to introduce a basis of vectors, or even a chart, in order \
to get the final result of a computation. ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " has been designed as a manipulator of abstract expressions, and therefore \
we need to implement bases and charts in an abstract way as well. This is \
implemented in the companion package ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ", but the types ",
 StyleBox[ButtonBox["Basis",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Basis.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["Chart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Chart.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " have been already implemented here:\n\nA symbol ",
 StyleBox["basis",
  FontSlant->"Italic"],
 " with type ",
 StyleBox[ButtonBox["Basis",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Basis.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represents a basis of vector fields on a given vbundle. The list of all \
currently defined bases is stored in the global variable ",
 StyleBox[ButtonBox["$Bases",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Bases.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". All of them have associated upvalues ",
 StyleBox["True",
  FontFamily->"Courier"],
 " for the function ",
 StyleBox[ButtonBox["BasisQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BasisQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input. The functions ",
 StyleBox["DefBasis",
  FontFamily->"Courier"],
 " and ",
 StyleBox["UndefBasis",
  FontFamily->"Courier"],
 " are defined in the package ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 ".\n\nIn parallel, a symbol ",
 StyleBox["chart",
  FontSlant->"Italic"],
 " with type ",
 StyleBox[ButtonBox["Chart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Chart.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " represents a smooth chart on a given manifold. The list of all currently \
defined charts is stored in the global variable ",
 StyleBox[ButtonBox["$Charts",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Charts.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". All of them have associated upvalues ",
 StyleBox["True",
  FontFamily->"Courier"],
 " for the function ",
 StyleBox[ButtonBox["ChartQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChartQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input. The functions ",
 StyleBox["DefChart",
  FontFamily->"Courier"],
 " and ",
 StyleBox["UndefChart",
  FontFamily->"Courier"],
 " are defined in the package ",
 StyleBox["xCoba`",
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Mathematical entities", "Bases and charts"}]
}, Closed]],

Cell[CellGroupData[{

Cell["4.8. Other derivatives", "Subsection",
 CellTags->{"Other ders", "Mathematical entities"}],

Cell[TextData[{
 "Apart from covariant derivatives there are other types of derivations \
currently supported by ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ":\n\nLie derivatives are denoted using the head ",
 StyleBox[ButtonBox["LieD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LieD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The general syntax is ",
 StyleBox["LieD",
  FontFamily->"Courier"],
 "[ ",
 StyleBox["vector",
  FontSlant->"Italic"],
 " ][ ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " ] where ",
 StyleBox["vector",
  FontSlant->"Italic"],
 " is any tensorial expression with a single upper abstract free index. That \
index is not relevant except for its character and associated vbundle; we \
call it an ",
 StyleBox["ultraindex",
  FontSlant->"Italic"],
 ". Lie derivatives can be expanded using a covariant derivative with the \
function ",
 StyleBox[ButtonBox["LieDToCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LieDToCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Viceversa, directional derivatives can be converted into Lie derivatives \
using ",
 StyleBox["DirCovDToLieD",
  FontFamily->"Courier"],
 " (TODOCUMENT).\n\nLie brackets are denoted using the head ",
 StyleBox[ButtonBox["Bracket",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Bracket.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". The general syntax is ",
 StyleBox["Bracket",
  FontFamily->"Courier"],
 "[",
 StyleBox["a",
  FontSlant->"Italic"],
 "][",
 StyleBox["vect1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["vect2",
  FontSlant->"Italic"],
 "] where ",
 StyleBox["vect1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["vect2",
  FontSlant->"Italic"],
 " are two contravariant vector fields with free ultraindices. The index of \
the resulting vector field is ",
 StyleBox["a",
  FontSlant->"Italic"],
 " and not the ultraindex. Lie brackets can be expanded using a covariant \
derivative with the function ",
 StyleBox[ButtonBox["BracketToCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BracketToCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nThere are two kinds of parametric derivatives in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ", for historical reasons. The operator ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " builtin ",
 StyleBox[ButtonBox["OverDot",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "OverDot.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " has been overloaded as a derivative with respect to an arbitrary \
parameter. Every tensor field is assumed to depend on that parameter, unless \
stated otherwise. The recommended parametric derivative is, however, ",
 StyleBox[ButtonBox["ParamD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ParamD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", with syntax ",
 StyleBox["ParamD",
  FontFamily->"Courier"],
 "[",
 StyleBox["par1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["par2",
  FontSlant->"Italic"],
 ", ...][ ",
 StyleBox["expr ",
  FontSlant->"Italic"],
 "] where ",
 StyleBox["par1, par2, ...",
  FontSlant->"Italic"],
 " are parameters (defined with ",
 StyleBox["DefParameter",
  FontFamily->"Courier"],
 ") with respect we differentiate.\n\nThe command ",
 StyleBox[ButtonBox["FirstDerQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FirstDerQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " identifies single derivatives: it gives ",
 StyleBox["True",
  FontFamily->"Courier"],
 " on expressions of the form ",
 StyleBox["covd",
  FontSlant->"Italic"],
 "[",
 StyleBox["-a",
  FontSlant->"Italic"],
 "], ",
 StyleBox["LieD",
  FontFamily->"Courier"],
 "[",
 StyleBox["v",
  FontSlant->"Italic"],
 "], ",
 StyleBox["OverDot",
  FontFamily->"Courier"],
 " or ",
 StyleBox["ParamD",
  FontFamily->"Courier"],
 "[",
 StyleBox["par",
  FontSlant->"Italic"],
 "], and ",
 StyleBox["False",
  FontFamily->"Courier"],
 " otherwise (in particular on multiple parametric derivatives).\n\nA \
variational derivative ",
 StyleBox[ButtonBox["VarD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VarD.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " is planned for future versions."
}], "Text",
 CellTags->{"Other ders", "Mathematical entities"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["5. Input Expressions",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->18,
 CellTags->"Input expressions"],

Cell[TextData[{
 "Composite mathematical objects in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->"Input expressions"],

Cell[CellGroupData[{

Cell["5.1. Sum of tensors", "Subsection",
 CellTags->"Input expressions"],

Cell[TextData[{
 "There is no special \"tensor addition\" command. We use the ",
 StyleBox["Plus",
  FontFamily->"Courier"],
 " head in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " because this allows us to use many builtins which already know how to \
handle ",
 StyleBox["Plus",
  FontFamily->"Courier"],
 " (in particular the simplification algorithms). Any input expression in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is assumed to be a sum of terms and most algorithms are threaded over \
those terms in such a way that each term is manipulated independently.\n\nThe \
use of ",
 StyleBox["Plus",
  FontFamily->"Courier"],
 " is not a restriction in the sense that it has all expected properties of a \
sum of tensors. The only problem might be the attribute ",
 StyleBox["Orderless",
  FontFamily->"Courier"],
 " (implementing commutativity) because we cannot control the order in which \
the terms are placed."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["5.2. Tensor product", "Subsection",
 CellTags->{"Input expressions", "Tensor product"}],

Cell[TextData[{
 "There is no special \"tensor product\" command. We use the ",
 StyleBox["Times",
  FontFamily->"Courier"],
 " head in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " because this allows us to use many builtins which already know how to \
handle ",
 StyleBox["Times",
  FontFamily->"Courier"],
 " (in particular the simplication algorithms). Any term expression in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " is assumed to be a product of factors. A tensor product can be considered \
as a single tensor and many algorithms in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " use this idea.\n\nThe product of several tensors can be separated into \
monomials which do not share dummy indices. This can be done with the \
function ",
 StyleBox[ButtonBox["BreakInMonomials",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BreakInMonomials.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which introduces the (inert-) head ",
 StyleBox[ButtonBox["Monomial",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Monomial.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nThe use of ",
 StyleBox["Times",
  FontFamily->"Courier"],
 " is a restriction in the sense that it is a commutative product \
(implemented throught its ",
 StyleBox["Orderless",
  FontFamily->"Courier"],
 " attribute). There is no natural anticommutative product in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " does not try to introduce it. Apart from that, ",
 StyleBox["Times",
  FontFamily->"Courier"],
 " is perfectly general because the abstract indices keep track of the \
structure of the expression."
}], "Text",
 CellTags->{"Input expressions", "Tensor product"}]
}, Closed]],

Cell[CellGroupData[{

Cell["5.3. Scalars and the Scalar head", "Subsection",
 CellTags->{"Input expressions", "Scalar"}],

Cell[TextData[{
 "A monomial with no free indices is a scalar field, and it is often \
convenient to mark scalar fields as such. We do this using the head ",
 StyleBox[ButtonBox["Scalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Scalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (which could be, but has not been, defined as an inert-head). The main \
property of a ",
 StyleBox["Scalar",
  FontFamily->"Courier"],
 " expression is that it hides the indices inside from the computations, so \
that ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " treats a ",
 StyleBox["Scalar",
  FontFamily->"Courier"],
 " expression as a block, like it would do with a truly elementary scalar \
field. For instance, dummy indices can be repeated across different ",
 StyleBox["Scalar",
  FontFamily->"Courier"],
 " expression in the same product.\n\nTo separate ",
 StyleBox["Scalar",
  FontFamily->"Courier"],
 " expressions use the function ",
 StyleBox[ButtonBox["PutScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PutScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (which is essentially a call to ",
 StyleBox["BreakInMonomials",
  FontFamily->"Courier"],
 "), and to remove the ",
 StyleBox["Scalar",
  FontFamily->"Courier"],
 " head use ",
 StyleBox[ButtonBox["NoScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "NoScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Sometimes ",
 StyleBox["Scalar",
  FontFamily->"Courier"],
 " expressions can be further subdivided, and this is achieved with the \
function ",
 StyleBox[ButtonBox["BreakScalars",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BreakScalars.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nThe function ",
 StyleBox[ButtonBox["ScalarQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ScalarQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " detects scalars, that is expressions with no free indices (recall that \
only indices of types A and B can be free indices; blocked indices are never \
free indices). An expression with head ",
 StyleBox["Scalar",
  FontFamily->"Courier"],
 " is certainly a scalar, but constant-symbols, parameters or any other \
expression without free indices are also scalars. Similar functions, \
detecting expressions with just a single free index are ",
 StyleBox[ButtonBox["UpVectorQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UpVectorQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["DownVectorQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DownVectorQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Input expressions", "Scalar"}]
}, Closed]],

Cell[CellGroupData[{

Cell["5.4. Inert heads", "Subsection",
 CellTags->{"Input expressions", "Inert Heads"}],

Cell[TextData[{
 "We call inert-head a symbol ",
 StyleBox["h",
  FontSlant->"Italic"],
 " such that ",
 StyleBox["h",
  FontSlant->"Italic"],
 "[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] has the same tensorial character as ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " (same indices with same characters, and same symmetries), even though ",
 StyleBox["h",
  FontSlant->"Italic"],
 " is not assumed to be linear in general. Such a symbol will be given type \
",
 StyleBox[ButtonBox["InertHead",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "InertHead.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nInert-heads are defined with ",
 StyleBox[ButtonBox["DefInertHead",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefInertHead.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined with ",
 StyleBox[ButtonBox["UndefInertHead",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefInertHead.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". There are two particular option at definition: ",
 StyleBox[ButtonBox["LinearQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LinearQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which states whether the inert-head is linear or not (value stored as an \
upvalue for the function with same name), and ",
 StyleBox[ButtonBox["ContractThrough",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractThrough.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which gives a list of metrics (and/or ",
 StyleBox["delta",
  FontFamily->"Courier"],
 ") which can be contracted through the inert-head (value stored as an \
upvalue for the function ",
 StyleBox[ButtonBox["ContractThroughQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractThroughQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "). Additionally, we have the generic options for all ",
 StyleBox["DefType",
  FontFamily->"Courier"],
 " commands: ",
 StyleBox[ButtonBox["ProtectNewSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProtectNewSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["DefInfo",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefInfo.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Master",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Master.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["PrintAs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PrintAs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nThe list of all currently defined inert-heads is stored in the global \
variable ",
 StyleBox[ButtonBox["$InertHeads",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$InertHeads.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nAny symbol defined as an inert-head is given a ",
 StyleBox["True",
  FontFamily->"Courier"],
 " upvalue for the function ",
 StyleBox[ButtonBox["InertHeadQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "InertHeadQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input."
}], "Text",
 CellTags->{"Input expressions", "Inert Heads"}]
}, Closed]],

Cell[CellGroupData[{

Cell["5.5. Scalar functions", "Subsection",
 CellTags->{"Input expressions", "Scalar-functions"}],

Cell[TextData[{
 "In ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " there is a second way in which we can have tensors as arguments of \
functions: scalar functions of scalar arguments are allowed, and they must be \
registered before being used. Those functions will be called scalar-functions \
and their symbols will be given type ",
 StyleBox[ButtonBox["ScalarFunction",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ScalarFunction.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nScalar-functions are defined with ",
 StyleBox[ButtonBox["DefScalarFunction",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefScalarFunction.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and undefined with ",
 StyleBox[ButtonBox["UndefScalarFunction",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefScalarFunction.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". There are no particular options at definition time, apart from some of \
those generic for all ",
 StyleBox["DefType",
  FontFamily->"Courier"],
 " commands: ",
 StyleBox[ButtonBox["ProtectNewSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProtectNewSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", DefInfo, ",
 StyleBox[ButtonBox["Master",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Master.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["PrintAs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PrintAs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". A scalar function can have any number of arguments, but all of them are \
assumed to be scalars.\n\nFunctions with attribute ",
 StyleBox["NumericFunction",
  FontFamily->"Courier"],
 " are interpreted as scalar-functions.\n\nScalar-functions cannot be master \
symbols (i.e. cannot have servants). They cannot have objects either.\n\nThe \
list of all currently defined scalar-functions is stored in the global \
variable ",
 StyleBox[ButtonBox["$ScalarFunctions",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ScalarFunctions.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nAny symbol defined as a scalar-function is given a ",
 StyleBox["True",
  FontFamily->"Courier"],
 " upvalue for the function ",
 StyleBox[ButtonBox["ScalarFunctionQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ScalarFunctionQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is defined as ",
 StyleBox["False",
  FontFamily->"Courier"],
 " on any other input. Derivatives of scalar-functions are also \
scalar-functions.\n\nThe arguments of a scalar-function can be wrapped with \
the ",
 StyleBox["Scalar",
  FontFamily->"Courier"],
 " head, but in general this is not necessary."
}], "Text",
 CellTags->{"Scalar-functions", "Input expressions"}]
}, Closed]],

Cell[CellGroupData[{

Cell["5.6. Complex conjugation", "Subsection",
 CellTags->{"Input expressions", "Complex conjugation"}],

Cell[TextData[{
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " has its own complex-conjugation operator, called ",
 StyleBox[ButtonBox["Dagger",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dagger.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", to avoid overloading the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " builtin ",
 StyleBox["Conjugate",
  FontFamily->"Courier"],
 ". All input expressions have a definite behaviour under the ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 " operation, and this is controlled using ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 " as an option in the ",
 StyleBox["DefType",
  FontFamily->"Courier"],
 " commands. Possible values are ",
 StyleBox[ButtonBox["Real",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Real.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (usually the default), ",
 StyleBox[ButtonBox["Complex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Complex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Imaginary",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Imaginary.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Hermitian",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Hermitian.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["Antihermitian",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Antihermitian.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Special definitions are introduced for the object being defined as \
specified by the value of that option. The function ",
 StyleBox[ButtonBox["DaggerQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DaggerQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " returns ",
 StyleBox["True",
  FontFamily->"Courier"],
 " on ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " if ",
 StyleBox["Dagger",
  FontFamily->"Courier"],
 "[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] is different from ",
 StyleBox["expr",
  FontSlant->"Italic"],
 ".\n\nIndices can also carry information on the complex properties of the \
object they belong to. Conjugation of indices is performed by the function ",
 StyleBox[ButtonBox["DaggerIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DaggerIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Tensors with equal numbers of indices on a vbundle and its conjugate can \
be ",
 StyleBox["Hermitian",
  FontFamily->"Courier"],
 ". Their conjugation properties are implemented through the function ",
 StyleBox[ButtonBox["TransposeDagger",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TransposeDagger.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nFinally, by default the conjugated symbol to a given symbol (tensor or \
index) is formed by adding a character to the original symbol. This character \
is stored in the global variable ",
 StyleBox[ButtonBox["$DaggerCharacter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$DaggerCharacter.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", and initially is the dagger character \"\[Dagger]\"."
}], "Text",
 CellTags->{"Input expressions", "Complex conjugation"}]
}, Closed]],

Cell[CellGroupData[{

Cell["5.7. Validation", "Subsection",
 CellTags->{"Input expressions", "Validation"}],

Cell[TextData[{
 "The function ",
 StyleBox[ButtonBox["Validate",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Validate.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " checks the syntax of an expression in ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 ". When doing a computation there are some checks but not many, to save \
time. In those cases in which the error can be localized in a particular \
subexpression of the whole expression, that subexpression is returned wrapped \
with the inert-head ",
 StyleBox[ButtonBox["ERROR",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ERROR.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (printed in red in ",
 StyleBox["StandardForm",
  FontFamily->"Courier"],
 ")."
}], "Text",
 CellTags->{"Input expressions", "Validation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["6. Rules and definitions",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->18,
 CellTags->"Rules"],

Cell["\<\
Rules among tensor expressions. There are two levels to consider: 1) ensuring \
syntactically correct rules and 2) having flexible ways of producing rules.\
\>", "Text"],

Cell[CellGroupData[{

Cell["6.1. Indicial rules", "Subsection",
 CellTags->{"Rules", "IndexRule"}],

Cell[TextData[{
 "Given the simple structure of our tensor expressions, it is tempting to \
construct simple rules to replace tensors by other tensor expressions. \
However that would inmediately produce syntactic errors, like repeated \
indices (see examples of this in ",
 StyleBox["xTensorDoc.nb",
  FontFamily->"Courier"],
 "). ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " generalizes the four main rule constructs to work with indexed \
expressions, with new names having the prefix ",
 StyleBox["Index",
  FontFamily->"Courier"],
 ":\n\t\t",
 StyleBox["Rule",
  FontFamily->"Courier"],
 "\t\t\t",
 StyleBox[ButtonBox["IndexRule",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexRule.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (infix notation ",
 StyleBox[ButtonBox["RightTeeArrow",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RightTeeArrow.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ")\n\t\t",
 StyleBox["RuleDelayed",
  FontFamily->"Courier"],
 "\t",
 StyleBox[ButtonBox["IndexRuleDelayed",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexRuleDelayed.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "\n\t\t",
 StyleBox["Set",
  FontFamily->"Courier"],
 "\t\t\t",
 StyleBox[ButtonBox["IndexSet",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexSet.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " (infix notation ",
 StyleBox[ButtonBox["DoubleRightTee",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DoubleRightTee.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ")\n\t\t",
 StyleBox["SetDelayed",
  FontFamily->"Courier"],
 "\t\t",
 StyleBox[ButtonBox["IndexSetDelayed",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexSetDelayed.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"]
}], "Text",
 CellTags->{"Rules", "IndexRule"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.2. MakeRule", "Subsection",
 CellTags->{"Rules", "MakeRule"}],

Cell[TextData[{
 "The function ",
 StyleBox[ButtonBox["MakeRule",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MakeRule.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " offers a large flexibility in constructing tensor rules and their \
equivalents under certain changes, as controlled by its options. The syntax \
is either ",
 StyleBox["MakeRule",
  FontFamily->"Courier"],
 "[{",
 StyleBox["lhs, rhs",
  FontSlant->"Italic"],
 "}, ",
 StyleBox["options",
  FontSlant->"Italic"],
 "] or ",
 StyleBox["MakeRule",
  FontFamily->"Courier"],
 "[{",
 StyleBox["lhs, rhs, conditions",
  FontSlant->"Italic"],
 "}, ",
 StyleBox["options",
  FontSlant->"Italic"],
 "] if we want to add conditions (head ",
 StyleBox["Condition",
  FontFamily->"Courier"],
 ") to the final rules. Possible options are:\n\t",
 StyleBox[ButtonBox["PatternIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PatternIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": indices to be converted into patterns\n\t",
 StyleBox[ButtonBox["TestIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TestIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": whether vbundle of indices must be checked\n\t",
 StyleBox[ButtonBox["MetricOn",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricOn.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": indices on which the metric must be used\n\t",
 StyleBox[ButtonBox["UseSymmetries",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UseSymmetries.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": whether symmetries of tensors must be used or not\n\t",
 StyleBox[ButtonBox["ContractMetrics",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractMetrics.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": whether to contract metric factors on the rhs\n\t",
 StyleBox[ButtonBox["Verbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Verbose.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ": report on the internal progress"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.3. Automatic rules", "Subsection",
 CellTags->{"Rules", "AutomaticRules"}],

Cell[TextData[{
 "The rules produced by ",
 StyleBox["MakeRule",
  FontFamily->"Courier"],
 " or any other rules can be converted into permanent definitions (like those \
produced by ",
 StyleBox["Set",
  FontFamily->"Courier"],
 ") using the function ",
 StyleBox[ButtonBox["AutomaticRules",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AutomaticRules.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". This function works like the ",
 StyleBox["TagSet",
  FontFamily->"Courier"],
 " family, deciding whether the rule must be defined as a downvalue or an \
upvalue for a given symbol. If none of those is possible then the rule is \
appended to the list ",
 StyleBox[ButtonBox["$Rules",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Rules.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which must be imposed explicitly by the user."
}], "Text",
 CellTags->{"Rules", "AutomaticRules"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["7. Manipulation of input",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->18,
 CellTags->"Manipulation of input"],

Cell[CellGroupData[{

Cell["7.1. Symmetry", "Subsection",
 CellTags->{"Manipulation of input", "Symmetry"}],

Cell[TextData[{
 "Every product of tensors or tensorial expressions has a well defined \
symmetry under permutations of its indices, and this can be obtained with the \
function ",
 StyleBox[ButtonBox["SymmetryOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymmetryOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". For convenience, apart from the permutation group describing the \
symmetry, this function returns the original expression with indices \
numbered, so that it is clear which indices the permutations are referring \
to. For example, for a tensor ",
 StyleBox["Rie",
  FontFamily->"Courier"],
 " with the symmetries of a Riemann tensor, the symmetry returned by ",
 StyleBox["SymmetryOf",
  FontFamily->"Courier"],
 " would be this expression with head ",
 StyleBox[ButtonBox["Symmetry",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Symmetry.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ":\n\n",
 Cell[BoxData[
  RowBox[{"Symmetry", "[", 
   RowBox[{"4", ",", 
    TagBox[
     SubsuperscriptBox[
      "Rie", "\<\"    \"\>", "\<\"\[FilledCircle]1\[FilledCircle]2\
\[FilledCircle]3\[FilledCircle]4\"\>"],
     Tensor], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\<\"\[FilledCircle]1\"\>", "\[Rule]", "G"}], ",", 
      RowBox[{"\<\"\[FilledCircle]2\"\>", "\[Rule]", "F"}], ",", 
      RowBox[{"\<\"\[FilledCircle]3\"\>", "\[Rule]", "D"}], ",", 
      RowBox[{"\<\"\[FilledCircle]4\"\>", "\[Rule]", "K"}]}], "}"}], ",", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"GenSet", "[", 
       RowBox[{
        RowBox[{"Cycles", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
        RowBox[{"-", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}], "]"}]}], "]"}]}], 
   "]"}]], "Output"],
 "\n   \nThe symmetry group is written in strong generating set notation, and \
its permutations are written in cyclic notation. For explanation of these and \
other concepts in permutation group theory see the documentation for the \
companion package ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 ".\n\nThe symmetry of a product of tensors is computed from the symmetries \
of the individual tensors (stored in ",
 StyleBox[ButtonBox["SymmetryGroupOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymmetryGroupOfTensor.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 ") and taking into account the possibility of permuting equal \
subexpressions. When there are derivatives involved the computation is more \
complicated and we need to know whether the derivatives commute, or whether \
it is possible to permute indices with different characters. The options ",
 StyleBox[ButtonBox["CommutePDs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CommutePDs.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["ConstantMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ConstantMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " of ",
 StyleBox["SymmetryOf",
  FontFamily->"Courier"],
 " help in controlling these points. The global variable ",
 StyleBox[ButtonBox["$CommuteCovDsOnScalars",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CommuteCovDsOnScalars.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " turns on and off the commutativity of symmetric covariant derivatives on \
scalar fields."
}], "Text",
 CellTags->{"Manipulation of input", "Symmetry"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["7.2. Canonicalization and simplification", "Subsection",
 CellTags->{"Manipulation of input", "ToCanonical"}],

Cell[TextData[{
 "The main part of a computer algebra system is the canonicalizer, the \
algorithm in chart of bringing any expression to its canonical form. In ",
 StyleBox["xTensor`",
  FontFamily->"Courier"],
 " the canonicalizer is implemented in a single command, called ",
 StyleBox[ButtonBox["ToCanonical",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ToCanonical.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", by far the most sophisticated algorithm of the whole system. Its action \
is composed of three steps:\n\t1) On a sum of terms we first apply the \
function ",
 StyleBox[ButtonBox["SameDummies",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SameDummies.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " to minimize the number of different dummy indices. Then we map ToCanonical \
over individual terms, such that each of them is canonicalized independently.\
\n\t2) Terms (generically products of different objects) are sorted according \
to a number of criteria. This is done by the function ",
 StyleBox[ButtonBox["xSort",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "xSort.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". This function works in three internal steps, corresponding to three \
respective internal (private) functions:\n\t\t2.1) ",
 StyleBox["Identify",
  FontFamily->"Courier"],
 ": Dismantle the expression adding symbols characterizing each of its parts\n\
\t\t2.2) ",
 StyleBox["MarkBlocked",
  FontFamily->"Courier"],
 ": mark those subexpressions with only blocked indices; they do not require \
canonicalization\n\t\t2.3) ",
 StyleBox["ObjectSort",
  FontFamily->"Courier"],
 ": sorts the different parts of the expression taking into account their \
properties. The global variable  ",
 StyleBox[ButtonBox["$CommuteFreeIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CommuteFreeIndices.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " controls the ordering of equivalent objects with free indices.\n\t3) Once \
the term has been sorted, it can be considered as a single tensor with \
indices and symmetry as given by ",
 StyleBox[ButtonBox["SymmetryOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymmetryOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". Then we \"only\" have to call the algorithms for canonicalization of \
permutations in single and double cosets which have been developed by R. \
Portugal and his collaborators. These algorithms have been encoded in the \
companion package ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " and constitute the hardest part of the canonicalization process. ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " offers two different (but equivalent) encodings of the algorithm: a \
pure-",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code ",
 StyleBox["CanonicalPerm",
  FontFamily->"Courier"],
 " and a mixed-C-",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code ",
 StyleBox["MathLinkCanonicalPerm",
  FontFamily->"Courier"],
 ", which is much faster but is not available for all platforms (see the \
documentation of ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 " for details). Which of the two is used is chosen through the option ",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MathLink.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " of ",
 StyleBox["ToCanonical",
  FontFamily->"Courier"],
 ". (The name of the option comes from the fact the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " protocol is used the link the C and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " parts of the code.) By default ",
 StyleBox["ToCanonical",
  FontFamily->"Courier"],
 " returns only the canonical expression, but it also sows the final list of \
indices, and the sign, associated to tag \[OpenCurlyDoubleQuote]NewIndices\
\[CloseCurlyDoubleQuote].\n\t\nApart from those three (permutation-related), \
there are three more options for ",
 StyleBox["ToCanonical",
  FontFamily->"Courier"],
 ". One of them reports information on the progress of the canonicalization \
process: ",
 StyleBox[ButtonBox["Verbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Verbose.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". (There are also the options ",
 StyleBox["xPermVerbose",
  FontFamily->"Courier"],
 " and ",
 StyleBox["TimeVerbose",
  FontFamily->"Courier"],
 " to get information and timings on the actual permutation-canonicalization \
process from ",
 StyleBox["xPerm`",
  FontFamily->"Courier"],
 ".) Then there is the option ",
 StyleBox[ButtonBox["UseMetricOnVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UseMetricOnVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which gives a list of vbundles on which the metric can be used to raise \
and lower the indices. The final issue is that of canonicalization of \
derivatives: when there is a metric and a derivative which is not compatible \
with that metric, the system changes to the internal function ",
 StyleBox["ToCanonicalDers",
  FontFamily->"Courier"],
 ", which handles canonicalization much more carefully, but also much more \
slowly. That change can be avoided by switching off the global variable ",
 StyleBox[ButtonBox["$MixedDers",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$MixedDers.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ". This new algorithm usually produces lots of Christoffel tensor because it \
changes internally from the \"offending\" derivative to the Levi-Civita \
connection of the metric. It is possible to convert automatically those \
Christoffel tensors into derivatives of the metric using the option ",
 StyleBox[ButtonBox["ExpandChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExpandChristoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ".\n\nFinally, there is the function ",
 StyleBox[ButtonBox["Simplification",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Simplification.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which is simply a combination of ",
 StyleBox["ToCanonical",
  FontFamily->"Courier"],
 " and then call to ",
 StyleBox["Simplify",
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->{"Manipulation of input", "ToCanonical"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["7.3. Imposing symmetries", "Subsection",
 CellTags->{"Manipulation of input", "ImposeSymmetry"}],

Cell[TextData[{
 "Given an expression ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " and a symmetry group ",
 StyleBox["G",
  FontSlant->"Italic"],
 " the function ",
 StyleBox[ButtonBox["ImposeSymmetry",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ImposeSymmetry.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "[",
 StyleBox["expr, inds, G",
  FontSlant->"Italic"],
 "] constructs the linear combination of all index-permutations of ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " corresponding to the elements of the group ",
 StyleBox["G",
  FontSlant->"Italic"],
 " applied on the indices ",
 StyleBox["inds",
  FontSlant->"Italic"],
 " of ",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", in particular taking ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " to be the expression corresponding to the identity element. The result is \
always divided by the order of ",
 StyleBox["G",
  FontSlant->"Italic"],
 " (the number of elements). Special derived functions for special groups of \
permutations are ",
 StyleBox[ButtonBox["Symmetrize",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Symmetrize.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["Antisymmetrize",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Antisymmetrize.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", ",
 StyleBox[ButtonBox["PairSymmetrize",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PairSymmetrize.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["PairAntisymmetrize",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PairAntisymmetrize.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", with obvious meanings. There is also ",
 StyleBox["Cyclize",
  FontFamily->"Courier"],
 " (TODOCUMENT).\n\nWe can also handle symmetry operations involving a \
metric: the function ",
 StyleBox[ButtonBox["STFPart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "STFPart.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " returns the symmetric trace-free part of an expression with respect to a \
given metric.\n\nMore ambitious, but still restricted to the case of a single \
vbundle, are the functions ",
 StyleBox[ButtonBox["ChangeFreeIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeFreeIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which changes the free abstract indices of an expression to those given \
by the user, and the function ",
 StyleBox[ButtonBox["EqualExpressionsQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "EqualExpressionsQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 ", which checks whether two expressions are the same apart from symmetries \
and permutations of indices."
}], "Text",
 CellTags->{"Manipulation of input", "ImposeSymmetry"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["7.4. Collecting terms", "Subsection",
 CellTags->{"Manipulation of input", "Collecting"}],

Cell[TextData[{
 "There are three simple functions which help in manipulating tensor \
expressions. These three functions are currently very simple and will be \
improved in future versions:\n\t",
 StyleBox[ButtonBox["IndexCoefficient",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexCoefficient.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "[",
 StyleBox["expr, form",
  FontSlant->"Italic"],
 "] returns the coefficient of ",
 StyleBox["form",
  FontSlant->"Italic"],
 " in ",
 StyleBox["expr",
  FontSlant->"Italic"],
 ".\n\t",
 StyleBox[ButtonBox["IndexCollect",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexCollect.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["form",
  FontSlant->"Italic"],
 ", ",
 StyleBox["function",
  FontSlant->"Italic"],
 "] imitates the action of ",
 StyleBox["Collect",
  FontFamily->"Courier"],
 " but allowing for indexed expressions in ",
 StyleBox["form",
  FontSlant->"Italic"],
 ".\n\t",
 StyleBox[ButtonBox["IndexSolve",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexSolve.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 "[",
 StyleBox["equation, tensor",
  FontSlant->"Italic"],
 "] solves ",
 StyleBox["equation",
  FontSlant->"Italic"],
 " for the given ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " in very simple cases:",
 " ",
 StyleBox["tensor",
  FontSlant->"Italic"],
 " has",
 " only free indices"
}], "Text",
 CellTags->{"Manipulation of input", "Collecting"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["7.5. Acting on particular subexpressions", "Subsection",
 CellTags->{"Manipulation of input", "Color"}],

Cell[TextData[{
 "In ",
 StyleBox["xTensor` ",
  FontFamily->"Courier"],
 "there are no special functions or arguments to act at particular positions \
of an expression. This is because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " already offers lots of different possibilities to act on arbitrary \
positions in different ways. See for example the functions ",
 StyleBox["Map",
  FontFamily->"Courier"],
 ", ",
 StyleBox["MapAt",
  FontFamily->"Courier"],
 ", ",
 StyleBox["MapAll",
  FontFamily->"Courier"],
 ", ",
 StyleBox["MapIndexed",
  FontFamily->"Courier"],
 ", etc. However, it is sometimes difficult to know in which position a given \
subexpression is, and for this an other similar purposes the functions ",
 StyleBox[ButtonBox["ColorPositionsOfPattern",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ColorPositionsOfPattern.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
  FontFamily->"Courier"],
 " and ",
 StyleBox[ButtonBox["ColorTerms",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ColorTerms.nb", CharacterEncoding -> 
     "iso8859-1"], None}],
  FontFamily->"Courier"],
 " are really useful. These two have been constructed using the functionality \
of the great package ExpressionManipulation` by David J.M. Park Jr., Ted \
Ersek (C) 1999-2007."
}], "Text",
 CellTags->{"Manipulation of input", "Color"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["8. List of commands",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->18,
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ABIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ABIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AbstractIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AbstractIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AbstractIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AbstractIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$AbstractIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$AbstractIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Acceleration",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Acceleration.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$AccelerationSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$AccelerationSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AChristoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AddIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AddIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AllowUpperDerivatives",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AllowUpperDerivatives.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Antihermitian",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Antihermitian.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Antisymmetrize",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Antisymmetrize.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AnyDependencies",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AnyDependencies.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AnyIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AnyIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["AutomaticRules",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "AutomaticRules.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BaseOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BaseOfVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$Bases",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Bases.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Basis",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Basis.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BasisQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BasisQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BCIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BCIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Blocked",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Blocked.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BlockedQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BlockedQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Bracket",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Bracket.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BracketToCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BracketToCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BreakChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BreakChristoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BreakInMonomials",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BreakInMonomials.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["BreakScalars",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "BreakScalars.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CDIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CDIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ChangeCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ChangeCurvature",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeCurvature.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ChangeFreeIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeFreeIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ChangeIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ChangeTorsion",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChangeTorsion.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Chart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Chart.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ChartQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChartQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$Charts",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Charts.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CheckZeroDerivative",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CheckZeroDerivative.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CheckZeroDerivativeStart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CheckZeroDerivativeStart.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CheckZeroDerivativeStop",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CheckZeroDerivativeStop.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$CheckZeroDerivativeVerbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CheckZeroDerivativeVerbose.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Christoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Christoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData["ChristoffelToGradConformal"], "Input"],

Cell[BoxData[
 ButtonBox["ChristoffelToGradMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChristoffelToGradMetric.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ChristoffelToMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ChristoffelToMetric.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CIndexForm",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CIndexForm.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$CIndexForm",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CIndexForm.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CircleDot",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CircleDot.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ColorPositionsOfPattern",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ColorPositionsOfPattern.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ColorTerms",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ColorTerms.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData["ConformalFactor"], "Input"],

Cell[BoxData["ConformalRules"], "Input"],

Cell[BoxData["ConformalTo"], "Input"],

Cell[BoxData[
 ButtonBox["CommuteCovDs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CommuteCovDs.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$CommuteCovDsOnScalars",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CommuteCovDsOnScalars.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$CommuteFreeIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CommuteFreeIndices.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CommutePDs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CommutePDs.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Complex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Complex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$ComputeNewDummies",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ComputeNewDummies.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ConstantMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ConstantMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ConstantQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ConstantQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ConstantSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ConstantSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ConstantSymbolQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ConstantSymbolQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$ConstantSymbols",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ConstantSymbols.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ContractCurvature",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractCurvature.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ContractDir",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractDir.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ContractMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ContractMetrics",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractMetrics.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ContractThrough",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractThrough.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ContractThroughQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ContractThroughQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$CovDFormat",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CovDFormat.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CovDOfMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CovDOfMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CovDQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CovDQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$CovDs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$CovDs.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CovDToChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CovDToChristoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Curvature",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Curvature.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CurvatureQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CurvatureQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["CurvatureRelations",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "CurvatureRelations.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Dagger",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dagger.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DaggerIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DaggerIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DaggerQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DaggerQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefAbstractIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefAbstractIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefConstantSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefConstantSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefInertHead",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefInertHead.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefInfo",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefInfo.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$DefInfo",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$DefInfo.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefManifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefParameter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefParameter.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefProductMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefProductMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefScalarFunction",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefScalarFunction.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DefVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DefVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["delta",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "delta.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DependenciesOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DependenciesOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DependenciesOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DependenciesOfTensor.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData["Determinant"], "Input"],

Cell[BoxData[
 ButtonBox["DimOfManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DimOfManifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DimOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DimOfVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Dir",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dir.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Disclaimer",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Disclaimer.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DisjointManifoldsQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DisjointManifoldsQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DisorderedPairQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DisorderedPairQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DoubleRightTee",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DoubleRightTee.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Down",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Down.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DownIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DownIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DownIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DownIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DownVectorQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DownVectorQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Dummy",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Dummy.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["DummyIn",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "DummyIn.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["EIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "EIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Einstein",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Einstein.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["EinsteinToRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "EinsteinToRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["epsilon",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "epsilon.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$epsilonSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$epsilonSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["EqualExpressionsQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "EqualExpressionsQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ERROR",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ERROR.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ExpandChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExpandChristoffel.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ExpandGdelta",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExpandGdelta.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ExpandProductMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExpandProductMetric.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ExtendedFrom",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExtendedFrom.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ExtrinsicK",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExtrinsicK.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$ExtrinsicKSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ExtrinsicKSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ExtrinsicKToGradNormal",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ExtrinsicKToGradNormal.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FindAllOfType",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindAllOfType.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FindBlockedIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindBlockedIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FindDummyIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindDummyIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FindFreeIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindFreeIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FindIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FindIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$FindIndicesAcceptedHeads",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$FindIndicesAcceptedHeads.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FirstDerQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FirstDerQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FlatMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FlatMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FlatMetricQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FlatMetricQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ForceSymmetries",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ForceSymmetries.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Free",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Free.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FRiemann",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FRiemann.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FrobeniusQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FrobeniusQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["FromMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "FromMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData["GaussCodazzi"], "Input"],

Cell[BoxData[
 ButtonBox["Gdelta",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Gdelta.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["GetIndicesOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GetIndicesOfVBundle.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["GIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["GiveOutputString",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GiveOutputString.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["GiveSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GiveSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["GradMetricToChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GradMetricToChristoffel.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["GradNormalToExtrinsicK",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "GradNormalToExtrinsicK.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Hermitian",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Hermitian.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["HostsOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "HostsOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Imaginary",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Imaginary.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ImposeSymmetry",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ImposeSymmetry.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexCoefficient",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexCoefficient.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexCollect",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexCollect.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexForm",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexForm.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexList",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexList.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexOrderedQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexOrderedQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexRange",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexRange.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexRule",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexRule.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexRuleDelayed",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexRuleDelayed.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexSet",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexSet.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexSetDelayed",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexSetDelayed.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexSolve",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexSolve.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndexSort",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndexSort.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndicesOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndicesOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IndicesOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IndicesOfVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["InducedDecomposition",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "InducedDecomposition.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["InducedFrom",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "InducedFrom.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["InertHead",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "InertHead.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["InertHeadQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "InertHeadQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$InertHeads",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$InertHeads.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Inv",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Inv.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["IsIndexOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "IsIndexOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Labels",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Labels.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["LI",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LI.nb", CharacterEncoding -> "iso8859-1"],
     None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["LieD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LieD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["LieDToCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LieDToCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["LIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["LIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["LinearQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "LinearQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["MakeRule",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MakeRule.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Manifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Manifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ManifoldOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ManifoldOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ManifoldQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ManifoldQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$Manifolds",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Manifolds.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ManifoldsOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ManifoldsOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Master",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Master.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["MasterOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MasterOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Metric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Metric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["MetricEndowedQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricEndowedQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["MetricOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["MetricOn",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricOn.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["MetricQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$Metrics",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Metrics.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["MetricScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["MetricsOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricsOfVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["MetricToProjector",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "MetricToProjector.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$MixedDers",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$MixedDers.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Monomial",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Monomial.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["NewIndexIn",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "NewIndexIn.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["NoScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "NoScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["OrthogonalTo",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "OrthogonalTo.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["OverDerivatives",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "OverDerivatives.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["OverDot",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "OverDot.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PairAntisymmetrize",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PairAntisymmetrize.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PairQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PairQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PairSymmetrize",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PairSymmetrize.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ParamD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ParamD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Parameter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Parameter.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ParameterQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ParameterQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$Parameters",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Parameters.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ParametersOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ParametersOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PatternIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PatternIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PatternIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PatternIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PD.nb", CharacterEncoding -> "iso8859-1"],
     None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PermuteIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{
      ParentDirectory[]}, "PermuteIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PrintAs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PrintAs.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$ProductManifolds",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ProductManifolds.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$ProductMetrics",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ProductMetrics.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ProjectDerivative",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProjectDerivative.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ProjectedWith",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProjectedWith.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ProtectNewSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProtectNewSymbol.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$ProtectNewSymbols",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ProtectNewSymbols.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Projector",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Projector.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ProjectorToMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProjectorToMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ProjectWith",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ProjectWith.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["PutScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "PutScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$ReadingVerbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ReadingVerbose.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Real",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Real.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["RemoveIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RemoveIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ReplaceDummies",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ReplaceDummies.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ReplaceIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ReplaceIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Ricci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Ricci.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["RicciScalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RicciScalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$RicciSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$RicciSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["RicciToEinstein",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RicciToEinstein.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["RicciToTFRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RicciToTFRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Riemann",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Riemann.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$RiemannSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$RiemannSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["RiemannToChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RiemannToChristoffel.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["RiemannToWeyl",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RiemannToWeyl.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["RightTeeArrow",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "RightTeeArrow.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$Rules",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Rules.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SameDummies",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SameDummies.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Scalar",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Scalar.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ScalarFunction",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ScalarFunction.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ScalarFunctionQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ScalarFunctionQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$ScalarFunctions",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$ScalarFunctions.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ScalarQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ScalarQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ScreenDollarIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ScreenDollarIndices.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SeparateDir",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SeparateDir.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SeparateMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SeparateMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ServantsOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ServantsOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SetCharacters",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SetCharacters.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData["SetConformalTo"], "Input"],

Cell[BoxData[
 ButtonBox["SetIndexSortPriorities",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SetIndexSortPriorities.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SetOrthogonal",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SetOrthogonal.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SignatureOfMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SignatureOfMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SignDetOfMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SignDetOfMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Simplification",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Simplification.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SlotsOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SlotsOfTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SortCovDs",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SortCovDs.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SortCovDsStart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SortCovDsStart.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SortCovDsStop",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SortCovDsStop.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SplitIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SplitIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["STFPart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "STFPart.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SubdummiesIn",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SubdummiesIn.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SubmanifoldQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SubmanifoldQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SubmanifoldsOfManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SubmanifoldsOfManifold.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SubvbundleQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SubvbundleQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SubvbundlesOfVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SubvbundlesOfVBundle.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$SumVBundles",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$SumVBundles.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SymbolOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymbolOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Symmetrize",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Symmetrize.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Symmetry",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Symmetry.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SymmetryGroupOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymmetryGroupOfTensor.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SymmetryTableauxOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymmetryTableauxOfTensor.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["SymmetryOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "SymmetryOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Tangent",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Tangent.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TangentBundleOfManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TangentBundleOfManifold.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Tensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Tensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TensorID",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TensorID.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$Tensors",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Tensors.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TestIndices",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TestIndices.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TFRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TFRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TFRicciToRicci",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TFRicciToRicci.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ToCanonical",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ToCanonical.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ToInducedDerivative",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ToInducedDerivative.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input"],

Cell[BoxData[
 ButtonBox["Torsion",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Torsion.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TorsionQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TorsionQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$TorsionSign",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$TorsionSign.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TorsionToChristoffel",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TorsionToChristoffel.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TraceDummy",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TraceDummy.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$TraceDummyVerbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$TraceDummyVerbose.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TraceProductDummy",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TraceProductDummy.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["TransposeDagger",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "TransposeDagger.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Undef",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Undef.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UndefAbstractIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefAbstractIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UndefConstantSymbol",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefConstantSymbol.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UndefCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UndefInertHead",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefInertHead.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData["$UndefInfoQ"], "Input"],

Cell[BoxData[
 ButtonBox["UndefManifold",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefManifold.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UndefMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UndefParameter",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefParameter.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UndefScalarFunction",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefScalarFunction.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UndefTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UndefVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UndefVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Up",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Up.nb", CharacterEncoding -> "iso8859-1"],
     None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UpIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UpIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UpIndexQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UpIndexQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UpVectorQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UpVectorQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UseMetricOnVBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UseMetricOnVBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["UseSymmetries",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "UseSymmetries.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Validate",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Validate.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["ValidateSymbolInSession",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "ValidateSymbolInSession.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["VanishingQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VanishingQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["VarD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VarD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["VBundle",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundle.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["VBundleQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundleQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["VBundleOfIndex",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundleOfIndex.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$VBundles",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$VBundles.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["VBundlesOfCovD",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundlesOfCovD.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["VBundleOfMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VBundleOfMetric.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["VectorOfInducedMetric",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VectorOfInducedMetric.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Verbose",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Verbose.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$Version",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$Version.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["VisitorsOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "VisitorsOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["WeightedWithBasis",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "WeightedWithBasis.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["WeightOf",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "WeightOf.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["WeightOfTensor",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "WeightOfTensor.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Weyl",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Weyl.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["WeylToRiemann",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "WeylToRiemann.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["$xPermVersionExpected",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "$xPermVersionExpected.nb", 
     CharacterEncoding -> "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["xSort",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "xSort.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["xTensorFormStart",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "xTensorFormStart.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["xTensorFormStop",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "xTensorFormStop.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["xTensorQ",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "xTensorQ.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"],

Cell[BoxData[
 ButtonBox["Zero",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"xTensor"}, "Zero.nb", CharacterEncoding -> 
     "iso8859-1"], None}]], "Input",
 CellTags->"List of commands"]
}, Closed]],

Cell[CellGroupData[{

Cell["9. Possible changes in the system", "Section",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
 "This is a list of possible changes I'm considering for future versions. \
Each of them is discussed in a different notebook. If you have any comment or \
suggestion on one of those changes (either in favour or against it), please \
edit the corresponding notebook and send it to me:\n\n\t",
 ButtonBox["Options and their associated functions",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"changes"}, "Options_and_functions.nb", 
     CharacterEncoding -> "iso8859-1"], None}],
 "\n\t\n\t",
 ButtonBox["Notations for multiple covariant derivatives",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`FileName[{"changes"}, "Multiple_derivatives.nb", 
     CharacterEncoding -> "iso8859-1"], None}]
}], "Text"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{871, 693},
WindowMargins->{{Automatic, 91}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"Magnification"->1,
"PaperOrientation"->"Portrait",
"PaperSize"->{597.562, 842.375},
"PostScriptOutputFile":>FrontEnd`FileName[{$RootDirectory, "home", "jmm", 
   "xAct", "Documentation", "English"}, "xTensorRefGuide.nb.ps", 
  CharacterEncoding -> "iso8859-1"]},
ShowCellTags->True,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Loading"->{
  Cell[1956, 66, 97, 3, 80, "Section",
   CellTags->"Loading"],
  Cell[2056, 71, 3250, 89, 466, "Text",
   CellTags->"Loading"]},
 "Symbols and types"->{
  Cell[5343, 165, 137, 3, 50, "Section",
   CellTags->"Symbols and types"],
  Cell[5505, 172, 84, 1, 44, "Subsection",
   CellTags->"Symbols and types"],
  Cell[5996, 186, 3840, 86, 665, "Text",
   CellTags->"Symbols and types"],
  Cell[9873, 277, 103, 1, 38, "Subsection",
   CellTags->{"Symbols and types", "Valid symbols"}],
  Cell[9979, 280, 4160, 111, 356, "Text",
   CellTags->{"Symbols and types", "Valid symbols"}],
  Cell[14176, 396, 91, 1, 44, "Subsection",
   CellTags->{"Symbols and types", "Type managing"}],
  Cell[14270, 399, 14517, 410, 673, "Text",
   CellTags->{"Symbols and types", "Type managing"}],
  Cell[28824, 814, 111, 1, 44, "Subsection",
   CellTags->{"Symbols and types", "Relations among symbols"}],
  Cell[28938, 817, 2554, 66, 243, "Text",
   CellTags->{"Relations among symbols", "Symbols and types"}],
  Cell[31495, 885, 899, 29, 71, "Text",
   CellTags->{"Relations among symbols", "Symbols and types"}]},
 "Valid symbols"->{
  Cell[9873, 277, 103, 1, 38, "Subsection",
   CellTags->{"Symbols and types", "Valid symbols"}],
  Cell[9979, 280, 4160, 111, 356, "Text",
   CellTags->{"Symbols and types", "Valid symbols"}]},
 "Type managing"->{
  Cell[14176, 396, 91, 1, 44, "Subsection",
   CellTags->{"Symbols and types", "Type managing"}],
  Cell[14270, 399, 14517, 410, 673, "Text",
   CellTags->{"Symbols and types", "Type managing"}]},
 "Relations among symbols"->{
  Cell[28824, 814, 111, 1, 44, "Subsection",
   CellTags->{"Symbols and types", "Relations among symbols"}],
  Cell[28938, 817, 2554, 66, 243, "Text",
   CellTags->{"Relations among symbols", "Symbols and types"}],
  Cell[31495, 885, 899, 29, 71, "Text",
   CellTags->{"Relations among symbols", "Symbols and types"}]},
 "Generalized indices"->{
  Cell[32443, 920, 141, 3, 50, "Section",
   CellTags->"Generalized indices"],
  Cell[32609, 927, 86, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "GIndexQ"}],
  Cell[32698, 930, 9320, 265, 788, "Text",
   CellTags->{"GIndexQ", "Generalized indices"}],
  Cell[42055, 1200, 99, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Abstract Indices"}],
  Cell[42157, 1203, 4208, 101, 428, "Text",
   CellTags->{"Generalized indices", "Abstract Indices"}],
  Cell[46402, 1309, 115, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Basis indices"}],
  Cell[46520, 1312, 3324, 88, 320, "Text",
   CellTags->{"Generalized indices", "Basis indices"}],
  Cell[49881, 1405, 105, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Directional indices"}],
  Cell[49989, 1408, 1727, 45, 158, "Text",
   CellTags->{"Generalized indices", "Directional indices"}],
  Cell[51753, 1458, 93, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Label Indices"}],
  Cell[51849, 1461, 1415, 41, 122, "Text",
   CellTags->{"Generalized indices", "Label Indices"}],
  Cell[53301, 1507, 90, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Pattern Indices"}],
  Cell[53394, 1510, 1056, 32, 104, "Text",
   CellTags->{"Generalized indices", "Pattern Indices"}],
  Cell[54487, 1547, 97, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Findind indices"}],
  Cell[54587, 1550, 7514, 227, 698, "Text",
   CellTags->{"Generalized indices", "Findind indices"}],
  Cell[62138, 1782, 97, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Sorting Indices"}],
  Cell[62238, 1785, 1705, 49, 122, "Text",
   CellTags->{"Generalized indices", "Sorting Indices"}],
  Cell[63980, 1839, 101, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Replacing indices"}],
  Cell[64084, 1842, 3883, 111, 284, "Text",
   CellTags->{"Generalized indices", "Replacing indices"}]},
 "GIndexQ"->{
  Cell[32609, 927, 86, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "GIndexQ"}],
  Cell[32698, 930, 9320, 265, 788, "Text",
   CellTags->{"GIndexQ", "Generalized indices"}]},
 "Abstract Indices"->{
  Cell[42055, 1200, 99, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Abstract Indices"}],
  Cell[42157, 1203, 4208, 101, 428, "Text",
   CellTags->{"Generalized indices", "Abstract Indices"}]},
 "Basis indices"->{
  Cell[46402, 1309, 115, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Basis indices"}],
  Cell[46520, 1312, 3324, 88, 320, "Text",
   CellTags->{"Generalized indices", "Basis indices"}]},
 "Directional indices"->{
  Cell[49881, 1405, 105, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Directional indices"}],
  Cell[49989, 1408, 1727, 45, 158, "Text",
   CellTags->{"Generalized indices", "Directional indices"}]},
 "Label Indices"->{
  Cell[51753, 1458, 93, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Label Indices"}],
  Cell[51849, 1461, 1415, 41, 122, "Text",
   CellTags->{"Generalized indices", "Label Indices"}]},
 "Pattern Indices"->{
  Cell[53301, 1507, 90, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Pattern Indices"}],
  Cell[53394, 1510, 1056, 32, 104, "Text",
   CellTags->{"Generalized indices", "Pattern Indices"}]},
 "Findind indices"->{
  Cell[54487, 1547, 97, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Findind indices"}],
  Cell[54587, 1550, 7514, 227, 698, "Text",
   CellTags->{"Generalized indices", "Findind indices"}]},
 "Sorting Indices"->{
  Cell[62138, 1782, 97, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Sorting Indices"}],
  Cell[62238, 1785, 1705, 49, 122, "Text",
   CellTags->{"Generalized indices", "Sorting Indices"}]},
 "Replacing indices"->{
  Cell[63980, 1839, 101, 1, 38, "Subsection",
   CellTags->{"Generalized indices", "Replacing indices"}],
  Cell[64084, 1842, 3883, 111, 284, "Text",
   CellTags->{"Generalized indices", "Replacing indices"}]},
 "Formatting of indexed objects"->{
  Cell[68016, 1959, 161, 3, 50, "Section",
   CellTags->"Formatting of indexed objects"],
  Cell[68180, 1964, 4455, 128, 374, "Text",
   CellTags->"Formatting of indexed objects"]},
 "Mathematical entities"->{
  Cell[72672, 2097, 145, 3, 50, "Section",
   CellTags->"Mathematical entities"],
  Cell[72820, 2102, 156, 6, 42, "Text",
   CellTags->"Mathematical entities"],
  Cell[73001, 2112, 101, 1, 55, "Subsection",
   CellTags->{"Mathematical entities", "Constant symbols"}],
  Cell[73105, 2115, 3555, 103, 266, "Text",
   CellTags->{"Constant symbols", "Mathematical entities"}],
  Cell[76697, 2223, 89, 1, 47, "Subsection",
   CellTags->{"Parameters", "Mathematical entities"}],
  Cell[76789, 2226, 4074, 116, 70, "Text",
   CellTags->{"Parameters", "Mathematical entities"}],
  Cell[80900, 2347, 116, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[81041, 2352, 92, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[81136, 2355, 3886, 116, 333, "Text",
   CellTags->{"Manifolds", "Mathematical entities"}],
  Cell[85059, 2476, 100, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[85162, 2479, 1711, 50, 123, "Text",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[86910, 2534, 95, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[87008, 2537, 1636, 47, 159, "Text",
   CellTags->{"Manifolds", "Mathematical entities"}],
  Cell[88681, 2589, 112, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[88796, 2592, 5477, 156, 470, "Text",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[94310, 2753, 95, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[94408, 2756, 2161, 60, 159, "Text",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[96606, 2821, 103, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[96712, 2824, 2237, 59, 161, "Text",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[99282, 2913, 83, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[99390, 2918, 85, 1, 70, "Subsubsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[99478, 2921, 3278, 113, 70, "Text",
   CellTags->{"Tensors", "Mathematical entities"}],
  Cell[102793, 3039, 103, 1, 70, "Subsubsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[102899, 3042, 9140, 252, 70, "Text",
   CellTags->{"Tensors", "Mathematical entities"}],
  Cell[112076, 3299, 96, 1, 70, "Subsubsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[112175, 3302, 3068, 94, 70, "Text",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[115280, 3401, 96, 1, 70, "Subsubsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[115379, 3404, 6391, 216, 70, "Text",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[121819, 3626, 111, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[121955, 3631, 136, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[122094, 3634, 2623, 74, 266, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[124754, 3713, 99, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[124856, 3716, 3654, 123, 266, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[128547, 3844, 117, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[128667, 3847, 6056, 181, 338, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[134760, 4033, 118, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[134881, 4036, 1350, 32, 140, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[136268, 4073, 113, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[136384, 4076, 12756, 422, 590, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[149177, 4503, 107, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[149287, 4506, 2295, 56, 230, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[151631, 4568, 83, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[151739, 4573, 85, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[151827, 4576, 2613, 88, 212, "Text",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[154477, 4669, 103, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[154583, 4672, 6780, 200, 374, "Text",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[161400, 4877, 96, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[161499, 4880, 3109, 109, 248, "Text",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[164645, 4994, 96, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[164744, 4997, 6588, 206, 338, "Text",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[171369, 5208, 99, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[171471, 5211, 2558, 86, 176, "Text",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[175915, 5362, 101, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Bases and charts"}],
  Cell[176019, 5365, 3457, 107, 70, "Text",
   CellTags->{"Mathematical entities", "Bases and charts"}],
  Cell[179513, 5477, 96, 1, 47, "Subsection",
   CellTags->{"Other ders", "Mathematical entities"}],
  Cell[179612, 5480, 4709, 162, 70, "Text",
   CellTags->{"Other ders", "Mathematical entities"}]},
 "Constant symbols"->{
  Cell[73001, 2112, 101, 1, 55, "Subsection",
   CellTags->{"Mathematical entities", "Constant symbols"}],
  Cell[73105, 2115, 3555, 103, 266, "Text",
   CellTags->{"Constant symbols", "Mathematical entities"}]},
 "Parameters"->{
  Cell[76697, 2223, 89, 1, 47, "Subsection",
   CellTags->{"Parameters", "Mathematical entities"}],
  Cell[76789, 2226, 4074, 116, 70, "Text",
   CellTags->{"Parameters", "Mathematical entities"}]},
 "Manifolds"->{
  Cell[80900, 2347, 116, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[81041, 2352, 92, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[81136, 2355, 3886, 116, 333, "Text",
   CellTags->{"Manifolds", "Mathematical entities"}],
  Cell[85059, 2476, 100, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[85162, 2479, 1711, 50, 123, "Text",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[86910, 2534, 95, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[87008, 2537, 1636, 47, 159, "Text",
   CellTags->{"Manifolds", "Mathematical entities"}],
  Cell[88681, 2589, 112, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[88796, 2592, 5477, 156, 470, "Text",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[94310, 2753, 95, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[94408, 2756, 2161, 60, 159, "Text",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[96606, 2821, 103, 1, 46, "Subsubsection",
   CellTags->{"Mathematical entities", "Manifolds"}],
  Cell[96712, 2824, 2237, 59, 161, "Text",
   CellTags->{"Mathematical entities", "Manifolds"}]},
 "Tensors"->{
  Cell[99282, 2913, 83, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[99390, 2918, 85, 1, 70, "Subsubsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[99478, 2921, 3278, 113, 70, "Text",
   CellTags->{"Tensors", "Mathematical entities"}],
  Cell[102793, 3039, 103, 1, 70, "Subsubsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[102899, 3042, 9140, 252, 70, "Text",
   CellTags->{"Tensors", "Mathematical entities"}],
  Cell[112076, 3299, 96, 1, 70, "Subsubsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[112175, 3302, 3068, 94, 70, "Text",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[115280, 3401, 96, 1, 70, "Subsubsection",
   CellTags->{"Mathematical entities", "Tensors"}],
  Cell[115379, 3404, 6391, 216, 70, "Text",
   CellTags->{"Mathematical entities", "Tensors"}]},
 "Covariant derivatives"->{
  Cell[121819, 3626, 111, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[121955, 3631, 136, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[122094, 3634, 2623, 74, 266, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[124754, 3713, 99, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[124856, 3716, 3654, 123, 266, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[128547, 3844, 117, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[128667, 3847, 6056, 181, 338, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[134760, 4033, 118, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[134881, 4036, 1350, 32, 140, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[136268, 4073, 113, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[136384, 4076, 12756, 422, 590, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[149177, 4503, 107, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Covariant derivatives"}],
  Cell[149287, 4506, 2295, 56, 230, "Text",
   CellTags->{"Mathematical entities", "Covariant derivatives"}]},
 "Metrics"->{
  Cell[151631, 4568, 83, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[151739, 4573, 85, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[151827, 4576, 2613, 88, 212, "Text",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[154477, 4669, 103, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[154583, 4672, 6780, 200, 374, "Text",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[161400, 4877, 96, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[161499, 4880, 3109, 109, 248, "Text",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[164645, 4994, 96, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[164744, 4997, 6588, 206, 338, "Text",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[171369, 5208, 99, 1, 28, "Subsubsection",
   CellTags->{"Mathematical entities", "Metrics"}],
  Cell[171471, 5211, 2558, 86, 176, "Text",
   CellTags->{"Mathematical entities", "Metrics"}]},
 "Bases and charts"->{
  Cell[175915, 5362, 101, 1, 47, "Subsection",
   CellTags->{"Mathematical entities", "Bases and charts"}],
  Cell[176019, 5365, 3457, 107, 70, "Text",
   CellTags->{"Mathematical entities", "Bases and charts"}]},
 "Other ders"->{
  Cell[179513, 5477, 96, 1, 47, "Subsection",
   CellTags->{"Other ders", "Mathematical entities"}],
  Cell[179612, 5480, 4709, 162, 70, "Text",
   CellTags->{"Other ders", "Mathematical entities"}]},
 "Input expressions"->{
  Cell[184370, 5648, 137, 3, 50, "Section",
   CellTags->"Input expressions"],
  Cell[184510, 5653, 151, 6, 70, "Text",
   CellTags->"Input expressions"],
  Cell[184686, 5663, 73, 1, 70, "Subsection",
   CellTags->"Input expressions"],
  Cell[185751, 5696, 93, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Tensor product"}],
  Cell[185847, 5699, 1876, 53, 70, "Text",
   CellTags->{"Input expressions", "Tensor product"}],
  Cell[187760, 5757, 98, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Scalar"}],
  Cell[187861, 5760, 3094, 88, 70, "Text",
   CellTags->{"Input expressions", "Scalar"}],
  Cell[190992, 5853, 87, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Inert Heads"}],
  Cell[191082, 5856, 3889, 118, 70, "Text",
   CellTags->{"Input expressions", "Inert Heads"}],
  Cell[195008, 5979, 97, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Scalar-functions"}],
  Cell[195108, 5982, 3236, 87, 70, "Text",
   CellTags->{"Scalar-functions", "Input expressions"}],
  Cell[198381, 6074, 103, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Complex conjugation"}],
  Cell[198487, 6077, 3743, 113, 70, "Text",
   CellTags->{"Input expressions", "Complex conjugation"}],
  Cell[202267, 6195, 85, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Validation"}],
  Cell[202355, 6198, 913, 26, 70, "Text",
   CellTags->{"Input expressions", "Validation"}]},
 "Tensor product"->{
  Cell[185751, 5696, 93, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Tensor product"}],
  Cell[185847, 5699, 1876, 53, 70, "Text",
   CellTags->{"Input expressions", "Tensor product"}]},
 "Scalar"->{
  Cell[187760, 5757, 98, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Scalar"}],
  Cell[187861, 5760, 3094, 88, 70, "Text",
   CellTags->{"Input expressions", "Scalar"}]},
 "Inert Heads"->{
  Cell[190992, 5853, 87, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Inert Heads"}],
  Cell[191082, 5856, 3889, 118, 70, "Text",
   CellTags->{"Input expressions", "Inert Heads"}]},
 "Scalar-functions"->{
  Cell[195008, 5979, 97, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Scalar-functions"}],
  Cell[195108, 5982, 3236, 87, 70, "Text",
   CellTags->{"Scalar-functions", "Input expressions"}]},
 "Complex conjugation"->{
  Cell[198381, 6074, 103, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Complex conjugation"}],
  Cell[198487, 6077, 3743, 113, 70, "Text",
   CellTags->{"Input expressions", "Complex conjugation"}]},
 "Validation"->{
  Cell[202267, 6195, 85, 1, 70, "Subsection",
   CellTags->{"Input expressions", "Validation"}],
  Cell[202355, 6198, 913, 26, 70, "Text",
   CellTags->{"Input expressions", "Validation"}]},
 "Rules"->{
  Cell[203317, 6230, 129, 3, 50, "Section",
   CellTags->"Rules"],
  Cell[203653, 6242, 76, 1, 70, "Subsection",
   CellTags->{"Rules", "IndexRule"}],
  Cell[203732, 6245, 2155, 69, 70, "Text",
   CellTags->{"Rules", "IndexRule"}],
  Cell[205924, 6319, 69, 1, 70, "Subsection",
   CellTags->{"Rules", "MakeRule"}],
  Cell[208451, 6401, 82, 1, 70, "Subsection",
   CellTags->{"Rules", "AutomaticRules"}],
  Cell[208536, 6404, 1021, 29, 70, "Text",
   CellTags->{"Rules", "AutomaticRules"}]},
 "IndexRule"->{
  Cell[203653, 6242, 76, 1, 70, "Subsection",
   CellTags->{"Rules", "IndexRule"}],
  Cell[203732, 6245, 2155, 69, 70, "Text",
   CellTags->{"Rules", "IndexRule"}]},
 "MakeRule"->{
  Cell[205924, 6319, 69, 1, 70, "Subsection",
   CellTags->{"Rules", "MakeRule"}]},
 "AutomaticRules"->{
  Cell[208451, 6401, 82, 1, 70, "Subsection",
   CellTags->{"Rules", "AutomaticRules"}],
  Cell[208536, 6404, 1021, 29, 70, "Text",
   CellTags->{"Rules", "AutomaticRules"}]},
 "Manipulation of input"->{
  Cell[209606, 6439, 145, 3, 50, "Section",
   CellTags->"Manipulation of input"],
  Cell[209776, 6446, 85, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "Symmetry"}],
  Cell[209864, 6449, 4137, 106, 393, "Text",
   CellTags->{"Manipulation of input", "Symmetry"}],
  Cell[214038, 6560, 115, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "ToCanonical"}],
  Cell[214156, 6563, 6894, 175, 748, "Text",
   CellTags->{"Manipulation of input", "ToCanonical"}],
  Cell[221087, 6743, 102, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "ImposeSymmetry"}],
  Cell[221192, 6746, 3240, 96, 275, "Text",
   CellTags->{"Manipulation of input", "ImposeSymmetry"}],
  Cell[224469, 6847, 95, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "Collecting"}],
  Cell[224567, 6850, 1693, 64, 158, "Text",
   CellTags->{"Manipulation of input", "Collecting"}],
  Cell[226297, 6919, 109, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "Color"}],
  Cell[226409, 6922, 1408, 40, 140, "Text",
   CellTags->{"Manipulation of input", "Color"}]},
 "Symmetry"->{
  Cell[209776, 6446, 85, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "Symmetry"}],
  Cell[209864, 6449, 4137, 106, 393, "Text",
   CellTags->{"Manipulation of input", "Symmetry"}]},
 "ToCanonical"->{
  Cell[214038, 6560, 115, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "ToCanonical"}],
  Cell[214156, 6563, 6894, 175, 748, "Text",
   CellTags->{"Manipulation of input", "ToCanonical"}]},
 "ImposeSymmetry"->{
  Cell[221087, 6743, 102, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "ImposeSymmetry"}],
  Cell[221192, 6746, 3240, 96, 275, "Text",
   CellTags->{"Manipulation of input", "ImposeSymmetry"}]},
 "Collecting"->{
  Cell[224469, 6847, 95, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "Collecting"}],
  Cell[224567, 6850, 1693, 64, 158, "Text",
   CellTags->{"Manipulation of input", "Collecting"}]},
 "Color"->{
  Cell[226297, 6919, 109, 1, 55, "Subsection",
   CellTags->{"Manipulation of input", "Color"}],
  Cell[226409, 6922, 1408, 40, 140, "Text",
   CellTags->{"Manipulation of input", "Color"}]},
 "List of commands"->{
  Cell[227866, 6968, 135, 3, 50, "Section",
   CellTags->"List of commands"],
  Cell[228004, 6973, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[228225, 6981, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[228456, 6989, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[228689, 6997, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[228926, 7005, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[229155, 7013, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[229394, 7021, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[229623, 7029, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[229848, 7037, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[230065, 7045, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[230284, 7053, 244, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[230531, 7061, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[230762, 7069, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[230995, 7077, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[231230, 7085, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[231455, 7093, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[231688, 7101, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[231919, 7109, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[232136, 7117, 212, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[232351, 7125, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[232568, 7133, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[232789, 7141, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[233006, 7149, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[233225, 7157, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[233444, 7165, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[233665, 7173, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[233884, 7181, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[234115, 7189, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[234352, 7197, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[234589, 7205, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[234818, 7213, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[235039, 7221, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[235264, 7229, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[235499, 7237, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[235738, 7245, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[235965, 7253, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[236196, 7261, 212, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[236411, 7269, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[236628, 7277, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[236847, 7285, 240, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[237090, 7293, 250, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[237343, 7301, 248, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[237594, 7309, 256, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[237853, 7317, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[238135, 7327, 248, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[238386, 7335, 240, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[238629, 7343, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[238846, 7351, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[239071, 7359, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[239298, 7367, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[239517, 7375, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[239740, 7383, 248, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[239991, 7391, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[240343, 7405, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[240572, 7413, 246, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[240821, 7421, 240, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[241064, 7429, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[241289, 7437, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[241508, 7445, 238, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[241749, 7453, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[241982, 7461, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[242205, 7469, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[242438, 7477, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[242673, 7485, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[242910, 7493, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[243149, 7501, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[243376, 7509, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[243609, 7517, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[243844, 7525, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[244079, 7533, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[244316, 7541, 210, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[244529, 7549, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[244756, 7557, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[244985, 7565, 212, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[245200, 7573, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[245417, 7581, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[245656, 7589, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[245879, 7597, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[246104, 7605, 238, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[246345, 7613, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[246562, 7621, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[246789, 7629, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[247008, 7637, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[247245, 7645, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[247484, 7653, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[247703, 7661, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[247932, 7669, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[248151, 7677, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[248372, 7685, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[248599, 7693, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[248822, 7701, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[249051, 7709, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[249288, 7717, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[249527, 7725, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[249750, 7733, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[249975, 7741, 212, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[250190, 7749, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[250423, 7757, 242, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[250708, 7767, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[250939, 7775, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[251168, 7783, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[251385, 7791, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[251604, 7799, 208, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[251815, 7807, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[252040, 7815, 238, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[252281, 7823, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[252516, 7831, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[252749, 7839, 210, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[252962, 7847, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[253185, 7855, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[253410, 7863, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[253637, 7871, 212, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[253852, 7879, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[254071, 7887, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[254290, 7895, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[254511, 7903, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[254746, 7911, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[254965, 7919, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[255194, 7927, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[255433, 7935, 212, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[255648, 7943, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[255887, 7951, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[256116, 7959, 240, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[256359, 7967, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[256588, 7975, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[256813, 7983, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[257048, 7991, 246, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[257297, 7999, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[257528, 8007, 238, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[257769, 8015, 234, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[258006, 8023, 232, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[258241, 8031, 224, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[258468, 8039, 252, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[258723, 8047, 220, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[258946, 8055, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[259171, 8063, 224, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[259398, 8071, 232, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[259633, 8079, 210, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[259846, 8087, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[260067, 8095, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[260292, 8103, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[260558, 8113, 214, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[260775, 8121, 240, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[261018, 8129, 216, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[261237, 8137, 234, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[261474, 8145, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[261699, 8153, 248, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[261950, 8161, 246, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[262199, 8169, 220, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[262422, 8177, 216, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[262641, 8185, 220, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[262864, 8193, 230, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[263097, 8201, 234, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[263334, 8209, 226, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[263563, 8217, 220, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[263786, 8225, 220, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[264009, 8233, 228, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[264240, 8241, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[264465, 8249, 220, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[264688, 8257, 234, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[264925, 8265, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[265146, 8273, 232, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[265381, 8281, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[265606, 8289, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[265829, 8297, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[266052, 8305, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[266289, 8313, 242, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[266534, 8321, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[266761, 8329, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[266984, 8337, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[267209, 8345, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[267436, 8353, 208, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[267647, 8361, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[267870, 8369, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[268087, 8377, 205, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[268295, 8385, 210, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[268508, 8393, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[268733, 8401, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[268950, 8409, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[269169, 8417, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[269388, 8425, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[269609, 8433, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[269830, 8441, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[270063, 8449, 220, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[270286, 8457, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[270511, 8465, 224, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[270738, 8473, 214, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[270955, 8481, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[271176, 8489, 214, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[271393, 8497, 230, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[271626, 8505, 226, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[271855, 8513, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[272076, 8521, 216, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[272295, 8529, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[272516, 8537, 226, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[272745, 8545, 234, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[272982, 8553, 236, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[273221, 8561, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[273446, 8569, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[273667, 8577, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[273892, 8585, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[274113, 8593, 226, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[274342, 8601, 232, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[274577, 8609, 216, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[274796, 8617, 238, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[275037, 8625, 212, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[275252, 8633, 230, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[275485, 8641, 214, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[275702, 8649, 220, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[275925, 8657, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[276150, 8665, 224, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[276377, 8673, 226, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[276606, 8681, 226, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[276835, 8689, 230, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[277068, 8697, 205, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[277276, 8705, 245, 7, 42, "Input",
   CellTags->"List of commands"],
  Cell[277524, 8714, 214, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[277741, 8722, 216, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[277960, 8730, 216, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[278179, 8738, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[278418, 8746, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[278653, 8754, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[278892, 8762, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[279123, 8770, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[279360, 8778, 238, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[279601, 8786, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[279824, 8794, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[280063, 8802, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[280290, 8810, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[280513, 8818, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[280748, 8826, 210, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[280961, 8834, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[281192, 8842, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[281425, 8850, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[281654, 8858, 212, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[281869, 8866, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[282096, 8874, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[282321, 8882, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[282556, 8890, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[282789, 8898, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[283008, 8906, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[283237, 8914, 242, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[283482, 8922, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[283713, 8930, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[283944, 8938, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[284161, 8946, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[284388, 8954, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[284605, 8962, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[284838, 8970, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[285073, 8978, 234, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[285310, 8986, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[285529, 8994, 240, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[285772, 9002, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[285999, 9010, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[286232, 9018, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[286457, 9026, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[286731, 9036, 246, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[286980, 9044, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[287211, 9052, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[287450, 9060, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[287685, 9068, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[287918, 9076, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[288149, 9084, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[288372, 9092, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[288605, 9100, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[288836, 9108, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[289061, 9116, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[289280, 9124, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[289509, 9132, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[289738, 9140, 246, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[289987, 9148, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[290214, 9156, 242, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[290459, 9164, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[290688, 9172, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[290917, 9180, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[291142, 9188, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[291363, 9196, 244, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[291610, 9204, 250, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[291863, 9212, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[292088, 9220, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[292307, 9228, 248, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[292558, 9236, 214, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[292775, 9244, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[292996, 9252, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[293217, 9260, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[293444, 9268, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[293663, 9276, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[293896, 9284, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[294335, 9299, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[294554, 9307, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[294775, 9315, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[295004, 9323, 242, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[295249, 9331, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[295474, 9339, 238, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[295715, 9347, 236, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[295954, 9355, 232, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[296189, 9363, 212, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[296404, 9371, 238, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[296645, 9379, 240, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[296888, 9387, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[297111, 9395, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[297384, 9405, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[297615, 9413, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[297842, 9421, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[298075, 9429, 240, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[298318, 9437, 224, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[298545, 9445, 226, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[298774, 9453, 205, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[298982, 9461, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[299201, 9469, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[299422, 9477, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[299645, 9485, 238, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[299886, 9493, 228, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[300117, 9501, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[300338, 9509, 248, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[300589, 9517, 222, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[300814, 9525, 210, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[301027, 9533, 216, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[301246, 9541, 218, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[301467, 9549, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[301700, 9557, 220, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[301923, 9565, 230, 6, 27, "Input",
   CellTags->"List of commands"],
  Cell[302156, 9573, 232, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[302391, 9581, 244, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[302638, 9589, 216, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[302857, 9597, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[303078, 9605, 222, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[303303, 9613, 236, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[303542, 9621, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[303763, 9629, 230, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[303996, 9637, 210, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[304209, 9645, 228, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[304440, 9653, 244, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[304687, 9661, 212, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[304902, 9669, 234, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[305139, 9677, 232, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[305374, 9685, 218, 6, 42, "Input",
   CellTags->"List of commands"],
  Cell[305595, 9693, 210, 6, 42, "Input",
   CellTags->"List of commands"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Loading", 307371, 9747},
 {"Symbols and types", 307525, 9752},
 {"Valid symbols", 308485, 9773},
 {"Type managing", 308700, 9778},
 {"Relations among symbols", 308927, 9783},
 {"Generalized indices", 309273, 9790},
 {"GIndexQ", 311198, 9829},
 {"Abstract Indices", 311409, 9834},
 {"Basis indices", 311637, 9839},
 {"Directional indices", 311865, 9844},
 {"Label Indices", 312099, 9849},
 {"Pattern Indices", 312322, 9854},
 {"Findind indices", 312549, 9859},
 {"Sorting Indices", 312777, 9864},
 {"Replacing indices", 313006, 9869},
 {"Formatting of indexed objects", 313253, 9874},
 {"Mathematical entities", 313463, 9879},
 {"Constant symbols", 319212, 9992},
 {"Parameters", 319442, 9997},
 {"Manifolds", 319657, 10002},
 {"Tensors", 320971, 10029},
 {"Covariant derivatives", 321883, 10048},
 {"Metrics", 323370, 10075},
 {"Bases and charts", 324481, 10098},
 {"Other ders", 324712, 10103},
 {"Input expressions", 324937, 10108},
 {"Tensor product", 326375, 10139},
 {"Scalar", 326588, 10144},
 {"Inert Heads", 326790, 10149},
 {"Scalar-functions", 327008, 10154},
 {"Complex conjugation", 327238, 10159},
 {"Validation", 327467, 10164},
 {"Rules", 327670, 10169},
 {"IndexRule", 328177, 10182},
 {"MakeRule", 328358, 10187},
 {"AutomaticRules", 328463, 10190},
 {"Manipulation of input", 328667, 10195},
 {"Symmetry", 329767, 10218},
 {"ToCanonical", 329983, 10223},
 {"ImposeSymmetry", 330209, 10228},
 {"Collecting", 330436, 10233},
 {"Color", 330649, 10238},
 {"List of commands", 330864, 10243}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 83, 1, 92, "Title"],
Cell[665, 25, 116, 1, 51, "Subtitle"],
Cell[784, 28, 105, 4, 69, "Subsubtitle"],
Cell[892, 34, 1039, 28, 165, "Text"],
Cell[CellGroupData[{
Cell[1956, 66, 97, 3, 80, "Section",
 CellTags->"Loading"],
Cell[2056, 71, 3250, 89, 466, "Text",
 CellTags->"Loading"]
}, Closed]],
Cell[CellGroupData[{
Cell[5343, 165, 137, 3, 50, "Section",
 CellTags->"Symbols and types"],
Cell[CellGroupData[{
Cell[5505, 172, 84, 1, 44, "Subsection",
 CellTags->"Symbols and types"],
Cell[5592, 175, 401, 9, 69, "Text"],
Cell[5996, 186, 3840, 86, 665, "Text",
 CellTags->"Symbols and types"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9873, 277, 103, 1, 38, "Subsection",
 CellTags->{"Symbols and types", "Valid symbols"}],
Cell[9979, 280, 4160, 111, 356, "Text",
 CellTags->{"Symbols and types", "Valid symbols"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[14176, 396, 91, 1, 44, "Subsection",
 CellTags->{"Symbols and types", "Type managing"}],
Cell[14270, 399, 14517, 410, 673, "Text",
 CellTags->{"Symbols and types", "Type managing"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[28824, 814, 111, 1, 44, "Subsection",
 CellTags->{"Symbols and types", "Relations among symbols"}],
Cell[28938, 817, 2554, 66, 243, "Text",
 CellTags->{"Relations among symbols", "Symbols and types"}],
Cell[31495, 885, 899, 29, 71, "Text",
 CellTags->{"Relations among symbols", "Symbols and types"}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32443, 920, 141, 3, 50, "Section",
 CellTags->"Generalized indices"],
Cell[CellGroupData[{
Cell[32609, 927, 86, 1, 38, "Subsection",
 CellTags->{"Generalized indices", "GIndexQ"}],
Cell[32698, 930, 9320, 265, 788, "Text",
 CellTags->{"GIndexQ", "Generalized indices"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[42055, 1200, 99, 1, 38, "Subsection",
 CellTags->{"Generalized indices", "Abstract Indices"}],
Cell[42157, 1203, 4208, 101, 428, "Text",
 CellTags->{"Generalized indices", "Abstract Indices"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[46402, 1309, 115, 1, 38, "Subsection",
 CellTags->{"Generalized indices", "Basis indices"}],
Cell[46520, 1312, 3324, 88, 320, "Text",
 CellTags->{"Generalized indices", "Basis indices"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[49881, 1405, 105, 1, 38, "Subsection",
 CellTags->{"Generalized indices", "Directional indices"}],
Cell[49989, 1408, 1727, 45, 158, "Text",
 CellTags->{"Generalized indices", "Directional indices"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[51753, 1458, 93, 1, 38, "Subsection",
 CellTags->{"Generalized indices", "Label Indices"}],
Cell[51849, 1461, 1415, 41, 122, "Text",
 CellTags->{"Generalized indices", "Label Indices"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[53301, 1507, 90, 1, 38, "Subsection",
 CellTags->{"Generalized indices", "Pattern Indices"}],
Cell[53394, 1510, 1056, 32, 104, "Text",
 CellTags->{"Generalized indices", "Pattern Indices"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[54487, 1547, 97, 1, 38, "Subsection",
 CellTags->{"Generalized indices", "Findind indices"}],
Cell[54587, 1550, 7514, 227, 698, "Text",
 CellTags->{"Generalized indices", "Findind indices"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[62138, 1782, 97, 1, 38, "Subsection",
 CellTags->{"Generalized indices", "Sorting Indices"}],
Cell[62238, 1785, 1705, 49, 122, "Text",
 CellTags->{"Generalized indices", "Sorting Indices"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[63980, 1839, 101, 1, 38, "Subsection",
 CellTags->{"Generalized indices", "Replacing indices"}],
Cell[64084, 1842, 3883, 111, 284, "Text",
 CellTags->{"Generalized indices", "Replacing indices"}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[68016, 1959, 161, 3, 50, "Section",
 CellTags->"Formatting of indexed objects"],
Cell[68180, 1964, 4455, 128, 374, "Text",
 CellTags->"Formatting of indexed objects"]
}, Closed]],
Cell[CellGroupData[{
Cell[72672, 2097, 145, 3, 50, "Section",
 CellTags->"Mathematical entities"],
Cell[72820, 2102, 156, 6, 42, "Text",
 CellTags->"Mathematical entities"],
Cell[CellGroupData[{
Cell[73001, 2112, 101, 1, 55, "Subsection",
 CellTags->{"Mathematical entities", "Constant symbols"}],
Cell[73105, 2115, 3555, 103, 266, "Text",
 CellTags->{"Constant symbols", "Mathematical entities"}]
}, Closed]],
Cell[CellGroupData[{
Cell[76697, 2223, 89, 1, 47, "Subsection",
 CellTags->{"Parameters", "Mathematical entities"}],
Cell[76789, 2226, 4074, 116, 70, "Text",
 CellTags->{"Parameters", "Mathematical entities"}]
}, Closed]],
Cell[CellGroupData[{
Cell[80900, 2347, 116, 1, 47, "Subsection",
 CellTags->{"Mathematical entities", "Manifolds"}],
Cell[CellGroupData[{
Cell[81041, 2352, 92, 1, 46, "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],
Cell[81136, 2355, 3886, 116, 333, "Text",
 CellTags->{"Manifolds", "Mathematical entities"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[85059, 2476, 100, 1, 46, "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],
Cell[85162, 2479, 1711, 50, 123, "Text",
 CellTags->{"Mathematical entities", "Manifolds"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[86910, 2534, 95, 1, 46, "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],
Cell[87008, 2537, 1636, 47, 159, "Text",
 CellTags->{"Manifolds", "Mathematical entities"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[88681, 2589, 112, 1, 46, "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],
Cell[88796, 2592, 5477, 156, 470, "Text",
 CellTags->{"Mathematical entities", "Manifolds"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[94310, 2753, 95, 1, 46, "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],
Cell[94408, 2756, 2161, 60, 159, "Text",
 CellTags->{"Mathematical entities", "Manifolds"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[96606, 2821, 103, 1, 46, "Subsubsection",
 CellTags->{"Mathematical entities", "Manifolds"}],
Cell[96712, 2824, 2237, 59, 161, "Text",
 CellTags->{"Mathematical entities", "Manifolds"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[98986, 2888, 40, 0, 35, "Subsubsection"],
Cell[99029, 2890, 204, 17, 315, "Text"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[99282, 2913, 83, 1, 47, "Subsection",
 CellTags->{"Mathematical entities", "Tensors"}],
Cell[CellGroupData[{
Cell[99390, 2918, 85, 1, 70, "Subsubsection",
 CellTags->{"Mathematical entities", "Tensors"}],
Cell[99478, 2921, 3278, 113, 70, "Text",
 CellTags->{"Tensors", "Mathematical entities"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[102793, 3039, 103, 1, 70, "Subsubsection",
 CellTags->{"Mathematical entities", "Tensors"}],
Cell[102899, 3042, 9140, 252, 70, "Text",
 CellTags->{"Tensors", "Mathematical entities"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[112076, 3299, 96, 1, 70, "Subsubsection",
 CellTags->{"Mathematical entities", "Tensors"}],
Cell[112175, 3302, 3068, 94, 70, "Text",
 CellTags->{"Mathematical entities", "Tensors"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[115280, 3401, 96, 1, 70, "Subsubsection",
 CellTags->{"Mathematical entities", "Tensors"}],
Cell[115379, 3404, 6391, 216, 70, "Text",
 CellTags->{"Mathematical entities", "Tensors"}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[121819, 3626, 111, 1, 47, "Subsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],
Cell[CellGroupData[{
Cell[121955, 3631, 136, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],
Cell[122094, 3634, 2623, 74, 266, "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[124754, 3713, 99, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],
Cell[124856, 3716, 3654, 123, 266, "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[128547, 3844, 117, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],
Cell[128667, 3847, 6056, 181, 338, "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[134760, 4033, 118, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],
Cell[134881, 4036, 1350, 32, 140, "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[136268, 4073, 113, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],
Cell[136384, 4076, 12756, 422, 590, "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[149177, 4503, 107, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Covariant derivatives"}],
Cell[149287, 4506, 2295, 56, 230, "Text",
 CellTags->{"Mathematical entities", "Covariant derivatives"}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[151631, 4568, 83, 1, 47, "Subsection",
 CellTags->{"Mathematical entities", "Metrics"}],
Cell[CellGroupData[{
Cell[151739, 4573, 85, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],
Cell[151827, 4576, 2613, 88, 212, "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[154477, 4669, 103, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],
Cell[154583, 4672, 6780, 200, 374, "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[161400, 4877, 96, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],
Cell[161499, 4880, 3109, 109, 248, "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[164645, 4994, 96, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],
Cell[164744, 4997, 6588, 206, 338, "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[171369, 5208, 99, 1, 28, "Subsubsection",
 CellTags->{"Mathematical entities", "Metrics"}],
Cell[171471, 5211, 2558, 86, 176, "Text",
 CellTags->{"Mathematical entities", "Metrics"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[174066, 5302, 51, 0, 28, "Subsubsection"],
Cell[174120, 5304, 1746, 52, 194, "Text"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[175915, 5362, 101, 1, 47, "Subsection",
 CellTags->{"Mathematical entities", "Bases and charts"}],
Cell[176019, 5365, 3457, 107, 70, "Text",
 CellTags->{"Mathematical entities", "Bases and charts"}]
}, Closed]],
Cell[CellGroupData[{
Cell[179513, 5477, 96, 1, 47, "Subsection",
 CellTags->{"Other ders", "Mathematical entities"}],
Cell[179612, 5480, 4709, 162, 70, "Text",
 CellTags->{"Other ders", "Mathematical entities"}]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[184370, 5648, 137, 3, 50, "Section",
 CellTags->"Input expressions"],
Cell[184510, 5653, 151, 6, 70, "Text",
 CellTags->"Input expressions"],
Cell[CellGroupData[{
Cell[184686, 5663, 73, 1, 70, "Subsection",
 CellTags->"Input expressions"],
Cell[184762, 5666, 952, 25, 70, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[185751, 5696, 93, 1, 70, "Subsection",
 CellTags->{"Input expressions", "Tensor product"}],
Cell[185847, 5699, 1876, 53, 70, "Text",
 CellTags->{"Input expressions", "Tensor product"}]
}, Closed]],
Cell[CellGroupData[{
Cell[187760, 5757, 98, 1, 70, "Subsection",
 CellTags->{"Input expressions", "Scalar"}],
Cell[187861, 5760, 3094, 88, 70, "Text",
 CellTags->{"Input expressions", "Scalar"}]
}, Closed]],
Cell[CellGroupData[{
Cell[190992, 5853, 87, 1, 70, "Subsection",
 CellTags->{"Input expressions", "Inert Heads"}],
Cell[191082, 5856, 3889, 118, 70, "Text",
 CellTags->{"Input expressions", "Inert Heads"}]
}, Closed]],
Cell[CellGroupData[{
Cell[195008, 5979, 97, 1, 70, "Subsection",
 CellTags->{"Input expressions", "Scalar-functions"}],
Cell[195108, 5982, 3236, 87, 70, "Text",
 CellTags->{"Scalar-functions", "Input expressions"}]
}, Closed]],
Cell[CellGroupData[{
Cell[198381, 6074, 103, 1, 70, "Subsection",
 CellTags->{"Input expressions", "Complex conjugation"}],
Cell[198487, 6077, 3743, 113, 70, "Text",
 CellTags->{"Input expressions", "Complex conjugation"}]
}, Closed]],
Cell[CellGroupData[{
Cell[202267, 6195, 85, 1, 70, "Subsection",
 CellTags->{"Input expressions", "Validation"}],
Cell[202355, 6198, 913, 26, 70, "Text",
 CellTags->{"Input expressions", "Validation"}]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[203317, 6230, 129, 3, 50, "Section",
 CellTags->"Rules"],
Cell[203449, 6235, 179, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[203653, 6242, 76, 1, 70, "Subsection",
 CellTags->{"Rules", "IndexRule"}],
Cell[203732, 6245, 2155, 69, 70, "Text",
 CellTags->{"Rules", "IndexRule"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[205924, 6319, 69, 1, 70, "Subsection",
 CellTags->{"Rules", "MakeRule"}],
Cell[205996, 6322, 2418, 74, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[208451, 6401, 82, 1, 70, "Subsection",
 CellTags->{"Rules", "AutomaticRules"}],
Cell[208536, 6404, 1021, 29, 70, "Text",
 CellTags->{"Rules", "AutomaticRules"}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[209606, 6439, 145, 3, 50, "Section",
 CellTags->"Manipulation of input"],
Cell[CellGroupData[{
Cell[209776, 6446, 85, 1, 55, "Subsection",
 CellTags->{"Manipulation of input", "Symmetry"}],
Cell[209864, 6449, 4137, 106, 393, "Text",
 CellTags->{"Manipulation of input", "Symmetry"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[214038, 6560, 115, 1, 55, "Subsection",
 CellTags->{"Manipulation of input", "ToCanonical"}],
Cell[214156, 6563, 6894, 175, 748, "Text",
 CellTags->{"Manipulation of input", "ToCanonical"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[221087, 6743, 102, 1, 55, "Subsection",
 CellTags->{"Manipulation of input", "ImposeSymmetry"}],
Cell[221192, 6746, 3240, 96, 275, "Text",
 CellTags->{"Manipulation of input", "ImposeSymmetry"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[224469, 6847, 95, 1, 55, "Subsection",
 CellTags->{"Manipulation of input", "Collecting"}],
Cell[224567, 6850, 1693, 64, 158, "Text",
 CellTags->{"Manipulation of input", "Collecting"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[226297, 6919, 109, 1, 55, "Subsection",
 CellTags->{"Manipulation of input", "Color"}],
Cell[226409, 6922, 1408, 40, 140, "Text",
 CellTags->{"Manipulation of input", "Color"}]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[227866, 6968, 135, 3, 50, "Section",
 CellTags->"List of commands"],
Cell[228004, 6973, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[228225, 6981, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[228456, 6989, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[228689, 6997, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[228926, 7005, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[229155, 7013, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[229394, 7021, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[229623, 7029, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[229848, 7037, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[230065, 7045, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[230284, 7053, 244, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[230531, 7061, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[230762, 7069, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[230995, 7077, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[231230, 7085, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[231455, 7093, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[231688, 7101, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[231919, 7109, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[232136, 7117, 212, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[232351, 7125, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[232568, 7133, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[232789, 7141, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[233006, 7149, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[233225, 7157, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[233444, 7165, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[233665, 7173, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[233884, 7181, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[234115, 7189, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[234352, 7197, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[234589, 7205, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[234818, 7213, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[235039, 7221, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[235264, 7229, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[235499, 7237, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[235738, 7245, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[235965, 7253, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[236196, 7261, 212, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[236411, 7269, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[236628, 7277, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[236847, 7285, 240, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[237090, 7293, 250, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[237343, 7301, 248, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[237594, 7309, 256, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[237853, 7317, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[238080, 7325, 52, 0, 27, "Input"],
Cell[238135, 7327, 248, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[238386, 7335, 240, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[238629, 7343, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[238846, 7351, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[239071, 7359, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[239298, 7367, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[239517, 7375, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[239740, 7383, 248, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[239991, 7391, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[240216, 7399, 41, 0, 27, "Input"],
Cell[240260, 7401, 40, 0, 27, "Input"],
Cell[240303, 7403, 37, 0, 27, "Input"],
Cell[240343, 7405, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[240572, 7413, 246, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[240821, 7421, 240, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[241064, 7429, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[241289, 7437, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[241508, 7445, 238, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[241749, 7453, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[241982, 7461, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[242205, 7469, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[242438, 7477, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[242673, 7485, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[242910, 7493, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[243149, 7501, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[243376, 7509, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[243609, 7517, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[243844, 7525, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[244079, 7533, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[244316, 7541, 210, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[244529, 7549, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[244756, 7557, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[244985, 7565, 212, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[245200, 7573, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[245417, 7581, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[245656, 7589, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[245879, 7597, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[246104, 7605, 238, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[246345, 7613, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[246562, 7621, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[246789, 7629, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[247008, 7637, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[247245, 7645, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[247484, 7653, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[247703, 7661, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[247932, 7669, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[248151, 7677, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[248372, 7685, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[248599, 7693, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[248822, 7701, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[249051, 7709, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[249288, 7717, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[249527, 7725, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[249750, 7733, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[249975, 7741, 212, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[250190, 7749, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[250423, 7757, 242, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[250668, 7765, 37, 0, 27, "Input"],
Cell[250708, 7767, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[250939, 7775, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[251168, 7783, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[251385, 7791, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[251604, 7799, 208, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[251815, 7807, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[252040, 7815, 238, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[252281, 7823, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[252516, 7831, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[252749, 7839, 210, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[252962, 7847, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[253185, 7855, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[253410, 7863, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[253637, 7871, 212, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[253852, 7879, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[254071, 7887, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[254290, 7895, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[254511, 7903, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[254746, 7911, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[254965, 7919, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[255194, 7927, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[255433, 7935, 212, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[255648, 7943, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[255887, 7951, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[256116, 7959, 240, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[256359, 7967, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[256588, 7975, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[256813, 7983, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[257048, 7991, 246, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[257297, 7999, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[257528, 8007, 238, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[257769, 8015, 234, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[258006, 8023, 232, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[258241, 8031, 224, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[258468, 8039, 252, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[258723, 8047, 220, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[258946, 8055, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[259171, 8063, 224, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[259398, 8071, 232, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[259633, 8079, 210, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[259846, 8087, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[260067, 8095, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[260292, 8103, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[260517, 8111, 38, 0, 28, "Input"],
Cell[260558, 8113, 214, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[260775, 8121, 240, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[261018, 8129, 216, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[261237, 8137, 234, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[261474, 8145, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[261699, 8153, 248, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[261950, 8161, 246, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[262199, 8169, 220, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[262422, 8177, 216, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[262641, 8185, 220, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[262864, 8193, 230, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[263097, 8201, 234, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[263334, 8209, 226, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[263563, 8217, 220, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[263786, 8225, 220, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[264009, 8233, 228, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[264240, 8241, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[264465, 8249, 220, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[264688, 8257, 234, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[264925, 8265, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[265146, 8273, 232, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[265381, 8281, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[265606, 8289, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[265829, 8297, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[266052, 8305, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[266289, 8313, 242, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[266534, 8321, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[266761, 8329, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[266984, 8337, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[267209, 8345, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[267436, 8353, 208, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[267647, 8361, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[267870, 8369, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[268087, 8377, 205, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[268295, 8385, 210, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[268508, 8393, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[268733, 8401, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[268950, 8409, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[269169, 8417, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[269388, 8425, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[269609, 8433, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[269830, 8441, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[270063, 8449, 220, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[270286, 8457, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[270511, 8465, 224, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[270738, 8473, 214, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[270955, 8481, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[271176, 8489, 214, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[271393, 8497, 230, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[271626, 8505, 226, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[271855, 8513, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[272076, 8521, 216, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[272295, 8529, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[272516, 8537, 226, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[272745, 8545, 234, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[272982, 8553, 236, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[273221, 8561, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[273446, 8569, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[273667, 8577, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[273892, 8585, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[274113, 8593, 226, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[274342, 8601, 232, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[274577, 8609, 216, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[274796, 8617, 238, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[275037, 8625, 212, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[275252, 8633, 230, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[275485, 8641, 214, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[275702, 8649, 220, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[275925, 8657, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[276150, 8665, 224, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[276377, 8673, 226, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[276606, 8681, 226, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[276835, 8689, 230, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[277068, 8697, 205, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[277276, 8705, 245, 7, 42, "Input",
 CellTags->"List of commands"],
Cell[277524, 8714, 214, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[277741, 8722, 216, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[277960, 8730, 216, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[278179, 8738, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[278418, 8746, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[278653, 8754, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[278892, 8762, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[279123, 8770, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[279360, 8778, 238, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[279601, 8786, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[279824, 8794, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[280063, 8802, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[280290, 8810, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[280513, 8818, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[280748, 8826, 210, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[280961, 8834, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[281192, 8842, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[281425, 8850, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[281654, 8858, 212, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[281869, 8866, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[282096, 8874, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[282321, 8882, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[282556, 8890, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[282789, 8898, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[283008, 8906, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[283237, 8914, 242, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[283482, 8922, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[283713, 8930, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[283944, 8938, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[284161, 8946, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[284388, 8954, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[284605, 8962, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[284838, 8970, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[285073, 8978, 234, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[285310, 8986, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[285529, 8994, 240, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[285772, 9002, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[285999, 9010, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[286232, 9018, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[286457, 9026, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[286688, 9034, 40, 0, 27, "Input"],
Cell[286731, 9036, 246, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[286980, 9044, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[287211, 9052, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[287450, 9060, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[287685, 9068, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[287918, 9076, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[288149, 9084, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[288372, 9092, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[288605, 9100, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[288836, 9108, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[289061, 9116, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[289280, 9124, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[289509, 9132, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[289738, 9140, 246, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[289987, 9148, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[290214, 9156, 242, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[290459, 9164, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[290688, 9172, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[290917, 9180, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[291142, 9188, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[291363, 9196, 244, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[291610, 9204, 250, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[291863, 9212, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[292088, 9220, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[292307, 9228, 248, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[292558, 9236, 214, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[292775, 9244, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[292996, 9252, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[293217, 9260, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[293444, 9268, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[293663, 9276, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[293896, 9284, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[294123, 9292, 209, 5, 27, "Input"],
Cell[294335, 9299, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[294554, 9307, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[294775, 9315, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[295004, 9323, 242, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[295249, 9331, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[295474, 9339, 238, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[295715, 9347, 236, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[295954, 9355, 232, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[296189, 9363, 212, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[296404, 9371, 238, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[296645, 9379, 240, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[296888, 9387, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[297111, 9395, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[297344, 9403, 37, 0, 27, "Input"],
Cell[297384, 9405, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[297615, 9413, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[297842, 9421, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[298075, 9429, 240, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[298318, 9437, 224, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[298545, 9445, 226, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[298774, 9453, 205, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[298982, 9461, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[299201, 9469, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[299422, 9477, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[299645, 9485, 238, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[299886, 9493, 228, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[300117, 9501, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[300338, 9509, 248, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[300589, 9517, 222, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[300814, 9525, 210, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[301027, 9533, 216, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[301246, 9541, 218, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[301467, 9549, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[301700, 9557, 220, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[301923, 9565, 230, 6, 27, "Input",
 CellTags->"List of commands"],
Cell[302156, 9573, 232, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[302391, 9581, 244, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[302638, 9589, 216, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[302857, 9597, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[303078, 9605, 222, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[303303, 9613, 236, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[303542, 9621, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[303763, 9629, 230, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[303996, 9637, 210, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[304209, 9645, 228, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[304440, 9653, 244, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[304687, 9661, 212, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[304902, 9669, 234, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[305139, 9677, 232, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[305374, 9685, 218, 6, 42, "Input",
 CellTags->"List of commands"],
Cell[305595, 9693, 210, 6, 42, "Input",
 CellTags->"List of commands"]
}, Closed]],
Cell[CellGroupData[{
Cell[305842, 9704, 98, 2, 39, "Section"],
Cell[305943, 9708, 751, 16, 144, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
