Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xAct`xTerior`",
 FontSize->18]], "Section",
 CellTags->{
  "S5.18.1", "1.1"},ExpressionUUID->"c46b6d29-1417-417b-95df-8e121b46f21d"],

Cell[TextData[{
 "This is the doc file xTeriorDoc.nb of version 0.9.1 of ",
 StyleBox["xTerior`",
  FontFamily->"Courier"],
 "Last update on Date 28 of January of 2014."
}], "Text",
 FontFamily->"Arial",
 FontWeight->"Plain",ExpressionUUID->"a19c5ed6-f2e1-4e67-a43f-0ed54b719b00"],

Cell[TextData[{
 StyleBox["Web:",
  FontWeight->"Bold"],
 "\t",
 StyleBox[ButtonBox["http://www.xact.es/xTerior/\n\t \
https://github.com/xAct-contrib/xTerior",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.xact.es/Spinors/"], None},
  ButtonNote->"http://www.xact.es/Spinors/"],
  FontFamily->"Courier"]
}], "Text",
 FontWeight->"Plain",ExpressionUUID->"cfd22a42-6ad8-4f07-b416-72d67cec0e69"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Authors",
 FontSize->
  14]], "SubsectionIcon",ExpressionUUID->"d4978679-a914-46e9-921c-\
cc1f98b3e0ba"],

Cell[TextData[{
 "\[Copyright] 2013-2019, under the GNU General Public License (GPL)\n    ",
 StyleBox[" Alfonso Garc\[IAcute]a-Parrado G\[OAcute]mez-Lobo\n",
  FontWeight->"Bold"],
 "\tDepartamento de matem\[AAcute]ticas\n\tUniversidad de C\[OAcute]rdoba, \
Spain",
 StyleBox["\n",
  FontWeight->"Bold"],
 "\t",
 StyleBox["agparrado@uco.es",
  FontFamily->"Courier"],
 "\n     and\n     ",
 StyleBox["Leo C. Stein\n           ",
  FontWeight->"Bold"],
 "U of MS, United States",
 StyleBox["     \n          ",
  FontWeight->"Bold"],
 StyleBox["leo.stein@gmail.com",
  FontFamily->"Courier"],
 "\n "
}], "Text",
 FontFamily->"Arial",
 FontWeight->"Plain",ExpressionUUID->"107f5b9f-35b6-4d2f-a8df-84355663aa2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Intro",
 FontSize->
  14]], "SubsectionIcon",ExpressionUUID->"d26d7a03-51b2-4810-966e-\
cd31e0b8b227"],

Cell[TextData[{
 StyleBox["xTerior`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 " ",
 StyleBox["is the",
  FontWeight->"Plain"],
 " ",
 StyleBox["xAct`",
  FontFamily->"Courier",
  FontWeight->"Plain"],
 StyleBox[" package for computations with (tensor valued) differential forms. \
",
  FontWeight->"Plain"]
}], "Text",
 TextJustification->1.,
 FontFamily->"Arial",
 FontWeight->"Plain",ExpressionUUID->"11c7f790-1978-4b08-a8f0-8f667756c791"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Load the package",
 FontSize->
  14]], "SubsectionIcon",ExpressionUUID->"7a00c09e-38cc-453b-ab36-\
21580580c08e"],

Cell[TextData[{
 StyleBox["This loads the package from the default directory, for example \
$Home/.",
  FontWeight->Plain],
 StyleBox["Mathematica",
  FontWeight->Plain,
  FontSlant->"Italic"],
 StyleBox["/Applications/xAct/ for a single-user installation under Linux. ",
  FontWeight->"Plain"]
}], "MathCaption",
 FontFamily->"Arial",
 CellTags->{
  "S5.18.1", "1.3"},ExpressionUUID->"ac8f01ea-6c42-463c-a2c4-f5fdf8d05635"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"d457571c-4f58-4fc8-af3b-421ee96c8f3d"],

Cell[BoxData["86365808"], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"35523ad9-0ac6-43dd-91d8-debae048ef7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["<<xAct`xTerior`", "Input",
 CellTags->"S5.18.1",
 CellLabel->"In[2]:=",ExpressionUUID->"c0260691-bf3c-482f-8f31-77cfc7f1a7de"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"71d6fd1d-3902-4c80-bc49-9092704c0d83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"dc360597-26e1-4cb4-adb9-7c15ccf4dcb2"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"ab432754-0570-4cc9-956c-a5d170fba7b0"],

Cell[BoxData["\<\"Connecting to external linux executable...\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"e3e78ce7-97ac-4622-97e3-9d8e9955cb89"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"0b2c9582-a54e-4b7e-97df-f4fb56f2ab99"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"0738159c-51dd-4b1d-93df-06cc7acc6225"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.1.5", ", ", {2021, 2, 28}],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"cb8910c4-f85a-4b00-9f53-8d5e5b1ff409"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"98bab45b-5c62-4331-8113-a2a4cdbf48db"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"2ffff1d0-e919-4ea5-ad13-1c8dd684065c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.6", ", ", {2021, 2, 28}],
  
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"17198860-7951-4249-a8f7-6a2547bb600e"],

Cell[BoxData["\<\"CopyRight (C) 2005-2021, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"f3c21521-f8f3-4b81-82e4-50827cb4a624"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"388d743c-c3de-438a-b7b2-0a553bf2e7e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTerior`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.9.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2019", ",", "5", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTerior`  version ", "0.9.1", ", ", {2019, 5, 17}],
  Editable->False]], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"f03a74f9-4320-446c-ac77-6e70bf869049"],

Cell[BoxData["\<\"CopyRight (C) 2013, Alfonso Garcia-Parrado Gomez-Lobo and \
Leo C. Stein, under the General Public License.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"6248311d-b2cd-493e-89f2-7e0ae08cf3c9"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"4ad1c1d8-0ff7-4fc2-af1f-7b4bc0e94913"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"37b7e9cf-9da6-4f75-a2f2-2c1711e47f36"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellTags->"S5.18.1",
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"e3889315-d9c6-4cd0-95d5-761195e06510"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Comparing, we see that all packages take about 20 Mb in ",
  FontWeight->Plain],
 StyleBox["Mathematica  10.0:",
  FontSlant->"Italic"]
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"abee6538-12b4-462b-8898-08838c6aee37"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"3fb02e1f-acda-4b45-ba3a-51a0b6bc3f24"],

Cell[BoxData["106782200"], "Output",
 CellLabel->"Out[3]=",ExpressionUUID->"d58309c5-0040-4ba2-99df-1851d73fac01"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Out", "[", "3", "]"}], "-", 
     RowBox[{"Out", "[", "1", "]"}]}], ")"}], "/", 
   RowBox[{"2", "^", "20"}]}], "//", "N"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"3d621923-d481-4f1b-891e-7e6f28dd5522"],

Cell[BoxData["19.47058868408203`"], "Output",
 CellLabel->"Out[4]=",ExpressionUUID->"2f821410-aa82-402d-b098-1ae6ea1d3b77"]
}, Open  ]],

Cell[TextData[{
 "There are several contexts: ",
 StyleBox["xAct`xTerior`, xAct`xCoba`, xAct`xTensor`",
  FontFamily->"Courier"],
 ", ",
 StyleBox["xAct`xPerm`",
  FontFamily->"Courier"],
 " and ",
 StyleBox["xAct`xCore`",
  FontFamily->"Courier"],
 " contain the respective reserved words. ",
 StyleBox["System` ",
  FontFamily->"Courier"],
 "contains ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s reserved words. The current context ",
 StyleBox["Global`",
  FontFamily->"Courier"],
 " will contain your definitions and right now is empty (at least in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with version <10). "
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"ce1177a1-a787-4124-ab80-60aaba5e8e2f"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"b28f5016-511e-4dd6-bfe9-dd0e662496be"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xTerior`\"\>", ",", "\<\"xAct`xCoba`\"\>", 
   ",", "\<\"xAct`ExpressionManipulation`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"DocumentationSearch`\"\>", ",", "\<\"ResourceLocator`\"\>", 
   ",", "\<\"WolframAppCatalog`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[5]=",ExpressionUUID->"3cdb7ccc-dcfd-4fcf-97ab-06ba6eb43bb5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "]"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"6be9b137-fd86-4113-abf2-cec0eddead60"],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellLabel->"Out[6]=",ExpressionUUID->"7827be69-af7c-4fcf-badf-c158f21c5d30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"d93b5137-9f59-4643-8be2-1da7e444c13b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`a\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`a\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{15., {5., 10.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{15., {5., 10.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`a\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> "Global`a", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "Global`a"], False]]], "Output",
 CellLabel->"Out[7]=",ExpressionUUID->"f3f65fe8-2cf6-4803-aefa-844583e69832"]
}, Open  ]],

Cell[TextData[{
 "We turn off info messages issued by ",
 StyleBox["xAct", "DisplayMath"],
 " def and undef commands."
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"9bf65f7b-ca84-4e15-8311-8a2b3380c06e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$UndefInfoQ", "=", "False"}], ";"}]}], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"0d791a09-face-421e-857a-e59c7814b657"]
}, Closed]],

Cell[CellGroupData[{

Cell["1. Example session", \
"SubsectionIcon",ExpressionUUID->"6d29b980-1c57-4390-b96a-b855fcba2ce0"],

Cell[TextData[{
 StyleBox["The user is assumed to be familiar with the standard tools of the \
exterior calculus. The wedge product and the exterior derivative only require \
a differentiable manifold to be defined. Other more advanced tools such as \
the Hodge dual and the co-differential require a pseudo-Riemannian metric on \
the manifold. The exterior covariant derivative is built upon a linear \
connection. In all the cases the required structures must be previously \
defined using commands of the packages automatically loaded when loading ",
  FontWeight->"Plain"],
 StyleBox["xTerior`", "DisplayMath",
  FontWeight->"Plain"],
 StyleBox[". We refer the user to the documentation of each package for a \
description of the commands used in this session. ",
  FontWeight->"Plain"]
}], "Text",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"6751dda7-7cb9-4e4e-8c1e-be0c92fe140c"],

Cell["\<\
We define a differentiable manifold of symbolic dimension dim and introduce \
some differential forms on it.\
\>", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"2069647a-3a53-4d19-ba04-e7ee41ecf4c5"],

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"dim", ",", " ", 
   RowBox[{"PrintAs", "->", "\"\<D\>\""}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"b5ed11dd-dfb6-4e88-87b8-0d9fbff4d1d4"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "dim", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"62669147-3273-4355-a92c-9b17ab93a78b"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"A0", "[", "]"}], ",", "M", ",", "0", ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(A\), \(0\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"d46c7c2d-9eb8-4b1a-83ad-4349b0253b65"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"A1", "[", "]"}], ",", "M", ",", "1", ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(A\), \(1\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"e13f06f5-b6d9-4af9-8900-620e51e2f93a"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"A2", "[", "]"}], ",", "M", ",", "2", ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(A\), \(2\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"962a2a9e-252d-4f05-8cda-23bd83fbe43b"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"A3", "[", "]"}], ",", "M", ",", "3", ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(A\), \(3\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"e82a2311-4928-4067-9a98-85845dec57bf"],

Cell[TextData[{
 "The third argument of the command ",
 StyleBox["DefDiffForm", "DisplayMath"],
 " specifies the degree or grade of the defined differential form. \
Differential forms are multiplied by means of the wedge product which is \
typed in with the key combination Esc ^ Esc. This corresponds to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbol without built-in meaning ",
 StyleBox["Wedge", "DisplayMath"],
 ". ",
 Cell["", "KeyEvent",ExpressionUUID->"ac8b9977-87fb-48f6-a239-ecb1ce8532c2"]
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"2ae9de58-3526-4ed1-b514-5fc5eff09cdb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A1", "[", "]"}], "\[Wedge]", 
  RowBox[{"A2", "[", "]"}]}]], "Input",
 CellLabel->"In[16]:=",ExpressionUUID->"55a70196-f111-46fd-8fc5-fb0fade205a5"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "1"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A1[],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "2"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A2[],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[16]=",ExpressionUUID->"d7df1679-d8cb-4a40-ae90-091fa2423e97"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"5f166b8e-ef66-4ab2-8804-22060d296782"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Wedge", "[", 
    RowBox[{
     RowBox[{"A1", "[", "]"}], ",", 
     RowBox[{"A2", "[", "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellLabel->
  "Out[17]//FullForm=",ExpressionUUID->"25df77fd-38fc-40aa-b24d-1d7425e40771"]\

}, Open  ]],

Cell["\<\
A form of degree zero corresponds to a scalar field and thus the wedge \
product reduces to the standard Times product.\
\>", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"2e1cc545-3801-43db-853b-6ef6d32b8bec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A0", "[", "]"}], "\[Wedge]", 
  RowBox[{"A1", "[", "]"}], "\[Wedge]", 
  RowBox[{"A2", "[", "]"}]}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"7249aa72-6f28-46ff-937f-27b1127a4423"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "0"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A0[],
   Editable->False], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "1"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A1[],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "2"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A2[],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[18]=",ExpressionUUID->"c0a03576-e474-4f38-abcc-624446d3a3cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"b7495ce6-85b2-4bac-8e67-80545fc2a647"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"A0", "[", "]"}], ",", 
     RowBox[{"Wedge", "[", 
      RowBox[{
       RowBox[{"A1", "[", "]"}], ",", 
       RowBox[{"A2", "[", "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellLabel->
  "Out[19]//FullForm=",ExpressionUUID->"377633c5-956f-41cd-be28-3236a1f0cdb6"]\

}, Open  ]],

Cell[TextData[{
 "We can use the command ",
 StyleBox["Deg", "DisplayMath"],
 " to check the degree of any expression containing differential forms. For \
example:"
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"912f533c-4dea-46b2-8854-2c00d2b72c85"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deg", "@", "%"}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"363cf467-e704-4840-803d-a9f88ca76cef"],

Cell[BoxData["3"], "Output",
 CellLabel->
  "Out[20]=",ExpressionUUID->"b4ce1ac1-63f3-42b2-9276-a60c1f6ed237"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deg", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"A2", "[", "]"}], "\[Wedge]", 
     RowBox[{"A3", "[", "]"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"A3", "[", "]"}], "\[Wedge]", 
      RowBox[{"A3", "[", "]"}]}], "+", 
     RowBox[{
      RowBox[{"A2", "[", "]"}], "\[Wedge]", 
      RowBox[{"A2", "[", "]"}], "\[Wedge]", 
      RowBox[{"A2", "[", "]"}]}]}]}], "}"}]}]], "Input",
 CellLabel->"In[21]:=",ExpressionUUID->"cf23188e-bfd3-4d71-b020-c7ef2b86979c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "6"}], "}"}]], "Output",
 CellLabel->
  "Out[21]=",ExpressionUUID->"6b125e22-3f1f-4222-ac12-ad8d63c0c1a5"]
}, Open  ]],

Cell[TextData[{
 "We can add differential forms of different degrees but ",
 StyleBox["Deg", "DisplayMath"],
 " throws an error when acting on these kind of expressions."
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"d2ad41cc-0aa8-4b7c-8794-5c628fddf51b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A2", "[", "]"}], "\[Wedge]", 
   RowBox[{"A3", "[", "]"}]}], "+", 
  RowBox[{
   RowBox[{"A3", "[", "]"}], "\[Wedge]", 
   RowBox[{"A3", "[", "]"}]}], "+", 
  RowBox[{
   RowBox[{"A2", "[", "]"}], "\[Wedge]", 
   RowBox[{"A2", "[", "]"}], "\[Wedge]", 
   RowBox[{"A2", "[", "]"}]}]}]], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"1005d318-cb07-45c8-be43-a6d29337cb67"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "2"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A2[],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "3"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A3[],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "3"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A3[],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "3"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A3[],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "2"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A2[],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "2"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A2[],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "2"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A2[],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[22]=",ExpressionUUID->"3ac421c4-2f5a-480d-b812-77616f988fbe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deg", "@", "%"}]], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"c0dfb6ed-3684-487c-a076-65a797e960a6"],

Cell[BoxData[
 TemplateBox[{
  "Validate", "inhom", 
   "\"Found inhomogeneous \
\\!\\(\\*RowBox[{\\\"\\\\\\\"grades\\\\\\\"\\\"}]\\): \\!\\(\\*RowBox[{\\\"\\\
\\\\\"{5, 6}\\\\\\\"\\\"}]\\).\"", 2, 23, 1, 19264546493731647491, "Local", 
   "xAct`xTensor`Validate"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[23]:=",ExpressionUUID->"c5689078-f185-46b9-bcce-55c9b275ed3e"],

Cell[BoxData[
 TemplateBox[{
  "Throw", "nocatch", 
   "\"Uncaught \\!\\(\\*RowBox[{\\\"Throw\\\", \\\"[\\\", \\\"Null\\\", \\\"]\
\\\"}]\\) returned to top level.\"", 2, 23, 2, 19264546493731647491, "Local"},
  
  "MessageTemplate"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[23]:=",ExpressionUUID->"eb514e10-4e7b-4f8c-bcf4-52b280d95630"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Throw", "[", "Null", "]"}], "]"}]], "Output",
 CellLabel->
  "Out[23]=",ExpressionUUID->"e76e66fc-0a1d-4fd5-954c-575663646143"]
}, Open  ]],

Cell["\<\
The canonicalizer is prepared to work with expressions involving the wedge \
product. For example:\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"f936eea1-f3da-4592-b8da-86d5b13aa623"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A1", "[", "]"}], "\[Wedge]", 
   RowBox[{"A2", "[", "]"}]}], "+", 
  RowBox[{
   RowBox[{"A2", "[", "]"}], "\[Wedge]", 
   RowBox[{"A1", "[", "]"}]}]}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"656d8731-2542-4dc8-bf7d-93fe6a9c06e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "1"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A1[],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "2"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A2[],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "2"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A2[],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "1"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A1[],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[24]=",ExpressionUUID->"12ec4298-123c-4834-bd7f-5a0cc5de213e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"5ad1356b-8b66-45b6-b6a3-813ec9e553d6"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "1"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A1[],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "2"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A2[],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[25]=",ExpressionUUID->"1ef9750a-f731-4747-828d-f1a9654ee59a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A1", "[", "]"}], "\[Wedge]", 
   RowBox[{"A1", "[", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"1131ae75-b173-4e53-9864-745364569d07"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[26]=",ExpressionUUID->"171c24e5-77fb-4c63-95a0-87a4c5c016c6"]
}, Open  ]],

Cell["Other cases. Note the automatic sorting of factors.", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"1622d686-3275-43a8-ae46-955c784eff6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A1", "[", "]"}], "\[Wedge]", 
   RowBox[{"A2", "[", "]"}], "\[Wedge]", 
   RowBox[{"A1", "[", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"688ecfe1-9be6-47a1-a0fc-966a9588c196"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[27]=",ExpressionUUID->"c84178d6-2666-448c-af3e-fea376005968"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A2", "[", "]"}], "\[Wedge]", 
   RowBox[{"A1", "[", "]"}], "\[Wedge]", 
   RowBox[{"A2", "[", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"ef3240b1-be4c-460d-85b4-15b7024e3b54"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "1"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A1[],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "2"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A2[],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "2"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A2[],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[28]=",ExpressionUUID->"9c8a6e80-c956-49d2-8877-54320f8f78fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A3", "[", "]"}], "\[Wedge]", 
   RowBox[{"A2", "[", "]"}], "\[Wedge]", 
   RowBox[{"A1", "[", "]"}], "\[Wedge]", 
   RowBox[{"A2", "[", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"62640830-aae3-4fb1-a9fb-602b52ddfed7"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SuperscriptBox["A", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`A1[],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      SuperscriptBox["A", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`A2[],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      SuperscriptBox["A", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`A2[],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      SuperscriptBox["A", "3"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`A3[],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[29]=",ExpressionUUID->"2dbb81b4-3a08-4992-bb07-f3b073b5ea54"]
}, Open  ]],

Cell[TextData[{
 "One can also define ",
 StyleBox["\[OpenCurlyDoubleQuote]tensor valued forms\[CloseCurlyDoubleQuote]",
  FontSlant->"Italic"],
 " with arbitrary symmetries."
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"577e547c-b4a9-4457-92a7-517d2421b448"],

Cell[BoxData[{
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"\[Omega]1", "[", "a", "]"}], ",", "M", ",", "1", ",", 
   RowBox[{
   "PrintAs", "->", 
    "\"\<\!\(\*SuperscriptBox[\(\[InvisiblePrefixScriptBase]\), \(1\)]\)\
\[Omega]\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"\[Omega]2", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "M", ",", "2", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{
   "PrintAs", "->", 
    "\"\<\!\(\*SuperscriptBox[\"\[InvisiblePrefixScriptBase]\", \
StyleBox[\"2\",FontSize->8]]\)\[Omega]\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"\[Omega]3", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "M", ",", "3", ",", 
   RowBox[{
   "PrintAs", "->", 
    "\"\<\!\(\*SuperscriptBox[\"\[InvisiblePrefixScriptBase]\", \
StyleBox[\"3\",FontSize->8]]\)\[Omega]\>\""}]}], "]"}]}], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"cd8212dd-c00e-4639-8ee6-a6e5e31da0f3"],

Cell["\<\
Now we can canonicalize expressions involving tensor valued forms.\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"f75eadda-662c-4644-9c0a-c00bbae7823c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Omega]1", "[", "b", "]"}], "\[Wedge]", 
   RowBox[{"\[Omega]1", "[", "a", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[33]:=",ExpressionUUID->"6209a9d0-102d-406c-960c-cb8c0221542d"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]1[$CellContext`a],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]1[$CellContext`b],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[33]=",ExpressionUUID->"5dfb4f99-20b6-4c99-b6b3-3cb4298f73da"]
}, Open  ]],

Cell["\<\
The priority is to sort the forms (with less symmetric tensors first), not \
the indices :\
\>", "MathCaption",ExpressionUUID->"fe4c4ac3-f8b7-43d9-90c1-6cf901103fd5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Omega]3", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[Wedge]", 
   RowBox[{"\[Omega]2", "[", 
    RowBox[{"c", ",", "d"}], "]"}], "\[Wedge]", 
   RowBox[{"\[Omega]1", "[", "e", "]"}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"2466121f-25ad-40cf-814d-120a2a9135ad"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"e"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]1[$CellContext`e],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", 
           StyleBox["3",
            FontSize->8]], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"a", "b"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]3[$CellContext`a, $CellContext`b],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", 
           StyleBox["2",
            FontSize->8]], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"c", "d"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]2[$CellContext`c, $CellContext`d],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[34]=",ExpressionUUID->"3c9e36ed-343c-4d4f-be76-68ec5f16226b"]
}, Open  ]],

Cell[TextData[{
 "The exterior derivative of a differential form is represented by ",
 StyleBox["Diff", "DisplayMath"],
 StyleBox[". ", "Text"],
 StyleBox["The", "Text",
  FontWeight->"Plain"],
 " exterior derivative is a graded derivation and hence all the corresponding \
properties are implemented. Examples of simple computations."
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"d7d6f888-b54b-4e48-bea2-0d767ece0c25"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "[", 
  RowBox[{
   RowBox[{"A0", "[", "]"}], " ", 
   RowBox[{"\[Omega]1", "[", "a", "]"}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"3d1ac034-82d9-4c2d-914d-dbe9ce7ca40e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "0"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A0[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A0[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`A0[], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[35]=",ExpressionUUID->"2018e7b7-9dd4-4b86-b608-ff3381ca72e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "[", 
  RowBox[{
   RowBox[{"\[Omega]1", "[", "a", "]"}], "\[Wedge]", 
   RowBox[{"\[Omega]2", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"69646a65-af91-485d-924c-419149a7d31e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["2",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"b", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["2",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b", "c"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]2[$CellContext`b, $CellContext`c], xAct`xTensor`PD],
    
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[36]=",ExpressionUUID->"8a8a8a26-4248-40d0-bbd0-5ca1ca5714d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "[", 
  RowBox[{
   RowBox[{"\[Omega]1", "[", "b", "]"}], "\[Wedge]", 
   RowBox[{"\[Omega]1", "[", "a", "]"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",ExpressionUUID->"7c75e366-7032-4a21-8e55-d2e99490a2f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[37]=",ExpressionUUID->"edc1746c-5c87-45f8-ac91-d5a90cc98499"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[38]:=",ExpressionUUID->"ff41a79a-dd9b-4aa4-9f5c-9b440a808c9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`b], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[38]=",ExpressionUUID->"0f9c610d-764b-458c-a1e0-7752ee11f960"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "[", "%", "]"}]], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"a4674fdb-769f-48fa-8e0c-ac3f442c4006"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`b], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[39]=",ExpressionUUID->"5cb87d0c-d813-4a13-bac6-183549011473"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"15d077c6-53ba-44a5-8401-0b3e50b053e5"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[40]=",ExpressionUUID->"290cbb7b-5bb4-4991-90a2-551521863ffe"]
}, Open  ]],

Cell["Something more involved.", \
"MathCaption",ExpressionUUID->"1b31041f-358a-466b-95dc-e22f04decd95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "[", 
  RowBox[{
   RowBox[{"A0", "[", "]"}], " ", 
   RowBox[{
    RowBox[{"\[Omega]1", "[", "a", "]"}], "\[Wedge]", 
    RowBox[{"\[Omega]2", "[", 
     RowBox[{"b", ",", "c"}], "]"}], "\[Wedge]", 
    RowBox[{"\[Omega]3", "[", 
     RowBox[{"d", ",", "e"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"892dce83-18d6-40bd-9b03-b188e23f476f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "0"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A0[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
               "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]1[$CellContext`a],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["2",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b", "c"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["3",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"d", "e"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["2",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"b", "c"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]2[$CellContext`b, $CellContext`c], 
        xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["3",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"d", "e"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["2",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b", "c"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["3",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"d", "e"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]3[$CellContext`d, $CellContext`e], 
        xAct`xTensor`PD],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A0[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`A0[], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["2",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"b", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["3",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"d", "e"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[41]=",ExpressionUUID->"f2b983ee-3c87-4b11-8b2e-03197385d749"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"f3d6599f-f4b5-493f-836e-f0ee5856f0a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      SuperscriptBox["A", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`A0[],
     Editable->False]}], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]1[$CellContext`a],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{
             SuperscriptBox["\[InvisiblePrefixScriptBase]", 
              StyleBox["3",
               FontSize->8]], "\[Omega]"}], 
            StyleBox[GridBox[{
               {"d", "e"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Omega]3[$CellContext`d, $CellContext`e], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", 
           StyleBox["2",
            FontSize->8]], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"b", "c"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
     Editable->False]}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "0"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A0[],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]1[$CellContext`a],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", 
           StyleBox["3",
            FontSize->8]], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"d", "e"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{
             SuperscriptBox["\[InvisiblePrefixScriptBase]", 
              StyleBox["2",
               FontSize->8]], "\[Omega]"}], 
            StyleBox[GridBox[{
               {"b", "c"},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Omega]2[$CellContext`b, $CellContext`c], xAct`xTensor`PD],
     Editable->False]}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "0"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A0[],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", 
           StyleBox["3",
            FontSize->8]], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"d", "e"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{
             SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
             "\[Omega]"}], 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Omega]1[$CellContext`a],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", 
           StyleBox["2",
            FontSize->8]], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"b", "c"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
     Editable->False]}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["3",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"d", "e"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A0[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`A0[], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["2",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"b", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[42]=",ExpressionUUID->"7b199cd7-bc99-4301-a846-207d6e756e18"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "[", "%", "]"}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"e23ecaf4-ef89-4b30-acad-32917504c692"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      SuperscriptBox["A", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`A0[],
     Editable->False]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
               "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]1[$CellContext`a],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["3",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"d", "e"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]3[$CellContext`d, $CellContext`e], 
        xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["2",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b", "c"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["3",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"d", "e"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]3[$CellContext`d, $CellContext`e], 
        xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["2",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"b", "c"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]2[$CellContext`b, $CellContext`c], 
        xAct`xTensor`PD],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "0"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A0[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
               "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]1[$CellContext`a],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["3",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"d", "e"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["2",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"b", "c"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]2[$CellContext`b, $CellContext`c], 
        xAct`xTensor`PD],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["3",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"d", "e"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]3[$CellContext`d, $CellContext`e], 
        xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["2",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"b", "c"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]2[$CellContext`b, $CellContext`c], 
        xAct`xTensor`PD],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "0"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A0[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["3",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"d", "e"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]3[$CellContext`d, $CellContext`e], 
        xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
               "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]1[$CellContext`a],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["2",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b", "c"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["3",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"d", "e"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
               "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]1[$CellContext`a],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{
               SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                StyleBox["2",
                 FontSize->8]], "\[Omega]"}], 
              StyleBox[GridBox[{
                 {"b", "c"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Omega]2[$CellContext`b, $CellContext`c], 
        xAct`xTensor`PD],
       Editable->False]}]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A0[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`A0[], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["3",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"d", "e"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]3[$CellContext`d, $CellContext`e], xAct`xTensor`PD],
    
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["2",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"b", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A0[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`A0[], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["3",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"d", "e"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["2",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b", "c"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]2[$CellContext`b, $CellContext`c], xAct`xTensor`PD],
    
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A0[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`A0[], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["3",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"d", "e"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["2",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"b", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]1[$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]1[$CellContext`a], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["3",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"d", "e"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A0[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`A0[], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["2",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"b", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["3",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"d", "e"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]3[$CellContext`d, $CellContext`e], xAct`xTensor`PD],
    
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A0[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`A0[], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["2",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"b", "c"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]1[$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[InvisiblePrefixScriptBase]", 
          StyleBox["3",
           FontSize->8]], "\[Omega]"}], 
        StyleBox[GridBox[{
           {"d", "e"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Omega]3[$CellContext`d, $CellContext`e],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A0[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`A0[], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{
            SuperscriptBox["\[InvisiblePrefixScriptBase]", 
             StyleBox["2",
              FontSize->8]], "\[Omega]"}], 
           StyleBox[GridBox[{
              {"b", "c"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Omega]2[$CellContext`b, $CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Omega]2[$CellContext`b, $CellContext`c], xAct`xTensor`PD],
    
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[43]=",ExpressionUUID->"f16f6d79-94e2-4664-b9a9-2eaec68cb39b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"3158486f-7e25-4b54-9cc0-c4035e2eb882"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[44]=",ExpressionUUID->"809411d3-0531-4eae-89ac-462ca334ef8c"]
}, Open  ]],

Cell[TextData[{
 StyleBox["xTerior", "DisplayMath"],
 " can handle automatically the fundamental (also called canonical) 1-form of \
the frame bundle of the manifold (see e.g. M. Spivak ",
 StyleBox["\[OpenCurlyDoubleQuote]A Comprehensive Introduction to \
Differential Geometry\[CloseCurlyDoubleQuote]",
  FontSlant->"Italic"],
 ", Vol. 2 p. 324 ) and its holonomic restriction. They are represented as \
follows: "
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"34f16f5a-24ee-4894-852e-ff477df931c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "a", "]"}], ",", 
   RowBox[{
    RowBox[{"dx", "[", "M", "]"}], "[", "a", "]"}]}], "}"}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"63a80bb0-8fb0-4e74-808b-3b2f087a8a03"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"dx", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`dx[$CellContext`M][$CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellLabel->
  "Out[45]=",ExpressionUUID->"653df523-e6d2-4010-b368-bfd2c43f82fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"9e170f98-36fe-4aec-85a3-3bd1556bb121"],

Cell["{Coframe[M][a], dx[M][a]}", "Output",
 CellLabel->
  "Out[46]//InputForm=",ExpressionUUID->"a271d95d-ef9e-4cae-9b01-762e781d5c96"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deg", "/@", "%%"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"e2d7b5f2-a216-4d7d-be9e-771d5a40f2cb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellLabel->
  "Out[47]=",ExpressionUUID->"8fa2d402-2743-46ac-9822-8788f2b3c623"]
}, Open  ]],

Cell[TextData[{
 "The first element of the list is the generic canonical 1-form and the \
second element of the list is the ",
 StyleBox["holonomic",
  FontSlant->"Italic"],
 " canonical 1-form. One can operate with the canonical 1-form in the same \
way as with any other tensor valued differential form:"
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"531a7f87-2f0b-4f55-9f2d-3732a611f0ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "b", "]"}], "\[Wedge]", 
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "a", "]"}]}], "//", 
  "ToCanonical"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"ebcec309-0a08-4568-9e82-0f14c00f42f4"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Theta]", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Theta]", 
         StyleBox[GridBox[{
            {"b"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->
  "Out[48]=",ExpressionUUID->"3c858a99-81c1-4640-b6fd-d539981824fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"19754e62-8061-44a6-a61d-dbf84929c02b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Theta]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], xAct`xTensor`PD],
      
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[49]=",ExpressionUUID->"d96299d5-b341-40fc-a221-f92d146d42e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"c24ce0fc-9049-474a-83c0-d51584ba735a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Theta]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], xAct`xTensor`PD],
      
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[50]=",ExpressionUUID->"92dc7130-3ef9-438c-9c51-378c97351e78"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"37c216d4-8f72-4f68-8b9d-804049034fc3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Theta]", 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], xAct`xTensor`PD],
      
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Theta]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], xAct`xTensor`PD],
      
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[51]=",ExpressionUUID->"aa05bf8a-7713-4329-9d4a-7a926a2304bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[52]:=",ExpressionUUID->"6ec1b0c6-801c-4744-9a57-a3910f8ec88b"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[52]=",ExpressionUUID->"4971328a-ab70-4edb-b3cd-7471c73638e3"]
}, Open  ]],

Cell["\<\
Tensor valued forms and plain tensors can be mixed in the same expression and \
the symmetries of the complete expression are computed with no extra effort \
on the user side.\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"19edb5c8-e169-4f48-9c2e-b856df6ba4dd"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"407eb552-9510-4f59-be85-14ee4e02628f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "a", "]"}], "\[Wedge]", 
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "b", "]"}]}]}]], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"f6caba46-2843-41e5-bb5b-59f876184306"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"S", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[-$CellContext`a, -$CellContext`b],
   Editable->False], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[54]=",ExpressionUUID->"9ef0211e-a317-45f7-886f-776cd58ef1da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"141dd7d8-7d30-4e83-8825-3c6ffbf95cc7"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[55]=",ExpressionUUID->"fdaa85df-2252-4fe8-8d35-d55bba634a9b"]
}, Open  ]],

Cell["\<\
Let us introduce now a covariant derivative in the manifold M. \
\>", "MathCaption",ExpressionUUID->"9b129220-fff3-41b1-814f-a3f3ebdde332"],

Cell[BoxData[
 RowBox[{"DefCovD", "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<D\>\""}], "}"}], ",", 
   RowBox[{"Torsion", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[56]:=",ExpressionUUID->"6f9a480b-c435-48f3-aac5-be1964d49080"],

Cell[TextData[{
 "When we define a covariant derivative and ",
 StyleBox["xTerior", "DisplayMath"],
 " is loaded, a number of objects are automatically introduced in the \
session. These are the connection 1-form, the curvature 2-form and, if \
non-zero, the torsion 2-form:"
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"a676f554-10c2-4f5e-85e9-37947e0fa1eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"ConnectionForm", "[", 
     RowBox[{"CD", ",", "TangentM"}], "]"}], "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"CurvatureForm", "[", 
     RowBox[{"CD", ",", "TangentM"}], "]"}], "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"TorsionForm", "[", "CD", "]"}], "[", "a", "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"0d5b116a-7c78-410d-a9a7-52d130b33e40"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, -$CellContext`b],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a],
    Editable->False]}], "}"}]], "Output",
 CellLabel->
  "Out[57]=",ExpressionUUID->"79d1d76a-c939-4825-821e-448cc2de7bed"]
}, Open  ]],

Cell["\<\
Given that we are working with a covariant derivative on the tangent bundle \
of a differentiable manifold, one has an equivalent representation for the \
connection and curvature forms, which is found next:\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"ef78c5d6-c00a-4c60-badb-fcc07809c3c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"abaf9ab0-a238-44b3-9b78-d89daba92566"],

Cell["\<\
{ChristoffelForm[CD][a, -b], RiemannForm[CD][a, -b], 
 TorsionForm[CD][a]}\
\>", "Output",
 CellLabel->
  "Out[58]//InputForm=",ExpressionUUID->"726718f2-67fa-4394-87b8-4211ebbecaa9"]
}, Open  ]],

Cell[TextData[{
 "Therefore, in this particular case, it is possible to use the Heads ",
 StyleBox["ConnectionForm", "DisplayMath"],
 ", ",
 StyleBox["CurvatureForm", "DisplayMath"],
 " or ",
 StyleBox["ChristoffelForm", "DisplayMath"],
 ", ",
 StyleBox["RiemannForm", "DisplayMath"],
 ". In fact we can modify the default output representation of these objects \
as follows:"
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"fe5a5f5b-876d-4ec0-891a-98bac5a2b558"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "@", 
    RowBox[{"ChristoffelForm", "[", "CD", "]"}]}], "^=", "\"\<\[Gamma]\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "@", 
    RowBox[{"RiemannForm", "[", "CD", "]"}]}], "^=", 
   "\"\<\[ScriptCapitalR]\>\""}], ";"}]}], "Input",
 CellLabel->"In[59]:=",ExpressionUUID->"45bf249b-8c80-4ee8-8213-16c107fc28a7"],

Cell[TextData[{
 "Once a covariant derivative has been introduced, one can use the Cartan \
structure equations in the manipulations. This is achieved with the command \
",
 StyleBox["UseCartan", "DisplayMath"],
 ". For example :"
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"619965d0-2154-4fde-94d4-29d651a617ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "b", "]"}], "\[Wedge]", 
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "a", "]"}]}], "//", 
  "Diff"}]], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"ebeb916a-44fb-4930-9450-10fc5a051a2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[61]=",ExpressionUUID->"4899ebdd-4dd2-4322-98fd-0434e06c70ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UseCartan", "[", 
  RowBox[{"%", ",", "CD"}], "]"}]], "Input",
 CellLabel->"In[62]:=",ExpressionUUID->"dcc99a29-8765-46f3-bdac-38b0fae39519"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[62]=",ExpressionUUID->"9e3e6b13-808e-4608-a684-5635640729ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "[", "%", "]"}]], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"8c982511-e9bc-420a-9236-6481ea3eba17"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Theta]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], xAct`xTensor`PD],
      
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a],
      Editable->False]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b], 
     xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a], 
     xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Gamma]", 
           StyleBox[GridBox[{
              {"b", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`c], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Gamma]", 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`Coframe[$CellContext`M][$CellContext`c], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[63]=",ExpressionUUID->"ffe77113-bd73-46c7-9cc0-8830dc6ba3f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UseCartan", "[", 
  RowBox[{"%", ",", "CD"}], "]"}]], "Input",
 CellLabel->"In[64]:=",ExpressionUUID->"eb6dc756-03c5-499d-9f66-9874c8699ca8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalR]", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, -$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalR]", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, -$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalR]", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`b, -$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[ScriptCapitalR]", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`b, -$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"c", " "},
           {" ", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`d],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"d"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`d],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`d],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"d"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`d],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"d", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`d, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`d],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"d"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`d],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"c", " "},
           {" ", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`d],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"d"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`d],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Gamma]", 
        StyleBox[GridBox[{
           {"d", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`d, \
-$CellContext`c],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
    Editable->False]}]}]], "Output",
 CellLabel->
  "Out[64]=",ExpressionUUID->"5de9f4c2-d974-42e8-b19b-b8762852f786"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"bc0a46ed-b4b1-46c4-9bf5-c5cb74b78af2"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[65]=",ExpressionUUID->"a6673612-fe58-4d3a-a2ac-a74f70fb3046"]
}, Open  ]],

Cell["\<\
We introduce a metric with full information about its signature. Its \
associated covariant derivative is automatically defined (note that we impose \
that the torsion of the Levi-Civita covariant derivative be non-zero). The \
information about the signature requires that we set a value for the \
dimension. \
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"1ba8542e-773e-469a-a060-5fdb0c51d346"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dim", "=", "4"}], ";"}]], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"cf907487-c773-43d1-be79-d9d88d6b3e0f"],

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"metricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CV", ",", 
   RowBox[{"Torsion", "\[Rule]", "True"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}]], "Input",
 CellLabel->"In[67]:=",ExpressionUUID->"a609be11-f545-4b66-97fc-3fdce0cee27e"],

Cell[TextData[{
 "We change the options of ",
 StyleBox["ToCanonical", "DisplayMath"],
 " to prevent indices inside the derivations from moving up and down."
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"d8b6272f-eb77-4bec-b07c-8469e617fbe1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ToCanonical", ",", 
    RowBox[{"UseMetricOnVBundle", "\[Rule]", "None"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[68]:=",ExpressionUUID->"5647a846-984e-47f3-8e46-548c2358a54f"],

Cell["\<\
Once we have a metric we have additional structures such as the Hodge dual \
and the co-differential. We illustrate both of them next:\
\>", "MathCaption",ExpressionUUID->"74a47d12-989e-440a-ba42-01f32600878c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "[", 
  RowBox[{"\[Omega]1", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[69]:=",ExpressionUUID->"20843e70-2040-4c97-bb3f-95309fe04060"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["*", "g"], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]1[$CellContext`a],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Hodge[$CellContext`metricg][
   $CellContext`\[Omega]1[$CellContext`a]],
  Editable->False]], "Output",
 CellLabel->
  "Out[69]=",ExpressionUUID->"3c4f73d2-d327-421d-aeff-41d99f2d2e75"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Deg"}]], "Input",
 CellLabel->"In[70]:=",ExpressionUUID->"9dc5a0d4-04af-4200-a3df-0eb9205898dd"],

Cell[BoxData["3"], "Output",
 CellLabel->
  "Out[70]=",ExpressionUUID->"54cb9bc7-fcda-42b8-a2e2-41d7a18b1be4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "[", "%%", "]"}]], "Input",
 CellLabel->"In[71]:=",ExpressionUUID->"d0660e42-68c1-4a32-a7a5-8fb0982ca310"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       SuperscriptBox["\[InvisiblePrefixScriptBase]", "1"], "\[Omega]"}], 
      StyleBox[GridBox[{
         {"a"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`\[Omega]1[$CellContext`a],
  Editable->False]], "Output",
 CellLabel->
  "Out[71]=",ExpressionUUID->"9179857e-e7bf-4f37-8eb6-fc4c4dc2646b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Codiff", "[", "metricg", "]"}], "[", 
  RowBox[{"\[Omega]2", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[72]:=",ExpressionUUID->"c6a55c1f-e973-493f-bdaa-61ea38e670b0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[Delta]", "g"], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{
          SuperscriptBox["\[InvisiblePrefixScriptBase]", 
           StyleBox["2",
            FontSize->8]], "\[Omega]"}], 
         StyleBox[GridBox[{
            {"a", "b"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Omega]2[$CellContext`a, $CellContext`b],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Codiff[$CellContext`metricg][
   $CellContext`\[Omega]2[$CellContext`a, $CellContext`b], xAct`xTensor`PD],
  Editable->False]], "Output",
 CellLabel->
  "Out[72]=",ExpressionUUID->"f391f256-3892-4f2c-aaca-25b66ef8a67d"]
}, Open  ]],

Cell[TextData[{
 "The co-differential can be transformed into its definition in terms of the \
exterior derivative by means of ",
 StyleBox["CodiffToDiff", "DisplayMath"],
 "."
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"7d02989d-e74e-452a-b93f-3be058817b5e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "CodiffToDiff"}]], "Input",
 CellLabel->"In[73]:=",ExpressionUUID->"417cd02a-6164-4713-a91b-a5bdc1baf0e0"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["*", "g"], "[", 
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["*", "g"], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {
                RowBox[{
                 SuperscriptBox["\[InvisiblePrefixScriptBase]", 
                  StyleBox["2",
                   FontSize->8]], "\[Omega]"}], 
                StyleBox[GridBox[{
                   {"a", "b"},
                   {" ", " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`\[Omega]2[$CellContext`a, $CellContext`b],
            Editable->False], "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Hodge[$CellContext`metricg][
          $CellContext`\[Omega]2[$CellContext`a, $CellContext`b]],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`Hodge[$CellContext`metricg][
        $CellContext`\[Omega]2[$CellContext`a, $CellContext`b]], 
       xAct`xTensor`PD],
      Editable->False], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Hodge[$CellContext`metricg][
    xAct`xTerior`Diff[
     xAct`xTerior`Hodge[$CellContext`metricg][
      $CellContext`\[Omega]2[$CellContext`a, $CellContext`b]], 
     xAct`xTensor`PD]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[73]=",ExpressionUUID->"b77cb927-072a-492a-a8f3-a30d3b94cc4b"]
}, Open  ]],

Cell[TextData[{
 "Hodge duals of exterior powers of the fundamental 1-form can be worked out \
with ",
 StyleBox["ExpandHodgeDual", "DisplayMath"],
 "."
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"e60e1445-5a52-4f99-a8c5-c0fbd06a384c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "a", "]"}], "\[Wedge]", 
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "b", "]"}], "\[Wedge]", 
   RowBox[{
    RowBox[{"Coframe", "[", "M", "]"}], "[", "c", "]"}]}], "]"}]], "Input",
 CellLabel->"In[74]:=",ExpressionUUID->"1a8225ca-5d8d-43a2-af07-93c4eecce83f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["*", "g"], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"c"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
      Editable->False]}], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Hodge[$CellContext`metricg][
   Wedge[
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], 
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], 
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[74]=",ExpressionUUID->"cc7d2709-90f7-4d7b-b3c0-727c343c352c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandHodgeDual", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Coframe", "[", "M", "]"}], ",", "metricg"}], "]"}]], "Input",
 CellLabel->"In[75]:=",ExpressionUUID->"bf4b6e90-54f7-46b3-800b-b53d56b43309"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]g", 
       StyleBox[GridBox[{
          {"a", "b", "c", " "},
          {" ", " ", " ", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`epsilonmetricg[$CellContext`a, $CellContext`b, \
$CellContext`c, -$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Theta]", 
       StyleBox[GridBox[{
          {"d"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Coframe[$CellContext`M][$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[75]=",ExpressionUUID->"86ef0340-e809-4b02-b3a4-a8cfeac325ec"]
}, Open  ]],

Cell[TextData[{
 "When we work with an explicit dimension then any expression whose degree is \
greater than the dimension vanishes. ",
 StyleBox["xTerior", "DisplayMath"],
 " does not take this into account by default but we can change this by \
issuing the instruction ",
 StyleBox["UseDimensionStart", "DisplayMath"],
 ". By doing this any expression whose degree is higher than the dimension \
will get replaced by zero."
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"f7c1e74a-8b36-4d5f-81ba-23f67d01ac6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A2", "[", "]"}], "\[Wedge]", 
   RowBox[{"A2", "[", "]"}], "\[Wedge]", 
   RowBox[{"A2", "[", "]"}]}], "//", "Deg"}]], "Input",
 CellLabel->"In[76]:=",ExpressionUUID->"d1b599cd-eb60-4a2c-b64f-548956019f97"],

Cell[BoxData["6"], "Output",
 CellLabel->
  "Out[76]=",ExpressionUUID->"d6e87d2c-26b4-4509-982f-93afb6f3921e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"UseDimensionStart", "[", "]"}]], "Input",
 CellLabel->"In[77]:=",ExpressionUUID->"f645499f-e556-4d35-a19f-09c2faab4685"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A2", "[", "]"}], "\[Wedge]", 
  RowBox[{"A2", "[", "]"}], "\[Wedge]", 
  RowBox[{"A2", "[", "]"}]}]], "Input",
 CellLabel->"In[78]:=",ExpressionUUID->"5f092480-0fc0-4aa6-aec5-c7f3f59f2c17"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[78]=",ExpressionUUID->"0b04c74b-e708-42bc-ac72-c3a4853b74bb"]
}, Open  ]],

Cell["\<\
The exterior differential of a 4-form is identically zero in four dimensions.\
\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"226ea9ba-ecc7-41c6-b930-c5c7f8f9b746"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A2", "[", "]"}], "\[Wedge]", 
  RowBox[{"A2", "[", "]"}]}]], "Input",
 CellLabel->"In[79]:=",ExpressionUUID->"bdb4ee39-9912-4e03-b4e3-2ddfb53c169d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "2"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A2[],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "2"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A2[],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[79]=",ExpressionUUID->"2ba8aa05-fc94-441d-b444-a499f149b87f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->"In[80]:=",ExpressionUUID->"5b528062-3b71-4f03-994f-ecc521acf26b"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[80]=",ExpressionUUID->"cb8c2f00-efb1-4ac9-a377-4bd7289772b2"]
}, Open  ]],

Cell["\<\
We can define forms whose degree is higher than the dimension but they will \
automatically vanish. \
\>", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"929c4315-fc33-4d6f-8fb0-28a08bc743cd"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"A6", "[", "]"}], ",", "M", ",", "6", ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(A\), \(6\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[81]:=",ExpressionUUID->"fb397b11-d609-42e0-a195-ba334a3edbff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A6", "[", "]"}]], "Input",
 CellLabel->"In[82]:=",ExpressionUUID->"966aea54-ff71-41ea-9d51-c6a5db23fdd4"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[82]=",ExpressionUUID->"2a74ee93-761d-425a-a81f-2d49f2393d4e"]
}, Open  ]],

Cell[TextData[{
 "Forms with degree greater than the dimension can be restored by issuing ",
 StyleBox["UseDimensionStop", "DisplayMath"]
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"5425b973-49a4-45a0-9d21-13380e060d65"],

Cell[BoxData[
 RowBox[{"UseDimensionStop", "[", "]"}]], "Input",
 CellLabel->"In[83]:=",ExpressionUUID->"f505a22f-c771-421b-be92-d3adacf7e262"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A6", "[", "]"}]], "Input",
 CellLabel->"In[84]:=",ExpressionUUID->"035c28e2-c0aa-460d-bd87-9333da6847b4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SuperscriptBox["A", "6"],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`A6[],
  Editable->False]], "Output",
 CellLabel->
  "Out[84]=",ExpressionUUID->"1dd5adca-9233-4fa2-8906-5cd12a5d4a81"]
}, Open  ]],

Cell[TextData[{
 "We introduce now a coordinate chart in the manifold ",
 StyleBox["M", "DisplayMath"],
 "."
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"ee4a1e97-88a9-4a2b-bbb7-c6fa666f17e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"Sph", ",", "M", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "[", "]"}], ",", 
     RowBox[{"r", "[", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[CurlyPhi]", "[", "]"}]}], "}"}], ",", 
   RowBox[{"FormatBasis", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Partials\>\"", ",", "\"\<Differentials\>\""}], "}"}]}], ",", 
   RowBox[{"ChartColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[85]:=",ExpressionUUID->"7f49ae87-36c3-479b-8d5a-03868eec38a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"dx", 
         StyleBox[GridBox[{
            {
             StyleBox["0",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`dx[$CellContext`M][{0, $CellContext`Sph}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"dx", "[", "M", "]"}]}],
  SequenceForm[
  "Added independent rule ", 
   xAct`xTerior`dx[$CellContext`M][{0, $CellContext`Sph}] -> xAct`xTerior`Diff[
     $CellContext`t[], xAct`xTensor`PD], " for tensor ", 
   xAct`xTerior`dx[$CellContext`M]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[85]:=",ExpressionUUID->"fb916ed8-eca5-4f64-9597-743f75b4c887"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"dx", 
         StyleBox[GridBox[{
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`dx[$CellContext`M][{1, $CellContext`Sph}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"dx", "[", "M", "]"}]}],
  SequenceForm[
  "Added independent rule ", 
   xAct`xTerior`dx[$CellContext`M][{1, $CellContext`Sph}] -> xAct`xTerior`Diff[
     $CellContext`r[], xAct`xTensor`PD], " for tensor ", 
   xAct`xTerior`dx[$CellContext`M]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[85]:=",ExpressionUUID->"2d1e9bf6-f329-4994-9618-6aefdd32b4a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"dx", 
         StyleBox[GridBox[{
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`dx[$CellContext`M][{2, $CellContext`Sph}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"dx", "[", "M", "]"}]}],
  SequenceForm[
  "Added independent rule ", 
   xAct`xTerior`dx[$CellContext`M][{2, $CellContext`Sph}] -> xAct`xTerior`Diff[
     $CellContext`\[Theta][], xAct`xTensor`PD], " for tensor ", 
   xAct`xTerior`dx[$CellContext`M]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[85]:=",ExpressionUUID->"cee472bb-23e5-4cde-93e2-23aea6ed1183"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"dx", 
         StyleBox[GridBox[{
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`dx[$CellContext`M][{3, $CellContext`Sph}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"dx", "[", "M", "]"}]}],
  SequenceForm[
  "Added independent rule ", 
   xAct`xTerior`dx[$CellContext`M][{3, $CellContext`Sph}] -> xAct`xTerior`Diff[
     $CellContext`\[CurlyPhi][], xAct`xTensor`PD], " for tensor ", 
   xAct`xTerior`dx[$CellContext`M]],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[85]:=",ExpressionUUID->"9a48ce70-c86b-4bf7-aa9e-3a2cdef6eb11"]
}, Open  ]],

Cell["\<\
Once we have the coordinates, their differentials and their exterior products \
are computed with no difficulty. Example:\
\>", "MathCaption",ExpressionUUID->"93180177-282d-4166-8f5c-0a877396f88c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Diff", "@", 
    RowBox[{"t", "[", "]"}]}], ",", 
   RowBox[{
    RowBox[{"Diff", "@", 
     RowBox[{"t", "[", "]"}]}], "\[Wedge]", 
    RowBox[{"Diff", "@", 
     RowBox[{"r", "[", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"Diff", "@", 
     RowBox[{"\[Theta]", "[", "]"}]}], "\[Wedge]", 
    RowBox[{"Diff", "@", 
     RowBox[{"\[CurlyPhi]", "[", "]"}]}], "\[Wedge]", 
    RowBox[{"Diff", "@", 
     RowBox[{"t", "[", "]"}]}]}]}], "}"}]], "Input",
 CellLabel->"In[86]:=",ExpressionUUID->"67a9ba60-0353-4856-a154-3af9475cdbbd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["t",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`t[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`t[], xAct`xTensor`PD],
    Editable->False], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->
  "Out[86]=",ExpressionUUID->"1855189b-2e79-42b7-a281-d9fd6d511e4e"]
}, Open  ]],

Cell["The components of the holonomic canonical 1-form are", \
"MathCaption",ExpressionUUID->"721a50a6-6b19-4ccd-91a1-bc573280c089"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"dx", "[", "M", "]"}], "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Sph"}], "}"}], "]"}], "->", 
    RowBox[{"Diff", "@", 
     RowBox[{"t", "[", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"dx", "[", "M", "]"}], "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "Sph"}], "}"}], "]"}], "->", 
    RowBox[{"Diff", "@", 
     RowBox[{"r", "[", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"dx", "[", "M", "]"}], "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "Sph"}], "}"}], "]"}], "->", 
    RowBox[{"Diff", "@", 
     RowBox[{"\[Theta]", "[", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"dx", "[", "M", "]"}], "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "Sph"}], "}"}], "]"}], "->", 
    RowBox[{"Diff", "@", 
     RowBox[{"\[CurlyPhi]", "[", "]"}]}]}]}], "}"}]], "Input",
 CellLabel->"In[87]:=",ExpressionUUID->"db75772c-197d-4103-9629-675c9d8c0c6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"dx", 
         StyleBox[GridBox[{
            {
             StyleBox["0",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`dx[$CellContext`M][{0, $CellContext`Sph}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"dx", 
         StyleBox[GridBox[{
            {
             StyleBox["1",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`dx[$CellContext`M][{1, $CellContext`Sph}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"dx", 
         StyleBox[GridBox[{
            {
             StyleBox["2",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`dx[$CellContext`M][{2, $CellContext`Sph}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"dx", 
         StyleBox[GridBox[{
            {
             StyleBox["3",
              FontColor->RGBColor[0., 0., 1.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`dx[$CellContext`M][{3, $CellContext`Sph}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->
  "Out[87]=",ExpressionUUID->"dbc35a5a-4f80-4061-b2ac-fb6149753f52"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"Rule", "->", "ComponentValue"}]}], ";"}]], "Input",
 CellLabel->"In[88]:=",ExpressionUUID->"c5a6a741-fbb5-40e3-8596-70733241ff9c"],

Cell["\<\
We can now work with arbitrary differential forms defined in terms of these \
coordinates\
\>", "MathCaption",ExpressionUUID->"693acec5-257b-432a-97f0-a078fbf19591"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A2", "[", "]"}], "==", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"\[CurlyPhi]", "[", "]"}], "]"}], "/", 
    RowBox[{"r", "[", "]"}]}], 
   RowBox[{
    RowBox[{"Diff", "[", 
     RowBox[{"r", "[", "]"}], "]"}], "\[Wedge]", 
    RowBox[{"Diff", "@", 
     RowBox[{"\[Theta]", "[", "]"}]}]}]}]}]], "Input",
 CellLabel->"In[89]:=",ExpressionUUID->"45a5a01b-e47e-46ae-bab2-b3cb8d56e524"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "2"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A2[],
   Editable->False], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       $CellContext`r[], xAct`xTensor`PD],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox["\[Theta]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Theta][],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       $CellContext`\[Theta][], xAct`xTensor`PD],
      Editable->False]}]}], 
   InterpretationBox[
    StyleBox["r",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`r[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[89]=",ExpressionUUID->"1edda99b-01b2-4a0d-a0b7-7f7071997823"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "/@", "%"}]], "Input",
 CellLabel->"In[90]:=",ExpressionUUID->"5ed4779d-855d-4bb2-a1c5-0ce15ba6f936"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{"d", "[", 
     InterpretationBox[
      StyleBox[
       SuperscriptBox["A", "2"],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`A2[],
      Editable->False], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Diff[
    $CellContext`A2[], xAct`xTensor`PD],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         ShowAutoStyles->False,
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}], " ", 
      RowBox[{
       InterpretationBox[
        StyleBox[
         RowBox[{"d", "[", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`Diff[
         $CellContext`r[], xAct`xTensor`PD],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox[
         RowBox[{"d", "[", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`Diff[
         $CellContext`r[], xAct`xTensor`PD],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox[
         RowBox[{"d", "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`Diff[
         $CellContext`\[Theta][], xAct`xTensor`PD],
        Editable->False]}]}], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["r",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`r[],
       Editable->False], "2"]]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        ShowAutoStyles->False,
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox["\[CurlyPhi]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[CurlyPhi][],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`r[], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Theta][], xAct`xTensor`PD],
       Editable->False]}]}], 
    InterpretationBox[
     StyleBox["r",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`r[],
     Editable->False]]}]}]], "Output",
 CellLabel->
  "Out[90]=",ExpressionUUID->"6be07b19-79c9-4249-8b0f-a5e6df5f0e53"]
}, Open  ]],

Cell["\<\
The result of this computation is by default neither canonicalized nor \
simplified. This has to be done by the user.\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"0cc7abe0-87fa-4023-8019-0d99d1b600d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[91]:=",ExpressionUUID->"63ebdb3c-2d0f-4d15-b431-f8703f336b1e"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{"d", "[", 
     InterpretationBox[
      StyleBox[
       SuperscriptBox["A", "2"],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`A2[],
      Editable->False], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Diff[
    $CellContext`A2[], xAct`xTensor`PD],
   Editable->False], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       ShowAutoStyles->False,
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False], "]"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox["r",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`r[],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       $CellContext`r[], xAct`xTensor`PD],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox["\[Theta]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Theta][],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       $CellContext`\[Theta][], xAct`xTensor`PD],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox["\[CurlyPhi]",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[CurlyPhi][],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
      Editable->False]}]}], 
   InterpretationBox[
    StyleBox["r",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`r[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[91]=",ExpressionUUID->"0d78c5a5-8023-4aa5-89b1-27d2e7d63a70"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "/@", "%"}]], "Input",
 CellLabel->"In[92]:=",ExpressionUUID->"b7bf2aaa-7a0d-4fda-914e-bd2b3fdb5042"],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         ShowAutoStyles->False,
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}], " ", 
      RowBox[{
       InterpretationBox[
        StyleBox[
         RowBox[{"d", "[", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`Diff[
         $CellContext`r[], xAct`xTensor`PD],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox[
         RowBox[{"d", "[", 
          InterpretationBox[
           StyleBox["r",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`r[],
           Editable->False], "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`Diff[
         $CellContext`r[], xAct`xTensor`PD],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox[
         RowBox[{"d", "[", 
          InterpretationBox[
           StyleBox["\[Theta]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Theta][],
           Editable->False], "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`Diff[
         $CellContext`\[Theta][], xAct`xTensor`PD],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox[
         RowBox[{"d", "[", 
          InterpretationBox[
           StyleBox["\[CurlyPhi]",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[CurlyPhi][],
           Editable->False], "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`Diff[
         $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
        Editable->False]}]}], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["r",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`r[],
       Editable->False], "2"]]}], "-", 
   FractionBox[
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        ShowAutoStyles->False,
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox["\[CurlyPhi]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[CurlyPhi][],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox["r",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`r[],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`r[], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox["\[Theta]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Theta][],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[Theta][], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox["\[CurlyPhi]",
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[CurlyPhi][],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
       Editable->False]}]}], 
    InterpretationBox[
     StyleBox["r",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`r[],
     Editable->False]]}]}]], "Output",
 CellLabel->
  "Out[92]=",ExpressionUUID->"4fe81ebd-33c2-4c4a-a0fd-63a9b71dfe4d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->"In[93]:=",ExpressionUUID->"757f897b-80a5-4bc3-9161-2720ac82939d"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[93]=",ExpressionUUID->"84c183ad-60a1-4288-b9b7-7ee4005f4492"]
}, Open  ]],

Cell["\<\
It is also possible to work with differential forms involving arbitrary \
functions. For example:\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"669bdef4-4d6e-4312-8b38-226d40fd82f6"],

Cell[BoxData[
 RowBox[{"DefScalarFunction", "[", "F", "]"}]], "Input",
 CellLabel->"In[94]:=",ExpressionUUID->"cc2f5732-93e4-4c4f-b4af-3f70e9095601"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F", "[", 
  RowBox[{
   RowBox[{"t", "[", "]"}], ",", 
   RowBox[{"r", "[", "]"}], ",", 
   RowBox[{"\[Theta]", "[", "]"}], ",", 
   RowBox[{"\[CurlyPhi]", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[95]:=",ExpressionUUID->"465cbf1a-0dba-4ca6-bd22-1d9d7fcc5029"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox["F",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`F,
   Editable->False], "[", 
  RowBox[{
   InterpretationBox[
    StyleBox["t",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`t[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["r",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`r[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[Theta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Theta][],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox["\[CurlyPhi]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CurlyPhi][],
    Editable->False]}], "]"}]], "Output",
 CellLabel->
  "Out[95]=",ExpressionUUID->"45edc656-0a01-4454-9ab2-db04aa229559"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->"In[96]:=",ExpressionUUID->"9152aa32-ead8-48b2-9613-0351ea60b916"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[CurlyPhi]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CurlyPhi][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
    Editable->False], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Theta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Theta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Theta][], xAct`xTensor`PD],
    Editable->False], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["r",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`r[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`r[], xAct`xTensor`PD],
    Editable->False], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["t",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`t[],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`t[], xAct`xTensor`PD],
    Editable->False], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}]}]], "Output",
 CellLabel->
  "Out[96]=",ExpressionUUID->"bd9f19f0-ec88-4321-b54a-0c0d5e0fe415"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->"In[97]:=",ExpressionUUID->"929a9e8a-7198-4288-bcea-31596c15564e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[CurlyPhi]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CurlyPhi][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[CurlyPhi][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["\[Theta]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Theta][],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`\[Theta][], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["r",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`r[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`r[], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox["t",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      $CellContext`t[], xAct`xTensor`PD],
     Editable->False]}], " ", 
   RowBox[{
    SuperscriptBox[
     InterpretationBox[
      StyleBox["F",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`F,
      Editable->False], 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox["t",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["r",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`r[],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[Theta]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Theta][],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox["\[CurlyPhi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CurlyPhi][],
      Editable->False]}], "]"}]}]}]], "Output",
 CellLabel->
  "Out[97]=",ExpressionUUID->"1a11ae45-61d3-4ae8-afda-52f690b5b62c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->"In[98]:=",ExpressionUUID->"a93c88be-7407-4b49-b410-3473e9908546"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[98]=",ExpressionUUID->"ad13f1f6-dd98-4052-b7ee-036b50e776fb"]
}, Open  ]],

Cell["We undefine the structures introduced in this section.", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"c7da33e4-d75a-4824-8e1d-d602eddb340d"],

Cell[BoxData[
 RowBox[{"UndefChart", "@", "Sph"}]], "Input",
 CellLabel->"In[99]:=",ExpressionUUID->"bac1e0f2-f4aa-4234-b550-1165f2beaf71"],

Cell[BoxData[
 RowBox[{"UndefMetric", "@", "metricg"}]], "Input",
 CellLabel->
  "In[100]:=",ExpressionUUID->"8dc7a496-b496-4d86-b854-0d9a8f5ccc7e"],

Cell[BoxData[
 RowBox[{"UndefCovD", "@", "CD"}]], "Input",
 CellLabel->
  "In[101]:=",ExpressionUUID->"b14933cb-3d56-4cb1-9950-d7f204281c77"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefDiffForm", "/@", 
   RowBox[{"VisitorsOf", "@", "M"}]}], ";"}]], "Input",
 CellLabel->
  "In[102]:=",ExpressionUUID->"eb461b14-26ae-4607-88a2-ab98b2b1dd27"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefScalarFunction", "@", "F"}], ";"}]], "Input",
 CellLabel->
  "In[103]:=",ExpressionUUID->"f65c2930-4be1-4e30-bd7a-45a193763d6b"],

Cell[BoxData[
 RowBox[{"UndefManifold", "@", "M"}]], "Input",
 CellLabel->
  "In[104]:=",ExpressionUUID->"99e28b96-ce73-4921-8220-bcde408c8c2e"],

Cell[TextData[{
 "We reset the value of the symbolic dimension and undefine it. We check that \
",
 StyleBox["Global`", "DisplayMath"],
 " contains no symbols."
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"e7a13a17-98ba-4462-a8c4-f4a848a6da4b"],

Cell[BoxData[
 RowBox[{"dim", "=."}]], "Input",
 CellLabel->
  "In[105]:=",ExpressionUUID->"f62ca872-c976-4740-bac1-414ccd3e3a0d"],

Cell[BoxData[
 RowBox[{"UndefConstantSymbol", "@", "dim"}]], "Input",
 CellLabel->
  "In[106]:=",ExpressionUUID->"b2fe4f0e-329e-478c-bc6a-dd3adfb4b4f1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellLabel->
  "In[107]:=",ExpressionUUID->"ebb7e337-9371-4cf2-8eca-00dd1c241680"],

Cell[BoxData[
 RowBox[{"Missing", "[", 
  RowBox[{"\<\"UnknownSymbol\"\>", ",", "\<\"Global`*\"\>"}], "]"}]], "Output",
 CellLabel->"Out[107]=",ExpressionUUID->"c0a033ee-5e9f-4625-806b-0debc4d72d09"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2. Definition and basic properties of differential forms", \
"SubsectionIcon",ExpressionUUID->"5d204e3d-8e1b-4fb6-a95e-c75cc12e9f53"],

Cell[TextData[{
 StyleBox["DefDiffForm\t\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Defines a differential form\n",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["UndefDiffForm\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Undefines a differential form\n",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["Deg\t\t\t\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Returns the degree of an expression composed of differential forms \
",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}], "FramedBox",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"2165a25e-b195-4b95-abb5-8d186814a440"],

Cell[TextData[{
 "We define a differentiable manifold of symbolic dimension ",
 StyleBox["dim:", "DisplayMath"]
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"c2d11303-d32d-435c-aa3d-bcb723966859"],

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "@", "dim"}]], "Input",
 CellLabel->
  "In[108]:=",ExpressionUUID->"aa289496-6e91-4c15-b849-11942a9f3471"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "dim", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "In[109]:=",ExpressionUUID->"88fd8fa5-5c0f-4b31-9625-cdec72874859"],

Cell[TextData[{
 "Once we have a differentiable manifold, we can define differential forms on \
it. This is achieved with ",
 StyleBox["DefDiffForm", "DisplayMath"],
 " which is a wrapper for the ",
 StyleBox["xTensor", "DisplayMath"],
 " command ",
 StyleBox["DefTensor", "DisplayMath"],
 ". The command ",
 StyleBox["DefDiffForm", "DisplayMath"],
 " registers an object as a tensor valued differential form on a manifold. We \
can indicate the degree of the form as a separate argument. For example, let \
us define a 2-form on the manifold ",
 StyleBox["M", "DisplayMath"],
 "."
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"c027c38a-607e-4caf-8b89-6b4b0bd9b19e"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"\[CapitalOmega]", "[", "]"}], ",", "M", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->
  "In[110]:=",ExpressionUUID->"3ce0b530-7fbb-46a9-9780-6258c0f16404"],

Cell[TextData[{
 "The object ",
 StyleBox["\[CapitalOmega]", "DisplayMath"],
 " has been registered as a 2-form on M."
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"49cb55d7-1ea1-4b5a-a26a-a89ec9d9f8dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deg", "@", 
  RowBox[{"\[CapitalOmega]", "[", "]"}]}]], "Input",
 CellLabel->
  "In[111]:=",ExpressionUUID->"00be7aa4-9ea5-4fc2-90bf-ae87cc326a2d"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[111]=",ExpressionUUID->"f173f7ea-c634-4996-b419-51f12dd517c7"]
}, Open  ]],

Cell["\<\
Once we have a differential form, we can start doing operations with it\
\>", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"edeb1633-ea48-4faa-936c-462a33fa5498"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deg", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalOmega]", "[", "]"}], "\[Wedge]", 
     RowBox[{"\[CapitalOmega]", "[", "]"}]}], ",", 
    RowBox[{
     RowBox[{"\[CapitalOmega]", "[", "]"}], "\[Wedge]", 
     RowBox[{"\[CapitalOmega]", "[", "]"}], "\[Wedge]", 
     RowBox[{"\[CapitalOmega]", "[", "]"}]}]}], "}"}]}]], "Input",
 CellLabel->
  "In[112]:=",ExpressionUUID->"677be695-6a7c-4d5f-bb90-4d0b1c5fa4f4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "6"}], "}"}]], "Output",
 CellLabel->"Out[112]=",ExpressionUUID->"c649493c-aa74-4b50-abb5-4963a8325ed4"]
}, Open  ]],

Cell[TextData[{
 "We point out that ",
 StyleBox["Deg", "DisplayMath"],
 " is a particular case of the more general ",
 StyleBox["xTensor", "DisplayMath"],
 " command ",
 StyleBox["Grade", "DisplayMath"],
 ": "
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"b1861078-8ea7-4c8a-8c87-2955faf18d97"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grade", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalOmega]", "[", "]"}], "\[Wedge]", 
    RowBox[{"\[CapitalOmega]", "[", "]"}]}], ",", "Wedge"}], "]"}]], "Input",
 CellLabel->
  "In[113]:=",ExpressionUUID->"c08ac482-f8b4-42ea-9201-3309ec831419"],

Cell[BoxData["4"], "Output",
 CellLabel->"Out[113]=",ExpressionUUID->"3fa40669-c9a0-4f7c-a266-b79dfe167c20"]
}, Open  ]],

Cell["Another differential form and more examples of operations:", \
"MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"3a9a7730-bbab-4cee-9cf9-e85276761eca"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"\[Eta]", "[", "]"}], ",", "M", ",", "4"}], "]"}]], "Input",
 CellLabel->
  "In[114]:=",ExpressionUUID->"6a4168c8-f4f5-4a1f-a5fc-f7ece6824332"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalOmega]", "[", "]"}], "\[Wedge]", 
   RowBox[{"\[Eta]", "[", "]"}]}], "+", 
  RowBox[{
   RowBox[{"\[Eta]", "[", "]"}], "\[Wedge]", 
   RowBox[{"\[CapitalOmega]", "[", "]"}]}]}]], "Input",
 CellLabel->
  "In[115]:=",ExpressionUUID->"7354254a-99c2-44a6-b4d9-e122af84ca0f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[115]=",ExpressionUUID->"2eca7343-1cea-4521-b9c8-9a3c4b805548"]
}, Open  ]],

Cell[TextData[{
 "Expressions involving differential forms are canonicalized in the same way \
as any other expression in ",
 StyleBox["xAct", "DisplayMath"],
 "."
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"bb40a1d8-135f-410b-9ebf-e3d3b783af21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->
  "In[116]:=",ExpressionUUID->"9a46f68b-9187-4e23-85e0-e15c310f7f07"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[116]=",ExpressionUUID->"150f1b1e-7b42-4dd9-ab8c-99891e64bd81"]
}, Open  ]],

Cell["Now an example with a tensor valued form", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"c4c3198e-8249-4adf-a1f3-a32430fd2a5f"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"\[Tau]", "[", "a", "]"}], ",", "M", ",", "3"}], "]"}]], "Input",
 CellLabel->
  "In[117]:=",ExpressionUUID->"fa77493a-d425-4253-a68c-504daedb0b84"],

Cell["Canonicalization proceeds without dificulty.", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"9ea8f3ca-11cc-4618-8ffa-96486387cd71"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalOmega]", "[", "]"}], "\[Wedge]", 
   RowBox[{"\[Eta]", "[", "]"}], "\[Wedge]", 
   RowBox[{"\[Tau]", "[", "a", "]"}]}], "+", 
  RowBox[{
   RowBox[{"\[Eta]", "[", "]"}], "\[Wedge]", 
   RowBox[{"\[Tau]", "[", "a", "]"}], "\[Wedge]", 
   RowBox[{"\[CapitalOmega]", "[", "]"}]}]}]], "Input",
 CellLabel->
  "In[118]:=",ExpressionUUID->"237e50fb-4ece-435b-8a3f-17d36634233a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`a],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[118]=",ExpressionUUID->"4ebba499-7c98-4c64-bdb7-518268ae72cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->
  "In[119]:=",ExpressionUUID->"1f10e304-e5fc-49fd-ae13-7c88fb23a4f4"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[119]=",ExpressionUUID->"99810aab-78d6-468b-9cc2-e17f8a12d1a0"]
}, Open  ]],

Cell[TextData[{
 "As mentioned above, ",
 StyleBox["DefDiffForm", "DisplayMath"],
 " is just a wrapper for ",
 StyleBox["DefTensor", "DisplayMath"],
 ". This means that we can use ",
 StyleBox["DefTensor", "DisplayMath"],
 " to introduce differential forms in our session:"
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"86c67863-6ab4-4574-9e8c-0c4230bf730e"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"L", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M", ",", 
   RowBox[{"GradeOfTensor", "->", 
    RowBox[{"{", 
     RowBox[{"Wedge", "->", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->
  "In[120]:=",ExpressionUUID->"e88bdeb4-fba1-468d-b254-8fc689031a3e"],

Cell[CellGroupData[{

Cell[BoxData["$Tensors"], "Input",
 CellLabel->
  "In[121]:=",ExpressionUUID->"ce38844d-5e15-4405-9f79-b6b202a010fb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[CapitalOmega]", ",", "\[Eta]", ",", "\[Tau]", ",", "L"}], 
  "}"}]], "Output",
 CellLabel->"Out[121]=",ExpressionUUID->"25a6d2bc-0ad0-4348-a97d-7b4988283abc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Tau]", "[", "b", "]"}], "\[Wedge]", 
   RowBox[{"L", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[Wedge]", 
   RowBox[{"\[CapitalOmega]", "[", "]"}], "\[Wedge]", 
   RowBox[{"\[Eta]", "[", "]"}]}], "+", 
  RowBox[{
   RowBox[{"\[Tau]", "[", "a", "]"}], "\[Wedge]", 
   RowBox[{"\[Eta]", "[", "]"}]}]}]], "Input",
 CellLabel->
  "In[122]:=",ExpressionUUID->"daef7639-04ce-43b3-a387-40feaefaa3d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[122]=",ExpressionUUID->"beff5594-e83e-4955-b962-46dbf8701d91"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->
  "In[123]:=",ExpressionUUID->"2c814091-85a5-43d3-8d6c-ecc428175396"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[123]=",ExpressionUUID->"769832a1-e0b0-4f79-9fee-04d1234b2777"]
}, Open  ]],

Cell[TextData[{
 "If we do not specify a grade with ",
 StyleBox["DefTensor", "DisplayMath"],
 " then it is taken as zero by default and the object is regarded as a \
0-form. "
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"99337035-10d4-46f5-923f-80b95ee01fc9"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[124]:=",ExpressionUUID->"393c78df-5849-445d-95e2-4cfc28d9ca59"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deg", "@", 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[125]:=",ExpressionUUID->"2ca2dd09-d9c0-43b9-b853-d94ba6567012"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[125]=",ExpressionUUID->"b7764047-95e6-41cf-b089-52dfe6a1aba1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Diff\t\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Exterior derivative\n",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["UseCartan\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Expands all instances of the exterior derivative in terms of \
partial derivatives",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}], "FramedBox",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"44a77df7-dd1c-49bb-88bf-66b887b8c331"],

Cell[TextData[{
 "One of the most important operations in the exterior calculus is the \
exterior derivative. This operation is implemented through the command ",
 StyleBox["Diff", "DisplayMath"],
 " and it acts on any kind of differential form as we illustrate next:"
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"8447be6b-aa14-44ef-a829-4d3cee63e331"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Tau]", "[", "b", "]"}], "\[Wedge]", 
   RowBox[{"L", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[Wedge]", 
   RowBox[{"\[CapitalOmega]", "[", "]"}], "\[Wedge]", 
   RowBox[{"\[Eta]", "[", "]"}]}], "+", 
  RowBox[{
   RowBox[{"\[Tau]", "[", "a", "]"}], "\[Wedge]", 
   RowBox[{"\[Eta]", "[", "]"}]}]}]], "Input",
 CellLabel->
  "In[126]:=",ExpressionUUID->"d27f6b27-e625-4ad8-a1e9-d46b48379eff"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[126]=",ExpressionUUID->"470298d5-b8a7-4dfd-8bef-443e7943449c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "/@", "%"}]], "Input",
 CellLabel->
  "In[127]:=",ExpressionUUID->"e99c1a10-fa95-4631-a357-87ca5909e62f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`a], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"L", 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`L[$CellContext`a, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`L[$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[CapitalOmega]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalOmega][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[CapitalOmega][], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[127]=",ExpressionUUID->"4a0d27a7-43e5-4cb3-a570-999d819c5d30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->
  "In[128]:=",ExpressionUUID->"6e7f406c-ee15-4334-ab43-df140c75ee5e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`a], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`a],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[CapitalOmega]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalOmega][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[CapitalOmega][], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`b], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"L", 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`L[$CellContext`a, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`L[$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[128]=",ExpressionUUID->"7b1cbeb7-3449-4e5e-97d7-4eb36de64e4b"]
}, Open  ]],

Cell["\<\
We check that all the basic properties of the exterior derivative are \
implemented. For example the exterior derivative applied twice is zero \
identically (we may need to canonicalize the resulting expression to obtain \
this result).\
\>", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"30690226-df50-4cbb-b8b9-48a52bd2e380"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "/@", "%"}]], "Input",
 CellLabel->
  "In[129]:=",ExpressionUUID->"be7b9d30-2581-495d-ba61-c55c662d6b9e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`a], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"a"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`a],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`a], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"L", 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`L[$CellContext`a, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`L[$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[CapitalOmega]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalOmega][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[CapitalOmega][], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"L", 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`L[$CellContext`a, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`L[$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`b], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"L", 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`L[$CellContext`a, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`L[$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"L", 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`L[$CellContext`a, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`L[$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[CapitalOmega]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalOmega][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[CapitalOmega][], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`b], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[CapitalOmega]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalOmega][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[CapitalOmega][], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[CapitalOmega]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalOmega][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[CapitalOmega][], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`b], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"L", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`L[$CellContext`a, -$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[CapitalOmega]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalOmega][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[CapitalOmega][], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[Eta]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Eta][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Eta][], xAct`xTensor`PD],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau][$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[Tau][$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalOmega][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"L", 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`L[$CellContext`a, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`L[$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox["\[Eta]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Eta][],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau][$CellContext`b],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox["\[CapitalOmega]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalOmega][],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`\[CapitalOmega][], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"L", 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`L[$CellContext`a, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`L[$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[129]=",ExpressionUUID->"fb4271c7-3041-4c9a-a365-94d681f37c9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->
  "In[130]:=",ExpressionUUID->"d26c39c2-40f0-43b1-8853-214a52b86cb8"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[130]=",ExpressionUUID->"e24b9f8b-fd30-4e38-8708-5c9f594db246"]
}, Open  ]],

Cell[TextData[{
 "It is possible to expand the exterior derivative in terms of partial \
derivatives (only when it acts on a zero degree form). Use",
 StyleBox[" ", "DisplayMath"],
 StyleBox["UseCartan", "DisplayMath"],
 " for that."
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"dc726b24-64b2-4691-b92e-28651ea0a321"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "[", 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[131]:=",ExpressionUUID->"0a8c034f-e5c3-4a20-9755-91acf0280e9c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"d", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"T", 
         StyleBox[GridBox[{
            {" ", " "},
            {"a", "b"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`T[-$CellContext`a, -$CellContext`b],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Diff[
   $CellContext`T[-$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
  Editable->False]], "Output",
 CellLabel->"Out[131]=",ExpressionUUID->"f8dda79c-009b-4b3e-a71d-83fa1b588c0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UseCartan", "[", 
  RowBox[{"%", ",", "PD"}], "]"}]], "Input",
 CellLabel->
  "In[132]:=",ExpressionUUID->"b77f1369-2b50-4cc5-b4ad-c0e3bf6715b0"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"dx", 
       StyleBox[GridBox[{
          {"c"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`dx[$CellContext`M][$CellContext`c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "c"], GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`c][
    $CellContext`T[-$CellContext`a, -$CellContext`b]],
   Editable->False]}]], "Output",
 CellLabel->"Out[132]=",ExpressionUUID->"9d4eef4c-5039-4346-a1b3-5e68db750e45"]
}, Open  ]],

Cell[TextData[{
 "The symbol ",
 StyleBox["PD", "DisplayMath"],
 " represents the fiducial covariant derivative in ",
 StyleBox["xTensor", "DisplayMath"],
 ". We refer to section 6.1 of the documentation of ",
 StyleBox["xTensor", "DisplayMath"],
 " for further information. In addition we point out that ",
 StyleBox["UseCartan", "DisplayMath"],
 " has further applications which are explained in section 4. "
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"8bacf7c9-ca94-4cae-9916-84c1d99348a1"]
}, Closed]],

Cell[CellGroupData[{

Cell["3. Cartan structure equations", \
"SubsectionIcon",ExpressionUUID->"76d1ce2b-f057-4844-8e4c-9a11787551ff"],

Cell[TextData[{
 StyleBox["UseCartan\t\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Expands the exterior derivative according to the Cartan structure \
equations.", "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["\nCoframe\t\t\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Representation of the canonical 1-form in the frame bundle of a \
manifold.", "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["\n", "SubsubsectionIcon",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["dx\t\t\t\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Holonomic canonical 1-form.\n", "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["ChristoffelForm\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Connection 1-form (tangent bundle covariant derivatives).\n", 
  "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["ConnectionForm\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Connection 1-form (general covariant derivatives).\n", 
  "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["RiemannForm\t\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Curvature 2-form (tangent bundle covariant derivatives).\n", 
  "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["CurvatureForm\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Curvature 2-form (general covariant derivatives).", "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]]
}], "FramedBox",
 FontFamily->"Arial",ExpressionUUID->"16121767-6f78-4ec2-92f1-84f69caaa0f5"],

Cell["First of all, we introduce a covariant derivative:", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"03cf1a68-cd6d-442b-a7ff-4c0f7e053823"],

Cell[BoxData[
 RowBox[{"DefCovD", "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<D\>\""}], "}"}], ",", 
   RowBox[{"Torsion", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->
  "In[133]:=",ExpressionUUID->"c5becd2c-bd24-41fb-8d79-afdaaacd8b24"],

Cell["\<\
Once we have introduced a covariant derivative we can work with its \
connection 1-form and the curvature 2-form:\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"2bd6d959-b53e-4225-9e4a-9d6e0a811208"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChristoffelForm", "[", "CD", "]"}], "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",
 CellLabel->
  "In[134]:=",ExpressionUUID->"10857236-5c5c-4d68-905a-323db5baa920"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
      StyleBox[GridBox[{
         {"a", " "},
         {" ", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[134]=",ExpressionUUID->"df635a21-13a2-4c93-a6f7-893f0e326ac3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Deg"}]], "Input",
 CellLabel->
  "In[135]:=",ExpressionUUID->"186f623d-410d-4778-afda-9188e4a34c2d"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[135]=",ExpressionUUID->"59580a69-fa84-4da0-a9f3-1a16382569dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannForm", "[", "CD", "]"}], "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "b"}]}], "]"}]], "Input",
 CellLabel->
  "In[136]:=",ExpressionUUID->"895fe9c6-aa13-49e7-b2e9-5c81e0ebd4d7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"R", "[", "D", "]"}], 
      StyleBox[GridBox[{
         {"a", " "},
         {" ", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[136]=",ExpressionUUID->"c8c02dc0-1f82-4c26-ab5d-f82a3962a71f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Deg"}]], "Input",
 CellLabel->
  "In[137]:=",ExpressionUUID->"bf83b975-4569-42ff-b1df-8c75f58be657"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[137]=",ExpressionUUID->"5570f237-448f-49ad-a787-7a5dc74bdcb9"]
}, Open  ]],

Cell[TextData[{
 "These elements are related by the Cartan structure equations. We can easily \
obtain the Cartan structure equations for a given connection by means of ",
 StyleBox["UseCartan", "DisplayMath"],
 "."
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"fc591fdf-b186-469c-ae5c-ffe0cd982dc8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CartanStructureEqs", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Diff", "@", 
      RowBox[{
       RowBox[{"Coframe", "[", "M", "]"}], "[", "a", "]"}]}], "==", 
     RowBox[{"UseCartan", "[", 
      RowBox[{
       RowBox[{"Diff", "[", 
        RowBox[{
         RowBox[{"Coframe", "[", "M", "]"}], "[", "a", "]"}], "]"}], ",", 
       "CD"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"Diff", "@", 
      RowBox[{
       RowBox[{"ChristoffelForm", "[", "CD", "]"}], "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "b"}]}], "]"}]}], "==", 
     RowBox[{"UseCartan", "[", 
      RowBox[{
       RowBox[{"Diff", "[", 
        RowBox[{
         RowBox[{"ChristoffelForm", "[", "CD", "]"}], "[", 
         RowBox[{"a", ",", 
          RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "CD"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"Diff", "@", 
      RowBox[{
       RowBox[{"TorsionForm", "[", "CD", "]"}], "[", "a", "]"}]}], "==", 
     RowBox[{"UseCartan", "[", 
      RowBox[{
       RowBox[{"Diff", "[", 
        RowBox[{
         RowBox[{"TorsionForm", "[", "CD", "]"}], "[", "a", "]"}], "]"}], ",",
        "CD"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"Diff", "@", 
      RowBox[{
       RowBox[{"RiemannForm", "[", "CD", "]"}], "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "b"}]}], "]"}]}], "==", 
     RowBox[{"UseCartan", "[", 
      RowBox[{
       RowBox[{"Diff", "[", 
        RowBox[{
         RowBox[{"RiemannForm", "[", "CD", "]"}], "[", 
         RowBox[{"a", ",", 
          RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "CD"}], "]"}]}]}], 
   "}"}]}]], "Input",
 CellLabel->
  "In[138]:=",ExpressionUUID->"80a7df96-0a26-4783-9ef1-a48d045de4c4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Theta]", 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], xAct`xTensor`PD],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"a", " "},
                {" ", "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Theta]", 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
         Editable->False]}], ")"}]}], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
            StyleBox[GridBox[{
               {"a", " "},
               {" ", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b], xAct`xTensor`PD],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"a", " "},
                {" ", "c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"c", " "},
                {" ", "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
         Editable->False]}], ")"}]}], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "D", "]"}], 
          StyleBox[GridBox[{
             {"a", " "},
             {" ", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
            StyleBox[GridBox[{
               {"a"},
               {" "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a], 
      xAct`xTensor`PD],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"a", " "},
                {" ", "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"R", "[", "D", "]"}], 
            StyleBox[GridBox[{
               {"a", " "},
               {" ", "b"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b], xAct`xTensor`PD],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}]}]}]}], "}"}]], "Output",
 CellLabel->"Out[138]=",ExpressionUUID->"14dbd0b2-aa5d-4a30-acc8-01eb815211f6"]
}, Open  ]],

Cell["\<\
We can also check the complete integrability conditions of the Cartan system. \
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"1990aaba-32c6-4628-b7c0-9db70fb2cfa5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->
  "In[139]:=",ExpressionUUID->"923867b5-a452-4163-b411-8426e0dc904a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"a"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`a], 
       xAct`xTensor`PD],
      Editable->False], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
              StyleBox[GridBox[{
                 {"a", " "},
                 {" ", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Theta]", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], xAct`xTensor`PD],
       Editable->False]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"a", " "},
                {" ", "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b], xAct`xTensor`PD],
      Editable->False], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
              StyleBox[GridBox[{
                 {"a", " "},
                 {" ", "c"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
              StyleBox[GridBox[{
                 {"c", " "},
                 {" ", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b], xAct`xTensor`PD],
       Editable->False]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          RowBox[{"d", "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {
                RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
                StyleBox[GridBox[{
                   {"a", " "},
                   {" ", "b"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            
            xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
            Editable->False], "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Diff[
          
          xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b], xAct`xTensor`PD],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Theta]", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b], 
        xAct`xTensor`PD],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"R", "[", "D", "]"}], 
              StyleBox[GridBox[{
                 {"a", " "},
                 {" ", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b], xAct`xTensor`PD],
       Editable->False]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
              StyleBox[GridBox[{
                 {"c", " "},
                 {" ", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"R", "[", "D", "]"}], 
              StyleBox[GridBox[{
                 {"c", " "},
                 {" ", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"R", "[", "D", "]"}], 
              StyleBox[GridBox[{
                 {"a", " "},
                 {" ", "c"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c], xAct`xTensor`PD],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
              StyleBox[GridBox[{
                 {"a", " "},
                 {" ", "c"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c], xAct`xTensor`PD],
       Editable->False]}]}]}]}], "}"}]], "Output",
 CellLabel->"Out[139]=",ExpressionUUID->"9e335127-5adb-448d-b0a6-5e7655048727"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UseCartan", "[", 
  RowBox[{"%", ",", "CD"}], "]"}]], "Input",
 CellLabel->
  "In[140]:=",ExpressionUUID->"64285119-24af-4733-9c68-767c24f1f6fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"b", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`d],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"d", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`d, \
-$CellContext`b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`d],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"d", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`d, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"a", " "},
                {" ", "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"b"},
                {" "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"b", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`c],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"b", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[GothicCapitalT]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`TorsionForm[$CellContext`CD][$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"b", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`b, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Theta]", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"c", " "},
                {" ", "b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"d", " "},
                {" ", "c"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`d, \
-$CellContext`c],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "D", "]"}], 
             StyleBox[GridBox[{
                {"a", " "},
                {" ", "d"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`d],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"d", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`d, \
-$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`d],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`d],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"d", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`d, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"d", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`d, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`c, \
-$CellContext`d],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`c, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`d],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"d", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`d, \
-$CellContext`c],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"R", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"d", " "},
              {" ", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`RiemannForm[$CellContext`CD][$CellContext`d, \
-$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"c", " "},
              {" ", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`c, \
-$CellContext`d],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
           StyleBox[GridBox[{
              {"a", " "},
              {" ", "c"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ChristoffelForm[$CellContext`CD][$CellContext`a, \
-$CellContext`c],
       Editable->False]}]}]}]}], "}"}]], "Output",
 CellLabel->"Out[140]=",ExpressionUUID->"a30817a1-9f26-44b8-87c3-31ed86e991cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", "%", "]"}]], "Input",
 CellLabel->
  "In[141]:=",ExpressionUUID->"beb2e795-e5f5-4b6b-b9d9-51f884d1f9d3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellLabel->"Out[141]=",ExpressionUUID->"4000cdef-deb4-40a9-987d-03659225ab39"]
}, Open  ]],

Cell[TextData[{
 "Some of the Cartan equations can be formulated in any vector bundle. For \
example take a real vector bundle over the manifold ",
 StyleBox["M", "DisplayMath"],
 " with 3-dimensional fibres and define a covariant derivative on it."
}], "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"763b5dc3-a7bd-415e-b206-da0b5354f6b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefVBundle", "[", 
  RowBox[{"VB", ",", "M", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "J", ",", "H"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->
  "In[142]:=",ExpressionUUID->"e650dd2d-9f7c-4202-80bd-d9e752508f60"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"C\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 142, 3, 19264546493731647491, "Local",
    "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[142]:=",ExpressionUUID->"6e9df2cb-fa63-4872-92c6-dff27eda7ed9"],

Cell[BoxData[
 TemplateBox[{
  "ValidateSymbol", "capital", 
   "\"System name \\!\\(\\*RowBox[{\\\"\\\\\\\"D\\\\\\\"\\\"}]\\) is \
overloaded as an abstract index.\"", 2, 142, 4, 19264546493731647491, "Local",
    "xAct`xCore`ValidateSymbol"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "During evaluation of \
In[142]:=",ExpressionUUID->"fe59b4b2-73bd-4a3c-a39b-90bf50693ddc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DefCovD", "[", 
  RowBox[{
   RowBox[{"cdv", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "VB", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<|\>\"", ",", "\"\<\[ScriptCapitalD]\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->
  "In[143]:=",ExpressionUUID->"971663cc-5067-4831-80ed-d5fd1bf8c9ea"],

Cell["\<\
For a covariant derivative defined in a general vector bundle, the notation \
for the connection 1-form and the curvature 2-form is slightly different; in \
addition to the symbol of the covariant derivative it also contains the \
symbol representing the vector bundle upon which the covariant derivative is \
defined.\
\>", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"36fa3d53-8d92-4adc-9dbf-6483e09d05e3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConnectionForm", "[", 
   RowBox[{"cdv", ",", "VB"}], "]"}], "[", 
  RowBox[{"A", ",", 
   RowBox[{"-", "B"}]}], "]"}]], "Input",
 CellLabel->
  "In[144]:=",ExpressionUUID->"74f9c774-8299-4279-b8ff-7608fc06ec09"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
      StyleBox[GridBox[{
         {"A", " "},
         {" ", "B"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
  Editable->False]], "Output",
 CellLabel->"Out[144]=",ExpressionUUID->"7101d0a9-e414-4406-9ee7-bec75b288b05"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Deg"}]], "Input",
 CellLabel->
  "In[145]:=",ExpressionUUID->"11087360-9656-4501-bfab-197161c9b1ed"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[145]=",ExpressionUUID->"37d11eba-4821-4fb8-87e9-61d4d06d792e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CurvatureForm", "[", 
   RowBox[{"cdv", ",", "VB"}], "]"}], "[", 
  RowBox[{"A", ",", 
   RowBox[{"-", "B"}]}], "]"}]], "Input",
 CellLabel->
  "In[146]:=",ExpressionUUID->"4f22e234-a659-46ab-9c03-83bde1856d28"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
      StyleBox[GridBox[{
         {"A", " "},
         {" ", "B"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
  Editable->False]], "Output",
 CellLabel->"Out[146]=",ExpressionUUID->"8acc4076-f79e-4b13-b91d-00a68555b7fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Deg"}]], "Input",
 CellLabel->
  "In[147]:=",ExpressionUUID->"bdf37e4c-16d4-40a8-9ad8-8fd98e23cc2c"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[147]=",ExpressionUUID->"c0174041-0d54-4bfc-b678-ee94160c4d97"]
}, Open  ]],

Cell["In this case, the Cartan equations adopt now the form:", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"b2656353-a25d-4338-95d2-2439e8449bb8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Diff", "@", 
     RowBox[{
      RowBox[{"ConnectionForm", "[", 
       RowBox[{"cdv", ",", "VB"}], "]"}], "[", 
      RowBox[{"A", ",", 
       RowBox[{"-", "B"}]}], "]"}]}], "==", 
    RowBox[{"UseCartan", "[", 
     RowBox[{
      RowBox[{"Diff", "@", 
       RowBox[{
        RowBox[{"ConnectionForm", "[", 
         RowBox[{"cdv", ",", "VB"}], "]"}], "[", 
        RowBox[{"A", ",", 
         RowBox[{"-", "B"}]}], "]"}]}], ",", "cdv"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Diff", "@", 
     RowBox[{
      RowBox[{"CurvatureForm", "[", 
       RowBox[{"cdv", ",", "VB"}], "]"}], "[", 
      RowBox[{"A", ",", 
       RowBox[{"-", "B"}]}], "]"}]}], "==", 
    RowBox[{"UseCartan", "[", 
     RowBox[{
      RowBox[{"Diff", "@", 
       RowBox[{
        RowBox[{"CurvatureForm", "[", 
         RowBox[{"cdv", ",", "VB"}], "]"}], "[", 
        RowBox[{"A", ",", 
         RowBox[{"-", "B"}]}], "]"}]}], ",", "cdv"}], "]"}]}]}], 
  "}"}]], "Input",
 CellLabel->
  "In[148]:=",ExpressionUUID->"c60bcee6-071f-41bf-80f3-03b9b3a97732"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
            StyleBox[GridBox[{
               {"A", " "},
               {" ", "B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B], xAct`xTensor`PD],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"A", " "},
                {" ", "C"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"C", " "},
                {" ", "B"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
         C, -$CellContext`B],
         Editable->False]}], ")"}]}], "+", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
          StyleBox[GridBox[{
             {"A", " "},
             {" ", "B"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"d", "[", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
            StyleBox[GridBox[{
               {"A", " "},
               {" ", "B"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
        Editable->False], "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Diff[
      xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B], xAct`xTensor`PD],
     Editable->False], "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False]}]}]}]}], "}"}]], "Output",
 CellLabel->"Out[148]=",ExpressionUUID->"776bb6d0-5257-4ae8-80cc-3ea076fa5795"]
}, Open  ]],

Cell["\<\
We compute the integrability conditions of the Cartan system in this case.\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"e3c1b584-d4b3-4af9-a066-89edd51b9ae5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->
  "In[149]:=",ExpressionUUID->"42368a51-487b-40b0-b0b6-144fd7536ba7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"A", " "},
                {" ", "B"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B], xAct`xTensor`PD],
      Editable->False], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"A", " "},
                 {" ", "C"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"C", " "},
                 {" ", "B"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
          C, -$CellContext`B],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
        C, -$CellContext`B], xAct`xTensor`PD],
       Editable->False]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"C", " "},
                 {" ", "B"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
          C, -$CellContext`B],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
        C, -$CellContext`B], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"C", " "},
                 {" ", "B"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
          C, -$CellContext`B],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
        C, -$CellContext`B], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"A", " "},
                 {" ", "C"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C], xAct`xTensor`PD],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"A", " "},
                 {" ", "C"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C], xAct`xTensor`PD],
       Editable->False]}]}]}]}], "}"}]], "Output",
 CellLabel->"Out[149]=",ExpressionUUID->"559d4fc9-b2a4-4c5b-bc21-6c2c9e22de49"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UseCartan", "[", 
  RowBox[{"%", ",", "cdv"}], "]"}]], "Input",
 CellLabel->
  "In[150]:=",ExpressionUUID->"a128e44a-dab0-4422-bd32-a7ee6214a37e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][C, -D],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       D, -$CellContext`B],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -D],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][D, -C],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"C", " "},
                {" ", "B"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
         C, -$CellContext`B],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"D", " "},
                {" ", "C"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][D, -C],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"A", " "},
                {" ", "D"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -D],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][D, -C],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -D],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][C, -D],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       D, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       D, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][C, -D],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -D],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][D, -C],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
       D, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][C, -D],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False]}]}]}]}], "}"}]], "Output",
 CellLabel->"Out[150]=",ExpressionUUID->"f1f60d30-b5bd-4802-b750-34a90049a187"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->
  "In[151]:=",ExpressionUUID->"8c47c077-d667-415f-b110-b2261a4021e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 CellLabel->"Out[151]=",ExpressionUUID->"c83bf649-3f7f-4819-8080-dbe6c4b86aee"]
}, Open  ]],

Cell["\<\
One can carry out other interesting computations. For example take the \
expression:\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"e4e58c0d-be24-435e-8d8b-d5d8027e37f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CurvatureForm", "[", 
    RowBox[{"cdv", ",", "VB"}], "]"}], "[", 
   RowBox[{"B", ",", 
    RowBox[{"-", "A"}]}], "]"}], "\[Wedge]", 
  RowBox[{
   RowBox[{"CurvatureForm", "[", 
    RowBox[{"cdv", ",", "VB"}], "]"}], "[", 
   RowBox[{"C", ",", 
    RowBox[{"-", "B"}]}], "]"}], "\[Wedge]", 
  RowBox[{
   RowBox[{"CurvatureForm", "[", 
    RowBox[{"cdv", ",", "VB"}], "]"}], "[", 
   RowBox[{"A", ",", 
    RowBox[{"-", "C"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[152]:=",ExpressionUUID->"9e71014a-e3f2-488d-90ea-9174d9e8b756"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
       StyleBox[GridBox[{
          {"B", " "},
          {" ", "A"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
       StyleBox[GridBox[{
          {"C", " "},
          {" ", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
   C, -$CellContext`B],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
       StyleBox[GridBox[{
          {"A", " "},
          {" ", "C"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
   Editable->False]}]], "Output",
 CellLabel->"Out[152]=",ExpressionUUID->"bc65f71d-4691-4504-b5bb-4286a572f2da"]
}, Open  ]],

Cell["\<\
It is well known that this is a closed form (this is independent from the \
dimension). Let us check this:\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"ba0330e7-ac91-439b-8f28-7b501e1c89f1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->
  "In[153]:=",ExpressionUUID->"1536b31f-a89d-411d-8a80-672885a6ec50"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"B", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"C", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
    C, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`B],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
     C, -$CellContext`B], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"C", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
    C, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C], xAct`xTensor`PD],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[153]=",ExpressionUUID->"a7e3c39b-abf8-486a-b81c-b3ea30939692"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UseCartan", "[", 
  RowBox[{"%", ",", "cdv"}], "]"}]], "Input",
 CellLabel->
  "In[154]:=",ExpressionUUID->"f7b943d1-ef32-4ada-ba56-5f940537016e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"D", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
    D, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -D],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"C", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
    C, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"D", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
    D, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"C", " "},
           {" ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][C, -D],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"C", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
    C, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"D", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][D, -C],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -D],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"C", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
    C, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"D", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][D, -C],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -D],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"D", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
    D, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"C", " "},
           {" ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][C, -D],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"D", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
    D, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -D],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"C", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, $CellContext`VB][
    C, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "C"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -C],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[154]=",ExpressionUUID->"8012936f-44a7-49b9-90af-062837ee941d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->
  "In[155]:=",ExpressionUUID->"870feec5-f2ef-40cf-a08b-650e5143753f"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[155]=",ExpressionUUID->"1e249087-a240-47cd-b6fb-c58e3c4006a9"]
}, Open  ]],

Cell["\<\
This result generalizes to exterior powers of the curvature form with any \
number of factors. Since the exterior derivative is zero then there are local \
potentials for these expressions which can be explicitly found in terms of \
the so-called Chern-Simmons forms. We can check this result in a number of \
particular cases. Let us define first an index free version of the curvature \
2-form and the connection 1-form. \
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"a92a94e4-e89e-49bd-8f37-43bde53f9a14"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"\[ScriptCapitalF]", "[", "]"}], ",", "M", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->
  "In[156]:=",ExpressionUUID->"0ad39b2a-ad63-4ee3-a82c-666cb21b0409"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"\[ScriptCapitalA]", "[", "]"}], ",", "M", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->
  "In[157]:=",ExpressionUUID->"d3ff282b-2e7e-4dff-bf40-735b33b8b25e"],

Cell["We need some preliminary code to work with these forms:", "MathCaption",
 
 FontFamily->"Arial",ExpressionUUID->"e0ff299b-6c16-415a-b322-b8d5fc65c684"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DefInertHead", "[", 
   RowBox[{"TR", ",", 
    RowBox[{"LinearQ", "\[Rule]", "True"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<Tr\>\""}]}], "]"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Grade", "[", 
     RowBox[{
      RowBox[{"TR", "[", "expr_", "]"}], ",", "Wedge"}], "]"}], "^:=", 
    RowBox[{"Grade", "[", 
     RowBox[{"expr", ",", "Wedge"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"addfactor", "[", 
     RowBox[{"expr1_", ",", 
      RowBox[{"expr2_", "?", "xTensorQ"}]}], "]"}], ":=", 
    RowBox[{"expr1", "\[Wedge]", 
     RowBox[{"expr2", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"First", "@", 
         RowBox[{"Select", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IndicesOf", "[", "Free", "]"}], "[", "expr1", "]"}], ",",
            "DownIndexQ"}], "]"}]}]}], ",", 
       RowBox[{"-", 
        RowBox[{"NewIndexIn", "[", "VB", "]"}]}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"traceindex", "[", "expr_", "]"}], ":=", 
    RowBox[{"expr", "/.", 
     RowBox[{"UpIndex", "/@", 
      RowBox[{"(", 
       RowBox[{"Rule", "@@", 
        RowBox[{
         RowBox[{"IndicesOf", "[", "Free", "]"}], "[", "expr", "]"}]}], 
       ")"}]}]}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"rules", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\[ScriptCapitalF]", "[", "]"}], "\[Rule]", 
       RowBox[{"CurvatureForm", "[", 
        RowBox[{"cdv", ",", "VB"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"\[ScriptCapitalA]", "[", "]"}], "\[Rule]", 
       RowBox[{"ConnectionForm", "[", 
        RowBox[{"cdv", ",", "VB"}], "]"}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"expandtrace", "=", 
   RowBox[{"expr_TR", "\[RuleDelayed]", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"list", "=", 
        RowBox[{
         RowBox[{"List", "@@", 
          RowBox[{"First", "@", "expr"}]}], "/.", "rules"}]}], "}"}], ",", 
      RowBox[{"traceindex", "@", 
       RowBox[{"Fold", "[", 
        RowBox[{"addfactor", ",", 
         RowBox[{
          RowBox[{"First", "[", "list", "]"}], "[", 
          RowBox[{"B", ",", 
           RowBox[{"-", "A"}]}], "]"}], ",", 
         RowBox[{"Rest", "[", "list", "]"}]}], "]"}]}]}], "]"}]}]}], 
  ";"}], "\n"}], "Input",
 CellLabel->
  "In[158]:=",ExpressionUUID->"2889887b-6abb-4e4f-aa1c-578e6ce40555"],

Cell["\<\
We are now ready to test our results. Let us start with the Chern-Simmons \
3-form:\
\>", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"99caaaac-555a-4efb-bac8-905ced6e89c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChernSimmons3", "=", 
  RowBox[{"TR", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[ScriptCapitalF]", "[", "]"}], "\[Wedge]", 
     RowBox[{"\[ScriptCapitalA]", "[", "]"}]}], "-", 
    RowBox[{
     RowBox[{"1", "/", "3"}], 
     RowBox[{
      RowBox[{"\[ScriptCapitalA]", "[", "]"}], "\[Wedge]", 
      RowBox[{"\[ScriptCapitalA]", "[", "]"}], "\[Wedge]", 
      RowBox[{"\[ScriptCapitalA]", "[", "]"}]}]}]}], "]"}]}]], "Input",
 CellLabel->
  "In[164]:=",ExpressionUUID->"eef4a67c-9324-4a57-ae1b-df40a7fe4772"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{"Tr", "[", 
     RowBox[{
      InterpretationBox[
       StyleBox["\[ScriptCapitalF]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[ScriptCapitalF][],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox["\[ScriptCapitalA]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[ScriptCapitalA][],
       Editable->False]}], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TR[
    Wedge[
     $CellContext`\[ScriptCapitalF][], 
     $CellContext`\[ScriptCapitalA][]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"Tr", "[", 
      RowBox[{
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False]}], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TR[
     Wedge[
      $CellContext`\[ScriptCapitalA][], 
      $CellContext`\[ScriptCapitalA][], 
      $CellContext`\[ScriptCapitalA][]]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[164]=",ExpressionUUID->"c664de64-efd9-4d3f-bd3c-ebddde7b7f54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", "expandtrace"}]], "Input",
 CellLabel->
  "In[165]:=",ExpressionUUID->"eae212cc-1513-4258-a28a-38cc73ffaaab"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H1", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H3", " "},
            {" ", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H3, -$CellContext`A],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"A", " "},
            {" ", "H2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H2],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H2", " "},
            {" ", "H3"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`H3],
     Editable->False]}]}]}]], "Output",
 CellLabel->"Out[165]=",ExpressionUUID->"3ad38cbd-86e8-4f9c-b95e-96f848db4257"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->
  "In[166]:=",ExpressionUUID->"42893133-6074-4582-aa9c-3ffcc04834de"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H1", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"A", " "},
            {" ", "H1"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H1", " "},
            {" ", "H2"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H2", " "},
            {" ", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A],
     Editable->False]}]}]}]], "Output",
 CellLabel->"Out[166]=",ExpressionUUID->"1b13071e-dc02-4684-94ba-085c3bfff739"]
}, Open  ]],

Cell["We compute the exterior derivative of this object:", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"397de5c2-faa5-4a7e-af02-44a0b2359db9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->
  "In[167]:=",ExpressionUUID->"65334f1b-f228-4fbd-a249-e19c73931604"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H1", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H1", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`A],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`A], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          RowBox[{"d", "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {
                RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
                StyleBox[GridBox[{
                   {"A", " "},
                   {" ", "H1"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            
            xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
            Editable->False], "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Diff[
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1], xAct`xTensor`PD],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H1", " "},
                {" ", "H2"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H2", " "},
                {" ", "A"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"H1", " "},
                 {" ", "H2"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H2", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H1", " "},
              {" ", "H2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"H2", " "},
                 {" ", "A"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A], xAct`xTensor`PD],
       Editable->False]}]}], ")"}]}]}]], "Output",
 CellLabel->"Out[167]=",ExpressionUUID->"14a84546-8f37-4707-9354-d3f9712c57d4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UseCartan", "[", 
  RowBox[{"%", ",", "cdv"}], "]"}]], "Input",
 CellLabel->
  "In[168]:=",ExpressionUUID->"99224ed8-7c4b-4e8d-a452-62ff9f499d3f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H1", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "H1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`H1],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H1", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H1", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`B],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H1"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H1", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`B],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"A", " "},
                {" ", "H1"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H1", " "},
                {" ", "H2"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H2", " "},
                {" ", "A"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H1", " "},
              {" ", "H2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H2", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H1", " "},
              {" ", "H2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H2", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"B", " "},
              {" ", "H1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`H1],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H1", " "},
              {" ", "H2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H2", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H1", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -C],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "H2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`H2],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H2", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H1", " "},
              {" ", "H2"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`H2],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H2", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H2, -D],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       D, -$CellContext`A],
       Editable->False]}]}], ")"}]}]}]], "Output",
 CellLabel->"Out[168]=",ExpressionUUID->"83cd8094-a99e-4631-ac6c-785d1683a0ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->
  "In[169]:=",ExpressionUUID->"1ecfd93f-0274-4e33-a658-8858bbb7f9fd"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
       StyleBox[GridBox[{
          {"A", " "},
          {" ", "H1"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H1],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
       StyleBox[GridBox[{
          {"H1", " "},
          {" ", "A"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`A],
   Editable->False]}]], "Output",
 CellLabel->"Out[169]=",ExpressionUUID->"e88fea53-f3f1-42b5-b467-5a9485f1dbc9"]
}, Open  ]],

Cell["Similar computation for the Chern-Simmons 5-form.", "MathCaption",
 FontFamily->"Arial",ExpressionUUID->"522d9fc8-b615-4a0c-bc0e-49668549fe88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChernSimmons5", "=", 
  RowBox[{"TR", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[ScriptCapitalF]", "[", "]"}], "\[Wedge]", 
     RowBox[{"\[ScriptCapitalF]", "[", "]"}], "\[Wedge]", 
     RowBox[{"\[ScriptCapitalA]", "[", "]"}]}], "-", 
    RowBox[{
     RowBox[{"1", "/", "2"}], 
     RowBox[{
      RowBox[{"\[ScriptCapitalF]", "[", "]"}], "\[Wedge]", 
      RowBox[{"\[ScriptCapitalA]", "[", "]"}], "\[Wedge]", 
      RowBox[{"\[ScriptCapitalA]", "[", "]"}], "\[Wedge]", 
      RowBox[{"\[ScriptCapitalA]", "[", "]"}]}]}], "+", 
    RowBox[{
     RowBox[{"1", "/", "10"}], 
     RowBox[{
      RowBox[{"\[ScriptCapitalA]", "[", "]"}], "\[Wedge]", 
      RowBox[{"\[ScriptCapitalA]", "[", "]"}], "\[Wedge]", 
      RowBox[{"\[ScriptCapitalA]", "[", "]"}], "\[Wedge]", 
      RowBox[{"\[ScriptCapitalA]", "[", "]"}], "\[Wedge]", 
      RowBox[{"\[ScriptCapitalA]", "[", "]"}]}]}]}], "]"}]}]], "Input",
 CellLabel->
  "In[170]:=",ExpressionUUID->"e0032996-034b-4527-b664-6396f8312649"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{"Tr", "[", 
     RowBox[{
      InterpretationBox[
       StyleBox["\[ScriptCapitalF]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[ScriptCapitalF][],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox["\[ScriptCapitalF]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[ScriptCapitalF][],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox["\[ScriptCapitalA]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[ScriptCapitalA][],
       Editable->False]}], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TR[
    Wedge[
     $CellContext`\[ScriptCapitalF][], 
     $CellContext`\[ScriptCapitalF][], 
     $CellContext`\[ScriptCapitalA][]]],
   Editable->False], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"Tr", "[", 
      RowBox[{
       InterpretationBox[
        StyleBox["\[ScriptCapitalF]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalF][],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False]}], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TR[
     Wedge[
      $CellContext`\[ScriptCapitalF][], 
      $CellContext`\[ScriptCapitalA][], 
      $CellContext`\[ScriptCapitalA][], 
      $CellContext`\[ScriptCapitalA][]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"Tr", "[", 
      RowBox[{
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox["\[ScriptCapitalA]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[ScriptCapitalA][],
        Editable->False]}], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TR[
     Wedge[
      $CellContext`\[ScriptCapitalA][], 
      $CellContext`\[ScriptCapitalA][], 
      $CellContext`\[ScriptCapitalA][], 
      $CellContext`\[ScriptCapitalA][], 
      $CellContext`\[ScriptCapitalA][]]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[170]=",ExpressionUUID->"199c4a06-95f0-4e9d-b6b5-4dd1eab0fc08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", "expandtrace"}]], "Input",
 CellLabel->
  "In[171]:=",ExpressionUUID->"a9fe9fd3-408d-4721-8716-1da87ddc8b14"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H5", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H5, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H4"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H4],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H4", " "},
           {" ", "H5"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`H5],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H8", " "},
            {" ", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H8, -$CellContext`A],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"A", " "},
            {" ", "H6"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H6],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H6", " "},
            {" ", "H7"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H6, -$CellContext`H7],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H7", " "},
            {" ", "H8"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H7, -$CellContext`H8],
     Editable->False]}]}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H12", " "},
            {" ", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"A", " "},
            {" ", "H9"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H9],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H9", " "},
            {" ", "H10"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H9, -$CellContext`H10],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H10", " "},
            {" ", "H11"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H11", " "},
            {" ", "H12"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
     Editable->False]}]}]}]], "Output",
 CellLabel->"Out[171]=",ExpressionUUID->"c49af8ce-bb29-414e-ac6f-4279bddcf9c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->
  "In[172]:=",ExpressionUUID->"bd45531f-5032-42f1-99ea-1dc84dfe8a5a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H10"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H10", " "},
           {" ", "H11"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H11", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"A", " "},
            {" ", "H10"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H10", " "},
            {" ", "H11"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H11", " "},
            {" ", "H12"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H12", " "},
            {" ", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
     Editable->False]}]}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"A", " "},
            {" ", "H10"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H10", " "},
            {" ", "H11"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H11", " "},
            {" ", "H12"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H12", " "},
            {" ", "H4"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
     Editable->False], "\[Wedge]", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
         StyleBox[GridBox[{
            {"H4", " "},
            {" ", "A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
     Editable->False]}]}]}]], "Output",
 CellLabel->"Out[172]=",ExpressionUUID->"137b6abf-9f9e-485a-92b5-62fdf660653a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "@", "%"}]], "Input",
 CellLabel->
  "In[173]:=",ExpressionUUID->"84d20fcd-452b-4b72-ab6d-f1bdb6529752"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H10", " "},
           {" ", "H11"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H11", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H10"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11], xAct`xTensor`PD],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H11", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H10"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H10", " "},
           {" ", "H11"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A], xAct`xTensor`PD],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          RowBox[{"d", "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {
                RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
                StyleBox[GridBox[{
                   {"A", " "},
                   {" ", "H10"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            
            xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
            Editable->False], "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Diff[
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10], xAct`xTensor`PD],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H10", " "},
                {" ", "H11"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H11", " "},
                {" ", "H12"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H12", " "},
                {" ", "A"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"H10", " "},
                 {" ", "H11"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"H11", " "},
                 {" ", "H12"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"H12", " "},
                 {" ", "A"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A], xAct`xTensor`PD],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"A", " "},
                 {" ", "H10"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"H10", " "},
                 {" ", "H11"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"H11", " "},
                 {" ", "H12"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"H12", " "},
                 {" ", "H4"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
              StyleBox[GridBox[{
                 {"H4", " "},
                 {" ", "A"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A], xAct`xTensor`PD],
       Editable->False]}]}], ")"}]}]}]], "Output",
 CellLabel->"Out[173]=",ExpressionUUID->"8d9f372a-8812-47a8-912e-8cdaefb34821"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UseCartan", "[", 
  RowBox[{"%", ",", "cdv"}], "]"}]], "Input",
 CellLabel->
  "In[174]:=",ExpressionUUID->"d7c59b3d-bf4d-4c7e-bea1-a89258db607f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H10"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H10", " "},
           {" ", "H11"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H11", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "H10"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`H10],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H10", " "},
           {" ", "H11"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H11", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H10"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "H11"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`H11],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H10", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H11", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H10"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "H11"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`H11],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H10", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`B],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H11", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H10"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H10", " "},
           {" ", "H11"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H11", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`B],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"A", " "},
           {" ", "H10"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H10", " "},
           {" ", "H11"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"B", " "},
           {" ", "A"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`A],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
        StyleBox[GridBox[{
           {"H11", " "},
           {" ", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`B],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"A", " "},
                {" ", "H10"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H10", " "},
                {" ", "H11"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H11", " "},
                {" ", "H12"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
         Editable->False], "\[Wedge]", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
             StyleBox[GridBox[{
                {"H12", " "},
                {" ", "A"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"B", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -C],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -D],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       D, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H, -$CellContext`A],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H, -$CellContext`A],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "B"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`B],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"B", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`B, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "C"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -C],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"C", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       C, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "D"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -D],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"D", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, $CellContext`VB][
       D, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`A],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"A", " "},
              {" ", "H10"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H10", " "},
              {" ", "H11"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H11", " "},
              {" ", "H12"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`H12],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H12", " "},
              {" ", "H4"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H12, -$CellContext`H4],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H4", " "},
              {" ", "H1"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H4, -$CellContext`H1],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"A", "[", "\[ScriptCapitalD]", "]"}], 
           StyleBox[GridBox[{
              {"H1", " "},
              {" ", "A"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`ConnectionForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H1, -$CellContext`A],
       Editable->False]}]}], ")"}]}]}]], "Output",
 CellLabel->"Out[174]=",ExpressionUUID->"99e543b0-1911-4e89-bc3d-e27a960f9511"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellLabel->
  "In[175]:=",ExpressionUUID->"df2a8e66-0564-4014-9ff2-1bc2e7cc87c0"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
       StyleBox[GridBox[{
          {"A", " "},
          {" ", "H10"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`A, -$CellContext`H10],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
       StyleBox[GridBox[{
          {"H10", " "},
          {" ", "H11"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H10, -$CellContext`H11],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"F", "[", "\[ScriptCapitalD]", "]"}], 
       StyleBox[GridBox[{
          {"H11", " "},
          {" ", "A"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`CurvatureForm[$CellContext`cdv, \
$CellContext`VB][$CellContext`H11, -$CellContext`A],
   Editable->False]}]], "Output",
 CellLabel->"Out[175]=",ExpressionUUID->"4c7f1f1d-3c83-4722-a997-683758765276"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["4. Hodge dual and co-differential", \
"SubsectionIcon",ExpressionUUID->"c5141992-deb8-447c-bda6-1360157278aa"],

Cell[TextData[{
 StyleBox["Hodge\t\t\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Hodge dual", "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["\n", "SubsubsectionIcon",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["ExpandHodgeDual\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Computation of the Hodge dual of the exterior powers of the \
canonical 1-form \n", "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["Codiff\t\t\t\t        ", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Co-differential", "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["\n", "SubsubsectionIcon",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],
 StyleBox["CodiffToDiff\t\t\t\t", "Input",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Expansion of the co-differential in terms of the exterior \
derivative", "MathCaption",
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}], "FramedBox",
 FontFamily->"Arial",ExpressionUUID->"c89315c9-1642-4d3f-8840-bb73c46c43fe"],

Cell["\<\
The Hodge dual requires the existence of a metric by definition. Once a \
metric is defined in the session, we can compute the Hodge dual of any \
differential form as follows \
\>", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"339f6734-042d-4785-b599-4b8561233a1c"],

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"metricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CV", ",", 
   RowBox[{"Torsion", "\[Rule]", "True"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}]], "Input",
 CellLabel->
  "In[176]:=",ExpressionUUID->"b711bc05-5e71-472b-8576-2458805a740a"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"A0", "[", "]"}], ",", "M", ",", "0", ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(A\), \(0\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->
  "In[177]:=",ExpressionUUID->"4b6379c7-53bb-472f-86b3-f519b25ea5c5"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"A1", "[", "]"}], ",", "M", ",", "1", ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(A\), \(1\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->
  "In[178]:=",ExpressionUUID->"aa99059a-e705-4697-a42f-7a56670388ba"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"A2", "[", "]"}], ",", "M", ",", "2", ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(A\), \(2\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->
  "In[179]:=",ExpressionUUID->"5b007911-404d-47c6-8465-3615e5f10163"],

Cell[BoxData[
 RowBox[{"DefDiffForm", "[", 
  RowBox[{
   RowBox[{"A3", "[", "]"}], ",", "M", ",", "3", ",", 
   RowBox[{
   "PrintAs", "->", "\"\<\!\(\*SuperscriptBox[\(A\), \(3\)]\)\>\""}]}], 
  "]"}]], "Input",
 CellLabel->
  "In[180]:=",ExpressionUUID->"79be0b42-5b4a-4855-a605-a2f1c59e0b5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "[", 
  RowBox[{"A2", "[", "]"}], "]"}]], "Input",
 CellLabel->
  "In[181]:=",ExpressionUUID->"ab64e2ec-b91a-423f-8cbb-0915d269134a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["*", "g"], "[", 
    InterpretationBox[
     StyleBox[
      SuperscriptBox["A", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`A2[],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Hodge[$CellContext`metricg][
   $CellContext`A2[]],
  Editable->False]], "Output",
 CellLabel->"Out[181]=",ExpressionUUID->"bc3701e4-4698-40bc-b203-03a1d521c4ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"A0", "[", "]"}], 
    RowBox[{
     RowBox[{"A1", "[", "]"}], "\[Wedge]", 
     RowBox[{"A2", "[", "]"}]}]}], "+", 
   RowBox[{
    RowBox[{"A1", "[", "]"}], "\[Wedge]", 
    RowBox[{"A1", "[", "]"}], "\[Wedge]", 
    RowBox[{"A1", "[", "]"}]}]}], "]"}]], "Input",
 CellLabel->
  "In[182]:=",ExpressionUUID->"65539a15-9803-4dd3-bbae-ca99776d10c8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "0"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A0[],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["*", "g"], "[", 
      RowBox[{
       InterpretationBox[
        StyleBox[
         SuperscriptBox["A", "1"],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`A1[],
        Editable->False], "\[Wedge]", 
       InterpretationBox[
        StyleBox[
         SuperscriptBox["A", "2"],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`A2[],
        Editable->False]}], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Hodge[$CellContext`metricg][
     Wedge[
      $CellContext`A1[], 
      $CellContext`A2[]]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["*", "g"], "[", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "1"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A1[],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "1"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A1[],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "1"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A1[],
       Editable->False]}], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Hodge[$CellContext`metricg][
    Wedge[
     $CellContext`A1[], 
     $CellContext`A1[], 
     $CellContext`A1[]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[182]=",ExpressionUUID->"350be855-c55e-405c-a63c-9bfd3737de90"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ToCanonical"}]], "Input",
 CellLabel->
  "In[183]:=",ExpressionUUID->"86637c9a-8c7f-4a37-aab6-bc390a166ef6"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "0"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A0[],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["*", "g"], "[", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "1"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A1[],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "2"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A2[],
       Editable->False]}], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Hodge[$CellContext`metricg][
    Wedge[
     $CellContext`A1[], 
     $CellContext`A2[]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[183]=",ExpressionUUID->"efa564f6-d8f5-42d2-9b73-3c0566d741b8"]
}, Open  ]],

Cell[TextData[{
 "Hodge duals of expressions involving the exterior product of canonical \
1-forms can be worked out with ",
 StyleBox["ExpandHodgeDual", "DisplayMath"],
 ". To illustrate this we need to give a value to the symbolic dimension and \
to the metric signature:"
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"4302834b-1ee1-4c32-8a15-ed4dcaa818e8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dim", "=", "4"}], ";"}]], "Input",
 CellLabel->
  "In[184]:=",ExpressionUUID->"d5392f95-79c0-485c-bc75-0d3cb2a94ee6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SignatureOfMetric", "[", "metricg", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}]}], ";"}]], "Input",
 CellLabel->
  "In[185]:=",ExpressionUUID->"0845398a-195a-4ae4-a578-6b61ae11bc28"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "@", "epsilonmetricg"}], "^=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "TangentM"}], ",", 
     RowBox[{"-", "TangentM"}], ",", 
     RowBox[{"-", "TangentM"}], ",", 
     RowBox[{"-", "TangentM"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->
  "In[186]:=",ExpressionUUID->"dcdc9850-6598-4aeb-8404-d45a537a731c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "@", 
    RowBox[{"epsilonmetricg", "[", 
     RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}]}], "^=", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "Cycles"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[187]:=",ExpressionUUID->"e68ca78d-2121-42d3-b867-e6ea60979477"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Coframe", "[", "M", "]"}], "[", "a", "]"}], "\[Wedge]", 
  RowBox[{
   RowBox[{"Coframe", "[", "M", "]"}], "[", "b", "]"}], "\[Wedge]", 
  RowBox[{
   RowBox[{"Coframe", "[", "M", "]"}], "[", "c", "]"}]}]], "Input",
 CellLabel->
  "In[188]:=",ExpressionUUID->"ae6c1985-7e4a-41e7-89ba-885f98cdc43c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Theta]", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Theta]", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Theta]", 
       StyleBox[GridBox[{
          {"c"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
   Editable->False]}]], "Output",
 CellLabel->"Out[188]=",ExpressionUUID->"cdf3e2bd-bd17-482b-85d3-63d8d6610773"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "@", "%"}]], "Input",
 CellLabel->
  "In[189]:=",ExpressionUUID->"64a61902-6b55-498e-b50a-8d3bbe5a733a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["*", "g"], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"c"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
      Editable->False]}], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Hodge[$CellContext`metricg][
   Wedge[
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], 
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], 
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c]]],
  Editable->False]], "Output",
 CellLabel->"Out[189]=",ExpressionUUID->"53506618-a684-46d1-84d8-cfb56296b7f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandHodgeDual", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Coframe", "[", "M", "]"}], ",", "metricg"}], "]"}]], "Input",
 CellLabel->
  "In[190]:=",ExpressionUUID->"3a4fb37d-f575-42fa-8a1e-26a1e48abc19"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Epsilon]g", 
       StyleBox[GridBox[{
          {"a", "b", "c", " "},
          {" ", " ", " ", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`epsilonmetricg[$CellContext`a, $CellContext`b, \
$CellContext`c, -$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Theta]", 
       StyleBox[GridBox[{
          {"d"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Coframe[$CellContext`M][$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[190]=",ExpressionUUID->"c8aadae8-44d8-46c3-992c-87ef88d40137"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Coframe", "[", "M", "]"}], "[", "a", "]"}], "\[Wedge]", 
  RowBox[{
   RowBox[{"Coframe", "[", "M", "]"}], "[", "b", "]"}], "\[Wedge]", 
  RowBox[{
   RowBox[{"Coframe", "[", "M", "]"}], "[", "c", "]"}], "\[Wedge]", 
  RowBox[{
   RowBox[{"Coframe", "[", "M", "]"}], "[", "d", "]"}]}]], "Input",
 CellLabel->
  "In[191]:=",ExpressionUUID->"d7b6d53f-07a8-4274-844b-15a9704c6d51"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Theta]", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Theta]", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Theta]", 
       StyleBox[GridBox[{
          {"c"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
   Editable->False], "\[Wedge]", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Theta]", 
       StyleBox[GridBox[{
          {"d"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Coframe[$CellContext`M][$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[191]=",ExpressionUUID->"642c76c3-1f16-4509-a666-f7071fed899f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "@", "%"}]], "Input",
 CellLabel->
  "In[192]:=",ExpressionUUID->"ccca6ac8-931e-46d7-adbf-f901e814721e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["*", "g"], "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"c"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`c],
      Editable->False], "\[Wedge]", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Theta]", 
          StyleBox[GridBox[{
             {"d"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Coframe[$CellContext`M][$CellContext`d],
      Editable->False]}], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Hodge[$CellContext`metricg][
   Wedge[
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], 
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b], 
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`c], 
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`d]]],
  Editable->False]], "Output",
 CellLabel->"Out[192]=",ExpressionUUID->"623840e1-2a3d-484d-98bc-c5c6343f23e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandHodgeDual", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Coframe", "[", "M", "]"}], ",", "metricg"}], "]"}]], "Input",
 CellLabel->
  "In[193]:=",ExpressionUUID->"e27c6948-6c26-44a2-b8ee-f98a46ccb509"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[Epsilon]g", 
      StyleBox[GridBox[{
         {"a", "b", "c", "d"},
         {" ", " ", " ", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`epsilonmetricg[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
  Editable->False]], "Output",
 CellLabel->"Out[193]=",ExpressionUUID->"54aa255e-a92b-4a10-81d8-a08cf704dbfe"]
}, Open  ]],

Cell["Hodge double dual", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"28017bb6-a4f3-48d2-add8-1e04881cba56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "[", 
  RowBox[{"A2", "[", "]"}], "]"}]], "Input",
 CellLabel->
  "In[194]:=",ExpressionUUID->"06b14e3f-fe47-42d3-9015-5e951f2303e0"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["*", "g"], "[", 
    InterpretationBox[
     StyleBox[
      SuperscriptBox["A", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`A2[],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Hodge[$CellContext`metricg][
   $CellContext`A2[]],
  Editable->False]], "Output",
 CellLabel->"Out[194]=",ExpressionUUID->"e0e232ce-8545-4cfb-b214-ddeb44d39243"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "@", "%"}]], "Input",
 CellLabel->
  "In[195]:=",ExpressionUUID->"9487469f-c955-41ba-90ee-96c58d6862fc"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "2"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A2[],
   Editable->False]}]], "Output",
 CellLabel->"Out[195]=",ExpressionUUID->"97a8440b-3f51-4ecc-8dae-5afeba9680fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "[", 
  RowBox[{
   RowBox[{"A0", "[", "]"}], 
   RowBox[{
    RowBox[{"A1", "[", "]"}], "\[Wedge]", 
    RowBox[{"A2", "[", "]"}]}]}], "]"}]], "Input",
 CellLabel->
  "In[196]:=",ExpressionUUID->"d663baa2-848d-49b2-91da-e466ef2e6e6b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "0"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A0[],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["*", "g"], "[", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "1"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A1[],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[
        SuperscriptBox["A", "2"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`A2[],
       Editable->False]}], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Hodge[$CellContext`metricg][
    Wedge[
     $CellContext`A1[], 
     $CellContext`A2[]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[196]=",ExpressionUUID->"92483f20-5dc5-46c2-9200-2cb81cef57c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "[", "metricg", "]"}], "@", "%"}]], "Input",
 CellLabel->
  "In[197]:=",ExpressionUUID->"9e6d1853-4577-4feb-9e09-aa2ff9812e84"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SuperscriptBox["A", "0"],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`A0[],
   Editable->False], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "1"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A1[],
    Editable->False], "\[Wedge]", 
   InterpretationBox[
    StyleBox[
     SuperscriptBox["A", "2"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`A2[],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[197]=",ExpressionUUID->"e3438f31-63d9-478f-8bc8-4badbf68f19f"]
}, Open  ]],

Cell["The co-differential", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"6959a4f9-8a8a-4669-a8fd-6c5fc7708856"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Codiff", "[", "metricg", "]"}], "[", 
  RowBox[{"A2", "[", "]"}], "]"}]], "Input",
 CellLabel->
  "In[198]:=",ExpressionUUID->"789fec92-cebb-4759-b7e1-ea12637ccc9c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[Delta]", "g"], "[", 
    InterpretationBox[
     StyleBox[
      SuperscriptBox["A", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`A2[],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Codiff[$CellContext`metricg][
   $CellContext`A2[], xAct`xTensor`PD],
  Editable->False]], "Output",
 CellLabel->"Out[198]=",ExpressionUUID->"7f31f838-454f-4ce0-9635-1307df096252"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->
  "In[199]:=",ExpressionUUID->"d870f3a4-4b23-4660-922c-540cb5ce2575"],

Cell["Codiff[metricg][A2[], PD]", "Output",
 CellLabel->
  "Out[199]//InputForm=",ExpressionUUID->"66a3aec8-887d-4e05-9e43-\
6f1be56fb7c5"]
}, Open  ]],

Cell[TextData[{
 "The co-differential can be expressed in terms of the exterior derivative by \
using ",
 StyleBox["CodiffToDiff", "DisplayMath"]
}], "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"b1088cea-1fef-43c6-a1ed-3f4dc2e611d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CodiffToDiff", "@", "%"}]], "Input",
 CellLabel->
  "In[200]:=",ExpressionUUID->"13d1510e-54a1-4f63-8327-746ed36fed97"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["*", "g"], "[", 
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["*", "g"], "[", 
           InterpretationBox[
            StyleBox[
             SuperscriptBox["A", "2"],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`A2[],
            Editable->False], "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Hodge[$CellContext`metricg][
          $CellContext`A2[]],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`Hodge[$CellContext`metricg][
        $CellContext`A2[]], xAct`xTensor`PD],
      Editable->False], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Hodge[$CellContext`metricg][
    xAct`xTerior`Diff[
     xAct`xTerior`Hodge[$CellContext`metricg][
      $CellContext`A2[]], xAct`xTensor`PD]],
   Editable->False]}]], "Output",
 CellLabel->"Out[200]=",ExpressionUUID->"c6f048d3-6c31-4ead-b250-8f62bff1506c"]
}, Open  ]],

Cell["\<\
To illustrate how this works, let us compute the co-differential of the \
holonomic co-frame.\
\>", "MathCaption",
 TextJustification->1.,
 FontFamily->"Arial",ExpressionUUID->"657b8b1a-58ff-467d-9468-d9affeee32c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Codiff", "[", "metricg", "]"}], "[", 
  RowBox[{
   RowBox[{"dx", "[", "M", "]"}], "[", "a", "]"}], "]"}]], "Input",
 CellLabel->
  "In[201]:=",ExpressionUUID->"e10c18f4-794c-4bff-86e0-4c252801cd13"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[Delta]", "g"], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"dx", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`dx[$CellContext`M][$CellContext`a],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Codiff[$CellContext`metricg][
   xAct`xTerior`dx[$CellContext`M][$CellContext`a], xAct`xTensor`PD],
  Editable->False]], "Output",
 CellLabel->"Out[201]=",ExpressionUUID->"8d1e43bc-5c3b-42e5-9a20-dafec11519bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "CodiffToDiff"}]], "Input",
 CellLabel->
  "In[202]:=",ExpressionUUID->"f8e540c7-8bba-46e5-ad51-3132b68581d8"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["*", "g"], "[", 
     InterpretationBox[
      StyleBox[
       RowBox[{"d", "[", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["*", "g"], "[", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"dx", 
                StyleBox[GridBox[{
                   {"a"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            xAct`xTerior`dx[$CellContext`M][$CellContext`a],
            Editable->False], "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Hodge[$CellContext`metricg][
          xAct`xTerior`dx[$CellContext`M][$CellContext`a]],
         Editable->False], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Diff[
       xAct`xTerior`Hodge[$CellContext`metricg][
        xAct`xTerior`dx[$CellContext`M][$CellContext`a]], xAct`xTensor`PD],
      Editable->False], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Hodge[$CellContext`metricg][
    xAct`xTerior`Diff[
     xAct`xTerior`Hodge[$CellContext`metricg][
      xAct`xTerior`dx[$CellContext`M][$CellContext`a]], xAct`xTensor`PD]],
   Editable->False]}]], "Output",
 CellLabel->"Out[202]=",ExpressionUUID->"24edb6df-cb74-4afc-a811-1b409f151914"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandHodgeDual", "[", 
  RowBox[{"%", ",", 
   RowBox[{"dx", "[", "M", "]"}], ",", "metricg"}], "]"}]], "Input",
 CellLabel->
  "In[203]:=",ExpressionUUID->"cd4081e3-243a-46fc-a1f9-e501d5290308"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "6"]}], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["*", "g"], "[", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        RowBox[{"d", "[", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Epsilon]g", 
              StyleBox[GridBox[{
                 {"a", " ", " ", " "},
                 {" ", "b", "c", "d"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`epsilonmetricg[$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
          Editable->False], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`Diff[
        $CellContext`epsilonmetricg[$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], xAct`xTensor`PD],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"dx", 
           StyleBox[GridBox[{
              {"b"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`dx[$CellContext`M][$CellContext`b],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"dx", 
           StyleBox[GridBox[{
              {"c"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`dx[$CellContext`M][$CellContext`c],
       Editable->False], "\[Wedge]", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"dx", 
           StyleBox[GridBox[{
              {"d"},
              {" "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTerior`dx[$CellContext`M][$CellContext`d],
       Editable->False]}], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTerior`Hodge[$CellContext`metricg][
    Wedge[
     xAct`xTerior`Diff[
      $CellContext`epsilonmetricg[$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], xAct`xTensor`PD], 
     xAct`xTerior`dx[$CellContext`M][$CellContext`b], 
     xAct`xTerior`dx[$CellContext`M][$CellContext`c], 
     xAct`xTerior`dx[$CellContext`M][$CellContext`d]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[203]=",ExpressionUUID->"65c80a62-7a15-4685-9794-26da552c542e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateMetric", "[", "]"}], "@", "%"}]], "Input",
 CellLabel->
  "In[204]:=",ExpressionUUID->"6b17be95-05a7-4b24-a676-e7b5f63c6c88"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"g", 
           StyleBox[GridBox[{
              {"a", "e"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`metricg[$CellContext`a, $CellContext`e],
       Editable->False]}], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["*", "g"], "[", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"d", "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"\[Epsilon]g", 
                 StyleBox[GridBox[{
                    {" ", " ", " ", " "},
                    {"e", "b", "c", "d"}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`epsilonmetricg[-$CellContext`e, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
             Editable->False], "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`Diff[
           $CellContext`epsilonmetricg[-$CellContext`e, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], xAct`xTensor`PD],
          Editable->False], "\[Wedge]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"dx", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`dx[$CellContext`M][$CellContext`b],
          Editable->False], "\[Wedge]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"dx", 
              StyleBox[GridBox[{
                 {"c"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`dx[$CellContext`M][$CellContext`c],
          Editable->False], "\[Wedge]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"dx", 
              StyleBox[GridBox[{
                 {"d"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`dx[$CellContext`M][$CellContext`d],
          Editable->False]}], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Hodge[$CellContext`metricg][
       Wedge[
        xAct`xTerior`Diff[
         $CellContext`epsilonmetricg[-$CellContext`e, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], xAct`xTensor`PD], 
        xAct`xTerior`dx[$CellContext`M][$CellContext`b], 
        xAct`xTerior`dx[$CellContext`M][$CellContext`c], 
        xAct`xTerior`dx[$CellContext`M][$CellContext`d]]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]g", 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"e", "b", "c", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`epsilonmetricg[-$CellContext`e, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["*", "g"], "[", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"d", "[", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"g", 
                 StyleBox[GridBox[{
                    {"a", "e"},
                    {" ", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             $CellContext`metricg[$CellContext`a, $CellContext`e],
             Editable->False], "]"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`Diff[
           $CellContext`metricg[$CellContext`a, $CellContext`e], 
           xAct`xTensor`PD],
          Editable->False], "\[Wedge]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"dx", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`dx[$CellContext`M][$CellContext`b],
          Editable->False], "\[Wedge]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"dx", 
              StyleBox[GridBox[{
                 {"c"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`dx[$CellContext`M][$CellContext`c],
          Editable->False], "\[Wedge]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"dx", 
              StyleBox[GridBox[{
                 {"d"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`dx[$CellContext`M][$CellContext`d],
          Editable->False]}], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Hodge[$CellContext`metricg][
       Wedge[
        xAct`xTerior`Diff[
         $CellContext`metricg[$CellContext`a, $CellContext`e], 
         xAct`xTensor`PD], 
        xAct`xTerior`dx[$CellContext`M][$CellContext`b], 
        xAct`xTerior`dx[$CellContext`M][$CellContext`c], 
        xAct`xTerior`dx[$CellContext`M][$CellContext`d]]],
      Editable->False]}]}], ")"}]}]], "Output",
 CellLabel->"Out[204]=",ExpressionUUID->"aa39f168-02b3-446b-905d-9c3594a1117b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UseCartan", "[", 
  RowBox[{"%", ",", "CV"}], "]"}]], "Input",
 CellLabel->
  "In[205]:=",ExpressionUUID->"fe2d6fa3-f043-462e-aa43-54a1e655ed5b"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]g", 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {"e", "b", "c", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`epsilonmetricg[-$CellContext`e, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
       Editable->False]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["*", "g"], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {
                 RowBox[{
                 "\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
                 StyleBox[GridBox[{
                    {"a", "e"},
                    {" ", " "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             
             xAct`xTerior`ChristoffelForm[$CellContext`CV][$CellContext`a, \
$CellContext`e],
             Editable->False], "\[Wedge]", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"dx", 
                 StyleBox[GridBox[{
                    {"b"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTerior`dx[$CellContext`M][$CellContext`b],
             Editable->False], "\[Wedge]", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"dx", 
                 StyleBox[GridBox[{
                    {"c"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTerior`dx[$CellContext`M][$CellContext`c],
             Editable->False], "\[Wedge]", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"dx", 
                 StyleBox[GridBox[{
                    {"d"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTerior`dx[$CellContext`M][$CellContext`d],
             Editable->False]}], "]"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`xTerior`Hodge[$CellContext`metricg][
          Wedge[
           
           xAct`xTerior`ChristoffelForm[$CellContext`CV][$CellContext`a, \
$CellContext`e], 
           xAct`xTerior`dx[$CellContext`M][$CellContext`b], 
           xAct`xTerior`dx[$CellContext`M][$CellContext`c], 
           xAct`xTerior`dx[$CellContext`M][$CellContext`d]]],
         Editable->False]}], "-", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["*", "g"], "[", 
          RowBox[{
           InterpretationBox[
            StyleBox[GridBox[{
               {
                RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
                StyleBox[GridBox[{
                   {"e", "a"},
                   {" ", " "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            
            xAct`xTerior`ChristoffelForm[$CellContext`CV][$CellContext`e, \
$CellContext`a],
            Editable->False], "\[Wedge]", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"dx", 
                StyleBox[GridBox[{
                   {"b"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            xAct`xTerior`dx[$CellContext`M][$CellContext`b],
            Editable->False], "\[Wedge]", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"dx", 
                StyleBox[GridBox[{
                   {"c"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            xAct`xTerior`dx[$CellContext`M][$CellContext`c],
            Editable->False], "\[Wedge]", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"dx", 
                StyleBox[GridBox[{
                   {"d"},
                   {" "}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            xAct`xTerior`dx[$CellContext`M][$CellContext`d],
            Editable->False]}], "]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`xTerior`Hodge[$CellContext`metricg][
         Wedge[
          
          xAct`xTerior`ChristoffelForm[$CellContext`CV][$CellContext`e, \
$CellContext`a], 
          xAct`xTerior`dx[$CellContext`M][$CellContext`b], 
          xAct`xTerior`dx[$CellContext`M][$CellContext`c], 
          xAct`xTerior`dx[$CellContext`M][$CellContext`d]]],
        Editable->False]}], ")"}]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Epsilon]g", 
          StyleBox[GridBox[{
             {" ", " ", " ", " "},
             {"e", "b", "c", "d"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`epsilonmetricg[-$CellContext`e, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "e"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`metricg[$CellContext`a, $CellContext`e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["*", "g"], "[", 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
              StyleBox[GridBox[{
                 {"f", " "},
                 {" ", "f"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          
          xAct`xTerior`ChristoffelForm[$CellContext`CV][$CellContext`f, \
-$CellContext`f],
          Editable->False], "\[Wedge]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"dx", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`dx[$CellContext`M][$CellContext`b],
          Editable->False], "\[Wedge]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"dx", 
              StyleBox[GridBox[{
                 {"c"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`dx[$CellContext`M][$CellContext`c],
          Editable->False], "\[Wedge]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"dx", 
              StyleBox[GridBox[{
                 {"d"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`dx[$CellContext`M][$CellContext`d],
          Editable->False]}], "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTerior`Hodge[$CellContext`metricg][
       Wedge[
        xAct`xTerior`ChristoffelForm[$CellContext`CV][$CellContext`f, \
-$CellContext`f], 
        xAct`xTerior`dx[$CellContext`M][$CellContext`b], 
        xAct`xTerior`dx[$CellContext`M][$CellContext`c], 
        xAct`xTerior`dx[$CellContext`M][$CellContext`d]]],
      Editable->False]}]}], ")"}]}]], "Output",
 CellLabel->"Out[205]=",ExpressionUUID->"981d789f-e8d7-4872-8954-82b764155c79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConnectionFormToTensor", "[", 
  RowBox[{"%", ",", "PD", ",", "dx"}], "]"}]], "Input",
 CellLabel->
  "In[206]:=",ExpressionUUID->"62f96fc3-c3e5-45fa-acb0-e02997b7a02a"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Epsilon]g", 
           StyleBox[GridBox[{
              {" ", " ", " ", " "},
              {"e", "b", "c", "d"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`epsilonmetricg[-$CellContext`e, -$CellContext`b, \
-$CellContext`c, -$CellContext`d],
       Editable->False]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", "\[EmptyDownTriangle]", "]"}], 
              StyleBox[GridBox[{
                 {"a", " ", "e"},
                 {" ", "g", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->9]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCV[$CellContext`a, -$CellContext`g, \
$CellContext`e],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["*", "g"], "[", 
           RowBox[{
            InterpretationBox[
             StyleBox[GridBox[{
                {"dx", 
                 StyleBox[GridBox[{
                    {"g"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTerior`dx[$CellContext`M][$CellContext`g],
             Editable->False], "\[Wedge]", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"dx", 
                 StyleBox[GridBox[{
                    {"b"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTerior`dx[$CellContext`M][$CellContext`b],
             Editable->False], "\[Wedge]", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"dx", 
                 StyleBox[GridBox[{
                    {"c"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.27999999999999997`]}, "Rows" -> {
                   Offset[0.2], {
                    Offset[0.4]}, 
                   Offset[0.2]}}],
              ShowAutoStyles->False,
              AutoSpacing->False],
             xAct`xTerior`dx[$CellContext`M][$CellContext`c],
             Editable->False], "\[Wedge]", 
            InterpretationBox[
             StyleBox[GridBox[{
                {"dx", 
                 StyleBox[GridBox[{
                    {"d"},
                    {" "}
                   },
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                  FontSize->9]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.27999999999999997`], {
         