(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2977599,      70832]
NotebookOptionsPosition[   2944805,      69855]
NotebookOutlinePosition[   2947605,      69925]
CellTagsIndexPosition[   2947331,      69917]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 TogglerBox[2, {1->
  OverlayBox[{
   TagBox[GridBox[{
      {
       GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEFxAJADBL8//8/
Qfzo0SP2GzduCF29elXs/Pnz0sgYn747d+5wA9VoArE/EB8B4uPoGJu+Fy9e
MF+4cEENKB8AxBeB+AMQ/wXif+gYi1tBdvoB8QUg/ghV9x8XRtb7/PlzFqje
t1D7cOrDpv/ixYvqUHuJ0ousHxpWAVA3E6UXWT80nC8S8i82/Q8ePOAgx26Y
/uvXrwsD2UdJ8Tey/kuXLolD0wNJbofpB6YVSUr0n4ek5QHTT6n7KQ0/SuOP
0vRDafqlRv6BxgPZ+Ret/HhHrBl4yi9QWHwiFB7Yyk+QO6B+CTxPYvmJjG/f
vs17nozyG1f9cR6t7gBhAPeiQ4A=
         "], {{0, 26}, {16, 0}}, {0, 255},
         ColorFunction->RGBColor],
        BaseStyle->"ImageGraphics",
        ImageSize->Magnification[1],
        ImageSizeRaw->{16, 26},
        PlotRange->{{0, 16}, {0, 26}}], 
       GraphicsBox[RasterBox[CompressedData["
1:eJzt2d9OVFcUB2DSNmkfQRFEiRQ1gCK1vW4fwT6BJu1tE9uk8fUUERE9aECC
qLGYEmKkErWxtont2mGdcDLVOpNgZijfJB9hzp+99j6zb9b5Hb3ww7nvP+rr
6/vxs/hz7vzPX1+8eP7St5/El28u/fTdhY/jn/6w8GlfXzlYVdWhDgyEwXT4
HQYbBho6qQMAAOxt/Q0HWxxo0TzX3xij7juGwpFwNAyHY2EkfB6OhxPhZBgL
42EinAqnw2SYSl+Es+HL9FWb6uvP5hj1eJNZ41TWHM85nMw5Hc85juSch3MN
R3JNdf/UfGbtPqf6WdW6/XsDAADsV7vd/7b2vqPV2/veuuc9k6Za1Mfr3vVt
feto9e+eVb9KL2tmz81M+n25dadZ9bU2zYXbYSmshNXwoOF+uJfn7obFcKfa
/twMN8L1MNtBTQAAYO+ZSVfTdLqSLreoj0/n9eXe0jeUHmQ+3AoL1XZ/UfqR
5Wq77yg9yMPwS3gcfg0b4Ul4Gn4LW+F5eBl+D6/CH+F1+DP99Q71+dd5z6sc
42WOuZU1nmbNjZzD45zTw5zjSs55KdewkGuazzXONp5Xu8+pflb185rpgd8d
AABgv/kQ/W/J4krGVvrIkruVDO5RWAvr1U7fuxmeVTt9b/Ei1d+38prNaqdv
Xc+xHuXY97LWYtbWr9Jryj4sGXPJmkvmXD7l/UrZsyWTLu9dyj4u72Ca2fVq
nivvY8renuug5ps2/b2L2q0JAADwX3azT/kQuv18AAAA2Pv0rOxn3djz3X6f
BAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAADsHW/a1I2aAAAAAAAAsJ91OyOEburGnr/W
prlwOyyFlbAaHjTcD/fy3N2wGO5U25+b4Ua4HmY7qAkAAAAAAAC9aCZdTdPp
Srrcoj4+ndeXe0tuVjK4+XCr2s7iSsa2XG3nbiWDexTWwnrYCE/CZngWtsLz
9CLV37fyms28ZyPHWMsxH2SN5ax5O+cwn3Oabayv3XXVa6vXN9MDvxN7W9mH
JWMuWXPJnMunZNBlz5ZMumTTZR+XrLqZXa/muZJtl70910HNQx0YCIPp8DsM
Ngw0dFIHAAAAAAAAel1/w8EWB1o0z/U3xqhzt6FwNAyHY2EkjIYT4WQYC+Nh
IpwOk+FMmmpRH5/Mayfy3rEc60SOPZK1hrP2ULWT9zXX2O666rXVuv378P/S
zJ6bmfT7cuuOsup/AFmW9vs=
         "], {{0, 26}, {2000, 0}}, {0, 255},
         ColorFunction->RGBColor],
        BaseStyle->"ImageGraphics",
        ImageSize->Magnification[1],
        ImageSizeRaw->{2000, 26},
        PlotRange->{{0, 2000}, {0, 26}}], 
       GraphicsBox[RasterBox[CompressedData["
1:eJy9lstOwkAUhhthQUJcuUBl5cr4GPoABvEJINGtCZoYng4Il4Z7gXAJYUHY
QAi3GlYQPZ5/4pCm0pYC2uSDaXvmn5lzzpzpVfQl/HyiKMqrj3/CkffbWCwS
f/TyzV387Snq4cYlc87gYbVaDbpB07SLRqMR6Pf7PiJSnOA+6h7kmBBz0+12
Tx30v/bgk9GZOvPAa7oejUYeC306AIz1wWjM/WAw8B9ZX4L1TDHGcDj02ulX
KpUNbt79jKHBV1b66Fcul3fCYgzEJNTr9fxmfaldKpWoUChQPp8X/8ViUWB8
BhuLMRCPGvJqmz76QWOxWFCtVqNsNku5XE6AdqfToclkImxga7cGuT/M+uw/
ms/ntF6vqdlsUjKZFKCNC/pynTZxyLbb7bNt/sHcMpkMzWYzoVev1wW4xuOx
WAdsbGIAH6ncJ7BNH/6FRjqdJl3XSV7T6VSsA76CDWxt9oSKOmLOH/RBLKEP
LVVVN/qJRGKjDxsnfSZoN3/4CPNfrVa/5n+IvtH/iDHu9/G/2T/G/JT5A41U
KiXm3Wq1xBhcx5zy0zK+Mj+Xy6XIf5n7EuQ/9sYh+Wneqy73r+3+2rX2OPh+
a31wqpHG5xbatvXtCDjW5wO1Z9UdzheXyPMRPrc6H49yvpvn/Y/fJ3/6ffUN
AyH/6w==
         "], {{0, 26}, {24, 0}}, {0, 255},
         ColorFunction->RGBColor],
        BaseStyle->"ImageGraphics",
        ImageSize->Magnification[1],
        ImageSizeRaw->{24, 26},
        PlotRange->{{0, 24}, {0, 26}}]}
     },
     AutoDelete->False,
     GridBoxItemSize->{"Columns" -> {Automatic, 
         Scaled[0.6], Automatic}},
     GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}}],
    "Grid"], 
   PaneBox[
    StyleBox[
     RowBox[{
     "Background", " ", "images", " ", "and", " ", "text", " ", "colors", " ",
       "have", " ", "been", " ", "adjusted", " ", "for", " ", "editing", " ", 
      
      RowBox[{"purposes", "."}]}],
     LineBreakWithin->False,
     FontFamily->"Helvetica",
     FontSize->12,
     FontColor->GrayLevel[0.4]],
    Alignment->Center,
    ImageSize->Scaled[0.5],
    ScrollPosition->{0., 0.}]},
   Alignment->{Center, Center}], 2->""}, "1"]], "SlideShowNavigationBar", \
"FirstSlide",
 CellMargins->{{0, 0}, {0, 0}},
 CellFrameLabelMargins->2,
 CellSize->{Automatic, 32},
 CellChangeTimes->{3.624476304390102*^9},
 TextAlignment->Center,
 CellTags->"SlideShowHeader"],

Cell["xTerior: exterior calculus in the Wolfram language", "Title",
 CellChangeTimes->{
  3.559948400406288*^9, {3.6244760935381527`*^9, 3.6244761235582743`*^9}}],

Cell[TextData[StyleBox["",
 FontWeight->"Bold"]], "Text",
 CellChangeTimes->{{3.624832289722921*^9, 3.62483231932158*^9}, {
  3.6249153260072603`*^9, 3.624915466298295*^9}, {3.627705579406288*^9, 
  3.6277055867339287`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["\<\
Exterior calculus has many applications in Mathematics & Physics: \
\>", "Section"],

Cell[CellGroupData[{

Cell["\<\
Stokes theorem (fundamental theorem of calculus in any dimension).\
\>", "Item"],

Cell["Topology: de Rham theorem.", "Item"],

Cell["Cartan structure equations.", "Item"],

Cell["Gauge theories in physics.", "Item"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Contents", "Section",
 CellChangeTimes->{{3.624476160400754*^9, 3.624476166909778*^9}}],

Cell[CellGroupData[{

Cell["1st part: differential forms in coordinates.", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["xTerior",
  FontSlant->"Italic"],
 " and its relation to ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 "."
}], "Item",
 CellChangeTimes->{{3.6221184630777617`*^9, 3.622118510921513*^9}}],

Cell["A very simple session with xTerior.", "Item",
 CellChangeTimes->{{3.62211851549629*^9, 3.622118524949894*^9}, {
  3.622118570816197*^9, 3.622118570827059*^9}, {3.6221186834471407`*^9, 
  3.6221186866799603`*^9}}],

Cell["\<\
Coordinate changes of differential forms and pull-back. Use for the \
integration of differential forms.\
\>", "Item",
 CellChangeTimes->{{3.62211851549629*^9, 3.622118524949894*^9}, 
   3.622118570816197*^9, {3.622118607711464*^9, 3.6221186541288977`*^9}, {
   3.622289112563724*^9, 3.622289156699377*^9}}],

Cell["Finding a local potential for a closed differential form.", "Item",
 CellChangeTimes->{{3.62211851549629*^9, 3.622118524949894*^9}, 
   3.622118570816197*^9, {3.622118607711464*^9, 3.6221186541258593`*^9}, {
   3.6221187173011627`*^9, 3.6221187506637583`*^9}, {3.6221188487073402`*^9, 
   3.6221188541287613`*^9}, {3.6221188951690817`*^9, 3.622118896647183*^9}, {
   3.625414582168339*^9, 3.62541458217838*^9}}],

Cell["Hodge dual and co-differential.", "Item",
 CellChangeTimes->{{3.62211851549629*^9, 3.622118524949894*^9}, 
   3.622118570816197*^9, {3.622118607711464*^9, 3.6221186541258593`*^9}, {
   3.6221187173011627`*^9, 3.6221187506637583`*^9}, {3.6221188487073402`*^9, 
   3.6221188541287613`*^9}, {3.6221188951690817`*^9, 3.622118896647183*^9}, {
   3.625414582168339*^9, 3.625414594192326*^9}}],

Cell["Divergence, curl in terms of differential forms.", "Item",
 CellChangeTimes->{{3.62211851549629*^9, 3.622118524949894*^9}, 
   3.622118570816197*^9, {3.622118607711464*^9, 3.6221186541258593`*^9}, {
   3.6221187173011627`*^9, 3.6221187506637583`*^9}, {3.6221188487073402`*^9, 
   3.6221188867170773`*^9}, {3.622285809341861*^9, 3.622285830991893*^9}, {
   3.622741278616733*^9, 3.622741282530057*^9}, {3.624476195894499*^9, 
   3.624476197707567*^9}, {3.624476375357955*^9, 3.624476385164592*^9}, {
   3.6249674142184772`*^9, 3.6249674142277813`*^9}, {3.625413625513435*^9, 
   3.62541366692008*^9}, {3.6254145753215513`*^9, 3.62541458043246*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2nd part: tensor valued differential forms. ", "Subsection"],

Cell[CellGroupData[{

Cell["Working with tensor valued forms.", "Item",
 CellChangeTimes->{{3.62211851549629*^9, 3.622118524949894*^9}, 
   3.622118570816197*^9, {3.622118607711464*^9, 3.6221186541258593`*^9}, {
   3.6221187173011627`*^9, 3.6221187506637583`*^9}, {3.6221188487073402`*^9, 
   3.6221188867170773`*^9}, {3.622285809341861*^9, 3.622285830991893*^9}, {
   3.622741278616733*^9, 3.622741282530057*^9}, {3.624476195894499*^9, 
   3.624476197707567*^9}, {3.624476375357955*^9, 3.624476385164592*^9}, {
   3.6249674142184772`*^9, 3.624967435257557*^9}}],

Cell["Cartan structure equations.", "Item",
 CellChangeTimes->{{3.62211851549629*^9, 3.622118524949894*^9}, 
   3.622118570816197*^9, {3.622118607711464*^9, 3.6221186541258593`*^9}, {
   3.6221187173011627`*^9, 3.6221187506637583`*^9}, {3.6221188487073402`*^9, 
   3.6221188867170773`*^9}, {3.622285809341861*^9, 3.622285830991893*^9}, {
   3.622741278616733*^9, 3.622741282530057*^9}, {3.624476195894499*^9, 
   3.62447623774824*^9}, 3.62491547942507*^9, {3.624967378671311*^9, 
   3.6249674115268517`*^9}}],

Cell["Example: Chern-Simons forms.", "Item",
 CellChangeTimes->{{3.62211851549629*^9, 3.622118524949894*^9}, 
   3.622118570816197*^9, {3.622118607711464*^9, 3.6221186541258593`*^9}, {
   3.6221187173011627`*^9, 3.6221187506637583`*^9}, {3.6221188487073402`*^9, 
   3.6221188867170773`*^9}, {3.622285809341861*^9, 3.622285830991893*^9}, {
   3.622741278616733*^9, 3.622741282530057*^9}, {3.624476195894499*^9, 
   3.62447623774824*^9}, 3.62491547942507*^9, {3.624967378671311*^9, 
   3.624967401671377*^9}, {3.625427266294957*^9, 3.625427266322294*^9}}],

Cell["Example: Einstein-Cartan theory.", "Item",
 CellChangeTimes->{{3.62211851549629*^9, 3.622118524949894*^9}, 
   3.622118570816197*^9, {3.622118607711464*^9, 3.6221186541258593`*^9}, {
   3.6221187173011627`*^9, 3.6221187506637583`*^9}, {3.6221188487073402`*^9, 
   3.6221188867170773`*^9}, {3.622285809341861*^9, 3.622285830991893*^9}, {
   3.622741278616733*^9, 3.622741282530057*^9}, {3.624476195894499*^9, 
   3.62447623774824*^9}, 3.62491547942507*^9, {3.624967378671311*^9, 
   3.624967401671377*^9}, {3.625427266294957*^9, 3.625427283973134*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SlideShowNavigationBar",
 CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["The xAct project", "Section",
 CellChangeTimes->{{3.624476440494431*^9, 3.624476454125167*^9}}],

Cell[CellGroupData[{

Cell["12 years of development.", "Item",
 CellChangeTimes->{{3.625436558567995*^9, 3.625436558681677*^9}}],

Cell["\<\
500+ different commands and 35000 lines of Wolfram language code.\
\>", "Item",
 CellChangeTimes->{{3.625433659367745*^9, 3.625433661996977*^9}}],

Cell[TextData[{
 "170+ scientific papers using ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 "."
}], "Item",
 CellChangeTimes->{{3.625436654162716*^9, 3.625436654173891*^9}}],

Cell["1500+ posts in the xAct forum.", "Item",
 CellChangeTimes->{{3.625436654162716*^9, 3.625436666077897*^9}, {
  3.6254372990020533`*^9, 3.625437336505309*^9}}]
}, Open  ]],

Cell[TextData[{
 "See ",
 Cell[BoxData[
  FormBox[
   ButtonBox[
    RowBox[{"www", ".", "xact", ".", "es"}],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["http://www.xact.es"], None},
    ButtonNote->"http://www.xact.es"], TraditionalForm]]]
}], "Text"],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.0004370597657053189], 
   {EdgeForm[{Thickness[0.003198864463484343], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], FaceForm[{RGBColor[1., 1., 0.], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{921.57, 1516.4832050000005`}, {
     1312.6519999999998`, 1516.4832050000005`}, {1348.109, 
     1516.4832050000005`}, {1376.6519999999998`, 1487.9402050000003`}, {
     1376.6519999999998`, 1452.4832050000005`}, {1376.6519999999998`, 
     1388.4832050000005`}, {1376.6519999999998`, 1353.0302050000003`}, {
     1348.109, 1324.4832050000005`}, {1312.6519999999998`, 
     1324.4832050000005`}, {921.57, 1324.4832050000005`}, {886.117, 
     1324.4832050000005`}, {857.57, 1353.0302050000003`}, {857.57, 
     1388.4832050000005`}, {857.57, 1452.4832050000005`}, {857.57, 
     1487.9402050000003`}, {886.117, 1516.4832050000005`}, {921.57, 
     1516.4832050000005`}}}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJxlVFtIVFEUHdLSTKcZZ3SkMtMpCUKip8g4tqViiJiKBkqsrLSiItJIsiKM
SOgj5J6w7vmIkl74I0oh4zOthBKFwTIw8UPsQSqEYS8tkPa5Z9+OOR/DsO7Z
j7XXXuekFhbvPjrHYrEE8Cf+M57cGa8Z0WDVtcSBHckcXAOhX33pLAxbRWAS
h8nAh0e33QprL36s3J/KAMMCRYjrfMMXncso38UBUd2rpQzGa15uz0zkcMYb
0+9GbHx3Kvw6bXBqOl7hhq5z7Sl2Dm2lVUkVKZRv5bBi3pVbm9OofgwHz9DO
Shfy6UQaC+dziK5dkn9kOZPfo6ge8S+O5FBky8tqyGBw/MaXS5smdVl/ozo3
4rMZlLVXL1ody6Hn3tbgtxyqb5+FHQoLfo1OOa8vh/gn0nk29XORfh4GyNJz
EPXCMUJlWUrPmXxm4v/2kR+Ozfgt1099/rOH+CAeS18TXRuQ89S7pD4fd8n8
UAKHDQUt22L9DHIPfepNc1A9H4OHJd6YvXEcClGv9blKH4PPWgbJyH/oqy73
4afzbh3uYuMe7Icqd/18psv58uS+fa0Uv4/mb9blngoYdKNOZxt1GJwqP9l2
mPwU1GX/Y7SPGdiY97Fu+O3munBsxgu9F2cq3OcvtL1DvY29BCWfTtxHL/qv
vIn4eRkgi9KqZumPSNxnJT8dH9GqsKFfm8JCv/vt5CcP9euc5S/Ux7xPxvzD
xDdBnRs62Wi/mC/8+CCOwWXk4+hQ+AT6qeOpwsY+iF+FlcH02/Oj6S00j036
sbqJ+MaTP1HvEpHvpH5BWc+dpPQysanve8FvTAvDZrzwTf+4BuJZ0BDbhRG+
a4Z+V7HfhVE05JQm7w/qGyfqTGvSb63kl0jy43OaZ4HSx+Bv3v+RWfPP5XK/
UeQ3K71PEUzycZCfLXQf0P8TbzDht+zfj/fjgEiY0P7dJ/N9NPFf7V9RgA==

      "], CompressedData["
1:eJxTTMoPSmViYGDQAWIQvadksgTLlwkOslEp1vcDpjuosjVOPfx1gsOhrxox
/drTHcRunvse/BHBP7XQdVvxhwkOjglPLygZTXd4WCWyzv39BIcXv1d+vGQ2
3UEcqP7y2wkOW0+U7ZtvOd2hH6Tx9QSHf1cqXqrZTXf4Efx4qfSLCQ4XlG7/
rHOc7rDOHWjCE6h6Zyj/wQSHR0Bzj7tOd5j7fvmx07eg7nODuM/5CoLPsUYm
6sleTD7Y/LPT4HwTY2PjzYenOQTtkGt9vW+Cg/V9/97pe6c5gP1/cIJD+b75
Uvq7ofwjExxA3n68fRpE3YkJDhkT39bYb5vmoAIKn3MIPsw96Hw+3U1z32+E
2j8Bkw9TD7KvZRqCL9/6OtBiLoLfDoqAhRMg4bwDav+SCQ4yQP/G74HqXwb1
/z6I+SnLJzjUZQFljiD4yOEB4qOE5xQE/7JvksCNHgQfFB9T2ic4PAfGb5Ab
NP5boO5zhcZvwwSHTCB/vzM0/Gug4ecwHRKeVRMcgLErtd5mukOhLdd15fIJ
DhGWW06UWUwHx0d26QSIv4yg+ksQ6Q3s3gIEH+zeIkR6BQA/ZFJj
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvadksgQL60QH2agU6/tfpjkE7ZBrfc0y0WGac3fO
8yfTHB5Wiaw7zjHRYSqQn35jmsM694dVUwQmOsgA1cefn+ZwRGFDUYbERLA6
92PTHKzv+/dOV5zokDnxbc3+g9McCm25rivrIPgv1Qw5dIwRfLA+y4kO5fvm
S60/PM3h1ELXbcV2Ex0OfdWI6T8+zUF309z3y50nOvABGfmnpzlUggzwmOhw
GCjPfwnqHm+o/O1pDkkCEZYm/lD5m9McKoDqO3wnOiwpsOUKPzfNQYWtceph
oH6wO49Mc+BYIxP1xGGig3a72M1zu6c5gMMD6J7e6XlCzJuh7tef6LDlRNm+
+eumOagC9TsrI/iXfYE2iiH4QNce8+ae6OCU8PTCIph+Jqj/9k5zAFnz/ccE
hw9AZduPQ+xP+TLBAaTN/CqCD1Kv/wzBB4fHD4h/RX5OgMQX23RIeDFB7JcX
nO4wAajwDjc0vqSnOyQDw2OLODQ8FaY7nAaq/6yKxjdE8MWBzrtsPdGhLgsY
EjLTIeHrDPWfyHQHkPODgeFtDASbeabDwxtsPxOCD0tPAAGcGn4=
      "], {{1089.254, 
      1470.9060000000002`}, {1101.676, 1470.9060000000002`}, {1101.57, 
      1472.6239999999998`}, {1101.3629999999998`, 1473.835}, {1101.051, 
      1474.546}, {1100.57, 1475.6399999999999`}, {1099.848, 1476.499}, {
      1098.879, 1477.1239999999998`}, {1097.91, 1477.749}, {1096.898, 
      1478.062}, {1095.848, 1478.062}, {1094.223, 1478.062}, {1092.77, 
      1477.429}, {1091.488, 1476.1709999999998`}, {1090.207, 1474.909}, {
      1089.461, 1473.156}, {1089.254, 1470.9060000000002`}}, CompressedData["
1:eJxllG1Ik1EUx5eBWS0nJmq1zKQiqIhYIaHRkQiJosA+WCYmNnNmZFAklJWF
UpJml/C5hThLfItEK22ba03ZJEXDij6EGFhUREQIRZpfrPtyrrfahzF+POfe
8/L/n7syrzgjP8xkMmWwH///smZTRHspgRJ/w9LO+RQc5Fvp9koCTSe3LXgT
T2Fs+sKx1FoCkRse1RcnUpja/6G57o7mHdeOfz7Xotl3+mZ8+X0CB7Z2D04m
yPO+TgLBn2uzLVYq4ia6CKTlfnqZtIRC/UTrs91uAuuuxI7ujaHgZDzcQyDA
4msWUdiS491V9YTA6AjLHEEhw5NQUeQjsNlms3XN0fwqaWx6ZsqYZd7PxiHN
/PyRoAHDd3e6fjB+fzamY8BviPvNfgLWLHvKYZ+M/8q4ljVW4DVkfX2Y32MA
n9f6gKx3xG1ARzq7qZ+AaMNlwOPBM/6GAczvkueHn4eymMNDQ86HhrKKF/Xc
/o+d/3JRI55X3IR6eJBbUI8eA1ib4y9aZb3JrF+hZxve12tARLs162Ob1D+z
D+dzj0A1PRE9t1+zmq/ibtb3iknNBjfGbwNWh1+qDbbi+Xnop2asbyGF5rr+
xAeN6DcL6ulEv0Qj39Is8tRo3pNcmfauAvszU1B+FvqEaVb1KhbzCqB+5wkM
MV+c8uN8GfM96PVhPxfxu1dyVRn6R833MoFCHs/8EMuNUk7Axv3pknqmXtV6
/WLzXnY9lJX+It/BUFbxNXwxDmkWeuZqZittKrPj/rixvqO4X16sz0EgZXxf
ddxT9Hch7kdAs5qXYjHv75pFfTMyn4nxKq5zOOrlwPzsPYljF78uwPvNuP+q
nkh8H/KRLfh+2NF/UVT6MY/Act4o4xvs4re5moV/cjQLPbOlPulRdHZ+wjcW
fG8yMd9iKuZfV6Lfr7/9wfkPsRJu/g==
      "], CompressedData["
1:eJxllGtIVEEUx28aZmr5dktXt4wisIioCBHpmIVIkWBEIlFiRg8ji6KiQupD
SJTY3HLuBzEpehCIllmJpFFiRIIZRaJr+X6sJlqpuUpb586c3SFaWHZ/3Lnn
8T//M0uz89IPeGmatgu/5m+7M//Ii0gdFq6uKs1bYoCbozNzEjpnOVx/Pbmy
I0Kxb7k1sy9UByvyvnkGVKR0nwsL0uFMfVnkmkAD0mtiLuf66xBXENG2I9SA
0rEHb5p8dMiIr3572mLA9o1Xkro0HTDsnqLFBgyvWOtb7mQezg7KiF8/ofiW
+f4Yg4TOtELLIor/jcl84ZTfwWS+EHo+SOcDFYt4/orF+1i/w8w/xGT/3pJX
jVA8Tca/OcogKau/JfY3B5RMu/iDwWE2euGlk4t4I1g/dldvm+KwYW9tagD1
3zzKZb+op6hngEs9YnXgyVePDtoVH8J4m94rfnd767OTjRymd/bei7KRXnUc
7OZ8LMTPORSZf1B/81zJYzrvq4t6yio4bME0sy7mYXN+OdP/ct+47Le5koNZ
1vkh0qeKnvczMb8p5OU+l4obepmc/xPK16PYtElal2Khz1cGd48n+u2uIv5C
+j4ivdr/Z1HfZ3XezWLeGN/16azjfhOXuvUxKMbCDzbI87nDTPoV9RLvYX+D
sw+/p9fI+Nd+kR+ecjnvP4rFvOfqHhb6oZ5i/m69A8jftaRHIPm7jvQL1gGr
rEh5pVj4pVGx8EsT5cP3N2P8Ozh/4Xf3/nyUftMwf6FxLMS7lUufanLfKu2k
/yTp1031OKSfxwaoXpzPh1i70zVC+4zzaEHOH6fndgZN6LefEzJeSRsDdNmp
GzOKxTznGB5eZ378DKlvB50Ppn3qofgWuc/V6Cfh52hD6j/OPPeN0H9G8Tbc
lyyXYqGXtw6pAV5xBTbi+aRnNPECXea3GnAi0a91Ge6D6DfK8OjtZnG/hSje
b9aH95mpW7KV7ocw2l+r7M8Wrkv/Yj6hazj5I8bw3I/uev8C2a6NPg==
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQXWjLdV05fZIDn+6mufkK0x041shEpZQj+EE75Fqz
WyY5qLI1TnWWmg6h+yDy73mnOxQA9S+eNsnh5rnvwcnM0x3EgYzLsyY5PKwS
Wef+fRqcv/VE2b75LxH8i0q3f/67P81hT8lkiZYZUPOvTQPb/2Qy1P4z0xzm
vl9+zLt/koP1ff/e6YemObSLAQ3omOTw70rFS7XdUPUNkxy2AM2X3wZRf7oC
yt84zeER0B3H8yH8+eug9qci+CBvLA9Fk/eY5FCftadEeOs0B5B1wfZQ9x6c
5nD7Z12WjfkkB9moFOv7QPclCURYmhhPcjj8VSOG/yaCfwjI73+G4IPD58M0
B1B4LzaFuv8X1P9WUPOYoeFtDw0vYPhOABp0x3WSgzbI4yLQ8PWFho/kdIj/
QiHhIy433UG+9XWgRRwi/tDjFwDsDPIP
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQvadkskRL8iQH7Xaxm+ckpjtwrJGJSolH8OVbXwda
RE9yqMsCqhSf7gBSzxI+yWHLibJ98qLTHS77JgncCJrk8PdKxctlQtMdQNrK
/Sc5LCmw5Qrng5j3xGeSQ/m++VL6HNMd5r5ffszba5JD7/Q8IWYmqHmekxzq
geYL/5oG5wNdYR3/AcHPmPi2Zv+DaQ4/gh8vlQaap8rWONX58jQHoHXfg4H2
8+lumvv++DSHipdqhh0RkxwcE55eWLRnmoMc0P07EiY5XFS6/fPftmkQ92Qh
+GD3FiH4YPUVUP/tmuZQaMt1fXEt1D0HpjmYxu3y7GmCyM8/BnVfK9S/FxH8
Q181YvofIPhOIPd8nuZwVGFD0YsGqPuA/k8SiLDcUgFVzzvdAeQN9eJJDoeB
fH5g+Frf9+8Vz0HEB3p8AQCyKtCF
      "], CompressedData["
1:eJxlk21Ik1EUx4dZulrbQ4vNwlglliAhfQgKiw5ZSEVF9UUiDLYCkchCMXuh
CIyCkupWz/0UEtoLCDN1W/nSioYhj2nJJBtORCpkhaxYJRGMznPv0Yv4YTz8
uPee8z//898ab9WhExkWi2UH/syvv3Ti/HKDgX1D+4Oq1RxmuPCaK7Y/m8O5
xLqN2VEGscHpw74cDqN/L1Vujav7Pq1sS+Cr4p03Tk7+Syiuw/fXpxgE+mrD
Hg8Hl1noB4MPa7FSLge8llyfYqCX4MMVsv+9X7LfZ5diUc8599yncdhU3rX7
ZkrqHVzKoafmbk79TwZnw40rW5cQJxkUjx9o4FYuvm7U8+Z3wdFbOF/+oiv3
S74pFvUmFZuyLnwhPVbyZ4LObVL/kzEm6zg4nNm2eCRvVM7bqFH/mGLR/5Ni
Mc9HBs2n8SG+73+4K5QaJv/tHAzk6iGp343zuFFIdIDmXaj2JfxJ67M8hP6m
DcWXK3tqnL06oNq3/Qb58VqXut/RPC/l+d4Bqtety77vGaSH6xKPO3UxXxPq
qbgzdXH7Cx08V78f3Ix6Vx05Xjwe0qX+Eel/EbLQG5/PZv1kG/Gj+TxzH9X7
S1sUR/d5tbJWBntsGYVZz3Xhb2a71PMK9Zi2THfQ/J10P8gAU9r3p1vqzwsx
qDXzEZbv65Eb+KllC9APr5nnEPkbURxBfxyGYpGv1FwustC+kIPmfrNon0HS
Y6Vz5Fz065iN8hGg/dopPx1UzyHzGWmjPFDebc/Ib8pXpl+x2GuL4tu42PhT
Jn3U+Ky/4v+I9c3YNTVTfSf171X/3/9NyQE2
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}}, {{1, 4, 3}, {1,
       3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAmIQfURhQ1GGeY/DlhNl++bvmuow1bk75/m5bjjfk4dJ
u31Pt4N2u9hNv6VTHSpfqhly7Oh2OPxVI4Z/wVQHwQjLLSe2QtTLz0HwLyjd
/lk3E8E/tdB1W/H0qQ5yra8Dd2zvdnBKeHph0dSpDjqb5r5fvhtq3pSpDoeA
dP/+bofe6XlCzZOg9p2A8idC+Veh6pH4MlEp1vG9UH4DJh+m/mGVyDr3bih/
EtS+Sd0OSwpsucInT3WYBvL/1G4HPl2gw4DuAVHL53Q7OALdqzRjqkNMP1DH
Emj4zJvqAA6/NVD7VkD53D0Qc8WnQfhCaPyCHofyffOl9JdPdQAG67nv5T0Q
84HmLQa643pdj4MqW+NU5xlQ97dC9QPDC6yvu8cBqCv4MdD9nSCNkyH85InQ
+JvXA/cvjA8LD7D/TTD5KOFp3wOJbyD/EUjercfBGARg8eHV45A58W3NfmB4
gcLtum8PxJyp0Pj2h/pnOoIPNm8mgv9++TFvc2B6ydpTMlkCqB9sDiw9uSPC
BwDwTDdU
      "], {{902.238, 1392.499}, {896.504, 1406.1399999999999`}, {
      890.629, 1392.499}}, CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7cnDpN3+uMdBNirF+v6NqQ7l++ZL6X/tcfh3peKl
2tOpDu+XH/M25+h10G4Xu+n3eqqD7qa575fLIPhHFDYUZegj+HKtrwN32EP5
z6HqfaH8+1MddED8aCj/OpSf1OsgA7Q//gyCf0Hp9s+6fQj+wyqRde7rpjpM
c+7OeR7eC3HXQqj9TlDzpkPloe451zfVAeQtf+leh0NfNWL6u6DuYUHwQcq+
/+yB82P6gaz3PQ7gcOmG8p/0OPABNeb3QsPjZo8DUFdwcv9Uh0+XfJMEzvVA
3DcJ6t5DPQ5bTpTtk5+G4JcBw3X9FwS/d3qeEPP/qQ6xIPOBfLD/WadB7DvY
45A58W3NfnYo/wA0PrimQdy5rwfiP+5pEP/vgZrPM80hGuTfXVD/8E5zWDob
qGJ7j8NFYHj+A/LB/tqC4AtGWG45sQHBz9pTMlliTY/DqYWu24ph6pdB3ccD
Vb8Yml74ofK3oPqloPzHCD4A/1wnoQ==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7cnDpN3+uMfhgtLtn3WXpjrA+Hy6m+a+nz3V4VGV
yDr3Vz0O1vf9e6fPmOrwEMT/2ONQn7WnRHgaVP2PHgeZqBTr+ClTHQQjLLec
+N/jYAwEmydNdSjfN19Kn73XQRYof3/iVAcBkDwfgr+4wJbruhSCDzR2soRa
L0TfVKj5Br0O2u1iN88B3cMLcpdVL9h9+YumOsT0H/qq4dALdp/4GgQfrH4H
gg+ytuwIQv+pha7bis8izM+c+LZm/2WE/V5AcfZbUP9LQd1zd6pD5Us1Qw5e
BB8cTqwI/lTn7pzn/3og4XRnqsM0EP87NHyB5gFdE9P/qcfh35WKl2o3oeH1
Gip/DRH+sPgAACvbvvQ=
      "], CompressedData["
1:eJxllGtIlEEUhjd/GEREQUTYRZOCwMQfBRIWHZGI7lREEkIiRRaBEVEREfjD
LG1W13ZcMC+oqUhbmq63WCxMXUkzM7W8Zetqu2qyhUWFJM3M9y5DtbDsPt93
Zuac97xnNiSlHD0TZDKZjouv/H17MGl5/DdGEemrBg/NcApwsmX2xq4uTqFp
M0caZzXXdVxpLvIxehM+/Guhn5On7H5r2Dgjh3w+wulLRfv+6CGDQz9yOhB9
Jzaxl9FC37Wpcg/272C0LLKmIGWS03nn5XurnZpLL+5c8q5Gs4p/yGir/Exw
2jF2mNnKGJ0T+Txzc3og44sYua+vfLxnjJMoo/tHPqOW75sTskb+4UHNal0/
zhfrf8v8enFeKep7zSlqdGNwagX2f8Vp3cnTMWNVjHhc5oWzLznVz4mVIv+1
4vkpF/IbhF7POfWIfW4KPbeJ9GubcP4iM+1bGhSx+IlmFV+uubN4d/1cAact
NQX+inlGm4JTeZwN+foZXW0uConK4RQjzxP6/zzmKVvDcH4f6s1AfJvmXJG3
t0lzQpb49wicCf0LwWK/1rDqS8l5jPyyr2a8z8V7M/a3ajbJj0Wzys+M+hn6
dRf6ivP6pN63/me13q7jA6zqy4YepZzWS3/aoHc+/FfCDN1t8K/d6J8rB/1q
hL+yOTVIbtOsfNytWdU3wGhcrrcgn2Hsb+UUKfvjhj9tyG8C6/M0q34Vahau
4i9K4Dc35qcc+g7B35XQX/RT+c4OPV2MfPOVX3ursd7BjLmsQ77F8OdT1Gs1
+tfQDDZDzxbwbWMeTrRDjzRGsYmTPeGdmmU9/p6/OeU98skw6q/9AH2syN8D
f2E+XT7Mg13fNyreqVnl36p5Rfx2R0cXo71iXtKnMR8D8IsP70fBXvhnHP3x
ar0DrObpk2Y11+I+k75p8KK+KfTLB39NMxLqhlT5cN99RvyUvh8D+f4BtUXD
pw==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQ7cnDpN0e1Oew5UTZvvls0xxQ+C+mOsT0H/qqUYvJ
3wriP5wKV4/Ov6B0+2fdMgS/LmtPyeQFUx3K982X0g+B8udA5cOh6mdNdeDV
3TT3fVSfw6mFrtuKZ0x1iEqxvu8f3+fABxTPnz7VASS9PAXB/3TJN0kgE8EH
q8/tcwCSveJA/UcVNhRlFELlZ0512P7575WK0j4H7Xaxm+dmQc2r6HN48Xvl
x0tA90x17s55XgV1z/ypDgIRlltONCH4IGdL1PU5XATy/82Aur8cat+UqQ6V
L9UMOfKh5k+Ayqf1OfROzxNq7p3qIN/6OnBHbJ+DLMih3VD7QxB8YOjG9Psh
+DZAc6d79Dm8X37Me3sP1D1OfQ4yQPn4vqlgf7236XOoBzpMeAJUvQXUvklT
HQRB6k37wOG+firUfcZ9DksKbLmuz4Dab9jn8AFk/lwEH+R+vyUIPix+weaJ
YPLB7ngCDR+ZPoeb574HJz+D+kcZah8s/WhDzX8z1aHDMeHpBSNoeL2H2mfZ
53AaGP+fP0910AHx7fscMia+rdn/A8oH+v9hlcg699/Q+HLrc5gGov9PdTgC
im8fRHoGAA2NYYY=
      "], CompressedData["
1:eJxlk19I01EUx4cUhdk/iIgoMh9EsIgokIjqZERUVFAvEYNCCiQCpcIsorcY
UZ3flt5U1hrbSumlpMK9iEFtIUar2WrNbabNYSaxbJiUJJ1776lb+oMfdx/O
2T3f8z3nt7qq5uCJApvNVkmvPHcXFZQ7QgjljqWJ/aMC/uXIOwGLD2963P0G
QR51QwK2FMYDtZlp+XnDgVrK+Gn45o6rp4ZtFpzr8i5f91nA2oeeXNtsCxbI
H8MCOvK/YvWFFnxte743mOX8IgumYvUjpRnD1a4vF7cN/B9vTQuwW0/Hy+ZZ
Wl9SwBp5/xxd70FCQI7urZhlQSIycSgTF3Cy82zDMtITLUn+mKL+Bi8sub9r
Ev/yXXeouP274aDUN4aw/Vj2dcl7vn8Ulf6aPtaTRVUnmOL+BhFWHjm++QPp
EzLeb1j1mzJ8R/qVQNggH+LzI6Xr58Y5nmS9UdR+UD/zZYEehDrZX8zMS+mJ
GFZxv+FK0u/38DzDCJ8m7431tnD/3aj9beL6dH+Pb2fHGSHgW+++qkUvEV4Q
5xsEhIvbT1dHdf6TGwKuSGPeoq7j4nmktJ6cU0BI5g/N5BXU39HrXM8xk//k
K31Ow+r+Ju1Hq4vn4Uag6XetIn1ybSdus5+NAqSNB3yo5yQ438/9NnM8wPVb
OE58SRp/y7Cah8+w+n94WvyV0HtOrE7an49Sv5+Z9mer/H58el8q+nj+XoSN
JPcRzXuP9NGj+/GmuH8360mzf80Iz8bL7Av7ef8aDat5OA2rutcQyDW7lTb+
Kk4xX2b/BtjfTvP9/gb9zRC/
      "], CompressedData["
1:eJxFVGtIlEEUXQz8Ib2o6GGJJimCpdSP7KF11SSkNJIiK0OxIgnJBcMkxG0J
EVnXSWx0S03dTBHxgYkGhUZJmUumsiSZYmaiImElFRFJM/OdZRaWj8N8c+85
5577bU/PSrrsZTKZzoq/fJ67dHDyhIXRUODHP/n3Ob38GZLCMhlN3dzQerSM
U1F02sxQGqPO/pwef8bpx0hC+toURsPi/WU7Jz9Z4BSjenOUz5liThmlX/MO
J6CejdONnhrf8DiN1XOfxlefXS/bHMYoRrRxinqrd3VULwYx41nKyXFt3e3n
foyCvK08tpxTQ2VfQPsWRq66uK6lSo0VH6fGA+I8u5HTI4m3Mgot3PghsRnY
n9ELqbMV/EQ/qXvNY6501oRBfzf0RjJD11P4Ew/cy0mUHfydyki4aN/Ux8nj
p+w3+EZjqSfrrcb2CiHsPacon9GH5jyjXu84+OXA70/ww8wofqVXaOE0/MtA
/xlOh+T9CxorP09r3LX0z52biHpfNH81tymcH2GULy9Ool80o+T9nf2/xjVW
/oxxOi/5x8BPt8aLja+ORQxjXmTkYXQQ84hihs9Cv/Sp4gD8d0HPXugfgJ7d
GqvznRorviGG3xUu+BkEPqL+N8kjEHzfoX8AIx5ry7wyrPE2cTHVrbFF6F8/
hn7BjGb/Nn1PEn7kSt57tH/KD6GnXNSbnePkFvFITkT/BczzosaKZ7bGyvdb
yO88+Nswr1lO0zIAZYyW3bnzwTN434F9mML8quDfBPL3gJFIrW/bGPJcy2hO
8B9xa6z2w6Wx8qdFY7W/9dBfa+RzRQ3O6/B+NTfmWoe8i/1bJXk5GX0W+/L6
HvTXwy+BTfLXgH104HvSiHMPbtJY6W3W2L9g4eSTFvBzwK827JcDfnUY+WoT
/cIndnhbu3G/Cnx6gWs19nzvIuV82rFfdzgdjxCMnPDXBn53NVZ5L9FY9S+C
/8XgV4B5lXDqlnm1Yj9KkV8L8sb198DD5z+ahcKT
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQHZVifd+/vt/hotLtn/8WTHWA8TMnvq3ZfxjKz+53
eFQlsu74/qkOV3yTBCLi+h0iLLec+LZnqoMt1/XFBRH9DtrtYjf9dk914NPd
NPe9b7/DzXPfg5N3QOXd+h2e/175MWgrVN6x32HLibJ98pumOtiB5G37HU4v
dN32ed1Uh/J986X0rSHml61G8EH0+uUIPsj8x4umOjCAgF2/wzTn7pzn86Y6
LJ19RGGDM9T9s6Hme0Lsmz8Dqj6g3+HwV40Y/ulQ94Uj+Db3/XunJyL4MqAA
yOsH0/GzEOEDCy8AbkWYuA==
      "], CompressedData["
1:eJxFk29Ik1EUxkeKDAk1tVm6uTQdlpqN7UMioxMWfoiK9EMiQqEGEpEWkiVh
BEVR2HtDbwNLLbREkGW5YoQotCjDWkPNaRlj/smJxIiSEqE673sP3A8vlx/3
3Huf85znzaiqKz25QafTOfBT1+yYK7zYzsC7mlMZP8ChM9L7ZszKoMV5JjGq
h8P+W6eX1vMY1N75fmmknUPKjO/3RLbgvW0c8p51RHrTGcw1JbvetnBIv7Zy
1GNg8ArvU25yGGpo3RIdJ/msIzbQHSW5cbgrtWBVgbvF+NBtDpvKC92jiwo8
Hz0/3OXkoJbXTymwtN73o/QBhwR136fA5VNDDUn9kk0VNUXBl5I1fe84hFBX
SYDunyQOU/1XDhOHqhLK1xQI4/3j3ziUerCDGAa51w0zh1c46PuNFQuJktX6
6TTJZux3z3YGcfloRJj63cFEXwscOlQ/d4n9uiCHalUg+uvP/LLW/FmyEfUc
/yRZ0zfOgaFRs7uZ0OfngGoL7QXk/0cOrpJQU1s+A7vNZhv8IN47mEt63gv9
NTmSUbavMUuyqvdqBun1EZsZoPupT/x0HudbFDzSkjJO8zMxyMLceNFPLT8m
qp8m/4yi3jnLxYp+NeO8WoNUv5WJ+Yao3kA8T/0nMXCrvED9xUsee3jgxU+9
5D9l84/uYZ7+Tl5YtsxxqFTQsH80f5zv620D52p/CR6Z4nBx2WLVRxTYd2LR
n+mTrM3HK1nLp4fygee1d120j/dr7z+mPEQzkatOoTd5o9Bnbqd5bZas9Zcm
GVVbb6D/PfWO2GP3Rb3bIvLlw7yr7VTuFPuBbvIL542/YVl1H83HSvl6yuE/
XjvTxQ==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQvc79YZVIzASHLSfK9s1nm+aAwn8x1YFjjUxUSiEm
fyuI/3AqXD06/4LS7Z91yxD8uqw9JZMXTHU4qrCh6AWMPwciPyUOqn7WVAeg
6nXuCRMcTi103VY8Y6pDu9jNc+VJExz4dDfNzZ8+1aHQluu6ciqCf9k3SSAi
HcEHq8+c4GB9379XHKgfaItESzZUfuZUB9O4XZ49uRMctEEKZ0HNy5/g8OL3
yo+XgO5RZWuc6lwAdc/8qQ5A0y1NShD8CYe+atwB+v8ikP9vBtT9eVD7pkx1
AJr6PTgLav4EqP/TJjj0Ts8Tau6d6vBKzZBjTeIEB9moFOv73VD7YxF8sDlR
CP6P4MdLpcMnOLxffsx7ew/UPSETHICxYB3fBw2vwAkO9cDwFJ4AVe8PtW/S
VIdkoPotvhMcyvfNl1o/Feo+nwkOSwqAFs+A2L/Ye4LDB5D5cxF8kPv9liD4
sPgF22+LyQeF7/sn0PBxmOAAsib5GcQ/012g9sHSjwfU/DdTHeRbXwda+EDD
6z3UPqD7TwPj//PnqQ4gbYuDJjhkTHxbs/8HNLyA/gf7+zc0vsImOExz7s55
/h8S3yyRiPQMANB0XW4=
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQvc79YZXIiQkOW06U7ZvPNs0Bhf9iqgPHGpmolLuY
/K0g/sOpcPXo/AtKt3/WLUPw67L2lExeMNXhqMKGohcw/hyI/JRTUPWzpjoA
Va9zPzPB4dRC123FM6Y6tIvdPFd+boIDn+6mufnTpzoU2nJdV76I4F/2TRKI
uIzgg9VfneBgfd+/VxyoH2iLRMt1qPzMqQ6mcbs8e25OcNAGKZwFNe/2BIcX
v1d+vAR0jypb41TnO1D3zJ/qADTd0uQBgj/h0FeNO0D/XwTy/82Auv8W1L4p
Ux2Apn4PvgY1fwLU/5cmOPROzxNq7p3q8ErNkGPN2QkOslEp1ve7ofafRPDB
5hxD8H8EP14qfXiCw/vlx7y390Ddc2CCAzAWrOP7oOG1d4JDPTA8hSdA1e+G
2jdpqkMyUP2WnRMcyvfNl1o/Feq+HRMclhQALZ4BsX/x9gkOH0Dmz0XwQe73
W4Lgw+IXbP9KTD4ofN8/gYbPmgkOIGuSn0H8M30D1D5Y+tkCNf/NVAf51teB
Fjug4fUeah/Q/aeB8f/581QHkLbF+yY4ZEx8W7P/BzS8gP4H+/s3NL4OTXCY
5tyd8/w/JL5ZjiLSMwDx0HDW
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvWz2EYUNXyc4ZEx8W2N/bKpDoS3X9cVAvjEQbN4x
1YFPd9Pc9z8mONRn7SkRXjfV4eMl36QJ/yc4yESlWMcvm+og3/o60IJtosPf
KxUvl82b6lD5Us2Qg2+ig3a72M1zs6Y6MICAOIJ/eqHrts8yCD7IPmWliQ6n
gOLFc6Dmq010yAS6Z//8qQ4gZd+1Jjp48TBpsy+e6rAU5F49qH0rpjqA3W84
0WHLibJ98zdMdZieJ9R8wATKB7rX27zTMcF4ooMnUH/70qkOIOOC9SdC/Dt3
KkSdBtS+qVMdjipsKHqhONHhYZXIOve+qQ57SiZLtEhOdDj0VSOmvwsSHvn8
CD7IfeUsCP46d6DO3xMcXvxe+fESUD/Yns/Q8Jo+FeLP1xMcpjl35zyfD/Xv
8wkOIGclr0bwweGzE03+JJQP1A+27yqU/xmi3u8elA+0/zBQnv/5VAfr+/69
01knQtz9Ghpeggg+OH6lEXxw+KhMhOh/MdXBBxh+D7Qg8eX3EOp+Q6h/byHC
Gxy+FxF8WHoCAHDWK3U=
      "], {{1085.422, 1394.999}, {1095.984, 1394.999}, {
      1095.898, 1396.468}, {1095.727, 1397.499}, {1095.469, 
      1398.0929999999998`}, {1095.051, 1399.019}, {1094.43, 1399.749}, {
      1093.609, 1400.281}, {1092.785, 1400.812}, {1091.9260000000002`, 
      1401.077}, {1091.031, 1401.077}, {1089.656, 1401.077}, {1088.422, 
      1400.538}, {1087.328, 1399.468}, {1086.242, 1398.4060000000002`}, {
      1085.609, 1396.913}, {1085.422, 1394.999}}, CompressedData["
1:eJxllG1IU1EYx0dBSERFhESvVCRBRUREH0x8ysnU9QLzQ1ArY2aERbOUGtPm
hoX0MubZduZi2pCoCMQgSiLCxEFJguVIxtqWkwozCakIE0F67rnP4UAThvw4
557z/F/u3WizW2oWGAwGC/60/3enH74eOs5gZFNqdj7B4W1XaW/9GQbrjp0u
HPvCoa5oceJeHYNtrfnJw1McfAN/tlqdirVtR5oV95jGncEWBjHctuw7h8mC
XXnbWxloj/kmOLRfWNHSf5PWv3L4W/n5fsTLYAjv/Z3lkJp11b70MTjLfjQV
p3TexxiMO1f2mHA+463zE3PIV/qiq3eOKF6640nn9KBioadL8W7tr4OLfXY/
nRcmPQG6L8ThV/yQbXmQAU7REAjS/ZzBlkUeXhLg0Ib70yHS6+dQguc3hhkk
h2cqqxkHtNTgjtA8bRwsz9dfn4rm8lo0rsrLoVPz/1Iuy/2af90N/z3vUHxw
74392UaaF+/fc/JF+e2rlB/OJ3Q1k/4g6XczeDp4uW9DSPd/jUfnKPqR142T
ID/T+A6d59H9edWhWPorWcz/RvH8B8fkg3fUJ7ee1+NRXZ/Zpc9vT3J9jibK
M0N+OqgfY5RPvWKxfk6xmLOa5vvIQfZZnBtXLOeV/G3u0c94hMNF7PdmKwMv
FnNhmPK1Ul/RHy332AkG2HJve1DXt6RK11cQoHxOUX/8pM9GfjDqd43Ka0bj
2lyW+Qt9Rbks9wsuVizyMyoWfTWRfj/pKWPwHvW7cH5syaprFdSPEPlrpvsi
iqVfksX+mGLh3zDdb6bzR0mPPD9B6xX0vmE++dqLUs4gpAlJkV9llF+a+mqi
/mWo36WU9yf6nhgVi+cPKBbvL1B+GeWf4DR9DwrJnyytH1XfL9kPyf8A+cWV
BQ==
      "], CompressedData["
1:eJxllG1Ik1EUx8UPFRHRh6gwy7KiwKIPGREWnbAQk4qSKCQq1OgFwd7IiBCC
QmipXfMiVCZlKZLpmtOpyTLNGZv5tpYtzeVbm0lYRJhI0nme5z8u1WBsP+65
5/7P/5x7lyen7z8eGhIScoC/2m9F3MDl/EFBUVkLvHvGJAX5pPh6ZVubpFUz
rspYn+Kl18f21fYJ6orsnZz2SOJt7RleQdbXF+1FfZIaLtxedM1jcMQnSTG+
vdkFXYKm314aLRlC/jZBc9dZCtNHJDkf7Kw571C80Ns+4X6pWIufbxe0QfsM
S0qed2hz9HNBp1jPiwFJfPxEYq0gjqqI80maVR6eNFwjqOnnmsO5ff+wV/Gj
M1tn97B+F5//wybot6avG+fVo74OSSxjfHUD8r+R5N7NChoFyVhT2gmnJC1N
MesPT0qNOdoKfR741ShpLe8vZT+jWX5VnXF+6qigXXNCo2Y+U6zHlyjWdRVK
6p3MPL3lszD6UAC93I8Me1HY+jxJKXyelf3/lTj0eHG2cb61G/XeQLxTca72
p0XxDlOaf8oONsF/G5jzaXnvVgsaL3UkbMrBehXWc9A/i+KWZeZzAbNiXV8l
6s/G/gr4a8I8PPmf9f3lKj7Ien1m+FGM+bTCv3uYvzpBnZwvk/1ayevNdqN/
rXno1yvM1y1JZ5lXuBRHaPPdoVivzy1oUNsvMG/vkD8f/fFiPgug7wP231Gs
9+u+Yl3XQ8xb8P6UoF4P5rtM0oTmP/dzCc+XD/VH8/0JTJV97zbDryZB1dr+
avS7FvNZj3otRv9sdqPe4kr42YT1cuM+HHTAD/Z/+7GRzkiXYq2e8c6/Of09
+vvUqL+qH/ot0D+E+bLB/wDug129N3q8Q7Hut1MxRztc7YLi+b5kfcH9dWNe
AsZ6Qg/YDz+86I9f+R1krV8NvYo3HqmPv8nv2TfNHz/q+4h+BYz5amZmd8Mq
A3jv+hE/qt7HoN4/7S2/Dg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQPe/98mOnlSc5aLeL3fR7PdVh64myffMNEfwkgQjL
LTaTHA5/1YjhfzbVwTRulyeP6ySHQ0B+/+2pDi/VDDl0fCY5WN/3751+aarD
7Z91WXv8ofpPIPhAU6XW70Hwe6fnCTVvmeqgytY49bDvJIeMiW9r7NdMdZgA
NPiO5yQH2agU6/uLpzrw6W6a+x5o3wUloM7ZEPt7HCY5lAPN05861eEV0P41
lpMg6iZMdZgL8o8R1L6eqQ5bgP6R14a6twvi3jVKCP7pha7bPosg+GD/cU1y
8OJh0mYHmhe0Q671NeMkh4tA+//Nmuqwzv1hlcjviRD3LoHa/30i2J7561D5
8rsQ/FNAe4oPQf3/E6J//ymof/9OhJgPDL89JZMlWJgmOQBtWecODF/n7pzn
1eyTHKYCGekPIfpt+CY5yADDJ/4pVL3oJIfnv1d+DHoJiS8TGUT8occvACyC
88o=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQfetnXdYehUkO2u1iN889meqwbPYRBQNZBL/Qluv6
YslJDqpsjVMPP57q8CP48VJpsUkO5fvmS61/ONXh4yXfpAlCkxys7/v3Tr8P
0b+Bf5IDn+6mue9vT3Vw7s55Xs07yaEMpP7aVLA5ztwQ+fyLUx1eqhly6HBB
5U8h+GD5Qwg+yD79rVMdolKs75/nmeSQOfFtzf6VUPcA7d9yomyf/IKpDhxr
ZKJSxCc5XFC6/bNu2lSH/kNfNWLkoO6dONXBBeie32oIPtgeXQR/ep5Q8wGj
SQ7Pf6/8GDRlqkPQDrnW12aTHLYCzZ8/c6rDOveHVSLWkxxOL3Td9nke1H22
kxzqs/aUCK9A8C8C7f+3BcE3BoGj0PCxhOoH+h8c/kD7MoD+sQeG156SyRIs
elD7HkL5Goj4QI8vAEp91JE=
      "], CompressedData["
1:eJxlk31Ik1EUxodEREj1R2iUaWlFYBGSEWLRSYmQqEj/WSLL5sekAqmGisrK
2NrAzHZfrzpURKNGEBUlJiEKmREF60PJ9pXGFK0RFhElgXTue4/czBfGy2/n
vvc+z3nO3Wwuzy2JMRgMWfgT763L63h2FYNUZ5z/WJTDv+x7z2HF3YT8yUsM
jBk9LyomOSQ5oif6nIvXDzUqzu1LdJzVFL/sOtR7sZlB5UDn+l1fOMT7fb9G
Whms2vmwY3aaQ3DOdmZfG4Nv3udHHk/R+nYG86NVn7dFFJe5v9YemFhcvx3m
cO/wp+qmNtIXpP098rz7fg6/8yK3NuB5+HdeZIzDHtOTnFjU8zY5ODeP/s7v
Xzl2U1M8ctS8xuhWHEB9/dcZHCycepP8gfavl/rLAxxeoZ4fLgazQn+I6lcZ
bMwvzhwPk16HYt2vXbHoV/QKg93iQe63auvsdVQPSr3XbNQP9CNiqaxhUCH8
jaq8dD0+xXq9W3EW6u/uoDyRZ/7c+f7OI/2nVFN/W+T5y3B/XTfngKemuWqZ
9KlxwO5k9Njk+kHGYXjTgwszlxnkxMakOt0yj7V2yveGXJ/uWsoJ6O9UA/k9
uZQX1uv6TIr1vE9T/m7qdxEDTH8gCfVl15+brimhfjZx2IGfeUsZNIsC+okT
g2Ahv60cxLZeC53vof2QMXWr1q5Yz6NLsf798H/11xwyx483tFho3mm+UhYY
5ydR3J9SOS97A5Q/6k1HuY8w7y3iPhVLP50hms8i0hOm/pkZDP3cXrD6I81X
oeJnmEeZSbHQE1/A4ClyY1j1V+cQsZH6N0H5WdX9/QvJvgvU
      "], CompressedData["
1:eJxFlH9MjWEUxy8ZSdIK/f4prS2GjbWW1iHWWqMtf4gZrTEWE2MxLAxrVqne
11NxJVKaSRkNw8rUSHdSuSvVbXWr6/Zj7UYjaeK8z3Ou54/WPnuf+5zv+Z7v
eYJS05MOzNXpdLvwT/uf//ZHmMlRhdbgnunMmwxis49Yz/5VwHxmaXWcyuDX
jsEK/bQCtU0ZdQF5DPBU2sYpBdrw/Gwug+PRTp33JhUoPxbttDOHgUdXy9Rn
myLuy2Zw21b5zjAmufnu1mcnLJIPFYyfi+lXYHOKpbUM7xsJXee4yqSAy+on
JbYCBtVxqOSLAivnX2SxhQw27H0Z79yhgAHvmdRL5nrKJPM6lcSdCoRnLe/a
/pC4SwFse09eNenrUaABeclTBq9Pqp6X+6n/59SvVRE6XzHYgv7MjBPXM7iv
bwxci/5E9SXmejQysPup1Wv5IFnrJ/2j5Nyio26XOhgkvfC/cniByu+rNwl9
OfNU4Xc/g1H0o2qOCvHOc8OzBsm/P1TfIn4/NiW5GK99MymZ152g+Q1J/X67
90f1mek7ziczDTvvI/9HFUiOrG36aZLM/elmkKcZN0p+GiWjjQkRbWJe10dE
HjpbyO9hBU7VlXqvwf4xcroLX8l/A/UzJPTWN1M/Zsn8e59krrdX+F1kID97
SA/er7WV2E16P5GfOG+GwT7YJtkXD+4zSj6P/bt3Uz3Mn3Xmwbck9KNEa2xA
+sf9wH4KtUUZZpAQcXVTygTVHyP9vyVr/eoc1P/M92WhKvI7QvpdxPxjrAxC
MOcNbirMGk+PhFro/DKRH5uZ9tNDFf71MqjA/D32VCED/a3pJr1eKgyj/naj
ZL4fBsncn0eS+f6WU/9eIp8OpbQf9vMlTPjgrYq864UfVcgDuC/vb1CefSi/
yKmuyZHrfVVxb7F4T3z86Lud/SVr/a4IkPy9fVuqayDpKya/Amm/kPm7EKzy
fNVgPe5rCP3+Fs0jjPiOZPt7x/MYRPuVz8CxCpPhTf5m0/vnLpnn3VWyVr9h
MfmfQ/oW0byuibzacN58PwqIcf953ph8D+x6/gHvhca8
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQPeHQV407HJMdLird/vlvwVQHGD9z4tua/Yeh/H+T
HB5Viaw7vn+qg7d5p2PCj0kOEZZbTnzbM9UhaIdca/bXSQ7a7WI3/XZPdXip
Zsih82GSw81z34OTd0Dl30xyeP575cegrVD5V5Mctpwo2ye/CSL/+vkkh9ML
Xbd9XjfVYe775cdOP4OYX7YawS/fN19q/XIEH2T+40VTHZIEIixNXkxymObc
nfN83lQH07hdnjyvJ0HcPxtq/luIffNnQNV/nORw+KtGDP90qPwXBJ8BBH4h
+AW2XNcXM0x2kIlKsY6fhQgfWHgBAGvWqIE=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfdk3SSDCf7LDRaXbP/9JTXNA4S+cCuc/rBJZ5z5n
qsOMPKHmA0D+BaB83YypDtb3/XunB0x22HKibN/8aVMdgnbItWYHQtQfnzLV
YensIwobgiY7yESlWMdPnuoA5BVlhED5k6Y66G6a+149bLLDVOfunPSJUx28
zTsdEyInO/CBJCZAzBePw+SD9fdC3WeIyYepN43b5dljiuCD7beAqgfadxTI
f2E52SFj4tsae6B7QOryrSH+kQe6F+wvm8kOnjxM2u1A/7SL3TxXbgv1/zSo
fXaI8AD7G8h//nvlx6A5CD4sPGF8WaD9978g+P+uVLxU+w91L5AfYQm0mXUa
xL9AvjbIYvZpDltB7gHaX75vvpQ+1zQHH2B4PbCBynND4u8G0P1AVVLreaB8
q8kOh75qxPTzToOYbwl1D5AP0vbdHMGXb30daGGG4DOAgMlkh1MLXbcV805D
DW+g+aBgXa4P9Q8/1D4vRHoCAIIVF4U=
      "], CompressedData["
1:eJxdlXtMzWEYx1szzAyjYeQ+l83MDMMwj2ENw+QP1sylhU6Tc6pTJweVFYcs
B2+v1OmipENxIh3RUnGOWzZj2WLlkjJas5i5rWme3+/3bS+1tfbZ+/yey/e5
NCncHLorMCAgwMS/2t+YpYOaphwWVPkoobbAI2nx2w0ZWQcEBYdFLN5+XdLI
V09/brIJstUWjJntBVsF+b7P2Dq0GhwjaMisiryuWkmjmBvNgj52X/4a6lcc
efrzwWUNilvtQZ6QRkkTjnRuXBgHf82SaqxidD+7oHvMzlZJjevCh71Mwfsn
SZ6QVnvmcUEzHSNfre+UFD5sy6J5mYrvT7wW+ylXcUPhqptxxci/A/FLkW+7
JL3+WsUOraB6xT83tV103RNUbGHDdiN+kE8QqzWmHJzJnJG1b3hqO+Izd7kf
rF3Qa+838nnaJmnFib0fD/jx3mbkX8nc8yKxY9p7xXo/3ik+q334RhJbzTnG
/IW/r3qN+v3Qh3klm3UjflWLUd8FZl0H8BQf+sGslXWB61szOHDmgJY+9Tf3
0Yd5av/DckWFYt3eC32boG+VoOSoGuuI54q9Wj2PFWv1TbgL/Sqh723o5YFe
N/DuFnpc31XMQ76Rf12ppIFXgsPaxf8c4VSseXuYLkiyfnvK4P8o3q9I+sX9
HZsqaK72UwrmfXg+ufl3jxv2Kci3BJwM/YqRX5Kg5Ts+PCsqUqzPX6FiXZ/z
8J8MfQrQvxTEy8M+cfwn3K9vuYa+tt78ctEvzt+k5e8y9iXtGPrLrLVlegbs
XYifCf85hh4hRYL+8LyV5MC+DPY5yKcc/cqW5NQW0Qu9zuH7asQ7K4087+D9
jOHPfRfz5ER+PG88xY8S0hXr+aQpfsacdAjzWwf7BPi/JWgc36O3ZtTjwf7s
ljR/W/XqwYW4VzvR/1OK9XuWqlifh0T0LwL+zcjHBI4y5nFzNO5HpCDe7voG
i2Ldn1Wxlu+PeMw3s7YmJ2zI14T52Y99Zv/GncW9i4ZeydDDYuyXORX7ZcF7
GvrB91ebI5cD/uyYr5OSWMWoJTbocwr19t7rM5ivOMO+XOBexWBeJfofg3uU
pVjXK1vxas7H4cJ9iMV7PuqxQh+e/9Bb4490xqO/vC95WmJ23LNL+P6f/z9/
AViTQwM=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvadkskTLpMkOF5Ru/6x7NtXB+r5/7/ReBL9d7Oa5
8s7JDp48TNrtT6Y6FNpyXVdum+yw5UTZvvkPpjrMfb/82OmmyQ7GQLD5DlS+
Ecq/huCD1Z9D5csfmepwRGFDUUbzZIcIyy0nvu2e6nB6oeu2z+2THcr3zZfS
3waV757soA1yyMapDo+qRNYd75/ssBVk3vqpDuvcH1aJTEXwfwQ/Xio9C8FX
ZWuc6jxvskPv9DyhZqB+sH8XQszz2wp1/5LJYH+L75zqcApof/GyyQ5eQP+y
70fwwe49juCbgPx3caqD7qa579WXQN1/E+KeKfMnO/CBJO5D5edA7QOG3zyQ
fdMR4Yse/gDSaMzb
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQnSQQYWnSMNlBJirFOr53qsM694dVIrWTHS4q3f75
r3OqA0h+S9Vkh4SnF5Rut0HlKyc78Olumvu+eaqDc3fO8+ryyQ6iQIlfDVD1
ZZMdgKrWudch+NrtYjfPVSP4f69UvFxWMdWhwJbr+uKKyQ6yQPvvl0512FMy
WaKlZrID0LafdcVTHQqB8srNUPflT3WQa30duKMHYp5f7lQHVbbGqc4zEXx5
oLzFUgS/8qWaIce6yQ5BO+Ras4H6k0H2b57ssPVE2b75QPOPKGwoytg52WEJ
yCHlUPP2QPjhNQj+FqB6+UYE3/q+f+/0lqkOpnG7PHt2TXYACXO3Q927Her+
jqkOr4DWrwHaB7T1xDdgeF72TRK4sQYaHl1Q/y+a7HD4q0YMfzdU/eTJDiKg
gO6GhJdJx2SHjIlva+x7oHyk+AIAninH6A==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dyd87z63mSHjIlva+yPTXXg0900Nx/INwaCzTum
Otz+WZe15+Fkh/qsPSXC66Y69B/6qhHzYrKDTFSKdfyyqQ57SiZLsLyf7PD3
SsXLZfOmOojfPPf98rfJDtrtYjfPzZrqMO/98mOn/yP4M/KEmg+wToHzQfa9
55ricGqh67biOVDz+ac4ZALds3/+VAdVtsaph4WnOHjxMGmzL57qAHav+BSI
fSugfKkpDltOlO2bv2Gqg2ncLs8eWSgf6N6XaoYcOjJTHDyB+tuXTgWLy0tM
gfh37lSHoB1yrdmCUPumTnVIEoiw3AJ0z8MqkXXufVMdgN687880xQHkrP4u
SHjY/JgM54Pc5/wWwfcx73R88Hiyw4vfKz9e6oO4h+cONLymT4XYe2WywzSQ
w+dD/XthsgMw2IKTVyP44PDZiSZ/Esq/ArXvKpR/B6Le7x6U/2Syw2FQMD6f
6sCxBmjzu8mQeH0NDa9fCP4tUPyyTIHzweHDOwWi/8VUh1fA8FsjDIkvv4dQ
90tBw+MWIrzB4XsRwYelJwBdGCtr
      "], {{1271.6209999999999`, 1394.999}, {
      1282.1839999999997`, 1394.999}, {1282.098, 1396.468}, {
      1281.9260000000002`, 1397.499}, {1281.668, 1398.0929999999998`}, {
      1281.25, 1399.019}, {1280.629, 1399.749}, {1279.809, 1400.281}, {
      1278.984, 1400.812}, {1278.125, 1401.077}, {1277.23, 1401.077}, {
      1275.855, 1401.077}, {1274.6209999999999`, 1400.538}, {1273.527, 
      1399.468}, {1272.441, 1398.4060000000002`}, {1271.809, 1396.913}, {
      1271.6209999999999`, 1394.999}}, CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3S5289x3pykOslEp1vdvTHWY9375sdPeUxz+Xal4
qfZ0qgNI2D90ioM2UKHf66kOQFHDjngE/6jChqIXGQj+p0u+SQKFUP7zqQ6V
QPUcFVD+fSi/Hsq/DjWvaYqDDNCi+DMI/gWl2z/r9iH4D6tE1rmvm+qgu2nu
e/XaKQ5AZ3qbL5zqcARof0YR1LzpUPlMCP9c31SHCYe+atyJm+IApGL6u6Dm
BSP4y2YfUTDwQ/BB9hz3mOLgycOk3d4N4bs7T3HgAxqc3wsJj/O2UxyAoRac
3D/VAejKLBsLqPsmQc03muKw5UTZPvlpCH7ZvvlS678g+L3T84SY/0PNN4L6
n3WawyOQ/YZTHDInvq3Zzz4NIm8IjQ+uaQ7O3TnPqw2g/uOeBvG/PtR8nmkO
/SCP6EH9wzvNwTRulyeP7hSHi8Dw/Afkg7SVayP4wNjtna6J4GcA7bVXn+Jw
aqHrtmKYehWo+3gg6sWVoemFHypvB9UvBeGD0hOMDwCRGB6Y
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ3S5289x3pykOF5Ru/6y7NNUBxufT3TT3/eypDpd9
kwQi3KY4WN/3750+A8K/4TnFoT5rT4nwNIj6ct8pDjJRKdbxU6aC1YkHTnEw
BoLNk6Y6zH2//NjpkCkOskD5+xMh8tMjEPwtJ8r2zY9D8DMmvq2xT5niUL5v
vpT+VKj5mVMctEEMoHteqhlyrMmDuC9/0VSHh1Ui69wLIe4TX4Pgg9XvQPAj
LIE2HUHoP7XQdVvxWYT5mUB7919G2O/Fw6TNfgvq/zioe+5OdZBvfR24IxzB
B5mnE4Lg6wCDbXnAFIi9d6Y6gIJR3RcavkDznLtznld7TXH4d6XipdpNaHi5
Q+WvIcIfFh8AP9jIUQ==
      "], CompressedData["
1:eJxlk3tI01EUx4d/hESUREhENTOSQCIkwSSioxIR9qD6RyJIrCAiGj1YDyKK
Cgt7uHaubisZCi0i8zkfpViZjqWxlUlubauFiprEsoiIQDr3d0/cysG4fHbP
7v1+z/fcZSWWnQeSTCZTPn3l+nVga0nKA4TM0tTwtkkBf3PgrYC7t3vSGpoQ
inK9fuuIgM4T9oWXHuv6Kaov79Zsvjy5Y61P80Hb57MbXiCc7HIvWv1JQIvf
2uXuR5i7qqkqMSbg9ERGVnIA4cs9X2HbKNcHEaYHT01kDGs21vi/+56YgMKc
q3nFAdYXEeCV579U99WHBfSmNRwb70MIB37sGh4S8IbshfwIr9MjP6fJn9Rh
8Wk+un720PIezaQi68ozhLzi0VfpIT6/S+m3vBPgODL/4tMOhITUH2V/jxCW
7N6/7kOM9bZrNvy2aZb9am9BWCM/xPLn7V7ejyi9RY3cD/KzYtYFUVCHYJX+
BnVehp6AZmO/RnM+6a+pEuCReRKP/7o/NeBU/hO13N9KdX/wIUJf9cbW40JA
qmxcPUI/8Te7ABoZ0/lGVf/kloB9KdT5ZoTNc5IyS20CtlAe8VbOt1zVmzpm
8mK6aO919nttJv+pV6tmI2/k/G2cRwUaq5n0fTyzoG6Tg/uJQvlwIlQUlB0e
E6re7GK/Dt538f1OPo/43CGa9DuajTyqNRv/7/1vPygguZZOcvG883wlnMwh
fj9ONS85ND9LZf6kN5vkNkf4PVUqP+4oz2cF64lx/wTC8+8r98x7z/Nl10zT
kptt0yz1jNxA6Ca+GdP9NTjKXMb9i3N+Hv1+fwNpQQ8K
      "], CompressedData["
1:eJxFlHlI1EEUx82kzMxEK11vO0SwCKEIMfGRhUhUZH9kEhVmFBZpB3YQRpQY
qKk4zyMzywyJTKOkpEQhO8wl09y8Zd081k1kC8kjyZrfzNvmj93lszPz5vu+
770JTEiOPWZvZ2d3gH+035b7O16cc0RoW903m3YboTradHnFXwb8uzo6HyHB
NS5s0yyD2ubUBv8cBI+e1umOKQbtfP98NgI/lbR1kkFFSoTT/iyE2Dq/9JNW
JuNlIjhW+cQnjivefOhVjPOI4o5dCa7dRgbbjoy0lfN46xZdw6Y+Bi4bnpVa
8xC+B4U6VnUx8X9UAcKZCKeuB18Z6LnuyRLFQk+5YpFXJUKKxp0MQjJW9ex+
TNzN4M2v4IM51aSP39fEeflzhJl9Qw+9Byn/l5TvKIMTeRNXIl9Lf9gEcSOK
fR9mGIQb92R7vEWw+and1/pRsZZP8ifF2YWn3a53ItSfz/d0WIwiXmO/1L/G
AaXfg9KPqAUIMc72IRlD5N8fun9Enr8xrVjzM25S8SULN/AH1W9Y6feNTww3
mmid1yctiUcykv8WBnFhtc1T/YqFP70ofbeQnwbF1sr3O7e0I2jh1ltkP3S1
Uj3MDC40lHlt5PkLn0bJfz3lMyz1NrZQPibFYt2oWOgdkH4X6snPPtLD478L
eHp2rIf0fiY/OWNU5qnj7Yp51cMPGxRf5fm799J9/QzMc49+xhplfwyblH/C
D55PAY9nHkPQyjxtpfvHSf9vxUKnPf5nMS9LbL6RfhdZ/0gzQo5mjBvCvOGi
JWiE9q+U/WM10Xx6oPRvQPZftCdCKve3ppf0ch7j+r8YFIv50CsW/jxRLOa3
gvLXyf5cWEbzoaP9pQj+6eN763RUxxLqTy+Eb9ocFFM/e1P/cr7LG0PvTXkW
yfek1ofWOR/V2FdxL8+33k+xlnalP+krojgBNF+cc7kR/YEo+qumWOrPWkvn
71A9gonvKba9dyKPQJqvXITtvKxzOvI3k94/d8WibssVi3otI/+zSN9Sqtct
BF7F0Ju83mI+8oj5/It+Q/Ue2PT8A8WQuhE=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQfWqh67ZijqkOF5Vu//y3YKoDjJ858W3N/sNQ/r8p
Do+qRNYd3z/VoV3s5rnv36c4RFhuOfFtz1SHPSWTJVi+TnHQBkr47Z7qoMrW
OPXw+ykOQFXByTug8m+mODz/vfJj0Fao/MspDltOlO2T3wSRb3k+xeE00J7P
66Y6cKyRiUp5BjG/bDWCX75vvtT65Qg+yPzHi6Y6zHu//NhpoP5pzt05z+dN
dSiw5bq++NUUiPtnQ81/C7Fv/oypDnNB6j9McTj8VSOGfzpU/guCb33fv3f6
TwT/9s+6LBuGqQ5AW63jZyHCBxZeAIyUqsg=
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{1548.309, 1419.5422050000004`}, {
     1380.336, 1418.3942050000003`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0015993573798539545`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     1519.0352151084003`, 1419.3427313653801`}, {1504.4964306622799`, 
     1404.6045089652398`}, {1555.6292151084, 1419.5932634038202`}, {
     1504.29701324704, 1433.8785158115002`}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{685.992, 1421.6362050000005`}, {
     853.9649999999999, 1420.4832050000005`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0015993573798539545`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{715.26581396796, 
     1421.43294050606}, {730.0040363681, 1435.97172495218}, {
     678.6718345067401, 1421.6864725445}, {729.8046257991199, 
     1406.69871810592}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{72.195, 1926.1472050000002`}, {
     559.277, 1926.1472050000002`}, {594.734, 1926.1472050000002`}, {623.277, 
     1897.6052050000003`}, {623.277, 1862.1472050000002`}, {623.277, 
     1702.1472050000002`}, {623.277, 1666.6902050000003`}, {594.734, 
     1638.1472050000002`}, {559.277, 1638.1472050000002`}, {72.195, 
     1638.1472050000002`}, {36.742000000000004`, 1638.1472050000002`}, {8.195,
      1666.6902050000003`}, {8.195, 1702.1472050000002`}, {8.195, 
     1862.1472050000002`}, {8.195, 1897.6052050000003`}, {36.742000000000004`,
      1926.1472050000002`}, {72.195, 1926.1472050000002`}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAmIQ/emSb5LAgwKHac7dOc9l5jrA+Nb3/XunS8x1COfT
3TR3fj4GH6a+0Jbr+uIzCD5IWR4DwjyQdIFwgYN2u9jNc3JzHaJSgCbJFzj8
vVLxcpnSXIcOx4SnF9QKHP4B+Wqqcx0Of9WI6dcqcNjlycOkrY3gv19+zHu7
CYI/FWh++mwEH+Ss/MVzHQ6B+BoFDhkT39bsXwHlqxQ4LCmw5QpfPdfB27zT
MUERIm+/dq5D7vPfKz9KFTgE7ZBrfb0O6j5BqPoNcx2Emg+cWsgMsd9801yH
rSfK9s1/lQ9x72aE/2F8WPig80Head+OCF90Pkz9ZAmWML6TCH75vvlS+usR
fJAzA+cUOKyRAbp0I5Q/ARoea6Hh3wEN/1VQ/7dA+UsQfFj4wfiw8IXxQeG/
WmeuwxaQf9sKHICxpBStPtehExRfXQUOD6tE1h1XmQsO9/e90PhVguqfUgDW
J68I5c8rcPgAMl9+roMsKIBXQ8L3uizU/7sQ6QXmfxgfALsSPlw=
      "], CompressedData["
1:eJxllHtIU1Ecx8coC7P1IEh0m3uo5FZoRYwews9XT0JaUFKiIVlJze2cdJqE
YjFMIqRMNOogaBoWRInVKpi9MOkvC0MiJCoiJGJUKEVonXPu73qKDcbdZ/ec
8/v9vt/vvfYyv7fcaDAYvPwrrlve1y272UrgaiA7fm+AgUF8hgiMON7+qm9g
YFrVz6KTBDa+Kzy3vIlBdvxYd8BJZ9n3+Xfftw2KWxPn7DEVUrgzHIx0hhgs
FPtLKUSvDe24d4pBR+XS048CFPz88oKf/7p2In11PYWi9QPDU3XIZ7T1nioG
NZHOpMwWCnGNbXln/Qx6Lz+z3bpA4cCnEcf+I4qnR2sneksUi3nGshSL/Qtc
DJpz+M6LVM7lT8PzL1HYnmB0z3My6BHrr1B4OrmieJEd++nC+ikMtgq9+rR+
g1YG+w7yyW9TMPMfpRYGmeOpcY2DWN+M+0djWejVnoj6/CExrK+X/c9X+2V/
Zvr/fReeZ0Feg36kIHN/BoQfNgZc1eYcoGARjTvQzzw8j+vxhM/dkk/hJfd/
Jh31KaDwYFuC8YZLsa6vzkKW58WK5TmHGHx/tbNsMa/3UOz3YZ7WYX+UgZAx
4qZa3oLYbxLmpRbZqDhL6DtOZlnuCxMtb8cZ6HmW/lQo1vvVWeqVgf61Efi5
+2NPchrW6yDA3T522InzMLxvR+4mWn50fa/jep6H+9bQl139RMunBed9rPyU
er+JZd1/ef7cWNbXi78rTYqln6mKS4RRazV9PFbdf02PKRv2l0ug4vzXk4NO
zONmoj0fGYp1vXSWehcplv2VM+gquPtjOp+AN2wNHfVhvVysz98nYVEP8Hzu
T7t4/jdhP1WYdw9yNb4/eP8yf0HM40oCfCp3Uw3On6pY5idZsfRzieZPNKj0
+yDyWY39zwS0eidQ/wb1fvs3H4L/AhbuStA=
      "], CompressedData["
1:eJxTTMoPSmViYGAwAGIQfd+/d3regyKHCMstJ741z3V4AOKvKsbgW4MU1s91
sOO6vrhgLoI/WYIljG8igg/UVravvdhhSYEt1/W6uQ62IPWNEH54LVR9dbGD
bFSK9f3quQ68upvmvi8vdpjm3J3zvBLBnwrkp5cj+H+vVLxcVjLXoXzffCn9
aqh84VwHj4dVIuuA5v8DyedC3fcUKm8014EPpN+zBGJ+PtT+wBIHkDZ3oHlL
Zx9R2BBSAnF/OYIPdn8lgg8Ojyqof4JLHBKeXlC6DXR/7vPfKz8GlDh48jBp
t9dA7fctcVgjE5WyG+jfRa7bPv/1KHFgawS6CBge7iCLnaHmAfk75FpfB9qV
OACVW8cDw09hQ1HGROMSeHiC7VPG5MPiB8xfj8mHqc+Y+LbGfn6JQ55Q8wEv
IJ8BBKaUOAB9/7CqDhp+vSXg8FMDurfTEeizphIH7Xaxm+eqoO6vgIZf2VyH
q0BlhgUl8PAHx8/1Ykh4ikLD6wiCD3aPdjE8/A991YjpVyl2+BH8eKl0CdQ9
csUOoGQjXw4NH3Fo+quY66B/V4WtUbAY7P5TVdDw4YSmpxqo/f+LIP4Fuv8w
yPxfRRD/Av336ZJvksCHInh4w9I7LHwACORj3g==
      "], CompressedData["
1:eJxdlGtIVEEUxxcpAzUDEVcX17fr1mKWQaKyecTAdClJQc2K1LQMtlXszqRm
mpaoSERIGcjgh1IJwyKSIsHCwkpIDAopCZUSE7HHBx9RSjN3zjaUsMiPc+c8
/ucRXlyeXephMBgO8Z/4v2+mxr//FYHkqazLRisDnRkBz4ZraW2hDAzir5HA
Ss6n7k4Tg+7O52H3KAHxWXoQA1tzwPuxUgJzv27/yDYy8I29z77lELhVYffK
C2BwWhhAcdnVxdqUSMU3XH4Xn3oRMBeUJE8FMrB7TdysWNEgP/HBy2UzgxFH
QmvqZ03PxzuSQY+I/0GDO8EFJYNbFWf6eNg2xSvW80tgINxmTWlQzsOMJqP9
i6bX25HCYMfHKM+GJQ2yH4U0LexlwMPSIW8iOQPzsUl9Og5g/g4CIu3MHNTn
AoE3EZM/1/NRP67n994Rx8NjivV6jit+nOHj0edi0JpaODs+jO8Jg7NDXaa4
Afy+mkG6+L4X+Tzq245cj1ytWNfrhGK9X7kERFlddejfgfZzqE8K1lON9SYS
WSdVLPo1UcngXdW8ZWcSkXo7FYs8yssYjPM66nYTGBT1lWK8ONSD179NzEsM
gVPc/5MizDdEztOLQgbTXGaXn2KnmB9PxXq/1rCfRRh/WZP5cf8tQs+vmpwn
d/wFDdbeVs33lCle52xxKuavIiYrcV5XcZ64HqLtLn8i33P9Ngu943D+L2G9
ubg/zZhPy3/cr3iP0PM1Af56pqYJ+zeL/hpRj1Ui86nH/dpI4dmS9ciWWuyn
L4XraW3OOd4fMaYH/SkMc/uVM1iPkQLvtumuU7Huv1ixrpdd8YCYj11YH2cR
/3As9j+ISj1sqI+JQp/YPyvWY6bSTwzawyjw6+E8aWEyryiq690TjfNuxXyi
cR9iFev7Ga/4qFiUBCrvkdueRKWeFsw/FTkG9dpPpa7u+1BIZf+2K/7n3tml
HnnBqH8w1feDBmD/f5O/3B64Idd3UbFezzSRcY24rxNod9/LMbl/oWa8F6O4
H+HqHrjz+QMPyYWp
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7fGwSmTdyVKHf1cqXi7Tn+sA41vf9++dHjHX4aLS
7Z91s0odZKNSrO8Hz3X4dMk3SaCm1IGtcapzd8BcB5CyvDyoer+5DoobijIm
hpY67PLkYdL2nuug1S5285wzVN59rkP5vvlS+palDksKbLmuO891WDr7iMIG
PYi8uMNcB6Do4gLNUgfRde4Pf1kj+CDj2s0R/GnO3TnPDaHuMSh1WCMDdKDu
XAc7kLwtVL3mXIfc579XfvQqddAGuUN1rsMDkHujSh0iLLec+KY814FPd9Pc
99kIPpAq29eM4MeBPLK41CHh6QWl2+qI8IGFFwBkp5BQ
      "], CompressedData["
1:eJxllF9IVEEUxhcfDFaR/lFRq+0utZVLVA+LxGKdFNKyknyxlogQzQ1u681d
55il/Vlkk0XCQn2wQdJ0KUuXMIoCjYiUHkIiWKIHsQipCClIiDCamXu2QXy4
XH7MzHe+852511VVV1GTYbPZisQj397YmvdvFhj4p8vb18Y4pPnY7tHJ+RCH
VdHnr2+7EDKvdBZnXeIgtnWH9uP//U/yWr8dNTTvsaf6zWbNK+X5OMLHptXD
E60cru079XmqC+Hvu8YvniiHTwM9L519CC9+bT1x/TKHfFk/YdWLN2tWek2L
17OQQ8mMEO5H5ZdFODiT9cGOHoQ7ZqG9sp74JkKw4/vFvSaH3EC1f7oNYS7x
qqygjlt1WzQrvbDmQtlPLfkxKZ/jtB4m/4cQKmQQDRx+vj1ctbwIQcqUINX3
a1b1fZpVPzsQptwffrcwDnK5fJvVz3yEeAPCGeF//ByHNplfNvVr6HmpfGo0
y3wHd2m+7whUP/NyGBR2kzbKYwv1n0n9bKJ1O+XtJr8rUOkccVJ/DoSu4rgx
m8dBqPhOehAOZGd4Y7nk12fln3KQ39KlLPW71xEbbAmn9z+aZGO9VzVfELHN
3GCAY73rR0Q9l8yXMxDTMWo3cigrEAoDDBZk/07af4/BqNRxk/9hS69yM81n
hMFT0cCQh+5z0rr/LF+zzOfxTs3qfGAxp05T/0JPzTdE/ID8mMRDDA6KvJaF
qX6CqXmMR8hfH+k10Hxu0fco7kepFO5kVt5I/bdrVvOKaj47++fuj0YGOdsf
8jmm81XfY/q+Bkn/PPFX/T/4B2rA5EQ=
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQPeeIwoaiDmcH6/v+vdMz5jiwN0517r7j5PDvSsXL
Za1zHLx4mLTbpzk5fFh+zHv7xDkOh79qxPRPcnKQiUqxjp88x6Fvep5Q8wQn
BzagPu6pCP57kPppCL4sUP39WXMcbLmuLy5Y6+QQtEOu9fXcOQ6zQfa/cHJY
UgCUmT/HQXSd+8MqFWeHfKHmA6cWznHIff575cciZ4eHVSLrji+Cyl9B8HtB
5hu4wPkgd3TXuMD1g83f4QI3X/+uClvjVxe4/WDzRFzB8uGzEXxQeIjPQPAj
LLecKJs0x6E4Y+Lbmv8uDglPLyhF90DD55qLwyOQ/a3Q8FFygYcnADwOoqc=

      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQvch12+e/X2wdrO/7907PmOOwEMSfYgPmi7fNcbi+
uMCWy9zGYZcnD5N23xwHzZj+Q185bBx2A/mrJyP4YP3TEPwlQG3XZ81xkNa/
q8LmaOMQtEOu9fXcOQ4WnY4JTzdA5edD5RVtHfKFmg+cWjjHAWhLu9hOW4eH
VSLrji+C8ivt4Pzc579XfjSyh/PXuQNZ5+zh+kVBAioOcPPB6pMcHGSjUqzv
A+0//FUjpr/JwSFj4tsa+9kIfoTllhPfpiP4MkD18VPnOIC83Z4G5ffPAasr
04Oqb53j0Po6cIccqz08/ACKlpaN
      "], CompressedData["
1:eJxTTMoPSmViYGCwA2IQvbdksgQLW4iD9X3/3ukScxwWum77/PdIIJxvGrfL
k+eSr8OH5ce8t4fPcQCrT/OFyAP5p0EaeH0dPHmYtNuBfJfunOe/T/rA+adA
8msRfEagnQwTfBzYGqc6dwP5IC5DgQ/cPLB8gI/D1hNl++YD+U8vKN3+qefj
sBtowGq4fT5w98D4YPMNEHwvIJ9dY45DxUs1Qw4dH4fVMlEpu5XmOPDpbpr7
Pt3H4e+VipfLFOY4fLrkmySww8dhDUhedo5D7/Q8oWYDX4eHVSLr3GUQ/ofx
K0Hm1fhh8GHhBfaPgzsGH6beDGTeIwR/zhGFDUUzPOB8kDSTtKfDFqD/5eWg
4Znp6bCkwJbruuIch+uLgYzpng5BO+RaXyvDwtfTQbtd7OY5DQQfFh4w/iOg
+cfbEXywfRNg8eEJiY+pcxxAxnwP9oS4f/ocB2n9uypsjJ4OoGiomzXHYQ8o
/ts8HCIst5z4NhvhHxgf5l90/j9QeM9HpB8YHxLe/nA+2F2OAQ7fgx8vnT0P
qn5dAMQ/c+Y4qIIcKh0Ijsd8oHv+g0A5NL1Og7r/cCDE/glQ+wWCwOEX3g01
zywIEv8tCP40Z2BA1yD4YPtL5jhcBPmbK8gBGDo56blQ8zcHQtyZPschc+Lb
GvvYQLD71RLngNOR9fUASHzFQONPEcIPj4K65wHUvcZQ+9yCHEDRvlprjoMB
MLgb5wY5ZADN3a8CTf/PguDxf9zbvNPRIBgS/3JQ8yYEOxz+qhHDLws1D5if
YekJAAiBoQ8=
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQfXqh67bPvD4OXjxM2uxxcxz2lkyWYDFD8OccUdhQ
FOHjcFHp9s9/sVD5Mh+HCMstJ74B+aLr3B9WTfFxCNoh1/oayAfKhvGt9XGY
5tyd8xzIZwCBAwh+5Us1Q44YPzj/8FeNmP5J/g5l++ZLrU+Y4+ACFP5tGODw
sEpknXvaHIdLQHvrZgU4JDy9oHQ7e47DMyD181wAxP4iBN/6vn/v9GoEn61x
qjN3yxwHEZD7lgRA7OuCuicgwOHflYqXahPmOHy65Jsk8MPfgU9309z8qVD/
SviDzROfMcfBNG6XJw+TH5x/fXGBLVe7L5zfOz1PqPkBJDzKps9xgIXn++XH
vM2nzXEAAFJfnvc=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/U0jpv/Q2VCH98uPeZsvm+PAfX1xge0vBP+4t3mn
o0KYwxqZqBTrpXMcrLacKNtnH+bwsEpknfviOQ7PLijd/hkX5qDdLnbTb+Ec
B/nW14E78sIc+HQ3zX0/D8H/d6XipdocBD/h6QWl6JkI/RGWW058m4YwH8yf
grD/IlDZv0kI93nxMGmzA/kw98P40vp3VdgWIvgz8oSaD1SFwvWD+VGhcPNV
2RqnOluHwu0Hunr5Me1QuPtgfJj7YXyY/2D6Yf6HmQ8LH5funOe/K0Ph4Qf2
zwJE+KKHPwDop78r
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQPSNPqPlAUJiDJw+TdnvZHAcY//3yY97mugj+BaXb
P+vU5zhI699VYYsMcyjfN19qvfIch28aMf2HUsMcHlWJrDuuOMchfhfQpOIw
h2nO3TnP5ec4yLW+DtzRFuYgss79YZXcHIeQx0tnH1kAtU92joMqW+NU591h
Dt+DgRIycxxiQfpfhzn8u1LxUg3It9pyomyffjgG3/q+f+90iTkO00HuywrB
4MPUuwCd8Xsjgl9rbxq36yFUPYz/M8QhwhJoMNA9XNcXF9gKhTosKbDlCpeD
+k811CFz4tua/UD/bJoLDBnjUIcPwPDZrghV7wTlA8OjBmSeZ6gDyFvd6gg+
LDxhfKBsTnoAgv8QGH7uUXMcFrpu+/zXJdQBFAyrE+Y4bAbZZx0KcW/yHAe/
JIEISxOofanQ8NQIBceHfjqULxHq4AUMX/YMKJ8j1CHhKTAGM6Dx+SkEYl8m
NH6uIfhgeieCnwH0t/1UCP94BiJ8wfENtA+YKrL2hIRAwisbyudBpCcAAVYQ
ig==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQLbrO/WHVnQiHCMstJ8oC5zhsnvt++bHbEQ5BO+Ra
XzvPceidnifULBDpACQPeFnOcbikdPtnXVWkg/V9/97phnMcFrpu+/z3SaSD
bFSK9X3NOQ4u3TnPfydGOXjxMGmzq81xAMpeqfiI4Ic8Xjr7SEA0nL8JZN/i
aIfdnjxMq9XnOFwEmf8qGuyeb1pzHKT176qwGcY4ZEx8W2OvN8dBBOTenBiI
fcZzHMDunxPjsKTAluu69RwHA6DyxrNQPtC9xSCN2yH69xvMcQD6KnBHWQzE
vxpzHIA8uVZuCP+bwhwHBhBYEO1wAeQOyTkOtfamcbskox0eVYmsOy4KDY+K
KDgf7L6TkXD+DFBAGUU6sDVOdeaWmuMAkm7cGgEJLyWo/y0iHIC275PXhobn
r3CH78FACTMEHxw+rmjyIVC+VYTDQ5B9CVD+rggHYPBpt2fC5CPB8u5Fcxzi
dgFlbkc6AGPh5bIyWHhFwflg/zhEw/ng8DkWDdFfDA0//RiI+TlQ98+Igfg3
FRHe4PCNQfBh6QkAntMWkg==
      "], {{99.44500000000001, 
      1813.8039999999999`}, {110.008, 1813.8039999999999`}, {109.922, 
      1815.273}, {109.75, 1816.3039999999999`}, {109.492, 1816.898}, {109.074,
       1817.8229999999999`}, {108.453, 1818.5539999999999`}, {107.633, 
      1819.085}, {106.809, 1819.616}, {105.94900000000001`, 
      1819.8819999999998`}, {105.05499999999999`, 1819.8819999999998`}, {
      103.67999999999999`, 1819.8819999999998`}, {102.44500000000001`, 
      1819.3429999999998`}, {101.35199999999999`, 1818.273}, {100.266, 
      1817.21}, {99.633, 1815.718}, {99.44500000000001, 
      1813.8039999999999`}}, CompressedData["
1:eJxlVWtsVEUULvwoKPg2PJou29rSJVZSICEVCNlTiRIsLYJoK3bvnZnbxy7F
WoSupmKTxlSURkGx1sQhhaBilIAhCj4XgkKJUQKEQAoSUhtDDKmPKBh+lHhm
5sydrPuj2Xw95575zne+M1Msnl3VND4vL+8N/FO/Lx/5YdfDj/iw6PKK16cG
EgarK1+r+tSH1Jujmw6nJER7rq784ncfjl6b1bD1GQkKzhjHYNnk8eWb2yRc
uNG19ptpDL7D+B3rJYxuis/35jF4FOMTNkiIzZ24t7CWQd+S3nUtGyVcxzJH
UwzKN08ZOtlB9XqoXlrCyAfvfV+002Gd/5PDOv8aA/brqfsubqT6U7iJ4/lV
KlDJYW/hmsZFbZRfw2EVntKaovr1POxX52/lkN/dt2RSq4Tl2D77lsNw5737
lrZLeEjFRwwefI76nShMHPlvU8JUiJCfrlfnsObX5fD6xbee373Tff/5iXRm
ICPC+jr+swjP//ivMzXiHwF/7DleXbmO6uUHmn9/M+lzV6Djh4SEJ2+ffWDH
1AC+wgM/aXC4fsFnJ9KrHdb1ZjuMat7oikl4EY8dLqD6JRLuUQYppu+LJSha
w2UBnMb8m1EJF5UecwJIKr/MoP7jAfyp+ERIzxriUyjh8EBBxaXGAG6efeG3
MsR3q/o9uVifP43mFxE52ObreT7gsJ5HtcMRtMHlQOj5X7X1O4TpB/kOnfz3
8ZFuoeffi/2824YZW4TxTzHV30bzKyH93xIwhvU/LCV/bBfmnJjDVl+Lrf5Z
+U8Tv14BGM1EOen9En3fKCGj9ErS90kJ6iezlPRYS3wKHNZ+GOMhVuvMhjk8
j4X2p0i/YxzewX280kJ+/ogbvZppf1/hhpeg+h7ti0d6NHCz3wkX1/6rz8aq
f4sV/+tl5BfGzX1h9Wym/UW9F6r+Wql+kQTchvbFaR76y/iDh/5S/4/38dBf
dcrP+3k4/3a1T2dzsfXTEyo/YDk4yz+9Dut92cMMH8SK7sBBZvqLkJ+OMc2n
PEr7fIriRZR/jsH7SKSuhPgPmXi6lO6DC8zcvzGHrZ4WWz9ZbP2k53+a8jnN
6wjlN9p5m/ihJMVfNXzOWz95Dmv/VDms/TOTzrN+uoX6Qz8d/Bs340vf3KdN
EiouleZ3d9B7gnyy3hvPYdtfFsb+1XXTudzX70Ut6qXvxaf80C/6t9nX+/o1
6j1J+aXTB7W+PvqlVtxZv+Bt3/Qfofr7zPn9OL+ZiuiIH85X7990loOtP/T5
PJGDbf6BHch8t8Pqnuw6kwjPUzrERxMhH73PE7yQ7wrFt9Az72OU/H+/B7+o
9wH7Pa4G8qBn+kU99D0V98z9FXPY6mmx1vux/+E1pNdCz7zvjN7/OZ7RFd/H
1cogszxzfzQR/4jBFS2Eb/PMviYJjyXM+4x4gzL4lYTRKUXz+NFhMw+HtV5b
DB5MOn11/y2ElyXM/rQSHueH76v1j8X/AX756i8=
      "], CompressedData["
1:eJxVlFlI1FEUxicJSw2DknHJXHKtqcaCMhPrjGWiQmKgYyKONfeONqkziVmJ
CBIhIRbRYtCNtPUh8aHN0DKxyPBBKiKRNkzKbBUsKXLpLkcvDQx/ftzlfOc7
59zw3a4d1MNgMOzkf/FtaCxbdJhQGL32OKMtioH5TaRnbSCFp8te/akJYfBc
fD8TuOxO8rYGMSgvPvGtup/AD74/PpDBWX68q51A96/Y/OP+DHoy4o9amFpv
MzIwiF+1ZnF8c5pmq++qG+dDCRR+4BEDGBS0py3wmLbD1IuDI9FLGXj3X3In
vbWDX2vqYFU4g/sVJwPm9tlBbDPFaJZ6Vv+/fn0t8ks7iO1165E/2uF9lV9r
TwLqm7DDIOfUTQzGeRrd4UTln4z5WgnkJtx6UrmNQZzwpwE5nYFFCB8mYKoz
DmzPZDDjZzqPNy9b8yTP52qu5pbgPNKxi8HFlDtjk7lU3jdexGBrfcnwXwtV
fu9FP0xU+vagDP3zUvsr3Xj+NZnlHOFnh+YjX7LuhjRj/Vxaf+K7zAb/Ulw/
RECUsdeJ8VwEDnReCDIXa5b+UNTvJspPm2YR1pXPwEfUy0ngIe+HhXnodwGB
01vqS4p4/ot5mOYsdV9PDuZjUXrHszGflZrleqBmqddL+d3Hzx8T8Sewvvz+
oSvnHoWNYj3z0M8RO3A3Oi/kaxb5N9o0i/zTKcabQ8Czlit2Yn/Eaf+kHzYi
7wutYLAviXdoE/pRifp/aha2Nq+jsyznxUlV/+5H/05hPcsZiE/nTQq8PRJt
btzfS9U8lOJ8DlDlH69Psui/IQpnuL/DFPV+olK/T6FmOR9WzdKfDZrl/Jox
/xHVn4krcP0r7o9lcFv4+J2qfo9GP8YoPOPzMhWJ+f/G/uUcJYRMU+gQ8xjB
1Fx5OtQ6Z3GuxlezsKPLqDlmzfyW4BCH0heBfkU61Hzx+zcKv8wOlX8k6k/B
8zGohyCbNM+8d7Iflztgj5ivJQy4Gue9UfTXiO9fu2YZv0mzjF+P/vtjP1Zj
vYKwX0upmo9gZEpVv4Xp92BGzz9x+WoV
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ3Ts9T6g5JdXh/fJj3uY6cxxg/AjLLSe++UH5IqkO
F5Vu//znNceh0Jbr+uIHKQ7l++ZL6XvMcVjkuu3z3xMpDp48TNrtbnMc4nYB
WfNTHH4EP1462xkq35DiwNY41bnbASqfn+KwpMCWK9wWKh+T4gAS1raa48AA
AiEpDmVA89ebIfjTnLtznhsh+CDzpfXmOKiCDI5PcdhyomyfvNYch70lkyVY
ylIg7leDmt8Dse+6MlT98hSHh1Ui69yVoPJHEHzh5gOnFr5F8GcAvX9AKdXB
+r5/73RVRPjAwgsALdqI2w==
      "], CompressedData["
1:eJxllAtIU1EYx4dEhEWQRLPYZs5wkVgEhYhIn1hEWUgrMsxs+Ljn3hQ1HyNM
eolJmFmYjeiE0cOgJCQ0JcikIiVwWETDosQeqJRaREWE0Xl8xxNscBk/zne/
x//7nxubV+otjLDZbF728P/Jmg3rc8sJTN98mpGUT2H3wsS7l/sJpIxkNtrL
KNR93tHjWmrClgURCfV+CtWL72weNTQ/d7/5feSM5oOpkaFrHSaM8sAqCtuS
TqX5BiX3l1PY2FA89mcCz1n+h63L1ry1WXCfJyimMBz8tfPDIgv2JHcO+A1k
pwVDvE4eBWd2QcpInAUt6Q3FJEfz35eHJuJ3aRbzJGr29rjqijwUys1zkzUe
zBdH4TCfZzXWi6XQGCiJql1nQWlUbd+zGKyfagEPq3Zh/FZLzuuk4OD5syxg
UTcuOSjY+K8M+2Hc9OjHypzmcOb6BqIpTHH9V5lhrOIzuH7Jms/y9/dqzuXC
VZhQwvtlfOvbi+15x2Q+O+v3QWVz9By2HzF/DM4fMOF6WWpkVizqTyWHmB5p
vk9D7lbkFZjviin0+enRrPRVLPr3aha6Z6OfWL0LbF9jPgrCbydNmGH9txVQ
uLrp3veZSlPu01R6oj8OqP1oFnmnySyL9zuI7K8Q8zM/i/n2aVb9Kp57vCV9
vgf9XUWgnRdWfqgm8J77lenjWTuv3XGCQEL9kuEg0+82n+80EX3ud+F+Lsr6
fifmb5P3J+BAffvI7L56OY+Hs9q/mO+oEcYqXnCTZpG/U7Pw66Ah53fiPK8N
+Mrm72b9M5c+WT4u89vdeD6F9eI1K73+P7dnahb6ZWP9LzK+26fmwfh8PP9o
yPvG9tM14O9tfWcAU6s3hqBerwy5P4J+Dcr+Qyb6+7Eh923h96RLs9Rbs7i/
5yX3m1o/sU+CXIH6FCFnktnvl/KH4n88qk9O
      "], CompressedData["
1:eJxllF1Ik2EUx5cXURZCHzShfegsJ4gXQSEho2MSEhriKhZj1pjatud9yRk0
wkIIEQnp68KMeiJi+UGJF5loXfRhscUIEQvG6ELMIiOigjIKip6P8/gUuxgv
vz3nPc/5/885b3GozduaZ7FYvOzHn+u7HqdvDhD4PJSsq2ymcGrjaO38LwJV
cw3nrDEKd77O7gvVG7B3bV55T5yCe9uqEdtVzUtlgQtTTzTb/S1VcwsGzHew
RCcotHvyMwmLKTh1nELk0qfTu+ySa1n+hYFrz4q2m/CAJzApdH9snHTsMeHQ
znvP40eRG02Ycb3+2RmiUB18N+PymdBX02uGA5r/vDr5ofSAZqGnQrN30tFt
uClcOcYU+zFfCeoJ4X3FFPjjYdiENm6ME+9vN4Hb0uHA+E5T6rVT2M3z95rw
Yz9TYqOwdeWZvpoE1sOYp7uRzGXub38hhQ3c/yYjh1W88M/UPM7fP6+ZncY8
gwZwWWnGBwsq7l4fk/msDvSb9Ufod6L+tAG3Yp58XzH6PyM5w/xg0TsOzyJv
wXwvDeHPkluz8lexqN+rWcyBH+eJ3XeZ9et9EPXdN+A3q3+whUKqrvJs9bAh
+xlRfuL8ENUfzeK8RHOSv/+WyPpaKah5FvqaNKt6FfM2rWF6bvP5HiYwYmMF
q3kYJfCGzyvzp56lD44TKO/ZlJ1m/vm4vkcEePgRB/bnhbw/bkd9Wbk//Tb0
9xtZ7pdgm5HDqv9C31g0h1W84KfR/99f1CzmdQXqt6OeAgJfmP4JVv/Fqe9l
gc243y48d2G9pZqVX/+eWxs0C//8eH+RjJ8IKj0Y34xcSOS+sf5kp9mmrCNi
D5xh9Gs19i+M84r1ZyI430tR2e8oBf53YlGz9Fuz2N+U5FRE+yf6GcbvwVBU
+mPgeRdZ/n6p+VD8FyD6Tlg=
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQ7W3e6ZhQmO+wpMCW6/rEOQ4o/OI5Dny6m+a+5y3A
zs9BU4/E/7D8mPd2QwQ/X6j5wCntOQ4MIFAB5avPcfABybdC1avOcYjb5cnD
NDnfYTeQWq08x6F3ep5Q85J8h79XKl4uU5rjcPPc9+DHOxH84oyJb2tOI/h9
IPV38h2028Vu+gH1758vpX/3DVReZY5D6+vAHXJ/8x28eJi02dXmOOQ+/73y
I0uBA1vjVGdujTkOQF8sLuAscHgPco/WHIfyfUADJBF8LaC55/ghfHOgectm
H1HYwFQAsU9+jkP/oa8aMY+h5stA/X8w32G1TFTKbok5DuqGHGtk5uU7WN/3
7xUXh/qnEsHXv6vC1piI4AsDg2mhZz4k3IH8tzX2pnFGEPnpktDwks53APr6
gJc0VD1nvsMakH2yUPX/8hymOXfnPFeAuu9znsNhIMWvArX/bR7EfA0EH2iq
drs+gg+L33cg86ow+f+A4atWMMchDGTQ9DyHH8GPl84uhPpnK9S+kjkOslEp
1vcvQ80vn+NwUen2z7pPeZDwqobax5vvAPKWdj2Ur5rvEGG55cS3ZijfMN/h
Akhf2xyHapF17g+d8h22nCjbJ989xwEUXXcjEOkZAEb6SXE=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3fo6cIdcfoFDhOWWE2WBcxxynv9e+TGvwCFoh1zr
a+c5Do+Xzj6iUFPgkCfUfMDLco4DUNW++dMKHKzv+/dON5zjkDHxbY39xgIH
2agU6/uacxwuKN3+WXehwMGLh0mbXW2OA1DWNO4Lgn+14qWaIU8hnJ8Lsk+h
0GG3Jw/TavU5DltB5hsVgt3zTWuOwzFv805Hl0KIPXpzHMDuDS6E2GcM5ccX
OiwpsOW6bj3HAaQ8IRvKB7oXrC4Von+/wRwHj4dVIutCIeaXacxxqBZZ5/7Q
CmqfwhwHBhAAugfsD8k5DiBv5v0rcHgE1HZcFBoe1xD84yALVyH4IOkNLQUO
bI1TnbmloO5JhYaXEtT/bgXgcJTXhoanWYHD92CgyWYIPjh8XNHkQ6B8oH6Q
N44nQPlpBQ7A4NNuz4Ty2yDy7kVzHKaDIm5dgcPfKxUvl5VBw+s+gg/2D0ch
nA8OH81CiP5iaPg5F0LMz4G6P64Q4t9URHiDwzcGwYelJwBYyBTv
      "], {{262.945, 
      1813.8039999999999`}, {273.508, 1813.8039999999999`}, {
      273.42199999999997`, 1815.273}, {273.25, 1816.3039999999999`}, {
      272.99199999999996`, 1816.898}, {272.574, 1817.8229999999999`}, {
      271.953, 1818.5539999999999`}, {271.133, 1819.085}, {270.309, 
      1819.616}, {269.449, 1819.8819999999998`}, {268.555, 
      1819.8819999999998`}, {267.18, 1819.8819999999998`}, {265.945, 
      1819.3429999999998`}, {264.85200000000003`, 1818.273}, {
      263.76599999999996`, 1817.21}, {263.133, 1815.718}, {262.945, 
      1813.8039999999999`}}, CompressedData["
1:eJxllH1Ik1EUxoeERoZFiRu0D6exRWJQEBIRHRP6QEJaUTGsxubaaqZ7bySx
JJCITSJDYhZ1LaSyhCiJxCwMMcvoD5EoRkTkDLEIsQ8yKorux7ndZH9s7368
9577nOc5d05/vSeYZTKZPOzDn4XdJNyaQ2D6+pPKsgCFl0c/uFauIrD2bdVp
c5TCoclfXZ+9BLbMzyqJN1AoiRe8GmnSvPjEwLOOpOZrF4cKuzsJpGP5tzYd
oXDWMmdnXo/kYUKhsqy53PcI37P6iXLfxOgIgfu8QC0Fbw07OUVg95q7Txv2
I78hMFr0+sdxP4V79pMft40RSFacqg1Va/7zggnfoVn0U6rZw35E3BTecYHj
WK8Y+5nA85wU2PfDy+8J1C9ijTnw/CkCTG06ZqewnK//iv3aKPTx+j8JfN/O
KlspTDWuX703+7DUw/jL863+hZZM5v6es1AQ/gdIBqv1wr8Imb2/UbOVC4wT
qON6GQ9+W1Z9pgXzs6PfSezfgf1fIHA1um7eLtZvM/efSk4xP/JK77RPtyMv
xXqXpD8zbs3KX8VCv0ezjevy4jyx89pYXpM+7K+VwG+mv7OGwjFubALzDKOf
MZyPg5hPULPIc6Nm/ki7UF8Q6+dgf3s0K72Ks5uSFblunO+5BG5yI4sx31wC
43xemT/MhSvRBUTqcGB/+UT4vs+O+SzB+bFhfSf6YcX5XqHzEn5vyGSVv+iv
xchgtV5wmzF7/w3NYl57DNm/Dft5YMAn1n8v0z/GytYNyvrmIvT3MZ7n0qz8
+v+9uUqz8M+L5w/J9b0+ZFU/gDxgyPvG8tnMg+s3xD1zhNCvPkPmF8J5Rf2p
MM73bUPmfQD97tIs9ndoFvf3vOThsPZP5BlCTqA/EeQZ49//l5oPxX8BQZpY
Ug==
      "], CompressedData["
1:eJxllHtIVEEUxheDArUE8VlZupElYrEQWKl1RK1MQtzwQVrkaqyb2yrOTbcQ
KUJUIkzKJJoQrJSCROxJf1iYZPVHGBUSQZJRImKbhEEPt2bmfssQLexefjvn
zHznO+dOgqPGfijIYrEUiq989l4aiR+wGpQbGpTcUs8pwCVbbj+tL+a0LXj8
Sm2k5qqO2cbtIQb5+p7kpZZzEr9tmX5GV2szgsednCbyz3R5vphcXM2pyxN+
6tF7RnH7KtMmPNj/OaOF197p3lpOb7zTibZBzTs/HI/o79as4s8yst9f1Vxd
w6lhqHv5xmam9Hx3c9ol448xGrO++9F0mNOylMHLPsZoUvw96tQsw0YrNT+e
X18WVo7zvdC3H+edYGZ9pZx6cu5+W2jF/iWctgobhi4yuiMe3YWcjkz9uj4n
9KfJwu3QN2vqq8/jdOCBcHaNofTPZOP8DMP0MV2zirdplmnJSZykrHybQRH9
whkr9MYY1Jl12u2Mw3l/GEkZ9hjwR9QfifgRzcktUW9f3NQsZRWchz9R8L8B
LPZrzTz4aczDlK6aWKw7kR+L/R2aLfJTplnpKTb7NxOD/L3wN5rTNen3jv9Z
5afq+ACr/UqZ6ccGThlyPl3wex3mr8nc754V6+cYvRT988ehXzcY+eV8rQCP
aFZ9Gdes6vuM/JWYtzlGX+X+q9GfBcynFfoWGWb+Ws2qX0maI4X+nymo9zfe
Hxvq9WG+N3Fqk/5PmvMVvRn5zxgtPtmZFZKOee1BPkFvI+YzB/U5zP75cjm5
JRfBzz1Y381oWLwP7QXgbEbiVGtpkWZZT2LZv9xbAT356K8L+iug34P58sI/
hvdB9CNw36j4W5qV/mHN8QN1VR2vGLlEXx4e5bRU1jGFeTE4Jcj1eTCDn370
v077HWDVryWa5T3QHmyY/tShvlD0i2F+wgy6IHhK8Ki878IRb+j7MaD3L4+U
iug=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQrbChKGOieqmDJw+TdnvZHIcqkXXuD+MQ/PJ986X0
u0sdHoIkCuc4HPqqEdO/BsI/njbHYbIESxjfyVIH7Xaxm+di5zhEpVjf978O
1R+M4E9z7s557o7gr5GJStltP8fBluv64oLzpQ4RlltOlJnPcdACmbO/1AGo
qldcf47D46WzjyhsKHV4v/yY93a1OQ6HQfbPKnWYCjQvXQFqf32pw78rFS/V
ZOY4gP2TDLVPfI5DNcg/LqUOj0DuFYWqV0bwrwK1Gb4pgfPB/jtQ4pAx8W2N
vfQch0+XfJMEFpSA7TcH2g92TksJxL36UPPKSxyWFAB9YonKD3dF8HcDA2S1
L9T/9RD930Kh/u2Hmh83xwHo7el5QPsuKN3+WQcM3x1yra8Dt5U4AG3bNz8H
qv9iCTh8phdA1QPdz9YIDJESaHxxIuIPPX4BL2/ZSw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQHZVifd9futTBi4dJm71gjkPr68AdcrwIfs7z3ys/
/itxEF3n/vBX3hyHTseEpxc+lDhMc+7OeZ4zx2HribJ98x+VOGi3i908lwXV
f73E4d+Vipdq6XMcdsgBRc5B1SfOcbDjur644GiJw1+g/LKYOQ6TJVjC+A5C
5UMRfJD+Zb4I/lSgfLrDHAeh5gOnFp4ucYiw3HLimwnUPQ9KHJYU2HKFa89x
4NPdNPf91xKHD8uPeW9XnANxl2ApxHwZqHtMEPzHS2cfUfBD8L3NgSYmlzqw
NQJtlJ/j8OmSb5JASSnY/OsqcxxAyje0lDrs8gQGkBbUfb2lDnlAh3kZI/jv
gfabOyD4QUCLswOg4VMP1R87xwEc/kD7QP4pS5vjcN+/d3peANS+HCjfAhEf
6PEFAKyuxNA=
      "], CompressedData["
1:eJxlk2tIk2EUx4eQxbogEhQ2p1ulwpgVVlIhHfODXYjKPlSaWZtzb8y2Qeys
G1F0wyKiwhb0VB9SSwQLC7oQKhUZfurKPkh0IyUkLKGwBOs8z3PGA/rCePnt
3P7n8rp8kYpAms1mW0U/+S6xJ29E9yOsmZbmOYUCUryWeLJPwHRvx9WhBEK8
83rW7YgA6/z3Qyvvj/NPGh5+vd6X0W/43b5veYuGERrLztQHYwLKPx2Y2T6K
MPaWDHsFVNau+LBhUhxmyDpR9rfHwUGGmrDhrcvuvcCQ4WwZaAlovvIs9056
HFDqq+P8/xAuUb2BWgENpTu/vhxBGNn8pXmOX8CTXwXbz/1AGLr5fF0x9Vc/
MNr6s9/wcirT+d6w0vcGgbK4q/ycv0frbwmwnseo9QfZfheBos7O2s32dsMq
X6thNa8mhIoHzhMh6of+ToSvsZ3yPZV6L6CeB/VDqhpKT3J/NWZfSs82w8ru
NSz19xUIrfMgQvrRxrKp8wXskf0fQT1fN9c/jvCIFtiWK+CVu+/P4dOaPTlC
3cGCi9r/d7YAm3wEqrvocghokfu4xft1sP/DiSz7S8zmemOxCZzyV/oyTLza
txP1/h0873yEpmiJfYtTAI1xcFMhz5P07pDCixDkWnNcAlZL/yXc71wB1dJe
zHrmcT7iSOax7t58w2ofXsMqfuM4e5WARJgCl/K972L9i5n9/P0U6XuJBHj/
C7XewTrel0f3kwzyfeYhyLS9Fs/PhSDLlqfuK8uw2kem4csycIrmHsvM97Nk
yv9R8t+Ynl+I92eZ7/c/76rdGw==
      "], CompressedData["
1:eJxTTMoPSmViYGDQAmIQHZVifd//fIXDwyqRde4ycxxgfCDZO11ijoNWu9jN
c8/LMfgw9ZMlWML4fiP43uadjgmCCPMUNhRlTFSscJjm3J3zXBbK165w+Hel
4qWa4hwHWZCFhlD1ylDzTCscpgLVp2sg+J48TNrtBgj+I6D64+0I/vfgx0tn
90HtN65w+AHkS0+e4/Dpkm+SgAHU/KlQed0KBz7dTXPfT5vjIAOyX70CTMfP
gLpPHur/mVD3CVc47AI5YPYcB3eQQewVDhGWW058m43wP4wPCx90Psi/y+Yj
whedj6J+N4KvDeIvRfA9QPZPrXBYUmDLFT4L6t5uiHvFp89xqAZ682ELVP0U
qHxjhUPC0wtKt/sRfFj4wfiw8IXxwe7ThLqvucJhy4myffKqcxw6HIEmtUHN
V5rjYMt1fXFBZ4VDnlDzAS9FaHj0Q+2Th5o3vcLhL8g8Oaj84gqHw181YviB
6aH1deAOufWI9ALzP4wPANkoK7g=
      "], CompressedData["
1:eJxllG1IU1EYx4eFxCqpiE1qL26OLRKxPlmI9sgIK6nRejGWkkxtdzp1Ca2d
iwQiYRFRIuYHTwTlC0GERGRESPS2iIiKQkLEzA+yImZJjRKtc859LqfYYIzf
zjnPef7//3OvI9jqb8gyGAx+9uW/p8aubigKE0gNP6ssrqOwucv04VUPgZIp
3wVzlMKjH5uqLz4gsHtVVkFXjEKpcfx6dEay0v21fUda8j3bmS/7V6gwra6/
VXGSwmD/k7wRk8aJNgrXdt6dX3ThOqvPrulr2aLCfV4gQqF5duHGt20qHNl+
53nsOIUI5zIVXjsnfp0OUsgpvH0lVa5Cr/d8JFQteeldPOk+KFnoKZTsZ401
eSjwsmNerJePeirwPgeFRGXxufI9KrSu63z4wo7371OBdTut2iiU8f2HVE2v
FesfVSF9YGaw30LBwD8K9sN4FxdKMpn725dLQfj/lGSwvl/495L8f35SctGk
K7sjSaCF98v4Pft76xzmx/qt4cayfIR+O+pfIDAQLTVWOdD/JY3HmR95I21K
9x9kF9YzaP789EjW/dVZ9O+XbA3Ul0wFcJ7YfZdZXrO1qG+ewCLrf6iewhue
w2ei5amgnxNEm49GzCcheTVfH5YscjxLtP4asH4Y9dVI1vvVObuj17uS6XnM
57uRwE0Lazgf820m8InPK/OnJ3f54ZwTBAq4DjvqixHg24/ZMJ927f6YFet3
Yp4W9PeSzEvwQCbr+Qt9qXgG6/sFpyV/5OeNsp6YVxPqt6IeK4E5pn+U9f/9
7d7gGhfOhxP99eD9bsm6X/+um32ShX8B7N+t7R+tRdbr12F/TqLlxPLhY+Gz
E+BjaA+hXxsxvxDOqxnnT8H5Xot5hykMcb+NksX5ZZLF8/s7rr1vFOmfyDOE
85WMa/404XqVfH/p86HzX11JUvo=
      "], CompressedData["
1:eJxTTMoPSmViYGAwAGIQrbihKGNia5XDkgJbruvFcxyiUqzv+xtWY/D/Xal4
qVYwx+HTJd8kATUE3/1hlcg6aQRfq13s5jnhaocLSrd/1uXPcdgh1/o6kK/a
4f3yY97meXMccp//XvmRo9ohwnLLiW85UHm2ageQMe7ZCD7YvEwEP+Ep0MS0
OQ6TJVjC+DirHX4EP14qnTLH4dBXjZh+oPnTnLtznifMcVAA+Se52sGTh0m7
XW+OQ6cjUOcOiPnHk+Y45IDs3weVT4P65xDE/OhMBB/mHhi/fN98Kf0cqPsP
VDvw6W6a+x7I7wCZDzMvF+r/3VB+HlT/Dqj/86Hu21ztAAzV3un5UP+sh4YH
kC8LCvClaOE9A5OPEj/8NRh8mHqg6OICxhpI+ADNlwEp+A71D5B/GBR+n6od
vIDuZQe6Fyz+shoszg/0XzUwGB4+qHbImPi2Zn8G1P03Ie4XT4G6J6La4REo
fEWh8u4IPtg9R6vg4Q92z/4qSHinQf27s8ohCBTRGdD43FIFDo+yLKh71lc5
sDVOdeYGugcUbHkrqsD+iM+Fpo8FUPV50PCfDVWfD3X/pCpwepkN5MPSOyx8
ADFZZlA=
      "], CompressedData["
1:eJxVlGlIlFEUhgcLg7KCEjVT0zSVhrIFMxvUo6bWaIqCa+pYuWXqDC0adm8k
YtJG9MP80U1pJxSJiAwNWwyVfkRRESEhJiESZREFFUp3OcMhYXCeufe7533f
e84XsteZU+FhsVgK5Uf9vzfaMNhl4fDt1nB63xoBrZ+zHwSNMXi5euz38SAB
y1oeP78yxOC6K25hvr+AyRuXngX3M5iR+2NWCIhVB3QzePozsvi8rzDPCbPe
5yPgC0uILj1LXNq/08vjEPHbo9PhG0sZlH2ST/oJCCwqt43vYjD3Ri4ECtjw
IcyzOY6Bd2/aRFOIgPSYU4ll0QzUMdYIYq1n/f/r3ZuQYxmo7W1bkBMZfGzy
7h2JRX0ZDCYkp8ULqL4gf3Gg/yT028SgQBlNxXzake0Clqy7e3nmCQNrm8/7
zCwB7jztst6CXOJZ6edmAXFPQFH5wB4Bx5SxP+a8X1WobwbzPoB5TDKt61E9
5vca67vw+YfEOs8e4tqpv7e/d+J5TtJvG88651snoE6tn2ZQry66Buu1Mmgc
7PKPqibW+VSg/pOYp4NY5eAsFhCl7quFwZDsh6VF6IczaE8+U1sl/etzG815
I3kCSpQfJ/rPRT/lxNrvbmKtN8fk/SIP62egHnm+tNVRn4p63fWTmdlXTKz8
dziIlX97BerJYuDZLBXXYH9UUn46D27OW3VYgGqPO51YvwH1jxJrv9PEel7m
cdO/R1C/Hzf3dVDAsBIUyUG2h83hwv2buZmHOrw/Gzf5yftZrPovgcNFme+U
1P9V6U3iWv+iMmI9H/nEOp+txHp+ozDvZNOftrXofzvujxSwQ31J4abfw4XW
OZ7G4ZWcl7kw9G/nJi/JFvWXyWFAzWOogOXqfZKN627OJd6m/BYSxy98d81V
gvpCMa8ynK8wzKsS/Uu+mnL/x6wLn49APSeQrcTu952+n30c9qv5WimgQzVC
Kubrg+8/K7GuH0Ss63tjfV9c98L78sd+nc/NfAQgy/nX/RZM7wO3nn/F8Xad

      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQveVE2b75DLUO75cf8zbXmeMA40dYbjnxzQ/Kv1Hj
cFHp9s9/XnMcls4+orBhX41D+b75UvoecxyqRda5P9xU4+DJw6Td7jbHQTYq
xfr+3BqHH8GPl852nuNQBZLvq3Fga5zq3O0AlW+tcVhSYMsVbgvVX1PjsAtk
gNUch7c19qZxFTUOQFul1psh+NOcu3OeGyH4IPOl9eY4MIBAXQ3YnfJacxy8
zTsdEzprIO5Xg5o/BWLfdWWo+kU1Dg9BDlOCym9A8MH+OorgW4IMvl/jYH3f
v3e6KiJ8YOEFAGwnj2E=
      "], CompressedData["
1:eJxlk21Ik1EUx4dEgoWFjRo152Zl4hpBECMqOimxUsIysBcjc3NusbVJ5Yry
XoqI9WYhshZ0YwVZRqQSFRoxLc2iDxERRPTBTEJCTAp6gSA69z5nXcgPY/w4
5znnf/7nXIc3WuXPMplMpfiT/yXxue9eZnPYODPLGY8JyHA5crZXQI/t5PiW
Ig6H0qn5XVEBc070v7i2Xuc7Zb5f83BlSzJyUPOT78W7LhzjkCg7Gw40Cfj2
epN39hkOf94c/lx0QIBn5Ii5s41DruvulclGyr/EwbqzflVtRPP2lfeex0Ka
8zE+HBTQZplWnZvgEJP6Gqj+eQ4Xsd9YvVC6l8U5/No62r7AJyA89vvWV85h
8uZQhRvnk2UqmzSPtl8etIc1b5D66jjs+fSqsMZH9asN/Tf8AgaknnLSH6B4
KQes2jJvL+ldrVnN69b8Qfq1nEMVGh3CeU6vw05LKY719km9dvID50EX0ikz
zVer96X07NCs4i7NUv/7YgG9cp85HKYfT5TNWEzzzyJ/C6l/HoeHuMDbdgFH
zZ2eEYvBzgIB9u79wVaHkf8jX8CX5rUrdpdwCLZONPdZaR9u2q+V8j1TWc6X
tFC/c2wKZ/KVvpRmVf8OM/ZvJb8fMLjeuCZnm02AXF/3I2b4iXor3FjxMVO+
FTgof5AZ8y6k+FPqv4jiQwyieXjoSzSrfbg0q+83/xevEYDu9tiwnrr3OtI/
QOyj94N65L1E/fRe0obe8QZ6T73GPG8D9P19BhGpJ0j+dTGQZ+TJ3FeH5gm5
j6ualZ6kwc+C2t+PkgPEp8i/EPn7k/17v38BMBvcQA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQbct1fXEBd73D++XHvM2XzXE49FUjpl8Mwf90yTdJ
QKHeYY1MVIr10jkOvLqb5r5Xr3d4WCWyzn3xHAfLLSfK9unXO2i3i930WzjH
wR0kYVzvwAdSNw/B/3el4qXaHAQ/4ekFpeiZCP0RQMa3aQjzwfwpCPsvKt3+
+W8Swn1ePEza7EA+zP0wPtDVnY4MCP7S2UcUNnyrg+sH89/Vwc3vcAS65Fkd
3P7c579XfnxUB3cfjA9zP4wP8x9MP8z/MPNh4XMBaG8d0H5Y+IH9w4AIX/Tw
BwDWsMWu
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvXT2EYUNOvUOnjxM2u1lcxxg/PfLj3mb6yL4F5Ru
/6xTn+MAFO101Kt3KN83X2q98hwHW67riwsM6x0eVYmsO644x2F6nlDzAZN6
h2nO3TnP5ec4eDwESljWO4isc39YJTfH4WrFSzVDB6h9snMcOhwTnl5wq3f4
Hvx46WyZOQ4zQPqD6h3+XQEqBPL5dDfNfZ+Mybe+7987XWKOwzKQ+zbVYfBh
6sHuPoLgg5TlXYCqh/Gv1TlEWG45UQZ0z6GvGjH9d+oclhTYcoXLQf33sM4h
c+Lbmv1A/+Q+/73y45M6hw/A8NmuCFX/AsoHhscDkHmv6hzYGqc6d6sj+LDw
hPGBsjnpAQg+KJjco+Y4ZADtsX9Z57ALGECrE+Y45IDsewZ1b/Ich8kSLGF8
T6H2pULD81EdOD7006H8e3UOXsDwZc+A8m/VOQBDWel2BjQ+r0Dty4TGz1kE
f4dc6+vAYwh+VArQ5r0Q/vEMRPiC4xtoH9jetdDwyobypRHpCQDygiM7
      
      "], CompressedData["
1:eJxVVGlIFEAUXoQMrMxCvFLz2FQS84A083qdomKi4tG26WoubuaxhJlYNCMR
FhERYRKNSFhGZBYSGRkaJRr9MLuQEgkTky7sQCOqpTneNiQs7rdv5r3vfe97
E1xel2d1MRgMO/lH/DdVJL3JiaHw5cpwVt8aBg/nI8ynAyiMhUz8PBLI4MQm
y8zYCgqX7CluRX4Mvj3LLvdYRmGOn0/wZRAgEiyi8EDc82bq3m8i431eDD4f
Tltf8knjkrsZS12ea/yy8X1Y7AABXiVkwgfzXSfgeMEDAQxiJo2uze0EPHvS
p5qCGWQlcEatBESayHCNJZ91/8evxSE+T0Acb4lHfJHA2ybPnpFE5NdNYIrj
9FQGtjP8l0Gi+tjMYPryhaGg1wSKE289atjO4NjH3DuB84gzGbR4vRr94UEh
kn/ZkcPAqWcmr7e4QOM/vJ+uYo27/U0V/WUMUt3GO+1RVOZbqGQgyt0MR733
MXCP6m2fC6aS12At6uGrzjfYGaSI++4aV92rP+vjqnH17K+rXx1E5avT/DmL
U941DGpE/AOB2pVH7z+uQv1nCBwc6PCLtmks9bEy4FkHOt6hnqUaC551ZgbR
gt80kT5abkK9Jwm0bjlZXcn7l3nHVb6RQga7xaCeKD0XuF6HxKCHNJZ+6ddY
8u0lUu/RQqzfjXx4ft5WW20X8nXW7yTqnFlj0X9bqcai/0wr8rlBwLWZM65C
fwxr/aQekyrf6nqclwPrN+A8POk/nCzqGDWW92Op8u8B9EMyzms/+m0rBW6P
pFI7ns+gah9qcD+zqdLPhv7LoXCO6ztrRX1zqeS/xKKx3I8ijaU+GzSW+xuN
/spV/kxay6BRxPPwfASDTq7DeB76PQz9mU/hKd8XhxH9XID+5dgg/ooo9It9
DMX3pBjjHB8X2KSx7NescaAwbAnyC0W9LLhfRtRrD/ZvxPfHhvfDcR52xJEa
O987OZ8yCnvFfq1CP+Sjvl7Id5vGsn6axrL+RqzP379dIh6P8+Lv5e3vfPPj
qNoPf8R8/6XfgvR74OTzF2CIdvo=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQHZVifd/foMHh/fJj3uY6cxxg/AjLLSe++UH5Mg0O
F5Vu//znNcfhsm+SQAR/g0P5vvlS+h5zHOy4ri8u4Gxw8ORh0m53m+MgC9Lw
t97hR/DjpbOd5zhUiaxzf/iu3oGtcapztwNU/mm9w5ICW65w2zkO1SD5O/UO
u0AGWM1xeFtjbxp3o96hDGj+ejMEf5pzd85zIwQfZL603hwHBhC4V++w5UTZ
PnmtOQ7e5p2OCS/rIe5Xg5r/BWLfdWWoesYGh4cghynNcbAFuZ8DwQf6tne6
EIIPdq98A0RcFRE+sPACAE/tiK8=
      "], CompressedData["
1:eJxllG1IU1EYx4dBhEVkRJPai5syCxsRfYio4Ak/SEVIK0iG0ZjalkoOsWkW
cS4pi8pesT54og+mfigi0pqIifS26kNYChIRMUNkRClZrQKt55z7HE6xD2P8
7j33ef7///Pc6wrW+aqyLBaLD3/iP6dsc9/zXgbTPc92bargUD3YcCX3BYMt
H0rbrBEO8dm5sab3DHYsySqKRTlcLT5bOzWj+fT2wOTIb82ju4PLyhYYkGxe
cafkKDevZ5ucqOfQ3fEk724O3cf6SPVhqwED4mAth3X3rk/3rDZAyIoeInYY
MOJ+9+tkkEP5hUff1+QZ0I46QuWa58eaUp59mqUfr2Zfv6O1ppDD1zco0EX1
8rmsM+Wmfi4O/kp0XmBA3fJTwy+d1N9jAKpNNjvI/1rD9GWn+l4D0ns/dnXY
ODQO3Vi1fiPpQT6W8mxYtDWTRb7XcjnI/JMsg9X5naLPJPv/+S+al3pR4CyD
I0Ivssw1TfNDvV0ib5yP9O8k/3MMbka2Ze93Uf7zJo9jHrGVb1+lFRdQvT9M
5vOjULPKV7HU79NsF0H6aZ+wn8wtQP5+MsCtSnVXcsAunZFvzJxnmPL8zMw6
1TSfCc3y/qhm+fxj0ldF9XvJ3wHNSq/ihUZ78WL080Dsdx+D2zYUnE/zvc9g
Quwr5uNo/bSnP86gSASD+YnrJQMMxPGDDprPQ7N/1E71hykPG+Wb0PN6Kvh1
Jqv5S3+NmazOSz6uWdZv0Sz39Qz5t5OfNgYz6D+O+mUOl2g/3JTvZern0azy
+ve+tVSzzM9P/el8PEB+VP0Kun+Rme8bzqdT7NV5BpjWkDNEeZ2j+YVoX0n/
eJj2O0bzPkzfkxbN8nmmWb6/J0xOhHV+cp4h4gbKp4b4lv5+qf1Q/Bfz12Et

      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQfdk3SSCiodFhSYEt1/WJcxxQ+MVzHNrFbp77vgoH
PwdNPRL/w/Jj3tsNEfx8oeYDp7TnODCAQBOUrw6Vb4WqV53jMCMPKNHR6LDb
k4dptfIch8dLZx9R6G10+Hul4uUypTkO2z4DWZMQfJmoFOv70xB8sPrZjQ7a
QIf6AfW/B5prPh8qrzLH4WGVyDr3xY0OXjxM2uxqUPOWNTqwNU515taY4yDf
+jpwx4pGsL7tWnMcbO77907fgOBPc+7Oeb4awjdXgbp/KdQ++TmQcJgDNV8G
Kj+l0WE10KG7JeY4AL2l3d7d6GANNFdcHGp/E4Lvbd7pmFCD4B9R2FCUUdbo
wKe7ae57cah7CiDy0yXnOEwHhVdWowOI8pKGqk9rdFgDsk92DkRdciPE3QpQ
9yU0Ohz+qhHDrwK1Px5qvgaCD3anPoIPi1+weU6Y/H/A8FUrgIaPZ6PDj2Bg
TBTOcfAB+ScQal8JNP1EQM0vn+Ow9UTZvvkJ0PCqhtqX3uiwC6Sgfo7DdhA/
t9EhwnLLiW/NUHmg/y8o3f5Z1waNr5JGhy1Ac+S754DTkXkVIj0DAK9wVgg=

      "], CompressedData["
1:eJxllFtIVFEUhgcLHzRLystoXie8VRZWYBetFRYhIuGAKWlQZpgXVNQmkQjO
DpGIkAgzaIcPldGLRFRKhEVJGmGZViJiZlQiQ5lGWkrSvvzjJhoYDh9nr3XW
+v+1dnRBhfOYl81myxZ/+fRLvHN1chOj9GVe6xpcnDycu+1ujyuH08HCHaP7
1xuevPksIzmO6ecRTpH17qyOKEbXK1N9Bos4nd19+HOfXXNOKaeGoKGXs/6M
wmWicuT3ZvTnTe1EayWnG1e6om7PWYu802fwWuWU4eXy/IRFzo6I+tIKTic7
W0I3frJUPTNlnFLl+fcW9TmGf58u4fTkZ3x+47BFH+sC2rqLDI9JLjT8VDxX
iPpb5fdHLF3fIXxvzNL95XEqeVhz0f4F+XM53f8hKvtm0b0eV2dLNqfp/swC
/3mLhErnm52ozw69MhC/man63Xu4+m4jMTp+4eupXSmG1fkkww+kIQmciuW5
7YwC2vaN1TlQbyKjprRzZUXh+F40o/H5W1NOO3gV0/0HQt8lhlUfv6xFbi5f
eeaxG/oEQf8RsMhnk78hS+lSEYL3bxEfgvz9hpUOrwyrenq1f247/HoBfYOh
d9f/rOKTzXkPq3wiv9JjA6c8OZ/v9Dy44jB/H3S+dgfmV/T3WvS9EA6/Zi1a
kPO1GryULbKqw8+w0juA6fgw1BPK6LvMH8m1j1Ha31IH6luD+BjDyq8Ew4Gi
/rlE9BuJ/UmCviF6Hma2QH/hp9Q1eCunWhkv9sfbakrzTcE+TVs6nuDHKOZz
L/ob0P5NpoN7oWcmuNvSe5EFFvoLFR15BwzLfmLz/+XWo+jnOfwthj4D2E+x
75flfI1A/2rsg/DDc9+o8/OGVf1e5j7KSBaO+jK1B49OYD8Ccf/U4H0YuBp6
RmlurzJ6e1j5FWM4TA5ILNNxVegvHn5VY34SGF0SPC44Qt53a3G+xtyPnnr/
Arfkgg0=
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQHdt/6KvGoSYH6/v+vdMz5jgcUdhQlLG9yeHflYqX
y1rnOFS+VDPk2Nzk8GH5Me/tE+c4CERYbjmxqclBJirFOn7yHAedTXPfLwfy
2RqnOnNPRfDfg9RPQ/Blgervz5rjsO3z3ysVW5ocgnbItb6eO8chBmT/jiaH
JQW2XNfnz3GY5tyd83x3k0O+UPOBUwvnOHQ6Jjy9cKDJ4WGVyLrji+Y4TAXJ
H0PwdUHmn0Hwj4LcfxGhH2z+VYT57WI3z32/gbAfbN4tiHz4bAQfFB7iMxB8
kLfLJs1xsAGF080mB6CrlKJ7oOFzvcnhEch+YHgJghSeRoQnAMSUtf8=
      
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQ/bBKZJ17ZZOD9X3/3ukZcxwegfh5EL542xyHy75J
AhHZTQ67PHmYtPvmOExz7s55ntnksBvIXz0ZwQfrn4bgLymw5bo+a46Dzqa5
75cD9QftkGt9PXeOQ0z/oa8a+VD5+VD5oiaHfKHmA6cWznE4orChKKO8yQHk
ruOL5jgcBfFrEfz3y495mzcj+J8uAR3YgdAPtr8bYX6nY8LTC/1NDrJRKdb3
gfYLRlhuOTGxySFj4tsa+9kIPoj6Nh3BlwGqj586x6HypZohxwQov3+OAygY
2nug6luh6hsR4QcADe+eHg==
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0,
       1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1,
       3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGCwAmIQXWNvGreLM9YhwnLLiW+zZzvA+P+uVLxcNn+2g2xU
ivX94AQMPkz9/vlS+nd10PgMCP7DKpF17gfjHZYU2HKFz5rtEPJ46ewjM+Id
rO/794pPn+2wRgZoYH08RP2U2Q4z8oSaDxTFOyQ8vaB0ux/BfwQ053g7gv9h
+THv7a4IPlvjVOdua6j5CfEOIGEv49kOd37WZe2xgZqvA3WPZLzDLk8eptVq
sx0qX6oZctyJcyjfB3S44myH2yD1LXEOQGntdpnZDntLJkuw6MVB/C0+22Gh
67bPf4/EQuRFoeHlieB/04jpP/Q0Bs4HeePntBiH+qw9JcLiUPnYGHB4qknN
dvBLEoiwVImBhIPsbAegM8v2scc4ZEx8W7NfAcF/D/KvCoJ/EWjsP3Woe0Ri
wP4r05rtYAWS14+BhC/Qv1zXFxfYBsWA/autN9tBFRRQ1RDzzPVnO0wHBdQq
BB/s/zMIfixI4+sYB5A36vSg7meNhZivO9tBWv+uCptiLCQ+tKHmO8fC3Qc2
LweavoDhC/KXfWusA8i78XJQ+SUQ86bLQN1zCsEHh8tzBN+lO+f5b8Y4h92g
+JOFxr9UHDh9XZef7dAudvPcd+M4cHrgVoKmB4c4Bz7dTXPfqyL44PjRRvBh
6QvG/x4MZPTNdqgFxa9lnMMPIF968mwHoCnLj2nHQdLRVJj/oeZPg7qfKw7i
vxlQ815A3T8TGj67YyHxMRsavt2I/AeO33AEHwDZhaGD
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7ZTw9IKSdqLDNOfunOfasx0eL519RMEFwW99HbhD
LjLRQbtd7OY5rdkO6oYca2SyEh3+Xql4uUxjtgNYf3WigycPk3a72myHUD7d
TXObEx2Cdsi1vlZG8JcU2HJdV0Dw84WaD5ySne1QLbLO/WFVokP5vvlS+tKz
HYSBwgszEx28gOaxS852OO5t3ukYkeggG5VifV9stkP/oa8aMc6JDo+qRNYd
F4Xar43gz8gDGiyE4N889z348d8EuP5CoDMWv0mAm6/G1jjV+XYC3P6tJ8r2
zb+UAHcfjA9zP4wfYbnlxDdlhH7r+/6909UQ5r9ffsx7uwbCfrB+LYT7YOGL
Hv4AQbiwhg==
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQfftnXdaeKSkO1vf9e6dLzHaYkSfUfOBTksP75ce8
zbsQfC8eJm12AwS/fN98qfXqsx1unvse/PhnksMFJaBJSrMdjnubdzpyJDtE
WG45UaYw20E2KsX6vnSyw25PHqbVsrMd4nYBGdbJDg+rRNa5y8x2+KYR038o
FcG3Amrb143Jh7kPZOw+4SQMPkw99/XFBbZWCL4MyP50BB/svo4kh4tA9/4D
ukeNrXGq8+wkiHsVZzuAlD1cBjVfebbDHVD4rEly4NPdNDdfA8GHhQeMDza/
A8FfA7K4b7ZD/6GvGjHLkxxA1nRPgsrPgYbv1NkOPkDnJExNcgB5Q3461D/t
SQ6rgfp3z4Dyi6H2zYKGR3ySg3a72E2/2VC+PcT932YjwgOd/+9Kxctl86Hh
7ZqMyj+bAlFvCjXPPw1VvjEdgw8zHxyeMQg+OD3oIvgZE9/W2POmQ8JjFjR+
fqWBw+v4tNngeKh7l+bwF2T+lNkOt0Dh8yIN7L9z/Qg+LHxhfFj4w/iw9MgA
Ah/S4OkRnF7/pcHTI9A1pnFC6fD0qH9Xha3RMB01fcSko6bPRkw+LP1NB5m/
LRWDD1MPju87CD44/XOnwfnFoADSToOnRy5Q+NilwdMjODw90+DpERY/sPQI
48PCA8ZHyb/rEPkbAGZV2TM=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQfftnXdaekgyHac7dOc+1Zzt804jpP9SL4M/IE2o+
sCjDQbtd7OY5rdkOlltOlO3bnOHw90rFy2Uasx3A+o9kOHjyMGm3q812yJj4
tsb+bIZD0A651tfKCP6SAluu6woIfj7Q2FOysx16pwMtAOov3zdfSl96toMq
W+NUZ6D5XkDz2CVnO9w89z348cIMB9moFOv7YrMdFrlu+/y3J8PhUZXIuuOi
UPtLEPzVHy/5JsUg+EUgC90R+rmuLy6wNUOYvx9o7V0VhP3Hvc07HWUQ7oPx
Ye6H8SOAAfFNGaHf+r5/73Q1hPnvlx/z3q6BsB+sXwvhPlj4ooc/AL3mtco=

      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQDQYVuQ7W9/17p0vMdthbMlmC5Vq2w/vlx7zNuxB8
Lx4mbXYDBL9833yp9eqzHVpfB+6Qu5vtcEHp9s86pdkOxRkT39a8znaIsNxy
okxhtoNjwtMLSv+zHXZ78jCtlp3twHV9cYGtXI7DwyqRde4ysx0WuW77/NcD
wY/bBVSYj8mHuS8WxP+ehcGHqTe4q8LWKJsN5zuB7PdG8MHuy852uAh07z+g
e0B0XR3UvYqzHdQNOdbIdGVDzFee7QAOnwnZDny6m+bmayD4sPCA8cHmdyD4
a2SiUqz7ZjtsPVG2bz7QPLbGqc7dk6DyDdDwnTrbocAWGCIV2Q5A2/fJT4f6
F+i+1UD9u2dA/RcOtW8WVN4520G7Xeym32woXxni/m+zEeGBzv93peLlsvnQ
8NbIQeVvyIWoN4WaZ5wPlweHj1EBBh9mviXY4Qj+oa8aMf0cCH7v9Dyh5g/5
kPCYBY2fu/ng8Do+bbbDN6DyQxfzHf6CzJ8CDZ8z+WD/netH8FHCF8hHCX8g
H5YeVUEBfTkfnh5dunOe/36YD0+PQs0HTi38mg9Pj+9q7E3juArg6QPmHxgf
5l90Piz9gc2fmYfBh6kHu+8Agg9O/+8Q/BnA4DnAlw9Pj/qg8FHMh6dHcP7S
zYenR1j8wNIjjA8LDxgfln/B7pmIyN8AQ32qoQ==
      "], CompressedData["
1:eJxVVGlIlFEUHSQsKmxBZszUNCcdlLSEMhuqa5GSVlLgNphbDk6aznuTmoxS
iYSGlZktwqussPxhSIvkoGBhoSEiFv2RCLEQqQhbSOiH0lvu+GhgmO/MW+45
5577hRU6j9p9DAZDNv+K36HU+AuJMRR+dA6l9m5i0Fa+tv7lMgrjGz/8PRPC
wNHyvXbPTwIdZNfyzEAGCT1vqgZmCMzy/fHrGIjj+RMEBv9YcppNDD4/YK9D
R9R6r5GBQXz6NBbH2+9qHNVgnBhrIpA/zSsGMIj9aPatqyGw8L76S0Qwg/Pf
jnhCSgn4dydPucMY5PYdWOlznID4iY7UWPKJ+X+9K47BMfFQTEBsb9iO2Eng
k9u/ezgB+bkJTHGcvJtBjSh0kSj9e1FvJ4Es8ZCE/gwiTmEQ+tjlaJklEM11
HE5j4PUzhddbmq7xPNfzMEvjR0G2ov4CpupYqLxvrpjB/f3Pf88HUeV3Kfqx
hso+vChH/wxqfxVh8Fac/0oWseAxNqGx7Mso9s+p+Vsn0y6ZynDdQ0D8PVKC
9Z4ROD3QHhjr0Fj6Y0f+PehnnsZ+m5/eduZgv54QeMXvXWXDfnQRuL6v6WQx
18/TMj3eoe4bzkA9txTfuXTUc1Vjud6oseR7Tvk9xs8Pi/pu5MPv//XuUOHq
CuRrQz8JUffkaCz038zTWOhPsWO9WgK+dZxxCebjmvZP+tGl7ttQwcATwhWP
Yv0q7Oecxo1Cr5EuYjkvW6nKbyX6l4T9dDEIthVZJ9Mp8HhY8wjuL6BqHsqw
fw6q/OP9CRP5K6Nwg/s7Y0e+hEr+K/I1lvORqbH0Z4fG0tdY1E9UPq1RuO7C
/RYGgl7aKaryHsFgi/Cjksq+LZhRfzXml2MRq3s1FPpFDMLxfXIW1724XmOp
t0Hj1oAlGX5NyC8c/bqM82VGv1pRvxn538HzkcinG3G0xt73nczjFQonxHyt
Z8DZbMutQH+NyC9bY1n/oMayfiLWN2Eed2K/+PtSzEFzHFXzEYT55fMv8xaq
3wdePv8AgptoHA==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQfczbvNNRr9Dh/XIgS2e2A4wfYbnlxDc/KJ+t0OGi
0u2f/7xmO+yQa30d+KbAoXzffCl9j9kOF4DidQ8KHDx5mLTb3WY76N9VYWs8
XeDwI/jx0tnOUPk9BQ5sjVOdux2g8psLHJYU2HKF284Gm1u3qsBhF8gAq9kO
DCCwrMChDGj+ejMEf5pzd85zIwQfZL603mwHoeYDpxauLnDYcqJsn7zWbIdY
kEHbCyDuV4Oafwhi33VlqPrzBQ4Pq0TWuStB3XcPwe90THh64ROCD/J+Am+h
g/V9/97pqojwgYUXAH/PjLs=
      "], CompressedData["
1:eJxlk21Ik1EUx4cfCuyFiKCoOV+yEmRIH2L0Yh0VspJa6YdMK20vPqvVnt0r
LokIQiQkRCJsxSECSyMKixArBSsRDYmIqIQiLCVGWSyNogii+3LGhRw8jB/n
5f7P+d+b7bPLg2kOh6NYfPJ/c/rY1eg6Dtvnp+WfiSGkeIfguT6Ehe67l5MV
HI4PXFl+20YInft6cku9yS+U+ecNz7zY6VvUYfhV46fVa7s5tJecPWo1IJR+
OLGk+x6Hvy9FoB6hKrBx3PuY63OilD/MwSkCNRHDlet7nsTChjNkYQihC4ey
7gxyiEl9ddS/n8MFcV4igNBSVPvxeQ+HXxWTnSv8CIM/8va33eKQvD5c5hHz
HUv8uTHdYXiDOGbgkmGlr42D6JJT7af+TVp/V5D0NJJ+i+I2B1HVuvQwxY8Y
Vv2ChtW+ajmU33c1h8U8772t8UgVxS3Su4v2IeYZKfO0FBXTfDXGL6Vnn2EV
dxuW+t/mISyQOj0c5pxuL5m3iubfRPvNQRiX5wOHPmHgzSwEUfX71FbN+Zmo
7kGBV+f/zEBwyF8lV/fioROhU/oRIH+dlN8wm+V88WU0bx+bxal8pe+pYeX3
G6b9d9K+Jxlcixam73UhPHA1T+35zPQ+hd4DUniSgbQ1Mxthm8yfZnrelQgH
Zfw7nZ9L/QTbi5seja4xrPxwG1b1u/+LVyNcjIjCGabv+yHS/43YT+9H6JH3
xQ6S/1+03qk6ek8JPc+YRfUTDGTb0RDt7x0DeWxp6n69Nqz8eGY4LguHNI+E
zH4nJFvkdy/tL0z+5Zr3+w9A/eQ5
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQvUOu9XWgW7HDkgJbrusTZzug8ItnOyhsKMqYOBsH
PwdNPRL/w/Jj3tsNEfx8oeYDp7RnOwgDqYWeUL46VD4Aql51tgOQt0MuvNhh
tycP02rl2Q4yUSnW9+OLHf5eqXi5TGm2w+GvGjH9WQi+t3mnY0Ixgi8LUl9d
7KDdLnbTD6j/0yXfJIEWqLzKbIerFS/VDHuKHbx4mLTZ1aDmTSp2YGuc6syt
MdthsgRLGN/0Yof3IPdozXbocEx4emEZgm/HdX1xwVwI31wF6v4JUPvkZzuA
rPevh5ovA5XPK3ZYDfTIbonZDktnH1HYEFPsAFTVKy4Otd8LwX9bY28aZ4fg
P/DvnZ5nVOzAp7tp7ntxqHvUIPLTJaHhJV3skAcMTy9pqHqhYoc1IPtkZzt0
gtTzFDtMc+7Oea4AdR97MdhefqD7D4HsZ4Gar4HgA4Nfu10fwYfFL9i8U0UY
/H/A8FUrmO1gCwqfm0UOP4IfL51dCPXPiyKIfSXQ9PO9CGJ++WyHKpF17g/Z
oOFVDbVPpNhhF0hBPZSvUOwQYbnlxLdmKB/o/wtKt3/WtUHjS7/YYcuJsn3y
3dD4tkKkZwAYC0XW
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvch12+e/NiUOnjxM2u1lsx1g/PfLj3mb6yL4F5Ru
/6xTn+2w5UTZvvl2JQ7l++ZLrVee7cAAAk4lDo+qRNYdV5ztYHBXha3RtcRh
mnN3znP52Q4XQfq8ShxE1rk/rJKDmhcAtU92toNQ84FTC8NLHL4HP146W2a2
g8KGooyJySUO/65UvFQD8qfnAVWUYPKt7/v3TpeY7aAPsu9wMQYfpj4qBShz
FcHPmPi2xv4hVD2M/7zYIcIS6DOge7zNOx0T3hY7LCmw5QoHuvc4SOBTsUMm
UN1+oH+sQAHwtdjhAzB8titC1f+E8pWh5v0udmBrnOrcrY7gw8ITxgfK5qQH
IPgPgeHnHjXb4dMl3ySBX8UOu4ABtDphtgPIWfu+Q92bPNtBFuQhmP2psx3i
QAo/F4PjQz99tkMsiP++2MELGL7sGVD518UOCU+BMZgBjZ+nUPsyZ0Pi9R6C
3/o6cIfcdQQfGCtHFM5B+MczEOELju90aPzvg4ZXNpSvg0hPAK/CFjE=
      "], {{
      326.43799999999993`, 1768.757}, {319.094, 1760.1629999999998`}, {318.25,
       1760.1629999999998`}, {320.85900000000004`, 1768.757}}, CompressedData["
1:eJxllH1Ik1EUxoeEf5gbFdVE9qWJi0wqCCREOiGRITFaUTGsxtQ2m+mQ966Q
KEbEiFghZvvjUoKfBDIkKkPBPtFhEBHGiArTiBFSllEhYnU/zttNNngZv/fe
e+55nvNsBb5md32WwWBws4d/nx7tzN9iJDDXP1ZdVkthU3T96+dlBMqnXDFz
iMLjHxtrrnoJ7M3NKomGKVTkpLpDUcWBts9nd1LF920XZ/cPEJhuXZvYQyj0
0aeOwWHJ4y0Uunbf+76UxHVWn10Tb5okMMwLNFI4lV689e0tgSM77iTDJ5Bn
CLwofLNwzkfBVHr7xtxHAh2Vlxv9NYp/T575VHxQsdBTqtjNGgs6KfCyo2ms
twH1zOJ9BRTYqUu7vhBoXnPh4YQd758nwLqdbrXh/gXUa6Vg5PX/EPh14EMv
tVAw8E9uWPbDuIoLtWYy9zeeR0H430AyWN8v/AuR5ecjire+K8qOxAg08X4Z
v2Kvt13D+bF+j3FjKeq3o/5OAj2hipzDTO977n+X5BTzwzHYEmjrRi7Cej3S
n59Oxbq/Oov+3YqtnrryKQ/mid13nc0r7UV9cQJLrP++OirncAXnGUA/z2M+
TqLfQcVintWKxfnN2F891jeivqOK9X51zo50VK50Yr5NBAYsrGE9D6sJzPC8
Mn/a81YcMq0jUMJ12FFfPgG+/bgN5+PA/FixvhP9sGC+t6t5Ca7KZH3+Ql+7
lsH6fsFUW34+oVjkdViT+q2o55EGX5n+Idb//Mt9vlVJWd9ciOvP8L5ixbpf
/6+bXYqFfx7Mz4TcP+TFfvT6tchjmpwTmw+PheuJBjyGdj/69UCT8/NjXkdk
/6kA5vuuJufdQKGX+51QLM73Kxa/35uSxwPKPzFPP3IM/QkiL2r//r/0fOj8
F3dSWcg=
      "], {{356.23799999999994`, 1747.476}, {369.113, 1747.476}, {
      369.113, 1743.71}, {356.23799999999994`, 1743.71}}, CompressedData["
1:eJxllGtIk2EUx5cfLMQu5LWl8xahSJkfQta6HIkwFRKN0uYSEaUic0aw93lT
ggwRC8vIWvhk07SFFCKlJQp2EzP7YlGEjbQZIiIlBaXdpOdyxkM5GOPHnvc8
5/z///PGFNlzSvwMBkMu+/Lf6pnsHlOCDt6TwR3PblAQnKKDZTyrLowgJ/zH
a3WYvTWY+aCKwrGpX+1flulwO8Ja3HeWQveQo9/1lcDCazK9vp7Ch6w6Z9kr
Ald2niudcuLz7QQm+H2UQhc/71C8YsPdptlkxUFnHg23/NEgz9w19L0BeVSD
tvJtAbk1FFZz7tMg0lpsGa/Aenc00V9KmWJxvkBxTo+p+mg2hZFYz49T9zXR
r3sXhc+VOzYXDGuQEeiXuNRC4RPnMQ0us/4PbcLz8xrM7f14k8ZTqAjuSPOG
y3ndcRS0fpcxyUykHiasZyVC37QIrFep+A2TKblecWZKbWphK+rFWMzVjXqa
8P4hInSyR1F4yfkdgcSa0NE9MXh+BvWLUyz8zVD85Fu87QKbfwsXZJqIOgv7
UN9JIv3OQ/YS6E1nglgpHL7IJvAQOMJ+H+aj38xfru9bG/r3nEi/DlJw04Ho
zl4C/PGaAtSrbTGL+YsoMFUHoh36IvadF1yqmN3aWp6rWPSXrkMZD4YN+0/V
pf8HKAxygbfqUof9+L9Zl37nKPbp5WM+jyMG827EepEUeDudv1F/IwXetneM
yLyEYx4eE+lbKPrdjPOHoB8VipPer/M/HaRY9DuA+Y7E+c9rwh/nRgrb+fwl
msh1lAX3K1uDeZ7PdMViPqtika8SzJNNE3plHMf8ncD9qcS8svuE/7XY3z28
7xL6NyH7CWvEPAYQ2a8L/TCTf98vdsVX+cVVisV+NhAonByJzfexLy8tFJz8
fBfuVzPu/wsCIayNn9ex/jTm6RqF5TyPc7KepxH1XqLLfWpEv/wVG/gnULGY
fxW+33zPB+lSP4p6hOnwlO3TyiYKu/nFa3TZvwv336jer38BylKFrQ==
      
      "], CompressedData["
1:eJxVlH9MDGAYx09/xGJstC6plFJNy40haenBiNo0tn7IqWOdQnU3I70vMw1r
WDMbsr2zFqq1uBIq3eR3R4w0ZhZLGu3mR2JuzGreH8/1Ttut+9z7vs/7fb7P
87zh22wbrT4Gg2ET/4j/1x+VdlYXUfhe35XWNpfB0c8b2kNTKPTM6ftzMJTB
9MN3umtMFC7Zk/yyghgM1rIHYVEUhvn++JkMEkQAI4V7v2LMJ41MnZuk1tsC
GHw9kLw49zcZ5y0d66b49Gt+VeaOWtBNwPKRnwxkEJKTn9h/k8DYS74QwsD0
LtK3vIGAvyNlgIYzSIs/tsJSQ0CEiY3WLPXM/3+9cSFyLQGxvWIJ8hUCH6i/
w5WA+toJDHBOWc6g8BT/5QlReazEfD8RyBaJrkF/JlDFqQymxrWcH46jEFsR
8GZ9OgOvn6n8vokZmkd5PnXZmi8H5+Q7tzIQ1w5sV/E8BahvM/q9i0Gw8COd
Sl23S9C/ZLzfzmC/OB+jWfoZqLl46G/DiB/Gs2n9PGilsZhBkVj3ECgRhd6J
/o8Q2NdZHWQq1Cz9sTK4IfT/QD/zNAsfbGas1zCB+7wfpuVgPm4CZ1adKCrg
+cu4gyqeK5NBrsinT/nrycB8ejTLfF2apd5OIv1+lol+tqMeHv99emVVSQvq
9d7fRNQ+s2aRf1WeZpF/qhX1OAn4lnPF3I9voj96ybh/0g+3ijd7D4M63h7N
3F95fynqX6RZ5puhWc6Ljar+3Yv6j2C9djPoEoJOU1n3PDvur6ZqHoqxfvVU
+VeI/ddI4Sz3d8iK/eygUv9ki2Y5H1mapT9LNcv5NaHfTao/E+fhejPuj2Gw
Vny5iv0ehX5co/CCz8tYJPZzK/YbZ4P466DgFPMYwWCGeE9u4bqX72peJvJ9
qDnJ7/VF+2PUF4F+PcX54vFdwq9ezJ/zhdWtP0ff4vlorMcX5FjN3vdO1uc5
hR1ivmYxOCcaoQX9DcD3r0qz7PfjmmW9DuH9RtRXhvUKwvmzUzUfwch8/mW/
hen3wKvnH0zMiNU=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQveVE2b75OVUO75cf8zbXme0A40dYbjnxzQ/Kd6ly
uKh0++c/r9kOy2YfUdigVeVQvm++lL7HbIcqkXXuD+WqHDx5mLTb3WY7yEal
WN/nrHL4Efx46Wzn2Q7VIPlflQ5sjVOdux2g8h8rHZYU2HKF20LlX1Q67AIZ
YDXb4W2NvWnck0oHoK1S680Q/GnO3TnPjRB8kPnSerMdGEDgVSXYnfJasx28
zTsdE75WQtyvBjWfoQps33VlqHq+KoeHIIcrQeVlEHywvwwRfEuQwd5VDtb3
/XunqyLCBxZeAGyRjos=
      "], CompressedData["
1:eJxlk39ozHEYx88sytYSF2O3290xrl3fZkpLkof9cVgaU5jJuNv2PR13y3J0
zyVijbg02qY+sTQbUmdDOv4YLSFFSCF/bGdpMWv5tRaFz4/n+pT98e3bq+f5
PJ/3836ej9MXrqzLsFgsa/gn/kXNc949b0RYl53haY4wSPN6ztN9DO7am0Y2
nUU42Ncx/0aYwexjD55e6tX5HpH/UvNARbw9NKi5/6d7x5kvCK1lp/aaBxh8
e7XBN3Mc4c/rQ58WNTLwpqLWxF+EHOPmhbEGys+MgW177YqakOZty28/iQQ1
5/P4QIDBudzMLTlTYhAR+uqp/i+ENn7fcC2Tuou/I0xsHurK8zPYN/z72tfP
CGNXHpWX8v5EmYqU5qEu9tDxVvNaoe8Zwq6PL1zVfqrfr/R315GeO6TfpHgC
gVeNz91D8auaZb+dmqVfFxEqk/amIO/n5Gp+03mKm6T3NCo/eD/chb6OI9Rf
jZ6X1FOlWcYNzUL/ezeDpJhnBGHa0dayrELqH1H562JwQtx/GOEeH+B1BwO0
Jryp44o9BQycPfsDLXGVP57PYDS2atnONoRAy2jsvo3m0Unz5ewQ+bcms+iv
PZf6nYhO4nS+1Jelz8v681DN30Z+uxAuN6ycsdXOoJuPr8dNfnK95aW8ooHS
twIn5S+hfhdQvIT0LKT4UoTwLL7oizXLeRia5fmN/8WrGXB3k/YS2vfdpL+Y
2E/vx1D7Eub7MyjmX6T0jtTTeypU/bwx6bwTIST0BMi/PASxRt70flk1y3lk
a5Z6pip+HND+fhBsEv+IKv+C5K9fv99/Iy/dKg==
      "], CompressedData["
1:eJxdkmtIk2EUx4eUQZldyAujUldWMmtIxWhTODJy5chbUfMyXZa4xtpkhEU8
TyARJlERUn44RB9MIwiVCKwgiYqMArEwoiTMLkgE2nWhoXSevQcearC9+3HO
+z/n/M/Jqo9UNCSYTKYC+qpnNz7K7CuTMH58RY/biXC60P9puEjCjZVVB502
hMy+aODCZgnebbeexLIRQhN/rn9LNbg5A2HQY28rnBHw3DI6PZeO8eeJNwLe
k95gCoJbCfdrfnns87q8c5pN6hMUQGoDGWaEowNXzDaPgKtNBQtfWRCGlV6u
gMSWi64zVo6vEhBefvJ+sV2zc6z0bFqR5nh/e7jeJtb3M5dx/iGEO6tPfSmP
GvqLogg09VgpCtiZlGBtbWa9Z5p9d+nflOZ4f0kS5kZI+AjPu0YCdRtqjCC0
KT8dEmYp3h1EoLIdYfL367XHnv4GzaqfDv+/nFaL0J4+b2+ySxr91XA8n/2v
QkjeePPy1FYJFbdpEC/Xy+V+vNx/lmbb27WJLcs071D9zud+K5lnBVwinqjm
96cFWFtTX5f42L+YgJQe9/hMHUKXup+fnH+A/fth5A818n4njX09DXL+R95v
iPNHmcM83xBzhOe7p5l+O5s6NX9/sat+Kd2TOte6w5wvef8B1gsYHNvP8/kE
kEuW6krN8f2UaI7fpwtB2VpO76u1Wx0cl1w/D6FWBdqFcQc5CItV/V4jvi+b
64/8x5OaHeowyf8HvzbUnF+P8E7FzRKKqdyCXN5/joSHFF9iY7/sEn7v/tCF
W3g/2/m+8hH+AjGytXc=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7W3e6ZjAXOfgycOk3V422wHGf7/8mLe5LoJ/Qen2
zzr12Q6LXLd9/stS51C+b77UeuXZDm9r7E3jOOocHlWJrDuuONtBNirF+j53
ncM05+6c5/KzHapF1rk/FKhzAFFVclDzxKH2yc52YAABuTqH78GPl86Wme3A
p7tp7nvNOod/VypeqgH5ra8Dd8hZY/Kt7/v3TpeA2tdZi8GHqQfaKrJuNoIv
1Hzg1MLlUPVAvjCIv7bWIcJyy4kyoHtA1L7NtQ5LCmy5woHuBXHn76h1yJz4
tmY/0D9AVx5R2FPr8AEYPtsVoer3Q/nKUPMO1jqwNU517lZH8GHhCeMDZXPS
AxB8kDPdo2Y7gJyVd6DWYRcwgFYnQO3bB3Vv8myHY6AAhNmfCg3PnbXg+NBP
h/K31jp4AcOXPQPK31jrkPAUGIMZ0PBZDbUvExo/SxB8g7sqbI1zEXxwvE+B
8I9nIMIXHN/p0PhvgYZX9myHdyD+p1p4egIADcQSUA==
      "], {{482.83599999999996`, 
      1768.757}, {475.49199999999996`, 1760.1629999999998`}, {474.648, 
      1760.1629999999998`}, {477.258, 1768.757}}, CompressedData["
1:eJxVlHlI1EEUxxeJAgsLEzWv1iMVl5KEUjPtlZCk1FLgkUhr4uJmHouYmscM
JWaXmJUKTSJR2cliYWiKFhoZEWKHRfiHpIREmBklWCTN8dahP0Q+zOy87/f7
3vsF5hQfsLoYDIaD/E/8j6j3/DgSTeH7recp3RsYPA6o+7rfncJo0PgCCWBw
Zmf259HfBG7Y413TfRhk5sZNmOcIzPL70esYFE7/uTM3SWDwV3hWoxeDpE+V
Ho636rzbk4Gxs8TWNKR5rOJL6Oa7mlOieYVmArxK0Lg3g0vey9Lc6ggsvuMX
/RncZM+MnaUEPBz85UCm6hQQ6N2zysUUplnq2fT/+b0oZDsBcb1+K3IFgUku
czgW9dUSELKTEhhMmBtai1qI8r8L/T4gkBHb9aJsN4Mekc8r5GQGnHoCFgiY
eI77zAyceSbzeitSNf/lfjoyNN/3y8ztO8zgx5u9OWuiqHxvPg/1hVKV91HM
w5eCrWmm+kkR5ueq7pfZ8fc/yRLLPKc0T4kA32P/irV+7qrBqxDPBwkUudc+
fZmP9foJlA+0+0TaNMt8rEz6HOnHPC2a3TY+bCvOYtAh+tVLYIj7WJ2JfroI
NCeeK8jj/meqd2w55FDvDaehnw6ldz4V/VzVLM8vapZ6z6q8R9Iwz1rUw99f
y21cq0G9vL7Q0VhJgKcx0J6lWfhvtWgW/pOtWO8UgeUnuGKeR6CYjzadn8zj
kXpvfSkDfzEgY1i/DPUb6BJLv0bNcl+2UTW/x1C/GftZwiDe9cN1u4UCH484
ix3v51O1D4W4nyVU5WfD+Sun0MLznbbiPB+nUv/KbM1yP9I1y3xiNMs+RaL/
SjWfcRF4XoX3wxlUiUWspmreQzEPSuE135fFEPR/EueXs5yjOgp9Yh+D8Xty
Gs+dfF6z9HtBs+zbZdQXjHm14n7x9xNEXm3oPwT138bfh6GeHmSTZuf37pvo
zxUKR8R++TI5x7M1mK8n6svRLOcuVbPsVwrW90J9idgvH5zX7VTthx9yDFXz
ZtTfA6eefyIehos=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQrdUudvOceb3D++XHvM11ZjvA+BGWW05884Py+esd
Lird/vnPa7aDbFSK9f2vdQ7l++ZL6XvMdvh0yTdJ4FWdgycPk3a722yHyRIs
YXxX6xx+BD9eOtsZKn+szoGtcapztwNUfm+dw5ICW65wW6j8ljqHXSADrGY7
KGwoypi4vs6hDGj+ejMEf5pzd85zIwQfZL603myIO7bWOWw5UbZPXmu2w6Gv
GjH9B+og7leDmn8GYt91Zaj6m3UOD6tE1rkrQeVfIPhva+xN4/4g+DnPf6/8
KFbvYH3fv3e6KiJ8YOEFACG7kq8=
      "], CompressedData["
1:eJxTTMoPSmViYGDQAWIQfeirRkz/s3qHv1cqXi77NssBxvfiYdJm/z3LgU93
09z3DA0OD6tE1rn/neXgCRRv54bwjzPMdqh8qWbIIdwAEWed7WB93793uhRU
PddshyMKG4oy5BoctNvFbvrxI/hgdSII/s1z34Mfi852EIyw3HJCtsHh9ELX
bZ/FZkPMlWlweASyTxxqvnSDw1Tn7px0idkOS2cDTQDa9375Me/tElD9kgg+
2B0SCP6nS75JAqINDoeB/uQH8mP6gT4WgMoD7et0THh6gRfiPnEgPyoFyOKG
2g90Hyg4lnMg+LEg/UwIvixIw896h4yJb2v2i0Ht+wQNX6B972rsTeNe1TsA
fbt0ttRseHiD3SmL4IPVKyD404D+fa482wEUXBNf1zuU7ZsvtV5ttoMiiP8V
Gl+aUPn/9Q5AXyhFa892WFJgy3WdFRo/OtD44kXwweEliuCDwqUfGP5g92lB
40cFGt9A+0DhZK7dAEkXSrMddEDhodcA8bcsgg+OJ3EEX4WtcephgdkQf2hC
4w+WPhSg9rPMBos/F2uA+P/fLIj72Rsg/vs1ywE9vQIA78M7WA==
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGCwA2IQ7Z8kEGFpE+hgfd+/d7rELAcvHibt9m++cH6E5ZYT
ZXYeDh+WH/PeHj7L4fBXjZj+S+4QeSD/gtLtn3VV7g6eIH3hUP1mCP5FkLwU
gs/WONW5+48bhAby2UH0HTe4eWDxPW4OW0+U7ZsP5L8J3CHXOtvNYTfQgNVw
+9zg7oHxweYbIPggd7BrzHKYc0RhQ9EMN4fVMlEpu5VmOYiuc39YdcXN4e+V
ipfLFKB8FXeHNSB52VkOUyRYwvjmujs8rBJZ5y6D8D+MPxtk3gtMPiy8wO5f
44jBRzHPzwnOX+S67fNfFmc4PwWksd3ZAahqn7wcNDyvOTssKbDluq44y+FX
XdaeEmYXhyBgsLxWhoWvi4N2u9jNcxoIPiw8YPxHQPOPtyP4YPsmwOLDGUJP
neXQOz1PqPmAM8T902c5AG1dXJDrDAnXWdD4/+QE9se32Qj/wPgw/6Lz/4HC
ez4i/cD4kPD2hPOfgix65+XwPfjx0tnzoPF3whvinzmzHHKf/175cZGPA5/u
prn5s6DpJwaaXqfNchABxecXX4j9E6DyPX7g8Avvhpp3ww8S/y0I/jTn7pzn
NQg+2P6SWQ4rjnmbdzb6OQBNyUnPhaUfX0j4pc9yAIaOLZe6L9j9aomzHOJ2
AV0q7QOJrxhoeG7wgtgfBQ0PHT+Ie42h6eeHnwNI22otaPwv93fImPi2Zr/K
LIdMIG0vGwCPf3A4pAVA4h+YPpoPnFroeiwAHK78wPQLy8+w9AQAraa7eg==

      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQfUHp9s+6KjcHLx4mbfa4WQ6Hv2rE9C9C8Be5bvv8
94ibw0Wgun+xUPlHbg4RlltOfAPypfXvqrAxujsE7ZBrfQ3kb//890qFpLvD
NOfunOdAPlvjVOduHQR/zhGFDUUnPOD8ZyAH/PN0KNs3X2p9wiyHvul5Qs0X
vBweVomsc0+b5bDymLd550Jvh4SnQIXZs8DuqOPygdhfhOBb3/fvnV6N4IPs
5W6Z5QByXuNWb4h9XbMc2EHu4fF2+Hel4qXahFkOouvcH1aleDnw6W6amz8V
6t8WT7B54jNmge0py/OA83/VZe0p+ewO50+RYAnj83WHqJs+ywEWnu+XAx0+
bZYDAHzXpaU=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQrcrWONX5cJDDNOfunOfasxwyJr6tsf+K4K+RiUqx
lg920G4Xu3lOa5bDwyqRde6OwQ5/r1S8XKYxywGsPznYwZOHSbtdbZaDX5JA
hGVJsEPQDrnW18oI/pICW67rCgh+vlDzgVOysxxm5AEZScEO5fvmS+lLz3I4
7m3e6egQ7OAFNI9dcpaDwV0VtkbZYAdZoDPui81y2DT3/fJjn4McHgHdcVwU
av9hBP+i0u2fdZMQ/JDHS2cfyQiC6wfautDVLQhu/utAoEOVg+D2c11fXGAr
FAR3H4wPcz+MH2G55cQ3ZYR+6/v+vdPVEOYDXem9XQNhP1i/FsJ9sPBFD38A
IxGnIg==
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQ7cXDpN2uF+WwpMCW63r4LAcY3xNEGyD4IJpdY5aD
wV0VtkbbKIfVMlEpu5VmObwJ3CHXGh3l8PdKxctlCrMc2sVunvveHOWwBiQv
O8tBWh+o4WCUw8MqkXXuMrMcLird/lknFA3ng6QbUzH51vf9e6dLzHIozpj4
tuZ4OAYfpr53ep5Qs0QEnA8kH1aVIPh7SyZLsGyLcNhyomyfvBzU/XcjIP5V
nOXg0p3z/PfHCIcgoDdeK89yEAXp/xPhoA3yiAaCDwsPGP8R0Pzj7Qg+2L4J
UPveRTiwNU517p46y2HbZ2DIXIyAuH/6LIf/ILA8wuECKBxmQcMjK8IhwnLL
iW+zEf6B8WH+Ref/A4X3fCj/fhScH/J46ewjC6LhfHD4W8Y4AF2Tkz4Pav6K
GIdpQP5zuH2xDny6m+bmz5zlAAyFwB1lsQ4gY+2B7n8Nit/DseDwCu+f5cAA
AgJx4PDK7pwFCRezOIj5TQg+ODyq0Pj5sxwqX6oZcvyJBYevXxrU/e2xEP3x
UPuEYyHxGDHL4RkooPJiIOkvdJbDJXC4RcP5YPPTEHxw+OtFQ9wfCg3/j1EO
H5Yf894O5INCe8+WKIf3QL552CyHTXOBrOIoSPyHIdI7LD8AAAk/YSE=
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7cXDpN2uF+XgCaJjZzk8vaB0+2dalEMCiBEzy0Fa
/64K20wIPxrIF1nn/rDqSJQDSB87kN87PU+o+UOUQ/m++VLro2c5fNOI6T8k
Gg0xLxqq3gTBj98FZC1G8C8CratjigHr14+D8oNiIPLJUP6iGIdpzt05zzOg
/FMxDksKbLmu56PywysQfJA12nVQ/2yLcbC+7987vRnq3glQfgdUfVaMw9YT
Zfvm98LcG+MgE5ViHT9xFtif7e+iIfZNhupfAeGHT5vlEPJ46ewjEdEQ86bP
cijOmPi25n8UnL/t898rFScR/E1z3y8/1hzlEGG55cS3aVDzgeH/Yfkx7+1T
ZzkAACcdtTY=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQfftnXdaeDwkOnjxM2u1lsxwmHPqqEROfCOczgMCO
RIeHVSLr3AtnOczIE2o+8AvCP542y8Fyy4myfcZJDtrtYjfPxc5yOO5t3ukY
kATRH4zgT3PuznnujuCvkYlK2W0/y6F3OtBAhySHCJBB5rMcMia+rbFXTHKw
vu/fK64/y+Hmue/BjxmTHN4vP+a9XW2WA0j5gWuJDlOB5qUrzHKwAtk/P9Hh
35WKl2oysxxugfyTkQixTxzqH+1Eh0cg94pC3fs8Ac53ASr7XYngg/2nlABx
h/Qsh9eBO+RaD8eD7TcH2r+3ZLIES1g8xL1A9xWDFMrHOywpsOW6bonKD3dF
8HcDA2S1L8y/EP3fQmc5XFQCxkAT1Py4WQ4LXbd9/nsk3uECSBwYvlzXFxfY
8iU4gL2ZM8vhGCj8XBLA4TO9YJbDJZC6qgQHtkZgiJRA42sLIj7R4xcAIWne
Qg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQfdzbvNPxRoKDFw+TNnvBLAfZqBTr+7sR/OKMiW9r
5ic4iK5zf/grb5aDKlvjVOfmBIdpzt05z3NmOVSJACXSEhy028VunsuC6vdP
cPh3peKlWvosB67riwts7aDqE2c59E3PE2rWSXD4C5RfFjPLwXLLibJ9ylD5
UAQfpH+ZL4I/FSif7jDLYd98Kf27FgkOEUCJbyZQ9yQnOCwpsOUK157lYHBX
ha2xN8Hhw/Jj3tsVZzmAnG9/FGq+zCwHbpB7uBLh/Jvnvgc/tkXwV3285JuU
kegAMrZbfpbDN42Y/kOdiWDzr6vMcojb5cnDtDrRAURpa81ysAK5b3eiA9BX
B7yMEfz3QPvNHRD8oB1yrdkB0PCZD9UfO8sBHP5A+0D+KUub5XBR6fbPOieo
fTlQvlAiPD7Q4wsATXHELw==
      "], CompressedData["
1:eJxllG1I01EUxpeEDpWSErKaU5dvIKP6JCHCUYte/JAZZGVl/e+dW6zcaLUi
IjCxiJAI09mNMjMLShQqhgTZ6GXKPmlEElKjLEIkFhhiRKP7ctalHIzx2zn/
c5/nOXfLMzy1jiSTyVTJ3+KzLdC0rOUqga3pSSUX/AwSvI1zisFg7fv85OZx
AieHu1cNehhM9V1/mZtB/+2v0TxXvO/y86Oanx5vz1p8nkJH1aUjzhMMbm8K
zv7uohB/c2q60MdgpLr0YkU/hSX2hzdiXuwPUrDspWUNTZp3b3g86ndrzub1
qIvBgSf8pEEKfqGvEeffotDJz/tKGRQkN3dUtVOY3znVt5ow6OJyQ+coxO6F
q0u5P5/ryrczHs2tMzuGrPs1S31bKBz8MmarJzh/ndJ/18FgIz/m10rU78S6
mUJZdHvbisOoN07+cljM+6FZ5jVNoHbI2urmfsZtkz/PfsA6nyfiDYWJyoP7
KVpv7rcMEOWvQe9L6tmjWdbtmoX+yWLc5zUCIpa0AgbHhP9eovK1MXgtzr9P
QMT6IJcB/3a4O6i4JIeBSbxGVf9cNoPlLaFIzzsCYswzC+5jVukptGB/Jl3A
wl8gC/3eNBZwol/qe6FZzo8aav8WzPu7AXe85al1VgapE73e8rih8uR6d4nF
pBDpIycP+9PR7xoGdaK+VOUdyMd6BgEPjz1SpFnuw65ZPl/zX72eQYUIms+T
9/0Q3q80ZIK/HzOR98XjwP0vUvufacR9zSs/E058PmaAuAYRF+b32YCPpzMH
Nifu11vNoq3nleZKoeeR4hGXzveTYD5/THAn5ufGfH36/+APci3UuA==
      
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQrW7IsUZmW6rDkgJbrusTZzmg8ItnORQCqcUJadj5
OWjqkfgflh/z3m6I4OcLNR84pT3L4c7Puqw9e6B8daj8Kah61VkOlltOlO27
nuqw25OHabXyLIeMiW9r7F+mOvy9UvFymdIsh61A6fn/EPzj3uadjgJpcD5Y
vWKag3a72E0/oH5hoDULDaHyKrMcbp77HvzYMc3Bi4dJm10Nap5fmgNb41Rn
bo1ZDmF8upvmhqc5vAe5R2uWg2PC0wtK5Qj+qo+XfJNSIHxzFaj7vaD2yc9y
eLx09hEFDaj5MlB5tjSH1TJRKbslZjlUi6xzf/go1cH6vn+vuDjU/n0IPjB0
C2yXIfhA35jG9aU6gJz1XhzmHoj8dMlZDlag8IpPdcgDhqeXNFS9X6rDGpB9
srMcnEDqnVMdpjl35zxXgLrPItXh8FeNGH4VqP1GUPM1EHxg8Gu36yP4sPgF
278/BYP/Dxi+agWzHFaDwudOisOPYKBNhbMcuEH++ZUCsa9klgNI22IJqPnl
sxxUQQFvngoJr2qofUGpDrtACuqh/KxUhwhgwvjWPMsB5N35ZakOF5Ru/6xr
g8ZXeypYXL4bGt9zEekZAPwpR1A=
      "], CompressedData["
1:eJxlkm1IU1EYx4dEhkaBOaWlMudcU8mXIJfZ6Nn8IM0isqgwyTHqnnPzZYug
oldqiUSU9MGSEyKxLAg1EEOJMJFQ68OwKEQizCQkpKwoe4Gic+55rrfhh8u9
P859nvN//s8/MxCsPBRnMpm8/BHvkDthPOJU4bb4OMpA563L4/KaNhts7i6f
+l3E4MHosYH2XDzPQ85X4e/LEx8cOcjrVchrSpmIOhgMtFsK3mxU4aEoyGaw
Kjz47JZHhbm7wxUuO4PE8UjI7VOhISk86MticO/Li+2B3ajHxmC64+YTq9/g
17/OHn4UMrh56LuzOqxCS9nlOpKF/7eiPt7f638/Zouo4OMcn8mgcXZnf8ZT
Cu9OJnePmJE7FrM+z8fTWzYcUCj84XzHyqBXzFdMpd41DJLEPGYKpZM7rqSu
Rr++EZiI/tg1ncJg3lndPPScxPbvMljTe9HgI6LeTyB76fmWslT000ukXxbs
byfSz3QGm4SglQT2lfSOzlux3xKi6bmRjX7+VIBe45PkYr+vivSvMJb3lhis
zRMwuLI/o7FWYXAqmQfhkyL9VhnsWbGup21Gkf7WMhipcF3yvFWAV1nu1zF5
7ytF5qce/RtW4Dqvn2lgkFZ1sHSyT5F5CTLYxsv9bQp0ioMQA4/Y33FF7uM/
1vMqmSziKeFncSyX56P+C0Tqc+J8jEj9PK8JIo89BETZfp6nVrHoKJ7refxs
sNY/ni7wY5F3K9X8mrVh3t1U21+fHe+rojBm40l2YB7OUBA2zuUY+dP6FRis
1QcMThe+Ed0vqvlYw/1fW7SsM+2q/N9Vj/rOURBxSgxiXmqwfwjnKaQL/uqs
+/kPphvXLg==
      "], CompressedData["
1:eJxdlX1MzVEYxystFiszoUhe6haxy5QkzWM0E5aRMUJruN3z+6k7DMNszWhe
EjPSmWQYI8tqyUvEtGH+MJqthdZihoU063oN5+V7O9TW2mfnnOf3fb7PS6Nz
8hevC/Dz83OLX/n3RN6g3XdPMTrnSQ1uSub0cefMxNUbGaW0ZhSVzOD0YH7S
vlmLGB2bfcB2EXgao7btgyvnpoFHMfr9bNt7Rzqn+5IHMwoqEC8yDC9Prnm4
ZanhJ2NefN+1mtPhe11xWU7EW8/JG5dVfG+d5gc2p4rOxoU5J3G+iVNw01lP
6itG8wYExBdu4RQjP5Rk9fCd8ghny07DuUdERjcsrX8z9H6wtF4PpxKZ/167
hxeI4+wyw41S5yWbGoTMUA++X2nTcRHvbT642qbLI1asrcvH92tsCplYXZbv
O6+1KV3o6SvY2RIdVHAD53mcHFJ/nU3iecqaDYZVPSzDwr36KMap+fHXJa/x
viMX+V+ztT+5iH8V5y5Oqr5CX50wpMLHQr+qh49FfsonV6/8Xb38ESyf1cca
VvfTbO1vDuqbaZN8lp5lWOWT+T8vW8Cpv/RnOvxNg19B8GsmuNGisMq5bT+m
oR8OWkq/N5GTqA67ldCLBxqOFL62tjPlX/lUxLuv+9GbxOmprG8lo8XXR+6x
EsFiHjouCKVTcP+4no9lk8GH0M9O6N/PKPuN6OiJhlX/TTCs/IlHfPFe+TMe
9SvB98ahP08zuikDxHGSmF0FfbGo1yPod2BemvX9CsE7RBu0/cZ9h89fS8cX
LPus9YKlfYnB/U+Wvh8DPaGoVzSnItkApPvFOxbvXein0ZivPTiPRLwz6KcI
6KuyaWt9ecSVMMNKz8D/+Vo/9O8x3PdH/FW22kdDf5bqfIIxP52ldHvz0WGB
pyy9rz6U0nNZ/2GG1T6rZj2s8l6J+nWU6vhh8L8L/NFNci0VfwM3u5UPfX4Z
VvH+GJZ6nf6o30s3ySwaAnz7yq37JxDz3O6m+MIhzY+DkH+3W8cJBocz6hbz
dT4E8xXJ9Hko6iH277ufFzsbByGehf4K57RJXsxg2p/h6P8U7M9I6JvE9P4a
iX0VjX4dhfpHMb2PxhhWfkUblp+548B+cOB8HPQnwm/R/2fSar90z2H0WdZX
zIuf/MnV8xiVgH7+5//PX17V41E=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/U0jpv+QZrbDh+XHvLcXznJ4W2NvGseE4Hubdzom
PMxyyJz4tmZ//iyH6XlCzQeOZTksKbDlup49y4EBBNZkOQTtkGt9nT7LYQZI
fh6Un4jgg9VHovLD/Wc57J8vpX93Q5ZD+T4gw32WQwbQHvurWQ5Tnbtz0h2h
8h+yHLx4mLTZbWc5yEalWN8XzoaYZzXLgev64gJbOwT/gtLtn3VpCL7llhNl
+9qzHVbLRKXstpnlAPbvwmwHT6B57Q5Q9+/JdtBuF7vp5wK1/2Q2hPZC8MHu
DULwwf6LmeVQJbLO/eG2bIj7U6HumZTt8O9KxUu1bKh8GdS+fKh9IYjwRQ9/
AG9nrrU=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQrcrWONV5epaD9X3/3ukSsxy4ri8usK3Lcni//Ji3
uegsBzWQfHaWQ33WnhJhIah8XJbDvysVL9X4Zzno31VhawzMcjAGAR6oeu8s
hwtKt3/WcSL4XjxM2uzsCL5sVIr1feZZDjPyhJoPREHsF2ec5fBNI6b/UCXE
/u3/ZkLk10Hd92umw4RDXzVifmc5eALNa/8x08Fqy4myffHZcD5Yfj+Cf/Pc
9+DHrDkOjglPLywC6gf71zjHYUmBLdd1oPn750vp303IcTgM1MYPdI8lyLzy
HAeQMf3sCD5IfTgPgq/dLnbzHND/Lt05z39n5kDMFYL6xy/H4QPI/cKzHOJ2
AV0CtK98H9AiYHiu/njJN+lPNiQ8xKDqV2U7PKwSWecuBlOfDQ7PzUA+2Nzr
WQ4RIIvFoXyk+AIAFrW7+Q==
      "], CompressedData["
1:eJxVlGtIVEEUx5ctLCwKTFYz85Hrg5bclDBts45mLRooBq4m5iPafOTM3dJU
pASJEBELibImwszSD21+kErJsjLJ6EMUFdKLsAcqEQWRIKI0j6NDC8vld2fu
Of/zn3Mm/KCxz202mUz7+V88z7RTv1NeCr97nu7tj2Rg/2T1aSyh8HLDh5mG
EAavxDOewnVPsm9uEIOqsrafJ0Ip/OL7t65lcJF//shMYfhvTMHZAAb8bXPK
NyLX+y0MTOI3oll8vrNNs2vVpr4rpQSKv/OMgQwO3EtfaXYSmH9TNxW1noHv
WJcnOYqAf69zvD6cwYPqc4FLLQTENlu0Zqkn9v/1m/HIIQTE9qYE5FgCX+r9
e0eTUF8agXHOzh0MpnkZw+VE1Z+K9XYQyEu6/axmD/rzFjmDQYoQbqdga7K8
y8xisOBnBs+3LEfzHK+nO0+zNzj/0GAJg2u77/6Zu0plvOlSBmktlROzzej3
EQaFopAqKn17SNG/bLW/xoPfWzXnCD+XaD79I3sgZIqoeIbW7/ic1RpAcP0x
AXGMzyvQ/34CtUMdQfYyzdIfN4NWoX8A/SzSLNIaBXhefQSe8H5YnY9+dxM4
v6ulspTXv4an6byk4o26sJ5m5ed0DtZTrVmul2iWerOJ9PuFC/OnoR4e/+uN
yyNhiag3H/2MI8DdGOoo0Czqby/SLOrPcGO+dAI+jVxxBfZHnfZP+tGj4oVW
M+Cvx7omMX8N6t9OF1nWe1KznJc+qvr3OPbDRzyvYwy2icCzFHh7OIo8uN/P
UPNA8PzCDeUfP59U0X82Ay5wfyfcqHezIfWvKNYs5yNXs/QnUbOcXzvWH2fI
/nRsxPUtuD+GKR8TDNXvUdifDkPeE/NWrB8M5RfnSCHEacCgmMcIvE8ycZ2z
nDOXZllvoebouOXe4MOoLwL9qjTUfPH4wrahWqzfivpb8fto1ONFtmleuO/k
+Rw1oFzM1zoG72caKu4nor8W1GvWLPttki6yzP+aqvwBuD5C1XkFYb/eoWo+
gpFvUdVvYfo+WNDzD/yfYqg=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ3Tc9T6h5TZ7D++XHvM11ZjnA+BGWW05884PyY/Ic
Lird/vnPa5ZDgS3X9cUaeQ7l++ZL6XvMcljkuu3zX4E8B08eJu12t1kOsbuA
rOe5Dj+CHy+d7QyVP5HrwNY41bnbASq/PddhCdCgcFuo/JJcB5CwttUsBwYQ
mJPrUAY0f70Zgj/NuTvnuRGCDzJfWm+WgyrI4OW5DltOlO2T15rlsLdksgTL
vlyI+9Wg5l+B2HddGar+fa7DwyqRde5KUHmePDhfqPnAqYWmCP4MoPcPZOU5
WN/3752uiggfWHgBALOpiws=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbXipZphQYHD++XHvM2XzXJA4esi+BeUbv+sU5/l
oN0udvNcYYHDB6D8duVZDuX75kvplxY4LCmw5bquOAuirqLA4SKQ/ic/y0Fx
Q1HGxNoCB+v7/r3T5WY5gKi8FihfdpYDUNfigu4Chy0nyvbNl5nlsEOu9XXg
jAKHf1eAFstAzV+NyQfrl5jlsOrjJd+kD/kYfJj6Ra7bPv/lQOgH2y8C1Q/k
PwDxpQocIiyBLgC659BXjZh+BYh/woHujUoBqlQtcMic+LZmP9A/y2YfUdig
AfW/IjR8dBDhwae7ae573QIHtsapzt3qCD4sPGF8kP3iDQi+DNCi+C6oe4Hm
AUNDav0EqH+1Cxy8eJi02SdD3aNZ4AA0PSd9KjS81KDy06HuUSpwmAaUfw7j
yxU4PKwSWXd8BtR8Cah7ZkL9I4Tgu4MUciP4nY4JTy8wFTjs8uRhWj0DLbyB
5leLrHN/+AjCF58NtS8OkZ4Aa/sc9g==
      "], CompressedData["
1:eJxVlAtI1EEQxg8pAyuNEDW7TNNUFJMkKhNtTMpSSop8dBiaeHhp6u2iFlKB
hJiEiERZWyGUXpQhouZJ4hkaGgamoUhEmEXYgzR7GCFK+5hz6eBYfv99zDff
zmxATvExs4vBYDjB/2KMdZu4ZyUUvt8fSLZvZeAe0XZnNpnCyJY3fy/6MZhM
qakv2kGh0Rrrlu7LoHB64cFcGIVZvn7XBgZ9v0Mza41Ujd4MTLkxkylr1bzd
i8FZR4Nv5CJZ5rAqr9fDHzSffHJojctLAtkfeUQfBk23nvm3OggsjZ37HLyJ
QZdf5dejLQQ8WxKnygMYjPPP220ExLbwEM1Sz7b/55ujkB8SEMurdiK3EXhf
7tkyGI36eghMcU6MY/Dj1eGcdSNE5b8P8/1CICO643nZAfRnJVWcxOBG0fpL
T6MohPO8jqQwcPqZxOOtStW8yPOxZWh+ZDTldp9ikCgCF6jz5vNQXzb6XYB+
HKdgqft2vrcI/UvA+FYGB8X+CM1393f+XDRqFoPDA88r1vr5LdV4F+L8AgGR
xlA+xpsnyheLZumPGfX/QT+zNItzizPxvn4R6Of14GHCfGYIXEu4ciaP528Q
v0/qvME0zGdS+TufivmMa5bzLzRLvf1E+j3M98eJ+D2oh58vfNprR73O+B0E
xLaGTM0i//oszSL/JDPG6yXgWsEV52N9TJBl/6QfM+q8zSUMIt8GuVZwf2X8
MtQfrVnma9Is+6SEqvotRf+q8b4og6s+K9Lcb1Lg5RGTZcX1jVT1QyHeXzNV
/lmw/lopXOf+TptRbzuV+ldna5b9ka5Z+rNbs4wTifm3q/qMCcP5x7g+lKm+
6MR6D2ZgE350URjl35eCsJ67sd44X47nne2g0C36MZDBO/Ge9OF8IL4vA5pF
3dQOaeaqq+OHUV8g+jWK/RWEfk1g/pxlXUzh/hC8jznkcM3O907ezxiF06K/
NjLwb6WWOjv664X6bmuW8Ws1y/iVGN8b6/EC3hd/L/eIQimlqj+MyLz/Zb35
6/fAqecfmbqA1w==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQbct1fXFBYZHD++XHvM11ZjnA+BGWW05884PyPYsc
Lird/vnPa5aD/l0Vtkb9IofyffOl9D1mObg/rBJZp1zk4MnDpN3uNsth6ewj
Chv4ihx+BD9eOtsZKv+/0IGtcapztwNU/luhw5ICW65w21kOHiD5t4UOu0AG
WM2CmPuy0KEMSK83Q/CnOXfnPDdC8EHmS+vNcuhwTHh64V2hw5YTZfvktWY5
XK14qWb4qxDifjWo+axFYPuuK89y6ASpFypyAAm7K0HlFRF8BhAwQ/APfdWI
6Q8ocrC+7987XRURPrDwAgCbAY5o
      "], CompressedData["
1:eJxllF9I01EUx8ceFs3+gEXL2B81m9AqkTIpEU/4oCEkruiP1Bo622qmY/c2
zSSSGBbSQ4ENbg8jLCOICComPUgPoVEQPVgjJMR6kLD/D9WIsvvn3G6xh/Hb
Z/fcc873e85vJW3d/g6rxWLx8494fuivqwr0Evh0Y6Kpup1B4MHOJdYRAjUz
zRccMQbb7j1OjD8lwH/1DSYY3OeY/mqYh6W6bPQvV7wusw04KMz2rbzdcIKB
qzVUM7NO8WScwYved97KLXjO8xeeffjkah0FUdbXyeDt9SuPihsp7BeFjyDv
ovC8dDp3uo1Bcr5lzN1CYbh+qDN80PDvKZ54j2GpZ6Nh/5g7GS1ncHzu580v
fsy3loGQl96L9UoY1NqzI7EDFLpFYx6sH6DAu53tc2N8CPW6MH+UwvfdPNLJ
oGc8vaaiB/vhfEpcPJfPwt/UagbS/ymSxzpe+jdN/r//3vAob+/ODwJdol/O
TdXndwQXcH5u9NuG+j2o307hWqzWvo/rXSH8X6o4y/1IiUTLkMsw33Llz7dy
w9pfzbJ/v2HZdyvuUwGFy3xec0EGH4U+K4VfvP/REINGsQg5ouYZQT/nidqP
Y+j3S8PyPGO4QXxJEdVfB/rH91nqO2RY96vZNjBcX8D1bBcFThK45eQN633o
J/BG7Cv3Z0IIOkPAN7jq1TMP6ksSEOGH3TifIVU/4UJ9l3CeTtzvtJmX5Lv5
rOcv9S3E81jHS15k7sv5FRmW++pF/S7Us4HAZ64/w/uPXOQObMb9KMXzrVjf
a1j79e+5o9mw9K8V61ep+EwQ9ej87XheSdT7xucjn5uIzOMJo1/rcX5h3Ffs
PxvB/S7GeR9Fv4sMy/uFhuX7u1jxZMT4J+cZRs7FlT9R5LD5P9P7ofkPyhpT
/g==
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQnTHxbY39ylKHJQW2XNeVZjl4m3c6JkwvdXi//Ji3
udwsBwYQaCt1kI1Ksb4vNcthkeu2z39LoOoloPIppQ7a7WI3z4nNchBuPnBq
YWCpw6MqkXXHRaHydgj+46WzjyiIIfggY/0/lzjw6W6a+15yloPBXRW2xqsl
Dg+B8u5A92iBzN1e4vA9GKhTC2r/ihKwfX6mCP5U5+6cdCcEH6j7YZX/LAd9
kHk7SxwiLLecKIue5XBR6fbPulslYPeHp0Hlf5dA/Fs4C+IP1VKHv1cqXi4r
g8pHIvhg/1Ui+MdAATal1AHoi17xklkOsPAE2fctD8EH+7cewS/fN19Kvwuq
fwVE//QJUP4yqP5JUP6SUgcZYEDFT53lMFmCJYxvYamDFw+TNvv0WQ7T84Sa
D8wpdZgG9P9zIP/QV42Y/hml4PA7PgMavpOh8TkTGj49CD44PtrQ5GtKHXZ5
8jCtngH1fyHUfdOh7smB+nc2VP0NqP5lsxziQBpfY/LB7rFB8A8D3clvBE0f
b0odgKLa7dpQ/rtSh3/A8FXThPI/QNOX2iyH1teBO+Q+Q9ynrQp133eofSpQ
9X9KHUDB4qUMVc9YBk/fsSCN7Ag+2P98CL4QKH7FyyDpSRlqvnIZxH0w8zXK
IOGvCJXfjUjPKPEN5AMAn/R5jQ==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnTHxbY39ylKHJQW2XNc1Zzmg8CNmOVhuOVG2bzmE
Hx47yyFulycP0+JSBz7dTXPzE6H82aUO/65UvFRLhfInlzpMc+7OeZ4xywFo
mmlcR6nDh+XHvLdnQ82vLnWwvu/fOz13lsOnS75JAnmlDheUbv+sy4fKJ5Y6
RIAsLpjlMD1PqPlACILvbd7pmGCL4B/6qhHTrwF1L9C8YyAFYlDzM6Dm/ytx
2A101mqgexlA4FMJRF84gv+wSmSduxeCn/AU6CKbWQ7CzQdOLfxbAjHPaJbD
Itdtn/+KQO3XngVxtw40fFSg7nErBZt3XAHqn2QEH+z+agR/Bsh/k0od8oHU
KWW08AfGBwAi/rlL
      "], CompressedData["
1:eJxTTMoPSmViYGBQAmIQ/a7G3jSOqdzB+r5/73SJWQ4w/sMqkXXuMrMctpwo
2zdfDMG347q+uEAXwfcAMWzLHX4EP14qLTfLwdu80zHBvdzhEVD4uOIsh/J9
86X0fcsd+HQ3zX2vPMvh8dLZRxQCyh0Snl5Quq2B4HvyMGm3GyD4YP3tCD7Y
nAmzHN6C3OdT7hBhCXTZ1FkO1UBnPHSBun/6LIeLSrd/1lmVO1wA0bNmObS+
Dtwhpw1R/202wj8wPsy/6Px/VypeLpsPte8egh+7C+hS/QpU+ZwKsH+i50L5
0yrA4XN8xiyIOw5UQNw/ZZbDA6Az8x5VOLA1TnXu7oH670+Fw5ICW67rjbMc
rEAOFK10AFmjXT7LYSvIvUqVEPksNH4Mgg8yj9trlgMoWPZxQ+TDraDm36tw
+LD8mPd23VkOM/KEmg+sqoDok5/lAJLeEFMBj3/ZqBTr+58R6QEAnTcBRg==

      "], CompressedData["
1:eJxTTMoPSmViYGAQBmIQveVE2b75c8odlhTYcoUrzXI45m3e6biv3OGC0u2f
dQqzHC6C6FvlDtb3/Xuny89yAEknfETwY3d58jDpV8D5j5fOPqKQVOEgus79
4S+VWQ5bQeZ3VTg8qhJZd1x/lkPGxLc19psrHL4HA1VazXIQaj5wauHxCoc8
IMPLE8EHued6NIIPdk8eQv/75UCX1iLMj7DccuJbO8J+kPz2SbMc+HQ3zX2v
C3Gf+Ayo/LtyOB/s32sIfuvrwB1yu8sdQOEiP32WAyx8wPZNneUAAFrpmFg=

      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/a7G3jRuVaXDNOfunOfasxyqRNa5P9yG4Hubdzom
HKx00G4Xu3lOa5aDbFSK9f2TlQ5/r1S8XKYxywGs/1KlgycPk3a72iyHLSfK
9s2/VukQtEOu9bUygr+kwJbrugKCny/UfOCU7CyH4yALgPrL982X0pee5SAM
FF4INN8LaB675CyH3Oe/V348UAmxV2yWwwWl2z/rgO57BHTocVGo/asQ/KsV
L9UM5yH4liALJyP0t74O3CHXjTD/gX/v9LwmhP2Pl84+olCHcB+MD3M/jB8B
NPibMkK/9X0gQw1h/vvlx7y3ayDsB+vXQrgPFr7o4Q8AaYO7yQ==
      "], CompressedData["
1:eJxllG1Ik1EUx8fohcokSlJC1zSo0ejlS0hEeKJRlJRooCEVYQZChKvI7Lm3
Isxcrpi2ptt9iNGLvSkmusiURkSk+CE0goygWBIRUcMgSYLRfTmPl9qHMX7s
nHP///s/d/lVtWWH7TabbRv/iO/nv1z7Ah4KqTf1X+9EGVzacvDzqO1MGu/d
GBueMhnI+ik6w86e4zWtSc3FhaKDwql4dNk6zj9f76paNI7zIwxIVvf2xIji
lWEGPjE/jv0hBqublr571Udh08eSK9lBBke//Lk/eY9CTet3WtTCYHHDs5Eb
JoXfeyY6TD/W+3FeI+qZR+G2d/P8t6Wad2bY3XPXaxb6Hq5iSudCCqMF76fP
FqC/LKWnzsmgw3zh7HFQGNyRYe/MQ15LIWFwI7lY79Es/Zans/DTnoP1XpLG
Vr3U16D5By3acIBpfjRcF48+IDDG9aa4nn5H47fSGFF68xlMCIEDOH8Fg2DO
rPLMpwQy1/Rer3Vptu7DYnn/JZi3iwC3627yMais5pOyibqnAOa7gMj7rQhi
/2zsv8ZAyEykDIgJnW1MnpucRA6j3g+GqmeY77ihfJmYx5gxs09y/lA6W/sp
53WTNLbqnwi+qdkt9iX03+/NBLpyuVMT9+kcgU/cyFAE/Z8ksm93GPPkeQk/
y9s0J+++LC4Mapb714J51ON9XkZ9PszzIvqZVv2PK5EPqf2tuIB8AvenGZng
ewholvVXNQ+IA3ke/LR+x2mKvi0/uJ/tDLjKW95jFDq5/8Ew5nWEQp4ojOA+
VFOlj+e1RLy//RTmnA9t9Zv4nsvov/8PHs1/AU5ADBw=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfeirRkz/slqH98uPeZsvm+WAwtdF8C8o3f5Zpz7L
4WrFSzXDFbUOH4Dy25VnOShsKMqYuLrWYUmBLdd1xVkOVSLr3B+uq3W4CFT/
T36WA5/uprnvN9c6WN/3750uN8uh0zHh6YVdUL7sLAftdrGb5w7WOmw5UbZv
vswsh6WzjyhsOFfr8O8K0CIZqPkPMflg/RJQ9+lh8mHqvc2BNtoj+GD7vaDq
YfyAWocIS6ALgO7Jef575ccwiH/Cge51fwj0UXStQ+bEtzX7gf6ZLMESxhcP
9T/Qv4dB9iUhwmOHXOvrwJRaB7bGqc7d6gg+LDxhfJD94g0IvkxUinV8F9S9
ybUOwNCQWj8B6t/EWgcvHiZt9slQ9wDtB5qekz4VGl4xUPnpUP9H1DpMA8o/
h/FDah1A2o7PgJrvD3XPTKh/PBH8T5d8kwScEPxyoDv0LWsddnnyMK2egRbe
QPO1QPGnDvXPbKj8FER6AgDWMx0r
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQrd0udvNcZ53D++XHvM2XzXJA4esi+BeUbv+sU5/l
YMt1fXFBd53DB6D8duVZDh2OCU8v9NU5LCkAyijOcni8dPYRhUl1DheB6v/J
z3Io3zdfSn96nYP1ff/e6XKzHD5d8k0SmAfly85ymCzBEsa3tM5hy4myffNl
Zjnw6W6a+35jncO/KxUv1YD8TpD5RzD5YP0SUPcJYvJh6reCzFVC8MH260HV
w/gmdQ4RlkAXAN1zFajM0Arin3Cge3Oe/1750a7OIXPi25r9QP/slGt9HegE
9b8i1D5XRHgobCjKmOhe58DWONW5Wx3Bh4UnjA+yX7wBwZeJSrGO75oFCQe3
OgcgKbV+AtS/LnUOXjxM2uyTZznkgtwDtB9oek761FkOvKDwsofKT5/loAVy
j3WdwzSg/HMY37zO4WGVyLrjM6DhYQR1z8xZDjtA/tFB8IHOuO+viuCDgilP
ps5hlycP0+oZaOE9HRp/3FD/zIbaV45ITwCRDxvq
      "], CompressedData["
1:eJxVlHtI1EEQx6/DlNTSQjzz/bhUtDIiMjmqMSvrpCTBtONKEw8f5QMpFYvb
n0RZRJh/lLIRUpT+kYhEpSRcZeKFf4hGBFEhFhISYSW9CK2d3bEl4bj7uI/5
zndmNq6kJs9lNplMh8QHv0dy0i9kehh87h7J6V/DoaN61ZnHHQzG41//ckdz
KG/7dHp7M4NbtVv9C8I5ZNx7Vu9pYDAr9qev5oDHiysYDH1LdrZaOLy/fW04
1qHW+0M5mPDPrhmPd27QnNIS+mosgkHxtIgYxiHtrdW3OYDBwovGmcQoDmc/
HhiI/u2GkN7sqaY4Dkce7g00z7kBv1KTNEs96/9fv7ORw2H88cMNuL1lM/Ef
N7xrCun1ZpA+fwZTgrO3cTiFgSIp/x2UbzqDQvyxm/zJI7ZziO2rK29jDFJF
HvtzOSz6aRfx/PI1z4t8ugo190Q6SgePchVnQN33vYzDzV0P5uZ7yO9j5McN
JuvwqJr8u0zxazlM4PkmzahjrEKzrIuT7qvR+m2TuZcsVbS+hwH+e7SS4mUx
aPB0hqeVa5b+uEj/Tqb8LNK8Yt3d6zVOqlcmg6fi3iAH1cPG4ErWxeNlIn/R
LdPjm9R93oOUz1rKP5/yidcs18M0S73Byu8xcd6L8f1Jj7j/6/N9JcE+pNdB
fpqYusepGfNvL9KM+dtdFC+QgW+zUFxJ/WHV/kk/bOq+mBMcBqJFxk6KX0/1
PKf5PObbpVnOyxOm+vck+feS6lXHIcpRapucZiDaw1ZUS/u/0DxUUf1+kn+i
PnHYf/MMrgp/P7hIr8mQ+gOKNcv5KNAs/dmiWfqaxgHD5wrG/rSl0PoS2p/M
QZR5tluw7PdEDu2ox2zIui1Y6b3wMZRfVqr3UgMGcR4TyF8/Whd8H3mZZnw+
+gI04xy1LCd9CfS+BBlqvsT92HezKw2Vv5X0W+h8EumJIU7VvPjeDeMABxtQ
gfMVwaER+96s8vWG0v4Z9o9lvd5olvWaIP8t1I+jVC/xXuIctA7RfERS/3qo
32L1e7Co5y9V5mMD
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQfczbvNNxX73D++VAls4sBxg/wnLLiW9+UP60eoeL
Srd//vOa5bBDrvV1YE29Q/m++VL6HrMcLgDF6wrqHTx5mLTb3WY56N9VYWuM
rnf4Efx46WxnqLxPvQNb41TnbgeovHO9w5ICW65w21lgc+us6h12gQywmuXA
AAJm9Q5lQPPXmyH405y7c54bIfgg86X1ZjkINR84tdC63mHLibJ98lqzHGJB
BrlD3a8GNT8IYt91Zaj6+HqHh1Ui69yVoO7LQ/A7HROeXmhC8EHeT5hb72B9
3793uioifGDhBQBCrooO
      "], CompressedData["
1:eJxllF9Ik1EYxocXEtVFRaQXbstlWzGkQihkim94EREhrSAbSbJNt+loIrVM
Is4I8aKipEw4FkKWQyovpJpFiEiYDLJCY4WEaBexIgyipIuic86ew4k2GIff
d96/z/t+X6k/5m0qsFgsXvGXp2eh7nKfn9FycurAngCnG7UXo5/OMJLPi9o4
LXZuHNl3idH+tQXu7jgnW9eXQ2MDhh9Nx8cHhg03XJn8sW2U5fxOc5o96F9X
/yTHL9o5vXbM/zo/gXsR/5vMO8XoqQwQ5fT4+++5jjSj+sqH0/FmTinJL1nO
z8+pe9P7mZUZRr2iztBxw3/mOrLOI4ZVP+WGvWO2rlYXJ6sv6Fl4hXhbONll
P2+Qr5TTx7v9zzfPMoptuDCRtiP/W0ai2sVOG+zfoV8r4s8zWjksPEs4WeRv
CfUIHmyrXp35nM9K92JOVfK8ms/aXul33fAd6X/TcN9JUehtRvJIC255dupa
8RDmJ+rd+aGsMDGM/u3o/x5TcY6KfpVOD3KcEXqsl0JoLkO8kZw+P12Gtb6a
Vf1ewyqPD/sk8qmzkefskoyEqtmhIKdwz9dzNYOYZxh69mM/WqB3j2F1nzAc
kf7tqK8J8f3or8GwrldzYaK3do0L+x1gdL9EFKz3IchoSe6r0EfNuZmRWya2
o78II2l+wob5RLE/VsSPQY8S7HfczEvVwfJZz1/1tzWftb3i7f/5VxhW+1qJ
/q3op4qpOlKi/rNZ565VhP1w4H4v8jkNa73+vS+qM6z08yE/7FONYB0/AK7B
+ybmUz56azlZzUioNW4PQS8P5hfCvqL+TBj7vRvzjkDvCsPKf4dh9f668b0J
G/3UPENgB/RpBR8z3y+9H5r/AslgZ+U=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQLRhhueWERKMDiCoLnOWwbPYRhQ1AftAOudbXzrMc
HlaJrHOXb3TIE2o+4GU5y8GTh0m7XafRwfq+f+90w1kOSwpsua5bNjrIRqVY
39ec5bD9898rFZ6NDl5AdexqsxyAphVlRCP4IGX+6Qg+2L7CRofdQINXq0PN
r4K455vWLIfLvkkCEc2NDhkT39bY681yEABJdEHtM57lAHb/hEaIO6xnOUx1
7s55Pg3KB7o3pv/QV40pEP37DWY5fLoENLAH6l+NWQ46m+a+X14HtU9hlsP7
5ce8zYHuuaB0+2ed5CwHoCmLCxIaHR4Bw+G4KDQ8fBD8KyD3mSH4QNti+pUb
HdgapzpzS81ymAZyjzA0vJSg/mdpdADavk9eG+rfPw0O34MfL51thuCDw8cV
TT4EygfqB7njeAKUL9IIoTOhfBWIvHvRLAcbkL0WjQ7AWHm5rAwaXgEIPlhd
KoIPDp8yqP5iaPg1Q83Pgbp/AtS/qYjwBodvDIIPS08ASesGAQ==
      "], {{
      547.0980000000001, 1685.8039999999999`}, {557.66, 
      1685.8039999999999`}, {557.5740000000001, 1687.273}, {557.4019999999999,
       1688.3039999999999`}, {557.145, 1688.898}, {556.727, 
      1689.8229999999999`}, {556.105, 1690.5539999999999`}, {
      555.2850000000001, 1691.085}, {554.4609999999999, 1691.616}, {553.602, 
      1691.8819999999998`}, {552.707, 1691.8819999999998`}, {
      551.3319999999999, 1691.8819999999998`}, {550.0980000000001, 
      1691.3429999999998`}, {549.004, 1690.273}, {547.918, 1689.21}, {
      547.2850000000001, 1687.718}, {547.0980000000001, 
      1685.8039999999999`}}, CompressedData["
1:eJxllG9IlEEQxg8jk7Qs/2te2pGWhJkUWGg0YRFmIh2YkgZlhpqiomYmEexG
RERIH8zYCL+U0ZeQqKwIFVMzgjhNMCgTKxERswIPLJL2z3Mu0cHL8eOdmX3m
mdl3Q3G1+5Sfw+HIk4/6v1kVcrEngVNWkN+Wyw2CfFyw69FgQ76gL3dv9cXH
WT43nZgaEMNp7t5AdtoJYfJCOd2p2b1ytFSQjOpqCzScXyForUpcxsl5tCR9
vAr1Fxj9GWmcbq8RtG1soz+btVx2ffb8nq+WdfxHRu6n6y9VVAtyqN8o03q8
lYgfYuRxfVi4cFrQobQre4+/ZfS5KezBq1LLE4pLLL+c31wULPXrPA8z+o7h
vBFm+isUdCPzauXUe9QvELrOgQlGj1WfecLkSf3p47nXWt3QFwi/spEv/VT6
Z/YJylbnb+dGd4ZlHZ9q+bkyNknQz+Gc4jXJnNSpTS7ojefUIuuWOnFeGKep
3/d/uKPA/tz0H454L1tiJTd3xnKv9KH5E/yJgJ8esKwn1Ux63jBanfzwdnU0
3g8iPxrz67fcF99RW9ZrWevpMfObkfXKVX4X/I0U1Kr87vyfdX6ajfexrifr
az+2Yj9fm31o2IT9e2fqdbrwXvY3JH1YdGJe04wW1X6tExSr2GtZ77eDL3GK
6m8FN/mx6H8Vp++qfhzmE2rmW+GCvgjkJ1jW80qyHC71/0pGvyG4P6moH2T2
wbsD/i/ner8idyJf3h9/1pIZmIF9nWQmnzDvYeznfvTbb+Y3lwXuhp854GfM
7MFh+PGEkTzVVXjEsuonsehfbj8JPS8w33LMawD3U953dc+aPfC/DvdhjC19
b3T8N8t6n+YtN3a1xaQsMh3XfQb3IwDfn3pBZ9X7YHAd/Aw13Flr/faxnleU
5Xa5Hh3R3PhTi/5iMK867E8sN7olH1S6nIivt99Hn96/FXJiGw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQXb5vvpR+aZPDNOfunOfasxxsua4vLqhG8JfNPqKw
oaHJQbtd7OY5rVkOfLqb5r5vaXL4e6Xi5TKNWQ5g/Z1NDp48TNrtarMcolKs
7/t3NzkE7ZBrfa2M4C8pAJqsgODnCzUfOCU7y+HxUqAFQP1gc6RnOXQ6Jjy9
ADTfC2geu+Qsh22fgTYB7ZcFaRSb5ZAx8W2NPdB9j6pE1h0XhdpfiuBn7SmZ
LJGP4IP1ZSL0H/6qEdOfijD//fJj3uaJCPs/XfJNEohHuA/Gh7kfxo+w3HLi
mzJCP9BXvdPVEOaDxLdrIOwH69dCuA8WvujhDwAq2bIW
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{123.32799999999999`, 
     1562.4562050000004`}, {610.41, 1562.4562050000004`}, {645.8669999999998, 
     1562.4562050000004`}, {674.41, 1533.9092050000004`}, {674.41, 
     1498.4562050000004`}, {674.41, 1338.4562050000004`}, {674.41, 
     1302.9992050000003`}, {645.8669999999998, 1274.4562050000004`}, {610.41, 
     1274.4562050000004`}, {123.32799999999999`, 1274.4562050000004`}, {
     87.87499999999999, 1274.4562050000004`}, {59.328, 1302.9992050000003`}, {
     59.328, 1338.4562050000004`}, {59.328, 1498.4562050000004`}, {59.328, 
     1533.9092050000004`}, {87.87499999999999, 1562.4562050000004`}, {
     123.32799999999999`, 1562.4562050000004`}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxtVXtMzWEYPoVYjE384zYaZmuGxSzWvJjl8ocpGzOzXI9LHN93jCYKLdc1
Yvl+JlJSiDSlWpLINaaGhrWW0NyWy1CjZb7Lc/pWc7bWnn3ved/nfd7nfc+I
FZ7I1f4ulytG/qn/QYkVVRn1nF49aY1a2cehTrhW0NtzJ+8Mf2xx4YOt5en3
OEWWDEv63CCoJrjud3wZp/dtF75HfhA0dMmqqQ2XOcWvL9ty7IugeZMPTI9O
5/RBvj/9KShbpss/yOnN9gF5938LGqLiPZyqMmYVedsFZc4q+tG+kNPf57Ef
R/s5tK08fdC4ME7JYlP/bt0cat4xbdKyIRbrem2sA29URF4zmtPHP2Sfy6H+
qp9HzPBpE9QwX0YWMWqNkp21gG8uo8VhhQ9avlk8PbqpJvOTxaMCdqdWNgm6
pvq/yihrc3jgokboU8GMPvWCwgNfnN38zPBJfCFoXP3IgN1+nCaGhoYWVAv6
ovjP5fRI9vvjrqDZjVKIJE4D8yIa/9wQVCvbnpDHSZYPritG/UroWYD4V9D7
iqDXqp9PnGS1irkXwafF6JOYJWiKGpifl0Yq/qeF0aOnl77m3JtX7Fis+R+1
WPe3Vxg9f3KjTxzeq7nWY6ZX0H014IucFDy0Hng7p1D1WYP4aRYnfV5QMmys
xWGK32BOt3+NWXrYF98b+d2C+o69euqr1G+GmocbejQzqpTx/dbBX9XQe4Og
uAFSyHzMc6Og8Ur/U8zU8yA+1WL9ntzlfR/8sQn59jDjT5lP+y+ekRpDRIyg
ZaXSaXHMzGsd4mNZR386n/v/uCCtc7zC2v+7kD8F/R9ilCsX5fp+YfbzBKME
6YegRPgth5FUP8a9E/4uQ75Y7OtLZvy2xTdP8GHIHwQ/eZB/ksVK1oqlFkco
YnGcjst67xn8fJQbPtvA/zynS2qxd0CvQnx/Txd8wGIdnyzIpT75nJSsISnQ
K4frfQxOFaRkaTwNfAL7lYJ9SUN8AvKfEeZ+eDm1y3uSnQn/LICfchA/GH67
Av7vzD6/LQK/cuhX5uMDP9zC/TvCzP7ehb8TgKuAvYivEbQ2RWZ0I18t8i2H
X+ss1n5+Y7G+t83wC8c9akU/qbh/8t7p9xLzPrOXY77fxDruu69fH9b6hFus
+4/GPQl0jN57oXcA7q+D+XR3SJ2b/Czss+8e51qs51losb7/pZw8atEl1vf/
Ju55D9S/g3nIelq/h9zcK9lPp98jyfcfSVMlzA==
      "], CompressedData["
1:eJxlk21Ik1EUx8eCgupDZARRmI2C0A8Fq1Zba2essLIwJ0KYmaiZL6tG9yYh
shhjiEiURB2hT64khIjACinRZbLJhLFGaBJhMUxDKiyiQozuvc+RS+3Dw31+
9557Xv7n3C3VF71nzSaTCcQn164La0NRO4NrKH4SCKefHVltHmIwmfxZmplA
UOepbN66PHjr5SBCy7qHhR8+Mvh6P1ZkG0UIz5X05y4yuOd3rpxIIux4Jyxz
OLirplORNMqwJlM+B29/brhpHCHv0aX6TjeHmYXeee8bhHiRrd1drrm+83Or
K6xZ+e/l8Ks007PxNfmLcdhltVr7xhDKax1TxZ84iHCWUy8QKmU9C0a8uT7N
sp6au5pVvjcQ7I9HmwenOYjdgrYgxX/OIdF96Cm7jBCT+XVxkGW3NCFkeu6M
5Pm4oV8d6WfTnN+2fjK5+T9eRfmdW4pv6L+sASFlefs78IWB3C5oRBDRd1e+
p/74tP7K3q9Z6VOs+ZXw86cQ1RpI07mH9BondiPkhKKJ7kliF8ImKeAUgwZR
95CT/M0yCDQO8Jv7SZ95ZvTPQf7MHGbF/bSd+r0hm1X+e6i+vSyLl+yVvgc1
S6wqY6oPQ4K/pY9Xr6llMPxje8V1B9n7GWwT8+hxEjczNW+WAwjt8qeFgTzu
cFG+AWb0003zEmSq7jMe6keIwQO5cViz0vvEvxx6ovnkPiHMAOkTpPcSpfm5
Su9lGEFei7Ya+UVGSN8rDI6Kdq+IkT1jMCby+x4jf+cZ3PZ0+GbiCHKMS+oM
/zXivUWE2WKF5p1S7zLNqt5j9B7jpDdQPsL/Xyqe20I=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQPSNPqPnAhWKHm+e+Bz/ePt0Bxn/xe+XHS/0I/o/g
x0ul26c7PF46+4jCpWKHqc7dOemN0x0WuW77/PdKsYMxEGyum+4QlWJ93/9m
scO/KxUv1aqmOzCAwBMovwyq/gtUfRHUPLYSh4dVIuvc86c7AG07tVC6xKEu
a0/J5NzpDgZ3VdgaTRH8TseEpxdCEHyw/rwSB6Drl84umO6gD1LfWAIxvwyq
flYJ3H1g+eUlDtOA7n/eieA/B/o3aAaCv1omKmX3iukOra8Dd8jNLHEAmqIU
vXW6wwWl2z/raiDmGe+D8jOg7j8CDa8AqHnHpztkTHxbY2+K4B/zNu90VEPw
weElXgIO/+RjUPM4Shx6pwMNOgKV/1vsAPKG0mGo+a+KHYJ2yLW+3oeIH1j8
AQAOHOcD
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQHbvLk4dpeanDqYWu24oFZjg8Xjr7iMIWBD8qxfq+
//5Shzyh5gNe/DMcLijd/ll3otShd3qeEDPvDAfh5gOnFl4sdXi//Jj3dq4Z
Dse8zTsdr5U6BO2Qa33NjuA7Jjy9sIgFwV9SYMsVzojQD3SFdvu/6XDzjUHg
z3S4/UDtQJnpcPeBpDf/mO4Acz+Mr90udvPcTAT/0FeNmP4+hP6MiW9r7FsR
5suCLKhG2A+WL0e4D8aHuR/Gh/lPC2RfNcL/i1y3ff7bgggfsHv7EOGnf1eF
rXEmInzRwx8Aomq2RA==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQDQbnSh2e/175MejGdAcYvz5rT4lwE4Kf8PSCUnT1
dAeZqBTr++dLHW6e+x78uGy6g+WWE2X7Lpc6OAIVLCqZ7qCwoShj4vVSh6Ad
cq3ZRdMdQMr975Y6PKwSWXe8YLrDItdtn/8+KXUwMTY23pw/3QGkff6bUgeg
aUtn50132Ari/4LaD+TH7vLkYeIvw+C/ALr3UuZ0hwtKt3/W2ZVi8GHqwfYH
o/ETSx3qgPzJeVD1GVA+0D1a7WI3z+VD+UD3KoL8U1rqsAbkcaB/rEAOroTK
A/0rCzKwttTh9EKgx8qg4dVQ6nAKyC+uRvBRwhMmvxpNfvt0h0NfNWL666Dh
sQ8avtVQ+UPQ8IXZf2S6A1DVEYWyUoc8oeYDXsemO+jfVWFrLCx1UGVrnOp8
fLpDJyhicqD8E9Md3tbYm8allToAVU09DOQf8zbvdIxD8MH+DUXw40Dh7V3q
AKK0TyDCt3d6nhDzcaj7LUodjEHg9HSHjIlAG3Yi0hMAzA0RFg==
      "], CompressedData["
1:eJxllAtIk1EUx5eFQklEVgQ9sBcEI5LsQVl5TKJchLmgh1QMS1jSHs1x75jD
sIiIkBCxGwSFUoEoFliWD8Z0tq0ZtixKiRoSZREWJdELoXvvd64X2gfj47fv
nnvO+Z//vcvKXNbyNJPJZOU/8bbXjQfyewlUV/R463sZZN/12OsmCLQsLj3R
nWCw9s3K9JoVFMb+Nn+zDjNo2tkxMblPc2L569/Vds33YiR4I0DB9p5/eckg
R8TXUhho5IHPGTxcev5zyXUKlsw0c8YzBptFQAuFXPE8YbBF8H0Kcb6+8hED
5px7LtRDYdQ/ry0aYhDZs+liQYhCXrK4lnVqHhn8uf/dHc1neD9ZZzWL+F1V
DL4E8jcc66PQVZSZ1kJw/wiFVek1DYVeBlGxPk5B/G3xYH1PMb+bgdTrFYX1
vNx2FwOx7ehbCjz7rWtOBvULZxyYPY75ndjPNF8Kf+R6DZ1EfdbQFFbrZf0b
Ncv6LP99P4Txim04DzeyHedxmoH5woKRQQeFX7zeRV6cpxv3owx4F/3ZHgqt
fP55PgZXhRCcrxReOjVWpVnpq7iWCzm9TbOLv+IPGGTxV6MD44Pop+NYX5gB
z5IsPmzk645ivbvRL4+RczRLfWdp/j60t2zOB2L014/z4X4Wdmrv0qzqVSz1
8jOoEvPrI3DTvW3mQYL5IgQK+IZNXuwnjt89yAli+EfpO0xgh1jP/SBkSyaJ
4U8n9vuVTM3rqAjMoCms5i/3X0dSWK03iWerZjnPEs19P1YfuWwjxvlxqfkb
euR6sD4Xgfm87T9e9HclMc6HX7PSS7HUu1mzrK+DQVjk8xCYfOH7dDuI+dyY
n98nS0Q+B+7P59Mpzn8F1hNBv5cjR/H+4PVL/8XQj6UE+KqGcAz7t2qW/inS
LM/jdmM+5pjWT/ozivWbMd8A+r+VTN1fyh+K/wHz6G5Y
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQDQbfKhye/175MejGdIfYXZ48TOaVcH7r68AdctmV
Dv+uVLxUuzTd4aLS7Z91kyodXgDlLx2d7gDWv6XS4WGVyDr33dMdpucJNR84
UukAMkZ7PYLfC2IsRPBvnvse/Hj6dAf9uypsjbuh5vdNd1jkuu3z3xVQ+1um
O2w5UbZv/rRKB6DpD6uqpjtEpVjf96+tdGBrnOrMXQxVHwMxnzkPqt4Gys+c
7nDoq0ZMvwTU/rTpDjNA9n+ogPM/XfJNEtiA4IPdV1PhEGG55cS3HCg/rALi
3srpDm9r7E3jzCocgK6eehjovmPe5p2OahUOpxcCHTIBwT8F5BfPQ/DB4bMC
Gl4GFRD3b4L637nCQRVk3m5oeIdD3QMM32qQxwsqHIyBYPMZqPsnQOPrItR/
QPeLApX9ujrdYacc0IRLiPhEj18AbFPs8g==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQrX9Xha3xeYWDMRBsvjDdIXaXJw/TdQR/h1zr68Bj
FQ4RlltOlJ2f7mAAUr+1wqF3ep4Q89npDp2OCU8vLKlwYGuc6tx9arpDVIr1
ff/pFQ5rZICsY9MdFrlu+/y3p8KhPmtPifCB6Q5bT5Ttm99U4TDNuTvn+U6o
ebUQ879tRPBVQQauQPBB1iyaMd1BFmRBZ4XDvysVL9W6pzvMyBNqPrCowuHF
75UfL9VPd1DYUJQxcXeFA9AX2u0lUPffqXC4ee578OM8qHtYKuF8sHuVEXyw
eptKiP+KpjswgEBAJcQ9FdMdgLadWpgMkW+ug7ovtxLi304E/9RC123FMxB8
sHtWT3eYLMESxhcL5e+a7nDM27zT0Qaq/uh0h0+XfJME1CodTgP5n89Md9Bu
F7t5jrMSHh/o8QUAZ/fJkQ==
      "], CompressedData["
1:eJxlk21Ik1EUx9eC9aWotIwiykmtl0FSM6L64DEJiYhofQmJEDOwiMdsZe7c
YSyLXqQXiXX7ZgZ96JXAEO3NzZc5thhThBKRsAgLK6wo6YXonrszL+EDY/ye
e889////nsdZXuU9YLfZbFvUj/43PYrVPA8ijP6+/cX7SkKGPfSEJTgfHq1s
vIUwgvMelKQkfA4Urt8XN/uj2zecLxo3TFg2TUxyLtXPFnBRWlnTX0q4bmXV
hxcJGExO7N4/IOFr/47yOS4BVep1vE/CRurvFrpfb9KwPi/x/3pJTAKVNa8Q
UKDktvRIyB9e5gguFVB36Omxq13MCwSo3SMYkeA+mzOYnCUg3ry11af89eUN
/ayzG9bnTeAkaz9jCG9IT4TzGeb1btafQvg7UPvB1SvBRk8Utd/6GPfvMKz7
txvWfloQ7i0urXii6isbPwUK73P+UeYmhPlK/69Ozu8Kpv0+M/el82k1TPm+
PWV4j2r0IyCBsOk0pvOoZf8X2M9xXr/E5/lYbwjBEQwVN1SzvxsIRWXvUnlH
JLQvOTO26w6Cchnqsliv8ndS5Z+tmGyGX0zl9+r8/oPsZ9w/hTP7O7+v3HvZ
YerPUeMcBG+bamxxvs60nptKT2nF5tc7V7H/at6/BoHkDvlY/zpMz0cN13sQ
rhU3HB49wfNcwPkKwwmVz7egYV1/17DW18b+PXy/HcxrWU+EOR9hOQXazf3d
fL89rM/F56l5SNH95PI8qHnJpvlcyHln5muu4dV0XzMMC7roP354vG2m3R0z
+ervMTOvH/3p8xPMlvme/wHkL/KQ
      "], CompressedData["
1:eJxllG1IlEEQxy8DAwmCTIIyMcm+RGmUREk1JmUZFBliWIS9WZ3aSWW+zGrJ
YRJWYEeuIWVWVoJIaoZWqHRhZZhWnhYSIhIa0uuXqCia3Z1zoR54ePjxzP5n
9j+zO3+vK+lAgMPhSKZXfUdrqx6HpwoY+1X3NemNBD9HBhZf9DZLaHl6or06
0bI8MtPducZwfIeEqHcLAoujBJx0Pjwe/EQCzmpIGAkVsEw9zyV8EmtjdgcJ
SHvfF7GzV8JNkr/zDaG7Zv29Yy8lzEvdHzvss+xQT6flj2p9A0IIyf7sZf2r
aPL1cH4Pmnzd/P8sx3dZ1npey3p9B+cvR7P/B8xVrNcqIVrp1yIkTg9YNK1F
Qm579ZyoNoR1tKFrjRIKlN4AwjkyZmqDhM0rzsSlzRWwnJY31/J+yU9dz2X2
o0CAi2zs9liOUwaVWr6RvToopVCCCqvJEKb+HO7PFmaXhLuqP9EC+iKGfhQd
5vgZQtfjTpdQMrGtNWwCJ7lS9a/vH25CU+9Bji9nf5zc79Oo+zdE3KU2WISm
/xmcL9fy8FZSzras/XYi1IeSsU72K539PcR+pfzPur7zNt7Put8uBCVf5pbg
y/uwcOkpBFVmInK+SpPfS35tHCGFRoTPt6jybNbv4XnI4n5PWNb6U8Qkaz+C
hem/3+9wnu+j7McSnu8cjo8RcH8TLci3rOel0LKeFzfP12IBKry0lOc9jPXL
eN6onxXxZZljtP8sNahfEIqoPx4P++9l/y5xPRUI4xT26grXm4fw9sX37aPX
+Tw7De+7zf93oZ63wXoJwUovGWHHSvrTZFn3s81yLDV69iP2dw/HP2M/81m/
l8/zBaOf4mP/G3HyvlFjMTxoWZ+Xccvar98ISa1hJRmDzCHsp485Upj8/RLU
p53uI73f19ZvP+vzs8qyro/usz/9NEj9PD9g/G8mTlD7ixdmfilfpipsA8/H
gL0f/fX+BUQrdVs=
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQLdx84NTCjQkOL36v/Hhp5zSHLSfK9s1vS3C4ee57
8ONr0xxaXwfukCtNcDi90HXb50fTHB4vnX1EoSTBASi7dPaTaQ6hfLqb5hYn
ODysElnn/gzBB6t/juD/AKqXfjPNoRqo7GFVgsO/KxUv1d5PcwDb35ngUJ+1
p0T44zSHAluu64tnJDh48TBps3+e5nDc27zTcU2CQ+/0PCHmL1D5Iwh+GMj8
2wj+VpD73yH0g83/izB//3wp/bs8iXD7weaJJDrUAeUnv0HwnwPDI+glgm9i
bGy8+fE0hwmHvmrE8Cc6WN/3751+Fxo+rIkQ+69Dw+cGIjwBmZ+vnQ==
      
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQ7Z8kEGEpE+/w4vfKj5d2TnPwA/GPxDk8B/KDrk9z
uP2zLmvPmjiHqc7dOen3pzk8rBJZ574wzmEakP/8CYIP1v8cwa/P2lMi/Gaa
wxqZqBTr9XEO/65UvFR7P81Bha1xqvNpqPxHqPzzOAcvHiZt9s/THDInvq2x
54136J2eJ8T8Bcq3RfA3zX2//Fg2gn9RCejCSfFw/WD7N8bDzQepa74Q7/Aj
+PFSaaD9x73NOx0fxDsAVT2seoPgG4PASwT/O1D97GfTHLiuLy6wvQTlP5jm
0Hzg1ELXbVD116HqExDhBwD/06R6
      "], CompressedData["
1:eJxllQtMz1EUx1tMhjHyaMqricysmawZ5iRNxNqyYZ6590ceqShZsYxYIyF0
PZJn5lEMebS8Io80w5g1YS2xhJK3Mpv7+P67w39r7fO/j/M933PO/fdjcZHz
3d3c3GLkn/rfa4YzsirOocxdsV1afRXkYr82a7NDbguqXz1m+JxIy/Gj21Uc
CXPo47E74UEPBC1fmFW/OsihPLkw7amgVV1Pj6/u7VBw1JtHhysFDRzatsCn
jUPTR5wv+14laE7xhA7uNZyGqc9rQZOCNgZHXeBU++vEp8haQVM7DjmXm86p
/FDoxYR3gk5+ejyZTedG3wdBW29+85810LKb+jSyFtbxbjISIRkxtXWCnj34
MaUml1GgDFf4BpzMSMlMqRbko/KNZlpP4QvLWk/F3+vDniB+AqPIot4bljwU
1KD82YT49wVtU+v5jJRd7e8K8kwrKT/UhP0lyHcF1/74FuF8JTf+nRXm+z7G
P98C1CPE1CftuKBrB3oGvFzomDzycN8GhyQdzTkoKFzxHsfkm4P1Uw69lfk8
FtB/yaHLsgz5WZZ1fTdb1vrXob67HCpQRiTDj2m4b5kwurwcU6/FglKUsXc4
9ZcXlC5APzDL+r4Qy7peAziVyrCdorG/Haexqn+isd7MqJv8ujka8SsYrVRG
LII/R5jRv0SQdOFW33hm/FwqKEHFi2DaLx6L+gdb1voDLY+TbfNrkOGapeh/
X3CMoAtlSTKyqed7Ge9w6MUvv7tifRH878xa8tP6vsz7j9csvpLomW33u1jP
Rx9GqvwzMwQFvJQnhzIaWRWR2WM96h+GfNcg3yim5yspBfengZPAhdifgP2v
cV889HuZeUqLdc27ZT3vOy3r/WVmfgvj0e8fudG/QtDVxB1erbujH5KR3yC8
B6n/8HrL2s90+N8P/ZiBfvTE/i2I3xr9uR16G7h5j7Kh5yHmazfqVQzei/vX
cuPvfsyHHzf9nOfKD/Ofj/jpeC/O4D2Kwvp56B+B96EI75c3M/lfwXkP1PcG
WNZfzdPl2zhfN0/reV5uWZ9/ZPmnnG9v+Z7OVv3hgftfIf+x4Dr4nwq9jej3
e6zlfdfsx1tY+zLXsn5P93Ez758F5at8X6DeDfCvidPEDu6DPerRr50ck/8H
+O9tWfvpb1n3X6D5/bgk+brq51Gm3qX10BfqkOy2kvIGnJ+E967R/h659P4B
yGUWkA==
      "], CompressedData["
1:eJxTTMoPSmViYGBwAGIQffPc9+DHgqkOvdPzhJj3THN4W2NvGvcp1QEknnx8
msP++VL6dwXSMPhg9ZumOVxQuv2zzizNga1xqjP3rmkOqz9e8k2KSXPY7cnD
tHo/1LwmiP7Hh6Y5rALJr0hzcEx4ekHpGJR/Ic1BFWjAYaD570DqfyH4oXy6
m+Y6p8P5hbZc1xc3pDvsApqvfWSag7d5p2PCxnSIe/ZOc/AB8d+mO7xffszb
fMs0hwmHvmrEcGc45Ak1Hzi1AsFXAZk3C8EH6++e5tAP4j9PdxBd5/7wVy1U
fn66g4mxsfHmYqh7ktMd1shEpVhnT3MoALlHAmp/OtS/+9Lg/FiQQ6cj+Itc
t33+W5IG1r87Her/CGh4ZELtd4bys6Y5FGdMfFujnebwI/jxUukcRPjXZ+0p
Ec5H8J//XvkxKBhN3neagyzQmfeF0xy2nCjbJ+85DRIPkmkOpxa6bit2h8rL
pzlkAq3Z7woNfy1ofLtAw9cSyneG+tcDyneCuj8FGr+O0PjvweQbg4Ad1H7e
VAw+TD2YVkTwq0WAEWGX6qDdLnbzHJAPCvb74amQdOcE9W9OqsNpoH8+A91X
BVJfBjF/M9D9F0Hq6qDmuUL92wxJ781A/+vfBaaEzlRIeHvC3JsKTm/Ovgg+
WH8wgg92/yoEHxzeG6Y5qBtyrJHpSnXIB6W3zVD/tELz01YovxGa37ZPc3AC
2VudCkmvO6DyhVD5ndMg7syAmrcT6v5oqP27oHxvBB/sD3sEPw6U/vRTIelt
JzQ9S6c6vACml0tA+wANc9wT
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQvX++lP5dgTQHx4SnF5TWTHOA8euz9pQIdyH4xkCw
uWmagxNInXCaA4i6XTvNQSYqxfq+eJpDHVD95OppEHPk0xxMQOrLpzl4m3c6
JhimOeQJNR/wKpnm8LbG3jTOL83h5rnvwcmF0xwmHPqqEZOd5hBhueVEWd40
B1mQef1pDr3T84SYc6H83Qh+6+vAHXIfEfzVHy/5JsmkO1jf9++dnj/NwQdk
n226gwpb49TDQPtWgeQz0h2AXOduoPtA9j6uhagXb0Xwwe6ZiOCD3Tsfal5q
uoMXD5M2+yqoeSbpEP9uhPpHKN1hNTAgdm+b5uDSnfP898s0h+e/V34M2gn1
324EX7j5wKmFCxF8sHkdaQ6eQPPbd0DV56c5nF7ouu3zNqj/YtIc1oDM3wqN
DxtofG1CxA8s/gAICtkp
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7ZTw9IKScabDqYWu24q/T3PwNu90TPBE8Fd/vOSb
FJPpEGG55UTZt2kOj5fOPqKQk+nQOz1PqPnLNAcroPC+6kwHtsapzt2fpjmE
8ulumtuc6bDLk4dJ+wOCf/Pc9+Dktwi+9X3/3umvEPqNQeAFwnww/xnC/jUy
USnWTxDuUwVZ+HiaA8z9MP6dn3VZe2QQfOHmA6cWciL0g/k/M+Dmg9z1+GUG
3H51Q441Mo8y4O6D8WHuh/Fh/oPph/kfZj4sfDImvq2x50SEH9g/MojwRQ9/
AK/7vCo=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQLdR84NTC0kwHVbbGqYePT3OA8U8tdN1WXIfgr5aJ
StldMc3h1s+6rD0VmQ5BO+RaX5dMc3BMeHpBqT7ToXd6nhBz8TSHbxox/Yda
MyHihdMcwvl0N83tz3T4sPyY9/b8aQ6FtlzXF8/JdFAB2Zc3zeHmue/Bj1dm
OiwpAErkQvUfzASLJwP5j5fOPqLwBJP/4vfKj5cypzkIg9zXmIHBh6nPmPi2
xn4pgt/6OnCH3F6oehj/ZIaDMRBsBrrHx7zTMeFqhgPQlyWT86H+u5/hILrO
/eGvgmkO6oYca2SeZTicBobP5yKo+rdQfgnUvI8ZDg+rRNYdr0DwYeEJ4zsB
zV20EMEHhV/z6mkOM4DUgXcZDtOcu3Oeb4Ta9wrq3i3THIC+MY2D2b8NGp4P
MsDxkb1jmgMoGBffyADHp/NOqPyFDAfr+/694rug8XkUah+QHwaKn+0I/r75
Uvp3VyD4QG+4P5wG4TPvQoQvmA80f8uJsn3zy6DhtWeaw1YQPwiRngAMQDEp

      "], CompressedData["
1:eJxllHtIk1EYxscMuyj9YZZBFmSLhAi1RZEkvSbS7a82KqmIyKT6vrObW7ai
FhIRZCEmnoKI0mURmqCbTjeNblhYhEowooJCoiKESuiK0bm8x0NsML79ds73
nvd53uf7Fu/3OKqsFovFwb782lLeMzGZbcJQc3mPP0ohIxn2lhgmfPhz+6vj
PoXi6JOauwkTlqbXNj18TKHgjS29diaZ4jOft/UuKtLMr2VOAhcuubNOD1Kw
8I9XctojCr6SWcnweVxn9asPNYyfCBNoKqsjBweo/D9KYJXdbo/EkO8RaM/d
dSARoTCc9+pXaJDAhn3vh1vuaH75/IezslWz0BPSPPki+OlmkMKyohntuUME
2ni9AOoZIWDn51VTKGV185IEtmRal0/34flvCXy5Nbg15qFQyPePE7BxvW4K
o7z+bwI3vEyYi0I3s+talkv2w3gg0Dh/2upU/sj8HT1MQfj/zExhtV/499r8
//6/mpk5Q81zsV/Wz9745kzrEiLn50G/C1G/F/UXEwgZ/YFGptfP/V9P4BTj
OUcofM/fU/+gFLkG65VJf+zHNCt/FYv+w5p/OsdaF7Rjnth5wtcu1Jcv5zXW
TWHH7BVdV3Nwnn3KT1P6nlDz0TzC1y9q3s7vd5qyvxjWZ3kW+jo0q34Vvzue
3bGR5WEtz3eOCRX8RwDnu1DWT/NTYKcZ/TYTeKwzfKivwBT6rnhwPuvk+RE3
1t+E83Rhviv1vITfdams5i/05RkprPYLXqlZ1N+pWfjiNaR+N+o5acBTpn+C
zf8yf5zOGTIffvS3Ac87qln5pVjsv65Z+NeG/ddj/U6lB/dHsb+zhnzeeiiI
uNUawOOwuxf9Chpyfn2YV9a/yF8c811lSF1x9LtCs/Rbs8jZGslpce2f4D58
H8xDf/px/Zsx9f5S+VD8D6omcz8=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQfdzbvNPxRp6DKlvj1MPHpzlUiaxzf+iWD+cXZ0x8
WzM/36F3ep5Q86FpDlzXFxfYPoLwmXdMcxBuPnBqIW+BA1C5M/f6aQ6yUSnW
96ULHFRA+pcg+I4JTy8ozUTwIyy3nPg2YZoDAwiIFDgYA8HmjmkOb2vsTeNY
Chye/175MahhmgPIeQkv8x1OL3Td9rkcav++fAcnoHmLCqeB3encnu9w89z3
4OTcaQ5g/wTkQ+zLnOZQDfKPENS96VD15/PgfP27QJcmIvjcIPO58hxA2qpy
pjmAvG9/MtfhFND+YqD9F5Vu/6yblAtxbwPUvPJch/qsPSXC3Qh+HZA/eRqC
P825O+f5vGkOQG+X7WuH6DdePs3h1k+gyhVQ84Hh5wJU9hto3xqZqJTd26c5
fNOI6T/0NdcB5J3be6c5WIH0a+c5vACGz6WDUPVA9z8CRtzxo9D4mo2IT/T4
BQAfBuD1
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQbbXlRNm+/XkOqmyNU50PTnPoP/RVI2Yxgh+7y5OH
qT3P4f3yY97mB6Y5zMgTaj6QlefgmPD0gtK+aQ5va+xN4/zyHEDKufdA9Zvn
Odw89z04ecc0h28aMf2HVKHqN09zYAABEYj847XTHNTAGqHyyxF8sPw8BN8J
KL9o4jSHVR8v+SYp5DkYg0Ab1D1eeQ51WXtKJtdMc1jkuu3z35I8h9MLgYyi
aQ53fgJl1kDNz4O65yOC72Pe6Zigmg/ny0alWN/3z3d4WCWy7njBNIeMiUAf
FuY71APNFy6b5nBR6fbPukn5DlOdu3PSq6dBwmlxvgMwlLTbWxD8U0D7iyci
+P+uVLxcthAaPu1Q/eumOYDDH2ifCdA7m7dPc3Dpznn+WxNq3z4o/yciPtDj
CwAg0c5A
      "], CompressedData["
1:eJxlk3tI01EUx4eFgZh/2MNoEDVKwhES9iBkdtRimZQwyaAsoiW95navLh9T
JiIREhEh3gKJ0FLoJeXW0h/LhlqKf5hEIVJhJqESIwoiS4zu49QtHYzx4dx7
zvd8v7vrjnscRTEmkymLf8VvwqaO65+fENgQW9vY28/gX84OMBjLu3TV/ZaA
o3PN+U8RBjuCA2Xds/POm+lf7v22sfByiubWpr61D7ZRyDz2cbjlOYPXFdPJ
m4HC6ND3fGcfA+uFlaNDORSMnPgYaw+e309hJn+itemp5jT+CYT/r5sNBuXd
N1an5lKl7zH236XmWUIMDp1IH8uzUbhFbHEHgwwaVi0uSNhKYbB5d6iU72eL
G7lJrJr7c7fXZ1o0pwh9SRTShRFB7B+v9E/w/m1Cjwn1d2F9hsDk7O0vDgPr
XzXLfaOae4RfUwR+vaqYbuP3i0XhA9Y7Ue8IUX48YnDNnVgXGSRqv4c6L6nn
jmZZr9Es9Cf5MM8IgXHf8nZ7GYMMsf8zAluEv6U4f4AAy77omqQMjojFXhBo
5HySMLCLi1yPyCPNw2DY8uaH/z2BFe328Z/FmEdU6XFy3iPOzy3kKT7m5Wmc
l7WQ/5yX+g5olv2dyg+zG/12EfCfCXsbuJ56sXgJgTnhJ9eb+m59bG05AWHH
4RI871P6A16sV+H8c1ivJrCXx7mkUrPMw69Z+tU8r36Pwakr0eqdVcr/lg78
f1UiB/H9cD3C1rshzN+r8k/meS8VeXkI1PB9lnXh/bOox0D/igjwFBPrDHwP
RzXLPAo0Sz37FC8ytL+SeX+X4Az0L4z+3tfv+zf4GQpG
      "], CompressedData["
1:eJxdk11IVFEQxxf7Aq0o8yksaqMIQiIyLEUcWSRao1Bfwj4QKzasTM5ZVGxT
Y5ES8yHS44PEornErmmpKX6xbFi7USAVQkQPsolUSIn1ECFFc+7914EuLHd/
d+bOmfnP/24vv1J8PsnhcOTyT99T/dEXXR5JrR2Vqf5birIfP6+OnJZ04hD/
aVT02vn+Z71b0n591SjaUnouZzbD5qEqRTWRwOa9GyU9SOdAhaLc5Lf3qpaE
VW+FR5EuF5g23LRQNLo1aPjyx+XQUqOgsvlXzpMXFc0FO59uKxfUUDHp3eRF
PZegRF1af9yHeKagI2uT9ty4aViXKe4wnKn7C+K8AtQfAHuQP67owu0vvrxm
u/7hKUXxwqzm/EFBO1dfb5+Ko94Hw+szBu8urpL/2Opvh6R30z9Kzj5TNKzn
zZaUzwd2R6FnkR2fm1Cky5exvi+7Cka+jxj+xP28GTBs9fdQkUNfpdLurw/x
EmnP16voKj9OHJX0e6b2866wIr22iAv9hND/QcOzx1n53Yat/aSj3zA4zWZn
H97fIInHdbX0Q791khbvxwqzuF/LPynIH4Z+yXZ+yhj2u1KSm/e1ZhL5y9hv
BPnfwFHMNw9+gvlmDH/15R04M264m2X81SOI1Q12RpDfhv2PoV6DsP07hPm8
gnK0EGHD1n4Chi1/tsMf/D5Pf8nTgngbzvfDDyFBvez/iTpFek2JmKB6jt+p
xvkL/zH75y9reR+x/pVamFrE99n+cl3D/smOu/l7jOmEY5J6qth5TdjPKfir
VdEfvwHLNw==
      "], CompressedData["
1:eJxFlH1I00EYx4dFYomEmUaUmGRF9kKsiBDpKSlLqUgjyiLCFzRfZnnntJQs
RphISAzPP6TUXnSms2nltlxL8zUFSyFCJERFNKTMwoz6p7v7PfMGY3x2d8/z
fb73PLcpMTsuxUun053nX/EbYstJu59BYaDmSOsvI4OfwycSVx+l0LghIbkt
m8G7hW0Xy3ZRuJnuouYMBuZ1y8/6hVHo5/tJOoOnlV0htkAKBn9Te38ag8iV
nx9f9cZ4qQwSkiPGTi2SJfbb2fJg7oviO7OnHcHvCfBd94J4vJJDl6c+OgiM
DC7GJxkY8L8rDBYCc3U9sfYcBo5gfqKaQHlUaWZqvmKpp0gx4+vTJuQnBMJW
3C7vLEZuJMCj+i8rRX12jU1lDD7lf92yp59o9Zux3ikCe/V6/YsK9EdHNa5k
UBDQFD2+gwIPH1VazcDjp8gXVatY1DNZr/jcgZd9v1sYhBcHjgymUNCLj5OB
U+hLQL9dDO4KP05SWMvT/H2L/kVi/g4G28X5rYqln0GKN4oCfTBeu9I//a9+
Ps6N6wsEYny9wr1d6P8PAnHcqAynYulPK+qfJ7BZ+GlT3Hbc16vBivf1nch+
iGlAv2cIHOZhHvH6J0XDTKD/FqxnhGj112E9HxTL9W7FUu8bIv1eZcH8drxf
Hj92P1fcjHo9+ZsI8PSho1bFM7z+YZtiLj+8uBXzOQlM3Aho6m3D/hgiS/5J
P2a0eBe6GazhbV/jo913Zy/q1yuW9Z5RLOfFQLX+7UH9JryvTgZ57qr1u80U
/sTzkx24/6HWP0luvL9aqvn3GvvvGQUhK9SOeq0Uxrn+6GbFcj4siqU/JYrl
/N7C+q1afxoLcP057r/OgP/rrrJhv+ehHy3aexFhxH5+hf2WyyBLNJqDavNI
8T1x4bqH2xXLersUfys8uO9SH+qj6NcAzlcu+jWE9RtR/yiez8f7mEUuVOx5
7+T9DOJ8ZTI4JoxrRn/TUB9TLPOXKJb5izD/FVzPw/vi76WwZSybavORhf3L
51/22zX1Hnj0/AcdtZyM
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQrbChKGNidonDqYWu24prpznA+MYgsADKdy5xWCMT
lWI9Z5qDcPOBUws1SxyCdsi1Zs+c5qDdLnbznGyJgypb49TD06c5dDomPL3A
UeKwpMCW6/oUqPzPYodHVSLrjk+Eyn8odqjL2lMyuW+agxZI/nmxw1Tn7pz0
7mkOQFvu+z8uBpv/uh3BB2lTakHwQeaH109zyH3+e+XHF8UOIOno6mkOIG2B
X4oh7q+Amv+/2KEeaJ9wKVQ9T4lD7/Q8oeZiqLw0gv946ewjCgYI/jIgd4NX
icMLoLZLZYjwgYUXABUNl8M=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQbXBXha2xtdTh1ELXbcXfpzmg8OsQ/NUyUSm7K6Y5
tL4O3CHXXupwGij/uWSaw0Wl2z/rukod6rP2lAgXT3PQbhe7ea631GENUL11
4TSHapF17g8nlTq8+L3y46X8aQ5WW06U7ZsJ5edNc5iRJ9R8YEGpQ8LTC0q3
c6c5CDcfOLVwbanDzXPfg5OB/Asg8w9g8sH6M6Hu48Xkw9TvkAO6WA7BB9uv
CVUP5FuC+PqlDsZAsBnoHlmgs++bljrUAf0zGejerUDp+ValDqJAb/wqmObA
AAJ2UP8XTXPQB9nniAiPjIlva+ydSx0eVomsO16B4MPCE8Z/DrQ/6CKC/yP4
8dLZt6c57AS516nUIQjk8IdQ/zqUOqiyNU51fjLNAeTc+UD7HYEBtujZNAch
UHhZQ+VfQN1jDpFXegnlG5c69E7PE2J+BQ0PPah7XkH9o4HgLwJ6468Cgg90
1REFiVKHac7dOc9fooU30L7poPhjg/rnDdS+YkR6AgDe6i26
      "], CompressedData["
1:eJxFk2tIVFEQxxeLFVIisgyqD+tSEUVJGPQQYUzCMlKwL1EhoYWiVku5c0TK
ViRUzCLCY7CUZG7hbppmCj64bm1qD1hMeiAVUhFWEGIPQkppzrkD58Ll3t+d
mTMz/5mblH8q93iMw+FIo1s9hdW8MjlJQEPTyaXVFyUcOpY6mbNCwMEdD56g
T8KP8f35SxYKSFGXkJC26M0tzxRq7vZIuEZh4WcId1dTZLGEvP698TEh1Oct
KJTwqvzrui21hgP+x67OPMMv3G9nK3ciHP085j5cIiHzQ8WyjlUI54sHyxLK
JLTs7v05988L6vPoWQl71Mt3L1CWjTW1hqf+ts3kNhnequoLcL55r31+l4Tb
il1o+/dLqEsnyy7U52dGJGyoSZyIliCsdVY1Rka5Hr/h5PdrnFVDhnV97xAm
on8OFAxzv78Q1LEtYdYzTmj7pwEJpSpxooDnNymw1/AXeox3Gdb13ZPg6jxd
dCVB2PW1SzihDPHC7i8kYTKHlHQKmH9JiYOcb47raWM9Zgw71PXRsK73Ndcb
ZI7a7G7n+KcI1G5GfQfrOYIwfWdk3zaqV+/PMPv3sH4R2z+uT8KYmq+FkEXz
ih1k/x6er8X+IeYw93+D+SH3d8nw4k33r0+fMfzo9/ojl2mfSN2A32L/bLT1
6WO9ttv7mtLN/W1GSFWOQcN6Ps2G9X428n5QPHVfWljP9mzOX837UIAQov0f
qOD8PoRKsl9Fzt9qWPdnGSYV69JJf/0blbP/N3u/Ms7x/Gdte5aP9YoV0Oqh
P/ECz2c571eDhP/Jztuq
      "], CompressedData["
1:eJxlk21Ik1EUx4dRH0oiTPpgb0tKIolRERJinTXCRMKafQgJCdMctqzmtnt1
MqsVpiEh5ZUYFSlTAhGZ0cvSNZu9ULDMihIJCxEbElIRZkV073PPs1v4wLj8
uM89zzm/+9+akuPWsiSDwbCT/8Q6VtDUWsko1FX0OZc+YqDzugWnW6JNiqc7
H+dn+RjkLHzbfqKVwlqxX4t8hcJIbKbwcA2ynwLftiyiDB5+X3/w4jUKLZYL
9nI3g2OTv25+aaPw7Mau21UuBrbmz7U7OinkJSdl1jsZ3F11bmpfF/bD+Q2N
Z2wKKn6ZPjrrDSneUL9sJBalYD40MdSmvx/D/nn93I81qd2vJFscDAL+QWPP
EQp8qpR55cj757I+T1Fp9ljBVsnjJxlsF/OtxH7tOE8yBbFYK9DXbwK3nrrD
q20MikP8zSmSqN8h6r9TrPU7qPiDOB8kMCTmtKHPdiJ9HcX6l4n0WcnAIJ5G
AlvE48B6Zwl84v0Mu9Gnl0BqNzfhwXoeIv2dUezlfKlRsTZPr+I/r2m84w4D
Y4/D1lxNpO8Qg8Ubg1enXUT67WPwJD+rwewgYBUf7mfAx/JF7ETm5wH6K5Pn
0yMMvg7vKVlSTGReBhg0iI29BA5s4wY57xb3l0PkffzDel417p/Lms/z/7Ov
DvuPYn/VON8L7J9gHkcJZAvRPE+m9zzpcdyvQr8/FWv159MER0XeU6jmK8OJ
+TBSeM7v75sLv2ei0LWiqPQ+wTwABRGTTI/Kn1bvlGLtfK/iH4XjgeX3dF8U
eDoDfu6fhK+nmfLw/xXG/swUxJIbwbxsxvoDOE8aTfjVWff5FzB47cQ=
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQbXBXha0xt9Lh1ELXbcXfpzmg8OsQ/NUyUSm7K6Y5
tL4O3CGXX+lwGij/uWSaw0Wl2z/riiod6rP2lAgXT3PQbhe7ea600mENUL11
4TSHapF17g+rKh1e/F758VL+NAerLSfK9jVC+XnTHGbkCTUf6Kh0SHh6Qel2
7jQH4eYDpxZOrXS4ee57cDKQfwFk/gpMPlh/JtR9Xysw+DD1O+SALmZD6Afb
LwjVD+RbgvjilQ7GQLAZ6B5ZoLPvy1Y61AH9Mxno3q1A6flKlQ6iQG/8Kpjm
wAACalD/F01z0AfZp4kIj4yJb2vstSsdHlaJrDtegeDDwhPGfw60P+gigv8j
+PHS2benOewEuVer0iEI5PCHUP9qVDqosjVOdX4yzQHk3PlA+x2BAbbo2TQH
IVB4KUPlX0DdIw+RV3oJ5UtXOvROzxNifgUNDzGoe15B/SOA4C8CeuMvB4IP
dNURBYZKh2nO3TnPX6KFN9C+6aD4e1cB8c8bqH3RiPQEALeCLr4=
      "], CompressedData["
1:eJxlkn1IU1EYxoeFf1RI5QjJyA9MCqkR/SEl1Wsj7BNrUogUhFkbtqzm3HbO
FS1H1AoREU+QSFRoBDJEpY+la1ZGFIVJERVhNaJGxMioDCE6H+/tFB64nPu7
5573PO9znpzKI44DKRaLZQN/xOyPXlhoSzegsXrQmz7CwOQlqSfa7zZrTl65
v7UwyOB5IJG/0mpAnlivR15gwMsnP8v2U+QMA/iyfXaAQUVV0XhppgHt9rNu
p49ByTtqDWcZ8PDixmu1dQwsYuQZsHlOSsEpL4O2jJm705ahHs7uj1NXv67Q
7Gr9Ur++UPOd70v3tIABxfs+jF7ifFj8vwX18/rjpc3nanYotnsYrJ314vLR
OAX+df4MJ/LT6Wz2MzG2vXJun+L4MezvPFV63Qw2iX5CFMSxjmr0i1AYeOCL
ZrkYrBYvTl1/nai/S7PUC5rlfhuF0dzXvxpceF42VX4dwvV5VPlZw4BvC8ZS
KawSw4P1LBQ+8WnMh35OEbCGufMG1pskyr8mzQ2c285olv30a/79LJDovs7g
xuKTn3f+IMrvCIPujnvZvRNE+TvIYG+EO5Mk4BA/DjGwveFJSRCVn9tY773a
nxtjEBIvr4jKyzCDnF6Pq/UxgXJhHOe34v4iRN3HP2zmVfIaOo2ln6f/52Aj
6ud+S30E9WyjSr8f81hOoUgEh+eJqw4VH8T1WsyjT7Os36RZ5r2FSr/yvZiP
TgqP+P19q8Pzeij0LKqouuXHPAxRELYVGDp/st5xzXJ/v+bJsnhX5k3TLwo8
nV0d3P+05X2dyRHMSxTzH6UgZJTEMC9hrD+M/TD611+TTT//AOqa7hU=
      
      "], CompressedData["
1:eJxllGtIlEEUhheLoCgJszASUcuKpD+tIiHWEREtKUkpSiLCDM1slVZCdobE
xEpiCRXHxETSXLO8sYppK2V5iQwspCjpR8kSKRF2IRKly3zfvOtQLSy7D3PO
mffcJiwzP+2kn8ViOSi/xm95/PH3zw9zilhWUj30WJCPrfLTfUtQaNfZnIoU
zSkx0iKe09iNxF67W9Anvjv6WBSn4tyBwjX9gh5933r06iZO5yVXDQhigR1J
U4Gc5tK9zRsGEd/CaXL8R7r3oaC+kLKPB6bZIkdeWjc5/lLzZcN+lNHPF0Uz
LumfkRX7NtXDTD3W+4K2GfadjNqCM7I8HkFfJ/Zlrr7NyFljC1jS/w/3arYF
lA7udeP+Dqb0deK+XqbyaxMkT/tCHiB+q6BgQ8AzRtIq/I1LUFXQ0kP+M4ym
F1q/TDRB30bU6zr8j3D6JfVvFri/kJNRFodTs2l/QXN1wpW8bIeguBWvmgqy
OX1uGU25a4fe/ZwMmY023BfNVd1PgddzlW+2oH7Dfp4tsv92d/2sV/O7VPlv
DJyD+reDcwWd+SATu8no3p6VfndycV6P89PQc02zt7luOLRSs6nHyVT+Pv9y
1DcH88D/Z9O/XNv72IxXwVQ9ijGfDWoeuoswfz2Mnsp43+w4f6L6F5uPfk1h
vvLAC5rN+V7FF9nML5grfxvmbQtX8QvQH6vqr8sOfTvhf06z2S+H5lmpP6YY
+e7A/pQi3wg1D9aLqH8QJ+MnzZf/b0ZTDjlBTvi/Zsq/Ev12Yz4F8qtV/Yus
AztRzwZwidqHsUYwY2R0raZFs5HPifa/2dsDPWXorwf6a7Gfcl+NMLYO1H8E
+yD74XtvTPsZzWa95zQnG4ku57RW7sv8KPYjBO+PjJdknEeCh1GPKPRnSNfb
x7uMfsVpdslx7SKu6jOM/BLQL8lhxvwkKg4fwXuXDPtR/T769P4Be45+Dw==

      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQPT1PqPnAlVqHUwtdtxV/n+YgE5Viff8+gu9t3umY
8LLWIcJyy4myb9McMia+rbH/WOvQC9L4ZZrDZAmWML6ftQ5sjVOduz9Nc1jk
uu3z3z+1Drs8eZi0PyD4N899D05+i+Bb3/fvnf4Kod8YBF4gzAfznyHsXwNy
2BOE+1RBFj6e5gBzP4yvsKEoY+JJBJ8BBA4g9IP5OxDmP146+4jCBoT9x0AW
rkG4D8aHuR/Gh/kPph/mf5j5sPDRahe7eW4/IvzA/jmJCF/08AcAqwS60A==

      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQDQbfah1U2RqnHj4+zQHGP7XQdVtxHYK/WiYqZXfF
NAeFDUUZE7/XOgTtkGt9XTLNYUaeUPOBX7UOvdPzhJiLpzl8uuSbJPCv1sEx
4ekFpcJpDnG7PHmYmOscPiw/5r09f5qD/l0VtkbOOgcVkH150xweL519REGg
zmFJgS3X9Vyofpk6h5vnvgcnA/kZE9/W2Oti8l/8XvnxUibUfTW1GHyYeu12
sZvnehF8qy0nyvbNhKoH8i1B/Pm1DsZAsBnoHtmoFOv7S2sd6rL2lEzOh/pv
Va2D6Dr3h78Kpjkc8zbvdFxX63AaGD6fi6DqN0L5JVDzNtc6PKwSWXe8AsGH
hSeM7wQMn0ULEXxQ+DWvnuZw+KtGTP+mWodpzt05zzdC7dsAde+WaQ5A35vG
wezfBg3P1ZD4yN4B5S+HxKfzTih/ca2D9X3/XvFd0PCZB7UPyI8Fxc90BB/o
21ML+xF8cPC0QeN3FyJ8wXyg+ReUbv+sK4OG1x4o/wkiPQEAmOwb9Q==
      
      "], CompressedData["
1:eJxllHtIk1EYxscSgzKJiuhGpFl0ISQWdIHqNVErDcmFiC0Ks6xwlzbTWXBO
JhFSESE7/SGVaRqhiZe16TTpsrQLiUgXRoSERUlBlkRFCJ1zvvd4oA3Gx49z
ed/neZ/vSyhw5hwym0ymHP4Xz+3vT85peUzg2Y20gMfPoHPx2S+7xwh8+nv7
e84DBtXzYnLj51NYFlvhe9TPYMaa9qvftmre6H9S2mvVXJVy4ONgIYWLVxyz
KvsYlPVeX5DsMXhKmEHyu6TYigpc5/fbRaELFHyp54uL7jHYMu1NvctHYZ3F
YukIMtgsuIZC86L8wu4OBsPZ/OQ1Ctt4mbo7miMDv6wHGzRLPUTzxEvvaKOX
QV/m+qqUWgpN4r4SBvFCTz0Fi6jnZiDaut9IYWecefXU41i/icLYrb7MoBP3
t1FIEnodeH8nhZsuvtPOYDDx7R8Sxn44v/KOLl/7Opo/c9lDRxlI/xOiWe2X
/q387/wmzSbxS8d+eT8NNeElrVnUmJ8T/baifhfqz6NAjvWUVLvR/3wKlPPs
Ewx+DO0qmGlDLsX7bIY/lnLNyl/Fsv96zb+tIw0LmzFPvJ6IRWI7gwyhL9vo
f+Qug32hHXHmDJxnF/q5AfPRjX4v1SzXYzTXpQXGJz4Qo78g+sfzLPW1aFb9
KhaPDC/mu59AngiyysNTYuTVwyCh1X3k8gsCfNyp03keGoW+ISL11ThxPhGj
focD9Q0Tww87+vuVTM5LsolGsZq/1JdFoljtl7xHc7E4f1izzKsH9TtQTzmB
51z/OJ//w58rbJdO4/vtwfVKrFemWfmlWO6v1Sz9a8L+z+D9bcjqfj/2R4jx
vgUYrDo3NzJwioCIw95O9KsM59eFeeX9y/yFMN8OYx6VIfS7SLM8v1+zfH9z
cX4h7Z9kla909KcH2U8mv18qH4r/AUxniFc=
      "], CompressedData["
1:eJxllHtIVEEUxs3CqESiLMPKyowelv4h0cPUk2JLRklKJRoRpmllrqS9IHSG
CIuUCnGEMiRNzRSLNJMKFQ0xwxAVe0iIWJlspquZlgTN3PutF/PCsvvbe+bM
Od/5ZlZFm8Ni7e3s7A7Jj/r2m/uuIGkfp8ycxAUzfwryV3yAU99EiTXstSDb
+yls4vTmXnDVSLugjr3R8yP8OUVsq2z61SXofE2eq7cPpw9vx8KP9Qg6+TIl
a8lqTjuPfml178d6J+w3gPhRNskFSTKizeCiO69WPq5m5KOer4IKFRcxSlWJ
34NzGI2H9xYubUG+m4yaZX3JtQZr8Y8M/ttxob8oX1CvSpDNtHp7haDhNtlQ
HqM1Djw7KANcwihQ1p/PEV/F6L6q86KgqBjf7tBGrE8RVDUiM3cyXQ8z1vfp
/Vw+DR43OH2xXDmDT3L96LrDN+ZBr0RB19QPZ+hpxv5unJ7vdrQvTQKv5aTK
vX4G8d7Q9+x/nGuw3K2uWfavtq3z4lS2LDLGtxh6b8S8S6DvBk4ye0JcqSDv
Tx4OXO63qNzU86cMesr5pkl9F5ZjfrI+bV5S78Hixj1bXLimZ4PkSKWX43TW
+q8Q5LTpyd3BlOlsi9fYbPCO7tDMnFiDW927fqce4RTiaO85uxz1R3J9/g8F
2akngut+eYD3B/X1QQUG2/SysWqnQurbrvxuQr5E9LcV+p9CP+u57pcT8IOr
ru+LOMx7DicPVe9xzGOMTXJl07mavAaDtXpz4W8z+meMvsn5tKWh/wRGyi5R
GThf0fDnbYO1/koN1vz1DP6JZyTt5JleD/8l4/y0wK+c6fP/iPqysN9n9FvK
dL9YkK8W9Voxj0429X6xGhx/a+BSwITBmp9mcfJVfY2AHaHXMOKdcd9YMZ8V
XJ/DEPrzgn/k/aHpsFnP5/Jd0FXV+HacJwvq9zN4ufojwGCt/0DsZ8G8gnA+
Zf6nSo9g/TyF/BDkdsWyv3oX6h/CepNxv/4DrT2XEA==
      "], CompressedData["
1:eJxTTMoPSmViYGCwA2IQ3emY8PRCf5PDi98rP17KnOawdPYRhQ3uCH75vvlS
+m8aHU4vdN32ecU0Bzuu64sLnjZC5IF8Pt1Nc9/fb3RQYWucengFVP9tBB8s
fxPB/3TJN0ngRqPDwyqRdcdh/GsI88D8K40OQFcp3QbyGUDgUqPDNOfunOcw
884j3APjq4LMb0TlO1dOcwD772KjQ4TllhPfiqc5HP6qEdN/tdHh5rnvwY8L
pzkcAvFvQeXzpjlk7SmZLPGo0aF3ep5Qcy7C/zB+B8i8b5h8WHiB3d+MyUcx
rxfBt7nv3zt9BoI/A0gdWADxf3T+NIdloPBc2uhQD3SYMND9wFD5Wbei0eHf
lYqXaqVQ/65sdAB5l7sKwUcJj5UQ85lvovKbH0LdtwIaH8+mOUSlWN/3XwJ1
/4tpDo9BETq/0WGNTFTK7tfTHGxB8T+90cEYBN4i/APjw/yLzgeH9wdE+oHx
weHN1ATnv19+zNtcvMlhSQHQpvfQ+FNpgvgHaN62z3+vVBg1Oez25GFa/Rpq
vh00vT6Hxicw/YLtfwSVD2xyqANZdAdqXijUvqsIPohSOofgg+0/Os3B2xwo
EgCRX7QPmn5cmyDht2Oag1zr68AdVhDzkjdNc2gXA7I0myDxtQ4ansJQ+1dD
3eMNdW8L1L7wJkj6rp7mADL2QFKTg+g694e/YPGb3QSPf3B4lTZB4r8Aal5j
kwNIm1ce1Lz+Jnh6AgCZtvUn
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQzae7ae77840OqmyNU53XT3Ow5bq+uOASgm9z3793
+pVGhzUyUSnWMPlrjQ7GIADkX/ZNEoi40ejw70rFSzUgXxao7P7NRgfHhKcX
lID8T5eACm4j+J0gxhcE//3yY97mHE0OQTvkWl9vnOYA0u4v2uTQOz1PqHn7
NAcfc6AOpSYHoGiv+N5pDmD3ajRB7D+C4L/4vfLjpTMI/sMqkXXuV6c5bDlR
tm++chPEvjtQ90g2Odw89z04+eE0h0NfNWL6+ZocdnnyMK1+BvUvQ5PDc6B5
QS+nOZTvmy+l/74Rzte/q8LW+BzBz9pTMlniLiQ8Nr+A2g8Mz1MLXbcVP5/m
AAA1XawZ
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQfURhQ1EGQ7PDi98rP17aOc1Bd9Pc98u/NjncPPc9
+PG1aQ4Pq0TWuX9scji90HXb50fTHCpfqhlyAPlA2aWzn0xzmObcnfP8QxNE
3TMEH6z+OYL/A6he+s00B7nW14E7PjU5/LtS8VLt/TQHsP3fmhzqs/aUCH+c
5hDbf+irxq8mBy8eJm32z9McPl3yTRL43+TQOz1PiPnLNIcYkDxrM5w/FWQ+
F4KvA3I/fzNcP9h84Wa4+e+XH/M2F2+G2w82T7LZoQ4oP/kNgv8cGB5BLxF8
E2Nj482PpzksKbDlug7Ub33fv3f6XWj4iELtvw4NHy5EeAIAc2a0ug==
      
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQ7cnDpN2+vcnhxe+VHy/tnOYA5q9pcngO5Addn+Zg
c9+/d/rKJoepzt056fenOcT0H/qqsaLJYRqQ//wJgg/W/xzBr8/aUyL8ZhpE
HVD/vysVL9XeT3M4qrChKGMtVP4jVH5Dk4MX0F72z9McdDfNfb98a5ND7/Q8
IeYv0xx0QPzdCP72z3+vVBxE8KNTrO/7H0PojwXZfwph/qdLvkkC55ocfgQ/
XioNtL/ypZohx4UmB5F17g+r3iD4xiDwEsH/DlQ/+9k0h0dVQJXnoPwH0xwE
Iiy3nDgFVX8dqv4AIvwAkmqrFA==
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}}, {{1, 4, 3}, {1,
       3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 
      1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAmIQffPc9+DHT5Md6rP2lAhPn+ogG5Vifd85Cc5/V2Nv
Gvcr0UGVrXHq4capDqs+XvJNepHo0Ds9T6i5ZqrDhENfNWLuJzrUAdVPrkDw
Ty903fa5FMGf5tyd87x4qoNjwtMLSs8THazv+/eKF011qBJZ5/7wG9S8gqkO
F5Ru/6xjS3KIsNxy4lse1D4NKD93qsNqED8mCaIeif/i98qPlzKh6jkSMfgw
9T7mnY4JplA+0PyLIPuCEh3yhZoPnMqH+j8+0QEULsmFUx2qQe6rgrh3eslU
h33zpfTvzkiEhE/1VLC6xzuh9rVA+abJYPOZv0D5gWj8kykOTsBwWNQ81eHx
0tlHFF6kQMyvmuoQyqe7aS5zqsP75ce8t5dA/SeTCtEPDK9FwGD9a5LqsKTA
lisc6N6ijIlva8Ih/Ou5UPc3p8L9C+PDwsMb5P+byRh8mHpweLGkQOI7Fyqv
mOLw90rFy2Ww+DBIcTAGAWB8hYPca5/isEYmKmU3MLz6QfHtDvVPMYIPNq8U
wd/lycO0GpheCoHOXmyT4gC0/YBXLVReHRE+ALxjReE=
      "], {{158.496, 
      1383.6129999999998`}, {152.762, 1397.253}, {146.88700000000003`, 
      1383.6129999999998`}}, CompressedData["
1:eJxTTMoPSmViYGCQBGIQ3X/oq0ZMepqDY8LTC0q1Ux1Wfbzkm9SA4PuYdzom
TE1zYGuc6sxdM9XhbY29adyyNIeb574HP66c6gDWvz3NQRWo4HD5VAfZqBTr
+/vTHP5dqXipVorg12ftKREuQvC9eJi02fOnQuwB6g/aIdeanTMVYu5SiHnO
WVMdeqfnCTVPSXP4ARSVzpjqEM6nu2lufRpYnDkdan86gh+3y5OHyR/BVzfk
WCNjhdC/b76U/l0NhPlFGRPf1ogj7K8WWef+kA/hPhgf5n4Y3xgEShH6X/xe
+fFSOcL80wtdt32uRNgP1l+DcB8sfNHDHwBLYawu
      "], CompressedData["
1:eJxllHtIVEEUxsWgxKQ/1IhMpOxlSJREmIl17EGkRaSoUWZmD7v3jq6lvewh
tmREikVNW2qImpruopA9pCLFotKyhwlqYiH2UDbNzTI1hGbunHVIF5bd3+7c
M9/5vjMzJ84Qts/RwcEhir35Z1dx7tPZ1QSyTImuk35R0LmZwLe/ZbaweuTq
cZxH4GXB+nsD7ykE3Hlx5PFRAtvYl8F2Cmtiv7z1DiXQ9vpP+J5OCtcSXY21
zgSC+e899nqa2K8X14dLHvSJzq6rV8f4rHVrtdduFZbx11fkmSqcVh+lXG5F
7lBgKLyreFYjFfvUKNDA9CXXSNbXV0oebT7WU1JI4YR7xYbOJkXX23WVwl3W
Tv6IAvMnp9O1mcjeqq6zMJ1CKl8fqcLNpCDnluMUIqctvn3DpIrnUyg8D/U/
H9yqCj8M+LyH6M+YgBwj2bmlKCkoQ/JBVrbIogmdiRTcjLUNBe804acB9x/U
4MFGF0dzEur3IMDlXjiE64Mwz8PjOE8yj6WB9c/lxgYQsHhu3xtYin76Yd5l
yIsIsOok3kzBbGvaHOdJYDrbdsSC+U0lkMb8davA/IY1kRfzewEX1q7pfj5h
HMX9qpzIev9VFBb6OVk8wxImsH29zqsktw+zZN0ll3N9QwRCXBx9p1Sg/h4i
8i+n0Hty9fKYj0TMyy38v42IvIsk2/2yM2+nivm7ks97LtZj+ejP7UL/NQoR
vJ+5RMyLgvPQren+PozHvEs0mMf17sc8dkquyfdY0pGpjrGutw/n24D9n1Gg
m+XTlIb9L1WAx7AjE8+XkyLmM0eyrtMsWZ+v+zg/XgqwcfI9V4fztwnPTyPO
K9tPz/8D6nuF+33G+fdVxbxYsV6qKvTaMI9W9f/7ZZ02xhfrfvtEa5J1Xdka
BH7akmUaQK5Ef37i+jeaOF82zGdUgx+lz0L9+7H+CpGf0X6fRBC93ozv6LeC
95MV80qWrJ/jU5J53PkZeL9Z8fksvM960Y8r4jyF9FE4cIkldl3sZ+pH/3Lk
/foPLD+d9Q==
      "], CompressedData["
1:eJxVlAlIlEEUx8UwQ+3ALiizuySLqC3KRHxmImoRKWmZhKilqd83a9laKR2I
iIhZyGggYSamooaZeaSt95GShUGySYgtYREhYplZUHM8HVpY9vvtzPfmvf/7
v9kYRYLP2drY2JxmX/7rE/npzSZvAgPFfvVTJgrW0sKuDd91qHIJj2kmFDK+
nmh07dbhenxLcl4Che17FlW51OrQz/Zfiqdw9ECWTyTVQXdOb+uPo3BtxWP/
MZMu48VSqOszmYtCFa8Lj/Ec3azYcbjE6DWrgefo8ZzVLN5yFqbYooFl8GdI
tE7BXLRm94dGDSbKeoIaLlIwejkMl5RrQH2zE2OvKBb53FCcz9bH0ykkca7R
YOvCW7QzE7lNg5wC3XlBNub3TnJ6LoXKyaFjUX80WX8e1rtXh30Gg+FpAeoT
h1xIYdotIrejXQcW3jf7AYU5Pfl5vo8U83qsFYpPedT1TddSOLlkV+19AwED
/zRhfi5E6t1CgctabEdgJZN1thX1s+L57RRC+fsNih24nvmKD/ECU7F/bSr/
8d8Vk8FmCh58PUSHQCdbd/sW1D9Ah+BG14yEJsVCn3oKh3n+QTps4XrWKG4O
cLKtrKbQyvt1RPohsBL7cVAX+x6y+nuDmGF2yngLyrGetbqsvwzrsVcs1qe0
eRb5WjWht2M56jmM/WXx7wkjYj/nzu/SgG8bqVb8mdU/VKOYpe+eWY/njWjw
kRm5t5nCM+4PB6Wf0MNDF/HOdFPYxhNh+orzeymE8fxfKxb1LiPzLObFj0j/
9mD+hMh+dVL4lua9/+xtAjMhrFPtuL9U+ifajP2rI1K/5+i/F0TGacB8OwiM
8UF8oljMR7lioU+WYiHbTay/U/rTlIrz0YP7r1KIu8syfEmk31NQj1dEzIun
Cf38Fv17mUrfW4icx2S8T8ZwfY6/KOZyRU4qfv+LPc1gfsmo11+cLxY/hV8Q
dkb5Pzt/MTt+YqlRvs/uhx2ZqyyD65HTFP9339ka5XwlUrjT8cMtYgD1jcP8
qGLh91TFol/nUf8LmF8Y9isB/epP5HxoOI9s/oXfktR9MJfPP1tSlro=
      
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7Zjw9IKSfb7DqYWu24prpzrA+MYgsADKf5/nsEYm
KsV6zlQHNbbGqc678xyCdsi1Zs+c6hDKp7tp7uI8B1Wg+OHpUx2Emw+cWliZ
57CkwJbr+pSpDmEg+eg8h0dVIuuOT4TKe+Y51GXtKZncB5U3z3OY6tydk949
1WHribJ98/Ug5r9uR/DB7mhB8EHmh9dPdbh57nvwY8s8B5B0dPVUh0KgtYsD
8iDur4Can57nUA+0T7gUqr4xz6F3ep5Qc/FUh3CQ/HwE/7i3eafjCQTfB8hN
+Jvn8OL3yo+XyhDhAwsvAJTYkr0=
      "], CompressedData["
1:eJxlk31Ik1EUxoeJQUVEmgVmmZRJBkFKUlIeExl9SlMssmJsiyxSz6smJTGR
iIiQELka9EdslGDFyDanvgwdZloGYhKCSJhYmUR/9EVfGN2Ps27pCy/jxzk7
9znPc991jnLbySiLxbKbv+K3uWz5pXALwoaYOvZogMG/nOtnUNLw4WL2YwRb
55rL78MMer+mHrv+ek5/tPGX92VezbHHat7ycn1M3VoDcuxvhr39DLx5wc+z
qQaMDX0rcPYxaH9S3X1rqwHmniVRab3Un2nA94KpOzd7NKfzxx/6v55gMrCI
J8NQ+jpo/mZ1XnKQAZ/Sl5RiwG3cuehwgEHiUVfWRKIBg568YCXfr18IjtPc
uCq6aOlizQGhz2JA1kR+fXOA5n9BqX8qSHpmUOnvovorhOlfrR9tJtXHNct5
o5qlX88Rfr84P9PC/79dNDyjeieD1UJvDyo/2hkkPagoafCj2q9N5yX13NUs
67Wahf6VNZRnK8JkTZzPWk37+xAyhL+VDHaI89sQmnKvnZ02GGy6Ej821IHA
OJ9CBsPJ4z/cYZR5pJczEPLynyKs8Fknf5ZSHqNKj7OU+t/O53d8v5HTtG/a
fI70S327NMv5+5UfCWXkdyGC+0yoqpHr4dsOeooRZoWfXK+4FofsCMKO4goG
J0RQTqXfX0V1F51/juZx3svjXHhBs8zDrVn65ZlTv8/g08gBxzKX8t/7kMGA
0O8gDtD3Y1f35V6Q8j+u8k/hed8QeR1BqOX7xHbR/oWkxyT/DiLUi2Aj98uq
WeaRrVnq2aZ4gan9lRy5bxvJvxD526S/7z87Lvof
      "], CompressedData["
1:eJxVk11IVFEQx1eDhD58sCCICnchI0oKKvoQc8QiNKKyiKhI+1S21D0HWTez
LblIhQlFDD5ssWht4Zq2ZkqmXFbMNgpEJIroQUwiK8Kih4hImnPPsIcuLHd/
d+bO+c9/5rqPVxWfSnW5XLn0U/cMK/6yxZLQ1FyZYV1D2PL4hd8+J+HgZvpz
CWHU8/538LSEdeqqQVh66GTOeKHmbh9CjR1evCZbwoMlFPAibJ3z9o5vvq43
qwyhh8qFv4gkN3zd+2TZoOGKT3/aftwSUPpx1HP4DMJkJPQsMyjgonegekE1
Qq6qVyJgonZhZ6KO43sEFM5LXXX5imFVprjZ8HqlL8LnHeP6XcwW5z9FKL/x
rS4vouvvGEJ4vnPj1fwRActn1+NQguvNGE7PfnR72i2T7OjLk/Bu5Ne+E8MI
yr7wAQn5dGBrnP2s0PHJfgRVvpT8fdWyvfdnr+Ep0jPWZdjR9xDBpS6/1Po6
OF4ldX/tCOfp8US5hJnXgc9ZUQQ1NruE9bSx/v2Gx3eT89sMO3o3sd4o81rN
ng5+f7UEaregsZP9Wylh+j45RXqd/VnB+T3sX5bOn9vH882UUETzShvg/EVS
z9fm/HTmOPeXwjzI/X0XSaZpbTj6xnAr2fg3LoDcjYRszo/x/Pu4Xkjo/e3m
/q4LyFFGRA078wkbdvYTeT/ofer+bFkjx2N8vsX7MCygnfa/v5bP/yAgSPGb
fj4/Tf7PbsP3yN4Y+V+pjAlwfJfer4ILPP8jOl5E32NCJXgl3PXR5jXwfAK8
X00I/wDfR8xt
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvUOu9XWgWbGDKlvj1MPHpzrA+KcWum4rrkPwV8tE
peyumOrAq7tp7nvzYocgkETJVIeoFOv7/tbFDr3T84SYi6c6dDgmPL1gV+wA
opQKpzpotYvdPOdc7PBh+THv7flTHXaCzPMqdlAB2Zc31SH3+e+VHwOKHZYU
2HJdz53qUC2yzv1hTLHDzXPfg5OB/E+XfJME8jD5L4DaLmVOdegEWbSnCIMP
U7/lRNm++ecQ/MNfNWL6b0HVA/mHQPwHRQ7GQLAZ6J6ls48obHhW5FCXtadk
MtC9ChuKMia+LnIQBTrrV8FUh8kSLGF874scTgPD53PRVIdlIPWfoPwSqHlf
ihweVomsO16B4MPCE8Z3Ajpz0UIEHxR+zaunOnibA33wuchhmnN3zvONUPs+
Qt27ZapD+b75Uvow+7dB4+dNETg+sndA+S+KwPHpvBPKf1LkAIylXvFd0Pi5
B7VvFzR+riP4QGXT8y4g+MBYWVxwHMJn3oUIXzB/JzT+t0PDaw+Ur4pITwD9
5DGr
      "], {{310.02, 1405.066}, {302.676, 1396.472}, {301.832, 
      1396.472}, {304.441, 1405.066}}, CompressedData["
1:eJxFlGtIVEEUxxcLK5IIS+tDiYlRZFGwRZSEp0QkpSSFSCsR3XBzfZAzbZZi
mYSJiJhMBhKmYWq6tpmsq2urtvnIyBa/iYhsJgqyPdFeRM3MPetcWJbfnbnn
/M//nJkd6XmJl/x0Ol0y/4n/B7mBpQNZFN42xNi+mxkYq71FUTEU2relGBx5
DI52jZqd+ygUZ/XRGhOD4fjD5cfDKYzx/SSLwfYUQ+RMEAURZszIQGyv98d4
mQzcYVO/ipfJCt9ZPGMPmVZsD+FvRglEziRUbuHxdOKxE5gc/5GUkctAhG1o
JvC5eTi+O5/B/ulw/5J6Aiy6IjuzQLHUc1Pxfb4+X4r8mMBO/xLmKkNuI1BZ
mxu4qgL12TQurWIgykt7Q7T6a7DejwQO6vX6F7Xozz/kOgbfJk6lb9xLgYeP
rnjEwOenyBf9RLGoZ7ZV8bkjXaPLnQwauQ1/DRT04ulBfcnodx/6cZpCUEes
53c/+neMavkHGVzsPRngt0ux9DNYcc3W1Wc3rMN4A0r//J/Wr4lOXF8iEBfg
F7HGl+8LgUQeyNSjWPpjQ/2cw4WfVsUOLqPNwmCT6JeXyHmIa8N65gmcSJtz
N/L6xbgkeND/Fqxnkmj1N2M97xXL9SHFUu9LIv1ez78XsgZs2F8e/9XS7gtV
VtTL8x8Q+S0EePqwKYviBV7/hFUxzxpRZsN8PQQ+3NjcMeLA+XCTFf+kHwta
vPNDDPi0zLnXav12jTBIFfr1imW9SYrlecmh2vwOo3+3sV8uBp+Kog6l3qPw
M2m2qW4Q9z/U5ifDif1ropp/vTh/TykIGWHdqLedgofrj32uWJ6PFsXSn3LF
8vzewvot2nyaC3G9A/dfZ7CnLHhy/BnO+zX0o1O7LyLNOM9dOG9XGfAqXofa
qXYeKQMR1unAdR/3K5b1uhSHWvON1SOoj6JfY3i+eHyv8MuN9ZtR/xR+X4D9
WEQuUuy772R/3uH5ymZQyG3zWNFfI95/TLHMf1exzF+M+S/jPJqxXyac1zyq
nY8cZBPV5u2Kug98ev4DNFSFLw==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQPSNPqPlAVonDqYWu24prpzrA+MYgsADKdypxWCMT
lWI9Z6pDp2PC0wsaJQ5BO+Ras2dOdVjkuu3zX5kSB1W2xqmHp091YAABjhKH
JQW2XNenQOV/FDs8qhJZd3wiVP5DsUNd1p6SyX1THWJ3efIwPS92mOrcnZPe
PdXhotLtn3WPisHmv25H8EHWKrUg+CDzw+unOjxeOvuIwotiB5B0dPVUB/27
KmyNn4sh7q+Amv+/2KEeaJ9wKVQ9T4lD73Sgx4qnOsSB5KURfKAv7/vrI/iy
IAHPEocXv1d+vFSGCB9YeAEAGuiQtQ==
      "], {{336.91799999999995`, 
      1383.7839999999999`}, {349.79299999999995`, 1383.7839999999999`}, {
      349.79299999999995`, 1380.019}, {336.91799999999995`, 
      1380.019}}, CompressedData["
1:eJxTTMoPSmViYGAwAmIQfeirRkz/sjKH+qw9JcIrpzrA+KpsjVMPN6LynSun
OuyUa30duKrMIcJyy4lvxVMdtNvFbp7bWOZw89z34MeFUx34dDfNfb8bKp83
1aF833wp/dNlDr3T84Sac6c6KGwoyph4H8HfATLvCyb/xe+VHy9lTnXodEx4
eoEHkw9TP1mCJYxPEcH/dMk3ScACwb/vD2R5lDkAdSlF50PdHwT1L9D9tlzX
FxeElzn8u1LxUq0Uqj+qzAHkXe4qBB8WHjA+yHzmm6j85odQ+8LKHB5Wiaw7
/myqQ1SK9X1/f6j7X0x1yH0OZLiUOayRiUrZ/XqqgyIoPEzLHIxB4C3CPzA+
zL/ofHB4f4DyLyH4QN/tkGMuh/PB4a9Z7uAEVLboPdR813IHkDYlmH2J5Q67
PHmYVr+a6rDlRNm++RXlDiLr3B9WAd2vBYrf7nKHOmB4TX4w1SEH5P555Q5/
geG17BY0fayAmn8ZwQeHx2k0/gFo+phZDg7f7u1Q99dA3LNoA9S++HKHD8uP
eW8Hpsels48obDArh6S/ZdD0w4jgg83/Ugbng8P/WRnE/cug4X+9zOH0Qtdt
n4H8xyADT5Q5nALyi5dPdZABKdgOjf8ViPQOyw8AOWiFIw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQfeirRkz/sjIHFbbGqYfXTXVYOvuIwoYtZQ7W9/17
xYH88n3zpfQPQvjT1051+HTJN0ngTJmDKlC9M5A/WYIljO96mUPQDrnW12um
OrytsTeNewA1bw1U/QsE3/1hlcg65nI4X2FDUcZE6XKw/uz1UL4+VH4LlO9c
7uCY8PSC0q6pDoogvm+5Q33WnhLhgwh+HZA/+SSCP9W5Oyf9/FSHZSD/eJQ7
vPi98uOlK1D32kP5N6HqTcsdQMbfvgd1r0a5w/fgx0tnP5rqAA4fMah9T6H6
WaH2PZ/q0Po6cIfcxzKIeS+mOnSCHHoLwY9KAYbcWQRfFiSwu8zBGAReQM0H
hv/pha7bPj+b6gAAEe7ESw==
      "], CompressedData["
1:eJxFlHlI1FEQxzeVTrXwqIg0lZLKQmqVEImmLCpFIoUojQg1PNYrU39vVSqR
MJOQkpeBlGmkK6ZtGh6tbNqWhpGEEGL9YWqhnaamHRr0jlnewrJ89v1+M9/5
zszzjcuIOuOg0+lOsC//9TFnJV17QOBl9YHWmVwK0wORcauuELi/PibBkkHB
Nrv5ZFkWgfMpndnlBgrla52OuSYT6GPPn0uhUFv5zMccQyDdrairL4nC7uWD
dzMjMF4ihZiE0OEjoYpdtzffmvRVfOnL0XZvFwLsqatrWLySvac/vl7QYKj/
V3R8OgX2d0X6Vw0m63oi2rIotHuzNz5oQMNKUxOJYqHnguIb7Hy8CHlCg02L
C6mtGPmHBiyqm2Mp6puXXFRG4Q355L/DFesvx3q3EAjS6/UtFejPfuRKCvke
TQdHMgmw8GGldyjY/eT5wmoV83rG6hUfD3n0Yq6ZQkDx6qH+egJ6/ulAfbfR
70704zoBT5bm7xP0rxDzd1PYyt83KBZ+xir24gVGYrwupX98vn4qyornIQTC
nR0CltjzBRGIYkIMHYqFP60UfLn+YAIbuZ9mxZbDzg4NjRTe837tlPMQ3oD1
bCOwj4WpYfWP3WMD4y/jOZqwHi+svw7rcVcszpcpFnoXSb9XmNDPeewvix+x
iymexX6y/B08/7QGLL3fu0bFE6z+AbNiJj+guBXz/dNgNM+jqdeC8+Gp/BN+
sHp4vNjnFNzZ2FdHyn7belG/pljUe1Ox2JdmIue3B/X3Yr9sFDRr1brAQQK/
o9mb3fj8qJyfeCv27zP695hCHp+/7wS4LL821DtFYIQfPFQs9sOkWPhToljs
70Wsf0rOZ24+ns/g80YK7F9r1U+cd43CZZ54Tu5LaC7O8x/0K4dCGh+0BSL3
MZvCU36f6Izy3M5OikW9SxV/K9gTfMrZKPVlo18rjXK/ctAvT6Osn+V34fo3
4PsE+xGIXKDYft+J/rgZ5X6lUjjEjZtFf5Pw/nurWMz7K8Uivw39T0Z9FuyX
Aee1BfcjjQK3aZjtv5i3s+o+sOv5D9rgmGI=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQrbChKGPi+gqHUwtdtxXXTnWA8Y1BYAGU317hsEYm
KsV6zlQH4eYDpxbmVjgE7ZBrzZ451UG7XezmucQKB1W2xqmHp0916HRMeHrB
p8JhSYEt1/UpUHnbCodHVSLrjk+EyptUONRl7SmZ3DfVQQskr13hMNW5Oye9
e6oD0Jb7/uoQ81+3I/ggbUotCD7I/PD6qQ65z3+v/KhT4QCSjq6e6gDSFmgB
dX8F1HznCod6oH3CpVD1ARUOvdPzhJqLofLxCP7jpbOPKJQg+CDuhr4KhxdA
bZfKEOEDCy8AL8GUVw==
      "], CompressedData["
1:eJxlk21Ik1EUx4eJQURI2QuswswiivCDkdWKjpqNihpNSCgR0UXrZbq2Jd1L
TCQiIiREbgZ9iI0SekGqzSc3hvmGEz/YkPowJGRIWkjQe1kY3ZezbukDD+PH
OTv3f/7/+6yrqbefzDCZTCX8Fb9tdUsv9xgENmQ1sf44g3+5NMTA2fL+0t5X
BOxda69M9zDo+7qp8saXOf059C8fKrpWXL1ec8Hr/KymAgrF1W8SwUEGwTLj
8+wOCsmR7+W1Aww6hxq675RQiB5YnLGlD/utFH6UT9y7/VxzIX9Csf/r5igD
k3j2UaXvGc7frc7LMxjwKQO52yncde9ZVBFmsOa4wzK+lcJwoMzw8v0GheB8
za2rMo8tMWsOC33ZFCzjtua2MM7PVPonDNQzQ5T+CNY/EJj6df+jPYr1ac1y
3qRm6VeKwO+XF9+18//vFA1jWO9isFrofUGUH50Mch97nC39RO33ROcl9TzQ
LOuNmoX+lRTzjBBI0ZwOawPu301gm/DXy2CXOL+XwM3S6+emzjPYfHVFciRO
gHE+5WaQyBub8SeIzKOwnoGQZ0sSWN5hTf10YR6TSk+tC/u/zee3fL/R07iv
ZT6n+6W+I5rl/Erlh7kO/XYQ8J+J+Vq5Hr7tcOAsgVnhJ9crrsVRNwFhxwkP
gyoRlFfpD/mw7sPzL+A8zgd5nAuJZpmHX7P0KzCn/ojBp9HDNdk+5X/wKYO4
0O9BDuP341b35aGB+btU/ht53rdEXk4CjXyfZRHc34F6ouhfFYFmEWz6flVo
lnnYNEs9+xUviGp/JafvWxH6F0N/2/X3/Qev0v+S
      "], CompressedData["
1:eJxllF1Ik2EUx8eCFRZdaB+QJSW1mwoJlQgRzxJZGhXNQirSkUUZTVfqsvOU
Y60FEV5EPHkhIVsZ9EGUm3OOYVKisouKSsKLkDXKTCzCC6VY9Dzve9aTORjb
b+f5+J///7zbcKzBdsJoMBh2irf8nL5YUlg9grDJ5OEvhjn8y6VBDrjisTXx
GcEWyfFNDXAYbZk0bzOx+evNigNl4ZlUgWLf1P5IjoWBxf7pdWCIQ8+Iq7+z
gsHYy9nK2kEOQ7u3X7McYBAtX2bc/JzWH2IwV5ns6nimOF+8grH59ewohyzv
QNx/kOn6ejmE5Pl79ftywxx2yB+sDO46izOqQhzyPmw0eUoYxP1l4UbR37rD
x4vGCxV3dQyuf7JF8bDUl8ugaHxfW3uIzl+l60+GSc9S0t9H/RkZTPy6/8MW
pXoK/7LW75ziarlxBuH3u5bJe2K/LNunqR4hvQnU/ejhcL6/c03eKOr9PVV5
aXoeKNbqbsVS/2rkwGSecYSEDNbFYa3s/xVCgfS3ke5/i3Cr9PqZibMcijPe
33GOIXDBJ50cktKgj6jlkd/AwSGFfkVYKY796eCQKfOY1fXUOmj9EraAv4ht
b+rovj24gNPrNX01irW8Hbof2fWUhwuh9XSs6abQc+qG6PgSQkr6KfQu39p9
+7sHQdpx5Bytv6LrDzZR3Uf3N1P9KkKFiHPxBcVaHq2KNb/8/9UfcdgljfXp
/ge6ab68xCF6fi6jNi8PxfwclV/cev5mkfc3mRciuEU/WX20v5n0RMk/J0Jb
e32mNz1fdYq1POyKrVJPlc6LospfjdPzVk7+xSi/XvV/8AeFCgby
      "], CompressedData["
1:eJxFlHtIVEEUxhcLgxIR6SERoWISWEhsUCHWUQlTCVEpKkNCEzefadu6OZMP
NrFlKzOZlDbJFF/4YDPRdGXTLDUDESFCNMwkTCKkoiz7o2bunHUuXC6/O/ee
851vzpmA1LzEdA+dTneW3+Lpvb+7biWcwpvHx3t/mBjMx9+uyfWj0LHr3EVn
HoOcpb9t33QUijMHjdVZDMI3v2u8vEpggn9/JZNBtd/G097LBHJ9LUMTBgYh
FdtnJmeIjJfB4MRC0dau14qf7S7/kuBQHPo+yLPMTiCMJ97B4xW6Hu0MtRGY
mVxNSstlYI248GmqiMBKy2hcXwGDZvtLf0cBARZly84wK9b0lCi+z9eXLAya
BJsI7PEsYyMVyMUEeJW+G2yozyrZUsngxc+95ysfEll/NdbbR+CgXq9/WsPg
g/BnGtnOwFD1lR77R4CHj7LVM3D7KfJFNSsW9Sy2KT5zpGf8VzeDt+bl4AOH
KejF1Y/69qHfg+hHAIVtXdELa8/RPx8q8w/j/2tknTU/lxWPxh2yRswRGW9I
6RfbmujC9XECsV4eIZvc+UYIJPJEWf2KNX96UT/nIOGnQ7EzxsujvRP3a0j2
Q2w77scAgUj+uoHXPxU4+6e4B/1vxXo6iKy/BetpUKyt1yrW9N6Vfm9pxfxW
3F8en9tqcllQrzt/KQGePnC2U/FnXv+0QzGXH1LRi/luEfjI22LMySBa9Eej
8k/zwynjJb9ioBPXHOYfQ/2edJ21eoMVa/MSQWX/jqL+U7ifIwwCHAWGqnQK
v5MWm+zD+H2+7J80F86nmUr/BrD/rlMQtgf2od4SCuIR/USxNh+tijV/rIq1
+S3F+ktlf5oIzkcZfn+NQcoAd8pCZb8Xoh/l8rwIM2H9N7F/rzLgb+fjbVTO
o5FBtmi8O7huxPPlnmKt3hrFtULYA9RnRL/qcL54fH/hVyPWb0L9Xfi/GfW4
kKli93mn7U89zlc2g+/TJ1N9bqC/BtRnUKzlT1as5U/A/JdwPQb3i5+XY6Jf
I6mcjxzs36NU9lu+Og/cev4DWESaRg==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQzae7ae572xqHUwtdtxXXTnWA8Y1BYAGUL1rjsEYm
KsV6zlQHBhD4U+0QtEOuNXvmVIerFS/VDD9UO6iyNU49PH2qQ/m++VL6t6sd
lhTYcl2fApU/U+3wqEpk3fGJUPnD1Q51WXtKJvdB5XdVO0x17s5J757q4PEQ
qHArxPzX7Qi+Y8LTC0otCD7I/PD6qQ5AV933313tAJKOrp7qsHT2EYUNx6oh
7q+Amn+p2qEeaJ9wKVT9/WqH3ul5Qs3FUPl3CP5Fpds/65hq4PzJEixhfLI1
Di9+r/x4qQwRPrDwAgC07ZL4
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQfbXipZrhnVqH+qw9JcIlUx12yrW+DjxV63Bqoeu2
4vypDrnPf6/8uKPW4Ufw46XSOVMdeHU3zX2/HKo+a6pDDkh+Wq0DW+NUZ+6M
qQ6HvmrE9LfUOvROzxNiTofqL0DwJ0uwhPF5IvjHvM07HdVqHXZ58jBpZ091
uO8PlOGAyDcXT3WYAaQOvKpxWFJgy3W9eqoDH8j+2zVg+7rbEHynhKcXFk1G
8N8vP+a9fQHUvDc1DsZAsHnNVAc7ruuLC3hrHeqA7p+8HSqvB/XvIah9EbUO
N899D358HCrfg+CD/bcGwS/fN19K/3itA8ibQUenOsDCE2Sf8QEEH+zfiwh+
0A651uzbUP23ax1eAPVfegjl34TqfwLlX691ANq2dPazqQ4MIHCl1kEVFAAv
pjq4P6wSWXe+1sER6H+ll1Md9O+qsDWehtr3Chq+x6D+ewWNv/0IPjg+dqLJ
r691mObcnfP8JdT/S6DuewF1z3yof99Aw5u7DqL/O5Qvi8kHu6cPwQcFs1cz
NP3I1TkAXT31cA00vSjUgcM3uQrKV6qDpK+KqQ6fLvkmCajVOQBjPye9bKrD
A5D7tKD2lULN06tzACWn9hKoepM6ePoG22+J4IP974jgHwbFr1cdODwXlUD9
H1YHDu/DpVD3REH4zkVQ+XeI9IwS30A+AP/doU8=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQfbXipZrhnVqH+qw9JcLVUx1Q+KumOiybfURhw61a
hzogf/K6qQ58upvmvr9a67DLk4dp9SYo/2ytw81z34OTt0H5R2sdHBOeXlDa
NdUhKsX6vv/uWofTC123fd4DNX9drcOL3ys/Xto31WERUPjvglqH1TJRKbsP
QOWn1DqYGBsbbz441cH9YZXIunYEf4dc6+vAAgRf/64KW2M01L37pzqU75sv
pe8JNX8n1HyDWodpzt05z4HuzX0OlFCpdcgTaj5wagWC3zsdKDIbwQe6ule8
b6rDoa8aMf0GUPOapzrwgvznXutgDLK/ZqqDLdf1xQXx0PAphbqnEmIecxHU
P9MQfLD71yH4HiD/AcPLi4dJm70ULfyB8QEAjZPLTg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQfUHp9s86tXoHVbbGqYePT3XQbhe7eS4WwX+8dPYR
ha56h97peULNh6Y66N9VYWtcDeEz75jqwAACJ+odgMqduddPdTjmbd7peK3e
QQWkfwmC75jw9ILSTAQ/wnLLiW8Tpjq8rbE3jTtX72AMBJs7pjqArDmwr97h
+e+VH4MapjpMlmAJ41tf73B6oeu2z+VQ+2fWOzgBzVtUCLW/rt7h5rnvwcm5
Ux0ugvyTBLUvc6qDFsg/zlD3pkPVKyH4ra8Dd8i9roPzwebvr3MQWef+sCpn
qkPsLk8epvl1DqeA9hcD7Qe67tTC5jqIexug5pXVOdRn7SkR7kbw64D8ydMQ
/GnO3TnP50H9XwfRb7wc6t8+qPnA8ANJJwDtWyMTlbJ7+1SHjInAENpa5wDy
zu29UP0X6hxeAMPn0kGoeqD7H1WJrDt+FBpfHIj4Q49fACOU2YQ=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQfdzbvNNRqt5Bla1xqvPBqQ6fLvkmCfAg+LJRKdb3
/9Y5vF9+zNv8wFQHyy0nyva9r3NwTHh6QWnfVAeFDUUZEx/WOYCUc++B6r9W
53Dz3Pfg5B1THTImvq2xPwtVv3mqA5BnGncEIv947VQHBhA4AJVfjuCD5ech
+E5A+UUTpzoc/qoR03+qzsEYBNqg7rlf51CXtadkcs1Uh2qRde4Pv9Q5nF7o
uu1z0VSHGXlCzQcE6iHm50HdY4zgT5ZgCePzRfB3yrW+Dkyqd3hYJbLueMFU
h7hdnjxMxfUO9UDzhcumOgBNO7Wwud5hqnN3Tno11H099Q5AVdrtLQj+KaD9
xRMR/H9XKl4uWwgNnzqo/nVTHcDhD7TPBOidzdunOoC4Cf5Q+/ZB+eaI+ECP
LwCgtsNX
      "], CompressedData["
1:eJxFlGtIVFEUhU0ro/xRYY8fZRYVQUHEBBIWbZOQtIj0j1mBmOGkpqbj+KzO
MJjIIGJynEp6aeUrRc1GTTNNU1GIHmJUlJmEVpSJ+SiROufeNZ0Lw8w3595z
1lp777s+Ij74lKuLi8tR8ZHfuwcP59r7GfXd2u+YMHO6nbBn8et2RvfWhEU2
x3OKbjEVrHYwOi9/xHB6dShiaWgto15xf1I0pxN5Tya3VDCKW25t6zVyOuDh
ujW7GPtFcXJMzPWnXlW8LHRXfU+u4iCfHL9wKyNfoWOV2G+stCvIJ4PRm2fT
ISfjOKV92bxjURLT/m9I5JS9UqzEMeL+ttioVMWanguKC8X6iBWcwGjTQgvv
yAabGOXa45a72aAvXWdrHsdz8F8Av/mMdhoMhvt2TiUyn+vgIk7G/O+Zex8w
Etv7225ycuYpz/O/q1j6GS5XLGOYquO0LuvbkcYXjAzyaoK+PuTdwumnzKOL
0YrqgKE/j5HfI5zfzslLPl+n+KDMs0KxtNVWgv3alP6R2fLx4FZOl+X6FUaB
om7uLcjfzii40Ssrpkmxlo+Da3WyC94o86xR3CwKX1mFehXq/RBYCT+XGO0L
//y8WPhfGxbpO5iH/Mvgxwb/pfBzUbG2blGs6T2n572kDOeno75i/+3vhbIU
6HWen8xIHL/hXZXiUeH/ZY1irW8dOE/036d0z+ruZvRHtspPy6NA3+/YU071
PebWGyU4vxv1bFSs+e1RrM3LAPq3C/3wEfXq4NTpXZNoHGU0EzJ8p6gd9//A
PLRiPseR30P03y9GflJQA6cGqXeS0ZDQH1CrWJuPMsVaPjmKtfll8D+p96c5
A/6ncH8aJ6Gq03sa/Z6CPGb0efE1w/9v5JXMdR2zmEcT3idzWHfyX8XHpd95
lv/sIi83i67PhLzmW/T5SkZe7hbdvxn6PfB8KvR4gjMVO993Wn0WWPT5iuW0
re7aWOk08jVC31fFWr8NK9bO/4D8T2P9LeoVg/kbwHycQf/2o9/OqveBU88/
jGWylQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQbXPfv3f6lQaHUwtdtxXXTnWA8Y1BYAGUf6DBYY1M
VIr1nKkOW06U7Zu/ucEhaIdca/bMqQ7yra8Dd6xtcFBla5x6ePpUh/fLj3mb
L25wWFJgy3V9ylQHOZD87AaHR1Ui645PhMpPb3Coy9pTMrkPKj+pwWGqc3dO
evdUh22f/16pmAAx/3U7gu+Y8PSCUguCDzI/vH6qw0Ogue6TGxxA0tHVUx3a
xW6e+z4D6v4KqPnzGhzqgfYJl0LVL21w6J2eJ9RcDHX/GgQf5M372xD8mP5D
XzWONDi8+L3y46UyRPjAwgsA7sqfqg==
      "], CompressedData["
1:eJxllGtIk1EYx4dBQTeiIiQjLRKEyi6zRnR7TCLowki/jClhptjNbbrpVoRx
iDIJCYuDg2FL15TQpHQ6N83KloqBlAXSh7AYURFhJVEQQee8+78caIMxfuw9
z3n+l21NiT2/LMVgMOSLt/z8MXmkZImF0XjL/j5niNNhU31ucQWjj3/ufs9/
wslrW3rpMWOUOZfxp6Oc3EP+lZu44tODrpupfsWhsZohfzujhiZxcITT1dzi
Dy+6EjwnxqluxZuJX734XswP+mIZ9wcY8bxrZ8sfclq8sbt55hGjHKPR2BPm
tEjyMKPOVdbSgR5Ou+dPBRwxRvvE2NZ7isXUghNBxZqeWsV/X3s+t3k4vZJy
nzHqkPNc0DPKyCjvq+K0a9rc0DTG6ODClPXzKnH/OKNv7SOHwnZOHvn8BKN1
Uq+N0x45/yWjOw5xUwWnvllx0xT2EWwt3TltfpfMn4S/k6c4af5fSWb9+Xrp
X73iQnn+huIZsZfJi33FPsM/s4qu+5CfHX7fgn4H9LcwqpXBVcH/VkYXBS+r
5nSy8euFvQFwDeYFEv4YzynW/dVZ2z+g+HdBPJjWiT6J+6SMtd3Q15zYP97L
Kf3yl6P9XuQZgZ+N6McA8qlTrOXpVrxani/HfmHMt0Bfl2J9X53fn1/edcCD
fgu27BDNdSFfK/rq5GSQryJGIu68BZXQdyyhz2dHPsfRHxvml8GPCvh7RuXV
Jrk6mfX8NX1pyaw/r3H6f+ezFGt9zYZ+G/RsZfRc6J8V+W9+K5q7Df1wwl8T
7nMr1v3SWXv+tmLNvw7o2475D7CPPj8EzsHvrY9TXB4wMpJ1KOyHX1uQXwR9
zUb/ouj3BuQdhd9ZirXzmYq1328G8osq/zSOgFPhzyDYrP6/9H7o/A+2AH/9

      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQve3z3ysVBU0O9Vl7SoRLpjp48jBpt6c3OZxa6Lqt
OH+qw+ICW67rcU0OP4IfL5XOmepwxTdJICIMqj5rqsMSkLxvkwNb41Rn7oyp
Drqb5r5f7tLk0Ds9T4g5HarfCsGf6tyd81wNwTe4q8LWKNrksAtkcfZUB+v7
/r3T2SDyzcVTHUDUge+NEHuqpzpcBtn/oRFsX3cbgu+U8PTCoskI/vvlx7y3
L5jqYAMy70ejgzEQbF4z1QHo7MkSnE0OdSDGdqi8JNS/h6D26TU53Dz3Pfjx
cai8B4IP9l8Egt8uBmSlNjk8/73yY9DRqQ6w8ATZZ3wAwQf79yKCH7RDrjX7
NlR/fpPDC6D+Sw+h/Dyo/idQfm6TA9C2pbOfTXXwNu90TMhpclAFBcCLqQ4f
gP40z2pycAT6X+nlVAegqiMKGVD7XkHDNxXqv1fQ+EtC8MHxEYcmH9XkMA0k
/hLq/xCo+15A3RMI9e8baHh3QPV/h/InYvLB7ulD8EHB7NUMTT9APtCVUw/X
QNPLJEj4JldB5SdD01fFVIejChuKMqY2gd2dXgZNL9Oh9pVC1c9sgqRjYHo+
AlI/B5G+wfbPR/DB/l+E4OuA4nc5JDwXlUD9vxYS3odh5q+Hhn8RVL4SkZ5R
4hvIBwBA9p0F
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQve3z3ysVBU0O9Vl7SoSrpzqg8FdNdZBrfR24I7/J
oQ7In7xuqsNl3ySBiNwmh12ePEyrN0H5mU0ON899D07eBuWnNjk4Jjy9oLRr
qkPlSzVDjoQmh9MLXbd93jPVYTvI/Mgmhxe/V368tG+qg0xUivX9oCaH1UDG
7gNQ+32aHEyMjY03H5zq8GH5MW9zNwQfaK12uxWC/3jp7CMKBlD37p/q0C4G
dIka1PydUPOlmhymOXfnPAe6d0mBLdd1kSaHPKHmA6dWIPi904EisxF86/v+
veJ9Ux10Ns19v1wKal7zVIcrIP8BzTcG2V8z1QEULBJG0PAphbrHHmIecxHU
v74IvhfI/ZEI/nuQ/4DhBRJnL0ULf2B8AACWh8Ql
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0,
       1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3},
       {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
       3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGCwAmIQ3fo6cIfcyxQHYxB4O8UBxr957nvw4w9THB4vnX1E
YUcaBh9F/UQ0fiqCv3++lP5dlzSHuqw9JZNfT3EotOW6vtggzeH575Ufg15M
cZCNSrG+rwxV/2yKg3DzgVMLZdMcrO/794o/RPB7p+cJMd9E8E8vdN32eRqC
/7BKZN3xnikOBSDzRdIcPHmYtNtbpjhsPVG2bz4T1Pw6qHs+pDpMc+7OeV4+
xQGousD2UqpD0A651uyiKQ5bQOqXpTqosjVOPZw7xUENSDtXpzr8CH68VDpz
igPQGc0H3FIdVEDyaVD/ciL4jglPLyhdT4HzrUAGrk9x0G4Xu+mXMcXBCSQ/
GRK+ydlTHN7W2JvGlaU4RFgCFeZBwzcjxUF0nfvDX4UIPti/pQj+GhlgwFVO
cZgBck9eioMJ0Hubq6HyNSmQ8K2d4uBj3umY0JviMBXo3/T6KZB4XJjicApo
XnEDNPx2Ivjg8DqF4H/TiOk/dBNi3+56qP+eQ80Hhuftn8CY/QJ1Xw3UfNZU
uPvA5kmlQsK/eIoDMJrcH6pBwnN2PjS8zVIdXgDNu5QLdY8ngg8y5n44gp8x
ERhiqdD4y4OqL0x1qAemL+FCaHzWpYLTg3sxND20pDrsAiWIcgQfHD81CD4s
fcH4S0CM+9D4bYTww59McVA35FgjUwVR3/wM6v8SqPkvoO7JhPrvJdS8CKj7
X0HDxzEVEh9voOGrmQrPL+D4E0DwAQ4runo=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQPeHQV42Y/nQHx4SnF5Rqpzis+njJN2kFgu9j3umY
sDfdga1xqjN3zRSHtzX2pnHn0h1unvse/LhyigNY//10B1WggsPlUxxkolKs
7z9Pd/h3peKlWimCX5+1p0S4CMH34mHSZs+fArEHqD9oh1xrds4UiLlnIeY5
Z01x6JueJ9S8J93hR/DjpdIZUxzC+HQ3zV2e7tALFGdOh9rfj+DH7vLkYSpH
8NUNOdbIJCH0758vpX83AGF+ccZEoJcQ9leJrHN/aIZwH4wPcz+MbwwCpQj9
L36v/HipHGH+6YWu2z5XIuwH669BuA8WvujhDwBlHrAW
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQvch12+e/P7IcXvxe+fFS5hSH2F2ePEzhmQ6nFrpu
K76N4KuyNU51bkTwg3bItb6umOKgbsixRiYu02GNTFTK7uIpDn3T84SaczId
TIyNjTcXTnF4vHT2EYWGTIdpzt05z/OmQMyZn+nQC1KXO8XBBSj8+ySCzwAC
HzD5MPeB+RUZGHyY+otKt3/WzUPwwfafQfDB7nuTAXavdf4Uh+KMiW9r/mc4
GIPcWzTFwSnh6QUlbqh9JVMcwOEjkOmwG+jt1ZUIPiw8YHyw+TcR/AjLLSfK
7k9xCOPT3TQXaN6jKpF1xx9D5Rmg4ftsioNw84FTC39mOICsjX4B9Q/QfSD9
315C+TcyIPa9hvKPZDiAuN1voPwlEPcbv0WEBzr/5rnvwY8/QMN7ZSYq3zAb
or4dqn5LDlx+b8lkCZZnuRh8mPlgfx9A8MHpYRKCr39Xha2xMBcSHq+h8ROX
C9bHDPTvDJD2IKj5T6Hh45ML9h/3QwQfJXyBfJTwB/Jh6fGYt3mnY0guPD3G
gdJrci48PQJdsW9+WS48PX7TiOk/NDUXnj5g/oHxYf5F58PSH9h86RwMPkw9
2H0OCD7Y3fkIvhXIQf058PQIDp9FOfD0CA7PdTnw9AiLH1h6hPFh4QHjw/Iv
2D3C2XD3AQCEzroG
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvch12+e/N/IcHBOeXlCqneLg0p3z/PdHBD92lycP
E3u+A1vjVGfumikODCAgke9w89z34MeVUxzA+jXyHVSBCg6XT3HQv6vC1miY
7/DvSsVLtVIEvz5rT4lwEYLvxcOkzZ4/xeHWz7qsPUD9QTvkWrNzpjgUZUx8
WyMOMc85a4qDuiHHGhm2fIcfwY+XSmdMcQBJ2wPd1zs9T4g5HWr/DQS/0Jbr
+uIDCL7VlhNl+1bnwfVfUrr9s25WHtz81teBO+Q68+D2g/Q1N+TB3Qfjw9wP
4xuDQClC/4vfKz9eKkeYf3oh0GGVCPvB+msQ7oOFL3r4AwDO0bPz
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQ/Xjp7CMK7wodXvxe+fFS5hSH1teBO+RkCx1OLXTd
VnwbwVdla5zq3IjgB+2Qa31dMcVhGVD7BoVChzUyUSm7i6c4ACnr++qFDibG
xsabC6c4eDysEllnWOgwzbk753neFIeMiW9r7B0LHXqn5wk1505x2HKibN/8
MARfuPnAqYWZmHyY+8D8tQUYfJj6apF17g8PIPjuIPuvI/hg9z0vALvXOn+K
g7d5p2PCxwIHY5B7i6Y4lO+bL6X/HWp+yRQHcPj8KnDY7cnDtLoSwYeFB4wP
Nv8mgh9hCfTZ/SkOtlzXFxcAzXsEdMbxx1D5TwWQ8H02xeG+P1DnuwKHhKcX
lKJfTHEQAvnnOUT/t5dQ/92F2vcaKn+5wAHE7X4D5R+GuN/4LSI80Pk3z30P
fvwBGt5uhXD+VhCfqwiivh1q3ukiVPUpxRh8mPmyoPAMRPDB6cEKwX9XY28a
p1UMCY/X0PhRKAaHFzPQv3G7gAErDTX/KTR8JIrB/uN+iOCjhC+QjxL+QD4s
PYKs2Qc0D5YewelVuRieHnOfAyNWpxieHi8o3f5ZZ1MMTx8w/6CkzxRMPkp+
qS/C4MPUg903CcEHp/+VCL7+XRW2xp1F8PQIDp9DRfD0CA7PE0Xw9AiLH1h6
hPFh4QHjo+Tf34j8AwCCUu09
      "], CompressedData["
1:eJxFlG1Ik1EUx4eBQUofzIjCJMsikJBaESnUsRGafpD0SxmFpKHpnNW9zpVi
iYjJkAivWYnYNKeWiprvL3OmTTEQESokxEzMXpEoeke6L2fdwRi/3ec553/+
55wbci474byPwWA4xb/i93P+kQNnkyk8cxzr/mplkBfYGr0QQaE5KCl1IJtB
3MHSqOQdFAoyBml5JoOtSamR85spTPLnSQaD8LlQ30I/CpaAIvdkOgOPeOEv
UfHSGCzWV41t+6T5jnhwRvP6PR3VK0MEIufjyzbxeBt4GEcLgdmpH4kpFgbp
t7jCagIrDZ64nssMij+e6A2uIFBhspvTbJqlnmuab/Pz5SLkuwR2+hZWjJYg
OwiUVVoC1thRX7PiopsMzvQf9/cZJqr+cqx3lsB+o9H4uBL9+YZcxSBm4Wpg
awgFHt5kv8/A66fIZ3JqFvUsNmk+eahz4nsHg64Jq6smiYJRfPpQXzz6PchA
2OowUdjI0/4eRv/2UZV/hEGneD9Is/TTT7Mor22VqHhurX/5T9OXBBcDpzj/
QCDW3yds7SD6v0QgoTe4OLNPs/SnG/W/JRAq/GzTPMBte9SC/Vokch5iH2E9
cwSOJi9N1/L6zSLxC/S/kYEI654iqv4GrGdMs6y3X7PU20Gk336NmL8Z+8vj
P7e937XXiXq9+esI8PTbX7VofsdlzLRp5vLDSrpRTyuBN7yt4wM4Hx7tn/Rj
TsU7/ZQBH9tKyyrmH0f9u+l/zhL1xmiW+5JC1fx6UL8N+zXKwCA+Nyj8TOSZ
R/D5cjU/KS7s3z2q/OtnEC3mr4ZClBDUg3prKYi/o9s1y/1o1Cz9KdUs9/c6
+l2r5tOah+cP8PkrDA6ve1l3sR7nPRfns0HdF5FWnOeHOL85DCKEIS1U7SPF
+6Qdz73cpVnW26c511WzJXwI9VH0y437lYN+ebB+K+qfxvdt2I/XyPmavfed
7M8T3C8zAz4lvwqc6G866rNrlvkLNMv8FPNfwHMz9isT9y+Vqv3Iwvnl+y/n
7ZK+D7x6/gHEjJ9t
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/bbG3jQuocTh1ELXbcW1UxxgfGMQWADlW5Q4rJGJ
SrGeM8Xhvn/v9Dy5EoegHXKt2TOnOGw9UbZvvlCJgypb49TD06c4CDcfOLXw
b7HDkgJbrutTpjhsAcm/K3Z4VCWy7vhEqPzTYoe6rD0lk/ug8neKHaY6d+ek
d09xeLx09hGFG8Vg81+3I/iOCU8vKLUg+CDzw+unOFiBDLhb7ACSjq6e4tD6
OnCH3MtiiPsroOZ/KXaoB9onXApVz1jiAPSFUHMxVF4Awc99/nvlRxUEX/+u
ClujfYnDC6DwpTJE+MDCCwDowZxK
      "], CompressedData["
1:eJxlk2tIk2EUx4dFhUhFtS5Uw2VK5Kew6INIxySkIqQJBhUhWliibs33yLLQ
JLrYhSgf9YNBrJqRhVjOtY3RRe1CgYQo4ZdsjNJRfuguRZfnPO8ZT+XgZfw4
5z3P//z/z2svcTr2JVkslo3yof/ULvf+C2UI6TMamvueCPib87oFfBzcVjL3
BIIjaDv+7oGAresbc4t9ut9O/Y80D3viGWuGNNNr218j5Ba/eXHlsYDMkwtH
BuIIIwPfCkv7BeQkv7zq+oQQ3pySlNnL/ZMIk4UxX9t9zVny1x35t740LKCR
Bn9mfXd5/oR53oqAgIqxHzc+vEW45spJ3uEX4GvrT+16hfDMuylQLfdrWjy9
aPaw5uU792aPPtes9D1EyB4tONfq5/k9pv6YnB8iPR2sP8R1LwId6wiz3kua
1bxWzcqviwi/hjzxdvl+75dVu8+f5XpQQDvpPcp+9AiYOLJh3R6D97ut81J6
OjSrer1m0r+olvMsR4jWLujMr+H9nQhryd9qAX10vhuhJe9MxdhBAf6nNfcu
exCaJZe5BJA9BQ1mHllOATEy9DSCtTM/+r1SwCk6uIXzreT+61N5XO43eID3
fW9M4US/0vdbs8o7hfOvYr+tCHXlEaNJ6qGYqpYh/CQ/pV7pftBmRyA7drkF
rKb+NL5PBtfTWQ/yPMlbZJwzD2lWedRpVn55/6vfEnBY2hpdyff9DutPY/bz
92M378vNAOdvM/PPCHJeSxDq5T7zQ/y+lfWE2b85CHLLeccS92uWZpWHRTPF
HP1qKJ4W1v4qTty3ccP0L8L5Fenv9w8F3AAa
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQfd+/d3peRZlDfdaeEuHHUxxQ+EenOHg8rBJZdxYH
fx+aeiT+6YWu2z43IfhePEza7LVTHCy3nCjbVw3lV05xeACSb4KqL5vikDHx
bY19Z5nDNOfunOclUxwYQGBSmcPNc9+DHxdPcVg6+4jChjkIvsFdFbbGpQg+
WP26Mge2xqnO3UD9Vyteqhlug8qXTnHYIdf6OnBfmYMqSEE51LwjZQ4gb7kD
3VO+b76U/kmoe6qnOOQ+/73y4w0EX2FDUcbE82UOp4D84lKo+w9B7SuY4mDL
dX1xwUao+blQ/y8oc4gAevxb5hSHDseEpxf6yhxAxgZlQO2vQfAvKN3+WVeA
4B/6qhHTn1LmsMsTGGCZUPdElDm8AFKXsqDh5VvmAJJuz4Gqd4HalzfFIQek
3q7MAWStUhHUfZZlDnlCzQe8SqH2m0HNr0LwgaE69XADgg+LX7D9f0ox+KDw
TT4IDR/uMoclBUCbDk1xuAjyjxTUPlj60YSaf2KKwyJgsP61gIbXGah9bmUO
wNDMSb8wxWEZiB9U5mAMAlehfKD/18hEpey+Do2vxDIHkPei70DjOweRngEo
8WZS
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3fo6cIdcfrmDKlvj1MPHpzjA+KcWum4rrkPwV8tE
peyumOIwI0+o+UBBuUPQDrnW1yVTHB4vnX1EoaTcoXd6nhBz8RQHoOypheXl
Do4JTy8oFU5x2HKibN/8mnKHD8uPeW/Ph5rXXO6gArIvb4qDFUhBZ7nDkgJb
ruu5Uxw8HlaJrJta7nDz3PfgZCAfyHN/uAyT/+L3yo+XMqc4CIPs+1qGwYep
B5q6uIAdod/bvNMxQRiqH8aXLHcwBoLNQPfo3wW6TL7coS5rT8lkoHvf1tib
xqmUO4gCrf1VMMUBGAzW99XLHU4Dw+dzEVS9NpRfAjVPt9wB5I3jFQg+LDxh
fCdg+CxaiOCDwq959RSHqxUv1Qx1yh2mOXfnPN84xUEWZJ8m1L1bpjgwgIAG
1L5t0PBUhcRH9g4oXxESn847oXzZcgfr+/694rug8SMOtW8XNH4EEPyMiUAf
cyL4x0AOZIDG7y5E+IL5O6Hx/6EMEl57oPw4RHoCALvXHlA=
      "], {{377.57, 
      1341.066}, {370.227, 1332.472}, {369.383, 1332.472}, {
      371.99199999999996`, 1341.066}}, CompressedData["
1:eJxllG1Ik1EUx0XDwMLCXrAXZUZGJBW1IiJypySMLKQJURYSZi9GbtMtn/tI
LEIiIiLKK30QMTWN0MS25V40s5RVRsNEk31JY4RJSZlIkgnd5z7ncol92MaP
e59zzv//P8/SCq3ms7ExMTFm9tF+84v2jOaaCPTXH+iweygkbnbV/igmMD73
eMr8kkJzTZ+h/R6B9Phr1b2vKRjayy7c9UvO2XVz3+n3kkdzb9+3fCLAvpMq
gxTY6ZeB7zrH9VG4/u2oL3UOz1n9VzMbT92JV6E669al888pVCUvOJa4RIUd
RqPR7UVeoULr2vyiTjeFX4NHCpcmq7CflW14Ijkc+p13pkky1+OUPD9EJpoJ
hRRN8CoVWrR6Dgppmp4UFYxavzIKk1dMOwsMKhxaHJuxsBT7p6vw81Ewx2tF
/RkqrNf0WrD+dhUe2vYmjJRQiDQxwzJxHsabbqwMh3Kj+Svzd7CYAve/hkSx
uM/9ayD/P++WnFTZ01//gujzsnl8qczhIOZnRb9ZPly/DfV/IOC82OWoKkP/
hwhcZbzsMoWDnyuWtw0jl2O9j4T7Y1QlC38F8/kbJc/mRZrWtOI+sX6ajHUu
1PdWnz/yjILnTXl3XQ/R8/Sjny7cj07Mp1YyP3dK5s8X4HxerG9CfW2SxbyC
NZnZBPcbCBzfzSo5MN8s3Fc7BaW7bvXWbAIs7qxFpajvsK6vxor5mPX+bgvW
P4F+lKC/52RevRpXRLPIn+sLKlEs7nMOSeb1xyTzfZ1UdP0W1DOtwDumf5rl
P0wmNmz7o+j7YUd/57GfIln4JZjffyCZ+9eC/f9i/aeoR9T34Pmsor9vHRQy
E0YabTMKaOtw0od+TSl6fn7cVzY/378A7ve4oucdQL/HJPPnw5L5+zugc1xA
+sdZ7FcP+tOFvEX+f4n9EPwPIJKCaA==
      "], {{407.371, 1319.7839999999999`}, {
      420.246, 1319.7839999999999`}, {420.246, 1316.019}, {407.371, 
      1316.019}}, CompressedData["
1:eJxllAtIVEEUhhcTg7KQtAwsMTEIhQoqetjjqFioSaRQkSWiltqWK2pRdwZF
JEzSQpzaqCi0TE3ZAq3oQYmFlKGYPcykQkxT1i0fZWUKzeMsQ3phuftxZ87j
P//MkkRLzAEXk8m0m//EO7XEQbfEUSi2ps+b8YOB5DQKX/9WD8e8QI6bwtEU
XpaF3x19zaB0oeuuucEU9qyvfz7WxYCHyW8IoNDZ+is2qZtB489l+866UghJ
6G3zH8D9XUTlczC4INZXaR5pj070SNbMwx57vILAKvH0Ic8mkHPoUXbpewYb
BDsM+B3bU+HTgvk/GdDM68t6olmuv6V58s3xgRvlDMT2q/2GrLfnPIM2/64/
ORMGLHXLOxdWhOxBIJTXX57H4I5YH0jgesamWR0nGMQ/iHB3iSJqfzaDvcnB
n3eYidLDgvuLVD/5R5Btmu/7nrTvbNS88mOAW95bovRKZ2AST7+Kn2TB/OME
RNqaDKzfnYIo93QmrvfFeR6dwpc1Cxmaef+LRcE+FGoX8T+VqK83zrsa2ZMC
j344pYZB1NrCkIQ5FObbtnWP16KefL65XF9PG85vAufF9S4UjQwSqedTzvtF
4R3TWfZfx6BJJKii09i5XvIVzX63M1NLCjXL+giFSHeXoJk2rD+LqvnfZMDd
tyY+nSq/VOF3s9ofdk2zUy8ni3bqMtHv0RiPz+eU6G856m9mUM6PxaQHVX5J
Qz+MEqnvwxScdzuBAFHvQZyHTbMnH0tZuGZZ7xj624L9NxjQz+fTnov9Ww0Q
dokrwvOVbyh/XtQs+6vRLP11D/1zxgA+haCCRvRfBZ6fFvQrzyfn/wHr68V8
X7BfL6L8Ysd4G4mqdxjnYSb/3y9lmokXN1K9ZumnJgJctWLrKPI71GOEgSHW
9+H5GsbzP0ngeyVXZgjj+6B/nPdJIJXxvAdR79V4P9mx/nWaeyouPfPbrPmV
6D8U7zc77t+K95kD9YhQ5ynyG4PAggWdrVEqn3UI9duu79d/V1iPwg==
      
      "], CompressedData["
1:eJxFlH8slWEUx2+Y/ki/U7YkTFvxR2231qLWKWuGNYutiTKhuSFG3Mj73JK1
OzMz84jNlmiFxCRdP3cjdUmboT+aWen6EROZrCRpPc/7nNtzt7u7z33e95zv
+Z5zHo+YlNArdhqN5gL78t/S5G25XfcJvKs8Y1rSU9AVzSsnswg8dY2I60ih
4NvcpzdfJmBI6EwvTqRgCT6adyqcQD97/noChT0RcX5jgQR4mH4dhRfs8Qpf
jBdPYchzdMXgLfnu13Otblslt7qxf/4o4DcWUrCLxdPwz5wCIwPLYbHJFHjY
ylEFFqotwS1pFA5+9HLMea9AiX9+UnymZFXPLcn32Pl0LvIHBfY55pT0GJHH
FChghdvno75ZwbmFFHh50WuKqL8Y63UhcFir1T4vRX+0yOUUvg+fjdkSTYCF
989/QMHmJ8/n/1gyr2eiVnL4sea+n00UqpgNa2UEtPzTRuEQ11eAfneiH3cI
ODcEWH+/RP9SMX83haj2QCe7SMlt3M8gycUuDuc3ncB4XVL/9GrtYqgZzw8Q
CHKy81lvy+dFIJQ1JrFNsuqPCfUz9uJ+NkruYDLq6ils5/3yEPMQVId+7yZw
OnpqsIrVz8clxFnEs6/BejZi/dVYj71k9XxF+c+q3kVF9XsDe7+MJ5rF/rL4
r37sv1g4if205bcqwNJ7jtZLnmH1DzdKZll9jCbMN6/A+M0dDb0dFAb5fDhI
/1Q/XIkaL/INBTYtU4PHRb97eilc4vrjJav1GiWr+1JJxPxa0D8T9quHAuvO
kSgLgV9hE4/Ku/H5ITE/sWbs3wj6147z94kAl+HZgno/E7Ay/QHPJKv7USNZ
9SdPsrq/t7F+q5hPfTbuxzg+n0XB27hzZGAC5/0G+vFF3Bd+epznGfQrgwKr
4rX7HBH7mE6BhzUv4LmNlyTzMGPLkt0b03RFq6gvHf36i/uVgX45GET9etS/
2SDez8R+7EVWJNvuO7U/6wxiv5IoZDPbrJPorw7vv7eS1fydkr/x/E3o/1Wc
xyfYr0Sc14e4H9eQK4iYt1R5H9j0/ANLiYQa
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQPT1PqPnAvFqHUwtdtxXXTnGA8Y1BYAGUX1brsEYm
KsV6zhSHTseEpxdiah2Cdsi1Zs+c4rDIddvnvwG1DqpsjVMPT5/iwAACNrUO
Swpsua5Pgcrr1Do8qhJZd3wiVF6l1qEua0/J5L4pDnG7PHmYpGsdpjp356R3
T3G4oHT7Z50YxPzX7Qg+yFqlFgQfZH54/RSHx0tnH1GQqXUASUdXT3HQv6vC
1qgOdX8F1HzjWod6oH3CpVD1DrUOvSCPFU9xiAXJ+yP4QF/e909G8GVBArW1
Di9+r/x4qQwRPrDwAgCklYxo
      "], CompressedData["
1:eJxlk31Ik1EUxoeGwSj/mH2RJCU5RAuR9UHI7JjUKglhiwQzLGf0gc6VZiZx
XkQiJCLCuwokQmvSp9i2po6hoiPFP2REIyzCZIhKRARFX/Rx73tP3dIXXl5+
nHvPfc7zvHddRY39aILBYNjBX/FN3ui7+d6LkJHU5BkeYfAvF/oZTBZfvu6K
INh70y68HWSwLTBa3x+ftz5R+8vDnzLLrpgUe9sia7vTNCg4PB3teMog1jBn
zs3UYGL8s8MZYZB9ccXEeK4GoT1LErKHaP0WDb444t62AcUW/vjD/9dTQwzO
9t9anWPRpL4e6r9BnpceZFBamTdZnKHBHbfVWBJg0Lpq0YHkNRqMte8M1vL5
rMYXt90pikeKtrYUGBVnCX2/EPKEEQHq/xF1/XHev1PomUWpv4/qbxBmvt/7
YA9R/aVifd6Y4iHhVxTh5/OGuU6+v1oUxqjeS3oHUPrxhMENl6l50Idyvscq
L13PfcV6XVMs9K9spDzvIkw1Luuy1TPIF/M/Qtgk/K2l87sRrhVeqpo5xeCQ
GKwHwcP5mJuBTWzkekQelhoG0fRXX3EUYXmXbepbNeURk3qcnHeL9dMLeZYf
8+wEnZe1kP+s1/VZFev9i6QfqS7yez8CngzXtXI9LWLwUoQfwk+uN+f1+qSm
cgRhx8HTtL5C6vfXUd1J55+heiXCXh7n4nOK9TxQse5X+7z6QwbHr747v90p
/e/w0f91hDhA96dc/i8PgpR/mczfzPNeKvIqQdD4PCl9tN9BekLk3z4EnqKp
OUT3YZdiPY98xbqezZITQ8pfnXn/KsFm8i9M/nrU/f4NRsgKKw==
      "], CompressedData["
1:eJxVk21Ik1EUx4fCCo0YagYV6qSGaSKWJDWNIyMiI0b2JVRCzDAsaoTYkuze
ErFYMqKzhCxG6RA137KGSxkrXUaRhCjiJ0sJG32wEulDGN27e/DiAw8Pv+ec
c8//vFxz5ZWS8zEGg6FQvPIbThu4eqGIQ0vr5YTGewj+lbVpZwGHM4devq/j
CO2OwrjZ/RwOyOcawvEtMVnNuxUPORCcQe+OnGQOz3eVVllrEMqqrPN2ozov
thohqzl5bjLC1nk4penHqZDmRV/beNpjBhXfPqeXXUQolfENDFjNaG1iLYJQ
EfSeZfC1Pqlv4gbZ7UzpuKN56W/Xr5JWzXlSn4/yVdD5gwgBybfJ/zXCvF0o
6VDnHxtDOBI32+74xGCP8ZZnbILOW9M8tppR7jbxjfZUDnOTf06fCyN4bK5L
S5kcikTCZyHq50FlXxxBlUf09+PTo/4Vv+bvQs/UoOaovn4EqxR4mKv/vWTP
56q+HoTrEUvu5jwO/6adEUs35cshPV0I2S+eLHfu1XxXCjNrfij17iS93cTb
Faf3Uvw2DqJcm6sPodz9djUjicNy57sT+ULvuNyfRPJ/hSDbO5yg/OMDCL+n
TlaaRL+Kxbw2jZJ/PFfzDZK/kThE9RmI31D8T7bOZhF+f0bzjCg7V+yT6K6v
LUj+AzT/AM3rEVP7O4SQKffRzVRfuzVH5+PVHN1PD8IXuR8iXs612kX2fsrf
iCDlp4QZ9Ij9H6mn/AsMbgr7gzqqJ5ZvZJPmrbLBov/i9oU+OBEWpN2i9svW
gFAgdWYre7G4j6kyoZh3h7yXTQj75HystF8tCP8BUxLL4w==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQPT1PqPnArAYHVbbGqYePT3GA8U8tdN1WXIfgr5aJ
StldMcXh0FeNmP7ZDQ5BO+RaX5dMcciY+LbGfm6DQy9QIXPxFAcGEJjf4OCY
8PSCUuEUB4O7KmyNCxscPiw/5r09f4rDDJB5SxocVED25U1x+HTJN0lgRYPD
kgJbruu5UxwqX6oZcqxrcLh57ntwMpC/5UTZvvnbMPkvfq/8eCkTal8cJh+m
fqpzd87zNARfNirF+n4OVD2Mn9/gYAwEm4Hu4dXdNPd9UYNDXdaekslA9/qY
dzomlDY4iK5zf/irYIrD46WzjyiUNzicBobP56IpDnwg9RVQfgnUvMoGh4dV
IuuOVyD4sPCE8Z2A4bNoIYIPCr/m1VPA+tyB/Gkgd2+E2lcBde+WKQ7l++ZL
6cPs3wYNz1JIfGTvgMZXMSQ+nXdC5QsbHKzv+/eK74KGTz7UPiBfHxQ/2Qh+
Jyji0hF8kPP8k6HxuwsRvmD+Tmj8R0PDa88Uh0wQfxIiPQEAphga/g==
      "], {{
      533.9689999999999, 1341.066}, {526.625, 1332.472}, {525.7810000000001, 
      1332.472}, {528.391, 1341.066}}, CompressedData["
1:eJxFlHtIVEEUxheTCusPrbSCMpOSIiFqraXscUzCUirSsk2TTC3Xd9m6aUnN
ILKIiIRj/iHROxVTzGrVFNM0FYNeWpJWohYWPVSWNIyomblnmwuXy49775zv
fOebWR6TFnrcSafTHea3eFo93j6b8qPw9NpOm93CYLysI8TgTeHOkoi4xjQG
Nvuf3kwPCucTm8xFSQyW5X7dX+9GoZt/fzqRwe65TmusLhRS5+W0dJsYFAfm
J4864XrxDG6c3OrSN03+c1Th45+rfiguET+OEPAf3FewkK8nniUDBLiqsNhU
Bu1eNemmHgJjXFddOoOePTGuxudE1onPVCz1XFB8SejIQX5JYOVMWtxmRX5N
oIAXnpGP+vo1zilkMHR2QXXQR6L1X4T9ThDw0+v190qY1GH4i1zK4EGXpfmK
OwW+fGD+VQYOP0W9wNuKRT8jFYqNm+53TdYyELYuWk9BL64G1OeLfjehHz4U
3KuDhqYfoX+eVKvfiv/PVyz9dFE8cqu03csZ12tR+kd/V0yENuN7Pp9gPsdZ
jnpTBELrPXOTGhRLf2yon/MK4WeN4kYehMoqnNckkXkIrsR+7AR2RH96cZ33
b7r4PXv7OPpfzuCI6Ocb0fovw35GFct+hxVLvR+I9HtOOdbvx/ny9ZdGxPkP
9qFeXr9X1H9DgJf3HqhS/Jn3/6pGscyxDfW8IzDMc9DZyOCmyAfX4/BP+mHX
1ot8wkAnLmdt3m2dqH+xYtnvasWyzkaq5bcD9QPOq42BmwjGLgq/wninrfj9
Xi0/sc24P0Op5t9DzN8BCgFCUB3qPUi1HN9VLPdHuWLpT55iuX8J+h2u5dNy
DvdHOH6fxWDtez75Q5j3Mwy2CD+M2nnhb8H+IzBvGQx8ay+PlUVSbT+aGdSJ
8yQK35vxfDmqWOTQekxxiCEvIDoW9ZnRrzjcXxnoVzz2b8H5peD/magnAzlb
seO8SxDzOYH7K5lB1hefdbON6K8J9QUrlvUDFbuK+tuwfgK+34zzSsK8Gqi2
P1KQN1BtrqfUeeDQ8w+Pa525
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ3S5289x3k0aHUwtdtxXXTnGA8Y1BYAGUr9DosEYm
KsV6zhQHBhAQaXQI2iHXmj1zikPWnpLJEnyNDqpsjVMPT5/iYH3fv3c6c6PD
kgJbrutToPJ/GhweVYmsOz4RKv+9waEOJNEHlf/c4DDVuTsnvXsKRN+HBrD5
r9sRfMeEpxeUWhB8EB1eP8VBZ9Pc98uB+kHS0dVTHC77JglE/GyAuL8Cav7/
Bod6IEO4dIqDLkg9a6ND7/Q8oeZiqDwvgp8x8W2NvTiC78nDpN2u0ujw4vfK
j5fKEOEDCy8AauKTBg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvf3z3ysVKxsdHBOeXlCqneIg1/o6cMd6BL9d7Oa5
71saHdgapzpz10xxeL/8mLf5zkYHoGjw48opDmD9exsdVIEKDpdPcbC+7987
fX+jw78rFS/VShH8+qw9JcJFCL4XD5M2e/4Uh6MKG4oygPqDdsi1ZudMcQAq
myyxE2Kec9YUhxl5Qs0HgPb/CH68VDpjioMnUF870H290/OEmNOh9q9E8L3N
Ox0TFiP4sf2HvmrMQ+hfUmDLdX0mwnyDuypAFsL+y75JAhGTEe6D8WHuh/GN
QaAUof/F75UfL5UjzD+90HXb50qE/WD9NQj3wcIXPfwBSny6fQ==
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{1144.027, 2020.6402050000004`}, {
     1145.176, 1516.4832050000005`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0015994239186056074`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{1144.094122659, 
     1991.3621645808503`}, {1158.7655126689, 1976.7575545907503`}, {
     1144.0076499153, 2027.9561577377003`}, {1129.4885126689, 
     1976.6907722899002`}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{680.2890000000001, 
     2032.5462050000003`}, {876.5659999999999, 1500.6752050000005`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.001394605241879238], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{690.42544817, 
     2005.0815386100005`}, {709.227023058, 1996.4178515660005`}, {
     677.7537728820001, 2039.4128005420002`}, {681.7613920919998, 
     1986.2809637220005`}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{1647.566, 1569.6552050000003`}, {
     2220.367, 1569.6552050000003`}, {2255.824, 1569.6552050000003`}, {
     2284.367, 1541.1122050000004`}, {2284.367, 1505.6552050000003`}, {
     2284.367, 1331.2532050000004`}, {2284.367, 1295.8002050000002`}, {
     2255.824, 1267.2532050000004`}, {2220.367, 1267.2532050000004`}, {
     1647.566, 1267.2532050000004`}, {1612.109, 1267.2532050000004`}, {
     1583.566, 1295.8002050000002`}, {1583.566, 1331.2532050000004`}, {
     1583.566, 1505.6552050000003`}, {1583.566, 1541.1122050000004`}, {
     1612.109, 1569.6552050000003`}, {1647.566, 1569.6552050000003`}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxlVG1IU2EUHhIVERUVFVFoQh9gUbGgYoVnGYzMGjlKDUORbGqlFaayYiXL
j5xzs229grwtLA2hTPr6NVZkkj+iTIMwKXUwtjklFlREIJ1777m8tF0Yl2fv
ec95znOeczeUVOWWpmg0GhP+pHfO7pv6SR2Hj+njf+biDA4jLq5Mxs+HagK+
WQbbnvDvm88KPJjWfylSxuFahb96BWL5fzPdjzFYNfb+t+kMh9tZ9nPhaQY9
nW/S+ks55O99NlQTFbg24Fv7OCxwRhPeDDH4MXKkZJmZ7gcZnDytm/hQTvm/
Mbiwf9HnexUcyttnr778ymCJRBD5BS0r+96OU77zHLBaIHWMQRnGZV7mStw7
ym8V53K8jcN6qdAkA5RIc72R8ocScFhgL/IzYz+rsd/RBuI/Tec3qF6M9MP8
Az+3FC5FvfzV7jXz6oWeKp9E/N88upKxGl8X3bSz+Q7xQZzaEDu2p5PDOuyn
aEbRp6qDwzDetyI/3YTRwTwcIn974yNhyufkkL04JWMB6s0ql9teNQt9ZD4W
Dq+Rv3OQ5uGhcx+DUTzOx3pzn+qiPV7q764y719Oiu+i/tsYXJTm181BXxwa
Tm9lMIVzM/SSn+wMOqT6j2geLQJL9XyNTKl7JRmr8VtR7wdWgRc+RCVQ7wNY
r8uu8DHaFP9tdxA/nNfG+fXeLOQXx35dOM9dWq32qVNgWb92gcOoX66b9FH9
wxL85RP7JPf/gvieEueyf/Jovkzx447jCp8Bt8DyHG8JLM/DRfVOcLgvLUYb
9ZOn+PGog/gWkD/tdL+Q6rWQ/4uEXipW9e2W8L5krMZLaWszubJndtpHPQet
9LQSv4O0Pw7yh4H85iKcQ370UrxJ6CPzV/ffn9D/F5qvkfwWpO9TNvGJkH8M
tA/o/z7DlMWDfA5h/aYZZR4+EPukfh9V/A+87JlN
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQzae7ae77h3MdDn/ViOG/ON0Bxs+Y+LZm/yI0/ozp
DntKJkuwPJ7r4MnDpN0+abrDstlHFAyeznXYcqJsn/yE6Q6FtlzXlV/Mdfh7
peLlsp7pDgVA/uI3cyHmdE13WApUv+ETgj89T6j5wA9MPsi8+W1Q9Vsw+TD1
YPFdCL63eadjwkEEH+y+Y1D39U53+HTJN0ng5FyHC0q3f9ZNhLrv1FyH0wtd
t32eDPFv/um5DibGxsabZyL4yOEB4oNpzhmofOEZEPuB5jklPL2wSHIGWJ/9
CWj4ysxwSBKIsDQ5OtchwhLoIvkZDjpAZy4/MNehfN98KX3FGXD/wPgw/6Lz
DwHN61eF2P/+HYIPDv+/CP5loHcjOOY51GftKRFWmeHwEej/CQLzIOEBNE+F
rXHqYYl5DsYgIDcDHF4b5Oc5qALFnYHuj0qxvu+vOs9Bu13spp8Q1D6teQ5L
gAEXzj3DYQYovnTnOQBV9YozI/hg+39OR5Gf/ma6wylgOBdrzoOEx6PpDj7A
8HqgMA9i7s3pDmI3z30PloDYdw6YHsHhxzPPIRMU/meh8f1nLpz/sEpk3fEf
CD44Pr/MdegFJiTmc9D4/wANDyBfvvV14I7XcyHuPT/dAWTN92fQ9HIekd5h
+QEAJNKFsQ==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQzae7ae77h3MdMie+rdl/fbrDp0u+SQLP5jqcXui6
7fO16Q7yra8Dd7yc67CkwJYrHMgHq38zF0Jfne5QaMt1XfnDXIdDXzVi+oF8
H/NOxwef5jrIRKVYxwP5W06U7ZP/iuBnAO2x/4vGZ5nn0Ds9T6j5BlQ91zwH
7Xaxm+fuTXeofKlmyCEwz8H6vn+v+NPpDgwgIDwPou8tGv87gg825990h3Xu
D6umCM5zuKB0+2cdywwHkDUH+OZB7OeaAfEn9zyHh1Ui69wFZjiArP3OPs/B
GAg2i8xwACq7f55pnsNWoHnzxWc4LJt9RGED0P11WXtKJkvNcBAHKr/8fa7D
YaD/+WVmQNzxEcEHm/sWwQfpN3gxF+w/P+kZDrDwB/tXcoYDAK0Kuqc=
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfdk3SeCG/zyHQ181YvpPTneYkSfUfADIt77v3zt9
53SHH8GPl84OhvDF1053OKKwoSgjep7DYaB6/iXTHW7/rMuySZ7nEGG55cS3
WdMdgnbItWbnzHPg0900N3/adId2sZvnvpch+AwgUIfgg8yXbpnnIBOVYh0/
Y7rDwyqRde6d8xwyJr6tsZ8z3cG5O+d5dd88hy0nyvbJL5juMAHo0DuTIPL7
l0HdMw0qv2G6Q+VLNUOOWfMcMkHyQPf2gzw2Y56DFw+TNvvi6RB/TZ4HsWfm
dAf51teBO7rnOVxQAvpkwnQHcHg0z3MwMTY23twOdX/lPAdtIMOvGaJfPA/B
B1mnk4jgg90RNs/h+e+VH4M6oPp9oP6bNN1h3vvlx047z3OYCvRY+hyI/Rb2
8xymgTy6EsGXBaq/vwvBB4fH2ekOR4H+feEMja/b0PDyhdh/7ul0h6WzgSES
Bo2vD9MdKoAO7EiC6v8KUX+8AI1fg+DrbJr7fnnbPAdVtsapzh+h4dsH9d/L
6Q7AaHuvDgxvoK+Ckx8iwhts/zUEH5aeAIEuJ1U=
      "], {{1939.961, 1524.077}, {
      1952.3829999999998`, 1524.077}, {1952.277, 1525.796}, {1952.07, 
      1527.007}, {1951.758, 1527.718}, {1951.277, 1528.812}, {1950.555, 
      1529.6709999999998`}, {1949.586, 1530.296}, {1948.617, 1530.921}, {
      1947.605, 1531.234}, {1946.555, 1531.234}, {1944.93, 1531.234}, {
      1943.477, 1530.6009999999999`}, {1942.195, 1529.3429999999998`}, {
      1940.914, 1528.081}, {1940.168, 1526.327}, {1939.961, 
      1524.077}}, CompressedData["
1:eJxlk21Ik1EUxx/8EBJRQpIRRm8UgURFQYREpyAkrIS+JBIUo0D6YkWYSVhB
ZG/aSuUW0RllrSLb1rbqSxhotJXh2xY6tc0921gmS6dY9KHoPPceuR8cjPv8
uPee8z//c+4qW9XB4zmGYeymv7W+Dla3OwIIflpXzAiY5b7Vw3/+jQhwlcRr
m3sRLpx4d2ZxRoBZm+8KRPT5ytuZ8zsTmmvG1m2+mtZs3c8fRyiqXxLpnhaw
b9u1XaMZhLPtjmUbswJseeXb/ZMIxbGyBvFTqHtTCHWUr2lcs1y/a5Z6UkLe
K8gi9JLeOlPAVP9+W94EQmHFseIjo8yUj1S4SqICTu6YP9D6A5XubwLoWKwn
rVnGS2k+R/XkmqwnqvI7orwfV/q3DiN0PdzzZjoh4Mn9Dys9g6reAynOP6D5
lJX/q2ZZTxhh74KcovqkAGqJcbGf/TcVGz2ofI8JKCX/jnZxvUO6XzJOSLPl
r9uhee28Sy2d9wSESE55kP1o4fo/cT131P7gZ45nZ7++IDymj0ONApxU3ybS
s3CD98HETaHi9iF0zKw/fOsG66f6lluBr7PeobksfbzC3DqXZ88XRLp/h55p
zm0rrEi2IUw+/Vj6lvJlyV+7W+mpahBAXVp6+RVCtVV/I5/3IvwN14w57Uq/
x8fz0cT98SNsoZ+vmefZz/7e1Wyt71GzvB/ULPWFuV9+7u8I++FjPVHeJ+4k
vxbFOb9X9SNg8vx4OF5C9afMzfOQVPMpXrLfKa7/hWZrvtY810zRTlc6EeiV
BX8ltb/yPSa4n484fprzd+j3+x+oyxhX
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQXfFSzbBDfL5DxsS3NfaiMxxg/ItKt3/++zjdwfq+
f+90A0x+JlD9/pfT4erR+eX75kvpL0Hw3y8/5m0+d7oD0EqGBon5Dr3T84Sa
Z0x3aBe7ea5car7D4a8aMfzToHyZ+Q5OCU8vLJo83aESqJ9Dfr4Dn+6mufmT
pjsAqffqSgj+rZ91WXtUEPzbQL6NOtS+yRD1yzXnO2iDDJ4y3eFH8OOl0jpQ
9UD7XLpznv/WhcoD3fOwSmSduz5E/v3s6Q5HFTYUvTBG8MH2G0LU+02Bqgfq
PwR0f38flK8x36EM6P/1XVC+MtT8Nqj9cvMdZKNSrO+3QOSPSyD4y2YfUTAQ
RfBfAb2/RhDKb53uIN/6OtCCD8pvn+4A9N2x01xQfud0SDxyQPy/vQcaX2xQ
/06AhO93lvkOjsDwVZoC9Q+Qv6TAluv6TAQf7J+FCD4sfsH2f56Hwd96Aujj
t9D4/T7P4fnvlR+D3k938DHvdHzwex4kPj5Nd7jsmyQQwQANv28Q/g0WqPt+
TXeYALT4DgdU/v90hyPA8M/ggYY/ywxI+PBB+ewzHJYC+RsE5jvIAP0fzzsD
El/CiPQMABkLWb0=
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQfftnXZYN02yHLSfK9s2/Ns1hwqGvGnf+zHIo3zdf
av3naQ4v1Qw51vya5ZA58W3N/v/THEzjdnn2APlTnbtz0hmnOwCp59VAfn3W
nhJhZgQ/A6SeBcGfBmJwTHfgWCMTlfJ7lsPpha7bPnNPdwDb/3eWg2xUivV9
3ukOP4IfL5X+P8vhxe+VHy/xT3f4eMk3aQLjbAftdrGb5wSmO3wHys9mQfDB
5rMj+GD3c86G6weZv4d7Ntz8Qluu64t5Z8PtB5vHN9sB6CrreE4EHxQe8mwI
/gUloEkM0yH6gPpvnvsenPwLGj48UPs/Q8KHhx0RngAXz7G5
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQPe/98mOn785y2HKibN/8a9Mc5gL53jcgfPkv0xzE
b577fvnaLAdjEPgzzeFH8OOl0kC+CZC7mXE6nA/Wz4Lgy0alWN/nmO7g0p3z
/DeQf3qh67bP3NMdbv2sy9pzAyrPO93BGShffWuWw4vfKz9e4p/uMOHQV407
d2Y5aLeL3TwnAOXfR/BV2BqnHn6E4C+bfUTB4ClCP9j+5wjzP13yTRJ4Octh
GsgioP2mcbs8eV7NcnhYJbLOnRPBv6h0++c/VgR/KlB9OvN0h5dqhhw6L6H8
v9McgnbItWY/h6r/PA2i/hEi/AA9la4v
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQ/bBKZJ2722wH2agU6/tHpznA+Ie+asT0z0PwDwP5
/NOmOci3vg60cJ/toMLWOPXwhGkO1vf9e8U9ZzuU7Zsvtb5vmsPWE0CW92wH
VZB89zQHPt1Nc/P9Zztot4vd9Oua5lDxUs2wIwTBB5m3IxKTvwVkTts0h8u+
SQI35DH5MPVHFTYUvVBB8HU2zX2/XAvBn54n1HxAb7bDvytAm3ug7jeE+rd/
mgMwCBgajGY7nF7ouu3zxGkOQOe+Vzee7bCkwJbr+jQEHxYeMD7I/HNfUfl+
/6Y5ZEx8W2MPNK8ua0/JZObpDiBl5QazIeHCOt3Bx7zT8YHubAdPHibtdo7p
DpXA8OAAuvei0u2f/zinw/0D48P8i84vB4U3L4QfEYjgB+2Qa82ORfBB4f8+
bTYkHnig5udC+O9h9pXMdoiwBIYw+3QHYOgdO101GxLvQPeD4nd6/WwHGWB4
xf+d5uANdH9Cy2yHU8DwKv4OSR/H26Dmf0DwweHxAo1/dxo4HuWbIeEbfgUa
n9VQ/Wch6Wk60D29oIg7Ns0BFE3+WdD0d3gaJLxiEfxHIPMjEXxw+IdB3Q/k
g8M/aLZDJlB8P5AP0r7GbzZE3ZFpDt+DHy+d7QWN/yOI9A7LDwB+n3Wc
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/bBKZJ2722yHQ181YvpPT3OISrG+f95ztsPNc9+D
H5+a5sCnu2nuex8IPxnIB3GX+892OAxUzw/kH1HYUJQRNNvhw/Jj3ttPTnO4
9bMua08I1DwgXwekPgzB/3jJN2lCLIJf8VLNsCN5tsN7oH7zM1B+BlT+IpSf
OxvijmvTHCqBfI6C2Q6yIIfeRfBlgPz4Zwi+MQi8gfonb7bD1hNl++Z/hLo3
Z7bDFhD/G1R91myHf1cqXi77DXVv2myHqc7dOen/pzmAwycJah/jdIejQP0v
YqH2sUx3CNoh1/o6Amo+63SHy75JAhHBCH67GDDk/BH8H8GPl872nu1wUen2
z39A/bDwz5z4tmY/83QHAP2FyUw=
      "], CompressedData["
1:eJxdkksoxFEUxicrC6GIIs/FULLQEGVzhDQJGRtJkiihlOS1QGka8lxwPI5H
I5rGwmM8krzyzpTGK4Y0JoRmMSEhJfc//6tbFrfbr3Pv+b7z3RtWVKkpcVMo
FEq2pD3aNOKMmCCwhF9/NW4gfObcTQYyNutTl97mEHZCZ6tKDQSP38YXjQGh
/lkZ4z5NsHhQsz42hjBJ7MQCASa3Vzz2I7CWiuZVgu33yHyvXgSdn/Wodlew
ZjlYW24W/MH0yEIQq1Kp5vt4/3OCY+bnZwDBkxmstBLYG3yn04YRXH5vuJ6e
8y1BUF5xos2IEKJ1ZCfccWZ+TzOKvC/t8v39UYRRp2HPfMPnRYREW1an/wXX
60JIj29LKmR+1B5uUTodQgqT+d4niJIGaUHYZXk8rQmW/DlNguMKVtQdRoKm
stVqn1bZz7KeYEHKq0ee3zFI8HNW96wc5PMiQVLhg2V8QrArn/l/9S3OQ1zv
iPM4wRY7333BeUquZ94ivJ6wANj7MPWAmXue16Zg1/seCh6R8jnh9+1yfrlW
3v+K+7dx/VORtyvfQ8F//+kXddI18g==
      "], {{1769.039, 1457.312}, {
      1779.6019999999999`, 1457.312}, {1779.516, 1458.781}, {
      1779.3439999999998`, 1459.812}, {1779.086, 1460.4060000000002`}, {
      1778.668, 1461.331}, {1778.047, 1462.062}, {1777.227, 
      1462.5929999999998`}, {1776.402, 1463.1239999999998`}, {1775.543, 
      1463.3899999999999`}, {1774.648, 1463.3899999999999`}, {1773.273, 
      1463.3899999999999`}, {1772.039, 1462.8509999999999`}, {
      1770.9450000000002`, 1461.781}, {1769.859, 1460.718}, {1769.227, 
      1459.226}, {1769.039, 1457.312}}, CompressedData["
1:eJxlk21Ik1EUx0eEiJRZjmm+5FszySzC+hASnbKICIryS0hUqJFEIJVoWBRB
b/iSme324T4iESFBWJSkhOyDRlqSbe5FRpqsGb1IubI5hyCde+8ZF3IwHn7c
85zz///PfbLKqg6fXGIymXbhXzwtvuFwSZwBfaG8o82TDKLcj7zCwWDowZ6X
MysNCHa82d89zuBznblzYLWuT8J6V5bm4oYzXy9aNfdWtyZfyzMgvuB5W1WA
QeyTtNLJ9QbU2ttTNvkZtE1j4wIDjmzrGpz9RPUbDbBho1Njmh3ZHyOXfZqZ
GORlcHZ73OhDfF+06XZT/3w1b3qEwffczbEbcN7OE18c2U4GcyWBR6mop7Ll
56Ud6K88ASdbNb/OfHauMkez0DeUaYCIpdxJ/dOV/qcupWdpKun30HmyAV2D
NfaMUdKbpFn6tWjejTbmzQa8w5zPo5/Ovf66e4l0jv3CqJcnUB7o5wIaurWc
/L3X+5J6BjTLc65ZPAKM9ol85XRvdWIrgzL0v2UZ5XtHzTdj/0L8vbjNoGji
YNP9eMWFTQzWxly19aMeJ9YvNDC4KQasMsAv7kW92keOhfaLbMX64pTFLPy1
3yC/U3wRR+ulvqBmue8ZrvZfT3mHOKSVVhQdb2Sw9dirfY1hrvJEvWuuTx3q
meOw4MbkmlV9RYQrvy0MMsR5hObfpX7I3+Yf/x6xaZb74Jrl+/b/zt8yELF3
IMv7/oH0Rxnvj8wJ9Yj7UuOi/aNeuRc3fU+zHNLRz4SH7meI9Hgpv78c8jH4
A9H79Uez2EdtULPQs+6X4mGvzleyh/gH5eej/cXo7/cf4Y0Quw==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQbRq3y7PHb46DbFSK9f3/0xxQ+A+nOUw49FXjTjIO
/i009Uj8zIlva/bPR/Bf/F758dLMaQ7e5p2OCf5Q/lSIPE8gVP3kaQ7T84Sa
DwTNcTAxNjbePHGaA5/uprnvQ+Y4lO2bL7V+wjSHH8GPl84OR/BB1p6PRPDB
6qPnOCwpsOUKB+p36c55/jsWKj9pmsOekskSLAlzHA5/1YjhnwI1L3GOQ33W
nhLhadMcbv2sy9qTNMchA+SeGdMcXqoZcqxJQ/DFbp77HpwC4dtPgro/EWpf
7zSHue+XHzsdAzW/C+r/iDkOKmyNUw+3TXMotOW6rgz0z5YTZfvkW6H2+yP4
Hy/5Jk3wQfDXuT+smuI5xyHCcsuJb61Q97jNcdgKlJ/fPs1hBii8nOc4PAeG
Z1AnVL3jHAdVkH3dEPU6DnMg4dIHdZ/dHAfr+/694pMg9kvbQc2fhuADozmm
fy6CD4vfVyD79TH55cDw1b8HDR/jOQ5OCU8vLLo/zeET0D8C5lD7HkHTjxXU
/KfTHJbOPqKwwQ4aXi+h9jnNcTAGgbdQvusch4tKt3/++zjN4TsovID+9+Rh
0m7/Ao0vjzkO/65UvFT7Oc3BGRjf1d6I9AwARUhqsg==
      "], CompressedData["
1:eJxlkn1IU1EYxodBf4RUWBSElQV9gEVFRIREb1mElUnzH4koWF+iMUVtWkgf
LNtkbG66nVk72wpXw4qUsBJZs/yooVH2hdn8yPrDImJI9CFC9N573supvHC5
/O655znP+9xniaFIfzRJp9Ntw1t5vso2zH4b4bBw/5GMkVEGGnd8X3mg5oZk
u9eYMu0Kg4yRHPv8B7R+SbAXuTwaXLDGS+tRDqHizTP63Qz2bKze+h55vXLV
MbDMG3j2s51Dvutr5ZZaBhsOtmUlP+IwNtk4rncxUGzkdJAfJ4MPp+feftIp
2YkHD3ZLvu7rSlsb4zBz9R1/Ee4fVb7vIX+oj68TK55y6ESeVcOgO6255FMz
h3TFiJlBF3L+ramszTP+MtvgDHEwITc5aN4A+a0W85Rf5tASM0UXW0ReeYyD
vnVR1ZcLDLbbToxNuv7Tt0tW/O60SlbzNnMwppgf7qqiPM9RXlbSr6Q8bQzi
E2cKIqc4vFgan/jtIL0KDnfRT7BO5PncxMX7etIzUX4ByanIh8KS1Xn6JPdc
3XGv9DUTuicp734GOOW+1jLKd4BBIBF+3FvKAR+7779jag6FJdSfQcqvWOxP
IHuVQY3UlyEmdAs5LJt+3pM5zGAVfhY+Rv/jL9b6qvLFqazmGfqX93Im5rKS
P0bz2ci/m/ro4IAtzT2MffqV+/Gaz0XrWh89klX9eslq330cejGvb07qR1D8
v/ZaOq+BQ1ZyUrrFTX0Ic8jb1BL74ZX9U/X8ktX9fZJZJhbrDeV1k4MH+Tjm
X/F5+TprI/UlLvofRv2zBZGyOUPUlwbSH6Z5/DJfjbU8/wD4NQv/
      "], CompressedData["
1:eJxlk39ojHEcx4/82PzYzsgffpsshUYjCfnMj6SF2v6RxLoRjVyiESIJ2cbd
cN/UfR/LH0itKRbSumSycbnd7/XYc7Ru4tLcbmy36+zyeZ7v53xjTz09vb6f
z/P5vj+f9/e70GItPzjWZDJtwlf/lr+Yd/l7H4fXg0v22noZZLkNOd/LYPW+
l9vrBzn0P3xb9jzCoGzNtdLKkX/zj4xX/nLztp4zM3IlD1dE78+eokDe8ieK
Ncpgc93Rr2fzFDjlapxV3MMgp2nOnl6zArvXtnQMfaL8AgUcmHhIk+wt7E6d
VyUzvVCYAa5Wr5+mQFzXF6T6+WK/uJ/B4gkXHW1TFSit/OIt9DGoMuNOkxU4
3NB3biP2p+g/5ko26c9Eybq+A+MUUD3Jiiof1R8j9D8OMEiiHmeGC/0hiv/m
0NJR45rfRXrTko1+U5L1ed0e5vD+3tZnJ7CfWNHKnGVJimM9C+pd9YuLeWA/
xnqCi/4+SL8MPe2SjbhTsq4/ysjPHxwuVLeenH6LwV3s3x3nYr52sX9TP4cS
fJ7eYPDA+WbBigHBJdcZ2HRjUY8P8zN1DBL+HRb7EAd0vbm9VvjRmhJ6ipHt
mK+NjGa9j8Yr1G/naM7mG/oCkg2/u7jwv5bmrXJAl9btr2dwfMOkrkXdNE/U
i8ufd2kcMsHTsSIbgy2Yn9ao3waKR2j/m1QP+Vv6UcLvkGzM3SnZ+N/1X/wd
E+cmIuZv7RTny60R++j+aOK81ATIf9TrRr0/g3SfPnKYqwsL0flUSU+Y5of9
L706U92ZPV9hyQPohzko+c6xgkuvfII9YTlfg0PEHpqfSv7F5P3+A4gDJcw=

      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQXWDLdX2xwVyHLSfK9slfmubQLnbzXLnlXIepzt05
6femObh05zz/7TTX4dBXjZj+J9MckgQiLE18Efx17g+rpoQh+Ld+1mXtiYPy
H0xzSAaq35IK5d+A6N+SA+VfgJpXMNdhK9D++UcR/MyJb2v2b0fwPXmYtNuX
T3MQv3nu++WsuQ5AU06UzYLYL5IANW8CVB7onsNAPn/HNIeKl2qGHT5zHbRB
HmuGmueI4E8AarxjjeCfWui6rdhsrgPQ1HXHW6Y5nAbyPwPDB+g6qfVt0xyA
wfK8Wnuug2PC0wuLgOYfVdhQ9EIV6r5uqPkKcx1kolKs4/sRfD7dTXPfv0Xw
Vdkapzr/gJovDwn/+f+g9gP5F5Vu//zHMB0iLweND+bpDiBj1OWg/mOdDvG/
LNR8IL8S6F8OGah/2KY7yLW+DtwhNdchAxie9uzTHQqB8a0sieCD3SGO4Aft
AOoQmetgDASb2aDqhaDxAzRfBaj+sAA0vXBC5XWg+kWmO8DSE4wPAC8SE+0=

      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQXWDLdX2xwVyHzIlva/afnuYA45fvmy+lP3Waw56S
yRIsJnMdloAkJkL4LeZzHZ7/XvkxqH+aQyFQWNl6rsPWE2X75vdOc1Bha5x6
2G6uw+mFrts+d09zaBe7ea7caa7DFqC8PJCvCpR3dkPw575ffszbB8EP2iHX
+jpwrgOf7qa5+X1Q88PnOhz+qhHDD3TPZd8kgYgYiPvWz54GsScO4r7wpQg+
WP0mBP8D0JrtexH6jYFg8zGE+ReVbv/8dwZh/8MqkXXul6H+94G659o0B441
MlEprgg+yLwbjgg+0Lvfg4H+9+Rh0m6/Os1BHMi/bAUNX6B5QGXv1S3mOkx1
7s5JvwQNLxOo/HlE+MPiAwAm1sdh
      "], CompressedData["
1:eJxVlHtIk1EYxodESUhJRUZFV5LAoqJCwqI3LMKsBP2jC1EhRRcji8SiQjM3
dd7mnDsqedKyZhcztWVWpuXU1kRN10XT1DQwiRCLqJCk93znHYcGY/z2fd85
z/Oc5/0WRkaHH/bS6XR78Ct+u//EHa+p4HDM/O1inYWBqf7n0n23OIT4eAUk
pzMITjsxdOE6h7l7DwUdSGHwO2Lw5pwiDkfx/o3JDGpiLLP0BRyC+sIycg0M
In13r7Pnyet1egbD/qu8S3MUz+xq/RWRqdjujK2db+Qg/h5MYrB2/5MQHwOH
s7WFs1ekMWi+tqXqxyUOGbknpyWaGIRXzzN8jeOwWnysijU9Bf9ff1BEHM9B
2DLdIE7gEJCMSkpIn17yzlIG3qXo1Ej+y8lvFofXizApO4MsXKiHEVcz+N6x
I9IX87lxasPkXc8YePJ04H5THYpj0c/9JsVLJiZYHW0M+EhJU2g5h3Zcb/yt
1Bd1j/Luknmk3+Hw6fyMspc9lJ+N9u+VzzcXKRZ5FhYoxmX6wvJpvY9Kv5Z7
N13H8/kydnu0o5Pyt3AQsgLfKdbycUv96y2UZ4tiPHVnrIuBC8/rTLbsg5+T
8sb8piyv5NHoPzTQuOmgifJvID8Z5N9BflIVa9dTFGt6k2Te7/H5DyJPPenB
9W1XGhasTCS9tH/UZQ5/35wbtrkUPxQ5tSgeQv/hbtoP+4erxlg6ZT+Wpan8
tDzMHMZxPf8BJnuXT/t/ZnBV6C9WvB399t9VrM1LJfV3kPrwiM6rn8FptFX8
lIMVB+9IL91fS/PQTfP5nPLD8xnF/mW9kPmOuElvPYd41D+9VbGms1Gxlo9N
sTa/nPzXy34G59F8eO5nDHTi46C+51A/kbfhvEyyUJ8bKK9sBmVbsbmNHNaI
eTQz2Izvk7FGuu7hJsXC7wSnYs2Xk/SZKa9XNF/ZMq/FzeQf2Q/1u1voeSud
RztxvmLP+07ro4vDgJgvI5O+HZSvnt5/NYq1vj9WLGpYXEX7G6iPdjqvFNnX
tkqaj1TiCupbpnofePT8A5Hi0AY=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQfftnXdaejXMdMia+rbGfNc0Bxr+odPvnvz1Q/vK5
Dl48TNrsO6dB1C2c6/B++TFv823THOaCGPPmOhz6qhHTv2Wag2ncLk+emXMd
nBKeXli0ESo/da4D0JSSyeug8pPnOshEpVjHr4bIn54w18EYBFZMc3ilZsix
ph9i/vYlCD6f7qa57xcg+I5A85XmTHNY5/6wSmTiXId/Vypeqs2Y5hC0Q671
9WSo+6dAzZ8210EWaN/9iVD1s+Y6aLeL3fSbMM1hHkh+LoLvY97p+GARgg90
tUTLyrkOW0+U7Zs/GRE+sPACAEekpco=
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQfdk3SSDi81wH2agU6/v/pzmg8B9Oc9DZNPf9co55
2Pm30NQj8TMnvq3ZPx/Bf/F75cdLM6c5vFQz5ND5AuVPhcjf+ApVP3mag2nc
Ls+e73MdTIyNjTdPnOZw+2dd1p6fcx3K9s2XWj9hmsMRhQ1FGX8Q/O/Bj5fO
/ofg3wKpZ5jnsKTAliscqP9hlci640zzIPKTpjmAnHmeZZ7D4a8aMfxToOax
zXOoz9pTIjxtmkMF0IEd7PMcMkDumTHNoV3s5rlybgR/y4myffKcEL79JKj7
WaH29U5zsL7v3zudEWp+F9T/f+c6qLA1Tj3cNs2BTxcYgD/mQsxphdr/BcHv
PwTU+BHB9zbvdEx4N9chwnLLiW+tUPe8nuuwFSg/vx0aXi/mOjwHhmdQJ1T9
s7kOqiD7uiHqvz+ZC7G3D+q+x3PBtDjQ/UeB9r94BDV/GoIPckb/XAQfFr9g
+69g8suB4at/Dxo+N+Y6OCU8vbDo/jSHCUCD7tyG2vdomgPIGcvvQ81/Os3B
uTvneTXQPeDwegm1D+h+YxB4C+W/nOtwUen2z38foeEF9L8nD5N2+xdofL2d
6/DvCpD1ExLf7h8Q6RkAJyF51A==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLX7z3PfLGvMcMia+rbEXme7wI/jx0tnaCL5Ld87z
37rzHFTZGqc6C093OL3Qddtn/XkO2u1iN/0EpzscVdhQ9MJwnsOSAluucP7p
DhxrZKKeGM1ziLDccuIbD4Jfvm++lD4Xgg+0NjiZHaH/otLtn/9YEOaD+UwI
+714mLTZGRHuO/xVI4afYboDzP0wfuVLNUMONQS/0Jbr+mJlhH4wXxFh/iug
8jXyCPuTBIAul0O4D8aHuR/Gh/kPph/mf5j5sPCxvu/fO10ZEX5g/6giwhc9
/AFZla+U
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQXWjLdV3ZcJ7Doa8aMf1PpjnA+BkT39bYz0bwPXmY
tNunTnOoeKlm2AHkf1h+zHv7xGkOYjfPfQ82mueg3Q5k9U9z0N0097268TwH
PhCjd5oDxxqZqBSTeQ690/OEmnumOewpmSzBYga1r3uawys1Q4415vMcHBOe
XljUNc1BB6htudU8h/J986X0gfzTC123fbbD5G85UbZvfts0hwKg+xYLYfJh
6q3v+/eKiyP469wfVolIQdVD+VOk5zlcULr9sw7onh/Bj5dKy85zALraOr4H
6j+5eQ6PqkTWHQf6J0kgwtJEfp5DJjB89vdD1StA+ROh5gH5dVlAn05F8GHh
CeODwid/H4IPCj+/E9McgK5b5w7kGwPB5nPTHJKB9m0B2rcV5N6L0xyArsyy
gdl/GRKeLUD3vQfGh/lVKB/o/sPA8OW/BuXLzHMAeePxNWh8SkPtuw6NH0kE
3zRul2ePOII/F2SwKDR+ryHCF8wH2qfK1jjVWRAaXjenOagA+Yd1EOkJAN5Y
G1o=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/emSb5JA+TyHQ181YvqfTHPgWCMT9aQFwW8Xu3nu
e/88B20gw+/+NIeoFOv7/jMg/HNXpjnw6W6amz9/nsOSAluu66enOTCAwGKo
/oMIPkjd+60Ivipb49TDa6c5VL5UM+RYOM/hgtLtn3VLpzlsOVG2T37uPCg9
zSFJIMLSZOY8h4yJb2v2T4HYf34yxLz8Poj973vmOZTvmy+l3zXNAeyfNqh9
rRD/pNRB3dsMVV+K4Mu3vg60yEDwwf6LnefwsEpknXvnNIdls48oGIRC7LcH
2n8ZaHyEH9S9c6Hmec1zkAVpXI7gA221jt+M4JsYGxtv3g31v+88h4tA/f8O
Q/0bCDX/zDSIvUD7PHmYtNuB4Ts9T6j5QNQ8h79XKl4uuwXR35AICZ/596Dq
ge6vy9pTMvkRJL7K8xHxhx6/AP1T5mQ=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQYl8xwOf9WI4b83zeHUQtdtxQUI/lGFDUUvcuY5
9E7PE2K+O83B27zTMSFzngOf7qa5729NcxC/ee775dR5DksKbLmu35jmcBqo
/3PSPIfyffOl9K9OcwBqaz6QAFV/fppDxUs1w464eQ5lQPn1p6aBxfNjofKH
EXyQ/vW7UeXz101zWOf+sEoEaN5Fpds//y2Cugdov0xUinX8zGkOOkBjlmfN
c8ic+LZmf/80h60ngDYVQs3vmuaQARS3r0LwkwQiLLc0IPh7SiZLsLTNc6jL
ArJ6pzksm31EwaBrnoMs0Pz7k6Y5XPYF6uib52AMAjOg7pswz+H575UfgxYi
+GB71iH44HDdBw2fHqj+09McwOEPtO8C0D91V6Y5AH23zr0Rat8tKL8aER/o
8QUAAxXQ8g==
      "], CompressedData["
1:eJxllG1sS1EYx6tkWRAE8WFeNhIvyQgiEomIR0ZkEWT1RUSQhZgRFcQQISIz
WdtURc8+LM4NwSJCMapqNllma1aqXdfuLWHWidJMjXhdjOee89wc0ibt7S/n
3Oc8z///v3dmsdWyy2wymSz41a8VU7pCZUEOJa6BEysjDO4HjtTnxrm8vmKw
Zefy1xt7OTR+nbfV2c/g2Ps5i7M/KF5t2/du6KNiUecLh3wsvCHBILq+eELn
N8mhXgYW34zyvb9oHeu/OT759trfHJbon24GTXl3Dpb84RCe1fPzZDuDZ8hJ
kwaFY835FWEGC+5dSteM0GAc/rG2Ki6r13IWNioWfVQrbr28xnvIzeDHpsS1
qWaq56J5RmryPCcD/C2tQ04O3Rhsc9D5ozRwVO2feMbO4CjuP5elyXltsv7c
bA1W7XgbvlLJQC83fwz1g4zqOarGZ7Kur3aWgdC/j2ewsV/Xb3M////+pOKl
2/yF9hSX/SLnlqeKlg2Qf3apdwr9EfM7aP5PHKahsdudUv8W5Om60ajH5zY8
cJD4AtVDjqA+w27Fhr4Gi/6fKmYFGIwA5Qnr636lQ3K+79gf7s7xtDHg6Zrm
YEquW+OkZ5Ly0Un+JBSL9R7F6G7zuij1FyX9gjRfULHRr8GnSusOT3LLfL9E
np112l3gIn+fU15RH9HXCw5XD6wY3YH6oZpFvhAHN863207+hCmvNpovQnpU
Ur5jyi/B3Zls+C/mu5XJxn7BHsV9un+1ikVevTS/jebxcdiD8zdg/9erm/IW
+Skf50nfx3TeRcWGXv+u5z5RLPQLUH78cn9DiOYx6keov0dcPm/oj0n/IA+3
Y2cx0ush+RejvHopf3HK9wPyu4PeJ7WKxf13FYvn10P+xZV+gmP0PrhJ+nTR
eot6fxn5MPgvhaCYuQ==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQzae7ae77lPkOslEp1vf/T3NA4T+c5pAx8W2NfRUO
/i009Uj8TKC6/fMR/Be/V368NHOagypb49TDqVD+VIh8fjpU/eRpDoW2XNeV
M+c7mBgbG2+eOM1B7Oa578HZ8x3K9s2XWj9hmgMDCOQh+EkCEZYmBQg+WH3R
fIclBbZc4UD93uadjgklUPlJ0xyOKGwoyiib73D4q0YM/xSoeRXzHeqz9pQI
T5vmsOVE2T75yvlgf+6fMc3h0yXfJIFaBF+u9XXgjioI334S1P3lUPt6pzks
m31EwaAYan4X1P9A96qA/N02zaHipZphR9Z8iD2tUPvTEPzTC123fU5C8NtB
Hoqf7xBhueXEt1aoe2LnO2wFys9vh4ZX1HyH58DwDOqEqg+fDwnn7mkOH4Hq
J4TNh7ijD+q+0PkO1vf9e8UnQexvCIGaPw3BPwR0f/9cBB8Wv2D73TD55cDw
1b83zUEeFD6e8x2cEp5eWHR/msMpoH+KfaH2PYKmn0Co+U+nOaxzf1glEgoN
r5dQ+yLmOxiDwFsoP3q+w0Wl2z//fYSGF9D/njxM2u1foPEFDJ9/V4Ah+3Oa
gw8wvh8kItIzADDTU7o=
      "], CompressedData["
1:eJxllHtI01EUx4floxgVJRn2fkmgUTFDwqJjFmEWgf4T0kPEqCySSCoqtLI0
91BX7q4QvSiZPYZWmogOn2WPkc05nVqWZlEWIhKRIkjn9/udXxfZH2N8ds/O
43u+965MSo076qPRaA7hR/refLguRlvM4bh55PL2QCuo3PJn3cG8DgZxtctu
nCzjsCPxm7O0lylxjzn8mHw45vrE5HhjJYfq1+calg8y2BuREzVQxcESbTh1
bIjB/cIXKzbWUr6vDPDn75fsgqXzJ82Cz2yb7VndRvnw//l48PEN9TfAYMy1
Lyn/HeXvZ5CQHPl5v5PDnPXPikZ7GIzHD5UtdnEIzV7Y2+5iEGBbkpDcSfnb
lX61bg6DFwMrXrUJdq76MJFeL1iuVyj4bcmumrMWBiiZ5ooabyZ9ujhglcgj
eQwqdmPmbg5fpPwmBknzDmwJ93AwWU/PzzQyKBotb3P0UD8GBrGoV2IfhyhJ
X71yHtvP4XwDD96gJ30HvVnSh2cx6JtIT7FXe7MaL+tXI1jWp356Pm0D7RP5
Z8imAFsj6Y/9oop/45tpfhPN3yLmHcb4sFYOS6VFmGkeZAfG/75F+0bOSLGn
LWCCVX1VVvVXWa73kil5sF4Hnk85FL1/NVN/74mbKB/ue63fVUs09o8qpN12
M9iJ+SbtFN9N+tRxCNfpdFUeBhi1aGYt1e8hvaoFS3oVPhUs77OCw3NJb48y
v+0Rzd9FepRzmHJfGA5xU/+lHDA6uNLJ/t8vya+pDsHT/FZM8xaQnsjoclOQ
mc45+Qf1v4O2akJuRZ6bS+cl5G8j6YP1T2D+RvRbEO6z8x4HnTQ/7lvW5YHw
g+xPmzer/pL9l+HNarzk/4JMwWtwH61Zwl+y/3KEv2Qd9KJf2V8GDnu0PqH+
uXQfjKSver9MNI+Z/IIcg/HZFsHT/GWi92BEsJQ2YpwBbjVlq4nmmSJ/GEl/
jVU5N9J7M8Oq+NJAevtalfuvp/dH5Ryq50fv6U3qx9+qzJMlWN7PdcGyn67R
fuj/kr6y33yV87B00m8W1bsr3u9/nq/pGw==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfXqh67bPP+Y7XFC6/bNu/zSHowobil4A+WDxjdMc
kgQiLE3+zHd4/nvlx6Dl0xy6c57/zmRc4LD1RNm++fOnOSwGKtvLssBhmjNQ
Zvo0h/Pfgx8v5VjgcPirRgz/lGkOQs0HTinyIvgTDn3VkBFA8JOB5m8RWuBg
YmxsvHnqNIceoPkvRRY4XAS659+MaQ7vauxN5cQXODysElnnPmeaw1OQQyWg
9i2E8CulFjjIRqVY3185zSFulycPkwyUD3TvDrnW14HSEP3H501zmPt++TFv
yQUQ/06b5sAaxqf7SRRqX980h9LJEizTgO4BmqLd3j7NodCW63oy3wIH7Xax
m+eapzkYcqyRieJE8EHuu8eM4F/2BYbYv/kO9Vl7SoQ7pjnsKZks0fJtvsMW
UHhNmOYAcs6Od/Md/l2peKk2c5qD+M1z3y+/mu/gmPD0wqIlCD44fDajyR+C
8oH6wfadg/KB5gODNab/OpT/DyLv92CagwfQ43nA+AHaLrX+CTS8uBB8I6B/
ZvEj+POA4XNaGOIfv4fTHHYCHSwIDH+w+bemOfSDGFJQ/15GhDc4fE8h+LD0
BACH5TMO
      "], {{2046.238, 1457.312}, {2056.8010000000004`, 1457.312}, {
      2056.715, 1458.781}, {2056.543, 1459.812}, {2056.285, 
      1460.4060000000002`}, {2055.867, 1461.331}, {2055.2459999999996`, 
      1462.062}, {2054.426, 1462.5929999999998`}, {2053.602, 
      1463.1239999999998`}, {2052.7419999999997`, 1463.3899999999999`}, {
      2051.848, 1463.3899999999999`}, {2050.4730000000004`, 
      1463.3899999999999`}, {2049.238, 1462.8509999999999`}, {2048.145, 
      1461.781}, {2047.059, 1460.718}, {2046.4260000000002`, 1459.226}, {
      2046.238, 1457.312}}, CompressedData["
1:eJxTTMoPSmViYGCQB2IQXfFSzbDDYoHDoa8aMf1PpjmwhPHpFtkj+C7dOc9/
uyxw0G4Xu+l3f5qD7qa579U9IfxzV6Y5dACp7T4LHJYU2HJdPz3NAWgkQ4Mf
VP9BBJ8PpHErgq/K1jj18NppDntKJku0+C5wuKB0+2fd0mkOUSnW9/u9Fzhs
OVG2T37uNAcjjjUys4D2ZUx8W7N/yjQHPaAxz90g5uX3TXMAOaPceYFD+b75
Uvpd0xwqgf7hcIDa1wrxj5EN1L3NEPXfzRH8CUCHyhgi+CBty7UXODysElnn
3jnN4bJvksAMdYj99kD7QcbrqEDdOxdqv9ICB1mQw5cj+DJAfvxmBN/E2Nh4
826o/5UXOFwE6v93GOpfVaj5Z6Y5FAKDcTHQPk8eJu12YPh6m3c6JmgtcPh7
peLlslvTHBiB+g/oQsJn/j2IemWg++uygCH5CBJfu00Q8YcevwAZo+F/
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQbmCxwOf9WI4b83zeHZBaXblqYIfpJAhGWJ8QKH
3ul5Qsx3pzksm31EYYPhAgc+3U1z39+a5tCT8/z3S/0FDksKbLmu35jm8BSo
v1JvgUP5vvlS+lenOXibdzom6ELVn5/msLdksoSLzgKHMqD8+lPTHDrEbp7b
rg2VP4zgg/Sv340qn79umsP1xUCLgOZdVLr9898iqHuA9stEpVjHz5zmAFT+
PdhogUPmxLc1+/unOQCF7583hZrfNc1hy4myffJWCL4hxxqZKFsEP26XJw+T
wwKHuqw9JZN7pzlc9k0SkHBa4CALMmjSNIeXaoYcOi4LHIxBYMY0h3agheau
Cxye/175MWghgp8BtN9+HYJ/aqHrtuJ90PBxhuo/Pc0BHP5A+4DCP+uuTHMo
BAbjYluofbegfCtEfKDHFwCHosv0
      "], CompressedData["
1:eJxlk21Ik1EUx5/CD1FQgbFGGJWBFFEhFiEhHXuBQOyDZs0hNfZozjWctmkR
vXyJoq2aNrwEw3zqQyMIixr1QR1Rolaom3tjZIYssYJYERVhSec+94wLORh7
frv3Off//59zN1idVQ2LFUXZi1/+O+D2GwetGrz4sanO94FBjl8ir4gwMKTH
fvlPaPA1OFTx7B2DOweefj9vl/v7cf+lZsmxSutKU4vkDnyYbNVg+dbH3c4M
g9vZ4NAylwanwz1rtk8zQAkKuDUwlYZGfk7RfuSufV5H46TkSOHb3xfSkhmu
zyYZfC4qXuJAznJ9cVHf6xLnZScY3AsMrn90SoNyy0ykMMqA/x1EPbbOL+f2
oD9UW+pukfzn/reJSqdkrk9BfxhDtRql+g6h/2FM6Ck4SfoT5A/zCY20h9el
GPh4EE2SF2G55zbJPC8j8msM1oV+WsuWptRGWsd621DvbAPlgX5Q1c5j9eRv
VPZL1zMsWV8PSOb6M4zBanzIVzW4aO935/sZqOg/pFK+HeL8jVi/BD9PbjAY
x9dmiEuuM9iPsc+hnijun/cyaPMb8wyod/rsqt5hj+jHAxv11yP299kXMvfX
c5n8Vi/k3H5dX41kvd9Hqf8e6odJgwJz/e7j1xhU7LpabqmlPFHv5jrsAPJ8
/MynIh+Dbj4oZvLbKdbbzHT+TaqH/HEOB6FLst6PgGT9/fB/668YHMQgms00
7+NivnbkGOfnLt6fv7ViXtpjov+3kN/wixUX9ykPeS36eZ+g+TSRniTlh/63
XDGkD6XoPhyRzPuRrJHM9fQeFjyWlPnqnBCcqaL80tQ/i7y//wCd2RHW
      
      "], CompressedData["
1:eJxllA9IU1EUxoeVRIiFhYmZpWRUYkIhESGeiigLCxMq1MyskemYQs7p2qY5
naiIiHQtNb06NYIoiIqUstCIsFKXok6dIWERkfYHkaCk894942IOtvHj3XvP
ud/3nReSlnVS66XRaOLxq/xviHRv8TZw2Jh4cd+HKQZ/7vx4H1e+lI1dTYGR
kwxaDj3+FV0m2YH8rFTyjDkmqtHOIdbHK7zULXiyhEN69TdzzAQDP9uL3hDk
N824cYyBUv9VMYfW7OhVp12SfSMe3MoakRxe6u/qG2KgtHUC9+9WPk4G/fMJ
H7VY7+Hr3K6mtwwCcb29mriRwY7kqu5H9Rx65rYlr8b1I47s6KMNHMK8r13v
GWRgqAlYzpB7sZ8rw5KV/ZtckqdM6+4dxn6343mGBrrvuOCoBuqPeA7rVdbq
/WwTol45ckHG05y1bnpex2EgdPy31U3915EeyHjt2Us3F+v9t3Ype/xR+htu
X8qe9btW3g2qaxN6ztL5t1s5uPrmEy646TwHh27Upwr7fRJc8jXeQfrgfQbj
0tbcaJH3V/Lwrpn0GWWQ0hnrU4S8MJT3ZSv6teKUb8RPzgFdqqwdEv4Hc/Jz
gPyp5BCE/Z4zMPiEQnRUcMByByt0DI7tKdufWkb30ZLedlp/XvhfZaPnyZSP
QvI7Udzf3ypZ7dMsWe3XxOEy5vF5EuU5n4MT/Vg4S3oYKa+pDPA3KsUo8jmS
Jlndr5Ws9p/OoAP1cyLrlaBn0Hzkkd860h/rdSoDomewE/mzieojKzGwmCWr
+lsWc0AB+aGnfgspfzqa1yLiTLq/TfDxTNLzfy6WrOYV5yt1eiA0SUfzYyf/
9CKv0zjvWH3KlE39oF9n9mKlHPm+UP0ySb/VPJaL/WEWmsd+wW1mkZf1TnHe
6FUOB7CBlkHSD/VB9wLv43wewYvP5Iv5Wobzia8wDSBbcb5qxqjfPKqP+W2v
f7n5u5Hme4Ke58r8e95/nnn5B46FgiI=
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQ3SF289z2Iwsctpwo2zf/2jSHypdqhhyHFjiU75sv
tf7zNIdls48ofDiwwCFz4tua/f+nOfiYdzo+APKnOnfnpDNOd7jsmyRwA8iv
z9pTIsyM4GeA1LMg+NOA6p9zTHeY+375Me+DCxxOL3Td9pl7ukM70H5zoH2y
USnW93mnO+humvte/fAChxe/V368xD/dQbj5wKlEoPu0QQoFpjvoAeWfH0Xw
QeZHHEfwK4Du7ziB0A8SLj+JMP8V0Hs5pxD2g80D8mWA8vGcCD4oPOTZEPwL
Srd/1jFMdwAa930ykA+kgpN/QcPnJNR+YHiB9R1HhCcAieW4GQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQINmxY4bDlRtm/+tWkOjED+gfUQvvyXaQ57SiZL
sAD5xiDwZ5qD7qa575evW+BgAuRuZpwO54P1syD4slEp1vc5pjtc9k0SkADq
P73Qddtn7ukO7WI3z31fD5Xnhcjf2LDA4cXvlR8v8U93qHypZsgBdI82SKHA
dIcKIL9jM4Lv0p3z/PcWBJ8ljE/XaBtCP8h+9e0I84WaD5xS3LHAYZozUCPQ
/q0gdwL5D6tE1rlzIvgXlW7//MeK4E8Fqk9nnu6wbPYRBQMY/+80B5Cx/tuh
6j9Pg6jfggg/AA2opiE=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1,
       4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
      0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 
      1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQAmIQ3X/oq0aM6EyHLSfK9s1vm+oA42u3i93065rqELRD
rjVbCsEHqZNXQPCXzT6iYKAy08Ex4ekFpZ6pDt+DHy+drQaRP9c/1eHTJd8k
AY2ZDhGWW058mzjVYe775cdOA/k3zwFVTkPwQdb2z0Pwwfq/IvhAytv831SH
CUCFd9RnOlxQuv2zjnmag0t3zvPfqjMdtoLczzrNgWONTFSK8kwHTx4m7XaO
aQ6mcbs8e+RnOlwEqv/HOQ3uHxgf5l90fvm++VLreaF8HwR/T8lkiZYEBB/s
nnyIf5K5oeqroO5ng7jnSQvU/UzTHLzNOx0Temc61GUBTfo11WEeyH+TZzrI
RqVY338/1SFJIMLSZNZMB2MQeAoN/7lQ+Rto/FMIfj3QPOEdUx2Sgfq3TJ/p
AAwF6/gVkPDz7pnpkDnxbc3+2VMdTi103VZcP9Ph35WKl8t6pzrw6W6a+z4b
Ef/AUM3aE4jgAwBcQAtk
      "], CompressedData["
1:eJxTTMoPSmViYGAQBmIQHbRDrvW19UwHmagU6/gJUx3Ebp77Huwy08GTh0m7
vW+qA8caoIz3TIetJ8r2ze+d6vAj+PFS6UAEf0/JZImWBAR/7vvlx7xzZzr0
Ts8TYp481QFkfnb5TAftdqDJc6c6rHN/WDWlcaaDY8LTC4tWTHV4qWbIsaZt
psPz3ys/Bm1H8GWB7rl/EsEHu+cOQn/GxLc19q8R5l9Uuv3z31eE/SD5/QzT
IOqA7tsCdJ882zSIfACCD/avF4JvGrfLs8d5psO/KxUv1VinOcDCB2wO8zQH
APNrlKQ=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ3X/oq0bM/pkOfLqb5r6fOdXBuTvnefUhBP9H8OOl
0kdnOiwpsOW6PmOqw+2fdVk2x2c6lO2bL7V+2lQHsP6TMx1AVP+UqQ5BO+Ra
s0/NdDi90HXb54kIvmxUivX9PgT/xe+VHy91T3UQu3nuezBQ//vlx7zNO6c6
vFQz5NABmn8YaB5/+1QHBhAA2j8N5LCWqQ4ca2SiUoDu024H6myG2r8fwQdZ
478HwU8WiLDcshOh3zRul2fPdoT5QEsdE7Yi7J8LYmxBuA/Gh7kfxr+odPvn
v4kI/VtOAENkCsL8jIlva/ZPQ9gP1j8D4T5Y+KKHPwAlNsoP
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQvadkskRL1iyHQ181YvpPT3W47JskcKMYyj8J5VfN
cpCJSrGOPzbVAay+fpbDRaXbP/8dnOrQLnbz3PfWWQ6yQPn7u6c6JAlEWJp0
znIAigYnb0HwweatRvCXFNhyXV8y1WGd+8MqkfZZDlOdu3PS5011EAdqvNw0
yyFj4tsa+xkQ+Sl1sxy2nCjbJz9pqsOtn3VZeypmOTglPL2wqHeqA8j64MJZ
Dtogh3RNdTiqsKHoReYsh97peULMHVMdrO/7906Pg+if3zbVgWMN0Cf+CH4h
0BmL+TH5IPP8uiDu3SKC4PeDPCKF4AftkGvNlpsFtke8B2L+E4VZDuX75kut
74fKK0HdMwnqf+VZDkBTT3ybhuCDw2cegg/2z1cE3xHoX6V/Ux3kW18HWihB
w4t5moMqW+NUZ6B9W0HuZ53m8ErNkGON7CwHTx4m7XaOaZDwlITGF+c0uH9g
fJh/0flg9/NOA8c3ixeCD/LP6xAEX3fT3PfLYyHx/ZgHYr5JCjR8uCHy6nmz
HPhADA6Iew+XznIwBoLNLFDzq6HhD/Qf2D8NUPf/gIZnE5T/EcEH+/clgg9O
f4+g6acBGn53oPFXA7E///pUB6Arl86ugMbXpakOpnG7PHuKoOF7Dpq+kfID
APd9bYQ=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLXbz3Pdgs1kOfLqb5r6/MNXhYZXIuuMWsxwiLLec
KAPy17k/rJpiPcsByNsnD+QnCQBl7GY5yEalWN8/P9VhwqGvGnccZzn8u1Lx
chmQf9kXqMJ1lgNQOKYfyC+05bqu7Ingz32//NjpIAQfZL5I1CwH6/v+vdOB
5p9e6Lrtc9wsh7J986XWX4KanzzLQYWtcerhK1MdfgQ/Xjo7fRZE3XWIe0yy
ZjlkTHxbY38H6v6cWQ51WXtKJj+Amp83y0G7Xeym31MEH+Tf/FcI/pICW67w
TxD33wCaVw/UL/xzqgPHGpmolBSI/+f/m+rQDgqw2FkOxiDAMg0SPiGzHC4q
3f75j20axD0eCD5Y3hHBB7sfGJ6qQP84A/mw8Ae57xzQPACB5McY
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLXbz3Pdgs1kOMlEp1vETpjq4dOc8/207y6Eua0/J
5L6pDtb3/Xunu85yKN83X2p971SHQluu68q+aPxIBP9hlcg696RZDiBjk4Hm
rXN/WDUlY5aDdjvQpqlTHY4qbCh6kTfL4f3yY97msyHyIkWzHKY5Ay1eiODL
At1zfyWCv+VE2T759VMdCoD2LS6Y5fDvSsVLtS1THVTZGqcezp3lcFHp9s9/
O6Y6BO2Qa32dBdW/F+qetFkOJsbGxpsPTnUQBzrscvwshwtA9XVHpjocAbon
A+h+sLrjUx1OLXTdVhw4y6EM5J8TUx1OA/mf3RF8sH5nBH8uyCMOsyDhBORz
rAGGJDD8+HQ3zc0H8kHeLreC+N8PyP8R/HiptMUsh3pg+AoD+bDwz5z4tmY/
0H4AijjHIQ==
      "], CompressedData["
1:eJxlk11IVFEQx5ceoqeSioooMqkIIgoMQnxoTMIH+4B8WSRINiOJSDCxkOiD
okgzNZvdOmvdttwiCLMy+2DbzNVVK929+yXb92aRPcRmURGBNOeeWQ7khcvl
x8yZ8//PzF3sqNy6c4rNZltPr/x2DtT4F3UJ6Pm5fFvjR4QMB4hnhBHO7515
rPuxgG/Xg8X33yC0F6Vqz/Xp/HuUbwxpTtXObi8yNZeW57/bEhMwfeWdi5Wj
CF53b3ZHQsB+vzF/VQqBog1zkwLseZ0Dv95y/ksBWFi/Z9drzeGcV38OJTU7
Kf45gaounU9LfTGEa7L+iLovHUE4OSc5/DsuoKDsUzjHROjL7qgaiwqoaP56
cB35oxbYjpiaHVn2vDUhzVKf64UAqlKyw+T6g0r/rajSEwqy/jj76xWqjyOs
N6DZ8tujWfarv1vAM8+Grn3kp3jtqYKyJxynelStqsLH/SA/0k7JQ/Y3pOdl
6enXbMXdmuWxUSeCS86T+PBuX/WsFuXf9oD724Swke5/T5xLz90zCNNuLigt
f6Q4twFhPLLJ0UR6TMqfqEdYMvUoBvxC+ahT80g/5fkSf6f8rOBklrqME+zX
NZkz+Za+Vs3WvA2efx3PwyOAVOZvP40QpfL2q9xP0uurbpl3vE3AROzAl2WN
Kn+1l/02c9zL95/lesRjf2+MR1Cz1Ue3Zuu8/7/4IKp7vbzvIdafYZP/nza1
LzW0Px9k30jvczr3I6bmZVwRsFAuTpz308N6Ety/ywJW0GJvzuzXJc1LaR6F
rZqtuhcUDyd0fy2OMzu5f0me3239//4DvrAYSQ==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQXflSzZDj+yyHjIlva+xFpjlEpVjfP/8TwV82+4iC
wZ9ZDqpsjVOdhac56G6a+1793ywH7Xaxm36C0xx+BD9eKs0w22FJgS1XOP80
B+v7/r3ijLMdIiy3nPjGg+CX75svpc+F4N889z04mR2h/6LS7Z//WBDmg/lM
CPu9eJi02RkR7jv8VSOGn2GaA8z9MP7tn3VZNl8Q/Mu+SQI3PiL0g/nvEeb7
mHc6Png7C27/UYUNRS/ezIK7D8aHuR/Gh/kPph/mf5j5sPCZ9375sdMfEeEH
9s8XRPiihz8AjNi6pg==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfdk3SSDi/yyHQ181YvqfTHWA8TMmvq2xn43ge/Iw
abdPnepw+2dd1h4g/8PyY97bJ051qHipZtjBMNtBu13s5rn+qQ79IIMYZzvw
6W6a+753qoP1ff/e6UyzHXqn5wk190x1kG99HWjBMhtiX/dUBx/zTscHrLMd
HBOeXljUNdVhAlDiDsdsh/J986X0gXyQMeq8mPwtJ8r2zW+DuO/Gg1kYfJj6
ue+BDn2K4D+sElnn/gKqHsh/BOQffznL4YIS0GdA90SlAF38epaDDJAR3wP1
35tZEHVA/xxR2FCU8XaWQyYwfPb3Q9W/g/InQsw/DuQDQ6lk8lQEHxaeMD4o
fPL3Ifig8PM7MdXBuTvneTWQbwwEm89NdTgKtO8F0L6tIPdenArRB7P/8lQH
OWB47gC6D+RN86uQ8N0BdP9hYPjyX4PKv5rlcPPc9+DH16Dx+RJq33Vo/DxH
8GcAo+nAUwQfmEQYGh5D+OeuIcIXzAfaB6LK70PD6yaE//0XIj0BACMyNZ4=

      "], CompressedData["
1:eJxTTMoPSmViYGCQA2IQfXqh67bP6bMdtpwo2zd/0VQH8Zvnvl9Og/LbpjqI
AfnBYpj88n3zpfS7pjpwrJGJehI020E2KsX6/q2pDntKJkuwmCL41vf9e6fr
Ifgg9Slasx1OAe0thvE1ZjtsBZl/E8pXm+3wsEpk3fEbUx1U2BqnHlaZ7fB+
+TFv8+sQ81uUZzvw6W6a+/7KVAf51teBOxRnQ+y5ONXhpZohxxqF2Q4RlkAX
n4WaB+Qf+qoR039iKsReGQQf7F5ZqPseQs3PxOSD/XsPap7ObAftdrGbfr1T
HQptua4v9kXwwe4IQfDB4RU52wFEPe6Fhm/0bIfDQPv5+6HycVD/TYDyE2Y7
qAL97TwJqj4Rav/UqQ5HFTYUvUiCmj99qsM8oMbTybMdHoHCazbUvSmI+AQA
AV3oNw==
      "], CompressedData["
1:eJxlkn1IU2EUxodFSERFRURUWtAHSFQUlER0SkLKPnD9IxEUViRRWcscrlWW
rWXi3HSvWxxtmVNRYw2z9A+xyK9hIWqFmGntLwuJYVERQXTue8/lrbwwLj/e
+z57znOe5ZnZ5hNxJpNpJ/209+y1TZXZHQhLDx3f+j4qwODn39YcLmlQXOw7
O2/aPQG12JkYNs7v6Ly+E8HaHli8ziegRjsnDp7bNnPIK8C5cLjP2oWwUXvK
BEwO7st0dyNkeT7bt5cKOE+fVfcgjP+qnzR7BHQlhi0fI+zHLSBtc+GOo72K
e6t2PbnwUnHUtiDU04e6Tw9/P8D+SJ9sFzwbROggnlMigEY25bcgJGnGCnQ2
PZrKxjwkG1vdiJBL/NDF89aw30IBX2ieuVUIzZHc9gSnnlesAsHcuswxcUNA
KDVq8/r/0/cq3kt+P7gUyzluI2i29zg4z5uc1y3Wv855FgmgWz8O5iMMrBj5
+dvFelcQHpOfAOVNty1Zl1HmlOpnPTvnd1fxEuIjdYrlPP2KZe6vBSQ4JtK3
2DnvIQGazIFLnO+wgPgHpGRDiNV1p7W8FdCWU7Zoeh735x3nZ9Xvx4hfUXwZ
F7kvowLyPq3aEG9BWDnjmkgZE/rcZ3gff7HRV8nFU1nmGfyX91cIoK2kt7rY
Xzn32cP+qa+ajWrajxbrMeoTuUve5Odzo48ViqV+QLHs+32EF5TXVzf3o1bf
39NS/r96hN2z4pKcXu5DCCEjuTny3af6J/UqFcv7/YrLU4pOj7/hvJoQBPFJ
yl/uLcx9GWF/pH/1VFvO/FHuSwPrj/E8QZWvwUaefwDaDO9y
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQrbtp7nv1l7MdLijd/lm3f6rDj+DHS6WB/NMLXbd9
3jjV4YjChqKMN7Mdnv9e+TFo+VSHypdqhhyfZztsPVG2b/78qQ7LZgNV/Jzt
MM25O+f59KkOQCMZGhjnOBz+qhHDP2WqQ7vYzXPlXAh+0A651mwBBB9k32zR
OQ4mxsbGm6dCzZea43AR6J5/M6Y68AEdmC83x+Fhlcg69zlTHcDuVZoDsW8h
lK86x0E2KsX6/sqpDvKtrwMtNKB8oHsv+yYJ3FCD6D8+b6rD3PfLj50G6gf7
d9pUB+v7/r3iMlD7+qY6eJt3OiYA3ePJw6Td3j7VwQVozW+eOQ7aII80T3U4
CgyPF0wIPsh977/PhvNN43Z59ryb7VCftadEuGOqgxzQPTuezXbYAgqvCRD/
v7432+HflYqXajOh/r0928Ex4emFRUsQfHD4bEaTPwTl34fadw7Kfz7b4RBQ
ff91KP89RN7vwVSHT5eAAQCMH6DtUuufQMOLdQ6cD45ffgR/Hih8xCH+83sI
Cb8IYPiDzb8Fdb8K1P+XEeENDt9TCD4sPQEA+poqIQ==
      "], {{1786.289, 
      1393.312}, {1796.8519999999999`, 1393.312}, {1796.766, 1394.781}, {
      1796.5939999999998`, 1395.812}, {1796.336, 1396.4060000000002`}, {
      1795.9180000000001`, 1397.331}, {1795.297, 1398.062}, {1794.477, 
      1398.5929999999998`}, {1793.6519999999998`, 1399.1239999999998`}, {
      1792.793, 1399.3899999999999`}, {1791.898, 1399.3899999999999`}, {
      1790.523, 1399.3899999999999`}, {1789.289, 1398.8509999999999`}, {
      1788.195, 1397.781}, {1787.109, 1396.718}, {1786.477, 1395.226}, {
      1786.289, 1393.312}}, CompressedData["
1:eJxTTMoPSmViYGBQA2IQvadksgRLyByHjIlva+xFpjmg8GdPhfM9eZi026dO
dQjaIdeaDeRnAuX3T5zqoMrWONU5dI6DbFSK9f3+qQ7W9/17xcPmOHgB1bP3
TXXoP/RVIyZ8jsOWE2X75vdMdVjn/rBKJHKOw1YQv3uqg/jNc98vR81x+Hul
4uWyrqkOpnG7PHni5jiU75svpQ/kqwDNP5yEyQeb1wZ1nxkmH6ZevvV1oIUV
gg+23xaqHsqfYjfH4YLS7Z91QPf8CH68VNphjoMM0D/xQPfOfb/8mLfjHIdH
VSLrjvdOdSi05bqu7AT1fz/UPmdEeJxa6LqtGMivywLKTEXwYeEJ44Psl3+H
4E917s5J/wF1L5APsnb7P6h/gfYdBgYjP+M0iHuAfD7dTXPzmaeBw6vHESrP
Com/FgeI/HsY336Og3a72M1zbNMg5ttB3cM+zaEA6J/FNgg+xxqZqCdWCP5L
NUOONRZzHIyBYDPbNHj4guMPaD7Q1O/BJlD/cELt80ekJwBXsxXb
      "], CompressedData["
1:eJxVlH1IlEEQxg+JkoiKioyItCgJLEoSLCSakIiykuyPPggKK7IINbvUDvPz
1DM1Pc9NxRW7krPQ9NTTLFKrUxPDs7w+FMvPICVCLCIikubdnWPp4Hj5sbuz
zzwzs+siYyLOe+l0uhP4176Onvh2XyuHi+ZvSR0WBqXRyzKelXDYv8grIDuP
wcHgnD1jZg5rTp4LOW1igEd0qQUconD/7mwGXX72uKlcDiGj4fklmUx8fUxy
vcPI4PvAocilRsW+mV+PtN5Q/FRvWWVM5DDk+nV0MovB4i2NFTF6Dgntlau3
5jJw4/HjsRzyS1BYAQOUMRoezWG79mOKhR7+/3rTHeIYDi9+bjpVUEV8hUNA
9sohVzXp00s+XMtg3LCi7mUi5W+nfFM4vF4//DvZweQ9WcStDHqte1uuoj9V
sbsWHmtj4PHTifctcSqOx3zquxVvnJ/GnP0MbOWdfvZKDm8w3tw7qa+fk99D
0o+ZMi51fST/GN0/Is9vK1Ss+TkvTzG6t9NhoniflH6hY5jBWW09g8PUnwez
A4PkfzqHmerusOD3ioU/bqm/Mp387FOMUXrie2W9BtNkP/j0kN+pXMbB/Ddo
eSeT/50M1mr5JFH+TsrHoFjkm6BY6L0m/f7QSX7qSQ/Gr9s3biiOI710fz/W
++/bxGlbr+JmTXef4i+Yf4Sb9GC85EvoJPoxi/1RaFD+iTwwnzmM5z/BQJNx
z0T3fyb9FsVanUPLFYt5sVL/TpL+aqrXGIPr0/6B3jUcWGju5QsjtP8hzcMw
zWc9+Yf1eYX998Mu/Z1xk94GDimof7lLsah7l2Lhj02xmN8K8rtB9mdoKc1H
I+2/zcC7Fp1opH4vpv5EPoDzssBC/dxEfhUx0GQmODgEafNoZhCG78mZZlr3
cItiPB0X9UjxSu1haCV9ZvLrMc0XxscqBJqeUP5FUv+ONjrPqB7PicsUe947
MYcYb0KbrxwGmzFMNeXrMtL7V6NY9Pt9xaJeNro/k/RVUb1Mcv6C7tJ83CS2
Ur/dUu+BR88/gty5UQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQveVE2T75hXMcMia+rbGfNdUBxr+odPvnvz1Q/vQ5
Dl48TNrsO6c6FNhyXV88YY7D++XHvM23TXVYNvuIwobeOQ6HvmrE9G+Z6sCn
u2lufsccB6eEpxcWbZzqsBQk3zLHoS5rT8nkdVD5pjkOMlEp1vGrIfoNGuY4
GIPAiqkOny75JgnUQ8zfvgTBB+l7vwDBdwSarzRnqkO72M1z5UD9/65UvFSb
MdUBaOx9/2ao+6dAzW+b4yALkpgIVd85x0EbyPCbAJXvRfBV2RqnOk9C8I8q
bCh6MWOOw1ZgOMyfjAgfWHgBAG/FnpU=
      "], CompressedData["
1:eJxTTMoPSmViYGDQAWIQPff98mOnz8xxKNs3X2p9ylQHGP/wV40Y/sypDltP
AGUuz3HQbhe76Zc91SFoh1zr6xsQ/rm8qQ4v1Qw51tyZ43AIqL6/eKrDqYWu
24ofQNVXTHXoB0k8muOwpMCWK7wWwd8CMrcJwQeb2zzVwTRulycPkC+6zv3h
rxaIfdkPofa1TnU4DTT/M9B8Pt1Nc/PbpjoAvcDQAORnTHxbs78Nqh+JD/KP
930Ef9nsIwob7s5xsL7v3ysO5N/+WZdlcxsqD7Tv0yXfJIFbEPfJA/lRKdb3
z8P8C3Sfc3fO8+rrCD5Y/xUEHxxeF+c4PKwSWXccqP8VKHzOQ8MXaN+MPKHm
A2fnODgmPL2wqAMR3uDw6kbwwer7EHyQf99PhPrv3BwHkLe2T4Hwey5A42s6
VB4YXzfPfQ9OnjnVARiMVSLXoPEzC+qemwg+WP09BB9sz0Oo+2ZA4+cp1H9A
+1TYGqcefjHHIcJyy4lvE6Dh8WqOwzQQoxvBB4dDK4IP8vapuqkOP4IfL5V+
AY0/WPp4DLW/aKrDd6D87HtQ/+dA3X8d6r8MtPABplcA/UFwXQ==
      "], CompressedData["
1:eJxTTMoPSmViYGCwAmIQvc79YdUUm7kOF5Vu//zHOc0Bxi/fN19qPe80h1ML
XbcVl2HyUdQXovJFchB807hdnjwZcx1kolKs4zmmOewpmSzRkjrXYcuJsn3y
rNMcgnbItb5OhqpnmuZQaMt1XRnIv3nue/Djv1PhfO12sZvnviL4mRPf1uzf
jODXZQFNXjkVbD5L0lyH579XfgxaONVBla1x6uF4qPmzpoLd0xM718EYCDZP
meog3/o6cEfkXIf3y495m/dD1DuHzHU49FUjpr9rqsNl3ySBG35zHaY5d+c8
b53qAPTdOncPqHzzVIj/HRB8MZDDrRD8IwobijJM5zr8CH68VBqoXxwof9kQ
Ep76HVMdbv+sy7LRmwuxt3sqJHx15oLtOd6H4GeA/DsJwffiYdJmnwZ1j+5c
hwtA/9XNmOpwGij/WQ8avkD/gu01hPjXeM5Uh1dqhhxrjCHm2c+d6lAADL/F
Zgi+Cii8LBB8nU1z3y8H+scTaF/7HKj/bKDmz57qUPkSaKAdND5mTnUAcXUc
EO4Dm+cEDX9g+M4FBbTLXAegZ3PSe6Dh7QYxb34X1D0eCD4ofWR7IfjW9/17
xX3mOpiA4q8bEv+Lfec6yALT1/1eSHxa+M91qAemB+EJ0PQQMNchwnLLiW+T
EXxw/MxE8GHpC8Z3THh6YdEfaPz6Q/hKjNMckgSAJvlB1PsxT4P43w9qPss0
iPt9oP5jg6Z3oPu3gtzPPg0S/u7Q+ADmD3D4uiDyCzh+HRF8AGGOsyQ=
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ3X/oq0bMxLkOfLqb5r6fOdXBuTvnefUUBP9H8OOl
0tPnOiwpsOW6PmOqw+2fdVk2M+c6lO2bL7V+2lQHsP7Zcx1AVP+UqQ5BO+Ra
s+fMdTi90HXb54kIvmxUivX9PgT/xe+VHy91T3UQu3nuezBQ//vlx7zNO6c6
vFQz5NABmn8YaB5/+1QHBhAA2j8N5LCWqQ4ca2SiUoDu024H6myG2j8RwQdZ
49+H4CcLRFhu6UboN43b5dnTiTAfaKljQjvC/rkgRhvCfTA+zP0w/kWl2z//
TUTo33ICGCJTEOZnTHxbs38awn6w/hkI98HCFz38AeP4xfU=
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQ/fGSb9KEf3Mdtpwo2ze/bapDVIr1ff9Tcx0yJr6t
sf+B4B/+qhHDPw/B/7D8mPf2qVMdkgQiLE1Oz3Xw5GHSbp8w1YEBBM7Odbig
dPtnXd9Uh1MLXbcVn5/rYGJsbLy5e6rDZV+gjstzHbTbxW76dU11WDr7iMKG
Gwg+n+6mufl3Mfkw94H56zD5MPVgd29G8E8D7f+8A8EHu2/vXAcvoHvZe6Y6
eJt3Oibsh7q3f6qD+M1z3y8fmOuwFWT+xKkO4PA5ONchwhJo4zQEHxYeMD7Y
/G8Ivipb41TnP1MdONbIRD0BmleXtadkMsM0iPx+aPgyT3MosOW6vnjfXId/
VypeqrFOA/vn/Z65DipA/YfZIPz8XVD7OKDy2+c6LAFqDOeE8oH+vQh0/z8o
HxQe6PzyffOl1vNOg4T3FQR/GYjPOg+ifjEkPN+bzkORN4jB5MPMBwVnQziC
nwxMD1sCEXxwOPrOg4QH0P1gf3vPA4fXOZZpDo+qRNYd95znUAYyn2mawydg
+AgA+SD/Xf87Fc6HhS+MDwt/GB+WHkHGfgfyYekRlF7PA+2DpUewO/zmwdMj
yLvqQfNQ0gfIPzA+zL/ofOT8cl4Jkw9TD45vdQQfnP51EXxg6BdlGM6Dp8cZ
eULNB4znwdMjOH8B4wOWHmHxA0uPMD4sPGB85Px7nhHhPgBL89d/
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/fGSb9KEqnkOfLqb5r6fOdVh2ewjChtqEfyoFOv7
/g3zHJYU2HJdnzEVLJ7fNM+hbN98qfXTpjqA9bfMczj0VSOmf8pUh60ngDKt
8xxOL3Td9nkigi8LMqgPwX/xe+XHS91THSpeqhl2APW/X37M27xzqgOQcEwA
mn8YaB5/+1SHJIEISxOg/dOcu3Oet0x1ALqmdzrQfdrtYjfPNUPtr0Lw95RM
lmgpR/CPKmwoelGC0D89T6j5QBHC/HXuD6umFCDsBwYJQ0M+wn0wPsz9MP5F
pds//01E6N8C8tcUhPkZE9/W7J+GsB+sfwbCfbDwRQ9/AHK3xeM=
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQ3S5289x3qfkOW06U7ZvfNtVBrvV14I5n8xwyJr6t
sf+B4B/+qhHDPw/B/7D8mPf2qVMdfgQ/Xjr7+TwHTx4m7fYJUx2OKGwoyng5
z+GC0u2fdX1THSYc+qpx5/U8BxNjY+PN3VMdZuQJNR94P89BG2ixX9dUB+v7
/r3iXxH8y75JAjd+YvJh7gPzT2HyYep1N819v/w8gt8PtD/mKoIPdt/NeQ5e
QPey90x1eFQlsu74bah7+6c6AMksm7vzHLaCzJ841QEcPkB+hCXQxmkIPiw8
YHyw+d8QfFW2xqnOf6Y6AF1zzBvIr8vaUzKZYRpE/jY0fJmnOZjG7fLkAfL/
Xal4qcY6DeyfCKD7VID6D7NB+DeuQe3jgMpfmeewpMCWK5wTyr8wz+Ei0P3/
oHxQeKDzy/fNl1rPOw0S3h/R+ErzIeoXQ8IzImg+ivz0Ckw+zPyjwPB8UYzg
g9KDdB6CX/lSzZAjaz4kPIDuB8dP+nxweJ1jmeawbPYRBYO0+Q5lIPOZIOFT
njof7L/rf6fC+cjhC+Ijhz+ID0uP3uadjglA82DpUR6YXi0y5sPTI8g5a4Du
gaXHj5d8kybkzYenD5h/kNMnyL/ofFj6A5tvj8mHqQfHtzOCD07/ngh+VIr1
/fO+8+HpERQ+6gHz4ekRnL8C58PTIyx+YOkRxoeFB4wPy79g98gh3AcAzG7s
6w==
      "], CompressedData["
1:eJxVlHtI01EUx4d/VIRUVBRUpAVZoFFRYRHRCYOwJ+kfWUSBFL0kI0Itwoqc
002dc14fqd0Q3RLELC2H+Cg359Sc5io1zUwDtYhRECaSdH73Hrk02OOze3/n
fs/3nHPXxcZHXQjQ6XSn8K19J02GbEur43DZ8uNOs5XB5ucl/o1VHCIDA0IN
GQy+3F5edfAJhzWnz+85l8agNbj6xkQ5h0u4f5+BAf79+XgpB/zMzNczwJC6
e4/kenMKA8OKAW/iQ8W1noSmoFzFUY61+u9ZHAa8U9FjqQx8R2OX9Bs5JDbx
VVtMDPKvLX3wKpVDpvbDzAB3n3CkcNiuvZhioaf4//WaxwyCNNZzaPm96Yy5
jNjAIVQTZid9RsnHKhnYilzBW82UfzXlyzj0rB+cTq5lEIb+2IuJHQyyMfCQ
nUPZ9b0LTzYymPPTiectdipOwHyeuhVvmHefObuZ8G3lSw5vMd7se6lvVw35
PSD9iKnmog5tQ+RfJZ0/LJ/PtynW/LxaqvhP9Fj5ak7xPin9Is4grWN9JmYq
fvb2k/8FHPx29+HwD4qFPz4Gt1D/gkLys0txzG6M2MFkHQpkP6z0UD3yOCzC
xorH/LXtYYz8d1E+VsrfSflkKxbrWYqF3gzpd5+L/DSSHox/wBQ3PpNGej3k
J/Lfd0mTtg7FLzAu71I8jvlH+eg8E4fkKw03rf2yP6aylX/CD8xnFuOFjDLY
ebY+MpDT+V9Jf4Xib5hv5TPFYl4c1L9jpL+R6jXCpE+vObAIU9zFYdrvonkY
pPl0k39YH7MWuE366/eRXuS7qH+ZV7GoS6ti4Y9NsdBdQvl7ZH9GFNB8eGh/
HgPsHnenh/o9l/qzncMhnJf5VurnDvIrh8GR8PT9I8g7tHm0MBjV+riT1i3y
fml7o1jLt7tL8cdprISX9FnIr26arxzpl7+H8kcWdfXR84zq0UdcqHjuvhP9
iM8LXekMfvViQu3kbwrdfy2KRb83Kxb1aqDz9aSvnuqF9yXeauVFDpoPo+zf
ojrqtyx1H8zp+QcK88xa
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQXfFSzbBj+3yHjIlva+xnTXWA8S8q3f75bw+Uv3a+
gxcPkzb7zqkOpnG7PHmWz3d4v/yYt/m2qQ7W9/17xZfMdzj0VSOmf8tUh8u+
SQI35s13cEp4emHRRqj87PkOdVl7Siavg8rPmO8gE5ViHb8aIj992nwHYxBY
MdWhXezmufKpEPO3L0Hw+XQ3zX2/AMF3BJqvNGeqg495p+MDoP5/V4AunTHV
Qb71deCOmVD3T4GaP2e+gyzQvvsToernz3fQBhrkNwEqvxjBB3qXY80KBB+k
zX/9fIetJ8r2zZ+MCB9YeAEAzKCdYg==
      "], CompressedData["
1:eJxllG1Ik1EUx+eaZsssMEzCkgorKAmxPoiMTppEBUUJIRIZavSCMCvTiiii
V1Izs7s+jLiPSUgQBjlshIxQSDOazrmNVTbmtraIsBIzmVrnPveuGzkYlx/3
3HP+53/OtqrMuP+IVqPR5OOXnale+2TRFIXuifUHG4MEYtyDvHiQQGhw9ftz
GgW+tb3a/XyEwEmD3lOuU/7G11WGo8cTJT8s7Bw36CWXvtiZ1L1QgeSsZw+M
AQLxB5KzfiQpUGujyzf5CQxMFgUykxUozrX0/fwo4pFJQV3l0Q+SUcbURa9k
E96H3QSsK6992Yc8xvQNE9Bh/lOLeL2xIQJnmtN0Jqy37TB24iAw/fj7UAPq
Odb09cJW7C878Ul6iV5y2ZLi3M0LJDN9ofkKMFvKHSJ/Atf/1EngEOrRxgv9
LtHfPAUsfTW2DA+/z/+HWb5HWsnMr5k4BfpbCjtPYz+e1irDrjhxj/l+Ybj5
N+V+YD9nP6/NvjlNeX9v5bxUPb2S1XuzZHYETATeYJ1x5EsnuqpTmkW/Ucr9
vUOgfYf//FLMn4OfjtsE8nx7G+7PcM5pIJCZcJn0oB4Hxs/WEdjOFgD3A1+1
997i82jSivkip1x52d+im8usP3qd17v3js7hWLyqzye5CvevdZTy+SOz8QWD
FNJLKvJK6wlsQcPrP1HuJ+rNwPWwhinMDqNzjTy+IiL6bSLA1scaEfXvinzI
kSguCpGszsMsWX1v++/+NYGNaHtbhPtvHBD6Y4z7M8p8Qj1sX2qcwj/Uq84F
93cZDsoZorAC+/G5+HtLUOhxc/8LAhQ23Ej17sH96apuTrvql4yHvdYnma3B
uhHOdrf0V2WXYK/wz8t/32sm5P/BH9RoFvk=
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQLa1/V+WY3AIH2agU6/v/pzqg8B9OdfB4WCWSp4mD
fwtNPRI/c+Lbmv3zEfwXv1d+vDRzqsOy2UcUDOSh/KkQeTYFqPrJUx18zDsd
HwD5JsbGxpsnTnVoF7t57rviAoeyffOl1k+Y6vAHqM1XGcHX3TT3fboKgg9S
X666wGFJgS1XOFD/Qtdtn2vVoPKTpjrE7fLkaVJf4HD4q0YM/xSoeRoLHOqz
9pQIT5vq8K7G3vQekJ8Bcs+MqQ6lkyVYrmkh+D05z3+v1ITw7SdB3a8Bta93
qsP578GPn6pCze+C+h/oXhW2xqmH26Y67JBrfT0R6J8tJ8r2ybdC7ZdH8Kte
qhmekEXwry8usPWSWeAQYbnlxLdWqHukFjhsBcrPb5/q4A0MrwTJBQ5AV30M
6oSql1jgoAqyrxuifpr4Agc+UED1Qd0ntsDB+r5/r/gkiP29YlDzpyH4h4Du
75+L4MPitwRoXhg/Jr8cGL7696Y6dAPDR1NwgYNTwtMLi+5PdagE+odDGGrf
I0j6eScCNf/pVIfLvkkCN8Sg4fUSah/Q/cYg8BbC5wX696LS7Z//PkL4Z4F8
Tx4m7fYv0PiSXuDw70rFS7WfUx0WAePbVhaRngGnC2NX
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQPeHQV405tgscgFRM/5OpDjB+xsS3NfazEXxPHibt
9qlTHaJSrO+fB/I/LD/mvX3iVAeX7pzn1nYLHLTbxW6e65/q8ErNkGMNkM+n
u2nu+96pDnPfAxXaL3DonZ4n1NwDMU/GAWpf91SHZbOPKHwA8h0Tnl5Y1DXV
weNhlUie0wKH8n3zpfSBfKCp3ye7YPK3nCjbN78NYl+OHiYfpv789+DHSw0Q
/EJbruvKRlD1UP5jIP+C0u2fdUD3gJy93HiBgwzQo/FA9+4tmSzhYrLA4VGV
yLrjQP8kC0RYbgHyM4Hhs78fol7dFMqfCDEvGcivy9pTMnkqgg8LTxgfFD75
+xB8UPj5nZjqsMh122dbIN8YCDafg9j3BWjfVpB7L0516AAGwHaY/ZenOvSD
AhLIBwWz+VVI+N4Buv8wUJj/GlQeyAcGW/Dja9D4MYLad32qwzygxtOGCL6P
eafjAwMEnxGYRg7oQ+P3GiJ8wfyrkPjfrQsNr5tTHZyB/GprRHoCAB+jIuI=

      "], {{2081.4300000000003`, 1412.265}, {2074.086, 1403.6709999999998`}, {
      2073.2419999999997`, 1403.6709999999998`}, {2075.8520000000003`, 
      1412.265}}, CompressedData["
1:eJxllH9IU1EUx4dEhFiURsSwxChpSEhGf0SIp0Ry2hYZla3RwjnnrNzMlVlS
lKSwH0yrW1CkTwsiCIIIycgfjIgxaTlz/ij6IWZlURIlEZZ03nvncosNHuPD
Pffe8/2e73vppc5iW4JGoynGR/5PaegLt++VoKLlS31ulIHOHAjOmCW4Hzre
k/aawe/b3wYXlkoQnFlrDrxj4Dv8YXaqXHB1TuKI1SFYm/VqdeMhCTKblo0Z
Jxg8WHn+884jKkfeMmjGwlQnreP5IzdcOR6XBBvk3wsG2QvupF6tlmBg1ctf
p4cYrEc2HZVAn5SQ2TTA4D0udCEvWnfvujMsuLanTZsVFKzouSY43J7fWcMY
WBeXbPrBz2th4EU9jhq6L8Cg231x+WPkj7Mo3E/3uyXwX6lKbvCp9bpjpNfL
YFLeiLzl4ORAh4dBHhacqqV+kOftwU7r4ln2t62RQTL6n26NZ17fhf4tKft/
f3a54E8Z2KGd+kU+8FCfdK6C5of9BuRGHaTfT/qRU01lmy0B1f/CSglWIL9B
PwrGTy6t4nyBzkOOosw5Jpj7y1npv0/wZdmIEOXJoc5rOsJAzts49ofV2ruD
DFqnbz3pt9M8h8lPG+VjlOZjFSyv11kEy/u9+6m/5+r5cp4Vff2Ceb+cz1Q+
cqcwNd9PkdfMP8vyKA+6Esor+vO1PndjK/JNFwbdr+rbuk8ChvrsPpqPifLj
JX0m8sND+TaLecmcaIlnPn9FX0E883qF9YJHcX+4SLCSVwPp95IeowQO1N+L
/Xfkd37/Y6R8NJO/O+i+S4K5X/+up3ULVvwLUX6ovjdCenh9lPoz0vuG83n2
c9eEDXlu6MRURoz8MtD8YpRXA+VvmPK9neY9ovodLRKs7C8UrLy/eprfsPBP
4Rh9D7aRP2O0vlt8v3g+OP8FqRCLkA==
      "], {{2111.23, 1390.984}, {2124.105, 
      1390.984}, {2124.105, 1387.218}, {2111.23, 1387.218}}, CompressedData["
1:eJxllGlIVFEUx8dpm9yRKBFbtJBAJLVAJKRjEZiWkUGKRIkW9UFyosiyiEJL
axQZ5D6DUq8myZC5tWjhVm7TOOm41MygpmRqWmF+EBNBuu/dM9zQgVl+8+69
55z//5zrl5wWd16tUqni2Vv+fmW81rx9iEJg9mZ7j6cER8MeRI4NU1D+nyTg
eO7gGPY8yU7hov73rZY/BEI1lb4+Vgq71t8lbX8JJJ7bP3p8kEJ6c4nPnmUC
1qfaiGgLBfeguqLZdRI/pxvjbZSU9b3tgict/kPhjYKfPW7fUfOaQp//0OKy
mnNwLQVftvHsPFFY+4KCdEiXOjXN4+c/5/kdGBasrDcLNpUefnOlhUDxbEVn
dyXPt/olgRvTASFR1RTa5nef9jAQyGBsrOX5pxXz9S4sn8ikCUuZRGDgWLKn
91vcryfgldlq8mtCPXLxvPe8ntiHBK4zzukQfObdEVe1UbAs0wUT6sU4h8lQ
b0Y9czF+L4WEcKZkHoEixjF9FMq1Ec7x+QRk2dIHUD/9Cm4QzFzKK2T1J3sm
hO9jHO2qDtzQzvWs6Ue/OzkHM94rv4wELkc4W1NYvG8Zm6q6PqLfzN+t8g8T
4f71ol/dBBq23ft54hOFD0zPfDPX65FpNSv1Wwg4sZ5s/b6aHesZqu6MC85N
nVqaHhMs57dzlMKPJcNcvwnz/4r+dxFovFrgnTWC/YL1Bo+g362CHXo5mJW1
eJvpG8L6PdGO5+l4ffrPqH8Or8fWh/1yH/uhhwJzOTA7C/121J+JfnQIngkI
0aQ2CFbyrcJ8dahHBfen5Amv31BGYXmQdZYB55VSOCj3Z71gpT6jYKW/Bng/
6UopsFPm4kax/8pxfmaw/yvQ/wXMrxLjOUlKvQl12C8aifdjPebrJnE/mlbc
L22C2efCyU7BynyyeZD/TnGwQy8Pvr7AjPPlzu8DLeu3vMJLXmvc8H7Bfo91
lmBCNm6QnzfO8pPDhH3BedLw/G3/sZz2TatgeX41NoyH+9NtqB+7n2Q9ftn4
PG1xkWDtKfegUDvm78b3R9lFff8Au0KqDg==
      "], CompressedData["
1:eJxVlH1MjXEUx29JpbcbGa01b5uwhGJrrTWH+kN5aWojMaZYWFM2KzXLrJKE
VH4KpeeZVrM1GtliepmS1tb1EiqlV6SX61bKlas4z/M7+XG3u3s/e57fOd/z
Pef8lkbEhBw212g0e/Cr/IYf8u3KnCXD0Sz96eocBtu80zd1T0sQaGfunnaR
QfHNuiUjJglc8cUD5xmY4ZmanxIcwfc3pjGIdAzzGf8hgW9X8KXcVAa3DCX1
tkb+vDqFQcKAm6f1hOArTydWdowK3v840G6zQYI2nTG07xyDtAVtOm+9BPFV
hS5rMxgox1cPSXAp9/i85EwGHvcLDCsGJVivfJhgVU/+/88fSJxLkDHtvswi
YoznriQqIX16zjtKGZzws2mJNFD9ZVTvmAQvl7VPJpUzKG+Iq1r8nbiCwWf8
8wj9KYr1s9ldyWDGz1rMp60VHIf13KsXvNzyLKt9waB5e4Rjq7kMrzDe9Fuu
L8pM5n63cT+MvyXoSZx/93kH+TdF+Tv5eWeTYMVP80nBntalruFG6t8HoV/9
befP349L8MV0Z/R1K/mPjG3c6v1OsOpPM9cfPE5+NgkO88GIjQwG0c7hb3we
FjZQP5Ad8E8M1u+UXNN4cIz8r2OQqQTCeVDrr6V6RgSr9X4VrOrVc79b8Pxe
zK/Vkx6M33I71i9omPRi/jWYvx/7PfXm1EBxo+CHWH9hk+B+rD+kmfRgvKRj
T07mtPL52DIi/FP9wHqmMZ5bL4OKRalDO42U/yPXn/dLsFKvrJH/srov2H91
fvtoHixl3q9uBpjVOcVaBuafER3VSe/Pkfk+tNN+2sjcP+zPJzyYYCur/hpQ
fyLqbUA+g/qddILV/XgmWPWnWLC6vwXkty2fT/882g87ev8aA4tdDh5eyOq8
X+V+xCMH4b5Y5dA829H8ZjMIyIju97WXYYOyj1n8Pimzp+fE6xwEK/WW/8N4
3LRKS/qyyC8t7RfGr0S/Ahyp/myuP38unWfUDyfi64Jn7julPz0Yr1fZr3QG
yrqFUr26FLr/rAWr824lWOmXhSXlT6V5nE39wvvSC+fVxULm+3GB8w3svzpv
l8V9MKPnD5IctHM=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQHZVifb+feaFDxsS3NfazpjrA+BeVbv/8twfK/7fA
wYuHSZt951SHHXKtrwN/L3B4v/yYt/m2qQ6XfZMEbvxc4HDoq0ZM/5apDu1i
N8+Zf1/g4JTw9MKijRD5iK8LHOqy9pRMXgeV/7LAQQZocPxqiLzE5wUOxiCw
YqpDxUs1w45PEPO3L0Hw+XQ3zX2/AMF3BJqvNGeqg0t3znNroP5/V4AyM6Y6
gJQtB5oPdv8UqPnfFjjIgjwyEaJ+N9B92kCH+E2AyM/4ieALNR84pfgHwQe6
3rLk/wKHrSfK9s2fjAgfWHgBACM9oIc=
      "], CompressedData["
1:eJxlk39IU1EUx0cYRJAW2rRtWQ2dbs7mtlaEiMfCiKT+SIgwKTOliMiotBCp
P6Jfs7VM7ohGyEtIgqgwM4IaYaFroW7OzUaZyJKSKCspiUo6790jt/LBeHx2
zjv3+z3n3BWVNVur56hUqnX4k9/GcndXbYYEXd+yy91vGczwU+SkIAOtZThj
Q7YEn9u6Sx4MM7jhfbY8z/xvviNP8FDroYL5NsG/bn4ZcNklSMxtv1YTZ9Ba
3Dn5eJUEx3wtGssog7nbEnO/OiTYvrbD//0N5a+WgK1vPLD3teCg/tWPEzHB
Hoy/izL41FDoSEeekPUNMriO9Qsc/LyJAQbJp54EduN5RRVjQX2IgXXeLV0Z
6tnX9LGhEP31T5XGM22CVfJjFZyA+totEsT6pkr3hKj+Sq7/Tpjr6TWT/gj5
y5Ggw1/nWzbE4wv+YrneYZPgl9ivgFGCgFTceQT91DanJaiNFMd6NtR7NYv6
gX52VOWPJBnIX6+Yl6KnR7AS9wqW9cc9fJ7dyCf3Pzqa3Mz9V2dSfy/x86PI
dnzuXWQQ3ly58IqBs93FYONofcpt1BPC/OlGBvXjBqsf90P+u8fJALvm2Gmi
+Tp5/kHzbJb9tZwhv4tn80y+oi9VsDLvJTR/J81DI4GurCp/1wUGD9NPf1ik
pX6iXrkNbcjTg8fHDW6e/1tLfpt4PEtH51+mesjvf+LgmGBlHl7Byve+/+LP
GX/raN/7uf4xLXGI35+7Wr4vdWF+XzYhv0C9k7i/JpzXffSzFP2MRGg/NaQn
Sv1D/zln1bEttF+uNMHo0nouVXDJmvNFFWrOfVHRX4UjnD0p1L8YzU8v7u8f
yWsAOQ==
      "], CompressedData["
1:eJxVkn9IU1EUx8daJiJWGiVlilESLBGJ/pAxPDJX/qiW25xr6rRMwhCVMIsQ
IyQWjaEyblKwxtWijCCSEVlqsUBtxtR+uPkL+7VMwqQiJATpbO/ApQeP9z6c
c8/9nvM9qSfr9dVymUymxjf87Uu+8n1zJQelbevU0R4G55yJikkrhz1Rl5nG
xSDv48UtdWUcJnbN/F1zMsiMfpA0beYwjtziYDDQ6EzMLeZQECtXbrAxcC3f
HSoskur5WxmsN8Wl/zosuOJpfqz3kOBce+2CSsNh7d2FxbSrDBJaX/hOZHPY
aTmlmm9ncAvr2VUcWs70NzpvSHGexWFhteen/o5gz0jTYIpHcESfl+5TUX0/
AyuyHCg/wGBHxtzug7kcLmH9hA8MxlYMn6vzOXj/7C1r+0J6dILb8WfWIDii
r4TD+UH39oxPDBTY71kLh7j0Xlf9HAMcj8JUzqEJ4w+DDILdDWofzremY6n5
+VvBYT1u//+c8prBUnP2AauV9PkYBDB+rZz6G2HwFX/60J9Rrn38e0jy73op
6UGOR/2pFsGLaZnR+8yCw3p7TaR3mLhY4uVXdB75doM6pmSU5mnk4Oisi1+H
ep/g/nQYKX+C5meU8gPvJX+f4by+oV9vgpSvJ3+nKb+IeJb61xHPUX9HBGO5
1ZoCwd3Y9gDuE9PYa0/PUL6W5jMpzStGQ/s7Rv3lcJjyrxiqhgVH/OkXHNnP
R9J+ROH5/eHnHsW1dL+bQVt4EfI44FYpbZ0MQuGLCzkkYbzCSX4dExzpzyC4
apM5y4PzV83rHJ1Myi84zuEllt14k8EP9D+5VIpvc0nzCqHfOZWh8a4u2ncr
6b/P4B+yD9Pp
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQrbtp7vv0soUOh75qxPQ/meoA42dMfFtjPxvB9+Rh
0m6fOtVhAlDhHCD/w/Jj3tsnTnWofKlmyFG+0EG7Xezmuf6pDiCqHMjnA2ns
nepw2TdJQKJioUPv9Dyh5p6pDnpA4ecVUPu6pzq4dOc831250MEx4emFRV1T
HZ5dULptWb3QoXzffCl9IN/bvNMxoRaTv+VE2b75bRD7zNMx+TD1LGF8ukWZ
CP6y2UcUPmRB1UP5G7IXOgCt/VkHdE+SQIRlSc5CB5moFOt4oHujU6zv8+cu
dHhUJbLuONA/wCBjaADyM4Hhsx/o32Sg+i8w/kSIeQZ5Cx3qsvaUTJ6K4MPC
E8YHhU/+PgQfFH5+J6Y6XF9cYMsF5BsDweZzUx0YgfYdAJq/FeTei1MdgKZK
tMDsuwyJH3Ug/z0wPsyvQvjLge4/DAxf/mtQeSD/5rnvwY+vQeMnG2rfdUj8
zMhC8F8Bo3NNJoI/D2hwdwY0fq8hwhfMB9pXAYz/jjRoeN2EpAePEkR6AgAw
UiSw
      "], {{2237.828, 1412.265}, {2230.484, 1403.6709999999998`}, {
      2229.641, 1403.6709999999998`}, {2232.25, 1412.265}}, CompressedData["
1:eJxVlAtIVEEUhjeRijCLDAuTXqRUYmIlEiKekkIrjQysRBSkMENUQq3ErFB3
V9d1dXV85arjWxKT0rIoFddMBLWyh2I+0sgkSiIkwpTO3jkytbBcPubemf//
zzmzIyI26KKVSqU6j3/Lc0+ooWu+lENU7rfkjjwGW9zGdh0r4uBvY+WiyWIQ
n7fZOphxcAy54BWuZTD468y0Uz6HS/i+j4aB++pGxxAjB6+JU/rCdAbWwbau
V3LEekcaA7+PSRtjsiWHPfG3OaKT7HrfNFen5TAygBurGXxP9vEoU3O42l7u
4KZj0LY1/WtuGgd9YcyGVAODPw0/XutTORyw/JhkRU/p/+sPKgSvxe+75neH
GqqJ0zm4aOxHBupIn1pwYCOD4ao47z4t+W8mv1kcXu4c/Z3SwsAB81EbiNsY
tPQmtm/DfKrjvNecfcZgOU8znrfOLDkR/dzrkey08jYzDzKoPPrwpzfyK9xv
6a3Q119CeY8wQFceYcUcUGbTiw+UXyGdP86A4/c38iVb8ow0Sl6BNe7Mof3G
pH5F9ygDXFYB1ufLAh48TPnrOczV9ZzwfCdZyWeIwV7U36qnPPslnzuEO/aJ
ep3Wi37Y1Ev1wPxsUVgs+k+adXbv1VH+3QzC0U9XJvk3k58MyYpfrWRFr0bk
/b5b5JmgJj24f+2d7u3NVN9AOj8AefHNtdnaPsmt6L+8X/IM+g8aIj24X8rl
p/F5w6I/mjJkfkoe6GcJ93OeYqBFG49y6PxPop6LTPJ19Lu6RLIyLybq32nq
h3Kq1ySDrOiZhVnOgfnqoiPH6f0qmodRms9qyg/rc9Iz4/Bktch3bkjo3VfD
4SbqtxuQrMzHc8lKPrWSlfk1Ud41oj99i2g+lt8vYDAUELG+qIb6PV/kMY58
HOdlVR71cy3lZWRgl9rZx5EPWuYxl0EC3if2dbROXPAP70e/DvWS8TFhqCd9
uZRXPc2XUeTV0ED+jUK/1V36nlE9GomLJS/fd5b6+OH3U5b5ymDwGQvxmPwO
pNH9VylZ6fcKyTo8P6qczk+nfiyjemlFv94y0XxkClaZqN+y5X2wrOcvDgG+
Lw==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQrRnTf+jrnIUOGRPf1tjPmuoA419Uuv3z3x4of/pC
By8eJm32nVMdOsRunts+ZaHD++XHvM23TXVY5Lrts+3khQ6HvmrE9G+Z6vCu
xt503oSFDk4JTy8s2jjVYTFQfm/fQoe6rD0lk9dB5XsXOshEpVjHr57qsBAo
X9uz0MEYBFZMdfB4WCXyrhti/vYlCD6f7qa57xcg+I5A85XmTHUQbj5waiFQ
/78rFS/VZkx1+LPy4yXePqj7p0DN71/oIAu07/7EqQ5CQPWKExc6aLeL3fSb
AHH/30kIPtAUw46pCL4hxxqZWzMWOmw9UbZv/mRE+MDCCwCv/KUx
      "]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3,
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxVlHtI01EUx4dEiUhJhUZJT5LAoiJDwqQTFmFSgv5RSVRI0ZMsEguLHuSc
7zl35+PaWpnNhGGiZkumli6dKzd11jJN8wEmEWIQFpJ0fr/fGZcGP8aH+/ud
+/1+7zl3XXJKwhk/lUp1DB/pP8G6Wv39JYfzuh+3WvUMdp5ois2r4RAb6Beu
yWMwFbbd3/KMQ2jS6aiTWQyM01UdcWYO5/D9PRoGyUFHdzVUcIgaic8vUTPw
t4QmTTxU1lszGBS2/do0xAXbUvUrMphgLDsSr+Uw4JpNHM9kMPjn9oXduRyu
t5hWbs1lcDU6wLtBwyG/5PLS+1oGvxPHn65Sc9gh/QyCZT0P/l+vf0ScyQFl
HNdWEmdxCNcED7iqSF+OwoctDGoOjKYzLfmvJb/FHHrWo7IGJZ9AI7GVKfti
PpVXogOONDPw5dmO+y1pF5yGfp53CN648J6h3c0gJvfS5M1GDr1Yb/6Doq+8
nvIeYPAZ87DVchhNX17TOUT5WWj/YQb78Ps5s2ApT3eFYDxi1V0T1fsi9Dc4
0lrWDNI6ns+3ueqZvk+UfxkHyXbkR8FyPh5F/8UyyrNbMHaBI83JAGPwPilV
+iHEQXmXcFi8pc6Ygv5n+g4lFxoofzv50ZP/dvJTKFheLxAs681T8vbaKc8c
0oP14yKz957KJr24/6yUJ5733/4bU2an4Bfo39QteBL9J3hoP+w/TD1Vj3lo
pcI6kZ+cB/qZx3phY0zxZaL9J0h/teCf6DeoTrA8L1bq33HS30zn9ZVBCA6C
5w0HAzbG2WF6307zMEjz2UH54fmU4li87lTynfaQXgeHO6h/mUuw3KdvBcv5
mAXL82sk/w6lP2NKaT587xczMJfb127ron5nSh425IM4L4v01M9OyquIKXXe
cYiQ5lGn3Ceb39O6j7sFS34jXILlPnWTPh3l5ab5wvrB0sXRS/6LFP0L+ul7
A52Hl7hMsO++k/uxh8OYNF/ZDJyP9zde66J8M+j+axMs93urYPm8bLS/mvQ1
0XllKf2qekXzkUNspX4rEPeBT88/lofGrQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQHbRDrvX19lkOGRPf1tjPmuIA419Uuv3z3x4of+0s
By8eJm32nVMc+HQ3zc1fPsvh/fJj3ubbpjg4d+c8r14yy+HQV42Y/i1THG7/
rMuymT/LwSnh6YVFG6Hys2c51GXtKZm8Dio/c5aDTFSKdfzqKQ4uQPnf02Y5
GIPAiikOE4AG3ZkKMX/7EgQfZO/7BQi+I9B8pTlTHFTZGqc6T5/l8O9KxUu1
GVMcfgQ/Xio9C+r+KVDz58xykAXad38iVP2CWQ7a7WI3/SZA5Rcj+J8u+SYJ
rETwkwUiLLesn+Ww9UTZvvmTEeEDCy8Aj5KjZQ==
      "], CompressedData["
1:eJxllG1IU1EYx5dJrBAxg2HTbRkowhIVrZCSHrE+SGCgXyKiRIrKIoukgqIX
epHcxrTOKu7BpHcCIYiIiKUiEaIw1HQ2zbKWuRUhfZAyQ3ruOc/pBLswdn+c
c5/z/P//597suobqvUkWi6Uaf+b/19wia8ecAftbv5/eNMjAFgn9rEnm8LT3
eKfrPYNg47WMi6kcembzdvo/MxifO1O/MUPzA/5qVaFDc9/tLc+OZXNwN9ki
VVEGa3e9qEzJkRyaZKJuex6tY/0Kz6HpU24OxeY1xuBXTfQ+z+cwsBpPGpac
WcChMiXJ3TTAoAUPeoecmv+kraFP84nOdntBj2ahh2sWfQUY7Niz4cO2QqrX
SnqK6Dw/E3VnkGPzj34M+ej8Yg6+G4fTL3gZjOH+YAnp9TDwmzfrOJTXTg3c
aWawdf2V8tpS6gf51szD1/1liSx8uMwgbvqflshqv+mfN11zm/m8TfNNbKt7
JfWLXP3ceelgJuXnlX67HKTfR/qdHLLwZjfq3Yz+zyM7zAX0I2fJ+UCFi/gq
1UMeRH8WApqVv4pF/92ar5vB9tI8OWVeMyGpb00WB9xtfzzEwGJedsozTH7a
aD7eUj7LNYv1pZrNx88tov7eMFDzLPT1a1b9Kj5bH2xcEZDznfzbkLpbKV9k
Ma/oz9GyZaN35w24dwRvfFLftz8GBFDfPi/ls2DI+fGQPgv50UzzvVjnJdia
yCp/oW/cSGC1X/CEZpHfR81iXqdIv4f0fDHgAOrvwv6tHbgSk/VdLeRvnM5j
mpVf/6+7XmoW/vXS+TG5vytEelT9QVqfNuT7hvnUpW0vLUFeGD4Zzx0hv7A/
kd8IzSv2L+YvTPMdlXlUjdL35JNm8fykZjFnE5RfWPsneIS+BxHyJ0Lrs8a/
75eaD8V/Abkiguc=
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQ7WPe6figdbaDbFSK9f0JUxyOKGwoymic7ZAx8W2N
fc8Uh0+XfJMEamc7THPuznneMcUBpOx8BVR92xSHj0D5CSWzHZYU2HJdb5ni
0C5289z3/NkO2iBGM1R/NoJvfd+/VzwRwedYIxOVEjHbIcJyy4lv7VMc+HQ3
zX0fAJH3A7pnT8lkiRbP2Q6OCU8vLJoBtd8VYl/4YgQfpC9/A4LfOz1PqHkv
1Dyg/gtKt3/WnZzisGz2EQWDoNkOQFut469A5POjoP69D7GPJXW2Q9m++VLr
n0D1FyL4YP9VIvhbTgBZDbPBtPyjKQ6w8LwItO/fHQQf7N+3CP775ce8zX9M
cdgK0t8K0T//H8Q8eZh+hqkQ8ZbZDlOB4Z/OPNVBHGj95ebZDoe/asTws051
AHnzQBPE/++B/GQBYEg2Qu1jmwoJ3wao/9inQsKnDsEHx0ctmnzVbAdjINgM
1A82t3w2xJ2sUPeUQf3LCVU/EapfBML3n4bJB7tn1RQ4H2zvAmj6AfIPAf3T
PxOaXqbPdigHhq/+dKj8dGj6mjLF4TJQOmIGxH3Gk6HxNxNq3ySo+lmzHZ7/
XvkxaCJE/Y3ZiPQNtn8ugg92x3wEH+TM8oXQ9DQRav4SqPtg5i+Fhn8/VL4L
kZ5R4hvIBwC1jp4P
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7WPe6figdbaDbFSK9f3pUxxQ+MemOACVMDQA+TJA
fvzpKQ4gYf+W2Q4RlltOlJ2H8ptmO5Tvmy+lfxnKb5jtwKe7ae77a1McQNTy
2tkOmRPf1uy/OcXBG2h+QtVsh60nyvbNvz3FYZ37wyqR8tkOnjxM2u13ofYX
z3a4oHT7Z929KQ7T84SaDxQg+EcVNhS9yELwkwWALkmFuhdoHtBV++QTZ4Pp
+deg5kfPdjAxNjbeDHTvp0u+SQIRsx2AruydfhTB124Xu+m3A8G/ee578ONV
UxyAwue+R0HNWwDx3/kEqP0zpzgsnX1EYUMaNHwmTXEAarY0yYWYd64P6t8S
BB+ouiijCsHPAIaLPTC8Xvxe+fHSRLTwB8YHABZjybA=
      "], CompressedData["
1:eJxllHtIVEEUxtdHpeZjiyjtnZSVGhoqZWYdNSvNR62EZW+t6EUGhYWFEFZW
rqzSXP3jjkpvBFEoKwlRSVHTMLMgTGFLLR8Qm4GpGUtzZ84yoBf28ePOnTnn
+75zV6SmG07Y63S6ZPbRfvPfjK7p2UvBL2d+V7teARPjg/spVLVk1C77QcB2
38b8voHCqYKf1+p+EUg5HmZ+H09h5czrSsM4ge6JrDObd1K4XFu6MMBK4Ina
uDwQKLive1ZsmaGI/ULwPGdFrF8r+XdnfKreU/K23HMDky4UPnh3T1jtke0o
LGYHHxklEMX46l8VCrU/QwS+sP1q/qi8vq09kvn6d5Jb70e/vFhHIFW/LzR4
QuX1Vj4nMOSz3snfqkIDa9OjDNlB1J9eQiCNra9yphBx9HvHg0ICJZanTW1z
RL+VBQTiNtyJ+OqFehjxeW/RT8JdweW+kl8wXUsDJBuql948G4x6MQ45/DrG
NRT1NOL54RTYd0tGHtYfSeHRhXCXZJNYb9yO+hVM4WrJYebEvCLWf82le56O
jGNd7f1mNRKh7zb0uwk5ikKQdrUQcCpnSrLzejPnVTS/Rb+Zv0u0ILQS4d8W
9KuNCB82UdBiY2L6F2t6BU9n3n8HgfGkvseLTk9n2/oxxupJydyXY5K1+voP
URicLBvpbMX6D2BemgkwmT4/TKEiL7Z+Wd653/WSbXrZuIP1k2USeU804H65
BIrOz82uj0X9b4t+dkVhXm5hHsIoxDB9c26g30FYbzb64SuZ51Ivmdf7D/Od
i3pYVO5PKRX9W/pVsH66MuRThvNqViFSy+cryby/Fsn8uY8iP1W9KgwwvQxm
zN8gzs8w5pedx/0fw/rG8Tw7RfTriHlxUkQe3VFfN0X44TXl/bJa8io2J1H+
kvl8BlLoah9LSrOxLS8eipirjThf7oqYf5a3PGaEgxu+X6IxPy4KjLA85seI
/fpYfXye4nCenLD+eMkVO75lkgTJw9q8JuJ5+LxxN84nez9xPfaIeVowWwGd
dhmwflYP188g+/sP0qGUTA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/VLNkEOnbY4Dn+6mue9nTnGY+375Me9OBD9oh1zr
6+45DksKbLmuz5jiYBq3y5Onb45D2b75UuunTXEA658wx+HQV42Y/ilTHG7/
rMuymTjH4fRC122fJyL4slEp1vf7EPwXv1d+vNQ9xaEQaKwyUD/IWvPOKQ4u
3TnPf/fOcTgMNI+/fYoDSNt5oP3TnIESLVMckgQiLE2A7tNuF7t5rhlqfxuC
v+VE2T75ZgR/T8lkiZYGhP5+kEPrEOYvm31EwaAGYf+P4MdLpasR7oPxYe6H
8S8q3f75byJCP8je+VMQ5mdMfFuzfxrCfrD+GQj3wcIXPfwB+hPH0w==
      
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQ/fGSb9IEtbkOW06U7ZvfNsUhKsX6vv+nOQ4ZE9/W
2P9A8A9/1Yjhn4fgf1h+zHv71CkOSQIRliaf5zh48jBpt0+Y4sAAAl/nOFxQ
uv2zrm+Kw6mFrtuKv89xMDE2Nt7cPcXhsi9Qx+85DtrtYjf9uqY4LJ19RGED
w1w4n09309x8Vkw+zH1g/rU5GHyYerC7byP4p4H2f36A4IPd93SOgxfQvew9
Uxy8zTsdE55D3ds/xUH85rnvl1/McdgKMn/iFAdw+Lyc4xBhCbRxGoIPCw8Y
H2z+NwRfla1xqvOfKQ4ca2SingDNq8vaUzKZYSpE/jk0fJmnOhTYcl1f/GyO
w78rFS/VWKeC/fP+yRwHFaD+w2wQfv4jqH0cUPn7cxyWADWGc0L5QP9eBLr/
H5QPCg90fvm++VLreadCwvsPgr8MxNedC1G/GBKe72PnosgbtGDyYeaDgrOh
HsFPBqaHLZUIPjgcS+dCwgPofrC/iyHxe45lqsOjKpF1xwvnOpSBzGea6vAJ
GD4CQD7If9f/ToHzYeEL48PCH8aHpUeQsd+BfFh6BKXX80D7YOkR7I6yufD0
CPKuetVclPQB8g+MD/MvOh85v5z3wuTD1IPj2x/BB6f/UAQfGPpFGZFz4elx
Rp5Q84HoufD0CM5fwPiApUdY/MDSI4wPCw8YHzn/ntdEuA8A5dvc3Q==
      
      "], CompressedData["
1:eJxdklsoRFEUhid5kIQQEuVSUsODxoukliR5QHmSPGjiRSI1CQ+oUaOEKcst
s2aiyaUY90sSGtdGxrWGQUyRPAlJUrLP2Vu7nDqtvrPOWv+//3MS9HUlVX4a
jSaZ3UodqA0zblkJThKvv1o2EfShpZmLjA9H8pbf5xA0yjVK8PQ9+VoyjrB4
0LBhmyBYUqoNwdcc4cifIejP7ax5GkDIuivuiloh2P5IKQ9BhLezQn3oluR1
Q2+0/55kRS/jkCBDp9Mt9CHfe0xwyvz8DCI0PSenB1wQ17EgDCp+PUJvBEH1
7yWIK6vMuptEUMrxrWDmNzhtnupu+Py+FSFgKras8lKctx9hbHgnfvZU6HUj
mCKv3J8ugoIgP63JhODI9zWjk0CrNIw8j7ZVyY3MX8e05PrsQE+SnaC1et0Q
3sH9FFuI52bm529Hgp8LNjkk8jQT5FQ8nozaJav5LPzrOwWj0HMLZvud7P0e
j2A77xfdI6TO08u4g4A9jZl5EHmtSVa/765kNZ8jMe/j+b2ci/1e4d8r9M9l
3mq+Lsl//9MvIsw07A==
      "], {{1895.6879999999999`, 1329.312}, {1906.25, 
      1329.312}, {1906.1639999999998`, 1330.781}, {1905.992, 1331.812}, {
      1905.734, 1332.4060000000002`}, {1905.316, 1333.331}, {1904.695, 
      1334.062}, {1903.875, 1334.5929999999998`}, {1903.051, 
      1335.1239999999998`}, {1902.1909999999998`, 1335.3899999999999`}, {
      1901.297, 1335.3899999999999`}, {1899.922, 1335.3899999999999`}, {
      1898.6879999999999`, 1334.8509999999999`}, {1897.5939999999998`, 
      1333.781}, {1896.508, 1332.718}, {1895.875, 1331.226}, {
      1895.6879999999999`, 1329.312}}, CompressedData["
1:eJxllHlI1EEUxxdRsRKLjA6PNitN08iwW80nGiVSwfZPRJRYUVlkkFREdNAh
ubus1mz9Ib+RDotAKkIiwjQkYlHYdL2yogOz3MS27cBCkN5v5g0T7cKyfJg3
M+/7fd+dpNJy2+4wi8Viw6/5W936K/VNOIe9NSMn8joZNFVcnnluModGz5Fm
61sGO6dsWdU4iwOWbXN9ZGB7NPv8/nmai1dczC9J1Xwod2LfjQwO6ZXT+zcO
MHj952RZTqZk73sGW3dlv3uRRet4vj9lSVTDcg5Z5ucVAyNw+3n7Sg4dc3Fn
t+Ti1RyKosPSKzsYLNv+uCg6m0PMogdGeZvmo811cYtbNQs9tZrbrq19eNjN
ACVbTmfTeTWkJ4fuczGpO5fD0NidoM9J96/h4Lx6cOpZh6wfziO9dnm+I59D
fslgx/UqBkHfhtLqQuoHudB+4PPY+lA276m7wED4Hx/Kqt70rynxv/1Jmk0f
AvOpX+TRzQP1tSk0P4f0e1Mq6XeS/jQOCbiwwyX9z1jIIdEsRD9EneJLdB5y
J/oz7tas/FUs+n+q+UoBNuqhPKXJeQW8DFymcQs4YHXcPR+DW7XP5mQm0zx7
yc8kysdLmk+CZrE+TXM97r8fTf11kX/hpK9ds+pX8amypopY1FOK+V4awSE5
8oy7gPIwHEF5RX9m9HtHuyI53DSDjf79Rn3xURzcqG+Pg+YzgfJjJ32TyI8q
yneMntcXk2NDWc1f6PtkhLCqFzykWcxvRLPI6zdD6reTnqAB+1B/C/Z/d92H
4+yHPN9aTf7+pPuYZuXXv+vWJ5qFfx66n+pbvKRHnd9J68ji/4bziWrAzr4b
MN59zJ/SQ35hf2J+PZRX7F/kr5fy/dWQ8+6j92REs9g/rFnc65fs7dX+Ce6h
92CQ/OmndYt+v1Q+FP8F7Xp4vA==
      "], CompressedData["
1:eJxVlAtIk1EUx0WkRKSkIqMke1pgEVJRYdIBi7CocBaaZtZy+Zi0UpsiZa+t
qfPR5p2PdFcjHwRiYhYSptDUxNAeq1Q0KxW0JCQiLCTpfN93xqXBNn7c77v3
//+fc+5atU6lcXdzczuJX+l/+VD/bISBQ5Ll+5WOYgYv7x148jOLQ5i3e6Ap
n0HjwS9Zyy5z8IuOD47LYaD2idrTksohEZ/fZ2LwO2K8dpWOQ/CnYwWlRgb2
mfruw1plvcPAYOOCG7bQBMGq1tXG6TOC/Y3T4a0xHCQZ47cZXArxGrgfySGj
vWrlNjODnaefhuVHcCgovbDkVhGDtvTiFYZwDtulj02wrKfy//VH1cQqDs9/
bT5VVEN8nEOgCZ3Xk75IhY82MNhvTpmciyH/TeRXzeH1uuE/2S0MejGftCTi
VgZbmtFxOoeaiyFekc8YuPJ04HmLHYL16Odht2DpXMcrBp4NftETNzm8wf3m
3yv6PK5T3kNKHuuvcsAqNL4Yofwy6fxR5f34NMFSnrt1grvWNKVOaWm/j0J/
S4++3X+Y1s9zmJp78OPtIOWv4SCVcdcHwXI+Tga+qN+poTz7BGNKPfpepV7e
GqUffHso73McFm1ttuvQvxT77FnKv5P8xJF/B/mJFSyvRwuW9UYpeQ90Up6R
pAf3H5NyOkF66XwP5L/vMr/W9Qp+jP6r+gRPon+Vk87D/bKTcWVQ6Q9HrMhP
zgP9zON+AWMMnEfUPoNaOn+C9OsFSzYzsgXL82Kk/h0n/XlUr88M8Dd5byEH
W6g5JWGUnrfQPAzTfFopP6wPxjqziSn5zqD+DZJe5Guof2m/YHk+ugTL+dQJ
lufXTv6Z0p+hZTQfNnq+hCnP2ajfGfVnCYdDOC8Li6mfSygvK4NvAUGeDaUc
dkjzaFHuE1ZG6y4uF4y3QG3FXcGYclBOBemzUF6VNF9WJa82O/m3Kvq11fS+
jepRQ1wu2HXfyf2I+8l9k8vgDhZqhPz2G+j+KxIs97tZsFyvXDrfSPpMVC+8
LzuxXxONNB95xAbqt0JxH7j0/APiibkj
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQLXbz3PfglnkOGRPf1tjPmuIA419Uuv3z3x4ov2qe
gxcPkzb7zikOl32TBG4Uz3N4v/yYt/m2KQ4ca2SinhTMczj0VSOmf8sUh0Jb
ruuLs+c5OCU8vbBoI1Q+fZ5DXdaeksnroPKp8xxkolKs41dD5FOS5zkYg8CK
KQ6qbI1TnZMg5m9fguDz6W6a+34Bgu8INF9pzhSHV2qGHGuA+v9dqXipNmOK
A9AWiZY0qPunQM3PnOcgC7Tv/sQpDi9B6nPmOWi3i930mwCVL0DwgdS58lIE
/0fw46XSNfMctp4o2zd/MiJ8YOEFAL18lvM=
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQrcrWOPWw9nyHLSfK9s1vm+Kwp2SyRMv3eQ4ZE9/W
2P9A8A9/1Yjhn4fgf1h+zHv71CkORxQ2FGX8mOfgycOk3T5hikOSQISlya95
DheUbv+s65vioLNp7vvlf+Y5mBgbG2/unuJgGrfLs4dhvoN2u9hNv64pDhxr
ZKKesCL4BbZc1xdzYfJh7isE8W/Pw+DD1J9a6Lqt+AGCrwu0X/0Zgg9236t5
Dl5A97L3THFY5/6wasobqHv7pzhUvlQz5Hg3z2EryPyJUxxUQOED5EdYAm2c
huDDwgPGB5v/DcEHhavznykO1vf9e8WB/LosYMgxTIXIv4GGL/NUh8u+SQI3
Xs9z+Hel4qUa61Swf5SB7gOrY4PwFz+H2scBlX86z2EJMGDCOaH8h/McLgLd
/w/KB4UHOr9833yp9bxTIeHNOB+VbzQfon4xJDyVk1HlUzox+TDzQeG5pQXB
PwpMDy/qEHzxm+e+X66aDwkPoPvB8VMBid9zLFMdXLpznv8um+9QBjKfaSpE
HZAP8t/1v1PgfFj4wviw8IfxYekRFH065fPh6RGUXlkq58PTI8ja8ur58PTY
fwhoUP18lPQB8g9y+gT5F52PnF9YAjD5MPXgeAxB8MHpPwrB/x78eOnsuPnw
9HgaGD6fE+bD0yM4fyXNh6dHWPzA0iOMDwsPGB85/7LoI9wHAFOn0Hg=
      
      "], CompressedData["
1:eJxVlH1Ik1EUxkWkRKSkIqMk+7TAIqSiwqQDFmFRkf5RSRSIkZlkX2hEGJFL
S83UOz+YdhO/WJkTZ7bElNy0qTjLpW7ObwUtCYkIC0k673vPuDTYxo/7vvc+
z3POuRtjEiMveXp4eJzDr/K/2mmbj7JyuJLz/V5LHoOu0iMNP5s5RPh6Bqdl
Mqg5On531TsOAdGxoRfTGcT4nT1Q38AhDp8/lMbgd9RkxTojh9DRU1kFGgYl
c1Xtxw1ivSWVwdYlD7ThryRHmtZrZsslB2pmT5s4B0XG5CMGN8J8Bsp0HJKb
+dpdGQz2XmiMyCzgkFVwbcXDbAZNt/PWpGo57FY+WsmqnuL/140viPM5tP7a
fj67nLiQQ3AaOq8ifTrBJ6sZHM5ImF7g5L+W/FZy+LTJ9SelnkEn5nPrNbGJ
wY46dGziUH49zOfMewbuPM143nKz5CT0Y2iXrJxr7mHgXR0QPdXO4TPut9gn
9HlZKG+nyGPzBw5YhZqPQ5RfE50/It6PfStZyXO/UXLbhtqbMwbab1jqr7cm
NQe6aP0lh5kF/Y9eB+Wv56CUcV+/ZDUfOwN/1G/XU57dkjEla1KnqJevXvSD
v5XyruKwbGddSSL6V2Kfr6D8LeSnjPybyU+pZHX9uWRVb7HIe8BCeepID+4/
oeRURHrpfC/kv1/ufK3slPwG/fNuydPoP9JO5+F+KfG44hD9YS6V+al5oJ9F
3C9ogoH9RIyfw0DnT5H+RsmKzeRWyeq8dFD/TpJ+G9VrjAH+xh/s5aANz0i4
PELP99E8uGg++yk/rA/GOrfNIfKdQ/1bFL3I91H/SptkdT7aJKv5VEpW57eE
/DtEf4YX0nw46fl8Jp5zUr8z6s9BDsdwXpbmUT8PUl65DL4FhXhXuzjsUeYx
R9wnbIjW3TwsGW+BCt2IZEw5JH2U9OVQXmM0X7kir6Zx8p8r9F+dove1VI8Z
4iLJ7vtO7UfcT+2bxwyeYaGGyK8tle4/u2S133skq/XqpvM1pK+L6oX3pQX7
Na6D5uMJsZX67am8D9x6/gHlvNEg
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQLXbz3PfgE/MdMia+rbGfNcUBxr+odPvnvz1Q/r75
Dl48TNrsO6c4XPZNErixfb7D++XHvM23TXHgWCMT9WTLfIdDXzVi+rdMcSi0
5bq+eP18B6eEpxcWbYTKr57vUJe1p2TyOqj8yvkOMlEp1vGrIfIpy+c7GIPA
iikOqmyNU52XQczfvgTB59PdNPf9AgTfEWi+0pwpDq/UDDnWAPX/u1LxUm3G
FAegLRItq6DunwI1f+18B1mgffcnTnF4CVK/Yb6DdrvYTb8JUPktCD6QOle+
E8H/Efx4qfSB+Q5bT5Ttmz8ZET6w8AIALFCcVw==
      "], CompressedData["
1:eJxlk39IU1EUx5fUWjPncmoRRiVkQUilQYyQjpkk2A8oiFFB5gojAo3ESqIf
FP3YLFPv/MNh74XQEMKkJP+RIRVqi+Y2nXP0c1mUhWypcw1BOvfdO27kg7H3
4Zx77vd8z3lryysPnExSqVQ78Uf/j5zY/il1kQwvohuO1n8lkOCXyKkeAnu2
3Sn8rJEh4ugr7f5AYLStqsC1VOQfxvxBveCzBdpAW5rg3Ket4fXpMujwpXKM
wNDecr0pQ4bzTmnlphCBB2FHnzVTBpOxa2DmI89fLoOtyHqm4r1gT/a7+OWg
4GaMfx8hcDsz6O7G82Gqb5jVH81g94V9BHZh2izeX1j2zZPtJWDWm4zTBhlO
NUxc2oH9LUAPetME52keZ7UsE9xKC2N/QXfsoNnL6+uY/idDTE9FCtfv5/2h
P10DNc7VARZ3JAum/Sb/w9Qvs1YG18Pi5+ewn0f2V2s6l/A41sNqxq0a7gf2
U4fttKt5f2/FvBQ9/YKVuF0w1T/WTKAU51mGfOV0T7WhiYCKPmru7312fxVy
Pj7P7hFYeEiXm7eYcf5dAhfHc7aUoB4v5s9ZCRiu97qOo95QbXpHv4XALZxH
TMvna2H5mpT5TPuTbnI9v6R5nMhX9EUEK3s0JbH5W7hfUQmycBGP1XH/YxLz
E/X2VDetuPFHgrnhC+M59Sx/c1xi/TbweJzf38jrIf+Ybf/tswlW5mEXrJx3
/hd/Tdi9yIrOQa4/wbg/HbtDtQT10H2pwf35Qn1DvW/w3BTur6JjRoJV9MPy
s/NXo1wP7sekDxuclmAjGr0vwL6//ZOC16mv2YoigpW6E4zdI8Jfhf2cf3L/
gnx+SeL7/QuYEABN
      "], CompressedData["
1:eJxlk31IU2EUxoeBREWJhdXUqZWz1LamjSUjOrqZWlng/omQgi0pQqaRGFgR
YbZk5Db36oxS30gSIwpCK6gsLGIklGUhprPEP0ZfmPQhUUTn3nsub+HgMn73
vee55zznuWnOqrKKGI1GU4CX9P9Bb5r/KZ9D8p791reTDFQe+L623HdV8LmQ
O34eZ9Ax3f1kYQGdn2fQjrwd+Wh/p9YYUs69yF3VmxeMMAZXLjxO/YKcK/2C
DGzeyugxG4eDgc/HtzQzSDRG1sTaOUR/9cyUBRisv4mKdurHz+AwyrgKBRdP
1i1zbxU8XOqMayvisBgLqwLK81PF1B/qJ4w+mw2WcHiEvMTHwBW3O++blUOW
B0/qFe7Nm8vqPHXv9aawmUMt8o0mZb7BHOq3kYEd57m7gUNvuLY/xaP4dc3A
oeyOruHjaQaXCm99PZEt9J2ovzFTsNTv5QzBUn1lOgd3fP3DbQ3k52ry6yzp
p5GfXgZ417w3lcOLVWM//zSRXgqHPuynE/02oJ9RHQe07XpRG+npyL8OwUnI
+7oFy/MMCX6Kgxx5xUAq26Ujv0cY+NHo8WTyd5TB81nHVAWyFIvbbxhklvsG
+pIoP+PkX6JSP428w9KY/05LeYkwkGywrOSQHnuqxTbBYDnubziB9vEPq3mV
WT+XZT+7/uedF5X+fRnUXyvleR31j3nVYh7P4H6wzOHCPP3umXlZmk3nah4N
gmV9o2Ap79UmDoPS4v1KPqy5yv4eNNP7ME8li2KyPIzyYOGAqQv/CIn8yXrt
guX6IcGt0of0mvxCbkE+gP7frwmusG+ivIwp+Xeg/slD92qWRigvZtKfoHly
hL8qq37+BWLQ9JM=
      "], CompressedData["
1:eJxdlXtMzWEYxxutGbkMi4W5zN2MFmvWzIO5d0pHtdPRbeV2Ws6JSjnSmE1Z
kuqt0KyXojFicm2KlcWaOyE5klvzBzHDzGWe33m/7cXZWvvsfc7zfN/v87zP
GR3vMK/u4eHhYeM/4//PY5/umyIljbCuCmyvEpTxbrxfToSkszc21ZcfF3Tn
24pXq8Mk9Zt65qCjWvEbs6Qp2T6twTU4D5WUXl/uO+2i4iPLJWUlXk4tqtN8
d0zb96xGzUu8e0zJvinogSl+gKU730NBFQvOf64LV3z7qSAu2zUhEucdgnyn
ucbujJbU8GViVP5rQWlFQz0fxWs+WnZt1PS1midF5Td8SYT+l6r+ODv0Phdk
3P9WumajbMBmzY8rkmf3dkoKbA/JG8I8jOsvdKp8XS7oYR7ntb240aXqn2a2
zGIHXSq+ibmR9fRnfmMY0X3+TOn32SKpeH5u0to2ze5+tGr+/ZA780SQh/HZ
or7/9RHu74Q/zG85/yXk/9qi7pfHPMPf378GbHKiH+C+zB3OwdWLWv67f8t/
/jB/yJwz8/kGzTkcfyEF/t5Ff1Mldf449sncrNl9nwbNw5lja5U/XinwtwZ+
OeDXSfibJCmv1D6wZxXmYZ2ke6z/d4WgxYbw+H/ZHqfZmOORMZJ+sX9HK5F/
Jc6PqP4utUpqPrTgfEoFmOdtXcH7zDmHEG+B3nL03wL/DkI/c+ttvliZZvf8
HdDs9mc/8lvgzz70z4J6pXhPXN/f+JSofqR36ytGv6KgXwg6zO/lV5SKr2E2
bA6JRbxA/QTkZw4K2DX3hU1SCc9bZxHi7YhnTmU9EcnoV6EgjvphS0G9Anw/
DfOUL2gyv69z6TjPVfnyN2OecgRx2s9beb4+VjUtu7BDs1tP1r98ZRPmNwPx
DvV+Z6apfTTShvsk4/3ECoqpXeI9z4Z9ZVX9/xCn2b3PrJrdecLRv2joXw49
CagXrOaxdA32R5Akft7z+yRqPmfkW6+5i/UGOLBfTJLsA3dcbU7G/JowPxvx
njl/Ja+Vx6mqf7ND4FcG+sl6OLvvqUy8x1CcbxW0m/vxjvdlnLFItiFfBOYr
W5BfrxPDrWHwZxfuuwL7IRfzZcb+2o19FYp53YP+h2If7dXs9qtQs6HnusB+
6D4vxf42w2+ef88IrsT1bUZ/+b0MYls6wrHPDmMf/fX78wfzfTzu
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvch12+e/iQscMie+rdl/f4pDxUs1w454BL9d7Oa5
8tgFDo+qRNYdvzvF4c/Kj5fORi9wkI1Ksb5/c4qDUPOBU4pRCxxOLwQadBUi
7xsJ5Z9H8MHqjyP4MkB+/N4pDstmH1EoAOp/v/yYt/nWKQ5aMf2HtsYscODT
3TQ3fz1UPm6Bw+GvGjH8q6c4bD1Rtm9+AtS8FVMcpPXvqrglI/g3FhfYnkpF
8N/V2JveS1/goMLWOPXwqikOIGfVZi5wOAQ0r38d1P3ZCxyWFNhyhW+a4qAJ
tP8rkP8Q6F/3HQg+2L0HEHyw/05NcQBZcz4L6v7LUxykgO5py1jgUL5vvpT+
Tah8GtQ+YPgJA+1bmIIIX/TwBwBpbc6T
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQXTpZguVaxAKHLSfK9s1vm+IgrX9XxS18gUPGxLc1
9s1THEDyYmELHH4EP14q3QCVD13gUL5vvpR+7RSHpxeUbleGLHBYIxOVYl0F
VQ/ke/IwabeXI/iHv2rE8Jci+NOcu3OeF05x+LPy4yXeUIj98vlTHBa5bvv8
Nwxi//4ciLxvFNR9GVMcLvsmCUjEL3A4BDSvP22KA9CVpnGpCD5IPiIbwWcE
+vFA/gKHXUAHrc6A2D+taIGDLNC594HmL5t9RKGgdIGD9X3/XnGge94BzbtX
BuFPL0XwQd6Lr0LwlxTYcl0H+j8OZDCQnyfUfMCrAerekgUOmSD3N05x2CHX
+noi0L73y495mwPDU3fT3Pfq+dDwaIH6P2uBg3a72E2/Fqj6pAUOq4EW7m6B
uPdazAIHYDD/rGuF8pHiCwBXJs6u
      "], CompressedData["
1:eJxVlAlIlFEQx0WkJKTLUDExipJEQiwlRMQhC9LIwKBMJMmKDiQt1C6xdF2P
1W1b961XHs87QyrKQiM11EwMNbM88Ci1MjsUKYkwpfm+N/JqYdnvt+978/7z
n5m3MSIq+KSlhYXFEfwqvxmRk/Ou+RzOGL/HN5kYfHy1aeiymUOAjaVbaiaD
/rJoX10WB6fQEz7haQw8rGucQo0cTuP7fqkM/lTPvtYbOPi8O6DP0TLo/nVw
okIv1puSGdhqnnWUZEh2DTM0x6ZJvtk8t3VYy2GwCzemMKh31n7t0XC42Fjs
6J7BYL37yOa2RA76nHNrNQYG4U8CbJqvc9ihfMySVT0F/68/5AyOIu/C/XhM
mKGcOImDW6rdYFcV6dMIDqphULrn8Y8FLeV/n/JN54C2/E6oZfAJH+oziesY
2CnC0Z/yaN8VhxsYLPnZguetapEch/nca5O8ZVmiuaWbgdWhldsu5HHowXiL
b4U+y1zye5BBHfphzOYwdmXd3RfD5B+j80fF/gdGyYqfBQbJx1eHeP/UU7wR
qb+2Pa5xwxCDCFyPwfp8nsdCDpD/Og4zVW37dvZJVv3pZZCJ+qd05Gen5BBv
jNjBwBHrlaIT/WDfTvVA/1BlYRTmv1sxII38bxX5zKVS/i2UT4pkNV+tZFVv
svC7v1WcX60hPRj/PP49QfUNahd+JiEvvLk0Vdkh+RHmX9wpGaPMBveSHoyX
cPZpjGlA9MdYivRP9QPzWcR4LuMMvrh4WH/T0/kfhP7tJslKvj45ktV5yaf+
naB+KKR6vWcwHe/n5VzMweyfEXlqlN7nNA9DNJ8l5B/Wxx77z7ZU+DvTK/Qe
Q76G+m27JKvz8Vyy6k+lZHV+C8nvUtGf/rk0H0vvZzMowsZ4WUr9zoQfa8o4
BOK8LDdRP5eRX1kMYk0OVn3Inso8GsV9ElhO68gDyB3/sJLv/grJDTEmh9YK
0mckvyppvrKEX6OVlH+W0O91m/abqR53iPMkL913aPPkVdw/rsxXOoO9OGjT
lG9XMt1/xZLVfi+UrJxfVEDna6kfb1G90sT81ebTfOhE/3rmU7/dkPfBkp6/
E57GgQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ3Z3z/LfmrAUOGRPf1tjPmuIA419Uuv3z3x4of+oC
By8eJm32nVMcXqkZcryZuMDh/fJj3ubbpjiwhPHpFk1Y4HDoq0ZM/5YpDjvl
Wl9f7F3g4JTw9MKijVMcWIHyn7oXONRl7SmZvA4q37XAQSYqxTp+NUT/ps4F
DsYgsGKKg1DzgVOKnRDzty9B8IGq5r5fgOA7As1XmjPFoXSyBMs1IP/flYqX
ajOmOMTt8uRx6oa6fwrU/J4FDrJA++5PnOJQAlQf1rfAQbtd7KbfBIi80QQE
3wXo4d2TEPw/Kz9e4p22wGHribJ98ycjwgcWXgDA7Zn7
      "], {{2127.629, 
      1348.265}, {2120.285, 1339.6709999999998`}, {2119.4410000000003`, 
      1339.6709999999998`}, {2122.0510000000004`, 1348.265}}, CompressedData["

1:eJxllHtIU3EUx5dYSIhYgolYVlAUYmUFEiEdkSDpBf4RIZGyih5ELhpZEEVJ
ac5xs36rQGy3B0lobY6wh7qNUWtuuvZwd5tRGRX2ZBVEhCCde++5/JJdGONz
f+f3u+f7Pd97F+kbavZl6HS6GvzJ/yc/Ly3L6hfhQPv3UxvCDATP72W73CI8
9B13Fr9hoM/duc74XAT5tvCBQe3e9W+3+zknbhsq/MOcv+Bx34IilDTnJ7e9
Z9CSnww+CqkcHGew+2l19rkIreP5dzueLfwRFWGNfI0x0MlXTITQ4ld/T48y
mIHoRq7OzihpDjG1L0mEnFJHZ4Ofc6PTWrjSw1nR08HZf3Nj3zELg7KsnqJa
ic5rV/W8lOh5AgPT4YnJ5XERPk3e+xkx0/ORzdeOzG1qU+uFBOk1MdhcfrGy
PilCZf3H0K1WBnlNbv+7MeoHObpVn1vwOp3lvqwXGJxA/1u86azVy7Y1vpi+
//oQ5ycLzn+dE6B+kVc4OlMTAZof9luHfnuGSb+Z9I+IUIRC6gTVfzvyfFkY
+jEvGfwT1fgynYccRn+mLJw1fzVW+ndzvlqFTvooTyPqvFJBBnLeNmE/WF1o
izDI3JFTujpA85TIzyHKR4Lm4+W8BdfHPZxn4v5fTuovqp4v51nRF+Cs9avx
mUMDxjyLmu+1yEtmnbVUUR6Efsor+jNgvFKQOSDCHUPF7Dj6J8voQragvv1t
NJ9Byo+J9DnJj1bKt4vPS2aDJ521+Sv6utNZq1e4Z/r+VTbOSl7tpN9EenpF
OIj6Xdj/UZSxx0H5uET+ElsZZ82v/9eLBzkr/vkoP1TvCpIerT5M/TnofcP5
3Eh1eQPYz9QoJj1GfvXS/GKUVzvlT6J822necdXvchtnZf8Dzsr7e5/mJ3H/
FI7R96Cb/EnS+mP+/dLyofE/CJ6NCw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7dyd87z61QIHPt1Nc9/PnOIw7/3yY9xvEPz+Q181
Yt4ucFhSYMt1fcYUh1dqhhw57xY4lO2bL7V+2hQHsP73CxxAyvqnTHHYUzJZ
guXDAofTC123fZ6I4MtGpVjf70PwX/xe+fFS9xSHdrGb58qB+oHWept3TnEo
BFqTDDT/MNA8/vYpDn+AynyB9k8DWdQyxYEBBIDu0wZpbIba/wrB14wBuvgF
gg/yxvLnCP1A0e+TnyHMBzmz9inC/mSBCMsvTxDug/Fh7ofxLyrd/vlvIkL/
lhPAEJmCMD9j4tua/dMQ9oP1z0C4Dxa+6OEPAHrQ0/I=
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{1526.195, 2014.3622050000004`}, {
     1359.566, 1500.4832050000005`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0014392422600976792`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     1517.1637125439997`, 1986.5105275280002`}, {1526.5744205119995`, 
     1968.0732627280004`}, {1528.4530366719996`, 2021.323203272}, {
     1498.7224205119994`, 1977.1044408399998`}}}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {{{789.8439999999999, 2453.616}, {789.8439999999999, 2510.71}, {
      769.453, 2510.71}, {769.453, 2522.3350000000005`}, {824.0619999999999, 
      2522.3350000000005`}, {824.0619999999999, 2510.71}, {803.719, 
      2510.71}, {803.719, 2453.616}}, CompressedData["
1:eJxTTMoPSmViYGDQBGIQnTHxbY19fpdD8A651tVbFjvA+IW2XNeVm6D8iV0O
9Vl7SoR7FjvIRqVY39/Z5TDv/fJj3BMXOzxeOvuIwksE38e80zGBsRvOB+sX
73YIApr/un+xw/Q8oeYDWt0Q+3oXO2SC5O0g8tndix2mOXfnPPeB6O/ugKoP
g5rXuthBd9Pc98sToPKNix2OKGwoykiHmle72IEBBLKh5lUudtABqc+D8LVL
FztcULr9s66g26EO6J/JeQg+yL+LUxH8NTJAj2pD/ceOyW8A6r8cj+CrsjVO
dc6C8lkh5j0ugPKB4XFmoeu2zcVQ/t8usPrmssUOlS/VDDm+dTlwX19csLcC
Gr6vIeGfXLXYQTDCcsuJh10Of1Z+vMRbA9V/FSL/uAaq/iiC7w0K/y0I/gxQ
+C3pgri3Gho+07sg7qmExk9nFyQ8yhc7xPQf+qpR3+UQxqe7KbYEqr8CGv8F
0PAugrjnbDYivYDCpzoVwf8R/HipdCyqPCj8wO5lxeTD0h8A5ig1kg==
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQB2IQ7WPe6ZhwqMchaIdc62uvxQ7eIL52r4MqW+PUZrfF
DrJRKdb3ZXsdCm25rj+2WezgycOk3c7R6/Bn5cdLvaZQ9a97IOoNFjs8qhJZ
536ux4Hr+uKCWm2o/pU9DmtlolJ+ayx2eLx09hGFOgQfLG+B4G89UbZvPmsP
2L7FelDzn3Q7nF7ouu2zJVT/qW6wfczOix0YQGBvt8MpoHyxH4IPkneOQeUf
zlnskDnxbY39uW6HjUUZE9dWLnaYkSfUfOAD1LzmxQ4ZIHnhHocwPt1NsT2L
HWRA7rPrcZj3fvkx7omLHbaA3FeM4IPl1yH4YPff7XGwADpbtQfqv/89Dj+C
Hy+NboK6X6nX4a4K0MKKxQ4XlG7/rDPqBcvPzoS617AXHB/ZoVC+Zg+cD3av
JsS82b5Q/xj1ODQfOLWw1R1qnhNEvTYwfKaD1Af1ONwD2nfVDmpeeo9DMFB+
tQ3Uv/UIPlh9P4IP9s9ciP9O20L9swLqXweof7b0OMwF8r2doOr3QNOT62IH
9PQFAJnIFk8=
      "], {{921.0469999999999, 2482.773}, {920.953, 2486.585}, {
      919.9689999999999, 2489.48}, {918.094, 2491.46}, {916.219, 2493.448}, {
      913.938, 2494.445}, {911.25, 2494.445}, {908.375, 2494.445}, {906., 
      2493.398}, {904.125, 2491.304}, {902.25, 2489.21}, {901.328, 
      2486.366}, {901.3589999999999, 2482.773}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, {{{991.406, 2467.585}, {979.031, 
      2453.616}, {962.531, 2453.616}, {985.5469999999999, 2479.116}, {972.891,
       2503.398}, {987.1880000000001, 2503.398}, {994.453, 2489.195}, {
      1007.0619999999999`, 2503.398}, {1023.4219999999999`, 2503.398}, {
      1000.3119999999999`, 2477.57}, {1012.875, 2453.616}, {998.5780000000001,
       2453.616}}, {{1067.016, 2468.804}, {1039.781, 2468.804}, {1031.531, 
      2453.616}, {1017., 2453.616}, {1055.859, 2522.3350000000005`}, {
      1071.562, 2522.3350000000005`}, {1082.719, 2453.616}, {1069.312, 
      2453.616}}, {{1065.281, 2480.241}, {1061.297, 2507.898}, {1044.703, 
      2480.241}}, CompressedData["
1:eJxTTMoPSmViYGCwBGIQvWz2EQWDKRMd1shEpewOWOwAFGJoODHRQZWtcWqz
z2IHH/NOxwf7JzoU2nJdf+yw2GHLibJ98psnOsx7v/wYt8Vih4yJb2vsF010
WAvU/9twsYM3UH3CxIkOQTvkWl9rL3aISrG+f74Wql9jscPHS75JE9IRfLD9
fgj+J6C8gNVEh2Cg/tU6UHltiPusTSDm+ctA7D9tDXWfyESH0wtdtxm7Ifin
gPziYAQf5B/nOKj7JCHmVWdA+UoTHX4EP14qXQTlQ+3bXb3YgU9309z3FhMd
/qwEurwZ6j7viQ4NWXtKLndA3Rc70SEMqDC2DypfCPGP8sTFDkuB8hvaEHyw
+nkIPtj8DRMd6oHmCfdB+fsg/vncDuWfgdrXCA3PKxD/HK6Ehuc1KD8f6v7F
0PjJhcbXIoj/ZgP9lyQQYbkFaP8ZoPmby6DyMyH2BwPNW+f+sGrKZKj91dDw
7oGGXy2U34zgg91XgeCD00M+1LxqKD8NGh/lUD4wvOqA8pOLFzuI3Tz3PThs
okPzgVMLj+ZC018g1P1pUPf6THS4q8LWGBoHtd8LGl/hqPzoAAQfHL9e0PD2
hfrHFereIGh4OUHjJwLqHntoeomHpmdbqHsyEHxweBUi+CDz8ish7u22h/Ib
oenXCcrvhKZXV4h7NvSjuQ8p/wEArZKhiw==
      "], CompressedData["
1:eJxTTMoPSmViYGBQAWIQzae7aW7+h4kODVl7Si5XLXZYOvuIwoYfEx3mvV9+
7HTfYgeQ/HuhSXA+UAtDg+QkhzUyUSm75y12WAZUbxA+yWEuUN5742KH6XlC
zQc8EOo/XvJNmpCJ4EelWN/3T5wEtw/Md0Dwfcw7HR/oTXL4Efx4qXTgYocZ
IPO0Ifq7PaH2aUHst3ZF8IN2yLVquyD4YP1OUPcC9XNdX1xQ67DYYcuJsn3y
QPPrgfYF20PdazDJYUNRxkRdO6h6U4j+2baLHbyB7kmwQfDB6u0QfHB4uUDd
bwu132+Sgypb41RnO6j7XaHhowU1H2petCaEz2A8yaHQluv6Y43FDhkT39bY
a6LxxRB8cHxxTHLoELt5brsWJPzO/58IMU8Pav/3iQ4tB04tZDWChucniLy0
OSof5H4YPxgYfqsdoPq/ToTErzvU/J/Q9BAEdT8XIr4A7j0LDg==
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1,
       3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGCQBWIQ7W3e6ZhwY5LDvPfLj53uW+wAFGJo4JyMwQ/aIdeq
3bDYwQeo/gE/lN8KlZeY7LBGJirFunOxA9g85ckOP4IfL43uWeyQMfFtjb0e
RL66f7EDUNV9fyuI+dwTFzt8vOSbNMEdwV86+4jChjgEH6y+aLKDKlvj1Gag
eXy6m+bmN012OLXQdVtxM1T/pMkOhbZc15OrFjtsOVG2b/4siPrDuQh+Xdae
ksmxCP5poP7PPlD3A/W3HDi1kNUB6t4mqP/NIPIMQPvvqgAN1IW6B+i+tUD/
/NZY7LAM6F4DdzS+DYKfJBBhaWI02aEeaL+wFtR8TYj7nHUWO4jdPPc9WAHq
Hz2I/96LQdxnbLTY4RPQfwK8UP+bI/jg8GWFhjcw/mB8AE+9zu0=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQDQINPJMdzix03bY5brEDjK/K1ji1OXixA5/uprnv
BSY7cF1fXGDrvdghKsX6/nnJyQ6FtlzXH7sudlg6+4jCBqXJDn9WfrzU6wDV
rwuVt13skDHxbY29FYIPlndD8MH6AyY73FVhawx1gJofMdlhjQyQ5Qq1P2Gy
g0WnY4KqF0Q/Q+pkh9NA9xoHIfgg85JjEfyGrD0ll9Oh5gH11wH5k/Mh5uVH
QNQvLlns8OmSb5JAANT/lYsdloHc4wq1vwai398SwQfr10HwZ+QJNR9QnOzA
DQyfvZVQ/0pCwu8w0PzpIHkBSPiczUeE7ymgfcUZCD4s/AHNBKNz
      "], CompressedData["
1:eJxTTMoPSmViYGCQBmIQ/emSb5LA98kOa2SiUqy1Fzt4m3c6JhzC5M97v/zY
6b7FDkDR+/6fMfmFtlzXFzcsdlg2+4jCht+THeqz9pQEty92SBKIsDRhngI2
b3f3YgcfoHkPOKc4/Ah+vPR272KHde4Pq6YITHFYC5T/3Q/RbyAxBWw+98TF
DktB5img8XUQ/IyJb2vsLaaA7U/uh7rXeQrYfuGexQ5g/xlD7JMuhZqvBbWv
fLEDn+6mue8VpzgE7ZBrza6E+kcKwQfLCyH4YPt5pjiArEmtWOzwEWj+BHaI
+dFlEPX5TFMc7qqwNYaWLHbgAHn832SHYKD+1QVQeWD4gNVnL3bYUzJZouUH
JDy506DuBcYHyL7XUQg+2L2eix0AbmXMPg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQvWz2EYUNvlMcgnbItWbHLXZA5munL3ZgAIGgKQ6F
tlzXF+cvdthyomzf/KgpDg1Ze0ouly92yJj4tsY+eYqDKlvjVOaGxQ6nFrpu
K86H8J3boPL1UxzqgOondy12WOf+sEqkH2Le477FDtPzhJoPLJjiMO/98mPc
E6HqtyD43uadjgmXEPxPl3yTBF5PcbAACqv2LHaISrG+7/9visOP4MdLo5sW
O3wEyk8QnOpwVwXogAqIfwykpzqskQGqzEHw5wLN845Fk/eDuh+on/v64oK9
jlD//4P61xzi/imvpjhsKAK6VBcSHvJA960F6v+tAQ2fLQg+2P2LEPzTQPM/
T4D6Rxsq3wANb/3FDuI3z32/DAw/sPuMEeEL8k+oJSL8wfKOiPhpPgB0uSci
/sD2BaHGJyh+AT3f6CE=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvWz2EYUNzVMcVNkapzLHLnaA8Qttua4rBy928Dbv
dEzomOJQl7WnZLL3YocZeULNByZOcagH8oPdFjtsOVG2T342hC/suNhhKUj/
sikOpxa6biu2W+zAp7tpbv4WBB9kvsEhBD9ZIMJyy1mEfgYQuI4wX+zmue/B
DxD2g+WfTnE4DdRvHIzGj0Xlf05D6Afbl4cw/wyQv7kYYT9YfQXCfWD7qhHu
h/Fh/oPxYf6H6YeFD8x8WPjB7EcO38dpCD4s/AGCgri9
      "], {{1360.875, 
      2510.1479999999997`}, {1360.875, 2522.3350000000005`}, {1374.047, 
      2522.3350000000005`}, {1374.047, 2510.1479999999997`}}, CompressedData["

1:eJxTTMoPSmViYGBQAmIQvWz2EQWDiqkO894vP3a6b7EDjF+ftackWA/BL7Tl
ur5YcbHDnpLJEi1lUx1yn/9euVECKl881WGNTFRKtfBiBw4g40n+VIdj3uad
jnxQ9ZlTHYJ2yLVqcy12+HTJN0kgAaLemn2xQwHI3LCpDnOB9nuzLHbYcqJs
33yvqQ4NQPsvMy12YAABGwR/ep5Q8wEzBH+d+8MqEcOpDoobijIEmaHqtSH+
6Qby28VunvuuMtXhONA9jEDz+XQ3zc2Xm+pwZqHrts0wvjjUf6xQ+xUgfGUZ
CF9eGcJ/LL3Ywbk753m1KtT/0hD/b1CH2gfkXwZ674bmVAfh5gOnEoF8H2Aw
PNCG+g/InwFyvy6CDzbfGMEHh5c5RP9DaYj73ltBzOeWhYRvih3EfkO5xQ5L
QfY7THWoA4bHZPnFDsBQvX/ecarDaaD/jBWh+p2g4aUECZ8GZ6j/1RF8sLw+
gg9LDwAfCvDw
      "], CompressedData["
1:eJxTTMoPSmViYGBQB2IQzae7aW6+0jSHoB1yra+9FjuA+O/DpjmosjVObXZb
7LBs9hEFg4BpDoW2XNcf2yx22FMyWaLFdZrDn5UfL/WaQtWbQdUbLHbgWCMT
laIxzYHr+uKCWm2ofrFpDmuBwr81FjtEpVjf92dA8EHyG+5OhfM/XfJNEjgy
FWzfYj2I+fmbpzqcXui67bMlVP+yqWD7mJ0XO8zIE2o+MH+qwymgfLEfgg+S
d45B5R/OWezgbd7pmLBiqsPGooyJaysXO2w9UbZv/k6oec2LHXyA8g9OTXUI
A1oc27PYYSnIfQ+mOsx7v/wY90So+34j+GB5iWmo8gbTHCyA1qj2QP3vOM3h
R/DjpdFNUPcHTXO4qwK0sGKxAzAKGBqiIPKzM6HujYTER3YolH91Kpy/Behe
+WtTIep9of65NdWh+cCpha3uUPMeQdRrO0PUz3811eEe0L6rdosdpoPM+zLV
IRgov9oG6l9gfMD4YPM5EXywfwQg/jttC40vUah/HaD+kZ7mMBfI93Za7PAR
qH6CPDQ9uULjDyl9AQB5GR8L
      "], {{1417.359, 2482.773}, {1417.266, 
      2486.585}, {1416.281, 2489.48}, {1414.4060000000002`, 2491.46}, {
      1412.531, 2493.448}, {1410.25, 2494.445}, {1407.562, 2494.445}, {
      1404.6879999999999`, 2494.445}, {1402.312, 2493.398}, {1400.438, 
      2491.304}, {1398.562, 2489.21}, {1397.6409999999998`, 2486.366}, {
      1397.6719999999998`, 2482.773}}, CompressedData["
1:eJxTTMoPSmViYGAwBmIQDQINRtMdfgQ/XhpduNjh4yXfpAn/pjkE75BrXZ2z
2CEqxfr++T/TwPK3gfLiN899v/xjmoMqW+PUw6WLHbacKNs3/9M0h0JbruvJ
FYsdTi103Vb8BiLPXL3YgU9309z8J9Mc6rP2lATXQM2/heCD5c8i+KeB+j8f
mubwZ+XHS7xVEPPld0PMawbaJwa0P3jzNAfu64sL/hZA9a+f5hAEdG92JoI/
7/3yY6fjEPy1MlEpv4MWO3CsATI2Q9y72AviP3+o+YddF4Np58MQ+ccOEP3v
ge4D+8sOqv42Gv8pgg8Oz7fTHMKBGu/aL3bwMe90fPB5msMZoPxmp8UOGRPf
1tj/gvivF2jf9Dyh5gP/oPqB7vEGqk9gnA4Jz0Co/02nQ9zvs9hhBki9PiS+
pB2h/lOFqFe2WOywbPYRBQOx6eDwFDaCup9tOiQ+dKDu+wQNDw2o+24g+GDz
dyP4e0omS7QsmeZQBzRvsi7U/MnQ8DKDhOeTxmmQeLOH+q8Smn58EHxQ/LyO
QfDB6S0X6j6gfgugt1WroOEJNH8uMP68mxc7LAXatwFov2ZM/6HSHqj9eyDx
yz0Rmj5vIvifgOlL4BOCD04vrNMdNhRlTMztW+ywFZRehaeD3WvcCU1vitMh
6akZ6j6d6RD9NdDwQsofAEYdhrM=
      "], CompressedData["
1:eJxTTMoPSmViYGBQB2IQzae7ae77rdMd5r1ffux032IHFH4llD8Rkx+8Q651
dSCqfLfnYgdVtsapzpOmO/xZ+fHSWReoPJB/aqHrtmLnxQ6FtlzXF0+e7hAG
lJB1WuyQJBBhaTJ1Olgfs+Nih60nyvbNnz4drE7ZYbHDOveHVSKzIPLO9osd
Pl3yTRKYO92hIWtPyWW7xQ4fgfwJCxB8kH35SxF8oBcZGtZA3QvUPyNPqPkA
0H8/gh8vjQbalzHxbY39rukOQUD51zoQ9QzrpjvMBfrHW2uxwxage+SB5q+V
iUr5rQHhz5+AypdvR/DB7qmb7vCoSmTdcU2o/8ug9mkvdohKsb7vnz/dQTOm
/9BXoH3JQP9vyZzu0HLg1EJWfah5adDwNIT4f0rSdIe7KmyNoiZQ+QRIeDSb
L3aYDvJPHNS/1tDwi4WE32M7aHgB+fVAeWFXBB8kn+yH4MPi18e80/GBCw5+
H5p6JH4d0PzJixDp4TQwvj9vREs/QPUANwMwqA==
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{67.648, 1230.9602050000003`}, {
     696.449, 1230.9602050000003`}, {731.906, 1230.9602050000003`}, {760.449, 
     1202.4172050000002`}, {760.449, 1166.9602050000003`}, {760.449, 
     1070.9602050000003`}, {760.449, 1035.5072050000003`}, {731.906, 
     1006.9602050000003`}, {696.449, 1006.9602050000003`}, {67.648, 
     1006.9602050000003`}, {32.19500000000001, 1006.9602050000003`}, {3.648, 
     1035.5072050000003`}, {3.648, 1070.9602050000003`}, {3.648, 
     1166.9602050000003`}, {3.648, 1202.4172050000002`}, {32.19500000000001, 
     1230.9602050000003`}, {67.648, 1230.9602050000003`}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}}, {CompressedData["
1:eJxtVQlIVFEUHaQsIoKybMGyxaywsChwy7wuZSopim22Sdp//6uMVmK2UAwi
ZqHikzTICNskTMOybDENCa3EMk0ty0QjWiyMJGkh679378zHaGAYDu++e889
97w7c3YmR+2yM5lMSfpX/G6/HTLeLkODE4HHk9hrDiNwKQeT+MQa+OzqG4O/
ozWYsOTq6YFKDi9/HE6oAQ3Op/iO23ibwx41//OheRr49ETkFN3j0DJXj7DH
884GDpn9kTdndauQPCnj3qMmii9VYZNX1YO0JxyGFm7Nq9+tgqDh1sZhwbKx
l528VQjV4Zh2DjlF5kkZJgPvFffrmA076GlLshnYW3TGrdTPDoZ8mjkIGudW
MNCr1Z55QPedGUypCO79WW/g38/SP1ysMXDfgckVjdXU/2IGsW9b5m65Rvqs
ZajPFQ7XRV4zA0E/6xKHk2bRKIMvpQ1h1SUccgX/rdjvUBGHAJGoTYWnuk7D
eRzeXDh1f7aLBjNj4n16sql+BOmZSfEHSW8Lh92in2IN3LIcX4QfIj5VGtZP
4+AqhGjSoFfwT+GwTejRqUGZU0z8nQQDS/7xBpb9bSI9KzXUZx2dM8wXvJpD
Y5hHtr+TBvXf9MGtJFyjwoDer4cnxQcbOOh40rtfcww8X/D7w0B3UWqBJ82r
h2F+Lw4bhNGaGAyLeXiRX84xOKLHO/iQvxTS25eDe7eLvWURzdOP9LdjWM+f
S50Pf1VsWJ73GVjm61DQH8BhqcjXrKA//ch/9xUQ10JXkV/vKjgvH6p/S7H1
J/MV/h9Xm0fGCyzzPaT8cRw2iv57FJA2jyF9finSD1PXc+TpyCDq5qzMxAjy
A2C/1aHk13SGfltjnSfpEUj5Bxj6yZ/yL1dtWNT1sxjYXxijTpX1+gPJz59U
5BNC/KdreC+c9FpKfo3+B28xsIzfwUHIXLtAg321Z2a4x5FejpqcvysjvUYT
TqT5fVRRfzPFNxDfPbQ/KnCflKXSe0pU0U/7yQ/D5DcL8c9nUKi/h3dHiV8Q
6Zdr5YM4rYBDl9h/7xV8v/p7vptaMG1UA+FiwhXkn7Mc9Omk+BYiHtL3aavI
d0xBv5YbWPq5ysByTHXkx3IF99FDeg+DCu6/VtLHi/rpov44s+13a79WLPUJ
UG1Y9p+t4j55RfnaUS/X56THdxXn00H7fKKGfrLuY2cDe4t5uhtYxvvivnrc
TvyDNeTfSfUjab88p32xmfZV1z//RzrfvzkYFiQ=
      "], CompressedData["
1:eJxllGlIVFEUxwcJc8MWtJHUTCkVTIwipEQ8oSJpC1mQiJRIUd3rTcmyTYpp
QUJ09A3j5DpqpuQHoc0KSkVDyw9hEYipiElISJmUWkjRue+e8RE+GIbfu+ee
7X/OC83JSz/hZjKZDuJP/t85s/ZGdyqDmda+tNhWDXT+yJdxc36811CTBpvd
LfbEfoOv+LWnTLQZPB+ZZe2xc+idi8xahbzz8evCzmIOe3zcooob6PwSh1Tk
lU7yf5bD3w8Xv4TXGVyZWJI7VW1w9ufBsBGHBk3JHT/+FHF4gm6dNvJXQfmW
kX1OLsSNHyg1ZxCHCbCjv5Novzf29u7saAELhybv1VTS+TYBny77tfdXGazH
rzV4As9T6jUodeCLrQKiitcN78f8+9PQ4Rah6mmg/kTQfeTyHmxEiNDzcTRq
MPL7Knvhp9iM/UlCs0VPOke2SvuF3KV+jkr70eXs0qdPxv8plrHLvsu5PmZs
VIBMq8Sl14CA9Gcbbk1jPl5Dd/PjOwVkoFDzmO/wW+zMA2Xv3UD+mgXoY4L1
n6r4WpRgF/Ad4z2t0aBAvrAKkDI7qyneTQG/ZH8dZH9ewB/Ut0WjeTArfRwR
Grw8ZwtYMc/hQideDKb4bzhMLd6fTfenftpoXlZrUCb7n8VhOz6PvDQIyjwe
Nx5B5x4Ub44tsa7PoMGqPqbfO+apgbesv5rOfTR4F4YKXWfKv68GMlx3IYPT
6LdrjcH6vPobPNCY3FEQQPleY0rfQIpfToz1xYxtcrc0EodQvs+JN9L9IYOD
ZX3TBpvk40Hzjvd3yX5GcV2/wmCarySu5jOI9DvMlV6BVG+mwXp8YbC+TxYO
vtEP62aCSC+H2u8jIaRXO9fz7A3VoG32/b6cV1zVH258L/R9i/5fbzNQfZPU
7wrSY5jp8fJsrvlkqp5Kms8Oqh/na1Dq08L0eRyopXyrmJq/euqHVdk7cD9l
+dkWpvYB5/lbUcKOo4wtzb/r++fal3+vG0pL
      "], CompressedData["
1:eJxlln1M1VUYx5lN29TlRkDLipkjajoz/3Cm1HjgAl6RS4IvmKYxtema/c45
2bSpWeaAHApykLd7EVS4IljC0BX5gow1saZNWy+rxkydc8bKmRMr03XOeZ7z
O2P3bne/fe7vOc/r95xzn13FCt8aFRcXV6G++jn8whuV/RkM5o0fNbWsWkLH
7e9Cqz5iMLUs6ef8iIR1VX9sTY8yYPE7+r5pljAwf9bOjC4GS2cfPze8X0JF
nRe/4zyDwp7kkqEWCVsSjs698juDW21n5886JOFxtezAaA6t/NWxP7VJeGxa
975biRwuTv71n23tEuL0JxXfF3VIeGbZmrTLMx0bfwscG/t1HJ5Wdm8elqDT
Kd7CTT4bWyVEI19N6qrgkHb5td11Kj+d9oEIx7hhCde0wUHu1/ubMvP6OdQG
ytffaJQQvLI54egghzHbawLjWiifO+h/OErxxwr8XcWvV+X3TRJ+fsb/y47X
37jffjvf8abe5onTV7v1pr73hO/f9KVU+PEN7xU4hyYJm7V9k8D66ijfKNmr
ekqGCnqS2wXWW+5Ym8392LFe/8Qix6afIcrvCNoPBKm/nbQ+R8KfW9NnruwW
0H9XCSeL6u0R8PfCa9GnAhLUFHqb+wT2M4P8fy1A/TqxEyj/Hyk+UH9vxrLR
Sxr5T4pla2/8JTs2+c5wrGXRmy4gUZn9C7Q+l+rLJH0XCMhVenhU1aPb6i0R
cEn1/WE26fd1YfT8RZDmvYz6nUvxllN+Ice2v5Zt/y2beHY+RQL7XkX9y6f8
9pI+MwVc1dxAenqR/DVSPQmOjd4fcfyOtv+Lw6d6wBGyv8rh4ffv30xV/lTW
LfwSx/nVUT9Oc1xfTfVH0f7QbsqvlfbjLvfecJljW79l7fdMHumrjeMzSHrq
4FCj9LI2h/T8GYd7Kp9IFunhGPf1ZfbLKe7ry+zHs9zX10uDKWO2/8BH6mEo
lq2eTPz4WLb2xv8Ux+b8m4P9GQCaX4D6mUn9zeO4PwLkrxDr7cymehbT+WP3
VxE35+2382j9Ug4nlcGRkGPbT8tWT5atnsy8C9FfvtVTkPKrofdziMO0P57n
8EDPt5HqmeDY1Psf89no/xeG55LSk7k/vqTzvoG4hO6LGuIVDM+jKmJ131g9
Wbb1WTb7S9U/Xc8zG++bjUHSZ4ih3nKIFzN8Kr2cUbIaLGaoh0zKn1M8pZcN
2vBDhvpS89P7fFsT8+dr/FyIZasPZf32qRQvhkfoJc/xu9rBWs+P95wubJPn
52POr1LPz9f0V3pQfP3i5OVZxGEP+6/qXXlCCaPFw/MsSP7aPOxPyLHt5wj+
wLG5rz+h+77VM/0u30PxmtDfcDXpN0zvayVUamFXe6iveprXTg/12GD/PxBb
fW1AHrC82nGW2sb3CxwfzP78zoNXPDwfwq6/Rt/Kv/670Zfkod720XyeZP79
avVj+X+/9AqV
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQfczbvNOxothhSYEt13XrSQ4z8oSaDzQVOXjyMGm3
H0Twpzp356SHI/g/gh8vne07yaFKZJ37w7YihwtKt3/WuU9yyJj4tsa+v8jB
+r5/r7jrJIdqkPysIod8oLZTjlD5tUUO/65UvFRzmOQAtv8Ygj8dZP4dTD7M
ffp3Vdga/xdi8GHqGUBADKG/0zHh6QUDBF82KsX6vnORQ/m++VL6TlD3+Bc5
PAR5xG2Sw6dLvkkCYRD+cQ+o+ZFFDiBvVPkh+LDwgPHfLwf6ZD+CDzb32CSH
HXKtrwPDIO4PPw11X0CRQ4TllhNl5yY5gIJloTdE//YLkxwUNhRlTHSGhN/0
S5McQMr2mUPD8wrUfTpFDluBwvOvTnIAecdfEuqea4jwQOeD/XMLyt9cBOeD
3TOrGKI+bpLDItdtn//WlMDlwXyDUgw+zPy4XcCUIo3ga7WL3Tz3vwTOP/RV
I6b/TYmDDNCh8Veg4f2wBBIeQP++q7E3jbsF4V8/O8khFmTe9RIHkLflTyD4
sPCF8WHhD+PD0iM4PG6XwNMj2H9PSuDpERze70vg6REsz1QKTx8w/8D4MP+i
82HpD6xeuQSDD1MPDm9LBB/kr/khCD44ftNL4OkRnL+KSuDpEZweKkvg6REW
P7D0COPDwgPGh+VfsPntiPwNAFwqy20=
      "], CompressedData["
1:eJxVlHtI1EEQx8U/DMwMygp6mEVEISERIXqJY/bQu9I00jxKzaykLrVw10oR
fFwqR4grnfnqtPN8RSlxpKVIZIkVRkFxVIQvQsLKMnqTtLu/OZcOjrsPuzvz
ne/M7pq0rPhjnh4eHkn8K35XGdN1IwcoNGeHeScaGEjeSCFzUfG9x9sZvDz3
fv1mXwqp756tfRPGIM/v5u4xTwrRPp6BpdsYeIjPDIGCk305VaEMJhx1DwJG
CehGYi9VhzAwT8X1+A8rDvN22bM7FZsm/7R/sRJwDtH+1TyeSNtUTGC6ddAQ
HMFAbMvMJlKPfheDCyL/cQJL+M/vPYrHxJ8DiqU+I4Ogt+u8Ck8R8Cq8HDk/
BfXnEFmvK41BlDhYSOCuOJDBYMGmWw3T1cinUU837j+D+l1aPAtFf3woZFR+
zA/PR/+4nwdDnEPfixTLekoVx/f4m6cqGRwWiWLxfA0DQ3B5RGoE7m/A/VuQ
m9DfAGQ7spfiUeHXDJljWe840eI0YXwXrtvQnydYTz2DxaLehwR4t38V1CgW
/VpmZcBVbk0eRL8rFOf225Z3Whi0cDld94lWXxnm6yWaHxdxXpwEnvP4syWo
t4OAnts9j7OYA9tVxXJ+qhTLfpVjP80MPon8RaiP+5ss/MzDeSrH/LkErJEW
06RFMa/WdKJC8c/9E44VVsxnxvrqUU8jnnf734fz1Yr1jmvzkdiBfvjROZb6
QhVLP5MoXF9pTO9tw3hn8T45cN5LqKbHjn4xCoGlS1/F2LCftRRmX/DBq2Va
nxq19adWrMdOwVfMcYViGd+sWPp1RLGcjwTU00zhB89ftw/1OqjmRwz600q1
+2fA9XYtX5Ye129o+lqiGVwRF7eLav5FMbi28/bXv07UE4XzfUexvL/9isVc
BQ3ge+ReH0Q/o1H/MLIe/XpNtXN70a8PmD9O8X/v3SPNj+pw9L+Nwmd+P7pD
sP9liuU9Pa9Y1mOiMPBtw6GFOox3FNfd76WRAm+3LgXwvUjA+79DvQduPf8A
sFN5vA==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQLRuVYn0/tMxhmnN3zvOgSQ4w/pICW67r1ZMcls4+
orBBrcxhy4myffLlkxyOeZt3OnKUOeQLNR84VTzJYStQfP6vUoj6wkkOViCF
D0sdgnbItWbnTXJgAIELUPmsSQ4g7QlHSx2s7/v3iqdPcqgWWef+cBdEPjx5
koMw0NiFW0sd1sgAHRKP4D+sEll3PArB/3el4qVaKNQ9e0odQMZUBUDlT0LV
+0xyaH0duEPueqnD4a8aMfyek8D+mP+s1OH9cqBO90kOj0Ee/IHg8+pumvue
vwzOL983X0pfv8zhR/DjpdLeiPCBhRcAFD2Vaw==
      "], CompressedData["
1:eJxllG9Ik0Ecx8cIhfKFSRQNsjl6MRqhBP7biv3m1tLlEq0o+iMhFQZREbU7
UqRRkmuVekPdlFpYphRoL7JJQUVFhi/M/kBEhEhExOgPlWWEo7t7fo9XbLCN
z/Pc3e9739/3Lq/uUM1eo8FgqOFf8Z//dkVGMETAMVl1rivCYOXpxa/H7xCo
b//UeK+XQenNJ4G7SQJXDq+dv/Uak8+dS+kcRw/mnLxfoLhh0eD6KQ+FZdv3
OCYHGNjF/C0UtvGFfvYxeDBt3dm6j0JGsMO94DIDg/gcpfCl//GG4ovITdr4
QBeD3nW3vs+eoiDKjDEGE5Y3v5taKMxsetfXE1bc6Q4f+BBULPazZLNiMd/n
ZzDM5cTPUOC/pqFyBrtuV2QZWylMHefCvQyeifGMgo37sNGDeqJYv4yB9CtO
4SvXm3AxaE5Wj+T2UxDbjAMDse2qYawPOH8snYVfrxzozzRJY3281J9SLPXl
0P/fm3E9na3YjzLkAuyHm8G35/667CJN73Iv9rMU16tg8LnRWVhrp9pzH4Na
4Y+DQs1IbnPSr1j3V2dfltGWeUKx8G88xLS6hTi/DfNkQ30dDMw3jtS351HY
L/IWQ73ZmJce5Bkyx9LfF4rFstWDRKvTif3heRZ5SpxVrOvVWfpVif0LE9j9
fsKyoxzrnScw+5J+vOrF/UTwvQfzGCVafnR/LxFIifE8DzyVj8wDBH6JfALu
N6H6J319ms56/2W9P4E01sfzUxJyzVPzZT9NikMurtSq+RNw6f3X/Cj2oL4S
InOU8mIe1xDtfFQq1v3SWfrdoFjqa8F6dgJC5vU2rFeC9SNYrwjX5/15KM7/
atQTxbyvQo7h/WHV7h9nN+bRQuT5HOU8KvZvUizzs1Cx7GcmAcL7k9+t/JP5
jKH+HwGt3gX0/5i63/7Nh+C/byxEpA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQrX9Xha0xstIhwnLLibJHkxyA5L75aQi+drvYzXOF
lWDa7+Ekh7hdnjxM1ZUOXjxM2uz3Jzk8Xjr7iEJLpcNqmaiU3XcmOczIE2o+
0FHpwKe7ae77mwj+3ysVL5ddQ/ATnl5Qir6M0M/WONW5+wLC/PfLj3mbn0PY
LxuVYn3/NMJ9IPntpyY5wNwP4++Qa30d6IPgT5ZgCeNzROgHeWufOcL8tzX2
pnF6CPutQPKaCPfB+DD3w/gw/4Ht00P4H+wec0T4gN3rgAg/BhDwQYQvevgD
AGy8vJo=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfUHp9s+6hkqHJQW2XOGrJjnA+Nb3/XvFQxB8magU
63jfSQ7vauxN45oqHaY5d+c895jkcMzbvNOxrdLh75WKl8vcJjl8uuSbJNBV
6cCnu2luvsskB612sZvn+isd8oSaD5xymuSgf1eFrXF6pcOH5ce8tztOcmh9
HbhDbn6lw5YTZfvmO0D5a6H2O0DVH8Tkg9x73XqSwyLXbZ//fqjA4MPUa4Ps
Z0XoB7tHGMKfDuTH7fLkYZKG8oHu2SkHdIESlO8E9Y9GpUPGxLc19i5Q/+pA
5YH+fQsKD4NKhwjLLSe+AcPjIii8jCD8Ml8EHxaeKPK1aPKdkxwmS7CE8RlC
w2MC1D49qPwUqHtg9k+bBFEHdB/In34zJjkwgIBKpcPDKpF17jMnOQCj7b6/
PJQ/a5JDNZB6KAHhHwfyZ4AiRgDBB5vPgeAbgML7b4VD+b75UvqzEOHrxcOk
zT4T6v5XFQ7vgfFpPneSA8hb+7IR6QkAGB8U6w==
      "], CompressedData["
1:eJxlk21Ik1EUx4eGic01m6MaNnWYBBH2oShb1rGQURKRQomVxSqSqBZS1nMe
E0yWiGh5V26rzAozixCJMAmRqJjRh7A3JMRMIioiikWJH4zuy3EPtMF4+HHP
Pfd//uecbK+v5ECCyWQC/hffvLGcpLoRDTaZE5Y2XGGQf/9Z9eBOhLaNTYc/
32awXJwfiecJTO8ZOs9gXv2j59frEe5mlO93X2KwiH/Gwwh7Pw27Rq8xiBSv
aizsRZh+c+prVyeD4FF+I4JgWXav3dfNoN/p/7btPULnsYKUHXcY7H7IlUwa
bBI/lx5jmb9IByEzs4tBSOTz6vDzVqT4QTuD6KstXutZHYScPQGqJ6jL9374
Db7I6zl4wmCp18vgpWt0qvaMDkl1PKKU3i/ToUwEehjcKOr7Nb1Ch2ERV8BA
T+/xTCTryr/VlO81xvjx7yW7zg38x92o9OXPvI+wmZ/PdjOobP1es74J4eRg
hyNvLQPuTr/zNN1fZ/gv4zcYLP3JNriZG53ooHw+OreTX1XENgb8dGVFNXEa
k7521CAs5gY8mUv5/Aju8a3NQQtTdbdQ/1Kpn1fV/REz9bsvnqX+ZNLzVovj
mXjp7weDP968/DQrqkGO0MO5sZB3yoRQe2jgeCCV4s1qHj1cb4WYHxvCXz5v
uVYGWb1Vla3zUfmeRvU7UPXTRvPiRHj3YrJ0n536kYlKl8Ng6bfLYKm/wWAx
BthC/jhpXxjNTwbtywUGct8W0j60kb92lPM2J0TxVqXvT4jmMQWhRCxKmEFg
waztlkRU88v3bY14f0qL8ZDwO2qwrPeLpuY7TH6PaUoPz/8Pxzm29w==
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQbXBXha0xt8phmnN3zvPOSQ4w/pICW67riQj+lhNl
++QjJzlUiaxzf5hX5RC0Q641O3iSgxVIorDK4f3yY97bAyY5fLrkmyRQVuWw
y5OHSdtnksOMPKHmAw1QvgdU/USoepdJDtUg8xZVOYCUeTlOcnhbY28at6PK
wfq+f+90+0kOx73NOx0vIfgKG4oyJn5E8MH6uarB7pvvNMnhGEi9XDXEfA+o
evNquPvA8i7VYPe/jkbwQf4Nz0LwMya+rdlfNclBNirF+r5ptYMMkI5vnwQW
t5eEmGc+AcpnrYa4fxo0vN5Cwi985iQHBhC4hODHgQLiMIIPDq8tVQ5TgeGf
PgNq3tIqB1BwtU+Dys+qcvh3peKl2tRJDvog89urHPh0N819PwERP7D4AwDQ
6ct9
      "], CompressedData["
1:eJxlk2tI01EYxtcgg5A+lBl0UYuKKCL6ZGrWq7LmNmlrlZuSFGPVwGjhh247
JxATiYjyhC0rWw4vRKVRUnZBJESjD7GiqKgYSyJrREb3TOtc3nliDv6MH+ec
533f5zlnvsfv3G40GAyF/BP/FbctqUY7hU/t/bbsdgYJHnuy//3iHZovzy33
3iljMNh6ti/LQaHr/t6eTCeDRwte/jrkpNCyJ3+qy87gSMG2t5FNFPKi9mPB
Egb3vi3ZctxNYZTrtVkZ5IqDFRS46rI6C4NAWoc55qEwbfm1Jn8xso/CqaKj
u96ZGeSI/X7Ntmxe4YDm7oza+IbDVNXh5yOinxO4bsH+gxTeHEzrGDAxCO6e
XtObjvVXMVjxemFK9aSJHOP7zXweUT70iig24Ty9BGbyNn+vYeCr/0jWXiHQ
wOvtXM1gXrk3L9pIYGjk4ufHOdhvLRnXV/MksUuznL+QwKKU6oaiXNRfSWCY
53Mzn0HW1SpffSZReRXg+gwC+3pCszt5f/2iYCpR+dmw/mSi/HcwMIifEft1
J7FHs8yTaXZyoyuDDJbWpb94+DcgOX4G/RoJyP3PzjHgaXRn/AiAsPnBefRv
WLH1AuoNqf2uZjwfVXqVYVyPoH4Y12+h/n+cuK9yv4NMYKm/NYk3MxAxxkpV
ngPr8T54lV9t3K/Tgqswj2L0u4aAmwf1fR36HdQs70OLZpnndSLfxZgZ9fuI
fA+zrHg/nmK/JfiePhCl69D3T66Xarbyfqac1Pxz42DrnEYGYdONL6N/UK8J
5/2K84YwjzhR76IZ53tOQDyLS2Hs7y4Z9zfBCT//ASHzxco=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfdzbvNPRq84hwnLLibJHkxxgfOv7/r3iIQi+TFSK
dbzvJIfHS2cfUfCpcwjaIdf62mOSAwMIBNQ5vF9+zHu7G5QfUufA1jjVudsF
yo+qc5jm3J3z3AnKT6pzeFQlsu64I9S8rDqHv1cqXi5zmOQAtOa+fyXUfiBf
/64KW2M/Jn9JgS3XdetJDotct33+u6cWgw9TD/TVvvkXEPxPl3yTBO5B+NOB
/IyJb2vsn0L5QPcc+qoR0/8GyneC+v9TLUQd0D/HQPxvUHk3qPyvWnD4ffOA
yv+B8Mt8EXxYeCLzp29F8D+Awu/gJIfW14E75H7XOvwDhofaSah/ftRCwu/0
JIcOx4SnF4D2A30ltf4cNLw+Q827MMnhgtLtn3XvoPyLkxyEmw+cWviyFhIO
l6Dh9xhq/mVofNxB8LXaxW6eu4zgg9WfrHXw5GHSbr+ECN+HwPhzvwjlb4GE
f/hVKN8EkZ4AsdwgfA==
      "], CompressedData["
1:eJxVlHtIVEEUxjcr7WEmpj3MTMuiWsL+kVg385iVuqapkZVEmhiJWJqERcid
a2WrLLE4km9ZzMwosghLeyBhUlYg9kIkwkxKIkIrNItamsdZhxaW3d+dO+ec
7ztnJjgzL+WQm8Fg2Me+/Fd82ghcyo+YsyeeguBSAkd9zjx8toVCR2DJl+Rc
Ahkf+1a8jaBwcdudH38zCMR5uhmtmygMN9d1ByUR0HIeHK8Ip/A4fmNZ1GYC
5sGd56tMFLLLvxZFGhUH3yzILp+nuGLxjFSvcQ3aego7l7N44fzPkAajLSxS
FIWu8TX77b2aqMeyHfN3a+DXGjP0e4fioVO+rTG7FYv60igsYDIan2rgXnwh
em46hQP32MorTejtz6SwzrpwoHdQA/7YmE3h+8uETO8J5CNYj5/0p/8Y1h9G
RDxbIYW73J8cInUWoX/Mz72mtp6J04qFHqviFG5sOQW2uyPwOu6voRD6LsS9
2IHvN+D7FLkR/dWQm5CzFAu/khQLP4DAsrQs8yDbv4HHD8N1B/qzFvXUUzBx
vSsJsG7/0moU834tqqTyeQiRftsVn+h0+N+wUSiLYpMShPpKUc8S9OMczosP
gRdsn/Ms1juLgIXZ7cG4ijf6jzbFwpdvikW/RrCfJZj/vSbrs6KfAzhPZaj3
jQaV0bbcEZtipjb3sF3x5K7h5qWVmG8Y56ke63HifubfE+63P85/C+oFPD9X
qdClFSgW9VUrFn62E7gWkJZ1/wr2rw/jNVN4xP34QGQ9TejXGAEj053owH5O
EnC+Pvl5dS0VOh1Oud7L6q/m9Rp08Fp/q2HUrljEL1Es/DqoWMxHKuabpsNP
lr8uicrnjIUfiZjPTZfnLx7Xp8t8eRYKt/n6TF3UdzmOAjs1TfkeuvQvFvXN
xnpicb49FQu/vBRzGS3euryPXOs+uvQzDuv3Q7bg+Q3QxTyGJmB/V2H+ZMX/
3Xe+0o+qSCp1Mj1j7Hy0m7D/n8gU83Zl9CsW8/acCF3zzRivC9dd92UHAdZu
czrgfeo6/1vVfeCq5x9K/HVC
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQZb6h2mOXfnPA+a5ADjLymw5bpePcmh0zHh6YWW
eoctJ8r2yZdPcnhbY28al1bvkC/UfOBU8SSHGXlARgRUfeEkB5moFOv79vUO
QTvkWrPzJjk8Xjr7iIIeVD5rkoP+XRW2RuV6B+v7/r3i6ZMcFrlu+/xXAiIf
njzJwRJkkXC9wxqQQfEI/sMqkXXHoxD8f1cqXqqFTnJ4B3KPVL2DyDr3h1UB
UHl1qHqfSQ4ZE0Eurnc4/FUjht9zksN0kHtd6h3eLz/mbe4+yQFIdjqGIfif
LvkmCeQh+CDv+PfWO/wIfrxU2hsRPrDwAgBh84wr
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQfeirRkx/cYNDhOWWE2WnJjnA+O+XH/M2Xz7JYdns
IwoblmLyQeq/zUOoR+dPde7OSY9E8Pl0N83ND5rkYHBXha2xtMFhjUxUym7f
SQ52XNcXF1Q2ODysElnn7g3l1zY4JDy9oHTbA6q/qcHh35WKl8vcJzl0OgJl
OhD8drGb5773ovEnQe3zgKqf3uDgxcOkze41yUG+9XXgjjlQ9UD7tn3+e6Vi
AVTeb5LDp0u+SQKLIfJqgZMcolKs7/uvQfA7QOYta3DwBKpv94Sqn9/g8Ajo
/uPOUP7UBodpQP8/t4fyu6Hm20Dtb2hwAJraK24FlS9D8GVAFuYh+EsKbLmu
p0P51pPA/nqfAOXbTnLI2lMyWSIKygfaxwACoRD/v3eExlcg1L+ukxxsQeHr
BwnfaE9o+Pg0OBwGhjO/P4IPio/jYQg+LH55QeZqYfLB7lw0yUEfFL/GDQ5s
jcAUsGSSQ8bEtzX2NtD4AKaf8n3zpfRdoeG3epJDBYjvB3Xf+kkOH0DpLAwq
vwUa/rHQ8N81yUEWJJAA5e+F8lMh/p9+CKo+B5GeAS6+VzA=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQHZVifd9fudFhSYEtV/iqSQ6djglPLzgj+LIgBbGN
Drs8eZi0l0xyOPxVI6a/ECJ/ffokh2iQ/qZGhzyh5gNevZMcls4+orChq9Gh
fN98Kf1GBB+kvb0YwZ/m3J3zPHOSw6dLvkkCbVDzE6D210DtD5vksOVE2b75
xY0OF5Ru/6zzmeTQLnbz3Pe0RrA7+F0nOXSA1Ic1OngBtbM7QNW7QfnWkxxs
7vv3TjeB2m8xyWEZyH4FBP8y0PoIBgQf7L5nDQ6i69wf/rKD8i83QNzrPclB
/64KW+PhBoeHVSLrjgPdBwyFxQW7GxwiLLec+JaEyi8rQPDB4VM1yQEc3gca
IO5vgfr/VIPDI5B5vdDwBtoHdg8wfGeAND5ocHi//Jj39nlQ939ogITPYqj/
gO6/CAyff8snOWz//PdKhSAi/tDjFwCoat3U
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ/emSb5KATKPD++XHvLcvmuTQ6Zjw9IIwgr/t898r
FdyNDiLr3B9WLZzkAFbP3OjgxcOkzT5/koNc6+vAHb8aHA591YjpnzPJoV3s
5rnvnxscMia+rbGfMcmhA2TeuwYH6/v+veKTJjlsPVG2b/7LBoegHUCd3VDz
njc4iALN/9WM4D+sAtpYheADXfFyWdYkiLlvGxx2eQIdEDvJYdnsIwobfjY4
LCmw5boeOMkha0/JZAm2Rge2xqnO3W5Q94s1Okxz7s557gB1jxaCD3avJYIP
Vu8G9Z/LJIeoFKDLAxoh7vGa5PB4KdDCqEYHkPXtAVD3xTdC3BWN4EdYbjlR
loXgg91TO8lhMcidYVB+zyQHIG9xgRtU/fRJDpeByiOsIfxv8yaB48FcFxEf
6PEFANXz2Dc=
      "], CompressedData["
1:eJxllG1Ik1EUx8foDUuRqBZBYiGRSOiHomIZB4csFxZZkFSfpIgi0g9RIyq4
N8IoQrzLPblYStaiF8TecKVstqKiD9GLIBEh0odYIZOk7AVH59571kEcjPHj
Ofec//9/z7NlDY11+9wul6sKv/r3WKJjSXlawLWmyrydtxTkOHPj+ea1SsHB
/iOhxX8FHJ5/eiBwVUHFp5JZIl/+r6/MG+pqKmZ26U8pszlfISEwz102+6aC
2OVnxT1rJLT5zh/aH1PwvrahsN4roax50YfXXQqCev5Gaea96mQ2/aJTnwci
Cj5fx4YbJIyh3l5Hwfd32HCdBO/w1gtOG/FqCW+Wf/x9KqSsr3IJ9esfvDyK
/p7+WLmnpZTZ9CthNn6KJDRqPSHKx0PPw6S/UMLjGjTYrmDXXpw8V4LG5gjN
n8Ns5s9kNn7cEg60jp5I4vn8VfeimSzlf0lBgeYJAW9Rf/Yi5TcmrN8Wvi+T
z1nmMOb7ZQfzwm7/yJ8tClB1ouOrsHkEyP+osH789DxD/apJ77iAlK7zkb9f
ArKDwfSKKgW945ODwUkBI8cXdL8A0jvD5u9B1nH2FExn3X/IS346xTTO1Zt7
vM1cdObbtvh9YecA5ftIAKpIx1CPXqOJfvLvo/qkgKVaeDXpf2L7OZvofEpA
XRwra2ifU5RvLbPO5+d2ZnP+5FT2nCP/2N/cbyvxAOkJESdtXv4wzU/Q/Tqk
r4/6tdP9xGkfcvv+kPLO7dddZlN3h9nRL0pM2D2IcL7mfcT+u/W8K9Q/SvOH
+f/gH2XF6yo=
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQLa1/V4VN0M1hSYEt1/XuiQ6LXLd9/pvi6jDNuTvn
+YqJDs8uKN3+KefqEGG55cS3LRMd4nZ58jBJuzpsOVG2b/62iQ5aMf2Hvkq4
OuQJNR/w2oHgg9XvRPBB6uX3TXTYWzJZgsXM1QFkjPbBiQ5SIPsLXR2s7/v3
ih+e6ACUDeNb6+rA1jjVmfvoRIc3gTvkWn+7OngBlbMfm+gwBSQf6wbna4LM
34Hgg93P4g7XD/afozvc/FMLgQpq3eH2g82bC5Gfvg/BB4VH+G4E/8PyY97b
t0504NfdNPd9u7vDj+DHS2evh4ZPnDvE/pXQ8FmNCE8A5o6ThQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQnfv898qPTY4OSwpsua53T3QA8y85gPnhKyc6tIvd
PPd9sYND0A651uyNEx2mSLCE8fVC+K+3Ifhg/TsRfOv7/r3i+yY6aMb0H/q6
wsFhlycPk/bBiQ7S+ndV2B5C5Q9PdNACyUs4OrA1TnXmPjrRYZHrts9/Uxwd
vIDK2Y9B+UcQfLM4oElKTnB+UcbEtzX5TnD9k0H2r3WCm/86EORQJ4ctJ8r2
yQPtB2ln4nZ2uKB0+2fdPgT//fJj3ua7EXyQ+vk7Jjo8BSl8B9E/f9NEh+uL
gR7d7gRRvxKm3gkefgCyyZIv
      "], CompressedData["
1:eJxlVQlIVFEUnSQyWiWtTFvFoqgolbLBai6amP758xfFssXEFq00w2IqacGs
jCLtFSWCaUoWkriUZKWpmFhYSJkkYWEqJhJhGWELLW+5M5/qwzBz/nvvvnPP
uffOnPgUfbuLyWRKoh/2XRh65/PPEzpEjHNZ6NpMwIG70zzKwnIIhJxN6v8R
buBwui9zuQ6l0zdsC7pKwBbvtt7soUNc3zOfjTcIbLlPd/Rq8LP94MD1UgI0
WvvBSg0ml4V1f68k4Dsq/VLIbg0GbzRLgXcImNjjpsG1vavGrLtHgN7SnVal
wnpz1WN7LYEH+y96joxWBb86AhMW37oy2K848XOfzm9Hxxg4uf9HySfdBvrd
mSff1xBYFksJNcrwkd5XXY3YX4Zn7NxtAmtYfgNWzqe6zMCcT8nf64HFBIba
5Hg3T5nzSCkkkDnlVevwPlncn4/rX2V4+GX+pom5BLyWvPEd5aeI/Rcw3/Mq
/KL6zDuD8WM0oV8GgfcaJU714+tHCRQxPxbpQvc0An2MuF2Hy8wYO8ar0IGq
VVeQSuA3ezp0kW8yrpsieT4dicjXPRIO1BV4lW81MPc31sCcfxT6265DIvlw
2CJhfUTpIl4IgYyGlsLQl5rwayX6H6DxeI9WENjM8G7ViXm8RQbmfvUocGxX
7X53M/ptV3j+18247q9wn3+ZUa8SGwSwJwjxK1nwX0WA2esyVhZ6WgjkNc2u
SD1thUtUrwRA/3UDu9JyPDvdwCzv7CFJ6GtBPV4gXo35V0miDul9MSzvfFyn
fEZwfyVnfpzftP9xUJdybmqCsd+Buc/NErD22rKZQFbOnkkZblb4Gtlb7B1N
oIURSLaKfDXM94lV9I3VUU+ywGsd99nE/lDc32kT8YKJ8K1MEfeCo99VJ2Z1
ndlqYN73gaJ/q4NRnwxN8A8j4p7nWA8S1uMwzgP1HxxtYK5nDJ4fEPUTRvOn
XeA3+inuj8P7yzVRn9swv3RNvE9APiHYP7sItLE+90KchPFLVKHvXuyPt4qo
Zzvqsccm+v8IzpsEnBfHCRzifHA+nMLzS3E+0H5esCm78ctdScTJcpxHfy86
5ocEO2k/1efg+Y8RMIPy6cozMD9fZGDW37NKsT52YPwqzDfSKnAN1m8w8m3E
ek+1Oef7coZ7FCfm82ar6sSMl+WNKvq9CfsxFv1uQP1yNWBjfGw9gbnsx0Oc
53Woz2sDc1+GDbyUjsP08TrcpO9rKH7HiM7UoYf1B43nzeelDgtZYg143oLz
rtH4P3Lw/QNmLP2y
      "], CompressedData["
1:eJxlVGtIFFEYNQsLEzRTM61wdZXMHxJGJpv1iYmkkOTeGWfEtOyJigqKmogg
pqttPu6K7g+D0MqCRIPsqZloaIhIoiQSFSo9/FEmUWJhdV/joC4sw2Hu/b7z
nXO+MaTnJJ53dHBwOEn+9Pnptf/bpfdmMH1IqNlhx/CP/izyOtwYbc262IDh
eX6D96YLa/BBHR+zZn3+s02GS/hryQubwEsSKBFdrwowhjHSrnRGgmfHXRxD
6jF8pP3fSND/c29KXa2OlyeK5tqu6TiOHN98FcNgfHh11BcJEp/sqcisxHCK
Ftoqw63cSOfJMgxsnuwkjs0YWmIe/VjuUmC62KMjlpzPo8SGFPDsiJ3+XYXB
N/Sd0WlMgW5S5p5Vx/R+Uq2OadnSOgyttN6IwuetF/VfKpwfFu97FGjflXyu
G4t+nQpku5f3xdnE++sKzN8ZjH9sE/ytCteD6Gd0KmuMzlRW63tkPdb8Yfx2
Jq/D2nnSbaJoQYW/RM8gggNp/XEVFs2zt5ttol6vCjNEnyHCt8ZOmN5VuT5k
PqYbVlfmZ3koVLk+NZjNbclWgYxrSiN+0XvFKSqEWLymRquF/1G8f1uF8Ocb
z5d9HwZKt+yhzHgNGDA4T97MjcwQ+fMVermI814Yhqj/9yX+3l3kQ5a4365i
/g06ZvX60QpmfGsRy+MvNy3PiPkRvl3Tl78v8MQQTfkHIxgg+XT11jG776Nj
xn+30O8QYs+NfqKejOA79dsg9M9DMDW6aD4bIHCz6G8U50d1zPRfWIMNEvcj
QJxPFfvhr+2rwJqerRLQeFn8hJ7ta/CIjlle5yUozejJbzCIfHvI3D/SL5UG
1STDgbCwsAeBgs8ZGQp7b/h0Bq/+fthDdb9ZHo9iSKP3ZxG/d0XgccTycqJS
1HuK4DQ1tkrM14SgiQpN9vPyXND+LSWI7ZeJ7Gd533BLDPEvh+zXcJ3gixDv
T/KbkO6mRBxGfL+xNg9ayb/2/dP25T/K5E6/
      "], CompressedData["
1:eJxlVWtsVFUQbvhRTCXVAAKhUAUflDQI/DBYmmZn+9gNW0FeoWTvY+/dQBQw
QiSKgVJs6APc7ZYThIpIeJRCQgskpAQkhCqQFppIeGgqwaaBaoQAIolW0Fg9
58ycc1L3R9N8O3Pn8c03cybFVy9cPiwjIyPF/8T/tgnRZYUVNhxcU5RVUcfg
9vrRx8Lf2HBt8q2ng0kGs9svfXTuXxvy68fcvLKNwauZ1TtKRjlwh/t1MSb9
qoodaZ/3GYOBPLvx/IcOxtnJYAV7WBk46sDgdx/fO9TEgP96e/1PDlz4I89+
bhfFy3Ex3i7Kv8Bg6d9msPT/24Uni/pbcj6n+EUx+V0Xzy/72RTD73h9rwj/
1hicmTNiWGtS9RfT/S7JnnZiz1gP3h+5+etIisHNK38u6i/zgLvn128n+yoP
IhwP5/28K/IxsvP8Il3fKU/XVyH8+wwW9O3N9DWuvb/gdO5UX38f9H6+Ojns
6/jSvtzX+Tv2jp/eW+nD0gIeqZHBSREv5cv6e7YyeLaneU3RF2gfqGXQ37L7
4kv7fFh4Orf2/iaDfzvcWX5qncEy3nyDRV8dEQaN5/lgmil+iMGUmc+0TTji
wyPxfSmDbcJ+HP0DJcTHVz7qJUh8dVE9QHx+T/UEGLw1a2vQe+jDjpLEe+8E
KH52PA3L/IUM+Fi697d4aVj5i5+b2w2eKOZxw+DWx9fnxh94cv75QPEHPeSD
1/trZeANN8uX8+8uVvr2UT+lFH+cj/oKEf/jfdjJ4/8Spn5zfDnnF8sNVvwq
rPgf4s/nc0TUN9qXOorVUH2Z9H09g3LB12OqN8GgS/xwlfhooHoOGJwl9FBn
sOR/hQci7SOu/1GCv7me3MfXEjS/mcQX19MG0Xi2h/XV0X59S/tSTftzGfct
/Imxy3lvGIpF/woL/cyK0L24HsN7ESJ7L+0v57uhiU/iLsXn+prRyzf4n5jW
F+rD0/qS92aip/Ul9fymmb/cJycdKz11Cj5/cNKw8l8sAua5Gkv+PRfr4VjQ
WVblYn+8vh+fVq08+6Ur61lVTPM4QfZS8j/nQmHf2w1NvH9RTu0FF+cbJnsn
xY8YrPhUWOlJYaUnqdt28q+heTHyryf+42gfSJB9EtYzNqXm5WjMVXO4c7vB
cj8sB/M1EH7Zwf4SFL/bxnu6heEdq6P3pIbus3pvqg1W/Q3BEZq/Y4M4O40h
4nOlrfWyVgh4nQ0v8L7/KqZ7n7BxL4Kk7xYb7xdQ/A7M38PnNy/+/NKC3209
X4lLnTSs9CHzfxBNw8r/lph/u8Fyvv1RnU/OazCq65H6GmfpeiX/0yx8H0uI
30IL34cymtccC/sNkR7nW3i/IgYrPhWWfK/9H95IfJVb+L5vpvhBC/nl+7+R
n8czBRbejy1U/+uIV39KOBf9wwnC2Ra+z0na5ydR1EFS7bvBOA+DHwi+dkex
36ThV+IEvXfRKO5Piuwjbf2+Kv0o/B+U6vqj
      "], CompressedData["
1:eJxlVQ1olWUUHqswpv1YmmJmJVjGshASiyH37O7uXvpWWY5apU793u97FQw1
jGXb0uTux3Xv7nxZbS3TpU0DlaBQJ1FTSlQkxJYgoiJr9GNDZ0S/kvT+PO/3
cruDy3juOfec55zznPPe769eEBYXFRXl5Ef93/3r4NP+TEZ9a+aV1LQIempu
W/nSxYy+nX7u7+tZQa/OKznzUSOj0ta7zp7cLOhyY2xObQuj7+snfHJMCPry
tc7JN24z9mfeEfTCrbM+29rPaEjaU12COr76feai7xhdP73u0q5uQbWfPzmu
eJTR1/Lr23oEXVHxSgITrwf5Zzis/asd1v71Af1VPbzz7vcEbVbxtwQ63zGZ
f4+q54uAZPahegG+gwGpMHuyiH8hiOrV9U8IadUd6cNeTtD+43UDvfGQpHtp
ayfsK0LyJB7ThXpzsMv8a1R/9oURP53/vMO6/ht4hM+e/LN6eAaPfn/Py0HZ
xQoexdf2ZTzKf2f68Intb3B68Yl9x+s6UG+Ga/5n2gQtVoV1G/sfzYIO9U55
9MIHnBYcnNY8ssHhqx8frep/3WEd71mHV4jLjYc8QcM7txy570PETwpSYxza
xWlU/T4B+17jH6tAPw5wo5dy9OsI+BD6OQg+MUEPzr5579RfOL1bkXllucQN
Kn7J8gKs85dhfjvCAmz9q9Q8P3VY6/WUw80jzx2cdinU8y8lxP8nNP2QfMuX
/nBq+hiu538iLqhI/d3OjX4S0MtEbvSVxDwnceqS8X9Kod7JnGQ3B+6tctj2
12Lb/zz/DeA3ntNUqYMlTeBXjN+3ol9XwDcjaEflgd/+/Qb9aIceeh3W+5J2
WOXp5SGptRzNYn+8UO/jAxnM7xH0qw37OzY0/FpQ7zD2ZSP6PWT2LfWWs+t5
N+RjVb/FSj9zPeT7MTD3Ign+I9jfBOq7ivhSX2uV0K4Fkb6MPsJIX4Py+/VT
wkhfWs+PufnrfXqpEFs9DSj/n1kBztPP+CDCOv7D4BPD/pahPskvrvRUFWg+
K+PI9zzsCfgvDKjs4vz2blm/irO+NjDzTcG+BPE9h20/LbZ6stjqSd+DGvg3
Qb+V8G+188a8MrDfYvhMytl5sQhr/Rx1WOtnNzP52rGPOWbqk/ESci2uLWPm
nm7CPhHekybo3743Gx3O2xeLPcy/lJGi1ZFEP2ezSC/t3TLT44wmqrWOg0+c
mbtTDn3NN/z6Cfd5EeYdw32rY/n3Z1shtvrQ+ef4Bdj663tS47Ce7yo/yqfn
1eBHfLS+2vyIr+5/p2/exwr0+33fvA+V2L/tvqk3CT32+eZ+eQ7n3fc+k79m
7f/wm/ae+uZ9T0MPW33T3xa8Pz2+uR+bwL/T4NVvA2eMfyoDnPbN+5zFPq/z
zXuWxTxWOmzm4bDeZw/1Zl1/Nc4AP+Sb/ckB38Si99Xqx+L/AAqwD/Y=
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQPT1PqPnAsXSH98uPeW8vmejwtsbeNA7I3+XJw6Sd
PtHh9s+6rD0P0h3YGqc6d8dMdPimEdN/SDTDYUmBLdf1kIkOcSCF3hkOW06U
7ZP3neigf1eFrbEzw+Fhlcg6d8+JDhkTgSZeRPD3z5fSv8uQCee/A9mnlekQ
tEOu9bUX1HzfTLB7zP0mOixy3fb5b0GmwwUloEsCJzrMALm3LxNiX/hEB7D7
l2U6WN/37xWPn+igCnLofig/dqID0JROxy2ZDheB+v8FT3SQjUqxvj850+ED
yL/eEx24ri8usI2D2ucy0aEXZKBGJtjd+20mOvgAtSc8zXDwAgYHuyU0PKYg
+GD32SD4N899D378Md0B5CwvW6h7NqdDwssV6v+SdAcZoDvi/aD+DU13SHgK
9GEkgg8Onww0+XIovzQdYl8LlL8Vov54D5T/Nd0BFH3tUyc67C2ZLMHiluEw
zbk75/lMWHgh+LdA/vmB4IPDxzoTon/aRIfjoPADhv8jkPn9UPcvyYTY34kI
b3D41iP4sPQEAKIaEUI=
      "], {{190.21099999999998`, 1118.616}, {
      200.77299999999997`, 1118.616}, {200.68800000000002`, 1120.085}, {
      200.516, 1121.116}, {200.258, 1121.71}, {199.84, 1122.636}, {
      199.21899999999997`, 1123.366}, {198.39800000000002`, 1123.898}, {
      197.57399999999998`, 1124.429}, {196.71499999999997`, 1124.695}, {
      195.82000000000002`, 1124.695}, {194.445, 1124.695}, {
      193.21099999999998`, 1124.156}, {192.117, 1123.085}, {191.031, 
      1122.023}, {190.39800000000002`, 1120.531}, {190.21099999999998`, 
      1118.616}}, CompressedData["
1:eJxTTMoPSmViYGDQA2IQveVE2b7537IcrO/794pvneiAwp8+0aH1deAOuYXZ
2PkT0NQj8SMst5z4FoLgszVOdeb2n+iQMfFtjf1fKN97osNWkDxXNkS9x0SH
497mnY4S2Q5BO+RaX7tNdPimEdN/SDPbYZpzd85z14kOjglPLyjZI/i3f9Zl
7QlA8MHqE7MdDn0FMoD61Q051sgUQeXdJzoAbTeNa8p2eFglss7dE2pef7ZD
nlDzAS+gex4vnX1EYQbUPb4THcL4dDfN3Y7g758vpX93CYRf5g51fxfUPqeJ
DgW2XNcXZ0DNt4f63y3bQXSd+8Nf1hMd+kEKlbMdlgAVhltB7f+fBedPBznk
GYJfDTTm4bksh/J9QIutYe6ByF+3gYbXAkh4dttB1fdlQexzmOgQClLfnOXw
70rFSzUXqPsqshy028Vu+gHd7wSyvxhqvg+CD3L/8SAEHxa/4SDz/mdi8IG2
56RPhoaPTJYDSNvtKRMdZoD8YwW1D5Z+IqHmz5roAArGfeUQvvs8qH2Ts8Dx
n70Iyl+d5fB++TFv8+XQ8AL6PxOYjvavhMbXiSwHmagU6/h10Pi+h0jPAJAT
VRg=
      "], CompressedData["
1:eJxllG1Ik1EUx4eFDQs/ZFDpWDWiBAmziKFjeeZmlgtKI4ykF6Ioeu4t06gQ
Gcjapm4Kt9IlFdL7B8UiKqVyDIyUIqiQFEyyIiJENPpQIkr35cwLORjjt3Pu
Of/zP/d51hw5XXosyWQyFfCv+H1vG57yxQh8rV7W2dfKIMFfOBcFGFSdYOM1
0wRSNzy6MXGJwfocc4clj87lfxD51ZpzH/efi0U1m8TnIYWZgQs/711lcPDZ
jiVJvRSa3WFyvIVByuDtCudHCudjbenZVzB/lMITXqaNaZ64/8rb1aRZtFkV
YXCr8OnvmSGq9NVj/TcUZnm/dXUMhPz8HgqHv7+zlQcZfJrynXzRQWGfEMrn
yx5Zm1zbqtklEkOapb5KCn/2fLt7LYj1yym0cP0/6lCPB/WHMb6Zwp0KZ0pZ
BOOZmmU9q2bpVxqF5/xYOz/fGD211G/GeAODYaF3kig/Qgy4iperh4iaz6/3
JfXUaJbxEs1/uf6MnQwqhSG9BHiXePF2BhvF/G8JTAp/C7H/AIHSbmtgzM3g
jJMrHlVsFDDw8DbTv4jch93FYK8wfgGVfWbzcR8W3C/nnrOXVyzcOp/FfIMO
7NdvzONEvtQ3rlnWNxO1f0C/Mwg4Pu9qjHI9fV57vSuTgPi7netN88df38wh
YNl/1HHIw+CACNiV/q5tGM8lqn8R1nMQSK5tdi/2apb72K1Z+lX1X9zHIDBW
0m3l9eR9v4j3awtyEJ+fTQT4NtMf8PuTJwbJUnqzGnBfNjXP8jCeX4l6Iuhf
KgGRHkrcL5PmMvkgGHMs9YwYUMx5UUT7Kzlx3+KG8q8J/b2u3wf/AJJczL4=

      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/U0jpv/Q0TyHCMstJ8pOTnRgAIE7CH7cLk8epvd5
DiLr3B9WnZjoMCNPqPnAvzwHoKh2+7GJDm9r7E3j+PIdDn0FGnRkogPX9cUF
tmL5DuX75kvpH0Lwpzp356TvR/C/Bz9eOnsPQv/75ce8zXchzAfzdyDsz5gI
VLkN4b6HVUAXbZ3oAHM/jD8B5JD1CP5xb/NOxzkI/WB+D8L8vulAC2vy4Pbf
/lmXtackD+4+GB/mfhgf5j+Yfpj/YebDwkc2KsX6/mxE+IH9sx4RvujhDwAG
P7wi
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfdzbvNORI9/hUZXIuuMzJzrA+BGWW06UBSD4GRPf
1uz3mugw4dBXjRjufAc+3U1z37tNdPimEdN/SDDfwYuHSZvddaLDqo+XfJMk
8h3+Xal4qeY80YHr+uICW6V8hzUyUSm7HSc6qLI1TnXWz3d4CLLPYaJD3/Q8
oWabfIeEpxeUbttD9YfkO0x17s5JB/JB0gfKMPlLCmy5rltPdDgGcp9IHgYf
ph5orfV9cwTfCuitff5Q9TB+dJ7D++XHvLcD3cMAAhl5Dtb3/XunO0L9V5jn
cFHp9s9/ThMdbv2sy9pTkQcOn28uUPUNUD4wPEDBtq85zwHkzFNeCD4sPGF8
UPgsK0bwPYHh11470QHk/ITGPIegHXKtr5snOtwB2VcDdW/bRIdFrts+/4XZ
3wENz+I8cHzkd010UAPxs/PA4eveDZVPznP4Efx4qXQPND4joPYB+dyg+PFC
8ItBEW2N4OvfVWFr1MyDxG8PInzBfKD5IOX2nNDw6oPyn+bB0xMAvAEFnA==

      "], CompressedData["
1:eJxTTMoPSmViYGCQA2IQfeirRky/WqHDkgJbruvhEx0+XfJNElCC8q0nOjxe
OvuIwoF8DP5U5+6cdPuJDjvlWl8HXipwsL7v3ys+YaJDp2PC0wtRCD5Qdoec
I4K/A6TeoMBhtycP0+p+KF+jAGJ+H5SvUOBwUen2z3+9Ex2028VunpMscODT
3TQ3vwdqvkiBw78rFS/VuiY6CDcfOLWQtwCirm2iA9CUxQWcBQ5l++ZLrW+C
msdR4PCoSmTd8Vqoez7mw/lCIP1f8yHumw41X6cQgw/272SoeRYFDkDna7c7
TXSISgGq3Ivgg82/ieCDw/NNgcOP4MdLpZ2h/G8FDg+B9ru7QPkMhRD/uUL5
HIUOQNmHVe5QPh/Ufq+JDu9q7E3jhAoh5vtMBOt7L1oICa8AqHslEPEJAI+6
1zA=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQbbXlRNm+iYUO75cf895eMtFBYUNRxkQgf5cnD5N2
+kSH6XlCzQfmFTqwNU517o6Z6JAx8W2N/c5ChyUFtlzXQyY6yEalWN+/XOgA
Mkbed6JD6+vAHXKfCx0eVomsc/ec6BALMki8CM7vcEx4ekEPwQfb51zkELRD
rvW1F9T80CKwe8z9JjqAlD1MK3K4oHT7Z13gRAewe0uLIPaFQ/mNRQ7W9/17
xeMnOjCAQB+UHzsRoq+jyOEikP4XPNEBZE1gRZHDB5B/vSc6GNxVYWuMhdrn
MtFhK9C4+U5FYHfst5noMFmCJYxPscjBCxgc7JYTHWaAwuNHIZxfDXLfGQQf
FBz+ywsdQMq8bKHu6YCGl+tEh06Q/zMKHWSACuP9oP6NLHQAiirdjkTwweGT
gSZfDuVnQu1rgfI7IeqP90D5KwsdQNHXPnWig7c50MaLhQ7TnLtzns+Ehhdj
EZwP9o8Wgg8OH58iiP5p0PADhv8jkPn9UPc3QMOjExHe4PCtR/Bh6QkAojMI
pQ==
      "], {{281.10900000000004`, 1118.616}, {291.672, 1118.616}, {
      291.58599999999996`, 1120.085}, {291.414, 1121.116}, {291.156, 
      1121.71}, {290.73799999999994`, 1122.636}, {290.117, 1123.366}, {
      289.29699999999997`, 1123.898}, {288.47299999999996`, 1124.429}, {
      287.613, 1124.695}, {286.719, 1124.695}, {285.34400000000005`, 
      1124.695}, {284.10900000000004`, 1124.156}, {283.01599999999996`, 
      1123.085}, {281.92999999999995`, 1122.023}, {281.29699999999997`, 
      1120.531}, {281.10900000000004`, 1118.616}}, CompressedData["
1:eJxTTMoPSmViYGAwA2IQbct1fXHBwWIH6/v+veJuEx0UNhRlTFxf7BBhueVE
meNEh6sVL9UM5xU7AHn75O0mOpTvmy+l3wtVbwOVryl2OPxVI4bfaqKDdrvY
zXOZxQ5ePEza7JZQ+TAEf4dc6+tAPQRf/64KWyN3McRc24kOHg+rRNa9LXLw
BMq3u050YACBC0UOCU8vKN32hdp/sMjhENC+/ggE/9+VipfLUhH81TJRKbuL
oOZdLHJ4v/yY9/a6iQ7LZh9R2PCpCOz+6Z0THdxB8sJQ/06B2mdX7DDNuTvn
+Uyo/kIEH+y/iQg+yJi8NcUOSwpsucKnT3SAhSfIPvNJCD7Yv4sRfD7dTXPz
10L1H4Dov74Zyt8H1b8Nyt8DCf/5OyY6ZEx8W2O/s9gB5Cz3XRMdcp//Xvlx
SzHY/2q7JzrMyBNqPrABat8eaPiuhvpvDzR8liL44PiYhyY/tdghCCSxG+r/
Tqj7dkHd0wL17z6o+o9Q/SehfOYSDD7YPQkIPigc/UKh6YOlBOyf435QPluJ
w1Rg+Kb7QPkcJZD05TXRISoFGHPcJWD3ZXtA448fap87VL1IiQNbI9AEN6h6
yRJ4+gbbL4/gg/2vhuBrgeJXv8ThLyg9uUHNty5xeARyH8x8B4h73V2g8pcR
6RklvoF8AILeeP0=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQbct1fXHBwWIH6/v+veK+Ex1Q+DUTHXh1N819vx/C
n94w0aF833wp/d3FDmVAen0LlL+52GGqc3dOegeUv7rY4d+VipdqPRMdDn3V
iOlfUOwQYbnlxLc+qPmTix2WFABZEyY6HPM273RsK3bImPi2Zv8kqHxlscOH
5ce8t0+e6JD7/PfKjzkIvuKGooyJoQj+jDyh5gMOUPdOnOgAcmaeHtT8bqj5
YsUOQTvkWl8D3XsV6CxDrmIH7Xaxm+eqEHxPHibt9lwE/0fw46XSCRMh6kSh
5oVC/adb7PAeZL/fRIels48obHCBho/7RIfpIPfEFTt4Ac1jd4H6pxrBVwC5
fzKCD/bfqmIHtsapztzuaOEPjA8ANLa7Uw==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQ/Xjp7CMKE0odrO/794pvneiAwp8+0cHbvNMx4SkO
/gQ09Uj8CMstJ76FIPhsjVOduf0nOthyXV9cMBnK94bKz4Kq95jokPv898qP
C0odgnbItb52m+jg8bBKZN3KUodpzt05z10nOrytsTeN24Lgl++bL6W/F8EH
qz9a6nDoq0ZMP1C/bFSK9f2zUHn3iQ4MIHCt1AGkzN0Tat6dUoc8oeYDXkD3
VAOFHz6Ausd3osOWE2X75n9A8DMmAnU8h/DL3KHuvwW1z2miQ+vrwB1yJ6Hm
20Pld5Q6iAKN/WU90eGC0u2fdctKHZYU2HKFW0Htn4LgX614qWbYgeAfAwV4
TSnEn9ZQ9xRA5K/bQMMrBRKe3XZQ9TFQ+xyg6sNKHf5dARrsAnVfYKmDdrvY
TT93qP1+UPN9EHyQ+48HIfiw+AWbJ4LJB9qekz4ZGj7KpQ4JT4E+nQL1jxHU
Plj6cYSaP2uiwzJg8GwIgIbXPKh9cZD4z1400eEdiJ9V6vB+OdBny6HyQP9n
Au3ZvxIaXxWlDjLAeI5fB43vZkR6BgA3TVWu
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfeirRky/W5nD++XHvLeXTHR4W2NvGgfk7/LkYdJO
n+igsKEoY2JwmQNb41Tn7piJDp8u+SYJ5JU5LCmw5boeMtFh2ewjChs6yhy2
nCjbJ+870YFXd9Pc98vLHB5Wiaxz95zooNUudvPcaQRfqPnAqYWPEXywfT/K
HIJ2yLW+9oKaz1UOdo+530QHd5BC6XKHC0q3f9YFTnQ4DHKvVjnEvvCJDmD3
m5U7WN/37xWPn+jQ6Zjw9IITlB870SEqBciyLXe4CNT/L3iiQ+vrwB1yuuUO
H0D+9Z7osBNobaAQ1D6XiQ5AXy0u+F7mkDHxbc1+m4kOsiADrpY5eAGDg91y
ooMiKDzWIvgeIPc1IviPlwIDJKbMIQ/oUS9bqHtsoOHlOtFBGOR/2TIHGaC5
8X5Q//KVOQBVKd2ORPDB4ZOBJl8O5ctB7WuB8u0g6o/3QPlxZQ6g6GufOtHh
asVLNcO2Modpzt05z2dCw2sbgg+O3/sIPjh8GMsh+qdBww8Y/o9A5vdD3W9a
DrG/ExHe4PCtR/Bh6QkAWP0Qcw==
      "], {{356.40999999999997`, 1118.616}, {
      366.97299999999996`, 1118.616}, {366.887, 1120.085}, {366.715, 
      1121.116}, {366.457, 1121.71}, {366.039, 1122.636}, {
      365.41799999999995`, 1123.366}, {364.59799999999996`, 1123.898}, {
      363.77299999999997`, 1124.429}, {362.914, 1124.695}, {362.02, 
      1124.695}, {360.64500000000004`, 1124.695}, {359.40999999999997`, 
      1124.156}, {358.316, 1123.085}, {357.22999999999996`, 1122.023}, {
      356.59799999999996`, 1120.531}, {356.40999999999997`, 
      1118.616}}, CompressedData["
1:eJxllG1Ik1EUx4fEohcqSjIizSQi8EMQhNSQnTmXuRHlglZSTkRrkZZKei/D
1mTpWpvVZcy3iijKPhSjD9asKAeJRlFoBBEiZlIRZYZR1Ieke+9znm60wcP4
ce499/z/59y7puKosyrNYDA4+Sf+998rXpg2TmDP5t7Hja0MlgWSTy7Po3C1
Nn++K8rgS5N5U9lGCm+96fGhLgYeNtVk3qs4umLO7kU1iievnR/I9lHgWXOD
nQyGc0Z/+SIU7JzntjMIWcrfDXdjnOcfdOSFLD0UnH1ZLYfPMug4sjSQjFP4
en3QkQgh91I4xM/tb2EgynyYoDD7kn7sOaE4Zg1XHySKpZ6dioXMG3YG2bfq
PewulTr6t6KeBxSmxXmFDGZebK9YkqRgbI5ZF1jx/AEKN1eVVt634PqnFCaE
XmCwReQfocBV5YyaGeQGl79+Pob1cN4wttbYPJ3Kwt9XJgZlojBTKuvrR4R/
Bf/t36W4tNI0vsON9fJ6DOJ3APtnQb+rUX8B6q+jwHe1dRSi/8c0zihiILC8
AXkb5mvU/MlzKNb91VnW36BY2LLah/NUp/Vr3UkGV2x3vv32UGjn9X8IMuBt
/1RSjv0Mo58lOB9t6He+YhnPVCz3zxKtPj4v+jxLfX7Fer06i7ba+TxMifl+
QyA9XjTh1edhkmjzamPgFYH3BB59X79vsRX1fSZwm5dxyYL9mdHOTwDq+0k0
P8zor1H1a0jwylTW+y/1VZEU1tdLrlEs8/sVy3mNoH5APVFN/w/e/0wxMF1a
fpcN4xfxvGLFul//xl31iqV/x/H8C5g/gHq6cX0rxjuJdt9OMeDd6suKEeDX
yeQ+jX6dw/6FcV6x/owIzneQaP2O4HviVyz3U8Xy/tZi/yLKP8lhfA/c6M8Z
jD8jf98vfT50/gOSX0B2
      "], CompressedData["
1:eJxllF9I01EUx4cvRfhUViC2yoe9DIyKEJ22Y7Eylca00dBQiUVLaylYen+K
0R8rG4uu4jYxsKzsoTAf0kRr9mBaEVEwjQoyLYpR5kMQJSjd+/t9x4UShny4
55z7/Z5z7m/jwePFh5JMJpNb/OT/T7e6xjYsMJrVUvomOjkleP72eOEDjVNj
St/ume+Ke8Vx/ywjT9b9pyfPccqfEYmTjGzTzuDaAKd1pV7b9BODw5c5TTbE
LZsHGYno6Po21O9hFNoZOPq1ndOqs4+fX29V3PLNNWSuV6zH+xgN70lOuiPy
ZZ3uA4aezCuIdzE6wueaRoOcCjNb8yoLGRUkJ1mXBf7hi4qtF9a83Sv0r5T3
O6HvNO7zwF8zJ2nDX4n6jZzqo92pm2qZ4bOB048m+7byS4xu1uSueHMC+sbQ
Lz+njzJ/wdBv9eH+1Rq9Sn//p7lCsR6/T3HxkLmluohTxC8ULtfoblqpd8QB
vfOMFmMN8V7CfVOMmqse1rXbOA1IHobfLMR3KfYJH/YWxdJmtBqcjX46wTmc
xqWgXYxE1dR7OTi34zwX88tSLLpwo2arYl1fBvwn8q3obzb6bf6f9fwyFZ9g
3d8WZvTDhf0k9LsA++c26v1y4LyKGb7zMK8z2K/tnOYkX1Usr+/vU6z7e4R8
gp5nqL+DU1jOJ8ZoRO6nA/reIT9fsT6vIsVSv80FvzG8HzfqT2C/PZwmZP+H
jf3aX4Z+XmMkry2oQL6GfC/mXYL99MFvNjP29hj8ZqCftThPN97DyzqcpzH6
XSIqM8Udws/hU4p1f+ehx4L5BqHfBv1t2C8n+hfGe6hS3xs9PqBY73en4nL9
4TN6Ld7LUgTvYxT7Iur1OAZ/Lr4Ah9CPKcynQ/U7wfq8Pig2yb9Z9CcEf58x
L8Ga3J8vjJYEW8L43sURH1Hfx4Tev9H6cp0=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQHbvLk4fpf5XDoyqRdcdnTnTYIdf6OtCsGs7feqJs
3/ykagegKu32KRMdGECgpdrBC8hn75rocEHp9s+6BdUOh79qxPA3TnSYnifU
fGBdtcNDkP4yBP/flYqXatkIvug694e/kiY6AJW5P1xW7fB++THv7VETHTIm
vq2xn17tsKTAlis8aKKDwoaijInt1Q4RlltOfPOE2l8EMW+ZM9T+sGqHqc7d
Oen2Ex3iQP6xhtpnDfWPDNS9lhMdLoLU/6qC84GuObXwMIIPNn9GFcRcu4kO
+ndV2BrLq8D2lwHtf7x09hGFmCqIe4Og9vtVOVjf9+8Vj0XlT89A8INADimA
+j8Mot+8EurfdKj5wPCTiUqxvg+0LxMovr9zooMVUHhfb5WDLEi8f6LDDJD+
FVXg8Lk+eSJEHOj+fJBHpk90ACmf/wARn+jxCwBfMOJE
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPSNPqPnApyqHh1Ui69wnT3Q49FUjpv8Jgv+2xt40
7lqVwxqZqBTrSRMdjnmbdzqeqHL4d6XipdqEiQ6fLvkmCeyqcjgM1MffB9W/
rsphqnN3TnrXRAerLSfK9i2Fqm+d6FANNPbhnCqHaUD55/UTHS4o3f5ZNwMq
X4ngg+ULUOWXJU90mCzBEsa3uMrh/XKgSyKg7tlR5WB93793ut9EBxA34WyV
Q4TllhPfXCY6ZEwE+uAl1HyHiQ6WIPdwV8P5ihuKMiaqIvhA3U8vWFU7gILl
lNNEB/27KmyN3tVg88U9Jjo8Xjr7iEJMtUPQDrnWbF+o+1KqHdgagT4OQ/BB
9pclI/i7PXmYVhdDwycMqr9hogM4/IH2fQD6Z3vnRAdQMN9Xh9o3Acrnr4bH
B3p8AQABKdlQ
      "], CompressedData["
1:eJxlk11Ik2EUx8cghWULTAisrCS6ibAuQmqIR1fNXJAfF0lSWRiBxRSkD3oP
oaz5tTV6Kj8iYkRlULAikqRoeBGmXSklu+hDV0SJhHVTdtHqPM97xoEcjPHb
Oe95/uf/f971R5trjjkdDkc5ffWvlRf3paoQPp7Li7+8piDDKWJfSIG/uLus
oRnBvfnRjfnLCu5cf7HuYVT6dVsqLrzl/Yas9ufCK4Ijr26OI/x5c3Z2cEBB
aK56uOA1Qq83fPJ4n4L+QG5w5B3CmUQsv+gq96cQhsZOJ2JKeP7uqP9JVPgx
1ddGFHzSgj6wvm6en0RI03kbuxSM6gUmEBo+TxTWdyhw6M8YQt12mkD7fcPS
bYcSwkbHkPCA1ncP4VctndTB82MIfaT/C83P1XqusP4w18MIt1tKXPsjrDck
bOa1CRdpvyyEZ3tynPfp+TUHGj3Tp7jew3qb2I9OBRU6mIO8X1DyMnpQ2NSr
hRdI/6q9nGctgpZRWcH71yF81/7u4vPrEWqGC0JzXmX7esTmE+XK1tFk51Fc
pqDElbzV0oowWfj2d7qU82jjfIl1TrFLi1nvl/TweVPWIs70G31fhc38n5ad
P7Dffy3wTO+72E96dujCEoSn2k/SO0N/B1wIq2nu4Z3cv4zv024F+rGAm/X4
uL4cIau917vUL2zyqBI2frX+Vz+vYIps3+rm+36B9ecw0/0Z1O8P6SEX8h90
cf7Ztt5NPZyXE80+K8P8fNqy9UTYvwULdHtn5n79EDZ5zAobPTMWVBJnR8Rf
w5n7Nsn+RdlfkPf3Hz+J5kE=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQbbXlRNk+xjqH98uPeW8vmeigsKEoYyKQv8uTh0k7
faLD9Dyh5gN8dQ5sjVOdu2MmOmRMfFtjr1nnsKTAlut6yEQH2agU6/vOdQ4g
Y+R9Jzq0vg7cIZdc5/CwSmSdu+dEh1iQQe0IfodjwtML8xB8sH2b6xyCdsi1
vvaCmn8U4h5zv4kOIGUPr9U5XFC6/bMucKID2L1PofaFQ/kf6xys7/v3isdP
dGAAgX9QfuxEiL4fdQ4XgfS/4IkOIGsCX9Q5fAD513uig8FdFbbGs1D7XCY6
bAUaN39THdgd+20mOkyWYAnjm1jn4AUMDnbLiQ4zQOGRgeBXg9xng+CDgsNf
vM4BpMzLFuqeH7WQ8HKd6NAJ8v+NWgcZoMJ4P6h/T9Y6AEWVbkci+ODwyUCT
L4fyb9ZC7GuB8n9C1B/vgfIl6xxA0dc+daKDtznQRsc6h2nO3TnPZ0LDqxDB
B/tnFoIPDp89UP3ToOEHDP9HIPP7oe7/APVvJyK8weFbj+DD0hMAO+wQGA==

      "], {{480.10900000000004`, 1118.616}, {490.672, 1118.616}, {
      490.58599999999996`, 1120.085}, {490.414, 1121.116}, {490.156, 
      1121.71}, {489.73799999999994`, 1122.636}, {489.117, 1123.366}, {
      488.29699999999997`, 1123.898}, {487.47299999999996`, 1124.429}, {
      486.613, 1124.695}, {485.719, 1124.695}, {484.34400000000005`, 
      1124.695}, {483.10900000000004`, 1124.156}, {482.01599999999996`, 
      1123.085}, {480.92999999999995`, 1122.023}, {480.29699999999997`, 
      1120.531}, {480.10900000000004`, 1118.616}}, CompressedData["
1:eJxllGtIlEEUhrclDO9RkhJlZmCRLGEQlZp7dL2sG93WSKl+hBmFmBbEahLN
iJmlpjsutpCEP8oiCu2elImVVESIURHRj7ALIhEWXTQi6cx859vJdmFZ3p05
57znmTOzsLjCvctqsVgK8Ct/9478vvA1gUHa2w0nYv0COtsHEi4/DdZtjsay
3T4ByfVzXg/e0/pl1WhSym0G7p74uk+tApzD1TFdNxgUrb7++KcQsLUEM11h
EFLT5ghHXdnXMXdZN4Oz+9aEvWqZqgubtR47/3DtrSYBS2W9awz2iM+H7A20
fpfyHxVgkZ9+BvNloToB0samASN+5RHy94T215D+YPTnrxRQ2nvAFzeNB9bV
/2Fc+W08JuD5uuKZRdEcPFi3u0lr1X+z1ooL9vNF1o3i8Czxza9JrwD593g4
D/BYgPZ6QnmAl6ofwgM8TT//a/M8zkhuGcHa3K84reIGJx/1s5xD+azafhfW
U9xt3ODrJf+LDX8e7Ofmtz8vquKp/+PC4Dhb85Hpyr/Tee0XIHH3YDxGjZ7b
KGCePAesN17wvrPdSf5SObzDsXjkID92DpO4PymL6mdzyI+wJteDgCHkdtjF
YULG26l/N/X3j1Z9pNF5TrAgbe5X82HV8dhlXwfyfvBjyfZooPMJpfVMYfiI
4LDj41DitiziFWnw9jum6tgcrVXeXAHpch/mi+nKG6526fMz+Zj3SfVfQn5b
WWBd+eXM4IfxZfJ+ehi40NeMPK1Pot+RHK3l/K3PFhBlu3p67CDdB/QfKTWj
ec+k9TpmzANQfDOD+8ijBfmo9+CU5mdqk2+evN+LgrW5X913G4NLOAh3UKdK
MCsoP1C+dPKfSfVzDf+DDvJbyOCijHeSrtB81Pz10vtUqvtXPGtp/ncSjwbi
uZnym+9LPuXz0rxlMOO88H744qZviUrR75v5Ppr6L3+QZRk=
      "], CompressedData["
1:eJxlkltIlFEQxxcfKkTM8rKUwZawIlhET7F4aSRCqgehh+yiEUsXDdPNzEp8
mO222WrLgXQVWSo2E0NKKtKXDLTaniIjWKSHqAiTCIuwqMCac75/HGgfPs73
Y8785z9zZo2/acfBNJfLRfLpc2tGWnGommmbnIsvK1p7NzY3GGHq3hxuONyn
6G1bzu3KaCqb++cU3ex/vHrkGtPkfFHN0k5FtZGJ+aJbTCfHr668o6B3j6lH
8meuKKrR8YdMC69OzRb2ghNM70Q3Ifrr9P0py6G86ec/3lueG3y6feM3R399
jyKp3lz3B34i4MwgDa/ac6DkgnLq5gapWAu1WdZ9JBosm/xacEaQpgpe/1yo
UqbvmV9MX6Tu6Bb4+cRUpz63byqDn2nU96HfCcsdFfs/vBizLK7eVI0w1Uv+
Ix/6H8I8SlA/Di5VlKkHEmO6/6x13FNu5y8qXe4KyzcCZenV3v/iHkWnZws3
LOll0jYK8pXxEepj2uUTxRWI9zN5FwW7J92YfwzvnafoiZ7ndXAu+h0A58D/
MN43G+//IJVNXpYis287U/nffcN7LWdpo36mj7+Hvr7Mht96pq5o4/KzUl/v
RWWj08938bdM/wQc/VHxP6D3sxl6buS3sFNH+i9PT8YDJzDvfPhtZWeOHssm
32vZ+G+3bOZ9RlGpnFHRM/t2Hv20YF4h8HHsQ4cy75Y8xs6+XkK8CfGwcvb8
KPTC8H8E9TvBhyzHtZ7f8kX98Puwb2Hs125nX5JS7y+YdMr0
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQ/bBKZJ379AaHf1cqXqrVTXSA8a3v+/eKxyD475cf
894eMtFhSYEt13UgXzYqBahkokPlSzVDjpkQ9dN9JzosBsnPanD4AFLvOdHh
iMKGooz5DQ7a7WI3/dwmOuhsmvt++bIGh6nO3TnpzhMdpgHp52sbHIC2PKxy
gJq3vcHBi4dJm90eyj+E4F/2TRKIOI/gx/Yf+qpxq8HhR/DjpbMdofY9agC7
+zjQvhiQ/NsGByAZ0w90nydQX/sniHrpcAQf7J5kBB/s3kKoeW8aHNgapzpz
10DNewD1bzPUP9cbHDImvq3Z3zHR4TDInrMN4HAK74b67yCCv+3z3ysVuxF8
sHlbIeZ3d00Eu+P5ugaHCMstJ751QP23qsEhE2R++0SHR6D4WASNrxZE/MDi
DwB6+djY
      "], CompressedData["
1:eJxlk1tIlFEQxxcfCiwiIiostHzoQlSQD4vZtrO3LNco7SGpqJAuYpbChlks
C8O2u5/uaky2uhGLkKVEFyNKpUKionoKu4BED1ERERJGEdZD0pzzzXIgH5bl
982cOf+Z/5xltY3Vh/IcDoeXf+rf8hz4PHoY4ePp+TefXSDI8Qfm8hjBj1fb
auc2I8xZczs7cY6gKDZeNRwz+a0qP23405WLT5ZmDZ8c6SlY14vw903L174M
2XX6EdK+ZMORLoLM8XnRh9fRzjsv+QMId583j/SQ4Yn+p8GhDsN3OF6UItiU
P9bbdEP0tUr9qwhTfN9yi2C0+N2fSB8CqyzeEyeodLLiSwg1pVyB+3v8a+Xe
s1nDiQVvX0xmDHcrfZ0Ikzu5s7jUb0foYv1fLNFjif6kxKMIl5tc+btSEkfD
ul7EsJ5XGOH+1tl51/j87oNl77efkngbQVDpDck8EqTn4Dwm/UWNX1pP2LCO
Vxn+zfoXV4qfdQhKRsUWgkeq/3qE72q+Abm/AaF6uDA27iN4zek1jTYf9RIo
ubdCth9OD0H9gxOdi1oQXvKcp9wELuVHRPx1S358Oqv+xsrkvlXTOZev9a03
rP0uFf9B5u1C4FPt3aynjr6F3R6Ee2qerFd/9yEs4cL7/ZLvl33aTLBRxQNy
f7nEmWdg2jcraFj7scOwnlfov3iEYOgnb3pA9v2M7JdfmPenUL0f1sNuFgxY
4r/X1ru6Td6T2+5nYVLOu0RPSua3AUGlJ3L75TSs/SgxPKj0rEWoYJ6ZMvPV
nNu3FTK/DvFvn3m//wAgB+mv
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQLRuVYn3/RqPD++XHvLeXTHQQjLDccgLI3+XJw6Sd
PtHB27zTMeF+owNb41Tn7piJDltPlO2b/6bRYUmBLdf1kIkOfLqb5r7/2eiw
BSgu7zvR4fBXjZh+ziaHh1Ui69w9Jzro31Vha5RG8I8obCjKUEfwwfYZNjkE
7ZBrfe01EWzOfKsmsHvM/SY6AG1ZXODc5HBB6fbPusCJDjIg93o1QewLn+gA
dn9Ak4P1ff9e8fiJDgwgEA7lx050yJj4tsY+pMnhIlD/v+CJDjH9h75q+DQ5
fAD513uiw/Q8oeYDdlD7XCY6gIzzB7oHpG+/zUQHUDC0KzQ5eAFpdktoePAg
+GD3fWuE83WAwbH8caMDyFgvW6h7rkDDyxXq/yONYH/E+0HDc0+jQ8JToA8j
EXxw+GSgyZdD+Ueg9rVA+Vcg6o/3QPlPGiHunjrRYdlsoI0/Gh2mOXfnPJ8J
DS+BJjjfB+QfVQQ/FhQ+Zk0Q/dOg4QcM/0cg8/uh7g+A+r8TEd7g8K1H8GHp
CQBLugqc
      "], {{571.109, 1118.616}, {581.672, 1118.616}, {581.586, 
      1120.085}, {581.414, 1121.116}, {581.156, 1121.71}, {580.738, 
      1122.636}, {580.117, 1123.366}, {579.297, 1123.898}, {578.4730000000001,
       1124.429}, {577.613, 1124.695}, {576.719, 1124.695}, {
      575.3439999999999, 1124.695}, {574.109, 1124.156}, {573.016, 
      1123.085}, {571.93, 1122.023}, {571.297, 1120.531}, {571.109, 
      1118.616}}, CompressedData["
1:eJxllG1Ik1EUx8e+BOGHiqiIMutDBCv6OHSzjoVUaxVa0rDAkEXrzV4w35JZ
N2fKmO263JTKiDQJyyTSLMOkTAXLXhyVVqwXKiLEQHr7kHTvff7jQg22Zz/u
Off+z/+c+yzMPZC502wymbLEVz4bD6ZOffGR0fuSma399ZziPN7ct/5mCVdP
a0zzh6YzvUmjjFzJNwYKyjmJ3+7zw4xssU2B2X5Oib6vGZ2DBkeqOc3Pdtti
95mKW1CD/W8xCq/27/sc4mSXcVc1D2/IneZq1KzizzK6vS7B3CLy99zJD82J
GHqsQcRzRrv5WOndAKeOiT/RompGjgSzZYr/H67UbDk5a2RjOc4PQt9xnHca
9Xk5meSnHvsf5eS0VqXtuMCMuoo4iW2Gfgr9Ku8I9A3CrzzkfzL0Wzw4f4LR
k0WvfntzNKv4LZozOxN9e52ctp+6933JGKMr87LdXenQ+5aRiPpyiXBelJFX
/rGB+1BvMjf60KG5N6ntsKdF89Lr58abG8Ap8DMItnOjD35Gostzr9mxXon1
VOjxaVZ1Mc1KzzHUL/KjMt8Lf1Pgd+H/rPK36fg4q/0Y/MjAfFbBPwfmL2Ts
90P49U2ui/o8on8r09Cvy5ivFeAOzWq+ezQr//qRT6j/EfZfhf6I+e+S85kO
fc+Rv1az6pdTs9RvE/ovynqf4f5kYf+HmG8X/H9gzNfWeP3i/uTNONHjyIFf
Tch3Q28N5tOD+kR/CkX/lu8Hl8HPQ+Bi4z4M5YMLGP3aLJwo1lwrdOwq06x0
VUBPKfobQL8qoF/c12VyvoLwL4L70KDfNyq+VbOap3bN8rmmm9FTMVeTdbgf
A5gXsd87uf4YHIYfw+hPrfY7zqpfLzVPl39G4E8Y9Y2iX2HM12tGk4IXi/Pa
5fvuDeLr9PsxrvcvD+eDbw==
      "], CompressedData["
1:eJxllG9Ik1EUxsc+FIRBRGhZthZawpBZRKZudkyEnFuiuVpaLMylTVuWmpvK
RK4rY1ldxWlE+EGzD0VFBEmGRUX1KewPREQERURECEFRH5Luve8zLtRgvPx4
zz33Oc8557XWHakKmE0mk1f85fP7C0/dkhijD53Lrj05zynJc5cfl9/u5ORc
9Hq8Jar5pXjtizDy5d96eryP03iLiDjGqPB9xUBanNPinJsX54IGj5zhFLzb
NrT8ACMRPWMZRP49jBIl8ebPQ5xOFe//NOvW/OBH9t6zJZpVvIPRnbIU8xVx
vrZeZN5s6Mk7x+mhjM9ldIh/6743wGnywqM1N3IYuVLMtoXxf7hfs+1k6psd
fbjfDn29uG8T6oty454tyN/FySHrIkYZNUJImFPHzFi63cNoQvrQDn1B+BXC
+Zih39bI6ZK8f5DR7Nq3v6N+zSq+WnPV1OpYk5tTeZ5QeJrR1VU19dOl0NvD
6M+r8JdJ4iRlVLQyikqjC8EB1JuPeK9mWeeYS7OqwwkugP92sIPTRynIxkic
Sr/uwPv1eO9E/kzNltjXyimrZqXHgvod6FcG/C2A32n/szpfq+OTrPJZ4Ucl
5jMb/rkwfxuNfD+FX0XyvaivUfRvazH6VYb5KuIUlrxLs5pvv+Z+Wd9BnCfo
aUb+bZzcsj9i/qflfJZCXzvOb9es+uXWLPUXVqLe5P544W8T5tsH/wPGfO1O
1u9jFFrK7rv8OF+K8/XoxwbMZyPqzWLG8zDYAj+PglcY+/CsDX6kMvq1U9wc
0Tws6mno0azqOwE9K9HfAfiTBf2DmC87/BvBPjj190bFezQr/dWac99lLujd
x+i52Jf5UexHA+ZF5FN7FAIn4Ecr+jOs/U6y2qcOzSb5i8CfBOrrRL8SmK8u
RvOC14n71J53I35Ufx+Tev8CE9ZY0A==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvfVE2b75d5odIiy3nCg7OdGhYt98Kf1HCD6v7qa5
7581O4isc39YdWKig0xUivX9V80OnjxM2u3HJjoIgBS+a3Y49FUjpv/IRIcZ
eULNBz40O5SDzDmE4E917s5J34/gfw9+vHT2HoT+98uPeZvvQpgP5u9A2J8x
8W2N/TaE+x5WAV20daIDzP0wfuVLNUOO6wh+JkjfJYR+MP8cwvxooHX+pxD2
e5t3OiacQLgPxoe5H8aH+Q+mH+Z/mPmw8IntB8pcQoQf2D/XEOGLHv4A2XvJ
1g==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQnTHxbY3922aHR1Ui647PnOgA40dYbjlRFoDgg+j9
XhMdKl+qGXK8a3bg0900973bRAegqn3z3zc7ePEwabO7TnR4CDTH/WOzw78r
FS/VnCc6TM8Taj7wudlhjUxUym7HiQ4MIPC9GazuuMNEh+gU6/v+v5odEp5e
ULptD9XP0OIw1bk7Jx3Il40CKuDA5C8psOW6bg1134ZmDD5MfUz/oa8aOxH8
x0tnH1HYD1UP4x9qdni//Jj3dqB7yvfNl9I/2uwAdFXvdEeo/443O1xUuv3z
n9NEBx/zTseEk5Dw+eYCVX8ayneDmnem2QHk7VNeCD4sPGF8UPgsK0bwPYHh
1147EUIDzQvaIdf6uhlq3ymoe9smOthxXV9cALO/AxqeJyDxkd8F5R+DhK97
N5R/pNnhR/DjpdI90PA5CLUPyJ8BcuheBP/TJd8kgV0I/uGvGjH9W6Hx24MI
XzAfaL7BXRW2xrXQ8Oqb6ACMxZ91TxDpCQCZZxXZ
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQnbWnZLJEZYvDoyqRdcdnTnSYkSfUfGAKgj/VuTvn
+aoWB08eJu32KRMdrO/7907f3eLgBeSzd010WFJgy3X9ZIvD4a8aMfyNEx3a
xW6e+36hxeEhSH8Zgv/vSsVLtWwEX3Sd+8NfSRMdKl+qGXKcbXF4v/yY9/ao
iWDa/GgL2NzwoIkOPuadjgl7WxwiLLec+OYJtX8TxLxlzlD7l7SA3ZluP9EB
7J/pUPusJzpMB/mnHepey4kOi0HqyxD8IwobijKiEXwbkPmuLQ4XlG7/rLOb
6HDZN0kgwhRifxnQfp1Nc98vV4e6Nwhqv0IL2F3isaj86RkIftAOudbXBVD/
q0D0m1dC/asLNR8YfiB3tAPty5z4tmZ/50SHbZ//XqlwaHGQjUqxvt8P1e8L
CZ/rkydC4gXo/nygN09Nn+gwDRRfmYj4Q49fAGww5hQ=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ3S5289z3ohaHh1Ui69wnT3SQjUqxvp+N4AtGWG45
kdLisEYGKDFpooN86+vAHbEtDv+uVLxUmzDRYcuJsn3zw1ocDn/ViOHvg+oP
aHGY6tydk9410WHb579XKnyg6lsnOlS+VDPk8GhxmAaUf14/0WFJgS3XdVeo
fCWCD5YvQJVfljzR4fHS2UcUvFsc3i8/5m0eAXVPaIuD9X3/3ul+EyHuTmhx
ADn7m8tEhw8gdXlQ8x2g7qlH8L3NOx0TehB8BhCY3uKQJ9R84JTTRIfLvkkC
EfMh5ot7THTQ2TT3/fLlLQ5BO+Ras32h7lvd4sDWCPRxGIIPsr8sGcHf7cnD
tLoYGj5LoPobJjqAw39aC9id2zsnOnjxMGm390LtmwDlNyLiAz2+ABAS0uo=

      "], CompressedData["
1:eJxllF1Ik2EUx5cXFRZ9EVkR1aREsA+8CAmRnbVsuRHWupiYYQyt1bRMKpdU
Fr7HtTYdT6YZERJFQkVEFEaFRd9XESVIdBEKIgvKWLQiyno+zsNT7GK8/Hae
55zz/5/zvvbAPl9tls1m8/GfeHa7YnVjdoSKtbdfHmpjMN733FtUhHC5oSTb
38mg+EN5+1kvwkjz3BsvzjE4nMwrnFpteMbKWxfGg4b7v/4eDO9HKJueVRDp
YSDCfWEED+cp3Qyizh2jr1sozvOL/yOI4Lu7GEMJBrNFI1GEL7yP/ihxHGE3
+3TkITJZx92BMDEYTl5pMdzFdexqMiz1bDZ8jxe85mHQNNC7cHUCISjybSA9
DKXu/vUMSrKHLjWcRph8oss1zUX1zyBcX1RZc99J53sQhoVeYPLpPo/AVeW+
dzCorOGOXaR+OG9PPP6WfzWThb9DxQyk/+WZrM+vEP5tNVwl7lcZTr3ZFJgV
oH55P8+W3mwM1tL8nOR3kPSvI/0hVHPleuUc6hTnuBnseXCgc3498UbKV6/8
KfIa1v5qlv0fNMyjA0uO0T6F1LzyLCb7HtuJSmeEgVCTCNA8Y+TnNtqPdvJ7
i2EZdxp+Iu4XUn9R8s9O+o4b1v1q3jun9ZHHQ/udi8CzDjfrfVhG+1rKlK7l
KOvM5PvwVOjLR7jD9fU6aT4FtD9A+laRHw7a7zVmXrJvRybr+Ut9o1YG6/OS
k9b/91OG5b7+sJQuID2/LKk/zef/lq9LxR+V319K8UlUv8yw9uvfuL/RsPTv
KNW3qfPpVmKdv414wlLv20kGkXnvXn3n/fDXqbj6FPn101Lzi9G+Uv85cdrv
tKXyxMnvlGF5/7Nh+f5+tNT84sY/yTH6HoyQPx0UX2C+X3o/NP8FKp8+uw==

      "], CompressedData["
1:eJxllFtIFEAUhpcNkkK7iJqElywraQl7SszbsRBKrdCSxAJDjOxmBmZmYUjN
ZIjVJO4aEj2U9lBURKBkmGVlUnijKC0rjLILIiRmPWTN5V8HakHWb2fOzPnP
+c9E5O3P3OF0OBxZ8k99J8x8eakomtNQWcD1jvOCvDx65XFaU5mgU8nbP/ZE
WQ5j3zKaF3HKjr39pOSE0L/HhHKKe7exel6VoJx8+V+gYc9pQU1jv5+X+nGS
u1vDz+H8aZzca6r2DtcIOtR6cX70BJviWctvXRgdsaz3f2J0Z52v86qMb6x/
uODme2buPSvIT+0fYLRLjBy9Vy3oe9/6vDmvGKX6Ol0+Vf9wpWXXyaD+DTL/
UnW/jNf5VeC+t8zoKxdGxxDOPyJIhnVNfGUUqoSWCnowHrXtjMz/cpGMPIj8
AlCvQsTLeqr8XQW4P4FTz8LXv8pzLev9my1nNoexPemCPIX+x9tWcroWkpPf
koJ8l3GSVf3SSLhP1r98993imjhBDYpnc6M3FvV1WHaozzib4gKpK+kzeBXq
3w+OF7RiMHJ6xQtGJfKcG/FY78V6As7vtqzSCH5mWefXafrn8sZ3oL7yvkRV
7/v/s47favd7Wet7ykw9MgRVKn/2GT80pcJ/g+a8Hynw7zAzOpPRrzH4K1FQ
u2IHn+Jw5e8ZlrW+udzEE/wWZPz/Y7WgOtWfEE4typ8pyC8c8Wst636lW1b5
x2XAbyGYnyzoDTR+iMkWFK3qL/up/LXFq9/JSV2bmov4UWbi85HvG/izAHpl
f/Tv+6C3E/U8gPV2Mw9dxVhvY/Rz04eG+sOWa6Wenccsa30c/X2E/lYj/27M
p5xXNTdJA6i/B/Mg++F9b/T+Ccs6zz+WtQ4fTr1yXibrMB/+eH88WA8Gu+Gf
UPSn1tbby7pfEZbTYqRD5Hum73VDXyT65YZ/FnOalLzEg/duKfbX2ffRm+9f
SKVt/w==
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQrbNp7vvl+9oclhTYcl3vnugwzbk75/nmNgi9YqKD
Jw+Tdvv6NocIyy0nvm2Z6PCwSmSdO5C/5UTZvvnbJjrE9B/6qgHk5wk1H/Da
geCD1e9E8EHq5fdNdGgXu3nu+4Y2h10ggw9OdNAF2b+lzcH6vn+v+OGJDkcU
NhRl7GhzYGuc6sx9dKJDVApQZm+bgxdQOfsxqPxhBB9s/kkEH+zuswj9YPMv
Iszf/vnvlYqrCPvB5l2HyE/fh+CDwiN8N4L/Yfkx7+1bJzpk7SmZLHGtzeFH
8OOls9dDw+cy1P6V0PA5gQhPAHTMqXQ=
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQLRhhueVEaZvDkgJbruvdEx0EQPwsCD985USIeHqb
Q9AOudbsjRMdjihsKMpIg/Bfb0Pwwep2IvjW9/17xfdNdIjpP/RVI6PNYZcn
D5P2wYkOOpvmvl+eDZU/DJXPb3Nga5zqzH10osM05+6c58VtDl5A5ezHoPxK
BB9oa+COegT/8FeNmP4WhH6w/R0I86NSgKyeNoctJ8r2yQPtf1Qlss69r83h
gtLtn3X7EPz3y495m+9G8EHq5++Y6ABydjtU//xNEx0qX6oZcnRC1a+Eqq9D
hB8AUsCZhg==
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAWIQnTHxbY39/EKHac7dOc8PTXAA85cWOrxffszbfPEE
BwYQmIbgx+3y5GGaXOiQJ9R84NSKCQ6xIH4/lL8Gqr4Lqn79BAftdrGb5xoL
Hdgapzpzb57gUCWyzv1hWaGDbFSK9f2tUPsyCx0+ANVv3z7BQWFDUcbEaIj6
7p1QvmehQ4TllhNlu6DqjRF8sP3PCzD4D0EWBSP4fLqb5r73muBw+KtGTP+r
AodMoDn7XSc4WAG17ftYALHfeQLEXb8LHIJ2yLW+dpjgoH9Xha2Ru9ABaIp2
u/0EhwtKt3/WKSD4MPeg85cU2HJdt4aGh18BBh9FfSKC/+mSb5JABYIPDMVO
x44CiDpHqHsnFoDDd7sLNHymQ813m+BwEeS+WQUO5fvmS633RvBh4QHjw8IL
bF4kgg+0xTTOAY2vV+AgCoy2X8D4AAnvUy5w8AK6j30nNLxECxweAc0/vh3q
fq4Ch4SnF5Sit0LdzwCV3zjBofV14A65t/lg9+mvg4bvw3yw+8NXTnAwAPHv
5sPTWzHI4/vzUdPjmXx4egUASHwzkQ==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQveVE2b75zwod/l2peKnmP8Gh9XXgDrnPCL5w84FT
C/8WOhz+qhHD7zfB4fHS2UcU2Iocpjl35zz3nuAA1s9X5PCoSmTdcc8JDtUi
69wfChU57PLkYdJ2R/Ct7/v3irsg+GyNU525HSc4XFC6/bMOqJ9Pd9PcfLsJ
DrJRKdb3WYscHgLNc7eZ4FC+b76UPtB+kD3yVhMcZuQJNR/4VOjgBTSe3RJq
/zME/4F/7/S8Wwg+AwhcQOj3Nu90TDheCDcf5J0N+wrh9r+rsTeN21UIdx+M
D3M/jP9++TFvc3eE/iUFtlzXPRHmR1huOfHNG2E/WL8fwn2w8EUPfwCJYbDI

      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQXb5vvpT+5BKHh1Ui6443THC4oHT7Z90OKL8Oyr9S
4mB93793evUEB7D65yUO75cf8zYvn+CwyHXb578MpWB58cIJDny6m+a+5y11
+BH8eOnsTAQfbF4Cgn/4q0YMf9QEBzuu64sLWEsdtp4o2zc/eIIDyJq8LyUO
EZZbTpT5TnCwBck/LnFYUmDLFe4+weHTJd8kgTMlDglPgS5zgqpfV+LgxcOk
ze4wwWFGnlDzgQklDmtkolKsbSc46N9VYWtMhui/bj3BYensIwob1BB8d5DD
1Isx+J5A89rtoe61RvBB7u4PQvA7HYEuSSp20G4Xu+nnCDU/p9hhmnN3znMX
qHxRMcQ97lDzSosh4eiD4D8ChU8wgg/2z2oEH+Tf6M0THBhAAGjeFlB47Zjg
cLXipZphFtT9uyY4aAHdcS6+2CFz4tua/Xuh4RNQDImv/Qj/wPgw/6Lzwe4/
BI1vwRI4H+wfGwQfFE374kvA8S19CGp+ZQkkfA5McLACyS8scfh3BejQfVD3
HihxCNoh1/p6J9T8q9D42AyVf1UCcf9aaHgC00MGiL8MwQern4fgg9PfDKh/
30DTwySoe26XOPwF2r+sZ4KDwoaijImnSyDx1T7BARgr9/03Q9JTdDPUPUj5
AQCWQXMj
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/cC/d3reoWKHf1cqXqq1TXA45m3e6Xim2KF833yp
9a0THGy5ri8uuF7ssKTAliscyOfT3TT3/eNiB+v7/r3iQP6hrxox/R+KHWSj
Uqzvt0xwuKB0+2fdv2KHh1Ui644D+R4gBm8JnL9DrvV1oAmCDzY/sMRBu13s
5jmgebnPf6/8mFLiMM25O+d5O9T8ihIH0XXuD391TnBQ2FCUMbG9xGGXJw+T
di/UPRNLHCIst5womwh1/5wSh3yh5gOnpkLNX1jiAFLePgvBB/l32XwEH2zP
cqj7p5Q45AH1e62b4LBs9hGFDVUlYP9f3zzBYZHrts9/E0ocgoAeyd4J1W9d
4vB+OdDmPVD3cCL4YPn3xXA+2P3A8BQB+qdq9wQHWPh7Ad3HvmuCAwBb58Gh

      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/cC/d3reoWIH6/tAhusEh8kSLGF8D4sd8oWaD5xy
nuCgf1eFrfF/scM05+6c504THDweVomsky1B5fsi+Me9zTsdi0ocfgQ/Xjob
aJ4t1/XFBd0lDl48TNrs3hMcpucBDV5S4sCnu2lufgBUfmOJw5YTZfvkwxF8
kHvE4xH8JQW2XOEpExzcQfatLnGQiUqxjs+c4HC14qWa4YISh/fLj3mb501w
6HRMeHphClR/MdQ9TSUOQTvkWl+XTXAAeTMvo8ThA1D99kqoe/xKHC4o3f5Z
VzPBIef575Uf9aD+qZ3gkAvicyD4YP0/iuH8nUBjA18VO2i3i908B+QvnX1E
YcO9Yod/VypeLgPy43Z58jBdLnYAktrtQL7ChqKMiSeLHUDWegH5sPCPsNxy
4hvQfgAApLt7
      "], CompressedData["
1:eJxVlFtI1EEUxhcfLKwMzHroYhdKDAnxIURt88iGqytaGpFamYmm5mXVmtHW
W7qKymaNmZcoWbpoF0ErjMTALEOlh1AoJCLMhEzErIfECqS5nG1oYVl+O/+Z
+b7vnPPfnmqNT3czGAyJ/Ct+19kHX9/cRSEhuHd0MZLBdMf1V9sMFLIa50uf
hzPoHaUDzq8EQicPNrQaGdTMxfX5TBL5PN3HoC3Pyz44RsC/dsP7NyEMAj7u
dK98odYXgxlEB9WHpzzSbBCfNs1FA86NAXYCS4enOzbx80q8u81ThQSaTY6c
DGAwvuPDr/JUAl2bk9KeHWDwrTRsb3ISgfg+n5psi2apJ+7/9bkjDOYFJxP4
bPPuHklEPk3AstrNf8UJ1FdAIIpz7SkGw+KPaqL8p6NfJ4Hvd4ejn2ZhPv3I
uQxyZv7c//GFwMuffscvFzJw5TnF7zMXa27hfmZKNK/nNn9XM+C2Qie3Uljg
5wU5UJ83VXlfwjxWUpnDciPmt4T3NzHYIvZPaZZ5jmv23PO4fWEI63dF67+T
b/Q4yhisEes9BNwrm02rXPc9IHKf1aFZ5lPHwEvo7yLS30iVZnFvTwWDMVGv
e6ofYsuwHrcILL8tnu3k/t8Vz/oG3sD8bejnKlH+z6Ofes1y/YJmqbeIwBDP
e60N8yzA+vLzjR4Tt/OzUW8Z5plJ1LkVmoX/iSrNwr+jDu87R8AqjDVgfzh0
fjIP7kfU7WQrA7MIYgjvv4b65zVLv570H8t58aOqf9tQv5GqejUzyOR9FxZD
4YmYuyZ8PoGqeWBYvxSq8rvIIFf0XxqV+frWo94MCmKbxa5ZzodNs8znmGY5
v/HoP5OCsGmLwfUsfD6aQSe//uEZqvo9CvPIoUp3JPazFfvXzCC5n+88q/zO
ReD7hOI6Z+nTprlVCC/X/In/5FWhvgjMqwbny4x5OdB/JOpvwf0WrEcHcqxm
1/tO1qcO52s/AxHTQDbmG4J6D2mW/W7SLO8PxvtDUV8g1suI87ebqvkIQ+bz
L/vNpN8HLj1/AWDhem4=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQLdx84NRC1TKHCMstJ8r8JzjA+O+XH/M2L4Ly/5Y6
ZEx8W2OfN8HB/WGVyLrHpQ58upvm5mdPcJCJSrG+f73U4RFQ+HjmBIdqkXXu
Dw+VOiQ8vaB0O22CgyxIfnOpQ74Q0KBkqPyqUgfr+/690xOg8gtLHYJ2yLVm
x05w8DbvdEyYCzH/fSSC/+9KxUu1MAQfZH504ASHuF2ePEyLS8HuiPed4AB0
pWnculKI+72g5u+E2CfuPsEhFqT+eKkDkNRud4XKX0XwrwKtMXyF4E/PAzqc
pcxhSYEt13UPRPjAwgsA36GL/Q==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLRuVYn3fuszBi4dJm/3gBAf3h1Ui69wRfKstJ8r2
BZY5RFhuOfFt/wSHx0tnH1GIKnNYUmDLdX3vBIetQOn5SWUOH5Yf896+e4ID
SPfDtDKHf1cqXqrtRONvQ+NvRuj/Hgw0eQPCfE+g/e3rEPbz6W6am78G4b6p
zt056asnOMDcD+PLgPj6CL5w84FTC1UR+ltfB+6Qk0WYDzJ+vgjC/rc19qZx
Agj3ofC3ofF3IvTD/A8zHxY+MPth4QdzHyx80cMfAJqZuo8=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ3fo6cIfc+lIHLx4mbfaDExwyJr6tsd+N4BvcVWFr
PFrqEGG55cS3/RMcZKNSrO+fLXVYUmDLdX3vBAegatO4a6UOH5Yf896+e4LD
1hNl++bfKnX4d6XipdpONP42NP5mhP7vwY+Xzt6AMN8TaH/7ugkO3uadjglA
+/l0N83NX4Nw31Tn7pz01RMchJoPnFq4Ho2/GMEH65+J0F8tss794QSE+WD7
OxD2A8kjCi0I96Hwt6Hxgf47BrKgA+H/LSD/TUCET+7z3ys/zkCEHzi8FyPC
Fz38AVLZxm8=
      "], CompressedData["
1:eJxdk39ozHEYx6+VqZGFRcRCJnWJf5ZuczymbDvactJpcbdkjTCjfB/tjjnX
dbSNx3Q7v9ZcjBT7g8nlj/Nr2UVpMi2tOdvS8mOGYiTyfL7fpz7xx7fv99X7
+Tyf9/PjO3/bXndVhs1mc/Kj3sPt57vm/UAonZxhj3gJHq9bfnz1J4ScjuLB
OjeB9y4r/QhjV1kpJRgNrMr3Ji2+U0RQMliX0xFH2HGKlRUEU5bcbB0LIrg4
30QHQfjDhkSuT/P00P0n8XzNzqy+S7VTEeZUbC/0OQlup4xk21cDCtPlTTPX
Sr4XBtRM44NlBJ1K7zIgMxhd01Ch+XKtM8uzU/Nn5Q/lvpeGlT9EoNLExyW+
kaBAHZiFZn5XlOCM+ihCGOKyus+Kn/2a2VaspkWz6e8WArvZXR2Tep8i/O49
+O5KM0G36ucQQgvrI00Ec9lHehRhs6Mz9f2YZuWnL/Qve4IEzxf0/zz8XvzV
iz6MVn2HCFT6ygEENSZ7QObXK3780o+U5j0jv659SWg2/d4QvwHhdoQ/zIvq
5fxFhIffFm85eUT62YpwXTWU/Zr7c0HiI9K/cwiPOD67gWClmm8UzXlNOiHx
jWjNlyT+qHCz1HdA+LTUV6XZrxbTpXnZwMLMIO+T6ZMkPk/6w/crm+ls2d+w
1DcBYXwjOwloNuezT7O5n9UEDpWYz7sTueFdW0XPk/s3EbxR+1Bg7f+99XK/
x9JjJVKP/z+OasZk2+yl3H97ZMarZy7RHyCo36q4nKBHzb/H0sv4f4ypfr1G
qHzLikfm81H8+wj+AlS1xPA=
      "], CompressedData["
1:eJxlVF1IlEEUFQmiCBPUNAtTHyQyiSCQWmLvt7v5i21Krv1BYoVCZlKwzVj0
YqFim6NWUmFlP0ZgJhZlKhYV/T1EhRHlg1mEiIQUtGCRNd9853O0fdhvOXPv
nDn33DuTVLK/YE94WFhYofyZ/9t2O4a9ZxltWXvnuf+FIBv/GWRj7RWCfrzN
K4kMMrpauX7++2pBWSNV0Z3zOC2ViTtrBR0fz+9JiOHUYS7UC+pJkCtxnE67
68tLTwj65A20VMRzOjRwMX5VQFBi14GyxiWc3iQPTU7NwIr/pMZSzcAyAT2L
OZU1fjvibBRUZxR/fR3NaeL609z0JkHDJn8kcDPypb7PUuYzG/9ldEbqGZ2B
5TcQ2yIotWbRh1etPATb+V+unX+SWKv5lB9+ThFp3a0TTdBbinqlvua4Ob6I
rZykyuShBviTjXpkvStM/nTorRN03/TrI6Mp0++DOp6zIDx1rg968sGXJ0hu
Mop3cfJLP29lCXr0c/mOhnJO2TK/JkNYPnPocaMfx6z92w3wBRAn+HfK6l+f
E/VdQtwJ/q5QrPrl0H7+j+18ux/RnZkjVU74GYl6nKg3CvqlHslypTIW82To
/ivs0ljluzVWfm0QVl+icF6mPl/1Myd0vm1s6i/apHGBNG6vzN83+vvG93Ns
2l/l5wXs9wiKqn74sq2NWb66EG9nJKubPGoAdzDV73uE+9Bt8Y/b9T9g0/6o
/EHtn41tfx+b/seHYjtf9T9NYzV/Dut+B20+D+bfgF/Z4JP4HRtLWb2RUYzU
88uFec5H/R7gQmbNXwZwEd6PHI0Vn3d2PHhZY+XPTcyDj1k6bkPfZkbmM5N5
F34VwO8ezL8X8V7w5Vr3J6VPkLk8ksGULwv7kW9Afz/8WqfxYTN/jcbqPqyE
3j7MQxLq6Z3tf9EAzq/R7+c/TEdX6w==
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQveVE2b75J6ocrO/794q7TXCYnifUfGBblUOEJVDG
cYKDt3mnY8LSKgeQOnm7CQ5va+xN46ZA1dtA5ZurHA5/1Yjht5rgsMh12+e/
BVUOXjxM2uyWUPlYBN/grgpboymCv2z2EYUNQlUO5fvmS+nbTnCoFlnn/vBL
pYMnUL7ddQJE/HqlQ8LTC0q3faH2n6h0OAS0rz8Cwf93peLlslQEf7VMVMru
Iqh5Nyod3i8/5r29boKDbFSK9f2flWD3T++EyktB/TsFap9rlcM05+6c5zOh
8hUIPth/MxB8YGidWri5ymFJgS1X+PQJDrDwBNlnPgnBB/t3MYLPp7tpbv5a
qP7jEP3XN09wEAbxj0L1b4PKH4aE//wdExxAzs47UOXwsArosF0THB4vBQbg
niqw/9V2T3DgBZr7fjvUvj3Q8N0E9d8eaPisQfDB8bEUTX5OlUPQDrnW17uh
/p8Add8uqHu6of7dB1X/A6r/5ASHdyA+VzUGH+yeBARfu13spl8oNH1wV4P9
c9wPyuetdpgKDN90HyifvxqSvrwmOFxUuv2zTqga7L5sjwkOoGB4KAa1zx2q
Xrraga0RaAIwPV8AqVeohqdvsHvVEHyw/3UR/NhdwJRnXu3wF5Se3KD+d6p2
eARyH8x8d4h73V2g8rcQ6RklvoF8AFmFgYU=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQveVE2b75J6ocrO/794r7TnBA4ddMcGh9HbhD7jiE
P71hgsO7GnvTuENVDkBVUutboPxdVQ5Tnbtz0jug/E1VDv+uVLxU65ngYAky
cHmVQwSQ8a1vgsNWkPmzqhyWFNhyXZ8wwcGO6/rigt4qh4yJb2v2T4La31Dl
8GH5Me/tkyc4PF46+4hCCYI/PU+o+UAMgs+ru2nue3eoeydOcBBuPnBqoSnU
/G6o+bJVDkE75FpfA93rbd7pmCBY5aDdLnbzXBWC78nDpN2ei+D/CH68VDph
gsMi122f/8pAzQud4PAW5D+TKof3IPv9JjjIRqVY3/eGho/7BAc+kHtSqxy8
gOaxu0D924TgzwC5fxaCD/YfMLzYGqc6c7ujhT8wPgCt4MCq
      "], CompressedData["
1:eJxVlAlI1EEUxjcJoxILO+kQjYhKQihCdDOfWR4rKhpZWpmJkpKpWZrujJkX
uqzHbKtlhCxGVlBoiJYlmGSoGIZFEBkhJlEhlhjZAUlzvHVI0OXn/Hfe933v
vb93SnZcmovBYEjgv+Iz3TZFg3wpHPHvGJwNZxDQMZjfs5hCBv//k2AGA5F+
luAZAsaxmJqrgQwaszzKej8T+Xz+HgZfadDupFECPpWr374IYFAxGdvl+Vyd
z/ozSHoc4ebSrXlFWe9Qc7NmS3Dyx5FqAr8OTrSs5/eNbHr3+yIl0BBizTwF
DCZarj/zyiRwd0Niavd+Bgbxk0ogrsuz4rRJs9QT+//55CHkdAIfzCtbBxKQ
cwiY3Fx8Fh1HfYQA/+tTeZLBxsRU41gNUf7T0O8dAtO3+yMfZjAQZXr6kM8w
ePpj67G6aaI+cxk48xzn9cIKNF/hfj4Rzataw8b/lDPwfb/ZtWQbhW/8Pj8r
6vOkKu9aBi9FHh5Ufs7ZML8FVNW34/cnyTzLPEc1e9/PTbcNY/8ua/03cwKX
HGYMvMT5IwKuJQ0hS2sx/w4C7jvam7KtmmU+Vai/k0h/A6WaL/Q41rUVY7/a
1TxEF6GfewTmXhd8ucX9yzlpwfzN6KeJKP+F6MeuWZ5bNEu9JQT6eN7LzFif
YH/5/fa1C+Pd81Cvs34uUX0t1iz8vynVLPxbq7BeEYFs3vahGgY3Djz4/rde
5yfz4H74OBpPXGUgro0ZxvrXUP9PzduF3zV0nuW+7KRqfhtRfxj2s4GBGJvx
eAqdvE0OOz6fQtU+MNzPDKryq8b5y6Iy3y0W1JtDQYytqUyz3A+zZpnPUc2y
L3Ho/ywFIcMchftxDp+PZCDWKvY8VXUjMI98qnyEo/9CnN8wBkKugyq/k6EM
+sX75BKeO7lc85TwW6V55lVUyvJq1BeKedXhfvH7iRBaj/55fdG2Zgd+34R6
2pCjNTvfd/JeG+7XXgZCTnIe5huA779EzbJ+lGZZfx/WN+K5EfsViPO6i6r9
CELm+y/nLUS/D5x6/gF3M3xO
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQnTHxbY29fo1DhOWWE2X+Exxg/PfLj3mbF0H57DUQ
Om+CQ1SK9X3/t9UOfLqb5uZnT3DQv6vC1viw2uFRlci645kTHC4o3f5Zd6ba
IeEpkJU2wcEAJL+32iFfqPnAqWSo/JZqB6ApvdMToPpXVzsE7ZBrzY6d4BC7
y5OHaTnE/PeRCP6/KxUv1cIQfJD50YETHICu3jd/TbWDDNBh8b4THBhAYEc1
xP1eUPMPQ+wTd4eqv1DtADRFu90VKn8fwddqF7t57jOCD/S1aRxfjcOSAluu
6x6I8IGFFwC3rYyW
      "], CompressedData["
1:eJxllHtIVEEUxhcJBTORkIyKUJGQJCwCLRfzrO9WypKosMIQIyNzrT8y7M4l
MVPx0Wj5qCghyxArxELFNQszUyspKRaRsrdFhZkWSCjN49wdbBeW3R9z7nl8
57sTkG5LOeBmMpn2sS//zRr/2zQZRmD3xrv9xwcoGPwuz/f24zMUxpLLa7N3
ENj/6XngaAUFHtZ9mIB7fnXMwvMUjvB4jcC1nEjPXTUU+pLCSywVBHhYfR2F
0NdB7vn1BN7zfBcoNF7q9W9pUbyWnz9SnJphHkt2YD72/KsTX1et+4z9VVO4
Gtc2NTuN+asomMRHh7mXLJD1l9tdvyzUQwerl1uIRzGFjpWF37Z76TJ/Ac7n
rcOLwNGZuZOKJ270JbXnKBb1tinu3Ozl1mylUJe9uOCBD8bHoz6+Opj5n1gK
55Yu2Onth/mjKfi3HMusXK7DzRWpGXYLBe81rZcnAnSpL6BewbrUNwrP1+tQ
HVOadTAK9Y11Za6Pw0whkSeqJC5sxAv9LioW+jQrFvO14T5ZP5s8HQ0591B/
1u+v4S3pPr1Ezh+N8/cT57yRPP6JZL8EnOepjA9JpHCd75sxf8yapNjQ12BD
f4NFvTwKD38H7z07KM/D81HvPuzvNIW3nHswXxGF1UVLRobsBGys3mAJ+q0V
40tRnyYCKdwYZRSKLUz5KwR+8vrlqFeVYqFXoWKxz1zUuwznP4TzlyLvIcDW
bU4rwf6tBGqY3uOF6v2aZX5tPKV4nt/CcF4r6rmBQAiba2s87j8C30+mfwR/
ESIlJ8TgeTSR/rOgPlaZ/w/gPlNwfrb/zMofWlSa8oPw31FXNvwl8ndpLmzE
C/8/U8z7HhrRnP4Sen7QnP5irp/Rv2jOfmu5Ub5rsi82zyJef0KT+sZh/ilN
zhOPfpmW8fetiuf5i7G4DxoU87lstygkcOGmcJ476I9JTerfhuesvrhvOij0
8H2y/oTenehH1r+4f+zIH7FeF+7zDfbThfM4FIv9DCsW/hnQ5H7s/+ndieft
qF831gtS9/c/MKfQjA==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3emY8PTCozqHCMstJ8pOTnBA4Qcg+BkT39bs95rg
cN+/d3reE4j8N7cJDlrtYjfPPa9zsAZKiLtOcGh9HbhD7jVEvb3zBIerFS/V
DD/UOSwpsOW67jjBYbIESxjfdyjfYYLDp0u+SQL/6hxko1Ks79tPcMh9/nvl
R656h6nO3TnpQL42yHxZTD5YvzXUfVl1GHyYeqHmA6cWViP4YPvboeph/N46
h/fLj3lvB7qnfN98Kf3JEP9MB7qXV3fT3PfT6xwuKt3++c9pggPImf6zof53
meDQAbJvHiI8Dn3ViOlfUOeQB7LYC8GHhSeMD7I/fDGCv/VE2b75a6HunV/n
wAeydzPUv3PrHB5Wiaxz3zYBIg60/++VipfLdkDDawZUfhfU/1PqHP4B5dV2
Q/kT6hy8eJi02fdAze+GumcP1D+tCP4OOWAM1iH4dlzXFxeU1jkEgSR2o4X3
Lmj8pUD9sw8qfwGRngByJyYx
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvch12+e/U+od/l2peKnmP8FB/64KW+NCBJ8BBNbU
Oxz+qhHD7zfB4YLS7Z91W+odpjl35zz3nuAA1r+n3uFRlci6454THDImvq2x
P1jvsMuTh0nbHcG3vu/fK+6C4LM1TnXmdpzgUC2yzv0hUD+f7qa5+XYTHI55
m3c6As1/CDTP3WaCg8KGooyJq+sdtpwo2ydvNcGh9XXgDjmg+7yAxrNbQu2f
guB3OiY8vdCB4ANtM42rQ+i3AjFKEeZPlmAJ48tF2D8jT6j5QAbCfTA+zP0w
/vvlQJe6I/QvKbDluu6JMD/CcsuJb94I+8H6/RDug4UvevgDAHUssw4=
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{751.5659999999999, 
     1228.4832050000005`}, {879.5659999999999, 1340.4832050000005`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0005827365172898222], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{773.5970000000002, 
     1247.7649550000003`}, {774.9768750000002, 1268.4207050000005`}, {
     746.0588750000003, 1223.6673300000002`}, {794.2537500000002, 
     1246.3859550000004`}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{1145.777, 363.6592050000004}, {1146.93, 
     195.67120500000055`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0015993573864237444`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     1145.9809540510598`, 334.3863041770005}, {1160.71917451346, 
     319.8465109480803}, {1145.7304508146801`, 370.9793041770008}, {
     1131.4411608221396`, 319.64808371460003`}}}]}, 
   {EdgeForm[{Thickness[0.003198864463484343], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], FaceForm[{RGBColor[1., 1., 0.], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{1002.0780000000001`, 
     195.67120500000055`}, {1290.078, 195.67120500000055`}, {1325.535, 
     195.67120500000055`}, {1354.078, 167.12820500000043`}, {1354.078, 
     131.67120500000055`}, {1354.078, 67.67120500000055}, {1354.078, 
     32.21420500000022}, {1325.535, 3.6712050000005547`}, {1290.078, 
     3.6712050000005547`}, {1002.0780000000001`, 3.6712050000005547`}, {
     966.625, 3.6712050000005547`}, {938.0780000000001, 32.21420500000022}, {
     938.0780000000001, 67.67120500000055}, {938.0780000000001, 
     131.67120500000055`}, {938.0780000000001, 167.12820500000043`}, {966.625,
      195.67120500000055`}, {1002.0780000000001`, 195.67120500000055`}}}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxlVH9IU1EYXSJmw8hiWWSYlaVkDISEhkYfmEhEWe6PrD/ibbcgSuyHJWJp
FJmBBveiZRpmusIskwhRCRHLSCuL0SKJRTLNSkSszGxF1P3xvT10g7F3du/9
zvnOd+5b6TySdSDEZDLZ+Vf8Lnn3atrTS8HSkuErdBOI4tj+Oxi3T/59U3CP
wC/78K3oaQPTx1MJ739QiAhJLI1qIiCOVU7i+RsEfIX86TuF7uf16W1VBI5t
Mg+4vlHIdEZm28oNvKUs5/OfIgN/cq/y+nMJdJ6oWBo6ied3E1gTdvZyzxTW
30ggZTDzUtVPCntsrX35VgLhzcv3fuT6VpSM7eqIwXp+Cm1C7zwCgnbDHAYX
RGONTlXfzALrcv8CBscPsvHTGQQEbd4ipurnzsLFBn4kHsoIDPF+excyGBH6
r+B6JINSwVeH/vH6Demc8TZR/0ewgJ+6ntl4xjyswVjfn8Z9PLUO9dwlMLo2
KXx9PPbjUv7sj8PzlQSS9z3cWh7L4Fl+V92yM1gvmoHXX3yoc6fyq9Vi+CP1
hKH+HCfEiXnE4rrNAbUTjU+3cb6izbzyuKb6S2SwQxTq1tR+K56/r6n5JTGo
qeafek3ypiYzladqDYjgt6H+KgNLvpOazJtlbjDW909zv6+ZDezZzoXMR75a
TeYpjc9D5q8J9fF5pQpdDzTZ73k+z/gk7lyXgRcLon4DS/+8CofyenmC7582
M1/cH/0+yf6/OpTeURpYl/kZxnybHDKPq31U6fmgBbD01WNgWe8J8g1REGNO
aVf99fB6Mo93UO8I3q/reP4L8l1V2DVGA37pWPf3qMB9wVjfn9URU3L4Bd7H
Gk3dx5dU+deA+ty43oL5eE1V3roRD1Dl5wTuHzT8kfr1+5/gnNm/haj5eqnK
Wza+n95SyBZ854jKjwf1VhAo4Bfkohv5b+L7q994v+nvRx3/B2FxjQQ=
      
      "], CompressedData["
1:eJxFU2tIk1EYHmUh/oh+rAsodo+CCgeB1opeWmaXH5J2MfHHdzs22qL6FmEa
QeSSCKnTxQKRWDWF0CUi84NWsSa6rgwSwr5CuhEhZRCxJILO+c67nR/j4+G8
7/M+7/O8W6IdrSEzXC6Xj/349/jmojfLXlLYdjH49e8FAstnn72eylCI//o3
1jSuQ+49h7umekZ2pyksCk/useoNKOwtqTeSFM7PH3+VHUJsUbhdyTp+Ir6P
/KsJZGs/RTvvUqjbMJg+uZ1ArOpDs/umxD5W19Iu8fMIIzqHfGUEnjEcakG+
WfhuUuhjY7y2Afb0mcObghS+ZJba0x0GcFm1h7C/whD9Wq5eh8SJqwsLFAql
fJ9GiUN++v20reWxmwv1a4KP9fM5iQJNzG/E937V2edagEKANzaoTn+riXzF
Kqzg/jL9B/l+PxTBH0Z/k4rov4T67ylCb6fEztyoxAuYntcxCn+4rwkFtLnM
uTiFNi50QhF+P6LAY/DOVEV+ozhvp5rP2/F7QBV5jaHeWyrUWKXhwAvUu04V
95CisH/O2oEuW+hvtVBPt+L0f+7D+zAVZ19fBP2pU+AY679zRWJHT5PEfN6k
TsE7Ud1+oxv59yH/VlXktAtxXBV5VFJIcqO2aHk8xPd7L/E8zt+gw+Unv1e9
24H3kNFFftXIt9EQ93iAApdVHjVEvYL7ZvGejuD9eQh8bHbHRk+h/0ECw4v7
TX+b/D/xPNZ3SMxYpnoiEjs59VIwud8hIvy15P07/j9Afypw3kPMz4P8jyVm
6mNVSYm5ruIU8peL+sFhxD4Cb/k9jSD/XgLfVnoK16TxfgJE3OdTqfc/joUb
Dw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQfXqh67bPEpMctn3+e6XiZbJDkkCEpYkmgn/7Z12W
jdkkh6w9JZMldiQ7rHN/WCXiAJUPTXY4BdRf7DHJgYdJu12MMdmhwJbr+mKf
SQ5+IIMWJMH5Ty8o3f5phOC7dOc8//000UHs5rnvwV5Q82ckOiQDtW1xhZrv
mejwI/jxUmnHSQ7yra8Dd/xKcADavu641SSHNTJRKdb7E8Du3WIENX9agsN3
oPrZWpMcnoH4eQkO1vf9e6crQuWjEhwKQfaLI/jtQAeUsyP4YPf9muhgA9LX
B1Gv/HEixL1fExxM43Z58ryc6LAIGGx/fRIdQM5meTrRIdJyy4mydWh8qSQ4
Hxw+mUmQ8Ho+EeL+7UkQ/7+BmscCDW+gfWD3BCU7vFIz5FjzfaKDKCjge5Ih
7v8/ERI+G5Mh/gO6Xw4UPteSHSpfAjUIIOIPPX4BSkX1EA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQLXbz3Pdg0UkOouvcH1atSXZIEoiwNBFE8Ctfqhly
8E5ysLnv3zt9UbKDOFD9ZY5JDs8uKN3+2ZfsoLNp7vvlLJMc1spEpVhXJzs8
rBJZ5844yeHWz7qsPREQ87b8m+hQlDHxbY16ssOP4MdLpf9MdFA35Fgj8y0J
Yt6viQ7WIPO3IfiLXLd9/puB4LeDHPo60SFoh1zr678THbL2lEyWaEh0KLTl
uq4MtB+o+kqFaqLDZV+gjVyTHE6W7ZsvdTrBoQLo/g6hSQ4u3TnPf89NgLhH
BsEHu1cFwQer15rk8BTkv20JDqcWum4r1p8Ecc+LBIf+Q181Ykyg8lKJEPeZ
TXK4DfJvAYIfabnlRNkrBB/snuYkB6DrA3cYQfm/kxxA3mgB2hcBUh+UDPGn
ClQ/MHyPKmwoeiGLiA/0+AIA7Uzeuw==
      "], CompressedData["
1:eJxlk1tIVFEUhgeJkJDoYdCg6GIXpejBYAqxyUUWZVFRhk2Sus/ZY3MahLyU
lQ1e0DSxtHaXIXQm1EwikaiUCF9qspsQkUHJRNFNswgfJExCaF+WszEfhuFj
773Wv/5/naXmkb15UTabbRP/if/ozoVZX08x6BmbfHNihMIU27u2fipNpDCw
05z3rppBTNTq2tibFBw5D9JjGvT93qMX51f7NQdHO570N2kW713XGAy9ig9P
fKBQ6Jzzdlkrg831+cN/n1OojR18OX6dAX+2Y3236u++gf0CmmW9yv/OD1No
fPQ78WA76t1HQZTLaGNQZF345UtDbmGw+PTPPffXUuhbcrvoe5DBgeR7z0pW
URDP7M2aZb2rmgNC2BXs50B/GJ5vV/qPNzLwCiMIhf6WLT1jZxl8E/N6sX+9
Ztm/TrOc5wyD8ESZt9dNYfnsysuhGpzHRWEF57Qq1L9R+ddWjud2nZf0Z9CM
sPTXaUR4w8fd5/xzDRjP+NLe5MN6P4iav4yBS8zzmsAffr6gHOs9JEpvBQMh
M+UugRd8vmKup0YM1kHg5MjKpGiut5WPPdlMpN5QHfrvJ1Ag9DbMZFn/GFHz
7J/JU/dTuO64bM1r7gRGEwwG/FaBM0ggjssYoEzt0S0Cn0vtXU/zcP5uvO9h
4Evlm9tHVD6ci0W9MFH5WAwSkrhTQ0Tts4X+zjIiLP1Zp1nqqTKn87Cp8rIw
33iVX8iDehyYpwf92ob7cYjBIpFHJu6PG/Xlqv28RFGPReE838/3Br7Pp2r+
XM2PeV5WtmYRT2cWg138M0y2aMRf+T3mUJVnJtavwP4l+vv9Bx8tBA0=
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/VLNkGPNvkkOi1y3ff7bk+Swzv1h1RQg//3yY97m
vEkOfLqb5uYfmuTwAcRfmehw+2ddls0pqPqERIdPl3yTBC5NcvBLEoiwlEh0
yJj4tsb+9iSHdrGb575/TnCYBzTo9FMEXxxIXX6D4IPMf/9pkkMRSCNzosOP
4MdLpX9Mcoiw3HKiTCnRISrF+r7/30kOQNuuVDgmOiybfURhA+NkiHwZ1D2s
kyHyBxMdJhz6qnGHY7JDJEh+HUS9Aftkh1tAdXsiEh2Cdsi1ZjNNdpBvfR24
gyvRwTRul2fPr0kOIiCPH0lwAIcH0D3qQEqmLsFhLsj9LyY5PL2gdPtnVAJY
/+s7CD4DCFxA8E8vBAbMkUkOJ8v2zZdqhvp/N9R/lxMcgK7aN3/TJIcDp4AK
lSH286yb5HAQxO9H8MHqxZPgfLB/ViVB/LEJGv4yyZDw2jPJ4RnI/rxkhz0l
kyVajkLj62CyQz8wPGIuQvW/gqiffR+N/xrBd+7OeV79dZKDzX3/3umnkiHh
+xfqv65kBxeg/G+WyQ5hoIjzToaHN1j+WxKcD0tPAP0lPUA=
      "], {{1199.668, 
      150.093}, {1212.09, 150.093}, {1211.984, 151.812}, {1211.777, 
      153.023}, {1211.4650000000001`, 153.73399999999998`}, {1210.984, 
      154.82700000000003`}, {1210.262, 155.687}, {1209.293, 156.312}, {
      1208.3239999999998`, 156.937}, {1207.312, 157.24899999999997`}, {
      1206.262, 157.24899999999997`}, {1204.637, 157.24899999999997`}, {
      1203.1839999999997`, 156.61599999999999`}, {1201.902, 155.359}, {
      1200.6209999999999`, 154.097}, {1199.875, 152.343}, {1199.668, 
      150.093}}}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxlVG1IU1EYHuKPEZWiKau0NCQMlexzxay9Yc7M7t0qvFlo1CoTf6whURal
PyKkH3tPVmAUEZE5qhFSsTT60DIVA9GyhvRDol9RtkKWYYSdL+5hdeFyeXbO
ed/nfZ7nLNt7ZMehBIvF4qIv+9Y9OXrRVoPQfrU3qyNlF3DchLDo7JftnS4P
tPk3zIosJOb6YvZ79f+49OPJefciBpTbz23a5ybwruHz0hXDBjSnjw1NuQgs
qyIvYgMGhCf/jDZsJnDauWbv4x4DTtBtViDQPXijJPzAAAt7igjMLbh/Ldpq
wFvNm1y5jog+PgMu+1LOdK8mcPzZ9QXLSwzBr5BAokFPxCqgaNwdaM0nsIXx
aaoAB8PTCKxNKMcD+bRscAph4hQlcMcN34N95fafCLTKTX+Bwq+yOuprR3QT
V65/OHCsURf8fiFk7jnoGHfqov5vhG1s7jRd9LdI/hENymYn5DVbiZijSxPz
pyocZfVt/6ynE5hupE4Ua2LuNjQx96Udzf3cr5DC1VTm3LDCnOdThLs/3mje
YdnvJcJ5uq1qRgMmU2k/ws5OWjlbF34NSrxfzj8k9z/X4RHjN4Lwmto1mekW
erxHyGB9om7hxweEIMvHFY+Yx6r84PXr1DwcexXm+pWhuZ/3m6/yyPmmyflu
u8U8qdKPJIV7mX89uolZWV+99I+eP1xDn7XSLxvCRub/HB1YTHMzUPD6JPXL
QUhifvZL/Vcqffn5QsWfzxsJxPs3Foj3a1zh2haaxK8K83zHAiJv3zSZrwCM
svXdutB3JgAay9stXZxPlHneKvW3qrxzvsUIB5JpRb8h9HPK9UuG4ONAoGq1
TIQktqO4n10Sr0K4wBr0GaJeHsbf7yw07z/HS9T/yV9nlP0L
      "], CompressedData["
1:eJxdU2tIVFEQXoogCkQiLCIrEyqI6AGxiZBTVlJ6z93HtaQHhBaaxfYklhAh
oix6DCVWECJhVtDDWGy1KHV7WFSI6Uqt/lhCDJawhcRki6Bzzgwe6sfl8p2Z
M/N938zJKj3o2zvJ5XLlyU/905aF6pMphM53NzeG8x340WuVpvcxnu6Bphuv
FjzqRih0n1u3e0zAvssjVXkSR2VaSUxQvsS+tnmnv0UMxhdjS3Y2G5w9mKqu
vCBAZnnbJC7JaXl7PMDxHoQiVb9YwJBq+BEhbl+8FlgvIDz6JxrsRehT/XI4
P2qwvDXc0/9f/DOCPF04uFnAWRUfQJh6f+72PfsF1GTEusfjCErWkbsC5Glu
/CuC9mGxDYo2JrlewoYdMmz/RFg77VPjoXqb+I0gZKp7HYL8GUI4WZd//sAs
QXViCL+qK58da7SgQvkl9Sl5wyssUNfsN5w/XkR8OwzWPjwxWFapnf2Y/Uqz
INjeMGd5iPXkWsSzmfVUWNT/AcfvGaz5TBb/xqUfeq7yvvZlVJDekNGr/Qgj
zW2Th/Q3IbxW7bLYjzquny0o/wzjWov0VXG/pRZcD8w41XnY6NP+lRus+e0y
+KWqV8zYbVF9wbiVcQHrX8Pz38DzTxis+7+3J7Aay+pLHvJ7C0J/MLFoJXgp
vg0hovb/t5d0lyEUfDkx82Grj/btKMKUrZKp5ad51jB+7ic+VxFU+1SGQ77e
Mu9Lx0MGy6m2Nzw1WM8zgnBbCVrlkD9dCGVyu1vSHdqHDwjzFa/vfkje6Sp0
y/26ovSE/RPvV/Mt99O+DDC/TAf+AjaF2cQ=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQzau7ae77Tf0OyQIRlls+BDvYcl1fXLAKwfcx73RM
WNjvoBnTf+jrhWAHIO/phen9DrX2pnG7JgY7RKdY3/fv6nd4ekHp9k+zYIfM
iW9r7Oug6jcEOSydfURhQ3G/g8fDKpF1/wMdyvfNl9LP7HcAKTP1C3TgA9mf
3O9weqHrts9rA+B8+dbXgTvkEHywu9b6O1SA9Kf1O3CskYlKsfaHmJ/V79A4
1bk757kfxPz8fodfdVl7Sib7OVz2TRKIKOmH0Jl+EP1VCP4ykP4OBB9sz4x+
h3axm+e+C/s72IH4K/sdXqoZcqwxCXAAmSpxoB/iLvFAiPrT/Q4flh/zNmcM
gvMh4Yfgg+3xCnZ4D1J3st/hwCmgh7uh4XkEyt8c7LDt898rFUDz/YHOsbwT
7AAK1rpdiPhAjy8ADuPPmA==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQveVE2b75FhMcPB5Wiaw7H+oQlWJ9/7zBBAfWMD7d
TbIhDkAlDA0OCP70PKHmA3YTHGrtTeN27Qx2yJj4tsZeH8EHmScvN8HhpZoh
xxqeAIi8zAQHWZDB/v5g8/2lJzjYcV1fXHDWD84/qrChKGMigm8Lks/1c1jn
/rBqCpAftEOu9XWgH8R8oHkTDn3ViLH3c9DZNPf9ciBf6fbPuiwdPweQN9xl
Jzj8qsvaU6LsB3Y/gxyCrwtSL4/gX/ZNErihOMGBHyTh7ufw8ZJv0gQVhHuW
zT6iYKA2wWGac3fO891+DjNA/tec4BBhCXSJnT/c/zD/gsPLaIIDxxqZqJTT
/g5HQOboTHA4tdB12+e1fg4FII8BzTMEKXjiCzEfaH8/yD/5vg7tYjfPlctC
/Sfv6yAP9PUOyQkOjVOBDvju48AHcqcogr+nZLIEizCCD45PAaj5Ir6Q+OKD
hrevL9hfL3ig/m33hYQPDzQ8LiP4YPfo+8H5waDwX+jn8AkYPgK80PAJ9Ie4
n38CxJ1yAZD0I49ID2D7BRB8cPgJTnBwB0XU92CHSlDASUL54iEOwNjvFQfq
f3oBGKNuIRD/Kk9wYAGlv9YQiPkaExxAsfP2SAgk/PUmOOQ+/73yo1EohG+C
SM8A+34xYA==
      "], CompressedData["
1:eJxFVGtIk1EYljKRCDOL6KpWFP0oTLqT1RsmJbpvc9/8ljLzfsFL6RLNS2rp
pkvBI7OMxELCpBCRkhCxsMiIhKyEohRKTKVWiEWY+af3XLbzwRgP5709z/uc
syXlvDF9iZeXVxz+6H/bbOeLqIsEnr5qj3hUZgaGLQRS/c8c7s2PgaiDjhNJ
WQT20s9phFt4PlxAQEnBAJMK+8/2RzZg/iDNf6jC2o+v59VKgVebID7tyOcR
m8DhJjhZnzuzWC/x3dbnwXsaJSbP/uwcbyI8LlTEOwkE2VwxfX4m+KtOdmy8
TqCWNnKp8G1HqO+uFgLLNL/dDx5LzOpVS9xjzWr6GabC2EJFdhjmY3Tb7IwR
GrGfpZmwuK4aIz+vIzAUjBlv9dCB8/XYCWyiREL0YOwLtLmQT2YGfu8VD46m
Og1JzOp3Kpwf5lNelkYFPmH9AcS+XVixTGH66GsJ0DbWLIXzrRXxiSK+TmLK
v9Uh8TzFVwkcXf7hTn6ewuYfQH1HdbgghwLhWK8M9aXjZkzz8zCnmC9Tz/uh
HoFUXx8D2+eKm5I/2zfqt5kOmqiHfNqoWeg/KfoTAsdo/wSBG9z66KAA47c5
xDwlOt7fLvSK0HH9q0W/VTrmv+EqApev4eTz0dxfFRJ3n5ooXVMu8a93WLiU
wCEsN+Wv43zRj/9QhsJwHedZRCCUCl6o435w416JWfxSxYPvz2HhJIX7uZgA
3oaXRX56+E59UiL1Yn60Sf8w/nahz6jwF+6T+qAnQPVgdr9A4uIntzeExKp8
XswfRvv+Tld5fbvIt6qw3QeZY7+VNK5S5f6qEfPYVX5/rkjM6lVJ3HIuoHoQ
9cybWbw3V6ry+14u7kuqCjfoOfKderN1bOGACgOFznU1Vve+Bb9cMU+2kZ17
5xCm+2KkkfNKF3yGYrgu+J4w3cYNbO9f4sT9bjKwfTab3XoYuN9ipf/ofcrR
y32y/YLEbP5kkT8Yy+9Lmpuv5sGsX7vG50W83hsfjH6N80khcBpt1T2icT2T
xXvxVQMqy4VEcT6r8XkSJKbP4D6LxOy9jBd++MHjXWYxz7Tm4XfpODp7QmKW
H2SG/wtbnuo=
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQveVE2T753RMcls8+orDhV4CDzqa575fvmuBQvm++
lP7RAAc+3U1z84H8D8uPeZvPRPDlWl8H7ihD8EH0e/EAhz0lkyVa9kxwiLAE
mtzn77AUZO6BCQ6XfZMEIjj9HTjWyEQ9OTLBwce80zGh1c+hXezmue8nJzj8
qsvaU+LsBzHnPIIPtucKgg9SHnxzgsMD/97peUl+DjPyhJoP3J3gcFRhQ1HG
Qj8HkHb1RxMcZKNSrO/f93MA2mq55cUEh7c19qZxWf4O3iB7P05wSAaJKwQ4
AIOAoeEz1PzH/hDzHk9wWPXxkm/SB1+H6SA+0P7Gqc7dOd99IOqPIfgPq0TW
Hd+D4IP8U751gsMcoLeLInwdQMZM2DAB7O8UaT+HQluu64tXT3CYcOirRgzQ
fcuA4WOwEqp/uz+cXwt07q7AADjfA2TR+wAHeWB4WKyByk8MdAB503/TBAd3
kLx5ECQ+dkxwYA0Dsu4GOQBle8WB4T8RHADBEPUnofp3BkPcd2mCAwtIvWiI
wzqQQXcmOBw4tdB1m3MIOJ4ePEXwQeH84g2CD04/nyY4vFQz5FijEwIJn68T
wO7c8S8Yov8HNP1chNr3a4KDMQjMRvBfgfTHIPhg81iCIfEF1H+1AiiyIQhs
PsMXaHjEB4Hj1+TdBIdJIP99C4TE61OofQsDIe65BY3vhECHSpDBl6Hp2zQQ
7N8pJ6DuEQ50QM8PANLSbRQ=
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQHZViff/87gkOSQIRlls8Ah0KbbmuLz46wWH57CMK
G6Kg/LMTHD4sP+ZtXhnoAFZ/eYLDSzVDjjVLAh3axW6e+357gsMaGZBMoIP1
ff9e8UcTHMr3zZfSVw1yWAY0x+DZBAe51teBO8qCHFTZGqc6v5rgwKe7ae77
40Fg8/zfQNWLBsP58iD1cQi+kTEQdAeD9eW/htq3Phhs/oaXEyD0KYj8++dQ
+55B1T+FuvcLRL3BIwSfA2TQbTT5KxMccp//XvlxV7DDx0u+SRPOTHBwf1gl
ss49GOLfIxMc/EABdiUIon//BAfn7pznvzUh/kEOTwAQa6QN
      "], CompressedData["
1:eJxVVX1MlVUYvzkzhk0h8NbMuKZmWbm4EnkdKQ9diBzc9733PXfOMcYYXepC
BtzLxzXqogQZ1TLP0lEzx1oZ5YjdGH3MMWdYzeWy5sfM+oPsS62ZkjNWrtVz
zvNcjrCxd797znnO7/d7Ps7tdc1O/SyXy9WL/+pbufqFkh9WSDj45ZtlH/nD
oPEiCbM3zFs50h6Ce0f2XBxcIkFeeKa4MM+B4fIznTvvlJCKR+WFNxz48HDH
gYF7JCSLC2v2TzpwBMNc9qbPCyiasF++2SchcWBg4X0nBfx5LFCXtU7Co1kb
14xmhfV6f4mEd3Z/tji1KgxnOnOHy8sMn1GM71lvsPq0Vhpch3Hut835CuRf
GzLxNV8hwfPc76FP/hCwV+0LSyhQf4cM1uvbDR5U3yoBny9Oxc/h+Ty17hYU
3+H7xh2oiqCCCgnXK70rQxBbm3lq6Qb2I+YA7opHa9mvsCA9jRLKldBTAjAF
rq3NEh5R2BPW8b5uM/q0X50Gaz+TM3H/FglPnr363iTqn8T9O7r5/uwwjLW9
ektvj4STm88v917i+3ol/LbcmzE0ZrDW12Gw8nXUJyBjaFHVz3geP5GiKYf8
eZb1jzjwWtNNPQcTfP7hIPnTLgFPH+7osvW+fNSjtsfPWdNYxY0cMVjJufy+
Bc+7Tx9NIPaqDTst0o/xdoxfuat6iwXo8p5mxPuU0BaL6g3xcdy2scHS/g50
GKzrKWGwrp/NEjBNb7Ukab8H/Q0o3nstyjf6q2xtmmUTn27ml7QpP73s/9wg
8euT8E9X41jbcZt0bUvztek+9E+1T02mDVHVSJgv8smCpzAtGU9LuE0FngiQ
vgTv72SMfqi+rC0LEJ+Y1Dyj2QHyvUlC9y7/S5umKsnPTQYr3d82GKzz+bgE
H4b7JStA9fsY8/cHYNmc7l2HIhJOH50SP7UHdD24IpyPUYO1vv8M/k7tr7dI
Vz3HK7DJ3yj7VRAkfrF0vzq673ytXG/vcj+hXmR79up5Z1q/1vmXAy0qcYhX
qf6dK6Bf1R/iX79Z8v3feQbr+vcabKkLKqmeI4hXVL8yfqVWEI9W7r9mQX7F
OV6XoPqK8f3bqD9c12A9f5oM1vl9wsRL69d8SjheDffrfof44LzQv/8bIr0W
+5MZIr/Wsx8NQbgD8+Mv5X7yUX+lik3+dP3nG6zXS3ge1zs0D/w8r75if0t5
HuaIaaz1PCBmrgue34hPqHkSFZQv/8x53/8Q57tH0FxNz/cXeb6Cwbqe1xms
5+eD7EeS87NGgmqToQjjQuZTJEDR6Mvn8z865P/d6fntUL6W8foxns8efh+C
5G/qVo5/Iqj9mb1QQqny+/Wgfj9y3RKWYjU0jtn0Ps6f6bfnOoP1/M3h+/aR
vxcX8H35XH9uvq+U6mPAbfxNYz2fqw1WPk21cv0s4Prt4/VcCZ8qv3cLmnc5
/F4Pcz6y+b35WBC/+QbrfMwzWJ+/UcKlwS8qVn/A710G832b34cbuL4nBPwP
I9yVQA==
      "], CompressedData["
1:eJxdk1tIlEEUx5eiiAKRCO0hK5MuEMEWhIqUp5aSyJlvb4VID7IZicXajYgI
SSoqymoK0xCJWBCh2kTE3Yfy0kWidTU1MdtqW9Biu4mJiPXSmTmDQz0sH789
Z+Z//uecyfRVuA/Msdls+fiT393Zl7eVTAjofHVvR5vDCykbWhrGP2he5IQ6
/+JznTEBKm+Kw6nkmo2XkN8wX2rRCFf5Fcju8PIL37oMX386tW7fI8NZsZnK
8qscVs+vqnmGXJTb+vKkX8ffCyiU9+/hcDFtpHcaOW5V1/q3czi6ZeFwAOsZ
lHq5Ov+j4eLSvLgV/y/+SUDJ2OtVsV0U70sIWPBgWXHpIU7fUQH1z1c2H2vi
6tzbL4J8r7WgEQP27/q+pAUTA8x3Y1zAVizjSINF9X0VkCEv7uBQJn6cyf8s
oKrGceVwOqc+od7vyvLHJwKM+oV+5N9jdga/BqSgzp8uJN1Bw+imOr3fcATH
MNmr+5XCAEdmOxvVfvIYBAsSp5f0aD9ljPQjOn7fsKpnLv83jv1Qenhe+Zrk
5Ddq/Mp+NPcJwOm6wjudlNct4IWUy9T9aNf3Z3HKD2m+xWgeLVpvPQOsNljw
0PhT/WsyrOoLGFbzuKs5m9H99ZpDxPY67T9Hz/+2nn/SsNKPWLMsZTdfcyr/
tXcEDMlBgYvmgXpdcv//uNS+OhoFyDYHQ27at6CAeXsxk3lonmHNTzxUX4cA
KT+T5lW6o93mfal41PAK2dd+w2qeQ4LyNnnp/Q0L2I/b3ZrqBZl2/J2gcz89
gE1eeh7366b00+aZfb+q3oMe2peEri/DC38BqATPhw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ7WPe6fjg7ESHZIEIyy0fgh22nijbN/8kgm99379X
/OhEB82Y/kNfLwQ7RKUARQ5MdKi1N43bNTHY4eMl36QJOyc6PL2gdPunWbBD
xUs1w47NUPUbghwyJr6tsV830cHjYZXIuv+BDgwgsHKiA0jY1C/QwRtof8Ky
iQ6nF7pu+7w2AM6Xb30duEMOwbflur64YK0/WH/D8okOHGtkgE7xd5iRJ9R8
AGhe41Tn7pznfhDz10x0+FWXtadksp/DOveHVVOA9l/2TRKIyITIN2xE8KeD
9O9A8LeA/A/0X7vYzXPfhf3BfHlgeAC9xbHGJMDhFNCdxVcmOvDpbpr7XjwQ
In9rosOH5ce8zRmD4HxI+CH4y2YfUdjgFewAdJQEy82JDgdABnVDwvP8NSh/
c7BDAcijQPP9gc6xvBPsALJm+UVEfKDHFwApxcvs
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQvadksgSL7iQHj4dVIuvOhzokCURYmqhOcmAN49Pd
JBviwLFGJuqJCYJfaMt1Xdl4kkOtvWncrp3BYP5iZQQfZF6L0CSHl2qGHGt4
AhwKQPICkxxko1Ks7/v7OyQDzd/CP8nBDihccNYPzj+qsKEoYyKCD9JWkOvn
0C5289x3ID9oh1zr60A/iPlA8yYc+qoRY+/nALTVk0dwkoPS7Z91WTp+Dq9A
9gL5v+qy9pQo+4HdnyKE4IPViyD4IG02YpMc+HU3zX3v7udweqHrts8SCPes
c39YNUVqksM05+6c57v9IP6Xm+QAdOWJMjt/uP9h/gWHl9okiL2n/R3mvl9+
7LTCJIdTIHPX+jlUghRKT3IwBCv0hZgvOsmhH+SffF+wv+4IQv0n7+vwI/jx
Umm+SQ6NU4EO+O7jAAqOYC4E/wjInewIPjg+WaHmi/hC3MsMDW9fX7B7vBmh
/m33hbiTARoelxF8sHv0/eD8YFD4L/QD+6OYERo+gf4Q9wPNlwfGzg65AEj6
EUFNH8qsaHy2SQ7uoPT2PRgcr9m8UL54iAMomKuFJzk8vQCMUbcQiH+B8cEC
Sn+tIRDzZSc5gGLn7ZEQSPpSmuSQ+/z3yo9GoRC+BiI9AwCPMS7J
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQzae7aW5+3CSHV2qGHGv2hDnIt74OtEhE8Ne5P6ya
kjzJoXzffCn9tWEOQC0MDamTwOp29IU5HFHYUJSRPsmBH2jO+/wwB2/zTseE
jEkOEixhfLpeCD4rkLtJFsGvtTeN2/Ux1IFjjUxUClB/u9jNc99PhzqA3QM0
/yXI/jWhYPFymP29oQ6FtlzXlROh5tVC1cch+GB3RSP4YPMjEfrB6sPRzA9F
2A/2XwjCfTA+zP0wPsx/pxa6bisORfN/OCJ8HlaJrHOPRIQfyP2LoxHhix7+
ANnpm2U=
      "], CompressedData["
1:eJxTTMoPSmViYGDQB2IQPSNPqPlA/CSHA6cWum5zDnFgAAGfSQ52XNcXF5z1
d9DZNPf9cq9JDulpQGDmD5EH8lVu/6zLuuMH50849FUjZr8fqvwcP4eoFOv7
/kD+qo+XfJMa/Bz4dIEGAvkca2SiUrL9HICyvdO9JzncPPc9+HGon8Nl3ySB
CB+ovLefw7LZRxQMfNH4fgg+mPaH2hcDse98ANQ99X4OIGsnhED59/0cvM07
HRMiJjk0TnXuzkn3d8iY+LbGPgbqf+4AB1h4wPwPdI2lSfQkBxmQwe8h9j0J
hbrXFGqfP9T8+b4OqmxAk4H+6Qfx9X0h/nWD2vfdB6LeCcEH+V/cAcH3Abrv
ge0kh6MKG4oyBH0dtpwo2ydvMwksnuDq63AEJG41CRJOlb4Q/1lOcgD6wjRu
F4IPluf0g/PB7giHhhdQ/zuQ+lt+Dp+A8gI2UPsmQuPXcxI4nDdMCoLYD/QP
SJs1ezAk/IHxkwwMly0BCL586+vAHXkI/mlgcH5uDXYAWbscqF8zBhgiM4LB
5s0Hxr/7wyqRdcuDHbaC+ED7JoE8sC0YbI6FxyQH1jCgi/cGg92d74bgt4sB
Q94FwQfb4wj13/ZgSPwCw++lmiHHmjUIPtg/r4IdAOGDPrQ=
      "], CompressedData["
1:eJxdlGtIFFEUx5eQkj5YSdEDSxOSoqQsxCLEEyYVujO7cy1CJMQeilRbZmqx
Vr5AK18nt6TXJmqiLeuqay0mJiYURhr5wR5C2YekwhYzCbWg+3IHHBiG35y5
557//5w761Mt2vEFBoNBpTd7BoS33bN4EIaMqUsPT6vQlXVjVVErQlDSsd2f
vArkfguLKGlGiF48XHcmXAG6xHClDqEvxJWZ3mqE/tq4x+fuIsRHle5JiTTy
9X42hHxb7LWTfxLg4Z2+kG1lOm9YmG97Xqgzz2NFuElxLN4I7pfZ3cE5Mt+U
ERLo8/NZhLWsHrsC6VXj1hgLQoS/IyipSPVxXkzkkU6zyccKlbPrtwmc+0Yv
Ls+UXG2GmtOBhT058vsITeyfh/D1TejH6QENLlC9/sUIwcU/zB6F8Hrs5QhH
6XK3i4j8Nch1uQITgdrnbaxF6GFGxCaKept15nradOZ+PkHYvoNem2X8KUIj
yzdDgJXp7pb5+4nwuwdhP5XhrNDZyuo/oDOT6Vwk63uG4GANHNTgFtPbJet/
oIn6OhG+U5kOq8b9qfbI/TJkvEPnLzTti3adf72lg0L15HTb12w9r0EDe++S
8auamKMWhCXMGLuMO6W+znn8QWfu908N2Dx6KW9KruidMhDOlhbZr2WCvZRP
jc02TYQSeEVtnXRJ/VHSjzbpl0pE/90ynkZEf6k+7nMuEXM2p7eACJ86pL4y
4vODf1+jM0vjqNdZ6CNcx8659a9lve3S7xEizgetby8d99kJAmys1RYZ/yt4
8JHO7LzENsyL30eRd1j6UyP9KyeiPyj3j5Pzex2BTnnV+Igm5q0Ewe8QXXlQ
gy1sfgsQVvMXZpH3sswXoLPov8nH/H/wT+X9fpePoHnW0RWq+I6en5lLGV1Z
QwpM0HoqS+V5TVRg5fuBP0P0PDHfUlbI/4lNZz6Pt3XuYPXbkf9nJqMVoace
obJ3amNyhSLOXxMCYfuPKj4/007QK1sV+9N+sOo8YSb4D3NjOnE=
      "], CompressedData["
1:eJxdU2tIFFEUnrRMrLbNRHutpfaCCiwQEytP2QPRe2d3ZwuRCNmMpGSViIiK
QCoitLK5SIHsj5AekJiEqESR9qIspOzFtoFKLbJGiYZsmxCd+2iH+jHMfHvu
nvN93/luhrfavS9O07QCfPg7vHxt4uqlDLp7r27rKPTAx+jJA/fsCs9wQs6e
u0X1NgbFuec2l09QSA30RQzEb4nXXhqgEMTzGxC7u9LPfO2x8MWHEyt337Zw
Fv+opzDWT7wNiEvz2p8d8an6bAYlvP9OCssSahsfIR7Qz1/2baFgW3PHX418
3vB5eer8HAv/ND5fW5j8X30ug/LQq8xgEYUI1ptSGCS2LCqrOEjhetPjJdlp
DPDVdugmhZqNSR+aFzAxZ3SFDlvrqoYn01W/sC51ZDLYhMdq/Lrk52DgKKvI
H3hAhT8z5zOobSysq0qjIPzEeb/QxsPNRPqFeri8UDaBBuz3KUmdj5RIvxMs
zHl+ibfwFV/yqe4pyi8bAf/ojafFmtKTT4Rvg79NqaeSyPmIRf2WhQWfePpv
Hf0Q8xCf5UR/UKlXs/Qii+HjcQxwu66u7U6pP2rCEz4uQ/kxpvpnUXl+RGFG
5D5Cat4qAq07ho6lDJoxfcK/oIUFv/cWFvt4rXAukf37FO4kst6r9K9X+39u
yv2HLSzmv9Bj+NK3EwU5F5zy95cmvDuKk8El99FvQg/P/6QLxjGv9oAJnHZr
p1vmbciEabswMcSQ+xxR+L4h+Y2bwMdHUz0ib23o19/7Jeqadd/QpHmnp1pY
7HM6k/9b55H3D/OyF9PdbvdAJSc+i8Fivo/vBvAY6pgvk+vpMGL3V/Ddb8i8
YB4FP4cH/gAkSseN
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ/VLNkGMNw2SHZIEIyy0fgh2Cdsi1Zv+ZBOdzrJGJ
evJ9koNmTP+hrxeCHX4EP14q/XmSQ629adyuicEOQFGNmDeTHJ5eULr90yzY
Qezmue/Bz6DqNwQ5AFV58jyc5ODxsEpk3f9Ah3nvlx87fXuSw8S3NfamfoEO
IPt1bk5yOL3QddvntQFwvnzr68Adcgi+Ldf1xQVr/R3mAvV735oEdleKtT/Y
/J47kxwapzp35zz3A8ufvjfJ4Vdd1p6SyX4O3uadjglA+y/7JglEZELkvZ8g
+GD9rxF8sP+B/msHeUTYH8x//XsS2B1rTAIcMkAOZ5/swKe7ae578UCIPM9k
hw9AY80Zg+B8SPgh+MtmH1HY4BXsAHT0/fPckx0OnAJ6uBsSnrM5ofzNwWBz
84Hm+wOdY3kn2AEkXMyCiB/0+AIAYSbP3w==
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGDQA2IQzbFGJupJ3WQHljA+3U2mYQ4o/NAQhySBCEuTKTj4
T4NR1SPxD5xa6LrNOADOT3h6Qen2Sn8H+dbXgTvqoXxNf7B8SuNkh8apzt05
z/0crO/794o3T3a4de578OOlfg4Pq0TWubdOdvAx73RMaPVzOA009nM7gq+7
ae579S4EH6y+Z7LDuxp707hZfg5iN4EG9UHlj/o59B/6qhEzYbLDEYUNRRkf
oeZNnOwQtEOu9bWhv8M6d6AJk6Huafd32FMyWYJlOoL/Us2QY80UKH+7H8T9
E6H2Sfk5FNpyXVfuhZq/0Rfi/47JDvwgh7r7OoB8Wd0y2eFXXdaeEmFfiP31
CP5RoL4XNQg+2F2Vkx0iLLecKNPzhbinHCqf7AsJr5LJDomg8JwJVV842YEP
ZN9ziPqWgskOdlzXFxf4Qt2XP9kBqG163iY/B1A0FedBzffzh/OTgfG8RSAA
zofFL9j+BEz+8tlAH0uFOLwChU/yZAcXoD9/G4ZAwiF9ssOH5ce8zSOh6Scb
av6EEIdKUIAC3QMS33IiBGJf0WQHoO6VH7lCIfzSyQ6gaFkXHgoJr7LJDlcr
gBobQiHxBQwfCZCDToU6iAPj+3I1Ij0DAGm/Qa8=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQHZViff/8yckOyQIRllsaQhwKbbmuL76O4Mu1vg7c
8Wiyw0s1Q441OiEOny75Jgm8hvJbgh2WzT6iYPBpskP5vvlS+l+DHGbkCTUf
+ArVH4Dgg82ZFgjnt4vdPPddONDhUZXIuuOfJzt4PAQy+gMcfMw7HR+8n+xQ
Y28at4szwOH0Qtdtn4H2NU517s5h93f4CLR/wrPJDiBnFtj6ge3fcH+ygzdQ
X8JWXwewf25A5XV9wf5RvjjZ4TLQ2REvfRyWgtSfQPDB7tiF4IP9t2Gywxyg
sqIZvg58upvmvl8Otf+7n4P1ff9e8YVQ9/IHQOyfO9mBJQyociuCzwri5wbC
+bnPf6/8+Anq//mTHdxB+suDIP5dPNnh4CmgR38HOVSCAnbFZIerFUBGQ7AD
MIoYGtZOdpAEWfAo2CFj4tsa+y2THWpB4aMYAlG/e7KDZkz/oa8JIQ7ywHC2
OISIP/T4BQClTeMx
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPT1PqPnAsckOSQIRllskQsC0yWEEX3fT3PfL9092
4AMx2EMctpwo2ye/Z7KDXOvrwB3Pgh3WuT+smrJjskP5vvlS+keDHZJB+rZO
dlg2+4jChq5gB6AVDA2boerNgh0eVomsc98IlX8UBKYNNkDlyxB8sPynQDhf
HiQvF+ggfvPc98ubJju4gwxKD4C4B2g/xxqZqJTZ/g5AXUUZeyc7NE517s5J
93PwNu90TDgy2cGO6/rigrO+YPcwnEXwTy103VZ8GcFXYWucevjGZIfgHUAX
KfpB/H0Hav5pPwfr+/694g8nOwCdEfy41B/ivseTHYC2TnzrEwDnHwQZLB0I
5z+7oHT7p1wQJHzuT3bIef575cdXQQ7g8Afa5wHyT32wQ+VLNUOOK5MdWMKA
Nj+F8s8h4gM9vgD9y80K
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2Iw3fo60MJgikOyQITlloYQB9O4XZ48dgj+lhNl++Q9
pzi8VDPkWKMT4tAudvNceSCU3xLsYH3fv3d6xBSH8n3zpfS/Bjnobpr7Xj0G
qj8AwZcD2rNjWiCcDzLnu3Cgw7LZRxQMoqY4eDysElnXH+AAotzDpjjU2ANd
whng0H/oq0ZM0BSHxqnO3Tns/hB9PlMcbLmuLy6w9QPbL+42xcHbvNMxYauv
A9g/9lB5XV+wf3rMpzhc9k0SiHjpA1Gvj+CD9Ski+GD/iU1xmHNEYUPRDF+I
OB/U/u9+DsAgY2hgh7qXPwBiHssUB5YwPt1NWxF8VhA/NxDOz33+e+XHT1D/
s01xcAfpLw+C+JdrisPBUwtdt/0OcgDqmpsPtO9qBTCEG4IdjgKd8UJ4ioMk
yIJHwQ46QP3LpaY41ILCRzEEoh7ofs0YYEglQOJrvgYi/tDjFwC8G80o
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQrbtp7nt13SkOSQIRllskQhx+BD9eOlsTwf90yTdJ
QG2KAx9IIXuIQ8VLNcMOpSkOcq2vA3c8C3Zw6c55/ltuikP5vvlS+keDwfql
ZaY4LJt9RGFDV7DDUYUNRS8koerNgiHi4lD5R0EO1vf9e6eLQeXLEHyw/KdA
OF8eJC8X6HD7Z12WDdA894dVIuvSAyDuAdrPsUYmKmW2v0NUivX988pTHBqn
OnfnpPs5gJQd15riYMd1fXHBWV8HoKlFGcYI/oRDXzXuWCL4QOM4dOynOATv
ALpI0c/hMtD7Ec5Q80/7OQCDjKHBfYrDzXPfgx+X+kPc5znFAWjqxLc+AXD+
wVMLXbdJB8L5zy4o3f4pFwQJH7cpDsBQW/nxVZADOPyB9nmAHFofDA7nfKsp
DixhQNZTKN8EER/o8QUA1VvF5A==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7W3e6ZjQOcXh4KmFrtuqwx1g/Mapzt051/3h/FUf
L/kmKfg7PKoSWXccJr/cz2HLibJ987umOHCskYlKyfZzABlT3A1Vb+DnINf6
OnBHzxSHX3VZe0qY/Rz4dDfNze+D8h/7OiybfUTBYMIUB0OQAUd8HY4obCjK
mDwFYu9WX7D58jMw+WD9zr4Q8WxMPkz9OveHVVPyEXyw/UVQ9Ych/PfFUxwm
HPqqEXPf16Fd7Oa58lKof377OugApZeXTXGYDXKYhp8DMMgYGsqh/k/3g5hb
gQiPqBTr++eB/OAdQJ8r+sP5sPCE8WvtTeN2SYbC+RPf1tib7guFuBfINwYB
5TCIf4H8JIEIyy0eYQ4g5y4H2i8PCte8MIejQGe9KIPKd4Q5+ADd8wDofnC4
T4PyS6Y4vFQDhvCSMIj5QP8eAEXU6jCwfxiKEPwMkEMKEPxKkMa8KQ65z3+v
/LgoDB6+YPdPDAPH34bMKQ41IP5JqH0tiPQEAFsOEhU=
      "], CompressedData["
1:eJxllGtIFVEQxyXMHoj0QbCotAQtqQghEQtyxMJC9z52V7EyCbOkDIqSCM1K
SCISlDp+CDGKUEPNRG++0lIrC2/q9ZVvSsrEJDTsJX2oc3Zm74H6cNn72zMz
5z+v3ZhyWj22xMPDI57/xPPOXFmHc4LB0VWJEY4rOpi8bzLTtypfhegbp6az
RiX7bKspnhti0Np5b2/dFg1Kil5sqB5g4JnATwo1GF28dLLZxWCp4C4NDqbu
etfzhsHNLxcjw7wo/isGpcIvUIfPwaHLK9skhyU37fdukVzM7WMbGXxyBY4t
+uigNvjnptcxiBF6pjXDPq+WweCFmeDQVg1+aR9K1tYwmBFx2T+cKnmehw0P
0Yz3W2tJ3w8V73tM+TlViA2/HnWknuLfVeFrn5JS8ITBGpHwWRUK2r9vHuf6
syO5kigV9bmoXj12iOP+73k9p4T+43b4ye8v+sjAmsILPm5zs2G/XfJIN/8X
bwUh49wkg/WikJctqHeMwe6VQ/fPTCjGfbO8/lm+VTGTO4m7GPQr/IKZOLTv
kMytMlmrZCFjRxPxCgXrX0u8XwE/LqS/msGBCMfr88l0/ojOTyjYv4eSudXT
gErJhp5yBk6ex4JC/pxzCvlk+SlGvZ2l/zP2z+a2N9mIV0H1+GPF+eR6RB+S
Aqw4fw6Kd80Ce/j5bz4/5aJx8wr26xkDRfS1RIF84dch2ZjvTsnGvd0MKoS/
C/Xn9VL8TRbsD6+/eC5kW1DfIPlPSTb6ddjq5nVC/5wV583cnzDKt5fmO82G
9e+i+bqN+afz/QlJ4sqHbbhPLeQfZMd+O8z5tGO+vD+V4sJ6YrOe34jLaB9C
VaxHKfUrW3KZ2MdRycZ+qhrm84Dmuw730buK9C/Tcb74PA2I/UnUcR8a5ffG
sG+XbMzTS8nNGbdWe/J+WESgDB33t4dBmyj4ITy/2kf7GovfC+cAcbTurrfJ
Rl5vJQd55RQ+H6L6xOiY3zCDgNxZe4NFx/nh7C84Qce8R8g+TXd/H029fwHp
GIUg
      "]}]}, 
   {EdgeForm[{Thickness[0.003198864463484343], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], FaceForm[{RGBColor[1., 1., 0.], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{921.2230000000001, 
     579.6712050000006}, {1370.934, 579.6712050000006}, {1406.3909999999998`, 
     579.6712050000006}, {1434.934, 551.1282050000002}, {1434.934, 
     515.6712050000006}, {1434.934, 451.67120500000055`}, {1434.934, 
     416.2142050000002}, {1406.3909999999998`, 387.67120500000055`}, {
     1370.934, 387.67120500000055`}, {921.2230000000001, 
     387.67120500000055`}, {885.7700000000001, 387.67120500000055`}, {
     857.2230000000001, 416.2142050000002}, {857.2230000000001, 
     451.67120500000055`}, {857.2230000000001, 515.6712050000006}, {
     857.2230000000001, 551.1282050000002}, {885.7700000000001, 
     579.6712050000006}, {921.2230000000001, 579.6712050000006}}}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJxlVFtIlEEUXsSHghLpZghuJbSKq6iUWe2DJ0pEIqMkiR4kpMIiFHrILhID
FXaFGXookJKCkl6qDbsYi2yhJq6saRbViqu7iatiG22kJkJnZs7P0O7C8vMx
5/Kd73wzG2rq9x9NstlslfiX37OTjsIlbg6Xp/e9tv9mcAbxlXAinmksKaqe
ZnDoiCu4d9TgX4N7alJHOFzy9t4vnWIwdm7Vk/fDlB9hsPP6yYnzAQ7PTtWK
mXEGHzH8yzcOt9YmV6WEDf6QGZi/EDR4W1vP6Y4Ag3VYaOsw5X9i0LTmq392
hOr7GdyLtnb7ghwOpOQ9v+tjgOxupo1xKFNEqF6Iww/J9x2DzvVYaYrDg9KX
scXHVD9mzlX8HIcMOegAA6wabV2g+oE4HDT4qeQXYrAL5134y2G75D9O5/PU
b4L0w/rHBSqIekn5c/8YPS0+8fi/faSJBGzFP2rGCVcKzQfr7y6+uuNwqtDz
RLQ+t5dTPvK7U7fionepAEmzO0j1kgU0dLSk5w8x6EK9IotGH8UnyqFW8m+m
fWC+Oq9ggJayMewn29S5aL7VQu+7gOKRr8rPZSDb+tIFHJO/bAZS1nq70H5y
UP9M4r/RYNUvQ/ut7CdPwFa8/PTHDC6qflN+A/VW/bI0n4Y58l8O8cN99c9W
hh8iP7sUCvdZvizJ2ZRvsNJvk8FuOcgW0sfyT0mcvyrMfVLzNxLfQXOu/NNH
9UH78WAvB7/kU2yw8tNmg1W9Qurn4+CUg+TRPH10n3KIr59wFuUPUD8H+X/I
6GVhS1+F3YnYipdlW9rofjjoPr4i/bKJXzudO8kfHq79VkD4Ldd+dFF8j9FH
8bfu/7W4+btov530vnym98nLoUr2GyX/eIjvdwa49ROeduo/ySAkn40X5v5Z
76OF/wFDon/s
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQbX3fv1c8fKJD5sS3NfabGhxg/DA+3U1zQ9H4jg0O
L9UMOXQiJjqU75svpW/a4HDZN0kgImqiA1C3aZxBg8Pc98uPecdOdHjg3zs9
T7PBYR6QfzpxosMi122f/6pC1N9IR/CPKmwoepGLyX8HMk8Wql4Tkw9T/6hK
ZN1xfQS/AujADjNU+yKsofq1GhzkW18HWthNdABSO+SMoe6zn+ggrX9Xhc0C
4t/pDhMdPHmYtNudEXzk8ADxweYrNaLyzRoh9gPNSwMB50aHI0D/ZNhOdMgA
ha9Ho0P/oa8aMVYTHSZLsITx+Tc6RKVY3z9vOtHhgtLtn3VBjXD/wPgw/6Lz
weZFQ+wXT0HwweFfhOADo5ihoXaiQ/OBUwtdIxrB/t/RCg0PoHlBO+RaX/dC
/esDNX/KRIdz34MfL3VqdGgXu3mufNZEB6stJ8r2mUDtWzDRQQskodYIia9F
Ex3+rvx4yVcMwQfbz4zg/wHJv2xwABk7ex5U/kqDQyUoQU2Dht/hBgfn7pzn
1UD3WILs29wACb/GiQ6hoPBfDY3vQgQfRL3PRfDB8Zk50eHfFWBMrIHGfyrU
vrUNDj7mnY4PEqDuXdfgALJGPgZq/3pEeoflBwAoY3ki
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQbX3fv1c8fKJDKJ/uprn7GxzkW18HWkRPdJDWv6vC
tq/Bwce80/FB3EQH7Xaxm+f2NDiA1SdNdFjkuu3z390NDnPfLz/mnTrRIWPi
2xp7IL/ypZohR8ZEB5moFOv7uxocHlaJrHPPQvCPKGwoyihC41dOdPh3peKl
2kGo+vqJDlZbTpTtO9vgsGz2EQWD1okOf1d+vOR7q8EB6Mr36h1Q975C4/9D
8IGuMY3jaXS49bMua0/bRAegt3bISTY6HAXa96J5ooMsyH6VRocfwY+XSjdO
dPAAWWzQ6ACyVr52ooMXD5N2u2WjA8jb38uh5tk3Olz2TRK4AXR/84FTC11d
Gx1cunOe/86B+t+jEeKfNAQf5Kz8JAQfpD8idqKDJcgit0YHWPiD+c6NDgC4
/buX
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQDQZHJzpkTHxbY7+4weGowoaiF0cmOvxZ+fGSb3OD
gwpb49TDJyY6/AXxsxocgGTShAtQ9RENDhxrZKJSbkx0mCzBEsbn1uCwzv1h
1ZSHEx0WuW77/NemwWHLibJ98m8QfN1Nc9+rf0bwVYHmO/+c6CAblWJ936HB
gQ+oIP/fRIcwEMOjwaHQluv6YuZJDkDbTOMCGhz2lABt4pgEkY+FuocbKl/Q
4LBs9hEFA/5JDqEg+WyI+hbeSQ4V++ZL6Yc1OEzPE2o+ANQPdKbIOqcGBx/z
TscHDJMcWl8H7pAzbHAAhwfQPZ48TNrt8lD3v5/oYAliiDVA/P0YwRe7ee57
8DUEH2Ss++mJDkBvLj+mANV/COo/kwaH0wuBHt8x0WFDEdAkoP+8gfYnbIHy
kxF8sPpWBB/sn1UNDp+A/hXYCQ3/49DwOgS1/3aDw2Wg9I3T0Pj7AAmPDdeh
+n9B1L9/isb/iOCDrD3/e6ID0FePl36Chi8w/MHmP4LI+wPDe6pzd87zS4jw
tgLJ70XwYekJAHX+H4M=
      "], {{1137.25, 534.0930000000001}, {
      1149.6719999999998`, 534.0930000000001}, {1149.566, 
      535.8119999999999}, {1149.359, 537.023}, {1149.047, 537.734}, {1148.566,
       538.8269999999999}, {1147.8439999999998`, 539.687}, {1146.875, 
      540.3119999999999}, {1145.9060000000002`, 540.9369999999999}, {1144.895,
       541.249}, {1143.8439999999998`, 541.249}, {1142.219, 541.249}, {
      1140.766, 540.616}, {1139.484, 539.3589999999999}, {1138.203, 
      538.097}, {1137.457, 536.343}, {1137.25, 
      534.0930000000001}}, CompressedData["
1:eJxlk29Ik3EQxx8kohciEVGSbdmYbktFhaw0q7Ncy9VaKZnIsFhaFmHQi6yI
+IGJQYR2vfBF2D8wCSIiQjRCJPojlmYLU2fRqhdSYlIRo3/Q757n5CBfjO2z
u+fue9+7Z3n4SGlNgmEYG/WHvt+fXHj7aSHCl1Mb8qp+KZjhxsmdXfZ+BeM/
Tx964EU409t/zftZQVLW3bbp7ZL/KPXO0doK4fZL+p+QMD1fuBch/17fsZ64
ghOf0nPn7UMYcujINwUtD3+439Qg/Ln5NRKYsvr7DiA0UL8J4SmqFxM29UQV
1F7Qkf2sd1jBMv1jTTWCrbJ67bsh5jDCFnrwuYLL0x1Pnu1B2EWD6PmaFo0N
xkPCZr1K4Rt6npzdrGdAwQfyp4zjEQXNWn9oB0JK9lvn3FEFrwLh+aMBnjfK
/bcJt1F/v7A5TwlCfc+VJdljCsjeDh/P89piVzGCjxJfKDiu/TsLHH8s+zL9
7hQ2/Q0KD8bLPrZvUqBXbqh1XK+A51+PUE7zrLTiBrDfOexXEUIGJWZa81Vo
Pde9nd//ehSUdtkbJzej5ZtLQSbp97P/aaw3OJtNvTbm5Nk8k1987vDEb5tw
XtX9kkQHAtnerPvZyQgn61mhgM7rVjrCS5o/i/PdCLHg+da6XN6P5qVUbxXv
x4PgT0zIaMrne/awv0XCpj8BYVPP1f+4m/eluYD228d+uFnPAMc1HyS/Itzf
xfc5zPrSuN6ItZ96J+vR99Jat6Ch18F+j/P8qcJ0X1vtwvqtCrekIFxMnlOe
FBV/zfsb4X0u5vox7r9a3t9/a5vrvg==
      "], CompressedData["
1:eJxllglIlEEUxxcJiQi7M7qsqKwsSynFInwS0Y1UFBERYQcGoZ1qEjFRURHb
MV/bQYdddhFWZocdJhVlZWuppauW2iUdZha2dtLMfP9xsF0Q+e0335v/e+//
ZrZ3XOK0hX4Oh2Ob+JP/J0VuiZnn5DQyKy8pJ59RXNtZUcNdnH6fri+cUsFo
9oJRlQX7OK3PfXhk7FtGJ/bf7TVsP6cZAUMyD9Yw6rnx49SrhzhNbO0XsqmW
0Y2VVpcNRznJr3t+ZSSixO04wenzmugRcxsYLR3dquTYGU7jq1M7ZjQyGpx5
sO5kBp7/ZCRlpGUaVvqyDYtd64JvcaqMde5J+M7IIT93oeczo0CP21uUx6m7
FP6O0Vexf9t8TrcbBszZXm7rP//Y5NvPf53rzjNOT/qU/1hbyShjXHXqrgpO
Uta9j7aeoFecZsr49fb+J2uwv5dRkQg/q9boU/X5Zrjl2e6z3zQafnRk7OVv
f8z7Kj8/qym+LMt9f6tpf8njWlmUkpPWdegrRpPF+qrWFvWQ+RVDbwDWP2Ik
wyS2seiOzPem4cU7a9dEnzGs3p9iWOkh6BMcL9dHor7t8H44o70J7dfnCh60
qbPHHYp8O1i0e8zWJTUhtl9iO1n0VNZzIOIHWmR1aTEzIBj6u2L/fowuyX4H
+bKqVw9G6bJfH7gP6/Uq3ifDUi6rNyzUOAMbOLm901+nB6P/Xm7nJ/TKNJJ/
wA9DGPWVfvgJf4bBv7/g50i736W/4I8o1Oc39MUY1vXVrOuvOUrud92uT53Y
T9UnD/PWCH0F8GcD2AM/fUG8l6j/B8PK7+8Mq/XVnP4Wp7zvX4H8X3A6Km1Y
gnn1cLt/RahHMfbLR/5urM9Ff93IN8c8r5WcZVjnrzlZ+jca/nIj3wj4qQDz
Fw4/P+HkknpCMX+FvMlfal6EPu0vdX48503+ElmGbS5r7gdHlS9rP6n9T/uy
Xq/m/ZzhIGmEi6hPMPp3CfUZiH5c5RQiCzkY8bKhLwzn2zX0PwJ6ruO8jcL7
grsNfdHXP8awrqdm7SfN2k+q39mIBz/FXoG+Ajy/CPZgPs6BXyKfU4bVvB03
rObrMOajAv04gPkoxTy6cF88Be/g9nn0AOudxk+adX6a1XxFY96cON8jMB/b
0K9w8HZun4+h9ryM2Yl6h6A+FvYbgHxd8Fd/2+/evaa/Kt4hX27mj8W+rNcr
Pyb8d/4sN/up+Vxp9Mj5a5Fk9Kr6JnNaJD+h4BSsD4e/V+M8i0S8VNxPZFjX
sxmnGZ4g7+srjOaL+z5LxLsg630PflyNeI8ZiS5eXpGC54WYT6Hvj/TXc/Qr
CfNQit8Pq+DPMpznK/C8HLzMsHDX8vhEw+r+W4J6lJn6Kn+XQF88/FYFf2/+
7/eC0/A/xAcjug==
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxTTMoPSmViYGAwAmIQrbNp7vvlu7sdGqc6d+csrXGA8SVYwvh0OdD4z6od
vHiYtNv3djssct32+e+FaoeHVSLr3A92O7xSM+RYc6La4YpvkkDEMaj8nmqH
drGb576f7XbY5QnUuL3aIab/0FeNGwg+iGp/hMm/7987PW9FtYNAhOWWE3mY
fJj6aUBnP69A8I8obCjKaEHwbUAae7od2EAe3Ad1/0Sof89WO2TtKZksMaXb
wWrLibJ9V6sdjoL0T+12APr6mPdLBB8WHjA+2PzUWlR+e62DNci+yd0OXNcX
F9jOqXWofAkMmAlQ9y+pdQCKcl3v6nYwjQPq2FALCY/mboegHXKtr7fWwv0D
48P8i84HGbvmSK2DIIh/EcHn0wVG2EsEHxz+f7od3EERtb/WAeTt51w9Dh4g
Psw+iR4HLZDC1bUOy2YDQ1Clx2EyyMOzax0egeJXrwcSXs21DktA7jfvcbAE
hVd2rQPIuuU2PRDz/RF8cHjoo/GZax0ug9KHaQ8kfO/XQPyjBtV/uAaSnoDu
ATnr9/IaB6CvA3cw90DCf1YNJLxedsP54PT5CMEHh//tbqj7ayDhf6XbARhL
E9/OqXGwBUXMmW6H9SD+vBqHqBSgjiPQ+F+ISO+w/AAAejlmlQ==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQrbNp7vvlu7sdJFjC+HT31DjItb4O3HGo26EoY+Lb
mp01Du1iN899PwHlb69xOKKwoSjjHFT9thqHac7dOc8vdzucPQMEW2ocDn/V
iOm/AZXfAlV/B8H/sPyYt/krBD+2/9BXjW/dDiDtZ/bVOMSA+Aw9EPkrUHmu
HgePh1Ui615C5fl7HBqnAi1mrUXlqyP4t37WZe2xq3WQB/mHp8fhvn/v9LyQ
Woh72aH8DKh65h4HNpABNbUQ9/7pdkixBqrornUAh8/nboj5U2sdQNTzV1D+
/FoHPl2gggfdEPOW1DoIRlhuOXEVwa98qWbIcR7BjwYZfKzbIWgHMKQXQs0H
hv8GUADPqXUAANWIwJQ=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfURhQ1FGeY9D0A651tfdNQ5RKdb3/YF8qy0nyvaF
1jhMc+7OeV7b47BGBiijXeMQ03/oq0Z3j8N9/97peTw1Dts+/71SMaPHIRWo
rfdttUPWnpLJEit6HCRYwvh071U7VL5UM+TYheDz6W6a+/4ogg+270KPw62f
dVl7nlRDzL8Jdc/Haod2sZvnvj/scZgM0vC/2uEoyL0vofaJ1jiA3f++x6Fx
KtChpjUOXjxM2u1foXzdGgeBCMstJz5B9XPWOCydDdTxqschEGT+82qHh1Ui
69zvQu07We2wpMCW6/r5HgfTuF2ePGuqHT5d8k0S2N/jAOQxac+tdgAZ+3wV
gg923xQEv2LffCn9ph4HruuLC2zXVTuAhNuLoOF1odqBF+T/pB4HdpADP0H9
G93jcEHp9s86hRo4Hxw+UTWo8jOg/GSofSeh/GKo+jdQfjNUnr/W4f3yY97m
03scXgGjYY1CLSS81iP44Pg9jOAvA4XPFah+4VoHQVD4PYSa/6MG4v53UPm7
iPAGh+9OBB+WngD76g1X
      "], {{910.9259999999999, 458.183}, {921.488, 
      458.183}, {921.4019999999999, 459.65200000000004`}, {921.23, 460.683}, {
      920.9730000000001, 461.277}, {920.555, 462.202}, {919.934, 
      462.93299999999994`}, {919.113, 463.464}, {918.2890000000001, 
      463.99499999999995`}, {917.43, 464.26099999999997`}, {916.535, 
      464.26099999999997`}, {915.16, 464.26099999999997`}, {913.9259999999999,
       463.722}, {912.8319999999999, 462.65200000000004`}, {911.746, 
      461.589}, {911.113, 460.097}, {910.9259999999999, 
      458.183}}, CompressedData["
1:eJxlk21Ik1EUx4cMezFKRCyW2TYiIhPrU5SI/5JYljEzEkoKWQkmYTIoaveu
EqthdYmIMojYh+jlwyiRipKysALpxUo/mFmoxZApERR9KIi65+60y/KB8ez3
nMM9/3P+53oC+6rrMxwOx1r9o3d7U07r43KFec6a2UXuMNK4T8JBzxaFVy/1
4wxjWeflr9cD/+UHLX/r3xTIDln+fPXSU/dRBd9YKPfm/DAWbN9dMnJMYWLx
iumxnDCu6XBHm0JhJG+obwbnn1bQWX71R6a4+l7B8cnvMj2ekKhc2bam7iTr
G5XIp/NPKKynekMSpTMHrzS3Krz1Dv883C9BYf8RhVvBhrNfdH9v6HvI8oXy
U3vH91s2+poVCOUAn9+okCD9H1hPPeuPy2R/dQqjftXeNMHxnZYJO2otm3lt
U1h1u/dA97jEHl2mrIbjn1hvFfc7KLHjTM+PJRu4v2cy5ZfRE7Ns4r9Fio3+
hEj6uU4hS4+l9L1A8cdFmS0+hc0039cClFZWoaCn0vigV4CO8VUy9wjc0TKj
VezHQ4FDVHirwjky/L7ARvKjlvXcFaC2orum8gj1d0Mk+82cyv/yjb45lo3f
eTwPXc/44VJoOa+NeyRwsDvqKi7geT4RqJiVURhxK0yjhOci6Y+H9Q9w3Mv1
3/F5mmP0J27Z+PHLsplXRKbHOyW0u8EGL+/7C4nlpN/DrPeniO6P1rOU9mWY
/V+osJr0jklcJL/yuZ8476eL9eh9N/Obq9BFwid5v3ItGz+yLRs9WcwJmZqv
YX2+8dvJ9fT9Mv6V2Pv7F5yh2Tw=
      "], CompressedData["
1:eJxllQ9o1kUYx1/EnKw1aojNmaESEYWIQYzU6WORKWqWmNgfI0TFP6EjQsW7
n6BpJnVXYbJKdEzd3JytEf5ZOmfpHGq+NrfRala6uVfTNXQO+yNbdffc995j
vi+M8eF5fs/f792NmL9i1sJ+sVhMmz/7f0J68678uKJLM1XB8gZJxdtqh1e2
KNqS3X9OZqek+pEX/lnbpqinrKthRo+kzFFfb7/RrsiaR8Ui2pWfl958XVGv
tadHtPiTTjmxC/asiFbVFOaM/lvR861rBlU8GNHS6ne2ZP+naPuNPXXThkUu
3j3a+Q+PqMTmzwjM/tmB2X+EprdtoiERrbbxH4c9I6I828+TmoqeO9jd+y/q
zdX09P5TK2s60N9YneyX/adoutf8y7slKWZ/szUdnprR74m0iHg+88APoN9F
4KGRm09+qI/jrQnM/W8IvHnSm4n6D8P3ry4Yd3HmpyE+27eF/J8tz3r32yJN
X9mG/5Su3xJNF239l6SbT5mmSmuvl3T89mOvf7RXk6lqaXVV4JeqHt7YURCY
/e+IJD/1hsnYLmharqmgHPGbBN1qmDH//i81zbLffy9ourVXwL9O0G47j0rt
9PKdcP3vR/xq4eZZ5esRNMw2fFTTtUfHDNx3EPHrUpnzlwq3v2Wp7P15nysC
j/71kQHrVgU+YNZeGGkaa/f/DeKvxzyOCbpsA2zUZMvOqxXUaMxzN2naafVz
Rjg9vo/9mXnwPjdrum7j/yScPgwvNGtUicB+vp79/Pv4H5Bkyyo0+dLWbX32
gzPS1bcB+/5R0kN2Xmvx/VVJ9rOClZjHTenqWRaY9bAgMM/f6Dd+1vz+wHl4
WdMUex4T0un5BczrN0lL7PmdrMnKUp1H/PGIV4PzMw7zOBzs3G/pXXxHJJn1
0wq9GOb7okE4PU9AvLPC9TcRbPR101wTuc8EffF8Jgd9bRr887m/pgZ9nbB6
fjHsn8/TK6ns9cT+vSqFvT/vJy18z+clE/UYPb1mB5WF/o5CT4NRz3Hky4b9
NPxzNNl1v9WI+nOw32bh7oOhiJ8I7Ofp2evJs9cT738I/I2eWL+DfHzsOxP2
37HPAainC/vrUUlm/dwOzPrpVC6feR/us3xFuf6Mnni/F5S7T1ukO0+NeE/i
0H9cJfXkuc958dyG/Z/De9GIef6gkno51N3btPq8cue1FveDycf6PQb9NaO+
I7ifWpC/CnpqVX3vn45U9vrg/B+nsvfn/X8emPe7I+Tj/e8M9fD9VHxXvaXo
9yT6KVPuPYjjvitHv03Q6z7l7q/2wH6enjn/e7IvV2Cf5XjfT0EPezHfJune
H5Of749foLdScJt0/ZTA/wrsu5V7n69JGm8TFaH+DrxfOwLzPr4IzPPaCjbf
+/kyJ8AKeuwG16rk++r14/l/qWkjDQ==
      "], CompressedData["
1:eJxlkn1IU1EYxtcwKdMw6UOibEaEMcqEIk2kN1OsZoyMIkokJMFCLPxjiedM
GCUWsvNSYf4RY4iEEGLSFyIyIiSW1FgJZZbNUTbbGAtN6EvqnHvO9SZeuPfy
u/e8z3nf5zzZ1Rcqaswmk6mY3+Jdvufa/jMOBFf7gba6NU7QOTPpxMrt+XSe
S9rqIr/TKGw4dbYwpP//TmCj4EsI0a15y3qiihsRPInuZ7YwgaKUt10XmxDe
/2w+PzhG4JHf4fNShHsNtdfjbwiknyx46G9G6BHCIwREud2l+nlFgK+i+64Y
PGTpa6i9avD06yPV6W6EsnDT6l5ef06sv6H6GyVgEle74mECwc28kyqEgUOp
ZquHwM7xLcmu44tZn4dPPxksVexX8xWofh+oefIQJuzujvq7RPq1DYHvdt/T
SYA/E90WQz9X6K8zWJsvzWCbqE9CaIkd7c/qUvv9YdKvXqU/y6SfAwQq8els
zjcGFf1ZLbHnSi/OICT6+UDgtPAzyuCmMCCh9KaY9G85XchWg7X6gMH8lBy+
EAUxViLCpN8xCp/u3B6yfGHS32kK4nPZZwYvX/DrB4XDfKzWMJP5mVN64wwO
ioVLnNDo867PHWMyL0udwKepxBEGnaWPZ+aSnfL8hhl8Ff7/x3peNU7BRaz5
mU0X8l8i+09F2d8UkXnOUPn4SGCVyGMmgrCb8jzd4rKRTep/QPmbY7Cmv8Ng
Le+7EPYKv3g+xctbiNAnBEfVfsUIu6t4RxMqDzYEa+vad4G4kT9Nz0znWasP
GlzDj9U9SaVfxxDEMbtnKHTUZ1x+Ylfrf6n5yxFW8LaKzE6ZlxKlz/3U5snH
eX911v38B6hbvVg=
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQXb5vvpT+jX6HxqnO3Tm9tQ4ofNFahyMKG4oyGCdg
5/+sQVWPxAeqmviWB8FfIxOVYv212mFJgS3X9ZtQ/tNqiPxdqPo71Q429/17
pz/od7j1sy5rz5Vqh3axm+e+P+l3eKVmyLHmQrVDdIr1ff9XCL5c6+vAHe8Q
fLD6T/0Oc98vP+Z9udrh0yXfJIHvUPkb1Q6Pl84+ovC730GCJYxP9x7UvH/9
DlzXFxfYPqt2eFglss6dYQLEPR+qHeSB5luwIPg+5p2OD4D+Xw/iX4O6/y/U
vsPVDsuAxm/4AjV/G1T+Tb/DItdtn/+uqHbwBupPeNzv8ADozbxFUPtvIfgg
Y8yvIPiZE9/W2J/rd9AGeWxptYMtyKEn+h1AwZS3ptrBGsQ4BA3PzVD1+6D2
7YGq393v4AHy2Emo+3b0O/xZ+fGSL9D9USD7t0PNf4ngg93PUgPnw+IXbN4s
TP5LUPiy1TrMyBNqPrCw3+GC0u2fdTy1EP+shNonVusA9P3TCxug5qvUOgBd
eaViB5RvVAuxb3+/w21Q/DtB+Uf7HYJ2AGM6FMoH+t80bpcnT0Ktw+GvGjH9
Z/od2EEOKqqFxPclRHoGAFb3Y/0=
      "], CompressedData["
1:eJxdlHlI1EEUx80kpcwj1DXzWLFNqd2osFBMfZWLdmzrUVYSBrJBlKQdUDSz
QZQUSDRhERRCa4kZshthJuIfUWaQ4h9tJB5hpbWZdIiEZQfN8bYBhUU+/Gbe
fL/feW+SK6qK9wcGBATs4T/x353/9lRUDoN7Rw9c/jxMoCJid2ZrOoO15R2b
Qx8RMAz0TXtXMjhzdVNtpYfAc5e17ZgZ198lwB5/TxtOY/C7efKF7TZR+0z4
/SaBzuN1sUHJmseXrQ5pidN8Pmag70Q0A4G0mUBIS3yZI5LBJ7Gug0D916bu
rQsZ5NVW+n71EDDN40oWMBj6efpg5zvNHlHg76zvEVRxKIPYoNIwixE5jAFX
GbjCQpW+SORcqvZFo/9CqvzGMyhqT6yZ2EdlPukpyFUUuozcCc9H6jxLwZ+n
PO+6ZunnjuYGa9vUn14K1dnz+2+tZ1As6r1X+p5kYt5TVOYxto5BnSg4x6ny
W4PnBzvhCN+fYtEs8pxO02y5z5WZsN5c53/9b+wXrx2eoWAW340MROxZk+o8
RxKDXvH3QbPMZ0jpv5KE/ro0LxcHP6Qyh55E7Ac35p3AQNh2N1FIqpkoal+C
9VxU5bIY/ddT5cegWfqN0iz1LsK8XZhnJOrh+Z7kGy6EY30PhaUiT37fQkZt
u+YR4b9Ls/Q/hHp4PX4r1dnfVH+cM+j8ZB4JWC/GCVmikMnfX3gfqzQLvxkZ
muW85GB/xjmV/jy8r3Cn6vN8Bg5ROBjXb8H+mVH917oN/Y1TeMr776ONQYHI
9zXq3Y76uzXLeWvQLPenapb3FYR5c3aJ/vyC82vH9T4CXhtXYMf8R9S8jtlx
XgaJ6udCzKufyHs7VMRgUPh9SUC0Z0kxfvcil2i+xP3u3aFZ2Mrfifr4fplX
Keb5igBf5SO70P+Ael/MZbh/lKj7KPfPk2b/e5co+rEU5+sBgR8lo403/H5d
+P4VaJb9btUs72sjnt+I+jYwlaObyPlLzfXPB3IO9tszArPf33/7VmuG
      
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQvc79YZWI3QSH9UUZE99+q3aA8YN2yLW+bqyB8E0m
OJjG7fLkKapxsL7v3ztdd4LDGRBIq3EosOW6vlhrgoMESxifbkKNA8camagU
1QkOF5Ru/6wLqXEoBMkrTnAAkgW2HlB5+QkOjVOdu3OsIfLKshMcbv2sy9qj
V+Owp2SyBIvMBIezIPMVEHwPoDPWCSL4YPP/VYPdmQ3UzwYy8F21gyqIoQB1
/8NqiPnKUPuuQtWrTXAA+oZJ+zxUXgvBl299HWihj+BPOPRV447pBAeQt/Pu
IMIHFl4AA2uKHA==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQvWz2EYUN9RMcGqc6d+f01jqg8EVrHRhAYCoO/s8a
VPVI/A1FGRPf8iD4a2SiUqy/VjvsKZks0dIA5T+tBssbNEHV36l24ABKPGme
4HDrZ13WnivVDuvcH1aJtE1weKVmyLHmQrXD9Dyh5gMdCP7pha7bPnch+GD1
vRMc5r5ffsz7crXDlhNl++T7ofI3qh10N819rz5xgoMESxif7j2oeZMmOHBd
X1xg+6zawce80/HBZKh7PlQ7AF15//x0BL9d7Oa5cqD/14P416DunwS173C1
Ax/Igl6o+dsg8hs6JzgsAjrz74pqB6Dr1rm3TnB44N87PW8R1P4GBD9ZIMJy
Sy2CL9f6OnBH1QQHbZDFS6HuKZ/gcB8kvwYaXiXQ8NwMVV8EtW8PRL1/4QQH
D5DFJ6Huy5/g8Gflx0u+QPcDfVFjnw81/yWCD3Y/Sw2cD4tfsP0JmPyXoPBl
q4WET8oEhwtKt3/W8dQ6JAH9Y5IBtU8Mmn5yoOar1DqI3zz3/TLMPqNaiH3F
Exxug+LfCcovm+AQtAPos9Bahxmg8AL63zRulydPQi0kvionOLCDHFRUC47v
+TWI9AwASZZXOw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/VLNkENn6wSH9UUZE9/eq3U4vdB12+ftCL7YzXPf
g3dNcFgEFP57q9Zh7vvlx7z3THDY5cnDpH251gGoqsZ+3wSI+Olah9s/67Js
9k9w0G4H6jyI4IPsWbMNwQcZX7MaoT9oh1zr64UI88H8mQj7TeOANk5CuE+C
JYxPt6/WAeZ+GN/bvNMxYROC79Kd8/z3eoR+MH8twvw9JZMlWNYg7AerW41w
H4wPcz+MD/MfTD/M/zDzYeHDp7tp7vv1iPAD+2cTInzRwx8AYHjFZw==
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dyd87x67wQHCZYwPl2FWgcYf0NRxsS3v6rhfNO4
XZ48T6odfMw7HR8A+WfPAMGVaoeXaoYca/ZNcADKMmmfrXYAGsnQsH+Cg8fD
KpF1R6sdbv2sy9pzYALYnN/7qx36D33ViDkEtW9PtcOekskSLEcmOFxQuv2z
bgdEP8PxCRBzt1U7zH2//Jj3aUz+ff/e6Xkrqh1cQObOw+TD1PPpbpqbvxjB
D9oh15q9DKp+B4T/evkECL272uHUQtdtxSsnODROBbp4P9R/qyY4TAY5GOgf
UDj0rIaGzxmo+jVQ/hWoeUA+1/XFBbZPEHxYeML47qDwaa+B88Hht77GYcuJ
sn3zgfzboHA7UQMJ9zVQ916pcVgH1DgFZv+dGocJwPC8swoaH4+g/JXQ8H0G
5a+Y4ABSXvOyBhKfy6H2va6B2LMUwedYIxP1ZDGCX2gL9MlCKB+oHxa+YP7T
GocfwY+Xzp4LDa/PEL70TkR6AgA+Tyhw
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQHbRDrjWbeaKDBEsYn65CrUPGxLc19oIIvtjNc9+D
ZSY67PLkYdLmrnV4qWbIsUYFyn9Y4zDv/fJjp7UnOswF0t57axz6D33ViNGH
6p+C4Hs8rBJZl4rgL3Ld9vmvS40DxxqZqBTdiQ4gd7xWrnFw7s55Xq050eGB
f+/0PKYah4+XfJMmqE502FAEdNmDarD9OgoTHdxB5h2vhtgrORHirm3VYHOy
haD2La12mJ4n1HyAC+reuVD1TAj+OqBBU75MgPNfgcx5OcFhMsgDm6sdTON2
efY8nOCwHmT/vWqHJIEIyy23JkDcy1wDMe/6BIfGqUCX66LxoxH8Wz/rsvbU
QP1/E6p/LtS/d6Hm76txKLTlur4YaB/IXp4HNQ4/gh8vlX4+wYENZOCPGocJ
QP133k5wuA8KH45ahwKQeqD7gWSBrUStgzgwvi7/ngCPP/T4BQAmAN7O
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ3X/oq0YMw0QHCZYwPl22WoeoFOv75/9MgPNV2Rqn
Ov+c4ODSnfP8N2Otw+2fdVl7vk5w8HhYJbLuZ43DstlHFAw+TXCY+375Me+P
NWD9/u8nOLxSM+RY86jG4Ufw46XSb6Hqz9Y4cKyRiXryCiq/o8ZhHlDf6ZdQ
+bkI/kuQfA2C7w6Sd69x4NPdNDf/zQSHoB1yra8layDu+TjBAejK7pzP1Q57
SiZLsHyf4LChKGPi2zPVEHf/hZq/s9rhO9A9s9kmwvmfLvkmCfAi+N7mnY4J
QhMduK4vLrA9Uu1gGrfLs0dsIsT8m9UOSQIRllukJjrcAtn7rhrs79MyEx2A
3kqxFq6B89eD7HdD8C23nCjb1w4NH8mJEHfvqnEAhz/QvkCQf+7XOBTaAm3m
hdr3E8pnR8QPenwBAFpk1zM=
      "], CompressedData["
1:eJxllGtIk1EYx4eEioVURAhF2v1DCfUhSsx6ZDoLi9GEWheshpXEULOh5jmv
WXYT0TzdDCRGSZcPMizKLIcGWlmRySrMLsxWIiYhJRQWQeec9zk71AZj/Hae
81z+z/9957oKHXuiLBaLg3/F77a81OCLLQxaivPZ1wCFkzMHektdDIL22oaC
aAOW3ro0dt3NIGHS5vjkJAOyV1an7yrRzMN/5hDNqeLiYQb310+JWjLLgGuN
3UnLqpCnGbAg+sj5rhPIMQbc6Snp8FYzeDtRsd//g8LFgulVD2oYbGqbc3w0
SIF3RdfWMliRy2/0UbCITx2DrI/lM3x3NY8sWh7bfEGznOcXCXPKbV7oE4Gn
lzNbD9ZhvlfEnOc0A4eo94yATySuZ9A8myvzkJj1GQNrjXv4dyeBDTx+8AzO
6zfzV55j0Dfv3URFGwG/52zCsQbsp5VAfDIXsDGSpb43CEj9CyJZxV/l+rUU
/XffozmWN/q5FPu9R+BbYKOr/hDm6yCwkOttJTh/F85PGfB/a9x8XvF3ooH8
mgCvVpyveADzGajPkGalr2JZr56GOU8Y4Sb6iddbJ/b1hMr57OUMvoj+31A4
kBbXP78M9zls7q/Sg/4Yo+Z+CjXL832axf2mndjfBzO/8LPsv12z6lfx5P6m
orQQASHnYieDK5mt438CuF8n5n9OIMTberyVAX8KHmVzP3zn803djvN14n52
YP12M789F/XgfpD+3q33JfT27o1ktX85X0okq3jJqf/eTwTN0q9WNT/Ok4Hz
dxMo44GnbJi/F/2fhTyoWemleFCcH6VhjhP6+ahZX8X3mOy1YXwAz234vL2n
8JLL58xkECMaDKEfMpS/qOlX1f8INf2djvsYpeb7BDTL+2s0y+d3NfIIDesn
eQjfD6sw/zie5+j3l/KH4r/vkT1z
      "], CompressedData["
1:eJxllH9MTmEUx18NhZYyM5b5EdJUW+KtpeIkqbfWUs3PtdZSm6VFmD/c55rm
16zQfaxhKWLVTHuLCaUSYU0mjDXJYjYxo0QjyjzPPeftsXq3u3efe597zvd8
zzl3fvqOpEwni8WyUVzy/1fy+/LieA71Nlcn32c6SPZM5NCdcPx0jjeyfP4/
e8ZyqNm1zfiyTodvz+PTC6M4XIy68X14pw5r8rN7/qzi8Ml7qUvVER3c/K+V
9AZziHm3b7q9nOL5U75aOj9P8ZaM0O72qYo7B/dnNThxSLo15/Dnszq8ljxo
QF5RZH72VuSwfgMyQ4VCqw7ibo/21YBqqe8vG2Hz/B3FIddb9zblM2grE8L7
DNSbwjDPgAEzx29w8w8k/m1AtNTvzOCROL97HIenXiLzRw2sqfW2gklU7wsN
akXY8x7kR7OG78+iem4ib/dSHBd8LCJtsWIZx8+P/KrToKS38mFbAMVv0jC/
lcOSozNePWnRUH8IN8/FteH5uJUU7+UozmUjPHRZdK6AwaKJeUUt4dysw7WU
od9h1O8Khn6HcrxvZ5AbPrljwQoOp6RBtQz7J/pr+lvHsH9W6lcjA4v8BXL0
s5mhX35j2dTXzqDw3oBPV9pYdpw/KTglVXFF8f15AZsVS32X1nOomi2U1JH+
ZNJ3hYGLfJDEIUPOSxk9T6T3Tyh2+OVgsx7hb7+Yd/dYindbM+s7sJr8r8Z5
cBV+mfNSSfOwjPy9QP32pXznqD9eitPdN4Usd1Fs6v1B892ooR8fDOyPhUG5
qL+mywBnKUjMq7lfHQbOZ7ZiM55dsTlfb2ieOw30a4qO8/eW9idIx7pFPtOH
LB319VE+rmNdQ6THruM8TuCo94GO/fAY9X2Zq7hhj5ikhYrN/fThINOzdmLH
vDzG84cCaL9aaf+DOM7hXfq+hDv2Cb8nCREU76oOpXKfImmf7KQ/SrHYqp/J
axWb+xpN+Wp07FcM7Wct+WHjMCz3qV6HMznTDjbbKF8L+WdT9f0D3o96GQ==

      "], CompressedData["
1:eJxlk3tI01EUx4dIbyQkIjDKiiIy/+iPCDPhlEWFxUghIqI/hkY5m6/VH/3u
BAlbslbzlj0wyxjLBaNCTCzsgVaIKyX9Y/mAzWLIlJAYURZR5957tstwMC6f
nbNzvud8711nqSwuSzOZTHvwK85CV8WU0cBhVfrRjNxsB6TwIINfJV99WW4O
Hz/gJ90BGbkdrbM3dP5ezP9zV3NVwZKQt03z9KZtiwJeDvsnL6x4nOWA7Sdf
HFz2kKvfMx0w8GBfV62fQ45z5ejgYsp/xKE0P2x2/2NJLu5e0zATZ6nxGIPW
2fb3QT/pizBVv53DAdFvlAFW/Vni4/Bp/fhc3TCDjQvqmwtRz5Oa003fcD5P
74/NE22avw8ftnjuaQ6ivngLB4FshOrf4RATOiaYPLfeJP1RiuN+Imb3Ldu0
ige4Zjlvk+Zq3NcGD4e8zv7zr6YYjM3VlfdcpfgXpbfPRfOGGPha3mY/vUzz
vWNJv2SfgGYZ/2skWeqPGcrPSxyWhrxVBWMGXMP5Tzg5HBH7HTIAt1S+C+uL
s6ffgNu2zItvGol7DeWDi/x4aYCQvRb1XheGPzekH0VNpKdL5Vub53NYzOc3
1Lyn5nMiX+qzapZ+22gf2E/uu5oDuuqqeG2AZfmxvM4a2mefAYd2NO6O1HJY
KBIGVP4VO+kfobid+n+meuc4BFYfL82PapZ+/NYs9+VkqfEOBviv8JCd7nuQ
Kf0Jxvsj3w/q2SLuyzj5j7xT6J1k6j0l5onS/awiPXjf5f4qOWDXtJwZeg9n
NT/DMvetmoUe8xniGEvuVzLWl76WUb+4ek9F9fr9/gcv+PXz
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQHZViff/87UkOEixhfLoKtQ6FtlzXF79E8OVaXwfu
+DLJYZcnD5M2d63Dp0u+SQJ/ofyHNQ7LZh9RMGCZ7DD3/fJj3ntrHGbkCTUf
YJ8M0T8Fwfd4WCWyLhXBX+S67fNflxqHR0Dh46yTHYJ2AG1SrnHwMe90fMA4
2eGBf+/0PKYah9MLQQonOWwoypj49kG1w0eg/RN+THJwB5l3vBps/4aPkxxe
qhlyrNlW7QD2z6tJEPuWVoP9o/wY6t651Q5LQepvIfjtYjfPfT+D4IP9d2iS
w2SQBzZXO/Dpbpr7fuckh/Ug++9VO1jf9+8V3zwJ4l5miP83rJ/k0DjVuTtH
F40fjeDf+lmXtacG6v+NUP1zof7dCjV/X41DJcgjuyY5mMYBXfSgxgEYRQwN
+yc5sIEM/FHjAFRVY39sksN9UPhw1ELUn53kAIy1AluJWgd5YHxZXEHEH3r8
AgBHx98X
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQPT1PqPnAjUkOEixhfLpstQ5JAhGWJlcRfN1Nc98v
vzjJwaU75/lvxlqHLSfK9smfm+Tg8bBKZN3PGod17g+rppya5ABUdcz7Y41D
MlD/luOTHF6pGXKseVTjALSCoeEoVP3ZGgcQ5X4YKr+jxmHZ7CMKBoeg8nMR
/Jcg+RoE3x2sscZB/Oa575ePTHII2iHX+lqyBuIeoP2NU527cz5XOxxR2FCU
cX6SA5Cc+PZMtYO3eadjwjWo+Turwe5huI/gn1rouq34KYKvwtY49fCrSQ5c
1xcX2B6pduADBcA7qPk3qx2s7/v3in+e5HDrZ13WnnfVEPd9neSwRiYqxVq4
Bs5fD7LfDcG3BDm0HRo+Hyc53Abp31XjAA5/oH2BIP/cr3GoBHn8GdS+n1D+
A0R8oMcXAJDk0Tw=
      "], CompressedData["
1:eJxlkm1Ik1EYhteoMDLrh2WRTRdkwpQcUdmkekxryhRrlVhEhLRaNZZY9HXO
on5EhUnFQ/RDloiUEEOlL2REP8LCskY2qGXRJhGaIiMt+kLqnLPn9c0cjL0X
7zn3nnOd21x9yOkyGgyG9eIrfwuiFfXXXAhnrhbVeeb6QOP5UytTcvP5OBfX
efp/z+IQLq+eE9Hef2WKq/YiDGZZkwKDCY4I9sdbnjj6GNzrOvqwcR/Cu5+n
DjzoZWA6O7S5w43QVuu+MvyawXWxrns/QiB9x56CMIORVyLgIM3Tw+D45yzr
eY/O37d8vNHg1Tkl97Y/XoNg7zuZ2hqm9YdpvgiDx5nttQNHiJ8xkMtbtiME
S5ONFn+Cl26bzNp5xFTRinLiLjqvnea9wyBDnCe/CCEmNHlvMeUrbR1CpRys
iUGvPLftv/yVOp8Q8yZZdVa+cxCkJlMz+cwmX62Uv4R8BhkIC/1sMYKzQ5h9
SnlmBBnjfc/gi/B5OQMBpYA45ZnI3ww+kS06q/0hnVffFRcZ5eBYdaFwt4l8
D3E4N+9t6Ngi8jvCYcWuYOnFdIQXz8XnBwc5Ts5C6s9YIq9qAUKJ3D/FB6KC
htNp1JdpPrjZ0JmZl4rQtOH+6Nh0H3SK+3PPRpUT+Ie1vipeNpmVTzOfyH8Y
lIn5Y3k03wD5WE7zf2Bqjm5xP1I3F3269Ohb9k4bvQ9Rv9bqrPILdZaaGosR
bPKhh/pRgtAuAyP0fw5UnpJj1IdNCBYpcljvn8oz8nFW+1/q7JJF+MQTvrYi
yJrWj3KQWu1OWv+Lzi/yZ75prllj9CX6Ukb5wqc6z0bdr8aaz79wjc/Q
      
      "], CompressedData["
1:eJxlkl9I01EUx39IxDARK4lFsephFZkPPSwfKjxhUSH2x6CHCAkpiByFVkY7
d0PdJEKi5GSGa5qo1aJWSUiYFRVUKqhJFP0jRkWuIWEgNQrq/u49eqE9jB+f
nXO+55zvPUvKD5fuz7AsC+TP/pbeddVXHCPo3ZKVkTchoKjB+xUbCRJLVzmu
u/wQ+X7laXFTOqv8fmHLWFYL6f8TAt6mAgf7WglWnJz3Zugv63VwfZYf3sn4
2qsEm+O+3Nh85hsEzhm7svMX+3V+t+HKdZmvO+4Zds+sbSp6QpBn68/2w5nH
k8v39PM8kwLOSn4/QrBB6vx+IeDnzk9d4ZcEf6IToyWdhpWe17CqzxfwS/IC
WU92Qgo1PyPYIX1KDqOe5yGBp0xWxFDP08P1EdR9rxn+MVpSnnPZ8O59az4O
t3P9JdT7t7IfXbpfOMwcRbjzvPpB2wUCWbbt9G2c9l92bfDeNyyjzYe2/hf3
IHyzfZcst+2OuBHUe58nuFl1oHHchepdVjYTLJNpC52o/Zf9VN0c1P628Ptl
874XOZ6p5+9rY3agfv/OdLb7JlM+/T2azlP5ar7jhpVPSDAuCj1lDp43QFCf
lC8yS+87WENwy94nh/PrWH8u6vsMsp6T/QjyeyxCKC44tX5viP1287whvo/V
hlXddsNKPyqmWfn9SMBA+8aeIyG+txGh84Ls3yvNFVP9PwiIbYr7ztXxvcY5
XsvxLwLkVqKwhvXGhNYJcP8EszBs6+WiYXV/J/jexvjeq/lePgv4B0sM1Hw=

      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQPff98mPeUyc7eDysElm3scYBxm+c6tydo4ngB+2Q
a33NXeOwzv1h1RQgnw2k4Ee1w0s1Qw6daVD176vB8iLTJzsEgtTfr3boP/RV
I2bmZIe/Kz9e8r1U7eDSnfP895zJYH1rjlU7fA9+vHT2gskOi1y3ff67C2re
0skOuzx5mLS3QvhrViH4YjfPfQ/eiODf+lmXtWfbZIeijIlva/ZXO0wA2ndn
12QHCZYwPt0r1Q63gfI2ByZD/AF0H9gfhyY7FIPUi9bA+WB73BD8PyD31tVA
zNs/2WGNTFSK9coasHl7dkL9e7zGAUg+r9462cE0DuiiOzUOfLqb5uZvmOxw
3793et6zGoj/ViH4HCCDliP4YPctgZr/uMbhB1C99MLJDhtAHgKaB/bfPKj5
NyDxcXoWNL5OIuIHFn8AZtPsfQ==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQbX3fv1fcYIpD41Tn7pzeWgcUvmitwxGFDUUZrjj4
P2tQ1SPxgaomvuVB8NfIRKVYf612CNoh1/oaxn9aDZafbgRVf6faYe775ce8
TaY43PpZl7XnSrUD0NTn1WZTHF6pGXKsuVDtoLtp7nt1SwS//9BXjRhrBB+s
3nYKxJzL1Q4VL9UMO+yh8jeqHT5e8k2a4DjFQYIljE/3HtQ85ykOXNcXF9g+
q3Z4WCWyzt0F6p4P1Q7yra8DLTwQfB/zTscHQP+vB/GvQd3vBLXvcLXDZd8k
gQg7qPnbIPLiVlMcFrlu+/x3RbXDstnAEDSd4vAAqC1vEdR+QwT/R/DjpdJ6
CP6WE2X75LWnOGi3i908txTqHo0pDiBr89ZAw0sVGp6boeqVofbtgajfoTjF
wQPksZNQ9ylMcfizEhgS1yD2L5eHmv8SwQe7n6UGzofFL9h+QUz+S1D4stVC
wkdkisMFpds/63hqHb4D/TNbAmqfGDT9yEDNV6l1AKrKslGA8o1qIfYB3Q8S
3+NU66AD4qtNgaSbUIi8OtD/pnG7PHkSaiHxpTXFgR3koKJah0qQQ3QR6RkA
SlZQyA==
      "], CompressedData["
1:eJxllGtIlEEUhsUkLEQipCQj7EqQ/gjsh5lwoMQszNbrEtUP2UBNVtPS3Jkv
u2Ca7hbiiIFYqUkaYiIiZptRpoiaiNplC9RFszsiFXYhaGa+8zksK6zy7BzP
nPOe98zm9JzEU74+Pj4n+Ef8TV9jjozIZPAgL6Py25QGBgf7pQaGT1Joi3Xb
WC6DsS3vfl/4QeF5aHteRgGD1o3HLFGr9PhOG4OZBEeNda0GRZ927PYvZmCJ
mk5whGgwEc8jrmC+UA3ORK9+3ViqWJy/sSuuW7g3cLgS823QwHm2KtivGusL
1GBTyRdT903Mv0KD0nWu0cJaBgfdtqC2RQrbV16q3l/HoCcuwHeXi8Kekz1x
9luYf5Dq/d1mUCW+aFGc2M0zE8Xt4r4/ZJkjOwcLemcJhHfwCo34CaLrc4cB
v7Uie5gAVylrXz3m7ydw49nPnccbGPDTD3+fEBiuj+n63oj1OAmc53qVNaG+
3QSG+Hl+MwMhY2uXfn9nqzdPC32aCfjzQcwVe7MRL/W7rFjqc9UzX8Q1nOdD
Autdo0sT5Zivl8i6iR3778P+HapfLv9S0nXkl9gP570i3kUgV8ybM/+dGz2v
2NDXYEN/g+V9jRR+Jc02hRjnj3U/BjnQH0PIdvTHKyrjTpfjfTNU+m1rGfYz
T3V9Shi85XNyfqVShzDuT5PIv0B1vS4q3sb16qOK5TyLMB//f6nXOez/PdX1
yGMgZK6YwvqtDD4Lvcfo8n6JstseKfbwWyb260Y9Of9rWRyPH8fzLPTPCIF+
vo8fDR7A82z031Pdn0FWzM/9dkD4MIdJnzq530QZsfnKD9Kfhd5s+Ev675A3
G/FS1yOKZR8m5S/pv2TlL7HGNSmq3jDhr1Qm9zZgAPchDfV9gftlxn4m0T9m
jJ9T7OEvM74HMdoyj4gfqyb9YDFjPWU6z6Wh/pV4nobvTa0GS3yetamod4Om
738Kvj9NyMl4Xwu+p0lYz31N78ekWM7nqGLpp3icT7PmqfddTfdXHPq/A++z
qPf7P3K5qw4=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/SP48VLpI1McgnbItb7urnH4dMk3SQDIt9pyomxf
aI1D/6GvGjHHpziskYlKsdaucXDpznn+++wUh/v+vdPzeGocCmy5ri++MsUh
1Roo8rba4dRC123Fd6Y4SLCE8eneqwabm/0Uwfc273RMeI3gfwTaN+HDFIdb
P+uy9jyphpj/Beqej9UOHCCLf05xmAzS8L/aAezev1D7RGsgfIapDo1Tnbtz
TGscXqoZcugwQ/m6NQ7z3i8/dppxKkQ/Z43DjDyh5gNA/YEg859XO5jG7fLk
+Q6172S1g9jNc9+Dge4Bi6+pduDT3TT3/fMpDkAek/bcaocJwPC4cxfBB7nv
ySUEHxikDA0npzgAQ6XAdl21wyuge9YchIbXhWoHH6D/H+yc4sAOcuAnqH+3
TnG4oHT7Z51CDZwPDp+oGlT5GVD+Tqh9J6H8g1D1b6D8k1B5/lqHPSVAnwPj
B+wOhVpIeD1A8MHx+wrBnw4Kn09Q/cK1DnOB4ef9E2r+jxqI+/9D5e8iwhsc
vjsRfFh6AgDuZhOy
      "], {{1329.027, 458.183}, {1339.59, 458.183}, {
      1339.504, 459.65200000000004`}, {1339.3319999999999`, 460.683}, {
      1339.0739999999998`, 461.277}, {1338.656, 462.202}, {1338.035, 
      462.93299999999994`}, {1337.2150000000001`, 463.464}, {
      1336.3909999999998`, 463.99499999999995`}, {1335.531, 
      464.26099999999997`}, {1334.637, 464.26099999999997`}, {1333.262, 
      464.26099999999997`}, {1332.027, 463.722}, {1330.934, 
      462.65200000000004`}, {1329.848, 461.589}, {1329.2150000000001`, 
      460.097}, {1329.027, 458.183}}, CompressedData["
1:eJxTTMoPSmViYGCQB2Iw3fo60MJmqoMESxifrkKtg2ncLk8eLwR/y4myffKh
Ux2Aokza3LUO7WI3z5XHQvkPaxys7/v3Tk+Z6jD3/fJj3ntrHHQ3zX2vngHV
PwXB93hYJbIuFcFf5Lrt81+XGodls48oGKRNdQjaIdf6WrnGAaTMPWmqwwOg
sXlMNQ79h75qxMRNddhQlDHx7YNqsP3fI6Y6uIMUHq8G2y8eNNXhpZohx5pt
1Q5g/3hD7VtaDfZPjzPUvXOh6q0RfG/zTscEXQQf7D+lqQ6TQR7YXO1w2TdJ
IEJqqsN6kP33qh2AQcbQIAx1LzPE/+ICUx0apzp35+ii8aMR/Fs/67L21ED9
LwTVPxfqXzGo+ftqHPiACvKB9oHj4UGNw1GFDUUv5Kc6sIEM/FHjoAPUv1xt
qgMo2PM4aiHqge7nur64wFYCEl/zTRDxhx6/AO4vzow=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQrbtp7nt1y6kOEixhfLpstQ4/gh8vnW2K4H+65Jsk
YDTVwaU75/lvxlqHipdqhh16Ux08HlaJrPtZAxHXmuow9/3yY94fa8D6pTWm
OrxSM+RY86jG4ajChqIXqlD1Z2scls0+orBBGSq/o8bB+r5/73QlqPxcBP8l
SL4GwXcHybvXONz+WZdlAzQvaIdc62vJGoh7gPY3TnXuzvlc7RCVYn3/vP5U
hw1FGRPfnql2AGk7bgY1f2e1A9D2ogx7BH/Coa8ad1wRfJC9Ot5THbiuLy6w
PVLtcBno/Qh/qPk3qx2AQcbQEDzV4RbQHXveVUPcFzrVYY0M0GbhGjh/Pch+
NwTfcsuJsn3t0PAJmgr2x55dNQ7g8AfaFwjyz/0aBz6gQL4b1L6fUL4DIj7Q
4wsABOzJpg==
      "], CompressedData["
1:eJxlk21Ik1EUx4cI2QsiEiUYlQURqR/6EFEmnN7QqJAU+iDRBzGICpslo7z3
cUaFRBNf1k1DR4qFRsNqilSsEqUQrUnuw1oKzmrIHCEosV6IOvc+x12GD4yH
38557vmf8z83q+xi8Zkki8VyAH/yHdm2M8XdKCAj+WRq7mYDEtjHwTXf/e5o
q4AP7/FJNqB/xPZ6U0difk6P5vVBX8z/WHPj0I/tU70CCmaq1/ZmGjD5q+bc
vmcC5mSddAMq81cFuvoEZNetC/pWUn6/gPK86aL6fzzOxc833owu8sR4hMOh
2xdm//SRvhA3z/cIKJT1ghy8Vc6MG08FfNyCkQkOo52HBy6jnieXzjZ9x/52
nX55ZI1bc2tF+vXBR5qlvq3dAiRyP53/QJhzmuLQgHpOdZL+MMXvCwgV1bdU
zJFel2ar7LddM34VK2kTsEcOdpabfd6j+BcOY6h38S71G+BwbPet/SEn9feW
x/1Sb7dmFf/L4qz0R5jpZ5OA1YEua/5npvp3NAs4IeuOM1X/PJ4v+/COMEjN
9bjm7xAPMfhZ8vVhZgv58YpBqRSGep3S8BcMDqIfrJ30DDCIYX5bx3Kelv31
mPWilct5KV/ps2lWfl+leWA9NW8u4JrAym8YpLg3lH4zaJ7DDBYmjpel2QWs
kAmjZr7XTvr9FK+l+p/oPGQ8pjwvrFn58VuzmlcdT4x7OFjkU0v7Pmbul8NO
jPuj7g/yDrkvk+R/jYC9MjBj+pdjUD9h2k9OenDf1fyqBeC/SdlR2q8rmqUf
4zbNSk4VcYTH56s4TGyleni/lH8OfX//A+8E/4E=
      "], CompressedData["
1:eJxllFtIlEEUx9f1kmiJoZmBSBetqIQCe7BaPNHFJERUiIhIsAKpKLNIcmYF
H6SHiIicr4coKIkIxCRMzDYTr+VW1mq5ZeKli6ZkmMRqutmZObN+qA/L8tuZ
OZf/+Z9dlXMm87jVYrFk4Ed+54QfTEp8LKBY7Lp8apkd4oOKRWPvQv6xdktw
eZAdztpCusp6TM6T/Mnk4PKYQ8fcArYeqU1dHED89YOAh/m5137+45BZE1ty
8r2AbVUvLtRNcpD5qzoF3Pp1v2X/uMkp/YWRFSMmYzTrxn4OA/hzK77vniw6
4XBxcN7ZUz3eJaA3/cqN0/V0P3FUczCHCgxUajUgOuBAWALeV+/8DbiLz7yf
OUR9fOPJCjAgSdYzaHKffP/b5OsygIfiRSIPy37/6vgYT9Xn1efIqN7g1Azl
24H5Q7vK8mxWO537GUqHEX871T+j9Qi0wyWZ0DtX7zVTC9k3n+V4vSPaWMC+
+1cb/qw/HGXAPqmnjl8QaYAcB/fX8SK0PhY73MY5OJdqfaY5dKShouFm/3HS
D2EG6TvKVZ5NyItkAcOc5r7EgOkHY660Pk5+CDVonu16Pt91/UcZeLK+3Ls5
IGAdlhsDDJpXVuYP9ejzeEZ6uTVHMJBhUlya/Rj545We90QhzavV5CaMl9to
sqq3XkClFGC6kPz8TNA8Ahnp8VT7NYyRf59of64wWb2PM1nVv5mpe85aASUj
GTWxSYz2wyEgQ8ZPZqR/naC+9xJ76nX+VJ2/yWSlf8s8filoHin6/mu9HzsZ
7Wu7Zhuj/t9p3q71dM3jTpOVX3FflW+S6bzUrfcR8ym/4r5nf3u7ujtd14Pz
2iAbyWZz/z8K2Oy8lR+rGbTh+3PNgvzWxomxX6/0i4v85m4QgNEni3A/lX6o
j9q3IQ6O89j5cwG75X6NcUh4hIrj/ELkfk3ofXTo/FMcLsrEOE+13zP6vEbM
+t/3/+fbl/8EU1P/
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{1144.25, 1319.7882050000003`}, {
     1142.168, 582.8942050000003}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.001599419507453699], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     1144.1679809507596`, 1290.5109284544003`}, {1158.7656133772398`, 
     1275.8315580548408`}, {1144.26940836268, 1327.1089341064805`}, {
     1129.4886218553597`, 1275.9172960279207`}}}]}, 
   {EdgeForm[{Thickness[0.003198864463484343], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], FaceForm[{RGBColor[1., 1., 0.], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{1728.105, 220.8272050000005}, {
     2071.34, 220.8272050000005}, {2106.797, 220.8272050000005}, {2135.34, 
     192.28020500000002`}, {2135.34, 156.8272050000005}, {2135.34, 
     97.03420499999993}, {2135.34, 61.577205000000504`}, {2106.797, 
     33.03420499999993}, {2071.34, 33.03420499999993}, {1728.105, 
     33.03420499999993}, {1692.648, 33.03420499999993}, {1664.105, 
     61.577205000000504`}, {1664.105, 97.03420499999993}, {1664.105, 
     156.8272050000005}, {1664.105, 192.28020500000002`}, {1692.648, 
     220.8272050000005}, {1728.105, 220.8272050000005}}}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxlVG1Ik1EUHhIhYeaPvrBQMvoAV7K01tTlWSnq5gdOSlsmw+7eC2o0UZck
Sf4QqRSzkjKvaVhEsPoRFhJiUBCGYFE/SiwsIqT8kRSh0Z/ux3m5jQ3GeHbv
Oec5z3PO3VJzyhuIsVgs5fwrfnue/d5ZtZvBUvmXOwNBCpc4/uCPxjf6+aeY
QoNz1buR4xrHhjf7yDEGi3dfeOyFFJZ53CYfxgMFH8mae1XJYCTIA+0Uvm23
xVo53iMCrRrvsPE/kjR+GZoYSlxDYW/1k8Kuoxi/ZMDgD16oCvO/N2B0MjSR
zPlkz5V2X5s2wDuW1FFXzSAmtXP9zISh8pn87xkw+6etdpwyqB1vurKxwFD5
g/pc3g8xOBK/6+HgvAG5F+vn/7Zg/ngaiZM0vi34pap+S1uQvx3PQ1gPUL9m
BnGCINeLW2A516j1jODzH47w42o0Nu+LMit6kY+HwomESsdoN4PDop9DVOqz
cAHjMyg8yP98Zm0nA2FjVjLma2fwdCgx7eOi0iu7Vesj+dQj/9XoRyeezxDY
MDO99JbX8399nTLbTVR/lxkIe31+ou73YXwZUf5dZ3A2h2d2Edi2sr3v+QDO
k4Oo+sPoh11jUa5/HZHzNnAyGpv3hd5bGzQusp93fWrEek4CNzmfqWacPzfy
O80guWOhbMxLZL9x3E/uWtBZrbGsU6/xfaFfq8JdPF+FqDdEIv3k+pj7JPvv
Dag8pfpczo8b/Rkm8J3PYzgf+bRpXCeMbtJY5gtgvQIGcq8rsB83zqMH+RYh
ziFy3sMlWG+/wlav1svEpr4Sp0Vj8/7UrbzHv2y4H5lE7WMG6ncQ+e3D8xKc
DwfOmx/xAZzHHryfp/WR/M39nwxE9v/IUP66cN6WDfU+ObFeClXzk4n7kE7h
55vimgQ71s/F9ytd75P5Ppr4H1vkSrY=
      "], CompressedData["
1:eJxlk21IVEEUhjdLWcQs+iFLSh/SF0hUUD8iF9+wkAiJFCREgmbv3gkNErN+
qAVBFlGRYRHl3KI1E1Or1SUWsaCM0KxV10D8SrYPIi2WCNlMlGbujHvBvXC5
+3DOnvPOe86sJyfz3HE2mw38Fd88/5rqKQ9Dz5mX91enUuy7cuL7bBfD5h32
lrSLFCJe0h3LSXEZl1Je6Oh9sP/5nw8MIzPnijvtFJ3ltY4Lgwxns3Yd7XBS
/M3/0pA6zFAiAkVU5n1iOF3rWFZQQeHr5o2/Mty9w5/LFEa48W3vpMW8yoGr
0xab9ecZ6kudiUOUYlTUizcQ4X3qNlD8DuaSmmQDx771p48O6PI8qwzZT7fY
PM9nd5RNvbluTG7igeUGWtIKtT2Dmtk/aamBzIlD126Xaaa+g/8YxPGH0zVs
TDh/Kzus/Jt1yXohix/VvVm3fWwRDzGpb4km84MqvkJDzevpLWN9DEJeoUND
ynAgkv9exTO0qP8m51hs+rPXFWVRfibBJestxENE+tWjeIBA2Fj/TvErArLy
yO6dvJ+Hj3XOR2S9AENB8tY2o5ngh/Cnn6Fc+Okhcp4f1f8NIucwEsum3kqC
61xPkSeWF/JNfxssfpITqrjZpPQwguM3flVltTKUiR/1Kv+Z2kcvwT2xP16G
YrEofgIhO9zGZJ8udf52JucZJHJffEzNjcgvZ65u27jdFWXp9yI+pUd5bfXU
Yf9jXfrjU/cloMv98Sl947r0s13dh5+KuT5z3yIq36v0zetyH58y8CmVOhMo
eNZEX6uqn0iRzftXNlss7ltdk8XivJmNDFViv+Op9OGh0jOn4z94xfL2
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQHbRDrjX7xBwHdUOONTJtaQ4w/kwQcE2F85cU2HJd
/5/ioMLWOPUwkM91fXGB7aUUB+funOfVJ+c4/Ah+vHT2nhSHj5d8kyacmuPg
lyQQYTkjxeH2z7osm7NQfgVU/UWo+pgUB1WQeVfnOHxYfszb3DHFoRBojfLt
OQ6hfLqb5hqnQNQ9RPBBVP5LBB+s/z3Ufd4pDt9B6r9Aza+BqH//C+E+EC39
D+p+sVQ4fxbIv50I/v75Uvp3edIc9pRMlmgB6k98ekHpdmGaQ/+hrxoxn+dA
7NkB5b+Duv8lNPxeQM1jTHcwjdvl2fMQwZ/3fvmx03cR/E/A8BK4BQ3/X1Dz
rs1xOFm2b77U6zRIeF6e45AFcsgDiPmvz81xKJ0swRK2DxFfsPgDAIGU5TE=

      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfetnXdYek7kOPEza7WK6aQ4FtlzXFwP5l32TBCLW
pjoAlTA0WED5nqkOc98vP+btAFXPmOqw5UTZPnmPuQ6GHGtkonakOESlWN/3
D5zrkL2nZLLElBSHCYe+atyJRvBByp4kIfgg8xky5zqE8ulumrs4xeGlmiGH
Tt5cB5v7/r3TD6U4eJt3OiYUz3WYNRMIHqY4zMgTaj5QPtfBGiQvBnVPNVQ+
MdUhaIdc6+s6qH6/VIeMiW9r7GvnOuybL6V/90eKg3N3zvPqirkOIOffXJXi
8D348dLZBXMhdEqKAzg8MuY6AEOhwFYO6v64uQ4ny4Am/E52cAHq/x2E4H+6
BAwYNwQf5C0W67kOQG+mWCtD9RtC/Vec4rB09hGFDRpzHZaAAvpwisMPoL3S
KlC+fiqcHwZSvx3BB/vHKw3s39Ma0PDfmwYJLyOo/fzpDuvcH1ZNsYbGV2I6
ODyy3aH6u9IdXgHVrwlF4yci+KZxuzx7suc6yLe+DtyRlQ4J32Ko+doQeR5g
eB88tdB12+s0eHiD5acj+LD0BAAv0w7/
      "], {{1869.1839999999997`, 179.097}, {
      1881.605, 179.097}, {1881.5, 180.816}, {1881.293, 
      182.02700000000002`}, {1880.98, 182.738}, {1880.5, 
      183.83100000000002`}, {1879.777, 184.691}, {1878.809, 185.316}, {
      1877.84, 185.941}, {1876.828, 186.253}, {1875.777, 186.253}, {
      1874.1519999999998`, 186.253}, {1872.6989999999998`, 185.62}, {
      1871.4180000000001`, 184.363}, {1870.137, 183.101}, {
      1869.3909999999998`, 181.347}, {1869.1839999999997`, 
      179.097}}, CompressedData["
1:eJxlk1tIVFEUhieRMLPoYbogYZrdoCKCQCInFllUdCPFKaSHku0+MQaV3bxA
EWRjiV3HZqZYSFTMi01mk1mZRhOmJl2UcQjJKItQHwy6WPRg+7LGTXjgcPjY
e//r/9deJy1/f3ZBnM1mWyNe+W06fHnWqVqEq37xnLEgxiM5/beutXFwz3j3
6th9hG+B1k0ZGy0YWLA8obbZ7D/oSIymtxnObkwpL+w0LM+PvEZoP9pck3zC
gnkTT1aHuxAWCpnZLgtWfdhW5Y0gdG/Jn7YzV9ePjyIMy3oOw0ovzbDyM8mC
tZX7vv6NkN8fHF5eX9fwvRshd+rSeuwnfosQt1g46eJQLAJUCD+Zsm4HB1F1
ZajTsNJrNyzzDLWSnwjX/QnT+iBX/mc+RdgqhWwWBNd/LPU8obyTLV3/sWFV
/5FhlechQktN8rL38RaIruSxB5TnN1f8+R757+MwX/Qvq47WQxz+u78Sw6q/
fWyM55QPbW8MMuj9c9yVeZv0zjKdP0h5ivR60x3S28O037sI55/9XLQrh6l8
9hCCSwpvYLCkHocDDQhJUtDBtH+Rzyn7n8G035bxLOX904krxnNsv/JdZfhT
qT344iLCEdE252oGHaK/hzwIhdLPZgbPU+uK9l6h/E7a70XY/eXN3N4C7d/j
I70ypu9HcGL0xgHHaabn2U/9vWlYzWmPYTVf6XyMlZ6b7stH9xvWzHzkp4fW
vdSvAZpP4XeCvI9fXPurRtgh9Ub1fK7wkJ8EC7LEfJZdovNTLJ3/guES+YOe
M4xycCsRZPk8cT7WX+VvVNezu0k/leY3YP7ff3EM44E=
      "], CompressedData["
1:eJxlln9MlVUYxy8MGzJixMzQHJjMEPtp5ahduDxOtEjpTp2gRA3Z8T3AtcxK
VwikFmOWhc1Kjd7jLKl/rLVmzRUrbc31Y+sXW4zUiCEpscZaa+ofZuc853vu
2d1lY+zDe97n5/d5zntT8+bVGzMjkcgr+tf8vbRmrP/GKyF9s+3zQ7MHA8q7
7aNwKkvRYG1z/rrrJC1+9NOaPdMVTb13akX5Ykmrjxd1T+YoqhiJv7w/Junb
w8s+eSpPUc7QO09U1klqefWvjqoCRRe13b4WSaF5caaig+Znq6QV5buXNM1W
lHlLz8zhXZKyj85pEEWK3jTPd0vq/fLfBY3zPHN8ZZ7N+XO3K9ow/uO8089K
On25q23gbsTTIOnvn2ub996rqM4kEpWktP/vooq27ivMqsuz8ScqVTJfXYLI
jmWKShdpy0WSGkR0JL5SkQkrGpe0V8dzZpWiqLEfIN56RU3Gf6ekD+4fbZ/x
iI+P69Ps+djX2lGL53f7vpr74WP+fc7vSW9/4Ol9hS9s8/4NZ7Ur0tHecXaB
tHXtULTW5PdPYOPtwvkfApq4eVH2rc8h3zc855qC13jm+gyJJHM9Dwsbnzvf
KehXU98d4FZBS1/adH77TsV1aXxY2Hx3KTpphBAXrJfcbtRzOez3KLrLFK5C
2PhfhP9yYfvdm86sl+ut/URDOrvzbK/Rs9FDxQbPNwx/f3FQKCrunlx1PIb3
JfKpFaRVft89rdBDvbB6aFOUYfQZCKvfhOI+9XUI7vdrCdS7x/obSCC+fs+u
vo5d/R2zv17bj6PanylXw4nAzlsLzp+FPjeCp0FPTeBZ0Nt6z6z3tZ4/Nue1
ftlvPvRfq6jNCCuCea1B/6YCW49qvP9TYPOPKUqY80dsfLkx6Pmgf868xbPL
3/EXRr9vCeo3+ooh32egpyropU1YPRPi0fri+Vvi9cXzUu31xfO43Otr/jU7
X1/6YKoeBuLp7PTE/melszvP9os9874rQX0qBf1p+jcf9XwA81CqrI7XwF4Z
8hXQ90L0fzvmayH2bTfe1/yQacQRz66ejp2eHDs9cb/LYO8k+lWK+H7H8xJw
trTzUYT+zpFWj4WeWS8zPPN85WN/F2B/5WLfRyz3TcN9MR7g/9hHpwJy943T
k2OXn2Oer0OYN82839vtftnzX2j11gq+Gtr9uM7ObyQDeliJemUi/mrsgyzo
KWrn/1i27y/by0vnFH0Mh2mcopffwtT9Mxom/fF8joXJeA48XvD8ifEwGS/X
93xInVXa83rwBZzfBH1PhHafdcHeBOrztmdXT8f1houDJPN93WXv+82a3zf1
/iywetT++D76JeD74M4LeD6J+0bHx/q6jP79EVo9Zkj7/XAOPB33+Rj4WvCo
5y2VOUMlI575/jsT2nnR+nT1ZX1fxf4cCq2u5trvk9xLYer3whXP/wMlpeuL

      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQrcLWOPXwunkOYXy6m+aeTnEI2iHXmr0Jwd9TMlmi
Zes8h8u+SQIRByF8lh3zHHiYtNvF1kLld81zuPWzLmvPjBQHVZB5u+c5+AGV
WzYg+KEg85IRfOv7/r3T3VIcnLtznlcD9Sc8vaB0WzfF4fRC122ft89zmDUT
CCRTHI4obCjKgNnPmgKhge47WbZvvtTvZAeY+2H8l2qGHDqrEfwfwY+XSq9A
6F/n/rBqylKE+ZUgDYsR9oPdtxDhPhgfxf1A/v75Uvp3GxD6webNRDMfGD4w
+8F8YPjB3AcLX/TwBwAkW7gz
      "], CompressedData["
1:eJxVk21IU2EUx8cyWDZKlmlrNtNkM1yF9EaodKI3REpUNAkpmvfep1xQaLgo
CgLFoiTBD2Hl89Ab+2IRYiI5+iAhlhFBQU0/RLUQHbQkysqgnpfDHrpwefhz
z/2fc37nPHnBE9Wm3WazlfFXnM9v7R5s2cAgFD3VvaLBhNPTvuKLAQa57Ymq
oRkDXu8LZrzzMahdsq6/t9sAR1/OQcPLoOR9Zee1OgM6smIv55YzuN7DH7cB
gf7eZMTJ4FnrE7ZyvhGkv13ryV/nm0p/0JSWPgmq8hcYII62jxT8xTxTq/IP
xyg0iQ9jBoxzv29vKHhFfVvMlJbxI1o77UUdWeWWqi+G8YOW9E+LY/7FBDYf
elzu/EKha+R7YcNhAj9rPt3z/Kaqn0sEghn12zY5WEpP8PqjLq2frn7YfNTD
QGApacH4fOSzh8Cuy8en5gsZHPn8Kn/STRQ/zrdO8ExY/+thrSXvOxZUD3nb
Q0UM9gvjLlV/21rMf8FSefwMRLuxZhWfKEC/EMbnaS384zlay/rdqMMWPNj7
4UxmNoMDQl+15LyifL6Cy42bltqHTCbP+kdYL9eS/wTyXobz/ov+nNd9wcdD
oJG3MbCUQamoez1R83JiPzsI8KxJ/yL8v4KAsKtJ03on53n2D01pyZvv092T
ZelvNxK1b7MUhF3PQpwn3y/Jb8xS+aaomldYa1mPS+tKEd9nSr7Z/P9z2/mm
VJmq31nMv8CEGR9vfI4qTgMG8OvjCNiwn051X+LpWot9u+LSWs7XjTxu4/7n
Iu8XBtBkZHR8DYOvkdGKrdN43/zIf5Wp9pnvi9z3Yyb8A/J3uKU=
      "]}]}, 
   {Thickness[0.005020976679084428], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxVVGtIFFEYXVIqRCzCyh5kRoRF9qAsorQjJhH2xxkfO4tEpJFkpYiYWQS9
DYM0E+rbVCLKDAu1tCjbxFQkKc2yMksxKVMRURNfld2XOzQwDGe/e797zvnO
XZ99Cdr+aRaLJZi9/Ou/5+kud1c7PPxKc/sP2NC9Yv3M1TPsWBl9uWo4PQpT
9SmsPVlyrneSUJwUl9UXa5X1ccIG/rgYoh4/SLgwr+XNSIyB3P6C2voegueD
nR1p1QbK6lIc+R1q/y+5vveDietvhpQPvTZxZtWw75caQnMqY9ZoYETvvG13
EL43LmsdO29gZtFiW+xjQlbfie3+gQZiZlu3PCoheLlGevi9kvwu3Scc6poo
HFhlRejmi0F7CwljJw9WJGdECX6hBYQAt4+3EmsinVjo/RTxf31uBOL4QYVK
X3y49Iv1T+e4VQeX6Vmi9O7WsSODnVxOYKzqUto0qYfxF79nafjMidSS1B2i
Sf4NhFl8Ht4a8rh/LSbmba9+MzE/Vu9R+wM0OY8B1f+YhmtH5pypHFH1Mg2M
hcObze+oI3/hWj/dOW/Rr11HK+OzzU3hF7rIRYKLHdzmrZMaKpKzvc5OEBZw
f5M0BLNzjg8qv7wU7ibcqF5anFQZhuXTT+W8bFN+ZYeBrfKNbjKx4PnMxInc
6HsEO9/P+on1eUqPj447rLAuhySfLl3mIVP50RDuxHIeEU4s+j+MlPnLVvzT
otDD9BddJ/zgeVpjlf7nE8Z5PjqtQq/rXcLpHKYsQeWvlHCY56nJkHyeE67w
/G2ySb115LxPgn+ziUfZ/kXtJhbz/0koH/rzPjXIJv0fNPMvzh8mBPL8fTVg
4c+I8uOtIec3amIx5zETT81L+qHu02/lV7/S81fl1d2G+WzZu0mFN9rk/bGY
/w//ALV9GAM=
      "], {{1734.57, 84.406}, {1747.4450000000002`, 84.406}, {
      1747.4450000000002`, 80.64}, {1734.57, 80.64}}, CompressedData["
1:eJxTTMoPSmViYGBQA2IQvWz2EQWDmtkOzy4o3f45L8oBhc8XDOf/qsvaU7I5
yMH6vn/vdCD/KUi+LMiBT3fT3Pza2Q6aMf2HvkYEOaiyNU51roOqtw5yqHip
ZthRP9thQ1HGxLcqQQ5Assa+EcoXCXJgAIHm2Q62XNcXF7AGOci3vg60aJvt
cHqh67bPfwPB5r/vwuSD9R8JhLgvDpMPU8+xRiYqJQnBB9ufClXPEuQwPU+o
+UDabIfc579XfhQKcnhYJbLOPQPqH4Ugh3axm+fKM2c7AH3VnWMe5BCVAgyB
LKj/w4Ig9mUjwmPribJ984F8vySBCMstCD4sPGF8sP02EXA+0HFXKh5GQNwL
5AM1nyhzi4T4F2gfyB3fsyMh7gHyXbpznv+eGAkOrx2ZUPnVkQ5Lge7ZkAGV
3xkJdt+G9NkQc45HQsxPg7rnXCTYP+dTEPxPl3yTBJIR/MtA7o2E2Q6TgMFm
eiwSNby3RILjryEGyn8Dta8ckZ4AtKItuQ==
      "], CompressedData["
1:eJxdlHlI1EEUx0UqJOwg7IBCO8jsj0BREcnqmUWEleys+1sLiTCLMFMREckS
o6LEDu3QdBRN88hElthMzbLUMjVU0hKvVk0zE1ERMZOgOd7uQAuyfpjZd3zf
982WsGhyxt7Ozu44++PfuVMlHwKbKYx2bO1byCBAqpyvT9RR+JMUURu3jYD3
yZrDjjUUdoberZ8b1MEvVw+H8pcUfvD7bTqoODR00clMwYn/Y9bB9mVXHgaY
MF6xDvoWkiL8yhU7lG86MVKkuIg2bjblU5hmZfg062Be/72I5lBofXywcnYF
gdq4+xuuPaLgyT96AgGpkWOJGRTSJy/t865QLOpx1tv4Hj8/i5xJ4ca6nrb5
QuQsCit3Pc+d6tbL+li+VZxdgmXefOz/dLDst4TChbHFpzMFwUKf8xXIw8Hw
4mP8m7xqCjmsjVh3A1j1FPlSFYu47xUzGcJ3GzVIq59z62/CeDUaHGD1LTai
3tMa/GZ6bKynwFRNjdxhlPq9xvv7jcBuuYVWKS5merqbFR/xSfEfNGE8d6Ot
flPsufRJRzx/RqErYdzV46cm9S+jEOJrZp0pFvrc1UT9rWXYn6diS9DtzCh7
TcxrCeO13A/9Bql3KZV9vTNI3YtR/xKD7OcJ1pttkP0UKBbneYpFvbkUuG1i
S1HPHKynwQCZUWuuvs3Gei0GmZfNe8/y7sKYpZqNRf9eir/w/tM0mY/FOxa2
OsR3RINe5o/aAqWf0IP1s5fHu2wENkVLu8nqL5zHK8W8z+gGxWJfWtC/d4yy
/nbsL8wIPK1XJ4XK2b9dCf54/6t1H+T8JrpRvyYN+JRcelDfLE34uZZxEA/k
p1jsR4XBxkKfOr2Nxf566WX/PehPC5H70Wu9T2Dm89GwtF70ez6R/uyjwMPE
pRLp5z7UK5lADBe+H/cxXr4ntwbwPAb5m2JexgOLYvZE2SUPYn1xROo1ROEm
1zORCL3Mw1T4bDGFiPrDR/H3JiLnMW7dJ8XW907oOIT7Na+D9SxsZ6/Vnzr5
/nUpFn7vUCzm1Yb6V8vzwE84rwEdBDK/nmqx7geR3Ix+AwL/v7//ANeV4fk=

      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQPff98mPeJ2c7PLugdPvnvyAHGD/n+e+VH7VCIfz9
sx1+1mXtKXkd4hCVYn3//I7ZDhGWW06U7QtxmHDoq8adrbMd2sVunvu+OMTh
e/DjpbM3zHYo3zdfSr8UKr9mtoNfkkCEpQtUftVsB82Y/kNfBUIcgKRGzIrZ
DhPf1tib3gt2uA20yGY51PxlCL5zN9BFmQg+2HzZYIcCW67ri4H67YBUwd0g
sLrq1VD3rwqCmL8Oal9FkEMhSP3G2Q78upvmvo+Hym9F8PmAdP4uBH+d+8Mq
kYOzHTYUZUx8OwURPrDwAgDwg6jw
      "], CompressedData["
1:eJxllG1IVEEUhrewkD7UzApNMhVS8TNDW1H0mKaYme3IzkosEWYkYRoWaZ9/
QjIqVPpRdEekzCKwkIgSCamwFIKMCrISLKKszEwW01WK5s6c2cH2wrI8zJ0z
7/uecye8rJrsmW+xWAj/mf9Hvq1b77uYwZcXEe/dVRSuG71rO1cw6KypaB7L
cMDWjWeyP4QxOL3y7fOpNgekDxefvxijOWVnd8G5BM07ytOHB5IZ+MffaRlv
dACvVlORysDP5L0OyD1bOTKbhutZDnhVVBYwmMGgeex4VspfKutkMtg/Mntz
4qrkWmAwc3Lfg0O7KYTVj9qs2UzWmaf52ZXN91wn7B4WfvxKPBzsQ7kEAt+5
3Y5srHeQSD+b8DxCoGX8xtPCHAav63gwViLPz2WwwXwi5fur8tDvciLqd+Uz
qO1pDUlcQOCdmxfegnr+2MC0GVXszSLfXhuI/CO8Wb3/hOf3NfK//dGap0s+
ta+ORb2+BD4eDbrdF4f1Qgnk8JyOJaD/ZPSfyCDG2fh4cjsR+ZcmIdcRuNt/
uKdVcQPWS8J8ujWrfBWL88rtHubiuCS7nCd+nqljtoCCKbMhHvXXU+CnRDtj
sZ+PZD+7onA+hqnsT4TmNeZ6iOYmvn8oEPVdpqDmWegP0Kz0Kt7Gbad1ECjk
872Lc0con9xq7O8SnFcHAYv5LGVg2qixSv/5fugvnMj++OP5gUT6W4Z5+Mh8
B4N0vwQHe7Pqv/D3w/Bi9b7gn8ac/aUuzWJefxvoH/1MG/DZ9J9K4FJV4KmH
bqzvxPmfQb6mWeU1Zz3O7uFiM78huzx/BuvnUelH1a+UXMpZfG8XKEy8LCpr
4noyF71pO3AL52HKwPmicl6V/n4q53vSkP0eoPI+cWkW+yc0i+933JD966Oe
/ATfx/tiFOv/wvWF+v5S86H4H0LCfSo=
      "], CompressedData["
1:eJxdlWlIVFEUx4eSsj5kRTtFGxVRUZkl0XbCog/V+OY9fc9WdcyaQscFMVtR
C9qxLCvr1lRmVpjaYH6IqIiQKIhW2hCNFulDlEa0EXTuPed5sYFh+M2575z/
We55I/1ZZnoXj8ezHr/y98LJuyOmZAkYv7LkzveXFuTM6fmiYr2AutzAoc8R
CbA4ds/8lHQBC/ZltP6Zz+wXEDUpfOpLCXOygAdnFzZ8a0qAJcgtqwR4/b2T
ZsYkdnBm659LbaWaf2/fcCNvtA1juhWVxaWyv5AN7U+W+nsHBPSS3N2ByOqh
y98H2Z7lwLV7+TdDGwXsGvDq4Y8KB1Dl1nnFmpWOvZoxRU9hKesvcij+cdY7
xwGVf7XmG3mHB0XUap6IYavqBPSvWfR282wH6jH+8KvsbybrQUaZa2bFcnzk
5vgDx4LRfD7MeiY4UPBp7NTdYbaPcuBYsO+O28gN3/4+K+ijWfXjp93Bc7Et
2U02SBlH3Ofv25R/mOtzy4ZN6D8SuUXar9sqvzrUU4rHpjcQT7nK/QjbUCnt
mF9xWdy+jFq7c/5X7M71QcYsm+PPaFbnz3M9Um2qb6WA5zJRj2aVz+7EzuxJ
VPUJnRPQTya2P4HqJdx6JVB9ywRET8PPA4vmYT/rP2HRnBR15qxtmgeim6cF
AuRYZ1da5D+P7dctkI+PyxEwOMLuNamUGe/Dx0ej3vwK8vkg6zWYM/n5aOJQ
hoCvVY2LYwdrVvq7alb1aTPJfybXp8Wk/gU53kOT7hPGl39Pv2mq+u509YVN
6hfqz5DxL5vQhvflYD7394IJ6tpt4fPnTIpfzP5PmyBlWQd53sr5fLmbP+s5
5fbLBIyWG6jgfDfz8xc5nm2q++WpZvsQE9LQX30tz1Ozj/ThvOG/9/KPalZ6
5mr+ILnRoPmt4fO2Qf6rBKTKA6/iKR+cj1uhIZObznsBp/HAwBIBKdLew0v9
365Z7bMczWoe1gp4jWm8S/eS/9U8z8PiiZe5+RMX2gKKZD4/NKv9GGN0sNLr
NWi+kXGa+9WsM2h+HfZXaNB9ThIg25h70aB9t8Ktl0H1cPWM8dH9Smb7ZB/1
A/ev7Ft9wEf+Ajxfj30gwy5K5/3Q7qN83X0dxfOF+zZOnh9vUpxkntc47n8y
z0eqZtXfYs2qHlUm7YcUtj8xKR+/+/6wyG8a93eGBU/RnBTgfbbNgv/fP/8A
CgYmbA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/fGSb9KEhjkOTy8o3f4ZFu5QaMt1fXE1gr+nZLJE
S/kch8apzt055uEOy2YfUTAomeOgGdN/6OuPMIfLvkkCNwrmOEiyhPHp7gqD
yOdD+VEIPlj9jVBUvkGow6mFrtuKC+c4RFhuOVG2LsSBAQTK5ji4dOc8/x0Y
ApGvnOPQLnbz3HfuEAdxIHW5Fqr/RbADUNc++WYEX3fT3PfqHQh+VIr1ff+e
OQ5rZIAs9hAHsH/7oeY5h0DcP2mOw5wjChuKGiD2N0yZ49AE8u99BB9sXkIo
nC8B8h9XmEOSQISlySSo+/vCHLYC3TO/d47DaaC7P7+FyndB7TMOh9jXighf
9PAHAMF5tzo=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQnTHxbY193hyHDUVA1pFAhy0nyvbJZ89xeHZB6fbP
vkCH6XlCzQcy5ji8UjPkWBMDlU+f43B6oeu2z7qBDhUv1Qw7Uuc4yLe+Dtzx
LwCiPmWOw6+6rD0llxH8drGb576vRvC3ff57paIywGHp7CMKG9Kg9vsEOHy8
5Js0IWuOw1OQ/WoBDsuA8gaFcxwSQAIn/R1U2BqnHq6a48Cvu2nu+3Z/h6gU
6/v+7Qi+KlDeeTKCv879YZXInDkOHGtkolJO+zvMANm/cI6DZkz/oa8aAQ6n
gP4oXj7HQQSkMCcAYt4qKH8Lgg9WzxAI54OcXWQR6ADk9U5fMcfBA2jNuvhA
iHuXQt1fFggJF6B9EZbAkAOGJ8gdT2bNcegAhcfsQIj/J0DdOx+qvnGOgxyI
XhboAI6fsjkOuc9/r/y4CcpHii8AFkrbIg==
      "], CompressedData["
1:eJxlk1tIFGEUx7cL0UurhZix4lYPlbRCEZGyhYdMksRkv4kZyaWHpUI26SKR
W4REYQliFyh88MxDhW1ClESYXbAQXSWttjLaktw02jJLXdZQs6DvNjOEA8M3
v5nvnPmf//xnhe8Q2TfXZrNtpSdbndUjnuxFOmR6L7T/Cmhg8LnU9y8m5+0y
eQM7ShV+v9J4niBipdxzNb8l8VxwpV2Hho7lzRU3CZRd+nkyN0kHtmw8T+BN
kS+5JFmHWHhl/3QVAdKaUX1gsQ5vA8Or1h8m0MgKl0g9ZQSy7upjq1MspkX+
zakWx18X+S6m6bCttvzrzBG53yH1nSHA2takSy4kMHgi5fb2OTrY2cZ6D+eu
PziLjXn4/QnJ+XLeURR6xz18nsh3hOYKOmmvBzKoX60xBDrtnodNHqAq13iH
rP5DrP9Hi110CUYs5n73IRQwIXc8ws8wCr8GZP9eFH7aCUwpnxsdzxDo9E3x
HUT065Z6LhO4Qf1c14Vw+kpebXlUfp8QCv8KlP85bDGv96omL5uv2rOuqWBj
B2Xu9ysV3NHiuqWdKHwZUYG6stDVgVCSc6/72AINqJpQTzuK/Dg0se8pQh6r
z9SA7mpzPkGRl2wNdu91R18+QriVTq9yNTjOGt6X/m+x2Mgr53ezmfsZVExO
YuxUuP5TEakvJP3oR6hhuhpkHgcQxoOhwk00T3zOQfm8VOYrZjHvP2wxz/sP
hDTml1/kPTKG8IV9v7PyfQmE31X+x0evE5GHSYRPxXX1Bz8QM3/cp7WKybx+
v2pyS+JvX+CBKvyakRxXoZPa+G1a5sUu/ZhC2El/uxyXJvIyIfW6NTHPqOWv
wYaf/wDT9wrw
      "], CompressedData["
1:eJxdlAlIVFEUhkUqJGwh2qDINpcMZUwtLbOjZiZW9u743pvEpCYt9xGTijaK
igortU1aLi2iFohImJRIi+0IFmVEaWhlWYmoiFhJ0F3OzIUGZPy4d87yn//c
OXYHSXd3c3PbwP74N+2reppgUvj6am7b7/MEyJ1ZR3rWUvizP6uxcB6B0NSG
eM/VFBakFDcNdWrw0yfIozqWwjd+v0WDmrhPuydHU5jM/6nTwHvMwXMxkRiv
UoO23/uzIpYq9qiemdwVrLji0uPZtYEU+lkZS15oMGz9UnHJn0Lztdj6wXEE
GgvPTD/sQyGYf6wEYopyuvfMp1Dau3dFaI1iUc8sq4tP8/OtyN4Ujk593zJc
juxLYXzALdr3zirrY/kmcPZKknkDsf8tSbLfUAq53SM3B64nCX2yI5A/J8Ht
5zvuXYmjcJm1UWDRwamnyFekWMR9opjJkLbMNKCkacivXcd4DQasZPWNENS7
34BfTI8Z6ykwVYtyfE2pXwLejzaB3fJLWaW4kulpiVa8ZsnxqM5IjGcxXfXX
FmSU9nrieTiF1l0/fIK+G1L/MAq28DrWmWKhT7Eh6m8Ow/6CFXcknizLczfE
vEYxnsL90K5LvRdT2ddDXeoegvpX6bKfRVjvRV32Y1EszgMUi3oXUuC2KbiB
evpjPY90KMubdOiBH9bbocu8bN7Lx74rzx9tuFj0H6L4Le+/xJD5WLx19om2
8C4DPjB/NFqUfkIP1k8kj7fPBDbFjpeRTn/hPOIV8z4dmmKxLzb07ylT1r8R
+7ObwNOGbKZQP/i3dVcU3k9z7oOcX0866vfMAD4lr22o7wVD+LmRcSIPFKFY
7EeN7mKhz32ri8X+hlhl/9vQnx1E7keG8z6Bgddr7SUZ6PerRPozkwIPU1hE
pJ8zUa8DBPK58Fm4jzvke3IiG8/zkXMU8zLO5ipmT5TbgTysr5BIvRwUjnE9
9xChV10+FT4bOU5E/Wnb8fe1RM5jp3OfFDvfO6GjA/drWINpLOybDKc/Nfn+
2RULv6cqFvNKQf3vyvOEZJzXRw0SmF832Zz7QSSb6Dcg8P/7+w8QP7sJ
      
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQPff98mPe4XMdnl1Quv3zX5ADjJ/z/PfKj1qhEL7v
XIefdVl7Sl6HOESlWN8/7zbXIcJyy4myfSEOEw591bjjPNehXezmue+LQxy+
Bz9eOtturkP5vvlS+qVQeau5Dn5JAhGWLlB5i7kOmjH9h74KhDgASY0Ys7kO
E9/W2JveC3a4DbTIxhRq/jIE37kb6KJMBB9svmywQ4Et1/XFQP12QKrgbhBY
XbUl1P2rgiDm20DtqwhyKASpt5/rwK+7ae77eKi8M4LPB6TzPRD8de4Pq0T8
5zpsKMqY+HYKInxg4QUAXdCgMA==
      "], CompressedData["
1:eJxdlWlIVFEUx4cKWj7YQiVZ2UYbKZFpKmWdqJCoxjfv6RuJiJSiXUOizMrM
cCtLk9TMrlamppSJmIm0iJWGQ7aYOVOJWrQRUSaiJkH3vnPGiw0MMz/OfWf5
n3PPmxUeqe4YZjKZdvOv+O2MmVjWkMVg4Za0uh67Bu/6Y/esOM+gPGrX+R8j
giFpsqOpN5XB2jP7vgysJk5hMNazgv1MI05kYLu6rqq7DflwAgNz+LhQf++Q
Qd7/ZaCkK0Pyn9g99w7O0SG9rmfB+2Tyl6+D+ClOY+Ai/oy0whoe92gW2SOt
MCPhu8Uvn2HcAis0bwofZy+R7LO1Zn1qheTl7UFnXWso/5NWjF9L+QZY4YOo
v1lyr/axMPeNZK7CsVV2BpPKAjtjVljBncevtpM/f8rHweDmtM3bl/tSfM48
bHaEF9qrHZTPIitUPj30YMZbss/G/EM5V3X/fR09XrLRjz59kFeOaS040KbD
t3lLRnk4n29Eu91B+jzU4Q73n8+5Q9hrdBD9DeScwcvwqUJusFM/KsjOOT6T
K31bH1r/LX2oPpyfzCyP+toguU+ct5EeYTrq+4xBSzTP1CTZqCc5ZCibQlC/
RgYThb6pwajXI6deyH73GXgt5R+bhvNQSflf0kCESS6RfEQIVChZrXZP2HuF
QYDQr1BD/7lkr9EgO2LCqdqLDKaM0F08M4j5vH1+MftdfwSdz6R8FQ37f4Ge
90K7H+dfxfUbfKdINvIfLtnQp0tF/xdInw4V+5dJ8ZpUfI7HF2Pn80A19J2a
Q/lVqNivywz2ifilqnFf5udRf4tU4Len3naNzl9TMX4p+c9TDT2+36V5y6Hz
tc76KZ/Hzn6pYBIfG9UbQ88/p3i6atyv7Gayu6G/Da00T+0WzI/PX6g/n/ws
yUY+KyV/Elyv4Py20HldQf9NDMLEAUcQ1sPze5jvtrjtuhkKcx/PLK9isE3Y
R5ux/0WSjX2WI9mYh3MM3jbxSd9hRv8JNM/Tg5DjnPUju8YyOCnq6ZVs7Edv
ZZCNfM0KzjfnQNGonQrme4L8xSl4n7l/kXbUDQU8xL6Ld+qloB7OfTrXgvcx
keyLLdiP0wzEeq3cZUF/6TRfLy2w0TdldUcq7YffFqz3NO2HsTRffN+KezSw
UMV9lUTzuob6n0jzESbZ6G+8ZEOPYhX3QxLZX+E8Fqc43x8adL3aFJ5+hvq7
TMO9nkb77LgG/79//gEMo0pl
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQrbtp7nv1FXMdnl5Quv0zLNzh9s+6LJvFCP6P4MdL
pefPdWic6tydYx7u8KhKZN3x2XMdNGP6D339EebABzQgf8ZcB0mWMD7dXWEO
D0Hy06D8KAQfrP5GKCrfINTBNG6XJ8/MuQ4RlltOlK0LcbC+7987fe5cB5fu
nOe/A0Mg8gvnOrSL3Tz3nTvEIWiHXGv2Uqj+F8EOcq2vA3esQvBn5Ak1H1iP
4B9V2FD0YvNchzUyUSnW7CEOYP9uh5rnHAJx/665DnOOABU2QOwX3zPXoQnk
3/sIPti8hFA4XwLkP64wh3nvlx87vRPq/r4wB3mgeyy2znU4vdB12+e3UPmN
UPuMwyH2rUWEL3r4AwC6asOz
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQfdk3SeDG1LkOG4oyJr49Eugg1/o6cMekuQ7PLijd
/tkX6ACSj5gw1+GVmiHHmhiofN9ch9MLXbd91g102HKibJ9871wHeZD4vwCI
+p65Dr/qsvaUXEbw28Vunvu+GsHf9vnvlYrKAIeHVSLr3Pug9vsEOOhumvte
HWj/U5D9ahD54zPmOiSABE76O/Qf+qoRs2iuAz9IYbu/w1GFDUUv1iH4E4Dy
d3Yh+GB3H57rwLFGJirltD/E/pNzHTRjQCYFOJjG7fLkOT/XAeiKh1U5ARDz
LkL5WxB8sHqGQDh/9hEgwyLQYRmQYXBhroMHyKHxgRD3noG6vyzQISrF+r4/
0L4IS2BIAcPTuTvnefWhuQ4doPCYDVHvvgPq3vlQ9SvnQsJ5GST8b8yd65D7
/PfKj5ugfKT4AgDWZeAk
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQveVE2T75L3Mdcp//XvkxKNRhnfvDKhEgX5IljE+3
KsTB27zTMeH7XIerFS/VDC8EOzCAwL+5DhuKMia+DQl20Nk09/1ylnkO2z7/
vVJxM8ihXezmuXKeeQ4dQPr77CAHPt1Nc/NFEXyONTJRKdIIPsi+KQrzHCa9
rbE33RYEMV91nkMOyD2vghyOKABt0pzn0DTVuTtHPtgB7F5dqH2VUL7BPAfN
mP5DX38EOyybfUTBwBjKvxHsEJViff+84TyHRpB+92AHVbbGqYeB+sH+PRTk
8OmSb5KAOtQ+ryCHy0BuBNA9v+qy9pRcDnQ4vdB122fxeWB/vJ8e6OADDI8H
vAj+UaD7XjAh+HtKJku0/Jzr4A80xvJOINg9Gz5CwysF4v8nL+c62HFdX1zw
FurfZ3MdyvfNl9JfGgzng8Lxe3cIqnxrKIT/ai7EPvcwCP8TVP1lKP/XXAd+
kHx8uEMlMNo4gPED9sfScEh4CSD44PiVQvBVQOGjNA+iPz8cHH7+wPAHm88c
DnG/Psy/YfDwBocvO4IPS08AL70R5Q==
      "], {{1917.031, 86.73400000000001}, {
      1927.5939999999998`, 86.73400000000001}, {1927.508, 88.202}, {1927.336, 
      89.23400000000001}, {1927.078, 89.827}, {1926.6599999999999`, 90.753}, {
      1926.039, 91.48400000000001}, {1925.219, 92.015}, {1924.395, 92.546}, {
      1923.535, 92.812}, {1922.6409999999998`, 92.812}, {1921.266, 92.812}, {
      1920.031, 92.273}, {1918.938, 91.202}, {1917.8519999999999`, 90.14}, {
      1917.219, 88.648}, {1917.031, 86.73400000000001}}, CompressedData["
1:eJxlVX9o1VUUf9VYsmANGWYxWGolQUZBomK1ExpCOceuvPsd0R8x+mH1cmuO
OeebtEpKTKfmctW8D5lOWvVY7pVaI8T9Mg1Xy7KVsRprbq0xV0jp1Lr33M99
l8f74/H4fM+5555zPp9z7pzSMvHM9aFQaLv+mf/sBYf2Tm5T1FaxZudERNJU
f2Hpjt2K6hqWbY2clfTGrIHT6xsV5cZX/FaTG1DL+123t72r+Ps/8wIqfyjr
bHMT7CsD+q6wNOfHGOwvBvTE00sHi5oVLd8aOT9dF9AdmXUNnS2KTJiKRhvv
vlb4Nwf2/o89vlP7L2v3mP2PKLpwsOfxRVsQvwP21QGZesqOKfooT1vy4d+p
6NYMmb2gH/V1+XrZ/5SiVaU5JUv+lJS/ebx48beKbjZ9KbDxJr9X9v851PsT
7PWB7c+gz4/jDXvM+Y15/OmJqi9jE/68LuKRp6Z8/IS251/09+vT2275V9HI
N3N/vnRN2niXkf9+yf3pnFb0u7E/K0lTGnrliqJdE9GChZkev3R++oOpV8NJ
zPGyVyfx5U0vdFS2C+rWtIxeQfxKQY1rZ7527CrOC0GGtjXX4L9U0MumH/9B
L/OFrf+6mM1nlrD9vCGGfASZsuZnxujUvkc/+/tqMelbogVZ6Zjv7yq2/P2i
0rDz/0vzmTPoMfd5yOMNY3fdP2NE0WzDf5aw8UdRz1xBQzW58d4x8P+AoBla
OMN/QD9FwuplHPytE9z/vnHE32zrndRYX3am+qjHrr8Ou/6n+F8K2/w0fli3
sbxQ2vzGcH6TpHu0+8ERnD8uqaPy7dmvD6Efw1YPfec85nkZ8Nj0/4jWb8kS
rawfpO1fP+bxqLR6Po169kqe35KTyO956K0b8fKk7Xc3+nGTtzPfPeEkdvU7
HDH5t0Iv3dgXEdvPoh43v4Lry+hV9KbBWl/8+YTXF/fnpErqi2n7WiX1xXru
8/zzPJ1Jx05Pxj/Uko5T9POhxxw/jnxuFHZ+28DPbYL0koyvOKTIpLnwXmHn
vR31Pwb/hKK7n6w/frHc5p9IOH0IWqntvyYQ/7DHrp8OOz057PTE+6Ad/quw
7z5x/uA77viCvRX5jILPAx6zfvZ5zPpRuG9A0gGzyN9D/M8l8zuvAfP0lrTz
tAP1BHbfJt+bPI9T5sXhOPjfrqjJLB7dL+av3uuFeanHvC4SNr+dyG8O5nUX
8puJ/bQb92dgv+3x/O4xuCkdO30wn2Xp2PnzPlnnMfNb5e9j/qt9PqyvmtR8
izbifVyMeqJ4HwJh568W9a6H3mvR74THKfu9Fvc/GE7F58I2fi3mcTn0EHX7
Ttr3J4r98Y60+W8EjgPXYF6/AN6A9/kru68yqvGe9UFfVR4zH5Ue8zxXoN5e
mewv48PS8r8WerwA+5bU99fox+H/AcCJYGc=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQXflSzZDDfr5Du9jNc98XhztMOPRV444Pgs+nu2nu
+/D5Dvwg2j/c4WGVyDr3hPkQ8eVhDkcUNhRlpM93mA1iSIRB9GVB9ReHwvku
3TnPf+8MgfPXyESlWJuHODCAQOZ8h9znv1d+3BTsYH3fv1c8db4D0NSJb3WC
HUDO00mc7/D0gtLtn8uCHB4B7T8eDTXPMcjhKNDaFyHzHU4vdN32+W+gA9g/
fjD7Ah36gf6JcYO6d3ogRL0tgr8M6HADAwQf7D/V+Q5NU527c94HOoCE1WXn
OzwD2T8vyAHo6vv+YlD3GgVDzBOa76AZA7TpBhp/QgicP+ltjb2pGDQ8RKD6
Z4VC/CsJNV8uzAHo6xp7oH2/6rL2lCwOc5BrfR24Q2m+gy3X9cUFrOFg/eWa
0PBxCYeoB7rfL0kgwrIFEl/55oj4Q49fAPKN7e4=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ3S5289x36/kOHWA63CFoh1xrtgWC72Pe6fjAZL6D
kTEQaIc7XPZNEogwnO/g3J3z/DdnuMO898uPndad7zD7iMKGohdhYP2vteY7
nF7ouu3z2jAHIC9wh8Z8BxeQ+sgwB6CVDA1qUHnWMAeQtgxVqPzMUDgfLC8a
iirvGOJgGrfLkwdoHpC38mNXMMQ9QPs1Y/oPff0Q5LDlRNm++UbzHZ5eULr9
MyzIwfq+f+90S5h7gxzkge6xcELwX6oZcqzxQPDB9vjOd/ADGmtpEuSgu2nu
e/UgqPkdQQ5RKUATw+Y7THxbY296Lwjivoj5DlcrgCYVBMP5z0D224XA+ZIs
YXy6TqGQ8AmB6ucLcwCHP9C+XJB/FoU5ZIAkPKH2cYRD+M6I+ECPLwBf09Cb

      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQnTHxbY39zvkOmjH9h75mBDk8rBJZd3zLfIdnF5Ru
/5QLcuDT3TQ3f8N8h22f/16peBnosGz2EQWDNVD1JwLB8u+Xz3cACm8oWhHo
cNk3SSBi8XyI+HSIfP48BL9d7Oa58ikIvipb49TD3fMdHvj3Ts+7FegQlWJ9
379lvgM/SD4+yIFjjUzUk5r5DuX75kvpPw2C2F8532EOyL4JwXC+S3fO89+J
IXC+MRiEQsyrne+Q+/z3yo+fQh0+XvJNmtAKdf+CMLD8+V6of/3CwfalzJjv
cHqh67bPS8Mh+pci+GD/rUXwGUAAGF4bikAhGe4AC88ckH1aCD7Yv+YRcH6E
5ZYTZfciIPp3QvW7RIL5DTug+rMgfIYd0PCfGOkAtN3SZPt8cDh+Xx3pADRl
n/w2qP93RjqscwfG4FaofccjIeG7Geq/c5GQ8NmE4IPjYwOa/Lr5DpOAzjQ9
Fgnx/2qo+7ZA3bMKyn8DVX8Uqn9eFJi/4SQmH+we9hA4XxTk0JhgiPhJqH8+
Q9PbKWj4noXw35+Cpa8gB/nW14E7Ts93AAWjaV8QJP7OQO2rg6o/O9/hasVL
NcMCiHqL84j0vRRk0AUEH+z/Swg+KH5vXIGGZyHU/OtQ9zVDzb8B5XtD5fci
0jNKfAP5AC/RrC4=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnTHxbY39zvkOmjH9h77eCHJA4Z8IdfAx73R8sAPK
FwhzWDb7iMKG7fMd7vv3Ts8LgvK3znc4vdB12+deKH/zfAfn7pznv0+GOVS+
VDPk2Djf4ekFpds/v4U5zMgTaj6wdr7DhiKgTSLhDqeA+opXzXf4VZe1p8Q4
HGL/8vkOuc9/r/zoFO6w5UTZPvklCP7DKpF17vMQ/HXuQJGZUPdJhDsAvcTQ
MAVq/pEwiPl98x0mAY01DQtz4NPdNDe/e76DCEjjllA4nx9Iv78fAud/WH7M
25wzxOGyb5JARB/UvJRgsP8MpkDt/xTk8OkSUMEsqP0NQWD3TFkwH2zOe/cg
iH+XI/iPgO4/vhbB3wr033xgeF2pAAZUBVr4A+MDAEUb0Sc=
      "], CompressedData["
1:eJxlk21IFFEUhjfbbNFcjSQ1bbf6EVoqRUjKIh5KYUlK5m7MLCn90AoRqRQx
s5DoG8JKLPxhcW9KmRAqkVFp/pAwwT7si7CoTS3Nz9zMSk3qzL2zM4QDy+zD
nXPPe9773tXZB8heP5PJtAV/6vti+1T0lTAGMVkX2qdKFPDxmeU9z34t3Knz
JvXJdEHqufzBFt/6JOE8i9x1Le3u5FPBjnAG1Y9WNRXeJNDcWdxGkSvGjqYk
nCcwtHajJTaCwUD3mvfTZQTWYd9m5DcluHKQwKvt2SHuFZqeXAJh2GZZpMHj
uI0tyuDDWOZcyYSOAgKqrEqbpu8EgYdFleGpdo3TCRQkB7ytXcrAGnf76rcq
iXNO8Hz2zaPWHQrUOI3AVuxzxKLpnZBgGOfJ92fQVJhbMfZEAlQVnWVmgDJ3
P6iXwNlbGhrvZ+zfVxra8Pgv1TkWX3UzBttPjUiJPymva2iURP/vVPj1UQIb
rt8bp8JPK4Hfrv7rkaMUcPp67zYi9humQs8lAjfwIDYMUTh+GZV7tHm+UuGf
0/U/dxvM67NknSPMsjWuRgaT+iBzv1/I4PBklIcNUuHviCzOd4CCO+lOZ7G/
Aqimo+szFfmJVMR3fZT7OBujAH7VZu+lIi+JCuza4/A8/0DhVhT+S1H4+Vp6
qPA/2WBfXjlPz2fuZ51L52CV7S6u/9iMpq9D82OOwllVVzXh+ySYGEzUdaRv
xjzVYNu5BUysZ2p5NBvcivk6uchgPs9iBuGqX3mE52MU8/JFPb/T4n60BDCY
KctrLaoVeexfwuBTRnnV/ndEzx/3ab1LZ16/T9YZVb0uuS9DPI41aNXYK0NO
iDvpR5B2v6wK12dG3oHXKilWgT/13pdBgZpehyLmsTDdXx/7/PwH1uD2Cw==

      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvdB12+daowUOzy4o3f45L8oBhc8XDOf/qsvaU7I5
yIEljE93E5D/FCRfFuTwrsbeVM54gYNmTP+hrxFBDhUv1Qw7jKHqrYMcunOe
/9Y0WeCwoShj4luVIAdp/bsqbKZQvkiQw/nvwY+fAvm2XNcXF7AGOcTt8uRp
Ml/gcBpk8d9AsPn3LDH5YP1HAiHuU8bkw9Rf9k0SmKGK4IPtV4eqZ4G45xiQ
n/v898qPQkEOQFfYdmlA/aMQ5CDUfOCUouYCh8apzt055kEOf1Z+vNSrCfV/
WJDDIpCxmojwAOkz1Vrg4JckEGG5BcGHhSeMD7bfJgLOB5pypeJhBNi9EkA+
UPOJMrdIiH+B5reL3Tz3PTvSQRjonoVAvgsoYCdGgsPLCSa/OtJhMdA9ezWg
8jsjwe6zBfKBsTb3/fFISHioQ91zLhLsn7NqCL7HwyqRd6oI/k651tcXVRY4
THoLdMixSNTw3hIJjr+lSlD+G6h9Boj0BAB+6C6z
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQPeHQV407bgsccp//XvkxKNShdLIEyzUgX5IljE+3
KsTBuTvnebXHAoerFS/VDC8EO8x7v/zYae8FDhuKMia+DQl22HKibJ+8/wKH
bZ//Xqm4GeRQCVTGEbzAoUPs5rnvs4Mc9pRMlmgJR/AXum77XBuF4IPsE4td
4DDpbY296bYgh7lA873jFzjkgNzzKsgB6ESGhsQFDk1TgS6RD3boB7o3Jhlq
X2WwA9j9KQscNGOAMj+CHQptua4np0H5N4IdkgUiLLekLnBoBOl3D3bweFgl
si4Z6t9DQQ4gZwQnQO3zCnJoBwnELHD4VZe1p+RyoIO0/l2VYxELHPh0N819
Pz3QwQUYHruDEXyQ+xz8EPw/Kz9e6vVc4OCfBLT4TiDYPYtdoeGVEuSwGOj/
vY4LHOyAwgVvgyDhab/AoXzffCn9pcFwPtgd3SGo8q2hEL4j1D73MAjfFar+
MpQPtJ8fJB8f7hCVYn3/PNB9p0EBvzQcEl4hCD7IP78jEXxQ+OjFQfXnhzuA
vFGSCDWfORzi/hSYf8Pg4Q0OX3YEH5aeABV7Les=
      "], {{2083.4300000000003`, 
      86.73400000000001}, {2093.992, 86.73400000000001}, {2093.906, 88.202}, {
      2093.734, 89.23400000000001}, {2093.4770000000003`, 89.827}, {2093.059, 
      90.753}, {2092.438, 91.48400000000001}, {2091.617, 92.015}, {2090.793, 
      92.546}, {2089.934, 92.812}, {2089.039, 92.812}, {2087.6639999999998`, 
      92.812}, {2086.4300000000003`, 92.273}, {2085.3360000000002`, 91.202}, {
      2084.25, 90.14}, {2083.617, 88.648}, {2083.4300000000003`, 
      86.73400000000001}}}]}, 
   {Thickness[0.005020976679084428], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{1451.8629999999998`, 
     387.05820500000027`}, {1676.816, 200.15120500000057`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0010745144856945108`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     1487.2065497679998`, 357.69506056000046`}, {1519.5626490640002`, 
     360.6831303959998}, {1443.027549768, 394.4019779320006}, {
     1490.1954504720002`, 325.3399612639996}}}]}, 
   {Thickness[0.0026865132860605], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}}, {CompressedData["
1:eJwtUwtIVFEQXSREQkRCQir8JJSUWlKmJeZYqUlGavkXyzUhIjRFuu89JJKK
CpMKq3tBRCtMAjEJCwmxDE1LzTLK/JWllZrrskqZZNS9b+bB4zE7954558xZ
X2tBUp6TxWKJka/68vwVZ58WC5gtiQzJthpQW9nu07hBwJVnP/2zKjRo6jrV
6t1L/V06HLtmK4m0CTjy9fXa4UENMo6GfzowLSDZLfBBVbcGF1YOvlr4ImDh
4Hht5ZgGLcUVnuc+Clg+cOdkxIwG6ph9RIBN4c1qMNe/3+o+RHgODazuadub
3gtQsOWyjg+9FDXWT3xsGjTEfjY8+gRUeC5LcZvSwPv8j8SwF3R/mPi0Ud1B
/POIXycDofQeFnA7+tH832aGfDIFhGQ/jnOtZ3BX6U8X8KR61abRGgaFEZJ5
qoChxdPHW24y6L4lL6aQnssMHkr86lTiV8pMftfTaH4hg1ylR+IXKeNyGFjU
kyNgfbBL/ZoEhnxzya+92D8j+UlZzV4RyGezP+E7GPoVQP4tMdxXEM2bZ6Bs
41uoHmfQ4dNYNBkq4LfCHyK+4TT/A83bKSBFGfGOgfw1YyKK/B9Afn3RhDfK
TL+b40j/BEN/EwU4l97YXfaL9GWRfx64j777pOcf7duV+vEa6nOh+emUjyTS
G2hgf5Gj3q06OOT9qw6OfW8dZBoaOmc47s9dx7xM03lnHfVPcpy3pJnnY2Xd
2yOfOQ35TnH0Y1LDfMi6yl73fN8onbdx2FN24vsfmW/Tv3k630S1nfjco/y1
c9znNh3rLupH6ajvJfEJ0+GttCPtDeH7oZ7YAY55Wa2D+f8c4eif1Bsgr9eN
cdihjPclvG8cWhVeEPljJ/0x5Ecm+VlogDa1LviirKVbThtLDfBSwBkC8coN
E68gnfbFDTP/fjLPKlb5NQbo8r5LMuW1wcD9J9D+2gzc7yHq9xjwH17eF50=

      "], CompressedData["
1:eJxFU3tI01EUHhYhFRSk0sPsaYUPLGzRjLEDKstCakoQFSPsgdUw07i3ZBaC
o2LJGhm7JhYltqxlUiuWjGzOyixkFRSzIioiaoj0nPaAzv3dI/4xtm/nfud8
33fPXVC2v2RXgk6nM+FHfgcPnp45MbkJCpy2T3/0HDrM72oanwiILHw1esTG
IH1S3Zn8sIDJL1srjRsZPC8um765RwD+67QVM8i+0TLsDQnoPj875806Blg1
rAwRfy0DV8/PZdvuCRiym/TWAgbHUqID8W4BOCapw8RAm4/1p/J83jjW+KsY
9M7vrCpH7EvdsnNN7nh/rO4NLmdw+POSFYmopySQ5ohlM9Bbu4pOot63Gxo8
FVlKf/g+6Ud8btj74PEj0p/JQMopjQiwSH4O4aiAPH8fu2tgsFjyBwmnM2iR
/AjxZ9H8Ppo/g0H/hcLb1WN6kxmcQv+vAwLipR/amlOYlm/STeo3l/B18pPB
QMZi9gkwyHouzb8iVI5GlU894qpy95DdTPczhi0M5jliltVXBWz/iAluZZAo
hVyjPHdT/jivq2hqQmY1zfcTv47BDszXf4ewW9UbQ6THy2AEfczpJH8e4l+k
eW7y7yE+1jVfLtLfzLSc9p0gfhv5qSd8i+7nqIBByetVea+vpf5R2o9a8vOD
8rELQNuBtGlc9Uf+FHnfGVydd1DehVzl0UD9K7jq3yQgX+6/i6t+l0l/O1f5
Bqh/mKv9ekj7NMCh0oi/XtD99XMtX/6e6n0cvuB6+GIC/rZ/fVYcpH7fBGBM
3/9d4uq+fglYisdSz3LIku9phPJw0nscJT81HA7hvh3/TXnuUfwA1jUfmzgc
QD2L4kK9Z6PCrROaVF5WDv8B/PDpng==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQLXbz3PfgdzMcXLpznv+eWO6QJBBhafJqhkNRxsS3
NfPLHeRbXwdaPJnhYBq3y5NnWbkDxxqZqJQ7Mxystpwo27e03OGyL1DHxRkO
IGFrIH/Coa8ad47McLAEyU8vdzi90HXb521Q+dpyh8qXaoYcK2c43P5Zl7Un
qdyhAsjvmAc136Xc4RRQffF0qHpFqHmTZzikWN/37+Uvd/gR/Hip9KQZDhIs
YXy6/8og7gXyFwGt+fumzAHsHyDf/WGVyLrbZQ7z3i8/dhqo/22NvWncuTKH
Aluu64unQdUfKXN4BXTOmrlQ/68tc1gH1DgF6L6EpxeUbq+EmrdrhgOQ97Nu
R5mDzqa575dfgMqfLoP44+EMsLtmf4LqfzvD4RZIXAfq309Q/zpBw/cL1L9h
5WD1Il+g6tOg4fUZ6t9yhH6w+1rLHdDjCwDrS+Rc
      "], CompressedData["
1:eJxFUltIVFEUHaIg+giLKCjRDNI+MumnEjFW5EAgovagiIIYikSsxDinlxQ6
DGkPVCLmHCjsQc2PhYSERFRENUEPiolSK00tBhsiRotRRqt97t7hgctlsR9r
7bV3TuDQ5n0zfD7fKvrcPzuUqFwXsCg5WxNP92rk37n8M89v0ZG5c29Rs8aT
pZ11VVstCrue6wfbNYaOL7gdLbPomzhZfb9EYyXlR9ZLvdI4vbD39ZG/BnVV
bT/qowqurH3c4GH74oLPXQobKe/EL4PK7qxQIqJwbCR39ewxg4+u3xWF8S3D
N5aMGsz5cL22+JLCdwp3JI1Xlw4rOL3dhD2+Cwrm4Pzgo//xFubLHhW+cwqx
skBGD+G3y4jhjGJ9xN/y+PeKXSGFo8TflDLodIIbRc+k4fmDiuf7Y9BwkRiC
3G/HLIs8kpXZpFA0UH5+UYb41SbxeRbX/HfHpuoFz7TYNEjGHRC9Ewbb5pLT
+7k+nJT5q1lfKmHY3xoFYn9WGjfs/2HJHxZ8SiHs+n0R/aTH29/AtD+ONtpv
WA/56+2zX+K3RB/le/Pck/6DMv9T8eur4JhCK/n2aUTwN8X3kBScZv5IgcVV
x3dTs585Fm+c/+8FL7e8jyHNc+dbuLVmxTR87q2xvJ8XmvdXLP4S9u7BP41L
1zZv2FNh8eolvXd8f6ndlu8hrvEPZTVwXQ==
      "], CompressedData["
1:eJxFVGtIlEEUXSRKKiwiMsrUklI0M0krM/HiMzU1FzRfqZmvfKbNfKWGlGFJ
q66WpUOI5SMJJCQypKIkLIMeWP7IsoiC6EVJRISY0MzOCReW3bvfnXvOPefM
rs0uM+famUymFPlWn97XO6bcBwVVFLR8P1Zp0Puq5dciYwXtuPHIuJvCKdRS
/Kk6X9Cil92Hgqo4qbbgKkHW+7890i2cAt/FN7bVCep3Ss0JbORkHnKu+9Ys
6NzKeUkOVjwXgtx97fudTqHuFPR83eR0TQUn2Z0w1CVoTNUF+nxRjyDP0yte
PUvD8x48383JP+NW1OJeQepn5yBOHyTf0W5BkpV/xiZOD1wHKj5fErRQ8XXl
5CAXLOsAvyWcxmOzlya3CzqsFpllmk+LoK7wm79mvzLaKPXoyxF0WdWljK5c
HHHdnClIreOdxfT+6YIClD57mW3eRBr0StTzHNOwr5nR6+mawjup4BPHbPqO
pkLPaEbNUsc3qeiPwHx5/l7nKp+3IYyUDH/SsD8xkuwePpb4u9SgIEYK1iUD
/HaiX/INk77NBDLtRy78CgR+sSCpop1XMKOjXzb41jP4H8moUtb2BvC2oi4X
thzM+DCtb6GgAXXAk5HKT98B6OvOtN6SX6L64ga8JOC5QV8z+K1n9PNFbHZz
HPb10HyLYgRlfZQMvBm5SKO3R8EfP+gdIUjR6pf7ygibjofP6WfrDwefBOwf
Bv3TGbWXLjs5HI798nT/UCT2K9PzTNHQqxr7xAvtYwP0SMa8HqbzWQu81Trf
jvVC59QTebTgPmzjNr3cm+B/CNf5sgIvktOg9LNT1k+fyJfMu/LziBX3xcxt
/sdYsW8y1/o1Yf4+ru9vI/js5zQi8QssmJ/PqVfiDUh+OYpoEfjUIb8lmFeD
8+U4zwXlqv4S3d93UNCk0iMb9ysP9yET8//nfQ/OR6D249r3YPD14npOgKD5
J86HWpwxfwv0duDazzXI5zj0dgC+nb7PE/XwM8nQ/lwAn2pD47cJ+qH+H2oN
7YesFyi8M4bOfxv4tRrajzbkr2Nuno13L+pW4PUb+v6eFfT3qlRuwLDpMdUM
vQfxf9oEPrdxvgF5HjZ0XqzAHzPoH2WIjxw=
      "], CompressedData["
1:eJxFU2tIFFEYNRERER8VGqZmBumPIo2WMBFPVFRUSApLRKgsPSxFc+5Mothi
hFSIlFSsd6QWEwtCli00JCSlB6XV5oPwVamU9NjsoaurqdGdvR80MAwf537n
O/ecb9ZairOO+fv5+aWJ1/j6ni6OndWFnxcaFbS+OPPIfoKjOebw0bRxhv1b
L20fK6DazdAi8DUlHB326E3vhxmexTuVLyrH5cczSUd6GfJrJysySjmG562n
2l2El3OMZdbYiroZStKDB9ZZOfImehJGuhhCN96/8bOS49auB9NLr2RdXMXR
mzAyb+1jeNkggGqOq6sCzKFCjyG38hrHiME/xyBUjb75TvomVUz1HbCEe6he
psn+OdIXocn+BY5txkViqV7iEDSZNYkaDDmJfzlMOQ/3hmz+j/v40jVEDbm8
/Yscgeeu76jeo6Hs6/qUoD8cwQONp9PNmvRnhurjhHto3kkNt+ufxidPkz+F
Gn4LvVemiL9YQ5PAnbN0vkyTfm7QpT/dqjyfpEMxgA6qEwjvU6W+WB09hn8f
VOwT+eVF6zLfcVXmEamDGf0TquRfocOb/bGp/hOdDyP+URXj5Ssdz0OI752K
C5FDrtJAXebxWpV5LZL+e6rcnybKp5PBsVsw2Om+DoZ+Ec+gzlHlPtgW10D5
13GkGve1MZ8/ThuH2QBqGcQ4b7aN+C7SPtpo3lkGS/ih1C2iP6strsqtyX3I
1KkukHzJN+l8LvXfpX030T63cOQa+xjFIKYr+e1c+hHAUFe0/HznE8pzUZH7
If6XxJSg5phZxeeH18WlPx5FznvLpX9eReYzSPW87L8zyvGjIsOU40/7/I30
REg99l+kdzXp95A/YQz/ANtgzGM=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQXWjLdX1x/iyHDUUZE9+eKXbgWCMTlVI0y8E0bpcn
z5Fih6Adcq2vi2c5nD0DBDuKHVTZGqc6l8xyAMoyaa8udrC+7987Hcj3eFgl
sm5usYPuprnvlwPVA1V150wsdji10HVbceEsB5CyvLZiB5Ayd6B9YHOrix3a
xW6eK8+B8kuLHfaUTJZgyYSqLykGu6MndZYDUDSMr7jYAWjq8+qkWQ63ftZl
7SkrdhC/ee775XioffXFDkkCEZYmsbMcAkHmtRc7JAP5W6Kh+icXOwCt+x4c
DfXvgmIHF6B5v6NmOawH8dcVOxxV2FD0Ihrqv93FDuvcgS6Og/rvKNT9CbMc
XqkZcqy5AJVPnuUACp4z16D+TZvlALJO90axw4RDXzXuAP0DMr7mJjQ8gf61
2nKibN/VYgf08AcA2Ry9kA==
      "], CompressedData["
1:eJwtUm1IU2EYXSvUQmWEloiMmjjNtcxyUVl5QPuQiuGEEqEhc0FY9PG80TdB
PyzBhKIi7hsREdEfWRERIkIQSWAfFP2osLBP1lpiELaiz+fd+1y4XM695z3P
ec65c2O7IlvdLperhm/z3LNyxvMrLRrXadvp8QUKibVvDxXlahw719i7Ywvh
YMpfm+cWHCYYfvk/B+Z1/xpCXn9Ze/yvg8HmfHegkRCKDjaf/OPgTMm0TYUN
lOXNZ/zZ8JcTKnJYibH5HFwi5xnH68fCfbWEU3cnq14xDpyY9fJxkBDztC27
xfo3jL9qQvDmxYlrPL/afK8kjP482rViikYly5f5CSOXV99WUzUiA97udAWB
XScPTxf/jM1+Zz0aHR+f+EbniX6Jtv4XE1g101oqeXgJ9+bwZOa/Cfed3zmT
kGl9f/VCjrb75xMe8Lxvvx2s49gSBYR3/Lg/6WD8SEMoWmj1675KPsWCv8j+
PsIBFupJObhzqbTmNe/XxH5/JR10p1sGvCHxm5T9IecZP3rI1waCiSHDOLvf
Zpvnh5TwOwjPNsY8L9IOcg2hizDM+3yakPz2W/2i79JPD2FoLzfnl7wKlNUL
attnubL9LtLSl7L8Om3nLVW275CGqbl3lcIPkxfjrN8mZfNlbMYm1sv/xvip
j5uMKBjZ2axneh1qs/PjPG/M5B9VtteF4qdTWd/sz9DqtyvsNv9zlfS3T6HT
9BvQNu/jCv8Bb5pETA==
      "], CompressedData["
1:eJxFVHtMzlEYbrFcRjLfZHInmq2lTSNmvZvbzHIpLK19rL7yRTjnFLOINfcl
NLkdMyvLNS3W3KZsGSG3abQoRKaWMmQuabzndx7zx7dvz857ed7nfd7fyMS1
Mcm+Pj4+cfwz/4F1j77X7NC0xD/00vFsRTcyDgzqvkTT9taFV4d1Shrjl33w
ltAUc3XY9tYgRRz16fRWTcVD4j1TQxUlBsRFlu1FfJiit5mukqqjmkqVN69t
giKOvjO3UBMX9Q8NURTM9aaf0XTzxOCwBpftt+28pvZNURHu3oi/oGlf5beQ
hC5Jclrv2pOMl79/Muplm7T8SjQx+rn5lXTiq4s1Tc9J+9D5GO/nUK9SUk8m
2nQK/S5J4qyVNwrAv0BSyezGzHyNfrk2f9tqTd9j3xUdC5BUE80TejV1nf38
NNpX0kDWKzZZk1HJ/6eg+wUzL6d7UL9D2PpJqP9ZOP09jJ252v5jR68W4ei6
inHhzMtfu5r+588w8zQK24/rjwvnzDfC4etKxr4ahOWXoolVEtPqhaPXaC/0
eikcvW/xPJFld9dXMN7Pc9ZnaIpwX5/T5w34Z4F/s7D6bdG0zOTXCtppCEjM
e08Qdy+ZvQJ8KwVVc/5XN/jcFo4/xi3VNN4kVgnrn0Wappj+D8FnIfSuhR7z
oddrzDdPU5vZH/Nx/BkNfl8E/TB7if7nD+HsfSPHc/L83B7SzrMA7/2l1TEG
/YdKq3cc3sPg7+XoN0tSkvFzDuYpt/5w5Wni6ofXPJBWv3zwrcP7YeynSTr8
go7gvUU6Ou9h/MLstd360XME/uqQNJyNMJmxM9cvSRtaxobv4nqLTf8/8Nsh
4G7KzpsPfr2U5ZsH3FfZfeQivp9y9lXF981Xl5M2QNl7yMK8AbjHdGA/RcLc
mxf39Rv8EnC/H3Ff86DfM9zLLOB7kswaAqM0mfPfdE3afU+CH4twj8Hguw7z
BeIe8O6JBx+35etJxP4zlN1nCuK32u/PRC/wbmV5pELvvcr6h3G64XNQ2XtP
Bd/jyvb/h4uQ78U+i/F9SwHfi4pujyhVzcl4L1PWTx58f65Az0TUK1f2Ht3g
V4V+7LcKM89zRX8BxnWVpw==
      "], CompressedData["
1:eJxFVGtIVFEQXrWH+KNCQix8Vaj9sIeBWWg4YbWEmGRkFmUhSSLmOXuJsrAw
ojQsLKLXuYqU5FKsJT1sFTGTzeyBlIaZq5iE9lhMdNPV1OqcnVm6sNydnTPf
zPfNd3ZJJkvN8jYYDNvkR707kjMXdIXq4Nrx5Y7eY4KQs47t1loB6hVSx6Eo
4FPbsVcCJlS+noP7fK+AyGhfS1ADxQ4B9slTOQ1NdN4pEK8VY9eYAEvQnoNx
bzjEZNRvveAS4Pexkm9o4xAqG62bEJA2b8XD8vcc+8s41Sq/dVC9jLsVfuf/
2N2/m4NBPZMCTl9NLMnt5RDXl3LxugevH/GtLppnkOYdF7D+cevRRgeHTSW5
X6d+CajRsi8PjXKQVcORo4Q/zaH/xML7L3+SHnNNWO/J+5tw/mAdhgoSYjKK
ic8iHZ5VLF7VW8Dhe0S0b9RCHRR8QQmHpNjzGw/M17H+Gs3jR/qXcSgfNrck
zdGxXyWH0uax5Xu9dORfxeG4ApwWsFPxM3MYaU/OvDRCfO+Svj8EBM6Sv9wj
vQYF4sh8lORn7iI+ZuRn7CQ9Sjn2aReQqHRh1K9NwP6Bd0vtRu7ec3wL7XM2
hxdhNdq35wJqnTMf8usYnpdxj8IpY6hnk4CchiNXAgsZziFjcVM+hzFvlucV
7dgshno3C9zLPubeb6FNwEkpb/1uhnq1kB/SGer9VqBv0hjWyfnde8+g/nby
J2fIv4fmNzKwyfmzJb945ZuVDNSaEmyUX0b4jTRfOMN9WgUoOSYjGPrtEc0b
zdD/NeTvLQxu5PmfaaoWcE7tYReDfAlQbCH/5BFfC/Epxtgozze9vrW59imD
Kt0WtvoJ4YdzrLfRfbxN+lfTfiooLiK/ryX/5lP+EO3TSX6pQz+nz9A8nSa8
T3/JX3bKG3TU7zPF0o/u+gET8vfW8b46TIjvQ/51mlBvb4qnTCBV7UvxxD4a
9vMifD8N9/jHc7803Iec74G6QAEa4v0mPwdryHec4nAN/ST/D9z3b40G/wDO
el93
      "]}]}, 
   {Thickness[0.0026865132860605], CapForm["Butt"], JoinForm[{"Miter", 4.}], 
    JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{1534.078, 1215.2762050000003`}, {
     1939.8629999999998`, 1215.2762050000003`}, {1975.32, 
     1215.2762050000003`}, {2003.8629999999998`, 1186.7332050000005`}, {
     2003.8629999999998`, 1151.2762050000003`}, {2003.8629999999998`, 
     1055.2762050000003`}, {2003.8629999999998`, 1019.8232050000004`}, {
     1975.32, 991.2762050000003}, {1939.8629999999998`, 991.2762050000003}, {
     1534.078, 991.2762050000003}, {1498.6209999999999`, 991.2762050000003}, {
     1470.078, 1019.8232050000004`}, {1470.078, 1055.2762050000003`}, {
     1470.078, 1151.2762050000003`}, {1470.078, 1186.7332050000005`}, {
     1498.6209999999999`, 1215.2762050000003`}, {1534.078, 
     1215.2762050000003`}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxlVFtIVFEUvdgTDZMyLe88Ne0x2WQ/JlHuNJt8TJFDNERhTGVOmZMa4zhO
0EssJKhTph2JIUj7CETCHlRYUJQQFD2goo+SPiIipIKsPqx97t2XM80MXOYu
zjn7rL3W2tfuC1TvTlIUxYOP+N+6a+X7Z38vwOUDq5K3HGUg8MblPAF7i4ZG
fh5igOhUplPil25f2pslHKpvWdr3If72wu077aDzEQa5U490lS7mUHfma6S4
jcH1keBwdBEHR0fG26etElfMSHJMC0k88Sr0OS/IQBE/B51vZtDTMOvY/Xyq
H2Aw4BoNn1vKdV4NDKoKT675gPyGsI61nuoV6HyDfgb9vQ9ty4o4jIbTB1zb
qX6JXNf2uziMXXlUWdjIIDX/2sVABdUPxuGQxH7kd69V7/dBOfFvo/X1dF+E
9MP6XaWd9XtQryeXym78WCv1jOUTi//zozYRG/uFrC0+4oMYrx9bUKP3cxPv
r0R9dmzTz78OM0CWBSe8HG6XowEhqufhYMKXmiYGfajXYJXUR+OzmsN55P9p
M4Nu4YeX1p1M7xPve5797vdELvW3U/d7g43211L/FvLPzyFdvJgYWNu/bFqx
n/Kk6n4NNpIfMVjrN4PBd8xbWnEiNvYLvbtLJEZ5xj1lHObgfX8Qa7lCP0T7
HWbih36Nez729Vr0fg+jnyLGKTaJNf3sEt/BAldzSB8jPwvj8uWU86T1v474
2uW6lh+V/MXzWo7ncfiFfNT5EgudH2dLrPlB/JQsDi3D0SynleZF1fPYbya+
Zsqnic7b6D6V8p8j9TKwoa/YH1USsbEf3Wmqm6TPR7dK8zhF16/TRPym0/xY
KB/JlDcb4ZmUxzzanyn10fgb8++O638v+Tub8tZM36dU4hOi/KTQPGD+7x48
O/c48jELYyL0/Zos58n4Phr4H9sSN5I=
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQ7WPe6fhg6SyHqc7dOemJkxxgfOv7/r3ixmh8zUkO
pxe6bvu8bJaDbFSK9X2lSQ5bTpTtk185yyHCEshSmOSwzv1hlciaWQ4XlW7/
/CcD4U/ZMMsBKLrOXRqifv42BH/p7CMKG/Zg8kHmfRODqq/A5MPUf7zkmzSh
DsEHOcu/FdU++S6o+2QnOTCAQO8shyUFtlzXFaHu65vlkCfUfMBLZZKDN9C/
Cf2zHNgapzpzayH4sPCA8R8BzT8+E42/GGo/0DxRoMG/Vk5yWAb0j0EPNHzX
THIoBFqr3DnLQbtd7Oa59ZPA5k5vmeXgycOk3b4R4R8YH+ZfdP40oHnPt0Lj
ZxOCDw7/gwg+OBzOzHII2iHXmr0F4v+GK9DwAJqXJABk3YH4t3vdJIetIPMf
z3L4Efx46Wyg+zMmvq2xfznL4e+VipfLFkHtezfLoXzffKn1syH+2/BxlgOf
7qa5+ZMRfLD9najy72smOXCskYlKeQsNjyJIeJ1/Ao2vrEkOqiCHAN3zD2if
WhI0/C5Awz8OGj4HEHy51teBO/Yg+OD43DHLIeHpBaXoOGj8b4G6B8gHOWP5
eqh74yc5HFXYUPRiFdT+BER6h+UHAPd0fXo=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7WPe6fhg6SwH6/v+veIZkxwYQGDVLIc8oeYDXumT
HHQ3zX2/fO0sh7J986XWp01yAKvfMMvhYZXIOncgf507kLVllsM05+6c56mT
HKJSrO+f3zbL4cPyY97bgfxPl3yTBHYi+MtmH1EwOIjGPzHLIeHpBaXbGVD1
52Y5/LtS8VItf5JDu9jNc98vz3LgAzokv3QSmH5/DeLe6bVo/HYEP8Jyy4my
vkkOe0omS7RcneWwpMCW6/qUSQ5LgfZtuDTL4T3I/lmTHDjWyEQ9OT/LAah6
3/wFkxyOKmwoenF6lgNb41Rn7qWTHKaDAuIYxLxvyyc5bAWpA7o/aIdc6+tV
kxxUgQoP757lMBXo//Q1UP9sRfDlW18HWmxE8EH2yK+B+G/Zamh4LoX6F2ge
AEDYyy0=
      "], CompressedData["
1:eJxlk19I01EUx8cgNbdVRCg0dfNPa7RkmsUMLc4yMrf+oD00IiL8Q6E2/y5W
kSA1LCKKCyrsIr1UvkRFFI2IiP6/9gf644NaDyY+WEF/pLLOvffIQXwY43Pv
+Z3zPd9zbn59W12T1WKxbMGf+i++NTS9Ol9CZOPtF0cTAub4cvumzL1HBPza
8+mKc42EulReouWkgH2NFaO7yzh+/PiK688rmb+92lm/LMj8E7+XWyXMvolP
ek4LeOK+2Xm4WkKN3err6xUwMtPTXBmSsEQV7jH1h8Om3tQJZp0vPv++JSYA
Tx9cChm9bzsFoLrzg9slTA8/C99tJ94mTVxUwKSnNGMt6tHn2N9rlBsJMuu4
zcxfsZ+LFaQnSv6U032HgA+o//56CdHlpx6GugW4ElO15etMv1djVL+EWdf3
M+t+iiXkKmPx+2M6gPzvEoCulZ7xGv0u7Ocp+ve5iPpt5nlpfxqYQ+hvegmz
maOAHYGzwTHkO6rPVdR/IfVTICCM9weLKJ+b9HokYPTKG3kC0IXaFOpRc6/O
FTCkjPZJGKg61zrhJP1+43/ASXrLFrLK/yOL+E9yAc/FX3j03bvfyt/ruadJ
eIzHS3OMv9mLJXxUe4h6Nhy4V2O3Uf8uirdLeFkwMjPrpvk4JHxR+1FI80FO
6+2vsqEfOo+D/PUy6zp+Zr1fkfkcaKJ5If9V820lPxykp43uUU8/+nWog+rb
aL5dpC+T8nWb+bzLoH2gfXelk9+0X9mLmFW5a1Zm/a7+JcHXl/V+V4z91e+R
9jX1O2nyx6l+Dr/f//Zo4k0=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvWz2EQWD3NkO1vf9e6fvneTQLnbzXHkBgq/K1jjV
uXi2A5/uprn5eyY5fLzkmzShdLbDvysVL9V2TXK47JskcKN8tkPC0wtKt7dP
cmAAgcrZDoe/asTwb0XwH1WJrDu+EcEXWef+sGodQv9uTx6m1asR5i8psOUK
X4mw/6LS7Z//liHcB5K/vnSSA8z9MD7HGpmoJ5kIPsgakXSE/ul5Qs0HUhDm
H1HYUJSRhLA/Y+LbGvtEhPtgfJj7YXyY/0D2pSQh/L8U6J4NKYjwAbn3exoi
/KJSrO+fz0SEL3r4AwDa8Lx7
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQzae7ae77stkOEZZbTpS1TnKA8d8vP+Ztro/gX1C6
/bNOY5LDEYUNRRnlsx28eJi02VUmOXibdzomVMx2eFQlsu644iQHsZvnvgdX
znY49FUjpl9+koMKW+PUw1WzHYJ2yLW+lp3ksHQ20ISa2Q5LCmy5rstMcrC+
7987vW62Q+bEtzX7pSF88Sao/UD+MqB6g3ZMPsi938QmOXy65JskEIzJh6lX
BdrvHIHKPxw92+EDkL8dyP8IVD8hFiK/HegejjUyUSnxUHmge8WB/rmcMNsB
KGodD/SPD9C/DxKh8kD/HgWGx4uk2RB3q0DCKz8Zwp+ugeAjhydcPgJNPmWS
wzr3h1UiydDwyIaGbxJUPh/qHpj9hZMc2kEBDnQf2JziSQ5AZ94/D3T/VOfu
nPSSSQ6gYF4cB+WXTnKofKlmyAH07zQg/zmQzwAC0Qg+2PwIBB8c3mGzHbSB
FvmVIsL335WKl2olUPcHQuIzvGKSw4w8oeYDhYj0BADY/hix
      "], CompressedData["
1:eJxllG1Ik1EUx4dFSUVIDAu2uabpCokKAgmJTkhEmQXrg7GIYq00NN+apVKh
iEREYdfWiqOuoJcPyYjypVJSKC0qFHuzYb4SlUitshwSjO69z3m41T48PPye
59x7zvmf/702V6HjQIzBYHDwR7wvFSyq7rqLELrZk9lWwCA+2Bve2YVgcbrT
R04wEK8dLxB2rWt+erSGwQ18vPT2gOLvL7NctUOKefRZ3zhCf+LgTKRaW9/3
EeX3xVUMOjx1S2ZPIjzYsiAm9SSDzLTTG/d9RbhWtH5edjmDbZxHv2nxvhIG
fNeH/h8IjnsJNZOHGfCSDZVTCLfMTnf7QcVb+XZz9ygW/aStUizW5y1nUD6R
sib2J0LqKd5pkra/9ReCN+NMfo5NizdMIyxceaeh0Er1hSm/hUHu+S/HN8xo
9Q6YGfCwkP03wiH+vdPEwBXHlYhQfhP1M6s+ioVe0/GkTy9GsR4v6+n/j9/+
y5VBWq/zIM3DQjxE80hgENtkdn4YRq0PG81zhPZbxkDIEubM5U3fm0z6jCLM
qfJmzF+hWNdX58jrsomU3YqFfiE3g1dZrrh3w7Q+n/z0nuorYpDMfzwKkt88
VO8b8ssx4j7FQt+1PYqfX93UOtVB/RUz0P0s55OjWK9XZ6mXnebXjGAMbB6r
SCJ9WxDGK4yBJzbqp5X+cz+0CD+2kX90fe8jjIl47geuZkluO0KT8KeJ+u1U
8xJ6r+6OZn3+Ml9tNOvx0pdMsZynT7Eo8wLS+TFTfQ10vqxUnx+1fRPJ31fo
fNgV63rpLPXOVizr26/lM3Iu5LI+y6N8fsrP75Nunu9zI+1fTOe/keo5Qn6v
J/bQ/YHkv1Ly42WEi/x8firV+g/5FEv/eBXLedZp89leqvST/vRQ/ecoXxmD
68L/AXV//e0PwX8ANFVSXQ==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQvfVE2b752nMcrO/7905fOskBxl9SYMsV3jTJYens
IwobXDD5IPXiVQj16HxPHibtdhME/9BXjZh+3UkQe3TmOCQ8vaB0W2OSw8dL
vkkT9OY4THXuzklXg/IN5jiIrnN/+Et5ksMWoH554zkOD6tE1h1XmuSQMfFt
jb0Zgi9+89z3yxYIvhiQH2wNtQ+of0aeUPMB2zkO/65UvFRTneSQJBBhaeIA
VQ+0D2hNlYgTVF5zkoO3eadjgjNE3l1nkgMDCHgg+GD7Xec4/AWqX6YCVe84
x2Ea0P3P5aB8mzkOXkD/s0tD+eZQ88Wh9hvNcXi//Ji3uegkBx+g/AMdBB9s
jyaCr8rWOPWwKpQvNskhKgUYgkpQvsQkB441MlFP5KB8qUkOl32BNsjMcTgM
9D+/LDS+pKD+VZjk8AkYvgKScxxEQB5XgfpHYo5D+b75UvpaCD7YP4YIPix+
wfazY/IjLLec+FYLjV/uOQ67gQlgdf0kh3ZQhPBD4wOYfvh0N83NF4GGXxuE
/14C6r6uSQ6nF7pu+ywDCa9l/ZDwb1CAhv9UaPgoQfkzIPzjKnMcPgD9v30u
NL40EOkZAN3hSWo=
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1,
       3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQ/SP48dLZ96c7gGhp34kOt3/WZdncmu6wy5OHSTtr
ooNpHJB1Y7rDGpmoFOuyiQ5BO+RaX1+f7nDz3Pfgx+UTHSYc+qpxB8gHUjH9
lQg+WH01gg9Sn1w/0UGFrXHqYaB5fLqb5uY3TXT4DrIfaF/C0wtK0S0THZy7
c55X35nuoN0udtOvbSJY3ft70x3yhJoPeLVPdHAByv9+iOCDzX+C4IPd/xyh
H+yvlwjz95RMlmB5jbAfbN5riPztegQf7K4aBF90nfvDX0D/i4E8AuTLAr13
vwAaPq+g9mdBwif7CSI8AZUctjs=
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQ/VLNkENn93SHH8GPl0r7TnR4BeSv2Trd4TuQPztr
okOSQISlyZbpDmX75kutL5ro4Nyd87x683SHciBfvwLBB+uvRvATnl5Qiq6f
6NB/6KtGDFA/n+6muflNEyHqtkHlWyY6TADK39k+3UG7XeymX9tEh9s/67Js
dk13yBNqPuDVDuXvRfALbbmuKx9A8D9e8k2acAihH2z/EYT5YHuPTXe4ee57
cDLQ/qAdcq3Zx6c7qLI1Tj1cj+CLrHN/WFWD4IPUP66c6GAat8uzB6r/cfFE
h7nvlx87fQSqPguqfj8i/ACz7KdS
      "], CompressedData["
1:eJxllGtIlEEUhtfdDCsLScvSbCuzQi0xUrJNOypdVKzUxFLzbpqipru4eMnN
vEEl7WDhQFRURIRhERJiItEdBYn8EVEgUoEhIRFhaUTzffPKhP5Yloc535z3
vOecWZ9XkVxoNBgMaeKn/ffbOlYtsHMqX970JL6NkcbNtZymUj7dvpIpWTv/
n5utnO6tSS+wFDFqW/l+eKqcUzH7Vr+ngpGbdnCSU1+cu7HLxmgkMc/jaC6n
5N61LaX1uC8N+c4gPl6xuWUiaWeE4srIxe/8gzl5de8fq60B+3PK+fJmw4dS
ybd8OQkVKfk58r7P3py6xLWPkxXr8TGKl219eHUyjNHFpz+3ZPpIvUGBjLRy
UsycFjZejj1vBm+U+ie8GDlF/MdATj2vqwfMSxkN3dj76Md2fO/GqObrplA3
C/ww4ftYWc+ggZG34JEExWO1Xt2vDivWyryUCr9cGAn3Inakw08j8mdxmdcE
/fmcxmfufn/ryihfxPcUwT+3ORyi2FHSb/MMZ6TJDRbc3ikidsHfE+j3bnAh
p+qB6z73oxiFZfXFXRD5AjSDCP3Llf5mRKN/2eiX8Pv5ugdVxRnSzyWx8Ct1
Puv172Py3nPzeTZe42dtii2jh9o7zyrW9Lk7OAWJwTwYDf2n0f9IRtcm77wc
qsO8WHBeh36HK571a5ZXiHqmXeW82624T/TnhahvvBT+/3XSoKjHWoB5+eOU
83Bc+muaccp+H4HeaafsR4LiX5rvoYp1vX7Qa4QfHlyP8/WU9Xsv5BQjBN00
Y79cMJ/bFOv1RSnW5yse82SSfg2nYv4WYX9yML8in13rfxmT+lYjn53JegMw
Lw2YxxDobUY/LHPelwOKdR2JivX9TOLkJ56X0Vbw7Ly0yviJY9ivFuy/mDfR
jd8NTagP8z4o3g8RndRbwkl7rrId2Kcy7FMD9JcrFreU9Fco1vf1FPI5sD+V
8E/cr9ddxUl8ZetoZKQ9K5ut0N8E/6yqvn/IpGUz
      "], CompressedData["
1:eJxlk19sy1EUx7uK2SixZUz8jT9DMiJiEtLgZMxP11WzlmATZOaFRCPEvweJ
sJAg7WWLk023IF506Rib6qpkiz8pZvRB/EkWGQ+yBw8i/iQS59576po1afr7
9Jzfud/vOefOrAn4dtltNlspfeVvTuvUqo9RhOzjDavHVAv4l8+sFZA4cGHS
yU6EJfKzQUDaUzN+c3Jofu0jw0u3xV2OlOGo9eFowXMEX2x63eAWAanLZZ37
XyB0uRz2yCYBoe5v89+/RP3/Rs5PI7zp/e4f8BmeQA+/vEPjOz0CSM3ykles
z831+/R5e1wC3v48tjvRi9Dx5GCyxRLwee7inNZnCBGS3UX+iqTQlOFTE6ny
Y8NB0rf1IcK0qlpnv8X1uxHIpb24XOupv8/6Kzh+D+GHf+Bak4f1Jgwrv3HD
sl9n7yKMW9ge/kLv71sx+vXsGMfdWu+CDu7HOgHOfu+5wnb2t8bMS+lZaVjF
8w2THef2sTzPNgRpK5grYA7577nB/c3W51+9iXAo2TJ50UgBUta8W5rbRgiQ
7fGTngJpzC7gMAk8fQd1H7P0PG7HtZ6ITUAh5aeTw1n6m/I7pP2GhnMmX+mr
N6zmjTz/LO53I8KOT32z3pEeVecS95P0UvejVhihlBKukJ+nlP81zH5HcbyZ
z8/lesTFtAjrHYbVPPIMq/dL/ouvEjCjbrByWTPve5ner54ws8X3h1jpcPH8
WW/AzfepSfupruD9bGQ9Hu4f+Q/kn3iQyuzXRcNH5MI0GKZTK2PnEfYSl3vE
3/4qzuxbkPvn5fldN/f3D5nJ5e8=
      "], CompressedData["
1:eJxVlH1Ik1EUxtf8mnNpTdPSNXVpSVYWFmFTO+Iq5keik9CKEjMICyWQggor
LCIs3MWi+yImFRWhVJREpFhURCRY2R+hM2aZqImJjDCdSve99+ilwdh+3Pe9
5znP+YgtrSw4rNVoNMXsq/42jt9/l21QoMW0t8yqJ1Dw3HxxVKvA1RsVRh8f
AlsOvLAbZimUDH6yuOacMLJ6k65lmvLn22ad8HDX91NhkxTOlrdXhc44Id7/
/PVMjzi3ep3gmqouTx2XrGN/fg5LvtfwNubxAAUVD7L7/joG7ja4KbTZDdrm
RQTaq+qXX3BR+GxxTc35EcisPTZ0uofCyY6myEdBkptVPcb/z5MikHspqLKC
opD7KFQYa15lmYnQ5xb8wUKg89aOZx6mh+e/hoh8f1FYxhKdXiv8OTqBvIFA
6/sTHU0zFIa9Dya6kwnM+6nGq02RzFzUJqZJPkLGzmzfScD5+k9Cn16BMNXI
HAI2ps8boAi/8wj3I8pPEb46iPBPo4j4hQTq2Pv7vXSBVT83TkrO2Xo5o9+D
9XNI/dznfDz/TSHxUnjPbozXMEYhmX2e5kiuVP2xE7jJ9HeOoZ82ydw3EPXy
ZVzN+qE+Hf0epaKvUgkEr3/SOD6C/lsxnyEq8t+G+QxK5uc/JHO9/RSGmN8F
VvTTjXqYv1S9+BvWMx39ZPXOUA3IkMx9tUlW8++yYzx23xsmIyRP9Ef7oPSP
+zEq7rtdRIC1rfujB+PvQ/1zktV8K/2VBebzslgR/VuM+o1Yzz0ESpcUpWwO
V6Cna9IxUIjPr1DEPOTjfEYqwr9c0X/RJkXUNYtAr6qXsSqjziaZz6tVMvfH
JJnPbxjmbxL9+TIY52MlPm8gMNGdW+pkzPtdj/1pFvuiJhD72Yz9qyNwPE3/
9U60yDdJJ/bJlRg8D0COlazme80ima0ozblVqE+HfsXhfDE+xPxqjcf8A4X+
sgR8PwjrsQ45RPL8vuP9GIfzpSEQwYz/gvlmsf3E91+EZN7voZJ5vZZifLb/
uL4QMe/NbF9ms34tYfXm88Hu58zmn/ebr9wH83r+AXLonjA=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQPff98mPePDMdVstEpewWmOgA44usc39YZQzlM810
6J2eJ9SsP9EhKsX6/vnfMxyMgWCzzkSHCYe+atz5McOBrXGqM7f2RIcfwY+X
zv48w2HLibJ98hpQ+fczHA5/1YjhV4XKv53hkPD0gtJtxYkO/UD5mNczHMr2
zZdaLzfR4fbPuiybVxDzjaUR/KAdcq3Z4gg+yPz5QhMdCm25ri8G6ncEGriI
b6KDc3fO8+p3MyDu54aa/xFiXzTHRIcCkPovMxyAvjlwig0q/wPB59PdNDf/
L4IPMkaEZSbY3dJciPCBhRcAbICcmQ==
      "], CompressedData["
1:eJxlk0tIVGEUxy8TWFCL3i2KyYRy0SQlmdPcCU4MMjbNNM4MaY69mIzKXqCB
NYEZIRomfN9C5EMKWpiEItIiJF206AEKYoXplNBMUdNjIdXC0l7nft8ZP2gW
l8uP87j/8z/nboidDx+3GYYB+FjvF4HY0kmHgHPLrz30BTk8zu2v/Vgq4MGe
JbaeKAd705fQgD+bZX4Jh/CAvel0SEB67u7XcIDDlns3p/PLBYzcLrn/PUz9
oqp+c7mKdx8Rqq6Sg8PiagE5V9s9i6so/5Tmb89RYJ3mrs5Huf1xAcPYv66C
Qyq+su9pI+kpU+xtETCW9/png5fDpU+bti26IeBKzdCFFW7Nsl+BZllv53AR
uaVZwEYrYRlxg4BVfd7UbA7pqRfQ1oEVfxjcsfScpfpZBki1J2OaPa1n0pcP
aUZVNe5KVb9gjik/9pMfv5jSEyH+zaDoMDpXJiAxOhM59pfN+3/0/VhelU3v
Yybyrqvzw3/xJAPzTbBtTUBAOwo5McVA7hu5Z120evCVinfsE+DD9SxMMOV/
UMCgte8JBm8tf0O0/5c0b4Ti40p/fgXtN8MHsxm3koo/U98/4MjmTL7UV6C5
eXVitL5QqDnGSW+RULqQ1+O8TqeAXpzHnKD8nbQvZOmji/olyA9T7WMY5781
3f1kxCS/p0ivW91Ha1KzrE9rlvp38XmWfns4+Iuv706adG94f3I+k/wrVTzp
onvwces3NAwX3eteijsp7ufwGc+ht5j64f8l9e+g72d4u2arXWOhZnl/W+ne
AnTv6O8PvJe12P8fCpvExA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQLdf6OnCHz0yHoB1yrdn2Ex1g/ISnF5SiZRF80XXu
D3+JTnRgAAHfmQ6OIAWCEx2s7/v3TveFqL/NB5Fv8IOq55ro8LBKZN3xgJkO
dVl7SiazT3Q4orChKCNkpsMuTx6m1SwTHSpfqhlyRMx0yJz4tmY/I9S8mJkO
eULNB7wYIHzxJAR/OoiRgeDrbpr7Xj1vpoNsVIr1fSaIfe5FMx3YGqc6c3NA
5JeXz3R48Xvlx0tA9132TRKIqJrpIANUHy+B4IPdo4Lgg91rBDUPqF+7Xeym
ny3UvkKof10mOhwF+udFzkyHXqDDmL0mOkw49FXjTvpMh+/Bj5fO9oH6LwnB
BznzfByCD3ZfNMT8c94THSqA6juA4bEG5EAvqH1hUPM9JzrIA+PDIggaX66I
+IHFHwAU3coW
      "], CompressedData["
1:eJxllGlIVFEUxyedbEopC1soUbMVLEr6ECHSsRBzaSyHyrRAxEAKlGwxTVsI
aUPy0mI3s8lR84MiUqNpmmhaidKUTaWTQZoWmoqVhBYUnfveeV1kBoaZ33vn
neV//u8uTUyNOeCi0+n241f8WtuON5qtHMq945LqLzHQ2O3s9a3u2xjoxKeB
K9d9dzBY6LBN2Js5BJxf4DDuUuN9n3GYNPWXFuxh0F4UWnOknQOGmfr3MliO
iVpslC+ewY/X2xM97ZJXiD/dkn1yhnfWfqB8+PzstfcLU3upv90MDgfP6lo2
QPlNDAwV3nEDXzjE1PrkHIpmUFrQ6lc1yCFl3rmmiHAG2KZtYojyh9J8X7la
N1jy/Mqwvt+BkitEvbmSRR9j7gwwLNNrmOJnkD4jHBI+v/Lvmc5gDYaVjVB+
PYNPmV6Vz0c5dPr3/PrrwiBy48WQhDHqB7kD9Rr/RvpOYxCF93vHOTwK93Ap
15G+k84s9FnyJw/ikoI+Rnc4sxav6PdC8j2hT+fUfOY3tE+sn8xGsza/4zAh
9Mf+nvpVpQ120fyuNL9DzntTCE0cb6B5HGp86kza93sOT36u3nfFQ7Kmr8aa
/hor9YIYnBhaGXgB83mJwltUvc90kz9CibvIH+hXOz7e/ZZDC9abE8ngO+bL
s9M8UUzVB+dPbzQvXmdkgJSbb6P6RtKrQ7LQa32b5D6xz1bS20h6NdP8UaTH
Yw4heMESQf3XqXoHhMn3S/h1OETyFL9ZaV530hP51MGGo1fRb9XifjX5x42B
sLepRuXLerr/kPznSvrUqfmDcJ+4/bTkepof953oGbvJ2ij9oPizxZk1fyn+
u+HMWrxY26pbksU+YgulvxT/maW/cKpF+iLZr+IvC4fcfBRST++DhfR1U/OX
FdM8BvJLiRrv6iF5ir9K6DxIkrwBPw9SVD+8LKZ5jpE/ikn/dLpvofMmg0EG
7tNgIb1P0vtfROdPFvFdqpdN+7xD/WTTPLclK/spkKz4idN+6Pn/emN+IUvT
NfL/aapXJc/vf54HsiI=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQzbFGJipFfJbDaiC1u2uiw0s1Qw4dKQTfNG6XZ4/M
LIfMiW9r9ndOdNhTMlmiRW6WQ75Q84FT7RMd2sVunitXmOXw4vfKj5daJzqc
Wui6rVhxFoRuRvB3efIwrW5A8GWjUqzv1yL0i6xzf1hVjTAfzK9E2N87PU+o
uRzhPrbGqc7dZRMdYO6H8a3v+/dOF0HwkwQiLE2EEPrBfAGE+bd/1mXZ8CHs
VwVp5EW4D8aHuR/Gh/kPph/mf5j5sPDR3TT3vboQIvzA/hFBhC96+AMAq0mr
6A==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQnSwQYblFfpYDW+NUZ+7oiQ4w/hqZqJTdggh+7/Q8
IWaeiQ7W9/17xRVmORiDAMdEBw6gwidAfp5Q8wEvtokO8q2vA3coznII2iHX
ms0y0eH0Qtdtn5VmOVxUuv3zH9NEh3XuD6umqEDtA/Jv/6zLslGb5bDlRNk+
eUaIfgvNWQ67PHmYVjNMdNhTMlmiRReT/yP48VLpvxMckoDuM2HE5MPU626a
+345K4JfYMt1fTEHVD3QvkIgX5lrloMo0GG/gPxXaoYca7hnOSQ8vaB0mwnq
P55ZDqogBwP9A6IP80LCxxro35cg9XxQPgfUPP5ZDoe/asTw8yD4sPCE8UHh
89oEwQeF3ym7iQ6XfZMEbgDNK983X0rfFWKfMx/UvR4THea9X37sNMx+L0h4
igD5JsDo2OwN5fNAwrfbB8oH+gekPN4XGp+csxzyQfb5QuOHHcEH28OG4E84
9FXjDjM0foF8WPiC+UDzxW+e+375/0xIePlPdBAD8oOlEekJABOl9L4=
      
      "], CompressedData["
1:eJxVkm1IU2EUx4dCWYkNZ0pZToVKkqDoQ4rdOqtmadNxt16sRazRaCa6ypJl
po6bvRDSDhHGIyEFBVFUhEVElKRBGJjol8QPFhYZElIRllF07n0OPHRhXH47
556X//nnhaK+cJLNZtPoZ77Np/WMgGi60dPvRDjxednqlNMCqvFL03MHgrNt
Ui9qEZBxd8v7xrkI34YqQvaYgAXEM8kIKXcW7/lwWEB7R1268ScBr6+5H32P
CCDqKZ9JQITqbAgq9qw973q3Q3HWyMD0sEeAK/hx8PrfBHS/anjmdAsgzA/M
RuinevWagN4fBXvn2xEeUryrWEDh2cyRgWzF0/7xG50rFFvzFaHsp3H9zQjb
iIOlAn6a+RUIL3PvH52oFPCC6l/cibDywdWp5bsFzIpf3jQvgHKesGJThow6
xdZ8xwU8KUtNul2Fct+TAnyPc9om/axnXMYLvQhpZgNDAMl2oKRcsTlPtlux
tc9GhJIxb3uWwfOBjEfjvN96BKoy9obuY/2vIcSo37lTPM86OX9Xo+KQvaq4
u0HxFfMQ9TyvxnxEcg3w93Tfid+3vg65WM+ogMH80V/NpKflnyjnb2X9iD9R
vs+D8r618l6VXs6v4fvqnF/N7Of9w8zbeb/9im929uWuCigeJju+JT9RG/+4
zvk66+NhvTzs31Ler0zAEjNRU2zdZ41iy58FCH3kjwh9TyosupfDcZ37Z7If
dkn/J6fJ/t59Mj46h/sf/J+nahUvJSP1kv4th54ec6RyPCb9dcEu79/RJKCZ
4pccrFerkL5cyH43eP48hH/lmbol
      "], CompressedData["
1:eJxVlH1IlEEQxi+1Oj8wMdNI0bIPI+kL/yi7tJEsUbRDT0IrKMRACpQikiTK
kIgI6ZY0ZS21TMkUDTOzFLOsFCtNjbzTSs1CI0Isog9Nmt0dWXrheO/H7jv7
zDMzuywlI+Ggg8FgSMafeIsnu51Dtd+eVJMLg/qO4y0BLRxyC9I9HR0ZpLGv
J7c1cjjw6VXg4IwVYjedjxi+q/Y3/bXCSJZXTVQdh9OHmo8tnLbCOW97V2YN
xZuygvvauqsZtzSbhsy5Pjc0G/HPx2IOAvdjPHwNdXMOTdFuDlVzGPif/RLf
eJlDT+Dg75m5DMqLniy9ncchs6VkSa2r5iqhx/P/9fU+DCoE53OYdyZ/u6sv
cQGHdM+c1hh/pvRxxZ2BDBAngkoo/yCm8i3nsKgmauTPGuVPSTXxOgY+9q6f
ffc4jE9VTvaGMJj1U5x3IVTzA8wnOEyz9HUng2+9cSkezzigiyNZsUrfhjby
28ykH+ZWDitFQAtT/jXT+YkMJvF7a4Nm4WdqnWYR1quW4lm0/l+W0fKieFrH
+gRj4XbRed03OYTgcydWc4bwJ1rpN1SSn5Gan1/b0fAdGARgvTbj/lPYD5fC
qR4VHBIasZJbGRwJc+lfXk7+myifMsp/C+VTqlmuF2uWeq9wGEO/E0zkJyc9
6K/UUUj1DCc/kSOEARGaRf6+kZpF/l3RdF4Rh7Yfq/ctMKv+mCjV/kk/KlS8
60kMMMvFTrV0/l7Sf1+zyLfskWY5Lx3Uv8mk/yXVazcDdOtoWg8HbCvLaCLt
f03zEE/z+Yb8i2PgLTb2K38Px5Be5Meo/2KkZjmvJs3SHz/Ncn69KH+b6s+H
7jQfNtrvxmAFJtJmo353of60q3nJcaZ+HiC/jAz6EG0DNI/IhSLQIK3PZyA+
a32r+QPm2/5Oc4pHUmj9e9JnJL+GaL6Qn6Jf48OUv7PSXzBK37tSPcaIF2ie
ve9kPw7TfBkYnPi8aqPRTv7i/STntFez7PduzbJeL+j8abWe3anmvQrvS9Gv
eR00HwbVv3nt1G9O+j6Y1fMPRmCKeg==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQINx2c5rJaJStktMNEBxhdZ5/6wyhjK3zvLoXd6
nlCz/kSHPSWTJVi2z3IwBoLNOhMdPl3yTRLYMsuBrXGqM7f2RIeoFOv759fN
cthyomyfvAZUfvUsh8NfNWL4VaHyK2Y5JDy9oHRbcaLDR6D8hGWzHMr2zZda
LzfRgU9309z8pRDzjaUR/KAdcq3Z4gg+yPz5QhMdLgONvwHU7wg0cBHfRIdl
s48obFgJdT831Pw1EPuiOaDq189yAPrmwCk2qPxmBL/Aluv64h0I/sMqoEn7
Zzn8CH68VJoLET6w8AIA51yL8g==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dKd8/w372yH1TJRKbu7JjrA+GtAfEEEv3d6nhAz
z0QHDpAEH0TemmOiw+2fdVk2/LMdEp5eUIpmm+jw6ZJvkoAARH0zy0QHsZvn
vgcLznb4Efx4qTTzRAfTuF2ePMJQPtNEh7nvlx87LTLbwRFkAONEhz0lkyVY
JGY7AFUxrWaY6HALaP4eGUw+WP/fCRD3vZ+FwYepXzb7iILBFwQfbP93qHpG
CL/nxywH0XXuD38B+UCqSuTXLLB/bgPdp8rWONX59ywIDfQPWN+fWRD/s0HD
B8YHhkfQDrnW7L+zHA5/1Yjh50HwYeEJ438HmjM7BcEHBdPjPKh7gXxjECiF
+hdoPsj67nKoe4B8kL7XlZDwavkNla+e6OAMdE/1L4h8dg2U/3OWAzA2DnjV
Qs3/AXUPkA92xzcEf8Khrxp3viD4BbZc1xd/muVQvm++lH7tRNTwroHEn/c7
CH92PdQ+TkR6AgDYtyBj
      "], CompressedData["
1:eJxtlF1Ik2EUx98mlZhISN1k9GEfBBUVFBEVHZHoS5HWjdQYspJMmy/Opmi6
T5Vlq/akMuqkIpWWji4iIjIsKiLmRR83QQsqIqIkhkSUhNHzcV4ecF2M8dvz
vOec///83y13mfZKm2EYe/lHfPemh54d8CHc35drW3uQgcWJxYePbV+oeYTz
aC4D1/zybZv9CBWfXxYemctgi5M/GUT4fejT9YLZDHhJIxBGKBIXbOr58Q5V
f8RgYL+3pH2iU/PX1Zuy13Vlsqw3HZOccGSydV/Wr9CcHNh9t/6o5pKtZ4o+
VCJ8+XNz0j6L5q2icz5fFfvesqsa4VVhaupvFoNVc4I9T2oQzPzwoyTX84v3
xZMI/OfiedkM8tbf7jXdVC+HQezxzzXv3ORPnmbLP4stf6UORyZLP8v1/f+y
U7Oc4zgD3uV9mYlw53nD2FKTQWrKV73Dg9LnGi+Dup05b1Z4EU5wnQ9Pq37Y
pOqlAsR+mr+NuB2V7giDC7yfI6r0n+2k/l0z+LJm4V/xAEIt929/hPQNkZ9h
5V96WJ0nA/R8gvS0ahb+jTbN4EaVLyNB83spn8OUj1MMbu352Nx9g/zyMHjL
/XgwiLBAHNQRX9M8iE+XbbyqefJ1qSvG5z8Xr83P8lD/fqpfT/f7EBrH+hdt
4P2k71dIfwODbyKfl2i/zfS+xEl/K+nvpnxY+i9S/6Da54sY7SOk8ho9T3rC
lN+o5nGe9x8RzXJfHTRPiPLQpvIwQfsuCNF+/ORXAGGlyH0LzW+939z/uLjo
U/tJe/X/gdTt1izrOzVb+e0T72dPJlv5/wc4lSJ/
      "], CompressedData["
1:eJxlk3tI01EUx38usqwVJBbR+0ERWIRU9Ic9Tj5ac/4SVhFplKj9U9GIoqAg
ipIIA3eo6HFZQ3M6WJRERrllpmk+okQEWS4iIiL6Q0KiF0Hn3nvWzRz8GF/O
ued+vuecu7DM593nsCwrhz75Hxhu6PQ8EpB65kru5BKEf3XVZgTvw3mVn1sF
rJK/7QhXD6Wfbe0and/bZ3RPTf6DIwNG51Yd/HhyUOg6uxD8bV+XJeICom6n
I7ITYYlMTAh9bgfnvxEQf/lt23uv0dPvuN79LBodL7cRKCskEszn4fqv9X0H
3AiH108aXEz3NXUdawm6EKjMiQziicwproiSv09LsybeHjDas/bCptJ+oyVf
+ysBc4srst+6uP4LAc3En1mAkEc8v7qZv5DjzwV8l1w283Yarfx2GN1L50ba
BUxdcS8wTOfX7Gl2X2zjuEfzXn7C/diCQCOzTsfYX56Zl+LZYLSKpxtNdrL3
TuF5kibM3dVp2v/yKPc3Vd/vpPrHW4KzVo5H+NJvl/kfa313HMLQj1P7Y8ST
IcEcqLmfCu0rBRX37A7NE7F0/rrusVrl/fZrvzfG6mS+4gsareZdy/NP4X7X
CSj90LdoiHhiRy/NPFfP/STeevFsQWODgBxKqCU/1dJ4mP1OQAjJeJjvT+N6
pDPPz4hvdRqt5jHNaHV+9X/xjQj35Z6Fed/zmT+paX+uyfdDPGrubp4/8/po
3jflewppPyWFvJ91zGNz/24J8FGZnuR+1Rit6gSNljzzAwLktQU2/u2v0sl9
u879K+L5NZn3+weUt/+I
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQvfVE2b75/HMc2BqnOnNHT3Q4tdB1W7Esgl/xUs2w
Q2OOQ75Q84FToRMdfMw7HR8YzHHIA/K9vCc6MICAxRyH579Xfgxymujw8ZJv
0gRrqH4LBD9oh1xrtg6CnzHxbY29ykQH6/v+vdMt5ziIrnN/+Et6osOy2UcU
NpjOcfgR/HjpbOGJDqpAgw4bznFYIxOVYs090cEbaH+CDsS81ywQ+xtU5zjs
8uRhWs0w0WELyD9yUPv+THA4DfTPZzGoe39NgKjnQ/AfVomsO86A4IP993U2
xN7/ExxmgCTeznZYDbR/N9dEh6MKG4pePJsNca8w1P7Hsx0Snl5QipZD5d/W
RPDL982X0jeC+v/pbAcRoP4qK6h/X0LNB4bfZd8kgRtA+3qn5wkxA8MX6Ov7
/p9nOziCDAyc6PAJqF/g12xw+EiHQtUD3X/4q0YMf+REh0pgfHFwIOIPPX4B
F1rXMA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ/fGSb9IEnjkObI1TnbtDJjrsKZkswcKJ4LeL3TxX
zjrH4YLS7Z91wRMd+HQ3zX3POMchaIdca3bgRAeONTJRKf9mOzz/vfJjkD9E
f8vv2Q67PXmYVntPdIhKsb7v/3M2RL3bRAcgr1f8+2yHXUB5bceJDgwg8A0q
b4Xgg+WNUOVfq0x0KLDlur74x2wHkXXuD6skoe75O9sh4SnQhfwTHeRbXwda
MM9xADnLmm2iw7LZRxQMuKDuZYS457wQgq8K8qgkgg8ydorcHIfDXzVi+Fkm
OkzPE2o+oDQHbH4050SHowobil6ozXEo2zdfaj0f1H2acxy0QQEljuCvBtq/
WwXBB7vTBBo+qnMcykH6gf4Hhz/QPlGgxb+8Jjpc9k0SuCEJtS8QyhdGxAd6
fAEAmqC1Nw==
      "], CompressedData["
1:eJxllG1IU1EYx7eZZkyixAoqsvxQgfQhIhQG9ZjK2nbny12QuSixWaY1wcBM
JbJcKibbCWTkzlgUUpFYRMGwsIje8EOvX4oFZhIWEuKHMJOi55773E61wWX8
uOec5/n/n/8966ob1BqLyWRS8dH+T3xZvzndx2FwdaXvrp3BQOTR2pt+DrOe
iYHILgZKXnfBh2YOae19hVYvA9tYaW/4tOSt+4Yd5zolV/psYy96ODRknnkw
uocBntZYG+TgR3buZlDUc2Ry/rzOo3j+G3f1krd9HJpGYitvlDHoXP7u+WyY
w7Ih+/gPp87HL3DoDfszU7C/7MBUeX4/BzW+JjAFkocdGZbr+ZKFnqWSF2+6
FZ22MtDkDvbTeemkJ0L1UhlEp688cXEOuVi4ZAHVj3J4lZOY+2XR16+IkV5k
7KI8fpHD7WdNI9lmBom5k3X3LlM/JgZa2Q1Xk/k7+rvqZwiE/63JbKx/jP59
bvtvf7tksa+D+sX6H1uyhp4GaH7YXyH63dpJ+lNIfxeHqk8vcxKpuv8V3Tp7
0Y87qCNm8CI6DzkL/WnJkGz4a7DoI08yTtFzYDvlqUufV30xg2ZsoOus3n+u
g0Hw4beNeztongr5eYryUULzaZWszTN+THII97+vp/4wL0aehb4CyUa/Bmtl
g5gHF+a7Cvkw+9p2fyHNt4bymsbApP0OcpicvzajYh7GUZ/9kK5vwkLzqaX8
mElfHflhpnwflfMS3JjMxvyFvuJkNtYLtv+7v0KRLPJaSvrNpKdc12/D/sOa
MJXykUb+eqieVbLh19/vI1skC/+2UX1abysmPSqtt9N7lb43nM/Ma3d1CPvZ
gQ1ecpFfZTQ/hfJK/XvdlO8Suk/cdJ8oksV+p2Tx/e6k+bnZH/8EK3QfFJE/
pfR+v7y/jHwY/BsIM095
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQHZVifd//1ByHhKcXlKLLJjqg8CMmOmw9UbZv/n0c
/EA09Uj8NTJAlhiCr90udtNPYKJDoS3XdeXTUD4PRP78Gah6rokOe0omS7Sc
m+NQvm++lD7HRIckgQjLLRfmOOzy5GHSZp/o4G3e6ZhwGcFf5/6waspVBD8Z
pP76HIcXv1d+vATkz8gTaj5wEyrPOdHhUZXIuuO35ziwNU517uaCmnd3jsOh
rxox/UD3AIOEoeEe1D38Ex34dDfNzX+E4AN90yv+YI7DaiB/NwfU/Xeg9jFP
dPh4yTdpwg2o+QxQ/1+Z45Ax8W2N/d8JDkcVNhS9OD/H4Ufw46Wzf0+A2H8a
wRe7ee578AkE/7IvMASOznE4tdB1W/GfCRD3HILIS/+bAAmv/ZDwPPcfqn4v
1D4miPvf757jELRDrjWbFeq+XXMc6rKAOoHu9wHa/2An1HxeBB/kfm4RBB8W
v2D7V2PyQeG7OgQaPuvnOGwBphP5sIkO4kD/XN4EtQ+YfkDi87dBzY+ZCLF3
FzS84qH27YXE//pkKP/AHAcRUERnQOML6P/e6XlCzNnQ+Doyx8EJ6KBF+RMh
/j6OSM8AsOpV/g==
      "], {{1850.6209999999999`, 1100.605}, {1863.496, 
      1100.605}, {1863.496, 1096.839}, {1850.6209999999999`, 
      1096.839}}, CompressedData["
1:eJxTTMoPSmViYGBQA2IQHZVifd/fZq6D6Dr3h79MJzqosjVOdQby+XQ3zc3X
mOjw8ZJv0gT7uQ7a7WI3z8lOdFg2+4iCgdtchx/Bj5dKi010uOybJHDDZ67D
zXPfg5P5JjrobJr7fnnIXAeQMd1cEx22nijbNz8WwQdaUzUlGcFXATIOZ8x1
KN83X0qfB2p+7lwHEZBC/okOQNf1Ti+cC1EnNNEB7N5SqH0SUH7FXIeEpxeU
ohUmOnibdzomVEP5chMdGECgai7EX6ITHU4vdN32uRTqX6B9GRPf1tjnQ+1j
nehQ8VLNsAPont7peULM/yY4FNpyXVdOmOuQJ9R8wOvXBIdPwPAQCEPwQe4T
90bwkwUiLLc4znU49FUjph+o3wfongeW0PBih/hfxGiugxPQgYv4of7Vm+uw
BRhO8tIIPjh8NNHkLaF8I6h9rlC+FUQ9tx+U7wSRPxU20UG+9XWgBTB+dnny
MGlHQ8MrAsEHx28Sgg8On6y5Dvkg/eGQ8GsohJofCHV/BdR+L0R4g8PXEcGH
pScAUmsDaQ==
      "], {{1871.078, 1102.933}, {1881.6409999999998`, 
      1102.933}, {1881.555, 1104.402}, {1881.3829999999998`, 1105.433}, {
      1881.125, 1106.027}, {1880.707, 1106.952}, {1880.086, 
      1107.6829999999998`}, {1879.266, 1108.214}, {1878.441, 
      1108.7450000000001`}, {1877.5819999999999`, 1109.011}, {
      1876.6879999999999`, 1109.011}, {1875.312, 1109.011}, {1874.078, 
      1108.472}, {1872.984, 1107.402}, {1871.898, 1106.339}, {1871.266, 
      1104.847}, {1871.078, 1102.933}}, CompressedData["
1:eJxllH1IU1EYxrerrdUkStYHFWn2CRIU/aExytdiDOfmagaV6w9ZBkbgKCJI
+qMPtZKWO0UYjJNk2aeZifSh0WpNJossI7I1Ypl9EBIhEeuDonPPeW8n2mBc
ftxzz3me533unev1ubcqOp3Ozf7qddKSLuprpdA+u6Kq10bAknT5p1+lkCof
aQuuJzBca+6w3aRg2H9yjclDQKf+7kt+eMZ640uf5Jz60XWFMQq+7IP3YpsI
VFRZko8fUahhbN9AwKgeNCg4xvavJp/2Fj2jsPtuy8xrawmUFhwprnxOYWqH
bfiHnYCD8eshCv7mmuwMpq+7n618QcF9a079KEjuKclSrhRK5n6mSFZ9fjYR
YNvWmuO4nxH9vMTzxhHwTt64optx/qFp8bJMPD9BYTAv8f23Itbve4V+FbF/
TpKKq57AjpUTh+a9QT06AmNPnd7A+3T+xvKd9SvAdflup7O2Xs3P1fvf8yHJ
d3admFEXRr3s/PPBSO7SCM5PEXm/7UP/Geg/SqHy3ZO8BPN7Sh0Esoflsefj
wmXGfuQJuB9js/pglmQtX425/gLJ8YFU+ZYi7FNUzGu7lQgdEaE/v4TAfBbk
gzDO04F5hrAfZTifHsn8fpfkBeogLqM+u9hf7TP3VyxZ06tx+OvizU0m0e8o
422sh6HxON+z2FcDgUhu587qcxQ+/Lw05s4U/jrbhL8RBedzAfujR38XMQ89
9rtdzovz9XTW5s/91aWztp5zg+RmVWijZN5XP/rXo58m4d/C9KvyFhHshwHz
PY7nmSRref17P7hcMs9vFfaH4P5W9ENwvQ31BfB9Y/NhNR1IMT2rmcDWUszr
GM7PgX1F/R4n9vsofk+c+D1plMyfPyyZv78NOD8n+ZsfZ+xXywHMx4X3T8vv
l9YPjf8AtE9Mdw==
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQXWDLdX2x3jyHhKcXlKLZJzq8VDPk0NGa57BaJipl
N9NEB/Gb575fVp3nAKSCk/9PcFjn/rBqiiJU/d8JDmIgCdl5Ds9/r/wY9HuC
w62fdVl7JOY55Ak1H/D6NQGiXxjBn3Doq8YdTgRfd9Pc9+qM8xxOLXTdVvxv
gkOyQITllp9zwfKn2CY6PKwSWef+aa7DlhNl++T5J0LsfzfX4QXQvkuSCH7Q
DrnW12oI/kWl2z//GU90SAKZB9QvCpT4ZT/R4TTQns+/5oLdf9sLIm/CPM9h
Dci/oRMdHgHtO847z2GXJw+TdjRUvxSCD/afEoLPAdKoOc/he/DjpbMjJjrA
wlME5JBgBB/s3xQE3xgINudB9QP5P4D6pUsh/Ce6UP3lUHldSPg/rpzoYH3f
v3e6zjwHtsapzt3VEx32lEyWaNGeB/Z/ds1Eh3ZghJRrQe2rnQgJX02o/2qh
4aOO4IPjQxVNXnmeQ/m++VL6tVD/K0DdVwN1jzyEP7seqt4Kml66IHwRe0w+
2D2KCD4wFEsmi02EpB97iH+4BaDpDcjfDQzf1bxQeQdo+uKeCHGHI8R96zmh
8ecEtY8Dqt55noM2KCCA6RkcLy6I9A223w3BB/vfHcG/DYxfGy9IeL5mh5rv
C3UfJ9R8P2j4s0LljRHpGSW+gXwArJSMGw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQXWDLdX2x3jyHhKcXlKL5Jjqg8G0nOqiyNU51hvJv
O050WOf+sEpEd57D6YWu2z67Qvna8xx2e/IwrfaE8jXnOQTtkGvN9p0IodXm
OayRiUqxDpjoUAg0X1l5nsOP4MdLpYMmOlz2TRK4IT/PoXd6nhBzCNR+mXkO
okCDfgH5e0omS7RIIviv1Aw51ggj+O1iN8+V80HdCzSPA2jRE06o+b5Q85nn
OZTvmy+l7zbRQfzmue+XGeY51GftKRG2QfDzhJoPnNJD8EHOjVec6HD7Z13W
HmaoeeIQ/03hhNrPP9HhFDAcivmh4cMBcc93UYh5XqxQ/8oi+C+B7tdRRvBB
/mMBhpc2UKMfB1r4A+MDAFH8tEM=
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQ/SP48dLZ7fMcQLS070SH2z/rsmya5jns8uRh0s6a
6GAaB2Q1zHNYIxOVYl020SFoh1zr6/p5DjfPfQ9+XD7RYcKhrxp3gHwgFdNf
ieCD1Vcj+CD1yfUTHVTYGqceBprHp7tpbn7TRIfvIPuB9iU8vaAU3TLRwbk7
53l1yzwH7Xaxm35tE8Hq3rfNc8gTaj7g1T7RwQUo/7sTwQeb34Pgg93fj9AP
9tdEhPl7SiZLsExG2A82bzJE/nY9gg92Vw2CL7rO/eEvoP/FQB4B8mWB3rtf
AA2fSVD7syDhk92DCE8AtjWvRQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQ/VLNkEMneZ7Dj+DHS6V9Jzq8AvLXxM5z+A7kz86a
6JAkEGFpEjPPoWzffKn1RRMdnLtznldHz3MoB/L1KxB8sP5qBD/h6QWl6PqJ
Dv2HvmrEAPXz6W6am980EaIuDirfMtFhAlD+Tvw8B+12sZt+bRMdbv+sy7JJ
mueQJ9R8wKsdyk9F8Attua4rZyD4Hy/5Jk3IQugH25+DMB9sb948h5vnvgcn
A+0P2iHXmp0/z0GVrXHq4XoEX2Sd+8OqGgQfpP5x5UQH07hdnj1Q/Y+LJzrM
fb/82OkcqPosqPp0RPgBAELmoK0=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}}, {{1, 4, 3}, {1,
       3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAmIQPT1PqPlAzEyHhKcXlKK1JjgAhRgaNBD8qBTr+/7y
Mx3YGqc6c4tOcPh0yTdJQHamQz5Q2yn+CQ58upvmvpeGqL/NjeCvkQHq5ETw
y/fNl9Jnn+BwVGFD0QuZmQ4g6XjWCQ4+5p2OD+Sg5jFPcBC/ee77ZYWZDhkT
39bYM0HtU4XyGSc4fATyJ2jPdAA5+xQDgv9h+TFv81/9EPWMmHyY+qWzjyhs
YIPaBzRPDGhfMNdMh/qsPSXCzBD/M/DMdNjlycO0mmWCgzfQfQn8Mx1kQQEB
dP+WE2X75IWh4cM3AeIu8ZkOP4IfL5WWmOAADk83iH1e7VB5LzR+5UyHoB1y
ra/FJjhUvlQz5KiFms87waEd6KDyhpkOF5Vu//zHDvVfM1Q/MLwKbLmuL26b
CXbHfGD4nF7ouu1zF4QvzwiNvwkI/8L4sPBYBvS/QTQmHyU8E6DxDTQPLJ8y
ExKPjND4SJvpILLO/WEVM8S939NnOvQCPc7MCo3vDKh/2BB8sHmcCD7Y3cD0
AkxdvdOB+uuA4T9ZACqfgggfAA1cIno=
      "], {{1622.5, 1036.433}, {1616.766, 
      1050.0729999999999`}, {1610.8909999999998`, 1036.433}}, CompressedData["

1:eJxTTMoPSmViYGCQBGIQzae7ae77NTMdgnbItWYLTHD4dMk3SWADgr909hGF
DZtmOjz/vfJjEP8Eh6gU6/vnt8x02OXJw6TNO8EBrH/bTAe2xqnO3NwTHBhA
YMdMsHg+B4Kf8PSCUjQrgq/dLnbTj2mCw1GFDUUvgPrTQOB/v8P0PKHmA0Dz
gaa3i/3ud1jn/rBqCtD+jXPfLz/2rd8BqO3c9/UzHe6pAG380u8Acz+Mz7FG
JurJSgT/YZXIOvflCP1bTpTtk1+KMP/0Qtdtnxch7Pcx73R8sBDhPhgf5n4Y
XwTkMKD/YPp/BD9eKg30P8x8oDNSrIHhA7MfrB8YfjD3wcIXPfwBCRW1TA==

      "], CompressedData["
1:eJxlVXtMzlEYLlHJh0r15VL0KbUka2WL0Kuyj1LRZyRNFC255NKFXJLLsjX7
jmG2Y2bEzLRmmBkNk9uyWeYP182Quc3MXJLGvOd3npyN3/btt+c757zneZ/n
fd9fRHFF3rI+Hh4eK/mn3r7NIwqWzpe0OnDHtcwGQb3Yu/5AemO+oBL//Inn
XQanN658sylPUofjaffWJYIeZBf758+WdP5O9ZUjZYKi1MZsSXkXw3d9WCXo
3ZgE37hMSWV7P25OXS/oZW1Qy+3pkoJanC9qawSpVxBJ6nK9OnGoVpD7+reY
wkmSFI3LWwS1H51+YX0S+NUJCnl8r8sVb/CNUWfWlUUb/J7va46QVHPlyLDx
fH7tFL+Ho8MkBfNFPzcIWsO4KVRSJPNsq0S+IVivMNjiU26wxbdUkJ3vf2CX
lMjPuWJBxUqfYbi/COvhkt70nPqcVyB0nBhJSWq/C/kma31WZOF8BvTLEHT4
08lbWdBvRaq+v3OOpAqO354iqLVyX+jOeZIuzbT1GZuMeAWSlCyvEjXeX4h8
4rFeJOkH8xgeC/0WS7rLun6JNNjyd6TBFv9g+Mvx9hzkDG3QYy7i9RPUwAdq
ZkniLO5U97i1/2mSmF1DyFeN2yYYrOI9SjDYqg/2cwbTbGFs+RIr6bgy6pte
b2b9VLoN3936/khJ7Prejz807gxDvF9urZsdenqA/xBJlznAaU9dD00BBiv+
XYMNjjvLDgyCvp6o/4HAHO9J99byVpukUvX8dtNGRZBx1b7QvvN+urX+A0x+
Fj+f//Hi1x2OhTHi7/5erGRw8n3T+I9j4YJSnufuOcj8OOuUIjv8D4RfgULn
GyxpOffX1YGol6HA/YFHYr+33v8hCvG8BG1g/rvjUF+9+SYanMH93pNisLU/
DfXlhXpxgr+voHGsXzTXw2nVvzbkl4N5EPAPthus+ilxuD5/Mht8w9FPWdgf
IbTemajPKN0/SU7MoxjwSUf/jIVfBDwO8SdKSlP6JqA/4lHPycjPgf6finjc
31Ydp2MeBev9h5zg74/5wP0seH49s2F+5eK8H/SZi3x8dD95LcB5b+23Y5HB
1vkSg1WYklWoDz+sV8GvAOi9GfoPBd8dmHcOM9+teRhvsDVvJhh8k+fp28no
911Cz4kM+F2P/pghiav5cc428MlC/nXIb5bBlp45Bls+5kq6z379rtP13HeO
9ntAPfjx96WuvLVyyHb47UL/7TTfo16+fwCFxfGc
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQnSQQYbmlZ5ZDwtMLStFlExxQ+BETHPaUTJZgWYSD
H4imHom/RiYqxVoMwdduF7vpJzDBoeKlmmFHL5TPA5E36Yeq55rgcFRhQ9GL
CbMcyvfNl9LnmOBgfd+/V3zyLIddnjxM2uwTHFTZGqcenorgA4059306gg9W
P2uWw4vfKz9eAvILbbmuK8+BynNOcABaz6Ezb5YD0Bjnbi6oefNnORz6qhHT
D3QPB9AhTxZA3cM/wUEcaPzlJQi+c3fO82qg/1cD+bs5oO6fD7WPeYLD6YWu
2z7PgprPAPX/tFkOF5Ru/6z71e8w9/3yY96TZjmAKPPv/RD7exF8udbXgTu6
EHygrqw97bMcpoEs/tEPcU8LVP5PPyS8Gmc5hPLpbpr7H6q+fpZDxsS3NfZM
ExxAwRNcN8shaIdcazYr1H01sxyAqkomc0D87wzknwKKF/Mi+CCKWwTBh8Uv
2P5cTD4ofFeHQMOncJbDlhNl++TDJjjIA/1jUQq1D5Z+KqHmx0xwuOybJHAD
al93PNS+Bkj8r0+G8ptnOYisc39YlTHBQQUUXkD/907PE2LOhsZX2ywHJ6CD
FuVD4ntxJyI9AwAHqEm6
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQHZVifd9/1ywH0XXuD3+ZTnBQZWuc6gzk8+lumpuv
McHh4yXfpAl7Zzlot4vdPCc7wWHZ7CMKBkdmOfwIfrxUWmyCw2XfJIEbp2Y5
3Dz3PTiZb4KDzqa575dfmuUAMqaba4LD1hNl++bfRvCB1lRNeYjgqwAZh5/N
cijfN19Knwdq/utZDiIghfwTHICu653+fhZEndAEB7B7P0Ptk4Dyv81ySHh6
QSlaYYKDt3mnY8JPKF9uggMDCPyYBfGX6ASH0wtdt33+DPUv0L6MiW9r7N9C
7WOd4FDxUs2wA+geaf27Kmx/+h0KbbmuK9+b5XAP5IAv/Q6fgOEhcAXBB7lP
/CSCnywQYbll/yyH1teBO+T+9jv4AN3zYDs0vNgh/hfZMMvBCejARfxQ/66Z
5bAFGE7y0gg+OHw00eQtoXyg/jyh5gNerlD+Doh6bj8o/wBE/lTYBAd5oEMs
gPGzy5OHSTsaGl7XEHxw/D5A8MHh82KWQz5Ifzgk/BreQ80PhLr/G9R+L0R4
g8PXEcGHpScAjk4VGg==
      "], {{1710.578, 1038.933}, {1721.1409999999998`, 
      1038.933}, {1721.055, 1040.402}, {1720.8829999999998`, 1041.433}, {
      1720.625, 1042.027}, {1720.207, 1042.952}, {1719.586, 
      1043.6829999999998`}, {1718.766, 1044.214}, {1717.941, 
      1044.7450000000001`}, {1717.0819999999999`, 1045.011}, {
      1716.1879999999999`, 1045.011}, {1714.812, 1045.011}, {1713.578, 
      1044.472}, {1712.484, 1043.402}, {1711.398, 1042.339}, {1710.766, 
      1040.847}, {1710.578, 1038.933}}, CompressedData["
1:eJxFkm9I02EQx4fCsiW2Wo3WatOlMVpWVtLa9rObutSxObdFDO1FmIEVtBIJ
ijCiJCJiT1gUHBEVFlGkiC8kpCILohch9qJC+odFhoQYhZUE3fP7HTyDsX24
e+6+970rac2m9uaZTCaNvvK3uS34IZFGyC4+9fiFW8CreKv1TRPCvgvfjz+y
CTj6bXVFQQxhyf26T8csAmJbzoY/1iIsJf6bL2CPNbN1UENwrn9Xap7LQZn5
5KWRSoT3pfTnZw5+jFHBcsW9+LS436P4sGZ5fdOBQN2vR/7loKh84Or0IoTd
X0Y9LfOEXq/GgjDyy7troVXo8awZwXfG/valU/FseqIX1yjW9fmF0Y/eh6ng
jVoBt4g32BB+y/y4AHf3VHLIifCE6ud2CpBlZ8sQZNsFLUa96QrFBfdWNH8O
KNb1VSM8aCjMu5sRxrz1CKkhV/dUmv2MG3FfQsDlg2Q0+Utl2oJRxVKPM6JY
n6dawLPi/o7JBOsDAe20l22NPF+VgMHnRx5eo/3oc2tGv0yU9YTYjzrFw509
y07XKJ4hvQJYr8ZcZfAB4Pe038m5OzNjYfYzhDDqGf/TRX7q9xPi/Hr2L4jw
lfJTMQGH5H4Dxr4aE5zv5/0mOb+SOc3zb2TewfOtU2ySH6/itbSe23RPVCU9
keR8F/sTY78cfL/beT47wkopRFOs72eTYikj6jXuw0/vqeryPhfHXdzfzvew
CuE8Cc8vMvq7fUZ8fD7336xYny+gWMq6SP6f2D/caSsUcEXGI8Z9naN7J7c7
2hsQuijeY2O/aN96Hwfvp4n1lwj4D+z2rtU=
      "], CompressedData["
1:eJxVk21Ik1EUx4eGlQ0bWvay0jSLkURERUUuzlIrTRtuEZISNvJDai5pDOzF
7EVEVJ4bslYclmVNs4lFSISIRUZEgYh9CLMXQsJIIozEagSd57kHLn14uPw4
597zP/9znjSP11UeYzKZ7PTp5y/3RNjai+BNvPjkZaqAGnv8m1sRhGOXv515
nCRgydjw7OtOhEW9ez6dihfwde3GeT3tCIuJ/8QKoCdM9VcRrBveZ8RFNZge
LfQIgfAhI+584KcG4umM7V2j4uzmqsnTZxUnrH8Q8voQqPrN3L8avP1dVzFQ
hVD2eSS9ZK6AH/SepRxhaMZWutAiYJziWUcQMhuTx4atimepD1yn2NC3Tch6
dN9BD3bkCMghjh5H0PvGQgEDvrall/wIJLNUOyhAlzVUj0BH9oISIfW0KO7E
Z6vuBxQb+kII/XnmmEixkP12ILgepTRMuQWc0P28I+OZTgFbDvfntZC/PSsO
Hd2Rr9iYQ65io59dAjyW4u19d1kfyLi5m/vbKYw6lV0ofbTL+a0Os54s9qND
MVX96LyuWNMfRtZrZ74muRL4Ps33S7R7etTBfgYRRtIpQn4auoOcv5f9u4Iw
SfmuAiF1BeS89js5v43nW8T5gtnN/bcyH+D+mhSHvnc9f3VBMW3Nw5O0T7Sm
7okizq9lfwrYLx/v727urwZhpW6EXbExn02Kq+l/yLfJ/ZhD9/2D7cvvpXC8
lusnCwjr+1CH0BqsToxNkPWnGmR8fD7X1/7nloDifVubHGXk/7mKAV+SmeM3
5H41W+T8N99GoC30tdH/uEb3i+bd98I/mLqM5xNh/WkC/gFibsUh
      "], CompressedData["
1:eJxllGlIVFEUx6dxm5opTbJoIU1oAYuSCAWJjomYjkspbVohYiAZClGJWwsh
USbeiDC4L4Sg/KBItIrW4DJjfZIssGQSUyszE22xaUaQzrv3vC7mwPD4vXvf
Wf7nf++6vOLM42aTyXQU//ozvGp8X2wfh8Y12fltVxkYHHjxZoJ1D4O4wYya
ugEOj16edYTvZZDZsraqcIRD1OXl/en75f6WUQ5/skbu8oMMdhxrTbZ949Df
48kaOcygtnN605EpipfDYPOD25MNvxQzXH/vVZydjxlnKR5+Xzq2Idpi1mR9
Bxi4vedOPAvQZPwsBgnVJ0fLLZqsK4PBUNmy5qRFGhSFXmpPSWbw/XVaHrNq
Mn4i9WfTYL3+YqfisOakIV+04iY931LFS7Zg4VYGejlNxv4g0mexBrmfXkW6
AxgUXJ+o2LWE4vszsMdcic8N1qA30u2dNTNA2Xo8IVSPWep1LVST+i6Q6yVh
GqCK5kYT6btyPk81dNtjfLXgirh/6gvq/T8b+4V+k4qFPj/5nHixv2memP9N
Wl7IOw8Hj64/1ocWMV3A+Yj+/ah/H//Xr77/0IzkHAv1MyP3Fy9koH/WgKzb
oNam2NDXYEN/g0W+OCZ1Qcaqh8p2S71X+MgficRe8i/6VeTF+rswX7Bdxts4
Tf2kMqnPDw4ljvpVW9MZ3OPOiG1TlD+d9JpQPIx6vRhTLOb5WeZfnU56DVP/
qaTHIId4fHEnhep3S72jktT50v06Hq94jt/6qF8r6YmMrj99I4jW39J5CZTn
cZy42p/W+7n0nx/p45bx42iepgHqH+eNanfbPyg/CH9+nM+Gv4T/ns5nY/8t
/eC1KRZzdCh/Cf91KH+JZ6eq96vury4ONXUYyJ/Og5P0DaTz5aJ+LOQXl9zv
Z1M8x1/I4j7IV7wdfw+LGDjRDwUumucZ8oeT9C+hdSfdZ6UMHuM867tI73I6
/51ynoUVxB2Ur5Lm0U71VFI/DsViPs8VCz+10nzoe11fUV8F+esJ+f885etV
9/dfltiyBg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQDQaWcxxWy0Sl7O6a4PCoSmTdcWsEX3fT3PfqdnMc
Mie+rdnfOcFhy4myffIOcxzyhZoPnGqf4LDO/WGViNMchxe/V3681DrB4dMl
3yQB5zkOpxa6bituRvB3efIwrW5A8GWjUqzv1yL0i4AY1QjzwfxKhP290/OE
mssR7mNrnOrcXTbBAeZ+GD9JIMLSxAzBB1lz3hihH8w3RJh/GeicG/oI+33M
Ox0f6CHcB+PD3A/jw/wH0w/zP8x8WPioAh1y2BgRfmD/mCHCFz38AZ59sUs=

      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQHZVifd/fcY4DW+NUZ+7oCQ4w/hqZqJTdggh+7/Q8
IWaeCQ7JAhGWW4B8YxDgmOAANIKhwWmOQ55Q8wEvtgkOYjfPfQ92nuMQtEOu
NZtlgsPHS75JE1zmOFxUuv3zH9MEh2WzjygYuEHtA/Iv+yYJ3HCf47DlRNk+
ecYJDuJA/Ze95jjs8uRhWs0wASLuj8n/sPyYt/mvfrD7zith8mHqVUEWqSP4
GRPf1thrzXH4Efx4qTTQvhkgh2vPcRBd5/7wF5D/sEpknbvuHIeEpxeUbjNB
/ac3B2IO0D/e5p2OCfqQ8LFmg6o3gPKB4TEdZB6Qf/irRgw/D4IPC08YHxQ+
r00QfBB1ym6Cw6mFrtuKgfzyffOl9F0nOPgA7XugD3WvxwSHIwobijJg9ntN
cFgKDM8NQPeZAKNjszckfDfoQsK32wcqrzPHAaQ83hcan0D/5oPs84XGjyaC
L9/6OnCHOoLfDozQclVo/EL1g8IXzAeaz6e7aW6+IjS8/CH89zaI9AQAmbb9
Cg==
      "], CompressedData["
1:eJxllG1Ik1EUx7epazEJC3uhoheJCCwoKlYYdcxkODeN2Yu6LNvsQy2yD7VC
K4uMqFa7Zkttd72RibnMQqIXsaiIUIhePsk+VFhISJhFmArR2b3n6Vb7MLbf
7r3nnv///J9ntrvcuc2g0+mc+Il9R4cP7Vixl0NkenHZQysDE/74WMVhqKC3
MbSOQav1Q0XqSQ7GI8Ess4vBxYGm5921iut2TTj6uF5xx57aKYlhDuX4d1cR
k3Uuc4hts21kcD30bNbCa5K7sP7SzQ9ykps4+DovTb21lsHnuYtM85s5TMSL
R2ySIzc4nMaLErA/570Zx7wtXHz3g2KsYmhZpljoGa943II74QEzA7vlROb7
FqpnYhCO6YnQfUkM0BLd4Zsc0o9P6slLpPtbObxOiw7/Msj9uW2k1yDr99/m
0P7C1zlTz+Q97dSPjkHgyY95m+7H81csYxkJgPDfH8/a/p/o37Qz/50/q7i4
LONdfpD6xfvXnNrZN3qe5of9NaLfbfWkP4H0N3Ao/fQqLZok/fdfkOxCPyb3
vBx6q/FYqoecGgtCsmLNX41FnxbFWKbAs4ry1CDn5c1mQl9Hnew/PYfB4BuH
mwVpnnbys4bykUfz8SsW69WKv+H5lIPUn03Wj+VZ6MtUrPWrcczGgFnm+xzy
9povBx6Nofn6KK9GBu6UwuVL9nHoG20edGIeslBf5X6pr9dA86mg/OhJXyX5
oad8V6l5Ca6OZ23+Qt+GeNb2Cy7897y/RLHIaynp15Met9Sfgf13X8m++91D
+TCSv2XUr1mx5tff66HFioV/K+l+2p+RTXq0/VZa99DzhvOZgw/OU+xnNTZ4
NZf82krzs1NeqX+Xg/K9hd4nDul3qESxOO9SLJ7fIpqfg/3xTzDly7ue/Mmn
9d3q/aXlQ+PfJdti8A==
      "], CompressedData["
1:eJxVlHtIVUEQxq/v69VUzDJS1Kwskl4YlJk2kiWaJnpFtPpDpEAKtCS0Inpg
EhFyNyoM3IMUWYRh0ovIsHylqZmvFNGwMEsRs1LzVdbs2bGlA/cefmfP2Z35
5ptZlpaZcNDaYDCk4E/ciwtr/MrGOdzz3nsgxMQA//vihjnkF2S429gwcFn7
QMsc4FDZcGPnk98W+NEWm+bWzyE5+FF99qwFLizubs7p4zDXcXwoYMoC+Pro
nR5a/2mBx/XZFUVdij+e9CiNbFVcGolPmjgIrJixgEFc9RzKo5ytS6wY1PqV
ZQ1Wc2j175mes2MQs/li+IdKDjkVRUvvOykuwfjL3f9fX+9JXMXB/ty1HU5e
xDUcMtxzX0b7MBlfneQGfwbtmF5yE+W/isl82zkswkBn1kh93nYTr2Pw/NiV
Jbaoz+Ds3e9tQQzm9RTnXQpW/AzzCQxVnH555NT2XUzexzh4CCFiGOzG+FK/
cUgdaPHviWO6HmdHOKwUG5qZ1G+Izk9kcF0E3q9YbHO1T7H+XS/tZ1bxT5n7
iwvjaR3rE4iF3EPnGTo5BOH1MEZxptAnisFtjH9DJ+kZobgR7TEGDDC7rPR3
HE4fQmXCSG/UL+GpT97wNgZol0lzG+kfQvm0UP5bKZ83ivX1RsV6vK85fEG9
E0Lk+WV1FA/qezTU1LX8FdUzjPSs5RAuBAhXLPL3ilAs8m+OovPQf9UTq/e7
oh7Clr7NSj9djw65381kBuiW4E29dP4+BgXi4M+KPTHf9q+K9X6ZIP+mkB9m
qF5JDLD78gvmOAiZ+hPpfStN9kM89aeNJvWLlf47b6vp+h6OpnjtNKjC+C0R
ikV/l4co1vXxVnwG67XQg/JHFr584UL9Mf++M5N1Rtb9biJ/2mt6v+Q6kp8d
NKmXkcGJoYCNRqMm+9Eo58mokdYdiB0Vi3wnTYqNGPgnJ4rPSHo5a7K/jFIv
TxfK31HGX+dG3ztRPTyIXRXPzzvdjws06SsDA9+84fgtmM/7FfgA55M+//7w
f6z7/ZdivV7THG4dQeNNyfWySQ5iLCThvBT7Vk9Qf+D+4rPqcfKbrZoH8/H8
BR6RkFE=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQvXT2EYUNX+Y4rJaJStktMMEBxhdZ5/6wyhjKfzXH
oXd6nlCz/gSHJIEIS5MncxyMgWCzzgSHjIlva+wfznFga5zqzK09wYEBBO7M
cdhyomyfvAZU/sYch8NfNWL4VaHy1+Y4JDy9oHRbcYLDDKCxBy7PcSjbN19q
vdwEsL75lyDmG0sj+EE75FqzxRF8MC00waHypZohx5U5Do5AAxfxTXDwMe90
fHAN6n5uqPk3IfZFc0DV353jABI+xTbBAeStAw8QfPGb575fforgt4vdPFf+
Zo7Dj+DHS6W5EOEDCy8AkUaU5A==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQzae7ae57vbkOQTvkWrMFJjh8uuSbJGCE4C+dfURh
g8lch+e/V34M4p/gEJViff+82VyHXZ48TNq8ExzA+i3mOrA1TnXm5p7gwAAC
VnPB4vkcCH7C0wtK0awIvna72E0/pgkORxU2FL0A6k8Dgf/9DtPzhJoPAM0H
mt4u9rvfYZ37w6opQPs3zn2//Ni3fgegtnPfDec63FMB2vil3wHmfhifY41M
1BNtBP9hlcg6d02E/i0nyvbJqyPMP73QddtnFYT9Puadjg+UEe6D8WHuh/FF
QA4D+g+m/0fw46XSQP/DzAc6I8UaGD4w+8H6geEHcx8sfNHDHwCVjali
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{1471.895, 1214.3622050000004`}, {
     1359.895, 1342.3622050000004`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0005827365172898222], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{1452.617, 
     1236.3969550000006`}, {1431.9609999999996`, 1237.7730800000006`}, {
     1476.714375, 1208.8550800000003`}, {1453.9959999999999`, 
     1257.0537050000007`}}}]}, 
   {Thickness[0.0033125865404013363`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}], 
    JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{352.03099999999995`, 
     932.7142050000004}, {883.621, 932.7142050000004}, {919.0780000000001, 
     932.7142050000004}, {947.621, 904.1712050000006}, {947.621, 
     868.7142050000004}, {947.621, 708.7142050000004}, {947.621, 
     673.2572050000003}, {919.0780000000001, 644.7142050000004}, {883.621, 
     644.7142050000004}, {352.03099999999995`, 644.7142050000004}, {316.574, 
     644.7142050000004}, {288.03099999999995`, 673.2572050000003}, {
     288.03099999999995`, 708.7142050000004}, {288.03099999999995`, 
     868.7142050000004}, {288.03099999999995`, 904.1712050000006}, {316.574, 
     932.7142050000004}, {352.03099999999995`, 932.7142050000004}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAWIQbXBXha1xbqMDiJqa3OPAAAILGx00Y/oPfZXocXi8
dPYRhRkIvo95p2PCtEaH1teBO+TUehwqX6oZckxpdLigdPtnnT5U/cRGBx4m
7XYx0x6H8n3zpfR7Gh3+Xal4qWbX47AMKL2htdFhSYEt13WXHoetJ8r2za+F
qveE8ksbHdLTgMC3x+HTJd8kgWyo+/yh7otD8DMmvq2xN8Tkg82P6YbzwbRn
t0NUivV9f+NGB2l9oA7bbgcQ1Wje6PB++TFvc4tuB3B42DY6hPHpbppr2O2g
s2nu++VujQ6lkyVYwvS6IfYHo/HjMPkHTy103aYKtf96AwYfph4cbo8Q/GnO
3TnP3yP4RxU2FGX8bHAABUeaEdT8/w0Q/1pB9TNB/W8PNZ+l0WGR67bPf70Q
fJTwYEELz3sNcD4omjXOI/jg+DjSALHHDxr/+xocSkDu8+lxqADF7zYo3xMa
/usbHEJB4efcAwnPlQ2Q8LXucZieJ9R8YHGDw0ZgsB4z6oHEx4IGB6Au0zh1
qP75DfD0lgniT0Pwwe6d1QBPrwCitCO/
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQrX9Xha1xf6MDiJq6utshKsX6vj+Qf+578OOl3d0O
lS/VDDmOQ/lF3Q5bTpTtm3+t0eEeSH1Ct8OjKpF17s8aHdJAwK/bQXfT3PfL
fzQ6lEyWYAlz7XaYkSfUfIC3Cc7vdEx4ekEawQebr9Hk8H75MW9zz24HH3Og
CqMmB82Y/kNfA7odBCMst5ywaXI4eGqh67aIbgcvHibtdleofGq3w1aQe3yg
8hXdDrIgDwRD5Yu7HTxB6gOaIHRctwMDCLg3OUiDPO7d7ZAx8W2NvXmTQyTQ
mjLLbgdweKg3QcxR73aYDnK/cJMDSLuYPFT/n0Y4PxZojcYjBP/TJd8kgTON
Dq2vA3fIaUL9v7MR4j/bbocjChuKMpY3OjQfADo4sNshE2T/PCg/B8H/AFLf
h+CD/bMJGv7LofF1Hhpeu6D2P+l2KN83X0r/bKPDeVB8/YCGxxOofqYeiHrG
JlS+JIL/eOnsIwq6TQ6LXLd9/vsLGr42UP+/7obIA8MbHG63EeENlj+G4MPS
EwDqUwh6
      "], {{567.938, 887.136}, {580.3589999999999, 887.136}, {
      580.254, 888.8549999999999}, {580.0469999999999, 890.0659999999999}, {
      579.734, 890.777}, {579.254, 891.87}, {578.531, 892.73}, {
      577.5619999999999, 893.3549999999999}, {576.594, 893.98}, {575.582, 
      894.292}, {574.531, 894.292}, {572.906, 894.292}, {571.453, 893.659}, {
      570.172, 892.4019999999999}, {568.891, 891.14}, {568.145, 889.386}, {
      567.938, 887.136}}, CompressedData["
1:eJxlVFtIlEEY3SR6iJLoQbQoLEqKypW0VhPz6waVhVQkXXwI6YI9mJHpPnSh
GUViKCkRIYklrYxeCikJ0s1LmdgFKSmysgcrjUXdXdnM0mhm/vM36v6wLIf5
Luc735lZlHNi95EIh8OxR/7Uf0toWXbZMUb7Uh60F44JalX4ZThu6rixpX5Y
UO+tqqexbQY/bC/0epoZ7Y1cVXc9KCj4ZmfOnCfI9wuqHx7vcjcwKlYJg4KK
vJ55zseMjqrPZ/DN/LSZ7/sMnhWxojTqqyBVdqgR+T2CZFRNfivqvxN0vKGg
PPoZo+XZZS2ht4IUvfvPGc13fl4yoxP1XoBvh6CDh1O/ZHYzOl0ePT2rDvV9
5lzHjzDy17ZluLoFXdxw6FvnGOr3TsF9BnNVwId5/4D/IM5/MSpQ/fzQ7ycj
ye5ChdRLzx0wek7iMwFP2kcSD8N2/IIDcsCV3OIjce6VgTPpcZyG1DwBQbeV
PrGc9qv8AUEO9cVwKvHterSwX5D2QySnbWqAT4JUucxp/L8+mk8v+NcIWq/2
EYPzLEGdiz+OnpP9ZFRt2ybM5+TWvpMRv4ZTj8pPwv5SOa2TdLwJgna4pGIb
ueWnePTP4NY+JuBm1W8p/PadhWE7Xus9YLDMvlQZZKTG9zrhJ7mPGsVzNfiN
MqqWao5LfrPVvL+ZpavLYK1/qsFav3ToE2KW3lun7DPL3Cc9fzH43jXn2j8e
1Jf5buXHa+CTbrD2U5rBul4K+lUx+tvl/hG3FvN54MdE8K0GToDf76BfPPA9
o5eNbX01zg3Hdnxl3lzelIf7EY/7eAr6JYBfEc4T4Y+zzPJbMnAp9NyM+Aqj
j+bfAr5Xp8z/Cvu9jPelB+9TCfr1wz/nsR/p/9KoD69H3Iy2q/4B7OOkuX/2
+2jjf/78htQ=
      "], CompressedData["
1:eJxTTMoPSmViYGDQAmIQ3emY8PSCTosDD5N2u9iEbgcwf2MznF++b76U/pxm
B82Y/kNfY7sdFhfYcl2f1uwQxqe7aW4gVH5Ks0MaCHgg+KWTJVjCnBD8i0q3
f9bZdjts+/z3SgVQf8bEtzX2lt0Ony75JgnMbna4p8LWONW020Gu9XXgjvnN
DtOcu3OeG3Y7yIP4K5sdLoD060PV74Sar4fgHzy10HWbarcDyFnvQzD5MPUV
IPckNTtYbTlRts+g22F6nlDzgaxmhyUgfxl3OyydfURhQ16zw12Qe8yh/DJo
eNh3O+iDJOqbHVoOAC3wg/qvs9nh/fJj3uapUPf8bIaEU1YPRJ6xBc4Hh29+
i0OEJdABSVD/VbRA9PtCw7+hBRKe9lDzOqDxAwyvqBTr+/79LQ4g7fuMuh3s
uK4vLpjZ4vDvSsVLNWD42IL4y1rg/oXxYeEBNk8Tkw9TD3aPaYvDIldgTAH5
maB4smtxAAnLGULDwwmq3wTqf/cWh2ZQeFhA3ePZ4nD+e/DjpTYIPjh8HRF8
cPgD00s0yD9uLQ6hoIgKhrrHARE+ACfVLEo=
      "], {{644.7730000000001, 
      884.1830000000001}, {638.039, 900.245}, {631.133, 
      884.1830000000001}}, CompressedData["
1:eJxdkltIVFEUhqchfLAL4UNFVpaIKBbSg0xpY3/EQKEiKooMQ+igREllYCkR
gbg3EaswiDAIkVLrtSQsqIbJJruAmSYNJNFloBLxEjJUD1pn7bNogwPD4T9n
7X+v9f1re/hkZaPX4/H4nT8/i1Pjvc2nNFqublxZ00oo+lR+uatJ41ZgcGEx
SJi7M1ziq9PuM0AINjgV5Rq5oc6hZAHBqZpoK9aIvr4ZGMwm9DX7U+N5Gqu9
eRfWZxD87L/Bag///qr/OkNPVzycUu79uYShZE6oM65cHz/hAfs/VzjN3yvF
77Fy+ztutam/YvXHrJT2awPS37DUj4j/B7k/Qbj/8kykZ1ZhaaJtKvs3oetE
Wkc0RebxXsKanQPdc5lWm/53W/2uLLyu9pAGj7F1kdz6GuHzk/A2c/LP+QaN
e90OwW/Cr0l4Ti7To8v0K0Kp7+L+uqMaM+f2FRyOEZ5x/40aT/n+qPCr10jP
dyZ+Qijh+pCcfyT11VYb/1KrTf8BjXnWEcLtG7FtdyHfY5KXk2/tHofUC9mH
vRqjv6oS/SPiV6TRy/zfC+9Cyfuz+PuEz3fCWuazS/hMS147ZJ552Z8sOb9A
aI30bMpPt5rHbF9lteG9pNDBgcwQzD4nlev3hXCd8/yhMMv8xuW+r8rtJ2K1
6afPasObhK9zvpAXpUXmTcr+1BO28IsVGmOccxlhM+s02Y8DUp9jtdk3n9Um
34DwOCh5VQjvKkKi3wkkqFHN4ILCN6zxhvkfkX0+pt19P0v4B5FMxzM=
      
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQnTnxbY39uVYHzZj+Q1+dehxg/AjLLSfK/nQ7eJt3
OiYwtGHwwepfdzug6EfiLymw5bqegOBPde7OeR7U7VC+b76U/oVWh4tKt3/W
eXY7PF46+4jClVaHeypsjVNdoPwbrQ4g6/bZdztkgPTfbXUomSzBEmbb7aB/
F6jwMYKvu2nu++Uv0PhvofbZdTtcANnzqdWBh0m7Xcyp2+GIwoaijO9Q9a7d
DiBna/yGynt1O8zIE2o+8BcqH9DtwAAC7G1wvgHIfsY2iHpHqPqfUPebdjtM
B/HfQ/2vC5V/CjVfDWr/7VaHD8uPeZsrQeUvIPiHv2rE9J9E8D1BGg+1OrwH
8VW6HUDBMn83lK/R7SAIipgtUL5OtwMo+Dasb3WYBvK/ITS+1kD9YwkN35Wt
DlYggxyg4bm81eHflYqXaj4IPoiaGo3gw+J3K8j+Vkz+gVMLXbd97naoAMVv
X6tD6+vAHXLfux14QREyDeoeYPqRjUqxvj8fGh6sPRD+Cqj7eHsg6jZA5cV7
IOG/o9WhFCSv1ONwCBQ+u6HqNXog4XUA6n9jqPrjiPQMACY0STw=
      "]}]}, 
   {Thickness[0.0032812502293197952`], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQvXT2EYUNU6ocDp5a6LrtaKdD+b75Uvr1VQ5LCmy5
rv/vdLjv3zs9r6zKQTOm/9BX8S4HPt1Nc9+XVjk0HwBqkO5y8HhYJbIOyA8F
Scgh+GD1igh+C0i9VpdDVIr1ff/KKoe3NfamcQZdDstA9jdUObxffszb3KTL
4WrFSzXDjiqH1teBO+QsuhwYQGBSlQMPk3a7mBVUfh6CDzZ/JYIPdv9mhH6w
+bsQ5u+UA8ocQtgPNu8YVF4bwQeHhwqCH2m55USZZJeDwoaijImHqxwyJgJN
4O2ChM8+qP0MXQ68oPBZjghPAPwDni4=
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQnfv898qPTFUOB08tdN12tNMBzH9TCeEzdDlMlmAJ
43te6SAblWJ9X6DL4WrFSzXDJ1C+NIIPVq+I4H9YfszbXKvLwf1hlcg6oP63
NfamcQZdDktnH1HY8K7S4T1I3qTLwQMk/7XSofV14A45iy6H8n3zpfT/Vzrw
MGm3i1lB+dxVcH6HY8LTC2II/gWl2z/rFKrg+sH2a1TBzWcAAYMqh+YDQAcC
7efT3TT3vXGVg7T+XRU2bQQ/wnLLiTIVBB+sXr7L4b5/7/Q8mH7hLgdbruuL
CzSh6hmg6oUR4QcA1j+V/g==
      "], CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7W3e6ZhwscYhwnLLibKCTgcguW/+vRoHHibtdrH8
Toe3NfamcRtqHA6eWui6TbXTQTYqxfo+bzUGH6xet9PhHUi9EoJfvm++lL4l
gq9/V4Wt0bPaYdPc98uPGXQ6gO0PrnYA8rzNLTodqkXWuT+MqIa4x6bTQaj5
wKmF0dUOLUDK1Q3BB9sfiuCDzWfpgvOnOXfnPBfpcuDVBdoUDjVPvgviv4Bq
B5Bx25S7HB4vnX1Ewa3awQtkgGaXA4i7wQyqXqcL7h8YH+ZfdP6SAluu68Zd
DltB5jPVYPBh6vlA7nla7RAGYgD5ViAHXax2ADnbVRvqnmNQ8zWg+nfBwrvL
YRnIfZuqHT6AwkupCxI/66odNGP6D32V7XK4WvFSzXAVVL0k1LwV1Q6eIP/x
I/hg8/93wvmw8ITxweHj1elwHBRBQPNaXwfukHOGpg+YfXadEPdvhMafDVR+
W7XDvytAh1h1QvTthYYPMH5B1u47XO1wQen2zzrzTgh9o9phMUjeDJoefiP4
4PSgVAPng/3rg+ADycUFmTUOJZMlWMIsoO6vgvKtOx1m5AFTRFeNQxoIAN3L
AAKzoPED9I8MKP6W1ziAkuVU704Hj4dVIuu2QtUHQ9Pr4RpIeMRD3YeUXwDR
YnSX
      "], CompressedData["
1:eJxFlGtIlEEUhhepfkRadLHw1q7JpqmJhJiZ6zGRNBEzQ1O0TNQMTC3KLJoP
REyGCBHLgrLL6mb+MCTNLEjFRNJgE1PCTEWiJKIkQyqi6Jv53m0WluXZmTnn
vO+cM5b8sgOFbiaTKUv/it97NwbNHW8ZBeXUDSzFcjrbe9sr7BGjfavcgmvD
OSXOnV//oInRQutQcmQQp4nKT9bwK9hv5RRc6znprGHk/JH+3rGF08BSYE5d
BdYtnGZTL18rLVLcsGlZhkeKYj0qj9vJ6Hj9lwuxejz30IdNC1sZNZfHrHyz
nZO541Rx/UZGo/5Tv7RITvq/zeWrGflkF0TP7lEs4+1X7CvWs8DrGM0ErKi6
ehTszUjI8yxGfVbwSU7iWGoU9J+D3oOMsqK6XlRUwZ8yMOdkEp+bjP6O6xsb
OLn8nBb5biluEXociu0J3d//POZ0Yv5327dxRodEvEHUNwy/X3LyEH48Y+Qd
pkccg3/tyD/BqUScb1Qs/byoWOapRLzXqv7+kbsJ3U6sFzCq+ZzW4zcC/48w
aoy/VDI/qFj604f686CvU/GxIv3Tzski7iuX0SvRD/ehJ5PRaVG4rr9Y3HMa
4tmhJwn670CPTbFcj1As6w2B3/p5h8hvxf3q8WWfmBG/jZNN5PdlpKtoHWpX
LPV3Kpb6+5AviFGGMH4Y/UHKP+lHJuK943S9dG11fyXyz+E+7Yql3ueK5bxM
o39n4N8i7muS0xM/vRI3japFgRPY764Z8+DE/W3QDH1D6D8vzfC3H/X6aEb9
XYrlfNgVy/OFiuX8pkO/r2b4nIh1P+xP4CTK7N2sGf7HoT8tGiWJDTboD9AM
v2I4LY6l5K8J1Ix5jOa0V7wnwVh3cZjibULvDsWi7asiUV80/NqlGX7u5tQj
/CKNzojCbag/GefjUU82OFmx672T9xOjGfMVwonH5X0YNUOvP96/5Ypl/p/s
P8v8X9HfAejHj5j3QE65T3VnZjEfoZwOC55Cv0Wo98BVzz+vNX6A
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQvWz2EYUNt2odNGP6D3316XSA8SMst5womwTlb6p1
8ORh0m7v6nSYkSfUfGBGrcM05+6c5y2dDrnPf6/82FPrcE+FrXFqY6cDr+6m
ue/Lax1A2vdVQ+Uzah3C+IASpVD5+FqH98uPeZvndzrkgOTDah1ko1Ks72d0
Ojzw752eFwQ1PxHBL50swRIWheBbgcwP6HT4dMk3SSCi1gFo6vJjHp0OtlzX
FxckQ93vBDU/D2qfDVR9Ta0DyDtillD3dSH4GRPf1tjPR/CB5M1zO2sdDpxa
6LrNHhE+sPACAN5UmgA=
      "], CompressedData["
1:eJxTTMoPSmViYGDQAWIQzau7ae57qQaHJQW2XNeNuxz4QHzZBocIyy0nyr50
OkSnWN/3F0PwOx0Tnl4QaXAIBSn83+nQAeILQfnsXQ5RIPUCUPU8XQ7vlx/z
NudpcGh9HbhDTqTLYXqeUPMBtgYHoC3Lj0l2OciANPyvd4gEqZftcrha8VLN
8FM9RL0ilP+g3kEzpv/QV6UuB1mQ+pMIvnDzgVMLazH591TYGqeGdML505y7
c547dzqU75svpd9Y7+DFw6Tdbtnp8LbG3jSuA2q/aafDRaXbP+sm1UPs0e90
eLx09hGFRfUOIOViup0Qd21H8GHuQecfPLXQdZtqpwPQ1H3zn9Rh8GHqwf7/
juCDrNvAhzCvSmSd+0O5egdPkIAB1L0a9ZDwNe+EhI9evcMBkPnWUPcZ1juk
pwGBK4IPCw8YHxZeYPM+1MH5sbuANl1H8Be5bvv890gdhAbGxzuQ+l1Q9yp0
OVwAhdeaOoj5wPhbBnL/gjoHK5BHJbog7p8GlRfsgoR/b50DyHlpXF0O3ubA
FNUODR8GKL+1Dp7ewO4rQ/DB4VdTB0+vAPfjNbw=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQbXPfv3e6RYNDhOWWE2XTOx0uKN3+WQfkv62xN42r
6XTI2lMyWcK+waH1deAOufROh8u+SQIRPg0OB04tdN0W3umgu2nu++WRDQ7N
IAGPToeHVSLr3DMbHO6psDVOdeh0eL/8mLd5NYL/eOnsIwrtCL7BXSBjYoOD
bFSK9X3nTocrIPNnQd3j1ekQ03/oq8biBgdpfaDCwE4Ha5B7V0Hti+l0ALt/
QwPEnpxOBzmQQ7dB+RmdDu1iN8993wzVH9YJsWd1g0MkyHzXTodtn/9eqZgH
tc+s06HypZohB9A9njxM2u3qnQ4ZE4Eh0dDgAOKKKUDDIwfBjwW5LwzB9zbv
dExwbnAI4wOGjAbUPcYNDgdB4WUJ9b9Kg8NGYLAd84KGp0yDgxXQ+n2JCD4o
WKbWocnPhfJVoPZtg/JNoOqPQ/kuUPmbnQ5HFDYUZUQ0OCwpsOW6/hAaXgUI
Ptg/rQg+OHymQvXfhobfImh8nYW6fwNU/gAivMHhuw7Bh6UnAAUjChg=
      "], {{
      519.0740000000001, 820.37}, {529.637, 820.37}, {529.5509999999999, 
      821.8389999999999}, {529.379, 822.87}, {529.121, 823.4639999999999}, {
      528.7030000000001, 824.39}, {528.082, 825.12}, {527.262, 
      825.6519999999999}, {526.438, 826.1830000000001}, {525.5780000000001, 
      826.448}, {524.6840000000001, 826.448}, {523.309, 826.448}, {
      522.0740000000001, 825.909}, {520.98, 824.8389999999999}, {519.895, 
      823.777}, {519.262, 822.2840000000001}, {519.0740000000001, 
      820.37}}, CompressedData["
1:eJxlVGtIVEEYlRCLasOWHqIpKrtllm4PbbOy/aykQqUXlVhUSPaAKH9E7Q+R
O6TpjJRImZqZlFnUr7AnBNvL3lFmkUVUPywiooyk1w+tmTvn7q11Ybkc5nud
852ZhMIdy4sGhYWFFcm/+hZsnP12yVZGOw9Eha+6wsnELYxOFGcO7drIKcfL
szacY3RoftW2D7k4v8qorann1O1MTt868woj7zDKzzh/d5eXU2XWhvcdjxjJ
0xzvVE4nG9vjz75gNEseB1KA3zEaPmhSxZh/8PX7x7IvuoGLB2IrXk7VUuxn
tKXmc4lP4u5WGVDKKMbz2hWRyomr/gzzeDhdkG2byxitGpHS1jSFk0N+evYy
2qR+01C/EnzTOHUkvvpdKqCHF/2qGMUq4hk2NuvPCcE+Ti2qjsw368xDfc7o
jSuC1WaH9FvIKUz9yhk9/rmiuzWPk6JzthR8V4PPUtQ/Av2jGE1cW33j+wpO
axR2Qu9c5I+AHrL+XDWfA/kLuNZtOPhkIX4Y8n02tvj9dz6T06Xevmd+B+ZN
w/5Hgs9U6D0K80v91RgshtETpYe1b3fI/t32vk2+t4wB2Iq/+T1pbfVDI+in
XOXPToPKPy27HOeBPl1G0H83VPxb1EuDnz8Y9KXEl74uA379YgT5f1XfH4bW
T+4rThXuN+h49sXevjzUH4L5C8B/ESNFs/YM/OWEfr/gj3D4zyG0X38Z+jxG
6HzZ39xngqCKMS8f/ew2aLFqkCToqTzOf4F5JgvaHWiO9jxA/j/Y1H+6CM4T
iq14c3+ZLFjP5DuDUdk1KVCy0H6ahn1PEFrfVGCX0Hwmo368jU09Ym3c/8z/
cXyUIFltX52Haf0iBSkZetKh12DEr8f+70GvaswbIfT9qLX1M8/rmdbHKbR/
GjDfaKH1Pwx/jxV6/43oF21j837H2ticV/Kp2+7cc03mr1T9EqFvA+ZzAddh
PqmP6feDjDar92Si0P6sQb9k1N/PSIUHJgl9/+T9/6z8J/W37ru1Hwtb+zPz
3wzEVrzpl+f2PuvV/B1Mv0PJ0PsB8pNw3g7sFuRXfAJ4nxPA7zLeq3GCtqp5
2/BeSj3NvNPId0Dvo8B/OP0F2+vOSQ==
      "], CompressedData["
1:eJxtlHtIU1Ecxy+joiLKHqxR9JJcD18rk5Ez/EVJhkUgGBIRMgxKIvtjxQqL
PAvGOSERowwkosdaRRSVTYiQGSUhZFIDkUyRiBxhi6LCQOmee76XA1uDcfns
/s7v8f19z1b5m2oOOgzDqDK/8vl+tz+nLsro1rEtswfecLJ53f4LL37VZvB2
TvKxNsboe6yn2lvG6aY8d49Rd+/1yngpp7ajC0KJh4weX03Heoo5JeX5OPIX
cPKN7Glt69Lc+DwQcb3NZitfHtifzXa8lb9Rc4Es3KS5P/fDxJkAo6lkMOUu
4ur3IN57OB26ON5ccZqpuBJOo6cWPdhxltEcR37Y6eUUdg72/Wlh9HH1jJZL
Pk4dr090XQshH3GK/5xMBs9Bn6oMrtVs62vlq8/mtNRzSMf/l8c0f2uuKD3w
l1O1l2+tDzMqk43NEiquldHxiGvaXqegkyn3hpkRRjcqzZO5QtVrR75CcAz9
bgI/gd7lgjplvW5Gw3J+Eqp+fwYPa7b0+wr9ypHvN7hEKP2mwIU47wipedya
rX6WZ/ASQVekv4yQ6n+xUP6cZJSQ/S4UdHnb+SNfJjBfjlA+NevXbTYrzwX/
0Pwp2v5yZVrzsn0NvhGz/52ywXmoPwY95iP+M1NxZj1DfkYxv0sofw5hvyuE
ui8DmHcN5n8HvfORvw/1iwTtkvvsxXuPUHle4b5tBCc0W35/ptna11P044Ef
HjEKSD/Y+76PftZDr7uMlhabDs9D/3eQz9T/sLwftxmNy/3Yekfht+marfwp
/X9h+9fiZDbb/v8HGZ0qDw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/X75MW9z+2aHeypsjVMfdjrIRKVY349C8Ctfqhly
FDY78DBpt4td73SQb30duKMRyj/U6dAudvPc9/5mh39XKl6qbeh0yNpTMlli
erPDXZD+2Qg+kGQJa0HwF7lu+/y3uNMhpv/QV43JzQ4RlltOlCV3Olz2TRKI
6G52OHBqoeu2oE4HfZBBzc0OmiCFjlD7K6DmmULtz2p2WFJgy3Vdp9MB7J9Y
qLxKp4MsyD++UPcqQNXbIPheIIYigi8HMp+72UEaZLF2pwPQlVcqfjdB7Hfo
dBAEOfRtE8S9wVDznjVB7M1A49cj+GB39EP9/xqqfwHUv5+h5gPDT2fT3PfL
gfaB3XWw08H6vn/vdLZmB5DwsbNQ/SLNDgdB4XO100EXJAF0fxgfkHUXGl8G
iPhDj18A2wHiAg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQnbWnZLKEZbPDPRW2xqlXOh0YQMAIwZ/q3J3zXKvZ
4YLS7Z91lzodlhTYcl1XbnYonSzBEnau02FGnlDzAZlmh39XKl6qnYLqF292
WAxSd6jTwfq+f+90oWaHEpD6HZ0Osf2HvmrwNUPMWdvp0C5289x3bqj8AgQf
LN+PJl/a6ZAx8W2NvWCzQ4TllhNlcVD3SDc7vF9+zNvcu9PhiMKGogy1ZgfN
GKBF5p0Ol32TBCJMoO7V63SwAbnHFcEH+ysIwX+8dPYRhdhmh1A+3U1zjTsd
tn/+e6UitdnhA8h8u04HQZDFuc0OslEp1vc9oO4rbHZofR24Qy4awQfbX4Lg
v6uxN42bCg2f7GYHGZD+dZ0O4PAH2hcJ8s/BTgedTXPfLw+G2ncOyndHxAd6
fAEAmNLFnQ==
      "], CompressedData["
1:eJxllH9ojWEUx283P0ZiND/y4zaMWeO6o1lrbTt+pyEUIUkLTYklFC2l80gn
f0i6/CFJw9X+YLi4bdy7e733neyfoSjihsRad5PcNCWe87xHT7O33t4+95z3
PN/zPee9M+sPbtrj9/l8y/TNz0/XLzmFXxHeF404Gf5AMIhjBHUVtHTXT4QL
y8/s//KS4FjP3LK8kWpw/mTL1aNfNzcGLHfPejtwokjB4fNThm3JEDScyzbV
lihobtSZbwi+v1hXnx9UsJevV5IfUoAdz66ufG55a2X06dEuy4rjLsHFAxOw
Q79v9CWlfqmCI3xenECr/9xdrIBfj7cRsNzW2QpKdpxN5XR/07fvrsoELH88
XnBr9VTLRt9E5dVtl/rjFFxj/QmC0Dvd6CjR70h8uAKW98AVvX7Lpp7Pcg37
9Ruhr6m2fGeagGVe+YVePEVwg/X+QM+PxwRrxvhLT/eh52fUzsvoiVg28Q2W
97GuVQRreZ49CJvHLrh7uYZgBvffi7CNDaokuM/nZ9H7vZxAZ/VHvqHn0yIC
H1859OYRIkgXth5qGECYtlAbEZR5/BE98yU/Tw3hJPc3R/ptwSH8L9/ouGfZ
1G9Db/5B8TuB0B9x6yrKCFK5eXpyCFn2czF5e+Eg3NFtuEvI88EV/VUEYY67
cn611OtEONW7MRZYYdnMY71l41f4v3gLQT4XdsX/h6I/Ldwu349msy8J+V6e
yPxTMq+k9OPIfsZFjyv+PULgNZjUKfsVs+zwPKKWx7Oe28Ku9dewI/O+Ked1
ib8Z+3/wF04Q7m4=
      "], CompressedData["
1:eJxlVgtozVEYH2nJO0nyyruJazab4Xb5bCbGNo9oWNKiTGITtiKPnIOTWB4j
sTyHvJrXxdjDzDajbRjLYzYW8pw88ihyzvn/zj3NvbVuv/t953v8vt93znon
LZ22oHlAQMA2+ae+xdh5r6pSGRWWH4r25gr6cj82qcNaRt2Ca/sFlgnqPnu+
u24jo4of0xuyKwUpGC8YPe8XuD7znqDG4yWTIjJgfyToUtnK/AOZjGqV/Ymg
m9+DEjP2M1q+s0uLmbWCvF//VKcfYfS3Ov3tgHpBc1S8k4j3AvnPWaz9r1us
/UsYJW//uHrMc0FFKn4F8tUI2qz6ecTocLQ8WYV6nzGS3uFzSxG/zvar+//A
aEY71/msckGTIuQvPxm1aT5oU+eHsDfjDn6CflsD1wnqoRJ04r76dP6eFuv+
gyxOyz/QNTjEnj+2r7hXzggbX9uJ+/I3ZEuH8ZwGJmYUfb+LfmM43VD13xB0
WfETC/tVQW1lG41x3KnrjMWzRl4sW5llsfaPs3iiShglaM+SjhsK47nDj1vQ
6FY1R1KmckpQ5yNgnwb/MPAxgzt6CQVfCYgfDD4TUY9LOHNL4nQ0xdOqZrAg
j4q/yB/r/vpjfh38sfHX8+xksc7TzeIA9enD6ZOa/xDEHwA+QgQNVcIZyJ35
DxPUk7+femUQd/QzHPFd3NGXG/N0Ib4H/Uq8QRE2zmLDr8GG/yb+p1HfYE7n
siSTXtQXhPPXBS1UfPXF+VuCNnV+XPGjK/i4DT20t1jvS0uLJyv+pX53R21Z
/KYU+/Mb+1iM+X1lTj+Fgi6q/X3HiKn6ctFvPXPi5YCPeuzbWWvX9Wb/h+Ms
1vqJRL4XuC9Gof6XiBeB/hqw71Jfstqte14zn740P++YT1/VspyET8ynLzXG
xm/MN/90tU9//bHRk/Y/5I+b6Oe0xXpfzqMeqSe1njle9DdUUFWfp7/W5DLn
3gzFPufBPhz++czhQerpgaq/gDnz9cBegPjjLDZ8Gmz0ZLDRk74P8uDvxbyu
wj8P/F+A/Rbspxh9Vr+XY14HLdb62Wux1s8O5CvDPm5Bf0ZP63Cf5mOf0tDP
Feg/1erJ4Cb7YnAk5r8M74UbfC63etFzWYH7fhjqSUd9IdDXKtQXjPt5DfK7
cL9x1vT+yfDHRh86f7g/Nv76PvFYrOcbZfPpeY239Wh9xdh6Nf+T0W8Y+I7D
ezQC85qCft3Q6xTwHWWx4dNgnX/Xf/gE+JK4Uu3jJcSPB7/X8P7I/Pr+KMB7
JevLVLgI/cRgX4thn4D3uQT7HI36SzGPSIv1PEZbrPd5FHCJ5VfjYuxvKPbn
DuzJ9v8Dox+D/wHDbR/+
      "], CompressedData["
1:eJxFlFtIVUEUhk+mJSJiJhF2QU1EKTMfQsLUZSJdJLoIkuVDSZZBlEVZhkgm
s3Phg4nZBfHS0cMxyPCW9qQHPUkpqGgmUilqUSIlFSIRXfbM/m02HPb5mJm1
1v/PWjsk6+LRbA+bzZZh/uR71lHlDp4RFJlZ1rOYyJQay0knhwQd8PXYejuG
qf1lXldtr6AFZ19qbCTTxuOn46a6sD+cSR5v7hQ0uJQ269jC9H3kYJZ/M9ZD
mGzyadQsjx+q0nwvufT8pzuCzpV/KUg04z24EFDsKhFUnxvvM76dqXcxIrPs
pqDh0Lc/C2PZehcIq449mlW8w5o3yfUMcKGgybBVRZWnwLcESXnrclBfCfgS
U4LPeH1uOfTnQ2+NoIxdphNF8OcJmJn8j5l/egT9eX19LryCadnP9zJfjeYG
qceh2Z7S8eN3J1OO1D0lSIbJczPtkAcn4PcA033px6igDdHmwgj8G0D+MZx3
aVZ+dmqevhH4dG8L4o3q+l39j1I6BrHuFCTmjzzf3A//G4QVx61Z+dON+h3Q
16b57BnzaWLqkfdVL2hI9kMj/K4TdKVivWe6qf9FcPPlnGrEs0PPQ+ivg567
mtV6mWZVbyn8tiN/Ce7XjJ8/Fx7jLRD/MZO0rahYUGu16UCTZqW/TbPS3418
LCjdL6q1+hX6o1L7p/yoQ7x3TLLtIlqQf5qtPu7T7JZ632hW8zKL/p1E/V9x
XxNMMu3CoqBiWeAY9v/CPAzi/v5CXx/TGmnMCsPy14V6VxpW/e2a1XzYNavz
2ZrV/KZBv8mqP/dh3RP7U5hkeU6Tlf9J8MPLoP1yQwLub7Vh+RXPZFb7cdjb
sOYxDt8TH6yb/Eyyr2al10+ziuuP+uLgV4Bh+bkbfgUadFXqN/OfkPUH4Xwy
7iMUnKp5+Xun7metYc3XNqZrXbVB0V7QG4p6l8R/Vvm/aVb559HfYVj/jHmP
QL9+wHxEMc1InkG/7dTfg+V6/gEpW4Nb
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/Xjp7CMKj1odNGP6D3316XSA8SMst5womwTln2t1
8ORh0m7v6nQAKdM42Oowzbk753lLp0PGxLc19rtbHe6psDVObex0mJEn1Hxg
Q6sDSPu+aqj8ylaHMD7dTXNLofJLWh3eLz/mbZ4PlV/Q6iAblWJ9P6PTgQEE
5kHNT0TwSydLsIRFIfhWIPMDOh06HROeXgDq3zQXaKJHp8MFpds/65ZB3e8E
NX8N1D6bTocOkPpNrQ4g74hZdjpkguR3IfhHFDYUZRxB8JcBvb/hYqvDgVML
XbfZI8IHFl4ANROS1w==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQfdk3SSAitc3h/fJj3uYSXQ4o/DudDu1iN89978fk
fwDxz3XC1aPzNWP6D30NR/BbXwfukPPpdGAAgXQo36XT4QpIPguq3r7TYUae
UPOB3DYH2agU6/vWnQ6Pl84+olDU5rCkwJbrumWnw7bPf69UlCP4YHXVCD5Y
fUObw78rFS/VgPrB7m6Bytt2OjysElnn3tHmcE+FrXGqA9S87jaHMD7dTXOB
7pEHOawX6h7PTgeb+/6906ci+NOcu3OeT4DybaDu74LaZ9wJsacRar4O1P+V
bQ6LXIE2qXY6ePIwabcXtDkcOLXQdZsS1P50BN/HvNMxIRHBP6KwoSgjus0h
DQRUoO4JhcqrdzpMB4WXPzQ8taHqvaH26UPVe7Q5lE6WYAkzg7rPtc3h/Pfg
x0ttoPa7QM13Q/DvgtwfjODD4tcaZJ46Jh9s7pVOh6mg8NFrc7DccqJs33Wo
f8yg9sHSjy3U/MedDluByua7QvmvoPb5tDnIgOL1E5Qf1OYQATLwT6fDdhAf
6H8vUDgydkHiK7LNYeNcYExzdUHiOx6RngGGUWAy
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQ3S5289z3a20O75cf8zaX6HJA4d/pdLC57987nbEd
g/8BxD/XCVePzteM6T/0NRzBb30duEPOp9Nh64myffNvQPkuUPnbUPX2nQ7e
5p2OCffbHGSjUqzvW3c6TM8Taj7wuM1hSYEt13XLToesPSWTJV4i+AZ3Vdga
3yL4M0DqP7Y5/LtS8VINqB8s/hUqb9vpMM25O+f5zzaHe0BtUx2g5v1tcwjj
0900F+iey75JAhH/oe7x7IT4m70dzvfkYdJuZ4LybaDu/w21z7jTYdvnv1cq
PkPN14HKv2pzWOQKlFHtdIgFatN41OZw4NRC121KUPtvIvgMIHAZwa98qWbI
cbbNIQ0EVKDuOQ6VV+908AGF10FoeGpD1e+F2qffCYmXXW0OpZMlWMLMoO7b
3uZw/nvw46U2UPu3Qc13Q/BBwTo1GMGHxS/Y/pmYfHD4XoGGz4I2B8stwIi+
DvXPCqh9wPRjDUo/66HmP+50yJj4tsZ+O5T/CmrfvjYHGVD8f4Lyj7Q5RIAM
/APlA/3vBbKHsQsSX6fbHDbOBbqEqwvijguI9AwA+pNmIA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQzae7ae57x3YHzZj+Q18duhz076qwNboj+BkT39bY
+7Q7LHLd9vmvXZdD+b75UvoB7Q48TNrtYtZdDll7SiZLhLQ7/LtS8VLNvMvh
0yXfJIGwdoc0EDBC8JcU2HJd10HwweaqI/RHWG45UaaEMB/Ml0PY7wmyUArh
vntAaqpElwPM/TD+ZaDxETYI/qGvGjH95gj9YL4xwnwguW++PsL+ZbOPKGzQ
RbgPxoe5H8aH+Q+mH+Z/mPmw8AGG2pUKc0T4gc21QYQvevgDACI2rtg=
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfeirRkx/ULvDPRW2xqkPOx1gfM2Y/kNf/RB8Tx4m
7XbnTofLvkkCEcHtDtOcu3OeW3c68Olumvs+pN0BJC1m0elgfd+/d3pYu0PJ
ZAmWMJNOh0+XgBoi2x0uKt3+WWfY6RCVAlQR0+5wF2SffqfDlhNl++bHtztY
gRi6nQ42IP2p7Q5LCmy5rut0OlTsmy+ln4fJP3hqoes21U6HwyD3iWLyYeq3
ff57pUIOwQeSiwtUoOp1oXz1docIS6ADgO65AHKnVrvD++XHvM0Nof7TaXeQ
1ge6GOifpbOPKGzQg4aPOVS9AZQPDA87kHmG7Q6hII3OCD4sPGF8cPhMRfDB
4beyE+JOoHmyoIDaCrVPv93hAMi9uzsdpucJNR+A2b8fGp667Q5TQfFxCMrX
hsbnEShfs90hc+LbGvtj0PhUg9p3HBo/ygi+t3mnY4I8gi8DMkAKyj+GCF8w
H2h+h2PC0wtC0PA63enQCeJ7ItITAFqkB2g=
      "], CompressedData["
1:eJxllGtIlEEUhlfLKKlQCPFPS0luWW66aKy37KhJVJQkJBYSIQURQRIlJhXY
hZlBSsrMpPrRDSPoYtRWm5nKtpaFXdgwixKjKKkw2kIqtpqZfb8G2h8fy7Nz
5pzzvud83/TKzaXro202W6l81K9v2uUtG7yMUioaur97Bdn3fVxx4xGjrt6T
xZ6AoI3tWxsT3zJ6PWNcXdOQoMUTo+ewUcP5sf2nq6L4P2YJA32jEzipsIRB
QSrtrHjwC0Gr1+UOliSCnwnaPuxwjbdzmqoOHgp6Uzvl4qIkTquyr96r7hI0
pDiZ0xJ14aaguHJ54OAkuxpbdsHwmar5sf3HDWs9yw1/3rFg3poiQWePScUz
eVhHrgjnTeGkwqrdgiY5r5wYmc1J2WDPRH0npydJL3/sckF/OqdXSm+aoHh1
MYNTjrze4RQkCta+e5yNflIFpcp0rYWRrP1NFqT9/8Ai2IrX/n0yrNpr/WZY
nlY0/GThfucKOlJUv+l9CPnS4XcU9GdA/xhOI63+pW43/I8B5wnKGyzZ3yz5
i+J85IuBPwsNW/5arOu1GN7bKf84j32S9bapeXmg7w/6vy3o69NllXG/WHie
d+FnkIX34z7mM2xYnw8Y1vd7Wbi/TuSX+6z1XDJs9WvxysnSyULs9y1Gp4o9
wVAO5tuO/FmCAjJ9eQej34GaYUcm9HUy2qP0uTAfH+qnIX8P/HfC3z4zL83P
I9mav9a3M5KteM11/92vN6z39SD0p0HPYeiX89dxzcifBX9bwAWGLb8sVnI9
hwyXKf/Oob4Vfw18FPFesKyn+7gj6HowFKhpYtQm19jfDb8a4Z8P+yr71/vn
x34fwDx64He9YX2fGdbv726w3/in2YfvQS38eYDzNvM9s/bD4r87cUPY
      
      "], CompressedData["
1:eJxdlXtIVEEUxhdL0wjpIRJWahGmWGiBiKh51EzMpFQ0E6nVNl+YhrhlUZsp
5QwlIqJCUWIl2h9FRdiDEN9YlFYuSpiKWIRpKYlJodHMvZ9NeGF3+TFzz/nO
d87Mbk7LiztuYzAYssRH/rpemoh9WsxoqqEr2j+T0+PuU821pxm1vqqLaDrB
KftFQeX6PEbie3miGZzFaJWNd6nzBfAxRndOBq8cYGAjowTHHY9uVCpOChCR
axXvkwEectqYbAocSUe8Vk5NMwvWwgJwD6ex+usd7sXgQU6BIwfKaioZDW+1
u1g1yvW8jYqzKr6dC3muuC8mbXXSS+gfQv5+6LVycpP1zyve789DjTb8H4sq
phpsOfXOxY/VW5HfjuvxFnkFp1sRQnkfp0yZ355TunwEB8l1wUNSz3tOne4P
8jMdOGXI9XfII7ikRRjeq1jrx2vFUkZXNydfGcgB8buwLuJr/nRy6pDxF/N3
cNL6K/Rtkj63g4V+rR/tqF/Ut8FHBG5X9d+WcduUP4tc6vyhZ+6T4mi5fxL+
PoO/04zka673FE/Lem4q1uorgz/jjHqkvxbwR6b7lQ9/exm93TL4y5KOeWjG
PBnhU+MSrlVskE810/1LRfyrWDdx2i4XLjMSXfM7chQs5s0rpbxtNhn7i6D3
EPRY8H481s8zve8HFWvzF6NY8yca8S3wJwr9K0K+vfCnhOn92gN/S6EvHP0o
Q/4wTk/keanA/lBONblrS1quMfou94ci/13EJ/jRyfR5I+zvR/wQ9H0Y/drN
Sb7mOYF8QXh/Fvn8cb7mse6LeMswT144z2L+qsOv5HxxU6zpcVrCtphfA/bP
MbLK+D8YSblNX5lezxDT53uAUZQc/DbcV2/QpzrF2n1WqljTnw+9fUzXb4Q/
w8iXyPTz/hnrsYzaZz1TyicVa3pmFFdJvT+Z3r84RrLdjr+ZPi/x0LWAeyaB
0R9r4biHDepPZrpfDuhnKvatwXlMw/o69EPcv4XNtS4+LpgfM+ZrG9d15MIf
b/QrG/enD+Yrg5FZ7t+F+8qEefVD/9MwHwGKD0u/ghVresIwjyb4GYl6MuG3
mP/Rs073I3PgrzgvZ8Y9dtqbcR5TcB/99//zF1wR/wY=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvf3z3ysVSzscNGP6D3293umw5UTZvvmzEXxv807H
hMkdDtL6d1XYrnQ6yLe+DtzR0+Hwfvkxb/MznQ6VL9UMOdo6HN7W2JvGHel0
kAPJN0H5OxB8sPoVaPzJnQ4ZE4Eq2zscpjp35zxv6nS47JskEDGhw6FksgRL
WDlUfnqHA9D2xql5nQ4MILCgw+EDSH9Wp4P1ff/e6asQfN1Nc98v34Lgt4vd
PPd9T4fDItdtn//mdjpsA/n3cIfDPZB5pVD3n+pw+Hel4qVaLdT+s1D/diL4
YPfORPDfgfy3rtNhRp5Q84ETUPfvg7pnf4fD4gJbruunoPI7oO6/DLVvAyJ8
0cMfAP1OxZA=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQvaTAlut6Q4fDwVMLXbepdjpY3/fvnV7V4aAZ03/o
q1ynA1i+tMPB42GVyDoJqHxRh8NikLhQp8MRhQ1FGfkdDkBy4lseqPrcDgdP
HibtdnYE/64KW+NUJgS/+QDQwj8dDvKtrwN3FHY4gLjbvnU4bP/890pFJdT+
jx0OciD5Nqj7XnY4yEalWN+f2eFwD2Te0w6HdrGb575vQvBlQPKnEPwLSrd/
1t3pcNAGKQTqB9v/vMPhw/Jj3uafOhyArq6x/9zhcO578OOlv6Dm/YDymTvh
/Pcg9bwI/r8rFS/VRDodvED+/NrhMFmCJYxPshPi3ndQ90t3OghGWG45AbRv
qnN3znNgeD5eOvuIwi2o+xQ6If4/2uEAMkZMEap+OTQ8FaHhNaHDASRcpgzl
I8UXAFq52fI=
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQPSNPqPlAS6fDwVMLXbcd7XRgAIGqToclBbZc1/93
Omw9UbZvfmmng2ZM/6Gv4l0OPuadjglAfvMBoAbpLoeMiW9r7IH8UD7dTXPl
EHywekUEvwWkXqvL4dMl3ySB8k4HoKhpnEGXw3SQ/UD73i8/5m1u0uVwQen2
z7q6TofW14E75Cy6HI4obCjKaO504GHSbhez6nIwuKvC1tiJ4IPN70fwwe6f
gtAPNn86wvxDXzVi+mcj7AebNxcqr43gg8NDBcGPtNxyokyyy6F833wp/Tmd
EHt5uyDhMxNqPwM0fPoQ4QkADJ6Y2g==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQLRuVYn3futPh4KmFrtuOdjqA+QZQPkOXA5/uprnv
daHiAl0OF5Ru/6zTgfKlEXywekUE/8PyY97mWl0OmRPf1tjrdToASdM4gy6H
GXlCzQcMOx3eg+RNuhwyQPKmnQ6trwN3yFl0OTCAgFWnAw+TdruYFZTvgOB3
OiY8veCK4OsAnbfcC6EfbL8fwvwjChuKMoI6HZoPAB0ItN/bHGhCSKeDtP5d
FTZtBD/CcsuJMhUEH6xevssBKLpvPky/cJfD46Wzjyj4Q9UzQNW7IMIPAMaP
jyI=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 
      1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAWIQfczbvNNxT6nDkgJbruvGHQ7HQfxDpQ4RlltOlH1p
d4jb5cnDtBnBZwCBDaUOoXy6m+b+h/LXQPnsHQ6xIPXLoep5Ohw6HBOeXphX
6tD6OnCHnEiHg2xUivX9yaUOm+a+X35MssMBbH9bqUMkSL1sh8Ohrxox/RVQ
9YpQflqpg2ZM/6GvSlD1AQg+2H4WTP49FbbGqSHtcP405+6c587tDgobijIm
spc6ePEwabdbtjtMzxNqPsAHtd+03aFaZJ37Q4lSiDv12x0uKN3+WadR6gBS
Lqbb7mBwF2iwLYIPcw86/+Cpha7bVKHhl12CwUdRX4fgT5ZgCeObiuBnTHxb
Y7+0xMETJGAAde+6Ekj4mrdDwmdLicMBkPnW7Q76IPdtL3FITwMCVwQfFh4w
Piy8wOaVIfgg5yTEovG9SxwWuW77/BcYHzNA6h2g7lPogISXEdR8YPyB3a9e
4mAFdN4+iQ6I+2Wh8oIdkPAXLnEAOS+NqwOijhcaPgwdDiBv7eMugac3sPv+
FKOmR+YSeHoFAFvqFAA=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLdR84NRC5jKHkskSLGE+7Q6Pl84+oiCA4G89UbZv
vlSZw78rFS/VvNodWl8H7pBTLnNYUmDLdd213QGsX7vM4Z4KW+NUx3YHmagU
6/v6ZQ5va+xN42wQ/A/Lj3mbmyH4YHMM2h307wI1AvVPde7Oea7V7lAtss79
oVKZA0h4qlq7w1WgtYZA+1uA1rgqtTtYbgE6iL/MgYdJu11MAWo/M4IPdNXi
gu+lcP4i122f/74phesHu+tJKdx894dVIutul8Lt9zbvdEy4Xgp3H4wPcz+M
HwFyiA1C/0Gg8dscEeZrxvQf+uqKsB+s3wvhPlj4ooc/AEp4rMg=
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQfbXipZrhhgqHuypsjVPXtzsYgBhXofzV7Q76IMbH
Cof3y495my9tdwCrZ6l0iLDccqJsTrsDAwjIVULkJ7Q75D7/vfKjVqVDxsS3
NfaNCD7YvHwE/98VoEFJ7Q4P/Hun5ylVOjQfOLXQNbTdwZbr+uICwUoHzZj+
Q1892h3ug+QZKh0OAqW32bQ7TJZgCeN7WeEAsn6fMVT96QoHHibtdjG9dgcr
kPjaCocLSrd/1mm0Q+iGCoh+1XYH94dVIuucEfyls48obHApx+CDzdOFujcC
wVfYUJQxMR/B12oXu3muvtzh/Pfgx0sN2h08QOZ3ljssKQC6zBwq318OcYcN
1LxJ5Q5pIOCG4N8DhU8ogg82n6UDzgf7S6TDIXaXJw8T0DxweMl3OJTvmy+l
317uAOJuU+5w6HRMeHqhptzBC2SAZoeDHSh8cssh8aXTAfcPjA/zLzof7H7j
Dkh861XA+dog/0Qi+NPzhJoP1FQ4ZILi26jDIQdk/jRofOhD5fdVOJSCIk4L
6t67FQ6yUSnW9xWh5n+CxocoVJ69EuJ+zg5IeALTgyeI/7sdzgf79zWC/wGU
/u5B0wNnJcT+S9Dw/FHhUAKy/3i7w6GvGjH9Lyog8bWn3WGHXOvrwAsVkPDd
Ak3fSPkBAIAbbgY=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQbct1fXHB/XKH0skSLGG72h0yJr6tsX9Z7pCeBgQ7
2x3u+/dOz/tS7nDw1ELXbTvaHXKf/175kaHC4f3yY97mQL7ihqKMibwVDpvm
AkW2tzvo31Vha5SucABRU4H8ZbOPKGzQQvCjUqzv+wci+GDz8yoczn8PfrwU
aB+fLtCkxgqHJQVAl+2Fmj+1wmGR67bPfw+2Oxz6qhHTv6TCAehK07gT7Q45
IPesq3DQjOk/9PUC1P07KxzCQAbdhJq/r8KBh0m7Xewxgl8C8u9bBP/flYqX
an+h7t9Y4RAK0s/V4eD+sEpk3fQKiP9FOxwYQKCuwkEW5BGFDoj+iAqHCMst
J8rUOiDuUUPwwfI8CD7Y/cDwBPtHpcMBFv5g9yl1OAAAyFC+7A==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQbct1fXHB/XKH98uPeZtbtjt8uuSbJPCv3CGMT3fT
XNN2hwtKt3/WyVQ4LCkAqjRud1g2+4jCBis0fhaCnzHxbY19fwWEBpp33793
et6KCgceJu12MZd2B6stJ8r2HaxwmOrcnfPcDyp/rsKh+cCpha4xCD7YPTkI
Pkh6WxnUvhMVDpvmAlU0tDuU75svpb+3wiHCEmhwV7sD0Jab5zZC9U+Bumd+
hYNsVIr1/dntDnYg/7ZWOESC1C9sdwBR+7IrHKT176qwLW93AHn7vTfUPyuh
fFUEH6xfFMEHGevPXuFw/nvw46VAvvvDKpF1v8sdSiZLsIQB+Qwg8KEc4n8g
/9BXjZj+Z9DwXdHuAAt/zZj+Q1+B9gMA3sO6cQ==
      "], CompressedData["
1:eJxFlG1I1EEQxg+xPkhJRElUipqJZiZ+CAnfRuXQkrISJMXCJMtCzSKz3d4w
s/GoNLEyEFNPz5cPhqWZRngiZmZxiSUilS9ESIRJhURU0n9359yD4/jd7s7M
8+zM+mSe3J/lYjKZUo2v+G2qHvBuj+UQmF7evxCNUNhbuz7Ek8OuFS5BGIqQ
MMPXPFjGYb55MDEsEGHs3Bf/0L9M7fdHCEKPCcccA8ev5E+2TQj9CwHp5ZO0
7oMwlXSzKs+huXKda4r7Y81GVEtMHYPjFXMXoo14K4Mf1cyXM2jIj3Qb34bg
3X46u+IygxHf978vhSEY/zbkFzLYmHYkfCpWs4y3V7OnWE8lPs9g0m950Z3D
xMUMhDyPbKqvjPgUgjiWVM+UfkZ6nzFI3dE5dLaI/BkntiCYxMeVw+I7Y2Ml
gtPPjyLffc2NQo9Ns9Xc9fPfE4Tc2T+t3yM4HBDxBqi+UPL7FYK78GMzhw0h
RsRR8m8tV/nHEHLE+UW2xNLPb5plnmmm4r3V9fcN15u7HLT+mkHJ133dXsPk
/wsGd+Ou58wOaJb+2Kn+Iab0dWg+dtT4tCH4iPt6zuCN6IcW0mNncEYUbujP
FvfcQ/GspOchU/rrSE+TZrleo1nWe5spv43zNpG/jO7XiC/7pJTityJEifwl
DAwVzYNtmqX+Ds1Sv53yVTBIEca/pP5o0f5JP+wU7wPCvbzVxX3TlH+G7tON
L7HUG6RZzouZq/6dJP/S6D4nEHq8jEpOcCgWBY7R/gKu5sFB93eRK32D1H9X
uPK3j+q9ylX9nZrlfFg1y/NZmuX8JpP+EurPBFq/RvvNCKLMXqR+j6H+tHDY
KTZEkf4b1L+RCD9Gd2euusXVPIYjxIv3pJLWnVyleYvQW61ZtH1RLdUXTn5Z
yc8IhG7hVwuHAlF4FNXfQefjqJ5+4kTNzvdO3o+N5msrgiUm4/NIKen1pfcv
V7PMn6FZ5k8h//2oH/fQvAcgHHxqOBPP1XwEIxwSHMdVv23X74Gznv9U/oun

      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQvWz2EYUNTlUOmjH9h776tDvA+BGWW06UTYLypaoc
PHmYtNu72h1m5Ak1H2Cocpjm3J3zvKXdIff575Ufv1Q63FNha5za2O7Aq7tp
7vv7lQ4g7fuqofIXKh3C+IASpVD545UO75cf8zbPb3fIAcnvq3SQjUqxvp/R
7vDAv3d63q5KiPmJCH7pZAmWsCgE3wpkfkC7w6dLvkkCByodgKYuP+bR7mDL
dX1xwelKiPudoOZfg9pnA1X/pNIB5B0xS6j7PiH4GRPf1tizV8H5QPLmOcUq
hwOnFrpus0eEDyy8AOfamq8=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQnfv898qPEVUOPEza7WIGHQ7T84SaD6Qg+B2OCU8v
5FU5aMb0H/qq2+FQvm++lH55lcPBUwtdt2l2OLg/rBJZV1/lEGm55USZaocD
n+6mue+bqxxKJkuwhCkg+KUgvhSavAhCf8bEtzX2/AjzwfZzI+yf6tyd85wN
4b4lBbZc11k6HGDuR+H7IPjLZh9R2OCE0H+14qWaoRXCfA+Q/YYI++24ri8u
0EW4D8aHuR9FXgGhH+Z/mPmw8IHZDws/mPtg4Yse/gDmLadL
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQfbXipZrhmUoHHibtdjGDDocdcq2vA28g+Ie/asT0
P6p00IzpP/RVt8Mh9/nvlR9fVTocPLXQdZtmh4Mt1/XFBZ8rHSItt5woU+1w
cH9YJbLue6VDyWQJljAFBL8UxJdCkxdB6M+Y+LbGnh9hPth+7g6HB/690/OA
9k917s55zoZw35ICoE6WDoels48obDiD4C8D8Q8g+PdB+rch9PPpbpr7fi3C
fDuQ/UsR9pfvmy+lvxDhPhgf5n4UeaD/olKs7/svRfjfA+S/tYjwYQCBbYjw
A4f3AUT4ooc/ALj5q6w=
      "], CompressedData["
1:eJxdkmtIVFEQxy8SRRYFZdGHCpOQojdRkiE7GYvEBtFGZlEZPUgozQ8isecQ
PYihDyEWYRCbWNqyICXbaha1mehi+8GslAJLWyQqYlstoof0uHPvHw544XL4
MXNm/vM/s+jgCf+RDMuyCuxfzvOft7cvnKNpesYynnuMqaw2pT3TNN3wtn37
42ey5PupqGRDtKeamHx5FzYdGASvZWq61pXdElO0RQrkMh3/MB4eu67cetlM
I5KgDbf2VMfq/YaHt12sq1ipKBJMh+JLmGad60g0zFQ0Gor78vKZyqXeaIB2
zlgRCfqYZks8GSBH9yHDTxIN3rbThneLviD6fQ249aNMUeEsRR2SH2eqq7A7
rldULPVfM8m1WKmiocWTz1xJQk+N4YLMVzcr7xp29PUpaqy0I28w70dFVZfn
TSp+CT//If6USWXdLkpmalq6t6bz+2PDjv7WCdzCtOqt3WiKdvU1I25pd74w
0xftWbf/t3LPW+g3hn6N8OO9YSmTHjDs6E1AbwjcCW7G/UeK/vaf/JR7B34+
UNSXM/jrlO2n8w73kf8Q/t1DfhfTO3nfiHLzEsgP4317kV8PfoH5LilKC/dj
vrOG5+85vHH4qOHnosPeJ5HpfYb8QuX60416y7Gv7ZgvR7k+hQw7ftQadvZT
Yz/s+wukbxnihehfgn3Yhf0vYkpJ/yrEPeh/dQJHDA/YNq2x/e/9sWOkaTNT
QOJD2K+tTKvl/VOI++HXuKJ8OffhfaZqV385039SpdTO
      "], CompressedData["
1:eJxllG1IU1EYx4eEUFQEkYSZqc31orfNt2at9EnxwwoTexURKashZNNMrA/n
RJFxrkhIiPYhRExH1CeVWlI0zESWoZkpEWl+kJCIEBORiKJ7znnuTmyD7fLb
ee7//M//ee5NrKg+diHKYrGcNL782h9/+3uxn8CusubBZdDB5LqWzatONTHg
l/UbKbwa6SzwP2Xguz+U0GOj0Nu+8HA4wGCO/5FOYTzp86/rQwxKz7tmi7Io
dNUcXPNxmIHx21XjpODhnyCDweWdZc3ZFLbYZ6zRI4oHuP5bxQ38jzEm/eyl
4F4blcLGGaSwmE9jaRRK9j0J1k8wyOH6GvIk1hv+vlijb7ZOIcdR6OZ+/mPD
/RHnNIPGQ2e+jj+PZLPeqO6P9yk9kUcLhbb8pqr5D+i3AesNfz8nCis21FPY
b9gJjGI+Hgq3+HmCqH8C/Q5gXiuYd6ta58eNKWWgc/ainpvBD5KbVX4D88xl
kNBTW3m3EetdDKaufbOltaGfTNTvxPsdqP8Y+7MH+9NL4T3vn4bne4n3pzJI
5PqjkSzmIVnlGc5mvdmPBwX+pT+pmKeGfjT040D/dgazRXfueTNxnhyq/4LT
FYv6rDDOZnBp/vejRQfud0DtL/zks4j5NlnM31HFcTy4PAbrtL72hWcklK/I
8wXe72TAj9ERIDC2cnzOl4Hrr4mc7zTkN0T22455vyOwlS+Y558moXxE/SIJ
5Weyma/otzOSzXrR/8OKxfyV4POtod5ZIufdyLeK5+VBPcPv1UBHrP0i+snA
efbi+Z3ItUTOnwu5DvXzFAu9wrD1JcUin9W6nIcrRD5Pm3Tp7zKBGf68xeoy
r2rMe5su578K15N0qVeJ61Zd5nqOwN9JIwgb1pej/x26zOu0YlFfrFjs50a/
yfg+zMH52K6H8ha8G/fvVu/Pf+dwYfM=
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQ7fGwSmTd0zqHD8uPeZtbtTtotYvdPHe5zkEzpv/Q
V4N2hwf+vdPzDtU5tBw4tdBVq93Bluv64oKNUPVq7Q73QfIL6hz+Xal4qabU
7vDpkm+SQF+dAw+TdruYAlR/FYJ/+KtGTH8Qgm+55UTZPv06hzQQ0Gh34NPd
NPe9IFTest0BaEun45daByuQOs92BzuQ/U9rIfbFI/glkyVYwioR/AtKt3/W
TYaa97XWIQJk0ep2h5znv1d+FKtzeA9y/8F2B16QvDnUv9faHY6D7Euqc1hS
APTpQ6j+qQg+2H/bEPxls48obLhQ53AQGDzb7rQ7wMITbN8lBB/sny8I/jTn
7pznHB0OS0H6n0D1i3ZAzHsE1S8F5T+oc2gGhb98h4PBXRW2xrt1DiBqqlKH
Q/m++VL6N+sg/lfpcFjkuu3z3ytQ+9Q6IOF7Huo/IB8cfycRfHB8HEKT31nn
IBuVYn1ftQPi/7V1DiDrtylD3bMCytfqgIS3aD1EvwNUvzomH+yevHY4//z3
4MdLI6DpR6Me4h9vaHrRqndYDApfN6i8Tj0kvp3aHRQ2FGVM1K93kAG5zw4a
P8ZQ+2yg6i3qHVpfB+6Qs253UASpt62Hp2+w/c4IPtj/Xgg+OH5D6iHhaQ1N
H/H1DvdA7rOFmp8Cda8ZVP47Ij2jxDeQDwA4zIlf
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7fGwSmTd0zqH98uPeZt7tDvA+B9A/GXtDlcrXqoZ
PoHKr293sOW6vrjgfp1DGghsh/Kv1zksLgCy9kH55+scSidLsIQda3fodEx4
euFInYNmTP+hr6fbHdxB5m+vczhwaqHrtvPtDheVbv+sW1Xn4MnDpN1+GWr/
3DqHSMstJ8qutjuU75svpT8RwdduF7t5rhLBX+S67fPfFKj7LrQ7LJt9RGFD
UJ3DQZD5R6HmW9U5yEalWN8Huve+f+/0PL06h3Pfgx8vXYzgg6wX60TwMye+
rbHPa3f4dMk3ScAKal4k1H+BdQ4RIPu92x1yn/9e+TEDar9tu0PcLqBPmqHm
mUH9Ox/B1wK5fzuCD/YfMLxaXwfukLNBhD8sPgCJP8X5
      "], CompressedData["
1:eJxFVGtIlEEUXRYxECl7YGEpvjBNzQpEbDOvyaLb9jAN07IoSTOIXpQ9aUYs
LlIgJZYVallmBoaoWflDxczUYDXLSirLJCojhEKkH0XzuDofLPsdZubOOeee
+wVkH0jNsVoslkzxk/+j1dc7/UM4hGUVd0zEIzhjihJ2zuWw1tMajssRmrrz
WytncBiv6XLGhCEs2rrb9tFK+0No/yQD12TaaHUQgqr3jen1AASLfN4arOq1
GhyO3kOuWgZ7L/48HS/qRX0Idi+4yuDWwTiPN0sRzv3Y9MiviEF/4Ls/Z2IQ
quzNv/9ypnmsMVjVSzHYV65nEj7LYFiULd1F+AIDKc87j/iVET6EcGre/aSR
e0zrP4GwUhJ+yiAzVrwUIJTtn1PY/olwEYJXhnhx5/Dv1fHvISWkX/gpZZRW
GHxb6qk2WPF4iJAndQdxkGXyOxGWyYO+5PdzhCvyvvkcFkpjBhCkrI2zuL5/
kM67GbxE+jnJpvGTidCs4jGm6700/Nt7b9qbXQgdcv010z73kv8vGFxOPL/v
a6fByp82hGey4QNM62s0eE+ueOqoX30M+mQe7pLf3QyOlCxwSxf6RVq+9HdQ
vSqEBzIPLUzrv4G6z/UGq7zcMVjxrWDab3G+S95fRv0V9X8NrM/2ukT1axG2
tzg8rcUMGsqFA3UGK/2NBivebcTnGoP0mZEN5T2Ujwbjn/Kjh+q9R3jsJ06O
0f0jqHPswadxp3/94Twfg2X76xdznd9hysMK6t8Qgrx2PJZDoSQ4SPvjuZ4H
F81bItf6uhBmS2PsXPvbTnyTuObfZLCajyqD1fkcg9X8plG+kiifybSeTPvt
CJJeTTLlPYHy5ODgkBtWUx6dlN846vc6rufRRv3cQOs28jvFYKU31WBVdzPx
s5Ff6eTnKvIrg8NRqV/cv03y30HnE6kfuYSdBk9971R/ttB8RSAca630iXKQ
3kDiazNY3R9tsLo/ivwPpvUImvdQhJGT4oMSyvV8RCJ8lljMv8pbtPkeTPH5
DwIVe2I=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/Xjp7CMKag0OmjH9h776tDvA+BGWW06UTYLyhRoc
PHmYtNu72h1AyjRYGxymOXfnPG9pd7igdPtn3b96h3sqbI1TG9sd9O8CGS/r
HUDa91W3O1wEyd+qdwjj0900txQqf7He4f3yY97m+VD9J+odZKNSrO9ntDsw
gMCReoj5iQh+6WQJlrAoBN8KZH5Au4Nw84FTC0/WO2yaCzTRo91hkeu2z3+v
1EPc7wQ1/wHUPhuo+rf1DiDviFlC5f8g+EcUNhRlcDTA+cuA3t8g2uAA1OW6
zR4RPrDwAgC3NpGL
      "], CompressedData["
1:eJxllHtIVEEUxjeJsAgpMREzNVOxh6llWK7VKYsIe1CBWGSEFJhIRWkPezBX
zbkRISHlHxEWZmJRSqYZiWgtWhaSaFmJihmJlKlpSEHQnZnvOogLy93fndnz
+M43szDl2O7Dbg6HI9n6iif3/tQyXsZo8f78F7/JJJu7gmcY159zCrj0fVdN
DaM1T16dqnvDKSHm8oaDLkbitf8Hrva/ZVTffGdz9WdOVda2oveMcsSLHk5H
rg2eX9/NqFvE6+VUfHztrI5vmlPF+ojmZKuMsL+I180prmfn1cJphqrvIyeH
+Mw0VPw2Tu+COv9c9DAos8BnemIzp7TajAIfT4Nmuy3l3nWcwh/fGir1MlT8
KtQ7z6D5EVaH9zQniQbzNct8OzRbVa46EM/Jb98hZ4839juhj49BQ6WNCTEx
nM4OhEa5+yJ+NKfeLK9HW/wMahV1RnGqHv3XfibAUPpGcBKyFgUZFCt+hGM9
zKC7QqdlyB85lRuEPiGc2ranzEnqYFPY3u8U+nVqlvp8ZZPjDWCey7nqYxDx
IjltFUIOM9X/SvT/i030K59j4DjM3+KfYv86rvJYnOhhTWKTZltfm239bZb5
ijnNFQujWK+A3iPwRzUnf8FDiFfLyRVYcSL1B/I1IF4/+nFBnz5GC0QfTZxu
xF9J7+9itFfEfw29OjRLvVo1fxHzbEb+JvT/Ev27wLWMhO0a61F/JfR+xifO
V4bwa7nmSX4rQ78b4Y/7jFrG9/SVxGL9Ac6npf82cR4f4vxEY72cKf+tgD6V
iB+BeT5F/5bf+kpuugLrtB+k/5qmsu0vGT99Ktv7pf8zNct5nNP+knoy7a/C
o5459dm6XllXLlN1RiN/HvRdjfgm+nFivib2x2ue5C+L5X0wplnO3d1UfjBR
zzwwh/6+JrULzsN9FmCqeeZC/yBT6ZuNeQabyp8M+UJxn15APRbLfrI0y/+f
1iz7PIn5hJgT+kq/LTJpWKyngZcg3219f/8HPNbDEg==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQPc25O+d5faODZkz/oa8OHQ4ofL92ON+Th0m73bnd
Qb71deCOBqi8dbvDEYUNRRlNjQ7vlx/zNrdod/h0yTdJoAWq3qTdwfq+f+/0
tkaHg6cWum4zbHeofKlmyNHV6HAAxNdvd/ACqettdNg0F2iCbrtDu9jNc98n
NzosKbDluq7T7nAUZP5cTD7YPFWo+5wx+TD1USlAF/gg+GD7g6DqdaH80EaH
CMstJ8qA7snaUzJZIgLqH6B7t33+e6UiqtFBWv+uChvQPyBva8RA/W8OtS8W
ER4CIIPiGh1C+XQ3zXVG8GHhCeOD7f+C4DeDAoSzwyEa5F4gH2yuaAfEv0Dz
gbY3TpXqgLgHaD/QlSxh8h2Q8IqCyitB4y8CKq/S4TAVxA9rdAAFs5haByQ8
QqDuAfLB/glE8HVBEeGL4IPDwbPRQRakUbUDHr7g+FPugMSzA5SvBbWvDJGe
AKb1EH4=
      "], CompressedData["
1:eJxTTMoPSmViYGDQAWIQLRuVYn1/d6PDkgJbrusP2xxg/LsqbI1TX7U5ePEw
abefbHQAUWLv2xweL519ROEKlP+tzWHLibJ9829D1f9vcyjfN19K/zFUnrPd
gQEEnjc6/LtS8VJNGME/eGqh6zZZBP/Pyo+XfBXaHXzMOx0TnjU63PfvnZ6n
1A6x7ynUPJV2iPlPGh1KJkuwhKm2OzysElnnDrRPM6b/0FdVqP5HCD7YPw8Q
fN1Nc98vv9vocP578OOlQPNm5Ak1H7gBlVdsdziisKEo4xrUfUD3THPuznl+
GWo/kJ8x8W2N/UUEfzpI/ykEHxxeRxsdpPWBIQJ0/1ZQ+ByEhi/QfsEIyy0n
9jY6WIECTrMdHt5g/foIPli9KYIP9q8N1H/7GiHucmx38AbxD0PD3w3KP9EI
cad3uwPQlMUF5xod7oHkfaHuuYrgg827h+DHAoNB4xnUfZ7Q+HkLdZ9TuwNQ
9dMLnxsd0kDAChoe3xsdgIGw0NUAwQdxtykj+CDn84m1O1xQuv2z7hPUP7D0
8RJq/982B1CwNd6H+v9jG8T9F6DyL9oc0NMrAF9iLgo=
      "], CompressedData["
1:eJxlk1tIFHEUxhepHqI7ImHl1mKk1bZEoWZYn5SErV0UCksfQiqionwIixKr
s8kZCVlCbCEpyU2EAinzEl3WdYsQH8IHIyIsJLpQyEIhURA0Z+Zsf6KBYeZj
znzznd85s6zmZMWhNI/HU2ifci2a+Spa20ao3NA7XLfaQkrfqrXv1lk4HWvP
DMwN/adT9Zukfnro3/d/Gb+y/KbiA98Iya7nwfxcC/sPbny3a5IQH7lZ0u+z
8L6z7dnSL1qfZeHpVE51+DPhyJXJ+s3pRs9KW8UZ04zOrQ4nps7zX71njr/n
+jFGlfh/JDR+LX+QVcWwv/5hdEL9d7KbZ5ywRIIUM7xS+JLQuuXy8U95DEvq
Rwhvs2dcbPUzOOP1ix+DhJAEzmZEhUMPYVyee9ntN2r0bDtG8qrRRx+falnY
TNg2cTa928eQmMlG5ZvDiJxYEIo3EDpK+r//XsMu33OERQHbIc9op98io0sF
yFZ2feoJ+6S/Un1+gTAkfMsYo743Pxsuab+7GX3DdbH2JvWrYCSEX9hoh1eL
0TbN5kiEsF2+V679XdP52TzHdtTMq7yh9UFGr/h3mHyOX5fyL2Aslhy3leda
5d2tef2a577Rzn4MGG1TGjvzUPsJ6Pyf6H6t13nGCXsFdIHuQ4JwWA4Y7cwn
aHRqv1K6UBqZr/s9RJD4sUwLEufuoNZ7Lbf/mPrb++zkf6T9Ldd9H1BeKyyX
/z1yOay0XL53zP/izK/T6D8386hA
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQDQauzQ4lkyVYwnzaHTImvq2x90bwLyjd/lkX0Ozw
70rFSzWvdocZeULNB0KaHZYU2HJdd213AOuPbHa4p8LWONWx3eHx0tlHFKKb
HYCmmMbZIPgflh/zNjdD8FtfB+6QM2h34NPdNPd9RLPDVOfunOda7Q5bT5Tt
mw80/y7IPLV2h4dVIuvcgfa3HDi10FWp3eHTJd8kAaD7eJi028UUoPa7Ivhg
c+wQ/GVA6zZYIvT7mHc6JpgizK98qWbIYYiwXyYqxfq+HsJ9MD7M/TB+hOWW
E2U2CP0HgcZvc0SYrxnTf+irK8J+sH4vhPtg4Yse/gBPHKA3
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQfURhQ1GGfIvDwVMLXbeptjtMde7Oeb6t2UEzpv/Q
V44OOP+eClvj1BCE/DQQ7dzusGw20IQdzQ5ePEza7ZbtDg+rRNa572l2iLTc
cqLMtN2hfN98Kf2DzQ6yUSnW9/XbHdrFbp77fqLZAaRcTLfdQWfT3PfLLyP4
IGs17mLyYe4D8+sx+TD1ghFAizsQfLD9UxB8sPvmNDt4ggQM2h0qX6oZcixs
dgBpKzNvd+DTBTpocbPDAZD51u0OR0Hhs7TZIT0NCFwRfFh4wPhg81k74PxF
rts+/xXocPh0yTdJYEmzQxjIYEmo/EJo+Mp1OABdH9M/v9lhIzAYjil1QPwz
B6pfFcqfDrVPo8MhFsSf1Ozw70rFSzVtKL8L6n6dDnh4oPOXFNhyXTfugIT3
aQQf5N3lui0Q9QntEPP6WlDV38Lkw8wHh+dFBB+cHo4i+OB0sbcF4h+g+8Hx
s6MFEl5A/4LN3Qo1X7bDAZwet7RA/CeC4MPCF8aHhT+MD0uPH5Yf8zbf1gJP
j2DxnS3w9NjhmPD0wr4WeHq0vu/fO/1YC2r6uNiCmj5vYfJh6Q9sfjomH6Ye
HN+FCD44/dcg+Fl7SiZLtLbA0yM4fDpb4OkRHJ49LfD0CIsfWHqE8WHhAePD
8i/YPaoI9wEAeRPAUw==
      "], CompressedData["
1:eJxFlGtIVEEYhk0qw25KZRfT0mRT0hV/mJi3z2SptLCSZHezKNG0kDJJc9UK
cadJJCzECsIua2b9MCLF+hEpYUsZbOKFkMqQiJAIwS4mkTUz511mYTk8Z875
5n3fb74Tln9ib6Gvj4+PTfzldcci303cyigqr/H5zzROgdbErpcWRpnyfhwn
x4QpbsEWRpPt7qyEKE7jVcsfbIvH8yZOx56ealplZuSZzvnUtoFT9/e/w5Um
rIdx6lv/sKw4VPM69nXPk0DN9oKkj9l+jI5e/laTJurJ25H/nNRamuL/1syJ
B416pn85aSD83czZBE7NGQ0lX6actFa+uFWzqrdbc4hct3G6IvmHk8Yi5tc2
Hwb/dpK0F1QMfbPgk5zuyH394N8BvysY2UQsFbWcAmQ+4eB6Tqef3VwTm8ho
drhywtTEyZvnB7nfDc2qbptml0Uk9ZhTzKOWyfZ9jGTZij7oy0berzkdkHlk
MgqOFRUHkV869h/hFC3f36x5v8zTrLntunC4EfWGtP7e/tuWbg+nu3I9hJEs
G9qP/IOZoaNPs8qnB/qD4a9Tc9ER8etAv1YzeiPPwz30I4iROCVzc4X/+vRD
nweWoZ6LU6jceCn834Iff83K7zzNSu8c5O3C/rPor6gvUm4t/YN+3keeM06S
Zd0dmpX/Ts3Kfw/0iPOXu0R05hXOx0Kdn8pjJTPqveckKK9R5Kv2H0c/kzUr
vzs1q3mxM+P8jkF/Afo1ymloV36AtYRRnRQ4gufLmDEPHsxnOfJz4/xVIt9e
Ti+kXgcz9HdpVvPh0qzeL9Ss5jcHeTtwPrfDfxWet3CaGhQCq5F/OvKoYYaP
VPg/g7xSuHE9x4x5TML3pBbrXq7TrPwyzYtlwfPQl4S8LiDPZOTVwKhc+k+F
/kt4PwN6roGzNHu/d6o/9ZivaE5iei5erYbfcOg7rlntX6R5WO6fj/wjsH4Q
8x6J+bNjPmJwfq2Yt3j9PfDq+Q9ZDnqX
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7cnDpN0e0eqgGdN/6KtPuwOMH2G55UTZJCjfpRVC
d7U7HPqqEdNv3uowzbk753lLu4Puprnvlxu2OtxTYWuc2tjuADJGQ73VAaR9
X3W7gw5IXr7VIYwPqLIUKi/d6vB++TFv83yovFirg2xUivX9jHaHIwobijJE
oOYnIvilkyVYwqIQfCuQ+QHtEHPEWx1AxhzzaIfok4G63wlqvhLUPhuoes1W
B5B3xCyh7jdA8DscE55esELws/aUTJbwaHU4cGqh6zZ7RPjAwgsAfxuJnw==

      "], CompressedData["
1:eJxlk2tIVFEQxxeL6IXYEiWYZWJRVKaFiYj6701YUUJRIRFSYRAlUUEhQdi5
Q/RBIrY+9CK22oiQzXysu+RjWW+RXyyhoLJFK0pklR4GUkF37pk6pBeW5Xdn
7pz//GfO/IqjZQeSPB7PGufH/+/vXI1lvFV4lzXprK+P8B+HCKX551fvG1S4
vPbC4U89hFMDC3Mn/xyTP836x0VTX/mrvIa7M9+Mnkm1cPxS6sSdcULlxUR1
SboFf5WT+Zrw9cWWipRMCwf5eSn5WRZq2p/dWv/c8K6Chqcnuwyf47hNuHLE
W9PufO/q65D68yyc4PNaCY76j91pFvjz1jCB5QZnW1hcXhsdcfqbs2d/Ydxr
uP/0zLqNyYZdfVMsXTci9SdYuM362wg5vU6jv5XWH5P4qALLa7JF7w/Dbr3v
hovZry8KQ9UleXs7CSzz5pDEo4S7rPez0n48JmyanrSE+pX2s8HMy9UTMOzG
txk+xLo2EDbzPHsVdiQvq79eTEjn/uMKu9mgAkIjn9+n9Ps8gpM1HPigtE8r
CB5+BpSeRw6hMyN4rDKhkLbcMSJb5vFN9CyV/F/juYP7WyD93hjPf/NdHQHD
bv06peefLX4/UhgO2KX5uYToyKLy2iaFBPu5kvRehBQeOm3Yq0j7EBb9hQQf
x8NyfpHUiyiowe2huesMu/PYatj1yzcmfp+QwoXD4n+z6G8Rjsj9aZF9aZP7
0izzj8q8GqWfmOxnveixxb+gAq/BrCeyXw8Mx3ge9wzPYD1+Ydv463JM5n1N
zusSf3vM/f4DMsbyTw==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQffirRkx/SpvD++XHvM0lOhxQ+HfaHcr3zZfS78fk
fwDxz7XD1aPzNWP6D30NR/BbXwfukPNph6hLg/JdoPKZUPX27Q7tYjfPfc9p
c5CNSrG+b93ucNk3SSCisM1hSYEt13XLdoels48obChD8LP2lEyWqEbwwerr
2xz+Xal4qQbUDxRdXNAMlbdtd9C/q8LW2N7mcA9ITXWAmtfV5hDGp7tpLtA9
IOp9D9Q9nu0OnY4JTy9MQfAfgzRMgPJtoO7vhNpn3O7w6RLQAY1Q83Wg8hVt
Dotct33+q9ruMD1PqPlAfpvDgVMLXbcpQe1PQ/Bt7vv3Tk9A8LecKNs3P6rN
IQ0EVKDuCYHKq0PDyw8antpQ9V5Q+/Sh6t3bHEonS7CEmUHd59rmcP578OOl
NlD7naHmuyH4oGCaGozgw+K3A2SeGiYfHL5XoOGj1+ZgCXLIdah/TKH2wdKP
LdT8x+0QfS5Q/iuofd5tDjKg+P/U7rAMxA9sc4gAGfgHygf634uHSbudsQMS
XxFtDhvnAlMoVwckvuMQ6RkAYDFgTw==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQPc25O+f5/TaHeypsjVMftjvA+Jox/Ye++iH4njxM
2u3O7Q7yra8Ddzxog4hbtzscUdhQlPGozQEkLWbR7gDSpvGkzaFksgRLmEm7
g86mue+XP2tzuKh0+2edIdS8l20Od0H26bc7vF9+zNv8bZuD1ZYTZft02x3K
982X0v/c5rCkwJbruk67g2CE5ZYTvzH5B08tdN2mCrVvMSYfpv7TJd8kgTUI
fuVLNUOOTVD1ulD+1jYHkLFlQPdk7QG6fEcbxF1A94L9vavNQVof6GKgfx5W
iaxz3wMNH3Oo+n1QvjXUvP1tDqF8upvmOiP4sPCE8cHhMxXBB4ffynYHoCsX
FwDNk41Ksb6/FWrf3jaHAyD37m53uAz0TgTM/v3tDlNB4Ql0H5g+BA3fHdD4
PAKV39bmkDnxbY39MWj4bIHad7zdQRcUPxsQ/Haxm+e+r0Hwt33+e6ViBZR/
DBG+YP4RaPwvgIbXaSj/OiI9AQCb6xj0
      "], {{734.613, 775.323}, {
      727.2700000000001, 766.73}, {726.4259999999999, 766.73}, {729.035, 
      775.323}}, CompressedData["
1:eJxllG1Ik1EUx4dEiEVJVIywkeaWketpVMy09JhJ5npBQXuzCEkyiLIozYjA
TI4hNXSYRS/SixlFWeKWCa051uztg4UhFCXSh5CIReGHPhTde/k/XGiD8fC7
z7nnnP//nC218lBpVYLFYikVX/lUnyKmxRXe8OQA0469OWNbdjENvrpeGBhh
un05suDhYabP6VMb2seZvnSJgybN9RMOV6JXc3gyo8LbwTQ9YQnPHWPqODir
MXQN/IHpQkHLga9d4PdMfS9qg533mObLwm/w7GHavkq8GWRKkdzLVCwvPGHy
uM/m7+ljOuqzTim/r/lWzZqk0SualZ7Nmr+fzFu5u4Bp/MTsB+v9TBtkvhzo
ecy0TdZz47yfqelbSb9tBeoLX96mffx9yoX4INMnqddg2ijziz6zpRAnk3Dr
SPUQ+slkqm4VlYfjWflrZ1L+18azGX9R+leveb+8f1qzlJnRjH6XMhmysRbk
W8bULv0+D/3Lob+VKdYd9bjd8L8NvJqpLtg5z/Ax/ZCci3w++LNOs+mvyare
Jc1nQuLgLvZJ1Dsm5xWAvnPo/ymTs/dqrLsZ83wOPxuwHy/hd51mNc99mjPl
/a3oL4T8RdDTo9ns1+SyGaLyWuy34BuFgV9/slGvGPmzmGRYzMP0d+T4hEPs
w7DcA5GnUepzYT4lqG8gfxn8cMLfnXpefslV8WzOX+mbFs9mvOKZ/923alb7
aoN+A3rSoF/MPzdp9GaNHfmz8H4ROF+z6ZfJUm6gTXO5NOYO9DkQ70c/dsQP
gNPxu3rG9PPdpsrkhUyPxNiiYfiVCv8i2Fcb9i+K/U7BPIbgt1Wzuj9Hs6qT
DI5q/xRHwInw5zU4T/9/mfth8j/uajBN
      "], {{764.414, 754.0419999999999}, {
      777.2890000000001, 754.0419999999999}, {777.2890000000001, 750.277}, {
      764.414, 750.277}}, CompressedData["
1:eJxlVG1Ik1EUHhaS1Q9Nk0ibH+hS0zk/1nBTPEVDzFxYWBJiMUpUKCOsrKQI
i3tuEBERCywsP5o/ZEwJKShZISOKRGggFU3I/kiWQYQJlb33vWdezBfGy7P3
3HOe5znn3DR3675jUQaD4aD2E2+W+G58vpbD+qhtLNGOoON6Ds9fPXCOfGYQ
+b4Muzhk19948XOBwZZDRx1TTg49zpEff2IQjFe/1Dy2c+g7WbZ2MgHh0csz
o905HNpubVp9IIPyb6R6uQgpIv43LuE9Nr7jyHuF57zBKlsAoa5Ey2RE+C6w
j/5fRe9uhM6ARnCWyfoelPwmFNbjhhT+2lFubfAwyBu+N+e9i5LvJQaOqb3X
PQ8RPmZEX77dwqBUYD9K/rUU/wzBLoQ5mTz3hs47GBjEE0bpRwHl+0Z68ggv
KmwRhWL4Em55qlWK53Ba1DMzeFvtjq1LJj8tVD+TQ6N4ihjkCmzm8DfUPmOy
UbyN8pX+h68pPD6/f7pf0//pfIKvYjuHShFwn0mfiqnffUz6XchlnwcYnJsx
FazJ55CUrxEfJD+1/sq+MNk/E5f98jPwnNjQGTByCAs/h8iv+JVY5/eEgeZa
qL1jJY7E6/iswtP9XWOpxxXW+TVyELSMPuLv5lKXl0mdhzlcEfPSQ98b6Pwd
hSN+RbCuR/M3Wfjgonz5pK+c/M8mPRaa90yah3QOu0XCNOp3HJfzlUL9WMQl
LMY267XCOt9emm8L6UeU/akh/W0IQ9oYBFtoP5sRBN1RprCub0BhnV+A5qcV
pV+TNH8XaH9maf61erruaJT8uqjeZoReoXeY+GShzBckvsUo+xHG5ffLL4Vj
hbFR6v7R52kdh6ab2oaWEI4nv2wIcSI+ie4bK+31Vg4T6R8WLhZSfmtkn+g+
KePQLPLlIISE3ztpn7Job3cpPJbqP9VUobCuv5LqZaPsVxX1N5f8qKZ9MqOs
4yL+RSj33aX0/QO17WdQ
      "], CompressedData["
1:eJxFlGtIVFEUhScLiV5YiJmaqQ2TVmb+iCHGxzaRHhI9BNEoKMmyiF5UaEQg
EodzI6JM7YFmppmBIilTieUU01CGU+RIiaWJQUiFQcXgD6PzWHIGZi7f3HP3
XmudfW580bGdxSE2m61QfOU19sL3HY+DnJJ2X37xN5MRixj0B79y2jIvZBVL
ZTTR7Mt1DnJ9TWLk/j0VKA1gvYPR6Nnwto19nPzBvLGm5YySH9ZONL/E/XhG
aSPbLtU8NVydffHIt3bD7xKGJs/f43Toys9zmaJeYGtRWEEdp7vH0+d8WMNo
j1iWWM31Oiejw92nKiOvcorZtd81ssGwqrfd8FJ5vxB8jdOwPbS8ah/4Oidp
L6IE+mrBJxiVjTtSZzfDfxn8dnIqXN/56kw58nkO5oxynTxr70dO/wKl445K
RtN5fpb96gw3Sj9NhhtyROVHTP//h1OBrOeFvgnk/YZRv8xjnFN0iqj4Hvl9
Qf8BPD9geK1s3GdY5eRDvX6j39N7J8ftZzqnbk5SVmwv8u/iuo/XsMqnB/q7
4K/D8MED4tPKSG5D4hNOb+U83IcfNyfxOytf+LfJTwfqNTCqkn3a4L8efloM
Kx2NhpXeeuQtnl8m+9dif0V9serZ7Zuo34L+NzjJsfS1Glb+Owwr/z3QI+Yv
f4GY5NeMXHI+Hpj8VB5u1PvEqOboogqPD/1HoX/IsPL7w7A6L5OY32HkN9PS
+zXIaLMUPteiCilwAOsXWvo8+LF/4Zb258P8LbZ0vh7Mc6Sl9XcaVuejwbB6
vtiwOr95yFuwms9NuL8E63OYPqdRls4/C/MZbWndGfAfY+m80hl549pPlsRa
et9ceJ/E4b7gX/KaYFj5tRsea7rljXNAnwt5rbB0nmnIa6VFp6X/DOhPwfPZ
0OME5xqeft+p/Umy9PlazShMDloU/CZA73zDqn+oYfWemIH87ZjHKZz3RMzr
JM5HMjiIeVtn3gfTev4D+4yIKg==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQLdf6OnDH904HzZj+Q1992h1g/AjLLSfKJkH5jzsd
PHmYtNu72h2m5wk1H7jW6TDNuTvneUu7w5ICW67rFzod7qmwNU5tbHe44psk
EHGs0wGkfV91u8NikPy+TocwPt1Nc0uh8rs6Hd4vP+Ztng/Vv7XTQTYqxfp+
RruD9X3/3umboeYnIvilkyVYwqIQfCuQ+QHtDkcUNhRlbOt02DQXaKJHu0PW
npLJEnug7neCmn8Qap8NVP2JTgeQd8QsofLnEXwGELiF4D+sElnn/rzT4cCp
ha7b7BHhAwsvAJzxklU=
      "], CompressedData["
1:eJxlk39ozHEYx68lSRLSUhgKJTMbjdY5e2e4P9aMy9bdJX8shISE/LhiHT16
WH6sYxktvzqtqK25WzZnd86RldIWUVzLH5Jmf0j+Uj7P5x59Yt/69unV83yf
5/28n893QdOBwM4ij8ezzrxyDtU1TQueZHxaOLE5NkL4h3sJ3nx9yzVmXK05
v+/LEGHP5dFI9XWXPyz5nY6Xdd8ci3c5Ljn7bUtvknG4ddaExjwh8eP38LF+
xp2DvsnvPhBGTsx86E8zdsnzVvOfMaIDr25teOM4WNXz8uig4zMSzxGo+P3r
X2nVl9b6KcYR6ZciHP+6uGJSH0M+Tz0mxCQvwViy7WLmp5lvb79R1u24/KMR
/sCx1XefsVvm7tP6txl3Rf9TwjzRc0P1ZzXexhB5iZzGY45tvVbH1q9LjO+R
6srtz6lQt0XjGSrMRerHE0Lb/hnRgWb1s8fty34Xd2zjmx3bvW0krJF9RhgN
U03ntTr/KUZIDKrS/qcZc8M7vPlKKpxRxhw5VxDG4rna1ed0H+WER8bWjguM
2cuNcWW6jyuqp1Tz28dzWuZbpP184/lvvtXnd2zr1+n+y9TvABfqVhCmi7AG
xqj4uZLw+V57dn6Q0WVszq0iJCU/pPq9Gg9rf5/WMyxrK1nv2O5jk2PrV+y/
eCfBI09Y/U+q/pCyuT/2HgX1vpj7Uyr7b9T9Z3RfW3WerH4fUD059a+eMaVo
KRW/0P+h1rFc8w6/Y6unRjnn/LWcVfZqv0H195D7f/8A9fL4Ew==
      "], CompressedData["
1:eJxdkm1Ik1EUxx8kQqQXqYgKjBVhCysFCc1lO2EyaitoolltFmvBojeJsIgR
hcSp534QCSuIIZU2AimRKX4IM1tD/WDDBIXeEAmRqEmxoqDo3uf5w4UeeLj8
OOeee87/f9aFzvlP5BiGUSl/dd49u6x58KSgRTlFvPIU081dxz6lw4IeVPd9
/+NnujjQvqb4iKD67YnhJmIqOBx2ffSBS5n2qIs7hX0WMm3uiWXiW1HPwRRp
/RJ1F2hOr3/760qu5qSj+3zkh0nqWsrJZKhv1qT5eMpbVoF6kybVLtnSE/Mi
njbp+ucD/WuPa34xer+676rmQ6q/GN6bQv0EU8n7DQuvzZk0qPJTTENZZ6Dl
t0l1qv4U07fxfaH8pYI+yLS2adTbqPl2lTg9W67Z6s8jqKOxMm/yHeatEXTh
1qoFdW+Ybig9GxAfYeodbhpol/puCrQMZZ9rtvrv/Y+7mRbLtjIhYffXxZRQ
8aPCnu8xk7dMOhYQ9DXq3tbwCP4dxHsd6N+vOSifde7VbPW7G/3GwQTuwn3p
79+JS3OFT6HnDmGfUs87an9cyH8G/VzIT8JfqZfl1yjyS4Xt7xjyi8HjmN8p
KKN4AvM5NM903ks6lmuWUzxslPvUrAx9jXwD+rxCvaxp72s/5ps37TOu2dKj
VbO1n1Gml2o/5H1r7yOIG3i/nqlN7UMe9t/D5FPvr0bcDb+KNFv9lGuevrzi
iUfqP/azZqazCvn7sV8+JmV7phZxP/QKCqpQiUH4E4afZ5j+AeGmunk=
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQnbWnZLLE4W6HeypsjVMftjvA+Jox/Ye++iH4njxM
2u3O7Q7TnLtzngP5YNq63cHmvn/v9KPdDiBpMYt2h8u+SQIRx7sdgLpYwkza
HZYU2HJdP9ntcFHp9s86Q6h5Z7sd7oLs0293OKKwoSjjQreD1ZYTZft02x18
zDsdE651Q/TptDu0i9089/0eJv/gqYWu21TbHa6A7GvD5MPUZ0x8W2Pfj+C/
X37M23wqVL0ulD+j2yHCEugAoHseVomsc5/dDREHule+9XXgjrndDtL6QBcD
/bPt898rFfOh4WMOVb8QygeGxweQvkXdDqF8upvmOiP4sPCE8cHhMxXBB4ff
ynaHrcBgmA80TzYqxfr+Vqh9C7odDoDcu7sdEg8w+/dDw3Net8NUUHwcgvLn
QOPzCJQ/q9shExQOx6DxMx1q33Fo/ExG8EHGakxA8HU2zX2/vBvKP4YIXzAf
aL41KP6boeF1GsrfhUhPABxUGLA=
      "], {{891.012, 775.323}, {883.668, 
      766.73}, {882.824, 766.73}, {885.434, 775.323}}, CompressedData["
1:eJxFlGtIlFEQhhcTCZGyEJEs75iiVhYhtaljYhelixmikl0sU0MqoxaV8pLJ
QfbYBTF/hF22xPphRJr2I1JiETPYIpWQShF/hEQYRIiE0jnne5dZ2F0ezndm
5n1n5ossuXCk1MdmsxWqr/4fO1ASWFAsKf7YrXd/0wXZpw+1dmRLyg7wSRDJ
gh5fTPX/kiZpvns4JyVe0Lk3l9tCduL5WEHtmc7KH1sleRbyZruiBc3UBj3f
m4DzSGHdi2ber+MGM8923XNHBEiquPPrarqKJ4InPQsrpJV3k6A1BTv6Rv45
6VPU18W6FEFhzT9zXy84aX3RGfv0bmYT7zDzBn1eKChc86KTpmL8GttPgZec
ZMooR30qn+EqQUkvO+e7A6C/BnrXSSpUZTga4c9GcIsgm/4of5bHq+di2wR5
/fyu891nfqL1dDG7svr/LA0IUr/j1UWStEyHG/Udhd8f4MdBSaGbVcTP8G8P
8k/gvp3Z+LmN2fiWiHhjXP/Q6KOsfg/OoyTptGGjyBcu6a7uq5vZ+DOI+iOg
r5e57Kz69AgK1ELCJH3U8/AU/QiVpFz0zVf6X4043j4IQTwX9ARB/0PoWc1s
zv2ZTb1+8NuF/Kp/pr8qfrmeIxviP0P+ZSfptg73MBv9vcxG/yDy+UrKX6Um
4T3mI5D9M34oPSbeN0E5KS0ZJxORf0bQgK4/g9nozWU2+3JcWvM7hfor0K9J
QXqM46okNekCJ/C8A/vgQf9qoW8Y83cN/g4J+q3rrEP9fcxmP1zM5n4ps9nf
POivw3zug/56PJ8lrL2qh/8Z8KNBWvfS0L/r8CtVUM1cbPLKG9K6ZxfWHjTj
3MuC2cxdC3PH+bVNQ07UZ4dfrfBzF/y6LemK1q/ym71tx/1M9KMTnMPsfd/1
6f7cxH4lCnJHvLhU3gC9UXj/XWI2+SuZTf4y+B+D89PY9zhBOmzjCexHkqAt
mouxb9v5feCt5z9mRYSC
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQfdk3SSAitsdBM6b/0FefdgcYP8Jyy4mySVC+Z4+D
Jw+TdntXu4O3eadjgk2PwzTn7pznLe0O2z7/vVJh1uNwT4WtcWpju0O72M1z
37V7HEDa91VD5VV6HML4dDfNLYXKy/c4vF9+zNs8Hyov3eMgG5VifT+jHSIu
CTU/EcEvnSzBEhaF4FuBzA9od6h8qWbIIdPjsGkuUMaj3UG+9XXgDkWo+52g
5qtD7bOBqtfrcQB5R8yy3WE7SN4UwQcZO98ewQe7w6fH4cCpha7b7BHhAwsv
ALYskhI=
      "]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxFlH0sllEYxqWmrcxaH9ZKQmaEzB9mJdzIJGsqm6WslVFsFbW+O8dmdSZr
ZqaPtVbqlbClWSSthbA3US8jNQkzw1qTycyqsZ5znut1bO/st/NxX9d17vvx
TMs+kOHo4OCQYvzk/5L1y5Jd8jj5pRa1zEYK8qg5m1l8mNMeZ0f//GBBv3v2
pq3axWmqwpoQ6ieoddY3tWgH9vsI6rv0wyc4gJNtLmm0fIugUxP/qqbdsO4p
qCDq6Fi3s+bwFV/LcmbYIte1X2gsHWKUVTzJIo37GtzFz/02RmU5xs5tglwC
XzyYesuo22vgT26oIP98137bS0Zuh9LDhqM1q/v2ad4k11PArxkNeTvl3T4G
fsdI2nPNhL6P4DOC4kaurH0+zEz/l+H3L6OU7YbSPEGeMp913OQCQb9YZMiR
aE4Ln40gSgTZ8xyU9R5qfiL9lGu2xNbPzL8SJGUmXuV0UN7XJmir1JeNvDuR
RzqnjUHGjT3ILwn1+3A+XLPKM0BzQqjhcDPu69X6mzsex9bbsL6Sk1Glwb0D
9Zw43Ym5eXKiTbPKpwn6l8NfreYTx42/arzXUk5dsh8qkfc8o3Nyo+F/9TWj
8hzytsDPFDP9P4KfMc1qfUCz0tvLzLwtqP8J72vcb7xe3IgV91chz1ZGhqoK
a7Vm5b9Ws/LfhHpdjJKlkQ+Cbsj+GGeL+ak8FnDfd2GeM/JV9UegP17zGuk3
S7Oal+vc7N8h6L+H9+oX9PR+m0dNJSd5LLYP++u4OQ82zOcbvIdV0KTsv2Zu
5tuMfm7hpv46zWo+LJrV+QzNan6T4L8V/bkb623YHytotNwQaEW/RyGPdk7x
ckME/Hei38IFDScW3j1t4+Y8huF70oN1O3/RrPx+06zODUJfGPIaQZ47BUk5
NeOczsuFCOifxvkY6FmSa3KCZvv3TvXjKOYrQNDFxtINQe/h1wv6nmlW9Us1
q/q3kL831gsx777oV4H5CATnYd5C9PfAruc/us+AHA==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQPVmCJYyvsdZBM6b/0FefVgcYP8Jyy4mySVB+ZK2D
Jw+TdntXq0Pr68Adcva1DtOcu3Oet7Q6RKVY3/c3rnW4p8LWOLWx1WGHHFCF
XK0DSPu+aqg8f61DGJ/uprmlUHm2Wof3y495m+dD5f/WOMiCGBmtDp2OCU8v
/KiBmJ+I4JeCHBKF4FuBzA9odbjv3zs971+Nw6a5QBM9Wh2028VunuOEut8J
ar4o1D6bVocHIPVKtQ4g74hZQuUNEXzh5gOnFroi+FcrXqoZJtQ6gES32SPC
BxZeAE7zias=
      "], CompressedData["
1:eJxllG1I01EUxseIsIgVUqMiV0lvy9aUGrNpduayqChJyF7QkFFRH3r5YBIV
9xJ2UyEYvUiGSSSFEZQoOUyopq7ZG2FhREmJ9AIhURR+KCq69+75d6kNxvbb
Pfec8zzn/Dc7vL9kp91ms5XIt/rUr1pG7rJIz2iXoI77VXcutjPqfnipKDog
aJ2/LlgxyOjNnLHH6ocF9akf7Pwvf322PjzJaViMbOx0zec0wZ5V4xwSlP1a
HvjArwQtrHG+fBICPxe0+9SnoyuKOWVs25E39FjQspuygc2ctqov3YICiss5
rVUXbglq2JdeHavgVHlm6pjS64YvH1g+/sUFw1rPBsOyim97SFDv6IKySJjT
GpUvT1BC6dnFaYuq5xek0jr28KSOpai/l9PTzMHvLAfxlZyUrHov8h/myTiP
oNpgxfv+E+hnkaB+da8hlbW/cwVp/9+xFLbivarQCPv3/k/DnS7ZaRr6XSyo
vEsqm4j82YKylN9ToH8J9E/n9LlFKvHD/wxwvkjGuTh9UVyAfDPhz0rDlr8W
63rnDR+PyR+uYZ9kvYPK2Cj0pcOP24LU2IvHYZ734OcPltyPB/D7g+Fz6jxh
WN9vYcn+Ysgv91nraTVs9WvxJoenvakQ+13HqLko+u1XAPVOIn+uoBmqQITR
74FDH+fJfdBxZxlVK305mE8j6nuRvxnz9MDfVjMvzb2pbM1f63OkshWv2fnf
fbdhvYc+6PdCTz70y/kfmXxj9XAh8ufifBU4aNjyy2IlN3racKny7yrqFyG+
AxxCfBc4yJLP211Bb680xmcVMGprkh32wK8A/ItjX2X/ev8S2O9szKMPfrsN
6/uZhvXzOw2cMP5pjmO/0uDPI5xXmf83az8s/gOo/CQm
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQbct1fXFBTIPDh+XHvM2tWh3076qwNQY3OGjG9B/6
atDq0OGY8PSCV4NDy4FTC121Wh2iU6zv+ztB1au1OnSC5C0bHP5dqXipptTq
sPVE2b75Bg0OPEza7WIKUP1qCL5MFNAAIQR/++e/VyoYGxzSQECj1aH1deAO
uaf1EHnLVgew+47XO1htARrs2eoAoubvqIfYF4/gl0yWYAmrRPAvKN3+WTcZ
at7JeocIS6DM6laHx0tnH1F4Ve/wHuT+g60Oh79qxPSzQv17rdVBDqRBqsFh
SQHQ5odQeRMEH+w/FwSfT3fT3PeBDQ4HgcGz7Q7UvcDwBNt3CcEH++cLgj/N
uTvnOUcbRH80VL9omwMviB8F1S8FlY9scGgGhb98m8Nl3ySBiIgGB1A0TVVq
c6jYN19KP6wB4n+VNoesPUBWCNQ+tTZI+AZC/Qfkg+PPD8EHx4cXmrxbg4Ms
SFy1DeJ/hwYHkPXblKHusYXytdocQMr8S6D6HaD8Wkw+2D15rXD++e/Bj5dG
QNNPLdQ/3tD0UtfgsBgUvm5Q+Xpo+nJqdfAxB4o0NkDcbdfqcAjkvmaofTZQ
9a0NkHi3bnXwBqnvQKRvsP3dCD7YnD4EH5x+JkPD0xoa/zMbHO6B3GcLNX82
1L1mUPlURHpGiW8gHwCywYM1
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQbct1fXFBTIPD++XHvM09Wh1g/A8g/rJWh6Wzjyhs
iIbKr291iEqxvu8f2eCQBgLbofzQBofFBUCd+6D8wAaH0skSLGHHWh0YQMCn
wUEzpv/Q19OtDnYg810bHA6cWui67XwrRJ9dg4MnD5N2+2Wo/RYNDpGWW06U
XW11qNg3X0rfCMG/oHT7Z50agp+1p2SyhAzUfRdaHXh1N819L9TgcBBk/lGo
+WwNDrIghwHd2+mY8PQCQ4PDue/Bj5cuRvBB1ot1IviZE9/W2Oe1OgBt2Tef
DWpeZKtDNMh/QPMjQPZ7tzp8uuSbJCAHtd8W6h5tqHlmUP9aIvgGd1XYGl0R
/HKQ/4Dh1fo6cIecDSL8YfEBAOb/tSo=
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQfUHp9s+6fY0Od1XYGqeub3WI6T/0VeMilL8ayr/f
6PB++TFv86WtDmD1LxodIiy3nCib0+pwVGFDUcZXqPyEVgfZqBTr+78bHTIm
vq2xb0TwweblI/j/rlS8VEtqdQCasm/+90aH5gOnFrqGtjo8Xjr7iML7RgdN
kMUeUPlnjQ4HgdLbbFodeHU3zX1/q9EBZP0+Y6j6M40OPEza7WJ6rQ4Pq0TW
ue9thLhTo9VBB6h8+TKoftVWiLs6EPwZeULNBzgw+WDzdFsdZEDuFULwK/bN
l9KXQ/CjgdL+ao0O578HP15qADVfu9FhSYEt13VzqLwe1D02UP/rNzqkgYAb
gn8PFD6hCD7YfJY2ON8K5F+RNodpzt05z3Wh4SXf5sAAAlqNDiDuNuU2h07H
hKcXVBodvEAGaLZBwkcWGl86bXD/wPgw/6Lzwe43bnMwAEVcLYIP0u4/GcEX
BGlc0uiQCfK3EdS9G6Hu14fKH210KJ0swRKmBXXv1UaIOsU2B32Q+feh4S8K
lX8FdT9nGyQ8genBE8T/3Qrng/37GsH/AEp/96Dp4TXU/kvQ+HvU6FACsv94
qwNIesMtaHztaXUApu6Y/nPQ8N0CTd9I+QEAj9Fjew==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/Xjp7CMKYY0OpZMlWMJ2tTpUvlQz5IhudEhPA4Kd
rQ5bT5Ttm5/Q6HDw1ELXbTtaHWSiUqzvpzU6vF9+zNscyC/fN19KP7fRYdNc
oMj2VoeY/kNfNUoaHe6qsDVOBfKn5wk1H6hG8D9d8k0S6EfwwebPbXQ4/z34
8VKgfd7mnY4JyxsdlhTYcl3fCzV/Y6PDItdtn/8ebHVYBnTuhh2NDm9r7E3j
TrQ6yILcs7fRQRNk8QWo+w83OoTx6W6aexNq/tFGBx4m7Xaxxwh+Cci/bxH8
f1cqXqr9hbp/f6NDKEg/V5tD5kSgTZug/hdtcziqsKEoY2kjxF6FNoctIP2T
Gh0iLIEstTaIeCWCDzY/B8EHuz8B6h+VNgdY+IPdp9TmAADvksI1
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/Xjp7CMKYY0O75cf8za3bHWw47q+uCC10SGMT3fT
XNNWByD5fnlJo8OSAluu68atDtPzhJoPNKPxZyP4lS/VDDnWNTpkTHxbYw80
b8uJsn3zdzU68DBpt4u5tDo8rBJZ53680WGqc3fOc79Wh60g+bONDs0HTi10
jUHwwe7JQfBB0tvKoPadanQAOetYQ6sDAwgcbXSIsATa1NXqEJVifd9/P1T/
FKh7tjU6yIIkZrc6gP27stEhEqR+IdQ9cxodpPXvqrAtb3XwNu90TOiB+mdl
q4MPiF+J4IP1FyL4ny75JglkNTqc/x78eCmQD/Z3SqNDyWQJljAg/4jChqKM
OKj/gfxlQO0bIqHhuwJqHjD8NWP6D30F2g8AGnK6jQ==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQbX3fv3e6W5NDyWQJljCfVoclBbZc130Q/Kw9QFZQ
k8O/KxUv1bxaHa74JglEhDVB1Lm2OoD1RzU53FNha5zq2Oog3/o6cEdMk8Pb
GnvTOBsE/8PyY97mZgg+iJIzaHXw5GHSbgfqn+rcnfNcqxWiDmj+XZB5aq0O
slEp1vcDmxxaDpxa6KrU6qC7ae775UD3gbSJKUDtd0PwLyjd/lnngOA/rBJZ
526N0N8udvPcdzOE+VtOlO2bb4Swf9vnv1cqDBDug/Fh7ofxIyyBOm0Q+g8C
jd/miDBfM6b/0FdXhP1g/V4I98HCFz38AepPscQ=
      "], CompressedData["
1:eJxlVHtI01EUXhJmIsMes5jOPRprawpaoJhJx8I/yqKHoBIVIWYmYQ/ElELw
d++uVERUlEFFRIl/RCG1VkGIhcWI6EGDkEgJ6SEVFiEy0Oo+zs+L22CMb+ee
c7/zfedcd93B7XtTLBZLFf+K36bHLeeX1lC4eags/f0qBiauLQlHW/MQb9V4
U/GJ8j0bKYz3Pq8sDjLoyhp6NVlB4cmL6xURP4P70db+a+UUfom4j8GDP9Ox
tjIKbz0f4h1uxCUUPnpTOy/YGWSKwkUULq4/deCrjUHpyJbT3Ssp3BB80pni
lUeBs5hbHQ/BGhH/RFS+E/GQxpLvFaL4vQypOrt1PDf0fdvDGo0jgs88ou75
F1L85hAYFvFMBvl3r473ThvwRvC3ox5Thoo7GDxz9R1pjBuqnofBAtHPhAF0
gAvC+5c8fhuz9flhzOg3KPK/GDP6yv6Hk7Hpj8TrSBI2z8v/yzTubl5IBoo0
fre5LrO2kEDOjvrSkRVM6ZdPQNCNLGfKhwCBDRkpwS4v9usn8HqyarTHpbEI
Z+VoLPVZwsAiPkHkl4F8CvD8FPrTgHzq0Z9zRPn7OaTm6aQ+L/lRoubJyuCS
6KeTgEPwX8wgLPTsQP521PsYYifOWzvme7D/o3ifF/m14H3crwJh5GHsh/u1
68zTCX8zgf1nfx5fy/WSfJswP4j1GjHf1Lde623OXyKetW/RZGyel3oMaCz7
eZQQv6f9lPPcp/1sH/MVpt3Wfkp+t3A/XBqb+pk4sJM3vohBTOA7BP7G2sZ8
aRgPY/+TIVXnm/ZTzmO23le5H24Kq4VR8zHfS1U9m8Zyf7ITcC6DSvHeLKOw
r4F/zPeD15N6835kX04K4vp+7t9oz+VBl4NCtZVvLvdP+m7H9ymAcRtVeUHM
t+r3TeqXmoxNf/4Dy/RJ3w==
      "], CompressedData["
1:eJxFlG1IVEEUhheJCImwiIi+UBNRyswfIWHqMZFMKzPN2jRQydSQ1DLT0EB2
hrAiKSkDMWttMQlN1DSC1HSzUlrXr+zDNJMKiRIKiX4U3Zl95VxY7j7MzDnn
feec65WeeyDDzWQymY2fes/Yqu2eTYL8Uyp65sMlxQaXR6RWC4pZ6rbpQpCk
theFnbUVgubq+2KD/SWtO3IsZOoi9vtKUsebLYIcvxNmbBsl/Rzem+5RgnUv
SSb1FDCr43GZzDciL+V8TRGUffV7SbgR7+bJFZbuREF1eaHu41sk9c77pVTs
EeT0fv/nfLB0vaOFq46dzDrefub1at0MjhE06bO47HoaeJ8gJW9VFupLBOdL
CnMfr8s7Cv3F0HtCkHm74UQZ/CkCl0vyOGz8uSLo32jRrG+lpAU/P6h8t5jv
Kj02ZmtU+6+/HZKylO77glSYQrukreqgDX4PSKpSftQKWhtoLAzDvyrkH8P5
y8zaTwvz9LmVTbtKEW+E6+/uvxPV7sD6aUHyW/yjDf3wP0+44tiZtT9dqD8f
+lqZM48bT6OkHnVfuYIGVT/cg985ggoqVy9KMvQ/82w+lZWNeFboyYD+29CT
yqzXk5l1vYfgtxX5E3G/RvziWd+gJfGI3yBJ2VYWJ6ilxnCgkVnrb2XW+ruQ
76CgpGUBLTUv0R9p7J/2IwfxJiSptvMrRf5p6erja8x2pdfKrOflAfp3EvU/
xn29laTSzj0VZFEFjmH/c8yDA/c3AH19kpYrY17B327UO4j625j1fFiZ9fkM
Zj2/CdA/iP6MxroT+6MkqfLqnfA/An4MCdqtNoTh/kbgV6gko9rPzlHMYwi+
J6+xbvBDxW+Ytd53zDruBOoLgV+T8HMH/Poo6IzSb+RPVvV/wflI3McPcCzz
wvdO388U5muzpLOdtWsCh6DXG/X2Muv8T5h1/g7474P1Nsy7H/q1GfMRIOmT
4ib02zb+HizU8x/EwIV0
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/Xjp7CMK61ocNGP6D331aXWA8SMst5womwTlz2px
8ORh0m7vanUAKdPobXGY5tyd87yl1SFj4tsa+/YWh3sqbI1TG1sdZuQJNR+o
aXEAad9XDZUvbXEI49PdNLcUKl/Q4vB++TFv83yofE6Lg2xUivX9jFYHBhDI
gpqfiOCXTpZgCYtC8K1A5ge0OnQ6Jjy9ANS/aS7QRI9WhwtKt3/WFUHd7wQ1
vwJqn02rQwdIfV2LA8g7YpatDpkg+TYE/4jChqKMCQj+MqD3N8xtcThwaqHr
NntE+MDCCwBh7o5j
      "], CompressedData["
1:eJxlk21I01EUxscwGWJzH0KCylQsksyyWMuWekxLRDNNihUhYi+s6FXMN0QI
dxCRiAjrQ4RExaAPUWEqlTNl/pOEKIyioob1ISR8oRfCD0b33J66pH/Y/vx2
7j33Oc9zl1R1ctchu81m26o+8l7OX8p6M5g+pESf7Rhj+o97mVrj3zz7SUyX
8tqPfR5luj9cG+osnbO+0nDD+MoMh9/w0Uc1FxefYFLfUXsiTNdPZcW8rsb7
LVPavatTwTqmw/K8wvpGppbHT69te2HYl9k1XDtiOCB1i2l0R5XLVw99A0w3
pG8N0xk5L8Q0lHin2n+aSbaHHjCNNS66XXCcKXX/+cEfar7ub7Mv6/2Gl+07
6I0cMKz1VTD5L0w05TxEfx/e/dBTDv1hzFXCJPK6LdSLDa+RfoWGtV8FTJNN
Oe6KIaapoFXkyUd9kOmj6M2GH31Mn25eCSdugp9dJi+tJ2hY10sNHxH925Hn
eqbdTqVE9e2R+d1Me8WgTJzvgQ9u7NvMtFRY7fNGdp67nI081jHZ5MljWrL2
fUp0OvIohJ40pi2yvmw+D8h8K3De98A8/rte65s1rPtHIf909HVgn5pTYlsV
yzQhfm5gep78bqbZyXRX2W5txPo46Pei7oKeLNQVi20J+YZ1HiWGtV8dc+q3
mIo8bbmVLvjfg/sVB1b3R65hpxP3pR/5L0T+Ku8EOTgG84Sx3wE9FvxbwBRr
X90a/wT3y25Y5/Er8I+LRc8M2DL+alb9p4W/Bv78PgJ/U83/9zc3BOF2
      
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQXflSzZCDrc3hw/Jj3uZWrQ5Ze0omS/xtddCM6T/0
1aDV4YjChqKML60OLQdOLXTVanWY5tyd8/x1K0S9GlT+cavDvysVL9WUoOK3
Wh14mLTbxRSg8hcQ/G2f/16p2IPgf7rkmySwutUhDQQ0Wh1A1mrMgcpbtjpE
pVjf9+9tdbDacqJsnyfU/laoffEIPtDVLGGVCP4Fpds/6ya3OsSCzOtrdYiw
BBoAtEdn09z3y+e1OrwHufMg1L71UP9eg9p3pNVhSYEt1/WHUP33EHyw/94h
+J4gh/5udTgIDJ5td1odYOEJtu8Sgg/2zxcEH+xOjjYHL5AEaxtEv2gbxDwW
qH4pKJ+5zaEZFP7ybQ58ukAPMLY53FVha5yq1OYgCFL4H+p/lTaHZbOBIf4X
Gn5qbZDw/Q31nxrU3u8IPjg+vqDJv291kAUFhGobxP+vWh1A1m9ThrrnOZSv
BVUv2wbR79DmMBXEV8Pkg92T1wrnn/8e/HhpBDR9qEP94w3la7Q5LAaFr1ur
w1EQX7MNEt9OrQ7tYjfPfQfaKwNynx00/nSh9tlA9eu3ObS+DtwhZw1Vb4hI
32D3miD4YP9bIPjgdGHbBglPa6j5zm0O90Dus4W6xxXqXjOoPH8bPD2jxDeQ
DwC4uYRA
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQXflSzZCDrc3h/fJj3uYerQ4w/gcQf1mrw8MqkXXu
rFD59a0OU527c54ztTmkgcB2KP9fq8PiAluu6/ug/F+tDqWTJVjCjrU62Nz3
753+tdVBM6b/0NfTUPPftzocOLXQddv5VgegrsUFL1odPHmYtNsvQ+UftTpE
Wm45UXa11UEwAsi4jeBn7SmZLHEBwV82+4jChqOtEPddgJqzp9XhIMj8o1Dz
N7Q6yEalWN8HuheouihjVavDue/Bj5cuRvBB2sQ6EfzMiW9r7POg5m6AmhfZ
6jAN5L/drQ4gZ5V5tzrobJr7fvlxqDpbqHuuQM0zg/rnMYIPdv97BF8AZBAw
vFpfB+6Qs0GEPyw+AOWVwaw=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQbXPfv3d6QZtDhOWWE2XTWx0uKN3+WQfkv62xN42r
aXXI2lMyWaK8zaH1deAOufRWh8u+SQIRLW0OB04tdN0W3uqgu2nu++UT2xya
QQIerQ4Pq0TWuS9sc7inwtY41aHV4f3yY97mmxH8x0tnH1HYj+Ab3AUyTrY5
yEalWN93bnW4AjL/EtQ9Xq0OMf2HvmrcbnOQ1gcqDGx1sAa59xHUvphWB7D7
X7RB7MlpdZADOfQdlJ/R6tAudvPc99dQ/WGtEHsetzlEgsx3bXXY9vnvlYpr
UPvMWh0qX6oZcgDd48nDpN2u3uqQMREYEjvaHEBcMQVoeCxB8GNB7utD8L3N
Ox0TqtscwviAIaMBdU92m8NBUHhZQv0f0+awERhsx7yg4RnS5mAFtH5fIoIP
CpapdWjyc6H8GKh926D8HKj641B+DVT+ZqvDEYUNRRkT2hyWFNhyXX8IDa8V
CD7YP3sRfHD4nIXqvw0Nv1vQ+DoLdf8LqPwBRHiDw3cdgg9LTwBdQRK0
      "], {{
      718.0740000000001, 692.37}, {728.637, 692.37}, {728.5509999999999, 
      693.8389999999999}, {728.379, 694.87}, {728.121, 695.4639999999999}, {
      727.7030000000001, 696.39}, {727.082, 697.12}, {726.262, 
      697.6519999999999}, {725.438, 698.1830000000001}, {724.5780000000001, 
      698.448}, {723.6840000000001, 698.448}, {722.309, 698.448}, {
      721.0740000000001, 697.909}, {719.98, 696.8389999999999}, {718.895, 
      695.777}, {718.262, 694.2840000000001}, {718.0740000000001, 
      692.37}}, CompressedData["
1:eJxTTMoPSmViYGBQA2IQHZ1ifd/frd1BM6b/0FeHNgcUvl8rnO/Jw6Td7tzq
8Hjp7CMK7lB561aHTseEpxc82h3eLz/mbW7R6rDt898rFV5Q9SatDgwg4Nvu
cPDUQtdthq0OtlzXFxcEtDscAPH1Wx34dDfNfR/c7gAklx/TbXXwMQeaGNXu
sKQAqFIHan4yJh9snirUfVyYfJh6udbXgTuEEHyw/RJQ9bpQvnS7Q4TllhNl
QPdcULr9s04O6h+ge2WjgAYqtDtI699VYQP659BXjZh+Jaj/zVsdQNL+Kojw
KN83X0pftd0hFOQxZwQfFp4wPtj+Lwh+MyhAONsc5EHuBZo3zbk757loG8S/
yu0OQNsbp0q1OciALATaXzJZgiVMvg0SXopQeaU2iHvkofIqUL5suwMoOsTU
2iDhIQV1D5AP9o84gv/pkm+SgAiCDwyVffP52yHhoNoGD19w/Cm3OfCC4o8N
yteC2meLSE8AeCgDTw==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQPc25O+f59nYHzZj+Q18d2hxQ+H6tcL4nD5N2u3Or
g3zr68AdO6Dy1q0ORxQ2FGXsand4v/yYt7lFq8OnS75JAnug6k1aHazv+/dO
39fucPDUQtdthq0OlS/VDDkOtTscAPH1Wx28QOqOtjtsmgs0QbfVoV3s5rnv
p9sdlhTYcl3XaXU4CjL/KiYfbJ4q1H3VmHyY+qgUoAtaEHyw/V1Q9bpQfm+7
Q4TllhNlQPdk7SmZLDEB6h+ge7d9/nulYlK7g7T+XRU2oH9A3taYAvW/OdS+
qYjwEAAZNK3dIZRPd9NcZwQfFp4wPtj+Lwh+MyhAONscokHuBfLB5oq2QfwL
NB9oe+NUqTaIe4D2A13JEibfBgmvSVB5JWj8TYDKq7Q5TAXx+9odQMEsptYG
CY8eqHuAfLB/OhF8XVBEtCL44HBobHeQBWlUbYOHLzj+lNsg8VwB5WtB7VuH
SE8AV5oZZg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQDQaCHQ4lkyVYwnxaHTImvq2xF0fwLyjd/lkn0+Hw
70rFSzWvVocZeULNBxQ6HJYU2HJdd211AOtX7XC4p8LWONWx1eHx0tlHFNQ7
HICmmMbZIPgflh/zNjdD8FtfB+6QM2h14NPdNPe9SofDVOfunOdarQ5bT5Tt
mw80/y7IPLVWh4dVIuvcgfa3HDi10FWp1eHTJd8kAaD7eJi028UUoPYLIvhg
c7gQ/GVA6zawIvT7mHc6JjAizK98qWbI8bcdbr9MVIr1/V/tcPfB+DD3w/gR
lltOlNkg9B8EGr/NEWG+Zkz/oa+uCPvB+r0Q7oOFL3r4AwCZzqBp
      "]}]}, 
   {Thickness[0.0032812502293197952`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}], 
    JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{1425.762, 925.4832050000005}, {
     2094.047, 925.4832050000005}, {2129.5, 925.4832050000005}, {2158.047, 
     896.9402050000003}, {2158.047, 861.4832050000005}, {2158.047, 
     765.4832050000005}, {2158.047, 730.0262050000003}, {2129.5, 
     701.4832050000005}, {2094.047, 701.4832050000005}, {1425.762, 
     701.4832050000005}, {1390.305, 701.4832050000005}, {1361.762, 
     730.0262050000003}, {1361.762, 765.4832050000005}, {1361.762, 
     861.4832050000005}, {1361.762, 896.9402050000003}, {1390.305, 
     925.4832050000005}, {1425.762, 925.4832050000005}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxlVG1Ik1EUHhIhEeGPsEBL+mSaWhqiJsJBkYiITElKpB/D+lFBRR+sjGGo
KFzDPrSPG/7QZVYMoYgVYn4syWpUC0eaOWWVmLMokDJ/FJ37+rxcdYNx9+ye
e85znvPcu8Z2rOBghMViKeSvWtu2B88tt0s6fXXloqLfghSuvx+OR9YvvtDw
XVCd55e1pFXjP4WfW2JaJPnWfpxxfBO04sOb6X4nzocE2Sc2ptQ0S/rn519f
BUW6You/NEmq6H7VlDemcQ9Dd1Dj+BKuFBC0gcvkOnF+UFDHKU58R5JainyC
+nfZogYZ3z6evWTgtaATvKy7K+larjg6/hL57oFvryBV5uQDST9an+9MdyF/
u9434rskLY3YVB3tF2SL2pf5yIP8gQU4qLHBj/s5y/1GesB/HPvdkn6qeiHo
x/n53xdnWK+4qsk9GU+1nvP4zMHz5jESjs34oRnH4Y4h8GFc8GR11ZEB9DMp
SNF2+qEf82tkIbw+Sc157qm/QeTzSjqkPu8FeVmvqV6tj8HHLWm/4t+IebzD
fr6gtAPtO2q53ttpNkY2+huWVKnmnYr4UfSfjPkFJe1dlvSwMUGQGlvZGPxk
Rf0J8J+DA6penKBo9lvh43Bsxl9ivYfbNc4a3X3xOutdpOrFz/Kp7IL/EsGv
R1JscWnWaPJsv88Yb2O6nSkaG/qlaWzolwF9TP/kLJhnvr5PRv8O8L2p9w3/
1GO+ObN+LL0saZXik6mx4d90jY18W1HviqSYzazIFvRTDz8mgm8DcDzO30A/
Vvj/ltbLxKa+BraHYzM+xPRdZbgfVtxHhyRFrzMB/MqxnwR/VMBvqcA10DMb
8XVaH4N/C/jWLui/D/MVeF8G8T5VS3Kqep/gnwrwZf/z69fWV476k3i/zuv7
ZL6PJv4P6PNjRg==
      "], CompressedData["
1:eJxTTMoPSmViYGDQAWIQrcrWOPVw+WyHSMstJ8piexz2lEyWaKmc7bC4wJbr
ulCPwzr3h1UipQh+kkCEpUnJbIdFrts+/5Xvcah8qWbIUTzb4V2NvWmcJkT9
lMLZDpox/Ye+6vU4/Ah+vFQ6f7aDtP5dFTaLHocJh75q3Mme7XDg1ELXbXY9
DuI3z32/nA5V7wTlJ892aAYpcO9xMI3b5dkTB3WfJ8R9LBEIfiHQWYsdMflg
88O64fzW14E75Jy7HUDOXeM022Gqc3fOc7NuBxWQ/11mO/AwabeLGXU7gMPD
fbbDBaXbP+u0ux0u+wJ97DPb4f3yY97mGt2Q8AlC5YPcg86/CzJYvtsBFGyL
RTD5MPUg+5ylEPx2MWAAKCD48iCHq0LDQwdqv8ZshwiQf02g+rWg/reE+FdZ
e7aDbFSK9X0XBB85PEB8lPCUQPCt7/v3ThdA8EHOCeae7fAWFL8e0PjnmO3w
AeQ+N2j8skDd69wD8R/DbIeLoPCz7YGE599ZkPA17XHgWCMT9eTXLIfz34Ea
dXrA8aHzc5ZDxkSgDYpQ/T9mwdMb2L1fEHywe7/NgqdXAIhTNIk=
      "], CompressedData["
1:eJxlk21Ik1EUx4dERPjBD6JBVPTuKBllL4wVHVoSEiEWhIX0YVRgBBWV5ip7
0ZzuFBFlEYcsezKLZJVkDBkjLTbT0GTCfJlJ60NIhR8qYtSH7rk7ciEHY/s9
997/+Z//uc9iz9FdBzNsNttW9eXfwPZP3ptNBB+Xzb7Y+Bdhmk/emDdrz3uE
05Mr1tS3EnxYMpaq/oYwmqo+HHpu9nuySp3rOg278ciXM2HDVer8nG4Ce9m1
7l8phNyR/t+xtwRdvc2Fr34i5LffnWqNEhRlZqzyTaXrZ78jGOR6k4bHWS9p
WPtJIKzf31mU2SN+4wgh/hMhYLmcmLCq18jG+hFcE8VXb3cRPDy2eW5c9cey
b8KGtV7I8DZ17E9Q6g1IPh2yPpT2v7KdoPz697NbRhGOq8fWM+k3IfUDhnX9
NsO6n6cEh/gzhsCxnHgi/Qwj9Cn+0UJwi/0PIuSo/HY/kPWomZfOO2hY51ti
eMG+A66JQgSVdmTHPdHbJP3fJ7C4nw0ITWq9r1nyXit+LYL5DvXEke5v6SMC
ltm4GmHh5a8lwccEe50veyrs4r9N8s8Tvy9mstZfJOydydP7k97sQPS84dhO
T9ZwDQFfm4g9nW9tnfjJR/Apgcp6gtdsxCH7GwiU6ueWAgRu0/KLnlPmgwRs
P+yS+4ySr9uwnnexYX3e+o9DMi+/zLdX8vCLnwFZV35KueCQ1G+QecTl/vhE
T92n5SoWd534kft+pVbyHpf+LxnmeeVeMKxc5JWdI6hhAwmTr/Y3IvOsIjjF
+kmpf8e8v/8AVp71xg==
      "], CompressedData["
1:eJxdlGlIFFAQxzcrEVE7SWFzvcqjkhISU7ccSz+YRGQYJSIhGmWHBRZCEpVK
xAsqzArek+76YpRSi4moHVgkmMfK4pGZ96qt4FJqlvSOqYctyPrjvZ35z3/e
TEBmbkq2i8FgOMD/xPf03v5HRg8Gn9e4XijdRkDyAgYtgV0z58IJPKbv/Df9
pJDqFV5ZFkTg6pvvoelTFMLS+X/+BE5tdbcFOSmU+Cza5+VLwB4c4VbuoODh
sv7SKiOBlCpT8ZhdM09pON+nOTnqcvzBbgpz1nx7MI8XmVGddMVG4bQIuI7A
rRPLC+tbKTQLPZsxfzMF37Ss2C/xmvdHv/hwJkWz1JdOoCavxKeohcL9RIvz
dzaBa/y8u41Cj6j3OIHJ1l2ZS3m+w9e/FcTlE+BRau9wPUcEX0Q9A1T5Q1D/
OMa7ofx5PkPhkPjcRf+4nw9PcmOeapb1WDQLubWNBNzKV6dluTP1+04CCeTY
8Kwr3u9T9+lC5FH0dw79cSjeMK1Z1uHULP2YoNA0xQONEdjB458dx/Mh9MeO
9fSqej1GKJSKi52aZb+sBHgXcswj6HeD5sL6j/cS6wiItuwephAj6nuF+Qap
8uOlei8P+incFAcVqPcr9usZgbKJJw3JPZrF+znapVn2qwP1VmB+G+qzoJ/t
+J6qMb+VgpBnqfuPGzQXj+2pMlnxvdqwvl6lp7EH73P/RoX/g6jnB9Y7ge/p
l9JTMzufzYvZP5Z+ejJwFMRFZsxg/1YwFW+SwG3x3r2Z0uPA+TIySBIFDmE/
fRkIm6K6CYiwb00MdorzdqzHj0GlEP5es4xfqVn6laP5k3gfqVifH+ZPQr3+
TPmRgP3gLOcvDs8DMJ8Z/QtAfbEEvDuaptoCGbwW/kWr/gwEoZ4tOA9rNcv6
gjWLtZMbgvsoGs9DcV/F4LyEob9m9CucQZFo2Hac9wim+pesed6+C0M/QnDf
8PryxHwYsf8+mht5GOdKzbKeZQyMG3lEE87rEjz/uy890d9Q3Kd8/uV8ROh9
8FfPH75Bn/A=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/SP48VJpnjkOB08tdN3m2+0A499VYWucOr/bISrF
+r4/wxyHf1cqXqpN63ZIEoiw3PJjtsMFpds/6/q7Hea+X37M++tsiPrubod1
7g+rRN7PdrDacqJsX0u3Q4Et1/XFr2Y73APJ13Y7uHTnPP/9fLYDD5N2u1hZ
t0P/oa8aMU+h+vO6HUzjdnnyPJnt8K7G3jQuDcGPtAQaGIvgfwBaax7U7ZAM
cg9QvyzIoR5Q+ZdQ9Y7dDkE75Fqz38x2kNYH2mAFde+H2Q6lkyVYwsy6HV6q
GXKs+YLgg5w9/xeCz6e7aW4+0xyH1teBO+TsEOEDCy8AYPKVDw==
      "], CompressedData["
1:eJxllEtIlFEUxweJiJBwESZopr3AMmqRmpl60HQ0U/MxwzTJLEYtS0VtxjQd
lEgZ4hYRUm6uix7iJjTNZIhBSsHCoCIXpZH2okAxA59FQffe7z/cRQPD8Jvv
3HPO/f/P+aKdNYXlQSaTySK+8rfX/Klpcyun6Z3rL938wyjAtsTB5xceMnKG
2BIPNmt+/6vl3JFG8DijQl9ke6WbU3DQXm/oFKNdIs1oDaf6jrB11s+M6pI3
vt1RyenlatGX7llG29rnCg6Vc7pbKx78YOR3i0CH5jjH4+yrNs3qfDGnW+ms
6vscI9nm6AnU+4b6uZxkGutH1M9B/KRmle+NZnV+HPXF+Q8y8YjBbfnI5zfy
zxVwupMxtPj3EaOJXGfIOyunhZ6xnIQ+I1+66D+m5PrIcg+jDfcj7GU1ON+J
+7aiHy/u4+WULRtwaf4p89k1WzbtG+jKZDR+O2PIdRn9x8MfD3iP4c+g0L/v
fMWN+UjEV6GfMEahk0L5Us1Twj9/iWblpwX9hjPaIuInjkOfKDw/xumV9C+a
0Zr4Cc+C/9tRL1Nz7EDXQs9RzUqfdE6n5ScKnIZ6EdAr5X9W/VXo+AArv0X+
8P3CsSJGSTP51zqzoGca5iMP9RMYeaUAYn7mPalxjlgj/9dT0G83/C7VrPyu
0Kz0q4b/MdC7Fv0egB5uzHc89Kvn1PZEKJOiWc2LWbO6TwHquZA/4H8t9sdp
zJtN+HlYXGf4LCPhfu+zMvjjgv4nEd+CfvKwz1fQr/BHtjPUgX0WfjyVzBmV
yuepnKxy3roZvRB/LyZz2movS5p5oFnpOaxZjLUv8jX0JU4RMn4a+2RGvVlj
n4NzMc8r0L9Yv2+U/g7Nctt8Ts1KrzOc+sVYjf0GV0PPVXAd+l1iJNes2Y36
i1rvAKv9adCs+hPvM7E9ntQlzE8j/F027tdwEfO7YuhvbuJ0T87Hmn4/Bvr9
By2+a/o=
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQfdk3SSBCcJqDbFSK9f3uTod2sZvnvnNPc1jkuu3z
36OdDo+qRNYd55zm0Po6cIfcvU4H3U1z3y8H8h/4907Pe9jpYH0fyADyQcLH
niD4YPUvEHwQlfeh0wFoJUMD1zQHTx4m7fZvnQ5g+3mmObyrsTeN+9XpIA/U
aME3zaHlwKmFrv86HV6qGXKsEZjmkDHxbY09QxdYfocwgg82XwzBB7tfAqEf
ZP4NKYT50/OEmg/IIOwHmycLlf+I4MuAwuMVgh/KB/T5/U6HT5eABgL5aSBw
GRo+0tMcMkH2H4OEj7oYIjwB6eCigw==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQfVRhQ9GLN1MdZKNSrO93dzocAfIznk91kAHxj3U6
8Olumvv+6VQHaf27KmzXOx3kW18HWsD4jxB8sP7nCP7bGnvTuA+dDtb3/XvF
n0118ORh0m7/1ulw2TdJ4AbQ/Hcg+V8Q+ekvpzq0HDi10PVfp0O72M1z319P
dciYCDSBoQvCf4fg+5h3Oj74iODPfb/8mPcXhH6w/d8Q5r9UM+TQ+THVAWRN
HtB+kHfUf051KN83X0r/I4IfCvLoKwT/AUj9006Hh1Ui69x/QPk3Ox0qgAZ2
fIOqPwZV/xERfgCCeaiQ
      "], CompressedData["
1:eJxlVQtMjlEY/mdYY5qZ2wi520yyMaXSW79WiB8ltCZ0n/zUuqd78R3mzmmY
mVqZzaVZbps1I2ZGhA1rrQwpiS5amjLnfOf5nY1v+/adZ+ec933e571803fs
3hAzxGKxJIpXfqsfp9VMY5zij3Xs9bUcIAf2lIsyRs4Lrp/bXaLxtJL29R7F
nJ73hXyoqGZ0NfB91thCTqesBxM/32dkkU8ep/oZDf25zxg9dK1Kbs3m9Pt1
Rtuct4zuppyYWJzOKUwabmYUHu3V9DyJk4tctDDyarIdmpDISbi5PbWDUeXZ
Wlf3WPDrZNT9cs2O0ds0TvIZ8WbmFo1rhb/4EE6TFzbOGv6VUfBS5te8ltNG
6e8Do9UCb1vFKb3m/KSFDUzFGwQ+9RqbfB5pbN6vYdQl/B9dyenExKFhzreg
TzD8V2F/HafBS2JVyeiVoLs5HOdPI94ETi+kPgbup0G/LEaZbXMWOeVhfw+j
G8L/+SLYT2Dqa3AqC7jZM7gd9g5yarYdKrVvUdh2GHxt2D/KaYpcBEC/45zu
986LOOKl8TIZqLvGA5K/C/Ir7MnP1RHQYx/s/TJIROe5ONeRL0PlPwX2Pimc
H6extHcySmOzPiI5pUqBWnA+AvF/NlQ+w5GvVkP5D+Mksltw6ouh9LGhPr8Z
JKL+Pncl9OxW/sYGQK8fhsq/VeMowb/aT2OnyyLzBNxjqPz4AncZtH/8u7r0
5chnp0GzBY0HPthvN5T+Pjo+k5/n//jbXt8lW/3Z3/MOLPtjqPB3LVlk2o2R
cNcXIvjFyscV+V+BeMczFW8g+msU6mU18DDg9Tj/W+lzcRPs/VT8rVtRX72I
N0Zj2e+3d2lsnk9Bv/Qbql4ywX8IM/X7mIN6GIn48jEPxv2Dp2ts6jlP3Y/O
A1839FMOzi9hSu9s1Ke36p/vGZzq5DzyR/2mon6CmMpXMnAw7O/kVCX1DUV/
RKKetyv71lD0vx32glF/mZhHgTifD/7+0MNQ86t0OeI/hvve0OcM4vFEP5Xj
vgf4XNHYvH9HY2nW/hT14Y39RswPK3A79HfMt37Mu1A93815GKmxOW/iNN4j
5mm5nVOQ5DfAqELEW5WG+HqhXxan4ntPLgR0g08O9jsRX67Gpp75Gpv1V4D/
RxejUvuYonuFyHcP5rWYd/Nl4oQ/2eYPitFf/fp/5OD7B8SWL08=
      "], CompressedData["
1:eJxlkm1Ik1EUx0dERB9CQiKisoIiiN6gMIvw9CH6YBIlhUREjAKFcBFRJqNX
qnvSyMrOPsy5rc1Nnw2RUVFQczpZL4aKEJFBLwhJmS6LssCoe5978kJ74OHh
95yX+z/n/pc4XbsPT3M4HCBf9S0pxK0HfQQV10fdxfUIs1clfK4HBLe33fv2
O4L6/6Nctr9uhJ6gDHQSTLaOD5TWITR7uxe3Zwi6vq/Yf83D/Xq43ocQkfG1
/QT9S1//Oh1mfkFQdOfJiWSU8wcNb36786pnyHDBxZFdG0cI0qp/AGHfIZkx
TlCp9NzQ3PeToG+ibKj5LIJU5ayfJFh5ee6r3krDm1S/UsN2/WqEr5LzZP3J
pH/+mnzmLMEeJeyP0HqGCba/r8lvGxNazxuu/yBs/dkBww+P35w3vdfwshnn
bqWfcv2w0PNneB+fhNaTZv4soE0mNqQI1LFVX8TU/sfcxRsO/DC8QA2e/C+e
EHBXjumXXK4WaAmw7ztJIGXfXxQVoNZQ0EGQeiYvMqT1u1J8XwGh99vF3MTz
djM3av3tj5m9Qt//81zeqxo3CNghz3/XmMv/8m19fsMO9YQIwke3zHrpZb0R
gmw0U1LoE+CpmnMh1cLzBDjf4v5Bof1pcb8Q7yPG/pXzS1dMlMV53xbrjbPf
Eobt+g7Ddv8jOMWjat/VCJKOVcTZb2dQzxfj+vOo54uxHy4hVH9cvk5Y7FfB
8VaOX0Fw5pUXrW/hfrVoz++P8Pl1zGHDp2S/mSHDtv+C7Lda9nsTwUJ1sYjw
F+PmDOk=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQnTHxbY393mkOF5Ru/6wr6HSA8YGkaZwOgh/Gp7tp
rmynQ8VLNcMOIH9DEVBGuNNhy4myffL7oOr5Ox0qgfIc+6c5hILUs3c6RKVY
3/c/OM1Bu13s5jmGTgeQ8Psj0xwWuW77/PdXh8PHS75JE05Mc/h3BWjy1w6I
eWenOWSC7P0E4c+/hOA/rBJZ534TwV86+4jChnvTHNJA4HsH2L7zj6Y5WIE0
MnY6LAPKG7yY5vBnJdAmoPt8zDsdH7yCqldC8MHusULwtUDuDYO4//zzaQ7N
B04tdM2BmLfhIdS/1RD/5N+d5uABclhrpwPHGpmolBvTHGRAGrs6If67hOBf
9k0SiDiP4IPddwZqfmenwyegeoGT0xxaXwfukGvrhPjv2DQHd5D5zZ0O0/OE
mg8cgsZXDSJ+YPEHAEUB6T8=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQrbtp7vvlktMdwviArNhOhx/Bj5fOBvI9eZi02506
HY4qbCh6ITPdofnAqYWuup0OFS/VDDuUpzvIRqVY35ftdFg2+4iCgdZ0h/v+
vdPz+DodGEDAaLqD5ZYTZfvYOh3axW6e+26F4AftkGt97YDgg+yTdpvuIK1/
V4WNC2q+F9Q9Ap0OIOq933SH8n3zpfTFOx10QO4Ngtqn1OkAdn/odId3Nfam
cUadDkDTA3dEQPl6nQ6XfZMEIsKh+mU6HYCqj3kHT3cIBRnM3elgDTLIB2rf
nw4HH/NOxweu0x08HlaJrHvb4eDcnfO82na6Q+bEtzX2zzocjgDDI8MYwQdp
y9dA8E3jdnnyyE932Aiy6F2HgzzQPRbi0PD63wH2fzb/dAegKRPfCkD9yz3d
YRrIInUE3woUPi5o8slQPlB/Bsi+GihfHKq+F8qXh8rP73T4eMk3aYLmdIdF
rts+/10ODS9TBB8cv/YIPjh8PKD6F0LC74YfNL4mQ+IvOxTq3zZEeIPDtwTB
h6UnAGRaFUc=
      "], {{1478.414, 813.14}, {1488.977, 813.14}, {
      1488.8909999999998`, 814.609}, {1488.719, 815.64}, {1488.461, 
      816.234}, {1488.043, 817.159}, {1487.422, 817.89}, {1486.6019999999999`,
       818.4209999999999}, {1485.777, 818.9519999999999}, {
      1484.9180000000001`, 819.2180000000001}, {1484.023, 
      819.2180000000001}, {1482.648, 819.2180000000001}, {1481.414, 
      818.6790000000001}, {1480.32, 817.609}, {1479.234, 816.5459999999999}, {
      1478.6019999999999`, 815.054}, {1478.414, 813.14}}, CompressedData["
1:eJxVkn1I02EQx4fUsNCwkDIqezMpLERKSEw6WlYSEim9EOEfKyuHL/krZWkK
arY9OjHTebpcsZUtaTobIRESURRRIL0IvREWRWYvRkSIlNE9v9/BQ4Px48Pd
8727791Sa0lOfoTJZMqgv/wezZj5/GIY4UjLt5MbUwSMJaZEru5H+DtsH0uc
L6D5zq+V+68i7Jq1Juw1C7DG7E1bdwlht+RJJ5yQD7wI295VxPZ9dUL6yI6m
eW6EAqn30QmRwYX7DroUDx5vjZtWq9gx9+XQhB0hpFEH405YYa5xW0oRKJqa
ZxK6HhYghL3fA/dnCz1+Nx+h7vZDX+YqxVQlfWSLYr3fA8KoZ2P9CoNPaQiL
ZL5LQGrezayoSoRrUv+8APnZXo+Qdv1B+a2AoWdpUby4/svO9R7Fen8+BH/m
wM8pvzDmDSA8WfZ6srqT/ezleLOAvq1kFPlLMjfiTyvW+6lUrM9TLoBUbBtC
3J9mxNt6eb4SAY98JEz7yYqKSHIUCvhM9YI9XM8mIEH6cVnxs2xrzAu/Ytnv
hwvcbxEz7fOxZI3fdyH86fnxNLuM/SQemsh9301+lsr7Ocf5tewf8ZTMbxDG
fjt5X2c4H3m/bZzvZu7g+c8ijEv28HxNiqVcrkPx5sbC0d81CG9pDcVuzq9i
fxrZLztzNc9XhnD4EP2KFOt+7FGs3+cm4z5c9H5B8psEczLHq7h+PN9DHd9/
tACacuBYA8enc/3W/znWo/jekn7tE/mfJI2awfFuvq85Al7R/gevcDyO/Qoi
tFto8OV87yHuf62Af7zm1bo=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQveVE2T7569MdWl8H7pBj73I4qrCh6MVNBP9hlcg6
9zvTHf5dqXipxtrlkDHxbY39vekQmrHLIUkgwtLkwXSHPys/XvL92+mwbPYR
BYOH0x0Of9WI6f+B4C9y3fb57ycEPz0NCN52wvWH8elumvuiE24+mP+kE26/
B4jxoBPuPkuQw+91OsDcD+OL3Tz3PfgKgg8y5v1FhH4w/zzC/HaQhrMI+xlA
4CzCfTA+zP0wPsx/MP0w/8PMh4UPxxqZqCcXEeEH9s8VRPiihz8AfW/JsQ==

      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQzae7aW7+/ekOlltOlO1b3ukA47e+DtwhJ4rgezys
ElnH2ekgfvPc98tA/mQJljA+pk4HkLb5D6Y7ZE58W2P/r8Ph1ELXbcUPpztc
ULr9s+5Xh8PS2UcUNjya7nDue/Djpd87HKJSrO/7P5nuYAXS+LXDoV0MaODT
6Q7TnLtznn/ucDgN1P/5xXSHRUDq76cOhwyQuW8x+bIgg153gN33/gAmH6ae
Y41MVMpRBN/bvNMx4QRUPdA+HyD/wcnpDmEgjUD3AF1blHF6ugPQFtM4oHvB
/jsz3aFi33wpfaB/gEHG0HAWGj7/oOrPQfnA8ACbB+QDXbH8GCeCDwtPGB8c
PtEIPthf+Z0O69wfVk0B8qX176qw1XSC7WM4B3VvY6dDxUs1ww6Y/W2d4PA8
fwYaH51Q/mlofHZB+aemO6SBQA80Pk9C7evtdFgGip/jCP5l3ySBG0cRfGBs
9U4/DOVD9YPCFxzfQPM/XvJNmrB/usM7UHhN7HT4BOQL3EakJwBQ1DOw
      
      "], CompressedData["
1:eJxdlGtIVEEUx1ddzUe+StryhWaa+EisTExXj6looCwpRUr4YTFZM5QySi2k
sK07aahk3IlFRMUkEDOxkBCRioiEDAsiKiz6kI9U0sJMzWbmHhtqQS4/Z+bM
+f/PORNsLs89bq/T6fLZH//mDgRaS6MoWKcPDQQ6EYgrfHhwYwiFzE/VPj2L
CkyGxTpHBVCYuZASVzinQMtc19MRX9w/o4DZ62jCXgOFyKtb3r6YVMC527+g
aDOuTyjQ8OhH+DFPyYNnbmzVu0guKEocH3WgUMx/XxV4t1RzYnBNhfaMBwur
3xU4ZXR907Gswuhi3ufOVQV+so9tSQW/mA87nFzIXxbxDOTf9SAC/JjtlwoJ
/c/ODu1EXlGhpIkp2kW0/Nh9Fs7xBHq4cD3qTyGaXlcKhz2i+1oyNX/qvZFN
BNSyTbXD/hRW7nwby8knsO7nfn5fkWShp1Ty79eVk2E1BNLrTn5ZjsB417T8
/cIpzHK/m4jwIymUwrmhVt8YSjT/gnG/jUAaO3/eTzL302SQrOM/H4x3S+Yf
wDc24zqrT+3w87aMRu2+QXcK7JYjHnWShT9WLf9pd9RXJZnb2FBBRL1CGEfw
fijDerhReLmdRWL658dyzF6uGM+Cepwx32LU4yhZrDtIFvnaod8W9HMN68vi
Z8eT1I+rWM9y9JNx72n2nwrJQn+VZKHfivfpKPTxwjcQaGTC3jtK/4QfTM9d
Hq+dAE9rjvW7uL8L8w+UzLI0N4ZJFvMSTbX+7MT8d6O+VgLMtcW8fRTGTdfV
MhvuT8D+acb5TET/6on2TUJ/r2C+jO/x/Ksli/kokSzORUoW87sN9RuxPz1x
Poy4343AbduToF4j+r8B+zOZQhafFz32czK+Fw4EQp0u3XycgnrtiXhPugH9
tCMwxTlVMtfbf0DyfWZbaxrmZ4d+paOfLJ6B+fUqA/XrtfwvZ+F5F6xHNrK3
5PX3TvQjO1/J52tegZE2ZvS63gl8/+Ili37fI1nUKxbvn9LWS2OwXrOK6NeL
0TgfC8hROG/LCvz//v4B9TWRig==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQHbRDrjVbZ4ZD6+vAHXLCnQ4wfhif7qa5EVC+0gwH
j4dVIusCOh1Awu+lZzhMlmAJ4/PudHDpznn+W2KGg+WWE2X73Dsdbv+sy9oj
PMNhmjNQwhEqzz/DAahr+TFrqDzvDId3NfamcaadDiBl1dwzHKT176qw6Xc6
9B/6qhHDBTVfA8G/oATUqYDgTwVpFOt0UGVrnHoYqH99UcbEt3ydDt+DHy+d
zQd1PwfUfEGofUydDiog9SIzHICqa+z/d0DkJRD8j5d8kybIIvhJAhGWJioz
HGSjUqzvsyLCBxZeAKRmjRs=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfVRhQ9GLohkOra8Dd8ixdzmg8EU74XyPh1Ui6zg7
HaJSrO/7F0PlmToddDfNfa9eMsPhXY29ady/DgeX7pznv4F8d5D6Xx0OGRPf
1tiXzXCQBWn83uHQLnbz3PdyKP9rh4M8yKDKGQ4bioAqP3c48IEMrJnhsMh1
2+e/nzrA5i9vxOSD9b/ugLgvBJMPU/8j+PFS6UgEH2x/NFT9Zwi/PHaGQxjI
YqB7GEAgfobDW5B/gO5dNvuIgkHCDIeKffOl9IH+qXypZsiRCPX/P6h9iYjw
uOybJBCRNMMB5MxjnAg+LDxhfBmQ/bsQ/Pv+vdPzzndC3AvkT5ZgCeO7Awnf
5UDzrbacKNv3oBPiHiD/otLtn3VPO8HhlZ8AlX/R6XAE6J4MoPsvgORfQflx
MyDx8AZqfizUPW87HSqA/umIRvAfAaPteCSC//GSb9KE8BkO0vp3VdjedKKG
98tOcPxZBEP5H6D25SHSEwAIbiuJ
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQXfFSzbBj8QyH1teBO+TYuxyiUqzv+y9D8JfOPqKw
YcUMh39XgCpZuxx0Ns19v3zVDIeMiW9r7Bm7HL4HP146e80Mhz8rP17y/dvp
ANTdO33tDIfDXzVi+n8g+Itct33++wnBT08DgredcP1hfLqb5r7ohJsP5j/p
hNvv8bBKZN2DTrj7LLecKNt3r9MB5n4Y/9bPuqw9CxD8y75JAhHzEPrB/DkI
873NOx0TZiHsB9pWlDET4T4YH+Z+GB/mP5h+mP9h5sPCB+ibY97zEOEH9s8C
RPiihz8A+VbM6g==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfdk3SeDG6hkOlltOlO1b3ukA47e+DtwhJ4rgezys
ElnH2elw+2ddls2aGQ6TJVjC+Jg6HSpfqhlyrJ3hkDnxbY39vw6HCYe+atwB
8i8oAVX+6nCwvu/fK75+hsO578GPl37vcJADGbxhhoMVyL6vHQ7e5p2OCZtm
OExz7s55/rnDoR+oP2brDIdFrts+//3U4aC7ae775Tsx+bJRKdb3X3eA3RfR
i8mHqZ/3fvmx0xMRfJA3jk+Bqv8M4btPm+EQxgc0GegekPD56TMcgL4xjQO6
F+y/mTMcKvbNl9IH+ueowoaiFzOh4fMPqn4WlA8MD7B5s2c4gJx5jBPBh4Un
jA8On2gEPwMUfvmdDi7AYPgNNE9a/64KW02nwxGgfRmzoO5t7HQAOfM9zP62
Tgd5IMNiJjQ+OqH8GdD47ILygf5JA4EeaHxOhdrX2wmJnykIPpiehOAzgMAE
KB+qHxS+4PgGmt8udvPc9+4ZDu9A4TURwi9fjkhPABymLWQ=
      "], CompressedData["
1:eJxTTMoPSmViYGCQA2IQfWqh67ZikZkOslEp1veVOx3Ebp77HiwM5b/ucBAH
8i8fmoHBX+S67fPfTx0OHGtkolL+z3B4W2NvGjel02FPyWSJlocIvvV9/17x
2wg+SP2TazMcPHmYtNsnQ/lXoOZPhPIvzXAo3zdfSn9Cp4MqW+NU54szHCZL
sITx9ULMZ7kww+GC0u2fdR2dDvKtrwMtzs1w0G4Huryx0+GlmiGHztkZDoe/
asT0V0LNOzPDwXLLibJ9+Z0Op4H+/XwCwQe79+QMh3cg9y2Cmi82E4MP9u8s
qHk3ZjhkTAT66GeHQ6Et13XlXwg+2L+MM+F8cHixznRIA4FfHZDw5ZjpYAWy
/w9UnmsmxH//oXyemQ7/rlS8VGOGxgcf1H6OTocjChuKMvih5vN2Osx9v/yY
t8BMhwpQeIlB3SuIiE8AqU3khA==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQnTHxbY29/kyHMD7dTXNjOx2SBCIsTYB8Tx4m7Xan
TgegEoYGo5kOzQdOLXTV7XTYcqJsn7zlTAfZqBTr+7KdDo+qRNYdt5/pcN+/
d3oeX6eDNYjhPtPBEqSQrdPh4yXfpAkBCP6ekskSLWEIfjLQvi3RMx2k9e+q
sHFBzU+Aukeg06HipZphR8pMh/J986X0xTsdwO7NgNqnBOVnz3R4V2NvGmfU
6QByln8elK/X6QAy5n0OVL9MpwPHGpmoJ0D9oSAJ7k6HZbOPKBgkQe370+HQ
LnbzXDnQPR4PgR572+Gwzh3ICJ7pkAmy51kHODwYPBH8SqD7OOwQ/AJbruuL
TWY6bJz7fvmxdx1g95zXgYbX/w6w/1lUZzpsKAK6XADqX8WZDtOcu3OeqyP4
ViCGC5p8MpQP1A/2dw2UrwtV3wvlm0Ll53c6gLyvDoyfRa7bPv9dDg0vbwQf
HL+hCD44fGKh+hdCwi8/BRpfkyHxx5IN9W8bIrzB4VuC4MPSEwCj1w/B
      "], {{1611.812,
       813.14}, {1622.375, 813.14}, {1622.289, 814.609}, {1622.117, 815.64}, {
      1621.859, 816.234}, {1621.441, 817.159}, {1620.82, 817.89}, {1620., 
      818.4209999999999}, {1619.176, 818.9519999999999}, {1618.316, 
      819.2180000000001}, {1617.422, 819.2180000000001}, {1616.047, 
      819.2180000000001}, {1614.812, 818.6790000000001}, {1613.719, 
      817.609}, {1612.6329999999998`, 816.5459999999999}, {1612., 815.054}, {
      1611.812, 813.14}}, CompressedData["
1:eJxTTMoPSmViYGAwA2IQ/VLNkENn90yHtzX2pnEMnQ5JAhGWW7bNdGh9HbhD
7nuHQ/+hrxoxm2Y63PfvnZ73ocPhR/DjpdLroOrfdDhMAMrfWTnT4c/Kj5d8
X3Q4qLI1TnVeOtMhcyJQxTOo/gUIPscamaiUaQj+stlHFDb0znQAKet/1+Fw
+2ddlk3bTIcMkPz/DoeoFOv75+tmOkxz7s55zt8Jsb8aap8qgn9BCajTHsE/
/x3IiOyEmFc/0yGMT3fT3MJOB5Ax1e1Q97dD5Pf0Q/07txNsn/+smQ6LXLd9
/rscqn85gg/233oEP2iHXOvrrTMdZEAaF3U6wMITbN8MBB/s310I/mQJljC+
81D9u2Y6yIL034bws3dB9T+Ayu+c6fAAFP5POx22nCjbJw/kW4EYLzodTON2
efLsgPr/VacDAwhsh4bfm05I+G6F+u8tNHy2IPjg+NiEJr9hpoO0/l0VtjdQ
/6+Fuu8l1D2rofwPUPXHofrZu8D82acx+WD3mHTC+VrtYjfPyXVC0s9pqH8E
OyHp5Qw0fHmg8meg8c3R6VBoy3V98Vmo+1g7HW6B4u8c1D5mqPrzMx2aD5xa
6MoIUa98EZG+Qcli9iUEH+z/Kwi+CjB+D1+b6XARFJ6M0PRxc6aDJch9MPNv
Qd37B5Je9+xHpGeU+AbyAQI3tI8=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ/VLNkENn90yHdzX2pnF8nQ4w/lsQP6fTYe775cdO
74LKl3Y6/Ah+vHT2zpkOh79qxPTXQvnbZzosct32+W8LlL91psMFpds/63o6
HU4vBEpsmunQ+jpwh9ykTodXQPPXrJ/pIBuVYn1/aqeDt3mnY8KamQ4eD6tE
1s2E2r9ypkMon+6mubM7HUzjdnnyLEPwkwQiLE0WIPgMIDAb6r5pnQ5BO+Ra
s6dBze+Gmj9hpoO0/l0VtrpOh/5DQIf3znTQbhe7eS4Twc+YCPSxP4KfBgIm
nQ6qbI1TnSdAzZOH+E8aaH4YyH7BTgeX7pznv2dDw4sZ4p6GRVDz/nRA/LsS
wU8Gun/LegQf5L8eYHi1HDi10JUJEf6w+AAAuFm9Lg==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQfdk3SeCG3iyHdzX2pnH3Oh1Q+Is6HXQ3zX2v7oLJ
fwviT0GoR+e3vg7cISeH4LccOLXQVajT4ZWaIccafSifCyIfYQhVz9bpYBq3
y5PHeJaDtP5dFTamTofbP+uybExnOSxy3fb57/8Oh6MKG4pemCP4P4IfL5W2
QvDB6m1mOfxZ+fGSL2Onw8MqkXXudlB55k6HqBTr+/4Osxwst5wo2we0D2ye
4yyHjXPfLz8GdE/lS6ADnaHuEeh0aBe7ee67G4IP0jbfBcpnhrrfEWrfzw4H
oOm94rZQ8z91QPxvMcvh35WKl2pvOhz4gAGYbzLLQRbkkBdQ/+gj+BMOfdW4
o4Pg+5h3Oj7QnOUAFI7pf9UBcY8aVP5tByS8VGY5NIPC8yNUvSLUvm8Q9eUK
sxwuKAFD5g/UffKzHLRAEsDwPQK0P0NulsNhkPk8CL4VyP2SCD4sfsH282Py
weE7q9NhKyh8hGc5THPuznk+t9OhH+Rwcah9sPQjDTV/ZaeDC1DZb5h9G6D2
KUHjfyeUrzrLIRQUcIeg8QX0vzsoYo9D4wsYPkBVE99e6HR4BBLWRqRnAES+
X4g=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfWqh67bimFkOYXy6m+bGdjocUdhQlAHke/Iwabc7
dTokC0RYbomf5dB8AKhSt9NB7Oa578Fpsxxko1Ks78t2Orh05zz/nTPL4b5/
7/Q8vk6Hue+XHztdMsvBcsuJsn1snQ6qbI1TD9ci+PKtrwN3NCP4R4H2veiY
5SCtf1eFjQtqfi/UPQKdDrd/1mXtmTjLoXzffCl98U4HsHunQu1TgvJnzHJ4
V2NvGmfU6bCnZLJEy2woX6/TodCW67ryLKh+mU4Ha6BG8WmzHEJB5nN3OnCs
kYlK6Yfa96fD4aWaIccaoHs8HlaJrHvb4QCi3BtmOWROfFtj/6zDIQkYHiZl
CD7IfTbZCP5l3ySBG4mzHDaCAuJdB9g9LFHQ8PrfAfa/RdAsB2AoT3wrAPWv
3yyHac7AgFRH8K1A4eOCJp8M5QP1Z4Dsq4Hyo6Dqe6H8JKj8/E6H/kNfNWKA
8bPIddvnv8uh4VWB4IP8s6UJwQeHTzdU/0JI+C2eCI2vyZD4s5gB9W8bIrzB
4VuC4MPSEwCIvSEL
      "], {{1687.1129999999998`, 813.14}, {1697.676, 
      813.14}, {1697.59, 814.609}, {1697.4180000000001`, 815.64}, {
      1697.1599999999999`, 816.234}, {1696.742, 817.159}, {
      1696.1209999999999`, 817.89}, {1695.301, 818.4209999999999}, {1694.477, 
      818.9519999999999}, {1693.617, 819.2180000000001}, {1692.723, 
      819.2180000000001}, {1691.348, 819.2180000000001}, {1690.1129999999998`,
       818.6790000000001}, {1689.02, 817.609}, {1687.934, 
      816.5459999999999}, {1687.301, 815.054}, {1687.1129999999998`, 
      813.14}}, CompressedData["
1:eJxllGtIk1EYx9cYyyRCojDIsqLLh4gIirIInxAxKpGMQvxQMQwMYko3IkYp
0zxHHTWkhDOislQUmU4q+hAipV2krDQQk1iauZWs8Lo2mnXOeZ/jIfZhvPu9
5/b8/8//PWttRbmnzCaTKZf/xHOiL9t24xmD8vHDT1aXUkjlf3a9ZZCSX7DH
zyh0rWk7WzjAIO3hq4sdjRTEI3VYszdr+PKyMc392bakvB8MCt0hR3o9hSVb
2m//CiHfpfD0fM2KsglkD4WDO+m+k9MMVm79vN5aQ4GXZCqZZXBULKww2PSb
gTjGe5VCrX2ps5Pz+3VDkSvnNNdlPp6K2TRLPcs1H1hs3lyxiAKvLm17hMF+
sd8C1BNlcEycFyOQPNgb7udc1tlzLzNKjPP/MOgNH/laHybwiM+/E2OwWyyc
IYaOvwxuZVSdCUwR2GAtvZlh9hj1TBKo93AHrfG8Svg7TkD6P8jiWM0XZRUN
aW4Q6/2ai/cmDtwfYeAU9U4TENvkjGL/Zon02zKG+iPE0B9g8NORvuM413uI
+/9FsZmCaNemIIOQYAs19gtiPxI1K38Vy/pPaPbnuGrtxZinAPbLQWGS60v6
hvU7KSS0pOSPjuB4FTX89GM+rmN/PmmWzz7NYn1BD9Z3jYLKs9RzQbOqVzGX
2fgigUI3z3eQ89zHS9838jzI/j5ncFrsP0eAv91GuhjEmvjKqOHvu27UF8b+
vMT88DxIfa/RD54Hme83ul+SP8Sz6r/U9SCe1XzJDZpl/5o1y7x6Uf8M5rUV
9fP6ReyzfJgPrk/6247nLaTzrPz6bzxPs0/4Z6fG+T6c78Dv2YfzS3C8Db+3
cgo8Ha5kzvxWcYcI5qEV+1dp3A8WL+avmhr5bsF+u/A+adYs1zdplt9vA3I1
nfdP9rMS74M69MeN4x36/lL5UPwPaO+RSg==
      "], CompressedData["
1:eJxllFtIlFEQxxepKMgws9287apoWiqyiuVly7F1MwszjSSiG5KVGUYSamVR
VPgdozYp0DhIahdfIioi9kmiGz1Jl5ciQiIozUtYmRWEnct/PVAfLLu//Wbm
zPxn5sRXHaioDrHZbJvER36/Kq0K21zCKffes4a+XkZBrpyXfrezhtHhocXu
2asNe8/u/3TUy+nMcHnAeYzR21/H93mI01hzQfb2Vkbvj0TcKvaA2xj5H06k
bM3hNFB2rr2uA/GzOPX47n/7wxm5RKCcdMP50jDFsLR/nchp7dyQ1JbLjFrs
b/on45HPJW3vcHEqlgf7GYl/v/TGcqppG20uaDW8V/Jpw6kyUDMjpyoE+TXg
vDjUd5BRRUBYJCB+LaOfGz9cj07mdLteRKxm9DhO/BL5x27ZlT+wA/nlI79y
7V8r9CyR+Rfp85M3cGrsuxKVkWVY2ccajs54lzgrlJFNPqWc+ifFwVOWzlf0
40WCUH7CUuc1Cv0PXVw0o3IYnIv6P1pK34DbsGyzK81wR134qQdJ0GfQ0vo7
wSMWrVvOCnfGcHok2ugfxfso+I/p+DmRhj+LcbnpMKzysaP+EfgvhL5Dlp6H
8P9Z+S9l0/ZBVvEc0MOB+YyGfnMwf8H+2Rg1ifdWEvr3w9L9SsV8jVv0RPCg
27Ca72WGVX15nNZI/+86f8cKxP9t6f4Q6ptCvYXwn8mmWfUr1LDK3455K8C+
OFGvB/UkMq2/6GeMnC/UP5nJ6Y4Y46eZ2KclnEalv0fvU8CF+fRhPkV/5Br6
14Pt0LMSvAD7sI1pPeZz2i2fPYZVPfX/8EnUE4H6zyP/SOQv9r1dzpcT+vdg
H5LMfaPs0w0rvd2Gx1+WVl3I5tQk9+UGozS5v3nQ/yqjr+J92EpwN/QgcJfR
O8iyXSdWGZaylnkx312oz4t+dWN+ijg9l9yD+84H+2vmfgzm+xf043Kb
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/fGSb9KErtkOlltOlO1b3unAsUYmKmUGgt8udvNc
+eLZDhkT39bYz+10iEqxvn9+NZTf0enAp7tp7vtNsx3+rgSaVNbpADSSoWHb
bAcrkP5EBP+C0u2fdV4I/r8rFS/VrDodgKRhx5bZDmEggzQ7HUDa5m+Y7SAL
skii0yFJIMJyy5rZDq2vA3fIcUDs918ONe93B9j+/AWzHRa5bvv891OHA9g/
M6HyrzrA/nkycbZDJsi9z6DqOxF8eZDB1Qg+2H8Fsx3K982X0v/Y4bB09hGF
DRlQ+9k7HS77JgncSIS6VxLi//y42Q7vauxN4/TQ+K4IvrT+XRW2MKj/E2Y7
hIIk0qD+TYGaX97p8LBKZN1xoH3uIEZ7JySc82Y7bCgCsiZD9DOUQsNndqfD
I5B6oPuBsbD82GJIfH1vQsQfevwCADSL6vI=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQIN7bMdLLecKNs3q9Ph9ELXbZ+bEfwjChuKMhpm
O5z/Hvx46YxOBx/zTscHNbMdLijd/lk3pdNB7Oa578GVsx3+rPx4yXdCp8Mp
oP7istkOi4DG/O3odMiY+LbGvgSqvq7TofKlmiFHEVS+uNOBT3fT3PcFUPk0
BB8sH4omb93psM79YdWU4tkOYSAJFah7KmY7vKuxN40T7HQAKVevm+3Q+jpw
h9y/DgeQN+Rbofq/dDjMyBNqPtCL4CcJRFiaTEHw95RMlmiZOdsBaMzyYz87
HJbNBobA3NkOb0Hms3Q6XPZNErixcLaDtP5dFTZ+qPsWz3ZoPgD0uSKCD7bf
GsH35GHSbo+Ghs8CqP7STgdw+APtCwUpbO90eFglsu74FKh9U6D8PkR8oMcX
AC8z27s=
      "], CompressedData["
1:eJxlk1tIlFEQx7dVIkKkB7FIMouIIMV6iAqDpkKiG5KRREUPkmYXK3rIsjJF
F89ZV2wJEjorXWDzJUIkYp9MbE0x3YperIz1gnnZdgXLK2s2c76pQ/rB8u2P
me/M/z8zZ13ulew8u81m24s/et8c2bh1WVDBzpft15vqJfzHJRJSG+vG6r8r
uL8qNif+oYR9VZeGbkVM/g3MF5OGnyl/ypZZw2sdoaM75hR8XP91psQrISOY
VV07r+Bp5qufc48l2Oixe+DNxKbTNR7Oj/EApV2uNZwTn9ZY514Qd0n4dCR3
xQn8XusTfL7NAx+oXoWEw9vlnt7fCh6Q8FIJJ89mBN9HFeAxvuS7EvwpDdcK
Zg1PHxvwJk0bJnmlEwrO5eNTxuePs36Hpcc3pqCF9Ds5Hlawhgq5WO8Pw9pv
yDD1q2FEwYE4++bKKgl9xQkv9g9zXFh6swaV5bdcArq6sKtfWf6Kzby0nkLD
Op5omOTnx0lIo3ki0+ttrIRW9D/cq+A49XdeQD/Wb+tTkJT+bcPSqABKOzTA
PCOgMvFzoGiQ8ycFjOLxz4cUFDU9Wp3+S+h5dI+ynnErfyqymLW/kLD8Ni/m
v/lan9+wnnc79wPr6X53KAjf3r3tzJSAAjf+61RwkPqJerN9yY6LXQpwyu5w
1MpfGVDWPi2RVjzA9WN4fsgVzR1PMpcb1vEEw9r/qQXxqxJqaBECvO93uL9d
zGV8f5D1vuP+eGn+nTx/wffpnYII+XHyfqK/ctKD+6L7h/61z2rerzbDNO7U
VsP3UE9PC7NL/uvveWIn82uu57buU/cXc3//ALq8CTA=
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQ/emSb5JA5xwH2agU6/uvOxxA1PmQOQ6trwN3yJ3v
hPMtt5wo2yeF4E+WYAnj4+p0SBaIsNwSOsfB/WGVyLr/HQ5AIxkawuc4hPLp
bpr7u8Ph9ELXbZ8j5zhI699VYfvW4XAZaN2N2DkOGRPf1th/7nBYNvuIgkEy
gg/S9j4dkw9zH5hvgcmHqZ+RJ9R8wBbBPwW0v9gZwQe7zx3qXqB7fMw7HR94
znEIAxn0t8NB7Oa578HeUPMZOx3A4eMzx+HQV42Yfm4EHxYeMD7Y/NMI/r8r
FS/Vrnc6cKyRiUoBmgd05fJj96HyXtDwfdrpUGjLdV0ZaP+GIqAJLzrB/sl3
h+p/A+G/d4Ha9w4q7zTH4c/Kj5d8P0L5dtDw/tQJDw90/iJgNPz92QkJ73g0
/gSoejWoeQcQ8kuB8hueYfJh5oPCk+ERgp8ETA8mdxB8kLPlb0D9874TEj9X
oeEF9C8oGtyvQM1/3OkA9FXShMtzHP6C/HcLwYeFL4wPC38YH5Ye24ERWH4F
kR5B0eh/DZEeVdgapx6+gUiPOqCIuYOaPkD+gfFh/kXnI+cX/7WYfJh6cHxv
QvDB6X87gn9UYUPRi92I9AgW34dIj+D8tR+RHmHxA0uPMD4sPGB85Pzr34Nw
HwDJJOrW
      "], CompressedData["
1:eJxdVGtIVEEUXnVZH5VtYVpmPsoXimmhro/MIyEGJVJRqETEZrISKGWUSghh
1p0eqGRYeIdFwSQIszDxR4iURRRkZFARYVE/tFLJR6ul1pm5R4e6sNz97syc
c77vfGfC7GV7j7qbTKYC/In3/aenep0RHGq/7ekJtjBwNIyeyQzikPOpyq/D
pcEuG8s67M8BvyYdGtfAJB4/2j+qQX9o5wmHlUPsBf93L0Y0SB/Ku9K0nNaH
NfjxKtde76VwCP5JcVf4wcmra83zOhSL57sGvnH3+PiMDq3Z3ZPzUxoM5tqt
b6d0GHDt+9w2r0FhUfrQwIQO6+M/hFu82RKW8QLYv+uhhCd1SO1ColGEp3Uo
ETw3M6M+zCd52xgI2jlYj+SfyQy+Zg77RWE5DJpKV9f0+RDOY/C8BQtdw2Hu
FkYqYLCoZ5rIV6Sw5HNM4YXXFSOR1QxuNveHJoRTvItGfXlhHMaE3g1M6lEW
zOF0rzMw/joz9Auk/c0M2vB8p5/CQs9zVoXt1vzUxBUU74aqf4NI1Ejr2J+a
vmct2fVGvnELB+zKAd9LCkt9ahkIWiGexK9S4YfT0QfrypnsVz7ujxF+KCW9
Ub+XG9/PViP/CMvZazs8KJ6D+LhRvcXEZ0FfwnJ9TmFZ7y/d0Nth5HfOUH8x
fodonIv6WUZ6/tQBXdowWq6w5F+psORfS/lmdUDW7U/qGEygP6x/9CX9pB7I
546I18rgeIbPm02or8zfbvSzM0BhwfdRiMJyXiK54c828kMs8XcyQFds0eI5
iDEqbab9W8k/jTSfiaTfZQZYdXd5Eul7nupN5nBX1F+lsJyPEoXl+ViF5fyu
I/7J5M+VNB+L+5cx8LodVPglmfzuSf60cdgp5sVMfk6h+8KDgQjrSiG+7gx2
433yMZX86EY4TeHHyHc4XeEAPD64jepzI70ySE+MV4l6eWUSf7NRf08Wnfem
fmQTXqXw4n0n/bidQ4WYrwkNRHujbMR3mO6/BIWl3+MUlv2KofxfjXVnNPVr
TJN+7Yqk+ZjU4IjAETRvvzX4//79CyvblWc=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQvfVE2b75qnMdWl8H7pAT7nSA8cP4dDfNjYDypec6
eDysElkX0OlQaMt1XVl0rsNkCZYwPu9Oh2WzjygYCM11sNwCVOje6QDS9p5n
rsM05+6c545Qec65DkDR5cesofJscx3e1dibxpl2OiwFym9gmesgrX9XhU2/
0+HjJd+kCcxQ8zUQ/AtKt3/WKSD4U0Hmi3U6tIvdPPcdqH99UcbEt3ydDlEp
1vfPs0PdzwE1nwtqHxNUPe9cB6DqGvv/HWD3bRBE8FXYGqceFkPwgbJFGbJz
HWRBBrMiwgcWXgA/d5Cz
      "], CompressedData["
1:eJxllHtIk1EYxpdImYzwj4pAk25IkFFBEnbBN0LMbAxnDpEwmEXecmllUWMZ
uvadubFMMGqdvJCNcIiJhYREREQkZEgQ3bAoCBsWudZaoHTO+d7joTYY47dz
e5/3ec5ZbbNbjiQZDAYL+/Jf/6Po+oNHKbjCxSOZFwiMnuxYkdxIIaP88I7J
awRsaWW5Wx0UcoefNj0IErCMZLrCLsX7t5HdHzyKG3alvlrrp1DVPu3I6yPw
Ju6sGb2M3E2Ab2vuRA4QmMrakpJ9lUL6pvfrFnYQoN+DT4oCFEqXbByibp3H
rlMo+Hh26cB5AjkV9wu9lMKLNW/jzhOKe/PvRWZtioWeZYr3GZM2uBcTMPDP
DQp7+X4LUA9jKz9vVoO7TEZXF4XWh8968v9o+vndFJ7HSj71xTQxv7aXwnau
N6qJ/Y03KXTuaav7EtFgZsJkSwtiPTMa8L/P9SfySt6IsAai/85ElvOZypqd
zf+tb1XMy7a7KbTwen9q8JuVmU7Qv1+a6Pe4B/XHNV2/l8I3R15OBdPL+x+S
nERgrIdtzHiaczLR9/OhH6mKZX8li/oPKZ40+67UH8c8edEvB4FLTN87gvW3
ELgVeLxq0I3jbbpfxlbMhx/9cSoW46cV8/Wb7VjfRQIyz0LPKcWyXslD3NgU
ApUs38OM516emcrCPNRWUajm+89psPw1c76awuztHxMmlgceg0AN6ouhP3WY
H5YHoe8Y9iOi9ze7QfkluCmRpf9CX2Eiy/mCixR/5f6ZFYu8WlB/FPN6APWz
+gf4RbJiPub08bAVz1tE5ln265/xMsV3+EH1+v0NyfkOvM9yfjPR6yvF++Yi
kBLKKP/M6hlsZA5qmIcS9M+jvw/jFsyfl+j5Lka/fUT0e9SsWKw3KRb3twjZ
S+b7J/z04HtQgP1px/FK9X7JfEj+C6GQfkw=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLXbz3PfgU3MdWl8H7pBj73L4Efx4qfRZBN+5O+d5
9fm5Dv+uVLxUY+1yOLXQdVvxxbkOGRPf1tgzdjkcUdhQlHF5rsOflR8v+f7t
dOBYIxOVcmWuw+GvGjH9PxD8Ra7bPv/9hOCnpwHB2064/jA+3U1zX3TCzQfz
n3TC7fd4WCWy7kEn3H2WW06U7bvX6QBzP4wPdKVhx3EEv9CW67ryUYR+MP8w
wnygcg6dgwj7kwQiLE0OINwH48PcD+PD/AfTD/M/zHxY+Fjf9+8VP4oIP7B/
jiPCFz38AfEbx9s=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQXWDLdX3xpbkOlltOlO1b3ukA47e+DtwhJ4rgezys
ElnH2elQ+VLNkOPyXIfJEixhfEydDuI3z32/DORnTnxbY/+vw0Fn09z3y6/M
dbigdPtn3a8OB441MlFPrs51OPc9+PHS7x0Oe0omS7Rcn+tgBbLva4cDyDid
m3Mdpjl35zz/3OGgC9SvfmeuwyLXbZ//fupwOLXQdVvxA0y+bFSK9f3XHQ6F
QPcpb8Hkw9Rb3/fvnb4DwV/n/rBqym6o+s8QvsjeuQ5hfECbge4BOXP2vrkO
QN+YxgHdC/bf/rkOFfvmS+kD/ZMkEGG55QA0fID+/QFSfxDKB4YH2LxDcx1A
wXCME8GHhSeMDw6faAQ/AxR++Z0Oj4DBfBxonrT+XRW2mk6wfSYHoe5t7HS4
9bMuaw/M/rZOcHiyHIDGRyeUvx8an11QPtA/aSDQA43PPVD7ejsh8bMLwTeN
2+XJsxPBB3nj9DYoH6gfFr7g+Aaar8LWOPXwprkO70DhNbHTQRXIdz6HSE8A
q6Yxtw==
      "], CompressedData["
1:eJxlkm1Ik1EUx1eULYtlNkQks4QkkLSoWCvCExR9MImSQiIiRoFCuIgoi9Er
1b1pZGXsw7p3M19GfhAZJX2IJRkRBRl9iehDRaXYdM6tkqCoc+89eaE98PDw
e87L/Z9z/8t8/l2HZjocDsBXfas9fPOBLwLqr48Hqlo5uFbGhH+GhDtb+zO/
u7n5Pzub9TfA4UU7BuZK+HV38nVNC4eu0JOlfS4Jj7+v2HctSP0WUb3g0I3x
VYUSXpW++3m6k7hYgvfes+PxKOWXWt74fsfVYLnlkouJnevXSBhU/SMc9h7E
DK+EBqXnhuEhkDA0Vfup6ywHVOVr3SKh/HLB25cNljeofjWWdX0FhzRyHtaf
iIeLKt3EHgm7lbA/zOiplLDt4yl3b5IZPWVUP8y0/okiyw+P3SycVWB5ec65
W4MLqX6EmfldtI+vzOiZRzzGoBcT25wS1LGNKTa9/2Sgat3+H5YXq8Hj/8Vj
DO7jmGHkOrXAHgb6vnMkoOwHS6IM1BpK5kgYeI4X2WH0+510XxFm9ptLLGne
+cS3jf6+BcQhZu7fnc17VOM2Btvx/A+fRRb/y9f6Riw71JMQ0HlkU+6bEOlN
CpiIPq32CAbBxvwLAylh5olQfpr6tzPjzzT166B9ZMjvOD+6Yqr2mzD77iG9
yNpvMcu6/pFl3f8wn+Zxte8mDkhH65G1385wM1+G6s9zMx+y9sMlDk2jZasZ
6tN+ZRSfpPgVDr68Ou/aFPVr5nr+cJLObyEes3wS+zkTlrX/RoXxWzP5fVhA
sbpYzuEvEHL6wA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQnTHxbY096zyHC0q3f9YVdDrA+EDSNE4HwQ/j0900
V7bToeKlmmEHkL+hCCgj3Omw5UTZPnk2qHr+TodKoDwH+zyHUJB69k6HqBTr
+/6c8xy028VunmPodAAJv+eZ57DIddvnv786HD5e8k2aIDDP4d8VoMlfOyDm
ic5zyATZ+wnCny+F4D+sElnnrojgL519RGGD2jyHNBD43gG277zWPAcrkEbG
TodlQHkDg3kOf1YCbQK6z8e80/GBEVS9EoIPdo8Vgq8Fcm8YxP3n9ec5NB84
tdA1B2LeBk2of6sh/slXnefgAXJYa6cDxxqZqBSFeQ4yII1dnRD/SSH4l32T
BCLEEXyw+0Sg5nd2OnwCqhcQnOfQ+jpwh1xbJ8R/fPMc3EHmN3c6TM8Taj7A
BY2vGkT8wOIPAPWs1U8=
      "], CompressedData["
1:eJxlk29IU1EYxq+m5gdZBZGSNivChBCJECuD3goRMbEslv+ykiwNrTBo1WIV
KrvHHHNUGhNfaaVDorCokD5IRFn0wcr6UETYHyiH1bCQFU3pnHPf2wEdXMaP
c85zn/c5z11WdaS4OlrTtM38Ef+vCqvml/gRfpzemFXpZ2DyujtPjw+uUTwc
3vG5x8ogZ7TI3cF5vVhfYHDiVQR/7r1fUwm0zjnSNzFSGM+gIJtt2nsNITnz
/Yq4WAauRW+H7T0IzePbB6xzGGRV3s9v7UVofPDsSm4Ug7L9OaPPAwjfhR+N
wcdTC2/m9Sn2PJxMr7iuuLfz0dL+Gwgvl7/744yi/f3kn+tn3O4KBW6R34gO
fHdDTTtCrZcrfNHhMecx72w25/k5wgNoIf6rG/M2kd8JXc4TPoOwRBj/psu8
3jgQSoSBMR22nK/76rDP0G9Q/In7fVKvWOZdixAKDBVkB433dVRTXiHS30d5
TurApz60YQ+CzcInjZDebvITa+RZVIFgH+xenDmP7qec8ktRLO8/Q3GKOOhU
nJ8QvcrlYiBiTC2nvN0MUrmxtWWUbxuDLmG8FOFCUozNcpFB8YC1eXwX9aed
+mJDeCHOX2ZQI+beiTAl+uJjIMYIbUOYfn0imNZp3N/KrZS/T7HZV8l1s1nq
ps/gRAZ3uc3uevJn9vUo9SWO+ngM4eAB/uN9+s1tJ9tpfVo3+uVQLPWdimXf
z1FemtH3cBPdXwy9T0fIE0JzmdGHVgRRa4+F/e+fzDNJsTx/VrGQOdxCebUh
fBDsZXAymLY63kP7L9H8bgTxGQzxvGVfGPn10ffSqPI12czzHylSAqA=
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/SP48VLpG/McWl8H7pBj73JA4Yt2wvkeD6tE1nF2
OuwpmSzRApNn6nToP/RVI+bmPId3Nfamcf86HJbNPqJgcGuegztI/a8Oh1ML
XbcV357nIBuVYn3/e4fDSzVDDp27UP7XDoegHXKtr+/Nc9hQlDHx7ecOh0Jb
ruvKj+Y5LHLd9vnvpw6HCUDz7zzD5IP1v+6AuG8XJh+mHiTsvw/BB9t/EKr+
M4S/5tA8hzA+3U1zge5JEoiwNDkyz+EtyD9A93KskYlKOTrPoWLffCl9oH9u
/6zLsjkG9f8/qH3HEeFhGrfLswfI3zT3/fJjnAg+LDxhfBmQ/bsQ/Pv+vdPz
zndC3AvkT5ZgCeO70wnxL9A+qy0nyvY96IS4B8i/qAR0ydNOcHgtPgqVf9Hp
8B3ontlA918Ayb+CxN/sw/McgKFbY/8Gav4hqHvedjrcAvpnzwEE36U75/nv
fQi+Clvj1MN75jlI699VYXvTiRreLzvB8Ze9A8r/ALXvMiI9AQAsOznx
      
      "], CompressedData["
1:eJxdlGtIVEEUx9d1W7XErCwzad0ePnCt7cG6PiqPhFiUSEaREX4QkzVDISEf
hQSyNZOGSoLF4h0SVILoIRESIRL2oCCj+tATe3xIK11yNRUfNDP3rENdWO7+
mHPPnP9/zpl1heV5x40GgyGf/8Q7xv3zQEosA/7qsZgpvM4pDH8bzSD7S03E
zUkCF1a9ezG5ksHI2QxHgZdA+mDupdYVGD9CwCCecAY2EThMoNPTb90SiutD
BDZ1t3njgxUfLUofHAhQPHnwW4dnVoNi8fwiUDUct5VMadCedc83N04gjCco
H9dgQATOEei33j7lGtMg2v5pozmELrDMF0n/Xbci+zRIvfv0dG888oQGJc1c
0Waq18f3cwl2UtjvpJmfeT1SfwbV9QYyOCQKydb9ObIYOZeCo+D+3gbuz+z1
369y8in4/UwT+xUplnpKFc+/4UprKXzl2zzZgPkuUnjE6xuyMhgVfjdTqOZ+
BFsYVPayNfYrVPcvCuM9FESZ2RGKp7hN0eGK27xdj5+HYr6rqv61IlELBU2s
BzGo63t2LauJ6v6bGVxebTocVq9Y+uOmYBFGm1FfteKHEwnHGiuoPC/vIgaJ
oh/K0G8Tg5frP0zXcv1NPPCjEfO5UI8B6y1GPfPaAsv1GcWy3mlN99uFfk7h
+fL8wq4bf/A8y9FPft68iuaRCsVSf7Viqd+N+/F83cK4RgpJ4g+vx++f9IPr
uSXytVN4P1174gH3V+7fhfVHKm4UxsQolvMSx/T+7MD6baifURBhMXYGou3K
PBi/DfunBedzO/rXoPdfqAP9Pa/3cxfnO6L+GsVyPkoUy+9tiuX8RqF+B/bn
UpyPZIxfQmF3/cnvZ5Kx34OwP50M9gjhJuxnJ94XgRR4VGFTCuo1UnmfVKZi
PwYgpykWcs+lK87rsbhLd2B9AejXTvTTqPvFdqF+k15/biZ+H4LnkYW8TLH/
vpP9yPNVifkaI9Batryuz693CO8/u2LZ70mK5Xkl4v4/iF5fAp7XKJHzty8O
58OHHIvzNkPg//v3L536nYk=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQLd/6OtBCdb4DkNohJ9zpAOOH8elumhsB5UvPd/B4
WCWyLqDT4dbPuqw9IvMdJkuwhPF5dzo8AgofF5zvYLnlRNk+906Hipdqhh08
8x2mOXfnPHfsdABpO84x32HT3PfLj1lD5dnmO7yrsTeNM4XIu7PMd5DWv6vC
pt/pALT1vToz1HwNBP+C0u2fdQoI/lSQ+WKdDh8v+SZNAOpfX5Qx8S1fp8MR
hQ1FGexQ93NAzeeC2scEVc873wGousb+fwdEXhDB7z/0VSNGDMFnAAHZ+Q6y
USnW91kR4QMLLwCyWYl3
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQfdk3SeBG2nyHdzX2pnH3Oh1Q+Is6HXQ3zX2vXoPJ
fwviT0GoR+e3vg7cISeH4LccOLXQVajT4ZWaIceadCifCyIfkQlVz9bpYBq3
y5Mne76DtP5dFTamTofbP+uybHLnOyxy3fb57/8Oh6MKG4pe5CP4P4IfL5Uu
QvDB6kvmO/xZ+fGSL2Onw8MqkXXuZVB55k6HqBTr+/4V8x0st5wo2we0D2xe
5XyHjXPfLz8GdE/lS6ADq6HuEeh0aBe7ee57HYIP0ja/Bspnhrq/Emrfzw4H
oOm94qVQ8z91QPxfMN/h35WKl2pvOhz4gAGYnzPfQRbkkBdQ/6Qj+BMOfdW4
k4Lg+5h3Oj5InO8AFI7pf9UBcU8cVP5tByS8YuY7NIPC8yNUfSTUvm8Q9eUR
8x0uKAFD5g/UfeHzHbRAEsDwPQK0PyNsvsNhkPk8CL4VyP2SCD4sfsH2u2Py
weE7q9NhKyh8vOc7THPuznk+t9OhH+Rwf6h9sPQTDDV/ZaeDC1DZb5h9G6D2
RUHjfyeUHzvfIRQUcIeg8QX0vzsoYo9D4wsYPkBVE99e6HR4BBJORqRnACdK
an4=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLXbz3PfgOfMdWl8H7pBj73L4Efx4qfR8BN+5O+d5
9cL5Dv+uVLxUY+1yOLXQdVvx4vkOGRPf1tgzdjkcUdhQlLF0vsOflR8v+f7t
dOBYIxOVsmy+w+GvGjH9PxD8Ra7bPv/9hOCnpwHB2064/jA+3U1zX3TCzQfz
n3TC7fd4WCWy7kEn3H2WW06U7bvX6QBzP4wPdKVhx0wEv9CW67rydIR+MH8q
wnygcg6dyQj7kwQiLE0mIdwH48PcD+PD/AfTD/M/zHxY+Fjf9+8Vn44IP7B/
ZiLCFz38AYh4w48=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQXWDLdX3xkvkOlltOlO1b3ukA47e+DtwhJ4rgezys
ElnH2elQ+VLNkGPpfIfJEixhfEydDuI3z32/DORnTnxbY/+vw0Fn09z3y5fN
d7igdPtn3a8OB441MlFPls93OPc9+PHS7x0Oe0omS7SsnO9gBbLva4cDyDid
1fMdpjl35zz/3OGgC9Svvm6+wyLXbZ//fupwOLXQdVvxJky+bFSK9f3XHQ6F
QPcpt2HyYeqt7/v3Tu9C8Ne5P6ya0gtV/xnCF+mf7xDGB7QZ6B6QM2dPmO8A
9I1pHNC9YP9NnO9QsW++lD7QP0kCEZZbJkHDB+jfHyD1k6F8YHiAzZsy3wEU
DMc4EXxYeML44PCJRvAzQOGX3+nwCBjMx4HmSevfVWGr6QTbZzIZ6t7GTodb
P+uy9sDsb+sEhyfLJGh8dEL5E6Hx2QXlA/2TBgI90Pjsg9rX2wmJnx4E3zRu
lydPN4IP8sbpDigfqB8WvuD4BpqvwtY49XDLfId3oPCa2OmgCuQ7L0CkJwDV
yisv
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/fGSb9KEV/MdLLecKNu3vNOBY41MVMoPBN+lO+f5
bsYFDhkT39bYz+100Ns09/1zVii/o9OhXezmuXLOBQ5/VwJNKut0ABrJ4MC9
wMEKpD8Rwb+gdPtnnReC/+9KxUs1q06HvSWTJVy4FjiE8elumqvZ6RCVYn3f
n2OBgyyIIdHpYAhyENsCh9bXgTvkODodgKreL2eGmve7A2y/OcMCh0Wu2z7/
/dThAPbPz/kQ+VcdYP88+TjfIRPk3mcdDiBr8l8i+PIgg28j+CBrz1+Y71C+
b76U/scOh6WzjyhsODEfYj97p8Nl3ySBGwfnQ9wr2Qkxb998h3c19qZxemh8
VwRfWv+uClsYxP8NB+Y7hIIk0jodQME0/wjU/PJOh4dVIuuOA+1zBzHaOyHh
fG6+w4YiIGsyRD/D1fmQ8Jnd6fAIpB7oflCwHFsMiY/vjxDxhx6/AJf66+Q=

      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQINz+c7WG45UbZvVqfD6YWu2z4/RvCPKGwoyngw
3+H89+DHS2d0OviYdzo+uDPf4YLS7Z91UzodxG6e+x58c77Dn5UfL/lO6HQ4
BdRffG2+wyKgMX87Oh0yJr6tsb8CVV/X6VD5Us2Q4xJUvrjTgU9309z3F6Dy
aQg+WD4UTd6602Gd+8OqKZfnO4SBJFSg7rkx3+Fdjb1pnGCnA0i5+r35Dq2v
A3fI/etwAHlD/ilU/5cOhxl5Qs0H3iL4SQIRliZfEPw9JZMlWn7OdwAas/zY
zw6HZbOBIfB3vsNbkPksnQ6vgM5/w7DAQVr/rgobf6dDOygAGBc4NB8A+lwR
wQfbb43ge/IwabdHdzo8A1pkCdNf2ukADn+gfaEg/7R3OjysEll3/AvUvilQ
/jtEfKDHFwCu8+PN
      "], CompressedData["
1:eJxllGtIlEEUhjeRMovSdNcordYVy2zVtbZSE4+kJIVESiIhFWtCQdjN7ksX
TP3GCyYLBYUyJiJBRElEYEVESARpZFARIeEPMTMp2xYrpTMz53OQ/bHs9zC3
877vmbF7jhRVhFgsliL8if+tDYeHz6/kUDO669GKywz2HMga7E/gECs+bjBI
6W4dH07ikPHg5amnXQyeVPmWvkjRfCv/4US2S/OOTSx3/3oOB1vGvDmdDEYS
XWHr3MScQVJZ83P/RuKbDI5lh78v38xheernhLk+Bp6I0oyqDA67Fzm7W+sU
b8jksO3Luei7FxnYPvYFfMhv4j9NXjihWdQx5dEs9Vg1b18Yklw3n8G/2z/e
vkYuEPvNUXrysjiUiPOmDPjuzXG3IV959qo9/4+hzt/CoS9QPNQZMOAxzg/N
5pAp9PoNiMH9B5CvCSMnDBDDJTlUz08D2sa7ehtygzlO+DtqQB4u+7s2mM35
X9G/b8mz1y9I0bwMfatN5VAt6v1lALq7piyN8vttSL/dLtI/aSj9yELnXtQr
/HekE4cwOIuBFSCPCQ5lar90yiNcs+mvybL+fZoHdzZdrzxK/eSivLxM6utJ
o/qrGfQLX1NpvIEpP53UH82UT7JmkWfxas1ifYWD6qtlYPaz1HNSs1mvydjW
Xb1hDJziA3n63ZmRROwHme8qDofE/tMG1OGBp5Gn0LdC7IerqC/WTvoClI+d
+sev8uuJJz8mlL/lCTovwUOJwWzmL/VFBLM5X3Lk7PUdUZplv1pJv5/61Ub6
sf6BQk/EBxv1B+qT/sbQefPYDJt+zRov1Xxf+Fep7q/DnO9VPGSj+ZcUd9jo
vtUwwCfHAsj3jmOCBvWDlfKrV++D20r918hUf0dT3k1M+n0nSrNcv0SzvL+R
xI1sxj+ZZz29B4vJnxYaj9Pvl9kfJv8H4d1xBA==
      "], CompressedData["
1:eJxllH1Ik1EUxpdYGLggCgvTUaFRSoqGhBR4ikyn6ZyuWTo3FbUksJKyD1SI
Mt8rmEhBhVRXTSUIqaiwIBGLiECt/qsokdCSpSW1oijs3HvP640ajPHbez+e
85znvKtK9+eWB1kslp34Fb/TtSlJb0s5JN9+UtPfw8Bk96L1ty5VMljnaRlM
KtHc3fZo5Wcfhwa/s89Wx6CgbNOow8vlPm8Tg0Nnlwe7PcStDDI3si3FBRxG
Hc3nqy7Q+fkcOlLvfvndxuDXtZkXQy7N7fhbl6tZrL+cwyEjNCi28SKD9LHj
S+McpOccg05c9yCLQxr+39vCYEX8m6gFyJWtU7UpTZr3Cj6lObYx7OVwrbq/
OYv01dB92VTfQQZ4y6ceB52/j8E89GzAyeFGNZ5YzmDke967cdQfKYzwkT4P
6XMyiMP979FPu9C/Td2/vYLDkf4r4fEbNMv1kZqlTiuDYPGgjMMw3tM1ayi9
2I/nq1//qA8Y8r4q9F/67lc8XUD1T6j11nzN3vv20K0uzfdsDf7FTvLng6H8
N/36aMCSkwNPS3ZweBhY62mZoueZtH9anT+UofnY5JqEkL9Y6rNT/Xie7Gs6
+TtpwJTISdr/LPfHsLn1Jsv67OTHMgYxmM87meTfQsqf2T+Lym8gh/r3zVD9
yqN8zSiOztcs8n1gt2ZRX1Yhl/f2fjVU3jx0/k9D9ifRS/XNkv9e2j+fzbHs
l1Wz1B+m8mYz58dG+TfzE8Wk/2PYzwiRL6q/F/XexFg+TqR5wnmRvm1WebZm
Uz5TKZ/Yj0HRv2zF5Xby003P02geihRHI1eIzx7Nsp7qf/iE0lOVTvWfoX5l
kH6c9z7MV6s5nx00Dzn6fSPXuzTLPLk1jz9D43ZxOCrmpZtBOM7F6ULyv5PB
BD5PLiJuZ8oHLzHXfpss+lXt05wQcj3ilY/yzam+YupXu8rPYWQho75Dve9G
imn9Vf1+NPX+AY9glh4=
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQ/UrNkGNN2wIH2agU6/vdnQ4u3TnPfzcvcFjkuu3z
36OdDoW2XNcfNy1waH0duEPuXqeD+M1z3y8D+Q/8e6fnPex0mPd++bHTQP6m
uUDGEwQfrP4Fgn8fpP5DpwPQSgYHoPmePEza7d86HV4C7ddpWeDwrsbeNO5X
p8OEQ181ZFoXOLQcOLXQ9V+nQ8lkCZYwoPsyJr6tsWfoAsvfaUfwQdZ6dyL4
zkD3V3ch9IP8l9ONMN/bvNMxoQdhP9i8Hqj8RwRfBhQerxD8UD7dTXPvdzpU
AB3cAeSngcBlaPgAzc8E2X8MEj7CnYjwBAA+kLE7
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQnSQQYVlSssBBNirF+n53p0MykL+lcIGDDIh/rNOh
Xezmue8FCxyk9e+qsF3vdJhw6KvGHBj/EYIP1v8cwX9bY28a96HTYd775ce4
geZ58jBpt3/rdHilZsjxBsh/B5L/BZE/XbTAoeXAqYWu/zodXLpznv8uXuCQ
MRFoAkOXgzOQX12K4C+bfUThQxmCf/578GPVCoR+kP0ylQjzSydLsIhVLXC4
7987PQ9oP8g7k4H88n3zpfQ/IvihfLqb5r5C8B+A1D/tdCi05bquDOPf7HTY
WzJZwqUSqv4YVH0ZIvwA/sKlKA==
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAWIQXflSzZAjepbDItdtn//+bHeoAPI7YmY5hPLpbpq7
q91BrvV14I4IBL9d7Oa57+GzHDbNfb/82FEoPwzKP9vuIA9SHwpVf6nd4RXQ
+DXBsxxaDpxa6Hqr3QEk/D5glsOGooyJb+9D7fOFqn/c7vAj+PFSaa9ZDs0g
9c8h/NmusxxAxsq9bHcAu9cBwQfbr4PJt9xyomyfFII/WYIljI+r3WHCoa8a
d3RnObg/rBJZ97/NAeSc5fpQ+3+3OSybfUTBwGiWg7T+XRW2b20O1vf9e8XN
ZjkAXVtj/7nN4bJvkkCENYIPcw86XzYqxfr+6zZI+LFh8mHqwf7nRvBv/6zL
shFE8EHOdBeFuvcb1L3isxzCQO792wYJL0mo+YztYPfdAPKB3ozp50bwYeEB
48PCC2weJ4IPMsafGZV//t9Mh39XgC59AVGv/memQybIfc/aHZYCw2vDj5kQ
84HxB3L/nq8zHaY6d+c8v9cOcf9nqPx1aPh/mOlwGOS+C+0OQN1FGe9nOsiA
LDrW7nAUyH/xbiY8vYHtez0TNT2+mQlPrwBOz15U
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQPeHQV407ObMcLijd/lkn1O7g0p3z/Hc+gv89+PHS
2UWzHP6s/HjJV6Dd4dbPuqw9JbMcFrlu+/yXu90BrL9sloPllhNl+9jbHYJ2
yLW+Lp/l4MnDpN3OhOC/rbE3jfvTBue3HDi10PVbm4P4zXPfLwP1T5ZgCeP7
2ObwUs2QYw3QfCuQeW/aHIBOZGgA2n/fv3d63os2B441MlFPgO7LnAg08Vmb
A8z9MH5UivX985kIfpJAhKVJOkK/adwuT55UhPk+5p2OD5IQ9s97v/zY6USE
+2B8mPth/FA+3U1zgf6D6ZcFWQz0P8z81teBO+R42uH2g/UDww/mPlj4ooc/
AENHxAQ=
      "], CompressedData["
1:eJxTTMoPSmViYGAwAWIQvc79YZXI9lkOi1y3ff77s90hWSDCcsttBF/s5rnv
wXqzHd7W2JvG6SP4GROBIqcRfO12IOt2uwPHGpmoFN3ZDv+uVLxUe9busKdk
skSL9myHTJD6V+0OpnG7PHk0oerftzu8VDPk0FGd7RDKp7tp7ieI/ifyCH4S
0D0m0ph8mPvAfC9MPrJ5Ka4I/iugfWvsEfxCW67ri62h7gW6R5WtcaqzJdR/
L9od5r1ffuy0OdT8x+0O4PAC8v+u/HjJ9xaCDwsPGP+C0u2fdc/bIP43RvBP
LXTdVnwLGr4H2uF8yy0nyvZJIfiTJVjC+LjaHS77An0EjA+Qsev+t4Hdq3x3
FsT9vyH8xfdnOUjr31Vh+wa17/EsiHs+tzmoAP1z+AWCD3LflLeYfNmoFOv7
r6H8fZh8mHpw+B5G8F26c57/PoFqnshZqHu/Qf17fpZDGMi9f9scTgP5ny9A
zWeEpreLsxwOfdWI6edG8GHhAeODw+9auwOQzNoDNB+Y6h4vvd/ucAvEPzXL
wQNk31NI/G85AbXvBZR/DBper6H6ge5/B0rP79odxIHp9/J+qHs+tDscVdhQ
9GIvNDyB6QPsv12z4OkFll9gfAC5LJsl
      "], CompressedData["
1:eJxlkw9IU1EUxqfpGjFWgTBJW//MhBKJkjCJDomIxIgMzGwt0pWV1cistHIl
snfBYc3Ukh0isnRJtcKGSIhEkUSBVAbRPyyKclgNETFpSve+d9aFHIzx2333
O9/97veWlDgL9sbqdLpN/Ct+j26Y82bZDYRfZzZm2tsYRDkr+PRE3xrJAxPb
vrRbGBhuJxc7OK8X6/M1/sq5Lbd7bMpI6+0Ikc7RV1YDg1DqasOqDoSkjI8p
+ngGy/W1LTl+BPfI1h7LLAaD1pJ5RTcR6h4+u5Ybw+A3H4OdCD+FHx2DQN7n
Uwm3JKd3XQmvuCM5x3Po++m7CC+Xvp90xdDzXeSf63PV7mP3yW9EAT4ta20r
woFGrvBNgVLOwaaZHD2P99F42gcP8R9FO6+b/I4q6nke1yIsLHZkD/1Q1Lyu
1yAUCQPDCnA3gbxqqS/mByslC7/NTslq3uUIYX//5nUhbZ6jjPIKk34p5Tmu
QLUIeA9CoYknEyG93eQnXsszyY5wsu/qgoy5dD+7KL9kyer9p0tOFvtdkvON
sSsZY1DQY3GP2CjvBga9lU2JcTbK18sge2hLg3knAv+30NTMYJEwvoP6c4n6
sh3hhdjfyiDT/iDfWIgwJfriY/Bu0nWwtwBh+nVVKBUZPOf3N2al/H2So31V
+fBM3i/yTPuPzZr/cif5i/a1gvqipz4eRyjbxz+8T08W36sYrqL1aS3fhBrJ
qv5ZyWrf6ygv3s8U0Q+F7i+O5tUjCJnAbKb14TwCr5ntgon965+aZ6Jkdf85
yTzmy0fqKa+LCJ8ENzIwvx2YGPTS8y10fq7PXxt/P89b7YuH/ProfXHLfKMc
zfMvR8/tmw==
      "], CompressedData["
1:eJxlklsoRFEUhscoSZIkkoxISIM8KLeySpIkUUqSB1FCKQ9uSQpnK4QSZTeJ
F3kRklDkNkyEcc913HIZhhBSbnufs6YdHk6nb+/V+tf/r+2TU5yWp1apVCHs
4/+KG/8w+20K91Wx4dnHBH5xL4HN5BznDPN/tnBuF/V/uf42dUyjEVw3vdQT
70KgdfYl8NDKDgTK2X3DLtbbETh4ry6I2aPgGXrkZ6cmkDamqS88oNAbP/r8
+S1BtCml2f1YsO6hbyHpRLBcf0bho/9xI9mGAHHbWy27wHtbAsyyquaSQuSI
oXSK6cn9rikM8UZsHm82SMQNzuNMIHhY9xBgEZyZG21aMyPb4vxXqPcuwWml
60DCOfZ/khT/JgpfW6zyTgJ+3L1PwYs3ukY/O4LDsycSHTcFP22wwI0UWGxZ
LWZJmWcF7y2SktcShVqe5yPWG1DvVQLtMDdGwejLKj9wPj2FIB6MWvHfOU9h
jvd3FBzFB/UQbN2vrD/6n+V8uzCfcQodcY1FVzoi+2maRD3r+5nB/v0EeDxa
PfIg6hlw/+PIyxTSnZjSLO6L+U/gRhZxX2sUBkvy2yxGZd9v6+I9/wD+PHJ0

      "], CompressedData["
1:eJxllX9ollUUx9+tCB2ytFyatrWsZjhrao4sBU/IfHVTlqNGKZpsatsck4a5
pduYLJ+b892aSCx4rimajiBiRMSIkAh/BEFF9Yf9QuufMlFL5+bm3tG5536f
HV7fwRifnfuce358z7mPVO2o2JoZi8W6+df9NQ/8/G1TtqXc9VuWXmg3tPRC
edeMHEvNp47MKuo2FHM/D1oqdAffNfTwvsvrlsyy9OynX+861WvoUsHCSfNz
YbeGyp7Z//zmfEvPOftRQz+urZp6/lFL38/5daTtuKHD1/rOls21lPzwvx/W
njSUx/4G5sFfH+5/Svl9Pv/N08pyfomlbe7nA/hfhvsOG3JhDJOl8Z+aLxX0
+ngHVlgqnZJZaLrgv0TzlfNllj5xgfUYeq/hvo4v11mqOXilZXno7U2V4KPI
dwP4BOqzWeMTf1uUJb5a5Sf5orkN+v2Z/P7Gv19X/87e94be7z470mzJpZF3
CP52I36DerbAzvm86QJstTS76PfH7tmp/FI2e65WlvM5yqv+2D3948mG3LEd
rfCfYcj9O95mqdIZkoHYrzHHnWE08PVot9Tk9HIr8Pnvhf+hwNezA/EMBnQi
PJ3fH1g6VvLZjeT1QPyf60xnuf9y4Pu3MZ2j866fva8qu3a0Vyuzyqp6tlla
7fo/CP81qMdwQM5teR36PxJQxUDevu3boZ+k9z+jHvrK8PV/uR7+74I+mF0Y
DVnKUX0jjuqfcr7R+Pj4vv5G13FDf7r4avF9h6GTXK8Fr+H7A4aKN32+eko1
6vEO4tmoLPPyirLoiPV7aObdldndmJ8KzGMn9FyOfAJDa3h+L5Yivnbojefl
Iedvl5+f3hLUY6faJd76OzhHWfQzCfetxL6Iwb4S/rjeLr9EHPPC+ur56uYT
v61SfUn/SlVfv4y01X2xRvUlen5B+z/fNfbFdI70xF1e+HZBOqfop1BZ/Bch
Hr5P5ncB+jPk9fTdIsTDepJ5X4z8x3Ce+WrL8uJNrCfuQt2yYnzPeuLpaKwp
xv7NUo7qGXGkp4gjPck+WIzzrdh3i3C+A/Uvgj0BO+d3xcXTg348riz6maMs
+snDfd14D2bDP+vpH/b/UQ7m6S3j52ka8mmD/rNVTxGnzEvEvI+k/8xj7r3I
wH68V/Wy4kD9X3umYl5HsR+mIT6eb5mP+1H/m9hP09HvG15P8Zmp+yeem86R
PqSf/4ZpHJ2XfTKoLP0dDifuk/7fCifiEX2Nhinxnr8d+veR85F6j4VU6/ow
jn2XDH2+mdjf46Gv92TllP3OLPVefwc34H1kfzKPe6AHZqnvXrw/fL/sjwDv
1W3wfjDHL/PaCR4J/fuc8PsqwfmKjrqgryFl6cegsszzdXDCTNRX8mf/Mr9X
Qz8/B2HPSn1/nX4i/h8ctkCi
      "], CompressedData["
1:eJxdVAtIVEEUXU1MC8wisq9aWUZSFhRmEt4IMSiRikIlIjYTJXCpjVIJIcyZ
vqioqe3oprWZVJvG7iZUJuanMtSyWs1M+xBarZIWEmU0M+/aUA8e+87OzL33
nHvuLNQbtu931+l08fwVv7aHR+rMzQyyP2+r9fekkJznOhZ5j0H024yZ1jEC
W8JObdx7mwH/d+2eYQI68dhxv4tAY2D1oeQaBiF0VnfbIIGIvthzRTdwfYDA
12cx+twqhQP4x7pLCt89nD/bo4xBkni+EPBZcat0uIRBRZRjdPwbgc4YvW9X
IYP2sR3vLeMEEhIj+trzGcwL7Q3y9KZ/sYznR/9dD0RcwCBcEA1GfJ5BiuC5
kmr18XySdxgFQTu6DPlHUo2vhcFOUVg0heLUGVn11xDHUmgt54U6GPyq4pHi
KUzouV58JCos+RxQ+PfztMGlmRSumBoDVzVhvNNafbENDIaE3nlU6mG4z+Bo
nXluaDHV9LuD+03a+Wq7wkLPEzUK633jwtdYMV6Jqn+BSFSA67w/WfWPy6Ny
tXzDlQx4V3b5nFFY6pOt1R9wFfmlK9zwfdnuHCOV/Yrj+5cLP6Si3ly/jkU9
PzI5/yWexws3XcZ4ycinAutNQj5mheV6qcKyXhPqzc/bhZ4l2F8e3yoaV4zx
DahnEQPu0jyXUWHJP11hyT8b811gIFg351AY4f7wvaj0k3pwPjdFvAoKBzdM
cS62Yv5KChZRf63CQZzvg3qF5by0oD8t6IcnyM9Mgbti9ckOBmKMUk24vxP9
U4Dz+QL5naXAq3YYX6K+BOt1MqgR9WcoLOcjRWF5PkRhOb9zkL8T/TkN52Ni
/1QKXtfnJ3xwov6T0Z9dDDaLefFAP3fjfTGJggg71o183Sls5fdJ/yvU0w1x
j8JNnO/Aa4X9+PHOXqzPDfV6g3ryeOlcL69+5M/z+wui7/C8N/bjI+LpCk/c
d9KPfQzSxHyNEBDtDe5CvgN4/z1VWPq9TWHZr1bM/4lofnyE/RoisI/71daC
8zFKpH9tzei3nwT+v3//AEapuGM=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQveVE2b75x+Y4tL4O3CEn3O4A44fx6W6aGwHl75nj
4PGwSmRdQLtDoS3XdeVtcxwmS7CE8Xm3OyybfUTBYPMcB0uQQvd2B5C292vn
OExz7s557giVXzXHASi6/Jg1VH75HId3NfamcaYQ+Q1L5zhI699VYdNvd/h4
yTdpwhKo+RoI/gWl2z/rFBD8qSDzxdod2sVunvsO1L++KGPiW752h6gU6/vn
V0DdzwE1fzXUPiao+nVzHICqa+z/tzksBclvQvBV2RqnHt6O4ANlizL2zXGQ
BRnMiggfWHgBABrjnQk=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQPeHQV407DHMdLijd/lkn1O7g0p3z/Dczgv89+PHS
2WxzHf6s/HjJV6Dd4dbPuqw9HHMdFrlu+/yXu90BrJ9rroPllhNl+9jbHYJ2
yLW+5p7r4MnDpN3OhOC/rbE3jfvTBue3HDi10PVbm4P4zXPfLwP1T5ZgCeP7
2ObwUs2QYw3QfCuQeW/aHIBOZGgA2n/fv3d63os2B441MlFPgO7LnAg08Vmb
A8z9MH5UivX983/nwPlJAhGWJr/nwPWbxu3y5Pk5B26+j3mn44Nvc+D2z3u/
/Njpr3Pg7oPxYe6H8UP5dDfNBfoPpl8WZDHQ/zDzW18H7pDjaYfbD9YPDD+Y
+2Dhix7+ALWnxLg=
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{1477.062, 2169.7022050000005`}, {
     1407.3709999999999`, 2169.698205}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0015994324417357268`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     1447.7854480251121`, 2169.7027806356846`}, {1433.1479605713519`, 
     2155.0612681927605`}, {1484.382448025112, 2169.706561691336}, {
     1433.1449356855042`, 2184.3392681927608`}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{857.004, 2313.698205}, {1344.086, 
     2313.698205}, {1379.539, 2313.698205}, {1408.086, 2285.1552050000005`}, {
     1408.086, 2249.698205}, {1408.086, 2089.698205}, {1408.086, 
     2054.245205}, {1379.539, 2025.6982050000004`}, {1344.086, 
     2025.6982050000004`}, {857.004, 2025.6982050000004`}, {821.5469999999999,
      2025.6982050000004`}, {793.004, 2054.245205}, {793.004, 2089.698205}, {
     793.004, 2249.698205}, {793.004, 2285.1552050000005`}, {
     821.5469999999999, 2313.698205}, {857.004, 2313.698205}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxlVG1Ik1EUHoZSVpZkq5Q+DHMqikSIiwqPmUiYRY0yRSVFwUIo+pEWFUhJ
SsmuxKazZFxiRERiA/sRbjo3XfYjzIo+xD6RkggpMhO0Onf3vF3dBu/u+3Dv
Pec5z3nOG19x8lBVmE6nM+Ej1lq3PTZ9ygxjCRH1q4c47Hh3oHlNGgvBmU3Z
x8YHOezDl/fJCnc/OuO2G5hcET8rqFh5NJHuI84oe7h32RYGWfjSNMDBt6nr
dHUCg3hcnvoUxv+Wb16Fl768dWqun8PHczGdfu2+h0PdROLWxiQZ39LLwdw/
lVSCfJJL8M3NIdXZMXk7hcH48ObRGRfFS2VgRL6OHg5X9K+fTG9jMHvn+0jz
Aw4fRPydaj9wfjeDS32PeUMfh40NXw8acyl+fxD2KiwKHfLJeq/tYRCJ/C8M
0H6OzLdc0y+bwZGoNGcH4tGZiyd6spSeGp9gvKAf5aFYO48qns8qJT6IRZrJ
IllPLmIBDYXy/mHkV1yJEUwMjuO9v16Kt59Bu81mW+eRetXmKX0CfIwMCjHw
mJP6YaJ9O4cfI2iAYgY/557XTbRzeCPqK5P9jm6j8+Wy/vWt1L9KBtacqzUG
Kwed+FWTnyyUv4b6MQ+LequuS7+92h6KtfP5YmOXwr9NnxxxIPN9RnwW+SzG
ft9H/92zEj/sl8iT2SrrzcN+BnSch9+ifi/aFBb69drIr9jfy5gv/GaQv+xq
ngL13yW+cWo/4B899RfvD6Afv6ySfKZtCgs/FczDIl4p8fHHMPBj4fWtVI9e
zpPLSnzX0nxZ6H4szZOF/L9B6aVhTd9GtNnwL3MIXqD3rBlScD66LTSPOgYr
UL90yu8Po/mxkv/DyW9t5JdI8mM76Rmt9Anw1+a/M6h+F/U3ioGg3eKh79MS
mS/DR/6JoHlA/yO7wfxFMn8RzofjBlb8x/x/nrTvo4b/AXxReUM=
      "], CompressedData["
1:eJxFU3tI01EUHkXvB0GvvzKLHgQO7A/JsOiERERFJBQVESUFoweFUGpm9Boq
Jd0lzraaeok5IhtrUG1SosPlA3Jl2pSVv21lZaNs4RA1sHN3z7iD8ft93Hu+
853vfL9V+efzTk3T6XS5+BdPf7qr4McUg2cFBtPTrxyKhtdtLJ9uguyK7cft
nRxS5yn8t2dv/qJJBt/erQ5533PQu20j60cZ/Hsc76kMEo4xOLhQ714RIhwl
/kEOuzchUZDBhqN3fRfDHD4gXX+XwgbTryvbWhROM8b2e14Qn8ZhJeJsJwMX
8p37JLHHzqAdiVsHOOjEr47B3OCjC6V9HHK0fZXLrbLeFqD6arqP80QuL3G2
32MwhPMU+xS+2dLF/V6FP6+Zeb3aTXxYb7VYLIcbqb9Fni91yHkO1TI4cjJH
C3BZv9NOfDby1ynnS1g5RAX/S+nv2vtU72MwD/W/NpPeboXFeNf6FRZ6aiIM
tuAzWMOhbNlAd+Gw3McCK/kdZ/BGvDyk/U3QPuvVvoWeLAfta5YJbqHeGQ0c
Gh60pWdOkd5aykOCSd0Wmi9GfqOeDKx3hGU+NldxKEb+2b3kn4lDG9Yb/Aon
9TxR2I79XGYm5zATf7nk34p6c2+f/V5SSv0ctI8iBpB1rGmOS2Ex9pBX4UHk
72vl8LzjUnNdCeWpk/J1g/wMUB4rGCzGhZ34SPerWFJHWYj46mX+9JhHbLvr
TiP5H+Ugxs1oUt+TmGOsQ+E8T5rxTK/CofGrp19pMh87vpC/P1X+k/7/Jn9S
/f5QXjTijysszuePKrwHjQgnJL+R7heOUb8w5Wlc8h+IcBCfyciEzM/bKOVz
Uun9DwcAGvw=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2Iw3fo6cIf3RAeLTseEpacWOrSL3Tz3PRrBZwCBzIkO
USnW9/uPL3S47JskcKNoooM5UD714EIHkH6L6okOW06U7ZPfs9DhiMKGooz6
iQ6KQEpwG4LPdX1xge16BB9ITsxdtdDB+r5/r3gt1PylEPvLK6D2L1jo4AO0
6EHxRIdnF5Ru75y90ME0bpdnT+5Eh+Pe5p2MM6DqUyHm105d6OANcljsRAdu
IP/vpIUO/Ye+asSEQPh7J0Lt90Lwb/+sy7KxQpPXnQgJhykLHY4C+S+Uoe4F
2g9y53npiQ7hfLqb7gLd96hKZN1x8YkOmjFAm5Yh+FpA/ta1CP5WYPjM3wQN
LymI+xu3Q/0vP9EhDGhe7B5oeKtAwwsYvkDhuflaEx3uqbA1Xj0CdZ8RJHxU
j0P9B3T/U2D4VJ5c6DD3/fJjp50Q8YcevwAZhujA
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQbX3fv1fcY6LDPRW2xqvHFjq0i908990ZwZ/3fvmx
0/YTweLmQD5I/XTriQ7c1xcX/D2y0CFoh1xrtvlEh+Pe5p0HDy90MI3b5clj
MtFh1kwgOAgxr9xwokPzgVMLW/ctdPAx73R8oDfRgU9309z83VDzdCHml29H
8MNACjYh+H9Wfrx0dtVCh6WzjyhsMJjoEJ1ifZ9/yUKHowobil6YTXQAGpuQ
Om+hw4/gx0ulbSc6ZE58W7N/xkKHuUD3e7tOdNhQlDHx7VSoe/wRfLB7wxF8
sPrYiQ5cQP/VTl/oIN/6OtAiCeqeWQsdtpwo2yefDvH/3rlQ92VC/Cu5GMHX
iuk/tHUVgg80vcZ+y0IH5+6c59WpUPcB/f+wSmSdO9A+TaB6U2B43f5Zl7Un
HML/Cgzfl2qGHGsCEPGBHl8Au//eEg==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQrbNp7vvlayY6/Fn58dLZ/QsdKl+qGXJsn+jwqEpk
HfvxhQ63f9Zl2Rya6GDR6Ziw9NRCh4dAcfdzaPybCL6Peafjg0cTHexN43Z5
nljoYH3fv1f89USHuypsjVMPL3QA2nbM+/NEh60nyvbd37fQ4YjChqKM7xMd
+HQ3zc3fgeA3Hzi10HUDgp858W3N/mULHT5d8k0S+AgxT3Q+VP4JVP3MhQ4f
gfITgO7JAKq3n7LQoV3s5rnysxMduK8vLtg7EeqeAwj+ZaBxN3Yi+M7dOc+r
N0PCw3cSNDzWTnQA2jIxd/JCh+/Bj5fOXjbRAWTtxClQ+QUTIeEwDRoeMyH6
e2cg+KDwUb2A4IPdd22hgwvQvt8zIP77fxPqHyAfGIwJqbcXOkSlWN8/P30i
hL6z0OEoUP7FNIh/j95d6KALir+pUP/fg+qfMtHBARj+J+9B/TcJ4h7e+5Dw
+D4BwQfFx+k+BB8cvj3Q8LgHce/xjokOYcAIkr0HsU+9HeqfBxDzI5ZPdNCK
6T+09dlCB1h6gvEBif4/zA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQrbNp7vvlayY6/Fn58RLvnoUOML5mTP+hr7MXOnwP
frx09oaJDpkT39b8n7nQQa71deCOLRMdmg+cWtg6Y6FDu9jNc993QPnTFzpk
ANXZ74Xypy102HqibN/8gxMdWoB8ViDf+r5/r/gxBP+lmiGHzlkE/1GVyLrj
lydCzAWad1RhQ9GLmxMdwvl0N90FuufTJd8kgQcTIermL3TQBbpX/fFEh6cX
lG5XLkXwwe5fg+DfU2FrvLoZoT8MaJ7sToT5IP+f3YOwn+v64oLaAwsdolKs
758/M9HhLlB/6KGFDpUgBx9F8Ccc+qpx5wCCDw6fPVDzDkL8Ox0YPtxA8/Ye
gIRX+Vao//YvdHDuznlevXGiw1QgI30fIvxh8QEAgDvjRg==
      "], CompressedData["
1:eJxVlH0s1WEUx9WWQqFIk7zc5qUmK7XCUKdiZpgw7xKWlSLVH1GrNiuTyeSR
5F63PBVmM1OtvO3qztvFH9XUpmZNaio1u1OZrFqd+3uOPWO77j73+f3O8z3f
86LKyo/NXm5mZpaMH9P3+WlP31UhDPxL92d4aDgoHMDgydC5nolbHH7FfWxw
2smg+mBZ7rGbHCYv2LeGbWdgNXb/tK6Kw/fRqCxbbwYe5kXVfYxD4ER0eY0n
gyv6ER6K/AqP36gkx3a4FJ/cKFlrbBqMsGewb3d6VynGK3F4+7zAhsE7d/Oi
9Xi/SU6LpdBz9zbdv4opz81rJCdY+zxyrpes6LvHAX/W5lswyKmcufjvAYcP
eG6wYuCH+U41cggpy/3825pBytHAiYpmDigj/DrqSUW2aSE9m8Tz2a2k313E
e9Ym/NH4MlDX4t9j8g/93JpW0Tv3VLKST6dkRVcPV+6NPiDed+zlMODWdvbL
Xnq+n0MhPn8tkHiQ/N1DbBC8YYdkU/ht3pIVP7wY/Pj7ujAH3+/H+Mfd6XyA
/FFRPn0i33lXBp9ebh4P6JVsqlexngM+bvRyI791klUYNqabw/jC5RNBriI/
Yyfd50x+dHCYxX654cRgCuMvtJNeRwaWWK9LyK7F32L8HSSb+ifJTrJSL1uq
Zzvdj/1yFfWt6CQ/1zAwFdKii+5fzQD/V+Z1L2UfnWSTTyV66lcbkZ8W/XBB
PR0O9P6i/85CT/Aw5esl5qdhROhp2rWUvYIlK35i/YMwztgw1S+C4g1x+Grq
92im9OlKA81XHIN1WADVANUznsGf5tnRcqxPgwYzSGBgh+eTesonkQG61HxG
J1mJ3yFZ8atR8k/sj+l6yi9R3G/Qkt5E8qOO6pEk5q9AQ+fIeXjfQzX5lyz0
RSHXnELlKcK/mVpRnxepNJ+1NA+HJSv5pUvGrtmSdoT20eJ5Bu0rNc1LJvmr
Jr+yRT+uraN5z6H63ZG8ZN9l0j6qpn2TJOYjnlH9D0mOxEXwPlKykk84A0OE
X+myKprXMDpf3JehDObQ3+Zq2qc0/8YauQ8W9fwH7NCdwQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQXflSzZDDZZLDhqKMiW/nLXSA8c07HRNSNy90uP2z
LsvGYpKDg2ncLs6NCx22nCjbN99gEpiOX7/QQb71daCFLlT9uoUODCCgPsmB
X3fT3PVrFjp8vOSbNEEJIv901UKHowobil7IT3JoOXBqIevKhQ4Pq0TWuctO
crAAyqsuX+jQLnbz3HfpSQ7W9/17xZci+OF8upvuLkLw/6z8eIl3wUKHrSD3
APV3AMW3z4XKK0DVz17ocNk3SSBCZZLDcW/zTsZZUPdqTHK4q8LWKDpzIdie
6ToIPtCbnj1GCH7/oa8aMVaTHB4B3ck+GxE+sPACANcHkhE=
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQDQb7Ox3MOx0TUq0XOmRMfFtjv6XTYUMRkOW50EE2
KsX6/vpOB82Y/kNf/Rc6bDlRtm8+kO9gGrfrZMBCB/27KmyNQP5WkHgggg9S
XxqE4NsD1XeGLHQAGee/sdMhGkjzhy10ANu/tdOh5cCphazhCx1m5Ak1H9jR
6ZAJdMd/IF9309z3y/d2OnBdX1xQG7HQYTpI/jCCbwAy/ySCD9Jnfw6hH2z+
JYT5QG8+vXAVYT/YvOudDs1A+aMhCL4FUKFqMIIPsiYU6F9bkEXXOh0eVoms
c/eFhs/lTgduoPBfYHiBw+EEIjwBysahmA==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQ/Xjp7CMKZZ0O5p2OCanWCx3A/OxOBwsgX9VroUP5
vvlS+hmdDvy6m+bq+y10mJ4n1HwgrdOBD8h/H4Dgg/UHIfjNB04tbA1Z6HBB
6fbPOqD+6BTr+/xhCx0YQCCn06EFKM8avtBB/64KW2N+p0PmxLc1/4H8DCBt
X9LpwHV9cUFtxEKwuH0Vgv/pkm+SQAOCP825O+d5C0L/DJD9HQjzQc5c3tPp
4GAat4sTaP+WE2X75vd1OjwDOmxnCIIPcoZoMIIPUn8ycKGDbBTQ4VD9J4H+
9wF5tBOq3guqvg4RfgDe1prk
      "], CompressedData["
1:eJxFU21IU2EUXkIhWpkp06Kp1QhNxhhao6Z4xmIlttS2tpUpJgkaaiJFH1gU
NsQjJdKHFFi8KA3/RKy0D4qkWkVRWin2gc6EGiNkRUlEBb33vme8Fy6X5573
nPs8z3nuypr922vjNBqNjd/Kc9+9A2fTIwgJE33Nx7wM3jpqlnijCG3Dz5nP
yiBWj+H+5sKEiWkEc4e1unYL1ccRCkKlpz0OqgcR3IsNgcoyBhb+vmcIIYUP
2ONkUNc921rUL/o/uxj0KefPSHzB1tkQbpU40/e1/HYDQj3ve8D7v/mflJir
EHJ2dz08WM4g2bvh5rNShCRDoNdYyuBx1vWWuk0Iu/ZaQl0lxK8AYVK/4OR5
O4OepqVtw3kIly7yy0r8jAg//o0drrdIfIrrnZ8v8U9ejxgYGJVBeUJfbzb5
ZRFYp2fAac1l24RelsmgXfv+1a9tCI3hPwOmFQwyFD2c/9+B729eLmMwpHy4
CYGz7m5MI/4nxD4KtUz1teecxJXK/KsScxZR/6DoN6SR3kdi/iI+f3TVx9/H
R0V9djn5H0LVZ3+G3Lc6j/O/pfCZI7yagU4xMoyqDrOOwZHIGlP8O+HvSDrp
C5JfWsI3EPiWOqwpDIoXxuW2X0bwcH8mk2mfPonV816JZ46mXtu8HuEp75+n
pfM6ocfB+SpjqxMFn0N6ykMcQiLnez9XYnUf+RKr8zeS/niECs4/yUr6UxHW
8sUN2sn/LJGPnVtJrwnhCzfyThnNsyNM8RiMO4lPBYISh6ib9LbI/0ndd6fE
UaX/isTq/gMIReuq7hZ7yP+gzL/6/Rcifzkca5RrhPLjJP6vJVb/nzGJY/tS
/XARnw/kl4v0TFFed1CepgX+5KY8zUi+/wErpvae
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/emSb5JAdrdDGJ/uplinhQ5yra8Dd7Qh+LJRKdb3
53Q7cF9fXLDXfqHD4a8aMf1rux24gPxaq4UOnY4JTy/s7nY47m3eyWi20IFX
d9Pc94e6HcKB+u8aIPh/Vn68xKuN4LeL3Tz3XW2hAwMI7O92uKfC1nhVaaFD
+b75Uvrbux0sgAYvlVvocBnovIj13Q6aMf2HSqWg9i+BmOcrvtChA2T/tG6H
DUUZE3VFFzqA/dMJtU94oYM8yD+VEPf/FYS6NwPB9zEHivgi+IdA5pt3Ozy7
oHR7p8hCB5D3/dUh9psC7d96omzffEmoe+Wg9gt1O7QcOLWQVQXBbwbyj2oi
+Hwgf+tC/S/W7XAXqF/UCOpfeaj5wPDTB0kA7Zs1c+bMSGD42oIC2qjb4fPf
KxWZtgsh5th3O4CcnQqMDwOQeqD7twDdFe8Ija9oRPyhxy8AWsvftQ==
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQzae7ae77lG6HMCBD1n6hw5ICW67rsQj+9Dyh5gNh
3Q7W9/17p9stdFg6+4jCBv9uhz8rP17qtV3oYAMS9+h2OO5t3tlos9BhMUi/
U7fDxqKMiWutFjoAeYsL7CDqeS0WOjCAgFW3wwagfK7pQodOx4SnF8yh8kYI
Pkj+rS6qvK/6QoesPSWTJWy7He6qsDVOVYS6x73bofnAqYVHZRY6ZE58W2Mf
1O2gGdN/6Kv4QofyffOl9BOg7hVd6GAHck8hgn/FN0kgog7Bbxe7ee57R7fD
1hNl++6LLXSISgH6fCLE/FbJhWDx+TO7HfiB4aYvA3Xf3G6wvfsVEHyQ/abq
CD7YHH1o+EyD6F8P9D84/Dsg/gkFhpc+iFEPtc8Wyi9GxAd6fAEA8O3Qhg==

      "], CompressedData["
1:eJxllQ9o1VUUx5dQlP+y3PuzJ7PUEs2WqD3fe/u9uTONwmxKomaiNkeCSqZJ
hRMrao01fneNETpWDPmRISOwnOlEdGjknzJ02MRE1pwyZchY04aKSd177vd6
eL7B2Pvsnnfu+fM9544r37Bw9ZCcnJwv9a/5u3Nj0dDzuYqSNSVl3yUDWnfo
/a+i4xX1tI+/eMcLaPsc/51rkxWNrjzyW3dRQH+Ulo9a+ryiJSMLWlbMCmht
fd/W4un2PCgOqKClqX9X0p43UUBe14LahmJF/zYPnC0tCci4/fhlRSfmJWoe
mg1/pfA3G/cvEp7a+cwjn74lzPZrFXVvyd1drf2ljf/3FL2hzzv1/ZxPhaLq
8IXTiVmw/0TRsre9rjMe/H8m+bJ9naJ9Jz9s25EO6Jenf9y05htFQ89/u7HI
+dtp+SNCvrsVDdN8uAT1aZX42P6oMOd/Srh/1/F5iQ75/tiq668fuCj++fyK
3L+87ufBSb2KJusP8SLk26cooeNfXYh6/m3PP9D5mLxvDSgy5d8QFzZlXDxN
+Dltvy9f+OvGxsYLsYBGLU39dPKG9d8TDWj/zXsdm/9R9Jf+/rlIQE+Y80Fr
n6d5janHbauXijDyv2vjGQyhnv8hHs2mb688XEv6v/UFmluN/xHZzPmNRv/2
qix29tzPVuFtph9twhW9E6c9esz2v875/xX10PHOHT5kSvXvtv9dmhvefbLy
yGlFX+i6tEbgvx36iqL+7db/+jzkq5niKw8+NkbY1dexq3+GfRzxnVE0qMNq
TqDep9DvVECXTb2O4/tavznmpw31SENfLcI8L98Lc/21ftdfu9s84KF+TXYe
R3jQ83bUqxDzW6uoWMdXk4T/Sjsvz85EPSox33E5Z/3NEHb5OzZhbYtBL59j
X7h6VqG+EeRXbf3na+a5rBF9cf9qRV+vmUTrRV+s5wbpP89TkM1OT2z/UjZn
6GeBMJ8vRjyanzLz+6bNL6Tje9XoaYWix3U8P4RxXxnyj8B+lSKT/rEo4i9H
f/OwD8qxf2PCrp6OnZ4cOz3xPiiDfQL9Wg77FPq9BP1y+3C+jafK6WmOMOsn
Lcz6ieM+zR2GX0D+Hvo7Afs0hXmKIZ8E9J8renKcMS+OY+h/yL4XR6OoZ0T0
km8GO2r3/a0w4htj9Ts3jHzGYn+F4H8c+h3CvE2S/jJPz2anD77/Tz+LnT3v
k0vC3N+r/v37uP+9/v14WF99fma8/b59HyPIZ8Dn9+Ke20c3fZtvFHrUzPsr
Jpyx3zVzvac+wC/Cv2Yzj6ucXm74tr5JvD/6ft4fKeit3/KeQuSj4+d59XB+
3bfvs9tXvTb+wx7mvUeY+9EtzPXq9O176El9Of9C8Dnfzk8aPPyB9zdX+H+j
Pgj5
      "], CompressedData["
1:eJxlkntI01EUx38qC1Eqc0OtlHz0UNYUCtNa5ll/BRWlleZ8YFOhIl+hZUSQ
WNSCg1SErLC81IrAYEVQVMTQUPCPEjEiQiNkf4ZURP3RqHPvPeNCG4zx2Xl9
z7nfPF9ndVuiZVlAX/l7/9ab3FAaQsqHu13ntgvwe5oj07sQQiePXnXtFFAh
A/vjWeWXCbjXRf/UIUzuLvP3uwV4W92f97Ug5FFB1Q7ud0LXf60UUC/jpxD+
PPw2gx7OP49Qs8z1pJH6X5b5VwwvBEngsGEa42keRciVDUHA+M/ChsHnCKmk
J0r6xyRPIlBXHCoX8H1mry/tHYJ9IDz1ZZPhWuo35zSs6guYJxAi0/mfzuQw
P0WYW7uk/1AW6wki3AwEAisdAvZIPde4fgXve9bwpYyPb391G372Izrbd0zX
16XzPXz6HkvtPK+R70N8/FXP9axahMrSphd+h7n/hfCUsGUYLqfB65L/i9sE
nH59Z1VJFcLtxQcTqUkCpPxQNUJRw+BYaSLHDyL8PrAQrE/g+9cgPKbzPrL4
nl5+f4v3beL43xH9fm063h7jzniW97sRHdHzl8dzLF/50WGYnml4cTVCNy3W
Qtwn9eYjjGZ7W18Sq3036H16SZ/KL0KYp/7vLfank/sl8L4u7d8K2l/5pJjv
n8R+LNF+y7EZVvXJhpX+zYbJXuLiFgFDHekD4WLttyPkP7WPi++3lXkj+4HY
kh8n+3Ubxws5TjxLdji8nvu5WX8Bz4/xGsOqX7Zh5b9M9pub/WVHkM8Yof7/
AI2lzQ0=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQbct1fXFBQK/Dn5UfL/WaLHSA8ZsPnFrYqozg31Nh
a7wqv9CBAQQCex0+/71SkSm70KFi33wp/SCIelcZqHxIr8NdoPpQqYUOh79q
xPRH9DoIgxRILHTodEx4eiG+12FDUcZEXfGFDp8u+SYJpPc6dIjdPLdddKFD
Oci8gl4HbqC1f0Wg/GoE/4LS7Z91HQh+VIr1ff/JvQ4Pq0TWuYstdDgEsm92
r0M4n+6mu0D7okHyy3odjnmbdzoC3bd09hGFDat7HR4B1bMrIvhg96gj+EJA
9yrqQd2/tNchY+LbmnpjqH0zof41h/pnQq/DrJkzZ960XOgg1/o6cEdbr4MF
UELVGuq/agR/64myffNLEHyw+/J6HTKB5u+3gqrP6HXQjOk/9NUSal8yxPxI
S2h8REPjyxwRP7D4AwBBnNYf
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQvaTAluu6c59DGJ/uplinhQ76d1XYGuMRfN1Nc98v
L+1z4L6+uGCv/UKHK75JAhFtfQ5cQH6t1UIHm/v+vdOn9Dkc9zbvZDRb6CDX
+jpwx+w+h3Cg/rsGCP6flR8v8Woj+O1iN899V1voIBhhueXE9D6He0Brryot
hIj39zlYdDomLJVb6PB46ewjCh19Dpox/YdKpRY6XAbZXwsxz1d8oYM1yP78
PocNRRkTdUUXOoD9kwi1T3ihwwWl2z/rgiDu/ysIda8jgh/bf+irhhqCDzZf
oM/hGVDjTpGFDll7SiZLMEDsNwXaf0QBaNOnXoh75aD2v+51aDlwaiGrCoLf
DOQf1UTw+UABqQv1//teB1AwixpB/fu9F2I+MPweVomscwfaN2vmzJmRwPB9
v/yYtzl3n8Pnv1cqMm0XOsiD9Ev0OZgDwycVGB+PQOqB7t9yomxfvCM0vkwQ
8YcevwDCB+ZM
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQLd/6OnCHbZ9DGJ/uJln7hQ5bTpTtm2+G4HvyMGm3
6/c5WN/3751ut9Bh2+e/Vyo0+hz+rPx4qdd2oYOPeadjgmKfw3Fv885GG6h+
6T6HjUUZE9daLXR4v/yYt7k4RD2vxUIHgQjLLSeE+hw2AOVzTRc62IDMFYDK
GyH4IPm3uqjyvuoLHWSjUqzvi/Y53FVha5yqCHWPQp9D84FTC4/KLHSofKlm
yKHd56AZ03/oq/hCh3axm+e+W0DdK7rQ4QPIPV4I/uOls48ohCP4M/KEmg8k
9jlsBfrjvthCh6w9JZMlsiDmt0oudDiiAHRZUZ8Dv+6mufpA+8DhUtbnkDnx
bc1+BQQfZL+pOoIPcra/PjR88iH61wP9Dw7/RIh/QoHh9bBKZJ17BNQ+Wyjf
BxEf6PEFAHnt0qA=
      "], CompressedData["
1:eJxllF1IVEEUx1ehCBMzalddyQpKstxUdLmrq3jMhzARSyq1tEKyLIwk7JMi
osQknEGiwiJiKBEfChGlD9oQy48UKswQH0yKQqLMPrAIlDp35kzzsA/L8rsz
c+ac//9/78qKw0WVoQ6Howh/9r+n4+Z06xcGa8t4T5dPQL1r7MXvEA6+hpw9
q7MFjBRURJa4OGyP8HSUbxCwuCS9cyDBcMuNZyvaUw1Pt/blW5kcFo7ergnk
CMDVI1W5HMKQz4CAnpk1ZXyT4iys/+7U0nsbN3NYhI0kZQnICw9dV7+Vw/iq
+ee2ZRAXc7je3Nxciv2d/BSfsqCUw2zb9+ECr2G8pcmTYljOs8zwjr3+iZdu
ARH2wKWq3lg0zbOTw1u8702UgONPbrmTyjkcaJo6/ddF9+/mkDlR2FiMHGnv
r+BQjIXGnVR/H4cruZeq9yP/GEbBqqkf5Kv4fLI2mC3Ut3KJgERbf3cw6/1S
vzjD9j2T8Ybx2MdXiRyqsN+zyDj2zJpk8s9FeqfS/C6a38vhfPeg6I0i/S0O
F5DnxQi4U5MVNmqp9boYqudTfjhjDWt9Ncv+kw1ne3c9akijPHmVX42WAJm3
FNX/oXQh+yr0kJ9+0jOe8pFJ/sQaluvhhuX5Wab6y6D6mGc5n9ew7ldz18Ax
dFrAazvfUwwuYp/3o8nfr0zmdw71sX2/9o1Bf77VEBJF8/1kcr48F/nzi6n8
OKn+H6b0cJK+DuPXe5vDgln7L+drZ0Gs90vuNCzrBwzLvD6l+Z00Tx+DBLtx
7Pfg49rL0YNM5UPnf4jucxvWemm297esN9yJ+i1Po/uHVP2jFs1D9Vt8tP6c
qfcN/Y6r+7zlQT+DmbmRE23ar17yz095pf7r/JTvbuVHALnX1jtgWJ5/aFi+
v11MfW/8Rj/pZwbxXdJH5+kD+//90vnQ/A8I8Ulj
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvbjAluv6on6HeypsjVf1FzpMzxNqPgDkR6dY3+fX
XOhw2TdJIGJlv0PmxLc1+5UXOljf9++dvq3fwbzTMeGp/EKHac7dOc8P9zs4
mMbt4pRZ6ODJw6TdfrnfIYxPd5Os1EKH7Z//Xql4iuD7gDR+RPDB9v3udwBy
574H8ue+X37Mm2mCw12ge6YCzQPabrmFbYLDswtKty3lFjoE7ZBrzeaaALFP
EcrnneDQcuDUQlbVhQ4g51QLQPkqCx1+BD9eKs0/weEpUH8l0L2fLgE9xA0x
P1R6oUP/oa8aMSxQ+8QXOjysElnnDnTPrJkzZ94UXugA1Paz7lW/A/f1xQV/
BRc6XAGFxzUE/4jChqKMAwj+1hNl++av7XfYAqTlRRY6tIvdPPd9LiS8UiWg
/u/rd/gKDJaVMtDwbOt3mAp0eLoSgg8Kn7maaPKGUD5QPxfQvlpzKH9ev0M4
UP1dayh/HUTe1mGhgw4wWJcf6ncAunJirtNCB3B830LwwfH7HsEHhw/DBLB/
9gL1fweG32xg+IPcE2u70GHZ7CMKBrwQ+b+WiPAGh68pgg9LTwAl/RSO
      "], {{
      1012.3549999999999`, 2201.3550000000005`}, {1022.918, 
      2201.3550000000005`}, {1022.8319999999999`, 2202.8230000000003`}, {
      1022.66, 2203.8550000000005`}, {1022.4019999999999`, 2204.448}, {
      1021.984, 2205.3740000000003`}, {1021.3629999999999`, 2206.105}, {
      1020.543, 2206.636}, {1019.719, 2207.167}, {1018.8589999999999`, 
      2207.4330000000004`}, {1017.9649999999999`, 2207.4330000000004`}, {
      1016.59, 2207.4330000000004`}, {1015.3549999999999`, 
      2206.8940000000002`}, {1014.262, 2205.8230000000003`}, {1013.176, 
      2204.761}, {1012.543, 2203.269}, {1012.3549999999999`, 
      2201.3550000000005`}}, CompressedData["
1:eJxllG1I01EUxldQREUFta0pNQ1dL2gpKZvbbGcWiaRZZi7XrBhZszRFKi17
pSQlxOuHkCUWlzDxS4gkRVCEaEZBgRUpZS/0oSJCCqSipM7/3nO5xD6M7bf7
dp7nPPcmhquLyqebTKYi/Bjf9Z8d6U1OBqtCrQP9Lg7XOwYT0nIYuJr9e5J9
HDY58Uc+g5J5qX1lORw8bwtbrCWaM3fdyZu7U3NwL87YzWDOy2s1d/0chhJ6
az+FGcxGPgkc1l+s/NiwT3I27v+sILxgRwWD+al9nWuyOVywjD2pO8hgPGnm
2e1uyT8qGVyORqOlWJ+98cvW21UM/vR8GynI1NxbG2lLTdcs9CzRbNT1NI4D
yp2VckjuN7aY9FQzeIPnvbByuDLR/eAxckXb1xN/LXR+DQMvzgtY5Pz2WgYB
1Dtulvu7DjO4hML2I7/6deqAt47qQUZZE90NsWzYWr6Qg/B/cyyr+YPoX2SL
5hRjfbHmn9s+dHUEGESw3tPI748vupFbSv3Dejeg37+DpN9C+kMMzt1/xIes
0v9R5PPIM2wcbj48es9eJscbbbRfmeyHOV6z8lexqD9Nsw+D0ZxBeQrJfrU4
ORwzCgjK+quyOLCByRWvA9RPD/lZTPnwUn8KNYvxXM2tuD7ko/rc5J+T9GVq
VvUq7kedVzEP+Vj4O+Qm7PMtykO7S+Z3Cv3BK2I6k8VgGC/CNKvUN+yW+vIs
1B8v5cdM+taRH2bKt1/3S/DGWFb9F/pssazmC47/f/2oXbPI6zLSbyY9SQxW
ov5JrNfIic9B+VD5X07nxWlWfik25net1ixykkHnO+T+R5ykh/bvctF4Mt03
7Pf3EfwDeXLqeX2Pm/xKov55KK9Uf6OH8p1I74mH3hO7ZrF+qWZxf+PpvfFo
/0Q/3fQeWMkflae1+v1S+VD8D2qmO8s=
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQPe/98mOn505waDlwaiFrwEIHFL7jQocfwY+XSm/G
5DcD+a22CPXofM2Y/kNf5RH8zIlva/7LLHTYcqJs3/x5UL7UQoe5QHnvBVD1
kgsdGEBg0QQHPt1Nc99LLHRYNvuIgsGSCQ4bijIm5gL5Ew591bizDMH/dMk3
SWAlgg9Wv3qCw3Fv886DQP7tn3VZNmuh8kDzVdkapzqvn+AQBrRAVgpq3oYJ
YHfJSy90cOnOef57I8Q9pUD3Bu2Qa329FcFf5/6waspmCN9UEur+DVD7xBY6
mMbt8uRZAzVfFOr/5RMc2sVunisXXujAsUYmKmXxBAeLTseEpUJQ++ch+FEp
1vfPz0bwxW+e+355xgQHRaAHBIWh7pk6wcEcKP9UGBpekyHhuV8Eqn4CxL7v
ohD12f0THP6s/HipVxzqvr4JDkLACFMEuh8Y6hoxvRMcFEABJI3ghwPdf1cO
wYfFL9j+Okw+SLuuPTR8miY4THMGBqQ9xD/+bVD7YOmnC2q+00JIPPdCwmuu
C9S+iRMc+IHc9W5Q/pQJDndV2BpFPaHhBfT/rJkzZ0Z6QeNr+gSHr3+vVKz0
WehwCxjfe2Yh0jMALxlnfg==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQPe/98mOnOSc6tBw4tZA1YKEDCt9xocOP4MdLpeUx
+c1AfqstQj06XzOm/9BXeQQ/c+Lbmv8yCx22nCjbN58Lypda6DAXKO/NA1Uv
udCBAQT4Jjrw6W6a+15iocOy2UcUDAQmOmwoypiYC+RPOPRV444Qgv/pkm+S
gCiCD1YvPtHhuLd550Eg//bPuiwbSag80HxVtsapztITHcKAFshKQc2TmQh2
l7z0QgeX7pznv2Uh7ikFujdoh1zra0UEf537w6op8hC+qSTU/TJQ+8QWOpjG
7fLkkYCaLwr1v/BEh3axm+fKhRc6cKyRiUrhn+hg0emYsFQIaj8Xgh+VYn3/
PDuCL37z3PfLLBMdFIEeEBSGuodxooM5UP6pMDS8/k8Ah+d+Eaj6PxPA9n0X
hajP/j3B4c/Kj5d6xaHu+zXBQQgYYYpA9wNDXSPm5wQHBVAASSP44UD335VD
8GHxC7b/FSYfpF3XHho+7yY4THMGBqQ9xD/+n6D2wdLPN6j5Tgsh8Qw0HxRe
c12g9v2d4MAP5K53g/IZJjrcVWFrFPWEhhfQ/7NmzpwZ6QWNL+aJDl//XqlY
6bPQ4RYwvvewIdIzAKXeWwY=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQHbRDrjXbfKLDPRW2xqv6Cx28zTsdE4D86BTr+/ya
Cx1eqhlyrLGa6JA58W3NfuWFDnPfLz/m7TjRAaTsqfxCh9MLXbd9dp/o4GAa
t4tTZqGDKlvj1MP+Ex3C+HQ3yUotdLj1sy5rTwSCv3T2EYUNcQi+D9CgB8kT
HYDcue+loOZnTHS4C3TPVKB5SQIRlltyJjo8u6B021JuoQPYvQVQ+xSh/OKJ
Di0HTi1kVV3o4Nyd87y6DMpXWejwI/jxUunSiQ5Pgforge79dMk3SaAQYn6o
9EKH/kNfNWKyoPaJL3QotOW6vhjonlkzZ868KbzQIQPob/voiQ7c1xcX/BWE
hIdOIIIPcp+JG4IfBQy38zYTHbacKNsnL7LQwQXont8mkPBKlVjosAzofwPd
iQ5f/16pWCkD9a/mRIepQIenKyH4oPCZq4kmbwjlA/UDXVlQaw7lm050CAeq
v2sN5dtC5G0dFjqI3Tz3PRgYPxuKMibmOkHDKxjBfwWK31gEHxw+aRD/7AXq
/w4Mv9k5EPfE2kLdXwz1ryUivMHha4rgw9ITAH1hEeg=
      "], {{1101.855, 
      2201.3550000000005`}, {1112.4180000000001`, 2201.3550000000005`}, {
      1112.3319999999999`, 2202.8230000000003`}, {1112.1599999999999`, 
      2203.8550000000005`}, {1111.902, 2204.448}, {1111.484, 
      2205.3740000000003`}, {1110.8629999999998`, 2206.105}, {1110.043, 
      2206.636}, {1109.219, 2207.167}, {1108.359, 2207.4330000000004`}, {
      1107.4650000000001`, 2207.4330000000004`}, {1106.09, 
      2207.4330000000004`}, {1104.855, 2206.8940000000002`}, {1103.762, 
      2205.8230000000003`}, {1102.676, 2204.761}, {1102.043, 2203.269}, {
      1101.855, 2201.3550000000005`}}, CompressedData["
1:eJxllH9ozGEcx48iIRR3Z5M2hdCOrbbu3N26z1BaLJkYGmlZjohWmB8zy679
bp4/tM66zYNzVmhdG7qMue1sIct+cMNh+QNJi7oQi8/3+3yennR/XHeve359
3u/P+3kWFR3OL55sMBjy8aN9l35emlHtY7CisDHcaeNwrbk3Nf06A1tNzp4l
Lg4brPgjyGDbLEtw1xoOjnebGsz3FGftDuXOfKh4516cEWEw4+WVI105HCKp
7SWf+hlMRy4DDmvrDn489VRwNu4/lFc0Z/sAg9mWoG9VNocq0+iz488ZxBZP
rdhqF/xjkMFFr9e7A+tL8XzZfHeIwZ+2b4N5WYrbS9zMkqFY17NQsVbXQDIH
lDstbVjsNzqf9IwweIvnjZg5tIwHHj1B3s++nv5rovNfMHDivAKTmN8UZVCA
emNGsb/tFYMLKGwf8utfZw44Y1QPMsoaD4wlsmZr8VwOuv8diSzn96J/7tuK
07T1IcU/t3zwN3cxcGO95chjJ+fdWv+A+of1rkO/f3eTfhPpDzM41/2YR8zC
/yhyJfKUJA4d/cfup/SIcU8S7dcj+mFcoFj6K1mvP12xC4NRk0l5Cot+NVg5
nNAK6Bb1H1rN4Xw4vuxNF/XTQX6GKB9O6k+nYn38puJGXF/op/rs5J+P9GUp
lvVK7kSdrZiHjVj4e+Rq7PMdykNTi8jvBPqDV8RwtpVBH16ESWahr++S0Jdr
ov5cpvwYSd9V8sNI+Q6oful8I5Fl/3V95Yks5+tc8f/6qEexntdq0m8kPbUM
lqP+ONar5cRVT/mQ+W+g85IVS78ka/P9KxXrOcmk8+vF/ketpIf299tovI7u
G/b7+yD+gRyfGC5ts5NftdQ/B+WV6vc4KN9V9J446D3xKNbXVyrW728FvTcO
5Z/eTzu9B2Xkj8yTV71fMh+S/wFdKVzJ
      "], CompressedData["
1:eJxllG1Ik1EUx4eZWc3Xubm5mpu5zFJSy9RceZaFhIWg9G4RlhC9YFRGFAWR
fpCS9dzowxKLS1QEYhEWEREhFaH0JkWElUlUWJlpE10qdZ57z7hEH8b4cc89
95z//5zHVVVTXh1mMBjW4E//bx648qg0lcHa6Mwbm5dxCPH71Ijjr3I4LD+5
+8uYUzGGNdc4GMyt9LXfzONwuemBM8vOoO5+B59cyKE7eGynJ5HBCeSHHg4b
txf2lJkYFOVuudOwlPJHM7i+b4e2p4hD3+zsyIxIxRi28tQkxecxvvOPJvI8
w/vltx3138Y1eIf1nF0i442/NTjn9/s34HsjFR8vNY1qMP31xb0TixVPQz5a
oNikF4j1f8X3W4Ia6ImmLqL3xjTZ30IOq/IavB8mKP8CDkNdq6tiwxgEJl4e
6svm4GsfnlOJ9WPY1uosqs9CemVwKNUPUE+9fl86h1F83z6PwefnKd0FbsUi
PllxDOp8zc6hk6+49SuNgaenrHGdlep1MRi/Otj1xCzf24X6u1GOYhNxApP9
x0l9W4yKW0t6DydMUVwVu76gzcCkPvGkf5D0wnyWN09HKkY0cKEhL0x0Pkz6
msi/gOK2xwfvXRhSLOoZlP75Qvd/kr7xNA/9/7O4n6LiQyzyYX6hh4PmE+sR
+iXR/KF/6ZivFvUqxvMj2J/un81CfkXI+epP4HAa+a1RsZjvOMWiP7O87zfT
vFmZyD9sIX+SpL9lVqpvBt23KRZ+2RVjdGOiQ/bbmUT746R+cX/EfLtIf/Qz
H8fIPYvmK4oJnZPdpFe43Lf6NPIb90HMZzr1G5D+xWUQD5KemcQ/5D70zic9
vmuAU9JakqNY7ycz91/uz6d+BjTYhP3HeKj+AO0n7us2fb6Ccn9sXtoHg/re
iPhIxUJvo+K7B85Y62IZfMJ9CXrlfjSZpf65XnkebqPvEZAednleC0rvEHeg
X/tnKhZ7g98zp94QUH8O8gtofpIlR3npe+ekeK/6Pobq/QttunkW
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQXfFSzbAjdZJDGJ/uplinhQ79h75qxBQj+EBqbn7d
JAfu64sL9tovdHhYJbLueNskBy4gv9ZqocNRhQ1FL3onORz3Nu9kNFvo0C52
81z5xEkO4UCNdw0Q/D8rP17i1UbwQfR3tYUOQCcwNPRPcrinwtZ4VWmhg/V9
/97p3ZMcLDodE5bKLXR4pWbIsaZ9koNmTP+hUimI/e5NEPN8xRc6HAHan1E9
yQFITtQVXegA9k8J1D7hhQ4TgP65kwNx/19BqPoUBH/pbKBIGIL/COQ/70kO
zy4o3d4pstAB6P33y50h9psC7Y9Ksb5/3gbqXjmoeZaTHFoOnFrIqoLgNwP5
RzURfFA4vteF+t96ksNdoH5RI6h/7aHmA8NvRp5Q8wGgfbNmzpwZCQxf+dbX
gRaekxw+/71SkWkL0f/df5KDOTB8UoHxMR2kHuj+LSfK9sU7QuLrfSwi/tDj
FwAzAuQG
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ3S5281x50iSHMD7dTbL2Cx2Cdsi1vo5D8L3NOx0T
oic5WN/3751ut9Dhsm+SwI3wSQ5/Vn681Gu70GHu++XHvEMmORwHKmy0gejP
DpzksLEoY+Jaq4UO8q2vAy38Iep5LRY6MICA7ySHDUD5XNOFDkcVNhS98IbK
GyH4IPm3uqjyvuoLHUzjdnn2+E1yuKvC1jhVEeqe4EkOzQdOLTwqs9Bhy4my
ffKRkxw0Y/oPfRVfCHa3eALUvaILHYC+C9yRgeC/VDPk0MlH8J27c55Xl0xy
2Ao0577YQgedTUAfVkDMb5Vc6BCVYn3/fM0kB37dTXP1ZaDuq5vkkDnxbc1+
BQQfZL+pOoIP0uevDw2faoj+9UD/g8O/BOKfUGB4zcgTaj6QD7XPFsrPRMQH
enwBAAKw0jI=
      "], CompressedData["
1:eJxlk2tIVFEQx5cgiZ5GbauFpj2kIKlI2cfd3FHrQ0gERhFhEUtCT1wLondI
RUjF1oH60LLZaVl3L/QmpUxlW918Yflo2XTVqAiJiLAQC5Oae8/IqfxwufzO
DDP/mf856c6SwuJJBoMhDz/tv+7igcHRpwy2zsx8tCOPw9+cYuHwY/MHv+c5
g4ODo+pQDgc89pa0yPx8zD/RKbl07dTY4qjkTxmrp6x4w+CXOtTVnsshe2fN
hku9DB4e2nP1LnBo4+urv/cxSHuABw7KH2Dg0BJzJA8sSSiL2v+NlyscvF8D
Lwr6GaBqtdRG9eOi32UrB1PPy5HuHgbXUWgA51maUHatIcZgeZE7nI3sDg8v
K4pK/ta10ZnYLbkV9R3uYPD++Nx7TRaq385Ak/vFKvTcaWWQjgezFYo3M7CU
5+7yK6S3SbI+b0SyC/fla2SwfbfydhNy/OfpffYGituE3vwQ7QP7VXoa01bV
iflmmKVfup41kvV4quR3qP/CAg4jmp81DKqaj9RXJHO4gvP3PWPQj/vdksSh
F/vX1jLhs4kDVj3pqGcwC/n+PA6FT1LP7w+JfCPyY61OmMHHjkXxY0YON9GP
tojQk2kU+Z9bJrIZ5yueQ/N6JvJ4vq6vQrLut4/8N9K+/QzOhtAp1ONM3GbN
Coh9vkIu0AoHGQyPvT6qmkT+dJXuUxLFVeqfTPWQ9+Lcv+dL1v1Ikazva+V/
8SwufFTpvptJf5DYQu8nKO5Lp1W8Fx/pddvoPVUyOIfzTFbofuJ8mg9nFNof
zj8t5nPVjd+v25I1PxbekqzvwcsAu7hOKXK/WnzMRnxD7C9iJ/+q5Pv9A7C3
+dE=
      "], CompressedData["
1:eJxFlHtI01EUx0d/RPTG15yP6VR8Nast59RNd5ZWqIlpmfm2ZaGWGEKhvSXE
IiTj/hErDC5hIlhZFEj0FB9RUFGBlYlZiJXEiJISEzq/3z3j/iHy2e7O/X6/
55xrcDUU7F2k0WiK8U/5b5vIa7+YzSCu7PzArI5DWOtMfrKTwSW3210cwOFN
rmv1LhuD04+f8U1+HNoC3r/4k8wgHs/f9eWQYz3rrLIw8MUDkz4cfr7OdXWY
RL1DyE3fok1nEiRfuzwYvj5Gcua5A9PzBgaTR/xutGG9ofC+xq+hDG411ly4
7s+hpNo28VLHwI46R7UcPuO5ES2DVQm3O28GSVbqWfSSV+L3DeFcrTsSyGAn
flAeQRzEYNno1YMLkaQP71uKnBbNoebCj2OOCPIfS35jGYxHLW4pjBf59K8j
NnIo6Ne3zqQyGMEgnqzl4M1Tua/TJLkP/dRvkKzWtXLAU56YLFHP3yb0bdks
8h6ycxjEPGoyGEy9ihhrTqf8HHS/Q/y+O0VyBuZ51CIZ7S0xmqleutSfjG3r
SqPvsT+K75N2yn8Ng/rp+R6TTbKS14MUoV9rZFCE/saTJBtQZr5F9CsPz/vg
hYZE6kccg389OBnof2zuRJ09VuR93Ex+osm/mfxESla/N0hW9YaJvFvMlGco
9RfrWyruZS0PoX4mUp7BDH4tvG2qtUhWxnYqSXIt+n+UQvfpGdx5evhhJebR
rFwYJfNT80A/v7FenJPD3+1fuoLNdP9GDkZFv13yB/R7P1Oyui85NL9O0r+N
+gUccCU1p3YwcChGHHS+iPYhjfazmPKzifnbXyLyXZFKekuF/jCrZHVfzZLV
fCIlq/urJ/+lYj6tIbQf3vPBHDoGZmM/Ig8rwoJoPsvEvrh1NM/l9F4gK2vg
KRf76AkU78m7CsrTy5WSt2LZT1WSr3i6h5/vJn2BlJdL5BmqE3lpqoX/duQu
1N+3j34fRP2oIw6R7H3v1HncI/ZrDt83NbcyyteH3r9Cyeq8F0hW+5VH+fuS
vlyx7wlY7zvG25tD++Ev5rc3W+ybQyvfA6+e/6rNdfo=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQbX3fv3e612QHzZj+Q6ayCx1g/LsqbI1T9aB8h8kO
s2YCgc5Chx/Bj5dKW012yH3+e6Wh9kIH3U1z36ubT3YI49PdFKu10OGowoai
F4aTHaY5d+c814DK60122HKibF+8OlRee7JD84FTC4+qQuSXa0524Acy9FUW
OlS8VDPs0JjskAM0v1AJwf+z8uOlXgUEH2S+utxCBz6QAUD9X/5eqdCUWejw
sEpk3XEdqPuloObrT3ZoAdrHKglVbzTZgev64gJbiYUOOiB5MwT/9s+6rD3W
CL63eadjgtNkBxD1VBIRPrDwAgB5lpLq
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvc79YZXIxMkOmjH9h0yjFjrA+FpA/lZZBH/WzJkz
b0otdHDuznleDVX/VWKhg9jNc9+DJ012aDlwaiErkK+7ae579ckQ9ZLiCx2C
dsi1Zk+Z7GDe6ZiQKrbQodCW67ryNAj/qehCB441MlFPpk92+Pz3SkUmkP8j
+PFS6dmTHTYUZUzUBfLFgeZfno/JB5snDHVfMSYfph7IW+dejuCD7a+Cqofy
F1dPdrinwtZ4Fch/qWbIoVM72aEZ6B9XoHuBvtSIqZvs8PSC0u2fQH6SQISl
ST3U/+JQ+xoQ4bGnZLJEC5C/9UTZvvtSCD4sPGF8C6D9qu4Ivr1p3C5PH6h7
gfyc579XFvpD/Qu0L4wPGLIBUPcA+X9Wfrx0NnChw3dgeM2ug8oHQdwzpRYi
zxsM5ddMdgD6sqA2GGp+NdQ9QH4y0D9bKhH80wtdt30uR/Bv/6zL2lM62QFk
fH4wang/DYLEX0ohxD9LQ6D29SDSEwCCRRvG
      "], CompressedData["
1:eJxVlXtMzlEYx6O7S4WULtRbZJnQJvKmemLNDGs0FsNIbfWH6zDXPxpm/jDs
ZIk1nVkMaV1RLku0knvkMlNKMcNyzz3P+Z1vTt6t993nd57fc77n+zznyZa6
el56XwcHh0z+U7+zJ+9JeF4jaGd1g3QeKcnnye2u5EuC+PGy9FGSPjbOSfWq
FPTr5IfGOaPBZwX1f3RszaVwcJmg4nUZByLGSuKo1P0lgirqN15uGWe4eaRL
VlOk4cO5ubkLJ0m6IRPPfioX1I/zxdolHVo1eEf1Bc3bYyUVzWjdkl2D/UjS
orSYlqQbghZ4RJQumSaJf/I6mwyvieU3mw0fP3IteMJL6E/A/m+hN16Sdf5u
w6leKVPK+2b/4/t8vBSnbGJVDbZ4vf8dZpVvIDjJOZt2K+PiJK1V+zPbOMG9
OMQzKz15zEG73syNdtHrc+O0/tXMFLW06nqsYasevfjz7webwqdKGuWSdXA6
c7ASGIPzc37Lvxid/zz2H8Q8SxWS2Yqz47ys36qHHevML++GPK20m/OXcPoz
duNPDzuoz2fDK1R8F/yNhr/fBWUceLctPsow2yd3Rf7PiRHw76ugIepBOPzq
1PXLC8P6a0H8vTcnFP3wXNAz1j80RFp9drTJcDlz0D3DF9eLYTtvCvrE/mWG
IH8d1kN1fR9fE/q5Dcz9NmbxvpqKYMRf0Xprg8DV6OcR0MfctsW7yLUXW/03
3LDy51Yg8lfDn0DU7wr2C8B9uirIk5+PD9D1mFgLff6oV73Wf5DZytMgdJ8w
uxUGLmq/reOT/LH/Q0HhnD/KX/vh1C6sfnPviX+L/H7Q8x71Yla++3bBLz+8
/0vv1+mr71dxN9Z9dL40R91PU7yhj/tv5aufJz8MMmzp8fyfN/RH//ZBvKuk
ApX/h6BoPnaBE87D+qz71Z1Prex7XRvm1e98Xf9Gw9Y8qzVs9UMV6vcnX+sv
gf99sF+h7sfljpgfpwR9S35REOBsWOXrcDGs9Ja4or+ZlQ1b3aD3NPrdHfeZ
89dxIbP6ScpR865IaL8GwI9SPY9WeuA+lur1Sg/Ug+evmgM7vJDvIvpriNRz
6Dz88Ub/98zroeivCh2/1wfzqgz96ov6837x3B8zhxlW9Z3vZ7iD9Wz2x3wo
g58BmN8V8Jv7X4WfOKf77wvfj82vwyLdWK81z2x4v9f/n7+kvwud
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQnTHxbY39lckOmjH9h77aL3QQu3nue/B5BD9JIMLS
5PRkh6cXlG7/tFvo4GPe6fjg+GSHlgOnFrLaLnSoeKlm2HFkskN0ivV9fmuo
/CEo3wLBB6s3QfCbgfyjegsdCm25risfneyQ+/z3yo1aCx2WzT6isOHkZIc/
Kz9eOqsOlT872SGMT3fTXNWFDntKJku0XITob1VZ6BAFtOf8NQT/sm+SwI3b
CD4DCDyY7NAO9Fg5UD/Yv48h5sWqQ93/bLLDMW+gwzQh9hu8mOzwDOhfSx0E
H2SeqwGCD7K333ShA8camagnT6Hut4S4x//hZIeNRRkT19pA5e9OdggH2nfX
DmrfTUT4ooc/AF+Zwq4=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQzae7ae77g5MdzDsdE1KFFzpEpVjfP79vsoNWTP+h
rYILHUDy+XsmOxTacl1XFoDK75rssLEoY+JavoUO8q2vAy12TnY4vdB1mzEv
VP2OyQ6zZs6ceZMbwQ8DMbgQfAfTuF2cnAsdvEEWA82zAFJL2Rc6ZEx8W2MP
tF8TaH8p20IHH6D8gyNQ97EsdDgFtKf4HMS8WOaFDgwgcBvBB7nj8zMEX5Wt
cerh95MdgnbItWazQO3/Otmh+cCpha1A88H++j3ZQRgkwAE17x+E/5ALwQdJ
u/Ii+MeBDmfkX+jwsEpknfufyQ5rZIAhIwB17w+I+78C+UcUNhRlAO3Lff57
5UZgeK5zf1g15R3EfbJCUP8/mezAdX1xga0QVP3VyRB/CkHc+/7kZId7KmyN
V2F8pPgCAGGbwRA=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQLd/6OtBCYYrDPRW2xqv6Cx1eqhly6AD50SnW9/k1
Fzq0i908V648xSFz4tua/coLHazv+/eKa01xMO90THgqv9Bhep5Q8wGDKQ4O
pnG7OGUWOny85Js0wWKKQxif7iZZqYUOFUADOxwRfOfunOfV7gg+yL41PlMc
gNy576Wg5gdOcbgLdM9UoHlAJzI0hE5xeHZB6bal3EIHsHsjofYpQvkxUxxa
DpxayKq60OFhlcg693goX2Whw1GFDUUvYqc4PAXqrwS6d8Khrxp3IiHmh0ov
dABZqx4MtU98Idgd+UD3zJo5c+ZN4YUgazx5XKY4cF9fXPBXEBIe3y0RfJD7
GPQR/B/Bj5fOVp3isOVE2T55kYUOj4DuOS4LCa9UiYUOLkD//xad4vD175WK
lTJQ/wpNcZgKDJh0JQQfFD5zNdHkDaF8sSkOXED7as2hfLkpDuFA9XetoXw1
iLytw0KIO4Dxs6EoY2KuEzS8bBB8cPy6Ifjg8PGD+GcvUP8RYPhlhELcE2sL
dX801L+WiPAGh68pgg9LTwDxmwSX
      "], {{1288.055, 2201.3550000000005`}, {
      1298.617, 2201.3550000000005`}, {1298.531, 2202.8230000000003`}, {
      1298.359, 2203.8550000000005`}, {1298.1019999999999`, 2204.448}, {
      1297.6839999999997`, 2205.3740000000003`}, {1297.062, 2206.105}, {
      1296.242, 2206.636}, {1295.4180000000001`, 2207.167}, {1294.559, 
      2207.4330000000004`}, {1293.6639999999998`, 2207.4330000000004`}, {
      1292.289, 2207.4330000000004`}, {1291.055, 2206.8940000000002`}, {
      1289.961, 2205.8230000000003`}, {1288.875, 2204.761}, {1288.242, 
      2203.269}, {1288.055, 2201.3550000000005`}}, CompressedData["
1:eJxTTMoPSmViYGBQA2IQnSQQYbmlZYqDRadjgqrlQoeKl2qGHb1THOxN43Z5
2i90AFE806c4hPHpbop1WuigytY41Xkhgl9gy3V98SoEf+775cdOb4LyHSDq
D++E8m0WOqiA+AegfAuoeUemOJgD7X9qhOBrxvQf+qqN4M+aOXPmTeWFDhxr
ZKKe7JvioLihKCNQdqFDIdB+5S1Q8ySg8lD3yIosdLC+7987fcEUB+7riwv+
CkLNm4rgB+2Qa33dj+DvKZks0dI1xeHpBaXblUIQPkvrFAegdRNzhSHh0VM/
xWGqc3dOOtD8drGb575XQt0nCjW/ZIpD84FTC4+KI/h/Vn68xOuO4IP0mftA
zS+B+D/VH2p/8RSHu6CACoDKA/kgi08GLnSQb30daFEE8d/cIKj/C6HmB0P8
K14wxQEYKwW1QP7DKpF1x/OmOGgBw3MrkA+Kb5NcBB/k/OBsBN+lO+f574wp
DiDj82Hq06DxA7RPHKj+cgokvSwNgco3QOLLNArCB6UnGB8A8tEF9A==
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQnSQQYbmlZYqDZkz/oa+mCx1g/I1FGRPXSi10WOf+
sEqkY4rDcW/zTkZJCH9K9xSHzIlva/aLQ9Sb9E9xMO90THgqttBB/Oa575cn
TXGITrG+zw/kV7xUM+yYNsXBAii/VHShgxhQPngWgg+0VSNmAYLv0p3z/PfS
KQ5/Vn685Aszf/UUhzA+3U1zge45orChKGPDFAcgOfGt7EKHPSWTJVg2Q9x3
UAnBB6mX1UTwc5//XvlRD6EfZFy+McL8uypsjVPNEPY/u6B0e6cl1P8LoO6x
XuhwaqHrtuKZCP5RoHkvpiL4HGtkolKA/p81c+bMm1YQ/pM+aPgCzZNvfR1o
0TPFwd40bpenJTS8OqDy5ojwh8UHAAmjwxE=
      "], CompressedData["
1:eJxlk21Ik1EUxx9KTcy3yNVMNA2LgqSixLlnuTMtIioCoz6EhUiCleF6Icre
kIoYFku6T19E5CImg1oWFREWYa8kKxuW5dY7sYrWWms52Uad57nXbuZgjN89
Z+f+z/+cW1DTUFk7QZKkcvyqv22Brvt9XwlsSC+6vKmcwr+ca6BQeT3v+Paf
BHb4oo5gGYW6Fv9Bc2xs/qoE5S/30eXXQpMEL2uu90VTFIg5gm6XhYK9Nzy3
Kk2BS7vqWi4AhdlJTcqdDAXyu/HAzPMzFTAXb76xskzw68KkpmemsXGbTCGy
7kNnDjKeOnYaef10dt+pUgrWpSmDHakKnK1oru/Cfpwr3jUS1DOvyt5bjPx5
zqLk+cmCV5fYLG8TBav6KiYq8L4xy/nAwOtLCqhy/Vgfy/oOxAkU4MEUmcej
BAw2S3WnzPWOCC5U+40IfoR+7R4msHGL/GYtstp26i8eNzK9WSHC/MD7JPXz
nWj9pZWIeWl6FgvW4nmCsYrzRA6fp5/A1Yd7b7Vns/7PfyPwCoWt17P7TwYI
4PjaGqZT+OFeU5MZJJCBfHEaBc/I4W2mEMvXIWt5YQIf+2d59usoDOM8WiNM
TxHyEOb3xMYz2lxdO5X3+3g8j+Zr+tyCtXk/Z37YdNzvFwSO3kYnUU/PnjP6
hCHm5xPkc6138xd6CITjA/sc2M9pzPcia/uk53Evvz+b10Peinv+e4ZgbR65
gjW/FvwXX0LhCvo608v8d+F8vqj6PZwN/P142L48LeXz53rtRv6eXhI4hv0k
ynw/sT/1f0dk7h/2P3mww3pzdL8GBKvzCLgFq3ra+wngK7AekoW/ajxu5Oxi
/t0z8fl9Eu/7D3rW/ok=
      "], CompressedData["
1:eJxFlGtIVFEQx5cIiaISXd2Hr101X2m15rqu67pjJpYmZpnp5qvVQgOz7GWS
pFhYH6SkDrKFyCEKhDILjYgeVprhh4oMLELMQCoiJCoiSmjuPbOcD8vld+/Z
mf/8Z+aYPY3b9izSaDRl+FOe1y6PmtblMYgvP/fkl4GDu9Yx8xIYXPJ6vWXB
HFYk3e6dT2fQMTLBc7Qcvr8u8JxPY5CA54cDOXQGv3vxO4VBIB6YDeCgHI+1
iHhHkIeeH30YkSR5tkU7MB4jeSB3tuWimanvOzEeStK0hTG41VTXfSOIw6hp
sKnOwCBjprBrSsch33Y2q1rHYCUmummUrMSzhktWdDeaiPUMSvBFRSSxkcGy
qSsHFqJIH+ZbiuyM4TBZ4PF/a6b646jeOAbT0X7tOxKEP4VriRM53D98QX8K
/RnHwI/XcPD5qeTrtUjGKrob1ktWfbNx6Nkf0DGyScQLcnDYgvo+5Ai/xzKE
H5psBnOvIt8fzyT/Mim/i0Nd97cTLrtkxU+tVfIqv3b21ELxMqX+NLThqpND
tPI9kalxTlK+ttUMGj797bc4JCt+PbAL/YPIO7G+6VTJZiywyMphDPv1OYEB
VjVhTiG/4xn860cnsX4dlj0ZK/xuTebwUalnFdWfTPVESVbrNUlW9YYLv9uT
yc8w6i/GP+jEyCHUzxTyE/v9Y+FNc71VsiJrLlVyPeZ9ZCc9GE+Ziyr0Yxif
fVHSP9UPrOcnxovP4lDjX2ofslD+DaQ/Q7LS5u0bJat9z6P5zSL9W6lfwAG7
06UrZuCyVt7b7KLzJbQPTtrPUvLPIeZvsVv4uzxdzHOfW+iPsElW9zVZsupP
lGR1f8PJb7eYT1so7ccuOh/CAW+BO4eQnymNNdJ8lot98RponsvpvkBu/hJj
OVMh9nFeL+6Txkry08dVkpW8x6olL7ke6q7dTfr05JdH+BlmEH711Ij6uwxC
f+5e+r+R+rGPOFSy775T59Ej9usP3m8Rp78W3aV6WwPo/iuWrM57kWS1X4Xk
fyDpKxD7nqQV+5edT/sRRJwn9s2lk/eBT89/AJxxhw==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQvWz2EQUDr6kOmjH9h0xlFzrA+HdV2Bqn6kH5DlMd
Zs0EAp2FDskCEZZbLKc65D7/vdJQe6HD9Dyh5gNmUx3C+HQ3xWotdAAaydBg
ONVhmnN3znONhQ4zQPK6Ux22nCjbF68Oldee6tB84NTCo6oLHTImvq2x15zq
wK+7aa6+ykKwOnmNqQ45QPMLlRD8Pys/XupVQPBB5qvLLXSoeKlm2AHU/+Xv
lQpNmYUO3uadjgk6UPdLQc3Xn+rQArSPVRKq3miqA9f1xQW2ElB5MwRf7Oa5
78HWCH47SMBxqgPI2KeSiPCBhRcAw8WLeg==
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQPff98mPeS6Y6mHc6JqRaL3QI2iHX+nreVIcNRRkT
33oudLj1sy5rz5ypDpox/Ye++i90+B78eOlsIN/BNG7XyYCFIMqzB8jfeqJs
3/xABB+kvjQIwbcHMjpDFjqcWui6rXjuVIfoFOv7/GELHcD2z5/q0HLg1ELW
8IUOL9UMOXQWTnXInPi25j+QDzZ38VQHruuLC2ojIPJrliH4YPNXIvhg969G
6J8HNP/0WoT5yQIRllvWI+wHm7dhqkMzUP5oCIJvAQwP1WAE/64KW2Mo0L97
SiZLsAD5D6tE1rn7QsNn3VQHbqD9f4Hh9QMYPtIrEeEJAM/Xq8g=
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQPeHQV4079VMdzDsdE1KtFzr0A/kxVVMdLIB8Va+F
DhxrZKKeVEx14NfdNFffb6HDSzVDDh0gnw/Ifx+A4IP1ByH4zQdOLWwNWehg
GrfLk6dyqkN0ivV9/rCFDnPfLz92Gmh+C1CeNRwi31Mz1SFz4tua/0B+0A65
1td1Ux24ri8uqI2A8hsRfPGb575fbkHwM4D67NsR+sH2dyLM33KibJ9891QH
kEWcQPt/BD9eKt0z1eHZBaXbO0MQ/LsqbI2iwQg+SP3JwIUOt3/WZdlA9Z8E
+t+5O+d5dSdUvRdUfQsi/ABJuJx0
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0,
       1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1,
       3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxTTMoPSmViYGCwAmIQnbWnZLIEQ7fDXRW2RtGrCxxg/A1FGRPfXlvgsKTA
lut6MSYfRX0WGj8ewa98qWbIEd7t0Hzg1ELXKwsc2sVunvse2O1g0emYsPTS
AgeBCMstJ/wg6qdeXODwfvkxb3PfbodHVSLr2M8j+NzXFxf8PYXga8b0H/q6
EsHfeqJs3/0lUPO9uh0yJ76t2b9ggcO2z3+vVLhBzZ8LdY9TtwOf7qa5+bMW
OPiYAx1i1e2Q+/z3yo3Toer1ux3CgApipy4AmztfpdvBwTRuF+fkBQ76IIPE
ux3CgfJ3J0L9y4HgW9/3753+uwvOn5En1HzgY5dDITDYFk+Cyr/qAoen7pQF
DkcUgKzHXQ4dQHdvnwoN3/tdDk8vKN2unI7gg/xbOhPBnzVz5kzJ2QscDEDu
edgF9l/oHKj8ky5w+KoC/QsKJo2XXQ78QP/qz1sADlf3d10OWkCJrfOg4fcF
wQf7/weCD4z1Gvs/EPsi50Hd/x9i/lKg+QwgwAyND6D9D0Hms3fD3Qc2jwea
HmYscPDkYdJu5+92sAeGp+c0qLxwtwMoGlKnQt0jgeALgtKHNIL/eOnsIwry
kPh7D+R/AKlX6nZoAaYv1unQ+FTtdtgCjDf5GdD0oNbtoAgMZsFZCD44fuYg
+LD0BeNPde7OST8HjV8gfxqQv/zCAofLvkkCESoQ9XsvQv2v3O0AisaJl6Du
V4D67zLUPKj7n16Ghr9YNzg+1l+Bhq8AIr+A448TwQcAAPm1sg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQrbtp7vvlK7sd/qz8eIl37gKHac7dOc/XI/gx/Ye+
amztdjjubd7ZOGeBw1GFDUUZO7sdgOTE3NkLHMD693Y7hPHpboqdtcBBMMJy
y4n93Q7RKdb3+Wci+M0HTi1snY7gZ058W/N/6gIHm/v+vdOB+nOf/165ccoC
h4dVIuvcd0LMmzt5gQOIer+l28HeNG5X56QFDnKtrwN3AN3HfX1xwd+JUPtX
IvhA18b0L0bwr/gmCUTMQ+ivfKlmyDELYf6y2UcUNkxF2O/Jw6TdPhnhPhgf
5n4Y/64KW6PoTIR+807HhNRZCPM1gQFXOhthP1j/HIT7YOGLHv4AlmbJXA==

      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQ/emSb5JAS4+DeadjQurkBQ6HvmrE9Ev3OGjG9B8y
PYPgh/HpbpKdj+DnPv+98uOsBQ6XgdojZHscZs2cOTNyxgIHoLK57xV6HO6q
sDWGTl/gsKTAluu6ag9EfOoCh60nyvbN1+1x4Lq+uMAWyI9Ksb7vb4HgA53x
9IIjJh/mPjD/cTcGH6beDsR4i+CD7f+B4IPdwQBxr+S0BQ7LZh9R2MDa43AP
6N6rQPfa3Pfvnc4Bse8p0D/g8OHqcVDcUJQROBvBh4UHjA82/zSC3y5285z5
uQUO8q2vA3cAzdsC9Hf8Bag8W4+DFjB8t15c4PB++TFvc5Yeh69/r1SsvAT1
DwNEf/llKP93N8S+KwscOkD8b90Ox73NOw/C+O+6weEtehURHuh8oPMnvr0G
DW+DHjg/GsSfBIkv0UVQ8z71oKq378Xgw8wHh6cpgn8FlB60EPyKffOl9JV6
IeFxBRo/sr3g8KoF+veC0u2fdVIQ83MvQsNHshfsP8bzCD5K+AL5KOEP5MPS
owzIgUDzYOkRnF7leuHpcdtnYEAr98LTI9BXNfbavajpw7QXNX3aY/Jh6e8w
yPwzPRh8mHqw+64h+OD0/xDBn5En1HzgJSI92oIk3iHSIzh/fUSkR1j8wNIj
jA8LDxgfJf92IdwHAIF83mM=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/emSb5JATa/Dn5UfL/HOXeAQnWJ9378JwT/0VSOm
v73X4bi3eWfjnAUOnY4JTy909zpsKMqYmDt7gQNY/4RehzA+3U2xsxY4VOyb
L6U/qRdsDv9MBL/5wKmFrdMR/MyJb2v+T13gwAACQP25z3+v3DhlgcPS2UcU
NnRDzJs7eYHDZaDxEUD77U3jdnVOWuDwGKQA6D7u64sL/k6E2l+D4LeL3Tz3
vRTBn5En1HygAKHflgsokYMwP2tPyWSJDIT9IOH3qQj3wfgw98P4d1XYGkVn
IvSbAwMmdRbCfM2Y/kOlsxH2g/XPQbgPFr7o4Q8ADhfGVw==
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQvaTAluv6nj4H807HhNTJCxwu+yYJRIT0OWjG9B8y
PYPgh/HpbpKdj+DnPv+98uOsBQ6Pl84+ohDW5zBr5syZkTMWOMi3vg7cEdnn
cFeFrTF0+gKHLSfK9s2P63MAap/7fuoChyMKG4oy0vocuK4vLrAF8rP2lEyW
KETwre/7906vwuTD3GcD4stg8mHqPyw/5m2uhuBvBdlviOCD3WcJca/ktAUO
2z7/vVJh1+dwD+jeq0D3+oAMdoSY/xTon8Wg8HHqc1AEOjtwNoIPCw8YH2z+
aQS/XezmOfNzCxwMQAEBNA8UDvEXoPJA+7SA4bv14gIHBhCw7XP4CnTGyktQ
/1hC9JdfhvJNoPZdgYaHfp/DcW/zzoMwvjokvEWvIsIDnQ90/sS316DhnYnG
Pw1VvwhqnnY/qnwFJh9mvhwoPPMQfHB6SEbwQf74HtUPCY8r0PgJ6weHVy3Q
vw+rRNa5B0PMzwWGBzg9BvaD/cd4HsGHhS+MDwt/GB+WHnWAyWw50DxYegSn
1/B+eHoE+qLGPqYfnh4rX6oZcqT0w9MHzD8o6bMCk4+SX1gx+TD14PjmQ/DB
6V8KwffkYdJuV+qHp8f3oPBR74enR3B4avXD0yMsfmDpEcaHhQeMj5J/DyPy
CwA++cxR
      "], CompressedData["
1:eJxFlHtIVFEQxhcpK101zR5QmUZBFkL9IRYqjliIiIRFD6MXYqCWGVJR9kJM
RErO9bmujzplloZpbq6P3HR9VShUlCQlImIiJCJhpmJSc+6Z5Swsy2/PvTPf
fDNz/OJTD51zMhgMcfgVv9nrvn2Ym2Xgf5J1zZo5TD97Gx00xqDUbDbHFXNo
mlkauDbIINPe9+hAIQefrMnYls8MduLz1gIOUUanXdn9DNbgA6P5HIoj7l2Y
6JbxriA/uRTqMtimWKTZUa+45KJXpv0Jg9F077psjBcycjDXVM6gIS0x70UR
hx7fl2mJhUz/f9DE4UtM/OrjGgOPAEtFfaliES/wgWJ3PE/lHAYE5zM4in+c
ekxczMB1sPLSUiXpK2Pgghz6lOs6Iquo/mqq18JgeJtzxpHn5I+duJZD4/ur
7Q+/MngXHZTTWcfB4afIV9GgGKvIS3mlWP9t5pBsu1ywYUbGW9tG+qek3702
DsHCjwkG45+2Dl1vJ/9GKH8HvT+g2CT87Fc8VlXW49tL8dqV/r054Wer3tA5
9icxb+rmHRv538IgZWKxZk+bYuHXm1bSj3wM6xtuUuyHBcZaqV/NDFBFn18j
1dPI4G/Nr88xWL/IE9Yg/b5loXpeUP0WqqdasX5eqVjX+1D6nWGh/GXUX4y/
+URC8EgJ9dOR38RAjHGSVXEQ1j/epDgJdXW0Ur4Kpvf1jI3mo1r5p/uB9fzG
eP6dHAzi00v5u0j/d8UibthPxfq+zNH84vv7cV0WDZrsl53DytpNJ34s0yAs
8PTrKOzfdueMou4VmtwH7Nf8YXRglSb9w/6Icj+6aLq/bq85HGrxyTrvqun6
tzQr1vfVolj3p1Kxvr+4P3WRo+mFyMLXoHJ5Pul4voz6Z9QApygnHPevAgeq
H1nsixnvDyH7vpsm7wtk0Z7D7pq+j9MlHIYWbieHeMjzXgevVizqjfBU/BTb
vduL9JWQX8jCz81m6VeCt6w/1yz1e6+n90ulHuNG4nLFjvvOKvZ3jabv1wLe
b6J9d43kb77UZ1uuWFxvN5wUex7f1/j+n5xvtwKax0W57wGFNK/ztB9FxH/k
voWZ1H3g0PMfe9TEiw==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ3S5289z3r/0OmjH9h0znLnCA8e+qsDVOXQflP+x3
mDUTCNYscGAAgav9DrnPf680XL3AIWtPyWSJ8/0OYXy6m2JXLXCwue/fO/1I
v8M05+6c5yug8nv7HbacKNsXvxwqv6PfofnAqYVHl0Llt/Q78Otumqu/ZIHD
kgJbrusb+x1ygOYXLkLw/6z8eKl3AYIPMl993gIHoLb3y4H6v/y9UqE5Z4HD
Fd8kgYhdUPfPgpp/oN+hBWgf68wFDjog9cf6HbiuLy6wnQGVP4fgZ0x8W2N/
A8H34mHSbn/a72De6ZjwdCYifGDhBQCavKLj
      "], CompressedData["
1:eJxlk3tI01EUx0eURO/AIAhtjiXaJtQfkpC2s6apOCk0K2TakAQrw/Ugyl5I
RQyLXbGZNpa/EJNBzR5W8/dby9aTJCophOwdMQpELKTCpM79/Y7czMEYn3vO
zv2e7zk3qaKmqHKKTqdbjV/+6x/qeNCbyWDDnLSrZVEJ/uWEkARFocTj27MZ
7IiNBoYjElQ1DB602CfmF6wX3Hs+58b3jYKz66tjo6UMfgeG+57ckcATHUlx
lDG4squq4VKPBEvi6rx3NzPQX8aD25TvZGBJL5fzI4LfGuPqXoYnxt2KBD+L
P7UvQsbTwE6Z6pdr953qlsCVNaO/zcGgyVZf3YH9BHM/1J5GPakOTzQd+Uvy
8unmTYLtK9zW9yWCuT5bMYOPtfHBhyGqv44BlzuI9bFs7EAhgyQ8mK9QvIBB
htvqbFdIb75gI+83T/Bj9Gt3LoPSLSvfrUXmbc9aQ3FZ0xtvIz/wPh3/gNbf
7JtiXqqea4LV+DnBWCV4wkfzzGJw/dHeSGuL1v/FVQzeoLCSZu3+kxYGOD5/
zRkJvvUVVsyzMpiL3NkkwcCvw9sybVr+AmQ1L4fB52eGgf1eCX7gPHx5mp40
5FeYH7ZPZrTZWdlI/SZO5vF8VZ9BsDrvZJq/l/xOYXC0B51EPeE9jQunLtX8
fIp8wXdPv8zEYGTsxb4A9sMw/7WJ9qmZ4ma6v4XqIW/FPf9zVrA6D79g1a/O
/+JdEnShr4vNtO84n69cv4k4RO/HpO3L826aP+n1yPSeUhkcw36mKbSf2B//
3xGF/MP+Z/a3uW6N75dRMJ/HkEEw19OqZ4CvwHVIEf7y+JhMnKD5dz9M88sQ
7/cvGekA3g==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQDQaNExxaDpxayHphgQMK/+ACh6gU6/v+0zD5zUB+
616EenS+Zkz/oa/zEfzMiW9r/s9Z4CB+89z3yzD+LIh8QzNU/cwFDkkCEZYm
rRMc+HQ3zX0/Y4EDxxqZqJT2CQ4bijIm5gL5ny75Jgl0IfiqbI1TnXsQfLD6
vgkOx73NOw8C+SBz8idA5YHmt4vdPFc+aYJDGFBCdhbUvCkTHLacKNsnP3uB
w7LZRxQMpkLcUwp0L1h8JoL/sEpk3fFpEL7pTKj7J0Ptm7bAIQPoL/t+qPlT
of7vngCxd/ICB2Do9U5vm+Bg0emYsHQS1P4mBH9PyWQJlnoEv/KlmiFHzQQH
RaAHBCdD3VM5wcEcKP90MjS8yiDhuX8KVH0JxL7vUyHq5xdNcPiz8uOl3ulQ
9xVOcBACRpgi0P0fgfZPKJjgoAAKoNkIfjjQ/XfnIfiw+AXbn4TJB2nX3b/A
4REofFInOExz7s55vh/in5ZMqH2w9JMLNf/QAodCW67ryoWQ8Jp7BGof0P38
QO76Y1B++QSHuypsjaInoeEF9P+smTNnRp6Cxlf1BIevf69UrDwDie/3tYj0
DADDWVab
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/VLNkGPNvgkOYXy6m2IPLXCA8bVi+g9tnYvgz5o5
c+bNWQsc1rk/rBLZP8Eh9/nvlR9nLHAI2iHX+hrI576+uODv9AUOc98vP3b6
wASHPys/XuIF8k3jdnnyHJrgYHPfvzd82gKHVyDzDk9wCAfad3fqAgexm+e+
Bx+d4DDVuTsnHciPSrG+739igsOGooyJukD+9+DHS2efweSbdzompE6G2Oe9
AJMPUz89T6j5wBIE//bPuqw9y6HqoXyblRMc7qmwNV4F8oHU1MOrJjg0Hzi1
0BXoXpfunOe/V09weHpB6fZPIH/Coa8ad9ZMcNAEhs9XoP9UQerXQvkzoOat
m+Cw9UTZvvuzEHxYeML4oPDxXY/gcwHDz3bLAgdgsMx9DzQPROdvX+AANFUj
Zi3EvU93LHDgWCMT9QRm/05I/OisgcTHxl1Q/mpIfMruhvKB/gHG2rr23dD4
WQGJr727ofGzHMFPEoiwNFmK4J9e6Lrt8yKI+2p3I8IXHN+7oPE/DxJeR/dA
+Nm7EOkJABodOQQ=
      "], {{1074.293, 2156.308}, {1066.949, 2147.714}, {
      1066.105, 2147.714}, {1068.7150000000001`, 2156.308}}, CompressedData["
1:eJxllHtI01EUx6eQmUpa+RgVlqCi5rCCXmR4wiJEJFDKkooYSvbC6EX0RFJI
SroX23ST1U/CQhAx2dI2LZNeGBSIJeZjaX9EREXWMEups3vPr0ttMMZnv/s7
93zP93tvgrksvyTYYDDk49f/+2bq/IHOCQZpu672uDo0CG1eXFQ8w2Bt1ca9
SQ80aNkydvrabA7b55radvdo4Phy+0nuPMWl/NPZrFjFncdrjBULOYQP3DzS
9VCDHwXvGhfFcwhDPtetwa36R0tbEyRvwPqr9rhzriRyiDS1OTK6NPiQvCK0
OZnDSGJI+Ta35PQUDnabzbYT+8vviK/8iDzd9LUvz6W49WgpN91RLPQ4FBcV
r/e+tGuQuwaFpcp6g3WkJ43DKO73qlYDg/+zjMN+1PXbSvunc8j0bq0uRL6O
65+bOBSi3hGLrH8wg4Ml+/Khfcj4t6NsJfWDzHp8KcOrA9nfRkmNBkP++c8J
ZH29f3714f+9H6lY6JrPhQ8XkLGN92eiufTPKue9PJb0W0l/HIeL3b0Nj2vl
/COMHCqQZ9k0iB18MVlglM8rbVTPKP2IqVesz1dn0X+r4iwsXOWkPMVJv6rb
pb7MGNn/4XsaTPTlmaMWkJ8emmck5aOT/AlTLJ4HK8a3zOwnk/1hXvQ8C30u
xXq/Oruenbx/wy7zHf2NwSUU3l5H/iL78zuD8zFH7Vjn/M7gKQ4uCHkT6vvl
Y0JfjpX8mWQyPxbSN8XkPCyU72n21y/BQTyAdf+Fvn4WwPp6wa//rRcxpFjk
dZT0W0iPl0Eq6vdhv70Nm+8eG6Pzred/nPazK9bnpbN/fWOLYifOb4mT9h+X
9U+0kx6q39hBz5HFeUO/k0LKLdlvGfhm+k81uWleXvLPQ3ml/is9lO9h6UeX
h+6TIcXi/UHF4vwOMHnfeNT8hJ9uug/6aD56nj6zv/eXng+d/wDcWoAr
      "], {{
      1104.0939999999998`, 2135.027}, {1116.969, 2135.027}, {1116.969, 
      2131.261}, {1104.0939999999998`, 2131.261}}, CompressedData["
1:eJxllGlIlFEUhqegKLOFViLKjFZQoh+iIOGRiAgTySArKkSSbCFDqGwvxHQo
yTvmuKVeSzHRVGwMsVyyRkXLdXRG3Bqz3DLRUhOa6nzfPcON/DEzPDP3u+e8
73nPOAeF+gfP1Wg0AfhSPp0iRw6WzDBwMD+9eNPCQWEPGwMPrXfglreCld//
ZY8pBjuOP6y6VMtheOuuBXnjDKJWdzRcec/Bs9cvZs1XBoVhIcy1kYPbydL9
jv0MfuWMtyxupfs6GCzCejYTnf8g2b9kQ+TIK8mtvkHLLPkMujfPvxvfTJzF
IKKyLsNYJ/hIGgOl0EKjuC8hWfTnVi5ZOb/3peRjpzx7Gws4TLTgBami39Ec
DleHUNATBoeXuBalZhJni/590znge1Dscwbxe+6fP53CAU+NZRfT84kcOmdu
nX1dRn7o6flq4e/ueA7hyNENkvGageutkq3XVubvs4h6McjGjYVhg13kp57q
Wxk44xfNeur/C4MaH3ftmwQO7/B8yDD5lyhZnW+e5BVoiBX1H3DXen8cYpCc
lJS0toj8HaR5vyAeYLAUhe40cECVN7yw3uemTZ0zBppfv/A3spjmZxXzWoV+
/zz0KWtdj/DzBLKL4pdlNqv6S7jq27Sjbhbbz6u+OkjGp6t95klOvLA8onKO
Tu3zdjH1/4fygnow8po7vxl4YV60dr020c/6Qsl2v+zcg3ra0F9lnC5TdB/O
Zxr1pXxjUI3+ez8Sedg2QHmJozz0Cn+P6mjeZgYBWK+b0TwaJCu59DNIVvvl
lG89+aFjgNUCg9OE/vpoBpM2U3hOJu1XBAO9UihXsqrPIFndx1LK0z0GZ9Cv
igrK3wPaHyPlN07Mv6Ce+ntM9ZpI7zPKi4nyWET9mmkeZf/9v9RLNtReLndq
kqzup4nRHhBbyA+zOJ/eRftlpv3vY+JcO+kbojy1iTyeGxX3RZlon8Zon0zU
/7hkZe1DJySr+/qd6ploXj/IvzbyY1LsUwZybNXk9i7kPqxX007+TUl9fwH+
08PD
      "], CompressedData["
1:eJxFlGlIlFEUhod+RLTTZmUuY5JaSikMWhpzRCvUxLTM3G2yUEsModB2CbEI
Sa+Zjhu3RM0w08l9V1yioKICKxOzECuJIUpKTOh83z3D/SHyzNw5933fc87V
GtLCTi7SaDSR+Kf8954IyS0KZOASc3tg1sjBLnsm1MuXQYnRaIy8y+FNsGH1
MW8G1/ue3dt3h0POhvcv/ngx2I7nmws4BHne9E3QMViLByYZh5+vgw157qLe
OeSMb9vcb7hJri4dtN/lJNn/1pnpeS2DyQvr6nOw3pB9Q/pXGwaN6Un5jwo5
RCV6T7zcxMAHdY4WcfiM50asGKxyM5U/LpGs1NNVSF6J36dxrtYd2cjgKH4Q
e594M4Nlo5VnFypJH963FHlvNYek/B+X9A7k/wH5dWYw7rg4K/yhyKdtJ3Ed
h7A22+yZPQxGMIj+eg6WPJX7yhslN6Cf1CeS1bqtHPCU2SlA1FvfKfQd2C/y
HuriMIh5JPkxmHrlMJbZQ/np6f5e8fua3ZL9MM+LOslob4mrB9Xrkfq9sG1V
3fQ99kfxfbWL8t/BIHV6vta9U7KSV3e70G/lyiAC/Y23SNaizNBm0a8QPL8G
L9Q2UT9cGPyrxclA/2NzV1J8nEXel03kZxv5N5GfrZLV77WSVb12Iu8sE+Vp
Q/3F+rq4joDlW6ifTZSnNYNfC28zkpslK2M71SI5Gf33ttN9tgyanp7vicc8
MpULHWV+ah7o5zfWc+nn8PfwlyprD7p/gIOrot9H8gf02+UvWd2XIJrfftJ/
iPrVxwFXUnPtCAO9YqSXzkfQPnTTfkZSfp1i/k5HiXxXdJDeaKHfrlWyuq8m
yWo+lZLV/a0g/9FiPj3LaD8s50s55A3MOn9EHlaEldB8xoh9MRppnmPpvUBW
1sAcK/bRXCzek3dxlKeF4yUfxLKfEiRXmGuGnx8nfcWUl0HkaWMUeWkShf9c
5CrU33CKfl9C/UghLpNsee/UeTwh9msO3zc1txjKl9H7Fy5ZnfcwyWq/Qij/
AtIXLPbdDet9x3jrgmg/CsX81gWKfdMXyffAouc/qbihyA==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQbX3fv3e61yQHzZj+Q6ZzFzjA+HdV2BqnroPyHSY5
zJoJBGsWOPwIfrxU2mqSQ+7z3ysNVy9w0N009726+SSHMD7dTbGrFjgcVdhQ
9MJwksM05+6c5yug8nqTHLacKNsXvxwqrz3JofnAqYVHl0Lkl2tOcuAHMvSX
LHCoeKlm2KExySEHaH7hIgT/z8qPl3oXIPgg89XnLXDgAxkA1P/l75UKzTkL
HB5Wiaw7rgN1/yyo+fqTHFqA9rHOhKo3muTAdX1xge2MBQ46IHkzBP/2z7qs
PdYIvrd5p2OC0yQHEPV0JiJ8YOEFAG9AnMI=
      "], CompressedData["
1:eJxlk21Ik1EUx0eUSK8G9vKhKHujQD8ESUZJp0SiDxElRYhFLIWKiXOZ7sUK
qVDJNb06t7mW18YYi7mZmW571rJFGEX2YmFiJb0RERISYlFS53nuHTfzw3j4
Pefsnv///O+Tpi7ZXzRDpVLtxJ/8TPYvyy+sI3Bwfkbn4TiFf3l5iEK0rHHp
zCYCxZ9/+cZiFAb2qFNeOaf2f3QLzjwS2V3nFRzY9c7YdJ3Ab9/Y88d3KTxq
y+3+7idwQ3e8ob2XgiU+vr4gSGBlB764w/s7CGyXD4oJfrsmqepldGq9VqJw
LOXQli78vwb1lUb4+e1snjlMYfjn2ZPbcF5zziWNF/18WbcxOR31bCiwxDOR
1yZVWe95BVcvHuqv8AiuR32vrxF4b0wN9IX4+a0EZLmjYaYn1UUgDV8slHi9
hUBW7Y6jHonrdQhW/NoFyzbn2gjkF24d2Ytcmj170G3l9QjT6yd8HzgPu8w2
C/M3r0fkpei5KVipXxWMKgPVTp6nmcCtB+WxVgfzn3OZwBvc7wE7m78az8f4
XCU2Cumdrm/eegILkIPNFJYM9U8MENa/CNkgC0S9n56uGjZYKagxj012picD
Gdc5kXdlOm9Gf0WN3G/xdE70K/p0gpW8T/P8rXzfFQTO9z5sy0U9P/I+eJwG
ts8nyLLvPiOB8ckXeh/6wa7uUyZ+n9CvkquJz3fw85BPNIxW/mkRrOThEqzs
K/hfvYvCiotf94VM/L73cP0JDvHvx8juy7Mwz9/I9Foi/HvSE7iAfmZJ/H6i
P0y38pzE91dOYM6gW3s7cb/KBOsxjxqdYFlPlpYAblV7RhL7leuTOE8rs4bt
736U51cjvt+/n4EIPA==
      "], CompressedData["
1:eJxVkmtIk2EUx2cXibISun7pRhkJSQWFhQknrA9hEShFhEWsJLuRRURUFJJC
UqF7lpFbk2fpun2QajfdTV2lrcuCYZmZrjTssqmp2bScdPY+Jx564eXl957z
POd/zvkvUh/Lyh2nUqnS8Y19h7O7TPrxWpjSUpnvruJwPH1yy+I4LVya3eq3
V3DATyR7lEH7kviCWToO35aumrR8iEEH8pvrHFSxp5eBrhwfLYeBwFZ1YjdT
7otqOJR4h5bltEveePnIlz8BydNSHhn6fAx+RptPJ1/j0DZy/tB6L4OL9c+N
RTc49ON9pQ4G1menPMGbHN5j3GVjcFDTc67uluS1xRv2Jt2XHNO7/SHVc9D9
dg4ZyGcfi3yTk4PrpHbuhJcMLHj/gnoOSfEFZRlvGexAYbu9pKdT8m39k4Ur
Q5IVfQMMHpzI06Q0UL/DDEbv9QdeeWieYyJ+1MVhzR7H5gScb3IOZtZKTkU9
uXbJSj82DurEnetWq7RCn1XEr4xRfxYOWTXzi0K4n13704IlZg75WK/yN+kx
C/2uiORY3utByaWo98MP0vuPewVPtdL5HgZNmanFDVaaZ5hBWnDb1TmoNxLz
T5jya2l+YZEf56T9fmeQh/u64KL8r7RfN+V3E3uo/y4GhcgT66i/DsmGvjuN
me8kvzBusg2in2IHfW7K99N8nDQvH/m3hvprZNB5ZmZ1k1mysp9qyYo/7wp/
FOL56djHiiqK+6k+Jz80C/+36kX9w22in6flVP/z/5wQkrwFF/8R5z8Df3zS
UfyX8Nc8A4d9uH/LiIgbK2heUQZlaOQDRvI7+kPRb+LwF4Vg+mo=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/bBKZJ27wWSHMD7dTbGHFjjA+Fox/Ye2zkXwZ82c
OfPmrAUOS2cfUdgA5Oc+/73y44wFDhUv1Qw7DCc7cF9fXPB3+gIHoGxRhtFk
hz8rP17iBfJ1N819v9x4soPNff/e8GlQ80wnO4QD7bs7dYEDH0iB2WSHqc7d
OelAftAOudbXlpMdgKZM1AXy5VtfB1rYYfLNOx0TUicvcDgKtO+FICYfpr7/
0FeNGDEE/7JvkkCEJFQ9lH9DarLDPRW2xqtAvjdIQmayQ/OBUwtdge61Brp7
uuxkh6cXlG7/BPLbxW6eK5eb7KAJDJ+v06Hq5aH8GVDzgPytJ8r23Z+F4MPC
E8YHhY/vegSfCxh+tlsWOJjG7fLsAfJB4ZK/HWLfdzmIe5/uWOAAjDKGBpj9
Oxc4PAKG53FZSHxs3AUJ3+MykPiU3Q2Vl54MFm/fDY0fKUh87QXydUDxI4Hg
R6VY3z8vhuADXZk0QQTivtrdiPAFx/cuaPwLQMLr6J4FDpVAPocOIj0BAIUU
ICg=
      "], {{1230.695, 2156.308}, {1223.3519999999999`, 2147.714}, {
      1222.508, 2147.714}, {1225.117, 2156.308}}, CompressedData["
1:eJxFlGlIVVEQxyVCxDYpW6DFbCNDPwiJRokjJVJmuaRpmooYPEtzyVx7lqmo
1cv0uPSePjkmVoaZvtx3DTUSIjKwBQkpsZKQsDAxobn3jJwPj8vv3vNm5v+f
mWMbGed3YYWZmVkw/pSnRf22c1FaBnahhYN/9By6k9iWlUkMDHq9PriMQ4Kr
5fjuywyy+19Ve5Rw2GueVfriEoMDeL6Fcfi+z9HCXsNgAx6YLOaAUfaHRol4
V5E3fXg97x8h+djtmOnFYMmT6dYNI2eY+szDeJFWQYeafRg0JWqKnpZymPf/
UltxksGRz6d14+UcGjwn00tOMFjnYDI+M0hW4jlVSV6L3+M4sReDQHxx/gGx
N4NV4zXxSzVUH+azRHZ9yMEprPP46gDS/5j0hjCY2GOeFfBE+JMTSVzPwSZ3
xrc9lsGIl3PBQAOHZT+VfMYmyY2oJ/a55DwlcRuH0WqP1rkMEW9jl6jPOk34
PdQt/DiYzGDqza5Pab3kXwLl7+OAXWm9EiNZ8dFTI1nNE0XxemX9LgXuEbU9
9D2cgabo57XrlK85jEHs9GKdY5dkxa+eDlH/V+SzqG+iVbItCvRt4fAX+7UV
eT0mtG0mv0MZ/Kv79dYb9acpAxMi/NaaSE8Q6TeRnkDJ6nd/yWq9vsLvLBP5
6UP9xfhj3pFW709RPym/NfLc0rvU6BbJzqh/qlVyNOrv66B8GK/5ZXJvOPqx
GdONBUr/VD9Qz2+MZzfAYWhnY+K3KMo/SPXHSU5FvfkpktV9yaT5HaD6s6lf
/RyMs4+GvfIYuCmD2Efnb9E+9NB+3iH/usT8ueiEv2s6qV6dqN+mTbK6rybJ
qj81ktX9rSL9OjGfzpW0H3fpfAUHexNWiDyM/rsbaD4Lxb7o9TTPhXRfIH9c
yLzYfU/s4+x9cZ/UFJGfyPEKF0v+gXrrmeTDuPflJVTfffKrVPi5XS/8Gi0T
+nXIR7H+DD3930D9MBJXSl6+79R5LBP7tYD3m1/7jtwZ0qstpvsvX7I67zmS
1X7dJP8Z1XdD7LtDiZjXlEzaj1Jirdg3t3J5HyzX8x/ZUrse
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQzbFGJiqldrKDZkz/IdO5Cxxg/LsqbI1T10H5xZMd
Zs0EgjULHI4qbCh6kTPZIff575WGqxc4nF7ouu1z5mSHMD7dTbGrFjgkCURY
bkmZ7DDNuTvn+QqofMJkhy0nyvbFL4fKx012aD5wauHRpQscTgHli2MmO/Dr
bpqrv2SBg9jNc9+Doyc75ADNL1yE4P9Z+fFS7wIEH2S++rwFDrd+1mXtAer/
8vdKheacBQ7r3B9WTYmHun8W1PykyQ4tQPtYZy5wuA1SnzrZgev64gLbGVD5
TAS/4qWaYUcegg/kcuiUTnYw73RMeDoTET6w8AIAfDOeLA==
      "], CompressedData["
1:eJxFlHtMzmEUx5uRyCWpNJV0cYn6o43FaJ1GMzOzaiHLZY2tTCu557aGYdYs
zy95X2pP3oUsqdfbTTdlybSZyZZK2UtJJVFIqnF+z3Py/PHut8/v97znnO/3
nPN4xSZG7JtkY2MTjT/9aZfvvmOvvQZ+MVfrfho4VB5mrpMnaWA0GAzR1zkc
DJ7e7DPG4NyTFzlhGodFtqkZT0cYLMPzxYxDz+JAO/9fDObiAes1Dhhlacwg
E/GOILu0vByO/Kp4/ZUD3aPdiq0pTgUNH5h4XsR4sQ7bV1s6GBQlx6U/yOAw
HPkx92Yrg7Xvt6Q1Z3Io2GBN0d4ymB1gznpoVKzHW5mteBZ+T+TELQy24oud
t4nbGNg3m5LGTVQf5puOHHyHw8pdjzfO+Mik/nukt4dBu69tatR96c/5b8T5
HDwv9IWXjTJo2BR0ubaAw4Sfer6sIsWFqCfhkeKLeuJSDo05YSVD0zQRz7lC
1uc0VRN+11dKP1ZM1qDrlXfbiWry7y/lr+GAXSk59Eex7uOGX4pFnkHZv/pq
Vf+qy6F7cqvoez+DuPT+U2cpn+ULg4Tu0bzACsW6X1Xlsv5O5G2or71EsRcK
DC/m8Bv75YbsiAm9LOR3L4OxvO+vN6P+E/rA9Ei/T5tJzydZr7OZ9HQqFt+t
ikW976XfqWbys4P6i/GbNsc6vH1H/aT8TshD42+OxxcrDkL9XSWK41F/TTnl
w3iW50erd6Mf8zBdU6fyT/iBen5gPL9aDvULC5M/D1L+Oqp/XPFx1Htpivaf
xb7M0OT81lL9c2T/o55wyBq4+2yTswYh+iDW0HlXTe5DFe3nfE36VyHnb5Wb
Jvyd+ZjqRdbr9yxVLPbVrFj4Y1Is9jeb9LvJ+Qy6RfvhTudvcvA3Y4XIz9D/
UCPNp4e8LwwGmmcPOb9hyK0jZ/ZXLtDEPg7ckPeJyZPmGzlJ54WKe1Fvvpfi
Nbj3md5U3w3yy0f66WGQfjX6Sv1pyOuw/pNL6P9G6sdy4luKJ+47MY++cr9G
8H6LKFtwoY/0nr5G95+LYjHvjopFvxzIf0b1zZL7HqDJeT2G/Rb7kUGM+6/v
W0imug8m6vkH35rBpw==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQzbFGJiqFe4qDZkz/IdO5Cxxg/LsqbI1T10H5jFMc
Zs0EgjULHI4qbCh68WuyQ+7z3ysNVy9wOL3Qddvn75Mdwvh0N8WuWuCQJBBh
ueXTZIdpzt05z1dA5d9Ndthyomxf/HKo/JvJDs0HTi08unSBwymgfPGryQ78
upvm6i9Z4CB289z34JeTHXKA5hcuQvD/rPx4qXcBgg8yX33eAodbP+uy9gD1
f/l7pUJzzgKHde4Pq6a8nQxx/yyo+R8mO7QA7WOducDhNkj958kOXNcXF9jO
gMp/R/ArXqoZdvxB8IFcDh3mKQ7mnY4JT2ciwgcWXgDpSqRJ
      "], CompressedData["
1:eJxllF9I01EUx1eQREH5YPkSZZAPRZZRMk3FExEVZisrLbMomaXV2lz/ROzP
mitHSUl3002kK6EhxFixpW1ZZolhkJBF+WBWT0FEVEgvSZ3fvedyqT38uHx+
995zz/d7zr2LK+zFldNNJlMxfsYYeX760aIiBsvKrw1Eezl8qksJDZUyyPau
O5D+mMPl+WMvfx1kUDIn496+AQ5dbc/Swkc1O/Jnvb3l0DyYFnZ+PslgNv7t
e8IBjzBdqGVgrDrbzyG08WNdSr3kfIyP29q/nWMwF8eVfRx+vCqqSHYxGF+S
5NoV4/Ad+fpFBsFAILAH8yuz5k5Y3Ax+d+NMVHPYWdWccVez0NOu2RhHghzS
k1y+p24Zb6yVQ6ehp4HBezzvTQuHmXcWlFk9DKqbv9b/8dP5lxjkTViaSv1S
f2Yjg1JMfNwn4494GfjWXzl2GDkV7Rq9SvkgV2GcguZENqO/lTc4CP+tiazW
G/6ZDv23/4jmiuTdOWtsTPw/j7wFA304TvXzS7+Zg/T7SX8NA3f/cMdgi/Tf
7mTQgDwjwGGh58v2Xqec9wQonlPWY16bZuWvYpF/WHNB1v6YN0L9VCPr1dTD
IYr6btpl/rYHHIY7Ntw/YaN6xsnPauqPh1Qfq2YxX675Be7/uZPyi5F/RaQv
qlnlq1jkEZT9fQa5EceeVqrvVtm/U+gPdk9TqoXBUKHZOw250BC6Terb7Kf6
FFP/+EjfDvLDR/1dousleG8iq/oLfSsSWa0XnPnvfnuWZtGv2aTfR3rWMliK
+icx31G8Xu9yqT9U/+fReUHNyi/FxvrOkGbhY4TOz5PxT/WQHorf2UvzuXTf
sN7Lcfo25jM59bq2O0Z+5VD94tSvlL8nTv1tpvckTu9Jlmaxf7VmcX9X0XsT
1/6JesboPcggf1Q/bdLvl+oPxX8BOadvKw==
      "], CompressedData["
1:eJxlkl9I01EUx4cPIoZpIviogwqNfPDBFDQ6Q8MHE9GHjCiRkZSgKD6Z1oOE
4BDR2VU3nXBFR0loKgrig+ZK53/XfrOptLRApllOo4hQofP73SMX9WH89uHc
c873fM/RG8vyioJ0Ot0N/KlfJdsYcW+NwYt3c121Fg53kk2GTQ+D+AeNjqRW
DpU7VxPrXAxuJRWMmRiHr1VR/ZkL9P4lh6cYD5lh4MxKNtU0c7iYMNRZ9p7B
BW93+bGZ8sclH7izjU3Dkpscf+I+v2GgH6h4cgnrf4jFPz0MQjF+E/Vk1Jf4
D20MWtLrSx7bqL9V9JvsknzUi5VfS07byGnw9lO9TgZfLgfXrAxzQHmBV3ah
//YYhymMb/cxuIbzjkxwwDb+6lEGmGUudVD+lGRtvkXJqdgnGv1KMRkKr0xy
OPHTh/1axiVr805LLvUf9iYuUD4y2l5YtCy4bZXyXRRHBvR/9iMHVD+d5WVw
VxXi5hBTu5ub8knMH6ZwUNdxfUX491whfxWaTyF/3JK1fbjOxJeYmFOh+eeF
vi036ZkT89o99H6L7mWdwzdk58551vTYJUfiAvSc7uc7g3xs6LPRvSAPor99
HRTfpftq53D/UerGMnI46ntrpf39oH5Wer/HoNj889mERbzPCcj7VvU69yVr
8/+SrM4d+C38XLRQ/b/C74cn9f+R/20U98l7PrVv5P+NUbnI
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQfdk3SSDi5hSHlgOnFrLOWeAA4zcD+a2bFzi0i908
9/0GhH906wKHR1Ui645fn+KguKEo4+J2KP/qFIeNRRkT1+6E8i9Pcfiz8uOl
3t0LHLacKNsnf3GKg2ZM/6GveyDm3zg7xcG80zHh6d4FDqZxuzx7Tk1xmDVz
5syb+6D2H5/icFeFrTF0/wIH+dbXgRZHEHxvkMZ9CP5LNUMOnZ1Q9wP1W9/3
752+BWJ+6m6o+eumOPDpbpr7HujeCqCGjtVTHISBHnq4CcHnur64wHYNgv8Q
6I/2pQvA+vLXQc1bsAAs7g40/x7Q/qvA8AIZq74LEj6uMyHuWXMAYl7tdKh/
jyP4PkCDHpxF8EH+2wEMr8yJb2v+z0CEPyw+APRG0w8=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQAmIQve3z3ysVV/oczDsdE1KFFzjA+FzXFxfYii5wsL7v
3zv9HoLPAAKvEPzHS2cfUfjU5zDNuTtHXWyBQ7vYzXPfv/U5cAPl/4ovcJCN
SrG+/7PPQXFDUYag5AKHy75JAhG/+xweVomsa5dG8MP4dDfFyiP4YP1eCH7u
898rDf0XOGwHuQ9o3j0VtsargQsc5FtfB+74CnH/06AFDp48TNrtH/ocZs2c
OTMyZIHDkgJbrusv+hzuAtWLhiL8A+PD/IvOBzp34tswKN+pH84XiLDcciIL
wQe7p7Pf4RHQP8dh+uf1g8OnNhjqns39EPcD3XtB6fbPuiP9DltOlO2L94X6
72K/Q8uBUwtZPRY4xPYf+qpxr9+BX3fT3PVOCxxsQO590u/QDJRvtUHjmyL4
IPPkdRY4xID034TIu6oscLgCMv9Qv4MmSEJ2gQPQ2PfLV/Q7fAE68yUwvrYC
9c1v7IfH//vlx7zNfRF8ANvODoI=
      "], CompressedData["
1:eJxTTMoPSmViYGAQBmIQbXPfv3e6Yr9D84FTC10lFjgcUdhQlGHU7zBr5syZ
keILHDx5mLTbHfodzDsdE56KLXBoF7t57rs3gi8QYbnlRBaCf9k3SSCipd/B
GmSu5AIHsPkz+h24ry8u+Cu3wGGac3fO8zX9DlOBdLrKAoesPSWTJbb3O2RO
fFuzXxvBbwG6h9UUwQe7xw6hXyum/9BWV4T5d1XYGkW9EfZrAuVLAxaAzbUH
us8C6D7V4AUOV0DyXgg+2L92CP6SAluu6wb9Dl//XqlYGQQ1XxFqX+ACBwCO
xYhx
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQfftnXZaNyASHPys/XuKVXeDQf+irRow4gu/SnfP8
t+QEh+Pe5p2NMgscfgQ/XiotM8FhQ1HGxFzpBQ5g/XITHML4dDfFSi1wmPt+
+TFv+QkO0SnW9/klEfzmA6cWtooj+JkT39b8F13gkCQQYWkC1J/7/PfKjSIL
HEzjdnnyyEDMmyu8wMHHvNPxAdB+e6BEp9ACB1W2xqnOQPdxX19c8FcQar8I
gr9s9hEFA0EEf537w6opfAj9QTvkWrN5EOZnAN1hz4Ww/6WaIYcOJ8J9MD7M
/TD+XRW2RlFJhH6gMxNSpRDma8b0HyqVRtgP1i+DcB8sfNHDHwBmlrHN
      
      "], CompressedData["
1:eJxllAtIk1EUx1dQ9MKCmvaglhGV0bCgyKjgSC/Wpu7xKT20TDJUDMOorCCI
Wro0dou0FkQ3IiQocdJoCVkN3SQiBHuJ1UqwtSIiKiJE6Nzvno9LbTDGj3vO
uf9z/ucus6zGXT7WZDJtxq/4/XBsRlusk0F7bcX5r0Uc+vPKpr1OpvLbheNP
mgs5iPgtCcV1yUUrGoYVb2ysTowMMdifGLkV1DhYO65+a41TPQ8Hf+TXkuI3
kq0eWX/bAOW7OayNF5y79JJBji+39KaTg2O1L/d9P4OPfQsG1xRwWLWr09bU
x6BlA17koPinDIJY746Nw1HUM+E2g9OPnlwft1xxUZq1Y65FsdD3fTaHNCEQ
+UogENg+U/YXa5N6CjM47NiLNwSZjDMThxhMenXjwHozxXcqFmGLH6YytlFa
Pp3DkIj3prIRr8/zrOLBPyeq1jHFOM2o/aLUOyudwzzvF1e4hcE71PsC9Yr2
ll2W9Yexn5757bWfkDNx4K45io15GKzPP5v8PijPS+wc6tMHnh2pIT/zOYix
H69mcArn2+Ok/CqZ3+wifysZ/Bh9XleJft7tPdxl2UeMfltQb84eitfI390M
fuJ5UiM/StQ+dWP9ip2pbOynXq85lY14nS8oFvuS4f/vvIlBA/Z5T6N98jGY
jPMe9cj+f59hELWjUA/ts1fqzXIrXlrsj4ScisV8vLivn8W61dM88+R94Uby
cyvNr5VBFuYfWkn9RWT+JhtxlPbFQdwr38P9fMV6vFPxVBSSjX64w7ghMQYx
1D/GTf1EZX8PkE3ig6z77JF+XetmIB7aRI32IUL6NPn+pjxmEMK4uEZ+d/37
/yDeg8F/AeIEDiE=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/bBKZJ278EQHzZj+Q6ZRCxxgfC0gf6ssgj9r5syZ
N6UWOCybfURhA1T9V4kFDhUv1Qw7RCY6tBw4tZAVyAeKasSIQtRLii9w2HKi
bN98sYkO5p2OCaliCxwu+yYJREhA+E9FFzhY3/fvFZea6PD575WKTCA/KgUo
IjvRYUNRxkRdIL8SaD6HEiYfbJ4w1H1fJ2DwYeqdu3OeV/9E8MH2/4Gqh/Jv
/J3gcE+FrfEqkO8Nkvg/waEZ6B9XoHs/XvJNmsAw0eHpBaXbP4F8oO+LMhih
/heH2seECA+51teBO4D8rUB/35dC8GHhCeNbAK1RdUfw7U3jdnn6QN0L5Oc8
/72y0B/qXyA/jE9309wAqHuA9v9Z+fHS2UBIeJ1ngMoHLXB4BHTPcaD7QfK8
wRD3Hf83wYHr+uKC2mCo+UD/gt0D5B8F+ufFbwQfaMp79V8IPsjY998ngOn8
YNTwfhoEib/pnyeA/bM0BGofHyI9AQDuPhUU
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvc79YZWIz0QHzZj+Q6ZRCxxgfC0gf6ssgj9r5syZ
N6UWODh35zyvhqr/KrHAQezmue/BvhMdWg6cWsgK5Otumvte3Q+iXlJ8gUPQ
DrnWbP+JDuadjgmpYgscCm25risHQvhPRRc4cKyRiXoSNNHh898rFZlA/o/g
x0ulwyY6bCjKmKgL5IsDzb8chckHmycMdZ8eJh+mHshb526E4IPtN4WqB/IL
gPzFZhMd7qmwNV4F8l+qGXLoWEx0aAb6xxXoXqAvNWIsJzo8vaB0+yeQnyQQ
YWliBfW/ONQ+a0R47CmZLNEC5G89UbbvvhSCDwtPGN8CaL+qO4Jvbxq3y9MH
6l4gP+f575WF/lD/Au0L4wOGbADUPUD+n5UfL50NhITXbEuofBDEPVMsIPK8
wVC++UQHoC8LaoOh5ptB3RMM8c8WEwT/9ELXbZ+NEPxbP+uy9hhMdAAZnx+M
Gt5PgyDxl6ID8c/SEKh97oj0BACwtBEU
      "], CompressedData["
1:eJxFlHtI01EUx0dERFGJrzkzn2UpGbmcy+bcsQiJErHoofRiWM3QNpbvtCYa
KjHsplGzzBtisXyLRkUPK83wj4oMLELMQCoiJCoiSuj8fvfI/WP8+Px+d+d8
z/eccyOs9p1H5mk0miz8Kc8bV4bC13sYxOyvf/JLxyE7xzT5sp5Bk8fjyQrk
sDSur3mmjkHV4Oj1rf4cvr9Ot56vYRCL5wf8ONQEvnvxu4qBHx6Y8uWgHF/t
EvEKkfufFz0MK5f8scy/a6RQclfaVFmjg8EUvq/BeChJ48pj0Ou0sc4ADkPh
PU6bjUHyZIZ7XMthu7Eu9fBRBsswUXewZCWeIVSyotseTnyMwR58cSCSOJfB
4vFWx2wU6cN8i5DN0RzG0q0+bx1U/xqqt5jBxMoFlbtjhT8Zp4nXcrhf0BBU
jf6MYODH6zjM+anka46XjFWw/A2SVd+MHC6f8K0avCTiBZg47EB9HxqF38PJ
wg/NBQbTryLfl6aQf27Kb+FgY9/KLbWSFT/9qyXj4+JTF8VLkfo3og1tZg6r
lO+nmBrnDOVzlTHI//TXG2+SrPj1IIlDG+rvQd6L9U0kSo7AAjMNHIaxX59L
GWBVoxEJ5HcJg39edBLr12LZY0XC7wo9V/s+UkD166kep2S1XrtkVW++8LtS
T37mUX8xvsOMkY9TPxPIT+z3j9k3JbkGyYqs6UTJuZj3URLpwXjKXBxKFvPR
4pT+qX5gPT8xXkwqB6vPvqR+F+XfTPrPSVbavKtBstp3D81vKulvoX4BB+yO
W9vKwGI4eG+bhc630T6YaT9vkn8mMX/zvcLfJZs4DCh6vUJ/mFGyuq96yao/
UZLV/Q0lv71iPo0htB+36PxyDngL3D6J/ExpbDDNZ7vYF4+O5rmd7gvkki/R
8bUdYh9ngsR9Yu8kP+e4S7KSt7hb8sKOkOycHtIXRH71Cj9X6IRfl/pE/W6d
6F/aAP0/mPpxlzhE8tx9p85jr9ivP3i/hZ79mnmH6q3wpfuvVbI671yy2q9r
5L8f6bsq9j3OX8zrlibajwBij9g3i1beB3N6/gPrSItD
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQvWz2EQWDmRMdNGP6D5nKLnCA8e+qsDVO1YPy+yc6
zJoJBDoLHJIEIiy3dEx0yH3+e6Wh9gKHGXlCzQdaJzqE8eluitVa4AA0kqGh
YaLDNOfunOcaCxymg+RrJjpsOVG2L14dKl810aH5wKmFR1UXOGRMfFtjXzHR
gV9301x9lQVgdfLlEx1ygOYXKiH4f1Z+vNSrgOCDzFeXW+BQ8VLNsAOo/8vf
KxWaMgscvM07HROqoe6XgppfN9GhBWgfqyRUfeNEB67riwtsJaDyrQi+2M1z
34O7EPx2kMCEiQ4gY59KIsIHFl4Acm2RQQ==
      "], CompressedData["
1:eJxllAtIVEEUhjchsRLz0a6vyoKMiiwFxceueMwixCQwyhILkSTLyt5EZSEq
JCE6tyRMrCuxhSARoRW1mmk+2qAgeuA7ywiLEAtRUbNzZ84wyC4sl4+ZOXP+
8//3rs7OT8txM5lMafjnz6crS371MNiQWd7aGKPDg+1DF258ZxBTmpgVmqBD
qHthZdsogz1eYY/2b9Eh6drRHxenFOOjJv+f4mzvvbENbhos+Xz3RFOiDjWj
9ztS3DVYjFwAOuyILk38skhwPNbvmbp8xOGpwVKsszleh4rW8XV9Xhr0r3Ev
3B2nQzlyprcGt6qqqvZhf5O7vtmDfTSYqRt7nxql+OGpXBYWoZjrWaE446B1
8F2QDngqu8JH1OsOID2+GgzgfR/9dbhX/WpVuJ8Gh9nvS3MWun+ZBrbBnWXp
yFtx/7RZg3TU228W9av9NajEQoeQG7rONd8Jon6Qow48S/YMcWUcQ1aOnw58
/mPMheX+2zi/N3/Z/POTik3Gb5pBLvZ7BXlkbYRH/Qz5h/2mGIXRH67fQvrn
GBS1OGvbUW8vzt9m0qAYeWGgDo4z1wOKkY31kkCqZxJ+mIMVy/lK5v2HK07A
RksjKU94n+FXWbTQlzcr+j8Wq/O+E6bFeqqV5jnBRD5s5M8fxRPG+k/FN4/7
FrV8ZaK/OJpfD+mLUiz7ldzIfRL5TuplcNXS/fZJAPmLbOR3FufjUb88Y7iP
QScOcoG/0LdxgHF9yRbyZ5CJ/JhJ3xD5aaZ8Dyu/jHk7RlxZ+s/1OVxZ7ufc
PP+8rU0xz2sH6TeTnk4G61H/OPZ7Mh4n95ryIfPvpPuCFMt5STb22zcpNnIe
Ekn3O0X9s9Gkh+rbY2gdmb9v6Lezdtvj010Mxmc/nK8jv/I6yT8r5ZX6L7FS
vtuFH01W+p60KebnXyrm7+8LkY8Cq5of9zOOvgfPaT4yT5/U90vmQ/J/Sqho
kA==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvadksgSL2SSHeypsjVf1Fzi0i9089910kkN0ivV9
fs0FDqpsjVOdLSc5ZE58W7NfeYEDxxqZqCf2kxzMOx0TnsovcDCN2+XZ4zbJ
AcTglFng0H/oq0aM3ySHMD7dTbJSCxxAxgWHI/gPq0TWucci+CD7ypMmOQC5
c99LQc1Pm+RwF+ieqUDz5r5ffsw7e5LDswtKty3lFjiA3ZsPtU8Ryi+a5NBy
4NRCVtUFDuvcgTaUQvkqCxySBSIstxRPcngK1F8JdC/ImuX5EPNDpRc4nF7o
uu1zBtQ+8QUOt3/WZdkA3TNr5syZN4UXOFz2TRK4ETnJgfv64oK/gpDwOOyP
4IPcd9oFwT+isKEow3qSw5YTZfvkRSDumWIMCa9UiQUOj4D+P649yeHr3ysV
K2Wg/lWf5DDVuTsnXQnBB4XPXE00eUMoH6ifC2hfrTmUDzQ/HKj+rjWUbw2R
t3VY4BC0Q671teskB6CrJuY6QcMrCMEHx28Mgq8DCp8UiH/2AvUnAcPPJBvi
nlhbqPsLof61RIQ3OHxNEXxYegIAiBMKFg==
      "], {{1165.504, 
      2073.3550000000005`}, {1176.066, 2073.3550000000005`}, {1175.98, 
      2074.8230000000003`}, {1175.809, 2075.8550000000005`}, {1175.551, 
      2076.448}, {1175.1329999999998`, 2077.3740000000003`}, {1174.512, 
      2078.105}, {1173.6909999999998`, 2078.636}, {1172.867, 2079.167}, {
      1172.008, 2079.4330000000004`}, {1171.1129999999998`, 
      2079.4330000000004`}, {1169.738, 2079.4330000000004`}, {1168.504, 
      2078.8940000000002`}, {1167.41, 2077.8230000000003`}, {
      1166.3239999999998`, 2076.761}, {1165.6909999999998`, 2075.269}, {
      1165.504, 2073.3550000000005`}}, CompressedData["
1:eJxllFtIlFEUhSUoutBFx2uGjtYkhpJapuZtTz34UCEFFdmFEAVfSpMuEgWF
mo5oOketUStPeClJnSm1LCSkEiLIygqRKPOhSELCKCJIaP//WcMhGhh+Ps5t
7bX2ORG5hbvy5/n4+Ozmv/E1fueGBO1ZFnvn4BZJXv6wZsH5twmSOlueWOPu
ay5KXzzedlfQugO1jwaSJC3sXpWT1yeobPjZ9fmpknibq4VuQaXMI2mSho7X
B5fdEpSZeOiBIwP7dwryFBc4j2RK2pbksB+Wml1H/UqHWzSbAl2CcvJSJ1/w
+v6nJx+GNwp6z3oa0yUVOGfOZApBzU1NTfv4PHNenaAl421Fc5s1s+qisyma
LYZA1r+dz//oFESsb9EmnNeA+jZK6s2aOu1/CftvkGTjY7c2C/ox96ZkOl7S
7NiO3DrWb5SRHwd9bvgVo9Y3DCn9tdHq/OzHgj6/jHyXYtNszg/XvJx9dIdK
4s+3qGFBaZPZNXuDoZfz+NM1O/Y8QNIAn9fK/pu6LOr81m7U74v57Zq5mt6s
Vs0jVk/xFxf88YP/TjDvVzK9Nr6yVlAEB/LKgvEarLcgv2rNQROjv15XaTb1
OVA/82VjfSX89UM/lP/P5vpIPd/LZn1V8CMM/XkR/q1E/9ULiub9TrBfHTzu
can8QgKR1zXVXzP+kr4zr+jQfMzo7y7NZn09an1TAPrNo/b/GYh8+lR92cHQ
14/1IZrNvEI18+yaoDD0m/f+WOGvG/0dAf85z2SWYVuN/uL7Y35t8OuKum/l
UchboD+jUW+1ys83BuyAn7HgC+o+TK2HH+y/2ScJmo16YhP/5Zlk5FshaD/X
vzwNeVVDfwb6ywn/7bgPLv3emPOlZtPvds1h5V93Dt4U9Invy2877m+P8j+R
OZzHk2+jfwh+9CF/0n572cjrxoDmisCJ0VP8nlmNggj13UNepPrLA15qx3s3
iPl2/T569f4F7kpz5g==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQfftnXZbNk0kOf1Z+vMQru8Ch/9BXjZjnCL5Ld87z
3y8nORz3Nu9slFng8CP48VLpN5McNhRlTMyVXuAA1v9ukkMYn+6mWKkFDnPf
Lz/m/X6SQ3SK9X1+SQS/+cCpha3iCH7mxLc1/0UXOCQJRFiaAPXnPv+9cqPI
AgfTuF2ePG8g5s0VXuDgY97p+ABovz1QolNogYMqW+NUZ6D7uK8vLvgrCLX/
CYK/bPYRBYOHCP4694dVU+4h9AftkGvNvoMwPwPoDvtbCPtfqhly6NxEuA/G
h7kfxr+rwtYoKonQD3RmQqoUwnzNmP5DpdII+8H6ZRDug4UvevgDAKpqxk8=

      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{1562.605, 2320.897205}, {2135.402, 
     2320.897205}, {2170.8590000000004`, 2320.897205}, {2199.402, 
     2292.3552050000003`}, {2199.402, 2256.897205}, {2199.402, 
     2082.4992050000005`}, {2199.402, 2047.0422050000004`}, {
     2170.8590000000004`, 2018.4992050000003`}, {2135.402, 
     2018.4992050000003`}, {1562.605, 2018.4992050000003`}, {1527.148, 
     2018.4992050000003`}, {1498.605, 2047.0422050000004`}, {1498.605, 
     2082.4992050000005`}, {1498.605, 2256.897205}, {1498.605, 
     2292.3552050000003`}, {1527.148, 2320.897205}, {1562.605, 2320.897205}}},
     
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxtlF1Ik1EYx0cXNreR0bcYWfRNeRHRlUUnTDCyzAldqHhhBjaL0RIvLDKh
rgpSwi7eg8khncWkJCqiRhcZIhldJCK1SmzCmvtqRlR003POeZ/32UeDMX47
X8/5/5/z39TsdZ9eYrPZmuArf/tTw+OTds7OH3DMnHorWHTbHvuI+/+8OUw8
KSqf7o0I/T/wk4mOl7NRwX7XhYdKajlzP9twbVdMsJuvfu5oPMHZYxgvjQv2
8c9lT/A4ZzsbYQQ4BLy/mrM6mB9ICNYD8z9VcbUPTwom6ztayVmXJ9i+MiXY
vqbnR24cIpbnxMrzeWtBd19F2tyvK59xvjq/k7ji+tnIxQ7iZWWP+lM+fb+B
pL4f93I2sr6+5UXCvO85XW8JsF0OtHF2GzbaHjf382j9wgvm+jOcnZQbR7We
u4G/dq56sDRCnKm3ZLku9JD4y5aC7umAYAvSD+BRX2tv2X3THzxvWLA34NMF
s56IX7DF98eal0O9DS3ls0V+sz6v3r9hSNc/79P+tQ2SHtLvH3dJL2TUM5fv
yL4S5Ecu43z0M5NdVcRwzb6xarP+QX1+sIazK+DPFNTv5683jtaaft2j/vwM
C1cHiDP1kyzrcU7o/pL9n8s4Hxn1rgfdagpJb9XfDtJb+eYkvdV6F+mt+rmI
9JbvYmAF6a38XUP3V3oVEyu/S/MZ9VX9FTLyOMu/OWL5LsYixMH2W+uuxg1L
b+V/yrD0VvdNG5be6j6LhqU3cqZ+krGfkTE/VJ2wH+aH0uu7YeWHTX6AMT/U
+0oaVn4chvr+xgwrP9LQ3z3fDCs/1Pi8kf3e54hRn1zGvEB9czkrb4qJ0T9k
9BfzA/3H/Fj74d2vKRflh7qnk/JD7eeg/GjtTVw6WEj5gf2J+ZGZ51Lvf84e
BKI=
      "], CompressedData["
1:eJxVlHtI01EUx6WHSEVBRAVFFGUkJNQfUZDCCRMJC0GpSO1BKJVWWtiDjFQ0
LMzUdKEcfFzf02GWT3SYmU3nTGVu+ZxmWpJSIhUVFXX2u0cu/THGZ3f33O/5
fu+5W85GBYYvcnFxOUEf5/fIzzsRXmaEvLkyU4pegMYtCImtXcK3REBw2P7x
gAaE3/p56+tCAT4pF6djaxGueC8b2Ers7pqg86lG+PrHdtNDCK2OpRIhqHHT
3coCAXtONR1aUaa4rvN6S36+YpLgEp+DsNLzWe4c7f+4fbebIQvBsDE4LLZY
wOG99w+8TUNIIj1Ly/j8VIRjtOFkhWKnjsQqxZq+pwKi6bvoIQKVORNeI+Ag
rf9KR8glnf51AkqxffMuOs8jNK3tW4OA7MurE1tzJF9rEjDj1COkPxYj69cj
7KN67s+lP731CBcyPt3++4L9Iz9/BE2WhLxSrPXToXhsm2uCvVuAMSZzfVIH
wnnaH9cntH0b2vn/VgHD9H9jK7ON/W1mtgvuQ7G/s9FqxZofBpQ6bbI+6nm9
n/0p5X6s0v+dJSj77FMcSHnN9gggl3aElrDfFsX31g71NJiFlmNUMYKD+jva
KeC787xC9oP6p591LwsQaqn+aRPrzZN5TZJfznMiUbHz/jzIVqzl9ZjzNPH5
WVJfZAf7+Ujep6hO7jcDIT7CGNNvVkyuxmRaFFdfpQR6+L7qZH+LrVLPLPJ+
m/TbUij1FA1wvwZ5P5YPCUgnPaONijV9bYo1P7sQaHe09yDn18f13vB9t0k9
l+w8X4MIE7fWVCX3c57DCBbhW/+F8nGjIKdG5LpfL/s9iuA1HpA6YFGs1Tcp
1vyqVazN+RPub1Se72lgvQ72o5LzID5OjTv0vD6GQLtT1+nZv3GEbtJXUy6k
TuI48i+oXOazZILns5zn4Z1irb9JxfPWI2fTp/g9Wlh/z+9VOc/LNPurZ79m
EJLpPt6o4Hn/zPkZFP/33n3g96iI/XfI+Wgu4Pztiqv8yGmrYq2fXgQdCTsn
eF67eX3hvaS8Q8jfVcX8npp5PkrVe7Cg5x8c295J
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQfftnXZbNydkO9Vl7SoLXLnSA8ee9X37s9MGFDny6
m+bm750NofcvdBC/ee775a2zHZoPnFp4dO9Ch6Adcq3Zm6Dq9yx0SBKIsDRZ
M9vhrgpbo+juhQ6qbI1TDy+f7TAXKO+9c6HDj+DHS6WXzobo277Qwbk753n1
Ioj+7q0LHV6qGXLoLJztwHV9cUHtZgQfZI7zRgT/1ELXbcXroO4B6g8DOlB2
DVR+GVT9qoUOpnG7PHtWznaYCrQofQXUvWtnO6yRiUqpXr4Q4u6NCP6MPKHm
A9sR/I+XfJMm7J/tsKEoY2LuSkT4wMILACdLoM0=
      "], CompressedData["
1:eJxlk2tIk1EYx+e6IBVhFMvSmpZmowaJJQ0nPWQRfYjIQcnoArqgNOhmFzK6
kFIgERH15T0VhzlneUFkheiosJs0t3dziYrQ6AIREkYRq9btec955Hzwwxi/
91ye////PCe38nD5frPJZNqIP+M/f+bFm2UWBncm/C9mj3KY5PZstyc1wMHa
ML5jvZVB/ZNXfMYQh/LupQ01K9X+9LZs94dCxZ9WFKavLlZsnO92MDhaOmu4
aoRDsPZGZr2TwfnqYO38YQ7xbZUZFRsYvDuzoOMl3p+H9Z8Cg0tYb/NrxcZ9
jYOKhZ4Yh7Gf56qDeB5leHp1DlUZFY5AKQMX6myNEJcweNB/8tHdMIe3WGcL
6vnheu/LQsYqD48XKxb3FSk2/LStkXqehykfO63rUv+IjYFt97W+E1EOltFI
0lUg/S6PUf18xaJ+nmLhZxmDg9c/n32M58X3XMpfl+xdwiCA+vdFZH7TF5Pf
kOqXyLtfsZGvq0Pxzrn2rj2tHDY1HvqYssj7rPfIf6b0o/k5lOF63SLKu5n0
ZjG4hQt+H4eF6C+OekJ47lsTh2c5nccO5DBZp4n0oz9jTsa9pNc2lY37Q5z4
qzaFJ/dfxkBPJRWfxoZcSWngTGy/ugvr4fQ41v7VhJ4i1Gfvuj1RYGJwAf3H
fbQ/jYHbU5LQm6k/ZqlnVYs8H0B+g40YaqF5NlO+9xUb+Yy1Kxbz1adY6MP8
jxj9Msv+egcoDzPpCVM/02Re03Sqb5LzmdBJ3z/ptwbnQeT8R5PzEJXz6fyt
ybxj5P+XYvGOkorX7e3ZOue7JnJMRlW+4j1GqZ9fNOG3bpDqz1Pv9z8IFfe1

      "], CompressedData["
1:eJxllgtMlWUYx5k2c5XltJUbrcvUapZbrZw1bT2OLjhGBGepU2tFiggGBlSk
Zhg1cEpI2GXjpfbpuXkUY3nr4soAUQ+HwzkHjsSoiOiCWtl15Gyr53vf/7sn
PWc7+/Y73/s91//zfOem/NK8lePS0tJe56973db2161fFih69r7L+nd2O+Rr
6rixtUTR8Lqr99bEHWo+G+jMKldUfSTsHO116NTNd07cU6Hob8+Ib1mfQ/mT
l9x7d6Wir2dM2JRMOpTmfjYoarlu6YrzJx2a88THC6+oUvQu2+nqd2j/8ec/
veFVRQf4+t4XjvY7vdbcv3zA0XbTtwrr+N4QXuvG+Y6iZSvmDV3Fz2dsWfPj
+mYTTzr7W8q/5+xQlPfh9a/d1mf8b/Upmj+UU7c4buK/PSD5Fjb8vOH+9xW9
XHS4wpNw6PdEdv7kg4rmbl7w5MqkiafpE2N/8CTi/VwZP+z/2oHoWG+nxKfr
ExHOcg0lhK+c/UFzab88r/MbFPszJ2x6M+Mb8e9y+4ii1RznvxxfPZ9f/oMi
D+e3uwfxjuI85+PmfWbU5Nt/Qti1M/6osL62CLvx1IcQ3ylzPiOI+p7G8wGH
Bs9tLJp/RtFbfOMWP/L9SVFrWWHDMz6jl65fFFVxPXu9sP+ropprBqJzvYj/
T/jfiX6fS2WtFwf96khle17b6xR+gOM9Hxbe+/Dwuu1RRYs4sce9eD6O/Dje
LufBg38kjB5GfNBDn9HnkB/6TSraw3qex/XgNMY8SVPv7219kogvJGzra9nW
37Lr72n0p7jP1OeFCOYtgfiiiKfHcHsMegrDHuvhtFv/dmGt98+E9XnWL6t9
7UtW/4cUhTnv8hjmdR/614N6tJjnq7uRf1BRhH/fF3ZMngHoOSz3Xd5yTNjm
b1nnYfUVNPmOWT3tMvM3NQA9h0w8s/2Yv92iLz0vLaIvPY+toq/DFY3TLtkv
/df1/iiVrZ60/+pUtue1/c3Cet/VoT/Qd3G9MnXzoh8NZj4CPthrVFTL8R1C
PunbTf+nW/0wf8v79lgQ88Q8a3l924GQsK2nZasny1ZPut+N2N/QU9c29DuK
+3WIN4b5qDV8VwL5vCKs9bJRWM/Xi9jfcfTjOTMf62OYx1K8L6LgIuyjCM4X
iJ4s2/ws630Wwrytwn4PYj4Kob8AeDX2I9f77ZIp1UeKoAcf6rMG/rzItwT6
YtZ1KZP+anuVqXyBPjJS+QK9ZF60f7LEn57PbInHHb+qHIlX1/dRRf/s+i0x
yQ/ORf0D0LcH+ywIex5Tn6aQ8P/nz3Jxm/BX/L5+7LhDfn7f38F8D9d7ZgR6
zMP7qNvM69lc3Lfvm1yj10tj6FcO9kUM/x8egT7j0Hs25sVylvBEFs53mcL6
+hD2Q0zqq/UdQ3wLoLcE9tFTF/1fKBD+D7iTe0k=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQvadkskSL2VyHee+XH+O+udBBha1x6mE3BB9Enw6e
66AZ03/o69WFDoW2XNcXx0LkT59f6ADSz5I216H5wKmFracWOiQJRFiaZM11
aBe7ea78CIIP1rcXwW/I2lNyecdCB441MlFP0qHmb17ooAq03zkZav/6hQ4v
1Qw51sTNddhyomyf/KqFDpd9gSZEzHWY6tydk74Mqj4AYv7jxRD1Oh4QfvLC
hQ66m+a+V7eH8JUXQO03RfArQRpU0eQl5jqE8eluil0M4W/hg7p35UKH78GP
l85mmwuxF+i+de4Pq6YwzXX4ARSP3orKl96D4LcAw4f1IDS8WOc6TAO6//lR
qP85IeYdBobfXFC48kHDCxi+t3/WZdmIznUAKkuxvgx1nywkfLqvQv0HdP9W
YPjcv77Qwfq+f+90XUT8occvADuk6Bs=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQzbFGJuqJ0VwHIJVifXWhgwpb49TDegi+9X3/3ula
cx3C+HQ3zb2y0AGkPkVtrkOhLdf15MsLHeRbXwdaKM11mObcnaN+aaHDZd8k
gRtycx0yJ76t+X9+oYMq0DxnmbkOQTvkWl+fWejwSs2QY43kXId7QIuunoSa
JzHXIRxo/t2jCD5IH/NBBP/0QtdtxjsXOgCteV4tPddBM6b/UOmmhQ7JAhGW
WxTnOsx7v/zY6TULHY4qbCh6oT7XwaLTMUF1OcT94gZzHeqz9pQEL4G6xwrB
B7vXEcEHq/eA+O/x0oUOe0omS7D4Qt2zciHEH4EQeeU1UPeFzHXIAPq3fiOC
/yP48VLpnQg+yD1LDy10eFglss49AOq+Uwsd1rkDRTwg6mcDw6vipZphhxOE
Hw0M33axm+fKrRHxgR5fAAqPxZc=
      "], CompressedData["
1:eJxllGtIk1EYx6WLSdHlg1QfIopuBElEiYRET1hIRASTICQqvIBZEKnV0KyW
GxUWISlR41SndrHZhpZJ5GrZtJYuNzc0L2UXhZIIiT5YGNRz3vMcDrUPY/ze
9znP5f/8z7s074ipcEpSUpIJf+J//kD3RM41BjmPFtsaXnPoWNJY8sXJoKjm
28nNvRxS7i3KHW1icGPc/WLWAIcVyZa6rCeaj26a+WZZUPPYynUpa0IMcgsy
3+/ql+cLwgx+5ow4h/o44NNLV6MMMi5sOVCI+bv4tpYfcQZeDJuMcehELu2T
8fYIh7x5ezZu6GdQ9QzfYH++7I/lqQMMmkqKaryvNJ8p9pfF2zWbcJ6vXs3i
vM3DZV7kczh4Rr3M3zzIjLmmumV87RCDT+Wpvhku6u8t1XdyWIB6xYcZiLFa
HRwGf50q9n9gMDftPluLjNV82aNU/w7NM5bIQq8uTvo0J7KKN/pp+Y9b/+XU
AAOG53c4iNtoH07ioNxHBFnMfaKdwRzsd9xF++yQ+Q6hHun7Hm+/iHwQ9/8H
OV/ogzy8PNnS69Gs9FUsfDAS1Cz0exniMi/We4fnd4fJT9RfdTeH+E7cQEDW
C0Sp31bySw/xQ81G3gbNZjTc+dvkN/SL8rOQMbNTs+pXsaEXzjMk9of8++73
2Ox60vc6M/a+3k3z2Om9i/zIyD9K35sMwhj/APXfWn348+QtBo3ozzQHzevQ
+0IZ6oKeRFb7N+odS2QV7y+7snCaWbOxz0rNYq2rLHR/lB+q6H45qT8rg+bQ
8af73eRvGwMr+nu6R7PSS7Ghd5tmQ7+QrOdGXr338vP0MNWjeDve1yysV2Gl
/BG6/6qfCPn9rNxXRZS+HxbyX5T8eFrez6weOb+1UrPhnwrNxn00y/1MRLV+
wp/5Ueq/lOrFyP+1+vul/KH4L5uHqoA=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLXbz3Pdg3nkOP4IfL5X+utDhO5CeLYDgH1HYUJQh
PM/hYZXIuvYvCx2SBSIst4jOcyi05bqe/Hmhg0t3zvPf4vMcuK4vLrD9tBAs
riw5z8Hmvn/v9Q8I/umFrtuM3yP4f1Z+vNT7FqHfotMxQfUNwvy1MlEpv18h
7I9Ksb5//iXCfWuA8tZAPsz9MH7lSzVDDi4EX771daAFO0I/B1DiCQvCfNO4
XZ49TAj7QfIpjAj3wfgw98P4MP9VAO3rYEL4XxzonsssiPABhyM7IvxA5nzm
RIQvevgDAEPtwPY=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvc79YZWI+DyHee+XH+O+udABxg/aIdf6ei2CH5Vi
fb9/1UIH07hdnj1Afn3WnpLgFQsd9pRMlmiRmOdweqHrNuPlCx3axW6eK5ec
52B9379XfNlCh6MKG4peSM1zaD5waqHr0oUO4jfPfb8sM89hjUxUyu4lCx1u
/azL2iM3z4Ffd9NcfSD/NpBvowS1f/FCB6Bx34PVMfkg955euNAhSSDC0uTz
XAw+TP0RoP0ZPxB8sHt+Q/jaQPuSgeq3/J3rEAzkrwbyK16qGXb8h8ovhfjn
O8M8h8yJb2v+L4X4l4UJ4h7t5ZDw4GGe5/Aj+PHS6BWQ8JoC5c9eheAjhydc
/hCqfPaJhQ7yra8DLZih4XEGGr5Q+16fhbqHEWr/+YVgc6SB/EdVIuvYLywE
x8NnoPtV2RqnNgP5wNhbd/wfhM98caED0HscOn8hfGcgv9CW67rybwQfbP4P
BB8c3t/mQsQvIMIXpC/5AtT9H+eC47P60kIHDiDjiSAiPQEAXI8qWg==
      
      "], CompressedData["
1:eJxdk19I01EUx6V/REYKRQWVFSUV4VOOMhNOaVSMgjnQ0BEyF1ka2ZqKSZqx
YWOLBeFTeOs0RExrMtOkLEqz6TbMNmuJRVSEgQ8SIRX10Lm7By708OPyuZx7
zvd8z/lttp4rPLkgJSUljz55Zi5pbh32CYjgwf5d/Qjxo9b0d14BRSuyghsC
CFnBtrltLQLMAxmurk4Ea/rxnAeNAn6Zv7RPtyN8urjq/qFaAWKu42XqHYSW
1VPjP6sEnM9blthyG2GrzG/VbDjx6Ii3SPPIph77N6OAKNXvpfdr6Hn8gIDL
ZwYd8Q6Ez5Q/lKP0/ehGkHrzDQKKSd+HXs2NFH9jULM8F46wvr0cH0GQ8swF
XP81gm9ofrvlmIDWfE/VqbcIhdRnZQn3M4VAWdc6KzRL/csvaN7omjUNNAjY
495f1p7g+CvszyRCG8UZ3QJKbbkf02LsH/kr6+x89R9HNSf9DiNM/6bOPAJ2
WHxDNWPsj1vV94yyfzSfvtHap7dCKn6fi/OFOL5Zs8yffUlzUn+94lnipd3r
S2x1iivHuF+ar7zODfM+1Ag1lwjrdQhoIv9XjrPfDuVv+QRChsxvV/5kxpQ/
i6qVP6VxntdZ7mdS7U/daZ7PG4RqOv02zdLPiEVz0m/apzQSFuB8wyaVLzLB
8zQq/+ajXO+wgN2k52tIs9Rz87lmGW94jPCC/K2g9387v8eu9SGUy35Nqr6/
B6HAUzXzp1hAasJf/aQLgdZopqFMqLnz/5Jdqfk67dt7u+bkfOu5/l2eVxP7
fQ+T9+ucApzPwrg4wP5eFeoM8j57ed8fIvwDtsbbgw==
      "], CompressedData["
1:eJxllGtIk1EYx0eESEZIRgV2IbpQUB+CosKiJ6oPURIoRohUTIWy6CoFGanM
kDCxkPJD7NTx0rKp2Vwr51rqSNfU4W7OZaam0B0pCAuLet5znpdD9GG8/Hae
97n8/895lxlPpeXOMBgMGfjTnhWd31dnTTBgk5auhBgHnVfGFd/0dHHYWXbi
XcGoYld+5cKSYcmmXg7ZiQe32GMM0p4uuXK8n8PGQ849syMMGhZl5hQEOf3P
IDMnZaQizAFLGop8DH6kj9fdjnAwY929HsULYv6p0DPF4v1WBo+9590jYcrv
oHohDkatvo1BI9abDtD5IwZ2jD/cr1jk8ysW7/dSfZucv8wnucdO+bwy/4Yn
DDZd3XEkt5uLvEtdDHr5bkfLC5nvGvZ/Ztus6LiHw4dV6+MbwnL+tuc07wT1
30bzfGbw9uK8pm6HYh/mO9es+Ff912C5lcOrn5fzXO+pfwv5M0Zcy2EX+jON
+ieZ2n2ccxjS4gOyn+V3OUxpcV7Fmn8zO//lEif1i6zlTbZJfT5xOn8o/dtf
zSFeC2wk/6upnlXxnHU282S9YqHPfQbHbny59IcTW0hfrPdR06vmfxb92VW8
zmLfMP8tXExLE4d9aMwo9jOGepY+IH/ttK+o11Gsux3nS4jWnP5dK/1Z20H6
1ZDfXsXCb79ioV+Q/Nf1jlC/daRHjPbbQvoNMSidH/NfqFcs9sWqWJsnu4nq
4fubMX+d7r9+f2xc7M0d9HN4RVxxBs7/LZhqTMT7k45xVgfth5viW6mfFib3
2kX9oj9Fea78kJvuM/pRiJzUQee1ct9SPdLPraj/ATRycZdi4edLxc1nUdk+
0veejDcH6D41MMCu8ivxvqIMU+k22uco6e9U3xvt2eNRrN0Xg1ex0KuPAW5f
edUgcYj0jBJHqV9k4XuM5h1Qeuss7s9rxaI//J6tycKTAdqfN1LPFMxXdXKu
qR1Zm7MQGVUyXh+R+5E8qL6Per9/AQJIwMA=
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3},
       {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1,
       3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQPff98mOnp81wmAeiPRc6BO2Qa82eOMOhPmtPSXDE
QofbP+uybPpnOPwIfrw0Om4hmJYG8vl1N83Vj1/oYBq3y5MHyG85cGohawKC
D1J3G4nPB1T/Pmmhw+mFrts+A/maMf2HSlMWQuwF2ge2N3Whwys1Q441k2c4
mHc6JqSmLXTYcqJsnzzQfYW2XNcfA/kvgfI6MxF8sPlzEHywOfMQ+kH+816A
MD9JIMLSZBHCfrB5iyHy2skIPshd3YkI/hqZqJTdQP/vKZks0QLUv7EoY+La
aGj4LITYnxwBCZ/ZsxHhCQD8aqf+
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQ3X/oq0ZM0QyHee+XHzvtudBhApB/JwfC745Y6MCx
RiYqJXuGw10VtsapMQsdXqoZcqzJgvBD4xF8sP4EBD9oh1zr66SFDqZxuzx7
gPo1Y/oPlaYsdJgLVOedC5HPToXI8+TPcDDvdExITVsIES+c4VBoy3X9MYxf
guCL3Tz3PbgcwZ+RJ9R8oBKh/xXI/mqE+VtPlO2bXzvDgU9309x8oP3fgx8v
nV03w2ELUFw+GcEHebM6EcHnB6rXB/rn9s+6rD21UH7sQgeX7pznv6uh6iOg
6ssQ4QcAhH2h6w==
      "], CompressedData["
1:eJxTTMoPSmViYGDQAWIQvc79YZWI+kyH+qw9JcGpCx1A/CkaMx3WyESlVIcu
dFBha5x6WAXB31MyWYIFyG8+cGqhawSUrwzlRy10UAWpV4Sqj17oIN/6OnCH
/EwH807HhNTYhQ4u3TnPf8vMdIhKsb5/Pg5qnyRE/e74hQ66m+a+Vxeb6WAB
VL80AcJfLjjT4Ufw46XSiRD1IjwIPtj+nzMw+CB3NOsi+Db3/XvDNRc6HFXY
UPQCyM+c+LZmv9pCh2SBCMstv2dA7Fdd6HD7Z12Wzb8ZDneBHg9VWehQaMt1
XZlpJpherLzQgQOkkB3Bh7kHnT/v/fJjpxWh4XdpBgYfWf2U6wg+UPc697sI
vtjNc9+DH85wyAC6t14F6t7HEPdaq0HD6+kMB2AoHfNWh7jvCZDfAdS4XRPB
h4UHjA8LL7B5VxH8/kNfNWLOI/gTgPw7p2Y4hPPpbroLjI8koHqTExD3JQP5
t4DhtecIxPzDwPh7BHT/8YMzHP6s/HipNw7q/v1Q+Rho+O+Z4dAOkgCmF2Cq
2Va8GxI+3cD0dBrI/7xrBjy9ge3bPgM1Pe6YAU+vAPQ/Sg0=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfVRhQ9EL05kOa2SiUqztFjpMOPRV4w6QrxnTf6jU
fKGD7qa579UtZzpYdDomqBotdHhUJbLuuP1Mh7nvlx/z1lvowAdUkO82E0Jr
LXTImPi2xt5vpoMqW+PUZo2FDvKtrwMtwhH8l2qGHDqxCH4/0L6YpJkOd1XY
GkM1Fzo8BJmfNtNhLdA9v4HmLZt9RMEge6bD1hNl++brLHQAuzcPap8+lF84
0yFoh1xrtvFCh3axm+e+l0D5QPda3/fvnV4M0X9fd6GDadwuz558iH93A+27
7JskcCMDap/qQoctQHXyQPeA/aG00OH2z7qsPZEzHQptua4nK0DCY7k/gr8U
6L4NLgg+OFysZzo0Hzi1sFUJ4p5y45kO84Dip9UWOrwC+n+N9kyH6BTr+/za
0PBUn+nwZ+XHS2cNEHxQ+DBboMnbQ/naEPseu0L5xhD1zl5QvjVEfrHfQgdg
rN4/7zrToSFrT8nlAGh4BSL44PiNQfDB4ZMC0a/sDwk/8WyI+Ye9oe4vhPrX
AxHe4PB1RvBh6QkAT0YY2g==
      "], {{1613.477, 2208.554}, {1624.039, 
      2208.554}, {1623.953, 2210.023}, {1623.781, 2211.054}, {1623.523, 
      2211.6479999999997`}, {1623.105, 2212.5730000000003`}, {1622.484, 
      2213.304}, {1621.6639999999998`, 2213.8350000000005`}, {1620.84, 
      2214.366}, {1619.98, 2214.632}, {1619.086, 2214.632}, {1617.711, 
      2214.632}, {1616.477, 2214.0930000000003`}, {1615.3829999999998`, 
      2213.023}, {1614.297, 2211.96}, {1613.6639999999998`, 2210.468}, {
      1613.477, 2208.554}}, CompressedData["
1:eJxllG1Ik1EUx0dUSIPsw8igN8RtOrIPgRIxzJNzzUexlwkRKRG+0JtQUVCY
ldWWLyssSuKSVrdhUolGkzCbzRco0CxyxSwLE4sICYmIivrQee49DzfahzF+
u/eee/7/899NLt3nrZhlMpm8+NG/w4cuLprdzOBn0VTrYg+Hz/ZVCe03GVyd
aXscKORwfuB72tu7DGxzTzYNbuLQ4ZmsutSj+AgeqIso1s8NDzI4kDUvloKc
0L5kW/kTyVMbONQufP3sx5DkINZPQoyOMHhnxQIFHIa5+/635wz0Yw/zOAwh
H3zBYPeFL9WR9RxKF2xdkzHK4Cn+HnIpPr4HlWQrFnrSFTtKGgcyHRzS77XM
tCHvwnrZqaQnKu9z2jlMVlk6PC8ZrK5ft6PCRve/YmCOBff3WuV+S0zqdVll
/a4xBn9ufR0dSeGw3D+9uXuc+kEWPryPZ+FTMgfhfyiejf26fx+6/jv/QLFz
YuO5pLDs9yOymEMvzc8q/T4cIf020t/HwNu9zL8C9erjKOqXvBf90H27Qjyd
SvX6pT9HHYoNfw0W/a9VPH8lXpRDecL7xFzdUp/vEYMa7D+KeYsWooNhmqdG
fnZTPvJpPiHFZfr6HcX6+bEg9ZdH/jWTvlzFRr8G+/qG+BzU04j5LkHegg0v
pTxYWmT9MvQnN1D56TdykytQudMm9bmuMUhEfZ1Wms91yo+V9N0gP1Io361q
XoJvx7Mxf6HvWDwb+wWfUCzm51Ms8lpL+o281kv9xdj/m1+4s4HyYSd/A3Rf
mmLDr3/XzVmKT6N//hy6n/aPu0kP1Td7aL2B/m84n8ztPdpZ7Ke43DmRqJFf
dTQ/jfJK/U9rlO8z9J7k03viUyzOn1Is/r819N5oyj8xT8pXRjX5U0Drl9X7
ZeTD4L/G32yA
      "], CompressedData["
1:eJxllGtIVFEQxxexNVzpYT4yTVddFzUzZFusLBlZc9FdXVGCKKmwAtPAHvbA
HiYlEQYp1Yd7xeIQFoFKRUaEPbCIUDDIQMSizA9RJpva4tpWNvecuRyiDyK/
vTNnZv7zPyexsrZsb5DBYNiCf9r/du+tlwNJKqQYG68+L2Wgc2fctj05eQwc
zfs/n0iQvGj1vXZvnAr+8vGO2AIGN9temO/EqFD2ML6pppDB6Nzp6t5Iwatc
DDDrw+ulqshz0/lhKpyp7q0bKmbwxZq1sNMo2b7jUWFYkGQt3vVHgbSKS312
ZF4noEAX9hNwifiLfgX2tU6efFrERF+zChzcFDq8u/BfHndK/lQf0R1SIOpn
YL7WX20+1fupiDgHA1f2hbxdv+h8nH/qTXFli0Hlc3mAQUufL/Ud9n9NmyuX
+oskvXIYuDH/I+qp9e/LFvXb0lToeXX0yXWbZB6fKfm9xdgYmc6gn21+cNiq
gmn4xoHHVurXrMIA/m6ziHoTqL/v99vjtxOJw1Uxv5niTZK7nWP1VxZIrlyy
df3aedLHTPr7ifG86JHB2SGfAuejRgazk+j7D9I3ifY3Lfk+zpUwJZn34xX7
8yVSvpf0Rea6TfzPPD9LxuvMz/uuCD0yyJ/YD9cvjfw3J84bRb3y8XsA/VOF
+2uw0L6CVWhAf5UnM8CuUitMkrlPF0v+qs23TOX7n08mv0UJ/29Pof2g/uk4
X4+V+ltB+amS+b7SJYdi/6cyyG/6/cmkefF87u81pH+48FczzV+D9+fss37W
ZKP7FCTyJ+y0b5yf+3MdzTst9ndsA7Gu50bibwqM4X1w5pIeqP/dQ1WtXSAZ
Va277JDM53PSPJNiv0eKqP8Zup9u8pef9PfQfcB96O8Njw+R7w/3U6hkrLo8
GPeh+WpnKd3fCKF/m0d8PxdN75GH/BMjeLRE6q2ztoeZWMkWrQ6+Z5o+syU0
30ral4f8g8z3jNyhvXfxFO+R76Pe718GG4Zy
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQvadksgRLyiwHVbbGqYcDFjpc9k0SuFGI4AftkGt9
XTPLodCW67qy30KwuHMrhP/YY6EDxxqZqJSeWQ5Tnbtz0l0WOpxe6Lrtcz9E
v7M9gn8KSBdbIvhhfLqbYk0XOrh05zz/3TvLAWSMteFCh3XuD6tEumY5zHu/
/Bi37kIH3U1z36u3zXL4Efx46W2NhQ4qIHc1zHI4AzRnsyrE/ieVsxzqsoA+
UV7oAPZPMdQ+RYh/IrIh7k1WgKpPQvBfqhly6IQi+GB3e81y2HKibJ880Dyw
v50g9s8G2j8X6C5va6h7daHmmc8Ch1O2ESpf2wLBvwt0eKgN1P+WEP3VDlD/
2kHNB4bf7Z91WTZA+zInvq3ZDwzfZIEIyy3usxyAtt0/770Q4i8/SPic9oWq
B7q/+cCphUf9IfGVHYOIP/T4BQA4wt43
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQfXqh67bPCbMcVNkapzb7LnQ4orChKCMWwZ9w6KvG
nchZDtzXFxf89VnoIHbz3PfgsFkOYH3eCx0eVomsOx40y2Gac3fOc6+FDkeB
+l/4z3Koz9pTIuy50CFZIMJyi+8sh1NA9cVuCx1Ayqq9Zzk0AOUvOy904Fgj
E5XiBZV3QPBB+oNtEPwzQPnNpgsdKl+qGXIAzVsLFP6tD3UP0P6gHXKt2toL
HX4EP146O3wWmI5WW+iwzv1h1ZQ4qHuVFzokAd1jko7g626a+355LoLfDjKw
aJZD8wGgi1QXOhTacl1XLoeY/1p9oQNQ9THv6lkOd1WAAaQFdV/tLAeLTscE
VX0EH+wOUwRfK6b/0FZbaPhUQvSLuiyE2Au0D6Rst8dCh9s/67Js8qD2eUP5
GYj4QI8vAL9g0ao=
      "], CompressedData["
1:eJxlk21Ik1EUx0dQRG9KUV+KSqbT1fwQIRIqnFy6Pc6xcB+KEhFfICyKSuqD
UISFSIVGRHrN1c3cioQkZvgyxvIt01BSynTWAomoCJEQi/rQufceuZEfHh5+
zznPOf/zP/cmlJwqKF9hMpmy8RFv+9UTn6s6GSStunSr7yCHf7k6l8NP72zr
1giDzJjn+iE3hw2pT5vnXuj8A5j/e0zz6aw1ky0Tmr9Y9qxue8tghOc824uc
VtRtrJticLEiVLnJw2EYv5+NMqjZMjW66Kb8GQZx2OdJvua2bUfKMlyapQ6D
g28uMDgSVfomnVR/WvX74eAgynrfMfjzaH58PbLQZUc9Yq4mnK++dyFlZkLz
/Li7pP61ZllnlEH7mWM3Uh1U/5XS73UqPbaXSv95g+Loj9C1No/DV6F3QLOc
t1+z8Mvcx2BXYV1vB/4f/XWhIvSc4siJwscw+YH9/U39O9t7mKqTo/cl9WRr
lnGbZqH/u5X22cXgcmSYr0zhUIfzF3Yrf3ssqn8m1v+Ajd8kcbh9cmN1JMTg
PfJm5ILO7Ve+hVV+VSKH4NC58A7U24HvmJlDM+p24Xw4ReVNs8o/PrSc5d4S
aN7G5byUL/X5NMs8Tvs3k98PGHix7mPUUxp/eF+wlYEV/UxDvfnptfs/+hkc
LcuIxVlU/rUAnadkigeofzLVe8gAPxeXWzXLfdg0S7+y/ovbOWDV2FiAznsu
6V9iB90fvzov6U7av1/pXXDSfcJ5pE8Gnc8WpeeTQf7dZ+q/PLoP9zSLfdz1
aRZ6PHcUzxraX8GlyNOCG1S/3S7aX1Df37+BFf+9
      "], CompressedData["
1:eJxllF1IlEEUhiXEpCK6qLDUZdf90dVtzVZx868jq267/uymRVFSoAVWF5pZ
SlQmJQUFIdbVYDFIRJBioSFhP2REKHRTIBERZTch4UWIQUSdb+Zdhuhi+Xj2
mzlz3vc98zla2huPrEhKStrDP+uZej9j/+G4IHdK383puKQEW4/SSkmj4c9n
1tcb7vnmKbgSFfSzaf5Oeo0kfjsaDgtqnLT1H49I2vj+zXJTSHNeraSX9rHO
th2C1m55OLRYh/olgi4cm+p6Wy/VuaFCwyfKV80N5xu21n/NE+Rtvv6iiHmq
azAt2StohMv8qtXrnR5BRwe+n30WldSybt/2cZdQ/7dG/uX5sOEv3PfKGn3+
tFv3116F87KhLyTpsiXIi/qs35KR7RfEbnyKkaQZWf3oJPd/a/Huq9kK9BeC
X6V6f3dc979UrM8v3Cto4vXpp7cDhtV6v+GPrpS+DbmSig4+jqzZLWj13HDH
Ew/65Txm+dyAS593if1f+v2u554DTNBvl+Sy1gcNc3ypvoDhIatvH/yxw383
mOupXJ1C6SjOwnsH9mchP7thW//CrkmbYdVPJvRzvQ5rfwb8dWAeNv3Pan+B
WZ9gVc8GP3yYzyz458X8Ib8PHv3+Butr4/x6Xchrm6Benq8mp1Q+/ggaVvNd
bljpq9T5/3Fi3qp0/QNu5MP+57K+CQ/624n9OYZVXrmGWVXHOR/mrQb3xw9/
Q5jvfPhPer6uQn8y35+Lz2dkfwB+bdX7F4qQtwfzGYReu86vuwScCT/LwJuF
vscV8CNN0IPOtoERMnye9QyGDCt9YehJ1/meiiIvO/rn+67uhRv+x3AffOZ7
o9YXGlZ+Bw0vs8+iTNA435dDzK3W/a3U/guup+amGvMTgx9h5N9g/E6wlde1
iGGeypzmqPZnuQH6osgrhvmpFdqnGL53dVgfM9/HRL9/AVtsVPs=
      "], CompressedData["
1:eJxlk19I01EUx3/0EJG5aZO9FOHEJKgeCiLIojP8M9f6I/omZTInOjdJKXpY
4RxTtDRMLF8OJpcVFSwJof/ZX8hUSLAHKQMxH8QihCIsRPDce49ccA/j7rPz
73v+zOU/V1azwbIsoI98y57uaAtVIjQd2Tw1d0xAQWd4/lIEobn+5YXeUgH9
i3c/+JpTWfkXCZnGsuIIfTLQK2D6P3m2I3Q4v3x6cpzzdSFEKb78pLYf7kEY
F0WP/5xi7kPYuTF2830p+6PhRqqTuG1YvgVJhHbKv0T5ut/93XV6SOup9gm4
TvztGULaVKJxpVjAv/K5OziMMBvJGvS4Das8hwyr+P2at1H8o48XX83sZn6I
kNxeEXiRx3ruIdT1/LoczWE9AxyfLaCQ9C/3Gv49ecKf0W24IpA/M3EVIUjx
r7O5f5rXGM3jvEvAktTTyvMhljoGYgi2vUP9izlm/mpvuYZv0dvpXGd3CFjI
27cpSUyq7jdlCv17FHXfGdq+pwVhxHfwyls7zz+m9+Ww83zjvH8b99vGduKv
ct8dCC3En9N5/9dS+QHNbzlN1/95JpXX/JW+KsMHKp97twQQ5JfRdNZbi7A1
/mbMRfVl3+NB3c+0jf1Del/5dr7PMOez8zzCeh8J6p/adlc18PwzWW+Dvo+4
w7CKdxpW+t2GVR+FQuch/k73NlLM/YV5fh7uj+tXlwgY9MxGboT4XkvYXs92
+j/JOzsa5HzEP6T+Wq6/xjWGZb6sgGF1f36+Ny/f+1nUd0K8CuG36U0=
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBWIQPff98mPedbMdTi903fbZaaEDjB+0Q671tSGCv0Ym
KsVab6HDOveHVVOAfCDv/nnthQ4v1Qw5dOpnOwQD1a/WgsiLNEDU79ZY6NB/
6KtGTNNsh0dVIuvY1Rc6uHTnPP/dOtuhLmtPyWTVhQ4/gh8vnd052yGMT3eT
rArUvL7ZDoW2XNeTlRc6vALy10xG8MVunvsePAvBv/0TaNL82Q4bizImrgXq
nwC0787i2Q6qbI1TndUh8jYrZztMc+7OWQ50H9hfq2c7bACqz9VH8MHuMUXw
gb5Y124DNW/FbAfzTseEp44LHW6B7FsE9a/rQgegsc+r5812yJj4tsbeY6ED
0Btz82fOdpgHDLduT6j/JiP4HKCAmYDgg93XO9vBAmi+KlS9dNdsMB3tAfVf
+2yHTKD5+90XgvWdbobGlysifmDxBwDK7+cV
      "], CompressedData["
1:eJxllHtIVEEUxhczXwsVYSVpPtJVl5SIkgiNjvhWzFKEMDVXDcSC7EEPDUtE
KiwkKvpjrsEgEUFJiIWURVhaKC7puphEiVmZbGJlZqJR586c6yD+sSw/Zjjn
O9/55oYUH8k+6GYymQrwp/8Xr9q3Y9sXBn9yRm+zMg4GWzxqbiSkcGhOGam8
PsFg/u6P/swMDi+DHxwrm2Kw/VJ80edMDiV4v3WGwa3JO13mLA5nxsO3eM0z
WBnd0rh5DwdHJlY0aaLeC+SKnT6DTe6K9fO33oobsU7GCk3WQ24/cc3PfbUm
9e3mEFTn2tu2RpP1sf+FtUP2U34a9PCkR1PpXOper8FR7DOK+mMKH6dd9qf6
STRfgAYPX598Nhyv+F5AXmlsnGK9n3+UYmt+Q0eMlUNUCyo07keQPxs0yG4L
rNsUzuHdbHV5XKAGrVj/gIVDQ8d0ZH6QBubBpoqnYVzqDJZ6EpBPo18XN2rC
395QDt14ftyiQXU5Th5K/lqXsu5PTwgHLxTyaZ4tYeO+8O+fYtF3maon5vPQ
5D6R1w3ZZxyesn496kuoPzxW5U3zW2h+HzUv2j+TY5Z8KILmMcv708j6HpqQ
a5938zqrYsNfgw3/DRb9cD/iHp1XJUq/fX0oH8nE3pQP3LfQ4Sn7dabKeqHL
aZ408sdNg/dhHjW5mBc9rlEmWf9JOvn1ly2wyM2sYrHP30zmNJ38+slk3zTy
Y5IBTjPckEr6XQzOo9+OZPW+9BxsTVS8KG/I97HfXCT5ifyx0rfZM4LOx+h9
ov+d+B6/Etda6HycyXyHkT8uWX8/ciLuc+4bgw84vxP3jafNKd9VPkQ+fy1l
I18if6+WsnFfz397j2LdF5edLeRL6O5jC/mKHc66crNf6Y3W8+VgUHZ14uw5
C72HAfLXeF9OmsfIl1Pe32VVvChfyPp/Sa5i0TdP5qHUSfMUUD4GyP9COh+g
71mR3CdzSL+X2ej9o36h0+A+2W/URvt4Q3qKaR67YrGfXsUiT920H5vyV+TN
Rvnqou9tCfUbUd/v/57vtgI=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/SP48VJpxzkOa2SiUqztFjp8uuSbJADka8b0Hyo1
X+jQf+irRozLHAeLTscEVaOFDi7dOc9/e81xmPt++TFvvYUOhbZc1xcHznHg
0900N19rocOpha7biiPnOKiyNU5t1ljoELRDrjU7CcH3NgcalIHgfwTaNyF3
jsNdFbbGUE2o+YVzHNYC3fMbaB4HyGFlcxy2nijbN19noQPYvVVQ+/Sh/No5
EHuMFzq8VDPk0GmA8oHuBbnzdB1E/33dhQ7T84SaD1RB/LsbaJ9p3C5PnhKo
faoLHcRunvseDHRPxsS3NfZKC8H2vE+ZA/ZnssJChwnA8LgTheCD3PfEH8EH
BilDg9sch+YDpxa2KkHcs8ZujsM8kDvUFjr4AP3/wGyOQ3SK9X1+bah/jeY4
/Fn58dJZAwQfFD7MFmjy9lC+GcS+x65Qvh1EvbMXlO8GkV/st9BhT8lkCRZg
/DRk7Sm5HAANr1gEHxy/6Qj+DFD45EP0K/tDws+7DGL+YW+o+2ug/vVAhDc4
fJ0RfFh6AgDECxQC
      "], {{1808.277, 2208.554}, {1818.84, 2208.554}, {
      1818.754, 2210.023}, {1818.5819999999999`, 2211.054}, {
      1818.3239999999998`, 2211.6479999999997`}, {1817.9060000000002`, 
      2212.5730000000003`}, {1817.285, 2213.304}, {1816.4650000000001`, 
      2213.8350000000005`}, {1815.6409999999998`, 2214.366}, {1814.781, 
      2214.632}, {1813.887, 2214.632}, {1812.512, 2214.632}, {1811.277, 
      2214.0930000000003`}, {1810.1839999999997`, 2213.023}, {1809.098, 
      2211.96}, {1808.4650000000001`, 2210.468}, {1808.277, 
      2208.554}}, CompressedData["
1:eJxlk21Ik1EUx0eQRFFGL/ahyGS6uZofIsRgSSdFtycblvtQlEiYglgkmWRl
VGKiYWNO2wq6BZeIYU5d5VTMZCxM2aAPRtgLNUqiFxGxkBX0oXNfxq388PDw
4557zv+c/7lp5TUllUt0Ol0efuz/4fy6XquPQEZSo+fpfgp/c1MhhbEtgdov
vQR2xYqdB+0U3vy6WD0y8G/8+KjiVVkPb9eEFbekvH5eP0YgSgsGdiC/sJev
fjVO4FL1SN3aYgpV7tkLuyOEx8XtMj5KIBnz9O1T7N90uMJSpJjVmdMoWFDX
jYjQN2WT+SdEvR9WCv0TZ0ZTsd7vrvnJlcjfJzEA9fx0TN+7hf2ZMY0vrNgV
XsgsDSm+eXJNU+gJgUBtlTvLKvMPC/0Om9ATHxT66zV5HiRwZ873bMVeqbdf
Me/3kWLexwMCW0td4SDeP/vVsL01IM+R51Fve4+cB9bPbzvxueE+gQj2d7pA
+cX15Cnm52bFTP+sSfqJfCUUoUszKbDyxi4x38cGCuew/jLM/z49qfFlBoXs
smHtWjeBd8jrkVObZw4M9Yj4hnQKJUObm2f6CARxzjG98GMD9odbUtepF/E7
Bxcz6y+aJvttXcyJeK7PqZj73S7918t5dxBwoI5u1IMrrbt8nYAJ55mNer9h
O34PgSMVlliyQcQf8sp9MlJg7fq9sr5R5kPOubrnaKVJMffDrJjPK/e/83wK
cbY3XrnvhVJ/gtG/t+z9eMS+5Nik/1LvAvJH9p46CZ/rcU3uZ4fQ80mT83MT
OJW7fEqf2C+XYn7PqZjt8cY2wdOami/jYwluEfW2FUn/7qr3+wfPGPu3
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/VLNkEPnxRyHH8GPl87OWOhweqHrts+vEHyxm+e+
B7+d4xDGp7tJFsif+375Me/3cxwKbbmuK6cvdMiY+LbG/uMch2nO3TnqaQsd
bv+sy7L5NMehHaQxBcGvy9pTMjkZwd9QlDFRNwmhf61MVMrvBIT5YH48wv5M
oLr/cQj3qbI1Tm0G8mHuh/G9zTsdE54i+C7dOc9/P0LoB/MfIMwHukqC5T7C
ftO4XZ489xDug/Fh7ofxYf6D6Yf5H2Y+LHyAwTb3/SNE+IH98xQRvujhDwCt
KsrD
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dyd87z6wxwHVbbGqYcDFjrA+D+CHy+V1kHwMya+
rbHXXOjgY97p+ADIt7nv3xuuvtDhlZohx5qPcxwKbbmuJ6stdAAaydDwaY7D
qYWu24pVFzrc/lmXtefzHAfu64sL9qosdOg/9FUj5ivEPmcgf0/JZAmW73Mc
/qz8eOmsMkQ/w685DkBdJZOB/Lnvlx/z/ofJnwekTysudHABuu/3RUw+TD2f
7qa5+dcQ/KAdcq3ZN6HqofzXt+Y4rJGJSrEGugfs7jtzHIKB4qtVoP67O8dh
y4myffFA/5jG7fLsuQcJn2g1qPr7UL461Dwgv/kAUEYTwYeFJ4x/Bqhvsy2C
Dwq/xU4LHbYC7ZkP5N9TYWu86gqxjwfIB/vbfaHDOveHVVNg9nssdJgADM87
QPdZA+ND3BPKvwMJ32YY//Ychw1FwBj0hMbnLYh9yl4LHW6B4ucGgs8BDIgn
1xD8ApC7rkD4jz0R4QuObyD/O9Adsy/MAftD23shxJ9vEOkJAAVdMco=
      
      "], CompressedData["
1:eJxVk2tIk2EUx0dEyYoVURnVSlebW2uNaeZG053dnHOb2SYVFSHTyFLKLvSh
G8bwgyxQCSOQUzxIRSAhYhIlIRYRSX3QD9KN7kREhIRYFNTZ+xx46MPLy49z
3nP5/89bmD6S3D9Hp9OV05N74/cbj2I7EY6W66fWlQjIf/5sdrIOYYfBMWh0
CBg5cXHF3FqE/tW7G09bBXSNzVhfVUneahZwvfdhwYAf4WD3tzN/CwVcPrwk
M+qR9RoKBJTuuxtd6FL8xeLK67covv345P2rRgSq9qbTJCB5Z03712Uo3xYB
TVTXZ0DIjD4RYbuMN+sR3B3+erNL8RXaI+tWnJvvno/7Gbh+WPLGfJm/oFpA
w+JdnqG1sn57jYBxER7+YUMwzzvf86CW5ylVHC/r8L+tUKzNV4lw7hAptY33
jaNWpyTBem5HaKP4JPV78YsySd+fqQ/X9lQpzs0zHv6fsyEBebTIxxTPFxTw
kuLeJO8XEDBLdXrJH9vezrEZv4Dl1C9Vw/P4WY+YYrJc1xZRnJv3QojnDTAH
EEjt4eNB/p78vRTMthSFWE9A0E/1tZ6lebX7Ac6PsH4+hB7KPxAVMJTzl/Qi
2eo/VXO+l/2Ncb6HOc77b5HcnOD9ihWHsi2ff9sVt9Id9dE9LXIMojPO+SbW
J8p6Gfl+K3m/lQgDx5q6HQHFmj9exdp9lglI031spu9fryfDizlu4v6b+B6K
UN7BBqH5usop43Yr93cr1varUDw9kUh3kf7vTi29FbHJ/JGovK+MXfrfmEB4
T/H5DtaL/P5zc3riqZP9qeP56f/9B6LPuzo=
      "], CompressedData["
1:eJxFlGtIlFEQhpcCCYMKuv0obM3LampodJFkaWzZ8rKbphRlV0xLXcm8pK1W
qyymlqUmmSJHOS263tKtrKSkotRCoyAJCysriS4SUhHWr5rvO7OcH8vycL4z
8847M8c7OSshdZZGo9mNP+X/Q+Gi7q31DP4kTrbsCeAwqHXlfLnAIL3m+8n7
vhysX/3D5lQwSOzzKu1cySH4Opt2nhHfL0P++cKcvMDOQI3jzSEN722yifNx
LYcVpVPbw4skmzZURL7Pk/wNw3dlMXDl4E28HzERd/6yhYEtoz9vIeZHiZri
Iww8xxzH9P4cypa8flaQyuCtr0fJ4kDJSrzGYMnv8PzlauLDDPw8Si49CiVO
Y5Ct9xw7tIb0WQQ71nKYF4IFZlH966nefAZdy5NS7oZzGEB/0k4Rb+Qwo+Qt
Z1BnOJep03Nw+6nkmw2Si7Ge0UjJOzHRvi0cRtG+V3UiXlG00DdTyyAB/Q6K
FX4srWFw80n+vQkT+VdJ+c3i/q4yyUq7gu2Sqx/+Dnhjo3hmqb9p2jk010Tn
hQww7MFPMeS/lYn/aMmKPz5RHD6i/sdWUZ/BKLkcdd82iH5prGIeyjaT3wUM
nnLjrRtYv6Jj6riINwlUTy7VD1RPtmT1/KhkVW+m8Puz218L9Rfjj/89ndGf
Tv2k/DPY76SUiInnBsnY1aFYo+RwrN8vivJhPPuDYT4YI+ajL1v6p/pRIOJV
xXHVxxEb5Y8n/WclK/csFyWr+9JA8xtP+puoX9s4tDYOaEOvMJiPc9hjpu9b
aB9MtJ+t5B/2R93DNgbD6G8u6vdS9LYJ/aVGyep3kZJVf8IkqzpCqP42MZ9s
Fe1HO32P+7Zu/53oynbhvzOA5rND7Ms/Hc1zB70XyMrcNneKencgn8ABLe8i
P918VfIPrLe6W7LS5qIe0qcjv1zCT7tO+OW6xmAE6/+FHKsMci/dD6R+9BEH
SXa/d+o8Yrxe1HnAh4s5oXontfT+OSSr894sWe0XI/+9SV8jA5zCvFp8H6tw
Xvc20H74ENeLeWvxk++BW89/cUaWLg==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/bBKZJ37jLkOP4IfL52tvdABxl8rE5Xy2wbK75vr
kDnxbc1/q4UO894vP3a6fa6D9X3/3umWCx0u+yYJ3GiZ66DK1jj1sMVCiHj9
XIc/Kz9e8jWHylfPdWg+cGrhUVOofOVch6Adcq3aJhD5iPK5DndVgAYYLXSQ
b30daFE218EGqO66AYJ/eqHrts96CD7I/F6dhQ5bT5Ttmw/UH5Vifb9fa6FD
u9jNc+VVUPdrQM2vhdiXrb7QYQtIfcNch0JbruuL1aDyLQg+WF0ngv/pElDB
hLkOc4H+9tZAhA8svAD3T5si
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQrcLWOPXwvbkOP4IfL52dsdABmS+tg+BnTHxbY6+5
0OGlmiGHzn2IfLT6Qoc9JZMlWB7MdQjaIdearbbQ4bJvksCNBxD19aoLIeY8
musw7/3yY6dVFjqI3zz3/fLjuQ5zgXxvIH+d+8OqKU/nOkSlWN8/r7wQLH76
xVyHuiygycoQ81veYvLB5ilC3XcAkw9T3y4GtPAIgg+2/zhUPZAPkg4+Oddh
jQzQBUD3TDj0VePOqbkOwUD/rAbyTeN2efKcmeuw5UTZvnigfziACp+cgfof
6F9VkH1nEeGRJBBhaXJurkPzgVMLXTURfFh4wvgg+7tDEXx+3U1z10dB3Qs0
z+a+f+/1WKh/gXyQPczxUPcA+acXum4zToCEl/cZqHwixD3Op+c6AG3fVgzj
A/1TaMt1/XEi1PwTUPckQfyTchzBB6lbfBTBB8fr4bkO94ABezUREb5gexMh
8SeyH+If7mSofbcQ6QkAR8cuSw==
      "], CompressedData["
1:eJxllFtIlFEQx6XCJB/qQSooKtF13byUuUuERiNe1nXbNM0utupeNN01yuxm
rnlJlhILiYoexAMHkQhKQiykLMIyQsmHJEyipCwqJCJCLOyh+c6Zj4Psw7L8
mGEu//mfL9pzvLBySVhYWCn+tH/PqoM7zDkM/hTN9HZVc9DZEN56I9PKoc/6
seG6g8G/279eO+wcnm+6V1ddxGB7e4bri4ODF/MHDjBgP2+9iMzncO57XEqE
k8HKpP7uLQUcJhxY0SXrPUOu3blisqdCsRZ/61PcjXXsx6ge8tCpa2uX1dF8
ezhsDM7uHTxN9bH/xdVT42frGYzx7Ae/87icu4HBCewzg/Nbyh7aLgeofjbt
18jg/sszT6YzFN9ZX1KRlq5Y67cuUbHJ2TlsMXFI7McJ9Xwj6XOeQeHghmBC
HId3f5v86U0MBrB+uYFD5/BcvLOZQeRkT+3jWC7nbCF9ketRr0sXpL6vYjiM
YvxkkEGTHzePIX3bQ1nTZyyaQwQO8tkZynq+0K9csejrVSz2O0L3RF4zNT4/
USXrdeB8mR1HvwZ8tL+B9verfVH++aIayTVG2qdG5s8ha3foQW57OsqDJsW6
vjrr+uss+uF9RB7FA1lS7yg/+SOH2Ef+wHuLOapkv5FcWS+mkvaxkT4eBu9j
w1uL0S+aXRNdsv6jPNKrVLHwzSHF4p77mfRpHulVSPvbSI98BrjNdGcuzW9n
0IJ6T+So96X5IDVL8SK/Id/FfgvxpCfyp4aovuVGilvJP6j/CL7Hb8RtBorb
yN+xpI9d1j+MnIX3XNjN4APu/wbvjdE+a4Hyg/DnvlDW/SX8ZwxlPV/z/1CC
Yk2X2WTlLzF3ivJX2nT+lZvb1LxJmr9SGVRf/dHYbKD3YCZ99fdloX10f1lk
/i6T4kX+ssjvgbdYsehbIv1QYaF9SskfZtK/jOJm+t645D27UqXeS930/nF+
MafOKfT9cdM9ttI8HtonWbG4T5Ji4afNdB+30lf4zU3+iiP/e6lfhvp+/wck
B6TR
      "], CompressedData["
1:eJxFlHlI1EEUx5cKEYuSbjBK81hNjQwry4Rn26aruylKUUYHZlAWndIfGZWI
VFSkeZbuxOQVpSZ5hS1qpRIqGpr3lZhIhUhFWPRHvd/MW2Zhmd+Hud73+94b
t/hzMSfm6XS6g/jXRsOdM9PJLQx+x04WH/LmYnSxMTiVMXO10YPD8J9riTtr
GcS+Wpv2fD2H9Le/vEeq5HoXZE+HlGxDJYOJK8srwtw4tHFj7aUyOT/syiEG
951+qrgiDFc+UWzedjv0UwGDyosnM2Zwv3W2tLU9j8H1RFvSMrw/3vnA9uos
Bk79hedDvDh88QpwLHvAYNTDIWWFj2LtvHw/xWM437uRw1eNM5mI890m4mwG
F0Kc+o9vpvjyJBcGcjG6W0n/VtJbyKBsTVzC6yAOc9o9z4h3cIhLCB7vqmGQ
g0bqQzjY/dTumw+Kb6CenlDF+xf7vzy8h8OWI/WmRc3yvGSTjN/vDRNx+UZK
PyIbGNS8v9wwbib/6ul+i9x/t1pxJPp5rFLxj25LvHM5nWdR8TM8d6GZ5jE/
2rapCPK/hEHweNS9XJNi4Us4h90Y/98Sqc9gVHxr5WBnnUHmK7BE1sPNXZSP
IgYdWBdVqL8adawrlOdNAunhpB9ID1Ms5gsUi3gfSb+n7f7mUX7xfLTVOptD
+aT7/ZBFngyKha9GxUGo3zOc7nvIILWpjbdEyPr4xpR/wo8ied79KA467VdO
90dT/HWKtbw9blQsfGul+o2m+NspX3s5OGofXQyWoI4XFlrfTf1gpv78SP6Z
ZP1F9TLZd+EUb6+MP82oWOwLVSz8CVAs+tef9PfJ+rRuoP7oo/XYb7lnl6Y2
9Un/S72pPvtlv/zTUz0P0HuBvGqwc65nQOrdp5fviW2Q/EQe0nhIsfBpWHFx
frNr5QjFpye/RqWfqXrp1+cxBu2o/6dexp81Qft9KB9TxL6K7e+dqEfcr41H
3TnYkjJXL+gnf13p/fugWNR7h2KRrzby343ie88AVSVl4vv4Hes1vZX6w524
RdZbsad6D+zx/AeliaMP
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7dyd87z66DyHH8GPl87WXugA46+ViUr5bQPl757n
kDnxbc1/q4UODCCwdZ6D9X3/3umWCx1M43Z58mya56DK1jj1sMVCh7nvlx87
vWaew5+VHy/5mkPlV85zaD5wauFRU6j8snkOQTvkWrVNIPI9S+Y53FUBGmC0
ECyevXiegw3Q/OsGCP7pha7bPush+CDze3UWOojfPPf9MlB/VIr1/X6thQ6v
1Aw51iyHul8Dav4qiH3Z6lD1a+c5FNpyXV+sBpXfiOBvOVG2b/42BB/kL+e9
88Du9tZAhA8svADnpJ1B
      "], CompressedData["
1:eJxlk3tI01EUx0eRlTJn+Rj08DX3dP4RIQZLOim6LRuW+6MoiTAFsUgyycqo
xKSiwiSiIPpd7h8h0UiJDCkJMXqg0B9G2IMaJaE1xtpsrqA/OvcxbuUfP358
uOee8z3fc25BQ2td0yKdTleBH/t/Op51172UgDml6+qTbRT+5u5qCk/zB9tm
0wlsDNZe2uGj8O7XyZaRnH/jn+cqTi+5d7O1UPHZnLcvO8wEJmjVg/XIr3wN
GW+sBE61jLRn1lJo7guf2OQgPC7hk/HFBAyYZ2Cr4sCaXY2uGsWsTsRLwYW6
rjmEvimPzG8T9ebcFO6/OPI4D+v9vh2d1CPHJjEA9fz0T9+6gf05MU1/oeLe
sbitPl/x9YMru0fXEhhsa+4rccv8q4R+v0foSRiF/g6vPM8moEX6n6VtkXqz
FPN+MxXzPlYQcNT3jg3h/aNfLevOZchz5CjqvayXfmD9ygsHZjpTCYxjf4er
1Ly4ngrF/NypmOkP2+U8kc+MjtMlNgqsvHW58PeRhcIxrL8M838sSul6baZQ
uueh92IagQ/I2ch5PaHtw3oR31lEoW44tydkIDCEPgdNYh5G7A+3pP2KScRv
MC5k1t9Egex3VlvAyXiuL6yYz/u7JnwzSb9jGvhRxx3UgyutO/1DAzv6WYp6
v2E7gbgGuxtdQYNFxO+c18Q+WSmwdgPzsr5V5kMuO795b5NdMZ+HUzH3q/y/
80oKCbY3yHzfq6X+JOP83rP3g3rYXpR55Pyl3jjyZ/ae5jTu636v3M+Y0PPF
K/2LanCoPHXKlNyviGJ+L6yY7fHqkOBpr/KX8b4kz4h6xTVyfovV+/0DI1js
JA==
      "], CompressedData["
1:eJxlVWlIlFEUlXYqqh9t0I4zjkMGFbY5Rq/UGWdRQ2nBbDMjK8m06EdFZWPR
Zla2kdjra5P2aJFK26Mio6CIaLUNoiSEIir60/3eO4/LND+G4XDfd9+55557
36D84uy5rWJiYrbSz/7/nfPxSJ+QFPtbau928lni5Z9VCxqypbhwf9m1mQFL
LB7b8fmhyVK8X979tC9kiW23fsa/niKFs13ZrtuEcws8TY9zpfhA8faZlmhY
WtW7zQwdb51liZTNRZ9XzJbioZVWd55wlyHnaloKpNhFgXkTLVFJ+fIKkY/w
K/v+hYzt88UljNX5ZVKcLS3c/s3kX67jKXT/L6qnepUUk+0PQzhfJoU7r/LW
iADqW8v12vVXb5Si/MYDq23QEh1O9s0tqJSixK47Q8f77NT4Yybq3atxLPFR
52qYn7r/IGPFr5axfW/jCf5+xIwr/i1nOH8NxYPn+X5VV53UPIPId0nzb0yH
npd1/JXXEl/ihnU4eUWKt452Zc9SGNtl1Y9jrOpKYExqrhzntsRpH3W6Xmoe
LktkX+q/rrlef++J0/GdDfr8aif0uCrFRfJLkwN6Xtf5pzmg503wibVEzxeP
fuXckYK6sLQqVudfeD8aq/oGoX/V0dict/2SXMNY6Woxzu82dUziYd3/nyb/
UehB/BrJlz+oP2HqfxrV8/1JRn63Y9o//eLgx2PwF+mRSvr/JbyG8j91wR/H
pfapm7HR12Cjf8T5FPCjfNNIx65e8KtFv8mfvUivp4fxvd8SR6rvDDx7AHoE
wGcfY5V3D2Nb/09VUiQ3ZVVMCUC/bVJQtXVL/OjfFuiVrue3fIPm1+KF38I6
3+ZU6B3GfKdyXPlvfCS26zf4FPH/G4/7wtgXLsTLoS/pfZTqG7pO4zD1g1ZU
zJr17C+lzwb2V3DUxvGzNrG/vtp+ruD+Kx/viMbGT7b/EwqicYR/5jNW81IE
PrGY30W6PyuIj9J1sRRviE8PJ+a9BPU7cb5UqjoGU/0h4v+uFP116XjnJdi/
bsZGT4ONnww2flJ9K8F5L/xbjPM+6F+EfvmxDws1n+YA+jGHsfLPTMbKP3m4
L4D3YCrqh5+ycrBP0zFPWajHC/+H2E8GR8yLwW70n/BuIuZyoX8Z7Bc774BM
Pa/TneBH93UlfmccmI+J2F8O7Ods9Bv7oHlS5P5pzo3Gxh/qf0g0NufVPhnG
WPU3ke9T/R/JfJS/RjNfpf8YvI+mniT9HszBPkr2oF4X/O7B/nIzNnoarPQe
+x+egPwePY/30uCHJOjrw/uThP2RDv7Ej7pc0csPPBrzavAovM9+zPNIvHfG
X4mMVT+GM1bzPBTvoZ/1VfX70f8EzE8QcR+/r8Y/Bv8DOFwwXg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2Iw3fo60OLvfAdVtsaphwMWOkjp31VpY10A50enWN/n
517gUGjLdV3Zb6GDS3fOc2t+CP+xx0KHee+XHzsttMBhqnN3TrrLQgexm+e+
TxaB6He2R/BPLXTdVmyJ4Ifx6W6KNV3ocNk3SWCG8AKHNTJRKdaGC8HmLhZc
ADaXW3ehg8fDKpF1QPt+BD9eelsDYv9vngUOZ4DmbVaF2N/NucChLmtPyWTl
hQ4TDn3VkGGD2qe40EEa6B83Joh7kxUWOljf9+8V/zMfzvc273RMeIfgtwMd
WP54vsOWE2X75JUh7ou4PR9s/2yg/cAgY2i4Mh/iXl2oeRfnOwTtkGvNNkLl
a1sg+HdV2BpDbRY66G6a+179MkR/tcNCB5D33K9DzQeGHzBY5uYD7cuc+LZm
PzB8jypsKHrxYL4D0Lb7570h+pc/nw8Jd1+oeqD7mw+cWnjUf6HDVqC7539F
xCd6/AIANb7k/g==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQrbtp7nv1X/MdVNkapzb7LnT4Hvx46exvCP6nS75J
Ap/nO3BfX1zw12ehQ8VLNcOO9/MdTi903fbZe6GDS3fO89+v5ztMcwYyvBY6
/ADql34536E+a0+JsOdCh6MKG4pePJvvcAqovthtocPS2UcUNjyZ79AAlL/s
vNDB+r5/7/THUHkHBB+kP9gGwT8DlN9sutDh9s+6LBugeWtlolJ+60PdA7Q/
aIdcq7b2QoeoFOv75z/MB7sjWm2hw6MqkXXHv0Pdq7zQIUkgwtKEYQGc7/Gw
SiSPGcEvnSzBIsa2wKH5ANBFqgsdgMZz6HAsAJv/Wn2hAzDIGBy4FjjcVQEG
kNZCh7nvlx/z5l7gYNHpmKCqj+CD7J9tiuBrxfQf2mq70OHPyo+Xejkh+kVd
FjqI3zz3XRho3xqgf3Z7LHToELt5bjsz1D5vKB/oXlh8oMcXAIW82FA=
      
      "], CompressedData["
1:eJxllG1IU1EYx0dYRJJGhNiczrW7zelWVo5N19xxL+5FFjHBDxoRpvQmZaDR
i0VRlrEPImIfiuKehkkgBfYKvUmFxNYb+UFDLGKsCCmLCIsKeu49z+UY+zDG
795znvP8/8//Hl3z3mjrApVKFYWf9P/nyrfXz0tE8rM+NVgQoGT5idGEbrVI
Ls4OjcUilHx4tWqqcr1IDIuODzzeRElnf35WnoNzY4vzXW8V56yGHOvIBpHs
cy2Z0ANT/63vR6oZpzZScvCTcW2QMI5D/dLNvY9u1ohkWoACdZQUrJkWxjwi
GdY0ttwNUqIGPuUVyc6+z10Payl5OVefSgM/g8LXvZyP7rrX0e/mLOuxcDbD
OTYzJTee7n+g9YlkB9Rzm5iesz52ntNIyeXzT4q/AtvP1GxtNeD5fpFkT8Tb
7wuUdMD6hlqm1yuw+oaASGQf9ZRYRy7MDgWxH+AvXW7b23AmS/4mdVTeF6nI
ZGX9JfDPZeMMXdu22DmPR5qXTTpYv2ng4PtDK65W4vygvwPgd08V6jegfqdI
oneKustAr/S8E3k3+LFu8bDmHPKMCes5mT+HzZwVfxWW+6/mnCMZ4cE8ASel
IPiZvqXQzzHofxzydjrvzYs5B84zhH7aMR9hnE8FZ+n9YDnnHth/24L9BVl9
Kc+yPh9npV+FT44m6ELQk4Z8/wKWYltowvmaWf1t4M9kvN2VAB7wxtq2G5i+
PaUiyQV91wScTxnmR0B9FvRDj/m28nnJcyjPZGX+sr6Vmaysl1n9//4fGs5y
XotQv5JXLdPfBP3H2j7+NhdjPozoL3KyhLPi1/z32S7OMFba7cH84PopP+pR
1gewPy1+bzAfKVZ9wE1wb+SG0C8tzi+EecX+Z0KY70K8T8LM778azvL+eSx/
v2q8b0LcP3meyOl89KcO3xv5/aXkQ+F/cjBnRA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQfX1xga1X1AKHH8GPl87OWOjg8bBKZF00gv+uxt70
XswChzA+3U2yQL4hxxqZW7ELHAptua4rpy90EL957vvluAUO05y7c9TTFjrs
kGt9HRi/wKFdDCiRguDXZe0pmZyM4G8oypiom4TQv1YmKuV3AsJ8MD8eYX/m
xLc1/+MQ7lNla5zaDOTD3A/jg9z1OALBZwE5PByhH8wPQ5ivFdN/aGsowv5n
F5RuW4Yi3Afjw9wP48P8B9MP8z/MfFj4vFID+igcEX5g/0Qgwhc9/AGUsrtE

      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQzRLGp1sUt8BBla1x6uGAhQ4w/o/gx0uldRD8jIlv
a+w1FzoU2nJdXwzk29z37w1XX+hwfXGBLVf8ArB4stpChySBCMsSIP/UQtdt
xaoLHXbKtb4WTFjgwA1UuFdloYNw84FTDxMg9jkD+Vox/Ye2Ji5w+LPy46Wz
yhD9JskLHOqy9pRMBvINOdbIRKVi8ue9X37stCLEfUb+mHyY+ldqhhw5gQh+
T87z3y+DoOqh/JXBCxyApqZYA93j8bBKJC9kgUPwDrnW1SpQ/4UucNhyomxf
PNA/Ty8o3a4MhYRPtBpE/TsYHxge3UDzNMMWOAC9udBVE8GHhSeMfwYYPptt
EXxwuDotdAC6UoIFyL+nwtZ41XWhwzOgfTuB5s8FutfbfaEDUNvnWph9Hgsd
hIAWKQL51sD4EPeEhO/CEEj4NntC5YH8DUXAGPSExmcwxD5lr4UOQG++nhiE
4J//DjQ4EMGX0r+r0hYA4T/2RIQvOL6B/LhdnjxNfgscgoAGaXtD+E4xiPQE
AJPuDss=
      "], CompressedData["
1:eJxVk21IU2EUx5fQCyvSXog+WDhrOlvTzGBGDY+by2YuzSAkJWIVWia1NJfz
Jeecbt3qboR96e15CItAIoTslRCLkEYv5AeLiCiRqAgpEPoQ1Ln3OfDgh3sf
fpxzz/M/53+uyXes6lCKwWBw4KOd415f2rsEA7/DOLGmgEN8dMZyOc5gz2Lb
0CobB19a9eZN5xkMpu892GbhcHes5cm1M4K3mDlMXD/uMPYxOJz42f7PxOHB
6siPJWFR70AGh+iK96/udUo+9S0rP9oqed9Dz6KUkwyw2ic1k4Nt6Mp0tp9B
1X0slMVBO3Y1MgiPvOBuq4jXNTAojBXvN+dLvjp987lSKFnT96iI7muk+m4O
QeQxv8hfWMbF2SLqR3ZywPCC9W0MzPNC/U8rSU9I8jI9UbKuL8ag88jj5gsV
HPqwX/tZBknuHi7winmmqwy6MD6O9+k6cL5/dk8O1GyXrOlIumezUsKFL3HS
5xLxCpX6c3JACw1d6E9OrTo6U8wB35bac6QHORf1f1Ukz0Vjf8cka3oDUdLr
JEY/cdrDTS76vpfBRZdyNLuE5olsROM7UK+2P9W9lF9K80Pux/w6j/C3G+dl
R7+myii/h/zdQflh4nLqPyS4wUv9nZZ849KzjA3tkrGLlT24T6loVF455Qdo
Ph5R73Uz7e826q+JwZ0T9QmbU7Luz1bJ+n7axX4k8fuPa9HwjRQP0P25HJai
MaYgg3rc/6J1HObg/SMdIm61kF/ds1mNSJ56k/mhFef/Obj8dmkOhxqMpypi
v8JW4f8k7tMXjM/H//E7zmsQ/f5769fbl3m073HSj//vfwx1u6Y=
      "], CompressedData["
1:eJxllFtIlEEUxxcREyt7yCRUxOuW5gUVMTLtiKl5XXPJB42iUrCCtNIui6YW
FhEhIvXQuuuMunnB3c31UkZWVIQo3SMJKSvpISQtRCxK6uw352OMHpblx8yc
Oef//88XuL+8oNRFo9Hswp/zvy1taH5pkEGoW/2Vh/kcVO71KypJTOFQ2bze
tXBAcnFJ4tSafgY/9NMW33QO142PAir6GBTc8m84nMkhbHfjgyq74E3ZHPAK
TZ2VgWekwzSXQ/V7GNQdulP5KpfDjo8Gr9lOybPV2+LNFsntuH+knSl145F/
d39/mdvGwIr9/MoW+98zBgebvlbfy+LwbFE/HYp8NMlj4kDmvzydIfmTwcu2
Il3cb2Oiv/LtdB+n+VI5GL5oY0bbqD7On5NwMeVDBwNUY0oHHHyj34W4dTEw
z3U+Hk+m/uykVyKH03jefUj0v5Ag7i8dZjA4euJua5xkZX+UZKxavy6cw7B/
w8yLmwxWTrRXjGipX/RjnKcNxYWI+y6j/gtLr091BwpebaP5A8T+qB7Ja8/d
H9vXKdm10DMytoP0CSD9Vb2w3p7bmavOtjK44P32aUIQrZvpfBD5Z5LstHnD
Mlb6a6H5A8V5/xbSFxnHmK+59j8r52PkfpWV+UykRwSHKsznGzPpF0b5I/8m
tWLdG+crQ/9qQ8gvnL8W86UPFpzeI9npa2OvZOd8R2zC/z/BlDe7qF8cygFj
PrMT9Q/Hewe11J+Dzm+UrPgVLtkD+6+JEO8hSX0/UaSvnfIdLfR3sYl8XaL5
n2C/aCNviKP3ZBHnZ+LJb0753EzzmoV/J7dw8EE+r+q5ldaNDJyxykgmPVD/
vmNlTVaQfAbnaU6VrMyXQf4ahb9VWeSXmfrPEflyMNJfR++hQ35vlP1dkpU8
dUuOde/180E/BvC97M0X78NiE/obsV4MrhfdoPzoKD995H+e1Ftlp0xNy/jz
86DJnw6hz2IezddPfulEfq4ijyEf14nv3bd+2q+T30e1378jVJFE
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQPe/98mOnby5wANOeCx0mHPqqIXN9gUN91p6S4IiF
DntKJkuwXFvg8CP48dLouIUOyQIRll+uLnDg1900Vz9+ocMrNUOON0B+y4FT
C1kTEHyQ+ttIfD6g+vdJCx28zTsdE4Dmacb0HypNWegwF2ivN9C+oB1yrdmp
Cx1cunOeW99Y4ABSlpq2EKIO6L5CW67rj9Mg8r9vIfgg83PuIPgg98+5i9AP
8lf3PYT5QC8zNNxH2A827z5EXjsZwQfrS0Tw18hEpewG+h/kjeVA/saijIlr
o6Hhcx9ifzIwvJKA4WNyBxGeADnhsMA=
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQLXbz3PfJxxc4zHu//Nhpz4UO4kD+5SMQfnfEQofL
vkkCEkD+XRW2xqkxCx1cunOe7z4M4YfGI/hg/QkIftAOudbXSQsdXqoZcugA
9WvG9B8qTVkIVsd9FCKfnbrQ4RVQ/g2Qb97pmJCattBhwqGvGjJA9xTacl1/
DOXPOYHgR6dY3+c/heBL699VcTuN0A+y3/oMwnyQvaZnFzjw6W6amw+0P1kg
wnILkL/lRNk++WQEf41MVEp1IoLPD1SvD/TP3pLJEi4wfuxCsL3JZ6DqI6Dq
TyLCDwCsVaH8
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1,
       4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
      0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 
      1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGBQAmIQvadkskTLwekO894vP3Z64QIHGL/Qluv64sULHNa5
P6yacgzBf1glss79DIJ/2TdJIOLCdIc/Kz9e6l2ywEGFrXHq4UsQ+eRlCxzk
W18HWlyZ7tAudvNc+fIFDqcXum77DORvKMqY+HYlgq8K0rcWwQfrv4ngW9/3
751+F+I+FiB/jUxUivWDBWB1ykD75gLd7/1wgYNp3C7PnvPTHTInvq3Z/2iB
Q7JAhOWW0xD11Y8R/oHxYf5F59dn7SkJfgrl/0DwX6oZcqzhmYEizyIzA+wf
3SdQ9WozwO56DHUPj+EMiPvvL3CoABrQYTnDofnAqYVHb0P9Zz/DIWiHXGv2
tQUO/Ye+asS4zXC4CwxI0YtQ93pC5F+fQuMfRvBB5rXuWuAwAaj/jvMMh2Cg
/OpNCxxOAc0vtpjh8CP48dLoNQvA9GztGQ7A0Lvvv3QB2F3iEjPg8c8BDIgn
fxHpAQC9zxcM
      "], CompressedData["
1:eJxTTMoPSmViYGAQBmIQvc79YZXIi+kOwTvkWlcvW+Dg3J3zvPrDdIfMiW9r
9i9d4GAat8uz5/t0h7nvlx/zBvJV2RqnOv9F8F+qGXKs4ZkB559a6LqtWHKG
A/f1xQV/ly9wAJk/RXmGQ6Et1/XktQscbv+sy9qjO8Phz8qPl85uWuAgfvPc
98tGMxwsOh0TVHch+EFA92QfRvDB7jmD0P8j+PFS6SsI89fIRKVU30TYD5K/
fW+BwxGFDUUZQPfNA7qv+yFU/s90OB/s328IfrJAhOWW99MdolOs7/M/hJgP
Ch+wfQ8WOAAAFZGkrA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvadkskRL9gyHUwtdtxWvXuBQYMt1fXEegq/K1jjV
uXCGwzTn7pznqxY4cKyRiUopnuHQkLWn5PLKBQ5g/aUzwOoOr1jgsM79YdWU
shkOmjH9h0qXI/hBO+RaXy9F8M07HRNSlyxwABlbDdRvfd+/V3zxAgexm+e+
BxdDzGNetMBBd9Pc9+pA+/lAjAULHEzjdnn2AN1XCHRn8gKo/dkIfjvQgPIM
BH/Coa8ad1IR+pMFIiy3JCPMr3ipZtiRiLAf7O8EhPtgfJj7YXxQMFQvR+if
9375sdMrEOb/CH689PZKhP1g/asQ7oOFL3r4AwC1JsEw
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQ/VLNkGON2EwHVbbGqc5HFjgwgIAClH8Yylef6RC8
Q6519cEFDq9A6rVnOqyRiUqp3r/AYcuJsn3yRjMdgoDy2XsWOPQf+qoRYzrT
YWNRxsS1OxB8sHlbEPxpzt05zzcscLj9sy7LxnimA7/uprnr1y5wcAEK/9ab
6fAj+PHS2asWONwCyu/Rmukw7/3yY93LFzhwAC1+ojLT4c/Kj5d8ly5wABlT
LTvTodCW6/rjxQscPl3yTRIA+ofr+uKC2kULHKbnCTUf4ILoP71wgYNp3C7P
nt8z4HwwvRuTDzJvMdC8CUD33jmA4O8pmSzRcgzBX+f+sGrKqRkOD6tE1rUv
gZjPc3aGQ33WnpLgZVD5czMg7lkO9f/5GQ7tYjfPfV+J4IPC5/BaBB9kfvJN
BB/k3967Cxy8zTsdE4DmgcJL/8ECSLifmeEwF+hu74cLHMSBxl4+OcMhc+Lb
mv2PoOF5dAYkvh4j/APjw/yLzge7/+kCB1D60PmG4IP8I8I4E86PSrG+f55z
psMGYHy/fQJ1rwAkPpSfQOT9pWY6nF7ouu3zI4h7XyvOdLinwtZ49QHUfHVo
/NyF+kdnJsT9t6DhqT/TAWh6jf11BB/s38sIPtjc81D/6kDTwxmofzUg9huf
WuCgAgpnYPoBx9fxBQ5JAhGWW+Qg6an3KMQ9yPkBAHsrkU4=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7dyd87z60QyH0wtdt30+tsCBT3fT3PdPZjh0iN08
tx3Iv/2zLmvP8xkO894vP9YN5E849FXjzqsZDkE75Fqzgfw9JZMlWN7NcIhK
sb7vD+QDjWRo+DjDQZWtcaozkD8XqM/7K4IPtucfgg8y34ZtpsOjKpF1x4H8
H8GPl0pzz3RoyNpTcvk41HyBmQ7hQIfdPbEArO+w8EwHzZj+Q6WnFjj0A90T
IzYTrG/2Gaj7JWY6NB84tfDoOaj5UjMdCm25ritfRPDPAN2x+TKCPw0YEMuv
Q9zPID7ToQWon/X2AgfTuF2ePUD7Qf4/fXeBw5YTZfvkuWY63FUBOuTBAodb
oPBhmOmwViYq5fdDqHu+zIDzweH3FsEHux8YnmEghwL5sPAHue8x0DwAAzDM
qg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7dyd87z60QyH4B1yrauXLXAotOW6rvxqhkPzgVML
jy5d4DAjT6j5wMcZDvVZe0qCgfy575cf8/6JxmedCefz6W6am88302FjUcbE
tUDzbv2sy9ojMhNsbvLKBQ6fLvkmCUjPdLC+798rvmaBw22gvI3cTIi+9Qh+
ENA92ZsR/HlAe7i3Qew7LTPTISrF+n7/jgVgda8lZzqslYlK+b1rgcM694dV
IuJQ/Xuh7hGa6XBXha0xdP8CBxegf39zz3RYA1S/+8ACh49A90wAun/LibJ9
8ocWOPwIfrx09t8ZDg1A/1yG8qW/IPhg/e8R/FMLXbcVv5nh8KhKZN1xIN80
bpdnz8sZDmeA4puBfJC585/NAPt/MZCvytY41fkJJHxbgXxY+IPsiQbyAcQh
z7c=
      "], CompressedData["
1:eJxTTMoPSmViYGBwAmIQ/bBKZJ170kwHVbbGqYcvLHBA5jcfW+BwVGFD0YvM
mQ429/17w88ucLj9sy5rTyFC/SOg+uOVCD6f7qa5+bUIfrvYzXPlDTMdTi90
3WYM5F/2TRK40TTToT5rT4nw+QUOGRPf1ti3zgSr+34Wqr5tpgM/0Jz1ZxD8
NTJRKdanEXyQPe9PLnCwBrpreivEfddPQM1vhtj3+fgChy0nyvbJA+37s/Lj
JV4g/9MloAKge34EP146G+g/kDHLaxH8/kNfNWKqEfzpeULNBypmOmwoypio
exxqfinE/cEnIO75XgRxf/lJqHzBTId575cf4z4FdW8+gg/2bx6CD/ZHzkwH
rZj+Q1uB+iteqhl2ZEPlgfyPQPdOyICGB9B+5+6c59WpMx1OAf1XfBQRX2D3
HELwwfJrEHyQ+9+uhMYnkN9y4NRC1hUQ/6unQMJ397IFDpVA+zmA5t9TYWu8
unSBg2ncLs+etJkOd4F8USBfrvV14I4MiPrqJQscgnYARbJmOmwFhvP9xZD4
EAf6D5hKSiYD+fJA9RZFmHyQ/04vhPrXGZMPUw92nweCD45vb2j8L4aGt+9M
h2CgO1YD3QNM0gwN/jMdNIHhaQp0L8g7awJmOkSnWN/nXwZRHxEITU/LFzi8
AskHQu1fDjUPyDfvdExIXYngg+NjDYIPDq+9aPKHF0DSTSA0vUPTlzqMD4y/
W6D8EwBJL+YnoPEPde/XE5D4Ou43Exyu2Seh6dMX4p6nJ6Hh5zPTodCW67oy
LH15IfhgfR4IPsg90m4Q/uOTiPAF8ZNhfCeIfdqnofEXh8i/ADs9CfU=
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/VLNkENn8UyHH8GPl85+scDh9ELXbZ+XIvhiN899
D14x0yGMT3eTLJA/9/3yY96rZjoU2nJdV36+wCFj4tsa+zUzHaY5d+eoP1vg
cPtnXZbN2pkO7SCNTxD8uqw9JZMfI/gbijIm6j5C6F8rE5Xy+wHCfDD/PsL+
TKC6//cQ7lNla5zaDOTD3A/je5t3OiYsQPBdunOe/56L0A/mz0aYD3SVBMss
hP2mcbs8eWYi3Afjw9wP48P8B9MP8z/MfFj4AINt7vu5iPAD+2cBInzRwx8A
jOfQIg==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dyd87x69UwHVbbGqYcvLHCA8X8EP14qvQbBz5j4
tsZ+5QIHH/NOxwdAvs19/97w5QscXqoZcqxZM9Oh0JbrevKyBQ5AIxka1s50
OLXQdVvx0gUOt37WZe1ZN9OB+/rigr1LFjj0H/qqEbMBYp8zkL+nZLIEy6aZ
Dn9Wfrx0djFEP8PWmQ5AXSWTgfy575cf896JyZ8HpE8vXODgAnTf7x5MPkw9
n+6mufkTEfygHXKt2VOg6qH811NnOqyRiUqxBroH7O7pMx2CgeKrl0D9N2Om
w5YTZfvigf4xjdvl2TMTEj7Ry6DqZ0H5y6HmAfnNB4AyKxF8WHjC+GeA+jbv
RfBB4bf40AKwPfOB/HsqbI1Xj0Ls4wHywf4+vsBhnfvDqikw+08scJgADM87
QPdZA+ND/CSUPx0Svs0w/rSZDhuKgDF4EhqfUyH2KZ9a4HAbFD+TEXwOYEA8
mYjgg93VD+E/PokIX3B8A/kgd8zungn2h/ZpCF96OSI9AQA0mjnz
      "], CompressedData["
1:eJxTTMoPSmViYGCQA2IQ/SP48VJpkVkO894vP3Z6/QIHl+6c57+FoPyFCxyc
gfzqQzMx+HVZe0omL17gYBq3y5Pn/0yHoB1yra9PL3B4qWbIofMQwZ+eJ9R8
4BaCD1Lfc22mg1ZM/6GtMP6VmQ5zgeZ7w/iXZjpsPVG27/6pBRB9F2Y6WN/3
7xUH8l8BzV9zfqbD6YWu2z6fWODgY97p+ODsTIeHVSLr3I8vcBC/ee775TMz
HdrFbp4zPwo1D8hXZWucevjQAofvQP/OPoHgg917EuK+7PNQ80VnYfDB/j0L
Ne/GTIdCW67ryksXQMLlJ4IP9i/DLDgfHF6ssxw2FGVMzF0KDV/2WWD7mZdB
5blmgf03HcbnmeUQxqe7ae5yqHreWQ71QPuFVy5w+HTJN0mAH2r+qgWQcADy
twDDK34NxD9rBBDxCQA6QfCf
      "], CompressedData["
1:eJxlkm1Ik1EUx0eRhEFFr0SxHDWdqdgLlWXCKY2SZeUiizEs1KismJqZWZpi
UmFhEhZcqe5a26PWRCxDQkrMhm2uID+sF6LCDxYSYiEVfuk8zz0PN/PDGD/u
vef5n985phyn7dAUg8GwBX/qf/KnXVdvOhnYOo01x15z0NkcUdXw/KHkyLC7
oLyVw0BGzuy3dJ56X/D+Agbn87uK57bQOfKN1NrjQ00cOvpKnt4pZPBxeUTV
fGRjzXBmZxGD33sGPY0Kh9sjij94kkHS5c0Hzcg/3mCBUyLPsJdD6bfoVZdK
JP9S35VKnpnQfmukjEHQtfXxGoXul1N+5BdRbUVfKwRPxfvqdSWXQWFKZDiX
C445MJn1fux5aGAfg0rkAQ/1m0l53RyWYj9JGUzrY8Zd4WthOoMTQ+PNo1jv
/Z+K/K60/+qD5DOYd3qyZM33OgZzqrsDJhf5XE2+9PqJ5PMeB1Xz2XgGviX2
vHEP1YtjgF36reh7FH1ei2ViDvp8LOTPN5Hj2iWr/dT6Ja9w1PV09HGwrsfG
LeQ7wOHignevTseQ3yCHtdlP0q9EM9iEOcPIapx4M+1PP/lbJt7/RMYVNFSa
GDRgI4dDHLyNvVErjQyy1MEi9+L8jixigBaLr//D+r5qvGEyqz4H2yay+wGH
HZj/80bK10z9pYj81ehL9RbE+eCr+gTcn7qeMYsjjc71fdwuWatvlfxI9byT
QSz6GvPSftjE/D4o9L29DI7Wfz/3rIn2wc6Exxa5f5pPn2TtvV+yqsf5knxl
M5iFnIi+v5TNa93mEPcX91M+rH+hO+CaFqJ9yaK8Iepnt/Srs+7zL8Og820=

      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQPff98mPeU2c5rJGJSrHet8AhY+LbGnsgXzOm/1Dp
9gUOpnG7PHtmzHKw6HRMUN20wOGlmiGHzvxZDmB96xY4iN889/3y0lkOfLqb
5uavWuBQaMt1ffHaWQ6qbI1Tm1cscPge/Hjp7G0I/sdLvkkT9iD4M/KEmg8c
nOVwV4WtMXQl1PxjsxzWAt3zG2jeOveHVVNOzXLYeqJs3/w1CyD2noPatx7K
vzjLIWiHXGv25gUO/Ye+asRcgfKB7nXpznn++xJE//21C8D63p+D+Hc30L7b
P+uybE5A7Vu6wGFPyWSJFqB7wOGwaIHDFqA++Z2zwP5KXgAJD571CD7IfSJL
EPyls48obJg1y6H5wKmFrUD9E4DuuTNplsM8oDtPL1vg8Anof4HuWQ7RKdb3
+VdD/ds+y+HPyo+Xzm5A8EHhw7wDTX4/lN8Nse/xUSh/MkS98ykofzZEfvG5
BQ5JAhGWJsD4acjaU3L5AjS8NiL44PjdjeCDw+cwRL/y+QUOzsDwqz4FMf/w
aaj7L0L9ewIR3uDwPYzgw9ITAEu6MEw=
      "], {{1701.3239999999998`, 2144.554}, {
      1711.887, 2144.554}, {1711.801, 2146.023}, {1711.629, 2147.054}, {
      1711.3709999999999`, 2147.6479999999997`}, {1710.953, 
      2148.5730000000003`}, {1710.3319999999999`, 2149.304}, {1709.512, 
      2149.8350000000005`}, {1708.6879999999999`, 2150.366}, {1707.828, 
      2150.632}, {1706.934, 2150.632}, {1705.559, 2150.632}, {
      1704.3239999999998`, 2150.0930000000003`}, {1703.23, 2149.023}, {
      1702.145, 2147.96}, {1701.512, 2146.468}, {1701.3239999999998`, 
      2144.554}}, CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/VLNkEOHYbbDj+DHS2e/WOCAzJdeg+BnTHxbY79y
gcM694dVU6Dy0csXOATtkGvNZpwNoZctgKhjgqivX7rAYU/JZIkW5tkO894v
P3Z6yQKH2z/rsmxYZzvMBfK9gXyX7pznv9lmO0SlWN8/v3iBQ5JAhKUJ12yH
uiygzsUQ81/zYfLB5i2Euu/RLAw+TL23eadjwjMEH2z/S6h6IP8WkL/n1SyH
NTJAFwDdo8rWONX5zSyHYKA9q4H8UwtdtxW/neWw5UTZvnigf8DufjcL4v9l
UPvez4KHBzgcgfzmA0CdKxF8WHjC+CD7u68i+Py6m+auvwV1L5Bvc9+/9/pd
qH+B9oHcxXwf6h4g/zSQNn6wwCEZGF5b3kLlH0LcswbofrA6IP8ViP96lkOh
Ldf1xw+h5r+CuucRxD+nXyD4pnG7PHmeI/jiN899v/xklsM9FbbGqw8R4QsO
ByDfGRh/1Q8g/uF+DLXv9yx4egIAEls95A==
      "], CompressedData["
1:eJxFlGtIlEEUhpcCCYMKukGarXjJ0szCaMHMI1IWpqV2MW3VdA21ojLpZpQi
olGhEdWPwZp1W1fTbDOzxazWy9qurheSsLuFRIWEVIT1q873zVnmx7I8zDdn
3vOed8Y/50hK3gyNRrMXf8r/pzMLWuITGfxJnTBnNHBwaK1FX+MYFFz5fvbZ
bQ6nvwWvmbWRQarNr6KpjsOq1topS5T43gf554vEnHk6BmodI4d83BcTKdbf
cg7LKiaTdRGSt62/EPtxhWSlfHMgA2sR7sT9UePbL9/QMjhf2Fk8H89HiZpS
XwbeY6aj0fUcKhe9Hjq5hMH7QK+yhY2SlXqsWfIHXH/ZQuzDIMir7FqPlXgp
g2PR3mO5raRPK9jUxmGO0mAg9d9O/YYyaPZNNzy2cehFf/LXEndwcW40g+tx
Fw8tf8LB46dy3ky75FLsZ7RL8m48SN/HYRTte5Ug6pW4hL7pLQxS0O/QAeHH
4s0MHjpPPB13k3+xdP6g2J+2QbLiZ5hOck3375B3kVRvUOq/OWXpm+2m9dUM
sGz2537yP5yJf5dkxZ8Ap9D/PFz0F+eQXIW6H/WIeWnCRR4qu8nvMAZu46b2
B9i/omNypag3Yad+Qqh/O/UTLFldD5Cs6vUXfn/x+Kul+WL9N3/PFXb60Tzp
/Gmcd7ohany4RzJOtS/BIVmH/Qc56TysV27vNzrQD1SbbAuW/ql+hIl61cNc
rTMQSeePkP4Yycq+g/GS1fuSRPkdIf2pNK8hDvWsVxuxh8FcDN69Qfo+ne6D
m+5nBvnnEvnz0TPoR3+PO0WebXqhv8IhWf2uS7Lqz33Jqo671L9e5LP2Dt2P
TPoe79u6zI6tlzKF/5YGymeWuC//LJTnLHovkNswt7eyRb+7kE9hQKv2k58e
zpH8A/utyZWsjLnEQPos5Fee8LMc2Yx+WQ8wGMD+fyEnKEEuoP2NNI/DxE2S
Pe+dmkesp+jMMnGRE+p3gtP7lyZZzftOyeq8Ush/I+nbwQBTWHwV38dqzOu+
JLofJuJEkTezWb4HHj3/AZ+wp44=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/bBKZJ2772yHH8GPl85evcABxl8rE5Xyew+U7zzb
IXPi25r/uxY4zH2//Nhpm9kO1vf9e6fvXOBw2TdJ4IblbAdVtsaph3csgIib
zHb4s/LjJd/tUHmD2Q7NB04tPLoVKq832yFoh1yr9haIfITObIe7KkADNi1w
kG99HWihPdvBBqju+gYE//RC122f1yH4IPN71yxw2HKibN98oP6oFOv7/asW
OLSL3TxXrg91/wqo+UYQ+7KXL3DYClJvOtuh0Jbr+uJlUHlLBB+szg7B/3QJ
qMB1Ntjf3isQ4QMLLwAj0J8J
      "], CompressedData["
1:eJxTTMoPSmViYGDQAWIQfXqh67bPFbMdGrL2lFyesMABxldla5zKPHmBw6Mq
kXXH62c7FNpyXVeessBhnfvDKpFWCP/x1AUO4jfPfb/cAVHvPGOBw/fgx0tn
90DkF89a4LCnZLJES99sh2nO3TnqcxH8ee+XHzs9H8HPef57ZeGCBQ5JAhGW
JkD+0wtKt38ugNg3pRdiXvLCBQ4/gOZLA/lngO7cDOTrbJr7fjnQPpD47YVQ
/Uj8U0B1xd0I/mXfJIEbnbMdgL5Y1w7kc6yRiUpph8oD7ZNvfR1o0QZxXzeQ
3y4G9GAL1H4gH+yvZgQfrL8BwQeHV+1sh60nyvbdXwANn2po+ALtO6qwoehF
5WyHPys/Xjq7CBHe4PBdguCD1S9F8MH+WA71X9VsB5v7/r3XV0D4W2qg8bUK
Kg+Mrw1FGRN1Vy9wuP2zLsumCSJ/eDXUPa0IPlh9F4JvDTRXvA/qvlXQ+JkI
jW+gfUE75FpfT5kNCZdlCxwKQOExbbYDn+6muflLEHxgrBzzXojgCzcfOPUQ
GP/gdDIFGn+w9NEPtX/6AgcVEN0F9f8UqPubIfLNk9DCB5heAYGyZPk=
      
      "], CompressedData["
1:eJxlk2tIFFEUx4cg0ZbUwDIwo5fRh4KCIsuiIxZ+sAhcilAQWRXMCimlICOR
kBAJlPLTvco1ddV2zOiFpFSUiCQVGFHrus0+ephpaVm7un7o3MdyiQaG4Tdz
7v/+z/+eWe8ozy1ZYhjGXrz5c2z+ctnABAFzTV5xVZBBlKvLBirtnxiE7MEO
soH+x9F6D69P/Zf3rdbsSDyxZ2cSBXvf2lpXgMHk5h2x5goKLT86h2x+Brez
/ReTEin0YH3EYtCM73MSKNw5V9p4xqv57P5l74rcmsPoI79P85WnL1oP3WPw
FfW3xlNIr8ssTOtlkIv7frMpfReDIvRzP47Ch00xNW+7GBzeXZfpW0ohwzp6
Ldkp608ZFNJiapqetzEw+BUhEL/tbnN5K5PPOSK+ZzGV15TmrPrTX6o+a54d
PeJo8BOAXQWP4nD9Qfwe8RLAVZXXbzKI5UGNETiOwqntKt/3BB4Mn39sdWjm
/Xo6NZc2Tl+q7lZ+3PL8+m8xUZfiISLfeuxX+MD9vNhvk8kg2f0q9MaSeik9
Mr+RgGaR10fNecUZ1mvs5yTu98RU/U1IfRuykwyu2z4p6/Nxv1Wob5/S/oTe
dzVfmC+e0sOKGQIJ6Lu3XeX9U+qNtCk/c5r5fNz4o5nrHgjLfo7hevF+nkgd
zCsHz7MQz4vPQ61TzcMigato7EKXZpGLS3N0vqK82D07+nJczXdE8nKcz4Zn
v7eML8j6jT7V/4LUD/mU/7Dqzy/1TPQv5jSg8v8l/a8Mqnxn9P/HcyTTmv8C
0aTkyw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvadkskSL7RyHUwtdtxWvXuBQYMt1fbEDgq/K1jjV
2XmOwzTn7pznqxY4cKyRiUpxnePQkLWn5PLKBQ5g/e5zwOoOr1jgsM79YdUU
jzkOmjH9h0qXI/hBO+RaXy9F8M07HRNSlyxwABlbDdRvfd+/V3zxAgexm+e+
B7tCzGNetMBBd9Pc9+pA+/lAjAULHEzjdnn2AN1XCHRn8gKo/bYIfjvQgHIr
BH/Coa8ad8wR+pMFIiy3mCLMr3ipZthhjLAf7G8jhPtgfJj7YXxQMFQvR+if
9375sdMrEOb/CH689PZKhP1g/asQ7oOFL3r4AwBz970W
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQLdf6OnDHqjkO894vP3Z64QKHdrGb58rL5jj8CH68
dPYtBF+VrXFq81oE3+a+f2/4ygUO/Ye+asSUz3HInPi2Zv+yBQ66m+a+V6+c
47BGJipl99IFEHOq5zjcVWFrDF2ywAFoJUND/RyHQluu64sXL3C47JskcKMF
wbcGmju9E5MPcx+YH4XJh6k/orChKCMewQfZL52K4IPdlznHIQPo3nqgeype
qhl2ZEPcaw10v0t3zvPfOXMc5gLN916+wEEeFD65cxw6gP7evhLBh4UHjA82
/yaCH8YHtOnOAgfTuF2ePEB+84FTC4/eg8pnQ8JX+sECsD2ns+Y4RKdY3+d/
CPGPONB94UD9d6H86WlQ+x5B5VPmOExz7s5RfwzlJ0DcX/0YER7o/PqsPSXB
T6Hh3YDG3whVvwFq3iNU+QiOuRh8mPmg8FzOjOBPAKaHO38R9j+qEll3/Cc0
PB5B4+c7JLweA/0PEn7/dY5DA9D8y/ch4WMB5E8F+i/9LoKPHL4gPnL4g/iw
9LjlRNk++W+I9AhKr9+/I9Jj0A651uxfiPQIjPX7/v9Q0wfIP8jpE+RfdD5y
fvl+bg4GH6YeHN+XEXxw+r+J4H+85Js04S4iPR4Fhs+L+4j0CM5fDxHpERY/
sPQI48PCA8ZHzr/f1yLcBwAMLvmi
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLdf6OnCH2lyHUwtdtxWvXuBw2TdJ4IYmgt8udvNc
uc5ch2nO3TnPVy1wsL7v3ztdb65DQ9aekssrFziA9RvMdVBla5x6eMUCh0dV
IuuOG8510IzpP1S6HMEP2gFUuRTBN+90TEhdssBh6ewjChuA+kHmii9e4FDx
Us2wQw9iHvOiBQ79h75qxADt59PdNPf9ggUOM/KEmg8A3Vdoy3U9eQHUfjUE
/5WaIccaZQT/0yWghxQR+o8qbCh6IYcw/9bPuqw9Mgj7QcqWSyPcB+PD3A/j
r5GJSqlejtA/7/3yY6dXIMz/Efx46e2VCPvB+lch3AcLX/TwBwDoJsCR
      
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQ/SP48VLp43Md5r1ffuz0wgUOEw591bgzaa4DSHz2
LQRfla1xavNaBN/mvn9v+MoFDjPyhJoPTJ7rkDnxbc3+ZQscTON2efZMneuw
RiYqZffSBQ4MIDBjrsNdFbbG0CULHDiAEk9mz3UotOW6vnjxAofbP+uybBYi
+C7dOc9/L8Xkw9wH5pdh8mHqweLVCD7I+oZGBB/svta5DhlA99YD3RO0Q671
dTvEvdZA93ubdzomdM51mAs0x3v5AnA4SHfNdegQu3lu+0oEHxYeMD7Y/JsI
fhif7qa5dxY4gKh8oHnNB04tPHoPKt8BCV/pBwscls0+omAAtD86xfo+/8MF
Ds5A/1QD3RcO1Hj3IdR/TVD7HkHlG+Y6TAMy1B9D+TUQ91c/RoQHOr8+a09J
8FNoeM9F45+Dqt8ANe8fQv4WUH6PyjwMPsx8UHjyKCD4oHC1l0LwX6oZcuiI
zYOExyNo/AjPA4fXY6D/gcH6PVhonkMD0PzL9yHhM1twnsNUoEPS7yL4yOEL
4iOHP4gPS497SiZLtADNg6XHfmB6jRGZB0+PwFi+fx7oHlh6TBKIsNwiNQ8l
fYD8A+PD/IvOh6U/sPmv52LwYerB8fwBwQen/68I/umFrts+/0SkR3C6+4NI
j+D89ReRHmHxA0uPMD4sPGB8WP4Fu+cUwn0AvlsEOw==
      "], CompressedData["
1:eJxFlH1MzVEYxxvWGkYjZmNeRthoK3qjWk9vQmS7yZKS3S7rTVK3oqJaa1iz
aiFb6+xcqVtKkqQl3LpqvdxexswIabGGtYZZzB8895zn7rS1s889v/O8fM/3
ORu0ZzQn59nZ2R3Ff+v6dbObQ1M8g98RU7XH6jlUzxr7wqIZJJbP5D27zUHT
sbY4+TCDCFwbb3HwON65b7FGfr8aedAQ0p4RzmAyx6k51MAhzW/h65r9cn+c
c5jDtWqPYmf7wutBoPjHi4NaRx8GLekJ5TN4PrgkZfqvJ4P8pC79cszv0LQm
+tMOBhg1za+OQ1nPr63vXBm832RfuKJBsTVeVZPiD7j/qpnYjYm85hbinQzO
Yp3xrVSfp+SaNg4r34zMRfhQ/+3UbyADLEP3uEPqM7SXuJODnfUP9bkRVJKy
5QkHm57WfPNNiguwn5fdio8scWmN7eMw/udikq9Wxssd4FCK9cXEMaH7tiEO
GHY6N4bBw/6spxMW0i+K8g9zeIvnuzSKv6OeZeGKUdU8/zCKN6zqZ7gustA+
3o/XlYATnwdJ/2AGPhOHrlYOKLbqs7Gfwxesf3uI7C+oV/FlFO6RWd6XLlj6
4VIP6Y36WdAnD7D/aB1GDpDxpkzUjz/1b6J+fBWL/d2KRb3eUu9pk8zf5En3
i/HbUKd1HnSfPaSnOxN5R82Khc97FXtj/879lM+LQZFp0NCLegif+yn9hB6B
Ml7pKIe6qufrXcMo/5i8z65IxSJvrGIxLzry7xj5IZHua4RDc+hkzrXTDJa6
tFbfG6bv02geLDSf6aTfgPRfQQaT3/VTvXpZf3GvYrF2Kxb63Fcs5vcu9a+X
/qy+Q/Nh+x7nzfrzrF7qb6wnf2bKeflnJD9n0XuB3KWvWLUgW/YbaZTvybds
0tPG5xQPYR8/zys+gMb8mEP1GUmvXKlnkVHq5XSByXNGWb85n8430H0UETcq
tr13wo95TPgmroaD1jFql3sm6cvp/UtVLPyerFjcVwLpbyA/nmKAWfQV+D5W
pi4rMuloPjD+TSvHS7/V1qr3wFbPfyU6sy0=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/UrNkGNN8jyHH8GPl85evcABxl8rE5Xyew+UHznP
IXPi25r/uxY4LJt9RMEgeJ6D9X3/3uk7Fzjc/lmXZRMwz0GVrXHq4R0LHFy6
c57/9prn8Gflx0u+26Hy7vMcmg+cWnh0K1TeZZ5D0A65Vu0tCxxuAeX3OM1z
uKsCNGDTAog7HOc52ADNv74BwT+90HXb53UIPsj83jULHPaUTJZgcZ7nEJVi
fb9/1QKHCYe+atxxhbp/BdR8D4h92cuh6n3mORTacl1fvAzivj3+CD7InPMh
CP4poL3F0fMc5r5ffsx7BSJ8YOEFACT2p1E=
      "], CompressedData["
1:eJxlk21IU2EUx4eQRG9GkV+KXiijNz9IiIQGp6wPYSG4D0VJxFIIi16lPgiF
mIUs22wTAvHxGWubY7dasknlkrHldu9uZgghvS6QiIoQCamoD537PEeeyA+X
y++ec8/5n/95nnWOM3WNBTabbTc+1rvaeepTS4BBSWFrd/oFh3+5LcPhp30y
sPIug6p8befBUQ5LSgd6p2Iqfw/m/04oPrtzwYQ/qfjLxrL5WpqB6ds7uB25
/OjjfYsyDK40JZqXj3HI4fcLOoPrxa+e/xilfINBEfa5/0yxtupwQ6WpWOgw
OPROhTKmLvVN6FQ/K/t9z3KwytpHGPwJT48vRrZ0VaMea64enM+dmtn0Nql4
evyAwz2sWNQZYhA9f6KrNEv1H0n9duz3GfVsG5T6LxkUR38Y6lqYk3FtQLGY
94Hic+jX+iiDLfWuVBz/f/3rclPiHsUNqTcdIT+wf6Dn6dpoP5N1RtS+hJ6U
YhHXFFv6v4Vpn0EGV5M537x+Di6cvz4k/R0KcniD/auw/vsNha0vAxxun17W
lgwzeIe8Arnu4er2rxGZ33KHQ0y/OLwG9cbxnffLfdTgfDhFs8cv80/G57I1
n+mjea/N5dl8oc+pWOz7Ju3fT353MbBj3QjqcSw9tCN2i8Fm9LMc9e6v6Nj1
wcPgSENlvigo82946TyFKO6l/iGq180APx9rDCsW+9AUC7+e/BdPc8Cq+TEv
nfcM6Z/lLN0fjzwvFTrt3yP1zuh0n3Ae4ZNB59Mt9Xw0yD8Xk//l6D50Krb2
0OdUbOmp7ZA8aSh/LT5uyH0n2mW/rSbtz6fu719g9Byr
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQvWz2EYUNL+c5BO2Qa82+t8ABhX9+gQMDCPzHzn99
GlU9Mv9H8OOl0esQfPNOx4TU1Qsc9pRMlmh5BeWvhMgbvIGqX7HAgWONTNST
t/Mc7qqwNYYuX+Cwzv1hlciHeQ4NWXtKLi9b4DA9T6j5wCcE//RC122fvyD4
YPXf5zlMc+7OUQfq33KibJ/8T6g8kK+7ae579d/zHFTZGqc2r4Ca92eeQ/OB
Uwtbge7xATrswV+Ie26vWuAQlWJ9/zzjfDi/XezmufL/EPnZy6Hu/wO1b+kC
Bz6QBd+h5i+G+v/zPIdwoMTdhQscgK5b5/5+nsO898uPcS+E2v8KwU8WiLDc
8hzBB4Zq4I4n8yD2LoS65+E8h7lAee9F0PC6N8/BAhieqouh6u/McwgD2he7
BKLe//Y8SDjB3HdzHtgd7UD3Z0x8W2N/E2L+95UIPsj9zmsRfFj8gu0/hcmv
A4bv5LPQ8Dk3z+HPyo+XfM8tcEgC+sfkEtQ+WPq5BjX/4gIHcaC1l6H2MV+G
2ncXEv+iV6H8B/McgN5Mqb6+wGEGKLyA/s8Eiu+/AY2vx/McooHu4L8Nie/5
zxDpGQAuTnvS
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ3X/oq0aM+nwHVbbGqYcvLHCA8X8EP14qvQbBz5j4
tsZ+5QKIOiDf5r5/b/jyBQ7fgepma8x3KLTlup68bIGDc3fO82rN+Q6nFrpu
K166wOHWz7qsPVrzHbivLy7YuwRqng7EPmcgf0/JZAkWvfkOf1Z+vHR28QIH
BhAwnO8A1FUyGcif+375MW9TTP48IH164QIHF6B9vzkw+TD1fLqb5ubzIvhB
O+RaswWg6qH814LzHdbIRKVYA90DdrfwfIdgoPhqIP+lmiHHGpH5DltOlO2L
B/rHNG6XZ48oJHyil0HVi0H5y6HmAfnNB4AyKxF8WHjC+GeA+jbvRfBB4bf4
0AKwPfOB/HsqbI1Xj0Ls4wHywf4+vsBhnfvDqikw+08scJgADM87QPdZA+ND
/CSULwwJ32YYX2i+w4YiYAyehMaPIMQ+5VMLHG6D4ocfwecABsQTXgQf7C5u
CP/xSUT4guMbyAe5Yzb7fLA/tE9D+NLKiPQEACI5KzU=
      "], {{1996.4650000000001`, 
      2163.507}, {1989.1209999999999`, 2154.9130000000005`}, {1988.277, 
      2154.9130000000005`}, {1990.887, 2163.507}}, CompressedData["
1:eJxllFloU0EUhoOoFAu2iA9CXXFBUR8Ei0gsOSXWWqsvFVRMLDVtXBLRWopU
oyEhVtAq6WKlEOpMyGYgqFgR0XQh6ZI0VqQ+FKyiUkQkSFERFH3wZOZcRs3D
5fIxc8/85z//3FWWMzXWOTqdrgYf8X68vNVuYvBj/0yoZIzD3cr3FxYfY3B7
NjLaNsFh7Xx3t7GRiXfyBYedbac+/jqveOHmB72zTsWW4kPbt3oYnC1bMLUa
uRfrZK5InnnOoXrb1fK6a5IDWH/6p9O24waDN2uwQIaDN/F9vdnLILb0cMPT
FId25NftDE52fL44OMqFTl8Hg2f+ikd9ScVOW7y5a1Cx6CemeIPZmyiNcvg6
uc9S3MngBNYzRKifTnmePswh7Bteeb+LQU6mNUTn32RQOBVo7A9yMOJ+xy3Z
rzEo65f0MPgd/TI5EeDwMHVuYIWP9CCX1j6pus7yOedvxs9B+N+Uz9r+nH/V
zf9936IYR6hzOaTeD8if1m0p2HSJ5of69uLCOyf1H6L+XUycsxH7fYX+x4nt
6AdWXTLXLTkboXpu6Y8jqljzV2Ohf0CxyEWC8oT1MzivbyOyvyzqc6H+l5i3
ntOLPEMOmmea/GyhfIzTfJoUi3W7YjHHetKXIv9M1N+wYk2vxpeHxv3zojLf
SeQDKHhZhOZrlvXr0Z+CXOEjDLpx4XhI9herZVCE/d0L0nzqKD9B6u8o+RGg
fFvVvATb8lmbv9BZls/afsGGf7+PGxWLvO6i/rW87pb9m1C/uJd7KB9h8pc4
c0ex5tff64X9ij3oX2uC8kP7p0eoH23/GOmrovuG8xE5QD2mBv3bojT5VUnz
S1NeSX82TfmuoP8JzlvoNCoW+8oVi/troP9NWvkn5kns05M/GVo/qP5fWj40
/gM56JSM
      "], {{2026.266, 2142.2259999999997`}, {2039.1409999999998`, 
      2142.2259999999997`}, {2039.1409999999998`, 2138.46}, {2026.266, 
      2138.46}}, CompressedData["
1:eJxllG1I01EUxpdaSuILWWopvqVO0zlMzUzCE1oJ5ofcB6OkwheykCyzopQs
SiL8YDKKoJcdnTokjcoIkbJyIpJmlJBojeXWilIRyTAwobPdM67lB5Efu/c+
53nOOf/wwvK8EheFQpFPf/b/hb770pITEU5uXz1q/YpQRDy3GeHejKG/7h2C
8/elXKlG+K2xtnz8gJA9cX5tggoh31v12DQu3inahHDh2LNKrQlhujoj5WA0
wuvGnU9PTfB74XzOyrobJP9pm32fu0by80ptYJ8nQkfw/uIFs+Asd4S8rpDa
uDEEUgm84opA8nfLR8Q9/QpR3+0hyRo6f79PcmxBfW9KD8Ke1Gs7Prsg1FC9
mi6E+t5fMQUrEaJWXbrh2olwnfgT6Q1R/Z0dCE8GzvSEeoo637QhfI9O9Ij3
4fsGfteP82jm9wJYVy/euxMk+bQ20M0/RHJmXdm3qjCEQdL7qRe5D0Zwns2s
H4Vw1X9sOLUFIYfqP6xEuEkXla3cp1jOz/AvW7slU9se7Cb/58hANnFpw3R1
zUvOO4bPveK8iU2RFEiv0D2rFHUcMrJOtOjHpJH7R/W1U7+qKO+38xpryUaR
p5H4B+XVHracHf77EQLGhudHti1n53mSn9emSW6imBa3SHbkkoJgj8Vm5PqT
eV6o/pHcQt9bSWJeZthvVpK4f7lHsjMvJ9v9pLeKeT+u5veahb+WOJG/oUn4
mVLyvDTyPEQiHKV8XyD3m/1nIuccJJlWUnHRW7KjXjeeb9Kzl21Y0Im5aOd5
mdXBgeJ0sw/Na1/Yw4rSKZ3oQ7dkh79eyY59HBB9z5jRwVbKK2pY5Dc/pxP7
Q/sUWju5t4v07P1fN8710b449MzCb5kH+7DwPHpxvTbuh99/35f1ku1+jgRL
dvSd9uFRRWlDh5OdefF5QwTvl433n+bNc1R/YvELf1943vX8PfGi/pDrhmmq
j27358TzPlm4X0uYumyuV0m272twAutZ2GcCf8+sIg8FzYOF9smd9IPUpshd
aqGnsvH+q6W/v8GbkgI=
      "], CompressedData["
1:eJxNlHlI1FEQx5cKiYISKhOUDtRui6CoEGlsvW3Z1Np0Xa/VzQwpKy1SqUTE
QsREOkCMWTddTTMzNUktb9Zbkggpk1hCiszCxKCgZn9v4vXHsnx4vzcz3+/M
vM3GcxGmJSqVKpp+jv/zviveWKIRfkbaK2OqEZKcow79OI6QWjKb8/IBQntG
qeuyCITI1g35tRUI6ydHFyeOie/diK982rJ3uRbhQ9ba+iAzQpPt0ouNGnH+
FhFudS9scw+TXFXWu+lbkGRHeF0AQsOF0yWzdL98ztofpka4dqY9Yw3lpxJV
4IdAVab7ViH4F6bN+ADClKdT7roayY54ZXWS39P563rBbcReTrm3exqYKZ5D
d1Ij16cWbGlCKHCZHL0cwPpbWG8wQp27PrmtFcFI/uw7yvwc4XfN91cj4Qh3
1IVpWzs4TrTIt7RT8nXSM9ElWbfKuzG2H+Ez2fclSsTLHkCgMDPZJxEiyO+d
Qwj3yY+VOoRm8nV6mP2L5PwjCA77d4VLziQ/XbSSg6kxZzUcb0TWr8QdFudf
QxEO3PRL+DjI/hP7TGuL7g5IdtTtYWPfQoU+dZ/kG+Tbsx7RL1WomIeCbu5H
CMKwOaDlKenfbijuzgwW9+ydQk96EOvvZD2BkhW9/pKVetXC7xn210PN/aX4
szmH98cdYZ85/y/qtz7ZZ3qsR7Kiq0/yQdLvZeN6KF5e56C5j/wopvkwBEr/
lHshIl7xGMLYYqTdpOH846KfdRGSd5DeZp1kZV/0PL/jXKeB+zWKMKExOt+L
Q1jt3Vj+eIS/T+B9GOb9TGD/BsT8FSUiDJK/F21int8livrz+yQr+9olWcn7
RLKyv4/Y70Qxn+UPeT+M/D3tm9ueKc9Ao/DfWi3mqNAo9uWPlefZyO+FVfik
TRJ6TxB30ML3JrGfzP7JkrNIr+0/rghomfc1cX1WrsMk/MyzCr+iTiEMkf55
q6i/IYXv13A/UplrJf977xzzuGAS71a8BYFUz6WwXjvy+xcvWZn3WMmO/K4G
9t/M8xiDcJX6VVoh5nW3nvfDIrg+WsxbZaV8D/7V8xcRTalt
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQXWjLdX1x5AKHH8GPl85evcABxl8rE5Xyew+UH7LA
IXPi25r/uxY4nP8e/Dg1cIGD9X3/3uk7Fzi8UjPkeOO/wEGVrXHq4R0LHOa+
X37M23eBw5+VHy/5bofI53gvcGg+cGrh0a1Qea8FDkE75Fq1tyxweAmU1/Fc
4HBXBWjApgUOEw591ZjjscDBBmj+9Q0I/umFrts+r0PwQeb3rlngEJUCdIkn
hO5ftcDBpTvn+W4vqPtXQM33gdiXvRyi7rwv1F/LIO5b44/ga8b0HzINQvAr
gAZ0hELdvQIRPrDwAgBKIqCH
      "], CompressedData["
1:eJxlk3tIU3EUx0fUiB5arRcVgqWRxYgeIrKkUxhU/0QOKiosTCF8bbutl6+1
+dZFhfRXD85YuoajIjAqM2LWtnuXaUGsp0OGRYVJhFjUH517f7/4Wf5xuffD
+d1zvud8zy+1wJJXNEWn022lR33HvNaclgqEdL3zYu8AwkSuDSGsmx5Ytr8G
YVN819m9fQg99rbFua5/z+9sEPy1anNmSpNgQ+0jxdOMEPVsu7OB+F5K/Zfn
LQiO4gd2Qz/C0rXv0/RuhMaFr5+N9/HzxMnG21duPhVMKgpNUcFJFB+VEabu
STKudzN9sQjCXcq/u5XV+x5GyDh4Lnic6v32f3sxm3j7UMX8ctLzw5xov0T9
fRhY/ja7SfAikmFoFKzqC9Uj3JKOXjCGef46pt8cYXqGXEz/SZn350S4OuoL
zVQQ5lE8dQIvoXwNZwSr8xp0IKwmnV30f2vpx18ZDh6Xmd4b1XweVN+WMyO2
ogpBof6OPRF+aXqCgrV4QLCqf8TP/HxDXEdjnHYdYZj6P13J5tvdgeCm+p+I
B9P0zpftCJ9X0h9Uj1xyLiA+dH/HrGA1O195DeF8cGzVO9qPrsiJh3Ev80Oi
/mpITxtxPp13uSaz2l/Uw/stmcx/z2v6ygRrflu4/17uhxXBTB+dpKd/3JxI
tzHfM0lvLiXsJj5QaIondzB/5kp8n3wsbpJ4fR/PR5zVvOVwkV+w5kdAsDav
nv/ivQgFc/Zlb5T4voeY/p82zmF2fx7b2L5k0f6MkP/5XO8Y8SvyS6F+8ihx
icz308r0DMt8fha+Bwq/D+WCVT8ulwlW9dhLGSdkMV+Vj8jMb38xq7cmyv07
Je7vHxDAD0I=
      "], CompressedData["
1:eJxVk21IU2EUx0eIhdnLh4gwk95WVAzRGAUhngipiAgUIiokrEhLyCyDTCMT
g1gwhsyw4Txz7FWd8zqXlVRuc83NNUvID5FRIiGRFREVBXXungMPfhiX3z3n
npf/+W9DxcXSs4s0Gk0R/dRn6mfZjDaIcKkoa2rTAMLd6o9/5gIIR5frlHW9
COWPDmbfUhB6co+fue5GOPC+ftW8T/AeB8Lk4YqVx7oRqkyfG/7ZEA7turP3
lEvUO40Ia/Pfbs60S65rXZPxukMyVXl3pF08jV0I204aQ3VmhNKhvJZPToTB
2NUnnSaE5mdxWwn12U7xQSPCbmqj7Zds/eKKGoYkq/M9fsr9TFx/VPDqNpG/
NI5QsIQy74v6LS8QZic2vrnWiaDNbDKHJ3geh2SnJbL+q0dyej7S6cb54Sut
KYQc2ve2HyFhKwnuTCIYSM8q0vUmxSep33xDsX6a9P1VNuM4EZOszpMYXciG
CEIGHaI2wPOFRdw6wPuFEP56vr1KKmLOHyPifp5+nmdEvNf7JdPJNeCTrN4n
2sPzhphJZ1I7eDnM3xO37TNUb42wnl6ErCl7TSPNq/rH4eX856wfsZnyz40J
3VOkl2qL2Tjnu/m+Cc53MY/z/g7BF5K8n10ytfneiJIf0mcvyU8rdEpH/jjn
W1ifMVEvr539G+X97iH4aytNupDk9H2GJaf9+QChkPyRQ9+Ti5vMCsct3N8n
/FBjRagk/xd7Rf9lXSK+w833ci7kaY/k+rktBTHSn/5Wvv30nqroy/uEv5q7
xf0L6Z4fKL64V+j1W+E9+9jvAZ6ffPEf8vfuVg==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dyd87z6zAIHVbbGqYcvLHCA8X8EP14qvQbBz5j4
tsZ+5QKHZbOPKGwA8m3u+/eGL1/gMOHQVw2ZswscCm25ricvW+Aw7/3yY91A
/qmFrtuKly5weKlmyKFzboED9/XFBXuXLHBwAZr3+xzEPmcgPyrF+v758wsc
/qz8eOnsYgjte3GBQ13WnpLJQH6SQIRlyWVMPsie0wsXOMwF0t57Mfkw9VL6
d1Xa9iP4QFKC5SBUPZC/F8g/AuSvkQG6BOieCqCDOw4tcAjeIde6egnEX8qH
FzhsOVG2Lx7oH7Gb575PPgwJn2igfytBHjwC5S+HmOcC5DcfAIbASgQfFp4w
/hlg+Gzei+CD7FkMtPddjb2pHJB/T4Wt8erRBQ7iQPsuH4b66/gCh8u+SQIz
YPafgISnNZBvDYwP8ZMQ/u5DkPBthvKtgfwNRcAYPAmNn4NQf51a4PAK6Pw1
BxB8RmCaOLAfwd8K9Pf8fRD+45OI8AXH90lI/M/Zs8AhCBhe2qcXOPQD+TGn
EOkJABN0PgU=
      "], {{2152.867, 2163.507}, {2145.523, 
      2154.9130000000005`}, {2144.68, 2154.9130000000005`}, {
      2147.2889999999998`, 2163.507}}, CompressedData["
1:eJxNlGlIlFEUhi1NwqLNsigJLG3FoihKRLplUtGPSEnKLMsFMqTFrB9pi4lt
FiZSQWGccbJp0sxMzTRLx0bcRiUpM8eZdHJBc8lxq3HpfN89w+3HMDx8955z
3vecc12CT/uGTbWxsTmEP+m/QXnGy8EMbNTPlHb4ObAN0zOcA3qBhSf1xHx8
CiwhosMS3g3ML39pfHoqsPa6ZU0eXfz8EuTdLRfnn+oEhn+ZuxTAFq9vdr3e
zr83AbCjBXtmXvspOCp5kZ1/i+CdmKDQACwr8kRSD96385/lnq0HduXk+yhH
zF87gge/A3OQCn0GzDGuuFLRCKzZ1T52gVqwFO9xhmADfv+SCWwesgved7OP
vV+aRdwE7KyXQ0NINtWn56zMAdYbs22zwUD680hvKzB0JbQwH9hG9OdRG3EB
sOA5Bz02oT8PvBMiVhYBs/op5bMtFnwV9dSXCJZkHikDhrZ27x/g8aIreP0t
/cB88cPaKu5HZB+w3PILH4zV5F8P5dfx+0ldgrGMjuhOwQsba0bq2ymeTtT/
pE9VNgPjOeF3P+zPllvbj7VVkv8mYJ7GfXcfVgiW/FleDuwb1l9p4vq8tYJv
YqC3pbxfYSY+Dzc01A/0r1rhk/cG9d/TDK3St/B4JvTnPOr5+oP0F5Meo2BZ
r0GwXG8z97uD/L2tp/5i/CK88In6q6T8x5EDQj2NtaWCU1D/Xq3grajfrZzq
wXhS2Vr0IwjnQ2MU/sl+tPJ4ibXcx6p2yl8H7B3WP/eXYEmvc79geV/MNL91
NA/D1K8aYKk+eebxEWCz3bNTXuno/B/ah2raz7/kH/YnBOdvELkS/T1Xzud5
h4XXH68VLO9riWDZn9eC5f19SX5b+HymvKD9sJ7HfetagRVYuP8qfC+m4cEB
C9+XSRXN8xi9F8hrAhM1uWNc7wEVf09Wj5OfyHeQ1f+xpHfdhGA57wTVpyK/
JrmfcchK9KsIuQr1m1W8f05TFPy+mvphS5wu2PreJWJ/AvF+Du5XkBLYmPr3
Zx3pNQG9f6OC5XkfFiylvTRE/itoHgeBXcZ+JafyeU02034o+T46mvm8paWJ
98Bazz85Adi4
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQfX1xgS3X5wUOP4IfL529eoEDjL9WJirl9x4o/90C
h8yJb2v+71rgMO/98mOnXy1wsL7v3zt95wKHHXKtrwNfLnBQZWucenjHAgeW
MD7dTc8WOPxZ+fGS7/YFDjuB8hefLHBoPnBq4dGtUPnHCxyCgBq1t0D0T3y0
wOGuCtCATQsc4nZ58jAB+TZA869vQPBPL3Td9nkdgg8yv3fNAgetmP5DW4H8
qBTr+/2rFjgIAS1SfAJ1/wqo+U8h9mUvX+CgCVRv+nyBQ6Et1/XFyyDuE3yJ
4E849FVjzmsE3+Nhlcg7oP/nAv3tvQIRPrDwAgAZdKmX
      "]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3,
       3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxFlFtIVFEUhqVCxKKCrlCY99HUSNNmchha4zjqOI6aU2JmGjaSaRfT8ZJa
KSoaESZmsQlji4gPiYVZSUlFZoSGPUiIWElYdEN6iLDoodbZew37QYbPc87a
//+vtXZA4emsomVeXl4H8U/7HUz+ULvexeC3c6HvUBiHwrU5e4ZzGRzvWKx/
Esxh0+zU0vR+Bs4Rv5ZbgRwmeqz3K7Lk+1uQrzz7FfY2nQFWGUwO4BCX/9C2
yi6fz/lzGHV3bl6RrPhraLTPAChu3Tg7VW1kcKe8uGMRv/cZ2Jrr0jO4UDLq
Xofnd//of2HfxcB3prfMFMohxLuxyxLN4F2wd+OGcMVavRuRit/j8zc7iGOY
+B3bSRzL4IzJd+ZoDOnTS+6N5TD353zJqJH87ya/CQw0WY8MMp9YG3E8h+f+
qBzzuWa5dEJn4uDJUztnOShuQD/TZsXZq6OGDidxKNPOLZT16mxS31gBgyzM
O8Iu8/iYx+Dey6rH82mUXw6d7+BCd5BTsZbnUrriqCFM0E71HEr/Tcx1JdaL
1J4nMdBfNB/5lEr5WxkY5zMuX7cpFuekSP1XrdKfxaq4Dc99YJH9mkyU89Ca
QHlbGLzCHO+i/20t3/eNmGW9Bcznm+ZnL/kH8mNSLPzGKxZ6DTLvz5589dRf
rF+DH7TFUT/x/GDt/9jvXJdx/rVFsZgrq2ID+g9JIT1Yr+npRM94qpyPZpPK
T+RhkfXaM7jMyU7nZ5L+bMWaX0O+YrEvLprfTNJfQv1K55CItv6eZLAGG3fb
Qe+X0T6k0X6WU37Yn3Gcvy8VTM5pCul1S/0tVsViX82KRT7RisX+RlHebjmf
3dtpPyrpfdy3aQcqqJT594fRfFbKffmno3muovsCWcuttFr6PYCsjaezhvL0
8FnF7eg3r1ax0FVH+nSUV73MswlZG4O6cwwm0f9PndQf2UDfh1M/mokjFHvu
Oz9tHrHeMO5XQRCX9wj5XfCn+++UYjHvpYpFv4op/wDSd4wB3iLuzkC5f7oi
2o8gYpect74QdR949PwHp4N0Pg==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQvc79YZVIykyHH8GPl87WXuAA46+ViUr5bQPlR810
yJz4tua/1QIH6/v+vdODZ0JoywUOBbZc1xcHzHRQZWucethigQPHGqBG75kO
f1Z+vORrvsChECTvPtOh+cCphUdNofKuMx2Cdsi1aptA5JWdZzrcVQEaYLTA
YU/JZAkWp5kONkDzrxsg+KcXum77rIfgg8zv1VkANicbqD8qxfp+v9YCsDuc
3aDu14Ca7wmxL1sdqt5nJsRdalD5AARfvvV1oEUogj/h0FeNO9EzHea+X37M
WwMRPrDwAgCWHo7V
      "], CompressedData["
1:eJxllFtIk2EYx0dQRIOMkAg6mOzUyKAuoothPrnWnMuMCRHaRZiSHehMhUUY
amaW5mHUS5TvkG0YplIaUWqyzMOWRRoMMZtpXoiEWBd10UXP937Px1ttMD5+
33v6///P873J+ac8hYt0Op0H/8ozt8AWe+9n8Ctn2r/GyaFi1di7i+0MHs4H
+6uyOKQ8eTAffMHAtOSa9/U+Du7tlTsP9UnG6T9zhiTbYtm37w4zOJO6LGpA
Dtzv27Dlg8rTezkYlXkfVW7C/TsHL/Q0RhlMKANuDvdOriztHWPQsja34GUG
h6Lab1fSxhkcxeer3Rx0yu8Tg7c+x7OndslXj3Wdr0+TLPykSLYerAlts3II
47pzyGJfC/mZUM+zmTm0Or8UJ35moLwuNNH5MQb6aNPpbiOHPTgwOan6tRvV
/UumGPxuXhgZNnBAFavLZkgP8vLNGOBsPCv5RpI5iPy74lmb78f82nv+Wx+S
vBSFf32j6p1BXhjJyr8zQPVDfULnEPk3kf8wA8/z9eWb0G8H5p8UUfk45oGn
nS0inrPQfhE1n8tWyVq+Ggv9OyQLnenUT3heBM/94VD9ZQ8yKEH9o9hvok/6
qZ4uyjNE/ZFJ9emWLMY7JYvnY9KXQfn5yd8uyZpejct6w77F6EeRaQkw2I+C
11movgF1/8OYz1RxYutAkIHXXnXiCOb3Hf2taGaQgAvbjFSfR9Q/RvLXQnkY
qL/bZL2UvBs74lmrv/BXEc/afMGV/65PqpYs+rWW/Gv9Wqf6z0P9l2bNW280
UH+YKV8vnbdRspbX3+P6VMmlmF95Op1P88cd5If21ztpvIG+N6zPKMZ3oJ5B
HuaU4KK86qh+LupX0j/nov6uofskk+6Tasli/S3J4vu9SfeNS+Yn6kmsu075
uGncJ+8vrT80/gOgdFv2
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQXflSzZDDaJZD0A651tdqCxw+XvJNmqA7y+FH8OOl
s1UWOMi3vg600JzlwKe7ae57pQUO7WI3z31XgapXXOAAJAN3KMxymObcnfNc
YYHDlhNl++RlZjkU2nJdT1aA6hdH8DMmvq2x50XwTeN2efawzAKbWw403/q+
f6/435lg+cVA97wCOm/N15kOf1Z+vHRWC2r/x5lg+9QNEPwzC123bTZD8IG6
C2xtoeZ9m+mwRiYqxdp5gcNl3ySBiH8zHYKB7l/tAZGfzgbxr7TfAgdQcOgI
znJoyNpTcjkAql8OwQf7Tw3Bf1glsu64ziyHee+XH+v2X+AAC8+1QPt++yD4
YP+GIvhge6MWODwC6TeE6D8dCzHP3RCqPw5qvsEsB35g+OsnLHBwAQbzb/1Z
DqpsjVOZExc4HFXYUPRCb5bDKaD/i4H8CYe+atzRhdj3OBEavjpQ/yVBw0cL
wQfHhyaaPNB/91TYGq8mQv0PjO+5QPd5J0LdowRxL3cyVL0tNL1kQPjlTph8
sHuMEXyQOe160PTjBPGPszY0vTjPcqgHhq+wFoS/wxmavjQWOACTLEODyyyH
u0D3iWpA488Vap861Dy3WQ4WnY4JquoQ9QweiPQNtt8TwQf73xvB3wqM3/m+
sxxOA8PTWB1qfgDEfYfVoe4JhIa/GlTeDJGeUeIbyAcAz+iJ6g==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQXflSzZDDaJZD0A651mytBQ7I/NeOCxx0N819v9wQ
wtd2WeDQLnbzXLnBLDBt7gbl681yqM/aUyLsAeXrzHI4vdB122fPBQ5RKdb3
z2vOcvgR/HhptPcChwqg+R1qsxyAph7z9lngcPtnXZaN8iyHjIlva+x9ofYr
zHJYIxOVshvIP6qwoeiFDIL/6ZJvkoA4gj/h0FeNO4JQ9wPNe1glss6dd5bD
PKD5pz2h5rPPcrirwtYYCnSvfOvrQAuWWRB1jgh+oS3X9cVWCP6GIqCLjBc4
bDlRtk+eHWqeHsR/33kg9ltrL3C4DHTODaFZDsFA+1erL3DoB7onRhJi3mNV
qH8VEPyPQPdPUEPwjwD9lwEML/NOx4RUddTwB8UHALxkufw=
      "], CompressedData["
1:eJxllHtIU3EUx8XKxOiBaPRH1MzpkBoUFpqSHZ1lkBY6yFqFdefCIrIsoizS
kKiw18gSfpfqlqm9NCsrCXuQZpFloKSGifMVWprZU1NH597fGb/Ewdg+2+/e
c77f8z3XT0pNsLm7ubkl4lv91F7uMuxa4tXQvkUBFTMnyHCxr7AqO56z+v//
nOlkMGBuz29ao0D15WUPfgwySJxivNtsUWBlyPHITT8ZHNpWvufsRgWmf6j5
Y+5h8BrP7d5M92tjWj2rlc6/FyxNW7t4YaXg0ld7n8x+yKBopiV5KIm4mEFC
2awjc9dxvlTAAMtfSDUrEIv3c1zh/cmxgs14/ma04KANp58vilCgLg4r5jPI
wH7NoQpYksNbVt9gEOBx+Ny4YOLbDN5g//eM/HzjfQbD1/tr3wYpWt2+x3S9
QQFUPWN8Ffmhp+truJ48f87v6gWrdSqaBPfXxklnHIz7ilwgV+rmd5Kfeqrf
zeAoGhsSQP1/ZXDelL3dEKhAPp4v+U7+GUZze5jg1nSf4hjUr7ZvQE6x9x7M
APK3n/F5RxJ/Y9Csx0ajFNjXHbjgGNZTf08y0fx6+Dy+mGh+nxncwnkdQL89
1S+fuJ8V0eSXYyxr+pcrWh9LfeUx7Dqfu8M765m34OKY1vScyYL3Y3+eXjKo
bXWaqH9PmecF+1d1v/SQeV2XXg9+fVaEYJdfLlZlhKO/Wo6dlD8919fxm/tf
OIfrSe2jvPhRHroYbEUdT3U07xau36SjedQLxrSczC0XrPV7jfKtJz9kPp/q
eVy/j53BeszV1GDarxM8n3FhgjV9UYI1HSsoT6cYhKJfAasofzm0P2bKr8zn
72uh/q5SvSTSW0J5kSiPj6hfG82jio1+vtQJRvVpKY2Ctf38yOBOWoq9yMWU
FxPyCzzf1UH7ZaP9x7xNasjbOZJM+ijvefj8sGIeS38xwCr2Xon2aYD2SaL+
BwVjiuPL/grW9nWI6kk0r2Hyz0p+jDBowzlNxPpqXX8nr2e0kX9Ooe8fxDR5
Nw==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQHZVifd/faLbDqYWu24q1Fzjw6W6am2+K4H+65Jsk
YDHbYZpzd85zrQUOy2YfUTCwmu3QkLWn5LLmAgewfpvZDqpsjVMPayxw8Dbv
dEywne2gGdN/qFQdwQ/aIdf6WhXBB1GpKgscHlaJrHMH6gea0iuuvMBhy4my
ffJWEPOYlRY4nAa647P5bLC73isscLgMdE4E0H2FtlzXkxWg9hsh+CB9zvoI
vg5Q23IdhH6glxkatBDmi9089z1YA2F/xsS3NfbqCPfB+DD3w/hrZKJSqtUR
+ue9X37stAbC/B/Bj5fe1kTYD9avhXAfLHzRwx8ANhOoIw==
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQLdf6OnDHpdkO894vP3ZacYFDu9jNc+XzZjv8CH68
dHYUgq/K1ji1WRfBt7nv3xuuucCh/9BXjZj5sx0yJ76t2a+2wEF309z36gtn
O6yRiUrZrboAYs7i2Q53VdgaQ1UWOACtZGhYPtuh0Jbr+mLlBQ6XfZMEbqxB
8K2B5k7fiMmHuQ/Mb8Lkw9QfUdhQlNGO4IPsl+5F8MHumzjbIQPo3nqgeype
qhl2TIa41xrofpfunOe/p8x2mAs031t9gYM8KHymznboAPp7uyaCDwsPGB9s
fiSCH8YHtClmgYNp3C5PHiC/+cCphUfjoPKTIeErnbAAbM/pSbMdolOs7/Mn
QvwjDnRfOFD/XSh/eh/UviSofM9sh2nO3TnqyVB+B8T91cmI8EDn12ftKQlO
hYb3CjT+Tah6A6h5XHNQ5CMMMPkw80HhuVwbwZ8ATA93VBH8R1Ui644rzoGE
RxI0fuTngMPrMdD/IOH3snMcGoDmX46HhI8FkD8V6L/0WAQfOXxBfOTwB/Fh
6XHLibJ98nJz4OkRlF6/y8+Bp8egHXKt2Upz4OkRGOv3/dXmoKQPkH+Q0yfI
v+h85Pzy/dtsDD5MPTi+fyP44PTPiDDv4yXfpAmsc+Dp8SgwfF6wz4GnR3D+
4pwDT4+w+IGlRxgfFh4wPnL+/X4V4T4Aq0bPzw==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfVRhQ9ELrzkOa2SiUqztFjhMOPRV4w6QrxnTf6jU
fIGD7qa579X95jhYdDomqBotcHhYJbLueMgch7nvlx/z1lvgwAdUkB89B0Jr
LXDImPi2xj55joMqW+PUZo0FDvKtrwMtchD8l2qGHDpFCH4/0L6Y8jkOd1XY
GkM1Fzg8AplfPcdhLdA9v4HmLZt9RMGgYY7D1hNl++brLHAAu7cZap8+lN82
xyFoh1xrtvECh3axm+e+d0L5QPda3/fvnd4B0X9fd4GDadwuz54WiH93A+27
7JskcKMWap/qAoctQHXyQPeA/aG0wOHWz7qsPXlzHAptua4nKyxw0AGGx/IU
BB/kvg2RCD44XALmODQfOLWwVQninnKPOQ7zgOKn1SD+X+MwxyE6xfo+vzY0
PG3mOPxZ+fHSWQMEHxQ+zBZo8vZQvgPEvseuUL4HRL2zF5QfAJFf7LfAARir
989HzXFoyNpTcjkAGl5pCD44fgsRfHD4VEL0K/tDwk+8AWL+YW+o+9ug/vVA
hDc4fJ0RfFh6AgBhZBw7
      "], {{1810.727, 2080.554}, {1821.289, 2080.554}, {
      1821.203, 2082.023}, {1821.031, 2083.054}, {1820.773, 
      2083.6479999999997`}, {1820.355, 2084.5730000000003`}, {1819.734, 
      2085.304}, {1818.914, 2085.8350000000005`}, {1818.09, 2086.366}, {
      1817.23, 2086.632}, {1816.336, 2086.632}, {1814.961, 2086.632}, {
      1813.727, 2086.0930000000003`}, {1812.6329999999998`, 2085.023}, {
      1811.547, 2083.96}, {1810.914, 2082.468}, {1810.727, 
      2080.554}}, CompressedData["
1:eJxllG1IU1EYx0dUSEL2YWRQCbIXHdUHQYkY5pNzzavYy4SIlAhf6E2oKCgs
oshRscIsR4hHvSIRwTC0VUMLRSnMpaEzNTSGaZkuqQixqA8995zncqJ9GON3
7znPef7//3NPcskJd/kyg8Hgxp/2/+zMnXXL2xj8LJy+t96lwrw1Lc7fyaDx
6/2X3gIVbvUspk6+YGBZednXu0eFVtdUZe0byefmrGnXRiQ34L7QOINTmavG
TMhx/g0HyiYFT+9S4erad4NLEcEtWD8RMfyBwXszFshXIdTsfPJjhoG2rTNX
hX7k058YHK1ZuNC1U4WSNfu3pc8yeI3PHzkkXzyGSrIkcz2bJduKq3sybCps
accOkY9gvawU0vNZnGe3qjBVaWx1zTHYen3HoXILnT/PIH6s5eRzs1hv/CL0
OpBLsX5ggcGfB9+HB0wqJHmie4PfqB9k7sNiLGv+hpJV4P73xbK+XvNv5tV/
+wcl2yO7byYOiX4/Ims29g5Tfmbh99kR0m8h/W8ZuINJnk2oV4ujcFTwcfRj
CX2rJ46mUL1R4c95m2TdX515/9slr9YOyqZ5wvN4rk6hryrM4BL2H8Z5Cxdg
QkOUp0J+DtB85FE+fZK1PAPdkrX940HqL5f8ayN9OZL1fnWu6u5vXoF6qnG+
i5H3YcMbaR6M7aJ+KfqT462Y/Y3sc3grDqN/PPcAgwTU99BM+Tym+TGTvqfk
h4nmu0PmxbkrlvX8ub7bsayv51wrmedXJ5nPKyP9+rw2Cv1F2P/EL1zZRPNh
JX9VOi9Vsu7Xv+/jMyVfQf882XQ+rZ9wkh6qH++i9030vWE+GQc7lBvYT1GZ
PZKgkF8NlJ9C80r9RxWa73q6T/LoPqmTzPfflcy/Xx/dN4r0j+dJnF5D/uTT
e7+8v/T50PkvtcJz1w==
      "], CompressedData["
1:eJxFlHtIk1EYxlezvGReMlNY6KbOz2u58pY2erc53XRLUYoyuqAGZdFV+iOj
EpGKihS7gZ46IuYfiUnZhRolWREaBkmIWVlYSIVIRVRE2fnOeccR5NuPc3ue
57zvMVTsLt06W6PRrGf/6td2cudkbRqBX2UTHRsSKP/qFALbm6YOPYijMPb7
cPVKA4GyO1ENV2MoND78kfA6SszXMTbOrTtn0xF4f3Bhd4GBwkCb/db+CDE+
pqdQytbtCJPcXcBmzpfsyjpheedLoGfftqYptv7SdOeTQS2BI9WemjB2fmXI
uhW9M60QMNK+xxxP4XO8ya/rbyu8iZtbF54oWd2vJUXyWzb+cgmFTyr/a+U6
+9OQNQT2mgNGKpehPq3g9nTKv7F+6D8T/QYR6FpcXnUvW+TTEo6cQ6G8Knf8
uZ7AeRakYqbgzVM9TwuSjzI/wxbJa4NSr2/Mp5Cx6a4zcKnYr9Yp9KWkEK4r
uYgCYXkUJRK4+fTA/XEX5mfE891i/aloyUUszy06yd9euCtCInE/t9Sv5jzP
hePsftRlHwsx/1ACuePFpy84JfNcHBTymP4/ocKfzS75+KLRods2ChXsvtJD
RT0cs+J9BBN4xuriBvPfy3xEB4n9JgD9BKJ/QD/+kvm4r2Sud47Ie9Kbr1bo
6Wf7s1jJ9Cy8TyvmyZjfk00yz9UuOZv5NzrwPB8C9X0DbY8LRX188Zf58TyC
xX5niilo1L9IPL8E9cdIVv1eTpLMczMRUb8lqD8T72s1BT/1Rw6BYObjmhvn
m7EfXNifqzA/p6i/YiCi7xyoF4T+Brtkvs4imedjksz7NxX9W0R9kiTsDwvO
Z/12cdeC+j6LyL8zAevTKvplRsF6tuF7wThidOjnsE34XcP4FXtPPHmYpyLe
F49dcpyaU77kKy2P9D0FqE/BvBwiz3pF5PXBSWCQ+f+uCP1nXbg+Ee+jBDlZ
sve94/XI1qvfzbEUPDXNkT5WzFeP71+uZF7vWZL5fWVg/gbUt5wAc1XTzN7H
r6xeG03YH7HIaaLeOozyPfDq+Q8E1nOU
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7dyd87zaYK7Dj+DHS2drL3CA8dfKRKX8toHy1eY6
ZE58W/PfaoEDAwgozHWwvu/fO91ygYNp3C5PHtm5DqpsjVMPWyxwmPd++bHT
4nMd/qz8eMnXHCovMteh+cCphUdNofKCcx2Cdsi1aptA5Hv45zrcVQEaYLQA
LJ7NN9fBBmj+dQME//RC122f9RB8kPm9OgscxG+e+34ZqD8qxfp+v9YCh5dq
hhxrhKDu14CaLwqxL1sdql5irkOhLdf1xWpQeRkEf+uJsn3zFRF8kL+cNeY6
zAW621sDET6w8AIAZp+Rdw==
      "], CompressedData["
1:eJxTTMoPSmViYGCwB2IQHbRDrvX19bkO894vP3ZacYHDKzVDjjWL5zr8CH68
dHYUgq/K1ji1WRfBt7nv3xuuucDh4yXfpAlL5jpkTnxbs19tgUP/oa8aMcvm
OqyRiUrZrbrAISrF+v75FXMd7qqwNYaqLHBIEoiw3LJmrkOhLdf1xcoLHEzj
dnnybELw54LcsQ2TD3MfmG7H5MPUfwe5uwfBB9nvPwnBB7tv2lyHDKB764Hu
ufWzLmvPDIh7rYHuXzb7iILBrLlge73VFziAwwfI7xC7eW67JoIPCw8YH2x+
JIIfxqe7aW7MArA99kB+84FTC4/GQeVnQMJXOmGBAwMIAPnRQHfyJ0L86w10
XzhQ/91EqP8mQ+1LgspPnOswzbk7Rz0Zyu+FuL86GREe6Pz6rD0lwanQ8F6H
xr8PVW8ANY9/Hop8jykmH2b+BGB43jFA8D8B04OANoLv0p3z/LfaPEh4JEHj
R2UeOLweA/0PopWV5zk0AM2/HA8Jn2yleQ5Tgf5Lj0XwkcMXxEcOfxAflh6B
0fQ9GGgeLD2+BKZXHdV58PS49UTZvvnq8+DpcU/JZIkW7Xnw9AHzD3L6BPkX
nQ9Lf2Dz/8zF4MPUg+ObAaEfnP7ZEHygM6Ye5poHT4/gdME7D54ewfmLbx48
PcLiB5YeYXxYeMD4sPwLds9thPsADarX4g==
      "], CompressedData["
1:eJxFlHtI01EUx0eFiEVJbzBK87GZGhlWlglnzrXNbWkbq3yUMTVSyyxnkYYm
cz5SSdEeIN6uiPlHYlL2oEZJL0LDIAkxKwsLqRCpiIr+qPu794w7GPf34b7O
93vOuSHOo7a8OSqVKp39lVHXcHi63EXgt32qO1ND+RhUSCC/Zeb0gzAKE38q
CrbnEbDfWe25upZC88OfmjdOsT6Icbhf1XldNoEPZUv7DCEUhjr1t0oyxfxE
MAUb21e4R3Kfga3cJdmypV773kyg//ihlhm2n8z2PB02EKgs8LqWsPtzAvdu
HdARCBjrKk6MoPAlIta/V0vgbZhf1bJIycp57dGS37H5V+spfFY4ifA4H21A
TiZwLDFgLGcjxmcQ3BVH+RhqQf2bUa+NQO+qjNx78cKf9nTkbRQychMmX+QS
uMCMVCdS8Pmp3DcXJJ9heka1kncvjLm+bweFTfvvmhaUiPPKTSK+6GLC44oy
U+hgfpiPELj57MT9SQv6l4/3W8X+xhzJZubngWzJ319anYFZeJ5Vxq/4PN+C
8yw/yrZPKei/g0DCZGrTRZNk7ouRQjKL/69D6NPpJdctHx+5raPgZPmKc4h6
qE3CfNgJPGd1cYPpH2A61tjEeVOAetJQP6Aeq2Q+b5bM4zUJv6d9/howv+x8
ZmvHrB7zmYR+MuZ50knmvuolxzP94Ua8z0jAPTjU+SRF1MdXq/SP+2EX551L
paBSfll4fxrGf1CyovdykWTuWynWbxrGX4b52knBX/moILCI6bhmxfVV2A8W
7E83+mcS9ZdaTUTfGTHeahG/Ry+Z79NK5v7ESub9G4P6PaI+O9Zhf3hwPeu3
S0WL3YMe4X+PBuuzRvTLPzXWcy2+F4xXjI/8Gq0Veh2MX7P3xFuHfqrF++Kt
lxym+HRW8pX2x8H9DRifGv1qFH661cKvj00Ehpn+H2oRf1sz7o/EfLQhR0n2
vXe8Htl+ZcwOpeB1ta6cV4P+BuP7VymZ13u5ZJ6vU+h/CMZ3kgBT5Wpl7+M3
Vq/NpdgfocguUW/d4fI98MXzHyeThpY=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7dyd87y6ZJ7Dj+DHS2drL3CA8dfKRKX8toHys+Y5
ZE58W/PfaoEDAwikzHOwvu/fO91ygYNp3C5PnsR5DqpsjVMPWyxwmPd++bHT
0fMc/qz8eMnXHCofMc+h+cCphUdNofKh8xyCdsi1aptA5HuC5zncVQEaYLQA
LJ4dNM/BBmj+dQME//RC122f9RB8kPm9OgscxG+e+34ZqD8qxfp+v9YCh5dq
hhxrwqDu14CaHwmxL1sdqj5mnkOhLdf1xWpQ+QQEf+uJsn3zUxF8kL+cc+Y5
zAW621sDET6w8AIA1WSW2w==
      "], CompressedData["
1:eJxlk21Ik1EUx0eQRFFGrx+KTKabK/0QIQZLOim2Pdmw3IfCJMIUxCLJJCuj
EouKCpOoQdntrhwSSYmkLFsmM2dpL2gva0aNkugNEQuxoA+de+8ZN/LDGL/n
nOec/zn/8yQWleeXTDGZTFn4E/8fDs675WhnkBxXc6F7I4d/uXYdh56lLRVf
7jNYHc07u9nF4e3vw2WBHp3/EfN7n2qeldZ6pXxA84kFkWdVLxn0e3PaVyK/
cBXNfvOawZGyQOXcPA6l9SOH1kSYzJtwUf4Qg3isc3uD5ubFBcX2XM2iz6jB
wY66PBGlL+yk+mHV76eDw51H+zoTsN+fG2ODM5F/DGIC6vnlHvZdxvlEmaYB
zXXB8ZTC55o9u+fUdj1h0FJRWp/moPqPlX63U+mZCCn9VQbFHzJgo02hGetJ
b7dmOW9Qs5yji8GywrpgG76//6tlxckHFEceQ73nArQP7J99etfn6rsM+nC+
vTnaL6knS7OMp2oW+kds5Cfysa4+79QUNb/Vr/Z7z8LhAPafhvXfJ8XVvErm
kL6twzjTweAd8nzkJce/b/IHVH51Eod8Pz7pZNCGe46alR8LcT68ksrzyAmY
vyo0mcV8/Yk0r2cyx/KlvgbN0u+r5L+Z9u1l4EYdN1EPnrTp6HUGNtxnOuoV
4zQ3MthabI/GW1T+Fh/dk5XDNxH3UX8r1UPOOLV2e4lNs/QjVbPcV+Z/8Wyu
7sZH9073ZY0x+jckvp9GdS8ZTvKf9I47lV+915jc606D7tOr9HwyaH+cwZ7M
6WFz7L6YZvleg2ahZ9ElxcOG3q/gHTG+qPotzyX/WvX3+xdlvf/Y
      "], CompressedData["
1:eJxlkm1Ik1EUx1epmFaa0YoUdbW5OVtOl5WkdMyyzA1BIUIiQovKXuxlFPQu
K0IsUsz6IN57RSqCigiNiFFiEbFBH+rDMHuTVUsshgwzGUTnee59vJmDcfnx
3HvuOb/7N9Q2VO2eqdPp1uNfWTc0HwhFcylUPU6/uL+SgcamuMb25w7JCYHu
w2dWMBicOFtfZOffS3MYvEP2Ip+r97oXWMX3PArXS/GghYHX3bY4Jp/CB2Nc
40Lk39XBm6kOqq4dZga3Ol5k2ldSWNNUstOE7Ova+OhYAe9nJIvxdZVknfIr
lKwfeD1evZaCH885zGJ/segfuTN8+2XFOs6zcH/Bjiflc4wUjhQnBOoyOV/O
mM7aPHXJ2wp7FlE4j/zWxOfzzhf9LuPzdMylQPCexKUMlLFPzaZwMBS9M4r1
el4df5oR+199nWTVe5RMsur7F4EUT5/PYBA+I4Tfo9UPE+7TyMC5uqnk8w8C
99JqdkVNot4I4XOjb8VLZJhAL/ZBtfdBVj3ZpnJOvmRlnuYyydbtV/t7NzMw
Kl6/E+57C4OW/jHL+xDhfisYzLM97Ax/I1D0qfJKAHn0jau25Svh+XEKf0F+
PoIcfzet5ssQgXYcbI+Lwf1NQyevfSSwVSmErPThHyCAp9xt/7CWV5UnprPi
M2ifyt3LGc9tVPSXLeb7w/v3WEQeZ1B4cHRvqw3zc+MQvkQMz49Hy2O8ZLV+
omQ170kUstHXGPK48m4pPO+DZnGfnsK+1p+nn1lEHpZQuIRBPmGV+VN92iSr
58skK3oayoWvdApJyLnoezgrD5Xy/alOnn8/1r/Q5+uKdYm86EW/LjFPMp30
q7Hm8y+EEO3d
      "], CompressedData["
1:eJxVlXtMzWEYxxtG0ySLck101Okk5XImqnks1JHT6UKFaiS33CqmllZC65gs
t/RHq/eNmT9c5z4alkuG8UfMJTSXDTPrDyxmbZ7f7/22N3+cveez9znP87zf
53Im5G5JXd3Pw8NjPX+M0zKwsu5OjqDUawFVG6ZJGl/1LSVqqaCmrpP3H02X
9Kh5/pUfiwU95vOiHZwiqDB28IugKHCSoPL8lm2HZ0t6yLzVKWj3bf4Wq/n0
2GV50aR5/cHvZbfmSWp35vq8TFb+jidIdWYo/pgoqdrv1ZPiHMRzScr1yZw1
Y62gSUbeyZL8Xz3pbi/UXPI1eKq7VPPZ+Pelw3chfxfiu5GvUyq7Bs3Rna79
9U2aO/6U58dIQezlbLVTxb/ErN6BfJoFpXuHX8h2Ij6zkfdM5lWGfbPKpz/z
77SPJ8YcE+Tm+6uLJPHRncY8NPxCY0QfNuuRqJnV66xdKInNukKOKf/dDry/
Gfo5lP8GxC92qPfFMb/lQi9hNustUY/ee+ZLD7bfHO/Q76/g9/s6tD697Mk/
/FSr2bQ/DH0XQN86QVF75644EafZeM+3OZrTmE9FQ79Dgj6wvoOioNc+6GXH
fZUgrxfHC3qmoh/KVP47IiVxlUbuKfyfB2zSfDfwfNG6dUq/p5Hwvwr37O81
17dlhaDQrNpWeySY+82sUwTss1X+YVNQ/yzoF478mDnKwU2TNZu6hWk25mR6
GPxnQR8b6peNeDbMU46qV12o0td/JfILRb3yBJ3h+H+tal6C1gh6x/bPmY0+
bcsXZGP7y1bEL1L+G5jvsR5fKgRxuzZu6bV3w78V+dSgXiGS5u3b+PnvIegV
gt/Xo5+C1XwdacC9RfmLF4Iucz+JiciP+y+G35ERqNnMZ9z/3DEK/dsIez/4
P6r2kZcv3lOD+fKWxOPmeboc+8oL9d+s2dxnKzWb/ZCO+g2Bfyf09wEnqH5s
G4b9sUBQW+LMvZW+mhvZX+IIzWad/NDfzL68AN/7Id949Ls/5pn9H41jYUdK
KjDmdiH0Gg09eJ/u5PlqH4v5SsJ8jkM9eP/+7HlW8jUA/jLRX6z3gdZf1jeL
oU8Q3puK/WlBfyUr+x8W7CsX+nUS6p+k9tG5YM2GXjdCNBv5dlqxH1zQ04b9
nQK9ud/tOdcdNWlK3+U8L2ZfZWCfRWAf9fn/+Qds1QSZ
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQXWjLdV25YL7Dj+DHS6P9FjjIt74OtMhG8K3v+/eK
p8932HKibF+87wIHVbbGqYeT5zsE7ZBrzfZeAKET5jtoxvQfKvVc4KACko+D
8t0QfLA6J1S+tu0Ch8qXaoYcifMh9lgucFjn/rBqSup8h9MLXbcZm0HlM+eD
7WU2WeBwRGFDUUYuRP9rowUOSQIRlluKEPzbP+uy9pQj+BxrZKKeVM93COfT
3XTXeIED2L/1EPMOm0Ld3zTfYZpzd85yc4j9Ii3zHbYC/TvfCsEPBqpbbYfg
g/z31XmBw6MqkXXHG6Hu94C4x6R2vkN91p4SYW+ofCXEPmdfqH2liPBFD38A
c0yxeg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQLX7z3PfLsfMd5r1ffuy04gKHJIEIyy1R8x1+BD9e
Kq2wwEEMKB8cMd/B3jRuV6ccVD5svkN91p4SYdkFEHWh8x1mzQQCaaj6kPkO
GRPf1thLIfiqbI1TmSURfD7dTXPzxReAxZ3DIPZziy1wKLTluq4Mtf+2yAIH
FaD84QSo+4QWOFz2BbogC2LeYcEFDhxrZKKelCH4IPkbTQg+0Jr3y7vnOyhu
KMq4KAS1f+J8h6Adcq2vgeZXvlQz5Jg+3+FRlcg6dnGoeTPnOzwE8t0lEfxg
oPrV0gj+VOfunHSg/0HadWbMdxBuPnBqoRzUvVMg7o+WX+AAtP2YN9A+6/v+
veLA8GwHOqC8C+K+ZgWo/xvmg/29WAGqvhASnjeBfHD8pM53AFqbYq0I5SPF
FwDaGs5O
      "], CompressedData["
1:eJxFlGlIlFEUhocKkYqSdjBKcxlLrQwry4Sj06ijY4pSlNGCGpRFq/QjoxKR
iooU20DsXhHzR6bWaGpNLpklGlqKiFujmEmKuGUqBXW+e49cQb55uNv7vvec
6xx3LvrEPJ1Odwj/ta/hzpnB5F4GMzH9eYc9uPg6tjM4lTFytcqVQ9fstcQ9
XxnElK9Le76BQ/r7KY/uJjnfEdnNLuWhoZFB35UVhSHOHBpyjK8vfZLjXU4c
onHd6VrFhSE4851i887bgb1lDIovnswYwfVPR/M/NloYXE+0Ji3H8+MdDu4q
KWKwsD33fIA7hyF3H/uCFwx6XO1SVm5UrO2X5aX4G463bebwU+NCJnTWbiUu
ZnAhYGF7/DbSZ5Gc68vF16Wc/O8gv5UMCtbGJrz1k/lk1RHv5hCb4G9r/sLg
EQapD+Awl6d23nxQfAP9tAYqPrDE+9WRYA7bj74xLbbJ/ZJNUp9XNxO6PMM5
ZGMe4R0MSusvV9rMlF8bnR8h199tVhyOeR5vVDzREhHnUE/7RSj9Ws6LzDSO
96MtGwij/GsY+Nsi7z02KRa5hHLYi/r/1Eh/BqPiW6s6msoMHOLwvnxrZD3c
DKL7qGLwGevCgv5L0Mf6SrlfP5AfK/kH8lOhWIyXKRZ6S2Xeg3P5Wuh+cX+M
NXv0Jd1nEOWJLO7JoFjkalTsh/7dQum8Egap1Q05dWGyPoYrVH4ijyq53/1I
Djrtr57OjyL9LYo1v6xTscitj+o3ivT/oPvax8Fe+zHEYCn6KIqg+SPUD2bq
z1HKzyTrL3KMyb4LJb1jUn+aUbFYF6hY5OOjWPSvN/kfl/WZvYn6Y5zmY789
ObsstXpc5p/vQfU5Ifvln57qeZLeC+TVHU3TrZPS737kTnxPrL8oT718X6xT
il21nH4rfpb1wal4mvTpKa8ZmWeqXub1fZZBI/qf1Ev9D/7SetTruKXHNVgn
fXh6Kp5770Q94nrte8yFgzUpc82CCcrXid6/YcWi3gcVi/saoPydSV8/A3SV
lInv4zjWa3of9YcLca+stzw39R7M6fkPA72pWw==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7dyd87z6wXyHH8GPl87WXuAA46+ViUr5bQPlX5vv
kDnxbc1/qwUODCBwYb6D9X3/3umWCxxM43Z58pyd76DK1jj1sMUCh3nvlx87
fXy+w5+VHy/5mkPlj8x3aD5wauFRU6j8wfkOQTvkWrVNIPI9++c73FUBGmC0
ACyevW++gw3Q/OsGCP7pha7bPush+CDze3UWOIjfPPf9MlB/VIr1/X6tBQ4v
1Qw51hyCul8Dav5RiH3Z6lD1J+Y7FNpyXV+sBpU/g+BvPVG2b/5FBB/kL+cb
8x3mAt3trYEIH1h4AQBBtp9f
      "], {{2042.668, 2099.507}, {
      2035.3239999999998`, 2090.9130000000005`}, {2034.48, 
      2090.9130000000005`}, {2037.09, 2099.507}}, CompressedData["
1:eJxllG1IU1EYx6e5ORJ8SVuDzfS6e3XLqUVKhKyd3KZby5AJEemHmEpvUgZG
bxJFSsU+VIR9KePYqBCEoEACk8KkD60MGiQS9sIIKSkJE4P60HPPeQ4n2GCM
3+45z/k//+d/rhI9GunKNBgMEfjqv1cnl532Akp+t6bu2poouXdzqrTHQsnt
xfsvYs2UnPxavumSjRLNdH7weQslxzyrZzpKJf/o89Z9KJNs0D8aX+do4XUS
5ZxTuyg5ft2adcPJOQ71n/TCHxsomVOhQJiSdbPTK4WVlIza93aOBzkngQ9e
+973tJGSaP6erbVuSl4NB8Ye+SSfPQSVvJJZP27JrvYrk3UuSoKfTxcdAT4A
9bwVqMvNz6sHnXcCY0ueKkq2XN6+r0vD84FzZuI9Eyrqrub9+lRev7eGkr8j
P9++dvBzljeiHmCwz+zenM7MF4US3f9b9nQW69kciiV/g/2jJZLfrLSmNIXr
/QLsj3XP/1Fwn8r9fleG/WvYP6yLPF4/UAn9ToD/U8iHwY/qh0OL88gLFVjP
wf0545Is/BXM9G+TnFsFhRowT8AJmNdSgBJwx9kOes6B/iTkzVYzpzYqOM8Q
+lmCPu/A+dgld8DzX1bJ+n7TWtQX5P7peWb9+SULvYL7n70cNkI/p2AgQeDd
ILgY8xAvwJyDP8nmaL51DSWDvlj3fo33Nw6cB/09UNHnQsyPiv0VoR8OzLdF
zkvnfms6i/mz/jLSWaxnnClZn5/fKJnl1YT9i7xm8/7bQP9Fy+z0CTPqFvcS
OeGULPz6/3mOR/IF8G+gAfOD698HsB+xvgn1mfG+wXx2QlA/gZ62zvqPeSH0
KxvnF8K8ov6FEObbhO8TmPcQ1A0bJbP9WZLZ/V2FOkPSPzZPzFdtBvoTxue5
8v0l8iH4H8UVP8w=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/Wflx0u9DgscTi103VasvcDhXY29qZwTgu/xsEok
z3mBwzTn7pznWgscgMKfa10WODRk7Sm5rLnAAazfdYGDKlvj1MMaCxxKJ0uw
iLktcNCM6T9Uqo7gB+2Qa32tiuCbdzompKoscLi+uMC2C6jf+r5/r7gyVJ8L
xDxmpQUO3iCFQPv5dDfNfa+wwGEn0BhBoPsKbbmuJytA7XdA8Ctfqhly2CP4
zy4o3d5pi9B//nvw46U2CPOjUqzv91sj7JfWv6vCZo1wH4wPcz+Mv0YmKqVa
HaF/3vvlx05rIMz/AaRuayLsB+vXQrgPFr7o4Q8A0zqxDQ==
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{153.266, 2313.698205}, {
     640.3439999999999, 2313.698205}, {675.8009999999999, 2313.698205}, {
     704.3439999999999, 2285.1552050000005`}, {704.3439999999999, 
     2249.698205}, {704.3439999999999, 2089.698205}, {704.3439999999999, 
     2054.245205}, {675.8009999999999, 2025.6982050000004`}, {
     640.3439999999999, 2025.6982050000004`}, {153.266, 
     2025.6982050000004`}, {117.809, 2025.6982050000004`}, {89.266, 
     2054.245205}, {89.266, 2089.698205}, {89.266, 2249.698205}, {89.266, 
     2285.1552050000005`}, {117.809, 2313.698205}, {153.266, 2313.698205}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}}, {CompressedData["
1:eJxllGlIVFEUxweh3SzbMCrRCFog/DTY8sETIVFhYSuJmohWQqh4r2FhkqiE
hEjFe7NUDLfwQ0RDiYoMucyiaR+shhaibEUiRKJFMmqqc989zzfNDAyP37vL
+Z9z/uelF1fsK02w2Wz78S+fGaNrZtbnMpCPpcMCDF7B4zizeVvR2KCAjqFT
vZ4kixc39D8QMzh0yvfIj1a//Flno/PIeSVb3+z9xSDLXuhrHhDgLF/U0D/F
IP1O1YnHIYsRL04ELZ73/EZlJCBgcDdG+kPn/QJwV23WHHW/1icgMLkuvzWR
w/r81sBkr4AtUmAyhzEppIfuS+GwCfW23RNQ4NuZmJDJ4ffNL+GWLgH35f15
1rqxv5KDTKupX4BN/mrp/kAMBy0G1DcconxPc5iL+s8O0DpX8eab9SvncChp
Y/s15K/hnOKFx6x6mnpi+b9+jMezuf9D25VQ2ivSg3xmiXfHuxGVTzbyZikg
qM4fRH1YTXthB4cyrOvfIN3n4eB2uVzLsd7Xs7u+RRqt+hh6dnE4jPpH26kf
nbTuESCXix5y+B55UvPJTfm950a/k520f0Llv8pB/ZvioG+/cHKtLqBpPLc7
dVa18pNG8VOqVT+iWIYpvUx+28Pj2Nxv1Dvf4jRptOMq3keN9FRwuIuvb+vE
1RzOL3sxkukg/9VwkO36HMWvsUxPnRbL+vW5iLG/jXIsrsb4y2PNk5H/LdL7
jE2vG/7x0zzieYf0Yxcz9PxwWSz9lBPF8r4CJ8XzMeNZ76B8/GqeenTSN0Tz
pZHfwyqeZvJbNl0vk836GvEOxLO5f6VM4CiDDTgfnRrNYxmDBVi/DJ30VTE1
Pzr5o44pvzmJLzHlRzfp9Vr1MXg2zb83Jv8e6q+Hqaefvk8tKp49RP45p/Rm
o/+7U9FxXMU/Yn6/Stj0PJnfR5P/AUZRc54=
      "], CompressedData["
1:eJxTTMoPSmViYGDQAWIQfczbvNMxoNwhnE93091HCx0yJr6tsQ8vd9CM6T9k
emGhg8FdFbZGVwSfAQScysHq6i8vdIhKsb7vb1vuYHPfv/f61YUO+iD15uUO
XNcXF9heX+gg3Hzg1ELdcofjQHsaby502HKibN98hXKHDUUZE3VvL3S4oHT7
Z50AVP0dKJ+h3EERqCDw7kIHkPMSXpdB3HcX6r6LCL4lyMByTD7Y/IUI/sMq
kXXucxY6yIIcXF3m8AxokeXMhQ5g/7eUObQAnck6A8qfUAZ2Z/y0hQ6Hv2rE
9C8qc/iz8uOl3qlQ+3ej8S9i8kHOTp0Mtf9wKQYfph4ULo63EPzJEixhfF8R
/E+XfJMEOMocFEAemgY1X7jMIQzo37kzoPqloP4H+scKZL5smUOH2M1z2+cg
+LDwgPFRw7MUzgfbsxnBB8fHvFIHYCz3Tr8Ljf9JEPfx3oXGbyOE73sH6r/i
UoetQOr+LWh4ZpQ6gJQdvbHQYXqeUPOBmFKHr3+vVKy8Bo2P0FJwOjp/Gao/
uBSe3sDudUTwwe71LIWnVwCBQFtE
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfczbvNNxSrlDOJ/uprtbFjrIRqVY359c7iDcfODU
wzULHUBc/8UQ/sJlCx0uKt3+WXeo3CEMqF520UIH7Xaxm+celjsobCjKmDh3
ocOhrxox/WwVDn9WfrzkO3uhw4w8oeYDBgh+tcg694c+CD7Y/NQKB5DxrnMW
OjCAQFWFg2ZM/yHTeQsdOhwTnl7oq3Cw6HRMUF2w0GGHXOvrwAUQ+dLFCx0u
gNyzDiq/YqHDItdtn//ugch/XQZVv63CYdZMIFi40CFj4tsa+8UVDs+AGncC
7bPccqJsX3OFw10VtsbQGQsdwOGRUuEA9N7c95MXOkwHud+mwoH7+uKCvROh
+nkRfLC/b5bD+SDtCWvLIeqmQP3fUQ7x38yFDp8u+SYJpJQ72JvG7fIE+s8K
ZH9guYMDkM+5FMEHqW9di+BrAf2zdRvUvynQ+NoLDa8uiP1/Dy10EAJpXF8O
phVPLHSI3eXJw3Qfqv8UVL1EBSrfA8HXBwVEfoVDBzBat5+A2tcH9e+RhQ4G
IPm1FQ6PqkTWHT+ACG8uoHztbgQflp4AjRMkQg==
      "], {{377.26599999999996`, 
      2268.12}, {389.688, 2268.12}, {389.582, 2269.8390000000004`}, {389.375, 
      2271.05}, {389.062, 2271.761}, {388.582, 2272.8550000000005`}, {
      387.85900000000004`, 2273.714}, {386.89099999999996`, 
      2274.3390000000004`}, {385.92199999999997`, 2274.964}, {
      384.90999999999997`, 2275.277}, {383.85900000000004`, 2275.277}, {
      382.234, 2275.277}, {380.78099999999995`, 2274.644}, {379.5, 
      2273.386}, {378.219, 2272.124}, {377.47299999999996`, 
      2270.3700000000003`}, {377.26599999999996`, 2268.12}}, CompressedData["
1:eJxlk11IFFEUxzejqJQirSRhYzM3KIjoQSpCOgVi0UMUWPSBViTYgxlFNneS
6GuRHqSW2NZZreEW+2BRZGil6Kw7rGZCH0QRUcuyRYWEhmxQUkude+dMF3Fh
ufO79845//M/Z5Yeqt9Zk+PxeDbjX6zb1l7adOAEg3W4RIc5uJwsmXkuZHE4
ZZlFq8MMuoYaLHOQg0f8etV9797DG1JpxVU9W/NyMorl+9N0yH1761j2KYfR
xo2lVXk6dByvDd4d4lCR1hfcK9Sh4EL/8MEnlN+ry3ypAcUinj8x+dy0OdQG
MeJiXeqtjHMIfNvxeMl8HTAcL+8nnq3Dl5fF79fHOJTNQSF/Gazcf9nuwvo+
RVsTvh+KZbwRxTfLH2ayHxh0Yr7qGOV/QecYf4vQH2ewD22Yh3ryReJHTNbb
Z1P+DsUy/x3FMl6UQcQwjD3IGK0ifYP8x3pOC77C4DPqn8D8Y8K/8855ZZ/q
l/S7W/F99HfUVNy06N3zn20cBsVGA5N+dEeo/kYGK7CeUoPOzzrx/C2kt4k5
+2Eu+8SDDP60j79qvsZh7qoH17+3MtiND8kQ6b3NpP+BEPXbmspCVs1Vquej
NoXd+2+0keVrfilObW8OH53FoO7r7/bxEPlb4Oh5hnrkfpFTf12Y7vsYZLKv
tSMt1J9ljp4Bg973M1lHfYTm2U/+tikW/pw0Fcv56pzMgR6qv4SBsK3MIi4m
PTFi1LNLJHTn0+v0l8VJXyGDi7jMsKk/+TQP7rznkt/ufE1XLPs1of1nMTZn
xjTwCQG28ld+j3HqZ1KT8RcmKH+1+n7/Aaw9+5s=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQrX9Xha1xcZWDVkz/oa3PFjpsOVG2b/4GBF+rXezm
ud1VDkLNB04pAvmLXLd9/nukyoH7+uKCv08WOjxeOvuIwrkqB5v7/r3XHy90
mJEHVHmpyiHn+e+VhY8Q/D8rP146+wDBn+bcnaN+H6E/c+Lbmv13EeaDnDX1
DsL+z3+vVGTeRrjvHlD+6q2FDjD3w/g75FpfB05D8CdLsITxdSP0W4EMaESY
/7bG3jSuAmG/JUi+GOE+GB/mfhgf5j+wfRUI/4Pd04gIn60g93Yhwo8BBKYh
whc9/AFGn9Pz
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfVHp9s+6U1UOFp2OCUtPLXSA8ZsPnFrYOh/B//L3
SoXmnIUOb2vsTePOVDlsKMqY+HbmQodj3uadjheqHP6s/Hjp7IyFDp8u+SYJ
XKlyyH3+e+XG6QsdtNvFbp67WeWw9UTZvvvTFjro31Vha3xY5QCiQoH81teB
O+ReVjk4mMbtOjkVyv8OtX8qVD13NQYfaGtC6uSFDnG7PHmYrKsw+DD1WiD7
/RF8sHtiIfyjQP4i122f/6ZA+K5A9+yQA7ogByo/DeqfoiqHWTOBYDrUv2VQ
eaB/34HCo6rKQTOm/9BXYHhcAIVXDYRvOgfBh4UnivwWBL8FKM+6a6HDZAmW
ML5qaHjshdpXAdW/H+oemP0HFoLDdT7QfcIggYMLHRhAIK/KIYxPd5PsoYUO
USnW9/0zIfy5QH61yDr3h0lVDuFA/l0gf0aeUPOBKAQfbH4Qgg8Ob/cqBwVQ
hB9ChC/39cUFfw9C3W8CiU/RIwsdrLYAHbQVkZ4AaRIsoQ==
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQfVHp9s86oRoHi07HhKWnFjro31VhawxG8IWaD5xa
2F7jEJVifb//+EKH2F2ePEzraxzMgfKpBxc6XADpv1DjsOVE2T75PQsdMia+
rbF/WOOguKEoQ3Abgs91fXGB7XoEHyg9MXfVQgcGELgBNX/pQgcDkP1HofYv
WOjQ+jpwh9zmGodnQIt2zl7ooN0udvPczBqH497mnYwzoO6thJhfOxWqPrLG
gRvI/ztpocNkCZYwPlMIf+9EqP28CP6hrxox/WeqUeVnVjuArPk+Bcovroa4
F2h/tcg694dB1Q7hfLqb7gLdNyMPGEJO1Q6aMf2Hvi5D8LWA/K1rEfytwPCZ
vwkaXj7VYPc3bof6P6HaIQxoXuweaHgD7QOHFzB8vUEB3VvtcA/ozatHoO5Z
Ww0OH9XjUP+drXZ4CjS48uRChw7HhKcX3lXD4w89fgHNSumY
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQDQYsNQ73VNgarx5b6KB/F8j4XA3ndzomPL3wqNqh
XezmOXMgH6z+UrUD9/XFBX+PLHSISrG+73+w2uG4t3nnwcMLHbRACjdXO8ya
CQQHoeatrHZoPnBqYeu+hQ6trwN3yM2vduDT3TQ3fzfUvFkQ88u3I/hhIAWb
EPw/Kz9eOrtqocPbGnvTuGXVDtFAe/mXLHTImAgU2V/tYA50aOq8hQ6fLvkm
CdyodsgEiu+fAXX/j2qHDUVAlVOh7lGsgfPB7rVH8MHqI2ocuID+q52+0OGC
0u2fdTk1EPfMWujweOnsIwoNNWD/750LdV9XDdi/kosRfK2Y/kNbVyH4YHdu
WeigALKosgbiPqD/Z+QJNR8A2qcJVG8KDK/DXzVi+p0g/K/A8N0hBwwxNUT8
oMcXAIc4ySk=
      "], CompressedData["
1:eJxlk21Ik1EUx4f0RplFWRSkmSmUvXzpxSyrs9HIENMCjcpoSYJ9MCMoKroX
wkYZhIisbWaNW0hIGCYaznJza84XKJb0QphIhUaUH0wirAade5+zLuIDDw8/
zr3n/M//nGdVScXB0jiTyWTBV37DuZlV5rsMtlWZbQ39AmI8lDbrisMn4MdA
XsnCIIO23vM+T1jApcRHez+O6vPO04squ+L5f046cnLHcJJmdX89h3nv7p+J
9gkoqxm7vDuTw+OzZTVNvQKe/1xTXG3hsLiyq/9ED9XP4arecLdmmS89NDXu
CQr43HA7lLKHK72FAQEm+WRzwHTC2kW8mcNoJHUwyy/Am2z/diCDQ0ZxdbAN
+zvWsS8+bqVmlS9R8wrZz2wOrVjvON7vkfV/MyOO+YNS/3cGR/HYAtTzKnVw
kn9iqt/OINX/oLld1n+rWfUTYVDndrsPI2+XhfrIf+wnS/JTBiOof9JP/jUZ
8cJOPS/lt1dzM/o75tF8ben7l7/qBWD19mTBlB/eOur/AYO12M8WN8UfGvnS
XeRXCzPyOAVIGfwZg7+N4wM3bwm4braNRMIMDiVsaBlykP43TPlvd5Der9MZ
s9lKa4nnT+fY+dplM4oSVmuW48jfxKD8y5/GcQf5u8vQ8wL1rJONWo3+y510
PpfBRPT1hVMu0r/fyNftpvsFDFD+nQr0wyX3uYD8rdcs/Tnn0az2q3Uq2zto
XvkM5uJ8d/rIjzzS46c46imSBWP7mWPM92KA9sfC4Crmm4n7cM/6ZCKaTfsQ
2/et5HdsvzZqVvuVplmOzbacQYoUENT+qv8xQH7MMfIvCVH9G/r//gc12fZR

      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQvfrjJd+kP1kO5p2OCanWCx28QYyLWQ4bijImvvVc
6CAblWJ9f3+Wg2ZM/6Gv/gsdqkXWuT/cl+XgYBq362TAQoe3NfamcUD+1hNl
++YHIvgg9aVBCD6Q3NUZstBBqPnAqYVHsxyigcbyhy10WAWy/0qWQwtQmDV8
oQPQFo2Yx1kOmRPf1vwH8mN3efIwfc9y4Lq+uKA2YqHDBJA8fzacDzZfDcEH
u98yG64fbL5HNtz8MD7dTXPDs+H2g82Lz3YAOysEwbcAGqMajODfVWFrDAX6
V92QY41MVLbDwypgQPhCw8c/24EbaP9fT2j4KGXDwxMAXjOg+Q==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQvW++lP7dG5kO5p2OCanWCx32g/hrMh0sgHxVr4UO
ra8Dd8gtzHTg1900V99vocOEQ181YmZnOvAB+e8DEHyw/iAEv/nAqYWtIQsd
3tbYm8YtynSITrG+zx+20GHVx0u+SRsyHVqA8qzhUPl9mQ6ZE9/W/AfyvUEG
Xcx04Lq+uKA2Asp/ieAX2gJZDFlwPgMIiGTB9feD7FfOgpsft8uTh8k4y8HB
NG4XJ9D+apF17g+tshyeXVC6vTMEwb+rwtYoGozgg9SfDFzoIBsFdDhU/0mg
/2+e+x78WBWq3guq/hci/AB3QpQr
      "], CompressedData["
1:eJxllGtIVFEQx7dAsYIKzcfmu9xSwdR0SVNzVMJoUVNTIWwTSSq691wLzDCD
FnugJdYHMS2RQ1lIUSFJIlEhvSGpsIcfNgnpQ0VGlNWHhOacO9eD+mFZfsyc
c2b+858bXW2U1Cy02WwF+BP/uVWfXq5arcPid5dqs0o5WPyv78fr1jQOB7Iw
spzNsMwrVNw2PBVbWc/Av+nB8+h0DhO9Fx5GnTHjBRs5pN9+eujeVQbRtw7u
fZXBweHrac+7w+CJa0OzZxOHAQz3DDEoX5rQvzOXzr+fzxXI3niVb/GRFTfy
P/bT++s4nBX1XGNmnUl0/jIDfP5cQjKHycZsp7uLQeZ4UWvFeg7nGZ5sYfAY
68lJ4XDia/FgRJ2Z/y2F7tvFIAPzO1I5jI38KZ3Ioniq0sdiS7+5nNacU9Ub
oXhqevRwXygHzGrMdujQ1dnZOWbnEIB98Dgd4irbhp12ei9Bhx27M8bbQijf
qQM43UOLkIUO3dl0fzCHJaLvrTqIazYHk15uHbwxvp7AYKq3UXGZOJ/CZsdr
Fd/vWZnovUh6IdeK+CDpjyx1G2XQnnda2xNC85hksv46O+X7GXAc6/EJtfoz
zPvDOawRfnAZsAzLSIyiuG7Gy2KIWxXLeSYZgK9W1QRQ/9/3z2M5/0AufcED
tRmW/ktULP2br5k6Ia9N9rse5tbM+4I45Ih5GRr8wnl9DiI9GzSIx/4GLL2O
aVLvR9h/g+j/pAYfsN43drqvRZN+XxCmWO5HpGLpT5fiU0FjI/VFVG+TJv1h
L6F+6jRTv1Lax2oNfmJ9+7YT51K8TPVvsaXPXJZ+LVf6zuJMQ/rLsYX2I1yx
rNffnN9NrP93LArjY4BY+8hCOv+X/FBE+/eFSf8+28ZBuNn91vxevCim/Lvm
/h7FfjvEfl5h0tfTJeR/D5v5XonvRLdL8X97QB99
      "], CompressedData["
1:eJxllGtIk1EYx4dYH8qEdHud0SKj68LKD3PmtvaIiYVQdCFBUiwSHGQ7b1hZ
CqE2uiFi0Z2Il7DwQ6KRFAPLIloGRkpiFiqzG1IrogtEST3nvM/pSHthvPz2
nMv//3/OeTN2BjdXJFgsli344+/Kllidvy8IR3qeGNPyDPhU53eVnWJx3LG3
siXTb8DKkYXT648qnluyyzN2mEFy5s3Ln9cYUOQ+nldey2DZ9uYH+5BLw+uT
Eg4wCOA+f3wG1FrbC6PVDPiwiimcg9zqVTyK2wx6aL+DDC5ewCeX6g3m+t9z
DFgXPWRtDzH4Ovm8JoBs4c8JBnzaGTfpayY92QY4OLcxaER/BVlUj6i6WP+l
qffeagNi3P8bBhlouN+juBP93/AqTsUFd6Cf162XHs4fZ/D22YJXP5H5/8aI
yiP0YdOdecMqL6Gn/788I/Es+yHyzdfjWI4frJlYnJWtC72z/eTHqUPX4/13
r8j+ZOhmvj7Sb9XBifq60I8Yl6CDOBe55Oejykdw2OzXohXkx6bD77YvA30O
A3wzhq6y5TqMY1si6bSfR4dtaLg0jfSsNcc3abT/Bh1m4rRumwHXcPmOEh14
WwttlE+A/E1hcX5SibtZHMvx4nz0Kq56/wt3ZhBBYfU26s8w1VHPuT0pjT2j
DM7mn9x9XSP9UTovaYpF/nbF4CoL99rJ3wsGx7Thp7fnqP7JfOR9Ev6XUL1Y
1YXeAmbmh/Nv8X54mchn0q6Y662awsIH6kvhbz+Db3gfJjTyV0D6NaoXMbPP
Npq/lcEjbkRyucpLssz3PM9nIBjHcnx39Wl74rsgeMc2NhUj8zZGfwRF3vdt
8nyRfo3WT6L7k0Z6HUzMH0ondql8xPlrMP2EnMo/r89yU3+XUh65lGe6yVEv
6Umm9Xx0XxKpX3g/VvEPRyz47z7J76Pkv/IzYXM=
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQnfv898qPPwodWg6cWsgasNABhe+40OFqxUs1Q78i
DH4zkN9qi1CPzteM6T/0VR7Bz5z4tua/zEKHY97mnY5/oHwpqDxTEUS95EIH
qy0nyvZxFjnw6W6a+15iocNFpds/64SKHDYUZUzMBfLL982X0pdF8BlAQA3B
vwBSr1fkcBxoz0Egf+nsIwobzKDyQPM7HBOeXrArcggDWiArBTXPtcgBZK28
9EIHj4dVIus8Ie4pBbrXluv64oJIBP/TJd8kgQAI31QS6n4nqH1iCyHuNoSa
LwqVVyhyaBe7ea5ceKFDVIr1fX/+IgeLTseEpUJQ+/8WwvmLXLd9/vsBwZ8s
wRLG97TQQRHoAUFhqHtuFjoAQzHhqTA0vM5CwnO/CFT90UKwfd9Foer3Fzr8
WfnxUq841H07Cx2EgBGmKAm1f3uhgwIogKQR/HCgwrtyCD4sfu1A5tVi8kHa
de2h4dNT6DDNuTvnOZAft8uTh2k21D5Y+lkFNd9poYP+XRW2RqB7QOE11wVq
3/FCB34gd70blH+50AGkTNQTygf6f9bMmTMjvaDx9bDQ4evfKxUrfaDx/QaR
ngHX5VZW
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQbct1fXHB+iKHeypsjVf1FzpkTHxbYw/kR6dY3+fX
XOhw3793et6eIodMoPh+5YUOOc9/r/x4rcjBvNMx4an8QgeFDUUZEz8WOTiY
xu3ilFnoABK+IFDsEManu0lWaqHD0tlHFDaYIPgXlG7/rPNB8MH2JRY7ALlz
3wP5uSDzi4od7gLdMxVo3qGvGjH9LcUOz4AaLeUWOoDdO7kYYp8ilD+/2KHl
wKmFrKoLHdwfVomsWw3lqyx0uFrxUs1wWbHDU6D+SqB7GUBgGsT8UOmFDuX7
5kvpV0PtE1/osEOu9XVgQrHDrJkzZ94UXugwPU+o+YBdsQM30Jq/gtDwEEPw
D4Pc96oIzl/kuu3z3yNFDltOlO2TF1no4AFyz1JIeKVKQP3fVuTw9e+VipUy
0PAsK3KY6tydk66E4IPCZ64mmrwhlA/UD/J2rTmUv6zIIRyo/q41lH8MIm/r
sNBhsgRLGN/7IgdQNOU6QcNLvhjOB/vHA8EHh08WxH97HaDh1wKJr1hbqPvn
Qf1viQhvcPiaIviw9AQASAsaKw==
      "], {{298.965, 2201.3550000000005`}, {
      309.527, 2201.3550000000005`}, {309.441, 2202.8230000000003`}, {309.27, 
      2203.8550000000005`}, {309.012, 2204.448}, {308.594, 
      2205.3740000000003`}, {307.97299999999996`, 2206.105}, {
      307.15200000000004`, 2206.636}, {306.328, 2207.167}, {305.469, 
      2207.4330000000004`}, {304.574, 2207.4330000000004`}, {303.199, 
      2207.4330000000004`}, {301.965, 2206.8940000000002`}, {300.871, 
      2205.8230000000003`}, {299.78499999999997`, 2204.761}, {
      299.15200000000004`, 2203.269}, {298.965, 
      2201.3550000000005`}}, CompressedData["
1:eJxlk1tIlFEQx9dsfUgqUjcvtaLRSw+yDyV7+WwdDcnqYekKRUZGhoaX8hvS
yogyEQsRXzSIkGNoLJRZqESgLVFYgl1EMYjaLKIgNpGwh3KrOecbOaULy+F3
Zr6Z/1xO5pGqXSVLbDZbPv3l+bHr2uOMQoR9K7LuFeUL+JedHgF9T08NdRxD
qPj8KzjjF0DX16cbFvh3a26vTKgP9Wk+m9SzdSqEMBecGRvNE/CtLjf70AjC
3erS1tsgwCZ/4wgZvXSRy/6vEcjrwTa/5nfr4y5M5PxvbzIE7HA35R2eQCgn
fSd9AiIy/nMrX7NXgOstfTiM0LblSvlNqqe0lTweImw42PIomzixPjQi+jWH
A83tlbc0K32dCB/OJPUMezh+G4KUG/GynssImXSxyuD6LiJ4SFaXwfY6zSpe
rearsl/VCAeOGuEAccPXnffTK9juY73F3A/Kp+awx6pvuVvPS+nZqFnZ0zVP
kf7GNQL65Ty3o3WmCkiQ9QcQZJv2pnD+3ajmXJUsoGaoI821H2El8Z3VApxS
aLHl7yDupvC9xxE+vVz35rSD51Fj6ckiXiv9GxezdCtJ5Hyj5iKe91f6wppV
/Ihpzd/B8/hhgnQrID2dBQPfo3Om6ucL4kJZeAzCbHS8NpjM/kt5n1LYbmc9
qWyPQyijvv9J06zm4dSs+uVaYN8kwL9s8sYJO++7m/XHMnv4/cRY+/LKy+/l
t6W3xcfz+mnCJfrMbvB+zppqD84b3L9pE+IpzeD8fn3RrObxXvNmqWfSBHmc
M3R/pT3qY35m9e9JDvfXrd/vX7gB22w=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ7f6wSmSdd6mDZkz/IdOohQ4djglPL4Qh+DvkWl8H
JpQ6dIjdPLc9cqHD1YqXaoYZpQ7c1xcX7I1Y6MAAAgWlDse9zTsPhi904NPd
NPd9camDwoaijIlhCD6IqxuK4D8CWns8GKH/rgpb49QghPlgfiDC/lkzgSAA
4b4woEGyQD7M/TD+BaXbP+scEPyc579XfjRD6Afz9RDmT5ZgCeNTR9hfvm++
lL4ywn0wPsz9MD7MfzD9MP/DzIeFz/Q8oeYDZojwA/vHARG+6OEPAJkkrh8=

      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQnfv898qPOaUOYXy6m2KdFjrA+Fox/Ye2yiL4s2bO
nHlTaqHDBaXbP+vySiHiEgsdPB5WiawrLHXgvr644K/4QodFrts+/y0pdfiz
8uMlXiAfaOzc95WlDjb3/XvDxRY6AKnpeQ2lDuFAibuiCx0mS7CE8bWXOkx1
7s5JB/LjdnnyME0uddhQlDFRF8i/WvFSzXAJJt+80zEhVRjqvk8lGHyY+ul5
Qs0HWBD6l80+orBBAKofyF8K4ouVOtxTYWu8CuQDhZ9ekCl1aD5waqGrGNR/
iqUOT0EeB/LL982X0lctddAEhs9Xcah6DShfAmq+VqnD1hNl++5LIfiw8ITx
QeHjq4/gcwHDz9ZkoYP+XaBDNEvB4ZZvDrVPHeLepxYLHaJSrO/7w+y3XOjw
ABSeSpD42GgFDV85SHzKWkPlpUodQN5ot4aGjwgkvvZaQ+OHF8E/9FUjpp8N
wVcEBdzfErD7aq0R4QuOb6B9diCJtyXg8Dpqs9DBFsSPRqQnAOY8HN0=
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQvXT2EYUNLWUOYXy6m2KdFjowgMAeBH+HXOvrwBdl
DtzXFxfstV/o4PGwSmQdZ7kDF5Bfa7XQ4WrFSzVDtXKH497mnYxmCx3u+/dO
zzMpdwgH6r9rgOD/WfnxEq82gt8udvPcd7WFDoe+asT065Q73FNha7yqtNAh
9/nvlR9lyh0sOh0TlsotdMiY+LbGnrfcQTOm/1Cp1EIHd5D938vA5vmKQ+2/
U+awoShjoq7oQodlIP8cgMjzCkP9swji/r+CUPUNCH5UivV9f08EH+w/2TKH
ZxeUbu8UWehQvm++lP7fUrD9pkD7tUEOf1gKca8c1LwrpQ4tB04tZFVB8JuB
/KOaCD4wOOa+14X6/06pw12gflEjqH/fQM0Hhp8iyCNA+2bNnDkzEhi+tqCA
Fi5z+Pz3SkWmLVS/XpmDOTB8UoHxoQBSD3T/lhNl++IdofGVhog/9PgFAKok
40g=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQfd+/d3peRZlDGJ/uJln7hQ7Hvc07HbMQ/E+XfJME
YsocrEEK7RY6AIXnvvctc/iz8uOlXtuFDpZbTpTtsy8D62u0WehwDKTfpMxh
Y1HGxLVWCx1sua4vLtCGqOe1WOhw+KtGTL9SmcMGoHyu6UKHqxUv1QzloPJG
CD5I/q0uqryv+kKHGXlCzQc0yhzuqrA1TlWEuse2zKH5wKmFR2UWOkyWYAnj
Cy5z0IzpP/RVfKFDzvPfKz/mQd0rCnXPRAQfaEuN/WoE/4LS7Z91B8octgK9
dV9soUP5vvlS+hch5rdKLnTQbhe7ee5hmQM/0F59Gaj7XpU5ZALN2a+A4IPs
N1VH8KNSgCGoDw2fOxD964H+B4f/AYh/QoHhpQjy+FqofbZQ/lREfKDHFwA7
DNLs
      "], CompressedData["
1:eJxllF9I01EUx1ekD0lm6uZWbGT4UiEGKfvzE3em+RAhUqBFaYzVyMBc9dC9
lRmhYUPE1KheIm4RsYf+UiFCIYIVgWXSXyLDQnyIVfbnQWzUufceuZmDbXzu
OTvne873/pYfiW2JLrTZbOX4lt8jq95Nt7xiUJtZeLu+XMC/7PYJuFR570fq
J4N9kzOJqTIBfZ6Tnzfn8rn5xYYx2uepMNzQnWwOVnP4nZgaHQ4JON+U3Tqw
jcOtgw3d10DAl+Zgyc4Ih5U38SBI+Xs44Gn/xjLDYwXpJ16Wzo3HLQH+O48P
PdjFoRH1HQgIOCfr1+l+nX4B7u27rQ81HM5WdDRexXlyWgeeiCoOq+u6BkuQ
bfK1wXA8FJ4YCRhOSn3rOHw8knv9kY/qF3CQcpN+0uPikI8HyyyaL4uDDwtd
sSieYVjVSzes9rWAg5RZjVz0HgedYTqO82RLvV+Z3gf2U3mfmJpvidf4pfSs
N6ziHsPjqL99Bfn5hsFdXNtFF80/xkC2rXFS/3EGaN+FWJ7QvkwyWIp8wyHg
4SZvPPRN59uRe52LajOnGUxgo8N2AQHpR5reT6Gd8h3zGT/D0Rzqt4PN49l8
pa/JsPL7qN5H3E5+tDGQa6pEPbJ8uIOpPT1D/j5aFck6zeBX6gVP5JE/PUzf
JyfFz1B/F9VD3ou+/VluWPnhNqz2VfRfvFjAmnbH26e9ev/DXtLfQ+yj5wf1
yPvy3E/+d2q9XQHy6xSDNpwnzaLf43zyHh23aH8tDDJeX95/f/Z+McPKj5jh
tVJPlMFi5GOW2a+MpwLEW/X+hkrJvyHzf/AXF7nSag==
      "], CompressedData["
1:eJxVk3tI01EUx9fzj4VGOM1WWyozNmMtWWvaHh6LXhT0QomYEdXKHlZImb9L
ZFGSEjIkQiwiTqHQH4ZEb9BqFZZQWCQhUcMgJEIiyj96DDr3d09e+sGPH597
zj3P7y9/+8GN8YkWiyVCr/wO1n+eV3xCwLS3Vw/1uBDuOhu/bKgT0JQz9PKO
E+Fc7uTKzB0C3rumnsy2I6TWtbQdWCHgA/FgDsKSm8/qej0CLrTTk4VgkY9V
xUvPQDjae9nuGzHGedWwsF3v0eyTgdsN+JF+U++xIXRefJLXLQw49bAfG3M5
XsyAW5QmNQehQ9rXGrCndfTYgwLNJc3l2wqLNMuwFcWcr4rjBxFWSm5Q/h0h
hPlnqFE0QLYxFxDo+NNAvwGVmd4bVUu5nl+aBwre/TzuFONs1hcW0F1b3eot
5343Cfhz7dvrF1GEe3Kee5W9JoxA1y59PSLAE0skx0o1BylxPKjZ7GcxwuMx
dyxRK1R9AbbvU/uoWIQQtdIg4wK27AylEn7eX4zr8XP96zVfWX77exo0m/UG
uN5/7FWcEeD7bgF9a4LNjwI8z0IBIRLCTKrX1I+L/Ut5fgXKfwLNd6Es1CGg
mvbVEGZ/m1D7jbC/lTnK/aUNOE08pYz7G9VcM/KbMmnOl42QniCw9f7zCPt3
8f4pf4aM16Y4u4T7azHgI7XR59ds7meBZlOfboQiqQ+6P53i+Fxs7+L8eQiv
pB6Shqn/odkIEZk/pfT7dBb3M0n8zw7Nci5lNP8sOhi2s3210pfDgZCU+9+s
7Ej/Y5Oc1y4B55ed3b87n/V+mPVViPAXQI26bA==
      "], CompressedData["
1:eJxFlGtIVEEUxzeJIisF3fWxqekakpItbq2bj3XPBmJSIQYZRlpEkUJqCJXN
mCEa1gcpP9lWImMYSKQWPUTKrHykgalkImG6lZVEhGmF1UIzd846C8u9v3vn
nnP+/zNnog6X7Dnqo9PpcvlfXD80X+uJrKYQe+DSs5+hDO69ONXVmE/hqsvl
yg1icP5rdkdEBoWq7kGWrmcQKG7sFOL4+vuBDArqvpU7zFR77g5goBO/SBnv
JOew/UdSpvwVD5veLlb8Iku8w030rW4C4lLD4+20XXQeGiFwp7Sg7raBQVP6
g3lPN4HUqaza8WAGVN+a4e4g4B9/t6HNqFjEs0Yo9uPvSyKRHxHI4Q/yTMg9
BFaP3zjhicb6XhHw5WyPYXClOKCq+z2R+jeiXg+ByQ0rKvfGoT8hVPImBmni
w3QK/bzwp5sZeP0U+RoSFLdzPUVbFNcETQz9tjHg7lnzK2Q8QwrWVyr97k1F
P45RmOHGnUlD/3IwvwO/B8UZwkiz4ums2vpiE8ZLU/Vv42Gb7QymxHs/qvXx
nDffKgpFn/+2JKQoFn49TsL6fSns4/omExVHcYHZVgZ5nZlrfFZS4C4ORm1F
PToK/1rmRndz/Tf58vY/0u+zFgYjQs8P6a/Bgnq+KNb0vlOs1fuGaH5XWjD/
MPaXxxe2fx/AfvL8ROTvIzDveV1WaFUsZM0kKi7k+p8kYT2jRPPpIPcjXOyP
WbLkn+bHMgoLPF6sk8FY2WxMgkn2O2871r9LsSiv/bhibV5qqNy/Tqz/OvYL
GCSJxLco8CidmQ5c/5DKebBj/7qo9I/3xy5unkt/1yZjvb1UW7feplibV4ti
zZ9oxdr8RqDffXJ/2sJwPvpx/ToGp7sajeYBCn3CCCP68VKeF65Q1D+E5wVn
sxA2QmVfQvA8GcP96OUJxZreScViH85NY30h6NdH6Wc4j58shM5K/bWhWP8C
fm/EepaXSw5T7D3vtP58kvO1yM83sa+cg+hvANbXpljL36RY61c9+h+I7y/L
eY/X4369gPNhQK6W8+YIVueBt57/J4aXnQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/Xjp7CMKLdUOmjH9h0xlFzrA+HdV2Bqn6kH5MdUO
s2YCgc5Ch6sVL9UMnaodcp//XmmovdDhbY29aZxZtUMYn+6mWK2FDt7mnY4J
itUO05y7c55rLHR4B5IXqnbYcqJsX7w6VJ6z2qH5wKmFR1Wh+hmqHfh1N83V
V1noIBuVYn3/d5VDDtD8QiUE/8/Kj5d6FRB8kPnqcgsd9EEOZax2+PL3SoWm
zEKHapF17g95oO6XgpovUe3QArSPVXKhgwFIQrXagev64gJbCai8CYK/DOjd
DR4IfsZEoIrkageQs59KIsIHFl4ABamM2Q==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ/emSb5LAvBoHzZj+Q6ZRCx1gfC0gf6ssgj9r5syZ
N6UWOrg/rBJZNx+i/qvEQofJEixhfItrHFoOnFrICuS/rbE3jVsGUS8pvtDB
luv64oLVNQ7mnY4JqWILHXbKtb4O3AThPxVd6BCVYn3ff2eNw+e/Vyoygfyr
FS/VDI/VOGwoypioKwo1/yYmH2yeMNR9aph8mHqga90fmiH4YPudoOqB/B0g
vkeNwz0VtsarQP59/97peX41Ds1A/7gC3Vu+b76UfnCNw9MLSrd/AvmHvmrE
9IdB/S8OtS8KER5a7WI3z0XXOGw9UbbvvhSCDwtPGN8CaL+qO4IPDLVdnj4L
HapB7gWal/P898pCf6h/I2scwvh0N80NgLonvMbhz8qPl84GQsMrBCofBHVP
AESeNxjK96lxAEVDbTA0PNyg7gmG+scBwVcABZQlgr9s9hGFDQY1DiDj84NR
w/tpEDT+5CH+WRoCle9BpCcARmENPA==
      "], CompressedData["
1:eJxFkm1Ik1EUx5eVH8qs1KnZNjfbQKO5Qp/mmtOzoiAiwkI/5AtDMg16ow8V
4b0RKigVQyKyIuoUEn0JEcsQLEvLEgyRYknZSKkvUdDLPhQNuvc+p+4D4/Lb
Offc/zn/42o8srspxWKxhMRPnpsGnh9/GOCwNHbr6LAbwbZ3XzDu49CZPfNy
0IEgw9dtHGbdqWeseQgW9XF4L/h1NoJM3zXP4Mpl8WUiOPuOtXSPMlUvuRKh
53BG28gNzS3dX1orT2i+kLuoJn0Pg5/JVyeLshCe7fB3hUsZtI1MYEcugkvW
szK4J3TEbRRPZXBA1HlUoLmsKxzxrNUs9VZvoPdyqL6fOGDm9wYRZHqklqk+
8wFBRI2GdgY16d7++s1Ub0Dz9+mdjSveaFb6Egzk4Q0jXJL9pnH4c+fb9GQF
gl0OaA1X8UPlCD4pTMy3qC76JBHQLGU0+TWrfjYizPdeHXOu46Y+A2G9jHtM
P6pLEeqHtqel5HPlQ7SE3rOa73kFj0v9SzSPJgrror/Zf1Z6vzJT7z/+ZPIy
g+7PMXU+Nmh+cQbC9fM5Qq/an1nKD9D83pn5C4Lkb4ype6fLKX+S/A1R/hhx
BfU/yKBd8OJK6u+25qmCt7/4Oc0dn6seOMQ+gdEw9CJE+c3kf5DqVZlsLaP+
tjGYO5V1d7xEs/KnWLPaz0LaD3F/ubf/ms9N8f30vpP2odXc/5nVCDe33v+R
7DH7ebqK/BrWrPTENHeGIx+nxPwzxR8f8ii+kKv9stvJ/wyu4uigeTk5XNxy
9mCzi/azmPbLg/AX84ut+w==
      "], CompressedData["
1:eJxlkm1IU1Ecxtd6gd5WrtXmnEtXi0qGFIxtrW1/+9IbEvVh4TApMVBo9gJZ
RJ6D2CgLGya9rDI5hYVgvpUUDlTEsgaFGRXhJApSokJW9CEq6Jx7zvVkXrhc
fvfe8z/P85wnu/jgrv1ajUazid7seWD8V3OqFcOpvgSZnUdA5aDO0bnHLtn7
bketMYvAQkdnw0Qbht30+6iFgI5xB4aOI6V1dzME38MwuN1VU2UmUG+aFdQ9
wLCIvm9LJ+Cb9+bWoTiGNYXRfidlz/0nFT29GMrqvp7sNRGoydv7cWgAQzXV
E6F8+9pAVntCclH31gXal5IfWiOfdyYx/G5ODT+j3MT+HxP66fxXxz+tWveF
c4ORwLGeRnMuxjCfyviTJjg8nVU/OaeXvX2ej6Gdctgo/DmFXgMBP/Njx+Cm
wpuWEAizvAwYbkzceXxOTyB3dOWcqpn/zU+hSVb0JiUr6xMIWiyhkrhe7BdH
PC+D+N6CeJ5LCbywjfxENxGwbS4axbzrCFwsSOr/DMvzEoKxIduIRz2vesTz
Wz6VH62QzPzY3ZJDJbQBGwh8G84vXnwB8by9BGgtLpefRzzfjQSulOur+84i
pTeHfQRKaU6BCOL98Yt5lXx9LeX+H6sLoxVI6cuMAOH7lCFgsbsC4vyCSMnf
8Q+rfVX49XRmx1Jpm8o+q9CfFPoyRJ/Huf5Ms+jjdwQfThhaB2mfNOzS8v5k
qn3US1bmWyUrfc/Bio+oSfTdw/t+NF3stxnD1VgsVmAWfSjAkE0Npllk/5Q8
rZKV9W7J4CzqnutV8+L8lOa/5T0Vvg/DWvp/l0/oC2HoorYa/aIv24TegPCz
Hk/mq7Ka51+i1OXo
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQXflSzZDDucFBM6b/kGnUQgcYXwvI3yqL4M+aOXPm
TamFDksKbLmuQ9V/lVjo4MXDpN3u2uDQcuDUQlYgv3zffCl9d4h6SfGFDvKt
rwN3eDY4mHc6JqSKLXQAadPwhfCfii500N009/3ygAaHz3+vVGQC+Vl7SiZL
hDc4bCjKmKgL5HuCzE/A5IPNE4a6jx2TD1MPdO3iAn4EH2y/KFQ9jC/R4HBP
ha3xKpD/fvkxb3PpBodmoH9cge61ue/fO122weHpBaXbP4H8h1Ui69zlof4X
h9qniAiPac7dOc+B/K0nyvbdl0LwYeEJ41sA7Vd1R/DtTeN2efosdLADuRfI
z3n+e2WhP9S/Cg0OYXzAkApY6GANcg/Q/j8rP146GwgNLzmofBDUPTIQed5g
KF+qwQFkbG0wNDzEoe4JhvpHBMEXjLDcckIAwb/smyQQwdPgADI+Pxg1vJ8C
7dMBxR8zxD9LQ6DyVoj0BAChBP36
      "], CompressedData["
1:eJxlkmtIk1EYx1dQdIFqa7pN55qaZaGUkDhbc4/1oQ8VQh+6iEWIwQS7GQVG
xjksMTEZQrdVFgcxGaw0SYqClG5bgWH2QUREUpZExKjYh+hCz7m8nMzBePfb
e855/8/v/WdXH9t9eL7JZNqKX37NqqzxTqZROD/4hi0oZ2DwnmWFfQfyNHsn
K9psbgY7S1rKD6VT2Iv3J5wMdnC2UbhfH2i/m6nYTiGGP2gGA1zWkXRQWI7X
HgeD6a4bL9xOCuuqQs+KkafOWO9td1Gobf9ydsDOAHcnht0UgpinCfnqUUtw
MFfzlW2tdTNrNT9P5VeFCij8inwdGUK+xtcXqfx4/nDO+I9zmyR32BiY+OcP
gaWjncd/mxWn5rIxDx+/IkGgF/mITc0/RmReq5rnHQEP/t21UvmKE7iV7H7V
amGAY6byB/87/6FmkTeqWezvJBB1VtY8sSifN4n0ZVX3LxHpM41BAertDhGY
WL2QXrap8y4S4NsSDuWzhcBHFFFqvK8LRPpbNZtf5mrm8+R5NAsPmxn4lmDQ
ZiJ9exn0x08/vd1EpN8tDMz7Sh/EgwTqZn5GTvgYNHxaU7SIEtmfMuWvUe5v
Q76D+nobiOjLPD+DbyO7qlecJNCcPva2BHkjH6xW+i/8h42+Co7MZR6zMWc2
+1wqf1Tly1R5+mT+LOzrB97HR0T0MoZ9wnT1gQF13+hjTLM4f0iz6Pt76Stk
V/0Yl+/vlEM9b4rA9XA4vD9D9eEzgWx8jNmp+yd8ujSL/R7NUHzw8WKv8vVd
8mv0H8Be+pME1uP6fvS/gefD88V7KlN9mVZ5/WqeUe3XYMPnX/MOwvE=
      
      "], CompressedData["
1:eJxllGtIlFEQhpegoMJMV80LeKuljESzttW8zdaP6CouWZqblJdKotSolLDo
YJJLiRhUrmJ2Kreii2IZ0g8RKYmgMisiokTCIEKki0SQ0Jzve5dDtLDsPpyZ
OTPvzJy44gpX2QyLxZLHX/Xra3sU290naNu8xJ6dayT5+eOiWeJNiqTvI5uL
5/doPh327vmv24KWupsGex2SHvyYfl3jE3Rq4KmcmS5pcGqJu+mSoDrmxxmS
ouu/5vZdEJRtL3royUL8s4K6D+1rPpAtKXPO26uVJzVX93dEJlVr7lT2FYJ2
lKaPvmB/TrN9slzQB87nfCbsSwW1er3eAr5P2eXsFjSXw06v1qyuOZ6m2aoS
dOD+EkHE+c1ehfv2or6Vkq5VssV+xF8hafL60EbHYUE/uewvyyV5nLvGhzl/
B/8pS0Z+7dBrGfz7zPybEiQVqvuHBH0ejn+fZtNs2MdoDuQ4XVGSLOozIChj
NKdxezjyvSfoz81vI89CJQWo+1h/G8ux1or7W1B/kKQsZe/RXN48UZt9QnOy
ErIK+gRDzxIwx7t4MLhuoEhQHDfkpRXnhfC3Ip98za94XPLzNBv5uVC/3z8X
+gZD7w3/s+Efr+39bNS3FXpEYz7d0C8S87dHUALHOxKO8yqzfxFh6FetOV8T
IWCPZmO+z2k26ms1/b2hyOeyGX8qDP3xmfXlhCO/G/CP0Gz0K0ozWzcuiMY+
dGJ/YhG/A/MdJ6lF6c/9TOVEbQvhf0bQ/SdH+2Ns8K8x961+MfpdhvlMQH35
Zv+CeB4bFLugZyLON5n7MJYEXi9o7FjI3XUpmlU9ifZ/eSIV/d0ijLkNzED+
Bcif9zVJ/SmB/k7sQ6V+bwx7odnQu0HzJzUQzYLGeV9+O7G/bab+difOr2B+
CPPjQ/9J6+1no1+3NPeyjh38nsWqggj13UG/CPPTZXKAE+9dN+yd+n305/sX
93txmQ==
      "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQLRuVYn3fvcnBvNMxIdV6ocPjpbOPKNg2OWwoypj4
1nOhw4w8oeYDFk0OmjH9h776L3S4oHT7Zx2Q72Aat+tkwEIHb5BGIH/ribJ9
8wMRfJD60iAE3x6ovjNkoUPFvvlS+lZNDtFAa/nDFjqA7Qfa13Lg1ELW8IUQ
cxybHDInvq35D+R78jBpt7s1OXBdX1xQGwGV90HwfUDmByH4YPeHI/TLgMyP
QpgPkt4Qh7AfbF5Ck0MzUP5oCIJvATRWNRjBv6vC1hgK9C/IOP/4JoeHVSLr
3H2h4RPT5MANtP8vMLwMQAoDEeEJAEe1nw0=
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQb/Gx3MOx0TUq0XOoD5XxodLIB8Va+FDp8u+SYJ
fGx04NfdNFffb6HDlhNl++a/b3TgA/LfByD4YP1BCH7zgVMLW0MWOviAJID6
o1Os7/OHLXSQjQIygOa3AOVZwxc6eIPkfzQ6ZE58W/MfyH+8dPYRhb+NDlzX
FxfURkD5zE1wPtheDgRfMMJyywneJrj+rSD7BZvg5nvxMGm3izY5OJjG7eIE
2q9/V4WtUbzJ4dkFpds7QxB8ECUajOCD1J8MXOgwI0+o+QBU/0mg/0H22AtB
1XtB1bM3wcMPAHMWkhw=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}}, {{1, 4, 3}, {1,
       3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 
      1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}}, {CompressedData["
1:eJxTTMoPSmViYGDQAmIQzX19cYHtrHSHlgOnFrKuWuBw3Nu80/FHKpw/I0+o
+cC6VIcwPt1NsfMXONz5WZe1Z06qA0jf3jkLHCy3nCjbNznVoRmo/ugsBF8z
pv9Q6UwEH6h9bv6MBQ7FGRPf1sxOdXhYJbKuffoCBzW2xqnOq6HmTVvgUC2y
zv3hrlSHdrGb575Phdp3B8IvB/Jvg/gCaQ5cIHcj8YGuTkidDFW/JwWDD1P/
TQPosJcpEPuA/CqQfWypDsJADyQC7T8G8r9IqsOGooyJukD3qYLcp5/q8Aio
8DjQ/SDn2/tCwwfof7C5ealg+54uWAA21/YVxH21N6DybOmo/LoMhz8rP17y
Barvmw4M4DkZEPNnL3BgAIEdGQ429/17r8+A+u9CBkQ/0D0g5yW8zHCY5tyd
ow50r2xUivV97kyHqUB++lRo/Flkwv0L48PCA+z/3nQMPkz9LZB9O9Ih8Q0L
r6vpDiBrzsPC+0m6w10VYMBMg7r3S7rDrJkzZ0YC3WcFiu/f6eD4dZ+B4IPN
m4ngKwID+CIwvSxy3fb574d0B2AqO6U4Fyp/Ox0ePgB7A0YX
      "], {{
      188.13299999999998`, 2134.8550000000005`}, {182.39800000000002`, 
      2148.4950000000003`}, {176.523, 2134.8550000000005`}}, CompressedData["
1:eJxTTMoPSmViYGCQBGIQbbXlRNk+6SyHPys/XuKdu8Dh9s+6rD0mCP43jZj+
Q55ZDse9zTsb5yxwmJEn1HwgKsthQ1HGxNzZCxzA+rOzHML4dDfFzlrgcAyo
zrEkyyE6xfo+/0wEv/nAqYWt0xH8zIlva/5PXeBQnAFkAPXnPv+9cuOUBQ7c
1xcX2EZBzJs7eYHDvvlS+nc9shzsTeN2dU5a4MAAAkD3gdT9nQi1XxrB7z/0
VSOGGcG/qAT00btMuH6QdfZ3M+Hmy0YBHXo6E26/KlvjVOfDmXD3wfgw98P4
d1XYGkVnIvQDfZWQOgthviYw2EpnI+wH65+DcB8sfNHDHwBJbcLY
      "], CompressedData["
1:eJxllH8sVWEYx+/MalJaxNIiTKU/zPqDmqYeSc2kVi2WycyPVds95z2lopJm
ZmaRJC5JXtIf0pAuMyukxFR+/8hMpjJrZc2alZXV857zuGfL3e7OPve+5/nx
/T7P6x7LjiVYGQyGCPyK53Dyl607/BRYNfpAufaeg8r7FdiVFRiz5SWx33/s
pcD2qNz2i10cDOLjpECm01hP0lsOt9rnvaL+Mqg7fybPu5dDdHPIaqtWBn+q
5gbWDHKonhsIizUysMV8i0MccsX5lTo/v5C/wTpVtvChnZjYUYYJzxVpBf3E
7yRIb+su7+jmECo4TwLwjW626aB4iZJan2+LzuJ8cKPOkfG7J3trOQTGTPd5
ZEpqvbNVHK6urzk4VSNBuJ13fWklhyuCRyS1/rAyDvvEeVsZCoJuGE+XcHAR
gUJl7f0iDjdNsn16tqzpUUjxemRV34ACYntm4QGP8YVUf51byzb6TMRoeuUg
j/X8PP4pg/QspPzVDNzxh/5Cqr+XQScK8cJE5+dIzyKdVX8f6+yAgkxh/+JZ
PsvgbnFxsXM96TvNNL+fEk8wWIty+Jg5nAvASH0MMOv4gpn8Rn9FmIwG8q+G
qX45ot6JKEtKLlP1PNVIesUtZ7X/Jg5JLShAurKMl86rfFlnUUZqvM5Nrhlf
j4YrINJex3oelrxyqzusaPOC/Yh0R0IU2IvzklVP/x/Q3nep03lJryX+gP0M
m2jevSge+uNv7rrUYqPAazGIdzhsEglGNf/C8mke7mn6nrxNfkcyiMB8E3nk
xzqdsfom10DZwg0YvqyC5hv9nk3Byv0kELYk3OdQEdz4Y/GzEeYXh5KrKmm/
nhmhEOdzplpntT+zzuo+NtM8DRrhLOrV2krzZ6D96aD5x3zC/9o3VF+apOXr
I/8mJW1ehmgefWSt3lGal2zZcr88Evl/6Sz6LN3MLKzuZxCDKZF4ieNIH4x3
QpxPZ9p+jdL+P2GAruaYRqi/bzRPw6SPtaLGy8T6jDO/q+bsFG2fkEW47w46
4/SG2znrvEcEcqH7DVkS77spmn4YX5SX66loe4Qs7G7bqsBHzNeJ9Yj2lW36
/foPdJWhng==
      "], CompressedData["
1:eJxFlFtIlFEQxxexHrpYVJYEXQyLFEQkxELN2QepKBGjDEMrpEAh9ZyiUjFD
QsQHEW+tu146akqGmW7eXXfV8oKEiFgmJZsP0p0ys5C0OpdZjyAfv/3ON/Of
/8wc74TU01fcDAZDLP8Xz+OzGdua0in4xhUMLJoZvEz7eCDwDAWL2WyOvceg
rvz53uZQCnf7RqsjShjcst/fGXCIgh8/31bMIM94aW7ch8JWfmC2iIF387XE
Qk8V7wbno+umaskazT8mIhM2fyGrnFj4NTN8ioCQkcvjXX3/p2F+iEALD/O4
lMHA4sG4gnYCoc6o/CkTA/4wpTQR2ORvrXxi0SziBVVp9uDvUxmDd4KtBGL4
D/E1yN0E1nNZK7Wob5CAeITVM+jcnfM5+jVR9T/EehcIzPiszT77CP3xoIob
GVzoPrHBLYTC8MngvP4mBi4/Rb7KFs3CluSnmnO3T4/97mBS57frKp5nD+pP
VH4P2hgkCz/iKMyN73uTbkf/TmF+B34fpFn6uV+zQfx5YTy71n+YN66uF9+7
U/ndHRv6/5fIvIE9moVfvV0Mjgn9/wic44ln2jWLvke3Yb+WCWzhCb1bsZ5f
BJYb5icief1D3Cfjd+X3bSvW80H562nFemY0y/eTmqXeF0T6nW1FPwexvzx+
gDjowH668tsILKxMpiW1aQ4Wg9uuOYnX7+jCfCMEWkdu2i9yP8JEICdZ9U/6
wev5yeP59jM4Ig7uUP2OH0D9Rs1CpzFBs9yXTKrmtx/1F2K/+hicvxzijKqm
EB7EJ8uB5xup2ode7F8rVf7x/tREtC+sdFLp78Zu1NtDpf49HZrlvlo1S39q
Ncv9rcL6bWo+gytwP3rxfDkDUwrvrJ2qPlpwPvvUfWE2Y/3P8L7gXOzlHuMx
TNXvZQzqxX0yivNYhvfLmGZZ74RmPvZLWa9QXxn6Na383GVGv5yq/nwz6v+E
31tQzxJyhWbXfSfreKv2a4nfb36icAf6W4T6HmiW827SLPPno//FqC9H7bt/
Cc5rFlX7UYqcofYt3KTvA5ee/+upu6w=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7fGwSmRdZaGDZkz/IdO5Cxxg/LsqbI1T10H5gYUO
s2YCwZoFDpZbTpTtMy90yH3+e6Xh6gUOfLqb5r7XLnQIAzJiVy1wyAGKfxQr
dJjm3J3zfMUCB16QPHuhA0hb/HKo/L8Ch+YDpxYeXQrV/7XAgR9I6y9Z4GDL
dX1xwccCsLrCRQj+n5UfL/UuQPBB5qvPW+AwWYIljO97gcOXv1cqNOcscHjg
3zs9jwnq/llQ83kLHVqA9rHOhKqXLnQAGWM7AyqvieAf8zbvdLRD8DsdE55e
iCh0MAcxZiLCBxZeAJ9zmuc=
      "], CompressedData["
1:eJxlk39IU1EUx1dhQT9Mo6KCwklIETYKhrHSnYqoiJCC+iMyQhQKTO08KIt+
ssKGDKmY04nthViMKFcpzj1dy34SlFOSKEkpGBFRYRAkJXXuvUdu5WC893nn
vHO/53vOsxdX7CydbLPZNtBfXA99+BkeOYOwOz33TlGPCX/z4qgJ+dNfNVeG
UD2PmxAon+NJxHV+mXg+pNkewQMXP2ve8u743FujCL/CI/3P75twNB5a5Jhi
wG1Ku5kwwbt+fyo504As8d49zs80wO3cF9sa1zy0dOrZga5/417LhIGqjzmr
0g2p43CM608z5Hm+ThOiS85/2mEzoG5jTdl16udb//bijB8Iy/fW9jiJhwt9
gfIvmkn8CXdKs9T3BuE9HfskyvV7EWSbVH+z0PMAZd+ZFscthDX0YovFets1
y3oRzbLvGwh7StYOFxKTbU1fWzgeY71BVH7Qea62p0fiPuXnrA49L6nnrmYZ
v6JZyKhu5Hl6ENqpTKiB+7+A8Jb83VXP59egvFYETLCJ3yWE2cStdSZca3yY
FQmq/HnEDnHTjJBKZg8e8/M8IkpPrp/zExM5j/orvcznpU3k8Xypb4FmWT9H
+eH1s98OBE/i2dVNpGdF9fzXL5zKz17ivuzB0VMuhO9jL6vCAc7PR7VP1G9S
xAv4/AaOuxEO0h78DmqW82jSLP1q/S/eZsLjbVSpgPe9g/WvY6b9qRffj0vt
S18nzz9P6a2N8bxWI5yjftIsfn8lyr08bbF/yxBm0Bi7x/fLrlnOY6FmqScD
QYz9pKX9FfGxGPMk5d+jLva3Un+/fwAHqQAS
      "], CompressedData["
1:eJxdkmtIVFEQx69WBj0sLHtAmoVRBpt+sTSJRixCIipDiXAXkSSLXnROGhFJ
mJBJLIs9dDdt1lywPoi5rutjd10Xyx4UIkWJmFhEQfTByg+hC51z7sSBLiz3
/nbmzPnP/GdD6bmCsljDMHaJn3zv7HpeEbJyWPz+4flgK0LSseM5k0c43Fg1
9sbfjCDDD4DDRGrctUQngiGfVA4fBb+7iyDTDy7k4GwUTz1CSseFcsdXpupF
HQj3ziZUh4c0lzt+XNnt0ly/Zn5RfCWD39G3l9JuIzzbv6M29yiD6vBLd00D
1ctm4BM6Ju8jDMv4VgYnRZ2BFs1Ztbklmx5rlnoLn9B9OVTfT2w18z39CDK9
pIqpPteHEUQ009bGoCje0mmNkJ4Pmn+OHihdPqdZ6VvLQb4sgwgNst8MDnOP
pkdfhxDWyQHtM+NnAgjpUpiYb1qxPTLTq1nKKPNrVv10I3z2uIZSDnFTn4/i
+aYfhV0Itr78JbF5XPlg95J/2aTHS/q3aY7MbCm2J2tWehNI7z9eZPJSH52P
42qugz6a3zwOwvVbq4VetT8xlN9L8zPM/Jh+8neWqXNVAcqfJn+DlP+NOET9
jTO4LnjBAPX3SvPIxvE/Vzs013w/3JMs9gkybX0vgpRfR/6L+zPkx0WTE3uo
v1MMPl1e2T7s1az8ades9rON9kOcX2bpbEpvpfhNuh9pH5Cp/R9zIbTs7f4V
DZj9PG2kfqb+41nNovqXETH/FeKPKSfFN3O1X0lN5P92M+5upnnt4XAnr+70
CTftewHtlwfhL/9qyII=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfd+/d3qeQKlDGJ/upthDCxxgfK2Y/kNb5yL4s2bO
nHlz1gKHT5d8kwSESh1yn/9e+XHGAgc7ruuLC0RLHbiB1N/pCyDiEqUOf1Z+
vMQL5AONnftettTBBmhQ+DSoeSqlDuFAibtTFzhMlmAJ49MudZjq3J2TDuTH
7vLkYTIvddhQlDFRF8i/WvFSzdADk2/e6ZiQOnmBQw7IvmklGHyY+hl5Qs0H
ViD4S2cfUdiwBaoeyF8G4u8qcbinwtZ4FcgHCj+9cKDEofnAqYWuQPd6PKwS
WXe0xOHpBaXbP4H88n3zpfRPljhoAsPn63So+jNQ/gyo+edKHLaeKNt3fxaC
DwtPGB8UPr7rEXxQMNpuWeBgcBfokLMl4HDL3w617zTEvU93LHCISrG+7w+z
fyc0PI+VgMN9464FDg9A/EMl4PiU3Q2V31fiAPJG+25o/OwoAcfX3t3Q+NmI
4B/+qhHTvwrBVwAF3EKI+2p3I8IXHN9A+2xBEhMh4XV0D5T/vwSengDmTTLf

      "], {{339.65200000000004`, 2156.308}, {332.309, 2147.714}, {331.465, 
      2147.714}, {334.074, 2156.308}}, CompressedData["
1:eJxFlHtIlEEUxTcJg0qLyoqgfBChhpiEGJV4hSQlxAy0DHsgBQqpEcykkYmU
mZaou5quz9FNSynT9YWv1bXM8I8yKURETEQiItRKQspoHnedheXjt9/sveec
uTOeCalnrjoZDIY4/hXP5C9/GpdOUPCJLxhaNjMI3jhhue5OodxsNsc9ZuDi
Z61a2EDh7uBobVgxg5mo/NKUfwR8+foOE4Mf45EJWxcJbOcLZo0MckMvz499
JrIe4dxQ8dqjZUzz+SvHZqK6NH/wmlq5U0dg9taO5hxe71Pa1wMBRgKtNxKL
XpQwOJizc/JdFoHjvPFEKYNwsTCdwBau62W5ZlEvsFqzK3+fypAzCMTyHy7U
IWcT2MRtrlpQXyEBYTu4gYFHC29sIcr/M/RrIzC93zkrpgnzmUR+zuDNqaDc
UGcKI/xpb2bgyFP0q2rVLMomt2kWtn53Mbhpq9njH0JlPbdeBieFvsMq7+E+
zMObwvyY11S6DfPbpdbHDOD/12keE3kukjVOLPp+O2SOqHo2rf8I36j6fnz/
nshnpqPfKJE6A3o1i7z6u1E/57Pc33SnZk9uMLqDga8wNkJgG2/o2Y552wn8
bVwaj+T+/YWwXpV3hhX9tCm9blb006hZvq/RLPWWEpl3lhX7F+L+8vplKbxz
Hu5nO+aZQ+Dn6se0pA7NQWJQOzUn8boD3djPRKD9LbVd6sP5aNL5yTyGCPzi
9XzsDC72RGx2msP+Q6jfha7xISHcT7M8L+FUza8d9cfj/g0yGFr2ji+4RiEk
kFcewPVpVJ2Hfty/TKry68X5u0dlvi49DOqF3vtU6nfv0izPq1WzzMeiWZ7f
avSfo+YzqBL9P8D1FQwM4pNHVd9yzOORui/MZvRfgPcF5+592d+ijVSex4Uy
pp4lON8ONmuWfqs1HxVGalFfGeb1ROW5l9d/JfJqUv7zzai/A/9fjnqGkSs1
O+47OY9P1fla4febaff6WNeHmK8R779UzbJ/gma5X+cwfxO+P63Ou18xzmsE
VeejBDmM4hzr+8Ch5z+BicMn
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQnfv898qPLmUOmjH9h0znLnCA8e+qsDVOXQfly5Q5
zJoJBGsWOMTt8uRhYi4DixuuXuBQvm++lP73UocwPt1NsasWOFyteKlm+KjU
YZpzd87zFVD5y6UOW06U7YtfDpU/VerQfODUwqNLofIHSx34dTfN1V+ywGHp
7CMKG/aUOuQAzS9chOD/WfnxUu8CBB9kvvq8BQ475VpfBx4qdfjy90qF5pwF
Dh4Pq0TWnS2FuH8W1PybpQ4tQPtYZy5w2AFS/6zUgev64gLbGVD5rwi+Pkgj
Zxmc/+mSb5KASpmDeadjwtOZiPCBhRcA6MyiHQ==
      "], {{366.555, 2135.027}, {
      379.42999999999995`, 2135.027}, {379.42999999999995`, 2131.261}, {
      366.555, 2131.261}}, CompressedData["
1:eJxTTMoPSmViYGAwAmIQvWz2EYUNDRUOLQdOLWTdvMABxg/j090UOx+VLzt7
gcN9/97peS0VDu1iN8+Vz1jgABSe+767wmFDUcbE3OkLHD5d8k0SmAaR/z51
gUNUivV9/6UVDlzXFxfYAvkeD6tE1u1E8MHmncPkm3c6JqROXuCQ8/z3yo/P
yjH4MPXl++ZL6f9G8K9WvFQzFEKYd/irRky/UoXDl79XKjSnQc3XgfoX6H4F
kMMNKxyige7knwnVb1LhcNzbvLNxNoIPCw8Ynxto/t9TCD7YvvMLHA6B7DOo
cNh6omzf/YsLHGxBEpoQ/zy9tMBhsgRLGJ98hcOsmTNnRl5Z4OAOCg/+Coe7
KmyNolcR/oHxYf5F54Oc/fbaAodcEH9NBZwPJGvs7yL44PBnrnT4s/LjJd9r
UPPlIXxemH3WlQ6KQA0XLy9wmJEn1HwgqNLh2QWl2zsvQuM3tdKhGRheR89B
3V9ZCTb3/Glo+miCmn8CwQeHxxEEHxRee/dB00dJpcMxYPg67oL6Jwyi/+w2
qH2WlQ42wIgKB6ZHULBdEKgEh//cjdDwul0B5y8FmX8OwQeH/4EKiPs3QsN/
Y4WDZkz/oa9APiheHRdB+KabFjgwgMCkCrB/+jch0jssPwAArL2MHg==
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvWz2EYUNDRUO4Xy6m+5uXeDQ4Zjw9EJfhcPDKpF1
7UB+VIr1ff/ZEL47kH+14qWa4bIKhzCgelkgv3zffCn9jRUOuc9/r/y4ZYHD
RaXbP+t2Qc3bAlV/CMHXbhe7ee4ugu8BMvgrRL/hNiifsxIivwPKl610+LPy
46Xe3Qsc3EF89UqHlgOnFrLuR/CbgXzXwwg+v+6mufrHFjh0gvyjVOlgDmKc
gLpXEsJPPQ1Vz1/p8OXvlYqXZ6HuZap0cDCN23Xy/AIHcPh8qIDYdxGq/34F
xL5LCxwyJr6tsT9dATEfyIeEA4Jvy3V9ccFyBJ8BBKZVONxVYWuceglqPjD8
NWP6D30Fmg8ABazF1Q==
      "], CompressedData["
1:eJxFlAlIVVEQhh8WQmUapRFBltGigoiQWJQ5ElJhIgYZhVaIgYJLCJX3tCES
YmTi1vM+l46KllGmL5fcnvowEzMVy2wzMzKTEjGTshQ6yzyPIJfv3XNn/vln
5rhFJR49a2cwGE6wf/48NEacq9IJeERkWud0CkPJkzt8ogmYdF0/cZtCeUHn
luojBFLbe0qCcilctNzZ6H2AgCc7X5dDIT3wzPjALgLr2IGxbApu1UkxWdtl
vPOM968cLjvnovjnYEjUmgVtiWOypi4HTGjAZaSxeHET/ypnXmtQw8I8zKNg
nXOPyOzSYN9oaMawkQJ7GBMsGjh5mYsemRTzeL7Fih3Z+0RK4RNnqwbh7IfI
UuQeDVYxWYtlqG9IA/7wr6DwxPX697Bvmqz/Hta7jMDINvuUY/fRH1fkBxRO
NR12sAsm8CzYL72jioLNT56vqEYxtyX+seK09W/7fjdQoXM6VcZzaUb9ydLv
py0U4rkfcQTGB7a+1yzoXwTmb8PvgxQLP30VG/ifO8azKP27WePKW/G9MxHf
XWtB/x2JyOvTrJj71dpI4SDX70TgOEs8Uq+Y9z2sDvvlQGAtS+hWi/XYE1io
nBkMYfV3MZ8CDUT4fcWM9fzRZP1mrGdKsXj/RbHQ+0ETfqeY0c8h7C+L780P
9mM/bfl7NZhdfJUcW6fYjw9uveJYVn9bI+Z7o0Ft9wXLaeaHPw80rS35J/xg
9fxi8Tw6KOzhB3fKfkdaUX+YYq4zMEmx2JebRM5vB+ovwX61UzgZvXc0tIZA
gC+brDY830LkPrRi/zrRP9af0qD62cVu6e/qJtT7nAj9mxsUi301Kxb+lCkW
+1uM9ffK+fQrxP14gecLKBgTWGf7iOyjCedzQN4Xuo71v8T7gnHOhuXhjsNE
/p5PoYLfJ+9wHvPxfvmoWNT7WTEb+/mrX1FfPvo1Kf3cpKNf07L+DB31/8Xv
TahnxSXJhYpt952o44fcr3l2v3nywvvR32zUV6tYzPtdxSJ/Efqfg/ry5L57
5eK83sL9yEO+IfctwKjuA5ue/zSXuWg=
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7fGwSmRdZ5WDZkz/IdO5Cxxg/LsqbI1T10H5iVUO
s2YCwZoFDpZbTpTtc69yyH3+e6Xh6gUOfLqb5r63rnIIAzJiVy1wyAGKf1Sr
cpjm3J3zfMUCB16QvHiVA0hb/HKoPF+VQ/OBUwuPLoXqZ61y4AfS+ksWONhy
XV9cwFgFVle4CMH/s/Ljpd4FCD7IfPV5CxwmS7CE8bFXOXz5e6VCc84Chwf+
vdPzhKDunwU1X7bKoQVoH+tMqHrtKgeQMbYzoPKWCP4xb/NORz8Ev9Mx4emF
jCoHcxBjJiJ8YOEFAA7JluE=
      "], CompressedData["
1:eJxlk21IU2EUx0dQ9EKllQVRsklEEiJ+sKSonQyxLJWC+hAZIQkGptWHss7t
DQsZISYyNxvLW1ExobRUnLu2lmRFoU1LIqRGgUSFhYEfolad53mOPZWDce/v
nnPP8z//c66juGJ7yRSbzZZNf3E98P57YOwCws45aXeKekz4m5cGTVg38+XV
gy2onodN8JTPq4r06/wy8fyzZkfr4dK6uOZNb48vuDXDgB+BscG++yYcDTct
Tp9vwG1KuxkxwbVh70h0iQF28d49zncY4MzcE9oc1vxm2bQzQ93/xl2WCUOV
H5ZnJBtSx6EQ11+kzqvpMiGYfO7TtgQDGjaeL7tB/XwdzC9OmG5A6u7ankzi
WGGNp/wn/uHSulHDOa5Z6vuI8I6OfRTk+jEEIXeU6ucKPc9R9p1ocfwpQha9
eM1ivb2aZb2IZtm3hbBr39pYITHZ5v/SwfEQ621G5Qedt6b98ZGwH2V/szv1
vKSeNs0yfkmzkFHt43nWI3RQmaZG7t+L8Jr83eHl830orxUeE2zidwVhLnFL
gwnXfQ/src0qP4k4Xdy0IYxEU4aPuXkeEaUnzc350cm8mvorqefzkibzRL7U
t0KzrL9K+eFys99OhKrIk8s5pGdl9cJX/TnKz2fEAynD307mIYzHX1QGPJyf
j2qfqN+oiBfw+Y0cL0TYT3vw66JmOQ+/ZulXy3/xdhMebqFKBcr/vk7Wv5WZ
9scrvp88tS8DXTz/XKW3NsTzykY4S/1Mtfj99Sj38pTF/mUhzKIx3p3YrwzN
ch6pmqUeO4IY+wlL+yvi8RBzovKvt5v9Pa2/39+FCwSG
      "], CompressedData["
1:eJxlk21Ik1EUx0eUH4rU7IUilFZCb5hFSKUfOkskKqIXyjDWepAEA8vqQ1Tc
pwgLGxEyRDcL62ZFLLBVWm571lqCLYKVG4VE78LoQxhZ9CFy1Ln3HruVg738
nnN27//8//faq+u31oyz2Wxr8C2+k3Nf/TjewaAyu+jOrl4Of3N+kENHxb1v
mRiDfR9/+oejHIIFpz9tea/7+0W/zfzDWA0W5Giu9Qyx1bNNGPEPpxIPOXj3
5zXECk24fajW0xnjgNUS1xIT5tzCBw+of7kJ+DS8Lqr5bWHWyReRf+tui8Oq
7seHo8Um1KG+g2EOPrH+ArXfuRCH/J17yt7ZTWgtP1t3HeeZ2hB7cnmWCQud
Tb0lyDbxytV8xmGk+7M0S30jDAaPTbsZD9L6XxgIuUMh0pNmYMcHUyya7zWD
lW6Hcc2i+oDmz2K9lGbpV4KBkLkJufgNDhqnOs6TJ/RaTPmB+8m+AJPzTe7R
eUk9XZpl/aLmD6i/8QLleZXBXbTtUhvNf4OB2Ha7j8NS8aOTAcbXXu/lKpcu
BjnIgVYOjzascDsiqn86cvPM8ZXZfQzSeBCOtnAoFXkklZ4i5LjoHxzL+GnU
NNO888fyaL/UV6pZ5r1W+eFuoTw2MxA2VaAesbyxQ/n5DPlramN1rpPB98zz
I34v5eNi6jz5qG7Q/m20HvJezO3Xec0yj3bN0q/Af/VuDosaZ7x8ulv5n+gh
/S7iIN0fpzovyRDlX6X0NoXpPm1jcArnmWDR/3E+cY5OWOTfegaTBq4cuD96
vso1yzzKNC8WepYxmIhsWtpfUc+Eiecp//oilJ9H3+/fff3yCw==
      "], CompressedData["
1:eJxFlFtIlEEUxxcffOgKphGVlSKBhaQPZjfxRIiJRSmZaalhGhqoJWlmzoRI
WYGFt9Zdb5OLkmGmm7vmbb1lhQ+hYYiIqIREhYVZhJjQXM42C8vu75v5zpz/
/5wzXkmZUSkuBoMhln/F76eGqte7tlDwvfBo8LeJge1djqPuJwGzyWSKfczg
zrfIVzumCBT2jzwJLWewSfwZI7CH77eVMUgtWcgPGSLy+VwpA4P4tBMZL5uz
Z1zy4RmL5jHvqWX6QPPxuTz3lmwC4qeIx4sIun/0YgqBtqzUkucVDOpD7Uur
ZwgcmTlVPGFkcMu9JWzuBIGNftaaF2bNIl5greYNfD2TIZ8mcJY/iK9HPkdg
7YTl6qoF87tEYA3n4EYGxgy3wv4c1P8U9ZYQmPZxLYh+xqBd+NOM3MwgWLw4
SeAtT3yghYHTT3FeTZvmVq4n/aXmos2T7/90MPieHxKY4EZlPI9uBnkiP1cq
/R7uQT9WCMyPek/ddKB/X/H8PgYL4v1xzWHCyCHN3DZjhl3Vb9ih8z/Awzb0
MpgV6/VE1vG287waAumfV5oCujULv3o7Mf9aAjFc37RdsxcXGGljkNAVvs6l
igB3ccSrHf0uJ/C3afHDSa5fbG99qPwmVgajQs9dla+HFfXka5Z6szTLfK8o
vwuseH4y1pfHF7b/iMd6Os+PI7C0Op6bZtMsZM3bNadx/X2dmM9lIn1K7MH+
INo/6UcFgV88nu8Ag4+5X3YH2PH8Qcx/VnOj0Gug/1nOyzaq+ncA8/dX9Y/u
Z3BQHBxCgUfpCu/D/RFUzUMvzmcUVf51Y//FUOnv+i7MN5bK/Hd2aJbzatUs
/bFolvNbi37Hqf4Mqsb187i/isENR93WffEU3ggjzOhHIpXzYjJhPyep/g3l
7C+EpVBVl0q8T9Kwv52crlnqvaZZ9OHidcyvEv3KVX568viHhFCi9BebsH73
8H0z1qMSuVqz876T9cmjcr6W+f0mdSWgv6WY3zHN8vz9mmW99qL/Zbjuo+bd
rxznbztV81GBzOdf6jTq+8CZzz+5WLk1
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/Xjp7CMKEnUOmjH9h0znLnCA8e+qsDVOXQflf6h1
mDUTCNYscLha8VLN8FqtQ+7z3ysNVy9weFdjbxp3qtYhjE93U+yqBQ7e5p2O
CVtrHaY5d+c8X7HA4S1Iflmtw5YTZfvil0Pl59Y6NB84tfDoUqj8lFoHft1N
c/WXLHCQiUqxvt9f65ADNL9wEYL/Z+XHS70LEHyQ+erzFjgYgB1a6/Dl75UK
zTkLHKpF1rk/XFALcf8sqPlrah1agPaxzlzgoA+S2FnrwHV9cYHtDKj8CQQf
5N0NdxD8jIlAFd9rHUDOfjoTET6w8AIAPqScfw==
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQvUOu9XXgtnqH5gOnFrbOWOBw3793et6SegfNmP5D
ptMWOEyWYAnjm1zvYG8at6tzygKHT5d8kwSaoOonQ+UL6x2Oe5t3Nk5a4LB0
9hGFDXH1DtzXFxf8nQiV90bwy/fNl9JXRvDf1gBNZqh3UNxQlCEINP/wV42Y
/kd1DlxAeVuge6pF1rk/PFLnMNW5Oyd9DtT+bXVg+w4uRPD/rPx4yXcFgm8D
9Mj1dQscDoHMO1bncE+FrfHqlgUOCkB7Jj6vA7vfdRdUnqPeQQvo3637ofYZ
1TuAlOUegsqnIfhg/7Uh+FEp1vf9F9Y7WHQ6JqgeXOAAC8+7QPum7kPwwf49
huDnPv+90vAMVP/WegdzoP7U81D+Zqj+C1D+xnoHB2D4n7y4wOExyAHr6h3C
+HQ3zb20wEG7XezmuZX1YP/zXl7gIAzy2NJ6cPjVXoaG7wKo/y5Dw2cWgg+O
j8lo8l31DiDj8y9D/V8Hcd/TS1D3VEL8u/QKVP0zaHq5BeX/wOSD3bMUwRcC
ulNxATR9/Kx3CAdaeHcOlP+73mEjMHzXzoby/0LT16wFDll7SiZLMDQ48APd
t37mAodHVcAIY2qA2Afke/IwabezNDhkTnxbs38GVD17Azx9V75UM+TgQvBB
6WQ6L4J/Bei8CKEGcHieBfIfgsyXaACHdyzMfCkIf+50aPicQKRnlPgG8gHp
5p4m
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvUOu9XXgtnqHlgOnFrLOWeAA4zcD+a2bFzh0OiY8
vbAFwj+6dYHDp0u+SQIb6h0UNxRlXNwO5a+od9hYlDFx7U4of0G9w5+VHy/1
7l7gYMd1fXHB1HoHzZj+Q1/3QM3vqHcwBxm8d4EDkLdDrrreYdbMmTNv7oPK
59U73FVhawzdv8BBu13s5rlEBP+Bf+/0PC8EXxjkMFOo+4H6o1Ks7/srQ8xP
3Q01n7vegU9309z3QPdOlmAJ4/tfB9b3cBOCD3Km7RoE/2GVyLr2pQscls0+
orCBC2reAqj/lOod7gHtvwoMLwVgOEy0hISP68wFDkIgRnA92Lza6VD/FCD4
90Hu70DwtUD+m1/vkDnxbc3/GYjwh8UHAMODzKQ=
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQfdk3SSCiocEhjE93U+yhBQ4MIDAHwY/tP/RVY1OD
A/f1xQV79y9wWFxgy3X9UIMDF5Bfu2uBQ9aekskSFxscjnubdzJuW+Dwfvkx
b/MbDQ7hQP13NyD4f1Z+vMS7GsFvF7t57vuyBQ4Pq0TWuV9pcLinwtZ4ddEC
h22f/16pONPgYNHpmLB03gKHrSfK9s0/0uCgGdN/qHTWAoclIPt3QszznQ61
f02Dw4aijIm6Uxc4XAH5Zx7UvslQ//RD3P93IlR9HYKvs2nu++VJCD7YfJ8G
h2cXlG7vnLLAwea+f+90G4j9pkD7pzp35zzXg7p3HtQ8jQaHlgOnFrIuQfCb
gfyjKxF8YHDMfb8W6n+dBoe7QP2im6D+NYGaDww/wQjLLSeA9s2aOXNmJDB8
5VpfB+5wb3AAKcvcC9Uf2uBgDgyfVGB8CIDUA92/BRhO8QcXOMSA4qsQEX/o
8QsA9U7xfg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ/WH5MW/zqgaHMD7dTbL7Fzg8Xjr7iEIxgl/5Us2Q
I6fBwfq+f+/0fQsc2sVunvue0uDwZ+XHS717FzjIRqVY349tcDjubd7ZuAeq
P6LBYWNRxsS1uxY4yLW+DtwRDFHPu2OBw8MqkXXu/g0OG4DyuVsXOGTtKZks
4QuV34Tgg+TfrkWV912+wMHHvNMxIajB4a4KW+PUhVD3xDQ4NB84tfDonAUO
njxM2u3pDQ6aMf2Hvk5f4LD9898rFaVQ906FuqcNwd9yomzf/MkIfubEtzX2
8xoctgLF709bAPH3Moj5rTMXOEx17s55vq7BgV9301z9OVD3bW4A69u/AMEH
2W+6HMEHBZP/emj4rIHoXw/0Pzj850H8EwoML8EIyy0npkDt2wvldyDiAz2+
APgf43w=
      "], CompressedData["
1:eJxFlGtIVEEUx80PEZVlTyIIMyK0kvCDbFHikYgQkTCotNTEDFfJXMxKxR6T
1SYivl13fU1uakpZrq7ma3W1UopCrJAQC02zt4+UkBI6c+9Z5sNy+d25e87/
/5854x6VcPSss5OTUyj+xNPLUjZVY2fgGZbdM2/kUHgw89xkPQOT0WgMLeIg
XnuYGaR3v7h7qIDD062PE7XlDHbigjWfw1TN80CNgcE6/GA0j8P+j0eyDNlq
vYvIASudd+n1ks063+VDqZKRzDodg9HU9fV6rCeeh7UMGhK1uQ8LOcR1JOVv
imRwAOsOGTikfN3hvSyMwWoU/sgkWdTzKZe8CtcTOHEEg+P4IrySOIrBCmy7
aCZ9MQyEDN9qDvqN71//0ZH/++T3KoOR7UvZsToORSKfTOIHHE5Fo+NKBn2B
mgx7PQdHnqJfWYNkrJIb3yhZ6dPCwTVkX1O/Ta23oZ30tap5P+ugPBoZTAxs
G06xUX511L+Lwxrx/wrJSp4GyRn+kRMDOVTPJvXvxYWqTg53xPptBtrcn2nX
HP1uMoif/Fvr3S5Z5NXZSvqRT6C/kWbJ7mgw2Er7lc5gLTZ0byI/1xn8q50Z
DEL/IpapNDXvKxYO94SfZPJvIT8XJCt+z0tW9MapeTPk3aJ/DO0v1u+d9wjL
jqb9dPQ/w+D34tvkWKtkjQimWXIs+u9qJT14/pr6L9lOd9D5SJL5KXmgnzms
52nnUF2CJySH+veQ/irJil+rZGVeeun82im/V7Rf3RxahNB3DPx8ItoCuuj7
YZqHTprPD5Qf7s9Jcf5G1Xxd2kjvmKrfrUWyMq8WyUo+ZsnK/JZT3mPq+dSU
0von+r6Ew2VbxeY94wxQVYa/ifKYUOfFaKTz/JnuC+Q3QVGuIV/UeZwq5hAu
7pNvlGcx3S8/JE8Lv78kzw5igWnSV0x5zah5bsH6zSKvOdV/lpH2b4H+b6L9
WHJD5VLJjvvORRScVedrAe83t1vfg5+MU755pG9IstJ/QLLS/yXln0/nsU+d
d68Cmr9emo9CYrs6b34GeR849PwHY2C+Vw==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQrbtp7vvlBxsdNGP6D5nOXeAA499VYWucug7KX9vo
MGsmEKxZ4LBs9hGFDQsaHXKf/15puHqBg0CE5ZYTsxodwvh0N8WuWuDwsEpk
nfuERodpzt05z1cscBAEyXc0Omw5UbYvfjlUvqXRofnAqYVHl0Ll6xsd+IEW
6S9Z4ODFw6TdXtvokAM0v3ARgv9n5cdLvQsQfJD56vMWOFz2TRKIaGh0+PL3
SoXmnAUOlS/VDDnaoO6fBTW/u9GhBWgf68wFDldA6ic1OnBdX1xgOwMqPxPB
5wN5eDGC/375MW/zjY0O5p2OCU9nIsIHFl4A+kKaiQ==
      "], CompressedData["
1:eJxllG1Ik1EUx5dgSNmbtKCwfMmiF4b1ISpSPBIiYiZIpYmFDKUFZWFlL5TS
tdEsdUptuol4Q1b5IZljY2vLtcRIgkqkCAmTiD70IaLAD0FS597nXO6HDcbD
j+fe8/zP//zvzbGeq2pMMZlMVfgXz6++gcnsEgY76pwToQiHwmUfh8/XMtjX
UVy/5TkHR3H9t+kmBsdWWgInJjic7v1xvYhpxm0L2zo1P8Ry/vsMlmOZ8Rcc
NtY2HJgfYCDK3khwuPp96+60YYMLsX5/U0Z74jGDVZbAYP44B5P4PWEwl7f0
5tEosZ+B1+PxHEd9u8SLMQZ/R37NVIQ0+5ttvZYxzbKfQc1CxjsvB1TXbAsY
9Wb7OdhEP0EGn3HZhz4OKOPnoxCTff5z0/cjDArmK7uq3bQ+xqAa+51zcZjO
/fSnNc7AdfDumVPIZekpO29Pkh7kQ3vRyDfJLB6N9zhI/y8ks1qfKYS3aC4X
C9s0f7m2drTUzqSuNuTQVEt8yEHzc5PfndS/m/rvZtCeeP3gJfbbJ/x3MriF
nOrhcl1lj/He7qF6PcY8zAOalb+KpX6/5qI9J6MdQcpTtzGvrjD1d8fQf/Yp
hzU1+4NTdppnjPxspXw8I78vapbvGzTL/UdIX5Tql1B/Ic1Kr2KpE/PQIfKN
7Fg3+zas8lBq5HcR/fk9U2FdXcbgFRq/BDko9pUb/ZW5aT6HKT8uql9Ffrgo
3zV6XtJvazKr+cv+0pJZrZecrlnWN2uWec2k/l3UTxaD7eKgol48rXXOXMqH
6jePvufVrPxSLNb7RjULH7KCpH+zUf9SmJjq+yKkL4fOG877cnxoQ342g4XF
91dG1Lw20fxilFfSb49RvtfTfRKj+8SsWe7P0CzP7wq6b2LaPznPKN0HqeSP
ylOBvr9UPhT/BwOsbIg=
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQffirRkx/bLND84FTC1tnLHDYeqJs3/yQZgfNmP5D
ptMWOPDpbpr73rvZwd40blfnlAUOtlzXFxc4Q9VPXuDAC5K3anY47m3e2Thp
gcOMPKHmA4bNDtxAZX8nQvWrI/gMICCC4Fvf9++dztTsoLihKEMQaP7S2UcU
NnxucgBZYwt0z5ICoI1PmhymOnfnpM9Z4GAHkrjbBLbv4EIE/8/Kj5d8VyD4
NkBzr69b4LAMZN7TJod7KmyNV7cscKjYN19K/1sT2P2uu6D2sTU7aAH9u3U/
1D7pZgegcybmHoLqN0Xwwf5zRfA/XfJNEghudrDodExQPbjAARaed4H2Td2H
4IP9ewzBz33+e6XhGah+IN8cqD/1PJQfA9V/AcqPbnZwAIb/yYsLHLZ//nul
IrLZIQwUsJcWOESlAEMwvBnsf97LCxzeLz/mbR7aDA6/2svQ8A2C+u8yNP78
EXxwfPigybs3g+Mt/zLU/44Q9z29BHWPPcS/S69Aw7sUml5uQfXXYfLB7lmK
4AND8ZTiAmj6AfLDgRbenQNNL/XNDhuB4bt2NpTfAE1fsxY4XFC6/bOuqdmB
Hyi+fibUfS1Q+2ZCzWtrdsic+LZmPzD9GIACshORvsH29yD4YP9PQPDB8TsF
Ep5nZ0DTxyxIeMfOhLpnDjT8p0Pl0xDpGSW+gXwAMmWgGA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQffirRkx/bLNDy4FTC1nnLHCA8ZuB/NbNCxw6HROe
XoiB8I9uXeBgy3V9cUFUs4PihqKMi9uh/LBmh41FGRPX7oTyg5od/qz8eKl3
9wKHx0tnH1HwbXbQjOk/9HXPAodDIPPdmh3MQQbvXeDQLnbz3Hf7ZodZM2fO
vLkPar9ls8NdFbbG0P0LHKJSrO/7GyP4W06U7ZuvjuC/X37M21wW6n6g/k+X
fJMERCDmp+6Gms/e7MCnu2nue6B7wTRjs4Mw0EMPNyH4IGfbrkHwH1aJrGtf
usBhep5Q8wF2qHkLoP4Tbna4B7T/KjC8yvfNl9KXh4SP60yoe3Qg5tVOh/rX
CsEHu98NwY8G+Q8YXpkT39b8n4EIf1h8AACE1cv3
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxTTMoPSmViYGAwAWIQ3emY8PSCVpHDXRW2RlG1BQ6fLvkmCVgUOXBfX1yw
V3WBg3a72M1znEUO5kCFqcILHKJSrO/7pxdg8LmA6m1FFzhogdRXI/hbT5Tt
mz8Jwc99/nvlx0UFDl/+XqnQFFvgALZ/TYFDy4FTC1klFjjslGt9HbipAOIe
yQUOkyVYwvi2FjjYm8bt6pRG8MH2yyP4IPf+9ULwQfYY+i9w8AYp3FjgcA9o
3tVAqP9WQfQ/DVrgoLChKGPi/AKHWTNnzowMWeDweOnsIwoToPaHIvwD48P8
i84HGfM2DGp+TCEGH6Ye7B77QoctwHCRB/LL982X0tcudHAA+u9kCNQ98lD1
IVD9IoUQ/wZD3cdT6NAMDK/WIKj72AsdNGP6D5UC/ScEkmCGqg+AmsdYCPbf
TV8EHxwengg+LDxhfAsgf6nMAgf3h1Ui64DmZU58W7NfCuoejkIHLaB9WyWh
7ucuhMSfJFReoNDhONCjjcD4PPRVI6ZfDBIeuhJQ9bKFDjb3/Xuviy9w4NPd
NPe9YaHDRqD8WnFoeghB8HeA0kMNgg9Oj0sR/GqRde4PDxU6/Fn58RKvBNT9
lyH8s0D+1YqXaoZPCiHiQPfZghLiZ2j8SEHjj7HIIRzokLtA/wJt2yHHX+Sg
CFRwUQ6aXmUg6f+pItR9SPkFAG/DaMU=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQvfVE2b75i4oc7qmwNV7VX+DwwL93eh6QH51ifZ9f
c4GDUPOBUwvXFzlkTnxbs195gcPjpbOPKJwqcjDvdEx4Kr/AYXoeUMWTIgcH
07hdnDILHBhAgKXYIYxPd5Os1AIHmSigQeoIvvvDKpF19gj+fZB9IcUOQO7c
91JQ89OKHe4C3TMVaJ7lFqADy4sdnl1Qum0pt8ABxJ3fVgyxT3GBA9j9k4od
WoDOZFVd4AA03f3hPChfZYGDN8ihM4sdngL1VwLdW75vvpR+J8T8UOkFDm9r
7E3j8qD2iS9w0AcxgosdZs2cOfOm8AKIuwyLHbivLy74K7jAQRgUHpwIvhXI
QXeL4PyrFS/VDHcUgd0pL7LAoRrknhmQ8EqVWODgAfJ/ZZHD179XKlbKQP2b
VeQw1bk7J10JwQeFz1xNNHlDKL+qyIELaF+tOZQ/q8ghHKj+rjWUvwsib+uw
wOE4KAAeFTlsKMqYmOsEDS+hYjgfHL/WCD44fGIh/tvrAA2/ckh8xdpC3T8R
6n9LRHiDw9cUwYelJwADVhGo
      "], {{298.16400000000004`, 
      2073.3550000000005`}, {308.727, 2073.3550000000005`}, {308.641, 
      2074.8230000000003`}, {308.469, 2075.8550000000005`}, {
      308.21099999999996`, 2076.448}, {307.79299999999995`, 
      2077.3740000000003`}, {307.172, 2078.105}, {306.35200000000003`, 
      2078.636}, {305.527, 2079.167}, {304.668, 2079.4330000000004`}, {
      303.77299999999997`, 2079.4330000000004`}, {302.39799999999997`, 
      2079.4330000000004`}, {301.16400000000004`, 2078.8940000000002`}, {
      300.07, 2077.8230000000003`}, {298.984, 2076.761}, {298.35200000000003`,
       2075.269}, {298.16400000000004`, 2073.3550000000005`}}, CompressedData["
1:eJxTTMoPSmViYGCQB2IQPVmCJYyvucQhjE93U6zTAod3NfamcbsQ/KWzjyhs
eFbiwH19ccFe+wUOny75JglwlDpwAfm1VgscDn3ViOlXKXU47m3eyWi2wKHT
MeHpBaNSh3Cg/rsGCP6flR8v8Woj+O1iN899V1vgkPv898qPWqUO91TYGq8q
LXCISrG+7y9d6mABVLhUboGDUPOBUwu5Sx00Y/oPlUpB7f9WAjbPV3yBw2GQ
/bdKHDYUZUzUFV3gAPbPfog8r/ACh7cg/yyAuP+vINS9dQi++8MqkXXuCD7Y
fJkSh2cXlG7vFFngoAAy+Hcx2H5ToP1XK16qGT4ohrhXDmr/pWKHFqAzWVUQ
fJCzj2oi+MDgmPteF+r/W8UOd4H6RY2g/n0NNR8YfmB1QPtmzZw5MxIYvtqg
gBIscfj890pFpi1Uv06JgzmQkQqMD16QeqD7t5wo2xfvCI2vFET8occvAFFs
47Y=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQ3eGY8PRCWYlDGJ/uJln7BQ5bTpTtm5+B4D/w752e
F1XiYH0fyLBb4LBDrvV1oE+Jw5+VHy/12i5weLx09hEFuxKH497mnY02Cxy2
gvQblThsLMqYuNZqgYN2u9jNc5oQ9bwWCxxyn/9e+VGhxGEDUD7XdIHDoa8a
Mf0yUHkjBB8k/1YXVd5XfYED0PYdcuolDndV2BqnKkLdY1Pi0Hzg1MKjMgsc
bLmuLy4ILHHQjOk/9FV8gUNUCtDluVD3ii5w0AK5px/BFwZpXIngV4msc3+4
rwTsj/tiCxwUQA45DzG/VXKBw9WKl2qGD0oc+HU3zdWXgbrvRYlD5sS3NfsV
EHyQ/abqCD7YHfrQ8LkF0b8e6H9w+O+D+CcUGF7AYJ/7fjXUPlsofzIiPtDj
CwCowdmm
      "], CompressedData["
1:eJxFU3tIk1EUX1ISla5YTbM0rRE+GFMwBpp4huQDG9O2th6aJQkJ2bt7R1jR
QyIihoS9ZHbnqPCPRISixLJGFESWyEwkzPlHlsgQndFT6L7m/eDj4/ede879
/X7nnLTaozvqYjQaTRF92fdB6+vUrqVuWDbsP3Z2FwH84l6SaY0bLr1852uy
EIjGo3jIPbk55xcG81XL/rpSGQ9h2Dpmu+6yyngAgzPe2F1dQaBk/MzqTj8G
HS1wwE6guqdsRcx5kf/VIc87FH6a0jRVma1wnLHbO63FUN8cbuyj+Q3f/nbM
zCLIqPIETlcSmB201q78hEBLz5lsBPYczB+z9SH+9ZQTuM/4dSIYNcReaCkm
oGFPG4K7d+hD9ZQyfi0IIvNBd32+wpep3iW5Cs/R+KSRQDYr5EVcnzdd+vVI
4GQDAUZ7oBdxvb4NBKgtt44EEeeds54AS5uOIPjXMTPYv5ZAATNeh6HrxKHm
hgTJ34x5Pwr00r8ahXn9iwpnXdGPfPCJfGOC1NuLef04Wt/E+A6LeDiJQPu2
J5H5OQw3i64dfpii+s3rGSSfNIk3EXhTTjsR6wZ2jTmZQOBHepVnAnOeHxMJ
hJg+2m/ul17qbcMiT0cglV18EoOLCh9dJfVbFObnv6MFfCNxsTPej+AtzV+k
l+ePC7+slC9V0VhoRZwPNsh5yEOwnPJ9nqUw70euwrx+npy/EgR7KX+tReqv
QZBJ5+lxsfQfi/nYvV3qvY1gYmDj52cVsl4AwRdq65Bd8gkjwdMp9a7DC/vE
/1sV5vmnFOZ+t2Io3LKvp8wl8Ss1//z+95jPXwbFlMbvc0HR33675D+iMN+f
kMLRfnE/HJLPFBZ+OaL7JPbTt5NAJjP2p8DjTrnffxTf/7TO+Y8=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQvXT2EYUNyyoc/qz8eIlXdoFD+b75UvqbEXyPh1Ui
6/ZWOBz3Nu9slFngcLXipZrhsQqHDUUZE3OlFziA9Z+rcAjj090UK7XAIff5
b6DOCofoFOv7/JIIfvOBUwtbxRH8zIlva/6LLnA49FUjph+oHyS+UWSBA9CY
ue+PQsybK7zAIQOozh5ov71p3K5OoQUOnY4JTy9sqnDgvr644K8g1P5lCP5F
pds/62Yh+J8u+SYJTEDot+UCSrQjzJ+eJ9R8oA5h/wP/3ul5VQj3wfgw98P4
d1XYGkUlEfrNgQ5LlUKYrxnTf6hUGmE/WL8Mwn2w8EUPfwDg8MY4
      "], CompressedData["
1:eJxlVVlsjFEYHeuD3UynyCjTaulgqKZVXaLfUJSWLjqtpRURjSWliFjuVSII
JU2JFCW4SB8aSxBrg9A0toRYI0JJCSLiwdIHoeEuZ9yESSYzZ/5vOd/5lomc
V55f2t7hcJTJt/p8EPXix/pcTl2eHVtWMUNQCBf28J+NCAhKOXd71bWAxTzs
1KSWNE6pr3Oq9k4QdGnAlk95CZz2jN9RNmSyIId6xXL6Vf/l0b0sQc5N1+8e
8XDaGv78/uppgr4+mjqvVxdOzdGdN9bkClq46/O69G+MxlQG5sbkC5Iocc5L
RkOLqxvPTxe0d6mM0MQMvwJBN7OSKgMnLG5sjS2u3mmxS+Vby0jSPVgu/Ueq
RAuYzhfMExSnvzB6LwtNzkG92YxeyZ+fZlus+UyxWLm5MwXdUvnzGS358LN+
1EToU4L8GeC3lGm7duMEKTi3xtifGYt6HzOtT1UK/DtBvyRBb+sONHmhX1WC
oIcqfwqnrjL+1XhBRydc+NaWzen0ChkpDvFmc6LEOQ13RgCXGn2Dw4HLOSka
73zgt5JTpAyQN8Ri1d+D0RYr/hsHor/zOe2vra3t54EeGSZeaR9BKuyDaG76
5UL/fzEqkvGaewPftfiyitdgsZ6P44xi5Dh0cML+kNFnqhP9lPq9k4nXOpF/
M6MNi6+sdLmgz2Jm5jNMkJLzcC4zerrBnxidkXqddGMeki3W/OMtVrrs8jOt
7xI3+uMz+LOMHzFrfurrGEZlsp/LJd7dt2Nhj0Gwd0HvSFuf5uf8H2+WZXXy
WfsQ1vsRy+h725M1PtkPlS5nFKMWFnZqqxf9T0O9A1BvJqNtcr8uehB/FnA/
4BWw7yvovLLfjnjh4F/HzHyF6r1hsd73NxZr+zbsSzjmpRc3/GU+rxJiECef
nIdED+rz4x5E/IO9Fms9o+Dvw72Jxr5FwT4G+T2YTzm/yYpvT3OP+oTm24H9
GYp+tWLfhiH+c0atUt96P/LL+dP7EYf4Fdj/BMQrNvfi8mhB+9Q9yjTP68bA
P9Hch5oU3K/BuF9p8O+P/qajHtl/tU8zA/Dvbvr9cbzF2n+ixTJqQ2UW5qM/
nuegX3Ketd7TUV8R+Bbi3lWwv/ddz/9xi/W9uW2xvqfvDb/aItzfztz0O4j9
cHNaJHn9LgAfL+556D4Ptljr6bdYz188pzTZr2cSlzRM7tY+yfS7JAh+qVzv
fUsQ/um4d4X2/yjE9w+08gBn
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQbbXlRNk+1RqHlgOnFrIGLHBA4TsucIjb5cnDVI3J
bwbyW20R6tH5mjH9h77KI/iZE9/W/JdZ4DBZgiWMTxPKl1rgYAmS14eql1zg
cOirRky/WY0Dn+6mue8lFjhEpVjf97evcdhQlDExF8hnAAEvBL/TMeHphSAE
H6w+usbhuLd550EgX/+uCltjMlQeaL4QyKHZNQ5hQAtkpaDmFdU4gJwhL73A
4YLS7Z91ZRD3lALdewxojmMbgl8tss79YQ2EbyoJdX8+1D6xBQ7T84A2xEHN
F4X637fGoV3s5rly4QUOj5fOPqJgU+NgAXT4UiGo/VoIvjZIoSyCLwvykGCN
gyLQA4LCUPew1TiYgzwO5B8GhdevanB47heBqv9YDbbvuyhU/Ztqhz8rP17q
FYe671k1OBwUJaH2P6l2UAAFkDSCHw50/105BB8WvyB/Oq7C5IO069pDw2dH
tcM05+6c50C+Fsghx6H2AdNPLCj9XIea77TAYYdc6+tAoHtA4TXXBWrfl2oH
fiB3vRuUz1DjAIpGUU8oH+j/WTNnzoz0gsYXX43D179XKlb6QONbEpGeAUxA
NNQ=
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbXipZrhnRqHeypsjVf1FzgwgACQH51ifZ9fc4FD
+b75UvovaxwyJ76t2a+8wMH9YZXIOuZaB/NOx4Sn8gscdsi1vg6Uq3VwMI3b
xSmzwEFxQ1HGRNtahzA+3U2yUgscbLmuLy5IRPAzgObYVyL4YPv6ah2A3Lnv
paDmz691uAt0z1SgeVFAd/hvrHV4dkHptqXcAgewew9A7VOE8s/UOrQcOLWQ
VXWBw33/3ul5N6B8lQUOuc9/r/x4qdbhKVB/JdC9M/KEmg8cgpgfKr3AgRdk
73KofeILHCZLsITx9dY6zJo5c+ZN4QUO+iCJ7FoHbqA3/gpCw8MZwQe7TxzB
t9pyomzfxxoHECUvssDhAcg9l2rA4ZUqAfX/5hqHr3+vVKyUgfp3cY3DVOfu
nHQlBB8UPnM10eQNoXygflCw1ppD+ZdrHMKB6u9aQ/mfIfK2DgsctNrFbp6T
rnUARUuuEzS8fBB8sH9KEfzpoPCZBvHPXgdo+G2AxFesLdT9p6H+tUSENzh8
TRF8WHoCAOyOEAA=
      "], {{461.762, 2073.3550000000005`}, {472.324, 
      2073.3550000000005`}, {472.23799999999994`, 2074.8230000000003`}, {
      472.066, 2075.8550000000005`}, {471.809, 2076.448}, {
      471.39099999999996`, 2077.3740000000003`}, {470.77, 2078.105}, {469.949,
       2078.636}, {469.125, 2079.167}, {468.26599999999996`, 
      2079.4330000000004`}, {467.371, 2079.4330000000004`}, {
      465.9959999999999, 2079.4330000000004`}, {464.762, 
      2078.8940000000002`}, {463.668, 2077.8230000000003`}, {462.582, 
      2076.761}, {461.949, 2075.269}, {461.762, 
      2073.3550000000005`}}, CompressedData["
1:eJxTTMoPSmViYGCQBGIQnfP898qPaXUOmjH9h0yjFjh8uuSbJFCE4CtsKMqY
WF3n0CF289z2yAUOtlzXFxc01zlwA6m9EQscMia+rbHvrnM47m3eeTB8gUP5
vvlS+v11EH1hCD6IqxuK4D+qEll3PBih/64KW+PUIIT5YH4gwv5ZM4EgAOG+
MD7dTbJAPsz9ML7llhNl+6IR/KsVL9UMgxD6wXwvhPk75VpfBzoh7L/v3zs9
zw7hPhgf5n4YH+Y/mH6Y/2Hmw8KHAQSCEOEH1heNCF/08AcAwPq1+A==
      
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQfbXipZphR51DGJ/uplinBQ4wvlZM/6Gtsgj+rJkz
Z96UWuBgteVE2b7OOofc579XfpRYAKF76hy4ry8u+Cu+wOGYt3mn44Q6hz8r
P17iBfLL982X0p9a52Bz3783XGyBg/vDKpF1s+scwoH23RVd4LBTrvV14KI6
h6nO3TnpolD96+ocNhRlTNQF8m25gAbvx+QDVSWkCkPdx4fJh6lnAAEFBB9o
7dz32lD1ML5hncM9FbbGq0D+p0u+SQIWdQ7NB04tdBWD+s+mzuHpBaXbP4F8
oDem5znUOWgCw+erOFS9C5QvATXPtc5hKzCY7ksh+LDwhPFB4eOrj+CDvGVr
ssBhep5Q8wGgeSDxfPMFDg9A9jlB3PvUYoHDoa8aMf0w+y0XOHiAwtMWEh8b
raB8S0h8ylpD+aZ1DiCq3RoaPgaQ+NprDY0fTQRfu13s5jlFBB9k7QUJiPtq
rRHhC45voH3LZh9R2MABCa+jNgscloL4ZYj0BACDZxL7
      "], CompressedData["
1:eJxllAtIVEEUhrcFA0203HbT9VFJRg/MBGXVVTwWVCIiCbUZWiFKRmkWlNJj
55YJSohI9LAIJ0pCgpBKCyMRKQuJHluiEmoS9sTEQkJK6sydMwyxC8vluzNz
zvnP+e8sLz6YX2q1WCz5+BfPqJ0l7jEPgzWFjb0dKRxex76b9Z5mkFKftScu
k0NZ0+SJzFsMtofE3ynawOFD65XHy3ya8XF1akJzUVd2sPUXgwWD1ysfZXEQ
29utBgQhnwQONyozggYDJWdg/N6ZVYWNoQaEYpyEDA6YduKVzYCRFfNPbUvj
UCfYYcDl5ubmAqxPlJsXbsCftmlfbrLm9sNlTfGJmk090ZrF86WTw9TNvhxX
hIw3HM7hhy+3eGGkAaOYb2AJh86fc2+rowzYh7r/Oih/jAHpY3kNHgftjzXA
g3pH7BQ/zoDzG88e2Iv8Bpd3rKV6kKu6W5wJSf7sQqGlNg7RIsBd5sdqf45Y
eKgZp5G867nmgeovKxOHmDknhnxs8e3N46M0P6x3yzi+wfmY+pHf5zVcrPjK
oKan/9oT1Fv7beuDmEkGZ5ADIjj0iYTf5XptBMVDFvOwR2pW/VVs1r9eM1bZ
VZ9EfsJ8Yl4NLtI3LusvT6V+DMv1XDeHjmdHu1v6mfRHOvmtU/M9sX5Bs3m+
iupDvyg/m/qSNat6FZt5nOTvAgZ1juEX98MpX6H07xz2J1Uk3M3gKfZlHvJx
oa9E6st20Hz2M+kfO+k7RP2wU3+ZnpfJ5/xZzd/UN+r1Y7Xf5I/e/8/ParYJ
4QGk3056ghmsRv0zWO+lirCanjDyh9LroPxOzapfisX+1nWaRR1Lkyi/XcY/
4iK20f4U4kVMfm84b4v4hTCYwc+sLY36FUjzc5Nfqf5aN/nbQveJm/qNehWb
56c1l3/63Tb92SvvG7funznPNOIhr+yP8tMmfX8pfyj+B936Tnk=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQLd/6OnBHZoPDn5UfL/HKLnBoF7t57ns+gv9++TFv
89IGh+Pe5p2NMgsctn/+e6WissFhQ1HGxFzpBQ5g/bUNDmF8uptipRY4LCmw
5bpe3+AQnWJ9n18SwW8+cGphqziCnznxbc1/0QUOupvmvl8O1J/7/PfKjSIL
HC77JglEVELMmyu8wIEBBID225vG7eoUWuAgGGG55QTQfdzXFxf8FYTan4ng
bzlRtm9+MoJ/RAHo0jiE/qw9JZMlohDmz8gTaj4QirDf+r5/7/RghPtgfJj7
Yfy7KmyNopII/eadjgmpUgjzNWP6D5VKI+wH65dBuA8WvujhDwD3JLnC
      "]}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{719.148, 2169.7022050000005`}, {
     788.8359999999999, 2169.698205}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0015994324417357268`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{748.42157542762, 
     2169.7028773132724`}, {763.0620877672281, 2184.3393648703477`}, {
     711.8285754276199, 2169.7066579556604`}, {763.0590628813801, 
     2155.0613648703484`}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{1387.8519999999999`, 
     929.9052050000003}, {1249.992, 1326.2022050000005`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0014162868511029278`], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     1378.2314663079999`, 957.5587015120004}, {1359.598497604, 
     966.5737328080004}, {1390.254975294, 922.9923536410006}, {1387.246845475,
      976.1906702160002}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{889.102, 946.0692050000002}, {994.637, 
     1326.2022050000005`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.001480558744785745], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{896.9298905379999, 
     974.276549354}, {886.7415276419998, 992.2961864580002}, {
     887.1402425259998, 939.0145493540001}, {914.9525276419998, 
     984.464079372}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}}}, {{{631.039, 1761.046205}, {
     857.1990000000001, 1481.9012050000003`}}},
     CurveClosed->{1}]}, 
   {EdgeForm[{Thickness[0.0007284567521596737], CapForm["Butt"], 
    JoinForm[{"Miter", 4.}]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{649.4691511400002, 
     1738.3000797600002`}, {670.05806239, 1736.1393706300005`}, {
     626.4330188700002, 1766.7330797600002`}, {647.3074420100002, 
     1717.7103583200003`}}}]}, 
   {Thickness[0.003198864463484343], CapForm["Butt"], JoinForm[{"Miter", 4.}],
     JoinedCurveBox[{{{0, 2, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}}}, {{{1677.273, 1926.1472050000002`}, {
     2164.3550000000005`, 1926.1472050000002`}, {2199.809, 
     1926.1472050000002`}, {2228.3550000000005`, 1897.6052050000003`}, {
     2228.3550000000005`, 1862.1472050000002`}, {2228.3550000000005`, 
     1702.1472050000002`}, {2228.3550000000005`, 1666.6902050000003`}, {
     2199.809, 1638.1472050000002`}, {2164.3550000000005`, 
     1638.1472050000002`}, {1677.273, 1638.1472050000002`}, {1641.816, 
     1638.1472050000002`}, {1613.273, 1666.6902050000003`}, {1613.273, 
     1702.1472050000002`}, {1613.273, 1862.1472050000002`}, {1613.273, 
     1897.6052050000003`}, {1641.816, 1926.1472050000002`}, {1677.273, 
     1926.1472050000002`}}},
     CurveClosed->{1}]}, 
   {FaceForm[{RGBColor[
    0.7843139999999998, 0.21568600000000002`, 0.21568600000000002`], Opacity[
    1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3,
       3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxlVFtIVFEUHSZT0QiLUMkZ7x1tHMKC5iPGsHCXhKU9qPkY6aPCioqsERNt
dLTCQiKCIszAs+mn7KOQCCPIqD56SB+9IaWXZqBSYUqYQkj73LOvx2Y+Lod1
Hnuvvfba11MR3r7P6XA4gvTJdezN5orzvQLKV3X1TDQjjBNOS8U4XPhl67m2
4whvCfYmaWytcxEST7YWpxLesZd2Evh9I8L9mouZCXMQ3PIgilAWOLN2txNh
/vLbGG7QePrdsZGOiMZf6xd1PqtDuHxkYfMj+30NAlF2nEjk+FUI6X0v/gSJ
z6/rT8vuhhG6emofXElGOHjhZ/ThYY6XonhmHFJ5RxcgXCo+Wzm0E6FNxl+s
z637JsLVqjUp76sROtofmytyOX5dDI5o7CJ+uxpUvadyEAYk/yifezhfI+tn
IJTOc+YnkV570qgSt9ZzNp/Z+L9+FMVj+75x+vu2gkLmQ/iJeat6OKDqCTUp
fYyV6n1tVPEs8SOEKc3zCMdbhvA658PU9FHuk1frY/FJR9hI/FtC3A8/n9Ma
GcnzJxcg3JF98CFUyPpWs+4evl/E9Zvcv3UIk8HBa1nZCC1yYz37yc35S7kf
Lo2tejOV315mxGP7vtS7PEvjzhKqOFvla3crPg5T+S/PYH7E86YUkPYPkI+K
qJ/dVPANj8aWfrkaS1lKvexXg/MtjfGXX8+TVf8G5jslZs4t//zmeaT3m8iP
/WPC4tPt1biV/LR/icZWP3I437iAfCmkyfVQPKvPBvOdEGq+3Px+kvO52P9/
xYxeNrb1tXBfPLbvyzb7PgoYpfkIuHkePwu4JwlmM79+oebHYP8PCuU3D/tl
WCg/+ljPUa2Pxd+e/y0x9Vdyf38I5bca9sUQ86ln/3xTfEPkf6802oCAV5S/
qYn/X5/EzDzZ/0cb/wNuQkaT
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQveVE2b75dXMdvHiYtNmT5zrA+O+XH/PeboLG15rr
kCwQYbmlfq7DBaXbP+tU5jr4mHc6Pmic62B9379XXGmug/jNc98vt0D1yc11
EAPygzvnOkxz7s55LjPXwRuoPqEfwefT3TQ3fyomH2TedAmo+kBMPkx9VApQ
JhzB/3TJN0kgDsEHuy8J6j75uQ4z8oSaD6TOdQD64kSZMtR96XMdgnbItb5W
hbhbPmOuw25PHqbV2gg+cniA+FOB5qfPRuMvhdoPNO9H8OOls1dD/PM+BRq+
6+Y6cKyRiXqSCPXnxrkOl4HKI2LnOvy7UvFSbTPCPzA+zL/ofKDztNu3z3XY
CgrnbgQfHP4zEfzKl2qGHEB3sTVOdebeNtchY+LbGvu10PAAmndqoeu24q1z
HXaBNGyAmr9nrgPQmSnWQPczgMChuQ4Pq0TWuS+B2nd8roN2u9hNv7lQf5ya
63D4q0YM/1QEH2x/N4J/CCjfD0xHhbZc15WPQcOjZK7DR2B4TdgLja/suQ57
SiZLsADd8who3/FkaPitmOvwART+8dDwmYngA51xrnwqgg+Oz4lzHUTXuT/8
FQ+N/x6oexLmOhxR2FCU0QF1LzAeQMYvb4ban4hI77D8AAC60HK5
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQveVE2b75dXMdPiw/5r09c67D9Dyh5gNNcx2Cdsi1
vs6Y63BEYUNRRttcB+12sZt+QP5WkPrOuQ7TnLtznqfPdRC/ee775Z65Dp48
TNrtQP7HS75JE/rnOiwpsOUKB/KjUqzvn5+I4PPpbpr7fiYaf8FcB5F17g+r
sqDql811eFglsu54wVwHoCsCd6yZ63D4q0YMf/lch2WzgS5aP9fhPdC95vVo
/E4E3/q+f6/4hLkOqmyNU53XzXWIsAT6dBrEvvzVUPvnzHUAUtcXr5jrkDHx
bY39orkOOkDnLF8y12EX0EOrge4ABhFDw3yIedNXznUAWuKYMGuuA8jYbqC7
9pRMlmiZMtfBC+h/9nVQ//Qi+MBgO/e9E8H3Aep/0ALxn/vauQ6w8H8E8i/Q
XQArwbzt
      "], CompressedData["
1:eJxVlFlI1FEUxoepzEpMpBwTd3EcHZfUJMPEAwahUZE+aBblSlMNGkbjmtIi
BhbaQ/Ug5/aSSigVYSQKFS0mBe1QMYaplVnZuGSDRkP3f+/RSwPD8Ju7nO98
554TUliWVaLX6XS7+Vf7Ha5ec22rgUHK0M5zBhOCYA8GbicupDcFITTfnzXt
XcbAmT3a1uqHUDlujD+jZ3LfOoS8Yn7ShTD25+pUlgHh9fZCr3dzCFeOpK7M
8UF576zib8Z4964JxUn7ejPOjiEEaBf5IgQ2fN/VM4KQu6l74HcAQlYP/+cD
Cj2rwii+HaHLP6+4L1JxpofevDxBsdC3EaGt9WHwjUGEMu9T956kIFTxdfch
qetSGoJ9ru7Q5hGKswWBOTr6n44RZyAEaXoctH8H6XcilPL7MrMRWrg/g0sZ
vAy1z7lyKS73c7Kjf9vt/YpFPkWKezM89J2lCFOvthe2rKXzxxBibqIjwpv2
V8n9jz2Jj5O/K4jrJecuUazpPuzCRRZ+zCN0D9juXK6T93c4ab2G/PlF+VTJ
fJNnECznJ2rTbIq1er0tR+C7yy0z5LdVsSe/uMyCkN5kHauZRujT8itBiNbi
TaL0o0i+l+c/EQ7y++8WkN4flGc+QqPP+2cV44qF718Ui3p9onoWUPwR0ldE
fn6k91RC+fJ6/31TOd5uUezibLQqzv/8ItReTu91lPKrknqc43S+jvyfpDqe
pnzn6VwjwiOu56sbW2Shz0ux8NOXAT89XN1A9QukfjpJ7y6UST311F9GBg94
G66upXqaGFzUAtuk745IBlqbNh8lv6MY8Gr7XbcqFvcXKhZ+pSq+pb2PRMov
SsbfE0N6zUz6YaZ6cO7U+s9E69EMKni8uAjyIYYBnx7WA0YEnfaJZcLv9nCE
aV4frzjSE04+rlcs8otXLOZOAs2jhfVE8tNI/ZJEHEF+JTPyhfo9lcn6xSr+
b95tkH7k+JP/ZtlPNh+qf5hirY+CghWLfAIYmLWNBnqnfrS+MC95vcW5AJqn
vP9Ff4SoebCg5x8C2ptH
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/bBKZJ27+DyHf1cqXi7Tn+sA41vf9++dHjHXwbk7
53k19zwH2agU6/vBcx18zDsdHzDPc2BrnOrcHTDXoV3s5rlyBqh6v7kOGRPf
1tj/muuwy5OHSdt7rgNI2/mvcyHy7nMddDfNfa/+ea7DkgJbruvOcx0qXqoZ
dnyAyIs7zHWQb30daPF+roPoOveHv6wRfJBx7eYI/jSQwwyh7gHqXyMDtEkX
Kv8Fql4Tau/3uQ7aIIeqQt37e65DhOWWE9+U5zpc9k0SuPEfwZ/3fvmx06zz
4PwfwY+Xzuad55Dw9ILSbXVE+MDCCwDP65d9
      "], CompressedData["
1:eJxllG1Ik1EUx8eIkpKSiBJyL24pqQQGgYhUp6QynS3mh0ZJynC2YetZTucL
0rBay8w0JBbIvSLqJJSKsBcqKjJK/FD2AhV9sBf64IcYBb19KDrPfc7DrTYY
4/fs3nv+5/z/98n2KC6v0WAwuPCr/iYGHlgL6ziMBDcu3hNksGZh57mpIIdZ
25ufRyIM4oeWH7vXwaFkztmzKsZgcjp8x3JSskH9nJHcNp+7Pq2fw1VcNxhl
4Dv7qWNznENy7GHF9aMMZoa2XQsNcFDw2Bk8f29dydwTzsFdPDn9rV1j55C2
vqiJwZdnlZ6MYQ4oq7RbYbB03RWWRK79OGvb55P860XrfGK/ZLWfl4WS1f1L
8hnEVr5+3DLCxXMlh8FnPL9vlEN5urFgkV1bryQ4TH1dW70sm/SNUX0LA3Ve
ly9oesNmJvqOj3PIwoU1JgaHsaz9EtXPon4mU1nsy6T5RFJZXy/0dP7HJ/7l
ZBftNxF3kx8W4h4ufBu0MsD2v1f1cjCpQmzkZx+dh/PA7hp9yE/R/9+5NB/k
mzvTjeP5kvX56vyufcXFR9WS7+P8euuZeL4D691S9wcoT6dJXyMDT4a7eMMp
yluY9EYpL63EEclq2eGw5LQJnHyA8hbS/FHzLPzxS9b16izmlUf+If+o+jC6
Oofm6+WAbh88YKd+6un/bMqjj/Kjz9dP6zEPz/HvVw2UT/TjvNqvIv0SOptT
Wfdf1INU1tc7irq2vN0qWfhZJvl2U3/mAgfdHzPpq6T7ZSV9Tg5+zNldO+V7
N92PPMn6vHQW83ZLFvq8Wr3jyK4b5mhDgOo5qX5Qq+d20vkhuv+7SE8T5V3X
10zvDwflL0x5LOeA8SmItTCowP5ryySL/GyXLHSVav4kw3J+79V8NpP+TVSv
jfJfI99ff+dD5T9unFwc
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQvXT2EYUNHPMd/l6peLlMZa5Du9jNc+XM8x3K982X
0pef6+Bt3umY8G+eQ8bEtzX20lD+z3kOSwpsua5LQPlf5jlEWG45USYG0f/9
3TyHh1Ui69xF5zosA5pv8BLBB5t/F8EHm3t5nsMuTx4mbam5DkAnMTScgpj3
TXmuw4w8oeYDB+c55AOpU7pQ+/bOcwjaIdeabYXgg93jieC/X37M2zxyrkOS
QISlySGofelzHXyA8g9Oz3PwAlrHXjLXYZ37w6opV+c5aIMc1jDXofKlmiHH
I6j+dqj7PiL4IPO2/ELw95RMlmhhmg/ht8x1gIUnmF+H4IPtm4Tgg90zb64D
xxqZqBQgH+y/pXMdolKs759nn+9gfd+/d/qKuQ7yra8DLYB8sH9XQ+T92eaD
/Ru+dq7Dp0u+SQKsUP46qH5g/AFNtY5fD3U/0H3TnLtznq+Hhg8Dgg+KrmBg
/ML4hcBgXPwbGl7rofb9gIYX0PzpoPj4Ng/sPvFNUL4Y1L/7oe6RweT/A6Yv
NWcE/9BXjZh+s7kOl4HcCCBfFmSR3lwHPt1Nc9/LQPwvrgMNX1mo/zTnOpxa
6LqtWG6+w1Sge9PVoelDHhqeatD4U4SmX9W5DkBbDTuUEOkbHB4qCD7Y/2oI
Psj/yprzwenBTxUaXzpQeTWo+3TnO4CSa7sS1D988+HpGSV+gXwAxI+GNA==

      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQvXT2EYUNHPMdlhTYcl3XmesA4/+7UvFSLWWug3zr
60ALIF9knfvDqsy5DlEp1vfPs0HUh+fNdeDT3TQ3n2W+w/vlx7y3F811sL7v
3yvONB9Cl891YACB//McZIAa46vmOmw5UbZP/vc8sPz0mrkOD6uAJn+fB7G/
bq4D0FbDjs/zHCIst5z4Vj/Xwce80/HBewQfbN5LBP+yb5LAjUfzHGRBDquB
uufuPIh7yiDyEdeg9uVB3X8JKp+E4IPdG4zg5wk1H/BynuuQMfFtjT1Qf/m+
+VL65lD3A80Hufu4HtQ9T+Y5THXuzklXm+tQCPTG4tcQ882V5jp8ugR0wBcE
fxkwfA1+o8kDwysTaM9+VUT4w+IDAGDXwvQ=
      "]}]}, 
   {Thickness[0.003198864463484343], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 4, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{0, 2, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxTTMoPSmViYGAQA2IQvc79YdWU7JkO1vf9e6dnzHFIEoiwNEmb6fDvSsXL
Za1zHPaUTJZgSZnp8GH5Me/tE+c4cKyRiXqSPNNBJirFOn7yHAfxm+e+Xwby
2RqnOnNPRfDfg9RPQ/Blgervz5rjcOtnXdYeoHlBO+RaX8+d4wC2H2jfkgJb
ruvz5zicWui6rThjpkO+UPOBUwvnOBxV2FD0Imumw8MqkXXHF81xOA2U/5yL
4IPNL0Dwwe4vRugHmS9SijDfpTvn+e8yhP1g88oh8uGzEXxQeIjPQPAjLLec
KJs0x2EuyGNAfsLTC0rRPdDwAZr3CGR/KyR8UgoQ4QkAdiOyFA==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQXWjLdV3ZfaaD9X3/3ukZcxxA/MWOEL542xyHl2qG
HDoOMx12efIwaffNcTi10HVbsf1Mh91A/urJCD5Y/zQEf0kB0KBZcxzEbp77
HgzUH7RDrvX13DkO69wfVok4QeXnz3EQB8pfdp7pkC/UfODUwjkOSQIRliZu
Mx2AqtYdXwTleyL4P4IfL5X2QfArgA7s8EPoB9sfgDD/iMKGooygmQ6yUSnW
94H2c6yRiUoJnumQMfFtjf1sBD/CcsuJb9MRfCBpHT91jsOekskSLUFQfv8c
BxW2xqmHA6DqW6HqvRHhBwAcsZcz
      "], CompressedData["
1:eJxTTMoPSmViYGAwAmIQ/SP48dLZ62c6LCmw5boePscBxvfkYdJuN0DwvYB8
do05DqZxuzx7Nsx0WC0TlbJbaY5D0A651uxNMx3+Xql4uUxhjsPpha7bPm+Z
6bAGJC87x0GFrXHq4R0zHR5Wiaxzl5njMOHQV407exF8kHk8hzH51vf9e6dL
zHF4qWbIodOJyYepv/2zLsumD8F36c55/nsygr/OHciaMdNhy4myffJyUPfP
gvpXcY6D+M1z3y/Pngn2x2vlOQ7OQP3Vc2Y6aLeL3TyngeDDwgPGfwQ0/3g7
gg+2bwLEvilA84Dedu6eOsdh3vvlx07PhLp/+hyHJIEIS5PpMx0uKAFdPmuO
Qz8wPGKA7o2w3HLi22yEf2B8mH/R+f9A4T0fwl+zC8GfnifUfOAYgq8KcsiF
mQ5A1+Skz4Oaf32mwzSQw2H23ZvpwKe7aW7+zDmQcHoy0yFj4tsa+6mQ+H39
AhJe4f1zHJKB7t/yFhJe2Z2Q9CH9AWp+E4IPDo8qNH7+HIdTwPRR/AYSvn5p
UP88heqPh9p3d6aDCCggI+Y4FAKjafFlaPoLhYbXMQQfbP5hBB8c/vuh7g+F
hv/umQ4flh/z3g7kM4AAMD0Chb3Nw+aA/f1+MzT+wxDpHZYfAEqegLU=
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/SP48dLZ62c6ePIwabfHznEotOW6rrx5pkPC0wtK
t2PmOKiyNU513gbhRwP5Lt05z3/vmOngBVTPDuTf/lmXtWf3TIfyffOl1kfP
cfh0yTdJYB/UvGio+v0IPscamagnxxD8CYe+atw5A9GvHwflX4TKJ0P512Y6
THMGGpQxx6EfyI+5OdNhSQHQofmo/PAKBH8XyIA6qH9uzHSwvu/fO70Z6t6r
UH4HVP3lmQ5bT5Ttm98Lde/5mQ4yUSnW8RPnOIDD5zTUvskQ/TbHofZNm+OQ
MfFtjf0hqHnT5zi8VDPkWLMHwZ/7fvkx750IPp/uprnvt8x0iLDccuLbNKj5
wPD/AFS2feocBwB2kMV8
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dyd87yad5ZDhOWWE2WBcxz4dDfNzQfyg3bItb52
nuNw62dd1h6BWQ55Qs0HvCznOPQf+qoRIz7Lwfq+f+90wzkOe0omS7DIzXKQ
jUqxvq85x0H85rnvl1VnOXjxMGmzq81xmPt++bHTegj+dJBBJgg+yL73lrMc
dnvyMK1Wh5pvB3HPN605DipsjVMPO81yyJj4tsZeb44D2L1uUPuMoXzPWQ5L
Cmy5rlvPcTCN2+XZ4wPlA937Us2QQ8cbon+/wRwHoC/3ybtD/asxB+zPbAeo
fQpzHJIFgCygey4o3f5ZJznHAWSNv+Esh0dVIuuOi85xAIpm2agj+KpA9znL
IPg+5p2OD4RmOYCEuaUg7uHhhoaX0hyIP5hnQdyhDfXv/5kO34MfL51thuCD
w8cVTT4EygfqfwiyLwHKB5oPDD7t9kwoXxgi7140x4FjjUxUiuwsh79XKl4u
K4OGlyaCD/LPHmMEH+wuG6j+Ykj4rXGCmp8Ddb8n1L+piPAGh28Mgg9LTwCX
EQ8C
      "], {{1667.3709999999999`, 1813.8039999999999`}, {1677.934, 
      1813.8039999999999`}, {1677.848, 1815.273}, {1677.676, 
      1816.3039999999999`}, {1677.4180000000001`, 1816.898}, {1677., 
      1817.8229999999999`}, {1676.379, 1818.5539999999999`}, {1675.559, 
      1819.085}, {1674.734, 1819.616}, {1673.875, 1819.8819999999998`}, {
      1672.98, 1819.8819999999998`}, {1671.605, 1819.8819999999998`}, {
      1670.3709999999999`, 1819.3429999999998`}, {1669.277, 1818.273}, {
      1668.1909999999998`, 1817.21}, {1667.559, 1815.718}, {
      1667.3709999999999`, 1813.8039999999999`}}, CompressedData["
1:eJxTTMoPSmViYGBwAmIQ/UrNkGNN8SwHTx4m7fayOQ4wvheQz540x2Hu++XH
vKtnOZTvmy+1Pn+Ow5YTZfvkmxHqXwLV63Qj+OI3z32/3IfgTzj0VePOxFkO
U527c9JL5zjc/lmXZTNllsO/KxUv1YrnOBTYcl1fPG2WA5/uprnvC6Dqp89y
kIlKsY7PQ/AjLIE2ZyP4skD5+xlzHFy6c57/BuovA7kvDWr+1FkO04D2PU+Z
47CnZLJEy+RZDj+CHy+VTp7jcGqh67ZioHtA3jIH+s80bpcnTz+CPz1PqPlA
D4JfCHSfctcsh4SnF5Sik6Hmt0Pcvyx1jkM/0D0xLVD3p0Plm2Y5WN/37xXP
hLq3AcEHmbe4HsEXA4ZXcN0sh6Adcq3ZQP+A6Nc1UHmgeaeB7v1cCQ0PoH98
zDsdH5RB/RePiC+weyIRfLC8LoIPcv9tDWh8lsxyYGuc6sytCvF/Tyk0fJUg
9mcDzQeGCtNqhTkQf5VD+NrycyDhWAVR/012jgMoGvyB7s2Y+LZmv8wcB5C1
1fXQ+JWBqJ/djMkH+W+6BNS/IZh8mHqw+yIRfHB8x0DjXwYa3vGzHJYAE1K4
3BwHjjUyUU8SoOEJdO+nS75JAkmzIOlWcY7DLaD6PUlQ/ypD5ZOh9qtAzQPy
84HJ4JQ6gg+OD10EH6w/AE0+eo4DAwgkQ9N7ItT9SVB+MjT/JEHSS34qNP4T
Ie59nQbNTwkQ/1xPh6ZPoP9AyfJUBjT8Ymc5PKwSWecOS1/RCD4oWM5HIvgg
5zSEQ/jHMxDh+wjET4fyg6Hhlw2Nv3xE/gUA84HrHg==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQ7WPe6fhg+yyHJQW2XNcnznFA4RfPcVg2+4iCwVkc
/Bw09Uj8D8uPeW83RPDzhZoPnNKe45AkEGG5ZQeUrz7HwRson7ALql51jsM6
94dVIntmOez25GFarTzHQZWtcarzvlkOf69UvFymNMeBT3fT3PcHEPxCoLXK
hxF8sPqjsxy028Vu+gH1R6VY3/c/DpVXmeNw2RfogpOzHLx4mLTZ1aDmnZrl
ANLGrTHH4dMloIIzsxzeg9yjNceBAQQuIPgg5cvPQvjmKlD3n4LaJz/HYcuJ
sn3yx6Dmy0D9f3CWw2qZqJTdEnMcgMrOle+d5QB0Va+4ONT+HQg+xxqZqCdb
EfyjChuKXmyaBVEnDnXPBoj8dEloeK2d5ZAHDE8vaaj6VbMc1oDsk4Wob1g5
y2Gac3fOcwWo+1bMcjj8VSOGXwVif/5yqPkaCD4w+LXb9RF8WPyC7Z+Jyf8H
DF+1gjkOOqDwmTPL4Ufw46WzCyH+SVkAta8Emn6WQM0vn+Owp2SyBMsKaHhV
Q+1bPcthF0hBPZS/bpYDMNWc+NYMDa/1sxwuKN3+WdcGjS9g+ID91Q2J7/Nb
EOkZAKNBR3U=
      "], CompressedData["
1:eJxlk31IU1EYxpdRG6UxZNOaWXMft81lOtBkaPSWhaREoH8kBiXDsvJjC0PC
IogKiQiKsOKcYxGV/SMKIRUhEhUlDUxCqGVla0mskGEfWkrZufe8dzfxj8vh
d8+9z3ne5z43yx+o2Juk0+k280teY5LXsFaicDO4YcmrZgYqb0tO8rQVa2zu
Lo1MexlU3F91ul7d9wj+yvnv8JGY5Mb9NRQ8bWnhQYmB31jly3dReCC/4GTQ
Eb/9tNxNQV4KHQzKC89sqsmm0JR68mGZncEhbuOGB/3YGPyqjN7KyNG4kz6x
5uVq3Hf44vJTXgrtJWcb6uz4fD764/r89uejBRTKOOuzGIz8Pn6w2ELhY6up
+5lZcJ95PqvzGLpWVn9KofCHc6cV59Wj3wwGV/kgoYUUikZ3nEtfweALz6tr
lkB4cKoymsagupbvzJCE/htZf1Jj2S+d0FjJe5yAc/GJ9pJ0zDNGRF4W1B8j
Is9MBt9ebvcbowSqfL0Dk1bUixDFz2WnyNP+gcD+C+PHNmaj3igR+eXN5Z0+
jZV5/Bor6z4Goetb735/T0TeBxgU7OZOOCv51jPoHWjpX/2OQEv/NUtPA4Mr
clAjRPSnEfMLE7gkf5gmBvx2q+k1EX0JMHDwuR8PE+Cx1xYFGWzhj828IOJ7
/MdqXxWOz+eInOf6uVy6jsFz7r95Av25cL4f6F/CPk4RqBkbsu3ifVqWc6cj
Po37ah9nNVb0F9AEK31fRMWcNtH3kEH0/Z4Dz0umMGTjTZOwD0YqznFr/VP0
cjVW3vdrnCkXqw7zMlGQ49rD8z//6KfrbSr+X43oj+vLdVoawL6koH4Q59HT
RL4qq3n+A8gN3Kg=
      "], CompressedData["
1:eJxlk19IU1Ecx8eIipKQiJSam38rsD0Ehcka/XJtYhGVe1A3dLq77d5cbWvm
JhpBlBhUD1HWwzkR0R8fCouIkBAL1AoDCQxEfJD+UTHChyDrJfqde37jQD6M
y2e/c8/5/jm3LJxsjFotFksd/sSzauXZQU8Tg4YCa/VAhkOeDyCvCnNY/dAW
+NzGIDt2a9OjJAd7f+7oSEytr8T14wnFjSP2/nha8dRt77OubgaDnovH9W4O
RXPTSzNZBn/f93zf0sVh/s+Zzj29DNY5n9xcTNH6Pga2QMQVSihurn36JhNX
XILzBYPDcP2H3mv4fkboi9H+PQyu43lfIxx++z/d24znmU+Nw6625w0FqGdx
6NXBGvSXcq+ZvZNWPHMoXNicUiz0jZ5g0P7lXXlQo/07pf77UQ5vUc9PnfTr
NI8ycC0cvlx0jPRGFJt+NcUir1wHk7mhn9FTV4vPt9Ncl3ovtVIe6Gdg49x0
NkD+QqovU0+LYnPuVCz0z2+jPpHF32urOJxE/xUtlG+5PH8F7o8pWR+UcsCW
dlwISq52cNAKcWWrXP+rhMNk6eP0txAD48qP0y9sso8NGvWLjGnW7tSXs/B3
o5j87l7O+fWmPrdis2+g/m2Udx2Du1hkk52DsN23n/JEvaKWIS8DdDfmKOOA
8S35feS3gsN2MffR+ZW0H3Jy/bmXU1sVm304FZvvH/lvHuRyHx/d9w7Sn2e8
Pw7x/XjlfUlGqX/Sm4vJvsY90s+sTvcT/SWEHoPy28cAUx6uz9+vvYonsA/D
rdjU5ZL82lD5fhSsE9dQfnHqz6++33+cMN26
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dKd8/z3zNkO1vf9e8VT5jhEpVjfP79otoMMkBFf
MMdB7Oa578FrZjt48jBpt5fNcTCN2+XZsw3BD9oh1/p6P4K/zv1hlcgJKL8I
op7nPJSfBeVfg/KToObdhNg/PRzB/7D8mPd2TwT/gtLtn3WWcxxeqhly6FyZ
7cCnu2luvg7E/uyTUPOUoPIHZjt4AfnsUnMcfMw7HR9sne3wqEpk3XFRqHmr
EPwkgQhLk6UI/rz3y4+dnj/bIWPi25r9YnMc5gL53rNmO/y9UvFymcQcB3Fg
eFyeMtvhe/DjpbOB5oPU2fdD3ScLNb9ztsOSAluucEUEf5ozMKDrEfw1oADu
gprfCfX/BAj/dMdshwjLLSe+TYLKd0DjY+ocB2CUMTS0Q/03Her/Nqj5QL43
0L8JrbMdHoL8M2OOw6dLvkkCLbMdQMaYz5zjAFJW3YTgg/3RgOCrsjVOda6b
7QCMJabVM6Dqq6HuA5r/A6heugqaXmZD5adC9S+b4wBLTzA+AIMzGks=
      
      "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQ7dKd8/z3zNkOH5Yf894eO8cBxv93peKlmvoch/5D
XzVi5s520G4Xu3lOeY7DBCD/zoLZDnlCzQe8FOc4OAPVVy+Z7WB93793uvwc
hx/Bj5dKr5jtELRDrvW17ByHqBTr++dXQ+TFZSHys9cj+IW2XNcXb0XwVdka
pzrvnu0wFWhwugLU/AOzHbx4mLTZge5ZNvuIwoajEPct053jMPc90OEnIO7z
M0fwwepdEPzyffOl1vsj9O/y5GFaHYEwP8Jyy4lvcQj7Mya+rbFPhfp/K9Q9
GXMcbv2sy9qzDsEHmWewGsF/pWbIsWb5bIcLSrd/1qXPcXgJ5OssgYYv0Dxg
kDM0LJztIAMMmPgUaHjNg8onIsIfFh8A5qbKcQ==
      "], CompressedData["
1:eJxVVHtMzWEYPjsbUii301XX00WndNGkneHFMIWGddHaSmod0UVSNDOGNTPD
XLL9XmvG6g9mZshkMcxp2dw3zB/JGIlSKKWa9/u+9/jmbOf327Pv973v8zzf
834hBeXriswmk2kD/cW7//nqAi9/hO9ND9OawxEajQfBV6YiPA19O7QnECGn
0N7xxAPhQsUC9yw/hCmxV8+WT0Tope+TfRFe0PbX4xDu/YrKPeqNsKsrIsHN
rNabLQgm8Rsz/mHa3ts0qHH7uWU3tvcbkP+ROvogpCUfWpzfY8DYy51dEbMQ
OmtnXF7xxQB6dtaGIDiOf9u96LMBt1ZOMtsiNZZ85vy/fjGRcZcB4vO6eYy7
DXhPdZ0pzI/6yT4LEQIPdq+9SXyk/iWsd8iA7JRrbdXLlT/xJlQ4FcHtUkBO
Ifljq7O8WZOO4PIzlfpNyNB4lPQ0ZmsstrVsRLjeVt3a4KvqDRQj1JdN23/X
wn5vQVhFfrybrnjfKWP/PLl/BQI9W4PcNX5Efv4YpzGVeXXezPXKNX97R/oR
71KEbWJ91ADRtr2E/R8xoKa1wS/OobH0pwihj/gfG2E/8zSWPuWi8vWPAfcp
D5457PewAaeWHt5aTPoLvIjZb1XPmYkQI/QMKH8HMljPT42l3j6NJd9eQ/r9
OJP97GE+VP921QmfA1+ZL/U/I4TReYu6DbkaC/31eRqLV2oR86F64/cR4xKV
j73Ex+Wf9GNY1QuqQhCxPEn+yv7VzH+yxkJv0kyN5bzQ+cv87mD+IXxelQhC
1qAVgeJhz6vg7ynnch5KeT5nq7lwOlT+PkQjnCZ/PxUxXxtK/h75Gsv5yNJY
+jNfYzm/cey3TeXTHs3zEcPfRyEIeutjOO8RnE/Cz2hexqyc51jOG2FiW+mg
uWwR8xim7pP0OF534XiNhd7sBI3DhZBE5hfGfs3l+bIqv2qSWL9V8Y9M5v2R
fB52xjaNXffdJpFHqrdZzJe/mot61uu08P0XrrHMe6jG8ryCuL838wvk8/JT
eQ0L4HskgDH1kXkL1veBi89fEjF2gg==
      "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/emSb5KA9ByH98uPeZvrzHGA8SMst5z45gflC85x
uKh0++c/rzkO69wfVk3hmuNQvm++lL7HHIetJ8r2zWef4+DJw6Td7jbHwdu8
0zGBaY7Dj+DHS2c7z3HYApL/N9uBrXGqc7cDVP7PbIclBbZc4bYQeflfsx12
gQywmuPAAAI/ZzsAdUmtN0Pwpzl35zw3QvBB5kvrzXE4orChKAOoH2yO1hyH
jIlva+z/zoa4Xw1qPsMcsH3XlaHqmec4PKwSWeeuBJVnR/CTBCIsTXgQ/MtA
798QmuNgfd+/d7oqInxg4QUAKJqM+Q==
      "], CompressedData["
1:eJxTTMoPSmViYGDQA2IQ/VLNkGNNzByHJQW2XNcnznFA4RfPcXDpznn+uxAH
PwdNPRL/w/Jj3tsNEfx8oeYDp7TnOACtZGiIhfLVIfI68VD1qnMcfMw7HR8k
zHHY7cnDtFp5jsOnS75JAslzHP5eqXi5TGmOw+2fdVl7UhF8Pt1Nc9+nI/hg
9VlzHLTbxW76AfX/CH68VDoHKq8yx6EQ6EzlvDkOXjxM2uxqUPPy5ziwNU51
5taY4zDh0FeNOwVzHN6D3KM1x2EukHG6BME/tdB1W3ERhG+uAnV/PtQ++TkO
QTvkWl9nQc2Xgfo/bY7DapmolN0ScxxUQRYlzXGwvu/fKy4OtT8WwV86+4jC
higEP1kgwnJLONSf4lD3hEDkp0tCwytwjkMeMDy9pKHq/ec4rAHZJwtR7+03
x2GaMzDiFKDu85njcPirRgy/CsR+Gx+o+RoIPjD4tdv1EXxY/M4D2W+Lyf8H
DF+1Amj4OELCfTYwnSwD+sfAFWpfCTT9eEDNL5/jEJViff+8DzS8qqH2Bcxx
2AVSUA/lB89xAPrqxLfmOQ63QOEF9P8FJaBMGzS+wuY4bDlRtk++G2pvJCI9
AwAU5VSd
      "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/VLNkENn0hyH98uPeZsvm+NweqHrts9TEHyxm+e+
B0+f47BGJirFeukch7kgiZlzHB5WiaxzXzzHIWPi2xr72XMctNvFbvotnONw
+2ddls2cOQ58upvmvp+H4P+7UvFSbQ6Cn/D0glL0TIT+CMstJ75NQ5gP5k9B
2H9R6fbPf5MQ7vPiYdJmB/Jh7ofxvc07HRP6EXyX7pznv3sQ+sH8LoT5e0om
S7B0Iuw3jdvlydOBcB+MD3M/jA/zH0w/zP8w82HhA1bXgwg/sH/6EeGLHv4A
bUXGzA==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dyd87x61hwHTx4m7fayOQ4w/vvlx7zNdRH8C0q3
f9apz3HwMe90fADkl++bL7VeeY7DKzVDjjWz5zg8qhJZd1xxjgPQSIaGOXMc
poE0ys9xAOrK2jN3joPIOveHVXJzHPoPfdWImQ+1T3aOw56SyRIsC+c4fA9+
vHS2DEQ/w5I5Dv+uVLxUA/LnghyyApNvfd+/d7rEHAcXoDW/qzH5MPV8upvm
5jcg+EE75Fqzm6HqofzXLXMcIiy3nCgDuufUQtdtxW1zHJYU2HKFy0H91z7H
IXPi25r9QP+Yxu3y7OmY4/AB6IztilD1nVC+MtQ8IJ+tcapztzqCDwtPGB8o
m5MegOA/BIafe9Qch60nyvbNB/J3AQNodQLEPp5OqHuT5ziAgnEKzP7UOQ4T
gOF5px0SH/rpUD7Q/V7A8GXPgPJb5zgkPAXGYAY0Plug9mXOcbgFip8mBJ9j
jUzUkwYEHxgM1xfXQfjHMxDhC47vdGi8VUHDK3uOww8gX3oaIj0BAMSpIsA=

      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQfURhQ1HGgzkOnjxM2u1lcxxu/6zLsnmH4EelWN/3
/znH4WGVyDr3wjkOupvmvl/OOBfMP54GET/OMddBu13s5rnYOQ6XfZMEInjm
QvQHI/jTnLtznrsj+GtkolJ2289x8DbvdEzgmusQYbnlRJn5HAeQMeVscx2A
tvaK689xMI3b5dnDNNfh/fJj3tvVIPar/53jMBVoXroC1F3f5jj8u1LxUk1m
jgPYP+/nQOwTh/hnz/M5Do9A7hSFqr+P4H+85Js04SKCrwPy37E5DhkT39bY
S89xAJpq2LFvDth+c6D9y2YDbdg+B+Jefah5W+Y4LCmw5bpuicoPd0XwdwMD
ZLUv1P/bIPq/hUL9uwtqftwcB6Cp++YD7bugBHQ5MHzB4XAEKp4D0X/jFER8
esEch60gcaD72RqBIVICia/zNxDxhx6/AJIP6lo=
      "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQfdk3SSDi7hwHLx4mbfaCOQ7z3i8/dvomgp8x8W2N
/bU5DqLr3B/+ypvjINf6OnDHpTkO05y7c57nzHF4qWbIoXN+joN2u9jNc1lz
HOYC9XufmePw70rFS7X0OQ7W9/17xU9B1SfOcfAx73R8cHyOw1+g/LKYOQ4P
q0TWHT8GlQ9F8EH6l/ki+FOB8ukOcxyCdsi1Zp+c4xBhueXENxOoe87NcVhS
YMsVrj3HgQEErsxx+AB0xnbFOQ4gZ32/BTVfBuKe6Y8RfNO4XZ48rxD8/kNf
NWLez3FgawTaKD/HAegLw47PEPOvq8xxWDb7iMKG73McgLqYtLXmODwCue/n
HIc8oeYDXsYIPigYzB0QfLC7A6Dh8w2qP3aOAzj830P8U5Y2xwFI7pv/Cmpf
DpT/BBEf6PEFAH//2LE=
      "], CompressedData["
1:eJxllG1Ik1EUx4cfQkwiYuhib+2FLTChIDOZ5okZMqaIm+Uaq8Y23dqW0zIR
iygqJCwqygq8t4jevogfIjJEIgoqFkREMHqBsj6IRRRBWUTRuc9zHm61D+PZ
j3uee8//f/7PtcVyga4SnU4XwJ948k/X7j9azQEf/to4g/zFDTd3NXLwvG47
VtnLoK+hrHDJx8FXXlI1PMDg+N2vyyNByeEEVoYkTzTPDJ2OcJgZ0k8072Yw
51pVuiKq8oOdDM71LDl4J07ruP988N2VsW4OU2KDLIMXP/alp1McQnU3Hg50
M3iJXJ/m8MSO/2IMmkaysz+RR70j2WRE8u9ng3OuDsmKnmrJgVuWwxk3g0XV
13kuQ/s5SE+WzrMx+PK0NbZ4B4cctpm30vk9HPRCmIXBCax/lSO9ZgbYxuye
Pq7qMDFAS3X7+6kfZHHuh8FiFv6eNTA4L/z3F7NW/x79G2/97/12yS21R9a/
6eAgbM0j12yd8h3dRPPDflMnP+5tDJF+K+nfzOFyb0NZJ+r9jn0bwyoX0I/S
cVM4obGT9gur/nxzS9b81VjpPyDZLIIRpjzheWeEUVEGIm/+Tg6/sP+rCQbo
+m3rRppnivxsp3ykaT4tkpX1Jsni/Qv11F+Xur/Is6Jvi2StX40XHBj1LnSr
+XbUcBCyPQ6aL/JbkVf0x4mF99ZwqBqueP7YquorX8tBlG+z0HzqKD9m0uch
P0yU73VyXsLvMW8xa/NX9FUUs1avsOHf941myUpel5F+M+mxcfiMbU1i/9P9
pwyHHJQPO/nrpPNckjW//l6vbJOs+Bem86l+Mkp6tP3jtO6g7w3ngy7OB+1c
nXuS/LLR/JKUV+q/kKJ8W2je2+k+MUtW3jdKVr7fpXTfpKR/yjyTdB/oyZ8M
ra+U95eWD43/AAevZh8=
      "], CompressedData["
1:eJxllGtIVEEYhsUfERXVD6/kpbbMJAwEw0SjD1RCRMIVU9Si1NhMUXPNQiII
tFVWcze1pZxRYr1UyiabN1QSlEoSxDAI64fYBQsJi0grSZo5512G6Mdy9uF8
M/O97/fO2ZNXajzn7eXllSF+8uk6vljVPMopeZv3QUslIw9nxfZPVWYyCtt0
vSVhWHFozXLa8ACnle5nKTFnGVn85mcuuzl1lB3d8trEaKyiKaDapXNmEaO4
hRMNjoecgrML4hZKsH8npz+vrnzuKmP04l7SoLldsf/8zNrcXcWy3sfByTgc
UlNUyihvZ1ZsdLP