Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Harmonics",
 FontSlant->"Italic",
 FontColor->RGBColor[
  1, 0, 0]]], "Title",ExpressionUUID->"810662b0-0077-488f-a161-2712071798ec"],

Cell[TextData[StyleBox["Tensor harmonics on the 2-sphere",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subtitle",ExpressionUUID->"4e9713d5-c1ba-41a1-aa9e-91f0ddfde6dd"],

Cell[TextData[{
 "David Brizuela, Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a and Guillermo \
A. Mena Marug\[AAcute]n\n",
 StyleBox["Instituto de Estructura de la Materia, CSIC, Madrid\n\n(c) \
2005-2026, under GPL\n\njose@xact.es\n\nhttp://www.xact.es/\n\n\
http://groups.google.com/group/xAct",
  FontSize->16],
 "\n"
}], "Subsubtitle",
 FontSize->18,ExpressionUUID->"ff6feb4b-eb2d-4e95-822f-9d0e4f384dcb"],

Cell[TextData[{
 "October 2005 -- May 2006.\n",
 StyleBox["August 2007: Notebook adapted for version 0.9.2 of xAct.\nNovember \
2007: Notebook adapted for version 0.9.3 of xAct.\nJuly 2009: Notebook \
adapted for version 0.9.9 of xAct.",
  FontSize->12]
}], "Subsubtitle",
 FontSize->18,ExpressionUUID->"83278772-8fc8-432d-a525-918b9339d546"],

Cell[TextData[{
 "This notebook defines different forms of the tensor harmonics on the sphere \
S^2. It requires the package ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " for abstract computations and its twin package ",
 StyleBox["xCoba",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " for component computations.\n\nThe package ",
 StyleBox["Harmonics",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is distributed under the GNU GPL License."
}], "Text",ExpressionUUID->"d5e5f98d-af4a-4716-99c2-860ed7f54adb"],

Cell[CellGroupData[{

Cell[BoxData["Today"], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"920fdcbf-d7d2-42dd-985d-6c5b9a1b35e2"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Mon 29 Dec 2025\""}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{"2025", ",", "12", ",", "29"}], "}"}], ",", "\"Day\""}], 
     "]"}]},
  "DateObject",
  Editable->False]], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"7163cd83-60df-4a1d-bc67-9f2b30b6d896"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`Harmonics`$Version", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<0.7.2\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2014", ",", "2", ",", "15"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[2]:=",ExpressionUUID->"02640418-1055-4d26-bedb-1d9574c184ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0.7.2\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2014", ",", "2", ",", "15"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",ExpressionUUID->"bdaa3b34-7dda-4ea1-a12d-ba7bf7999e8c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Initialization", \
"Subsection",ExpressionUUID->"ce0b06a2-f8c0-4c62-8f0a-ba0692eb8780"],

Cell[CellGroupData[{

Cell["1.1. GPL", \
"Subsubsection",ExpressionUUID->"3da923ca-1851-4b18-a47c-c28ffaa61ad4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Harmonics", ",", " ", 
    RowBox[{
    "a", " ", "free", " ", "package", " ", "for", " ", "tensor", " ", 
     "computations", " ", "with", " ", "tensor", " ", "harmonics", " ", "in", 
     " ", "Mathematica"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Copyright", " ", 
      RowBox[{"(", "C", ")"}], " ", "2005"}], "-", 
     RowBox[{"2026", " ", "David", " ", "Brizuela"}]}], ",", " ", 
    RowBox[{
     RowBox[{"Jose", " ", 
      RowBox[{"M", ".", " ", "Martin"}]}], "-", 
     RowBox[{"Garcia", " ", "and", " ", "Guillermo", " ", 
      RowBox[{"A", ".", " ", "Mena"}], " ", "Marugan"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", " ", "it", " ", "under", " ",
       "the", " ", "terms", " ", "of", " ", "the", " ", "GNU", " ", "General",
       " ", "Public", " ", "License", " ", "as", " ", "published", " ", "by", 
      " ", "the", " ", "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], " ",
      "program", " ", "is", " ", "distributed", " ", "in", " ", "the", " ", 
     "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", "useful"}], 
    ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", " ", "MERCHANTABILITY", " ", "or", " ", "FITNESS", " ", "FOR", " ",
       "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", " ", 
      "General", " ", "Public", " ", "License", " ", "for", " ", "more", " ", 
      
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], " ",
       "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ", 
      "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", " ", "along", " ", "with", " ", "this", " ", "program"}], ";",
      " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", " ", 
     "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", " ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"491aa8d2-f1c9-4901-8087-d9e317e1931f"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Info package", \
"Subsubsection",ExpressionUUID->"2341e1e5-0a60-4b22-9579-33ca0601d7d3"],

Cell["\<\
(* :Title: Harmonics *)

(* :Author: David Brizuela, Jose M. Martin-Garcia and Guillermo A. Mena \
Marugan *)

(* :Summary: Free package for computations with tensor harmonics *)

(* :Brief Discussion:
   - TO FILL IN
*)
  
(* :Context: xAct`Harmonics` *)

(* :Package Version: 0.7.2 *)

(* :Copyright: David Brizuela, Jose M. Martin-Garcia and Guillermo A. Mena \
Marugan (2005-2026) *)

(* :History: see Harmonics.History *)

(* :Keywords: *)

(* :Source: Harmonics.nb *)

(* :Warning: *)

(* :Mathematica Version: 5.0 and later *)

(* :Limitations: *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellLabel->"In[3]:=",ExpressionUUID->"f592969c-ff59-4597-bf11-cd6cc3ddc721"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. BeginPackage", \
"Subsubsection",ExpressionUUID->"a8906679-9c3a-4ec4-92fa-a841ffd2e95b"],

Cell["Protect against multiple loading of the package:", \
"Text",ExpressionUUID->"539ed533-27b2-4c7c-93a2-5e23d08456b0"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xAct`Harmonics`Private`HarmonicsSymbols", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Names", "[", "\"\<xAct`Harmonics`*\>\"", "]"}], ",", 
         RowBox[{"Names", "[", "\"\<xAct`Harmonics`Private`*\>\"", "]"}]}], 
        "]"}], ",", 
       RowBox[{"\"\<$Version\>\"", "|", "\"\<xAct`Harmonics`$Version\>\"", 
        "|", "\"\<$HarmonicsVersionExpected\>\"", 
        "|", "\"\<xAct`Harmonics`$xTensorVersionExpected\>\""}]}], "]"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "/@", "xAct`Harmonics`Private`HarmonicsSymbols"}], ";",
     "\[IndentingNewLine]", 
    RowBox[{"Clear", "/@", "xAct`Harmonics`Private`HarmonicsSymbols"}], 
    ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[28]:=",ExpressionUUID->"6b628745-9c41-4fff-b98a-784093dd3d7e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`Harmonics`\>\""}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[29]:=",ExpressionUUID->"de5d3e4a-5934-4939-b0ad-6d4c42f0fb87"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"fc288778-7d8c-4863-963d-82793f730d58"],

Cell[BoxData["\<\"xAct`Harmonics`\"\>"], "Output",
 CellLabel->
  "Out[30]=",ExpressionUUID->"087d6fb9-5967-4898-a68b-6a98633bb270"]
}, Open  ]],

Cell[TextData[{
 "Explicit (not hidden) import of ",
 StyleBox["xCoba",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", ",
 StyleBox["xPerm",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " and ",
 StyleBox["xCore",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ":"
}], "Text",ExpressionUUID->"55371074-ddba-4b44-a235-5ab37d1599f7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`Harmonics`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<xAct`xCoba`\>\"", ",", "\"\<xAct`xTensor`\>\"", 
     ",", "\"\<xAct`xPerm`\>\"", ",", "\"\<xAct`xCore`\>\""}], "}"}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[31]:=",ExpressionUUID->"a3f77cdf-cb55-4a5b-bd02-6d13e6b386a9"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"5a61e4fd-ff0e-45aa-b036-7f7531de5830"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.4", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"c60c5b2b-cfa1-4da8-bcc6-122be93445ce"],

Cell[BoxData["\<\"CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"1291ff0c-f90a-4eb6-9dea-0f34ddd1b579"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"483a4127-1d2b-4ebe-ad2a-9ebbbfac1e33"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"09333f70-f9d2-49b7-aef4-ab772e7c4760"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"04185c51-9c56-4b11-8fce-f8b0e3d4feba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.3.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.3.0", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"0d1f55a4-1030-4831-a82e-755536812622"],

Cell[BoxData["\<\"CopyRight (C) 2002-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"65ef89ee-0042-4fa1-adfa-ba8e34c11dfe"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"93978a23-ccc1-4ee4-8147-688ea8ce6211"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.6", ", ", {2021, 2, 28}],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"35cae1b6-a538-4cb7-8e9f-52dd7b5524c7"],

Cell[BoxData["\<\"CopyRight (C) 2005-2026, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"1134d651-146f-4fbe-a562-79f80aaf71c0"]
}, Open  ]],

Cell[BoxData["\<\"xAct`Harmonics`\"\>"], "Output",
 CellLabel->
  "Out[31]=",ExpressionUUID->"2520b964-67e5-4d34-9ecd-1e6f49d36fcd"]
}, Open  ]],

Cell["Welcome message:", \
"Text",ExpressionUUID->"118764eb-612f-452a-93a5-beb1201d0f5a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`Harmonics`  version \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", "\"\<CopyRight (C) 2005-2026, David Brizuela, Jose M. \
Martin-Garcia and Guillermo A. Mena Marugan, under the General Public \
License.\>\"", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[32]:=",ExpressionUUID->"042889fb-cb41-454d-8e36-d48de0915c2a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"934452a8-cce2-46c7-af2e-26cf8032c95a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Harmonics`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.7.2\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2014", ",", "2", ",", "15"}], "}"}]}],
  SequenceForm[
  "Package xAct`Harmonics`  version ", "0.7.2", ", ", {2014, 2, 15}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"96395971-ecc7-4170-a370-ab7fbb1d0cff"],

Cell[BoxData["\<\"CopyRight (C) 2005-2026, David Brizuela, Jose M. \
Martin-Garcia and Guillermo A. Mena Marugan, under the General Public \
License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"b6561f99-38c2-44e2-8a4a-15ea1ad18f6f"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We specify the context xAct`Harmonics` to avoid overriding the Disclaimer of \
the other packages. However we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"7153f7da-cf1b-419a-a417-0f02d1c8078b"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`Harmonics`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[35]:=",ExpressionUUID->"91839170-5335-4037-9174-adf6a1f4fb97"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`Harmonics`\>\""}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", "\"\<These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\>\"", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[38]:=",ExpressionUUID->"441744d2-5422-43a2-be61-f21a3fb556c5"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[38]:=",ExpressionUUID->"b2b6a7db-07f9-49c8-936e-b5013a3ef38c"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[38]:=",ExpressionUUID->"5cccec0c-e260-4e96-9007-8343f1131a37"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[38]:=",ExpressionUUID->"a87bdd2f-df9d-43b4-90fe-e793b02226d9"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Eliminate annoying spell messages (this is now included in ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 "):"
}], "Text",ExpressionUUID->"cf13db2c-b5d2-41c1-a4ee-dda4c279b208"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell1"}], "]"}]}], "Input",
 CellLabel->
  "In[39]:=",ExpressionUUID->"44b40075-06f6-4ce4-9ae1-aac9e41f0050"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. Set up", \
"Subsubsection",ExpressionUUID->"fe8cca9b-461a-4a7b-8e93-1c8816ee9787"],

Cell["Screen all dollar indicess:", \
"Text",ExpressionUUID->"3c455e49-d566-4241-87f5-3e0ad7405052"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSet", "[", 
   RowBox[{"$PrePrint", ",", "ScreenDollarIndices"}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6c0fb6a8-92df-4e38-b46a-9291bd9c8d08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$PrePrint", 
   "\[InvisibleSpace]", "\<\" assigned value \"\>", "\[InvisibleSpace]", 
   "ScreenDollarIndices"}],
  SequenceForm[
  "** Variable ", $PrePrint, " assigned value ", 
   xAct`xTensor`ScreenDollarIndices],
  Editable->
   False]], "Print",ExpressionUUID->"52306391-b8fd-42b7-9f84-b47c7bde00e9"]
}, Open  ]],

Cell["Postfix format for derivatives:", \
"Text",ExpressionUUID->"b5b79a36-f2c0-4bc5-ab01-915d026a260a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSet", "[", 
   RowBox[{"$CovDFormat", ",", "\"\<Postfix\>\""}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"48c3e120-7a1e-4ad6-8ac9-99bf9b8cb0d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$CovDFormat", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", 
   "\[InvisibleSpace]", "\<\"Prefix\"\>", "\[InvisibleSpace]", "\<\" to \"\>",
    "\[InvisibleSpace]", "\<\"Postfix\"\>"}],
  SequenceForm[
  "** Variable ", xAct`xTensor`$CovDFormat, " changed from ", "Prefix", 
   " to ", "Postfix"],
  Editable->
   False]], "Print",ExpressionUUID->"3a055f59-1740-44c5-86a0-4ed5f339117e"]
}, Open  ]],

Cell["\<\
In this notebooks we shall allow metric contractions everywhere:\
\>", "Text",ExpressionUUID->"f663764a-36cc-414c-915e-2e5c4cab1e36"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"ContractMetric", ",", 
    RowBox[{"AllowUpperDerivatives", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e7909eb5-8086-4573-aa45-38ab9231895d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->
   False]], "Print",ExpressionUUID->"893222e8-a7a4-40bd-ad9a-6055e9813662"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"MakeRule", ",", 
    RowBox[{"MetricOn", "\[Rule]", "All"}]}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"11f3c141-4886-469b-8dbf-e1ad5ce87625"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "MetricOn", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "MakeRule", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "None",
    "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "All"}],
  SequenceForm[
  "** Option ", xAct`xTensor`MetricOn, " of ", xAct`xTensor`MakeRule, 
   " changed from ", None, " to ", All],
  Editable->
   False]], "Print",ExpressionUUID->"25d9c6f0-eab9-4fd5-a0c3-9a0c8fc3be36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"MakeRule", ",", 
    RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"eaf18370-59cc-4b9f-83d0-8ea3625a7401"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "ContractMetrics", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "MakeRule", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`ContractMetrics, " of ", xAct`xTensor`MakeRule, 
   " changed from ", False, " to ", True],
  Editable->
   False]], "Print",ExpressionUUID->"9ec61ed3-9945-43f6-bc61-c4635dccc8f1"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5. Usage messages", \
"Subsubsection",ExpressionUUID->"3f3b7f5f-f7ed-492b-badc-e4dd690e018b"],

Cell["This is the only angular function we really need:", \
"Text",ExpressionUUID->"3c738853-725b-41fc-8a7d-5d1d5f432d93"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"calDEdmonds", "::", "usage"}], 
   "=", "\"\<calDEdmonds[j, mp, m][\[Alpha], \[Beta], \[Gamma]] computes the \
Wigner matrix with labels j, mp and m for the SO(3) rotation described by \
Euler angles \[Alpha], \[Beta], \[Gamma], as given by Edmonds. Note that \
other authors use a different convention for this function.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"calD", "::", "usage"}], 
   "=", "\"\<calD[LI[l], LI[mp], LI[m]] is the formal scalar denoting the \
Wigner matrix. It can be transformed into actual functions of the spherical \
angles using the rule calDRule.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"calDRule", "::", "usage"}], 
   "=", "\"\<calDRule transforms the calD scalar into the function \
calDEdmonds with Euler angles \[Alpha]=0, \[Beta]=\[Theta], \
\[Gamma]=\[Phi].\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c3c0f626-eb38-4349-8c28-8d39a17ecdaf"],

Cell["The manifold:", \
"Text",ExpressionUUID->"66bfc58e-190a-4a62-82c9-d8b9772a762a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"S2", "::", "usage"}], 
   "=", "\"\<The package Harmonics constructs the 2-sphere S2 with indices \
IndexList[a, b, c, d, e, f] and ultraindex uS2, and its tangent vbundle \
TangentS2.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TangentS2", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"c", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uS2", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"etaUpS2", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"etaDownS2", "::", "usage"}], "=", 
   RowBox[{"S2", "::", "usage"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f4caf0e3-56ed-429d-b82c-bec82dbb38fa"],

Cell["The metric on the manifold:", \
"Text",ExpressionUUID->"ddc38e09-36cc-4172-a17f-b0eae32aaef1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gamma", "::", "usage"}], 
   "=", "\"\<The package Harmonics defines the metric gamma (prints as \
\[Gamma]) on the 2-sphere S2. Its Levi-Civita connection is cd, with \
associated tensors Riemanncd, Riccicd, RicciScalarcd = 2, and vanishing \
Torsioncd, Einsteincd and Weylcd. There is also the Christoffelcd connection \
cd with PD, the antisymmetric tensor epsilongamma, and the absolute value of \
the determinant AbsDetgamma in the DefaultChart.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cd", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Riemanncd", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Riccicd", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RicciScalarcd", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Torsioncd", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Einsteincd", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Weylcd", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Christoffelcd", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"epsilongamma", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AbsDetgamma", "::", "usage"}], "=", 
   RowBox[{"gamma", "::", "usage"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"2a28a83c-235c-4c83-ac0b-e07c3deb8e0c"],

Cell["The spherical chart:", \
"Text",ExpressionUUID->"922ea199-26c6-4b41-b1a7-5e87b6bab5a6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"spherical", "::", "usage"}], 
   "=", "\"\<The package Harmonics defines the chart spherical on the \
2-sphere S2 and assigns values to the components of the metric tensors in \
this chart. The coordinate fields are called \[Theta][] and \[Phi][]. The \
associated parallel (partial) derivative is called PDspherical. The \
associated\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "::", "usage"}], "=", 
   RowBox[{"spherical", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "::", "usage"}], "=", 
   RowBox[{"spherical", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PDspherical", "::", "usage"}], "=", 
   RowBox[{"spherical", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TorsionPDspherical", "::", "usage"}], "=", 
   RowBox[{"spherical", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChristoffelPDspherical", "::", "usage"}], "=", 
   RowBox[{"spherical", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannPDspherical", "::", "usage"}], "=", 
   RowBox[{"spherical", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RicciPDspherical", "::", "usage"}], "=", 
   RowBox[{"spherical", "::", "usage"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a1602bdf-81fc-4213-89cc-95b5ebc342f9"],

Cell["Complex basis vectors:", \
"Text",ExpressionUUID->"27f8a5a6-3b81-4015-a698-b1d7d19eaefc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"m", "::", "usage"}], 
   "=", "\"\<m[a] and mbar[a] are the complex Newman-Penrose vectors on the \
2-sphere. They are null vectors.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mbar", "::", "usage"}], "=", 
   RowBox[{"m", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mmbarRule", "::", "usage"}], 
   "=", "\"\<mmbarRule transforms the product of one m[a] and one mbar[b] \
vectors into a sum of a gamma[a,b] object and epsilongamma[a,b] with suitable \
coefficients.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f7ccfdb6-86a2-4c3d-b0a6-1743922e32ef"],

Cell["STF harmonics:", \
"Text",ExpressionUUID->"2b5053d0-440b-4d09-bd16-cbf348f6379d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Z", "::", "usage"}], 
   "=", "\"\<Z[LI[l], LI[m], a1, a2, ..., as] represents the polar \
generalized-GS tensor harmonics with labels l, m, and s indices.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"X", "::", "usage"}], 
   "=", "\"\<X[LI[l], LI[m], a1, a2, ..., as] represents the axial \
generalized-GS tensor harmonics with labels l, m, and s indices.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"calZ", "::", "usage"}], 
   "=", "\"\<calZ[LI[sign], LI[l], LI[m], a1, a2, ..., as] is a combined \
notation for the generalized-GS tensor harmonics. For sign=1 calZ = Z and for \
sign=-1 calZ = -I*X.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZToX", "::", "usage"}], 
   "=", "\"\<ZToX and XToZ are rules which transform the Z tensor harmonics \
into X harmonics and viceversa, respectively.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"XToZ", "::", "usage"}], "=", 
   RowBox[{"ZToX", "::", "usage"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dropepsilon", "::", "usage"}], 
   "=", "\"\<Dropepsilon is a rule which contracts epsilongamma with the \
tensor harmonics Z and X.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeffK", "::", "usage"}], 
   "=", "\"\<coeffK[l, s] is the normalization factor for pure-spin \
harmonics.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PureSpin", "::", "usage"}], 
   "=", "\"\<PureSpin[l, sign, m][a1, ..., as] returns the pure-spin harmonic \
as a product of coeffK, calD and a number of complex NP vectors.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZXToY", "::", "usage"}], 
   "=", "\"\<ZXToY is a rule which transforms the Z and X harmonics into \
PureSpin harmonics.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Orbitalt", "::", "usage"}], 
   "=", "\"\<Orbitalt[LI[m], a] are the complex Cartesian vectors. \
Orbitalt[LI[m], a1, ..., as] are the complex Cartesian tensors obtained by \
combination of the former.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PureOrbital", "::", "usage"}], 
   "=", "\"\<PureOrbital[j, l, m][a1, ..., as] returns the pure-orbital \
harmonic with labels j, l, m and s indices.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0dc069ba-2e98-461a-98be-cef1c18753dd"],

Cell["Computation of components:", \
"Text",ExpressionUUID->"f4c5f296-eb04-4829-b060-100f7157f03b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HarmonicComponent", "::", "usage"}], 
   "=", "\"\<HarmonicComponent[expr] returns the scalar expression as a \
function of the coordinates \[Theta][] and \[Phi][].\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f0f2b871-f9a5-40da-9443-967a94bf88c4"],

Cell["Products of harmonics:", \
"Text",ExpressionUUID->"baeed1c8-69a2-443d-baed-ebb79d3b6cb5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"coeffE", "::", "usage"}], 
   "=", "\"\<coeffE[{l1, s1, m1}, {l2, s2, m2}, l] is the formal coefficient \
E in the expansion of a product of two tensor harmonics. It can be evaluated \
using the coeffERule.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeffERule", "::", "usage"}], 
   "=", "\"\<coeffERule is a rule which evaluates the numerical value of the \
E coefficients.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductRule", "::", "usage"}], 
   "=", "\"\<ProductRule is a rule which expands the product of two tensor \
harmonics with integer labels.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FormalProductRule", "::", "usage"}], 
   "=", "\"\<FormalProductRule[l] is a rule which expresses the product of \
two tensor harmonics with non-integer labels, using l as last argument of the \
coefficients E.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f83f8bca-2e0e-46a6-b026-71974d62ecdc"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.6. Begin private", \
"Subsubsection",ExpressionUUID->"6141ebf8-3302-4792-9968-e9c59abdd9e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e2cfbd4f-4d01-499e-b1b6-c08177ee09d3"],

Cell[BoxData["\<\"xAct`Harmonics`Private`\"\>"], \
"Output",ExpressionUUID->"252abd5d-ccb9-4ff0-9f34-c6014500af94"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`Harmonics`*\>\"", 
  "]"}]], "Input",ExpressionUUID->"bdc8e611-281d-4f4a-8662-1900bde6e879"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"AbsDetgamma\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"c\"\>", ",", "\<\"calD\"\>", ",", "\<\"calDEdmonds\"\>", 
   ",", "\<\"calDRule\"\>", ",", "\<\"calZ\"\>", ",", "\<\"cd\"\>", 
   ",", "\<\"Christoffelcd\"\>", ",", "\<\"ChristoffelPDspherical\"\>", 
   ",", "\<\"coeffE\"\>", ",", "\<\"coeffERule\"\>", ",", "\<\"coeffK\"\>", 
   ",", "\<\"d\"\>", ",", "\<\"Disclaimer\"\>", ",", "\<\"Dropepsilon\"\>", 
   ",", "\<\"e\"\>", ",", "\<\"Einsteincd\"\>", ",", "\<\"epsilongamma\"\>", 
   ",", "\<\"etaDownS2\"\>", ",", "\<\"etaUpS2\"\>", ",", "\<\"f\"\>", 
   ",", "\<\"FormalProductRule\"\>", ",", "\<\"gamma\"\>", 
   ",", "\<\"HarmonicComponent\"\>", ",", "\<\"m\"\>", ",", "\<\"mbar\"\>", 
   ",", "\<\"mmbarRule\"\>", ",", "\<\"Orbitalt\"\>", 
   ",", "\<\"PDspherical\"\>", ",", "\<\"ProductRule\"\>", 
   ",", "\<\"PureOrbital\"\>", ",", "\<\"PureSpin\"\>", 
   ",", "\<\"Riccicd\"\>", ",", "\<\"RicciPDspherical\"\>", 
   ",", "\<\"RicciScalarcd\"\>", ",", "\<\"Riemanncd\"\>", 
   ",", "\<\"RiemannPDspherical\"\>", ",", "\<\"S2\"\>", 
   ",", "\<\"spherical\"\>", ",", "\<\"TangentS2\"\>", 
   ",", "\<\"Torsioncd\"\>", ",", "\<\"TorsionPDspherical\"\>", 
   ",", "\<\"uS2\"\>", ",", "\<\"Weylcd\"\>", ",", "\<\"X\"\>", 
   ",", "\<\"XToZ\"\>", ",", "\<\"Z\"\>", ",", "\<\"ZToX\"\>", 
   ",", "\<\"ZXToY\"\>", ",", "\<\"\[Theta]\"\>", ",", "\<\"\[Phi]\"\>", 
   ",", "\<\"$Version\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"6465e7d6-8a1a-42d5-aa74-ddf8d8c8a139"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "Length"}]], "Input",ExpressionUUID->"057b8345-aec3-4baf-820f-fdd3477d8fe5"],

Cell[BoxData["54"], \
"Output",ExpressionUUID->"d340b00d-c785-4430-8347-ba97b149424a"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2. Conventions for the angular functions", \
"Subsection",ExpressionUUID->"f1f2b0d0-d73d-4093-be7c-3784b73d4d99"],

Cell["\<\
There are several conventions in the literature for the functions which are \
used in the description of the rotation group.\
\>", "Text",ExpressionUUID->"474de33b-933c-4276-87a4-de703b82883d"],

Cell[TextData[{
 "The choice of spherical harmonics is now almost universal. From ",
 StyleBox["Mathematica'",
  FontSlant->"Italic"],
 "s help:\n\nFor ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["l", "TI"], "\[GreaterEqual]", "0"}], TraditionalForm]], 
  "InlineFormula",ExpressionUUID->"309b5a84-92a3-45a3-a645-8518a0594155"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox[
     StyleBox["Y", "TI"], 
     StyleBox["l", "TI"], 
     StyleBox["m", "TI"]], 
    RowBox[{"(", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], "=", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", 
        StyleBox["l", "TI"], "+", "1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "\[Pi]"}], ")"}]}]], 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        StyleBox["l", "TI"], "-", 
        StyleBox["m", "TI"]}], ")"}], "!", "/", 
      RowBox[{"(", 
       RowBox[{
        StyleBox["l", "TI"], "+", 
        StyleBox["m", "TI"]}], ")"}], "!"}]], 
    SubsuperscriptBox[
     StyleBox["P", "TI"], 
     StyleBox["l", "TI"], 
     StyleBox["m", "TI"]], 
    RowBox[{"(", 
     RowBox[{"cos", "(", "\[Theta]", ")"}], ")"}], 
    SuperscriptBox[
     StyleBox["e", "TI"], 
     RowBox[{
      StyleBox["i", "TI"], 
      StyleBox["m", "TI"], "\[Phi]"}]]}], TraditionalForm]], "InlineFormula",
  ExpressionUUID->"04e682a0-c58f-4cd7-bc51-5ee612bba988"],
 " where ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox[
    StyleBox["P", "TI"], 
    StyleBox["l", "TI"], 
    StyleBox["m", "TI"]], TraditionalForm]], "InlineFormula",ExpressionUUID->
  "917d68e9-4265-46f8-9e5b-c8d715a694c5"],
 " is the associated Legendre function: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox[
      StyleBox["P", "TI"], 
      StyleBox["l", "TI"], 
      StyleBox["m", "TI"]], 
     RowBox[{"(", 
      StyleBox["x", "TI"], ")"}]}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       StyleBox["m", "TI"]], "/", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["2", "l"], 
        RowBox[{"l", "!"}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         StyleBox["x", "TI"], "2"]}], ")"}], 
      RowBox[{
       StyleBox["m", "TI"], "/", "2"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         StyleBox["d", "TI"], 
         RowBox[{"l", "+", 
          StyleBox["m", "TI"]}]], "/", 
        StyleBox["d", "TI"]}], 
       SuperscriptBox[
        StyleBox["x", "TI"], 
        RowBox[{"l", "+", 
         StyleBox["m", "TI"]}]]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         StyleBox["x", "TI"], "2"], "-", "1"}], ")"}], "l"]}]}], 
   TraditionalForm]], "InlineFormula",ExpressionUUID->
  "d5a9a972-ab46-42db-97d4-f307103d6dff"],
 "\n\nNote the phase ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    StyleBox["m", "TI"]], TraditionalForm]], "InlineFormula",ExpressionUUID->
  "49f60b05-a621-40a9-a4a9-9c2d5107b407"],
 " (so-called Condon-Shortley phase) in the Legendre polynomial. Edmonds does \
not use that phase (Edmonds 2.5.17), but later on he compensates that with \
the definition of spherical harmonics (Edmonds 2.5.29). Therefore the \
definitions for ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox[
    StyleBox["Y", "TI"], 
    StyleBox["l", "TI"], 
    StyleBox["m", "TI"]], TraditionalForm]], "InlineFormula",ExpressionUUID->
  "7f49b489-34f0-4772-bc7c-71d0a07f156f"],
 "of Edmonds, Galindo-Pascual and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " all coincide."
}], "Text",ExpressionUUID->"112b397e-b203-4d9b-ab23-6ce8f623f8e0"],

Cell["\<\
For the representation matrices we use Edmonds' convention. Note that \
\[Alpha]=0, \[Beta]=\[Theta] and \[Gamma]=\[Phi]. Note also that his equation \
(4.1.12) contains a mistake: angles \[Alpha] and \[Gamma] must be exchanged \
(this error has been previously pointed our for example in PhysRev A 18 \
(1978) 392, appendix B):\
\>", "Text",ExpressionUUID->"d48598a5-a446-420b-8fdd-7520f2e1e448"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dEdmonds", "[", 
    RowBox[{"j_", ",", "mp_", ",", "m_"}], "]"}], "[", "\[Beta]_", "]"}], ":=", 
  RowBox[{"0", "/;", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", "mp", "]"}], ">", "j"}], "||", 
    RowBox[{
     RowBox[{"Abs", "[", "m", "]"}], ">", 
     "j"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dEdmonds", "[", 
    RowBox[{"j_", ",", "mp_", ",", "m_"}], "]"}], "[", "\[Beta]_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j", "+", "mp"}], ")"}], "!"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j", "-", "mp"}], ")"}], "!"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j", "+", "m"}], ")"}], "!"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j", "-", "m"}], ")"}], "!"}]}], "]"}], 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"j", "-", "mp", "-", "\[Sigma]"}], ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"j", "-", "mp", "-", "\[Sigma]"}], ")"}], "!"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"j", "-", "m", "-", "\[Sigma]"}], ")"}], "!"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"mp", "+", "m", "+", "\[Sigma]"}], ")"}], "!"}], 
         RowBox[{"\[Sigma]", "!"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"\[Beta]", "/", "2"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "j"}], "-", "mp", "-", "m", "-", 
         RowBox[{"2", "\[Sigma]"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"\[Beta]", "/", "2"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"mp", "+", "m", "+", 
         RowBox[{"2", "\[Sigma]"}]}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Sigma]", ",", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "mp"}], "-", "m"}], ",", "0"}], "]"}], ",", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{"j", "-", "mp"}], ",", 
         RowBox[{"j", "-", "m"}]}], "]"}]}], "}"}]}], "]"}]}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0c2e88a2-f098-4455-b948-06227bd8f9b0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"calDEdmonds", "[", 
    RowBox[{"j_", ",", "mp_", ",", "m_"}], "]"}], "[", 
   RowBox[{"\[Alpha]_", ",", "\[Beta]_", ",", "\[Gamma]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", "mp", " ", "\[Alpha]"}], "]"}], 
   RowBox[{
    RowBox[{"dEdmonds", "[", 
     RowBox[{"j", ",", "mp", ",", "m"}], "]"}], "[", "\[Beta]", "]"}], 
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", "m", " ", "\[Gamma]"}], "]"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"cf46cb9b-1fd5-4312-b5f4-6b38952a621b"],

Cell["\<\
The the formal Wigner matrices calD will be defined below and replaced by \
their values with the calDRule:\
\>", "Text",ExpressionUUID->"69985899-ee39-40a9-9532-87db1e86d9dd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"calDRule", "=", 
  RowBox[{
   RowBox[{"calD", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "mp_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}]}], "]"}], "\[RuleDelayed]", 
   RowBox[{
    RowBox[{"calDEdmonds", "[", 
     RowBox[{"l", ",", "mp", ",", "m"}], "]"}], "[", 
    RowBox[{"0", ",", 
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[Phi]", "[", "]"}]}], "]"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bde39358-e890-4d03-961c-d7150efdfef2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"calD", "[", 
   RowBox[{
    RowBox[{"LI", "[", "l_", "]"}], ",", 
    RowBox[{"LI", "[", "mp_", "]"}], ",", 
    RowBox[{"LI", "[", "m_", "]"}]}], "]"}], "\[RuleDelayed]", 
  RowBox[{
   RowBox[{"calDEdmonds", "[", 
    RowBox[{"l", ",", "mp", ",", "m"}], "]"}], "[", 
   RowBox[{"0", ",", 
    RowBox[{"\[Theta]", "[", "]"}], ",", 
    RowBox[{"\[Phi]", "[", "]"}]}], 
   "]"}]}]], "Output",ExpressionUUID->"dc39d367-fe1a-46f8-b428-04b745f3c36d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dEdmonds", "[", 
    RowBox[{"7", ",", "3", ",", "3"}], "]"}], "[", "\[Beta]", "]"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"45f20770-a262-46b0-b242-6e2382c98800"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "128"], " ", 
  SuperscriptBox[
   RowBox[{
    InterpretationBox[
     StyleBox["Cos",
      ShowAutoStyles->False,
      AutoSpacing->False],
     Cos,
     Editable->False], "[", 
    FractionBox["\[Beta]", "2"], "]"}], "6"], " ", 
  RowBox[{"(", 
   RowBox[{"5595", "-", 
    RowBox[{"9944", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        ShowAutoStyles->False,
        AutoSpacing->False],
       Cos,
       Editable->False], "[", "\[Beta]", "]"}]}], "+", 
    RowBox[{"6908", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        ShowAutoStyles->False,
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"2", " ", "\[Beta]"}], "]"}]}], "-", 
    RowBox[{"3432", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        ShowAutoStyles->False,
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"3", " ", "\[Beta]"}], "]"}]}], "+", 
    RowBox[{"1001", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        ShowAutoStyles->False,
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"4", " ", "\[Beta]"}], "]"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"f9de2ab7-9750-43b8-95aa-3ccb2d08090b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"\[Beta]", ",", "0", ",", "Pi"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"00d79144-1de6-4f4c-aa40-e17c37de74dd"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.303152 0.18722 0.416099 [
[.17539 .17472 -9 -9 ]
[.17539 .17472 9 0 ]
[.32696 .17472 -3 -9 ]
[.32696 .17472 3 0 ]
[.47854 .17472 -9 -9 ]
[.47854 .17472 9 0 ]
[.63011 .17472 -3 -9 ]
[.63011 .17472 3 0 ]
[.78169 .17472 -9 -9 ]
[.78169 .17472 9 0 ]
[.93327 .17472 -3 -9 ]
[.93327 .17472 3 0 ]
[.01131 .02078 -24 -4.5 ]
[.01131 .02078 0 4.5 ]
[.01131 .104 -24 -4.5 ]
[.01131 .104 0 4.5 ]
[.01131 .27044 -18 -4.5 ]
[.01131 .27044 0 4.5 ]
[.01131 .35366 -18 -4.5 ]
[.01131 .35366 0 4.5 ]
[.01131 .43688 -18 -4.5 ]
[.01131 .43688 0 4.5 ]
[.01131 .5201 -18 -4.5 ]
[.01131 .5201 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .18722 m
.17539 .19347 L
s
[(0.5)] .17539 .17472 0 1 Mshowa
.32696 .18722 m
.32696 .19347 L
s
[(1)] .32696 .17472 0 1 Mshowa
.47854 .18722 m
.47854 .19347 L
s
[(1.5)] .47854 .17472 0 1 Mshowa
.63011 .18722 m
.63011 .19347 L
s
[(2)] .63011 .17472 0 1 Mshowa
.78169 .18722 m
.78169 .19347 L
s
[(2.5)] .78169 .17472 0 1 Mshowa
.93327 .18722 m
.93327 .19347 L
s
[(3)] .93327 .17472 0 1 Mshowa
.125 Mabswid
.05412 .18722 m
.05412 .19097 L
s
.08444 .18722 m
.08444 .19097 L
s
.11476 .18722 m
.11476 .19097 L
s
.14507 .18722 m
.14507 .19097 L
s
.2057 .18722 m
.2057 .19097 L
s
.23602 .18722 m
.23602 .19097 L
s
.26633 .18722 m
.26633 .19097 L
s
.29665 .18722 m
.29665 .19097 L
s
.35728 .18722 m
.35728 .19097 L
s
.38759 .18722 m
.38759 .19097 L
s
.41791 .18722 m
.41791 .19097 L
s
.44822 .18722 m
.44822 .19097 L
s
.50885 .18722 m
.50885 .19097 L
s
.53917 .18722 m
.53917 .19097 L
s
.56948 .18722 m
.56948 .19097 L
s
.5998 .18722 m
.5998 .19097 L
s
.66043 .18722 m
.66043 .19097 L
s
.69074 .18722 m
.69074 .19097 L
s
.72106 .18722 m
.72106 .19097 L
s
.75138 .18722 m
.75138 .19097 L
s
.81201 .18722 m
.81201 .19097 L
s
.84232 .18722 m
.84232 .19097 L
s
.87264 .18722 m
.87264 .19097 L
s
.90295 .18722 m
.90295 .19097 L
s
.96358 .18722 m
.96358 .19097 L
s
.9939 .18722 m
.9939 .19097 L
s
.25 Mabswid
0 .18722 m
1 .18722 L
s
.02381 .02078 m
.03006 .02078 L
s
[(-0.4)] .01131 .02078 1 0 Mshowa
.02381 .104 m
.03006 .104 L
s
[(-0.2)] .01131 .104 1 0 Mshowa
.02381 .27044 m
.03006 .27044 L
s
[(0.2)] .01131 .27044 1 0 Mshowa
.02381 .35366 m
.03006 .35366 L
s
[(0.4)] .01131 .35366 1 0 Mshowa
.02381 .43688 m
.03006 .43688 L
s
[(0.6)] .01131 .43688 1 0 Mshowa
.02381 .5201 m
.03006 .5201 L
s
[(0.8)] .01131 .5201 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04158 m
.02756 .04158 L
s
.02381 .06239 m
.02756 .06239 L
s
.02381 .08319 m
.02756 .08319 L
s
.02381 .1248 m
.02756 .1248 L
s
.02381 .14561 m
.02756 .14561 L
s
.02381 .16641 m
.02756 .16641 L
s
.02381 .20802 m
.02756 .20802 L
s
.02381 .22883 m
.02756 .22883 L
s
.02381 .24963 m
.02756 .24963 L
s
.02381 .29124 m
.02756 .29124 L
s
.02381 .31205 m
.02756 .31205 L
s
.02381 .33285 m
.02756 .33285 L
s
.02381 .37446 m
.02756 .37446 L
s
.02381 .39527 m
.02756 .39527 L
s
.02381 .41607 m
.02756 .41607 L
s
.02381 .45768 m
.02756 .45768 L
s
.02381 .47849 m
.02756 .47849 L
s
.02381 .49929 m
.02756 .49929 L
s
.02381 .5409 m
.02756 .5409 L
s
.02381 .56171 m
.02756 .56171 L
s
.02381 .58251 m
.02756 .58251 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60325 L
.02605 .60305 L
.02729 .60267 L
.02846 .60217 L
.03053 .60092 L
.03279 .59904 L
.03527 .59636 L
.0379 .59283 L
.04262 .58471 L
.05205 .56194 L
.06244 .52758 L
.0842 .43057 L
.10458 .32166 L
.12312 .2214 L
.14335 .12514 L
.15431 .08327 L
.16449 .05264 L
.16949 .04076 L
.17421 .03157 L
.17682 .02734 L
.17965 .02345 L
.18203 .02073 L
.18458 .01837 L
.1859 .01739 L
.18715 .01659 L
.18837 .01596 L
.18949 .01548 L
.19056 .01514 L
.19169 .01489 L
.19283 .01474 L
.19408 .01472 L
.19474 .01476 L
.19543 .01484 L
.19667 .01509 L
.19736 .01529 L
.198 .01551 L
.19946 .01613 L
.20191 .01758 L
.20451 .01967 L
.21019 .02606 L
.21555 .0343 L
.22558 .05487 L
.24559 .11136 L
.26405 .1729 L
.2844 .23893 L
.29436 .26685 L
.30345 .28844 L
.30793 .29746 L
.31282 .30596 L
Mistroke
.31749 .31272 L
.32171 .31764 L
.32665 .32191 L
.32935 .32356 L
.33059 .32416 L
.3319 .32468 L
.33302 .32503 L
.33426 .32532 L
.33539 .3255 L
.33643 .32558 L
.33767 .32559 L
.3388 .32551 L
.3401 .32532 L
.34134 .32503 L
.34248 .32467 L
.34371 .32419 L
.34594 .32308 L
.34859 .32134 L
.35102 .31936 L
.35602 .31414 L
.36129 .30709 L
.37009 .29198 L
.37972 .27139 L
.42033 .16058 L
.4391 .11225 L
.44898 .09132 L
.45943 .0738 L
.46473 .06695 L
.46755 .06391 L
.47056 .06113 L
.47333 .05901 L
.47586 .05745 L
.4784 .05623 L
.48081 .05542 L
.48197 .05514 L
.48324 .05492 L
.48388 .05485 L
.48458 .0548 L
.48583 .05476 L
.48701 .05481 L
.48825 .05495 L
.48931 .05514 L
.49047 .05541 L
.49185 .05583 L
.4931 .05631 L
.49591 .05768 L
.49852 .05934 L
.50098 .06123 L
.51068 .0717 L
.51558 .0787 L
Mistroke
.52097 .08761 L
.53941 .12618 L
.57972 .23114 L
.59827 .27611 L
.61851 .31494 L
.62948 .33018 L
.63482 .33597 L
.63966 .34029 L
.64467 .34383 L
.64939 .3463 L
.65198 .3473 L
.65437 .34801 L
.65562 .34829 L
.65699 .34854 L
.65768 .34865 L
.65842 .34874 L
.65912 .3488 L
.65976 .34885 L
.66094 .3489 L
.66204 .3489 L
.66326 .34886 L
.66457 .34875 L
.66587 .34859 L
.66724 .34836 L
.66968 .34781 L
.67195 .34712 L
.67406 .34634 L
.67886 .34409 L
.68412 .3409 L
.6889 .33739 L
.69962 .32772 L
.73962 .27916 L
.77811 .23383 L
.798 .21636 L
.80815 .20934 L
.81905 .20318 L
.82929 .1986 L
.83864 .19533 L
.84804 .19281 L
.85696 .19101 L
.86658 .18961 L
.87195 .18903 L
.87682 .18861 L
.88138 .18829 L
.8863 .18801 L
.89061 .18782 L
.89522 .18765 L
.90016 .18752 L
.90476 .18743 L
.90757 .18739 L
Mistroke
.91023 .18735 L
.91521 .1873 L
.91776 .18729 L
.92047 .18727 L
.92281 .18726 L
.92532 .18725 L
.92802 .18724 L
.93054 .18723 L
.93355 .18723 L
.9363 .18723 L
.93879 .18722 L
.94106 .18722 L
.94231 .18722 L
.94367 .18722 L
.94485 .18722 L
.94613 .18722 L
.94845 .18722 L
.94971 .18722 L
.95089 .18722 L
.95198 .18722 L
.95301 .18722 L
.95419 .18722 L
.95527 .18722 L
.95646 .18722 L
.95777 .18722 L
.95843 .18722 L
.95914 .18722 L
.96043 .18722 L
.96164 .18722 L
.96291 .18722 L
.964 .18722 L
.96519 .18722 L
.96592 .18722 L
.96661 .18722 L
.9679 .18722 L
.96862 .18722 L
.96928 .18722 L
.97001 .18722 L
.97079 .18722 L
.97207 .18722 L
.97327 .18722 L
.97458 .18722 L
.97532 .18722 L
.97599 .18722 L
.97619 .18722 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 
  1}},ImageRangeCache->{{{0., 287.}, {176.938, 0.}} -> {-0.338866, -0.503927, \
0.0124008, \
0.00903467}},ExpressionUUID->"c9ba584a-3b6d-439f-91d0-ce8fbcd69a89"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->
   False]], "Output",ExpressionUUID->"85d4ecf4-7c23-49e6-86bb-640fa2d36370"]
}, Open  ]],

Cell["\<\
Galindo-Pascual's definition of the coefficient d coincides with that of \
Goldberg, but they are different from Edmonds' due to a phase (-1)^(m+mp), or \
equivalently, they have opposite signs of \[Beta]. The complex exponentials \
are also different between Edmonds and Galindo-Pascual and (after correcting \
the mistake referred to above) we see that the difference is just the \
exchange of angles \[Alpha] and \[Gamma]. The exponentials of Goldberg \
coincide with those of Edmonds before correcting the mistake! Therefore, \
taking Galindo-Pascual as a reference we find that:
\tcalDEdmonds(\[Alpha], \[Beta], \[Gamma]) = calDGalindo(-\[Alpha], -\[Beta], \
-\[Gamma])
\tcalDGoldberg(\[Alpha], \[Beta], \[Gamma]) = calDGalindo(-\[Gamma], \
-\[Beta], -\[Alpha]) = DGalindo(\[Alpha], \[Beta], \[Gamma])^(-1)
That means that the three calD's are different!\
\>", "Text",ExpressionUUID->"f7d5562e-0cfe-480d-b2ac-3334b5aeae5b"],

Cell["\<\
d can be related to the Jacobi polynomials (interestingly, timings are very \
similar).\
\>", "Text",ExpressionUUID->"2b9abec8-ed7e-4393-b5ef-1be136cee990"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dJacobi", "[", 
    RowBox[{"j_", ",", "mp_", ",", "m_"}], "]"}], "[", "\[Beta]_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j", "+", "mp"}], ")"}], "!"}], 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"j", "-", "mp"}], ")"}], "!"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"j", "+", "m"}], ")"}], "!"}]}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j", "-", "m"}], ")"}], "!"}]}]}], "]"}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"\[Beta]", "/", "2"}], "]"}], "^", 
    RowBox[{"(", 
     RowBox[{"m", "+", "mp"}], ")"}]}], 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"\[Beta]", "/", "2"}], "]"}], "^", 
    RowBox[{"(", 
     RowBox[{"mp", "-", "m"}], ")"}]}], 
   RowBox[{"JacobiP", "[", 
    RowBox[{
     RowBox[{"j", "-", "mp"}], ",", 
     RowBox[{"mp", "-", "m"}], ",", 
     RowBox[{"mp", "+", "m"}], ",", 
     RowBox[{"Cos", "[", "\[Beta]", "]"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"1a929354-e5fa-458b-971a-05d64f957f4d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"dEdmonds", "[", 
     RowBox[{"3", ",", "1", ",", 
      RowBox[{"-", "3"}]}], "]"}], "[", "beta", "]"}], "/", 
   RowBox[{
    RowBox[{"dJacobi", "[", 
     RowBox[{"3", ",", "1", ",", 
      RowBox[{"-", "3"}]}], "]"}], "[", "beta", "]"}]}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"ecfb13f9-81f3-406b-bbf0-b3b9fd3ebd2f"],

Cell[BoxData["1"], \
"Output",ExpressionUUID->"afe64f54-90bf-4cc7-8965-2b3397491d98"]
}, Open  ]],

Cell[TextData[{
 "The Clebsch-Gordan coefficients are also standarized. They can be given \
(and are actually computed by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in this way) in terms of a hypergeometric function:"
}], "Text",ExpressionUUID->"d0890b94-c780-4896-bec1-f225766eefbf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"j1_", ",", "m1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j2_", ",", "m2_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j3_", ",", "m3_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"j1", "+", "m2", "-", "j3"}], ")"}]}], 
   RowBox[{
    RowBox[{"W", "[", 
     RowBox[{
      RowBox[{"j3", "-", "m3"}], ",", 
      RowBox[{"j2", "-", "m2"}], ",", 
      RowBox[{"j1", "-", "m1"}]}], "]"}], "[", 
    RowBox[{
     RowBox[{"j1", "+", "m1", "-", "j2", "+", "m2"}], ",", 
     RowBox[{
      RowBox[{"-", "j1"}], "+", "m1", "+", "j2", "+", "m2"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"50f778a7-f762-44be-8acd-3a585904a435"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"W", "[", 
    RowBox[{"m_", ",", "n1_", ",", "n2_"}], "]"}], "[", 
   RowBox[{"k1_", ",", "k2_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", "m"}], " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n1", "+", "n2"}], ")"}], "!"}], "/", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "k2"}], "]"}]}], 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "m"}], "+", "k1", "+", "k2", "+", "1"}], ")"}], 
     RowBox[{"Gamma", "[", 
      RowBox[{"m", "+", "k1", "+", "k2", "+", "1"}], "]"}], 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Gamma", "[", 
           RowBox[{"m", "+", "k2", "+", "1"}], "]"}], "/", 
          RowBox[{"n1", "!"}]}], "/", 
         RowBox[{"n2", "!"}]}], "/", 
        RowBox[{"m", "!"}]}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n1", "+", "n2", "-", "m"}], ")"}], "!"}]}], "/", 
      RowBox[{"Gamma", "[", 
       RowBox[{"m", "+", "k1", "+", "1"}], "]"}]}]}], "]"}], 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"n1", "+", "k1", "+", "1"}], "]"}], 
     RowBox[{
      RowBox[{"Gamma", "[", 
       RowBox[{"n2", "+", "k2", "+", "1"}], "]"}], "/", 
      RowBox[{"Gamma", "[", 
       RowBox[{"n1", "+", "n2", "+", "m", "+", "k1", "+", "k2", "+", "2"}], 
       "]"}]}]}], "]"}], 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "m"}], ",", 
       RowBox[{"m", "+", "k1", "+", "k2", "+", "1"}], ",", 
       RowBox[{"-", "n2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "+", "k2"}], ",", 
       RowBox[{
        RowBox[{"-", "n1"}], "-", "n2"}]}], "}"}], ",", "1"}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"d608e16a-fd17-4078-93ca-182dd9912833"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j1", "=", "4"}], ",", 
     RowBox[{"m1", "=", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"j2", "=", "5"}], ",", 
     RowBox[{"m2", "=", "2"}], ",", 
     RowBox[{"j3", "=", "7"}], ",", 
     RowBox[{"m3", "=", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ClebschGordan", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"j1", ",", "m1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j2", ",", "m2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j3", ",", "m3"}], "}"}]}], "]"}], ",", 
     RowBox[{"CG", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"j1", ",", "m1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j2", ",", "m2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j3", ",", "m3"}], "}"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"4d165f1f-58b4-4e93-9902-a6b805ce05b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["35", 
    SqrtBox["4862"]], ",", 
   FractionBox["35", 
    SqrtBox["4862"]]}], 
  "}"}]], "Output",ExpressionUUID->"5c330569-ba9b-493c-b151-cf5238c907ab"]
}, Open  ]],

Cell["This expression allows us to find a limit for large j1+j2:", \
"Text",ExpressionUUID->"55ac60c9-1433-454c-8a02-0a7c2f551070"],

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lp", "=", "4"}], ",", 
      RowBox[{"m1", "=", "2"}], ",", 
      RowBox[{"m2", "=", 
       RowBox[{"-", "4"}]}], ",", 
      RowBox[{"lpp", "=", "5"}], ",", 
      RowBox[{"m3", "=", 
       RowBox[{"-", "2"}]}], ",", 
      RowBox[{"lower", "=", "7"}], ",", 
      RowBox[{"upper", "=", "1000"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"nums", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"L", "+", "Lp", "+", "lpp"}], ")"}], "/", "2"}], ",", 
            "m1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"L", "-", "Lp", "+", "lpp"}], ")"}], "/", "2"}], ",", 
            "m2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"lpp", ",", "m3"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"L", ",", "lower", ",", "upper", ",", "2"}], "}"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"approx", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"L", "-", "Lp", "+", "lpp"}], ")"}], "/", "2"}], "+", 
            "m2"}], ")"}]}], 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "lpp"}], "+", "1"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"L", "+", "lpp", "+", "1"}], ")"}]}], "]"}], 
         RowBox[{
          RowBox[{"dJacobi", "[", 
           RowBox[{"lpp", ",", "Lp", ",", 
            RowBox[{"m1", "+", "m2"}]}], "]"}], "[", 
          RowBox[{"ArcCos", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"m1", "-", "m2"}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"L", "+", "lpp", "+", "1"}], ")"}]}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"L", ",", "lower", ",", "upper", ",", "2"}], "}"}]}], 
       "]"}]}]}]}], "]"}], 
  ";"}]], "Input",ExpressionUUID->"c153d899-b448-4b81-a1ca-ef9fa90faccc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"nums", "/", "approx"}], 
  "]"}]], "Input",ExpressionUUID->"d9236d1b-639e-4d74-ba1a-46fcf7b3fa14"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00191626 -780.431 780.657 [
[.21544 .21296 -9 -9 ]
[.21544 .21296 9 0 ]
[.40706 .21296 -9 -9 ]
[.40706 .21296 9 0 ]
[.59869 .21296 -9 -9 ]
[.59869 .21296 9 0 ]
[.79031 .21296 -9 -9 ]
[.79031 .21296 9 0 ]
[.98194 .21296 -9 -9 ]
[.98194 .21296 9 0 ]
[.01131 .06933 -36 -4.5 ]
[.01131 .06933 0 4.5 ]
[.01131 .1474 -36 -4.5 ]
[.01131 .1474 0 4.5 ]
[.01131 .30353 -36 -4.5 ]
[.01131 .30353 0 4.5 ]
[.01131 .38159 -36 -4.5 ]
[.01131 .38159 0 4.5 ]
[.01131 .45966 -36 -4.5 ]
[.01131 .45966 0 4.5 ]
[.01131 .53772 -36 -4.5 ]
[.01131 .53772 0 4.5 ]
[.01131 .61579 -36 -4.5 ]
[.01131 .61579 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21544 .22546 m
.21544 .23171 L
s
[(100)] .21544 .21296 0 1 Mshowa
.40706 .22546 m
.40706 .23171 L
s
[(200)] .40706 .21296 0 1 Mshowa
.59869 .22546 m
.59869 .23171 L
s
[(300)] .59869 .21296 0 1 Mshowa
.79031 .22546 m
.79031 .23171 L
s
[(400)] .79031 .21296 0 1 Mshowa
.98194 .22546 m
.98194 .23171 L
s
[(500)] .98194 .21296 0 1 Mshowa
.125 Mabswid
.06213 .22546 m
.06213 .22921 L
s
.10046 .22546 m
.10046 .22921 L
s
.13879 .22546 m
.13879 .22921 L
s
.17711 .22546 m
.17711 .22921 L
s
.25376 .22546 m
.25376 .22921 L
s
.29209 .22546 m
.29209 .22921 L
s
.33041 .22546 m
.33041 .22921 L
s
.36874 .22546 m
.36874 .22921 L
s
.44539 .22546 m
.44539 .22921 L
s
.48371 .22546 m
.48371 .22921 L
s
.52204 .22546 m
.52204 .22921 L
s
.56036 .22546 m
.56036 .22921 L
s
.63701 .22546 m
.63701 .22921 L
s
.67534 .22546 m
.67534 .22921 L
s
.71366 .22546 m
.71366 .22921 L
s
.75199 .22546 m
.75199 .22921 L
s
.82864 .22546 m
.82864 .22921 L
s
.86696 .22546 m
.86696 .22921 L
s
.90529 .22546 m
.90529 .22921 L
s
.94361 .22546 m
.94361 .22921 L
s
.25 Mabswid
0 .22546 m
1 .22546 L
s
.02381 .06933 m
.03006 .06933 L
s
[(0.9998)] .01131 .06933 1 0 Mshowa
.02381 .1474 m
.03006 .1474 L
s
[(0.9999)] .01131 .1474 1 0 Mshowa
.02381 .30353 m
.03006 .30353 L
s
[(1.0001)] .01131 .30353 1 0 Mshowa
.02381 .38159 m
.03006 .38159 L
s
[(1.0002)] .01131 .38159 1 0 Mshowa
.02381 .45966 m
.03006 .45966 L
s
[(1.0003)] .01131 .45966 1 0 Mshowa
.02381 .53772 m
.03006 .53772 L
s
[(1.0004)] .01131 .53772 1 0 Mshowa
.02381 .61579 m
.03006 .61579 L
s
[(1.0005)] .01131 .61579 1 0 Mshowa
.125 Mabswid
.02381 .08494 m
.02756 .08494 L
s
.02381 .10056 m
.02756 .10056 L
s
.02381 .11617 m
.02756 .11617 L
s
.02381 .13178 m
.02756 .13178 L
s
.02381 .16301 m
.02756 .16301 L
s
.02381 .17862 m
.02756 .17862 L
s
.02381 .19424 m
.02756 .19424 L
s
.02381 .20985 m
.02756 .20985 L
s
.02381 .24108 m
.02756 .24108 L
s
.02381 .25669 m
.02756 .25669 L
s
.02381 .2723 m
.02756 .2723 L
s
.02381 .28791 m
.02756 .28791 L
s
.02381 .31914 m
.02756 .31914 L
s
.02381 .33475 m
.02756 .33475 L
s
.02381 .35037 m
.02756 .35037 L
s
.02381 .36598 m
.02756 .36598 L
s
.02381 .39721 m
.02756 .39721 L
s
.02381 .41282 m
.02756 .41282 L
s
.02381 .42843 m
.02756 .42843 L
s
.02381 .44405 m
.02756 .44405 L
s
.02381 .47527 m
.02756 .47527 L
s
.02381 .49089 m
.02756 .49089 L
s
.02381 .5065 m
.02756 .5065 L
s
.02381 .52211 m
.02756 .52211 L
s
.02381 .55334 m
.02756 .55334 L
s
.02381 .56895 m
.02756 .56895 L
s
.02381 .58456 m
.02756 .58456 L
s
.02381 .60018 m
.02756 .60018 L
s
.02381 .05372 m
.02756 .05372 L
s
.02381 .0381 m
.02756 .0381 L
s
.02381 .02249 m
.02756 .02249 L
s
.02381 .00688 m
.02756 .00688 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.04297 .26888 Mdot
.13304 .61214 Mdot
.13495 .6015 Mdot
.13687 .59129 Mdot
.13879 .58147 Mdot
.1407 .57204 Mdot
.14262 .56297 Mdot
.14453 .55424 Mdot
.14645 .54584 Mdot
.14837 .53776 Mdot
.15028 .52996 Mdot
.1522 .52245 Mdot
.15412 .51522 Mdot
.15603 .50823 Mdot
.15795 .5015 Mdot
.15986 .49499 Mdot
.16178 .48872 Mdot
.1637 .48265 Mdot
.16561 .47679 Mdot
.16753 .47112 Mdot
.16945 .46565 Mdot
.17136 .46035 Mdot
.17328 .45522 Mdot
.17519 .45025 Mdot
.17711 .44545 Mdot
.17903 .44079 Mdot
.18094 .43628 Mdot
.18286 .43191 Mdot
.18478 .42767 Mdot
.18669 .42356 Mdot
.18861 .41957 Mdot
.19052 .4157 Mdot
.19244 .41195 Mdot
.19436 .4083 Mdot
.19627 .40476 Mdot
.19819 .40131 Mdot
.20011 .39797 Mdot
.20202 .39472 Mdot
.20394 .39156 Mdot
.20585 .38849 Mdot
.20777 .3855 Mdot
.20969 .38259 Mdot
.2116 .37976 Mdot
.21352 .37701 Mdot
.21544 .37433 Mdot
.21735 .37171 Mdot
.21927 .36917 Mdot
.22118 .36669 Mdot
.2231 .36428 Mdot
.22502 .36192 Mdot
.22693 .35963 Mdot
.22885 .35739 Mdot
.23077 .3552 Mdot
.23268 .35307 Mdot
.2346 .351 Mdot
.23651 .34897 Mdot
.23843 .34699 Mdot
.24035 .34506 Mdot
.24226 .34317 Mdot
.24418 .34133 Mdot
.2461 .33953 Mdot
.24801 .33777 Mdot
.24993 .33605 Mdot
.25184 .33437 Mdot
.25376 .33273 Mdot
.25568 .33113 Mdot
.25759 .32956 Mdot
.25951 .32802 Mdot
.26143 .32652 Mdot
.26334 .32505 Mdot
.26526 .32361 Mdot
.26717 .32221 Mdot
.26909 .32083 Mdot
.27101 .31949 Mdot
.27292 .31817 Mdot
.27484 .31687 Mdot
.27676 .31561 Mdot
.27867 .31437 Mdot
.28059 .31316 Mdot
.2825 .31197 Mdot
.28442 .3108 Mdot
.28634 .30966 Mdot
.28825 .30854 Mdot
.29017 .30745 Mdot
.29209 .30637 Mdot
.294 .30532 Mdot
.29592 .30428 Mdot
.29783 .30327 Mdot
.29975 .30227 Mdot
.30167 .3013 Mdot
.30358 .30034 Mdot
.3055 .2994 Mdot
.30742 .29848 Mdot
.30933 .29757 Mdot
.31125 .29669 Mdot
.31316 .29581 Mdot
.31508 .29496 Mdot
.317 .29412 Mdot
.31891 .29329 Mdot
.32083 .29248 Mdot
.32275 .29169 Mdot
.32466 .2909 Mdot
.32658 .29013 Mdot
.32849 .28938 Mdot
.33041 .28864 Mdot
.33233 .28791 Mdot
.33424 .28719 Mdot
.33616 .28649 Mdot
.33808 .2858 Mdot
.33999 .28512 Mdot
.34191 .28445 Mdot
.34382 .28379 Mdot
.34574 .28314 Mdot
.34766 .2825 Mdot
.34957 .28188 Mdot
.35149 .28126 Mdot
.35341 .28066 Mdot
.35532 .28006 Mdot
.35724 .27947 Mdot
.35915 .2789 Mdot
.36107 .27833 Mdot
.36299 .27777 Mdot
.3649 .27722 Mdot
.36682 .27668 Mdot
.36874 .27615 Mdot
.37065 .27562 Mdot
.37257 .27511 Mdot
.37449 .2746 Mdot
.3764 .2741 Mdot
.37832 .2736 Mdot
.38023 .27312 Mdot
.38215 .27264 Mdot
.38407 .27217 Mdot
.38598 .2717 Mdot
.3879 .27124 Mdot
.38982 .27079 Mdot
.39173 .27035 Mdot
.39365 .26991 Mdot
.39556 .26948 Mdot
.39748 .26906 Mdot
.3994 .26864 Mdot
.40131 .26822 Mdot
.40323 .26782 Mdot
.40515 .26742 Mdot
.40706 .26702 Mdot
.40898 .26663 Mdot
.41089 .26625 Mdot
.41281 .26587 Mdot
.41473 .26549 Mdot
.41664 .26512 Mdot
.41856 .26476 Mdot
.42048 .2644 Mdot
.42239 .26405 Mdot
.42431 .2637 Mdot
.42622 .26335 Mdot
.42814 .26301 Mdot
.43006 .26268 Mdot
.43197 .26235 Mdot
.43389 .26202 Mdot
.43581 .2617 Mdot
.43772 .26138 Mdot
.43964 .26107 Mdot
.44155 .26076 Mdot
.44347 .26045 Mdot
.44539 .26015 Mdot
.4473 .25985 Mdot
.44922 .25956 Mdot
.45114 .25927 Mdot
.45305 .25898 Mdot
.45497 .2587 Mdot
.45688 .25842 Mdot
.4588 .25815 Mdot
.46072 .25787 Mdot
.46263 .2576 Mdot
.46455 .25734 Mdot
.46647 .25708 Mdot
.46838 .25682 Mdot
.4703 .25656 Mdot
.47221 .25631 Mdot
.47413 .25606 Mdot
.47605 .25581 Mdot
.47796 .25557 Mdot
.47988 .25533 Mdot
.4818 .25509 Mdot
.48371 .25485 Mdot
.48563 .25462 Mdot
.48754 .25439 Mdot
.48946 .25417 Mdot
.49138 .25394 Mdot
.49329 .25372 Mdot
.49521 .2535 Mdot
.49713 .25328 Mdot
.49904 .25307 Mdot
.50096 .25286 Mdot
.50287 .25265 Mdot
.50479 .25244 Mdot
.50671 .25224 Mdot
.50862 .25204 Mdot
.51054 .25184 Mdot
.51246 .25164 Mdot
.51437 .25144 Mdot
.51629 .25125 Mdot
.5182 .25106 Mdot
.52012 .25087 Mdot
.52204 .25068 Mdot
.52395 .2505 Mdot
.52587 .25031 Mdot
.52779 .25013 Mdot
.5297 .24996 Mdot
.53162 .24978 Mdot
.53353 .2496 Mdot
.53545 .24943 Mdot
.53737 .24926 Mdot
.53928 .24909 Mdot
.5412 .24892 Mdot
.54312 .24876 Mdot
.54503 .24859 Mdot
.54695 .24843 Mdot
.54886 .24827 Mdot
.55078 .24811 Mdot
.5527 .24795 Mdot
.55461 .2478 Mdot
.55653 .24764 Mdot
.55845 .24749 Mdot
.56036 .24734 Mdot
.56228 .24719 Mdot
.56419 .24704 Mdot
.56611 .2469 Mdot
.56803 .24675 Mdot
.56994 .24661 Mdot
.57186 .24647 Mdot
.57378 .24632 Mdot
.57569 .24619 Mdot
.57761 .24605 Mdot
.57952 .24591 Mdot
.58144 .24578 Mdot
.58336 .24564 Mdot
.58527 .24551 Mdot
.58719 .24538 Mdot
.58911 .24525 Mdot
.59102 .24512 Mdot
.59294 .24499 Mdot
.59485 .24487 Mdot
.59677 .24474 Mdot
.59869 .24462 Mdot
.6006 .2445 Mdot
.60252 .24438 Mdot
.60444 .24426 Mdot
.60635 .24414 Mdot
.60827 .24402 Mdot
.61018 .2439 Mdot
.6121 .24379 Mdot
.61402 .24367 Mdot
.61593 .24356 Mdot
.61785 .24345 Mdot
.61977 .24333 Mdot
.62168 .24322 Mdot
.6236 .24311 Mdot
.62551 .24301 Mdot
.62743 .2429 Mdot
.62935 .24279 Mdot
.63126 .24269 Mdot
.63318 .24258 Mdot
.6351 .24248 Mdot
.63701 .24238 Mdot
.63893 .24227 Mdot
.64085 .24217 Mdot
.64276 .24207 Mdot
.64468 .24197 Mdot
.64659 .24188 Mdot
.64851 .24178 Mdot
.65043 .24168 Mdot
.65234 .24159 Mdot
.65426 .24149 Mdot
.65618 .2414 Mdot
.65809 .24131 Mdot
.66001 .24121 Mdot
.66192 .24112 Mdot
.66384 .24103 Mdot
.66576 .24094 Mdot
.66767 .24085 Mdot
.66959 .24077 Mdot
.67151 .24068 Mdot
.67342 .24059 Mdot
.67534 .24051 Mdot
.67725 .24042 Mdot
.67917 .24034 Mdot
.68109 .24025 Mdot
.683 .24017 Mdot
.68492 .24009 Mdot
.68684 .24 Mdot
.68875 .23992 Mdot
.69067 .23984 Mdot
.69258 .23976 Mdot
.6945 .23968 Mdot
.69642 .23961 Mdot
.69833 .23953 Mdot
.70025 .23945 Mdot
.70217 .23937 Mdot
.70408 .2393 Mdot
.706 .23922 Mdot
.70791 .23915 Mdot
.70983 .23907 Mdot
.71175 .239 Mdot
.71366 .23893 Mdot
.71558 .23886 Mdot
.7175 .23878 Mdot
.71941 .23871 Mdot
.72133 .23864 Mdot
.72324 .23857 Mdot
.72516 .2385 Mdot
.72708 .23843 Mdot
.72899 .23837 Mdot
.73091 .2383 Mdot
.73283 .23823 Mdot
.73474 .23816 Mdot
.73666 .2381 Mdot
.73857 .23803 Mdot
.74049 .23797 Mdot
.74241 .2379 Mdot
.74432 .23784 Mdot
.74624 .23777 Mdot
.74816 .23771 Mdot
.75007 .23765 Mdot
.75199 .23759 Mdot
.7539 .23752 Mdot
.75582 .23746 Mdot
.75774 .2374 Mdot
.75965 .23734 Mdot
.76157 .23728 Mdot
.76349 .23722 Mdot
.7654 .23716 Mdot
.76732 .23711 Mdot
.76923 .23705 Mdot
.77115 .23699 Mdot
.77307 .23693 Mdot
.77498 .23688 Mdot
.7769 .23682 Mdot
.77882 .23676 Mdot
.78073 .23671 Mdot
.78265 .23665 Mdot
.78456 .2366 Mdot
.78648 .23654 Mdot
.7884 .23649 Mdot
.79031 .23644 Mdot
.79223 .23638 Mdot
.79415 .23633 Mdot
.79606 .23628 Mdot
.79798 .23623 Mdot
.79989 .23617 Mdot
.80181 .23612 Mdot
.80373 .23607 Mdot
.80564 .23602 Mdot
.80756 .23597 Mdot
.80948 .23592 Mdot
.81139 .23587 Mdot
.81331 .23582 Mdot
.81522 .23577 Mdot
.81714 .23573 Mdot
.81906 .23568 Mdot
.82097 .23563 Mdot
.82289 .23558 Mdot
.82481 .23553 Mdot
.82672 .23549 Mdot
.82864 .23544 Mdot
.83055 .2354 Mdot
.83247 .23535 Mdot
.83439 .2353 Mdot
.8363 .23526 Mdot
.83822 .23521 Mdot
.84014 .23517 Mdot
.84205 .23513 Mdot
.84397 .23508 Mdot
.84588 .23504 Mdot
.8478 .23499 Mdot
.84972 .23495 Mdot
.85163 .23491 Mdot
.85355 .23487 Mdot
.85547 .23482 Mdot
.85738 .23478 Mdot
.8593 .23474 Mdot
.86121 .2347 Mdot
.86313 .23466 Mdot
.86505 .23462 Mdot
.86696 .23458 Mdot
.86888 .23454 Mdot
.8708 .2345 Mdot
.87271 .23446 Mdot
.87463 .23442 Mdot
.87654 .23438 Mdot
.87846 .23434 Mdot
.88038 .2343 Mdot
.88229 .23426 Mdot
.88421 .23422 Mdot
.88613 .23419 Mdot
.88804 .23415 Mdot
.88996 .23411 Mdot
.89188 .23407 Mdot
.89379 .23404 Mdot
.89571 .234 Mdot
.89762 .23396 Mdot
.89954 .23393 Mdot
.90146 .23389 Mdot
.90337 .23385 Mdot
.90529 .23382 Mdot
.90721 .23378 Mdot
.90912 .23375 Mdot
.91104 .23371 Mdot
.91295 .23368 Mdot
.91487 .23364 Mdot
.91679 .23361 Mdot
.9187 .23358 Mdot
.92062 .23354 Mdot
.92254 .23351 Mdot
.92445 .23348 Mdot
.92637 .23344 Mdot
.92828 .23341 Mdot
.9302 .23338 Mdot
.93212 .23334 Mdot
.93403 .23331 Mdot
.93595 .23328 Mdot
.93787 .23325 Mdot
.93978 .23322 Mdot
.9417 .23318 Mdot
.94361 .23315 Mdot
.94553 .23312 Mdot
.94745 .23309 Mdot
.94936 .23306 Mdot
.95128 .23303 Mdot
.9532 .233 Mdot
.95511 .23297 Mdot
.95703 .23294 Mdot
.95894 .23291 Mdot
.96086 .23288 Mdot
.96278 .23285 Mdot
.96469 .23282 Mdot
.96661 .23279 Mdot
.96853 .23276 Mdot
.97044 .23273 Mdot
.97236 .2327 Mdot
.97427 .23267 Mdot
.97619 .23265 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 
  1}},ImageRangeCache->{{{0., 287.}, {176.938, 0.}} -> {-81.8767, 0.999662, \
2.09309, 5.13786}},ExpressionUUID->"554b8210-a9c8-4af1-94e5-1b8d33746339"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->
   False]], "Output",ExpressionUUID->"d229e2bc-e41d-4d26-b8c9-448ca4e041ab"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3. Unit sphere", \
"Subsection",ExpressionUUID->"ed47a7a7-4bbc-4fe4-b4a1-abaa66e5bdd2"],

Cell[CellGroupData[{

Cell["3.0. Unit sphere", \
"Subsubsection",ExpressionUUID->"4c9835e9-1483-4a93-b01b-e77aa533539a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefUnitSphere", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "manifold_Symbol", ",", "dim_Integer", ",", "indices_List", ",", 
       "manifoldoptions___"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"metric_Symbol", ",", "covd_Symbol", ",", "metricoptions___"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "chart_Symbol", ",", "cnumbers_List", ",", "scalars_List", ",", 
       "chartoptions___"}], "}"}]}], "\[IndentingNewLine]", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "tmp", "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", "Checks", " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"dim", "=!=", "2"}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "indices", "]"}], "<", "3"}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "=", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"b", "=", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"c", "=", 
           RowBox[{"indices", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", 
          RowBox[{"theta", "=", 
           RowBox[{"scalars", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Define", " ", "geometric", " ", "structures"}], " ", "*)"}],
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"DefManifold", "[", 
          RowBox[{
          "manifold", ",", "dim", ",", "indices", ",", "manifoldoptions"}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"DefChart", "[", 
          RowBox[{
          "chart", ",", "manifold", ",", "cnumbers", ",", "scalars", ",", 
           "chartoptions"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"DefMetric", "[", 
          RowBox[{"1", ",", 
           RowBox[{"metric", "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}]}], "]"}], ",", "covd", ",", "metricoptions"}],
           "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"rs", "=", 
             RowBox[{"GiveSymbol", "[", 
              RowBox[{"RicciScalar", ",", "covd"}], "]"}]}], "}"}], ",", 
           RowBox[{"Set", "[", 
            RowBox[{
             RowBox[{"rs", "[", "]"}], ",", "2"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"Unit", " ", "metric"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"$CVVerbose", "=", "False"}], ";", "\[IndentingNewLine]", 
         RowBox[{"metricvalues", "=", 
          RowBox[{"DiagonalMatrix", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"theta", "[", "]"}], "]"}], "^", "2"}]}], "}"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"MetricInBasis", "[", 
          RowBox[{"metric", ",", 
           RowBox[{"-", "chart"}], ",", "metricvalues"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"MetricInBasis", "[", 
          RowBox[{"metric", ",", "chart", ",", 
           RowBox[{"Inverse", "[", "metricvalues", "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"ComponentValue", "[", 
          RowBox[{
           RowBox[{"Determinant", "[", 
            RowBox[{
             RowBox[{"metric", "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "b"}]}], "]"}], ",", "chart"}], "]"}], ",", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"Det", "[", "metricvalues", "]"}], "]"}], "//", 
            "PowerExpand"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Remove", "[", "metricvalues", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"$BMUseValues", "=", "All"}], ";", "\[IndentingNewLine]", 
         RowBox[{"$TUseValues", "=", "All"}], ";", "\[IndentingNewLine]", 
         RowBox[{"$CVSimplify", "=", "Simplify"}], ";", "\[IndentingNewLine]", 
         RowBox[{"$CCSimplify", "=", "Simplify"}], ";", "\[IndentingNewLine]", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"eps", "=", 
              RowBox[{"GiveSymbol", "[", 
               RowBox[{"epsilon", ",", "metric"}], "]"}]}], ",", 
             RowBox[{"det", "=", 
              RowBox[{"GiveSymbol", "[", 
               RowBox[{"Det", ",", "metric", ",", "chart"}], "]"}]}]}], "}"}],
            ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"ComponentValue", "[", 
             RowBox[{
              RowBox[{"ComponentArray", "[", 
               RowBox[{"eps", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "chart"}], ",", 
                  RowBox[{"-", "chart"}]}], "}"}]}], "]"}], ",", 
              RowBox[{
               RowBox[{"$epsilonSign", " ", 
                RowBox[{"det", "[", "]"}], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], "//", 
               "ToValues"}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"ChangeComponents", "[", 
             RowBox[{
              RowBox[{"eps", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"a", ",", "chart"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"b", ",", "chart"}], "}"}]}], "]"}], ",", 
              RowBox[{"eps", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "a"}], ",", 
                  RowBox[{"-", "chart"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "b"}], ",", 
                  RowBox[{"-", "chart"}]}], "}"}]}], "]"}]}], "]"}]}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"AllComponentValues", "[", 
          RowBox[{
           RowBox[{"Christoffel", "[", 
            RowBox[{"cd", ",", "PDspherical"}], "]"}], "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "a"}], ",", 
              RowBox[{"-", "chart"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "chart"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "chart"}]}], "}"}]}], "]"}], "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"tmp", "=", 
          RowBox[{"metric", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "a"}], ",", 
              RowBox[{"-", "chart"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"-", "chart"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"tmp", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"SeparateBasis", "[", "AIndex", "]"}], "[", "tmp", "]"}], 
           "-", "tmp"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"tmp", "=", 
          RowBox[{
           RowBox[{"covd", "[", 
            RowBox[{"-", "c"}], "]"}], "[", "tmp", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"tmp", "=", 
          RowBox[{
           RowBox[{"tmp", "//", "ContractMetric"}], "//", "ContractBasis"}]}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"tmp", "=", 
          RowBox[{"tmp", "//", 
           RowBox[{"ToBasis", "[", "chart", "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"tmp", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"ComponentArray", "[", "tmp", "]"}], "//", "ToValues"}], "//",
            "Flatten"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"tmp", "=", 
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "\[Equal]", "0"}], "&"}], ",", "tmp"}], "]"}], ",", 
            RowBox[{"First", "/@", 
             RowBox[{"Last", "[", 
              RowBox[{"TensorValues", "[", 
               RowBox[{"GiveSymbol", "[", 
                RowBox[{"Christoffel", ",", "covd", ",", 
                 RowBox[{"GiveSymbol", "[", 
                  RowBox[{"PD", ",", "chart"}], "]"}]}], "]"}], "]"}], 
              "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"tmp", "/.", 
          RowBox[{"Rule", "\[Rule]", "ComponentValue"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"ChangeComponents", "[", 
          RowBox[{
           RowBox[{"ChristoffelcdPDspherical", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "spherical"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "b"}], ",", 
               RowBox[{"-", "spherical"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "c"}], ",", 
               RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"ChristoffelcdPDspherical", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "spherical"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "b"}], ",", 
               RowBox[{"-", "spherical"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "c"}], ",", 
               RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"SetAttributes", "[", 
          RowBox[{"identity", ",", "Orderless"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"identity", "[", 
           RowBox[{"a_Symbol", ",", 
            RowBox[{"-", "b_Symbol"}]}], "]"}], ":=", 
          RowBox[{
           RowBox[{
            RowBox[{"Basis", "[", 
             RowBox[{"a", ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
            RowBox[{"Basis", "[", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "spherical"}], "}"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"Basis", "[", 
             RowBox[{"a", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", 
                RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
            RowBox[{"Basis", "[", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "spherical"}], "}"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"Basis", "[", 
             RowBox[{"a", ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", 
                RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
            RowBox[{"Basis", "[", 
             RowBox[{
              RowBox[{"-", "b"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "spherical"}], "}"}]}], "]"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"DefTensor", "[", 
          RowBox[{
           RowBox[{"m", "[", "a", "]"}], ",", "S2"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"DefTensor", "[", 
          RowBox[{
           RowBox[{"mbar", "[", "a", "]"}], ",", "S2", ",", 
           RowBox[{"PrintAs", "\[Rule]", "\"\<mb\>\""}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"m", "/:", 
          RowBox[{
           RowBox[{"m", "[", "a_", "]"}], 
           RowBox[{"m", "[", 
            RowBox[{"-", "a_"}], "]"}]}], ":=", "0"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"mbar", "/:", 
          RowBox[{
           RowBox[{"mbar", "[", "a_", "]"}], 
           RowBox[{"mbar", "[", 
            RowBox[{"-", "a_"}], "]"}]}], ":=", "0"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"mbar", "/:", 
          RowBox[{
           RowBox[{"m", "[", "a_", "]"}], 
           RowBox[{"mbar", "[", 
            RowBox[{"-", "a_"}], "]"}]}], ":=", "1"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"m", "/:", 
          RowBox[{
           RowBox[{"m", "[", 
            RowBox[{"-", "a_"}], "]"}], 
           RowBox[{"mbar", "[", "a_", "]"}]}], ":=", "1"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"ComponentValue", "[", 
          RowBox[{
           RowBox[{"ComponentArray", "[", 
            RowBox[{"m", "[", 
             RowBox[{"{", 
              RowBox[{"a", ",", "spherical"}], "}"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"I", " ", 
              RowBox[{
               RowBox[{"Csc", "[", 
                RowBox[{"\[Theta]", "[", "]"}], "]"}], "/", "2"}]}]}], 
            "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"ChangeComponents", "[", 
          RowBox[{
           RowBox[{"m", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "a"}], ",", 
              RowBox[{"-", "spherical"}]}], "}"}], "]"}], ",", 
           RowBox[{"m", "[", 
            RowBox[{"{", 
             RowBox[{"a", ",", "spherical"}], "}"}], "]"}]}], "]"}], ";", 
         RowBox[{"ComponentValue", "[", 
          RowBox[{
           RowBox[{"ComponentArray", "[", 
            RowBox[{"mbar", "[", 
             RowBox[{"{", 
              RowBox[{"a", ",", "spherical"}], "}"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{
              RowBox[{"-", "I"}], " ", 
              RowBox[{
               RowBox[{"Csc", "[", 
                RowBox[{"\[Theta]", "[", "]"}], "]"}], "/", "2"}]}]}], 
            "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"ChangeComponents", "[", 
          RowBox[{
           RowBox[{"mbar", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "a"}], ",", 
              RowBox[{"-", "spherical"}]}], "}"}], "]"}], ",", 
           RowBox[{"mbar", "[", 
            RowBox[{"{", 
             RowBox[{"a", ",", "spherical"}], "}"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"m", "/:", 
          RowBox[{
           RowBox[{"m", "[", "a_", "]"}], 
           RowBox[{"Basis", "[", 
            RowBox[{
             RowBox[{"-", "a_"}], ",", 
             RowBox[{"{", 
              RowBox[{"b_", ",", "spherical"}], "}"}]}], "]"}]}], ":=", 
          RowBox[{"m", "[", 
           RowBox[{"{", 
            RowBox[{"b", ",", "spherical"}], "}"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"m", "/:", 
          RowBox[{
           RowBox[{"m", "[", 
            RowBox[{"-", "a_"}], "]"}], 
           RowBox[{"Basis", "[", 
            RowBox[{"a_", ",", 
             RowBox[{"{", 
              RowBox[{"b_", ",", "spherical"}], "}"}]}], "]"}]}], ":=", 
          RowBox[{"m", "[", 
           RowBox[{"{", 
            RowBox[{"b", ",", "spherical"}], "}"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"mbar", "/:", 
          RowBox[{
           RowBox[{"mbar", "[", "a_", "]"}], 
           RowBox[{"Basis", "[", 
            RowBox[{
             RowBox[{"-", "a_"}], ",", 
             RowBox[{"{", 
              RowBox[{"b_", ",", "spherical"}], "}"}]}], "]"}]}], ":=", 
          RowBox[{"mbar", "[", 
           RowBox[{"{", 
            RowBox[{"b", ",", "spherical"}], "}"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"mbar", "/:", 
          RowBox[{
           RowBox[{"mbar", "[", 
            RowBox[{"-", "a_"}], "]"}], 
           RowBox[{"Basis", "[", 
            RowBox[{"a_", ",", 
             RowBox[{"{", 
              RowBox[{"b_", ",", "spherical"}], "}"}]}], "]"}]}], ":=", 
          RowBox[{"mbar", "[", 
           RowBox[{"{", 
            RowBox[{"b", ",", "spherical"}], "}"}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"5be102e3-c390-4241-b80e-9a6a02ed4cbc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefHarmonicStructure", "[", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Cartesian", " ", "structure"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"DefChart", "[", 
      RowBox[{"cartesian", ",", "S2", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y", "[", "]"}], ",", 
         RowBox[{"z", "[", "]"}]}], "}"}], ",", 
       RowBox[{"ChartColor", "\[Rule]", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"DefTensor", "[", 
      RowBox[{
       RowBox[{"x", "[", "]"}], ",", "S2"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Coordinate", "[", 
       RowBox[{"1", ",", "cartesian"}], "]"}], ":=", "x"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"DefTensor", "[", 
      RowBox[{
       RowBox[{"r", "[", "]"}], ",", "S2"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Coordinate", "[", 
       RowBox[{"1", ",", "spherical"}], "]"}], ":=", "r"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"change", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "]"}], "\[Rule]", 
         RowBox[{
          RowBox[{"r", "[", "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Theta]", "[", "]"}], "]"}], 
          RowBox[{"Cos", "[", 
           RowBox[{"\[Phi]", "[", "]"}], "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"y", "[", "]"}], "\[Rule]", 
         RowBox[{
          RowBox[{"r", "[", "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Theta]", "[", "]"}], "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Phi]", "[", "]"}], "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"z", "[", "]"}], "\[Rule]", 
         RowBox[{
          RowBox[{"r", "[", "]"}], 
          RowBox[{"Cos", "[", 
           RowBox[{"\[Theta]", "[", "]"}], "]"}]}]}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cartesian", "/:", 
      RowBox[{"CNumbersOf", "[", 
       RowBox[{"cartesian", ",", "TangentS2"}], "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"spherical", "/:", 
      RowBox[{"CNumbersOf", "[", 
       RowBox[{"spherical", ",", "TangentS2"}], "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"changeL", "=", 
       RowBox[{"ComponentArray", "[", 
        RowBox[{"Basis", ",", 
         RowBox[{"{", 
          RowBox[{"cartesian", ",", 
           RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"changeLinv", "=", 
       RowBox[{"ComponentArray", "[", 
        RowBox[{"Basis", ",", 
         RowBox[{"{", 
          RowBox[{"spherical", ",", 
           RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     RowBox[{"sphericalcoordinates", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Coordinate", "[", 
          RowBox[{"i", ",", "spherical"}], "]"}], "[", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], ";", 
     RowBox[{"cartesiancoordinates", "=", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Coordinate", "[", 
           RowBox[{"i", ",", "cartesian"}], "]"}], "[", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "3"}], "}"}]}], "]"}], "/.", "change"}]}], ";", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"changeR", "=", 
       RowBox[{"Outer", "[", 
        RowBox[{
        "D", ",", "cartesiancoordinates", ",", "sphericalcoordinates"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"changeRinv", "=", 
       RowBox[{"Simplify", "[", 
        RowBox[{"Inverse", "[", "changeR", "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ComponentValue", "[", 
      RowBox[{"changeL", ",", "changeR"}], "]"}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"ComponentValue", "[", 
      RowBox[{"changeLinv", ",", "changeRinv"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ChangeComponents", "[", 
      RowBox[{
       RowBox[{"m", "[", 
        RowBox[{"{", 
         RowBox[{"a", ",", "cartesian"}], "}"}], "]"}], ",", 
       RowBox[{"m", "[", 
        RowBox[{"{", 
         RowBox[{"a", ",", "spherical"}], "}"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ChangeComponents", "[", 
      RowBox[{
       RowBox[{"m", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "cartesian"}]}], "}"}], "]"}], ",", 
       RowBox[{"m", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "spherical"}]}], "}"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"r", "[", "]"}], ":=", "1"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"mmbarRule", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"mbar", "[", "a_", "]"}], 
        RowBox[{"m", "[", "b_", "]"}]}], "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"gamma", "[", 
           RowBox[{"a", ",", "b"}], "]"}], "+", 
          RowBox[{"I", " ", 
           RowBox[{"epsilongamma", "[", 
            RowBox[{"a", ",", "b"}], "]"}]}]}], ")"}], "/", "2"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"DefConstantSymbol", "[", "l", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"DefTensor", "[", 
      RowBox[{
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}], ",", 
         RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], ",", "S2"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"DefTensor", "[", 
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}], ",", 
         RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], ",", "S2"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"DefTensor", "[", 
      RowBox[{
       RowBox[{"calZ", "[", 
        RowBox[{
         RowBox[{"LI", "[", "sign", "]"}], ",", 
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}], ",", 
         RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], ",", "S2", ",", 
       RowBox[{"PrintAs", "\[Rule]", "\"\<\[GothicCapitalZ]\>\""}]}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calZ", "[", 
       RowBox[{
        RowBox[{"LI", "[", "1", "]"}], ",", 
        RowBox[{"LI", "[", "l_", "]"}], ",", 
        RowBox[{"LI", "[", "m_", "]"}]}], "]"}], ":=", 
      RowBox[{"2", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calZ", "[", 
       RowBox[{
        RowBox[{"LI", "[", "1", "]"}], ",", 
        RowBox[{"LI", "[", "l_", "]"}], ",", 
        RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
      RowBox[{"Z", "[", 
       RowBox[{
        RowBox[{"LI", "[", "l", "]"}], ",", 
        RowBox[{"LI", "[", "m", "]"}], ",", "inds"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calZ", "[", 
       RowBox[{
        RowBox[{"LI", "[", 
         RowBox[{"-", "1"}], "]"}], ",", 
        RowBox[{"LI", "[", "l_", "]"}], ",", 
        RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"-", "I"}], " ", 
       RowBox[{"X", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}], ",", "inds"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calZ", "[", 
       RowBox[{
        RowBox[{"LI", "[", 
         RowBox[{"c_.", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"a_.", "+", 
             RowBox[{"2", "b_"}]}], ")"}]}]}], "]"}], ",", 
        RowBox[{"LI", "[", "l_", "]"}], ",", 
        RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
      RowBox[{"calZ", "[", 
       RowBox[{
        RowBox[{"LI", "[", 
         RowBox[{"c", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", "a"}]}], "]"}], ",", 
        RowBox[{"LI", "[", "l", "]"}], ",", 
        RowBox[{"LI", "[", "m", "]"}], ",", "inds"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Z", "/:", 
      RowBox[{"Z", "[", 
       RowBox[{
        RowBox[{"LI", "[", "l_", "]"}], ",", 
        RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
      RowBox[{"0", "/;", 
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"{", "inds", "}"}], "]"}], ">", "l"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X", "/:", 
      RowBox[{"X", "[", 
       RowBox[{
        RowBox[{"LI", "[", "l_", "]"}], ",", 
        RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
      RowBox[{"0", "/;", 
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"{", "inds", "}"}], "]"}], ">", "l"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"calZ", "/:", 
      RowBox[{"calZ", "[", 
       RowBox[{
        RowBox[{"LI", "[", "sign_", "]"}], ",", 
        RowBox[{"LI", "[", "l_", "]"}], ",", 
        RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
      RowBox[{"0", "/;", 
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"{", "inds", "}"}], "]"}], ">", "l"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SymmetryGroupOfTensor", "[", 
       RowBox[{"Z", "[", 
        RowBox[{"_LI", ",", "_LI", ",", "indices___"}], "]"}], "]"}], "^:=", 
      RowBox[{"Symmetric", "[", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"Range", "@", 
          RowBox[{"Length", "@", 
           RowBox[{"{", "indices", "}"}]}]}]}], ",", "Cycles"}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SymmetryGroupOfTensor", "[", 
       RowBox[{"X", "[", 
        RowBox[{"_LI", ",", "_LI", ",", "indices___"}], "]"}], "]"}], "^:=", 
      RowBox[{"Symmetric", "[", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"Range", "@", 
          RowBox[{"Length", "@", 
           RowBox[{"{", "indices", "}"}]}]}]}], ",", "Cycles"}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SymmetryGroupOfTensor", "[", 
       RowBox[{"calZ", "[", 
        RowBox[{"_LI", ",", "_LI", ",", "_LI", ",", "indices___"}], "]"}], 
       "]"}], "^:=", 
      RowBox[{"Symmetric", "[", 
       RowBox[{
        RowBox[{"3", "+", 
         RowBox[{"Range", "@", 
          RowBox[{"Length", "@", 
           RowBox[{"{", "indices", "}"}]}]}]}], ",", "Cycles"}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Z", "[", 
       RowBox[{"_LI", ",", "_LI", ",", "___", ",", "a_", ",", "___", ",", 
        RowBox[{"-", "a_"}], ",", "___"}], "]"}], ":=", "0"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Z", "[", 
       RowBox[{"_LI", ",", "_LI", ",", "___", ",", 
        RowBox[{"-", "a_"}], ",", "___", ",", "a_", ",", "___"}], "]"}], ":=",
       "0"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"X", "[", 
       RowBox[{"_LI", ",", "_LI", ",", "___", ",", "a_", ",", "___", ",", 
        RowBox[{"-", "a_"}], ",", "___"}], "]"}], ":=", "0"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"X", "[", 
       RowBox[{"_LI", ",", "_LI", ",", "___", ",", 
        RowBox[{"-", "a_"}], ",", "___", ",", "a_", ",", "___"}], "]"}], ":=",
       "0"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calZ", "[", 
       RowBox[{
       "_LI", ",", "_LI", ",", "_LI", ",", "___", ",", "a_", ",", "___", ",", 
        
        RowBox[{"-", "a_"}], ",", "___"}], "]"}], ":=", "0"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calZ", "[", 
       RowBox[{"_LI", ",", "_LI", ",", "_LI", ",", "___", ",", 
        RowBox[{"-", "a_"}], ",", "___", ",", "a_", ",", "___"}], "]"}], ":=",
       "0"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"X", "[", 
       RowBox[{"_LI", ",", "_LI"}], "]"}], ":=", "0"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X", "/:", 
      RowBox[{
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l_", "]"}], ",", 
         RowBox[{"LI", "[", "m_", "]"}], ",", 
         RowBox[{"inds1__", "?", "AIndexQ"}]}], "]"}], 
       RowBox[{"X", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l_", "]"}], ",", 
         RowBox[{"LI", "[", "m_", "]"}], ",", 
         RowBox[{"inds2__", "?", "AIndexQ"}]}], "]"}]}], ":=", 
      RowBox[{"0", "/;", 
       RowBox[{
        RowBox[{"Sort", "[", 
         RowBox[{"xAct`xTensor`Private`TakePairs", "[", 
          RowBox[{"IndexList", "[", 
           RowBox[{"inds1", ",", "inds2"}], "]"}], "]"}], "]"}], "===", 
        RowBox[{"Sort", "[", 
         RowBox[{"IndexList", "[", 
          RowBox[{"inds1", ",", "inds2"}], "]"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ZToX", "=", 
      RowBox[{
       RowBox[{"Z", "[", 
        RowBox[{"l_LI", ",", "m_LI", ",", "a_", ",", "b___"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "c", "}"}], ",", 
         RowBox[{"-", 
          RowBox[{"Symmetrize", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"epsilongamma", "[", 
              RowBox[{"a", ",", "c"}], "]"}], 
             RowBox[{"X", "[", 
              RowBox[{"l", ",", "m", ",", 
               RowBox[{"-", "c"}], ",", "b"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]}], "]"}]}]}], ";", 
     RowBox[{"XToZ", "=", 
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{"l_LI", ",", "m_LI", ",", "a_", ",", "b___"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "c", "}"}], ",", 
         RowBox[{"Symmetrize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"epsilongamma", "[", 
             RowBox[{"a", ",", "c"}], "]"}], 
            RowBox[{"Z", "[", 
             RowBox[{"l", ",", "m", ",", 
              RowBox[{"-", "c"}], ",", "b"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}], "]"}]}]}], ";", 
     RowBox[{"calZTocalZ", "=", 
      RowBox[{
       RowBox[{"calZ", "[", 
        RowBox[{
         RowBox[{"LI", "[", "sign_", "]"}], ",", "l_LI", ",", "m_LI", ",", 
         "a_", ",", "b___"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "c", "}"}], ",", 
         RowBox[{
          RowBox[{"-", "I"}], " ", 
          RowBox[{"Symmetrize", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"epsilongamma", "[", 
              RowBox[{"a", ",", "c"}], "]"}], 
             RowBox[{"calZ", "[", 
              RowBox[{
               RowBox[{"LI", "[", 
                RowBox[{"-", "sign"}], "]"}], ",", "l", ",", "m", ",", 
               RowBox[{"-", "c"}], ",", "b"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Dropepsilon", "=", 
      RowBox[{
       RowBox[{"term", ":", 
        RowBox[{"(", 
         RowBox[{"_.", " ", 
          RowBox[{"epsilongamma", "[", 
           RowBox[{"a_", ",", "b_"}], "]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Z", "|", "X", "|", "calZ"}], ")"}], "[", "__", "]"}]}], 
         ")"}]}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"ReplaceAll", "[", 
         RowBox[{"term", ",", 
          RowBox[{"{", 
           RowBox[{"ZToX", ",", "XToZ", ",", "calZTocalZ"}], "}"}]}], "]"}], "/;", 
        RowBox[{
         RowBox[{"IsIndexOf", "[", 
          RowBox[{"term", ",", 
           RowBox[{"-", "a"}]}], "]"}], "||", 
         RowBox[{"IsIndexOf", "[", 
          RowBox[{"term", ",", 
           RowBox[{"-", "b"}]}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"cd", "[", "a_", "]"}], "[", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l_", "]"}], ",", 
         RowBox[{"LI", "[", "m_", "]"}]}], "]"}], "]"}], ":=", 
      RowBox[{"Z", "[", 
       RowBox[{
        RowBox[{"LI", "[", "l", "]"}], ",", 
        RowBox[{"LI", "[", "m", "]"}], ",", "a"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"cd", "[", "b_", "]"}], "[", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l_", "]"}], ",", 
         RowBox[{"LI", "[", "m_", "]"}], ",", 
         RowBox[{"a_", "?", "AIndexQ"}]}], "]"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}], ",", "a", ",", "b"}], "]"}], "-", 
       RowBox[{"l", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "+", "1"}], ")"}], "/", "2"}], 
        RowBox[{"gamma", "[", 
         RowBox[{"a", ",", "b"}], "]"}], 
        RowBox[{"Z", "[", 
         RowBox[{
          RowBox[{"LI", "[", "l", "]"}], ",", 
          RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"cd", "[", "b_", "]"}], "[", 
       RowBox[{"X", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l_", "]"}], ",", 
         RowBox[{"LI", "[", "m_", "]"}], ",", 
         RowBox[{"a_", "?", "AIndexQ"}]}], "]"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}], ",", "a", ",", "b"}], "]"}], "-", 
       RowBox[{"l", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "+", "1"}], ")"}], "/", "2"}], 
        RowBox[{"epsilongamma", "[", 
         RowBox[{"a", ",", "b"}], "]"}], 
        RowBox[{"Z", "[", 
         RowBox[{
          RowBox[{"LI", "[", "l", "]"}], ",", 
          RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"cd", "[", "b_", "]"}], "[", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l_", "]"}], ",", 
         RowBox[{"LI", "[", "m_", "]"}], ",", 
         RowBox[{"a1_", "?", "AIndexQ"}], ",", 
         RowBox[{"a2_", "?", "AIndexQ"}], ",", 
         RowBox[{"a___", "?", "AIndexQ"}]}], "]"}], "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "b$", "}"}], ",", 
        RowBox[{
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"s", "=", 
             RowBox[{"1", "+", "1", "+", 
              RowBox[{"Length", "[", 
               RowBox[{"{", "a", "}"}], "]"}]}]}], "}"}], ",", 
           RowBox[{
            RowBox[{"Z", "[", 
             RowBox[{
              RowBox[{"LI", "[", "l", "]"}], ",", 
              RowBox[{"LI", "[", "m", "]"}], ",", "a1", ",", "a2", ",", "a", ",",
               "b$"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "+", "s"}], ")"}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"l", "-", "s", "+", "1"}], ")"}], "/", "2"}], 
             RowBox[{"Symmetrize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"1", "/", "2"}], 
                 RowBox[{"gamma", "[", 
                  RowBox[{"a1", ",", "a2"}], "]"}], 
                 RowBox[{"Z", "[", 
                  RowBox[{
                   RowBox[{"LI", "[", "l", "]"}], ",", 
                   RowBox[{"LI", "[", "m", "]"}], ",", "a", ",", "b$"}], 
                  "]"}]}], "-", 
                RowBox[{
                 RowBox[{"gamma", "[", 
                  RowBox[{"b$", ",", "a1"}], "]"}], 
                 RowBox[{"Z", "[", 
                  RowBox[{
                   RowBox[{"LI", "[", "l", "]"}], ",", 
                   RowBox[{"LI", "[", "m", "]"}], ",", "a2", ",", "a"}], 
                  "]"}]}]}], ",", 
               RowBox[{"{", 
                RowBox[{"a1", ",", "a2", ",", "a"}], "}"}]}], "]"}]}]}]}], 
          "]"}], "/.", 
         RowBox[{"b$", "\[Rule]", "b"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"cd", "[", "b_", "]"}], "[", 
       RowBox[{"X", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l_", "]"}], ",", 
         RowBox[{"LI", "[", "m_", "]"}], ",", 
         RowBox[{"a1_", "?", "AIndexQ"}], ",", 
         RowBox[{"a2_", "?", "AIndexQ"}], ",", 
         RowBox[{"a___", "?", "AIndexQ"}]}], "]"}], "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "b$", "}"}], ",", 
        RowBox[{
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"s", "=", 
             RowBox[{"1", "+", "1", "+", 
              RowBox[{"Length", "[", 
               RowBox[{"{", "a", "}"}], "]"}]}]}], "}"}], ",", 
           RowBox[{
            RowBox[{"X", "[", 
             RowBox[{
              RowBox[{"LI", "[", "l", "]"}], ",", 
              RowBox[{"LI", "[", "m", "]"}], ",", "a1", ",", "a2", ",", "a", ",", \
"b$"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "+", "s"}], ")"}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"l", "-", "s", "+", "1"}], ")"}], "/", "2"}], 
             RowBox[{"Symmetrize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"1", "/", "2"}], 
                 RowBox[{"gamma", "[", 
                  RowBox[{"a1", ",", "a2"}], "]"}], 
                 RowBox[{"X", "[", 
                  RowBox[{
                   RowBox[{"LI", "[", "l", "]"}], ",", 
                   RowBox[{"LI", "[", "m", "]"}], ",", "a", ",", "b$"}], 
                  "]"}]}], "-", 
                RowBox[{
                 RowBox[{"gamma", "[", 
                  RowBox[{"b$", ",", "a1"}], "]"}], 
                 RowBox[{"X", "[", 
                  RowBox[{
                   RowBox[{"LI", "[", "l", "]"}], ",", 
                   RowBox[{"LI", "[", "m", "]"}], ",", "a2", ",", "a"}], 
                  "]"}]}]}], ",", 
               RowBox[{"{", 
                RowBox[{"a1", ",", "a2", ",", "a"}], "}"}]}], "]"}]}]}]}], 
          "]"}], "/.", 
         RowBox[{"b$", "\[Rule]", "b"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"coeffK", "[", 
       RowBox[{"l_", ",", "s_"}], "]"}], ":=", 
      RowBox[{"Infinity", "/;", 
       RowBox[{"s", ">", "l"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"coeffK", "[", 
       RowBox[{"l_", ",", "s_"}], "]"}], ":=", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "l"}], "+", "1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"4", "Pi"}], ")"}]}], "/", 
         RowBox[{"2", "^", "s"}]}], " ", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"l", "+", "s"}], ")"}], "!"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"l", "-", "s"}], ")"}], "!"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"DefTensor", "[", 
      RowBox[{
       RowBox[{"calD", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "mp", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}]}], "]"}], ",", "manifold", ",", 
       RowBox[{"PrintAs", "->", "\"\<\[GothicCapitalD]\>\""}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"PureSpin", "[", 
        RowBox[{"l_", ",", "1", ",", "mlabel_"}], "]"}], "[", "inds___", 
       "]"}], ":=", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"s", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", "inds", "}"}], "]"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"coeffK", "[", 
          RowBox[{"l", ",", "s"}], "]"}], 
         RowBox[{"calD", "[", 
          RowBox[{
           RowBox[{"LI", "@", "l"}], ",", 
           RowBox[{"LI", "@", "s"}], ",", 
           RowBox[{"LI", "@", "mlabel"}]}], "]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", "s"}], " ", 
         RowBox[{"Times", "@@", 
          RowBox[{"(", 
           RowBox[{"m", "/@", 
            RowBox[{"{", "inds", "}"}]}], ")"}]}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"PureSpin", "[", 
        RowBox[{"l_", ",", 
         RowBox[{"-", "1"}], ",", "mlabel_"}], "]"}], "[", "inds___", "]"}], ":=", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"s", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", "inds", "}"}], "]"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"coeffK", "[", 
          RowBox[{"l", ",", "s"}], "]"}], 
         RowBox[{"calD", "[", 
          RowBox[{
           RowBox[{"LI", "@", "l"}], ",", 
           RowBox[{"LI", "@", 
            RowBox[{"-", "s"}]}], ",", 
           RowBox[{"LI", "@", "mlabel"}]}], "]"}], 
         RowBox[{"Times", "@@", 
          RowBox[{"(", 
           RowBox[{"mbar", "/@", 
            RowBox[{"{", "inds", "}"}]}], ")"}]}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ZXToY", ":=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Z", "[", 
          RowBox[{
           RowBox[{"LI", "[", "l_", "]"}], ",", 
           RowBox[{"LI", "[", "m_", "]"}]}], "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"PureSpin", "[", 
           RowBox[{"l", ",", "1", ",", "m"}], "]"}], "[", "]"}]}], ",", 
        RowBox[{
         RowBox[{"Z", "[", 
          RowBox[{
           RowBox[{"LI", "[", "l_", "]"}], ",", 
           RowBox[{"LI", "[", "m_", "]"}], ",", "inds__"}], "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{
           RowBox[{"PureSpin", "[", 
            RowBox[{"l", ",", "1", ",", "m"}], "]"}], "[", "inds", "]"}], "+", 
          RowBox[{
           RowBox[{"PureSpin", "[", 
            RowBox[{"l", ",", 
             RowBox[{"-", "1"}], ",", "m"}], "]"}], "[", "inds", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{
           RowBox[{"LI", "[", "l_", "]"}], ",", 
           RowBox[{"LI", "[", "m_", "]"}], ",", "inds__"}], "]"}], "\[RuleDelayed]", 
         RowBox[{"I", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"PureSpin", "[", 
              RowBox[{"l", ",", "1", ",", "m"}], "]"}], "[", "inds", "]"}], "-", 
            RowBox[{
             RowBox[{"PureSpin", "[", 
              RowBox[{"l", ",", 
               RowBox[{"-", "1"}], ",", "m"}], "]"}], "[", "inds", "]"}]}], 
           ")"}]}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"spherical", "/:", 
      RowBox[{"CNumbersOf", "[", 
       RowBox[{"spherical", ",", "TangentS2"}], "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cartesian", "/:", 
      RowBox[{"CNumbersOf", "[", 
       RowBox[{"cartesian", ",", "TangentS2"}], "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], ";", "\n", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"HarmonicComponent", "[", "expr_", "]"}], ":=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"ToValues", "[", 
        RowBox[{
         RowBox[{"expr", "/.", "ZXToY"}], "/.", "calDRule"}], "]"}], "]"}]}], 
     ";", "\n", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Format", "[", 
       RowBox[{"coeffE", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"s_", ",", "l_", ",", "m_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"sp_", ",", "lp_", ",", "mp_"}], "}"}], ",", "lpp_"}], 
        "]"}], "]"}], ":=", 
      RowBox[{"Subsuperscript", "[", 
       RowBox[{"\"\<E\>\"", ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"ToString", "[", "s", "]"}], ",", "\"\<,\>\"", ",", 
          RowBox[{"ToString", "[", "l", "]"}], ",", "\"\<,\>\"", ",", 
          RowBox[{"ToString", "[", "m", "]"}], ",", "\"\<;\>\"", ",", 
          RowBox[{"ToString", "[", "lpp", "]"}]}], "]"}], ",", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"ToString", "[", "sp", "]"}], ",", "\"\<,\>\"", ",", 
          RowBox[{"ToString", "[", "lp", "]"}], ",", "\"\<,\>\"", ",", 
          RowBox[{"ToString", "[", "mp", "]"}]}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"coeffE", "/:", 
      RowBox[{"FindIndices", "[", 
       RowBox[{"coeffE", "[", "___", "]"}], "]"}], "=", 
      RowBox[{"IndexList", "[", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"_", "?", "FirstDerQ"}], "[", 
       RowBox[{"coeffE", "[", "__", "]"}], "]"}], "^=", "0"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"IsIndexOf", "[", 
       RowBox[{
        RowBox[{"coeffE", "[", "___", "]"}], ",", "__"}], "]"}], "^:=", 
      "False"}], ";", "\[IndentingNewLine]", 
     RowBox[{"coeffERule", "=", 
      RowBox[{
       RowBox[{"coeffE", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"s_", ",", "l_", ",", "m_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"sp_", ",", "lp_", ",", "mp_"}], "}"}], ",", "lpp_"}], 
        "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"coeffK", "[", 
         RowBox[{"lp", ",", 
          RowBox[{"Abs", "[", "sp", "]"}]}], "]"}], 
        RowBox[{
         RowBox[{"coeffK", "[", 
          RowBox[{"l", ",", 
           RowBox[{"Abs", "[", "s", "]"}]}], "]"}], "/", 
         RowBox[{"coeffK", "[", 
          RowBox[{"lpp", ",", 
           RowBox[{"Abs", "[", 
            RowBox[{"s", "+", "sp"}], "]"}]}], "]"}]}], 
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"lp", ",", "mp"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "m"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"lpp", ",", 
            RowBox[{"m", "+", "mp"}]}], "}"}]}], "]"}], 
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"lp", ",", "sp"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "s"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"lpp", ",", 
            RowBox[{"s", "+", "sp"}]}], "}"}]}], "]"}]}]}]}], ";", "\n", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"TTensor", "[", "1", "]"}], "[", 
       RowBox[{"ainds_List", ",", "binds_List"}], "]"}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", 
        RowBox[{"Length", "[", "ainds", "]"}]}], 
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{"mbar", "/@", "ainds"}], ")"}]}], 
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{"m", "/@", "binds"}], ")"}]}]}]}], ";", 
     RowBox[{
      RowBox[{
       RowBox[{"TTensor", "[", 
        RowBox[{"-", "1"}], "]"}], "[", 
       RowBox[{"ainds_List", ",", "binds_List"}], "]"}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", 
        RowBox[{"Length", "[", "ainds", "]"}]}], 
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{"m", "/@", "ainds"}], ")"}]}], 
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{"mbar", "/@", "binds"}], ")"}]}]}]}], ";", "\n", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"calTTensor", "[", "sign_", "]"}], "[", 
       RowBox[{"ainds_List", ",", "binds_List"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"1", "/", "2"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"TTensor", "[", 
           RowBox[{"-", "1"}], "]"}], "[", 
          RowBox[{"ainds", ",", "binds"}], "]"}], "+", 
         RowBox[{"sign", " ", 
          RowBox[{
           RowBox[{"TTensor", "[", "1", "]"}], "[", 
           RowBox[{"ainds", ",", "binds"}], "]"}]}]}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ProductRule", ":=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"rest_.", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"tp", ":", 
             RowBox[{"(", 
              RowBox[{"Z", "|", "X"}], ")"}]}], ")"}], "[", 
           RowBox[{
            RowBox[{"LI", "[", "lp_", "]"}], ",", 
            RowBox[{"LI", "[", "mp_", "]"}], ",", "a___"}], "]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"t", ":", 
             RowBox[{"(", 
              RowBox[{"Z", "|", "X"}], ")"}]}], ")"}], "[", 
           RowBox[{
            RowBox[{"LI", "[", "l_", "]"}], ",", 
            RowBox[{"LI", "[", "mlabel_", "]"}], ",", "b___"}], "]"}]}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"sp", "=", 
               RowBox[{"Length", "[", 
                RowBox[{"{", "a", "}"}], "]"}]}], ",", 
              RowBox[{"s", "=", 
               RowBox[{"Length", "[", 
                RowBox[{"{", "b", "}"}], "]"}]}], ",", "ab", ",", "aa", ",", 
              "sigma", ",", "sigmap", ",", "coeff", ",", "coeffp"}], "}"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{"coeffp", ",", "sigmap"}], "}"}], "=", 
              RowBox[{"Switch", "[", 
               RowBox[{"tp", ",", "Z", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", "X", ",", 
                RowBox[{"{", 
                 RowBox[{"I", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"coeff", ",", "sigma"}], "}"}], "=", 
              RowBox[{"Switch", "[", 
               RowBox[{"t", ",", "Z", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", "X", ",", 
                RowBox[{"{", 
                 RowBox[{"I", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"ab", "=", 
              RowBox[{"Sequence", "@@", 
               RowBox[{"Drop", "[", 
                RowBox[{
                 RowBox[{"{", "a", "}"}], ",", "s"}], "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"aa", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{
                RowBox[{"{", "a", "}"}], ",", 
                RowBox[{
                 RowBox[{"-", "sp"}], "+", "s"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"rest", " ", "coeffp", " ", "coeff", " ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"s", "===", "0"}], ",", 
                RowBox[{"1", "/", "2"}], ",", "1"}], "]"}], 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"sp", "===", "0"}], ",", 
                RowBox[{"1", "/", "2"}], ",", "1"}], "]"}], 
              RowBox[{"Sum", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"coeffE", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"sp", ",", "lp", ",", "mp"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"s", ",", "l", ",", "mlabel"}], "}"}], ",", 
                    "lpp"}], "]"}], 
                  RowBox[{"calZ", "[", 
                   RowBox[{
                    RowBox[{"LI", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"l", "+", "lp", "-", "lpp"}], ")"}]}], "sigma", " ",
                     "sigmap"}], "]"}], ",", 
                    RowBox[{"LI", "[", "lpp", "]"}], ",", 
                    RowBox[{"LI", "[", 
                    RowBox[{"mp", "+", "mlabel"}], "]"}], ",", "a", ",", 
                    "b"}], "]"}]}], "+", 
                 RowBox[{"sigma", " ", 
                  RowBox[{"coeffE", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"sp", ",", "lp", ",", "mp"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "s"}], ",", "l", ",", "mlabel"}], "}"}], ",",
                     "lpp"}], "]"}], 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"calTTensor", "[", 
                    RowBox[{"+", "1"}], "]"}], "[", 
                    RowBox[{"aa", ",", 
                    RowBox[{"{", "b", "}"}]}], "]"}], 
                    RowBox[{"calZ", "[", 
                    RowBox[{
                    RowBox[{"LI", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"l", "+", "lp", "-", "lpp"}], ")"}]}], "sigma", " ",
                     "sigmap"}], "]"}], ",", 
                    RowBox[{"LI", "[", "lpp", "]"}], ",", 
                    RowBox[{"LI", "[", 
                    RowBox[{"mp", "+", "mlabel"}], "]"}], ",", "ab"}], 
                    "]"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"calTTensor", "[", 
                    RowBox[{"-", "1"}], "]"}], "[", 
                    RowBox[{"aa", ",", 
                    RowBox[{"{", "b", "}"}]}], "]"}], 
                    RowBox[{"calZ", "[", 
                    RowBox[{
                    RowBox[{"LI", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"l", "+", "lp", "-", "lpp"}], ")"}]}]}], "sigma", 
                    " ", "sigmap"}], "]"}], ",", 
                    RowBox[{"LI", "[", "lpp", "]"}], ",", 
                    RowBox[{"LI", "[", 
                    RowBox[{"mp", "+", "mlabel"}], "]"}], ",", "ab"}], 
                    "]"}]}]}], ")"}]}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"lpp", ",", 
                  RowBox[{"Abs", "[", 
                   RowBox[{"lp", "-", "l"}], "]"}], ",", 
                  RowBox[{"lp", "+", "l"}]}], "}"}]}], "]"}]}]}]}], "]"}], "/;", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "a", "}"}], "]"}], "\[GreaterEqual]", 
           RowBox[{"Length", "[", 
            RowBox[{"{", "b", "}"}], "]"}]}]}]}], ",", 
        RowBox[{
         RowBox[{"rest_.", " ", 
          RowBox[{
           RowBox[{"Z", "[", 
            RowBox[{
             RowBox[{"LI", "[", "l_", "]"}], ",", 
             RowBox[{"LI", "[", "mlabel_", "]"}]}], "]"}], "^", "2"}]}], "\[RuleDelayed]", 
         RowBox[{"rest", " ", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"coeffE", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "l", ",", "mlabel"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "l", ",", "mlabel"}], "}"}], ",", "lpp"}], 
              "]"}], 
             RowBox[{"Z", "[", 
              RowBox[{
               RowBox[{"LI", "[", "lpp", "]"}], ",", 
               RowBox[{"LI", "[", 
                RowBox[{"2", "mlabel"}], "]"}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"lpp", ",", "0", ",", 
              RowBox[{"2", "l"}]}], "}"}]}], "]"}]}]}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"FormalProductRule", "[", "lc_", "]"}], ":=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"rest_.", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"ta", ":", 
             RowBox[{"(", 
              RowBox[{"Z", "|", "X"}], ")"}]}], ")"}], "[", 
           RowBox[{
            RowBox[{"LI", "[", "la_", "]"}], ",", 
            RowBox[{"LI", "[", "ma_", "]"}], ",", "a___"}], "]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"tb", ":", 
             RowBox[{"(", 
              RowBox[{"Z", "|", "X"}], ")"}]}], ")"}], "[", 
           RowBox[{
            RowBox[{"LI", "[", "lb_", "]"}], ",", 
            RowBox[{"LI", "[", "mb_", "]"}], ",", "b___"}], "]"}]}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"sa", "=", 
               RowBox[{"Length", "[", 
                RowBox[{"{", "a", "}"}], "]"}]}], ",", 
              RowBox[{"sb", "=", 
               RowBox[{"Length", "[", 
                RowBox[{"{", "b", "}"}], "]"}]}], ",", "sigmaa", ",", 
              "sigmab", ",", "coeffa", ",", "coeffb", ",", "indicesA", ",", 
              "indicesZ"}], "}"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{"coeffa", ",", "sigmaa"}], "}"}], "=", 
              RowBox[{"Switch", "[", 
               RowBox[{"ta", ",", "Z", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", "X", ",", 
                RowBox[{"{", 
                 RowBox[{"I", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"coeffb", ",", "sigmab"}], "}"}], "=", 
              RowBox[{"Switch", "[", 
               RowBox[{"tb", ",", "Z", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], ",", "X", ",", 
                RowBox[{"{", 
                 RowBox[{"I", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"indicesZ", "=", 
              RowBox[{"Sequence", "@@", 
               RowBox[{"(", 
                RowBox[{"Drop", "[", 
                 RowBox[{
                  RowBox[{"{", "a", "}"}], ",", "sb"}], "]"}], ")"}]}]}], ";",
              "\[IndentingNewLine]", 
             RowBox[{"indicesA", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{
                RowBox[{"{", "a", "}"}], ",", 
                RowBox[{"sb", "-", "sa"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"rest", " ", "coeffa", " ", "coeffb", " ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"sa", "===", "0"}], ",", 
                RowBox[{"1", "/", "2"}], ",", "1"}], "]"}], 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"sb", "===", "0"}], ",", 
                RowBox[{"1", "/", "2"}], ",", "1"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"coeffE", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"sa", ",", "la", ",", "ma"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"sb", ",", "lb", ",", "mb"}], "}"}], ",", "lc"}], 
                  "]"}], 
                 RowBox[{"calZ", "[", 
                  RowBox[{
                   RowBox[{"LI", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"lb", "+", "la", "-", "lc"}], ")"}]}], "sigmaa", " ",
                     "sigmab"}], "]"}], ",", 
                   RowBox[{"LI", "[", "lc", "]"}], ",", 
                   RowBox[{"LI", "[", 
                    RowBox[{"ma", "+", "mb"}], "]"}], ",", "a", ",", "b"}], 
                  "]"}]}], "+", 
                RowBox[{"sigmab", " ", 
                 RowBox[{"coeffE", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"sa", ",", "la", ",", "ma"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "sb"}], ",", "lb", ",", "mb"}], "}"}], ",", 
                   "lc"}], "]"}], 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"calTTensor", "[", 
                    RowBox[{"+", "1"}], "]"}], "[", 
                    RowBox[{"indicesA", ",", 
                    RowBox[{"{", "b", "}"}]}], "]"}], 
                    RowBox[{"calZ", "[", 
                    RowBox[{
                    RowBox[{"LI", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"lb", "+", "la", "-", "lc"}], ")"}]}], "sigmaa", " ",
                     "sigmab"}], "]"}], ",", 
                    RowBox[{"LI", "[", "lc", "]"}], ",", 
                    RowBox[{"LI", "[", 
                    RowBox[{"ma", "+", "mb"}], "]"}], ",", "indicesZ"}], 
                    "]"}]}], "+", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"calTTensor", "[", 
                    RowBox[{"-", "1"}], "]"}], "[", 
                    RowBox[{"indicesA", ",", 
                    RowBox[{"{", "b", "}"}]}], "]"}], 
                    RowBox[{"calZ", "[", 
                    RowBox[{
                    RowBox[{"LI", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"lb", "+", "la", "-", "lc"}], ")"}]}]}], "sigmaa",
                     " ", "sigmab"}], "]"}], ",", 
                    RowBox[{"LI", "[", "lc", "]"}], ",", 
                    RowBox[{"LI", "[", 
                    RowBox[{"ma", "+", "mb"}], "]"}], ",", "indicesZ"}], 
                    "]"}]}]}], ")"}]}]}], ")"}]}]}]}], "]"}], "/;", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "a", "}"}], "]"}], "\[GreaterEqual]", 
           RowBox[{"Length", "[", 
            RowBox[{"{", "b", "}"}], "]"}]}]}]}], ",", 
        RowBox[{
         RowBox[{"rest_.", " ", 
          RowBox[{
           RowBox[{"Z", "[", 
            RowBox[{
             RowBox[{"LI", "[", "la_", "]"}], ",", 
             RowBox[{"LI", "[", "ma_", "]"}]}], "]"}], "^", "2"}]}], "\[RuleDelayed]", 
         RowBox[{"rest", " ", 
          RowBox[{"coeffE", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "la", ",", "ma"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "la", ",", "ma"}], "}"}], ",", "lc"}], "]"}], 
          RowBox[{
           RowBox[{"calZ", "[", 
            RowBox[{
             RowBox[{"LI", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"-", "lc"}], ")"}]}], "]"}], ",", 
             RowBox[{"LI", "[", "lc", "]"}], ",", 
             RowBox[{"LI", "[", 
              RowBox[{"2", "ma"}], "]"}]}], "]"}], "/", "2"}]}]}]}], "}"}]}], 
     ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "]"}]}]], "Input",ExpressionUUID->"f5896eb4-c9ba-40ea-b02d-e60b806ef1a0"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1. Definition of manifold", \
"Subsubsection",ExpressionUUID->"5aa7c305-49f2-4798-94f2-25c6343c5bc6"],

Cell["Define S2 manifold", \
"Text",ExpressionUUID->"77261904-a7b2-4b3d-9d8d-fd998b82368c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"S2", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fe5240d4-d679-4737-a758-6f2e4fdbbc93"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "S2", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefManifold, ": Defining ", "manifold ", S2, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"b808ac7a-3c8a-4e73-b222-08f7a0c32708"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentS2", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", DefVBundle, ": Defining ", "vbundle ", TangentS2, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"67ef97e5-d499-452c-b177-b33e4e2cd249"]
}, Open  ]]
}, Open  ]],

Cell["with round metric", \
"Text",ExpressionUUID->"81bf7d6e-c374-42ae-acdb-5ae1b296702d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{"1", ",", 
   RowBox[{"gamma", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "cd", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<:\>\"", ",", "\"\<D\>\""}], "}"}], ",", 
   RowBox[{"PrintAs", "->", "\"\<\[Gamma]\>\""}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"586fe43a-2a5d-4ef4-b27e-dee9e4315d8d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"gamma", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "symmetric metric tensor ", 
   gamma[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"0fc1159a-5cc7-4ead-b22c-e0988cb8ec1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongamma", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "antisymmetric tensor ", 
   epsilongamma[a, b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"72c58333-9f00-4ac8-b8f8-9b7097f2e7bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"cd", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefCovD, ": Defining ", "covariant derivative ", 
   cd[-a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"46f2b01f-4860-4493-a4ea-37fc9ffc4cf2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Torsioncd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing torsion tensor ", 
   Torsioncd[a, -b, -c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"2af556af-bba1-4003-a865-3eb474a9907f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Christoffelcd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", DefTensor, ": Defining ", "symmetric Christoffel tensor ", 
   Christoffelcd[a, -b, -c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"8f58e118-c9ee-42d3-ac6c-32c7948348b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Riemanncd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "Riemann tensor ", 
   Riemanncd[-a, -b, -c, -d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"87c1cc40-4411-43da-8b5f-f02457244eb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Riccicd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   Riccicd[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"5b412c28-01d3-438b-9dd7-f84e52bce2ab"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], \
"Print",ExpressionUUID->"75f874cf-3f34-44f6-b1ba-2073a71906e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarcd", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "Ricci scalar ", 
   RicciScalarcd[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"32cd4783-1fac-4f4d-aa81-c37734f288df"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], \
"Print",ExpressionUUID->"5910b9f8-d569-42ab-ab7e-6fd221b76fa2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Einstein tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Einsteincd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", DefTensor, ": Defining ", "vanishing Einstein tensor ", 
   Einsteincd[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"9feaa453-525f-4774-92a6-f1a78cac4885"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Weylcd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   Weylcd[-a, -b, -c, -d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"43e75646-28e6-4064-ab14-0da838a7db8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing TFRicci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TFRiccicd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing TFRicci tensor ", 
   TFRiccicd[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"07324698-317a-4aec-817a-10f7df8524f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"Kretschmanncd", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "Kretschmann scalar ", 
   Kretschmanncd[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"ce481e4d-4ecc-4fd7-8eec-c96a2c6fa03b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", "\[InvisibleSpace]",
    "2"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 2],
  Editable->
   False]], "Print",ExpressionUUID->"f2e56f36-bb0e-4dc1-9085-7097b336b280"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", "\[InvisibleSpace]",
    "2"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 2],
  Editable->
   False]], "Print",ExpressionUUID->"4ab88125-9d36-4e80-97b3-1df3fdf6acc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", "\[InvisibleSpace]",
    "2"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 2],
  Editable->
   False]], "Print",ExpressionUUID->"f4f57a40-3ea4-41cd-b5f9-28f9a5b58d85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detgamma", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "weight +2 density ", 
   Detgamma[], ". ", "Determinant."],
  Editable->
   False]], "Print",ExpressionUUID->"3bae6a8a-7027-4ed4-9067-690e08f38408"]
}, Open  ]]
}, Open  ]],

Cell["Constant (unit) Gaussian curvature:", \
"Text",ExpressionUUID->"ea1cf0a1-73c0-489c-ba6c-6e8fb0aa3b87"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RicciScalarcd", "[", "]"}], ":=", "2"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c73bb581-659e-4833-84a8-8841dcd7749f"],

Cell["We can now define the calD scalars:", \
"Text",ExpressionUUID->"4fa2b31e-0a7b-4f8b-ac94-0d268e3442ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"calD", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "mp", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}]}], "]"}], ",", "S2", ",", 
   RowBox[{"PrintAs", "->", "\"\<\[GothicCapitalD]\>\""}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e69af515-7210-4d93-b88a-c6f09119aa02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"calD", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "mp", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   calD[
    LI[l], 
    LI[mp], 
    LI[m]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"efaea4b0-4164-4b5e-ac9c-f5dd33c36fc6"]
}, Open  ]],

Cell["\<\
We shall use the convention of having three upper label indices\
\>", "Text",ExpressionUUID->"69863469-554d-4df3-90a3-177f1ae76241"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"calD", "[", 
  RowBox[{
   RowBox[{"LI", "[", "l", "]"}], ",", 
   RowBox[{"LI", "[", 
    RowBox[{"m", "'"}], "]"}], ",", 
   RowBox[{"LI", "[", "m", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"c243896d-0f8a-47a1-a15e-35311029679d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["\[GothicCapitalD]", "   ", 
    RowBox[{
     RowBox[{"lm", "'"}], "m"}]],
   AutoSpacing->False],
  calD[
   LI[l], 
   LI[
    Derivative[1][m]], 
   LI[m]],
  Editable->
   False]], "Output",ExpressionUUID->"44eab46b-d0c8-4b4f-b416-501a34e3f2b3"]
}, Open  ]],

Cell["instead of the usual", \
"Text",ExpressionUUID->"954ddf62-2792-4b56-871d-979650d64c3c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"calD", "[", 
  RowBox[{
   RowBox[{"LI", "[", "l", "]"}], ",", 
   RowBox[{"-", 
    RowBox[{"LI", "[", 
     RowBox[{"m", "'"}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"LI", "[", "m", "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"91551d53-e880-4d94-935e-9043b1824421"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["\[GothicCapitalD]", 
    RowBox[{" ", 
     RowBox[{
      RowBox[{"m", "'"}], "m"}]}], 
    RowBox[{"l", "  "}]],
   AutoSpacing->False],
  calD[
   LI[l], -LI[
     Derivative[1][m]], -LI[m]],
  Editable->
   False]], "Output",ExpressionUUID->"258cff15-8abc-4352-a62b-684d69c56126"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. Coordinate systems", \
"Subsubsection",ExpressionUUID->"21f67853-4829-49bd-aa94-374ec3d43a6f"],

Cell["\<\
We use a dirty trick to have 3-dimensional coordinate systems on the \
2-dimensional manifold S2:\
\>", "Text",ExpressionUUID->"25ec6099-1095-4f40-864f-a4266fcb50b3"],

Cell["Define the cartesian coordinate system:", \
"Text",ExpressionUUID->"0ca18145-aa5c-4864-8842-28d9cb1109fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"cartesian", ",", "S2", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "]"}], ",", 
     RowBox[{"z", "[", "]"}]}], "}"}], ",", 
   RowBox[{"ChartColor", "\[Rule]", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}]}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c1a14d6d-471f-4a52-87eb-f499bbaa692a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"y", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   y[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"40eb7538-7deb-42c2-9842-75b9d6fcf77f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"z", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   z[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"a0479957-be51-4d5c-aaa4-e6e92d16d688"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "cartesian", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefBasis, ": Defining ", "basis ", cartesian, ". ", ""],
  
  Editable->
   False]], "Print",ExpressionUUID->"1a8df3c7-e121-48fe-9adf-6942e7101346"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDcartesian", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefCovD, ": Defining ", "parallel derivative ", 
   PDcartesian[-a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"abdb1ed3-9ef0-4db0-abde-853303d0051a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDcartesian", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing torsion tensor ", 
   TorsionPDcartesian[a, -b, -c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"27b70dee-2f0e-4e39-8b0d-7cc0a32c42c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDcartesian", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", DefTensor, ": Defining ", "symmetric Christoffel tensor ", 
   ChristoffelPDcartesian[a, -b, -c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"2e551579-4fcc-4f26-a5bd-ceb619589446"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannPDcartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   RiemannPDcartesian[-a, -b, -c, d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"84ef3fcb-7f3c-4603-b4f9-5612197859c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciPDcartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   RicciPDcartesian[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"d9df332d-719f-4f1b-8a0e-dd3726743407"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"etaUpcartesian", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "antisymmetric +1 density ", 
   etaUpcartesian[a, b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"b1ebe4c5-4540-4f43-b5ed-b98db0a3820e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"etaDowncartesian", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "antisymmetric -1 density ", 
   etaDowncartesian[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"f1bda99b-6d38-4e6b-be48-c52908d2dd4d"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We enlarge the coordinate system with an additional coordinate:\
\>", "Text",ExpressionUUID->"e81d6e2e-9aaa-4d1a-aed9-33bbc60b84be"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"x", "[", "]"}], ",", "S2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Coordinate", "[", 
    RowBox[{"1", ",", "cartesian"}], "]"}], ":=", "x"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e6b4c20f-7d39-47fb-94c9-e2aa970c57e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"x", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   x[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"f4bf1e9b-cdba-4ef5-8654-ef6afd5f0522"]
}, Open  ]],

Cell["Define the spherical system:", \
"Text",ExpressionUUID->"df3b1d15-7c31-4fac-8327-3d9a7bea0887"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"spherical", ",", "S2", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ec887215-63d4-49fa-882d-29f1acf9e53d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Theta]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   \[Theta][], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"f936e4ff-dd14-42fc-9317-b284ad15acee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Phi]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   \[Phi][], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"7a514874-2ab0-45e0-a4cc-a0d8375d0134"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "spherical", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefBasis, ": Defining ", "basis ", spherical, ". ", ""],
  
  Editable->
   False]], "Print",ExpressionUUID->"5f07171b-025e-4a44-91f6-853ea878a9af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDspherical", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefCovD, ": Defining ", "parallel derivative ", 
   PDspherical[-a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"2d731bb4-d22e-4bf8-8a9c-a8c865079390"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDspherical", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing torsion tensor ", 
   TorsionPDspherical[a, -b, -c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e43b3ba7-c7b7-46da-858e-6990861e7ccb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDspherical", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", DefTensor, ": Defining ", "symmetric Christoffel tensor ", 
   ChristoffelPDspherical[a, -b, -c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"b313421d-dfbe-446d-bad2-660f246ff7d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannPDspherical", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   RiemannPDspherical[-a, -b, -c, d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"60e9b8b6-8951-4211-b795-047df1c3a06e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciPDspherical", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   RicciPDspherical[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"c8bbacac-7b63-42f4-bf25-e40a7266b9dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"etaUpspherical", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "antisymmetric +1 density ", 
   etaUpspherical[a, b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"d2b053c1-691c-47d4-afbf-2e206653f813"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"etaDownspherical", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "antisymmetric -1 density ", 
   etaDownspherical[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"1d8da796-6ae4-40e2-b0be-4a8f63cf20dc"]
}, Open  ]]
}, Open  ]],

Cell["Again, We add a third coordinate to the spherical chart:", \
"Text",ExpressionUUID->"6c97f84a-a996-4a53-81ac-9b4fb3bff068"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"r", "[", "]"}], ",", "S2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Coordinate", "[", 
    RowBox[{"1", ",", "spherical"}], "]"}], ":=", "r"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d34a6130-0fae-4af3-b270-b17eeb344e5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"r", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   r[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"4215cf8b-f4d0-4dda-bddf-ab4d74633c54"]
}, Open  ]],

Cell["Now we give the metric in this coordinate system:", \
"Text",ExpressionUUID->"b4bf8ba2-46c3-4dac-904d-fb2dca9e5eaf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CVVerbose", "=", "False"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d001a27c-e6a1-4108-813b-4899fc759603"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metricvalues", "=", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"\[Theta]", "[", "]"}], "]"}], "^", "2"}]}], "}"}], 
   "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fa15720b-ac94-48c7-9d3e-99b0b57d0665"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"be55550f-af71-42f2-ac7d-73f354eaf32a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetricInBasis", "[", 
  RowBox[{"gamma", ",", 
   RowBox[{"-", "spherical"}], ",", "metricvalues"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"36bbe999-8e42-40d0-950d-53bf4de80d1f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", 
         StyleBox[
          RowBox[{"2", "2"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       gamma[{2, -spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", 
         StyleBox[
          RowBox[{"2", "3"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       gamma[{2, -spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", 
         StyleBox[
          RowBox[{"3", "2"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       gamma[{3, -spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", 
         StyleBox[
          RowBox[{"3", "3"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       gamma[{3, -spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], "2"]}]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"67399fed-ed26-4072-bc01-16f2e09fb48f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetricInBasis", "[", 
  RowBox[{"gamma", ",", "spherical", ",", 
   RowBox[{"Inverse", "[", "metricvalues", "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f5fd09bc-9672-45bd-a8ba-4ff4f45d796a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"2", "2"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       gamma[{2, spherical}, {2, spherical}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"2", "3"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       gamma[{2, spherical}, {3, spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"3", "2"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       gamma[{3, spherical}, {2, spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"3", "3"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       gamma[{3, spherical}, {3, spherical}],
       Editable->False], "\[Rule]", 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["Csc",
          AutoSpacing->False],
         Csc,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], "2"]}]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"4e5ef207-cfe2-42c1-aea0-bd45a88fc1c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TensorValues", "[", "gamma", 
  "]"}]], "Input",ExpressionUUID->"06b0fa39-7e30-4fc9-9226-ea69b0603ca9"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Gamma]", "  ", 
        StyleBox[
         RowBox[{"3", "2"}],
         FontColor->RGBColor[1, 0, 0]]],
       AutoSpacing->False],
      gamma[{3, spherical}, {2, spherical}],
      Editable->False], "\[Rule]", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Gamma]", "  ", 
        StyleBox[
         RowBox[{"2", "3"}],
         FontColor->RGBColor[1, 0, 0]]],
       AutoSpacing->False],
      gamma[{2, spherical}, {3, spherical}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"2", "2"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       gamma[{2, spherical}, {2, spherical}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"2", "3"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       gamma[{2, spherical}, {3, spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"3", "3"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       gamma[{3, spherical}, {3, spherical}],
       Editable->False], "\[Rule]", 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["Csc",
          AutoSpacing->False],
         Csc,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Gamma]", 
        StyleBox[
         RowBox[{"3", "2"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      gamma[{3, -spherical}, {2, -spherical}],
      Editable->False], "\[Rule]", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Gamma]", 
        StyleBox[
         RowBox[{"2", "3"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      gamma[{2, -spherical}, {3, -spherical}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", 
         StyleBox[
          RowBox[{"2", "2"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       gamma[{2, -spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", "1"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", 
         StyleBox[
          RowBox[{"2", "3"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       gamma[{2, -spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", 
         StyleBox[
          RowBox[{"3", "3"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       gamma[{3, -spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], "2"]}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"1d10c42e-852e-4372-b2ad-c4f938d8d223"]
}, Open  ]],

Cell["We enlarge the metric:", \
"Text",ExpressionUUID->"d598f960-7147-400f-a5b7-21c5fae30dce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentValue", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"gamma", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"gamma", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"gamma", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"gamma", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"gamma", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5e6f2400-51ee-4f63-b773-6c5124c0ee83"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Gamma]", 
       StyleBox[
        RowBox[{"1", "1"}],
        FontColor->RGBColor[1, 0, 0]], "  "],
      AutoSpacing->False],
     gamma[{1, -spherical}, {1, -spherical}],
     Editable->False], "\[Rule]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Gamma]", 
       StyleBox[
        RowBox[{"1", "2"}],
        FontColor->RGBColor[1, 0, 0]], "  "],
      AutoSpacing->False],
     gamma[{1, -spherical}, {2, -spherical}],
     Editable->False], "\[Rule]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Gamma]", 
       StyleBox[
        RowBox[{"1", "3"}],
        FontColor->RGBColor[1, 0, 0]], "  "],
      AutoSpacing->False],
     gamma[{1, -spherical}, {3, -spherical}],
     Editable->False], "\[Rule]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Gamma]", 
       StyleBox[
        RowBox[{"2", "1"}],
        FontColor->RGBColor[1, 0, 0]], "  "],
      AutoSpacing->False],
     gamma[{2, -spherical}, {1, -spherical}],
     Editable->False], "\[Rule]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Gamma]", 
       StyleBox[
        RowBox[{"3", "1"}],
        FontColor->RGBColor[1, 0, 0]], "  "],
      AutoSpacing->False],
     gamma[{3, -spherical}, {1, -spherical}],
     Editable->False], "\[Rule]", "0"}]}], 
  "}"}]], "Output",ExpressionUUID->"82a4d665-a1a5-4c74-80a5-01ac0a3dd8ac"]
}, Open  ]],

Cell["The determinant of the metric:", \
"Text",ExpressionUUID->"c3229f32-b15b-41f5-acc0-d4f5cdc538d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{"Det", "[", "metricvalues", "]"}], "]"}], "//", 
  "PowerExpand"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"75191a51-4b59-44e4-95e4-dd4466156540"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox["Sin",
    AutoSpacing->False],
   Sin,
   Editable->False], "[", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Theta]", "", ""],
    AutoSpacing->False],
   \[Theta][],
   Editable->False], 
  "]"}]], "Output",ExpressionUUID->"75c7d948-bb98-4563-aaf7-06db2550c731"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentValue", "[", 
  RowBox[{
   RowBox[{"Determinant", "[", 
    RowBox[{
     RowBox[{"gamma", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "spherical"}], "]"}], ",", "%"}], 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2780571f-5284-446d-adda-cda1a0cc5abc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detgammaspherical", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "weight +2 density ", 
   Detgammaspherical[], ". ", "Determinant."],
  Editable->
   False]], "Print",ExpressionUUID->"3c7c7d42-4c0d-469d-ab03-b4b23131d98f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     OverscriptBox["\[Gamma]", 
      OverscriptBox[
       StyleBox["~",
        FontColor->RGBColor[1, 0, 0]], 
       StyleBox["~",
        FontColor->RGBColor[1, 0, 0]]]], "", ""],
    AutoSpacing->False],
   Detgammaspherical[],
   Editable->False], "\[Rule]", 
  RowBox[{
   InterpretationBox[
    StyleBox["Sin",
     AutoSpacing->False],
    Sin,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], 
   "]"}]}]], "Output",ExpressionUUID->"c4b4436b-a565-4eb6-a282-039ddb555127"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Remove", "[", "metricvalues", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"aaea229e-91d9-4595-97d9-57931b81e25b"],

Cell["And the epsilon tensor:", \
"Text",ExpressionUUID->"35e4468c-090a-4a28-83f9-ec660d4832cc"],

Cell[CellGroupData[{

Cell[BoxData["$epsilonSign"], \
"Input",ExpressionUUID->"d4ed65ad-ac00-4af3-bb00-c2449ca647b7"],

Cell[BoxData["1"], \
"Output",ExpressionUUID->"66c61c37-0c3d-447d-a52e-a93ef762f842"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentArray", "[", 
  RowBox[{"epsilongamma", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "spherical"}], ",", 
     RowBox[{"-", "spherical"}]}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"6bc0288a-8417-4e11-a224-34e3a402d725"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", 
        StyleBox[
         RowBox[{"2", "2"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      epsilongamma[{2, -spherical}, {2, -spherical}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", 
        StyleBox[
         RowBox[{"2", "3"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      epsilongamma[{2, -spherical}, {3, -spherical}],
      Editable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", 
        StyleBox[
         RowBox[{"3", "2"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      epsilongamma[{3, -spherical}, {2, -spherical}],
      Editable->False], ",", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", 
        StyleBox[
         RowBox[{"3", "3"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      epsilongamma[{3, -spherical}, {3, -spherical}],
      Editable->False]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"ced1e895-736f-49a0-a74e-84094dde28fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"$epsilonSign", " ", 
   RowBox[{"Detgammaspherical", "[", "]"}], 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"f3469db3-9e56-4453-87a6-902bbca41404"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], ",", "0"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"60156cb6-44d9-4270-b727-0f3e5d1f1b22"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentValue", "[", 
  RowBox[{
   RowBox[{"ComponentArray", "[", 
    RowBox[{"epsilongamma", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "spherical"}], ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"$epsilonSign", " ", 
     RowBox[{"Detgammaspherical", "[", "]"}], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], "//", 
    "ToValues"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"23e79ebe-399d-4368-947e-dde2bad771b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         StyleBox[
          RowBox[{"2", "2"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       epsilongamma[{2, -spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         StyleBox[
          RowBox[{"2", "3"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       epsilongamma[{2, -spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         StyleBox[
          RowBox[{"3", "2"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       epsilongamma[{3, -spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         StyleBox[
          RowBox[{"3", "3"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       epsilongamma[{3, -spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"01b2fe04-6b5d-4bcc-9514-b91485a9ed1b"]
}, Open  ]],

Cell["\<\
Now we compute the values of epsilongamma in all other index configurations:\
\>", "Text",ExpressionUUID->"ae527058-80ff-4525-971a-81ecb794df9b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$BMUseValues", "=", "All"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$TUseValues", "=", "All"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CVSimplify", "=", "Simplify"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CCSimplify", "=", "Simplify"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7afc1193-7710-4a6d-bada-32e1a10850a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeComponents", "[", 
  RowBox[{
   RowBox[{"epsilongamma", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "spherical"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "spherical"}], "}"}]}], "]"}], ",", 
   RowBox[{"epsilongamma", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "spherical"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2ccef20f-b8ef-43e5-99bb-e49ed999ca84"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Epsilon]\[Gamma]", 
       RowBox[{
        StyleBox["a",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["b",
         FontColor->RGBColor[1, 0, 0]]}]],
      AutoSpacing->False],
     epsilongamma[{-a, -spherical}, {b, spherical}],
     Editable->False]}], "\[Rule]", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", 
        StyleBox[
         RowBox[{"a", "c"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      epsilongamma[{-a, -spherical}, {-c, -spherical}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Gamma]", "  ", 
        StyleBox[
         RowBox[{"b", "c"}],
         FontColor->RGBColor[1, 0, 0]]],
       AutoSpacing->False],
      gamma[{b, spherical}, {c, spherical}],
      Editable->False]}], "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]",
     "0.030253`4.932313440876003", "\[InvisibleSpace]", "\<\" Seconds\"\>"}]}],
  SequenceForm[
  "Computed ", epsilongamma[{-a, -spherical}, {b, spherical}] -> 
   epsilongamma[{-a, -spherical}, {-c, -spherical}] 
    gamma[{b, spherical}, {c, spherical}], " in ", 0.030253`4.932313440876003,
    " Seconds"],
  Editable->
   False]], "Print",ExpressionUUID->"4afb7bff-cdd5-4e82-8db8-352da279db83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
       StyleBox[
        RowBox[{"a", "b"}],
        FontColor->RGBColor[1, 0, 0]]],
      AutoSpacing->False],
     epsilongamma[{a, spherical}, {b, spherical}],
     Editable->False]}], "\[Rule]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Epsilon]\[Gamma]", 
       RowBox[{
        StyleBox["c",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["b",
         FontColor->RGBColor[1, 0, 0]]}]],
      AutoSpacing->False],
     epsilongamma[{-c, -spherical}, {b, spherical}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Gamma]", "  ", 
       StyleBox[
        RowBox[{"a", "c"}],
        FontColor->RGBColor[1, 0, 0]]],
      AutoSpacing->False],
     gamma[{a, spherical}, {c, spherical}],
     Editable->False], "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]",
     "0.013991`4.597393750086518", "\[InvisibleSpace]", "\<\" Seconds\"\>"}]}],
  SequenceForm[
  "Computed ", epsilongamma[{a, spherical}, {b, spherical}] -> 
   epsilongamma[{-c, -spherical}, {b, spherical}] 
    gamma[{a, spherical}, {c, spherical}], " in ", 0.013991`4.597393750086518,
    " Seconds"],
  Editable->
   False]], "Print",ExpressionUUID->"3c9944f4-794b-4780-b80f-8485470a18ed"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"2", "2"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       epsilongamma[{2, spherical}, {2, spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"3", "2"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       epsilongamma[{3, spherical}, {2, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
          StyleBox[
           RowBox[{"2", "3"}],
           FontColor->RGBColor[1, 0, 0]]],
         AutoSpacing->False],
        epsilongamma[{2, spherical}, {3, spherical}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"3", "3"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       epsilongamma[{3, spherical}, {3, spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
        StyleBox[
         RowBox[{"2", "3"}],
         FontColor->RGBColor[1, 0, 0]]],
       AutoSpacing->False],
      epsilongamma[{2, spherical}, {3, spherical}],
      Editable->False], "\[Rule]", 
     RowBox[{
      InterpretationBox[
       StyleBox["Csc",
        AutoSpacing->False],
       Csc,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       epsilongamma[{2, -spherical}, {2, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", 
          RowBox[{" ", 
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]], " "}]],
         AutoSpacing->False],
        epsilongamma[{2, spherical}, {2, -spherical}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       epsilongamma[{3, -spherical}, {2, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", 
          RowBox[{" ", 
           StyleBox["3",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]], " "}]],
         AutoSpacing->False],
        epsilongamma[{2, spherical}, {3, -spherical}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       epsilongamma[{3, -spherical}, {3, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", 
          RowBox[{" ", 
           StyleBox["3",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{
           StyleBox["3",
            FontColor->RGBColor[1, 0, 0]], " "}]],
         AutoSpacing->False],
        epsilongamma[{3, spherical}, {3, -spherical}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}]],
        AutoSpacing->False],
       epsilongamma[{3, spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", 
          RowBox[{
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]], " "}], 
          RowBox[{" ", 
           StyleBox["3",
            FontColor->RGBColor[1, 0, 0]]}]],
         AutoSpacing->False],
        epsilongamma[{2, -spherical}, {3, spherical}],
        Editable->False]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}]],
        AutoSpacing->False],
       epsilongamma[{2, spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}]],
        AutoSpacing->False],
       epsilongamma[{2, spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       epsilongamma[{2, -spherical}, {3, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       InterpretationBox[
        StyleBox["Csc",
         AutoSpacing->False],
        Csc,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}]],
        AutoSpacing->False],
       epsilongamma[{3, spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"ecce1063-03d9-4e97-99d9-1c0ac068f0d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TensorValues", "[", "epsilongamma", 
  "]"}]], "Input",ExpressionUUID->"6cc2e6eb-9fe5-446e-888c-d9e6a5ba1f9b"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"2", "2"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       epsilongamma[{2, spherical}, {2, spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"3", "2"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       epsilongamma[{3, spherical}, {2, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
          StyleBox[
           RowBox[{"2", "3"}],
           FontColor->RGBColor[1, 0, 0]]],
         AutoSpacing->False],
        epsilongamma[{2, spherical}, {3, spherical}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
         StyleBox[
          RowBox[{"3", "3"}],
          FontColor->RGBColor[1, 0, 0]]],
        AutoSpacing->False],
       epsilongamma[{3, spherical}, {3, spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", 
        StyleBox[
         RowBox[{"2", "3"}],
         FontColor->RGBColor[1, 0, 0]]],
       AutoSpacing->False],
      epsilongamma[{2, spherical}, {3, spherical}],
      Editable->False], "\[Rule]", 
     RowBox[{
      InterpretationBox[
       StyleBox["Csc",
        AutoSpacing->False],
       Csc,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       epsilongamma[{2, -spherical}, {2, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", 
          RowBox[{" ", 
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]], " "}]],
         AutoSpacing->False],
        epsilongamma[{2, spherical}, {2, -spherical}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       epsilongamma[{3, -spherical}, {2, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", 
          RowBox[{" ", 
           StyleBox["3",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]], " "}]],
         AutoSpacing->False],
        epsilongamma[{2, spherical}, {3, -spherical}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       epsilongamma[{3, -spherical}, {3, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", 
          RowBox[{" ", 
           StyleBox["3",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{
           StyleBox["3",
            FontColor->RGBColor[1, 0, 0]], " "}]],
         AutoSpacing->False],
        epsilongamma[{3, spherical}, {3, -spherical}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}]],
        AutoSpacing->False],
       epsilongamma[{3, spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", 
          RowBox[{
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]], " "}], 
          RowBox[{" ", 
           StyleBox["3",
            FontColor->RGBColor[1, 0, 0]]}]],
         AutoSpacing->False],
        epsilongamma[{2, -spherical}, {3, spherical}],
        Editable->False]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}]],
        AutoSpacing->False],
       epsilongamma[{2, spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}]],
        AutoSpacing->False],
       epsilongamma[{2, spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       epsilongamma[{2, -spherical}, {3, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       InterpretationBox[
        StyleBox["Csc",
         AutoSpacing->False],
        Csc,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}]],
        AutoSpacing->False],
       epsilongamma[{3, spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         StyleBox[
          RowBox[{"2", "2"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       epsilongamma[{2, -spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         StyleBox[
          RowBox[{"3", "2"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       epsilongamma[{3, -spherical}, {2, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Epsilon]\[Gamma]", 
          StyleBox[
           RowBox[{"2", "3"}],
           FontColor->RGBColor[1, 0, 0]], "  "],
         AutoSpacing->False],
        epsilongamma[{2, -spherical}, {3, -spherical}],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", 
         StyleBox[
          RowBox[{"3", "3"}],
          FontColor->RGBColor[1, 0, 0]], "  "],
        AutoSpacing->False],
       epsilongamma[{3, -spherical}, {3, -spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", 
        StyleBox[
         RowBox[{"2", "3"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      epsilongamma[{2, -spherical}, {3, -spherical}],
      Editable->False], "\[Rule]", 
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"1320d93e-16f2-40e8-908c-441d70131c8c"]
}, Open  ]],

Cell["Compute Christoffels:", \
"Text",ExpressionUUID->"a2283d6f-d1a9-4385-8c5e-a5da3d5d874c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AllComponentValues", "[", 
  RowBox[{
   RowBox[{"Christoffel", "[", 
    RowBox[{"cd", ",", "PDspherical"}], "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "spherical"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "spherical"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0876ebf7-465a-40d7-89e3-37a9d5389af8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelcdPDspherical", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   ChristoffelcdPDspherical[a, -b, -c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"1ce4ac95-3fd4-4202-9c6d-48d65cb24d59"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"2", "3", "2"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, -spherical}, {3, -spherical}, {
        2, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"2", "2", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"3", "3", "2"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, -spherical}, {3, -spherical}, {
        2, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"3", "2", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"2", "2", "2"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
        2, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"2", "2", "2"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
        2, -spherical}],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"2", "2", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"2", "2", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"2", "3", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, -spherical}, {3, -spherical}, {
        3, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"2", "3", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, -spherical}, {3, -spherical}, {
        3, -spherical}],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"3", "2", "2"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
        2, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"3", "2", "2"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
        2, -spherical}],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"3", "2", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"3", "2", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"3", "3", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, -spherical}, {3, -spherical}, {
        3, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         StyleBox[
          RowBox[{"3", "3", "3"}],
          FontColor->RGBColor[1, 0, 0]], "   "],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, -spherical}, {3, -spherical}, {
        3, -spherical}],
       Editable->False]}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"911f3b18-64e2-48c7-985d-7ae49b83dcd6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"gamma", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "spherical"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9c8c4ecb-8692-4856-889f-af115d55a64b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["\[Gamma]", 
    StyleBox[
     RowBox[{"a", "b"}],
     FontColor->RGBColor[1, 0, 0]], "  "],
   AutoSpacing->False],
  gamma[{-a, -spherical}, {-b, -spherical}],
  Editable->
   False]], "Output",ExpressionUUID->"cec10717-a33f-40af-ad89-791161e7a189"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"SeparateBasis", "[", "AIndex", "]"}], "[", "tmp", "]"}], "-", 
   "tmp"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"96fce20a-2073-4847-b502-5f6fdebfd515"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["a",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "c"}]],
     AutoSpacing->False],
    Basis[{-a, -spherical}, c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["b",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "d"}]],
     AutoSpacing->False],
    Basis[{-b, -spherical}, d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "cd", "  "],
     AutoSpacing->False],
    gamma[-c, -d],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Gamma]", 
     StyleBox[
      RowBox[{"a", "b"}],
      FontColor->RGBColor[1, 0, 0]], "  "],
    AutoSpacing->False],
   gamma[{-a, -spherical}, {-b, -spherical}],
   Editable->
    False]}]], "Output",ExpressionUUID->"6be88ddd-81ad-460b-af23-cf7d9a4f9dd0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{"cd", "[", 
    RowBox[{"-", "e"}], "]"}], "[", "tmp", "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"481d7acc-ca3e-4e69-8973-a31b6e701d96"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["b",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "d"}]],
     AutoSpacing->False],
    Basis[{-b, -spherical}, d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      RowBox[{"\[CapitalGamma]", "[", 
       RowBox[{"D", ",", 
        StyleBox["\[ScriptCapitalD]",
         FontColor->RGBColor[1, 0, 0]]}], "]"}], 
      RowBox[{" ", 
       RowBox[{"e", 
        StyleBox["a",
         FontColor->RGBColor[1, 0, 0]]}]}], 
      RowBox[{"c", "  "}]],
     AutoSpacing->False],
    ChristoffelcdPDspherical[c, -e, {-a, -spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "cd", "  "],
     AutoSpacing->False],
    gamma[-c, -d],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["a",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "c"}]],
     AutoSpacing->False],
    Basis[{-a, -spherical}, c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      RowBox[{"\[CapitalGamma]", "[", 
       RowBox[{"D", ",", 
        StyleBox["\[ScriptCapitalD]",
         FontColor->RGBColor[1, 0, 0]]}], "]"}], 
      RowBox[{" ", 
       RowBox[{"e", 
        StyleBox["b",
         FontColor->RGBColor[1, 0, 0]]}]}], 
      RowBox[{"d", "  "}]],
     AutoSpacing->False],
    ChristoffelcdPDspherical[d, -e, {-b, -spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "cd", "  "],
     AutoSpacing->False],
    gamma[-c, -d],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      StyleBox["a",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       StyleBox["b",
        FontColor->RGBColor[1, 0, 0]], ":", "e"}]}], "    "],
    AutoSpacing->False],
   cd[-e][
    gamma[{-a, -spherical}, {-b, -spherical}]],
   Editable->
    False]}]], "Output",ExpressionUUID->"f0c73c8d-b48e-4def-9f34-8d3a3e651117"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{"tmp", "//", "ContractMetric"}], "//", 
   "ContractBasis"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2dedd0a3-4024-4516-897c-2cf668689a32"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     RowBox[{"\[CapitalGamma]", "[", 
      RowBox[{"D", ",", 
       StyleBox["\[ScriptCapitalD]",
        FontColor->RGBColor[1, 0, 0]]}], "]"}], 
     RowBox[{
      StyleBox["a",
       FontColor->RGBColor[1, 0, 0]], "e", 
      StyleBox["b",
       FontColor->RGBColor[1, 0, 0]]}], "   "],
    AutoSpacing->False],
   ChristoffelcdPDspherical[{-a, -spherical}, -e, {-b, -spherical}],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     RowBox[{"\[CapitalGamma]", "[", 
      RowBox[{"D", ",", 
       StyleBox["\[ScriptCapitalD]",
        FontColor->RGBColor[1, 0, 0]]}], "]"}], 
     RowBox[{
      StyleBox["b",
       FontColor->RGBColor[1, 0, 0]], "e", 
      StyleBox["a",
       FontColor->RGBColor[1, 0, 0]]}], "   "],
    AutoSpacing->False],
   ChristoffelcdPDspherical[{-b, -spherical}, -e, {-a, -spherical}],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      StyleBox["a",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       StyleBox["b",
        FontColor->RGBColor[1, 0, 0]], ":", "e"}]}], "    "],
    AutoSpacing->False],
   cd[-e][
    gamma[{-a, -spherical}, {-b, -spherical}]],
   Editable->
    False]}]], "Output",ExpressionUUID->"0e5f00b2-2213-4fe8-bb87-12119b011b95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"tmp", "//", 
   RowBox[{"ToBasis", "[", "spherical", "]"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"14af6bda-7d0d-4327-865b-cd26068d45a7"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     RowBox[{"\[CapitalGamma]", "[", 
      RowBox[{"D", ",", 
       StyleBox["\[ScriptCapitalD]",
        FontColor->RGBColor[1, 0, 0]]}], "]"}], 
     StyleBox[
      RowBox[{"a", "e", "b"}],
      FontColor->RGBColor[1, 0, 0]], "   "],
    AutoSpacing->False],
   ChristoffelcdPDspherical[{-a, -spherical}, {-e, -spherical}, {-b, -
     spherical}],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     RowBox[{"\[CapitalGamma]", "[", 
      RowBox[{"D", ",", 
       StyleBox["\[ScriptCapitalD]",
        FontColor->RGBColor[1, 0, 0]]}], "]"}], 
     StyleBox[
      RowBox[{"b", "e", "a"}],
      FontColor->RGBColor[1, 0, 0]], "   "],
    AutoSpacing->False],
   ChristoffelcdPDspherical[{-b, -spherical}, {-e, -spherical}, {-a, -
     spherical}],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{
      StyleBox["a",
       FontColor->RGBColor[1, 0, 0]], 
      RowBox[{
       StyleBox["b",
        FontColor->RGBColor[1, 0, 0]], ":", 
       StyleBox["e",
        FontColor->RGBColor[1, 0, 0]]}]}], "    "],
    AutoSpacing->False],
   cd[{-e, -spherical}][
    gamma[{-a, -spherical}, {-b, -spherical}]],
   Editable->
    False]}]], "Output",ExpressionUUID->"a5f57ead-30b5-45a3-8ac7-da696d71908f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ComponentArray", "[", "tmp", "]"}], "//", "ToValues"}], "//", 
   "Flatten"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"69134992-ba62-4a73-85d5-d906082a15fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"2", "2", "2"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
      2, -spherical}],
     Editable->False]}], ",", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"2", "2", "3"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
      3, -spherical}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"2", "2", "3"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
      3, -spherical}],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"3", "2", "2"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
      2, -spherical}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"2", "3", "3"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{2, -spherical}, {3, -spherical}, {
      3, -spherical}],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"3", "2", "3"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
      3, -spherical}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"2", "2", "3"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
      3, -spherical}],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"3", "2", "2"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
      2, -spherical}],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"2", "3", "3"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{2, -spherical}, {3, -spherical}, {
      3, -spherical}],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"3", "2", "3"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
      3, -spherical}],
     Editable->False]}], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"3", "2", "3"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
       3, -spherical}],
      Editable->False]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}]}], ",", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       StyleBox[
        RowBox[{"3", "3", "3"}],
        FontColor->RGBColor[1, 0, 0]], "   "],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{3, -spherical}, {3, -spherical}, {
      3, -spherical}],
     Editable->False]}]}], 
  "}"}]], "Output",ExpressionUUID->"38582d23-bf1f-4fb4-853a-7181e520bc99"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "\[Equal]", "0"}], "&"}], ",", "tmp"}], "]"}], ",", 
    RowBox[{"First", "/@", 
     RowBox[{"Last", "[", 
      RowBox[{"TensorValues", "[", "ChristoffelcdPDspherical", "]"}], 
      "]"}]}]}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"068b6eec-ee86-48d3-a385-c5bc2fa9455d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"2", "2", "2"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
       2, -spherical}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"2", "2", "3"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
       3, -spherical}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"2", "3", "3"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{2, -spherical}, {3, -spherical}, {
       3, -spherical}],
      Editable->False], "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}]}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"3", "2", "2"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
       2, -spherical}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"3", "2", "3"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
       3, -spherical}],
      Editable->False], "\[Rule]", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}]}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"3", "3", "3"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{3, -spherical}, {3, -spherical}, {
       3, -spherical}],
      Editable->False], "\[Rule]", "0"}]}], "}"}], 
  "}"}]], "Output",ExpressionUUID->"89990e78-a649-4fc7-b6a2-53df848328e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "/.", 
  RowBox[{"Rule", "\[Rule]", "ComponentValue"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ee3dc485-5de5-4c49-a734-7bac8e1b1394"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"2", "2", "2"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
       2, -spherical}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"2", "2", "3"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{2, -spherical}, {2, -spherical}, {
       3, -spherical}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"2", "3", "3"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{2, -spherical}, {3, -spherical}, {
       3, -spherical}],
      Editable->False], "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}]}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"3", "2", "2"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
       2, -spherical}],
      Editable->False], "\[Rule]", "0"}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"3", "2", "3"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{3, -spherical}, {2, -spherical}, {
       3, -spherical}],
      Editable->False], "\[Rule]", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}]}], ",", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"3", "3", "3"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{3, -spherical}, {3, -spherical}, {
       3, -spherical}],
      Editable->False], "\[Rule]", "0"}]}], "}"}], 
  "}"}]], "Output",ExpressionUUID->"6ff3ffda-a4b2-4034-86f4-e019d4602559"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeComponents", "[", 
  RowBox[{
   RowBox[{"ChristoffelcdPDspherical", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "spherical"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "spherical"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"ChristoffelcdPDspherical", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "spherical"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "spherical"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bab085ab-3f83-41da-8eda-a0861c8b7fe9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       RowBox[{" ", 
        StyleBox[
         RowBox[{"b", "c"}],
         FontColor->RGBColor[1, 0, 0]]}], 
       RowBox[{
        StyleBox["a",
         FontColor->RGBColor[1, 0, 0]], "  "}]],
      AutoSpacing->False],
     ChristoffelcdPDspherical[{
      a, spherical}, {-b, -spherical}, {-c, -spherical}],
     Editable->False]}], "\[Rule]", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        StyleBox[
         RowBox[{"d", "b", "c"}],
         FontColor->RGBColor[1, 0, 0]], "   "],
       AutoSpacing->False],
      ChristoffelcdPDspherical[{-d, -spherical}, {-b, -spherical}, {-c, -
        spherical}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Gamma]", "  ", 
        StyleBox[
         RowBox[{"a", "d"}],
         FontColor->RGBColor[1, 0, 0]]],
       AutoSpacing->False],
      gamma[{a, spherical}, {d, spherical}],
      Editable->False]}], "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]",
     "0.049843`5.149149167681504", "\[InvisibleSpace]", "\<\" Seconds\"\>"}]}],
  SequenceForm[
  "Computed ", 
   ChristoffelcdPDspherical[{
     a, spherical}, {-b, -spherical}, {-c, -spherical}] -> 
   ChristoffelcdPDspherical[{-d, -spherical}, {-b, -spherical}, {-c, -
       spherical}] gamma[{a, spherical}, {d, spherical}], " in ", 
   0.049843`5.149149167681504, " Seconds"],
  Editable->
   False]], "Print",ExpressionUUID->"7eacba4e-f97d-496d-b3e2-8249e251df04"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"3", "2"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
        2, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"2", "3"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"3", "2"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
        2, -spherical}],
       Editable->False], "\[Rule]", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"2", "3"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"2", "2"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
        2, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"2", "3"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"3", "3"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
        3, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}]}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"2", "2"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
        2, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"2", "3"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
        3, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cot",
         AutoSpacing->False],
        Cot,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         RowBox[{"\[CapitalGamma]", "[", 
          RowBox[{"D", ",", 
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1, 0, 0]]}], "]"}], 
         RowBox[{" ", 
          StyleBox[
           RowBox[{"3", "3"}],
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], "  "}]],
        AutoSpacing->False],
       ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
        3, -spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"d8461b1a-09fd-4ea9-8bcd-29457105e042"]
}, Open  ]],

Cell["\<\
Note that the spherical basis is not normalized (because it is a coordinate \
chart):\
\>", "Text",ExpressionUUID->"2f24ff95-301d-4d7e-ad00-afbcbebea932"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"gamma", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{"b", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "spherical"}]}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"91e44a9b-d869-4512-a38a-085d19edd0a5"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["3",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "a"}]],
    AutoSpacing->False],
   Basis[{3, -spherical}, a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["3",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "b"}]],
    AutoSpacing->False],
   Basis[{3, -spherical}, b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Gamma]", "ab", "  "],
    AutoSpacing->False],
   gamma[-a, -b],
   Editable->
    False]}]], "Output",ExpressionUUID->"8ebef7d9-d208-4ec6-9032-19104328fb6d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "ContractBasis"}], "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"b80b6ce0-99b3-4370-8f4f-308969a9383e"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{
   InterpretationBox[
    StyleBox["Sin",
     AutoSpacing->False],
    Sin,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], "]"}], 
  "2"]], "Output",ExpressionUUID->"32c7b363-ddb4-4e20-80b4-942554060cc4"]
}, Open  ]],

Cell["\<\
Transformation between spherical and Cartesian charts. Instead of defining a \
new chart, we define the Cartesian chart as the DefaultChart. Note the trick \
of using 3 coordinate values rather than 2:\
\>", "Text",ExpressionUUID->"d4f91b0b-4e58-46b1-b667-5aeec572718a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"change", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"r", "[", "]"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}], 
       RowBox[{"Cos", "[", 
        RowBox[{"\[Phi]", "[", "]"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"r", "[", "]"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Phi]", "[", "]"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"z", "[", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"r", "[", "]"}], 
       RowBox[{"Cos", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}]}]}]}], "}"}]}], ";"}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"eaf46803-d5fe-4796-acd3-7768741f70a7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"spherical", "/:", 
   RowBox[{"CNumbersOf", "[", 
    RowBox[{"spherical", ",", "TangentS2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cartesian", "/:", 
   RowBox[{"CNumbersOf", "[", 
    RowBox[{"cartesian", ",", "TangentS2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"6d6c3924-2fd3-4749-8396-3339264ab8ff"],

Cell["Compute relevant matrices for the change of basis:", \
"Text",ExpressionUUID->"81ff5c57-99b3-4320-b55a-92ec817397a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"changeL", "=", 
   RowBox[{"ComponentArray", "[", 
    RowBox[{"Basis", ",", 
     RowBox[{"{", 
      RowBox[{"cartesian", ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8fc85cad-1f14-45ec-b530-223a567016aa"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{1, -spherical}, {1, cartesian}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{2, -spherical}, {1, cartesian}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{3, -spherical}, {1, cartesian}],
       Editable->False]},
     {
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{1, -spherical}, {2, cartesian}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{2, -spherical}, {2, cartesian}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{3, -spherical}, {2, cartesian}],
       Editable->False]},
     {
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{1, -spherical}, {3, cartesian}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{2, -spherical}, {3, cartesian}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{3, -spherical}, {3, cartesian}],
       Editable->False]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"b3ce6170-f913-499a-bc91-477f9e7f2e8b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"changeLinv", "=", 
   RowBox[{"ComponentArray", "[", 
    RowBox[{"Basis", ",", 
     RowBox[{"{", 
      RowBox[{"spherical", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"64426043-cbaa-4b65-a380-9f6e9c7e22d6"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{1, -cartesian}, {1, spherical}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{2, -cartesian}, {1, spherical}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{3, -cartesian}, {1, spherical}],
       Editable->False]},
     {
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{1, -cartesian}, {2, spherical}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{2, -cartesian}, {2, spherical}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{3, -cartesian}, {2, spherical}],
       Editable->False]},
     {
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{1, -cartesian}, {3, spherical}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{2, -cartesian}, {3, spherical}],
       Editable->False], 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{3, -cartesian}, {3, spherical}],
       Editable->False]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"ad566bf3-e2f0-4b05-a767-a66da816fd0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sphericalcoordinates", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Coordinate", "[", 
      RowBox[{"i", ",", "spherical"}], "]"}], "[", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"cartesiancoordinates", "=", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Coordinate", "[", 
       RowBox[{"i", ",", "cartesian"}], "]"}], "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}]}], "]"}], "/.", "change"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b19c7e0f-a051-45ae-a4fa-0ff656aaa61f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["r", "", ""],
     AutoSpacing->False],
    r[],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Phi]", "", ""],
     AutoSpacing->False],
    \[Phi][],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"53629d97-9a21-4b79-a202-8d930d0f985e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False], "]"}], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["r", "", ""],
      AutoSpacing->False],
     r[],
     Editable->False], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["r", "", ""],
      AutoSpacing->False],
     r[],
     Editable->False], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["r", "", ""],
      AutoSpacing->False],
     r[],
     Editable->False]}]}], 
  "}"}]], "Output",ExpressionUUID->"a6307ac7-1b6f-4c79-9fb5-f6f50549cd7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"MatrixForm", "[", 
  RowBox[{"changeR", "=", 
   RowBox[{"Outer", "[", 
    RowBox[{"D", ",", "cartesiancoordinates", ",", "sphericalcoordinates"}], 
    "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"changeRinv", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Inverse", "[", "changeR", "]"}], "]"}]}], "]"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"ae3148c0-07f6-446f-8718-81b80ced7f59"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False]}], 
      RowBox[{
       RowBox[{"-", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["r", "", ""],
          AutoSpacing->False],
         r[],
         Editable->False]}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]},
     {
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}], 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}], 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}]},
     {
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], 
      RowBox[{
       RowBox[{"-", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["r", "", ""],
          AutoSpacing->False],
         r[],
         Editable->False]}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"ce60eb56-dffe-4905-ab25-b711d311d495"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}], 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]},
     {
      FractionBox[
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}]}], 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False]], 
      FractionBox[
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}]}], 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False]], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["r", "", ""],
          AutoSpacing->False],
         r[],
         Editable->False]]}]},
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox["Csc",
            AutoSpacing->False],
           Csc,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "]"}], " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}], 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["r", "", ""],
          AutoSpacing->False],
         r[],
         Editable->False]]}], 
      FractionBox[
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Csc",
           AutoSpacing->False],
          Csc,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}]}], 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False]], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"ba0776cc-90fd-4723-917a-5bf6af6ec8c9"]
}, Open  ]],

Cell["Equate them:", \
"Text",ExpressionUUID->"ac3737b8-0d1e-4554-9ac4-a2d22d8e8383"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentValue", "[", 
  RowBox[{"changeL", ",", "changeR"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"32803541-cae4-4e80-b3ed-8175f0b30ebe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{1, -spherical}, {1, cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{2, -spherical}, {1, cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{3, -spherical}, {1, cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["r", "", ""],
          AutoSpacing->False],
         r[],
         Editable->False]}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{1, -spherical}, {2, cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{2, -spherical}, {2, cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{3, -spherical}, {2, cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{1, -spherical}, {3, cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{2, -spherical}, {3, cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["r", "", ""],
          AutoSpacing->False],
         r[],
         Editable->False]}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]]}]],
        AutoSpacing->False],
       Basis[{3, -spherical}, {3, cartesian}],
       Editable->False], "\[Rule]", "0"}]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"c5b0f17b-f172-4e6c-8478-466e82d3ae75"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentValue", "[", 
  RowBox[{"changeLinv", ",", "changeRinv"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e37decb3-4970-43f1-a360-5045a4b7cd30"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{1, -cartesian}, {1, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{2, -cartesian}, {1, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["1",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{3, -cartesian}, {1, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{1, -cartesian}, {2, spherical}],
       Editable->False], "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}]}], 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False]]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{2, -cartesian}, {2, spherical}],
       Editable->False], "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}]}], 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False]]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{3, -cartesian}, {2, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["r", "", ""],
          AutoSpacing->False],
         r[],
         Editable->False]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["1",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{1, -cartesian}, {3, spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox["Csc",
            AutoSpacing->False],
           Csc,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "]"}], " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}], 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["r", "", ""],
          AutoSpacing->False],
         r[],
         Editable->False]]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{2, -cartesian}, {3, spherical}],
       Editable->False], "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Csc",
           AutoSpacing->False],
          Csc,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}]}], 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["r", "", ""],
         AutoSpacing->False],
        r[],
        Editable->False]]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[0, 0, 1]], " "}], 
         RowBox[{" ", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]],
        AutoSpacing->False],
       Basis[{3, -cartesian}, {3, spherical}],
       Editable->False], "\[Rule]", "0"}]}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"30e8d5d5-8583-413f-a270-096bef702ca7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", "]"}], ":=", "1"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b94df5ce-4f04-43ad-bbf2-b751b8cb4d60"],

Cell["Identity in the spherical basis:", \
"Text",ExpressionUUID->"3a64d2df-58a2-434d-b10c-e2b0fcc20293"],

Cell[BoxData[{
 RowBox[{"SetAttributes", "[", 
  RowBox[{"identity", ",", "Orderless"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"identity", "[", 
   RowBox[{"a_Symbol", ",", 
    RowBox[{"-", "b_Symbol"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "spherical"}], "}"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "spherical"}], "}"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "spherical"}], "}"}]}], "]"}]}]}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fc52215e-c889-44ea-85ae-4c3de8893fae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"identity", "[", 
  RowBox[{
   RowBox[{"-", "b"}], ",", "a"}], 
  "]"}]], "Input",ExpressionUUID->"fb2dd9f0-8e00-499b-afba-a642e6b6b977"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["1",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {1, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["1",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{1, -spherical}, a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, a],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"292b9355-91ff-4a04-9c0c-381736e5d272"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. Complex basis vectors", \
"Subsubsection",ExpressionUUID->"f8290d5f-f1c3-4906-bb04-b69ad6743725"],

Cell["Then we have the complex basis vectors", \
"Text",ExpressionUUID->"fa8db8c4-65e9-4d98-9166-230ac1273c26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"m", "[", "a", "]"}], ",", "S2"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b0bc4e28-6f4e-4994-b40a-ac676dbb9e19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"m", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   m[a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"ca55523b-4606-4483-a55e-309a435af71e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"mbar", "[", "a", "]"}], ",", "S2", ",", 
   RowBox[{"PrintAs", "->", "\"\<\!\(\*OverscriptBox[\(m\), \(_\)]\)\>\""}]}],
   "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3b0d59af-8e61-48aa-8b94-aeb985821693"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"mbar", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   mbar[a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"120f4f58-0639-49ac-8886-c0f06cc5e230"]
}, Open  ]],

Cell["Orthogonality properties:", \
"Text",ExpressionUUID->"13ac671b-e80f-405a-bbb9-123f751a38ad"],

Cell[BoxData[{
 RowBox[{"m", "/:", 
  RowBox[{
   RowBox[{"m", "[", "a_", "]"}], 
   RowBox[{"m", "[", 
    RowBox[{"-", "a_"}], "]"}]}], ":=", "0"}], "\[IndentingNewLine]", 
 RowBox[{"mbar", "/:", 
  RowBox[{
   RowBox[{"mbar", "[", "a_", "]"}], 
   RowBox[{"mbar", "[", 
    RowBox[{"-", "a_"}], "]"}]}], ":=", "0"}], "\[IndentingNewLine]", 
 RowBox[{"mbar", "/:", 
  RowBox[{
   RowBox[{"m", "[", "a_", "]"}], 
   RowBox[{"mbar", "[", 
    RowBox[{"-", "a_"}], "]"}]}], ":=", "1"}], "\[IndentingNewLine]", 
 RowBox[{"m", "/:", 
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"-", "a_"}], "]"}], 
   RowBox[{"mbar", "[", "a_", "]"}]}], ":=", "1"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"58643ad0-73c1-43e9-a6e3-53407b0d72d0"],

Cell["Components in the coordinated spherical basis:", \
"Text",ExpressionUUID->"c07ec199-5a3e-41e9-9c20-c96d6c384931"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentValue", "[", 
  RowBox[{
   RowBox[{"ComponentArray", "[", 
    RowBox[{"m", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "spherical"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     FractionBox[
      RowBox[{"I", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}]}], 
      SqrtBox["2"]]}], "}"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9289a650-3100-45e2-bf66-1ac857ef392f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", 
       StyleBox["1",
        FontColor->RGBColor[1, 0, 0]]],
      AutoSpacing->False],
     m[{1, spherical}],
     Editable->False], "\[Rule]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]],
      AutoSpacing->False],
     m[{2, spherical}],
     Editable->False], "\[Rule]", 
    FractionBox["1", 
     SqrtBox["2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]],
      AutoSpacing->False],
     m[{3, spherical}],
     Editable->False], "\[Rule]", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Csc",
         AutoSpacing->False],
        Csc,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], 
     SqrtBox["2"]]}]}], 
  "}"}]], "Output",ExpressionUUID->"eb5817ca-42b7-4ab5-b195-1c10adf4b7c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeComponents", "[", 
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "spherical"}]}], "}"}], "]"}], ",", 
   RowBox[{"m", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "spherical"}], "}"}], "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9f23d6a4-9eef-49d8-a3b2-842d57913705"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", 
       StyleBox["a",
        FontColor->RGBColor[1, 0, 0]], " "],
      AutoSpacing->False],
     m[{-a, -spherical}],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Gamma]", 
        StyleBox[
         RowBox[{"b", "a"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      gamma[{-b, -spherical}, {-a, -spherical}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["m", " ", 
        StyleBox["b",
         FontColor->RGBColor[1, 0, 0]]],
       AutoSpacing->False],
      m[{b, spherical}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]",
    "0.020898`4.771649718337857", "\[InvisibleSpace]", "\<\" Seconds\"\>"}],
  SequenceForm[
  "Computed ", m[{-a, -spherical}] -> 
   gamma[{-b, -spherical}, {-a, -spherical}] m[{b, spherical}], " in ", 
   0.020898`4.771649718337857, " Seconds"],
  Editable->
   False]], "Print",ExpressionUUID->"769480b2-2c3b-46b5-b6cc-6f5e5991dce3"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", 
         StyleBox["1",
          FontColor->RGBColor[1, 0, 0]], " "],
        AutoSpacing->False],
       m[{1, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "],
        AutoSpacing->False],
       m[{2, -spherical}],
       Editable->False], "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", 
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "],
        AutoSpacing->False],
       m[{3, -spherical}],
       Editable->False], "\[Rule]", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}]}], 
       SqrtBox["2"]]}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"22985c07-c8d2-4330-8d4e-9080faa51110"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComponentValue", "[", 
  RowBox[{
   RowBox[{"ComponentArray", "[", 
    RowBox[{"mbar", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "spherical"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"I", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}]}], 
       SqrtBox["2"]]}]}], "}"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"608c9925-5768-4758-ae09-dc7d3145fe3e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", 
       StyleBox["1",
        FontColor->RGBColor[1, 0, 0]]],
      AutoSpacing->False],
     mbar[{1, spherical}],
     Editable->False], "\[Rule]", "0"}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]],
      AutoSpacing->False],
     mbar[{2, spherical}],
     Editable->False], "\[Rule]", 
    FractionBox["1", 
     SqrtBox["2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]],
      AutoSpacing->False],
     mbar[{3, spherical}],
     Editable->False], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Csc",
          AutoSpacing->False],
         Csc,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], 
      SqrtBox["2"]]}]}]}], 
  "}"}]], "Output",ExpressionUUID->"cdeb6637-d0cf-41c3-8922-5e07f73c10f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeComponents", "[", 
  RowBox[{
   RowBox[{"mbar", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "spherical"}]}], "}"}], "]"}], ",", 
   RowBox[{"mbar", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "spherical"}], "}"}], "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c586c906-2bd3-44ff-85ae-f6cf626ce3f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], 
       StyleBox["a",
        FontColor->RGBColor[1, 0, 0]], " "],
      AutoSpacing->False],
     mbar[{-a, -spherical}],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Gamma]", 
        StyleBox[
         RowBox[{"b", "a"}],
         FontColor->RGBColor[1, 0, 0]], "  "],
       AutoSpacing->False],
      gamma[{-b, -spherical}, {-a, -spherical}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        OverscriptBox["m", "_"], " ", 
        StyleBox["b",
         FontColor->RGBColor[1, 0, 0]]],
       AutoSpacing->False],
      mbar[{b, spherical}],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]",
    "0.020322`4.759511440524248", "\[InvisibleSpace]", "\<\" Seconds\"\>"}],
  SequenceForm[
  "Computed ", mbar[{-a, -spherical}] -> 
   gamma[{-b, -spherical}, {-a, -spherical}] mbar[{b, spherical}], " in ", 
   0.020322`4.759511440524248, " Seconds"],
  Editable->
   False]], "Print",ExpressionUUID->"bc7a4957-aaa3-47ac-befd-104869a61c1f"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], 
         StyleBox["1",
          FontColor->RGBColor[1, 0, 0]], " "],
        AutoSpacing->False],
       mbar[{1, -spherical}],
       Editable->False], "\[Rule]", "0"}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "],
        AutoSpacing->False],
       mbar[{2, -spherical}],
       Editable->False], "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], 
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "],
        AutoSpacing->False],
       mbar[{3, -spherical}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "]"}]}], 
        SqrtBox["2"]]}]}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"5f9289c2-f732-42c3-b5bd-e2a08e89fd35"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"m", "/:", 
  RowBox[{
   RowBox[{"m", "[", "a_", "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a_"}], ",", 
     RowBox[{"{", 
      RowBox[{"b_", ",", "spherical"}], "}"}]}], "]"}]}], ":=", 
  RowBox[{"m", "[", 
   RowBox[{"{", 
    RowBox[{"b", ",", "spherical"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"m", "/:", 
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"-", "a_"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{"a_", ",", 
     RowBox[{"{", 
      RowBox[{"b_", ",", "spherical"}], "}"}]}], "]"}]}], ":=", 
  RowBox[{"m", "[", 
   RowBox[{"{", 
    RowBox[{"b", ",", "spherical"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"mbar", "/:", 
  RowBox[{
   RowBox[{"mbar", "[", "a_", "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{
     RowBox[{"-", "a_"}], ",", 
     RowBox[{"{", 
      RowBox[{"b_", ",", "spherical"}], "}"}]}], "]"}]}], ":=", 
  RowBox[{"mbar", "[", 
   RowBox[{"{", 
    RowBox[{"b", ",", "spherical"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"mbar", "/:", 
  RowBox[{
   RowBox[{"mbar", "[", 
    RowBox[{"-", "a_"}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{"a_", ",", 
     RowBox[{"{", 
      RowBox[{"b_", ",", "spherical"}], "}"}]}], "]"}]}], ":=", 
  RowBox[{"mbar", "[", 
   RowBox[{"{", 
    RowBox[{"b", ",", "spherical"}], "}"}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7818ade2-cbe4-4adb-9915-1970503f226d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeComponents", "[", 
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "cartesian"}], "}"}], "]"}], ",", 
   RowBox[{"m", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "spherical"}], "}"}], "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1b41c67d-cd08-4fdd-9b36-b0c969d6ae91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", 
       StyleBox["a",
        FontColor->RGBColor[0, 0, 1]]],
      AutoSpacing->False],
     m[{a, cartesian}],
     Editable->False]}], "\[Rule]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["b",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["a",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{-b, -spherical}, {a, cartesian}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", 
       StyleBox["b",
        FontColor->RGBColor[1, 0, 0]]],
      AutoSpacing->False],
     m[{b, spherical}],
     Editable->False], "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]",
     "0.05807`5.2154968195293", "\[InvisibleSpace]", "\<\" Seconds\"\>"}]}],
  SequenceForm[
  "Computed ", m[{a, cartesian}] -> 
   Basis[{-b, -spherical}, {a, cartesian}] m[{b, spherical}], " in ", 
   0.05807`5.2154968195293, " Seconds"],
  Editable->
   False]], "Print",ExpressionUUID->"77b450db-c8bb-4f92-bd48-6afa0b20837a"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", " ", 
         StyleBox["1",
          FontColor->RGBColor[0, 0, 1]]],
        AutoSpacing->False],
       m[{1, cartesian}],
       Editable->False], "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "]"}], " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}]}], 
       SqrtBox["2"]]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", " ", 
         StyleBox["2",
          FontColor->RGBColor[0, 0, 1]]],
        AutoSpacing->False],
       m[{2, cartesian}],
       Editable->False], "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}], "+", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "]"}], " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}]}], 
       SqrtBox["2"]]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", " ", 
         StyleBox["3",
          FontColor->RGBColor[0, 0, 1]]],
        AutoSpacing->False],
       m[{3, cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], 
        SqrtBox["2"]]}]}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"41463ac0-7248-4685-80e9-a95cfd8070f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeComponents", "[", 
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], "]"}], ",", 
   RowBox[{"m", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "spherical"}]}], "}"}], "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6ae21fce-a7e6-4422-b24c-ce1ef4517b81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"Computed \"\>", "\[InvisibleSpace]", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", 
       StyleBox["a",
        FontColor->RGBColor[0, 0, 1]], " "],
      AutoSpacing->False],
     m[{-a, -cartesian}],
     Editable->False]}], "\[Rule]", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["a",
         FontColor->RGBColor[0, 0, 1]], " "}], 
       RowBox[{" ", 
        StyleBox["b",
         FontColor->RGBColor[1, 0, 0]]}]],
      AutoSpacing->False],
     Basis[{-a, -cartesian}, {b, spherical}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", 
       StyleBox["b",
        FontColor->RGBColor[1, 0, 0]], " "],
      AutoSpacing->False],
     m[{-b, -spherical}],
     Editable->False], "\[InvisibleSpace]", "\<\" in \"\>", "\[InvisibleSpace]",
     "0.018598`4.721011236871663", "\[InvisibleSpace]", "\<\" Seconds\"\>"}]}],
  SequenceForm[
  "Computed ", m[{-a, -cartesian}] -> 
   Basis[{-a, -cartesian}, {b, spherical}] m[{-b, -spherical}], " in ", 
   0.018598`4.721011236871663, " Seconds"],
  Editable->
   False]], "Print",ExpressionUUID->"f864f7c4-a798-4ebf-8e5d-58c9bce4fe1f"],

Cell[BoxData[
 RowBox[{"FoldedRule", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", 
         StyleBox["1",
          FontColor->RGBColor[0, 0, 1]], " "],
        AutoSpacing->False],
       m[{1, -cartesian}],
       Editable->False], "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "]"}], " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}]}], 
       SqrtBox["2"]]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", 
         StyleBox["2",
          FontColor->RGBColor[0, 0, 1]], " "],
        AutoSpacing->False],
       m[{2, -cartesian}],
       Editable->False], "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}], "+", 
        RowBox[{
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "]"}], " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Sin",
            AutoSpacing->False],
           Sin,
           Editable->False], "[", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False], "]"}]}]}], 
       SqrtBox["2"]]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", 
         StyleBox["3",
          FontColor->RGBColor[0, 0, 1]], " "],
        AutoSpacing->False],
       m[{3, -cartesian}],
       Editable->False], "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], 
        SqrtBox["2"]]}]}]}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"a03b9ff8-89d7-4345-a6e9-0466ddc19512"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cd", "[", 
    RowBox[{"-", "a"}], "]"}], "[", 
   RowBox[{"TraceBasisDummy", "[", 
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"{", 
       RowBox[{"c", ",", "spherical"}], "}"}], "]"}], 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", "b"}], "]"}]}], "]"}], 
   "]"}], "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"b07a513f-5e07-492f-b442-be7a5f20a0de"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      RowBox[{"\[CapitalGamma]", "[", 
       RowBox[{"D", ",", 
        StyleBox["\[ScriptCapitalD]",
         FontColor->RGBColor[1, 0, 0]]}], "]"}], 
      RowBox[{" ", 
       RowBox[{"a", 
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]]}]}], 
      RowBox[{"b", "  "}]],
     AutoSpacing->False],
    ChristoffelcdPDspherical[b, -a, {2, -spherical}],
    Editable->False], 
   SqrtBox["2"]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       RowBox[{"\[CapitalGamma]", "[", 
        RowBox[{"D", ",", 
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1, 0, 0]]}], "]"}], 
       RowBox[{" ", 
        RowBox[{"a", 
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]]}]}], 
       RowBox[{"b", "  "}]],
      AutoSpacing->False],
     ChristoffelcdPDspherical[b, -a, {3, -spherical}],
     Editable->False], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Csc",
       AutoSpacing->False],
      Csc,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], 
   SqrtBox["2"]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{"a", " "}], 
       RowBox[{" ", 
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]]}]],
      AutoSpacing->False],
     Basis[-a, {2, spherical}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["3",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", "b"}]],
      AutoSpacing->False],
     Basis[{3, -spherical}, b],
     Editable->False], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Cot",
       AutoSpacing->False],
      Cot,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Csc",
       AutoSpacing->False],
      Csc,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], 
   SqrtBox[
    "2"]]}]], \
"Output",ExpressionUUID->"f386e557-3b70-41f5-ab2c-8c81a512abba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "spherical"}], "}"}]}], "]"}], "%"}], "//", 
   "ContractBasis"}], "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"5b0f30cc-9273-423b-a565-b3618a368767"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], 
   SqrtBox[
    "2"]]}]], \
"Output",ExpressionUUID->"1c8c1611-69b0-41ff-90d1-b2db592f6fbb"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4. Products of m, mbar", \
"Subsubsection",ExpressionUUID->"045bc546-5ad2-4927-8e35-3129e9d070e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mmbarRule", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"mbar", "[", "a_", "]"}], 
    RowBox[{"m", "[", "b_", "]"}]}], "\[Rule]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"gamma", "[", 
       RowBox[{"a", ",", "b"}], "]"}], "+", 
      RowBox[{"I", " ", 
       RowBox[{"epsilongamma", "[", 
        RowBox[{"a", ",", "b"}], "]"}]}]}], ")"}], "/", "2"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3d420cce-c94c-4403-bfd6-9ba30543acc6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", 
      UnderscriptBox["b", "_"]],
     AutoSpacing->False],
    m[
     Pattern[b, 
      Blank[]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", 
      UnderscriptBox["a", "_"]],
     AutoSpacing->False],
    mbar[
     Pattern[a, 
      Blank[]]],
    Editable->False]}], "\[Rule]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", "ab"],
        AutoSpacing->False],
       epsilongamma[a, b],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Gamma]", "  ", "ab"],
       AutoSpacing->False],
      gamma[a, b],
      Editable->False]}], 
    ")"}]}]}]], \
"Output",ExpressionUUID->"7004a26a-9e7c-4f7a-b736-798662ae52ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mbar", "[", "a", "]"}], 
  RowBox[{"mbar", "[", "c", "]"}], 
  RowBox[{"mbar", "[", "e", "]"}], 
  RowBox[{
  "mbar", "[", "f1", 
   "]"}]}]], "Input",ExpressionUUID->"c7467b9f-9d9d-417e-b983-35dd655c4c62"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     OverscriptBox["m", "_"], " ", "a"],
    AutoSpacing->False],
   mbar[a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     OverscriptBox["m", "_"], " ", "c"],
    AutoSpacing->False],
   mbar[c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     OverscriptBox["m", "_"], " ", "e"],
    AutoSpacing->False],
   mbar[e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     OverscriptBox["m", "_"], "  ", "f1"],
    AutoSpacing->False],
   mbar[f1],
   Editable->
    False]}]], "Output",ExpressionUUID->"d639c7ca-7550-429c-91e1-f1b70615e3ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mbar", "[", "a", "]"}], 
   RowBox[{"m", "[", "c", "]"}], 
   RowBox[{"mbar", "[", "e", "]"}], 
   RowBox[{"m", "[", "f1", "]"}]}], "/.", 
  "mmbarRule"}]], \
"Input",ExpressionUUID->"dc8124cb-7dfe-479f-8979-ce775d670d82"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", "ac"],
       AutoSpacing->False],
      epsilongamma[a, c],
      Editable->False]}], "+", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Gamma]", "  ", "ac"],
      AutoSpacing->False],
     gamma[a, c],
     Editable->False]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["m", "  ", "f1"],
    AutoSpacing->False],
   m[f1],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox[
     OverscriptBox["m", "_"], " ", "e"],
    AutoSpacing->False],
   mbar[e],
   Editable->
    False]}]], "Output",ExpressionUUID->"a996910d-1a11-4af5-b8bc-bbd11f818901"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mbar", "[", "a", "]"}], 
   RowBox[{"m", "[", "c", "]"}], 
   RowBox[{"mbar", "[", "e", "]"}], 
   RowBox[{"m", "[", "f1", "]"}]}], "//.", 
  "mmbarRule"}]], \
"Input",ExpressionUUID->"da4059bd-b431-4480-a2e5-93fe71d33cfd"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", "ac"],
       AutoSpacing->False],
      epsilongamma[a, c],
      Editable->False]}], "+", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Gamma]", "  ", "ac"],
      AutoSpacing->False],
     gamma[a, c],
     Editable->False]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]\[Gamma]", "   ", "ef1"],
       AutoSpacing->False],
      epsilongamma[e, f1],
      Editable->False]}], "+", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Gamma]", "   ", "ef1"],
      AutoSpacing->False],
     gamma[e, f1],
     Editable->False]}], 
   ")"}]}]], "Output",ExpressionUUID->"c0eac72d-dd4d-4c19-9b45-e30b3291d14e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"561c3736-9096-4194-82ad-81153ee0c60f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]\[Gamma]", "   ", "ef1"],
     AutoSpacing->False],
    epsilongamma[e, f1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "  ", "ac"],
     AutoSpacing->False],
    gamma[a, c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "   ", "af1"],
     AutoSpacing->False],
    gamma[a, f1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "  ", "ce"],
     AutoSpacing->False],
    gamma[c, e],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "  ", "ae"],
     AutoSpacing->False],
    gamma[a, e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "   ", "cf1"],
     AutoSpacing->False],
    gamma[c, f1],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]\[Gamma]", "  ", "ac"],
     AutoSpacing->False],
    epsilongamma[a, c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "   ", "ef1"],
     AutoSpacing->False],
    gamma[e, f1],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "  ", "ac"],
     AutoSpacing->False],
    gamma[a, c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "   ", "ef1"],
     AutoSpacing->False],
    gamma[e, f1],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"2204935a-ef1a-41a3-a9ca-56949c83789a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.5. Orbital basis vectors", \
"Subsubsection",ExpressionUUID->"e2327630-9461-42be-b1b2-2ec09e68fc87"],

Cell["\<\
Again, we define the basis tensor with an arbitrary number of indices:\
\>", "Text",ExpressionUUID->"9f769b5d-e95a-46b5-bb66-fea8f4721c60"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"Orbitalt", "[", 
    RowBox[{
     RowBox[{"LI", "[", "m", "]"}], ",", 
     RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], ",", "S2", ",", 
   RowBox[{"PrintAs", "->", "\"\<t\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"c99f0df2-4857-4142-800e-6dbd3ac1884f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Orbitalt", "[", 
    RowBox[{
     RowBox[{"LI", "[", "m", "]"}], ",", 
     RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   Orbitalt[
    LI[m], 
    AnyIndices[TangentS2]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"68ca54b5-3efb-44a6-abd6-ed8b2d0e79e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "Orbitalt"}]], \
"Input",ExpressionUUID->"f14ced94-93a7-41a9-ad7a-82f6c882b717"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Orbitalt[LI[m], a] are the complex Cartesian vectors. \
Orbitalt[LI[m], a1, ..., as] are the complex Cartesian tensors obtained by \
combination of the former.\"\>"], "Print",
 CellTags->
  "Info3467289667-4776147",ExpressionUUID->"1a1e1260-a1a0-49e0-88eb-\
89cb018a0d2a"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"Dagger", "[", "Orbitalt", "]"}],
           AutoSpacing->False],
          Dagger[Orbitalt],
          Editable->False], "^=", "Orbitalt"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"DependenciesOfTensor", "[", "Orbitalt", "]"}], "^=", 
         RowBox[{"{", "S2", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"HostsOf", "[", "Orbitalt", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"S2", ",", "TangentS2"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"Info", "[", "Orbitalt", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"\<\"tensor\"\>", ",", "\<\"\"\>"}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"PrintAs", "[", "Orbitalt", "]"}], "^=", "\<\"t\"\>"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"SlotsOfTensor", "[", "Orbitalt", "]"}], "^=", 
         RowBox[{"{", 
          RowBox[{"Labels", ",", 
           RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"TensorID", "[", "Orbitalt", "]"}], "^=", 
         RowBox[{"{", "}"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"xTensorQ", "[", "Orbitalt", "]"}], "^=", "True"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Orbitalt"],
  Editable->False]], "Print",
 CellTags->
  "Info3467289667-4776147",ExpressionUUID->"7660ca07-06ad-4a35-85e5-\
c1b71a1b8fb9"]
}, Open  ]]
}, Open  ]],

Cell["They are STF tensors:", \
"Text",ExpressionUUID->"f9b2fcbb-6d2c-4fac-97da-1b384fdb0e5a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SymmetryGroupOfTensor", "[", 
   RowBox[{"Orbitalt", "[", 
    RowBox[{"_LI", ",", "indices__"}], "]"}], "]"}], "^:=", 
  RowBox[{"Symmetric", "[", 
   RowBox[{"1", "+", 
    RowBox[{"Range", "@", 
     RowBox[{"Length", "@", 
      RowBox[{"{", "indices", "}"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Orbitalt", "[", 
   RowBox[{"_LI", ",", "___", ",", "a_", ",", "___", ",", 
    RowBox[{"-", "a_"}], ",", "___"}], "]"}], ":=", "0"}], "\n", 
 RowBox[{
  RowBox[{"Orbitalt", "[", 
   RowBox[{"_LI", ",", "___", ",", 
    RowBox[{"-", "a_"}], ",", "___", ",", "a_", ",", "___"}], "]"}], ":=", 
  "0"}]}], "Input",ExpressionUUID->"efad3663-3f4e-4a32-89d5-b39e5d2591e8"],

Cell["Define Cartesian components:", \
"Text",ExpressionUUID->"284e5bb6-c5f4-44ed-99e3-848ff817c297"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "cartesian"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "I"}], ",", "0"}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "I"}], ",", "0"}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "0", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "cartesian"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "0", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", 
       RowBox[{"-", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "cartesian"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "I"}], ",", "0"}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", 
       RowBox[{"-", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "I"}], ",", "0"}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], 
  ";"}]}], "Input",ExpressionUUID->"3a84bea9-08bb-447c-a169-2e66d6bec7a7"],

Cell["Components of the vectors in the spherical chart:", \
"Text",ExpressionUUID->"5662b300-0586-40fd-b0cc-7b4c04efaedf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "spherical"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
        RowBox[{"I", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"\[Theta]", "[", "]"}], "]"}]}]}], "}"}]}], 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", 
        RowBox[{"\[Phi]", "[", "]"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
        RowBox[{"I", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"\[Theta]", "[", "]"}], "]"}]}]}], "}"}]}], 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", 
        RowBox[{"\[Phi]", "[", "]"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "0", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "spherical"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}]}], ",", "0"}], "}"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "0", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}]}], ",", "0"}], "}"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", 
       RowBox[{"-", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "spherical"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
       RowBox[{"Cos", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"-", "I"}], " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}]}]}], "}"}], 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "I"}], " ", 
        RowBox[{"\[Phi]", "[", "]"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AllComponentValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", 
       RowBox[{"-", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
       RowBox[{"Cos", "[", 
        RowBox[{"\[Theta]", "[", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"-", "I"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", "[", "]"}], "]"}]}]}], "}"}], 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "I"}], " ", 
        RowBox[{"\[Phi]", "[", "]"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], "]"}], 
  ";"}]}], "Input",ExpressionUUID->"7cdd4034-ded5-439d-991e-1036062db5f1"],

Cell["Arbitrary number of indices, in any chart:", \
"Text",ExpressionUUID->"6a2a2112-97ac-49a8-a6e2-ef8e78aa4e0d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Orbitalt", "[", 
   RowBox[{
    RowBox[{"LI", "[", "m_Integer", "]"}], ",", 
    RowBox[{"first", ":", 
     RowBox[{"{", 
      RowBox[{"_Integer", ",", "basis_"}], "}"}]}], ",", 
    RowBox[{"seq", ":", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"_Integer", ",", "basis_"}], "}"}], ".."}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s", "=", 
       RowBox[{"Length", "[", 
        RowBox[{"{", 
         RowBox[{"first", ",", "seq"}], "}"}], "]"}]}], ",", 
      RowBox[{"perms", "=", 
       RowBox[{"Permutations", "[", 
        RowBox[{"{", 
         RowBox[{"first", ",", "seq"}], "}"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ClebschGordan", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "mp"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"s", "-", "1"}], ",", 
           RowBox[{"m", "-", "mp"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "m"}], "}"}]}], "]"}], 
       RowBox[{
        RowBox[{"Plus", "@@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Orbitalt", "[", 
               RowBox[{
                RowBox[{"LI", "[", "mp", "]"}], ",", 
                RowBox[{"First", "[", "#", "]"}]}], "]"}], 
              RowBox[{"Orbitalt", "[", 
               RowBox[{
                RowBox[{"LI", "[", 
                 RowBox[{"m", "-", "mp"}], "]"}], ",", 
                RowBox[{"Sequence", "@@", 
                 RowBox[{"Rest", "[", "#", "]"}]}]}], "]"}]}], ")"}], "&"}], "/@",
            "perms"}], ")"}]}], "/", 
        RowBox[{"Length", "[", "perms", "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"mp", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"ef06b537-ba4f-49eb-9706-d633c3aa6b46"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"ClebschGordan", "::", "phy"}], 
  "]"}]], "Input",ExpressionUUID->"dbfbe588-3f3f-46cd-b7b6-556e0e2eabb6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Orbitalt", "[", 
    RowBox[{
     RowBox[{"LI", "[", "2", "]"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], 
   RowBox[{"Basis", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], "//", 
  "ContractBasis"}]], \
"Input",ExpressionUUID->"4e90646c-b815-4764-aea6-fb01d8b90319"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["t", 
    RowBox[{" ", 
     RowBox[{"a", 
      StyleBox["2",
       FontColor->RGBColor[1, 0, 0]]}]}], 
    RowBox[{"2", "  "}]],
   AutoSpacing->False],
  Orbitalt[
   LI[2], -a, {2, -spherical}],
  Editable->
   False]], "Output",ExpressionUUID->"cdc88e58-a8ba-450c-9263-25b6b9ccbdb5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", 
   RowBox[{"Basis", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], "//", 
  "ContractBasis"}]], \
"Input",ExpressionUUID->"34e858b0-de36-456d-a4ff-8ad06df9bd9a"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["t", 
     RowBox[{" ", 
      StyleBox["2",
       FontColor->RGBColor[1, 0, 0]]}], 
     RowBox[{"1", " "}]],
    AutoSpacing->False],
   Orbitalt[
    LI[1], {2, -spherical}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["t", 
     RowBox[{" ", 
      StyleBox["3",
       FontColor->RGBColor[1, 0, 0]]}], 
     RowBox[{"1", " "}]],
    AutoSpacing->False],
   Orbitalt[
    LI[1], {3, -spherical}],
   Editable->
    False]}]], "Output",ExpressionUUID->"4692bb06-39ad-4823-ad8e-f1782bbcb1dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"245b3e8b-8ac9-42d9-ad23-266d86266e9b"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Cos",
     AutoSpacing->False],
    Cos,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], "]"}], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Sin",
     AutoSpacing->False],
    Sin,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], 
   "]"}]}]], "Output",ExpressionUUID->"80d2d87f-dada-4df4-bb97-a0869f296bb8"]
}, Open  ]],

Cell["All components:", \
"Text",ExpressionUUID->"fe89ed54-a41e-4968-af76-b9b6609ec133"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Orbitalt", "[", 
    RowBox[{
     RowBox[{"LI", "[", "mm", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "spherical"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "spherical"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mm", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"cfa93e97-9396-40b2-9661-a39a04b71be6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]]}], 
       RowBox[{
        RowBox[{"-", "1"}], " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[-1], {2, -spherical}],
     Editable->False], "3"], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["t", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          RowBox[{"-", "1"}], " "}]],
        AutoSpacing->False],
       Orbitalt[
        LI[-1], {2, -spherical}],
       Editable->False], "2"], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["t", 
        RowBox[{" ", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]]}], 
        RowBox[{"0", " "}]],
       AutoSpacing->False],
      Orbitalt[
       LI[0], {2, -spherical}],
      Editable->False]}], 
    SqrtBox["3"]], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["t", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          RowBox[{"-", "1"}], " "}]],
        AutoSpacing->False],
       Orbitalt[
        LI[-1], {2, -spherical}],
       Editable->False], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["t", 
          RowBox[{" ", 
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{"0", " "}]],
         AutoSpacing->False],
        Orbitalt[
         LI[0], {2, -spherical}],
        Editable->False], "2"]}], 
     SqrtBox["15"]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["t", 
          RowBox[{" ", 
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{
           RowBox[{"-", "1"}], " "}]],
         AutoSpacing->False],
        Orbitalt[
         LI[-1], {2, -spherical}],
        Editable->False], "2"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["t", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{"1", " "}]],
        AutoSpacing->False],
       Orbitalt[
        LI[1], {2, -spherical}],
       Editable->False]}], 
     SqrtBox["15"]], "+", 
    RowBox[{
     SqrtBox[
      FractionBox["2", "5"]], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["t", 
        RowBox[{" ", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]]}], 
        RowBox[{
         RowBox[{"-", "1"}], " "}]],
       AutoSpacing->False],
      Orbitalt[
       LI[-1], {2, -spherical}],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox[
         FractionBox["2", "3"]], " ", 
        SuperscriptBox[
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["t", 
            RowBox[{" ", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], 
            RowBox[{"0", " "}]],
           AutoSpacing->False],
          Orbitalt[
           LI[0], {2, -spherical}],
          Editable->False], "2"]}], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["t", 
            RowBox[{" ", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], 
            RowBox[{
             RowBox[{"-", "1"}], " "}]],
           AutoSpacing->False],
          Orbitalt[
           LI[-1], {2, -spherical}],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["t", 
            RowBox[{" ", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], 
            RowBox[{"1", " "}]],
           AutoSpacing->False],
          Orbitalt[
           LI[1], {2, -spherical}],
          Editable->False]}], 
        SqrtBox["6"]]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox[
      FractionBox["2", "5"]], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["t", 
        RowBox[{" ", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]]}], 
        RowBox[{
         RowBox[{"-", "1"}], " "}]],
       AutoSpacing->False],
      Orbitalt[
       LI[-1], {2, -spherical}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["t", 
        RowBox[{" ", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]]}], 
        RowBox[{"0", " "}]],
       AutoSpacing->False],
      Orbitalt[
       LI[0], {2, -spherical}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["t", 
        RowBox[{" ", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]]}], 
        RowBox[{"1", " "}]],
       AutoSpacing->False],
      Orbitalt[
       LI[1], {2, -spherical}],
      Editable->False]}], "+", 
    RowBox[{
     SqrtBox[
      FractionBox["3", "5"]], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["t", 
        RowBox[{" ", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]]}], 
        RowBox[{"0", " "}]],
       AutoSpacing->False],
      Orbitalt[
       LI[0], {2, -spherical}],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox[
         FractionBox["2", "3"]], " ", 
        SuperscriptBox[
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["t", 
            RowBox[{" ", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], 
            RowBox[{"0", " "}]],
           AutoSpacing->False],
          Orbitalt[
           LI[0], {2, -spherical}],
          Editable->False], "2"]}], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["t", 
            RowBox[{" ", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], 
            RowBox[{
             RowBox[{"-", "1"}], " "}]],
           AutoSpacing->False],
          Orbitalt[
           LI[-1], {2, -spherical}],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["t", 
            RowBox[{" ", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], 
            RowBox[{"1", " "}]],
           AutoSpacing->False],
          Orbitalt[
           LI[1], {2, -spherical}],
          Editable->False]}], 
        SqrtBox["6"]]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["t", 
          RowBox[{" ", 
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{"0", " "}]],
         AutoSpacing->False],
        Orbitalt[
         LI[0], {2, -spherical}],
        Editable->False], "2"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["t", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{"1", " "}]],
        AutoSpacing->False],
       Orbitalt[
        LI[1], {2, -spherical}],
       Editable->False]}], 
     SqrtBox["15"]], "+", 
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["t", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{
          RowBox[{"-", "1"}], " "}]],
        AutoSpacing->False],
       Orbitalt[
        LI[-1], {2, -spherical}],
       Editable->False], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["t", 
          RowBox[{" ", 
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]]}], 
          RowBox[{"1", " "}]],
         AutoSpacing->False],
        Orbitalt[
         LI[1], {2, -spherical}],
        Editable->False], "2"]}], 
     SqrtBox["15"]], "+", 
    RowBox[{
     SqrtBox[
      FractionBox["2", "5"]], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["t", 
        RowBox[{" ", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]]}], 
        RowBox[{"1", " "}]],
       AutoSpacing->False],
      Orbitalt[
       LI[1], {2, -spherical}],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SqrtBox[
         FractionBox["2", "3"]], " ", 
        SuperscriptBox[
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["t", 
            RowBox[{" ", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], 
            RowBox[{"0", " "}]],
           AutoSpacing->False],
          Orbitalt[
           LI[0], {2, -spherical}],
          Editable->False], "2"]}], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["t", 
            RowBox[{" ", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], 
            RowBox[{
             RowBox[{"-", "1"}], " "}]],
           AutoSpacing->False],
          Orbitalt[
           LI[-1], {2, -spherical}],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["t", 
            RowBox[{" ", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], 
            RowBox[{"1", " "}]],
           AutoSpacing->False],
          Orbitalt[
           LI[1], {2, -spherical}],
          Editable->False]}], 
        SqrtBox["6"]]}], ")"}]}]}], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["t", 
        RowBox[{" ", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]]}], 
        RowBox[{"0", " "}]],
       AutoSpacing->False],
      Orbitalt[
       LI[0], {2, -spherical}],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["t", 
         RowBox[{" ", 
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]]}], 
         RowBox[{"1", " "}]],
        AutoSpacing->False],
       Orbitalt[
        LI[1], {2, -spherical}],
       Editable->False], "2"]}], 
    SqrtBox["3"]], ",", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {2, -spherical}],
     Editable->False], "3"]}], 
  "}"}]], "Output",ExpressionUUID->"d4cbba3e-7add-4bd3-833b-ef7a6a5b30b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "ToValues"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"d1071d84-aa1c-4e55-a007-3e5a11b152d5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Phi]", "", ""],
         AutoSpacing->False],
        \[Phi][],
        Editable->False]}]], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "3"]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SqrtBox["3"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "2"], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SqrtBox[
     FractionBox["3", "10"]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"5", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], "+", 
     RowBox[{"5", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       RowBox[{"3", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}]}], 
    RowBox[{"4", " ", 
     SqrtBox["10"]}]], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SqrtBox[
     FractionBox["3", "10"]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"5", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SqrtBox["3"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "2"], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "\[ImaginaryI]", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False]}]], " ", 
      SuperscriptBox[
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], "3"]}], 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]]}]}], 
  "}"}]], "Output",ExpressionUUID->"a2f88511-2a42-4588-ba27-6998054768e5"]
}, Open  ]],

Cell["At the poles we have:", \
"Text",ExpressionUUID->"d3da0350-3b71-4bf8-8c95-cd4c6706e7bc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"northpole", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]", "[", "]"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"\[Phi]", "[", "]"}], "\[Rule]", "0"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"southpole", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]", "[", "]"}], "\[Rule]", "Pi"}], ",", 
     RowBox[{
      RowBox[{"\[Phi]", "[", "]"}], "\[Rule]", "0"}]}], "}"}]}], 
  ";"}]}], "Input",ExpressionUUID->"a125fa61-5cbf-4377-b2b2-5499b5f506f8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ToValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Equal]", 
    RowBox[{"-", 
     RowBox[{"m", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], "]"}]}]}], "]"}], "/.", 
  "northpole"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Equal]", 
    RowBox[{"-", 
     RowBox[{"m", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], "]"}]}]}], "]"}], "/.", 
  "northpole"}]}], \
"Input",ExpressionUUID->"6571b354-d1af-475d-9252-8697ea261103"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"d34fe802-ccab-43ad-bc8a-8e2566bdae02"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"bf6833b5-b9b7-42bb-a2c7-ca6a87e41670"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ToValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", 
       RowBox[{"-", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Equal]", 
    RowBox[{"mbar", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "spherical"}]}], "}"}], "]"}]}], "]"}], "/.", 
  "northpole"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", 
       RowBox[{"-", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Equal]", 
    RowBox[{"mbar", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "spherical"}]}], "}"}], "]"}]}], "]"}], "/.", 
  "northpole"}]}], \
"Input",ExpressionUUID->"511e8b76-087e-4458-9d43-3f433bfed1be"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"9da75f78-7d4f-46b0-b47c-e6d628189abb"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"fa572a0d-277f-4c77-be57-337db9747b44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ToValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", 
       RowBox[{"-", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Equal]", 
    RowBox[{"-", 
     RowBox[{"m", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], "]"}]}]}], "]"}], "/.", 
  "southpole"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", 
       RowBox[{"-", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Equal]", 
    RowBox[{"-", 
     RowBox[{"m", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], "]"}]}]}], "]"}], "/.", 
  "southpole"}]}], \
"Input",ExpressionUUID->"f0d626da-3dad-407c-a53e-f672a4e85960"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"66961f22-78ff-4ee9-bacb-3714d4a13e3e"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"fd00d7cd-6188-438d-a630-b5b9485dd5c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ToValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Equal]", 
    RowBox[{"mbar", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "spherical"}]}], "}"}], "]"}]}], "]"}], "/.", 
  "southpole"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToValues", "[", 
   RowBox[{
    RowBox[{"Orbitalt", "[", 
     RowBox[{
      RowBox[{"LI", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Equal]", 
    RowBox[{"mbar", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "spherical"}]}], "}"}], "]"}]}], "]"}], "/.", 
  "southpole"}]}], \
"Input",ExpressionUUID->"8400584c-f3a3-48cb-bb10-40017d234959"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"11142acb-3852-40ef-9032-6946b7b045e7"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"ebf9d927-5309-4dda-a411-5edb85d4c9fa"]
}, Open  ]],

Cell["\<\
These three must coincide. Note the importance of the (-1)^s factor:\
\>", "Text",ExpressionUUID->"182e997d-9929-4328-9a41-2e6da5062a76"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"ToValues", "[", 
     RowBox[{"Orbitalt", "[", 
      RowBox[{
       RowBox[{"LI", "[", "3", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "]"}], "/.", 
    "northpole"}], ",", 
   RowBox[{
    RowBox[{"ToValues", "[", 
     RowBox[{"Orbitalt", "[", 
      RowBox[{
       RowBox[{"LI", "[", 
        RowBox[{"-", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "spherical"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "]"}], "/.", 
    "southpole"}], ",", 
   RowBox[{"ToValues", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", "3"}], 
     RowBox[{"m", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], "]"}], 
     RowBox[{"m", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], "]"}], 
     RowBox[{"m", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], "]"}]}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"b6aafe82-74f7-4c9c-abce-e1aaefcb6d63"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]]}], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]]}], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]]}]}], 
  "}"}]], "Output",ExpressionUUID->"23b6e2a8-a58f-40db-88df-20ca43037da4"]
}, Open  ]],

Cell["We can compute it also using the Cartesian components:", \
"Text",ExpressionUUID->"6635f1e4-e458-4532-bfcc-b850e0071fa4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Orbitalt", "[", 
   RowBox[{
    RowBox[{"LI", "[", "3", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "cartesian"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"b", ",", "cartesian"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", ",", "cartesian"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "spherical"}]}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"9ec4d033-84e4-42d0-a5ad-2046e2f94b61"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["2",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", 
      StyleBox["a",
       FontColor->RGBColor[0, 0, 1]]}]],
    AutoSpacing->False],
   Basis[{2, -spherical}, {a, cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["2",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", 
      StyleBox["b",
       FontColor->RGBColor[0, 0, 1]]}]],
    AutoSpacing->False],
   Basis[{2, -spherical}, {b, cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["2",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", 
      StyleBox["c",
       FontColor->RGBColor[0, 0, 1]]}]],
    AutoSpacing->False],
   Basis[{2, -spherical}, {c, cartesian}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["t", 
     RowBox[{" ", 
      StyleBox[
       RowBox[{"a", "b", "c"}],
       FontColor->RGBColor[0, 0, 1]]}], 
     RowBox[{"3", "   "}]],
    AutoSpacing->False],
   Orbitalt[
    LI[3], {-a, -cartesian}, {-b, -cartesian}, {-c, -cartesian}],
   Editable->
    False]}]], "Output",ExpressionUUID->"cc4df1a7-3c1e-41b2-bdb1-c854f9e973db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraceBasisDummy", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"e168c066-a122-47dd-b77d-49adf901e7de"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["1",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{2, -spherical}, {1, cartesian}],
     Editable->False], "3"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["1",
         FontColor->RGBColor[0, 0, 1]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {1, -cartesian}],
     Editable->False], "3"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["1",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{2, -spherical}, {1, cartesian}],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[0, 0, 1]]}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, {2, cartesian}],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["1",
         FontColor->RGBColor[0, 0, 1]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {1, -cartesian}],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {2, -cartesian}],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["1",
        FontColor->RGBColor[0, 0, 1]]}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, {1, cartesian}],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["2",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{2, -spherical}, {2, cartesian}],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["1",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {1, -cartesian}],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["2",
         FontColor->RGBColor[0, 0, 1]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {2, -cartesian}],
     Editable->False], "2"]}], "+", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["2",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{2, -spherical}, {2, cartesian}],
     Editable->False], "3"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["2",
         FontColor->RGBColor[0, 0, 1]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {2, -cartesian}],
     Editable->False], "3"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["1",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{2, -spherical}, {1, cartesian}],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[0, 0, 1]]}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, {3, cartesian}],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["1",
         FontColor->RGBColor[0, 0, 1]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {1, -cartesian}],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {3, -cartesian}],
    Editable->False]}], "+", 
  RowBox[{"6", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["1",
        FontColor->RGBColor[0, 0, 1]]}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, {1, cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[0, 0, 1]]}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, {2, cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[0, 0, 1]]}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, {3, cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["1",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {1, -cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {2, -cartesian}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {3, -cartesian}],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["2",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{2, -spherical}, {2, cartesian}],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[0, 0, 1]]}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, {3, cartesian}],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["2",
         FontColor->RGBColor[0, 0, 1]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {2, -cartesian}],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {3, -cartesian}],
    Editable->False]}], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["1",
        FontColor->RGBColor[0, 0, 1]]}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, {1, cartesian}],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["3",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{2, -spherical}, {3, cartesian}],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["1",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {1, -cartesian}],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["3",
         FontColor->RGBColor[0, 0, 1]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {3, -cartesian}],
     Editable->False], "2"]}], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[0, 0, 1]]}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, {2, cartesian}],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["3",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{2, -spherical}, {3, cartesian}],
     Editable->False], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {2, -cartesian}],
    Editable->False], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["3",
         FontColor->RGBColor[0, 0, 1]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {3, -cartesian}],
     Editable->False], "2"]}], "+", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", 
        StyleBox["3",
         FontColor->RGBColor[0, 0, 1]]}]],
      AutoSpacing->False],
     Basis[{2, -spherical}, {3, cartesian}],
     Editable->False], "3"], " ", 
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["t", 
       RowBox[{" ", 
        StyleBox["3",
         FontColor->RGBColor[0, 0, 1]]}], 
       RowBox[{"1", " "}]],
      AutoSpacing->False],
     Orbitalt[
      LI[1], {3, -cartesian}],
     Editable->False], 
    "3"]}]}]], "Output",ExpressionUUID->"58bdfd30-9c24-4467-af7d-9c122fb91511"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"b390be24-8ac0-4b76-aab2-c6b332a5007d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "3"], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Phi]", "", ""],
         AutoSpacing->False],
        \[Phi][],
        Editable->False], "]"}], "3"]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]]}], "-", 
  FractionBox[
   RowBox[{"3", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False], "]"}], "2"], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "3"], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False], "]"}], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False], "]"}], "2"]}], 
   RowBox[{"2", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False], "]"}], "3"]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     "2"]}]]}]], \
"Output",ExpressionUUID->"29f7d663-caa8-4a30-b97a-510f1da51748"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"f96052a7-f091-4993-9c1b-924ca7c578d7"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"3", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False]}], "]"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        RowBox[{"3", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False]}], "]"}]}]}], ")"}]}], 
   RowBox[{"2", " ", 
    SqrtBox[
     "2"]}]]}]], \
"Output",ExpressionUUID->"232f3b17-94dc-41eb-9bce-186bbcc5c4b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "northpole"}]], \
"Input",ExpressionUUID->"b5df587d-a94e-4701-93fb-8c959893b591"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    SqrtBox[
     "2"]}]]}]], \
"Output",ExpressionUUID->"edcec326-6030-423e-a983-7c245fbf3246"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Orbitalt", "[", 
  RowBox[{
   RowBox[{"LI", "[", "3", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "cartesian"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "cartesian"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "cartesian"}]}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"78e90d2a-0701-4461-bd3f-998db2deaa75"],

Cell[BoxData[
 SuperscriptBox[
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["t", 
     RowBox[{" ", 
      StyleBox["1",
       FontColor->RGBColor[0, 0, 1]]}], 
     RowBox[{"1", " "}]],
    AutoSpacing->False],
   Orbitalt[
    LI[1], {1, -cartesian}],
   Editable->False], 
  "3"]], "Output",ExpressionUUID->"431c178d-cac8-40ba-b2b8-9efb7b94b781"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"d9ef03bb-98cb-4c2f-882b-7155f01effa3"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    SqrtBox[
     "2"]}]]}]], \
"Output",ExpressionUUID->"bc4f6de9-55da-4468-a201-14e566b635ad"]
}, Open  ]],

Cell["Cut and paste:", \
"Text",ExpressionUUID->"79bf0e7a-5992-4990-b250-a7173f177852"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["t", 
      RowBox[{" ", 
       StyleBox["1",
        FontColor->RGBColor[0, 0, 1]]}], 
      RowBox[{"1", " "}]],
     AutoSpacing->False],
    Orbitalt[
     LI[1], {1, -cartesian}],
    Editable->False], "3"], "//", 
  "InputForm"}]], \
"Input",ExpressionUUID->"f45e53b0-2869-4665-82e9-44442e6f3113"],

Cell["Orbitalt[LI[1], {1, -cartesian}]^3", \
"Output",ExpressionUUID->"bad9cc57-9499-4389-b2ac-a9a8aaa724e7"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["4. Spherical harmonics", \
"Subsection",ExpressionUUID->"d4611536-cd73-4dcd-8d09-8b64851cf774"],

Cell[CellGroupData[{

Cell["STF Spherical harmonics", \
"Subsubsection",ExpressionUUID->"9a9a518b-eca2-4ca0-b7d9-8949b91b56ed"],

Cell["Harmonic label:", \
"Text",ExpressionUUID->"73562dc4-93f9-4a2b-9944-a412cae6d44f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", "l", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8c7925e4-1820-4ca7-a8a4-84778af3cf02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", "l", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", DefConstantSymbol, ": Defining ", "constant symbol ", l, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"a186f532-7d10-4c2f-b51b-eca83f828e70"]
}, Open  ]],

Cell["Now we define the STF tensors.", \
"Text",ExpressionUUID->"611a228e-08f0-4df0-a5d2-9ddc2aa3b7dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", 
     RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], ",", "S2"}], 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"056694f3-5e18-49fb-a3bb-462e8e2c9f77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", 
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False], "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", 
     RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   Z[
    LI[l], 
    LI[m], 
    AnyIndices[TangentS2]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"5af79744-3037-42f5-93f4-f400093bdbd6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", 
     RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], ",", "S2"}], 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e0ef07e3-6d8a-4dd5-96ac-cd3e4b9d9490"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", 
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False], "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", 
     RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   X[
    LI[l], 
    LI[m], 
    AnyIndices[TangentS2]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"78e7129f-3ed2-42c4-ad22-9bde5dcb6d30"]
}, Open  ]],

Cell["\<\
Common notation with a sign. Note the stupid exception for scalars:\
\>", "Text",ExpressionUUID->"6ed04cd1-6d82-4051-b7e5-f8541e2a5e29"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"calZ", "[", 
    RowBox[{
     RowBox[{"LI", "[", "sign", "]"}], ",", 
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", 
     RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], ",", "S2", ",", 
   RowBox[{"PrintAs", "->", "\"\<\[GothicCapitalZ]\>\""}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"eb74e40c-1020-4527-892d-512930272b40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"calZ", "[", 
    RowBox[{
     RowBox[{"LI", "[", "sign", "]"}], ",", 
     RowBox[{"LI", "[", 
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False], "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", 
     RowBox[{"AnyIndices", "[", "TangentS2", "]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "tensor ", 
   calZ[
    LI[sign], 
    LI[l], 
    LI[m], 
    AnyIndices[TangentS2]], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"120006e8-5769-4c11-b4e3-daa36d5efbf9"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"calZ", "[", 
   RowBox[{
    RowBox[{"LI", "[", "1", "]"}], ",", 
    RowBox[{"LI", "[", "l_", "]"}], ",", 
    RowBox[{"LI", "[", "m_", "]"}]}], "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"calZ", "[", 
   RowBox[{
    RowBox[{"LI", "[", "1", "]"}], ",", 
    RowBox[{"LI", "[", "l_", "]"}], ",", 
    RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
  RowBox[{"Z", "[", 
   RowBox[{
    RowBox[{"LI", "[", "l", "]"}], ",", 
    RowBox[{"LI", "[", "m", "]"}], ",", "inds"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"calZ", "[", 
   RowBox[{
    RowBox[{"LI", "[", 
     RowBox[{"-", "1"}], "]"}], ",", 
    RowBox[{"LI", "[", "l_", "]"}], ",", 
    RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", "I"}], " ", 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", "inds"}], "]"}]}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8eac6518-1bde-4306-99db-c54179b810f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"calZ", "[", 
   RowBox[{
    RowBox[{"LI", "[", 
     RowBox[{"c_.", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"2", "b_"}]}], ")"}]}]}], "]"}], ",", 
    RowBox[{"LI", "[", "l_", "]"}], ",", 
    RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
  RowBox[{"calZ", "[", 
   RowBox[{
    RowBox[{"LI", "[", 
     RowBox[{"c", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "a"}]}], "]"}], ",", 
    RowBox[{"LI", "[", "l", "]"}], ",", 
    RowBox[{"LI", "[", "m", "]"}], ",", "inds"}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"84c569bd-67cc-4118-85f2-d5788b16124f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"calZ", "[", 
   RowBox[{
    RowBox[{"LI", "[", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"2", "y"}]}], ")"}]}]}], "]"}], ",", 
    RowBox[{"LI", "[", "l", "]"}], ",", 
    RowBox[{"LI", "[", "m", "]"}], ",", 
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], "//", 
  "InputForm"}]], \
"Input",ExpressionUUID->"9f9d3c14-2085-4c96-8c4b-65bd8b169d2b"],

Cell["calZ[LI[-(-1)^x], LI[l], LI[m], -a, -b]", \
"Output",ExpressionUUID->"6a551d53-37a7-44cf-b4a7-da1e45c05996"]
}, Open  ]],

Cell["0) We need |m|\[LessEqual]l and s\[LessEqual]l:", \
"Text",ExpressionUUID->"d3a99be0-21f5-4eb0-b5f0-5214aa0924ac"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Z", "/:", 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"{", "inds", "}"}], "]"}], ">", "l"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "/:", 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"{", "inds", "}"}], "]"}], ">", "l"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"calZ", "/:", 
   RowBox[{"calZ", "[", 
    RowBox[{
     RowBox[{"LI", "[", "sign_", "]"}], ",", 
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}], ",", "inds___"}], "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"{", "inds", "}"}], "]"}], ">", "l"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"34e5c0db-e191-41da-a891-e41f57d488bd"],

Cell["1) We introduce their symmetry properties:", \
"Text",ExpressionUUID->"523e3d05-9570-436b-b5f9-03c6ed34b751"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryGroupOfTensor", "[", 
   RowBox[{"Z", "[", 
    RowBox[{"_LI", ",", "_LI", ",", "indices___"}], "]"}], "]"}], "^:=", 
  RowBox[{"Symmetric", "[", 
   RowBox[{
    RowBox[{"2", "+", 
     RowBox[{"Range", "@", 
      RowBox[{"Length", "@", 
       RowBox[{"{", "indices", "}"}]}]}]}], ",", "Cycles"}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0d36b88d-2e4f-42ee-b6f2-855db15c0e77"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryGroupOfTensor", "[", 
   RowBox[{"X", "[", 
    RowBox[{"_LI", ",", "_LI", ",", "indices___"}], "]"}], "]"}], "^:=", 
  RowBox[{"Symmetric", "[", 
   RowBox[{
    RowBox[{"2", "+", 
     RowBox[{"Range", "@", 
      RowBox[{"Length", "@", 
       RowBox[{"{", "indices", "}"}]}]}]}], ",", "Cycles"}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"608f76c9-ed51-466a-86c9-3b322520fda4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetryGroupOfTensor", "[", 
   RowBox[{"calZ", "[", 
    RowBox[{"_LI", ",", "_LI", ",", "_LI", ",", "indices___"}], "]"}], "]"}], 
  "^:=", 
  RowBox[{"Symmetric", "[", 
   RowBox[{
    RowBox[{"3", "+", 
     RowBox[{"Range", "@", 
      RowBox[{"Length", "@", 
       RowBox[{"{", "indices", "}"}]}]}]}], ",", "Cycles"}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ffc64cd1-b8fc-4aae-8c09-f0fcabfe83ae"],

Cell["2) They are all traceless:", \
"Text",ExpressionUUID->"04127302-0067-4246-9943-0fb98c1b1c37"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Z", "[", 
   RowBox[{"_LI", ",", "_LI", ",", "___", ",", "a_", ",", "___", ",", 
    RowBox[{"-", "a_"}], ",", "___"}], "]"}], ":=", "0"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Z", "[", 
   RowBox[{"_LI", ",", "_LI", ",", "___", ",", 
    RowBox[{"-", "a_"}], ",", "___", ",", "a_", ",", "___"}], "]"}], ":=", 
  "0"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "[", 
   RowBox[{"_LI", ",", "_LI", ",", "___", ",", "a_", ",", "___", ",", 
    RowBox[{"-", "a_"}], ",", "___"}], "]"}], ":=", "0"}], "\n", 
 RowBox[{
  RowBox[{"X", "[", 
   RowBox[{"_LI", ",", "_LI", ",", "___", ",", 
    RowBox[{"-", "a_"}], ",", "___", ",", "a_", ",", "___"}], "]"}], ":=", 
  "0"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"calZ", "[", 
   RowBox[{"_LI", ",", "_LI", ",", "_LI", ",", "___", ",", "a_", ",", "___", ",", 
    RowBox[{"-", "a_"}], ",", "___"}], "]"}], ":=", "0"}], "\n", 
 RowBox[{
  RowBox[{"calZ", "[", 
   RowBox[{"_LI", ",", "_LI", ",", "_LI", ",", "___", ",", 
    RowBox[{"-", "a_"}], ",", "___", ",", "a_", ",", "___"}], "]"}], ":=", 
  "0"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"30111bd5-73ca-4efe-812b-176aaf734c5e"],

Cell["3) There are no pseudoscalars:", \
"Text",ExpressionUUID->"dddaa14b-cf36-49ac-aa80-8b0c8f9da5c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"X", "[", 
   RowBox[{"_LI", ",", "_LI"}], "]"}], ":=", "0"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d73ffee6-fb4a-46a6-a51a-9e5f91cf0694"],

Cell["4) Orthogonality relations:", \
"Text",ExpressionUUID->"d5b06e2f-8929-4806-8c2e-487e07e1f352"],

Cell[BoxData[
 RowBox[{"X", "/:", " ", 
  RowBox[{
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}], ",", 
     RowBox[{"inds1__", "?", "AIndexQ"}]}], "]"}], 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}], ",", 
     RowBox[{"inds2__", "?", "AIndexQ"}]}], "]"}]}], ":=", 
  RowBox[{"0", "/;", 
   RowBox[{
    RowBox[{"Sort", "[", 
     RowBox[{"xAct`xTensor`Private`TakePairs", "[", 
      RowBox[{"IndexList", "[", 
       RowBox[{"inds1", ",", "inds2"}], "]"}], "]"}], "]"}], "===", 
    RowBox[{"Sort", "[", 
     RowBox[{"IndexList", "[", 
      RowBox[{"inds1", ",", "inds2"}], "]"}], "]"}]}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"48d1295a-6ef5-4e57-ad54-0960d18101aa"],

Cell["5) Products with epsilongamma:", \
"Text",ExpressionUUID->"f12fb6ee-7556-4d61-b816-d1733768b6c1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ZToX", "=", 
   RowBox[{
    RowBox[{"Z", "[", 
     RowBox[{"l_LI", ",", "m_LI", ",", "a_", ",", "b___"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "c", "}"}], ",", 
      RowBox[{"-", 
       RowBox[{"Symmetrize", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"epsilongamma", "[", 
           RowBox[{"a", ",", "c"}], "]"}], 
          RowBox[{"X", "[", 
           RowBox[{"l", ",", "m", ",", 
            RowBox[{"-", "c"}], ",", "b"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"XToZ", "=", 
   RowBox[{
    RowBox[{"X", "[", 
     RowBox[{"l_LI", ",", "m_LI", ",", "a_", ",", "b___"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "c", "}"}], ",", 
      RowBox[{"Symmetrize", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"epsilongamma", "[", 
          RowBox[{"a", ",", "c"}], "]"}], 
         RowBox[{"Z", "[", 
          RowBox[{"l", ",", "m", ",", 
           RowBox[{"-", "c"}], ",", "b"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"calZTocalZ", "=", 
   RowBox[{
    RowBox[{"calZ", "[", 
     RowBox[{
      RowBox[{"LI", "[", "sign_", "]"}], ",", "l_LI", ",", "m_LI", ",", "a_", 
      ",", "b___"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "c", "}"}], ",", 
      RowBox[{
       RowBox[{"-", "I"}], " ", 
       RowBox[{"Symmetrize", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"epsilongamma", "[", 
           RowBox[{"a", ",", "c"}], "]"}], 
          RowBox[{"calZ", "[", 
           RowBox[{
            RowBox[{"LI", "[", 
             RowBox[{"-", "sign"}], "]"}], ",", "l", ",", "m", ",", 
            RowBox[{"-", "c"}], ",", "b"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]}], "]"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cd0b6115-6e29-47b4-988f-3e2270aec4b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dropepsilon", "=", 
   RowBox[{
    RowBox[{"term", ":", 
     RowBox[{"(", 
      RowBox[{"_.", " ", 
       RowBox[{"epsilongamma", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Z", "|", "X", "|", "calZ"}], ")"}], "[", "__", "]"}]}], 
      ")"}]}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"ReplaceAll", "[", 
      RowBox[{"term", ",", 
       RowBox[{"{", 
        RowBox[{"ZToX", ",", "XToZ", ",", "calZTocalZ"}], "}"}]}], "]"}], "/;", 
     RowBox[{
      RowBox[{"IsIndexOf", "[", 
       RowBox[{"term", ",", 
        RowBox[{"-", "a"}]}], "]"}], "||", 
      RowBox[{"IsIndexOf", "[", 
       RowBox[{"term", ",", 
        RowBox[{"-", "b"}]}], "]"}]}]}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b89f9ad4-f564-4149-8da0-e9810c003da2"],

Cell["An alternative coding (not used now):", \
"Text",ExpressionUUID->"7efe3cfe-0ee2-4b9e-a176-406be532a2ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dropepsilon", "=", 
   RowBox[{
    RowBox[{"term", ":", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"_.", " ", 
        RowBox[{"epsilongamma", "[", 
         RowBox[{"___", ",", "a_", ",", "___"}], "]"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Z", "|", "X", "|", "calZ"}], ")"}], "[", 
         RowBox[{"___", ",", 
          RowBox[{"-", "a_"}], ",", "___"}], "]"}]}], "|", 
       RowBox[{"_.", " ", 
        RowBox[{"epsilongamma", "[", 
         RowBox[{"___", ",", 
          RowBox[{"-", "a_"}], ",", "___"}], "]"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Z", "|", "X"}], ")"}], "[", 
         RowBox[{"___", ",", "a_", ",", "___"}], "]"}]}]}], ")"}]}], "\[RuleDelayed]", 
    RowBox[{"ReplaceAll", "[", 
     RowBox[{"term", ",", 
      RowBox[{"{", 
       RowBox[{"ZToX", ",", "XToZ", ",", "calZTocalZ"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"d1846fcf-6cef-4304-971b-38a0bbfddff3"],

Cell["\<\
6) We define the relations between STF tensors with different numbers of \
indices. Note that the only place where epsilongamma appears is in the \
derivative of X_a:\
\>", "Text",ExpressionUUID->"e17f77b3-99d3-4c61-bca6-9a3ac6b1e62a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cd", "[", "a_", "]"}], "[", 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}]}], "]"}], "]"}], ":=", 
  RowBox[{"Z", "[", 
   RowBox[{
    RowBox[{"LI", "[", "l", "]"}], ",", 
    RowBox[{"LI", "[", "m", "]"}], ",", "a"}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5e179654-c8d7-415e-acfb-8c965c23602f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cd", "[", "b_", "]"}], "[", 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}], ",", 
     RowBox[{"a_", "?", "AIndexQ"}]}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", "a", ",", "b"}], "]"}], "-", 
   RowBox[{"l", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"l", "+", "1"}], ")"}], "/", "2"}], 
    RowBox[{"gamma", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"Z", "[", 
     RowBox[{
      RowBox[{"LI", "[", "l", "]"}], ",", 
      RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0ecb3a0a-6723-4fe9-a7b1-496629ce9d61"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cd", "[", "b_", "]"}], "[", 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}], ",", 
     RowBox[{"a_", "?", "AIndexQ"}]}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", "a", ",", "b"}], "]"}], "-", 
   RowBox[{"l", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"l", "+", "1"}], ")"}], "/", "2"}], 
    RowBox[{"epsilongamma", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"Z", "[", 
     RowBox[{
      RowBox[{"LI", "[", "l", "]"}], ",", 
      RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"06d40789-d801-4b4a-8ae1-a910b8701092"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cd", "[", "b_", "]"}], "[", 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}], ",", 
     RowBox[{"a1_", "?", "AIndexQ"}], ",", 
     RowBox[{"a2_", "?", "AIndexQ"}], ",", 
     RowBox[{"a___", "?", "AIndexQ"}]}], "]"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "b$", "}"}], ",", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", "=", 
         RowBox[{"1", "+", "1", "+", 
          RowBox[{"Length", "[", 
           RowBox[{"{", "a", "}"}], "]"}]}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"Z", "[", 
         RowBox[{
          RowBox[{"LI", "[", "l", "]"}], ",", 
          RowBox[{"LI", "[", "m", "]"}], ",", "a1", ",", "a2", ",", "a", ",", 
          "b$"}], "]"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "+", "s"}], ")"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"l", "-", "s", "+", "1"}], ")"}], "/", "2"}], 
         RowBox[{"Symmetrize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"1", "/", "2"}], 
             RowBox[{"gamma", "[", 
              RowBox[{"a1", ",", "a2"}], "]"}], 
             RowBox[{"Z", "[", 
              RowBox[{
               RowBox[{"LI", "[", "l", "]"}], ",", 
               RowBox[{"LI", "[", "m", "]"}], ",", "a", ",", "b$"}], "]"}]}], 
            "-", 
            RowBox[{
             RowBox[{"gamma", "[", 
              RowBox[{"b$", ",", "a1"}], "]"}], 
             RowBox[{"Z", "[", 
              RowBox[{
               RowBox[{"LI", "[", "l", "]"}], ",", 
               RowBox[{"LI", "[", "m", "]"}], ",", "a2", ",", "a"}], 
              "]"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a1", ",", "a2", ",", "a"}], "}"}]}], "]"}]}]}]}], "]"}], 
     "/.", 
     RowBox[{"b$", "\[Rule]", "b"}]}]}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e8f2ca49-90a6-48e3-89bb-2d8616687b60"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cd", "[", "b_", "]"}], "[", 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l_", "]"}], ",", 
     RowBox[{"LI", "[", "m_", "]"}], ",", 
     RowBox[{"a1_", "?", "AIndexQ"}], ",", 
     RowBox[{"a2_", "?", "AIndexQ"}], ",", 
     RowBox[{"a___", "?", "AIndexQ"}]}], "]"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "b$", "}"}], ",", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", "=", 
         RowBox[{"1", "+", "1", "+", 
          RowBox[{"Length", "[", 
           RowBox[{"{", "a", "}"}], "]"}]}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"X", "[", 
         RowBox[{
          RowBox[{"LI", "[", "l", "]"}], ",", 
          RowBox[{"LI", "[", "m", "]"}], ",", "a1", ",", "a2", ",", "a", ",", 
          "b$"}], "]"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "+", "s"}], ")"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"l", "-", "s", "+", "1"}], ")"}], "/", "2"}], 
         RowBox[{"Symmetrize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"1", "/", "2"}], 
             RowBox[{"gamma", "[", 
              RowBox[{"a1", ",", "a2"}], "]"}], 
             RowBox[{"X", "[", 
              RowBox[{
               RowBox[{"LI", "[", "l", "]"}], ",", 
               RowBox[{"LI", "[", "m", "]"}], ",", "a", ",", "b$"}], "]"}]}], 
            "-", 
            RowBox[{
             RowBox[{"gamma", "[", 
              RowBox[{"b$", ",", "a1"}], "]"}], 
             RowBox[{"X", "[", 
              RowBox[{
               RowBox[{"LI", "[", "l", "]"}], ",", 
               RowBox[{"LI", "[", "m", "]"}], ",", "a2", ",", "a"}], 
              "]"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a1", ",", "a2", ",", "a"}], "}"}]}], "]"}]}]}]}], "]"}], 
     "/.", 
     RowBox[{"b$", "\[Rule]", "b"}]}]}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0c8bc3cf-f254-47da-a050-585e93cbbeb7"]
}, Closed]],

Cell[CellGroupData[{

Cell["Pure-spin harmonics", \
"Subsubsection",ExpressionUUID->"72154c8c-6f9c-4292-b8c2-e82ce93de30a"],

Cell["Normalization factor:", \
"Text",ExpressionUUID->"4e96bf41-e5a9-417b-98a7-747ef05ad774"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"coeffK", "[", 
   RowBox[{"l_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"Infinity", "/;", 
   RowBox[{"s", ">", "l"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeffK", "[", 
   RowBox[{"l_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "l"}], "+", "1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "Pi"}], ")"}]}], "/", 
     RowBox[{"2", "^", "s"}]}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"l", "+", "s"}], ")"}], "!"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"l", "-", "s"}], ")"}], "!"}]}]}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"ec39be80-b8de-4859-ac0a-379f53bbe62f"],

Cell["Asymptotics for large l+lp:", \
"Text",ExpressionUUID->"c6e38e1a-e204-48c5-a4a0-69216fc174e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"coeffK", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"L", "-", "Lp", "+", "lpp"}], ")"}], "/", "2"}], ",", "s"}], 
      "]"}], 
     RowBox[{"coeffK", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"L", "+", "Lp", "+", "lpp"}], ")"}], "/", "2"}], ",", "sp"}],
       "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"L", ",", "Infinity", ",", "1"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], \
"Input",ExpressionUUID->"bd482619-f1ad-4f66-ad6e-d49466a81e54"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"esss\"\>"}], ":", 
  " ", "\<\"Essential singularity encountered in \
\\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(\\(\\(-\\(\\(\\(\\(\\(\\*\
InterpretationBox[StyleBox[\\(Log\\), Rule[AutoSpacing, False]], Log, \
Rule[Editable, False]]\\)\\)[\\(\\(2\\\\ \[ExponentialE]\\)\\)]\\)\\/\\(2\\/L\
\\)\\)\\)\\)\\) + \\*InterpretationBox[\\(\\(O[\\(\\(1\\/L\\)\\)]\\)\\^3\\), \
SeriesData[L, DirectedInfinity[1], List[], -1, 3, 1], Rule[Editable, \
False]]\\), SeriesData[L, DirectedInfinity[1], List[Times[Rational[-1, 2], \
Log[Times[2, E]]]], -1, 3, 1], Rule[Editable, False]]\\). \\!\\(\\*ButtonBox[\
\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"Series::esss\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"9be28efb-4b2d-4060-88b4-b33a6b023408"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"esss\"\>"}], ":", 
  " ", "\<\"Essential singularity encountered in \
\\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(\\(\\(-\\(\\(\\(\\(\\(\\*\
InterpretationBox[StyleBox[\\(Log\\), Rule[AutoSpacing, False]], Log, \
Rule[Editable, False]]\\)\\)[\\(\\(2\\\\ \[ExponentialE]\\)\\)]\\)\\/\\(2\\/L\
\\)\\)\\)\\)\\) + \\*InterpretationBox[\\(\\(O[\\(\\(1\\/L\\)\\)]\\)\\^3\\), \
SeriesData[L, DirectedInfinity[1], List[], -1, 3, 1], Rule[Editable, \
False]]\\), SeriesData[L, DirectedInfinity[1], List[Times[Rational[-1, 2], \
Log[Times[2, E]]]], -1, 3, 1], Rule[Editable, False]]\\). \\!\\(\\*ButtonBox[\
\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"Series::esss\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"437d4c2b-785a-4f3a-afb3-78a03633e2a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"esss\"\>"}], ":", 
  " ", "\<\"Essential singularity encountered in \
\\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(\\(\\(-\\(\\(\\(\\(\\(\\*\
InterpretationBox[StyleBox[\\(Log\\), Rule[AutoSpacing, False]], Log, \
Rule[Editable, False]]\\)\\)[\\(\\(2\\\\ \[ExponentialE]\\)\\)]\\)\\/\\(2\\/L\
\\)\\)\\)\\)\\) + \\*InterpretationBox[\\(\\(O[\\(\\(1\\/L\\)\\)]\\)\\^3\\), \
SeriesData[L, DirectedInfinity[1], List[], -1, 3, 1], Rule[Editable, \
False]]\\), SeriesData[L, DirectedInfinity[1], List[Times[Rational[-1, 2], \
Log[Times[2, E]]]], -1, 3, 1], Rule[Editable, False]]\\). \\!\\(\\*ButtonBox[\
\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"Series::esss\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"6134c681-6163-4f76-9fa7-593c44b53f9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(Series :: \\\"esss\\\"\\) will be \
suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"b30399c5-6074-4fb3-9029-fdeef9d11c67"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox["L", 
      RowBox[{"2", " ", "s"}]], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"3", " ", "s"}]}]], 
         FractionBox["1", "L"]], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "L"], "]"}], "0"],
         SeriesData[L, 
          DirectedInfinity[1], {}, -2, 0, 2],
         Editable->False]}],
       SeriesData[L, 
        DirectedInfinity[1], {2^(-2 - 3 s)}, -2, 0, 2],
       Editable->False], ")"}]}]], " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["L", 
      RowBox[{"2", " ", "sp"}]], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"3", " ", "sp"}]}]], 
         FractionBox["1", "L"]], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "L"], "]"}], "0"],
         SeriesData[L, 
          DirectedInfinity[1], {}, -2, 0, 2],
         Editable->False]}],
       SeriesData[L, 
        DirectedInfinity[1], {2^(-2 - 3 sp)}, -2, 0, 2],
       Editable->False], ")"}]}]]}], 
  "\[Pi]"]], "Output",ExpressionUUID->"4137d895-b64f-4201-b11f-cf83ddd16db5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerExpand", "[", "%", "]"}], "//", 
  "FullSimplify"}]], \
"Input",ExpressionUUID->"eaeb3906-3ad5-4c8c-8cc9-ff3430b16ceb"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["L", 
   RowBox[{"s", "+", "sp"}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"s", "+", "sp"}], ")"}]}], "2"]}]], 
      FractionBox["\[Pi]", "L"]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "L"], "]"}], "0"],
      SeriesData[L, 
       DirectedInfinity[1], {}, -2, 0, 2],
      Editable->False]}],
    SeriesData[L, 
     DirectedInfinity[1], {2^(-2 + Rational[-3, 2] (s + sp))/Pi}, -2, 0, 2],
    Editable->False], 
   ")"}]}]], "Output",ExpressionUUID->"038bef53-9bae-4d0f-95bc-ddab88aa165b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], "//", 
  "FullSimplify"}]], \
"Input",ExpressionUUID->"fe0f69fb-9166-466b-af82-68dc93c2fa5d"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"s", "+", "sp"}], ")"}]}], "2"]}]], " ", 
   SuperscriptBox["L", 
    RowBox[{"1", "+", "s", "+", "sp"}]]}], 
  "\[Pi]"]], "Output",ExpressionUUID->"214e5022-c9a4-4095-ba5c-7706e7728806"]
}, Open  ]],

Cell["The pure-spin harmonics are:", \
"Text",ExpressionUUID->"8f365d15-3c53-41cd-a70f-73331a317f96"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PureSpin", "[", 
    RowBox[{"l_", ",", "1", ",", "mlabel_"}], "]"}], "[", "inds___", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"{", "inds", "}"}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"coeffK", "[", 
      RowBox[{"l", ",", "s"}], "]"}], 
     RowBox[{"calD", "[", 
      RowBox[{
       RowBox[{"LI", "@", "l"}], ",", 
       RowBox[{"LI", "@", "s"}], ",", 
       RowBox[{"LI", "@", "mlabel"}]}], "]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", "s"}], " ", 
     RowBox[{"Times", "@@", 
      RowBox[{"(", 
       RowBox[{"m", "/@", 
        RowBox[{"{", "inds", "}"}]}], ")"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PureSpin", "[", 
    RowBox[{"l_", ",", 
     RowBox[{"-", "1"}], ",", "mlabel_"}], "]"}], "[", "inds___", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"{", "inds", "}"}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"coeffK", "[", 
      RowBox[{"l", ",", "s"}], "]"}], 
     RowBox[{"calD", "[", 
      RowBox[{
       RowBox[{"LI", "@", "l"}], ",", 
       RowBox[{"LI", "@", 
        RowBox[{"-", "s"}]}], ",", 
       RowBox[{"LI", "@", "mlabel"}]}], "]"}], 
     RowBox[{"Times", "@@", 
      RowBox[{"(", 
       RowBox[{"mbar", "/@", 
        RowBox[{"{", "inds", "}"}]}], ")"}]}]}]}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"4de8fae4-91e7-4280-b0d5-c64e653efab1"],

Cell["\<\
Note that both PureSpin[-1] and PureSpin[+1] with no indices are equal to the \
scalar spherical harmonics.\
\>", "Text",ExpressionUUID->"59fe92c0-bc6e-4d9d-bcef-c9136196855b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j", "=", "5"}], ",", 
      RowBox[{"m", "=", "2"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"j", ",", "1", ",", "m"}], "]"}], "[", "]"}], ",", 
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"j", ",", 
           RowBox[{"-", "1"}], ",", "m"}], "]"}], "[", "]"}]}], "}"}], "-", 
      RowBox[{"SphericalHarmonicY", "[", 
       RowBox[{"j", ",", "m", ",", 
        RowBox[{"\[Theta]", "[", "]"}], ",", 
        RowBox[{"\[Phi]", "[", "]"}]}], "]"}]}], "/.", "calDRule"}]}], "]"}], 
  "//", "Simplify"}]], \
"Input",ExpressionUUID->"c93df15b-2fa6-421d-8fc3-c935da4738f4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"58d688df-9a2b-4023-9314-d628169b6e8d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j", "=", "4"}], ",", 
      RowBox[{"m", "=", 
       RowBox[{"-", "1"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"j", ",", "1", ",", "m"}], "]"}], "[", "]"}], ",", 
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"j", ",", 
           RowBox[{"-", "1"}], ",", "m"}], "]"}], "[", "]"}]}], "}"}], "-", 
      RowBox[{"SphericalHarmonicY", "[", 
       RowBox[{"j", ",", "m", ",", 
        RowBox[{"\[Theta]", "[", "]"}], ",", 
        RowBox[{"\[Phi]", "[", "]"}]}], "]"}]}], "/.", "calDRule"}]}], "]"}], 
  "//", "Simplify"}]], \
"Input",ExpressionUUID->"ac6aea08-ec8b-4383-832b-3262066d9ee2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"f85b7798-a0f7-4c32-baea-48e386177051"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Relations among them", \
"Subsubsection",ExpressionUUID->"0339ee78-11e4-4cc9-90ae-921f760e52e0"],

Cell[BoxData[
 RowBox[{"ZXToY", ":=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Z", "[", 
      RowBox[{
       RowBox[{"LI", "[", "l_", "]"}], ",", 
       RowBox[{"LI", "[", "m_", "]"}]}], "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"PureSpin", "[", 
       RowBox[{"l", ",", "1", ",", "m"}], "]"}], "[", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Z", "[", 
      RowBox[{
       RowBox[{"LI", "[", "l_", "]"}], ",", 
       RowBox[{"LI", "[", "m_", "]"}], ",", "inds__"}], "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{
       RowBox[{"PureSpin", "[", 
        RowBox[{"l", ",", "1", ",", "m"}], "]"}], "[", "inds", "]"}], "+", 
      RowBox[{
       RowBox[{"PureSpin", "[", 
        RowBox[{"l", ",", 
         RowBox[{"-", "1"}], ",", "m"}], "]"}], "[", "inds", "]"}]}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"X", "[", 
      RowBox[{
       RowBox[{"LI", "[", "l_", "]"}], ",", 
       RowBox[{"LI", "[", "m_", "]"}], ",", "inds__"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"I", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"l", ",", "1", ",", "m"}], "]"}], "[", "inds", "]"}], "-", 
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"l", ",", 
           RowBox[{"-", "1"}], ",", "m"}], "]"}], "[", "inds", "]"}]}], 
       ")"}]}]}]}], "}"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7353384c-d773-4dfb-8a34-8de6f4ee4162"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"paper1", "=", 
  RowBox[{
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "-", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"l", "^", "2"}], "+", "l", "+", "2"}], ")"}], "/", "4"}], 
    RowBox[{"gamma", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"Z", "[", 
      RowBox[{
       RowBox[{"LI", "[", "l", "]"}], ",", 
       RowBox[{"LI", "[", "m", "]"}]}], "]"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"l", "+", "2"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"l", "-", "1"}], ")"}], "/", "2"}], " ", 
    RowBox[{"Symmetrize", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"gamma", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}]}], "]"}], 
       RowBox[{
        RowBox[{"cd", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"Z", "[", 
         RowBox[{
          RowBox[{"LI", "[", "l", "]"}], ",", 
          RowBox[{"LI", "[", "m", "]"}]}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "}"}]}], 
     "]"}]}]}]}]], \
"Input",ExpressionUUID->"5af326c9-bf0f-449e-81bb-62c3950b66cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["l",
       AutoSpacing->False],
      l,
      Editable->False]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     InterpretationBox[
      StyleBox["l",
       AutoSpacing->False],
      l,
      Editable->False]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", "cb", "  "],
        AutoSpacing->False],
       gamma[-c, -b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "a"}], 
         RowBox[{"lm", " "}]],
        AutoSpacing->False],
       Z[
        LI[l], 
        LI[m], -a],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Gamma]", "ca", "  "],
        AutoSpacing->False],
       gamma[-c, -a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "b"}], 
         RowBox[{"lm", " "}]],
        AutoSpacing->False],
       Z[
        LI[l], 
        LI[m], -b],
       Editable->False]}]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     InterpretationBox[
      StyleBox["l",
       AutoSpacing->False],
      l,
      Editable->False], "+", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False], "2"]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", "ab", "  "],
     AutoSpacing->False],
    gamma[-a, -b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "c"}], 
      RowBox[{"lm", " "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -c],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", 
     RowBox[{"  ", "abc"}], 
     RowBox[{"lm", "   "}]],
    AutoSpacing->False],
   Z[
    LI[l], 
    LI[m], -a, -b, -c],
   Editable->
    False]}]], "Output",ExpressionUUID->"a554a932-e55d-4893-b6eb-322a8d141a9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplification", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"cd", "[", 
     RowBox[{"-", "c"}], "]"}], "@", 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "b"}], "]"}], "@", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "a"}], "]"}], "@", 
      RowBox[{"Z", "[", 
       RowBox[{
        RowBox[{"LI", "[", "l", "]"}], ",", 
        RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}], "-", "paper1"}], 
  "]"}]], "Input",ExpressionUUID->"cee418e5-b867-43e2-baaf-3ce2cc45eadb"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"70e1e16a-09e9-4ab6-9bc5-b34f0732ac3e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"paper2", "=", 
   RowBox[{
    RowBox[{"Z", "[", 
     RowBox[{
      RowBox[{"LI", "[", "l", "]"}], ",", 
      RowBox[{"LI", "[", "m", "]"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "-", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"l", "^", "2"}], "+", "l", "+", "6"}], ")"}], "/", "6"}], 
     RowBox[{"gamma", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{
       RowBox[{"cd", "[", 
        RowBox[{"-", "c"}], "]"}], "@", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}], "-", 
    RowBox[{"Symmetrize", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"l", "+", "3"}], ")"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "-", "2"}], ")"}], "/", "6"}], 
        RowBox[{"gamma", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], 
        RowBox[{
         RowBox[{"cd", "[", 
          RowBox[{"-", "b"}], "]"}], "@", 
         RowBox[{
          RowBox[{"cd", "[", 
           RowBox[{"-", "a"}], "]"}], "@", 
          RowBox[{"Z", "[", 
           RowBox[{
            RowBox[{"LI", "[", "l", "]"}], ",", 
            RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}], "+", 
       RowBox[{"l", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "+", "1"}], ")"}], "/", "3"}], 
        RowBox[{"gamma", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "a"}]}], "]"}], 
        RowBox[{
         RowBox[{"cd", "[", 
          RowBox[{"-", "b"}], "]"}], "@", 
         RowBox[{
          RowBox[{"cd", "[", 
           RowBox[{"-", "d"}], "]"}], "@", 
          RowBox[{"Z", "[", 
           RowBox[{
            RowBox[{"LI", "[", "l", "]"}], ",", 
            RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}], "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"l", "+", "3"}], ")"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "-", "2"}], ")"}], "/", "3"}], 
        RowBox[{"gamma", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "a"}]}], "]"}], 
        RowBox[{
         RowBox[{"cd", "[", 
          RowBox[{"-", "c"}], "]"}], "@", 
         RowBox[{
          RowBox[{"cd", "[", 
           RowBox[{"-", "b"}], "]"}], "@", 
          RowBox[{"Z", "[", 
           RowBox[{
            RowBox[{"LI", "[", "l", "]"}], ",", 
            RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"l", "+", "3"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}], "l", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "-", "2"}], ")"}], "/", "12"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"gamma", "[", 
            RowBox[{
             RowBox[{"-", "c"}], ",", 
             RowBox[{"-", "a"}]}], "]"}], 
           RowBox[{"gamma", "[", 
            RowBox[{
             RowBox[{"-", "b"}], ",", 
             RowBox[{"-", "d"}]}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"gamma", "[", 
            RowBox[{
             RowBox[{"-", "a"}], ",", 
             RowBox[{"-", "b"}]}], "]"}], 
           RowBox[{
            RowBox[{"gamma", "[", 
             RowBox[{
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "d"}]}], "]"}], "/", "2"}]}]}], ")"}], 
        RowBox[{"Z", "[", 
         RowBox[{
          RowBox[{"LI", "[", "l", "]"}], ",", 
          RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",ExpressionUUID->"fca4bf0e-574e-4d3d-b5ff-44028f532e49"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplification", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"cd", "[", 
     RowBox[{"-", "d"}], "]"}], "@", 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "c"}], "]"}], "@", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "b"}], "]"}], "@", 
      RowBox[{
       RowBox[{"cd", "[", 
        RowBox[{"-", "a"}], "]"}], "@", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}]}], "-", "paper2"}], 
  "]"}]], "Input",ExpressionUUID->"4c364dcd-e6cc-442c-9905-32586d9de3e4"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"3fac7c6b-7916-4548-ad28-1fe2929ba726"]
}, Open  ]],

Cell["More checks (this are full expansions, brute force):", \
"Text",ExpressionUUID->"b93280c7-1ae6-4122-9c1a-d62d1308aca3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"STFPart", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "c"}], "]"}], "@", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "b"}], "]"}], "@", 
      RowBox[{
       RowBox[{"cd", "[", 
        RowBox[{"-", "a"}], "]"}], "@", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}], ",", "gamma"}], "]"}], 
  "//", "ContractMetric"}]], \
"Input",ExpressionUUID->"86f7eca1-930a-4dc6-8760-115bc9ba0955"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "abc"}], 
      RowBox[{"lm", "   "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -a, -b, -c],
    Editable->False], "6"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "acb"}], 
      RowBox[{"lm", "   "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -a, -c, -b],
    Editable->False], "6"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "bac"}], 
      RowBox[{"lm", "   "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -b, -a, -c],
    Editable->False], "6"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "bca"}], 
      RowBox[{"lm", "   "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -b, -c, -a],
    Editable->False], "6"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "cab"}], 
      RowBox[{"lm", "   "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -c, -a, -b],
    Editable->False], "6"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "cba"}], 
      RowBox[{"lm", "   "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -c, -b, -a],
    Editable->False], 
   "6"]}]], "Output",ExpressionUUID->"c40fcfa0-8a91-4293-8666-b394884a6708"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "Simplification"}]], \
"Input",ExpressionUUID->"810f9610-348b-48f4-afa6-61f3a524e626"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["Z", 
    RowBox[{"  ", "abc"}], 
    RowBox[{"lm", "   "}]],
   AutoSpacing->False],
  Z[
   LI[l], 
   LI[m], -a, -b, -c],
  Editable->
   False]], "Output",ExpressionUUID->"b1783754-816e-4f73-b483-0c9e815c62d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"STFPart", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "d"}], "]"}], "@", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "c"}], "]"}], "@", 
      RowBox[{
       RowBox[{"cd", "[", 
        RowBox[{"-", "b"}], "]"}], "@", 
       RowBox[{
        RowBox[{"cd", "[", 
         RowBox[{"-", "a"}], "]"}], "@", 
        RowBox[{"Z", "[", 
         RowBox[{
          RowBox[{"LI", "[", "l", "]"}], ",", 
          RowBox[{"LI", "[", "m", "]"}]}], "]"}]}]}]}]}], ",", "gamma"}], 
   "]"}], "//", 
  "ContractMetric"}]], \
"Input",ExpressionUUID->"ba719037-e0cb-4694-b00a-08a9242e312a"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "abcd"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -a, -b, -c, -d],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "abdc"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -a, -b, -d, -c],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "acbd"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -a, -c, -b, -d],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "acdb"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -a, -c, -d, -b],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "adbc"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -a, -d, -b, -c],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "adcb"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -a, -d, -c, -b],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "bacd"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -b, -a, -c, -d],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "badc"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -b, -a, -d, -c],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "bcad"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -b, -c, -a, -d],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "bcda"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -b, -c, -d, -a],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "bdac"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -b, -d, -a, -c],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "bdca"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -b, -d, -c, -a],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "cabd"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -c, -a, -b, -d],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "cadb"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -c, -a, -d, -b],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "cbad"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -c, -b, -a, -d],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "cbda"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -c, -b, -d, -a],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "cdab"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -c, -d, -a, -b],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "cdba"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -c, -d, -b, -a],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "dabc"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -d, -a, -b, -c],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "dacb"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -d, -a, -c, -b],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "dbac"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -d, -b, -a, -c],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "dbca"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -d, -b, -c, -a],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "dcab"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -d, -c, -a, -b],
    Editable->False], "24"], "+", 
  FractionBox[
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "dcba"}], 
      RowBox[{"lm", "    "}]],
     AutoSpacing->False],
    Z[
     LI[l], 
     LI[m], -d, -c, -b, -a],
    Editable->False], 
   "24"]}]], "Output",ExpressionUUID->"cdc9398f-c1e1-44e9-b47d-29106fd90634"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "Simplification"}]], \
"Input",ExpressionUUID->"96cefeca-c2fd-46e8-bcd3-2d306632942d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["Z", 
    RowBox[{"  ", "abcd"}], 
    RowBox[{"lm", "    "}]],
   AutoSpacing->False],
  Z[
   LI[l], 
   LI[m], -a, -b, -c, -d],
  Editable->
   False]], "Output",ExpressionUUID->"15a15ad2-04fe-45a7-9d7e-0b5656930a71"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Explicit expressions", \
"Subsubsection",ExpressionUUID->"b5d2349b-30ed-458f-8bec-05936c22d919"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"spherical", "/:", 
   RowBox[{"CNumbersOf", "[", 
    RowBox[{"spherical", ",", "TangentS2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cartesian", "/:", 
   RowBox[{"CNumbersOf", "[", 
    RowBox[{"cartesian", ",", "TangentS2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"1521fe0d-da69-4f98-af88-a9e64dfb7680"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HarmonicComponent", "[", "expr_", "]"}], ":=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"ToValues", "[", 
    RowBox[{
     RowBox[{"expr", "/.", "ZXToY"}], "/.", "calDRule"}], "]"}], 
   "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1e5a28c5-41d8-4889-81b4-a171b7c36a58"],

Cell["Components of tensors can be directly obtained:", \
"Text",ExpressionUUID->"6701e03c-2046-4cc7-8078-e1860cbacf97"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "4", "]"}], ",", 
     RowBox[{"LI", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "4", "]"}], ",", 
     RowBox[{"LI", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"f9178a92-ccfe-4036-a50a-0cdc21034835"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", " "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {2, -spherical}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", " "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {3, -spherical}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"d514dc1d-2491-4d25-945f-73b92d1e6c57"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"dd0767ab-023e-4c9d-84dc-104d5d26433c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "16"]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", "\[Pi]"]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"2", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}], "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "32"]}], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", "\[Pi]"]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"9", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"3", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"9e9a19d5-61c3-404a-a3de-4ebfd90bf907"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "4", "]"}], ",", 
     RowBox[{"LI", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "4", "]"}], ",", 
     RowBox[{"LI", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "spherical"}]}], "}"}]}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"40b759e7-221b-4678-b6ae-400ebaefcaf3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", " "}]],
     AutoSpacing->False],
    X[
     LI[4], 
     LI[1], {2, -spherical}],
    Editable->False], ",", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", " "}]],
     AutoSpacing->False],
    X[
     LI[4], 
     LI[1], {3, -spherical}],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"3d6e1f9d-3241-4d81-ba99-2e644357e650"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"f8da2ded-219a-42b4-881d-b969cd78d64e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "32"]}], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", "\[Pi]"]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"9", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"3", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["3", "16"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", "\[Pi]"]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"2", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}], "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"ea862b0a-ce69-4d75-96f5-b10f83aeb7cf"]
}, Open  ]],

Cell["\<\
However, derivatives must be computed with care. For example:\
\>", "Text",ExpressionUUID->"62a3f028-aa32-4fe4-87d2-c7cd99054840"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "spherical"}]}], "}"}], "]"}], "[", 
  RowBox[{
   RowBox[{"cd", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "spherical"}]}], "}"}], "]"}], "[", 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "4", "]"}], ",", 
     RowBox[{"LI", "[", "1", "]"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"bd7a459c-4d02-4754-892e-f18fe6715315"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["Z", 
    RowBox[{"  ", 
     RowBox[{
      StyleBox["3",
       FontColor->RGBColor[1, 0, 0]], ":", 
      StyleBox["3",
       FontColor->RGBColor[1, 0, 0]]}]}], 
    RowBox[{"41", "   "}]],
   AutoSpacing->False],
  cd[{3, -spherical}][
   Z[
    LI[4], 
    LI[1], {3, -spherical}]],
  Editable->
   False]], "Output",ExpressionUUID->"4f5d2043-98f7-4eee-a149-b4a707fc69f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"7d53587a-196c-49e2-8647-b96501ed7792"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "32"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", "\[Pi]"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"9", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}], "+", 
    RowBox[{"7", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"3", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Sin",
     AutoSpacing->False],
    Sin,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], 
   "]"}]}]], "Output",ExpressionUUID->"31122301-abfa-41b1-b25a-35c9e483ef10"]
}, Open  ]],

Cell["\<\
That is not a component of the second derivative of a scalar harmonic:\
\>", "Text",ExpressionUUID->"767ca7cb-34a4-4854-8373-3c24d0003437"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractBasis", "[", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "a"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "b"}], "]"}], 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"Z", "[", 
       RowBox[{
        RowBox[{"LI", "[", "4", "]"}], ",", 
        RowBox[{"LI", "[", "1", "]"}]}], "]"}], "]"}], "]"}]}], "]"}], "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"26563c1d-981f-495d-ae61-9fe875ff5d81"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "10"}], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "41"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1]],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", 
     RowBox[{"  ", 
      StyleBox[
       RowBox[{"3", "3"}],
       FontColor->RGBColor[1, 0, 0]]}], 
     RowBox[{"41", "  "}]],
    AutoSpacing->False],
   Z[
    LI[4], 
    LI[1], {3, -spherical}, {3, -spherical}],
   Editable->
    False]}]], "Output",ExpressionUUID->"6fc2dae3-d3a2-4149-8fbb-080d8eac8c41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"50176200-8319-4644-9bb1-b05dac88f584"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "8"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", "\[Pi]"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"15", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}], "+", 
    RowBox[{"7", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"3", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], 
   "3"]}]], "Output",ExpressionUUID->"165ce841-28da-415a-9cd9-51f5a7fa7f36"]
}, Open  ]],

Cell[TextData[{
 "The reason is the way ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 "  understands component derivatives:"
}], "Text",ExpressionUUID->"f4d06cea-7b5e-44bf-8a8f-e6dd2f853611"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "spherical"}]}], "}"}], "]"}], "[", 
  RowBox[{
   RowBox[{"cd", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"-", "spherical"}]}], "}"}], "]"}], "[", 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "4", "]"}], ",", 
     RowBox[{"LI", "[", "1", "]"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"9212887e-3044-4ae5-ad33-13582d231ad9"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["Z", 
    RowBox[{"  ", 
     RowBox[{
      StyleBox["3",
       FontColor->RGBColor[1, 0, 0]], ":", 
      StyleBox["3",
       FontColor->RGBColor[1, 0, 0]]}]}], 
    RowBox[{"41", "   "}]],
   AutoSpacing->False],
  cd[{3, -spherical}][
   Z[
    LI[4], 
    LI[1], {3, -spherical}]],
  Editable->
   False]], "Output",ExpressionUUID->"0a06e4fe-dd3a-458a-a8a2-5a1b6432dba6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeparateBasis", "[", "AIndex", "]"}], "[", 
  RowBox[{"%", ",", 
   RowBox[{"IndicesOf", "[", "spherical", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"9937ae03-1c90-4939-94a8-fbf0a3d8a2b6"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["3",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "a"}]],
    AutoSpacing->False],
   Basis[{3, -spherical}, a],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{"D", ",", 
          StyleBox["\[ScriptCapitalD]",
           FontColor->RGBColor[1, 0, 0]]}], "]"}], 
        RowBox[{" ", 
         RowBox[{"a", 
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]]}]}], 
        RowBox[{"b", "  "}]],
       AutoSpacing->False],
      ChristoffelcdPDspherical[b, -a, {3, -spherical}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", 
        RowBox[{"  ", "b"}], 
        RowBox[{"41", " "}]],
       AutoSpacing->False],
      Z[
       LI[4], 
       LI[1], -b],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "b"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, b],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "10"}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Gamma]", "ba", "  "],
          AutoSpacing->False],
         gamma[-b, -a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["Z", "  ", "41"],
          AutoSpacing->False],
         Z[
          LI[4], 
          LI[1]],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["Z", 
          RowBox[{"  ", "ba"}], 
          RowBox[{"41", "  "}]],
         AutoSpacing->False],
        Z[
         LI[4], 
         LI[1], -b, -a],
        Editable->False]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"c1ed580a-82ca-4351-a541-ec1624f9551a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SeparateBasis", "[", "spherical", "]"}], "[", "%", "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"f889d1b2-7f61-4ccd-b361-53c431a42451"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "10"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["e",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {e, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["f",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {f, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["c",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, {c, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["d",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, {d, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["c",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{-c, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["d",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{-d, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Gamma]", 
      StyleBox[
       RowBox[{"f", "e"}],
       FontColor->RGBColor[1, 0, 0]], "  "],
     AutoSpacing->False],
    gamma[{-f, -spherical}, {-e, -spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "41"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["f",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {f, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", "  "}], 
      RowBox[{" ", 
       StyleBox["f1",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {f1, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["c",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, {c, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["d",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, {d, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["c",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{-c, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["e",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{-e, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      RowBox[{"\[CapitalGamma]", "[", 
       RowBox[{"D", ",", 
        StyleBox["\[ScriptCapitalD]",
         FontColor->RGBColor[1, 0, 0]]}], "]"}], 
      RowBox[{" ", 
       StyleBox[
        RowBox[{"f", "d"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{
       StyleBox["e",
        FontColor->RGBColor[1, 0, 0]], "  "}]],
     AutoSpacing->False],
    ChristoffelcdPDspherical[{
     e, spherical}, {-f, -spherical}, {-d, -spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["f1",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", "  "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {-f1, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["e",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {e, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["f",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {f, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["c",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, {c, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", 
       StyleBox["d",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, {d, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["c",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{-c, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["d",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{-d, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"f", "e"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", "  "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {-f, -spherical}, {-e, -spherical}],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"1e817c70-4ed8-4591-839a-b834f4563153"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "TraceBasisDummy"}], "//", "ToValues"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"1d7fd116-3b3f-43f2-b53e-dfc6b8730acb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "10"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "41"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1]],
    Editable->False]}], "-", 
  RowBox[{"10", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, b],
    Editable->False], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "41"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, b],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Cot",
      AutoSpacing->False],
     Cot,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", " "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {2, -spherical}],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Cos",
      AutoSpacing->False],
     Cos,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", " "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, b],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Cot",
      AutoSpacing->False],
     Cot,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", " "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {3, -spherical}],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{2, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Cos",
      AutoSpacing->False],
     Cos,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", " "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {3, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"2", "2"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", "  "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {2, -spherical}, {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"2", "3"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", "  "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {2, -spherical}, {3, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {2, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"3", "2"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", "  "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {3, -spherical}, {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"a", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-a, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{"b", " "}], 
      RowBox[{" ", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}]],
     AutoSpacing->False],
    Basis[-b, {3, spherical}],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "a"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["e", 
      RowBox[{
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]], " "}], 
      RowBox[{" ", "b"}]],
     AutoSpacing->False],
    Basis[{3, -spherical}, b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"3", "3"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", "  "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {3, -spherical}, {3, -spherical}],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"dcc37db7-5278-4ad9-9813-72be5bfa7347"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"a314ccdd-98a9-4fc7-9c6e-23016f715383"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "512"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", "\[Pi]"]], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["3",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "a"}]],
    AutoSpacing->False],
   Basis[{3, -spherical}, a],
   Editable->False], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Csc",
     AutoSpacing->False],
    Csc,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{"a", " "}], 
        RowBox[{" ", 
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]]}]],
       AutoSpacing->False],
      Basis[-a, {3, spherical}],
      Editable->False], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["e", 
           RowBox[{"b", " "}], 
           RowBox[{" ", 
            StyleBox["3",
             FontColor->RGBColor[1, 0, 0]]}]],
          AutoSpacing->False],
         Basis[-b, {3, spherical}],
         Editable->False], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["e", 
              RowBox[{
               StyleBox["2",
                FontColor->RGBColor[1, 0, 0]], " "}], 
              RowBox[{" ", "b"}]],
             AutoSpacing->False],
            Basis[{2, -spherical}, b],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"9", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox[
                 SubsuperscriptBox["\[Theta]", "", ""],
                 AutoSpacing->False],
                \[Theta][],
                Editable->False], "]"}]}], "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"3", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["e", 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], " "}], 
              RowBox[{" ", "b"}]],
             AutoSpacing->False],
            Basis[{3, -spherical}, b],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              InterpretationBox[
               StyleBox["Sin",
                AutoSpacing->False],
               Sin,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox["\[Theta]", "", ""],
                AutoSpacing->False],
               \[Theta][],
               Editable->False], "]"}], "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"3", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["e", 
           RowBox[{"b", " "}], 
           RowBox[{" ", 
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]]}]],
          AutoSpacing->False],
         Basis[-b, {2, spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["e", 
              RowBox[{
               StyleBox["2",
                FontColor->RGBColor[1, 0, 0]], " "}], 
              RowBox[{" ", "b"}]],
             AutoSpacing->False],
            Basis[{2, -spherical}, b],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              InterpretationBox[
               StyleBox["Cos",
                AutoSpacing->False],
               Cos,
               Editable->False], "[", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox["\[Theta]", "", ""],
                AutoSpacing->False],
               \[Theta][],
               Editable->False], "]"}], "+", 
             RowBox[{"8", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"3", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"5", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"3", " ", "\[ImaginaryI]", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["e", 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], " "}], 
              RowBox[{" ", "b"}]],
             AutoSpacing->False],
            Basis[{3, -spherical}, b],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               InterpretationBox[
                StyleBox[
                 SubsuperscriptBox["\[Theta]", "", ""],
                 AutoSpacing->False],
                \[Theta][],
                Editable->False], "]"}]}], "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"3", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}],
     "+", 
    RowBox[{"16", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{"a", " "}], 
        RowBox[{" ", 
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]]}]],
       AutoSpacing->False],
      Basis[-a, {2, spherical}],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "b"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, b],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["e", 
           RowBox[{"b", " "}], 
           RowBox[{" ", 
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]]}]],
          AutoSpacing->False],
         Basis[-b, {2, spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}], "+", 
          RowBox[{"18", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}], "-", 
          RowBox[{"35", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"5", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["e", 
           RowBox[{"b", " "}], 
           RowBox[{" ", 
            StyleBox["3",
             FontColor->RGBColor[1, 0, 0]]}]],
          AutoSpacing->False],
         Basis[-b, {3, spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}], "+", 
          RowBox[{"6", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}], "-", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"5", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"39c3d070-59bb-4c43-bb6a-e506c2361a72"]
}, Open  ]],

Cell["Or in other words:", \
"Text",ExpressionUUID->"726855a4-fc8f-4ebf-b527-fa19af203355"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicComponent", "[", 
  RowBox[{"Z", "[", 
   RowBox[{
    RowBox[{"LI", "[", "4", "]"}], ",", 
    RowBox[{"LI", "[", "1", "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"25f53970-c739-4694-a574-191d8f1823d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["3", "32"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", "\[Pi]"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"9", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}], "+", 
    RowBox[{"7", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"3", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Sin",
     AutoSpacing->False],
    Sin,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], 
   "]"}]}]], "Output",ExpressionUUID->"b9e91f01-5147-4175-96e9-661e57761793"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Phi]", "[", "]"}], ",", "2"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"ec7d5a67-683f-4f21-ab5d-8975ae6c5fcc"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "32"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", "\[Pi]"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"9", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}], "+", 
    RowBox[{"7", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"3", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Sin",
     AutoSpacing->False],
    Sin,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], 
   "]"}]}]], "Output",ExpressionUUID->"35c0f3b5-2453-409c-a71b-9a578dd409e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractBasis", "[", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "a"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "b"}], "]"}], 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"Z", "[", 
       RowBox[{
        RowBox[{"LI", "[", "4", "]"}], ",", 
        RowBox[{"LI", "[", "1", "]"}]}], "]"}], "]"}], "]"}]}], "]"}], "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"4d017bd2-d673-44c0-be3f-70d5c286f87e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["Z", 
    RowBox[{"  ", 
     StyleBox[
      RowBox[{"3", "2"}],
      FontColor->RGBColor[1, 0, 0]]}], 
    RowBox[{"41", "  "}]],
   AutoSpacing->False],
  Z[
   LI[4], 
   LI[1], {3, -spherical}, {2, -spherical}],
  Editable->
   False]], "Output",ExpressionUUID->"ba9d8769-cfa3-41aa-b10d-6954d017f89b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"78ecf1bb-ea8c-4a1f-b867-2a7e5fd4b780"],

Cell[BoxData[
 RowBox[{
  FractionBox["9", "16"], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", "\[Pi]"]], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", 
    RowBox[{"7", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], 
   "2"]}]], "Output",ExpressionUUID->"514b837f-1fdc-42df-9044-a69592c88140"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cd", "[", 
   RowBox[{"-", "a"}], "]"}], "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "spherical"}]}], "}"}], ",", "b"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"d941b85b-90c7-45a5-8e9c-d565da1f9d44"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox[
    RowBox[{"\[CapitalGamma]", "[", 
     RowBox[{"D", ",", 
      StyleBox["\[ScriptCapitalD]",
       FontColor->RGBColor[1, 0, 0]]}], "]"}], 
    RowBox[{" ", 
     RowBox[{"a", 
      StyleBox["2",
       FontColor->RGBColor[1, 0, 0]]}]}], 
    RowBox[{"b", "  "}]],
   AutoSpacing->False],
  ChristoffelcdPDspherical[b, -a, {2, -spherical}],
  Editable->
   False]], "Output",ExpressionUUID->"7967fa28-d714-44be-af9c-d2fe69287622"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractBasis", "[", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "a"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "b"}], "]"}], 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"X", "[", 
      RowBox[{
       RowBox[{"LI", "[", "4", "]"}], ",", 
       RowBox[{"LI", "[", "2", "]"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "]"}]}], "]"}], "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"67c0bee5-5fff-4d7f-a7e0-4a229c2f0ca5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["9", "16"]}], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "+", 
    RowBox[{"7", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"3", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], 
   "2"]}]], "Output",ExpressionUUID->"08c7d288-9310-479c-b056-bbfb511bf97a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractBasis", "[", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "a"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "b"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "c"}], "]"}], 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "a"}], "]"}], "@", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{
       RowBox[{"cd", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "4", "]"}], ",", 
         RowBox[{"LI", "[", "1", "]"}]}], "]"}], "]"}], "]"}]}]}], "]"}], "//",
   "HarmonicComponent"}]], \
"Input",ExpressionUUID->"ef0b4b65-54ad-4725-85ea-aec3b5153696"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "16"], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", "\[Pi]"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"81", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}]}], "+", 
    RowBox[{"35", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"3", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], 
   "3"]}]], "Output",ExpressionUUID->"9ea577e2-ec70-4caf-9d58-ec0fdc529e8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractBasis", "[", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "a"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "b"}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", 
        RowBox[{"-", "spherical"}]}], "}"}], ",", "c"}], "]"}], 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "a"}], "]"}], "@", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"X", "[", 
       RowBox[{
        RowBox[{"LI", "[", "4", "]"}], ",", 
        RowBox[{"LI", "[", "1", "]"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}]}], "]"}], "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"f602bb77-e4c3-4efc-af03-8f3181ab658c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["9", "16"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", "\[Pi]"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"5", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}], "+", 
    RowBox[{"7", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"4", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], 
   "3"]}]], "Output",ExpressionUUID->"901571b6-12cd-4b8e-8323-dc4d323753db"]
}, Open  ]],

Cell["New example:", \
"Text",ExpressionUUID->"346fbeb5-a6d8-430d-a974-9f93f7600bde"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Z", "[", 
   RowBox[{
    RowBox[{"LI", "[", "4", "]"}], ",", 
    RowBox[{"LI", "[", "3", "]"}], ",", "a", ",", "b"}], "]"}], 
  RowBox[{"X", "[", 
   RowBox[{
    RowBox[{"LI", "[", "4", "]"}], ",", 
    RowBox[{"LI", "[", "3", "]"}], ",", 
    RowBox[{"-", "a"}], ",", "c"}], 
   "]"}]}]], "Input",ExpressionUUID->"d425d306-f169-4549-a5a3-323049a85bff"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"  ", "a", " "}], 
     RowBox[{"43", " ", "c"}]],
    AutoSpacing->False],
   X[
    LI[4], 
    LI[3], -a, c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", "    ", 
     RowBox[{"43", "ab"}]],
    AutoSpacing->False],
   Z[
    LI[4], 
    LI[3], a, b],
   Editable->
    False]}]], "Output",ExpressionUUID->"f8a3f569-f1c3-4a77-b79f-23ddbbaaf3ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  RowBox[{
  "SeparateBasis", "[", "spherical", 
   "]"}]}]], "Input",ExpressionUUID->"4c735b3d-86c5-4ebc-b319-1e4be8a11e24"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{"a", " "}], 
     RowBox[{" ", 
      StyleBox["d",
       FontColor->RGBColor[1, 0, 0]]}]],
    AutoSpacing->False],
   Basis[-a, {d, spherical}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["e",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "c"}]],
    AutoSpacing->False],
   Basis[{-e, -spherical}, c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["f",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "a"}]],
    AutoSpacing->False],
   Basis[{-f, -spherical}, a],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["f1",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{"  ", "b"}]],
    AutoSpacing->False],
   Basis[{-f1, -spherical}, b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"  ", 
      StyleBox["d",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{"43", " ", 
      StyleBox["e",
       FontColor->RGBColor[1, 0, 0]]}]],
    AutoSpacing->False],
   X[
    LI[4], 
    LI[3], {-d, -spherical}, {e, spherical}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", "     ", 
     RowBox[{"43", 
      StyleBox["f",
       FontColor->RGBColor[1, 0, 0]], 
      StyleBox["f1",
       FontColor->RGBColor[1, 0, 0]]}]],
    AutoSpacing->False],
   Z[
    LI[4], 
    LI[3], {f, spherical}, {f1, spherical}],
   Editable->
    False]}]], "Output",ExpressionUUID->"88e67146-f3a3-4e9a-a74f-6187b10e20ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractBasis", "[", 
  RowBox[{"%", ",", "AIndex"}], 
  "]"}]], "Input",ExpressionUUID->"b006d1b2-f767-435a-be18-1b0dcb49b9fa"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["a",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "c"}]],
    AutoSpacing->False],
   Basis[{-a, -spherical}, c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["e",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "b"}]],
    AutoSpacing->False],
   Basis[{-e, -spherical}, b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"  ", 
      StyleBox["d",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{"43", " ", 
      StyleBox["a",
       FontColor->RGBColor[1, 0, 0]]}]],
    AutoSpacing->False],
   X[
    LI[4], 
    LI[3], {-d, -spherical}, {a, spherical}],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", "    ", 
     RowBox[{"43", 
      StyleBox["d",
       FontColor->RGBColor[1, 0, 0]], 
      StyleBox["e",
       FontColor->RGBColor[1, 0, 0]]}]],
    AutoSpacing->False],
   Z[
    LI[4], 
    LI[3], {d, spherical}, {e, spherical}],
   Editable->
    False]}]], "Output",ExpressionUUID->"189ddffc-06a7-4dcd-8562-292307ede7af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"4d7d10ee-606e-4bde-95e4-d04a0ae135a2"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", "\[Pi]"}]], 
  RowBox[{"(", 
   RowBox[{"2835", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"6", " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["a",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", "c"}]],
      AutoSpacing->False],
     Basis[{-a, -spherical}, c],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["e", 
       RowBox[{
        StyleBox["e",
         FontColor->RGBColor[1, 0, 0]], " "}], 
       RowBox[{" ", "b"}]],
      AutoSpacing->False],
     Basis[{-e, -spherical}, b],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         FractionBox[
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "2"], "]"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}]}], ")"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["m", " ", 
          StyleBox["a",
           FontColor->RGBColor[1, 0, 0]]],
         AutoSpacing->False],
        m[{a, spherical}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["m", 
          StyleBox["d",
           FontColor->RGBColor[1, 0, 0]], " "],
         AutoSpacing->False],
        m[{-d, -spherical}],
        Editable->False]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}]}], ")"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox[
          OverscriptBox["m", "_"], " ", 
          StyleBox["a",
           FontColor->RGBColor[1, 0, 0]]],
         AutoSpacing->False],
        mbar[{a, spherical}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox[
          OverscriptBox["m", "_"], 
          StyleBox["d",
           FontColor->RGBColor[1, 0, 0]], " "],
         AutoSpacing->False],
        mbar[{-d, -spherical}],
        Editable->False], " ", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         FractionBox[
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "2"], "]"}], "4"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         FractionBox[
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "2"], "]"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}]}], ")"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["m", " ", 
          StyleBox["d",
           FontColor->RGBColor[1, 0, 0]]],
         AutoSpacing->False],
        m[{d, spherical}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["m", " ", 
          StyleBox["e",
           FontColor->RGBColor[1, 0, 0]]],
         AutoSpacing->False],
        m[{e, spherical}],
        Editable->False]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}]}], ")"}], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox[
          OverscriptBox["m", "_"], " ", 
          StyleBox["d",
           FontColor->RGBColor[1, 0, 0]]],
         AutoSpacing->False],
        mbar[{d, spherical}],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox[
          OverscriptBox["m", "_"], " ", 
          StyleBox["e",
           FontColor->RGBColor[1, 0, 0]]],
         AutoSpacing->False],
        mbar[{e, spherical}],
        Editable->False], " ", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         FractionBox[
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False], "2"], "]"}], "4"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "2"]}], 
   ")"}]}]], "Output",ExpressionUUID->"513b6249-3cf2-4449-92ff-318813ccef5f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "TraceBasisDummy"}], "//", "ToValues"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"cc51c4de-48d0-4fc3-9c46-d867a098eb56"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2835", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"6", " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", "c"}]],
        AutoSpacing->False],
       Basis[{2, -spherical}, c],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", "b"}]],
        AutoSpacing->False],
       Basis[{3, -spherical}, b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["2",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", "b"}]],
        AutoSpacing->False],
       Basis[{2, -spherical}, b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["e", 
         RowBox[{
          StyleBox["3",
           FontColor->RGBColor[1, 0, 0]], " "}], 
         RowBox[{" ", "c"}]],
        AutoSpacing->False],
       Basis[{3, -spherical}, c],
       Editable->False]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"2", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "5"]}], 
  RowBox[{
  "64", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"607ad4de-4dbd-4f01-b63a-daa0c3e438e3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Pure-orbital harmonics", \
"Subsubsection",ExpressionUUID->"77cb5b03-1db0-4e00-a606-c5358aad7d51"],

Cell["\<\
Here we show that the Cartesian components of the pure-orbital harmonics are \
eigenfunctions of the Laplacian, but not of the z component of angular \
momentum. Note that this form for the Laplacian is only valid on scalars:\
\>", "Text",ExpressionUUID->"90e2c604-c799-40ea-ba30-daffd3ca932e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LaplacianOnScalars", "[", "expr_", "]"}], ":=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "]"}]}], "]"}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"\[Theta]", "[", "]"}], "]"}], "/", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Theta]", "[", "]"}], "]"}]}], 
    RowBox[{"D", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"\[Theta]", "[", "]"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"\[Phi]", "[", "]"}], ",", 
      RowBox[{"\[Phi]", "[", "]"}]}], "]"}], "/", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"\[Theta]", "[", "]"}], "]"}], "^", 
     "2"}]}]}]}]], \
"Input",ExpressionUUID->"66860feb-f1c7-440c-9f1f-ef1bd673a6a0"],

Cell["Note that we use Separate twice:", \
"Text",ExpressionUUID->"3130795a-c116-4826-a21a-7a32b25e6f3c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SeparateBasis"}]], \
"Input",ExpressionUUID->"fb3b5e5a-a364-4367-add7-c84fda3bdceb"],

Cell[BoxData["\<\"SeparateBasis[basis][expr, indices] expands indices of \
objects in expr into products of Basis objects and the original objects, \
using contractions of indices specified by basis. When basis is AIndex or is \
not given, abstract indices are used. The list of indices can be supplied in \
different ways, using IndicesOf[selectors], a list of g-indices with head \
IndexList or a single g-index. See the documentation for IndicesOf for a \
complete list of possible selectors.\"\>"], "Print",
 CellTags->
  "Info3467290051-1079711",ExpressionUUID->"0ee5ba7c-8fb8-4399-9c6e-\
26cd2e7235f8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Laplacian", "[", "expr_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateBasis", "[", "spherical", "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"SeparateBasis", "[", "spherical", "]"}], "[", 
        RowBox[{
         RowBox[{
          RowBox[{"DummyToBasis", "[", "spherical", "]"}], "[", 
          RowBox[{"ContractBasis", "[", 
           RowBox[{
            RowBox[{"gamma", "[", 
             RowBox[{"a", ",", "b"}], "]"}], 
            RowBox[{
             RowBox[{"cd", "[", 
              RowBox[{"-", "a"}], "]"}], "[", 
             RowBox[{
              RowBox[{"cd", "[", 
               RowBox[{"-", "b"}], "]"}], "[", "expr", "]"}], "]"}]}], "]"}], 
          "]"}], ",", 
         RowBox[{"IndicesOf", "[", "Free", "]"}]}], "]"}], ",", 
       RowBox[{"IndicesOf", "[", "Free", "]"}]}], "]"}], "//", 
     "TraceBasisDummy"}], "//", "ToValues"}], "//", 
   "Simplify"}]}]], \
"Input",ExpressionUUID->"66d4516a-636c-4d1a-8189-c97fe07139f3"],

Cell["Definition:", \
"Text",ExpressionUUID->"e4ca782f-6d39-42bc-bd23-371a40bfcfb2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PureOrbital", "[", 
    RowBox[{"j_", ",", "l_", ",", "m_"}], "]"}], "[", "inds__", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"{", "inds", "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ClebschGordan", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"l", ",", 
           RowBox[{"m", "-", "mp"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "mp"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "m"}], "}"}]}], "]"}], 
       RowBox[{"SphericalHarmonicY", "[", 
        RowBox[{"l", ",", 
         RowBox[{"m", "-", "mp"}], ",", 
         RowBox[{"\[Theta]", "[", "]"}], ",", 
         RowBox[{"\[Phi]", "[", "]"}]}], "]"}], 
       RowBox[{"Orbitalt", "[", 
        RowBox[{
         RowBox[{"LI", "[", "mp", "]"}], ",", "inds"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"mp", ",", 
        RowBox[{"-", "s"}], ",", "s"}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"1239dcf3-1b37-48c4-adeb-9f3e62a72c17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PureOrbital", "[", 
     RowBox[{"4", ",", "3", ",", 
      RowBox[{"-", "2"}]}], "]"}], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "cartesian"}]}], "}"}]}], "]"}], "//", "ToValues"}], "//",
   "Simplify"}]], \
"Input",ExpressionUUID->"1d322ba1-f37b-4c51-b970-80808627afca"],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "3"}], " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Phi]", "", ""],
             AutoSpacing->False],
            \[Phi][],
            Editable->False]}]]}]}], ")"}], " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"2", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}]}], ")"}], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}]}], 
  RowBox[{"8", " ", 
   SqrtBox[
    RowBox[{
    "22", " ", 
     "\[Pi]"}]]}]]], \
"Output",ExpressionUUID->"492aacf9-dc2d-42bf-b4c5-0cb20f1ea1d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LaplacianOnScalars", "[", "%", "]"}], "/", "%"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"5d537d81-3bda-4845-a244-1e71858f76f8"],

Cell[BoxData[
 RowBox[{"-", 
  "12"}]], "Output",ExpressionUUID->"d20cdfa7-e0b7-4c13-97c0-20227aa59527"]
}, Open  ]],

Cell["We have these two orbital harmonics:", \
"Text",ExpressionUUID->"414bcdf9-0a11-40b6-9c13-91067acf0f7b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"O1", "=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j", "=", "4"}], ",", 
      RowBox[{"m", "=", 
       RowBox[{"-", "2"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"j", 
          RowBox[{"(", 
           RowBox[{"j", "+", "1"}], ")"}]}], "]"}], 
        RowBox[{"Sqrt", "[", 
         RowBox[{"j", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "j"}], "+", "1"}], ")"}]}], "]"}], 
        RowBox[{
         RowBox[{"PureOrbital", "[", 
          RowBox[{"j", ",", 
           RowBox[{"j", "+", "1"}], ",", "m"}], "]"}], "[", "c", "]"}], 
        RowBox[{"identity", "[", 
         RowBox[{"d", ",", 
          RowBox[{"-", "c"}]}], "]"}]}], "//", "ContractBasis"}], "//", 
      "ToValues"}], "//", "Simplify"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"389cc0f2-f9d2-41c4-921c-72e6ad87c918"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "48"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"8", " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{"20", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["1",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{1, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], "+", 
    RowBox[{"4", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{2, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"5afd1cd5-cd64-4522-948f-cfb108321297"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"O2", "=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j", "=", "4"}], ",", 
      RowBox[{"m", "=", 
       RowBox[{"-", "2"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"j", 
          RowBox[{"(", 
           RowBox[{"j", "+", "1"}], ")"}]}], "]"}], 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"j", "+", "1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "j"}], "+", "1"}], ")"}]}], "]"}], 
        RowBox[{
         RowBox[{"PureOrbital", "[", 
          RowBox[{"j", ",", 
           RowBox[{"j", "-", "1"}], ",", "m"}], "]"}], "[", "c", "]"}], 
        RowBox[{"identity", "[", 
         RowBox[{"d", ",", 
          RowBox[{"-", "c"}]}], "]"}]}], "//", "ContractBasis"}], "//", 
      "ToValues"}], "//", "Simplify"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"89e134ce-8c46-4809-945b-d3acae5dc289"],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "24"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["e", 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], " "}], 
           RowBox[{" ", "d"}]],
          AutoSpacing->False],
         Basis[{2, -spherical}, d],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False], "]"}]}], "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["e", 
           RowBox[{
            StyleBox["1",
             FontColor->RGBColor[1, 0, 0]], " "}], 
           RowBox[{" ", "d"}]],
          AutoSpacing->False],
         Basis[{1, -spherical}, d],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False], "]"}]}], "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"ca5b0d05-ef9f-4a13-824d-ba0e7ce00be0"]
}, Open  ]],

Cell["\<\
which add up to a spin harmonic (note that the radial part cancels)\
\>", "Text",ExpressionUUID->"ec9dbd9a-2f2b-42d3-8347-8fdc8e0f65d2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newZ", "=", 
  RowBox[{
   RowBox[{"O1", "+", "O2"}], "//", 
   "Simplify"}]}]], \
"Input",ExpressionUUID->"3c8c6d11-3838-47ec-9712-18429d76fc7e"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "16"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{2, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"c5290d56-60c1-4a2b-b79c-ba078640ae7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"newZ", "-", 
     RowBox[{
      RowBox[{"Z", "[", 
       RowBox[{
        RowBox[{"LI", "[", "4", "]"}], ",", 
        RowBox[{"LI", "[", 
         RowBox[{"-", "2"}], "]"}], ",", "c"}], "]"}], 
      RowBox[{"identity", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "c"}]}], "]"}]}]}], "//", "ContractBasis"}], "//", 
   "HarmonicComponent"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"0a955f84-b77d-45a0-b09d-5935e20249a8"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"376e0b0a-c18d-46b9-bf18-0c46ef1a0b03"]
}, Open  ]],

Cell["which has the correct geometric Laplacian:", \
"Text",ExpressionUUID->"dcbdcee6-79ff-4c88-b803-8cff9a1c9a5b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"gamma", "[", 
    RowBox[{"a", ",", "b"}], "]"}], 
   RowBox[{
    RowBox[{"cd", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "b"}], "]"}], "@", 
     RowBox[{"Z", "[", 
      RowBox[{
       RowBox[{"LI", "[", "4", "]"}], ",", 
       RowBox[{"LI", "[", 
        RowBox[{"-", "2"}], "]"}], ",", "c"}], "]"}]}]}]}], "//", 
  "ContractMetric"}]], \
"Input",ExpressionUUID->"e3bda0ce-bf97-4a73-b133-7b1b08051bab"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "19"}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", "   ", 
     RowBox[{"4", "-", 
      RowBox[{"2", "c"}]}]],
    AutoSpacing->False],
   Z[
    LI[4], 
    LI[-2], c],
   Editable->
    False]}]], "Output",ExpressionUUID->"c19b69c8-fc25-4510-ab96-0acbb891dc2b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"gamma", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{
     RowBox[{"cd", "[", 
      RowBox[{"-", "a"}], "]"}], "@", 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "b"}], "]"}], "@", 
      RowBox[{"Z", "[", 
       RowBox[{
        RowBox[{"LI", "[", "l", "]"}], ",", 
        RowBox[{"LI", "[", "m", "]"}], ",", "c"}], "]"}]}]}]}], "//", 
   "ContractMetric"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"b347a44b-c36c-4ebe-8545-16d096cc4cd5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["l",
       AutoSpacing->False],
      l,
      Editable->False], "+", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False], "2"]}], ")"}]}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", "   ", "lmc"],
    AutoSpacing->False],
   Z[
    LI[l], 
    LI[m], c],
   Editable->
    False]}]], "Output",ExpressionUUID->"e84639e8-7fb1-458a-ac1b-1889b7cddb7d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"gamma", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "a"}], "]"}], "@", 
      RowBox[{
       RowBox[{"cd", "[", 
        RowBox[{"-", "b"}], "]"}], "@", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}], ",", "c", ",", "d"}], "]"}]}]}]}], "//",
     "ContractMetric"}], "//", "Simplification"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"ce676788-a68d-4a05-a212-67f0f2657c94"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     InterpretationBox[
      StyleBox["l",
       AutoSpacing->False],
      l,
      Editable->False], "+", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False], "2"]}], ")"}]}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", "    ", "lmcd"],
    AutoSpacing->False],
   Z[
    LI[l], 
    LI[m], c, d],
   Editable->
    False]}]], "Output",ExpressionUUID->"7592e39e-6144-4197-993d-22cb155ec73d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"gamma", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "a"}], "]"}], "@", 
      RowBox[{
       RowBox[{"cd", "[", 
        RowBox[{"-", "b"}], "]"}], "@", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}], ",", "c", ",", "d", ",", "e"}], 
        "]"}]}]}]}], "//", "ContractMetric"}], "//", "Simplification"}], "//",
   "Simplify"}]], \
"Input",ExpressionUUID->"b7e04132-6b8e-4c38-abee-8325621f4790"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "9"}], "+", 
     InterpretationBox[
      StyleBox["l",
       AutoSpacing->False],
      l,
      Editable->False], "+", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False], "2"]}], ")"}]}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", "     ", "lmcde"],
    AutoSpacing->False],
   Z[
    LI[l], 
    LI[m], c, d, e],
   Editable->
    False]}]], "Output",ExpressionUUID->"66f04c2f-d691-469e-a032-bbae4f0f6f73"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"gamma", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{
      RowBox[{"cd", "[", 
       RowBox[{"-", "a"}], "]"}], "@", 
      RowBox[{
       RowBox[{"cd", "[", 
        RowBox[{"-", "b"}], "]"}], "@", 
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l", "]"}], ",", 
         RowBox[{"LI", "[", "m", "]"}], ",", "c", ",", "d", ",", "e", ",", 
         "f"}], "]"}]}]}]}], "//", "ContractMetric"}], "//", 
   "Simplification"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"5c7e1ce6-caaf-4098-9a22-f035768ea8dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "16"}], "+", 
     InterpretationBox[
      StyleBox["l",
       AutoSpacing->False],
      l,
      Editable->False], "+", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False], "2"]}], ")"}]}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", "      ", "lmcdef"],
    AutoSpacing->False],
   Z[
    LI[l], 
    LI[m], c, d, e, f],
   Editable->
    False]}]], "Output",ExpressionUUID->"eebf788d-35a1-48ee-aa78-bddbf80fd550"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", "newZ", 
  "]"}]], "Input",ExpressionUUID->"45f9207c-eb3a-4734-8fec-6b4a1c817393"],

Cell[BoxData[
 RowBox[{
  FractionBox["57", "16"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{2, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"9bc70317-2c93-49f8-a2b0-7238eba20956"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "+", 
   RowBox[{"19", " ", "newZ"}]}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"65ffc394-4b93-47ee-8a0d-95d34a35ca1c"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"f0a1b46d-35ae-41c6-a4d2-5836b7cf5c0c"]
}, Open  ]],

Cell["Let us study the tangential part:", \
"Text",ExpressionUUID->"98bfd8a0-cc69-4aee-8300-5c607bc66de4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"O1tangential", "=", 
  RowBox[{
   RowBox[{"O1", "/.", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{"_", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Rule]", "0"}]}], "//",
    "Simplify"}]}]], \
"Input",ExpressionUUID->"eaa9f193-cc31-4542-8631-0a2ef53507f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "48"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"8", " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{"20", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["1",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{1, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], "+", 
    RowBox[{"4", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{2, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"6e2c4ead-0feb-4f3d-8f7a-3ff8177a9f29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"O2tangential", "=", 
  RowBox[{
   RowBox[{"O2", "/.", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{"_", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "\[Rule]", "0"}]}], "//",
    "Simplify"}]}]], \
"Input",ExpressionUUID->"1a4cdafd-fcad-4936-9c87-e05a63a5c162"],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "24"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["e", 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], " "}], 
           RowBox[{" ", "d"}]],
          AutoSpacing->False],
         Basis[{2, -spherical}, d],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False], "]"}]}], "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["e", 
           RowBox[{
            StyleBox["1",
             FontColor->RGBColor[1, 0, 0]], " "}], 
           RowBox[{" ", "d"}]],
          AutoSpacing->False],
         Basis[{1, -spherical}, d],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False], "]"}]}], "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"f25a0571-33ad-4214-82c4-b10646e163bc"]
}, Open  ]],

Cell["\<\
The following expressions have changed and now are far more complicated. In \
particular the sums should yield zero. It must be related to the issue of \
whether the cnumbers of the bases are {1,2,3} or {2,3}. Removing the \
Christoffel terms containing a component 1 and removing the result in the \
direction 1 we get zero again:\
\>", "Text",ExpressionUUID->"4070d3c3-32cf-4dc0-8a92-a1d0eccf149d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", "O1tangential", 
  "]"}]], "Input",ExpressionUUID->"f12e35d6-d894-4cdd-b7b3-8625c1c64ce4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "48"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Csc",
     AutoSpacing->False],
    Csc,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{2, -spherical}, d],
      Editable->False], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "80"}], " ", "\[ImaginaryI]", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "-", 
       RowBox[{"152", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"50", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["3",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"532", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"35", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["3",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"15", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"2", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}], "+", 
          RowBox[{"21", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"15", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"2", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{2, -spherical}][
          
          ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
           1, -spherical}]],
         Editable->False]}], "+", 
       RowBox[{"20", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"2", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{2, -spherical}][
          
          ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
           1, -spherical}]],
         Editable->False]}], "-", 
       RowBox[{"35", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"2", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{2, -spherical}][
          
          ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
           1, -spherical}]],
         Editable->False]}], "+", 
       RowBox[{"100", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"3", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["3",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{3, -spherical}][
          
          ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
           1, -spherical}]],
         Editable->False]}], "+", 
       RowBox[{"140", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"3", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["3",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{3, -spherical}][
          
          ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
           1, -spherical}]],
         Editable->False]}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"17", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False], "]"}]}], "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "40"}], " ", "\[ImaginaryI]", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"3", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"5", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"2", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{"35", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"4", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "38"}], " ", "\[ImaginaryI]"}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False], "]"}], "2"], " ", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox[
                 RowBox[{"\[CapitalGamma]", "[", 
                  RowBox[{"D", ",", 
                   StyleBox["\[ScriptCapitalD]",
                    FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                 RowBox[{" ", 
                  RowBox[{
                   StyleBox[
                    RowBox[{"2", "1"}],
                    FontColor->RGBColor[1, 0, 0]], ":", 
                   StyleBox["2",
                    FontColor->RGBColor[1, 0, 0]]}]}], 
                 RowBox[{
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]], "    "}]],
                AutoSpacing->False],
               cd[{2, -spherical}][
                
                ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
                 1, -spherical}]],
               Editable->False]}], "+", 
             RowBox[{"5", " ", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox[
                 RowBox[{"\[CapitalGamma]", "[", 
                  RowBox[{"D", ",", 
                   StyleBox["\[ScriptCapitalD]",
                    FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                 RowBox[{" ", 
                  RowBox[{
                   StyleBox[
                    RowBox[{"3", "1"}],
                    FontColor->RGBColor[1, 0, 0]], ":", 
                   StyleBox["3",
                    FontColor->RGBColor[1, 0, 0]]}]}], 
                 RowBox[{
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]], "    "}]],
                AutoSpacing->False],
               cd[{3, -spherical}][
                
                ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
                 1, -spherical}]],
               Editable->False]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"10375cf3-8656-4d48-9946-9b898612cf71"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "+", 
   RowBox[{"19", " ", "O1tangential"}]}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"59072f4c-a509-4fff-a022-5ff6e46c330e"],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "96"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Csc",
     AutoSpacing->False],
    Csc,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "152"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["1",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{1, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "3"]}], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{2, -spherical}, d],
      Editable->False], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", "\[ImaginaryI]", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"2", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}], "-", 
          RowBox[{"63", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"3", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False], "]"}], "2"], " ", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox[
                 RowBox[{"\[CapitalGamma]", "[", 
                  RowBox[{"D", ",", 
                   StyleBox["\[ScriptCapitalD]",
                    FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                 RowBox[{" ", 
                  RowBox[{
                   StyleBox[
                    RowBox[{"2", "1"}],
                    FontColor->RGBColor[1, 0, 0]], ":", 
                   StyleBox["2",
                    FontColor->RGBColor[1, 0, 0]]}]}], 
                 RowBox[{
                  StyleBox["2",
                   FontColor->RGBColor[1, 0, 0]], "    "}]],
                AutoSpacing->False],
               cd[{2, -spherical}][
                
                ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
                 1, -spherical}]],
               Editable->False]}], "+", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox[
                RowBox[{"\[CapitalGamma]", "[", 
                 RowBox[{"D", ",", 
                  StyleBox["\[ScriptCapitalD]",
                   FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                RowBox[{" ", 
                 RowBox[{
                  StyleBox[
                   RowBox[{"3", "1"}],
                   FontColor->RGBColor[1, 0, 0]], ":", 
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]]}]}], 
                RowBox[{
                 StyleBox["2",
                  FontColor->RGBColor[1, 0, 0]], "    "}]],
               AutoSpacing->False],
              cd[{3, -spherical}][
               
               ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
                1, -spherical}]],
              Editable->False]}], ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"17", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False], "]"}]}], "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", "\[ImaginaryI]", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"3", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"2", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{"70", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"4", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False], "]"}], "2"], " ", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox[
                 RowBox[{"\[CapitalGamma]", "[", 
                  RowBox[{"D", ",", 
                   StyleBox["\[ScriptCapitalD]",
                    FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                 RowBox[{" ", 
                  RowBox[{
                   StyleBox[
                    RowBox[{"2", "1"}],
                    FontColor->RGBColor[1, 0, 0]], ":", 
                   StyleBox["2",
                    FontColor->RGBColor[1, 0, 0]]}]}], 
                 RowBox[{
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]], "    "}]],
                AutoSpacing->False],
               cd[{2, -spherical}][
                
                ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
                 1, -spherical}]],
               Editable->False]}], "+", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox[
                RowBox[{"\[CapitalGamma]", "[", 
                 RowBox[{"D", ",", 
                  StyleBox["\[ScriptCapitalD]",
                   FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                RowBox[{" ", 
                 RowBox[{
                  StyleBox[
                   RowBox[{"3", "1"}],
                   FontColor->RGBColor[1, 0, 0]], ":", 
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]]}]}], 
                RowBox[{
                 StyleBox["3",
                  FontColor->RGBColor[1, 0, 0]], "    "}]],
               AutoSpacing->False],
              cd[{3, -spherical}][
               
               ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
                1, -spherical}]],
              Editable->False]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"560d39ba-024f-4494-9cc3-0d7d5b2f4596"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"ChristoffelcdPDspherical", "[", 
    RowBox[{"___", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "_"}], "}"}], ",", "___"}], "]"}], "\[Rule]", 
   "0"}]}]], "Input",ExpressionUUID->"ae0b16a5-eb33-4569-956a-99cc9ee2d45a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["95", "12"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["1",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "d"}]],
    AutoSpacing->False],
   Basis[{1, -spherical}, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", 
    RowBox[{"7", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], 
   "2"]}]], "Output",ExpressionUUID->"69d2c73d-ff19-44da-b8bc-a075bbf78340"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", "O2tangential", 
  "]"}]], "Input",ExpressionUUID->"c9d9a269-2559-4d40-9cbb-0c8fecb053c3"],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "48"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Csc",
     AutoSpacing->False],
    Csc,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{2, -spherical}, d],
      Editable->False], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", "\[ImaginaryI]", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"38", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"10", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["3",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"133", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"7", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["3",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"2", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "6"}], " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}], "+", 
          RowBox[{"63", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"3", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"2", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{2, -spherical}][
          ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
           1, -spherical}]],
         Editable->False]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"2", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{2, -spherical}][
          
          ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
           1, -spherical}]],
         Editable->False]}], "-", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"2", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{2, -spherical}][
          
          ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
           1, -spherical}]],
         Editable->False]}], "+", 
       RowBox[{"20", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"3", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["3",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{3, -spherical}][
          
          ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
           1, -spherical}]],
         Editable->False]}], "+", 
       RowBox[{"28", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            RowBox[{
             StyleBox[
              RowBox[{"3", "1"}],
              FontColor->RGBColor[1, 0, 0]], ":", 
             StyleBox["3",
              FontColor->RGBColor[1, 0, 0]]}]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "    "}]],
          AutoSpacing->False],
         cd[{3, -spherical}][
          
          ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
           1, -spherical}]],
         Editable->False]}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"17", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False], "]"}]}], "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", "\[ImaginaryI]", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"3", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"2", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{"35", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"4", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"5", "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"19", " ", "\[ImaginaryI]"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False], "]"}], "2"], " ", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox[
                 RowBox[{"\[CapitalGamma]", "[", 
                  RowBox[{"D", ",", 
                   StyleBox["\[ScriptCapitalD]",
                    FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                 RowBox[{" ", 
                  RowBox[{
                   StyleBox[
                    RowBox[{"2", "1"}],
                    FontColor->RGBColor[1, 0, 0]], ":", 
                   StyleBox["2",
                    FontColor->RGBColor[1, 0, 0]]}]}], 
                 RowBox[{
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]], "    "}]],
                AutoSpacing->False],
               cd[{2, -spherical}][
                
                ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
                 1, -spherical}]],
               Editable->False]}], "+", 
             RowBox[{"2", " ", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox[
                 RowBox[{"\[CapitalGamma]", "[", 
                  RowBox[{"D", ",", 
                   StyleBox["\[ScriptCapitalD]",
                    FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                 RowBox[{" ", 
                  RowBox[{
                   StyleBox[
                    RowBox[{"3", "1"}],
                    FontColor->RGBColor[1, 0, 0]], ":", 
                   StyleBox["3",
                    FontColor->RGBColor[1, 0, 0]]}]}], 
                 RowBox[{
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]], "    "}]],
                AutoSpacing->False],
               cd[{3, -spherical}][
                
                ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
                 1, -spherical}]],
               Editable->False]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"ac8f1f75-5506-48db-ae5d-9b201fcf0f63"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "+", 
   RowBox[{"19", " ", "O2tangential"}]}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"3ae50b42-fff1-47b2-8a1f-06bd91064edd"],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "96"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  RowBox[{
   InterpretationBox[
    StyleBox["Csc",
     AutoSpacing->False],
    Csc,
    Editable->False], "[", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Theta]", "", ""],
     AutoSpacing->False],
    \[Theta][],
    Editable->False], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"152", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["1",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{1, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "3"]}], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["2",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{2, -spherical}, d],
      Editable->False], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", "\[ImaginaryI]", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"2", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "6"}], " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}], "+", 
          RowBox[{"63", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"3", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Sin",
              AutoSpacing->False],
             Sin,
             Editable->False], "[", 
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False], "]"}], "2"], " ", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox[
                 RowBox[{"\[CapitalGamma]", "[", 
                  RowBox[{"D", ",", 
                   StyleBox["\[ScriptCapitalD]",
                    FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                 RowBox[{" ", 
                  RowBox[{
                   StyleBox[
                    RowBox[{"2", "1"}],
                    FontColor->RGBColor[1, 0, 0]], ":", 
                   StyleBox["2",
                    FontColor->RGBColor[1, 0, 0]]}]}], 
                 RowBox[{
                  StyleBox["2",
                   FontColor->RGBColor[1, 0, 0]], "    "}]],
                AutoSpacing->False],
               cd[{2, -spherical}][
                
                ChristoffelcdPDspherical[{2, spherical}, {2, -spherical}, {
                 1, -spherical}]],
               Editable->False]}], "+", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox[
                RowBox[{"\[CapitalGamma]", "[", 
                 RowBox[{"D", ",", 
                  StyleBox["\[ScriptCapitalD]",
                   FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                RowBox[{" ", 
                 RowBox[{
                  StyleBox[
                   RowBox[{"3", "1"}],
                   FontColor->RGBColor[1, 0, 0]], ":", 
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]]}]}], 
                RowBox[{
                 StyleBox["2",
                  FontColor->RGBColor[1, 0, 0]], "    "}]],
               AutoSpacing->False],
              cd[{3, -spherical}][
               
               ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
                1, -spherical}]],
              Editable->False]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["e", 
        RowBox[{
         StyleBox["3",
          FontColor->RGBColor[1, 0, 0]], " "}], 
        RowBox[{" ", "d"}]],
       AutoSpacing->False],
      Basis[{3, -spherical}, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"D", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1, 0, 0]]}], "]"}], 
           RowBox[{" ", 
            StyleBox[
             RowBox[{"3", "1"}],
             FontColor->RGBColor[1, 0, 0]]}], 
           RowBox[{
            StyleBox["2",
             FontColor->RGBColor[1, 0, 0]], "  "}]],
          AutoSpacing->False],
         ChristoffelcdPDspherical[{2, spherical}, {3, -spherical}, {
          1, -spherical}],
         Editable->False], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"17", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False], "]"}]}], "+", 
          RowBox[{"7", " ", 
           RowBox[{
            InterpretationBox[
             StyleBox["Cos",
              AutoSpacing->False],
             Cos,
             Editable->False], "[", 
            RowBox[{"3", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", "\[ImaginaryI]", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"3", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox[
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"D", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1, 0, 0]]}], "]"}], 
              RowBox[{" ", 
               StyleBox[
                RowBox[{"2", "1"}],
                FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{
               StyleBox["3",
                FontColor->RGBColor[1, 0, 0]], "  "}]],
             AutoSpacing->False],
            
            ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
             1, -spherical}],
            Editable->False], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}], "+", 
             RowBox[{"70", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Sin",
                 AutoSpacing->False],
                Sin,
                Editable->False], "[", 
               RowBox[{"4", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", 
             RowBox[{"7", " ", 
              RowBox[{
               InterpretationBox[
                StyleBox["Cos",
                 AutoSpacing->False],
                Cos,
                Editable->False], "[", 
               RowBox[{"2", " ", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False]}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox[
               RowBox[{
                InterpretationBox[
                 StyleBox["Sin",
                  AutoSpacing->False],
                 Sin,
                 Editable->False], "[", 
                InterpretationBox[
                 StyleBox[
                  SubsuperscriptBox["\[Theta]", "", ""],
                  AutoSpacing->False],
                 \[Theta][],
                 Editable->False], "]"}], "2"], " ", 
              InterpretationBox[
               StyleBox[
                SubsuperscriptBox[
                 RowBox[{"\[CapitalGamma]", "[", 
                  RowBox[{"D", ",", 
                   StyleBox["\[ScriptCapitalD]",
                    FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                 RowBox[{" ", 
                  RowBox[{
                   StyleBox[
                    RowBox[{"2", "1"}],
                    FontColor->RGBColor[1, 0, 0]], ":", 
                   StyleBox["2",
                    FontColor->RGBColor[1, 0, 0]]}]}], 
                 RowBox[{
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]], "    "}]],
                AutoSpacing->False],
               cd[{2, -spherical}][
                
                ChristoffelcdPDspherical[{3, spherical}, {2, -spherical}, {
                 1, -spherical}]],
               Editable->False]}], "+", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox[
                RowBox[{"\[CapitalGamma]", "[", 
                 RowBox[{"D", ",", 
                  StyleBox["\[ScriptCapitalD]",
                   FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                RowBox[{" ", 
                 RowBox[{
                  StyleBox[
                   RowBox[{"3", "1"}],
                   FontColor->RGBColor[1, 0, 0]], ":", 
                  StyleBox["3",
                   FontColor->RGBColor[1, 0, 0]]}]}], 
                RowBox[{
                 StyleBox["3",
                  FontColor->RGBColor[1, 0, 0]], "    "}]],
               AutoSpacing->False],
              cd[{3, -spherical}][
               
               ChristoffelcdPDspherical[{3, spherical}, {3, -spherical}, {
                1, -spherical}]],
              Editable->False]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"34dc192a-217a-4856-9f35-aa42faab25fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"ChristoffelcdPDspherical", "[", 
    RowBox[{"___", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "_"}], "}"}], ",", "___"}], "]"}], "\[Rule]", 
   "0"}]}]], "Input",ExpressionUUID->"7ddbded5-c0a7-4ae8-88b4-5c33c1298db9"],

Cell[BoxData[
 RowBox[{
  FractionBox["95", "12"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Phi]", "", ""],
      AutoSpacing->False],
     \[Phi][],
     Editable->False]}]], " ", 
  SqrtBox[
   FractionBox["5", 
    RowBox[{"2", " ", "\[Pi]"}]]], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["e", 
     RowBox[{
      StyleBox["1",
       FontColor->RGBColor[1, 0, 0]], " "}], 
     RowBox[{" ", "d"}]],
    AutoSpacing->False],
   Basis[{1, -spherical}, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", 
    RowBox[{"7", " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{
    InterpretationBox[
     StyleBox["Sin",
      AutoSpacing->False],
     Sin,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], 
   "2"]}]], "Output",ExpressionUUID->"d48f367a-a66f-4b1a-9fe7-39887cecd7fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"l", 
    RowBox[{"(", 
     RowBox[{"l", "+", "1"}], ")"}]}], "-", 
   RowBox[{"s", "^", "2"}]}], 
  "]"}]], "Input",ExpressionUUID->"b58cedbf-8ece-4974-93e8-7218f8acde3a"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox["l",
    AutoSpacing->False],
   l,
   Editable->False], "+", 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["l",
     AutoSpacing->False],
    l,
    Editable->False], "2"], "-", 
  SuperscriptBox["s", 
   "2"]}]], "Output",ExpressionUUID->"a5a20309-adde-4876-b110-2f033b6e5108"]
}, Open  ]],

Cell["Now we study the Laplacian acting on the scalar components:", \
"Text",ExpressionUUID->"06a9426e-298a-46d3-9b53-b8278d1dfeb7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"basis", "[", "spherical", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "spherical"}], "}"}]}], "]"}], ",", " ", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "spherical"}], "}"}]}], "]"}], ",", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "spherical"}], "}"}]}], "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"basis", "[", "cartesian", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "cartesian"}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "cartesian"}], "}"}]}], "]"}], ",", 
    RowBox[{"Basis", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "cartesian"}], "}"}]}], "]"}]}], 
   "}"}]}]}], "Input",ExpressionUUID->"f7333210-520d-47dc-9791-401159cdc21f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"O1", " ", 
    RowBox[{"basis", "[", "spherical", "]"}]}], "//", "ContractBasis"}], "//",
   "Simplify"}]], \
"Input",ExpressionUUID->"bfcda7cd-b7a9-4258-b1a0-238dc912cec2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["5", "12"]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "2"]}], ",", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}], "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "6"]}], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"04b6ee6f-7748-46f2-9082-d43d297a3ae7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LaplacianOnScalars", "[", "%", "]"}], "/", "%"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"b89452e1-cac2-4c46-bb76-cd9bbacbc014"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "20"}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"34", "-", 
       RowBox[{"87", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"35", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Csc",
         AutoSpacing->False],
        Csc,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"7", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"2", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}]}]], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "11"}], "-", 
       RowBox[{"28", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Csc",
         AutoSpacing->False],
        Csc,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}]]}], 
  "}"}]], "Output",ExpressionUUID->"660ffea2-595b-44ef-a5f4-94a614fa92ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"O2", " ", 
    RowBox[{"basis", "[", "spherical", "]"}]}], "//", "ContractBasis"}], "//",
   "Simplify"}]], \
"Input",ExpressionUUID->"d4538ea2-a6f9-47fe-abb9-037ff53cfafc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["5", "12"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "2"]}], ",", 
   RowBox[{
    FractionBox["5", "24"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"3", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["5", "24"]}], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"7cf3d8a1-3edd-4447-937e-1ff4c59978a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LaplacianOnScalars", "[", "%", "]"}], "/", "%"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"a6bd8292-c85a-402a-9131-571e7849c93e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "20"}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"34", "-", 
       RowBox[{"87", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"35", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Csc",
         AutoSpacing->False],
        Csc,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"7", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"2", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}]}]], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "11"}], "-", 
       RowBox[{"28", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Csc",
         AutoSpacing->False],
        Csc,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}]]}], 
  "}"}]], "Output",ExpressionUUID->"042a25a6-898f-44c6-a38e-d2ba5ec49c92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"newZ", " ", 
    RowBox[{"basis", "[", "spherical", "]"}]}], "//", "ContractBasis"}], "//",
   "Simplify"}]], \
"Input",ExpressionUUID->"ed6d23e0-caa9-4179-b755-1ff4edb835ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    FractionBox["3", "16"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}], "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        RowBox[{"4", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "8"]}], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"8969701d-2f8c-4497-8fcf-8053ffc8fa44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LaplacianOnScalars", "[", "%", "]"}], "/", "%"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"4a5f6353-bb46-48b7-9f2c-4e6feef84312"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox["Power",
     AutoSpacing->False],
    Power,
    Editable->False], "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Power::infy\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"e56832fe-b9e1-4498-8656-ba055b7e551d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::indet\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"7b2b6a5b-7024-47cd-a5f8-e46088d65bdf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Indeterminate", ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"34", "-", 
       RowBox[{"87", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"35", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Csc",
         AutoSpacing->False],
        Csc,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"7", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"2", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}]}]], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "11"}], "-", 
       RowBox[{"28", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"4", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Csc",
         AutoSpacing->False],
        Csc,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{"2", " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Theta]", "", ""],
            AutoSpacing->False],
           \[Theta][],
           Editable->False]}], "]"}]}]}], ")"}]}]]}], 
  "}"}]], "Output",ExpressionUUID->"06b4fc87-b837-4577-bf45-e600cd86d7b0"]
}, Open  ]],

Cell["Cartesian components:", \
"Text",ExpressionUUID->"4bf0e39b-bddf-4e78-8488-291c33818fa3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"O1", " ", 
     RowBox[{"basis", "[", "cartesian", "]"}]}], "//", "ContractBasis"}], "//",
    "ToValues"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"c1f75be4-1305-4c47-bb19-d7f9ac52e59f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "96"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "18"}], " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}], "-", 
         RowBox[{"35", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"3", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"63", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"5", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{"8", " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}], "+", 
         RowBox[{"7", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"3", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "96"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}], "+", 
         RowBox[{"7", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"3", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "18"}], " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}], "-", 
         RowBox[{"35", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"3", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"63", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"5", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["7", "8"]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"3", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "2"]}]}], 
  "}"}]], "Output",ExpressionUUID->"e7459ba2-5cad-4868-a5cc-d54ec0b67d2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LaplacianOnScalars", "[", "%", "]"}], "/", "%"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"bf7d6e1a-1357-4991-b87c-afc26aed20f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "30"}], ",", 
   RowBox[{"-", "30"}], ",", 
   RowBox[{"-", "30"}]}], 
  "}"}]], "Output",ExpressionUUID->"274be51b-01d3-4d49-a45d-84dacb495133"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"O2", " ", 
     RowBox[{"basis", "[", "cartesian", "]"}]}], "//", "ContractBasis"}], "//",
    "ToValues"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"fd36eb49-26c0-4d4a-9efc-92fa011414ef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["5", "24"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"8", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         RowBox[{"7", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["5", "24"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         RowBox[{"7", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["5", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "2"]}]}], 
  "}"}]], "Output",ExpressionUUID->"1f6b93f8-89f0-4300-8525-800bda9714ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LaplacianOnScalars", "[", "%", "]"}], "/", "%"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"ae6ea6f0-a468-4ac1-b76a-06e599c8a11d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "12"}], ",", 
   RowBox[{"-", "12"}], ",", 
   RowBox[{"-", "12"}]}], 
  "}"}]], "Output",ExpressionUUID->"d78048d1-22c5-4c43-908d-7d988f0b041c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"newZ", " ", 
     RowBox[{"basis", "[", "cartesian", "]"}]}], "//", "ContractBasis"}], "//",
    "ToValues"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"f183beb1-b5ae-45a0-a2c8-a4e00493455a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "16"]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False], "]"}], "2"], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}], "-", 
         RowBox[{"7", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"3", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}], "+", 
         RowBox[{"7", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"3", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["3", "16"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False], "]"}]}], "+", 
         RowBox[{"7", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"3", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"2", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"7", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{"4", " ", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Theta]", "", ""],
              AutoSpacing->False],
             \[Theta][],
             Editable->False]}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Sin",
          AutoSpacing->False],
         Sin,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Phi]", "", ""],
          AutoSpacing->False],
         \[Phi][],
         Editable->False], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "8"]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"2", " ", "\[Pi]"}]]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"3", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{
      InterpretationBox[
       StyleBox["Sin",
        AutoSpacing->False],
       Sin,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "2"]}]}], 
  "}"}]], "Output",ExpressionUUID->"a8bec477-4844-4dc4-9903-1f0cb774b066"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LaplacianOnScalars", "[", "%", "]"}], "/", "%"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"19cab90f-3e48-4b3f-b21f-a4dbbcf6610d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"20", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "-", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"21", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "-", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"14", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Phi]", "", ""],
             AutoSpacing->False],
            \[Phi][],
            Editable->False], "]"}]}], "+", 
         RowBox[{"20", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"21", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "-", 
         RowBox[{"28", " ", "\[ImaginaryI]", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "-", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"40", " ", "\[ImaginaryI]", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Phi]", "", ""],
             AutoSpacing->False],
            \[Phi][],
            Editable->False], "]"}]}], "+", 
         RowBox[{"28", " ", "\[ImaginaryI]", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"6", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{
        FractionBox["7", "2"], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"4", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"5", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{
        FractionBox["7", "2"], " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"4", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"7", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"10", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}]}], "+", 
       RowBox[{"7", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "28"}], " ", "\[ImaginaryI]", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "-", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "-", 
         RowBox[{"40", " ", "\[ImaginaryI]", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Phi]", "", ""],
             AutoSpacing->False],
            \[Phi][],
            Editable->False], "]"}]}], "-", 
         RowBox[{"28", " ", "\[ImaginaryI]", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Cos",
             AutoSpacing->False],
            Cos,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "-", 
         RowBox[{"20", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "-", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "-", 
         RowBox[{"21", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "-", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"14", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Phi]", "", ""],
             AutoSpacing->False],
            \[Phi][],
            Editable->False], "]"}]}], "+", 
         RowBox[{"20", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"2", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}], "+", 
         RowBox[{"21", " ", 
          RowBox[{
           InterpretationBox[
            StyleBox["Sin",
             AutoSpacing->False],
            Sin,
            Editable->False], "[", 
           RowBox[{
            RowBox[{"4", " ", 
             InterpretationBox[
              StyleBox[
               SubsuperscriptBox["\[Theta]", "", ""],
               AutoSpacing->False],
              \[Theta][],
              Editable->False]}], "+", 
            InterpretationBox[
             StyleBox[
              SubsuperscriptBox["\[Phi]", "", ""],
              AutoSpacing->False],
             \[Phi][],
             Editable->False]}], "]"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "14"}], " ", "\[ImaginaryI]", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"20", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}]}], "-", 
       RowBox[{"14", " ", "\[ImaginaryI]", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Cos",
           AutoSpacing->False],
          Cos,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "-", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"4", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"10", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Phi]", "", ""],
           AutoSpacing->False],
          \[Phi][],
          Editable->False], "]"}]}], "+", 
       RowBox[{"12", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}], "+", 
       RowBox[{"7", " ", 
        RowBox[{
         InterpretationBox[
          StyleBox["Sin",
           AutoSpacing->False],
          Sin,
          Editable->False], "[", 
         RowBox[{
          RowBox[{"4", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "+", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[Phi]", "", ""],
            AutoSpacing->False],
           \[Phi][],
           Editable->False]}], "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"30", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"7", " ", 
         RowBox[{
          InterpretationBox[
           StyleBox["Cos",
            AutoSpacing->False],
           Cos,
           Editable->False], "[", 
          RowBox[{"2", " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["\[Theta]", "", ""],
             AutoSpacing->False],
            \[Theta][],
            Editable->False]}], "]"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"7", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"2", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}]}]]}]}], 
  "}"}]], "Output",ExpressionUUID->"24985b85-b1e7-48d3-a829-52262af768d6"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["5. Products of harmonics", \
"Subsection",ExpressionUUID->"b05013f4-3488-4986-8711-548ff4eef8c4"],

Cell[CellGroupData[{

Cell["Products of calDs", \
"Subsubsection",ExpressionUUID->"6a8f1f10-8f4f-4b25-847c-26297f548eec"],

Cell["This checks that the formula in the paper is correct:", \
"Text",ExpressionUUID->"4b2f17cc-d6ea-4de3-9c11-6591624519dc"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"ClebschGordan", "::", "phy"}], 
  "]"}]], "Input",ExpressionUUID->"f18831d5-0986-4042-a6a5-f1f9403ba34d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j1", "=", "4"}], ",", 
      RowBox[{"m1p", "=", "1"}], ",", 
      RowBox[{"m1", "=", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"j2", "=", "6"}], ",", 
      RowBox[{"m2p", "=", 
       RowBox[{"-", "2"}]}], ",", 
      RowBox[{"m2", "=", "4"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"calDEdmonds", "[", 
        RowBox[{"j1", ",", "m1p", ",", "m1"}], "]"}], "[", 
       RowBox[{"alpha", ",", "beta", ",", "gamma"}], "]"}], 
      RowBox[{
       RowBox[{"calDEdmonds", "[", 
        RowBox[{"j2", ",", "m2p", ",", "m2"}], "]"}], "[", 
       RowBox[{"alpha", ",", "beta", ",", "gamma"}], "]"}]}], "-", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j1", ",", "m1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j2", ",", "m2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"m1", "+", "m2"}]}], "}"}]}], "]"}], 
        RowBox[{"ClebschGordan", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j1", ",", "m1p"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j2", ",", "m2p"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"m1p", "+", "m2p"}]}], "}"}]}], "]"}], 
        RowBox[{
         RowBox[{"calDEdmonds", "[", 
          RowBox[{"j", ",", 
           RowBox[{"m1p", "+", "m2p"}], ",", 
           RowBox[{"m1", "+", "m2"}]}], "]"}], "[", 
         RowBox[{"alpha", ",", "beta", ",", "gamma"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Abs", "[", 
          RowBox[{"j1", "-", "j2"}], "]"}], ",", 
         RowBox[{"j1", "+", "j2"}]}], "}"}]}], "]"}]}]}], "]"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"d36747fb-487b-4cab-bfd8-aa5bc7966d85"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"4d665d07-2f88-444a-8664-08271048ceab"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Products of PureSpins", \
"Subsubsection",ExpressionUUID->"83cad5ba-b696-4b29-afba-34d396a6396e"],

Cell["\<\
Product coefficients. We do not want to define tensors, but need to state how \
the main functions act on them:\
\>", "Text",ExpressionUUID->"49033d61-3267-4de8-a421-8654600314d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{"coeffE", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s_", ",", "l_", ",", "m_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"sp_", ",", "lp_", ",", "mp_"}], "}"}], ",", "lpp_"}], "]"}], 
   "]"}], ":=", 
  RowBox[{"Subsuperscript", "[", 
   RowBox[{"\"\<E\>\"", ",", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"ToString", "[", "s", "]"}], ",", "\"\<,\>\"", ",", 
      RowBox[{"ToString", "[", "l", "]"}], ",", "\"\<,\>\"", ",", 
      RowBox[{"ToString", "[", "m", "]"}], ",", "\"\<;\>\"", ",", 
      RowBox[{"ToString", "[", "lpp", "]"}]}], "]"}], ",", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"ToString", "[", "sp", "]"}], ",", "\"\<,\>\"", ",", 
      RowBox[{"ToString", "[", "lp", "]"}], ",", "\"\<,\>\"", ",", 
      RowBox[{"ToString", "[", "mp", "]"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e8fbf9ba-2362-4354-9223-da5095d7ad51"],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffE", "/:", 
   RowBox[{"FindIndices", "[", 
    RowBox[{"coeffE", "[", "___", "]"}], "]"}], "=", 
   RowBox[{"IndexList", "[", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f54e201e-9bc7-45f4-ad01-3bff534a9b50"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"_", "?", "FirstDerQ"}], "[", 
    RowBox[{"coeffE", "[", "__", "]"}], "]"}], "^=", "0"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"af40a685-8a14-4bc7-a570-dd1fcd0f40dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"IsIndexOf", "[", 
    RowBox[{
     RowBox[{"coeffE", "[", "___", "]"}], ",", "__"}], "]"}], "^:=", 
   "False"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c8387d29-54c2-4b4d-a07d-a6927d533699"],

Cell["Substitution rule:", \
"Text",ExpressionUUID->"0e3fa4f7-dfe8-451a-852e-9015e0242730"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffERule", "=", 
  RowBox[{
   RowBox[{"coeffE", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s_", ",", "l_", ",", "m_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"sp_", ",", "lp_", ",", "mp_"}], "}"}], ",", "lpp_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{
    RowBox[{"coeffK", "[", 
     RowBox[{"lp", ",", 
      RowBox[{"Abs", "[", "sp", "]"}]}], "]"}], 
    RowBox[{
     RowBox[{"coeffK", "[", 
      RowBox[{"l", ",", 
       RowBox[{"Abs", "[", "s", "]"}]}], "]"}], "/", 
     RowBox[{"coeffK", "[", 
      RowBox[{"lpp", ",", 
       RowBox[{"Abs", "[", 
        RowBox[{"s", "+", "sp"}], "]"}]}], "]"}]}], 
    RowBox[{"ClebschGordan", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lp", ",", "mp"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l", ",", "m"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"lpp", ",", 
        RowBox[{"m", "+", "mp"}]}], "}"}]}], "]"}], 
    RowBox[{"ClebschGordan", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lp", ",", "sp"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l", ",", "s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"lpp", ",", 
        RowBox[{"s", "+", "sp"}]}], "}"}]}], "]"}]}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"75f33ecd-21e2-40fb-8997-55acb67392fb"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   SubsuperscriptBox["\<\"E\"\>", "\<\"s_,l_,m_;lpp_\"\>", "\<\"sp_,lp_,mp_\"\
\>"],
   Subsuperscript["E", "s_,l_,m_;lpp_", "sp_,lp_,mp_"],
   Editable->False], "\[RuleDelayed]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"coeffK", "[", 
     RowBox[{"lpp", ",", 
      RowBox[{
       InterpretationBox[
        StyleBox["Abs",
         AutoSpacing->False],
        Abs,
        Editable->False], "[", 
       RowBox[{"s", "+", "sp"}], "]"}]}], "]"}]], 
   RowBox[{
    RowBox[{"coeffK", "[", 
     RowBox[{"lp", ",", 
      RowBox[{
       InterpretationBox[
        StyleBox["Abs",
         AutoSpacing->False],
        Abs,
        Editable->False], "[", "sp", "]"}]}], "]"}], " ", 
    RowBox[{"coeffK", "[", 
     RowBox[{
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False], ",", 
      RowBox[{
       InterpretationBox[
        StyleBox["Abs",
         AutoSpacing->False],
        Abs,
        Editable->False], "[", "s", "]"}]}], "]"}], " ", 
    RowBox[{"ClebschGordan", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lp", ",", "mp"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        InterpretationBox[
         StyleBox["l",
          AutoSpacing->False],
         l,
         Editable->False], ",", "m"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"lpp", ",", 
        RowBox[{"m", "+", "mp"}]}], "}"}]}], "]"}], " ", 
    RowBox[{"ClebschGordan", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lp", ",", "sp"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        InterpretationBox[
         StyleBox["l",
          AutoSpacing->False],
         l,
         Editable->False], ",", "s"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"lpp", ",", 
        RowBox[{"s", "+", "sp"}]}], "}"}]}], 
     "]"}]}]}]}]], \
"Output",ExpressionUUID->"b49124b7-88b3-430a-9b13-3b1ccfd909ad"]
}, Open  ]],

Cell["Scalar case:", \
"Text",ExpressionUUID->"5ef02c8a-cee0-4de1-9769-f58c05cf8b2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"coeffE", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "l", ",", "m"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "lp", ",", "mp"}], "}"}], ",", "lpp"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ClebschGordan", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"l", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"lp", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"lpp", ",", "0"}], "}"}]}], "]"}], 
      RowBox[{"ClebschGordan", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"lp", ",", "mp"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"l", ",", "m"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"lpp", ",", 
          RowBox[{"m", "+", "mp"}]}], "}"}]}], "]"}]}], ")"}]}], "/.", 
   "coeffERule"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"fc5e7037-9ee7-4a7b-a80f-38843c6e8eb7"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False]}], "+", 
     RowBox[{"4", " ", "lp"}]}]], " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox["l",
        AutoSpacing->False],
       l,
       Editable->False]}]}]], " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "lp"}]}]]}], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"\[Pi]", "+", 
     RowBox[{
     "2", " ", "lpp", " ", 
      "\[Pi]"}]}]]}]]], \
"Output",ExpressionUUID->"d7d306a5-ac28-4f05-8c7d-f72b94d626aa"]
}, Open  ]],

Cell["\<\
Mathematica knows how to expand factorials near Infinity (Stirling expansion)\
\
\>", "Text",ExpressionUUID->"b750ab71-2b13-477b-a6b4-7fb0bd07d2dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Gamma", "[", 
     RowBox[{"x", "+", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "Infinity", ",", "1"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"13391d07-2b28-4080-9e8e-b469d69adb5c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"esss\"\>"}], ":", 
  " ", "\<\"Essential singularity encountered in \
\\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(\\(\\(-\\(\\(1\\/\\(1\\/x\\)\\\
)\\)\\)\\) + \\*InterpretationBox[\\(\\(O[\\(\\(1\\/x\\)\\)]\\)\\^3\\), \
SeriesData[x, DirectedInfinity[1], List[], -1, 3, 1], Rule[Editable, \
False]]\\), SeriesData[x, DirectedInfinity[1], List[-1], -1, 3, 1], \
Rule[Editable, False]]\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Series::esss\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"b25c5970-a988-48ff-85d7-d105f10bd4c5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"esss\"\>"}], ":", 
  " ", "\<\"Essential singularity encountered in \
\\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(\\(\\(-\\(\\(1\\/x\\)\\)\\)\\)\
 + \\*InterpretationBox[\\(\\(O[x]\\)\\^3\\), SeriesData[x, 0, List[], -1, 3, \
1], Rule[Editable, False]]\\), SeriesData[x, 0, List[-1], -1, 3, 1], \
Rule[Editable, False]]\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Series::esss\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"79a3bc2b-dfe0-4540-be1e-3c82ec59df30"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"esss\"\>"}], ":", 
  " ", "\<\"Essential singularity encountered in \
\\!\\(\[ExponentialE]\\^\\*InterpretationBox[\\(\\(\\(-\\(\\(1\\/\\(1\\/x\\)\\\
)\\)\\)\\) + \\*InterpretationBox[\\(\\(O[\\(\\(1\\/x\\)\\)]\\)\\^3\\), \
SeriesData[x, DirectedInfinity[1], List[], -1, 3, 1], Rule[Editable, \
False]]\\), SeriesData[x, DirectedInfinity[1], List[-1], -1, 3, 1], \
Rule[Editable, False]]\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Series::esss\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"61b8bd50-3c22-416a-b1fe-4cd43da93daf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(Series :: \\\"esss\\\"\\) will be \
suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], \
"Message",ExpressionUUID->"b941cff9-5cf6-4030-867b-c0b66c07d734"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "x"}]], " ", 
  SuperscriptBox["x", "x"], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]], 
      SqrtBox[
       FractionBox["1", "x"]]], "+", 
     InterpretationBox[
      SqrtBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}]],
      SeriesData[x, 
       DirectedInfinity[1], {}, -1, 1, 2],
      Editable->False]}],
    SeriesData[x, 
     DirectedInfinity[1], {(2 Pi)^Rational[1, 2]}, -1, 1, 2],
    Editable->False], 
   ")"}]}]], "Output",ExpressionUUID->"25d9b6d6-7d35-4064-9e70-b0604f8f703d"]
}, Open  ]],

Cell["\<\
Expansion of the prefactor of the E coefficients for large L:\
\>", "Text",ExpressionUUID->"80c316b0-6bd8-4a06-9928-f66249d2fd3e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"coeffK", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"L", "+", "Lp", "+", "lpp"}], ")"}], "/", "2"}], ",", "sp"}],
       "]"}], 
     RowBox[{"coeffK", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"L", "-", "Lp", "+", "lpp"}], ")"}], "/", "2"}], ",", "s"}], 
      "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"L", ",", "Infinity", ",", "1"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"23121a67-a207-4d9b-9752-5d83b4173b4b"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox["L", 
      RowBox[{"2", " ", "s"}]], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"3", " ", "s"}]}]], 
         FractionBox["1", "L"]], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "L"], "]"}], "0"],
         SeriesData[L, 
          DirectedInfinity[1], {}, -2, 0, 2],
         Editable->False]}],
       SeriesData[L, 
        DirectedInfinity[1], {2^(-2 - 3 s)}, -2, 0, 2],
       Editable->False], ")"}]}]], " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["L", 
      RowBox[{"2", " ", "sp"}]], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"3", " ", "sp"}]}]], 
         FractionBox["1", "L"]], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "L"], "]"}], "0"],
         SeriesData[L, 
          DirectedInfinity[1], {}, -2, 0, 2],
         Editable->False]}],
       SeriesData[L, 
        DirectedInfinity[1], {2^(-2 - 3 sp)}, -2, 0, 2],
       Editable->False], ")"}]}]]}], 
  "\[Pi]"]], "Output",ExpressionUUID->"7cc00b9b-76f1-4800-941a-f5f1f5be7e47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerExpand", "[", "%", "]"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"2a13c803-21f9-40e6-9e3c-0e5e71696ddd"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["L", 
   RowBox[{"s", "+", "sp"}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        FractionBox[
         RowBox[{"3", " ", "s"}], "2"], "-", 
        FractionBox[
         RowBox[{"3", " ", "sp"}], "2"]}]], 
      FractionBox["\[Pi]", "L"]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "L"], "]"}], "0"],
      SeriesData[L, 
       DirectedInfinity[1], {}, -2, 0, 2],
      Editable->False]}],
    SeriesData[L, 
     DirectedInfinity[1], {
     2^(-2 + Rational[-3, 2] s + Rational[-3, 2] sp)/Pi}, -2, 0, 2],
    Editable->False], 
   ")"}]}]], "Output",ExpressionUUID->"09e0e5cf-a985-408c-bf57-25adfec6798b"]
}, Open  ]],

Cell["Checks of the formulas in the paper:", \
"Text",ExpressionUUID->"67c1b6cd-d69b-482a-bbfd-e4e3b572b189"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"lp", "=", "3"}], ",", 
      RowBox[{"mp", "=", "2"}], ",", 
      RowBox[{"l", "=", "3"}], ",", 
      RowBox[{"mlabel", "=", "0"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"PureSpin", "[", 
        RowBox[{"lp", ",", "1", ",", "mp"}], "]"}], "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
      RowBox[{
       RowBox[{"PureSpin", "[", 
        RowBox[{"l", ",", "1", ",", "mlabel"}], "]"}], "[", 
       RowBox[{"d", ",", "e", ",", "f"}], "]"}]}], "-", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"coeffE", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3", ",", "lp", ",", "mp"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "l", ",", "mlabel"}], "}"}], ",", "j"}], "]"}], 
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"j", ",", "1", ",", 
           RowBox[{"mp", "+", "mlabel"}]}], "]"}], "[", 
         RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
         "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"lp", "-", "l"}], "]"}], ",", "6"}], "]"}], ",", 
         RowBox[{"lp", "+", "l"}]}], "}"}]}], "]"}]}]}], "]"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"a8eaa298-0e4e-4c9e-af22-9b5aac44749d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"45", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"7", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", "330"],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[3], 
        LI[0]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", "332"],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[3], 
        LI[2]],
       Editable->False]}], "-", 
     RowBox[{"4", " ", 
      SqrtBox[
       RowBox[{"3003", " ", "\[Pi]"}]], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", "662"],
        AutoSpacing->False],
       calD[
        LI[6], 
        LI[6], 
        LI[2]],
       Editable->False], " ", 
      InterpretationBox[
       SubsuperscriptBox["\<\"E\"\>", "\<\"3,3,2;6\"\>", "\<\"3,3,0\"\>"],
       Subsuperscript["E", "3,3,2;6", "3,3,0"],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "a"],
     AutoSpacing->False],
    m[a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "c"],
     AutoSpacing->False],
    m[c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "d"],
     AutoSpacing->False],
    m[d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "e"],
     AutoSpacing->False],
    m[e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "f"],
     AutoSpacing->False],
    m[f],
    Editable->False]}], 
  RowBox[{
  "2", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"dc43ccd2-f651-42c1-8b56-4adb71243fcc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "coeffERule"}]], \
"Input",ExpressionUUID->"45c85149-5e57-40fc-bd96-ced0d4ee20c0"],

Cell[BoxData[
 FractionBox[
  RowBox[{"45", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"7", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", "330"],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[3], 
        LI[0]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", "332"],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[3], 
        LI[2]],
       Editable->False]}], "-", 
     RowBox[{"14", " ", 
      SqrtBox[
       FractionBox["2", "33"]], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", "662"],
        AutoSpacing->False],
       calD[
        LI[6], 
        LI[6], 
        LI[2]],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "a"],
     AutoSpacing->False],
    m[a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "c"],
     AutoSpacing->False],
    m[c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "d"],
     AutoSpacing->False],
    m[d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "e"],
     AutoSpacing->False],
    m[e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "f"],
     AutoSpacing->False],
    m[f],
    Editable->False]}], 
  RowBox[{
  "2", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"be52966a-bc0f-46f6-8427-688f8fa96c68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "calDRule"}]], \
"Input",ExpressionUUID->"67e58a63-ff07-480c-9198-1e652b88ec70"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"a2261806-0bee-454a-ab6e-9257528aa90b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"lp", "=", "3"}], ",", 
      RowBox[{"mp", "=", 
       RowBox[{"-", "2"}]}], ",", 
      RowBox[{"l", "=", "3"}], ",", 
      RowBox[{"mlabel", "=", 
       RowBox[{"-", "1"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"PureSpin", "[", 
        RowBox[{"lp", ",", 
         RowBox[{"-", "1"}], ",", "mp"}], "]"}], "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
      RowBox[{
       RowBox[{"PureSpin", "[", 
        RowBox[{"l", ",", 
         RowBox[{"-", "1"}], ",", "mlabel"}], "]"}], "[", 
       RowBox[{"d", ",", "e", ",", "f"}], "]"}]}], "-", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"coeffE", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "lp", ",", "mp"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "l", ",", "mlabel"}], "}"}], ",", "j"}], 
         "]"}], 
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"j", ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"mp", "+", "mlabel"}]}], "]"}], "[", 
         RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
         "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Max", "[", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"lp", "-", "l"}], "]"}], ",", "6"}], "]"}], ",", 
         RowBox[{"lp", "+", "l"}]}], "}"}]}], "]"}]}]}], "]"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"02b81204-a73d-42dd-bfab-cb2ae5c2b4e1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"45", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"7", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"3", "-", "3", "-", "2"}]],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[-3], 
        LI[-2]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"3", "-", "3", "-", "1"}]],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[-3], 
        LI[-1]],
       Editable->False]}], "-", 
     RowBox[{"4", " ", 
      SqrtBox[
       RowBox[{"3003", " ", "\[Pi]"}]], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"6", "-", "6", "-", "3"}]],
        AutoSpacing->False],
       calD[
        LI[6], 
        LI[-6], 
        LI[-3]],
       Editable->False], " ", 
      InterpretationBox[
       SubsuperscriptBox["\<\"E\"\>", "\<\"-3,3,-2;6\"\>", "\<\"-3,3,-1\"\>"],
       
       Subsuperscript["E", "-3,3,-2;6", "-3,3,-1"],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "a"],
     AutoSpacing->False],
    mbar[a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "c"],
     AutoSpacing->False],
    mbar[c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "d"],
     AutoSpacing->False],
    mbar[d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "e"],
     AutoSpacing->False],
    mbar[e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "f"],
     AutoSpacing->False],
    mbar[f],
    Editable->False]}], 
  RowBox[{
  "2", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"a105ad22-3d9d-43be-8234-4fd8499dfa48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "coeffERule"}]], \
"Input",ExpressionUUID->"8f0ffa87-3ca9-422d-9229-f286f663bada"],

Cell[BoxData[
 FractionBox[
  RowBox[{"45", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"7", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"3", "-", "3", "-", "2"}]],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[-3], 
        LI[-2]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"3", "-", "3", "-", "1"}]],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[-3], 
        LI[-1]],
       Editable->False]}], "-", 
     FractionBox[
      RowBox[{"21", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[GothicCapitalD]", "   ", 
          RowBox[{"6", "-", "6", "-", "3"}]],
         AutoSpacing->False],
        calD[
         LI[6], 
         LI[-6], 
         LI[-3]],
        Editable->False]}], 
      SqrtBox["22"]]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "a"],
     AutoSpacing->False],
    mbar[a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "c"],
     AutoSpacing->False],
    mbar[c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "d"],
     AutoSpacing->False],
    mbar[d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "e"],
     AutoSpacing->False],
    mbar[e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "f"],
     AutoSpacing->False],
    mbar[f],
    Editable->False]}], 
  RowBox[{
  "2", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"7b17abdf-01d5-4c11-87b0-70d647bf24ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "calDRule"}]], \
"Input",ExpressionUUID->"3465c68d-7509-4efb-9817-d32c1be7a933"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"9cb1debb-1f9e-4b64-af86-782c63212bd8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lp", "=", "3"}], ",", 
        RowBox[{"mp", "=", 
         RowBox[{"-", "2"}]}], ",", 
        RowBox[{"l", "=", "5"}], ",", 
        RowBox[{"mlabel", "=", 
         RowBox[{"-", "3"}]}]}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"lp", ",", 
           RowBox[{"-", "1"}], ",", "mp"}], "]"}], "[", 
         RowBox[{"a", ",", "b"}], "]"}], 
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"l", ",", "1", ",", "mlabel"}], "]"}], "[", 
         RowBox[{"c", ",", "d", ",", "e", ",", "f"}], "]"}]}], "-", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"coeffE", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "lp", ",", "mp"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "l", ",", "mlabel"}], "}"}], ",", "j"}], "]"}], 
          RowBox[{
           RowBox[{"PureSpin", "[", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"mp", "+", "mlabel"}]}], "]"}], "[", 
           RowBox[{"e", ",", "f"}], "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"mbar", "[", "a", "]"}]}], 
            RowBox[{"m", "[", "c", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"mbar", "[", "b", "]"}]}], 
            RowBox[{"m", "[", "d", "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"lp", "-", "l"}], "]"}], ",", "0"}], "]"}], ",", 
           RowBox[{"lp", "+", "l"}]}], "}"}]}], "]"}]}]}], "]"}], "//", 
    "Expand"}], ",", 
   RowBox[{"{", 
    RowBox[{"epsilongamma", "[", "__", "]"}], "}"}], ",", "Simplify"}], 
  "]"}]], "Input",ExpressionUUID->"023c20cd-2444-4e92-8957-24ce363810df"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", "\[Pi]"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"630", " ", 
       SqrtBox["33"], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[GothicCapitalD]", "   ", 
          RowBox[{"3", "-", "2", "-", "2"}]],
         AutoSpacing->False],
        calD[
         LI[3], 
         LI[-2], 
         LI[-2]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[GothicCapitalD]", "   ", 
          RowBox[{"54", "-", "3"}]],
         AutoSpacing->False],
        calD[
         LI[5], 
         LI[4], 
         LI[-3]],
        Editable->False]}], "-", 
      RowBox[{
       SqrtBox[
        RowBox[{"5", " ", "\[Pi]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox["6"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"22", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[2], 
            LI[2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-2,3,-2;2\"\>", \
"\<\"4,5,-3\"\>"],
           Subsuperscript["E", "-2,3,-2;2", "4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{
          SqrtBox["42"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"32", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[3], 
            LI[2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-2,3,-2;3\"\>", \
"\<\"4,5,-3\"\>"],
           Subsuperscript["E", "-2,3,-2;3", "4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{"9", " ", 
          SqrtBox["2"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"42", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[4], 
            LI[2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-2,3,-2;4\"\>", \
"\<\"4,5,-3\"\>"],
           Subsuperscript["E", "-2,3,-2;4", "4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{
          SqrtBox["462"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"52", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[5], 
            LI[2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-2,3,-2;5\"\>", \
"\<\"4,5,-3\"\>"],
           Subsuperscript["E", "-2,3,-2;5", "4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["273"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"62", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[6], 
            LI[2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-2,3,-2;6\"\>", \
"\<\"4,5,-3\"\>"],
           Subsuperscript["E", "-2,3,-2;6", "4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{"18", " ", 
          SqrtBox["7"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"72", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[7], 
            LI[2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-2,3,-2;7\"\>", \
"\<\"4,5,-3\"\>"],
           Subsuperscript["E", "-2,3,-2;7", "4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["119"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"82", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[8], 
            LI[2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-2,3,-2;8\"\>", \
"\<\"4,5,-3\"\>"],
           Subsuperscript["E", "-2,3,-2;8", "4,5,-3"],
           Editable->False]}]}], ")"}]}]}], ")"}], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "c"],
      AutoSpacing->False],
     m[c],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "d"],
      AutoSpacing->False],
     m[d],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "e"],
      AutoSpacing->False],
     m[e],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "f"],
      AutoSpacing->False],
     m[f],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "a"],
      AutoSpacing->False],
     mbar[a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False]}], 
   ")"}]}]], "Output",ExpressionUUID->"ef1108bf-95a3-4a97-9069-481f75b389bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", "coeffERule"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"2d12d2be-5d74-4145-a227-e21248baa045"],

Cell[BoxData[
 FractionBox[
  RowBox[{"45", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"72", " ", 
      SqrtBox["55"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"52", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[5], 
        LI[2], 
        LI[-5]],
       Editable->False]}], "+", 
     RowBox[{"364", " ", 
      SqrtBox["33"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"3", "-", "2", "-", "2"}]],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[-2], 
        LI[-2]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"54", "-", "3"}]],
        AutoSpacing->False],
       calD[
        LI[5], 
        LI[4], 
        LI[-3]],
       Editable->False]}], "+", 
     RowBox[{"156", " ", 
      SqrtBox["10"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"62", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[6], 
        LI[2], 
        LI[-5]],
       Editable->False]}], "-", 
     RowBox[{"33", " ", 
      SqrtBox["3"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"72", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[7], 
        LI[2], 
        LI[-5]],
       Editable->False]}], "-", 
     RowBox[{"9", " ", 
      SqrtBox["195"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"82", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[8], 
        LI[2], 
        LI[-5]],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "c"],
     AutoSpacing->False],
    m[c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "d"],
     AutoSpacing->False],
    m[d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "e"],
     AutoSpacing->False],
    m[e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "f"],
     AutoSpacing->False],
    m[f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "a"],
     AutoSpacing->False],
    mbar[a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False]}], 
  RowBox[{
  "52", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"2e1e0ff2-5bf7-4c3d-90a4-b05610d74c25"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", "calDRule"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"6af73c48-6cb0-4c5f-afbe-456fa3875533"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"e8132abe-119c-4c59-ba79-0f6ce6d41cf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lp", "=", "3"}], ",", 
        RowBox[{"mp", "=", 
         RowBox[{"-", "2"}]}], ",", 
        RowBox[{"l", "=", "5"}], ",", 
        RowBox[{"mlabel", "=", 
         RowBox[{"-", "3"}]}]}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"lp", ",", "1", ",", "mp"}], "]"}], "[", 
         RowBox[{"a", ",", "b"}], "]"}], 
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"l", ",", 
           RowBox[{"-", "1"}], ",", "mlabel"}], "]"}], "[", 
         RowBox[{"c", ",", "d", ",", "e", ",", "f"}], "]"}]}], "-", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"coeffE", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "lp", ",", "mp"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "4"}], ",", "l", ",", "mlabel"}], "}"}], ",", 
            "j"}], "]"}], 
          RowBox[{
           RowBox[{"PureSpin", "[", 
            RowBox[{"j", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"mp", "+", "mlabel"}]}], "]"}], "[", 
           RowBox[{"e", ",", "f"}], "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"m", "[", "a", "]"}]}], 
            RowBox[{"mbar", "[", "c", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"m", "[", "b", "]"}]}], 
            RowBox[{"mbar", "[", "d", "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"lp", "-", "l"}], "]"}], ",", "0"}], "]"}], ",", 
           RowBox[{"lp", "+", "l"}]}], "}"}]}], "]"}]}]}], "]"}], "//", 
    "Expand"}], ",", 
   RowBox[{"{", 
    RowBox[{"epsilongamma", "[", "__", "]"}], "}"}], ",", "Simplify"}], 
  "]"}]], "Input",ExpressionUUID->"6af23535-8d27-47e8-a9f8-0c1cb547d675"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", "\[Pi]"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"630", " ", 
       SqrtBox["33"], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[GothicCapitalD]", "   ", 
          RowBox[{"32", "-", "2"}]],
         AutoSpacing->False],
        calD[
         LI[3], 
         LI[2], 
         LI[-2]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[GothicCapitalD]", "   ", 
          RowBox[{"5", "-", "4", "-", "3"}]],
         AutoSpacing->False],
        calD[
         LI[5], 
         LI[-4], 
         LI[-3]],
        Editable->False]}], "-", 
      RowBox[{
       SqrtBox[
        RowBox[{"5", " ", "\[Pi]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox["6"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"2", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[2], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"2,3,-2;2\"\>", \
"\<\"-4,5,-3\"\>"],
           Subsuperscript["E", "2,3,-2;2", "-4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{
          SqrtBox["42"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"3", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[3], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"2,3,-2;3\"\>", \
"\<\"-4,5,-3\"\>"],
           Subsuperscript["E", "2,3,-2;3", "-4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{"9", " ", 
          SqrtBox["2"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"4", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[4], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"2,3,-2;4\"\>", \
"\<\"-4,5,-3\"\>"],
           Subsuperscript["E", "2,3,-2;4", "-4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{
          SqrtBox["462"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"5", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[5], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"2,3,-2;5\"\>", \
"\<\"-4,5,-3\"\>"],
           Subsuperscript["E", "2,3,-2;5", "-4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["273"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"6", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[6], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"2,3,-2;6\"\>", \
"\<\"-4,5,-3\"\>"],
           Subsuperscript["E", "2,3,-2;6", "-4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{"18", " ", 
          SqrtBox["7"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"7", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[7], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"2,3,-2;7\"\>", \
"\<\"-4,5,-3\"\>"],
           Subsuperscript["E", "2,3,-2;7", "-4,5,-3"],
           Editable->False]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["119"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"8", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[8], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"2,3,-2;8\"\>", \
"\<\"-4,5,-3\"\>"],
           Subsuperscript["E", "2,3,-2;8", "-4,5,-3"],
           Editable->False]}]}], ")"}]}]}], ")"}], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "a"],
      AutoSpacing->False],
     m[a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "c"],
      AutoSpacing->False],
     mbar[c],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "d"],
      AutoSpacing->False],
     mbar[d],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "e"],
      AutoSpacing->False],
     mbar[e],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "f"],
      AutoSpacing->False],
     mbar[f],
     Editable->False]}], 
   ")"}]}]], "Output",ExpressionUUID->"a2b1908d-e289-498a-a558-ac5f6f3776bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", "coeffERule"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"ba788005-5c94-41e8-ab79-48495c9c2dd0"],

Cell[BoxData[
 FractionBox[
  RowBox[{"45", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"364", " ", 
      SqrtBox["33"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"32", "-", "2"}]],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[2], 
        LI[-2]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"5", "-", "4", "-", "3"}]],
        AutoSpacing->False],
       calD[
        LI[5], 
        LI[-4], 
        LI[-3]],
       Editable->False]}], "-", 
     RowBox[{"72", " ", 
      SqrtBox["55"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"5", "-", "2", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[5], 
        LI[-2], 
        LI[-5]],
       Editable->False]}], "+", 
     RowBox[{"156", " ", 
      SqrtBox["10"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"6", "-", "2", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[6], 
        LI[-2], 
        LI[-5]],
       Editable->False]}], "+", 
     RowBox[{"33", " ", 
      SqrtBox["3"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"7", "-", "2", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[7], 
        LI[-2], 
        LI[-5]],
       Editable->False]}], "-", 
     RowBox[{"9", " ", 
      SqrtBox["195"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"8", "-", "2", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[8], 
        LI[-2], 
        LI[-5]],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "a"],
     AutoSpacing->False],
    m[a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "c"],
     AutoSpacing->False],
    mbar[c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "d"],
     AutoSpacing->False],
    mbar[d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "e"],
     AutoSpacing->False],
    mbar[e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "f"],
     AutoSpacing->False],
    mbar[f],
    Editable->False]}], 
  RowBox[{
  "52", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"c7968417-8db2-45f9-b8ac-57666b176623"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", "calDRule"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"adfa57c3-1f1c-4792-95dd-c545317b8283"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"89820895-9a34-42c2-a72a-8205d8c049e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lp", "=", "5"}], ",", 
        RowBox[{"mp", "=", 
         RowBox[{"-", "2"}]}], ",", 
        RowBox[{"l", "=", "3"}], ",", 
        RowBox[{"mlabel", "=", 
         RowBox[{"-", "3"}]}]}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"lp", ",", 
           RowBox[{"-", "1"}], ",", "mp"}], "]"}], "[", 
         RowBox[{"a", ",", "b", ",", "e", ",", "f"}], "]"}], 
        RowBox[{
         RowBox[{"PureSpin", "[", 
          RowBox[{"l", ",", "1", ",", "mlabel"}], "]"}], "[", 
         RowBox[{"c", ",", "d"}], "]"}]}], "-", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"coeffE", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "4"}], ",", "lp", ",", "mp"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "l", ",", "mlabel"}], "}"}], ",", "j"}], "]"}], 
          RowBox[{
           RowBox[{"PureSpin", "[", 
            RowBox[{"j", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"mp", "+", "mlabel"}]}], "]"}], "[", 
           RowBox[{"e", ",", "f"}], "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"mbar", "[", "a", "]"}]}], 
            RowBox[{"m", "[", "c", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"mbar", "[", "b", "]"}]}], 
            RowBox[{"m", "[", "d", "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"lp", "-", "l"}], "]"}], ",", "0"}], "]"}], ",", 
           RowBox[{"lp", "+", "l"}]}], "}"}]}], "]"}]}]}], "]"}], "//", 
    "Expand"}], ",", 
   RowBox[{"{", 
    RowBox[{"epsilongamma", "[", "__", "]"}], "}"}], ",", "Simplify"}], 
  "]"}]], "Input",ExpressionUUID->"0e184361-37d6-4be2-b73c-39af6470a443"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", "\[Pi]"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"630", " ", 
       SqrtBox["33"], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[GothicCapitalD]", "   ", 
          RowBox[{"32", "-", "3"}]],
         AutoSpacing->False],
        calD[
         LI[3], 
         LI[2], 
         LI[-3]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[GothicCapitalD]", "   ", 
          RowBox[{"5", "-", "4", "-", "2"}]],
         AutoSpacing->False],
        calD[
         LI[5], 
         LI[-4], 
         LI[-2]],
        Editable->False]}], "-", 
      RowBox[{
       SqrtBox[
        RowBox[{"5", " ", "\[Pi]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox["6"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"2", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[2], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-4,5,-2;2\"\>", \
"\<\"2,3,-3\"\>"],
           Subsuperscript["E", "-4,5,-2;2", "2,3,-3"],
           Editable->False]}], "+", 
         RowBox[{
          SqrtBox["42"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"3", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[3], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-4,5,-2;3\"\>", \
"\<\"2,3,-3\"\>"],
           Subsuperscript["E", "-4,5,-2;3", "2,3,-3"],
           Editable->False]}], "+", 
         RowBox[{"9", " ", 
          SqrtBox["2"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"4", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[4], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-4,5,-2;4\"\>", \
"\<\"2,3,-3\"\>"],
           Subsuperscript["E", "-4,5,-2;4", "2,3,-3"],
           Editable->False]}], "+", 
         RowBox[{
          SqrtBox["462"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"5", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[5], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-4,5,-2;5\"\>", \
"\<\"2,3,-3\"\>"],
           Subsuperscript["E", "-4,5,-2;5", "2,3,-3"],
           Editable->False]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["273"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"6", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[6], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-4,5,-2;6\"\>", \
"\<\"2,3,-3\"\>"],
           Subsuperscript["E", "-4,5,-2;6", "2,3,-3"],
           Editable->False]}], "+", 
         RowBox[{"18", " ", 
          SqrtBox["7"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"7", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[7], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-4,5,-2;7\"\>", \
"\<\"2,3,-3\"\>"],
           Subsuperscript["E", "-4,5,-2;7", "2,3,-3"],
           Editable->False]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["119"], " ", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["\[GothicCapitalD]", "   ", 
             RowBox[{"8", "-", "2", "-", "5"}]],
            AutoSpacing->False],
           calD[
            LI[8], 
            LI[-2], 
            LI[-5]],
           Editable->False], " ", 
          InterpretationBox[
           
           SubsuperscriptBox["\<\"E\"\>", "\<\"-4,5,-2;8\"\>", \
"\<\"2,3,-3\"\>"],
           Subsuperscript["E", "-4,5,-2;8", "2,3,-3"],
           Editable->False]}]}], ")"}]}]}], ")"}], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "c"],
      AutoSpacing->False],
     m[c],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "d"],
      AutoSpacing->False],
     m[d],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "a"],
      AutoSpacing->False],
     mbar[a],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "e"],
      AutoSpacing->False],
     mbar[e],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "f"],
      AutoSpacing->False],
     mbar[f],
     Editable->False]}], 
   ")"}]}]], "Output",ExpressionUUID->"92f4e0b7-4d1c-4d7a-a780-c80241563ea4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", "coeffERule"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"34d231c8-5c7e-4822-9d58-d07aafee0a7e"],

Cell[BoxData[
 FractionBox[
  RowBox[{"45", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"182", " ", 
      SqrtBox["33"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"32", "-", "3"}]],
        AutoSpacing->False],
       calD[
        LI[3], 
        LI[2], 
        LI[-3]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"5", "-", "4", "-", "2"}]],
        AutoSpacing->False],
       calD[
        LI[5], 
        LI[-4], 
        LI[-2]],
       Editable->False]}], "+", 
     RowBox[{"18", " ", 
      SqrtBox["55"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"5", "-", "2", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[5], 
        LI[-2], 
        LI[-5]],
       Editable->False]}], "-", 
     RowBox[{"78", " ", 
      SqrtBox["10"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"6", "-", "2", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[6], 
        LI[-2], 
        LI[-5]],
       Editable->False]}], "+", 
     RowBox[{"99", " ", 
      SqrtBox["3"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"7", "-", "2", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[7], 
        LI[-2], 
        LI[-5]],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      SqrtBox["195"], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[GothicCapitalD]", "   ", 
         RowBox[{"8", "-", "2", "-", "5"}]],
        AutoSpacing->False],
       calD[
        LI[8], 
        LI[-2], 
        LI[-5]],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "c"],
     AutoSpacing->False],
    m[c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "d"],
     AutoSpacing->False],
    m[d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "a"],
     AutoSpacing->False],
    mbar[a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "e"],
     AutoSpacing->False],
    mbar[e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "f"],
     AutoSpacing->False],
    mbar[f],
    Editable->False]}], 
  RowBox[{
  "26", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"f009242a-224b-4677-9458-97af3dbb5574"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", "calDRule"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"8d5a02a0-68ec-44cd-82f5-476d6f2beb75"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"a4433bd2-110a-4914-a106-2b8e0b2ea8eb"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Products of X and Z", \
"Subsubsection",ExpressionUUID->"81ba58f1-41a4-496d-8ef5-5fedabc4cb10"],

Cell["\<\
Now we implement the final product formula. We first define the TTensor can \
calTTensor tensors with even number of indices (note that the a,b indices are \
reorganized in the paper):\
\>", "Text",ExpressionUUID->"aba741d0-7add-4dd4-bb2c-f3fbb1811e20"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TTensor", "[", "1", "]"}], "[", 
    RowBox[{"ainds_List", ",", "binds_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", 
     RowBox[{"Length", "[", "ainds", "]"}]}], 
    RowBox[{"Times", "@@", 
     RowBox[{"(", 
      RowBox[{"mbar", "/@", "ainds"}], ")"}]}], 
    RowBox[{"Times", "@@", 
     RowBox[{"(", 
      RowBox[{"m", "/@", "binds"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TTensor", "[", 
     RowBox[{"-", "1"}], "]"}], "[", 
    RowBox[{"ainds_List", ",", "binds_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", 
     RowBox[{"Length", "[", "ainds", "]"}]}], 
    RowBox[{"Times", "@@", 
     RowBox[{"(", 
      RowBox[{"m", "/@", "ainds"}], ")"}]}], 
    RowBox[{"Times", "@@", 
     RowBox[{"(", 
      RowBox[{"mbar", "/@", "binds"}], ")"}]}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b788de81-5870-4c4b-820e-62aad9d3e420"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"calTTensor", "[", "sign_", "]"}], "[", 
    RowBox[{"ainds_List", ",", "binds_List"}], "]"}], ":=", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"TTensor", "[", 
        RowBox[{"-", "1"}], "]"}], "[", 
       RowBox[{"ainds", ",", "binds"}], "]"}], "+", 
      RowBox[{"sign", "  ", 
       RowBox[{
        RowBox[{"TTensor", "[", "1", "]"}], "[", 
        RowBox[{"ainds", ",", "binds"}], "]"}]}]}], ")"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c95b34a9-cfb6-4e14-84e4-21088b7e9d53"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"calTTensor", "[", "sign_", "]"}], "[", 
   RowBox[{"ainds_List", ",", "binds_List"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", 
    RowBox[{"Length", "[", "ainds", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"sign", " ", 
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{"mbar", "/@", "ainds"}], ")"}]}], 
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{"m", "/@", "binds"}], ")"}]}]}], "+", 
      RowBox[{
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{"m", "/@", "ainds"}], ")"}]}], 
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{"mbar", "/@", "binds"}], ")"}]}]}]}], ")"}], "/", 
    "2"}]}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"18428d69-5904-4d0e-b21c-a58802a6d4fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"calTTensor", "[", 
   RowBox[{"-", "1"}], "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d", ",", "f"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"2394f5e6-d2fa-4fa8-bd5b-87de1e41920c"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["m", " ", "b"],
       AutoSpacing->False],
      m[b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["m", " ", "d"],
       AutoSpacing->False],
      m[d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["m", " ", "f"],
       AutoSpacing->False],
      m[f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        OverscriptBox["m", "_"], " ", "a"],
       AutoSpacing->False],
      mbar[a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        OverscriptBox["m", "_"], " ", "c"],
       AutoSpacing->False],
      mbar[c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        OverscriptBox["m", "_"], " ", "e"],
       AutoSpacing->False],
      mbar[e],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["m", " ", "a"],
       AutoSpacing->False],
      m[a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["m", " ", "c"],
       AutoSpacing->False],
      m[c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["m", " ", "e"],
       AutoSpacing->False],
      m[e],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        OverscriptBox["m", "_"], " ", "b"],
       AutoSpacing->False],
      mbar[b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        OverscriptBox["m", "_"], " ", "d"],
       AutoSpacing->False],
      mbar[d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox[
        OverscriptBox["m", "_"], " ", "f"],
       AutoSpacing->False],
      mbar[f],
      Editable->False]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"a807e188-4951-4e5b-8235-d4da5dab4452"]
}, Open  ]],

Cell["and the rule is:", \
"Text",ExpressionUUID->"a51adc53-e65b-4bd3-8d09-1282d3b0ce2d"],

Cell[BoxData[
 RowBox[{"ProductRule", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"rest_.", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"tp", ":", 
         RowBox[{"(", 
          RowBox[{"Z", "|", "X"}], ")"}]}], ")"}], "[", 
       RowBox[{
        RowBox[{"LI", "[", "lp_", "]"}], ",", 
        RowBox[{"LI", "[", "mp_", "]"}], ",", "a___"}], "]"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"t", ":", 
         RowBox[{"(", 
          RowBox[{"Z", "|", "X"}], ")"}]}], ")"}], "[", 
       RowBox[{
        RowBox[{"LI", "[", "l_", "]"}], ",", 
        RowBox[{"LI", "[", "mlabel_", "]"}], ",", "b___"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"sp", "=", 
           RowBox[{"Length", "[", 
            RowBox[{"{", "a", "}"}], "]"}]}], ",", 
          RowBox[{"s", "=", 
           RowBox[{"Length", "[", 
            RowBox[{"{", "b", "}"}], "]"}]}], ",", "ab", ",", "aa", ",", 
          "sigma", ",", "sigmap", ",", "coeff", ",", "coeffp"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"coeffp", ",", "sigmap"}], "}"}], "=", 
          RowBox[{"Switch", "[", 
           RowBox[{"tp", ",", "Z", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", "X", ",", 
            RowBox[{"{", 
             RowBox[{"I", ",", 
              RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"coeff", ",", "sigma"}], "}"}], "=", 
          RowBox[{"Switch", "[", 
           RowBox[{"t", ",", "Z", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", "X", ",", 
            RowBox[{"{", 
             RowBox[{"I", ",", 
              RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"ab", "=", 
          RowBox[{"Sequence", "@@", 
           RowBox[{"Drop", "[", 
            RowBox[{
             RowBox[{"{", "a", "}"}], ",", "s"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"aa", "=", 
          RowBox[{"Drop", "[", 
           RowBox[{
            RowBox[{"{", "a", "}"}], ",", 
            RowBox[{
             RowBox[{"-", "sp"}], "+", "s"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"rest", "  ", "coeffp", " ", "coeff", " ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"s", "===", "0"}], ",", 
            RowBox[{"1", "/", "2"}], ",", "1"}], "]"}], 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"sp", "===", "0"}], ",", 
            RowBox[{"1", "/", "2"}], ",", "1"}], "]"}], 
          RowBox[{"Sum", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"coeffE", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"sp", ",", "lp", ",", "mp"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"s", ",", "l", ",", "mlabel"}], "}"}], ",", "lpp"}], 
               "]"}], 
              RowBox[{"calZ", "[", 
               RowBox[{
                RowBox[{"LI", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"l", "+", "lp", "-", "lpp"}], ")"}]}], "sigma", " ",
                   "sigmap"}], "]"}], ",", 
                RowBox[{"LI", "[", "lpp", "]"}], ",", 
                RowBox[{"LI", "[", 
                 RowBox[{"mp", "+", "mlabel"}], "]"}], ",", "a", ",", "b"}], 
               "]"}]}], "+", 
             RowBox[{"sigma", " ", 
              RowBox[{"coeffE", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"sp", ",", "lp", ",", "mp"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "s"}], ",", "l", ",", "mlabel"}], "}"}], ",", 
                "lpp"}], "]"}], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"calTTensor", "[", 
                   RowBox[{"+", "1"}], "]"}], "[", 
                  RowBox[{"aa", ",", 
                   RowBox[{"{", "b", "}"}]}], "]"}], 
                 RowBox[{"calZ", "[", 
                  RowBox[{
                   RowBox[{"LI", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"l", "+", "lp", "-", "lpp"}], ")"}]}], "sigma", " ",
                     "sigmap"}], "]"}], ",", 
                   RowBox[{"LI", "[", "lpp", "]"}], ",", 
                   RowBox[{"LI", "[", 
                    RowBox[{"mp", "+", "mlabel"}], "]"}], ",", "ab"}], 
                  "]"}]}], "+", 
                RowBox[{
                 RowBox[{
                  RowBox[{"calTTensor", "[", 
                   RowBox[{"-", "1"}], "]"}], "[", 
                  RowBox[{"aa", ",", 
                   RowBox[{"{", "b", "}"}]}], "]"}], 
                 RowBox[{"calZ", "[", 
                  RowBox[{
                   RowBox[{"LI", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"l", "+", "lp", "-", "lpp"}], ")"}]}]}], "sigma", 
                    " ", "sigmap"}], "]"}], ",", 
                   RowBox[{"LI", "[", "lpp", "]"}], ",", 
                   RowBox[{"LI", "[", 
                    RowBox[{"mp", "+", "mlabel"}], "]"}], ",", "ab"}], 
                  "]"}]}]}], ")"}]}]}], ",", 
            RowBox[{"{", 
             RowBox[{"lpp", ",", 
              RowBox[{"Abs", "[", 
               RowBox[{"lp", "-", "l"}], "]"}], ",", 
              RowBox[{"lp", "+", "l"}]}], "}"}]}], "]"}]}]}]}], "]"}], "/;", 
      RowBox[{
       RowBox[{"Length", "[", 
        RowBox[{"{", "a", "}"}], "]"}], "\[GreaterEqual]", 
       RowBox[{"Length", "[", 
        RowBox[{"{", "b", "}"}], "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"rest_.", " ", 
      RowBox[{
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "l_", "]"}], ",", 
         RowBox[{"LI", "[", "mlabel_", "]"}]}], "]"}], "^", "2"}]}], "\[RuleDelayed]",
      "\[IndentingNewLine]", 
     RowBox[{"rest", " ", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"coeffE", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "l", ",", "mlabel"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "l", ",", "mlabel"}], "}"}], ",", "lpp"}], 
          "]"}], 
         RowBox[{"Z", "[", 
          RowBox[{
           RowBox[{"LI", "[", "lpp", "]"}], ",", 
           RowBox[{"LI", "[", 
            RowBox[{"2", "mlabel"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"lpp", ",", "0", ",", 
          RowBox[{"2", "l"}]}], "}"}]}], "]"}]}]}]}], "}"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6467272f-e8a9-4322-a41f-4929c6f0f631"],

Cell["\<\
This is the formal (non-expanding) form. It is exactly the previous rule, \
without the Sum command. Note the special case for a square of a harmonic. \
Note also that this rule multiplies Z's and X's, but not calZ's.\
\>", "Text",ExpressionUUID->"98360e10-401d-49b1-8a45-8d2745ae93fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FormalProductRule", "[", "lc_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"rest_.", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"ta", ":", 
         RowBox[{"(", 
          RowBox[{"Z", "|", "X"}], ")"}]}], ")"}], "[", 
       RowBox[{
        RowBox[{"LI", "[", "la_", "]"}], ",", 
        RowBox[{"LI", "[", "ma_", "]"}], ",", "a___"}], "]"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"tb", ":", 
         RowBox[{"(", 
          RowBox[{"Z", "|", "X"}], ")"}]}], ")"}], "[", 
       RowBox[{
        RowBox[{"LI", "[", "lb_", "]"}], ",", 
        RowBox[{"LI", "[", "mb_", "]"}], ",", "b___"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"sa", "=", 
           RowBox[{"Length", "[", 
            RowBox[{"{", "a", "}"}], "]"}]}], ",", 
          RowBox[{"sb", "=", 
           RowBox[{"Length", "[", 
            RowBox[{"{", "b", "}"}], "]"}]}], ",", "sigmaa", ",", "sigmab", ",",
           "coeffa", ",", "coeffb", ",", "indicesA", ",", "indicesZ"}], "}"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"coeffa", ",", "sigmaa"}], "}"}], "=", 
          RowBox[{"Switch", "[", 
           RowBox[{"ta", ",", "Z", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", "X", ",", 
            RowBox[{"{", 
             RowBox[{"I", ",", 
              RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"coeffb", ",", "sigmab"}], "}"}], "=", 
          RowBox[{"Switch", "[", 
           RowBox[{"tb", ",", "Z", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", "X", ",", 
            RowBox[{"{", 
             RowBox[{"I", ",", 
              RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"indicesZ", "=", 
          RowBox[{"Sequence", "@@", 
           RowBox[{"(", 
            RowBox[{"Drop", "[", 
             RowBox[{
              RowBox[{"{", "a", "}"}], ",", "sb"}], "]"}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"indicesA", "=", 
          RowBox[{"Drop", "[", 
           RowBox[{
            RowBox[{"{", "a", "}"}], ",", 
            RowBox[{"sb", "-", "sa"}]}], "]"}]}], ";", 
         RowBox[{"rest", "  ", "coeffa", " ", "coeffb", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"sa", "===", "0"}], ",", 
            RowBox[{"1", "/", "2"}], ",", "1"}], "]"}], 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"sb", "===", "0"}], ",", 
            RowBox[{"1", "/", "2"}], ",", "1"}], "]"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"coeffE", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"sa", ",", "la", ",", "ma"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"sb", ",", "lb", ",", "mb"}], "}"}], ",", "lc"}], 
              "]"}], 
             RowBox[{"calZ", "[", 
              RowBox[{
               RowBox[{"LI", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"lb", "+", "la", "-", "lc"}], ")"}]}], "sigmaa", " ",
                  "sigmab"}], "]"}], ",", 
               RowBox[{"LI", "[", "lc", "]"}], ",", 
               RowBox[{"LI", "[", 
                RowBox[{"ma", "+", "mb"}], "]"}], ",", "a", ",", "b"}], 
              "]"}]}], "+", 
            RowBox[{"sigmab", " ", 
             RowBox[{"coeffE", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"sa", ",", "la", ",", "ma"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "sb"}], ",", "lb", ",", "mb"}], "}"}], ",", 
               "lc"}], "]"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"calTTensor", "[", 
                  RowBox[{"+", "1"}], "]"}], "[", 
                 RowBox[{"indicesA", ",", 
                  RowBox[{"{", "b", "}"}]}], "]"}], 
                RowBox[{"calZ", "[", 
                 RowBox[{
                  RowBox[{"LI", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"lb", "+", "la", "-", "lc"}], ")"}]}], "sigmaa", " ",
                     "sigmab"}], "]"}], ",", 
                  RowBox[{"LI", "[", "lc", "]"}], ",", 
                  RowBox[{"LI", "[", 
                   RowBox[{"ma", "+", "mb"}], "]"}], ",", "indicesZ"}], 
                 "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"calTTensor", "[", 
                  RowBox[{"-", "1"}], "]"}], "[", 
                 RowBox[{"indicesA", ",", 
                  RowBox[{"{", "b", "}"}]}], "]"}], 
                RowBox[{"calZ", "[", 
                 RowBox[{
                  RowBox[{"LI", "[", 
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"lb", "+", "la", "-", "lc"}], ")"}]}]}], "sigmaa",
                     " ", "sigmab"}], "]"}], ",", 
                  RowBox[{"LI", "[", "lc", "]"}], ",", 
                  RowBox[{"LI", "[", 
                   RowBox[{"ma", "+", "mb"}], "]"}], ",", "indicesZ"}], 
                 "]"}]}]}], ")"}]}]}], ")"}]}]}]}], "]"}], "/;", 
      RowBox[{
       RowBox[{"Length", "[", 
        RowBox[{"{", "a", "}"}], "]"}], "\[GreaterEqual]", 
       RowBox[{"Length", "[", 
        RowBox[{"{", "b", "}"}], "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"rest_.", " ", 
      RowBox[{
       RowBox[{"Z", "[", 
        RowBox[{
         RowBox[{"LI", "[", "la_", "]"}], ",", 
         RowBox[{"LI", "[", "ma_", "]"}]}], "]"}], "^", "2"}]}], "\[RuleDelayed]",
      "\[IndentingNewLine]", 
     RowBox[{"rest", "  ", 
      RowBox[{"coeffE", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "la", ",", "ma"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "la", ",", "ma"}], "}"}], ",", "lc"}], "]"}], 
      RowBox[{
       RowBox[{"calZ", "[", 
        RowBox[{
         RowBox[{"LI", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "lc"}], ")"}]}], "]"}], ",", 
         RowBox[{"LI", "[", "lc", "]"}], ",", 
         RowBox[{"LI", "[", 
          RowBox[{"2", "ma"}], "]"}]}], "]"}], "/", "2"}]}]}]}], 
   "}"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"02e9b175-77d2-4596-a563-ae0b326219ed"],

Cell["\<\
It is important to note that when both harmonics have the same labels la and \
ma then the E-coefficients vanish for odd lc, which ranges from 0 to 2la \
through even integers. In order to make that point clearer we have used calZ \
/ 2 instead of Z in the last expression, because calZ vanishes for odd l, but \
Z doesn't.\
\>", "Text",ExpressionUUID->"c6a5cb9e-5d46-4a92-99a6-4efafa950865"]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", \
"Subsubsection",ExpressionUUID->"598e2843-2be5-4fb0-8512-be03b2175a9a"],

Cell["Example1:", \
"Text",ExpressionUUID->"ed973361-26b3-4dc3-8c17-4fca5331d37e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expression", "=", 
  RowBox[{
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "4", "]"}], ",", 
     RowBox[{"LI", "[", 
      RowBox[{"-", "1"}], "]"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "3", "]"}], ",", 
     RowBox[{"LI", "[", "2", "]"}], ",", 
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "e"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"deef60b4-2c9e-4a1a-8fe9-a78b893d7baf"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"  ", "de"}], 
     RowBox[{"32", "  "}]],
    AutoSpacing->False],
   X[
    LI[3], 
    LI[2], -d, -e],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"  ", "abc"}], 
     RowBox[{"4", "-", "1", "   "}]],
    AutoSpacing->False],
   X[
    LI[4], 
    LI[-1], -a, -b, -c],
   Editable->
    False]}]], "Output",ExpressionUUID->"f78cd1dc-8639-4b77-8c3d-c4ba77ae35e9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"comp", "[", "expr_", "]"}], ":=", 
  RowBox[{"ContractBasis", "[", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"b", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"c", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"d", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"e", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "expr"}], 
   "]"}]}]], "Input",ExpressionUUID->"b5dfaf2a-4223-43ed-b87c-ab63bec70702"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{
   RowBox[{"expression", "//", "comp"}], "//", 
   "HarmonicComponent"}]}]], \
"Input",ExpressionUUID->"da00c6ec-3f60-4108-8d58-fcf6395d6058"],

Cell[BoxData[
 FractionBox[
  RowBox[{"945", " ", 
   SqrtBox[
    FractionBox["21", "2"]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False]}]], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Cos",
      AutoSpacing->False],
     Cos,
     Editable->False], "[", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Theta]", "", ""],
      AutoSpacing->False],
     \[Theta][],
     Editable->False], "]"}], " ", 
   RowBox[{
    InterpretationBox[
     StyleBox["Cos",
      AutoSpacing->False],
     Cos,
     Editable->False], "[", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "2"]}], 
  RowBox[{
  "32", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"27755ff1-e1f3-4b1a-97fb-ed031c991342"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expression", "/.", 
  "ProductRule"}]], \
"Input",ExpressionUUID->"b27fe55b-4e8a-4606-b896-5435433106aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ImaginaryI]", " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;6\"\>", "\<\"2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;6", "2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", "abcde"}], 
      RowBox[{"61", "     "}]],
     AutoSpacing->False],
    X[
     LI[6], 
     LI[1], -a, -b, -c, -d, -e],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;1\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;1", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", "d", " "],
            AutoSpacing->False],
           m[-d],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "c"}], 
         RowBox[{"11", " "}]],
        AutoSpacing->False],
       X[
        LI[1], 
        LI[1], -c],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "c"}], 
         RowBox[{"11", " "}]],
        AutoSpacing->False],
       Z[
        LI[1], 
        LI[1], -c],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;2\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;2", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "c"}], 
         RowBox[{"21", " "}]],
        AutoSpacing->False],
       X[
        LI[2], 
        LI[1], -c],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", "d", " "],
            AutoSpacing->False],
           m[-d],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "c"}], 
         RowBox[{"21", " "}]],
        AutoSpacing->False],
       Z[
        LI[2], 
        LI[1], -c],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;3\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;3", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", "d", " "],
            AutoSpacing->False],
           m[-d],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "c"}], 
         RowBox[{"31", " "}]],
        AutoSpacing->False],
       X[
        LI[3], 
        LI[1], -c],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "c"}], 
         RowBox[{"31", " "}]],
        AutoSpacing->False],
       Z[
        LI[3], 
        LI[1], -c],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;4\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;4", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "c"}], 
         RowBox[{"41", " "}]],
        AutoSpacing->False],
       X[
        LI[4], 
        LI[1], -c],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", "d", " "],
            AutoSpacing->False],
           m[-d],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "c"}], 
         RowBox[{"41", " "}]],
        AutoSpacing->False],
       Z[
        LI[4], 
        LI[1], -c],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;5\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;5", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", "d", " "],
            AutoSpacing->False],
           m[-d],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "c"}], 
         RowBox[{"51", " "}]],
        AutoSpacing->False],
       X[
        LI[5], 
        LI[1], -c],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "c"}], 
         RowBox[{"51", " "}]],
        AutoSpacing->False],
       Z[
        LI[5], 
        LI[1], -c],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;6\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;6", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "c"}], 
         RowBox[{"61", " "}]],
        AutoSpacing->False],
       X[
        LI[6], 
        LI[1], -c],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", "d", " "],
            AutoSpacing->False],
           m[-d],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "c"}], 
         RowBox[{"61", " "}]],
        AutoSpacing->False],
       Z[
        LI[6], 
        LI[1], -c],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;7\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;7", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", "d", " "],
            AutoSpacing->False],
           m[-d],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "c"}], 
         RowBox[{"71", " "}]],
        AutoSpacing->False],
       X[
        LI[7], 
        LI[1], -c],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "e", " "],
           AutoSpacing->False],
          m[-e],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "b", " "],
           AutoSpacing->False],
          mbar[-b],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "b", " "],
           AutoSpacing->False],
          m[-b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "e", " "],
           AutoSpacing->False],
          mbar[-e],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "c"}], 
         RowBox[{"71", " "}]],
        AutoSpacing->False],
       Z[
        LI[7], 
        LI[1], -c],
       Editable->False]}]}], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;5\"\>", "\<\"2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;5", "2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "abcde"}], 
      RowBox[{"51", "     "}]],
     AutoSpacing->False],
    Z[
     LI[5], 
     LI[1], -a, -b, -c, -d, -e],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;7\"\>", "\<\"2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;7", "2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "abcde"}], 
      RowBox[{"71", "     "}]],
     AutoSpacing->False],
    Z[
     LI[7], 
     LI[1], -a, -b, -c, -d, -e],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"011907bc-2a4b-4a0b-bbe2-d9c7ad10a2b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "comp"}], "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"55bd22ce-aec8-419f-baaf-58e315c03c77"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;2\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;2", "-2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"21", " "}]],
     AutoSpacing->False],
    X[
     LI[2], 
     LI[1], {2, -spherical}],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;4\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;4", "-2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", " "}]],
     AutoSpacing->False],
    X[
     LI[4], 
     LI[1], {2, -spherical}],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;6\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;6", "-2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"61", " "}]],
     AutoSpacing->False],
    X[
     LI[6], 
     LI[1], {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;6\"\>", "\<\"2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;6", "2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"2", "2", "2", "2", "2"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"61", "     "}]],
     AutoSpacing->False],
    X[
     LI[6], 
     LI[1], {2, -spherical}, {2, -spherical}, {2, -spherical}, {
     2, -spherical}, {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;1\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;1", "-2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"11", " "}]],
     AutoSpacing->False],
    Z[
     LI[1], 
     LI[1], {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;3\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;3", "-2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"31", " "}]],
     AutoSpacing->False],
    Z[
     LI[3], 
     LI[1], {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;5\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;5", "-2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"51", " "}]],
     AutoSpacing->False],
    Z[
     LI[5], 
     LI[1], {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;7\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;7", "-2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"71", " "}]],
     AutoSpacing->False],
    Z[
     LI[7], 
     LI[1], {2, -spherical}],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;5\"\>", "\<\"2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;5", "2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"2", "2", "2", "2", "2"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"51", "     "}]],
     AutoSpacing->False],
    Z[
     LI[5], 
     LI[1], {2, -spherical}, {2, -spherical}, {2, -spherical}, {
     2, -spherical}, {2, -spherical}],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;7\"\>", "\<\"2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;7", "2,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"2", "2", "2", "2", "2"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"71", "     "}]],
     AutoSpacing->False],
    Z[
     LI[7], 
     LI[1], {2, -spherical}, {2, -spherical}, {2, -spherical}, {
     2, -spherical}, {2, -spherical}],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"140caa01-c478-4263-928b-726bd33cbc03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "coeffERule"}]], \
"Input",ExpressionUUID->"06786e76-8c2f-43c3-bd98-8068658dfa32"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["7", "16"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["35", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"21", " "}]],
     AutoSpacing->False],
    X[
     LI[2], 
     LI[1], {2, -spherical}],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{"85", " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", 
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]]}], 
       RowBox[{"61", " "}]],
      AutoSpacing->False],
     X[
      LI[6], 
      LI[1], {2, -spherical}],
     Editable->False]}], 
   RowBox[{"16", " ", 
    SqrtBox[
     RowBox[{"13", " ", "\[Pi]"}]]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", 
        StyleBox[
         RowBox[{"2", "2", "2", "2", "2"}],
         FontColor->RGBColor[1, 0, 0]]}], 
       RowBox[{"61", "     "}]],
      AutoSpacing->False],
     X[
      LI[6], 
      LI[1], {2, -spherical}, {2, -spherical}, {2, -spherical}, {
      2, -spherical}, {2, -spherical}],
     Editable->False]}], 
   RowBox[{"24", " ", 
    SqrtBox[
     RowBox[{"13", " ", "\[Pi]"}]]}]], "+", 
  RowBox[{
   FractionBox["45", "16"], " ", 
   SqrtBox[
    FractionBox["7", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"11", " "}]],
     AutoSpacing->False],
    Z[
     LI[1], 
     LI[1], {2, -spherical}],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{"35", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", 
        StyleBox["2",
         FontColor->RGBColor[1, 0, 0]]}], 
       RowBox[{"31", " "}]],
      AutoSpacing->False],
     Z[
      LI[3], 
      LI[1], {2, -spherical}],
     Editable->False]}], 
   RowBox[{"11", " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]]}]], "+", 
  RowBox[{
   FractionBox["25", "208"], " ", 
   SqrtBox[
    FractionBox["385", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"51", " "}]],
     AutoSpacing->False],
    Z[
     LI[5], 
     LI[1], {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["18", "143"], " ", 
   SqrtBox[
    FractionBox["5", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox["2",
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"71", " "}]],
     AutoSpacing->False],
    Z[
     LI[7], 
     LI[1], {2, -spherical}],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["25", "312"], " ", 
   SqrtBox[
    FractionBox["35", 
     RowBox[{"11", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"2", "2", "2", "2", "2"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"51", "     "}]],
     AutoSpacing->False],
    Z[
     LI[5], 
     LI[1], {2, -spherical}, {2, -spherical}, {2, -spherical}, {
     2, -spherical}, {2, -spherical}],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", 
        StyleBox[
         RowBox[{"2", "2", "2", "2", "2"}],
         FontColor->RGBColor[1, 0, 0]]}], 
       RowBox[{"71", "     "}]],
      AutoSpacing->False],
     Z[
      LI[7], 
      LI[1], {2, -spherical}, {2, -spherical}, {2, -spherical}, {
      2, -spherical}, {2, -spherical}],
     Editable->False]}], 
   RowBox[{"143", " ", 
    SqrtBox[
     RowBox[{
     "5", " ", 
      "\[Pi]"}]]}]]}]], \
"Output",ExpressionUUID->"d6270408-3a04-4ea9-80f5-fe3e50873960"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{
  "%", "//", 
   "HarmonicComponent"}]}]], \
"Input",ExpressionUUID->"10b800b1-3dba-4270-bad6-4a18241f8e1f"],

Cell[BoxData[
 FractionBox[
  RowBox[{"945", " ", 
   SqrtBox[
    FractionBox["21", "2"]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"3", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "2"]}], 
  RowBox[{
  "64", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"afae8c6e-c3e0-4dc3-ac89-bacc36f2692d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"r1", "-", "r2"}], 
  "]"}]], "Input",ExpressionUUID->"dfa9533c-335d-4768-9a56-6fa112a7218d"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"37d922c3-b1a0-40fd-ab3a-1d1e93af906a"]
}, Open  ]],

Cell["Compare total timings:", \
"Text",ExpressionUUID->"c3013e63-3077-49f2-b364-c5b26afd8d54"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"HarmonicComponent", "[", 
   RowBox[{"comp", "[", "expression", "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"e9e762f9-4d3e-49ba-a130-283fbde1ee3c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.016666000000000736`", " ", "Second"}], ",", 
   FractionBox[
    RowBox[{"945", " ", 
     SqrtBox[
      FractionBox["21", "2"]], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Phi]", "", ""],
         AutoSpacing->False],
        \[Phi][],
        Editable->False]}]], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Theta]", "", ""],
        AutoSpacing->False],
       \[Theta][],
       Editable->False], "]"}], " ", 
     RowBox[{
      InterpretationBox[
       StyleBox["Cos",
        AutoSpacing->False],
       Cos,
       Editable->False], "[", 
      RowBox[{"2", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], 
    RowBox[{"32", " ", "\[Pi]"}]]}], 
  "}"}]], "Output",ExpressionUUID->"14df60ee-abe4-4c4d-b4fe-5aebc4bd2500"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"HarmonicComponent", "[", 
   RowBox[{
    RowBox[{"ToValues", "@", 
     RowBox[{"comp", "[", 
      RowBox[{"expression", "/.", "ProductRule"}], "]"}]}], "/.", 
    "coeffERule"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"6fc6562c-b39b-4ae4-984f-6e7003de9857"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.12999200000000144`", " ", "Second"}], ",", 
   FractionBox[
    RowBox[{"945", " ", 
     SqrtBox[
      FractionBox["21", "2"]], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Phi]", "", ""],
         AutoSpacing->False],
        \[Phi][],
        Editable->False]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        RowBox[{"3", " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["\[Theta]", "", ""],
           AutoSpacing->False],
          \[Theta][],
          Editable->False]}], "]"}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       InterpretationBox[
        StyleBox["Sin",
         AutoSpacing->False],
        Sin,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}], "2"]}], 
    RowBox[{"64", " ", "\[Pi]"}]]}], 
  "}"}]], "Output",ExpressionUUID->"7c2cdb57-c096-4da4-9846-6f1c547ce420"]
}, Open  ]],

Cell["Example2. There is a contracted index", \
"Text",ExpressionUUID->"23644621-3c8a-4847-9c27-f0ffe9d65042"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expression", "=", 
  RowBox[{
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "4", "]"}], ",", 
     RowBox[{"LI", "[", 
      RowBox[{"-", "1"}], "]"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "3", "]"}], ",", 
     RowBox[{"LI", "[", "2", "]"}], ",", "b", ",", 
     RowBox[{"-", "d"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"b5581d1d-cc7a-415a-a4c7-cc908fe07aaf"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"   ", "d"}], 
     RowBox[{"32", "b", " "}]],
    AutoSpacing->False],
   X[
    LI[3], 
    LI[2], b, -d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"  ", "cab"}], 
     RowBox[{"4", "-", "1", "   "}]],
    AutoSpacing->False],
   X[
    LI[4], 
    LI[-1], -c, -a, -b],
   Editable->
    False]}]], "Output",ExpressionUUID->"ce6e464d-a16a-46c0-b973-9acd5f52aa40"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"comp", "[", "expr_", "]"}], ":=", 
  RowBox[{"ContractBasis", "[", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"c", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"d", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "expr"}], 
   "]"}]}]], "Input",ExpressionUUID->"1f6d328d-6325-4703-9ab9-61c9eb86af81"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{
   RowBox[{"expression", "//", "comp"}], "//", 
   "HarmonicComponent"}]}]], \
"Input",ExpressionUUID->"547238b1-a0aa-4330-b3a7-c0bd30a46555"],

Cell[BoxData[
 FractionBox[
  RowBox[{"315", " ", 
   SqrtBox[
    FractionBox["21", "2"]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"25", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], "+", 
     RowBox[{"20", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"3", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}], "+", 
     RowBox[{"3", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"5", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "2"]}], 
  RowBox[{
  "256", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"9097f7f6-1070-4e5e-8ed6-318143004ce8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expression", "/.", 
  "ProductRule"}]], \
"Input",ExpressionUUID->"91f5f34d-decb-4160-85f3-3aea8c3620a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;1\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;1", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", " ", "b"],
            AutoSpacing->False],
           m[b],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "b"}], 
         RowBox[{"11", " "}]],
        AutoSpacing->False],
       X[
        LI[1], 
        LI[1], -b],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "b"],
           AutoSpacing->False],
          m[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "b"}], 
         RowBox[{"11", " "}]],
        AutoSpacing->False],
       Z[
        LI[1], 
        LI[1], -b],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;2\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;2", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "b"],
           AutoSpacing->False],
          m[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "b"}], 
         RowBox[{"21", " "}]],
        AutoSpacing->False],
       X[
        LI[2], 
        LI[1], -b],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", " ", "b"],
            AutoSpacing->False],
           m[b],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "b"}], 
         RowBox[{"21", " "}]],
        AutoSpacing->False],
       Z[
        LI[2], 
        LI[1], -b],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;3\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;3", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", " ", "b"],
            AutoSpacing->False],
           m[b],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "b"}], 
         RowBox[{"31", " "}]],
        AutoSpacing->False],
       X[
        LI[3], 
        LI[1], -b],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "b"],
           AutoSpacing->False],
          m[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "b"}], 
         RowBox[{"31", " "}]],
        AutoSpacing->False],
       Z[
        LI[3], 
        LI[1], -b],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;4\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;4", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "b"],
           AutoSpacing->False],
          m[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "b"}], 
         RowBox[{"41", " "}]],
        AutoSpacing->False],
       X[
        LI[4], 
        LI[1], -b],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", " ", "b"],
            AutoSpacing->False],
           m[b],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "b"}], 
         RowBox[{"41", " "}]],
        AutoSpacing->False],
       Z[
        LI[4], 
        LI[1], -b],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;5\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;5", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", " ", "b"],
            AutoSpacing->False],
           m[b],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "b"}], 
         RowBox[{"51", " "}]],
        AutoSpacing->False],
       X[
        LI[5], 
        LI[1], -b],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "b"],
           AutoSpacing->False],
          m[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "b"}], 
         RowBox[{"51", " "}]],
        AutoSpacing->False],
       Z[
        LI[5], 
        LI[1], -b],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;6\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;6", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "b"],
           AutoSpacing->False],
          m[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "b"}], 
         RowBox[{"61", " "}]],
        AutoSpacing->False],
       X[
        LI[6], 
        LI[1], -b],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", " ", "b"],
            AutoSpacing->False],
           m[b],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "b"}], 
         RowBox[{"61", " "}]],
        AutoSpacing->False],
       Z[
        LI[6], 
        LI[1], -b],
       Editable->False]}]}], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;7\"\>", "\<\"-2,3,2\"\>"],
    Subsuperscript["E", "3,4,-1;7", "-2,3,2"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          InterpretationBox[
           StyleBox[
            SubsuperscriptBox["m", " ", "b"],
            AutoSpacing->False],
           m[b],
           Editable->False]}], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["X", 
         RowBox[{"  ", "b"}], 
         RowBox[{"71", " "}]],
        AutoSpacing->False],
       X[
        LI[7], 
        LI[1], -b],
       Editable->False]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "b"],
           AutoSpacing->False],
          m[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "d", " "],
           AutoSpacing->False],
          m[-d],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "a", " "],
           AutoSpacing->False],
          mbar[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "c", " "],
           AutoSpacing->False],
          mbar[-c],
          Editable->False]}], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "a", " "],
           AutoSpacing->False],
          m[-a],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", "c", " "],
           AutoSpacing->False],
          m[-c],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], " ", "b"],
           AutoSpacing->False],
          mbar[b],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox[
            OverscriptBox["m", "_"], "d", " "],
           AutoSpacing->False],
          mbar[-d],
          Editable->False]}]}], ")"}], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["Z", 
         RowBox[{"  ", "b"}], 
         RowBox[{"71", " "}]],
        AutoSpacing->False],
       Z[
        LI[7], 
        LI[1], -b],
       Editable->False]}]}], 
    ")"}]}]}]], \
"Output",ExpressionUUID->"56096d7c-acf7-41cf-8264-814319a55bf8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "comp"}], "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"97ae478d-0e98-4ca6-b77c-c206ae30c75a"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;1\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;1", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"11", " "}]],
      AutoSpacing->False],
     X[
      LI[1], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;1\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;1", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"11", " "}]],
      AutoSpacing->False],
     X[
      LI[1], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;2\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;2", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"21", " "}]],
      AutoSpacing->False],
     X[
      LI[2], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;2\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;2", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"21", " "}]],
      AutoSpacing->False],
     X[
      LI[2], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;3\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;3", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"31", " "}]],
      AutoSpacing->False],
     X[
      LI[3], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;3\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;3", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"31", " "}]],
      AutoSpacing->False],
     X[
      LI[3], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;4\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;4", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"41", " "}]],
      AutoSpacing->False],
     X[
      LI[4], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;4\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;4", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"41", " "}]],
      AutoSpacing->False],
     X[
      LI[4], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;5\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;5", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"51", " "}]],
      AutoSpacing->False],
     X[
      LI[5], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;5\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;5", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"51", " "}]],
      AutoSpacing->False],
     X[
      LI[5], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;6\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;6", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"61", " "}]],
      AutoSpacing->False],
     X[
      LI[6], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;6\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;6", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"61", " "}]],
      AutoSpacing->False],
     X[
      LI[6], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;7\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;7", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"71", " "}]],
      AutoSpacing->False],
     X[
      LI[7], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;7\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;7", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"71", " "}]],
      AutoSpacing->False],
     X[
      LI[7], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;1\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;1", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"11", " "}]],
      AutoSpacing->False],
     Z[
      LI[1], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;1\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;1", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"11", " "}]],
      AutoSpacing->False],
     Z[
      LI[1], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;2\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;2", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"21", " "}]],
      AutoSpacing->False],
     Z[
      LI[2], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;2\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;2", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"21", " "}]],
      AutoSpacing->False],
     Z[
      LI[2], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;3\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;3", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"31", " "}]],
      AutoSpacing->False],
     Z[
      LI[3], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;3\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;3", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"31", " "}]],
      AutoSpacing->False],
     Z[
      LI[3], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;4\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;4", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"41", " "}]],
      AutoSpacing->False],
     Z[
      LI[4], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;4\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;4", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"41", " "}]],
      AutoSpacing->False],
     Z[
      LI[4], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;5\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;5", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"51", " "}]],
      AutoSpacing->False],
     Z[
      LI[5], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;5\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;5", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"51", " "}]],
      AutoSpacing->False],
     Z[
      LI[5], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;6\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;6", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"61", " "}]],
      AutoSpacing->False],
     Z[
      LI[6], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;6\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;6", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"61", " "}]],
      AutoSpacing->False],
     Z[
      LI[6], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;7\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;7", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"71", " "}]],
      AutoSpacing->False],
     Z[
      LI[7], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     SubsuperscriptBox["\<\"E\"\>", "\<\"3,4,-1;7\"\>", "\<\"-2,3,2\"\>"],
     Subsuperscript["E", "3,4,-1;7", "-2,3,2"],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"71", " "}]],
      AutoSpacing->False],
     Z[
      LI[7], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"4", " ", 
    SqrtBox[
     "2"]}]]}]], \
"Output",ExpressionUUID->"9ee85a99-e37b-48ba-847e-56d72eec12fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "coeffERule"}]], \
"Input",ExpressionUUID->"515919a9-f98b-4b32-ac0b-d71876a3985d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["45", "16"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["7", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", "b"}], 
      RowBox[{"11", " "}]],
     AutoSpacing->False],
    X[
     LI[1], 
     LI[1], -b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["45", "16"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["7", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", "b"}], 
      RowBox[{"11", " "}]],
     AutoSpacing->False],
    X[
     LI[1], 
     LI[1], -b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["7", "16"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["35", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", "b"}], 
      RowBox[{"21", " "}]],
     AutoSpacing->False],
    X[
     LI[2], 
     LI[1], -b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["7", "16"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["35", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", "b"}], 
      RowBox[{"21", " "}]],
     AutoSpacing->False],
    X[
     LI[2], 
     LI[1], -b],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{"35", " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"31", " "}]],
      AutoSpacing->False],
     X[
      LI[3], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"22", " ", 
    SqrtBox["\[Pi]"]}]], "+", 
  FractionBox[
   RowBox[{"35", " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"31", " "}]],
      AutoSpacing->False],
     X[
      LI[3], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"22", " ", 
    SqrtBox["\[Pi]"]}]], "+", 
  RowBox[{
   FractionBox["25", "208"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["385", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", "b"}], 
      RowBox[{"51", " "}]],
     AutoSpacing->False],
    X[
     LI[5], 
     LI[1], -b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["25", "208"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["385", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", "b"}], 
      RowBox[{"51", " "}]],
     AutoSpacing->False],
    X[
     LI[5], 
     LI[1], -b],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{"85", " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"61", " "}]],
      AutoSpacing->False],
     X[
      LI[6], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"16", " ", 
    SqrtBox[
     RowBox[{"26", " ", "\[Pi]"}]]}]], "+", 
  FractionBox[
   RowBox[{"85", " ", "\[ImaginaryI]", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["X", 
       RowBox[{"  ", "b"}], 
       RowBox[{"61", " "}]],
      AutoSpacing->False],
     X[
      LI[6], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"16", " ", 
    SqrtBox[
     RowBox[{"26", " ", "\[Pi]"}]]}]], "+", 
  RowBox[{
   FractionBox["9", "143"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["10", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", "b"}], 
      RowBox[{"71", " "}]],
     AutoSpacing->False],
    X[
     LI[7], 
     LI[1], -b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["9", "143"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["10", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["X", 
      RowBox[{"  ", "b"}], 
      RowBox[{"71", " "}]],
     AutoSpacing->False],
    X[
     LI[7], 
     LI[1], -b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["45", "16"], " ", 
   SqrtBox[
    FractionBox["7", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "b"}], 
      RowBox[{"11", " "}]],
     AutoSpacing->False],
    Z[
     LI[1], 
     LI[1], -b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["45", "16"], " ", 
   SqrtBox[
    FractionBox["7", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "b"}], 
      RowBox[{"11", " "}]],
     AutoSpacing->False],
    Z[
     LI[1], 
     LI[1], -b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["7", "16"], " ", 
   SqrtBox[
    FractionBox["35", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "b"}], 
      RowBox[{"21", " "}]],
     AutoSpacing->False],
    Z[
     LI[2], 
     LI[1], -b],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["7", "16"], " ", 
   SqrtBox[
    FractionBox["35", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "b"}], 
      RowBox[{"21", " "}]],
     AutoSpacing->False],
    Z[
     LI[2], 
     LI[1], -b],
    Editable->False]}], "-", 
  FractionBox[
   RowBox[{"35", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"31", " "}]],
      AutoSpacing->False],
     Z[
      LI[3], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"22", " ", 
    SqrtBox["\[Pi]"]}]], "-", 
  FractionBox[
   RowBox[{"35", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"31", " "}]],
      AutoSpacing->False],
     Z[
      LI[3], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"22", " ", 
    SqrtBox["\[Pi]"]}]], "+", 
  RowBox[{
   FractionBox["25", "208"], " ", 
   SqrtBox[
    FractionBox["385", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "b"}], 
      RowBox[{"51", " "}]],
     AutoSpacing->False],
    Z[
     LI[5], 
     LI[1], -b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["25", "208"], " ", 
   SqrtBox[
    FractionBox["385", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "b"}], 
      RowBox[{"51", " "}]],
     AutoSpacing->False],
    Z[
     LI[5], 
     LI[1], -b],
    Editable->False]}], "+", 
  FractionBox[
   RowBox[{"85", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["m", " ", "b"],
      AutoSpacing->False],
     m[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"61", " "}]],
      AutoSpacing->False],
     Z[
      LI[6], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"16", " ", 
    SqrtBox[
     RowBox[{"26", " ", "\[Pi]"}]]}]], "-", 
  FractionBox[
   RowBox[{"85", " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox[
       OverscriptBox["m", "_"], " ", "b"],
      AutoSpacing->False],
     mbar[b],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["Z", 
       RowBox[{"  ", "b"}], 
       RowBox[{"61", " "}]],
      AutoSpacing->False],
     Z[
      LI[6], 
      LI[1], -b],
     Editable->False]}], 
   RowBox[{"16", " ", 
    SqrtBox[
     RowBox[{"26", " ", "\[Pi]"}]]}]], "+", 
  RowBox[{
   FractionBox["9", "143"], " ", 
   SqrtBox[
    FractionBox["10", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["m", " ", "b"],
     AutoSpacing->False],
    m[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "b"}], 
      RowBox[{"71", " "}]],
     AutoSpacing->False],
    Z[
     LI[7], 
     LI[1], -b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["9", "143"], " ", 
   SqrtBox[
    FractionBox["10", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox[
      OverscriptBox["m", "_"], " ", "b"],
     AutoSpacing->False],
    mbar[b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "b"}], 
      RowBox[{"71", " "}]],
     AutoSpacing->False],
    Z[
     LI[7], 
     LI[1], -b],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"13914c08-ebc7-42ab-be60-c6440f7cce07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{
  "%", "//", 
   "HarmonicComponent"}]}]], \
"Input",ExpressionUUID->"8ffcc8f6-67d4-47ee-a6c8-35b3f0204099"],

Cell[BoxData[
 FractionBox[
  RowBox[{"315", " ", 
   SqrtBox[
    FractionBox["21", "2"]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"25", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["\[Theta]", "", ""],
         AutoSpacing->False],
        \[Theta][],
        Editable->False], "]"}]}], "+", 
     RowBox[{"20", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"3", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}], "+", 
     RowBox[{"3", " ", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"5", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "2"]}], 
  RowBox[{
  "256", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"584198cd-0664-4dc7-b2df-611c99eac2ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"r1", "-", "r2"}], 
  "]"}]], "Input",ExpressionUUID->"ccce42ae-4c17-4bf4-8f05-c224d9cf7c62"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"158243b2-df75-4b6a-9cc0-465f4990130d"]
}, Open  ]],

Cell["Example 3. Equal numbers of indices:", \
"Text",ExpressionUUID->"0bb82314-9616-42fe-a33f-5cc5faae7e51"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expression", "=", 
  RowBox[{
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "2", "]"}], ",", 
     RowBox[{"LI", "[", 
      RowBox[{"-", "1"}], "]"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "2", "]"}], ",", 
     RowBox[{"LI", "[", "2", "]"}], ",", 
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "e"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"680ffbcc-95c1-409d-8c2c-bb2cb4fbc344"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"  ", "ab"}], 
     RowBox[{"2", "-", "1", "  "}]],
    AutoSpacing->False],
   X[
    LI[2], 
    LI[-1], -a, -b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"  ", "de"}], 
     RowBox[{"22", "  "}]],
    AutoSpacing->False],
   X[
    LI[2], 
    LI[2], -d, -e],
   Editable->
    False]}]], "Output",ExpressionUUID->"37367cb4-80a6-423b-a013-cbf6f6948924"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"comp", "[", "expr_", "]"}], ":=", 
  RowBox[{"ContractBasis", "[", 
   RowBox[{
    RowBox[{"Basis", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"b", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"d", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], 
    RowBox[{"Basis", "[", 
     RowBox[{"e", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "spherical"}]}], "}"}]}], "]"}], "expr"}], 
   "]"}]}]], "Input",ExpressionUUID->"1378a960-900e-4f1b-ae20-ab1121a730ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{
   RowBox[{"comp", "[", "expression", "]"}], "//", 
   "HarmonicComponent"}]}]], \
"Input",ExpressionUUID->"950f45b3-628b-48ce-947b-157cc55c9414"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"15", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], 
   RowBox[{
   "8", " ", 
    "\[Pi]"}]]}]], \
"Output",ExpressionUUID->"9545fdd8-98bd-4796-bcb6-0b619648e8a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expression", "/.", 
  "ProductRule"}]], \
"Input",ExpressionUUID->"71ec27e6-57e2-4a3b-9f9f-46396bc33985"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;0\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;0", "-2,2,-1"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "d", " "],
        AutoSpacing->False],
       m[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "e", " "],
        AutoSpacing->False],
       m[-e],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "a", " "],
        AutoSpacing->False],
       mbar[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "b", " "],
        AutoSpacing->False],
       mbar[-b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "a", " "],
        AutoSpacing->False],
       m[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "b", " "],
        AutoSpacing->False],
       m[-b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "d", " "],
        AutoSpacing->False],
       mbar[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "e", " "],
        AutoSpacing->False],
       mbar[-e],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "01"],
     AutoSpacing->False],
    Z[
     LI[0], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;1\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;1", "-2,2,-1"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "d", " "],
        AutoSpacing->False],
       m[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "e", " "],
        AutoSpacing->False],
       m[-e],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "a", " "],
        AutoSpacing->False],
       mbar[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "b", " "],
        AutoSpacing->False],
       mbar[-b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "a", " "],
        AutoSpacing->False],
       m[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "b", " "],
        AutoSpacing->False],
       m[-b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "d", " "],
        AutoSpacing->False],
       mbar[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "e", " "],
        AutoSpacing->False],
       mbar[-e],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "11"],
     AutoSpacing->False],
    Z[
     LI[1], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;2\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;2", "-2,2,-1"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "d", " "],
        AutoSpacing->False],
       m[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "e", " "],
        AutoSpacing->False],
       m[-e],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "a", " "],
        AutoSpacing->False],
       mbar[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "b", " "],
        AutoSpacing->False],
       mbar[-b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "a", " "],
        AutoSpacing->False],
       m[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "b", " "],
        AutoSpacing->False],
       m[-b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "d", " "],
        AutoSpacing->False],
       mbar[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "e", " "],
        AutoSpacing->False],
       mbar[-e],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "21"],
     AutoSpacing->False],
    Z[
     LI[2], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;3\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;3", "-2,2,-1"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "d", " "],
        AutoSpacing->False],
       m[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "e", " "],
        AutoSpacing->False],
       m[-e],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "a", " "],
        AutoSpacing->False],
       mbar[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "b", " "],
        AutoSpacing->False],
       mbar[-b],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "a", " "],
        AutoSpacing->False],
       m[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "b", " "],
        AutoSpacing->False],
       m[-b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "d", " "],
        AutoSpacing->False],
       mbar[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "e", " "],
        AutoSpacing->False],
       mbar[-e],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "31"],
     AutoSpacing->False],
    Z[
     LI[3], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;4\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;4", "-2,2,-1"],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "d", " "],
        AutoSpacing->False],
       m[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "e", " "],
        AutoSpacing->False],
       m[-e],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "a", " "],
        AutoSpacing->False],
       mbar[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "b", " "],
        AutoSpacing->False],
       mbar[-b],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "a", " "],
        AutoSpacing->False],
       m[-a],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["m", "b", " "],
        AutoSpacing->False],
       m[-b],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "d", " "],
        AutoSpacing->False],
       mbar[-d],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox[
         OverscriptBox["m", "_"], "e", " "],
        AutoSpacing->False],
       mbar[-e],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "41"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;4\"\>", "\<\"2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;4", "2,2,-1"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", "deab"}], 
      RowBox[{"41", "    "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], -d, -e, -a, -b],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"8beb6a8e-1f65-45c8-802f-1e519f391632"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "comp"}], "//", 
  "ToValues"}]], \
"Input",ExpressionUUID->"dd71a571-5f1c-48f8-a7be-a2c060134237"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;0\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;0", "-2,2,-1"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "01"],
     AutoSpacing->False],
    Z[
     LI[0], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;2\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;2", "-2,2,-1"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "21"],
     AutoSpacing->False],
    Z[
     LI[2], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;4\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;4", "-2,2,-1"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "41"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;4\"\>", "\<\"2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;4", "2,2,-1"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"2", "2", "2", "2"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", "    "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {2, -spherical}, {2, -spherical}, {2, -spherical}, {
     2, -spherical}],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"23728741-18b2-4908-95c2-4dbab59bdfb5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "coeffERule"}]], \
"Input",ExpressionUUID->"8ce0a855-d963-43d8-9485-0a959d6e132f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["3", "7"], " ", 
   SqrtBox[
    FractionBox["15", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "21"],
     AutoSpacing->False],
    Z[
     LI[2], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "28"], " ", 
   SqrtBox[
    FractionBox["5", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "41"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "84"], " ", 
   SqrtBox[
    FractionBox["5", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", 
      RowBox[{"  ", 
       StyleBox[
        RowBox[{"2", "2", "2", "2"}],
        FontColor->RGBColor[1, 0, 0]]}], 
      RowBox[{"41", "    "}]],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1], {2, -spherical}, {2, -spherical}, {2, -spherical}, {
     2, -spherical}],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"32e96fd0-6919-42b0-9ca7-cda804ae4a44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{
  "%", "//", 
   "HarmonicComponent"}]}]], \
"Input",ExpressionUUID->"97197260-59dd-4fab-a242-c3fc08ef98fb"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"15", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], 
   RowBox[{
   "8", " ", 
    "\[Pi]"}]]}]], \
"Output",ExpressionUUID->"a906701f-fedd-447e-8123-e31de6315b8b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"r1", "-", "r2"}], 
  "]"}]], "Input",ExpressionUUID->"a7b0ee7f-2082-48fb-b138-543f4b2766ad"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"3c2063e5-345f-4922-bd0c-1c40b1f08dfe"]
}, Open  ]],

Cell["Example 4. Equal numbers of indices and contracted indices:", \
"Text",ExpressionUUID->"70761dbd-0798-4e13-ab02-2428eed25a7b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expression", "=", 
  RowBox[{
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "2", "]"}], ",", 
     RowBox[{"LI", "[", 
      RowBox[{"-", "1"}], "]"}], ",", 
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], 
   RowBox[{"X", "[", 
    RowBox[{
     RowBox[{"LI", "[", "2", "]"}], ",", 
     RowBox[{"LI", "[", "2", "]"}], ",", "a", ",", "b"}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"21eb48c3-699a-4e78-bfe3-cb0c2944a1e6"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", 
     RowBox[{"  ", "ab"}], 
     RowBox[{"2", "-", "1", "  "}]],
    AutoSpacing->False],
   X[
    LI[2], 
    LI[-1], -a, -b],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", "    ", 
     RowBox[{"22", "ab"}]],
    AutoSpacing->False],
   X[
    LI[2], 
    LI[2], a, b],
   Editable->
    False]}]], "Output",ExpressionUUID->"82e97546-0f14-445e-9ead-19db885aac09"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{
  "expression", "//", 
   "HarmonicComponent"}]}]], \
"Input",ExpressionUUID->"3d48b2b5-618a-42a5-9912-bd6090790cc4"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"15", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"15", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"3", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}], ")"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], 
   RowBox[{
   "32", " ", 
    "\[Pi]"}]]}]], \
"Output",ExpressionUUID->"ac9c8f0b-a5cd-4aec-9d0a-ae2dd7c75f79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expression", "/.", 
  "ProductRule"}]], \
"Input",ExpressionUUID->"84d62deb-b796-421b-b39e-49d50a95ed72"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;0\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;0", "-2,2,-1"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "01"],
     AutoSpacing->False],
    Z[
     LI[0], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;2\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;2", "-2,2,-1"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "21"],
     AutoSpacing->False],
    Z[
     LI[2], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{"2", " ", 
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"2,2,2;4\"\>", "\<\"-2,2,-1\"\>"],
    Subsuperscript["E", "2,2,2;4", "-2,2,-1"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "41"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"ca9b5f20-853c-446e-b2ed-69dd6d93570c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "coeffERule"}]], \
"Input",ExpressionUUID->"708f4e8f-4d6a-4bda-bf23-223c26d85dc7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["6", "7"], " ", 
   SqrtBox[
    FractionBox["30", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "21"],
     AutoSpacing->False],
    Z[
     LI[2], 
     LI[1]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "7"], " ", 
   SqrtBox[
    FractionBox["5", "\[Pi]"]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "41"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[1]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"d1ad995b-6770-41ef-9676-87378af79d31"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{
  "%", "//", 
   "HarmonicComponent"}]}]], \
"Input",ExpressionUUID->"1f21ba9b-f983-4356-ac20-1a979feefc88"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"15", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["\[Phi]", "", ""],
        AutoSpacing->False],
       \[Phi][],
       Editable->False]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"15", " ", 
       RowBox[{
        InterpretationBox[
         StyleBox["Cos",
          AutoSpacing->False],
         Cos,
         Editable->False], "[", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False], "]"}]}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox["Cos",
         AutoSpacing->False],
        Cos,
        Editable->False], "[", 
       RowBox[{"3", " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["\[Theta]", "", ""],
          AutoSpacing->False],
         \[Theta][],
         Editable->False]}], "]"}]}], ")"}], " ", 
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}]}], 
   RowBox[{
   "32", " ", 
    "\[Pi]"}]]}]], \
"Output",ExpressionUUID->"422ea8bc-d2a9-4876-a2c1-97deb64e4070"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"r1", "-", "r2"}], 
  "]"}]], "Input",ExpressionUUID->"720333bd-7eb9-4226-826a-6bc8c13be2fe"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"a4ece1e8-7eb5-43c5-a09b-7b9b81ff454e"]
}, Open  ]],

Cell["Example 5, with scalar harmonics:", \
"Text",ExpressionUUID->"8ea12052-7485-44a0-9f4e-43afb9bd13d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "3", "]"}], ",", 
     RowBox[{"LI", "[", "2", "]"}]}], "]"}], 
   RowBox[{"Z", "[", 
    RowBox[{
     RowBox[{"LI", "[", "3", "]"}], ",", 
     RowBox[{"LI", "[", "2", "]"}]}], "]"}]}], "/.", 
  "ProductRule"}]], \
"Input",ExpressionUUID->"64fb3ad4-82e5-420a-a571-85a1b75ad7a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"0,3,2;0\"\>", "\<\"0,3,2\"\>"],
    Subsuperscript["E", "0,3,2;0", "0,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "04"],
     AutoSpacing->False],
    Z[
     LI[0], 
     LI[4]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"0,3,2;1\"\>", "\<\"0,3,2\"\>"],
    Subsuperscript["E", "0,3,2;1", "0,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "14"],
     AutoSpacing->False],
    Z[
     LI[1], 
     LI[4]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"0,3,2;2\"\>", "\<\"0,3,2\"\>"],
    Subsuperscript["E", "0,3,2;2", "0,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "24"],
     AutoSpacing->False],
    Z[
     LI[2], 
     LI[4]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"0,3,2;3\"\>", "\<\"0,3,2\"\>"],
    Subsuperscript["E", "0,3,2;3", "0,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "34"],
     AutoSpacing->False],
    Z[
     LI[3], 
     LI[4]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"0,3,2;4\"\>", "\<\"0,3,2\"\>"],
    Subsuperscript["E", "0,3,2;4", "0,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "44"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[4]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"0,3,2;5\"\>", "\<\"0,3,2\"\>"],
    Subsuperscript["E", "0,3,2;5", "0,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "54"],
     AutoSpacing->False],
    Z[
     LI[5], 
     LI[4]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    SubsuperscriptBox["\<\"E\"\>", "\<\"0,3,2;6\"\>", "\<\"0,3,2\"\>"],
    Subsuperscript["E", "0,3,2;6", "0,3,2"],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "64"],
     AutoSpacing->False],
    Z[
     LI[6], 
     LI[4]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"2bc65672-d5bc-41e9-bdd7-52b426b38565"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "coeffERule"}]], \
"Input",ExpressionUUID->"7a2c9c26-2615-433d-b8d9-f96baace4a0a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "11"], " ", 
   SqrtBox[
    FractionBox["35", 
     RowBox[{"2", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "44"],
     AutoSpacing->False],
    Z[
     LI[4], 
     LI[4]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["5", "11"], " ", 
   SqrtBox[
    FractionBox["14", 
     RowBox[{"13", " ", "\[Pi]"}]]], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["Z", "  ", "64"],
     AutoSpacing->False],
    Z[
     LI[6], 
     LI[4]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"33df0332-85c0-403d-9114-d63448847a7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "HarmonicComponent"}]], \
"Input",ExpressionUUID->"e0c4523e-4919-4aa9-a4d6-12e17b49c229"],

Cell[BoxData[
 FractionBox[
  RowBox[{"105", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"4", " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False]}]], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "4"]}], 
  RowBox[{
  "32", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"1a3c1f12-e2c1-4410-b270-e099af809601"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SphericalHarmonicY", "[", 
   RowBox[{"3", ",", "2", ",", 
    RowBox[{"\[Theta]", "[", "]"}], ",", 
    RowBox[{"\[Phi]", "[", "]"}]}], "]"}], "^", 
  "2"}]], "Input",ExpressionUUID->"91cedb8e-93fc-473f-8bc3-7edd00d8da59"],

Cell[BoxData[
 FractionBox[
  RowBox[{"105", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"4", " ", "\[ImaginaryI]", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Phi]", "", ""],
       AutoSpacing->False],
      \[Phi][],
      Editable->False]}]], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Cos",
       AutoSpacing->False],
      Cos,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{
     InterpretationBox[
      StyleBox["Sin",
       AutoSpacing->False],
      Sin,
      Editable->False], "[", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Theta]", "", ""],
       AutoSpacing->False],
      \[Theta][],
      Editable->False], "]"}], "4"]}], 
  RowBox[{
  "32", " ", 
   "\[Pi]"}]]], \
"Output",ExpressionUUID->"70240790-b413-4475-a7ac-02eadc8a1acc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", "-", "%%"}], 
  "]"}]], "Input",ExpressionUUID->"254bfbb9-cd16-4941-b6f7-ab2fb0377d53"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"de0858a9-3629-4df0-b1d8-d622f20fe372"]
}, Open  ]],

Cell["Example 6, with an epsilon term:", \
"Text",ExpressionUUID->"8d0d53a3-95ad-47a9-8c23-d9be1bc09828"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Z", "[", 
   RowBox[{
    RowBox[{"LI", "[", "4", "]"}], ",", 
    RowBox[{"LI", "[", "3", "]"}], ",", "a", ",", "b"}], "]"}], 
  RowBox[{"X", "[", 
   RowBox[{
    RowBox[{"LI", "[", "4", "]"}], ",", 
    RowBox[{"LI", "[", "3", "]"}], ",", "c", ",", "d"}], 
   "]"}]}]], "Input",ExpressionUUID->"19323a60-05d3-444b-b6b8-50983892e0d7"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["X", "    ", 
     RowBox[{"43", "cd"}]],
    AutoSpacing->False],
   X[
    LI[4], 
    LI[3], c, d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["Z", "    ", 
     RowBox[{"43", "ab"}]],
    AutoSpacing->False],
   Z[
    LI[4], 
    LI[3], a, b],
   Editable->
    False]}]], "Output",ExpressionUUID->"6f3bf35d-8e74-48fe-8981-be7246f8556b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  "ProductRule"}]], \
"Input",ExpressionUUID->"9f23ad6e-22b1-434e-bd25-75c0d9d27bfc"],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", 
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;4\"\>", "\<\"2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;4", "2,4,3"],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["X", "      ", 
        RowBox[{"46", "abcd"}]],
       AutoSpacing->False],
      X[
       LI[4], 
       LI[6], a, b, c, d],
      Editable->False]}], "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;6\"\>", "\<\"2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;6", "2,4,3"],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["X", "      ", 
        RowBox[{"66", "abcd"}]],
       AutoSpacing->False],
      X[
       LI[6], 
       LI[6], a, b, c, d],
      Editable->False]}], "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;8\"\>", "\<\"2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;8", "2,4,3"],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["X", "      ", 
        RowBox[{"86", "abcd"}]],
       AutoSpacing->False],
      X[
       LI[8], 
       LI[6], a, b, c, d],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;0\"\>", "\<\"-2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;0", "-2,4,3"],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "c"],
           AutoSpacing->False],
          m[c],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "d"],
          AutoSpacing->False],
         m[d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "a"],
          AutoSpacing->False],
         mbar[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "b"],
          AutoSpacing->False],
         mbar[b],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "a"],
          AutoSpacing->False],
         m[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "b"],
          AutoSpacing->False],
         m[b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "c"],
          AutoSpacing->False],
         mbar[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "d"],
          AutoSpacing->False],
         mbar[d],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "  ", "06"],
       AutoSpacing->False],
      Z[
       LI[0], 
       LI[6]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;1\"\>", "\<\"-2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;1", "-2,4,3"],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "c"],
          AutoSpacing->False],
         m[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "d"],
          AutoSpacing->False],
         m[d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "a"],
          AutoSpacing->False],
         mbar[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "b"],
          AutoSpacing->False],
         mbar[b],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "a"],
          AutoSpacing->False],
         m[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "b"],
          AutoSpacing->False],
         m[b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "c"],
          AutoSpacing->False],
         mbar[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "d"],
          AutoSpacing->False],
         mbar[d],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "  ", "16"],
       AutoSpacing->False],
      Z[
       LI[1], 
       LI[6]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;2\"\>", "\<\"-2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;2", "-2,4,3"],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "c"],
           AutoSpacing->False],
          m[c],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "d"],
          AutoSpacing->False],
         m[d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "a"],
          AutoSpacing->False],
         mbar[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "b"],
          AutoSpacing->False],
         mbar[b],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "a"],
          AutoSpacing->False],
         m[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "b"],
          AutoSpacing->False],
         m[b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "c"],
          AutoSpacing->False],
         mbar[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "d"],
          AutoSpacing->False],
         mbar[d],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "  ", "26"],
       AutoSpacing->False],
      Z[
       LI[2], 
       LI[6]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;3\"\>", "\<\"-2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;3", "-2,4,3"],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "c"],
          AutoSpacing->False],
         m[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "d"],
          AutoSpacing->False],
         m[d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "a"],
          AutoSpacing->False],
         mbar[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "b"],
          AutoSpacing->False],
         mbar[b],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "a"],
          AutoSpacing->False],
         m[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "b"],
          AutoSpacing->False],
         m[b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "c"],
          AutoSpacing->False],
         mbar[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "d"],
          AutoSpacing->False],
         mbar[d],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "  ", "36"],
       AutoSpacing->False],
      Z[
       LI[3], 
       LI[6]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;4\"\>", "\<\"-2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;4", "-2,4,3"],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "c"],
           AutoSpacing->False],
          m[c],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "d"],
          AutoSpacing->False],
         m[d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "a"],
          AutoSpacing->False],
         mbar[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "b"],
          AutoSpacing->False],
         mbar[b],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "a"],
          AutoSpacing->False],
         m[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "b"],
          AutoSpacing->False],
         m[b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "c"],
          AutoSpacing->False],
         mbar[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "d"],
          AutoSpacing->False],
         mbar[d],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "  ", "46"],
       AutoSpacing->False],
      Z[
       LI[4], 
       LI[6]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;5\"\>", "\<\"-2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;5", "-2,4,3"],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "c"],
          AutoSpacing->False],
         m[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "d"],
          AutoSpacing->False],
         m[d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "a"],
          AutoSpacing->False],
         mbar[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "b"],
          AutoSpacing->False],
         mbar[b],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "a"],
          AutoSpacing->False],
         m[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "b"],
          AutoSpacing->False],
         m[b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "c"],
          AutoSpacing->False],
         mbar[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "d"],
          AutoSpacing->False],
         mbar[d],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "  ", "56"],
       AutoSpacing->False],
      Z[
       LI[5], 
       LI[6]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;6\"\>", "\<\"-2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;6", "-2,4,3"],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "c"],
           AutoSpacing->False],
          m[c],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "d"],
          AutoSpacing->False],
         m[d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "a"],
          AutoSpacing->False],
         mbar[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "b"],
          AutoSpacing->False],
         mbar[b],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "a"],
          AutoSpacing->False],
         m[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "b"],
          AutoSpacing->False],
         m[b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "c"],
          AutoSpacing->False],
         mbar[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "d"],
          AutoSpacing->False],
         mbar[d],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "  ", "66"],
       AutoSpacing->False],
      Z[
       LI[6], 
       LI[6]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;7\"\>", "\<\"-2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;7", "-2,4,3"],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "c"],
          AutoSpacing->False],
         m[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "d"],
          AutoSpacing->False],
         m[d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "a"],
          AutoSpacing->False],
         mbar[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "b"],
          AutoSpacing->False],
         mbar[b],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "a"],
          AutoSpacing->False],
         m[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "b"],
          AutoSpacing->False],
         m[b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "c"],
          AutoSpacing->False],
         mbar[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "d"],
          AutoSpacing->False],
         mbar[d],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "  ", "76"],
       AutoSpacing->False],
      Z[
       LI[7], 
       LI[6]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;8\"\>", "\<\"-2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;8", "-2,4,3"],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[
           SubsuperscriptBox["m", " ", "c"],
           AutoSpacing->False],
          m[c],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "d"],
          AutoSpacing->False],
         m[d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "a"],
          AutoSpacing->False],
         mbar[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "b"],
          AutoSpacing->False],
         mbar[b],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "a"],
          AutoSpacing->False],
         m[a],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["m", " ", "b"],
          AutoSpacing->False],
         m[b],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "c"],
          AutoSpacing->False],
         mbar[c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox[
           OverscriptBox["m", "_"], " ", "d"],
          AutoSpacing->False],
         mbar[d],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "  ", "86"],
       AutoSpacing->False],
      Z[
       LI[8], 
       LI[6]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;5\"\>", "\<\"2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;5", "2,4,3"],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "      ", 
        RowBox[{"56", "abcd"}]],
       AutoSpacing->False],
      Z[
       LI[5], 
       LI[6], a, b, c, d],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      SubsuperscriptBox["\<\"E\"\>", "\<\"2,4,3;7\"\>", "\<\"2,4,3\"\>"],
      Subsuperscript["E", "2,4,3;7", "2,4,3"],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["Z", "      ", 
        RowBox[{"76", "abcd"}]],
       AutoSpacing->False],
      Z[
       LI[7], 
       LI[6], a, b, c, d],
      Editable->False]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"e3e6eb63-bf99-493c-b2c0-b81f4cae4d07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", "coeffERule"}], "//", 
  "Simplification"}]], \
"Input",ExpressionUUID->"bff7079e-fea6-4063-9752-bd7e04372d35"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "170"], " ", 
  SqrtBox[
   FractionBox["3", 
    RowBox[{"143", " ", "\[Pi]"}]]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"17", " ", 
     SqrtBox["7"], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["X", "      ", 
        RowBox[{"66", "abcd"}]],
       AutoSpacing->False],
      X[
       LI[6], 
       LI[6], a, b, c, d],
      Editable->False]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["17"], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["X", "      ", 
           RowBox[{"86", "abcd"}]],
          AutoSpacing->False],
         X[
          LI[8], 
          LI[6], a, b, c, d],
         Editable->False]}], "-", 
       RowBox[{"15", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["m", " ", "c"],
             AutoSpacing->False],
            m[c],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[
             SubsuperscriptBox["m", " ", "d"],
             AutoSpacing->False],
           