Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Invar package",
 FontColor->RGBColor[
  1, 0, 0]]], "Title",ExpressionUUID->"ec25d7be-9eb7-4658-9a20-eececdd44ac0"],

Cell[TextData[StyleBox["Manipulation of the invariants of Riemann tensors",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subtitle",ExpressionUUID->"b77e7ebe-8881-4a8c-a332-f6b288ccba8c"],

Cell[TextData[{
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a",
  FontSize->18],
 "     jose@xact.es\n\n",
 StyleBox["David Yllanes",
  FontSize->18],
 "     yllanes@xact.es\nUniversidad Complutense de Madrid\n\n",
 StyleBox["Renato Portugal",
  FontSize->18],
 "     \nLaborat\[OAcute]rio Nacional de Computa\[CCedilla]\[ATilde]o Cient\
\[IAcute]fica, Petr\[OAcute]polis, Brazil\n\n(c) 2006-2026, under GPL\n\n\
http://www.xact.es/\n\nhttp://groups.google.com/group/xAct"
}], "Subsubtitle",ExpressionUUID->"c0fc6ce9-9768-4dec-b20f-c6793d35d919"],

Cell[CellGroupData[{

Cell["Set up of the system", \
"Section",ExpressionUUID->"8522c4c4-0d03-464a-a6e5-2b098eba0200"],

Cell[CellGroupData[{

Cell[BoxData["Today"], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"1d971749-77f7-4a0b-8b3e-09e120a2dd93"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Mon 29 Dec 2025\""}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{"2025", ",", "12", ",", "29"}], "}"}], ",", "\"Day\""}], 
     "]"}]},
  "DateObject",
  Editable->False]], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"4c9f937b-4a44-46ec-99c5-b023d482fd7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`Invar`$Version", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<2.0.5\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2014", ",", "2", ",", "15"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[2]:=",ExpressionUUID->"77060086-c808-4ef6-a0c7-4c8253b8ded4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"2.0.5\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2014", ",", "2", ",", "15"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",ExpressionUUID->"a2f5420e-621c-4471-b5cd-03b104e3aa60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`Invar`$xTensorVersionExpected", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<1.1.0\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2013", ",", "9", ",", "1"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[3]:=",ExpressionUUID->"d5c5c2b3-6cbf-49b1-93f6-bb2e32fb0223"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1.1.0\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2013", ",", "9", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",ExpressionUUID->"4c06731d-6095-4f94-b543-c42fdcd6f5d0"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "spell1"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"f0a286de-e435-4647-815d-066d38ffe037"],

Cell[CellGroupData[{

Cell["TODO", \
"Subsection",ExpressionUUID->"47e622dd-d408-458c-9702-3edc8e0f5041"],

Cell["\<\
- Nondual invariants can be handled in any dimension, but so far dual \
invariants only work in dimension 4. Generalize that. Answer to Teake in the \
group (16 June 2011): \[OpenCurlyDoubleQuote]And I agree that the codes of \
Invar2 would require slight generalizations to be able to generate and deal \
with the databases for dual invariants in dimensions other than 4, for those \
cases in which it makes sense. I just had a look at Invar.m and I see that \
the
private function riemannof is the only place where dimension 4 is hardwired. \
The function InvSimplify has also the error message \
\[OpenCurlyDoubleQuote]Duals
are only handled in dimension 4.\[CloseCurlyDoubleQuote], which would have to \
be removed. Finally, some bookkeeping functions like MaxDualIndex would have to
take an additional dimension argument. I think that\[CloseCurlyQuote]s all.\
\[CloseCurlyDoubleQuote]\
\>", "Text",ExpressionUUID->"a5be9bbf-74a9-4ad1-9d32-93d2176f8f53"]
}, Closed]],

Cell[CellGroupData[{

Cell["GPL", \
"Subsection",ExpressionUUID->"77949ac6-8b44-43ac-a53a-fecc21daee11"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Invar", ",", " ", 
    RowBox[{
    "a", " ", "free", " ", "package", " ", "for", " ", "simplification", " ", 
     "of", " ", "Riemann", " ", "invariants"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Copyright", " ", 
      RowBox[{"(", "C", ")"}], " ", "2006"}], "-", 
     RowBox[{"2026", " ", "Jose", " ", 
      RowBox[{"M", ".", " ", "Martin"}]}], "-", "Garcia"}], ",", " ", 
    RowBox[{
     RowBox[{"D", ".", " ", "Yllanes"}], " ", "and", " ", "Renato", " ", 
     "Portugal"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", "\[IndentingNewLine]", " ", 
      "it", " ", "under", " ", "the", " ", "terms", " ", "of", " ", "the", " ",
       "GNU", " ", "General", " ", "Public", " ", "License", " ", "as", " ", 
      "published", "\[IndentingNewLine]", " ", "by", " ", "the", " ", "Free", 
      " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], " ",
      "program", " ", "is", " ", "distributed", " ", "in", " ", "the", " ", 
     "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", "useful"}], 
    ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", " ", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", "\[IndentingNewLine]",
       " ", "General", " ", "Public", " ", "License", " ", "for", " ", "more",
       " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], " ",
       "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ", 
      "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", "\[IndentingNewLine]", " ", "along", " ", "with", " ", 
      "this", " ", "program"}], ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", "\[IndentingNewLine]",
      " ", "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[6]:=",ExpressionUUID->"b3972d9c-7edb-4d2d-b934-4360a46a0e60"]
}, Closed]],

Cell[CellGroupData[{

Cell["Info package", \
"Subsection",ExpressionUUID->"3e19280f-a73f-43ad-a595-6d7f238192ca"],

Cell["\<\
(* :Title: Invar *)

(* :Authors: Jose M. Martin-Garcia, David Yllanes and Renato Portugal *)

(* :Summary: Free package for simplification of Riemann invariants *)

(* :Brief Discussion:
   - Based on xTensor.
   - There is a companion version for Maple (using Canon) by Renato
     Portugal.
   - Simplifies Riemann invariants (scalars formed from the Riemann
     tensor of a metric-compatible connection and its Levi-Civita
     connection) by using permutation group theory.
   - Multiterm symmetries (cyclic, Bianchi, commutation and
     dimension-dependent identities) have been solved in advance
     and stored in solution-files.
   - Works with Riemann, Ricci, RicciScalar, Weyl and TFRicci.
*)
  
(* :Context: xAct`Invar` *)

(* :Package Version: 2.0.5 *)

(* :Copyright: Jose M. Martin-Garcia and David Yllanes (2006-2026) *)

(* :History: 
\t- 22 Nov 2006 - Invar1
\t-  8 Feb 2008 - Invar2
*)

(* :Keywords: *)

(* :Source: Invar.nb *)

(* :Warning: *)

(* :Mathematica Version: 6.0 and later *)

(* :Limitations:
   - Handles algebraic invariants with up to seven Riemann tensors
     or dual invariants with up to five Riemann tensors
   - Handles differential invariants with up to twelve metric derivatives
     or dual invariants with up to eight metric derivatives *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellLabel->"In[7]:=",ExpressionUUID->"20dd9915-667c-4d27-97ca-e65479d09424"]
}, Closed]],

Cell[CellGroupData[{

Cell["Begin package", \
"Subsection",ExpressionUUID->"155b01c7-7816-4155-941d-fcd1aa77b01c"],

Cell["Protect against multiple loading of the package:", \
"Text",ExpressionUUID->"e3a205e7-940c-4e1e-af7a-2df596b79391"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xAct`Invar`Private`InvarSymbols", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Names", "[", "\"\<xAct`Invar`*\>\"", "]"}], ",", 
         RowBox[{"Names", "[", "\"\<xAct`Invar`Private`*\>\"", "]"}]}], "]"}],
        ",", 
       RowBox[{"\"\<$Version\>\"", "|", "\"\<xAct`Invar`$Version\>\"", 
        "|", "\"\<$xTensorVersionExpected\>\"", 
        "|", "\"\<xAct`Invar`$xTensorVersionExpected\>\""}]}], "]"}]}], "}"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "/@", "xAct`Invar`Private`InvarSymbols"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Clear", "/@", "xAct`Invar`Private`InvarSymbols"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[32]:=",ExpressionUUID->"cb49e6fa-ab28-4f03-9391-450d00f67c88"],

Cell[TextData[{
 "Explicit (not hidden) import of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". QUESTION: Do we really need ExpressionManipulation?"
}], "Text",ExpressionUUID->"d1267a5f-6fb0-40fa-a934-6907501ff3e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{"xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`Invar`\>\""}]}],
    "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[33]:=",ExpressionUUID->"9f91014c-f813-4175-81e6-5ae382a0265d"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"8aace0b6-e64b-4e02-a0f6-b0dbb6ebe346"],

Cell[BoxData["\<\"xAct`Invar`\"\>"], "Output",
 CellLabel->
  "Out[34]=",ExpressionUUID->"2deb3a03-6766-4f66-acf2-056e3a40a541"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`Invar`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", 
     ",", "\"\<xAct`xCore`\>\"", 
     ",", "\"\<xAct`ExpressionManipulation`\>\""}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[35]:=",ExpressionUUID->"78478f84-a65c-43fa-b895-a91bcc8011f7"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"7f9aee5f-35ff-4e60-bf3e-389643986c2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.4", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"14ebc6a3-e87f-4665-9383-dd315baf6090"],

Cell[BoxData["\<\"CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"3df1e5bc-5f53-41e1-b4c0-73a8ffb68a81"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"b20380f5-2ac2-45aa-b020-d1032358b18e"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"f1cee8b7-6555-459c-86e6-978481003c29"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"3e3120b9-dd64-4a42-b331-e9bfeaf8418e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.3.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.3.0", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"ec39300a-a807-429b-a2ea-f1e05a0e1d43"],

Cell[BoxData["\<\"CopyRight (C) 2002-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"8e6142b9-0896-4b0f-8c0f-89f1e00bc44a"]
}, Open  ]],

Cell[BoxData["\<\"xAct`Invar`\"\>"], "Output",
 CellLabel->
  "Out[35]=",ExpressionUUID->"9c15900c-ecc7-458c-a270-b9dbfad1df87"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"62abd090-36de-4ca6-9cf3-f5d253a3eada"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`Invar`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`ExpressionManipulation`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[36]=",ExpressionUUID->"f7639239-7302-4c42-b859-f2ad47b6c39a"]
}, Open  ]],

Cell[TextData[{
 "Check version of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". We simply compare dates:"
}], "Text",ExpressionUUID->"3d676470-740c-4470-9a1c-a9499410352d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "xTensorVersion"}], 
   "=", "\"\<Loaded xTensor version `1` but expected version `2` at \
least.\>\""}], ";"}], "\n", 
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Not", "@", 
    RowBox[{"OrderedQ", "@", 
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"{", 
        RowBox[{"$xTensorVersionExpected", ",", "xAct`xTensor`$Version"}], 
        "}"}]}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"General", "::", "xTensorVersion"}], ",", 
      "xAct`xTensor`$Version", ",", "$xTensorVersionExpected"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Abort", "[", "]"}]}]}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[37]:=",ExpressionUUID->"c9136402-e07c-49b6-a9e8-00ab9fac1b90"],

Cell["Message:", \
"Text",ExpressionUUID->"a7ea7f8a-4d05-4af9-8068-5fc3aadff4cd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`Invar`  version \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{"Print", 
  "[", "\"\<CopyRight (C) 2006-2026, J. M. Martin-Garcia, D. Yllanes and R. \
Portugal, under the General Public License.\>\"", "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[39]:=",ExpressionUUID->"949cc9f0-aab8-44dc-8a64-d106de700ace"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"818c3644-78f0-4a83-8622-83b409fc0e4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Invar`  version \"\>", 
   "\[InvisibleSpace]", "\<\"2.0.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2014", ",", "2", ",", "15"}], "}"}]}],
  SequenceForm["Package xAct`Invar`  version ", "2.0.5", ", ", {2014, 2, 15}],
  
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"34420170-3c67-4ab6-a05c-d7c33c4b31f1"],

Cell[BoxData["\<\"CopyRight (C) 2006-2026, J. M. Martin-Garcia, D. Yllanes \
and R. Portugal, under the General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"284d8fac-3a1f-4d7a-94b9-4e9629b5255e"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We specify the context xAct`Invar` to avoid overriding the Disclaimer's of \
xTensor and xPerm. However we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"ee110ca9-ad28-46c7-ad5e-02a23db9b860"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`Invar`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[42]:=",ExpressionUUID->"816c73e2-7dbd-4fba-8a7f-d690eaea1623"],

Cell[TextData[{
 "If ",
 StyleBox["Invar",
  FontSlant->"Italic"],
 " is the last package begin read, print the GPL message:"
}], "Text",ExpressionUUID->"988124d2-e5f3-4b2f-aa7d-a63482c7deaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`Invar`\>\""}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Print", "[", "\"\<These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\>\"", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[45]:=",ExpressionUUID->"b8503bda-991e-4592-94ea-676ea9a8ef02"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"8347f1b0-1bf6-4bf8-b2a8-bda866b091e8"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"7025a044-32dc-47f0-bd7d-44d466aab228"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"a07d00e3-38fb-4b8a-8305-cd0ed24b01a4"]
}, Open  ]]
}, Open  ]],

Cell["We already have these symbols:", \
"Text",ExpressionUUID->"df45af11-d034-4c89-977d-e14d2a293d0e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "xAct`Invar`*"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"46717c2b-094c-4017-9d39-9ed4d6e9aa14"],

Cell[BoxData[
 StyleBox[
  FrameBox[GridBox[{
     {
      DynamicModuleBox[{Typeset`open$$ = True}, 
       PaneSelectorBox[{False->
        ButtonBox[
         RowBox[{
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "RightPointerOpener"]], " ", 
          StyleBox["xAct`Invar`", "InformationGridGroupHeader"]}],
         Appearance->None,
         BaseStyle->"InformationGridLink",
         ButtonFunction:>FEPrivate`Set[Typeset`open$$, True],
         Evaluator->Automatic,
         Method->"Preemptive"], True->
        PaneBox[GridBox[{
           {
            ButtonBox[
             RowBox[{
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {2.134033203125, 7.865966796875}}], " ", 
              
              StyleBox["xAct`Invar`", "InformationGridGroupHeader"]}],
             Appearance->None,
             BaseStyle->"InformationGridLink",
             ButtonFunction:>FEPrivate`Set[Typeset`open$$, False],
             Evaluator->Automatic,
             Method->"Preemptive"]},
           {
            PaneBox[GridBox[{
               {
                ButtonBox[
                 StyleBox["Disclaimer", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-1f703eb0-e625-4049-a0bc-28f89223efaf", {
                   "Disclaimer", "xAct`Invar`"}, False},
                 ButtonNote->"xAct`Invar`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$Version", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-1f703eb0-e625-4049-a0bc-28f89223efaf", {
                   "$Version", "xAct`Invar`"}, False},
                 ButtonNote->"xAct`Invar`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$xTensorVersionExpected", "InformationGridButton"],
                 
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-1f703eb0-e625-4049-a0bc-28f89223efaf", {
                   "$xTensorVersionExpected", "xAct`Invar`"}, False},
                 ButtonNote->"xAct`Invar`",
                 Evaluator->Automatic]}
              },
              DefaultBaseStyle->"Text",
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{
                   Scaled[0.31666666666666665`]}}}],
             ImageMargins->{{10, 0}, {0, 2}}]}
          },
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
         FrameMargins->{{0, 0}, {8, 0}}]}, Dynamic[Typeset`open$$],
        ImageSize->Automatic]]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"ColumnsIndexed" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.8]}, 
        Offset[0.2]}}],
   BaseStyle->"InformationTitleFrame"], "InformationGridPlain"]], "Output",
 CellLabel->
  "Out[46]=",ExpressionUUID->"5183c2fa-f396-447c-aa4b-71f223042518"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Public functions", \
"Subsection",ExpressionUUID->"84d528e7-8634-4d81-9735-886c9934cfc2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"$InvarDirectory", "::", "usage"}], 
   "=", "\"\<$InvarDirectory is a global variable giving the directory in \
which the package file and the database can be found.\>\""}], ";"}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"da28e250-50c8-47e2-8eb0-eba7b4f19a90"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "::", "usage"}], 
   "=", "\"\<InvarCases[s, d] returns the list of cases of order (number of \
metric derivatives) s and degree (number of Riemanns) d. InvarCases[s] \
returns the list of cases of order s. InvarCases[] returns the list of all \
cases handled by Invar (currently the 47 cases up to order 12 plus the \
algebraic case of degree 7).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "::", "usage"}], 
   "=", "\"\<InvarDualCases[s, d] returns the list of dual cases of order \
(number of metric derivatives) s and degree (number of Riemanns) d in \
dimension 4. InvarDualCases[s] returns the list of dual cases of order s. \
InvarDualCases[] returns the list of all dual cases handled by Invar \
(currently the 14 cases up to order 8 plus the algebraic case of degree 5).\>\
\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3ebbbac9-257d-4e91-9ebb-e40ed30d6350"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInv", "::", "usage"}], 
   "=", "\"\<RInv[g][c, r] denotes the Riemann invariant of case c and index \
r associated to the metric g.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInv", "::", "usage"}], 
   "=", "\"\<DualRInv[g][c, r] denotes the dual Riemann invariant of case c \
and index r associated to the metric g.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RPerm", "::", "usage"}], 
   "=", "\"\<RPerm[g][{c, ed}, perm] denotes a Riemann invariant of case c \
with ed epsilon tensors (both associated to metric g), after reordering the \
indices from a canonical order using permutation perm.\>\""}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"dbb4156d-3d81-46bc-a71a-65013f6e881d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"WInv", "::", "usage"}], 
   "=", "\"\<WInv[g][c, r] denotes the Weyl invariant of case c and index r \
associated to the metric g.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualWInv", "::", "usage"}], 
   "=", "\"\<DualWInv[g][c, r] denotes the dual Weyl invariant of case c and \
index r associated to the metric g.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WPerm", "::", "usage"}], 
   "=", "\"\<WPermRPerm[g][{Rd, ed}, perm] denotes a Weyl invariant  formed \
by Rd Weyl tensors and ed epsilon tensors, after reordering the indices from \
a canonical order using permutation perm. Contracted Weyls encode the \
Traceless Ricci tensor.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"bbe23e0d-64b4-45b0-a8de-283dbee3ee64"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RToW", "::", "usage"}], 
   "=", "\"\<RToW[expr] transforms Riemann invariants into Weyl invariants in \
expression expr.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"WToR", "::", "usage"}], 
   "=", "\"\<WToR[expr] transforms Weyl invariants into Riemann invariants in \
expression expr.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RToWRules", "::", "usage"}], 
   "=", "\"\<RToWRules[step, degree]\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RToWDualRules", "::", "usage"}], 
   "=", "\"\<RToWDualRules[step, degree]\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"WToRRules", "::", "usage"}], 
   "=", "\"\<RToWRules[step, degree]\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"WToRDualRules", "::", "usage"}], 
   "=", "\"\<RToWDualRules[step, degree]\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"331e7e68-5e39-4f3a-9a0e-f5776f8bf3df"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInvs", "::", "usage"}], 
   "=", "\"\<RInvs[step, case] gives all independent Riemann invariants at \
the given step (1, 2, 3, 4, 5 or 6) and the given case. Using RInvs[g] \
instead of RInvs we get the particularization of the invariants to metric \
g.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WInvs", "::", "usage"}], 
   "=", "\"\<WInvs[step, case] gives all independent Weyl invariants at the \
given step (1, 2, 3, 4, 5, 6) and the given case. Using WInvs[g] instead of \
WInvs we get the particularization of the invariants to metric g.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvs", "::", "usage"}], 
   "=", "\"\<DualRInvs[step, case] gives all independent dual Riemann \
invariants at the given step (1, 2, 3, 4, 5 or 6) and the given case. Using \
DualRInvs[g] instead of RInvs we get the particularization of the dual \
invariants to metric g.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualWInvs", "::", "usage"}], 
   "=", "\"\<DualWInvs[step, case] gives all independent dual Weyl invariants \
at the given step (1, 2, 3, 4, 5 or 6) and the given case. Using DualWInvs[g] \
instead of WInvs we get the particularization of the dual invariants to \
metric g.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RInvRules", "::", "usage"}], 
   "=", "\"\<RInvRules[step, case] gives the list of rules to be used to \
simplify Riemann non-dual invariants of the given case at the given \
step.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WInvRules", "::", "usage"}], 
   "=", "\"\<WInvRules[step, case] gives the list of rules to be used to \
simplify Weyl non-dual invariants of the given case at the given step.\>\""}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvRules", "::", "usage"}], 
   "=", "\"\<DualRInvRules[step, case] gives the list of rules to be used to \
simplify Riemann dual invariants of the given case at the given step.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualWInvRules", "::", "usage"}], 
   "=", "\"\<DualWInvRules[step, case] gives the list of rules to be used to \
simplify Weyl dual invariants of the given case at the given step.\>\""}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"2e5aa017-fb61-4dc3-8b0e-89f7ce8b5d05"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RemoveRInvRules", "::", "usage"}], 
   "=", "\"\<RemoveRInvRules[step, case] removes the stored rules for the \
invariants of the given step and case.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveDualRInvRules", "::", "usage"}], 
   "=", "\"\<RemoveDualRInvRules[step, case] removes the stored rules for the \
dual invariants of the given step and case.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c13127f6-d8da-4e30-84a5-ab1342b7f266"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "::", "usage"}], 
   "=", "\"\<MaxIndex[step] gives the largest index of the non-dual \
invariants at the given step.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "::", "usage"}], 
   "=", "\"\<MaxDualIndex[step] gives the largest index of the dual \
invariants at the given step.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"1bc7a613-269d-4234-823e-1514685ad9b4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify", "::", "usage"}], 
   "=", "\"\<InvSimplify[expr, level] simplifies the invariants of the form \
inv[metric][case,count] in the expression expr, where inv is one of RInv, \
DualRInv, WInv, DualWInv. There are six possible levels of simplification: 1 \
means no simplification; 2 uses the cyclic identity; 3 uses the Bianchi \
identity; 4 commutes covariant derivatives; 5 uses dimensionally dependent \
(Lovelock type) identities and 6 reduces some non-dual invariants into \
products of dual invariants. The default level used in InvSimplify[expr] is \
$InvSimplifyLevel.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvToPerm", "::", "usage"}], 
   "=", "\"\<InvToPerm[expr] converts all invariants in expr into their \
corresponding permutations with head RPerm or WPerm.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermToRiemann", "::", "usage"}], 
   "=", "\"\<PermToRiemann[expr, cr] converts all permutations into their \
explicit tensor expressions. With cr=True contracted Riemann tensors are \
replaced by Ricci tensors. The default value used in PermToRiemann[expr] is \
$CurvatureRelations.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvToRiemann", "::", "usage"}], 
   "=", "\"\<InvToRiemann[expr, cr] converts all invariants into their \
explicit tensor expressions. With cr=True contracted Riemann tensors are \
replaced by Ricci tensors. The default value used in InvToRiemann[expr] is \
$CurvatureRelations.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannToPerm", "::", "usage"}], 
   "=", "\"\<RiemannToPerm[expr, g] converts all Riemann scalars of metric g \
into their canonical permutations. If g is a list of metrics then the command \
is folded over the list. RiemannToPerm[expr] is automatically converted into \
RiemannToPerm[expr, $Metrics].\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermToInv", "::", "usage"}], 
   "=", "\"\<PermToInv[expr] converts all permutations in expr into their \
correspondent invariants. It is assumed that the permutations have been \
already canonicalized.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannToInv", "::", "usage"}], 
   "=", "\"\<RiemannToInv[expr, g] converts all Riemann scalars of metric g \
into their invariant form. If g is a list of metrics then the command is \
folded over the list. RiemannToInv[expr] is automatically converted into \
RiemannToInv[expr, $Metrics].\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannSimplify", "::", "usage"}], 
   "=", "\"\<RiemannSimplify[expr, level, cr, g] simplifies the Riemann \
scalars of metric g using relations up to the given level (see usage message \
for InvSimplify). With cr=True contracted Riemann tensors are replaced by \
Ricci tensors. If g is a list of metrics then the command is folded over the \
list. RiemannSimplify[expr] uses the defaults $InvSimplifyLevel, \
$CurvatureRelations and $Metrics, respectively. See usage messages for those \
global variables.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b961ae9e-1432-4dff-9401-2e7022fb9aad"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dim", "::", "usage"}], 
   "=", "\"\<dim is a constant symbol used in the Invar rules to denote the \
dimension of a manifold.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sigma", "::", "usage"}], 
   "=", "\"\<sigma is a constant symbol used in the Invar rules to denote the \
sign of the determinant of a metric.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"1682175b-1bdf-44d1-b9cd-a205ff618635"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"$InvSimplifyLevel", "::", "usage"}], 
   "=", "\"\<$InvSimplifyLevel is a global variable specifying the default \
level of simplification in InvSimplify. Initially it is set to 6.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$CurvatureRelations", "::", "usage"}], 
   "=", "\"\<$CurvatureRelations is a global variable specifying the default \
behaviour of contracted Riemann conversion in the functions PermToRiemann, \
InvToRiemann and RiemannSimplify.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"71e6693f-f9d4-44b5-84fc-ba9cf33308f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RandomRiemannMonomial", "::", "usage"}], 
   "=", "\"\<RandomRiemannMonomial[c, g] generates a random monomial of case \
c with Riemann tensors of the metric g. If not specified, g is taken to be \
the first metric in the list $Metrics.\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"76acf86d-33b2-4ded-a9cd-f0c12366230d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"$ExpandedCommuteOrder12Q", "::", "usage"}], 
   "=", "\"\<$ExpandedRulesDiagonalQ is a Boolean global variable stating \
whether we want to use the expanded form for the Commute step of some hard \
cases of order 12. Its default value is False.\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d2f58395-373d-4676-a738-4c8c038365db"]
}, Closed]],

Cell[CellGroupData[{

Cell["Begin Private", \
"Subsection",ExpressionUUID->"f85a85d7-cebb-4482-863b-2278036e9a05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"02ecb36e-4ff6-4a26-a6a3-e7ddcf997ff5"],

Cell[BoxData["\<\"xAct`Invar`Private`\"\>"], \
"Output",ExpressionUUID->"08bbbbf7-4220-435c-828a-824153e289fe"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$InvarNames", "=", 
   RowBox[{"Names", "[", "\"\<xAct`Invar`*\>\"", "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"990b5d65-b9f4-491f-b44b-4a3d46f10efb"]
}, Closed]],

Cell[CellGroupData[{

Cell["sigma", \
"Subsection",ExpressionUUID->"5e8327e9-f9cd-438c-877a-1b7da33f37f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "sigma"}]], "Input",ExpressionUUID->"7e0bb0b7-4bdc-4573-b5ce-1ed18235aa9c"],

Cell[BoxData[
 StyleBox["\<\"sigma is a constant symbol used in the Invar rules to denote \
the sign of the determinant of a metric.\"\>", "MSG"]], "Print", "PrintUsage",
 
 CellTags->
  "Info3568108645-8679363",ExpressionUUID->"f9bb30b1-b1e3-4597-b5d5-\
42eadeb47aca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$InvarNames", "=", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"DefConstantSymbol", "[", 
    RowBox[{"sigma", ",", 
     RowBox[{"PrintAs", "\[Rule]", "\"\<\[Sigma]\>\""}]}], "]"}]}], 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4544ec6a-c335-4268-ba5c-dac7af09f785"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "sigma", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", "constant symbol ", 
   xAct`Invar`sigma, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"9c3ef4da-af18-499a-81b9-70b83620c069"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sigma", "/:", 
   RowBox[{"Power", "[", 
    RowBox[{"sigma", ",", 
     RowBox[{"_Integer", "?", "EvenQ"}]}], "]"}], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sigma", "/:", 
   RowBox[{"Power", "[", 
    RowBox[{"sigma", ",", 
     RowBox[{"_Integer", "?", "OddQ"}]}], "]"}], "=", "sigma"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sigma", "/:", 
   RowBox[{"Abs", "[", "sigma", "]"}], "=", "1"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"48a47228-35db-45f2-af4a-e8fd24169c79"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "dim"}]], "Input",ExpressionUUID->"3a5d0b7a-5927-4c9c-9c48-ab869d26ae20"],

Cell[BoxData[
 StyleBox["\<\"dim is a constant symbol used in the Invar rules to denote the \
dimension of a manifold.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3568108646-8679363",ExpressionUUID->"1f751461-c767-4a9d-8931-\
7fcb2d42c827"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$InvarNames", "=", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"DefConstantSymbol", "[", 
    RowBox[{"dim", ",", 
     RowBox[{"PrintAs", "->", "\"\<d\>\""}]}], "]"}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d18200ea-1674-4295-85c4-e1fa0566803f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "dim", "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", "constant symbol ", 
   xAct`Invar`dim, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"83395f0b-6f94-4334-b22f-ef51e12fed85"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Main setup", \
"Subsection",ExpressionUUID->"0baa6716-a2ce-4c54-a7c1-1cd9d35ce20b"],

Cell["Options:", \
"Text",ExpressionUUID->"96f59d01-3761-4526-aba3-58a9dd58a85e"],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], \
"Input",ExpressionUUID->"3a93269c-531a-4659-a8b9-d32bfe3f7f5f"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"490036fc-55bc-43f5-81b4-617720f4eee1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "CanonicalPerm", 
  "]"}]], "Input",ExpressionUUID->"2976bdd7-506f-4c2c-bde3-b1b3e3a357b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MathLink", "\[RuleDelayed]", "$xpermQ"}], ",", 
   RowBox[{"TimeVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"OrderedBase", "\[Rule]", "True"}]}], 
  "}"}]], "Output",ExpressionUUID->"b8522b48-5a89-4895-befe-ec49d496028d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "ToCanonical", 
  "]"}]], "Input",ExpressionUUID->"42bf6bb0-1d48-4a12-82bf-8bbe84a05a1c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Verbose", "\[Rule]", "False"}], ",", 
   RowBox[{"Notation", "\[Rule]", "Images"}], ",", 
   RowBox[{"UseMetricOnVBundle", "\[Rule]", "All"}], ",", 
   RowBox[{"ExpandChristoffel", "\[Rule]", "False"}], ",", 
   RowBox[{"GivePerm", "\[Rule]", "False"}], ",", 
   RowBox[{"Method", "\[Rule]", "ChangeCovD"}]}], 
  "}"}]], "Output",ExpressionUUID->"a88c1fb1-fa2a-4593-b6dd-a864e165f0a8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"ContractMetric", ",", 
    RowBox[{"AllowUpperDerivatives", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8041f718-abda-4592-80ce-e962ba6600e6"],

Cell["Default values for the global values of the package:", \
"Text",ExpressionUUID->"edf1001e-a31b-49d0-87ae-6b2e55c5e766"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$InvSimplifyLevel", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$CurvatureRelations", "=", "False"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b4a42a57-0bda-4e86-b924-de627923ba4d"],

Cell["Nonstandard configuration:", \
"Text",ExpressionUUID->"0b90c880-8451-4309-859a-384d081af934"],

Cell["These two are just aesthetical changes:", \
"Text",ExpressionUUID->"66d838f9-fb92-406b-a692-914f136fe811"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSet", "[", 
   RowBox[{"$PrePrint", ",", "ScreenDollarIndices"}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0e539a56-46a0-42e1-a8c8-0a2f9dacaeed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSet", "[", 
   RowBox[{"$CovDFormat", ",", "\"\<Postfix\>\""}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7c2d40e2-e132-4e68-80af-928482adc02b"],

Cell["\<\
JMM 2011: This is not well designed as $CurvatureRelations is not directly \
related to CurvatureRelations as other options are. $CurvatureRelations is \
information for the Riemann simplification functions, while Invar currently \
requires the option CurvatureRelations to be False. The proper solution is \
twofold:
\t1) Rename $CurvatureRelations to something else.
\t2) Make Invar work properly independently of the value of the option \
CurvatureRelations. Same thing happens with $CommuteCovDsOnScalars.
Currently we just sent a few warning messages when loading the package.\
\>", "Text",ExpressionUUID->"ba33bd0e-de57-430b-9455-201e549214ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"DefCovD", ",", 
    RowBox[{"CurvatureRelations", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"84fb1de5-1f2f-4001-8b79-eda5ffe7dd4b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSet", "[", 
   RowBox[{"$CommuteCovDsOnScalars", ",", "False"}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9bd1312e-2b67-41ce-9a07-d63790aab6a7"]
}, Closed]],

Cell[CellGroupData[{

Cell["Formatting of invariants", \
"Subsection",ExpressionUUID->"82aed95c-b3f3-4b23-a84a-26acec07dc13"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tostring", "[", "list_List", "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"ToString", "/@", "list"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5ae6d971-0ae9-4f38-af4d-d9b0f5330d79"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tostring", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"b4dc4033-99c3-43ef-b41d-6efdfe63c96a"],

Cell[BoxData["\<\"000\"\>"], \
"Output",ExpressionUUID->"b9ad10d0-2b1b-4ac0-8d54-eda9966d2e66"]
}, Open  ]],

Cell["Invariants with metric:", \
"Text",ExpressionUUID->"8257c7ee-6888-4769-846a-33d17a547f46"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{
     RowBox[{"RInv", "[", "_", "]"}], "[", 
     RowBox[{"case_", ",", "index_"}], "]"}], "]"}], ":=", 
   RowBox[{"Subscript", "[", 
    RowBox[{"\"\<I\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"tostring", "[", "case", "]"}], ",", "\"\<,\>\"", ",", 
       RowBox[{"ToString", "[", "index", "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{
     RowBox[{"DualRInv", "[", "_", "]"}], "[", 
     RowBox[{"case_", ",", "index_"}], "]"}], "]"}], ":=", 
   RowBox[{"Subscript", "[", 
    RowBox[{"\"\<D\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"tostring", "[", "case", "]"}], ",", "\"\<,\>\"", ",", 
       RowBox[{"ToString", "[", "index", "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{
     RowBox[{"WInv", "[", "_", "]"}], "[", 
     RowBox[{"case_", ",", "index_"}], "]"}], "]"}], ":=", 
   RowBox[{"Subscript", "[", 
    RowBox[{"\"\<W\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"tostring", "[", "case", "]"}], ",", "\"\<,\>\"", ",", 
       RowBox[{"ToString", "[", "index", "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{
     RowBox[{"DualWInv", "[", "_", "]"}], "[", 
     RowBox[{"case_", ",", "index_"}], "]"}], "]"}], ":=", 
   RowBox[{"Subscript", "[", 
    RowBox[{"\"\<X\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"tostring", "[", "case", "]"}], ",", "\"\<,\>\"", ",", 
       RowBox[{"ToString", "[", "index", "]"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"21254713-ca3a-4b62-ae5e-13820fde4eab"],

Cell["Invariants without metric :", \
"Text",ExpressionUUID->"97706c0f-6cad-4fdc-9c54-367c5f94e270"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{"RInv", "[", 
     RowBox[{"case_", ",", "index_"}], "]"}], "]"}], ":=", 
   RowBox[{"Subscript", "[", 
    RowBox[{"\"\<I\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"tostring", "[", "case", "]"}], ",", "\"\<,\>\"", ",", 
       RowBox[{"ToString", "[", "index", "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{"DualRInv", "[", 
     RowBox[{"case_", ",", "index_"}], "]"}], "]"}], ":=", 
   RowBox[{"Subscript", "[", 
    RowBox[{"\"\<D\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"tostring", "[", "case", "]"}], ",", "\"\<,\>\"", ",", 
       RowBox[{"ToString", "[", "index", "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{"WInv", "[", 
     RowBox[{"case_", ",", "index_"}], "]"}], "]"}], ":=", 
   RowBox[{"Subscript", "[", 
    RowBox[{"\"\<W\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"tostring", "[", "case", "]"}], ",", "\"\<,\>\"", ",", 
       RowBox[{"ToString", "[", "index", "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{"DualWInv", "[", 
     RowBox[{"case_", ",", "index_"}], "]"}], "]"}], ":=", 
   RowBox[{"Subscript", "[", 
    RowBox[{"\"\<X\>\"", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"tostring", "[", "case", "]"}], ",", "\"\<,\>\"", ",", 
       RowBox[{"ToString", "[", "index", "]"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"ce2e74a2-0b65-453c-9dc9-4c1683f6e5a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInv", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", "100"}], "]"}], "^", 
  "2"}]], "Input",ExpressionUUID->"2db88913-a094-46a1-aaae-cb9f42e66400"],

Cell[BoxData[
 SubsuperscriptBox["\<\"I\"\>", "\<\"013,100\"\>", 
  "2"]], "Output",ExpressionUUID->"f3b76b9b-ad79-4ae3-bb51-bd5cefed8079"]
}, Open  ]],

Cell["Permutations RPerm and WPerm are not formatted.", \
"Text",ExpressionUUID->"9d3d209f-ee7f-4c66-9764-394e0863afe4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Reading Invar files as rules", \
"Subsection",ExpressionUUID->"9158c482-50b4-4e3e-8d0d-8735e93bb1be"],

Cell["Switch to read the Weyl section of the package:", \
"Text",ExpressionUUID->"56ec1bd6-c697-416b-8e8b-69ae1c457db4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$ReadWeyl", "=", "False"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"776ff1c2-69e4-49be-975e-8129a1c115d3"],

Cell["The installation directory of Invar:", \
"Text",ExpressionUUID->"cec23fd3-0870-40bc-a5a2-c74855141fd7"],

Cell[CellGroupData[{

Cell[BoxData["$UserBaseDirectory"], \
"Input",ExpressionUUID->"3051d205-86e1-4473-8b9e-516f51ec7378"],

Cell[BoxData["\<\"/Users/jose/Library/Mathematica\"\>"], \
"Output",ExpressionUUID->"47ca4c62-3b92-4f80-9c9d-020fbf6bf9b5"]
}, Open  ]],

Cell["Default directory for the package :", \
"Text",ExpressionUUID->"8ad534f3-cf91-4bd6-89a8-2cd7ba35ffe5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$InvarDirectory", "=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"$xActDirectory", ",", "\"\</Invar\>\""}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fca5f5f5-8a76-4eb6-b514-ccac3288caf0"],

Cell[BoxData["\<\"/Users/jose/Library/Mathematica/Applications/xAct/Invar\"\>\
"], "Output",ExpressionUUID->"d32ddf2f-2131-441b-bee9-0b27497db35f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DataBaseDir", "=", "\"\<Riemann/\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"21474633-6287-4781-8b18-290fb53d2d14"],

Cell[CellGroupData[{

Cell["RInvs", \
"Subsubsection",ExpressionUUID->"35b3e341-682f-4463-bb05-47d37344d492"],

Cell["Backwards compatibility notation :", \
"Text",ExpressionUUID->"68f38d9b-23f7-483f-8da9-c7b69a2acd9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Invariants", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"RInv", "[", 
      RowBox[{"deg_Integer", ",", "index_"}], "]"}], ":=", 
     RowBox[{"RInv", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "deg", "}"}]}], "]"}], ",", "index"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DualRInv", "[", 
      RowBox[{"deg_Integer", ",", "index_"}], "]"}], ":=", 
     RowBox[{"DualRInv", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "deg", "}"}]}], "]"}], ",", "index"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Invariants", " ", "with", " ", "metric", " ", "argument"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"RInv", "[", "metric_", "]"}], "[", 
      RowBox[{"deg_Integer", ",", "index_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"RInv", "[", "metric", "]"}], "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "deg", "}"}]}], "]"}], ",", "index"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"DualRInv", "[", "metric_", "]"}], "[", 
      RowBox[{"deg_Integer", ",", "index_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"DualRInv", "[", "metric", "]"}], "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "deg", "}"}]}], "]"}], ",", "index"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Independent", " ", "Riemann", " ", "invariants"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RInvs", "[", 
      RowBox[{"step_Integer", ",", "deg_Integer", ",", "dim___"}], "]"}], ":=", 
     RowBox[{"RInvs", "[", 
      RowBox[{"step", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "deg", "}"}]}], "]"}], ",", "dim"}], "]"}]}], ";", 
    RowBox[{
     RowBox[{"DualRInvs", "[", 
      RowBox[{"step_Integer", ",", "deg_Integer", ",", "dim___"}], "]"}], ":=", 
     RowBox[{"DualRInvs", "[", 
      RowBox[{"step", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "deg", "}"}]}], "]"}], ",", "dim"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Lists", " ", "of", " ", "rules"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RInvRules", "[", 
      RowBox[{"step_", ",", "deg_Integer", ",", "dim___"}], "]"}], ":=", 
     RowBox[{"RInvRules", "[", 
      RowBox[{"step", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "deg", "}"}]}], "]"}], ",", "dim"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DualRInvRules", "[", 
      RowBox[{"step_", ",", "deg_Integer", ",", "dim___"}], "]"}], ":=", 
     RowBox[{"DualRInvRules", "[", 
      RowBox[{"step", ",", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "deg", "}"}]}], "]"}], ",", "dim"}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"be90fc74-746d-45b4-8dee-fee1f1bbc88f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "From", " ", "Riemann", " ", "to", " ", "Weyl", " ", "invariants"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"WInvs", "[", 
     RowBox[{"step_Integer", ",", "deg_", ",", "dim___"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"RInvs", "[", 
      RowBox[{"step", ",", "deg", ",", "dim"}], "]"}], "/.", 
     RowBox[{"RInv", "\[Rule]", "WInv"}]}]}], ";", 
   RowBox[{
    RowBox[{"DualWInvs", "[", 
     RowBox[{"step_Integer", ",", "deg_", ",", "dim___"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"DualRInvs", "[", 
      RowBox[{"step", ",", "deg", ",", "dim"}], "]"}], "/.", 
     RowBox[{"DualRInv", "\[Rule]", "DualWInv"}]}]}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7e8a9c67-dde4-4886-b69f-f90b96b5c94d"],

Cell["\<\
The lists of independent invariants could be protected. We define this \
alternative form of Set:\
\>", "Text",ExpressionUUID->"06e44676-750a-4744-bdb2-4aac01c36432"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ProtSet", ",", "HoldFirst"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"head_", "[", "args___", "]"}], ",", "value_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"prot", "=", 
       RowBox[{"Unprotect", "[", "head", "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"Set", "[", 
       RowBox[{
        RowBox[{"head", "[", "args", "]"}], ",", "value"}], "]"}], ";", 
      RowBox[{"Protect", "[", 
       RowBox[{"Evaluate", "[", "prot", "]"}], "]"}], ";", "value"}]}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5e542d1c-ee14-4033-b561-1082ad66396a"]
}, Closed]],

Cell[CellGroupData[{

Cell["File names", \
"Subsubsection",ExpressionUUID->"b6edccd0-382d-4c9d-b727-eee423d41f72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"intercase", "[", "case_List", "]"}], ":=", 
   RowBox[{"StringJoin", "@", 
    RowBox[{"Insert", "[", 
     RowBox[{
      RowBox[{"ToString", "/@", "case"}], ",", "\"\<_\>\"", ",", 
      RowBox[{"List", "/@", 
       RowBox[{"Range", "[", 
        RowBox[{"2", ",", 
         RowBox[{"Length", "[", "case", "]"}]}], "]"}]}]}], "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2417f8ba-e3fa-4ea8-9933-e3306e6b6f7e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"intercase", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"856dc13e-f38b-4e01-878c-4538f8c9d0b0"],

Cell[BoxData["\<\"0_1_3\"\>"], \
"Output",ExpressionUUID->"900f7299-c9ff-48f1-89b7-665418c5aa4e"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"filename", "[", 
    RowBox[{
     RowBox[{"step", ":", 
      RowBox[{"(", 
       RowBox[{"5", "|", "6"}], ")"}]}], ",", "case_", ",", "dim_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"filename", "[", 
     RowBox[{
      RowBox[{"ToString", "[", "step", "]"}], ",", "case"}], "]"}], 
    "<>", "\"\<_\>\"", "<>", 
    RowBox[{"ToString", "[", "dim", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"filename", "[", 
    RowBox[{"step_", ",", "case_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<RInv-\>\"", ",", 
     RowBox[{"intercase", "[", "case", "]"}], ",", "\"\<-\>\"", ",", 
     RowBox[{"ToString", "[", "step", "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"6f76fd38-a8ef-4cdf-b2ec-e28a16dee900"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"filename", "[", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"d425f290-0313-40de-80b4-bb3f72af9e32"],

Cell[BoxData["\<\"RInv-0_1_3-3\"\>"], \
"Output",ExpressionUUID->"f718bebc-4b33-4bb0-ac19-25fd332b8ad4"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dualfilename", "[", 
    RowBox[{"5", ",", "case_", ",", "dim_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"dualfilename", "[", 
     RowBox[{"\"\<5\>\"", ",", "case"}], "]"}], "<>", "\"\<_\>\"", "<>", 
    RowBox[{"ToString", "[", "dim", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dualfilename", "[", 
    RowBox[{"step_", ",", "case_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<DInv-\>\"", ",", 
     RowBox[{"intercase", "[", "case", "]"}], ",", "\"\<-\>\"", ",", 
     RowBox[{"ToString", "[", "step", "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7937f6b4-c829-4769-8fd4-9efe8a73f1e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dualfilename", "[", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", "4"}], 
  "]"}]], "Input",ExpressionUUID->"486dba2b-09e2-4ae6-8824-f4745c01b728"],

Cell[BoxData["\<\"DInv-0_1_3-5_4\"\>"], \
"Output",ExpressionUUID->"cd22bd43-9bfb-4bd9-acef-92b5ce9b4e1f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Check the import of the files", \
"Subsubsection",ExpressionUUID->"a9bf8414-d588-47f0-a945-96d107d5bfa0"],

Cell["Code contributed by Teake:", \
"Text",ExpressionUUID->"d1d640bc-f2d3-4af3-a2b8-e58a0e64d412"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInv", "::", "nodatabase"}], 
   "=", "\"\<Can't find the Invar database. You can download it from \
http://www.xact.es/Invar/.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CheckImport", "[", "args__", "]"}], ":=", 
   RowBox[{"Quiet", "[", 
    RowBox[{
     RowBox[{"Check", "[", 
      RowBox[{
       RowBox[{"Import", "[", "args", "]"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{"RInv", "::", "nodatabase"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ",", 
     RowBox[{"Import", "::", "nffil"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8a3df9d8-2073-4429-a76a-d487bd87cac1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Reading functions. Maple notation", \
"Subsubsection",ExpressionUUID->"b33c8adc-b487-47be-baca-a99e99ad1883"],

Cell[TextData[{
 "The permutation files are written in Maple notation. We need a collection \
of functions to translate the data to a format that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can understand. Note that the files are read without a metric argument."
}], "Text",ExpressionUUID->"8d9fd676-f607-4cb8-9e71-978deb6d531e"],

Cell["\<\
Intermediate simple functions. This selects the first of a collection of \
positions:\
\>", "Text",ExpressionUUID->"bb6171c1-c217-4660-bce1-7bbf642f7f5c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"firstof", "[", 
    RowBox[{"{", "}"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"firstof", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], "}"}], "]"}], ":=", "a"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"firstof", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_"}], "}"}], ",", "__"}], "}"}], "]"}], ":=", 
   "a"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"de2f1f64-1294-4e0e-857c-477b26c3628a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"positionof", "[", 
    RowBox[{"string_String", ",", "substring_String"}], "]"}], ":=", 
   RowBox[{"firstof", "@", 
    RowBox[{"StringPosition", "[", 
     RowBox[{"string", ",", "substring"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"movetofirst", "[", "0", "]"}], ":=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"movetofirst", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "+", "4"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c1aa047e-6240-4af0-a8d5-3cf980ffd2a0"],

Cell["\<\
Translation from brackets to braces for lists, and from equality to rules:\
\>", "Text",ExpressionUUID->"582acc31-06b3-427e-a58e-500a69de8b61"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"replacebrackets", "[", "string_String", "]"}], ":=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"string", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<[\>\"", "\[Rule]", "\"\<{\>\""}], ",", 
      RowBox[{"\"\<]\>\"", "\[Rule]", "\"\<}\>\""}]}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"replaceequal", "[", "string_String", "]"}], ":=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"string", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<=\>\"", "\[Rule]", "\"\<->\>\""}], "}"}]}], 
   "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"983cccc4-e766-4a47-85dc-6f72634bc16e"],

Cell["\<\
This is the main conversion function. It only reads what is found to the \
right of := and removing the last character (always a colon).\
\>", "Text",ExpressionUUID->"0cd162a7-de92-4fef-b0d2-4135c384b859"],

Cell[BoxData[
 RowBox[{
  RowBox[{"readline", "[", "string_", "]"}], ":=", 
  RowBox[{"StringTake", "[", 
   RowBox[{"string", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"movetofirst", "@", 
       RowBox[{"positionof", "[", 
        RowBox[{"string", ",", "\"\< := \>\""}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"StringLength", "[", "string", "]"}], "-", "1"}]}], "}"}]}], 
   "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b8da1ae6-a473-4a9a-bad0-1f0f9eb87af6"],

Cell["Final reading functions, for Maple notation:", \
"Text",ExpressionUUID->"fa1f3e26-49f0-4f07-9173-0735196febbe"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReadInvarPerms", "[", 
    RowBox[{"filename_", ",", "\"\<Maple\>\""}], "]"}], ":=", 
   RowBox[{"ToExpression", "/@", 
    RowBox[{"replacebrackets", "/@", 
     RowBox[{"readline", "/@", 
      RowBox[{"CheckImport", "[", 
       RowBox[{
        RowBox[{"StringJoin", "[", 
         RowBox[{"$InvarDirectory", ",", "\"\</\>\"", ",", "filename"}], 
         "]"}], ",", "\"\<Lines\>\""}], "]"}]}]}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ee285457-2951-4fb7-871f-1f8371c14a45"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReadInvarRules", "[", 
    RowBox[{"filename_", ",", "\"\<Maple\>\""}], "]"}], ":=", 
   RowBox[{"ToExpression", "/@", 
    RowBox[{"replaceequal", "/@", 
     RowBox[{"readline", "/@", 
      RowBox[{"CheckImport", "[", 
       RowBox[{
        RowBox[{"StringJoin", "[", 
         RowBox[{"$InvarDirectory", ",", "\"\</\>\"", ",", "filename"}], 
         "]"}], ",", "\"\<Lines\>\""}], "]"}]}]}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b71a94cc-e45c-4e53-bc61-6bc9c98647f6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Reading functions. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notation"
}], "Subsubsection",ExpressionUUID->"69b00687-bee6-4e39-acc1-085eeb5e3b00"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReadInvarPerms", "[", 
    RowBox[{"filename_", ",", "\"\<Mathematica\>\""}], "]"}], ":=", 
   RowBox[{"ToExpression", "/@", 
    RowBox[{"CheckImport", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"$InvarDirectory", ",", "\"\</\>\"", ",", "filename"}], "]"}], 
      ",", "\"\<Lines\>\""}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bea73824-4fe3-41c5-9ecd-eb147610b3ca"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReadInvarRules", "[", 
    RowBox[{"filename_", ",", "\"\<Mathematica\>\""}], "]"}], ":=", 
   RowBox[{"ToExpression", "/@", 
    RowBox[{"CheckImport", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"$InvarDirectory", ",", "\"\</\>\"", ",", "filename"}], "]"}], 
      ",", "\"\<Lines\>\""}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"28016f44-ff01-4e39-ba34-8425a33d118a"]
}, Closed]],

Cell[CellGroupData[{

Cell["Removing rules", \
"Subsubsection",ExpressionUUID->"b1d9d878-7990-4932-92b6-067c6228c1a6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RemoveRInvRules", "[", 
    RowBox[{"step_Integer", ",", "degree_Integer", ",", "dim___"}], "]"}], ":=", 
   RowBox[{"RemoveRInvRules", "[", 
    RowBox[{"step", ",", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "degree", "}"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveRInvRules", "[", 
    RowBox[{"step_Integer", ",", "case_List", ",", "dim___"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unset", "[", 
      RowBox[{"DispatchRules", "[", 
       RowBox[{"RInv", ",", "step", ",", "case", ",", "dim"}], "]"}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"Unprotect", "[", "RInvRules", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Unset", "[", 
      RowBox[{"RInvRules", "[", 
       RowBox[{"step", ",", "case", ",", "dim"}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Protect", "[", "RInvRules", "]"}], ";"}], "\[IndentingNewLine]",
     ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveDualRInvRules", "[", 
    RowBox[{"step_Integer", ",", "degree_Integer", ",", "dim___"}], "]"}], ":=", 
   RowBox[{"RemoveDualRInvRules", "[", 
    RowBox[{"step", ",", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "degree", "}"}]}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RemoveDualRInvRules", "[", 
    RowBox[{"step_Integer", ",", "case_List", ",", "dim___"}], "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unset", "[", 
      RowBox[{"DispatchRules", "[", 
       RowBox[{"DualRInv", ",", "step", ",", "case", ",", "dim"}], "]"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Unprotect", "[", "DualRInvRules", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Unset", "[", 
      RowBox[{"DualRInvRules", "[", 
       RowBox[{"step", ",", "case", ",", "dim"}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Protect", "[", "DualRInvRules", "]"}], ";"}], 
    "\[IndentingNewLine]", ")"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"2dede5ed-0f58-4d9c-9ee8-84401470b2ef"]
}, Closed]],

Cell[CellGroupData[{

Cell["Metric argument", \
"Subsubsection",ExpressionUUID->"0f999800-4d76-48f6-ab24-90cb0f057c2e"],

Cell["\<\
We could have invariants associated to different metrics. Therefore the \
invariants need to carry a third argument specifying the metric:\
\>", "Text",ExpressionUUID->"d3cfd6c6-e3a0-4443-9725-76bb136556f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"addRdep", "[", 
   RowBox[{"Rule", "[", 
    RowBox[{
     RowBox[{"inv_", "[", 
      RowBox[{"case_", ",", "count_"}], "]"}], ",", "rhs_"}], "]"}], "]"}], ":=", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"inv", "[", "metric_", "]"}], "[", 
     RowBox[{"case", ",", "count"}], "]"}], ",", 
    RowBox[{"rhs", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RInv", "\[Rule]", 
        RowBox[{"RInv", "[", "metric", "]"}]}], ",", 
       RowBox[{"DualRInv", "\[Rule]", 
        RowBox[{"DualRInv", "[", "metric", "]"}]}], ",", 
       RowBox[{"WInv", "\[Rule]", 
        RowBox[{"WInv", "[", "metric", "]"}]}], ",", 
       RowBox[{"DualWInv", "\[Rule]", 
        RowBox[{"DualWInv", "[", "metric", "]"}]}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9515e2bd-9612-4ae9-8b6e-9cfddc40abdf"],

Cell["\<\
The main idea is that we shall use the dispatched rules with the metric \
option for the actual simplification algorithm, but the normal (Nometric) \
rules to generate the files for the package.\
\>", "Text",ExpressionUUID->"794b38d8-9b76-4f7e-9779-889d416efed6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"With", " ", "a", " ", "metric", " ", "argument"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"RInvs", "[", "metric_", "]"}], "[", "args__", "]"}], ":=", 
     RowBox[{
      RowBox[{"RInvs", "[", "args", "]"}], "/.", 
      RowBox[{"RInv", "\[Rule]", 
       RowBox[{"RInv", "[", "metric", "]"}]}]}]}], ";", 
    RowBox[{
     RowBox[{
      RowBox[{"WInvs", "[", "metric_", "]"}], "[", "args__", "]"}], ":=", 
     RowBox[{
      RowBox[{"WInvs", "[", "args", "]"}], "/.", 
      RowBox[{"WInv", "\[Rule]", 
       RowBox[{"WInv", "[", "metric", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"DualRInvs", "[", "metric_", "]"}], "[", "args__", "]"}], ":=", 
     
     RowBox[{
      RowBox[{"DualRInvs", "[", "args", "]"}], "/.", 
      RowBox[{"DualRInv", "\[Rule]", 
       RowBox[{"DualRInv", "[", "metric", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"DualWInvs", "[", "metric_", "]"}], "[", "args__", "]"}], ":=", 
     
     RowBox[{
      RowBox[{"DualWInvs", "[", "args", "]"}], "/.", 
      RowBox[{"DualWInv", "\[Rule]", 
       RowBox[{"DualWInv", "[", "metric", "]"}]}]}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3a3ecd58-b9ff-44e3-b46a-22589b226d98"],

Cell["\<\
Note that there is no confusion between both (metric and nometric) \
definitions because in one case RInvs has one argument, but in the other case \
it has two arguments.\
\>", "Text",ExpressionUUID->"b7a2eaf5-f483-43d8-b2bc-ebb6df640f0e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefaultDim", ":=", 
   RowBox[{"DimOfVBundle", "@", 
    RowBox[{"VBundleOfMetric", "@", 
     RowBox[{"First", "@", "$Metrics"}]}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c2431933-85bd-4aed-bac7-3595f3c93dae"]
}, Closed]],

Cell[CellGroupData[{

Cell["Cases", \
"Subsubsection",ExpressionUUID->"0c1bfb30-5881-456a-9c1f-0888aeaaf638"],

Cell[TextData[{
 "The function InvarCases contains the list of cases which are currently \
handled by ",
 StyleBox["Invar",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"b238f856-207e-4263-8c51-f45c4c63ce9e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", "]"}], ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"InvarCases", "[", "order", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"order", ",", "2", ",", "14", ",", "2"}], "}"}]}], "]"}], ",",
      "1"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"order_Integer", "?", "EvenQ"}], "]"}], ":=", 
   RowBox[{"InvarCases", "[", 
    RowBox[{"order", ",", 
     RowBox[{"Reverse", "@", 
      RowBox[{"Range", "[", 
       RowBox[{"order", "/", "2"}], "]"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarCases", "[", 
     RowBox[{
      RowBox[{"order_Integer", "?", "EvenQ"}], ",", "list_List"}], "]"}], ":=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"InvarCases", "[", 
         RowBox[{"order", ",", "#"}], "]"}], "&"}], "/@", "list"}], ",", 
      "1"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarCases", "[", "14", "]"}], ":=", 
    RowBox[{"InvarCases", "[", 
     RowBox[{"14", ",", "7"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 

 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarCases", "[", 
     RowBox[{"2", ",", "1"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", "0", "}"}], "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"4", ",", "1"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", "2", "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarCases", "[", 
     RowBox[{"4", ",", "2"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"6", ",", "1"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", "4", "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"6", ",", "2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarCases", "[", 
     RowBox[{"6", ",", "3"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"8", ",", "1"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", "6", "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"8", ",", "2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"8", ",", "3"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarCases", "[", 
     RowBox[{"8", ",", "4"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"10", ",", "1"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", "8", "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"10", ",", "2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"10", ",", "3"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"10", ",", "4"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarCases", "[", 
     RowBox[{"10", ",", "5"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"12", ",", "1"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", "10", "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"12", ",", "2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"12", ",", "3"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"12", ",", "4"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", 
    RowBox[{"12", ",", "5"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}], "}"}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarCases", "[", 
     RowBox[{"12", ",", "6"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarCases", "[", 
     RowBox[{"14", ",", "7"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
      "}"}], "}"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Invalid order \>\"", ",", "x"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarCases", "[", "args__", "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Invar cannot work with the cases \>\"", ",", 
      RowBox[{"{", "args", "}"}]}], "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3d14104f-4062-46a2-8789-e4fa40664665"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvarCases", "[", 
  "]"}]], "Input",ExpressionUUID->"c8023713-6a43-478c-8776-932f498df2e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", "8", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "10", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"5055df08-7610-452b-a5d2-8169ed066e7a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"7262e24c-061c-45d6-b1ac-79b1a4c3b3ba"],

Cell[BoxData["48"], \
"Output",ExpressionUUID->"ff7b8566-6ede-4f11-b6c6-3139a7269410"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvarCases", "[", "10", 
  "]"}]], "Input",ExpressionUUID->"5c92d541-7249-46f2-93f7-74ecd3e7e983"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", "8", "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"d22e67b0-fbaa-4e29-90c4-6f9c17d71d82"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvarCases", "[", 
  RowBox[{"10", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"619e4677-194e-42e2-854a-af53df7dfb74"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"5768370a-9d83-40b9-a38a-fbeeb313dc6e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"indicesofcase", "[", "case_", "]"}], ":=", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{"Length", "[", "case", "]"}]}], "+", 
   RowBox[{
   "Plus", "@@", 
    "case"}]}]}]], \
"Input",ExpressionUUID->"f15e5143-c359-4f66-bac9-86e1b1067c0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factorial", "/@", 
  RowBox[{"(", 
   RowBox[{"indicesofcase", "/@", 
    RowBox[{
     RowBox[{"InvarCases", "[", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
   ")"}]}]], "Input",ExpressionUUID->"4fbdda37-0d40-4b6b-b8c9-279704a51b11"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "24", ",", "40320", ",", "720", ",", "479001600", ",", "3628800", ",", 
   "3628800", ",", "40320", ",", "20922789888000", ",", "87178291200", ",", 
   "87178291200", ",", "479001600", ",", "479001600", ",", "479001600", ",", 
   "3628800", ",", "2432902008176640000", ",", "6402373705728000", ",", 
   "6402373705728000", ",", "20922789888000", ",", "20922789888000", ",", 
   "20922789888000", ",", "20922789888000", ",", "87178291200", ",", 
   "87178291200", ",", "87178291200", ",", "87178291200", ",", "479001600", ",",
    "620448401733239439360000", ",", "1124000727777607680000", ",", 
   "1124000727777607680000", ",", "2432902008176640000", ",", 
   "2432902008176640000", ",", "2432902008176640000", ",", 
   "2432902008176640000", ",", "2432902008176640000", ",", "6402373705728000",
    ",", "6402373705728000", ",", "6402373705728000", ",", "6402373705728000",
    ",", "6402373705728000", ",", "6402373705728000", ",", "6402373705728000",
    ",", "20922789888000", ",", "20922789888000", ",", "20922789888000", ",", 
   "20922789888000", ",", "20922789888000", ",", "87178291200"}], 
  "}"}]], "Output",ExpressionUUID->"68eb7a3a-8a51-453f-a434-a624dfa8f8a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  "%"}]], "Input",ExpressionUUID->"4d35b7fa-c724-42e5-8996-13cbeac8b25b"],

Cell[BoxData["622711058432047619006184"], \
"Output",ExpressionUUID->"81e532a0-e8b0-4e9a-8e26-47cebe73e766"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"c27038ad-b688-4078-8352-aa515e11a217"],

Cell[BoxData["6.227110584320476`*^23"], \
"Output",ExpressionUUID->"b7020ee8-e647-4b92-af3f-37b94ce9a3b3"]
}, Open  ]],

Cell["Almost Avogadro's number!", \
"Text",ExpressionUUID->"ad0e6972-94d1-4a60-8152-f92c12fed966"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", "]"}], ":=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"InvarDualCases", "[", "order", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"order", ",", "2", ",", "10", ",", "2"}], "}"}]}], "]"}], ",",
      "1"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", 
    RowBox[{"order_Integer", "?", "EvenQ"}], "]"}], ":=", 
   RowBox[{"InvarDualCases", "[", 
    RowBox[{"order", ",", 
     RowBox[{"Reverse", "@", 
      RowBox[{"Range", "[", 
       RowBox[{"order", "/", "2"}], "]"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarDualCases", "[", 
     RowBox[{
      RowBox[{"order_Integer", "?", "EvenQ"}], ",", "list_List"}], "]"}], ":=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"InvarDualCases", "[", 
         RowBox[{"order", ",", "#"}], "]"}], "&"}], "/@", "list"}], ",", 
      "1"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarDualCases", "[", "10", "]"}], ":=", 
    RowBox[{"InvarDualCases", "[", 
     RowBox[{"10", ",", "5"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 

 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarDualCases", "[", 
     RowBox[{"2", ",", "1"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", "0", "}"}], "}"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", 
    RowBox[{"4", ",", "1"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", "2", "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarDualCases", "[", 
     RowBox[{"4", ",", "2"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", 
    RowBox[{"6", ",", "1"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", "4", "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", 
    RowBox[{"6", ",", "2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarDualCases", "[", 
     RowBox[{"6", ",", "3"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", 
    RowBox[{"8", ",", "1"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", "6", "}"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", 
    RowBox[{"8", ",", "2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", 
    RowBox[{"8", ",", "3"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarDualCases", "[", 
     RowBox[{"8", ",", "4"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvarDualCases", "[", 
     RowBox[{"10", ",", "5"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], 
   ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Invalid order \>\"", ",", "x"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvarDualCases", "[", "args__", "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Invar cannot work with the dual cases \>\"", ",", 
      RowBox[{"{", "args", "}"}]}], "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"924cd60c-6521-4948-81d1-0a27d892ef5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvarDualCases", "[", 
  "]"}]], "Input",ExpressionUUID->"76f64652-3c86-4a5e-9b4f-2b6565d41dec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"3d29d0ca-be22-4abb-b830-d7f2bd236731"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"c122df95-ca83-4f9e-940b-000a43d553ab"],

Cell[BoxData["15"], \
"Output",ExpressionUUID->"e7e4de7e-86e8-45f8-bd99-9e47ce4229f3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Maximum degree and index", \
"Subsubsection",ExpressionUUID->"0046734d-9c93-4fae-a8e4-af943e273b45"],

Cell["\<\
These are the numbers (directly copied from the files) of canonical \
invariants for each degree (not containing products):\
\>", "Text",ExpressionUUID->"54b09d04-7895-4bd3-8886-f47a5cd2e4d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "MaxIndex"}]], \
"Input",ExpressionUUID->"80d670ed-1f5c-4018-abdc-777d2b324656"],

Cell[BoxData[
 StyleBox["\<\"MaxIndex[step] gives the largest index of the non-dual \
invariants at the given step.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3568108732-8679363",ExpressionUUID->"ac08679e-36da-4554-868c-\
d9d4e9120ddb"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"n_Integer", "?", "Positive"}], "]"}], ":=", 
    RowBox[{"MaxIndex", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", "}"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", "0", "}"}], "]"}], ":=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "]"}], ":=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", "2", "}"}], "]"}], ":=", "2"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ":=", "9"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}], "]"}], ":=", "12"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "]"}], ":=", "12"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", "4", "}"}], "]"}], ":=", "12"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "]"}], ":=", "38"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}], ":=", "99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}], "]"}], ":=", "125"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}], "]"}], ":=", "126"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "]"}], ":=", "138"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "]"}], ":=", "86"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", "6", "}"}], "]"}], ":=", "105"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "]"}], ":=",
    "204"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], "]"}], ":=", 
   "1020"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], "]"}], ":=", 
   "1749"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "4"}], "}"}], "]"}], ":=", "1473"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}], "]"}], ":=", "3099"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}], ":=", "1622"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "2"}], "}"}], "]"}], ":=", "1617"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "6"}], "}"}], "]"}], ":=", "1665"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}], "]"}], ":=", "1770"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "]"}], ":=", "1746"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], "]"}], ":=", "962"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", "8", "}"}], "]"}], ":=", "1155"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
    "]"}], ":=", "1613"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], "]"}], ":=",
    "12722"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], "]"}], ":=",
    "27022"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], "]"}], ":=", 
   "19617"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], "]"}], ":=", 
   "60984"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], "]"}], ":=", 
   "30974"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], "]"}], ":=", 
   "62465"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], "]"}], ":=", 
   "5606"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "6"}], "}"}], "]"}], ":=", "25590"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "5"}], "}"}], "]"}], ":=", "53160"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "4"}], "}"}], "]"}], ":=", "52764"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "4"}], "}"}], "]"}], ":=", "27396"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3", ",", "3"}], "}"}], "]"}], ":=", "27024"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ":=", "54654"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}], ":=", "9104"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8"}], "}"}], "]"}], ":=", "25515"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "7"}], "}"}], "]"}], ":=", "26670"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "6"}], "}"}], "]"}], ":=", "26460"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}], "]"}], ":=", "26670"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}], "]"}], ":=", "13607"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", "10", "}"}], "]"}], ":=", "15120"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
      "}"}], "]"}], ":=", "16532"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], "]"}], ":=", "217395"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxIndex", "[", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0"}], "}"}], "]"}], ":=", "3406747"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxIndex", "[", "case_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Case \>\"", ",", "case", ",", "\"\< not included.\>\""}], 
     "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f00f3f60-3a11-4ef8-9b2d-a619b8d49adb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"allnonduals", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Plus", ",", 
    RowBox[{"MaxIndex", "/@", 
     RowBox[{"InvarCases", "[", "]"}]}]}], 
   "]"}]}]], "Input",ExpressionUUID->"ea769e76-2cce-4ec1-a01f-053b5c4d6409"],

Cell[BoxData["640119"], \
"Output",ExpressionUUID->"8b9af0bf-b63e-44ed-b4d7-70b8874cb7a4"]
}, Open  ]],

Cell["Duals.", "Text",ExpressionUUID->"5f3877f4-4e4c-4d3a-8e64-ac827de2e552"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxDualIndex", "[", "n_Integer", "]"}], ":=", 
    RowBox[{"MaxDualIndex", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxDualIndex", "[", 
     RowBox[{"{", "}"}], "]"}], "=", "0"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxDualIndex", "[", 
     RowBox[{"{", "0", "}"}], "]"}], "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "]"}], "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxDualIndex", "[", 
     RowBox[{"{", "2", "}"}], "]"}], "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], "=", "27"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}], "]"}], "=", "58"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "]"}], "=", "36"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxDualIndex", "[", 
     RowBox[{"{", "4", "}"}], "]"}], "=", "32"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "]"}], "=", "232"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}], "=", "967"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}], "]"}], "=", "1047"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}], "]"}], "=", "876"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "]"}], "=", "920"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "]"}], "=", "478"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxDualIndex", "[", 
     RowBox[{"{", "6", "}"}], "]"}], "=", "435"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxDualIndex", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "]"}], "=",
     "2582"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxDualIndex", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     "]"}], "=", "35090"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MaxDualIndex", "[", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
      "}"}], "]"}], "=", "558323"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MaxDualIndex", "[", "case_", "]"}], ":=", 
   RowBox[{"Throw", "[", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Dual case\>\"", ",", " ", "case", 
      ",", "\"\< not included.\>\""}], "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"efa3c218-7107-4b8d-912f-afef0f2a9cf2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"allduals", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Plus", ",", 
    RowBox[{"MaxDualIndex", "/@", 
     RowBox[{"InvarDualCases", "[", "]"}]}]}], 
   "]"}]}]], "Input",ExpressionUUID->"fd1d667d-194b-4971-98b4-b571428b800a"],

Cell[BoxData["7698"], \
"Output",ExpressionUUID->"c57d2e6c-68ff-4448-a527-a1257ac016c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"allnonduals", "+", 
  "allduals"}]], \
"Input",ExpressionUUID->"2e30af50-9833-4492-ac43-1eb706c26d12"],

Cell[BoxData["647817"], \
"Output",ExpressionUUID->"70af452d-fdfb-4293-ae22-b9c76428716e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["More on RInvs", \
"Subsubsection",ExpressionUUID->"f5ea181f-19e8-4a35-ae0d-4cd4ed3afcd3"],

Cell["\<\
Construct Invs lists for level 1. There is a call to MaxIndex and hence a \
check of maximum degree.\
\>", "Text",ExpressionUUID->"f3616840-ff27-47bd-9f3c-cf89e5b1711f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInvs", "[", 
    RowBox[{"1", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"RInvs", "[", 
      RowBox[{"1", ",", "case"}], "]"}], ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"RInv", "[", 
         RowBox[{"case", ",", "#"}], "]"}], "&"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"MaxIndex", "[", "case", "]"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvs", "[", 
    RowBox[{"1", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"DualRInvs", "[", 
      RowBox[{"1", ",", "case"}], "]"}], ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"DualRInv", "[", 
         RowBox[{"case", ",", "#"}], "]"}], "&"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"MaxDualIndex", "[", "case", "]"}], "]"}]}], "]"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WInvs", "[", 
    RowBox[{"1", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"WInvs", "[", 
      RowBox[{"1", ",", "case"}], "]"}], ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"WInv", "[", 
         RowBox[{"case", ",", "#"}], "]"}], "&"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"MaxIndex", "[", "case", "]"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DualWInvs", "[", 
    RowBox[{"1", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"DualWInvs", "[", 
      RowBox[{"1", ",", "case"}], "]"}], ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"DualWInv", "[", 
         RowBox[{"case", ",", "#"}], "]"}], "&"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{"MaxDualIndex", "[", "case", "]"}], "]"}]}], "]"}]}], "]"}]}],
   ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3cfc928b-27aa-413f-913a-26b0dd559381"]
}, Closed]],

Cell[CellGroupData[{

Cell["DispatchRules", \
"Subsubsection",ExpressionUUID->"d27acf55-e3f5-4d3f-bf5c-12e82ce30234"],

Cell["\<\
Dispatch rules per degree. Again, we do not need separate dispatched rules \
for the Weyl invariants:\
\>", "Text",ExpressionUUID->"aaaf721a-b3b7-49c6-8e5c-28c76566fb9d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DispatchRules", "[", 
    RowBox[{"RInv", ",", "step_", ",", "case_", ",", "dim___"}], "]"}], ":=", 
   
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "sigma", "}"}], ",", 
     RowBox[{
      RowBox[{"DispatchRules", "[", 
       RowBox[{"RInv", ",", "step", ",", "case", ",", "dim"}], "]"}], "=", 
      RowBox[{"Dispatch", "[", 
       RowBox[{"RInvRules", "[", 
        RowBox[{"step", ",", "case", ",", "dim"}], "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchRules", "[", 
    RowBox[{"DualRInv", ",", "step_", ",", "case_", ",", "dim___"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchRules", "[", 
     RowBox[{"DualRInv", ",", "step", ",", "case", ",", "dim"}], "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"DualRInvRules", "[", 
      RowBox[{"step", ",", "case", ",", "dim"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchRules", "[", 
    RowBox[{"WInv", ",", "step_", ",", "case_", ",", "dim___"}], "]"}], ":=", 
   
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "sigma", "}"}], ",", 
     RowBox[{
      RowBox[{"DispatchRules", "[", 
       RowBox[{"WInv", ",", "step", ",", "case", ",", "dim"}], "]"}], "=", 
      RowBox[{"Dispatch", "[", 
       RowBox[{"WInvRules", "[", 
        RowBox[{"step", ",", "case", ",", "dim"}], "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchRules", "[", 
    RowBox[{"DualWInv", ",", "step_", ",", "case_", ",", "dim___"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchRules", "[", 
     RowBox[{"DualWInv", ",", "step", ",", "case", ",", "dim"}], "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"DualWInvRules", "[", 
      RowBox[{"step", ",", "case", ",", "dim"}], "]"}], "]"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"daef190b-d811-4611-b968-b613480c1972"]
}, Closed]],

Cell[CellGroupData[{

Cell["Read the Canon permutations for the invariants: step 1", \
"Subsubsection",ExpressionUUID->"703464d5-d4e9-4cb5-9858-bb6d943b700b"],

Cell[TextData[{
 "First we read the correspondence between invariants and permutations. Note \
that the symbols Invars and DualInvars are never loaded into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",ExpressionUUID->"36f1ba29-99e3-4011-bc39-6dec5be7586d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RInvRules", "[", 
    RowBox[{"1", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Reading InvRules for step 1 and case \>\"", ",", "case"}],
        "]"}], ";", 
      RowBox[{"result", "=", 
       RowBox[{"Inner", "[", 
        RowBox[{"Rule", ",", 
         RowBox[{"tmphead", "@@", 
          RowBox[{"RInvs", "[", 
           RowBox[{"1", ",", "case"}], "]"}]}], ",", 
         RowBox[{"tmphead", "@@", 
          RowBox[{"ReadInvarPerms", "[", 
           RowBox[{
            RowBox[{"$DataBaseDir", "<>", "\"\<1/\>\"", "<>", 
             RowBox[{"filename", "[", 
              RowBox[{"1", ",", "case"}], "]"}]}], ",", "\"\<Maple\>\""}], 
           "]"}]}], ",", "List"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"RInvRules", "[", 
         RowBox[{"1", ",", "case"}], "]"}], ",", "result"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b582ddd3-c9d7-4c11-89f7-f354b96f2bc2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvRules", "[", 
    RowBox[{"1", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxDualIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Reading DualInvRules for step 1 and case \>\"", ",", 
        "case"}], "]"}], ";", 
      RowBox[{"result", "=", 
       RowBox[{"Inner", "[", 
        RowBox[{"Rule", ",", 
         RowBox[{"tmphead", "@@", 
          RowBox[{"DualRInvs", "[", 
           RowBox[{"1", ",", "case"}], "]"}]}], ",", 
         RowBox[{"tmphead", "@@", 
          RowBox[{"ReadInvarPerms", "[", 
           RowBox[{
            RowBox[{"$DataBaseDir", "<>", "\"\<1/\>\"", "<>", 
             RowBox[{"dualfilename", "[", 
              RowBox[{"1", ",", "case"}], "]"}]}], ",", "\"\<Maple\>\""}], 
           "]"}]}], ",", "List"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"DualRInvRules", "[", 
         RowBox[{"1", ",", "case"}], "]"}], ",", "result"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b678b586-da68-47db-8f79-1ed14946f9f6"],

Cell["Dispatch rules per degree:", \
"Text",ExpressionUUID->"dd675b27-d4d3-4c1f-8bcc-bd82030ae64e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"reversecycles", "[", 
    RowBox[{"inv_", "\[Rule]", 
     RowBox[{"{", "cycles__", "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Cycles", "[", "cycles", "]"}], "\[Rule]", "inv"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f9dea197-9719-4ce3-877b-9b16bae3590d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DispatchRInvToPermRules", "[", "case_List", "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchRInvToPermRules", "[", "case", "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"RInvRules", "[", 
      RowBox[{"1", ",", "case"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchPermToRInvRules", "[", "case_List", "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchPermToRInvRules", "[", "case", "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"reversecycles", "/@", 
      RowBox[{"RInvRules", "[", 
       RowBox[{"1", ",", "case"}], "]"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchDualRInvToPermRules", "[", "case_List", "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchDualRInvToPermRules", "[", "case", "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"DualRInvRules", "[", 
      RowBox[{"1", ",", "case"}], "]"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchPermToDualRInvRules", "[", "case_List", "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchPermToDualRInvRules", "[", "case", "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"reversecycles", "/@", 
      RowBox[{"DualRInvRules", "[", 
       RowBox[{"1", ",", "case"}], "]"}]}], "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"69518fd0-cda0-41ab-848d-416137885fd7"],

Cell["\<\
The files for WInvariants are the same as those for RInvariants. We do not \
create dispatched rules for the WInvariants.\
\>", "Text",ExpressionUUID->"15af213a-4cf9-46da-b8cb-1b6355f91039"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"WInvRules", "[", 
    RowBox[{"1", ",", "case_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"RInvRules", "[", 
     RowBox[{"1", ",", "case"}], "]"}], "/.", 
    RowBox[{"RInv", "\[Rule]", "WInv"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualWInvRules", "[", 
    RowBox[{"1", ",", "case_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DualRInvRules", "[", 
     RowBox[{"1", ",", "case"}], "]"}], "/.", 
    RowBox[{"DualRInv", "\[Rule]", "DualWInv"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"262441b9-9ea0-4092-9f2f-059f44ef2c39"],

Cell["Examples with invariants:", \
"Text",ExpressionUUID->"2c789571-fc05-4cd9-886f-c8ac8099bbbc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RInvRules", "[", 
  RowBox[{"1", ",", "3"}], 
  "]"}]], "Input",ExpressionUUID->"5de98dca-a9e1-42fb-ad7a-9d0591a5fffb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"29c1acc8-2f7a-483b-973a-d278230d8531"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"000,1\"\>"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "7", ",", "8", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "11"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"000,2\"\>"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "11"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"000,3\"\>"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "7", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "11", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"000,4\"\>"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "7", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "11"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"000,5\"\>"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "9", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "11", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"000,6\"\>"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "9", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "11"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"000,7\"\>"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "11"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"000,8\"\>"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "6", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "11"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
    SubscriptBox["\<\"I\"\>", "\<\"000,9\"\>"], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "6", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "11"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "12"}], "}"}]}], "}"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"fce85b5a-6244-48d6-a8cf-44eee8c7a79e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"1", ",", "7"}], "]"}], "]"}], "//", 
  "Timing"}]], "Input",ExpressionUUID->"a274352d-605c-4cf2-af91-80c304e561aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"efe85d99-1741-4d4c-88ac-cbba2cf01524"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.27744799999999991690913248021388426423`6.126943143986419", ",", 
   "16532"}], 
  "}"}]], "Output",ExpressionUUID->"f714a7b9-ae1e-4961-82d6-ea1fb88920ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"1", ",", "7"}], "]"}], "]"}], "//", 
  "Timing"}]], "Input",ExpressionUUID->"980963e5-508c-4516-9942-95a788d8de21"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.01484100000000000002531308496145356912`4.192063078363468", ",", 
   "16532"}], 
  "}"}]], "Output",ExpressionUUID->"018ac105-eeaa-4241-8940-b290fb8ec998"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvRules", "[", 
   RowBox[{"1", ",", "7"}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"998ccc99-5e76-443c-a0d3-1c27e687e3a1"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"0000000,16532\"\>"], "\[Rule]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "4", ",", "7", ",", "11", ",", "17", ",", "8", ",", "13", ",", "6", ",", 
      "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15", ",", "12", ",", "19", ",", "14", ",", "21"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"16", ",", "18", ",", "23", ",", "20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"22", ",", "27"}], "}"}]}], 
   "}"}]}]], "Output",ExpressionUUID->"60a93ff7-4108-4dee-b67b-48e1f699af90"]
}, Open  ]],

Cell["Examples with dual invariants:", \
"Text",ExpressionUUID->"d4dada68-71cf-4818-a541-d997b657f584"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DualRInvRules", "[", 
   RowBox[{"1", ",", "3"}], "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"2d027da4-75c4-420b-abd5-ee77af27b2d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"7660d58b-df72-4db4-8d9b-1b8ff5b6080c"],

Cell[BoxData["27"], \
"Output",ExpressionUUID->"39966417-eae8-4d40-bb92-848a3a30db69"]
}, Open  ]],

Cell["Errors:", "Text",ExpressionUUID->"f21ff551-bfd9-4525-b354-b923bbf88ed2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"RInvRules", "[", 
   RowBox[{"1", ",", "10"}], 
   "]"}]}]], "Input",ExpressionUUID->"9107a9b4-4ea7-480b-977c-201b5f81c4fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" not included.\"\>"}],
  SequenceForm["Case ", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, " not included."],
  Editable->
   False]], "Print",ExpressionUUID->"cfef14c2-2f60-48d6-b2eb-46d34eec8bbb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"DualWInvRules", "[", 
   RowBox[{"1", ",", "8"}], 
   "]"}]}]], "Input",ExpressionUUID->"46c16f3d-7bdc-4b6f-b78d-a472c2043ec1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dual case\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], "\[InvisibleSpace]", "\<\" not included.\"\>"}],
  SequenceForm["Dual case", {0, 0, 0, 0, 0, 0, 0, 0}, " not included."],
  Editable->
   False]], "Print",ExpressionUUID->"f2b4c3da-7c21-4362-ba95-f05a46a08782"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Read cyclic rules: step 2", \
"Subsubsection",ExpressionUUID->"046d6c32-9ed0-40a0-9241-65ca447e8d08"],

Cell["Now we read the rules given by the cyclic symmetry.", \
"Text",ExpressionUUID->"66dbd641-ad27-47c9-ad27-7884a98a1185"],

Cell["Invariants:", \
"Text",ExpressionUUID->"267a39b7-65e5-44ee-a6dc-341e90012abb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInvs", "[", 
    RowBox[{"2", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"RInvs", "[", 
      RowBox[{"2", ",", "case"}], "]"}], ",", 
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"RInvs", "[", 
        RowBox[{"1", ",", "case"}], "]"}], ",", 
       RowBox[{"First", "/@", 
        RowBox[{"RInvRules", "[", 
         RowBox[{"2", ",", "case"}], "]"}]}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvs", "[", 
    RowBox[{"2", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"DualRInvs", "[", 
      RowBox[{"2", ",", "case"}], "]"}], ",", 
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"DualRInvs", "[", 
        RowBox[{"1", ",", "case"}], "]"}], ",", 
       RowBox[{"First", "/@", 
        RowBox[{"DualRInvRules", "[", 
         RowBox[{"2", ",", "case"}], "]"}]}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a2de9293-851e-41c7-96ed-a79c2dd98dc7"],

Cell["Rules:", "Text",ExpressionUUID->"613920a7-26da-4135-a204-4e6647203dc8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RInvRules", "[", 
    RowBox[{"2", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Reading InvRules for step 2 and case \>\"", ",", "case"}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"result", "=", 
       RowBox[{"ReadInvarRules", "[", 
        RowBox[{
         RowBox[{"$DataBaseDir", "<>", "\"\<2/\>\"", "<>", 
          RowBox[{"filename", "[", 
           RowBox[{"2", ",", "case"}], "]"}]}], ",", "\"\<Mathematica\>\""}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"RInvRules", "[", 
         RowBox[{"2", ",", "case"}], "]"}], ",", "result"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7535a51b-7de5-43c3-b44b-244c8fafee9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvRules", "[", 
    RowBox[{"2", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxDualIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Reading DualInvRules for step 2 and case \>\"", ",", 
        "case"}], "]"}], ";", 
      RowBox[{"result", "=", 
       RowBox[{"ReadInvarRules", "[", 
        RowBox[{
         RowBox[{"$DataBaseDir", "<>", "\"\<2/\>\"", "<>", 
          RowBox[{"dualfilename", "[", 
           RowBox[{"2", ",", "case"}], "]"}]}], ",", "\"\<Mathematica\>\""}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"DualRInvRules", "[", 
         RowBox[{"2", ",", "case"}], "]"}], ",", "result"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1bb0286a-06e6-422a-b0c7-8a0105526e58"],

Cell["Examples:", \
"Text",ExpressionUUID->"d9b6aab8-3b17-4751-8135-11f7012a0411"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"result", "=", 
    RowBox[{"RInvRules", "[", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"1056773e-481b-4802-87fa-9f55f230ed67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"965f80b0-426a-4e1e-a308-10b7f5852383"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.09669600000000000417088585891178809106`5.006008422379608", ",", "1712"}],
   "}"}]], "Output",ExpressionUUID->"3af42b57-a0ac-4f62-8c9f-23294cf0b8d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", "1", "]"}], 
  "]"}]], "Input",ExpressionUUID->"ac2a09dd-f029-4d98-9ac9-cbfcbe6d7924"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"013,144\"\>"], "\[Rule]", 
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["\<\"I\"\>", "\<\"013,142\"\>"]}], "+", 
   SubscriptBox["\<\"I\"\>", "\<\"013,143\"\>"]}]}]], \
"Output",ExpressionUUID->"a8b6fb7b-fad7-4e66-bd8f-189ef98ae294"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"d8ef53f6-4ee0-4ffc-b991-eb334e3fa305"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"013,3099\"\>"], "\[Rule]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SubscriptBox["\<\"I\"\>", "\<\"013,3088\"\>"], "2"]}], "+", 
   FractionBox[
    SubscriptBox["\<\"I\"\>", "\<\"013,3089\"\>"], 
    "2"]}]}]], "Output",ExpressionUUID->"1a27bbce-c2dc-4586-b069-fddf8f1ba1e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", 
   RowBox[{"2", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"19eb50ef-fe9b-4a8e-9790-32e0737cef6e"],

Cell[BoxData["1387"], \
"Output",ExpressionUUID->"48b166ef-e814-4a65-b2cd-cc3e84c46c21"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"result", "=", 
    RowBox[{"DualRInvRules", "[", 
     RowBox[{"2", ",", "4"}], "]"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"45f3e857-c5bd-45be-bfcc-ca62c1d47580"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"7927c98e-3ff0-40ea-9187-1f3575f533d3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.03205999999999999822142271455049922224`4.52656343129775", ",", "192"}], 
  "}"}]], "Output",ExpressionUUID->"4c60bb19-b637-4ce7-86c3-90f9c8218662"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"result", "[", 
  RowBox[{"[", "1", "]"}], 
  "]"}]], "Input",ExpressionUUID->"504cda74-cff5-4755-ab73-23ca6066b3b9"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"D\"\>", "\<\"0000,1\"\>"], "\[Rule]", 
  "0"}]], "Output",ExpressionUUID->"73e2ebdd-42c2-4e59-8552-49b549169479"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{"DualRInvRules", "[", 
   RowBox[{"2", ",", "8"}], 
   "]"}]}]], "Input",ExpressionUUID->"63524687-76c0-48ff-ac3c-78287d828399"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dual case\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], "\[InvisibleSpace]", "\<\" not included.\"\>"}],
  SequenceForm["Dual case", {0, 0, 0, 0, 0, 0, 0, 0}, " not included."],
  Editable->
   False]], "Print",ExpressionUUID->"4894433e-e30f-4b8d-9a20-a5ac969a311e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DualRInvRules", "[", 
   RowBox[{"2", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"91a44bee-e4aa-4d40-841f-6b8aa72c0ed7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ca9f0f64-3fea-498c-9ec7-3a22d86d1e5c"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"D\"\>", "\<\"13,920\"\>"], "\[Rule]", 
  "0"}]], "Output",ExpressionUUID->"ed3c2b81-c8cf-4ca8-9398-e445e409cb64"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Read Bianchi rules: step 3", \
"Subsubsection",ExpressionUUID->"3624e225-ab3a-4ba7-984a-be9ede582c3a"],

Cell["Invariants:", \
"Text",ExpressionUUID->"0e367c82-8638-4bc5-bbea-5b52ede38914"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInvs", "[", 
    RowBox[{"3", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"RInvs", "[", 
      RowBox[{"3", ",", "case"}], "]"}], ",", 
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"RInvs", "[", 
        RowBox[{"2", ",", "case"}], "]"}], ",", 
       RowBox[{"First", "/@", 
        RowBox[{"RInvRules", "[", 
         RowBox[{"3", ",", "case"}], "]"}]}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvs", "[", 
    RowBox[{"3", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"DualRInvs", "[", 
      RowBox[{"3", ",", "case"}], "]"}], ",", 
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"DualRInvs", "[", 
        RowBox[{"2", ",", "case"}], "]"}], ",", 
       RowBox[{"First", "/@", 
        RowBox[{"DualRInvRules", "[", 
         RowBox[{"3", ",", "case"}], "]"}]}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5dbbba1d-944b-46d2-8e67-1670798f6d79"],

Cell["Rules:", "Text",ExpressionUUID->"816e0e03-f2d2-41b9-9e97-2403d115c65b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RInvRules", "[", 
    RowBox[{"3", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Reading InvRules for step 3 and case \>\"", ",", "case"}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"result", "=", 
       RowBox[{"ReadInvarRules", "[", 
        RowBox[{
         RowBox[{"$DataBaseDir", "<>", "\"\<3/\>\"", "<>", 
          RowBox[{"filename", "[", 
           RowBox[{"3", ",", "case"}], "]"}]}], ",", "\"\<Mathematica\>\""}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"RInvRules", "[", 
         RowBox[{"3", ",", "case"}], "]"}], ",", "result"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b20d08b3-f8a4-4fd4-ac3d-af4e06b1cdf1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvRules", "[", 
    RowBox[{"3", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxDualIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Reading DualInvRules for step 3 and case \>\"", ",", 
        "case"}], "]"}], ";", 
      RowBox[{"result", "=", 
       RowBox[{"ReadInvarRules", "[", 
        RowBox[{
         RowBox[{"$DataBaseDir", "<>", "\"\<3/\>\"", "<>", 
          RowBox[{"dualfilename", "[", 
           RowBox[{"3", ",", "case"}], "]"}]}], ",", "\"\<Mathematica\>\""}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"DualRInvRules", "[", 
         RowBox[{"3", ",", "case"}], "]"}], ",", "result"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"96b97b3e-1ba5-4de2-aea3-342bb9911349"],

Cell["Examples:", \
"Text",ExpressionUUID->"eb89cf81-612e-435e-930e-b38a4f171e1f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"554a3b6c-0c4b-4cd1-9495-60cb631a42b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"902c4f5f-b03d-44c7-93ee-e3fb05a431ec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.06496200000000000585043125056472490542`4.833259300442438", ",", "945"}], 
  "}"}]], "Output",ExpressionUUID->"e2541236-008e-4fb6-a13d-7fe68a39ea59"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"efd00df3-33e7-4693-8a4c-ea99ff7f4c98"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00071400000000000000792421683826205481`2.874298125055798", ",", "945"}], 
  "}"}]], "Output",ExpressionUUID->"00d38d1c-6779-430f-b9ae-9d428d6a1c9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvRules", "[", 
   RowBox[{"3", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"a26e0b05-471d-4159-bbbb-e9a1fce08279"],

Cell[BoxData["945"], \
"Output",ExpressionUUID->"7fd4fdac-7892-4972-8d7f-0bf5749599e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", 
   RowBox[{"3", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"019b2371-1ee0-4627-a804-070c628238aa"],

Cell[BoxData["442"], \
"Output",ExpressionUUID->"bae65fd3-a195-4fda-ba54-b07f480329dc"]
}, Open  ]],

Cell["Duals:", "Text",ExpressionUUID->"55f5ab98-d2db-407c-853b-80c67704e765"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"DualRInvRules", "[", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"fed86b1e-34b1-400d-a27c-7a85baa77df3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f7c1ed4a-4dff-4b3a-8014-97bb7ee1f1ef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.02921699999999999991517896091863804031`4.486235533832953", ",", "126"}], 
  "}"}]], "Output",ExpressionUUID->"ab4e69f9-02ad-4690-a676-2749e0207448"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"DualRInvRules", "[", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"c349fccf-c41b-4a2a-982b-6bcadb098fee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00001399999999999999978999003918955779`1.1667279489578624", ",", "126"}],
   "}"}]], "Output",ExpressionUUID->"e8e14069-b2ab-4097-bd58-86ec9e26b214"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DualRInvRules", "[", 
   RowBox[{"3", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"ab8828e4-cc4b-492c-a62b-9345546b1cd0"],

Cell[BoxData["126"], \
"Output",ExpressionUUID->"26245f8a-83c0-4496-a353-09c6840f1d5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", 
   RowBox[{"3", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"11455d42-7182-4f05-a604-d297f97a9f8e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"aee50c7b-846f-46bd-97c7-118aa541c609"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9c900bb0-ad97-4c55-b9a6-7b52e503ee5a"]
}, Open  ]],

Cell[BoxData["23"], \
"Output",ExpressionUUID->"601404b7-a8f2-4b7c-a658-126c16d6f952"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Read Commute rules: step 4", \
"Subsubsection",ExpressionUUID->"f7720055-28de-4b5c-b23e-320d41d68ca4"],

Cell["Invariants:", \
"Text",ExpressionUUID->"123f21f5-cd87-4e9f-98d3-af68d53d90da"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInvs", "[", 
    RowBox[{"4", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"RInvs", "[", 
      RowBox[{"4", ",", "case"}], "]"}], ",", 
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"RInvs", "[", 
        RowBox[{"3", ",", "case"}], "]"}], ",", 
       RowBox[{"First", "/@", 
        RowBox[{"RInvRules", "[", 
         RowBox[{"4", ",", "case"}], "]"}]}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvs", "[", 
    RowBox[{"4", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"DualRInvs", "[", 
      RowBox[{"4", ",", "case"}], "]"}], ",", 
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"DualRInvs", "[", 
        RowBox[{"3", ",", "case"}], "]"}], ",", 
       RowBox[{"First", "/@", 
        RowBox[{"DualRInvRules", "[", 
         RowBox[{"4", ",", "case"}], "]"}]}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5db18b90-f647-4fa5-9f77-4492801fcbbc"],

Cell["Rules:", "Text",ExpressionUUID->"2ffe9d83-7d69-4173-9e91-67a5cfd07946"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$ExpandedCommuteOrder12Q", "=", "False"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fde99661-ad46-4107-b097-e5358cd7c446"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"extendedQ", "[", "case_", "]"}], ":=", 
   RowBox[{"$ExpandedCommuteOrder12Q", "/;", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"InvarCases", "[", 
       RowBox[{"12", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], ",", "case"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"extendedQ", "[", "case_", "]"}], ":=", "True"}], ";"}]}], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"299319c0-6c18-4ce6-80c7-680f4e5db840"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"extendedQ", "[", 
  RowBox[{"{", "8", "}"}], 
  "]"}]], "Input",ExpressionUUID->"90f86894-3fa2-4aa3-bd2d-a9885a12ce09"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"a64b5ac6-c149-40e6-86fe-969339473b58"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"extendedQ", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"b0932470-40c0-4c91-9131-560731e29363"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"25f86269-7bf1-4932-96b4-48218bde86d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"extendedQ", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "8"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"8a15d014-b645-4a9f-ae19-3f8622fcfada"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"d5aa4efd-bf40-4d8c-8885-aea71ea3edbf"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RInvRules", "[", 
    RowBox[{"4", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"result", ",", 
       RowBox[{"eQ", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"extendedQ", "[", "case", "]"}], ",", "\"\<\>\"", 
          ",", "\"\<NE\>\""}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
        RowBox[{"\"\<Reading \>\"", "<>", "eQ", 
         "<>", "\"\<InvRules for step 4 and case \>\""}], ",", "case"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"result", "=", 
       RowBox[{"ReadInvarRules", "[", 
        RowBox[{
         RowBox[{"$DataBaseDir", "<>", "\"\<4/\>\"", "<>", 
          RowBox[{"filename", "[", 
           RowBox[{"4", ",", "case"}], "]"}], "<>", "eQ"}], 
         ",", "\"\<Mathematica\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"RInvRules", "[", 
         RowBox[{"4", ",", "case"}], "]"}], ",", "result"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9892df29-d6a1-43ba-b77f-0b42ab72a13f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvRules", "[", 
    RowBox[{"4", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxDualIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Reading DualInvRules for step 4 and case \>\"", ",", 
        "case"}], "]"}], ";", 
      RowBox[{"result", "=", 
       RowBox[{"ReadInvarRules", "[", 
        RowBox[{
         RowBox[{"$DataBaseDir", "<>", "\"\<4/\>\"", "<>", 
          RowBox[{"dualfilename", "[", 
           RowBox[{"4", ",", "case"}], "]"}]}], ",", "\"\<Mathematica\>\""}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"DualRInvRules", "[", 
         RowBox[{"4", ",", "case"}], "]"}], ",", "result"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"dbf20002-15d8-471b-b796-892d67bfb04f"],

Cell["Examples:", \
"Text",ExpressionUUID->"8b0ec5f9-9dc3-47ee-b8cc-dd0a4a8ec774"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"3e65bc22-af6b-4605-9637-cd557d56f56b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"42e48094-6164-49e3-8a19-5fd6143fa13e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.08251000000000000000888178419700125232`4.93710650039478", ",", "389"}], 
  "}"}]], "Output",ExpressionUUID->"df931724-72cf-42dc-b5c4-57d3a5e4d18e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"902be3b0-122c-4ba5-9e74-8ea9f66f97d2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00122900000000000005767608612927688228`3.110151796166078", ",", "389"}], 
  "}"}]], "Output",ExpressionUUID->"df42e278-4999-4ef0-9aad-3af41d81652b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvRules", "[", 
   RowBox[{"4", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"311bd4ce-a998-44fb-be5c-b96640efa7fb"],

Cell[BoxData["389"], \
"Output",ExpressionUUID->"9dddd949-c979-4d0c-8a14-f17d8be1ea80"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", 
   RowBox[{"4", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"507bfacd-0e47-42c3-b4a5-844360408138"],

Cell[BoxData["53"], \
"Output",ExpressionUUID->"04a7a89d-b3f5-4ed6-b045-f484fa11c830"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Read Dim-dep rules: step 5", \
"Subsubsection",ExpressionUUID->"15cbd8ee-cea4-4ab7-8212-afd5e491583f"],

Cell["Invariants:", \
"Text",ExpressionUUID->"231e6e7f-dc2a-41e0-85a1-9fa4b42981a6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInvs", "[", 
    RowBox[{"5", ",", "case_"}], "]"}], ":=", 
   RowBox[{"RInvs", "[", 
    RowBox[{"5", ",", "case", ",", "$DefaultDim"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RInvs", "[", 
    RowBox[{"5", ",", "case_", ",", "dim_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"RInvs", "[", 
      RowBox[{"5", ",", "case", ",", "dim"}], "]"}], ",", 
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"RInvs", "[", 
        RowBox[{"4", ",", "case"}], "]"}], ",", 
       RowBox[{"First", "/@", 
        RowBox[{"RInvRules", "[", 
         RowBox[{"5", ",", "case", ",", "dim"}], "]"}]}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvs", "[", 
    RowBox[{"5", ",", "case_"}], "]"}], ":=", 
   RowBox[{"DualRInvs", "[", 
    RowBox[{"5", ",", "case", ",", "$DefaultDim"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvs", "[", 
    RowBox[{"5", ",", "case_", ",", "dim_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"DualRInvs", "[", 
      RowBox[{"5", ",", "case", ",", "dim"}], "]"}], ",", 
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"DualRInvs", "[", 
        RowBox[{"4", ",", "case"}], "]"}], ",", 
       RowBox[{"First", "/@", 
        RowBox[{"DualRInvRules", "[", 
         RowBox[{"5", ",", "case", ",", "dim"}], "]"}]}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"599448b7-3f4e-4194-9781-8b81f045a1e3"],

Cell["Rules:", "Text",ExpressionUUID->"80c40114-e134-4ecb-984c-6d6d342a68c1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInvRules", "[", 
    RowBox[{"5", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"5", ",", "case", ",", "$DefaultDim"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RInvRules", "[", 
    RowBox[{"5", ",", "case_List", ",", "dim_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Reading InvRules for step 5, case \>\"", ",", "case", 
        ",", "\"\< and dimension \>\"", ",", "dim"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"result", "=", 
       RowBox[{"ReadInvarRules", "[", 
        RowBox[{
         RowBox[{"$DataBaseDir", "<>", "\"\<5_\>\"", "<>", 
          RowBox[{"ToString", "[", "dim", "]"}], "<>", "\"\</\>\"", "<>", 
          RowBox[{"filename", "[", 
           RowBox[{"5", ",", "case", ",", "dim"}], "]"}]}], 
         ",", "\"\<Mathematica\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"RInvRules", "[", 
         RowBox[{"5", ",", "case", ",", "dim"}], "]"}], ",", "result"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a86b796c-3f69-4ddc-8210-23f9e0389282"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvRules", "[", 
    RowBox[{"5", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"DualRInvRules", "[", 
    RowBox[{"5", ",", "case", ",", "$DefaultDim"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvRules", "[", 
    RowBox[{"5", ",", "case_List", ",", "dim_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"MaxDualIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Reading DualInvRules for step 5 and case \>\"", ",", 
        "case"}], "]"}], ";", 
      RowBox[{"result", "=", 
       RowBox[{"ReadInvarRules", "[", 
        RowBox[{
         RowBox[{"$DataBaseDir", "<>", "\"\<5_\>\"", "<>", 
          RowBox[{"ToString", "[", "dim", "]"}], "<>", "\"\</\>\"", "<>", 
          RowBox[{"dualfilename", "[", 
           RowBox[{"5", ",", "case", ",", "dim"}], "]"}]}], 
         ",", "\"\<Mathematica\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProtSet", "[", 
       RowBox[{
        RowBox[{"DualRInvRules", "[", 
         RowBox[{"5", ",", "case", ",", "dim"}], "]"}], ",", "result"}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5d958d01-a01c-43ff-b948-22e8391ec8ca"],

Cell["Examples:", \
"Text",ExpressionUUID->"47396da1-b476-4f12-a3bb-24f34021efaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", "4"}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"8d65852b-819d-464e-987a-04a963c46800"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 1, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"0067d6ba-1b0a-4b74-bbce-6b150f584e72"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.03519300000000000205879757686489028856`4.567056202789226", ",", "11"}], 
  "}"}]], "Output",ExpressionUUID->"64cb0f44-e6db-47e1-8a23-69e625ffbcfc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Length", "[", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", "4"}], "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"1b827306-7860-42a0-b30d-c2c6cf89263c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.00001699999999999999986599261148079165`1.2510488346578978", ",", "11"}], 
  "}"}]], "Output",ExpressionUUID->"5e6778e2-0c11-44a2-a2cf-2e0c0765d523"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RInvs", "[", 
   RowBox[{"5", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", "4"}], "]"}], "//", 
  "Length"}]], "Input",ExpressionUUID->"9dea67f9-a868-47f9-bf5a-90923fe5afc3"],

Cell[BoxData["42"], \
"Output",ExpressionUUID->"421e1a8c-aa36-4355-9943-12b529edca6b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Read metric-signature rules: step 6", \
"Subsubsection",ExpressionUUID->"0dcc8057-a34a-4cd6-99a5-d7dc161f8964"],

Cell["\<\
Finally we read the metric-signature dependent relations. There are only 25 \
independent objects:\
\>", "Text",ExpressionUUID->"ddb5d124-475f-41bd-9c7a-ad810c26619d"],

Cell["Invariants:", \
"Text",ExpressionUUID->"2342c6b9-20f1-44f6-b20b-303ca5c51a7f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInvs", "[", 
    RowBox[{"6", ",", "case_"}], "]"}], ":=", 
   RowBox[{"RInvs", "[", 
    RowBox[{"6", ",", "case", ",", "$DefaultDim"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RInvs", "[", 
    RowBox[{"6", ",", "case_", ",", "dim_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"RInvs", "[", 
      RowBox[{"6", ",", "case", ",", "dim"}], "]"}], ",", 
     RowBox[{"Complement", "[", 
      RowBox[{
       RowBox[{"RInvs", "[", 
        RowBox[{"5", ",", "case", ",", "dim"}], "]"}], ",", 
       RowBox[{"First", "/@", 
        RowBox[{"RInvRules", "[", 
         RowBox[{"6", ",", "case", ",", "dim"}], "]"}]}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvs", "[", 
    RowBox[{"6", ",", "case_"}], "]"}], ":=", 
   RowBox[{"DualRInvs", "[", 
    RowBox[{"6", ",", "case", ",", "$DefaultDim"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualRInvs", "[", 
    RowBox[{"6", ",", "case_", ",", "dim_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"DualRInvs", "[", 
      RowBox[{"6", ",", "case", ",", "dim"}], "]"}], ",", 
     RowBox[{"DualRInvs", "[", 
      RowBox[{"5", ",", "case", ",", "dim"}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5ae7711f-f4cd-4667-ba59-d4c0359ed3da"],

Cell["Higher degrees:", \
"Text",ExpressionUUID->"2e056911-f658-478e-8bb5-27c3cdbe0230"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RInvRules", "[", 
    RowBox[{"6", ",", "case_List"}], "]"}], ":=", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"6", ",", "case", ",", "$DefaultDim"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RInvRules", "[", 
    RowBox[{"6", ",", "case_List", ",", "dim_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "sigma", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MaxIndex", "[", "case", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Reading InvRules for step 6, case \>\"", ",", "case", 
          ",", "\"\< and dimension \>\"", ",", "dim"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"result", "=", 
         RowBox[{"ReadInvarRules", "[", 
          RowBox[{
           RowBox[{"$DataBaseDir", "<>", "\"\<6_\>\"", "<>", 
            RowBox[{"ToString", "[", "dim", "]"}], "<>", "\"\</\>\"", "<>", 
            RowBox[{"filename", "[", 
             RowBox[{"6", ",", "case", ",", "dim"}], "]"}]}], 
           ",", "\"\<Mathematica\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"ProtSet", "[", 
         RowBox[{
          RowBox[{"RInvRules", "[", 
           RowBox[{"6", ",", "case", ",", "dim"}], "]"}], ",", "result"}], 
         "]"}]}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}], ";"}]}], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"d458dd0c-9ace-4b10-b9c5-ca3d0ec7a15e"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbers", \
"Subsection",ExpressionUUID->"4a5829a4-1648-4b4b-a858-6b2d6cac141d"],

Cell[CellGroupData[{

Cell["Diagonals 1 to 5", \
"Subsubsection",ExpressionUUID->"544bfd5b-f78a-4e89-85de-75bd173bbc08"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"memory", "=", 
  RowBox[{
  "MemoryInUse", "[", 
   "]"}]}]], "Input",ExpressionUUID->"4a261b22-5861-45b9-8df5-45e5a7e82f43"],

Cell[BoxData["64762768"], \
"Output",ExpressionUUID->"cb6edf50-d1fd-4a53-a2b2-581865c8a6fb"]
}, Open  ]],

Cell["Read first five diagonals:", \
"Text",ExpressionUUID->"0b24e821-028d-4e06-bbf6-43118d1b3529"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefaultDim", "=", "4"}], 
  ";"}]], "Input",ExpressionUUID->"122f3d89-7929-4959-9c29-5600ea3be554"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"RInvs", "[", 
     RowBox[{"step", ",", 
      RowBox[{
       RowBox[{"InvarCases", "[", "]"}], "[", 
       RowBox[{"[", "case", "]"}], "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"step", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"case", ",", "34"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"0bcb13d7-0784-4480-8362-fb87e383fd88"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"7b01fd1f-9005-4a4f-8dad-5d4262483e50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"71262bba-0a2b-4cdf-b37b-d88970cef129"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"bc41759b-c8b6-4453-87fa-abdb1c4cc00f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"ff9203c3-0af1-4577-80f7-7029e9b736e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a14f10ac-dd5b-40aa-b84e-f867333efbfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"d4a0bc9c-3802-4c46-a12b-582ebd92207a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"888d9c61-abd3-4a4c-b322-7a9e8b216e9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"88596d54-f07b-457a-9ae8-717c9ea2fd35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"1e1176f4-509d-421d-b827-10a0acd02a5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"43b234fe-5765-4bb2-98fc-cfde7ccf6bc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"aa48451f-4b4a-4adf-b050-8cdc4393890c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b3a3b91b-c3d6-4385-aa8a-394e3637d25f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"edbf211e-5720-4fe0-ac66-3faace34c6a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"7457215a-f5ed-4df1-833d-3296bb2107f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"811e457e-1221-405f-99cf-1fdc83bbfdb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"7168d1b4-5708-4b1e-bc27-5897b49082d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"98d3ed21-5295-4148-9352-53cee5e1b5e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"db46be21-afa4-4c3e-8f12-fbf0b95ea165"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ae41f502-f77a-48c7-8e6c-047ba798fd39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"f8cfdf14-c75d-44e2-85b9-c73d52bb9ab9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"e36190f6-8ca2-41ce-a0b5-f8becb73e3c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"5ad9f3b1-b77e-48cd-9d5a-b99a340d8f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"fcc02c69-dc1d-4c71-a3e3-d01b107bd8c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"42f24835-7499-4ec7-b959-eae6717a1fc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"5915d661-e2f6-4205-b4ac-525e988a1842"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"24f90283-6572-48f4-bdb9-f75e719d733f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"4e491ca5-7d08-44d5-b3b7-5c40899636f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"f528a5a0-5c5e-41aa-91dd-a810b010e173"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"1549d5c4-a63b-426e-bcae-37bc3643809d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"528082e0-c21b-4ed5-94d9-2d96636e2922"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f197d10f-910b-43bd-93ce-1d594f5aee60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"e8d93824-0a7d-4b40-9046-b7e0881dd6f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"69ea01e8-dec3-4215-be33-012ed73baa5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"b1598e2f-490d-4da4-9c9e-bb7a83be21a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"91104cfe-6352-44e6-a5ce-f4bb2d9cb9dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"4a6de142-8816-4b28-8de8-2607acc0d844"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"827e75d0-ae32-4fb1-bf87-8c9469b2fb13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"bdbb454a-9a42-4b71-9eaf-f349e9c7d89d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"e50b98fb-c08f-48f2-ad75-c0292f89e4ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"8d087c2a-8f0f-4a40-8d50-2181af2d0d92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e84dae29-7b3f-498f-87ea-d89e71041152"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"5031a63b-43eb-4da9-a457-234dd46847a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1e109173-a8ad-4479-bdc3-f9bf92413480"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"66dd3680-1ed0-4c23-82ff-5ff5908010cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"9f963cff-6923-4e81-b5db-cf4fda095895"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"9ca2cc62-3059-4cf7-a824-70347c14924c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"39573b73-e555-4400-8132-b18de0ce4edb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ba0979d1-48fe-4493-bf11-5727818deef6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"430a2e3b-b833-476e-8987-10c45e0474e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"dbe37d9c-1724-4b05-a164-58527aabf1b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d2b62322-f0d3-4e0a-90c0-c61ffa4d89fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"150f7415-d560-41a5-91d7-b2d09ae883b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"9a238a42-1295-4892-895c-181f64cc81a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"6459c7bd-5bb2-401f-bb30-b7a21ce58932"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ecd5bab1-0b60-418f-8449-22a8845c5ad4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"cf4606dd-bddc-442c-83ac-10ebc4b3396a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"42e2572d-1c89-40bb-afc9-6e20050b7994"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a2d970f4-692f-44d2-b3fe-2c68b5418b71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"25e157e1-6b09-4ba1-8b5f-7da76e1c1976"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d1e04b55-d727-44e2-aad0-eb2ea559cf00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b2abcade-e734-4e6b-b185-2fe5037edd0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f5749536-d6f3-4f26-9f88-60f2f2a8ba69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9d87d7db-be67-4b40-8411-de4090995b78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"e0f1ecc1-6c62-4089-b0fe-fccf5d6410df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"37b9d143-2547-4f66-bd71-0e1e439011a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"db1a850d-7409-43e2-9d24-185075c0efac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"0b0a0c5c-66ed-4af8-b8af-141c2899bb17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"8c6c844f-1fd8-4e93-8da2-d7838da54c48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"4d63a8ad-44bf-40ab-8451-d17c0be69e69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"1250c9fc-12f7-4a7a-bd49-14ba4371cad0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"02185611-56c7-4239-a294-baac2f408d50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"37f0550b-4142-4789-9dbe-821b544cf54c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"c846932e-5d12-4906-803a-b02aa32ab740"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"6792fc90-550f-40cc-a5f1-402b8516fd78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"5a4f18fe-ee96-4ceb-b2e9-6ef123bd3585"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"5bee5773-efea-458b-8d66-beec79461982"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e71e4476-a9b8-4df7-8411-f9021f4edb7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"980f8c41-4ce2-4d38-b3b9-0af40387d006"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"a8cdba98-d349-42d7-8267-accdc9a28210"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a57faf15-1cce-47cc-86b4-ba54b4520871"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"bae67f8c-7ffa-4422-b049-3ef526330e4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"81e6aef5-b319-4636-a956-05e873a19085"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a77420f7-12b0-451a-bd4a-613d7adad402"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"658889dd-8975-402b-a5d5-a38ebd7ea7ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"65844668-7300-4ed2-ba46-d23f117d58e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"61f3a855-85b0-4a4d-a70f-0062c88cd568"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"cc177651-27e0-4d9a-8afe-a0c1ea1abe96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"99cd3abb-e92d-4f57-ab2e-7912f6858236"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"315a5644-3bd4-4975-8915-012fb6597653"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"aec01549-e721-42b4-bf3d-190d8151aa4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ebd183b9-38d3-421e-b299-2569626f653f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"5fc7704a-86fa-4337-a02e-e8186b99fa8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"4564f7b7-28df-4a19-a193-9400a41f2a56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"bb0c26f3-43a9-459f-8fec-83b8509c6bb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"37fc4ad7-b0b2-494c-b447-4d073857b567"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"324a79f3-03a6-40c3-bb8a-2fb8046d5be7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"0e21ef15-d8c7-4b65-b399-74197cdb95aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"b3377031-5057-49ef-ac86-1db0fea674f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"2c6f7aff-ad91-4130-ba9e-e610645f85f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"7930f404-f3ed-4516-bcff-6046b71814f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"7f000d49-0e1d-476c-9a88-8308fe152a5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"546e4888-a99a-4ced-9608-4824ba09bf1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"c4704904-8730-412f-b7df-80a981ed2645"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"b7cc9b8d-b807-48ba-977a-c88bc21d3990"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"2395d2b2-a2f5-4f1c-9517-fafb4d3c31a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"da57cb46-07a3-4aa8-bb64-be370ccb6164"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"bb74e274-2d47-4578-8fbb-6da4e25330b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"13bb2453-0f8b-4870-b09e-d950ca80f55f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"9343fb67-f657-47c6-938c-ebecc38cf664"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"baf74f1a-6a21-40a7-bd05-c672cf1b3664"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {6}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"09d654e4-9f17-45d0-87b6-4b23ac4f288e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"5bea5938-19f2-4c2f-8251-02aea7e5a4d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"80a92a27-1fe6-4b6b-a1cb-f74ea210906d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"ba0f3716-537f-4463-b3a5-723471547e43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"6ed9f449-468f-4e77-8df5-66bfb9a187aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"43a3bae0-a4cc-4228-9d9b-51548cb8082e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 1, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"3b519845-1050-4eaa-8ac9-a03204e2d44a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 6}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"9b4e15c6-ca0c-45e8-b82b-8e90a855b318"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 5}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"a99c49c0-0bcb-4bd9-859c-735bac7520a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {2, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"75c8c8b5-b1c9-41b9-a1af-08fbed468f62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {3, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"f1fcb383-01a3-4eac-b2e7-a2f1a02be7ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {8}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"9bc40e72-0aea-44b7-b3d3-fd82a3899bb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 0, 0, 0}, " and dimension ",
    4],
  Editable->
   False]], "Print",ExpressionUUID->"a5d98ca1-144f-4396-814d-9ce52d327613"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 0, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"cb44c155-08d7-4211-9f00-7165fa351032"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"dd1de38c-7a06-414e-ab3b-0f044976edff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"0bdfa9b2-7ca5-462f-882f-deb8565d7f21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 1, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"6ecb08e2-439d-4b19-824a-0e23d0c155e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"bb1644e1-2b43-498f-a94d-57c95dff37cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 1, 1, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"f4a88ce2-7f28-485c-acaa-c4fd114ac772"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 1, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"ba8b1f22-a69c-41b4-8cc0-9c2a1fa3f884"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"3fb22896-4a62-43df-8792-69c5503e0842"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"03b60f06-5767-4688-ac92-45d616625884"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"36583864-c308-4e14-b6ec-00dbcf95c2dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"e6064b71-71ec-4529-ae1f-aa31d88afb08"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"7a3683d1-2d91-4c84-b955-affa33a8fc01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"34dc880e-19f0-477e-9fb9-d83b8df73916"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"b4e05f0a-9586-42f0-8405-ed797c9398c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"09c4f610-4325-42ce-a0e8-7a6d595e1881"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"e8bf9a49-2c6e-4ea7-857a-d534b96eb305"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"9799bff7-b58e-4bdf-8a24-ae4ae50f3967"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"f725046f-f9bf-4685-a622-4ea6485f33ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"ef8a539c-cd9d-445a-913e-c9c6d017e77a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"8a6aabd0-6b26-44ba-b4fc-393438a22266"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {6}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"38e4d00e-1267-4da1-afc5-3f2262c691ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"2f732708-c424-4008-8e03-3b26304bf2c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"d290c2f1-8918-494b-af5f-0fbda9be3ac4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"9535ebe9-474d-49e8-a6c5-fa78a8ca4bb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"e51906e6-2e3a-434a-969e-b490488304ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 1, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"5538df9d-b163-4315-880e-09ec7a8b3cb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"ebef4f6a-3568-46cc-be97-87e250fb8de5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 1, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"771ef4ce-f30a-496e-9804-9dab21a7ef62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 6}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"a7714425-4f32-4eff-8c9c-648f52604090"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 5}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"ecbcf703-3750-4874-b6a7-176403639fb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {2, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"72e68cce-ae40-4073-a665-987e01c58d16"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {3, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"722a826a-5c26-44ca-9b68-ce408d8cd377"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {8}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"5011e9bd-4cbc-4437-8aab-043934ee3d10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 0, 0, 0}, " and dimension ",
    4],
  Editable->
   False]], "Print",ExpressionUUID->"25247141-57b9-4a74-94ac-5ac09dcef027"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 0, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"b6eb5ad9-e26d-4ef6-91c9-76227f5d0e77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"ed7ae0d3-aec4-46d9-9111-6d2fc0773223"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"7ce26d35-c596-4501-b9c7-f14ccc2e4100"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 1, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"f1c010af-3936-431d-ab6d-41ffd82577eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"29725e95-2edc-4b33-95bb-5f2c9a3ddab2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 1, 1, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"8486c010-ebbc-40b7-b4e2-28f65198b09e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 1, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"c4d70192-068f-4cd1-9771-bd813320f792"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "9", ",", "12", ",", "12", ",", "12", ",", 
     "38", ",", "99", ",", "125", ",", "126", ",", "138", ",", "86", ",", 
     "105", ",", "204", ",", "1020", ",", "1749", ",", "1473", ",", "3099", ",",
      "1622", ",", "1617", ",", "1665", ",", "1770", ",", "1746", ",", "962", 
     ",", "1155", ",", "1613", ",", "12722", ",", "27022", ",", "19617", ",", 
     "60984", ",", "30974", ",", "62465", ",", "5606"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "2", ",", "5", ",", "9", ",", "9", ",", "11", ",", 
     "15", ",", "48", ",", "63", ",", "84", ",", "95", ",", "59", ",", "90", ",",
      "54", ",", "313", ",", "564", ",", "648", ",", "1387", ",", "727", ",", 
     "741", ",", "1025", ",", "1115", ",", "1093", ",", "612", ",", "945", ",",
      "270", ",", "2495", ",", "5439", ",", "5622", ",", "17662", ",", "9030",
      ",", "18272", ",", "1733"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "1", ",", "5", ",", "5", ",", "4", ",", "6", ",", 
     "15", ",", "27", ",", "23", ",", "47", ",", "32", ",", "23", ",", "50", ",",
      "54", ",", "175", ",", "194", ",", "361", ",", "442", ",", "244", ",", 
     "143", ",", "570", ",", "362", ",", "356", ",", "211", ",", "525", ",", 
     "270", ",", "1371", ",", "1725", ",", "3094", ",", "5440", ",", "2861", ",",
      "3226", ",", "210"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "1", ",", "5", ",", "3", ",", "4", ",", "1", ",", 
     "15", ",", "15", ",", "23", ",", "3", ",", "5", ",", "7", ",", "1", ",", 
     "54", ",", "79", ",", "194", ",", "17", ",", "53", ",", "46", ",", "67", 
     ",", "3", ",", "5", ",", "9", ",", "9", ",", "1", ",", "270", ",", "549",
      ",", "1725", ",", "99", ",", "577", ",", "445", ",", "1235", ",", 
     "210"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "1", ",", "3", ",", "3", ",", "4", ",", "1", ",", "4",
      ",", "10", ",", "17", ",", "3", ",", "5", ",", "7", ",", "1", ",", "5", 
     ",", "26", ",", "76", ",", "12", ",", "42", ",", "34", ",", "52", ",", 
     "3", ",", "5", ",", "9", ",", "9", ",", "1", ",", "8", ",", "66", ",", 
     "245", ",", "37", ",", "242", ",", "169", ",", "505", ",", "86"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "1", ",", "3", ",", "3", ",", "4", ",", "1", ",", "3",
      ",", "10", ",", "17", ",", "3", ",", "5", ",", "7", ",", "1", ",", "3", 
     ",", "25", ",", "74", ",", "12", ",", "42", ",", "34", ",", "52", ",", 
     "3", ",", "5", ",", "9", ",", "9", ",", "1", ",", "4", ",", "58", ",", 
     "228", ",", "36", ",", "240", ",", "165", ",", "503", ",", "83"}], 
    "}"}]}], "}"}]], \
"Output",ExpressionUUID->"ab34720a-f7bd-4b59-9d85-b55faba7c9b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InvarCases", "[", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"Range", "[", "34", "]"}], "]"}], "]"}], "}"}], ",", "%"}], 
    "]"}], "]"}], "//", 
  "MatrixForm"}]], \
"Input",ExpressionUUID->"29558de2-80bb-41d0-aa06-c8543a16adac"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", "0", "}"}], "1", "1", "1", "1", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "3", "2", "2", "2", "2", "2"},
     {
      RowBox[{"{", "2", "}"}], "2", "2", "1", "1", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "9", "5", "5", "5", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], "12", "9", "5", "3", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "12", "9", "4", "4", "4", "4"},
     {
      RowBox[{"{", "4", "}"}], "12", "11", "6", "1", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "38", "15", "15", 
      "15", "4", "3"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2"}], "}"}], "99", "48", "27", "15", "10",
       "10"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], "125", "63", "23", "23", 
      "17", "17"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], "126", "84", "47", "3", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "138", "95", "32", "5", "5", "5"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], "86", "59", "23", "7", "7", "7"},
     {
      RowBox[{"{", "6", "}"}], "105", "90", "50", "1", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "204", 
      "54", "54", "54", "5", "3"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], "1020", "313", 
      "175", "79", "26", "25"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], "1749", "564", 
      "194", "194", "76", "74"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "4"}], "}"}], "1473", "648", "361", "17", 
      "12", "12"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "3"}], "}"}], "3099", "1387", "442", "53", 
      "42", "42"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "2"}], "}"}], "1622", "727", "244", "46", 
      "34", "34"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "2"}], "}"}], "1617", "741", "143", "67", 
      "52", "52"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}], "1665", "1025", "570", "3", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "1770", "1115", "362", "5", "5", "5"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "1746", "1093", "356", "9", "9", "9"},
     {
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "962", "612", "211", "9", "9", "9"},
     {
      RowBox[{"{", "8", "}"}], "1155", "945", "525", "1", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}],
       "1613", "270", "270", "270", "8", "4"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], "12722", 
      "2495", "1371", "549", "66", "58"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], "27022", 
      "5439", "1725", "1725", "245", "228"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], "19617", "5622", 
      "3094", "99", "37", "36"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], "60984", "17662", 
      "5440", "577", "242", "240"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], "30974", "9030", 
      "2861", "445", "169", "165"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], "62465", "18272", 
      "3226", "1235", "505", "503"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], "5606", "1733", 
      "210", "210", "86", "83"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"5dcca2f4-3418-402e-89da-b21def596148"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MemoryInUse", "[", "]"}], "/", "1024."}], "/", 
  "1000"}]], "Input",ExpressionUUID->"53235727-beae-4957-99ad-57d565c9d7e8"],

Cell[BoxData["549.7006015625`"], \
"Output",ExpressionUUID->"3f447bb9-6bf4-45dd-af43-256dabaac9cf"]
}, Open  ]],

Cell["\<\
Reading the first five diagonals takes 50 Mbytes. With eight more cases from \
the sixth diagonal it takes 350 Mbytes.\
\>", "Text",ExpressionUUID->"4896a28b-3f7f-4be7-8b9f-87f45aea01d4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MemoryInUse", "[", "]"}], "-", "memory"}], ")"}], "/", 
   "1024."}], "/", 
  "1000"}]], "Input",ExpressionUUID->"19743657-9d37-4433-8d80-653d05e25a06"],

Cell[BoxData["486.4576953125`"], \
"Output",ExpressionUUID->"2210e2a2-71af-460c-aeeb-eac2666ff497"]
}, Open  ]],

Cell["\<\
Analysis of numbers for the first five diagonals:
\tThere are originally 18550 invariants at step 1.
\tWe have 9133 rules at step 2 in terms of 6673 of the 9717 free invariants \
at step 2.
\tWe have 5839 rules at step 3 in terms of 3801 of the 3878 free invariants \
at step 3.
\tWe have 3255 rules at step 4 in terms of 618 of the 623 free invariants at \
step 4.
\tWe have 287 rules at step 5 in terms of 308 of the 336 free invariants at \
step 5.
\tWe have 6 rules at step 6 in terms of 57 of the 330 free invariants at step \
6 and 6 free dual invariants.\
\>", "Text",ExpressionUUID->"15c3c49b-66a3-492d-a767-f5097080484f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"1", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "26", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"aec0df66-9ab3-4e14-a14c-bac22a29cfe5"],

Cell[BoxData["18850"], \
"Output",ExpressionUUID->"718fcf79-3628-40b4-86eb-f84f734fea55"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"2", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "26", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"97533be3-6b06-4f7a-a29b-c9fc54c26b45"],

Cell[BoxData["9717"], \
"Output",ExpressionUUID->"ee2ae04d-627d-4549-8a8e-07b6dec41057"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"3", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "26", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"d10b23c8-ec77-4fbb-a416-34478d90b530"],

Cell[BoxData["3878"], \
"Output",ExpressionUUID->"dd006048-ac0f-4058-9484-aecfaa9417a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"4", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "26", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"4b9ca60e-b7c7-4a52-9721-888b4d674b67"],

Cell[BoxData["623"], \
"Output",ExpressionUUID->"ed926cc5-2fcc-4c47-bde9-025b3bba9e3b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"5", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "26", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"008ea0b0-21e5-4d5b-b266-dc62d262dc1c"],

Cell[BoxData["336"], \
"Output",ExpressionUUID->"4bf49b32-8543-4ff5-9872-a762bbe63ee2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"6", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "26", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"b36830a3-de8d-460c-b2c3-60f9693681d3"],

Cell[BoxData["330"], \
"Output",ExpressionUUID->"8e786b11-b2e9-4bc0-b075-e6af27a57571"]
}, Open  ]],

Cell["Check that all previous rules have been used:", \
"Text",ExpressionUUID->"c337f729-ee3a-4982-9241-e8acde5e3fe2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"check", "[", 
   RowBox[{"step_", ",", "cases_"}], "]"}], ":=", 
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"case", "=", 
      RowBox[{"cases", "[", 
       RowBox[{"[", "count", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rules", "=", 
      RowBox[{"RInvRules", "[", 
       RowBox[{"step", ",", "case"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"right", "=", 
      RowBox[{"Union", "@", 
       RowBox[{"Cases", "[", 
        RowBox[{
         RowBox[{"Last", "/@", "rules"}], ",", 
         RowBox[{"RInv", "[", 
          RowBox[{"_", ",", "_"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"inters", "=", 
      RowBox[{"Intersection", "[", 
       RowBox[{"right", ",", "knowns"}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"inters", "=!=", 
        RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<There are \>\"", ",", 
         RowBox[{"Length", "[", "inters", "]"}], 
         ",", "\"\< rules to use in case \>\"", ",", "case"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Checked case \>\"", ",", "case"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"knowns", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"knowns", ",", 
        RowBox[{"First", "/@", "rules"}]}], "]"}]}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"count", ",", "1", ",", 
      RowBox[{"Length", "[", "cases", "]"}]}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"42f455de-9c01-4737-aab4-b47a7b2804ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"knowns", "=", 
   RowBox[{"{", "}"}]}], 
  ";"}]], "Input",ExpressionUUID->"d833ef75-d4b3-4403-9d68-e682238cc214"],

Cell["These are the cases to check:", \
"Text",ExpressionUUID->"18b7e9d7-810e-4530-bb47-03a814456aa4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cases", "=", 
  RowBox[{"Append", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"InvarCases", "[", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"Range", "[", "34", "]"}], "]"}], "]"}], ",", 
    RowBox[{
     RowBox[{"InvarCases", "[", "]"}], "[", 
     RowBox[{"[", "48", "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"891f1176-7c92-4bc4-bea5-fe21e06203a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", "8", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"f500588f-b1ce-4fff-b6a5-a9c1823a58dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"2", ",", "cases"}], 
  "]"}]], "Input",ExpressionUUID->"f9671383-b5cf-40bd-93c6-469419227083"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"23fed8e3-8a01-4703-a82a-3aa3e7fe5b8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"0b2376d4-9eed-4b2d-9415-d33ed8b1ca41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"d5ea9611-d795-4207-b138-10c5af9623be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"218646e2-17a5-423b-a7f7-7f6e9949ae33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6ca2465a-9d0a-41cb-b79a-01e93e8ad460"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"e1fefc08-165f-42ef-b331-1e3198236136"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"50d5545a-401c-467b-8e66-441d555fdf6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"225620fe-34ec-476b-902c-cc9b5c6366c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"cd58b104-1e7c-4be7-ac94-b0378079765f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"bee8c162-4ae8-4e60-8efc-0d4e229a256d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1cad2b7d-207a-4efd-9a68-3c2a8af6520e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"92e7836f-8813-408b-aa2c-f2be74e02bcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e1056aeb-bc36-48ca-a0c5-bef6a6197a26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"a693117d-3cdb-4848-89d7-018e354619b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"5f4a8d45-6e8b-4a63-9092-a63cb5b435c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d2905c73-33d6-4b6b-ad5c-59d97174ac4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ef04209d-9590-4cf8-bd0d-bf348c31ef02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"88c6d4ac-45db-4287-ab62-b2a8789e12ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"cf8ae3e4-0332-4ff1-973c-6bbf4595ac57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"294f8a6d-6526-48ca-b641-e864cdfad10a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b98cdd52-3cba-4a9c-a806-a675ea9a6402"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"5cafd1c3-a7e0-463b-abfe-1cbc3d298623"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"228c1e32-2159-4e2c-9707-90f10dc4fdfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"a4a3460b-ab89-4b82-94f3-f4ecbe4b5c6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"6854e2e5-72c3-4c6c-bd8c-c46f2b42ed84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"3820a245-8849-4811-ba86-0629c23c8d1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"b39b1770-cc7c-4116-a41b-3960111982a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ae7a1500-43a0-4bbe-aa74-05fb52524b2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"4c2b8c18-2454-4525-8660-2d04f17b2d12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"bf11c9dc-134d-4c06-9f36-ff6f82974901"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b1da5cc3-3e1d-47dc-b4d9-0ff0d0fa61c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"536255a4-2294-4b28-8089-d5c75b6b8c2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b99055f0-0864-4e69-b956-e82c9fa345e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"2c65afc2-7660-498b-9f93-5ef1070a91df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"3dcb558c-72c0-4fb9-a44b-a6c35253c94c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"346c24f9-f019-42db-9a87-c0ccc8f8284e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"3", ",", "cases"}], 
  "]"}]], "Input",ExpressionUUID->"b38da6b3-11cc-4336-b12c-19c919aa58e1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"a6499c76-100f-41c9-b41b-5e3ffb552098"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"e2183d6f-0df5-4040-9aa0-376a9fa91b35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"79c89c05-444e-41da-af7c-83dbe7bfbdff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"620a9103-7f06-4ec9-9676-432739116071"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"2d429de7-6b02-4356-8371-9f13620cb937"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"73eaa525-a50a-44f8-8d36-cb8bfd3e1439"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"f4e4b49a-be6e-4e9e-9dbf-ec17f33e8f55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"c1c38423-92c7-4616-bc67-ecb74cbe777f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6ee7addd-ae55-4148-a4c3-750db74114b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"91459867-2fb6-4637-a515-b775d6f21fcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"8ec60358-2ab6-4cf7-8213-c32a764b673f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"09a4b7a9-a6f0-43a2-8766-21521e537b41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"22d9ae9d-2e59-48e6-b0d6-b78c910e96b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"afb97784-ca39-42ab-aa73-c2f2b7866704"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"b3e24781-4650-4571-af74-dc0f2b56fba9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"0228978a-c73d-46de-8674-9d3d0121483c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"3113c538-2c55-4e25-b9c8-7849bd16dab2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"8133c510-ec7a-4cd6-a9ae-55743a90dcf1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ec89841e-b29c-4667-93ab-954a30ff6b03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"cd6f679e-643e-480b-a3f7-01234c8fb1f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5b3c0f5b-ec0b-48ca-9e06-7c65c3b75fd1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"4d88bfbe-2f3c-430e-a55b-e5a226a358b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"ab96542e-e0f6-415d-9e50-5c2737184f73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"e0c26f56-89c8-4b70-8812-0f471d95809c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"6c633052-0d2b-4b40-b677-2b8d182d497f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"dff6e2d9-6df9-4ae8-92f4-ea5f8124a179"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"f067f5f5-b4fa-43cf-8e8f-0e38af8b43dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9dc68beb-cdf4-4298-a5c7-4623836c8d05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"1595d9f1-287b-4e7e-a6a1-0bb79ce79cea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"bee9f036-96ce-4345-a846-b1a5a33e7e76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"808d4a7a-b901-4411-9d7e-79a0c8be6bb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"96b817f5-ef4c-4429-9fc2-b6e22feb4fc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"3e6e81b8-85f7-46b9-898f-b9a731514855"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"294c0636-940c-4944-9d5a-1928b533d3ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"4d4fc8a4-1b0c-4bd3-bcc5-0e7e0432f497"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"8456ea08-05dc-42e3-9c35-10dade8b81d4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"4", ",", "cases"}], 
  "]"}]], "Input",ExpressionUUID->"9bb5533e-fe9b-49ba-991b-828ab65ef27c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"78edc12b-ce65-4dbb-b196-53828ff1bc99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"6cb0db8d-be4b-4d89-981f-acdfe9de8c0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"7f3d6323-fa31-4283-8590-6fe9e2e6a3b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"28d459f9-e5ab-433d-aeef-5b83c0143df3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"8c4d4264-98e6-41a8-bc13-e80b001a7f09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"3ab36fb4-b804-4bcc-b951-4957b168f161"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"970bbfa5-86af-47e2-adbd-7eadbb8716d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"fdd71a8a-5411-4454-89a3-78650e62588a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"0d1fd35e-3528-4a4b-b46e-9666429b9bde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"9894004d-2ea4-41de-b8ea-2794f95014bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"f0830712-acb3-44e1-bf9c-38f0f3e6f35f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"a71642bc-709c-4ce8-ab01-f162a21f351f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"c8faf828-540b-4f47-9e2c-f8e04971c058"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"50d3c992-a4e2-40ed-9110-11e6c3e77322"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"2d7a4dd8-c605-4dfc-8b10-eda8f6cec4a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"971278ad-665e-403e-a370-e42547530dc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"bd17fdfd-ab84-4915-b361-3c0a189c1549"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"280130eb-a945-48e5-b9ab-82c433c49d45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"20868302-eef1-49ea-9bc3-fcef14606474"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"fc1e2fc1-8df4-4c8e-8a69-be609710a15a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"c8603ca2-907e-4985-b85c-360eaa30f52b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"81da7551-d4a5-42a8-9665-025a52cb5645"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"e9ee5e25-0e31-403d-98f2-737f7c6eb73c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"566a8f18-8d8f-462f-86cd-2384d7628325"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b6766637-ee92-45b6-a355-dfdbf3d68a52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"7b917417-b51a-4716-b40b-a4a3b07742db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"1ace7588-144e-4f19-bb0c-0b3c7cacad8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"daff759e-0957-4f78-ad5b-925f4057d682"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"a1b49dcd-bb7e-4332-9c0b-d7771cec4c0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"5d0e29ef-7651-436c-9eb0-82bf8d50f8b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"fa7bde06-fc93-4a56-a2a8-048e5cd50b1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"0c126f07-27c8-4ca7-9ebf-df6cab181a31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e77c4829-a17c-4eaf-99dd-314590c853fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"20285cea-d610-4a9f-b9d4-eeb93f90c7c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"57c63d05-33ad-4e29-83a1-24af0d6da46c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"56093256-b807-44fa-b4ac-e7dc5052142f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"5", ",", "cases"}], 
  "]"}]], "Input",ExpressionUUID->"2af83326-35f3-4ec6-bc0f-ed80e3f06eb5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"224e9e24-c451-4a27-971d-cf7a0c7076b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"5f556b90-e60e-466a-8650-7384bff3b261"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"ab5e8303-7019-4480-b78b-813f8fc143db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"d428ee8c-47e6-4f4b-a878-cf1568c9013b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"4235de23-2bf9-4714-a269-bad7dc3780d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"fd44c07d-3d8d-42f1-a367-963dcf944478"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"27c8952a-e3e9-4bfd-b26a-1725ba488579"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"4c8049ba-1151-47c4-97ae-a612acef869c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"3f6391cf-d0cf-496d-814c-09954a9a791e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"6c6970c2-8a1d-428f-afe8-dca679275fc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"fa86583d-7e39-43ff-b157-00c094ac5a74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ebddc7b4-734f-4d75-bcb9-eaa5c71240c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"7cd6f0b0-edd4-4bcf-98d7-9e6f5669e24d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"ed4ca1c7-1aa0-4b71-b795-c92120852f7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"ebea3456-f577-4ce3-b844-95d4b09d31c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e994e346-2204-4249-a4ca-d326724a02c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"f4b65dd5-0558-41a6-97cb-fd5b7b58c4fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"68f20590-03bd-43f6-8198-9ad16ed1c339"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"54b4f964-805b-40fa-b850-d53fb8deeb40"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"3f0572cd-0edf-4598-9a1a-a3a78e1bda04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"1607e5ee-9399-4882-90a2-ca5035141c82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"66d8c141-51a1-4230-81eb-e9b8df83b7e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"295059ed-b597-40e8-b209-3bdeae08c9aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"159482bd-064d-4e58-afc6-fc3bc4642233"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"81dc9aa7-1c93-4f4a-95dd-b17adceb84eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"3b5bcc8a-7e7b-4438-a22e-005d35f09d1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"7698c551-ffc7-4c4f-9ea9-67a123fa8cb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5864734a-a218-4e1b-a3a6-ee018f8ba685"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"f20f2c16-30dc-4768-94a1-7cbae688ff76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"ecfbdadb-af0e-4252-a026-4df890ae5a3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"f0718195-3ae1-45bf-bc60-14fe81be467e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"999ed27f-e049-4fa2-8e0b-8e65d354fa74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"78a0f4f4-2886-4135-9575-e8fb8aefa947"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"d288697c-c928-4beb-aa94-75f83f3b48a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0, 0, 0, 0, 0}, 
   " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"612eb2cd-24d8-49be-bd18-9b734bc4dd8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"9fb26577-0ee0-48db-873b-6b9cecd41699"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"6", ",", "cases"}], 
  "]"}]], "Input",ExpressionUUID->"8ec5594b-4693-4cc5-8919-45eff620b99e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"c87053ab-b362-43ce-bee9-f51f609b69a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"4454058d-76e2-4ec3-939c-df562cfecff4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"bb2a7f90-8ffe-41e5-9e27-521bdf8dbe4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"a452b5ec-a10e-4133-954e-0e557eac27a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b6fbd4e0-754e-4891-8ce6-9fce794b4e4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"e6153a77-cd4e-479e-a137-ff4667e41cd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"6983bef1-e5e8-45a6-8c03-63196a781995"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"fa2a6abb-19af-4664-a973-e4679852e62f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"80c53eb3-ed53-4005-9943-233225f9481c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"accf9f3f-116c-4796-84e2-6867bf46adae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d4fc83e9-ec8e-40cd-b71d-6637a06e32bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"3d186b76-551b-4a07-86ca-040e7037ca3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"edd77777-e678-4354-b209-35b288393b48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"106f2f85-5b8a-454e-acdd-4701310973ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"c5b541ad-8870-4b62-a8af-0b536163741e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"89aac4db-fa0e-4e71-81a0-b3cbdebdc422"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"8b2ac6bc-ffc1-420a-8fb3-f8003608b7a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"aade4940-4d60-41ac-a267-92cd68f7d26e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"d86bcebb-f843-4836-b26c-ed9226b6c69b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b0d6fa3c-08dc-4172-832c-4cc83a21215f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"198a2f9c-5f90-47e5-abef-ff041c512f44"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"f77511a8-76f7-4627-ba6a-3d600164bb86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"0e61dc68-506c-4b6c-9dcf-8402269c5034"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"aac4ec30-9cc4-46e8-9b8c-e3ad78c3bbf8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"1f5e802f-a990-44a6-8cf5-a8dbaeabd5cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"add0bd69-1464-4d99-b67d-74344d53ad82"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"51a5efc1-c14f-4485-9d47-aba76ae7857b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d5b946d4-8068-4c87-80aa-9ea3a76ae88a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"d9d6962f-2259-47dc-87f6-073f7489a9ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"a8fa4c5c-5914-42fc-8d8a-7049ff40b638"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"9dc696a8-a944-4450-91d0-b292ef0a4573"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e3fe0d6d-423c-4c75-ade6-2b52cf50e111"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"3504728c-5147-4cac-a0c9-4bbce1d68fd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"3c04f99e-635e-495c-b778-5e37100157b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0, 0, 0, 0, 0}, 
   " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"52ccd2f2-2188-4614-8bba-d98f3a064e81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"887e9d93-b3e3-48e5-83a2-4d37d5de9b55"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"ca78dfa6-2a23-4c31-baa3-bf49ab20c025"],

Cell[BoxData["254735"], \
"Output",ExpressionUUID->"e02eeebb-e417-449f-837c-9a663def2d5c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MemoryInUse", "[", "]"}], "/", "1000."}], "/", 
  "1024"}]], "Input",ExpressionUUID->"f33261a4-ce92-47db-a54e-5bae21ca3102"],

Cell[BoxData["826.452484375`"], \
"Output",ExpressionUUID->"67a41e40-99bd-4ba1-b90f-dac8214e35d2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal 6 non-expanded", \
"Subsubsection",ExpressionUUID->"93943f01-0915-4e05-8d88-2b8f08fbf93f"],

Cell["Now we read the sixth diagonal (Commute non-expanded):", \
"Text",ExpressionUUID->"2d637eb9-ca90-4a05-932a-ee7e4d5ba727"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"RInvs", "[", 
     RowBox[{"step", ",", 
      RowBox[{
       RowBox[{"InvarCases", "[", "]"}], "[", 
       RowBox[{"[", "case", "]"}], "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"step", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"case", ",", "35", ",", "47"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"733caeda-efb4-419e-b7f6-9bae064285f5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"d8447abb-195c-4f61-aa9a-8aca54fda472"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"41006801-fab0-44b9-8022-cb80a584b990"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"99a65887-63e3-406b-9d42-dd1d49340eff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"9e8a1302-04b2-41dd-b9d3-25d2615f7b5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ba69fcd8-a5f8-4d19-9c12-05346a6b5cdd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"a2750fa4-c3df-4e23-b64b-a4939cc0d2a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d98002c8-fb27-4141-88e6-3b31d9545df4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"4e07e2a0-2fe5-4a56-9229-5e1b4e773b65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"e6b4e77a-6bda-485d-bf66-751632e2c2ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"6f145966-c9dd-463b-8fb4-7f35551ee676"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"019807b0-010d-428a-925b-da064cc316da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1d7620ba-9291-4f3f-8b82-2627fb4b0be0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"98c22e65-88f9-45bc-9fa0-a0de9a9c0589"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"cf3c510a-2168-4610-841d-33fa8a36d2d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"452ce3da-485e-4be7-8fc3-9efeef7f360d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1049de01-4f37-4a16-aa04-40d65775371d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"9e380027-c9cc-4407-bba5-f146cd703d6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e9bfef69-c0b3-4ee7-b24f-cc5b62de7085"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"3d03a67d-6c11-4eca-93c7-d295a7646b64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d3fb5acd-ce13-4fe5-bd4d-eace40352ff3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"7145b125-21b3-4675-9ef1-b365dbe7aaa5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"d6e5e44f-d950-4906-acd4-6a5d565f65fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"16bbba19-1bb0-4d82-b47b-07942039d4b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"5597ea2d-233a-4019-a28e-69455fdd1b38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"3a523ebf-66a2-4a0e-a25c-2294fd724c91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"1d6aa392-8586-4a8d-aa20-c7d60fde0007"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"4d76dac3-3977-4b54-8a60-fdc8e1d5bbad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"8a6c50a4-0e96-4b89-b11c-d108594f00d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"4ef94a9e-5cda-4a1e-b26e-31daabd4167a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"b2ebf3f5-38bb-4524-9cd3-f20a64371916"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"0b62960c-4283-4713-81a2-9539ecb48045"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"3c7cbd1c-fcab-454a-954c-2aed4e31d0c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"4cb186f6-3fb5-4ca5-bfb1-274f7085010a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"dc7e664b-d9e1-494c-ad92-7ba9fb52a756"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"651b8294-c355-4f18-86da-1dff2f8e8e19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"948fa064-bf3d-415e-8417-3e8aadbd74a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"7a2edac1-acf9-4f87-bc2b-36b4c56c60d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d5bda048-3695-488b-b1d1-f6feaf84e044"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"ecd2f45f-9a29-4d19-b2d7-ea207c6f4b63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 6}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"9c98241b-b186-4196-a3b1-a40e49e71a22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 1, 5}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"e8b4e962-539c-4875-9c2d-1f27110ee2ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 2, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"b8546514-d047-4d97-b429-4982167d15e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 1, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"3ac0c41e-59b4-4bf6-a8aa-e8466004ab23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 3, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"8c3b8543-8c8e-43c2-a76e-402387786ab0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 2, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"d2899908-43f6-4d56-b89e-cbffb924979d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {2, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"7726021e-a3b3-4ab7-8c3e-88236f3641e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 8}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"96314208-dce3-4152-9105-3cfa6f170999"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 7}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"2a1d86bd-8615-4033-bd8f-7ecfedde3004"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {2, 6}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"3583eb02-7fa9-460e-a4e6-8ea753ece90c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {3, 5}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"8a3d4219-8de5-4f18-8a5e-5da1f89f14f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {4, 4}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"7526fe2c-6590-4197-9fe0-9e4d0e6a796e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {10}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"d924a27a-d672-4071-9882-a73acf0aaa76"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "25590", ",", "53160", ",", "52764", ",", "27396", ",", "27024", ",", 
     "54654", ",", "9104", ",", "25515", ",", "26670", ",", "26460", ",", 
     "26670", ",", "13607", ",", "15120"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10600", ",", "22330", ",", "22063", ",", "11695", ",", "11402", ",", 
     "23255", ",", "3879", ",", "14910", ",", "15855", ",", "15675", ",", 
     "15855", ",", "8111", ",", "11970"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5840", ",", "6938", ",", "6861", ",", "2121", ",", "3597", ",", "4204", ",",
      "715", ",", "8225", ",", "5000", ",", "4950", ",", "5000", ",", "2615", 
     ",", "6615"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "17", ",", "55", ",", "93", ",", "83", ",", "68", ",", "212", ",", "66", ",",
      "3", ",", "5", ",", "9", ",", "11", ",", "12", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "12", ",", "44", ",", "72", ",", "66", ",", "53", ",", "171", ",", "49", ",",
      "3", ",", "5", ",", "9", ",", "11", ",", "12", ",", "1"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"a1a8c012-ca03-4876-8d34-c1b01b31111b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InvarCases", "[", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"Range", "[", 
         RowBox[{"35", ",", "47"}], "]"}], "]"}], "]"}], "}"}], ",", "%"}], 
    "]"}], "]"}], "//", 
  "MatrixForm"}]], \
"Input",ExpressionUUID->"8da9894f-1ffd-4c49-b7ce-20aa55137e6f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "6"}], "}"}], "25590", "10600", "5840", 
      "17", "12"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "5"}], "}"}], "53160", "22330", "6938", 
      "55", "44"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "4"}], "}"}], "52764", "22063", "6861", 
      "93", "72"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "4"}], "}"}], "27396", "11695", "2121", 
      "83", "66"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "3"}], "}"}], "27024", "11402", "3597", 
      "68", "53"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "54654", "23255", "4204", 
      "212", "171"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "2"}], "}"}], "9104", "3879", "715", "66", 
      "49"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}], "25515", "14910", "8225", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "7"}], "}"}], "26670", "15855", "5000", "5", "5"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "6"}], "}"}], "26460", "15675", "4950", "9", "9"},
     {
      RowBox[{"{", 
       RowBox[{"3", ",", "5"}], "}"}], "26670", "15855", "5000", "11", "11"},
     {
      RowBox[{"{", 
       RowBox[{"4", ",", "4"}], "}"}], "13607", "8111", "2615", "12", "12"},
     {
      RowBox[{"{", "10", "}"}], "15120", "11970", "6615", "1", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"3b7de78e-3e31-417c-bfab-fbe8a8aa6d2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MemoryInUse", "[", "]"}], "/", "1024."}], "/", 
  "1000"}]], "Input",ExpressionUUID->"17a48502-cf01-4ca6-9bc1-e4b303223b23"],

Cell[BoxData["3481.2755781250003`"], \
"Output",ExpressionUUID->"24f1935a-bffa-4773-9186-1377a0846b67"]
}, Open  ]],

Cell["\<\
Analysis of numbers for the first six diagonals:
\tThere are originally 623587 invariants at step 1.
\tWe have 365747 rules at step 2 in terms of 212119 of the 257840 free \
invariants at step 2.
\tWe have 169204 rules at step 3 in terms of 84409 of the 84756 free \
invariants at step 3.
\tWe have ? rules at step 4 in terms of ? of the 6368 free invariants at step \
4.
\tWe have ? rules at step 5 in terms of 2129 of the 2202 free invariants at \
step 5.\
\>", "Text",ExpressionUUID->"75f6d445-437b-48ce-a7fe-686d7550385e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"1", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"cecb85ce-08ca-421f-b818-aed063cb63fd"],

Cell[BoxData["623587"], \
"Output",ExpressionUUID->"da169309-fb6a-440c-b504-38301a9791ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"2", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"2e67de92-b219-4856-82f3-521ccb62bfec"],

Cell[BoxData["257840"], \
"Output",ExpressionUUID->"9b457fb9-b4cb-4fc6-832c-923c2b0e2128"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", 
  RowBox[{"Union", "@", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RInvRules", "[", 
           RowBox[{"2", ",", "#"}], "]"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"InvarCases", "[", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"RInv", "[", "__", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"5296dade-b9a7-4f1c-9c38-9bcb17f55ca4"],

Cell[BoxData["212119"], \
"Output",ExpressionUUID->"a9d4cfbb-1c43-4800-a54a-8797ccf2ba17"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"3", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"e49b396b-51e3-4505-943c-2d2a9413afe1"],

Cell[BoxData["84756"], \
"Output",ExpressionUUID->"e03da37e-3573-49ec-863d-b7a68ab373b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", 
  RowBox[{"Union", "@", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RInvRules", "[", 
           RowBox[{"3", ",", "#"}], "]"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"InvarCases", "[", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"RInv", "[", "__", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"5f153358-9c34-4b60-a545-8e50c3253af3"],

Cell[BoxData["84409"], \
"Output",ExpressionUUID->"bb518e71-fc96-4246-a1b7-f7b534de7c41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"4", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"f3ee84a7-4856-4a7c-8341-16fbc8821cd2"],

Cell[BoxData["6368"], \
"Output",ExpressionUUID->"d35259b0-dfce-47a8-940e-653eb524b5b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"5", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"7b63473c-c2f7-475b-8bf2-73a0a250356b"],

Cell[BoxData["2202"], \
"Output",ExpressionUUID->"290b79e0-dce2-43ae-bd32-fef1fe8ff979"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", 
  RowBox[{"Union", "@", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RInvRules", "[", 
           RowBox[{"5", ",", "#"}], "]"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"InvarCases", "[", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"RInv", "[", "__", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"308d85a4-b83c-4675-aedd-39d40f14d193"],

Cell[BoxData["2129"], \
"Output",ExpressionUUID->"3c7bcd7e-2294-4c2b-bcf4-4614cb282e32"]
}, Open  ]],

Cell["Checks (now we include the algebraic degree 7 case):", \
"Text",ExpressionUUID->"78b57454-7364-4bf1-a472-17f20d4291f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"knowns", "=", 
   RowBox[{"{", "}"}]}], 
  ";"}]], "Input",ExpressionUUID->"5c790e43-fc85-4c8c-a535-07fea4bba6b1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"2", ",", 
   RowBox[{"InvarCases", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"98c3f953-85e2-4ae1-8b45-ac3d8287153e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"30c6395d-df72-43c3-86c3-ba576e6ace5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"379ab417-cc41-46d0-b65d-7eb97e288dad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"fca90d5d-6831-44b4-8dc7-137e7ecc0b47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"763d39ad-e67f-40b7-bde6-3e5b85b64a93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"1551208c-3785-4590-89e3-c73546fcd0e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ea2c6797-135d-431a-9ea2-99143779bb97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"1579785d-d252-463b-919d-83b2d2888f78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"dcdbcebe-5bf9-460b-a33c-ee47e326b870"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a7e7ab60-639e-4c13-b9fb-3d7dbb9288ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ed4c485c-2b03-4059-87a3-d1d9707eb437"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1b83e205-2a37-4b31-9d23-b87d261436e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"17a9b06a-c7d4-4e15-a2db-599203431eed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"72e5cb81-539c-4f07-a77e-6501e0446cb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"3bd6ca8b-7d01-40a4-a953-be3ad5b04e58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"c2534bc3-76d1-49ea-89da-b39244a6f315"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5a544b6b-1134-42aa-bee3-949f98e32a1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"9ef40c1d-a6cf-43ad-9bb3-a668e3e5d5c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"f748fff2-de7e-45fe-aef0-841db48aed74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e2a6db25-8f53-4e4d-a268-e01b63870514"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6a325d9f-541b-4b26-9e35-a63729411cfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5d6017ad-3d8f-4f05-b3b3-d14a6f02a737"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"0a503657-7624-4376-835e-9c19892ff509"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"0051b537-1bb0-4606-b72e-51cdbc09d90e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"afff88ab-28a5-4d40-8203-9e2c08732041"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"1d0ad39f-e370-410d-bd72-103820220ede"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"00fadadf-5b4c-42b2-ad3a-390fb6d43724"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"904402de-beba-4d74-ab54-4750813d2daa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"dbce8342-7e78-43de-82bc-9e6b3d5e398d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"d4868e15-e58e-49e8-b338-62d9620e6f96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"ad009349-3d65-4bd6-ac58-1ecb6f468691"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ed4b7007-8749-4aa9-9cc9-947781f6bbdd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"472ddd47-be9f-4c0d-9c92-1fdda57966b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"fea71ea5-3d5d-4ea4-99dd-63464f539c2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"aa2fe858-3361-4c4c-a9ec-e94616ba475e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"1a5a6903-f074-4eb0-8bcd-87609c041ec2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"5a01ffda-bf7e-4b46-a83d-8fa4dd13a526"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"840e1af3-552f-458f-b1a8-cea9951fe25b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"3bfd9231-af40-4590-b7e9-ecac833d9677"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"4fbf885c-14e7-4155-9d08-77938de79a67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"c7d5c593-4f24-4cba-9bab-13e5710ac752"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b1eb0cb7-0172-4931-bfef-86d7e6e96701"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Checked case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"55c316da-751c-4e05-b479-d5949f581610"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Checked case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"5bdb5419-9019-48a0-aeff-c31bc1aded84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"a3204cf6-c462-4863-b3b8-c76b48850a62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"e551bc6f-37af-4b38-8e5e-a7da540c657f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"68b06e1b-37ed-49b3-a22d-9c3285672984"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Checked case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"d3a0faa0-0e4c-4267-935c-26a12a7de5e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"d1383b1d-092a-46ab-ba00-62b15d78512f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"f15b5672-9eef-49d3-852c-d3d97d9e1520"],

Cell[BoxData["380640"], \
"Output",ExpressionUUID->"829c9c0c-70e5-4c4c-ac37-b2e26528555a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"3", ",", 
   RowBox[{"InvarCases", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"55567406-8201-47c5-aaa8-873b815aef7f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"f64c1ee9-b624-485a-b842-a411cb056e45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"da1ca249-cddd-42eb-aad3-1ea7025f3148"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"ef90bfc7-d6e0-4142-b343-f271b3e2e4d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"f6688aab-19e4-498d-b9ea-5cd24cb830d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f18d4caf-b343-44bf-829c-d588046d1210"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"2329d0dd-18a1-4019-9d23-3804e8ab98d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"f4fed2ae-39b5-402a-877c-a1587247d5f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"ff4b2f3f-fb53-44a3-8b0b-0f8e312afd76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"07241f09-fa9b-4282-9f90-f74880ca4b9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"23bb4e40-1268-45ba-af4e-de38367cc3a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1a6752ea-5d73-4b5d-a011-d173474ff32c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"198b93a5-bce9-4922-9405-351d37dc6a3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"156fa395-e571-418c-9816-c88b3c9ac895"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"c06b4de3-f0e9-40ce-8222-f482ecf0f80b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"953148ea-52df-420e-a032-7473c0b7cb07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"2c6e4bbe-d725-4a74-a5cb-88bbd98d7867"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"e6fe0864-c20d-44ca-a84c-5d67cfd02269"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"43454758-ba4e-40b9-992a-b8d3b5afba2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"66a5333a-d0ec-4a2c-a5d4-15255bb9a19d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"553c9205-352a-4326-8615-5dfeb705d347"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"4e002462-af26-4710-8845-a6e4c2c8371d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"c77e80ce-d3ac-4388-8c82-6e5b6c7e3e60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"10e8e7c7-e8a7-44fa-b4e5-8037a780232b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"be007350-4be3-49ca-b1d4-4a446a8c0618"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"911a98b4-0888-4c70-bdd2-13c5fbbb3f18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"7a0cff79-8df2-4f98-ac55-aff5c7346cb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"74a16106-a1b4-464e-94b4-17d265dc28bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"32c33132-8a88-414e-a1cd-e8bff355944d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"2c17094d-2bd6-4371-8976-3d1a17c688e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1a3d5943-f12b-427a-b3ab-f2c0698d5379"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"5e8ee6d1-8afd-40ec-ab84-fa1edae1a066"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"84f77c5b-fa7f-46c3-a752-5492b8e3516b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ffe86659-22a0-4b59-90d3-5bc52c310813"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"56b47a77-f236-47b6-9994-d09c1d69162f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"7c79ef3b-5690-471d-97c5-fc2eb1049cb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"f43fe7b2-99b8-4703-9b7d-ae11ebe5e99f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"3ed51f7d-c8ba-4a0d-a1c7-fa4b393e488d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1ae88842-6b0d-4c1a-a288-cb7355988929"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"7e592b12-e27c-4654-885f-6fb07ba03505"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"99ec4e80-ade1-476d-8967-9a054351d1c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d1705bb8-7913-47a3-966d-9f7d9cf55507"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Checked case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"cfcdbd51-a16c-4311-9d35-b4dfea064a03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Checked case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"464422dd-8606-40da-8976-462f2b12efbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"a69e7cb0-b795-4faa-8527-5ec426c36356"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"f945492c-a7d4-4cc7-a904-25012b5ccda5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"a85a5e2d-182e-42d5-b2a7-ff19e1583f62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Checked case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"9c7ab553-92fa-4c45-b028-dd3ae375944f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"234165e9-0055-4302-a49d-ca55d7c21b0c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"b010ee3e-c22f-4e8d-9a71-192c69106e69"],

Cell[BoxData["553724"], \
"Output",ExpressionUUID->"1b07280f-35ed-4f26-aedf-6d4b5c31e073"]
}, Open  ]],

Cell["The sixth diagonal is not expanded:", \
"Text",ExpressionUUID->"10d2c177-3970-4072-a1b3-72d894a750d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"4", ",", 
   RowBox[{"InvarCases", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"6b625295-5bd3-407a-92ac-3c0d7226be0c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"1d9e5fe8-2c80-4f92-9cae-75b13098b1bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"8537ce6f-51a0-4132-a238-4cdce50542db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"b78db2f3-f792-48d8-b564-f85e8e1c48c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"8a828c2c-ed1e-4205-b24d-f92ee111a9b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e8c3baac-b0e3-401d-b643-e4e6fc66a643"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"4abe7a6e-e771-473f-84eb-2476f00cb645"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"27c639c7-01f1-4d0b-8238-c9afbd77283e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"c6800bde-cf5a-4594-b819-2cd7a040bd39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"15af22b1-8f0b-4226-aac1-1ac65b76367d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"1cdb279d-f674-44fe-8504-fc9a988bbf06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"72001470-05b7-4ee9-a9be-ca30f481deec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"203b037b-f08d-4724-bd36-5c3be031d5d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d9751442-e6a5-4858-8965-04112558d02e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"8c1cf96b-ceb6-4f9b-bcb6-0c4b0e30a5d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"25f235dd-224b-40bc-a810-4eab1b4d8046"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"28eaa878-8117-40cc-b049-766e7f201687"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"2c134446-5fd8-4d5f-b38f-c827a360fb5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"5f918e4c-e104-489c-8983-10c23cad8500"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"40e72941-e781-4126-bffd-ecec57beec23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b8bb41bb-a3bd-4c0c-82dd-db9f0699aa3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"2bf9f533-ce22-4c67-99d6-f9bb6469ebed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"e706aad3-9b4c-40e0-b1fe-50c3244959b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"cb9d8643-de59-4d2a-9b07-cfc480577129"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1547395f-e256-4424-ae6e-bfa64d27836c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"d6596321-6cce-470d-8c3c-9cc10465905f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"d5665bef-18bc-4e4b-9818-f55b4e115bc1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"e3c77ac6-b220-445b-ade7-3c699a5a4a1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d6bc935b-a601-4517-95e0-d3d8b29e8078"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"5a2e7241-ec88-4b35-903a-9e19fbc8b8fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"2285f8d0-a9e6-445a-bdc3-80804f497b84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ea080f8a-cf7e-4374-8869-dc2dabe82a5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"aecd31e2-913c-4689-8ece-fdd48b221358"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5b5ab17e-8a34-485b-92bc-586d3429166c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"4d0c2c99-18bf-494d-920d-faafa4c7a4f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "39502", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["There are ", 39502, " rules to use in case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"6149bb52-4716-449a-966c-a7bb518591e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "33821", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["There are ", 33821, " rules to use in case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"c59a4da9-9c57-4694-9b45-6bdeefc0cf1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "21143", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["There are ", 21143, " rules to use in case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"9644a654-89e2-4132-b4b1-be4f2be4816b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "7043", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["There are ", 7043, " rules to use in case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"35638220-c96d-471e-939b-eec879a16b4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "10293", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["There are ", 10293, " rules to use in case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"a454622b-278c-4f11-90af-f8e74212957c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "9974", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["There are ", 9974, " rules to use in case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"50540585-e2f2-4f96-abae-1ef57cca9b2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "1373", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["There are ", 1373, " rules to use in case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6a85b4fd-4403-4172-ac4c-88a1b82f5dc5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "82507", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["There are ", 82507, " rules to use in case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"786ce8c0-db27-4880-a5ce-9c20b5e0a644"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "38993", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["There are ", 38993, " rules to use in case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"2c2d60bd-06af-4b05-8a3d-ca677c5a0143"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "29313", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["There are ", 29313, " rules to use in case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"6b7b56f9-beaf-4c08-802f-ed0e585c7775"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "22786", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["There are ", 22786, " rules to use in case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"5fc528f3-2bb5-4e85-af87-cd5106bb2a4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "11727", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["There are ", 11727, " rules to use in case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"10f1b3f1-d98c-4cc4-bfc4-d48370e95ab2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"There are \"\>", "\[InvisibleSpace]", "70808", 
   "\[InvisibleSpace]", "\<\" rules to use in case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["There are ", 70808, " rules to use in case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"d283c1e0-798e-4167-b407-c04fe7f1e67b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"e6f6be1d-0029-4c75-a00f-ec590ad8f5f2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"fa7d12bb-8f1c-48d6-9367-75f1a247c3dc"],

Cell[BoxData["632112"], \
"Output",ExpressionUUID->"da91fd83-1b57-4ea0-b67d-3de7591ba941"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"5", ",", 
   RowBox[{"InvarCases", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"0fb67525-d549-478b-8696-bc01397a316c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"bd9146b9-7c30-446e-86c1-5b3acc40e187"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"a5dfe7a5-19d3-4cb7-a91e-d83c0fdf47d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"a1a19360-c494-4a72-a8d6-3b9b4a12e546"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"201fee85-69af-4ba0-95f4-cd2d70907b2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"62e719f8-7df4-4e98-b6c3-88430d43ff55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"2739f85d-7011-43e2-a046-db920678fcbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"aa30b122-11c7-4dc7-8b44-3de1cad79dcd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"74ef7ae5-1405-4001-b431-ff7a50b8c738"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"cdd6425c-fc81-4fac-9b92-749061e40235"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"8a36b291-e72b-434b-b130-57e92db47413"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"f9b46af6-9973-4162-a10e-21ec821fb08f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"5e419c1d-3844-41cc-b674-bb83afefb096"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"346aeaee-f470-4fcf-9175-2e7d3a40e580"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"9061523f-4096-4816-83f1-a99849c41037"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"de79b21d-d7f1-4c10-9841-579e59d77d29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"c0bea9ff-91b8-4e15-91da-11d3d496196d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"2eff96b7-0bd7-4702-a31d-f4b6b3d95d60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"fddf109c-5f98-4b70-aed5-b0f50d284619"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"0dcb3c6c-c03f-4c0d-8d64-f6f1b2b075d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"85164ec1-d7f6-4e6e-8eb1-c9652465c5ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a856e820-9c39-44a6-b453-9543c4caf5b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"ed73fa4a-48a2-4b29-a485-e29181152e5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"d580f3e6-07f5-43b7-a702-7ecafcf4f258"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"f6442561-d67d-43e2-a955-df81791eef20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"673ffed5-3b11-4cec-a5a9-75a6ed70dd8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"be4547e8-8909-490e-894c-95449215c5ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"1b5b182e-2582-4fc7-822a-4e3330f3e6a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a5f81188-9413-4a0f-b13b-f50ca13bd986"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"e6b033fd-2ce6-44dc-9f94-19f61f17d9ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"93bd5794-0c9e-4a52-aecb-4dc18167af19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b407ed22-17f4-4811-8637-cd10baf0091e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b680fd72-dd4b-431a-8bcc-4567d86133c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"cb5d487b-80e7-4440-9cf7-b99f6355b8a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"13f4567a-4e47-47fe-bc44-9b0e913536b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"73189570-b2be-4b16-a32f-649128228f00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"98ef7e2a-e321-4a89-8574-3ff98641502b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"03a9ccbc-903c-4696-befc-3fdb855202b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"8157e8c3-87d2-4399-9496-fc1c7fde148c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"34ac1f24-329f-4711-9968-1792656e4fc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"4ba69b7e-03ef-4dc8-b6f1-65f20ba472f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9c4965de-d70d-4855-81c4-64e82c21faa2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Checked case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"81ddc9b4-a957-4b3d-9f70-f4bbe1660c1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Checked case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"27e11a73-4ffb-470b-a5a1-b4382e3e8d96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"c3a9cd08-77fe-45aa-8b2f-52559fec5319"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"5a0e4e93-921c-4ebc-8a39-ef6f8804c7c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"e7fd7d59-50fb-44b1-9836-dec832c3585e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Checked case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"e1be0454-1d7b-464a-9b1a-6d08b1d5a0e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"60111d2d-4909-4bb1-8e38-9a0cdf36f268"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"ab775407-b014-456c-b154-0a404f702a04"],

Cell[BoxData["637910"], \
"Output",ExpressionUUID->"b9ca6b82-51c6-498b-bed8-00316d8017f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MemoryInUse", "[", "]"}], "/", "1024."}], "/", 
  "1000"}]], "Input",ExpressionUUID->"8d548111-438f-4215-bc7c-9f24902b2295"],

Cell[BoxData["4564.822453125`"], \
"Output",ExpressionUUID->"6567ea37-12eb-4537-bc0a-4bf5f0f6f5ea"]
}, Open  ]],

Cell["Numbers for the abstract:", \
"Text",ExpressionUUID->"973c6b10-30d7-4c0e-9c28-e9498f538e45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"1", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{"InvarCases", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"753d2872-08b8-4502-a067-05b15cd1d799"],

Cell[BoxData["640119"], \
"Output",ExpressionUUID->"786f9118-e3c1-461c-a7cf-55fd05b2d32d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"DualRInvs", "[", 
      RowBox[{"1", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"ac26e9b3-33e4-4324-90a2-2018aff6fe47"],

Cell[BoxData["7698"], \
"Output",ExpressionUUID->"dfc55bac-fbeb-451d-b7b8-da19492507fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r2", "=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"RInvRules", "[", 
       RowBox[{"2", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{"InvarCases", "[", "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"87691289-40e9-4a93-91f7-ed259ee51fea"],

Cell[BoxData["380640"], \
"Output",ExpressionUUID->"dfcde623-f744-408f-b631-8570a06a7fb4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dr2", "=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"DualRInvRules", "[", 
       RowBox[{"2", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{
     RowBox[{"InvarCases", "[", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"c3afa60c-4a5b-4982-a164-d605f27d79aa"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"b4578ec7-370d-429a-bd01-c7595cc19172"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"ebdfc41b-b60a-4dbf-b972-24389bfc7e56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"354eaf03-f7d6-4fbb-b52a-e6c862f5be70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"4c5440bf-2ef0-4a8c-addd-0d5a9c7997f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f4ea28d9-c6d0-4ee0-abae-d0b5c03b0b6c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"75c04df3-ac52-45d7-b768-45323b0223d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"9b9dab90-584b-4ae7-ba71-72d9c7ca601b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"abac3f72-8d68-4f8e-9d40-4bc3a06b6474"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"53b5cd2f-9199-4e55-819b-6847437e6115"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"c496f606-213d-4856-b24a-a2a5ac8e113e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9d40ecc7-36a5-4153-a434-1da475e6d829"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"0852e57f-4348-44db-8fa6-362fb32155f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"2358a878-00fa-4e25-983e-cd2174145322"]
}, Open  ]],

Cell[BoxData["5876"], \
"Output",ExpressionUUID->"da67b7ad-8842-48e4-be7c-0a7a6a07b371"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r3", "=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"RInvRules", "[", 
       RowBox[{"3", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{"InvarCases", "[", "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"69d5dd3a-b730-43b9-ad79-6ed2db9eb675"],

Cell[BoxData["173084"], \
"Output",ExpressionUUID->"86c8085a-5fda-4f44-8a87-fd43996abaf4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dr3", "=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"DualRInvRules", "[", 
       RowBox[{"3", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{
     RowBox[{"InvarCases", "[", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"4a7e0861-5259-43e0-91a5-85ecad19e58e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"66c74a0d-0115-4817-9e58-f773c4a861a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"4adec0dd-7633-46fc-b7cb-7b9bc110824a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"51ede475-d8f6-44a2-8331-a15a97e15f03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"eae32900-8618-4fe9-aa9b-ec62f3bf8c29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"1eebaab6-604d-4e0f-896a-f7cf96f6f40c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"d21a2090-7f3a-4f83-9879-8ba234a0d623"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"c96f195f-ec12-4e34-a7a0-adc5f78fe4db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"5e57a8b2-a323-4598-a7e3-7f91d2e7d1b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b60384ed-ab55-4efd-86e9-b50d5acfc414"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"1dd732fc-3038-46d0-9bc6-a8b66eeb78d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"a9f1b891-dd00-4f9b-9fd8-ab2aa0b1a192"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e13d83f6-bf74-4e44-b37f-680f031d1b66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"82ce363a-faf9-4dea-8bf4-4f8710948d92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"aaddbbd5-fece-4cb2-bd82-1400d71830a1"]
}, Open  ]],

Cell[BoxData["962"], \
"Output",ExpressionUUID->"370e7db2-bd3a-408f-a18a-b89cdb76dfb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r4", "=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"RInvRules", "[", 
       RowBox[{"4", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{"InvarCases", "[", "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"7c7f35b8-65f4-44f8-ab67-9f1484a73d05"],

Cell[BoxData["78388"], \
"Output",ExpressionUUID->"e97978d9-b7d1-4c83-854b-f13ad54db035"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dr4", "=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"DualRInvRules", "[", 
       RowBox[{"4", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{
     RowBox[{"InvarCases", "[", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"287ff562-fede-434e-be37-3f8d7cdfd7e8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"1f530b4f-adaf-4742-8596-2c83947c6500"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"b27b3dbe-3824-4127-bd13-d947115e14e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"ba3363d9-7812-4eb6-9884-e73e70b02d50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"239da2e0-1b73-4107-833b-6eac689f4fd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"13002a94-60c0-4be5-80a3-faa9cd81ddb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"9cb962de-1e89-4bc7-a7b3-e47a3c760234"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"eba3ffc2-7d03-4f32-8770-b8a550f9edca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"fed54ba3-c4fd-41dd-94fd-280b8a626846"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"0dc7cc81-39f2-4217-987b-8c0e1eafe7fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"48a8c4c0-5f29-41a0-b202-f5fa9be79c96"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"af19d103-f93e-496b-8acb-f80249f00d27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ef12c98b-3578-45ca-b723-1fa478278f0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"53e09588-076d-4c3b-90af-464c422cc662"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"e29d5967-d093-4beb-b386-006373375471"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"42a5e8db-aaff-472f-b9c0-e2cb61398992"]
}, Open  ]],

Cell[BoxData["391"], \
"Output",ExpressionUUID->"94e24313-0060-4c05-99cf-ac740853363b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r5", "=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"RInvRules", "[", 
       RowBox[{"5", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{"InvarCases", "[", "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f9e7887b-d2e0-4142-808c-cb2cdd5138f6"],

Cell[BoxData["5798"], \
"Output",ExpressionUUID->"f5697f2f-123b-4bff-828b-8cf05656439e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dr5", "=", 
  RowBox[{"Total", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"DualRInvRules", "[", 
       RowBox[{"5", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
    RowBox[{
     RowBox[{"InvarCases", "[", "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"ebb29add-04d0-4cbd-9ebd-d9b9017676e0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"18044ffc-1107-456d-a15a-4fd0feb52129"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"adbc782e-2363-4ca7-8885-bb011a421167"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"e892c81a-c88a-461d-b6b1-18b69fa7b397"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"477c800a-ef9c-48b7-90fa-dcd8ebebae09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"bc2986ee-edd7-447e-bbee-d1070dcb10cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"d16987c3-70cc-4bd1-9f17-440f35ee814c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"edcd2775-c28a-42b5-aebf-371429f38b2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"8ec13dc9-27d4-4375-860c-867e9f0519df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5deeb97b-a405-4370-9566-f1612b78cb36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"819f8d43-5920-4a75-814e-3ad2fae38a84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1fa983a6-79ae-440e-9cc6-86a00b3f4d59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"5a0a4e89-fb6d-41a7-9edd-add68e68c8f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"c098b9e9-a294-4d7c-b59d-2d49e7c8f405"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"a03311a7-6f30-43f4-9b0d-d1960304c9af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"be890703-49a2-4456-8f3b-5f2ef1c46af2"]
}, Open  ]],

Cell[BoxData["435"], \
"Output",ExpressionUUID->"0d56384d-d818-44d4-af7e-fbf680de0f31"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"allnonduals", ",", "allduals", ",", 
   RowBox[{"allnonduals", "+", "allduals"}], ",", 
   RowBox[{"r2", "+", "r3", "+", "r4", "+", "r5", "+", "51"}], ",", 
   RowBox[{"dr2", "+", "dr3", "+", "dr4", "+", "dr5"}], ",", 
   RowBox[{
   "r2", "+", "r3", "+", "r4", "+", "r5", "+", "51", "+", "dr2", "+", "dr3", "+",
     "dr4", "+", "dr5"}]}], 
  "}"}]], "Input",ExpressionUUID->"a8987b46-9716-402e-8da1-0d95e7c69206"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "640119", ",", "7698", ",", "647817", ",", "637961", ",", "7664", ",", 
   "645625"}], 
  "}"}]], "Output",ExpressionUUID->"dc46065a-060e-45fd-b0bc-c1dc9323d32a"]
}, Open  ]],

Cell["Number of independent invariants:", \
"Text",ExpressionUUID->"cbf9dc97-17ad-49a2-ab2b-11118a356965"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"allnonduals", "-", 
  RowBox[{"(", 
   RowBox[{"r2", "+", "r3", "+", "r4", "+", "r5"}], 
   ")"}]}]], "Input",ExpressionUUID->"646c5484-29ea-4bb1-a18e-543654a3a5c7"],

Cell[BoxData["2209"], \
"Output",ExpressionUUID->"638daac5-3dbc-4f12-af8a-b5a0a5b3231b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", 
  "51"}]], "Input",ExpressionUUID->"fb8743b1-0efd-45cc-bb71-4f32a2f3519e"],

Cell[BoxData["2158"], \
"Output",ExpressionUUID->"6830351b-bef7-4288-9f5c-08c03d099d88"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"allduals", "-", 
  RowBox[{"(", 
   RowBox[{"dr2", "+", "dr3", "+", "dr4", "+", "dr5"}], 
   ")"}]}]], "Input",ExpressionUUID->"79f94dbc-30d0-46e5-8c91-72bf1d1c2c63"],

Cell[BoxData["34"], \
"Output",ExpressionUUID->"555cddbf-a95a-4d74-a5ee-1e7f7fce3de2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal 6 expanded", \
"Subsubsection",ExpressionUUID->"3c02df67-8747-4a28-bffc-7cfaff1d2182"],

Cell["Now we read the sixth diagonal (Commute expanded):", \
"Text",ExpressionUUID->"37919224-f1ab-4fc4-a80e-2d9351ff9255"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$ExpandedCommuteOrder12Q", "=", "True"}], 
  ";"}]], "Input",ExpressionUUID->"b598d68c-6ad7-4d66-8b76-0dadc21bab57"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"RInvs", "[", 
     RowBox[{"step", ",", 
      RowBox[{
       RowBox[{"InvarCases", "[", "]"}], "[", 
       RowBox[{"[", "case", "]"}], "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"step", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"case", ",", "35", ",", "47"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"9e28456b-4e7b-4553-92ae-257ec3df3eee"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"2e830779-072a-431c-a8b1-2a213afbde2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9c441712-f7b4-49f9-94ae-31c242f03e8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"bff806d2-04f7-4dc5-b44d-f4b5112a1c9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"7febe81d-66a7-4d73-9ca2-1eac57d43478"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"11852bc5-d080-4b41-9a68-844a1553ae7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"2f91038a-868a-4465-9a41-05fc1dadcc72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"df7449ac-ec7c-4c9b-b6c9-32dcef7d9240"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"22b9ca49-f270-43be-bb54-57772b209e62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"966c8949-56f4-4d93-b00c-46bbdb7ccced"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"5e337660-9627-49f6-827a-73d39598f3d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"7e945707-b044-4798-aab8-14e32682322a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"c07107c2-17ed-414c-b898-eaac3b118625"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"d4761676-03c7-4da2-9bae-9f2ae662ef99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"023965c0-92c8-4b15-823b-2209c4633d70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a9edde6d-4f3d-4dfc-aabb-e28871450e4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"829fc09b-b4a0-40af-9d49-17c094358920"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"ea73ae57-0bf8-4838-a766-5fc2e4a5ed38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"9b968aff-ed23-4e23-a05c-a9819f30859d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"3fcff849-df6d-4eeb-bc89-66e0180d0c68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"68621133-bf95-40c9-9667-85c697730f83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"f84720ff-b2d0-48aa-99ec-d441310cdc6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"e5766b5d-b9dd-4a03-ba11-e9bc03c6ef94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"0a48eaa2-4b38-481b-91f7-ced0c4a4c5ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6e952983-b2e9-4449-a68f-ed5c7d38d4ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"5148681c-5daa-4f01-8b76-4bae104e0e8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"9a3bdbeb-8496-40af-9140-2ea4719e32fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"718776cb-0b0a-47e4-a0cb-d5ada3068c86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"87ceafce-5192-4c96-985f-962d185cb675"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"94595a94-e0c5-404e-9999-c41d54859cb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"e28d9218-1bc2-4539-9acc-fed5a31bf433"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"a294a586-c96c-4af6-818e-f24862625a02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"3fbfadb0-d7cd-4f45-aef6-452cce5ed1be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"b0fa78bc-5b0d-4586-90cd-bdd6474f4cc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"ad7e7ec0-3677-47cd-81bc-541d33e3053b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"c4103559-da95-4ac4-aff6-1048571674dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b03d3c5b-d077-4976-af38-e4e90c1fba61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ab8ed939-f689-44a8-85ba-19eb28816fc2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"97cadfda-8405-487b-8ae1-d329f800f286"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"0f3bc555-356e-42a5-8620-339aa6de4cb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"412ecd07-b806-46be-a221-ffefc49798ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"85cc5264-8481-46d5-9312-b96dd40201fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d428bd85-4d7d-47fe-86a8-5a138899b5fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"9b37f2b4-e3c9-4723-a4d3-afc0e23997dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"5210910c-a011-44a6-8172-39bbeaef114a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"23094e6b-74e3-4af6-804a-12f161d8347e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f0013766-023b-4026-a874-6ef89e84d3a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"a32e7e0b-6cab-477e-93ad-6f4a5534cfff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"986a9f97-b8ca-498a-8ba7-22f53736d46d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e19f376c-1745-437b-8d5f-7dd2cb2f1986"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d4e21cb0-a68b-4fd6-b21c-1ba80ff3fc6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e5532aee-8086-45d4-9e02-a84b298adca5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"830e8d65-85da-4309-95f9-9f7f3b70f63f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"a8a7071d-7fbe-4f86-b843-1c5db4bba0e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"5fb81fed-ad0d-4c9b-9e55-1350ba5b936b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"845c5eef-55f5-4e2a-9e77-62195946ca3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"75bddffc-8600-4a7a-975d-e4a8d86c343c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"0b167956-d60a-4bc5-b0de-eedeb7474f32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"09ed5ba0-5a25-4164-bcba-af8235a474b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9406a8e3-9140-4756-9cc1-e735dc1c6504"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"6b7a34cd-4246-4487-b5b7-a4217afeeb66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"783dc641-cd35-44f6-8773-e5292a52fc49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"47515a9a-f5ec-4ee0-995e-6361409d786e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"ddb4d77c-c172-4067-837f-5d8cc7c7682b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"8e6d452d-934b-4ddf-b43c-180d0f40e1d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"5d7b0143-b4c0-4ff8-8c82-97178c9a261d"]
}, Open  ]],

Cell[BoxData["$Aborted"], \
"Output",ExpressionUUID->"726798c5-1f0d-4794-abac-8d3e1a09d6d6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", 
  "]"}]], "Input",ExpressionUUID->"d0c52bf6-d5a0-40d7-88b0-a939d5e81624"],

Cell[BoxData["6639425120"], \
"Output",ExpressionUUID->"929666c9-7a58-4a5d-8c70-0664da17cab5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InvarCases", "[", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"Range", "[", 
         RowBox[{"35", ",", "47"}], "]"}], "]"}], "]"}], "}"}], ",", "%"}], 
    "]"}], "]"}], "//", 
  "MatrixForm"}]], \
"Input",ExpressionUUID->"7939b19e-4fe9-4ad8-81ab-ee3de8314660"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}],
       "1613", "270", "270", "270", "8"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], "12722", 
      "2495", "1371", "549", "66"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], "27022", 
      "5439", "1725", "1725", "245"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], "19617", "5622", 
      "3094", "99", "37"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], "60984", "17662", 
      "5440", "577", "242"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], "30974", "9030", 
      "2861", "445", "169"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], "62465", "18272", 
      "3226", "1235", "505"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], "5606", "1733", 
      "210", "210", "86"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "6"}], "}"}], "25590", "10600", "5840", 
      "17", "12"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "5"}], "}"}], "53160", "22330", "6938", 
      "55", "44"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "4"}], "}"}], "52764", "22063", "6861", 
      "93", "72"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "4"}], "}"}], "27396", "11695", "2121", 
      "83", "66"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "3"}], "}"}], "27024", "11402", "3597", 
      "68", "53"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "54654", "23255", "4204", 
      "212", "171"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "2"}], "}"}], "9104", "3879", "715", "66", 
      "49"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}], "25515", "14910", "8225", "3", "3"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "7"}], "}"}], "26670", "15855", "5000", "5", "5"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "6"}], "}"}], "26460", "15675", "4950", "9", "9"},
     {
      RowBox[{"{", 
       RowBox[{"3", ",", "5"}], "}"}], "26670", "15855", "5000", "11", "11"},
     {
      RowBox[{"{", 
       RowBox[{"4", ",", "4"}], "}"}], "13607", "8111", "2615", "12", "12"},
     {
      RowBox[{"{", "10", "}"}], "15120", "11970", "6615", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
       "}"}], "16532", "1639", "1639", "1639", "7"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"ae5aadf0-39b1-4724-880a-251c8d84c55a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MemoryInUse", "[", "]"}], "/", "1024."}], "/", 
  "1000"}]], "Input",ExpressionUUID->"896c9975-7cbc-4376-a20d-1dc222d37dfe"],

Cell[BoxData["2413.5582890625`"], \
"Output",ExpressionUUID->"8d1953b4-5c6a-4f96-ba51-53a75b6b816b"]
}, Open  ]],

Cell["\<\
Analysis of numbers for the first six diagonals, only steps 2 and 3:
\tThere are originally 623587 invariants at step 1.
\tWe have 365747 rules at step 2 in terms of 212119 of the 257840 free \
invariants at step 2.
\tWe have 169204 rules at step 3 in terms of 84409 of the 84756 free \
invariants at step 3.
\tWe have ? rules at step 4 in terms of ? of the 6368 free invariants at step \
4.
\tWe have ? rules at step 5 in terms of 2129 of the 2202 free invariants at \
step 5.\
\>", "Text",ExpressionUUID->"03e329de-0411-42a3-ae98-04c175288dbb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"1", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"d64245dc-f863-4403-988b-0610687abd7a"],

Cell[BoxData["623587"], \
"Output",ExpressionUUID->"a0fbb195-48e2-420c-a4e4-2efb69bceba2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"2", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"57b5cb36-27a7-4377-bceb-0bcc7b89633e"],

Cell[BoxData["257840"], \
"Output",ExpressionUUID->"37231a08-9d07-4899-a94e-3c093a6b3ba4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", 
  RowBox[{"Union", "@", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RInvRules", "[", 
           RowBox[{"2", ",", "#"}], "]"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"InvarCases", "[", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"RInv", "[", "__", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"89a205c0-95c8-4b27-9add-49a12a2da04b"],

Cell[BoxData["212119"], \
"Output",ExpressionUUID->"37507a50-aba0-4ff6-843a-2ff549e8c676"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"3", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"a32cd837-e7b8-41b2-8772-ae3d994c4ee3"],

Cell[BoxData["84756"], \
"Output",ExpressionUUID->"ddf84a77-dbcf-4500-86e1-4bd080ca1e99"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", 
  RowBox[{"Union", "@", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RInvRules", "[", 
           RowBox[{"3", ",", "#"}], "]"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"InvarCases", "[", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"RInv", "[", "__", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"8fba3498-8ffa-48a9-9eeb-510863df4e86"],

Cell[BoxData["84409"], \
"Output",ExpressionUUID->"9c1751b2-d2b6-46ac-be6c-204db6d29527"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"4", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"10e1189d-8a9a-4e7d-a6ee-5bb18f614015"],

Cell[BoxData["6368"], \
"Output",ExpressionUUID->"bc27abb6-d4f7-4b58-8669-72a9f129c562"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"5", ",", "#"}], "]"}], "]"}], "&"}], "/@", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"362fe757-3507-4485-922b-ec0dee60e946"],

Cell[BoxData["2202"], \
"Output",ExpressionUUID->"adec3911-d4c0-46b2-b285-7cdd8dfea19b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", 
  RowBox[{"Union", "@", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RInvRules", "[", 
           RowBox[{"5", ",", "#"}], "]"}], "&"}], "/@", 
         RowBox[{
          RowBox[{"InvarCases", "[", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"Range", "[", "47", "]"}], "]"}], "]"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"RInv", "[", "__", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"76f5033d-8624-4c9e-8f7a-1a6b577ff32e"],

Cell[BoxData["2129"], \
"Output",ExpressionUUID->"af2df254-adb4-458a-b216-2b31ea8bb189"]
}, Open  ]],

Cell["Checks (now we include the algebraic degree 7 case):", \
"Text",ExpressionUUID->"b5ac1779-1368-4c15-ba41-53a8e15bf2ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"knowns", "=", 
   RowBox[{"{", "}"}]}], 
  ";"}]], "Input",ExpressionUUID->"dd0cb91e-c1af-4a5f-9e03-0e0aecc34a78"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"2", ",", 
   RowBox[{"InvarCases", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"a89e5899-c9f6-43b8-87d2-a367cf72e7fb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"40859f18-eb5a-411c-a0ac-663051ce5724"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"38e514e5-df24-4494-b17f-14d4cc524906"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"d58c9ca6-868f-41bf-b02a-5fbd3c94f3df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"6fae143a-0761-4991-be0b-24a012268fa6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"61d85914-2966-4695-af75-20d7ad9ab506"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ac7f34b6-0bd9-43a9-9532-70973f6038c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"ca6b99f0-dfc6-450b-94cf-7acd6eab6789"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"eb03724e-207d-46a9-a795-d186b053f40a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"80f71f7a-4287-4c03-9126-fe4990d43907"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ea1fe8af-5f31-4466-b2d3-27a18fcd31ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"a56ab818-8a76-4a79-8a29-b7ade27e6f1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"9239f39a-7773-41f8-9ea4-fa8b448ea317"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ceb99042-61c3-4358-b1c7-d723da688f94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"b1703ba7-d97d-4d68-865d-798b802d1989"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"587b7596-2dbe-4db8-b028-78745a24acaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"7147b624-58be-4984-a085-3785dd1b6583"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"3bd5d014-05e9-4a84-9d59-463c2f4674b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"061aad2b-5a4f-40e0-8b72-6cf6fcf28eae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"a0cc61f0-96f2-4c71-b56c-dae7f35f2f6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"cf149441-da7d-4851-af6e-f71da44b0c95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b41883a6-21c1-4e35-a74d-ab4484a86f1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"627f019d-ea4c-454b-9772-2bd14909d2ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"9a76220d-38b7-47b9-b7d4-e692248d3690"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"0d940c9c-b01d-4194-9b5f-688e58d76aaf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"cf62af42-5185-4982-a0ca-661c52cb8807"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"b9c25883-8b20-4f2a-aeaf-92cf0c1df86d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"dd1858f1-ae16-4479-9428-1662a1309890"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5bfc52c0-d289-4660-b3c6-b263b87f9924"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"84e41e66-4c90-48c1-a2df-e9ee4fec5bae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"e310d3d9-fa3b-4d8e-acb0-2a0168b4168f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b9aa4983-79ac-46dc-925f-eca4c440eb00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6bebbb3a-f692-420e-aac5-d9d8d39c7418"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"3fc71cff-f13f-4b38-ba0c-173bacc16073"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"87c07ebd-03de-4fa7-b4d4-f8670fbdb6a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"c1ae643d-58e5-4df5-998f-f3a84ec371ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"1ef2ec97-38ad-490a-9a14-33db40f42ba4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"65117a81-ed89-476f-8e6e-4e70171afc33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"a9c1d458-fe1f-48da-875b-10b4fb90b328"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"6c1e574f-d9ac-482d-b146-edbe32b62530"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"bd1b05fa-0073-4274-8ab0-5a5a29e45781"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"855ee768-45c2-422b-95d6-c9a052f7836e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Checked case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"684c059a-0733-4476-be66-15b0c8651ae3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Checked case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"6bc2830b-4560-4cbb-b4f2-3a67c7545ff4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"1d17e094-f0cd-445e-bc8b-a029aef0ae1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"720d557a-a3c3-4ae7-a161-a35e16a0ada1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"cf6a9db1-3507-4676-9315-8f794eba7f0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Checked case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"a50eca16-1773-4db3-86c8-96cf64285c1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"a26236c3-76cb-4e3e-9ca1-a86883fc9829"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"1220c7a2-9afe-4690-b37f-19c29834846c"],

Cell[BoxData["380640"], \
"Output",ExpressionUUID->"7adc0364-8159-4b83-a48e-260220f4ad34"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"3", ",", 
   RowBox[{"InvarCases", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"38908ff8-747e-4701-bf0f-2b63cad8a4a1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"84bf9641-658b-4ffa-9ce3-2a890a9f5c13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"15472fb2-9c34-41a3-895a-4b8e66079fdb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"4b9e0dcf-a456-434f-8ffd-578c57d4dbc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"e84c24de-5e0c-47e6-aee9-68212041e007"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"c8e6b7a1-6945-4691-85ff-4f2f03117315"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"3f95ccb1-ddb7-4274-9cf0-8c00a7968966"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"025ad780-dca1-462f-81fd-cbe3276e8890"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"379284bd-3de2-4c2c-b31a-d634fc20467b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"fb852ded-473f-4e58-94f0-77ad8e6d6505"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"c99cfdb7-d74d-4b68-9c71-4b9f5207c08e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"f12e3c6d-7bf4-4561-847f-a8df00b61dcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"38642cc9-5d40-49c5-9c6e-0f57890aff3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"8c292469-349a-4010-9b65-876a7e41d966"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"2e1d12f2-f59d-4e56-a5dc-c04ebf01d10d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"d9175a59-e88a-4a42-a51f-313de416fb3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"11d3b19e-1992-40ce-b48b-847a730c523f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"21994f12-665b-4fb2-abc8-7c8e094c552d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"49e9ec79-3039-42f2-b31b-dff914ffa861"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"7cc5a991-ba7a-4150-aeb1-ae9b741b8512"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"07cd5bb6-435d-4d09-a861-d872bbfd10eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"fd1e497d-cdbc-488f-a61b-1b855e1aa30a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"e93f9034-cb0f-4ee4-a54e-d269a121aaa7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"958a7977-baaa-4bb5-9018-79cd2ab0f12f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"5e5f144b-7829-4661-ad85-bf8774bccaac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"67403202-193a-4f9d-9ab0-e9ee47f5d18f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"e0f687e3-12de-4e0f-9687-f68fbb4ad049"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"fad213e1-85e1-40a7-ba56-b14733bb27a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"2faef0f0-2623-4dff-a3a5-a457da3904c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"a4280930-dd80-4330-9878-71affe03dcee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"0a321ce8-b4b3-45df-890d-565608b9040c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e3f35f19-60b1-44db-9bd6-b4402f0e0d9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"272803f8-9a5f-4384-9a14-0791a47db544"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f115e5ef-551e-4a2d-a3e8-97ca241aa93c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"971f041e-cb06-46fc-aaad-1b32aadd7632"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"1284c052-2dc2-447e-ad75-96b41ae02200"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"8f379643-0e65-40c8-97cb-2d7306042ee3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"48ba9b28-562a-4293-8afc-13ed7abedc10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d5a6d193-3f4f-407d-85bf-77cd36066f52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"dfcb7700-df46-4812-8a35-a09dcde33100"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"4ea2f0d3-9425-46a1-a040-6aedda9b2a69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9d435d0c-ce19-4fb2-a36f-e16cdb4bd332"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Checked case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"ecd5e580-03b5-41f3-b900-9a4d1dd2badd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Checked case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"dd1434cb-9ff6-4577-b0af-e32ef395e49b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"10931497-9987-46c3-bf7c-54bcfa6ce340"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"8dd58c42-50a0-46d9-91d3-24c6777bd725"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"7b179381-370a-4980-b48e-163aa4891a1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Checked case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"5a510489-3e7b-424f-8f8f-8250c83e8bf5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"c317f172-33ba-47a1-b250-097818862559"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"2fa6495f-e296-4d1b-ab11-1d2c49d47271"],

Cell[BoxData["553724"], \
"Output",ExpressionUUID->"8242a9b2-5b0f-4778-9b7c-cbed85e034ef"]
}, Open  ]],

Cell["The sixth diagonal is now expanded:", \
"Text",ExpressionUUID->"bf1414c6-8fef-4bce-8274-07eafb8e7cd9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"4", ",", 
   RowBox[{"InvarCases", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"5768bdc4-bcf5-4755-bdcf-df3f5438d289"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"4181c40d-46fb-4fcd-9737-acad4f6c6fef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"dca79a10-fb5f-46d6-9e8d-2f9c26d457ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"1cc2d287-ddc9-4b1e-9540-0e57d4d4c02a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"0a84d318-98bd-43ee-9e9f-78cc6a4946f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f460c2d2-aa94-4b1a-9111-c4dacd16bd39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"aaade32e-9867-46c3-9659-e3ebc2723d72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"7affedd4-9877-48e1-b069-d3adf4765aba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"54e0e5ea-b748-4879-ac18-afc0d40f9c9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9cbaa867-95a3-4ff3-aaf8-7ffe3f8f956b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"d06a5856-9e92-49ef-9ffd-5569a4fe29fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"c7b38bfa-b2af-405b-852b-b2b911f8d629"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ba586ad5-8a9a-4565-9327-1c2b5d3caf87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5744cc7a-6bd7-4888-afcb-2f75db8ad785"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"55eee223-4d3e-4047-bcb5-0cdfed9abf10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"c625bc93-75d0-44bd-ab13-9f03ee12d0fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"53b29179-ab45-447b-8441-d93b07e74a39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"beebdcfc-81ff-4779-a109-d6bfdc3e8299"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"a394f57a-c43f-44cb-863c-bace7b7b86e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"83d7c958-b3cb-416e-8e7a-1c465f70f4aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"18b7ffc0-af77-4ae6-8e61-316dbe13fcff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"eaffae8c-a2aa-4656-86ae-6c067205c99e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"7ec2e3f2-62ee-4028-9280-0508673400e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"411335cd-7be3-4f1a-af8b-aa00d0c63661"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"6c101dda-7251-4e93-a215-fb137088bb86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"70f34795-a4d6-4baf-9ab4-cdd34813c0b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"12ea3d17-fded-4cb9-b4bd-246a183b740a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"b39e82d9-5ff0-408b-a19c-fc04fee5f8a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"c369275b-0391-437d-829d-33ab78be8640"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"38da2994-5f11-441c-85a3-baab1de6069a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"c4e46641-9065-42ec-97cf-077c9b735cbe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"3f20de83-81ec-4354-abf0-6a4787c8c186"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e0cfb5a3-b609-413c-b2d2-22c114023d8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6c6f7b50-9d42-4971-9e58-b3dcde617783"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"b1f4687e-a622-4608-b0a2-f748ed450514"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"c3e5737d-83ad-4c8b-8707-fb8de6868270"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"7ff4ef01-8386-4fba-ac43-f6588a007d50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"822765ad-19a9-4023-9ecb-078b0b8be198"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"7327036a-505d-4ce4-948b-6f1b32d31b47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"14a0b34b-23e9-4b18-955c-0482e521825c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"fc9de456-a5d3-49ac-9c34-603d78f06779"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"425e3169-2eb1-40d2-b14b-3d7e0639ab05"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Checked case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"d241696b-03f9-42a3-9c43-964754e99659"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Checked case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"b910994d-be97-46b9-89ac-ef7f16f8b111"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"a5ab7f9f-ba97-4fb7-bdee-780b39c29301"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"fc4af8f6-b1dd-412c-9e42-4b233078915f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"c874772d-87a6-4c13-a8b4-93994bf8240e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"aaf130f8-593f-4c94-b6e3-cb976d29ead2"],

Cell[BoxData["632112"], \
"Output",ExpressionUUID->"86701036-8cc4-432b-9595-dabd968fa98f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "[", 
  RowBox[{"5", ",", 
   RowBox[{"InvarCases", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"7ac6f188-8366-417e-ac3d-12956b5e1cdd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"c23c1e89-5295-4e92-a94e-86f55c881dd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"ddc6f8ae-0122-48c3-b00c-e154affec8cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"f875f6d2-a765-45c3-b7de-e4a853f8e1f8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"1de0d318-604c-4f22-8790-1b4f906262b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"24dd2224-96fe-4321-b28e-82fdfa235c23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"5ef155f1-51a5-46f4-8eed-003463f8a9c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"e363a203-e821-4ca1-90d3-0988f501fb24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"b9671890-f4e0-46c2-96a5-d51fa1c2db4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ed417246-1f33-4236-8c0b-3f8a22560840"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"b85393e2-8aa4-44f1-a747-a78d6ecc6c70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"cfbea627-f996-4c32-ac19-3c544202addf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e3cc4a26-50b8-4ec3-9840-7a660d8d2907"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ef551c0a-d0c5-431a-99a1-dc2364b99373"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"b90be581-1095-4900-a2f9-f22f22a012e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"06fbf0f2-1a2f-4392-899a-3041b8a1ac4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b031dd07-4a82-4b4a-92bf-e4bde178965e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"0155cd22-6cb1-477c-a69d-b936280bdd1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"3d1bf292-30a8-4a04-bdd9-92925e326bd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"994d9ef2-dbdb-4f72-8b07-df02d47713d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5c712042-dbd2-4992-ba09-fcf48e24cdf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"df0a2e54-f6b8-4d46-b1f1-d7904576ecd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"7e43a49f-cae7-451d-a872-87566b1cb006"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"112c7744-be7d-4f2f-ac09-5b5da3c2feb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"85e9d775-af35-450a-92b5-15b0d816218b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"632e169c-3a92-4a0d-ae75-3cc1e6b59dc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Checked case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"ce5eae9e-d9fa-4607-9b4e-7945495baa71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"7ba85bc3-7f75-43b6-8df9-eabd2e26c5d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d950bfa4-a04a-4b15-ae44-c9078394c4e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ed9ac188-9f75-478a-a2ce-8ffa2dc87cdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"663abe9b-a16d-4255-ae0f-c44f4f5032f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"d24c9d36-a0af-4a1e-947b-6430474a8e7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e4289fa1-7598-48fb-b743-0f6a86788c5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"83205abd-c240-4b08-b7a1-816e9f5d3b11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"19c36511-da1b-4bb6-9035-e67d3c801d6a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"f3e6abf4-8aa0-4369-a0d0-4dbdfdd0a914"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"217a9d9f-3136-454a-b891-bfe76680c1ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"326a402e-1dfa-4237-b514-c76a76cb15c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"992e5f3c-a7dc-458b-ac5b-3e6f07f9f958"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"c8ba3821-f27e-42e6-87eb-107b1534ef3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ae2e5d7b-ff83-43c1-bb2f-22b30ed4ea4f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"85cfd0ba-29d3-4db0-9d17-4d06b0761557"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Checked case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"16562dce-8e5c-4954-9b76-587ccde1c06b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Checked case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"affe4fbf-e2a3-44a8-95e8-89fb227f9892"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Checked case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"24a0e689-0af8-4227-acf8-de87fc7c3380"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Checked case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"25b966ed-c0ed-49bc-a04c-a03d9571cfcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"bdc778e8-db23-4f39-b963-7eafb61060ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Checked case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"5e1e2f38-8d84-47e9-8e51-8500d49254e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
     "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"ccb74a7b-5123-49e0-b0e4-d3a16d9a39d8"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"f28052b7-cff4-447f-9383-8532aeff22db"],

Cell[BoxData["637910"], \
"Output",ExpressionUUID->"73f2eb0a-6008-4e1f-8646-07e33f37de0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MemoryInUse", "[", "]"}], "/", "1024."}], "/", 
  "1000"}]], "Input",ExpressionUUID->"3eb0bf87-3119-439d-8b01-80ea2c83fcf0"],

Cell[BoxData["6496.03225`"], \
"Output",ExpressionUUID->"3d18ec61-28d0-4624-8c4c-c5a7bae72a1b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Dual invariants", \
"Subsubsection",ExpressionUUID->"093e7c1f-16bd-4d6a-b7e0-6cd38acd4ec6"],

Cell["Now read dual invariants:", \
"Text",ExpressionUUID->"fdd9f5ee-8364-4264-a46c-66328bd8d6c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dualtable", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"DualRInvs", "[", 
      RowBox[{"step", ",", 
       RowBox[{
        RowBox[{"InvarCases", "[", "]"}], "[", 
        RowBox[{"[", "case", "]"}], "]"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"step", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"case", ",", "15"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"62a8b601-7e0d-4dc4-bf42-1f668383384f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"138e71fa-bc9e-4b71-ad4e-38c0b3d86e63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"52dae62c-b690-4f86-a519-17d643963a1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"d71405ec-1c6d-4769-9a1e-d00adb172ffe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"8b15a207-ce84-4c8f-a35c-78b39d602725"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d06e5c13-fc0f-440b-9e62-4a10a47f6f5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"b704d5a4-d750-4b38-ac96-0b90a2ca992b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"bde2660d-d90d-4fdc-a735-69768ef90bcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"1a2ef38e-1fb1-4ff4-a7e6-0efcc98461b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"a82e1e1a-aca2-475f-9c00-138800911b45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"9ea53f09-ccbd-4da2-8fa1-d7b04ebe8140"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"45639b6f-39ee-44bb-ad3d-58daaffec100"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"d6b6441d-3456-4836-ab11-69ae18b81704"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"748cc60c-50e4-4ee9-933e-1742895fe0dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"f633a651-6b71-4ba9-9781-06b081d47d5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"f2430b26-40e3-4768-a468-9050cb821711"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"46d2fd44-06aa-4a76-8a69-efab30c64306"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"c1d2e88e-3f5e-4f61-9577-5c4fd6d5015a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"4e150239-2855-4fe5-a4b7-2ea9587bae56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"28967e13-4200-4a23-9a88-0de4d16070b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"e86fd773-35c6-4b1f-9282-2dcd2541fe24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"17b8088e-8d89-4722-99c2-a50b0c762ab8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"defa0554-b5bf-4096-9786-2bde996972fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"30e6dde3-fac4-4670-88ce-5ce48d91bbeb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"ab7b4cec-0e87-4a4e-87ef-75da59e21d87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"88760906-af24-4189-a8b5-e2f4d647c0dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"d09a0f01-89e1-409f-b51f-9a8521aeb2a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"bca0774c-1698-406b-8c7e-94f117eb2c2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"981c7d4c-4e22-46fe-8eb7-5b4bd09fd469"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"6a28ccc4-eecd-457e-8ca6-c1e8071bcb71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"80b3c1b6-405d-4a20-af5e-aa7b6199a21f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"3d1d9751-c98d-41ba-99d4-8e033f556ef1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"c2501e83-fceb-4831-9af5-f6d25ddc5b43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"00be4978-387c-4606-ac56-4128493a326d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"47143049-0ea4-4745-b742-a531d0a0a89b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"28a46621-691e-4d67-b1f3-88550b9ee0ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"35c93cd8-f763-4b37-a403-476e843e9ece"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"84e54444-5095-41d1-bf64-fcdd636cd545"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"8da5916b-8e05-4db7-958e-9888d72fb6dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"da435539-eae1-42b1-8ace-fe8b22609d24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5f8c76e9-6e56-4e51-b2ed-50fbc8a0f68a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"ba349c85-49f0-46be-b46e-aefcf9e29e92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"d73afe27-cf71-49b5-9352-b617cacda71d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"6525cdb5-df3f-47df-a22e-78cfd4f7dd7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"eb3dd114-5f02-4d6d-9a65-4483a8a43fab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"382b56d5-0e3e-4934-93dc-b1251484d7c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"caa3acfb-2880-408d-bc9a-cbd0e53f7d81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9ff90eb0-6e26-424f-b2e3-f6c16e348400"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"df9875de-80e2-44b3-950d-f72aabe0ef51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"8ffa4c73-6f51-4de7-bf6d-1e3e358a532f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"70278ae2-df21-4b83-9a52-7ad8bf3a1ee4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"85df0228-9616-4f3b-b06b-715dda1fe938"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"b11bb6ce-2b69-4239-9182-6477b674d75e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"9f48b04f-dd48-47ba-bfb2-8d49ccc17773"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"9e45bffb-a729-4a7c-8b71-910fe6998e18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"41e2337a-f2f0-4d92-bfad-3eaf32157791"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"ea65d733-7f08-4fd7-8a3c-59d12ca0d683"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"568b0045-ef15-40dd-b115-3299f10fb9ba"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "4", ",", "3", ",", "27", ",", "58", ",", "36", ",", "32", ",", 
     "232", ",", "967", ",", "1047", ",", "876", ",", "920", ",", "478", ",", 
     "435", ",", "2582"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "6", ",", "13", ",", "9", ",", "11", ",", 
     "40", ",", "212", ",", "236", ",", "285", ",", "296", ",", "163", ",", 
     "220", ",", "330"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "6", ",", "5", ",", "2", ",", "4", ",", 
     "40", ",", "98", ",", "54", ",", "128", ",", "60", ",", "37", ",", "95", 
     ",", "330"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "6", ",", "1", ",", "2", ",", "0", ",", 
     "40", ",", "29", ",", "54", ",", "1", ",", "2", ",", "3", ",", "0", ",", 
     "330"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "2", ",", "1", ",", "2", ",", "0", ",", "1",
      ",", "6", ",", "13", ",", "1", ",", "2", ",", "3", ",", "0", ",", "2"}],
     "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"602a56ca-c89f-45aa-882b-fbee03ffa396"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InvarCases", "[", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}], "}"}], ",", 
     "dualtable"}], "]"}], "]"}], "//", 
  "MatrixForm"}]], \
"Input",ExpressionUUID->"d1c66ca7-4680-4d4f-b17e-bbf1e2cdf91b"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"{", "0", "}"}], "1", "0", "0", "0", "0"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "4", "1", "1", "1", "1"},
     {
      RowBox[{"{", "2", "}"}], "3", "0", "0", "0", "0"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], "27", "6", "6", "6", "2"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], "58", "13", "5", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "36", "9", "2", "2", "2"},
     {
      RowBox[{"{", "4", "}"}], "32", "11", "4", "0", "0"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "232", "40", "40", 
      "40", "1"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2"}], "}"}], "967", "212", "98", "29", 
      "6"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], "1047", "236", "54", "54", 
      "13"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], "876", "285", "128", "1", "1"},
     {
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "920", "296", "60", "2", "2"},
     {
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], "478", "163", "37", "3", "3"},
     {
      RowBox[{"{", "6", "}"}], "435", "220", "95", "0", "0"},
     {
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "2582", 
      "330", "330", "330", "2"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"c197b207-97d7-4b76-bbde-6f7ce1e398f0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "/@", 
  "dualtable"}]], \
"Input",ExpressionUUID->"f7a5368c-b04d-421d-8d9f-69e1416079d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7698", ",", "1822", ",", "860", ",", "469", ",", "34"}], 
  "}"}]], "Output",ExpressionUUID->"cf828816-f7d6-403a-8b35-e13053663124"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "[", "%", "]"}], "-", 
  RowBox[{
  "Last", "[", "%", 
   "]"}]}]], "Input",ExpressionUUID->"0c67980a-ec16-47a5-b3fb-1d7f325151b7"],

Cell[BoxData["7664"], \
"Output",ExpressionUUID->"c70b5a5d-5a88-4855-8dce-d8a34ff4d455"]
}, Open  ]],

Cell["There are 7664 relations for 7698 canonical dual invariants.", \
"Text",ExpressionUUID->"e8ffe878-8e09-4d82-99f8-963c12d6639b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MemoryInUse", "[", "]"}], "/", "1024"}], "/", 
  "1000."}]], "Input",ExpressionUUID->"a9f5bb9b-125d-4a5d-a3bf-5bf36b44c89c"],

Cell[BoxData["445.9801484375`"], \
"Output",ExpressionUUID->"6371726d-7ec1-4e9a-afb0-f7d5a8bb1955"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "knowns", 
  "]"}]], "Input",ExpressionUUID->"ceba9f6b-e1e2-4106-a539-10b08edc9055"],

Cell[BoxData["254735"], \
"Output",ExpressionUUID->"2e5c231f-4811-4a6e-997f-910088f48031"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"checkdual", "[", 
   RowBox[{"step_", ",", "cases_"}], "]"}], ":=", 
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"case", "=", 
      RowBox[{"cases", "[", 
       RowBox[{"[", "count", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rules", "=", 
      RowBox[{"DualRInvRules", "[", 
       RowBox[{"step", ",", "case"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"right", "=", 
      RowBox[{"Union", "@", 
       RowBox[{"Cases", "[", 
        RowBox[{
         RowBox[{"Last", "/@", "rules"}], ",", 
         RowBox[{
          RowBox[{"RInv", "[", 
           RowBox[{"_", ",", "_"}], "]"}], "|", 
          RowBox[{"DualRInv", "[", 
           RowBox[{"_", ",", "_"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"inters", "=", 
      RowBox[{"Intersection", "[", 
       RowBox[{"right", ",", "knowns"}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"inters", "=!=", 
        RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<There are \>\"", ",", "inters", 
         ",", "\"\< rules to use in case \>\"", ",", "case"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Checked case \>\"", ",", "case"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"knowns", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"knowns", ",", 
        RowBox[{"First", "/@", "rules"}]}], "]"}]}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"count", ",", "1", ",", 
      RowBox[{"Length", "[", "cases", "]"}]}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"055c9713-0a90-4483-8a1f-ad1e67f11c8c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkdual", "[", 
  RowBox[{"2", ",", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"435c7fc2-81ce-4b35-a0ae-df9235f1715e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"cff91d8f-a298-4830-afee-acc14b641313"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"84bc0259-6957-4148-a518-ffc4ba2ddae0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"21559240-5dcf-4cb6-91d6-1d9d55f2bf3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"cfa82c0c-1b5c-4d2c-861f-50c148b9bfe4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"552f5cd0-964a-42a0-8293-815651975ca0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ceb9c070-98fc-4913-997c-922eae21ea53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"44c2a05d-cd03-4e25-866d-bfe9da2d4283"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"a6560eb2-7f51-468c-9869-391f8cb36725"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"495fa7d6-ea77-482d-aa15-62e619f8dce2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"3892b042-f8a9-49a5-984a-dfd7e9592203"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"2e1f7a5d-1db7-4c47-b9a4-59ad88200f7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"780bb76d-aab2-4186-8363-c8e33a0a62dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"56c6675e-0e5a-4aa3-8223-f107d860421c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"5328c776-72fd-403f-aa84-ef37f928d24b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"6e93dc55-c6c3-40de-9f95-20429558c27d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkdual", "[", 
  RowBox[{"3", ",", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"dcc5030b-065b-4f41-9ea4-9b5827cc92e2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"2be005f0-be99-4d3d-a196-0d9661a34fce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"963fff31-af37-406d-b9fc-2a9e25180336"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"4de6037c-2038-41dc-b30f-4ca0fd12f723"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"769ceda1-0462-4672-814d-7d831065f534"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"1780d985-6d35-4634-b3cd-ada8fb0fb7c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"9a781913-6e3b-48bc-930c-6bdcda30435d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"593d0674-dbc4-41ec-b81a-152793c56be4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"a730dd8c-0be6-4b2d-a9b1-0e80929dcf48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"0fdb6d2b-76b5-4174-a4db-ab84697f73c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"c61756f1-1219-4a36-8e6b-c91b252d833f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"2da5ada4-4c27-4356-b59d-5237935d3937"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"3ba63152-47a4-4212-959c-d87c19de8fd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9501641e-602d-4538-b57e-5d1d0b6a0d56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"6bb936b9-1419-4dea-a399-7be5a64920ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"359dcf38-96af-47da-8e22-4e9fc7cb7b5f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkdual", "[", 
  RowBox[{"4", ",", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"f2ee5752-79a2-4755-a11c-cd2790750b25"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"a76f5283-1cf5-401b-ac08-02dafb656331"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"20bb1557-bade-4fc0-ad96-43ab5ddfc0d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"b44bd81f-9db2-486a-b8a1-e46044d391dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"46de9ac9-1c21-4b6a-ac15-f24c680b2976"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"47d03456-b809-458a-a808-3721daa0ad11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"6068e88f-43cb-44a7-8caa-ffdbb542850c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"aa9a12d8-dee3-4643-86b0-c65fa3bde616"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"7217ba2b-a1c5-4a63-a1b2-8e779eef87b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"7bf77523-70c3-4168-84dc-b108d1fa1da1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"d2a4d502-f93e-4099-b316-9c1e7dbd38c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"49d4f52c-fc94-4842-94aa-4c190975e07f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"eddabc89-bbd5-4c9b-b739-b88441970819"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9dce3064-0600-4c2d-b622-2ab0c200e7d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"36103508-95fa-42d9-82b8-bd7d81746256"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"d6ae1ac8-e592-44d0-9b43-ff956b4dfde6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkdual", "[", 
  RowBox[{"5", ",", 
   RowBox[{
    RowBox[{"InvarCases", "[", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"Range", "[", "15", "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"d76cfdae-7148-4c29-a234-d818116fdb03"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Checked case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"a4b37ea1-23e2-428f-aee2-8948ed54488a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"06a4ee96-9d5f-41fb-9797-58dfb47cb772"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Checked case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"cdb7ef31-35e9-467a-9469-2fbafb14ca53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"3867467d-bb7f-41bf-ab0f-30321a6f2605"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ee8bc0a6-43b7-4240-927b-c0210c5d2974"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"5e2cd360-0e8e-4b71-ad53-161083a7f307"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Checked case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"6cda2827-9176-4fa3-a64c-a93fedbc93ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"b4dfb664-b9bd-4aca-9253-c13bca6dbf2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"bf96a670-7011-4522-b238-ebd1ccdc5798"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Checked case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"6d6485bd-8c74-4823-8488-3a80bb0d73a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Checked case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1c036d0d-479f-4062-a013-3aecd14fb6b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Checked case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"3f44cdef-51d6-4ecd-85a1-44b03b574a31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Checked case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f8303cff-0786-49ce-886a-e24553bdae3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Checked case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"a362a1ff-1615-4dcd-84ad-3b952eec3e22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Checked case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Checked case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"fe66e568-8ef7-4554-857f-ad3680cca489"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Algebraic invariants", \
"Subsubsection",ExpressionUUID->"1c24a05b-0540-4904-8cd0-0f6059729028"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"table", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"RInvs", "[", 
      RowBox[{"step", ",", "degree"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"step", ",", "1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"degree", ",", "1", ",", "7"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"c26cf9ee-da2e-45d7-8b1c-17f0d6459b28"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "9", ",", "38", ",", "204", ",", "1613", ",", 
     "16532"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "5", ",", "15", ",", "54", ",", "270", ",", "1639"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "5", ",", "15", ",", "54", ",", "270", ",", "1639"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "5", ",", "15", ",", "54", ",", "270", ",", "1639"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "8", ",", "7"}],
     "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"e4b00a96-475a-4081-8523-f2d379250e16"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Transpose", "[", "table", "]"}], 
  "]"}]], "Input",ExpressionUUID->"a8058de7-9aa8-4c94-b5e2-47e8c23b46c4"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "1", "1", "1", "1"},
    {"3", "2", "2", "2", "2"},
    {"9", "5", "5", "5", "3"},
    {"38", "15", "15", "15", "4"},
    {"204", "54", "54", "54", "5"},
    {"1613", "270", "270", "270", "8"},
    {"16532", "1639", "1639", "1639", "7"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"6dd50ac0-d602-4994-aae6-dd8ce0408aad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "/@", 
  "table"}]], "Input",ExpressionUUID->"05cdb761-f515-4251-970c-97e2e38e249a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18400", ",", "1986", ",", "1986", ",", "1986", ",", "30"}], 
  "}"}]], "Output",ExpressionUUID->"f2a5af82-57f7-4a13-b64b-2edc52ba7b45"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "[", "%", "]"}], "-", 
  RowBox[{
  "Last", "[", "%", 
   "]"}]}]], "Input",ExpressionUUID->"26aaee33-74b9-45c3-8601-b916d9c6422b"],

Cell[BoxData["18370"], \
"Output",ExpressionUUID->"583694e7-beca-4983-9900-bc1dc576947f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dualtable", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"DualRInvs", "[", 
      RowBox[{"step", ",", "degree"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"step", ",", "1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"degree", ",", "1", ",", "5"}], "}"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"0aa03b44-367a-47c5-9e61-0a169bfabcb8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "27", ",", "232", ",", "2582"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "6", ",", "40", ",", "330"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "6", ",", "40", ",", "330"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "6", ",", "40", ",", "330"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "1", ",", "2"}], "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"d8cdaa63-4851-4286-a10d-41181717872c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Transpose", "[", "dualtable", "]"}], 
  "]"}]], "Input",ExpressionUUID->"02678521-21e2-4923-a2be-2990852b60ef"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "0", "0", "0", "0"},
    {"4", "1", "1", "1", "1"},
    {"27", "6", "6", "6", "2"},
    {"232", "40", "40", "40", "1"},
    {"2582", "330", "330", "330", "2"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$]]]], \
"Output",ExpressionUUID->"33c767e3-f440-41ad-99b6-cc08d38966a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "/@", 
  "dualtable"}]], \
"Input",ExpressionUUID->"43fb29f1-5fe6-45ab-b083-e75290f1ef90"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2846", ",", "377", ",", "377", ",", "377", ",", "6"}], 
  "}"}]], "Output",ExpressionUUID->"cdfa14ba-d710-43de-be74-7df3a5c1ed4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "[", "%", "]"}], "-", 
  RowBox[{
  "Last", "[", "%", 
   "]"}]}]], "Input",ExpressionUUID->"8490acad-7c74-49c9-b3a4-a898c16cbce2"],

Cell[BoxData["2840"], \
"Output",ExpressionUUID->"1a25b51a-3beb-4589-a444-2e4f3b8de480"]
}, Open  ]],

Cell[TextData[{
 "Number of canonical forms handled: ",
 StyleBox["21246",
  FontSize->18]
}], "Text",ExpressionUUID->"64103168-db19-422d-ba85-eb914e01b248"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"18400", "+", 
  "2846"}]], "Input",ExpressionUUID->"5c2963db-c949-44bd-9abe-2eb324cb62ff"],

Cell[BoxData["21246"], \
"Output",ExpressionUUID->"ee4f3b06-6a00-409c-b2d7-5c9e80c5069b"]
}, Open  ]],

Cell[TextData[{
 "Number of independent objects: ",
 StyleBox["25",
  FontSize->18],
 ". Therefore we have ",
 StyleBox["21221",
  FontSize->18],
 " relations."
}], "Text",ExpressionUUID->"8c785e3d-0bfb-49dc-af4d-650965e0dd1a"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Weyl", \
"Subsection",ExpressionUUID->"f27f4d36-dc8d-47c8-9a38-1fc04debfec0"],

Cell[CellGroupData[{

Cell["Riemann <-> Weyl conversion rules. INCOMPLETE. DEACTIVATED", \
"Subsubsection",ExpressionUUID->"03674c32-0a30-4f7c-9248-8801d89fc683"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DispatchRToWRules", "[", 
    RowBox[{"step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchRToWRules", "[", 
     RowBox[{"step", ",", "case"}], "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"RToWRules", "[", 
      RowBox[{"step", ",", "case"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchRToWDualRules", "[", 
    RowBox[{"step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchRToWDualRules", "[", 
     RowBox[{"step", ",", "case"}], "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"RToWDualRules", "[", 
      RowBox[{"step", ",", "case"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchWToRRules", "[", 
    RowBox[{"step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchWToRRules", "[", 
     RowBox[{"step", ",", "case"}], "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"WToRRules", "[", 
      RowBox[{"step", ",", "case"}], "]"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchWToRDualRules", "[", 
    RowBox[{"step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchWToRDualRules", "[", 
     RowBox[{"step", ",", "case"}], "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"WToRDualRules", "[", 
      RowBox[{"step", ",", "case"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 Evaluatable->False,ExpressionUUID->"bb80ab44-3a4f-4b75-a38f-67ff9a3ad4dc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fileread", "[", 
    RowBox[{"RToWRules", ",", "step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<RToW/RToW\>\"", ",", 
     RowBox[{"ToString", "[", "step", "]"}], ",", "\"\<_R\>\"", ",", 
     RowBox[{"ToString", "[", "case", "]"}], ",", "\"\<.mpl\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fileread", "[", 
    RowBox[{"RToWDualRules", ",", "step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<RToW/RToW\>\"", ",", 
     RowBox[{"ToString", "[", "step", "]"}], ",", "\"\<_D\>\"", ",", 
     RowBox[{"ToString", "[", "case", "]"}], ",", "\"\<.mpl\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fileread", "[", 
    RowBox[{"WToRRules", ",", "step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<WToR/WToR\>\"", ",", 
     RowBox[{"ToString", "[", "step", "]"}], ",", "\"\<_R\>\"", ",", 
     RowBox[{"ToString", "[", "case", "]"}], ",", "\"\<.mpl\>\""}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"fileread", "[", 
    RowBox[{"WToRDualRules", ",", "step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<WToR/WToR\>\"", ",", 
     RowBox[{"ToString", "[", "step", "]"}], ",", "\"\<_D\>\"", ",", 
     RowBox[{"ToString", "[", "case", "]"}], ",", "\"\<.mpl\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"read", "[", 
   RowBox[{"file_", ",", "step_Integer", ",", "case_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Reading \>\"", ",", "file", ",", "\"\< for step \>\"", ",",
        "step", ",", "\"\< and case \>\"", ",", "case"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ReadInvarRules", "[", 
      RowBox[{
       RowBox[{"fileread", "[", 
        RowBox[{"file", ",", "step", ",", "case"}], "]"}], 
       ",", "\"\<Mathematica\>\""}], "]"}]}]}], "]"}]}]}], "Input",
 Evaluatable->False,ExpressionUUID->"b6c11307-6e52-4177-8fb3-adf99c87142b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RToWRules", "[", 
    RowBox[{"step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"RToWRules", "[", 
      RowBox[{"step", ",", "case"}], "]"}], ",", 
     RowBox[{"read", "[", 
      RowBox[{"RToWRules", ",", "step", ",", "case"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RToWDualRules", "[", 
    RowBox[{"step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"RToWDualRules", "[", 
      RowBox[{"step", ",", "case"}], "]"}], ",", 
     RowBox[{"read", "[", 
      RowBox[{"RToWDualRules", ",", "step", ",", "case"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WToRRules", "[", 
    RowBox[{"step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"WToRRules", "[", 
      RowBox[{"step", ",", "case"}], "]"}], ",", 
     RowBox[{"read", "[", 
      RowBox[{"WToRRules", ",", "step", ",", "case"}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"WToRDualRules", "[", 
    RowBox[{"step_Integer", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"WToRDualRules", "[", 
      RowBox[{"step", ",", "case"}], "]"}], ",", 
     RowBox[{"read", "[", 
      RowBox[{"WToRDualRules", ",", "step", ",", "case"}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 Evaluatable->False,ExpressionUUID->"7890430c-3f94-46b1-b6c9-4d2cea8bf2ce"]
}, Closed]],

Cell[CellGroupData[{

Cell["Weyl simplification: levels 3 and 4. INCOMPLETE. DEACTIVATED", \
"Subsubsection",ExpressionUUID->"0443ae81-e439-4e79-b073-7b8255ae4d52"],

Cell["These two files are still incomplete for degree 6 and 7:", \
"Text",ExpressionUUID->"946f9045-ea4b-4166-9dce-11d0318debf9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DispatchWInvRules3", "[", "case_", "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchWInvRules3", "[", "case", "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"WInvRules", "[", 
      RowBox[{"3", ",", "case"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchDualWInvRules3", "[", "case_", "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchDualWInvRules3", "[", "case", "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"DualWInvRules", "[", 
      RowBox[{"3", ",", "case"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchWInvRules4", "[", "case_", "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchWInvRules4", "[", "case", "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"WInvRules", "[", 
      RowBox[{"4", ",", "case"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DispatchDualWInvRules4", "[", "case_", "]"}], ":=", 
   RowBox[{
    RowBox[{"DispatchDualWInvRules4", "[", "case", "]"}], "=", 
    RowBox[{"Dispatch", "[", 
     RowBox[{"DualWInvRules", "[", 
      RowBox[{"4", ",", "case"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 Evaluatable->False,ExpressionUUID->"cdfc0bc1-211a-4e56-8063-7ccb3482bce8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fileread", "[", 
    RowBox[{"WInvRules", ",", "level_", ",", "case_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<Weyl/WInvar\>\"", ",", 
     RowBox[{"ToString", "[", "level", "]"}], ",", "\"\<_R\>\"", ",", 
     RowBox[{"ToString", "[", "case", "]"}], ",", "\"\<.mpl\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fileread", "[", 
    RowBox[{"DualWInvRules", ",", "level_", ",", "case_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<Weyl/WInvar\>\"", ",", 
     RowBox[{"ToString", "[", "level", "]"}], ",", "\"\<_D\>\"", ",", 
     RowBox[{"ToString", "[", "case", "]"}], ",", "\"\<.mpl\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WInvRules", "[", 
    RowBox[{"3", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"WInvRules", "[", 
      RowBox[{"3", ",", "case"}], "]"}], ",", 
     RowBox[{"read", "[", 
      RowBox[{"WInvRules", ",", "3", ",", "case"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualWInvRules", "[", 
    RowBox[{"3", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"DualWInvRules", "[", 
      RowBox[{"3", ",", "case"}], "]"}], ",", 
     RowBox[{"read", "[", 
      RowBox[{"DualWInvRules", ",", "3", ",", "case"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WInvRules", "[", 
    RowBox[{"4", ",", "case_"}], "]"}], ":=", 
   RowBox[{"ProtSet", "[", 
    RowBox[{
     RowBox[{"WInvRules", "[", 
      RowBox[{"4", ",", "case"}], "]"}], ",", 
     RowBox[{"read", "[", 
      RowBox[{"WInvRules", ",", "4", ",", "case"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DualWInvRules", "[", 
    RowBox[{"4", ",", "case"}], "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 Evaluatable->False,ExpressionUUID->"c343761b-f237-42e4-bcd3-b0646db8cd36"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The ten main functions", \
"Section",ExpressionUUID->"0b79587a-1891-479d-9ef5-0fc2946cf411"],

Cell[CellGroupData[{

Cell["InvSimplify", \
"Subsection",ExpressionUUID->"7e50793f-3345-4fd1-bb11-4c682c254040"],

Cell["\<\
This function takes an expression containing RInv and DualRInv objects (or \
their Weyl counterparts) and simplify them to the level given by the user. \
Note that there is no use of permutations.\
\>", "Text",ExpressionUUID->"08280df5-e8e7-4fdd-9fd4-a56ae5689800"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "InvSimplify"}]], \
"Input",ExpressionUUID->"10bed032-80a0-4063-942f-b388109f24b1"],

Cell[BoxData["\<\"InvSimplify[expr, level] simplifies the invariants of the \
form inv[metric][case,count] in the expression expr, where inv is one of \
RInv, DualRInv, WInv, DualWInv. There are six possible levels of \
simplification: 1 means no simplification; 2 uses the cyclic identity; 3 uses \
the Bianchi identity; 4 commutes covariant derivatives; 5 uses dimensionally \
dependent (Lovelock type) identities and 6 reduces some non-dual invariants \
into products of dual invariants. The default level used in InvSimplify[expr] \
is $InvSimplifyLevel.\"\>"], "Print",
 CellTags->
  "Info3411227614-4799785",ExpressionUUID->"478e1b84-3ab7-46b7-ba9e-\
9919af24c071"]
}, Open  ]],

Cell["\<\
User driver: conversion to InvSimplify1, which knows the dimension of the \
vbundle of the metric and already acts on a single invariant. Note that the \
most external function of InvSimplify is Expand, and not Simplify.\
\>", "Text",ExpressionUUID->"0c961b1f-47d7-41ce-949a-bc65e832e4fb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify", "[", "expr_", "]"}], ":=", 
   RowBox[{"InvSimplify", "[", 
    RowBox[{"expr", ",", "$InvSimplifyLevel"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify", "[", 
    RowBox[{"expr_", ",", "1"}], "]"}], ":=", "expr"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify", "[", 
    RowBox[{"expr_", ",", "step_"}], "]"}], ":=", 
   RowBox[{"Expand", "[", 
    RowBox[{"expr", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"inv", ":", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"RInv", "|", "DualRInv", "|", "WInv", "|", "DualWInv"}], 
           ")"}], "[", "metric_", "]"}], "[", 
         RowBox[{"_", ",", "_"}], "]"}]}], "\[RuleDelayed]", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"dim", "=", 
            RowBox[{"DimOfVBundle", "@", 
             RowBox[{"VBundleOfMetric", "@", "metric"}]}]}], ",", 
           RowBox[{"sigma", "=", 
            RowBox[{"SignDetOfMetric", "[", "metric", "]"}]}]}], "}"}], ",", 
         RowBox[{"InvSimplify1", "[", 
          RowBox[{"inv", ",", "step", ",", "dim"}], "]"}]}], "]"}]}], "}"}]}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"InvSimplify", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e38628e1-7b42-4c94-9c33-5fa02ceb30af"],

Cell["\<\
InvSimplify1 receives one invariant. Initial checks. If correct, move on to \
InvSimplify2.\
\>", "Text",ExpressionUUID->"5b4933f2-880c-4768-9caf-fe51fc48c1cc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify1", "[", 
    RowBox[{"inv_", ",", "1", ",", "_"}], "]"}], ":=", "inv"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify1", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"DualRInv", "|", "DualWInv"}], ")"}], "[", "_", "]"}], "[", 
      RowBox[{"_", ",", "_"}], "]"}], ",", "_", ",", "dim_Integer"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Duals are only handled in dimension 4.\>\"", "]"}], "/;", 
    RowBox[{"dim", "=!=", "4"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify1", "[", 
    RowBox[{"_", ",", 
     RowBox[{"5", "|", "6"}], ",", "dim_Integer"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Levels 5 and 6 of simplication are only possible in \
dimension 4.\>\"", "]"}], "/;", 
    RowBox[{"dim", "=!=", "4"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify1", "[", 
    RowBox[{
     RowBox[{"inv", ":", 
      RowBox[{
       RowBox[{"_", "[", "metric_", "]"}], "[", 
       RowBox[{"_", ",", "_"}], "]"}]}], ",", 
     RowBox[{"step", ":", 
      RowBox[{"(", 
       RowBox[{"2", "|", "3", "|", "4", "|", "5", "|", "6"}], ")"}]}], ",", 
     "dim_"}], "]"}], ":=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"InvSimplify56", "[", 
      RowBox[{
       RowBox[{"InvSimplify234", "[", 
        RowBox[{"inv", ",", "step"}], "]"}], ",", "step"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RInv", "\[Rule]", 
        RowBox[{"RInv", "[", "metric", "]"}]}], ",", 
       RowBox[{"DualRInv", "\[Rule]", 
        RowBox[{"DualRInv", "[", "metric", "]"}]}], ",", 
       RowBox[{"WInv", "\[Rule]", 
        RowBox[{"WInv", "[", "metric", "]"}]}], ",", 
       RowBox[{"DualWInv", "\[Rule]", 
        RowBox[{"DualWInv", "[", "metric", "]"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify1", "[", 
    RowBox[{"inv_", ",", "step_", ",", "dim_"}], "]"}], ":=", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Invalid level of simplification: \>\"", ",", "step"}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"292ff4c8-be6f-4e46-9e0c-24c5b758e3ed"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify234", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RInv", "[", "metric_", "]"}], "[", 
      RowBox[{"case_", ",", "count_"}], "]"}], ",", "step_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"newexpr", "=", 
       RowBox[{"RInv", "[", 
        RowBox[{"case", ",", "count"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"RInvs", "[", 
           RowBox[{"step", ",", "case"}], "]"}], ",", "newexpr"}], "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"newexpr", "=", 
          RowBox[{"newexpr", "/.", 
           RowBox[{"DispatchRules", "[", 
            RowBox[{"RInv", ",", "2", ",", "case"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"newexpr", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"step", "\[GreaterEqual]", "3"}], ",", 
            RowBox[{"newexpr", "/.", 
             RowBox[{"DispatchRules", "[", 
              RowBox[{"RInv", ",", "3", ",", "case"}], "]"}]}], ",", 
            "newexpr"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"newexpr", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"step", "\[GreaterEqual]", "4"}], ",", 
            RowBox[{"newexpr", "/.", 
             RowBox[{"DispatchRules", "[", 
              RowBox[{"RInv", ",", "4", ",", "case"}], "]"}]}], ",", 
            "newexpr"}], "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      "newexpr"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify234", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DualRInv", "[", "metric_", "]"}], "[", 
      RowBox[{"case_", ",", "count_"}], "]"}], ",", "step_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"newexpr", "=", 
       RowBox[{"DualRInv", "[", 
        RowBox[{"case", ",", "count"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"DualRInvs", "[", 
           RowBox[{"step", ",", "case"}], "]"}], ",", "newexpr"}], "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"newexpr", "=", 
          RowBox[{"newexpr", "/.", 
           RowBox[{"DispatchRules", "[", 
            RowBox[{"DualRInv", ",", "2", ",", "case"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"newexpr", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"step", "\[GreaterEqual]", "3"}], ",", 
            RowBox[{"newexpr", "/.", 
             RowBox[{"DispatchRules", "[", 
              RowBox[{"DualRInv", ",", "3", ",", "case"}], "]"}]}], ",", 
            "newexpr"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"newexpr", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"step", "\[GreaterEqual]", "4"}], ",", 
            RowBox[{"newexpr", "/.", 
             RowBox[{"DispatchRules", "[", 
              RowBox[{"DualRInv", ",", "4", ",", "case"}], "]"}]}], ",", 
            "newexpr"}], "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      "newexpr"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify234", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"WInv", "[", "metric_", "]"}], "[", 
      RowBox[{"case_", ",", "count_"}], "]"}], ",", "step_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"RInvs", "[", 
        RowBox[{"step", ",", "case"}], "]"}], ",", 
       RowBox[{"RInv", "[", 
        RowBox[{"case", ",", "count"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"WInv", "[", 
      RowBox[{"case", ",", "count"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"newexpr", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"RInv", "[", 
            RowBox[{"case", ",", "count"}], "]"}], "/.", 
           RowBox[{"DispatchRules", "[", 
            RowBox[{"RInv", ",", "2", ",", "case"}], "]"}]}], "/.", 
          RowBox[{"RInv", "\[Rule]", "WInv"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"newexpr", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"step", "\[GreaterEqual]", "3"}], ",", 
           RowBox[{"newexpr", "/.", 
            RowBox[{"DispatchRules", "[", 
             RowBox[{"WInv", ",", "3", ",", "case"}], "]"}]}], ",", 
           "newexpr"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"newexpr", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"step", "\[GreaterEqual]", "4"}], ",", 
           RowBox[{"newexpr", "/.", 
            RowBox[{"DispatchRules", "[", 
             RowBox[{"WInv", ",", "4", ",", "case"}], "]"}]}], ",", 
           "newexpr"}], "]"}]}], ";", "\[IndentingNewLine]", "newexpr"}]}], 
      "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify234", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DualWInv", "[", "metric_", "]"}], "[", 
      RowBox[{"case_", ",", "count_"}], "]"}], ",", "step_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"DualRInvs", "[", 
        RowBox[{"step", ",", "case"}], "]"}], ",", 
       RowBox[{"DualRInv", "[", 
        RowBox[{"case", ",", "count"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DualWInv", "[", 
      RowBox[{"case", ",", "count"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"newexpr", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"DualRInv", "[", 
            RowBox[{"case", ",", "count"}], "]"}], "/.", 
           RowBox[{"DispatchRules", "[", 
            RowBox[{"DualRInv", ",", "2", ",", "case"}], "]"}]}], "/.", 
          RowBox[{"DualRInv", "\[Rule]", "DualWInv"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"newexpr", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"step", "\[GreaterEqual]", "3"}], ",", 
           RowBox[{"newexpr", "/.", 
            RowBox[{"DispatchRules", "[", 
             RowBox[{"DualWInv", ",", "3", ",", "case"}], "]"}]}], ",", 
           "newexpr"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"newexpr", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"step", "\[GreaterEqual]", "4"}], ",", 
           RowBox[{"newexpr", "/.", 
            RowBox[{"DispatchRules", "[", 
             RowBox[{"DualWInv", ",", "4", ",", "case"}], "]"}]}], ",", 
           "newexpr"}], "]"}]}], ";", "\[IndentingNewLine]", "newexpr"}]}], 
      "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7d413d00-a80a-407b-8605-485b7236bbe6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RulesFor", "[", 
   RowBox[{
    RowBox[{"inv_", "[", 
     RowBox[{"case_", ",", "_"}], "]"}], ",", "step_"}], "]"}], ":=", 
  RowBox[{"DispatchRules", "[", 
   RowBox[{"inv", ",", "step", ",", "case", ",", "dim"}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"532a4ae0-2229-4abb-878d-051acfdc4a50"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify56", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"step_", "/;", 
      RowBox[{"step", "<", "5"}]}]}], "]"}], ":=", "expr"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify56", "[", 
    RowBox[{"expr_", ",", "5"}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"inv", ":", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"RInv", "|", "DualRInv", "|", "WInv", "|", "DualWInv"}], 
         ")"}], "[", 
        RowBox[{"case_", ",", "_"}], "]"}]}], "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"inv", "/.", 
        RowBox[{"RulesFor", "[", 
         RowBox[{"inv", ",", "5"}], "]"}]}], ")"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvSimplify56", "[", 
    RowBox[{"expr_", ",", "6"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"InvSimplify56", "[", 
     RowBox[{"expr", ",", "5"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"inv", ":", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"RInv", "|", "WInv"}], ")"}], "[", 
        RowBox[{"case_", ",", "_"}], "]"}]}], "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"inv", "/.", 
        RowBox[{"RulesFor", "[", 
         RowBox[{"inv", ",", "6"}], "]"}]}], ")"}]}], "}"}]}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0b5402ea-6639-4a3d-a4fe-b84b75e296d4"]
}, Closed]],

Cell[CellGroupData[{

Cell["InvToPerm", \
"Subsection",ExpressionUUID->"98b53240-742c-4a66-b283-13b3090b7224"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "InvToPerm"}]], \
"Input",ExpressionUUID->"18f05000-6a23-45ae-a886-5710713e1a3f"],

Cell[BoxData["\<\"InvToPerm[expr] converts all invariants in expr into their \
corresponding permutations with head RPerm or WPerm.\"\>"], "Print",
 CellTags->
  "Info3411227615-8565162",ExpressionUUID->"3fbcbd95-b910-4a02-a7fc-\
5e8643499744"]
}, Open  ]],

Cell["\<\
With the Canon permutations we need to use the Cycles notation.\
\>", "Text",ExpressionUUID->"dca09fef-fe01-42fa-bac8-abe1403ee61a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"toCycles", "[", 
    RowBox[{"cycles", ":", 
     RowBox[{"{", "___List", "}"}]}], "]"}], ":=", 
   RowBox[{"Apply", "[", 
    RowBox[{"Cycles", ",", "cycles"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fc2de310-68d0-4cb6-967b-88c9bfd9856b"],

Cell["Focus InvToPerm on single invariants:", \
"Text",ExpressionUUID->"f4728342-1eec-495f-b91f-ba3cae56232e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvToPerm", "[", "expr_", "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"inv", ":", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"RInv", "|", "DualRInv", "|", "WInv", "|", "DualWInv"}], 
         ")"}], "[", "_", "]"}], "[", 
       RowBox[{"_", ",", "_"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{"InvToPerm", "[", "inv", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvToPerm", "[", 
    RowBox[{
     RowBox[{"RInv", "[", "metric_", "]"}], "[", 
     RowBox[{"case_", ",", "count_"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"RPerm", "[", "metric", "]"}], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"case", ",", "0"}], "}"}], ",", 
     RowBox[{"toCycles", "[", 
      RowBox[{
       RowBox[{"RInv", "[", 
        RowBox[{"case", ",", "count"}], "]"}], "/.", 
       RowBox[{"DispatchRInvToPermRules", "[", "case", "]"}]}], "]"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvToPerm", "[", 
    RowBox[{
     RowBox[{"DualRInv", "[", "metric_", "]"}], "[", 
     RowBox[{"case_", ",", "count_"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"RPerm", "[", "metric", "]"}], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"case", ",", "1"}], "}"}], ",", 
     RowBox[{"toCycles", "[", 
      RowBox[{
       RowBox[{"DualRInv", "[", 
        RowBox[{"case", ",", "count"}], "]"}], "/.", 
       RowBox[{"DispatchDualRInvToPermRules", "[", "case", "]"}]}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvToPerm", "[", 
    RowBox[{
     RowBox[{"WInv", "[", "metric_", "]"}], "[", 
     RowBox[{"case_", ",", "count_"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"WPerm", "[", "metric", "]"}], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"case", ",", "0"}], "}"}], ",", 
     RowBox[{"toCycles", "[", 
      RowBox[{
       RowBox[{"RInv", "[", 
        RowBox[{"case", ",", "count"}], "]"}], "/.", 
       RowBox[{"DispatchRInvToPermRules", "[", "case", "]"}]}], "]"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InvToPerm", "[", 
    RowBox[{
     RowBox[{"DualWInv", "[", "metric_", "]"}], "[", 
     RowBox[{"case_", ",", "count_"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"WPerm", "[", "metric", "]"}], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"case", ",", "1"}], "}"}], ",", 
     RowBox[{"toCycles", "[", 
      RowBox[{
       RowBox[{"DualRInv", "[", 
        RowBox[{"case", ",", "count"}], "]"}], "/.", 
       RowBox[{"DispatchDualRInvToPermRules", "[", "case", "]"}]}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"InvToPerm", ",", "1"}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"4d3657db-68a6-43d9-8bf4-45e7198bb26e"],

Cell["\<\
There is nothing to decide in this function. All invariants will be converted \
into permutations, unless the degree and index supplied is incorrect.\
\>", "Text",ExpressionUUID->"1a9702e3-d580-452a-85ac-f7a2b95f0347"]
}, Closed]],

Cell[CellGroupData[{

Cell["PermToRiemann", \
"Subsection",ExpressionUUID->"1ebec63c-8d6b-4f25-a1ca-1d17d37d123f"],

Cell["\<\
We need to introduce indices. This is done through these two auxiliary \
functions. Note that they are defined with remembered values, and so they are \
computed just once. We specify 2*9 because that is the most complicated case \
we shall need:\
\>", "Text",ExpressionUUID->"a7c9ab0b-219a-4a34-8444-5c6accdef1dc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"upindices", "[", "metric_", "]"}], ":=", 
   RowBox[{
    RowBox[{"upindices", "[", "metric", "]"}], "=", 
    RowBox[{"GetIndicesOfVBundle", "[", 
     RowBox[{
      RowBox[{"VBundleOfMetric", "[", "metric", "]"}], ",", "18"}], "]"}]}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"canon", "[", "metric_", "]"}], ":=", 
   RowBox[{
    RowBox[{"canon", "[", "metric", "]"}], "=", 
    RowBox[{"Flatten", "@", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"upindices", "[", "metric", "]"}], ",", 
        RowBox[{"Minus", "/@", 
         RowBox[{"upindices", "[", "metric", "]"}]}]}], "}"}], "]"}]}]}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a70c6da2-4d05-471c-b8e4-f30573e64a30"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PermToRiemann"}]], \
"Input",ExpressionUUID->"648f845e-0095-49cc-a3d4-6f4a87b41cb7"],

Cell[BoxData["\<\"PermToRiemann[expr, cr] converts all permutations into \
their explicit tensor expressions. With cr=True contracted Riemann tensors \
are replaced by Ricci tensors. The default value used in PermToRiemann[expr] \
is $CurvatureRelations.\"\>"], "Print",
 CellTags->
  "Info3411227616-4472405",ExpressionUUID->"730278ff-7516-4276-8a0c-\
cd2a93350f1d"]
}, Open  ]],

Cell["\<\
Any permutation can be converted into a Riemann expression using \
PermToRiemann. The first point is translating the permutation into Images \
notation:\
\>", "Text",ExpressionUUID->"dcfe233e-5a51-4bcc-bb18-d46454769501"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"translate", "[", 
    RowBox[{
     RowBox[{"RPerm", "[", "metric_", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"case_", ",", "dege_"}], "}"}], ",", "perm_"}], "]"}], "]"}], ":=", 
   RowBox[{"First", "@", 
    RowBox[{"TranslatePerm", "[", 
     RowBox[{"perm", ",", 
      RowBox[{"{", 
       RowBox[{"Images", ",", 
        RowBox[{
         RowBox[{"4", 
          RowBox[{"Length", "[", "case", "]"}]}], "+", 
         RowBox[{"Plus", "@@", "case"}], "+", 
         RowBox[{"4", "dege"}]}]}], "}"}]}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"54ad2eea-dadc-45f0-b199-5be720d4df0c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RPerm", "[", "metric_", "]"}], "[", 
    RowBox[{"info_", ",", 
     RowBox[{"-", "perm_"}]}], "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"RPerm", "[", "metric", "]"}], "[", 
     RowBox[{"info", ",", "perm"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"WPerm", "[", "metric_", "]"}], "[", 
    RowBox[{"info_", ",", 
     RowBox[{"-", "perm_"}]}], "]"}], ":=", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"WPerm", "[", "metric", "]"}], "[", 
     RowBox[{"info", ",", "perm"}], "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5bc4b2f9-579d-4ed3-9a82-60c65622e016"],

Cell["\<\
We construct a function which transforms a given permutation into a Riemann \
(or Weyl) expression:\
\>", "Text",ExpressionUUID->"7e4034c1-eadd-43de-a904-8117b5e2c88a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"riemannof", "[", 
    RowBox[{"metric_", ",", "0", ",", "indices_", ",", 
     RowBox[{"{", 
      RowBox[{"other___", ",", "n_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"CD", "=", 
       RowBox[{"CovDOfMetric", "[", "metric", "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Apply", "[", 
        RowBox[{"Composition", ",", 
         RowBox[{"CD", "/@", 
          RowBox[{"indices", "[", 
           RowBox[{"[", 
            RowBox[{"Range", "[", 
             RowBox[{
              RowBox[{"4", "+", "n"}], ",", "5", ",", 
              RowBox[{"-", "1"}]}], "]"}], "]"}], "]"}]}]}], "]"}], "[", 
       RowBox[{"Apply", "[", 
        RowBox[{
         RowBox[{"Riemann", "[", "CD", "]"}], ",", 
         RowBox[{"Take", "[", 
          RowBox[{"indices", ",", "4"}], "]"}]}], "]"}], "]"}], 
      RowBox[{"riemannof", "[", 
       RowBox[{"metric", ",", "0", ",", 
        RowBox[{"Drop", "[", 
         RowBox[{"indices", ",", 
          RowBox[{"4", "+", "n"}]}], "]"}], ",", 
        RowBox[{"{", "other", "}"}]}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"riemannof", "[", 
    RowBox[{"metric_", ",", "1", ",", "indices_", ",", "case_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"riemannof", "[", 
     RowBox[{"metric", ",", "0", ",", 
      RowBox[{"Drop", "[", 
       RowBox[{"indices", ",", 
        RowBox[{"-", "4"}]}], "]"}], ",", "case"}], "]"}], 
    RowBox[{"Apply", "[", 
     RowBox[{
      RowBox[{"epsilon", "[", "metric", "]"}], ",", 
      RowBox[{"Take", "[", 
       RowBox[{"indices", ",", 
        RowBox[{"-", "4"}]}], "]"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"riemannof", "[", 
    RowBox[{"_", ",", "_", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ":=", "1"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a4c8a5b1-93d4-4eac-b4d8-f0ad0ee77235"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PermToRiemann", "[", "rperm_", "]"}], ":=", 
    RowBox[{"PermToRiemann", "[", 
     RowBox[{"rperm", ",", "$CurvatureRelations"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"On", " ", "Riemann", " ", "permutations"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PermToRiemann", "[", 
     RowBox[{
      RowBox[{"rperm", ":", 
       RowBox[{
        RowBox[{"RPerm", "[", "metric_", "]"}], "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"case_", ",", "dege_"}], "}"}], ",", "_"}], "]"}]}], ",", 
      "cr_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"ToRicci", "[", 
      RowBox[{"metric", ",", "cr"}], "]"}], "[", 
     RowBox[{"riemannof", "[", 
      RowBox[{"metric", ",", "dege", ",", 
       RowBox[{
        RowBox[{"canon", "[", "metric", "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"translate", "[", "rperm", "]"}], "]"}], "]"}], ",", 
       RowBox[{"Reverse", "[", "case", "]"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"On", " ", "Weyl", " ", "permutations"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PermToRiemann", "[", 
     RowBox[{
      RowBox[{"wperm", ":", 
       RowBox[{
        RowBox[{"WPerm", "[", "metric_", "]"}], "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"_", ",", "_"}], "}"}], ",", "_"}], "]"}]}], ",", "_"}], 
     "]"}], ":=", 
    RowBox[{"ToWeyl", "[", 
     RowBox[{
      RowBox[{"PermToRiemann", "[", 
       RowBox[{
        RowBox[{"wperm", "/.", 
         RowBox[{"WPerm", "\[Rule]", "RPerm"}]}], ",", "True"}], "]"}], ",", 
      RowBox[{"CovDOfMetric", "[", "metric", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"On", " ", "general", " ", "expressions"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermToRiemann", "[", 
    RowBox[{"expr_", ",", "cr_"}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"perm", ":", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"RPerm", "|", "WPerm"}], ")"}], "[", "_", "]"}], "[", "__", 
       "]"}]}], "\[RuleDelayed]", 
     RowBox[{"PermToRiemann", "[", 
      RowBox[{"perm", ",", "cr"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermToRiemann", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"527c8485-b101-4e99-9b12-a5af8aa5229b"],

Cell["\<\
It is returned with canon indices, not with dollar-indices. That is why we \
need to wrap it with Scalar. There is a second argument in PermToRiemman to \
specify whether the contracted Riemann must be replaced by Ricci:\
\>", "Text",ExpressionUUID->"4fbf9e0f-a43f-4068-826d-079d27dcadbb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ToRicci", "[", 
     RowBox[{"metric_", ",", "False"}], "]"}], "[", "expr_", "]"}], ":=", 
   RowBox[{"Scalar", "[", "expr", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ToRicci", "[", 
     RowBox[{"metric_", ",", "True"}], "]"}], "[", "expr_", "]"}], ":=", 
   RowBox[{"Scalar", "@", 
    RowBox[{"ReplaceDummies", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ContractMetric", "[", 
        RowBox[{
         RowBox[{"expr", "/.", 
          RowBox[{"CurvatureRelations", "[", 
           RowBox[{
            RowBox[{"CovDOfMetric", "[", "metric", "]"}], ",", "Riemann"}], 
           "]"}]}], ",", "metric"}], "]"}], "/.", 
       RowBox[{"CurvatureRelations", "[", 
        RowBox[{
         RowBox[{"CovDOfMetric", "[", "metric", "]"}], ",", "Ricci"}], 
        "]"}]}], ",", 
      RowBox[{"IndexList", "@@", 
       RowBox[{"upindices", "[", "metric", "]"}]}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToWeyl", "[", 
    RowBox[{"expr_", ",", "cd_"}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Riemann", "[", "cd", "]"}], "\[RuleDelayed]", 
       RowBox[{"Weyl", "[", "cd", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Ricci", "[", "cd", "]"}], "\[RuleDelayed]", 
       RowBox[{"TFRicci", "[", "cd", "]"}]}]}], "}"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"6af35d24-b901-436b-b2df-21f9776c8b1d"],

Cell["\<\
Only cr (True or False, with default True) needs to be decided in this \
function.\
\>", "Text",ExpressionUUID->"ebfebb78-8cdc-4961-9e06-5f6a42c4825e"]
}, Closed]],

Cell[CellGroupData[{

Cell["InvToRiemann", \
"Subsection",ExpressionUUID->"783c628d-0d34-4dd5-b052-a7a5fba12bc3"],

Cell["\<\
The invariant Inv[metric][n,m] is converted into a Riemann expression using \
the function InvToRiemann1:\
\>", "Text",ExpressionUUID->"12908396-4583-4ee6-8961-9183ae5cbfa2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvToRiemann1", "[", "cr_", "]"}], "[", 
    RowBox[{"inv", ":", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"RInv", "|", "DualRInv", "|", "WInv", "|", "DualWInv"}], 
        ")"}], "[", "_", "]"}], "[", 
      RowBox[{"_", ",", "_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"PermToRiemann", "[", 
    RowBox[{
     RowBox[{"InvToPerm", "[", "inv", "]"}], ",", "cr"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"72abaaaa-a306-4d7f-a7eb-59a113ece32d"],

Cell["\<\
This intermediate function is in charge of detecting these very frequent \
cases:\
\>", "Text",ExpressionUUID->"6760bdcb-d75e-4878-bee1-17becbd24ff1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvToRiemann1", "[", "False", "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"RInv", "|", "WInv"}], ")"}], "[", "metric_", "]"}], "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "1"}], "]"}], "]"}], ":=", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     RowBox[{"Riemann", "[", 
      RowBox[{"CovDOfMetric", "[", "metric", "]"}], "]"}], "@@", 
     RowBox[{
      RowBox[{"canon", "[", "metric", "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvToRiemann1", "[", "True", "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"RInv", "|", "WInv"}], ")"}], "[", "metric_", "]"}], "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", "1"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"RicciScalar", "[", 
     RowBox[{"CovDOfMetric", "[", "metric", "]"}], "]"}], "[", "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"bffd0f20-9c54-4104-9328-5a055f877691"],

Cell["\<\
Main translation function. Note that there is no ToCanonical. We assume that \
the permutations of the invariants have been already canonicalized:\
\>", "Text",ExpressionUUID->"f674b5db-89c3-48e3-8b8e-9fcb26cad7bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "InvToRiemann"}]], \
"Input",ExpressionUUID->"72ceec2a-4aa3-45bb-8f00-152bc5f9fd5a"],

Cell[BoxData["\<\"InvToRiemann[expr, cr] converts all invariants into their \
explicit tensor expressions. With cr=True contracted Riemann tensors are \
replaced by Ricci tensors. The default value used in InvToRiemann[expr] is \
$CurvatureRelations.\"\>"], "Print",
 CellTags->
  "Info3411227617-3523154",ExpressionUUID->"6d7169c0-f22a-4bbc-95b0-\
49e64270e578"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InvToRiemann", "[", "expr_", "]"}], ":=", 
   RowBox[{"InvToRiemann", "[", 
    RowBox[{"expr", ",", "$CurvatureRelations"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InvToRiemann", "[", 
    RowBox[{"expr_", ",", "cr_"}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"inv", ":", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"RInv", "|", "DualRInv", "|", "WInv", "|", "DualWInv"}], 
         ")"}], "[", "_", "]"}], "[", 
       RowBox[{"_", ",", "_"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"InvToRiemann1", "[", "cr", "]"}], "[", "inv", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"InvToRiemann", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0c5045e4-d77d-4d81-9ca2-3722716b7def"]
}, Closed]],

Cell[CellGroupData[{

Cell["RiemannToPerm", \
"Subsection",ExpressionUUID->"8e9cdeb4-96cd-4dd4-9797-499888f2fe5d"],

Cell["\<\
Given any **monomial** Riemann expression, we need to know the degree of that \
expression in terms of Riemann's and Ricci's, and the degree in terms of \
epsilons. Note that the three objects are given by the metric:\
\>", "Text",ExpressionUUID->"1e17edf0-8925-4df4-8bce-faf4954ee278"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"addone", "[", 
    RowBox[{"head_", "[", "n_Integer", "]"}], "]"}], ":=", 
   RowBox[{"head", "[", 
    RowBox[{"n", "+", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"addone", "[", 
    RowBox[{"casePlus", "[", 
     RowBox[{"{", 
      RowBox[{"head_", ",", "n_Integer"}], "}"}], "]"}], "]"}], ":=", 
   RowBox[{"casePlus", "[", 
    RowBox[{"{", 
     RowBox[{"head", ",", 
      RowBox[{"n", "+", "1"}]}], "}"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f70eef07-ebad-4ec0-b62b-495dbb4f420a"],

Cell[BoxData[{
 RowBox[{"SetAttributes", "[", 
  RowBox[{"casePlus", ",", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "Orderless"}], "}"}]}], "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"casePlus", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"head_", ",", "n__"}], "}"}], ",", "c___", ",", 
     RowBox[{"{", 
      RowBox[{"head_", ",", "m__"}], "}"}]}], "]"}], ":=", 
   RowBox[{"casePlus", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"head", ",", "m", ",", "n"}], "}"}], ",", "c"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"casePlus", "[", 
    RowBox[{"0", ",", "c___"}], "]"}], ":=", 
   RowBox[{"casePlus", "[", "c", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"casePlus", "[", "ERROR", "]"}], ":=", "ERROR"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"casePlus", "[", 
    RowBox[{"ERROR", ",", "__"}], "]"}], ":=", "ERROR"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"94c2d7e7-52fd-4d1f-a25f-50d5ced5a173"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"casePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Ricci", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Riemann", ",", "6"}], "}"}], ",", "0", ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"Riemann", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Riemann", ",", "4"}], "}"}], ",", 
   RowBox[{"casePlus", "[", 
    RowBox[{
     RowBox[{"casePlus", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Ricci", ",", "3"}], "}"}], ",", "0", ",", 
     RowBox[{"{", 
      RowBox[{"Riemann", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Weyl", ",", "5"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"69ced8fa-b94d-444f-8b5e-9f48dfadd45e"],

Cell[BoxData[
 RowBox[{"casePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Weyl", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Ricci", ",", "3", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Riemann", ",", "1", ",", "2", ",", "4", ",", "6"}], "}"}]}], 
  "]"}]], "Output",ExpressionUUID->"9e454bbc-a794-44e5-9385-f64c52b4fcdd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"degrees", "[", 
   RowBox[{"expr_", ",", "cd_", ",", "metric_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"riemann", "=", 
       RowBox[{"Riemann", "[", "cd", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ricci", "=", 
       RowBox[{"Ricci", "[", "cd", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ricciscalar", "=", 
       RowBox[{"RicciScalar", "[", "cd", "]"}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"weyl", "=", 
       RowBox[{"Weyl", "[", "cd", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"tfricci", "=", 
       RowBox[{"TFRicci", "[", "cd", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"eps", "=", 
       RowBox[{"epsilon", "[", "metric", "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "deg", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"deg", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"cd", "[", "_", "]"}], "[", "expr1_", "]"}], "x_."}], 
         "]"}], ":=", 
        RowBox[{"casePlus", "[", 
         RowBox[{
          RowBox[{"addone", "[", 
           RowBox[{"deg", "[", "expr1", "]"}], "]"}], ",", 
          RowBox[{"deg", "[", "x", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"deg", "[", 
         RowBox[{"_riemann", " ", "x_."}], "]"}], ":=", 
        RowBox[{"casePlus", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Riemann", ",", "0"}], "}"}], ",", 
          RowBox[{"deg", "[", "x", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"deg", "[", 
         RowBox[{"_ricci", " ", "x_."}], "]"}], ":=", 
        RowBox[{"casePlus", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Ricci", ",", "0"}], "}"}], ",", 
          RowBox[{"deg", "[", "x", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"deg", "[", 
         RowBox[{"_ricciscalar", " ", "x_."}], "]"}], ":=", 
        RowBox[{"casePlus", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"RicciScalar", ",", "0"}], "}"}], ",", 
          RowBox[{"deg", "[", "x", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"deg", "[", 
         RowBox[{"_weyl", " ", "x_."}], "]"}], ":=", 
        RowBox[{"casePlus", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Weyl", ",", "0"}], "}"}], ",", 
          RowBox[{"deg", "[", "x", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"deg", "[", 
         RowBox[{"_tfricci", " ", "x_."}], "]"}], ":=", 
        RowBox[{"casePlus", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"TFRicci", ",", "0"}], "}"}], ",", 
          RowBox[{"deg", "[", "x", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"deg", "[", 
         RowBox[{"_eps", " ", "x_."}], "]"}], ":=", 
        RowBox[{"casePlus", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"epsilon", ",", "0"}], "}"}], ",", 
          RowBox[{"deg", "[", "x", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"deg", "[", 
         RowBox[{"1", "|", 
          RowBox[{"-", "1"}]}], "]"}], ":=", "0"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"deg", "[", "x_", "]"}], ":=", "Infinity"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"deg", "[", "expr", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4f9cc366-473c-41b3-ae63-935ca0a995bf"],

Cell["\<\
The function is essentially based on the use sowing of the new list of \
indices by ToCanonical (this was its GivePerm option before xTensor 1.1.0). \
We need the function RiemannToPerm1 to avoid using PutScalar several times, \
which would be time-consuming. In this case we need to separate the action on \
the different metrics which have been defined and therefore this function \
does need a metric argument. It is a different question whether we make this \
feature public or not. October 2011: We have added a wrapping ContractMetric \
to fix cases like metric[a,b]Ricci[-a,-b] or metric[a,b]Riemann[-a,-c,-b,c].\
\>", "Text",ExpressionUUID->"6de65dad-9d2e-49da-bfd8-daaa8b3f973f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"First", " ", "expand"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm", "[", 
      RowBox[{"expr_", ",", "args___"}], "]"}], ":=", 
     RowBox[{"RiemannToPerm0", "[", 
      RowBox[{
       RowBox[{"ContractMetric", "@", 
        RowBox[{"Expand", "[", "expr", "]"}]}], ",", "args"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"RiemannToPerm", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Thread", " ", "over", " ", "sums"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm0", "[", 
      RowBox[{"expr_Plus", ",", "args___"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"RiemannToPerm0", "[", 
        RowBox[{"#", ",", "args"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm0", "[", 
      RowBox[{"expr_", ",", "args___"}], "]"}], ":=", 
     RowBox[{"RiemannToPerm1", "[", 
      RowBox[{
       RowBox[{"BreakScalars", "@", 
        RowBox[{"PutScalar", "[", "expr", "]"}]}], ",", "args"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Deal", " ", "with", " ", "the", " ", "second", " ", "argument"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm1", "[", "expr_", "]"}], ":=", 
     RowBox[{"RiemannToPerm1", "[", 
      RowBox[{"expr", ",", "$Metrics"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm1", "[", 
      RowBox[{"expr_", ",", "metrics_List"}], "]"}], ":=", 
     RowBox[{"Fold", "[", 
      RowBox[{"RiemannToPerm1", ",", "expr", ",", "metrics"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Possibilities", " ", "for", " ", "the", " ", "first", " ", "argument"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm1", "[", 
      RowBox[{
       RowBox[{"Scalar", "[", "expr_", "]"}], ",", "metric_Symbol"}], "]"}], ":=", 
     RowBox[{"arrange", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"degrees", "[", 
        RowBox[{"expr", ",", 
         RowBox[{"CovDOfMetric", "[", "metric", "]"}], ",", "metric"}], "]"}],
        ",", "metric"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm1", "[", 
      RowBox[{"expr_Times", ",", "metric_Symbol"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"RiemannToPerm1", "[", 
        RowBox[{"#", ",", "metric"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm1", "[", 
      RowBox[{
       RowBox[{"tensor_Symbol", "[", "]"}], ",", "metric_Symbol"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"RPerm", "[", "metric", "]"}], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "0", "}"}], ",", "0"}], "}"}], ",", 
        RowBox[{"xAct`xPerm`Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}], "/;", 
      RowBox[{"tensor", "===", 
       RowBox[{"RicciScalar", "[", 
        RowBox[{"CovDOfMetric", "[", "metric", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm1", "[", 
      RowBox[{
       RowBox[{"Power", "[", 
        RowBox[{"expr_", ",", "n_Integer"}], "]"}], ",", "metric_Symbol"}], 
      "]"}], ":=", 
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"RiemannToPerm1", "[", 
        RowBox[{"expr", ",", "metric"}], "]"}], ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToPerm1", "[", 
      RowBox[{"expr_", ",", "x_"}], "]"}], ":=", "expr"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"771e8ed4-e001-4319-ba77-7b69a95680ba"],

Cell["\<\
Note that the RicciScalar is always converted into RInv[metric][{0},1] and \
never into WInv[metric][{0},1]. This additional step must be done by the \
user. The function arrange always receives a monomial.\
\>", "Text",ExpressionUUID->"c18ae027-3b98-4f21-ab78-40386adeb16f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"0.", " ", "Trivial", " ", "cases"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"arrange", "[", 
      RowBox[{"0", ",", "_", ",", "_"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"arrange", "[", 
      RowBox[{"expr_", ",", "Infinity", ",", "_"}], "]"}], ":=", "expr"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"1.", " ", "There", " ", "is", " ", "Ricci", " ", "or", " ", 
     RowBox[{"RicciScalar", ":", " ", 
      RowBox[{"convert", " ", "to", " ", "Riemann"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"arrange", "[", 
       RowBox[{"expr_", ",", 
        RowBox[{"casePlus", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Ricci", "|", "RicciScalar"}], ",", "m__"}], "}"}], ",", 
          "c___"}], "]"}], ",", "metric_"}], "]"}], "]"}], ":=", 
     RowBox[{"arrange", "[", 
      RowBox[{
       RowBox[{"RicciToRiemann", "[", 
        RowBox[{"expr", ",", 
         RowBox[{"CovDOfMetric", "[", "metric", "]"}]}], "]"}], ",", 
       RowBox[{"casePlus", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Riemann", ",", "m"}], "}"}], ",", "c"}], "]"}], ",", 
       "metric"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"2", 
     RowBox[{"a", ".", " ", "There"}], " ", "are", " ", "only", " ", 
     RowBox[{"Riemanns", ":", " ", 
      RowBox[{
       RowBox[{"compute", " ", "non"}], "-", 
       RowBox[{"dual", " ", "permutation"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"arrange", "[", 
       RowBox[{"expr_", ",", 
        RowBox[{"casePlus", "[", 
         RowBox[{"{", 
          RowBox[{"Riemann", ",", "Rcase__"}], "}"}], "]"}], ",", "metric_"}],
        "]"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"canonical", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"#", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "}"}], 
           "&"}], "@", 
          RowBox[{"Reap", "[", 
           RowBox[{
            RowBox[{"ToCanonical", "[", "expr", "]"}], 
            ",", "\"\<NewIndices\>\""}], "]"}]}]}], "}"}], ",", 
       RowBox[{"arrange1", "[", 
        RowBox[{"canonical", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Sort", "[", 
            RowBox[{"{", "Rcase", "}"}], "]"}], ",", "0"}], "}"}], ",", 
         "metric"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"2", 
     RowBox[{"b", ".", " ", "There"}], " ", "are", " ", "only", " ", 
     "Riemanns", " ", "and", " ", "an", " ", "epsilon", " ", 
     RowBox[{"tensor", ":", " ", 
      RowBox[{"compute", " ", "dual", " ", 
       RowBox[{"permutation", ".", " ", "Oct"}], " ", "2011"}], ":", " ", 
      RowBox[{
      "epsilon", " ", "must", " ", "be", " ", "sorted", " ", "last"}]}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"arrange", "[", 
       RowBox[{"expr_", ",", 
        RowBox[{"casePlus", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Riemann", ",", "Rcase__"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"epsilon", ",", "0"}], "}"}]}], "]"}], ",", "metric_"}], 
       "]"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"epsilonname", "=", 
         RowBox[{"epsilon", "[", "metric", "]"}]}], "}"}], ",", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "result", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"TagSet", "[", 
           RowBox[{"epsilonname", ",", 
            RowBox[{"xSortPrecedence", "[", "epsilonname", "]"}], ",", 
            "Infinity"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"canonical", "=", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", 
                    RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "}"}], 
                "&"}], "@", 
               RowBox[{"Reap", "[", 
                RowBox[{
                 RowBox[{"ToCanonical", "[", "expr", "]"}], 
                 ",", "\"\<NewIndices\>\""}], "]"}]}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"result", "=", 
             RowBox[{"arrange1", "[", 
              RowBox[{"canonical", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Sort", "[", 
                  RowBox[{"{", "Rcase", "}"}], "]"}], ",", "1"}], "}"}], ",", 
               "metric"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"TagUnset", "[", 
           RowBox[{"epsilonname", ",", 
            RowBox[{"xSortPrecedence", "[", "epsilonname", "]"}]}], "]"}], ";",
           "\[IndentingNewLine]", "result"}]}], "\[IndentingNewLine]", 
        "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"3.", " ", "There", " ", "are", " ", 
     RowBox[{"Weyl", "/", "TFRicci"}], " ", 
     RowBox[{"only", ":", " ", 
      RowBox[{"convert", " ", "to", " ", 
       RowBox[{"Riemann", ".", " ", "NOT"}], " ", "UPDATED"}]}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"arrange", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "degWeyl_", ",", "degTFRic_", ",", "degeps_"}], 
        "}"}], ",", "metric_"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"cd", "=", 
         RowBox[{"CovDOfMetric", "[", "metric", "]"}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"arrange", "[", 
         RowBox[{
          RowBox[{"ToRiemann", "[", 
           RowBox[{
            RowBox[{"FromWeyl", "[", 
             RowBox[{"expr", ",", "cd"}], "]"}], ",", "cd", ",", "metric"}], 
           "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"degWeyl", "+", "degTFRic"}], ",", "0", ",", "0", ",", 
            "0", ",", "degeps"}], "}"}], ",", "metric"}], "]"}], "/.", 
        RowBox[{"RPerm", "\[Rule]", "WPerm"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"4.", " ", "Final", " ", "arrangements"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"arrange1", "[", 
      RowBox[{"0", ",", "_", ",", "_"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"arrange1", "[", 
      RowBox[{
       RowBox[{"_Symbol", "[", 
        RowBox[{"a_", ",", "b_", ",", 
         RowBox[{"-", "a_"}], ",", 
         RowBox[{"-", "b_"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "0", "}"}], ",", "0"}], "}"}], ",", "metric_"}], "]"}], 
     ":=", 
     RowBox[{
      RowBox[{"RPerm", "[", "metric", "]"}], "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "0", "}"}], ",", "0"}], "}"}], ",", 
       RowBox[{"xAct`xPerm`Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"arrange1", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"expr_", ",", 
         RowBox[{"{", 
          RowBox[{"sign_", ",", "perm_IndexList"}], "}"}]}], "}"}], ",", 
       RowBox[{"degs", ":", 
        RowBox[{"{", 
         RowBox[{"_", ",", "_"}], "}"}]}], ",", "metric_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"RPerm", "[", "metric", "]"}], "[", 
      RowBox[{"degs", ",", 
       RowBox[{"sign", " ", 
        RowBox[{"TranslatePerm", "[", 
         RowBox[{
          RowBox[{"PermutationFromTo", "[", 
           RowBox[{
            RowBox[{"List", "@@", "perm"}], ",", 
            RowBox[{"List", "@@", 
             RowBox[{"IndexSort", "[", "perm", "]"}]}]}], "]"}], ",", 
          "xAct`xPerm`Cycles"}], "]"}]}]}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"132e94c6-4fbf-44c0-b6a1-e8dfdb367dd6"],

Cell["\<\
The function FromWeyl changes temporarily the heads WeylCD and TRicciCD by \
RiemannCD and RicciCD respectively. This is a trick to avoid duplicated code.\
\
\>", "Text",ExpressionUUID->"bd7457c1-d314-4f72-bdd3-5226c5088f07"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FromWeyl", "[", 
    RowBox[{"expr_", ",", "cd_"}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Weyl", "[", "cd", "]"}], "\[RuleDelayed]", 
       RowBox[{"Riemann", "[", "cd", "]"}]}], ",", 
      RowBox[{
       RowBox[{"TFRicci", "[", "cd", "]"}], "\[RuleDelayed]", 
       RowBox[{"Ricci", "[", "cd", "]"}]}]}], "}"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a2f0d6e6-a6d7-4bef-9792-3dc4d36d44d6"],

Cell["\<\
This function converts any Ricci tensor into its corresponding Riemann tensor \
(added $RicciSign in version 2.0.4, as pointed out by Teake):\
\>", "Text",ExpressionUUID->"2979d4ae-65bd-45a8-b4ef-c267075dfd0f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RicciToRiemann", "[", 
    RowBox[{"expr_", ",", "cd_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ricciscalar", "=", 
        RowBox[{"RicciScalar", "[", "cd", "]"}]}], ",", 
       RowBox[{"ricci", "=", 
        RowBox[{"Ricci", "[", "cd", "]"}]}], ",", 
       RowBox[{"riemann", "=", 
        RowBox[{"Riemann", "[", "cd", "]"}]}], ",", 
       RowBox[{"vbundle", "=", 
        RowBox[{"First", "@", 
         RowBox[{"VBundlesOfCovD", "[", "cd", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"expr", "/.", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ricciscalar", "[", "]"}], "\[RuleDelayed]", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"c", "=", 
              RowBox[{"DummyIn", "@", "vbundle"}]}], ",", 
             RowBox[{"d", "=", 
              RowBox[{"DummyIn", "@", "vbundle"}]}]}], "}"}], ",", 
           RowBox[{"$RicciSign", " ", 
            RowBox[{"riemann", "[", 
             RowBox[{"c", ",", "d", ",", 
              RowBox[{"-", "c"}], ",", 
              RowBox[{"-", "d"}]}], "]"}]}]}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"ricci", "[", 
          RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", "=", 
             RowBox[{"DummyIn", "@", "vbundle"}]}], "}"}], ",", 
           RowBox[{"$RicciSign", " ", 
            RowBox[{"riemann", "[", 
             RowBox[{"a", ",", 
              RowBox[{"-", "c"}], ",", "b", ",", "c"}], "]"}]}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"11dee6df-8aa6-4322-a644-01a897e11adb"]
}, Closed]],

Cell[CellGroupData[{

Cell["PermToInv", \
"Subsection",ExpressionUUID->"d0f173da-c5d0-4a76-98c0-d3c64f352f08"],

Cell["\<\
Note also that these dispatched rules have no metric argument; it is added at \
the end. It is important to realize that right now this command will only \
work if the permutation is already in canonical form.\
\>", "Text",ExpressionUUID->"d4475aea-b45e-47f5-838b-ab95a1818d26"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PermToInv", "[", 
    RowBox[{
     RowBox[{"RPerm", "[", "metric_", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"case_", ",", "0"}], "}"}], ",", "perm_"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"perm", "/.", 
     RowBox[{"DispatchPermToRInvRules", "[", "case", "]"}]}], "/.", 
    RowBox[{"RInv", "\[Rule]", 
     RowBox[{"RInv", "[", "metric", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermToInv", "[", 
    RowBox[{
     RowBox[{"RPerm", "[", "metric_", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"case_", ",", "1"}], "}"}], ",", "perm_"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"perm", "/.", 
     RowBox[{"DispatchPermToDualRInvRules", "[", "case", "]"}]}], "/.", 
    RowBox[{"DualRInv", "\[Rule]", 
     RowBox[{"DualRInv", "[", "metric", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermToInv", "[", 
    RowBox[{
     RowBox[{"WPerm", "[", "metric_", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"case_", ",", "0"}], "}"}], ",", "perm_"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"perm", "/.", 
     RowBox[{"DispatchPermToRInvRules", "[", "case", "]"}]}], "/.", 
    RowBox[{"RInv", "\[Rule]", 
     RowBox[{"WInv", "[", "metric", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PermToInv", "[", 
    RowBox[{
     RowBox[{"WPerm", "[", "metric_", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"case_", ",", "1"}], "}"}], ",", "perm_"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"perm", "/.", 
     RowBox[{"DispatchPermToDualRInvRules", "[", "case", "]"}]}], "/.", 
    RowBox[{"DualRInv", "\[Rule]", 
     RowBox[{"DualWInv", "[", "metric", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PermToInv", "[", "expr_", "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"perm", ":", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"RPerm", "|", "WPerm"}], ")"}], "[", "_", "]"}], "[", "__", 
       "]"}]}], "\[RuleDelayed]", 
     RowBox[{"PermToInv", "[", "perm", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PermToInv", ",", "1"}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"37768906-5527-4181-a758-ae248576ca31"]
}, Closed]],

Cell[CellGroupData[{

Cell["RiemannToInv", \
"Subsection",ExpressionUUID->"3e5d45d7-a8ca-44f8-9f1c-4de62e5df6ac"],

Cell["\<\
Main transformation function. It is just a combination of RiemannToPerm and \
PermToInv:\
\>", "Text",ExpressionUUID->"1cbe41ce-8fa6-43f9-a162-2a3e87acd817"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RiemannToInv", "[", "expr_", "]"}], ":=", 
   RowBox[{"RiemannToInv", "[", 
    RowBox[{"expr", ",", "$Metrics"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannToInv", "[", 
    RowBox[{"expr_", ",", "metrics_List"}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{"RiemannToInv", ",", "expr", ",", "metrics"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannToInv", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"metric_Symbol", "?", "MetricQ"}]}], "]"}], ":=", 
   RowBox[{"PermToInv", "[", 
    RowBox[{"RiemannToPerm", "[", 
     RowBox[{"expr", ",", "metric"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannToInv", "[", 
    RowBox[{"expr_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"RiemannToInv", "::", "unknown"}], 
       ",", "\"\<metric or list of metrics\>\"", ",", "x"}], "]"}], ";", 
     "expr"}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"RiemannToInv", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f0936c6f-9ded-4c3e-a182-f6017c7df218"]
}, Closed]],

Cell[CellGroupData[{

Cell["RiemannSimplify", \
"Subsection",ExpressionUUID->"8cc040f7-1afa-418a-8948-b5b5208202af"],

Cell["\<\
This function requires two additional arguments: the level of simplification \
(to be passed to InvSimplify) and the metric argument (to be passed to \
RiemannToInv):\
\>", "Text",ExpressionUUID->"9a63a83a-17c6-497d-8098-4f16d1337d21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "RiemannSimplify"}]], \
"Input",ExpressionUUID->"7e9948c6-226b-4216-9934-e0b821c40712"],

Cell[BoxData["\<\"RiemannSimplify[expr, level, cr, g] simplifies the Riemann \
scalars of metric g using relations up to the given level (see usage message \
for InvSimplify). With cr=True contracted Riemann tensors are replaced by \
Ricci tensors. If g is a list of metrics then the command is folded over the \
list. RiemannSimplify[expr] uses the defaults $InvSimplifyLevel, \
$CurvatureRelations and $Metrics, respectively. See usage messages for those \
global variables.\"\>"], "Print",
 CellTags->
  "Info3411227618-8018884",ExpressionUUID->"75447fb2-d72e-4c4b-92b9-\
3b3d5525eebb"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RiemannSimplify", "[", "expr_", "]"}], ":=", 
   RowBox[{"RiemannSimplify", "[", 
    RowBox[{
    "expr", ",", "$InvSimplifyLevel", ",", "$CurvatureRelations", ",", 
     "$Metrics"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannSimplify", "[", 
    RowBox[{"expr_", ",", "step_Integer"}], "]"}], ":=", 
   RowBox[{"RiemannSimplify", "[", 
    RowBox[{
    "expr", ",", "step", ",", "$CurvatureRelations", ",", "$Metrics"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannSimplify", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"cr", ":", 
      RowBox[{"(", 
       RowBox[{"True", "|", "False"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"RiemannSimplify", "[", 
    RowBox[{"expr", ",", "$InvSimplifyLevel", ",", "cr", ",", "$Metrics"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannSimplify", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"metric", ":", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"_Symbol", "?", "MetricQ"}], "|", 
        RowBox[{"{", 
         RowBox[{"__Symbol", "?", "MetricQ"}], "}"}]}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"RiemannSimplify", "[", 
    RowBox[{
    "expr", ",", "$InvSimplifyLevel", ",", "$CurvatureRelations", ",", 
     "metric"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannSimplify", "[", 
    RowBox[{"expr_", ",", "step_Integer", ",", 
     RowBox[{"cr", ":", 
      RowBox[{"(", 
       RowBox[{"True", "|", "False"}], ")"}]}], ",", "metric_"}], "]"}], ":=", 
   RowBox[{"InvToRiemann", "[", 
    RowBox[{
     RowBox[{"InvSimplify", "[", 
      RowBox[{
       RowBox[{"RiemannToInv", "[", 
        RowBox[{"expr", ",", "metric"}], "]"}], ",", "step"}], "]"}], ",", 
     "cr"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"RiemannSimplify", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7bf6064d-6f23-4568-9302-82029089f96e"]
}, Closed]],

Cell[CellGroupData[{

Cell["RToW and WToR", \
"Subsection",ExpressionUUID->"be638be9-3c97-4bd8-86e4-c6a5e01c552c"],

Cell["\<\
Transformation between Riemann and Weyl invariants. Internal function:\
\>", "Text",ExpressionUUID->"eb847b5d-f0cb-4e45-97f5-fe48cce52818"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RToWInv", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RInv", "[", "metric_", "]"}], "[", 
      RowBox[{"deg_", ",", "index_"}], "]"}], ",", "level_"}], "]"}], ":=", 
   RowBox[{"setdim", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RInv", "[", 
        RowBox[{"deg", ",", "index"}], "]"}], "/.", 
       RowBox[{"DispatchRToWRules", "[", 
        RowBox[{"level", ",", "deg"}], "]"}]}], "/.", 
      RowBox[{"WInv", "\[Rule]", 
       RowBox[{"WInv", "[", "metric", "]"}]}]}], ",", "metric"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RToWInv", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DualRInv", "[", "metric_", "]"}], "[", 
      RowBox[{"deg_", ",", "index_"}], "]"}], ",", "level_"}], "]"}], ":=", 
   RowBox[{"setdim", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"DualRInv", "[", 
        RowBox[{"deg", ",", "index"}], "]"}], "/.", 
       RowBox[{"DispatchRToWDualRules", "[", 
        RowBox[{"level", ",", "deg"}], "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DualWInv", "\[Rule]", 
         RowBox[{"DualWInv", "[", "metric", "]"}]}], ",", 
        RowBox[{"WInv", "\[Rule]", 
         RowBox[{"WInv", "[", "metric", "]"}]}]}], "}"}]}], ",", "metric"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WToRInv", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"WInv", "[", "metric_", "]"}], "[", 
      RowBox[{"deg_", ",", "index_"}], "]"}], ",", "level_"}], "]"}], ":=", 
   RowBox[{"setdim", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"WInv", "[", 
        RowBox[{"deg", ",", "index"}], "]"}], "/.", 
       RowBox[{"DispatchWToRRules", "[", 
        RowBox[{"level", ",", "deg"}], "]"}]}], "/.", 
      RowBox[{"RInv", "\[Rule]", 
       RowBox[{"RInv", "[", "metric", "]"}]}]}], ",", "metric"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"WToRInv", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DualWInv", "[", "metric_", "]"}], "[", 
      RowBox[{"deg_", ",", "index_"}], "]"}], ",", "level_"}], "]"}], ":=", 
   RowBox[{"setdim", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"DualWInv", "[", 
        RowBox[{"deg", ",", "index"}], "]"}], "/.", 
       RowBox[{"DispatchWToRDualRules", "[", 
        RowBox[{"level", ",", "deg"}], "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"DualRInv", "\[Rule]", 
         RowBox[{"DualRInv", "[", "metric", "]"}]}], ",", 
        RowBox[{"RInv", "\[Rule]", 
         RowBox[{"RInv", "[", "metric", "]"}]}]}], "}"}]}], ",", "metric"}], 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8aa42086-9c8f-4695-b7ca-0707184cf243"],

Cell["\<\
Set correct dimension (replacing the constant symbol dim in the stored rules):\
\>", "Text",ExpressionUUID->"94c69da3-6c5d-4e34-b970-caf5c994be8a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"setdim", "[", 
   RowBox[{"expr_", ",", "metric_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dimension", "=", 
      RowBox[{"DimOfVBundle", "@", 
       RowBox[{"VBundleOfMetric", "[", "metric", "]"}]}]}], "}"}], ",", 
    RowBox[{"expr", "/.", 
     RowBox[{"dim", "\[Rule]", "dimension"}]}]}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"10e477b3-77d0-44d5-ad9c-b2c271389514"],

Cell["User driver:", \
"Text",ExpressionUUID->"87907112-8cef-473d-82cf-a85b57e95fc8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "RToW"}]], "Input",ExpressionUUID->"3de9de14-1353-46f3-ba4b-7fb641e13819"],

Cell[BoxData["\<\"RToW[expr] transforms Riemann invariants into Weyl \
invariants in expression expr.\"\>"], "Print",
 CellTags->
  "Info3411227619-2362067",ExpressionUUID->"ac4b2c59-8b50-4545-b131-\
8ebd7bc4915b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "WToR"}]], "Input",ExpressionUUID->"d2e440d3-a89b-4dcb-98a5-2a9ef34f3458"],

Cell[BoxData["\<\"WToR[expr] transforms Weyl invariants into Riemann \
invariants in expression expr.\"\>"], "Print",
 CellTags->
  "Info3411227620-8562565",ExpressionUUID->"33a9fc58-551b-4b80-9e9b-\
1db3a8be01c5"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RToW", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"level_", ":", "2"}]}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"inv", ":", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"RInv", "|", "DualRInv"}], ")"}], "[", "_", "]"}], "[", 
       RowBox[{"_", ",", "_"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{"RToWInv", "[", 
      RowBox[{"inv", ",", "level"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WToR", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"level_", ":", "2"}]}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"inv", ":", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"WInv", "|", "DualWInv"}], ")"}], "[", "_", "]"}], "[", 
       RowBox[{"_", ",", "_"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{"WToRInv", "[", 
      RowBox[{"inv", ",", "level"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"RToW", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"WToR", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fca41647-d1ce-45a9-b205-d15abbff9754"]
}, Closed]],

Cell[CellGroupData[{

Cell["RandomRiemannMonomial", \
"Subsection",ExpressionUUID->"f6f5e71d-1843-42c1-8b6e-b15ec4eea6ee"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RandomRiemannMonomial", "[", "case_", "]"}], ":=", 
   RowBox[{"RandomRiemannMonomial", "[", 
    RowBox[{"case", ",", 
     RowBox[{"First", "[", "$Metrics", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RandomRiemannMonomial", "[", 
    RowBox[{"degree_Integer", ",", "metric_"}], "]"}], ":=", 
   RowBox[{"RandomRiemannMonomial", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "degree", "}"}]}], "]"}], ",", "metric"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RandomRiemannMonomial", "[", 
    RowBox[{"case_List", ",", "metric_"}], "]"}], ":=", 
   RowBox[{"PermToRiemann", "[", 
    RowBox[{
     RowBox[{"RPerm", "[", "metric", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"case", ",", "0"}], "}"}], ",", 
      RowBox[{"RandomPerm", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"4", 
          RowBox[{"Length", "@", "case"}]}], "+", 
         RowBox[{"Plus", "@@", "case"}]}], ",", "Images"}], "]"}]}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"RandomRiemannMonomial", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3700b4ca-4eeb-437a-830f-341614b2d400"]
}, Closed]],

Cell[CellGroupData[{

Cell["End package", \
"Subsection",ExpressionUUID->"73e67171-0f0b-4bc8-9b2b-10eba68ea4f8"],

Cell["End private part:", \
"Text",ExpressionUUID->"cc8a0ee0-154e-4685-88d9-bb1cae05c746"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"End", "[", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"efa8f055-41f5-435d-bd75-4c5b1210fb07"],

Cell[BoxData["\<\"xAct`Invar`Private`\"\>"], \
"Output",ExpressionUUID->"d11f1925-7300-4985-9bc4-7f947897c9ba"]
}, Open  ]],

Cell["\<\
We have defined these new names, and they are now all protected:\
\>", "Text",ExpressionUUID->"f1f0599d-6010-4687-a5ad-7ced2039b704"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "\"\<xAct`Invar`*\>\"", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"194210af-170c-4511-96a2-097f8b379bfe"],

Cell["\<\
The three user-global-variables and the constant-symbols dim, sigma must be \
unprotected:\
\>", "Text",ExpressionUUID->"9d4eb8f4-98ea-4f6a-ad63-2490123faa2d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", 
   RowBox[{
   "xAct`Invar`dim", ",", "xAct`Invar`sigma", ",", 
    "xAct`Invar`$InvSimplifyLevel", ",", "xAct`Invar`$CurvatureRelations", ",",
     "xAct`Invar`$ExpandedCommuteOrder12Q", ",", 
    "xAct`Invar`InvarDirectory"}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7c9c2b0c-c0f4-4f21-b373-969af9e6618e"],

Cell[BoxData[
 RowBox[{"EndPackage", "[", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d275ec29-741b-4d5f-bef5-9ad112a6eff3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", \
"Subsection",ExpressionUUID->"853526e6-9b9c-4b31-b119-89101fd344a3"],

Cell[CellGroupData[{

Cell["Setup", \
"Subsubsection",ExpressionUUID->"67f247d9-3353-484a-97cf-ca02566c4da5"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"General", "::", "spell"}], ",", 
   RowBox[{"General", "::", "spell1"}]}], 
  "]"}]], "Input",ExpressionUUID->"84b30b48-f1ad-4d96-9286-80c5ed440746"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"IndexRange", "[", 
    RowBox[{"a", ",", "q"}], "]"}], ",", "z"}], 
  "]"}]], "Input",ExpressionUUID->"2cd0b175-f6b0-4158-9bcf-0c5aa6ac4c87"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefManifold, ": Defining ", "manifold ", M, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"22920b71-6b94-475b-bdb5-6679e877cee2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", DefVBundle, ": Defining ", "vbundle ", TangentM, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"21afb805-18d9-4802-9e93-0be4ba64fafa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"metric", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}], ",", 
   RowBox[{"CurvatureRelations", "\[Rule]", "False"}]}], 
  "]"}]], "Input",ExpressionUUID->"0f03f8ac-653e-4aa7-b28d-80ca27bc436f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"metric", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "symmetric metric tensor ", 
   metric[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"f86ad2a2-6056-4421-953f-b67d61e586d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilonmetric", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "antisymmetric tensor ", 
   epsilonmetric[a, b, c, d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"137494d5-cf6d-415b-aedd-a7476a35fcd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefCovD, ": Defining ", "covariant derivative ", 
   CD[-a], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"19670e1f-ddb8-4abc-a9d9-2ee20299c7b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "vanishing torsion tensor ", 
   TorsionCD[a, -b, -c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"532188cf-6195-43cd-a696-72d85aba4d36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", DefTensor, ": Defining ", "symmetric Christoffel tensor ", 
   ChristoffelCD[a, -b, -c], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"37bae02f-63ef-4796-9385-d8e1a70b4148"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "Riemann tensor ", 
   RiemannCD[-a, -b, -c, -d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"631d472e-e96d-411e-87c3-f41a978bdd86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   RicciCD[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"16d76e06-3536-489c-b576-b65b6aa23c55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "Ricci scalar ", 
   RicciScalarCD[], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"1dee7572-ab27-4b3e-a788-8b729c472677"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Einstein tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "Einstein tensor ", 
   EinsteinCD[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"daf2a01b-fa08-4a71-9bb6-3acde4db99d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "Weyl tensor ", 
   WeylCD[-a, -b, -c, -d], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"f5344361-cee9-426c-a0c6-f9901585f04b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Rules \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}], 
   "\[InvisibleSpace]", "\<\" have been declared as DownValues for \"\>", "\[InvisibleSpace]",
    "WeylCD", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["   Rules ", 
   Shallow[{1, 2, 3, 4, 5, 6, 7, 8}], 
   " have been declared as DownValues for ", WeylCD, "."],
  Editable->
   False]], "Print",ExpressionUUID->"08e79fef-5f0c-4027-9a8c-acd7ec61aefb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"TFRicci tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", DefTensor, ": Defining ", "TFRicci tensor ", 
   TFRicciCD[-a, -b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"c54b94f3-05ba-4aec-bec7-4f2373d2e695"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"   Rules \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" have been declared as DownValues for \"\>", "\[InvisibleSpace]",
    "TFRicciCD", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["   Rules ", 
   Shallow[{1, 2}], " have been declared as DownValues for ", TFRicciCD, "."],
  
  Editable->
   False]], "Print",ExpressionUUID->"d938245f-05f4-4296-bd82-53095205d151"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"acd0a0ae-804b-47bc-9cab-3fddc836440a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"303fa328-6633-46e3-9266-caeb601fc585"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"2afc81cf-dbcd-46e3-b432-1bfcadd04e4a"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RiemannCD", "]"}], "^=", "\"\<R\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RicciCD", "]"}], "^=", "\"\<R\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RicciScalarCD", "]"}], "^=", "\"\<R\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "epsilonmetric", "]"}], 
   "^=", "\"\<\[Epsilon]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "metric", "]"}], "^=", "\"\<g\>\""}], 
  ";"}]}], "Input",ExpressionUUID->"22069690-758b-474d-b8af-60b8b625a426"]
}, Closed]],

Cell[CellGroupData[{

Cell["Special cases", \
"Subsubsection",ExpressionUUID->"0509b440-be71-4877-bbf4-dbb671d2211b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", 
  RowBox[{"RicciScalarCD", "[", "]"}], 
  "]"}]], "Input",ExpressionUUID->"bdf31b36-7c1a-4fbf-9150-0d670cc59088"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"7de3a0ba-c0f9-4ac8-b1ea-7fb14f278763"],

Cell[BoxData[
 SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"]], \
"Output",ExpressionUUID->"f09a1611-ff44-4fd1-a81d-e38d34274d32"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", 
  RowBox[{
   RowBox[{"-", "3"}], 
   RowBox[{"RicciScalarCD", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"73f1dc96-723b-4229-b868-48145f59c0ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", 
  SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"]}]], \
"Output",ExpressionUUID->"f3d0f8ec-26e3-472f-b4e4-2eb0db25f8a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", 
  RowBox[{
   RowBox[{"-", "3"}], 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "a", ",", "b"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"bc925855-0c06-41a6-942a-21b4009bd5f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", 
  SubscriptBox["\<\"I\"\>", "\<\"0,1\"\>"]}]], \
"Output",ExpressionUUID->"ba5165b3-d4d5-44d0-9805-04bee33d102f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", 
  RowBox[{
   RowBox[{"-", "3"}], 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{"RicciScalarCD", "[", "]"}]}], 
   RowBox[{
    RowBox[{"CD", "[", "a", "]"}], "@", 
    RowBox[{"RicciScalarCD", "[", "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"bdd9af64-5307-4750-8339-5892de789585"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"a754784a-38a1-4c8d-b6f4-af1062acb27c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], " ", 
  SubscriptBox["\<\"I\"\>", "\<\"11,1\"\>"]}]], \
"Output",ExpressionUUID->"9453a7aa-410b-417e-be3f-3ed566bf0212"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", 
  RowBox[{
   RowBox[{"-", "3"}], 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{"b", ",", 
      RowBox[{"-", "c"}], ",", "c", ",", 
      RowBox[{"-", "b"}]}], "]"}]}], 
   RowBox[{
    RowBox[{"CD", "[", "a", "]"}], "@", 
    RowBox[{"RicciScalarCD", "[", "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"dfae0a25-5ec7-4f97-a956-74eba5462c92"],

Cell[BoxData[
 RowBox[{"3", " ", 
  SubscriptBox["\<\"I\"\>", "\<\"11,1\"\>"]}]], \
"Output",ExpressionUUID->"ef0ef4d5-6200-443c-8faa-6bd90faa66ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", 
  RowBox[{
   RowBox[{"-", "3"}], 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{"b", ",", 
      RowBox[{"-", "c"}], ",", "c", ",", 
      RowBox[{"-", "b"}]}], "]"}]}], 
   RowBox[{
    RowBox[{"CD", "[", "a", "]"}], "@", 
    RowBox[{"RicciCD", "[", 
     RowBox[{"d", ",", 
      RowBox[{"-", "d"}]}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"c590dc06-4bbb-4f22-915d-bac8d07a6bcc"],

Cell[BoxData[
 RowBox[{"3", " ", 
  SubscriptBox["\<\"I\"\>", "\<\"11,1\"\>"]}]], \
"Output",ExpressionUUID->"9a252d5d-6819-4a7a-ac56-c55d6941f5b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", 
  RowBox[{
   RowBox[{"-", "3"}], 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{"b", ",", 
      RowBox[{"-", "c"}], ",", "c", ",", 
      RowBox[{"-", "b"}]}], "]"}]}], 
   RowBox[{
    RowBox[{"CD", "[", "a", "]"}], "@", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "e"}], ",", "d", ",", "e"}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"86f7a33c-01e9-425f-8b79-702aae7eac8d"],

Cell[BoxData[
 RowBox[{"3", " ", 
  SubscriptBox["\<\"I\"\>", "\<\"11,1\"\>"]}]], \
"Output",ExpressionUUID->"43d53677-a287-4b22-8d93-20cd698810db"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Check of RiemannToInv", \
"Subsubsection",ExpressionUUID->"51c7a2d9-72cb-4e9f-9063-078db8820ed2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"checkperms", "[", "case_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"riemanns", ",", "invs"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"riemanns", "=", 
      RowBox[{"xAct`Invar`Private`ReadInvarPerms", "[", 
       RowBox[{
        RowBox[{"xAct`Invar`Private`$DataBaseDir", "<>", "\"\<0/\>\"", "<>", 
         RowBox[{"xAct`Invar`Private`filename", "[", 
          RowBox[{"0", ",", "case"}], "]"}]}], ",", "\"\<Mathematica\>\""}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"AbsoluteTiming", "[", 
       RowBox[{"Length", "[", 
        RowBox[{"invs", "=", 
         RowBox[{"RiemannToInv", "/@", "riemanns"}]}], "]"}], "]"}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"invs", "/.", 
        RowBox[{
         RowBox[{"RInv", "[", "metric", "]"}], "\[Rule]", "RInv"}]}], ")"}], "===", 
      RowBox[{"RInvs", "[", 
       RowBox[{"1", ",", "case"}], "]"}]}]}]}], 
   "]"}]}]], "Input",ExpressionUUID->"5ef04cc1-be42-42c0-bc55-85a3f3ad2ad2"],

Cell["First diagonal:", \
"Text",ExpressionUUID->"8af7a812-7814-4308-b260-a07b4e40c8c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "0", "}"}], 
  "]"}]], "Input",ExpressionUUID->"770ae4f7-c993-4f71-afdd-f19700c6410d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.004991`4.149732563362096", " ", "Second"}], ",", "1"}], 
  "}"}]], "Print",ExpressionUUID->"7e6d1b91-221a-4668-ad14-1eee80ef12dc"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"bb532ab3-8e71-4b80-b41e-5113fe51e9c7"]
}, Open  ]],

Cell["Second diagonal:", \
"Text",ExpressionUUID->"b7bcb2e5-abcc-4107-b4bf-c44bd084e2dd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"d37196f9-fac4-48ff-88b0-685a3e7fd806"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"26d9db02-97dc-4d19-8270-79b328fc9d6a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.131295`5.569793181019146", " ", "Second"}], ",", "3"}], 
  "}"}]], "Print",ExpressionUUID->"325dd9df-12ab-40ec-b781-2558d95ece18"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"97539a04-b62f-491c-b520-34cb9fc6f8ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "2", "}"}], 
  "]"}]], "Input",ExpressionUUID->"3f3b7314-3956-45b0-9099-1390a6919303"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"1b34a1c6-9a11-475a-83bc-74352df5052d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.117452`5.521405409940106", " ", "Second"}], ",", "2"}], 
  "}"}]], "Print",ExpressionUUID->"0a3e9e58-d261-4da0-9576-b31e0727bb2f"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"aad4c0fd-06ba-4c3b-803d-1eb11ab8ded8"]
}, Open  ]],

Cell["Third diagonal:", \
"Text",ExpressionUUID->"44c494f6-70a5-464b-9b6e-5a995fcaa263"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"c3bee351-764c-4b27-9779-de692f3f6db2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.154208`5.639651898117087", " ", "Second"}], ",", "9"}], 
  "}"}]], "Print",ExpressionUUID->"7e663096-31f8-411e-9f15-7ccfd1a3d44c"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"2a1184db-f1ad-44bd-aa88-3267544a8265"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"e2719d96-b56c-439e-93cb-21280099774d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"56957b0b-8948-43e4-8081-60c41cc1add7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.276592`5.893384608148153", " ", "Second"}], ",", "12"}], 
  "}"}]], "Print",ExpressionUUID->"d5fa491c-8e5e-46c5-bd8a-a7298849ebbf"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"8b2f0f0a-6d45-4629-bb9a-bbef42f16d08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"dcd5828f-e59a-4f44-9a11-77f7113ae046"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.182808`5.713540190800961", " ", "Second"}], ",", "12"}], 
  "}"}]], "Print",ExpressionUUID->"301b325e-8c12-419f-86c9-dfa2d2ff6081"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"749d4cec-6d35-44ac-9a96-56fe6c19914e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "4", "}"}], 
  "]"}]], "Input",ExpressionUUID->"ed29c5bc-9ccb-4271-aa9c-c847d2906edc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"2f116b3e-cc11-4030-a38b-11f2a7c553d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.241806`5.835012066425038", " ", "Second"}], ",", "12"}], 
  "}"}]], "Print",ExpressionUUID->"d9abac8c-aa43-4225-bea3-fb895342821c"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e4a9131b-dff6-40e5-b769-f73bb03f806b"]
}, Open  ]],

Cell["Fourth diagonal:", \
"Text",ExpressionUUID->"6599c26f-b5a9-4e8a-825b-6aaaf19e0e19"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"4f64d16f-6b96-4de8-a906-5fc8a7db7b8e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"60380e3b-e6cb-4469-a52f-b2eded8da287"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.005408`6.453887330069382", " ", "Second"}], ",", "38"}], 
  "}"}]], "Print",ExpressionUUID->"5ef5a876-ca4c-4df3-9d0f-58e95092c3ba"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"0ac26f7e-2991-43a0-a239-401b6ecce43f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"b3be47c4-fc6d-4cd5-a94a-93145d9eb531"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6fc98282-664a-49d8-b978-440a9dbd21dc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.057613`6.764908688621534", " ", "Second"}], ",", "99"}], 
  "}"}]], "Print",ExpressionUUID->"52569ca8-73cd-4712-8c9a-a7385907c035"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"b5a118a3-f31b-47ad-ac6b-ab419ec58e37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"753fb6ce-fdbd-457a-9d6a-d81a5b07788b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"f73beae3-732a-4622-84da-f85c58ecc596"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.553331`6.858652111533881", " ", "Second"}], ",", "125"}], 
  "}"}]], "Print",ExpressionUUID->"9cf53e49-f4d4-4ffe-a9c3-fbc908603b88"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e67a787d-ff32-467d-a54e-b424cc7aead0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"82771643-f040-4485-bd8f-64d3d2a30094"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"fc7a6eb2-de63-483a-a216-404fcf4d542f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.349168`6.822459069815508", " ", "Second"}], ",", "126"}], 
  "}"}]], "Print",ExpressionUUID->"c259e669-b941-493b-a8da-c5a940b6a5e7"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"1ec2f024-45c8-48c5-83a7-74365a1ebb43"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"d6bb9a11-5be7-47aa-8c83-50eb3b427d2b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"19e22093-05b4-4b46-91e9-9f3f387fa576"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.498517`6.849227302239991", " ", "Second"}], ",", "138"}], 
  "}"}]], "Print",ExpressionUUID->"9a1373e4-72df-4436-bbd3-ef83d65b8846"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"65e29125-b1d2-4e07-86cd-f0815c327e84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"a4e11bf3-7b2c-4a86-8671-401b3a582b63"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"15d4bf66-9940-430b-acf2-6e78f04c857b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.690113`6.679460735763983", " ", "Second"}], ",", "86"}], 
  "}"}]], "Print",ExpressionUUID->"a5ef3249-a360-4c75-9476-2ac3d8540222"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"27753bc9-9e78-475c-bf9d-a73073a4e3fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "6", "}"}], 
  "]"}]], "Input",ExpressionUUID->"d4deca85-09ed-4d3e-ae56-45b81fe959a3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"df1e229f-d7c0-4684-a456-05b5e60cb20b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.708278`6.6841035413720835", " ", "Second"}], ",", "105"}], 
  "}"}]], "Print",ExpressionUUID->"56df37b3-603a-407e-9d92-1aedaaa3b862"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"de10a610-1e06-49d5-b01d-2c02e469ec17"]
}, Open  ]],

Cell["Fifth diagonal:", \
"Text",ExpressionUUID->"e7b0bba8-40f5-4d1e-b18c-ed7f4bae2568"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"3932c46c-4637-4aef-bb88-522354c01bb4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"223c96a4-6d09-4bca-96bc-3702bd591ea9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"6.398637`7.257632466476654", " ", "Second"}], ",", "204"}], 
  "}"}]], "Print",ExpressionUUID->"ec61bceb-6d65-40e0-8d1c-b8b9fc13923f"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e5d31b61-d0e2-4adc-886b-810d28e7517e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"08c51226-4584-401e-a4b1-e1a593af91b9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ea9fc33a-3ddf-4f5a-ab1b-90e567b24f3f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"29.779126`7.925456940809133", " ", "Second"}], ",", "1020"}], 
  "}"}]], "Print",ExpressionUUID->"1d7a8412-ea85-4ab3-ac1f-595d57b835de"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"4b0e0d47-c59f-4abc-83bb-8b89f7336f62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"8b233380-74ad-4350-9a10-e99690236da0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"4a78fed9-9754-434e-aac9-804462d750ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"52.523769`8.171900876129946", " ", "Second"}], ",", "1749"}], 
  "}"}]], "Print",ExpressionUUID->"049d25bf-d6d6-431a-a4d0-95677e1bf8c0"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"5d0a0925-5af0-4d7b-a8d7-39094e3a0fac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"66644d81-f97d-4a9e-b43e-484df4635d31"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d112d1ad-1d9e-4d9d-99b7-132ace7f3dfd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"40.320767`8.057073778359515", " ", "Second"}], ",", "1473"}], 
  "}"}]], "Print",ExpressionUUID->"a29e0d68-ae04-487c-afa4-2bc77b4d8dfc"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"be0063bf-9a94-4ac0-950c-e18742898701"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"ad4e6ac5-6596-427c-b02e-2d812f62918e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"78.180342`8.344642559418082", " ", "Second"}], ",", "3099"}], 
  "}"}]], "Print",ExpressionUUID->"67544dd8-4c74-4af9-b590-dc2bf12ae2b4"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"39aa3970-7f6b-4b4f-a8b8-14406acaf092"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"53696b31-8726-4665-aa79-6ca7b80d35d3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6b3504f2-a04e-4fbd-97b9-0d39a2326424"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"42.5302`8.080242418502307", " ", "Second"}], ",", "1622"}], 
  "}"}]], "Print",ExpressionUUID->"4d81f3f3-64b6-408e-8a23-25c4ad18420a"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"decf9207-57ad-455c-89f6-9e15c0c2f5e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"c4bfca4b-af11-44ea-aece-298d0ddfa7d7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"9540020d-d4f5-4304-b07d-29d1ea17051e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"41.360479`8.068130553220458", " ", "Second"}], ",", "1617"}], 
  "}"}]], "Print",ExpressionUUID->"734d7279-74fe-4043-a69f-656e5a20574e"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"1995b1e1-485b-4f00-9cac-9f8067e7f2b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "6"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"f86786c5-24c0-41d0-9392-eb4923ae2f0e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"649f5eed-d115-4347-8211-0868027cf7dc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"41.053926`8.064899688656835", " ", "Second"}], ",", "1665"}], 
  "}"}]], "Print",ExpressionUUID->"9bda5086-8529-46f0-964b-fdc7e5244969"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"c2e6f469-57d0-44c3-a147-eadc4b2c9910"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"3a883362-ae97-43bc-b739-d27b76a18a64"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"7db41437-3697-4992-af5b-474565da46bf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"42.440843`8.079328995177024", " ", "Second"}], ",", "1770"}], 
  "}"}]], "Print",ExpressionUUID->"9d4f93b6-fa17-4a0a-9569-f54cc44fcf3e"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"bb28b84f-31f1-4a8e-bfd4-dbaf11ebfecf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"2a7e2603-fe1c-4720-9a4e-7acb16037a79"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"7b2a8e78-32c7-4290-84d2-4a7c46fd1c62"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"40.571427`8.05976527670749", " ", "Second"}], ",", "1746"}], 
  "}"}]], "Print",ExpressionUUID->"9b441921-4f00-4452-a732-3e939883cfc2"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"12821387-538a-41be-bdfc-59281d3036fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"cc6fbaec-86fb-48ba-b16e-6231f10bcb26"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"ac248d41-d48c-49e2-bb3d-02ecf8d6fdc1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"23.348762`7.819808851810434", " ", "Second"}], ",", "962"}], 
  "}"}]], "Print",ExpressionUUID->"f1819a2d-a254-403a-ae9f-ac73c524f4dc"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e10d68e5-b457-475f-9917-2cad838d60eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "8", "}"}], 
  "]"}]], "Input",ExpressionUUID->"e499d895-8cfa-47a1-a7f5-d11fe642f168"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"a478b51f-656a-4edd-af5b-f4acf9269cac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"24.544413`7.841497643543219", " ", "Second"}], ",", "1155"}], 
  "}"}]], "Print",ExpressionUUID->"82f1a612-74ed-4b26-a821-a2b82d44c75c"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"d79c3bfe-5167-4509-90cb-9eea5236d6fa"]
}, Open  ]],

Cell["Sixth diagonal:", \
"Text",ExpressionUUID->"8d5c3b98-0059-416e-8ad3-e89704be84f0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"fa9b18fe-f14b-4b49-a4b8-65bcf5713023"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"4854f0dd-bdb4-4291-b6f6-49835c152ff9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"67.705513`8.28216902655332", " ", "Second"}], ",", "1613"}], 
  "}"}]], "Print",ExpressionUUID->"51717194-1462-43d2-bbc6-8698ccf0aee4"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"17a017c9-6dab-40e8-9362-12fe25924d24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"650c5e6d-7575-422b-adce-0190a5d567ff"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"1b51052c-2cd1-45a9-867b-39309a47cdc9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"556.176796`9.196757859398849", " ", "Second"}], ",", "12722"}], 
  "}"}]], "Print",ExpressionUUID->"5c190ac6-07cd-47a3-b318-f992e916ae66"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"5552b689-3097-4c65-ae6a-d394744952e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"039d028c-2cad-4103-ab64-ebd05ec60bee"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"2469f5ae-574e-4ff2-a637-889dea4adca9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1500.317586`9.627728193383835", " ", "Second"}], ",", "27022"}], 
  "}"}]], "Print",ExpressionUUID->"2e2c7490-1784-4bbc-b30d-6b20b1f872c7"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"982059a7-05c7-4ad2-a5d4-632fe1ce92ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"b2b4fc05-c3d8-4d57-bf48-1242900cb76e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"f146a00d-f431-4076-a6e6-5578d51786b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"918.764127`9.414749023390652", " ", "Second"}], ",", "19617"}], 
  "}"}]], "Print",ExpressionUUID->"29f9d749-5624-4e07-b2ba-c2c0ccbadc8b"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"07ee06cf-cdae-4194-861b-d255fb708779"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"e8835431-c985-4801-9b04-82c8daf8d508"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"7814c45c-a2ec-4c35-89f9-36c97d119c42"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4288.280804`10.083828209461192", " ", "Second"}], ",", "60984"}], 
  "}"}]], "Print",ExpressionUUID->"25388db6-fca0-46c2-9d74-592210fbab6b"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"98ec1f93-de90-4629-88aa-b7bccd2393a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"21c59ff9-e197-4bde-9cfa-6a1e04db4f34"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"0214f194-59f0-43d6-94ab-5afb262d77d7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1641.026477`9.666660581692415", " ", "Second"}], ",", "30974"}], 
  "}"}]], "Print",ExpressionUUID->"211bb32e-f93e-4b2d-b6d2-bf9cf2f31566"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"923cc710-c12b-4b81-bf39-0436d747f7b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"9c68f2da-7f20-4daa-900e-491a6acb083a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"097b1d04-df93-401e-b827-66cf9cbb6c66"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4530.369857`10.107678652528072", " ", "Second"}], ",", "62465"}], 
  "}"}]], "Print",ExpressionUUID->"abfdcc04-c5ca-49f1-b017-80bba4b7f6cd"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"6d50ffcd-dc0f-49f7-ba42-e070ca6916c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"7a5d003b-c59e-4546-abc8-7eb1e99d4c81"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"a9515c89-cd69-49dd-a12e-77acdb073079"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"215.617927`8.785229859813604", " ", "Second"}], ",", "5606"}], 
  "}"}]], "Print",ExpressionUUID->"218bffb5-a09d-44b5-80b9-c8d32ef3e305"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"5c068c29-f481-4d6b-8ccd-da3b482b4cb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "6"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"ac81ba6e-b8bc-4a98-a7bb-e8bdb336b1a7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"adbc59fb-1d66-4597-9b1c-0625bc93cb59"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1247.736608`9.54766791076151", " ", "Second"}], ",", "25590"}], 
  "}"}]], "Print",ExpressionUUID->"707ca7f9-3dd6-4f7e-a535-ae1ba4c6296a"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e8529bcb-687e-4d18-aba7-34e35ce58278"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "5"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"621a2757-b34d-4827-b44c-ca70b30d33d5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"a6421e09-defb-493c-a623-d06d3465681b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3391.849248`9.98198153512999", " ", "Second"}], ",", "53160"}], 
  "}"}]], "Print",ExpressionUUID->"fa128a18-35b9-419b-9196-6887feb40570"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"a6ca3dac-0bd3-4f5b-9010-5ef4d957ad22"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"1756efa8-7b2c-4616-b4a9-cde2565f7432"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"a8b04bfa-4deb-415c-a914-2d59b8b2ca18"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3397.808827`9.982743933739831", " ", "Second"}], ",", "52764"}], 
  "}"}]], "Print",ExpressionUUID->"d34a283c-4a0a-470e-8925-9e18c42245c1"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"1422de5b-6cff-4441-8389-9589107e1739"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"da3e52c9-2320-4a74-b2ca-01959c61ccf3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"c639df06-8ab4-4caa-890d-3827c311fbc9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1365.574839`9.586860499710355", " ", "Second"}], ",", "27396"}], 
  "}"}]], "Print",ExpressionUUID->"77aa08fa-18a1-4617-8250-ce665e7281ff"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"cd54a33f-648b-42fd-864d-68b71f910c7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "3", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"22e14cbb-bf66-4075-adad-db72529923d2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"092c6266-652c-4c2e-ae67-ebb2749a834e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1295.664256`9.564037471375517", " ", "Second"}], ",", "27024"}], 
  "}"}]], "Print",ExpressionUUID->"84d21959-7ce5-4cb8-a025-ed9f4b85b9de"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"f72d60c6-b9bd-4f51-ba70-97a5b19b62a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"fd3e8143-0a94-4df7-8189-9c8bb9fc6bc4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"49bad4a3-21a7-484d-bdbf-34c660140a8f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3433.395039`9.987268768779453", " ", "Second"}], ",", "54654"}], 
  "}"}]], "Print",ExpressionUUID->"4b8735ff-a908-4fb9-87bb-d17873d62fc8"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"b8de8321-be3c-4085-9968-4a07b1ab9bce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"1400b154-e99e-44f9-bb16-cfd8283cf7b7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"3af50f97-839b-446f-88e0-acc3d82edd05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"325.672535`8.964326128171093", " ", "Second"}], ",", "9104"}], 
  "}"}]], "Print",ExpressionUUID->"4137f475-202a-4721-9b3b-20e8eb098839"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"c0aa475a-1e18-4b49-a580-66c4f125b566"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "8"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"a62e6456-6e2a-44ea-9754-0bd7ca7dcf31"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"5e78f648-61cc-4595-8ae9-3a06dcc7cc7a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1173.992029`9.521210141708194", " ", "Second"}], ",", "25515"}], 
  "}"}]], "Print",ExpressionUUID->"a963a7c2-247a-4a73-9c68-a0374ba63aaa"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"5bb79a0b-7f67-4bf9-9f2f-97932568f3e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "7"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"97751815-2aa3-4795-940c-f4b6852dc847"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 7}],
  Editable->
   False]], "Print",ExpressionUUID->"86d2a143-1e34-4682-8248-fc58bc38cb74"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1038.752264`9.468056976850493", " ", "Second"}], ",", "26670"}], 
  "}"}]], "Print",ExpressionUUID->"27c62b7f-ef19-409d-a9c6-a74706c31ef8"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"a686f63f-b154-40f0-891b-c01da6dd32ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "6"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"c2d9d6c8-a6ac-48f2-a1fa-79db062e9c25"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"eb35fb96-f153-4da0-8df7-1252969d0f99"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1039.274087`9.4682750923273", " ", "Second"}], ",", "26460"}], 
  "}"}]], "Print",ExpressionUUID->"a8c35d64-9e18-4559-893f-76527ba17dd5"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"599ccb1f-3c1f-4720-a03e-43ae1e20f690"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "5"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"342ee8d4-c750-4fd0-9187-a388b01f4e5d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {3, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"b1afe434-edfe-4296-8c1c-f71ec794b9f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1044.221858`9.470337773262674", " ", "Second"}], ",", "26670"}], 
  "}"}]], "Print",ExpressionUUID->"d8442dcf-3959-4238-999a-b21df618d92c"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"217bf670-49be-410e-b1f0-8a166b70ca62"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"2f0d9cbe-fe09-40fd-ae63-1bcb7ee92eca"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {4, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"d04aeb07-16d1-430d-9902-5c5191cdc580"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"474.894716`9.128142330850553", " ", "Second"}], ",", "13607"}], 
  "}"}]], "Print",ExpressionUUID->"8e7039e6-a2a5-4966-83a7-4b5b23ce5fe1"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"7abf70a4-513a-4fe1-9ac7-0a107ee6b15c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "10", "}"}], 
  "]"}]], "Input",ExpressionUUID->"aba85a14-bd08-412d-b0d9-ddb9954cc282"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "10", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {10}],
  Editable->
   False]], "Print",ExpressionUUID->"70fcbac1-f0ff-43a2-8d26-0cf7f3835753"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"526.007396`9.172536844150487", " ", "Second"}], ",", "15120"}], 
  "}"}]], "Print",ExpressionUUID->"4b2a23a5-b283-4f56-a7a9-6889735ad006"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"ab3f429f-91fb-4398-9133-27ec5bc897c3"]
}, Open  ]],

Cell["Seventh diagonal:", \
"Text",ExpressionUUID->"bc162c34-e7b2-42ba-be14-b36f1037c48c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
   "}"}], "]"}]], \
"Input",ExpressionUUID->"da08b200-0c0c-4383-ac83-eed8ecb9213e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1012.036507`9.456741172504382", " ", "Second"}], ",", "16532"}], 
  "}"}]], "Print",ExpressionUUID->"81aa493b-7046-41be-ae9b-a3dc94214fec"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"3ea084cd-91aa-4fb5-b868-0705317ad489"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Check of InvToRiemann", \
"Subsubsection",ExpressionUUID->"e128adc7-e446-4727-8ee9-f190f68d413a"],

Cell[CellGroupData[{

Cell[BoxData["$CurvatureRelations"], \
"Input",ExpressionUUID->"1262fb55-65d7-4f7b-884b-b344877fc9ba"],

Cell[BoxData["False"], \
"Output",ExpressionUUID->"b971a030-d3d4-4211-8e1f-a0b32966edca"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"checkperms", "[", "case_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"riemanns", ",", "frominvs"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"riemanns", "=", 
      RowBox[{"Scalar", "/@", 
       RowBox[{"xAct`Invar`Private`ReadInvarPerms", "[", 
        RowBox[{
         RowBox[{
         "xAct`Invar`Private`$DataBaseDir", "<>", "\"\<0/\>\"", "<>", 
          RowBox[{"xAct`Invar`Private`filename", "[", 
           RowBox[{"0", ",", "case"}], "]"}]}], ",", "\"\<Mathematica\>\""}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"AbsoluteTiming", "[", 
       RowBox[{"Length", "[", 
        RowBox[{"frominvs", "=", 
         RowBox[{"InvToRiemann", "/@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"RInvs", "[", 
             RowBox[{"1", ",", "case"}], "]"}], "/.", 
            RowBox[{"RInv", "\[Rule]", 
             RowBox[{"RInv", "[", "metric", "]"}]}]}], ")"}]}]}], "]"}], 
       "]"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"riemanns", "===", "frominvs"}]}]}], 
   "]"}]}]], "Input",ExpressionUUID->"fd6d803b-e9fe-44b0-b992-fed2b89bb832"],

Cell["First diagonal:", \
"Text",ExpressionUUID->"1a8cd2f4-0ad3-49f2-8bbd-95fc6b7da652"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "0", "}"}], 
  "]"}]], "Input",ExpressionUUID->"ee860483-020f-4423-96a0-e7fac61bb5c5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"f36906c9-4989-444e-a66d-64eb435a0815"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.046226`5.116431308455025", " ", "Second"}], ",", "1"}], 
  "}"}]], "Print",ExpressionUUID->"905dac3c-a38b-453b-97c3-c6a4f0f5f50d"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"340a4e94-5f4b-48d8-a0f4-9d77a37fea2f"]
}, Open  ]],

Cell["Second diagonal:", \
"Text",ExpressionUUID->"710baadb-66e6-47d3-989f-ad945ec66a4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"11809711-b822-4b2a-a701-422f9b9e5fff"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"69d36481-9ae7-48bb-9d5a-4f3665c23781"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.038161`5.033164740261565", " ", "Second"}], ",", "3"}], 
  "}"}]], "Print",ExpressionUUID->"e21e7d11-e872-4e34-a99c-3bbd4a4ecf5d"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"aa811f9d-6231-47a4-b006-cf0131c07354"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "2", "}"}], 
  "]"}]], "Input",ExpressionUUID->"210e82d9-896b-4680-87ba-7ab6df028f25"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"8344874b-40ca-4cc1-bc5c-8f708e22def1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.041459`5.0691638161037975", " ", "Second"}], ",", "2"}], 
  "}"}]], "Print",ExpressionUUID->"e3e55984-2c82-4c71-90dc-e57e04d01166"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"870ddc48-df2a-4e99-a1c9-19e5f8fb9f08"]
}, Open  ]],

Cell["Third diagonal:", \
"Text",ExpressionUUID->"a116e758-1628-40fe-ae18-04b2e5782572"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"3da6269b-baa0-418d-ac49-c70d4157d40f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.006556`4.268183938394429", " ", "Second"}], ",", "9"}], 
  "}"}]], "Print",ExpressionUUID->"dd3a06e6-79b7-4264-88b9-83f2590c1fca"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"b0cd3979-5731-4842-9ef6-64d2c31344f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"0c78453a-928b-45bf-ad99-5a41a536d885"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"80a032af-b811-464d-a98b-beacd959caee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.041422`5.068776057826317", " ", "Second"}], ",", "12"}], 
  "}"}]], "Print",ExpressionUUID->"a911917c-b162-4186-8310-da6c0cd1ffb9"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"383214d2-eddc-45ea-8ee4-ede49cfb46f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"211bf016-7f73-4003-bb5d-bb7ca979e7c8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"a267950c-54ab-4ab7-acbc-9c776fe74848"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.038412`5.036011913687731", " ", "Second"}], ",", "12"}], 
  "}"}]], "Print",ExpressionUUID->"c0356349-8c79-46ae-9eba-78a378a1178c"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e3bf566b-0b7c-4867-a440-fec31149bce3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "4", "}"}], 
  "]"}]], "Input",ExpressionUUID->"50b032c9-77fc-4ffb-b6d9-91cc7eaeb67e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "4", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {4}],
  Editable->
   False]], "Print",ExpressionUUID->"51f46e21-c73e-4794-bf81-dca103636e59"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.04161`5.070742709288924", " ", "Second"}], ",", "12"}], 
  "}"}]], "Print",ExpressionUUID->"af313950-8673-4f87-88b2-bb53ce6ed3e1"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e069e8cc-48b7-4792-b120-cad860b64ae6"]
}, Open  ]],

Cell["Fourth diagonal:", \
"Text",ExpressionUUID->"7f63e5f2-928f-4234-a4ea-9bb811f055aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"b01513fd-0fcb-4cd7-be09-49ec15927a7e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"a544c55f-4533-4785-ac7f-871d38520e60"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.062751`5.249165644621502", " ", "Second"}], ",", "38"}], 
  "}"}]], "Print",ExpressionUUID->"3da68c8e-48a9-4233-b167-8206631eecfd"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"1cf6da4c-ee52-4374-870e-cdfcd56b100a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"2666a73a-caba-4ce3-a0c6-bd7f66dfe14c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"be8096d4-a4ae-49e4-931c-009c7017a556"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.082681`5.368950714134532", " ", "Second"}], ",", "99"}], 
  "}"}]], "Print",ExpressionUUID->"f9d0dc13-9272-441c-aaa5-6b769b7af61c"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"506cb8a7-8ae8-4b23-929b-1c5aa05fd3b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"0747d7e1-099d-46e5-a1bf-87fabc7dfe0f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"70b99a66-bea7-47c2-9c80-eba78b7e62ce"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.1019`5.459719177502392", " ", "Second"}], ",", "125"}], 
  "}"}]], "Print",ExpressionUUID->"bfe49bfc-1ec2-4f98-b859-bbdec730eacd"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"a9039fbf-73cd-4f14-9f61-844a0e6afce1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"63fc00f3-4327-4e87-82d8-6f28b08b33ad"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"0b70bfbc-aa9f-4ed3-b931-c439f0b686c9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.089094`5.401393451128445", " ", "Second"}], ",", "126"}], 
  "}"}]], "Print",ExpressionUUID->"8080a2de-dbaa-465b-858a-f87fd3aaa7c4"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"acb6e804-ab88-4cc4-a1ce-e1b5bb0f6de3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"fa4cc7ac-d0af-44db-a126-20e35012947e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"53c2dea2-ff82-4f4b-9d78-2485d99cde90"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.092355`5.41700540614314", " ", "Second"}], ",", "138"}], 
  "}"}]], "Print",ExpressionUUID->"766b0563-425a-44a9-803a-f7b5b85036d4"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"ee56b18a-a32d-4016-b055-177b4a3cc688"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"2b41d599-7202-43e3-968b-fbd04734df97"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e62b9276-515f-4425-bb17-1faee0ca61c3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.070083`5.29715767763145", " ", "Second"}], ",", "86"}], 
  "}"}]], "Print",ExpressionUUID->"ba986bf2-9761-4855-b1c7-c1c7a040b8b0"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"85403f44-1e64-4f84-adfb-5f721bcb979c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "6", "}"}], 
  "]"}]], "Input",ExpressionUUID->"608e89fc-fa02-48f2-b36c-42a908cde783"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "6", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {6}],
  Editable->
   False]], "Print",ExpressionUUID->"77749359-d47d-444e-b3d9-ebed80929b93"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.074415`5.323205479587842", " ", "Second"}], ",", "105"}], 
  "}"}]], "Print",ExpressionUUID->"eb8a1b43-5b81-46d2-aabb-a06bab8c4861"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"eb24d92d-dd5e-4c17-bed9-18fe7258d7cc"]
}, Open  ]],

Cell["Fifth diagonal:", \
"Text",ExpressionUUID->"9399b2ba-2cea-4147-b8bd-bc0524197f93"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"db8368cd-d064-408c-b607-2661fd5b481c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"144d1556-5075-4750-818b-e0a8f3466f52"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.211114`5.776062027945935", " ", "Second"}], ",", "204"}], 
  "}"}]], "Print",ExpressionUUID->"2d1d3c6d-243a-4f1e-b85d-3f1f8e7933d5"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"2c5700e5-a19f-44d5-8602-c8b368a303f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"421cf150-574f-496f-bcbc-a91335e30521"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b1d30716-163d-4680-afbb-ff2a97a6df75"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.744608`6.323472691423454", " ", "Second"}], ",", "1020"}], 
  "}"}]], "Print",ExpressionUUID->"fda25452-c3c3-443b-973d-0a5b82093ffe"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"dc8349fe-3a5b-4d1e-8fa5-c68e37ab5cd1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"27f4a50d-ef04-4824-966e-6de739b9d73d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"d8f46913-2ac3-4101-a553-64e45225b254"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.238924`6.544589659522593", " ", "Second"}], ",", "1749"}], 
  "}"}]], "Print",ExpressionUUID->"aca1dc4c-ed70-4659-a09e-028ecaeaa91a"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"8f88dadc-d822-4c72-9bec-f58cac6efa60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"aa8f3c7c-0a5d-4d25-a8e6-9f2766ec0202"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"62c4b9bd-9cd8-4916-a137-0e82a3d7bd5b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.924189`6.417305788594333", " ", "Second"}], ",", "1473"}], 
  "}"}]], "Print",ExpressionUUID->"42af5163-631a-4266-aa54-d4d7c192edf5"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"721dd59e-46da-4b2e-8523-81fdf9a8df9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"75e9f9a1-8385-4495-ab38-58f4b7ca51e6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"c0157a85-b323-4ba1-bc6c-535438dfba2b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.772673`6.700173623404124", " ", "Second"}], ",", "3099"}], 
  "}"}]], "Print",ExpressionUUID->"80237544-05ab-480a-9824-3ad84e707d57"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"50ac8bb0-5bd6-4134-b823-27f680582521"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"2ab466f3-f5dc-4b2c-b4d2-6f9d6628c26c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f9b0021b-f9eb-4f2b-bc07-ef3441a65e70"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.961906`6.434677627201219", " ", "Second"}], ",", "1622"}], 
  "}"}]], "Print",ExpressionUUID->"469cd363-c089-48d2-9bb8-efb50e92c070"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"6d0df0a6-6349-494f-936b-72590181ad67"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"f5af7aef-f550-4819-9df6-9dadae25cc18"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"680bb203-3e73-494a-bbc1-0c55e56815f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.951224`6.429827792777002", " ", "Second"}], ",", "1617"}], 
  "}"}]], "Print",ExpressionUUID->"d708942d-129b-449a-ad6b-0267445560f1"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"4b292893-e7ac-4c20-9f93-f855f8716139"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "6"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"03196d2b-48f9-4576-adbe-8b8d01d677fe"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"f8fe7733-f86d-4ebd-bc4e-8c806a5a48c1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.845635`6.378727943188322", " ", "Second"}], ",", "1665"}], 
  "}"}]], "Print",ExpressionUUID->"7d40dba5-574c-4fd2-91b9-f9b987fc11bd"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"4a999ad3-27ee-449a-9741-15ac5e91157d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"10992620-96ca-47f5-8d63-fcc0e0c6c419"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"2d531d8d-16e6-4d72-94fa-ba502dd79686"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.878395`6.395234848517989", " ", "Second"}], ",", "1770"}], 
  "}"}]], "Print",ExpressionUUID->"c23af4c8-42d2-4598-a160-9be1a32eaadc"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"d09b96a1-f960-45d5-a63c-006749e593b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"8c397b2f-8d0f-40e7-9ead-1d4703894cd9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"cfa024c7-265c-4ac3-9a04-b80b6a8225db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.882233`6.397128292064027", " ", "Second"}], ",", "1746"}], 
  "}"}]], "Print",ExpressionUUID->"6e8e5edc-7ad0-41cc-bd7c-a3f1fc119bf9"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"496a5498-71ab-4254-afe0-e62b3561d232"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"c2458bca-57c2-479b-affa-8e7080850914"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e7a93f83-54d4-4363-8709-6f7b3e11cf60"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.554227`6.1952326727649645", " ", "Second"}], ",", "962"}], 
  "}"}]], "Print",ExpressionUUID->"8a73d11d-86f6-40cd-bfdf-c645af40dc3c"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"daebf94f-f220-49e7-9d2b-65492e517861"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "8", "}"}], 
  "]"}]], "Input",ExpressionUUID->"93632b4c-86f5-4646-877c-eea777a8b4a5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"6fc9a32c-6bc7-4a3c-880f-06e35424f93d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.506037`6.155727265885893", " ", "Second"}], ",", "1155"}], 
  "}"}]], "Print",ExpressionUUID->"63c90db2-d963-40df-8d17-69e4dc4f702d"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"475de8f2-5806-4a73-85e6-d2e9e013aa1d"]
}, Open  ]],

Cell["Sixth diagonal:", \
"Text",ExpressionUUID->"922a6bbf-3d0a-4bd1-a4be-66c3da545d3c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"655b50e0-a36a-42e0-87b8-e22e46efdc6f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"79767744-71b7-4337-9825-bbc39513dfa6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.156364`6.785267066266811", " ", "Second"}], ",", "1613"}], 
  "}"}]], "Print",ExpressionUUID->"23ca85d0-7dc9-42ac-a896-95f28793570d"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"811479ab-3fc1-448a-a4f7-b6963940ffdd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"70355da3-4a75-4eb3-9f3b-5049fc0a477c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"7ed77c06-4152-4247-92b7-3ca4488c4cb7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"12.301808`7.541513938001994", " ", "Second"}], ",", "12722"}], 
  "}"}]], "Print",ExpressionUUID->"36abdbbd-2b57-4c09-959b-d1a714e2153f"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"cf3dfe8e-06d4-4c7f-8f73-d4b76c02c1db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"5ffda42c-036f-492d-a626-0b35665649a9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"fbac6f11-ac14-46e1-98b7-32ca507580ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"27.569132`7.891968086277682", " ", "Second"}], ",", "27022"}], 
  "}"}]], "Print",ExpressionUUID->"1793e5c9-8a42-4733-a9ee-2aeba86d785e"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"23dae59b-c27d-45d3-9bdc-3fdee9771423"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"1893662a-0082-4c3e-a1c2-2bc344550816"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"f66f0350-bc2d-41da-8a48-79c53b85909d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"14.880151`7.624152331838496", " ", "Second"}], ",", "19617"}], 
  "}"}]], "Print",ExpressionUUID->"64baaf54-bdcb-47aa-896b-5fe4bb85cc93"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"4e71ec3c-833d-4258-bbbc-a1a4c5c76c95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"c1080943-6449-4c85-b159-c7baa7b41374"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"39dc178c-2eeb-4ffc-8268-da231d9b22e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"45.076325`8.105493494985383", " ", "Second"}], ",", "60984"}], 
  "}"}]], "Print",ExpressionUUID->"63ed8aa3-95f0-4c99-8018-d9807d2bded7"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"df26dfdc-461b-455f-bce7-a142daf71586"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"8c21bf77-c340-41a6-92fc-9211217ac6c4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a0b394a1-935e-4e79-9172-579ad8a50c5e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"24.140848`7.8342975150672585", " ", "Second"}], ",", "30974"}], 
  "}"}]], "Print",ExpressionUUID->"c5807708-e091-46d7-bdb5-4d4faf03728d"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"67e2f0b2-1d80-4430-b9e9-3644795c5aae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"7b8db22b-1ada-4d08-9efd-e69e4adde4a2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 1, 1, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"2e136f0a-7edc-4c51-965d-ff83a21bf5aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"47.944902`8.132287428757108", " ", "Second"}], ",", "62465"}], 
  "}"}]], "Print",ExpressionUUID->"84498a38-7fb9-491e-814a-36624384d563"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"91ac2f00-c9c2-4a45-bcf3-7497ad538048"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"2415a50b-26fd-4352-b15d-4ee96cddfb56"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"2a2e8108-a6b2-4e4c-89b7-8c856df4e02f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4.424557`7.097414787832281", " ", "Second"}], ",", "5606"}], 
  "}"}]], "Print",ExpressionUUID->"41581a56-22ca-4ddb-9490-ffd636e06b15"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"86df2041-c2cd-4ecd-97ca-4b0d4d41a968"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "6"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"aca65136-51b6-4b9f-aa18-846d609413a2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 6}],
  Editable->
   False]], "Print",ExpressionUUID->"4494b478-807e-4583-94ae-7b0a61afed20"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"16.649409`7.6729438155668905", " ", "Second"}], ",", "25590"}], 
  "}"}]], "Print",ExpressionUUID->"690ed94b-dcb3-4247-a48c-bb05440be206"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"8cea3e16-491c-4a9f-bdc7-f120ce38e5ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "5"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"9ac3bcf2-ced8-46ec-aefb-cba10a502463"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "5"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 1, 5}],
  Editable->
   False]], "Print",ExpressionUUID->"522d208b-ed3d-42ca-ab85-51bb1078f5b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"34.33199`7.987243970850384", " ", "Second"}], ",", "53160"}], 
  "}"}]], "Print",ExpressionUUID->"f507648d-1561-46f7-9297-b1aa35e5fe68"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"5f53db9b-16f7-4c78-a4d9-d61318528ee7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"65168fae-8bc4-4460-b992-40400901038a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 2, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"78a0795a-359a-4d48-bc5d-cafcecd41a03"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"33.53896`7.977094585061679", " ", "Second"}], ",", "52764"}], 
  "}"}]], "Print",ExpressionUUID->"f56339a2-f547-4e14-b3fe-5fbd9cbeae6e"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"fa850c93-b992-42a0-beca-217f9a337ba6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"e715fb9f-f026-4db2-a4de-bcc04024c3bf"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"3089befe-874d-4e44-90c5-822cab545358"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"19.75139`7.747142657918598", " ", "Second"}], ",", "27396"}], 
  "}"}]], "Print",ExpressionUUID->"372e8df0-b60a-434c-bc9a-0952bac9d066"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"6fdea4c1-ee43-4039-979e-91eb3ecf6b12"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "3", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"2f0f7009-71ce-43e3-898b-1dab9a20d761"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"a660b568-b836-4ade-a7e3-d23ac9b28538"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"18.36304`7.715489573734557", " ", "Second"}], ",", "27024"}], 
  "}"}]], "Print",ExpressionUUID->"bcdcc1d4-1c0a-48cd-b09b-ac9839a80bf3"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"0445b37c-d7e7-4193-89b4-d214f5a44660"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"9936bd46-c203-42a7-a9a5-58e39b004605"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b237cbbf-7792-4937-a047-b8e688b9af80"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"36.430667`8.013012116200072", " ", "Second"}], ",", "54654"}], 
  "}"}]], "Print",ExpressionUUID->"a2b370b7-6553-48f8-8ce1-3a2ae26a6051"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"236ebc24-b3f0-4e0d-9289-af2c249bc1a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"0ef553c3-3e0a-40e0-a8b6-a089937a082b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"8376b5f7-fb71-4553-ab0d-67c025a71fe3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"5.950329`7.2260859724908055", " ", "Second"}], ",", "9104"}], 
  "}"}]], "Print",ExpressionUUID->"7896e284-c1b3-4f40-91f4-557e6880e0ec"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"ba74a1b0-da27-4161-96c4-416d2afd8402"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "8"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"8a7526cb-bc0c-49fa-8ff8-0f9a05f98832"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"86681290-1487-492c-ab14-b59cafbd9602"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"14.888479`7.624395326194613", " ", "Second"}], ",", "25515"}], 
  "}"}]], "Print",ExpressionUUID->"2aa1dc3b-e380-4615-9487-da86e56e3594"]
}, Open  ]],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"5a48caae-ffa1-4618-a5ac-a0f26b9797a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "7"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"653672f1-2251-405e-9e7c-cbe78fed1f73"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"13.322361`7.57612619118371", " ", "Second"}], ",", "26670"}], 
  "}"}]], "Print",ExpressionUUID->"864837a0-367e-4d67-b0eb-81eb647ae7c4"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"d535337f-e822-464d-b0af-2504d2ec82d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "6"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"d569bf03-bfa6-48e3-9bda-4f68690bde66"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"13.214404`7.572592573725842", " ", "Second"}], ",", "26460"}], 
  "}"}]], "Print",ExpressionUUID->"41de46c9-1d28-4030-8767-ebabe9ec67ee"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"f5dc1f90-b477-4b8d-a1bb-420c284f281e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "5"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"abde13e4-5e8e-49de-9961-fdfe2d26cb56"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"13.18877`7.571749288123373", " ", "Second"}], ",", "26670"}], 
  "}"}]], "Print",ExpressionUUID->"875dbdbb-099f-4937-9e66-89ea7f3c7d69"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"b3ec7b02-5bea-42ef-87bd-15c98dd4476b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "4"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"e058d1db-d720-468c-97fe-399e75a5a7b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"6.60293`7.271281686683739", " ", "Second"}], ",", "13607"}], 
  "}"}]], "Print",ExpressionUUID->"859407d7-8251-444c-b191-deb8e65157ce"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"e420b85a-87ef-4d1b-9c5a-42f36f8eb165"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", "10", "}"}], 
  "]"}]], "Input",ExpressionUUID->"6501ffbd-ef7e-425d-a540-ef42c3ca8e17"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"6.162564`7.241306436077817", " ", "Second"}], ",", "15120"}], 
  "}"}]], "Print",ExpressionUUID->"4422c27c-42bf-40d1-9461-7b72f71e8f7d"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"ec2608cf-37d5-407e-b89b-8ed954f98d48"]
}, Open  ]],

Cell["Seventh diagonal:", \
"Text",ExpressionUUID->"60d4f0cc-bd8a-4be9-9193-ce22e61850c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"checkperms", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
   "}"}], "]"}]], \
"Input",ExpressionUUID->"2a7edd43-7c75-4d50-be35-3878fc74359f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"33.193421`7.972597007726173", " ", "Second"}], ",", "16532"}], 
  "}"}]], "Print",ExpressionUUID->"f910a759-1f64-4ec3-9622-f36d10b27181"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"9ea46fab-0819-4335-8be7-244752253594"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The invariant in the paper", \
"Subsubsection",ExpressionUUID->"8a04a41b-621f-4af7-a159-c057763c6caf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"paperinv", "=", 
  RowBox[{
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "e"}], "]"}], "@", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{"e", ",", "c", ",", "f", ",", "g"}], "]"}]}], 
   RowBox[{
    RowBox[{"CD", "[", "a", "]"}], "@", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "f"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "h"}], "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{"b", ",", "d", ",", "h", ",", 
        RowBox[{"-", "g"}]}], 
       "]"}]}]}]}]}]}]], \
"Input",ExpressionUUID->"9bde0827-30b8-49b9-9ec1-9d48f77fbcdc"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", "abcd", "    "],
    AutoSpacing->False],
   RiemannCD[-a, -b, -c, -d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"   ", 
      RowBox[{"g", ";", "h", ";", "f", "  "}]}], 
     RowBox[{"bdh", "     ", ";", "a"}]],
    AutoSpacing->False],
   CD[a][
    CD[-f][
     CD[-h][
      RiemannCD[b, d, h, -g]]]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"    ", 
      RowBox[{";", "e"}]}], 
     RowBox[{"ecfg", "  "}]],
    AutoSpacing->False],
   CD[-e][
    RiemannCD[e, c, f, g]],
   Editable->
    False]}]], "Output",ExpressionUUID->"46aed061-be58-497e-ac5d-08ef4cda4f99"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"canon", "=", 
  RowBox[{
  "ToCanonical", "[", "paperinv", 
   "]"}]}]], "Input",ExpressionUUID->"b6fe8376-4779-47fc-96f0-3210821b50e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "    ", "abcd"],
     AutoSpacing->False],
    RiemannCD[a, b, c, d],
    Editable->False]}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
     RowBox[{"   ", "h", "      "}]],
    AutoSpacing->False],
   CD[-d][
    CD[-g][
     CD[-h][
      RiemannCD[-b, -c, -f, h]]]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"a", "   ", ";", "e"}], 
     RowBox[{" ", "efg", "  "}]],
    AutoSpacing->False],
   CD[-e][
    RiemannCD[-a, e, f, g]],
   Editable->
    False]}]], "Output",ExpressionUUID->"2d2467b9-9d62-4b31-9224-59325f99d31d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"3ed018ea-2268-49c8-8e06-54e9abbaf5ff"],

Cell[BoxData[
 RowBox[{"-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2595\"\>"]}]], \
"Output",ExpressionUUID->"151aec67-4e5b-4356-8505-36adb9f88b4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannCD", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "e"}], "]"}], "@", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "e", ",", "f", ",", "g"}], "]"}]}], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "g"}], "]"}], "@", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "h"}], "]"}], "@", 
        RowBox[{"RiemannCD", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}], ",", "h"}], "]"}]}]}]}]}], "+", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "b"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "g"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "h"}], "]"}], "@", 
       RowBox[{"RiemannCD", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "f"}], ",", "h"}], "]"}]}]}]}]}], 
   ")"}]}]], "Input",ExpressionUUID->"aca8920d-3e22-4c0f-8550-486678a34c90"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", "    ", "abcd"],
    AutoSpacing->False],
   RiemannCD[a, b, c, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"cdf", " ", ";", "h", ";", "g", ";", "b"}], 
       RowBox[{"   ", "h", "      "}]],
      AutoSpacing->False],
     CD[-b][
      CD[-g][
       CD[-h][
        RiemannCD[-c, -d, -f, h]]]],
     Editable->False], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-g][
        CD[-h][
         RiemannCD[-b, -c, -f, h]]]],
      Editable->False]}]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"a", "   ", ";", "e"}], 
     RowBox[{" ", "efg", "  "}]],
    AutoSpacing->False],
   CD[-e][
    RiemannCD[-a, e, f, g]],
   Editable->
    False]}]], "Output",ExpressionUUID->"1efbe635-823a-479a-88ab-db72c8aab2e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplification", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"809588d0-0018-4c6e-831b-1167a3bcb12d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", "    ", "abcd"],
    AutoSpacing->False],
   RiemannCD[a, b, c, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"cdf", " ", ";", "h", ";", "g", ";", "b"}], 
       RowBox[{"   ", "h", "      "}]],
      AutoSpacing->False],
     CD[-b][
      CD[-g][
       CD[-h][
        RiemannCD[-c, -d, -f, h]]]],
     Editable->False], "+", 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-g][
        CD[-h][
         RiemannCD[-b, -c, -f, h]]]],
      Editable->False]}]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"a", "   ", ";", "e"}], 
     RowBox[{" ", "efg", "  "}]],
    AutoSpacing->False],
   CD[-e][
    RiemannCD[-a, e, f, g]],
   Editable->
    False]}]], "Output",ExpressionUUID->"7106f62e-644b-4650-bfcf-5514694f6d47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"17d2eada-63d2-406d-8f2c-52d3b010a917"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SubscriptBox["\<\"I\"\>", "\<\"013,2595\"\>"]}], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2610\"\>"]}]], \
"Output",ExpressionUUID->"b38abd0f-3412-40f2-bf90-4516f35a6cf9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannCD", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "e"}], "]"}], "@", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "e", ",", "f", ",", "g"}], "]"}]}], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "d"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "g"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "h"}], "]"}], "@", 
       RowBox[{"RiemannCD", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "f"}], ",", "h"}], "]"}]}]}]}], "-", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "d"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "g"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "h"}], "]"}], "@", 
       RowBox[{"RiemannCD", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "f"}], ",", 
         RowBox[{"-", "c"}], ",", "h"}], "]"}]}]}]}], "+", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "d"}], "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "g"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "h"}], "]"}], "@", 
       RowBox[{"RiemannCD", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", "h", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "f"}]}], "]"}]}]}]}]}], 
   ")"}]}]], "Input",ExpressionUUID->"9512a61b-6ebe-4c55-a923-dc2aa5188924"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", "    ", "abcd"],
    AutoSpacing->False],
   RiemannCD[a, b, c, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
       RowBox[{"   ", "h", "      "}]],
      AutoSpacing->False],
     CD[-d][
      CD[-g][
       CD[-h][
        RiemannCD[-b, -c, -f, h]]]],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"bfc", " ", ";", "h", ";", "g", ";", "d"}], 
       RowBox[{"   ", "h", "      "}]],
      AutoSpacing->False],
     CD[-d][
      CD[-g][
       CD[-h][
        RiemannCD[-b, -f, -c, h]]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{
        RowBox[{"b", " ", "cf"}], ";", "h", ";", "g", ";", "d"}], 
       RowBox[{" ", "h", "        "}]],
      AutoSpacing->False],
     CD[-d][
      CD[-g][
       CD[-h][
        RiemannCD[-b, h, -c, -f]]]],
     Editable->False]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"a", "   ", ";", "e"}], 
     RowBox[{" ", "efg", "  "}]],
    AutoSpacing->False],
   CD[-e][
    RiemannCD[-a, e, f, g]],
   Editable->
    False]}]], "Output",ExpressionUUID->"4af7a7e0-f425-481c-8023-22100e45e30a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplification", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"62d7af99-e273-4adf-9c94-1b0a5d92a5ab"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", "    ", "abcd"],
    AutoSpacing->False],
   RiemannCD[a, b, c, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
       RowBox[{"   ", "h", "      "}]],
      AutoSpacing->False],
     CD[-d][
      CD[-g][
       CD[-h][
        RiemannCD[-b, -c, -f, h]]]],
     Editable->False], "-", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"bfc", " ", ";", "h", ";", "g", ";", "d"}], 
       RowBox[{"   ", "h", "      "}]],
      AutoSpacing->False],
     CD[-d][
      CD[-g][
       CD[-h][
        RiemannCD[-b, -f, -c, h]]]],
     Editable->False], "+", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{
        RowBox[{"b", " ", "cf"}], ";", "h", ";", "g", ";", "d"}], 
       RowBox[{" ", "h", "        "}]],
      AutoSpacing->False],
     CD[-d][
      CD[-g][
       CD[-h][
        RiemannCD[-b, h, -c, -f]]]],
     Editable->False]}], ")"}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"a", "   ", ";", "e"}], 
     RowBox[{" ", "efg", "  "}]],
    AutoSpacing->False],
   CD[-e][
    RiemannCD[-a, e, f, g]],
   Editable->
    False]}]], "Output",ExpressionUUID->"5f5d9aee-3729-4041-8e21-7626b6cadbde"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"229839b0-2457-4662-8251-34416e56643c"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"013,2595\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2601\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2757\"\>"]}]], \
"Output",ExpressionUUID->"9ea9df1a-e12f-41e6-8859-32c4fafad553"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannCD", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "e"}], "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "e", ",", "f", ",", "g"}], "]"}]}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "g"}], "]"}], "@", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "h"}], "]"}], "@", 
        RowBox[{"RiemannCD", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}], ",", "h"}], "]"}]}]}]}]}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "f"}], "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "e", ",", "f", ",", "g"}], "]"}]}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "e"}], "]"}], "@", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "h"}], "]"}], "@", 
        RowBox[{"RiemannCD", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}], ",", "h"}], "]"}]}]}]}]}], "-", 
    RowBox[{
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "f"}], "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "e", ",", "f", ",", "g"}], "]"}]}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "g"}], "]"}], "@", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "h"}], "]"}], "@", 
        RowBox[{"RiemannCD", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "e"}], ",", "h"}], "]"}]}]}]}]}]}], 
   ")"}]}]], "Input",ExpressionUUID->"810547ff-4d1f-4b31-b0ca-4d2319b35ba3"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", "    ", "abcd"],
    AutoSpacing->False],
   RiemannCD[a, b, c, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-g][
        CD[-h][
         RiemannCD[-b, -c, -f, h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", "   ", ";", "e"}], 
        RowBox[{" ", "efg", "  "}]],
       AutoSpacing->False],
      CD[-e][
       RiemannCD[-a, e, f, g]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bcg", " ", ";", "h", ";", "e", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-e][
        CD[-h][
         RiemannCD[-b, -c, -g, h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", "   ", ";", "f"}], 
        RowBox[{" ", "efg", "  "}]],
       AutoSpacing->False],
      CD[-f][
       RiemannCD[-a, e, f, g]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bce", " ", ";", "h", ";", "g", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-g][
        CD[-h][
         RiemannCD[-b, -c, -e, h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", "   ", ";", "f"}], 
        RowBox[{" ", "efg", "  "}]],
       AutoSpacing->False],
      CD[-f][
       RiemannCD[-a, e, f, g]],
      Editable->False]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"3d0b69d4-1fec-48af-bcf1-b8c3d7d7a007"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplification", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"34985a2b-0dfe-4a40-8741-fadca8e41e7f"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", "    ", "abcd"],
    AutoSpacing->False],
   RiemannCD[a, b, c, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-g][
        CD[-h][
         RiemannCD[-b, -c, -f, h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", "   ", ";", "e"}], 
        RowBox[{" ", "efg", "  "}]],
       AutoSpacing->False],
      CD[-e][
       RiemannCD[-a, e, f, g]],
      Editable->False]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["R", 
          RowBox[{"bcg", " ", ";", "h", ";", "e", ";", "d"}], 
          RowBox[{"   ", "h", "      "}]],
         AutoSpacing->False],
        CD[-d][
         CD[-e][
          CD[-h][
           RiemannCD[-b, -c, -g, h]]]],
        Editable->False], "-", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["R", 
          RowBox[{"bce", " ", ";", "h", ";", "g", ";", "d"}], 
          RowBox[{"   ", "h", "      "}]],
         AutoSpacing->False],
        CD[-d][
         CD[-g][
          CD[-h][
           RiemannCD[-b, -c, -e, h]]]],
        Editable->False]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", "   ", ";", "f"}], 
        RowBox[{" ", "efg", "  "}]],
       AutoSpacing->False],
      CD[-f][
       RiemannCD[-a, e, f, g]],
      Editable->False]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"683cf108-f24f-4ef6-be33-14eb394f165e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"66a3715c-dd40-4158-9f6b-7ebecc557b3b"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"013,2595\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2634\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2640\"\>"]}]], \
"Output",ExpressionUUID->"3749c43f-b479-43ac-819e-b54121a02001"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RiemannCD", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "e"}], "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "e", ",", "f", ",", "g"}], "]"}]}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "g"}], "]"}], "@", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "h"}], "]"}], "@", 
        RowBox[{"RiemannCD", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}], ",", "h"}], "]"}]}]}]}]}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"CD", "[", "g", "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "e", ",", 
        RowBox[{"-", "e"}], ",", "f"}], "]"}]}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "g"}], "]"}], "@", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "h"}], "]"}], "@", 
        RowBox[{"RiemannCD", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}], ",", "h"}], "]"}]}]}]}]}], "-", 
    RowBox[{
     RowBox[{
      RowBox[{"CD", "[", "g", "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "e", ",", 
        RowBox[{"-", "e"}], ",", "f"}], "]"}]}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "f"}], "]"}], "@", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "h"}], "]"}], "@", 
        RowBox[{"RiemannCD", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}], ",", "h"}], "]"}]}]}]}]}]}], 
   ")"}]}]], "Input",ExpressionUUID->"fb1eebd0-e0ff-4952-8073-7fa844e3b3d4"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", "    ", "abcd"],
    AutoSpacing->False],
   RiemannCD[a, b, c, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-g][
        CD[-h][
         RiemannCD[-b, -c, -f, h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", "   ", ";", "e"}], 
        RowBox[{" ", "efg", "  "}]],
       AutoSpacing->False],
      CD[-e][
       RiemannCD[-a, e, f, g]],
      Editable->False]}], "-", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bcg", " ", ";", "h", ";", "f", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-f][
        CD[-h][
         RiemannCD[-b, -c, -g, h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", " ", "e", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"e", " ", "f"}], ";", "g"}]}]],
       AutoSpacing->False],
      CD[g][
       RiemannCD[-a, e, -e, f]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-g][
        CD[-h][
         RiemannCD[-b, -c, -f, h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", " ", "e", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"e", " ", "f"}], ";", "g"}]}]],
       AutoSpacing->False],
      CD[g][
       RiemannCD[-a, e, -e, f]],
      Editable->False]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"96864c79-fcaf-4fa2-99b7-8aca1f5f5b7e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplification", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"b5a85df2-81bc-4bb3-9146-dee5976f9589"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", "    ", "abcd"],
    AutoSpacing->False],
   RiemannCD[a, b, c, d],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      InterpretationBox[
       StyleBox[
        SubsuperscriptBox["R", 
         RowBox[{"bcg", " ", ";", "h", ";", "f", ";", "d"}], 
         RowBox[{"   ", "h", "      "}]],
        AutoSpacing->False],
       CD[-d][
        CD[-f][
         CD[-h][
          RiemannCD[-b, -c, -g, h]]]],
       Editable->False]}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", " ", "e", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"e", " ", "f"}], ";", "g"}]}]],
       AutoSpacing->False],
      CD[g][
       RiemannCD[-a, e, -e, f]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
        RowBox[{"   ", "h", "      "}]],
       AutoSpacing->False],
      CD[-d][
       CD[-g][
        CD[-h][
         RiemannCD[-b, -c, -f, h]]]],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["R", 
          RowBox[{"a", "   ", ";", "e"}], 
          RowBox[{" ", "efg", "  "}]],
         AutoSpacing->False],
        CD[-e][
         RiemannCD[-a, e, f, g]],
        Editable->False], "+", 
       InterpretationBox[
        StyleBox[
         SubsuperscriptBox["R", 
          RowBox[{"a", " ", "e", "   "}], 
          RowBox[{" ", 
           RowBox[{
            RowBox[{"e", " ", "f"}], ";", "g"}]}]],
         AutoSpacing->False],
        CD[g][
         RiemannCD[-a, e, -e, f]],
        Editable->False]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"f898dbf3-d38e-42fe-901e-bac87573214e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"9ec88533-d79a-4377-8d10-e15bbd3173b4"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"013,1445\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,1451\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2595\"\>"]}]], \
"Output",ExpressionUUID->"95ec5976-0481-4f6a-aaf3-49d8f45fc6b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvSimplify", "[", 
  RowBox[{"%", ",", "2"}], 
  "]"}]], "Input",ExpressionUUID->"87e947dd-66fd-40af-85e8-850c069f838b"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"013,1445\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,1451\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2595\"\>"]}]], \
"Output",ExpressionUUID->"7780ca90-df23-489d-bf84-4c90439ddf07"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["canon"], \
"Input",ExpressionUUID->"dd911b45-7b91-48b4-bdbc-0034776d2a66"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "    ", "abcd"],
     AutoSpacing->False],
    RiemannCD[a, b, c, d],
    Editable->False]}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"bcf", " ", ";", "h", ";", "g", ";", "d"}], 
     RowBox[{"   ", "h", "      "}]],
    AutoSpacing->False],
   CD[-d][
    CD[-g][
     CD[-h][
      RiemannCD[-b, -c, -f, h]]]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"a", "   ", ";", "e"}], 
     RowBox[{" ", "efg", "  "}]],
    AutoSpacing->False],
   CD[-e][
    RiemannCD[-a, e, f, g]],
   Editable->
    False]}]], "Output",ExpressionUUID->"b3e56ece-8273-4dfe-bc82-361c9a1c525a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"canon", "-", 
   RowBox[{"CommuteCovDs", "[", 
    RowBox[{"canon", ",", "CD", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "h"}], ",", 
       RowBox[{"-", "g"}]}], "}"}]}], "]"}]}], "//", 
  "RiemannToInv"}]], \
"Input",ExpressionUUID->"33658599-1358-4214-8fa0-2b1fecf44572"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"013,2593\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2595\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,694\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,827\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,1194\"\>"], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"I\"\>", "\<\"0011,1329\"\>"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"I\"\>", "\<\"0011,1331\"\>"]}], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,1745\"\>"]}]], \
"Output",ExpressionUUID->"8432fc5c-f5aa-4dc8-a789-dc686714ca05"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvSimplify", "[", 
   RowBox[{"%", ",", "3"}], "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"19b4c56d-72df-42b2-91c3-3e7cdb186951"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"52803900-49bf-4736-92e5-be556d2e81ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"eb1100e9-ac5c-4da9-986e-f53bc43cb93a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"013,536\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,539\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,542\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,548\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,820\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,294\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,296\"\>"], "+", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"0011,363\"\>"], "2"], "+", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"0011,369\"\>"], "2"], "-", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"0011,775\"\>"], "2"], "+", 
  FractionBox[
   SubscriptBox["\<\"I\"\>", "\<\"0011,776\"\>"], "2"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,884\"\>"], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"I\"\>", "\<\"0011,885\"\>"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"I\"\>", "\<\"0011,918\"\>"]}], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,1008\"\>"]}]], \
"Output",ExpressionUUID->"691efddd-0ac2-4fee-bd12-8c91ae7a95ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvSimplify", "[", 
   RowBox[{"%", ",", "4"}], "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"6acea3a7-549b-4ef2-bf08-71c408387d55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"b016c857-77a9-42f2-bdae-cd4d184cf792"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"05070eee-4328-44f1-ba9f-26d80a9588d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"canon", "-", 
   RowBox[{"CommuteCovDs", "[", 
    RowBox[{"canon", ",", "CD", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "g"}], ",", 
       RowBox[{"-", "d"}]}], "}"}]}], "]"}]}], "//", 
  "RiemannToInv"}]], \
"Input",ExpressionUUID->"8ec3bf0c-992a-4062-a450-673f05579bcc"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"I\"\>", "\<\"013,2594\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,2595\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,1091\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,1216\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,1353\"\>"]}]], \
"Output",ExpressionUUID->"49b8e309-3f7d-4cf9-9925-f5eac3d783c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvSimplify", "[", 
   RowBox[{"%", ",", "3"}], "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"0e97a745-57db-457c-a266-de741b7ccd05"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SubscriptBox["\<\"I\"\>", "\<\"013,535\"\>"]}], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,536\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,538\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,539\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,541\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,542\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"013,547\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"013,548\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,385\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,386\"\>"], "-", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,394\"\>"], "+", 
  SubscriptBox["\<\"I\"\>", "\<\"0011,397\"\>"]}]], \
"Output",ExpressionUUID->"ebfdbcf2-d762-4cb5-be10-4ea798ed8e41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvSimplify", "[", 
   RowBox[{"%", ",", "4"}], "]"}], "//", 
  "Expand"}]], "Input",ExpressionUUID->"6edb95d2-8c6b-44df-8689-7829f68a1a6f"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"93704af1-91c9-4824-890d-3bb4375c997a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Nice examples", \
"Subsubsection",ExpressionUUID->"62f86331-db01-4e1f-9714-a67ffca13add"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rules", "=", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"1f25556f-415b-4b8e-996d-44d452215f50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"1692d0a6-a5af-488a-970a-b7396bc81e41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvToRiemann", "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"First", "/@", 
     RowBox[{"Cases", "[", 
      RowBox[{"rules", ",", 
       RowBox[{"HoldPattern", "[", 
        RowBox[{"_", "\[Rule]", "0"}], "]"}]}], "]"}]}], "/.", 
    RowBox[{"RInv", "\[Rule]", 
     RowBox[{"RInv", "[", "metric", "]"}]}]}], 
   ")"}]}]], "Input",ExpressionUUID->"4fbe953f-63b2-443d-913e-d3df73cef4c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"8925e225-80ca-4929-8b77-4c7fd29f815f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"fg", ";", "a", ";", "b"}]}], 
        RowBox[{"fg", "      "}]],
       AutoSpacing->False],
      CD[-b][
       CD[-a][
        RiemannCD[f, g, -f, -g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"hi", ";", "c", ";", "d", ";", "e"}]}], 
        RowBox[{"hi", "        "}]],
       AutoSpacing->False],
      CD[-e][
       CD[-d][
        CD[-c][
         RiemannCD[h, i, -h, -i]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bdgh", "  ", ";", "i", ";", "c"}], 
        RowBox[{"    ", 
         RowBox[{";", "i", "    "}]}]],
       AutoSpacing->False],
      CD[-c][
       CD[-i][
        CD[i][
         RiemannCD[-b, -d, -g, -h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", "   "}], 
        RowBox[{
         RowBox[{"ab", " ", "c"}], ";", "d"}]],
       AutoSpacing->False],
      CD[d][
       RiemannCD[a, b, -a, c]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "ef", "    "}], 
        RowBox[{"ef", "  ", ";", "g", ";", "h"}]],
       AutoSpacing->False],
      CD[h][
       CD[g][
        RiemannCD[e, f, -e, -f]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"fg", ";", "a", ";", "b"}]}], 
        RowBox[{"fg", "      "}]],
       AutoSpacing->False],
      CD[-b][
       CD[-a][
        RiemannCD[f, g, -f, -g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "eh"}], ";", "d", "  ", ";", "i"}], 
        RowBox[{" ", 
         RowBox[{"h", "    ", ";", "i", "  "}]}]],
       AutoSpacing->False],
      CD[-i][
       CD[i][
        CD[-d][
         RiemannCD[-c, h, -e, -h]]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"fg", ";", "a", ";", "b"}]}], 
        RowBox[{"fg", "      "}]],
       AutoSpacing->False],
      CD[-b][
       CD[-a][
        RiemannCD[f, g, -f, -g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "eh"}], "  ", ";", "i", ";", "d"}], 
        RowBox[{" ", 
         RowBox[{"h", "  ", ";", "i", "    "}]}]],
       AutoSpacing->False],
      CD[-d][
       CD[-i][
        CD[i][
         RiemannCD[-c, h, -e, -h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"hi", ";", "c", ";", "d", ";", "e"}]}], 
        RowBox[{"hi", "        "}]],
       AutoSpacing->False],
      CD[-e][
       CD[-d][
        CD[-c][
         RiemannCD[h, i, -h, -i]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "f"}], " ", ";", "b", ";", "g"}], 
        RowBox[{" ", 
         RowBox[{"f", " ", "g", "    "}]}]],
       AutoSpacing->False],
      CD[-g][
       CD[-b][
        RiemannCD[-a, f, -f, g]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"fg", ";", "a", ";", "b"}]}], 
        RowBox[{"fg", "      "}]],
       AutoSpacing->False],
      CD[-b][
       CD[-a][
        RiemannCD[f, g, -f, -g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "h"}], " ", ";", "d", ";", "e", ";", "i"}], 
        RowBox[{" ", 
         RowBox[{"h", " ", "i", "      "}]}]],
       AutoSpacing->False],
      CD[-i][
       CD[-e][
        CD[-d][
         RiemannCD[-c, h, -h, i]]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bdgh", "  ", ";", "i", ";", "c"}], 
        RowBox[{"    ", 
         RowBox[{";", "i", "    "}]}]],
       AutoSpacing->False],
      CD[-c][
       CD[-i][
        CD[i][
         RiemannCD[-b, -d, -g, -h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", "   "}], 
        RowBox[{
         RowBox[{"ab", " ", "c"}], ";", "d"}]],
       AutoSpacing->False],
      CD[d][
       RiemannCD[a, b, -a, c]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"e", "   ", ";", "f"}]}], 
        RowBox[{
         RowBox[{"ef", " ", "g"}], ";", "h", "  "}]],
       AutoSpacing->False],
      CD[-f][
       CD[h][
        RiemannCD[e, f, -e, g]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "f"}], " ", ";", "b", ";", "g"}], 
        RowBox[{" ", 
         RowBox[{"f", " ", "g", "    "}]}]],
       AutoSpacing->False],
      CD[-g][
       CD[-b][
        RiemannCD[-a, f, -f, g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "eh"}], ";", "d", "  ", ";", "i"}], 
        RowBox[{" ", 
         RowBox[{"h", "    ", ";", "i", "  "}]}]],
       AutoSpacing->False],
      CD[-i][
       CD[i][
        CD[-d][
         RiemannCD[-c, h, -e, -h]]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "eh"}], "  ", ";", "i", ";", "d"}], 
        RowBox[{" ", 
         RowBox[{"h", "  ", ";", "i", "    "}]}]],
       AutoSpacing->False],
      CD[-d][
       CD[-i][
        CD[i][
         RiemannCD[-c, h, -e, -h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "f"}], " ", ";", "b", ";", "g"}], 
        RowBox[{" ", 
         RowBox[{"f", " ", "g", "    "}]}]],
       AutoSpacing->False],
      CD[-g][
       CD[-b][
        RiemannCD[-a, f, -f, g]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "f"}], " ", ";", "b", ";", "g"}], 
        RowBox[{" ", 
         RowBox[{"f", " ", "g", "    "}]}]],
       AutoSpacing->False],
      CD[-g][
       CD[-b][
        RiemannCD[-a, f, -f, g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "h"}], " ", ";", "d", ";", "e", ";", "i"}], 
        RowBox[{" ", 
         RowBox[{"h", " ", "i", "      "}]}]],
       AutoSpacing->False],
      CD[-i][
       CD[-e][
        CD[-d][
         RiemannCD[-c, h, -h, i]]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"fg", ";", "a", ";", "b"}]}], 
        RowBox[{"fg", "      "}]],
       AutoSpacing->False],
      CD[-b][
       CD[-a][
        RiemannCD[f, g, -f, -g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"cde", "   ", ";", "i", ";", "h"}], 
        RowBox[{"   ", 
         RowBox[{"h", ";", "i", "    "}]}]],
       AutoSpacing->False],
      CD[-h][
       CD[-i][
        CD[i][
         RiemannCD[-c, -d, -e, h]]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "f"}], " ", ";", "b", ";", "g"}], 
        RowBox[{" ", 
         RowBox[{"f", " ", "g", "    "}]}]],
       AutoSpacing->False],
      CD[-g][
       CD[-b][
        RiemannCD[-a, f, -f, g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"cde", "   ", ";", "i", ";", "h"}], 
        RowBox[{"   ", 
         RowBox[{"h", ";", "i", "    "}]}]],
       AutoSpacing->False],
      CD[-h][
       CD[-i][
        CD[i][
         RiemannCD[-c, -d, -e, h]]]],
      Editable->False]}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"d243a4fa-416c-4d15-89e4-0e81226726db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$CommuteCovDsOnScalars", "=", "True"}], "}"}], ",", 
   RowBox[{"ToCanonical", "[", "%", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"43315e20-5d79-41e7-b953-138b33524ed4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bdgh", "  ", ";", "i", ";", "c"}], 
        RowBox[{"    ", 
         RowBox[{";", "i", "    "}]}]],
       AutoSpacing->False],
      CD[-c][
       CD[-i][
        CD[i][
         RiemannCD[-b, -d, -g, -h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", "   "}], 
        RowBox[{
         RowBox[{"ab", " ", "c"}], ";", "d"}]],
       AutoSpacing->False],
      CD[d][
       RiemannCD[a, b, -a, c]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"e", "   ", ";", "f"}]}], 
        RowBox[{
         RowBox[{"ef", " ", "g"}], ";", "h", "  "}]],
       AutoSpacing->False],
      CD[-f][
       CD[h][
        RiemannCD[e, f, -e, g]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "f"}], " ", ";", "b", ";", "g"}], 
        RowBox[{" ", 
         RowBox[{"f", " ", "g", "    "}]}]],
       AutoSpacing->False],
      CD[-g][
       CD[-b][
        RiemannCD[-a, f, -f, g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "eh"}], ";", "d", "  ", ";", "i"}], 
        RowBox[{" ", 
         RowBox[{"h", "    ", ";", "i", "  "}]}]],
       AutoSpacing->False],
      CD[-i][
       CD[i][
        CD[-d][
         RiemannCD[-c, h, -e, -h]]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "eh"}], "  ", ";", "i", ";", "d"}], 
        RowBox[{" ", 
         RowBox[{"h", "  ", ";", "i", "    "}]}]],
       AutoSpacing->False],
      CD[-d][
       CD[-i][
        CD[i][
         RiemannCD[-c, h, -e, -h]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "f"}], " ", ";", "b", ";", "g"}], 
        RowBox[{" ", 
         RowBox[{"f", " ", "g", "    "}]}]],
       AutoSpacing->False],
      CD[-g][
       CD[-b][
        RiemannCD[-a, f, -f, g]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "f"}], " ", ";", "b", ";", "g"}], 
        RowBox[{" ", 
         RowBox[{"f", " ", "g", "    "}]}]],
       AutoSpacing->False],
      CD[-g][
       CD[-b][
        RiemannCD[-a, f, -f, g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "h"}], " ", ";", "d", ";", "e", ";", "i"}], 
        RowBox[{" ", 
         RowBox[{"h", " ", "i", "      "}]}]],
       AutoSpacing->False],
      CD[-i][
       CD[-e][
        CD[-d][
         RiemannCD[-c, h, -h, i]]]],
      Editable->False]}], "]"}], ",", "0", ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "f"}], " ", ";", "b", ";", "g"}], 
        RowBox[{" ", 
         RowBox[{"f", " ", "g", "    "}]}]],
       AutoSpacing->False],
      CD[-g][
       CD[-b][
        RiemannCD[-a, f, -f, g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"cde", "   ", ";", "i", ";", "h"}], 
        RowBox[{"   ", 
         RowBox[{"h", ";", "i", "    "}]}]],
       AutoSpacing->False],
      CD[-h][
       CD[-i][
        CD[i][
         RiemannCD[-c, -d, -e, h]]]],
      Editable->False]}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"7c952c25-456d-44e0-b724-9fa2594ce12d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rules", "=", 
   RowBox[{"RInvRules", "[", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"96a8b8a4-3f92-4e4a-9258-0b474253aa47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b4c57114-1af3-46e6-a056-c298f0f8c78e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"rulesb", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{"rules", ",", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{"RInv", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", "_"}], "]"}], "\[Rule]", 
       RowBox[{"_", " ", 
        RowBox[{"RInv", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", "_"}], "]"}]}]}], 
      "]"}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"9bbae268-647a-4e82-887d-129b579893e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"Denominator", "/@", 
    RowBox[{"Last", "/@", "rulesb"}]}], ",", "8"}], 
  "]"}]], "Input",ExpressionUUID->"53abf7c2-fce9-4cc7-bdc9-1f2ee0eace0b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "57", "}"}], ",", 
   RowBox[{"{", "62", "}"}], ",", 
   RowBox[{"{", "133", "}"}], ",", 
   RowBox[{"{", "389", "}"}], ",", 
   RowBox[{"{", "439", "}"}], ",", 
   RowBox[{"{", "440", "}"}], ",", 
   RowBox[{"{", "441", "}"}], ",", 
   RowBox[{"{", "444", "}"}], ",", 
   RowBox[{"{", "446", "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"24f16261-e0ac-4feb-a826-f3a09f209cbf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"rules", ",", 
   RowBox[{"rulesb", "[", 
    RowBox[{"[", "446", "]"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"822648ea-4af1-4cec-8f6c-315d1d57636d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "2868", "}"}], 
  "}"}]], "Output",ExpressionUUID->"5718f2ff-0a11-4b1c-bd9e-21eed7ae8d30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Scalar", "[", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"      ", 
        RowBox[{";", "a"}]}], 
       RowBox[{"abcd", ";", "e", "  "}]],
      AutoSpacing->False],
     CD[-a][
      CD[e][
       RiemannCD[a, b, c, d]]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"cfgi", ";", "d", ";", "h"}], "        "],
      AutoSpacing->False],
     CD[-h][
      CD[-d][
       RiemannCD[-c, -f, -g, -i]]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"be", "      "}], 
       RowBox[{"  ", 
        RowBox[{"fg", ";", "h", ";", "i"}]}]],
      AutoSpacing->False],
     CD[i][
      CD[h][
       RiemannCD[-b, -e, f, g]]],
     Editable->False]}], "]"}], "-", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"      ", 
         RowBox[{";", "e"}]}], 
        RowBox[{"abcd", ";", "e", "  "}]],
       AutoSpacing->False],
      CD[-e][
       CD[e][
        RiemannCD[a, b, c, d]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"cdfg", ";", "i", ";", "h"}], "        "],
       AutoSpacing->False],
      CD[-h][
       CD[-i][
        RiemannCD[-c, -d, -f, -g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"ab", "      "}], 
        RowBox[{"  ", 
         RowBox[{"fg", ";", "h", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       CD[h][
        RiemannCD[-a, -b, f, g]]],
      Editable->False]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"e184b0ac-4dc7-4023-b731-8856e9d6fab0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "8"]}], " ", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"      ", 
         RowBox[{";", "e"}]}], 
        RowBox[{"abcd", ";", "e", "  "}]],
       AutoSpacing->False],
      CD[-e][
       CD[e][
        RiemannCD[a, b, c, d]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"cdfg", ";", "i", ";", "h"}], "        "],
       AutoSpacing->False],
      CD[-h][
       CD[-i][
        RiemannCD[-c, -d, -f, -g]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"ab", "      "}], 
        RowBox[{"  ", 
         RowBox[{"fg", ";", "h", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       CD[h][
        RiemannCD[-a, -b, f, g]]],
      Editable->False]}], "]"}]}], "+", 
  RowBox[{"Scalar", "[", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"      ", 
        RowBox[{";", "a"}]}], 
       RowBox[{"abcd", ";", "e", "  "}]],
      AutoSpacing->False],
     CD[-a][
      CD[e][
       RiemannCD[a, b, c, d]]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"cfgi", ";", "d", ";", "h"}], "        "],
      AutoSpacing->False],
     CD[-h][
      CD[-d][
       RiemannCD[-c, -f, -g, -i]]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"be", "      "}], 
       RowBox[{"  ", 
        RowBox[{"fg", ";", "h", ";", "i"}]}]],
      AutoSpacing->False],
     CD[i][
      CD[h][
       RiemannCD[-b, -e, f, g]]],
     Editable->False]}], 
   "]"}]}]], "Output",ExpressionUUID->"6119fa07-2dd6-46a4-931c-e7f420c62c6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "RiemannToInv"}], "//", "InvSimplify"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"592a231d-0d41-46bd-937a-222a0ce623cf"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"640db92d-093e-4d13-b8cd-167ffef7763b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6b7637c7-40d3-427e-a769-cbd00887c1c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {2, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"911de734-8c0f-4006-b712-4f176b45a895"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {2, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"4747fb77-32c3-43c0-9718-f429d7b148a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {2, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"5001b564-bc88-416c-9f60-c9e32a7a5a77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"91e0f5f3-f5a7-420d-bc26-e0e2f10d3902"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"f9fd2988-5d8b-46c7-8446-8a022cb1f8e2"]
}, Open  ]],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"9689b120-4234-4993-8b06-4d70b54a97d8"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Renato's examples", \
"Subsubsection",ExpressionUUID->"7e76a24f-b8bf-43b5-834c-63c2cd6bed88"],

Cell["First example:", \
"Text",ExpressionUUID->"2ad0e708-d857-4c47-9488-861c00932596"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"invar1", "=", 
  RowBox[{
   RowBox[{"DualRInv", "[", "metric", "]"}], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}], ",", "1"}], 
   "]"}]}]], "Input",ExpressionUUID->"5d4898a8-41dd-43f1-92e0-41b473699ad2"],

Cell[BoxData[
 SubscriptBox["\<\"D\"\>", "\<\"02,1\"\>"]], \
"Output",ExpressionUUID->"4428dfdd-5515-48ae-be7f-b9e94df49c30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"invar2", "=", 
  RowBox[{
  "InvSimplify", "[", "invar1", 
   "]"}]}]], "Input",ExpressionUUID->"081f4c1e-d16d-4be8-be75-1d013fc93b50"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"642c6769-7fd6-4a6a-93e9-1d0fd558b637"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"925c28fd-f3a9-41a0-a64b-df870f2d18ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"acddb012-5eae-419c-beac-a2a4c0f4497b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"50049c49-c1a6-4fbd-a1e0-3b2080a794c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"f37ce307-a787-44e9-ad84-b808305073cd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SubscriptBox["\<\"D\"\>", "\<\"000,2\"\>"], 
   "2"]}]], "Output",ExpressionUUID->"fa38d104-ddd1-4af7-b6e3-6a6680fb41cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvToRiemann", "[", "invar1", 
  "]"}]], "Input",ExpressionUUID->"a0b45365-8d26-49ea-be22-1b9b7e8b6b55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"6e5105c7-05c2-4571-bd5d-a023840e9c99"],

Cell[BoxData[
 RowBox[{"Scalar", "[", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "cefg", "    "],
     AutoSpacing->False],
    epsilonmetric[-c, -e, -f, -g],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"  ", "a", " "}], 
      RowBox[{"ab", " ", "c"}]],
     AutoSpacing->False],
    RiemannCD[a, b, -a, c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"b", " ", "d", "     "}], 
      RowBox[{" ", 
       RowBox[{
        RowBox[{"d", " ", "e"}], ";", "f", ";", "g"}]}]],
     AutoSpacing->False],
    CD[g][
     CD[f][
      RiemannCD[-b, d, -d, e]]],
    Editable->False]}], 
  "]"}]], "Output",ExpressionUUID->"dd544d91-3bf8-4042-af1c-514a262a0eae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NoScalar", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"7c3ff059-e41d-4fc8-a71e-fee9eabf4bed"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Epsilon]", "cefg", "    "],
    AutoSpacing->False],
   epsilonmetric[-c, -e, -f, -g],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"  ", "a", " "}], 
     RowBox[{"ab", " ", "c"}]],
    AutoSpacing->False],
   RiemannCD[a, b, -a, c],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["R", 
     RowBox[{"b", " ", "d", "     "}], 
     RowBox[{" ", 
      RowBox[{
       RowBox[{"d", " ", "e"}], ";", "f", ";", "g"}]}]],
    AutoSpacing->False],
   CD[g][
    CD[f][
     RiemannCD[-b, d, -d, e]]],
   Editable->
    False]}]], "Output",ExpressionUUID->"2444861e-749e-4a8f-b04d-f5cb71c9fc56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CD", "[", "a", "]"}], "@", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "[", "%", 
   "]"}]}]], "Input",ExpressionUUID->"b531e5f5-efc0-4b6e-9307-12645f012a85"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Epsilon]", "dfgh", "    "],
    AutoSpacing->False],
   epsilonmetric[-d, -f, -g, -h],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "e"}], "     ", ";", "a"}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"e", " ", "f"}], ";", "g", ";", "h", "  "}]}]],
       AutoSpacing->False],
      CD[-a][
       CD[h][
        CD[g][
         RiemannCD[-c, e, -e, f]]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "b", "   "}], 
        RowBox[{
         RowBox[{"bc", " ", "d"}], ";", "a"}]],
       AutoSpacing->False],
      CD[a][
       RiemannCD[b, c, -b, d]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "b", " "}], 
        RowBox[{"bc", " ", "d"}]],
       AutoSpacing->False],
      RiemannCD[b, c, -b, d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "e"}], "     ", ";", "a", "  "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"e", " ", "f"}], ";", "g", ";", "h", "  ", ";", "a"}]}]],
       AutoSpacing->False],
      CD[a][
       CD[-a][
        CD[h][
         CD[g][
          RiemannCD[-c, e, -e, f]]]]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"b", " ", ";", "a"}]}], 
        RowBox[{"bc", " ", "d", "  "}]],
       AutoSpacing->False],
      CD[-a][
       RiemannCD[b, c, -b, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"c", " ", "e", "       "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"e", " ", "f"}], ";", "g", ";", "h", ";", "a"}]}]],
       AutoSpacing->False],
      CD[a][
       CD[h][
        CD[g][
         RiemannCD[-c, e, -e, f]]]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"b", " ", ";", "a", "  "}]}], 
        RowBox[{
         RowBox[{"bc", " ", "d"}], "  ", ";", "a"}]],
       AutoSpacing->False],
      CD[a][
       CD[-a][
        RiemannCD[b, c, -b, d]]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"c", " ", "e", "     "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"e", " ", "f"}], ";", "g", ";", "h"}]}]],
       AutoSpacing->False],
      CD[h][
       CD[g][
        RiemannCD[-c, e, -e, f]]],
      Editable->False]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"b77d72a6-2131-44b2-a405-f63ca524d248"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr1", "=", 
  RowBox[{
  "RiemannToInv", "[", "%", 
   "]"}]}]], "Input",ExpressionUUID->"7404a46a-0a74-4f04-970b-54b3b7d42d7b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"54c1f0b4-5182-4946-8cf9-aae9b16298f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"14b3ce21-0ecb-4887-b3c5-e4f364306b56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"67f02b04-cc19-4338-9838-dc7bb952f01a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\<\"D\"\>", "\<\"04,7\"\>"], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"D\"\>", "\<\"13,27\"\>"]}], "+", 
  SubscriptBox["\<\"D\"\>", "\<\"22,6\"\>"]}]], \
"Output",ExpressionUUID->"37884a84-81cf-42af-9848-8219c7d75fb4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CD", "[", "a", "]"}], "@", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "@", 
   RowBox[{"NoScalar", "@", 
    RowBox[{
    "InvToRiemann", "[", "invar2", 
     "]"}]}]}]}]], \
"Input",ExpressionUUID->"6a75b238-43b5-45e0-b5bc-7712e0ed57fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  InterpretationBox[
   StyleBox[
    SubsuperscriptBox["\[Epsilon]", "dfgi", "    "],
    AutoSpacing->False],
   epsilonmetric[-d, -f, -g, -i],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"e", " ", "h", " "}], 
           RowBox[{" ", 
            RowBox[{"h", " ", "i"}]}]],
          AutoSpacing->False],
         RiemannCD[-e, h, -h, i],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"c", "   ", ";", "a"}], 
           RowBox[{" ", "efg", "  "}]],
          AutoSpacing->False],
         CD[-a][
          RiemannCD[-c, e, f, g]],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"c", "   "}], 
           RowBox[{" ", "efg"}]],
          AutoSpacing->False],
         RiemannCD[-c, e, f, g],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{
            RowBox[{"e", " ", "h"}], " ", ";", "a"}], 
           RowBox[{" ", 
            RowBox[{"h", " ", "i", "  "}]}]],
          AutoSpacing->False],
         CD[-a][
          RiemannCD[-e, h, -h, i]],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "b", "   "}], 
        RowBox[{
         RowBox[{"bc", " ", "d"}], ";", "a"}]],
       AutoSpacing->False],
      CD[a][
       RiemannCD[b, c, -b, d]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"e", " ", "h", " "}], 
        RowBox[{" ", 
         RowBox[{"h", " ", "i"}]}]],
       AutoSpacing->False],
      RiemannCD[-e, h, -h, i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"b", " ", ";", "a"}]}], 
        RowBox[{"bc", " ", "d", "  "}]],
       AutoSpacing->False],
      CD[-a][
       RiemannCD[b, c, -b, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"c", "     "}], 
        RowBox[{" ", 
         RowBox[{"efg", ";", "a"}]}]],
       AutoSpacing->False],
      CD[a][
       RiemannCD[-c, e, f, g]],
      Editable->False]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"c", "   "}], 
        RowBox[{" ", "efg"}]],
       AutoSpacing->False],
      RiemannCD[-c, e, f, g],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"  ", 
            RowBox[{"b", " ", ";", "a"}]}], 
           RowBox[{"bc", " ", "d", "  "}]],
          AutoSpacing->False],
         CD[-a][
          RiemannCD[b, c, -b, d]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"e", " ", "h", "   "}], 
           RowBox[{" ", 
            RowBox[{
             RowBox[{"h", " ", "i"}], ";", "a"}]}]],
          AutoSpacing->False],
         CD[a][
          RiemannCD[-e, h, -h, i]],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"e", " ", "h", " "}], 
           RowBox[{" ", 
            RowBox[{"h", " ", "i"}]}]],
          AutoSpacing->False],
         RiemannCD[-e, h, -h, i],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"  ", 
            RowBox[{"b", " ", ";", "a", "  "}]}], 
           RowBox[{
            RowBox[{"bc", " ", "d"}], "  ", ";", "a"}]],
          AutoSpacing->False],
         CD[a][
          CD[-a][
           RiemannCD[b, c, -b, d]]],
         Editable->False]}]}], ")"}]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "b", " "}], 
        RowBox[{"bc", " ", "d"}]],
       AutoSpacing->False],
      RiemannCD[b, c, -b, d],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{
            RowBox[{"e", " ", "h"}], " ", ";", "a"}], 
           RowBox[{" ", 
            RowBox[{"h", " ", "i", "  "}]}]],
          AutoSpacing->False],
         CD[-a][
          RiemannCD[-e, h, -h, i]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"c", "     "}], 
           RowBox[{" ", 
            RowBox[{"efg", ";", "a"}]}]],
          AutoSpacing->False],
         CD[a][
          RiemannCD[-c, e, f, g]],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"c", "   ", ";", "a"}], 
           RowBox[{" ", "efg", "  "}]],
          AutoSpacing->False],
         CD[-a][
          RiemannCD[-c, e, f, g]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"e", " ", "h", "   "}], 
           RowBox[{" ", 
            RowBox[{
             RowBox[{"h", " ", "i"}], ";", "a"}]}]],
          AutoSpacing->False],
         CD[a][
          RiemannCD[-e, h, -h, i]],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"e", " ", "h", " "}], 
           RowBox[{" ", 
            RowBox[{"h", " ", "i"}]}]],
          AutoSpacing->False],
         RiemannCD[-e, h, -h, i],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"c", "   ", ";", "a", "  "}], 
           RowBox[{" ", 
            RowBox[{"efg", "  ", ";", "a"}]}]],
          AutoSpacing->False],
         CD[a][
          CD[-a][
           RiemannCD[-c, e, f, g]]],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{"c", "   "}], 
           RowBox[{" ", "efg"}]],
          AutoSpacing->False],
         RiemannCD[-c, e, f, g],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          SubsuperscriptBox["R", 
           RowBox[{
            RowBox[{"e", " ", "h"}], " ", ";", "a", "  "}], 
           RowBox[{" ", 
            RowBox[{
             RowBox[{"h", " ", "i"}], "  ", ";", "a"}]}]],
          AutoSpacing->False],
         CD[a][
          CD[-a][
           RiemannCD[-e, h, -h, i]]],
         Editable->False]}]}], ")"}]}]}], 
   ")"}]}]], "Output",ExpressionUUID->"500a4e40-5a1f-40b0-bc49-c644c324d3c7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr2", "=", 
  RowBox[{
  "RiemannToInv", "[", "%", 
   "]"}]}]], "Input",ExpressionUUID->"3e5560b6-cf18-4203-afc9-20ce72573a6e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"69dc6aec-890b-4c7b-ba79-361c15b394ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"7f219b2e-d522-45a6-b047-09aaf39955fb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SubscriptBox["\<\"D\"\>", "\<\"002,14\"\>"]}], "+", 
  FractionBox[
   SubscriptBox["\<\"D\"\>", "\<\"002,16\"\>"], "2"], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"D\"\>", "\<\"011,68\"\>"]}], "+", 
  SubscriptBox["\<\"D\"\>", "\<\"011,102\"\>"]}]], \
"Output",ExpressionUUID->"73b0092a-a5aa-4389-b84f-302b2f005b1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvSimplify", "[", 
   RowBox[{"expr1", "-", "expr2"}], "]"}], "//", 
  "Simplify"}]], \
"Input",ExpressionUUID->"50d5e0b4-0616-4144-b2d2-0421a43d7d0d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"5989d428-7a94-4a28-8be3-ae62da7ff726"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"cfd43118-d880-486d-b579-604500a26d90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"42becac6-1f77-48b7-9a9f-4f37bf02504a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"47242561-2149-4c2b-af4b-15fe68e87df2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"3aa5192f-d428-401b-93ee-130f88805edb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"5e34f538-7884-4966-9f2f-042a7b985687"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"383d93c5-1a71-4301-884f-02c8249acefd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"dd10731d-857a-4713-8ce1-9489a2841dae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"e88d12c5-fac9-4e9f-949a-81874b0fac5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e1ee48c9-e43a-4354-80aa-e713579b0e71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"f80883fb-bae7-491e-82db-1dfcb4b8a970"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"05517c31-2fcb-4747-b6a2-18fc8ec62e0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"f49e4045-67ae-4c56-b20d-56c472a6e6dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"fd074a1f-9561-4759-8944-1dae81b7a258"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5c94dd92-2d32-4cbc-87de-526405262aeb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"44e0804f-c9d4-4d5a-b7dc-ba68fa94112a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"180f3ce3-2921-4a38-9714-981292d08959"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"1b18ee41-9d1a-45b8-a326-e0e48d379821"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"062e806c-db09-4d7e-9812-ff7d0b4c70be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"1ad99ffd-d52f-4361-96a0-1d08559b6d98"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"1a224468-c30a-471a-b457-6ad03c57a0ed"]
}, Open  ]],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"7b8366fc-b4f3-4dee-bc29-5263d9e0588d"]
}, Open  ]],

Cell["Second example:", \
"Text",ExpressionUUID->"77b31c34-0a2e-4ec6-92e0-fb15088bf25b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$CurvatureRelations", "=", "False"}], 
  ";"}]], "Input",ExpressionUUID->"857ec0f8-5325-46c7-ba12-1239e46d781f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}], ":=", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   RowBox[{"xAct`Invar`Private`RicciToRiemann", "[", 
    RowBox[{"RicciCD", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"3524061d-a757-435f-83fc-933ec64e4766"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"a_", ",", "b__"}], "]"}], "[", "exp_", "]"}], ":=", 
  RowBox[{
   RowBox[{"CD", "[", "a", "]"}], "[", 
   RowBox[{
    RowBox[{"CD", "[", "b", "]"}], "[", "exp", "]"}], 
   "]"}]}]], "Input",ExpressionUUID->"fb3b93ac-f5ae-491b-aec3-7f38f92f2bd4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IndicesOf", "[", "]"}], "[", "expr", 
  "]"}]], "Input",ExpressionUUID->"c0b53a72-8413-4d8a-b2d9-aa13ddf4581f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "f5"}], ",", 
   RowBox[{"-", "d2"}], ",", 
   RowBox[{"-", "b4"}], ",", 
   RowBox[{"-", "c1"}], ",", 
   RowBox[{"-", "g9"}], ",", 
   RowBox[{"-", "f4"}], ",", "f9", ",", "b4", ",", "c1", ",", 
   RowBox[{"-", "f9"}], ",", 
   RowBox[{"-", "a"}], ",", "g9", ",", "f5", ",", "f4", ",", "d2", ",", "a"}],
   "}"}]], "Output",ExpressionUUID->"9ed73262-2cf2-46c4-aaca-e92d14ba929a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{"HoldComplete", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", "a", "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"g9", ",", "f5", ",", "f4", ",", "d2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "f9"}], ",", "c1"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "g9"}], ",", 
         RowBox[{"-", "f4"}], ",", "f9", ",", "b4"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "d2"}], ",", 
        RowBox[{"-", "b4"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{"R", "[", 
       RowBox[{"g9", ",", "f5", ",", "f4", ",", "d2"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "f9"}], ",", "c1"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "g9"}], ",", 
         RowBox[{"-", "f4"}], ",", "f9", ",", "b4"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "d2"}], ",", 
        RowBox[{"-", "b4"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", "h2"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"d3", ",", "f5", ",", "a0", ",", "z"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "f9"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "d3"}], ",", "f9", ",", 
         RowBox[{"-", "h2"}], ",", "c1"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "a0"}], ",", 
        RowBox[{"-", "z"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", "h2", "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"d3", ",", "f5", ",", "a0", ",", "z"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "f9"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "d3"}], ",", "f9", ",", 
         RowBox[{"-", "h2"}], ",", "c1"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "a0"}], ",", 
        RowBox[{"-", "z"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", "b8"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"d3", ",", "f5", ",", "b7", ",", "d2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b8"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "d3"}], ",", "g6", ",", 
         RowBox[{"-", "b7"}], ",", "c1"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "d2"}], ",", 
        RowBox[{"-", "g6"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"CD", "[", "b8", "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"d3", ",", "f5", ",", "b7", ",", "d2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b8"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "d3"}], ",", "g6", ",", 
         RowBox[{"-", "b7"}], ",", "c1"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "d2"}], ",", 
        RowBox[{"-", "g6"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"CD", "[", "a", "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"g9", ",", "f5", ",", "h1", ",", "d2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "e6"}], ",", "e6"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "g9"}], ",", "b0", ",", 
         RowBox[{"-", "h1"}], ",", "e5"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "d2"}], ",", 
        RowBox[{"-", "b0"}], ",", 
        RowBox[{"-", "e5"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"g9", ",", "f5", ",", "h1", ",", "d2"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "e6"}], ",", "e6"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "g9"}], ",", "b0", ",", 
         RowBox[{"-", "h1"}], ",", "e5"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "d2"}], ",", 
        RowBox[{"-", "b0"}], ",", 
        RowBox[{"-", "e5"}]}], "]"}]}], "-", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", "c7"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"d3", ",", "c5", ",", "h9", ",", "f2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "h9"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "d3"}], ",", "g6", ",", 
         RowBox[{"-", "c5"}], ",", "c1"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f2"}], ",", 
        RowBox[{"-", "c7"}], ",", 
        RowBox[{"-", "g6"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"CD", "[", "c7", "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"d3", ",", "c5", ",", "h9", ",", "f2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "h9"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "d3"}], ",", "g6", ",", 
         RowBox[{"-", "c5"}], ",", "c1"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f2"}], ",", 
        RowBox[{"-", "c7"}], ",", 
        RowBox[{"-", "g6"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", "b8"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"f3", ",", "f2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b8"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "f3"}], ",", "g7", ",", "b4", ",", "c1"}], "]"}], "]"}],
       "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f2"}], ",", 
        RowBox[{"-", "g7"}], ",", 
        RowBox[{"-", "b4"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", "b8", "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"f3", ",", "f2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b8"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "f3"}], ",", "g7", ",", "b4", ",", "c1"}], "]"}], "]"}],
       "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f2"}], ",", 
        RowBox[{"-", "g7"}], ",", 
        RowBox[{"-", "b4"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", "b8"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"d3", ",", "f5", ",", "a0", ",", "z"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b8"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "d3"}], ",", "c1"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "a0"}], ",", 
        RowBox[{"-", "z"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", "b8", "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"d3", ",", "f5", ",", "a0", ",", "z"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b8"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "d3"}], ",", "c1"}], "]"}], "]"}], "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "a0"}], ",", 
        RowBox[{"-", "z"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"CD", "[", "a", "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"g9", ",", "f5", ",", "i1", ",", "d2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "f9"}], ",", 
         RowBox[{"-", "i1"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "g9"}], ",", "b0", ",", "f9", ",", "e5"}], "]"}], "]"}],
       "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "d2"}], ",", 
        RowBox[{"-", "b0"}], ",", 
        RowBox[{"-", "e5"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"g9", ",", "f5", ",", "i1", ",", "d2"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "f9"}], ",", 
         RowBox[{"-", "i1"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "g9"}], ",", "b0", ",", "f9", ",", "e5"}], "]"}], "]"}],
       "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f5"}], ",", 
        RowBox[{"-", "d2"}], ",", 
        RowBox[{"-", "b0"}], ",", 
        RowBox[{"-", "e5"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "g9"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"g9", ",", "f3", ",", "h9", ",", "f2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "h9"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "f3"}], ",", "g7", ",", "b4", ",", "c1"}], "]"}], "]"}],
       "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f2"}], ",", 
        RowBox[{"-", "g7"}], ",", 
        RowBox[{"-", "b4"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "g9"}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{"g9", ",", "f3", ",", "h9", ",", "f2"}], "]"}], "]"}], "*", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "h9"}]}], "]"}], "[", 
       RowBox[{"R", "[", 
        RowBox[{
         RowBox[{"-", "f3"}], ",", "g7", ",", "b4", ",", "c1"}], "]"}], "]"}],
       "*", 
      RowBox[{"epsilonmetric", "[", 
       RowBox[{
        RowBox[{"-", "f2"}], ",", 
        RowBox[{"-", "g7"}], ",", 
        RowBox[{"-", "b4"}], ",", 
        RowBox[{"-", "c1"}]}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"3870c13d-1862-45b3-b5a0-b3edfa465caa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "@", 
  RowBox[{"Flatten", "@", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{
      RowBox[{"epsilonmetric", "[", "inds__", "]"}], "\[Rule]", 
      RowBox[{"{", "inds", "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"9caedf7b-2fd8-4a27-a76e-5191a7eda2c3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "a0"}], ",", 
   RowBox[{"-", "b0"}], ",", 
   RowBox[{"-", "b4"}], ",", 
   RowBox[{"-", "c1"}], ",", 
   RowBox[{"-", "c7"}], ",", 
   RowBox[{"-", "d2"}], ",", 
   RowBox[{"-", "e5"}], ",", 
   RowBox[{"-", "f2"}], ",", 
   RowBox[{"-", "f5"}], ",", 
   RowBox[{"-", "g6"}], ",", 
   RowBox[{"-", "g7"}], ",", 
   RowBox[{"-", "z"}]}], 
  "}"}]], "Output",ExpressionUUID->"7216dcd8-dbb9-4637-948c-108cf1032541"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "@", 
  RowBox[{"Flatten", "@", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{
      RowBox[{"R", "[", "inds__", "]"}], "\[Rule]", 
      RowBox[{"{", "inds", "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"80c973bd-3a49-45ba-a29e-89c9435907b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a0", ",", "b0", ",", "b4", ",", 
   RowBox[{"-", "b7"}], ",", "b7", ",", "c1", ",", 
   RowBox[{"-", "c5"}], ",", "c5", ",", "d2", ",", 
   RowBox[{"-", "d3"}], ",", "d3", ",", "e5", ",", "f2", ",", 
   RowBox[{"-", "f3"}], ",", "f3", ",", 
   RowBox[{"-", "f4"}], ",", "f4", ",", "f5", ",", "f9", ",", "g6", ",", "g7",
    ",", 
   RowBox[{"-", "g9"}], ",", "g9", ",", 
   RowBox[{"-", "h1"}], ",", "h1", ",", 
   RowBox[{"-", "h2"}], ",", "h9", ",", "i1", ",", "z"}], 
  "}"}]], "Output",ExpressionUUID->"aa1bd0cc-aa08-44bb-a248-5eb9d808230a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "@", 
  RowBox[{"Flatten", "@", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{
      RowBox[{"CD", "[", "inds__", "]"}], "\[Rule]", 
      RowBox[{"{", "inds", "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"71a775aa-a520-4eac-90f7-766aefd4a061"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "a"}], ",", "a", ",", 
   RowBox[{"-", "b8"}], ",", "b8", ",", "c1", ",", "c7", ",", 
   RowBox[{"-", "e6"}], ",", "e6", ",", 
   RowBox[{"-", "f9"}], ",", 
   RowBox[{"-", "g9"}], ",", "h2", ",", 
   RowBox[{"-", "h9"}], ",", 
   RowBox[{"-", "i1"}]}], 
  "}"}]], "Output",ExpressionUUID->"5599d450-9d41-46db-acc0-b244694e0d42"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"Union", "[", 
    RowBox[{"%", ",", "%%", ",", "%%%"}], "]"}], ",", "_Symbol"}], 
  "]"}]], "Input",ExpressionUUID->"ec9bbe34-e97c-43a6-b4b6-8d7ac9810469"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "a0", ",", "b0", ",", "b4", ",", "b7", ",", "b8", ",", "c1", ",", 
   "c5", ",", "c7", ",", "d2", ",", "d3", ",", "e5", ",", "e6", ",", "f2", ",",
    "f3", ",", "f4", ",", "f5", ",", "f9", ",", "g6", ",", "g7", ",", "g9", ",",
    "h1", ",", "h2", ",", "h9", ",", "i1", ",", "z"}], 
  "}"}]], "Output",ExpressionUUID->"3500b3e9-5165-4790-a9ae-673d2a469a58"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{"%", ",", "1"}], 
  "]"}]], "Input",ExpressionUUID->"1e00d24a-e73e-47ca-a6d8-c98bbf5112c9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a0", ",", "b0", ",", "b4", ",", "b7", ",", "b8", ",", "c1", ",", "c5", ",",
    "c7", ",", "d2", ",", "d3", ",", "e5", ",", "e6", ",", "f2", ",", "f3", ",",
    "f4", ",", "f5", ",", "f9", ",", "g6", ",", "g7", ",", "g9", ",", "h1", ",",
    "h2", ",", "h9", ",", "i1", ",", "z"}], 
  "}"}]], "Output",ExpressionUUID->"5ca74851-3006-4538-a461-d22cf6285df5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{"%", ",", 
   RowBox[{"-", "1"}]}], 
  "]"}]], "Input",ExpressionUUID->"4e78539f-6771-4b0b-86c4-1a41ffd12bc5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a0", ",", "b0", ",", "b4", ",", "b7", ",", "b8", ",", "c1", ",", "c5", ",",
    "c7", ",", "d2", ",", "d3", ",", "e5", ",", "e6", ",", "f2", ",", "f3", ",",
    "f4", ",", "f5", ",", "f9", ",", "g6", ",", "g7", ",", "g9", ",", "h1", ",",
    "h2", ",", "h9", ",", "i1"}], 
  "}"}]], "Output",ExpressionUUID->"40dfd137-6b90-4b75-b3f8-adef3d981866"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"AddIndices", "[", 
  RowBox[{"TangentM", ",", "%"}], 
  "]"}]], "Input",ExpressionUUID->"312ee6f0-67eb-4a83-a9da-7262daad0329"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndicesOfVBundle", "[", "TangentM", 
  "]"}]], "Input",ExpressionUUID->"67eecaa8-1c36-499f-8596-26cb121bc7fd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h",
      ",", "i", ",", "j", ",", "k", ",", "l", ",", "m", ",", "n", ",", "o", ",",
      "p", ",", "q", ",", "a0", ",", "b0", ",", "b4", ",", "b7", ",", "b8", ",",
      "c1", ",", "c5", ",", "c7", ",", "d2", ",", "d3", ",", "e5", ",", "e6", 
     ",", "f2", ",", "f3", ",", "f4", ",", "f5", ",", "f9", ",", "g6", ",", 
     "g7", ",", "g9", ",", "h1", ",", "h2", ",", "h9", ",", "i1"}], "}"}], ",", 
   RowBox[{"{", "}"}]}], 
  "}"}]], "Output",ExpressionUUID->"d6f18b4b-f82b-4dbc-84bc-4e0f141343f5"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}], ":=", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   RowBox[{"xAct`Invar`Private`RicciToRiemann", "[", 
    RowBox[{
     RowBox[{"RicciCD", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", "CD"}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"3750dcbd-7b3e-4bb9-b9ca-51e1bea8a287"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr2", "=", 
  RowBox[{
  "ReleaseHold", "[", "expr", 
   "]"}]}]], "Input",ExpressionUUID->"9b5c20c4-39fb-4aa7-80ee-33501416dbd0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5d2b4c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f5, -d2, -b4, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"g9f4", "       ", ";", "f9", ";", "a"}], 
      RowBox[{"    ", 
       RowBox[{"f9b4", ";", "c1", "     "}]}]],
     AutoSpacing->False],
    CD[-a][
     CD[-f9][
      CD[c1][
       RiemannCD[-g9, -f4, f9, b4]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"g9f5f4d2", ";", "a"}]],
     AutoSpacing->False],
    CD[a][
     RiemannCD[g9, f5, f4, d2]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5d2b0e5", "        "],
     AutoSpacing->False],
    epsilonmetric[-f5, -d2, -b0, -e5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"g9", "  ", "h1"}], "     ", ";", "e6", ";", "a"}], 
      RowBox[{"  ", 
       RowBox[{
        RowBox[{"b0", "  ", "e5"}], ";", "e6", "     "}]}]],
     AutoSpacing->False],
    CD[-a][
     CD[-e6][
      CD[e6][
       RiemannCD[-g9, b0, -h1, e5]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"g9f5h1d2", ";", "a"}]],
     AutoSpacing->False],
    CD[a][
     RiemannCD[g9, f5, h1, d2]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5d2b0e5", "        "],
     AutoSpacing->False],
    epsilonmetric[-f5, -d2, -b0, -e5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"g9", "      ", ";", "i1", ";", "f9", ";", "a"}], 
      RowBox[{"  ", "b0f9e5", "        "}]],
     AutoSpacing->False],
    CD[-a][
     CD[-f9][
      CD[-i1][
       RiemannCD[-g9, b0, f9, e5]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"g9f5i1d2", ";", "a"}]],
     AutoSpacing->False],
    CD[a][
     RiemannCD[g9, f5, i1, d2]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5d2b0e5", "        "],
     AutoSpacing->False],
    epsilonmetric[-f5, -d2, -b0, -e5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "        ", "g9f5h1d2"],
     AutoSpacing->False],
    RiemannCD[g9, f5, h1, d2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"g9", "  ", "h1"}], "     ", ";", "e6", ";", "a", "  "}], 
      RowBox[{"  ", 
       RowBox[{
        RowBox[{"b0", "  ", "e5"}], ";", "e6", "     ", ";", "a"}]}]],
     AutoSpacing->False],
    CD[a][
     CD[-a][
      CD[-e6][
       CD[e6][
        RiemannCD[-g9, b0, -h1, e5]]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5d2b4c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f5, -d2, -b4, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "        ", "g9f5f4d2"],
     AutoSpacing->False],
    RiemannCD[g9, f5, f4, d2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"g9f4", "       ", ";", "f9", ";", "a", "  "}], 
      RowBox[{"    ", 
       RowBox[{"f9b4", ";", "c1", "     ", ";", "a"}]}]],
     AutoSpacing->False],
    CD[a][
     CD[-a][
      CD[-f9][
       CD[c1][
        RiemannCD[-g9, -f4, f9, b4]]]]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5d2b0e5", "        "],
     AutoSpacing->False],
    epsilonmetric[-f5, -d2, -b0, -e5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "        ", "g9f5i1d2"],
     AutoSpacing->False],
    RiemannCD[g9, f5, i1, d2],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"g9", "      ", ";", "i1", ";", "f9", ";", "a", "  "}], 
      RowBox[{"  ", 
       RowBox[{"b0f9e5", "        ", ";", "a"}]}]],
     AutoSpacing->False],
    CD[a][
     CD[-a][
      CD[-f9][
       CD[-i1][
        RiemannCD[-g9, b0, f9, e5]]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5a0zc1", "       "],
     AutoSpacing->False],
    epsilonmetric[-f5, -a0, -z, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"d3b", "   ", ";", "b8", ";", "a"}], 
      RowBox[{"   ", "c1b", "     "}]],
     AutoSpacing->False],
    CD[-a][
     CD[-b8][
      RiemannCD[-d3, -b, c1, b]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "            ", 
      RowBox[{"d3f5a0z", ";", "b8", ";", "a"}]],
     AutoSpacing->False],
    CD[a][
     CD[b8][
      RiemannCD[d3, f5, a0, z]]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5d2g6c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f5, -d2, -g6, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"d3", "  ", "b7"}], "  ", ";", "b8", ";", "a"}], 
      RowBox[{"  ", 
       RowBox[{"g6", "  ", "c1", "     "}]}]],
     AutoSpacing->False],
    CD[-a][
     CD[-b8][
      RiemannCD[-d3, g6, -b7, c1]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "             ", 
      RowBox[{"d3f5b7d2", ";", "b8", ";", "a"}]],
     AutoSpacing->False],
    CD[a][
     CD[b8][
      RiemannCD[d3, f5, b7, d2]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f2g7b4c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f2, -g7, -b4, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"f3", "      ", ";", "b8", ";", "a"}], 
      RowBox[{"  ", "g7b4c1", "     "}]],
     AutoSpacing->False],
    CD[-a][
     CD[-b8][
      RiemannCD[-f3, g7, b4, c1]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"  ", "a0", "         "}], 
      RowBox[{
       RowBox[{"f3", "  ", "f2a0"}], ";", "b8", ";", "a"}]],
     AutoSpacing->False],
    CD[a][
     CD[b8][
      RiemannCD[f3, -a0, f2, a0]]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f2c7g6c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f2, -c7, -g6, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"d3", "  ", "c5"}], "  ", ";", "h9", ";", "a"}], 
      RowBox[{"  ", 
       RowBox[{"g6", "  ", "c1", "     "}]}]],
     AutoSpacing->False],
    CD[-a][
     CD[-h9][
      RiemannCD[-d3, g6, -c5, c1]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "             ", 
      RowBox[{"d3c5h9f2", ";", "c7", ";", "a"}]],
     AutoSpacing->False],
    CD[a][
     CD[c7][
      RiemannCD[d3, c5, h9, f2]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f2g7b4c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f2, -g7, -b4, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"f3", "      ", ";", "h9", ";", "a"}], 
      RowBox[{"  ", "g7b4c1", "     "}]],
     AutoSpacing->False],
    CD[-a][
     CD[-h9][
      RiemannCD[-f3, g7, b4, c1]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"        ", 
       RowBox[{";", "g9", "  "}]}], 
      RowBox[{"g9f3h9f2", "   ", ";", "a"}]],
     AutoSpacing->False],
    CD[a][
     CD[-g9][
      RiemannCD[g9, f3, h9, f2]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5a0zc1", "       "],
     AutoSpacing->False],
    epsilonmetric[-f5, -a0, -z, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"d3", "  ", "h2"}], "  ", ";", "f9", ";", "a"}], 
      RowBox[{"  ", 
       RowBox[{"f9", "  ", "c1", "     "}]}]],
     AutoSpacing->False],
    CD[-a][
     CD[-f9][
      RiemannCD[-d3, f9, -h2, c1]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "            ", 
      RowBox[{"d3f5a0z", ";", "h2", ";", "a"}]],
     AutoSpacing->False],
    CD[a][
     CD[h2][
      RiemannCD[d3, f5, a0, z]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5a0zc1", "       "],
     AutoSpacing->False],
    epsilonmetric[-f5, -a0, -z, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"d3b", "   ", ";", "b8", ";", "a", "  "}], 
      RowBox[{"   ", 
       RowBox[{"c1b", "     ", ";", "a"}]}]],
     AutoSpacing->False],
    CD[a][
     CD[-a][
      CD[-b8][
       RiemannCD[-d3, -b, c1, b]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"d3f5a0z", ";", "b8"}]],
     AutoSpacing->False],
    CD[b8][
     RiemannCD[d3, f5, a0, z]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5d2g6c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f5, -d2, -g6, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"d3", "  ", "b7"}], "  ", ";", "b8", ";", "a", "  "}], 
      RowBox[{"  ", 
       RowBox[{
        RowBox[{"g6", "  ", "c1"}], "     ", ";", "a"}]}]],
     AutoSpacing->False],
    CD[a][
     CD[-a][
      CD[-b8][
       RiemannCD[-d3, g6, -b7, c1]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "           ", 
      RowBox[{"d3f5b7d2", ";", "b8"}]],
     AutoSpacing->False],
    CD[b8][
     RiemannCD[d3, f5, b7, d2]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f2g7b4c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f2, -g7, -b4, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"f3", "      ", ";", "b8", ";", "a", "  "}], 
      RowBox[{"  ", 
       RowBox[{"g7b4c1", "     ", ";", "a"}]}]],
     AutoSpacing->False],
    CD[a][
     CD[-a][
      CD[-b8][
       RiemannCD[-f3, g7, b4, c1]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"  ", "a0", "       "}], 
      RowBox[{
       RowBox[{"f3", "  ", "f2a0"}], ";", "b8"}]],
     AutoSpacing->False],
    CD[b8][
     RiemannCD[f3, -a0, f2, a0]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f2c7g6c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f2, -c7, -g6, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"d3", "  ", "c5"}], "  ", ";", "h9", ";", "a", "  "}], 
      RowBox[{"  ", 
       RowBox[{
        RowBox[{"g6", "  ", "c1"}], "     ", ";", "a"}]}]],
     AutoSpacing->False],
    CD[a][
     CD[-a][
      CD[-h9][
       RiemannCD[-d3, g6, -c5, c1]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "           ", 
      RowBox[{"d3c5h9f2", ";", "c7"}]],
     AutoSpacing->False],
    CD[c7][
     RiemannCD[d3, c5, h9, f2]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f2g7b4c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-f2, -g7, -b4, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"f3", "      ", ";", "h9", ";", "a", "  "}], 
      RowBox[{"  ", 
       RowBox[{"g7b4c1", "     ", ";", "a"}]}]],
     AutoSpacing->False],
    CD[a][
     CD[-a][
      CD[-h9][
       RiemannCD[-f3, g7, b4, c1]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"        ", 
       RowBox[{";", "g9"}]}], 
      RowBox[{"g9f3h9f2", "   "}]],
     AutoSpacing->False],
    CD[-g9][
     RiemannCD[g9, f3, h9, f2]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "f5a0zc1", "       "],
     AutoSpacing->False],
    epsilonmetric[-f5, -a0, -z, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"d3", "  ", "h2"}], "  ", ";", "f9", ";", "a", "  "}], 
      RowBox[{"  ", 
       RowBox[{
        RowBox[{"f9", "  ", "c1"}], "     ", ";", "a"}]}]],
     AutoSpacing->False],
    CD[a][
     CD[-a][
      CD[-f9][
       RiemannCD[-d3, f9, -h2, c1]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"d3f5a0z", ";", "h2"}]],
     AutoSpacing->False],
    CD[h2][
     RiemannCD[d3, f5, a0, z]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"236bbe43-e16b-49a5-aafc-ef82e5fd4ff6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr2", "//", 
  "ToCanonical"}]], \
"Input",ExpressionUUID->"36f520ce-04da-467a-88dc-8e3366e89a65"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b4c1c5", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b4, -c1, -c5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"ab0", "       ", ";", "b8", ";", "b7"}], 
      RowBox[{"   ", 
       RowBox[{"b8c1", ";", "c5", "      "}]}]],
     AutoSpacing->False],
    CD[-b7][
     CD[-b8][
      CD[c5][
       RiemannCD[-a, -b0, b8, c1]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"aa0b0b4", ";", "b7"}]],
     AutoSpacing->False],
    CD[b7][
     RiemannCD[a, a0, b0, b4]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b4b8c5", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b4, -b8, -c5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"a", "      ", ";", "b0", ";", "c1", ";", "b7"}], 
      RowBox[{" ", "b8c1c5", "         "}]],
     AutoSpacing->False],
    CD[-b7][
     CD[-c1][
      CD[-b0][
       RiemannCD[-a, b8, c1, c5]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"aa0b0b4", ";", "b7"}]],
     AutoSpacing->False],
    CD[b7][
     RiemannCD[a, a0, b0, b4]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b4b8c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b4, -b8, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"a", "  ", "b0"}], "     ", ";", "c5", ";", "b7"}], 
      RowBox[{" ", 
       RowBox[{
        RowBox[{"b8", "  ", "c1"}], ";", "c5", "      "}]}]],
     AutoSpacing->False],
    CD[-b7][
     CD[-c5][
      CD[c5][
       RiemannCD[-a, b8, -b0, c1]]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"aa0b0b4", ";", "b7"}]],
     AutoSpacing->False],
    CD[b7][
     RiemannCD[a, a0, b0, b4]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "b4b8c1c5", "        "],
     AutoSpacing->False],
    epsilonmetric[-b4, -b8, -c1, -c5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"a0", "      ", ";", "b0", ";", "b7"}], 
      RowBox[{"  ", "b8c1c5", "      "}]],
     AutoSpacing->False],
    CD[-b7][
     CD[-b0][
      RiemannCD[-a0, b8, c1, c5]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"       ", 
       RowBox[{";", "a", "   "}]}], 
      RowBox[{"aa0b0b4", "  ", ";", "b7"}]],
     AutoSpacing->False],
    CD[b7][
     CD[-a][
      RiemannCD[a, a0, b0, b4]]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "b0b8c1c5", "        "],
     AutoSpacing->False],
    epsilonmetric[-b0, -b8, -c1, -c5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"a0", "      ", ";", "b4", ";", "b7"}], 
      RowBox[{"  ", "b8c1c5", "      "}]],
     AutoSpacing->False],
    CD[-b7][
     CD[-b4][
      RiemannCD[-a0, b8, c1, c5]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"   ", "a", "        "}], 
      RowBox[{
       RowBox[{"aa0", " ", "b0"}], ";", "b4", ";", "b7"}]],
     AutoSpacing->False],
    CD[b7][
     CD[b4][
      RiemannCD[a, a0, -a, b0]]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b4c1c5", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b4, -c1, -c5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"a", "  ", "b0"}], "  ", ";", "b7", ";", "b8"}], 
      RowBox[{" ", 
       RowBox[{"c1", "  ", "c5", "      "}]}]],
     AutoSpacing->False],
    CD[-b8][
     CD[-b7][
      RiemannCD[-a, c1, -b0, c5]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "             ", 
      RowBox[{"aa0b0b4", ";", "b7", ";", "b8"}]],
     AutoSpacing->False],
    CD[b8][
     CD[b7][
      RiemannCD[a, a0, b0, b4]]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b4c1c5", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b4, -c1, -c5],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"ab0b7", "     ", ";", "b8"}], 
      RowBox[{"     ", 
       RowBox[{"c1", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-b8][
     CD[c5][
      RiemannCD[-a, -b0, -b7, c1]]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "             ", 
      RowBox[{"aa0b0b4", ";", "b7", ";", "b8"}]],
     AutoSpacing->False],
    CD[b8][
     CD[b7][
      RiemannCD[a, a0, b0, b4]]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "b4b7b8c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-b4, -b7, -b8, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"aa0b0b4", ";", "b7"}]],
     AutoSpacing->False],
    CD[b7][
     RiemannCD[a, a0, b0, b4]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"a", "  ", "a0"}], "  ", ";", "b0", "   ", ";", "c5"}], 
      RowBox[{" ", 
       RowBox[{
        RowBox[{"b8", "  ", "c1"}], "   ", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-c5][
     CD[c5][
      CD[-b0][
       RiemannCD[-a, b8, -a0, c1]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "b4b7b8c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-b4, -b7, -b8, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"       ", 
       RowBox[{";", "a"}]}], 
      RowBox[{"aa0b0b4", "  "}]],
     AutoSpacing->False],
    CD[-a][
     RiemannCD[a, a0, b0, b4]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"a0", "      ", ";", "b0", "   ", ";", "c5"}], 
      RowBox[{"  ", 
       RowBox[{"b7b8c1", "   ", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-c5][
     CD[c5][
      CD[-b0][
       RiemannCD[-a0, b7, b8, c1]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "b0b7b8c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-b0, -b7, -b8, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"   ", "a", "     "}], 
      RowBox[{
       RowBox[{"aa0", " ", "b0"}], ";", "b4"}]],
     AutoSpacing->False],
    CD[b4][
     RiemannCD[a, a0, -a, b0]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"a0", "      ", ";", "b4", "   ", ";", "c5"}], 
      RowBox[{"  ", 
       RowBox[{"b7b8c1", "   ", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-c5][
     CD[c5][
      CD[-b4][
       RiemannCD[-a0, b7, b8, c1]]]],
    Editable->False]}], "-", 
  RowBox[{"2", " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b4b8c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b4, -b8, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"aa0b0b4", ";", "b7"}]],
     AutoSpacing->False],
    CD[b7][
     RiemannCD[a, a0, b0, b4]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"a", "  ", "b0"}], "  ", ";", "b7", "   ", ";", "c5"}], 
      RowBox[{" ", 
       RowBox[{
        RowBox[{"b8", "  ", "c1"}], "   ", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-c5][
     CD[c5][
      CD[-b7][
       RiemannCD[-a, b8, -b0, c1]]]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b0b4c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b0, -b4, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"aa0b0b4", ";", "b7"}]],
     AutoSpacing->False],
    CD[b7][
     RiemannCD[a, a0, b0, b4]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"a", "  ", "b8"}], "  ", ";", "b7", "   ", ";", "c5"}], 
      RowBox[{" ", 
       RowBox[{
        RowBox[{"b8", "  ", "c1"}], "   ", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-c5][
     CD[c5][
      CD[-b7][
       RiemannCD[-a, b8, -b8, c1]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b4b8c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b4, -b8, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "       ", "aa0b0b4"],
     AutoSpacing->False],
    RiemannCD[a, a0, b0, b4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"ab0", "       ", ";", "b7", "   ", ";", "c5"}], 
      RowBox[{"   ", 
       RowBox[{"b7b8", ";", "c1", "   ", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-c5][
     CD[c5][
      CD[-b7][
       CD[c1][
        RiemannCD[-a, -b0, b7, b8]]]]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b0b4c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b0, -b4, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "          ", 
      RowBox[{"aa0b0b4", ";", "b7"}]],
     AutoSpacing->False],
    CD[b7][
     RiemannCD[a, a0, b0, b4]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"a", "  ", "b7"}], "  ", ";", "b8", "   ", ";", "c5"}], 
      RowBox[{" ", 
       RowBox[{
        RowBox[{"b8", "  ", "c1"}], "   ", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-c5][
     CD[c5][
      CD[-b8][
       RiemannCD[-a, b8, -b7, c1]]]],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b4b7c1", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b4, -b7, -c1],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "       ", "aa0b0b4"],
     AutoSpacing->False],
    RiemannCD[a, a0, b0, b4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"a", "      ", ";", "b0", ";", "b8", "   ", ";", "c5"}], 
      RowBox[{" ", 
       RowBox[{"b7b8c1", "      ", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-c5][
     CD[c5][
      CD[-b8][
       CD[-b0][
        RiemannCD[-a, b7, b8, c1]]]]],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "a0b4b7b8", "        "],
     AutoSpacing->False],
    epsilonmetric[-a0, -b4, -b7, -b8],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "       ", "aa0b0b4"],
     AutoSpacing->False],
    RiemannCD[a, a0, b0, b4],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{
       RowBox[{"a", "  ", "b0"}], "     ", ";", "c1", "   ", ";", "c5"}], 
      RowBox[{" ", 
       RowBox[{
        RowBox[{"b7", "  ", "b8"}], ";", "c1", "   ", ";", "c5", "   "}]}]],
     AutoSpacing->False],
    CD[-c5][
     CD[c5][
      CD[-c1][
       CD[c1][
        RiemannCD[-a, b7, -b0, b8]]]]],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"a79e5b1a-8ed1-4398-b884-719f663397d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"IndexList", "@@", 
    RowBox[{"First", "@", 
     RowBox[{"IndicesOfVBundle", "[", "TangentM", "]"}]}]}], ")"}], "[", 
  RowBox[{"[", 
   RowBox[{"Range", "[", "15", "]"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"87675357-3391-426a-a84b-6cbce770b94c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h", ",",
    "i", ",", "j", ",", "k", ",", "l", ",", "m", ",", "n", ",", "o"}], 
  "}"}]], "Output",ExpressionUUID->"b9863f60-45a8-46f6-85ab-712bf91d4f27"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", "expr2", 
  "]"}]], "Input",ExpressionUUID->"aef87271-6387-4db9-89a1-4f8d46cdab93"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SubscriptBox["\<\"D\"\>", "\<\"04,331\"\>"]}], "-", 
  FractionBox[
   SubscriptBox["\<\"D\"\>", "\<\"04,355\"\>"], "2"], "+", 
  SubscriptBox["\<\"D\"\>", "\<\"04,396\"\>"], "+", 
  FractionBox[
   SubscriptBox["\<\"D\"\>", "\<\"13,102\"\>"], "2"], "+", 
  FractionBox[
   SubscriptBox["\<\"D\"\>", "\<\"13,121\"\>"], "2"], "-", 
  FractionBox[
   SubscriptBox["\<\"D\"\>", "\<\"13,377\"\>"], "2"], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"D\"\>", "\<\"13,421\"\>"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"D\"\>", "\<\"13,425\"\>"]}], "-", 
  FractionBox[
   SubscriptBox["\<\"D\"\>", "\<\"13,429\"\>"], "2"], "-", 
  SubscriptBox["\<\"D\"\>", "\<\"13,435\"\>"], "-", 
  FractionBox[
   SubscriptBox["\<\"D\"\>", "\<\"13,693\"\>"], "2"], "+", 
  SubscriptBox["\<\"D\"\>", "\<\"13,842\"\>"], "+", 
  SubscriptBox["\<\"D\"\>", "\<\"22,153\"\>"], "-", 
  SubscriptBox["\<\"D\"\>", "\<\"22,308\"\>"], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"D\"\>", "\<\"22,437\"\>"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\<\"D\"\>", "\<\"22,473\"\>"]}]}]], \
"Output",ExpressionUUID->"e1a74f55-802a-40cc-b685-ca54c81d62fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"eb54f3cc-12b5-4bf8-a59f-3e3d8e7633b2"],

Cell["\<\
-DualRInv[metric][{0, 4}, 331] - 
 DualRInv[metric][{0, 4}, 355]/2 + 
 DualRInv[metric][{0, 4}, 396] + 
 DualRInv[metric][{1, 3}, 102]/2 + 
 DualRInv[metric][{1, 3}, 121]/2 - 
 DualRInv[metric][{1, 3}, 377]/2 - 
 2*DualRInv[metric][{1, 3}, 421] - 
 2*DualRInv[metric][{1, 3}, 425] - 
 DualRInv[metric][{1, 3}, 429]/2 - 
 DualRInv[metric][{1, 3}, 435] - 
 DualRInv[metric][{1, 3}, 693]/2 + 
 DualRInv[metric][{1, 3}, 842] + 
 DualRInv[metric][{2, 2}, 153] - 
 DualRInv[metric][{2, 2}, 308] - 
 2*DualRInv[metric][{2, 2}, 437] - 
 2*DualRInv[metric][{2, 2}, 473]\
\>", "Output",ExpressionUUID->"cd585d50-4dc9-41fd-ab25-8cc87edff1a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "expr2", 
  "]"}]], "Input",ExpressionUUID->"b15b6dca-6188-4d45-9c4d-88f2d2db8ffa"],

Cell[BoxData["18"], \
"Output",ExpressionUUID->"35450a58-70ab-4e74-936a-47aa236bf4c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvSimplify", "[", "%%", 
  "]"}]], "Input",ExpressionUUID->"eb6fc8fd-b6b4-4f4b-95eb-6af67ba8c9b9"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"84a24c28-fce4-44c9-9db6-4e92e6f992b8"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Relation in the previous paper", \
"Subsubsection",ExpressionUUID->"c5f04947-2a5a-49cb-89f8-2446096fb907"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"epsilonmetric", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "e", ",", "f"}], "]"}], 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "e"}], ",", 
     RowBox[{"-", "f"}], ",", "g"}], "]"}], 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "d"}], ",", "h", ",", "i", ",", "j"}], "]"}], 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "g"}], ",", 
     RowBox[{"-", "i"}]}], "]"}], 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "h"}], ",", 
     RowBox[{"-", "j"}]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"1", "/", "8"}], 
   RowBox[{"epsilonmetric", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "e", ",", "f"}], "]"}], 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}], ",", 
     RowBox[{"-", "e"}], ",", 
     RowBox[{"-", "f"}]}], "]"}], 
   RowBox[{"RiemannCD", "[", 
    RowBox[{"g", ",", "h", ",", "i", ",", "j"}], "]"}], 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "g"}], ",", 
     RowBox[{"-", "i"}]}], "]"}], 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "h"}], ",", 
     RowBox[{"-", "j"}]}], 
    "]"}]}]}]], \
"Input",ExpressionUUID->"07ac5a45-5850-48c0-b88e-c1d0391686c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "    ", "abcd"],
     AutoSpacing->False],
    epsilonmetric[a, b, c, d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "gi", "  "],
     AutoSpacing->False],
    RicciCD[-g, -i],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "hj", "  "],
     AutoSpacing->False],
    RicciCD[-h, -j],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"ab", "  "}], 
      RowBox[{"  ", "ef"}]],
     AutoSpacing->False],
    RiemannCD[-a, -b, e, f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"cef", " "}], 
      RowBox[{"   ", "g"}]],
     AutoSpacing->False],
    RiemannCD[-c, -e, -f, g],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"d", "   "}], 
      RowBox[{" ", "hij"}]],
     AutoSpacing->False],
    RiemannCD[-d, h, i, j],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["\[Epsilon]", "    ", "abcd"],
     AutoSpacing->False],
    epsilonmetric[a, b, c, d],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "gi", "  "],
     AutoSpacing->False],
    RicciCD[-g, -i],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "hj", "  "],
     AutoSpacing->False],
    RicciCD[-h, -j],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", 
      RowBox[{"ab", "  "}], 
      RowBox[{"  ", "ef"}]],
     AutoSpacing->False],
    RiemannCD[-a, -b, e, f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "cdef", "    "],
     AutoSpacing->False],
    RiemannCD[-c, -d, -e, -f],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     SubsuperscriptBox["R", "    ", "ghij"],
     AutoSpacing->False],
    RiemannCD[g, h, i, j],
    Editable->
     False]}]}]], \
"Output",ExpressionUUID->"13a9320e-ff4b-4747-9ca6-d9da333c5485"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"03fc0dc0-fc1f-4915-abd1-9a59f803e33f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"58c2e30a-f98f-467a-b2ae-4e277f394edf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"fd90e250-38fe-406c-8642-e5d673f2d720"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SubscriptBox["\<\"D\"\>", "\<\"00000,89\"\>"]}], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["\<\"D\"\>", "\<\"00,2\"\>"], " ", 
    SubscriptBox["\<\"I\"\>", "\<\"000,2\"\>"]}], 
   "8"]}]], "Output",ExpressionUUID->"10eb341a-ad46-4f2b-ab35-160f2979e889"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvSimplify", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"cef38a3b-3496-4544-a130-c2cd1af3d6fd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"fba47ca3-2951-4b74-8340-e270f31ee6ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"c315db65-4a4e-41c2-8239-a08ae910d5e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"08c25c49-0989-46f1-8098-d525defdf325"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"956e4c5f-ea5d-4824-8631-1c0a85e426c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"443c7125-33ff-470a-993b-6c443878444e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"49349c8f-12c5-4bd5-97c4-bd648e28860c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"b2ed1d58-f938-45f1-96db-9ededae1d87a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"78caaa0c-cc60-4dba-bd14-97a51d1ed8cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"08ea095e-881d-4631-98e8-2375f9a59e87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"08a2e32b-0adc-49d5-b825-895e19f63096"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"ccce3b56-f7c2-4a05-bcf7-ed09c67e3a54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"6771d0bc-e8b4-4f54-bf34-cb0069aa0600"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"1a0d4b64-7e0f-45ff-ba7d-b5d0d869f1be"]
}, Open  ]],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"8a7cc00b-d693-4099-9a99-c07e115ad74c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["More examples", \
"Subsubsection",ExpressionUUID->"7bb704b3-89e1-46d9-b33d-5a3c69b720e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"memory", "=", 
     RowBox[{"MemoryInUse", "[", "]"}]}], ")"}], "/", "1000."}], "/", 
  "1024"}]], "Input",ExpressionUUID->"d5c20b0c-1722-4490-afba-1a72c5042460"],

Cell[BoxData["29.7776796875`"], \
"Output",ExpressionUUID->"16be815d-6ca2-4b54-be8d-730a8f0236ed"]
}, Open  ]],

Cell["Examples of RiemannToInv and InvToRiemann:", \
"Text",ExpressionUUID->"d859a57b-1475-4d74-a6c7-87b8fa2ca484"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "1", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "h"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "a"}], "]"}], "@", 
       RowBox[{"RiemannCD", "[", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}]}], 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", "e", ",", "f"}], "]"}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "g"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "c"}], "]"}], "@", 
       RowBox[{"RiemannCD", "[", 
        RowBox[{
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "f"}], ",", "g", ",", "h"}], "]"}]}]}]}], "+", 
    RowBox[{
     RowBox[{"RInv", "[", "metric", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "2"}], "}"}], ",", "1157"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "2", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", "e", ",", "f", ",", "g"}], "]"}], 
     RowBox[{"RiemannCD", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
     RowBox[{"RiemannCD", "[", 
      RowBox[{"h", ",", "i", ",", "j", ",", "k"}], "]"}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "h"}], ",", 
        RowBox[{"-", "i"}], ",", 
        RowBox[{"-", "j"}], ",", 
        RowBox[{"-", "k"}]}], "]"}], "]"}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "e"}], "]"}], "[", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "f"}], ",", 
        RowBox[{"-", "g"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"RInv", "[", "metric", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
      "27015"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "3", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "h"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "g"}], "]"}], "@", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "c"}], "]"}], "@", 
        RowBox[{
         RowBox[{"CD", "[", "h", "]"}], "@", 
         RowBox[{
          RowBox[{"CD", "[", 
           RowBox[{"-", "f"}], "]"}], "@", 
          RowBox[{
           RowBox[{"CD", "[", 
            RowBox[{"-", "e"}], "]"}], "@", 
           RowBox[{
            RowBox[{"CD", "[", 
             RowBox[{"-", "d"}], "]"}], "@", 
            RowBox[{
             RowBox[{"CD", "[", "g", "]"}], "[", 
             RowBox[{"RiemannCD", "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", "e", ",", 
               RowBox[{"-", "b"}], ",", "f"}], "]"}], "]"}]}]}]}]}]}]}]}]}], "+", 
    RowBox[{
     RowBox[{"RInv", "[", "metric", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}], ",", "20018"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "4", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"epsilonmetric", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "g"}], ",", 
       RowBox[{"-", "h"}]}], "]"}], 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "c"}], "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "a"}], "]"}], "@", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"RiemannCD", "[", 
         RowBox[{"g", ",", "f", ",", 
          RowBox[{"-", "e"}], ",", "h"}], "]"}], "]"}]}]}], 
     RowBox[{
      RowBox[{"CD", "[", "e", "]"}], "[", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"DualRInv", "[", "metric", "]"}], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", "914"}], "]"}]}]}], 
  ";"}]}], "Input",ExpressionUUID->"8106f7dc-0669-4e9a-a7dc-d48e32860a7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannToInv", "/@", 
  RowBox[{"Array", "[", 
   RowBox[{"test", ",", "4"}], 
   "]"}]}]], "Input",ExpressionUUID->"d69f5e7b-f073-4fa2-8e14-68d25c05ed5a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a2ca256f-b78a-4f28-86c3-bad93afec134"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"b00c0315-6ed4-4166-b663-a1a7dd8bb12a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8"}], "}"}]}],
  SequenceForm["Reading InvRules for step 1 and case ", {0, 8}],
  Editable->
   False]], "Print",ExpressionUUID->"929b617a-dd07-4400-ae78-6dad95b84b0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"37bce5ee-d0ff-4cfa-9c53-156dbc4cca0a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"63165cb5-b57d-4021-b845-aa213c722caf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InvToRiemann", "/@", 
    RowBox[{"Array", "[", 
     RowBox[{"test", ",", "4"}], "]"}]}], "//", "NoScalar"}], "//", 
  "ToCanonical"}]], \
"Input",ExpressionUUID->"c080c917-8184-4733-90be-247c90d4b90e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"b1261d75-59b9-4b61-aa0f-394386cb0ab1"]
}, Open  ]],

Cell["Shortcuts:", \
"Text",ExpressionUUID->"9edf8a6e-ccb9-45a3-8c15-07d6efd9d21a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inv", "=", 
   RowBox[{"RInv", "[", "metric", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dinv", "=", 
   RowBox[{"DualRInv", "[", "metric", "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"bd2d7a64-9f49-4aea-af79-1d5d525ff5c2"],

Cell["Examples of relations at step 2:", \
"Text",ExpressionUUID->"e1515d98-8976-4860-8489-4b2a546720f4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "5", "]"}], "=", 
   RowBox[{
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", "15073"}], "]"}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", "15063"}], "]"}], "/", 
     "4"}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", "15072"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "6", "]"}], "=", 
   RowBox[{
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", "914"}], "]"}], "-", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", "908"}], "]"}], "/", "4"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "7", "]"}], "=", 
   RowBox[{
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
      "27015"}], "]"}], "+", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
       "26365"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "8", "]"}], "=", 
   RowBox[{
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", "8", "}"}], ",", "1116"}], "]"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", "8", "}"}], ",", "1092"}], "]"}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", "8", "}"}], ",", "1115"}], "]"}]}]}], 
  ";"}]}], "Input",ExpressionUUID->"30354b62-d04a-458d-beaa-b61c3236a679"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$InvSimplifyLevel", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"InvSimplify", "/@", 
  RowBox[{"Array", "[", 
   RowBox[{"test", ",", "4", ",", "5"}], 
   "]"}]}]}], "Input",ExpressionUUID->"aa3f7ff8-3b04-4844-b99f-c07cce40dac3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"1e8e205f-692e-42d8-b490-282020d30f4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"2e2f0573-4436-42d8-98b6-85b2dd9b6ca3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"171d0f23-22a7-4f03-9ca6-c9030c10f6f9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"c1fc47ad-ecff-4487-9ee2-9e563e3febeb"]
}, Open  ]],

Cell["Examples of relations at step 3:", \
"Text",ExpressionUUID->"474f8a71-27a4-4e13-a241-c0130faccdf7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "9", "]"}], "=", 
   RowBox[{
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", "15072"}], "]"}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", "1750"}], "]"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", "1751"}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", "1753"}], "]"}]}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "4"}], "}"}], ",", "1754"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "10", "]"}], "=", 
   RowBox[{
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", "908"}], "]"}], "+", 
    RowBox[{"4", 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", "328"}], "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", "332"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "11", "]"}], "=", 
   RowBox[{
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
      "26365"}], "]"}], "+", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
       "26327"}], "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
       "26335"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "12", "]"}], "=", 
   RowBox[{
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", "8", "}"}], ",", "1092"}], "]"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", "8", "}"}], ",", "1090"}], "]"}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", "8", "}"}], ",", "1091"}], "]"}]}]}], 
  ";"}]}], "Input",ExpressionUUID->"5c6989c8-f2f3-4bb9-b374-3a7766b49236"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$InvSimplifyLevel", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"InvSimplify", "/@", 
  RowBox[{"Array", "[", 
   RowBox[{"test", ",", "4", ",", "9"}], 
   "]"}]}]}], "Input",ExpressionUUID->"226ec62e-ea05-4df9-a80d-e800ffcc307b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"0f1bb5a5-20c3-48ea-8f2a-916ec0a1522d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"19af9688-dddf-4970-a6ee-0443dd0e42ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"fa44bf5e-08c9-406e-81ff-3d23f57664ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "8", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {8}],
  Editable->
   False]], "Print",ExpressionUUID->"a9ec41bc-5e82-4f39-a6dd-426d69214a8d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"6345ea8b-738c-45f3-a571-8f4da29b7f9b"]
}, Open  ]],

Cell["Examples of relations at step 4:", \
"Text",ExpressionUUID->"c17343dd-eb90-415e-bbab-9ae7d84f3980"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "13", "]"}], "=", 
   RowBox[{
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", "70"}], "]"}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "50"}], "]"}],
     "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", "100"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "14", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", "74"}], "]"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", "18"}], "]"}]}], "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", "19"}], "]"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", "71"}], 
      "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", "251"}], 
      "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", "264"}], 
      "]"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", "267"}], 
      "]"}]}], "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "5"}], 
      "]"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "6"}], 
      "]"}]}], "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "8"}], 
      "]"}]}], "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "12"}], 
      "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "31"}], 
      "]"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "32"}], 
      "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "34"}], 
      "]"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "35"}], 
      "]"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "37"}], 
      "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "41"}], 
      "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", "42"}], 
      "]"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "2"}], "]"}]}], "+", 
    RowBox[{"10", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "6"}], "]"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "8"}], "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "9"}], "]"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "11"}], "]"}]}], "+", 
    RowBox[{"6", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "12"}], "]"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "25"}], "]"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "27"}], "]"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "31"}], "]"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "33"}], "]"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "35"}], "]"}]}], "-", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "36"}], "]"}]}], "-", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "38"}], "]"}]}], "-", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "43"}], "]"}]}], "-", 
    RowBox[{"8", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
       "45"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "15", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", "11"}], "]"}]}], "+", 
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", "10"}], "]"}], "+", 
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "2"}], "]"}], "-", 
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "4"}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "6"}], "]"}]}], "+", 
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "88"}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "89"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "16", "]"}], "=", 
   RowBox[{
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", "5"}], "]"}], "-", 
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "1"}], "]"}], "-", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "18"}], "]"}], "/", 
     "2"}]}]}], 
  ";"}]}], "Input",ExpressionUUID->"67a23e37-fe61-4d79-83a7-6f3cdfb72777"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$InvSimplifyLevel", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"InvSimplify", "/@", 
  RowBox[{"Array", "[", 
   RowBox[{"test", ",", "4", ",", "13"}], 
   "]"}]}]}], "Input",ExpressionUUID->"c12ba4d2-1fc6-4b58-94ba-09382069a7fc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"cad8549f-d55b-42c8-83b8-f3713aab11fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"88d7529a-f8e6-4ec2-a2f6-01a233cea6d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 4}],
  Editable->
   False]], "Print",ExpressionUUID->"14386eb4-5378-4b5b-923a-a7bf4a723cd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"fb610c92-987d-4ed3-afd7-e5bfc34d384f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"446f72a3-2a14-405d-9f5a-c53b3b012e7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"166e0c3e-82f0-4462-9679-81f5632f2b32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"b1f690bb-56d6-406d-800b-103705c56b49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"dd215e2f-1cf0-4a08-b0b7-31736140d408"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ddcd6a75-7d39-4f5b-ae06-e3ac0ae96bd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"70ed9e98-3b02-46cd-9359-6693139098b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"7cc94923-5b08-4aa4-b7b9-e705deb3d5bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"99f3daec-3ce8-419a-9290-c9e3ad26c6f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"313b3169-648c-4fba-9da0-4c85e691bd57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"83453105-6f7d-47a2-bba1-d2b224d4157b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"421e8c15-a929-4157-8fb6-8f46626b68ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"77ff7e9e-bc30-4a05-a6e9-9533e4fee0a8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"48b98e39-c069-48df-b99e-465d6293cf1a"]
}, Open  ]],

Cell["Examples of relations at step 5:", \
"Text",ExpressionUUID->"71a0720d-6cf2-4539-99df-e709f6f7557b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "17", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "5861"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "7"}], "]"}], "/", 
     "8"}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "49"}], "]"}], "/", 
     "4"}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "380"}], "]"}], "/", 
     "2"}], "-", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "392"}], "]"}], "/", 
     "2"}], "-", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "474"}], "]"}], "/", 
     "2"}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "480"}], "]"}], "/", 
     "2"}], "-", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "625"}], "]"}], "/", 
     "2"}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "631"}], "]"}], "/", 
     "2"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1356"}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1362"}], "]"}]}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1380"}], "]"}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1416"}], "]"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1422"}], "]"}], "-", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "2229"}], "]"}], "/", 
     "2"}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "2626"}], "]"}], "/", 
     "2"}], "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "4985"}], "]"}]}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "5804"}], "]"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "5816"}], "]"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "5837"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "18", "]"}], "=", 
   RowBox[{
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", "95"}], "]"}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", "1"}], "]"}], "/", "4"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "19", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "3901"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", "1"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}], ",", "7"}], "]"}], "/", "8"}]}], "-", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", "1"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}], ",", "150"}], "]"}], "/", "2"}]}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", "1"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}], ",", "155"}], "]"}], "/", "2"}]}], "-", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "14"}], "]"}], "/", 
     "4"}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "101"}], "]"}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "111"}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "585"}], "]"}]}], "+", 
    
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "590"}], "]"}], "+", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "602"}], "]"}]}], "+", 
    
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "718"}], "]"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "1144"}], "]"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "3567"}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "3572"}], "]"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "3"}], "}"}], ",", "3875"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "20", "]"}], "=", 
   RowBox[{
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "4"}], "]"}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "1"}], "]"}], "/", 
     "2"}], "+", 
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "2"}], "]"}], "-", 
    RowBox[{"dinv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "3"}], "]"}]}]}], 
  ";"}]}], "Input",ExpressionUUID->"f8427406-0b94-4463-bb67-427748be38e1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$InvSimplifyLevel", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"InvSimplify", "/@", 
  RowBox[{"Array", "[", 
   RowBox[{"test", ",", "4", ",", "17"}], 
   "]"}]}]}], "Input",ExpressionUUID->"0ec3e9fc-3f6c-4292-9d13-cedc3add7b36"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"826d7b83-03cd-47de-b067-0d0a35d28271"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"c7dbf53f-4b9a-46df-9f2e-b7661d79f39a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {1, 2, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"331dc30f-5292-436d-8371-3fd8f9533296"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 2, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"87b7452b-a5a2-4dc8-b6eb-692514c430a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"3f07cd8c-5bb7-4c32-a874-553b9d0a8c57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"d4da401e-2ead-4647-b529-f7b71ea70135"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"2175c019-f542-43cf-9764-e45ab8f24885"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"eaa2a063-e0cb-4caa-b21d-6dcd0ade6a34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"b1d5b664-7812-403c-ae5e-c23cc8f5aff6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"3a03fbcd-45a9-41f3-b8ae-b6d952ff1f46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"1548e172-f75a-4576-b500-483b161a7b78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"adebfc06-55d4-40bf-8e70-7f1425e13dc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"008773de-51ac-4972-b600-a4fbff44ec88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"1dc57de8-fb5f-4d08-a7ba-4113d1e215e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {2}],
  Editable->
   False]], "Print",ExpressionUUID->"33fa85eb-390d-4843-b99f-a60fddcc56a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "2", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"0504f4b4-1bf6-4f04-b026-fdf45a52e067"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"144dbc80-c9a2-43f0-a6a0-1e4d7a7cebaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"2d60fa36-32fa-48df-a6b9-bada43aa4d04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0}],
  Editable->
   False]], "Print",ExpressionUUID->"6bfb4664-df68-48d3-9ece-7bf69d06e4ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 5, case ", {0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"854fe53b-375f-478a-a192-f6f17b618bff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b1f59f01-47ef-43e6-acf5-e9b88a5de382"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"e4447705-cc0f-4ab8-8975-2262745cd41e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"040c3a6e-9811-43d1-bfbf-1d0bfcc55899"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {3, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"fb9b604f-09b7-4588-a68d-57ff15dc49ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"de81c49c-44e7-4e7a-9446-c6eb636557ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"b196b1b2-c638-4d1a-b02d-780b62f3c5a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading NEInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}]}],
  SequenceForm["Reading NEInvRules for step 4 and case ", {0, 3, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"d32ec7c1-21d2-4a26-8542-f12c5be207e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 3, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"801886aa-fcaf-4feb-bd84-f0de32fe8df3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"c8fffb89-c690-4e38-914e-fa977418f3c1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"fff5d4aa-b76e-4e6e-8b9d-4d240bec5929"]
}, Open  ]],

Cell["Examples of relations at step 6:", \
"Text",ExpressionUUID->"efd53fa5-0828-48e7-83a0-5d4145daf409"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "21", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "53"}], 
      "]"}]}], "-", 
    RowBox[{
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "]"}], "^", "2"}], "/", 
     "4"}], "-", 
    RowBox[{
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "]"}], "^", "2"}], "/", 
     "64"}], "+", 
    RowBox[{"3", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", "4"}], "]"}], "/", "8"}]}], "-", 
    RowBox[{"5", 
     RowBox[{
      RowBox[{
       RowBox[{"inv", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", "4"}], "]"}], "^", "2"}], "/", 
      "4"}]}], "-", 
    RowBox[{"3", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", "5"}], "]"}], "/", "8"}]}], "+", 
    RowBox[{"5", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "4"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", "5"}], "]"}], "/", "2"}]}], "-", 
    RowBox[{"5", 
     RowBox[{
      RowBox[{
       RowBox[{"inv", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", "5"}], "]"}], "^", "2"}], "/", 
      "4"}]}], "-", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "3"}], "]"}],
      "/", "4"}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "5"}], "]"}],
      "/", "4"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "12"}], "]"}],
     "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "14"}], "]"}],
     "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "15"}], "]"}],
     "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "16"}], "]"}],
     "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "20"}], "]"}],
     "-", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "22"}], 
      "]"}]}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "23"}], "]"}],
     "-", 
    RowBox[{"3", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "38"}], 
      "]"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "39"}], 
      "]"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "40"}], 
      "]"}]}], "+", 
    RowBox[{"6", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "41"}], 
      "]"}]}], "-", 
    RowBox[{"4", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "42"}], 
      "]"}]}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "43"}], "]"}],
     "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "44"}], "]"}],
     "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "45"}], 
      "]"}], "/", "2"}], "+", 
    RowBox[{"3", 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", "46"}], 
       "]"}], "/", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "22", "]"}], "=", 
   RowBox[{
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", "1104"}], 
     "]"}], "-", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", "25"}], "]"}], "/", "4"}]}], "-", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", "1098"}], 
      "]"}], "/", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "23", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], ",", "25986"}], 
      "]"}]}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], ",", "294"}], "]"}], "/", "8"}]}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "1"}], "]"}], "/", 
      "8"}]}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "2"}], "]"}], "/", 
      "4"}]}], "+", 
    RowBox[{"3", 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "18"}], "]"}], "/", 
      "32"}]}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "63"}], "]"}], "/", 
      "8"}]}], "-", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "86"}], "]"}], "/", 
      "2"}]}], "+", 
    RowBox[{"5", 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "87"}], "]"}], "/", 
      "8"}]}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "97"}], "]"}], "/", 
      "16"}]}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "117"}], "]"}], "/", 
      "32"}]}], "+", 
    RowBox[{"3", 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "271"}], "]"}], "/", 
      "16"}]}], "-", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", "0", "}"}], ",", "1"}], "]"}], "/", "16"}]}], "+", 
    RowBox[{
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], ",", "25974"}], 
      "]"}], "/", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", "24", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"inv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], ",", "5470"}], 
      "]"}]}], "-", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", "19"}], "]"}], "/", "8"}]}], "-", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", "2"}], "]"}], "/", 
      "4"}]}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", "5"}], "]"}], "/", 
      "16"}]}], "-", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", "14"}], "]"}], "/", 
      "16"}]}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", "32"}], "]"}], "/", 
      "4"}]}], "-", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", "15"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", "0", "}"}], ",", "1"}], "]"}], "/", "16"}]}], "+", 
    RowBox[{
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{"dinv", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "2"}], "]"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", "0", "}"}], ",", "1"}], "]"}], "/", "16"}]}], "-", 
    RowBox[{
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], "^", "2"}], 
     RowBox[{
      RowBox[{
       RowBox[{"inv", "[", 
        RowBox[{
         RowBox[{"{", "0", "}"}], ",", "1"}], "]"}], "^", "2"}], "/", 
      "128"}]}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], "^", "2"}], 
     RowBox[{
      RowBox[{"inv", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], "/", "32"}]}], "-", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], ",", "5461"}], 
     "]"}], "+", 
    RowBox[{"inv", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], ",", "5466"}], 
     "]"}]}]}], 
  ";"}]}], "Input",ExpressionUUID->"bd5358a1-b399-4c70-963c-b844a840beda"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$InvSimplifyLevel", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"InvSimplify", "/@", 
  RowBox[{"Array", "[", 
   RowBox[{"test", ",", "4", ",", "21"}], 
   "]"}]}]}], "Input",ExpressionUUID->"a6d46c04-5ca5-42ab-8790-f38811efedc5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"602ac845-d847-45bd-a423-ea8f213f2392"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"431a291e-8f47-4a93-b65f-6d7bdee60cf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"f5f000b4-a23b-405a-aeb2-b01c99ea817b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"9a35661a-a4d6-4f28-961d-f24f2be2c79d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"61c7c72e-2577-4860-84fb-cb8ac29c0c5e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"dfb4d551-e884-407b-b329-a0a80bbc87a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"547eef01-2aa8-4f58-977e-d5ab77d5ae37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"61f63933-5502-4e07-ae6b-6112a87f271f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"edbf71a2-bb1c-4fa1-91b9-b1c256ae4737"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"8fdaa672-6e1c-42ab-b17e-bfc882a0d1d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"78b5fc70-e703-45d0-b247-bca401c3bee8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {1, 1, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"378ffefd-e9e8-4597-ab1a-761eb41c1133"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {1, 1, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"14cfff2a-fc12-415a-8c2d-c44cc587e3d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {1, 1, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"376f7c31-5aaa-4d0a-93fa-5f15ee001ad9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"3552e75e-9589-4183-a2d1-f478e99f83d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 1, 1}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"a1af43c2-1b24-4d9b-beb5-a03b76396d0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"691578d7-24c7-4205-8374-17bad3f01374"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "0", "}"}], "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]",
    "4"}],
  SequenceForm[
  "Reading InvRules for step 6, case ", {0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"3487c7fc-0eea-44ce-b549-9360ec2670e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"74f3f49b-1551-40ff-8545-4e093d2c64c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"cec62b36-bd7d-4a4d-b0d6-e36895c643cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 1, 3}],
  Editable->
   False]], "Print",ExpressionUUID->"f30ffcdf-f10d-416b-bbc2-c5bece211fb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 1, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"4e7791eb-8958-427e-8e9f-9a8cfd212e4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 1, 3}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"24f4372d-a524-4341-abf1-c9dd66207d5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a053d707-23b4-49ed-8f73-ae4c70bb1c0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"80953875-d697-4d56-a93f-7ec80d08b8a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"61516189-a65c-431b-a615-018d0bb51849"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"920b7bb6-a5d3-4475-a713-c9b9bb7635e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"531b46dd-23f4-4781-af7c-9c9e9d5613cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"e4c2aa7d-5c91-4ca1-8495-721229836d2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"a1a03358-f3f5-4bcd-8423-1451a92d7950"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"86012164-f24a-470d-936d-ee90d7e32198"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"364fc762-ab90-40ed-beb7-d0bbfd7c681f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"15bda47d-6bd3-4475-baa6-1b04d79174bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"2517dce5-93e9-4a42-83d7-7bc22c303ca6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"862eb414-4b66-4ecf-97c4-9ea61536ee85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"0c2b37ef-e9e5-4d1c-8824-da1765e7ddd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"91fa698a-fa35-465b-a2dc-c990c9879057"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"cbd7d5b4-1ca2-4158-abfa-263e5f50e758"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"490020ce-ea08-49c8-aea3-341473fc739e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 2 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"c105327d-c148-45e1-b468-c08c74879111"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 3 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"bf34662f-5ffd-4228-8a9a-7026d83eaf61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}]}],
  SequenceForm["Reading InvRules for step 4 and case ", {0, 0, 2, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ab87eb0f-ea89-4e5f-8503-55be8994d863"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 5, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 5, case ", {0, 0, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"66adb25b-a82f-4bf3-9ab0-70fc70ef1eb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading InvRules for step 6, case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" and dimension \"\>", "\[InvisibleSpace]", "4"}],
  
  SequenceForm[
  "Reading InvRules for step 6, case ", {0, 0, 2, 2}, " and dimension ", 4],
  Editable->
   False]], "Print",ExpressionUUID->"12202857-02d4-4f2f-8ff5-d40a2ddae573"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",ExpressionUUID->"d275532f-918f-4eab-9699-f7881c6c4ddf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MemoryInUse", "[", "]"}], "-", "memory"}], ")"}], "/", 
   "1000."}], "/", 
  "1024"}]], "Input",ExpressionUUID->"0d8f0038-72db-4ecf-b6da-41a20d53a047"],

Cell[BoxData["265.2934140625`"], \
"Output",ExpressionUUID->"4332c229-29c5-42cf-9a7c-1a38dee3d4ea"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dual products", \
"Section",ExpressionUUID->"8de9f77f-0ca3-4edb-b526-8ba6642b0b7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SignDetOfMetric", "[", "metric", "]"}], "^=", 
  "sigma"}]], "Input",ExpressionUUID->"297737ec-7b67-43ec-90eb-20c55dd837a8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["\[Sigma]",
   AutoSpacing->False],
  sigma,
  Editable->
   False]], "Output",ExpressionUUID->"4dc68ea8-1f97-4dc0-9f30-b4b2edbcd40c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Read dual invariants", \
"Subsection",ExpressionUUID->"64b87747-29d4-4b77-9963-db868cde73ff"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReadDuals", "[", "case_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dlist", "[", "case", "]"}], "=", 
      RowBox[{
       RowBox[{"DualRInvs", "[", 
        RowBox[{"5", ",", "case"}], "]"}], "/.", 
       RowBox[{"DualRInv", "\[Rule]", 
        RowBox[{"DualRInv", "[", "metric", "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Slist", "[", "case", "]"}], "=", 
      RowBox[{"InvToRiemann", "/@", 
       RowBox[{"Dlist", "[", "case", "]"}]}]}]}], ")"}]}], 
  ";"}]], "Input",ExpressionUUID->"82543c1c-9aed-40fd-8cc7-af743633d316"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadDuals", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"298a6c54-95a3-479b-bbee-de476041d1a8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"9a7ad482-d51b-4e86-84dd-3611ec5c6382"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"9dff0a6b-b6ac-4189-b67d-954c8a60a6db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"555fc02d-ba57-40e8-8a65-561baef0cfd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"7d86ffe8-4d24-45f9-9068-ee01d33187f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"3c8f06b1-5e50-45d7-810c-b8564326798a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Scalar", "[", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Epsilon]", "cdef", "    "],
      AutoSpacing->False],
     epsilonmetric[-c, -d, -e, -f],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{"ab", "  "}], 
       RowBox[{"  ", "ef"}]],
      AutoSpacing->False],
     RiemannCD[-a, -b, e, f],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", "    ", "abcd"],
      AutoSpacing->False],
     RiemannCD[a, b, c, d],
     Editable->False]}], "]"}], 
  "}"}]], "Output",ExpressionUUID->"e8c49692-7048-49f4-9f74-ec1c82f2b8ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadDuals", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"4d285ead-1244-4a03-9361-c132a248844a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"ec6b9291-025d-436e-9bc4-81e4c0b2ef6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"bf2b8eac-0445-4268-ae76-546b31c7c2ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b8c7f791-da2c-4a44-884b-7343031f1163"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"50f5cc87-8313-42b3-8d4b-5ef4b28fe77c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"5f3aaed4-76cb-43f6-aa10-f0b30f342f7b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Scalar", "[", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["\[Epsilon]", "cdfg", "    "],
      AutoSpacing->False],
     epsilonmetric[-c, -d, -f, -g],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", "    ", "abcd"],
      AutoSpacing->False],
     RiemannCD[a, b, c, d],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubsuperscriptBox["R", 
       RowBox[{
        RowBox[{"a", " ", "e"}], " ", ";", "b", "  "}], 
       RowBox[{" ", 
        RowBox[{
         RowBox[{"e", " ", "f"}], "  ", ";", "g"}]}]],
      AutoSpacing->False],
     CD[g][
      CD[-b][
       RiemannCD[-a, e, -e, f]]],
     Editable->False]}], "]"}], 
  "}"}]], "Output",ExpressionUUID->"bab69ab5-9aa8-474c-9701-65287189000e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadDuals", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "2"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"38d5cd07-eb59-4363-96bf-00cbef3c177b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"41ac9c6c-2fd5-46e5-9661-364e635b7f57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"748d078b-7a3e-4f6f-b1a8-1f54b2b29857"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"b49b3236-0a21-4ded-bcbe-28583c61a5e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"87a35184-ac5c-4906-b62f-54782f14b07f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 0, 2}],
  Editable->
   False]], "Print",ExpressionUUID->"3a45568f-8b24-4c16-ac52-92256816a969"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "cfhi", "    "],
       AutoSpacing->False],
      epsilonmetric[-c, -f, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "d", " "}], 
        RowBox[{"de", " ", "f"}]],
       AutoSpacing->False],
      RiemannCD[d, e, -d, f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"b", " ", "g"}], " ", ";", "e", "  "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], "  ", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       CD[-e][
        RiemannCD[-b, g, -g, h]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "cefi", "    "],
       AutoSpacing->False],
      epsilonmetric[-c, -e, -f, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", "   "}], 
        RowBox[{" ", "def"}]],
       AutoSpacing->False],
      RiemannCD[-b, d, e, f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", 
         RowBox[{"gh", ";", "d", "  "}]}], 
        RowBox[{"gh", "    ", ";", "i"}]],
       AutoSpacing->False],
      CD[i][
       CD[-d][
        RiemannCD[g, h, -g, -h]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "cefh", "    "],
       AutoSpacing->False],
      epsilonmetric[-c, -e, -f, -h],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", "   "}], 
        RowBox[{" ", "def"}]],
       AutoSpacing->False],
      RiemannCD[-b, d, e, f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"d", " ", "g"}], "   ", ";", "i"}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], ";", "i", "  "}]}]],
       AutoSpacing->False],
      CD[-i][
       CD[i][
        RiemannCD[-d, g, -g, h]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "efhi", "    "],
       AutoSpacing->False],
      epsilonmetric[-e, -f, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", "   "}], 
        RowBox[{" ", "def"}]],
       AutoSpacing->False],
      RiemannCD[-b, d, e, f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "g"}], " ", ";", "d", "  "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], "  ", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       CD[-d][
        RiemannCD[-c, g, -g, h]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "fghi", "    "],
       AutoSpacing->False],
      epsilonmetric[-f, -g, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "    ", "defg"],
       AutoSpacing->False],
      RiemannCD[d, e, f, g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"bdc", " ", ";", "e", "  "}], 
        RowBox[{"   ", 
         RowBox[{"h", "  ", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       CD[-e][
        RiemannCD[-b, -d, -c, h]]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "efhi", "    "],
       AutoSpacing->False],
      epsilonmetric[-e, -f, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"ab", "  "}], 
        RowBox[{"  ", "ef"}]],
       AutoSpacing->False],
      RiemannCD[-a, -b, e, f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "    ", "abcd"],
       AutoSpacing->False],
      RiemannCD[a, b, c, d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"c", " ", "g"}], " ", ";", "d", "  "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], "  ", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       CD[-d][
        RiemannCD[-c, g, -g, h]]],
      Editable->False]}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"0acba5fc-16b2-4b2a-a465-7af30386a4bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadDuals", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"57f5d7ac-e07c-4515-bb3b-54298933114f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"e470282b-14c8-4f2d-9e52-ce3391a2f334"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"282b02ed-1a6b-4344-bb0c-dc91b66bb33e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"7a0bf3d7-48cf-4ad4-8b8f-03dd90d5a6a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"e3cf0f8e-f6d0-4421-9ada-9fe2c36b4bb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {0, 1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"ff602317-d7f4-4c74-bae7-45bfd1d0b8cc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "cefi", "    "],
       AutoSpacing->False],
      epsilonmetric[-c, -e, -f, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", " ", "d", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"d", " ", "e"}], ";", "f"}]}]],
       AutoSpacing->False],
      CD[f][
       RiemannCD[-b, d, -d, e]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "gh", "  "}], 
        RowBox[{"gh", "  ", ";", "i"}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[g, h, -g, -h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "efhi", "    "],
       AutoSpacing->False],
      epsilonmetric[-e, -f, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", " ", "d", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"d", " ", "e"}], ";", "f"}]}]],
       AutoSpacing->False],
      CD[f][
       RiemannCD[-b, d, -d, e]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"c", " ", "g", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-c, g, -g, h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "cfhi", "    "],
       AutoSpacing->False],
      epsilonmetric[-c, -f, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", " ", "d", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"d", " ", "e"}], ";", "f"}]}]],
       AutoSpacing->False],
      CD[f][
       RiemannCD[-b, d, -d, e]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"e", " ", "g", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-e, g, -g, h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "cdfi", "    "],
       AutoSpacing->False],
      epsilonmetric[-c, -d, -f, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "    ", "abcd"],
       AutoSpacing->False],
      RiemannCD[a, b, c, d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "e"}], " ", ";", "b"}], 
        RowBox[{" ", 
         RowBox[{"e", " ", "f", "  "}]}]],
       AutoSpacing->False],
      CD[-b][
       RiemannCD[-a, e, -e, f]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "gh", "  "}], 
        RowBox[{"gh", "  ", ";", "i"}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[g, h, -g, -h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "efhi", "    "],
       AutoSpacing->False],
      epsilonmetric[-e, -f, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", " ", "c", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"d", " ", "e"}], ";", "f"}]}]],
       AutoSpacing->False],
      CD[f][
       RiemannCD[-b, d, -c, e]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"d", " ", "g", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-d, g, -g, h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "cfgi", "    "],
       AutoSpacing->False],
      epsilonmetric[-c, -f, -g, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", "     "}], 
        RowBox[{" ", 
         RowBox[{"def", ";", "g"}]}]],
       AutoSpacing->False],
      CD[g][
       RiemannCD[-b, d, e, f]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"d", " ", "eh", "  "}], 
        RowBox[{" ", 
         RowBox[{"h", "  ", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-d, h, -e, -h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "dfhi", "    "],
       AutoSpacing->False],
      epsilonmetric[-d, -f, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "    ", "abcd"],
       AutoSpacing->False],
      RiemannCD[a, b, c, d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", " ", "ce", "  "}], 
        RowBox[{" ", 
         RowBox[{"e", "  ", ";", "f"}]}]],
       AutoSpacing->False],
      CD[f][
       RiemannCD[-a, e, -c, -e]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", " ", "g", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-b, g, -g, h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "dfhi", "    "],
       AutoSpacing->False],
      epsilonmetric[-d, -f, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "    ", "abcd"],
       AutoSpacing->False],
      RiemannCD[a, b, c, d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{
         RowBox[{"a", " ", "e"}], " ", ";", "b"}], 
        RowBox[{" ", 
         RowBox[{"e", " ", "f", "  "}]}]],
       AutoSpacing->False],
      CD[-b][
       RiemannCD[-a, e, -e, f]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"c", " ", "g", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-c, g, -g, h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "cdgi", "    "],
       AutoSpacing->False],
      epsilonmetric[-c, -d, -g, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "    ", "abcd"],
       AutoSpacing->False],
      RiemannCD[a, b, c, d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"a", " ", "e", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"e", " ", "f"}], ";", "g"}]}]],
       AutoSpacing->False],
      CD[g][
       RiemannCD[-a, e, -e, f]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", " ", "fh", "  "}], 
        RowBox[{" ", 
         RowBox[{"h", "  ", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-b, h, -f, -h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "defi", "    "],
       AutoSpacing->False],
      epsilonmetric[-d, -e, -f, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "    ", "abcd"],
       AutoSpacing->False],
      RiemannCD[a, b, c, d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"abc", "   "}], 
        RowBox[{"   ", 
         RowBox[{"e", ";", "f"}]}]],
       AutoSpacing->False],
      CD[f][
       RiemannCD[-a, -b, -c, e]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "gh", "  "}], 
        RowBox[{"gh", "  ", ";", "i"}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[g, h, -g, -h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "fghi", "    "],
       AutoSpacing->False],
      epsilonmetric[-f, -g, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", " "}], 
        RowBox[{"ab", " ", "c"}]],
       AutoSpacing->False],
      RiemannCD[a, b, -a, c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", "     "}], 
        RowBox[{" ", 
         RowBox[{"def", ";", "g"}]}]],
       AutoSpacing->False],
      CD[g][
       RiemannCD[-b, d, e, f]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"ced", "   "}], 
        RowBox[{"   ", 
         RowBox[{"h", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-c, -e, -d, h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "efhi", "    "],
       AutoSpacing->False],
      epsilonmetric[-e, -f, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "    ", "abcd"],
       AutoSpacing->False],
      RiemannCD[a, b, c, d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"abc", "   "}], 
        RowBox[{"   ", 
         RowBox[{"e", ";", "f"}]}]],
       AutoSpacing->False],
      CD[f][
       RiemannCD[-a, -b, -c, e]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"d", " ", "g", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"g", " ", "h"}], ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-d, g, -g, h]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "fghi", "    "],
       AutoSpacing->False],
      epsilonmetric[-f, -g, -h, -i],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "    ", "abcd"],
       AutoSpacing->False],
      RiemannCD[a, b, c, d],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"ab", "    "}], 
        RowBox[{"  ", 
         RowBox[{"ef", ";", "g"}]}]],
       AutoSpacing->False],
      CD[g][
       RiemannCD[-a, -b, e, f]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"cde", "   "}], 
        RowBox[{"   ", 
         RowBox[{"h", ";", "i"}]}]],
       AutoSpacing->False],
      CD[i][
       RiemannCD[-c, -d, -e, h]],
      Editable->False]}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"adc13ca2-1e75-4ea5-bf49-3abb90024e98"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadDuals", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"dfc6bf26-1f65-448a-8b5a-2a5b18b88f6b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"1912d5dc-753e-423d-8744-3a74a95d0091"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"a0a683b3-d9ac-4122-a29c-a2512ee5dcf0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"388859b1-a8e4-4fe5-8986-bd4da90cd9a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"bfbc2a5b-cce9-4221-a4b1-70d2f1e5de0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 1 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 1 and case ", {1, 1}],
  Editable->
   False]], "Print",ExpressionUUID->"4cdb64a3-3a71-449f-a2ac-fd44ea275c93"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "cdfg", "    "],
       AutoSpacing->False],
      epsilonmetric[-c, -d, -f, -g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"  ", "a", "   "}], 
        RowBox[{
         RowBox[{"ab", " ", "c"}], ";", "d"}]],
       AutoSpacing->False],
      CD[d][
       RiemannCD[a, b, -a, c]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"b", " ", "e", "   "}], 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"e", " ", "f"}], ";", "g"}]}]],
       AutoSpacing->False],
      CD[g][
       RiemannCD[-b, e, -e, f]],
      Editable->False]}], "]"}], ",", 
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["\[Epsilon]", "defg", "    "],
       AutoSpacing->False],
      epsilonmetric[-d, -e, -f, -g],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", "      ", 
        RowBox[{"abcd", ";", "e"}]],
       AutoSpacing->False],
      CD[e][
       RiemannCD[a, b, c, d]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       SubsuperscriptBox["R", 
        RowBox[{"abc", "   "}], 
        RowBox[{"   ", 
         RowBox[{"f", ";", "g"}]}]],
       AutoSpacing->False],
      CD[g][
       RiemannCD[-a, -b, -c, f]],
      Editable->False]}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"0b746c9a-1205-4842-b3f7-69551290c6fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadDuals", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}], 
  "]"}]], "Input",ExpressionUUID->"5df4989b-42aa-4f79-8171-77d21f222589"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 2 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 2 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"ec4f6acd-b85f-4c9d-a8b0-3f7d4d45dc47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 3 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 3 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"038cd32f-eef8-4bcc-b9dc-8f97fee6797e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 4 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 4 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"62f8704d-67fc-4c1a-9a42-11cb8ac5411c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reading DualInvRules for step 5 and case \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm["Reading DualInvRules for step 5 and case ", {0, 0, 0}],
  Editable->
   False]], "Print",ExpressionUUID->"7b40d4bc-f642-45ba-ae9b-f35c3a6b599b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Scalar", "[", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       Subsupersc