(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    970631,      21693]
NotebookOptionsPosition[    940993,      21195]
NotebookOutlinePosition[    941688,      21218]
CellTagsIndexPosition[    941645,      21215]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["SpaceSpinors",
 FontSlant->"Italic",
 FontColor->RGBColor[1, 0, 0]]], "Title",
 CellChangeTimes->{{3.424432795274125*^9, 3.424432798147224*^9}, {
   3.5157440947588263`*^9, 3.515744097651992*^9}, {3.515938160464596*^9, 
   3.515938165706205*^9}, {3.5703531597164736`*^9, 3.5703531655508842`*^9}, 
   3.570353218013776*^9, 
   3.690025821460571*^9},ExpressionUUID->"f49154df-a83d-4bc1-aa0b-\
5f799a9f770e"],

Cell[TextData[StyleBox["Handling of space spinor expressions",
 FontColor->RGBColor[0, 0, 1]]], "Subtitle",
 CellChangeTimes->{{3.432628764630637*^9, 3.432628770497842*^9}, {
  3.515744107853575*^9, 3.515744118206167*^9}, {3.5445929647531424`*^9, 
  3.544592965622192*^9}, {3.5703531863769207`*^9, 
  3.5703531999801445`*^9}},ExpressionUUID->"5f2aa1a3-036f-407d-a174-\
534951cfe91a"],

Cell[TextData[{
 StyleBox["Thomas B\[ADoubleDot]ckdahl",
  FontSize->18],
 "     thomas.backdahl@chalmers.se\nMathematical Sciences\nChalmers \
University of Technology and University of Gothenburg \nGothenburg, Sweden\n\n\
(c) 2015-2025, under GPL\n\nhttp://www.xAct.es/\n\
http://groups.google.com/group/xAct"
}], "Subsubtitle",
 CellChangeTimes->{{3.515744127407694*^9, 3.515744214153655*^9}, {
   3.515938182944235*^9, 3.515938183474636*^9}, {3.5354546450794406`*^9, 
   3.5354546469202437`*^9}, {3.5671882614270687`*^9, 
   3.5671882618482695`*^9}, {3.570353203630551*^9, 3.570353206017355*^9}, 
   3.5844269015311675`*^9, {3.6176882956746087`*^9, 3.617688296874611*^9}, {
   3.662875790099593*^9, 3.662875858629689*^9}, 3.690025803240571*^9, 
   3.6938141166588545`*^9, {3.9103398072314076`*^9, 3.910339818932251*^9}, 
   3.95673887892054*^9},ExpressionUUID->"2d566e78-a858-4a54-9b96-\
7f8ef5b3d711"],

Cell[TextData[{
 "SpaceSpinors is a package for handling space spinor expressions.\n\n",
 "SpaceSpinors",
 " is distributed under the GNU General Public License, and runs on top of ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", a free package for fast manipulation of abstract tensor expressions. "
}], "Text",
 CellChangeTimes->{{3.419078218575598*^9, 3.419078246806376*^9}, {
  3.425990024306922*^9, 3.425990025430625*^9}, {3.4941363300431013`*^9, 
  3.494136333188654*^9}, {3.5157442219230995`*^9, 3.5157442456454563`*^9}, {
  3.5159381900578475`*^9, 3.51593820845028*^9}, {3.5292378115451984`*^9, 
  3.529237844414456*^9}, {3.5703532254081893`*^9, 3.5703532547362404`*^9}, {
  3.690025830750571*^9, 
  3.6900258308105707`*^9}},ExpressionUUID->"6473c268-e2e1-4325-95fa-\
062a84411f18"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "]"}]], "Input",
 CellChangeTimes->{{3.461421019166093*^9, 3.461421020263547*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"ed1ae1a2-5ed5-4064-9cca-f1ecd7602ff0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2025", ",", "6", ",", "23", ",", "23", ",", "4", ",", 
   "44.8632326`9.40446543241616"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5201748450984573`*^9, 3.520175592850561*^9, 3.52017596479801*^9, 
   3.5201760928938336`*^9, 3.5201762671609373`*^9, 3.520176752597585*^9, 
   3.5201779201008253`*^9, 3.5201779700665092`*^9, 3.5201780303834147`*^9, 
   3.520178119921769*^9, 3.5201783207649164`*^9, 3.520179006952915*^9, 
   3.5201791070766892`*^9, 3.520179190298833*^9, 3.52017923484451*^9, 
   3.520179281313389*^9, 3.520179460495299*^9, 3.5201795483158507`*^9, 
   3.520181356801396*^9, 3.52018163326988*^9, 3.520268558614688*^9, 
   3.5202687266265273`*^9, 3.520268859119117*^9, 3.52026889611597*^9, 
   3.5202690874682417`*^9, 3.520271811210497*^9, 3.5203105954279346`*^9, 
   3.520310975876489*^9, 3.5203117778404217`*^9, 3.5203120960882998`*^9, 
   3.5271449373462715`*^9, 3.5271458071433992`*^9, 3.5271460006471395`*^9, 
   3.5271470217333326`*^9, 3.5271475923989353`*^9, 3.527148045611931*^9, 
   3.527148262935913*^9, 3.5271486851910577`*^9, 3.527150049445654*^9, 
   3.527150171734269*^9, 3.527150352273386*^9, 3.5271505062924566`*^9, 
   3.527150790680956*^9, 3.527150864063485*^9, 3.5292308221613216`*^9, 
   3.5292324657178087`*^9, 3.5292325704563923`*^9, 3.529235908180855*^9, 
   3.529236216250196*^9, 3.5292364158213468`*^9, 3.5292366532537637`*^9, 
   3.5292367147802715`*^9, 3.529236965912513*^9, 3.529237056345872*^9, 
   3.5340685680385866`*^9, 3.534068950442058*^9, 3.5340693813928146`*^9, 
   3.5340699505598145`*^9, 3.53407017563701*^9, 3.5342496349881597`*^9, 
   3.537621497408594*^9, 3.537621623940417*^9, 3.5376228407123537`*^9, {
   3.537622948290143*^9, 3.537622963078969*^9}, 3.537623181697753*^9, 
   3.5376233601932664`*^9, 3.5376254387741175`*^9, 3.5376287880242715`*^9, 
   3.5376946984858675`*^9, 3.5376948663733625`*^9, 3.537695500467676*^9, 
   3.5376955802462163`*^9, 3.5376959119193993`*^9, 3.5376963939602456`*^9, 
   3.537697103606492*^9, 3.5376974590531163`*^9, {3.537697970468815*^9, 
   3.5376979899220486`*^9}, 3.537700569234584*^9, 3.537700987268518*^9, 
   3.5377011485572014`*^9, 3.5377050741510963`*^9, 3.537767648391486*^9, 
   3.537780184692705*^9, 3.5377805825558043`*^9, 3.537780919595396*^9, 
   3.5377810786220756`*^9, 3.5377812407375603`*^9, 3.5377813767853994`*^9, 
   3.537781525859261*^9, 3.5377817242760096`*^9, 3.5377823976677923`*^9, 
   3.537782738543991*^9, 3.537782929706727*^9, 3.5377831903675847`*^9, 
   3.5377834392358217`*^9, 3.5377835716176543`*^9, 3.537784106542594*^9, 
   3.537784243386034*^9, 3.5440922078795586`*^9, 3.544097238595995*^9, 
   3.544097364160615*^9, 3.544097951565047*^9, 3.5440997528856106`*^9, 
   3.5441033713607664`*^9, 3.5441034625585265`*^9, 3.5441037037671504`*^9, 
   3.544103916145923*^9, 3.5441040505557594`*^9, 3.5441050983794003`*^9, 
   3.5441057130048795`*^9, 3.5441059477540913`*^9, 3.544107146242797*^9, 
   3.54459125186217*^9, 3.544591489073738*^9, 3.544591651463026*^9, 
   3.5445929032206225`*^9, 3.5446721717281303`*^9, 3.544672373193654*^9, 
   3.544673272411086*^9, {3.544673382043357*^9, 3.544673401580474*^9}, 
   3.5449492175074224`*^9, 3.5449516127414317`*^9, 3.5450156606377296`*^9, 
   3.54501572313144*^9, 3.5451061404170465`*^9, 3.545114019247418*^9, 
   3.5528211940801992`*^9, 3.5528226582373714`*^9, 3.55282279426961*^9, 
   3.552822985433346*^9, 3.5528231946453133`*^9, 3.5528236648769393`*^9, 
   3.552823969889675*^9, 3.5528261153624434`*^9, 3.552826308086182*^9, 
   3.5542072700575094`*^9, 3.5542084655364094`*^9, 3.561371696187217*^9, 
   3.561732584986005*^9, 3.5617791964926033`*^9, 3.561781486672226*^9, 
   3.561781560741156*^9, 3.561781651626916*^9, 3.561781901133754*^9, 
   3.561781932411809*^9, 3.5617821001443033`*^9, 3.561782193338867*^9, 
   3.561782386732407*^9, 3.5617824912681904`*^9, 3.561782524418249*^9, 
   3.5617842329196496`*^9, 3.562766624845748*^9, 3.5627667425479546`*^9, 
   3.562767080990549*^9, 3.5627678918497734`*^9, 3.562769544564476*^9, 
   3.5627696665098906`*^9, {3.5627711274856567`*^9, 3.5627711457688885`*^9}, 
   3.5627731129021435`*^9, 3.562773200792698*^9, 3.562821270227209*^9, 
   3.5628223445864964`*^9, 3.5628235964438953`*^9, 3.562823659733206*^9, 
   3.56282406054471*^9, 3.5628245974206533`*^9, 3.562825242122986*^9, 
   3.5628253104667053`*^9, 3.562825370511211*^9, 3.562825957931243*^9, 
   3.5628261325891495`*^9, 3.56282624664095*^9, 3.562828064642171*^9, 
   3.562828562563845*^9, 3.562828735240548*^9, 3.5628288774815984`*^9, 
   3.5628304882020273`*^9, 3.56283130395866*^9, 3.5628316985779533`*^9, 
   3.5628318196029663`*^9, 3.56283185036622*^9, 3.562832306979022*^9, 
   3.562832420360021*^9, 3.5628327279769616`*^9, 3.5628336685816135`*^9, 
   3.56283376305538*^9, 3.5628338335987034`*^9, 3.5634256313733892`*^9, 
   3.563426365869479*^9, 3.563427212265566*^9, 3.563428698122376*^9, 
   3.5634287900689373`*^9, 3.563428868849076*^9, 3.563429665169074*^9, 
   3.5641236113084354`*^9, 3.564124344510723*^9, 3.5641248610442305`*^9, 
   3.5641250162967033`*^9, 3.5641304406546307`*^9, 3.564635024021423*^9, 
   3.5646354965618525`*^9, 3.5646721277594867`*^9, 3.565759285923563*^9, 
   3.565773665638832*^9, 3.565892021411496*^9, 3.566194850147024*^9, 
   3.5662039697458687`*^9, 3.5662119026396637`*^9, 3.5662126380007563`*^9, 
   3.5662147323512344`*^9, 3.5663991476361322`*^9, 3.566543710509116*^9, 
   3.5670828122489247`*^9, 3.5671851346335764`*^9, 3.567586520134695*^9, 
   3.5676004782589216`*^9, 3.5678594368679476`*^9, 3.567860569571337*^9, 
   3.5678613057220306`*^9, 3.5678615186780043`*^9, 3.5678616178473787`*^9, 
   3.5678617145831485`*^9, 3.567861808822914*^9, 3.56786203435251*^9, 
   3.567862203456807*^9, 3.5678625351767898`*^9, 3.5678626821290483`*^9, 
   3.567862769941602*^9, 3.5678633189689665`*^9, 3.567863413676733*^9, 
   3.567863935279249*^9, 3.5678640874897165`*^9, 3.567864252475606*^9, 
   3.5678647657321076`*^9, 3.5678650145213447`*^9, 3.5678653135738697`*^9, 
   3.5678655273420453`*^9, 3.567877452606958*^9, 3.5679119462244887`*^9, 
   3.5679130610960464`*^9, 3.567916908038382*^9, 3.567917675232129*^9, 
   3.5679183595127316`*^9, 3.5679186135435777`*^9, 3.5679194434182353`*^9, 
   3.567919755465583*^9, 3.5679242565630894`*^9, 3.567926173807457*^9, 
   3.567926475558787*^9, 3.5679268601774626`*^9, 3.5679294726256514`*^9, 
   3.567929589376257*^9, 3.5679296707928*^9, 3.5679298550291233`*^9, 
   3.5679300820417223`*^9, 3.567930173535883*^9, 3.567930335339367*^9, 
   3.567930621194269*^9, 3.567931057183835*^9, 3.567931209284102*^9, 
   3.567931330277914*^9, 3.5679314656861525`*^9, 3.5679315186804457`*^9, 
   3.567931624479831*^9, 3.5679319489760013`*^9, 3.567932630369598*^9, 
   3.5679327498814077`*^9, 3.5679331244234657`*^9, 3.5679332316892543`*^9, 
   3.5679334628192596`*^9, 3.567934708810049*^9, 3.567935970697265*^9, 
   3.5681150026035523`*^9, 3.568115907094141*^9, 3.5681222518944855`*^9, 
   3.5681223539654646`*^9, 3.568123410993121*^9, 3.568895115070609*^9, 
   3.5688954820612535`*^9, {3.5703549460922117`*^9, 3.5703549577298317`*^9}, 
   3.5703573260021915`*^9, 3.570357445187401*^9, 3.570357531814353*^9, 
   3.5703576096896896`*^9, 3.5703577455981283`*^9, 3.57035780350543*^9, 
   3.5703578487923098`*^9, 3.5703579038448067`*^9, 3.5703579385236673`*^9, 
   3.57035800254618*^9, 3.570358231273782*^9, 3.570358626937277*^9, 
   3.5703592156833105`*^9, 3.57035930621027*^9, 3.5703598570472374`*^9, 
   3.5703601271149116`*^9, 3.570360996271438*^9, 3.5703610755195775`*^9, 
   3.5703612145002213`*^9, 3.5703614867206993`*^9, 3.5703615676380415`*^9, 
   3.5703616682894187`*^9, 3.5703618773453856`*^9, 3.5703628434716825`*^9, 
   3.570363006476369*^9, 3.5703631489982195`*^9, 3.5703632374503746`*^9, 
   3.570363298462082*^9, 3.570363360768591*^9, 3.5703635558469343`*^9, 
   3.570364084204262*^9, 3.5703641642636023`*^9, 3.570364365426956*^9, 
   3.570364471491542*^9, 3.5703645571044927`*^9, 3.5703647228235836`*^9, 
   3.5703648613986273`*^9, 3.570364932487952*^9, 3.570365043528947*^9, {
   3.5703653939055624`*^9, 3.5703654025635777`*^9}, 3.5703654620932817`*^9, 
   3.5703657261549463`*^9, 3.5703657903022585`*^9, {3.570365854121971*^9, 
   3.570365873107204*^9}, 3.5703659361625147`*^9, 3.5703659877830057`*^9, 
   3.5703660954241943`*^9, 3.570366175233935*^9, 3.570366231862034*^9, 
   3.570366296227747*^9, 3.570366338238621*^9, 3.5703664051315384`*^9, 
   3.570366436503194*^9, 3.570366572317032*^9, 3.5703669449392867`*^9, 
   3.570367244600213*^9, 3.5703673996488853`*^9, 3.5703674942162514`*^9, 
   3.5703677596049175`*^9, 3.570367807247401*^9, 3.570367863813101*^9, 
   3.570368556657118*^9, 3.5703686384792614`*^9, 3.570368782093114*^9, 
   3.5703688692660666`*^9, 3.570368929731773*^9, 3.570426909393371*^9, 
   3.5704275268736553`*^9, 3.570427596450778*^9, 3.5704276663389006`*^9, 
   3.5704277532310534`*^9, 3.5704319397968063`*^9, 3.5704321823148327`*^9, 
   3.5704330968050385`*^9, 3.570436513343156*^9, 3.5704380375906334`*^9, 
   3.5704381700982656`*^9, 3.5704382588156223`*^9, 3.5704383504969826`*^9, 
   3.570438571330971*^9, 3.570438755255294*^9, 3.5704388113217926`*^9, 
   3.5769885463038497`*^9, 3.5769896635788116`*^9, 3.5769897122508974`*^9, 
   3.5769897551665726`*^9, 3.5769897956642437`*^9, 3.5769901331864367`*^9, 
   3.576990313756754*^9, 3.5769903603540354`*^9, 3.576990526369527*^9, 
   3.576991387846441*^9, 3.5769916115352335`*^9, 3.5769924500689063`*^9, 
   3.576992811880342*^9, 3.5769933535288935`*^9, 3.576993430593029*^9, 
   3.5769937348403635`*^9, 3.5769941730773325`*^9, 3.57699510528817*^9, 
   3.5769952490736227`*^9, 3.5844271621452255`*^9, 3.584427295182259*^9, 
   3.5844273969256377`*^9, 3.584427666806112*^9, 3.584427731203025*^9, 
   3.584428021676535*^9, 3.584428063640609*^9, 3.5844284675721183`*^9, 
   3.584428588643931*^9, 3.5844287680764465`*^9, 3.5844292423640795`*^9, 
   3.584429323203421*^9, 3.584429364169093*^9, 3.584429426335202*^9, 
   3.5844295922414937`*^9, 3.584429987640788*^9, 3.584431509128061*^9, 
   3.5844319821530914`*^9, 3.617688620529112*^9, 3.6176886668991766`*^9, 
   3.617688743839285*^9, 3.6176888135993824`*^9, 3.617688852199436*^9, 
   3.617688898423549*^9, 3.617689373349262*^9, 3.617689415299321*^9, 
   3.6176895288035283`*^9, 3.61768960896364*^9, 3.6176897737738714`*^9, 
   3.6628758917997355`*^9, 3.6630604719880643`*^9, 3.663060518530857*^9, 
   3.6630606291066885`*^9, 3.6630607029141393`*^9, 3.690020733164571*^9, 
   3.690020876724571*^9, 3.690021106474571*^9, 3.690026102582571*^9, 
   3.690026177282571*^9, 3.9103403767217617`*^9, 3.9103443725837994`*^9, 
   3.9567389319121513`*^9, 3.9568088588797016`*^9, 3.957359841662842*^9, 
   3.957362220367737*^9, 3.9574060810389385`*^9, {3.957407134231531*^9, 
   3.9574071389199963`*^9}, 3.957411813640585*^9, 3.9586986759113045`*^9, 
   3.9596015156977215`*^9, 3.9596158756632576`*^9, 3.9596944337483387`*^9, 
   3.9596983561512794`*^9, 3.959701250512884*^9, 3.959701336424526*^9, 
   3.9597014848711853`*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"7dc82672-3cc3-2040-b4db-29ec99d3c25d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xAct`SpaceSpinors`$Version", "=", 
  RowBox[{"{", 
   RowBox[{"\"\<0.1.3\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2025", ",", "06", ",", "23"}], "}"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5201736763242097`*^9, 3.5201736765114098`*^9}, 
   3.5202677233961115`*^9, {3.524975610240281*^9, 3.5249756190074964`*^9}, {
   3.526043102559106*^9, 3.5260431029851303`*^9}, 3.5262094698353777`*^9, {
   3.527143521454584*^9, 3.527143523888189*^9}, 3.527145380935051*^9, {
   3.527148024473894*^9, 3.527148025066695*^9}, {3.5271508514118624`*^9, 
   3.527150853003065*^9}, {3.527487735477854*^9, 3.527487735649454*^9}, {
   3.529235948304126*^9, 3.529235955495738*^9}, {3.530340543752088*^9, 
   3.5303405442701178`*^9}, {3.5340680436748652`*^9, 
   3.5340680511160784`*^9}, {3.534248359249119*^9, 3.5342483601071205`*^9}, {
   3.5354546246122046`*^9, 3.5354546292298126`*^9}, {3.5376260016865063`*^9, 
   3.53762600379251*^9}, 3.5376979589871945`*^9, 3.5377801890451126`*^9, {
   3.54020534631925*^9, 3.5402053477733326`*^9}, {3.544091585983466*^9, 
   3.5440915874186687`*^9}, 3.5441070904258986`*^9, 3.5445902979486094`*^9, {
   3.5446732637615914`*^9, 3.544673264066609*^9}, {3.5451058294149003`*^9, 
   3.545105832690906*^9}, 3.5451134126559525`*^9, {3.549022343760488*^9, 
   3.549022346287692*^9}, {3.552826297821364*^9, 3.5528263005513687`*^9}, {
   3.56094496233256*^9, 3.560944965093765*^9}, 3.561368747422238*^9, {
   3.5628210173663645`*^9, 3.5628210182399664`*^9}, {3.562821058690838*^9, 
   3.5628210594084387`*^9}, {3.56412500309908*^9, 3.564125006531086*^9}, {
   3.5646349977977767`*^9, 3.5646349983281775`*^9}, {3.5671882702566843`*^9, 
   3.5671882813795033`*^9}, {3.5678591469726386`*^9, 
   3.5678591471286387`*^9}, {3.567920466734233*^9, 3.567920467171033*^9}, 
   3.568122916627253*^9, {3.568895100640584*^9, 3.5688951033549886`*^9}, {
   3.5695822059707413`*^9, 3.569582206173542*^9}, {3.570353266155461*^9, 
   3.57035327135027*^9}, {3.5769949374006753`*^9, 3.5769949405362806`*^9}, {
   3.5844269100799828`*^9, 3.584426912232786*^9}, {3.6176886371391354`*^9, 
   3.61768864767915*^9}, {3.6368087469635763`*^9, 3.636808751643583*^9}, {
   3.6408760851804333`*^9, 3.6408760876434917`*^9}, {3.662875781569581*^9, 
   3.6628757855595865`*^9}, 3.663060242370682*^9, 3.66306192769107*^9, {
   3.690017743542571*^9, 3.6900177492325706`*^9}, 3.690025830820571*^9, {
   3.6938141068888407`*^9, 3.693814111398847*^9}, {3.9103397977746115`*^9, 
   3.910339803067458*^9}, {3.956738886778532*^9, 3.95673889404212*^9}, 
   3.9568088619734344`*^9, 3.957359836762947*^9, 3.957406083828478*^9, {
   3.958558991891796*^9, 3.958558994772934*^9}, 3.9586986691995564`*^9, 
   3.9596015109045124`*^9, 3.9596944297183094`*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"0edccc3c-94ea-4439-8974-e9b46fcb2712"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0.1.3\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "6", ",", "23"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5201748451140575`*^9, 3.520175592870561*^9, 3.52017596481361*^9, 
   3.5201760929094334`*^9, 3.5201762671765375`*^9, 3.520176752628785*^9, 
   3.5201779201108255`*^9, 3.5201779700765095`*^9, 3.5201780303990145`*^9, 
   3.520178119941769*^9, 3.5201783207805166`*^9, 3.5201790069685154`*^9, 
   3.5201791070766892`*^9, 3.520179190314433*^9, 3.5201792348601103`*^9, 
   3.5201792813333893`*^9, 3.5201794605108986`*^9, 3.5201795483358507`*^9, 
   3.520181356816996*^9, 3.52018163328988*^9, 3.520268558624688*^9, 
   3.520268726636527*^9, 3.5202688591391172`*^9, 3.52026889613597*^9, 
   3.520269087488241*^9, 3.520271811230497*^9, 3.520310595447935*^9, 
   3.5203109759064894`*^9, 3.520311777850422*^9, 3.5203120961082993`*^9, {
   3.5271449345382667`*^9, 3.5271449373462715`*^9}, 3.5271458071589994`*^9, 
   3.5271460006627393`*^9, 3.527147021748933*^9, 3.5271475924145355`*^9, 
   3.527148045627531*^9, 3.5271482629515133`*^9, 3.527148685206658*^9, 
   3.527150049461254*^9, 3.527150171749869*^9, 3.527150352288986*^9, 
   3.5271505063080564`*^9, 3.527150790696556*^9, 3.527150864079085*^9, 
   3.529230822176922*^9, 3.5292324657334085`*^9, 3.5292325704719925`*^9, 
   3.529235908196455*^9, 3.529236216250196*^9, 3.5292364158369465`*^9, 
   3.5292366532693634`*^9, 3.5292367147958717`*^9, 3.529236965928113*^9, 
   3.5292370563770723`*^9, 3.534068568069786*^9, 3.534068950473258*^9, 
   3.5340693814396152`*^9, 3.5340699506066146`*^9, 3.53407017566821*^9, 
   3.5342496350193596`*^9, 3.5376214974397945`*^9, 3.5376216239560165`*^9, 
   3.537622840743554*^9, {3.537622948321343*^9, 3.537622963110169*^9}, 
   3.537623181744553*^9, 3.5376233602244663`*^9, 3.5376254388521175`*^9, 
   3.537628788086672*^9, 3.537694698517068*^9, 3.537694866404563*^9, 
   3.5376955004988766`*^9, 3.537695580277416*^9, 3.537695911934999*^9, 
   3.5376963939914455`*^9, 3.537697103653292*^9, 3.5376974590843163`*^9, {
   3.537697970500015*^9, 3.537697989953249*^9}, 3.537700569265784*^9, 
   3.537700987299718*^9, 3.537701148572801*^9, 3.5377050741978965`*^9, 
   3.537767648453886*^9, 3.537780184723905*^9, 3.537780582602604*^9, 
   3.5377809196265965`*^9, 3.5377810786532755`*^9, 3.53778124076876*^9, 
   3.537781376816599*^9, 3.537781525906061*^9, 3.5377817243072095`*^9, 
   3.5377823976989927`*^9, 3.5377827385751915`*^9, 3.5377829297379265`*^9, 
   3.5377831903987846`*^9, 3.537783439267022*^9, 3.5377835716488543`*^9, 
   3.537784106589394*^9, 3.5377842434172344`*^9, 3.5440922079107585`*^9, 
   3.5440972386271944`*^9, 3.544097364207415*^9, 3.5440979515962467`*^9, 
   3.544099752916811*^9, 3.5441033713919663`*^9, 3.5441034625897264`*^9, 
   3.5441037037983503`*^9, 3.544103916177123*^9, 3.5441040506025596`*^9, 
   3.544105098395*^9, 3.5441057130360794`*^9, 3.5441059477852917`*^9, 
   3.544107146273997*^9, 3.544591251895172*^9, 3.54459148910574*^9, 
   3.544591651494028*^9, 3.544592903244624*^9, 3.544672171765133*^9, 
   3.5446723732246556`*^9, 3.5446732724500885`*^9, {3.544673382081359*^9, 
   3.544673401615476*^9}, 3.544949217538623*^9, 3.5449516127726316`*^9, 
   3.54501566066893*^9, 3.54501572316264*^9, 3.5451061404482465`*^9, 
   3.545114019278618*^9, 3.5528211941113997`*^9, 3.552822658268571*^9, 
   3.55282279430081*^9, 3.552822985464546*^9, 3.5528231946765137`*^9, 
   3.5528236649237394`*^9, 3.5528239699208755`*^9, 3.5528261153936434`*^9, 
   3.552826308117382*^9, 3.55420727008871*^9, 3.5542084655520096`*^9, 
   3.561371696218417*^9, 3.561732585001605*^9, 3.5617791965238037`*^9, 
   3.561781486703426*^9, 3.561781560772356*^9, 3.561781651673716*^9, 
   3.561781901164954*^9, 3.561781932443009*^9, 3.5617821001599035`*^9, 
   3.561782193370067*^9, 3.561782386763607*^9, 3.561782491299391*^9, 
   3.5617825244494486`*^9, 3.5617842329508495`*^9, 3.5627666248769474`*^9, 
   3.5627667425791545`*^9, 3.5627670810217485`*^9, 3.562767891880973*^9, 
   3.562769544595676*^9, 3.5627696665254903`*^9, {3.562771127516856*^9, 
   3.5627711458000884`*^9}, 3.562773112933344*^9, 3.562773200808298*^9, 
   3.562821270274009*^9, 3.5628223446176963`*^9, 3.562823596475095*^9, 
   3.562823659764406*^9, 3.56282406057591*^9, 3.5628245974362535`*^9, 
   3.5628252421697855`*^9, 3.5628253104979057`*^9, 3.562825370542411*^9, 
   3.562825957962443*^9, 3.56282613262035*^9, 3.5628262466721497`*^9, 
   3.5628280646889706`*^9, 3.562828562579445*^9, 3.5628287352717485`*^9, 
   3.5628288775127983`*^9, 3.5628304882332277`*^9, 3.5628313039742603`*^9, 
   3.5628316986091537`*^9, 3.562831819618566*^9, 3.56283185039742*^9, 
   3.562832307010222*^9, 3.562832420391221*^9, 3.5628327280081615`*^9, 
   3.562833668612814*^9, 3.5628337630865793`*^9, 3.562833833629904*^9, 
   3.5634256314357896`*^9, 3.5634263659006796`*^9, 3.563427212281166*^9, 
   3.563428698169176*^9, 3.5634287901001377`*^9, 3.563428868895876*^9, 
   3.5634296652002745`*^9, 3.564123611339635*^9, 3.564124344541923*^9, 
   3.5641248610754304`*^9, 3.564125016327903*^9, 3.564130440685831*^9, 
   3.564635024052623*^9, 3.564635496593053*^9, 3.5646721277906866`*^9, 
   3.5657592859547625`*^9, 3.5657736656700325`*^9, 3.5658920214270964`*^9, 
   3.5661948501938243`*^9, 3.566203969777068*^9, 3.5662119026864634`*^9, 
   3.566212638047556*^9, 3.5662147323668346`*^9, 3.566399147698532*^9, 
   3.5665437105559163`*^9, 3.567082812295725*^9, 3.5671851347115765`*^9, 
   3.5675865201970954`*^9, 3.567600478274522*^9, 3.5678594369147477`*^9, 
   3.567860569602537*^9, 3.5678613057376304`*^9, 3.5678615187092047`*^9, 
   3.567861617862979*^9, 3.5678617146143484`*^9, 3.567861808869714*^9, 
   3.56786203438371*^9, 3.5678622034880075`*^9, 3.5678625352079897`*^9, 
   3.567862682175848*^9, 3.5678627699884024`*^9, 3.5678633190157666`*^9, 
   3.5678634137079325`*^9, 3.567863935294849*^9, 3.5678640875053167`*^9, 
   3.5678642525068064`*^9, 3.5678647657633076`*^9, 3.5678650145525446`*^9, 
   3.56786531358947*^9, 3.5678655273732452`*^9, 3.567877452638158*^9, 
   3.5679119462556887`*^9, 3.567913061127247*^9, 3.567916908069582*^9, 
   3.5679176752633295`*^9, 3.5679183595439315`*^9, 3.5679186135591774`*^9, 
   3.567919443449435*^9, 3.5679197554967833`*^9, 3.5679242565942893`*^9, 
   3.567926173838657*^9, 3.567926475589987*^9, 3.5679268602086625`*^9, 
   3.567929472656852*^9, 3.5679295893918567`*^9, 3.5679296708083997`*^9, 
   3.5679298550447235`*^9, 3.567930082057322*^9, 3.567930173567083*^9, 
   3.567930335354967*^9, 3.567930621225469*^9, 3.5679310572150345`*^9, 
   3.5679312092997017`*^9, 3.5679313303091145`*^9, 3.5679314657017527`*^9, 
   3.567931518711645*^9, 3.567931624511031*^9, 3.567931949007201*^9, 
   3.567932630400798*^9, 3.567932749912608*^9, 3.567933124454666*^9, 
   3.567933231720454*^9, 3.56793346285046*^9, 3.5679347088412485`*^9, 
   3.567935970728465*^9, 3.568115002619152*^9, 3.5681159071253414`*^9, 
   3.568122251925686*^9, 3.568122353981065*^9, 3.5681234110243216`*^9, 
   3.568895115148609*^9, 3.568895482108054*^9, {3.5703549461546116`*^9, 
   3.570354957823432*^9}, 3.5703573260801916`*^9, 3.570357445265401*^9, 
   3.570357531892353*^9, 3.57035760975209*^9, 3.5703577456917286`*^9, 
   3.5703578035834303`*^9, 3.57035784887031*^9, 3.5703579039072065`*^9, 
   3.5703579386172676`*^9, 3.57035800260858*^9, 3.570358231367382*^9, 
   3.570358627015277*^9, 3.5703592157613106`*^9, 3.5703593062570696`*^9, 
   3.5703598571408377`*^9, 3.5703601271617117`*^9, 3.5703609963494387`*^9, 
   3.5703610755975776`*^9, 3.5703612145782213`*^9, 3.5703614867987*^9, 
   3.570361567716042*^9, 3.570361668367419*^9, 3.570361877407786*^9, 
   3.570362843534083*^9, 3.570363006554369*^9, 3.5703631490762196`*^9, 
   3.5703632375127745`*^9, 3.570363298540082*^9, 3.5703633608309917`*^9, 
   3.570363555924934*^9, 3.570364084297862*^9, 3.570364164341603*^9, 
   3.5703643655049562`*^9, 3.5703644715695424`*^9, 3.5703645571824927`*^9, 
   3.5703647229015837`*^9, 3.5703648614766273`*^9, 3.5703649325659523`*^9, 
   3.570365043622547*^9, {3.5703653939211626`*^9, 3.570365402657178*^9}, 
   3.5703654621868825`*^9, 3.570365726217346*^9, 3.570365790364659*^9, {
   3.570365854184371*^9, 3.570365873154004*^9}, 3.5703659362249146`*^9, 
   3.5703659878454056`*^9, 3.5703660955177946`*^9, 3.5703661752963347`*^9, 
   3.5703662319244347`*^9, 3.5703662962745476`*^9, 3.570366338332221*^9, 
   3.5703664051783385`*^9, 3.5703664365655937`*^9, 3.5703665723794327`*^9, 
   3.570366945001687*^9, 3.570367244662613*^9, 3.5703673997112856`*^9, 
   3.5703674942786517`*^9, 3.5703677596517177`*^9, 3.5703678073410015`*^9, 
   3.5703678638755007`*^9, 3.5703685567195177`*^9, 3.5703686385416613`*^9, 
   3.570368782155514*^9, 3.570368869328467*^9, 3.570368929794173*^9, 
   3.570426909424571*^9, 3.5704275269048557`*^9, 3.5704275964819775`*^9, 
   3.5704276663701005`*^9, 3.5704277532622533`*^9, 3.570431939843607*^9, 
   3.5704321823616323`*^9, 3.570433096851839*^9, 3.570436513389956*^9, 
   3.570438037621833*^9, 3.570438170129466*^9, 3.570438258878022*^9, 
   3.570438350543783*^9, 3.5704385713933706`*^9, 3.570438755302094*^9, 
   3.5704388113685923`*^9, 3.5769885463350496`*^9, 3.576989663610012*^9, 
   3.5769897123288975`*^9, 3.5769897552133727`*^9, 3.576989795726644*^9, 
   3.576990133217637*^9, 3.5769903137879543`*^9, 3.576990360385236*^9, 
   3.5769905264163275`*^9, 3.5769913878776407`*^9, 3.576991611566434*^9, 
   3.5769924501001067`*^9, 3.576992811911542*^9, 3.5769933535600934`*^9, 
   3.5769934306086287`*^9, 3.576993734855963*^9, 3.5769941731397333`*^9, 
   3.57699510530377*^9, 3.576995249089223*^9, 3.584427162176426*^9, 
   3.5844272951978593`*^9, 3.5844273969568377`*^9, 3.5844276668217115`*^9, 
   3.584427731218625*^9, 3.5844280217233353`*^9, 3.584428063718609*^9, 
   3.5844284676189184`*^9, 3.584428588690731*^9, 3.584428768123246*^9, 
   3.5844292424420795`*^9, 3.5844293232814217`*^9, 3.5844293642158933`*^9, 
   3.584429426397602*^9, 3.5844295923194942`*^9, 3.5844299876875887`*^9, 
   3.5844315091592607`*^9, 3.584431982184292*^9, 3.617688620539112*^9, 
   3.6176886668991766`*^9, 3.617688743839285*^9, 3.6176888136093826`*^9, 
   3.6176888522094364`*^9, 3.617688898433549*^9, 3.617689373349262*^9, 
   3.617689415319321*^9, 3.617689528813528*^9, 3.6176896089736404`*^9, 
   3.617689773783871*^9, 3.6628758918197355`*^9, 3.6630604720680695`*^9, 
   3.6630605186008615`*^9, 3.6630606291666784`*^9, 3.6630607029941254`*^9, 
   3.690020733204571*^9, 3.690020876754571*^9, 3.690021106504571*^9, 
   3.6900261026425705`*^9, 3.690026177342571*^9, 3.910340376824515*^9, 
   3.910344372682563*^9, 3.9567389364440346`*^9, 3.9568088656077175`*^9, 
   3.957359840154871*^9, 3.9574060843580666`*^9, 3.958698673584835*^9, 
   3.9596015171438274`*^9, 3.959615877397644*^9, 3.9596944351825333`*^9, 
   3.9597012505996513`*^9, 3.9597013365272503`*^9, 3.9597014849749336`*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"03a10ec3-8cae-0c45-967e-7f241d415e39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "1. ",
 StyleBox["Initialization",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsection",
 CellChangeTimes->{{3.576988657188844*^9, 3.576988658280846*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"4e20abc8-318f-43fd-b033-972527f51d6b"],

Cell["1.0. TODO list", "Subsubsection",ExpressionUUID->"5a03847b-4624-4ebb-b440-c33f5c273685"],

Cell[CellGroupData[{

Cell["1.1. GPL", "Subsubsection",ExpressionUUID->"51944893-e166-41d2-8b3f-5c16f96d9cef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"SpaceSpinors", ":", " ", 
    RowBox[{
    "Handling", " ", "of", " ", "space", " ", "spinor", " ", 
     "expressions"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Copyright", " ", 
     RowBox[{"(", "C", ")"}], " ", "2015"}], "-", 
    RowBox[{"2025", " ", "Thomas", " ", "B\[ADoubleDot]ckdahl"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", " ", "it", " ", "under", " ",
       "the", " ", "terms", " ", "of", " ", "the", " ", "GNU", " ", "General",
       " ", "Public", " ", "License", " ", "as", " ", "published", " ", "by", 
      " ", "the", " ", "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], 
     " ", "program", " ", "is", " ", "distributed", " ", "in", " ", "the", 
     " ", "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", 
     "useful"}], ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", " ", 
      "General", " ", "Public", " ", "License", " ", "for", " ", "more", " ", 
      
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], 
      " ", "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ",
       "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", " ", "along", " ", "with", " ", "this", " ", "program"}], 
     ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", " ", 
     "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", " ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744689999872*^9, 3.5157447334903593`*^9}, {
   3.5159382492443514`*^9, 3.515938255219162*^9}, {3.544107100285116*^9, 
   3.5441071015331182`*^9}, 3.567188293812725*^9, {3.5703532799926853`*^9, 
   3.57035331145794*^9}, {3.690017759702571*^9, 3.690017760922571*^9}, 
   3.690017791042571*^9, 3.690025830820571*^9, {3.9567389418515835`*^9, 
   3.9567389423213253`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"036ec658-714f-4b68-91b2-2a6f99229f8a"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Info package", "Subsubsection",ExpressionUUID->"17e0739e-f29e-4f30-a935-773fc524be2a"],

Cell["\<\
(* :Title: SpaceSpinors *)

(* :Author: Thomas B\[ADoubleDot]ckdahl *)

(* :Summary: Handling of space spinor expressions *)

(* :Brief Discussion:
   - Handles space spinor expressions. *)
  
(* :Context: xAct`SpaceSpinors` *)

(* :Package Version: 0.1.3 *)

(* :Copyright: Thomas B\[ADoubleDot]ckdahl (2015-2025) *)

(* :History: See SpaceSpinors.History *)

(* :Keywords: *)

(* :Source: SpaceSpinors.nb *)

(* :Warning: *)

(* :Mathematica Version: 8.0 and later *)

(* :Limitations:
\t- Only abstract indices can be used. *)
\t
(* :Acknowledgements:
\tThe autor would like to thank A. Garc\[IAcute]a-Parrado
\tand Steffen Aksteiner for helpful comments. *)\
\>", "Input",
 PageWidth->PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellChangeTimes->{{3.52748768805377*^9, 3.5274877167110205`*^9}, 
   3.5292359425009155`*^9, {3.529237855818076*^9, 3.5292378954733458`*^9}, 
   3.534068072144915*^9, {3.537679017041196*^9, 3.537679018772799*^9}, 
   3.5441071118759365`*^9, {3.56718831328156*^9, 3.567188332438393*^9}, {
   3.56718841025133*^9, 3.5671884486117973`*^9}, {3.5703533217695584`*^9, 
   3.570353449689783*^9}, 3.6408760520804515`*^9, {3.690017780662571*^9, 
   3.6900177998025713`*^9}, {3.690017837932571*^9, 3.690017849042571*^9}, {
   3.6900258308905706`*^9, 3.6900258310605707`*^9}, {3.6900258848305707`*^9, 
   3.6900258850505705`*^9}, {3.956738951504774*^9, 3.9567389541437187`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"7bd45ce1-3ff4-4bd9-a30e-74fd8910ce60"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. BeginPackage", "Subsubsection",ExpressionUUID->"e768ec32-e706-485e-9e49-8783ddbbff06"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`SpaceSpinors`\>\""}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4232371765761337`*^9, 3.4232371975315447`*^9}, {
   3.5157446135334983`*^9, 3.5157446161936502`*^9}, 3.5159382952176323`*^9, {
   3.570353461920204*^9, 3.5703534651650105`*^9}, 3.690025831070571*^9},
 CellLabel->"In[31]:=",ExpressionUUID->"e1a06c66-48f4-42b8-83b9-4090cd93ab6b"],

Cell[TextData[{
 "Explicit (not hidden) import of ",
 StyleBox["TexAct,",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " ",
 StyleBox["SymManipulator,",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " ",
 StyleBox["Spinors,",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", ",
 StyleBox["xPerm",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " and ",
 StyleBox["xCore",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ":"
}], "Text",
 CellChangeTimes->{{3.57035348776945*^9, 3.5703535035722775`*^9}, {
  3.5703538815775414`*^9, 3.5703538894243555`*^9}, {3.570353941466047*^9, 
  3.5703539460368547`*^9}},ExpressionUUID->"71776b15-73c9-4381-bc7e-\
32fc2d274dcf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`SpaceSpinors`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<xAct`SymSpin`\>\"", ",", "\"\<xAct`TexAct`\>\"", ",", 
     "\"\<xAct`SymManipulator`\>\"", ",", "\"\<xAct`Spinors`\>\"", ",", 
     "\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", ",", 
     "\"\<xAct`xCore`\>\""}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744641041072*^9, 3.515744644398264*^9}, 
   3.5159383064496517`*^9, {3.570353474181826*^9, 3.570353477348632*^9}, {
   3.570353512355093*^9, 3.5703535203579073`*^9}, {3.5703538965847683`*^9, 
   3.5703539054455833`*^9}, {3.570353951294064*^9, 3.5703539570660744`*^9}, 
   3.6900258310805707`*^9, {3.956738860690817*^9, 3.956738868184244*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"7c8902e5-15c0-46e8-ae20-cc7a7c2566a2"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014851274967`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"c601d585-9e27-5144-87b1-e170563e89f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014851284943`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"0c8a3c0d-811d-f64f-93ed-7dd3a672ebdd"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.959701485140465*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"70008e09-796d-db4d-9ebc-db1f4ea1c66e"],

Cell[BoxData["\<\"Connecting to external MinGW executable...\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.959701485214266*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"b29afd35-74a2-744c-b16f-3b457f47d3a2"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014853449173`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"208dea5e-32c3-0b44-bfa6-be16ee0afad2"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.959701485345913*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"4880d4d9-62d7-e14e-99ab-907c0cd9dbd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014853469124`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"b464d1d0-2097-4b4a-8ff2-0c558555250e"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.959701485348936*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"a8fbfe11-36b8-0947-a6d8-9de2eb5d499b"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014854675884`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"e50c4fdb-d9ba-bc47-ac67-d48f1721a4a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SymManipulator`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.9.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2024", ",", "4", ",", "30"}], "}"}]}],
  SequenceForm[
  "Package xAct`SymManipulator`  version ", "0.9.6", ", ", {2024, 4, 30}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014854695835`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"e61dd66e-ee80-2c4f-a849-f9b28d683762"],

Cell[BoxData["\<\"CopyRight (C) 2011-2021, Thomas B\[ADoubleDot]ckdahl, under \
the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.959701485470583*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"3004751b-6a85-d242-874b-ff4793fb0e50"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014855364056`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"480bc76d-f1bd-bf47-9f75-8fe39398ff9e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`TexAct`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.4.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "6", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`TexAct`  version ", "0.4.5", ", ", {2025, 6, 23}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014855374336`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"c99333ac-09f9-0541-a15a-bf09fcf654f3"],

Cell[BoxData["\<\"CopyRight (C) 2008-2021, Thomas B\[ADoubleDot]ckdahl, Jose \
M. Martin-Garcia and Barry Wardell, under the General Public License.\"\>"], \
"Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014855384293`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"dd2b1dc5-c89c-ce4a-9c39-960895e70d30"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.959701485625168*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"86ae22a3-ee46-a246-8b87-7ee44bb848c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.6", ", ", {2021, 2, 28}],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014856261654`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"120dae2d-9b8e-bb4b-95b5-4f17249252c1"],

Cell[BoxData["\<\"CopyRight (C) 2005-2021, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014856271896`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"de4cb892-8cc7-e449-a250-9841d9f428bb"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014888475494`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"ea406618-5352-e442-9159-2c8368c2ccf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Spinors`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`Spinors`  version ", "1.0.6", ", ", {2021, 2, 28}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014888495445`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"7b211808-6894-e248-97fa-f734beb2253f"],

Cell[BoxData["\<\"CopyRight (C) 2006-2018, Alfonso Garcia-Parrado Gomez-Lobo \
and Jose M. Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.959701488850569*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"67f17470-014a-da41-941c-e361c1438155"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014888784657`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"0e740901-78b4-0e43-a826-e7d30934e0bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SpinFrames`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.5.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "6", ",", "8"}], "}"}]}],
  SequenceForm[
  "Package xAct`SpinFrames`  version ", "0.5.5", ", ", {2025, 6, 8}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014888804626`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"c713811d-47f1-4142-b0d0-e5cb03fb7f02"],

Cell[BoxData["\<\"CopyRight (C) 2014-2024, Thomas B\[ADoubleDot]ckdahl and \
Steffen Aksteiner, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014888814583`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"49f19cad-6198-0641-916d-f08f83c5f1ca"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014889103813`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"1fd55fd8-ac03-f44d-8163-9f5ccdab45cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SymSpin`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.1.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "6", ",", "23"}], "}"}]}],
  SequenceForm[
  "Package xAct`SymSpin`  version ", "0.1.3", ", ", {2025, 6, 23}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014889123764`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"42ed5698-f685-db45-a402-7104d78f8008"],

Cell[BoxData["\<\"CopyRight (C) 2021, Steffen Aksteiner and Thomas B\
\[ADoubleDot]ckdahl, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.570365403437179*^9, 3.5703654629668837`*^9, 3.5703657270285473`*^9, 
   3.57036579117586*^9, {3.570365854995572*^9, 3.5703658739652057`*^9}, 
   3.5703659370361166`*^9, 3.570365988641007*^9, 3.570366096328996*^9, 
   3.5703661761075363`*^9, 3.5703662327356358`*^9, 3.5703662970545487`*^9, 
   3.5703663391122227`*^9, 3.57036640597394*^9, 3.5703664373455954`*^9, 
   3.5703665731594334`*^9, 3.570366945797288*^9, 3.5703672454738145`*^9, 
   3.5703674005224867`*^9, 3.5703674950898533`*^9, 3.570367760447319*^9, 
   3.570367808121003*^9, 3.5703678646555023`*^9, 3.5703685575307193`*^9, 
   3.570368639352863*^9, 3.570368782966715*^9, 3.5703688701396685`*^9, 
   3.5703689305741744`*^9, 3.5704269107817736`*^9, 3.5704275276692567`*^9, 
   3.570427597246379*^9, 3.570427667103302*^9, 3.5704277539954543`*^9, 
   3.570431940623608*^9, 3.570432183126034*^9, 3.5704330976162405`*^9, 
   3.5704365141231575`*^9, 3.5704380384018345`*^9, 3.5704381708938675`*^9, 
   3.5704382596268234`*^9, 3.5704383512925844`*^9, 3.570438572142172*^9, 
   3.570438756066495*^9, 3.5704388121329937`*^9, 3.5769885485502534`*^9, 
   3.5769896643744135`*^9, 3.576989713108899*^9, 3.5769897560245743`*^9, 
   3.576989796506645*^9, 3.576990133982038*^9, 3.5769903145523553`*^9, 
   3.5769903611652374`*^9, 3.576990527196329*^9, 3.576991388642042*^9, 
   3.576991612315235*^9, 3.5769924508645077`*^9, 3.576992812707144*^9, 
   3.576993354324495*^9, 3.57699343135743*^9, 3.5769937356047645`*^9, 
   3.576994173935334*^9, 3.576995106099372*^9, 3.576995249838024*^9, 
   3.5844271623012257`*^9, 3.5844272953226595`*^9, 3.584427397097238*^9, 
   3.584427666962112*^9, 3.584427731359025*^9, 3.5844280218637357`*^9, 
   3.5844280638434095`*^9, 3.5844284677749186`*^9, 3.5844285888155313`*^9, 
   3.5844287682792463`*^9, 3.5844292425668793`*^9, 3.5844293234062214`*^9, 
   3.584429364371894*^9, 3.584429426522403*^9, 3.584429592444294*^9, 
   3.5844299879683886`*^9, 3.584431509284061*^9, 3.584431982309092*^9, 
   3.6176886206491117`*^9, 3.617688666999177*^9, 3.617688743929285*^9, 
   3.6176888136893826`*^9, 3.6176888522894363`*^9, 3.617688898513549*^9, 
   3.6176893734592624`*^9, 3.6176894154093213`*^9, 3.6176895289235287`*^9, 
   3.6176896090836406`*^9, 3.617689773883871*^9, 3.6628758919497356`*^9, 
   3.6630604722080774`*^9, 3.663060518730869*^9, 3.663060629306655*^9, 
   3.663060703134102*^9, 3.6900207333545713`*^9, 3.690020876914571*^9, 
   3.690021106654571*^9, 3.690026102792571*^9, 3.690026177472571*^9, 
   3.9103403769751196`*^9, 3.9103443728510857`*^9, 3.9597012507402744`*^9, 
   3.959701336697796*^9, 3.9597014889143696`*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"a65a0b56-cf4b-634a-9b0c-16a8164f8eb0"]
}, Open  ]],

Cell[BoxData["\<\"xAct`SpaceSpinors`\"\>"], "Output",
 CellChangeTimes->{3.6900261031525707`*^9, 3.6900261777725706`*^9, 
  3.9103403774329786`*^9, 3.9103443733138943`*^9, 3.959701253461025*^9, 
  3.9597013398104706`*^9, 3.9597014889412994`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"f37eb745-af0d-054b-aa01-07eadf020dc8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "xAct`xCore`Private`bars", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`SpaceSpinors`  version \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<CopyRight (C) 2013-2015, Thomas B\[ADoubleDot]ckdahl, under the \
General Public License.\>\"", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5157446619242663`*^9, 3.5157446758810644`*^9}, {
   3.5157447480631933`*^9, 3.515744750743346*^9}, {3.515938308727256*^9, 
   3.515938317666072*^9}, {3.567188468470632*^9, 3.567188472292639*^9}, {
   3.6176919983538384`*^9, 3.6176920074838514`*^9}, 3.640876065426857*^9, 
   3.690025831110571*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"38f27d83-3490-4d52-a6b5-36911e0f00ed"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.520174849509264*^9, 3.5201755960989656`*^9, 3.520175968590816*^9, 
   3.520176096258639*^9, 3.5201762704681425`*^9, 3.520176756057991*^9, 
   3.5201779236516304`*^9, 3.520177973427715*^9, 3.5201780339410205`*^9, 
   3.5201781232217736`*^9, 3.520178324027721*^9, 3.52017901033572*^9, 
   3.5201791108454947`*^9, 3.5201791936240377`*^9, 3.5201792382921157`*^9, 
   3.520179284833394*^9, 3.520179463876904*^9, 3.520179551655855*^9, 
   3.5201813601618013`*^9, 3.5201816366154847`*^9, 3.5202685625118937`*^9, 
   3.520268730947734*^9, 3.5202688625719223`*^9, 3.5202688996803756`*^9, 
   3.5202690919982476`*^9, 3.520271814190901*^9, 3.520310605197149*^9, 
   3.5203109866249046`*^9, 3.520311787180435*^9, 3.5203121049047127`*^9, {
   3.5271449361606693`*^9, 3.527144937439872*^9}, 3.5271458083914013`*^9, 
   3.5271460019419413`*^9, 3.527147022965735*^9, 3.5271475939589376`*^9, 
   3.5271480468755336`*^9, 3.527148264183915*^9, 3.52714868648586*^9, 
   3.5271500507716565`*^9, 3.527150172997871*^9, 3.5271503536149883`*^9, 
   3.527150507556059*^9, 3.5271507919913583`*^9, 3.5271508653426867`*^9, 
   3.529230823877325*^9, 3.529232467059411*^9, 3.529232571751195*^9, 
   3.5292359095068574`*^9, 3.5292362175137987`*^9, 3.529236417194149*^9, 
   3.5292366545797663`*^9, 3.529236716075074*^9, 3.529236967176115*^9, 
   3.529237057671874*^9, 3.5340685699417896`*^9, 3.53406895170566*^9, 
   3.534069382718817*^9, 3.534069951854617*^9, 3.5340701769318123`*^9, 
   3.5342496371721635`*^9, 3.537621498672197*^9, 3.5376216251884193`*^9, 
   3.5376228419447565`*^9, {3.537622948446143*^9, 3.537622964373771*^9}, 
   3.5376231829301553`*^9, 3.537623361519269*^9, 3.5376254399285192`*^9, 
   3.5376287896154747`*^9, 3.53769469982747*^9, 3.5376948677461653`*^9, 
   3.537695501762479*^9, 3.5376955815566187`*^9, 3.537695913229801*^9, 
   3.537696395239448*^9, 3.5376971050104947`*^9, 3.5376974604259186`*^9, {
   3.537697970624815*^9, 3.5376979912324514`*^9}, 3.537700570638586*^9, 
   3.5377009886725206`*^9, 3.5377011498208036`*^9, 3.537705075508299*^9, 
   3.5377676499514885`*^9, 3.537780185987508*^9, 3.5377805838974066`*^9, 
   3.5377809208901987`*^9, 3.5377810799168777`*^9, 3.5377812420011625`*^9, 
   3.5377813781426015`*^9, 3.537781527200863*^9, 3.5377817255864115`*^9, 
   3.537782399040595*^9, 3.5377827398387933`*^9, 3.5377829310015287`*^9, 
   3.537783191740387*^9, 3.537783440546224*^9, 3.5377835728656564`*^9, 
   3.537784107868596*^9, 3.5377842446964364`*^9, 3.544092209221161*^9, 
   3.544097239984397*^9, 3.5440973654710174`*^9, 3.544097952797449*^9, 
   3.544099754133613*^9, 3.5441033727023687`*^9, 3.544103463868929*^9, 
   3.544103705030752*^9, 3.5441039174563255`*^9, 3.5441040518505616`*^9, 
   3.544105099611802*^9, 3.5441057142684813`*^9, 3.544105949064494*^9, 
   3.544107147443999*^9, 3.544591253200247*^9, 3.5445914903948135`*^9, 
   3.5445916527811017`*^9, 3.5445929046057014`*^9, 3.5446721730552063`*^9, 
   3.5446723745247297`*^9, 3.544673273684159*^9, {3.5446733821943655`*^9, 
   3.5446734029125504`*^9}, 3.5449492188490252`*^9, 3.544951614114234*^9, 
   3.5450156626813335`*^9, 3.5450157245042424`*^9, 3.5451061422266493`*^9, 
   3.5451140205734205`*^9, 3.5528211954218016`*^9, 3.552822659532173*^9, 
   3.5528227955020123`*^9, 3.552822986681348*^9, 3.5528231958777156`*^9, 
   3.5528236662185416`*^9, 3.552823971168877*^9, 3.5528261166260457`*^9, 
   3.552826309287384*^9, 3.554207271336712*^9, 3.5542084668468113`*^9, 
   3.5613716974352193`*^9, 3.561732586327607*^9, 3.561779198364607*^9, 
   3.5617814879670286`*^9, 3.561781561957958*^9, 3.5617816529217176`*^9, 
   3.5617819012741547`*^9, 3.561781933675411*^9, 3.5617821014079056`*^9, 
   3.5617821946492696`*^9, 3.561782388074009*^9, 3.561782492562993*^9, 
   3.5617825257130513`*^9, 3.561784234167652*^9, 3.5627666270141516`*^9, 
   3.5627667438427563`*^9, 3.5627670822697515`*^9, 3.562767893144575*^9, 
   3.562769545796878*^9, 3.5627696677110925`*^9, {3.5627711276260567`*^9, 
   3.562771147063691*^9}, 3.562773114181346*^9, 3.5627732020563*^9, 
   3.5628212717716117`*^9, 3.562822345818898*^9, 3.562823597723097*^9, 
   3.5628236609812083`*^9, 3.5628240618239126`*^9, 3.562824598637455*^9, 
   3.5628252433865876`*^9, 3.562825311761508*^9, 3.562825371806013*^9, 
   3.562825959194845*^9, 3.5628261338527517`*^9, 3.562826247904552*^9, 
   3.5628280657185726`*^9, 3.5628285638898478`*^9, 3.562828736504151*^9, 
   3.5628288786984005`*^9, 3.56283048949683*^9, 3.5628313051442623`*^9, 
   3.5628316998415556`*^9, 3.5628318197277665`*^9, 3.5628318516454225`*^9, 
   3.5628323081802244`*^9, 3.5628324215456233`*^9, 3.5628327291781635`*^9, 
   3.562833669814016*^9, 3.5628337642409816`*^9, 3.5628338348467054`*^9, 
   3.563425632980192*^9, 3.5634263671330814`*^9, 3.563427213529168*^9, 
   3.5634286993859777`*^9, 3.56342879144174*^9, 3.563428870143878*^9, 
   3.563429666479477*^9, 3.5641236126968374`*^9, 3.5641243458523254`*^9, 
   3.5641248624014325`*^9, 3.5641250176227055`*^9, 3.5641304420898333`*^9, 
   3.5646350262366266`*^9, 3.5646354978254547`*^9, 3.56467212978749*^9, 
   3.565759287764366*^9, 3.5657736669648347`*^9, 3.5658920235955*^9, 
   3.5661948526742287`*^9, 3.566203971352671*^9, 3.5662119037940655`*^9, 
   3.5662126406527605`*^9, 3.566214734004837*^9, 3.5663991503037367`*^9, 
   3.56654371253712*^9, 3.567082814807329*^9, 3.5671851370203805`*^9, 
   3.5675865229115*^9, 3.567600479600524*^9, 3.5678594381939497`*^9, 
   3.567860570772539*^9, 3.5678613068452325`*^9, 3.5678615199572067`*^9, 
   3.567861619048581*^9, 3.567861715815551*^9, 3.5678618101177163`*^9, 
   3.5678620356317124`*^9, 3.5678622047516093`*^9, 3.567862536440392*^9, 
   3.5678626834706507`*^9, 3.5678627712988043`*^9, 3.5678633202949686`*^9, 
   3.5678634149403353`*^9, 3.567863936574051*^9, 3.567864088753319*^9, 
   3.5678642537860084`*^9, 3.5678647669801097`*^9, 3.567865015816147*^9, 
   3.567865314837472*^9, 3.5678655286212473`*^9, 3.56787745385496*^9, 
   3.5679119479404917`*^9, 3.5679130624376493`*^9, 3.5679169100195856`*^9, 
   3.5679176765113316`*^9, 3.567918361150734*^9, 3.5679186147915792`*^9, 
   3.567919444681837*^9, 3.5679197567447853`*^9, 3.5679242578890915`*^9, 
   3.5679261750866594`*^9, 3.5679264768847895`*^9, 3.5679268614566646`*^9, 
   3.567929473936054*^9, 3.567929590686659*^9, 3.5679296721344023`*^9, 
   3.567929856308326*^9, 3.5679300833677244`*^9, 3.567930174908685*^9, 
   3.5679303366497693`*^9, 3.567930622504671*^9, 3.567931058541037*^9, 
   3.5679312105477037`*^9, 3.567931331603917*^9, 3.5679314669965544`*^9, 
   3.5679315200376477`*^9, 3.5679316258214335`*^9, 3.5679319502864037`*^9, 
   3.5679326316332*^9, 3.56793275120741*^9, 3.567933125749468*^9, 
   3.5679332329996567`*^9, 3.567933464176462*^9, 3.5679347101828513`*^9, 
   3.5679359720232677`*^9, 3.568115004553556*^9, 3.568115908404544*^9, 
   3.5681222531580877`*^9, 3.5681223552758675`*^9, 3.568123412287924*^9, 
   3.568895116739812*^9, 3.5688954833872557`*^9, {3.5703549462170115`*^9, 
   3.5703549591338344`*^9}, 3.570357327359394*^9, 3.5703574465758033`*^9, 
   3.570357533202756*^9, 3.5703576111092925`*^9, 3.5703577470021315`*^9, 
   3.5703578048626328`*^9, 3.5703578501495123`*^9, 3.5703579051552086`*^9, 
   3.57035793992767*^9, 3.570358003887782*^9, 3.5703582327713842`*^9, 
   3.570358628356879*^9, 3.5703592170717134`*^9, 3.5703593076610727`*^9, 
   3.5703598584356394`*^9, 3.570360128456514*^9, 3.5703609977222404`*^9, 
   3.57036107700158*^9, 3.570361215935424*^9, 3.570361488155902*^9, 
   3.5703615690576444`*^9, 3.570361669709021*^9, 3.570361878780588*^9, 
   3.570362844813285*^9, 3.5703630119363785`*^9, 3.570363150433422*^9, 
   3.5703632389011774`*^9, 3.5703632998816843`*^9, 3.570363362188194*^9, 
   3.570363557297736*^9, 3.5703640865130663`*^9, 3.570364165698805*^9, 
   3.5703643668777585`*^9, 3.570364472957945*^9, 3.570364558570895*^9, 
   3.5703647243367863`*^9, 3.5703648628806295`*^9, 3.570364933938754*^9, 
   3.5703650449485493`*^9, {3.5703653939991627`*^9, 3.57036540396758*^9}, 
   3.570365463497285*^9, 3.570365727527748*^9, 3.5703657916282606`*^9, {
   3.5703658554635735`*^9, 3.5703658744644065`*^9}, 3.570365937550917*^9, 
   3.570365989124608*^9, 3.570366096843797*^9, 3.570366176591137*^9, 
   3.570366233250437*^9, 3.5703662975537496`*^9, 3.5703663396114235`*^9, 
   3.5703664064731407`*^9, 3.570366437813596*^9, 3.5703665736430345`*^9, 
   3.5703669462652893`*^9, 3.5703672460666156`*^9, 3.570367400974888*^9, 
   3.570367495667054*^9, 3.57036776096212*^9, 3.5703678086202035`*^9, 
   3.570367865154703*^9, 3.57036855806112*^9, 3.570368639914464*^9, 
   3.5703687835439157`*^9, 3.570368870607669*^9, 3.570368931073375*^9, 
   3.570426911265374*^9, 3.570427528152858*^9, 3.57042759776118*^9, 
   3.570427667618103*^9, 3.5704277544946556`*^9, 3.570431941169609*^9, 
   3.570432183640835*^9, 3.5704330981310415`*^9, 3.570436514606758*^9, 
   3.5704380390726357`*^9, 3.5704381714242687`*^9, 3.5704382601260242`*^9, 
   3.570438351822985*^9, 3.5704385726881733`*^9, 3.570438756596896*^9, 
   3.5704388126165943`*^9, 3.5769885490650544`*^9, 3.576989664858014*^9, 
   3.5769897136705*^9, 3.576989756508175*^9, 3.5769897970370464`*^9, 
   3.576990134528039*^9, 3.576990315035956*^9, 3.576990361633238*^9, 
   3.57699052775793*^9, 3.5769913891724434`*^9, 3.576991612830036*^9, 
   3.5769924513637085`*^9, 3.5769928131439443`*^9, 3.576993354808096*^9, 
   3.576993431872231*^9, 3.576993736181966*^9, 3.5769941744813356`*^9, 
   3.576995106551772*^9, 3.576995250337225*^9, 3.5844271627536263`*^9, 
   3.58442729568146*^9, 3.584427397518439*^9, 3.584427667289713*^9, 
   3.584427731717826*^9, 3.584428022269336*^9, 3.58442806420221*^9, 
   3.584428468180519*^9, 3.584428589236732*^9, 3.584428768638047*^9, 
   3.58442924292568*^9, 3.5844293237806225`*^9, 3.5844293647306943`*^9, 
   3.5844294268968034`*^9, 3.584429592881095*^9, 3.5844299883115897`*^9, 
   3.5844315096896615`*^9, 3.5844319827146926`*^9, 3.617688621069113*^9, 
   3.617688667369178*^9, 3.617688744289285*^9, 3.6176888140493827`*^9, 
   3.617688852649437*^9, 3.6176888988835497`*^9, 3.617689373889263*^9, 
   3.617689415809322*^9, 3.617689529333529*^9, 3.617689609503641*^9, 
   3.6176897742838717`*^9, 3.6628758923297367`*^9, 3.6630604725781*^9, 
   3.6630605191208925`*^9, 3.6630606296665936`*^9, 3.6630607035240355`*^9, 
   3.6900207337445707`*^9, 3.690020877254571*^9, 3.6900211069945707`*^9, 
   3.690026103162571*^9, 3.690026177782571*^9, 3.9103403774558897`*^9, 
   3.910344373322824*^9, 3.959701253719307*^9, 3.9597013401006947`*^9, 
   3.9597014892135696`*^9},
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"f9587f96-09db-4a4f-85c0-88e8fafc239d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SpaceSpinors`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.1.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "6", ",", "23"}], "}"}]}],
  SequenceForm[
  "Package xAct`SpaceSpinors`  version ", "0.1.3", ", ", {2025, 6, 23}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520174849509264*^9, 3.5201755960989656`*^9, 3.520175968590816*^9, 
   3.520176096258639*^9, 3.5201762704681425`*^9, 3.520176756057991*^9, 
   3.5201779236516304`*^9, 3.520177973427715*^9, 3.5201780339410205`*^9, 
   3.5201781232217736`*^9, 3.520178324027721*^9, 3.52017901033572*^9, 
   3.5201791108454947`*^9, 3.5201791936240377`*^9, 3.5201792382921157`*^9, 
   3.520179284833394*^9, 3.520179463876904*^9, 3.520179551655855*^9, 
   3.5201813601618013`*^9, 3.5201816366154847`*^9, 3.5202685625118937`*^9, 
   3.520268730947734*^9, 3.5202688625719223`*^9, 3.5202688996803756`*^9, 
   3.5202690919982476`*^9, 3.520271814190901*^9, 3.520310605197149*^9, 
   3.5203109866249046`*^9, 3.520311787180435*^9, 3.5203121049047127`*^9, {
   3.5271449361606693`*^9, 3.527144937439872*^9}, 3.5271458083914013`*^9, 
   3.5271460019419413`*^9, 3.527147022965735*^9, 3.5271475939589376`*^9, 
   3.5271480468755336`*^9, 3.527148264183915*^9, 3.52714868648586*^9, 
   3.5271500507716565`*^9, 3.527150172997871*^9, 3.5271503536149883`*^9, 
   3.527150507556059*^9, 3.5271507919913583`*^9, 3.5271508653426867`*^9, 
   3.529230823877325*^9, 3.529232467059411*^9, 3.529232571751195*^9, 
   3.5292359095068574`*^9, 3.5292362175137987`*^9, 3.529236417194149*^9, 
   3.5292366545797663`*^9, 3.529236716075074*^9, 3.529236967176115*^9, 
   3.529237057671874*^9, 3.5340685699417896`*^9, 3.53406895170566*^9, 
   3.534069382718817*^9, 3.534069951854617*^9, 3.5340701769318123`*^9, 
   3.5342496371721635`*^9, 3.537621498672197*^9, 3.5376216251884193`*^9, 
   3.5376228419447565`*^9, {3.537622948446143*^9, 3.537622964373771*^9}, 
   3.5376231829301553`*^9, 3.537623361519269*^9, 3.5376254399285192`*^9, 
   3.5376287896154747`*^9, 3.53769469982747*^9, 3.5376948677461653`*^9, 
   3.537695501762479*^9, 3.5376955815566187`*^9, 3.537695913229801*^9, 
   3.537696395239448*^9, 3.5376971050104947`*^9, 3.5376974604259186`*^9, {
   3.537697970624815*^9, 3.5376979912324514`*^9}, 3.537700570638586*^9, 
   3.5377009886725206`*^9, 3.5377011498208036`*^9, 3.537705075508299*^9, 
   3.5377676499514885`*^9, 3.537780185987508*^9, 3.5377805838974066`*^9, 
   3.5377809208901987`*^9, 3.5377810799168777`*^9, 3.5377812420011625`*^9, 
   3.5377813781426015`*^9, 3.537781527200863*^9, 3.5377817255864115`*^9, 
   3.537782399040595*^9, 3.5377827398387933`*^9, 3.5377829310015287`*^9, 
   3.537783191740387*^9, 3.537783440546224*^9, 3.5377835728656564`*^9, 
   3.537784107868596*^9, 3.5377842446964364`*^9, 3.544092209221161*^9, 
   3.544097239984397*^9, 3.5440973654710174`*^9, 3.544097952797449*^9, 
   3.544099754133613*^9, 3.5441033727023687`*^9, 3.544103463868929*^9, 
   3.544103705030752*^9, 3.5441039174563255`*^9, 3.5441040518505616`*^9, 
   3.544105099611802*^9, 3.5441057142684813`*^9, 3.544105949064494*^9, 
   3.544107147443999*^9, 3.544591253200247*^9, 3.5445914903948135`*^9, 
   3.5445916527811017`*^9, 3.5445929046057014`*^9, 3.5446721730552063`*^9, 
   3.5446723745247297`*^9, 3.544673273684159*^9, {3.5446733821943655`*^9, 
   3.5446734029125504`*^9}, 3.5449492188490252`*^9, 3.544951614114234*^9, 
   3.5450156626813335`*^9, 3.5450157245042424`*^9, 3.5451061422266493`*^9, 
   3.5451140205734205`*^9, 3.5528211954218016`*^9, 3.552822659532173*^9, 
   3.5528227955020123`*^9, 3.552822986681348*^9, 3.5528231958777156`*^9, 
   3.5528236662185416`*^9, 3.552823971168877*^9, 3.5528261166260457`*^9, 
   3.552826309287384*^9, 3.554207271336712*^9, 3.5542084668468113`*^9, 
   3.5613716974352193`*^9, 3.561732586327607*^9, 3.561779198364607*^9, 
   3.5617814879670286`*^9, 3.561781561957958*^9, 3.5617816529217176`*^9, 
   3.5617819012741547`*^9, 3.561781933675411*^9, 3.5617821014079056`*^9, 
   3.5617821946492696`*^9, 3.561782388074009*^9, 3.561782492562993*^9, 
   3.5617825257130513`*^9, 3.561784234167652*^9, 3.5627666270141516`*^9, 
   3.5627667438427563`*^9, 3.5627670822697515`*^9, 3.562767893144575*^9, 
   3.562769545796878*^9, 3.5627696677110925`*^9, {3.5627711276260567`*^9, 
   3.562771147063691*^9}, 3.562773114181346*^9, 3.5627732020563*^9, 
   3.5628212717716117`*^9, 3.562822345818898*^9, 3.562823597723097*^9, 
   3.5628236609812083`*^9, 3.5628240618239126`*^9, 3.562824598637455*^9, 
   3.5628252433865876`*^9, 3.562825311761508*^9, 3.562825371806013*^9, 
   3.562825959194845*^9, 3.5628261338527517`*^9, 3.562826247904552*^9, 
   3.5628280657185726`*^9, 3.5628285638898478`*^9, 3.562828736504151*^9, 
   3.5628288786984005`*^9, 3.56283048949683*^9, 3.5628313051442623`*^9, 
   3.5628316998415556`*^9, 3.5628318197277665`*^9, 3.5628318516454225`*^9, 
   3.5628323081802244`*^9, 3.5628324215456233`*^9, 3.5628327291781635`*^9, 
   3.562833669814016*^9, 3.5628337642409816`*^9, 3.5628338348467054`*^9, 
   3.563425632980192*^9, 3.5634263671330814`*^9, 3.563427213529168*^9, 
   3.5634286993859777`*^9, 3.56342879144174*^9, 3.563428870143878*^9, 
   3.563429666479477*^9, 3.5641236126968374`*^9, 3.5641243458523254`*^9, 
   3.5641248624014325`*^9, 3.5641250176227055`*^9, 3.5641304420898333`*^9, 
   3.5646350262366266`*^9, 3.5646354978254547`*^9, 3.56467212978749*^9, 
   3.565759287764366*^9, 3.5657736669648347`*^9, 3.5658920235955*^9, 
   3.5661948526742287`*^9, 3.566203971352671*^9, 3.5662119037940655`*^9, 
   3.5662126406527605`*^9, 3.566214734004837*^9, 3.5663991503037367`*^9, 
   3.56654371253712*^9, 3.567082814807329*^9, 3.5671851370203805`*^9, 
   3.5675865229115*^9, 3.567600479600524*^9, 3.5678594381939497`*^9, 
   3.567860570772539*^9, 3.5678613068452325`*^9, 3.5678615199572067`*^9, 
   3.567861619048581*^9, 3.567861715815551*^9, 3.5678618101177163`*^9, 
   3.5678620356317124`*^9, 3.5678622047516093`*^9, 3.567862536440392*^9, 
   3.5678626834706507`*^9, 3.5678627712988043`*^9, 3.5678633202949686`*^9, 
   3.5678634149403353`*^9, 3.567863936574051*^9, 3.567864088753319*^9, 
   3.5678642537860084`*^9, 3.5678647669801097`*^9, 3.567865015816147*^9, 
   3.567865314837472*^9, 3.5678655286212473`*^9, 3.56787745385496*^9, 
   3.5679119479404917`*^9, 3.5679130624376493`*^9, 3.5679169100195856`*^9, 
   3.5679176765113316`*^9, 3.567918361150734*^9, 3.5679186147915792`*^9, 
   3.567919444681837*^9, 3.5679197567447853`*^9, 3.5679242578890915`*^9, 
   3.5679261750866594`*^9, 3.5679264768847895`*^9, 3.5679268614566646`*^9, 
   3.567929473936054*^9, 3.567929590686659*^9, 3.5679296721344023`*^9, 
   3.567929856308326*^9, 3.5679300833677244`*^9, 3.567930174908685*^9, 
   3.5679303366497693`*^9, 3.567930622504671*^9, 3.567931058541037*^9, 
   3.5679312105477037`*^9, 3.567931331603917*^9, 3.5679314669965544`*^9, 
   3.5679315200376477`*^9, 3.5679316258214335`*^9, 3.5679319502864037`*^9, 
   3.5679326316332*^9, 3.56793275120741*^9, 3.567933125749468*^9, 
   3.5679332329996567`*^9, 3.567933464176462*^9, 3.5679347101828513`*^9, 
   3.5679359720232677`*^9, 3.568115004553556*^9, 3.568115908404544*^9, 
   3.5681222531580877`*^9, 3.5681223552758675`*^9, 3.568123412287924*^9, 
   3.568895116739812*^9, 3.5688954833872557`*^9, {3.5703549462170115`*^9, 
   3.5703549591338344`*^9}, 3.570357327359394*^9, 3.5703574465758033`*^9, 
   3.570357533202756*^9, 3.5703576111092925`*^9, 3.5703577470021315`*^9, 
   3.5703578048626328`*^9, 3.5703578501495123`*^9, 3.5703579051552086`*^9, 
   3.57035793992767*^9, 3.570358003887782*^9, 3.5703582327713842`*^9, 
   3.570358628356879*^9, 3.5703592170717134`*^9, 3.5703593076610727`*^9, 
   3.5703598584356394`*^9, 3.570360128456514*^9, 3.5703609977222404`*^9, 
   3.57036107700158*^9, 3.570361215935424*^9, 3.570361488155902*^9, 
   3.5703615690576444`*^9, 3.570361669709021*^9, 3.570361878780588*^9, 
   3.570362844813285*^9, 3.5703630119363785`*^9, 3.570363150433422*^9, 
   3.5703632389011774`*^9, 3.5703632998816843`*^9, 3.570363362188194*^9, 
   3.570363557297736*^9, 3.5703640865130663`*^9, 3.570364165698805*^9, 
   3.5703643668777585`*^9, 3.570364472957945*^9, 3.570364558570895*^9, 
   3.5703647243367863`*^9, 3.5703648628806295`*^9, 3.570364933938754*^9, 
   3.5703650449485493`*^9, {3.5703653939991627`*^9, 3.57036540396758*^9}, 
   3.570365463497285*^9, 3.570365727527748*^9, 3.5703657916282606`*^9, {
   3.5703658554635735`*^9, 3.5703658744644065`*^9}, 3.570365937550917*^9, 
   3.570365989124608*^9, 3.570366096843797*^9, 3.570366176591137*^9, 
   3.570366233250437*^9, 3.5703662975537496`*^9, 3.5703663396114235`*^9, 
   3.5703664064731407`*^9, 3.570366437813596*^9, 3.5703665736430345`*^9, 
   3.5703669462652893`*^9, 3.5703672460666156`*^9, 3.570367400974888*^9, 
   3.570367495667054*^9, 3.57036776096212*^9, 3.5703678086202035`*^9, 
   3.570367865154703*^9, 3.57036855806112*^9, 3.570368639914464*^9, 
   3.5703687835439157`*^9, 3.570368870607669*^9, 3.570368931073375*^9, 
   3.570426911265374*^9, 3.570427528152858*^9, 3.57042759776118*^9, 
   3.570427667618103*^9, 3.5704277544946556`*^9, 3.570431941169609*^9, 
   3.570432183640835*^9, 3.5704330981310415`*^9, 3.570436514606758*^9, 
   3.5704380390726357`*^9, 3.5704381714242687`*^9, 3.5704382601260242`*^9, 
   3.570438351822985*^9, 3.5704385726881733`*^9, 3.570438756596896*^9, 
   3.5704388126165943`*^9, 3.5769885490650544`*^9, 3.576989664858014*^9, 
   3.5769897136705*^9, 3.576989756508175*^9, 3.5769897970370464`*^9, 
   3.576990134528039*^9, 3.576990315035956*^9, 3.576990361633238*^9, 
   3.57699052775793*^9, 3.5769913891724434`*^9, 3.576991612830036*^9, 
   3.5769924513637085`*^9, 3.5769928131439443`*^9, 3.576993354808096*^9, 
   3.576993431872231*^9, 3.576993736181966*^9, 3.5769941744813356`*^9, 
   3.576995106551772*^9, 3.576995250337225*^9, 3.5844271627536263`*^9, 
   3.58442729568146*^9, 3.584427397518439*^9, 3.584427667289713*^9, 
   3.584427731717826*^9, 3.584428022269336*^9, 3.58442806420221*^9, 
   3.584428468180519*^9, 3.584428589236732*^9, 3.584428768638047*^9, 
   3.58442924292568*^9, 3.5844293237806225`*^9, 3.5844293647306943`*^9, 
   3.5844294268968034`*^9, 3.584429592881095*^9, 3.5844299883115897`*^9, 
   3.5844315096896615`*^9, 3.5844319827146926`*^9, 3.617688621069113*^9, 
   3.617688667369178*^9, 3.617688744289285*^9, 3.6176888140493827`*^9, 
   3.617688852649437*^9, 3.6176888988835497`*^9, 3.617689373889263*^9, 
   3.617689415809322*^9, 3.617689529333529*^9, 3.617689609503641*^9, 
   3.6176897742838717`*^9, 3.6628758923297367`*^9, 3.6630604725781*^9, 
   3.6630605191208925`*^9, 3.6630606296665936`*^9, 3.6630607035240355`*^9, 
   3.6900207337445707`*^9, 3.690020877254571*^9, 3.6900211069945707`*^9, 
   3.690026103162571*^9, 3.690026177782571*^9, 3.9103403774558897`*^9, 
   3.910344373322824*^9, 3.959701253719307*^9, 3.9597013401006947`*^9, 
   3.9597014892165623`*^9},
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"13fa6750-80f4-204e-832d-27e3b9453ef8"],

Cell[BoxData["\<\"CopyRight (C) 2013-2015, Thomas B\[ADoubleDot]ckdahl, under \
the General Public License.\"\>"], "Print",
 CellChangeTimes->{
  3.520174849509264*^9, 3.5201755960989656`*^9, 3.520175968590816*^9, 
   3.520176096258639*^9, 3.5201762704681425`*^9, 3.520176756057991*^9, 
   3.5201779236516304`*^9, 3.520177973427715*^9, 3.5201780339410205`*^9, 
   3.5201781232217736`*^9, 3.520178324027721*^9, 3.52017901033572*^9, 
   3.5201791108454947`*^9, 3.5201791936240377`*^9, 3.5201792382921157`*^9, 
   3.520179284833394*^9, 3.520179463876904*^9, 3.520179551655855*^9, 
   3.5201813601618013`*^9, 3.5201816366154847`*^9, 3.5202685625118937`*^9, 
   3.520268730947734*^9, 3.5202688625719223`*^9, 3.5202688996803756`*^9, 
   3.5202690919982476`*^9, 3.520271814190901*^9, 3.520310605197149*^9, 
   3.5203109866249046`*^9, 3.520311787180435*^9, 3.5203121049047127`*^9, {
   3.5271449361606693`*^9, 3.527144937439872*^9}, 3.5271458083914013`*^9, 
   3.5271460019419413`*^9, 3.527147022965735*^9, 3.5271475939589376`*^9, 
   3.5271480468755336`*^9, 3.527148264183915*^9, 3.52714868648586*^9, 
   3.5271500507716565`*^9, 3.527150172997871*^9, 3.5271503536149883`*^9, 
   3.527150507556059*^9, 3.5271507919913583`*^9, 3.5271508653426867`*^9, 
   3.529230823877325*^9, 3.529232467059411*^9, 3.529232571751195*^9, 
   3.5292359095068574`*^9, 3.5292362175137987`*^9, 3.529236417194149*^9, 
   3.5292366545797663`*^9, 3.529236716075074*^9, 3.529236967176115*^9, 
   3.529237057671874*^9, 3.5340685699417896`*^9, 3.53406895170566*^9, 
   3.534069382718817*^9, 3.534069951854617*^9, 3.5340701769318123`*^9, 
   3.5342496371721635`*^9, 3.537621498672197*^9, 3.5376216251884193`*^9, 
   3.5376228419447565`*^9, {3.537622948446143*^9, 3.537622964373771*^9}, 
   3.5376231829301553`*^9, 3.537623361519269*^9, 3.5376254399285192`*^9, 
   3.5376287896154747`*^9, 3.53769469982747*^9, 3.5376948677461653`*^9, 
   3.537695501762479*^9, 3.5376955815566187`*^9, 3.537695913229801*^9, 
   3.537696395239448*^9, 3.5376971050104947`*^9, 3.5376974604259186`*^9, {
   3.537697970624815*^9, 3.5376979912324514`*^9}, 3.537700570638586*^9, 
   3.5377009886725206`*^9, 3.5377011498208036`*^9, 3.537705075508299*^9, 
   3.5377676499514885`*^9, 3.537780185987508*^9, 3.5377805838974066`*^9, 
   3.5377809208901987`*^9, 3.5377810799168777`*^9, 3.5377812420011625`*^9, 
   3.5377813781426015`*^9, 3.537781527200863*^9, 3.5377817255864115`*^9, 
   3.537782399040595*^9, 3.5377827398387933`*^9, 3.5377829310015287`*^9, 
   3.537783191740387*^9, 3.537783440546224*^9, 3.5377835728656564`*^9, 
   3.537784107868596*^9, 3.5377842446964364`*^9, 3.544092209221161*^9, 
   3.544097239984397*^9, 3.5440973654710174`*^9, 3.544097952797449*^9, 
   3.544099754133613*^9, 3.5441033727023687`*^9, 3.544103463868929*^9, 
   3.544103705030752*^9, 3.5441039174563255`*^9, 3.5441040518505616`*^9, 
   3.544105099611802*^9, 3.5441057142684813`*^9, 3.544105949064494*^9, 
   3.544107147443999*^9, 3.544591253200247*^9, 3.5445914903948135`*^9, 
   3.5445916527811017`*^9, 3.5445929046057014`*^9, 3.5446721730552063`*^9, 
   3.5446723745247297`*^9, 3.544673273684159*^9, {3.5446733821943655`*^9, 
   3.5446734029125504`*^9}, 3.5449492188490252`*^9, 3.544951614114234*^9, 
   3.5450156626813335`*^9, 3.5450157245042424`*^9, 3.5451061422266493`*^9, 
   3.5451140205734205`*^9, 3.5528211954218016`*^9, 3.552822659532173*^9, 
   3.5528227955020123`*^9, 3.552822986681348*^9, 3.5528231958777156`*^9, 
   3.5528236662185416`*^9, 3.552823971168877*^9, 3.5528261166260457`*^9, 
   3.552826309287384*^9, 3.554207271336712*^9, 3.5542084668468113`*^9, 
   3.5613716974352193`*^9, 3.561732586327607*^9, 3.561779198364607*^9, 
   3.5617814879670286`*^9, 3.561781561957958*^9, 3.5617816529217176`*^9, 
   3.5617819012741547`*^9, 3.561781933675411*^9, 3.5617821014079056`*^9, 
   3.5617821946492696`*^9, 3.561782388074009*^9, 3.561782492562993*^9, 
   3.5617825257130513`*^9, 3.561784234167652*^9, 3.5627666270141516`*^9, 
   3.5627667438427563`*^9, 3.5627670822697515`*^9, 3.562767893144575*^9, 
   3.562769545796878*^9, 3.5627696677110925`*^9, {3.5627711276260567`*^9, 
   3.562771147063691*^9}, 3.562773114181346*^9, 3.5627732020563*^9, 
   3.5628212717716117`*^9, 3.562822345818898*^9, 3.562823597723097*^9, 
   3.5628236609812083`*^9, 3.5628240618239126`*^9, 3.562824598637455*^9, 
   3.5628252433865876`*^9, 3.562825311761508*^9, 3.562825371806013*^9, 
   3.562825959194845*^9, 3.5628261338527517`*^9, 3.562826247904552*^9, 
   3.5628280657185726`*^9, 3.5628285638898478`*^9, 3.562828736504151*^9, 
   3.5628288786984005`*^9, 3.56283048949683*^9, 3.5628313051442623`*^9, 
   3.5628316998415556`*^9, 3.5628318197277665`*^9, 3.5628318516454225`*^9, 
   3.5628323081802244`*^9, 3.5628324215456233`*^9, 3.5628327291781635`*^9, 
   3.562833669814016*^9, 3.5628337642409816`*^9, 3.5628338348467054`*^9, 
   3.563425632980192*^9, 3.5634263671330814`*^9, 3.563427213529168*^9, 
   3.5634286993859777`*^9, 3.56342879144174*^9, 3.563428870143878*^9, 
   3.563429666479477*^9, 3.5641236126968374`*^9, 3.5641243458523254`*^9, 
   3.5641248624014325`*^9, 3.5641250176227055`*^9, 3.5641304420898333`*^9, 
   3.5646350262366266`*^9, 3.5646354978254547`*^9, 3.56467212978749*^9, 
   3.565759287764366*^9, 3.5657736669648347`*^9, 3.5658920235955*^9, 
   3.5661948526742287`*^9, 3.566203971352671*^9, 3.5662119037940655`*^9, 
   3.5662126406527605`*^9, 3.566214734004837*^9, 3.5663991503037367`*^9, 
   3.56654371253712*^9, 3.567082814807329*^9, 3.5671851370203805`*^9, 
   3.5675865229115*^9, 3.567600479600524*^9, 3.5678594381939497`*^9, 
   3.567860570772539*^9, 3.5678613068452325`*^9, 3.5678615199572067`*^9, 
   3.567861619048581*^9, 3.567861715815551*^9, 3.5678618101177163`*^9, 
   3.5678620356317124`*^9, 3.5678622047516093`*^9, 3.567862536440392*^9, 
   3.5678626834706507`*^9, 3.5678627712988043`*^9, 3.5678633202949686`*^9, 
   3.5678634149403353`*^9, 3.567863936574051*^9, 3.567864088753319*^9, 
   3.5678642537860084`*^9, 3.5678647669801097`*^9, 3.567865015816147*^9, 
   3.567865314837472*^9, 3.5678655286212473`*^9, 3.56787745385496*^9, 
   3.5679119479404917`*^9, 3.5679130624376493`*^9, 3.5679169100195856`*^9, 
   3.5679176765113316`*^9, 3.567918361150734*^9, 3.5679186147915792`*^9, 
   3.567919444681837*^9, 3.5679197567447853`*^9, 3.5679242578890915`*^9, 
   3.5679261750866594`*^9, 3.5679264768847895`*^9, 3.5679268614566646`*^9, 
   3.567929473936054*^9, 3.567929590686659*^9, 3.5679296721344023`*^9, 
   3.567929856308326*^9, 3.5679300833677244`*^9, 3.567930174908685*^9, 
   3.5679303366497693`*^9, 3.567930622504671*^9, 3.567931058541037*^9, 
   3.5679312105477037`*^9, 3.567931331603917*^9, 3.5679314669965544`*^9, 
   3.5679315200376477`*^9, 3.5679316258214335`*^9, 3.5679319502864037`*^9, 
   3.5679326316332*^9, 3.56793275120741*^9, 3.567933125749468*^9, 
   3.5679332329996567`*^9, 3.567933464176462*^9, 3.5679347101828513`*^9, 
   3.5679359720232677`*^9, 3.568115004553556*^9, 3.568115908404544*^9, 
   3.5681222531580877`*^9, 3.5681223552758675`*^9, 3.568123412287924*^9, 
   3.568895116739812*^9, 3.5688954833872557`*^9, {3.5703549462170115`*^9, 
   3.5703549591338344`*^9}, 3.570357327359394*^9, 3.5703574465758033`*^9, 
   3.570357533202756*^9, 3.5703576111092925`*^9, 3.5703577470021315`*^9, 
   3.5703578048626328`*^9, 3.5703578501495123`*^9, 3.5703579051552086`*^9, 
   3.57035793992767*^9, 3.570358003887782*^9, 3.5703582327713842`*^9, 
   3.570358628356879*^9, 3.5703592170717134`*^9, 3.5703593076610727`*^9, 
   3.5703598584356394`*^9, 3.570360128456514*^9, 3.5703609977222404`*^9, 
   3.57036107700158*^9, 3.570361215935424*^9, 3.570361488155902*^9, 
   3.5703615690576444`*^9, 3.570361669709021*^9, 3.570361878780588*^9, 
   3.570362844813285*^9, 3.5703630119363785`*^9, 3.570363150433422*^9, 
   3.5703632389011774`*^9, 3.5703632998816843`*^9, 3.570363362188194*^9, 
   3.570363557297736*^9, 3.5703640865130663`*^9, 3.570364165698805*^9, 
   3.5703643668777585`*^9, 3.570364472957945*^9, 3.570364558570895*^9, 
   3.5703647243367863`*^9, 3.5703648628806295`*^9, 3.570364933938754*^9, 
   3.5703650449485493`*^9, {3.5703653939991627`*^9, 3.57036540396758*^9}, 
   3.570365463497285*^9, 3.570365727527748*^9, 3.5703657916282606`*^9, {
   3.5703658554635735`*^9, 3.5703658744644065`*^9}, 3.570365937550917*^9, 
   3.570365989124608*^9, 3.570366096843797*^9, 3.570366176591137*^9, 
   3.570366233250437*^9, 3.5703662975537496`*^9, 3.5703663396114235`*^9, 
   3.5703664064731407`*^9, 3.570366437813596*^9, 3.5703665736430345`*^9, 
   3.5703669462652893`*^9, 3.5703672460666156`*^9, 3.570367400974888*^9, 
   3.570367495667054*^9, 3.57036776096212*^9, 3.5703678086202035`*^9, 
   3.570367865154703*^9, 3.57036855806112*^9, 3.570368639914464*^9, 
   3.5703687835439157`*^9, 3.570368870607669*^9, 3.570368931073375*^9, 
   3.570426911265374*^9, 3.570427528152858*^9, 3.57042759776118*^9, 
   3.570427667618103*^9, 3.5704277544946556`*^9, 3.570431941169609*^9, 
   3.570432183640835*^9, 3.5704330981310415`*^9, 3.570436514606758*^9, 
   3.5704380390726357`*^9, 3.5704381714242687`*^9, 3.5704382601260242`*^9, 
   3.570438351822985*^9, 3.5704385726881733`*^9, 3.570438756596896*^9, 
   3.5704388126165943`*^9, 3.5769885490650544`*^9, 3.576989664858014*^9, 
   3.5769897136705*^9, 3.576989756508175*^9, 3.5769897970370464`*^9, 
   3.576990134528039*^9, 3.576990315035956*^9, 3.576990361633238*^9, 
   3.57699052775793*^9, 3.5769913891724434`*^9, 3.576991612830036*^9, 
   3.5769924513637085`*^9, 3.5769928131439443`*^9, 3.576993354808096*^9, 
   3.576993431872231*^9, 3.576993736181966*^9, 3.5769941744813356`*^9, 
   3.576995106551772*^9, 3.576995250337225*^9, 3.5844271627536263`*^9, 
   3.58442729568146*^9, 3.584427397518439*^9, 3.584427667289713*^9, 
   3.584427731717826*^9, 3.584428022269336*^9, 3.58442806420221*^9, 
   3.584428468180519*^9, 3.584428589236732*^9, 3.584428768638047*^9, 
   3.58442924292568*^9, 3.5844293237806225`*^9, 3.5844293647306943`*^9, 
   3.5844294268968034`*^9, 3.584429592881095*^9, 3.5844299883115897`*^9, 
   3.5844315096896615`*^9, 3.5844319827146926`*^9, 3.617688621069113*^9, 
   3.617688667369178*^9, 3.617688744289285*^9, 3.6176888140493827`*^9, 
   3.617688852649437*^9, 3.6176888988835497`*^9, 3.617689373889263*^9, 
   3.617689415809322*^9, 3.617689529333529*^9, 3.617689609503641*^9, 
   3.6176897742838717`*^9, 3.6628758923297367`*^9, 3.6630604725781*^9, 
   3.6630605191208925`*^9, 3.6630606296665936`*^9, 3.6630607035240355`*^9, 
   3.6900207337445707`*^9, 3.690020877254571*^9, 3.6900211069945707`*^9, 
   3.690026103162571*^9, 3.690026177782571*^9, 3.9103403774558897`*^9, 
   3.910344373322824*^9, 3.959701253719307*^9, 3.9597013401006947`*^9, 
   3.9597014892255383`*^9},
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"14bf5eb0-88f2-1c4c-aef8-93119c7d1edc"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We specify the context xAct`Spinors` to avoid overriding the Disclaimer of \
the other packages. However we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"6963ddda-72a4-477d-97c1-74a931423182"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`SymManipulator`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", 
   "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.515744758879812*^9, 3.5157447618609824`*^9}, 
   3.5159383434841175`*^9},
 CellLabel->"In[36]:=",ExpressionUUID->"ed509164-2321-4173-a14e-dfd9b09e6584"],

Cell["\<\
If SpaceSpinors is not being called from other package then write this GPL \
short disclaimer:\
\>", "Text",
 CellChangeTimes->{{3.519296661172683*^9, 3.51929666543149*^9}, {
   3.5703535775476074`*^9, 3.5703535804024124`*^9}, 
   3.690025831170571*^9},ExpressionUUID->"80c5263f-d5e1-4b23-a1a7-\
264eab01c1ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
   "xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`SpaceSpinors`\>\""}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Print", "[", 
     "\"\<These packages come with ABSOLUTELY NO WARRANTY; for details type \
Disclaimer[]. This is free software, and you are welcome to redistribute it \
under certain conditions. See the General Public License for details.\>\"", 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4232372878945827`*^9, 3.423237289581603*^9}, {
   3.423283390363858*^9, 3.4232834081506033`*^9}, {3.519296677771112*^9, 
   3.5192966829815207`*^9}, 3.570353587422425*^9, 3.690025831190571*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"03b801ad-6fd8-4f34-95b7-dc49a97917fe"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.5201748495404644`*^9, 3.5201755961289663`*^9, 3.520175968622016*^9, 
   3.520176096289839*^9, 3.5201762704993424`*^9, 3.5201767560879908`*^9, 
   3.5201779236828303`*^9, 3.5201779734589148`*^9, 3.5201780339722204`*^9, 
   3.520178123251774*^9, 3.520178324058921*^9, 3.52017901036572*^9, 
   3.520179110875495*^9, 3.520179193654038*^9, 3.520179238322116*^9, 
   3.520179284863394*^9, 3.520179463908104*^9, 3.520179551695855*^9, 
   3.520181360208601*^9, 3.5201816366466846`*^9, 3.520268562601894*^9, 
   3.5202687309789333`*^9, 3.5202688626119223`*^9, 3.5202688997115755`*^9, 
   3.520269092038248*^9, 3.520271814240901*^9, 3.520310605227149*^9, 
   3.520310986656105*^9, 3.520311787220435*^9, 3.5203121049347124`*^9, {
   3.5271449362230697`*^9, 3.5271449374710712`*^9}, 3.5271458084226017`*^9, 
   3.5271460019731417`*^9, 3.527147022996935*^9, 3.527147593974538*^9, 
   3.5271480469067335`*^9, 3.5271482641995153`*^9, 3.5271486865170603`*^9, 
   3.5271500508184566`*^9, 3.527150173029071*^9, 3.5271503536305885`*^9, 
   3.5271505075716586`*^9, 3.527150792006958*^9, 3.527150865373887*^9, 
   3.5292308239241247`*^9, 3.5292324671062107`*^9, 3.529232571782395*^9, 
   3.5292359095380573`*^9, 3.529236217544998*^9, 3.5292364172253494`*^9, 
   3.5292366546109657`*^9, 3.529236716121874*^9, 3.5292369672073154`*^9, 
   3.5292370577030745`*^9, 3.5340685699885893`*^9, 3.5340689517524605`*^9, 
   3.5340693827656174`*^9, 3.5340699518858166`*^9, 3.534070176963012*^9, 
   3.534249637234564*^9, 3.537621498718997*^9, 3.537621625219619*^9, 
   3.537622841991556*^9, {3.5376229484929433`*^9, 3.537622964404971*^9}, 
   3.5376231829769554`*^9, 3.5376233615504684`*^9, 3.53762543997532*^9, 
   3.5376287896778746`*^9, 3.5376946998898697`*^9, 3.537694867792965*^9, 
   3.5376955018092785`*^9, 3.537695581603419*^9, 3.5376959132766013`*^9, 
   3.537696395270648*^9, 3.537697105057295*^9, 3.537697460457119*^9, {
   3.5376979706560154`*^9, 3.537697991279251*^9}, 3.5377005707009864`*^9, 
   3.5377009887193203`*^9, 3.5377011498676033`*^9, 3.537705075586299*^9, 
   3.5377676500294886`*^9, 3.5377801860343075`*^9, 3.537780583944206*^9, 
   3.5377809209369984`*^9, 3.537781079948078*^9, 3.537781242047962*^9, 
   3.5377813781738014`*^9, 3.5377815272320633`*^9, 3.537781725617612*^9, 
   3.5377823990717945`*^9, 3.5377827399011936`*^9, 3.5377829310483294`*^9, 
   3.5377831917715874`*^9, 3.5377834405930243`*^9, 3.5377835728968563`*^9, 
   3.537784107915396*^9, 3.5377842447432365`*^9, 3.5440922092835608`*^9, 
   3.5440972403587976`*^9, 3.5440973655022173`*^9, 3.5440979528442492`*^9, 
   3.544099754164813*^9, 3.5441033727647686`*^9, 3.544103463915729*^9, 
   3.544103705077553*^9, 3.5441039175031257`*^9, 3.5441040518817616`*^9, 
   3.5441050996586018`*^9, 3.544105714315282*^9, 3.544105949111294*^9, 
   3.544107147490799*^9, 3.5445912532642508`*^9, 3.544591490440816*^9, 
   3.544591652821104*^9, 3.544592904641704*^9, 3.54467217312121*^9, 
   3.5446723745717325`*^9, 3.544673273733162*^9, {3.544673382226367*^9, 
   3.544673402974554*^9}, 3.5449492188958254`*^9, 3.5449516141610346`*^9, 
   3.545015662743734*^9, 3.5450157245354424`*^9, 3.5451061422578497`*^9, 
   3.54511402062022*^9, 3.552821195484202*^9, 3.5528226595633736`*^9, 
   3.552822795564412*^9, 3.552822986743748*^9, 3.5528231959089155`*^9, 
   3.5528236662653418`*^9, 3.5528239712156773`*^9, 3.552826116688446*^9, 
   3.5528263093185844`*^9, 3.5542072713991117`*^9, 3.554208466893612*^9, 
   3.561371697466419*^9, 3.5617325863744073`*^9, 3.5617791984114065`*^9, 
   3.5617814880138283`*^9, 3.5617815620047584`*^9, 3.561781652952918*^9, 
   3.561781901305354*^9, 3.561781933722211*^9, 3.561782101439106*^9, 
   3.5617821946804695`*^9, 3.5617823881208096`*^9, 3.5617824925941925`*^9, 
   3.5617825257442513`*^9, 3.561784234214452*^9, 3.5627666270609517`*^9, 
   3.562766743889557*^9, 3.562767082316551*^9, 3.5627678931757755`*^9, 
   3.5627695458436785`*^9, 3.5627696677422924`*^9, {3.5627711276572566`*^9, 
   3.562771147110491*^9}, 3.562773114228146*^9, 3.5627732020875*^9, 
   3.562821271834012*^9, 3.5628223458656983`*^9, 3.5628235977542973`*^9, 
   3.5628236610124083`*^9, 3.562824061855112*^9, 3.5628245986686554`*^9, 
   3.5628252434333878`*^9, 3.562825311792708*^9, 3.5628253718372135`*^9, 
   3.562825959226045*^9, 3.562826133883952*^9, 3.562826247951352*^9, 
   3.5628280657497725`*^9, 3.5628285639366474`*^9, 3.562828736535351*^9, 
   3.5628288787296004`*^9, 3.56283048952803*^9, 3.5628313051754627`*^9, 
   3.5628316998727555`*^9, 3.5628318197433662`*^9, 3.5628318516922226`*^9, 
   3.562832308211424*^9, 3.5628324215924234`*^9, 3.5628327292249637`*^9, 
   3.562833669845216*^9, 3.5628337642877817`*^9, 3.562833834893506*^9, 
   3.563425633042592*^9, 3.5634263671798816`*^9, 3.5634272135759687`*^9, 
   3.5634286994327784`*^9, 3.56342879147294*^9, 3.5634288701906776`*^9, 
   3.5634296665262766`*^9, 3.5641236127436376`*^9, 3.564124345899125*^9, 
   3.5641248624482327`*^9, 3.5641250176539054`*^9, 3.564130442136634*^9, 
   3.564635026283427*^9, 3.5646354978722553`*^9, 3.5646721298498907`*^9, 
   3.565759287826766*^9, 3.565773667011635*^9, 3.5658920236579*^9, 
   3.5661948527054286`*^9, 3.566203971383871*^9, 3.5662119038408656`*^9, 
   3.566212640683961*^9, 3.5662147340360374`*^9, 3.566399150350537*^9, 
   3.5665437125839195`*^9, 3.567082814838529*^9, 3.5671851370671806`*^9, 
   3.5675865229583006`*^9, 3.567600479647324*^9, 3.5678594382563505`*^9, 
   3.56786057083494*^9, 3.5678613069544325`*^9, 3.567861519988407*^9, 
   3.5678616190797806`*^9, 3.567861715831151*^9, 3.5678618101489162`*^9, 
   3.567862035647312*^9, 3.5678622047828093`*^9, 3.567862536471592*^9, 
   3.5678626835174503`*^9, 3.5678627713300047`*^9, 3.567863320326169*^9, 
   3.567863414971535*^9, 3.567863936589651*^9, 3.5678640887845187`*^9, 
   3.5678642538172083`*^9, 3.56786476699571*^9, 3.567865015831747*^9, 
   3.567865314868672*^9, 3.5678655286524477`*^9, 3.56787745388616*^9, 
   3.567911947971692*^9, 3.567913062468849*^9, 3.5679169100507855`*^9, 
   3.567917676526932*^9, 3.5679183611819344`*^9, 3.5679186148227797`*^9, 
   3.5679194446974373`*^9, 3.5679197567759857`*^9, 3.5679242579046917`*^9, 
   3.567926175102259*^9, 3.567926476900389*^9, 3.5679268614878645`*^9, 
   3.5679294739672537`*^9, 3.567929590702259*^9, 3.5679296721656017`*^9, 
   3.5679298563395257`*^9, 3.5679300833989244`*^9, 3.567930174939885*^9, 
   3.567930336680969*^9, 3.5679306225202713`*^9, 3.567931058572237*^9, 
   3.567931210578904*^9, 3.5679313316351166`*^9, 3.567931467027755*^9, 
   3.5679315200688477`*^9, 3.5679316258526335`*^9, 3.5679319503176036`*^9, 
   3.5679326316488*^9, 3.5679327512386103`*^9, 3.5679331257806683`*^9, 
   3.5679332330152564`*^9, 3.5679334642076626`*^9, 3.567934710198451*^9, 
   3.5679359720544677`*^9, 3.568115004584756*^9, 3.5681159084357433`*^9, 
   3.568122253173688*^9, 3.568122355322667*^9, 3.5681234123191233`*^9, 
   3.5688951167866125`*^9, 3.568895483418456*^9, {3.5703549462326117`*^9, 
   3.5703549591650343`*^9}, 3.5703573273749943`*^9, 3.570357446607003*^9, 
   3.5703575332183557`*^9, 3.570357611124892*^9, 3.570357747017731*^9, 
   3.5703578048938327`*^9, 3.5703578501651125`*^9, 3.570357905186409*^9, 
   3.5703579399432697`*^9, 3.5703580039189825`*^9, 3.5703582328025846`*^9, 
   3.570358628388079*^9, 3.570359217087313*^9, 3.570359307692272*^9, 
   3.57035985846684*^9, 3.570360128487714*^9, 3.5703609977378407`*^9, 
   3.57036107701718*^9, 3.5703612159666243`*^9, 3.5703614881871023`*^9, 
   3.570361569073244*^9, 3.5703616697246213`*^9, 3.5703618788117886`*^9, 
   3.5703628448444853`*^9, 3.570363011967579*^9, 3.570363150464622*^9, 
   3.570363238916777*^9, 3.5703632999128847`*^9, 3.5703633622037935`*^9, 
   3.5703635573133364`*^9, 3.5703640865442657`*^9, 3.570364165714405*^9, 
   3.570364366893358*^9, 3.570364472973545*^9, 3.5703645585864954`*^9, 
   3.5703647243679867`*^9, 3.5703648628962297`*^9, 3.5703649339543543`*^9, 
   3.5703650449641495`*^9, {3.570365394014763*^9, 3.57036540398318*^9}, 
   3.570365463528485*^9, 3.5703657275433483`*^9, 3.570365791643861*^9, {
   3.570365855494773*^9, 3.5703658744956064`*^9}, 3.570365937566517*^9, 
   3.570365989140208*^9, 3.570366096874997*^9, 3.570366176606737*^9, 
   3.570366233266037*^9, 3.5703662975693493`*^9, 3.570366339642624*^9, 
   3.570366406488741*^9, 3.570366437829196*^9, 3.5703665736586347`*^9, 
   3.570366946280889*^9, 3.5703672460822153`*^9, 3.5703674010060873`*^9, 
   3.570367495682654*^9, 3.5703677609777203`*^9, 3.570367808651404*^9, 
   3.5703678651859035`*^9, 3.57036855809232*^9, 3.5703686399300637`*^9, 
   3.570368783559516*^9, 3.5703688706388693`*^9, 3.570368931088975*^9, 
   3.5704269112965746`*^9, 3.570427528168458*^9, 3.57042759777678*^9, 
   3.5704276676337028`*^9, 3.570427754525855*^9, 3.570431941200809*^9, 
   3.570432183656435*^9, 3.5704330981466413`*^9, 3.5704365146379585`*^9, 
   3.570438039088236*^9, 3.5704381714398685`*^9, 3.5704382601416245`*^9, 
   3.570438351838585*^9, 3.5704385727037735`*^9, 3.570438756628096*^9, 
   3.5704388126321945`*^9, 3.576988549080654*^9, 3.5769896648736143`*^9, 
   3.5769897137017*^9, 3.5769897565393753`*^9, 3.5769897970526466`*^9, 
   3.5769901345592394`*^9, 3.5769903150671563`*^9, 3.576990361648838*^9, 
   3.57699052777353*^9, 3.576991389203643*^9, 3.576991612861236*^9, 
   3.576992451394909*^9, 3.5769928131595445`*^9, 3.5769933548392954`*^9, 
   3.576993431903431*^9, 3.5769937362131653`*^9, 3.576994174512535*^9, 
   3.5769951065985727`*^9, 3.576995250368425*^9, 3.584427162769226*^9, 
   3.58442729569706*^9, 3.5844273975340385`*^9, 3.584427667320913*^9, 
   3.584427731733426*^9, 3.584428022284936*^9, 3.5844280642178097`*^9, 
   3.5844284681961193`*^9, 3.584428589267932*^9, 3.5844287686536474`*^9, 
   3.5844292429568806`*^9, 3.5844293237962227`*^9, 3.584429364746294*^9, 
   3.584429426912403*^9, 3.584429592912295*^9, 3.5844299883271894`*^9, 
   3.584431509720862*^9, 3.5844319827302923`*^9, 3.6176886210891128`*^9, 
   3.6176886673791776`*^9, 3.617688744309285*^9, 3.6176888140693827`*^9, 
   3.6176888526694365`*^9, 3.61768889889355*^9, 3.617689373909263*^9, 
   3.6176894158193216`*^9, 3.6176895293435287`*^9, 3.617689609523641*^9, 
   3.617689774303872*^9, 3.662875892349736*^9, 3.663060472598101*^9, 
   3.663060519150894*^9, 3.6630606297165847`*^9, 3.663060703544032*^9, 
   3.690020733764571*^9, 3.6900208772845707`*^9, 3.6900211070345707`*^9, 
   3.6900261031725707`*^9, 3.690026177792571*^9, 3.9103403774838157`*^9, 
   3.9103443733587294`*^9, 3.959701253755209*^9, 3.959701340138592*^9, 
   3.959701489253462*^9},
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"ba85bdd7-72b3-1c47-ab1f-88c514ff6468"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{
  3.5201748495404644`*^9, 3.5201755961289663`*^9, 3.520175968622016*^9, 
   3.520176096289839*^9, 3.5201762704993424`*^9, 3.5201767560879908`*^9, 
   3.5201779236828303`*^9, 3.5201779734589148`*^9, 3.5201780339722204`*^9, 
   3.520178123251774*^9, 3.520178324058921*^9, 3.52017901036572*^9, 
   3.520179110875495*^9, 3.520179193654038*^9, 3.520179238322116*^9, 
   3.520179284863394*^9, 3.520179463908104*^9, 3.520179551695855*^9, 
   3.520181360208601*^9, 3.5201816366466846`*^9, 3.520268562601894*^9, 
   3.5202687309789333`*^9, 3.5202688626119223`*^9, 3.5202688997115755`*^9, 
   3.520269092038248*^9, 3.520271814240901*^9, 3.520310605227149*^9, 
   3.520310986656105*^9, 3.520311787220435*^9, 3.5203121049347124`*^9, {
   3.5271449362230697`*^9, 3.5271449374710712`*^9}, 3.5271458084226017`*^9, 
   3.5271460019731417`*^9, 3.527147022996935*^9, 3.527147593974538*^9, 
   3.5271480469067335`*^9, 3.5271482641995153`*^9, 3.5271486865170603`*^9, 
   3.5271500508184566`*^9, 3.527150173029071*^9, 3.5271503536305885`*^9, 
   3.5271505075716586`*^9, 3.527150792006958*^9, 3.527150865373887*^9, 
   3.5292308239241247`*^9, 3.5292324671062107`*^9, 3.529232571782395*^9, 
   3.5292359095380573`*^9, 3.529236217544998*^9, 3.5292364172253494`*^9, 
   3.5292366546109657`*^9, 3.529236716121874*^9, 3.5292369672073154`*^9, 
   3.5292370577030745`*^9, 3.5340685699885893`*^9, 3.5340689517524605`*^9, 
   3.5340693827656174`*^9, 3.5340699518858166`*^9, 3.534070176963012*^9, 
   3.534249637234564*^9, 3.537621498718997*^9, 3.537621625219619*^9, 
   3.537622841991556*^9, {3.5376229484929433`*^9, 3.537622964404971*^9}, 
   3.5376231829769554`*^9, 3.5376233615504684`*^9, 3.53762543997532*^9, 
   3.5376287896778746`*^9, 3.5376946998898697`*^9, 3.537694867792965*^9, 
   3.5376955018092785`*^9, 3.537695581603419*^9, 3.5376959132766013`*^9, 
   3.537696395270648*^9, 3.537697105057295*^9, 3.537697460457119*^9, {
   3.5376979706560154`*^9, 3.537697991279251*^9}, 3.5377005707009864`*^9, 
   3.5377009887193203`*^9, 3.5377011498676033`*^9, 3.537705075586299*^9, 
   3.5377676500294886`*^9, 3.5377801860343075`*^9, 3.537780583944206*^9, 
   3.5377809209369984`*^9, 3.537781079948078*^9, 3.537781242047962*^9, 
   3.5377813781738014`*^9, 3.5377815272320633`*^9, 3.537781725617612*^9, 
   3.5377823990717945`*^9, 3.5377827399011936`*^9, 3.5377829310483294`*^9, 
   3.5377831917715874`*^9, 3.5377834405930243`*^9, 3.5377835728968563`*^9, 
   3.537784107915396*^9, 3.5377842447432365`*^9, 3.5440922092835608`*^9, 
   3.5440972403587976`*^9, 3.5440973655022173`*^9, 3.5440979528442492`*^9, 
   3.544099754164813*^9, 3.5441033727647686`*^9, 3.544103463915729*^9, 
   3.544103705077553*^9, 3.5441039175031257`*^9, 3.5441040518817616`*^9, 
   3.5441050996586018`*^9, 3.544105714315282*^9, 3.544105949111294*^9, 
   3.544107147490799*^9, 3.5445912532642508`*^9, 3.544591490440816*^9, 
   3.544591652821104*^9, 3.544592904641704*^9, 3.54467217312121*^9, 
   3.5446723745717325`*^9, 3.544673273733162*^9, {3.544673382226367*^9, 
   3.544673402974554*^9}, 3.5449492188958254`*^9, 3.5449516141610346`*^9, 
   3.545015662743734*^9, 3.5450157245354424`*^9, 3.5451061422578497`*^9, 
   3.54511402062022*^9, 3.552821195484202*^9, 3.5528226595633736`*^9, 
   3.552822795564412*^9, 3.552822986743748*^9, 3.5528231959089155`*^9, 
   3.5528236662653418`*^9, 3.5528239712156773`*^9, 3.552826116688446*^9, 
   3.5528263093185844`*^9, 3.5542072713991117`*^9, 3.554208466893612*^9, 
   3.561371697466419*^9, 3.5617325863744073`*^9, 3.5617791984114065`*^9, 
   3.5617814880138283`*^9, 3.5617815620047584`*^9, 3.561781652952918*^9, 
   3.561781901305354*^9, 3.561781933722211*^9, 3.561782101439106*^9, 
   3.5617821946804695`*^9, 3.5617823881208096`*^9, 3.5617824925941925`*^9, 
   3.5617825257442513`*^9, 3.561784234214452*^9, 3.5627666270609517`*^9, 
   3.562766743889557*^9, 3.562767082316551*^9, 3.5627678931757755`*^9, 
   3.5627695458436785`*^9, 3.5627696677422924`*^9, {3.5627711276572566`*^9, 
   3.562771147110491*^9}, 3.562773114228146*^9, 3.5627732020875*^9, 
   3.562821271834012*^9, 3.5628223458656983`*^9, 3.5628235977542973`*^9, 
   3.5628236610124083`*^9, 3.562824061855112*^9, 3.5628245986686554`*^9, 
   3.5628252434333878`*^9, 3.562825311792708*^9, 3.5628253718372135`*^9, 
   3.562825959226045*^9, 3.562826133883952*^9, 3.562826247951352*^9, 
   3.5628280657497725`*^9, 3.5628285639366474`*^9, 3.562828736535351*^9, 
   3.5628288787296004`*^9, 3.56283048952803*^9, 3.5628313051754627`*^9, 
   3.5628316998727555`*^9, 3.5628318197433662`*^9, 3.5628318516922226`*^9, 
   3.562832308211424*^9, 3.5628324215924234`*^9, 3.5628327292249637`*^9, 
   3.562833669845216*^9, 3.5628337642877817`*^9, 3.562833834893506*^9, 
   3.563425633042592*^9, 3.5634263671798816`*^9, 3.5634272135759687`*^9, 
   3.5634286994327784`*^9, 3.56342879147294*^9, 3.5634288701906776`*^9, 
   3.5634296665262766`*^9, 3.5641236127436376`*^9, 3.564124345899125*^9, 
   3.5641248624482327`*^9, 3.5641250176539054`*^9, 3.564130442136634*^9, 
   3.564635026283427*^9, 3.5646354978722553`*^9, 3.5646721298498907`*^9, 
   3.565759287826766*^9, 3.565773667011635*^9, 3.5658920236579*^9, 
   3.5661948527054286`*^9, 3.566203971383871*^9, 3.5662119038408656`*^9, 
   3.566212640683961*^9, 3.5662147340360374`*^9, 3.566399150350537*^9, 
   3.5665437125839195`*^9, 3.567082814838529*^9, 3.5671851370671806`*^9, 
   3.5675865229583006`*^9, 3.567600479647324*^9, 3.5678594382563505`*^9, 
   3.56786057083494*^9, 3.5678613069544325`*^9, 3.567861519988407*^9, 
   3.5678616190797806`*^9, 3.567861715831151*^9, 3.5678618101489162`*^9, 
   3.567862035647312*^9, 3.5678622047828093`*^9, 3.567862536471592*^9, 
   3.5678626835174503`*^9, 3.5678627713300047`*^9, 3.567863320326169*^9, 
   3.567863414971535*^9, 3.567863936589651*^9, 3.5678640887845187`*^9, 
   3.5678642538172083`*^9, 3.56786476699571*^9, 3.567865015831747*^9, 
   3.567865314868672*^9, 3.5678655286524477`*^9, 3.56787745388616*^9, 
   3.567911947971692*^9, 3.567913062468849*^9, 3.5679169100507855`*^9, 
   3.567917676526932*^9, 3.5679183611819344`*^9, 3.5679186148227797`*^9, 
   3.5679194446974373`*^9, 3.5679197567759857`*^9, 3.5679242579046917`*^9, 
   3.567926175102259*^9, 3.567926476900389*^9, 3.5679268614878645`*^9, 
   3.5679294739672537`*^9, 3.567929590702259*^9, 3.5679296721656017`*^9, 
   3.5679298563395257`*^9, 3.5679300833989244`*^9, 3.567930174939885*^9, 
   3.567930336680969*^9, 3.5679306225202713`*^9, 3.567931058572237*^9, 
   3.567931210578904*^9, 3.5679313316351166`*^9, 3.567931467027755*^9, 
   3.5679315200688477`*^9, 3.5679316258526335`*^9, 3.5679319503176036`*^9, 
   3.5679326316488*^9, 3.5679327512386103`*^9, 3.5679331257806683`*^9, 
   3.5679332330152564`*^9, 3.5679334642076626`*^9, 3.567934710198451*^9, 
   3.5679359720544677`*^9, 3.568115004584756*^9, 3.5681159084357433`*^9, 
   3.568122253173688*^9, 3.568122355322667*^9, 3.5681234123191233`*^9, 
   3.5688951167866125`*^9, 3.568895483418456*^9, {3.5703549462326117`*^9, 
   3.5703549591650343`*^9}, 3.5703573273749943`*^9, 3.570357446607003*^9, 
   3.5703575332183557`*^9, 3.570357611124892*^9, 3.570357747017731*^9, 
   3.5703578048938327`*^9, 3.5703578501651125`*^9, 3.570357905186409*^9, 
   3.5703579399432697`*^9, 3.5703580039189825`*^9, 3.5703582328025846`*^9, 
   3.570358628388079*^9, 3.570359217087313*^9, 3.570359307692272*^9, 
   3.57035985846684*^9, 3.570360128487714*^9, 3.5703609977378407`*^9, 
   3.57036107701718*^9, 3.5703612159666243`*^9, 3.5703614881871023`*^9, 
   3.570361569073244*^9, 3.5703616697246213`*^9, 3.5703618788117886`*^9, 
   3.5703628448444853`*^9, 3.570363011967579*^9, 3.570363150464622*^9, 
   3.570363238916777*^9, 3.5703632999128847`*^9, 3.5703633622037935`*^9, 
   3.5703635573133364`*^9, 3.5703640865442657`*^9, 3.570364165714405*^9, 
   3.570364366893358*^9, 3.570364472973545*^9, 3.5703645585864954`*^9, 
   3.5703647243679867`*^9, 3.5703648628962297`*^9, 3.5703649339543543`*^9, 
   3.5703650449641495`*^9, {3.570365394014763*^9, 3.57036540398318*^9}, 
   3.570365463528485*^9, 3.5703657275433483`*^9, 3.570365791643861*^9, {
   3.570365855494773*^9, 3.5703658744956064`*^9}, 3.570365937566517*^9, 
   3.570365989140208*^9, 3.570366096874997*^9, 3.570366176606737*^9, 
   3.570366233266037*^9, 3.5703662975693493`*^9, 3.570366339642624*^9, 
   3.570366406488741*^9, 3.570366437829196*^9, 3.5703665736586347`*^9, 
   3.570366946280889*^9, 3.5703672460822153`*^9, 3.5703674010060873`*^9, 
   3.570367495682654*^9, 3.5703677609777203`*^9, 3.570367808651404*^9, 
   3.5703678651859035`*^9, 3.57036855809232*^9, 3.5703686399300637`*^9, 
   3.570368783559516*^9, 3.5703688706388693`*^9, 3.570368931088975*^9, 
   3.5704269112965746`*^9, 3.570427528168458*^9, 3.57042759777678*^9, 
   3.5704276676337028`*^9, 3.570427754525855*^9, 3.570431941200809*^9, 
   3.570432183656435*^9, 3.5704330981466413`*^9, 3.5704365146379585`*^9, 
   3.570438039088236*^9, 3.5704381714398685`*^9, 3.5704382601416245`*^9, 
   3.570438351838585*^9, 3.5704385727037735`*^9, 3.570438756628096*^9, 
   3.5704388126321945`*^9, 3.576988549080654*^9, 3.5769896648736143`*^9, 
   3.5769897137017*^9, 3.5769897565393753`*^9, 3.5769897970526466`*^9, 
   3.5769901345592394`*^9, 3.5769903150671563`*^9, 3.576990361648838*^9, 
   3.57699052777353*^9, 3.576991389203643*^9, 3.576991612861236*^9, 
   3.576992451394909*^9, 3.5769928131595445`*^9, 3.5769933548392954`*^9, 
   3.576993431903431*^9, 3.5769937362131653`*^9, 3.576994174512535*^9, 
   3.5769951065985727`*^9, 3.576995250368425*^9, 3.584427162769226*^9, 
   3.58442729569706*^9, 3.5844273975340385`*^9, 3.584427667320913*^9, 
   3.584427731733426*^9, 3.584428022284936*^9, 3.5844280642178097`*^9, 
   3.5844284681961193`*^9, 3.584428589267932*^9, 3.5844287686536474`*^9, 
   3.5844292429568806`*^9, 3.5844293237962227`*^9, 3.584429364746294*^9, 
   3.584429426912403*^9, 3.584429592912295*^9, 3.5844299883271894`*^9, 
   3.584431509720862*^9, 3.5844319827302923`*^9, 3.6176886210891128`*^9, 
   3.6176886673791776`*^9, 3.617688744309285*^9, 3.6176888140693827`*^9, 
   3.6176888526694365`*^9, 3.61768889889355*^9, 3.617689373909263*^9, 
   3.6176894158193216`*^9, 3.6176895293435287`*^9, 3.617689609523641*^9, 
   3.617689774303872*^9, 3.662875892349736*^9, 3.663060472598101*^9, 
   3.663060519150894*^9, 3.6630606297165847`*^9, 3.663060703544032*^9, 
   3.690020733764571*^9, 3.6900208772845707`*^9, 3.6900211070345707`*^9, 
   3.6900261031725707`*^9, 3.690026177792571*^9, 3.9103403774838157`*^9, 
   3.9103443733587294`*^9, 3.959701253755209*^9, 3.959701340138592*^9, 
   3.9597014892544594`*^9},
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"9ee4ca23-3b2e-9443-80f8-59251e5e41c2"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{
  3.5201748495404644`*^9, 3.5201755961289663`*^9, 3.520175968622016*^9, 
   3.520176096289839*^9, 3.5201762704993424`*^9, 3.5201767560879908`*^9, 
   3.5201779236828303`*^9, 3.5201779734589148`*^9, 3.5201780339722204`*^9, 
   3.520178123251774*^9, 3.520178324058921*^9, 3.52017901036572*^9, 
   3.520179110875495*^9, 3.520179193654038*^9, 3.520179238322116*^9, 
   3.520179284863394*^9, 3.520179463908104*^9, 3.520179551695855*^9, 
   3.520181360208601*^9, 3.5201816366466846`*^9, 3.520268562601894*^9, 
   3.5202687309789333`*^9, 3.5202688626119223`*^9, 3.5202688997115755`*^9, 
   3.520269092038248*^9, 3.520271814240901*^9, 3.520310605227149*^9, 
   3.520310986656105*^9, 3.520311787220435*^9, 3.5203121049347124`*^9, {
   3.5271449362230697`*^9, 3.5271449374710712`*^9}, 3.5271458084226017`*^9, 
   3.5271460019731417`*^9, 3.527147022996935*^9, 3.527147593974538*^9, 
   3.5271480469067335`*^9, 3.5271482641995153`*^9, 3.5271486865170603`*^9, 
   3.5271500508184566`*^9, 3.527150173029071*^9, 3.5271503536305885`*^9, 
   3.5271505075716586`*^9, 3.527150792006958*^9, 3.527150865373887*^9, 
   3.5292308239241247`*^9, 3.5292324671062107`*^9, 3.529232571782395*^9, 
   3.5292359095380573`*^9, 3.529236217544998*^9, 3.5292364172253494`*^9, 
   3.5292366546109657`*^9, 3.529236716121874*^9, 3.5292369672073154`*^9, 
   3.5292370577030745`*^9, 3.5340685699885893`*^9, 3.5340689517524605`*^9, 
   3.5340693827656174`*^9, 3.5340699518858166`*^9, 3.534070176963012*^9, 
   3.534249637234564*^9, 3.537621498718997*^9, 3.537621625219619*^9, 
   3.537622841991556*^9, {3.5376229484929433`*^9, 3.537622964404971*^9}, 
   3.5376231829769554`*^9, 3.5376233615504684`*^9, 3.53762543997532*^9, 
   3.5376287896778746`*^9, 3.5376946998898697`*^9, 3.537694867792965*^9, 
   3.5376955018092785`*^9, 3.537695581603419*^9, 3.5376959132766013`*^9, 
   3.537696395270648*^9, 3.537697105057295*^9, 3.537697460457119*^9, {
   3.5376979706560154`*^9, 3.537697991279251*^9}, 3.5377005707009864`*^9, 
   3.5377009887193203`*^9, 3.5377011498676033`*^9, 3.537705075586299*^9, 
   3.5377676500294886`*^9, 3.5377801860343075`*^9, 3.537780583944206*^9, 
   3.5377809209369984`*^9, 3.537781079948078*^9, 3.537781242047962*^9, 
   3.5377813781738014`*^9, 3.5377815272320633`*^9, 3.537781725617612*^9, 
   3.5377823990717945`*^9, 3.5377827399011936`*^9, 3.5377829310483294`*^9, 
   3.5377831917715874`*^9, 3.5377834405930243`*^9, 3.5377835728968563`*^9, 
   3.537784107915396*^9, 3.5377842447432365`*^9, 3.5440922092835608`*^9, 
   3.5440972403587976`*^9, 3.5440973655022173`*^9, 3.5440979528442492`*^9, 
   3.544099754164813*^9, 3.5441033727647686`*^9, 3.544103463915729*^9, 
   3.544103705077553*^9, 3.5441039175031257`*^9, 3.5441040518817616`*^9, 
   3.5441050996586018`*^9, 3.544105714315282*^9, 3.544105949111294*^9, 
   3.544107147490799*^9, 3.5445912532642508`*^9, 3.544591490440816*^9, 
   3.544591652821104*^9, 3.544592904641704*^9, 3.54467217312121*^9, 
   3.5446723745717325`*^9, 3.544673273733162*^9, {3.544673382226367*^9, 
   3.544673402974554*^9}, 3.5449492188958254`*^9, 3.5449516141610346`*^9, 
   3.545015662743734*^9, 3.5450157245354424`*^9, 3.5451061422578497`*^9, 
   3.54511402062022*^9, 3.552821195484202*^9, 3.5528226595633736`*^9, 
   3.552822795564412*^9, 3.552822986743748*^9, 3.5528231959089155`*^9, 
   3.5528236662653418`*^9, 3.5528239712156773`*^9, 3.552826116688446*^9, 
   3.5528263093185844`*^9, 3.5542072713991117`*^9, 3.554208466893612*^9, 
   3.561371697466419*^9, 3.5617325863744073`*^9, 3.5617791984114065`*^9, 
   3.5617814880138283`*^9, 3.5617815620047584`*^9, 3.561781652952918*^9, 
   3.561781901305354*^9, 3.561781933722211*^9, 3.561782101439106*^9, 
   3.5617821946804695`*^9, 3.5617823881208096`*^9, 3.5617824925941925`*^9, 
   3.5617825257442513`*^9, 3.561784234214452*^9, 3.5627666270609517`*^9, 
   3.562766743889557*^9, 3.562767082316551*^9, 3.5627678931757755`*^9, 
   3.5627695458436785`*^9, 3.5627696677422924`*^9, {3.5627711276572566`*^9, 
   3.562771147110491*^9}, 3.562773114228146*^9, 3.5627732020875*^9, 
   3.562821271834012*^9, 3.5628223458656983`*^9, 3.5628235977542973`*^9, 
   3.5628236610124083`*^9, 3.562824061855112*^9, 3.5628245986686554`*^9, 
   3.5628252434333878`*^9, 3.562825311792708*^9, 3.5628253718372135`*^9, 
   3.562825959226045*^9, 3.562826133883952*^9, 3.562826247951352*^9, 
   3.5628280657497725`*^9, 3.5628285639366474`*^9, 3.562828736535351*^9, 
   3.5628288787296004`*^9, 3.56283048952803*^9, 3.5628313051754627`*^9, 
   3.5628316998727555`*^9, 3.5628318197433662`*^9, 3.5628318516922226`*^9, 
   3.562832308211424*^9, 3.5628324215924234`*^9, 3.5628327292249637`*^9, 
   3.562833669845216*^9, 3.5628337642877817`*^9, 3.562833834893506*^9, 
   3.563425633042592*^9, 3.5634263671798816`*^9, 3.5634272135759687`*^9, 
   3.5634286994327784`*^9, 3.56342879147294*^9, 3.5634288701906776`*^9, 
   3.5634296665262766`*^9, 3.5641236127436376`*^9, 3.564124345899125*^9, 
   3.5641248624482327`*^9, 3.5641250176539054`*^9, 3.564130442136634*^9, 
   3.564635026283427*^9, 3.5646354978722553`*^9, 3.5646721298498907`*^9, 
   3.565759287826766*^9, 3.565773667011635*^9, 3.5658920236579*^9, 
   3.5661948527054286`*^9, 3.566203971383871*^9, 3.5662119038408656`*^9, 
   3.566212640683961*^9, 3.5662147340360374`*^9, 3.566399150350537*^9, 
   3.5665437125839195`*^9, 3.567082814838529*^9, 3.5671851370671806`*^9, 
   3.5675865229583006`*^9, 3.567600479647324*^9, 3.5678594382563505`*^9, 
   3.56786057083494*^9, 3.5678613069544325`*^9, 3.567861519988407*^9, 
   3.5678616190797806`*^9, 3.567861715831151*^9, 3.5678618101489162`*^9, 
   3.567862035647312*^9, 3.5678622047828093`*^9, 3.567862536471592*^9, 
   3.5678626835174503`*^9, 3.5678627713300047`*^9, 3.567863320326169*^9, 
   3.567863414971535*^9, 3.567863936589651*^9, 3.5678640887845187`*^9, 
   3.5678642538172083`*^9, 3.56786476699571*^9, 3.567865015831747*^9, 
   3.567865314868672*^9, 3.5678655286524477`*^9, 3.56787745388616*^9, 
   3.567911947971692*^9, 3.567913062468849*^9, 3.5679169100507855`*^9, 
   3.567917676526932*^9, 3.5679183611819344`*^9, 3.5679186148227797`*^9, 
   3.5679194446974373`*^9, 3.5679197567759857`*^9, 3.5679242579046917`*^9, 
   3.567926175102259*^9, 3.567926476900389*^9, 3.5679268614878645`*^9, 
   3.5679294739672537`*^9, 3.567929590702259*^9, 3.5679296721656017`*^9, 
   3.5679298563395257`*^9, 3.5679300833989244`*^9, 3.567930174939885*^9, 
   3.567930336680969*^9, 3.5679306225202713`*^9, 3.567931058572237*^9, 
   3.567931210578904*^9, 3.5679313316351166`*^9, 3.567931467027755*^9, 
   3.5679315200688477`*^9, 3.5679316258526335`*^9, 3.5679319503176036`*^9, 
   3.5679326316488*^9, 3.5679327512386103`*^9, 3.5679331257806683`*^9, 
   3.5679332330152564`*^9, 3.5679334642076626`*^9, 3.567934710198451*^9, 
   3.5679359720544677`*^9, 3.568115004584756*^9, 3.5681159084357433`*^9, 
   3.568122253173688*^9, 3.568122355322667*^9, 3.5681234123191233`*^9, 
   3.5688951167866125`*^9, 3.568895483418456*^9, {3.5703549462326117`*^9, 
   3.5703549591650343`*^9}, 3.5703573273749943`*^9, 3.570357446607003*^9, 
   3.5703575332183557`*^9, 3.570357611124892*^9, 3.570357747017731*^9, 
   3.5703578048938327`*^9, 3.5703578501651125`*^9, 3.570357905186409*^9, 
   3.5703579399432697`*^9, 3.5703580039189825`*^9, 3.5703582328025846`*^9, 
   3.570358628388079*^9, 3.570359217087313*^9, 3.570359307692272*^9, 
   3.57035985846684*^9, 3.570360128487714*^9, 3.5703609977378407`*^9, 
   3.57036107701718*^9, 3.5703612159666243`*^9, 3.5703614881871023`*^9, 
   3.570361569073244*^9, 3.5703616697246213`*^9, 3.5703618788117886`*^9, 
   3.5703628448444853`*^9, 3.570363011967579*^9, 3.570363150464622*^9, 
   3.570363238916777*^9, 3.5703632999128847`*^9, 3.5703633622037935`*^9, 
   3.5703635573133364`*^9, 3.5703640865442657`*^9, 3.570364165714405*^9, 
   3.570364366893358*^9, 3.570364472973545*^9, 3.5703645585864954`*^9, 
   3.5703647243679867`*^9, 3.5703648628962297`*^9, 3.5703649339543543`*^9, 
   3.5703650449641495`*^9, {3.570365394014763*^9, 3.57036540398318*^9}, 
   3.570365463528485*^9, 3.5703657275433483`*^9, 3.570365791643861*^9, {
   3.570365855494773*^9, 3.5703658744956064`*^9}, 3.570365937566517*^9, 
   3.570365989140208*^9, 3.570366096874997*^9, 3.570366176606737*^9, 
   3.570366233266037*^9, 3.5703662975693493`*^9, 3.570366339642624*^9, 
   3.570366406488741*^9, 3.570366437829196*^9, 3.5703665736586347`*^9, 
   3.570366946280889*^9, 3.5703672460822153`*^9, 3.5703674010060873`*^9, 
   3.570367495682654*^9, 3.5703677609777203`*^9, 3.570367808651404*^9, 
   3.5703678651859035`*^9, 3.57036855809232*^9, 3.5703686399300637`*^9, 
   3.570368783559516*^9, 3.5703688706388693`*^9, 3.570368931088975*^9, 
   3.5704269112965746`*^9, 3.570427528168458*^9, 3.57042759777678*^9, 
   3.5704276676337028`*^9, 3.570427754525855*^9, 3.570431941200809*^9, 
   3.570432183656435*^9, 3.5704330981466413`*^9, 3.5704365146379585`*^9, 
   3.570438039088236*^9, 3.5704381714398685`*^9, 3.5704382601416245`*^9, 
   3.570438351838585*^9, 3.5704385727037735`*^9, 3.570438756628096*^9, 
   3.5704388126321945`*^9, 3.576988549080654*^9, 3.5769896648736143`*^9, 
   3.5769897137017*^9, 3.5769897565393753`*^9, 3.5769897970526466`*^9, 
   3.5769901345592394`*^9, 3.5769903150671563`*^9, 3.576990361648838*^9, 
   3.57699052777353*^9, 3.576991389203643*^9, 3.576991612861236*^9, 
   3.576992451394909*^9, 3.5769928131595445`*^9, 3.5769933548392954`*^9, 
   3.576993431903431*^9, 3.5769937362131653`*^9, 3.576994174512535*^9, 
   3.5769951065985727`*^9, 3.576995250368425*^9, 3.584427162769226*^9, 
   3.58442729569706*^9, 3.5844273975340385`*^9, 3.584427667320913*^9, 
   3.584427731733426*^9, 3.584428022284936*^9, 3.5844280642178097`*^9, 
   3.5844284681961193`*^9, 3.584428589267932*^9, 3.5844287686536474`*^9, 
   3.5844292429568806`*^9, 3.5844293237962227`*^9, 3.584429364746294*^9, 
   3.584429426912403*^9, 3.584429592912295*^9, 3.5844299883271894`*^9, 
   3.584431509720862*^9, 3.5844319827302923`*^9, 3.6176886210891128`*^9, 
   3.6176886673791776`*^9, 3.617688744309285*^9, 3.6176888140693827`*^9, 
   3.6176888526694365`*^9, 3.61768889889355*^9, 3.617689373909263*^9, 
   3.6176894158193216`*^9, 3.6176895293435287`*^9, 3.617689609523641*^9, 
   3.617689774303872*^9, 3.662875892349736*^9, 3.663060472598101*^9, 
   3.663060519150894*^9, 3.6630606297165847`*^9, 3.663060703544032*^9, 
   3.690020733764571*^9, 3.6900208772845707`*^9, 3.6900211070345707`*^9, 
   3.6900261031725707`*^9, 3.690026177792571*^9, 3.9103403774838157`*^9, 
   3.9103443733587294`*^9, 3.959701253755209*^9, 3.959701340138592*^9, 
   3.9597014892624397`*^9},
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"feb455ef-98d5-d74e-b732-644ff9114513"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Note that symbols in the Global` context cannot be accessed right now.\
\>", "Text",
 CellChangeTimes->{
  3.423568541839567*^9},ExpressionUUID->"7ceb0cb8-abe3-4640-83bb-\
1ba04022ad10"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"accc4ed9-6ec1-4902-92b9-fc04001b28a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`SpaceSpinors`\"\>", ",", "\<\"xAct`SymSpin`\"\>", 
   ",", "\<\"xAct`TexAct`\"\>", ",", "\<\"xAct`SymManipulator`\"\>", 
   ",", "\<\"xAct`Spinors`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.6900261031825705`*^9, 3.690026177802571*^9, 
  3.910340377510744*^9, 3.9103443733916397`*^9, 3.959701253786127*^9, 
  3.959701340175495*^9, 3.959701489291361*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"544e1efb-441c-6843-87b0-091a566ecae3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"74bd840d-c578-4306-b1c5-d1456cd17170"],

Cell[BoxData["\<\"xAct`SpaceSpinors`\"\>"], "Output",
 CellChangeTimes->{3.6900261031925707`*^9, 3.6900261778125706`*^9, 
  3.910340377528695*^9, 3.9103443734176006`*^9, 3.959701253790119*^9, 
  3.959701340207409*^9, 3.9597014893182907`*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"981d1a5a-eac2-d747-8323-dd93623e07f5"]
}, Open  ]],

Cell["Established connection to external executable?", "Text",
 CellChangeTimes->{{3.419152978029696*^9, 
  3.419152995868268*^9}},ExpressionUUID->"e57e3d72-38cf-4d61-a22c-\
28dde243b59b"],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], "Input",
 CellChangeTimes->{{3.419152970981339*^9, 3.4191529720352583`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"c3e1f441-5b9e-4cbb-9ab4-e289b5553aef"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.5201748496184645`*^9, 3.520175596188966*^9, 3.520175968668816*^9, 
   3.5201760963522387`*^9, 3.5201762705617423`*^9, 3.520176756147991*^9, 
   3.5201779237452307`*^9, 3.520177973505715*^9, 3.52017803401902*^9, 
   3.520178123301774*^9, 3.5201783241057215`*^9, 3.52017901042572*^9, 
   3.520179110925495*^9, 3.520179193704038*^9, 3.5201792383821163`*^9, 
   3.520179284913394*^9, 3.520179463954904*^9, 3.5201795517558556`*^9, 
   3.520181360286601*^9, 3.520181636693485*^9, 3.5202685626818943`*^9, 
   3.5202687310413337`*^9, 3.5202688626619225`*^9, 3.5202688997583756`*^9, 
   3.520269092098248*^9, 3.5202718143009014`*^9, 3.5203106052771487`*^9, 
   3.5203109867029047`*^9, 3.5203117872904353`*^9, 3.520312104994713*^9, 
   3.527144937533472*^9, 3.5271458084694014`*^9, 3.5271460020355415`*^9, 
   3.5271470230437355`*^9, 3.527147594021338*^9, 3.527148046937934*^9, 
   3.527148264246315*^9, 3.52714868657946*^9, 3.5271500509276567`*^9, 
   3.5271501730758715`*^9, 3.5271503536929884`*^9, 3.5271505076184587`*^9, 
   3.5271507920537586`*^9, 3.5271508654050875`*^9, 3.529230823970925*^9, 
   3.529232467153011*^9, 3.529232571829195*^9, 3.529235909584858*^9, 
   3.5292362175917983`*^9, 3.529236417272149*^9, 3.5292366546577663`*^9, 
   3.5292367161696744`*^9, 3.5292369672697153`*^9, 3.5292370577654743`*^9, 
   3.53406857005099*^9, 3.5340689518148603`*^9, 3.5340693828436174`*^9, 
   3.5340699519638166`*^9, 3.5340701770410123`*^9, 3.5342496373593636`*^9, 
   3.537621498828197*^9, 3.537621625297619*^9, 3.537622842069556*^9, {
   3.5376229485553436`*^9, 3.5376229644985714`*^9}, 3.5376231830549555`*^9, 
   3.5376233616440687`*^9, 3.5376254400689197`*^9, 3.537628789787075*^9, 
   3.53769469999907*^9, 3.537694867870965*^9, 3.5376955018872786`*^9, 
   3.537695581681419*^9, 3.537695913354602*^9, 3.537696395348648*^9, 
   3.537697105135295*^9, 3.5376974605507193`*^9, {3.5376979707340155`*^9, 
   3.537697991357251*^9}, 3.5377005708257866`*^9, 3.5377009888129206`*^9, 
   3.5377011499300036`*^9, 3.5377050756954994`*^9, 3.537767650138689*^9, 
   3.537780186096708*^9, 3.537780584022207*^9, 3.5377809210149984`*^9, 
   3.537781080041678*^9, 3.5377812421259623`*^9, 3.5377813782518015`*^9, 
   3.5377815273256636`*^9, 3.537781725711212*^9, 3.5377823991497946`*^9, 
   3.5377827400103936`*^9, 3.537782931110729*^9, 3.537783191865187*^9, 
   3.537783440655424*^9, 3.537783572974857*^9, 3.5377841079933963`*^9, 
   3.5377842448212366`*^9, 3.544092209408361*^9, 3.544097240452398*^9, 
   3.5440973655802174`*^9, 3.544097952906649*^9, 3.544099754242813*^9, 
   3.544103372873969*^9, 3.5441034639781294`*^9, 3.544103705155553*^9, 
   3.544103917581126*^9, 3.544104051959762*^9, 3.5441050997366023`*^9, 
   3.5441057143776817`*^9, 3.544105949189294*^9, 3.544107147568799*^9, 
   3.5445912533502555`*^9, 3.5445914905248213`*^9, 3.5445916529051085`*^9, 
   3.5445929047197084`*^9, 3.5446721732382174`*^9, 3.5446723746587377`*^9, 
   3.544673273854169*^9, {3.544673382290371*^9, 3.5446734030965605`*^9}, 
   3.5449492190050254`*^9, 3.5449516142390347`*^9, 3.5450156628373337`*^9, 
   3.5450157246290426`*^9, 3.54510614233585*^9, 3.5451140206982203`*^9, 
   3.5528211956246023`*^9, 3.5528226596725736`*^9, 3.5528227956580124`*^9, 
   3.5528229868373485`*^9, 3.552823196002516*^9, 3.552823666358942*^9, 
   3.5528239713092775`*^9, 3.552826116797646*^9, 3.5528263093965845`*^9, 
   3.554207271492712*^9, 3.554208466987212*^9, 3.5613716975444193`*^9, 
   3.5617325864836073`*^9, 3.561779198505007*^9, 3.5617814881074286`*^9, 
   3.5617815620827584`*^9, 3.561781653030918*^9, 3.5617819013521547`*^9, 
   3.5617819337846117`*^9, 3.561782101517106*^9, 3.56178219474287*^9, 
   3.5617823881832094`*^9, 3.5617824926565933`*^9, 3.5617825258378515`*^9, 
   3.561784234308052*^9, 3.5627666271545515`*^9, 3.5627667439519567`*^9, 
   3.562767082378951*^9, 3.5627678932537756`*^9, 3.5627695459060783`*^9, 
   3.5627696678046923`*^9, {3.562771127719657*^9, 3.562771147188491*^9}, 
   3.562773114290546*^9, 3.5627732021655006`*^9, 3.5628212719276123`*^9, 
   3.5628223459280987`*^9, 3.5628235978322973`*^9, 3.5628236610904083`*^9, 
   3.5628240619331126`*^9, 3.5628245987310553`*^9, 3.562825243495788*^9, 
   3.5628253118551083`*^9, 3.5628253719152136`*^9, 3.562825959304045*^9, 
   3.562826133961952*^9, 3.562826248029352*^9, 3.562828065827773*^9, 
   3.5628285639990473`*^9, 3.5628287365977507`*^9, 3.5628288788076005`*^9, 
   3.56283048960603*^9, 3.562831305253463*^9, 3.562831699935156*^9, 
   3.562831819805766*^9, 3.5628318517702227`*^9, 3.5628323082738247`*^9, 
   3.5628324216704235`*^9, 3.562832729318564*^9, 3.562833669923216*^9, 
   3.562833764365782*^9, 3.562833834971506*^9, 3.5634256331361923`*^9, 
   3.563426367257882*^9, 3.5634272136539683`*^9, 3.563428699495178*^9, 
   3.56342879155094*^9, 3.5634288702686787`*^9, 3.5634296666042767`*^9, 
   3.564123612837238*^9, 3.564124345961526*^9, 3.5641248625262327`*^9, 
   3.564125017731906*^9, 3.564130442214634*^9, 3.5646350263770266`*^9, 
   3.5646354979502554`*^9, 3.5646721299434905`*^9, 3.565759287904766*^9, 
   3.565773667089635*^9, 3.5658920237827005`*^9, 3.566194852783429*^9, 
   3.566203971461871*^9, 3.566211903918866*^9, 3.566212640746361*^9, 
   3.5662147340984373`*^9, 3.5663991504129367`*^9, 3.5665437126463203`*^9, 
   3.5670828149165297`*^9, 3.5671851371295805`*^9, 3.5675865230207005`*^9, 
   3.5676004797253237`*^9, 3.5678594383187504`*^9, 3.56786057089734*^9, 
   3.5678613070012326`*^9, 3.567861520035207*^9, 3.5678616191421804`*^9, 
   3.567861715893551*^9, 3.5678618101957164`*^9, 3.5678620357097125`*^9, 
   3.5678622048140097`*^9, 3.567862536518392*^9, 3.56786268357985*^9, 
   3.5678627713924046`*^9, 3.567863320388569*^9, 3.5678634150339355`*^9, 
   3.5678639366520514`*^9, 3.567864088831319*^9, 3.567864253864009*^9, 
   3.56786476705811*^9, 3.5678650158785467`*^9, 3.567865314915472*^9, 
   3.567865528699248*^9, 3.56787745393296*^9, 3.5679119480184917`*^9, 
   3.5679130625312495`*^9, 3.567916910113186*^9, 3.567917676573732*^9, 
   3.567918361244334*^9, 3.56791861485398*^9, 3.567919444744238*^9, 
   3.5679197568071856`*^9, 3.567924257951492*^9, 3.5679261751490593`*^9, 
   3.5679264769627895`*^9, 3.567926861534665*^9, 3.5679294740140543`*^9, 
   3.567929590764659*^9, 3.567929672228002*^9, 3.5679298564019256`*^9, 
   3.5679300834457245`*^9, 3.567930175002285*^9, 3.567930336727769*^9, 
   3.567930622582671*^9, 3.567931058619037*^9, 3.5679312106413045`*^9, 
   3.567931331697517*^9, 3.5679314670901546`*^9, 3.5679315201156483`*^9, 
   3.5679316259150333`*^9, 3.567931950380004*^9, 3.5679326317112007`*^9, 
   3.5679327512698107`*^9, 3.567933125843068*^9, 3.5679332330620565`*^9, 
   3.5679334642544627`*^9, 3.567934710260851*^9, 3.567935972101268*^9, 
   3.568115004647156*^9, 3.5681159084981437`*^9, 3.568122253236088*^9, 
   3.568122355400667*^9, 3.568123412381524*^9, 3.5688951168490124`*^9, 
   3.5688954834496565`*^9, {3.5703549462638116`*^9, 3.5703549591962347`*^9}, 
   3.570357327421794*^9, 3.570357446653804*^9, 3.570357533265156*^9, 
   3.5703576111716924`*^9, 3.5703577470645313`*^9, 3.5703578049250326`*^9, 
   3.570357850211912*^9, 3.5703579052332087`*^9, 3.5703579399900703`*^9, 
   3.570358003965782*^9, 3.5703582328493843`*^9, 3.5703586284348793`*^9, 
   3.5703592171341133`*^9, 3.5703593077390723`*^9, 3.5703598585136395`*^9, 
   3.570360128534514*^9, 3.570360997784641*^9, 3.57036107706398*^9, 
   3.570361216013424*^9, 3.5703614882183027`*^9, 3.5703615691200447`*^9, 
   3.5703616697714214`*^9, 3.5703618788429885`*^9, 3.570362844906885*^9, 
   3.570363011998779*^9, 3.570363150495822*^9, 3.5703632389635773`*^9, 
   3.570363299944084*^9, 3.570363362250594*^9, 3.5703635573601365`*^9, 
   3.570364086591066*^9, 3.570364165761205*^9, 3.570364366940159*^9, 
   3.5703644730047445`*^9, 3.570364558633295*^9, 3.570364724399186*^9, 
   3.57036486294303*^9, 3.570364934001155*^9, 3.5703650450265493`*^9, {
   3.5703653940615625`*^9, 3.57036540402998*^9}, 3.5703654635596848`*^9, 
   3.5703657275901484`*^9, 3.570365791690661*^9, {3.5703658555259733`*^9, 
   3.5703658745424066`*^9}, 3.5703659376133175`*^9, 3.570365989187008*^9, 
   3.5703660969217973`*^9, 3.5703661766535373`*^9, 3.5703662332972364`*^9, 
   3.57036629761615*^9, 3.5703663396894236`*^9, 3.570366406535541*^9, 
   3.570366437875996*^9, 3.570366573705435*^9, 3.570366946327689*^9, 
   3.5703672461446157`*^9, 3.5703674010372877`*^9, 3.5703674957450542`*^9, 
   3.57036776102452*^9, 3.570367808698204*^9, 3.570367865232703*^9, 
   3.57036855813912*^9, 3.570368639976864*^9, 3.570368783606316*^9, 
   3.570368870670069*^9, 3.570368931135775*^9, 3.5704269113433743`*^9, 
   3.570427528199658*^9, 3.5704275978235803`*^9, 3.570427667680503*^9, 
   3.5704277545726557`*^9, 3.570431941232009*^9, 3.5704321837032347`*^9, 
   3.5704330981934414`*^9, 3.570436514684758*^9, 3.570438039135036*^9, 
   3.5704381714866686`*^9, 3.570438260188424*^9, 3.5704383518853855`*^9, 
   3.570438572750573*^9, 3.5704387566748962`*^9, 3.570438812678995*^9, 
   3.5769885491430545`*^9, 3.5769896649048142`*^9, 3.5769897137797003`*^9, 
   3.576989756586175*^9, 3.576989797083846*^9, 3.576990134606039*^9, 
   3.5769903151139565`*^9, 3.5769903616956377`*^9, 3.5769905278203297`*^9, 
   3.5769913892348433`*^9, 3.576991612908036*^9, 3.5769924514417086`*^9, 
   3.5769928132063446`*^9, 3.576993354886096*^9, 3.5769934319502316`*^9, 
   3.5769937362755656`*^9, 3.576994174574936*^9, 3.5769951066609726`*^9, 
   3.576995250415225*^9, 3.5844271628004265`*^9, 3.58442729572826*^9, 
   3.584427397580839*^9, 3.584427667352113*^9, 3.584427731764626*^9, 
   3.5844280223161364`*^9, 3.5844280642646103`*^9, 3.5844284682273197`*^9, 
   3.5844285892991323`*^9, 3.584428768700447*^9, 3.5844292429880805`*^9, 
   3.5844293238430223`*^9, 3.5844293647774944`*^9, 3.5844294269436035`*^9, 
   3.584429592943495*^9, 3.5844299883739896`*^9, 3.5844315097832623`*^9, 
   3.584431982777093*^9, 3.617688621119113*^9, 3.617688667409178*^9, 
   3.617688744339285*^9, 3.617688814089383*^9, 3.617688852689437*^9, 
   3.61768889891355*^9, 3.6176893739392633`*^9, 3.6176894158493223`*^9, 
   3.6176895293835287`*^9, 3.6176896095536413`*^9, 3.617689774343872*^9, 
   3.662875892389736*^9, 3.6630604726381035`*^9, 3.663060519180896*^9, 
   3.663060629756578*^9, 3.6630607035840254`*^9, 3.690020733804571*^9, 
   3.6900208773245707`*^9, 3.6900211070745707`*^9, 3.6900261031925707`*^9, 
   3.690026177822571*^9, 3.910340377545684*^9, 3.910344373441507*^9, 
   3.9597012538140545`*^9, 3.959701340211399*^9, 3.9597014893212814`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"863d4b58-dfae-fc4c-8d70-97cd25035b66"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. Non-standard setup", "Subsubsection",
 CellChangeTimes->{{3.4259903997539062`*^9, 
  3.425990420166374*^9}},ExpressionUUID->"6e7041e5-a29b-4a7a-80a7-\
5a7ee98160f8"],

Cell["Screen all dollar indices:", "Text",
 CellChangeTimes->{
  3.4232298843102837`*^9},ExpressionUUID->"156062d8-61f5-4f7c-a3c6-\
4ae8c26df340"],

Cell["$PrePrint = ScreenDollarIndices;", "Text",
 InitializationCell->True,
 CellChangeTimes->{
  3.5844292220528436`*^9},ExpressionUUID->"be099e94-b38f-49fc-b574-\
58bebbddfd2f"],

Cell["\<\
Timings will be shown if they are above 0.1 Second (Only for this notebook; \
this is not included in the package):\
\>", "Text",
 CellChangeTimes->{{3.5292379513058443`*^9, 
  3.5292379516490445`*^9}},ExpressionUUID->"444559e7-424f-4ac5-b07e-\
69a4c61ad7a4"],

Cell[BoxData[
 RowBox[{"<<", "xAct/ShowTime1.m"}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"a167a13f-4a74-40ba-b458-9cc176456294"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$ShowTimeThreshold", "=", "0.1"}]], "Input",
 CellChangeTimes->{{3.5159388321237755`*^9, 3.51593883486938*^9}, {
  3.517390968479415*^9, 3.517390975967428*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"0f7d6149-14cb-4b4e-bacb-12257ef6b1ed"],

Cell[BoxData["0.1`"], "Output",
 CellChangeTimes->{
  3.5201748496340647`*^9, 3.520175596218966*^9, 3.520175968700016*^9, 
   3.520176096367839*^9, 3.5201762705773425`*^9, 3.520176756177991*^9, 
   3.5201779237608304`*^9, 3.520177973536915*^9, 3.5201780340502205`*^9, 
   3.520178123321774*^9, 3.520178324136921*^9, 3.52017901045572*^9, 
   3.520179110955495*^9, 3.5201791937340384`*^9, 3.520179238402116*^9, 
   3.520179284933394*^9, 3.520179463986104*^9, 3.5201795517858553`*^9, 
   3.5201813603178015`*^9, 3.5201816367246847`*^9, 3.520268562701894*^9, 
   3.5202687310569334`*^9, 3.520268862691922*^9, 3.5202688997895756`*^9, 
   3.520269092118248*^9, 3.520271814330901*^9, 3.520310605307149*^9, 
   3.520310986734105*^9, 3.5203117873204355`*^9, 3.520312105014713*^9, 
   3.5271449375490723`*^9, 3.5271458084850016`*^9, 3.5271460020511417`*^9, 
   3.527147023074935*^9, 3.5271475940369377`*^9, 3.5271480469691334`*^9, 
   3.5271482642775154`*^9, 3.5271486865950603`*^9, 3.5271500509588566`*^9, 
   3.527150173107071*^9, 3.5271503537085886`*^9, 3.527150507634059*^9, 
   3.527150792084958*^9, 3.527150865420687*^9, 3.529230824002125*^9, 
   3.529232467184211*^9, 3.5292325718447948`*^9, 3.5292359096160574`*^9, 
   3.529236217622998*^9, 3.5292364173033495`*^9, 3.5292366546889663`*^9, 
   3.5292367162008743`*^9, 3.5292369672853155`*^9, 3.5292370577966747`*^9, 
   3.53406857008219*^9, 3.5340689518616605`*^9, 3.534069382874818*^9, 
   3.5340699520106173`*^9, 3.534070177072212*^9, 3.534249637421764*^9, 
   3.537621498874997*^9, 3.5376216253444195`*^9, 3.5376228421163564`*^9, {
   3.5376229486021433`*^9, 3.5376229645453715`*^9}, 3.537623183101755*^9, 
   3.5376233616908693`*^9, 3.5376254401001196`*^9, 3.5376287898338747`*^9, 
   3.5376947000458703`*^9, 3.537694867917765*^9, 3.5376955019340787`*^9, 
   3.537695581728219*^9, 3.5376959134014015`*^9, 3.537696395395448*^9, 
   3.5376971051820946`*^9, 3.537697460597519*^9, {3.537697970780815*^9, 
   3.537697991404052*^9}, 3.5377005708725863`*^9, 3.5377009888597207`*^9, 
   3.537701149976804*^9, 3.537705075742299*^9, 3.537767650201089*^9, 
   3.537780186143508*^9, 3.537780584069007*^9, 3.537780921061799*^9, 
   3.537781080088478*^9, 3.5377812421571627`*^9, 3.537781378298602*^9, 
   3.5377815273724637`*^9, 3.537781725742412*^9, 3.537782399196595*^9, 
   3.5377827400571938`*^9, 3.537782931157529*^9, 3.537783191896387*^9, 
   3.5377834407178245`*^9, 3.537783573006057*^9, 3.5377841080557966`*^9, 
   3.537784244852437*^9, 3.544092209439561*^9, 3.544097240499198*^9, 
   3.5440973656426177`*^9, 3.5440979529534492`*^9, 3.5440997542896132`*^9, 
   3.544103372920769*^9, 3.544103464024929*^9, 3.5441037052023525`*^9, 
   3.5441039176123257`*^9, 3.544104051990962*^9, 3.5441050997834024`*^9, 
   3.5441057144244823`*^9, 3.5441059492360945`*^9, 3.544107147615599*^9, 
   3.544591253394258*^9, 3.5445914905668235`*^9, 3.5445916529481115`*^9, 
   3.5445929047607107`*^9, 3.5446721732902203`*^9, 3.5446723747047405`*^9, 
   3.5446732739081717`*^9, {3.5446733823533745`*^9, 3.5446734031515636`*^9}, 
   3.5449492190674257`*^9, 3.544951614270234*^9, 3.5450156628841343`*^9, 
   3.545015724660242*^9, 3.54510614236705*^9, 3.545114020745021*^9, 
   3.552821195671402*^9, 3.552822659734974*^9, 3.5528227957048125`*^9, 
   3.5528229868997483`*^9, 3.5528231960649157`*^9, 3.552823666421342*^9, 
   3.5528239713872776`*^9, 3.552826116844446*^9, 3.552826309443384*^9, 
   3.554207271555112*^9, 3.554208467049612*^9, 3.5613716975756197`*^9, 
   3.5617325865148077`*^9, 3.5617791985518074`*^9, 3.5617814881542287`*^9, 
   3.5617815621139584`*^9, 3.5617816530621185`*^9, 3.5617819014145546`*^9, 
   3.561781933815811*^9, 3.561782101548306*^9, 3.56178219477407*^9, 
   3.5617823882300096`*^9, 3.561782492703393*^9, 3.5617825258690515`*^9, 
   3.5617842343548527`*^9, 3.562766627201352*^9, 3.5627667439831567`*^9, 
   3.5627670824101515`*^9, 3.5627678933005753`*^9, 3.5627695459372787`*^9, 
   3.5627696678358927`*^9, {3.562771127750857*^9, 3.5627711472196913`*^9}, 
   3.562773114337346*^9, 3.5627732021967*^9, 3.5628212719588118`*^9, 
   3.562822345959298*^9, 3.5628235978634977`*^9, 3.5628236611216087`*^9, 
   3.5628240619643126`*^9, 3.5628245987622557`*^9, 3.562825243526988*^9, 
   3.562825311901908*^9, 3.5628253719464135`*^9, 3.5628259593508453`*^9, 
   3.5628261339931517`*^9, 3.5628262480605526`*^9, 3.5628280658745728`*^9, 
   3.5628285640302477`*^9, 3.562828736628951*^9, 3.562828878838801*^9, 
   3.56283048963723*^9, 3.5628313052846622`*^9, 3.562831699981956*^9, 
   3.5628318198525667`*^9, 3.5628318518170223`*^9, 3.5628323083206244`*^9, 
   3.5628324217172236`*^9, 3.562832729349764*^9, 3.5628336699856157`*^9, 
   3.562833764396982*^9, 3.562833835018306*^9, 3.5634256331673927`*^9, 
   3.563426367289082*^9, 3.5634272137163687`*^9, 3.5634286995419784`*^9, 
   3.56342879159774*^9, 3.5634288703154783`*^9, 3.563429666635477*^9, 
   3.564123612899638*^9, 3.5641243460083256`*^9, 3.564124862557433*^9, 
   3.5641250177631054`*^9, 3.5641304422614336`*^9, 3.564635026408227*^9, 
   3.564635497997055*^9, 3.5646721299902906`*^9, 3.5657592879515667`*^9, 
   3.5657736671208353`*^9, 3.5658920238139005`*^9, 3.566194852830229*^9, 
   3.5662039714930716`*^9, 3.566211903965666*^9, 3.566212640793161*^9, 
   3.5662147341296377`*^9, 3.566399150459737*^9, 3.56654371269312*^9, 
   3.5670828149633293`*^9, 3.567185137160781*^9, 3.5675865230675*^9, 
   3.567600479756524*^9, 3.5678594383343506`*^9, 3.5678605709285393`*^9, 
   3.5678613070324326`*^9, 3.5678615200664067`*^9, 3.5678616191577806`*^9, 
   3.567861715924751*^9, 3.5678618102269163`*^9, 3.567862035725312*^9, 
   3.56786220482961*^9, 3.567862536549592*^9, 3.5678626835954504`*^9, 
   3.567862771423605*^9, 3.567863320404169*^9, 3.5678634150495353`*^9, 
   3.5678639366832514`*^9, 3.567864088846919*^9, 3.5678642538796086`*^9, 
   3.5678647670893097`*^9, 3.567865015909747*^9, 3.5678653149466724`*^9, 
   3.567865528730448*^9, 3.5678774539485598`*^9, 3.567911948049692*^9, 
   3.5679130625624495`*^9, 3.5679169101443853`*^9, 3.5679176765893316`*^9, 
   3.5679183612755346`*^9, 3.56791861488518*^9, 3.5679194447598376`*^9, 
   3.5679197568227854`*^9, 3.567924257982692*^9, 3.567926175180259*^9, 
   3.5679264769783893`*^9, 3.5679268615658646`*^9, 3.567929474029654*^9, 
   3.567929590780259*^9, 3.5679296722436023`*^9, 3.5679298564331255`*^9, 
   3.5679300834769244`*^9, 3.5679301750334854`*^9, 3.5679303367589693`*^9, 
   3.5679306226138716`*^9, 3.567931058650237*^9, 3.5679312106725044`*^9, 
   3.5679313317131166`*^9, 3.567931467105755*^9, 3.5679315201468477`*^9, 
   3.5679316259306335`*^9, 3.5679319503956037`*^9, 3.5679326317268004`*^9, 
   3.56793275130101*^9, 3.5679331258586683`*^9, 3.5679332330776567`*^9, 
   3.5679334642856627`*^9, 3.5679347102920513`*^9, 3.5679359721324673`*^9, 
   3.568115004678356*^9, 3.5681159085293436`*^9, 3.568122253267288*^9, 
   3.5681223554474673`*^9, 3.5681234123971243`*^9, 3.5688951168958125`*^9, 
   3.5688954834808564`*^9, {3.5703549462950115`*^9, 3.570354959227434*^9}, 
   3.5703573274529943`*^9, 3.5703574466694036`*^9, 3.5703575332963552`*^9, 
   3.5703576112028923`*^9, 3.5703577470957313`*^9, 3.570357804940633*^9, 
   3.5703578502275124`*^9, 3.570357905264409*^9, 3.57035794000567*^9, 
   3.5703580039813824`*^9, 3.5703582328649845`*^9, 3.5703586284504795`*^9, 
   3.5703592171653132`*^9, 3.5703593077702723`*^9, 3.5703598585292397`*^9, 
   3.5703601285501137`*^9, 3.5703609978158407`*^9, 3.5703610770795803`*^9, 
   3.5703612160446243`*^9, 3.5703614882339025`*^9, 3.570361569151244*^9, 
   3.570361669787021*^9, 3.570361878858588*^9, 3.5703628449380856`*^9, 
   3.5703630120143785`*^9, 3.570363150527022*^9, 3.5703632389947777`*^9, 
   3.5703632999752846`*^9, 3.570363362281794*^9, 3.570363557391337*^9, 
   3.570364086606666*^9, 3.570364165776805*^9, 3.570364366971359*^9, 
   3.570364473035945*^9, 3.5703645586488953`*^9, 3.5703647244303865`*^9, 
   3.57036486297423*^9, 3.5703649340323544`*^9, 3.5703650450577497`*^9, {
   3.570365394108363*^9, 3.57036540404558*^9}, 3.5703654635908847`*^9, 
   3.5703657276213484`*^9, 3.570365791721861*^9, {3.5703658555571733`*^9, 
   3.5703658745580063`*^9}, 3.5703659376445174`*^9, 3.570365989202608*^9, 
   3.570366096937397*^9, 3.570366176684737*^9, 3.570366233328437*^9, 
   3.57036629764735*^9, 3.570366339705024*^9, 3.570366406551141*^9, 
   3.570366437891596*^9, 3.570366573721035*^9, 3.5703669463432894`*^9, 
   3.5703672461602154`*^9, 3.570367401052888*^9, 3.570367495776254*^9, 
   3.57036776104012*^9, 3.570367808729404*^9, 3.570367865263903*^9, 
   3.5703685581703205`*^9, 3.5703686400080643`*^9, 3.570368783637516*^9, 
   3.570368870685669*^9, 3.5703689311513753`*^9, 3.5704269113589745`*^9, 
   3.570427528230858*^9, 3.57042759783918*^9, 3.570427667696103*^9, 
   3.570427754588256*^9, 3.5704319412632093`*^9, 3.570432183718835*^9, 
   3.570433098209041*^9, 3.5704365147003584`*^9, 3.5704380391506357`*^9, 
   3.5704381715178685`*^9, 3.5704382602196245`*^9, 3.5704383519009857`*^9, 
   3.570438572781773*^9, 3.5704387567060966`*^9, 3.5704388127101946`*^9, 
   3.576988549158654*^9, 3.5769896649204144`*^9, 3.5769897138108997`*^9, 
   3.576989756601775*^9, 3.5769897971150465`*^9, 3.5769901346216393`*^9, 
   3.5769903151451564`*^9, 3.576990361711238*^9, 3.57699052785153*^9, 
   3.576991389266043*^9, 3.576991612923636*^9, 3.576992451457309*^9, 
   3.5769928132219443`*^9, 3.5769933549172955`*^9, 3.5769934319658313`*^9, 
   3.5769937363067656`*^9, 3.5769941746061354`*^9, 3.576995106692173*^9, 
   3.5769952504464254`*^9, 3.584427162831627*^9, 3.5844272957438602`*^9, 
   3.584427397596439*^9, 3.584427667367713*^9, 3.5844277317802258`*^9, 
   3.5844280223317366`*^9, 3.58442806428021*^9, 3.58442846824292*^9, 
   3.5844285893147326`*^9, 3.5844287687160473`*^9, 3.58442924300368*^9, 
   3.5844293238586226`*^9, 3.5844293647930946`*^9, 3.5844294269592037`*^9, 
   3.584429592959095*^9, 3.5844299883895893`*^9, 3.584431509798862*^9, 
   3.584431982777093*^9, 3.6176886211291127`*^9, 3.6176886674191775`*^9, 
   3.617688744349285*^9, 3.617688814109383*^9, 3.617688852709437*^9, 
   3.6176888989235497`*^9, 3.617689373949263*^9, 3.617689415859322*^9, 
   3.617689529393529*^9, 3.6176896095736413`*^9, 3.6176897743538723`*^9, 
   3.6628758923997364`*^9, 3.663060472658105*^9, 3.663060519200897*^9, 
   3.663060629776575*^9, 3.663060703604022*^9, 3.6900207338245707`*^9, 
   3.690020877344571*^9, 3.690021107094571*^9, 3.690026103242571*^9, 
   3.690026177832571*^9, 3.910340377572579*^9, 3.9103443734484873`*^9, 
   3.9597012538210335`*^9, 3.9597013402423153`*^9, 3.959701489349207*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"4bfc65c9-4e7f-d541-93cf-cd95b27f57e9"]
}, Open  ]],

Cell[TextData[{
 "We also read the package (this is not automatic in ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " anymore since its version 0.6.2):"
}], "Text",ExpressionUUID->"d3a937eb-5fe6-403b-805d-6d7228daca9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct/ExpressionManipulation.m"}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"83b7e2c5-c210-47c0-9cbe-55c26961b845"],

Cell[BoxData[
 TemplateBox[{
  "Set", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"ColorPositions\\\"}]\\) in \\!\\(\\*RowBox[{\\\
\"Options\\\", \\\"[\\\", \\\"ColorPositions\\\", \\\"]\\\"}]\\) is \
Protected.\"", 2, 45, 1, 28865286614347849434, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.959701253881872*^9, 3.959701340301159*^9, 
  3.959701489407053*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"5a63d6ac-e92b-874c-8867-125c9e8f329b"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"ColorPositions\\\"}]\\) in \
\\!\\(\\*RowBox[{RowBox[{\\\"ColorPositions\\\", \\\"[\\\", \
RowBox[{\\\"positionlist_\\\", \\\",\\\", RowBox[{\\\"opts___\\\", \\\"?\\\", \
\\\"OptionQ\\\"}]}], \\\"]\\\"}], \\\"[\\\", \\\"expr_\\\", \\\"]\\\"}]\\) is \
Protected.\"", 2, 45, 2, 28865286614347849434, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.959701253881872*^9, 3.959701340301159*^9, 
  3.959701489453928*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"10ec5d94-60be-134c-9c85-9708c3b9623b"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"CompleteTheSquare\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"CompleteTheSquare\\\", \\\"[\\\", RowBox[{\\\"expr_\\\", \
\\\",\\\", RowBox[{\\\"var_\\\", \\\":\\\", \\\"x\\\"}]}], \\\"]\\\"}]\\) is \
Protected.\"", 2, 45, 3, 28865286614347849434, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.959701253881872*^9, 3.959701340301159*^9, 
  3.959701489470909*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"af091c70-6a4b-a940-8ad7-237a8f84e870"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "wrsym", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"ErsekComplexity\\\"}]\\) is Protected.\"", 
   2, 45, 4, 28865286614347849434, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.959701253881872*^9, 3.959701340301159*^9, 
  3.959701489502796*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"ef755c87-1705-534e-9628-aff0bcaac378"],

Cell[BoxData[
 TemplateBox[{
  "Set", "wrsym", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"ErsekComplexity\\\"}]\\) is Protected.\"", 
   2, 45, 5, 28865286614347849434, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.959701253881872*^9, 3.959701340301159*^9, 
  3.9597014895407257`*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"22e92847-a444-b04e-9982-8b73b1760948"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"EvaluateAt\\\"}]\\) in \
\\!\\(\\*RowBox[{RowBox[{\\\"EvaluateAt\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"posn\\\", \\\":\\\", RowBox[{\\\"_Integer\\\", \\\"|\\\", \
RowBox[{\\\"{\\\", \\\"__Integer\\\", \\\"}\\\"}]}]}], \\\",\\\", \
RowBox[{\\\"f_\\\", \\\":\\\", \\\"Identity\\\"}]}], \\\"]\\\"}], \\\"[\\\", \
\\\"expr_\\\", \\\"]\\\"}]\\) is Protected.\"", 2, 45, 6, 
   28865286614347849434, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.959701253881872*^9, 3.959701340301159*^9, 
  3.9597014895457096`*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"469b8580-9b75-024d-98b3-25391eccd07f"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"SetDelayed\\\", \
\\\"::\\\", \\\"write\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 45, 7, 28865286614347849434, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.959701253881872*^9, 3.959701340301159*^9, 
  3.9597014895506954`*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"68e519fe-1dfa-6444-9f3f-aedbb654bf8b"],

Cell[BoxData["0.203125`"], "Print",
 CellChangeTimes->{3.9597012540823364`*^9, 3.959701340466715*^9, 
  3.95970148957959*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"51703a79-7023-114a-b4b7-2f74f0c40724"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5. Usage messages", "Subsubsection",
 InitializationCell->
  True,ExpressionUUID->"ef8b2407-159d-46a1-a639-ed6155bb123f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefSpaceSpinStructure", "::", "usage"}], " ", "=", 
   "\"\<DefSpaceSpinStructure[Sigma, Metrich, Ns, SpatialSigma, Dd, Nb] \
defines a space spinor structure based on the spacetime spin soldering form \
Sigma and the intrinsic metric Metrich. The function defines the spinor \
version of the normal Ns, the spatial soldering form SpatialSigma, the Sen \
connection Dd, and the intrinsic connection Nb.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SenToSpinCovDRules", "::", "usage"}], "=", 
   "\"\<SenToSpinCovDRules is a collection of rules that transfoms indexed \
Sen derivatives to spacetime spinor derivatives.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinCovDToSenRules", "::", "usage"}], "=", 
   "\"\<SpinCovDToSenRules is a collection of rules that transfoms indexed \
spacetime spinor derivatives to Sen derivatives.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DirToSpinCovDRules", "::", "usage"}], "=", 
   "\"\<DirToSpinCovDRules is a collection of rules that transfoms indexed \
normal derivatives to indexed spacetime spinor derivatives.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpatialSFToSF", "::", "usage"}], "=", 
   "\"\<SpatialSFToSF[Nn] is an equation expressing the spatial soldering \
form in terms of the spacetime soldering form. Nn is the normal \
tensor.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SFToSpatialSF", "::", "usage"}], "=", 
   "\"\<SpatialSFToSF[Nn] is an equation expressing the spatial soldering \
form in terms of the spacetime soldering form. Nn is the normal \
tensor.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfCovD", "::", "usage"}], "=", 
   "\"\<Default index configuration in the derivative indices.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefSpatialBox", "::", "usage"}], "=", 
   "\"\<DefSpatialBox[covd] defines a commutator box for the spatial \
derivative covd.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpatialBoxToCovD", "::", "usage"}], "=", 
   "\"\<SpatialBoxToCovD[expr, boxcd] converts the spatial box boxcd in expr \
to the corresponding contracted and symmetrized derivative.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefFundSpatialSpinOperators", "::", "usage"}], "=", 
   "\"\<DefFundSpatialSpinOperators[covd] defines fundamental spinor \
operators for the intrinsic or Sen differential operator covd.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefFundSpatialSpinOperators", "::", "usage"}], "=", 
   "\"\<UndefFundSpatialSpinOperators[covd]\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$ExtrinsicKScalingConv", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$AccelerationScalingConv", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NormalOfCovD", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinorOfNormal", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FundSpinOpNormalRules", "::", "usage"}], "=", 
   "\"\<FundSpinOpNormalRules[Ns] converts the fundamental spinor operators \
acting on the normal spinor Ns to acceleration and irreducible components of \
the extrinsic curvature.\>\""}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5703551580029836`*^9, 3.570355181605825*^9}, {
   3.5703552181410894`*^9, 3.5703553832517796`*^9}, {3.570355430285862*^9, 
   3.570355495150776*^9}, {3.570355534431645*^9, 3.5703555345096445`*^9}, {
   3.5703555799057245`*^9, 3.57035575356623*^9}, {3.570365006572482*^9, 
   3.570365012313292*^9}, {3.5703657000561*^9, 3.570365704502108*^9}, {
   3.570367042891859*^9, 3.5703670491318693`*^9}, {3.57036816495603*^9, 
   3.570368176141249*^9}, {3.5704269990623283`*^9, 3.570427004007537*^9}, {
   3.5769925952427616`*^9, 3.5769926097975874`*^9}, {3.5769927120089664`*^9, 
   3.5769927804150867`*^9}, {3.5844272514865828`*^9, 
   3.5844272518921833`*^9}, {3.617692983148362*^9, 3.6176930112784014`*^9}, {
   3.6176930862385063`*^9, 3.617693099548525*^9}, {3.663060316872916*^9, 
   3.6630603277332425`*^9}, {3.6900188577432213`*^9, 
   3.6900188580232067`*^9}, {3.690019163445644*^9, 3.690019205325225*^9}, {
   3.690019246754811*^9, 3.6900192524947534`*^9}, {3.690019426294571*^9, 
   3.690019438904571*^9}, {3.690019497814571*^9, 3.690019547024571*^9}, {
   3.690020392054571*^9, 3.6900204936045713`*^9}, {3.9103393705719147`*^9, 
   3.9103394165233545`*^9}, {3.910344781023514*^9, 3.9103447890841064`*^9}, {
   3.956740794357731*^9, 3.9567407991541862`*^9}, {3.9567410660222034`*^9, 
   3.9567410744636364`*^9}, {3.956741119486435*^9, 3.95674112358267*^9}, 
   3.9567411852039433`*^9, {3.957368791271843*^9, 3.957368806278143*^9}, {
   3.958560405868326*^9, 3.9585604943786297`*^9}, {3.9596015466721783`*^9, 
   3.9596015502555943`*^9}, {3.95960178903903*^9, 3.9596018001433277`*^9}, {
   3.9597002171922264`*^9, 3.9597002349766808`*^9}, {3.9597003053917427`*^9, 
   3.9597006389761524`*^9}, {3.9597006750014935`*^9, 3.959700766456644*^9}, {
   3.9597008088153877`*^9, 3.9597008764075336`*^9}, {3.959700911384058*^9, 
   3.9597009786569443`*^9}, {3.959701089399889*^9, 3.9597011258497944`*^9}, {
   3.9597011577674522`*^9, 3.9597011692493095`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"a4a91fc5-a401-41ee-b504-8cfdde8883f2"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.6. Begin private", "Subsubsection",ExpressionUUID->"476bfd7d-7652-4561-a895-07ee8e888d65"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[62]:=",ExpressionUUID->"ddc8959c-bfe1-4a0e-9728-7f8691b1d836"],

Cell[BoxData["\<\"xAct`SpaceSpinors`Private`\"\>"], "Output",
 CellChangeTimes->{3.690026103322571*^9, 3.6900261778925705`*^9, 
  3.9103403776284294`*^9, 3.91034437349636*^9, 3.959701254114252*^9, 
  3.959701340475691*^9, 3.95970148958757*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"ca9ef85f-899b-6e40-9167-1c2875845495"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\"\<xAct`SpaceSpinors`Private`\>\""], "Input",
 CellChangeTimes->{{3.6900258312205706`*^9, 3.6900258312205706`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"14e5d1ad-d97d-4116-9f57-45376c8173f7"],

Cell[BoxData["\<\"xAct`SpaceSpinors`Private`\"\>"], "Output",
 CellChangeTimes->{3.690026103322571*^9, 3.6900261779025707`*^9, 
  3.9103403776354103`*^9, 3.910344373519327*^9, 3.9597012541182423`*^9, 
  3.959701340479679*^9, 3.959701489614498*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"95fe4167-b675-4a4e-afa2-423ce5391d3a"]
}, Open  ]],

Cell["The reserved words in version 0.1.0 :", "Text",
 CellChangeTimes->{{3.5157533805469513`*^9, 3.5157533977299337`*^9}, 
   3.5157546086511946`*^9, {3.5157546435341897`*^9, 3.515754643595193*^9}, {
   3.5157566043206267`*^9, 3.5157566044298267`*^9}, {3.517824627882413*^9, 
   3.5178246279354157`*^9}, {3.5178247353335586`*^9, 
   3.5178247353725605`*^9}, {3.5178368637722654`*^9, 
   3.5178368687315493`*^9}},ExpressionUUID->"f495dc70-aad7-44cb-872b-\
622007dc6552"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`SpaceSpinors`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.515744906140235*^9, 3.5157449089503956`*^9}, 
   3.515938353904936*^9, 3.5703536314613028`*^9, 3.690025831230571*^9},
 CellLabel->"In[64]:=",ExpressionUUID->"4c8ed378-da43-45fa-a8b2-f463a6ebf17e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DefFundSpatialSpinOperators\"\>", 
   ",", "\<\"DefSpaceSpinStructure\"\>", ",", "\<\"DefSpatialBox\"\>", 
   ",", "\<\"DirToSpinCovDRules\"\>", ",", "\<\"FundSpinOpNormalRules\"\>", 
   ",", "\<\"NormalOfCovD\"\>", ",", "\<\"SenToSpinCovDRules\"\>", 
   ",", "\<\"SFToSpatialSF\"\>", ",", "\<\"SlotsOfCovD\"\>", 
   ",", "\<\"SpatialBoxToCovD\"\>", ",", "\<\"SpatialSFToSF\"\>", 
   ",", "\<\"SpinCovDToSenRules\"\>", ",", "\<\"SpinorOfNormal\"\>", 
   ",", "\<\"UndefFundSpatialSpinOperators\"\>", 
   ",", "\<\"$AccelerationScalingConv\"\>", 
   ",", "\<\"$ExtrinsicKScalingConv\"\>", ",", "\<\"$Version\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5201748498368645`*^9, 3.520175596408966*^9, 3.520175968949617*^9, 
   3.520176096570639*^9, 3.520176270780143*^9, 3.520176756357991*^9, 
   3.5201779239480305`*^9, 3.5201779737241154`*^9, 3.520178034237421*^9, 
   3.520178123511774*^9, 3.5201783243241215`*^9, 3.5201790106457205`*^9, 
   3.520179111195495*^9, 3.5201791939140387`*^9, 3.520179238602116*^9, 
   3.5201792851233945`*^9, 3.5201794641733046`*^9, 3.520179551975856*^9, 
   3.520181360505002*^9, 3.5201816369274855`*^9, 3.5202685629118943`*^9, 
   3.520268731259734*^9, 3.5202688628819227`*^9, 3.520268899976776*^9, 
   3.5202690923082485`*^9, 3.520271814540901*^9, 3.520310605507149*^9, 
   3.520310986936905*^9, 3.5203117875304356`*^9, 3.520312105214713*^9, 
   3.527144937720672*^9, 3.5271458086410017`*^9, 3.527146002222742*^9, 
   3.5271470232465353`*^9, 3.5271475941929383`*^9, 3.527148047125134*^9, 
   3.5271482644335155`*^9, 3.5271486867822604`*^9, 3.527150051146057*^9, 
   3.5271501732630715`*^9, 3.527150353880189*^9, 3.527150507790059*^9, 
   3.5271507922409587`*^9, 3.5271508655766873`*^9, 3.529230824173725*^9, 
   3.529232467340211*^9, 3.529232572016395*^9, 3.5292359097720575`*^9, 
   3.529236217778999*^9, 3.5292364174593496`*^9, 3.529236654860566*^9, 
   3.5292367163568745`*^9, 3.5292369674413157`*^9, 3.529237057952675*^9, 
   3.53406857026939*^9, 3.534068952033261*^9, 3.534069383062018*^9, 
   3.5340699521978173`*^9, 3.5340701772438126`*^9, 3.5342496376401644`*^9, 
   3.537621499077798*^9, 3.5376216255316195`*^9, 3.537622842303557*^9, {
   3.537622948758144*^9, 3.537622964748172*^9}, 3.5376231832733555`*^9, 
   3.5376233618780694`*^9, 3.5376254403029203`*^9, 3.5376287900366755`*^9, 
   3.5376947002486706`*^9, 3.5376948680893655`*^9, 3.5376955021056795`*^9, 
   3.5376955818998194`*^9, 3.537695913588602*^9, 3.5376963955982485`*^9, 
   3.5376971053848953`*^9, 3.5376974607847195`*^9, {3.5376979709524155`*^9, 
   3.537697991606852*^9}, 3.537700571075387*^9, 3.537700989078121*^9, 
   3.5377011501640043`*^9, 3.5377050759294996`*^9, 3.53776765041949*^9, 
   3.5377801863307085`*^9, 3.5377805842406073`*^9, 3.537780921264599*^9, 
   3.5377810802756786`*^9, 3.537781242344363*^9, 3.537781378501402*^9, 
   3.537781527575264*^9, 3.537781725929612*^9, 3.5377823993837953`*^9, 
   3.5377827402443943`*^9, 3.5377829313291297`*^9, 3.537783192099188*^9, 
   3.5377834409206247`*^9, 3.5377835732088575`*^9, 3.537784108227397*^9, 
   3.537784245039637*^9, 3.5440922096423616`*^9, 3.5440972417628*^9, 
   3.544097365814218*^9, 3.5440979531250496`*^9, 3.5440997544924135`*^9, 
   3.5441033731235695`*^9, 3.5441034642121296`*^9, 3.5441037054051533`*^9, 
   3.5441039178151264`*^9, 3.5441040521937623`*^9, 3.544105099955003*^9, 
   3.544105714627282*^9, 3.5441059494388947`*^9, 3.5441071478027997`*^9, 
   3.544591253590269*^9, 3.5445914907438335`*^9, 3.544591653144122*^9, 
   3.5445929049517217`*^9, 3.544672173493232*^9, 3.5446723748987513`*^9, 
   3.5446732741261845`*^9, {3.544673382502383*^9, 3.5446734033675766`*^9}, 
   3.544949219254626*^9, 3.5449516144574347`*^9, 3.5450156630557346`*^9, 
   3.5450157248474426`*^9, 3.5451061425542502`*^9, 3.545114020932221*^9, 
   3.552821195889803*^9, 3.5528226599377737`*^9, 3.552822795907613*^9, 
   3.5528229871025486`*^9, 3.552823196252116*^9, 3.5528236666085424`*^9, 
   3.552823971574478*^9, 3.5528261170472465`*^9, 3.5528263096149845`*^9, 
   3.5542072717423124`*^9, 3.5542084672524123`*^9, 3.56137169777842*^9, 
   3.561732586748808*^9, 3.561779198754607*^9, 3.561781488372629*^9, 
   3.561781562316759*^9, 3.5617816532649183`*^9, 3.5617819015705547`*^9, 
   3.561781934018612*^9, 3.5617821017667065`*^9, 3.5617821949924703`*^9, 
   3.56178238843281*^9, 3.5617824929061937`*^9, 3.561782526087452*^9, 
   3.5617842345576525`*^9, 3.562766627404152*^9, 3.562766744185957*^9, 
   3.5627670826129513`*^9, 3.562767893487776*^9, 3.5627695461400785`*^9, 
   3.5627696680386925`*^9, {3.562771127938057*^9, 3.562771147422491*^9}, 
   3.5627731145245466`*^9, 3.5627732023839006`*^9, 3.5628212721772127`*^9, 
   3.5628223461464987`*^9, 3.562823598050698*^9, 3.5628236613244085`*^9, 
   3.5628240621671133`*^9, 3.5628245989494557`*^9, 3.5628252437141886`*^9, 
   3.5628253121047087`*^9, 3.562825372149214*^9, 3.5628259595692453`*^9, 
   3.5628261341959524`*^9, 3.5628262482789526`*^9, 3.5628280660773735`*^9, 
   3.562828564217448*^9, 3.562828736816151*^9, 3.562828879041601*^9, 
   3.5628304898244305`*^9, 3.5628313054562626`*^9, 3.562831700169156*^9, 
   3.5628318199929667`*^9, 3.562831852051023*^9, 3.5628323084922247`*^9, 
   3.562832421920024*^9, 3.5628327295525646`*^9, 3.5628336701884165`*^9, 
   3.5628337645997825`*^9, 3.5628338352211065`*^9, 3.5634256333857927`*^9, 
   3.563426367476282*^9, 3.563427213919169*^9, 3.563428699729179*^9, 
   3.5634287918005404`*^9, 3.563428870502679*^9, 3.5634296668226776`*^9, 
   3.564123613102438*^9, 3.564124346195526*^9, 3.564124862760233*^9, 
   3.564125017965906*^9, 3.564130442448634*^9, 3.5646350266110272`*^9, 
   3.5646354981686554`*^9, 3.564672130193091*^9, 3.565759288138767*^9, 
   3.565773667292435*^9, 3.5658920240167007`*^9, 3.5661948530174294`*^9, 
   3.566203971680272*^9, 3.566211904168466*^9, 3.566212640980361*^9, 
   3.566214734301238*^9, 3.5663991506469374`*^9, 3.5665437128803205`*^9, 
   3.56708281515053*^9, 3.5671851373479815`*^9, 3.5675865232391005`*^9, 
   3.5676004799593244`*^9, 3.56785943844355*^9, 3.5678605710221395`*^9, 
   3.5678613071104326`*^9, 3.567861520160007*^9, 3.567861619251381*^9, 
   3.5678617160027514`*^9, 3.5678618103205166`*^9, 3.5678620358189125`*^9, 
   3.5678622049232097`*^9, 3.5678625366431923`*^9, 3.5678626836890507`*^9, 
   3.5678627715172048`*^9, 3.567863320513369*^9, 3.567863415143135*^9, 
   3.5678639367768517`*^9, 3.567864088940519*^9, 3.5678642540668087`*^9, 
   3.56786476716731*^9, 3.567865016128147*^9, 3.5678653150402727`*^9, 
   3.567865528824048*^9, 3.5678774540421605`*^9, 3.567911948143292*^9, 
   3.5679130626560497`*^9, 3.567916910253586*^9, 3.5679176766673317`*^9, 
   3.567918361431535*^9, 3.56791861497878*^9, 3.5679194448378377`*^9, 
   3.5679197569163857`*^9, 3.567924258076292*^9, 3.5679261752738595`*^9, 
   3.5679264770719895`*^9, 3.567926861659465*^9, 3.5679294741232543`*^9, 
   3.5679295908738594`*^9, 3.567929672337202*^9, 3.567929856526726*^9, 
   3.5679300835705247`*^9, 3.5679301751114855`*^9, 3.5679303368369694`*^9, 
   3.567930622707472*^9, 3.5679310587438374`*^9, 3.5679312107505045`*^9, 
   3.567931331806717*^9, 3.567931467199355*^9, 3.567931520240448*^9, 
   3.567931626024234*^9, 3.5679319504892035`*^9, 3.5679326318204*^9, 
   3.5679327513946104`*^9, 3.5679331259522686`*^9, 3.567933233155657*^9, 
   3.567933464379263*^9, 3.5679347103856516`*^9, 3.567935972210468*^9, 
   3.568115004818756*^9, 3.568115908638544*^9, 3.568122253360888*^9, 
   3.5681223555410676`*^9, 3.568123412490724*^9, 3.5688951169894123`*^9, 
   3.568895483574456*^9, {3.570354946544612*^9, 3.5703549593054347`*^9}, 
   3.5703573275309944`*^9, 3.5703574467630033`*^9, 3.5703575333899555`*^9, 
   3.5703576112808924`*^9, 3.5703577471737313`*^9, 3.570357805018633*^9, 
   3.5703578503055124`*^9, 3.5703579053580093`*^9, 3.57035794008367*^9, 
   3.5703580040749826`*^9, 3.570358232958585*^9, 3.5703586285440793`*^9, 
   3.570359217243314*^9, 3.5703593078482723`*^9, 3.57035985862284*^9, 
   3.570360128628114*^9, 3.5703609978938413`*^9, 3.5703610771731806`*^9, 
   3.5703612161226244`*^9, 3.5703614883275023`*^9, 3.5703615692448444`*^9, 
   3.570361669865021*^9, 3.5703618789521885`*^9, 3.5703628450160856`*^9, 
   3.5703630120923786`*^9, 3.5703631506050224`*^9, 3.570363239088378*^9, 
   3.5703633000376844`*^9, 3.570363362375394*^9, 3.5703635574693365`*^9, 
   3.5703640867002664`*^9, 3.570364165870405*^9, 3.570364367049359*^9, 
   3.570364473113945*^9, 3.5703645587268953`*^9, 3.5703647245083866`*^9, 
   3.57036486305223*^9, 3.570364934110355*^9, 3.57036504513575*^9, {
   3.570365394467163*^9, 3.5703654041235805`*^9}, 3.5703654636844845`*^9, 
   3.5703657276993484`*^9, 3.570365791799861*^9, {3.5703658556351733`*^9, 
   3.570365874636007*^9}, 3.5703659377381177`*^9, 3.570365989280608*^9, 
   3.5703660970309973`*^9, 3.5703661767627373`*^9, 3.570366233406437*^9, 
   3.57036629774095*^9, 3.570366339798624*^9, 3.570366406644741*^9, 
   3.570366437969596*^9, 3.570366573814635*^9, 3.5703669464212894`*^9, 
   3.5703672462538157`*^9, 3.570367401146488*^9, 3.5703674958542547`*^9, 
   3.5703677611337204`*^9, 3.570367808823004*^9, 3.5703678653575034`*^9, 
   3.5703685582639203`*^9, 3.5703686400860643`*^9, 3.570368783715516*^9, 
   3.570368870779269*^9, 3.5703689312449756`*^9, 3.5704269114525747`*^9, 
   3.5704275282932577`*^9, 3.57042759791718*^9, 3.570427667774103*^9, 
   3.5704277546818557`*^9, 3.5704319413412094`*^9, 3.570432183796835*^9, 
   3.5704330982870417`*^9, 3.5704365147783585`*^9, 3.570438039228636*^9, 
   3.570438171595869*^9, 3.5704382602976246`*^9, 3.5704383519633856`*^9, 
   3.5704385728597736`*^9, 3.5704387567996964`*^9, 3.570438812803795*^9, 
   3.5769885492522545`*^9, 3.5769896649984145`*^9, 3.5769897139201*^9, 
   3.576989756679775*^9, 3.5769897971930466`*^9, 3.5769901346996393`*^9, 
   3.5769903152231565`*^9, 3.576990361804838*^9, 3.57699052792953*^9, 
   3.5769913893440437`*^9, 3.5769916130172367`*^9, 3.5769924515353093`*^9, 
   3.5769928132999444`*^9, 3.576993354995296*^9, 3.576993432059431*^9, 
   3.576993736415966*^9, 3.5769941746841354`*^9, 3.576995106785773*^9, 
   3.576995250540025*^9, 3.5844271628940268`*^9, 3.5844272958218603`*^9, 
   3.5844273976744394`*^9, 3.584427667445713*^9, 3.584427731858226*^9, 
   3.5844280223941364`*^9, 3.58442806435821*^9, 3.5844284683209195`*^9, 
   3.5844285893927326`*^9, 3.584428768778447*^9, 3.5844292430816803`*^9, 
   3.584429324045823*^9, 3.5844293648710947`*^9, 3.584429427146404*^9, 
   3.584429593037095*^9, 3.58442998846759*^9, 3.584431509876862*^9, 
   3.584431982855093*^9, 3.617688621209113*^9, 3.6176886674891777`*^9, 
   3.6176887444192853`*^9, 3.617688814169383*^9, 3.6176888527694373`*^9, 
   3.6176888989935503`*^9, 3.6176893740292635`*^9, 3.6176894159293222`*^9, 
   3.617689529473529*^9, 3.6176896096636415`*^9, 3.617689774433872*^9, 
   3.6628758924897366`*^9, 3.66306047274811*^9, 3.6630605193009033`*^9, 
   3.6630606298865557`*^9, 3.663060703714003*^9, 3.690020733924571*^9, 
   3.690020877474571*^9, 3.690021107194571*^9, 3.690026103342571*^9, 
   3.690026177912571*^9, 3.910340377656355*^9, 3.9103443735432634`*^9, 
   3.959701254143173*^9, 3.9597013405076065`*^9, 3.959701489643446*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"e880ed30-923e-ff47-ac2b-ccce97cf094a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Length"}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"ddd04ef9-fe24-409f-923b-2f961b5cb604"],

Cell[BoxData["17"], "Output",
 CellChangeTimes->{
  3.5201748498524647`*^9, 3.5201755964289665`*^9, 3.5201759689652166`*^9, 
   3.520176096570639*^9, 3.520176270795743*^9, 3.5201767563679914`*^9, 
   3.5201779239636307`*^9, 3.5201779737397156`*^9, 3.520178034253021*^9, 
   3.5201781235217743`*^9, 3.5201783243397217`*^9, 3.5201790106557207`*^9, 
   3.520179111215495*^9, 3.520179193934038*^9, 3.520179238612116*^9, 
   3.5201792851333942`*^9, 3.520179464188905*^9, 3.5201795519958563`*^9, 
   3.5201813605206017`*^9, 3.5201816369274855`*^9, 3.520268562921894*^9, 
   3.520268731275334*^9, 3.520268862901922*^9, 3.5202688999923763`*^9, 
   3.5202690923238482`*^9, 3.5202718145609016`*^9, 3.520310605527149*^9, 
   3.520310986952505*^9, 3.5203117875504355`*^9, 3.5203121052247133`*^9, 
   3.527144937736272*^9, 3.527145808656602*^9, 3.5271460022383423`*^9, 
   3.5271470232621355`*^9, 3.527147594208538*^9, 3.5271480471407337`*^9, 
   3.5271482644491158`*^9, 3.5271486867978606`*^9, 3.527150051177257*^9, 
   3.5271501732786713`*^9, 3.527150353895789*^9, 3.5271505078056593`*^9, 
   3.5271507922409587`*^9, 3.5271508655922875`*^9, 3.5292308241893253`*^9, 
   3.529232467355811*^9, 3.5292325720319953`*^9, 3.5292359097876577`*^9, 
   3.5292362177945986`*^9, 3.52923641747495*^9, 3.5292366548761663`*^9, 
   3.529236716388075*^9, 3.529236967456916*^9, 3.529237057968275*^9, 
   3.5340685703005905`*^9, 3.5340689520644608`*^9, 3.534069383093218*^9, 
   3.5340699522134175`*^9, 3.534070177259413*^9, 3.5342496376713643`*^9, 
   3.5376214991089973`*^9, 3.5376216255628195`*^9, 3.5376228423191566`*^9, {
   3.537622948789344*^9, 3.537622964779372*^9}, 3.537623183304556*^9, 
   3.5376233619092693`*^9, 3.53762544031852*^9, 3.537628790067875*^9, 
   3.537694700279871*^9, 3.5376948681205654`*^9, 3.537695502136879*^9, 
   3.537695581915419*^9, 3.537695913619802*^9, 3.537696395629449*^9, 
   3.5376971054160953`*^9, 3.53769746081592*^9, {3.5376979709680157`*^9, 
   3.537697991622452*^9}, 3.5377005711065874`*^9, 3.537700989109321*^9, 
   3.537701150179604*^9, 3.5377050759606996`*^9, 3.5377676504506893`*^9, 
   3.537780186346308*^9, 3.537780584271807*^9, 3.5377809212957993`*^9, 
   3.5377810802912784`*^9, 3.537781242359963*^9, 3.537781378517002*^9, 
   3.537781527590864*^9, 3.5377817259608126`*^9, 3.537782399414995*^9, 
   3.5377827402755938`*^9, 3.5377829313447294`*^9, 3.5377831921303873`*^9, 
   3.537783440951825*^9, 3.5377835732244573`*^9, 3.5377841082429967`*^9, 
   3.537784245070837*^9, 3.5440922096735616`*^9, 3.5440972417784004`*^9, 
   3.544097365845418*^9, 3.5440979531562495`*^9, 3.5440997545080137`*^9, 
   3.54410337315477*^9, 3.54410346422773*^9, 3.5441037054207535`*^9, 
   3.5441039178463264`*^9, 3.5441040522093625`*^9, 3.5441050999862027`*^9, 
   3.5441057146584826`*^9, 3.5441059494700947`*^9, 3.5441071478183994`*^9, 
   3.5445912536162705`*^9, 3.544591490768835*^9, 3.544591653174124*^9, 
   3.5445929049717226`*^9, 3.544672173520233*^9, 3.544672374923753*^9, 
   3.544673274156186*^9, {3.5446733825253844`*^9, 3.5446734033975782`*^9}, 
   3.5449492192858257`*^9, 3.544951614473035*^9, 3.545015663086934*^9, 
   3.545015724878643*^9, 3.54510614256985*^9, 3.545114020963421*^9, 
   3.552821195921003*^9, 3.552822659968974*^9, 3.552822795938813*^9, 
   3.552822987118149*^9, 3.552823196283316*^9, 3.5528236666397424`*^9, 
   3.552823971605678*^9, 3.5528261170784464`*^9, 3.552826309646185*^9, 
   3.554207271773513*^9, 3.5542084672836123`*^9, 3.5613716977940197`*^9, 
   3.5617325867800083`*^9, 3.5617791987858076`*^9, 3.561781488403829*^9, 
   3.561781562332359*^9, 3.5617816532805185`*^9, 3.561781901586155*^9, 
   3.561781934034212*^9, 3.5617821017823067`*^9, 3.56178219500807*^9, 
   3.56178238844841*^9, 3.561782492921794*^9, 3.561782526118652*^9, 
   3.561784234588853*^9, 3.562766627419752*^9, 3.562766744201557*^9, 
   3.5627670826285515`*^9, 3.562767893503376*^9, 3.5627695461556787`*^9, 
   3.5627696680542927`*^9, {3.562771127953657*^9, 3.5627711474536915`*^9}, 
   3.5627731145401464`*^9, 3.562773202415101*^9, 3.562821272208412*^9, 
   3.562822346162099*^9, 3.5628235980662975`*^9, 3.562823661355609*^9, 
   3.562824062182713*^9, 3.5628245989806557`*^9, 3.5628252437297883`*^9, 
   3.5628253121203084`*^9, 3.562825372164814*^9, 3.5628259596004457`*^9, 
   3.5628261342115526`*^9, 3.562826248294553*^9, 3.562828066108573*^9, 
   3.562828564233048*^9, 3.562828736847351*^9, 3.562828879072801*^9, 
   3.5628304898400307`*^9, 3.562831305487463*^9, 3.5628317002003565`*^9, 
   3.562831820008567*^9, 3.562831852082223*^9, 3.562832308507825*^9, 
   3.562832421935624*^9, 3.562832729583764*^9, 3.5628336702196164`*^9, 
   3.5628337646309824`*^9, 3.5628338352523065`*^9, 3.563425633401393*^9, 
   3.5634263675074825`*^9, 3.563427213950369*^9, 3.563428699760379*^9, 
   3.5634287918317404`*^9, 3.563428870518279*^9, 3.5634296668538775`*^9, 
   3.5641236131336384`*^9, 3.564124346226726*^9, 3.5641248627914333`*^9, 
   3.5641250179815063`*^9, 3.5641304424642344`*^9, 3.564635026642227*^9, 
   3.5646354981842556`*^9, 3.5646721302086906`*^9, 3.5657592881699667`*^9, 
   3.565773667323635*^9, 3.565892024047901*^9, 3.5661948530486293`*^9, 
   3.5662039717114716`*^9, 3.5662119041996665`*^9, 3.566212640995961*^9, 
   3.566214734316838*^9, 3.5663991506781373`*^9, 3.5665437129115205`*^9, 
   3.56708281518173*^9, 3.567185137379181*^9, 3.567586523270301*^9, 
   3.567600479974924*^9, 3.5678594384591503`*^9, 3.5678605710377398`*^9, 
   3.567861307126033*^9, 3.5678615201756067`*^9, 3.567861619266981*^9, 
   3.567861716018351*^9, 3.5678618103205166`*^9, 3.5678620358345127`*^9, 
   3.5678622049388094`*^9, 3.5678625366587925`*^9, 3.567862683720251*^9, 
   3.5678627715328045`*^9, 3.5678633205289693`*^9, 3.5678634151587353`*^9, 
   3.567863936792452*^9, 3.5678640889561186`*^9, 3.567864254082409*^9, 
   3.56786476718291*^9, 3.567865016128147*^9, 3.5678653150558724`*^9, 
   3.5678655288396482`*^9, 3.5678774540577602`*^9, 3.567911948143292*^9, 
   3.56791306267165*^9, 3.567916910269186*^9, 3.567917676682932*^9, 
   3.567918361447135*^9, 3.56791861497878*^9, 3.5679194448534374`*^9, 
   3.5679197569163857`*^9, 3.5679242580918922`*^9, 3.567926175289459*^9, 
   3.5679264770875893`*^9, 3.567926861659465*^9, 3.567929474138854*^9, 
   3.567929590889459*^9, 3.5679296723528023`*^9, 3.567929856542326*^9, 
   3.567930083586125*^9, 3.5679301751270857`*^9, 3.5679303368525696`*^9, 
   3.567930622707472*^9, 3.5679310587594376`*^9, 3.5679312107661047`*^9, 
   3.567931331822317*^9, 3.567931467214955*^9, 3.567931520256048*^9, 
   3.567931626039834*^9, 3.5679319505048037`*^9, 3.5679326318360004`*^9, 
   3.5679327513946104`*^9, 3.5679331259678683`*^9, 3.567933233171257*^9, 
   3.567933464394863*^9, 3.5679347104012513`*^9, 3.5679359722260675`*^9, 
   3.5681150048343563`*^9, 3.5681159086541443`*^9, 3.5681222533764877`*^9, 
   3.5681223555566673`*^9, 3.568123412521924*^9, 3.5688951170050125`*^9, 
   3.5688954835900564`*^9, {3.570354946560212*^9, 3.5703549593054347`*^9}, 
   3.570357327546594*^9, 3.5703574467786036`*^9, 3.5703575333899555`*^9, 
   3.5703576112964926`*^9, 3.570357747189331*^9, 3.570357805034233*^9, 
   3.5703578503211126`*^9, 3.5703579053736095`*^9, 3.57035794008367*^9, 
   3.5703580040749826`*^9, 3.5703582329741845`*^9, 3.5703586285440793`*^9, 
   3.5703592172589135`*^9, 3.5703593078638725`*^9, 3.57035985862284*^9, 
   3.5703601286437144`*^9, 3.570360997909441*^9, 3.5703610771887803`*^9, 
   3.5703612161382246`*^9, 3.5703614883275023`*^9, 3.5703615692604446`*^9, 
   3.5703616698806214`*^9, 3.5703618789677887`*^9, 3.570362845031686*^9, 
   3.570363012107979*^9, 3.570363150620622*^9, 3.5703632391039777`*^9, 
   3.5703633000532846`*^9, 3.570363362390994*^9, 3.5703635574849367`*^9, 
   3.570364086715866*^9, 3.5703641658860054`*^9, 3.5703643670649586`*^9, 
   3.570364473129545*^9, 3.5703645587424955`*^9, 3.570364724523987*^9, 
   3.57036486306783*^9, 3.5703649341259546`*^9, 3.57036504515135*^9, {
   3.5703653944983635`*^9, 3.57036540413918*^9}, 3.5703654637000847`*^9, 
   3.5703657277149487`*^9, 3.570365791815461*^9, {3.570365855650773*^9, 
   3.5703658746516066`*^9}, 3.5703659377537174`*^9, 3.570365989296208*^9, 
   3.5703660970465975`*^9, 3.5703661767783375`*^9, 3.570366233422037*^9, 
   3.57036629775655*^9, 3.570366339814224*^9, 3.570366406644741*^9, 
   3.570366437985196*^9, 3.5703665738302345`*^9, 3.570366946436889*^9, 
   3.570367246269416*^9, 3.570367401146488*^9, 3.5703674958698545`*^9, 
   3.5703677611337204`*^9, 3.570367808838604*^9, 3.570367865373103*^9, 
   3.5703685582795205`*^9, 3.570368640101664*^9, 3.570368783715516*^9, 
   3.570368870779269*^9, 3.5703689312605753`*^9, 3.570426911468175*^9, 
   3.570427528308858*^9, 3.5704275979327803`*^9, 3.5704276677897034`*^9, 
   3.5704277546818557`*^9, 3.570431941356809*^9, 3.570432183812435*^9, 
   3.5704330983026414`*^9, 3.5704365147939587`*^9, 3.570438039244236*^9, 
   3.570438171611469*^9, 3.5704382603132243`*^9, 3.570438351978986*^9, 
   3.570438572875374*^9, 3.5704387568152966`*^9, 3.570438812819395*^9, 
   3.5769885492678547`*^9, 3.5769896650140142`*^9, 3.5769897139357004`*^9, 
   3.5769897566953754`*^9, 3.5769897971930466`*^9, 3.5769901347152395`*^9, 
   3.576990315238756*^9, 3.5769903618204384`*^9, 3.5769905279451303`*^9, 
   3.5769913893596435`*^9, 3.5769916130328364`*^9, 3.576992451550909*^9, 
   3.576992813315544*^9, 3.5769933550108957`*^9, 3.5769934320750313`*^9, 
   3.576993736431566*^9, 3.576994174715336*^9, 3.5769951068013725`*^9, 
   3.5769952505556254`*^9, 3.584427162909627*^9, 3.5844272958374605`*^9, 
   3.584427397690039*^9, 3.5844276674613132`*^9, 3.584427731873826*^9, 
   3.5844280224097366`*^9, 3.58442806435821*^9, 3.5844284683209195`*^9, 
   3.5844285894083323`*^9, 3.5844287687940474`*^9, 3.5844292430816803`*^9, 
   3.584429324045823*^9, 3.5844293648866944`*^9, 3.5844294271620035`*^9, 
   3.584429593037095*^9, 3.5844299884831896`*^9, 3.584431509908062*^9, 
   3.5844319828706927`*^9, 3.617688621209113*^9, 3.617688667499178*^9, 
   3.6176887444192853`*^9, 3.6176888141793833`*^9, 3.617688852779437*^9, 
   3.61768889900355*^9, 3.6176893740392632`*^9, 3.617689415939322*^9, 
   3.617689529483529*^9, 3.617689609673641*^9, 3.617689774443872*^9, 
   3.6628758924997363`*^9, 3.663060472758111*^9, 3.6630605193109035`*^9, 
   3.6630606298965545`*^9, 3.663060703724002*^9, 3.6900207339345713`*^9, 
   3.690020877484571*^9, 3.690021107204571*^9, 3.6900261033525705`*^9, 
   3.6900261779225707`*^9, 3.9103403776743364`*^9, 3.9103443735661726`*^9, 
   3.9597012541471634`*^9, 3.959701340510597*^9, 3.9597014896464386`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"38c92f7c-5c31-c14b-8d53-61ceae378422"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 InitializationCell->True,
 CellLabel->"In[66]:=",ExpressionUUID->"50fb47c1-4d4b-4d80-86ee-19fabf8543c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`ExpressionManipulation`\"\>", 
   ",", "\<\"Utilities`ShowTime`\"\>", ",", "\<\"xAct`SpaceSpinors`\"\>", 
   ",", "\<\"xAct`SymSpin`\"\>", ",", "\<\"xAct`TexAct`\"\>", 
   ",", "\<\"xAct`SymManipulator`\"\>", ",", "\<\"xAct`Spinors`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.6900261033525705`*^9, 3.690026177962571*^9, 
  3.910340377681288*^9, 3.9103443735701623`*^9, 3.959701254152149*^9, 
  3.9597013405415154`*^9, 3.959701489649435*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"40e8f403-98a4-5044-bb1c-3b854af4a8cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\"\<xAct`ExpressionManipulation`\>\"", ",", "\"\<Utilities`ShowTime`\>\"", 
   ",", "\"\<xAct`SpaceSpinors`\>\"", ",", "\"\<xAct`TexAct`\>\"", ",", 
   "\"\<xAct`SymManipulator`\>\"", ",", "\"\<xAct`Spinors`\>\"", ",", 
   "\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", ",", 
   "\"\<xAct`xCore`\>\"", ",", "\"\<System`\>\""}], "}"}]], "Input",
 CellChangeTimes->{{3.690025831230571*^9, 3.690025831230571*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"3dea724f-e060-42d8-83da-ce3996042e39"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`ExpressionManipulation`\"\>", 
   ",", "\<\"Utilities`ShowTime`\"\>", ",", "\<\"xAct`SpaceSpinors`\"\>", 
   ",", "\<\"xAct`TexAct`\"\>", ",", "\<\"xAct`SymManipulator`\"\>", 
   ",", "\<\"xAct`Spinors`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.690026103362571*^9, 3.690026177972571*^9, 
  3.910340377698278*^9, 3.910344373575178*^9, 3.9597012541800747`*^9, 
  3.9597013405684433`*^9, 3.9597014896763325`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"225ccf90-47f1-6d4f-9f49-38b0e0c4f6ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[68]:=",ExpressionUUID->"0fd981bf-a288-4f1a-8235-97a4d77ca3e6"],

Cell[BoxData["\<\"xAct`SpaceSpinors`Private`\"\>"], "Output",
 CellChangeTimes->{3.690026103372571*^9, 3.690026177972571*^9, 
  3.910340377719216*^9, 3.9103443735971184`*^9, 3.959701254202017*^9, 
  3.9597013405744267`*^9, 3.959701489679352*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"933a09b6-afc5-3341-b5fc-531599fea960"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\"\<xAct`SpaceSpinors`Private`\>\""], "Input",
 CellChangeTimes->{{3.690025831240571*^9, 3.690025831240571*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"3b1f9659-9a02-4847-b32d-d18e174476a8"],

Cell[BoxData["\<\"xAct`SpaceSpinors`Private`\"\>"], "Output",
 CellChangeTimes->{3.690026103372571*^9, 3.6900261779825706`*^9, 
  3.910340377726192*^9, 3.9103443737108164`*^9, 3.9597012542050076`*^9, 
  3.959701340605345*^9, 3.95970148968334*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"c2a8dba9-9d05-4544-9eed-80a36528f5f7"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Development of some tools", "Subsection",
 CellChangeTimes->{{3.5703536834717937`*^9, 3.5703536884170027`*^9}, 
   3.5703540316030054`*^9, {3.570354071211475*^9, 3.570354074799481*^9}, {
   3.5703542672726192`*^9, 3.570354274152231*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"64e78e7b-0ff7-46a9-b500-6b1c5b9f54a7"],

Cell[CellGroupData[{

Cell["2.1. Development of some tools", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.570354046235831*^9, 
  3.570354067015067*^9}},ExpressionUUID->"187de461-ac77-4df8-8902-\
ecb779ff40ee"],

Cell["A simpler version of MakeRule", "Text",
 CellChangeTimes->{{3.5704318840267086`*^9, 
  3.570431900827938*^9}},ExpressionUUID->"bb1b6867-dad0-43b4-93a0-\
af18a5b6b36e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FormatDirRule", "[", 
    RowBox[{"Dir", "[", 
     RowBox[{"v_", "[", "index_", "]"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Dir", "[", 
     RowBox[{"v", "[", "index", "]"}], "]"}], "\[Rule]", " ", 
    RowBox[{"Dir", "[", 
     RowBox[{"v", "[", 
      RowBox[{"xAct`xTensor`Private`pattern", "[", 
       RowBox[{"index", ",", "_"}], "]"}], "]"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5704377358237033`*^9, 3.5704377813289833`*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"0add4b4f-4ec0-4b11-b467-1d99629463fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MakeSimpleRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"LHS_", ",", "RHS_", ",", "conditions___"}], "}"}], ",", 
    "options___"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"HeldLHS", "=", 
       RowBox[{"Hold", "[", "LHS", "]"}]}], ",", 
      RowBox[{"HeldRHS", "=", 
       RowBox[{"Hold", "[", "RHS", "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Unblocked", " ", "indices"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"indsLHS", "=", 
         RowBox[{"List", "@@", 
          RowBox[{"xAct`xTensor`Private`TakeEIndices", "[", 
           RowBox[{"FindIndices", "[", "HeldLHS", "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"freesLHS", "=", 
         RowBox[{"List", "@@", 
          RowBox[{"xAct`xTensor`Private`TakeEIndices", "[", 
           RowBox[{"FindFreeIndices", "[", "HeldLHS", "]"}], "]"}]}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"dirinds", "=", 
         RowBox[{"List", "@@", 
          RowBox[{"Select", "[", 
           RowBox[{
            RowBox[{"FindIndices", "[", "HeldLHS", "]"}], ",", "DIndexQ"}], 
           "]"}]}]}], ",", "\[IndentingNewLine]", "verb", ",", 
        "\[IndentingNewLine]", "indsLHSinfo", ",", "\[IndentingNewLine]", 
        "rulesLHS", ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"newHeldLHS", "=", 
           RowBox[{
           "xAct`xTensor`Private`ReplaceIsolated", "[", "HeldLHS", "]"}]}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"newHeldRHS", "=", 
           RowBox[{"ReplaceDummies", "[", "HeldRHS", "]"}]}], ","}], "*)"}], 
        "\[IndentingNewLine]", "rules", ",", "conds"}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Options", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", "verb", "}"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"{", "Verbose", "}"}], "/.", 
          RowBox[{"CheckOptions", "[", "options", "]"}]}], "/.", 
         RowBox[{"Options", "[", "MakeRule", "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"**", 
         RowBox[{"*", " ", 
          RowBox[{"B", ".", " ", "Construct"}], " ", "indsLHSinfo"}]}], " ", 
        "****)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "0.", " ", "Convert", " ", "LHS", " ", "inds", " ", "to", " ", 
         "names"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"indsLHS", "=", 
        RowBox[{"xAct`xTensor`Private`IndexName", "/@", "indsLHS"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"freesLHS", "=", 
        RowBox[{"xAct`xTensor`Private`IndexName", "/@", "freesLHS"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "1.", " ", "Name", " ", "of", " ", "index", " ", "in", " ", "input", 
         " ", "rule"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"indsLHSinfo", "=", 
        RowBox[{"Partition", "[", 
         RowBox[{"indsLHS", ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"2.", " ", "Free", " ", "character"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"indsLHSinfo", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{"#", ",", 
            RowBox[{"MemberQ", "[", 
             RowBox[{"freesLHS", ",", 
              RowBox[{"First", "@", "#"}]}], "]"}]}], "]"}], "&"}], "/@", 
         "indsLHSinfo"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"3.", " ", 
         RowBox[{
          RowBox[{"MetricOn", ".", " ", "up"}], "/", "down"}], " ", 
         "character", " ", "is", " ", "corrected"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"indsLHSinfo", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{"#", ",", 
            RowBox[{"MetricEndowedQ", "@", 
             RowBox[{"VBundleOfIndex", "@", 
              RowBox[{"First", "@", "#"}]}]}]}], "]"}], "&"}], "/@", 
         "indsLHSinfo"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"4.", " ", "TestIndices"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"indsLHSinfo", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{"#", ",", "True"}], "]"}], "&"}], "/@", "indsLHSinfo"}]}], 
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "5.", " ", "Pattern", " ", "character", " ", "in", " ", "final", " ", 
         
         RowBox[{
          RowBox[{"rule", ".", " ", "up"}], "/", "down"}], " ", "character", 
         " ", "in", " ", "patindsLHS", " ", "is", " ", "corrected"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"indsLHSinfo", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{"#", ",", "True"}], "]"}], "&"}], "/@", "indsLHSinfo"}]}], 
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"6.", " ", "Name", " ", "in", " ", "final", " ", 
         RowBox[{"rule", ".", " ", "Currently"}], " ", "we", " ", "do", " ", 
         "not", " ", "change", " ", "names"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"indsLHSinfo", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Append", "[", 
           RowBox[{"#", ",", 
            RowBox[{"First", "@", "#"}]}], "]"}], "&"}], "/@", 
         "indsLHSinfo"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<indsLHSinfo: \>\"", ",", "indsLHSinfo"}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<dirinds:\>\"", ",", " ", "dirinds"}], "]"}]}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "7.", " ", "Final", " ", "rules", " ", "for", " ", "LHS", " ", 
         "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"rulesLHS", "=", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
            "xAct`xTensor`Private`FormatIndexRule", "/@", "indsLHSinfo"}], 
            ")"}], ",", 
           RowBox[{"FormatDirRule", "/@", "dirinds"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "xAct`xTensor`Private`patternTest", "\[Rule]", "PatternTest"}], 
           ",", 
           RowBox[{"xAct`xTensor`Private`pattern", "\[Rule]", "Pattern"}]}], 
          "}"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<rulesLHS: \>\"", ",", "rulesLHS"}], "]"}]}], "]"}], 
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"**", 
         RowBox[{"*", " ", 
          RowBox[{"C", ".", " ", "Construct"}], " ", "rules"}]}], " ", 
        "****)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"3.", " ", "Construct", " ", "rules"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"rules", "=", 
        RowBox[{"{", 
         RowBox[{"Rule", "[", 
          RowBox[{"HeldLHS", ",", "HeldRHS"}], "]"}], "}"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<rules: \>\"", ",", 
           RowBox[{"InputForm", "[", "rules", "]"}]}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"4.", " ", "Replace", " ", "indices"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"rules", "=", 
        RowBox[{"rules", "/.", 
         RowBox[{
          RowBox[{"Rule", "[", 
           RowBox[{"lhs_Hold", ",", "rhs_Hold"}], "]"}], "\[RuleDelayed]", 
          RowBox[{"Rule", "[", 
           RowBox[{
            RowBox[{"ReplaceIndex", "[", 
             RowBox[{"lhs", ",", "rulesLHS"}], "]"}], ",", "rhs"}], 
           "]"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<rules after pattern: \>\"", ",", "rules"}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "5.", " ", "Add", " ", "Module", " ", "on", " ", "the", " ", "RHS"}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"rules", "=", 
        RowBox[{"rules", "/.", 
         RowBox[{"Rule", "\[Rule]", "IndexRule"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"6.", " ", "Add", " ", "conditions"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"conds", "=", 
        RowBox[{"Hold", "[", "conditions", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"verb", ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Conditions: \>\"", ",", "conds"}], "]"}]}], "]"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"rules", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"xAct`xTensor`Private`addconditions", "[", 
             RowBox[{"#", ",", "conds"}], "]"}], "&"}], "/@", "rules"}], 
          ")"}], "/.", 
         RowBox[{
          RowBox[{"Hold", "[", "cond_", "]"}], "\[Rule]", "cond"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"7.", " ", "Return", " ", "rules"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"ScreenDollarIndices", "@", "rules"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.5704281997194376`*^9, 3.5704282529935308`*^9}, {
   3.570428301993217*^9, 3.5704284048597975`*^9}, {3.5704284473230724`*^9, 
   3.570428469833912*^9}, {3.570428533138823*^9, 3.570428545182044*^9}, {
   3.5704286756138735`*^9, 3.570428714520342*^9}, {3.5704287514144063`*^9, 
   3.5704288057337017`*^9}, {3.5704289045754757`*^9, 
   3.5704289089434834`*^9}, {3.570428955025964*^9, 3.570429013697667*^9}, {
   3.57042907232257*^9, 3.5704290739761724`*^9}, {3.570429127016266*^9, 
   3.5704291705559425`*^9}, {3.5704295438655987`*^9, 
   3.5704296043625045`*^9}, {3.570429689881855*^9, 3.5704296908022566`*^9}, {
   3.5704298912782087`*^9, 3.5704299124786453`*^9}, 3.5704300465452814`*^9, {
   3.570430176056709*^9, 3.570430191859536*^9}, {3.570430287472104*^9, 
   3.570430288189706*^9}, 3.5704306814195967`*^9, {3.570430728609679*^9, 
   3.570430741198901*^9}, {3.5704307752537613`*^9, 3.5704307811661716`*^9}, {
   3.5704308741111345`*^9, 3.5704309028307853`*^9}, {3.5704309724225073`*^9, 
   3.570431042857631*^9}, {3.570431128252181*^9, 3.5704311309353857`*^9}, {
   3.5704311883746867`*^9, 3.5704311892170887`*^9}, {3.5704312856408577`*^9, 
   3.5704312997120824`*^9}, {3.570431366277399*^9, 3.5704313830006285`*^9}, {
   3.570431465852374*^9, 3.5704315429789095`*^9}, {3.570431579233373*^9, 
   3.5704316063618207`*^9}, {3.5704316591523137`*^9, 3.570431695812378*^9}, {
   3.5704317323944426`*^9, 3.5704317503344736`*^9}, {3.5704318556970587`*^9, 
   3.57043185660186*^9}, {3.5704330646065826`*^9, 3.570433087242222*^9}, {
   3.570436497509128*^9, 3.57043650427954*^9}, {3.57043789353998*^9, 
   3.570438003722974*^9}, {3.5704381593488474`*^9, 3.570438162562453*^9}, {
   3.5704382233567595`*^9, 3.57043825206081*^9}, {3.570438325022138*^9, 
   3.5704383377049603`*^9}, {3.570438544623724*^9, 3.5704385599741507`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"1bbbd1f1-72d7-4323-b40e-48a1502af355"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Definition of space spinor structure", "Subsection",
 CellChangeTimes->{{3.5703536834717937`*^9, 3.5703536884170027`*^9}, 
   3.5703540316030054`*^9, {3.570354071211475*^9, 3.570354074799481*^9}, {
   3.5703542672726192`*^9, 3.5703543005474777`*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"4a8fdd46-59dc-4b2e-ab2e-6683dae74efa"],

Cell[CellGroupData[{

Cell["3.1. Definition", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.570354046235831*^9, 3.570354067015067*^9}, {
  3.5703543996388516`*^9, 
  3.570354406721264*^9}},ExpressionUUID->"6b6f1aa1-90af-4c0d-b473-\
afc2fc9510f4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SenToSpinCovDRules", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpinCovDToSenRules", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DirToSpinCovDRules", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpaceSpinors`Private`CommuteSpinCovD", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$ExtrinsicKScalingConv", "=", "1"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$AccelerationScalingConv", "=", "1"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.570360935462531*^9, 3.570360938036536*^9}, {
   3.5703662769773135`*^9, 3.5703662798321185`*^9}, {3.5703670118166037`*^9, 
   3.5703670204434195`*^9}, {3.663060587353788*^9, 3.663060599491724*^9}, 
   3.690025831320571*^9, {3.910339115587186*^9, 3.910339129683505*^9}, {
   3.910339379643633*^9, 3.910339388041192*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"e3f38bf9-e139-4221-92f2-40dee50af90a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SenCovDQ", "[", "_", "]"}], ":=", "False"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.957368851553726*^9, 3.9573688603382397`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"44efa703-f8d0-984e-8f46-3d68e3a6cfec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<Acc\>\"", ",", "Nn"}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<ExtrK\>\"", ",", "Nn"}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<\[CapitalOmega]4\>\"", ",", "Nn"}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<\[CapitalOmega]0\>\"", ",", "Nn"}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<Dir\>\"", ",", "Nn", ",", "\"\<Op\>\""}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<Hat\>\"", ",", "Nn", ",", "\"\<Op\>\""}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<SpatialPhi4\>\"", ",", "Nn"}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<SpatialPhi2\>\"", ",", "Nn"}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<SpatialPhi0\>\"", ",", "Nn"}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<R4\>\"", ",", "Nn"}], "]"}], ",", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"\"\<R0\>\"", ",", "Nn"}], "]"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5844308313692703`*^9, 3.584430861992124*^9}, {
   3.5844309538918858`*^9, 3.5844309629399014`*^9}, {3.910343452006386*^9, 
   3.9103434702957296`*^9}, {3.956739438382387*^9, 3.9567394566286087`*^9}, {
   3.956742892948118*^9, 3.9567428952410297`*^9}, {3.9567429500923576`*^9, 
   3.956742956196045*^9}, {3.95736122111598*^9, 3.9573612232135735`*^9}, {
   3.9573613150325127`*^9, 3.9573613417413273`*^9}, 3.9573615124168606`*^9, {
   3.957405324804556*^9, 3.9574053278121223`*^9}, {3.9585707054957237`*^9, 
   3.9585707612402363`*^9}, {3.9596018156079655`*^9, 3.959601816551441*^9}, {
   3.9596571825553284`*^9, 3.9596572134706383`*^9}, {3.9596575114897957`*^9, 
   3.959657513291931*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"b402dbcc-782a-4e00-b580-9206b8aaae92"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpaceSpinorsDefaultSymbols", "[", "Nn_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"\"\<A\>\"", ",", "\"\<K\>\"", ",", "\"\<\[CapitalOmega]\>\"", ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"OverlayBox", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<\[CapitalOmega]\>\"", ",", "\"\</\>\""}], "}"}], "]"}], 
      "}"}], "]"}], ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"UnderscriptBox", "[", 
       RowBox[{"\"\<R\>\"", ",", "\"\<_\>\""}], "]"}], "}"}], "]"}], ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"UnderscriptBox", "[", 
       RowBox[{
        RowBox[{"OverlayBox", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<R\>\"", ",", "\"\</\>\""}], "}"}], "]"}], ",", 
        "\"\<_\>\""}], "]"}], "}"}], "]"}]}], "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5844309639071035`*^9, 3.5844309696323133`*^9}, {
   3.5844310051067753`*^9, 3.584431009459183*^9}, {3.95673942025922*^9, 
   3.9567394238655777`*^9}, {3.9567402493868504`*^9, 3.956740254954975*^9}, {
   3.956742964106884*^9, 3.9567429719879017`*^9}, 3.959601999686594*^9, {
   3.9596573968832626`*^9, 3.9596575420101986`*^9}, {3.959659190089905*^9, 
   3.959659193172657*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"e5d923ff-bbf0-4050-be2f-599545d01409"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefSpaceSpinStructure", "[", 
    RowBox[{
    "sigma_", ",", "metrich_", ",", "t_", ",", "spatialsigma_", ",", " ", 
     "Dd_", ",", "nb_"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tbundle", "=", 
        RowBox[{"TangentBundleOfSolderingForm", "[", "sigma", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"sbundle", "=", 
        RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"metric", "=", 
        RowBox[{"First", "@", 
         RowBox[{"InducedFrom", "@", "metrich"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Nn", "=", 
        RowBox[{"Last", "@", 
         RowBox[{"InducedFrom", "@", "metrich"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"eps", "=", 
        RowBox[{"SpinMetricOfSolderingForm", "[", "sigma", "]"}]}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Mfd", "=", 
          RowBox[{"ManifoldOfCovD", "@", 
           RowBox[{"CovDOfMetric", "@", "metric"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Accname", "=", 
          RowBox[{
           RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"ExtrKname", "=", 
          RowBox[{
           RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"DirNnOpname", "=", 
          RowBox[{
           RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"HatNnOpname", "=", 
          RowBox[{
           RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"SpatialPhi4name", "=", 
          RowBox[{
           RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"SpatialPhi2name", "=", 
          RowBox[{
           RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"SpatialPhi0name", "=", 
          RowBox[{
           RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "9", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"hatboxname", "=", 
          RowBox[{"SymbolJoin", "[", 
           RowBox[{"\"\<HatBox\>\"", ",", 
            RowBox[{"Evaluate", "@", 
             RowBox[{"CovDOfMetric", "@", "eps"}]}], ",", "Nn"}], "]"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"a", "=", 
          RowBox[{"First", "@", 
           RowBox[{"First", "@", 
            RowBox[{"IndicesOfVBundle", "@", "tbundle"}]}]}]}], ",", 
         RowBox[{"b", "=", 
          RowBox[{"First", "@", 
           RowBox[{"Rest", "@", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", "tbundle"}]}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"A", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", "sbundle"}]}], ")"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"B", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", "sbundle"}]}], ")"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"C", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", "sbundle"}]}], ")"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"D", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", "sbundle"}]}], ")"}], "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Adg", "=", 
          RowBox[{"First", "@", 
           RowBox[{"First", "@", 
            RowBox[{"IndicesOfVBundle", "@", 
             RowBox[{"Dagger", "@", "sbundle"}]}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Bdg", "=", 
          RowBox[{"First", "@", 
           RowBox[{"Rest", "@", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", 
              RowBox[{"Dagger", "@", "sbundle"}]}]}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"CD", "=", 
          RowBox[{"CovDOfMetric", "@", "eps"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"normsqr", "=", 
           RowBox[{"Scalar", "[", 
            RowBox[{
             RowBox[{"Nn", "[", "a", "]"}], 
             RowBox[{"Nn", "[", 
              RowBox[{"-", "a"}], "]"}]}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Defining", " ", "the", " ", "tensor", " ", "version", " ", "of", 
           " ", "the", " ", "normal", " ", "and", " ", 
           RowBox[{"it", "'"}], "s", " ", 
           RowBox[{"contractions", "."}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"DefSpinorOfTensor", "[", 
           RowBox[{
            RowBox[{"t", "[", 
             RowBox[{"A", ",", "Adg"}], "]"}], ",", 
            RowBox[{"Nn", "[", "a", "]"}], ",", "sigma", ",", 
            RowBox[{"PrintAs", "\[Rule]", 
             RowBox[{"PrintAs", "[", "Nn", "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SpinorOfNormal", "[", "Nn", "]"}], "^=", "t"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"AutomaticRules", "[", 
           RowBox[{"t", ",", 
            RowBox[{"MakeRule", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"A", ",", "Adg"}], "]"}], 
                 RowBox[{"t", "[", 
                  RowBox[{
                   RowBox[{"-", "A"}], ",", 
                   RowBox[{"-", "Adg"}]}], "]"}]}], ",", "normsqr"}], "}"}], 
              ",", 
              RowBox[{"MetricOn", "\[Rule]", "All"}], ",", " ", 
              RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AutomaticRules", "[", 
           RowBox[{"t", ",", 
            RowBox[{"MakeRule", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{
                   RowBox[{"-", "A"}], ",", " ", "Adg"}], "]"}], "*", 
                 RowBox[{"t", "[", 
                  RowBox[{
                   RowBox[{"-", "B"}], ",", " ", 
                   RowBox[{"-", "Adg"}]}], "]"}]}], ",", " ", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"normsqr", "*", 
                    RowBox[{"eps", "[", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", " ", 
                    RowBox[{"-", "B"}]}], "]"}]}], ")"}]}], "/", "2"}]}], 
               "}"}], ",", 
              RowBox[{"MetricOn", "\[Rule]", "All"}], ",", " ", 
              RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AutomaticRules", "[", 
           RowBox[{"t", ",", 
            RowBox[{"MakeRule", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{
                   RowBox[{"-", "A"}], ",", 
                   RowBox[{"-", "Bdg"}]}], "]"}], "*", 
                 RowBox[{"t", "[", 
                  RowBox[{"A", ",", 
                   RowBox[{"-", "Adg"}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"normsqr", "*", 
                    RowBox[{
                    RowBox[{"Dagger", "[", "eps", "]"}], "[", 
                    RowBox[{
                    RowBox[{"-", "Adg"}], ",", 
                    RowBox[{"-", "Bdg"}]}], "]"}]}], ")"}]}], "/", "2"}]}], 
               "}"}], ",", 
              RowBox[{"MetricOn", "\[Rule]", "All"}], ",", " ", 
              RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Definition", " ", "of", " ", "the", " ", "index"}], "-", 
            
            RowBox[{"free", " ", "hat", " ", "operator"}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xTensorQ", "[", 
            RowBox[{"HatNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^=", "True"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SlotsOfTensor", "[", 
            RowBox[{"HatNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"SlotsOfTensor", "[", "AA", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SymmetryGroupOfTensor", "[", 
            RowBox[{"HatNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"SymmetryGroupOfTensor", "[", "AA", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"PrintAs", "[", 
            RowBox[{"HatNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"OverscriptBox", "[", 
            RowBox[{
             RowBox[{"PrintAs", "[", "AA", "]"}], ",", "\"\<^\>\""}], "]"}]}],
           ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Tex", "[", 
            RowBox[{"HatNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"\"\<\\\\widehat{\>\"", "<>", 
            RowBox[{"Tex", "[", "AA", "]"}], "<>", "\"\<}\>\""}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"PrintAs", "[", 
            RowBox[{"HatNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"s", "=", 
                RowBox[{
                 RowBox[{"First", "[", 
                  RowBox[{"Rasterize", "[", 
                   RowBox[{"AA", ",", "\"\<RasterSize\>\""}], "]"}], "]"}], 
                 "/", "2"}]}], ",", 
               RowBox[{"tt", "=", 
                RowBox[{"0.6", "*", 
                 RowBox[{"First", "[", 
                  RowBox[{"Rasterize", "[", 
                   RowBox[{"\"\<^\>\"", ",", "\"\<RasterSize\>\""}], "]"}], 
                  "]"}]}]}]}], "}"}], ",", 
             RowBox[{"With", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"sl", "=", 
                 RowBox[{"N", "[", 
                  RowBox[{"2", " ", 
                   RowBox[{"Log", "[", 
                    RowBox[{"2", " ", "s"}], "]"}]}], "]"}]}], "}"}], ",", 
               RowBox[{"OverscriptBox", "[", 
                RowBox[{
                 RowBox[{"PrintAs", "[", "AA", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"s", "<=", "tt"}], ",", "\"\<^\>\"", ",", 
                   RowBox[{"TagBox", "[", 
                    RowBox[{
                    RowBox[{"GraphicsBox", "[", 
                    RowBox[{
                    RowBox[{"LineBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "s"}], ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "sl"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"s", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
                    RowBox[{"ImageSize", "->", 
                    RowBox[{"{", 
                    RowBox[{"s", ",", "Automatic"}], "}"}]}]}], "]"}], ",", 
                    "\"\<LongOverHat\>\"", ",", 
                    RowBox[{"Selectable", "->", "False"}]}], "]"}]}], "]"}]}],
                 "]"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"HatNnOpOfNormal", "[", "Nn", "]"}], "^=", "HatNnOpname"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"HatNnOpname", "[", 
            RowBox[{"expr_TensorPlus", ",", "z___"}], "]"}], ":=", 
           RowBox[{
            RowBox[{
             RowBox[{"HatNnOpname", "[", 
              RowBox[{"#", ",", "z"}], "]"}], "&"}], "/@", "expr"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"HatNnOpname", "[", 
            RowBox[{
             RowBox[{"ZeroTensor", "[", "vbs_", "]"}], ",", "z___"}], "]"}], ":=", 
           RowBox[{"ZeroTensorOfTensor", "@", 
            RowBox[{"HatNnOpname", "[", 
             RowBox[{
              RowBox[{"DummyTensor", "[", 
               RowBox[{"vbs", ",", 
                RowBox[{"CompatibleSymmetric", "[", "vbs", "]"}]}], "]"}], 
              ",", "z"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"HatNnOpname", "[", 
            RowBox[{
             RowBox[{"MultScal", "[", 
              RowBox[{"c_", ",", 
               RowBox[{"TT_", "?", "xTensorQ"}]}], "]"}], ",", "z___"}], 
            "]"}], ":=", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"Dagger", "[", "c", "]"}], ",", 
             RowBox[{"HatNnOpname", "[", 
              RowBox[{"TT", ",", "z"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"SymbolJoin", "[", 
             RowBox[{"HatNnOpname", ",", "\"\<Rule\>\""}], "]"}], "]"}], "=", 
           
           RowBox[{
            RowBox[{"HatNnOpname", "[", 
             RowBox[{"\[Phi]_", "?", 
              RowBox[{"(", 
               RowBox[{
               "SymmetricSpinorOfArbitraryValenceQ", "[", "sbundle", "]"}], 
               ")"}]}], "]"}], ":>", 
            RowBox[{
             RowBox[{"With", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"k", "=", 
                 RowBox[{
                  RowBox[{"NumOfUnprimedSlots", "[", "sbundle", "]"}], "[", 
                  "\[Phi]", "]"}]}], "}"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{"Power", "[", 
                  RowBox[{
                   RowBox[{"2", "/", "normsqr"}], " ", ",", 
                   RowBox[{"k", "/", "2"}]}], "]"}], ",", 
                 RowBox[{"Nest", "[", 
                  RowBox[{
                   RowBox[{"SymMult", "[", 
                    RowBox[{"t", ",", "0", ",", "1", ",", "sbundle"}], "]"}], 
                   ",", 
                   RowBox[{"Dagger", "[", "\[Phi]", "]"}], ",", "k"}], 
                  "]"}]}], "]"}]}], "]"}], "/;", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "sbundle", "]"}], "@", 
                "\[Phi]"}], "===", "0"}], ")"}]}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"SymbolJoin", "[", 
             RowBox[{"HatNnOpname", ",", "\"\<Valence0Rule\>\""}], "]"}], 
            "]"}], "=", 
           RowBox[{
            RowBox[{"HatNnOpname", "[", 
             RowBox[{"\[Phi]_", "?", 
              RowBox[{"(", 
               RowBox[{
               "SymmetricSpinorOfArbitraryValenceQ", "[", "sbundle", "]"}], 
               ")"}]}], "]"}], ":>", 
            RowBox[{
             RowBox[{"Dagger", "[", "\[Phi]", "]"}], "/;", 
             RowBox[{"And", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "sbundle", "]"}], "@", 
                 "\[Phi]"}], "===", "0"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "sbundle", "]"}], "@", 
                 "\[Phi]"}], "===", "0"}]}], "]"}]}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"SymbolJoin", "[", 
             RowBox[{"HatNnOpname", ",", "HatNnOpname", ",", "\"\<Rule\>\""}],
              "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"HatNnOpname", "[", 
             RowBox[{"HatNnOpname", "[", 
              RowBox[{"\[Phi]_", "?", 
               RowBox[{"(", 
                RowBox[{
                "SymmetricSpinorOfArbitraryValenceQ", "[", "sbundle", "]"}], 
                ")"}]}], "]"}], "]"}], ":>", 
            RowBox[{
             RowBox[{"With", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"k", "=", 
                 RowBox[{
                  RowBox[{"NumOfUnprimedSlots", "[", "sbundle", "]"}], "[", 
                  "\[Phi]", "]"}]}], "}"}], ",", 
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", "k"}], ",", "\[Phi]"}], 
                "]"}]}], "]"}], "/;", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "sbundle", "]"}], "@", 
                "\[Phi]"}], "===", "0"}], ")"}]}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"HatNnOpname", "[", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"T1_", ",", "i_", ",", "0", ",", "sbundle"}], "]"}], 
             "[", "T2_", "]"}], "]"}], "^:=", 
           RowBox[{
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{
               RowBox[{"HatNnOpname", "[", "T1", "]"}], ",", "i", ",", "0", 
               ",", "sbundle"}], "]"}], "[", 
             RowBox[{"HatNnOpname", "[", "T2", "]"}], "]"}], "/;", 
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "sbundle", "]"}], "[", "T1",
                  "]"}], "===", "0"}], ")"}], ",", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "sbundle", "]"}], "[", "T2",
                  "]"}], "===", "0"}], ")"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Defining", " ", "the", " ", "spatial", " ", "soldering", " ", 
            "form"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"DefSpinor", "[", 
           RowBox[{
            RowBox[{"spatialsigma", "[", 
             RowBox[{
              RowBox[{"-", "a"}], ",", "A", ",", "B"}], "]"}], ",", "Mfd", 
            ",", 
            RowBox[{"Symmetric", "[", 
             RowBox[{"{", 
              RowBox[{"A", ",", "B"}], "}"}], "]"}], ",", 
            RowBox[{"OrthogonalTo", "\[Rule]", " ", 
             RowBox[{"{", 
              RowBox[{"Nn", "[", "a", "]"}], "}"}]}], ",", " ", 
            RowBox[{"ProjectedWith", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"metrich", "[", 
               RowBox[{"a", ",", 
                RowBox[{"-", "b"}]}], "]"}], "}"}]}], ",", 
            RowBox[{"PrintAs", "\[Rule]", 
             RowBox[{"PrintAs", "[", "sigma", "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SpatialSFToSF", "[", "Nn", "]"}], "^=", 
           RowBox[{
            RowBox[{"spatialsigma", "[", 
             RowBox[{
              RowBox[{"-", "a"}], ",", "A", ",", "B"}], "]"}], "\[Equal]", 
            RowBox[{"Symmetrize", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma", "[", 
                RowBox[{
                 RowBox[{"-", "a"}], ",", "A", ",", 
                 RowBox[{"-", "Adg"}]}], "]"}], 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"B", ",", "Adg"}], "]"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"normsqr", "/", "2"}], "]"}]}]}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "B"}], "}"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SFToSpatialSF", "[", "Nn", "]"}], "^=", 
           RowBox[{
            RowBox[{"sigma", "[", 
             RowBox[{
              RowBox[{"-", "a"}], ",", "A", ",", "Adg"}], "]"}], "\[Equal]", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Nn", "[", 
                 RowBox[{"-", "a"}], "]"}], "*", 
                RowBox[{"t", "[", 
                 RowBox[{"A", ",", "Adg"}], "]"}]}], ")"}], "/", "normsqr"}], 
             "-", 
             RowBox[{
              RowBox[{"spatialsigma", "[", 
               RowBox[{
                RowBox[{"-", "a"}], ",", "A", ",", 
                RowBox[{"-", "B"}]}], "]"}], "*", 
              RowBox[{"t", "[", 
               RowBox[{"B", ",", "Adg"}], "]"}], "*", 
              RowBox[{
               RowBox[{"Sqrt", "[", "2", "]"}], "/", 
               RowBox[{"Sqrt", "@", "normsqr"}]}]}]}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "HatBox", " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CovDQ", "[", "hatboxname", "]"}], "^=", "True"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"xAct`xTensor`Private`MakeLinearDerivative", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"hatboxname", "[", "A__", "]"}], ",", 
              RowBox[{"hatboxname", "[", "A", "]"}]}], "}"}], ",", "True"}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SymmetryGroupOfCovD", "[", "hatboxname", "]"}], "^=", 
           RowBox[{"StrongGenSet", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", " ", "2"}], "}"}], ",", 
             RowBox[{"GenSet", "[", 
              RowBox[{"Cycles", "@", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ManifoldOfCovD", "[", "hatboxname", "]"}], "^=", 
           RowBox[{"ManifoldOfCovD", "[", "CD", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"VBundlesOfCovD", "[", "hatboxname", "]"}], "^=", 
           RowBox[{"VBundlesOfCovD", "[", "CD", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SymbolOfCovD", "[", "hatboxname", "]"}], "^=", 
           RowBox[{"{", 
            RowBox[{
            "\"\<?\>\"", ",", 
             "\"\<\!\(\*OverscriptBox[\(\[EmptySquare]\), \(^\)]\)\>\""}], 
            "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"SymbolJoin", "[", 
             RowBox[{"hatboxname", ",", "\"\<ToBox\>\"", ",", 
              RowBox[{"Evaluate", "@", 
               RowBox[{"CovDOfMetric", "@", "eps"}]}]}], "]"}], "]"}], "=", 
           RowBox[{"MakeSimpleRule", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"hatboxname", "[", 
                RowBox[{"A", ",", "B"}], "]"}], "@", "L_"}], ",", 
              RowBox[{
               RowBox[{"2", "/", 
                RowBox[{"Scalar", "[", 
                 RowBox[{
                  RowBox[{"Nn", "[", "a", "]"}], 
                  RowBox[{"Nn", "[", 
                   RowBox[{"-", "a"}], "]"}]}], "]"}]}], "*", 
               RowBox[{"t", "[", 
                RowBox[{"A", ",", "Adg"}], "]"}], 
               RowBox[{"t", "[", 
                RowBox[{"B", ",", "Bdg"}], "]"}], 
               RowBox[{
                RowBox[{
                 RowBox[{"SymbolJoin", "[", 
                  RowBox[{"\"\<Box\>\"", ",", 
                   RowBox[{"Evaluate", "@", 
                    RowBox[{"CovDOfMetric", "@", "eps"}]}]}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"-", "Adg"}], ",", 
                  RowBox[{"-", "Bdg"}]}], "]"}], "@", "L"}]}]}], "}"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Definition", " ", "of", " ", "Acceleration", " ", "and", " ", 
            "Extrinsic", " ", "curvature"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"DefSpinor", "[", 
           RowBox[{
            RowBox[{"Accname", "[", 
             RowBox[{
              RowBox[{"-", "A"}], ",", 
              RowBox[{"-", "B"}]}], "]"}], ",", "Mfd", ",", 
            RowBox[{"Symmetric", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"PrintAs", "\[Rule]", 
             RowBox[{
              RowBox[{"SpaceSpinorsDefaultSymbols", "[", "Nn", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"AccNameOfNormal", "[", "Nn", "]"}], "^=", "Accname"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"HatNnOpname", "[", "Accname", "]"}], "^=", 
           RowBox[{"MultScal", "[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "Accname"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"SymbolJoin", "[", 
             RowBox[{"Accname", ",", "\"\<Def\>\""}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"Accname", "[", 
             RowBox[{
              RowBox[{"-", "A"}], ",", 
              RowBox[{"-", "B"}]}], "]"}], "\[Equal]", 
            RowBox[{
             RowBox[{
              RowBox[{"Acceleration", "[", "Nn", "]"}], "[", "a", "]"}], "*", 
             "$AccelerationScalingConv", "*", 
             RowBox[{"spatialsigma", "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "B"}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"SymbolJoin", "[", 
             RowBox[{"Accname", ",", "\"\<To\>\"", ",", " ", "CD", ",", "t"}],
              "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"Accname", "[", 
             RowBox[{
              RowBox[{"-", "A"}], ",", 
              RowBox[{"-", "B"}]}], "]"}], "\[Equal]", 
            RowBox[{
             RowBox[{"Sqrt", "[", "2", "]"}], "*", 
             RowBox[{"$AccelerationScalingConv", "/", 
              RowBox[{
               RowBox[{"(", "normsqr", ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"3", "/", "2"}], ")"}]}]}], "*", 
             RowBox[{"Symmetrize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{
                  RowBox[{"-", "A"}], ",", "Adg"}], "]"}], "*", 
                RowBox[{
                 RowBox[{"CD", "[", 
                  RowBox[{"Dir", "[", 
                   RowBox[{"Nn", "[", "a", "]"}], "]"}], "]"}], "[", 
                 RowBox[{"t", "[", 
                  RowBox[{
                   RowBox[{"-", "B"}], ",", 
                   RowBox[{"-", "Adg"}]}], "]"}], "]"}]}], ",", 
               RowBox[{"IndexList", "[", 
                RowBox[{
                 RowBox[{"-", "A"}], ",", 
                 RowBox[{"-", "B"}]}], "]"}]}], "]"}]}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "We", " ", "assume", " ", "that", " ", "the", " ", "normal", " ", 
            "is", " ", "hypersurface", " ", 
            RowBox[{"orthogonal", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"DefSpinor", "[", 
           RowBox[{
            RowBox[{"ExtrKname", "[", 
             RowBox[{
              RowBox[{"-", "A"}], ",", 
              RowBox[{"-", "B"}], ",", 
              RowBox[{"-", "C"}], ",", 
              RowBox[{"-", "D"}]}], "]"}], ",", "Mfd", ",", 
            RowBox[{"StrongGenSet", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
              RowBox[{"GenSet", "[", 
               RowBox[{
                RowBox[{"Cycles", "[", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
                RowBox[{"Cycles", "[", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
                RowBox[{"Cycles", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"1", ",", "3"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}], 
            ",", 
            RowBox[{"PrintAs", "\[Rule]", 
             RowBox[{
              RowBox[{"SpaceSpinorsDefaultSymbols", "[", "Nn", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ExtrKNameOfNormal", "[", "Nn", "]"}], "^=", "ExtrKname"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"SymbolJoin", "[", 
             RowBox[{"ExtrKname", ",", "\"\<Def\>\""}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"ExtrKname", "[", 
             RowBox[{
              RowBox[{"-", "A"}], ",", 
              RowBox[{"-", "B"}], ",", 
              RowBox[{"-", "C"}], ",", 
              RowBox[{"-", "D"}]}], "]"}], "\[Equal]", 
            RowBox[{
             RowBox[{
              RowBox[{"ExtrinsicK", "[", "metrich", "]"}], "[", 
              RowBox[{
               RowBox[{"-", "a"}], ",", 
               RowBox[{"-", "b"}]}], "]"}], 
             RowBox[{"spatialsigma", "[", 
              RowBox[{"a", ",", 
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "B"}]}], "]"}], 
             RowBox[{"spatialsigma", "[", 
              RowBox[{"b", ",", 
               RowBox[{"-", "C"}], ",", 
               RowBox[{"-", "D"}]}], "]"}], "*", 
             "$ExtrinsicKScalingConv"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"SymbolJoin", "[", 
             RowBox[{"CD", ",", "t", ",", "\"\<Eq\>\""}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"CD", "[", 
              RowBox[{
               RowBox[{"-", "A"}], ",", 
               RowBox[{"-", "Adg"}]}], "]"}], "[", 
             RowBox[{"t", "[", 
              RowBox[{
               RowBox[{"-", "B"}], ",", 
               RowBox[{"-", "Bdg"}]}], "]"}], "]"}], "\[Equal]", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Sqrt", "[", "2", "]"}], "*", 
                  RowBox[{
                  "$AccelerationSign", "/", "$AccelerationScalingConv"}], "*", 
                  RowBox[{"Accname", "[", 
                   RowBox[{
                    RowBox[{"-", "B"}], ",", 
                    RowBox[{"-", "C"}]}], "]"}], "*", 
                  RowBox[{"t", "[", 
                   RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "Adg"}]}], "]"}], "*", 
                  RowBox[{"t", "[", 
                   RowBox[{"C", ",", 
                    RowBox[{"-", "Bdg"}]}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", "*", 
                RowBox[{"$ExtrinsicKSign", "/", "$ExtrinsicKScalingConv"}], 
                "*", 
                RowBox[{"ExtrKname", "[", 
                 RowBox[{
                  RowBox[{"-", "A"}], ",", 
                  RowBox[{"-", "C"}], ",", 
                  RowBox[{"-", "B"}], ",", 
                  RowBox[{"-", "D"}]}], "]"}], "*", 
                RowBox[{"t", "[", 
                 RowBox[{"C", ",", 
                  RowBox[{"-", "Adg"}]}], "]"}], "*", 
                RowBox[{"t", "[", 
                 RowBox[{"D", ",", 
                  RowBox[{"-", "Bdg"}]}], "]"}]}], ")"}], "/", 
              RowBox[{"(", "normsqr", ")"}]}]}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Defining", " ", "the", " ", "Sen", " ", "connection"}], 
           " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"DefSenConnection", "[", 
           RowBox[{"Dd", ",", "eps", ",", 
            RowBox[{"CovDOfMetric", "@", "eps"}], ",", "t", ",", "Nn", ",", 
            "sigma", ",", 
            RowBox[{"{", 
             RowBox[{
             "A", ",", "B", ",", "C", ",", "D", ",", "Adg", ",", "Bdg", ",", 
              "a"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Normal", " ", "derivative", " ", "in", " ", "operator", " ", 
            "form"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"DirOpNameOfNormal", "[", "Nn", "]"}], "^=", 
           "DirNnOpname"}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xTensorQ", "[", 
            RowBox[{"DirNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^=", "True"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SlotsOfTensor", "[", 
            RowBox[{"DirNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"SlotsOfTensor", "[", "AA", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SymmetryGroupOfTensor", "[", 
            RowBox[{"DirNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"SymmetryGroupOfTensor", "[", "AA", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"PrintAs", "[", 
            RowBox[{"DirNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"RowBox", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"SubscriptBox", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SymbolOfCovD", "[", "CD", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{"PrintAs", "[", "Nn", "]"}]}], "]"}], ",", 
              RowBox[{"PrintAs", "[", "AA", "]"}]}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Tex", "[", 
            RowBox[{"DirNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{
            RowBox[{
             RowBox[{"xAct`TexAct`Private`TexCovD", "[", "CD", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<_{\>\"", "<>", 
            RowBox[{"Tex", "[", "Nn", "]"}], "<>", "\"\<}\>\"", "<>", 
            RowBox[{"Tex", "[", "AA", "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Dagger", "[", 
            RowBox[{"DirNnOpname", "[", 
             RowBox[{"AA_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"DirNnOpname", "[", 
            RowBox[{"Dagger", "@", "AA"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"SetLinearOperatorRules", "[", "DirNnOpname", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Spatial", " ", "parts", " ", "of", " ", "the", " ", "tracefree", 
            " ", "Ricci"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"DefSymmetricSpinor", "[", 
           RowBox[{
           "SpatialPhi4name", ",", "4", ",", "0", ",", "sbundle", ",", 
            "\"\<\!\(\*UnderscriptBox[\(\[CapitalPhi]\), \(4\)]\)\>\""}], 
           "]"}], ";", " ", "\[IndentingNewLine]", 
          RowBox[{"DefSymmetricSpinor", "[", 
           RowBox[{
           "SpatialPhi2name", ",", "2", ",", "0", ",", "sbundle", ",", 
            "\"\<\!\(\*UnderscriptBox[\(\[CapitalPhi]\), \(2\)]\)\>\""}], 
           "]"}], ";", " ", "\[IndentingNewLine]", 
          RowBox[{"DefSymmetricSpinor", "[", 
           RowBox[{
           "SpatialPhi0name", ",", "0", ",", "0", ",", "sbundle", ",", 
            "\"\<\!\(\*UnderscriptBox[\(\[CapitalPhi]\), \(0\)]\)\>\""}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SpatialPhinamesOfNormal", "[", "Nn", "]"}], "^=", 
           RowBox[{"{", 
            RowBox[{
            "SpatialPhi4name", ",", "SpatialPhi2name", ",", 
             "SpatialPhi0name"}], "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "One", " ", "commutator", " ", "that", " ", "does", " ", "not", 
            " ", "need", " ", "fundamental", " ", "spinor", " ", 
            RowBox[{"operators", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"CommuteOp", "[", 
            RowBox[{"HatNnOpname", ",", "DirNnOpname"}], "]"}], "^=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"HatNnOpname", "[", 
              RowBox[{"DirNnOpname", "[", "\[Phi]_", "]"}], "]"}], ":>", 
             RowBox[{
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"k", "=", 
                  RowBox[{
                   RowBox[{"NumOfUnprimedSlots", "[", "sbundle", "]"}], "@", 
                   "\[Phi]"}]}], "}"}], ",", 
                RowBox[{"TensorPlus", "[", 
                 RowBox[{
                  RowBox[{"DirNnOpname", "[", 
                   RowBox[{"HatNnOpname", "[", "\[Phi]", "]"}], "]"}], ",", 
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "*", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "*", "k"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "1", ",", "0", ",", "sbundle"}], 
                    "]"}], "[", 
                    RowBox[{"HatNnOpname", "[", "\[Phi]", "]"}], "]"}]}], 
                   "]"}]}], "]"}]}], "]"}], "/;", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"NumOfPrimedSlots", "[", "sbundle", "]"}], "[", 
                 "\[Phi]", "]"}], "===", "0"}], ")"}]}]}], "}"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SymMultLeibnizRules", "[", "DirNnOpname", "]"}], "^=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"DirNnOpname", "[", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]_", ",", "m_", ",", "0", ",", "sbundle"}], 
                "]"}], "[", "\[Psi]_", "]"}], "]"}], ":>", 
             RowBox[{"TensorPlus", "[", 
              RowBox[{
               RowBox[{"MultScal", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", "m"}], ",", 
                 RowBox[{
                  RowBox[{"SymMult", "[", 
                   RowBox[{"\[Psi]", ",", "m", ",", "0", ",", "sbundle"}], 
                   "]"}], "[", 
                  RowBox[{"DirNnOpname", "[", "\[Phi]", "]"}], "]"}]}], "]"}],
                ",", 
               RowBox[{
                RowBox[{"SymMult", "[", 
                 RowBox[{"\[Phi]", ",", "m", ",", "0", ",", "sbundle"}], 
                 "]"}], "[", 
                RowBox[{"DirNnOpname", "[", "\[Psi]", "]"}], "]"}]}], "]"}]}],
             "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Defining", " ", "the", " ", "Intrinsic", " ", "connection"}], " ",
            "*)"}], "\[IndentingNewLine]", 
          RowBox[{"DefIntrinsicConnection", "[", 
           RowBox[{"nb", ",", "eps", ",", 
            RowBox[{"CovDOfMetric", "@", "eps"}], ",", "t", ",", "Nn", ",", 
            "sigma", ",", 
            RowBox[{"{", 
             RowBox[{"A", ",", "B", ",", "Adg", ",", "Bdg", ",", "a"}], 
             "}"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}],
     "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.570354408328067*^9, 3.5703544184212847`*^9}, {
   3.570354517169458*^9, 3.5703545174190583`*^9}, {3.5703545571523285`*^9, 
   3.5703545737351575`*^9}, {3.57035578223908*^9, 3.5703558137511353`*^9}, {
   3.570355874341642*^9, 3.5703560195310965`*^9}, 3.570356098248835*^9, {
   3.570356139058507*^9, 3.570356212129035*^9}, {3.570356246012295*^9, 
   3.570356247229097*^9}, {3.5703562915487747`*^9, 3.570356339097658*^9}, {
   3.57035643113782*^9, 3.5703564413870378`*^9}, {3.5703565313679957`*^9, 
   3.570356614063741*^9}, {3.5703566678526354`*^9, 3.5703566707854404`*^9}, {
   3.5703568769710026`*^9, 3.5703568785466056`*^9}, {3.570357053376113*^9, 
   3.5703570571825194`*^9}, {3.5703571613283024`*^9, 
   3.5703572020131736`*^9}, {3.570357253524464*^9, 3.570357282618515*^9}, {
   3.5703573696052685`*^9, 3.5703573999005213`*^9}, {3.5703574318337774`*^9, 
   3.570357434298582*^9}, {3.570357500598698*^9, 3.570357522610337*^9}, {
   3.570357574340028*^9, 3.570357629564125*^9}, {3.5703576605613794`*^9, 
   3.570357668408193*^9}, {3.570357786127*^9, 3.5703577935838127`*^9}, {
   3.5703578272330723`*^9, 3.5703578869187765`*^9}, 3.5703579303960533`*^9, {
   3.57035797415413*^9, 3.570357994730566*^9}, {3.570358039658645*^9, 
   3.57035808252752*^9}, {3.5703581989037247`*^9, 3.570358220587763*^9}, {
   3.570358330209155*^9, 3.570358394808869*^9}, {3.570358757571906*^9, 
   3.570358769786728*^9}, {3.5703589541946516`*^9, 3.570358992071518*^9}, {
   3.5703590710232563`*^9, 3.5703591761684413`*^9}, {3.5703592554009805`*^9, 
   3.5703592754314156`*^9}, {3.570359493878599*^9, 3.5703595034882164`*^9}, {
   3.570359643404862*^9, 3.570359660206092*^9}, {3.570359759266266*^9, 
   3.5703598256599817`*^9}, {3.570359912505335*^9, 3.5703599447661915`*^9}, 
   3.5703607392131867`*^9, {3.5703608066833053`*^9, 3.5703608297089453`*^9}, {
   3.5703614614798555`*^9, 3.5703614616826553`*^9}, {3.570362993731147*^9, 
   3.5703629974439535`*^9}, {3.570365451563264*^9, 3.5703654518440638`*^9}, {
   3.5703656187487574`*^9, 3.570365636345588*^9}, {3.570366935048869*^9, 
   3.5703669362968717`*^9}, {3.5703682481821756`*^9, 3.570368249149378*^9}, {
   3.5703687551050663`*^9, 3.570368768255889*^9}, {3.570368846739627*^9, 
   3.570368847862829*^9}, 3.5703689222593594`*^9, {3.5769889357585335`*^9, 
   3.576988954244566*^9}, {3.576988997519042*^9, 3.576989052087938*^9}, {
   3.576989236698662*^9, 3.5769892613467054`*^9}, {3.5769893074603863`*^9, 
   3.576989363043284*^9}, {3.5769894323230057`*^9, 3.576989459312053*^9}, {
   3.576989501198127*^9, 3.576989518607757*^9}, {3.5769896777904367`*^9, 
   3.576989681097643*^9}, {3.576989741438549*^9, 3.5769897430141516`*^9}, {
   3.576989785945427*^9, 3.5769897868034286`*^9}, {3.5769902803414955`*^9, 
   3.576990290762314*^9}, {3.576990341181602*^9, 3.5769903416184025`*^9}, {
   3.5769903810240717`*^9, 3.576990388402885*^9}, {3.576990491425466*^9, 
   3.576990492642268*^9}, {3.5769911423020096`*^9, 3.576991226900958*^9}, {
   3.5769913151503134`*^9, 3.57699137045241*^9}, {3.576991568291958*^9, 
   3.5769915726911654`*^9}, {3.576992322366082*^9, 3.5769923424589176`*^9}, {
   3.576992373908573*^9, 3.5769924089150343`*^9}, 3.5769926271916175`*^9, 
   3.5769927918187065`*^9, {3.5769932928447866`*^9, 3.5769933213304367`*^9}, {
   3.576993402263379*^9, 3.5769934111553946`*^9}, 3.5769936311469812`*^9, {
   3.57699370451391*^9, 3.576993708429517*^9}, {3.5769939973898244`*^9, 
   3.576994024518272*^9}, {3.5769940794303684`*^9, 3.5769941014108067`*^9}, {
   3.5769950298464375`*^9, 3.5769950906865444`*^9}, {3.5769951453178406`*^9, 
   3.5769952061891475`*^9}, {3.584431065900082*^9, 3.5844311172709723`*^9}, {
   3.617689755653846*^9, 3.6176897561738462`*^9}, {3.6176923584383907`*^9, 
   3.617692403918454*^9}, {3.6176924347684975`*^9, 3.6176924380885024`*^9}, {
   3.6176927268429546`*^9, 3.617692799053056*^9}, {3.640875876521248*^9, 
   3.640875878112282*^9}, {3.640876186798544*^9, 3.640876200209948*^9}, {
   3.663061762538474*^9, 3.6630618988821115`*^9}, {3.6630623948516407`*^9, 
   3.663062408071905*^9}, {3.6630624468726816`*^9, 3.663062479953343*^9}, {
   3.663062612907096*^9, 3.6630626227673917`*^9}, {3.690018132072571*^9, 
   3.690018212412571*^9}, {3.690018255452571*^9, 3.690018395742571*^9}, {
   3.6900185866925707`*^9, 3.690018607332571*^9}, {3.690018644102571*^9, 
   3.690018732349491*^9}, {3.690021068154571*^9, 3.6900210730345707`*^9}, {
   3.6900215453545713`*^9, 3.690021546014571*^9}, {3.6900224806845713`*^9, 
   3.690022516334571*^9}, {3.690027326742128*^9, 3.6900273276621003`*^9}, {
   3.6938139641556406`*^9, 3.693813965755643*^9}, 3.69381401358671*^9, {
   3.9103392088142166`*^9, 3.9103392407322125`*^9}, {3.9103392729592733`*^9, 
   3.910339292384344*^9}, {3.910339448995571*^9, 3.910339458779441*^9}, {
   3.9103394957644143`*^9, 3.910339516907869*^9}, {3.9103406633555665`*^9, 
   3.910340681249735*^9}, {3.9103429523224854`*^9, 3.910343004940427*^9}, {
   3.910343458681569*^9, 3.910343460846754*^9}, {3.9103435367700872`*^9, 
   3.91034358777798*^9}, 3.9103436619644527`*^9, {3.9103436981306353`*^9, 
   3.9103437429057937`*^9}, {3.910343858228812*^9, 3.9103438955954742`*^9}, {
   3.9103450129540772`*^9, 3.9103450290747046`*^9}, {3.9103467757797318`*^9, 
   3.9103467842441053`*^9}, {3.910346894317238*^9, 3.9103469132271624`*^9}, {
   3.910346994149001*^9, 3.9103470089395075`*^9}, {3.9103488409112797`*^9, 
   3.910348863777601*^9}, {3.9567410850683174`*^9, 3.9567411122707253`*^9}, {
   3.957361361485649*^9, 3.9573613813714886`*^9}, 3.9573614624593678`*^9, {
   3.9573615063799477`*^9, 3.957361507717449*^9}, {3.957361569390045*^9, 
   3.957361571684908*^9}, {3.9573616239900513`*^9, 3.957361676186285*^9}, {
   3.9573617517834682`*^9, 3.9573617986414814`*^9}, {3.957361836214037*^9, 
   3.957361836386652*^9}, {3.9573618825713387`*^9, 3.957361904697384*^9}, {
   3.9573619514304504`*^9, 3.9573619888456955`*^9}, 3.9573620355840816`*^9, {
   3.9573621248310146`*^9, 3.957362157675207*^9}, {3.957362758302046*^9, 
   3.9573628041272736`*^9}, {3.957402969915943*^9, 3.9574031085735455`*^9}, {
   3.957403144307045*^9, 3.9574031808263874`*^9}, {3.957405343039448*^9, 
   3.9574053487098827`*^9}, {3.9574054005011406`*^9, 3.957405569769266*^9}, {
   3.9574056126316776`*^9, 3.957405740809368*^9}, {3.957405813352892*^9, 
   3.9574059238089676`*^9}, {3.957405984992628*^9, 3.957406040577032*^9}, {
   3.9574068539375305`*^9, 3.9574069110269127`*^9}, {3.9574069451905785`*^9, 
   3.9574070495741234`*^9}, {3.958559060394369*^9, 3.9585590818568287`*^9}, {
   3.9585591170351124`*^9, 3.958559135562187*^9}, {3.9585595683274307`*^9, 
   3.9585596059970818`*^9}, {3.958560043555231*^9, 3.9585600449328117`*^9}, {
   3.9585601062028503`*^9, 3.9585601206173115`*^9}, 3.95856109450062*^9, {
   3.958561703647991*^9, 3.9585617333181267`*^9}, {3.958571164012398*^9, 
   3.958571273638445*^9}, {3.958575694797886*^9, 3.9585757043127213`*^9}, {
   3.958699151377615*^9, 3.95869915455023*^9}, {3.958699204663023*^9, 
   3.9586992710352917`*^9}, {3.9596018424622154`*^9, 
   3.9596018581143513`*^9}, {3.9596020362300415`*^9, 
   3.9596020372802334`*^9}, {3.959604301067951*^9, 3.9596043474107895`*^9}, {
   3.9596046629225864`*^9, 3.959604690979233*^9}, {3.959605191700636*^9, 
   3.959605209603754*^9}, {3.959605256772871*^9, 3.9596052914197025`*^9}, {
   3.9597010019656296`*^9, 3.9597010259207115`*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"a9186706-8c35-437d-b160-0236c62c35e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefSenConnection", "[", 
    RowBox[{
    "Dd_", ",", "eps_", ",", "CD_", ",", "t_", ",", "Nn_", ",", "sigma_", ",", 
     RowBox[{"{", 
      RowBox[{
      "A_", ",", "B_", ",", "C_", ",", "D_", ",", "Adg_", ",", "Bdg_", ",", 
       "a_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"normsqr", "=", 
        RowBox[{"Scalar", "[", 
         RowBox[{
          RowBox[{"Nn", "[", "a", "]"}], 
          RowBox[{"Nn", "[", 
           RowBox[{"-", "a"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"epsdg", "=", 
        RowBox[{"Dagger", "[", "eps", "]"}]}], ",", 
       RowBox[{"boxcd", "=", 
        RowBox[{"SymbolJoin", "[", 
         RowBox[{"\"\<Box\>\"", ",", "CD"}], "]"}]}], ",", 
       RowBox[{"tbundle", "=", 
        RowBox[{"TangentBundleOfSolderingForm", "[", "sigma", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"sbundle", "=", 
        RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}], ",", 
       RowBox[{"boxDd", "=", 
        RowBox[{"SymbolJoin", "[", 
         RowBox[{"\"\<Box\>\"", ",", "Dd"}], "]"}]}], ",", 
       RowBox[{"F", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"First", "@", 
           RowBox[{"IndicesOfVBundle", "@", 
            RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}]}], ")"}], 
         "[", 
         RowBox[{"[", "5", "]"}], "]"}]}], ",", 
       RowBox[{"H", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"First", "@", 
           RowBox[{"IndicesOfVBundle", "@", 
            RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}]}], ")"}], 
         "[", 
         RowBox[{"[", "6", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Mfd", "=", 
        RowBox[{"ManifoldOfCovD", "[", "CD", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Omega4name", "=", 
        RowBox[{
         RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Omega0name", "=", 
        RowBox[{
         RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"DirOpname", "=", 
        RowBox[{"Evaluate", "[", 
         RowBox[{"DirOpNameOfNormal", "[", "Nn", "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ExtrKname", "=", 
        RowBox[{"Evaluate", "[", 
         RowBox[{"ExtrKNameOfNormal", "[", "Nn", "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"HatNnOpname", "=", 
        RowBox[{
         RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
         RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"CovDQ", "[", "Dd", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SpinCovDQ", "[", "Dd", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SenCovDQ", "[", "Dd", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"NormalOfCovD", "[", "Dd", "]"}], "^=", "Nn"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SenCovDOfNormalSpinor", "[", "t", "]"}], "^=", "Dd"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ParentCovD", "[", "Dd", "]"}], "^=", "CD"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`MakeLinearDerivative", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Dd", "[", 
             TagBox[
              StyleBox[
               RowBox[{"xAct`xTensor`Private`pattern", "[", 
                RowBox[{"A", ",", 
                 RowBox[{"BlankSequence", "[", "]"}]}], "]"}],
               ShowSpecialCharacters->False,
               ShowStringCharacters->True,
               NumberMarks->True],
              FullForm], "]"}], ",", 
            RowBox[{"Dd", "[", "A", "]"}]}], "}"}], "/.", 
          RowBox[{"xAct`xTensor`Private`pattern", "\[Rule]", "Pattern"}]}], 
         "]"}], ",", "True"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"TorsionQ", "[", "Dd", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SpatialSpinCovDQ", "[", "Dd", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SymmetryGroupOfCovD", "[", "Dd", "]"}], "^=", 
       RowBox[{"StrongGenSet", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", 
         RowBox[{"GenSet", "[", 
          RowBox[{"Cycles", "@", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ManifoldOfCovD", "[", "Dd", "]"}], "^=", 
       RowBox[{"ManifoldOfCovD", "[", "CD", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"VBundlesOfCovD", "[", "Dd", "]"}], "^=", 
       RowBox[{"{", 
        RowBox[{"tbundle", ",", "sbundle"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SymbolOfCovD", "[", "Dd", "]"}], "^=", 
       RowBox[{"{", 
        RowBox[{"\"\<?\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SlotsOfCovD", "[", "Dd", "]"}], "^=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "sbundle"}], ",", 
         RowBox[{"-", "sbundle"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"eps", "/:", 
       RowBox[{
        RowBox[{"Dd", "[", "__", "]"}], "@", 
        RowBox[{"eps", "[", "__", "]"}]}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"epsdg", "/:", 
       RowBox[{
        RowBox[{"Dd", "[", "__", "]"}], "@", 
        RowBox[{"epsdg", "[", "__", "]"}]}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DefSpinor", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{"SymbolJoin", "[", 
           RowBox[{"\"\<TorsionNormal\>\"", ",", "Dd"}], "]"}], "]"}], "[", 
         RowBox[{
          RowBox[{"-", "A"}], ",", 
          RowBox[{"-", "B"}], ",", 
          RowBox[{"-", "C"}], ",", 
          RowBox[{"-", "D"}]}], "]"}], ",", 
        RowBox[{"ManifoldOfCovD", "[", "CD", "]"}], ",", 
        RowBox[{"GenSet", "[", 
         RowBox[{
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"Cycles", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}]}], "]"}], ",", 
        RowBox[{
        "PrintAs", "\[Rule]", 
         "\"\<\!\(\*SubscriptBox[\(\[Omega]\), \(N\)]\)\>\""}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DefSpinor", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{"SymbolJoin", "[", 
           RowBox[{"\"\<TorsionSpatial\>\"", ",", "Dd"}], "]"}], "]"}], "[", 
         RowBox[{
          RowBox[{"-", "A"}], ",", 
          RowBox[{"-", "B"}], ",", 
          RowBox[{"-", "C"}], ",", 
          RowBox[{"-", "D"}], ",", "F", ",", "H"}], "]"}], ",", 
        RowBox[{"ManifoldOfCovD", "[", "CD", "]"}], ",", 
        RowBox[{"GenSet", "[", 
         RowBox[{
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
          RowBox[{"Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"5", ",", "6"}], "}"}], "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"Cycles", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}]}], "]"}], ",", 
        RowBox[{
        "PrintAs", "\[Rule]", 
         "\"\<\!\(\*SubscriptBox[\(\[Omega]\), \(S\)]\)\>\""}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DefSpatialBox", "[", "Dd", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Add", " ", "the", " ", "slashed", " ", "package", " ", "to", " ", 
        "Latex", " ", "packages"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"$TexInitLatexPackages", ",", "\"\<{slashed}\>\""}], "]"}], 
        ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"$TexInitLatexPackages", ",", "\"\<{slashed}\>\""}], "]"}]}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Define", " ", "irreducible", " ", "parts", " ", "of", " ", 
        "extrinsic", " ", "curvature"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"DefSymmetricSpinor", "[", 
       RowBox[{"Omega4name", ",", "4", ",", "0", ",", "sbundle", ",", 
        RowBox[{
         RowBox[{"SpaceSpinorsDefaultSymbols", "[", "Nn", "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"DefSymmetricSpinor", "[", 
       RowBox[{"Omega0name", ",", "0", ",", "0", ",", "sbundle", ",", 
        RowBox[{
         RowBox[{"SpaceSpinorsDefaultSymbols", "[", "Nn", "]"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}]}], "]"}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tex", "[", "Omega4name", "]"}], "^=", 
       RowBox[{"Tex", "[", "Omega4name", "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"Tex", "[", "Omega0name", "]"}], "^=", 
       RowBox[{"Tex", "[", "Omega0name", "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"Omega4NameOfCovD", "[", "Dd", "]"}], "^=", "Omega4name"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Omega0NameOfCovD", "[", "Dd", "]"}], "^=", "Omega0name"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"HatNnOpname", "[", "Omega4name", "]"}], "^=", "Omega4name"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"HatNnOpname", "[", "Omega0name", "]"}], "^=", "Omega0name"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Dagger", "[", "Omega0name", "]"}], "^=", "Omega0name"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{"SymbolJoin", "[", 
         RowBox[{"\"\<IrrDec\>\"", ",", "ExtrKname", ",", "\"\<Eq\>\""}], 
         "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"ExtrKname", "[", 
         RowBox[{
          RowBox[{"-", "A"}], ",", 
          RowBox[{"-", "B"}], ",", 
          RowBox[{"-", "C"}], ",", 
          RowBox[{"-", "D"}]}], "]"}], "==", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "/", "6"}], " ", 
          RowBox[{"eps", "[", 
           RowBox[{
            RowBox[{"-", "A"}], ",", 
            RowBox[{"-", "D"}]}], "]"}], " ", 
          RowBox[{"eps", "[", 
           RowBox[{
            RowBox[{"-", "B"}], ",", 
            RowBox[{"-", "C"}]}], "]"}], " ", 
          RowBox[{"Omega0name", "[", "]"}]}], "+", 
         RowBox[{
          RowBox[{"1", "/", "6"}], " ", 
          RowBox[{"eps", "[", 
           RowBox[{
            RowBox[{"-", "A"}], ",", 
            RowBox[{"-", "C"}]}], "]"}], " ", 
          RowBox[{"eps", "[", 
           RowBox[{
            RowBox[{"-", "B"}], ",", 
            RowBox[{"-", "D"}]}], "]"}], " ", 
          RowBox[{"Omega0name", "[", "]"}]}], "+", 
         RowBox[{"Omega4name", "[", 
          RowBox[{
           RowBox[{"-", "A"}], ",", 
           RowBox[{"-", "B"}], ",", 
           RowBox[{"-", "C"}], ",", 
           RowBox[{"-", "D"}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Transforming", " ", "between", " ", "4", "D", " ", "and", " ", "3", 
        "D", " ", "derivatives"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"SenToSpinCovDRules", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"SenToSpinCovDRules", ",", 
         RowBox[{"MakeSimpleRule", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Dd", "[", 
              RowBox[{"A", ",", "B"}], "]"}], "@", "expr_"}], ",", " ", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"normsqr", "*", "2"}], "]"}]}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"B", ",", "Adg"}], "]"}], 
                RowBox[{
                 RowBox[{"CD", "[", 
                  RowBox[{"A", ",", 
                   RowBox[{"-", "Adg"}]}], "]"}], "@", "expr"}]}], "+", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"A", ",", "Adg"}], "]"}], 
                RowBox[{
                 RowBox[{"CD", "[", 
                  RowBox[{"B", ",", 
                   RowBox[{"-", "Adg"}]}], "]"}], "@", "expr"}]}]}], 
              ")"}]}]}], "}"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"SpinCovDToSenRules", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"SpinCovDToSenRules", ",", 
         RowBox[{"MakeSimpleRule", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"CD", "[", 
              RowBox[{"A", ",", "Adg"}], "]"}], "@", "expr_"}], ",", " ", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"A", ",", "Adg"}], "]"}], "*", 
                RowBox[{
                 RowBox[{"CD", "[", 
                  RowBox[{"Dir", "@", 
                   RowBox[{"Nn", "[", "a", "]"}]}], "]"}], "[", "expr", 
                 "]"}]}], ")"}], "/", "normsqr"}], "-", 
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"B", ",", "Adg"}], "]"}], "*", 
              RowBox[{
               RowBox[{"Dd", "[", 
                RowBox[{
                 RowBox[{"-", "B"}], ",", "A"}], "]"}], "[", "expr", "]"}], 
              "*", 
              RowBox[{
               RowBox[{"Sqrt", "[", "2", "]"}], "/", 
               RowBox[{"Sqrt", "[", "normsqr", "]"}]}]}]}]}], "}"}], "]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DirToSpinCovDRules", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"DirToSpinCovDRules", ",", 
         RowBox[{"MakeSimpleRule", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"CD", "[", 
              RowBox[{"Dir", "[", 
               RowBox[{"Nn", "[", "a", "]"}], "]"}], "]"}], "@", "expr_"}], 
            ",", 
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"A", ",", "Adg"}], "]"}], "*", 
             RowBox[{
              RowBox[{"CD", "[", 
               RowBox[{
                RowBox[{"-", "A"}], ",", 
                RowBox[{"-", "Adg"}]}], "]"}], "[", "expr", "]"}]}]}], "}"}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Commutation", " ", "rule", " ", "for", " ", "the", " ", "Sen", " ", 
        "connection", " ", "Dd"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{"SymbolJoin", "[", 
         RowBox[{"\"\<Commute\>\"", ",", "Dd", ",", "Dd", ",", "boxDd"}], 
         "]"}], "]"}], "=", 
       RowBox[{"MakeSimpleRule", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Dd", "[", 
            RowBox[{"A", ",", " ", "B"}], "]"}], "[", 
           RowBox[{
            RowBox[{"Dd", "[", 
             RowBox[{"C", ",", " ", "D"}], "]"}], "[", "expr_", "]"}], "]"}], 
          ",", "  ", "\n", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"eps", "[", 
               RowBox[{"B", ",", " ", "D"}], "]"}], "*", 
              RowBox[{
               RowBox[{"boxDd", "[", 
                RowBox[{"A", ",", " ", "C"}], "]"}], "[", "expr", "]"}]}], 
             ")"}], "/", "2"}], " ", "+", " ", "\n", "  ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"eps", "[", 
               RowBox[{"B", ",", " ", "C"}], "]"}], "*", 
              RowBox[{
               RowBox[{"boxDd", "[", 
                RowBox[{"A", ",", " ", "D"}], "]"}], "[", "expr", "]"}]}], 
             ")"}], "/", "2"}], " ", "+", " ", "\n", "  ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"eps", "[", 
               RowBox[{"A", ",", " ", "D"}], "]"}], "*", 
              RowBox[{
               RowBox[{"boxDd", "[", 
                RowBox[{"B", ",", " ", "C"}], "]"}], "[", "expr", "]"}]}], 
             ")"}], "/", "2"}], " ", "+", " ", "\n", "  ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"eps", "[", 
               RowBox[{"A", ",", " ", "C"}], "]"}], "*", 
              RowBox[{
               RowBox[{"boxDd", "[", 
                RowBox[{"B", ",", " ", "D"}], "]"}], "[", "expr", "]"}]}], 
             ")"}], "/", "2"}], " ", "+", " ", "\n", "  ", 
           RowBox[{
            RowBox[{"Dd", "[", 
             RowBox[{"C", ",", " ", "D"}], "]"}], "[", 
            RowBox[{
             RowBox[{"Dd", "[", 
              RowBox[{"A", ",", " ", "B"}], "]"}], "[", "expr", "]"}], 
            "]"}]}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{"SymbolJoin", "[", 
         RowBox[{"boxDd", ",", "\"\<ToHatBox\>\""}], "]"}], "]"}], "=", 
       "\[IndentingNewLine]", 
       RowBox[{"MakeSimpleRule", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"boxDd", "[", 
            RowBox[{"A", ",", "B"}], "]"}], "[", "expr_", "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"1", "/", "2"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"boxcd", "[", 
               RowBox[{"A", ",", "B"}], "]"}], "[", "expr", "]"}], ")"}]}], 
           "-", 
           RowBox[{
            RowBox[{"1", "/", "2"}], 
            RowBox[{
             RowBox[{"Evaluate", "[", 
              RowBox[{"SymbolJoin", "[", 
               RowBox[{"\"\<TorsionNormal\>\"", ",", "Dd"}], "]"}], "]"}], 
             "[", 
             RowBox[{"A", ",", "D", ",", "B", ",", 
              RowBox[{"-", "D"}]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"CD", "[", 
               RowBox[{"Dir", "[", 
                RowBox[{"Nn", "[", "a", "]"}], "]"}], "]"}], "[", "expr", 
              "]"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"1", "/", "2"}], " ", 
            RowBox[{
             RowBox[{"Evaluate", "[", 
              RowBox[{"SymbolJoin", "[", 
               RowBox[{"\"\<TorsionSpatial\>\"", ",", "Dd"}], "]"}], "]"}], 
             "[", 
             RowBox[{"A", ",", "C", ",", "B", ",", 
              RowBox[{"-", "C"}], ",", 
              RowBox[{"-", "D"}], ",", 
              RowBox[{"-", "F"}]}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Dd", "[", 
               RowBox[{"D", ",", "F"}], "]"}], "[", "expr", "]"}], ")"}]}], 
           "+", 
           RowBox[{
            RowBox[{"1", "/", "2"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"SymbolJoin", "[", 
                RowBox[{"\"\<HatBox\>\"", ",", "CD", ",", "Nn"}], "]"}], "[", 
               
               RowBox[{"A", ",", "B"}], "]"}], "[", "expr", "]"}], 
             ")"}]}]}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Commutation", " ", "rule", " ", "for", " ", "the", " ", "spacetime", 
        " ", "CovD"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"SpaceSpinors`Private`CommuteSpinCovD", "=", 
       RowBox[{"MakeSimpleRule", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"CD", "[", 
            RowBox[{"A", ",", "Adg"}], "]"}], "@", 
           RowBox[{
            RowBox[{"CD", "[", 
             RowBox[{"B", ",", "Bdg"}], "]"}], "@", "expr_"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"epsdg", "[", 
             RowBox[{"Adg", ",", "Bdg"}], "]"}], "*", 
            RowBox[{
             RowBox[{"boxcd", "[", 
              RowBox[{"A", ",", "B"}], "]"}], "[", "expr", "]"}]}], "+", 
           RowBox[{
            RowBox[{"eps", "[", 
             RowBox[{"A", ",", "B"}], "]"}], "*", 
            RowBox[{
             RowBox[{"boxcd", "[", 
              RowBox[{"Adg", ",", "Bdg"}], "]"}], "[", "expr", "]"}]}], "+", 
           RowBox[{
            RowBox[{"CD", "[", 
             RowBox[{"B", ",", "Bdg"}], "]"}], "[", 
            RowBox[{
             RowBox[{"CD", "[", 
              RowBox[{"A", ",", "Adg"}], "]"}], "[", "expr", "]"}], "]"}]}]}],
          "}"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.570359519213044*^9, 3.570359635854449*^9}, {
   3.5703596823113303`*^9, 3.570359748798647*^9}, 3.5703598423208113`*^9, {
   3.5703601032936697`*^9, 3.570360106366875*^9}, {3.570360487647145*^9, 
   3.570360504479574*^9}, {3.5703605552420635`*^9, 3.5703605627144766`*^9}, {
   3.570360621167779*^9, 3.5703606306681957`*^9}, {3.570360682959488*^9, 
   3.5703607335971766`*^9}, {3.570360772300845*^9, 3.5703608867436457`*^9}, {
   3.5703609202057047`*^9, 3.5703609800630097`*^9}, {3.570361062493554*^9, 
   3.570361062867955*^9}, {3.5703611618813295`*^9, 3.570361193689785*^9}, {
   3.5703614009985495`*^9, 3.570361406661359*^9}, {3.5703614643346605`*^9, 
   3.5703614756758804`*^9}, {3.570361527467971*^9, 3.570361537779589*^9}, {
   3.570361609477315*^9, 3.5703616539529934`*^9}, {3.5703616994270735`*^9, 
   3.570361752326766*^9}, {3.5703625851820292`*^9, 3.570362592560842*^9}, 
   3.570362658798558*^9, 3.5703628104464245`*^9, {3.5703629119246025`*^9, 
   3.5703629784119196`*^9}, {3.570363078735696*^9, 3.570363107533346*^9}, {
   3.570363208184723*^9, 3.570363216655538*^9}, {3.570363269602031*^9, 
   3.570363270616033*^9}, {3.570363333312543*^9, 3.570363335590147*^9}, {
   3.570363412030281*^9, 3.5703634326379175`*^9}, {3.570363519966871*^9, 
   3.570363537891302*^9}, {3.5703635963446054`*^9, 3.5703636041914186`*^9}, {
   3.5703640325525713`*^9, 3.570364056982214*^9}, {3.570364124187132*^9, 
   3.570364138944758*^9}, {3.570364297161236*^9, 3.570364355224538*^9}, 
   3.5703644596355214`*^9, {3.5703645421908665`*^9, 3.570364546402874*^9}, {
   3.570364614418993*^9, 3.5703646228586082`*^9}, {3.570364657537469*^9, 
   3.5703647117007637`*^9}, {3.5703647995601187`*^9, 3.5703648083117337`*^9}, 
   3.570364844956198*^9, {3.5703649013814974`*^9, 3.5703649030039005`*^9}, {
   3.5703653382134647`*^9, 3.5703653881179523`*^9}, {3.5703654331396313`*^9, 
   3.570365448334058*^9}, {3.57036552377579*^9, 3.570365676000858*^9}, 
   3.5703657816598434`*^9, {3.570365835667138*^9, 3.5703658649795895`*^9}, {
   3.5703659011560535`*^9, 3.570365908285266*^9}, {3.5703659646325645`*^9, 
   3.5703659685013714`*^9}, {3.5703660270804744`*^9, 3.57036608712498*^9}, {
   3.570366161802311*^9, 3.5703662235628195`*^9}, {3.5703663135125775`*^9, 
   3.5703663292374053`*^9}, 3.5703663913567142`*^9, {3.5703664241167717`*^9, 
   3.5703664263007755`*^9}, {3.570366484036477*^9, 3.570366495954898*^9}, {
   3.570366554065*^9, 3.5703665624890146`*^9}, {3.5703670779295206`*^9, 
   3.5703671123431807`*^9}, {3.570367143714836*^9, 3.570367231995391*^9}, {
   3.57036733422237*^9, 3.5703673531140037`*^9}, {3.570367449584573*^9, 
   3.570367485870237*^9}, {3.5703677275156612`*^9, 3.570367751430503*^9}, 
   3.5703677989013863`*^9, {3.5703678432678647`*^9, 3.570367855903887*^9}, {
   3.570368110574334*^9, 3.570368143599592*^9}, {3.5703681930204787`*^9, 
   3.5703683208315034`*^9}, {3.5703683623431764`*^9, 
   3.5703683800648074`*^9}, {3.5703684124816647`*^9, 
   3.5703684536345367`*^9}, {3.5703685190610514`*^9, 3.5703685440210953`*^9}, 
   3.570368630975648*^9, {3.5703687430462446`*^9, 3.57036876306108*^9}, {
   3.5703688133399687`*^9, 3.5703688527768373`*^9}, {3.570368904085328*^9, 
   3.570368919092554*^9}, {3.570427262343991*^9, 3.5704272816100245`*^9}, {
   3.570427484893982*^9, 3.5704275147680345`*^9}, {3.5704275869659615`*^9, 
   3.5704275874183617`*^9}, {3.570431928127986*^9, 3.570431929110788*^9}, {
   3.570432048747398*^9, 3.5704321662624044`*^9}, {3.5704322209561005`*^9, 
   3.570432221424101*^9}, {3.5704324418680887`*^9, 3.570432506093401*^9}, {
   3.570432663778478*^9, 3.570432736864607*^9}, {3.570438646538703*^9, 
   3.5704387470964794`*^9}, {3.5769891426460967`*^9, 3.576989233797057*^9}, {
   3.5844319092853637`*^9, 3.584431917865379*^9}, 3.584431950407036*^9, {
   3.6176887218492537`*^9, 3.6176887259692593`*^9}, {3.617688794519356*^9, 
   3.617688799949363*^9}, {3.617688860649448*^9, 3.6176888832394795`*^9}, {
   3.617689150374902*^9, 3.6176891528249054`*^9}, {3.617689338949214*^9, 
   3.617689356649239*^9}, {3.6176922404282255`*^9, 3.6176922461082335`*^9}, {
   3.6177065804926987`*^9, 3.6177066052327337`*^9}, {3.617707156791602*^9, 
   3.6177071613316083`*^9}, 3.617707200031663*^9, {3.6177072364827137`*^9, 
   3.617707296986847*^9}, {3.6177073271668887`*^9, 3.6177073453869143`*^9}, {
   3.6408757935108333`*^9, 3.640875796147901*^9}, {3.64087586003176*^9, 
   3.6408758650249186`*^9}, {3.640875896398842*^9, 3.6408759009189606`*^9}, 
   3.663060555463073*^9, {3.690017976602571*^9, 3.690017995662571*^9}, {
   3.6900189301096025`*^9, 3.690018934179399*^9}, {3.690019653334571*^9, 
   3.6900197162845707`*^9}, {3.690019753664571*^9, 3.6900197756845713`*^9}, {
   3.690019831404571*^9, 3.6900198618245707`*^9}, {3.690019926654571*^9, 
   3.6900199526445713`*^9}, {3.690019990314571*^9, 3.690019992984571*^9}, {
   3.6900210915745707`*^9, 3.690021095904571*^9}, {3.690021430584571*^9, 
   3.690021525414571*^9}, {3.690021832334571*^9, 3.690021884454571*^9}, {
   3.690022001664571*^9, 3.690022001884571*^9}, {3.690022053874571*^9, 
   3.690022074124571*^9}, {3.6900221087845707`*^9, 3.690022131874571*^9}, 
   3.6900258313305707`*^9, {3.690026717039571*^9, 3.6900268455295706`*^9}, {
   3.690026876219571*^9, 3.690026932083696*^9}, {3.6900269680297413`*^9, 
   3.690027173637122*^9}, {3.690027230585013*^9, 3.690027306382739*^9}, 
   3.6900273535313244`*^9, 3.9567398992641964`*^9, {3.9567409566916924`*^9, 
   3.9567409647770767`*^9}, {3.9567411560498734`*^9, 
   3.9567411621006985`*^9}, {3.9567415891721573`*^9, 3.956741671765564*^9}, {
   3.9567417185558662`*^9, 3.9567419695032043`*^9}, {3.956742102517748*^9, 
   3.956742139987545*^9}, {3.956742564071205*^9, 3.956742586319769*^9}, {
   3.956743010816763*^9, 3.95674302070018*^9}, {3.9573616835406303`*^9, 
   3.9573616852251186`*^9}, {3.9573682740225315`*^9, 
   3.9573683874246197`*^9}, {3.9573684221139336`*^9, 3.957368441695036*^9}, {
   3.9573684833279457`*^9, 3.9573685351394386`*^9}, 3.9573685733784485`*^9, {
   3.957368877751688*^9, 3.9573688850248985`*^9}, {3.957369562803404*^9, 
   3.9573695799760094`*^9}, {3.957403221427847*^9, 3.9574032790506763`*^9}, {
   3.9585591655332565`*^9, 3.9585591842796745`*^9}, {3.9585592182255077`*^9, 
   3.9585592268297653`*^9}, {3.958559274885271*^9, 3.9585593026021767`*^9}, {
   3.958559622802103*^9, 3.958559755998888*^9}, {3.9585598730040665`*^9, 
   3.9585598741808987`*^9}, {3.958560094258217*^9, 3.9585600953068905`*^9}, {
   3.958561035491993*^9, 3.958561065621834*^9}, {3.9585620954056625`*^9, 
   3.958562096373337*^9}, {3.9585626407025547`*^9, 3.9585626420662823`*^9}, {
   3.958562690722727*^9, 3.9585627125867004`*^9}, {3.958570798078808*^9, 
   3.9585710160373*^9}, {3.9585710502279644`*^9, 3.9585710882468643`*^9}, {
   3.958571130767294*^9, 3.9585711339024677`*^9}, {3.9585712080359306`*^9, 
   3.9585712096368046`*^9}, {3.9585713053289948`*^9, 3.958571335146345*^9}, {
   3.958571370484148*^9, 3.9585713720055065`*^9}, {3.958700175682541*^9, 
   3.95870018083753*^9}, {3.9596018759128056`*^9, 3.959601879983986*^9}, {
   3.959601931170513*^9, 3.959601933055475*^9}, {3.959601982475294*^9, 
   3.9596019881843586`*^9}, {3.9596045890329514`*^9, 3.959604636652876*^9}, {
   3.9596047006194477`*^9, 3.959604715019327*^9}, {3.959604802516535*^9, 
   3.959604815931654*^9}, {3.9596048756229954`*^9, 3.9596048814623775`*^9}, {
   3.9596051525473576`*^9, 3.9596051617317924`*^9}, {3.95961110362327*^9, 
   3.9596111410462055`*^9}, {3.959657607173004*^9, 3.9596576126354218`*^9}, {
   3.9596576475870323`*^9, 3.9596576489463997`*^9}, {3.9596580969862766`*^9, 
   3.959658157193453*^9}, {3.959659428608839*^9, 3.9596594706972733`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"f0342ec5-bc28-421a-bd81-2ac232563182"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefIntrinsicConnection", "[", 
    RowBox[{
    "nb_", ",", "eps_", ",", "CD_", ",", "t_", ",", "Nn_", ",", "sigma_", ",", 
     RowBox[{"{", 
      RowBox[{"A_", ",", "B_", ",", "Adg_", ",", "Bdg_", ",", "a_"}], "}"}]}],
     "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"normsqr", "=", 
        RowBox[{"Scalar", "[", 
         RowBox[{
          RowBox[{"Nn", "[", "a", "]"}], 
          RowBox[{"Nn", "[", 
           RowBox[{"-", "a"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"epsdg", "=", 
        RowBox[{"Dagger", "[", "eps", "]"}]}], ",", 
       RowBox[{"tbundle", "=", 
        RowBox[{"TangentBundleOfSolderingForm", "[", "sigma", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"sbundle", "=", 
        RowBox[{"VBundleOfSolderingForm", "[", "sigma", "]"}]}], ",", 
       RowBox[{"R4name", "=", 
        RowBox[{
         RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
         RowBox[{"[", "10", "]"}], "]"}]}], ",", 
       RowBox[{"R0name", "=", 
        RowBox[{
         RowBox[{"SpaceSpinorsDefaultNames", "[", "Nn", "]"}], "[", 
         RowBox[{"[", "11", "]"}], "]"}]}], ",", 
       RowBox[{"Dd", "=", 
        RowBox[{"SenCovDOfNormalSpinor", "[", "t", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"CovDQ", "[", "nb", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SpinCovDQ", "[", "nb", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SpatialSpinCovDQ", "[", "nb", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"NormalOfCovD", "[", "nb", "]"}], "^=", "Nn"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ParentCovD", "[", "nb", "]"}], "^=", "CD"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"IntrinsicCovDOfNormalSpinor", "[", "t", "]"}], "^=", "nb"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SlotsOfCovD", "[", "nb", "]"}], "^=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "sbundle"}], ",", 
         RowBox[{"-", "sbundle"}]}], "}"}]}], ";", "\[IndentingNewLine]", " ", 
      RowBox[{"xAct`xTensor`Private`MakeLinearDerivative", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"nb", "[", 
             TagBox[
              StyleBox[
               RowBox[{"xAct`xTensor`Private`pattern", "[", 
                RowBox[{"A", ",", 
                 RowBox[{"BlankSequence", "[", "]"}]}], "]"}],
               ShowSpecialCharacters->False,
               ShowStringCharacters->True,
               NumberMarks->True],
              FullForm], "]"}], ",", 
            RowBox[{"nb", "[", "A", "]"}]}], "}"}], "/.", 
          RowBox[{"xAct`xTensor`Private`pattern", "\[Rule]", "Pattern"}]}], 
         "]"}], ",", "True"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SymmetryGroupOfCovD", "[", "nb", "]"}], "^=", 
       RowBox[{"StrongGenSet", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", 
         RowBox[{"GenSet", "[", 
          RowBox[{"Cycles", "@", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ManifoldOfCovD", "[", "nb", "]"}], "^=", 
       RowBox[{"ManifoldOfCovD", "[", "CD", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"VBundlesOfCovD", "[", "nb", "]"}], "^=", 
       RowBox[{"{", 
        RowBox[{"tbundle", ",", "sbundle"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SymbolOfCovD", "[", "nb", "]"}], "^=", 
       RowBox[{"{", 
        RowBox[{"\"\<?\>\"", ",", "\"\<D\>\""}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"eps", "/:", 
       RowBox[{
        RowBox[{"nb", "[", "__", "]"}], "@", 
        RowBox[{"eps", "[", "__", "]"}]}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DefSpatialBox", "[", "nb", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Omega4NameOfCovD", "[", "nb", "]"}], "^=", 
       RowBox[{"ZeroTensor", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "sbundle"}], ",", 
          RowBox[{"-", "sbundle"}], ",", 
          RowBox[{"-", "sbundle"}], ",", 
          RowBox[{"-", "sbundle"}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Omega0NameOfCovD", "[", "nb", "]"}], "^=", 
       RowBox[{"ZeroTensor", "[", 
        RowBox[{"{", "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"DefSymmetricSpinor", "[", 
       RowBox[{"R4name", ",", "4", ",", "0", ",", "sbundle", ",", 
        RowBox[{
         RowBox[{"SpaceSpinorsDefaultSymbols", "[", "Nn", "]"}], "[", 
         RowBox[{"[", "5", "]"}], "]"}]}], "]"}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"DefSymmetricSpinor", "[", 
       RowBox[{"R0name", ",", "0", ",", "0", ",", "sbundle", ",", 
        RowBox[{
         RowBox[{"SpaceSpinorsDefaultSymbols", "[", "Nn", "]"}], "[", 
         RowBox[{"[", "6", "]"}], "]"}]}], "]"}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tex", "[", "R4name", "]"}], "^=", 
       RowBox[{"Tex", "[", "R4name", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tex", "[", "R0name", "]"}], "^=", 
       RowBox[{"Tex", "[", "R0name", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"R4NameOfCovD", "[", "Dd", "]"}], "^=", "R4name"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"R0NameOfCovD", "[", "Dd", "]"}], "^=", "R0name"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQXZGT4m385ZXjv1V24SDaUsg1AURPP5CSDKLdlvAW
Ziu8djwsnQOm73R8LgXREgdnV4LoC8ETOdXrXjvmZSzjAdEb9MOngui2y/lg
OsPvjIUGkK75w2wJomVqRPoeVb11jDCSBdMx5icZHgPpB26cPCD6gEhFi2DN
W8eG5XvB9A3fqaGiQDqCfzqYrrD1TALRIs98wXSFBt81VSBt0H4PTP/5J6oc
XffWUUH9PpiumOflEN3w1vHLJR8wzXK26RmIniD68AWIXvO2IaMISOcE3s4C
0Q1bth8D0QfY/U+A6B07Tze2AOmOZR6dIPpEZPQ5EP1kBt9lEL3ntB9LK5B2
YdzKCqIBch2ldw==
  "],
 CellLabel->"In[83]:=",ExpressionUUID->"8121bac4-8361-4f35-9c62-0d46dde3bc46"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefSpatialBox", "[", "covd_Symbol", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"boxcd", "=", 
        RowBox[{"SymbolJoin", "[", 
         RowBox[{"\"\<Box\>\"", ",", "covd"}], "]"}]}], ",", 
       RowBox[{"A", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"First", "@", 
           RowBox[{"IndicesOfVBundle", "@", 
            RowBox[{
             RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"B", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"First", "@", 
           RowBox[{"IndicesOfVBundle", "@", 
            RowBox[{
             RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"CovDQ", "[", "boxcd", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"xAct`xTensor`Private`$MultiIndexCovDs", ",", "boxcd"}], "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`MakeLinearDerivative", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"boxcd", "[", 
           RowBox[{"A_", ",", "B_"}], "]"}], ",", 
          RowBox[{"boxcd", "[", 
           RowBox[{"A", ",", "B"}], "]"}]}], "}"}], ",", "True"}], "]"}], ";",
       "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SymmetryGroupOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"Symmetric", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{"ManifoldOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"ManifoldOfCovD", "[", "covd", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"VBundlesOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"VBundlesOfCovD", "[", "covd", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SlotsOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"SlotsOfCovD", "[", "covd", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"xAct`Spinors`Private`CovDOfBox", "[", "boxcd", "]"}], "^=", 
       "covd"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"SymbolOfCovD", "[", "boxcd", "]"}], "^=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"First", "[", 
          RowBox[{"SymbolOfCovD", "[", "covd", "]"}], "]"}], ",", 
         RowBox[{"StringJoin", "[", 
          RowBox[{
          "\"\<\!\(\*OverscriptBox[\(\[EmptySquare]\), \(~\)]\)\>\"", ",", 
           "\"\<[\>\"", ",", 
           RowBox[{"Part", "[", 
            RowBox[{
             RowBox[{"SymbolOfCovD", "@", "covd"}], ",", "2"}], "]"}], ",", 
           "\"\<]\>\""}], "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xAct`xTensor`Private`SymbolRelations", "[", 
       RowBox[{"boxcd", ",", "covd", ",", 
        RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Protect", "[", "boxcd", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.690019008927189*^9, {3.690019063346645*^9, 3.6900190674266043`*^9}, {
   3.6900191286859913`*^9, 3.6900191423758545`*^9}, {3.690019998614571*^9, 
   3.690020005014571*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"72e2b433-1fc9-4426-8b69-7707d35b456a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SpatialBoxToCovD", "[", 
    RowBox[{"expr_", ",", "boxcd_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"cd", "=", 
        RowBox[{"xAct`Spinors`Private`CovDOfBox", "@", "boxcd"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"spin1", "=", 
        RowBox[{"UpIndex", "@", 
         RowBox[{
          RowBox[{"SlotsOfCovD", "[", "boxcd", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], ",", 
       RowBox[{"spin2", "=", 
        RowBox[{"UpIndex", "@", 
         RowBox[{
          RowBox[{"SlotsOfCovD", "[", "boxcd", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"expr", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"boxcd", "[", 
           RowBox[{"A_", ",", "B_"}], "]"}], "@", "L_"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"C", "=", 
              RowBox[{"DummyIn", "[", "spin2", "]"}]}], "}"}], ",", 
            RowBox[{"Symmetrize", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"cd", "[", 
                RowBox[{"A", ",", 
                 RowBox[{"-", "C"}]}], "]"}], "@", 
               RowBox[{
                RowBox[{"cd", "[", 
                 RowBox[{"B", ",", "C"}], "]"}], "@", "L"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "B"}], "}"}]}], "]"}]}], "]"}], "/;", 
          RowBox[{
           RowBox[{"ABIndexQ", "[", 
            RowBox[{"A", ",", "spin1"}], "]"}], "&&", 
           RowBox[{"ABIndexQ", "[", 
            RowBox[{"B", ",", "spin1"}], "]"}]}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"boxcd", "[", 
           RowBox[{"A_", ",", "B_"}], "]"}], "@", "L_"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"C", "=", 
              RowBox[{"DummyIn", "[", "spin1", "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Symmetrize", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"cd", "[", 
                RowBox[{
                 RowBox[{"-", "C"}], ",", "A"}], "]"}], "@", 
               RowBox[{
                RowBox[{"cd", "[", 
                 RowBox[{"C", ",", "B"}], "]"}], "@", "L"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "B"}], "}"}]}], "]"}]}], "]"}], "/;", 
          RowBox[{
           RowBox[{"ABIndexQ", "[", 
            RowBox[{"A", ",", "spin2"}], "]"}], "&&", 
           RowBox[{"ABIndexQ", "[", 
            RowBox[{"B", ",", "spin2"}], "]"}]}]}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[85]:=",ExpressionUUID->"3190ae08-02e1-4d5c-b4b5-570a183a141e"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. Decomposition into space spinors", "Subsection",
 CellChangeTimes->{{3.5703536834717937`*^9, 3.5703536884170027`*^9}, 
   3.5703540316030054`*^9, {3.570354071211475*^9, 3.570354074799481*^9}, {
   3.5703542672726192`*^9, 3.5703543005474777`*^9}, {3.617690917665018*^9, 
   3.6176909388750477`*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"66b7061b-ab77-4167-b986-4926b60e844f"],

Cell["4.1. Tensors", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.570354046235831*^9, 3.570354067015067*^9}, {
  3.5703543996388516`*^9, 3.570354406721264*^9}, {3.6176909415850515`*^9, 
  3.617690960365078*^9}},ExpressionUUID->"5439dd50-c9f1-453c-a865-\
57f981599104"]
}, Open  ]],

Cell[CellGroupData[{

Cell["5. Fundamental space spinor operators", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.5703536834717937`*^9, 3.5703536884170027`*^9}, 
   3.5703540316030054`*^9, {3.570354071211475*^9, 3.570354074799481*^9}, {
   3.5703542672726192`*^9, 3.5703543005474777`*^9}, {3.617690917665018*^9, 
   3.6176909388750477`*^9}, {3.690020071474571*^9, 3.690020083654571*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"e9848701-0963-4e7e-a673-8a6acde35f45"],

Cell[CellGroupData[{

Cell["5.1. Common functions for the fundamental spinor operators", \
"Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.570354046235831*^9, 3.570354067015067*^9}, {
  3.5703543996388516`*^9, 3.570354406721264*^9}, {3.6176909415850515`*^9, 
  3.617690960365078*^9}, {3.6900201008245707`*^9, 3.690020102214571*^9}, {
  3.690020199004571*^9, 
  3.690020199714571*^9}},ExpressionUUID->"79b7240c-c425-45df-91f6-\
63a622fd6214"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DivName", "[", 
    RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], "]"}], ":=", 
   RowBox[{"Symbol", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<Div\>\"", ",", 
      RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], ";", " ", 
  RowBox[{
   RowBox[{"CurlName", "[", 
    RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], "]"}], ":=", 
   RowBox[{"Symbol", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<Curl\>\"", ",", 
      RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], ";", " ", 
  RowBox[{
   RowBox[{"TwistName", "[", 
    RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], "]"}], ":=", 
   RowBox[{"Symbol", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<Twist\>\"", ",", 
      RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BoxName", "[", 
    RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], "]"}], ":=", 
   RowBox[{"Symbol", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{"\"\<Box\>\"", ",", 
      RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5922206212445946`*^9, 3.5922207287657456`*^9}, {
   3.592224183151582*^9, 3.592224189641591*^9}, {3.5922242722017064`*^9, 
   3.59222429608174*^9}, 3.592232206802663*^9, 3.5992901182170424`*^9, {
   3.599297379153892*^9, 3.599297404033927*^9}, {3.957359604820652*^9, 
   3.957359617881962*^9}, {3.957361246252142*^9, 3.9573612497006187`*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"e3b9c935-0461-4f04-88f0-cbfa0a42a550"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExtractUnprimedIndsGivenCovD", "[", 
    RowBox[{"inds_List", ",", 
     RowBox[{"covd_", "?", "xAct`Spinors`SpinCovDQ"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"spin", "=", 
       RowBox[{
        RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"Select", "[", 
      RowBox[{"inds", ",", 
       RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "@", "spin"}]}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5993006194044313`*^9, 3.599300633684451*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"a8928bd8-175a-49d1-b9a7-e2537af81715"]
}, Closed]],

Cell[CellGroupData[{

Cell["5.2. Definition of fundamental spinor operators and tools", \
"Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.5539192482194347`*^9, 3.553919256393849*^9}, {
   3.5539225601370564`*^9, 3.5539225625082607`*^9}, {3.5891979111905575`*^9, 
   3.589197916853368*^9}, {3.589197965338253*^9, 3.589197978052275*^9}, {
   3.5901524319283648`*^9, 3.5901524341591687`*^9}, 3.590213338156372*^9, 
   3.590318254499852*^9, 3.592220754195781*^9, {3.6900201918945713`*^9, 
   3.690020195984571*^9}},ExpressionUUID->"5b7522e7-2dd5-446d-b841-\
0c61a19fd2fb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FundSpatialSpinOpQ", "[", "_", "]"}], ":=", "False"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5981891511155453`*^9, 3.5981891850155926`*^9}, {
  3.599290177237125*^9, 3.5992901967571526`*^9}, {3.599305684395522*^9, 
  3.5993056881555276`*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"3137d577-445f-4e76-9f3d-8213faf0ce33"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FundSpatialSpinOpCovDs", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5972104434752345`*^9, 3.597210454145653*^9}, {
  3.598172049387412*^9, 3.598172059997427*^9}, {3.599290199257156*^9, 
  3.5992902085771685`*^9}, {3.5993018569471636`*^9, 3.599301857427164*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"e06b6fd8-cb43-40ba-8671-d4101e63a999"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefFundSpatialSpinOperators", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"HideCovDSymbolReference", "\[Rule]", "True"}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5981790359563274`*^9, 3.598179074796382*^9}, {
  3.5981792696366544`*^9, 3.5981792714066567`*^9}, {3.599290213097175*^9, 
  3.5992902161571794`*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"44ba52ae-758e-4140-b081-70355dd28a91"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"SpatialOpValenceNumberPrintFunc", "[", 
    RowBox[{
    "TT_", ",", "opsymbol_", ",", "opsymbsuper_", ",", " ", "covdsymb_", ",", 
     "spin_"}], "]"}], ":=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"OptionValue", "[", 
         RowBox[{"DefFundSpinOperators", ",", "ShowValenceInfo"}], "]"}], ",", 
        RowBox[{"SubsuperscriptBox", "[", 
         RowBox[{"opsymbol", ",", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"DisplayForm", "[", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "TT", 
              "]"}], "]"}], ",", "StandardForm"}], "]"}], ",", 
          "opsymbsuper"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"StringLength", "[", "opsymbsuper", "]"}], "==", "0"}], 
          ",", "opsymbol", ",", 
          RowBox[{"SuperscriptBox", "[", 
           RowBox[{"opsymbol", ",", "opsymbsuper"}], "]"}]}], "]"}]}], "]"}], 
      "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"OptionValue", "[", 
        RowBox[{
        "DefFundSpatialSpinOperators", ",", "HideCovDSymbolReference"}], 
        "]"}], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<[\>\"", ",", "covdsymb", ",", "\"\<]\>\""}], "}"}]}], 
      "]"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9568081532954845`*^9, 3.9568081544527397`*^9}, {
   3.956808196723715*^9, 3.9568082246713524`*^9}, 3.9568084069987526`*^9},
 CellLabel->"In[92]:=",ExpressionUUID->"ec129206-7f6b-6547-8e18-62a8879eac6b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SpatialTexValenceNumbers", "[", 
    RowBox[{"TT_", ",", "spin_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"OptionValue", "[", 
      RowBox[{"DefFundSpinOperators", ",", "ShowValenceInfo"}], "]"}], ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<_{\>\"", ",", 
       RowBox[{"xAct`TexAct`Tex", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "TT", "]"}], 
         "/.", "xAct`TexAct`ToOrderedPlus"}], "]"}], ",", "\"\<} \>\""}], 
      "]"}], ",", "\"\< \>\""}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.956808510605875*^9, 3.956808528302635*^9}, {
  3.9568088413625336`*^9, 3.956808847957903*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"6d927011-d2df-974c-a85c-ad0b217a838b"],

Cell["\<\
Definition of the spatial divergence, curl and twistor operators, and most \
tools that are needed to handle them.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.553938656402255*^9, 3.553938671846282*^9}, {
  3.587796839044757*^9, 3.5877968419619617`*^9}, {3.5903182638442683`*^9, 
  3.5903182815190997`*^9}, {3.6900201533245707`*^9, 
  3.690020165714571*^9}},ExpressionUUID->"6a5ca2ab-50e7-4899-8890-\
d316034198ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefFundSpatialSpinOperators", "[", 
    RowBox[{
     RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Names", " ", "of", " ", "the", " ", "operators"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"divcd", "=", 
        RowBox[{"DivName", "@", "covd"}]}], ",", " ", 
       RowBox[{"curlcd", "=", 
        RowBox[{"CurlName", "@", "covd"}]}], ",", " ", 
       RowBox[{"twistcd", "=", 
        RowBox[{"TwistName", "@", "covd"}]}], ",", 
       RowBox[{"boxcd", "=", 
        RowBox[{"BoxName", "@", "covd"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Names", " ", "of", " ", "lists"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"$irrdecrulescd", "=", 
        RowBox[{"Symbol", "[", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"\"\<$IrrDecRules\>\"", ",", 
           RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"$expandfundspinoprulescd", "=", 
        RowBox[{"Symbol", "[", 
         RowBox[{"StringJoin", "[", 
          RowBox[{"\"\<$ExpandFundSpinOpRules\>\"", ",", 
           RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Extract", " ", "the", " ", "spin", " ", "bundles"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"spin", "=", 
        RowBox[{
         RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Nn", "=", 
        RowBox[{"NormalOfCovD", "[", "covd", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"CD", "=", 
        RowBox[{"ParentCovD", "[", "covd", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Omega4", "=", 
        RowBox[{"Omega4NameOfCovD", "[", "covd", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Omega0", "=", 
        RowBox[{"Omega0NameOfCovD", "[", "covd", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Accname", "=", 
        RowBox[{"AccNameOfNormal", "[", 
         RowBox[{"NormalOfCovD", "[", "covd", "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"DirOp", "=", 
        RowBox[{"DirOpNameOfNormal", "[", 
         RowBox[{"NormalOfCovD", "[", "covd", "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Ns", "=", 
        RowBox[{"SpinorOfNormal", "[", 
         RowBox[{"NormalOfCovD", "[", "covd", "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"aind", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"First", "@", 
           RowBox[{"IndicesOfVBundle", "@", 
            RowBox[{
             RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"normsqr", "=", 
          RowBox[{"Scalar", "[", 
           RowBox[{
            RowBox[{"Nn", "[", "aind", "]"}], 
            RowBox[{"Nn", "[", 
             RowBox[{"-", "aind"}], "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"The", " ", "spin", " ", "metrics"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"eps", "=", 
          RowBox[{"First", "@", 
           RowBox[{"MetricsOfVBundle", "@", "spin"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"divCD", "=", 
          RowBox[{"xAct`SymManipulator`Private`DivName", "@", "CD"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"curlCD", "=", 
          RowBox[{"xAct`SymManipulator`Private`CurlName", "@", "CD"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"curldgCD", "=", 
          RowBox[{"xAct`SymManipulator`Private`CurlDgName", "@", "CD"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"twistCD", "=", 
          RowBox[{"xAct`SymManipulator`Private`TwistName", "@", "CD"}]}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Aind", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", "spin"}]}], ")"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Bind", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", "spin"}]}], ")"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Cind", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", "spin"}]}], ")"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Dind", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"First", "@", 
             RowBox[{"IndicesOfVBundle", "@", "spin"}]}], ")"}], "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"SpatialPhi4", "=", 
          RowBox[{
           RowBox[{"SpatialPhinamesOfNormal", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"SpatialPhi2", "=", 
          RowBox[{
           RowBox[{"SpatialPhinamesOfNormal", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"SpatialPhi0", "=", 
          RowBox[{
           RowBox[{"SpatialPhinamesOfNormal", "[", "Nn", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"HatNnOp", "=", 
          RowBox[{"HatNnOpOfNormal", "[", "Nn", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"R4Name", "=", 
          RowBox[{"R4NameOfCovD", "[", 
           RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"R0Name", "=", 
          RowBox[{"R0NameOfCovD", "[", 
           RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Functions", " ", "for", " ", "extraction", " ", "of", " ", 
           "unprimed", " ", "indices", " ", "and", " ", "their", " ", 
           RowBox[{"numbers", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"ExtractUnprimed", "=", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{"#", ",", 
             RowBox[{"xAct`xTensor`Private`VBundleIndexPMQ", "@", "spin"}]}], 
            "]"}], "&"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"expanddivcd", ",", "expandcurlcd", ",", "expandtwistcd"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Add", " ", "to", " ", "the", " ", "lists", " ", "$FundSpinOpCovDs",
            " ", "and", " ", "$FundSpatialSpinOpCovDs"}], "  ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"AppendTo", "[", 
           RowBox[{"$FundSpatialSpinOpCovDs", ",", "covd"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{
           "xAct`SymManipulator`Private`$FundSpinOpCovDs", ",", "covd"}], 
           "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "FundSpinOpQ", " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"FundSpatialSpinOpQ", "[", "divcd", "]"}], "^=", "True"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"FundSpatialSpinOpQ", "[", "curlcd", "]"}], "^=", "True"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"FundSpatialSpinOpQ", "[", "twistcd", "]"}], "^=", 
           "True"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "Linking", " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CovDOfFundSpinOp", "[", "divcd", "]"}], "^=", "covd"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CovDOfFundSpinOp", "[", "curlcd", "]"}], "^=", "covd"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CovDOfFundSpinOp", "[", "twistcd", "]"}], "^=", "covd"}], 
          ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Tensor", " ", 
            RowBox[{"definitions", "."}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xTensorQ", "[", 
            RowBox[{"divcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^=", " ", 
           "True"}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xTensorQ", "[", 
            RowBox[{"curlcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^=", " ", 
           "True"}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xTensorQ", "[", 
            RowBox[{"twistcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^=", " ", 
           "True"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Links", " ", "to", " ", "other", " ", "symbols"}], " ", 
           "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"VisitorsOf", "[", "covd", "]"}], "^=", 
           RowBox[{"Union", "[", 
            RowBox[{
             RowBox[{"VisitorsOf", "[", "covd", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"divcd", ",", "curlcd", ",", "twistcd"}], "}"}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"How", " ", "to", " ", "undefine"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Undef", "[", "divcd", "]"}], "^:=", 
           RowBox[{"UndefFundSpatialSpinOperators", "@", "covd"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Undef", "[", "curlcd", "]"}], "^:=", 
           RowBox[{"UndefFundSpatialSpinOperators", "@", "covd"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Undef", "[", "twistcd", "]"}], "^:=", 
           RowBox[{"UndefFundSpatialSpinOperators", "@", "covd"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"SetLinearOperatorRules", "[", "divcd", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"SetLinearOperatorRules", "[", "curlcd", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"SetLinearOperatorRules", "[", "twistcd", "]"}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Usage", " ", "messages"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"$expandfundspinoprulescd", "::", "usage"}], "=", 
           RowBox[{"StringJoin", "@@", 
            RowBox[{"(", 
             RowBox[{"ToString", "/@", 
              RowBox[{"{", 
               RowBox[{
               "$expandfundspinoprulescd", ",", 
                "\"\<contains rules for expansion of the fundamental \
operators \>\"", ",", " ", "divcd", ",", " ", "\"\<, \>\"", ",", " ", 
                "curlcd", ",", "\"\< and \>\"", ",", " ", "twistcd", ",", 
                "\"\< of expr in terms of symmetrized derivatives.\>\""}], 
               "}"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"$irrdecrulescd", "::", "usage"}], "=", 
           RowBox[{"StringJoin", "@@", 
            RowBox[{"(", 
             RowBox[{"ToString", "/@", 
              RowBox[{"{", 
               RowBox[{
               "$irrdecrulescd", ",", 
                "\"\< is a list of rules that are used by the function \>\"", 
                ",", " ", "ToFundSpinOp", ",", 
                "\"\< to convert derivatives to fundamental operators.\>\""}],
                "}"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Calculation", " ", "of", " ", "the", " ", "slots", " ", "of", " ",
             "the", " ", 
            RowBox[{"tensors", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SlotsOfTensor", "[", 
            RowBox[{"divcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"k", ",", "l", ",", "ovb"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"k", "=", 
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                "TT"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"l", "=", 
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
               ";", "\[IndentingNewLine]", 
              RowBox[{"ovb", "=", 
               RowBox[{
                RowBox[{
                "xAct`SymManipulator`Private`ExtractOtherVBundles", "[", 
                 "spin", "]"}], "@", 
                RowBox[{"SlotsOfTensor", "@", "TT"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"And", "[", 
                 RowBox[{
                 "xAct`SymManipulator`Private`$SlotsOfTensorWarning", ",", 
                  RowBox[{"Simplify", "[", 
                   RowBox[{"k", "<", "2"}], "]"}]}], "]"}], ",", 
                RowBox[{"Throw", "@", 
                 RowBox[{"Message", "[", 
                  RowBox[{
                   RowBox[{"divcd", "::", "error"}], ",", 
                   RowBox[{"StringJoin", "[", 
                    RowBox[{"\"\<Wrong VBundles: \>\"", ",", " ", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"SlotsOfTensor", "@", "TT"}], "]"}]}], "]"}]}], 
                  "]"}]}], ",", "\[IndentingNewLine]", 
                RowBox[{"SymmetricOfValence", "[", 
                 RowBox[{
                  RowBox[{"k", "-", "2"}], ",", "l", ",", "spin", ",", 
                  "ovb"}], "]"}]}], "]"}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SlotsOfTensor", "[", 
            RowBox[{"curlcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"k", ",", "l", ",", "ovb"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"k", "=", 
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                "TT"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"l", "=", 
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
               ";", "\[IndentingNewLine]", 
              RowBox[{"ovb", "=", 
               RowBox[{
                RowBox[{
                "xAct`SymManipulator`Private`ExtractOtherVBundles", "[", 
                 "spin", "]"}], "@", 
                RowBox[{"SlotsOfTensor", "@", "TT"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"And", "[", 
                 RowBox[{
                 "xAct`SymManipulator`Private`$SlotsOfTensorWarning", ",", 
                  RowBox[{"Simplify", "[", 
                   RowBox[{"k", "<", "1"}], "]"}]}], "]"}], ",", 
                RowBox[{"Throw", "@", 
                 RowBox[{"Message", "[", 
                  RowBox[{
                   RowBox[{"curlcd", "::", "error"}], ",", 
                   RowBox[{"StringJoin", "[", 
                    RowBox[{"\"\<Wrong VBundles: \>\"", ",", " ", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"SlotsOfTensor", "@", "TT"}], "]"}]}], "]"}]}], 
                  "]"}]}], ",", "\[IndentingNewLine]", 
                RowBox[{"SymmetricOfValence", "[", 
                 RowBox[{"k", ",", "l", ",", "spin", ",", "ovb"}], "]"}]}], 
               "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SlotsOfTensor", "[", 
            RowBox[{"twistcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"k", ",", "l", ",", "ovb"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"k", "=", 
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                "TT"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"l", "=", 
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "@", "TT"}]}],
               ";", "\[IndentingNewLine]", 
              RowBox[{"ovb", "=", 
               RowBox[{
                RowBox[{
                "xAct`SymManipulator`Private`ExtractOtherVBundles", "[", 
                 "spin", "]"}], "@", 
                RowBox[{"SlotsOfTensor", "@", "TT"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"And", "[", 
                 RowBox[{
                 "xAct`SymManipulator`Private`$SlotsOfTensorWarning", ",", 
                  RowBox[{"Simplify", "[", 
                   RowBox[{"k", "<", "0"}], "]"}]}], "]"}], ",", 
                RowBox[{"Throw", "@", 
                 RowBox[{"Message", "[", 
                  RowBox[{
                   RowBox[{"twistcd", "::", "error"}], ",", 
                   RowBox[{"StringJoin", "[", 
                    RowBox[{"\"\<Wrong VBundles: \>\"", ",", " ", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"SlotsOfTensor", "@", "TT"}], "]"}]}], "]"}]}], 
                  "]"}]}], ",", "\[IndentingNewLine]", 
                RowBox[{"SymmetricOfValence", "[", 
                 RowBox[{
                  RowBox[{"k", "+", "2"}], ",", "l", ",", "spin", ",", 
                  "ovb"}], "]"}]}], "]"}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"TagSetDelayed", "[", 
           RowBox[{"divcd", ",", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
             RowBox[{"divcd", "[", 
              RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "TT", 
              "]"}], "-", "2"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"TagSetDelayed", "[", 
           RowBox[{"divcd", ",", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
             RowBox[{"divcd", "[", 
              RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "TT", 
             "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"TagSetDelayed", "[", 
           RowBox[{"curlcd", ",", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
             RowBox[{"curlcd", "[", 
              RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "TT", 
             "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"TagSetDelayed", "[", 
           RowBox[{"curlcd", ",", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
             RowBox[{"curlcd", "[", 
              RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "TT", 
             "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"TagSetDelayed", "[", 
           RowBox[{"twistcd", ",", 
            RowBox[{
             RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
             RowBox[{"twistcd", "[", 
              RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "TT", 
              "]"}], "+", "2"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"TagSetDelayed", "[", 
           RowBox[{"twistcd", ",", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
             RowBox[{"twistcd", "[", 
              RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "TT", 
             "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Calculation", " ", "of", " ", "the", " ", "symmetry", " ", 
            "groups", " ", "of", " ", "the", " ", "tensors"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SymmetryGroupOfTensor", "[", 
            RowBox[{"divcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"xAct`SymManipulator`Private`CompatibleSym", "@", 
            RowBox[{"SlotsOfTensor", "[", 
             RowBox[{"divcd", "[", "TT", "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SymmetryGroupOfTensor", "[", 
            RowBox[{"curlcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"xAct`SymManipulator`Private`CompatibleSym", "@", 
            RowBox[{"SlotsOfTensor", "[", 
             RowBox[{"curlcd", "[", "TT", "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"SymmetryGroupOfTensor", "[", 
            RowBox[{"twistcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
           RowBox[{"xAct`SymManipulator`Private`CompatibleSym", "@", 
            RowBox[{"SlotsOfTensor", "[", 
             RowBox[{"twistcd", "[", "TT", "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin", "]"}], 
            "[", 
            RowBox[{"divcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], " ", "^:=", " ", 
           
           RowBox[{
            RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin", "]"}], 
            "[", "TT", "]"}]}], ";", 
          RowBox[{
           RowBox[{
            RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin", "]"}], 
            "[", 
            RowBox[{"curlcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], " ", "^:=", " ", 
           
           RowBox[{
            RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin", "]"}], 
            "[", "TT", "]"}]}], ";", 
          RowBox[{
           RowBox[{
            RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin", "]"}], 
            "[", 
            RowBox[{"twistcd", "[", 
             RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], " ", "^:=", " ", 
           
           RowBox[{
            RowBox[{"SymmetricSpinorOfArbitraryValenceQ", "[", "spin", "]"}], 
            "[", "TT", "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Interaction", " ", "with", " ", "the", " ", "ZeroTensor"}], " ", 
           "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"divcd", "[", 
            RowBox[{"ZeroTensor", "[", "vbundles_", "]"}], "]"}], ":=", 
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedVBundles", "[", "spin", "]"}], "@", 
                 "vbundles"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedVBundles", "[", "spin", "]"}], "@", 
                 "vbundles"}]}], ",", 
               RowBox[{"ovb", "=", 
                RowBox[{
                 RowBox[{
                 "xAct`SymManipulator`Private`ExtractOtherVBundles", "[", 
                  "spin", "]"}], "@", "vbundles"}]}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ZeroTensor", "[", 
              RowBox[{"SymmetricOfValence", "[", 
               RowBox[{
                RowBox[{"k", "-", "2"}], ",", "l", ",", "spin", ",", "ovb"}], 
               "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"curlcd", "[", 
            RowBox[{"ZeroTensor", "[", "vbundles_", "]"}], "]"}], ":=", 
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedVBundles", "[", "spin", "]"}], "@", 
                 "vbundles"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedVBundles", "[", "spin", "]"}], "@", 
                 "vbundles"}]}], ",", 
               RowBox[{"ovb", "=", 
                RowBox[{
                 RowBox[{
                 "xAct`SymManipulator`Private`ExtractOtherVBundles", "[", 
                  "spin", "]"}], "@", "vbundles"}]}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ZeroTensor", "[", 
              RowBox[{"SymmetricOfValence", "[", 
               RowBox[{"k", ",", "l", ",", "spin", ",", "ovb"}], "]"}], 
              "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"twistcd", "[", 
            RowBox[{"ZeroTensor", "[", "vbundles_", "]"}], "]"}], ":=", 
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedVBundles", "[", "spin", "]"}], "@", 
                 "vbundles"}]}], ",", 
               RowBox[{"l", "=", 
                RowBox[{
                 RowBox[{"NumOfPrimedVBundles", "[", "spin", "]"}], "@", 
                 "vbundles"}]}], ",", 
               RowBox[{"ovb", "=", 
                RowBox[{
                 RowBox[{
                 "xAct`SymManipulator`Private`ExtractOtherVBundles", "[", 
                  "spin", "]"}], "@", "vbundles"}]}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ZeroTensor", "[", 
              RowBox[{"SymmetricOfValence", "[", 
               RowBox[{
                RowBox[{"k", "+", "2"}], ",", "l", ",", "spin", ",", "ovb"}], 
               "]"}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "Printing", " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SenCovDQ", "[", "covd", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"PrintAs", "[", 
               RowBox[{"divcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"RowBox", "@", 
               RowBox[{"Join", "[", 
                RowBox[{
                 RowBox[{"SpatialOpValenceNumberPrintFunc", "[", 
                  RowBox[{"TT", ",", "\"\<\:0257\>\"", ",", "\"\<\>\"", ",", 
                   RowBox[{"Last", "@", 
                    RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}], ",", 
                   "spin"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"PrintAs", "[", "TT", "]"}], "}"}]}], "]"}]}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"PrintAs", "[", 
               RowBox[{"curlcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"RowBox", "@", 
               RowBox[{"Join", "[", 
                RowBox[{
                 RowBox[{"SpatialOpValenceNumberPrintFunc", "[", 
                  RowBox[{"TT", ",", "\"\<\:0188\>\"", ",", "\"\<\>\"", ",", 
                   RowBox[{"Last", "@", 
                    RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}], ",", 
                   "spin"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"PrintAs", "[", "TT", "]"}], "}"}]}], "]"}]}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"PrintAs", "[", 
               RowBox[{"twistcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"RowBox", "@", 
               RowBox[{"Join", "[", 
                RowBox[{
                 RowBox[{"SpatialOpValenceNumberPrintFunc", "[", 
                  RowBox[{"TT", ",", "\"\<\:01ad\>\"", ",", "\"\<\>\"", ",", 
                   RowBox[{"Last", "@", 
                    RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}], ",", 
                   "spin"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"PrintAs", "[", "TT", "]"}], "}"}]}], "]"}]}]}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"PrintAs", "[", 
               RowBox[{"divcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"RowBox", "@", 
               RowBox[{"Join", "[", 
                RowBox[{
                 RowBox[{"SpatialOpValenceNumberPrintFunc", "[", 
                  RowBox[{"TT", ",", 
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<\:0257\>\"", ",", "Underlined"}], "]"}], 
                   ",", "\"\<\>\"", ",", 
                   RowBox[{"Last", "@", 
                    RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}], ",", 
                   "spin"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"PrintAs", "[", "TT", "]"}], "}"}]}], "]"}]}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"PrintAs", "[", 
               RowBox[{"curlcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"RowBox", "@", 
               RowBox[{"Join", "[", 
                RowBox[{
                 RowBox[{"SpatialOpValenceNumberPrintFunc", "[", 
                  RowBox[{"TT", ",", 
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<\:0188\>\"", ",", "Underlined"}], "]"}], 
                   ",", "\"\<\>\"", ",", 
                   RowBox[{"Last", "@", 
                    RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}], ",", 
                   "spin"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"PrintAs", "[", "TT", "]"}], "}"}]}], "]"}]}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"PrintAs", "[", 
               RowBox[{"twistcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"RowBox", "@", 
               RowBox[{"Join", "[", 
                RowBox[{
                 RowBox[{"SpatialOpValenceNumberPrintFunc", "[", 
                  RowBox[{"TT", ",", 
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<\:01ad\>\"", ",", "Underlined"}], "]"}], 
                   ",", "\"\<\>\"", ",", 
                   RowBox[{"Last", "@", 
                    RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}], ",", 
                   "spin"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"PrintAs", "[", "TT", "]"}], "}"}]}], "]"}]}]}], 
             ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Tex", " ", 
            RowBox[{"output", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"xAct`TexAct`$TexInitLatexPackages", "=", 
           RowBox[{"DeleteDuplicates", "@", 
            RowBox[{"Join", "[", 
             RowBox[{"xAct`TexAct`$TexInitLatexPackages", ",", 
              RowBox[{"{", "\"\<{tipa}\>\"", "}"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"xAct`TexAct`$TexInitLatexExtraCode", "=", 
           RowBox[{"DeleteDuplicates", "@", 
            RowBox[{"Join", "[", 
             RowBox[{"xAct`TexAct`$TexInitLatexExtraCode", ",", 
              RowBox[{"{", 
               RowBox[{
               "\"\<\\\\def\\\\sdiv{\\\\text{\\\\texthtd}}\>\"", ",", 
                "\"\<\\\\def\\\\scurl{\\\\text{\\\\texthtc}}\>\"", ",", 
                "\"\<\\\\def\\\\stwist{\\\\text{\\\\texthtt}}\>\"", ",", 
                "\"\<\\\\def\\\\isdiv{\\\\underline{\\\\text{\\\\texthtd}}}\>\
\"", ",", "\"\<\\\\def\\\\iscurl{\\\\underline{\\\\text{\\\\texthtc}}}\>\"", 
                ",", "\"\<\\\\def\\\\istwist{\\\\underline{\\\\text{\\\\\
texthtt}}}\>\""}], "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SenCovDQ", "[", "covd", "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", 
               RowBox[{"divcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"StringJoin", "[", 
               RowBox[{"\"\<\\\\sdiv\>\"", ",", 
                RowBox[{"SpatialTexValenceNumbers", "[", 
                 RowBox[{"TT", ",", "spin"}], "]"}], ",", 
                RowBox[{
                "xAct`SymManipulator`Private`TexFundOp", "[", "TT", "]"}]}], 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", 
               RowBox[{"curlcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"StringJoin", "[", 
               RowBox[{"\"\<\\\\scurl\>\"", ",", 
                RowBox[{"SpatialTexValenceNumbers", "[", 
                 RowBox[{"TT", ",", "spin"}], "]"}], ",", 
                RowBox[{
                "xAct`SymManipulator`Private`TexFundOp", "[", "TT", "]"}]}], 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", 
               RowBox[{"twistcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"StringJoin", "[", 
               RowBox[{"\"\<\\\\stwist\>\"", ",", 
                RowBox[{"SpatialTexValenceNumbers", "[", 
                 RowBox[{"TT", ",", "spin"}], "]"}], ",", 
                RowBox[{
                "xAct`SymManipulator`Private`TexFundOp", "[", "TT", "]"}]}], 
               "]"}]}]}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", 
               RowBox[{"divcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"StringJoin", "[", 
               RowBox[{"\"\<\\\\isdiv\>\"", ",", 
                RowBox[{"SpatialTexValenceNumbers", "[", 
                 RowBox[{"TT", ",", "spin"}], "]"}], ",", 
                RowBox[{
                "xAct`SymManipulator`Private`TexFundOp", "[", "TT", "]"}]}], 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", 
               RowBox[{"curlcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"StringJoin", "[", 
               RowBox[{"\"\<\\\\iscurl\>\"", ",", 
                RowBox[{"SpatialTexValenceNumbers", "[", 
                 RowBox[{"TT", ",", "spin"}], "]"}], ",", 
                RowBox[{
                "xAct`SymManipulator`Private`TexFundOp", "[", "TT", "]"}]}], 
               "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xAct`SymManipulator`Private`TexFundOp", "[", 
               RowBox[{"twistcd", "[", 
                RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "^:=", 
              RowBox[{"StringJoin", "[", 
               RowBox[{"\"\<\\\\istwist\>\"", ",", 
                RowBox[{"SpatialTexValenceNumbers", "[", 
                 RowBox[{"TT", ",", "spin"}], "]"}], ",", 
                RowBox[{
                "xAct`SymManipulator`Private`TexFundOp", "[", "TT", "]"}]}], 
               "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
           "xAct`SymManipulator`Private`TexFundOp", "[", "expr_", "]"}], ":=", 
           RowBox[{"xAct`TexAct`Tex", "@", "expr"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"xAct`TexAct`Tex", "[", 
            RowBox[{"x", ":", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"divcd", "|", "curlcd", "|", "twistcd"}], ")"}], "[", 
               "_", "]"}], ")"}]}], "]"}], ":=", 
           RowBox[{"StringJoin", "[", 
            RowBox[{"\"\<(\>\"", ",", 
             RowBox[{"xAct`SymManipulator`Private`TexFundOp", "@", "x"}], 
             ",", "\"\<)\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Translating", " ", "between", " ", "3", "D", " ", "and", " ", "4",
             "D"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SenCovDQ", "[", "covd", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"Evaluate", "[", 
               RowBox[{"SymbolJoin", "[", 
                RowBox[{"DirOp", ",", "\"\<ToFundSpinOpRule\>\""}], "]"}], 
               "]"}], "=", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"DirOp", "[", "\[Phi]_", "]"}], ":>", 
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "k"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "0", ",", "1", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"curldgCD", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"twistCD", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}],
                  "]"}]}], "}"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SenCovDQ", "[", "covd", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"Evaluate", "[", 
               RowBox[{"SymbolJoin", "[", 
                RowBox[{"\"\<FundSpinOpToSenRules\>\"", ",", "covd"}], "]"}], 
               "]"}], "=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"twistCD", "[", 
                  RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], ":>", 
                 RowBox[{
                  RowBox[{"With", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                    RowBox[{"TensorPlus", "[", 
                    RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "0", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"DirOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], "*", 
                    RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "0", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}], "/;", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}], ")"}]}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"curldgCD", "[", 
                  RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], ":>", 
                 RowBox[{
                  RowBox[{"With", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                    RowBox[{"TensorPlus", "[", 
                    RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"DirOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "/", "k"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "0", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}], "/;", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}], ")"}]}]}]}], 
               "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Evaluate", "[", 
               RowBox[{"SymbolJoin", "[", 
                RowBox[{"\"\<SenToFundSpinOpRules\>\"", ",", "covd"}], "]"}], 
               "]"}], "=", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"twistcd", "[", 
                  RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], ":>", 
                 RowBox[{
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "0", ",", "1", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"twistCD", "[", "\[Phi]", "]"}], "]"}]}], "]"}], "/;", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}], ")"}]}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"curlcd", "[", 
                  RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], ":>", 
                 RowBox[{
                  RowBox[{"Module", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                    RowBox[{"TensorPlus", "[", 
                    RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], "/", "2"}], ",", 
                    
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"twistCD", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "k"}], "+", "2"}], ")"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "0", ",", "1", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"curldgCD", "[", "\[Phi]", "]"}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}], "/;", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}], ")"}]}]}], ",", 
                RowBox[{
                 RowBox[{"divcd", "[", 
                  RowBox[{"\[Phi]_", "?", "xTensorQ"}], "]"}], ":>", 
                 RowBox[{
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "1", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{"curldgCD", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                  "/;", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}], ")"}]}]}]}], "}"}]}], 
             ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "4", "D", " ", "derivatives", " ", "of", " ", "the", " ", 
            "normal"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SenCovDQ", "[", "covd", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"FundSpinOpNormalRules", "[", "Ns", "]"}], "^=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"divCD", "[", "Ns", "]"}], "->", "Omega0"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"curlCD", "[", "Ns", "]"}], "->", 
                 RowBox[{"MultScal", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", "Accname"}], 
                  "]"}]}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"curldgCD", "[", "Ns", "]"}], "->", 
                 RowBox[{"MultScal", "[", 
                  RowBox[{
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                   RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                    "[", "Accname", "]"}], "]"}]}], "]"}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"twistCD", "[", "Ns", "]"}], "->", 
                 RowBox[{"TensorPlus", "[", 
                  RowBox[{
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "3"}], "*", 
                    RowBox[{"1", "/", "normsqr"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "0", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "0", ",", "0", ",", "spin"}], "]"}], 
                    "[", "Omega0", "]"}], "]"}]}], "]"}], ",", 
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "0", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                    "[", "Accname", "]"}], "]"}]}], "]"}], ",", 
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"2", "/", "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                    "[", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Ns", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                    "[", "Omega4", "]"}], "]"}]}], "]"}]}], "]"}]}]}], 
               "}"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Translation", " ", "between", " ", "intrinsic", " ", "and", " ", 
            "Sen", " ", "connection", " ", "if", " ", "both", " ", "are", " ", 
            RowBox[{"defined", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SubsetQ", "[", 
             RowBox[{"$FundSpatialSpinOpCovDs", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"IntrinsicCovDOfNormalSpinor", "[", "Ns", "]"}], ",", 
                
                RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}]}], "}"}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"With", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"IntDiv", "=", 
                  RowBox[{"DivName", "@", 
                   RowBox[{
                   "IntrinsicCovDOfNormalSpinor", "[", "Ns", "]"}]}]}], ",", 
                 RowBox[{"IntCurl", "=", 
                  RowBox[{"CurlName", "@", 
                   RowBox[{
                   "IntrinsicCovDOfNormalSpinor", "[", "Ns", "]"}]}]}], ",", 
                 RowBox[{"IntTwist", "=", 
                  RowBox[{"TwistName", "@", 
                   RowBox[{
                   "IntrinsicCovDOfNormalSpinor", "[", "Ns", "]"}]}]}], ",", 
                 RowBox[{"SenDiv", "=", 
                  RowBox[{"DivName", "@", 
                   RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}]}]}], ",", 
                 RowBox[{"SenCurl", "=", 
                  RowBox[{"CurlName", "@", 
                   RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}]}]}], ",", 
                 RowBox[{"SenTwist", "=", 
                  RowBox[{"TwistName", "@", 
                   RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}]}]}], ",", 
                 RowBox[{"Omega4Sen", "=", 
                  RowBox[{"Omega4NameOfCovD", "@", 
                   RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}]}]}], ",", 
                 RowBox[{"Omega0Sen", "=", 
                  RowBox[{"Omega0NameOfCovD", "@", 
                   RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}]}]}]}], 
                "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"Evaluate", "[", 
                  RowBox[{"SymbolJoin", "[", 
                   RowBox[{"\"\<FundSpatial\>\"", ",", 
                    RowBox[{"IntrinsicCovDOfNormalSpinor", "[", "Ns", "]"}], 
                    ",", "\"\<To\>\"", ",", 
                    RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}], ",", 
                    "\"\<Rule\>\""}], "]"}], "]"}], "=", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"IntDiv", "[", "\[Phi]_", "]"}], ":>", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                    RowBox[{"TensorPlus", "[", 
                    RowBox[{
                    RowBox[{"SenDiv", "[", "\[Phi]", "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}]}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4Sen", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                   ",", 
                   RowBox[{
                    RowBox[{"IntCurl", "[", "\[Phi]_", "]"}], ":>", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                    RowBox[{"TensorPlus", "[", 
                    RowBox[{
                    RowBox[{"SenCurl", "[", "\[Phi]", "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}], "/", "6"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0Sen", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}]}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4Sen", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                   ",", 
                   RowBox[{
                    RowBox[{"IntTwist", "[", "\[Phi]_", "]"}], ":>", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                    RowBox[{"TensorPlus", "[", 
                    RowBox[{
                    RowBox[{"SenTwist", "[", "\[Phi]", "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "k"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4Sen", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"Evaluate", "[", 
                  RowBox[{"SymbolJoin", "[", 
                   RowBox[{"\"\<FundSpatial\>\"", ",", 
                    RowBox[{"SenCovDOfNormalSpinor", "[", "Ns", "]"}], ",", 
                    "\"\<To\>\"", ",", 
                    RowBox[{"IntrinsicCovDOfNormalSpinor", "[", "Ns", "]"}], 
                    ",", "\"\<Rule\>\""}], "]"}], "]"}], "=", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SenDiv", "[", "\[Phi]_", "]"}], ":>", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                    RowBox[{"TensorPlus", "[", 
                    RowBox[{
                    RowBox[{"IntDiv", "[", "\[Phi]", "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4Sen", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                   ",", 
                   RowBox[{
                    RowBox[{"SenCurl", "[", "\[Phi]_", "]"}], ":>", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                    RowBox[{"TensorPlus", "[", 
                    RowBox[{
                    RowBox[{"IntCurl", "[", "\[Phi]", "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}]}], "/", "6"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0Sen", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4Sen", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                   ",", 
                   RowBox[{
                    RowBox[{"SenTwist", "[", "\[Phi]_", "]"}], ":>", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                    RowBox[{"TensorPlus", "[", 
                    RowBox[{
                    RowBox[{"IntTwist", "[", "\[Phi]", "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"k", "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4Sen", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], 
                    "]"}]}]}], "}"}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
              ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "IntrinsicCurvatureRules", " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SenCovDQ", "[", "covd", "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"Evaluate", "[", 
               RowBox[{"SymbolJoin", "[", 
                RowBox[{"\"\<IntrinsicCurvatureRules\>\"", ",", "covd"}], 
                "]"}], "]"}], "=", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"R0NameOfCovD", "[", "covd", "]"}], "->", 
                 RowBox[{"TensorPlus", "[", 
                  RowBox[{
                   RowBox[{"MultScal", "[", 
                    RowBox[{"12", ",", 
                    RowBox[{"Lambda", "[", "CD", "]"}]}], "]"}], ",", 
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"4", "/", "normsqr"}], ",", "SpatialPhi0"}], 
                    "]"}], ",", 
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"3", "*", "normsqr"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "Omega0", "]"}]}], "]"}], ",", 
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"normsqr", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "4", ",", "0", ",", "spin"}], 
                    "]"}], "[", "Omega4", "]"}]}], "]"}]}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"R4NameOfCovD", "[", "covd", "]"}], "->", 
                 RowBox[{"TensorPlus", "[", 
                  RowBox[{
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{"Psi", "[", "CD", "]"}]}], "]"}], ",", 
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "/", "normsqr"}], ",", 
                    "SpatialPhi4"}], "]"}], ",", 
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{"curlcd", "[", "Omega4", "]"}]}], "]"}], ",", 
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"2", "/", 
                    RowBox[{"(", 
                    RowBox[{"3", "*", "normsqr"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "Omega4", "]"}]}], "]"}], ",", 
                   RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "/", "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "Omega4", "]"}]}], "]"}]}], "]"}]}]}], 
               "}"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Indexfree", " ", "commutators"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SenCovDQ", "[", "covd", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"Sen", " ", "derivative", " ", "case"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"divcd", ",", "curlcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"divcd", "[", 
                RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}], "/", "k"}], ",", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "4", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", "k"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], "*", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", "2"}], "/", 
                    "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi2", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", "k"}], ")"}], "/", "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi4", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "3"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", " ", "k", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], "*", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "3"}], "*", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}], "/", "2"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "3", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}],
                  "]"}], "/;", 
                RowBox[{"And", "[", 
                 RowBox[{
                  RowBox[{"EnoughIndsQSpin", "[", 
                   RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}],
                   ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}]}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"curlcd", ",", "divcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"curlcd", "[", 
                RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}]}], ",", 
                    RowBox[{"divcd", "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"4", "-", 
                    RowBox[{"2", "*", "k"}]}], ")"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "4", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}]}], "/", "normsqr"}], 
                    ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi2", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"k", "/", "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi4", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "-", "k"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"2", "*", "k"}]}], ")"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"3", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "k"}], ")"}]}], ")"}]}], ")"}], 
                    "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", "k"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "3", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}],
                  "]"}], "/;", 
                RowBox[{"And", "[", 
                 RowBox[{
                  RowBox[{"EnoughIndsQSpin", "[", 
                   RowBox[{"\[Phi]", ",", "3", ",", "0", ",", "spin"}], "]"}],
                   ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}]}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"curlcd", ",", "twistcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"curlcd", "[", 
                RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                    RowBox[{"twistcd", "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "2"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"3", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"k", "/", "2"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "1", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"4", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", "k", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "/", "normsqr"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi2", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", "k", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "/", "normsqr"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi4", "]"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Simplify", "[", 
                    RowBox[{"k", "<=", "0"}], "]"}], ",", 
                    RowBox[{"ZeroTensorOfTensor", "[", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}], "/;", 
                RowBox[{
                 RowBox[{
                  RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                  "\[Phi]", "]"}], "===", "0"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"twistcd", ",", "curlcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"twistcd", "[", 
                RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", "k"}], ",", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"3", "*", "k"}], ")"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    RowBox[{"k", "/", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "1", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", "2"}], "/", 
                    "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi2", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi4", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}], 
                   "]"}]}], "]"}], "/;", 
                RowBox[{
                 RowBox[{"EnoughIndsQSpin", "[", 
                  RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                 "&&", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}], "===", "0"}]}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"divcd", ",", "twistcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"divcd", "[", 
                RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                    RowBox[{"twistcd", "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "4"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"2", "*", "k"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "/", "3"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", "k"}], ")"}], "/", "6"}], "*", 
                    RowBox[{"2", "/", "normsqr"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi0", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "/", "normsqr"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi2", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"2", "/", "normsqr"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi4", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "2", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "-", "k"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Lambda", "[", "CD", "]"}], ",", "0", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"3", "*", "k"}], "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}], 
                   "]"}]}], "]"}], "/;", 
                RowBox[{
                 RowBox[{"EnoughIndsQSpin", "[", 
                  RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                 "&&", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}], "===", "0"}]}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"twistcd", ",", "divcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"twistcd", "[", 
                RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "k", "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}]}], ",", 
                    RowBox[{"divcd", "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"4", "*", "k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "^", "2"}]}], ")"}]}], 
                    ",", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "k", "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}]}], ")"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "*", "k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "^", "2"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "*", "k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"3", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "k", "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}]}], ")"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"6", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}]}], ")"}]}], "*", 
                    RowBox[{"2", "/", "normsqr"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi0", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "k", "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}]}], "*", 
                    RowBox[{"2", "/", "normsqr"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi2", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], "*", 
                    RowBox[{"2", "/", "normsqr"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi4", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "2", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Lambda", "[", "CD", "]"}], ",", "0", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", "k"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}], 
                   "]"}]}], "]"}], "/;", 
                RowBox[{
                 RowBox[{"EnoughIndsQSpin", "[", 
                  RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}], 
                 "&&", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}], "===", "0"}]}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"curlcd", ",", "curlcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"curlcd", "[", 
                RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", "k"}], ")"}], "/", "4"}], ",", 
                    RowBox[{"divcd", "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "^", "2"}]}], ")"}], "/", 
                    
                    RowBox[{"(", 
                    RowBox[{"4", "*", "k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                    RowBox[{"twistcd", "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", "4"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "/", "2"}], "-", 
                    RowBox[{"k", "/", "2"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", "k"}], ")"}], "/", "6"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"24", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "^", "2"}], "*", 
                    RowBox[{"2", "/", "normsqr"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi0", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", "k"}], ")"}], "/", "4"}], "*", 
                    RowBox[{"2", "/", "normsqr"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi2", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", "4"}], "*", 
                    
                    RowBox[{"2", "/", "normsqr"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi4", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", "4"}], ",", 
                    
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "2", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"4", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "^", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Lambda", "[", "CD", "]"}], ",", "0", ",", "0", 
                    ",", "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"3", "*", "k"}], "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"4", "*", "k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}], 
                   "]"}]}], "]"}], "/;", 
                RowBox[{
                 RowBox[{"EnoughIndsQSpin", "[", 
                  RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                 "&&", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}], "===", "0"}]}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"DirOp", ",", "divcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"DirOp", "[", 
                RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"divcd", "[", 
                    RowBox[{"DirOp", "[", "\[Phi]", "]"}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"3", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{"Omega0", "[", "]"}]}], ",", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"DirOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "*", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", "/", "k"}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "*", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"6", "-", 
                    RowBox[{"5", "*", "k"}], "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "3", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "4", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    RowBox[{"k", "/", "2"}]}], ")"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"SpatialPhi2", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "k"}], ")"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"\[Phi]", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", "SpatialPhi4", "]"}]}], "]"}]}], "]"}]}], 
                 "]"}], "/;", 
                RowBox[{
                 RowBox[{"EnoughIndsQSpin", "[", 
                  RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}], 
                 "&&", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}], "===", "0"}]}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"DirOp", ",", "curlcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"DirOp", "[", 
                RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"curlcd", "[", 
                    RowBox[{"DirOp", "[", "\[Phi]", "]"}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"3", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{"Omega0", "[", "]"}]}], ",", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"DirOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"4", "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"6", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "*", "6", "*", 
                    RowBox[{
                    RowBox[{"Lambda", "[", "CD", "]"}], "[", "]"}]}], ")"}]}],
                     ",", "\[Phi]"}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "6"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", "2", "]"}], "*", 
                    RowBox[{"SpatialPhi0", "[", "]"}]}], ")"}]}], ",", 
                    "\[Phi]"}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"SpatialPhi2", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "k"}], ")"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"SpatialPhi4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "2", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ")"}]}], ")"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"3", "*", "k"}], "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", 
                    RowBox[{"k", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}], 
                   "]"}]}], "]"}], "/;", 
                RowBox[{
                 RowBox[{"EnoughIndsQSpin", "[", 
                  RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}], 
                 "&&", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}], "===", "0"}]}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"DirOp", ",", "twistcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"DirOp", "[", 
                RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"twistcd", "[", 
                    RowBox[{"DirOp", "[", "\[Phi]", "]"}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{"3", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], ")"}], "*", 
                    RowBox[{"Omega0", "[", "]"}]}], ",", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"DirOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "*", "k"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Accname", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "*", "k"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "normsqr", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{
                    RowBox[{"Psi", "[", "CD", "]"}], ",", "1", ",", "0", ",", 
                    "spin"}], "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", "/", "2"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"SpatialPhi2", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "k"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"SpatialPhi4", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Simplify", "[", 
                    RowBox[{"k", "<=", "0"}], "]"}], ",", 
                    RowBox[{"ZeroTensorOfTensor", "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "k"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}], "/;", 
                RowBox[{
                 RowBox[{
                  RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                  "\[Phi]", "]"}], "===", "0"}]}]}]}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"Intrinsic", " ", "derivative", " ", "case"}], " ", 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"divcd", ",", "curlcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"divcd", "[", 
                RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}], "/", "k"}], ",", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}]}], "/", "2"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R4Name", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
                RowBox[{"And", "[", 
                 RowBox[{
                  RowBox[{"EnoughIndsQSpin", "[", 
                   RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}],
                   ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}]}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"curlcd", ",", "divcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"curlcd", "[", 
                RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}]}], ",", 
                    RowBox[{"divcd", "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"k", "/", "2"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R4Name", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
                RowBox[{"And", "[", 
                 RowBox[{
                  RowBox[{"EnoughIndsQSpin", "[", 
                   RowBox[{"\[Phi]", ",", "3", ",", "0", ",", "spin"}], "]"}],
                   ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}]}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"curlcd", ",", "twistcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"curlcd", "[", 
                RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"k", "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                    RowBox[{"twistcd", "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "2"}], "*", "k"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R4Name", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}], "===", "0"}], ")"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"twistcd", ",", "curlcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"twistcd", "[", 
                RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", "k"}], ",", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", "2"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R4Name", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
                RowBox[{"And", "[", 
                 RowBox[{
                  RowBox[{"EnoughIndsQSpin", "[", 
                   RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}],
                   ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}]}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"divcd", ",", "twistcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"divcd", "[", 
                RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                    RowBox[{"twistcd", "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "4"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{"1", "-", "k"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R4Name", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", "k"}], ")"}], "/", "12"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R0Name", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
                RowBox[{"And", "[", 
                 RowBox[{
                  RowBox[{"EnoughIndsQSpin", "[", 
                   RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}],
                   ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}]}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"twistcd", ",", "divcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"twistcd", "[", 
                RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}]}], ")"}]}], ",", 
                    RowBox[{"divcd", "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"4", "*", "k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "^", "2"}]}], ")"}]}], 
                    ",", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R4Name", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"12", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R0Name", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
                RowBox[{"And", "[", 
                 RowBox[{
                  RowBox[{"EnoughIndsQSpin", "[", 
                   RowBox[{"\[Phi]", ",", "2", ",", "0", ",", "spin"}], "]"}],
                   ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}]}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"CommuteOp", "[", 
               RowBox[{"curlcd", ",", "curlcd"}], "]"}], "^=", 
              RowBox[{
               RowBox[{"curlcd", "[", 
                RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
               RowBox[{
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"k", "=", 
                    RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "\[Phi]"}]}], "}"}], ",", 
                  RowBox[{"TensorPlus", "[", 
                   RowBox[{
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", "k"}], ")"}], "/", "4"}], ",", 
                    RowBox[{"divcd", "[", 
                    RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "^", "2"}]}], ")"}], "/", 
                    
                    RowBox[{"(", 
                    RowBox[{"4", "*", "k", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}], ",", 
                    RowBox[{"twistcd", "[", 
                    RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "4"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R4Name", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}], ",", 
                    RowBox[{"MultScal", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "/", "48"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "^", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"R0Name", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", "\[Phi]", "]"}]}], "]"}]}], "]"}]}], "]"}], "/;", 
                RowBox[{"And", "[", 
                 RowBox[{
                  RowBox[{"EnoughIndsQSpin", "[", 
                   RowBox[{"\[Phi]", ",", "1", ",", "0", ",", "spin"}], "]"}],
                   ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", 
                    "\[Phi]", "]"}], "===", "0"}]}], "]"}]}]}]}], ";"}]}], 
           "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteOp", "[", 
            RowBox[{"HatNnOp", ",", "divcd"}], "]"}], "^=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"HatNnOp", "[", 
              RowBox[{"divcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
             RowBox[{
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"k", "=", 
                  RowBox[{
                   RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}]}], "}"}], ",", 
                RowBox[{"TensorPlus", "[", 
                 RowBox[{
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{"divcd", "[", 
                    RowBox[{"HatNnOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                  ",", 
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "3", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"HatNnOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}],
                  "]"}]}], "]"}], "/;", 
              RowBox[{
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
                 "]"}], "===", "0"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteOp", "[", 
            RowBox[{"HatNnOp", ",", "curlcd"}], "]"}], "^=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"HatNnOp", "[", 
              RowBox[{"curlcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
             RowBox[{
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"k", "=", 
                  RowBox[{
                   RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}]}], "}"}], ",", 
                RowBox[{"TensorPlus", "[", 
                 RowBox[{
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{"curlcd", "[", 
                    RowBox[{"HatNnOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                  ",", 
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k"}], ")"}], "/", "6"}], ")"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega0", ",", "0", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"HatNnOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                  ",", 
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "2", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"HatNnOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}],
                  "]"}]}], "]"}], "/;", 
              RowBox[{
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
                 "]"}], "===", "0"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteOp", "[", 
            RowBox[{"HatNnOp", ",", "twistcd"}], "]"}], "^=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"HatNnOp", "[", 
              RowBox[{"twistcd", "[", "\[Phi]_", "]"}], "]"}], ":>", 
             RowBox[{
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"k", "=", 
                  RowBox[{
                   RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", 
                   "\[Phi]", "]"}]}], "}"}], ",", 
                RowBox[{"TensorPlus", "[", 
                 RowBox[{
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{"twistcd", "[", 
                    RowBox[{"HatNnOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}], 
                  ",", 
                  RowBox[{"MultScal", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "2", "]"}], "/", 
                    RowBox[{"Sqrt", "[", "normsqr", "]"}]}], ")"}], "*", 
                    "k"}], ",", 
                    RowBox[{
                    RowBox[{"SymMult", "[", 
                    RowBox[{"Omega4", ",", "1", ",", "0", ",", "spin"}], 
                    "]"}], "[", 
                    RowBox[{"HatNnOp", "[", "\[Phi]", "]"}], "]"}]}], "]"}]}],
                  "]"}]}], "]"}], "/;", 
              RowBox[{
               RowBox[{
                RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
                 "]"}], "===", "0"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Expansion", " ", "of", " ", "the", " ", 
            RowBox[{"operators", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"expanddivcd", "[", 
            RowBox[{
             RowBox[{"divcd", "[", 
              RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "[", "inds___", "]"}], 
            "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"slotsTT", "=", 
                RowBox[{"SlotsOfTensor", "@", "TT"}]}], ",", "unprimedinds", 
               ",", 
               RowBox[{"A", "=", 
                RowBox[{"DummyIn", "@", "spin"}]}], ",", 
               RowBox[{"B", "=", 
                RowBox[{"DummyIn", "@", "spin"}]}], ",", "unprimedpos", ",", 
               "TTinds"}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"unprimedinds", "=", 
               RowBox[{"ExtractUnprimed", "[", 
                RowBox[{"{", "inds", "}"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"unprimedpos", "=", 
               RowBox[{"Select", "[", 
                RowBox[{
                 RowBox[{"Range", "@", 
                  RowBox[{"Length", "@", "slotsTT"}]}], ",", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"UpIndex", "[", 
                    RowBox[{"slotsTT", "[", 
                    RowBox[{"[", "#", "]"}], "]"}], "]"}], "\[Equal]", 
                    "spin"}], ")"}], "&"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"TTinds", "=", 
               RowBox[{
                RowBox[{"Range", "@", 
                 RowBox[{"Length", "@", "slotsTT"}]}], "/.", 
                RowBox[{"Thread", "[", 
                 RowBox[{"unprimedpos", "\[Rule]", 
                  RowBox[{"Join", "[", 
                   RowBox[{"unprimedinds", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "}"}]}], "]"}]}], "]"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"covd", "[", 
                RowBox[{"A", ",", "B"}], "]"}], "[", 
               RowBox[{"TT", "@@", "TTinds"}], "]"}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"expandcurlcd", "[", 
            RowBox[{
             RowBox[{"curlcd", "[", 
              RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "[", "inds___", "]"}], 
            "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"slotsTT", "=", 
                RowBox[{"SlotsOfTensor", "@", "TT"}]}], ",", "unprimedinds", 
               ",", 
               RowBox[{"A", "=", 
                RowBox[{"DummyIn", "@", "spin"}]}], ",", "unprimedpos", ",", 
               "TTinds"}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"unprimedinds", "=", 
               RowBox[{"ExtractUnprimed", "[", 
                RowBox[{"{", "inds", "}"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"unprimedpos", "=", 
               RowBox[{"Select", "[", 
                RowBox[{
                 RowBox[{"Range", "@", 
                  RowBox[{"Length", "@", "slotsTT"}]}], ",", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"UpIndex", "[", 
                    RowBox[{"slotsTT", "[", 
                    RowBox[{"[", "#", "]"}], "]"}], "]"}], "\[Equal]", 
                    "spin"}], ")"}], "&"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"TTinds", "=", 
               RowBox[{
                RowBox[{"Range", "@", 
                 RowBox[{"Length", "@", "slotsTT"}]}], "/.", 
                RowBox[{"Thread", "[", 
                 RowBox[{"unprimedpos", "\[Rule]", 
                  RowBox[{"Append", "[", 
                   RowBox[{
                    RowBox[{"Rest", "@", "unprimedinds"}], ",", 
                    RowBox[{"-", "A"}]}], "]"}]}], "]"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ToCanonicalSym", "@", 
               RowBox[{"ImposeSym", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"covd", "[", 
                   RowBox[{
                    RowBox[{"First", "@", "unprimedinds"}], ",", "A"}], "]"}],
                   "[", 
                  RowBox[{"TT", "@@", "TTinds"}], "]"}], ",", 
                 RowBox[{"IndexList", "@@", "unprimedinds"}]}], "]"}]}]}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"expandtwistcd", "[", 
            RowBox[{
             RowBox[{"twistcd", "[", 
              RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "[", "inds___", "]"}], 
            "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"slotsTT", "=", 
                RowBox[{"SlotsOfTensor", "@", "TT"}]}], ",", "unprimedinds", 
               ",", "unprimedpos", ",", "TTinds"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"unprimedinds", "=", 
               RowBox[{"ExtractUnprimed", "[", 
                RowBox[{"{", "inds", "}"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"unprimedpos", "=", 
               RowBox[{"Select", "[", 
                RowBox[{
                 RowBox[{"Range", "@", 
                  RowBox[{"Length", "@", "slotsTT"}]}], ",", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"UpIndex", "[", 
                    RowBox[{"slotsTT", "[", 
                    RowBox[{"[", "#", "]"}], "]"}], "]"}], "\[Equal]", 
                    "spin"}], ")"}], "&"}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"TTinds", "=", 
               RowBox[{
                RowBox[{"Range", "@", 
                 RowBox[{"Length", "@", "slotsTT"}]}], "/.", 
                RowBox[{"Thread", "[", 
                 RowBox[{"unprimedpos", "\[Rule]", 
                  RowBox[{"Join", "[", 
                   RowBox[{"Rest", "@", 
                    RowBox[{"Rest", "@", "unprimedinds"}]}], "]"}]}], 
                 "]"}]}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"ToCanonicalSym", "@", 
               RowBox[{"ImposeSym", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"covd", "@@", 
                    RowBox[{"Take", "[", 
                    RowBox[{"unprimedinds", ",", "2"}], "]"}]}], ")"}], "[", 
                  RowBox[{"TT", "@@", "TTinds"}], "]"}], ",", 
                 RowBox[{"IndexList", "[", "inds", "]"}]}], "]"}]}]}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"$expandfundspinoprulescd", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"x", ":", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"divcd", "[", 
                  RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "[", "inds___", 
                 "]"}], ")"}]}], ":>", 
              RowBox[{"expanddivcd", "[", "x", "]"}]}], ",", 
             RowBox[{
              RowBox[{"x", ":", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"curlcd", "[", 
                  RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "[", "inds___", 
                 "]"}], ")"}]}], ":>", 
              RowBox[{"expandcurlcd", "[", "x", "]"}]}], ",", 
             RowBox[{
              RowBox[{"x", ":", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"twistcd", "[", 
                  RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "[", "inds___", 
                 "]"}], ")"}]}], ":>", 
              RowBox[{"expandtwistcd", "[", "x", "]"}]}]}], "}"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Imposing", " ", "Twist"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ImposeFundSpinOp", "[", 
            RowBox[{"expr1_", ",", "twistcd", ",", " ", "iinds_"}], "]"}], ":=",
            "\[IndentingNewLine]", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"unprimedinds1", ",", "irrdecexpr", ",", " ", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{
                 "If", " ", "the", " ", "expression", " ", "is", " ", "an", 
                  " ", "expanded", " ", "symmetry"}], ",", " ", 
                 RowBox[{
                 "it", " ", "is", " ", "important", " ", "that", " ", "we", 
                  " ", "do", " ", "the", " ", "contractions", " ", "with", 
                  " ", "the", " ", "same", " ", "index", " ", "on", " ", 
                  "all", " ", 
                  RowBox[{"terms", ".", " ", "Therefore"}]}], ",", " ", 
                 RowBox[{
                 "we", " ", "sort", " ", "the", " ", "free", " ", "indices", 
                  " ", "so", " ", "the", " ", "contraction", " ", "is", " ", 
                  "done", " ", "with", " ", "the", " ", "same", " ", "index", 
                  " ", "on", " ", "all", " ", 
                  RowBox[{"terms", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{"frees", "=", 
                RowBox[{"Sort", "[", 
                 RowBox[{"List", "@@", 
                  RowBox[{"FindFreeIndices", "@", 
                   RowBox[{"Evaluate", "[", "expr1", "]"}]}]}], "]"}]}], ",", 
               " ", "unprimedfrees", ",", 
               RowBox[{"indexrules", "=", 
                RowBox[{"{", "}"}]}], ",", " ", "intexpr"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"unprimedinds1", "=", 
               RowBox[{"ExtractUnprimed", "[", "iinds", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"unprimedfrees", "=", 
               RowBox[{"ExtractUnprimed", "[", "frees", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"indexrules", "=", 
               RowBox[{"Thread", "@", 
                RowBox[{"Rule", "[", 
                 RowBox[{"unprimedfrees", ",", 
                  RowBox[{"Rest", "@", 
                   RowBox[{"Rest", "@", "unprimedinds1"}]}]}], "]"}]}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"intexpr", "=", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"covd", "@@", 
                  RowBox[{"Take", "[", 
                   RowBox[{"unprimedinds1", ",", "2"}], "]"}]}], ")"}], "[", 
                RowBox[{"ReplaceIndex", "[", 
                 RowBox[{"expr1", ",", "indexrules"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"intexpr", "=", 
               RowBox[{"ToFundSpinOp", "[", 
                RowBox[{"intexpr", ",", "covd"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ImposeSym", "[", 
               RowBox[{"intexpr", ",", 
                RowBox[{"IndexList", "@@", "unprimedinds1"}]}], "]"}]}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Imposing", " ", "Curl"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ImposeFundSpinOp", "[", 
            RowBox[{"expr1_", ",", "curlcd", ",", " ", "iinds_"}], "]"}], ":=",
            "\[IndentingNewLine]", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"unprimedinds1", ",", "irrdecexpr", ",", " ", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{
                 "If", " ", "the", " ", "expression", " ", "is", " ", "an", 
                  " ", "expanded", " ", "symmetry"}], ",", " ", 
                 RowBox[{
                 "it", " ", "is", " ", "important", " ", "that", " ", "we", 
                  " ", "do", " ", "the", " ", "contractions", " ", "with", 
                  " ", "the", " ", "same", " ", "index", " ", "on", " ", 
                  "all", " ", 
                  RowBox[{"terms", ".", " ", "Therefore"}]}], ",", " ", 
                 RowBox[{
                 "we", " ", "sort", " ", "the", " ", "free", " ", "indices", 
                  " ", "so", " ", "the", " ", "contraction", " ", "is", " ", 
                  "done", " ", "with", " ", "the", " ", "same", " ", "index", 
                  " ", "on", " ", "all", " ", 
                  RowBox[{"terms", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{"frees", "=", 
                RowBox[{"Sort", "[", 
                 RowBox[{"List", "@@", 
                  RowBox[{"FindFreeIndices", "@", 
                   RowBox[{"Evaluate", "[", "expr1", "]"}]}]}], "]"}]}], ",", 
               " ", "unprimedfrees", ",", 
               RowBox[{"indexrules", "=", 
                RowBox[{"{", "}"}]}], ",", " ", "intexpr", ",", 
               RowBox[{"A", "=", 
                RowBox[{"DummyIn", "@", "spin"}]}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"unprimedinds1", "=", 
               RowBox[{"ExtractUnprimed", "[", "iinds", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"unprimedfrees", "=", 
               RowBox[{"ExtractUnprimed", "[", "frees", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"indexrules", "=", 
               RowBox[{"Thread", "@", 
                RowBox[{"Rule", "[", 
                 RowBox[{"unprimedfrees", ",", 
                  RowBox[{"Append", "[", 
                   RowBox[{
                    RowBox[{"Rest", "@", "unprimedinds1"}], ",", 
                    RowBox[{"-", "A"}]}], "]"}]}], "]"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"intexpr", "=", 
               RowBox[{
                RowBox[{"covd", "[", 
                 RowBox[{
                  RowBox[{"First", "@", "unprimedinds1"}], ",", "A"}], "]"}], 
                "[", 
                RowBox[{"ReplaceIndex", "[", 
                 RowBox[{"expr1", ",", "indexrules"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"intexpr", "=", 
               RowBox[{"ToFundSpinOp", "[", 
                RowBox[{"intexpr", ",", "covd"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ImposeSym", "[", 
               RowBox[{"intexpr", ",", 
                RowBox[{"IndexList", "@@", "unprimedinds1"}]}], "]"}]}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Imposing", " ", "Div"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ImposeFundSpinOp", "[", 
            RowBox[{"expr1_", ",", "divcd", ",", " ", "iinds_"}], "]"}], ":=",
            "\[IndentingNewLine]", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"unprimedinds1", ",", "irrdecexpr", ",", " ", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{
                 "If", " ", "the", " ", "expression", " ", "is", " ", "an", 
                  " ", "expanded", " ", "symmetry"}], ",", " ", 
                 RowBox[{
                 "it", " ", "is", " ", "important", " ", "that", " ", "we", 
                  " ", "do", " ", "the", " ", "contractions", " ", "with", 
                  " ", "the", " ", "same", " ", "index", " ", "on", " ", 
                  "all", " ", 
                  RowBox[{"terms", ".", " ", "Therefore"}]}], ",", " ", 
                 RowBox[{
                 "we", " ", "sort", " ", "the", " ", "free", " ", "indices", 
                  " ", "so", " ", "the", " ", "contraction", " ", "is", " ", 
                  "done", " ", "with", " ", "the", " ", "same", " ", "index", 
                  " ", "on", " ", "all", " ", 
                  RowBox[{"terms", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{"frees", "=", 
                RowBox[{"Sort", "[", 
                 RowBox[{"List", "@@", 
                  RowBox[{"FindFreeIndices", "@", 
                   RowBox[{"Evaluate", "[", "expr1", "]"}]}]}], "]"}]}], ",", 
               " ", "unprimedfrees", ",", 
               RowBox[{"indexrules", "=", 
                RowBox[{"{", "}"}]}], ",", " ", "intexpr", ",", 
               RowBox[{"A", "=", 
                RowBox[{"DummyIn", "@", "spin"}]}], ",", 
               RowBox[{"B", "=", 
                RowBox[{"DummyIn", "@", "spin"}]}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"unprimedinds1", "=", 
               RowBox[{"ExtractUnprimed", "[", "iinds", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"unprimedfrees", "=", 
               RowBox[{"ExtractUnprimed", "[", "frees", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"indexrules", "=", 
               RowBox[{"Thread", "@", 
                RowBox[{"Rule", "[", 
                 RowBox[{"unprimedfrees", ",", 
                  RowBox[{"Join", "[", 
                   RowBox[{"unprimedinds1", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "}"}]}], "]"}]}], "]"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"intexpr", "=", 
               RowBox[{
                RowBox[{"covd", "[", 
                 RowBox[{"A", ",", "B"}], "]"}], "[", 
                RowBox[{"ReplaceIndex", "[", 
                 RowBox[{"expr1", ",", "indexrules"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"intexpr", "=", 
               RowBox[{"ToFundSpinOp", "[", 
                RowBox[{"intexpr", ",", "covd"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ImposeSym", "[", 
               RowBox[{"intexpr", ",", 
                RowBox[{"IndexList", "@@", "unprimedinds1"}]}], "]"}]}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"$irrdecrulescd", "=", 
           RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Commutators", " ", "with", " ", "indices", " ", "and", " ", 
            "boxes"}], " ", "*)"}], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "DivTwist", " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"divcd", ",", "twistcd"}], "]"}], "^=", 
           RowBox[{
            RowBox[{
             RowBox[{"divcd", "[", 
              RowBox[{"twistcd", "[", 
               RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "[", "inds___",
              "]"}], "\[RuleDelayed]", 
            RowBox[{
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"A", "=", 
                 RowBox[{"DummyIn", "[", "spin", "]"}]}], "}"}], ",", 
               RowBox[{"With", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"k", "=", 
                   RowBox[{
                    RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                    "TT"}]}], "}"}], ",", 
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"k", ">", "1"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "*", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}], "/", "k"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}]}], "*", 
                    RowBox[{
                    RowBox[{"twistcd", "[", 
                    RowBox[{"divcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                    "]"}]}], ",", "0"}], "]"}], "-", 
                  RowBox[{
                   RowBox[{"4", "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}]}], 
                   RowBox[{
                    RowBox[{"curlcd", "[", 
                    RowBox[{"curlcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                    "]"}]}], "-", 
                  RowBox[{"2", "*", 
                   RowBox[{"ToCanonicalSym", "@", 
                    RowBox[{"ImposeSym", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"boxcd", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"First", "@", 
                    RowBox[{"{", "inds", "}"}]}]}], "]"}], ")"}], "[", 
                    RowBox[{"TT", "[", 
                    RowBox[{
                    RowBox[{"Sequence", "@@", 
                    RowBox[{"Rest", "[", 
                    RowBox[{"{", "inds", "}"}], "]"}]}], ",", 
                    RowBox[{"-", "A"}]}], "]"}], "]"}], ",", 
                    RowBox[{"IndexList", "[", "inds", "]"}]}], "]"}]}]}]}]}], 
                "]"}]}], "]"}], "/;", 
             RowBox[{
              RowBox[{
               RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}], 
              "\[GreaterEqual]", "1"}]}]}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "TwistDiv", " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"twistcd", ",", "divcd"}], "]"}], "^=", 
           RowBox[{
            RowBox[{
             RowBox[{"twistcd", "[", 
              RowBox[{"divcd", "[", 
               RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "[", "inds___",
              "]"}], "\[RuleDelayed]", 
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"A", "=", 
                RowBox[{"DummyIn", "[", "spin", "]"}]}], "}"}], ",", 
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"k", "=", 
                  RowBox[{
                   RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                   "TT"}]}], "}"}], ",", 
                RowBox[{
                 RowBox[{"k", "*", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}]}], "/", 
                   RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}]}], "*", 
                  RowBox[{
                   RowBox[{"divcd", "[", 
                    RowBox[{"twistcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                   "]"}]}], "+", 
                 RowBox[{"4", "*", "k", "*", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}]}], "/", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}], "^", "2"}]}], "*", 
                  RowBox[{
                   RowBox[{"curlcd", "[", 
                    RowBox[{"curlcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                   "]"}]}], "+", 
                 RowBox[{"2", "*", "k", "*", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}]}], "/", 
                   RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}]}], "*", 
                  RowBox[{"ToCanonicalSym", "@", 
                   RowBox[{"ImposeSym", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"boxcd", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"First", "@", 
                    RowBox[{"{", "inds", "}"}]}]}], "]"}], ")"}], "[", 
                    RowBox[{"TT", "[", 
                    RowBox[{
                    RowBox[{"Sequence", "@@", 
                    RowBox[{"Rest", "[", 
                    RowBox[{"{", "inds", "}"}], "]"}]}], ",", 
                    RowBox[{"-", "A"}]}], "]"}], "]"}], ",", 
                    RowBox[{"IndexList", "[", "inds", "]"}]}], "]"}]}]}]}]}], 
               "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "CurlCurl", " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"curlcd", ",", "curlcd"}], "]"}], "^=", 
           RowBox[{
            RowBox[{
             RowBox[{"curlcd", "[", 
              RowBox[{"curlcd", "[", 
               RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "[", "inds___",
              "]"}], "\[RuleDelayed]", 
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"A", "=", 
                RowBox[{"DummyIn", "[", "spin", "]"}]}], "}"}], ",", 
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"k", "=", 
                  RowBox[{
                   RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                   "TT"}]}], "}"}], ",", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"k", ">", "1"}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "*", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}], "^", "2"}], "/", "4"}], 
                    "/", "k"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}]}], "*", 
                    RowBox[{
                    RowBox[{"twistcd", "[", 
                    RowBox[{"divcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                    "]"}]}], ",", "0"}], "]"}], "-", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}], "/", "4"}], "*", 
                  RowBox[{
                   RowBox[{"divcd", "[", 
                    RowBox[{"twistcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                   "]"}]}], "-", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "2"}], ")"}], "/", "2"}], "*", 
                  RowBox[{"ToCanonicalSym", "@", 
                   RowBox[{"ImposeSym", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"boxcd", "[", 
                    RowBox[{"A", ",", 
                    RowBox[{"First", "@", 
                    RowBox[{"{", "inds", "}"}]}]}], "]"}], ")"}], "[", 
                    RowBox[{"TT", "[", 
                    RowBox[{
                    RowBox[{"Sequence", "@@", 
                    RowBox[{"Rest", "[", 
                    RowBox[{"{", "inds", "}"}], "]"}]}], ",", 
                    RowBox[{"-", "A"}]}], "]"}], "]"}], ",", 
                    RowBox[{"IndexList", "[", "inds", "]"}]}], "]"}]}]}]}]}], 
               "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "DivCurl", " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"divcd", ",", "curlcd"}], "]"}], "^=", 
           RowBox[{
            RowBox[{
             RowBox[{"divcd", "[", 
              RowBox[{"curlcd", "[", 
               RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "[", "inds___",
              "]"}], "\[RuleDelayed]", 
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"A", "=", 
                 RowBox[{"DummyIn", "[", "spin", "]"}]}], ",", 
                RowBox[{"B", "=", 
                 RowBox[{"DummyIn", "[", "spin", "]"}]}]}], "}"}], ",", 
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"k", "=", 
                  RowBox[{
                   RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                   "TT"}]}], "}"}], ",", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"k", ">", "2"}], ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}], "/", "k"}], "*", 
                    RowBox[{
                    RowBox[{"curlcd", "[", 
                    RowBox[{"divcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                    "]"}]}], ",", "0"}], "]"}], "-", 
                 RowBox[{
                  RowBox[{"boxcd", "[", 
                   RowBox[{"A", ",", "B"}], "]"}], "[", 
                  RowBox[{"TT", "[", 
                   RowBox[{"inds", ",", 
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], "]"}]}]}], "]"}]}], 
             "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "CurlDiv", " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"curlcd", ",", "divcd"}], "]"}], "^=", 
           RowBox[{
            RowBox[{
             RowBox[{"curlcd", "[", 
              RowBox[{"divcd", "[", 
               RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "[", "inds___",
              "]"}], "\[RuleDelayed]", 
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"A", "=", 
                 RowBox[{"DummyIn", "[", "spin", "]"}]}], ",", 
                RowBox[{"B", "=", 
                 RowBox[{"DummyIn", "[", "spin", "]"}]}]}], "}"}], ",", 
              RowBox[{"With", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"k", "=", 
                  RowBox[{
                   RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                   "TT"}]}], "}"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"k", "/", 
                   RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}]}], "*", 
                  RowBox[{
                   RowBox[{"divcd", "[", 
                    RowBox[{"curlcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                   "]"}]}], "+", 
                 RowBox[{
                  RowBox[{"k", "/", 
                   RowBox[{"(", 
                    RowBox[{"k", "-", "2"}], ")"}]}], "*", 
                  RowBox[{
                   RowBox[{"boxcd", "[", 
                    RowBox[{"A", ",", "B"}], "]"}], "[", 
                   RowBox[{"TT", "[", 
                    RowBox[{"inds", ",", 
                    RowBox[{"-", "A"}], ",", 
                    RowBox[{"-", "B"}]}], "]"}], "]"}]}]}]}], "]"}]}], 
             "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "CurlTwist", " ", "*)"}], "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"curlcd", ",", "twistcd"}], "]"}], "^=", 
           RowBox[{
            RowBox[{
             RowBox[{"curlcd", "[", 
              RowBox[{"twistcd", "[", 
               RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "[", "inds___",
              "]"}], "\[RuleDelayed]", 
            RowBox[{"With", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"k", "=", 
                RowBox[{
                 RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                 "TT"}]}], "}"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"k", "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "2"}], ")"}]}], 
                RowBox[{
                 RowBox[{"twistcd", "[", 
                  RowBox[{"curlcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                 "]"}]}], "-", 
               RowBox[{"ToCanonicalSym", "@", 
                RowBox[{"ImposeSym", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"boxcd", "@@", 
                    RowBox[{"Take", "[", 
                    RowBox[{
                    RowBox[{"{", "inds", "}"}], ",", "2"}], "]"}]}], ")"}], 
                   "[", 
                   RowBox[{"TT", "@@", 
                    RowBox[{"Drop", "[", 
                    RowBox[{
                    RowBox[{"{", "inds", "}"}], ",", "2"}], "]"}]}], "]"}], 
                  ",", 
                  RowBox[{"IndexList", "[", "inds", "]"}]}], "]"}]}]}]}], 
             "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"curlcd", ",", "twistcd", ",", "twistcd", ",", "curlcd"}],
             "]"}], "^=", 
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"curlcd", ",", "twistcd"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", "TwistCurl", " ", "*)"}], "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"twistcd", ",", "curlcd"}], "]"}], "^=", 
           RowBox[{
            RowBox[{
             RowBox[{"twistcd", "[", 
              RowBox[{"curlcd", "[", 
               RowBox[{"TT_", "?", "xTensorQ"}], "]"}], "]"}], "[", "inds___",
              "]"}], "\[RuleDelayed]", 
            RowBox[{
             RowBox[{"With", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"k", "=", 
                 RowBox[{
                  RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", 
                  "TT"}]}], "}"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"k", "+", "2"}], ")"}], "/", "k"}], "*", 
                 RowBox[{
                  RowBox[{"curlcd", "[", 
                   RowBox[{"twistcd", "[", "TT", "]"}], "]"}], "[", "inds", 
                  "]"}]}], "+", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"k", "+", "2"}], ")"}], "/", "k"}], "*", 
                 RowBox[{"ToCanonicalSym", "@", 
                  RowBox[{"ImposeSym", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"boxcd", "@@", 
                    RowBox[{"Take", "[", 
                    RowBox[{
                    RowBox[{"{", "inds", "}"}], ",", "2"}], "]"}]}], ")"}], 
                    "[", 
                    RowBox[{"TT", "@@", 
                    RowBox[{"Drop", "[", 
                    RowBox[{
                    RowBox[{"{", "inds", "}"}], ",", "2"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"IndexList", "[", "inds", "]"}]}], "]"}]}]}]}]}], 
              "]"}], "/;", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "@", "TT"}],
                ">", "0"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"twistcd", ",", "curlcd", ",", "curlcd", ",", "twistcd"}],
             "]"}], "^=", 
           RowBox[{"CommuteFundSpinOp", "[", 
            RowBox[{"twistcd", ",", "curlcd"}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.587796849512375*^9, 3.5877969429595394`*^9}, {
   3.587797035470702*^9, 3.5877971333628745`*^9}, {3.5877972266364384`*^9, 
   3.587797278257929*^9}, {3.587797328272617*^9, 3.5877974421548166`*^9}, {
   3.587797527456767*^9, 3.5877980794913373`*^9}, {3.587798332295781*^9, 
   3.5877984885944557`*^9}, {3.5877985241791186`*^9, 
   3.5877987453447075`*^9}, {3.5877988019894066`*^9, 
   3.5877990347770157`*^9}, {3.5877990799088955`*^9, 3.587799251980198*^9}, {
   3.5878126592567286`*^9, 3.587812833045034*^9}, {3.5878129270683994`*^9, 
   3.587813104149311*^9}, {3.5878131414187765`*^9, 3.587813313615879*^9}, {
   3.5878133441305323`*^9, 3.587813347422138*^9}, {3.5878138139685583`*^9, 
   3.5878138195845685`*^9}, {3.587813867119852*^9, 3.5878138993963084`*^9}, {
   3.587962937150714*^9, 3.5879629949488153`*^9}, {3.587963035274886*^9, 
   3.5879630522009163`*^9}, {3.5879633948555183`*^9, 
   3.5879634188795605`*^9}, {3.5879634593772316`*^9, 
   3.5879635555670004`*^9}, {3.5879636803984194`*^9, 3.587963681771222*^9}, {
   3.5879656781545286`*^9, 3.5879657028337717`*^9}, {3.587965944259796*^9, 
   3.5879659446497965`*^9}, {3.5880580491087914`*^9, 
   3.5880581004640813`*^9}, {3.5880581319761367`*^9, 
   3.5880581404625516`*^9}, {3.5880582224874954`*^9, 3.58805830462164*^9}, {
   3.588058335806095*^9, 3.5880583812801743`*^9}, {3.5880585920531445`*^9, 
   3.588058687213312*^9}, {3.588058746353016*^9, 3.588058795399502*^9}, {
   3.5880597345367517`*^9, 3.58805976778041*^9}, {3.588059906667454*^9, 
   3.5880599319706984`*^9}, {3.5880605022141*^9, 3.588060504788104*^9}, {
   3.588061943283231*^9, 3.5880619646552687`*^9}, {3.5880620038737373`*^9, 
   3.5880620387397985`*^9}, {3.588062154164401*^9, 3.58806217049763*^9}, {
   3.5880625719175353`*^9, 3.5880626468132668`*^9}, {3.588062766044276*^9, 
   3.5880628298171883`*^9}, {3.5884221096646595`*^9, 
   3.5884223296562457`*^9}, {3.5884223954103613`*^9, 3.588422487481723*^9}, {
   3.588587592565319*^9, 3.5885876272129803`*^9}, {3.5885876804402733`*^9, 
   3.588587910603078*^9}, {3.588587948433144*^9, 3.5885880505821238`*^9}, {
   3.5885880906273937`*^9, 3.588588099176209*^9}, {3.588588143043486*^9, 
   3.5885882053811955`*^9}, {3.588588236066449*^9, 3.5885883500558496`*^9}, {
   3.5885884183215694`*^9, 3.5885885288633633`*^9}, {3.588588561483021*^9, 
   3.5885886588281918`*^9}, {3.5885887196682987`*^9, 
   3.5885887697287865`*^9}, {3.588588807449653*^9, 3.5885889398626857`*^9}, {
   3.588589036629656*^9, 3.5885890391100597`*^9}, {3.5885891650802813`*^9, 
   3.588589350393007*^9}, {3.588589539512139*^9, 3.5885895527721624`*^9}, {
   3.5885897315962763`*^9, 3.5885897583347235`*^9}, 3.5885898885013523`*^9, {
   3.588590053534042*^9, 3.5885900675116663`*^9}, {3.5885901105053415`*^9, 
   3.5885901830454693`*^9}, {3.588590344084552*^9, 3.588590392943838*^9}, {
   3.5885905929049892`*^9, 3.5885907760181108`*^9}, {3.5885908289344034`*^9, 
   3.5885908706176767`*^9}, {3.5885909725794563`*^9, 
   3.5885910581924067`*^9}, {3.588596422415507*^9, 3.588596439747137*^9}, {
   3.5885964834272137`*^9, 3.5885964996824427`*^9}, {3.5885965367013073`*^9, 
   3.588596700985196*^9}, {3.588596949727633*^9, 3.5885970957750893`*^9}, {
   3.5885990893201914`*^9, 3.5885990935165987`*^9}, {3.5891204330535717`*^9, 
   3.5891204389659824`*^9}, {3.589783474795376*^9, 3.589783509037436*^9}, {
   3.5897836321538525`*^9, 3.5897836835091424`*^9}, {3.589783814268572*^9, 
   3.589783822271386*^9}, {3.5897874219633284`*^9, 3.589787433366949*^9}, 
   3.589787574937197*^9, {3.589894074428589*^9, 3.589894172615162*^9}, {
   3.5898942180424414`*^9, 3.5898942725957375`*^9}, {3.589894305542995*^9, 
   3.5898943185222178`*^9}, {3.589894352795478*^9, 3.58989443375962*^9}, {
   3.5898944726816883`*^9, 3.5898944736488905`*^9}, {3.5901493219371023`*^9, 
   3.5901494695601616`*^9}, {3.5901495196986494`*^9, 3.590149581037957*^9}, {
   3.5901496763697248`*^9, 3.5901500754184256`*^9}, {3.5901501273041167`*^9, 
   3.5901502759411783`*^9}, {3.5901505376004376`*^9, 
   3.5901508268249454`*^9}, {3.5901508689138193`*^9, 3.590150951454564*^9}, {
   3.5901511018700285`*^9, 3.590151170400949*^9}, {3.5901512092606173`*^9, 
   3.59015122799625*^9}, {3.590151380611318*^9, 3.590151451794243*^9}, {
   3.590151559808833*^9, 3.590151578107665*^9}, {3.5901516835794506`*^9, 
   3.59015179145364*^9}, {3.5901524166715384`*^9, 3.5901524174047394`*^9}, {
   3.590214743665763*^9, 3.5902147796698217`*^9}, {3.5902148719420996`*^9, 
   3.590214965692462*^9}, {3.5902150017935266`*^9, 3.590215043206896*^9}, {
   3.590215093675782*^9, 3.590215268972809*^9}, {3.5902153041628213`*^9, 
   3.590215394215972*^9}, {3.590215485688204*^9, 3.5902155215402546`*^9}, {
   3.590215720644643*^9, 3.5902157831672187`*^9}, {3.590215825532642*^9, 
   3.5902158330610723`*^9}, {3.5902163407191086`*^9, 3.590216573325413*^9}, {
   3.5902175313012066`*^9, 3.590217532681285*^9}, {3.5902175635540514`*^9, 
   3.590217564596111*^9}, {3.590219869944969*^9, 3.590219901539776*^9}, {
   3.590220028614044*^9, 3.5902200293790884`*^9}, {3.5902223236148486`*^9, 
   3.5902223268908544`*^9}, {3.5902223736597366`*^9, 
   3.5902223782461443`*^9}, {3.590222472953911*^9, 3.5902224790067215`*^9}, {
   3.5902225291452093`*^9, 3.590222692758297*^9}, {3.590237640893194*^9, 
   3.5902376586928253`*^9}, {3.590237915250876*^9, 3.590238019334259*^9}, {
   3.590238482343072*^9, 3.590238547441986*^9}, {3.59023857783084*^9, 
   3.5902386108092976`*^9}, {3.590238674223409*^9, 3.590238795264022*^9}, {
   3.590238834872491*^9, 3.5902390287028313`*^9}, {3.5902391913331175`*^9, 
   3.5902392986935062`*^9}, {3.5902394081588984`*^9, 
   3.5902394714326096`*^9}, {3.590239504879068*^9, 3.5902395528023524`*^9}, {
   3.5902396655905504`*^9, 3.5902397974419823`*^9}, {3.5902398371284513`*^9, 
   3.5902398598420916`*^9}, {3.590239936890627*^9, 3.590240055201235*^9}, {
   3.5902400894432945`*^9, 3.5902401786910515`*^9}, {3.5902402680324087`*^9, 
   3.5902403446909432`*^9}, {3.5906856508367624`*^9, 3.590685652106764*^9}, 
   3.591097598296443*^9, {3.5911012114490833`*^9, 3.591101232409113*^9}, 
   3.5921236916738486`*^9, {3.592123727703899*^9, 3.5921237294539013`*^9}, {
   3.592123895074133*^9, 3.592123924274174*^9}, {3.5921239560242186`*^9, 
   3.5921239701242385`*^9}, {3.5921260215281105`*^9, 3.592126044238142*^9}, {
   3.5921275927213097`*^9, 3.59212764961139*^9}, {3.592127690731447*^9, 
   3.5921277380015135`*^9}, {3.5921281722021217`*^9, 3.5921281812921343`*^9}, 
   3.5921283738334036`*^9, {3.592128804744007*^9, 3.5921288290440407`*^9}, {
   3.592220023523758*^9, 3.5922200278437643`*^9}, {3.592222312167962*^9, 
   3.5922223127679634`*^9}, 3.592222345018008*^9, {3.5922224499881554`*^9, 
   3.5922224639181747`*^9}, {3.5922225243282595`*^9, 3.592222556428304*^9}, {
   3.592225370726246*^9, 3.592225397846284*^9}, {3.592226258667489*^9, 
   3.5922262608274918`*^9}, {3.592226314317567*^9, 3.592226315067568*^9}, {
   3.5922263526576204`*^9, 3.592226441548745*^9}, 3.5922273826500626`*^9, {
   3.592227445800151*^9, 3.5922274724101877`*^9}, {3.59222751656025*^9, 
   3.5922275365102777`*^9}, {3.5972097728456564`*^9, 
   3.5972097735788574`*^9}, {3.597209804560512*^9, 3.597209804654112*^9}, 
   3.597209890703863*^9, 3.597210022914096*^9, {3.597210506873746*^9, 
   3.5972105410846057`*^9}, {3.5972107685798054`*^9, 
   3.5972109341428957`*^9}, {3.597210971068161*^9, 3.5972109799757767`*^9}, {
   3.5981720988374815`*^9, 3.598172153047557*^9}, {3.598172188808607*^9, 
   3.5981722033686275`*^9}, {3.5981789494962063`*^9, 
   3.5981789590962195`*^9}, {3.598179110836432*^9, 3.5981791137764363`*^9}, {
   3.5981793021767*^9, 3.598179408426849*^9}, {3.598180602999522*^9, 
   3.5981806574195986`*^9}, {3.598181218660384*^9, 3.598181221350388*^9}, {
   3.5981813515205708`*^9, 3.598181406280647*^9}, {3.598181677062026*^9, 
   3.5981817114620743`*^9}, {3.598182010032492*^9, 3.598182044892541*^9}, {
   3.5981820850625973`*^9, 3.598182124752653*^9}, {3.5981821801327305`*^9, 
   3.5981824857431583`*^9}, {3.598182679263429*^9, 3.5981826798334303`*^9}, {
   3.5981828360236483`*^9, 3.598182843583659*^9}, {3.5981831610151033`*^9, 
   3.598183183725136*^9}, {3.598183277835267*^9, 3.5981833089453106`*^9}, {
   3.598189238565667*^9, 3.598189401765896*^9}, {3.5981894378769464`*^9, 
   3.5981895479771004`*^9}, {3.5981896186572*^9, 3.5981896306872163`*^9}, {
   3.5981897277073526`*^9, 3.5981901055578814`*^9}, {3.5981901454279375`*^9, 
   3.5981901929780035`*^9}, {3.5981902388180676`*^9, 3.598190260448098*^9}, {
   3.5992902293971977`*^9, 3.5992902308272*^9}, {3.5992903153973184`*^9, 
   3.5992903577073774`*^9}, {3.5992948559063244`*^9, 
   3.5992949227764177`*^9}, {3.599294953736461*^9, 3.599295069926624*^9}, {
   3.5992951923567953`*^9, 3.599295254426882*^9}, {3.599295296266941*^9, 
   3.599295655907444*^9}, {3.5992957068975153`*^9, 3.599295752217579*^9}, {
   3.5992958493877153`*^9, 3.59929590300879*^9}, {3.5992959799529257`*^9, 
   3.5992961227311335`*^9}, {3.5992961739712048`*^9, 
   3.5992962445613036`*^9}, {3.5992962930713716`*^9, 
   3.5992963545414577`*^9}, {3.5992963927815113`*^9, 
   3.5992964445715837`*^9}, {3.599296494641654*^9, 3.5992968444321437`*^9}, {
   3.599296887552204*^9, 3.599296986792343*^9}, {3.599297934218672*^9, 
   3.599298019208791*^9}, {3.5993016795669155`*^9, 3.599301693636935*^9}, {
   3.599301959947308*^9, 3.5993019634573126`*^9}, {3.5993021233475366`*^9, 
   3.5993021435185647`*^9}, {3.599304557802945*^9, 3.599304591432992*^9}, {
   3.5993049055044317`*^9, 3.5993049245844584`*^9}, {3.599305295074977*^9, 
   3.59930539737512*^9}, 3.5993054293551655`*^9, {3.599305492505254*^9, 
   3.5993055960653987`*^9}, {3.6408748763965225`*^9, 
   3.6408749053343873`*^9}, {3.640875276876398*^9, 3.640875397485052*^9}, {
   3.640876228255804*^9, 3.6408762546105614`*^9}, {3.6408780676364126`*^9, 
   3.640878091393145*^9}, {3.689572481342763*^9, 3.6895724962757835`*^9}, {
   3.6895726041899347`*^9, 3.689572796495205*^9}, {3.689572835900262*^9, 
   3.6895729129853697`*^9}, {3.689573008749504*^9, 3.689573031821536*^9}, {
   3.689573416735077*^9, 3.689573438147107*^9}, {3.689573470017152*^9, 
   3.6895734770721617`*^9}, {3.6895736217583647`*^9, 3.689573650092405*^9}, {
   3.6895736814044485`*^9, 3.689573709454488*^9}, {3.689573821010645*^9, 
   3.689573864774706*^9}, {3.68957389621675*^9, 3.6895739080567665`*^9}, {
   3.6895739612188416`*^9, 3.6895740112309113`*^9}, {3.6895771888864636`*^9, 
   3.689577214158499*^9}, {3.6895772454085426`*^9, 3.6895773575767*^9}, {
   3.6895774363708105`*^9, 3.6895775019029026`*^9}, {3.689577536814952*^9, 
   3.6895775494549694`*^9}, {3.689577719146208*^9, 3.689577720206209*^9}, {
   3.6922705873465204`*^9, 3.6922705886764803`*^9}, {3.6922706280372996`*^9, 
   3.692270628897274*^9}, {3.956738995534006*^9, 3.956739014511242*^9}, {
   3.9567393668160896`*^9, 3.9567393674124966`*^9}, {3.9567395158812714`*^9, 
   3.9567396635345116`*^9}, {3.9567397274785366`*^9, 
   3.9567397402304726`*^9}, {3.956739787345316*^9, 3.956739843004961*^9}, {
   3.956740192188427*^9, 3.956740226974432*^9}, 3.956740296979456*^9, {
   3.956740522507965*^9, 3.956740535754654*^9}, {3.956740696255327*^9, 
   3.9567407059237785`*^9}, {3.956740907666361*^9, 3.9567409314528294`*^9}, {
   3.9567414236827717`*^9, 3.9567414429794903`*^9}, {3.9567415160513268`*^9, 
   3.956741557641884*^9}, {3.9567416918141804`*^9, 3.9567416933072243`*^9}, {
   3.956742276978449*^9, 3.9567423193389473`*^9}, {3.9567424419383163`*^9, 
   3.9567425159232216`*^9}, {3.956742657226343*^9, 3.9567426691744003`*^9}, {
   3.956807434931713*^9, 3.9568074932460976`*^9}, {3.9568077505731735`*^9, 
   3.956807764108095*^9}, {3.9568077962200375`*^9, 3.9568078009374294`*^9}, {
   3.956808312410383*^9, 3.9568083227048645`*^9}, {3.9568084342121143`*^9, 
   3.956808455429867*^9}, {3.956808596453972*^9, 3.9568086794987144`*^9}, {
   3.9568147911247272`*^9, 3.956814847154001*^9}, {3.956815496630129*^9, 
   3.956815497314272*^9}, {3.956815553757454*^9, 3.9568155547359123`*^9}, {
   3.9568156061865673`*^9, 3.9568157585298233`*^9}, {3.956815806907892*^9, 
   3.9568158080957184`*^9}, {3.9568158853675385`*^9, 3.956816110129196*^9}, {
   3.9568167706799164`*^9, 3.956816795175434*^9}, {3.956823524767521*^9, 
   3.9568235405243835`*^9}, {3.9573686255752544`*^9, 3.957368661024948*^9}, {
   3.9573689217530727`*^9, 3.957368994917904*^9}, {3.9573690392914314`*^9, 
   3.9573691056969337`*^9}, {3.9573692094226933`*^9, 
   3.9573692633185997`*^9}, {3.957369307499462*^9, 3.9573693161293926`*^9}, {
   3.957369640959526*^9, 3.9573696808327446`*^9}, {3.9573697581962967`*^9, 
   3.9573698167595634`*^9}, {3.957369853696085*^9, 3.957369997361313*^9}, 
   3.957370154685913*^9, {3.9573702128540154`*^9, 3.9573702152776794`*^9}, {
   3.9573702599820404`*^9, 3.957370260511627*^9}, {3.957403357186363*^9, 
   3.95740335917054*^9}, {3.9574034650346985`*^9, 3.9574034714826183`*^9}, {
   3.9574035098990307`*^9, 3.9574035371402473`*^9}, {3.957403627353815*^9, 
   3.9574036377745705`*^9}, {3.957403678153837*^9, 3.9574036814585457`*^9}, {
   3.957403740132717*^9, 3.9574037806195335`*^9}, 3.9574041628195076`*^9, {
   3.9574043625419064`*^9, 3.957404384627447*^9}, {3.9574045472908745`*^9, 
   3.9574045645641975`*^9}, {3.9574046001470623`*^9, 
   3.9574046284624233`*^9}, {3.95740468802754*^9, 3.957404708925646*^9}, {
   3.957405097843487*^9, 3.9574051181160583`*^9}, {3.958559913297182*^9, 
   3.9585599780345592`*^9}, {3.958560074587206*^9, 3.958560081798483*^9}, {
   3.958560158125244*^9, 3.9585601812404594`*^9}, {3.958560215878517*^9, 
   3.9585602297500935`*^9}, {3.9585603198609333`*^9, 3.958560391197401*^9}, {
   3.958560872736456*^9, 3.95856089502878*^9}, {3.958561072111412*^9, 
   3.9585610791395016`*^9}, {3.9585713916422234`*^9, 
   3.9585714178416233`*^9}, {3.958571797768955*^9, 3.9585717981236534`*^9}, {
   3.9585719098618984`*^9, 3.9585719566730747`*^9}, {3.958571996684271*^9, 
   3.958572036132679*^9}, {3.9585728915916405`*^9, 3.9585731302237434`*^9}, {
   3.958573234553978*^9, 3.9585733401589413`*^9}, {3.95857358281513*^9, 
   3.958573589926409*^9}, {3.9585737664923725`*^9, 3.9585738137795296`*^9}, {
   3.9585738446147766`*^9, 3.958573966255121*^9}, {3.9585741777165585`*^9, 
   3.958574320942053*^9}, {3.958574368925852*^9, 3.9585744661073723`*^9}, {
   3.958574561234215*^9, 3.9585745914601746`*^9}, {3.9585746393859158`*^9, 
   3.9585746728937607`*^9}, {3.958574954596163*^9, 3.9585749579873714`*^9}, {
   3.958575387788143*^9, 3.9585754197624817`*^9}, {3.958575532253706*^9, 
   3.958575576338417*^9}, {3.9585756290601215`*^9, 3.9585756396576443`*^9}, {
   3.958692996498476*^9, 3.9586930790747337`*^9}, {3.958693624376524*^9, 
   3.9586936377380066`*^9}, {3.9586936901207256`*^9, 3.958693722179882*^9}, {
   3.9586937909246216`*^9, 3.958693821377239*^9}, {3.9586943792668743`*^9, 
   3.9586944272972775`*^9}, {3.9586945783276863`*^9, 
   3.9586945959064617`*^9}, {3.959599658417551*^9, 3.9595996821959305`*^9}, {
   3.9596000822574883`*^9, 3.9596001215284233`*^9}, {3.9596012180616646`*^9, 
   3.959601221442623*^9}, {3.9596013144702244`*^9, 3.9596013189552307`*^9}, {
   3.959601400305361*^9, 3.959601494338848*^9}, 3.9596023952229424`*^9, {
   3.9596026588750725`*^9, 3.9596026782073917`*^9}, {3.959603005433214*^9, 
   3.959603030238041*^9}, {3.9596098922881393`*^9, 3.959609901089569*^9}, {
   3.9596109300833797`*^9, 3.959610935207676*^9}, {3.9596114697906475`*^9, 
   3.959611574102152*^9}, {3.9596116611976852`*^9, 3.9596117886061344`*^9}, {
   3.959611888315819*^9, 3.9596119935413704`*^9}, {3.9596120362062263`*^9, 
   3.959612103451689*^9}, {3.9596123621671257`*^9, 3.9596123754675198`*^9}, {
   3.959612675273695*^9, 3.9596127007046757`*^9}, {3.9596128878315887`*^9, 
   3.9596129519668026`*^9}, {3.959613020117359*^9, 3.959613093337103*^9}, 
   3.9596131941955585`*^9, {3.959613851574375*^9, 3.9596139566684513`*^9}, 
   3.9596142417788887`*^9, {3.95961469844466*^9, 3.9596147068900967`*^9}, 
   3.9596148341854515`*^9, {3.959614871161152*^9, 3.9596148925356445`*^9}, {
   3.9596150597642307`*^9, 3.9596150881790733`*^9}, {3.9596158335179787`*^9, 
   3.9596158568316193`*^9}, {3.959656928822216*^9, 3.9596570411626587`*^9}, {
   3.959657103825054*^9, 3.9596571252377815`*^9}, {3.959658351693657*^9, 
   3.9596584458619404`*^9}, {3.9596590362102222`*^9, 
   3.9596590660693645`*^9}, {3.959694814184656*^9, 3.9596948803265533`*^9}, {
   3.9596950338308983`*^9, 3.959695115493559*^9}, {3.9596951544593353`*^9, 
   3.9596952472180004`*^9}, {3.959695282358074*^9, 3.959695324983671*^9}, {
   3.959695563451803*^9, 3.959695568123308*^9}, {3.959695692930685*^9, 
   3.9596957019864616`*^9}, {3.959695819633322*^9, 3.95969583326486*^9}, {
   3.959695887384409*^9, 3.959695971474659*^9}, {3.959696053074543*^9, 
   3.9596960657456455`*^9}, {3.959696099622593*^9, 3.9596961256669846`*^9}, 
   3.959696159297062*^9, {3.959696249802267*^9, 3.9596963635686646`*^9}, 
   3.95969648660038*^9, {3.95969675316951*^9, 3.9596968932665977`*^9}, {
   3.9596969355848675`*^9, 3.9596970268937206`*^9}, 3.959697059724907*^9, {
   3.9596976851677628`*^9, 3.9596977920960407`*^9}, {3.9596978807291145`*^9, 
   3.9596979237480335`*^9}, {3.9596979565454025`*^9, 
   3.9596980942537575`*^9}, {3.9596981412334576`*^9, 3.959698273103056*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"7d48bbd3-0d1b-46ec-b47c-83ff250e943e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UndefFundSpatialSpinOperators", "[", 
    RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Names", " ", "of", " ", "the", " ", "operators"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"divcd", "=", 
        RowBox[{"DivName", "@", "covd"}]}], ",", " ", 
       RowBox[{"curlcd", "=", 
        RowBox[{"CurlName", "@", "covd"}]}], ",", " ", 
       RowBox[{"twistcd", "=", 
        RowBox[{"TwistName", "@", "covd"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Names", " ", "of", " ", "lists"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"$irrdecrulescd", "=", 
        RowBox[{"StringJoin", "[", 
         RowBox[{"\"\<$IrrDecRules\>\"", ",", 
          RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"$expandfundspinoprulescd", "=", 
        RowBox[{"StringJoin", "[", 
         RowBox[{"\"\<$ExpandFundSpinOpRules\>\"", ",", 
          RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Removing", " ", "special", " ", "code"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"ImposeFundSpatialSpinOp", "[", 
        RowBox[{"expr1_", ",", "twistcd", ",", " ", "iinds_"}], "]"}], "=."}],
       ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ImposeFundSpatialSpinOp", "[", 
        RowBox[{"expr1_", ",", "curlcd", ",", " ", "iinds_"}], "]"}], "=."}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ImposeFundSpatialSpinOp", "[", 
        RowBox[{"expr1_", ",", "divcd", ",", " ", "iinds_"}], "]"}], "=."}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Unlinking", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"VisitorsOf", "[", "covd", "]"}], "^=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{
         RowBox[{"VisitorsOf", "[", "covd", "]"}], ",", 
         RowBox[{"Alternatives", "[", 
          RowBox[{"divcd", ",", "curlcd", ",", "twistcd"}], "]"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Undefining", " ", "objects"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Remove", "@", "$irrdecrulescd"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Remove", "@", "$expandfundspinoprulescd"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Remove", "@", "divcd"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Remove", "@", "curlcd"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Remove", "@", "twistcd"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"$FundSpatialSpinOpCovDs", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"$FundSpatialSpinOpCovDs", ",", "covd"}], "]"}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5880605441313734`*^9, 3.588060669243593*^9}, {
   3.5880607302407007`*^9, 3.588060867318141*^9}, {3.588060944351076*^9, 
   3.588061029870427*^9}, {3.5880611161697783`*^9, 3.5880611503650384`*^9}, {
   3.588061380356242*^9, 3.5880613940998664`*^9}, {3.5880614250191207`*^9, 
   3.5880614311967316`*^9}, {3.5880615118956733`*^9, 3.588061513486876*^9}, {
   3.588061641547501*^9, 3.5880616695651503`*^9}, {3.5880617060380144`*^9, 
   3.588061710328022*^9}, {3.5880626552528815`*^9, 3.5880626614304924`*^9}, {
   3.5885904132706738`*^9, 3.5885904328643084`*^9}, {3.588590883394099*^9, 
   3.5885909192429624`*^9}, {3.5885910709220285`*^9, 3.588591080734446*^9}, {
   3.5885967096432114`*^9, 3.588596718114026*^9}, {3.5885971145731225`*^9, 
   3.5885971261171427`*^9}, {3.5898944535092545`*^9, 
   3.5898944662856774`*^9}, {3.5902377703266215`*^9, 
   3.5902378623199835`*^9}, {3.592127789641586*^9, 3.5921278076716113`*^9}, {
   3.5921278580916815`*^9, 3.5921278898917265`*^9}, {3.592222379808057*^9, 
   3.5922223941780767`*^9}, {3.592226524638861*^9, 3.592226528738867*^9}, {
   3.5922275854403462`*^9, 3.592227592370356*^9}, {3.5972100354565177`*^9, 
   3.5972100462361364`*^9}, {3.598172228598663*^9, 3.5981722289086633`*^9}, {
   3.5981722807587357`*^9, 3.598172315098784*^9}, {3.5981804002592382`*^9, 
   3.5981804018192406`*^9}, {3.5981826992234573`*^9, 
   3.5981827863935795`*^9}, {3.5981895802471457`*^9, 
   3.5981895807571464`*^9}, {3.598190269768111*^9, 3.598190296298148*^9}, {
   3.5981903477182207`*^9, 3.598190371538254*^9}, {3.5981908809289665`*^9, 
   3.598190888988978*^9}, {3.599290365207388*^9, 3.59929036663739*^9}, {
   3.5992957683276014`*^9, 3.5992958051976533`*^9}, 3.95735968971719*^9},
 CellLabel->"In[95]:=",ExpressionUUID->"e6cb054c-8f65-40ff-8ca1-f0c6b55d44f6"]
}, Closed]],

Cell[CellGroupData[{

Cell["5.3. Irreducible decompositions of covariant derivatives", \
"Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.5539192482194347`*^9, 3.553919256393849*^9}, {
   3.5539225601370564`*^9, 3.5539225625082607`*^9}, {3.5891979111905575`*^9, 
   3.589197916853368*^9}, {3.589197965338253*^9, 3.589197978052275*^9}, {
   3.5901524319283648`*^9, 3.5901524341591687`*^9}, 3.590213338156372*^9, 
   3.590318254499852*^9, 3.592220754195781*^9, {3.592220952516059*^9, 
   3.592220960076069*^9}, {3.5922222423178644`*^9, 3.5922222478378725`*^9}, 
   3.59721118096653*^9, {3.690020264694571*^9, 
   3.690020265774571*^9}},ExpressionUUID->"821f239f-e5a6-488b-84f6-\
9156d5a339dd"],

Cell["\<\
Irreducible decompositions of covariant derivatives of symmetric spinors.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.553938656402255*^9, 3.553938671846282*^9}, {
  3.587796839044757*^9, 3.5877968419619617`*^9}, {3.5903182638442683`*^9, 
  3.5903182815190997`*^9}, {3.592220965436077*^9, 
  3.5922210022161283`*^9}},ExpressionUUID->"9922c4f6-242b-4767-bc1e-\
993fe0a91556"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xAct`SymManipulator`IrrDecomposeCovD", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], "[", 
       RowBox[{"A_", ",", "B_"}], "]"}], "@", 
      RowBox[{
       RowBox[{"TT_", "?", "xTensorQ"}], "[", "inds___", "]"}]}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CompatibleSymQ", "[", 
       RowBox[{
        RowBox[{"SlotsOfTensor", "@", "TT"}], ",", 
        RowBox[{"SymmetryGroupOfTensor", "@", "TT"}]}], "]"}], "=!=", 
      "True"}], ",", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"IrrDecomposeCovD", "::", "error"}], ",", 
        "\"\<Only decompositions of derivatives of symmetric tensors are \
implemented.\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eps", "=", 
         RowBox[{"First", "@", 
          RowBox[{"MetricsOfVBundle", "@", 
           RowBox[{
            RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "unprimedinds", ",", "irrdecexpr", ",", "k", ",", " ", "resulttype",
            ",", "expandsym"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"resulttype", ",", "expandsym"}], "}"}], "=", 
           RowBox[{"OptionValue", "[", 
            RowBox[{"{", 
             RowBox[{"ResultType", ",", "ExpandSym"}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"unprimedinds", "=", 
           RowBox[{"ExtractUnprimedIndsGivenCovD", "[", 
            RowBox[{
             RowBox[{"{", "inds", "}"}], ",", "covd"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"k", "=", 
           RowBox[{"Length", "@", "unprimedinds"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"irrdecexpr", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"TwistName", "[", "covd", "]"}], "[", "TT", "]"}], "[", 
            RowBox[{"A", ",", "B", ",", 
             RowBox[{"Sequence", "@@", "unprimedinds"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"k", ">", "0"}], ",", 
            RowBox[{"irrdecexpr", "=", 
             RowBox[{"irrdecexpr", "-", 
              RowBox[{
               RowBox[{"k", "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "2"}], ")"}]}], "*", 
               RowBox[{"ImposeSym", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"eps", "[", 
                   RowBox[{"A", ",", 
                    RowBox[{"First", "@", "unprimedinds"}]}], "]"}], "*", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"CurlName", "[", "covd", "]"}], "[", "TT", "]"}], 
                   "[", 
                   RowBox[{
                    RowBox[{"Sequence", "@@", 
                    RowBox[{"Rest", "@", "unprimedinds"}]}], ",", "B"}], 
                   "]"}]}], ",", 
                 RowBox[{"IndexList", "@@", "unprimedinds"}]}], "]"}]}], "-", 
              
              RowBox[{
               RowBox[{"k", "/", 
                RowBox[{"(", 
                 RowBox[{"k", "+", "2"}], ")"}]}], "*", 
               RowBox[{"ImposeSym", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"eps", "[", 
                   RowBox[{"B", ",", 
                    RowBox[{"First", "@", "unprimedinds"}]}], "]"}], "*", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"CurlName", "[", "covd", "]"}], "[", "TT", "]"}], 
                   "[", 
                   RowBox[{
                    RowBox[{"Sequence", "@@", 
                    RowBox[{"Rest", "@", "unprimedinds"}]}], ",", "A"}], 
                   "]"}]}], ",", 
                 RowBox[{"IndexList", "@@", "unprimedinds"}]}], "]"}]}]}]}]}],
            "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"And", "[", 
             RowBox[{"k", ">", "1"}], "]"}], ",", 
            RowBox[{"irrdecexpr", "=", 
             RowBox[{"irrdecexpr", "+", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "k"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "k"}], ")"}]}], "*", 
               RowBox[{"ImposeSym", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"eps", "[", 
                   RowBox[{"A", ",", 
                    RowBox[{"First", "@", "unprimedinds"}]}], "]"}], "*", 
                  RowBox[{"eps", "[", 
                   RowBox[{
                    RowBox[{"Last", "@", "unprimedinds"}], ",", "B"}], "]"}], 
                  "*", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"DivName", "[", "covd", "]"}], "[", "TT", "]"}], 
                   "[", 
                   RowBox[{"Sequence", "@@", 
                    RowBox[{"Most", "@", 
                    RowBox[{"Rest", "@", "unprimedinds"}]}]}], "]"}]}], ",", 
                 RowBox[{"IndexList", "@@", "unprimedinds"}]}], "]"}]}]}]}]}],
            "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"expandsym", ",", 
            RowBox[{"irrdecexpr", "=", 
             RowBox[{"ToCanonical", "@", 
              RowBox[{"ExpandSym", "[", 
               RowBox[{"irrdecexpr", ",", 
                RowBox[{"SmartExpand", "\[Rule]", "True"}]}], "]"}]}]}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Switch", "[", 
           RowBox[{
           "resulttype", ",", "\[IndentingNewLine]", "\"\<Expression\>\"", 
            ",", "irrdecexpr", ",", "\[IndentingNewLine]", "\"\<Equation\>\"",
             ",", 
            RowBox[{"Equal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"covd", "[", 
                RowBox[{"A", ",", "B"}], "]"}], "@", 
               RowBox[{"TT", "[", "inds", "]"}]}], ",", "irrdecexpr"}], "]"}],
             ",", "\[IndentingNewLine]", "\"\<Rule\>\"", ",", 
            RowBox[{"MakeRule", "[", 
             RowBox[{"Evaluate", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"covd", "[", 
                   RowBox[{"A", ",", "B"}], "]"}], "@", 
                  RowBox[{"TT", "[", "inds", "]"}]}], ",", "irrdecexpr"}], 
                "}"}], ",", 
               RowBox[{"MetricOn", "\[Rule]", "All"}], ",", 
               RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}], "]"}],
             ",", "\[IndentingNewLine]", "\"\<CompareRule\>\"", ",", 
            RowBox[{"MakeCompareRule", "[", 
             RowBox[{"Evaluate", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"covd", "[", 
                  RowBox[{"A", ",", "B"}], "]"}], "@", 
                 RowBox[{"TT", "[", "inds", "]"}]}], ",", "irrdecexpr"}], 
               "}"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "_", ",", 
            "Null"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5922201074438753`*^9, 3.5922201611939507`*^9}, {
   3.5922205632945137`*^9, 3.59222056770452*^9}, {3.5922208333158917`*^9, 
   3.592220847615912*^9}, {3.5922208850759645`*^9, 3.5922209281260242`*^9}, {
   3.592221173136368*^9, 3.5922212330864515`*^9}, {3.5922212710365047`*^9, 
   3.592221272926507*^9}, {3.592221379356656*^9, 3.592221391386673*^9}, {
   3.5922214233667183`*^9, 3.592221454366761*^9}, {3.592221554096901*^9, 
   3.592221554386901*^9}, {3.5922215987369633`*^9, 3.5922216666070585`*^9}, {
   3.592221713767124*^9, 3.592221752027178*^9}, 3.592225019615754*^9, {
   3.5922252913161345`*^9, 3.592225291676135*^9}, {3.599300498884262*^9, 
   3.5993005539743395`*^9}, {3.599300646524469*^9, 3.5993006914845324`*^9}, {
   3.599300731044587*^9, 3.5993007839746614`*^9}, {3.599300815064705*^9, 
   3.599300879624795*^9}, {3.599300912115841*^9, 3.5993009547959003`*^9}, {
   3.5993009856059437`*^9, 3.5993010120159807`*^9}, {3.599301048336032*^9, 
   3.5993010775360727`*^9}, 3.599301114276124*^9, 3.5993042043924503`*^9, {
   3.6900205442845707`*^9, 3.690020546924571*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"6b1d5707-68ca-4cc7-aa8e-ec7508346aa1"],

Cell["We can also just give the name of the tensor and the covd.", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.5922219722174864`*^9, 
  3.5922220102375393`*^9}},ExpressionUUID->"c2d2a842-9323-4e92-949a-\
bbc3e6d83e32"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xAct`SymManipulator`IrrDecomposeCovD", "[", 
    RowBox[{
     RowBox[{"TT_", "?", "xTensorQ"}], ",", 
     RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"unprimedinds", ",", " ", "cdeexpr"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", "unprimedinds", "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"DownIndex", "/@", "#1"}], "}"}], "&"}], "@@", 
        RowBox[{"GetIndexRange", "@@@", 
         RowBox[{"(", 
          RowBox[{"Reverse", "/@", 
           RowBox[{"Tally", "[", 
            RowBox[{"UpIndex", "/@", 
             RowBox[{"SlotsOfTensor", "@", 
              RowBox[{
               RowBox[{"TwistName", "[", "covd", "]"}], "[", "TT", "]"}]}]}], 
            "]"}]}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"cdeexpr", "=", 
       RowBox[{
        RowBox[{"covd", "[", 
         RowBox[{
          RowBox[{"First", "@", "unprimedinds"}], ",", " ", 
          RowBox[{"First", "@", 
           RowBox[{"Rest", "@", "unprimedinds"}]}]}], "]"}], "@", 
        RowBox[{"TT", "[", 
         RowBox[{"Sequence", "@@", 
          RowBox[{"Rest", "@", 
           RowBox[{"Rest", "@", "unprimedinds"}]}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"IrrDecomposeCovD", "[", 
       RowBox[{"cdeexpr", ",", "options"}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.59222204619759*^9, 3.5922221130876837`*^9}, {
   3.592222154097741*^9, 3.592222176167772*^9}, {3.59930111832613*^9, 
   3.5993011531661787`*^9}, {3.599301199926244*^9, 3.5993012333862906`*^9}, {
   3.5993042188724704`*^9, 3.599304222732476*^9}, 3.6900205639945707`*^9},
 CellLabel->"In[97]:=",ExpressionUUID->"aacf17fd-6557-4ade-8c7c-254a7e189e16"],

Cell["Collecting rules for irreducible decompositions.", "Text",
 InitializationCell->True,
 CellChangeTimes->{
  3.5922269226394186`*^9},ExpressionUUID->"5ee48b2b-67d2-4d11-bfac-\
962b43b8947d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"xAct`SymManipulator`ToFundSpinOp", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"newtensors", "=", 
        RowBox[{"{", "}"}]}], ",", "intermexpr"}], "}"}], ",", 
     RowBox[{
      RowBox[{"intermexpr", "=", 
       RowBox[{
        RowBox[{"ToCanonical", "@", 
         RowBox[{"ContractMetric", "[", 
          RowBox[{"expr", "//.", 
           RowBox[{"Symbol", "[", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<$IrrDecRules\>\"", ",", 
              RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], 
          "]"}]}], "/.", 
        RowBox[{
         RowBox[{"x", ":", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"covd", "[", 
             RowBox[{"A_", ",", "B_"}], "]"}], "[", 
            RowBox[{
             RowBox[{"TTT_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], 
           ")"}]}], "\[RuleDelayed]", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", "}"}], ",", 
           RowBox[{
            RowBox[{"AppendTo", "[", 
             RowBox[{"newtensors", ",", "TTT"}], "]"}], ";", "x"}]}], 
          "]"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"newtensors", "=", 
       RowBox[{"DeleteDuplicates", "@", "newtensors"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"newtensors", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"newtensors", ",", 
         RowBox[{
          RowBox[{"CompatibleSymQ", "[", 
           RowBox[{
            RowBox[{"SlotsOfTensor", "@", "#"}], ",", 
            RowBox[{"SymmetryGroupOfTensor", "@", "#"}]}], "]"}], "&"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "@", "newtensors"}], ">", "0"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Adding rules for \>\"", ",", " ", "newtensors"}], 
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"xAct`SymManipulator`Private`AddToIrrDecRules", "[", 
         RowBox[{"#", ",", "covd", ",", 
          RowBox[{"ExpandSym", "\[Rule]", 
           RowBox[{"OptionValue", "[", "ExpandSym", "]"}]}]}], "]"}], "&"}], "/@",
        "newtensors"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ToCanonical", "@", 
       RowBox[{"ContractMetric", "[", 
        RowBox[{"expr", "//.", 
         RowBox[{"Symbol", "[", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<$IrrDecRules\>\"", ",", 
            RowBox[{"SymbolName", "[", "covd", "]"}]}], "]"}], "]"}]}], 
        "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.5922269746894913`*^9, 3.592227095849661*^9}, {
   3.592235359105347*^9, 3.5922353733941646`*^9}, {3.597208830604001*^9, 
   3.597208837639614*^9}, {3.597209294439616*^9, 3.597209310757245*^9}, 
   3.5972094985191746`*^9, {3.597209651867444*^9, 3.5972096527410455`*^9}, {
   3.5981880099839478`*^9, 3.59818801872396*^9}, {3.599301388036507*^9, 
   3.5993014624866114`*^9}, {3.5993042666725373`*^9, 3.599304287672567*^9}, 
   3.690020643974571*^9},
 CellLabel->"In[98]:=",ExpressionUUID->"c2cc750e-7297-44d6-a850-ca26dacdaebb"]
}, Closed]],

Cell[CellGroupData[{

Cell["5.4. LeibnizRules", "Subsubsection",
 InitializationCell->True,
 CellChangeTimes->{{3.5539192482194347`*^9, 3.553919256393849*^9}, {
   3.5539225601370564`*^9, 3.5539225625082607`*^9}, {3.5891979111905575`*^9, 
   3.589197916853368*^9}, {3.589197965338253*^9, 3.589197978052275*^9}, {
   3.5901524319283648`*^9, 3.5901524341591687`*^9}, 3.590213338156372*^9, 
   3.590318254499852*^9, 3.592220754195781*^9, {3.592220952516059*^9, 
   3.592220960076069*^9}, {3.5922222423178644`*^9, 3.5922222478378725`*^9}, 
   3.59721118096653*^9, {3.690020264694571*^9, 3.690020265774571*^9}, {
   3.957360897215843*^9, 
   3.957360925275854*^9}},ExpressionUUID->"d2df8d3d-efeb-4f4e-a2f7-\
33fae2211ad3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SpatialTwistMultScal", "[", 
   RowBox[{"covd_", ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"T_", "?", "xTensorQ"}], ")"}], "[", "]"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"xAct`SpaceSpinors`Private`TwistName", "@", "covd"}], ")"}], "[", 
   "T", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpatialTwistMultScal", "[", 
   RowBox[{"covd_", ",", 
    RowBox[{"Times", "[", 
     RowBox[{"a_", ",", "rest__"}], "]"}]}], "]"}], ":=", 
  RowBox[{"TensorPlus", "[", 
   RowBox[{
    RowBox[{"MultScal", "[", 
     RowBox[{
      RowBox[{"Times", "[", "rest", "]"}], ",", 
      RowBox[{"SpatialTwistMultScal", "[", 
       RowBox[{"covd", ",", "a"}], "]"}]}], "]"}], ",", 
    RowBox[{"MultScal", "[", 
     RowBox[{"a", ",", 
      RowBox[{"SpatialTwistMultScal", "[", 
       RowBox[{"covd", ",", 
        RowBox[{"Times", "[", "rest", "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpatialTwistMultScal", "[", 
   RowBox[{"covd_", ",", 
    RowBox[{"Power", "[", 
     RowBox[{"a_", ",", 
      RowBox[{"c_", "?", "ConstantQ"}]}], "]"}]}], "]"}], ":=", 
  RowBox[{"MultScal", "[", 
   RowBox[{
    RowBox[{"c", "*", 
     RowBox[{"Power", "[", 
      RowBox[{"a", ",", 
       RowBox[{"c", "-", "1"}]}], "]"}]}], ",", 
    RowBox[{"SpatialTwistMultScal", "[", 
     RowBox[{"covd", ",", "a"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpatialTwistMultScal", "[", 
   RowBox[{"covd_", ",", "expr_Plus"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"SpatialTwistMultScal", "[", 
     RowBox[{"covd", ",", "#"}], "]"}], "&"}], "/@", 
   RowBox[{"TensorPlus", "@@", "expr"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpatialTwistMultScal", "[", 
   RowBox[{"covd_", ",", 
    RowBox[{"c_", "?", "ConstantQ"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"spin", "=", 
      RowBox[{
       RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"ZeroTensor", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "spin"}], ",", 
       RowBox[{"-", "spin"}]}], "}"}], "]"}]}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.776737806532586*^9, 3.776737850993584*^9}, {
   3.7767395067657394`*^9, 3.776739523430374*^9}, {3.8388791855273247`*^9, 
   3.838879297398347*^9}, {3.839155632517634*^9, 3.8391556492935333`*^9}, {
   3.839155761491336*^9, 3.8391557769012885`*^9}, {3.9573601171815224`*^9, 
   3.95736013609202*^9}, {3.9573601988903255`*^9, 3.957360202035877*^9}, 
   3.957360237684574*^9},
 CellLabel->"In[99]:=",ExpressionUUID->"f29bdb4c-5b52-3748-8efd-8b9f63972beb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MultScalLeibnizRules", "[", 
    RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], "]"}], ":=", "\n", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"divcd", "=", 
        RowBox[{"xAct`SpaceSpinors`Private`DivName", "@", "covd"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"curlcd", "=", 
        RowBox[{"xAct`SpaceSpinors`Private`CurlName", "@", "covd"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"twistcd", "=", 
        RowBox[{"xAct`SpaceSpinors`Private`TwistName", "@", "covd"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"spin", "=", 
        RowBox[{
         RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"divcd", "[", 
         RowBox[{"MultScal", "[", 
          RowBox[{"expr_", ",", "T_"}], "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{"TensorPlus", "[", 
         RowBox[{
          RowBox[{"MultScal", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"divcd", "[", "T", "]"}]}], "]"}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{
             RowBox[{"SpatialTwistMultScal", "[", 
              RowBox[{"covd", ",", "expr"}], "]"}], ",", "2", ",", "0", ",", 
             "spin"}], "]"}], "[", "T", "]"}]}], "]"}]}], ",", "\n", 
       RowBox[{
        RowBox[{"curlcd", "[", 
         RowBox[{"MultScal", "[", 
          RowBox[{"expr_", ",", "T_"}], "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{"TensorPlus", "[", 
         RowBox[{
          RowBox[{"MultScal", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"curlcd", "[", "T", "]"}]}], "]"}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{
             RowBox[{"SpatialTwistMultScal", "[", 
              RowBox[{"covd", ",", "expr"}], "]"}], ",", "1", ",", "0", ",", 
             "spin"}], "]"}], "[", "T", "]"}]}], "]"}]}], ",", "\n", 
       RowBox[{
        RowBox[{"twistcd", "[", 
         RowBox[{"MultScal", "[", 
          RowBox[{"expr_", ",", "T_"}], "]"}], "]"}], "\[RuleDelayed]", 
        RowBox[{"TensorPlus", "[", 
         RowBox[{
          RowBox[{"MultScal", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"twistcd", "[", "T", "]"}]}], "]"}], ",", 
          RowBox[{
           RowBox[{"SymMult", "[", 
            RowBox[{
             RowBox[{"SpatialTwistMultScal", "[", 
              RowBox[{"covd", ",", "expr"}], "]"}], ",", "0", ",", "0", ",", 
             "spin"}], "]"}], "[", "T", "]"}]}], "]"}]}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.957359514010338*^9, 3.957359514433182*^9}, {
  3.957359875381956*^9, 3.957360044453306*^9}, {3.9573601404363556`*^9, 
  3.957360158372631*^9}, {3.9573605367225723`*^9, 3.95736054522106*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"04ee2797-1fe9-9144-9671-8688068a4852"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymMultLeibnizRules", "[", 
   RowBox[{"covd_", "?", "SpatialSpinCovDQ"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"divcd", "=", 
       RowBox[{"xAct`SpaceSpinors`Private`DivName", "@", "covd"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"curlcd", "=", 
       RowBox[{"xAct`SpaceSpinors`Private`CurlName", "@", "covd"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"twistcd", "=", 
       RowBox[{"xAct`SpaceSpinors`Private`TwistName", "@", "covd"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"spin", "=", 
       RowBox[{
        RowBox[{"VBundlesOfCovD", "[", "covd", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"divcd", "[", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"\[Phi]_", ",", "m_", ",", "0", ",", "spin"}], "]"}], "[", 
         "\[Psi]_", "]"}], "]"}], ":>", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
               "]"}]}], ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "\[Psi]",
               "]"}]}]}], "}"}], ",", 
          RowBox[{"TensorPlus", "[", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", "m"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "l", "-", "m"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"l", "-", "m"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Psi]", ",", 
                 RowBox[{"2", "+", "m"}], ",", "0", ",", "spin"}], "]"}], "[", 
               RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", "m"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"k", "-", "m"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k", "+", "l", "-", "m"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "l"}], "+", "m"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Psi]", ",", 
                 RowBox[{"1", "+", "m"}], ",", "0", ",", "spin"}], "]"}], "[", 
               RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"k", "===", "0"}], ",", "0", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", "m"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k", "-", "m"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"k", "-", "m"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"k", "+", "l", "-", "m"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k", "+", "l", "-", "m"}], ")"}]}], 
                  ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k", "+", "l", "-", 
                    RowBox[{"2", "*", "m"}]}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"k", "+", "l", "-", 
                    RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}]}], "]"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Psi]", ",", "m", ",", "0", ",", "spin"}], "]"}], 
               "[", 
               RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "k", "-", "m"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"k", "-", "m"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"2", "+", "m"}], ",", "0", ",", "spin"}], "]"}], "[", 
               RowBox[{"twistcd", "[", "\[Psi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "*", 
                 RowBox[{"(", 
                  RowBox[{"k", "-", "m"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "k", "+", "l", "-", "m"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "l"}], "+", "m"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "+", "l"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"1", "+", "m"}], ",", "0", ",", "spin"}], "]"}], "[", 
               RowBox[{"curlcd", "[", "\[Psi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"l", "===", "0"}], ",", "0", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "l", "-", "m"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"l", "-", "m"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"k", "+", "l", "-", "m"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k", "+", "l", "-", "m"}], ")"}]}], 
                  ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"l", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "k", "+", "l", "-", 
                    RowBox[{"2", "*", "m"}]}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"k", "+", "l", "-", 
                    RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}]}], "]"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", "m", ",", "0", ",", "spin"}], "]"}], 
               "[", 
               RowBox[{"divcd", "[", "\[Psi]", "]"}], "]"}]}], "]"}]}], 
           "]"}]}], "]"}], "/;", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]", 
           "]"}], "===", "0"}], "&&", 
         RowBox[{
          RowBox[{
           RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Psi]", 
           "]"}], "===", "0"}]}]}]}], ",", 
      RowBox[{
       RowBox[{"curlcd", "[", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"\[Phi]_", ",", "m_", ",", "0", ",", "spin"}], "]"}], "[", 
         "\[Psi]_", "]"}], "]"}], ":>", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
               "]"}]}], ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "\[Psi]",
               "]"}]}]}], "}"}], ",", 
          RowBox[{"TensorPlus", "[", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", "m"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "l"}], "+", "m"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "l", "-", 
                 RowBox[{"2", "*", "m"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Psi]", ",", 
                 RowBox[{"1", "+", "m"}], ",", "0", ",", "spin"}], "]"}], "[", 
               RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", "m"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"k", "*", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], "-", 
                   RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "k", "+", "l"}], ")"}], "*", "m"}], "+", 
                   RowBox[{"2", "*", 
                    RowBox[{"m", "^", "2"}]}]}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "+", "k"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Psi]", ",", "m", ",", "0", ",", "spin"}], "]"}], 
               "[", 
               RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"k", "===", "0"}], ",", "0", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", "m"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"k", "-", "m"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k", "+", "l", "-", "m"}], ")"}], "*", 
                   "m"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"k", "+", "l", "-", 
                    RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}]}], "]"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Psi]", ",", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m"}], ",", "0", ",", "spin"}], 
                "]"}], "[", 
               RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "k"}], "+", "m"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"k", "+", "l", "-", 
                 RowBox[{"2", "*", "m"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{"1", "+", "m"}], ",", "0", ",", "spin"}], "]"}], "[", 
               RowBox[{"twistcd", "[", "\[Psi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"l", "*", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", "k", "+", "l"}], ")"}]}], "-", 
                 RowBox[{"2", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "k", "+", "l"}], ")"}], "*", "m"}], "+", 
                 
                 RowBox[{"2", "*", 
                  RowBox[{"m", "^", "2"}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "+", "l"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"k", "+", "l", "-", 
                   RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", "m", ",", "0", ",", "spin"}], "]"}], 
               "[", 
               RowBox[{"curlcd", "[", "\[Psi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"l", "===", "0"}], ",", "0", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"l", "-", "m"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k", "+", "l", "-", "m"}], ")"}], "*", 
                   "m"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"l", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"k", "+", "l", "-", 
                    RowBox[{"2", "*", "m"}]}], ")"}]}], ")"}]}]}], "]"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m"}], ",", "0", ",", "spin"}], 
                "]"}], "[", 
               RowBox[{"divcd", "[", "\[Psi]", "]"}], "]"}]}], "]"}]}], 
           "]"}]}], "]"}], "/;", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]", 
           "]"}], "===", "0"}], "&&", 
         RowBox[{
          RowBox[{
           RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Psi]", 
           "]"}], "===", "0"}]}]}]}], ",", 
      RowBox[{
       RowBox[{"twistcd", "[", 
        RowBox[{
         RowBox[{"SymMult", "[", 
          RowBox[{"\[Phi]_", ",", "m_", ",", "0", ",", "spin"}], "]"}], "[", 
         "\[Psi]_", "]"}], "]"}], ":>", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"k", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "\[Phi]",
               "]"}]}], ",", 
            RowBox[{"l", "=", 
             RowBox[{
              RowBox[{"NumOfUnprimedSlots", "[", "spin", "]"}], "[", "\[Psi]",
               "]"}]}]}], "}"}], ",", 
          RowBox[{"TensorPlus", "[", 
           RowBox[{
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", "m"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Psi]", ",", "m", ",", "0", ",", "spin"}], "]"}], 
               "[", 
               RowBox[{"twistcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", "m"}], "*", "m"}], ")"}], 
               "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "k"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Psi]", ",", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m"}], ",", "0", ",", "spin"}], 
                "]"}], "[", 
               RowBox[{"curlcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"k", "===", "0"}], ",", "0", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", "m"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m"}], ")"}], "*", "m"}], ")"}], 
                 "/", 
                 RowBox[{"(", 
                  RowBox[{"k", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "k"}], ")"}]}], ")"}]}]}], "]"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Psi]", ",", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "m"}], ",", "0", ",", "spin"}], 
                "]"}], "[", 
               RowBox[{"divcd", "[", "\[Phi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{
             RowBox[{"SymMult", "[", 
              RowBox[{"\[Phi]", ",", "m", ",", "0", ",", "spin"}], "]"}], "[", 
             RowBox[{"twistcd", "[", "\[Psi]", "]"}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "*", "m"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "+", "l"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m"}], ",", "0", ",", "spin"}], 
                "]"}], "[", 
               RowBox[{"curlcd", "[", "\[Psi]", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"MultScal", "[", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"l", "===", "0"}], ",", "0", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m"}], ")"}], "*", "m"}], ")"}], 
                 "/", 
                 RowBox[{"(", 
                  RowBox[{"l", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "l"}], ")"}]}], ")"}]}]}], "]"}], ",", 
              RowBox[{
               RowBox[{"SymMult", "[", 
                RowBox[{"\[Phi]", ",", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "m"}], ",", "0", ",", "spin"}], 
                "]"}], "[", 
               RowBox[{"divcd", "[", "\[Psi]", "]"}], "]"}]}], "]"}]}], 
           "]"}]}], "]"}], "/;", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Phi]", 
           "]"}], "===", "0"}], "&&", 
         RowBox[{
          RowBox[{
           RowBox[{"NumOfPrimedSlots", "[", "spin", "]"}], "[", "\[Psi]", 
           "]"}], "===", "0"}]}]}]}]}], "\[IndentingNewLine]", "}"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQHTPlzEeNmreOHddtPoPokktWP0G0wv7XPJpAWqBf
XhBEHwlaC6YZJq/3ANE2qUzRYHnj8ngQLcN1F0zfcVLNANF/DghmgugflXMK
wOr+7SkGm7MprwtE8/QrdIPoA5e8JoHoJXwBYFpn3o35YPNmSywA0StY5m8A
0Q39u8A0h8mF3SD6w7Z3YLrEdsN+EG3AevIwiNa4lHgF7D7VxOtg+5Zl3QXR
MSeePgXRKZ+ufAHRCRJaX0H0hlM3lmuB5HdOXwmiW1rZNoDoGcfWgWmdbeWf
QPSCNUV/QDQA66KWnA==
  "],
 CellLabel->
  "In[105]:=",ExpressionUUID->"4307d7e6-cded-574a-b6af-e99097f6504e"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5. End private and package", "Subsection",
 CellChangeTimes->{3.527145154765854*^9, 3.5292318049006476`*^9, 
  3.5703537164502516`*^9, 3.5703543041198835`*^9, 3.617690981205107*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"f88cfed4-1778-4799-b9df-9e78aa8beb5a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->
  "In[106]:=",ExpressionUUID->"8e64f184-960e-41c1-84da-a4cd8ec03a83"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6. Examples", "Subsection",
 CellChangeTimes->{3.5271451565598564`*^9, 3.529231807084652*^9, 
  3.570353718961856*^9, 3.5703543056018867`*^9, 3.6176909837751107`*^9},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"ab924ac9-7e77-441f-a3ca-df4c8046f515"],

Cell["The user context is empty :", "Text",ExpressionUUID->"e7456fdd-e881-46ed-a381-a6b1f5fe8e08"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Global`*"}]], "Input",
 CellChangeTimes->{{3.9585602873017445`*^9, 3.958560288891964*^9}, {
  3.958692697117174*^9, 3.9586926985226727`*^9}, {3.9597012318680897`*^9, 
  3.95970123527133*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"6e20b6ef-391d-46a6-9c64-e43434a2815c"],

Cell[BoxData[
 RowBox[{"Missing", "[", 
  RowBox[{"\<\"UnknownSymbol\"\>", ",", "\<\"Global`*\"\>"}], "]"}]], "Output",\

 CellChangeTimes->{3.9597012546009808`*^9, 3.959701341005274*^9, 
  3.9597014900862617`*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"bba5cb8e-73fd-844d-bc99-2e68168133c4"]
}, Open  ]],

Cell["Define a manifold", "Text",
 CellChangeTimes->{{3.517390655215265*^9, 
  3.5173906600668736`*^9}},ExpressionUUID->"393d3c18-af0b-48d3-9d6e-\
d756d8091dbe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{3.690020917624571*^9},
 CellLabel->
  "In[109]:=",ExpressionUUID->"a180e70a-0dc3-4e44-bdb0-fd0185b1296a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"AutomaticRules", ",", 
    RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{3.584427462866954*^9, 3.690020907874571*^9},
 CellLabel->
  "In[110]:=",ExpressionUUID->"684fe5b0-337e-4fb5-84c6-b4d597d55ce3"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M4", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "h", ",", "l", ",", "m",
      ",", "p", ",", "q"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.458061600629331*^9, 3.4580616119243917`*^9}, 
   3.4930234672464*^9, 3.4930252618884*^9, {3.4930256821434*^9, 
   3.4930256973644*^9}, 3.5844293408782525`*^9, 3.5844293831699266`*^9},
 CellLabel->
  "In[111]:=",ExpressionUUID->"3a145ba2-458e-4ec7-8945-801a89cdf3c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.584428050021785*^9, 3.584428050271385*^9}, {
  3.5844293080557947`*^9, 3.5844293081181946`*^9}, {3.584429390423939*^9, 
  3.584429399097554*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"dd08d7bd-e931-4310-ad84-0b2ed05288ed"],

Cell[BoxData["0.265625`"], "Print",
 CellChangeTimes->{
  3.570354959555035*^9, 3.5703573278117948`*^9, 3.570357447043804*^9, 
   3.5703575336395564`*^9, 3.570357611561693*^9, 3.570357747485732*^9, 
   3.5703578052838335`*^9, 3.570357850570713*^9, 3.57035790562321*^9, 
   3.5703579403332705`*^9, 3.5703580043401833`*^9, 3.570358233270585*^9, 
   3.5703586288248796`*^9, 3.570359217555314*^9, 3.5703593081446733`*^9, 
   3.57035985893484*^9, 3.570360128924515*^9, 3.570360998361842*^9, 
   3.570361077500781*^9, 3.5703612164190245`*^9, 3.570361488592703*^9, 
   3.5703615696192455`*^9, 3.570361670192622*^9, 3.570361879326589*^9, 
   3.570362845390486*^9, 3.570363012341979*^9, 3.5703631509170227`*^9, 
   3.570363239431578*^9, 3.5703633003184853`*^9, 3.570363362687395*^9, 
   3.5703635577501373`*^9, 3.5703640870434666`*^9, 3.5703641661980057`*^9, 
   3.5703643674237595`*^9, 3.5703644734259453`*^9, 3.570364559054496*^9, 
   3.570364724835987*^9, 3.57036486336423*^9, 3.5703649344067554`*^9, 
   3.5703650454633503`*^9, 3.5703654044511805`*^9, 3.570365463949685*^9, 
   3.570365728026949*^9, 3.570365792096262*^9, {3.5703658560407743`*^9, 
   3.5703658749324074`*^9}, 3.570365938050118*^9, 3.5703659895770082`*^9, 
   3.5703660973273983`*^9, 3.5703661770591383`*^9, 3.5703662337184377`*^9, 
   3.57036629806855*^9, 3.570366340095024*^9, 3.5703664069411416`*^9, 
   3.5703664382503967`*^9, 3.570366574095435*^9, 3.57036694670209*^9, 
   3.5703672465970163`*^9, 3.5703674014116883`*^9, 3.570367496166255*^9, 
   3.570367761539321*^9, 3.5703678091350045`*^9, 3.570367865653904*^9, 
   3.5703685585915213`*^9, 3.5703686403980646`*^9, 3.570368784011917*^9, 
   3.57036887106007*^9, 3.570368931525776*^9, 3.570426911764575*^9, 
   3.570427528605259*^9, 3.570427598213581*^9, 3.570427668039304*^9, 
   3.570427754962656*^9, 3.5704319416532097`*^9, 3.570432184077636*^9, 
   3.5704330985834417`*^9, 3.5704365150747595`*^9, 3.570438039525037*^9, 
   3.5704381719078693`*^9, 3.570438260609625*^9, 3.570438352244186*^9, 
   3.5704385731561737`*^9, 3.5704387571272974`*^9, 3.5704388131313953`*^9, 
   3.576988549564255*^9, 3.5769896655444155`*^9, 3.576989714341301*^9, 
   3.5769897569761763`*^9, 3.5769897974738474`*^9, 3.5769901349960403`*^9, 
   3.576990315535157*^9, 3.5769903621012387`*^9, 3.576990528366331*^9, 
   3.576991389640444*^9, 3.576991613313637*^9, 3.5769924518473096`*^9, 
   3.576992813611945*^9, 3.5769933553228965`*^9, 3.576993432387032*^9, 
   3.5769937368215666`*^9, 3.5769941750741367`*^9, 3.5769951071289735`*^9, 
   3.576995250867626*^9, 3.584427434771304*^9, 3.584427679442134*^9, 
   3.584427743761047*^9, 3.584428034546558*^9, 3.584428064951011*^9, 
   3.5844284796933393`*^9, 3.584428999612053*^9, 3.584429243346881*^9, {
   3.5844293354962425`*^9, 3.584429365339095*^9}, 3.5844294395952253`*^9, 
   3.5844296163747363`*^9, 3.584430000386011*^9, 3.5844315219356833`*^9, 
   3.5844319946643133`*^9, 3.617688621869114*^9, 3.6176886681091785`*^9, 
   3.617688745009286*^9, 3.617688853379438*^9, 3.6176888995435505`*^9, 
   3.617689374609264*^9, 3.6176894165293226`*^9, 3.61768953012353*^9, 
   3.6176896104036427`*^9, 3.6176897751138735`*^9, 3.662875893809738*^9, 
   3.6630604747882323`*^9, 3.663060521191016*^9, 3.6630606317762346`*^9, 
   3.66306070567367*^9, 3.690020734954571*^9, 3.690020922774571*^9, 
   3.690021108234571*^9, 3.690026108052571*^9, 3.690026180162571*^9, 
   3.910340378435272*^9, 3.9103443743071923`*^9, 3.9597012549191246`*^9, 
   3.959701341346361*^9, 3.959701490401394*^9},
 CellLabel->
  "During evaluation of \
In[112]:=",ExpressionUUID->"e672fda2-33f3-1e40-baa2-7640d2c39681"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"DefSpinor", ",", 
    RowBox[{"PrintDaggerAs", "\[Rule]", "AddBar"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.6117313077172728`*^9, 3.61173132026729*^9}, {
  3.611731410167416*^9, 3.6117314105874166`*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"bd62f093-4f3e-4fee-a5b7-000e480ac4bd"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"ValidateSymbol", "::", "\"\<capital\>\""}], "]"}]], "Input",
 CellLabel->
  "In[114]:=",ExpressionUUID->"f6db5701-4367-4310-8df7-dd9ff91d102a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"DefAbstractIndex", ",", 
    RowBox[{"PrintAs", "\[Rule]", "PrimeDagger"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.5983460248059864`*^9, 3.598346033935999*^9}, {
   3.5983462472362976`*^9, 3.598346265086323*^9}, 3.959701264880478*^9},
 CellLabel->
  "In[115]:=",ExpressionUUID->"a41aec68-ed86-47e4-a490-9e13762f8c3a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{
    "A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "H", ",", "L", ",", "M",
      ",", "P", ",", "Q", ",", "R", ",", "S"}], "}"}], ",", "\[Epsilon]", ",",
    "\[Sigma]", ",", "CDe", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}], ",", 
   RowBox[{"SpinorPrefix", "->", "SP"}], ",", 
   RowBox[{"SpinorMark", "->", "\"\<S\>\""}]}], "]"}]], "Input",
 CellLabel->
  "In[116]:=",ExpressionUUID->"c778d003-9de9-42c5-b584-771d25b3e6fd"],

Cell[BoxData["0.203125`"], "Print",
 CellChangeTimes->{{3.5703549484166155`*^9, 3.570354960007436*^9}, 
   3.570357328435796*^9, 3.570357447480605*^9, 3.5703575341075573`*^9, 
   3.5703576120140944`*^9, 3.570357748062933*^9, 3.5703578058610344`*^9, 
   3.570357851163514*^9, 3.57035790607561*^9, 3.5703579411132717`*^9, 
   3.570358004948584*^9, 3.570358233769786*^9, 3.570358629277281*^9, 
   3.570359218054515*^9, 3.570359308643874*^9, 3.570359859449641*^9, 
   3.570360129376916*^9, 3.5703609989858427`*^9, 3.570361078015582*^9, 
   3.570361216965026*^9, 3.5703614890451035`*^9, 3.570361570165246*^9, 
   3.5703616707386227`*^9, 3.57036187982579*^9, 3.570362845936487*^9, 
   3.57036301279438*^9, 3.570363151447424*^9, 3.570363239946379*^9, 
   3.5703633007864857`*^9, 3.5703633632333956`*^9, 3.570363558280538*^9, 
   3.570364087667468*^9, 3.570364166728407*^9, 3.5703643679541607`*^9, 
   3.5703644739407463`*^9, 3.570364559584897*^9, 3.5703647254755883`*^9, 
   3.5703648639102316`*^9, 3.5703649349527564`*^9, 3.570365045962551*^9, 
   3.570365405075182*^9, 3.5703654645736866`*^9, 3.5703657286509504`*^9, 
   3.5703657925330625`*^9, {3.570365856555575*^9, 3.5703658753692083`*^9}, 
   3.5703659385493193`*^9, 3.5703659900294094`*^9, 3.570366097951399*^9, 
   3.570366177573939*^9, 3.5703662342488384`*^9, 3.5703662986145515`*^9, 
   3.5703663405474253`*^9, 3.5703664073935423`*^9, 3.570366438702798*^9, 
   3.570366574532236*^9, 3.5703669471388903`*^9, 3.570367247096217*^9, 
   3.5703674020356894`*^9, 3.570367496665456*^9, 3.570367762069722*^9, 
   3.570367809634206*^9, 3.570367866153105*^9, 3.570368559121922*^9, 
   3.5703686408972654`*^9, 3.5703687846359177`*^9, 3.570368871699671*^9, 
   3.570368932056177*^9, 3.5704269121857758`*^9, 3.570427529057659*^9, 
   3.5704275986659813`*^9, 3.5704276684605045`*^9, 3.570427755415057*^9, 
   3.5704319421680107`*^9, 3.5704321845144367`*^9, 3.5704330990202427`*^9, 
   3.5704365154959598`*^9, 3.5704380399618373`*^9, 3.57043817239147*^9, 
   3.570438261062026*^9, 3.570438352680987*^9, 3.5704385736553745`*^9, 
   3.5704387577200985`*^9, 3.5704388136149964`*^9, 3.5769885500010557`*^9, 
   3.576989666028016*^9, 3.576989714824902*^9, 3.5769897574129767`*^9, 
   3.576989797926248*^9, 3.576990135510841*^9, 3.5769903160031576`*^9, 
   3.5769903625692396`*^9, 3.5769905288499317`*^9, 3.5769913901084447`*^9, 
   3.5769916137972374`*^9, 3.5769924523465104`*^9, 3.576992814220346*^9, 
   3.5769933558064976`*^9, 3.576993432870633*^9, 3.5769937373207674`*^9, 
   3.576994175542137*^9, 3.5769951075969744`*^9, 3.576995251351227*^9, 
   3.5844274428677187`*^9, 3.5844276797385345`*^9, 3.584430000713611*^9, 
   3.5844315222476835`*^9, 3.584431995023114*^9, 3.6176886221391144`*^9, 
   3.617688668399179*^9, 3.6176887452492867`*^9, 3.6176888536294384`*^9, 
   3.617688899773551*^9, 3.617689374889264*^9, 3.617689416799323*^9, 
   3.61768953040353*^9, 3.6176896107636433`*^9, 3.6176897754038734`*^9, 
   3.662875894059739*^9, 3.6630604751082516`*^9, 3.6630605216410437`*^9, 
   3.6630606321061783`*^9, 3.6630607060136123`*^9, 3.6900207352845707`*^9, 
   3.690020982664571*^9, 3.690021108564571*^9, 3.6900261084825706`*^9, 
   3.690026180472571*^9, 3.9103403793907194`*^9, 3.910344375236707*^9, 
   3.959701270501446*^9, 3.9597013415707626`*^9, 3.959701490633795*^9},
 CellLabel->
  "During evaluation of \
In[116]:=",ExpressionUUID->"96c99a5d-ef69-b64f-86a5-b82994fdf217"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"$PsiSign", "=", "1"}], ",", 
    RowBox[{"$PhiSign", "=", "1"}], ",", 
    RowBox[{"$LambdaSign", "=", "1"}], ",", 
    RowBox[{"$ChiSign", "=", "1"}], ",", 
    RowBox[{"$RicciSign", "=", "1"}], ",", 
    RowBox[{"$RiemannSign", "=", 
     RowBox[{"-", "1"}]}]}], "}"}], ";"}]], "Input",
 CellLabel->
  "In[117]:=",ExpressionUUID->"cf632184-f9f1-4d78-a4e2-77f388fcb44c"],

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"Nn", "[", "a", "]"}], ",", "M4", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<\[Tau]\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.570356843025343*^9, 3.570356859280572*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"a7f268da-69df-4585-813a-ba748cdc514b"],

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"ccc", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<c\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.570358587999608*^9, 3.5703586080924435`*^9}},
 CellLabel->
  "In[119]:=",ExpressionUUID->"89b372d5-181a-45ec-a161-43dcb1ad7840"],

Cell[BoxData[
 RowBox[{"AutomaticRules", "[", 
  RowBox[{"Nn", ",", 
   RowBox[{"MakeRule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Nn", "[", "a", "]"}], 
        RowBox[{"Nn", "[", 
         RowBox[{"-", "a"}], "]"}]}], ",", "ccc"}], "}"}], ",", 
     RowBox[{"MetricOn", "\[Rule]", "All"}], ",", " ", 
     RowBox[{"ContractMetrics", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.57035841827131*^9, 3.5703584353221397`*^9}, {
  3.570358562415563*^9, 3.5703585631487646`*^9}, {3.5703586127724514`*^9, 
  3.5703586131000524`*^9}},
 CellLabel->
  "In[120]:=",ExpressionUUID->"51ff3ca3-d57c-4390-9943-5f02837b734d"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"DefMetric", "::", "\"\<old\>\""}], "]"}]], "Input",
 CellLabel->
  "In[121]:=",ExpressionUUID->"e3fbd2ec-cedb-4eb8-8e2a-ecda77f80e90"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"metrich", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "cd", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<|\>\"", ",", "\"\<D\>\""}], "}"}], ",", 
   RowBox[{"InducedFrom", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"g", ",", "Nn"}], "}"}]}], ",", 
   RowBox[{"PrintAs", "->", "\"\<h\>\""}], ",", 
   RowBox[{"DefInfo", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->
  "In[122]:=",ExpressionUUID->"5f3e4e9a-bb43-410a-ba09-842876c0ae1a"],

Cell[BoxData["0.328125`"], "Print",
 CellChangeTimes->{
  3.5703571039202013`*^9, 3.5703573288725967`*^9, 3.5703574479486055`*^9, 
   3.5703575345755577`*^9, 3.570357612497695*^9, 3.5703577484685335`*^9, 
   3.570357806251035*^9, 3.570357852692317*^9, 3.5703579065436115`*^9, 
   3.5703579418308735`*^9, 3.570358005400985*^9, 3.5703582341909866`*^9, 
   3.5703586296828814`*^9, 3.5703592185069156`*^9, 3.5703593089714746`*^9, 
   3.570359859808442*^9, 3.570360129751316*^9, 3.570360999360244*^9, 
   3.5703610783587823`*^9, 3.5703612172926264`*^9, 3.5703614896691046`*^9, 
   3.5703615705084467`*^9, 3.5703616710818233`*^9, 3.570361880184591*^9, 
   3.570362846279688*^9, 3.5703630131843805`*^9, 3.5703631518062243`*^9, 
   3.5703632402739797`*^9, 3.5703633011920867`*^9, 3.5703633635765963`*^9, 
   3.570363558623739*^9, 3.5703640880106688`*^9, 3.570364167040407*^9, 
   3.570364368312961*^9, 3.5703644742527475`*^9, 3.5703645599280977`*^9, 
   3.5703647258343887`*^9, 3.570364864237832*^9, 3.5703649352959566`*^9, 
   3.570365046305752*^9, 3.570365405433983*^9, 3.570365464901287*^9, 
   3.570365728994151*^9, 3.570365792969863*^9, {3.570365856883176*^9, 
   3.570365875930809*^9}, 3.57036593889252*^9, 3.57036599052861*^9, 
   3.5703660990278006`*^9, 3.5703661779171395`*^9, 3.570366234592039*^9, 
   3.5703662990825524`*^9, 3.570366340953026*^9, 3.570366407752343*^9, 
   3.570366439092798*^9, 3.5703665749222364`*^9, 3.5703669475444913`*^9, 
   3.570367247423818*^9, 3.57036740242569*^9, 3.5703674969930563`*^9, 
   3.5703677623817225`*^9, 3.5703678099930058`*^9, 3.5703678665275054`*^9, 
   3.5703685594963226`*^9, 3.5703686412560663`*^9, 3.5703687849791183`*^9, 
   3.570368872183272*^9, 3.5703689323837776`*^9, 3.5704269125289764`*^9, 
   3.5704275294320602`*^9, 3.5704275990403824`*^9, 3.5704276688193045`*^9, 
   3.5704277558206577`*^9, 3.5704319425112114`*^9, 3.570432184888837*^9, 
   3.570433099379043*^9, 3.5704365158703604`*^9, 3.5704380403206377`*^9, 
   3.5704381727346706`*^9, 3.570438261436426*^9, 3.5704383530397873`*^9, 
   3.5704385739985757`*^9, 3.570438758078899*^9, 3.570438813942597*^9, 
   3.5769885505002565`*^9, 3.576989666340017*^9, 3.5769897151681023`*^9, 
   3.5769897577873774`*^9, 3.576989798316249*^9, 3.5769901358384414`*^9, 
   3.576990316330758*^9, 3.5769903629436407`*^9, 3.5769905291931324`*^9, 
   3.5769913904828453`*^9, 3.576991614124838*^9, 3.5769924526741114`*^9, 
   3.576992814547947*^9, 3.5769933561496983`*^9, 3.576993433198233*^9, 
   3.5769937376795683`*^9, 3.576994175900938*^9, 3.576995107940175*^9, 
   3.5769952516944275`*^9, 3.5844274727261705`*^9, 3.584427681126937*^9, 
   3.5844300647829237`*^9, 3.5844315233240857`*^9, 3.584431996115116*^9, 
   3.6176896112636433`*^9, 3.617689775973874*^9, 3.6628758945697393`*^9, 
   3.6630604757182884`*^9, 3.663060522271081*^9, 3.663060632756068*^9, 
   3.663060706583515*^9, 3.690020735904571*^9, 3.690020990504571*^9, 
   3.690021109194571*^9, 3.6900261091925707`*^9, 3.690026181032571*^9, 
   3.910340379889385*^9, 3.9103443757104425`*^9, 3.959701276753784*^9, 
   3.9597013420205593`*^9, 3.9597014910347347`*^9},
 CellLabel->
  "During evaluation of \
In[122]:=",ExpressionUUID->"b2d649f6-3852-a048-aeb8-f5403baf8c7d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DefSpaceSpinStructure", "[", 
  RowBox[{
  "\[Sigma]", ",", "metrich", ",", "t", ",", "spatial\[Sigma]", ",", "Dd", 
   ",", "nb"}], "]"}]], "Input",
 CellChangeTimes->{{3.5703569651735578`*^9, 3.57035697790318*^9}, {
   3.5703570283068686`*^9, 3.570357038790087*^9}, 3.5703572304520235`*^9, {
   3.5703573049733543`*^9, 3.5703573133505692`*^9}, 3.5703582441282043`*^9, {
   3.5703598732712655`*^9, 3.5703598742072673`*^9}, {3.5769900291186543`*^9, 
   3.576990031911059*^9}, {3.617692459338532*^9, 3.6176924598885326`*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"95071c09-855e-411b-a4b0-ac3cdaa082e4"],

Cell[CellGroupData[{

Cell[BoxData["ExtrKNnDef"], "Input",
 CellLabel->
  "In[124]:=",ExpressionUUID->"81c87314-e735-4a7e-a82e-325551a0d1b9"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"K", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ExtrKNn[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"Kh", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ExtrinsicKmetrich[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`spatial\[Sigma][$CellContext`a, -$CellContext`A, \
-$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`spatial\[Sigma][$CellContext`b, -C, -D],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{
  3.5844303781250744`*^9, 3.584431523464486*^9, 3.5844319962399163`*^9, 
   3.6176896202936563`*^9, 3.6176897760538745`*^9, 3.66287589471974*^9, 
   3.6630604758882985`*^9, 3.6630605223910885`*^9, 3.6630606328760476`*^9, 
   3.6630607067534866`*^9, 3.690020736054571*^9, 3.690021109304571*^9, 
   3.6900261093125706`*^9, 3.690026181222571*^9, 3.910340379984132*^9, 
   3.910344375810175*^9, {3.959701281259733*^9, 3.9597012979312553`*^9}, 
   3.959701344347336*^9, 3.959701493071251*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"78e37425-a89f-8545-b294-07109c9f7470"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpatialSFToSF", "[", "Nn", "]"}]], "Input",
 CellChangeTimes->{{3.5769926942873354`*^9, 3.5769927009485474`*^9}, {
  3.9597010490635757`*^9, 3.9597010497188225`*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"f63a09ae-79f3-430f-b607-fa2d050355b6"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "B"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`spatial\[Sigma][-$CellContext`a, $CellContext`A, \
$CellContext`B],
   Editable->False], "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {"B", 
                RowBox[{"A", "'"}]},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[$CellContext`B, $CellContext`A\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {" ", "A", " "},
               {"a", " ", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, \
-$CellContext`A\[Dagger]],
        Editable->False]}], 
      SqrtBox[
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]]], "+", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {"A", 
                RowBox[{"A", "'"}]},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[$CellContext`A, $CellContext`A\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {" ", "B", " "},
               {"a", " ", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][-$CellContext`a, $CellContext`B, \
-$CellContext`A\[Dagger]],
        Editable->False]}], 
      SqrtBox[
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]]]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.576992853719616*^9, 3.5769933572573*^9, 3.576993434321435*^9, 
   3.57699373881837*^9, 3.57699417702414*^9, 3.576995252817629*^9, 
   3.584431541217317*^9, 3.5844319962711163`*^9, 3.6176896531537027`*^9, 
   3.6176897760838747`*^9, 3.6628758947397394`*^9, 3.6630604759183006`*^9, 
   3.663060522401089*^9, 3.663060632996027*^9, 3.6630607067734833`*^9, 
   3.690020736084571*^9, 3.690021109334571*^9, 3.690026109332571*^9, 
   3.690026181242571*^9, 3.910340380015049*^9, 3.910344375847076*^9, {
   3.959701281296633*^9, 3.959701298348112*^9}, 3.959701344378252*^9, 
   3.959701493099201*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"bb7cf8b0-ec07-1140-9939-ea94ceb8749a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"EqToRule", "[", 
   RowBox[{"SFToSpatialSF", "[", "Nn", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5769933730133276`*^9, 3.576993382576144*^9}, 
   3.9597010570392437`*^9, {3.9597012906798153`*^9, 3.9597012926475143`*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"49884639-f520-409d-9f06-fdd97c4b7065"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "B"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`spatial\[Sigma][-$CellContext`a, $CellContext`A, \
$CellContext`B],
   Editable->False], "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {"B", 
                RowBox[{"A", "'"}]},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[$CellContext`B, $CellContext`A\[Dagger]],
        Editable->False], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Tau]", 
                StyleBox[GridBox[{
                   {" "},
                   {"a"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Nn[-$CellContext`a],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Tau]", 
                StyleBox[GridBox[{
                   {"A", " "},
                   {" ", 
                    RowBox[{"A", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`t[$CellContext`A, -$CellContext`A\[Dagger]],
            Editable->False]}], 
          InterpretationBox[
           StyleBox["c",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`ccc,
           Editable->False]], "-", 
         FractionBox[
          RowBox[{
           SqrtBox["2"], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Sigma]", 
                StyleBox[GridBox[{
                   {" ", "A", " "},
                   {"a", " ", "C"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`spatial\[Sigma][-$CellContext`a, $CellContext`A, -C],
            
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Tau]", 
                StyleBox[GridBox[{
                   {"C", " "},
                   {" ", 
                    RowBox[{"A", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`t[C, -$CellContext`A\[Dagger]],
            Editable->False]}], 
          SqrtBox[
           InterpretationBox[
            StyleBox["c",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ccc,
            Editable->False]]]}], ")"}]}], 
      SqrtBox[
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]]], "+", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {"A", 
                RowBox[{"A", "'"}]},
               {" ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[$CellContext`A, $CellContext`A\[Dagger]],
        Editable->False], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Tau]", 
                StyleBox[GridBox[{
                   {" "},
                   {"a"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`Nn[-$CellContext`a],
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Tau]", 
                StyleBox[GridBox[{
                   {"B", " "},
                   {" ", 
                    RowBox[{"A", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`t[$CellContext`B, -$CellContext`A\[Dagger]],
            Editable->False]}], 
          InterpretationBox[
           StyleBox["c",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`ccc,
           Editable->False]], "-", 
         FractionBox[
          RowBox[{
           SqrtBox["2"], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Sigma]", 
                StyleBox[GridBox[{
                   {" ", "B", " "},
                   {"a", " ", "D"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`spatial\[Sigma][-$CellContext`a, $CellContext`B, -D],
            
            Editable->False], " ", 
           InterpretationBox[
            StyleBox[GridBox[{
               {"\[Tau]", 
                StyleBox[GridBox[{
                   {"D", " "},
                   {" ", 
                    RowBox[{"A", "'"}]}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                 FontSize->Rational[39, 4]]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "Rows" -> {{Center}}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}}],
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`t[D, -$CellContext`A\[Dagger]],
            Editable->False]}], 
          SqrtBox[
           InterpretationBox[
            StyleBox["c",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ccc,
            Editable->False]]]}], ")"}]}], 
      SqrtBox[
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]]]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.5769933838085465`*^9, 3.576993434337035*^9, 3.5769937388495703`*^9, 
   3.57699417705534*^9, 3.5769952528488293`*^9, 3.584431549017331*^9, 
   3.5844319963023167`*^9, 3.617689786003888*^9, 3.6628758947697396`*^9, 
   3.6630604760183067`*^9, 3.6630605224410915`*^9, 3.663060633185995*^9, 
   3.6630607068034782`*^9, 3.690020736114571*^9, 3.690021109364571*^9, 
   3.690026109362571*^9, 3.690026181282571*^9, 3.9103403800479608`*^9, 
   3.9103443758829794`*^9, {3.9597012816068*^9, 3.9597012987570457`*^9}, 
   3.959701344414156*^9, 3.959701493131119*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"ed0c0ac7-0707-0942-9023-ffe5555417c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.5769934386582427`*^9, 3.576993444305453*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"9aafb9cc-ba74-4aca-ad28-e4680434c747"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.576993444508253*^9, 3.57699373888077*^9, 
  3.57699417710214*^9, 3.5769952528800297`*^9, 3.5844315500001326`*^9, 
  3.584431996333516*^9, 3.617689788693892*^9, 3.66287589479974*^9, 
  3.663060476278322*^9, 3.663060522461093*^9, 3.6630606332859783`*^9, 
  3.6630607068234744`*^9, 3.6900207361445713`*^9, 3.6900211093945713`*^9, 
  3.6900261093825707`*^9, 3.6900261813125706`*^9, 3.910340380072894*^9, 
  3.910344375917887*^9, 3.95970134871266*^9, 3.95970149315802*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"74f1a7c6-8482-c144-ba64-d9b30f47d7da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tSquareIrrDec", "=", 
  RowBox[{"IrrDecompose", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "[", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "A\[Dagger]"}]}], "]"}], 
     RowBox[{"t", "[", 
      RowBox[{
       RowBox[{"-", "B"}], ",", 
       RowBox[{"-", "B\[Dagger]"}]}], "]"}]}], ",", 
    RowBox[{"ResultType", "\[Rule]", "\"\<Equation\>\""}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.576992930861751*^9, 3.576992956554996*^9}, {
  3.6176898154279776`*^9, 3.6176898264679933`*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"f9d1aed7-1c2d-4b0f-8eb1-f898e1fa5945"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"A", 
            RowBox[{"A", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`t[-$CellContext`A, -$CellContext`A\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {" ", " "},
           {"B", 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`t[-$CellContext`B, -$CellContext`B\[Dagger]],
    Editable->False]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"A", "B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon][-$CellContext`A, -$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Epsilon]\[Dagger]", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             RowBox[{"A", "'"}], 
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]\[Dagger][-$CellContext`A\[Dagger], \
-$CellContext`B\[Dagger]],
     Editable->False]}], "+", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{
         UnderscriptBox["Sym", 
          StyleBox[
           RowBox[{
            RowBox[{"(", "13", ")"}], 
            RowBox[{"(", "24", ")"}]}],
           FontSize->Tiny]], "[", "\[Tau]", "\[Tau]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", " "},
           {"A", 
            RowBox[{"A", "'"}], "B", 
            RowBox[{"B", "'"}]}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`SymManipulator`SymH[{$CellContext`t, $CellContext`t}, 
     xAct`xPerm`StrongGenSet[{1, 2, 3, 4}, 
      xAct`xPerm`GenSet[
       xAct`xPerm`Cycles[{1, 3}], 
       xAct`xPerm`Cycles[{2, 4}]]], 
     "(13)(24)"][-$CellContext`A, -$CellContext`A\[Dagger], -$CellContext`B, \
-$CellContext`B\[Dagger]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{{3.5769929482557817`*^9, 3.576992957771798*^9}, 
   3.57699350528596*^9, 3.5769937390055704`*^9, 3.57699417721134*^9, 
   3.5769952529892297`*^9, 3.5844315556317425`*^9, 3.584431996458317*^9, {
   3.617689808347968*^9, 3.6176898269179935`*^9}, 3.66287589494974*^9, 
   3.663060476428331*^9, 3.663060522601101*^9, 3.6630606334459505`*^9, 
   3.6630607069734488`*^9, 3.6900207362845707`*^9, 3.6900211095345707`*^9, 
   3.690026109532571*^9, 3.690026181472571*^9, 3.9103403802105265`*^9, 
   3.9103443760126333`*^9, 3.959701353712311*^9, 3.9597014932318516`*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"3f9d3419-5616-a941-92e5-b5976f4a38fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SFToSpatialSF", "[", "Nn", "]"}]], "Input",
 CellChangeTimes->{{3.9597013574393177`*^9, 3.959701358486517*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"30538703-91ba-42a1-85cb-673633263209"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[-$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"A", 
              RowBox[{"A", "'"}]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[$CellContext`A, $CellContext`A\[Dagger]],
      Editable->False]}], 
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False]], "-", 
   FractionBox[
    RowBox[{
     SqrtBox["2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", "A", " "},
             {"a", " ", "B"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`spatial\[Sigma][-$CellContext`a, $CellContext`A, \
-$CellContext`B],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"B", 
              RowBox[{"A", "'"}]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[$CellContext`B, $CellContext`A\[Dagger]],
      Editable->False]}], 
    SqrtBox[
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False]]]}]}]], "Output",
 CellChangeTimes->{
  3.5769933918737607`*^9, 3.5769934485486603`*^9, {3.576993495769943*^9, 
   3.5769935055823603`*^9}, 3.576993545892831*^9, 3.5769937390211706`*^9, 
   3.5769941772425404`*^9, 3.5769952530048294`*^9, 3.5844315579405465`*^9, 
   3.584431996473917*^9, 3.617689830417999*^9, 3.6628758949597397`*^9, 
   3.663060476458333*^9, 3.6630605226111016`*^9, 3.663060633465947*^9, 
   3.6630607070034437`*^9, 3.690020736304571*^9, 3.690021109544571*^9, 
   3.6900261096525707`*^9, 3.690026181492571*^9, 3.910340380259396*^9, 
   3.9103443760475397`*^9, {3.959701355210308*^9, 3.959701359084917*^9}, 
   3.95970149325778*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"e9d564a1-fadb-0340-b044-ef6e1d120f9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"EqToRule", "@", 
   RowBox[{"SpatialSFToSF", "[", "Nn", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5769933730133276`*^9, 3.576993382576144*^9}, {
  3.5769934933831387`*^9, 3.576993494584341*^9}, {3.959701361610182*^9, 
  3.959701362215542*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"de4e014f-d63d-4a4e-9832-479eb205eecd"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[-$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"A", 
              RowBox[{"A", "'"}]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[$CellContext`A, $CellContext`A\[Dagger]],
      Editable->False]}], 
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False]], "-", 
   FractionBox[
    RowBox[{
     SqrtBox["2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"B", 
              RowBox[{"A", "'"}]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[$CellContext`B, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Tau]", 
              StyleBox[GridBox[{
                 {" ", 
                  RowBox[{"B", "'"}]},
                 {"B", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`t[-$CellContext`B, $CellContext`B\[Dagger]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Sigma]", 
              StyleBox[GridBox[{
                 {" ", "A", " "},
                 {"a", " ", 
                  RowBox[{"B", "'"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, \
-$CellContext`B\[Dagger]],
          Editable->False]}], 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          InterpretationBox[
           StyleBox["c",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`ccc,
           Editable->False]]}]], "+", 
       FractionBox[
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Tau]", 
              StyleBox[GridBox[{
                 {"A", 
                  RowBox[{"B", "'"}]},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`t[$CellContext`A, $CellContext`B\[Dagger]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Sigma]", 
              StyleBox[GridBox[{
                 {" ", " ", " "},
                 {"a", "B", 
                  RowBox[{"B", "'"}]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Sigma][-$CellContext`a, -$CellContext`B, \
-$CellContext`B\[Dagger]],
          Editable->False]}], 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          InterpretationBox[
           StyleBox["c",
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`ccc,
           Editable->False]]}]]}], ")"}]}], 
    SqrtBox[
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False]]]}]}]], "Output",
 CellChangeTimes->{
  3.5769933838085465`*^9, 3.576993434337035*^9, {3.576993496269144*^9, 
   3.576993506019161*^9}, 3.5769935464856324`*^9, 3.5769937390679703`*^9, 
   3.5769941772737403`*^9, 3.57699525303603*^9, 3.5844315598749495`*^9, 
   3.5844319965051165`*^9, 3.6176898330980024`*^9, 3.66287589498974*^9, 
   3.6630604769183607`*^9, 3.6630605226411037`*^9, 3.6630606335059404`*^9, 
   3.6630607070534353`*^9, 3.690020736384571*^9, 3.6900211095745707`*^9, 
   3.6900261096825705`*^9, 3.6900261815225706`*^9, 3.910340380303279*^9, 
   3.910344376088431*^9, 3.95970136279599*^9, 3.9597014932877026`*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"4c8262cb-a07a-3a4f-a6d1-3c2c354c8c86"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"Nn", "[", "a_", "]"}], "\[RuleDelayed]", 
   RowBox[{
    RowBox[{"SeparateSolderingForm", "[", "]"}], "@", 
    RowBox[{"Nn", "[", "a", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5769929996890717`*^9, 3.5769930426047473`*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"161f0ed4-1c3e-4e0c-b826-bba26a79a7f0"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"B", 
               RowBox[{"A", "'"}]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`t[$CellContext`B, $CellContext`A\[Dagger]],
       Editable->False], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Tau]", 
               StyleBox[GridBox[{
                  {" ", 
                   RowBox[{"B", "'"}]},
                  {"B", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`t[-$CellContext`B, $CellContext`B\[Dagger]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Sigma]", 
               StyleBox[GridBox[{
                  {" ", "A", " "},
                  {"a", " ", 
                   RowBox[{"B", "'"}]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, \
-$CellContext`B\[Dagger]],
           Editable->False]}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox[
           InterpretationBox[
            StyleBox["c",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ccc,
            Editable->False]]}]], "+", 
        FractionBox[
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Tau]", 
               StyleBox[GridBox[{
                  {"A", 
                   RowBox[{"B", "'"}]},
                  {" ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`t[$CellContext`A, $CellContext`B\[Dagger]],
           Editable->False], " ", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Sigma]", 
               StyleBox[GridBox[{
                  {" ", " ", " "},
                  {"a", "B", 
                   RowBox[{"B", "'"}]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`\[Sigma][-$CellContext`a, -$CellContext`B, \
-$CellContext`B\[Dagger]],
           Editable->False]}], 
         RowBox[{
          SqrtBox["2"], " ", 
          SqrtBox[
           InterpretationBox[
            StyleBox["c",
             ShowAutoStyles->False,
             AutoSpacing->False],
            $CellContext`ccc,
            Editable->False]]}]]}], ")"}]}], 
     SqrtBox[
      InterpretationBox[
       StyleBox["c",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ccc,
       Editable->False]]]}], "+", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"A", 
              RowBox[{"A", "'"}]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[$CellContext`A, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"B", 
              RowBox[{"B", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`B, -$CellContext`B\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", "B", 
              RowBox[{"B", "'"}]},
             {"a", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, $CellContext`B, $CellContext`B\
\[Dagger]],
      Editable->False]}], 
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False]]}]}]], "Output",
 CellChangeTimes->{{3.576993039547142*^9, 3.576993070013995*^9}, {
   3.576993137608914*^9, 3.576993171476574*^9}, {3.5769932546715193`*^9, 
   3.576993268493144*^9}, 3.5769935482484355`*^9, 3.5769937390835705`*^9, 
   3.57699417730494*^9, 3.57699525305163*^9, 3.584431560639351*^9, 
   3.584431996536317*^9, 3.617689834268004*^9, 3.66287589500974*^9, 
   3.6630604775783997`*^9, 3.663060522661105*^9, 3.6630606335459337`*^9, 
   3.6630607070834303`*^9, 3.690020736414571*^9, 3.690021109654571*^9, 
   3.690026109722571*^9, 3.690026181552571*^9, 3.9103403803361917`*^9, 
   3.910344376128324*^9, 3.9597013648584976`*^9, 3.959701493315626*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"e05d57d5-739e-ff4a-9f5e-76c4e968290a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.5769934386582427`*^9, 3.576993444305453*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"fdc33cb9-c29a-4f0c-ac7e-403c882e6925"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", "A", 
             RowBox[{"A", "'"}]},
            {"a", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
     Editable->False]}], "-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"A", 
              RowBox[{"B", "'"}]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[$CellContext`A, $CellContext`B\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"B", 
              RowBox[{"A", "'"}]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[$CellContext`B, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", " ", " "},
             {"a", "B", 
              RowBox[{"B", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
      Editable->False]}], 
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False]], "+", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"A", 
              RowBox[{"A", "'"}]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[$CellContext`A, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"B", 
              RowBox[{"B", "'"}]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[$CellContext`B, $CellContext`B\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", " ", " "},
             {"a", "B", 
              RowBox[{"B", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
      Editable->False]}], 
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False]]}]}]], "Output",
 CellChangeTimes->{
  3.576993444508253*^9, {3.576993497517146*^9, 3.5769935069239626`*^9}, 
   3.5769935501672387`*^9, 3.5769937391303706`*^9, 3.5769941773361406`*^9, 
   3.5769952530672297`*^9, 3.5844315614349527`*^9, 3.584431996567517*^9, 
   3.617689837808009*^9, 3.66287589504974*^9, 3.66306047774841*^9, 
   3.6630605228111134`*^9, 3.663060633585927*^9, 3.663060707133422*^9, 
   3.690020736454571*^9, 3.690021109694571*^9, 3.690026109752571*^9, 
   3.690026181592571*^9, 3.910340380371098*^9, 3.9103443761662235`*^9, 
   3.9597013659326286`*^9, 3.9597014933465385`*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"dfd140ad-5c3d-3749-a2fb-427022deafd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"EqToRule", "@", "tSquareIrrDec"}]}]], "Input",
 CellChangeTimes->{{3.576993508265565*^9, 3.5769935215099883`*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"c7b47ff0-9241-4c09-b59d-948ba3780f9d"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", 
           RowBox[{"A", "'"}]},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Sigma]", 
         StyleBox[GridBox[{
            {" ", "A", 
             RowBox[{"A", "'"}]},
            {"a", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, $CellContext`A\
\[Dagger]],
     Editable->False]}], "+", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", " ", " "},
             {"a", "B", 
              RowBox[{"B", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "4"], " ", 
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]", 
             StyleBox[GridBox[{
                {"B", "A"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon][$CellContext`B, $CellContext`A],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]\[Dagger]", 
             StyleBox[GridBox[{
                {
                 RowBox[{"B", "'"}], 
                 RowBox[{"A", "'"}]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon]\[Dagger][$CellContext`B\[Dagger], \
$CellContext`A\[Dagger]],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{
             UnderscriptBox["Sym", 
              StyleBox[
               RowBox[{
                RowBox[{"(", "13", ")"}], 
                RowBox[{"(", "24", ")"}]}],
               FontSize->Tiny]], "[", "\[Tau]", "\[Tau]", "]"}], 
            StyleBox[GridBox[{
               {"A", 
                RowBox[{"A", "'"}], "B", 
                RowBox[{"B", "'"}]},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`SymManipulator`SymH[{$CellContext`t, $CellContext`t}, 
         xAct`xPerm`StrongGenSet[{1, 2, 3, 4}, 
          xAct`xPerm`GenSet[
           xAct`xPerm`Cycles[{1, 3}], 
           xAct`xPerm`Cycles[{2, 4}]]], 
         "(13)(24)"][$CellContext`A, $CellContext`A\[Dagger], $CellContext`B, \
$CellContext`B\[Dagger]],
        Editable->False]}], ")"}]}], 
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False]], "-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", " ", " "},
             {"a", "B", 
              RowBox[{"B", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "4"], " ", 
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]", 
             StyleBox[GridBox[{
                {"B", "A"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon][$CellContext`B, $CellContext`A],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Epsilon]\[Dagger]", 
             StyleBox[GridBox[{
                {
                 RowBox[{"A", "'"}], 
                 RowBox[{"B", "'"}]},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`\[Epsilon]\[Dagger][$CellContext`A\[Dagger], \
$CellContext`B\[Dagger]],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{
             UnderscriptBox["Sym", 
              StyleBox[
               RowBox[{
                RowBox[{"(", "13", ")"}], 
                RowBox[{"(", "24", ")"}]}],
               FontSize->Tiny]], "[", "\[Tau]", "\[Tau]", "]"}], 
            StyleBox[GridBox[{
               {"A", 
                RowBox[{"B", "'"}], "B", 
                RowBox[{"A", "'"}]},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`SymManipulator`SymH[{$CellContext`t, $CellContext`t}, 
         xAct`xPerm`StrongGenSet[{1, 2, 3, 4}, 
          xAct`xPerm`GenSet[
           xAct`xPerm`Cycles[{1, 3}], 
           xAct`xPerm`Cycles[{2, 4}]]], 
         "(13)(24)"][$CellContext`A, $CellContext`B\[Dagger], $CellContext`B, \
$CellContext`A\[Dagger]],
        Editable->False]}], ")"}]}], 
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False]]}]}]], "Output",
 CellChangeTimes->{{3.5769935220871897`*^9, 3.576993551384041*^9}, 
   3.5769937391615705`*^9, 3.57699417736734*^9, 3.5769952530984297`*^9, 
   3.5844315625425544`*^9, 3.5844319965987167`*^9, 3.6176898388580103`*^9, 
   3.6628758950697403`*^9, 3.6630604778384156`*^9, 3.663060522851116*^9, 
   3.663060633615922*^9, 3.6630607072134085`*^9, 3.690020736474571*^9, 
   3.690021109734571*^9, 3.690026109792571*^9, 3.690026181622571*^9, 
   3.9103403804050074`*^9, 3.91034437620512*^9, 3.9597013670167027`*^9, 
   3.9597014933754654`*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"2d8d8e2b-094a-8541-9c9f-6274733b6929"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.5769935237875924`*^9, 3.5769935280151997`*^9}},
 CellLabel->
  "In[134]:=",ExpressionUUID->"d890d309-c1cd-4cad-b5fe-745b9ac084f1"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.5769935282024*^9, 3.576993552444843*^9}, 
   3.576993739192771*^9, 3.5769941773985405`*^9, 3.57699525312963*^9, 
   3.584431563712557*^9, 3.584431996629917*^9, 3.6176898406280127`*^9, 
   3.66287589509974*^9, 3.6630604783884487`*^9, 3.663060522871117*^9, 
   3.6630606336559153`*^9, 3.6630607072534018`*^9, 3.690020736504571*^9, 
   3.690021109754571*^9, 3.690026109822571*^9, 3.6900261816425705`*^9, 
   3.910340380461855*^9, 3.910344376239029*^9, 3.959701368206518*^9, 
   3.959701493398409*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"0bf02e16-c754-a541-b4a1-2ac763a3e2e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", "A", ",", "A\[Dagger]"}], "]"}], 
  RowBox[{"\[Sigma]", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.576991394211252*^9, 3.5769914259885077`*^9}, 
   3.5769916398648834`*^9, 3.5769916863061647`*^9},
 CellLabel->
  "In[135]:=",ExpressionUUID->"1e7a4947-23d4-443b-bab5-405189e6b514"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{{3.576991416815692*^9, 3.5769914267217093`*^9}, {
   3.57699163228327*^9, 3.5769916404888844`*^9}, 3.5769916866181655`*^9, 
   3.576992453812913*^9, 3.5769935671400685`*^9, 3.5769937392083707`*^9, 
   3.5769941774141407`*^9, 3.57699525312963*^9, 3.584431565132159*^9, 
   3.5844319966455173`*^9, 3.617689841768015*^9, 3.66287589509974*^9, 
   3.6630604784284506`*^9, 3.663060522871117*^9, 3.663060633675912*^9, 
   3.6630607072633996`*^9, 3.690020736514571*^9, 3.690021109764571*^9, 
   3.690026109822571*^9, 3.6900261816525707`*^9, 3.9103403804827986`*^9, 
   3.9103443762789216`*^9, 3.9597013699857597`*^9, 3.9597014934203186`*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"0c10dec3-b062-e741-bbe8-0c78d2cf4565"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"spatial\[Sigma]", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", "A", ",", "B"}], "]"}], 
  RowBox[{"spatial\[Sigma]", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.576991444942541*^9, 3.5769914537097564`*^9}, {
  3.576991665183728*^9, 3.57699168909857*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"29a427ae-be69-4c1d-bb2e-b83ce923ec29"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {" ", "A", "B"},
          {"a", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`spatial\[Sigma][-$CellContext`a, $CellContext`A, \
$CellContext`B],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Sigma]", 
       StyleBox[GridBox[{
          {"a", " ", " "},
          {" ", "A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`spatial\[Sigma][$CellContext`a, -$CellContext`A, \
-$CellContext`B],
   Editable->False]}]], "Output",
 CellChangeTimes->{
  3.576991454458558*^9, {3.576991632954071*^9, 3.5769916894729705`*^9}, {
   3.5769935676704693`*^9, 3.5769935773580866`*^9}, 3.5769937392395706`*^9, 
   3.5769941774453406`*^9, 3.5769952531452303`*^9, 3.584431566208561*^9, 
   3.5844319966611176`*^9, 3.617689842598016*^9, 3.6628758951097403`*^9, 
   3.663060478448452*^9, 3.663060522881118*^9, 3.663060633705907*^9, 
   3.663060707273398*^9, 3.6900207365345707`*^9, 3.6900211097845707`*^9, 
   3.690026109842571*^9, 3.690026181662571*^9, 3.9103403804897804`*^9, 
   3.910344376357711*^9, {3.9597013700216637`*^9, 3.9597013766364937`*^9}, 
   3.9597014934462776`*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"3b22c529-8719-e64e-8b76-524f53814c60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"EqToRule", "@", 
   RowBox[{"SpatialSFToSF", "[", "Nn", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.576991456985762*^9, 3.576991493396226*^9}, {
  3.5769935728808784`*^9, 3.576993575938484*^9}, {3.959701372978279*^9, 
  3.959701373617569*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"27f8f483-7a47-4516-bcdb-895e57a399c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"B", 
               RowBox[{"A", "'"}]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`t[$CellContext`B, $CellContext`A\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {" ", "A", " "},
              {"a", " ", 
               RowBox[{"A", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][-$CellContext`a, $CellContext`A, -$CellContext`A\
\[Dagger]],
       Editable->False]}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]]}]], "+", 
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"A", 
               RowBox[{"A", "'"}]},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`t[$CellContext`A, $CellContext`A\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {" ", "B", " "},
              {"a", " ", 
               RowBox[{"A", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][-$CellContext`a, $CellContext`B, -$CellContext`A\
\[Dagger]],
       Editable->False]}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]]}]]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {" ", 
               RowBox[{"B", "'"}]},
              {"B", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`t[-$CellContext`B, $CellContext`B\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "A", 
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, -$CellContext`B\
\[Dagger]],
       Editable->False]}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]]}]], "+", 
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {" ", 
               RowBox[{"B", "'"}]},
              {"A", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`t[-$CellContext`A, $CellContext`B\[Dagger]],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Sigma]", 
           StyleBox[GridBox[{
              {"a", " ", " "},
              {" ", "B", 
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, -$CellContext`B\
\[Dagger]],
       Editable->False]}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]]}]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.5769916433592896`*^9, 3.5769916899721713`*^9}, {
   3.5769935683256707`*^9, 3.576993577763687*^9}, 3.576993739270771*^9, 
   3.5769941774609404`*^9, 3.5769952531764297`*^9, 3.584431567160163*^9, 
   3.584431996692317*^9, 3.6176898433680167`*^9, 3.66287589513974*^9, 
   3.6630604788984795`*^9, 3.6630605229211206`*^9, 3.6630606337658963`*^9, 
   3.6630607073233895`*^9, 3.6900207365745707`*^9, 3.690021109814571*^9, 
   3.690026109872571*^9, 3.690026181702571*^9, 3.9103403805157104`*^9, 
   3.9103443764025908`*^9, {3.9597013701473274`*^9, 3.959701377013485*^9}, 
   3.9597014934741726`*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"3fad9b04-02d4-2c43-bae2-b8c60361a255"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.5769916473528967`*^9, 3.576991657914115*^9}},
 CellLabel->
  "In[138]:=",ExpressionUUID->"b6219253-5cb6-420f-8b1f-55cbdca7c765"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{{3.5769916491468997`*^9, 3.5769916904713726`*^9}, 
   3.5769935786684885`*^9, 3.5769937392863708`*^9, 3.576994177492141*^9, 
   3.57699525319203*^9, 3.5844315680805645`*^9, 3.584431996707917*^9, 
   3.6176898442080183`*^9, 3.66287589514974*^9, 3.663060479058489*^9, 
   3.663060522931121*^9, 3.663060633775895*^9, 3.663060707333388*^9, 
   3.690020736584571*^9, 3.690021109834571*^9, 3.6900261098825707`*^9, 
   3.690026181712571*^9, 3.910340380535657*^9, 3.910344376432511*^9, 
   3.959701379135809*^9, 3.95970149349811*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"8baf265a-53c6-c44a-95c5-d33bfa989eb3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["AccNnToCDet"], "Input",
 CellChangeTimes->{{3.576993586109702*^9, 3.5769936108981457`*^9}, 
   3.576993725199546*^9, {3.5769941563853035`*^9, 3.5769941606909113`*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"f3c4773f-91e8-4d8f-b79a-3c9e764505e8"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"A", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`AccNn[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"B", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`B, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "\[Tau]"], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"A", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[
        xAct`xTensor`Dir[
         $CellContext`Nn[$CellContext`a]]][
        $CellContext`t[-$CellContext`A, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`A, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "\[Tau]"], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"B", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[
        xAct`xTensor`Dir[
         $CellContext`Nn[$CellContext`a]]][
        $CellContext`t[-$CellContext`B, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellChangeTimes->{{3.5769935886213064`*^9, 3.5769936115845466`*^9}, 
   3.5769937393175707`*^9, 3.5769937790664406`*^9, 3.5769938497969646`*^9, 
   3.576993894710444*^9, 3.576994177507741*^9, 3.57699525320763*^9, 
   3.584431569000966*^9, 3.5844319967235174`*^9, 3.617689845078019*^9, 
   3.6628758951697407`*^9, 3.6630604790884905`*^9, 3.6630605229411216`*^9, 
   3.663060633815888*^9, 3.6630607073533845`*^9, 3.690020736614571*^9, 
   3.6900211098545713`*^9, 3.6900261098925705`*^9, 3.6900261817325706`*^9, 
   3.91034038057954*^9, 3.9103443764654226`*^9, {3.9597013821987*^9, 
   3.9597013971167984`*^9}, 3.959701493528055*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"716dc2be-c029-2f43-a888-44f5abdb9515"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeparateDir", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5769937677252207`*^9, 3.5769937755564346`*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"2fc6835a-3a91-4846-83c6-d9d41e157246"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"A", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`AccNn[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"B", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`B, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"A", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[-$CellContext`a][
        $CellContext`t[-$CellContext`A, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`A, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"B", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[-$CellContext`b][
        $CellContext`t[-$CellContext`B, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellChangeTimes->{{3.5769937760712357`*^9, 3.5769937898616595`*^9}, 
   3.576993850218166*^9, 3.576993895194045*^9, 3.5769941850269537`*^9, 
   3.57699525322323*^9, 3.5844315707793694`*^9, 3.584431996739117*^9, 
   3.6176898458580203`*^9, 3.66287589518974*^9, 3.663060479118492*^9, 
   3.6630605229611225`*^9, 3.663060633835884*^9, 3.6630607073733807`*^9, 
   3.690020736634571*^9, 3.690021109874571*^9, 3.690026109912571*^9, 
   3.690026181762571*^9, 3.910340380685257*^9, 3.910344376518281*^9, {
   3.9597013822356014`*^9, 3.959701397160681*^9}, 3.959701493554985*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"2e335908-9721-7d43-9ef2-acad96f7a660"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{
    RowBox[{"t", "[", 
     RowBox[{"A_", ",", "Adg_"}], "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"SeparateSolderingForm", "[", "]"}], "@", 
     RowBox[{"t", "[", 
      RowBox[{"A", ",", "Adg"}], "]"}]}]}]}], "/.", 
  RowBox[{"CDe", "\[Rule]", "CD"}]}]], "Input",
 CellChangeTimes->{{3.576993796460471*^9, 3.5769938461777587`*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"9a380b65-8132-4a2b-a01e-1b3c2ef32d83"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"A", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`AccNn[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[-$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"c", " ", 
              RowBox[{"A", "'"}]},
             {" ", "B", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`c, -$CellContext`B, $CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"d", " ", " "},
             {" ", "A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`d, -$CellContext`A, -$CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" "},
               {"d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`a][
        $CellContext`Nn[-$CellContext`d]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"f"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[-$CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"f", " ", 
              RowBox[{"A", "'"}]},
             {" ", "A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`f, -$CellContext`A, $CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"h", " ", " "},
             {" ", "B", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`h, -$CellContext`B, -$CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" "},
               {"h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`b][
        $CellContext`Nn[-$CellContext`h]],
       Editable->False], ")"}]}]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellChangeTimes->{{3.576993821482915*^9, 3.5769938506081667`*^9}, 
   3.5769938957400455`*^9, 3.576994185713355*^9, 3.57699525323883*^9, 
   3.5844315808257866`*^9, 3.584431996770317*^9, 3.6176898466480217`*^9, 
   3.6628758952097406`*^9, 3.663060479158495*^9, 3.663060522981124*^9, 
   3.663060633865879*^9, 3.663060707403376*^9, 3.690020736674571*^9, 
   3.690021109914571*^9, 3.6900261099325705`*^9, 3.690026181792571*^9, 
   3.9103403807371464`*^9, 3.910344376551193*^9, {3.959701382267515*^9, 
   3.9597013971965847`*^9}, 3.959701493584877*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"6867af38-2e61-7944-8b8f-ff174119fd55"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GradNormalToExtrinsicK", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5769938347741385`*^9, 3.5769938381593447`*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"13c916d7-38a9-4857-9384-e129c2987671"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"A", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`AccNn[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"Kh", 
            StyleBox[GridBox[{
               {" ", " "},
               {"a", "d"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ExtrinsicKmetrich[-$CellContext`a, -$CellContext`d],
        Editable->False], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"A\[Tau]", 
             StyleBox[GridBox[{
                {" "},
                {"d"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`AccelerationNn[-$CellContext`d],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Tau]", 
             StyleBox[GridBox[{
                {" "},
                {"a"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Nn[-$CellContext`a],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[-$CellContext`c],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"c", " ", 
              RowBox[{"A", "'"}]},
             {" ", "B", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`c, -$CellContext`B, $CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"d", " ", " "},
             {" ", "A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`d, -$CellContext`A, -$CellContext`A\
\[Dagger]],
      Editable->False]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"Kh", 
            StyleBox[GridBox[{
               {" ", " "},
               {"b", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ExtrinsicKmetrich[-$CellContext`b, -$CellContext`h],
        Editable->False], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"A\[Tau]", 
             StyleBox[GridBox[{
                {" "},
                {"h"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`AccelerationNn[-$CellContext`h],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Tau]", 
             StyleBox[GridBox[{
                {" "},
                {"b"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`Nn[-$CellContext`b],
         Editable->False]}]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"f"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[-$CellContext`f],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"f", " ", 
              RowBox[{"A", "'"}]},
             {" ", "A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`f, -$CellContext`A, $CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {"h", " ", " "},
             {" ", "B", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][$CellContext`h, -$CellContext`B, -$CellContext`A\
\[Dagger]],
      Editable->False]}]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellChangeTimes->{{3.576993838486945*^9, 3.576993851154167*^9}, 
   3.576993896426447*^9, 3.5769941869145575`*^9, 3.57699525325443*^9, 
   3.584431582323389*^9, 3.5844319967859173`*^9, 3.617689847538023*^9, 
   3.6628758952397404`*^9, 3.6630604791984973`*^9, 3.6630605230111256`*^9, 
   3.6630606338858757`*^9, 3.6630607074333706`*^9, 3.690020736704571*^9, 
   3.690021109944571*^9, 3.690026109962571*^9, 3.690026181822571*^9, 
   3.9103403807620773`*^9, 3.9103443765860996`*^9, {3.9597013866288776`*^9, 
   3.959701397233486*^9}, 3.959701493615822*^9},
 CellLabel->
  "Out[142]=",ExpressionUUID->"a0e0cb7e-6f26-a942-b181-cb71717135e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5769938548981743`*^9, 3.5769938581117797`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"6369bfde-ef54-4190-b2be-ffc123ceae9c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"A", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`AccNn[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"A\[Tau]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`AccelerationNn[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", " ", " "},
             {"a", "B", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, -$CellContext`B, -$CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", " ", 
              RowBox[{"A", "'"}]},
             {"b", "A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`b, -$CellContext`A, $CellContext`A\
\[Dagger]],
      Editable->False]}], 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox[
      InterpretationBox[
       StyleBox["c",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ccc,
       Editable->False]]}]], "-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"A\[Tau]", 
          StyleBox[GridBox[{
             {"a"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`AccelerationNn[$CellContext`a],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {"b"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Nn[$CellContext`b],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", " ", 
              RowBox[{"A", "'"}]},
             {"a", "A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`a, -$CellContext`A, $CellContext`A\
\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Sigma]", 
          StyleBox[GridBox[{
             {" ", " ", " "},
             {"b", "B", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Sigma][-$CellContext`b, -$CellContext`B, -$CellContext`A\
\[Dagger]],
      Editable->False]}], 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox[
      InterpretationBox[
       StyleBox["c",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ccc,
       Editable->False]]}]]}]}]], "Output",
 CellChangeTimes->{
  3.576993858813781*^9, 3.5769938973468485`*^9, 3.5769941878037586`*^9, 
   3.57699525328563*^9, 3.58443158299419*^9, 3.5844319968327174`*^9, 
   3.617689848408024*^9, 3.6628758952797403`*^9, 3.6630604792384996`*^9, 
   3.6630605230411277`*^9, 3.663060633925869*^9, 3.6630607074633656`*^9, 
   3.6900207367445707`*^9, 3.690021109984571*^9, 3.690026110002571*^9, 
   3.690026181872571*^9, 3.9103403807879844`*^9, 3.9103443766180153`*^9, {
   3.9597013866777573`*^9, 3.9597013972654*^9}, 3.959701493646742*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"b4cd9aae-c71a-3e4f-bb50-b21562d7cae6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "[", 
   RowBox[{"%", "/.", 
    RowBox[{"EqToRule", "@", 
     RowBox[{"SFToSpatialSF", "[", "Nn", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5769938683297977`*^9, 3.5769938865194297`*^9}, {
  3.959701390113529*^9, 3.9597013914080677`*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"1608b1cf-f1f5-402a-8cd1-d80dfdf597b4"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"A", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`AccNn[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"A\[Tau]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`AccelerationNn[$CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"a", "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`spatial\[Sigma][-$CellContext`a, -$CellContext`A, \
-$CellContext`B],
    Editable->False]}]}]], "Output",
 CellChangeTimes->{{3.5769938794370174`*^9, 3.5769938982984505`*^9}, 
   3.576994189082961*^9, 3.57699525331683*^9, 3.584431583774192*^9, 
   3.5844319968639174`*^9, 3.6176898491980247`*^9, 3.6628758952997403`*^9, 
   3.663060479438512*^9, 3.66306052308113*^9, 3.6630606339658623`*^9, 
   3.663060707503359*^9, 3.6900207367845707`*^9, 3.690021110024571*^9, 
   3.690026110042571*^9, 3.6900261819025707`*^9, 3.910340380811947*^9, 
   3.9103443766469665`*^9, {3.9597013868003902`*^9, 3.9597013973003063`*^9}, 
   3.959701493671644*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"46b1c548-f9ae-f742-a129-610eedece301"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"EqToRule", "@", "AccNnDef"}]}]], "Input",
 CellChangeTimes->{{3.576994193778569*^9, 3.576994207818594*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"9466e2c6-f78d-47cf-9b41-2cb0adee06c8"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.5769942098933973`*^9, 3.5769952533324304`*^9, 3.584431584460593*^9, 
   3.5844319968795176`*^9, 3.617689849978026*^9, 3.66287589530974*^9, 
   3.663060479538518*^9, 3.6630605230911303`*^9, 3.6630606339758606`*^9, 
   3.663060707513357*^9, 3.690020736804571*^9, 3.690021110054571*^9, 
   3.690026110052571*^9, 3.690026181912571*^9, 3.9103403808308964`*^9, 
   3.9103443766719007`*^9, {3.959701386883169*^9, 3.959701399047634*^9}, 
   3.9597014936966057`*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"e95ce54f-0f05-9a4d-a3f2-dedb507ef5c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"metrich", "[", 
   RowBox[{
    RowBox[{"-", "b"}], ",", "c"}], "]"}], 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "c"}], "]"}], "@", 
   RowBox[{"Nn", "[", 
    RowBox[{"-", "a"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.576995310756131*^9, 3.5769953529240055`*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"db1af2d2-3bb5-49ee-829f-1d016f21d0e2"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"h", 
       StyleBox[GridBox[{
          {" ", "c"},
          {"b", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`metrich[-$CellContext`b, $CellContext`c],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
        {"\[Tau]", 
         StyleBox[GridBox[{
            {" "},
            {"a"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`c][
     $CellContext`Nn[-$CellContext`a]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{{3.5769953213641496`*^9, 3.57699536671443*^9}, 
   3.576995397836484*^9, 3.5769956288572903`*^9, 3.576995670774564*^9, 
   3.5844315852873945`*^9, 3.5844319968951178`*^9, 3.6176898507680273`*^9, 
   3.6628758953197403`*^9, 3.663060479558519*^9, 3.6630605230911303`*^9, 
   3.663060633985859*^9, 3.6630607075233555`*^9, 3.690020736834571*^9, 
   3.6900211100745707`*^9, 3.690026110072571*^9, 3.6900261819325705`*^9, 
   3.9103403808488197`*^9, 3.910344376701792*^9, {3.9597013869140873`*^9, 
   3.959701401885044*^9}, 3.9597014937205143`*^9},
 CellLabel->
  "Out[146]=",ExpressionUUID->"6e34d0af-8767-714b-bf9b-c60fb7bb27d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "@", 
   RowBox[{"GradNormalToExtrinsicK", "@", "%"}]}], "\[Equal]", "%"}]], "Input",\

 CellChangeTimes->{{3.5769953387123804`*^9, 3.5769953656380277`*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"d101dfce-465e-4067-9e30-d357d728fd93"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"Kh", 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ExtrinsicKmetrich[-$CellContext`a, -$CellContext`b],
   Editable->False], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"h", 
        StyleBox[GridBox[{
           {" ", "c"},
           {"b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metrich[-$CellContext`b, $CellContext`c],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`Nn[-$CellContext`a]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.5769953411459846`*^9, 3.57699536715123*^9}, 
   3.576995403046893*^9, 3.5769956293096905`*^9, 3.5769956708213634`*^9, 
   3.5844315860361958`*^9, 3.5844319969107175`*^9, 3.617689851508028*^9, 
   3.6628758953297405`*^9, 3.66306047957852*^9, 3.6630605231111317`*^9, 
   3.6630606340058556`*^9, 3.6630607075533504`*^9, 3.6900207368545713`*^9, 
   3.6900211101045713`*^9, 3.690026110082571*^9, 3.690026181952571*^9, 
   3.910340380866774*^9, 3.910344376731711*^9, {3.9597013869430103`*^9, 
   3.9597014019239407`*^9}, 3.9597014937494373`*^9},
 CellLabel->
  "Out[147]=",ExpressionUUID->"cdb651db-3db5-784f-b0d2-80ecee56d036"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtrKNnDef", "/.", 
   RowBox[{"EqToRule", "@", "%"}]}], "/.", 
  RowBox[{"CD", "\[Rule]", "CDe"}]}]], "Input",
 CellChangeTimes->{{3.5769952635816483`*^9, 3.5769952677156553`*^9}, {
  3.576995370068435*^9, 3.576995374982444*^9}, {3.576995405308897*^9, 
  3.5769954077269015`*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"d9d5a7c8-9805-476c-8a5b-8fc747049aa0"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"K", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ExtrKNn[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"a", " ", " "},
           {" ", "A", "B"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`spatial\[Sigma][$CellContext`a, -$CellContext`A, \
-$CellContext`B],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {"b", " ", " "},
           {" ", "C", "D"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`spatial\[Sigma][$CellContext`b, -C, -D],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`b][
      $CellContext`Nn[-$CellContext`a]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.5769952688856573`*^9, 3.576995376526847*^9, 3.576995408179302*^9, 
   3.5769956296684914`*^9, 3.576995670852564*^9, 3.584431586800597*^9, 
   3.5844319969419174`*^9, 3.617689852258029*^9, 3.6628758953497405`*^9, 
   3.6630604796585245`*^9, 3.663060523131133*^9, 3.663060634025852*^9, 
   3.6630607075833454`*^9, 3.690020736884571*^9, 3.690021110134571*^9, 
   3.6900261101025705`*^9, 3.690026181972571*^9, 3.910340380885749*^9, 
   3.91034437676562*^9, {3.959701386974924*^9, 3.959701401953861*^9}, 
   3.9597014937773895`*^9},
 CellLabel->
  "Out[148]=",ExpressionUUID->"921f4f6c-c945-334d-ad08-b789d60a0481"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"EqToRule", "@", 
   RowBox[{"SpatialSFToSF", "[", "Nn", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.576995272629664*^9, 3.576995282098881*^9}, {
  3.5769954132337112`*^9, 3.576995415464515*^9}, {3.9597014033770523`*^9, 
  3.959701404886492*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"dfb8975d-5449-460e-887a-fb64f986951b"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"K", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ExtrKNn[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"A", "'"}]},
               {"B", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-$CellContext`B, $CellContext`A\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"a", " ", " "},
               {" ", "A", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, \
-$CellContext`A\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]], "+", 
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"A", "'"}]},
               {"A", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-$CellContext`A, $CellContext`A\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"a", " ", " "},
               {" ", "B", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, \
-$CellContext`A\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"B", "'"}]},
               {"D", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-D, $CellContext`B\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"b", " ", " "},
               {" ", "C", 
                RowBox[{"B", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`b, -C, -$CellContext`B\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]], "+", 
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"B", "'"}]},
               {"C", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-C, $CellContext`B\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"b", " ", " "},
               {" ", "D", 
                RowBox[{"B", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`b, -D, -$CellContext`B\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]]}], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`b][
      $CellContext`Nn[-$CellContext`a]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.5769954168217173`*^9, 3.576995630074092*^9, 3.5769956708993635`*^9, 
   3.5844315877053986`*^9, 3.584431996973118*^9, 3.6176898530080304`*^9, 
   3.6628758953797407`*^9, 3.6630604800885506`*^9, 3.6630605231611347`*^9, 
   3.6630606340658455`*^9, 3.6630607077333198`*^9, 3.690020736924571*^9, 
   3.690021110164571*^9, 3.6900261101325707`*^9, 3.690026182012571*^9, 
   3.910340380907695*^9, 3.9103443767975597`*^9, {3.959701387021799*^9, 
   3.959701405288414*^9}, 3.9597014938063126`*^9},
 CellLabel->
  "Out[149]=",ExpressionUUID->"b3e79564-8afd-974e-815a-d02d4fa57f15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{
    RowBox[{"CDe", "[", "a_", "]"}], "[", "expr_", "]"}], "\[RightTeeArrow]", 
   
   RowBox[{
    RowBox[{"\[Sigma]", "[", 
     RowBox[{"a", ",", "A", ",", "A\[Dagger]"}], "]"}], 
    RowBox[{
     RowBox[{"CDe", "[", 
      RowBox[{
       RowBox[{"-", "A"}], ",", 
       RowBox[{"-", "A\[Dagger]"}]}], "]"}], "@", "expr"}]}]}]}]], "Input",
 CellChangeTimes->{{3.576995431376543*^9, 3.5769954773030233`*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"056e44f3-a43f-4876-9552-151496d2a315"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"K", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ExtrKNn[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"B", "'"}]},
               {"B", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-$CellContext`B, $CellContext`B\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"a", " ", " "},
               {" ", "A", 
                RowBox[{"B", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, \
-$CellContext`B\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]], "+", 
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"B", "'"}]},
               {"A", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-$CellContext`A, $CellContext`B\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"a", " ", " "},
               {" ", "B", 
                RowBox[{"B", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, \
-$CellContext`B\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "F", 
            RowBox[{"A", "'"}]},
           {"b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`b, $CellContext`F, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"C", "'"}]},
               {"D", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-D, $CellContext`C\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"b", " ", " "},
               {" ", "C", 
                RowBox[{"C", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`b, -C, -$CellContext`C\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]], "+", 
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"C", "'"}]},
               {"C", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-C, $CellContext`C\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"b", " ", " "},
               {" ", "D", 
                RowBox[{"C", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`b, -D, -$CellContext`C\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]]}], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"FA", "'"}], "  "], GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" "},
             {"a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`F, -$CellContext`A\[Dagger]][
      $CellContext`Nn[-$CellContext`a]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{3.5769954777554245`*^9, 3.576995630542093*^9, 
  3.576995670930564*^9, 3.584431591028205*^9, 3.5844319970043173`*^9, 
  3.617689853768031*^9, 3.6628758953997407`*^9, 3.6630604805485783`*^9, 
  3.6630605231911364`*^9, 3.663060634085842*^9, 3.6630607077633147`*^9, 
  3.690020736964571*^9, 3.690021110204571*^9, 3.690026110162571*^9, 
  3.690026182042571*^9, 3.9103403809306297`*^9, 3.9103443768374557`*^9, 
  3.9597014071335087`*^9, 3.959701493837204*^9},
 CellLabel->
  "Out[150]=",ExpressionUUID->"4214ee0f-d24a-8043-aeac-80cbf0e6f969"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"Nn", "[", "a_", "]"}], "\[RuleDelayed]", 
   RowBox[{
    RowBox[{"SeparateSolderingForm", "[", "]"}], "@", 
    RowBox[{"Nn", "[", "a", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.576995483215434*^9, 3.576995499735863*^9}},
 CellLabel->
  "In[151]:=",ExpressionUUID->"214007c6-d38f-456b-8728-f3faa36a0dee"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"K", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ExtrKNn[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "H", 
            RowBox[{"D", "'"}]},
           {"a", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`a, $CellContext`H, $CellContext`D\
\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"B", "'"}]},
               {"B", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-$CellContext`B, $CellContext`B\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"a", " ", " "},
               {" ", "A", 
                RowBox[{"B", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`a, -$CellContext`A, \
-$CellContext`B\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]], "+", 
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"B", "'"}]},
               {"A", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-$CellContext`A, $CellContext`B\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"a", " ", " "},
               {" ", "B", 
                RowBox[{"B", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`a, -$CellContext`B, \
-$CellContext`B\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Sigma]", 
        StyleBox[GridBox[{
           {" ", "F", 
            RowBox[{"A", "'"}]},
           {"b", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Sigma][-$CellContext`b, $CellContext`F, $CellContext`A\
\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"C", "'"}]},
               {"D", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-D, $CellContext`C\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"b", " ", " "},
               {" ", "C", 
                RowBox[{"C", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`b, -C, -$CellContext`C\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]], "+", 
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", 
                RowBox[{"C", "'"}]},
               {"C", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`t[-C, $CellContext`C\[Dagger]],
        Editable->False], " ", 
       InterpretationBox[
        StyleBox[GridBox[{
           {"\[Sigma]", 
            StyleBox[GridBox[{
               {"b", " ", " "},
               {" ", "D", 
                RowBox[{"C", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Sigma][$CellContext`b, -D, -$CellContext`C\[Dagger]],
        Editable->False]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]}]]}], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", 
        RowBox[{"FA", "'"}], "  "], GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"H", 
              RowBox[{"D", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDe[-$CellContext`F, -$CellContext`A\[Dagger]][
      $CellContext`t[-$CellContext`H, -$CellContext`D\[Dagger]]],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{3.5769955003754644`*^9, 3.576995631680895*^9, 
  3.576995670961764*^9, 3.584431592276207*^9, 3.5844319970199175`*^9, 
  3.6176898550280333`*^9, 3.6628758954197407`*^9, 3.663060481068609*^9, 
  3.6630605232311387`*^9, 3.663060634115837*^9, 3.663060707803308*^9, 
  3.690020737004571*^9, 3.690021110234571*^9, 3.690026110202571*^9, 
  3.690026182252571*^9, 3.9103403810682335`*^9, 3.9103443768703413`*^9, 
  3.959701408272434*^9, 3.9597014938671513`*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"61a46402-50a2-e143-ac30-6ba5a1a84aab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.5769955038386707`*^9, 3.5769955079882774`*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"5a2ba937-2a6f-4d03-a085-1729be786a47"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"K", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ExtrKNn[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"B", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`B, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"B", "'"}]},
             {"D", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-D, $CellContext`B\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubsuperscriptBox["\[EmptyDownTriangle]", 
          RowBox[{"CB", "'"}], "  "], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"A", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[-C, -$CellContext`B\[Dagger]][
        $CellContext`t[-$CellContext`A, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}], 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False]}]], "+", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`A, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"B", "'"}]},
             {"D", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-D, $CellContext`B\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubsuperscriptBox["\[EmptyDownTriangle]", 
          RowBox[{"CB", "'"}], "  "], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"B", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[-C, -$CellContext`B\[Dagger]][
        $CellContext`t[-$CellContext`B, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}], 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False]}]], "+", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"B", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`B, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"B", "'"}]},
             {"C", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-C, $CellContext`B\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubsuperscriptBox["\[EmptyDownTriangle]", 
          RowBox[{"DB", "'"}], "  "], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"A", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[-D, -$CellContext`B\[Dagger]][
        $CellContext`t[-$CellContext`A, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}], 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False]}]], "+", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`A, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"B", "'"}]},
             {"C", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-C, $CellContext`B\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubsuperscriptBox["\[EmptyDownTriangle]", 
          RowBox[{"DB", "'"}], "  "], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"B", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDe[-D, -$CellContext`B\[Dagger]][
        $CellContext`t[-$CellContext`B, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}], 
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False]}]]}]}]], "Output",
 CellChangeTimes->{3.576995508175478*^9, 3.576995632585696*^9, 
  3.576995671039764*^9, 3.5844315930562077`*^9, 3.5844319970979176`*^9, 
  3.6176898583880377`*^9, 3.662875895479741*^9, 3.66306048123862*^9, 
  3.663060523311144*^9, 3.663060634195823*^9, 3.6630607078932924`*^9, 
  3.6900207370745707`*^9, 3.690021110414571*^9, 3.6900261102725706`*^9, 
  3.690026182332571*^9, 3.910340381113139*^9, 3.9103443769142504`*^9, 
  3.959701409186125*^9, 3.959701493912031*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"474e5b43-abed-2a4c-80ba-dd4f0001b5e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "[", 
   RowBox[{"%", "/.", "SpinCovDToSenRules"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5769956369849043`*^9, 3.576995659698544*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"5f4bf89c-6e4b-45a8-a224-ab4f4da25dcd"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"K", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", "C", "D"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ExtrKNn[-$CellContext`A, -$CellContext`B, -C, -D],
   Editable->False], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"B", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`B, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubsuperscriptBox["\[EmptyDownTriangle]", "CD", "  "], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"A", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Dd[-C, -D][
        $CellContext`t[-$CellContext`A, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}], 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox[
      InterpretationBox[
       StyleBox["c",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ccc,
       Editable->False]]}]], "+", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", 
              RowBox[{"A", "'"}]},
             {"A", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`t[-$CellContext`A, $CellContext`A\[Dagger]],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubsuperscriptBox["\[EmptyDownTriangle]", "CD", "  "], GridBox[{
           {"\[Tau]", 
            StyleBox[GridBox[{
               {" ", " "},
               {"B", 
                RowBox[{"A", "'"}]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->Rational[39, 4]]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Dd[-C, -D][
        $CellContext`t[-$CellContext`B, -$CellContext`A\[Dagger]]],
       Editable->False], ")"}]}], 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox[
      InterpretationBox[
       StyleBox["c",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ccc,
       Editable->False]]}]]}]}]], "Output",
 CellChangeTimes->{{3.5769956522261305`*^9, 3.576995671117764*^9}, 
   3.584431593758209*^9, 3.584431997175918*^9, 3.617689859328039*^9, 
   3.662875895569741*^9, 3.6630604828387156`*^9, 3.66306052342115*^9, 
   3.6630606344457808`*^9, 3.663060708033269*^9, 3.690020737174571*^9, 
   3.690021110514571*^9, 3.690026110372571*^9, 3.6900261824225707`*^9, 
   3.910340381175974*^9, 3.910344376976059*^9, 3.959701410076744*^9, 
   3.9597014939968033`*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"6986c6fe-668c-4444-87e3-ff4fe1c98913"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"t", "[", 
     RowBox[{
      RowBox[{"-", "B"}], ",", "A\[Dagger]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Dd", "[", 
       RowBox[{
        RowBox[{"-", "C"}], ",", 
        RowBox[{"-", "D"}]}], "]"}], "[", 
      RowBox[{"t", "[", 
       RowBox[{
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "A\[Dagger]"}]}], "]"}], "]"}], ")"}]}], ")"}], "/", 
  "ccc"}]], "Input",
 CellChangeTimes->{{3.5769958627173004`*^9, 3.5769958627173004`*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"06e22a79-91db-43ff-8e6e-37b199ff3c34"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {" ", 
            RowBox[{"A", "'"}]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`t[-$CellContext`B, $CellContext`A\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", "CD", "  "], GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Dd[-C, -D][
      $CellContext`t[-$CellContext`A, -$CellContext`A\[Dagger]]],
     Editable->False], ")"}]}], 
  InterpretationBox[
   StyleBox["c",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ccc,
   Editable->False]]], "Output",
 CellChangeTimes->{{3.5769958636377025`*^9, 3.5769959075673795`*^9}, {
   3.5844315944446106`*^9, 3.5844316305908737`*^9}, {3.5844319972227182`*^9, 
   3.584432019967558*^9}, 3.61768986007804*^9, 3.6628758955797405`*^9, 
   3.6630604828987193`*^9, 3.6630605234411516`*^9, 3.6630606344657774`*^9, 
   3.6630607080532656`*^9, 3.690020737194571*^9, 3.6900211105345707`*^9, 
   3.6900261103825707`*^9, 3.6900261824425707`*^9, 3.9103403811949234`*^9, 
   3.9103443770050077`*^9, 3.9597014142269*^9, 3.959701494049635*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"d3b2c51e-c6fc-7f4f-a33c-e124c33c805e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Epsilon]", "[", 
   RowBox[{"A", ",", "B"}], "]"}], "*", "%"}]], "Input",
 CellChangeTimes->{{3.576995880782132*^9, 3.5769958877709446`*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"f44a078b-ed09-44f3-8fb9-aed2d2168dec"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {" ", 
            RowBox[{"A", "'"}]},
           {"B", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`t[-$CellContext`B, $CellContext`A\[Dagger]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Epsilon]", 
        StyleBox[GridBox[{
           {"A", "B"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Epsilon][$CellContext`A, $CellContext`B],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", "CD", "  "], GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"A", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Dd[-C, -D][
      $CellContext`t[-$CellContext`A, -$CellContext`A\[Dagger]]],
     Editable->False], ")"}]}], 
  InterpretationBox[
   StyleBox["c",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ccc,
   Editable->False]]], "Output",
 CellChangeTimes->{{3.576995889564948*^9, 3.5769959080509806`*^9}, {
   3.5844315953026123`*^9, 3.5844316310120745`*^9}, {3.5844319972539177`*^9, 
   3.5844320203887587`*^9}, 3.6176898608980417`*^9, 3.662875895679741*^9, 
   3.6630604829187202`*^9, 3.663060523451152*^9, 3.6630606344957724`*^9, 
   3.663060708093259*^9, 3.690020737204571*^9, 3.690021110554571*^9, 
   3.6900261104025707`*^9, 3.690026182452571*^9, 3.9103403812128744`*^9, 
   3.910344377033931*^9, 3.959701420834198*^9, 3.959701494057642*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"7f34e707-b0c6-b444-85b9-e7ed28ec92da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", 
  RowBox[{"ContractMetric", "@", "%"}]}]], "Input",
 CellChangeTimes->{{3.5769958922169523`*^9, 3.5769958967721605`*^9}, 
   3.5844316210592575`*^9, {3.584432016239152*^9, 3.5844320178147545`*^9}, {
   3.6630606923259397`*^9, 3.66306069273587*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"0a8e54a0-9079-483f-bec7-0a911e3346cc"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Tau]", 
        StyleBox[GridBox[{
           {"B", 
            RowBox[{"A", "'"}]},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`t[$CellContext`B, $CellContext`A\[Dagger]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", "CD", "  "], GridBox[{
         {"\[Tau]", 
          StyleBox[GridBox[{
             {" ", " "},
             {"B", 
              RowBox[{"A", "'"}]}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Dd[-C, -D][
      $CellContext`t[-$CellContext`B, -$CellContext`A\[Dagger]]],
     Editable->False], ")"}]}], 
  InterpretationBox[
   StyleBox["c",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ccc,
   Editable->False]]], "Output",
 CellChangeTimes->{{3.5769958968969607`*^9, 3.576995908581381*^9}, {
   3.5844315966910143`*^9, 3.5844316314644756`*^9}, {3.584431997269518*^9, 
   3.5844320210127597`*^9}, 3.6176898616880426`*^9, 3.662875895699741*^9, 
   3.6630604829387217`*^9, 3.6630605234711533`*^9, 3.663060634515769*^9, 
   3.663060708123254*^9, 3.6900207372445707`*^9, 3.6900211105745707`*^9, 
   3.690026110412571*^9, 3.690026182472571*^9, 3.9103403812298317`*^9, 
   3.9103443770638237`*^9, 3.959701420868107*^9, 3.9597014940855675`*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"db8c5a92-72fd-f147-a64b-2baf07be72c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Dd", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}], "@", 
  RowBox[{"\[Epsilon]", "[", 
   RowBox[{
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "D"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.570360230699094*^9, 3.570360234021899*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"0d37a6a8-7594-47e2-bc57-c473d8051d69"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.5703602346459007`*^9, 3.5703610004834456`*^9, 3.5703610795287848`*^9, 
   3.570361218603029*^9, 3.5703614920247087`*^9, 3.570361571631649*^9, 
   3.5703616722362256`*^9, 3.5703618812921925`*^9, 3.5703628474184895`*^9, 
   3.570363014323183*^9, 3.5703631530230265`*^9, 3.5703632413971815`*^9, 
   3.570363302533689*^9, 3.570363364699798*^9, 3.570363559731341*^9, 
   3.570364089211871*^9, 3.5703641681636095`*^9, 3.570364369436163*^9, 
   3.570364475375949*^9, 3.5703645612229*^9, 3.5703647272383914`*^9, 
   3.570364865361034*^9, 3.570364936621959*^9, 3.570365047428954*^9, 
   3.5703654066507845`*^9, 3.570365465993289*^9, 3.570365730304553*^9, 
   3.570365794670266*^9, {3.570365858053178*^9, 3.5703658779900126`*^9}, 
   3.5703659404057226`*^9, 3.5703659917142124`*^9, 3.5703661004318037`*^9, 
   3.5703661794303417`*^9, 3.570366235762041*^9, 3.5703663008921556`*^9, 
   3.570366342107428*^9, 3.570366408844345*^9, 3.5703664402316003`*^9, 
   3.5703665760766387`*^9, 3.570366949166894*^9, 3.57036724868742*^9, 
   3.5703674044380937`*^9, 3.5703674981786585`*^9, 3.5703677637545247`*^9, 
   3.5703678112878084`*^9, 3.5703678677131076`*^9, 3.5703685606351247`*^9, 
   3.5703686424728684`*^9, 3.570368786117921*^9, 3.5703688737900743`*^9, 
   3.5703689335225797`*^9, 3.570426913605378*^9, 3.570427530539662*^9, 
   3.5704276001479845`*^9, 3.570427670176507*^9, 3.57042775705306*^9, 
   3.5704319436188135`*^9, 3.570432186074439*^9, 3.570433100502245*^9, 
   3.5704365170091624`*^9, 3.5704380429414425`*^9, 3.570438173857873*^9, 
   3.5704382625440283`*^9, 3.570438354194189*^9, 3.570438575215378*^9, 
   3.5704387592021008`*^9, 3.5704388150501986`*^9, 3.5769885516078587`*^9, 
   3.576989716525305*^9, 3.57698975925378*^9, 3.5769897994394503`*^9, 
   3.5844320381571903`*^9, 3.6176898623980436`*^9, 3.662875895699741*^9, 
   3.663060482948722*^9, 3.663060523481154*^9, 3.6630606345257673`*^9, 
   3.663060708133252*^9, 3.690020737254571*^9, 3.690021110584571*^9, 
   3.6900261104225707`*^9, 3.6900261824825706`*^9, 3.910340381246785*^9, 
   3.910344377069807*^9, 3.9597014208930416`*^9, 3.9597014941164894`*^9},
 CellLabel->
  "Out[157]=",ExpressionUUID->"c0ee2833-3384-604f-9692-2c2f171c55dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Dd", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "B"}]}], "]"}], "@", 
  RowBox[{"t", "[", 
   RowBox[{
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5703601374577293`*^9, 3.570360174616995*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"648bc087-bf32-44ba-a2fe-43fbf28f9712"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "AB", "  "], GridBox[{
      {"\[Tau]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"C", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Dd[-$CellContext`A, -$CellContext`B][
   $CellContext`t[-C, -$CellContext`A\[Dagger]]],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5703601692817855`*^9, 3.5703601767229986`*^9}, 
   3.5703610004990454`*^9, 3.5703610795443845`*^9, 3.570361218603029*^9, 
   3.570361492040309*^9, 3.570361571631649*^9, 3.5703616722518253`*^9, 
   3.5703618813077927`*^9, 3.5703628474184895`*^9, 3.570363014338783*^9, 
   3.5703631530230265`*^9, 3.5703632414127817`*^9, 3.570363302580489*^9, 
   3.5703633647153983`*^9, 3.5703635597469406`*^9, 3.570364089274271*^9, 
   3.5703641681792097`*^9, 3.570364369451763*^9, 3.570364475391549*^9, 
   3.5703645613009*^9, 3.5703647272695913`*^9, 3.5703648653766336`*^9, 
   3.570364936653159*^9, 3.570364970552019*^9, 3.570365047444554*^9, 
   3.5703654066663847`*^9, 3.570365466008889*^9, 3.570365730320153*^9, 
   3.570365794670266*^9, {3.5703658580687776`*^9, 3.5703658780680127`*^9}, 
   3.5703659404213223`*^9, 3.5703659917298126`*^9, 3.5703661004474034`*^9, 
   3.570366179445942*^9, 3.5703662357776413`*^9, 3.5703663008921556`*^9, 
   3.570366342138628*^9, 3.5703664088599453`*^9, {3.5703664402472*^9, 
   3.570366463616041*^9}, 3.570366576092239*^9, 3.5703668691699533`*^9, {
   3.570366949182494*^9, 3.57036696966533*^9}, 3.5703672487342205`*^9, 
   3.5703674080417*^9, 3.5703674981942587`*^9, 3.570367763785725*^9, 
   3.5703678113034086`*^9, 3.5703678677287073`*^9, 3.5703685606507244`*^9, 
   3.570368642488468*^9, 3.5703687861335206`*^9, 3.5703688738212748`*^9, 
   3.5703689335381794`*^9, 3.5704269136209784`*^9, 3.570427530539662*^9, 
   3.5704276001479845`*^9, 3.5704276702077074`*^9, 3.57042775708426*^9, 
   3.5704319436188135`*^9, 3.570432186121239*^9, 3.570433100517845*^9, 
   3.570436517024762*^9, 3.5704380433782434`*^9, 3.5704381738734727`*^9, 
   3.5704382625596285`*^9, 3.5704383542097893`*^9, 3.5704385755429783`*^9, 
   3.5704387592021008`*^9, 3.5704388150657988`*^9, 3.576988551623459*^9, 
   3.576989716525305*^9, 3.57698975925378*^9, 3.5769897994550505`*^9, 
   3.5844320388279915`*^9, 3.6176898631380444`*^9, 3.662875895709741*^9, 
   3.6630604829687233`*^9, 3.6630605234911547`*^9, {3.6630606345357656`*^9, 
   3.6630606626709814`*^9}, 3.6630607081532483`*^9, 3.690020737264571*^9, 
   3.690021110594571*^9, 3.6900261104325705`*^9, 3.690026182492571*^9, 
   3.910340381263711*^9, 3.910344377075819*^9, 3.959701420918972*^9, 
   3.9597014941444073`*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"cd4b9a44-764a-014c-b0c6-990c8e7796ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", "SenToSpinCovDRules"}]], "Input",
 CellChangeTimes->{{3.5703610894816017`*^9, 3.5703610996060195`*^9}, {
   3.5703649715348206`*^9, 3.570364972236822*^9}, 3.570365025074115*^9, {
   3.6630606604813538`*^9, 3.663060674708935*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"20fe2f20-1305-43ae-ade9-b3c5590835e8"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Tau]", 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"B", "'"}]},
            {"B", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`t[-$CellContext`B, $CellContext`B\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubsuperscriptBox["\[EmptyDownTriangle]", 
         RowBox[{"AB", "'"}], "  "], GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"C", 
               RowBox[{"A", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[-$CellContext`A, -$CellContext`B\[Dagger]][
       $CellContext`t[-C, -$CellContext`A\[Dagger]]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Tau]", 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"B", "'"}]},
            {"A", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`t[-$CellContext`A, $CellContext`B\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubsuperscriptBox["\[EmptyDownTriangle]", 
         RowBox[{"BB", "'"}], "  "], GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"C", 
               RowBox[{"A", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDe[-$CellContext`B, -$CellContext`B\[Dagger]][
       $CellContext`t[-C, -$CellContext`A\[Dagger]]],
      Editable->False], ")"}]}]}], 
  RowBox[{
   SqrtBox["2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False]]}]]], "Output",
 CellChangeTimes->{
  3.570361103693227*^9, 3.5703612189306293`*^9, 3.5703614923367095`*^9, 
   3.5703615716472487`*^9, 3.5703616722518253`*^9, 3.5703618813077927`*^9, 
   3.5703628474340897`*^9, 3.5703630145727835`*^9, 3.570363153272627*^9, 
   3.5703632416311817`*^9, 3.5703633028144894`*^9, 3.570363364933799*^9, 
   3.5703635599809413`*^9, 3.570364089570671*^9, 3.5703641683976097`*^9, 
   3.5703643696857634`*^9, 3.5703644756255493`*^9, 3.5703645613633003`*^9, 
   3.5703647272851915`*^9, 3.5703648653766336`*^9, 3.5703649371055603`*^9, 
   3.5703649728296227`*^9, 3.570365047460154*^9, 3.570365406681985*^9, 
   3.570365466024489*^9, 3.5703657303357534`*^9, 3.5703657946858664`*^9, {
   3.5703658580999775`*^9, 3.5703658784736137`*^9}, 3.570365940436922*^9, 
   3.5703659917454123`*^9, 3.570366100463003*^9, 3.570366179461542*^9, 
   3.5703662357932415`*^9, 3.570366300907756*^9, 3.570366342154228*^9, 
   3.5703664088755455`*^9, {3.5703664402472*^9, 3.570366464037242*^9}, 
   3.5703665761078386`*^9, 3.570366869949955*^9, {3.5703669491980944`*^9, 
   3.570366970102131*^9}, 3.5703672488122206`*^9, 3.5703674081041*^9, 
   3.5703674982098584`*^9, 3.570367763816925*^9, 3.570367811334608*^9, 
   3.5703678677443075`*^9, 3.5703685606507244`*^9, 3.5703686425352683`*^9, 
   3.5703687861491203`*^9, 3.570368874102075*^9, 3.5703689335537796`*^9, 
   3.5704269136209784`*^9, 3.570427530555262*^9, 3.5704276001635847`*^9, 
   3.570427670316908*^9, 3.57042775709986*^9, 3.5704319436344132`*^9, 
   3.570432186136839*^9, 3.5704331005334454`*^9, 3.5704365170403624`*^9, 
   3.5704380439242444`*^9, 3.5704381738734727`*^9, 3.5704382625596285`*^9, 
   3.5704383542097893`*^9, 3.5704385755585785`*^9, 3.570438759217701*^9, 
   3.570438815081399*^9, 3.576988551639059*^9, 3.576989716540905*^9, 
   3.57698975926938*^9, 3.5769897994706507`*^9, 3.5844320398575926`*^9, 
   3.617689863798045*^9, 3.662875895719741*^9, 3.663060482998725*^9, 
   3.6630605235111556`*^9, {3.6630606345557623`*^9, 3.663060663190893*^9}, 
   3.663060708173245*^9, 3.690020737294571*^9, 3.6900211106445713`*^9, 
   3.6900261104425707`*^9, 3.690026182512571*^9, 3.91034038128266*^9, 
   3.910344377103716*^9, 3.959701420947895*^9, 3.9597014941773205`*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"31545e86-61ed-ff4c-b78a-8109b03d2825"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", "SpinCovDToSenRules"}]], "Input",
 CellChangeTimes->{{3.5703663514050446`*^9, 3.5703663635730658`*^9}, {
  3.6630606765886154`*^9, 3.6630606774884624`*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"010bd2cc-b766-402e-8ad8-21c3cb920c0d"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Tau]", 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"B", "'"}]},
            {"B", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`t[-$CellContext`B, $CellContext`B\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Tau]", 
             StyleBox[GridBox[{
                {" ", " "},
                {"A", 
                 RowBox[{"B", "'"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`t[-$CellContext`A, -$CellContext`B\[Dagger]],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[EmptyDownTriangle]", "\[Tau]"], GridBox[{
              {"\[Tau]", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {"C", 
                   RowBox[{"A", "'"}]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDe[
           xAct`xTensor`Dir[
            $CellContext`Nn[$CellContext`a]]][
           $CellContext`t[-C, -$CellContext`A\[Dagger]]],
          Editable->False], ")"}]}], 
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Tau]", 
             StyleBox[GridBox[{
                {"D", " "},
                {" ", 
                 RowBox[{"B", "'"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`t[D, -$CellContext`B\[Dagger]],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubsuperscriptBox["\[EmptyDownTriangle]", "DA", "  "], GridBox[{
              {"\[Tau]", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {"C", 
                   RowBox[{"A", "'"}]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Dd[-D, -$CellContext`A][
           $CellContext`t[-C, -$CellContext`A\[Dagger]]],
          Editable->False], ")"}]}], 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]]}], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Tau]", 
         StyleBox[GridBox[{
            {" ", 
             RowBox[{"B", "'"}]},
            {"A", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`t[-$CellContext`A, $CellContext`B\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Tau]", 
             StyleBox[GridBox[{
                {" ", " "},
                {"B", 
                 RowBox[{"B", "'"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`t[-$CellContext`B, -$CellContext`B\[Dagger]],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[EmptyDownTriangle]", "\[Tau]"], GridBox[{
              {"\[Tau]", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {"C", 
                   RowBox[{"A", "'"}]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDe[
           xAct`xTensor`Dir[
            $CellContext`Nn[$CellContext`a]]][
           $CellContext`t[-C, -$CellContext`A\[Dagger]]],
          Editable->False], ")"}]}], 
       InterpretationBox[
        StyleBox["c",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ccc,
        Editable->False]], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"\[Tau]", 
             StyleBox[GridBox[{
                {"F", " "},
                {" ", 
                 RowBox[{"B", "'"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`t[$CellContext`F, -$CellContext`B\[Dagger]],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubsuperscriptBox["\[EmptyDownTriangle]", "FB", "  "], GridBox[{
              {"\[Tau]", 
               StyleBox[GridBox[{
                  {" ", " "},
                  {"C", 
                   RowBox[{"A", "'"}]}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
                FontSize->Rational[39, 4]]}
             },
             GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`Dd[-$CellContext`F, -$CellContext`B][
           $CellContext`t[-C, -$CellContext`A\[Dagger]]],
          Editable->False], ")"}]}], 
       SqrtBox[
        InterpretationBox[
         StyleBox["c",
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ccc,
         Editable->False]]]}], ")"}]}]}], 
  RowBox[{
   SqrtBox["2"], " ", 
   SqrtBox[
    InterpretationBox[
     StyleBox["c",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ccc,
     Editable->False]]}]]], "Output",
 CellChangeTimes->{
  3.5703663646650677`*^9, 3.570366408891145*^9, {3.5703664402784004`*^9, 
   3.5703664644584427`*^9}, 3.570366576139039*^9, 3.5703666382739477`*^9, 
   3.570366730984911*^9, 3.57036685575393*^9, {3.5703669492760944`*^9, 
   3.5703669704765315`*^9}, 3.5703672488902206`*^9, 3.5703674081353*^9, 
   3.5703674982410583`*^9, 3.5703677638481255`*^9, 3.5703678113502083`*^9, 
   3.570367867775508*^9, 3.570368560681925*^9, 3.5703686426132684`*^9, 
   3.5703687861647205`*^9, 3.570368874148875*^9, 3.57036893356938*^9, 
   3.5704269136365786`*^9, 3.570427530570862*^9, 3.5704276001791844`*^9, 
   3.5704276703325076`*^9, 3.57042775709986*^9, 3.5704319436500134`*^9, 
   3.5704321861680393`*^9, 3.5704331005490456`*^9, 3.5704365170559626`*^9, 
   3.570438044813446*^9, 3.570438173889073*^9, 3.5704382625908284`*^9, 
   3.5704383542253895`*^9, 3.5704385755897784`*^9, 3.570438759248901*^9, 
   3.570438815112599*^9, 3.576988551654659*^9, 3.576989716556505*^9, 
   3.57698975928498*^9, 3.576989799486251*^9, 3.5844320405751944`*^9, 
   3.6176898644880466`*^9, 3.6628758957497416`*^9, 3.6630604830287266`*^9, 
   3.663060523551158*^9, 3.6630606345857573`*^9, 3.6630607082132382`*^9, 
   3.6900207373245707`*^9, 3.690021110674571*^9, 3.690026110472571*^9, 
   3.690026182542571*^9, 3.9103403813076215`*^9, 3.910344377136628*^9, 
   3.959701422046955*^9, 3.959701494214222*^9},
 CellLabel->
  "Out[160]=",ExpressionUUID->"85408607-05b9-2443-8883-4007c56cc288"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5703664551608267`*^9, 3.570366461759638*^9}, {
  3.6900261526025705`*^9, 3.690026152972571*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"8b3bcb86-6988-4fb2-b25e-d575a9e10e20"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", "AB", "  "], GridBox[{
      {"\[Tau]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"C", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Dd[-$CellContext`A, -$CellContext`B][
   $CellContext`t[-C, -$CellContext`A\[Dagger]]],
  Editable->False]], "Output",
 CellChangeTimes->{{3.570366456783229*^9, 3.570366464988844*^9}, 
   3.570366576201439*^9, 3.5703667323421135`*^9, 3.570366856986332*^9, {
   3.570366949322894*^9, 3.570366971318933*^9}, 3.570367249061821*^9, 
   3.5703674081665*^9, 3.5703674982878585`*^9, 3.570367763879325*^9, 
   3.5703678113814087`*^9, 3.5703678678223076`*^9, 3.5703685607131248`*^9, 
   3.5703686426288686`*^9, 3.570368786195921*^9, 3.570368874180075*^9, 
   3.5703689336005793`*^9, 3.5704269136677785`*^9, 3.570427530586462*^9, 
   3.570427600194784*^9, 3.570427670394908*^9, 3.57042775711546*^9, 
   3.5704319436812134`*^9, 3.5704321862148395`*^9, 3.5704331005802455`*^9, 
   3.5704365170871625`*^9, 3.5704380481518517`*^9, 3.570438173920273*^9, 
   3.570438262606428*^9, 3.57043835425659*^9, 3.5704385756209784`*^9, 
   3.5704387592645006`*^9, 3.570438815128199*^9, 3.5769885516858587`*^9, 
   3.5769897165877047`*^9, 3.57698975931618*^9, 3.576989799517451*^9, 
   3.5844320414019957`*^9, 3.617689865128047*^9, 3.662875895769741*^9, 
   3.6630604830687294`*^9, 3.6630605235911603`*^9, 3.663060634615752*^9, 
   3.663060708243233*^9, 3.690020737384571*^9, 3.690021110704571*^9, 
   3.690026110502571*^9, 3.690026182572571*^9, 3.910340381326573*^9, 
   3.910344377161589*^9, 3.9597014230495415`*^9, 3.9597014942421207`*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"f05f1972-d4c0-5a41-abc0-45a51b8b4e30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDe", "[", 
   RowBox[{"Dir", "[", 
    RowBox[{"Nn", "[", "a", "]"}], "]"}], "]"}], "[", 
  RowBox[{"t", "[", 
   RowBox[{
    RowBox[{"-", "C"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.570366632080737*^9, 3.5703666368075457`*^9}, 
   3.570366848827518*^9, 3.5703676917905984`*^9, 3.5703679489268503`*^9},
 CellLabel->
  "In[162]:=",ExpressionUUID->"4fdcfe84-f08b-4b70-b247-6045ef082172"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[EmptyDownTriangle]", "\[Tau]"], GridBox[{
      {"\[Tau]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"C", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[
   xAct`xTensor`Dir[
    $CellContext`Nn[$CellContext`a]]][
   $CellContext`t[-C, -$CellContext`A\[Dagger]]],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5703666372599463`*^9, 3.5703666777420177`*^9}, 
   3.570366711235276*^9, 3.57036685026272*^9, {3.570366949213694*^9, 
   3.570366974672939*^9}, {3.570367249093021*^9, 3.570367274645866*^9}, 
   3.5703674081821003`*^9, {3.5703674983034587`*^9, 3.570367529175913*^9}, {
   3.5703676157092648`*^9, 3.5703676537265315`*^9}, {3.5703676919777985`*^9, 
   3.5703677106198316`*^9}, 3.570367763894925*^9, 3.570367811397009*^9, 
   3.5703678678691077`*^9, {3.570367932141221*^9, 3.570367949566451*^9}, 
   3.5703685607287245`*^9, 3.5703686426600685`*^9, 3.570368786211521*^9, 
   3.570368874195675*^9, 3.5703689336161795`*^9, 3.570426913683378*^9, 
   3.570427530602062*^9, 3.5704276002103844`*^9, 3.5704276704105077`*^9, 
   3.57042775714666*^9, 3.5704319436968136`*^9, 3.5704321862460394`*^9, 
   3.5704331005802455`*^9, 3.5704365170871625`*^9, 3.570438049462254*^9, 
   3.570438173920273*^9, 3.5704382626220284`*^9, 3.5704383542721896`*^9, 
   3.5704385756365786`*^9, 3.570438759280101*^9, 3.570438815143799*^9, 
   3.576988551701459*^9, 3.576989716603305*^9, 3.57698975933178*^9, 
   3.576989799517451*^9, 3.584432042166397*^9, 3.6176898657880483`*^9, 
   3.6628758957797413`*^9, 3.6630604830887303`*^9, 3.6630605236111617`*^9, 
   3.6630606346257505`*^9, 3.663060708253231*^9, 3.690020737404571*^9, 
   3.690021110724571*^9, 3.690026110512571*^9, 3.690026182592571*^9, 
   3.9103403813434987`*^9, 3.910344377186524*^9, 3.9597014261791706`*^9, 
   3.9597014942690754`*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"d1b5169a-7c53-8247-a30e-77f93d2f46d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", "DirToSpinCovDRules"}]], "Input",
 CellChangeTimes->{{3.570367262165844*^9, 3.57036727703267*^9}, {
  3.663060684477274*^9, 3.6630606866369066`*^9}, {3.690026150252571*^9, 
  3.690026150282571*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"de164043-2d4b-4d22-9b27-6bfdbc21739a"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Tau]", 
       StyleBox[GridBox[{
          {"A", 
           RowBox[{"B", "'"}]},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`t[$CellContext`A, $CellContext`B\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubsuperscriptBox["\[EmptyDownTriangle]", 
       RowBox[{"AB", "'"}], "  "], GridBox[{
        {"\[Tau]", 
         StyleBox[GridBox[{
            {" ", " "},
            {"C", 
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CDe[-$CellContext`A, -$CellContext`B\[Dagger]][
     $CellContext`t[-C, -$CellContext`A\[Dagger]]],
    Editable->False], ")"}]}]], "Output",
 CellChangeTimes->{{3.570367270355858*^9, 3.5703672750826664`*^9}, 
   3.5703674082289004`*^9, 3.570367498365859*^9, 3.5703677642069254`*^9, 
   3.570367811693409*^9, 3.5703678679783077`*^9, {3.5703679229684043`*^9, 
   3.5703679501436524`*^9}, 3.5703685607287245`*^9, 3.5703686426756687`*^9, 
   3.570368786227121*^9, 3.570368874648076*^9, 3.5703689336161795`*^9, 
   3.5704269136989784`*^9, 3.570427530617662*^9, 3.5704276002259846`*^9, 
   3.5704276704261074`*^9, 3.57042775714666*^9, 3.5704319436968136`*^9, 
   3.5704321862616396`*^9, 3.5704331005958457`*^9, 3.5704365171027627`*^9, 
   3.5704380502578554`*^9, 3.570438173935873*^9, 3.5704382626376286`*^9, 
   3.5704383542721896`*^9, 3.5704385756521783`*^9, 3.570438759295701*^9, 
   3.570438815159399*^9, 3.576988551717059*^9, 3.576989716618905*^9, 
   3.5769897593473797`*^9, 3.5769897995330505`*^9, 3.5844320429463987`*^9, 
   3.6176898664380493`*^9, 3.6628758957897415`*^9, 3.6630604831087313`*^9, 
   3.6630605236311626`*^9, 3.6630606346457467`*^9, 3.6630607082632294`*^9, 
   3.690020737424571*^9, 3.690021110734571*^9, 3.6900261105225706`*^9, 
   3.6900261826025705`*^9, 3.91034038136048*^9, 3.9103443772124586`*^9, 
   3.9597014262130814`*^9, 3.9597014942959766`*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"19e76599-5c7f-e144-8d4e-338898336a1f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", "SpinCovDToSenRules"}]], "Input",
 CellChangeTimes->{{3.5703663514050446`*^9, 3.5703663635730658`*^9}, {
  3.690026148542571*^9, 3.690026148592571*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"c4f0350d-1832-44e7-904a-54d385f6df79"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Tau]", 
       StyleBox[GridBox[{
          {"A", 
           RowBox[{"B", "'"}]},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`t[$CellContext`A, $CellContext`B\[Dagger]],
   Editable->False], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {" ", " "},
              {"A", 
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`t[-$CellContext`A, -$CellContext`B\[Dagger]],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\[EmptyDownTriangle]", "\[Tau]"], GridBox[{
            {"\[Tau]", 
             StyleBox[GridBox[{
                {" ", " "},
                {"C", 
                 RowBox[{"A", "'"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`CDe[
         xAct`xTensor`Dir[
          $CellContext`Nn[$CellContext`a]]][
         $CellContext`t[-C, -$CellContext`A\[Dagger]]],
        Editable->False], ")"}]}], 
     InterpretationBox[
      StyleBox["c",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`ccc,
      Editable->False]], "-", 
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[Tau]", 
           StyleBox[GridBox[{
              {"B", " "},
              {" ", 
               RowBox[{"B", "'"}]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`t[$CellContext`B, -$CellContext`B\[Dagger]],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubsuperscriptBox["\[EmptyDownTriangle]", "BA", "  "], GridBox[{
            {"\[Tau]", 
             StyleBox[GridBox[{
                {" ", " "},
                {"C", 
                 RowBox[{"A", "'"}]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`Dd[-$CellContext`B, -$CellContext`A][
         $CellContext`t[-C, -$CellContext`A\[Dagger]]],
        Editable->False], ")"}]}], 
     SqrtBox[
      InterpretationBox[
       StyleBox["c",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ccc,
       Editable->False]]]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.5703663646650677`*^9, 3.570366408891145*^9, {3.5703664402784004`*^9, 
   3.5703664644584427`*^9}, 3.570366576139039*^9, 3.5703666382739477`*^9, 
   3.570366730984911*^9, 3.57036685575393*^9, {3.5703669492760944`*^9, 
   3.570366977512144*^9}, 3.5703672492490215`*^9, 3.5703674084941006`*^9, 
   3.5703674986934595`*^9, 3.570367764846527*^9, 3.5703678120990095`*^9, 
   3.5703678683215084`*^9, {3.570367942562039*^9, 3.5703679507520533`*^9}, 
   3.5703685607443247`*^9, 3.570368642691269*^9, 3.5703687862427206`*^9, 
   3.570368874679276*^9, 3.5703689336317797`*^9, 3.5704269136989784`*^9, 
   3.5704275306332617`*^9, 3.5704276002415843`*^9, 3.5704276704417076`*^9, 
   3.57042775716226*^9, 3.570431943712414*^9, 3.57043218627724*^9, 
   3.5704331006114454`*^9, 3.570436517118363*^9, 3.570438051396658*^9, 
   3.5704381739514728`*^9, 3.5704382626376286`*^9, 3.5704383542877893`*^9, 
   3.5704385756677785`*^9, 3.5704387593113008`*^9, 3.5704388151905994`*^9, 
   3.5769885517326593`*^9, 3.5769897166345053`*^9, 3.57698975936298*^9, 
   3.5769897995486507`*^9, 3.5844320470804057`*^9, 3.61768986704805*^9, 
   3.662875895809741*^9, 3.6630604831287327`*^9, 3.6630605236911664`*^9, 
   3.6630606346557455`*^9, 3.6630607082832265`*^9, 3.690020737444571*^9, 
   3.690021110754571*^9, 3.690026110542571*^9, 3.690026182622571*^9, 
   3.9103403813804317`*^9, 3.9103443772403517`*^9, 3.9597014262400074`*^9, 
   3.959701494327915*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"f6591e04-42ff-6c46-9dd0-103e7e1772c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "@", "%"}]], "Input",
 CellChangeTimes->{{3.5703664551608267`*^9, 3.570366461759638*^9}, {
  3.6900261458525705`*^9, 3.6900261461425705`*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"87797569-1074-4f2a-a337-885dbc18260f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[EmptyDownTriangle]", "\[Tau]"], GridBox[{
      {"\[Tau]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"C", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[
   xAct`xTensor`Dir[
    $CellContext`Nn[$CellContext`a]]][
   $CellContext`t[-C, -$CellContext`A\[Dagger]]],
  Editable->False]], "Output",
 CellChangeTimes->{{3.570366456783229*^9, 3.570366464988844*^9}, 
   3.570366576201439*^9, 3.5703667323421135`*^9, 3.570366856986332*^9, {
   3.570366949322894*^9, 3.5703669786197457`*^9}, 3.570367249280221*^9, 
   3.570367408603301*^9, 3.5703674988026595`*^9, 3.570367764986927*^9, 
   3.57036781222381*^9, 3.570367868446309*^9, {3.5703679436852407`*^9, 
   3.5703679519532557`*^9}, 3.570368560775525*^9, 3.570368642722469*^9, 
   3.570368786273921*^9, 3.5703688747572765`*^9, 3.5703689336629796`*^9, 
   3.5704269137145786`*^9, 3.570427530648862*^9, 3.5704276002571845`*^9, 
   3.570427670472908*^9, 3.57042775719346*^9, 3.5704319437436132`*^9, 
   3.5704321863084393`*^9, 3.5704331006270456`*^9, 3.5704365171339626`*^9, 
   3.5704380533154607`*^9, 3.5704381739670725`*^9, 3.5704382626688285`*^9, 
   3.5704383543033895`*^9, 3.5704385756989784`*^9, 3.5704387593425007`*^9, 
   3.570438815206199*^9, 3.576988551748259*^9, 3.5769897166501055`*^9, 
   3.57698975937858*^9, 3.576989799564251*^9, 3.5844320471428056`*^9, 
   3.617689867718051*^9, 3.6628758958197412`*^9, 3.663060483158735*^9, 
   3.663060523801173*^9, 3.6630606346757417`*^9, 3.6630607083032227`*^9, 
   3.690020737464571*^9, 3.690021110774571*^9, 3.690026110552571*^9, 
   3.6900261826425705`*^9, 3.9103403813983517`*^9, 3.9103443772662816`*^9, 
   3.9597014262659397`*^9, 3.959701494354849*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"9b9a712f-93ed-7f4d-9567-672927b40e74"]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowToolbars->"EditBar",
WindowSize->{949, 639},
WindowMargins->{{Automatic, 173.5}, {167.5, Automatic}},
ShowSelection->True,
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]]}, Visible -> False, 
  FrontEndVersion -> "14.1 for Microsoft Windows (64-bit) (July 16, 2024)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"f5f7d67e-2b96-412e-aa1b-252bb1b80287"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 429, 8, 96, "Title",ExpressionUUID->"f49154df-a83d-4bc1-aa0b-5f799a9f770e"],
Cell[999, 32, 383, 6, 52, "Subtitle",ExpressionUUID->"5f2aa1a3-036f-407d-a174-534951cfe91a"],
Cell[1385, 40, 906, 16, 201, "Subsubtitle",ExpressionUUID->"2d566e78-a858-4a54-9b96-7f8ef5b3d711"],
Cell[2294, 58, 825, 16, 99, "Text",ExpressionUUID->"6473c268-e2e1-4325-95fa-062a84411f18"],
Cell[CellGroupData[{
Cell[3144, 78, 200, 3, 28, "Input",ExpressionUUID->"ed1ae1a2-5ed5-4064-9cca-f1ecd7602ff0"],
Cell[3347, 83, 11105, 155, 32, "Output",ExpressionUUID->"7dc82672-3cc3-2040-b4db-29ec99d3c25d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14489, 243, 2856, 42, 44, "Input",ExpressionUUID->"0edccc3c-94ea-4439-8974-e9b46fcb2712",
 InitializationCell->True],
Cell[17348, 287, 10970, 153, 32, "Output",ExpressionUUID->"03a10ec3-8cae-0c45-967e-7f241d415e39"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28355, 445, 256, 7, 53, "Subsection",ExpressionUUID->"4e20abc8-318f-43fd-b033-972527f51d6b"],
Cell[28614, 454, 94, 0, 43, "Subsubsection",ExpressionUUID->"5a03847b-4624-4ebb-b440-c33f5c273685"],
Cell[CellGroupData[{
Cell[28733, 458, 88, 0, 35, "Subsubsection",ExpressionUUID->"51944893-e166-41d2-8b3f-5c16f96d9cef"],
Cell[28824, 460, 3351, 70, 367, "Input",ExpressionUUID->"036ec658-714f-4b68-91b2-2a6f99229f8a",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[32212, 535, 97, 0, 35, "Subsubsection",ExpressionUUID->"17e0739e-f29e-4f30-a935-773fc524be2a"],
Cell[32312, 537, 1536, 45, 530, "Input",ExpressionUUID->"7bd45ce1-3ff4-4bd9-a30e-74fd8910ce60",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[33885, 587, 97, 0, 35, "Subsubsection",ExpressionUUID->"e768ec32-e706-485e-9e49-8783ddbbff06"],
Cell[33985, 589, 648, 14, 62, "Input",ExpressionUUID->"e1a06c66-48f4-42b8-83b9-4090cd93ab6b",
 InitializationCell->True],
Cell[34636, 605, 799, 30, 33, "Text",ExpressionUUID->"71776b15-73c9-4381-bc7e-32fc2d274dcf"],
Cell[CellGroupData[{
Cell[35460, 639, 851, 15, 82, "Input",ExpressionUUID->"7c8902e5-15c0-46e8-ae20-cc7a7c2566a2",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[36336, 658, 2833, 41, 70, "Print",ExpressionUUID->"c601d585-9e27-5144-87b1-e170563e89f4"],
Cell[39172, 701, 3105, 49, 70, "Print",ExpressionUUID->"0c8a3c0d-811d-f64f-93ed-7dd3a672ebdd"],
Cell[42280, 752, 2852, 41, 70, "Print",ExpressionUUID->"70008e09-796d-db4d-9ebc-db1f4ea1c66e"],
Cell[45135, 795, 2811, 40, 70, "Print",ExpressionUUID->"b29afd35-74a2-744c-b16f-3b457f47d3a2"],
Cell[47949, 837, 2794, 40, 70, "Print",ExpressionUUID->"208dea5e-32c3-0b44-bfa6-be16ee0afad2"],
Cell[50746, 879, 2831, 41, 70, "Print",ExpressionUUID->"4880d4d9-62d7-e14e-99ab-907c0cd9dbd4"],
Cell[53580, 922, 3111, 49, 70, "Print",ExpressionUUID->"b464d1d0-2097-4b4a-8ff2-0c558555250e"],
Cell[56694, 973, 2852, 41, 70, "Print",ExpressionUUID->"a8fbfe11-36b8-0947-a6d8-9de2eb5d499b"],
Cell[59549, 1016, 2833, 41, 70, "Print",ExpressionUUID->"e50c4fdb-d9ba-bc47-ac67-d48f1721a4a9"],
Cell[62385, 1059, 3123, 49, 70, "Print",ExpressionUUID->"e61dd66e-ee80-2c4f-a849-f9b28d683762"],
Cell[65511, 1110, 2858, 41, 70, "Print",ExpressionUUID->"3004751b-6a85-d242-874b-ff4793fb0e50"],
Cell[68372, 1153, 2833, 41, 70, "Print",ExpressionUUID->"480bc76d-f1bd-bf47-9f75-8fe39398ff9e"],
Cell[71208, 1196, 3104, 48, 70, "Print",ExpressionUUID->"c99333ac-09f9-0541-a15a-bf09fcf654f3"],
Cell[74315, 1246, 2903, 42, 70, "Print",ExpressionUUID->"dd2b1dc5-c89c-ce4a-9c39-960895e70d30"],
Cell[77221, 1290, 2831, 41, 70, "Print",ExpressionUUID->"86ae22a3-ee46-a246-8b87-7ee44bb848c3"],
Cell[80055, 1333, 3105, 49, 70, "Print",ExpressionUUID->"120dae2d-9b8e-bb4b-95b5-4f17249252c1"],
Cell[83163, 1384, 2872, 41, 70, "Print",ExpressionUUID->"de4cb892-8cc7-e449-a250-9841d9f428bb"],
Cell[86038, 1427, 2833, 41, 70, "Print",ExpressionUUID->"ea406618-5352-e442-9159-2c8368c2ccf3"],
Cell[88874, 1470, 3109, 49, 70, "Print",ExpressionUUID->"7b211808-6894-e248-97fa-f734beb2253f"],
Cell[91986, 1521, 2890, 41, 70, "Print",ExpressionUUID->"67f17470-014a-da41-941c-e361c1438155"],
Cell[94879, 1564, 2833, 41, 70, "Print",ExpressionUUID->"0e740901-78b4-0e43-a826-e7d30934e0bd"],
Cell[97715, 1607, 3113, 49, 70, "Print",ExpressionUUID->"c713811d-47f1-4142-b0d0-e5cb03fb7f02"],
Cell[100831, 1658, 2882, 41, 70, "Print",ExpressionUUID->"49f19cad-6198-0641-916d-f08f83c5f1ca"],
Cell[103716, 1701, 2833, 41, 70, "Print",ExpressionUUID->"1fd55fd8-ac03-f44d-8163-9f5ccdab45cc"],
Cell[106552, 1744, 3109, 49, 70, "Print",ExpressionUUID->"42ed5698-f685-db45-a402-7104d78f8008"],
Cell[109664, 1795, 2877, 41, 70, "Print",ExpressionUUID->"a65a0b56-cf4b-634a-9b0c-16a8164f8eb0"]
}, Open  ]],
Cell[112556, 1839, 324, 4, 70, "Output",ExpressionUUID->"f37eb745-af0d-054b-aa01-07eadf020dc8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112917, 1848, 973, 21, 82, "Input",ExpressionUUID->"38f27d83-3490-4d52-a6b5-36911e0f00ed",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[113915, 1873, 10758, 150, 70, "Print",ExpressionUUID->"f9587f96-09db-4a4f-85c0-88e8fafc239d"],
Cell[124676, 2025, 11044, 158, 70, "Print",ExpressionUUID->"13fa6750-80f4-204e-832d-27e3b9453ef8"],
Cell[135723, 2185, 10785, 150, 70, "Print",ExpressionUUID->"14bf5eb0-88f2-1c4c-aef8-93119c7d1edc"]
}, Open  ]]
}, Open  ]],
Cell[146535, 2339, 243, 4, 55, "Text",ExpressionUUID->"6963ddda-72a4-477d-97c1-74a931423182"],
Cell[146781, 2345, 1839, 30, 405, "Input",ExpressionUUID->"ed509164-2321-4173-a14e-dfd9b09e6584",
 InitializationCell->True],
Cell[148623, 2377, 320, 7, 33, "Text",ExpressionUUID->"80c5263f-d5e1-4b23-a1a7-264eab01c1ac"],
Cell[CellGroupData[{
Cell[148968, 2388, 1087, 23, 177, "Input",ExpressionUUID->"03b801ad-6fd8-4f34-95b7-dc49a97917fe",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[150080, 2415, 10769, 150, 70, "Print",ExpressionUUID->"ba85bdd7-72b3-1c47-ab1f-88c514ff6468"],
Cell[160852, 2567, 10926, 152, 70, "Print",ExpressionUUID->"9ee4ca23-3b2e-9443-80f8-59251e5e41c2"],
Cell[171781, 2721, 10771, 150, 70, "Print",ExpressionUUID->"feb455ef-98d5-d74e-b732-644ff9114513"]
}, Open  ]]
}, Open  ]],
Cell[182579, 2875, 196, 5, 33, "Text",ExpressionUUID->"7ceb0cb8-abe3-4640-83bb-1ba04022ad10"],
Cell[CellGroupData[{
Cell[182800, 2884, 117, 1, 28, "Input",ExpressionUUID->"accc4ed9-6ec1-4902-92b9-fc04001b28a1"],
Cell[182920, 2887, 603, 10, 70, "Output",ExpressionUUID->"544e1efb-441c-6843-87b0-091a566ecae3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183560, 2902, 113, 1, 28, "Input",ExpressionUUID->"74bd840d-c578-4306-b1c5-d1456cd17170"],
Cell[183676, 2905, 320, 4, 70, "Output",ExpressionUUID->"981d1a5a-eac2-d747-8323-dd93623e07f5"]
}, Open  ]],
Cell[184011, 2912, 188, 3, 33, "Text",ExpressionUUID->"e57e3d72-38cf-4d61-a22c-28dde243b59b"],
Cell[CellGroupData[{
Cell[184224, 2919, 180, 2, 28, "Input",ExpressionUUID->"c3e1f441-5b9e-4cbb-9ab4-e289b5553aef"],
Cell[184407, 2923, 10651, 146, 70, "Output",ExpressionUUID->"863d4b58-dfae-fc4c-8d70-97cd25035b66"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[195107, 3075, 176, 3, 35, "Subsubsection",ExpressionUUID->"6e7041e5-a29b-4a7a-80a7-5a7ee98160f8"],
Cell[195286, 3080, 146, 3, 100, "Text",ExpressionUUID->"156062d8-61f5-4f7c-a3c6-4ae8c26df340"],
Cell[195435, 3085, 179, 4, 100, "Text",ExpressionUUID->"be099e94-b38f-49fc-b574-58bebbddfd2f",
 InitializationCell->True],
Cell[195617, 3091, 269, 6, 100, "Text",ExpressionUUID->"444559e7-424f-4ac5-b07e-69a4c61ad7a4"],
Cell[195889, 3099, 139, 2, 100, "Input",ExpressionUUID->"a167a13f-4a74-40ba-b458-9cc176456294"],
Cell[CellGroupData[{
Cell[196053, 3105, 263, 4, 100, "Input",ExpressionUUID->"0f7d6149-14cb-4b4e-bacb-12257ef6b1ed"],
Cell[196319, 3111, 10667, 146, 70, "Output",ExpressionUUID->"4bfc65c9-4e7f-d541-93cf-cd95b27f57e9"]
}, Open  ]],
Cell[207001, 3260, 219, 5, 100, "Text",ExpressionUUID->"d3a937eb-5fe6-403b-805d-6d7228daca9b"],
Cell[CellGroupData[{
Cell[207245, 3269, 152, 2, 100, "Input",ExpressionUUID->"83b7e2c5-c210-47c0-9cbe-55c26961b845"],
Cell[207400, 3273, 488, 11, 70, "Message",ExpressionUUID->"5a63d6ac-e92b-874c-8867-125c9e8f329b"],
Cell[207891, 3286, 628, 13, 70, "Message",ExpressionUUID->"10ec5d94-60be-134c-9c85-9708c3b9623b"],
Cell[208522, 3301, 568, 12, 70, "Message",ExpressionUUID->"af091c70-6a4b-a940-8ad7-237a8f84e870"],
Cell[209093, 3315, 412, 10, 70, "Message",ExpressionUUID->"ef755c87-1705-534e-9628-aff0bcaac378"],
Cell[209508, 3327, 407, 10, 70, "Message",ExpressionUUID->"22e92847-a444-b04e-9982-8b73b1760948"],
Cell[209918, 3339, 726, 15, 70, "Message",ExpressionUUID->"469b8580-9b75-024d-98b3-25391eccd07f"],
Cell[210647, 3356, 504, 11, 70, "Message",ExpressionUUID->"68e519fe-1dfa-6444-9f3f-aedbb654bf8b"],
Cell[211154, 3369, 230, 5, 70, "Print",ExpressionUUID->"51703a79-7023-114a-b4b7-2f74f0c40724"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[211433, 3380, 129, 2, 35, "Subsubsection",ExpressionUUID->"ef8b2407-159d-46a1-a639-ed6155bb123f",
 InitializationCell->True],
Cell[211565, 3384, 5671, 117, 710, "Input",ExpressionUUID->"a4a91fc5-a401-41ee-b504-8cfdde8883f2",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[217273, 3506, 98, 0, 35, "Subsubsection",ExpressionUUID->"476bfd7d-7652-4561-a895-07ee8e888d65"],
Cell[CellGroupData[{
Cell[217396, 3510, 180, 3, 44, "Input",ExpressionUUID->"ddc8959c-bfe1-4a0e-9728-7f8691b1d836",
 InitializationCell->True],
Cell[217579, 3515, 322, 4, 70, "Output",ExpressionUUID->"ca9ef85f-899b-6e40-9167-1c2875845495"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217938, 3524, 209, 2, 28, "Input",ExpressionUUID->"14e5d1ad-d97d-4116-9f57-45376c8173f7"],
Cell[218150, 3528, 326, 4, 70, "Output",ExpressionUUID->"95fe4167-b675-4a4e-afa2-423ce5391d3a"]
}, Open  ]],
Cell[218491, 3535, 470, 7, 33, "Text",ExpressionUUID->"f495dc70-aad7-44cb-872b-622007dc6552"],
Cell[CellGroupData[{
Cell[218986, 3546, 303, 4, 28, "Input",ExpressionUUID->"4c8ed378-da43-45fa-a8b2-f463a6ebf17e"],
Cell[219292, 3552, 11309, 158, 70, "Output",ExpressionUUID->"e880ed30-923e-ff47-ac2b-ccce97cf094a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[230638, 3715, 134, 2, 28, "Input",ExpressionUUID->"ddd04ef9-fe24-409f-923b-2f961b5cb604"],
Cell[230775, 3719, 10653, 146, 70, "Output",ExpressionUUID->"38c92f7c-5c31-c14b-8d53-61ceae378422"]
}, Open  ]],
Cell[CellGroupData[{
Cell[241465, 3870, 144, 2, 44, "Input",ExpressionUUID->"50fb47c1-4d4b-4d80-86ee-19fabf8543c8",
 InitializationCell->True],
Cell[241612, 3874, 690, 11, 70, "Output",ExpressionUUID->"40e8f403-98a4-5044-bb1c-3b854af4a8cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[242339, 3890, 538, 9, 47, "Input",ExpressionUUID->"3dea724f-e060-42d8-83da-ce3996042e39"],
Cell[242880, 3901, 660, 11, 70, "Output",ExpressionUUID->"225ccf90-47f1-6d4f-9f49-38b0e0c4f6ad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243577, 3917, 113, 1, 28, "Input",ExpressionUUID->"0fd981bf-a288-4f1a-8235-97a4d77ca3e6"],
Cell[243693, 3920, 324, 4, 70, "Output",ExpressionUUID->"933a09b6-afc5-3341-b5fc-531599fea960"]
}, Open  ]],
Cell[CellGroupData[{
Cell[244054, 3929, 205, 2, 28, "Input",ExpressionUUID->"3b1f9659-9a02-4847-b32d-d18e174476a8"],
Cell[244262, 3933, 325, 4, 70, "Output",ExpressionUUID->"c2a8dba9-9d05-4544-9eed-80a36528f5f7"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[244648, 3944, 335, 5, 53, "Subsection",ExpressionUUID->"64e78e7b-0ff7-46a9-b500-6b1c5b9f54a7"],
Cell[CellGroupData[{
Cell[245008, 3953, 208, 4, 43, "Subsubsection",ExpressionUUID->"187de461-ac77-4df8-8902-ecb779ff40ee",
 InitializationCell->True],
Cell[245219, 3959, 173, 3, 33, "Text",ExpressionUUID->"bb1b6867-dad0-43b4-93a0-af18a5b6b36e"],
Cell[245395, 3964, 610, 15, 44, "Input",ExpressionUUID->"0add4b4f-4ec0-4b11-b467-1d99629463fe",
 InitializationCell->True],
Cell[246008, 3981, 12393, 280, 1300, "Input",ExpressionUUID->"1bbbd1f1-72d7-4323-b40e-48a1502af355",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[258450, 4267, 348, 5, 53, "Subsection",ExpressionUUID->"4a8fdd46-59dc-4b2e-ab2e-6683dae74efa"],
Cell[CellGroupData[{
Cell[258823, 4276, 244, 5, 43, "Subsubsection",ExpressionUUID->"6b6f1aa1-90af-4c0d-b473-afc2fc9510f4",
 InitializationCell->True],
Cell[259070, 4283, 1066, 24, 139, "Input",ExpressionUUID->"e3f38bf9-e139-4221-92f2-40dee50af90a",
 InitializationCell->True],
Cell[260139, 4309, 282, 6, 44, "Input",ExpressionUUID->"44efa703-f8d0-984e-8f46-3d68e3a6cfec",
 InitializationCell->True],
Cell[260424, 4317, 1981, 38, 82, "Input",ExpressionUUID->"b402dbcc-782a-4e00-b580-9206b8aaae92",
 InitializationCell->True],
Cell[262408, 4357, 1352, 30, 82, "Input",ExpressionUUID->"e5d923ff-bbf0-4050-be2f-599545d01409",
 InitializationCell->True],
Cell[263763, 4389, 49265, 1090, 2566, "Input",ExpressionUUID->"a9186706-8c35-437d-b160-0236c62c35e6",
 InitializationCell->True],
Cell[313031, 5481, 29498, 665, 1471, "Input",ExpressionUUID->"f0342ec5-bc28-421a-bd81-2ac232563182",
 InitializationCell->True],
Cell[342532, 6148, 6457, 160, 576, "Input",ExpressionUUID->"8121bac4-8361-4f35-9c62-0d46dde3bc46",
 InitializationCell->True],
Cell[348992, 6310, 3674, 91, 318, "Input",ExpressionUUID->"72e2b433-1fc9-4426-8b69-7707d35b456a",
 InitializationCell->True],
Cell[352669, 6403, 3013, 81, 177, "Input",ExpressionUUID->"3190ae08-02e1-4d5c-b4b5-570a183a141e",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[355731, 6490, 396, 6, 53, "Subsection",ExpressionUUID->"66b7061b-ab77-4167-b986-4926b60e844f"],
Cell[356130, 6498, 289, 5, 43, "Subsubsection",ExpressionUUID->"5439dd50-c9f1-453c-a865-57f981599104",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[356456, 6508, 471, 7, 53, "Subsection",ExpressionUUID->"e9848701-0963-4e7e-a673-8a6acde35f45",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[356952, 6519, 437, 8, 43, "Subsubsection",ExpressionUUID->"79b7240c-c425-45df-91f6-63a622fd6214",
 InitializationCell->True],
Cell[357392, 6529, 1628, 39, 101, "Input",ExpressionUUID->"e3b9c935-0461-4f04-88f0-cbfa0a42a550",
 InitializationCell->True],
Cell[359023, 6570, 746, 19, 63, "Input",ExpressionUUID->"a8928bd8-175a-49d1-b9a7-e2537af81715",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[359806, 6594, 564, 9, 35, "Subsubsection",ExpressionUUID->"5b7522e7-2dd5-446d-b841-0c61a19fd2fb",
 InitializationCell->True],
Cell[360373, 6605, 399, 9, 44, "Input",ExpressionUUID->"3137d577-445f-4e76-9f3d-8213faf0ce33",
 InitializationCell->True],
Cell[360775, 6616, 430, 8, 44, "Input",ExpressionUUID->"e06b6fd8-cb43-40ba-8671-d4101e63a999",
 InitializationCell->True],
Cell[361208, 6626, 490, 11, 44, "Input",ExpressionUUID->"44ba52ae-758e-4140-b081-70355dd28a91",
 InitializationCell->True],
Cell[361701, 6639, 1749, 44, 139, "Input",ExpressionUUID->"ec129206-7f6b-6547-8e18-62a8879eac6b",
 InitializationCell->True],
Cell[363453, 6685, 853, 20, 82, "Input",ExpressionUUID->"6d927011-d2df-974c-a85c-ad0b217a838b",
 InitializationCell->True],
Cell[364309, 6707, 443, 9, 33, "Text",ExpressionUUID->"6a5ca2ab-50e7-4899-8890-d316034198ed",
 InitializationCell->True],
Cell[364755, 6718, 224528, 4888, 10642, "Input",ExpressionUUID->"7d48bbd3-0d1b-46ec-b47c-83ff250e943e",
 InitializationCell->True],
Cell[589286, 11608, 5034, 96, 519, "Input",ExpressionUUID->"e6cb054c-8f65-40ff-8ca1-f0c6b55d44f6",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[594357, 11709, 686, 11, 35, "Subsubsection",ExpressionUUID->"821f239f-e5a6-488b-84f6-9156d5a339dd",
 InitializationCell->True],
Cell[595046, 11722, 402, 8, 33, "Text",ExpressionUUID->"9922c4f6-242b-4767-bc1e-993fe0a91556",
 InitializationCell->True],
Cell[595451, 11732, 8841, 202, 576, "Input",ExpressionUUID->"6b1d5707-68ca-4cc7-aa8e-ec7508346aa1",
 InitializationCell->True],
Cell[604295, 11936, 231, 4, 33, "Text",ExpressionUUID->"c2d2a842-9323-4e92-949a-bbc3e6d83e32",
 InitializationCell->True],
Cell[604529, 11942, 1977, 49, 139, "Input",ExpressionUUID->"aacf17fd-6557-4ade-8c7c-254a7e189e16",
 InitializationCell->True],
Cell[606509, 11993, 195, 4, 33, "Text",ExpressionUUID->"5ee48b2b-67d2-4d11-bfac-962b43b8947d",
 InitializationCell->True],
Cell[606707, 11999, 3456, 83, 215, "Input",ExpressionUUID->"c2cc750e-7297-44d6-a850-ca26dacdaebb",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[610200, 12087, 695, 11, 35, "Subsubsection",ExpressionUUID->"d2df8d3d-efeb-4f4e-a2f7-33fae2211ad3",
 InitializationCell->True],
Cell[610898, 12100, 2748, 74, 158, "Input",ExpressionUUID->"f29bdb4c-5b52-3748-8efd-8b9f63972beb",
 InitializationCell->True],
Cell[613649, 12176, 3036, 75, 234, "Input",ExpressionUUID->"04ee2797-1fe9-9144-9671-8688068a4852",
 InitializationCell->True],
Cell[616688, 12253, 22236, 550, 805, "Input",ExpressionUUID->"4307d7e6-cded-574a-b6af-e99097f6504e",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[638973, 12809, 276, 4, 53, "Subsection",ExpressionUUID->"f88cfed4-1778-4799-b9df-9e78aa8beb5a"],
Cell[639252, 12815, 258, 7, 63, "Input",ExpressionUUID->"8e64f184-960e-41c1-84da-a4cd8ec03a83",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[639547, 12827, 261, 4, 53, "Subsection",ExpressionUUID->"ab924ac9-7e77-441f-a3ca-df4c8046f515"],
Cell[639811, 12833, 98, 0, 33, "Text",ExpressionUUID->"e7456fdd-e881-46ed-a381-a6b1f5fe8e08"],
Cell[CellGroupData[{
Cell[639934, 12837, 303, 6, 28, "Input",ExpressionUUID->"6e20b6ef-391d-46a6-9c64-e43434a2815c"],
Cell[640240, 12845, 297, 7, 32, "Output",ExpressionUUID->"bba5cb8e-73fd-844d-bc99-2e68168133c4"]
}, Open  ]],
Cell[640552, 12855, 161, 3, 33, "Text",ExpressionUUID->"393d3c18-af0b-48d3-9d6e-d756d8091dbe"],
Cell[640716, 12860, 204, 5, 28, "Input",ExpressionUUID->"a180e70a-0dc3-4e44-bdb0-fd0185b1296a"],
Cell[640923, 12867, 306, 7, 28, "Input",ExpressionUUID->"684fe5b0-337e-4fb5-84c6-b4d597d55ce3"],
Cell[641232, 12876, 527, 11, 28, "Input",ExpressionUUID->"3a145ba2-458e-4ec7-8945-801a89cdf3c1"],
Cell[CellGroupData[{
Cell[641784, 12891, 599, 16, 28, "Input",ExpressionUUID->"dd08d7bd-e931-4310-ad84-0b2ed05288ed"],
Cell[642386, 12909, 3622, 52, 22, "Print",ExpressionUUID->"e672fda2-33f3-1e40-baa2-7640d2c39681"]
}, Open  ]],
Cell[646023, 12964, 362, 8, 28, "Input",ExpressionUUID->"bd62f093-4f3e-4fee-a5b7-000e480ac4bd"],
Cell[646388, 12974, 190, 4, 28, "Input",ExpressionUUID->"f6db5701-4367-4310-8df7-dd9ff91d102a"],
Cell[646581, 12980, 392, 8, 28, "Input",ExpressionUUID->"a41aec68-ed86-47e4-a490-9e13762f8c3a"],
Cell[CellGroupData[{
Cell[646998, 12992, 593, 13, 28, "Input",ExpressionUUID->"c778d003-9de9-42c5-b584-771d25b3e6fd"],
Cell[647594, 13007, 3418, 48, 22, "Print",ExpressionUUID->"96c99a5d-ef69-b64f-86a5-b82994fdf217"]
}, Open  ]],
Cell[651027, 13058, 436, 12, 28, "Input",ExpressionUUID->"cf632184-f9f1-4d78-a4e2-77f388fcb44c"],
Cell[651466, 13072, 324, 7, 28, "Input",ExpressionUUID->"a7f268da-69df-4585-813a-ba748cdc514b"],
Cell[651793, 13081, 290, 6, 28, "Input",ExpressionUUID->"89b372d5-181a-45ec-a161-43dcb1ad7840"],
Cell[652086, 13089, 687, 18, 28, "Input",ExpressionUUID->"51ff3ca3-d57c-4390-9943-5f02837b734d"],
Cell[652776, 13109, 181, 4, 28, "Input",ExpressionUUID->"e3fbd2ec-cedb-4eb8-8e2a-ecda77f80e90"],
Cell[CellGroupData[{
Cell[652982, 13117, 576, 16, 28, "Input",ExpressionUUID->"5f3e4e9a-bb43-410a-ba09-842876c0ae1a"],
Cell[653561, 13135, 3219, 46, 22, "Print",ExpressionUUID->"b2d649f6-3852-a048-aeb8-f5403baf8c7d"]
}, Open  ]],
Cell[656795, 13184, 631, 11, 28, "Input",ExpressionUUID->"95071c09-855e-411b-a4b0-ac3cdaa082e4"],
Cell[CellGroupData[{
Cell[657451, 13199, 119, 2, 28, "Input",ExpressionUUID->"81c87314-e735-4a7e-a82e-325551a0d1b9"],
Cell[657573, 13203, 4112, 117, 34, "Output",ExpressionUUID->"78e37425-a89f-8545-b294-07109c9f7470"]
}, Open  ]],
Cell[CellGroupData[{
Cell[661722, 13325, 273, 5, 28, "Input",ExpressionUUID->"f63a09ae-79f3-430f-b607-fa2d050355b6"],
Cell[661998, 13332, 6215, 174, 58, "Output",ExpressionUUID->"bb7cf8b0-ec07-1140-9939-ea94ceb8749a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[668250, 13511, 356, 7, 28, "Input",ExpressionUUID->"49884639-f520-409d-9f06-fdd97c4b7065"],
Cell[668609, 13520, 14030, 387, 94, "Output",ExpressionUUID->"ed0c0ac7-0707-0942-9023-ffe5555417c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[682676, 13912, 246, 5, 28, "Input",ExpressionUUID->"9aafb9cc-ba74-4aca-ad28-e4680434c747"],
Cell[682925, 13919, 603, 9, 32, "Output",ExpressionUUID->"74f1a7c6-8482-c144-ba64-d9b30f47d7da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[683565, 13933, 629, 18, 28, "Input",ExpressionUUID->"f9d1aed7-1c2d-4b0f-8eb1-f898e1fa5945"],
Cell[684197, 13953, 5968, 171, 45, "Output",ExpressionUUID->"3f9d3419-5616-a941-92e5-b5976f4a38fb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[690202, 14129, 218, 4, 28, "Input",ExpressionUUID->"30538703-91ba-42a1-85cb-673633263209"],
Cell[690423, 14135, 5755, 167, 56, "Output",ExpressionUUID->"e9d564a1-fadb-0340-b044-ef6e1d120f9e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[696215, 14307, 373, 8, 28, "Input",ExpressionUUID->"de4e014f-d63d-4a4e-9832-479eb205eecd"],
Cell[696591, 14317, 9713, 277, 74, "Output",ExpressionUUID->"4c8262cb-a07a-3a4f-a6d1-3c2c354c8c86"]
}, Open  ]],
Cell[CellGroupData[{
Cell[706341, 14599, 370, 9, 28, "Input",ExpressionUUID->"161f0ed4-1c3e-4e0c-b826-bba26a79a7f0"],
Cell[706714, 14610, 10909, 303, 74, "Output",ExpressionUUID->"e05d57d5-739e-ff4a-9f5e-76c4e968290a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[717660, 14918, 246, 5, 28, "Input",ExpressionUUID->"fdc33cb9-c29a-4f0c-ac7e-403c882e6925"],
Cell[717909, 14925, 8663, 251, 51, "Output",ExpressionUUID->"dfd140ad-5c3d-3749-a2fb-427022deafd9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[726609, 15181, 243, 5, 28, "Input",ExpressionUUID->"c7b47ff0-9241-4c09-b59d-948ba3780f9d"],
Cell[726855, 15188, 12696, 354, 54, "Output",ExpressionUUID->"2d8d8e2b-094a-8541-9c9f-6274733b6929"]
}, Open  ]],
Cell[CellGroupData[{
Cell[739588, 15547, 248, 5, 28, "Input",ExpressionUUID->"d890d309-c1cd-4cad-b5fe-745b9ac084f1"],
Cell[739839, 15554, 634, 10, 32, "Output",ExpressionUUID->"0bf02e16-c754-a541-b4a1-2ac763a3e2e5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[740510, 15569, 463, 12, 28, "Input",ExpressionUUID->"1e7a4947-23d4-443b-bab5-405189e6b514"],
Cell[740976, 15583, 764, 11, 32, "Output",ExpressionUUID->"0c10dec3-b062-e741-bbe8-0c78d2cf4565"]
}, Open  ]],
Cell[CellGroupData[{
Cell[741777, 15599, 455, 12, 28, "Input",ExpressionUUID->"29a427ae-be69-4c1d-bb2e-b83ce923ec29"],
Cell[742235, 15613, 2485, 67, 34, "Output",ExpressionUUID->"3b22c529-8719-e64e-8b76-524f53814c60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[744757, 15685, 371, 8, 28, "Input",ExpressionUUID->"27f8f483-7a47-4516-bcdb-895e57a399c0"],
Cell[745131, 15695, 9700, 280, 57, "Output",ExpressionUUID->"3fad9b04-02d4-2c43-bae2-b8c60361a255"]
}, Open  ]],
Cell[CellGroupData[{
Cell[754868, 15980, 246, 5, 28, "Input",ExpressionUUID->"b6219253-5cb6-420f-8b1f-55cbdca7c765"],
Cell[755117, 15987, 656, 10, 32, "Output",ExpressionUUID->"8baf265a-53c6-c44a-95c5-d33bfa989eb3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[755810, 16002, 264, 4, 28, "Input",ExpressionUUID->"f3c4773f-91e8-4d8f-b79a-3c9e764505e8"],
Cell[756077, 16008, 6129, 172, 55, "Output",ExpressionUUID->"716dc2be-c029-2f43-a888-44f5abdb9515"]
}, Open  ]],
Cell[CellGroupData[{
Cell[762243, 16185, 212, 4, 28, "Input",ExpressionUUID->"2fc6835a-3a91-4846-83c6-d9d41e157246"],
Cell[762458, 16191, 7701, 219, 55, "Output",ExpressionUUID->"2e335908-9721-7d43-9ef2-acad96f7a660"]
}, Open  ]],
Cell[CellGroupData[{
Cell[770196, 16415, 485, 13, 28, "Input",ExpressionUUID->"9a380b65-8132-4a2b-a01e-1b3c2ef32d83"],
Cell[770684, 16430, 11322, 327, 55, "Output",ExpressionUUID->"6867af38-2e61-7944-8b8f-ff174119fd55"]
}, Open  ]],
Cell[CellGroupData[{
Cell[782043, 16762, 223, 4, 28, "Input",ExpressionUUID->"13c916d7-38a9-4857-9384-e129c2987671"],
Cell[782269, 16768, 15092, 429, 55, "Output",ExpressionUUID->"a0e0cb7e-6f26-a942-b181-cb71717135e8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[797398, 17202, 212, 4, 28, "Input",ExpressionUUID->"6369bfde-ef54-4190-b2be-ffc123ceae9c"],
Cell[797613, 17208, 9404, 276, 55, "Output",ExpressionUUID->"b4cd9aae-c71a-3e4f-bb50-b21562d7cae6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[807054, 17489, 405, 9, 28, "Input",ExpressionUUID->"1608b1cf-f1f5-402a-8cd1-d80dfdf597b4"],
Cell[807462, 17500, 3218, 91, 34, "Output",ExpressionUUID->"46b1c548-f9ae-f742-a129-610eedece301"]
}, Open  ]],
Cell[CellGroupData[{
Cell[810717, 17596, 236, 5, 28, "Input",ExpressionUUID->"9466e2c6-f78d-47cf-9b41-2cb0adee06c8"],
Cell[810956, 17603, 596, 10, 32, "Output",ExpressionUUID->"e95ce54f-0f05-9a4d-a3f2-dedb507ef5c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[811589, 17618, 396, 12, 28, "Input",ExpressionUUID->"db1af2d2-3bb5-49ee-829f-1d016f21d0e2"],
Cell[811988, 17632, 2469, 67, 34, "Output",ExpressionUUID->"6e34d0af-8767-714b-bf9b-c60fb7bb27d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[814494, 17704, 284, 7, 28, "Input",ExpressionUUID->"d101dfce-465e-4067-9e30-d357d728fd93"],
Cell[814781, 17713, 3381, 94, 34, "Output",ExpressionUUID->"cdb651db-3db5-784f-b0d2-80ecee56d036"]
}, Open  ]],
Cell[CellGroupData[{
Cell[818199, 17812, 399, 9, 28, "Input",ExpressionUUID->"d9d5a7c8-9805-476c-8a5b-8fc747049aa0"],
Cell[818601, 17823, 4298, 122, 34, "Output",ExpressionUUID->"921f4f6c-c945-334d-ad08-b789d60a0481"]
}, Open  ]],
Cell[CellGroupData[{
Cell[822936, 17950, 373, 8, 28, "Input",ExpressionUUID->"dfb8975d-5449-460e-887a-fb64f986951b"],
Cell[823312, 17960, 11683, 334, 57, "Output",ExpressionUUID->"b3e79564-8afd-974e-815a-d02d4fa57f15"]
}, Open  ]],
Cell[CellGroupData[{
Cell[835032, 18299, 553, 16, 28, "Input",ExpressionUUID->"056e44f3-a43f-4876-9552-151496d2a315"],
Cell[835588, 18317, 12628, 362, 57, "Output",ExpressionUUID->"4214ee0f-d24a-8043-aeac-80cbf0e6f969"]
}, Open  ]],
Cell[CellGroupData[{
Cell[848253, 18684, 366, 9, 28, "Input",ExpressionUUID->"214007c6-d38f-456b-8728-f3faa36a0dee"],
Cell[848622, 18695, 13613, 391, 57, "Output",ExpressionUUID->"61a46402-50a2-e143-ac30-6ba5a1a84aab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[862272, 19091, 248, 5, 28, "Input",ExpressionUUID->"5a2ba937-2a6f-4d03-a085-1729be786a47"],
Cell[862523, 19098, 14470, 417, 51, "Output",ExpressionUUID->"474e5b43-abed-2a4c-80ba-dd4f0001b5e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[877030, 19520, 293, 6, 28, "Input",ExpressionUUID->"5f4bf89c-6e4b-45a8-a224-ab4f4da25dcd"],
Cell[877326, 19528, 6066, 175, 55, "Output",ExpressionUUID->"6986c6fe-668c-4444-87e3-ff4fe1c98913"]
}, Open  ]],
Cell[CellGroupData[{
Cell[883429, 19708, 623, 20, 28, "Input",ExpressionUUID->"06e22a79-91db-43ff-8e6e-37b199ff3c34"],
Cell[884055, 19730, 2734, 75, 51, "Output",ExpressionUUID->"d3b2c51e-c6fc-7f4f-a33c-e124c33c805e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[886826, 19810, 261, 6, 28, "Input",ExpressionUUID->"f44a078b-ed09-44f3-8fb9-aed2d2168dec"],
Cell[887090, 19818, 3587, 101, 51, "Output",ExpressionUUID->"7f34e707-b0c6-b444-85b9-e7ed28ec92da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[890714, 19924, 375, 7, 28, "Input",ExpressionUUID->"0a8e54a0-9079-483f-bec7-0a911e3346cc"],
Cell[891092, 19933, 2730, 75, 51, "Output",ExpressionUUID->"db8c5a92-72fd-f147-a64b-2baf07be72c1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[893859, 20013, 392, 12, 28, "Input",ExpressionUUID->"0d37a6a8-7594-47e2-bc57-c473d8051d69"],
Cell[894254, 20027, 2247, 32, 32, "Output",ExpressionUUID->"c0ee2833-3384-604f-9692-2c2f171c55dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[896538, 20064, 394, 12, 28, "Input",ExpressionUUID->"648bc087-bf32-44ba-a2fe-43fbf28f9712"],
Cell[896935, 20078, 3367, 64, 34, "Output",ExpressionUUID->"cd4b9a44-764a-014c-b0c6-990c8e7796ab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[900339, 20147, 346, 6, 28, "Input",ExpressionUUID->"20fe2f20-1305-43ae-ade9-b3c5590835e8"],
Cell[900688, 20155, 6695, 164, 55, "Output",ExpressionUUID->"31545e86-61ed-ff4c-b78a-8109b03d2825"]
}, Open  ]],
Cell[CellGroupData[{
Cell[907420, 20324, 273, 5, 28, "Input",ExpressionUUID->"010bd2cc-b766-402e-8ad8-21c3cb920c0d"],
Cell[907696, 20331, 13604, 365, 74, "Output",ExpressionUUID->"85408607-05b9-2443-8883-4007c56cc288"]
}, Open  ]],
Cell[CellGroupData[{
Cell[921337, 20701, 261, 5, 28, "Input",ExpressionUUID->"8b3bcb86-6988-4fb2-b25e-d575a9e10e20"],
Cell[921601, 20708, 2367, 50, 34, "Output",ExpressionUUID->"f05f1972-d4c0-5a41-abc0-45a51b8b4e30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[924005, 20763, 472, 12, 28, "Input",ExpressionUUID->"4fdcfe84-f08b-4b70-b247-6045ef082172"],
Cell[924480, 20777, 2579, 55, 34, "Output",ExpressionUUID->"d1b5169a-7c53-8247-a30e-77f93d2f46d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[927096, 20837, 315, 6, 28, "Input",ExpressionUUID->"de164043-2d4b-4d22-9b27-6bfdbc21739a"],
Cell[927414, 20845, 3287, 79, 34, "Output",ExpressionUUID->"19e76599-5c7f-e144-8d4e-338898336a1f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[930738, 20929, 269, 5, 28, "Input",ExpressionUUID->"c4f0350d-1832-44e7-904a-54d385f6df79"],
Cell[931010, 20936, 7189, 189, 58, "Output",ExpressionUUID->"f6591e04-42ff-6c46-9dd0-103e7e1772c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[938236, 21130, 263, 5, 28, "Input",ExpressionUUID->"87797569-1074-4f2a-a337-885dbc18260f"],
Cell[938502, 21137, 2451, 53, 34, "Output",ExpressionUUID->"9b9a712f-93ed-7f4d-9567-672927b40e74"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

