(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1298374,      35084]
NotebookOptionsPosition[   1271293,      34666]
NotebookOutlinePosition[   1271741,      34684]
CellTagsIndexPosition[   1271698,      34681]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["SpinFrames package examples", "Section",
 CellChangeTimes->{{3.644040180198903*^9, 3.6440401959664197`*^9}, 
   3.6477596101504073`*^9, {3.647769561281448*^9, 
   3.6477695629690385`*^9}},ExpressionUUID->"06b29797-6b3c-43a6-85f4-\
0d1ffcdbd50f"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellChangeTimes->{{3.645010529473902*^9, 3.6450105325839067`*^9}, {
  3.6481983142425528`*^9, 
  3.648198316711464*^9}},ExpressionUUID->"53b7a24f-f85f-4daa-88c2-\
d8ee95821d8b"],

Cell["\<\
This package uses Newman-Penrose (NP) and Geroch-Held-Penrose (GHP) component \
formalisms to extract geometric properties of covariant spinorial \
differential equations in dimension 4 of Lorentzian signature. With highly \
integrated functions like ToGHP or AllGHPCommutatorsForward large sets of GHP \
equations can be treated efficiently.

The package is partly based on a notebook for pure NP or GHP calculations \
using (GHP-weighted) scalars by Alfonso Garcia-Parrado Gomez-Lobo available \
under http://xact.es/Documentation/English/PublicNPGHP.nb (There derivations \
of the NP/GHP form of Ricci-identities, Bianchi-identities and commutators \
can be found, which are hardcoded in this package).
The aim of SpinFrames is different in the sense that general spinorial \
equations can be expanded into components automatically. Here we focused on \
spinors, because the irreducible decomposition of equations leads \
automatically to \[OpenCurlyDoubleQuote]a minimal set of required quantities\
\[CloseCurlyDoubleQuote]. Irreducible decompositions of spinors can be done \
automatically with the SymManipulator package, while  irreducible \
decompositions of tensors are much more involved and do not lead in such a \
nice way to the component form.

The package requires at least SymManipulator 0.9.6, TexAct 0.4.4, Spinors \
1.0.6, xCoba 0.8.6 \
\>", "Text",
 CellChangeTimes->{{3.647759601993722*^9, 3.6477596275888042`*^9}, {
   3.6477597126363063`*^9, 3.6477597630764055`*^9}, {3.6477598608892555`*^9, 
   3.6477600189087577`*^9}, {3.6477687467115536`*^9, 3.6477687557745285`*^9}, 
   3.6477688404508195`*^9, {3.647768935279125*^9, 3.647768935669738*^9}, {
   3.647769454228988*^9, 3.6477695837669973`*^9}, {3.6477696745782537`*^9, 
   3.6477697933579144`*^9}, {3.647778991633498*^9, 3.6477789933992157`*^9}, {
   3.647779378462239*^9, 3.647779390837884*^9}, {3.6477794339295483`*^9, 
   3.6477794418049593`*^9}, {3.647779471884654*^9, 3.6477794936982903`*^9}, {
   3.647779566795854*^9, 3.647779610028288*^9}, {3.647779644655095*^9, 
   3.6477796688907347`*^9}, {3.647779705001995*^9, 3.647779716549471*^9}, {
   3.6478402334582005`*^9, 3.647840251388259*^9}, {3.647840303656482*^9, 
   3.64784038364705*^9}, {3.6478404190043516`*^9, 3.6478404545295577`*^9}, {
   3.6478405302382936`*^9, 3.64784053461352*^9}, {3.647840592053141*^9, 
   3.647840633038813*^9}, {3.6478432819505453`*^9, 3.6478432997557364`*^9}, {
   3.6481964751712446`*^9, 3.6481964787495556`*^9}, {3.648196714233886*^9, 
   3.6481967768062286`*^9}, {3.648196858731207*^9, 3.648196915490475*^9}, {
   3.6481969521160693`*^9, 3.6481969550225058`*^9}, {3.648197010408595*^9, 
   3.6481971093620086`*^9}, {3.648198180782378*^9, 3.648198193747774*^9}, {
   3.648198252684198*^9, 3.6481982688643064`*^9}, {3.648210813684537*^9, 
   3.6482108171490836`*^9}, {3.648349831923768*^9, 3.648349850883795*^9}, 
   3.6483502215843134`*^9, {3.648350305134431*^9, 3.648350377594532*^9}, {
   3.7282100011973877`*^9, 3.7282100038987813`*^9}, 3.7282100467141843`*^9, 
   3.728210381476144*^9, {3.9561927710115223`*^9, 
   3.956192797341118*^9}},ExpressionUUID->"e0a8e66b-986c-46d2-9bcc-\
a7388d14defb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Init", "Subsection",
 CellChangeTimes->{{3.645010529473902*^9, 
  3.6450105325839067`*^9}},ExpressionUUID->"b412cc77-0c85-482a-a5df-\
2af6813e7bdd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`SymManipulator`"}]], "Input",
 CellChangeTimes->{{3.582978274310623*^9, 3.5829782779506283`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"5e9c6741-a771-4075-8da3-90ed0a42209d"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931307365*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"58d6764f-a3b9-4494-a0a2-d4dac28684c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.9754679313087587`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"a65eb360-cb35-4c44-a0d1-ca7bf209f189"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931310968*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"150f786d-ec16-4bea-87bb-86f604b1289a"],

Cell[BoxData["\<\"Connecting to external linux executable...\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931380134*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"68360e43-0efe-4fb5-b744-6e2fc99bb982"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931414809*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"4e7a2cd6-ced1-448c-a15f-5016f7be94f2"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931420656*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"dfa572d3-9d1d-4a6e-a218-57070da94502"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931421636*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"725f06c9-8424-4a41-921e-10b3aae80a49"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931422431*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"397255fd-6aaf-4e30-965d-9adb6362f1db"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931514783*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"639cecfd-9630-4620-b3c5-bea23a2ddeb3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SymManipulator`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.9.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2024", ",", "4", ",", "30"}], "}"}]}],
  SequenceForm[
  "Package xAct`SymManipulator`  version ", "0.9.6", ", ", {2024, 4, 30}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.97546793151608*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"8e184856-8fde-4df9-abce-2a0af6c18411"],

Cell[BoxData["\<\"CopyRight (C) 2011-2021, Thomas B\[ADoubleDot]ckdahl, under \
the General Public License.\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.9754679315169687`*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"bb19b292-7568-40a0-82d7-20c49260de69"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931548423*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"69be1dc3-012a-40b2-93de-d0a974b5fbcd"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931554227*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"41542f8f-f4dc-4a58-9b62-746f62d5b746"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807184965125*^9, 3.632807212141241*^9}, 
   3.633021671451436*^9, 3.633063619076556*^9, 3.6332425657465982`*^9, 
   3.6332701343205786`*^9, 3.633334134923021*^9, 3.63333462046677*^9, 
   3.6333542971842175`*^9, 3.6336864819875717`*^9, 3.6337970655374346`*^9, 
   3.6339441813725195`*^9, 3.634044851751899*^9, 3.63427415077481*^9, 
   3.6342852876324024`*^9, 3.6343062766766615`*^9, 3.6343635435927687`*^9, 
   3.6344465105569043`*^9, 3.6344493544080715`*^9, 3.634530124490921*^9, 
   3.6348909127663474`*^9, 3.6350943284704514`*^9, 3.6355125327227154`*^9, 
   3.6356548815487576`*^9, 3.6356853185452967`*^9, 3.63583820620743*^9, 
   3.635841772961458*^9, 3.6358491404446125`*^9, 3.636119340805501*^9, 
   3.6361795149577427`*^9, 3.6365430969603834`*^9, 3.6367258387374587`*^9, 
   3.6373038226510077`*^9, 3.637496182367216*^9, 3.6375991861837*^9, 
   3.6376107051303606`*^9, 3.6376366868997126`*^9, 3.6376595744475784`*^9, 
   3.6376651215461116`*^9, 3.637730635896694*^9, 3.637911426864806*^9, 
   3.63802523111205*^9, 3.6381075542261553`*^9, 3.638156401521514*^9, 
   3.6382692210818005`*^9, 3.638545114063052*^9, 3.6386048292888193`*^9, 
   3.6386876489044085`*^9, 3.6387828256526513`*^9, {3.6388621752803483`*^9, 
   3.638862194970006*^9}, 3.6398349215741863`*^9, {3.6404997194634566`*^9, 
   3.6404997405845556`*^9}, 3.6404999696419177`*^9, 3.6405089278761578`*^9, 
   3.6405153950994773`*^9, 3.6409386161084876`*^9, 3.6409431100519323`*^9, 
   3.6410227520191865`*^9, {3.641089829749978*^9, 3.641089844689945*^9}, 
   3.641103117652438*^9, 3.641126296715784*^9, 3.6411878156315093`*^9, 
   3.641270418426424*^9, 3.641281290200775*^9, 3.6415617052366433`*^9, 
   3.6421443457207355`*^9, 3.64224279190071*^9, 3.642259593352555*^9, 
   3.6423264151115475`*^9, 3.6423267072860117`*^9, 3.6423472367224197`*^9, 
   3.6424278530123854`*^9, 3.6424376130164614`*^9, 3.642478945953889*^9, 
   3.642571667476577*^9, 3.642609902570447*^9, 3.64265165109195*^9, 
   3.642652307787716*^9, 3.642680226174882*^9, 3.64268881656607*^9, 
   3.6427465923552823`*^9, 3.642822512791442*^9, 3.642823203002408*^9, 
   3.642823450412754*^9, 3.6428243112349596`*^9, 3.6428243939150753`*^9, 
   3.6428281477633305`*^9, 3.642830251647276*^9, 3.642831754930381*^9, 
   3.642833016293147*^9, 3.642833332313589*^9, 3.6428345563363028`*^9, 
   3.6428348888167686`*^9, {3.6428350404269805`*^9, 3.642835058717006*^9}, 
   3.6428421977017574`*^9, 3.6428427230824933`*^9, 3.6428427992226*^9, 
   3.6428431691141176`*^9, 3.642843265544253*^9, 3.6428433488243694`*^9, 
   3.6428436826548367`*^9, 3.642844093780419*^9, 3.6428447173122916`*^9, 
   3.6428453414331656`*^9, 3.6428455188134136`*^9, 3.6428456543136034`*^9, 
   3.642846412585665*^9, 3.642846905256355*^9, 3.6428469908464746`*^9, 
   3.6428492948027*^9, 3.6428497598133516`*^9, 3.6428500434947486`*^9, 
   3.642850226475005*^9, 3.642850892136937*^9, 3.6428509260369844`*^9, 
   3.642854842164467*^9, 3.6428552017059703`*^9, 3.6428552558860464`*^9, 
   3.6428554576163287`*^9, 3.642860492786378*^9, 3.6428666620313225`*^9, 
   3.6429078716970377`*^9, 3.6429092436760836`*^9, 3.6429098284753113`*^9, 
   3.6429296963784447`*^9, 3.642930269306051*^9, 3.642931486032188*^9, 
   3.642932787950075*^9, 3.6429329148718977`*^9, 3.642934098666377*^9, 
   3.642940870825657*^9, 3.6430003912094617`*^9, 3.643039484412284*^9, 
   3.6430465747697005`*^9, 3.6430977794126973`*^9, 3.6432203487711053`*^9, 
   3.6432217948237576`*^9, 3.64339141339933*^9, 3.6433930640924826`*^9, 
   3.6434336423282146`*^9, 3.643519626177702*^9, 3.6435375695239353`*^9, 
   3.6436011962751875`*^9, 3.643602585887789*^9, 3.643603075139504*^9, 
   3.643603853775299*^9, 3.64360543232301*^9, 3.643608318430092*^9, 
   3.643866128316925*^9, 3.6439639312366724`*^9, 3.643984459351285*^9, 
   3.64404021762387*^9, 3.6440554645827384`*^9, 3.6441212362270737`*^9, 
   3.6441401503467274`*^9, 3.6442072450360384`*^9, 3.644210702925988*^9, 
   3.644235285860941*^9, 3.644236474753824*^9, 3.644241746231884*^9, 
   3.64424179407819*^9, 3.6442419852876577`*^9, 3.6443148969654093`*^9, 
   3.644315001455556*^9, 3.6443150533256283`*^9, 3.644316487338636*^9, 
   3.6443165366887054`*^9, 3.644316710118948*^9, 3.6449398170816374`*^9, 
   3.6449402757332797`*^9, 3.644940368493409*^9, 3.6449404436635146`*^9, 
   3.645004873621793*^9, 3.6450087325713863`*^9, 3.6450100212331905`*^9, 
   3.645010071273261*^9, 3.6450104423637805`*^9, 3.6450105122838783`*^9, 
   3.645010568343957*^9, 3.6450106396040564`*^9, 3.645010882775397*^9, 
   3.6450111010357027`*^9, 3.6464533516807375`*^9, 3.647319008425825*^9, 
   3.647319905563612*^9, 3.647328372279748*^9, 3.6473287884713306`*^9, 
   3.6473288506614175`*^9, 3.6473337063428726`*^9, 3.647703123632454*^9, 
   3.6477507583751726`*^9, 3.64775141488725*^9, 3.6477523441511984`*^9, 
   3.6477772557750564`*^9, 3.6477907914790916`*^9, 3.647792246528067*^9, 
   3.648183148156362*^9, 3.6481884842441177`*^9, 3.6481916665660095`*^9, 
   3.648193200483923*^9, 3.648193286163921*^9, 3.648209868575658*^9, 
   3.64821021010704*^9, 3.6482639981818123`*^9, 3.648264281429792*^9, 
   3.6482650903567176`*^9, 3.6483498697538214`*^9, 3.6483509149962845`*^9, 
   3.648352600489644*^9, 3.6491725216664515`*^9, 3.6491726628166494`*^9, 
   3.7282099902877874`*^9, 3.7282103648952436`*^9, 3.7282104683244295`*^9, 
   3.728793133234188*^9, 3.956192748130684*^9, 3.956193822725622*^9, 
   3.9754649374333153`*^9, 3.975464981418132*^9, 3.97546602376196*^9, 
   3.975467291527845*^9, 3.975467533231194*^9, 3.975467931555264*^9},
 CellLabel->
  "During evaluation of \
In[3]:=",ExpressionUUID->"4541a9d3-303c-45a5-bb08-a04585ad0518"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`SpinFrames`"}]], "Input",
 CellChangeTimes->{{3.4930250813754*^9, 3.4930250849734*^9}, 
   3.607155122356115*^9, {3.6247599797151012`*^9, 3.6247599801526246`*^9}, {
   3.6247789160856695`*^9, 3.6247789164606895`*^9}, 3.647318998753476*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"81392721-68d6-429a-b116-ba3148784211"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467931892201*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9c73224d-8a4c-489b-9e69-a4c83761e757"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`TexAct`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.4.5\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "8", ",", "9"}], "}"}]}],
  SequenceForm["Package xAct`TexAct`  version ", "0.4.5", ", ", {2025, 8, 9}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467931898218*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"83201235-b2cc-4d16-8cf3-d08a05b29043"],

Cell[BoxData["\<\"CopyRight (C) 2008-2021, Thomas B\[ADoubleDot]ckdahl, Jose \
M. Martin-Garcia and Barry Wardell, under the General Public License.\"\>"], \
"Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467931900367*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"04140236-53af-4785-808d-40101296a74c"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467931981779*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"5d471802-eaf3-41b7-99c9-c413c4544e29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.6", ", ", {2021, 2, 28}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467931983161*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"9d7564a4-f611-43a3-8ade-1028c0f8d07d"],

Cell[BoxData["\<\"CopyRight (C) 2005-2021, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467931984044*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d7e0ea0d-19ab-41a9-aa47-983b128161ba"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467932428179*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"5a0f15d5-ef1d-43cf-b875-a42174e0ef1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`Spinors`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.0.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm[
  "Package xAct`Spinors`  version ", "1.0.6", ", ", {2021, 2, 28}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467932429267*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"a0075e5c-ef46-44ba-985f-bab54d539df5"],

Cell[BoxData["\<\"CopyRight (C) 2006-2018, Alfonso Garcia-Parrado Gomez-Lobo \
and Jose M. Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467932430112*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"220a9ef7-641a-4218-b8ad-f3dc6be8480d"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467932464669*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"d1da9119-c7a1-4e66-8362-f67bd25ef41b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`SpinFrames`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.5.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "23"}], "}"}]}],
  SequenceForm[
  "Package xAct`SpinFrames`  version ", "0.5.6", ", ", {2025, 12, 23}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467932470543*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"f4b883df-dc0f-4622-89e0-6052ceedbe47"],

Cell[BoxData["\<\"CopyRight (C) 2014-2024, Thomas B\[ADoubleDot]ckdahl and \
Steffen Aksteiner, under the General Public License.\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467932471307*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"7b65568d-aed6-4aee-8bcc-acd6a43ceb0d"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467932472089*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"042ac7d5-2938-42ec-bd0f-24e28d170861"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.975467932472826*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1e714b39-b866-491a-a591-905da07f90dc"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{{3.632807185527652*^9, 3.6328072126568947`*^9}, 
   3.633021672201476*^9, 3.6330636207641354`*^9, 3.6332425661216145`*^9, 
   3.633270134695599*^9, 3.633334135282422*^9, 3.6333346208105383`*^9, 
   3.63335429862179*^9, 3.6336864823938427`*^9, 3.6337970670062633`*^9, 
   3.633944182645368*^9, 3.634044852158167*^9, 3.634274151134205*^9, 
   3.634285288116804*^9, 3.6343062771610622`*^9, 3.6343635454750714`*^9, 
   3.634446510931924*^9, 3.6344493547518377`*^9, 3.634530124990947*^9, 
   3.634890914610191*^9, 3.635094328831337*^9, 3.6355125331446123`*^9, 
   3.635654883548859*^9, 3.6356853190296965`*^9, 3.635838206566828*^9, 
   3.635841773320851*^9, 3.6358491409446416`*^9, 3.6361193421649485`*^9, 
   3.636179516379698*^9, 3.636543097710424*^9, 3.6367258405336614`*^9, 
   3.637303823175358*^9, 3.637496183864217*^9, 3.6375991876876636`*^9, 
   3.6376107055956726`*^9, 3.63763668734601*^9, 3.637659575791402*^9, 
   3.63766512285868*^9, 3.637730636616173*^9, 3.637911427271079*^9, 
   3.6380252325808773`*^9, 3.6381075546434345`*^9, 3.6381564034057713`*^9, 
   3.638269221409941*^9, 3.638545114469325*^9, 3.6386048297361174`*^9, 
   3.6386876495122967`*^9, 3.6387828260259004`*^9, 3.6388621954231524`*^9, 
   3.639834921942432*^9, {3.64049971985772*^9, 3.640499740927784*^9}, 
   3.6404999699827843`*^9, 3.64050892824888*^9, 3.640515395575796*^9, 
   3.640938616465726*^9, 3.6409431103800745`*^9, 3.6410227525035877`*^9, 
   3.6410898451382437`*^9, 3.6411031183434076`*^9, 3.641126297059548*^9, 
   3.641187816104825*^9, 3.641270418770192*^9, 3.6412812905601673`*^9, 
   3.641561706884471*^9, 3.6421443460957527`*^9, 3.642242793286629*^9, 
   3.642259594774501*^9, 3.6423264164553595`*^9, 3.6423267086767063`*^9, 
   3.642347237191186*^9, 3.642427854606208*^9, 3.6424376134567432`*^9, 
   3.6424789479201965`*^9, 3.6425716678984704`*^9, 3.6426099030548463`*^9, 
   3.6426516529241743`*^9, 3.642652309185547*^9, 3.642680226867344*^9, 
   3.642688817063436*^9, 3.642746593808489*^9, 3.6428225131814423`*^9, 
   3.642823203332408*^9, 3.6428234507527547`*^9, 3.64282431160496*^9, 
   3.6428243942650757`*^9, 3.642828148103331*^9, 3.6428302519672766`*^9, 
   3.6428317551703815`*^9, 3.642833016533147*^9, 3.6428333325335894`*^9, 
   3.6428345566563034`*^9, 3.642834889036769*^9, {3.6428350406669807`*^9, 
   3.6428350589670067`*^9}, 3.6428421981217585`*^9, 3.6428427234424934`*^9, 
   3.6428427996526003`*^9, 3.6428431694341183`*^9, 3.642843265864253*^9, 
   3.64284334914437*^9, 3.6428436830148373`*^9, 3.6428440941204195`*^9, 
   3.6428447176522923`*^9, 3.6428453417731657`*^9, 3.6428455191534147`*^9, 
   3.642845654663604*^9, 3.6428464129056654`*^9, 3.6428469055963554`*^9, 
   3.6428469911664753`*^9, 3.6428492951227007`*^9, 3.642849760153352*^9, 
   3.642850043804749*^9, 3.6428502268150053`*^9, 3.642850892466937*^9, 
   3.642850926356985*^9, 3.6428548425344677`*^9, 3.6428552020359707`*^9, 
   3.6428552562160463`*^9, 3.6428554579563293`*^9, 3.6428604930363784`*^9, 
   3.6428666624013233`*^9, 3.6429078721026387`*^9, 3.642909244003684*^9, 
   3.6429098288185115`*^9, 3.642929696706045*^9, 3.642930269649251*^9, 
   3.6429314862661886`*^9, 3.642932788293275*^9, 3.642932915230698*^9, 
   3.642934099025178*^9, 3.6429408711688576`*^9, 3.643000392615779*^9, 
   3.6430394858185987`*^9, 3.643046575175969*^9, 3.643097779850221*^9, 
   3.6432203492343626`*^9, 3.6432217952829475`*^9, 3.6433914152195606`*^9, 
   3.643393065695551*^9, 3.6434336427813606`*^9, 3.643519628642333*^9, 
   3.6435375699902444`*^9, 3.643601197931514*^9, 3.6436025874347334`*^9, 
   3.643603076717705*^9, 3.6436038553691273`*^9, 3.6436054327761602`*^9, 
   3.643608318883241*^9, 3.6438661287700715`*^9, 3.643963931721073*^9, 
   3.6439844610857415`*^9, 3.6440402181021876`*^9, 3.6440554650190296`*^9, 
   3.644121236680375*^9, 3.644140153315631*^9, 3.6442072454689465`*^9, 
   3.644210703379138*^9, 3.6442352862984753`*^9, 3.6442364762226515`*^9, 
   3.644241746606902*^9, 3.6442417945000877`*^9, 3.6442419856783023`*^9, 
   3.64431489733541*^9, 3.6443150017655563`*^9, 3.644315053645629*^9, 
   3.644316487658636*^9, 3.644316536998706*^9, 3.6443167104489484`*^9, 
   3.6449398174716377`*^9, 3.64494027605328*^9, 3.64494036883341*^9, 
   3.644940443993515*^9, 3.645004873921793*^9, 3.645008732971387*^9, 
   3.645010021553191*^9, 3.645010071603261*^9, 3.645010442693781*^9, 
   3.6450105126038785`*^9, 3.645010568663957*^9, 3.645010639924057*^9, 
   3.6450108831153975`*^9, 3.645011101375703*^9, 3.6464533521040173`*^9, 
   3.647319008816471*^9, 3.647319905907378*^9, 3.6473283726497483`*^9, 
   3.647328788801331*^9, 3.647328851001418*^9, 3.6473337067211266`*^9, 
   3.6477031240257177`*^9, 3.6477507589064503`*^9, 3.64775141526227*^9, 
   3.647752344698102*^9, 3.6477772564000874`*^9, 3.647790792107501*^9, 
   3.647792247048414*^9, 3.6481831494845533`*^9, 3.6481884856816874`*^9, 
   3.6481916670504036`*^9, 3.648193201999628*^9, 3.648193287663989*^9, 
   3.648209868950676*^9, 3.648210210482058*^9, 3.6482639995725126`*^9, 
   3.648264282632972*^9, 3.6482650918880496`*^9, 3.6483498701138215`*^9, 
   3.648350915316285*^9, 3.6483526007196445`*^9, 3.649172521966452*^9, 
   3.64917266316665*^9, 3.7282099913040714`*^9, 3.7282103688802075`*^9, 
   3.728210468693079*^9, 3.728793133563207*^9, 3.9561927568364315`*^9, 
   3.9561938232551785`*^9, 3.975464937793529*^9, 3.97546498198343*^9, 
   3.975466024319813*^9, 3.975467292138935*^9, 3.9754675337798233`*^9, 
   3.9754679324736547`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"586ff8ce-1de6-4c0a-9504-ec92b1d272b6"]
}, Open  ]]
}, Open  ]],

Cell["We don't want too many messages:", "Text",
 CellChangeTimes->{{3.648350416244586*^9, 
  3.6483504496546326`*^9}},ExpressionUUID->"d5d96ba1-550e-42d0-b35e-\
7745d816e145"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"$CVVerbose", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"AutomaticRules", ",", 
    RowBox[{"Verbose", "\[Rule]", "False"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.458061670223096*^9, 3.4580616749787188`*^9}, 
   3.458280552972406*^9, {3.6070649056938066`*^9, 3.6070649314238424`*^9}, {
   3.6483507071259937`*^9, 3.6483507136360025`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"f40f8139-c34d-4f99-9289-f3e5a23bf61e"],

Cell["\<\
Follow Penrose Rindler sign conventions ($RiemannSign is opposite to the \
conventions of Wald)\
\>", "Text",
 CellChangeTimes->{{3.6472546675667777`*^9, 
  3.6472547068460245`*^9}},ExpressionUUID->"5c2eb7a8-79f6-45ef-bbc3-\
7e11dc19b2ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RiemannSign", "=", 
   RowBox[{"-", "1"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.647254712516349*^9, 3.6472547142374473`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"86faec5b-5f57-4bb9-8f44-7c8c74d6bda7"],

Cell["Declare 4-manifold :", "Text",
 CellChangeTimes->{{3.4581254864280243`*^9, 3.458125490803075*^9}, {
  3.45828065180431*^9, 
  3.458280651957197*^9}},ExpressionUUID->"4c89fe60-2e18-4534-88cf-\
2a0b758981d4"],

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M4", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "h", ",", "l", ",", "m",
      ",", "p", ",", "q"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.458061600629331*^9, 3.4580616119243917`*^9}, 
   3.4930234672464*^9, 3.4930252618884*^9, {3.4930256821434*^9, 
   3.4930256973644*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"d0282584-7f30-419f-86a8-c76fec53067d"],

Cell["Declare abstract metric :", "Text",
 CellChangeTimes->{{3.458125496632946*^9, 3.458125501564406*^9}, {
  3.458280669950614*^9, 
  3.458280679080079*^9}},ExpressionUUID->"d5a31d1b-6b83-48e5-a22a-\
0ce187e131c0"],

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}], ",", 
   RowBox[{"DefInfo", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4930246743644*^9, 3.4930246825154*^9}, {
  3.4930257047374*^9, 3.4930257055004*^9}, {3.4930364767714*^9, 
  3.4930364782344*^9}, {3.582977715587841*^9, 3.582977721317849*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"72952092-15df-49d5-8d59-df2be72e8922"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"ValidateSymbol", "::", "\"\<capital\>\""}], "]"}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"932461c0-494b-495f-bf40-036046e82626"],

Cell["We want dagger indices to be displayed with a prime.", "Text",
 CellChangeTimes->{{3.6483505064147124`*^9, 
  3.648350538294757*^9}},ExpressionUUID->"ec79c1a8-352f-4900-a0fb-\
5508e783f237"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"DefAbstractIndex", ",", 
    RowBox[{"PrintAs", "\[Rule]", "PrimeDagger"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{3.6483504986947017`*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"df686193-929f-4bf1-ae94-f1f5c3406482"],

Cell["We want dagger spinors to be displayed with a bar.", "Text",
 CellChangeTimes->{{3.6483505064147124`*^9, 
  3.648350559584787*^9}},ExpressionUUID->"6857c0c5-9b6b-43f8-85c1-\
356d0c76ff83"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"DefSpinor", ",", 
    RowBox[{"PrintDaggerAs", "\[Rule]", "AddBar"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.6192611487902145`*^9, 3.6192611585802283`*^9}, 
   3.9561928539862194`*^9},
 CellLabel->"In[13]:=",ExpressionUUID->"73bcbd04-634f-44c8-b3ab-8f2482e99c43"],

Cell["Define a spin structure.", "Text",
 CellChangeTimes->{{3.648350566924797*^9, 
  3.648350588835828*^9}},ExpressionUUID->"ecb74477-7d88-4386-8fe4-\
0a5b2f93d29b"],

Cell[BoxData[
 RowBox[{"DefSpinStructure", "[", 
  RowBox[{"g", ",", "Spin", ",", 
   RowBox[{"{", 
    RowBox[{
    "A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "H", ",", "L", ",", "M",
      ",", "P", ",", "Q", ",", "R", ",", "S"}], "}"}], ",", "\[Epsilon]", ",",
    "\[Sigma]", ",", "CDe", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}], ",", 
   RowBox[{"SpinorPrefix", "->", "SP"}], ",", 
   RowBox[{"SpinorMark", "->", "\"\<S\>\""}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"ce7643aa-ec26-4708-b062-45fadc0e5537"],

Cell["\<\
Here, we don't want a reference to the covariant derivatite in the symbols \
for the curvature.\
\>", "Text",
 CellChangeTimes->{{3.648350566924797*^9, 3.648350599775843*^9}, {
  3.6483506330258894`*^9, 
  3.6483506570159235`*^9}},ExpressionUUID->"8addac25-84d9-452f-b4fb-\
5d7cf456f658"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAs", "[", "PsiCDe", "]"}], "^=", "\"\<\[CapitalPsi]\>\""}],
     ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "PhiCDe", "]"}], "^=", "\"\<\[CapitalPhi]\>\""}],
     ",", 
    RowBox[{
     RowBox[{"PrintAs", "[", "LambdaCDe", "]"}], 
     "^=", "\"\<\[CapitalLambda]\>\""}]}], "}"}], ";"}]], "Input",
 CellChangeTimes->{{3.607083443767644*^9, 3.6070834481576505`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"763d9570-f96c-44b0-a1af-887896773a45"],

Cell["\<\
It is convenient to work with the fundamental spinor operators from the \
SymManipulator package, so we define them.\
\>", "Text",
 CellChangeTimes->{{3.6483506624159307`*^9, 3.6483506952559767`*^9}, {
  3.6483507291760244`*^9, 
  3.648350821956154*^9}},ExpressionUUID->"0965739d-47cd-4cd1-88a9-\
2f5df20e83cf"],

Cell[BoxData[
 RowBox[{"DefFundSpinOperators", "[", "CDe", "]"}]], "Input",
 CellChangeTimes->{{3.6442419392227035`*^9, 3.6442419474106317`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"12bd7cee-75da-4794-a7be-3c0f577b0f37"],

Cell["The SpinFrames package has the following public names:", "Text",
 CellChangeTimes->{{3.6483506624159307`*^9, 3.6483506952559767`*^9}, {
  3.6483507291760244`*^9, 3.648350745956048*^9}, {3.648350838046177*^9, 
  3.6483508829362392`*^9}},ExpressionUUID->"f8442d84-9d7b-4273-bcc7-\
238d63f9f783"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "xAct`SpinFrames`*"}]], "Input",
 CellChangeTimes->{{3.644121546423849*^9, 3.6441215586044426`*^9}, 
   3.6473190504705734`*^9, 3.956192867205879*^9, 3.975464952244011*^9, {
   3.975467323484304*^9, 3.975467328867486*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"83e753cf-5fac-42f7-917b-5f9606dd6b91"],

Cell[BoxData[
 StyleBox[
  FrameBox[GridBox[{
     {
      DynamicModuleBox[{Typeset`open$$ = True}, 
       PaneSelectorBox[{False->
        ButtonBox[
         RowBox[{
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "RightPointerOpener"]], " ", 
          StyleBox["xAct`SpinFrames`", "InformationGridGroupHeader"]}],
         Appearance->None,
         BaseStyle->"InformationGridLink",
         ButtonFunction:>FEPrivate`Set[Typeset`open$$, True],
         Evaluator->Automatic,
         Method->"Preemptive"], True->
        PaneBox[GridBox[{
           {
            ButtonBox[
             RowBox[{
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{12.5, {2.611328125, 9.888671875}}], " ", 
              StyleBox["xAct`SpinFrames`", "InformationGridGroupHeader"]}],
             Appearance->None,
             BaseStyle->"InformationGridLink",
             ButtonFunction:>FEPrivate`Set[Typeset`open$$, False],
             Evaluator->Automatic,
             Method->"Preemptive"]},
           {
            PaneBox[GridBox[{
               {
                ButtonBox[
                 
                 StyleBox["AllDyadComponentsSymmetric", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "AllDyadComponentsSymmetric", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["DefNPTetrad", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DefNPTetrad", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPCommutatorsForward", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPCommutatorsForward", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NPBianchiRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "NPBianchiRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TetradOfDyad", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "TetradOfDyad", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 
                 StyleBox["AutocanonicalizeComponents", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "AutocanonicalizeComponents", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["DefSpinDyad", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DefSpinDyad", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPComponentRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPComponentRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NPCommutatorsBackward", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "NPCommutatorsBackward", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TetradToBasisRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "TetradToBasisRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["BasisToDyadRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "BasisToDyadRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["DummyWS", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DummyWS", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPMatrixOp", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPMatrixOp", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NPCommutatorsForward", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "NPCommutatorsForward", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TetradToDyadRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "TetradToDyadRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["BasisToTetradRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "BasisToTetradRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["DyadComponentByNumber", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DyadComponentByNumber", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPMatrixOpRule", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPMatrixOpRule", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NPComponentRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "NPComponentRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ToGHP", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "ToGHP", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CommuteGHPOp", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "CommuteGHPOp", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["DyadComponentByNumberSymmetric", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DyadComponentByNumberSymmetric", "xAct`SpinFrames`"}, 
                   False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPPrime", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPPrime", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NPRicciRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "NPRicciRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ToNP", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "ToNP", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CommuteNPOp", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "CommuteNPOp", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["DyadComponents", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DyadComponents", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPRicciRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPRicciRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NPSpinCoefficients", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "NPSpinCoefficients", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["VectorsOfTetrad", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "VectorsOfTetrad", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["ComponentMatrix", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "ComponentMatrix", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["DyadExpansionEq", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DyadExpansionEq", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPSpinCoefficients", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPSpinCoefficients", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NPToGHPRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "NPToGHPRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$DyadCalcInfo", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "$DyadCalcInfo", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["ComponentMatrixEqToList", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "ComponentMatrixEqToList", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["DyadIndexFormattingFunction", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DyadIndexFormattingFunction", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPToNPRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPToNPRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["NPToGHPSpinCoeffs", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "NPToGHPSpinCoeffs", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$GHPExtraRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "$GHPExtraRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["ComponentMatrixToList", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "ComponentMatrixToList", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["DyadIndexTexFunction", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DyadIndexTexFunction", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPToNPSpinCoeffs", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPToNPSpinCoeffs", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["SetGHPWeightAndFormatSymmetric", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "SetGHPWeightAndFormatSymmetric", "xAct`SpinFrames`"}, 
                   False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$NPExtraRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "$NPExtraRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CovDDyadRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "CovDDyadRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["DyadToBasisRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "DyadToBasisRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPWeightOf", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPWeightOf", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SetTexComponents", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "SetTexComponents", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$Version", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "$Version", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["CovDsToGHP", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "CovDsToGHP", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["EqListToGHPMatrixEq", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "EqListToGHPMatrixEq", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPWeightRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPWeightRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SortByGHPOrder", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "SortByGHPOrder", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], ""},
               {
                ButtonBox[
                 StyleBox["CovDsToNP", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "CovDsToNP", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["FormatComponents", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "FormatComponents", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["IndexFormattingFunction", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "IndexFormattingFunction", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SpinorsOfDyad", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "SpinorsOfDyad", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], ""},
               {
                ButtonBox[
                 StyleBox["CovDToGHPRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "CovDToGHPRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPBianchiRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPBianchiRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["IndexTexFunction", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "IndexTexFunction", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SymbolFormattingFunction", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "SymbolFormattingFunction", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], ""},
               {
                ButtonBox[
                 StyleBox["CovDToNPRules", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "CovDToNPRules", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["GHPCommutatorsBackward", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "GHPCommutatorsBackward", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["InertScalarOp", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "InertScalarOp", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SymbolTexFunction", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-178a476c-dbdc-4c44-ad98-181482babeaa", {
                   "SymbolTexFunction", "xAct`SpinFrames`"}, False},
                 ButtonNote->"xAct`SpinFrames`",
                 Evaluator->Automatic], ""}
              },
              DefaultBaseStyle->"Text",
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{
                   Scaled[0.19]}}}],
             ImageMargins->{{10, 0}, {0, 2}}]}
          },
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
         FrameMargins->{{0, 0}, {8, 0}}]}, Dynamic[Typeset`open$$],
        ImageSize->Automatic]]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"ColumnsIndexed" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.8]}, 
        Offset[0.2]}}],
   BaseStyle->"InformationTitleFrame"], "InformationGridPlain"]], "Output",
 CellChangeTimes->{3.9561928713430233`*^9, 3.956193828918871*^9, 
  3.97546498315066*^9, 3.9754660254977016`*^9, 3.975467535093473*^9, 
  3.9754679333790483`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"9afe7120-8298-4c3e-97b4-67c300688615"]
}, Open  ]],

Cell["Define an NP tetrad.", "Text",
 CellChangeTimes->{{3.6483506624159307`*^9, 
  3.6483506952559767`*^9}},ExpressionUUID->"ff88e215-fb33-4c90-ae9f-\
f063fa4bf74d"],

Cell[BoxData[
 RowBox[{"DefNPTetrad", "[", 
  RowBox[{"NP", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"lNP", "[", "a", "]"}], ",", 
     RowBox[{"nNP", "[", "a", "]"}], ",", 
     RowBox[{"mNP", "[", "a", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"120945aa-c94e-4c80-a2cc-fcd9db8a1b46"],

Cell["Define the corresponding spin dyad.", "Text",
 CellChangeTimes->{{3.6483506624159307`*^9, 3.6483506952559767`*^9}, {
  3.6483507291760244`*^9, 
  3.648350745956048*^9}},ExpressionUUID->"3860082f-871d-4d6a-98f8-\
07930c1e9733"],

Cell[BoxData[
 RowBox[{"DefSpinDyad", "[", 
  RowBox[{"Dyad", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"o", "[", "A", "]"}], ",", 
     RowBox[{"\[Iota]", "[", "A", "]"}]}], "}"}], ",", "NP"}], "]"}]], "Input",
 CellChangeTimes->{{3.6070931774224405`*^9, 3.6070931911724596`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"7106945c-65d8-4a6d-ac18-b54de85188fd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Components of spinors", "Subsection",
 CellChangeTimes->{{3.6442121408202915`*^9, 
  3.6442121571336946`*^9}},ExpressionUUID->"8b0f61a1-9810-4446-a2d4-\
7b6251a68281"],

Cell["\<\
In this section we show how to expand symmetric spinors into NP components \
using DyadExpansionEq. The command automatically sets the GHP weights of the \
scalars and formats its Tex output. The components are numbered according to \
Penrose&Rindler. This can be disabled in the option FormatComponents.\
\>", "Text",
 CellChangeTimes->{{3.647849145863405*^9, 3.647849203674616*^9}, {
  3.6478492515208597`*^9, 3.6478493582477293`*^9}, {3.6478494044063864`*^9, 
  3.647849435736146*^9}},ExpressionUUID->"9a12cedc-76ea-4f2a-8fa6-\
13ceb3624557"],

Cell["Dyad components of a symmetric (2, 0) - spinor", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
  3.644212606380419*^9, 
  3.6442126071304607`*^9}},ExpressionUUID->"bad3134b-f2c9-4d62-9c49-\
73c776dc510d"],

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"phi20", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<\[Phi]\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6442122937318177`*^9, 3.6442123182175303`*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"8c14b883-adc5-461a-86ac-ee1ff90dcef7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DyadExpansionEq", "[", 
  RowBox[{"phi20", ",", "Dyad"}], "]"}]], "Input",
 CellChangeTimes->{{3.644213261241832*^9, 3.6442132723049216`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"345e29e5-6b87-437f-b3d6-cd20e4c25f45"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", "phi20", 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm[
  "GHP weights for ", $CellContext`phi20, " components are generated, ", 
   "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.975467536002082*^9, 3.975467934339726*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"c93f2859-b83d-4b44-a388-604cceaec883"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "phi20", "\[InvisibleSpace]", "\<\" is expanded into \"\>", "\[InvisibleSpace]",
    "Dyad"}],
  SequenceForm[$CellContext`phi20, " is expanded into ", $CellContext`Dyad],
  Editable->False]], "Print",
 CellChangeTimes->{3.975467536002082*^9, 3.9754679343826027`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"b1ba35bd-6416-4416-88f4-011fb571bb7b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Phi]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`phi20[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False]}]}]}]], "Output",
 CellChangeTimes->{{3.644213266867133*^9, 3.6442132735237384`*^9}, 
   3.644235338926277*^9, 3.644241749966456*^9, 3.6442417980784025`*^9, 
   3.6442419889128513`*^9, 3.6443148992754126`*^9, 3.6443150042055597`*^9, 
   3.644315055995632*^9, 3.64431649015864*^9, 3.6443165394087086`*^9, 
   3.644316712918952*^9, 3.6449398201016417`*^9, 3.6449402784732833`*^9, 
   3.6449403714534135`*^9, 3.6449404464535184`*^9, 3.6450048764517965`*^9, 
   3.645008735641391*^9, 3.645010024093195*^9, 3.645010074023265*^9, 
   3.645010445203784*^9, 3.645010515073882*^9, 3.6450105711039605`*^9, 
   3.6450106424640603`*^9, 3.645010885635401*^9, 3.645011103855706*^9, 
   3.6464533560806704`*^9, 3.647319011988509*^9, 3.6473199092200527`*^9, 
   3.6473283956997805`*^9, 3.6473287912813344`*^9, 3.6473288535714216`*^9, 
   3.6473337100733624`*^9, 3.6477031279963665`*^9, 3.647750762763956*^9, 
   3.647751418512438*^9, 3.6477523480133*^9, 3.6477772598533916`*^9, 
   3.6477907961802273`*^9, 3.6477922505727673`*^9, 3.648183161094535*^9, 
   3.648188497798588*^9, 3.648191670394328*^9, 3.6481933006455507`*^9, 
   3.648209872060214*^9, 3.6482102136228495`*^9, 3.6482640117520204`*^9, 
   3.6482642938905582`*^9, 3.6482651042917004`*^9, 3.648349872603825*^9, 
   3.648350917736288*^9, 3.648352603209648*^9, 3.649172530486464*^9, 
   3.6491726656966534`*^9, 3.7282104723485374`*^9, 3.728793135990346*^9, 
   3.9561928985140285`*^9, 3.9561938300189266`*^9, 3.9754649396648607`*^9, 
   3.97546498437676*^9, 3.975466026431571*^9, 3.975467293541547*^9, 
   3.97546753607377*^9, 3.975467934675372*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"fa502b73-3118-4899-a99d-2c5302a010bc"]
}, Open  ]],

Cell["Formatting can be controlled by the following options", "Text",
 CellChangeTimes->{{3.644213383994172*^9, 3.644213403573374*^9}, {
  3.647779888866557*^9, 
  3.6477798909760413`*^9}},ExpressionUUID->"361c574b-e988-43b4-a4ed-\
7b646fc5cc6e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DyadExpansionEq", "]"}]], "Input",
 CellChangeTimes->{{3.6442133095881643`*^9, 3.6442133162916794`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"43583527-b7e8-4537-891d-c71b47c3771a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SetTexComponents", "\[Rule]", "True"}], ",", 
   RowBox[{"FormatComponents", "\[Rule]", "True"}]}], "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGCwB+Kwq5M5Tqq9djyiMvHkZSBtnrv/1TUg7cF0+AOIFto2
l+M6kJZSylz0C0jffdq2HkQr6zFsA9ENqa6Zv4G0ikhuPojmy5BtBdGTJjUf
1dYA8svP/wPRnlfyuHSAtGXzOWEQ/VWiv9MbSBvd+JLtC6TjfZl5/YB0o4Cj
MIhOa13mCKK11id5gegJS5MDQXSDtn8UiFZYvqUCRN/b/HsyiDbybD7Lp/3a
8eHChpqtOq8d13UtfwOi1Sp1hHYB6TlBL51ANNPsTV4gOjj+8Mo9QPrLeQbu
Qt3Xjpv+Rvh2AOmnTwPmg2ipDw3CnUCayb/GdiqQ/hXednM2kF71PKh/DpDO
a1PJj9Z77SjQZ80VB6Sj5c5OiwfSMSumJyUAafdcpqoMIJ31bssSEL1oQu3L
JiBdX7+PpxlIH70qXASiS5YIX1sDpGc83B6xFkgXbE3TXgekOR/7t9kZvHZ8
McdsOoi2UOd2/X/steN1JoZj0ieA/nG5fOFa5VvHK/UHXa4DaZmksr8z5r11
PJfAyzwTSK+87dcKoiXeblKeBaSn+TI7gegvG68Vg2gAX9fz5w==
  "],
 CellLabel->"Out[22]=",ExpressionUUID->"8c4baf9b-d069-4a69-bfb4-79b593cfee80"]
}, Open  ]],

Cell["\<\
Dyad components of a symmetric (2, 2) - spinor, i.e. a symmetric, trace-free \
2-tensor\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
  3.644212471065132*^9, 3.644212496113346*^9}, {3.6442126018801794`*^9, 
  3.644212602708335*^9}},ExpressionUUID->"f77fabbe-04f6-4c66-96a3-\
3d0ac738fc8e"],

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"g22", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}], ",", 
     RowBox[{"-", "A\[Dagger]"}], ",", 
     RowBox[{"-", "B\[Dagger]"}]}], "]"}], ",", "M4", ",", 
   RowBox[{"GenSet", "[", 
    RowBox[{
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"Cycles", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6442121826633787`*^9, 3.6442122504951286`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"043b86f5-a83f-4888-be81-0a2299cc7332"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DyadExpansionEq", "[", 
  RowBox[{"g22", ",", "Dyad"}], "]"}]], "Input",
 CellChangeTimes->{{3.6442133461057425`*^9, 3.644213346652647*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"8069544f-ba9a-4620-a3c3-8e42e629f1c5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", "g22", 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm[
  "GHP weights for ", $CellContext`g22, " components are generated, ", 
   "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.975467536143269*^9, 3.975467934771652*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"0a521586-f75e-41c5-9371-db227af3b711"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "g22", "\[InvisibleSpace]", "\<\" is expanded into \"\>", "\[InvisibleSpace]",
    "Dyad"}],
  SequenceForm[$CellContext`g22, " is expanded into ", $CellContext`Dyad],
  Editable->False]], "Print",
 CellChangeTimes->{3.975467536143269*^9, 3.975467934803134*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"706bc249-f1bf-4166-9925-f2042279b375"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " ", " ", " "},
          {"A", "B", 
           RowBox[{"A", "'"}], 
           RowBox[{"B", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g22[-$CellContext`A, -$CellContext`B, \
-$CellContext`A\[Dagger], -$CellContext`B\[Dagger]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"22", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      1, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"12", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      1, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"12", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      1, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"02", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}, {
      1, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"21", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"11", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"11", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"01", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"21", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"11", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"11", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"01", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"20", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"10", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"10", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["g", 
       RowBox[{"00", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g22[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}, {0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"B", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`B\[Dagger]],
     Editable->False]}]}]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwVxV1IWmEYAGCjWE5dyx3oJojWQga26KYFwYwvjC3DQY5aM9jMpsyiDjP6
ZQxRlEoyNlZu6w/6wQ3MhWxdVNTVDirYBlvnUEFEmlBfRd2WWe978fDcNbI6
U5pIJKoAW0ZWFlZQovY9ifyDDW2RQx7usq+f4uUPfWIB/rncMn0O7+x7fuCF
xeJF3GbSWi5gubmTxRNShRN/H3f/Vt6n5DwkpPD8nm5JEazY4Bl8r8U7UAM/
diVbtXDWiOzWU9ieXc3gz4QAwWNRVoN/mGutxZMVdXo837fSgw9dZHzC/fWj
0SwlJeIC97tfRZSEBxeO8DS2lFmCg6KzSnxLtazB7Z3R7yvwgvOm9O0DSmYs
Tdp+OGVqmMKTrn5mAM7743g0Aje+8GyOwfyufngcTtyoYhuLKfF6miUv4a68
jdFXMPctaDTAljZZ3xvY1b46ixfKZw/scIYtLnPA5XyZFR/U5fJ+eH54rWEe
Nu9YlQFYEnvuUpVQ8v9E5cX1H5mqK46SiUkxlxui5LVe+Mv3HhNDNacWYEuq
7/Lz5DE5DMjTv8DJ2zonnshZvPcV9t/JrMRrVdsd+DV6lPdl
  "],
 CellLabel->"Out[24]=",ExpressionUUID->"02919828-6030-4a03-be1a-bdca82c8ec5f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Expansion of derivatives into NP and GHP formalism", "Subsection",
 CellChangeTimes->{{3.644124193264351*^9, 
  3.6441242198243523`*^9}},ExpressionUUID->"70705da3-c8b5-4323-b39e-\
6405fd72db66"],

Cell["\<\
In this section we show how to expand derivatives of symmetric spinors into \
NP components using ToNP and ToGHP. For higher derivatives it is most \
convenient to write the operator in terms of fundamental spinor operators and \
let ToGHP expand automatically.\
\>", "Text",
 CellChangeTimes->{{3.647849145863405*^9, 3.647849203674616*^9}, {
  3.6478492515208597`*^9, 3.6478493582477293`*^9}, {3.6478494044063864`*^9, 
  3.647849435736146*^9}, {3.647849501145808*^9, 3.6478495508742285`*^9}, {
  3.6478495976849413`*^9, 3.6478496005757165`*^9}, {3.6478508080273924`*^9, 
  3.647850862552681*^9}, {3.6478509328844776`*^9, 
  3.6478509332438693`*^9}},ExpressionUUID->"9ae00cec-ef7c-451f-bf02-\
c5077c3bed81"],

Cell["\<\
Dyad components of the gradient of a valence (0, 0)-spinor, i.e. a scalar \
function\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
  3.644212606380419*^9, 3.6442126423058653`*^9}, {3.6478495604059772`*^9, 
  3.647849587137516*^9}},ExpressionUUID->"2678d8b0-c4a4-4ba0-8b66-\
60ab30659557"],

Cell[BoxData[
 RowBox[{"DefSpinor", "[", 
  RowBox[{
   RowBox[{"chi00", "[", "]"}], ",", "M4", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<\[Chi]\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6442107378497305`*^9, 3.644210752506796*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"7ca20b4f-176d-4874-8175-39080dd896b0"],

Cell["In NP formalism:", "Text",
 CellChangeTimes->{{3.64421271166466*^9, 3.64421272521229*^9}, {
  3.6442127757462416`*^9, 
  3.6442127765119057`*^9}},ExpressionUUID->"2f9b7e24-e532-475c-9720-\
2bcdc126443f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "[", 
  RowBox[{"chi00", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6441278038803496`*^9, 3.644127818162369*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"5f7f2316-5b86-4ee7-b51b-3c324de2136e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", 
     RowBox[{"AA", "'"}], "  "], "\[Chi]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
   $CellContext`chi00[]],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.644127818771744*^9, 3.6441278757278175`*^9, {3.6441280633426657`*^9, 
   3.6441280693429956`*^9}, 3.6441284392255573`*^9, 3.644128517329858*^9, 
   3.644207353993077*^9, 3.6442126604275446`*^9, 3.644212737259777*^9, 
   3.6442127782775965`*^9, 3.644235351317565*^9, 3.644236762024289*^9, 
   3.6442417503727274`*^9, 3.6442417985003023`*^9, 3.6442419892409954`*^9, 
   3.6443148993454127`*^9, 3.64431500448556*^9, 3.6443150562656326`*^9, 
   3.6443164904286404`*^9, 3.6443165396887093`*^9, 3.644316713198952*^9, 
   3.6449398203816423`*^9, 3.644940278773284*^9, 3.644940371743414*^9, 
   3.6449404467335186`*^9, 3.645004876741797*^9, 3.645008735901391*^9, 
   3.6450100244031954`*^9, 3.645010074303265*^9, 3.6450104454837847`*^9, 
   3.6450105155138826`*^9, 3.6450105713839607`*^9, 3.645010642674061*^9, 
   3.645010885905401*^9, 3.645011104175707*^9, 3.6464533567681265`*^9, 
   3.6473190123791547`*^9, 3.647319909548194*^9, 3.647328414559807*^9, 
   3.647328791541335*^9, 3.647328853871422*^9, 3.647333710450616*^9, 
   3.647703128324585*^9, 3.6477507630681615`*^9, 3.6477514187937036`*^9, 
   3.647752348290484*^9, 3.6477772601346593`*^9, 3.6477907964754252`*^9, 
   3.6477922508699656`*^9, 3.648183162235217*^9, 3.6481884996580544`*^9, 
   3.6481916706912193`*^9, 3.648193302145631*^9, 3.64820987241961*^9, 
   3.6482102139666185`*^9, 3.648264013314599*^9, 3.648264295328133*^9, 
   3.648265106057412*^9, 3.648349872873825*^9, 3.6483509180062885`*^9, 
   3.6483526036096487`*^9, 3.649172537906474*^9, 3.649172665986654*^9, 
   3.7282104726434016`*^9, 3.728793136289363*^9, 3.9561929140032024`*^9, 
   3.9561938302164*^9, 3.975464939910042*^9, 3.975464984600967*^9, 
   3.975466026604941*^9, 3.975467293771307*^9, 3.975467536259956*^9, 
   3.975467934888529*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"a1e68fc5-df80-4d23-b513-7904abce78b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "==", 
  RowBox[{"ToNP", "[", 
   RowBox[{"%", ",", "Dyad"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6442073583995614`*^9, 3.6442073603996983`*^9}, {
  3.6442126618651533`*^9, 3.644212662318304*^9}, {3.6442127344627852`*^9, 
  3.6442127444632864`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"752a8ca4-9603-4f49-a840-17b8032ae9a5"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[EmptyDownTriangle]", 
      RowBox[{"AA", "'"}], "  "], "\[Chi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
    $CellContext`chi00[]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"D", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDNP[{1, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[CapitalDelta]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDNP[{2, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Delta]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDNP[{3, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Delta]", "_"], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDNP[{4, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}]}]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwVzVtIk3Ech/FpYDoPmGs3JeKQljGz3RReeNh/vZIsZhYpMscWr00Si+WB
sUxUDHUbWUO01CRBChQ8MXGQGPPGqYloOTYVE0UI6+2VghJJVn1/Fw+fy0fB
W29ZIiQSCYeMHxSpfqXAHJe2vAuwaZWbJW28ZY7cGY5aWoPcteLHAdgsrn0L
wsbIjz/IXO9QdAi6zFWDf6C9yT1OfkmL8ZJXyworj6Fv1GYlhyLOt5Kazadz
qnSBdfEbf8m9B3ZpBgwkr8tIt6fHeR3+Xg5X6eGqKz6+EKpLdTJSfDjByE55
tY7ME+/fJH2XSwzkXv97O6nsjuoi7271LieoBJY02NEwlSGwFZfnO6n+tS+b
hnWHP7Vk7fqMjhSXVoZn4JnJ2NjqiwLT6cv1DiitMAyQJt4lc0Lljbacbmix
uTdewe2w8Xk/PPRcSXkHE08WWcsyBbb7rF5qgs6U0AszTLqwyN+BNWJC/T3o
OPC9IbWnxr+2wFTJQdwTWFmSX0Nm9SUHR6AxNFs6CuXKOtUYHHub056rFphh
U/OSPOLk+f/8AsvOkvrPLuC/rfkUfCSywO48F4KKzsZwz2uR7dhOn+iFHebb
rWTFuem0PmgqiNGSBcWfa8n/RdIKVg==
  "],
 CellLabel->"Out[27]=",ExpressionUUID->"990f6a3d-2097-443b-abe6-b23aa79fd657"]
}, Open  ]],

Cell["\<\
In GHP formalism (no difference because the scalar is unweighted):\
\>", "Text",
 CellChangeTimes->{{3.644212699492135*^9, 3.644212729743782*^9}, {
  3.644212911747475*^9, 
  3.644212947030611*^9}},ExpressionUUID->"0593c97f-5698-4bf6-b8a7-\
ba0a0b64495b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "[", 
  RowBox[{"chi00", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6441278038803496`*^9, 3.644127818162369*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"9ce52abb-ca84-465e-aced-bbbb3494ba2b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", 
     RowBox[{"AA", "'"}], "  "], "\[Chi]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
   $CellContext`chi00[]],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.644127818771744*^9, 3.6441278757278175`*^9, {3.6441280633426657`*^9, 
   3.6441280693429956`*^9}, 3.6441284392255573`*^9, 3.644128517329858*^9, 
   3.644207353993077*^9, 3.6442126604275446`*^9, 3.6442127740898695`*^9, 
   3.644235354348975*^9, 3.6442367640088024`*^9, 3.644241750716496*^9, 
   3.6442417985471773`*^9, 3.644241989303496*^9, 3.6443148993654127`*^9, 
   3.64431500451556*^9, 3.6443150562956324`*^9, 3.64431649045864*^9, 
   3.644316539718709*^9, 3.6443167132289524`*^9, 3.644939820411642*^9, 
   3.6449402788032837`*^9, 3.6449403717734137`*^9, 3.644940446763519*^9, 
   3.645004876781797*^9, 3.645008735941391*^9, 3.645010024433195*^9, 
   3.6450100743332653`*^9, 3.6450104455237846`*^9, 3.645010515543883*^9, 
   3.6450105714039607`*^9, 3.6450106427040606`*^9, 3.645010885935401*^9, 
   3.645011104215707*^9, 3.6464533568291674`*^9, 3.647319012457284*^9, 
   3.647319909595072*^9, 3.6473284164698095`*^9, 3.647328791571335*^9, 
   3.647328853911422*^9, 3.647333710516659*^9, 3.647703128388628*^9, 
   3.647750763122197*^9, 3.647751418856206*^9, 3.6477523483425198`*^9, 
   3.6477772602127876`*^9, 3.647790796534465*^9, 3.6477922509240007`*^9, 
   3.6481831625321074`*^9, 3.648188499954945*^9, 3.648191670738096*^9, 
   3.648193302348769*^9, 3.64820987248211*^9, 3.648210214013494*^9, 
   3.6482640135333595`*^9, 3.648264295500017*^9, 3.648265106229303*^9, 
   3.6483498729038258`*^9, 3.6483509180362887`*^9, 3.6483526036396484`*^9, 
   3.649172537936475*^9, 3.6491726660266542`*^9, 3.728210472664669*^9, 
   3.7287931363303657`*^9, 3.95619291405204*^9, 3.956193830262251*^9, 
   3.9754649399904013`*^9, 3.975464984679164*^9, 3.975466026668613*^9, 
   3.9754672938656187`*^9, 3.975467536320661*^9, 3.9754679349454613`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"1f670eca-8e83-4e66-b42f-cae256f89ce3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "==", 
  RowBox[{"ToGHP", "[", 
   RowBox[{"%", ",", "Dyad"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6442073583995614`*^9, 3.6442073603996983`*^9}, {
  3.6442126618651533`*^9, 3.644212662318304*^9}, {3.6442127469009485`*^9, 
  3.6442127498229485`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"6e48f112-c58b-4a48-9e1b-0fbf732d9406"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[EmptyDownTriangle]", 
      RowBox[{"AA", "'"}], "  "], "\[Chi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
    $CellContext`chi00[]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}]}]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwVzl1IU3Ech/GlkLL5BgtD1HCKMj0ru1K80PwfU2wyYxIq5RtqkqhMTSst
ZJwUJxnzvWxhsGKoZKHW0Jja0I2VqGV51DAiuqrjJOzOSPv+Lh4+t4+q3JB3
9ZhMJstARe9VUe44iZkSd+weaC37ukTyXO3yJxibPXj7M5zyfv8lwgFh/TfJ
28f9N+GNyRrrAcyN6X1JjoXJ7eRx/cXqv1B4etNA5l9Qd5C+H+67OLXEMsa/
HJK2iha5BgqV20oyb3S4KwfOLB7W6GC/MSgwF+7rcpSkZWaSkenFjVrS50ed
nhS4gsukrW/+Frmx4zdApnosK0GcxEKt5juvNRIT5a92SZc97sQbmLy7z5NJ
q3NaMtHzccwB3y4EKhpOS8x5VKkzwZCqoiekf1a3sgsmrHWmDsJzKX3bFqga
LTE/hgu1zqhZmLV3yXDljMT8gtvlJdA4sjVUCqPj18rLYKs3pPUa7NlzPiOb
eh0/BZhk/BNwF7aJ2kbywBwpPoenVpyFE3ArvJl7AestaZ1pZ/ETzT8gI+pC
M4/c+DAp3OEeiTna+HWxxcua1O/Ob0KXRvj3cMTLpmNP+g7D5Hv5HWSVfi7m
EbQVK3iyueDbdfI/xAUEog==
  "],
 CellLabel->"Out[29]=",ExpressionUUID->"aea11796-28e2-4a3c-ac86-2d8c1e876fa7"]
}, Open  ]],

Cell["\<\
Alternatively using the fundamental spinor operator from the SymManipulator \
package:\
\>", "Text",
 CellChangeTimes->{{3.6442127872624493`*^9, 3.6442128078885827`*^9}, {
  3.6478496162171583`*^9, 
  3.6478496307022886`*^9}},ExpressionUUID->"5be7da25-22a4-4f87-abd5-\
d423f295868a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TwistCDe", "[", "chi00", "]"}], "//", 
  "GiveIndicesToTensor"}]], "Input",
 CellChangeTimes->{{3.6442107543818636`*^9, 3.644210763007358*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"3496c739-7e1a-48d1-95f6-cc736fb9ec33"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{
       SubsuperscriptBox["\[ScriptCapitalT]", 
        RowBox[{
         TagBox["0",
          DisplayForm], ",", 
         TagBox["0",
          DisplayForm]}], ""], "\[Chi]"}], 
      StyleBox[GridBox[{
         {" ", " "},
         {"A", 
          RowBox[{"A", "'"}]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TwistCDe[$CellContext`chi00][-$CellContext`A, -$CellContext`A\
\[Dagger]],
  Editable->False]], "Output",
 CellChangeTimes->CompressedData["
1:eJwV0VtI0wEYBfDFXmStlcykMMULiGvThMQHW+J/KAzdvGE67zJQkslGG5KW
iUzEC0PbJbMpDqcv0kzzFkQsDLwhQ5pjYz6IlV3XfxjSi3npfA8fP855OC9f
glpX2niBw+Hk4uRSw+Z6cogJOJNmNuCN8tNtkuua2NqBquk7PnJdvvLYBxfY
z7/80Gb0HpLyzJcRAajmtjiPYVareZa0aXjL5B9nUfM/aJx8qCMHA/NtZBqb
0kOGEwZXxSnIJ7tnpGWpnSeB2uWgkLypsPcXwMmr5xol7PQKLhXCPUeBkNTX
zDNkTq0+nwxnaEtI1XZFFWk5cLeRrq4IG5n8fcwjEIeY64nmjiUJdgYWf5O3
YpVRb6Hg6ZGMTIx355M/TN7pd9BlElx8kBpiiq2Nyj54panWQdYdm4T9UFLU
d/cZbPpqCY7CKEX90BiUhu/pqtPgZSuvDhrHg8P18Lboo7oBPmEjH92HVu2H
KXLO7PlphFldf/nd0F6u0JPfPsX6XTDOs6KagbPvW8WvYA2b3ZudHmKODLLn
ZBwbnXe+hl7KX4vZwB9Eb7z+dpYZOdjMDcC5su7TkXGWed1yjfsCmu0VPeTi
F3eSHeZU8mUkX7lvIP8DsAYOFA==
  "],
 CellLabel->"Out[30]=",ExpressionUUID->"00b23cc2-bf37-4427-82e4-d28c6b7ef146"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "==", 
  RowBox[{"ToGHP", "[", 
   RowBox[{"%", ",", "Dyad"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.644210765163697*^9, 3.644210767585726*^9}, {
  3.644212582879133*^9, 3.644212583316658*^9}, {3.64423537824091*^9, 
  3.6442353815848093`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"ad35812b-ecbc-435b-8ea6-068c84c58812"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", 
   RowBox[{"TwistCDe", "[", "chi00", "]"}], 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm["GHP weights for ", 
   $CellContext`TwistCDe[$CellContext`chi00], " components are generated, ", 
   "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9754675364189587`*^9, 3.975467935040113*^9},
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"44c9788e-59e2-4e07-b966-245f6208d933"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"TwistCDe", "[", "chi00", "]"}], 
   "\[InvisibleSpace]", "\<\" is expanded into \"\>", "\[InvisibleSpace]", 
   "Dyad"}],
  SequenceForm[
   $CellContext`TwistCDe[$CellContext`chi00], 
   " is expanded into ", $CellContext`Dyad],
  Editable->False]], "Print",
 CellChangeTimes->{3.9754675364189587`*^9, 3.975467935048698*^9},
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"3451a9fa-688f-4cb8-b09e-6e83a56ca558"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", "chi00", 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm[
  "GHP weights for ", $CellContext`chi00, " components are generated, ", 
   "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9754675364189587`*^9, 3.975467935073532*^9},
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"8e06eb6f-4599-4158-a14f-915a9cf0fecd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating the \"\>", "\[InvisibleSpace]", "Dyad", 
   "\[InvisibleSpace]", "\<\"components of \"\>", "\[InvisibleSpace]", 
   RowBox[{"TwistCDe", "[", "chi00", "]"}], 
   "\[InvisibleSpace]", "\<\" in GHP form. (Improved code)\"\>"}],
  SequenceForm["Calculating the ", $CellContext`Dyad, "components of ", 
   $CellContext`TwistCDe[$CellContext`chi00], " in GHP form. (Improved code)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9754675364189587`*^9, 3.9754679350791388`*^9},
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"0dee7071-87f4-4a4d-9632-18df42baaa90"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalT]", 
         RowBox[{
          TagBox["0",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], ""], "\[Chi]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`TwistCDe[$CellContext`chi00][-$CellContext`A, -$CellContext`A\
\[Dagger]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}]}]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwVyl1Ik2EYgOFlCLG1UVtJMBGtGdHWUPJAiAnv0BjLOVKbMUVrUm5kfbWB
OJuykqHWYAjzL92MTZBFToP8wIxgweawCfa3UbE8CAT3OpFhWCut5zm4uU7u
IgNTe+MAh8OphIwVguWl05SU+hUzUbBHd2IVtZ9fWvkIXiHCb+hO9U/bJ3D1
dioVBz05X7fRenb2UAKU/G73ZUF91j2Lvtzms+hfa53pD+jsus+gU47lTrTa
LHOggunBsPQMJTUPvu+jlpIergx0XkiKUNV7z8AlMLiZ064BHwWE/BpwT6IV
ofUJlqDqsg41+otnvow+ndPr0TnT206UbTjsRpOxZysCKSVnfUO2eRklG9yF
TfQde/PYK1B+fFeJynZDarTQkgi8Bt9EhLx75yiJPjZp+sGT69cn0c/iQdEA
WK51KoZARjXyZRzMdLe6JsC7W61Mo5ySOy4/txl0FiSHW8DmwJrhGuhK53UZ
Qe9WZAotFmY2HoI2ey6/F3yhazKjuW1F8eegojZ8dQZcGLZKg/iZlX0VJZSk
Ji6OoHKxpOpfhJKYKi8ijlJSZlz8ELemib0wVpkAs7f69ka9aaIL5x8cA9eP
NjpQgyh06gmoZI4o0R39Dwv6H1LiDSg=
  "],
 CellLabel->"Out[31]=",ExpressionUUID->"5672fd0f-000a-44a5-ae49-d7f303474c50"]
}, Open  ]],

Cell["The Dyad components :", "Text",
 CellChangeTimes->{{3.644212833514922*^9, 
  3.644212851994282*^9}},ExpressionUUID->"dd803938-1c9f-46dd-a595-\
65e206535734"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DyadComponents", "[", 
  RowBox[{"%", ",", "Dyad"}], "]"}]], "Input",
 CellChangeTimes->{{3.644127890619211*^9, 3.6441278967133083`*^9}, {
  3.6442128578852215`*^9, 3.6442128612760277`*^9}, {3.644316610548808*^9, 
  3.644316611178809*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"29bfe620-e4d1-4f16-b672-8d91f88a85e1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox[
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalT]", 
         RowBox[{
          TagBox["0",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], ""], "\[Chi]"}], 
       RowBox[{"00", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TwistCDe[$CellContext`chi00][{0, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Thorn]", "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
      $CellContext`chi00[]],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox[
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalT]", 
         RowBox[{
          TagBox["0",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], ""], "\[Chi]"}], 
       RowBox[{"01", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TwistCDe[$CellContext`chi00][{0, -$CellContext`Dyad}, {
      1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Eth]", "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
      $CellContext`chi00[]],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox[
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalT]", 
         RowBox[{
          TagBox["0",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], ""], "\[Chi]"}], 
       RowBox[{"10", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TwistCDe[$CellContext`chi00][{1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{"\[Eth]", "'"}], "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
      $CellContext`chi00[]],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox[
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalT]", 
         RowBox[{
          TagBox["0",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], ""], "\[Chi]"}], 
       RowBox[{"11", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TwistCDe[$CellContext`chi00][{1, -$CellContext`Dyad}, {
      1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Equal]", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{"\[Thorn]", "'"}], "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
      $CellContext`chi00[]],
     Editable->False]}]}], "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBwBGKPy3LB89VeO/KHO144AaTjD4rdvgykz7199eoakN7Q
dPcDiI4y28BxHUg3dOQv+gWkDeZNXQ+iu6fwbQPRl2VDMn8D6RS5mnwQfYzr
XQWI5s/QbQXRT7wmHdXWeO2oonr/H4j2ulLHpQOkU+7fFQbRCqXzOr2BdMEj
5hxfIJ3gK8zrB6SvnPAXBtFa1dsdQbTijTIvEH1hfVEgiK4IiY4C0R28hytA
dN9vnikgegLPmrN82q8ddRZNq9mq89rxHdeuNyB6s+FmkV1AmmXndycQLeF5
yAtEX9l0Y+UeIH1LTIS7UPe1Y/2iLN8OIK32LGk+iI7QmiTcCaRt/HttpwLp
Ew/m3ZwNpIWWpvTPAdJN79Lzo/WA4dO/kisOSE+dd29aPJCes/JjUgKQnvRW
vCoDSC9+d3wJiA6Y9PtlE0i8gYe3GUjfC0svAtF3uJSurQHSIt+ORqwF0hOs
qrTXAekgMed2O4PXjmsmuU8H0QsuqLj+P/ba8auf+DHpE0D/T9tz6VrlW8cY
0bMu14F0xcyOvzPmvXXsYZdjngmkVeRjWkG0Qu8h5VlA+kehoBOIdnR7Ugyi
AeP1/qs=
  "],
 CellLabel->"Out[32]=",ExpressionUUID->"9a2d18c4-d6e0-4083-9c80-7211b89b63e5"]
}, Open  ]],

Cell["The GHP weight of the scalar can be changed manually :", "Text",
 CellChangeTimes->{{3.6442129759071245`*^9, 
  3.644213033890293*^9}},ExpressionUUID->"7deff96b-839a-4046-bfbd-\
fb4d0afb95bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GHPWeightOf", "[", 
   RowBox[{"chi00", "[", "]"}], "]"}], "^=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.644127922058338*^9, 3.644127944918902*^9}, {
   3.644128057061123*^9, 3.6441280575767736`*^9}, {3.6441280922973223`*^9, 
   3.6441280988601294`*^9}, 3.6441284314937067`*^9, {3.644128485070242*^9, 
   3.644128512626525*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"9d9b91d7-ec89-4a1b-80c6-233ee4be10b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.6441279362778234`*^9, 3.644127945512678*^9}, {
   3.644128019824789*^9, 3.6441280582174025`*^9}, {3.6441280947661667`*^9, 
   3.644128099375814*^9}, 3.6441281516592803`*^9, 3.644128259546337*^9, 
   3.644128434103213*^9, {3.6441284854921036`*^9, 3.6441285139703074`*^9}, 
   3.6442129712193775`*^9, 3.644213048391038*^9, 3.6442417513727827`*^9, 
   3.6442417989534492`*^9, 3.6442419895378838`*^9, 3.644314899495413*^9, 
   3.64431500468556*^9, 3.6443150564556327`*^9, 3.6443164906386404`*^9, 
   3.64431653987871*^9, 3.6443166210088234`*^9, 3.644316713428952*^9, 
   3.644939820581642*^9, 3.644940278983284*^9, 3.6449403719734144`*^9, 
   3.644940446943519*^9, 3.645004876961797*^9, 3.6450087361313915`*^9, 
   3.645010024603195*^9, 3.645010074493265*^9, 3.645010445743785*^9, 
   3.6450105157238827`*^9, 3.6450105715939612`*^9, 3.6450106428640614`*^9, 
   3.6450108861054015`*^9, 3.645011104415707*^9, 3.646453357397547*^9, 
   3.6473190127385516`*^9, 3.6473199098294573`*^9, 3.647328422759818*^9, 
   3.647328791741335*^9, 3.6473288540814223`*^9, 3.647333710793845*^9, 
   3.647703128649802*^9, 3.6477507633493476`*^9, 3.647751419121846*^9, 
   3.6477523485846806`*^9, 3.6477772604315476`*^9, 3.647790796984954*^9, 
   3.6477922511631613`*^9, 3.6481831632947383`*^9, 3.6481885018456755`*^9, 
   3.6481916709724846`*^9, 3.6481933036457133`*^9, 3.648209872779004*^9, 
   3.648210214263508*^9, 3.648264015955361*^9, 3.6482642964531984`*^9, 
   3.6482651072762303`*^9, 3.6483498730638256`*^9, 3.648350918196289*^9, 
   3.6483526038396487`*^9, 3.6491725380964746`*^9, 3.6491726662466545`*^9, 
   3.7282104731661234`*^9, 3.7287931367463894`*^9, 3.956192928129965*^9, 
   3.956193830414871*^9, 3.975464940304977*^9, 3.975464984979803*^9, 
   3.975466026912109*^9, 3.975467294184304*^9, 3.975467536576861*^9, 
   3.975467935163599*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"b8b3c067-c206-4a86-b487-dd19ca4cda72"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDe", "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "[", 
  RowBox[{"chi00", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6441278038803496`*^9, 3.644127818162369*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"531d3b64-c5d4-47fe-b782-945a7c3c0bdd"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[EmptyDownTriangle]", 
     RowBox[{"AA", "'"}], "  "], "\[Chi]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
   $CellContext`chi00[]],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.644127818771744*^9, 3.6441278757278175`*^9, {3.6441280633426657`*^9, 
   3.6441280693429956`*^9}, 3.6441284392255573`*^9, 3.644128517329858*^9, 
   3.644207353993077*^9, 3.6442126604275446`*^9, 3.6442127740898695`*^9, 
   3.6442130797989664`*^9, 3.6442417514040337`*^9, 3.644241798969075*^9, 
   3.6442419895535097`*^9, 3.644314899495413*^9, 3.6443150046955605`*^9, 
   3.644315056465633*^9, 3.6443164906486406`*^9, 3.6443165398887095`*^9, 
   3.6443166220088243`*^9, 3.644316713428952*^9, 3.644939820581642*^9, 
   3.644940278983284*^9, 3.6449403719834146`*^9, 3.644940446943519*^9, 
   3.645004876971797*^9, 3.6450087361313915`*^9, 3.6450100246131954`*^9, 
   3.6450100745032654`*^9, 3.645010445753785*^9, 3.6450105157238827`*^9, 
   3.6450105715939612`*^9, 3.645010642874061*^9, 3.6450108861154013`*^9, 
   3.645011104415707*^9, 3.6464533574165597`*^9, 3.647319012754174*^9, 
   3.6473199098607125`*^9, 3.6473284234998198`*^9, 3.647328791751335*^9, 
   3.647328854091422*^9, 3.6473337108158593`*^9, 3.647703128671817*^9, 
   3.6477507633663607`*^9, 3.647751419137472*^9, 3.6477523486006913`*^9, 
   3.647777260447176*^9, 3.6477907970034733`*^9, 3.6477922511811733`*^9, 
   3.6481831635134993`*^9, 3.648188501970681*^9, 3.6481916709881096`*^9, 
   3.6481933037082143`*^9, 3.6482098728415036`*^9, 3.648210214279135*^9, 
   3.6482640160491157`*^9, 3.648264296500082*^9, 3.6482651073387356`*^9, 
   3.648349873073826*^9, 3.648350918196289*^9, 3.6483526038496485`*^9, 
   3.649172538106475*^9, 3.6491726662566543`*^9, 3.7282104731661234`*^9, 
   3.7287931367633905`*^9, 3.9561929281578903`*^9, 3.956193830441799*^9, 
   3.975464940342181*^9, 3.975464985061019*^9, 3.975466026946138*^9, 
   3.975467294228545*^9, 3.975467536609582*^9, 3.975467935194291*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"1ad96056-9763-4c17-a2a6-874c995aae42"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "==", 
  RowBox[{"ToGHP", "[", 
   RowBox[{"%", ",", "Dyad"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6442073583995614`*^9, 3.6442073603996983`*^9}, {
  3.6442126618651533`*^9, 3.644212662318304*^9}, {3.6442127469009485`*^9, 
  3.6442127498229485`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"c78fe0eb-92f5-4a56-8115-769ce766d650"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[EmptyDownTriangle]", 
      RowBox[{"AA", "'"}], "  "], "\[Chi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
    $CellContext`chi00[]],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`chi00[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Gamma]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Gamma]Dyad[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`chi00[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Gamma]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Gamma]Dyad\[Dagger][],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`chi00[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Alpha]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Alpha]Dyad\[Dagger][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`chi00[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Beta]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Beta]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`chi00[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Alpha]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Alpha]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`chi00[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Beta]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Beta]Dyad\[Dagger][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`chi00[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Epsilon]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Chi]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`chi00[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Epsilon]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Epsilon]Dyad\[Dagger][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}]}]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwdxW0o43EcAPAdF3cTTbtRnDqtOM3hlXRF/Xa7F7bcebiWw7FbboduzZCQ
NOfGFuWmeRp2+ecFYlN2/3JHJBuWxQtNate1N+fhx/ICeQj3/Xrx6ROv1OR/
esDhcMSgxB3/zJVAiSHVx67BjOLPCj5giqX4qfr00As7gvwneDk7+2gHlrRU
M1cwa+y34zwdj8UlxfLKa3j/cYsGr/aENeHmglQ9XpVudoqeUzLJ89/ivyNb
ucnwgfsvH29+OGqUwR5tyJcc+F+GIPwN/N6Rx8dnVHME7xE0SvF3Q3V5+L7p
QxF+IXU24Py9CPP9s3ZPhIiSLMbS/DOZkjPuwhE+PBUq+AVb8y/FuKF9RYp3
fvRNzMNLY9Fh2heUvJpW5xjgFJXqB972tJdvhGVvv2f2wnUvmd0h2Lr1uXsY
dgTqNcUplAS6V7ml8IjV31cGLyfdKhUwo45rqoBtAfcYruvhHn6FJ3RR4W3w
lVxbgyvPhd4p2OJfLZyGZxb1Iht8ZJd0ZKVREreV3Y87chNf37ng6BhX7Bol
3/Qh297GY7JRuSnZgeWjXTcD1mOyLhMGD8I+U5ketwSvCy3wOPtEjHsL92rx
/9X/B74=
  "],
 CellLabel->"Out[35]=",ExpressionUUID->"79c400b8-cd4c-403c-9882-98dde156dfee"]
}, Open  ]],

Cell["\<\
Dyad components of the spin-1 field equation, i.e. vacuum Maxwell equations\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
  3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
  3.644213159334499*^9}},ExpressionUUID->"fa448cd9-8113-4a1d-ad67-\
611b4cd5b09f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], "[", 
   RowBox[{
    RowBox[{"-", "A"}], ",", 
    RowBox[{"-", "A\[Dagger]"}]}], "]"}], "\[Equal]", "0"}]], "Input",
 CellChangeTimes->{{3.644213442997327*^9, 3.6442134561543107`*^9}, {
  3.6442135157668715`*^9, 3.6442135223922253`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"7ce82fa0-61b6-4e5f-8bc7-79089b5affb8"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalC]", 
         RowBox[{
          TagBox["2",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], "\[Dagger]"], "\[Phi]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", 
           RowBox[{"A", "'"}]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CurlDgCDe[$CellContext`phi20][-$CellContext`A, \
-$CellContext`A\[Dagger]],
   Editable->False], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBwBGKmAgGpk2qvHVV7E5VA9K+3315dA9J7mh5+ANF527Zw
XAfSLnUFi34B6UW3p68H0X8uCmwD0QZrwzJ/A+kXnHX5ILoq/WwdiM75rt8K
osM6phzV1njtODXp4T8QPWlrI5cOkL4i80AYRGeELez0BtI7DrPl+ALpS12i
vH5A2oUtSBhEz9mx0xFE16VXeoFoh7clgSD6gGlcFIh+MudoBYj+Z8E/BURP
fLXhLJ/2a8egRXNqtuq8dvzdtfcNiHaT9RXdBaS7lvx0AtEdbUe8QLRW3r2V
e4C03iVJ7kLd144innm+HUDaOC19PogW3DBVuBNIe/tPtJ0KpN/fXXRzNpD2
c8jrnwOkj7yryI/We+34g/8MVxyQPlf3bFo8kD6kyZCcAKRX5cpVZQDpDXmn
l4Dojkn8r5qA9LoGCd5mIM0aXlwEon09VK6tAdKzHh6PWAukzVa3a68D0jcY
XdvtDF47cih5TQfRBm0arv+PvXbcd1jqmPSJ144Bs9mvXKt86xihVsB1HUhn
3DnvAqK9n/X+nTHvrWNTjQrzTCC9rS+hFUQ/UTytPAtIf58n6gSieUpeFINo
ACnN/9g=
  "],
 CellLabel->"Out[36]=",ExpressionUUID->"e5ef187b-48df-4813-80e1-d1ce64fb88c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToGHP", "[", 
  RowBox[{"%", ",", "Dyad"}], "]"}]], "Input",
 CellChangeTimes->{{3.644213458763792*^9, 3.644213464529729*^9}, {
  3.644213525111124*^9, 3.6442135252830057`*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"53ff91ba-eb31-4c06-9fa1-16bf8eeac025"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", 
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm["GHP weights for ", 
   $CellContext`CurlDgCDe[$CellContext`phi20], " components are generated, ", 
   "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.975467536707953*^9, 3.975467935290174*^9},
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"8321e392-fb7a-4c6e-8df5-295b6801286c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], 
   "\[InvisibleSpace]", "\<\" is expanded into \"\>", "\[InvisibleSpace]", 
   "Dyad"}],
  SequenceForm[
   $CellContext`CurlDgCDe[$CellContext`phi20], 
   " is expanded into ", $CellContext`Dyad],
  Editable->False]], "Print",
 CellChangeTimes->{3.975467536707953*^9, 3.9754679352984743`*^9},
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"3e7fc049-2b6b-41f5-a1a9-f760b9c0abce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating the \"\>", "\[InvisibleSpace]", "Dyad", 
   "\[InvisibleSpace]", "\<\"components of \"\>", "\[InvisibleSpace]", 
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], 
   "\[InvisibleSpace]", "\<\" in GHP form. (Improved code)\"\>"}],
  SequenceForm["Calculating the ", $CellContext`Dyad, "components of ", 
   $CellContext`CurlDgCDe[$CellContext`phi20], 
   " in GHP form. (Improved code)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.975467536707953*^9, 3.975467935323276*^9},
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"3b3b2a49-a0d2-4554-bf84-63c3241057d7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       SubscriptBox["\[Phi]", "2"],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
      Editable->False]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]Dyad[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Kappa]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]pDyad[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Rho]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad[],
     Editable->False]}], "+", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Rho]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad[],
     Editable->False]}], "-", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Rho]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Rho]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Sigma]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]Dyad[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Sigma]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]pDyad[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Tau]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad[],
     Editable->False]}], "-", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Tau]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad[],
     Editable->False]}], "+", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Tau]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Tau]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        SubscriptBox["\[Phi]", "2"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], 
        SubscriptBox["\[Phi]", "0"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        SubscriptBox["\[Phi]", "2"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Iota]", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota][-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        SubscriptBox["\[Phi]", "0"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"o", 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`o[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBwBGK2EjPpk2qvHVX6vyiBaIl3/15dA9Knmp5/ANFTth3k
uA6k2UoKF/0C0n26C9aD6D8XJbaBaI7A+MzfQPpqdFs+iJ4g+rYOREd4WrSC
aD2duUe1NV47Tkt6+Q9E17F3cekA6asyL4RBdMiKlZ3eQLpmJ3+OL5Ded0eW
1w9Iu7FFCYPoDq5DjiBaZ32TF4h2fFsTCKKvPE6NAtGTnpyrANGvusSngOiC
qCNn+bRfO6YpLa/ZqvPaUar7+BsQzWiTJboLSHctYXQG0SU3zniB6P3PXqzc
A6SNHihzF+q+dnSfVO7bAaRDnhXMB9EKzvOFO4F0xfl5tlOB9Jt9a27OBtLv
RCr65wBpvfyZ+dF6rx2LJrznigPSH/69nxYPpFO19JMTgPS5txpVGUD6St7V
JSBaaLL5qyYgbXXUmrcZSJeHTysC0X4eOtfWAOlZD89HrAXSZqv7tdcB6RuM
vu12Bq8dOZWCpoNopncGrv+PvXbsYdc6Jn0C6C5W7ivXKt86/ulazXUdSN9J
vOQCoh8mTPo7Y95bx1NvNJhnAmkBhZRWEH3E56zyLCB9NEzGCURPaH9dDKIB
iBf/VA==
  "],
 CellLabel->"Out[37]=",ExpressionUUID->"d81ab05d-f705-4baf-be46-5b389a9a6a24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MawellGHPEqs", "=", 
  RowBox[{"DyadComponents", "[", 
   RowBox[{"%", ",", "Dyad"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.644040319568876*^9, 3.6440403223139224`*^9}, {
  3.6443165247086887`*^9, 3.6443165283386936`*^9}, {3.956193357744137*^9, 
  3.956193359048601*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"dfced1bf-e943-47c4-baf8-dea6bf994f11"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Phi]", "0"],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[Rho]", "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "2"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Sigma]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyad[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "1"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyad[],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], 
        SubscriptBox["\[Phi]", "0"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[Kappa]", "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyad[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "1"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[Rho]", "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyad[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "2"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyad[],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        SubscriptBox["\[Phi]", "2"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Phi]", "2"],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox["\[Kappa]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyad[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "1"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyad[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[Tau]", "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyad[],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        SubscriptBox["\[Phi]", "0"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "2"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyad[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[Sigma]", "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyad[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "1"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[Tau]", "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyad[],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        SubscriptBox["\[Phi]", "2"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False]}], "\[Equal]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBwBWJ/hfwJJWqvHZNUWf9UA+nX6Zx2NUC6qu7y/+NAWubv
WdmTQPpFv44yiBbP+//qGpA+xfTiA4iesu0Qx3UgfVe8aNEvIG1TunA9iF4t
KbUNRAtpJGf+BtKGrzvyQXRDOm89iFYVs20F0fzLFx7V1njteM/5zT8Qba7W
z6UDpBe9fCMMohVL13V6A2mvNpEcXyDdtVKJ1w8kPzVGGERntR5zBNG/qtu9
QPTcmvpAEM0hnhkFohM2Xq4A0TvCZaaAaDeDk2f5tF87Fi1aVbNV57Wjevfp
NyC6S32K6C4g/cyYxRlEhwVf9ALRDtverNwDpOuWq3MX6gL9Z1vr2wGks5+V
zQfRqunLhDuBdJv/ItupQPqSz4abs4G01Z3q/jlAOv39yvxoPaD4BC7uOCD9
q+7ztHggvV/LMzkBSN/O1anKANIP8m4tAdFewh6vmoB0zlEv3mYgve/6qiIQ
veq63rU1QPp7waWItUB6ktUk7XVA2mSif7udwWvHV3PCpoPoDmUT1//HgOGi
pXtM+sRrRxZD3ivXKt867olcx3UdSGvEXHEB0TsYpvydMe+t46oSbeaZQHrL
sdRWEB0ac155FpB+9lPWCUR36b4tBtEAoeIMUQ==
  "],
 CellLabel->"Out[38]=",ExpressionUUID->"0562c2a2-f42b-476c-87f3-11711fdb41ed"]
}, Open  ]],

Cell["GHP form of the scalar wave equation", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
  3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
  3.644213159334499*^9}, {3.6442135544251876`*^9, 
  3.644213559796273*^9}},ExpressionUUID->"d48201ee-b98c-4308-b6d2-\
e0fdb9744f49"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CDe", "[", 
    RowBox[{"A", ",", "A\[Dagger]"}], "]"}], "[", 
   RowBox[{
    RowBox[{"CDe", "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "A\[Dagger]"}]}], "]"}], "[", 
    RowBox[{"chi00", "[", "]"}], "]"}], "]"}], "\[Equal]", "0"}]], "Input",
 CellChangeTimes->{{3.647850988965496*^9, 3.647851006169548*^9}, {
  3.6478510420732393`*^9, 3.6478510424482594`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"056710eb-37e8-4ddc-a7cb-a126ed4945a1"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[EmptyDownTriangle]", "  ", 
      RowBox[{"AA", "'"}]], 
     SubsuperscriptBox["\[EmptyDownTriangle]", 
      RowBox[{"AA", "'"}], "  "], "\[Chi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDe[$CellContext`A, $CellContext`A\[Dagger]][
    $CellContext`CDe[-$CellContext`A, -$CellContext`A\[Dagger]][
     $CellContext`chi00[]]],
   Editable->False], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.6478510070289383`*^9, 3.6478510433076477`*^9}, 
   3.648183165372978*^9, 3.64818850447081*^9, 3.648191671624876*^9, 
   3.648193306380227*^9, 3.648209873404036*^9, 3.6482102148416653`*^9, 
   3.6482640183461103`*^9, 3.648264298399098*^9, 3.6482651093857145`*^9, 
   3.6483498735338264`*^9, 3.6483509185862894`*^9, 3.64835260457965*^9, 
   3.649172538496475*^9, 3.6491726667066545`*^9, 3.7282104736293373`*^9, 
   3.7287931374274282`*^9, 3.956192928443136*^9, 3.9561938306482506`*^9, 
   3.9754649406580467`*^9, 3.975464985403096*^9, 3.9754660272110043`*^9, 
   3.975467294524495*^9, 3.975467537005831*^9, 3.975467935439641*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"46d38077-2d8c-4bb8-8022-2102488c5625"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToFundSpinOp", "/@", 
  RowBox[{"ToFundSpinOp", "/@", "%"}]}]], "Input",
 CellChangeTimes->{{3.6478510081539946`*^9, 3.6478510278537464`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"899acb23-10f3-43bd-83fb-e8154fdb3e5b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Adding rules for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "chi00", "}"}]}],
  SequenceForm["Adding rules for ", {$CellContext`chi00}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6481831654354744`*^9, 3.648188504595818*^9, 
  3.648191671640502*^9, 3.64819330645835*^9, 3.6482098734196606`*^9, 
  3.6482102148572917`*^9, 3.6482640184242473`*^9, 3.6482642984772263`*^9, 
  3.6482651094482193`*^9, 3.648349873543826*^9, 3.6483509185962896`*^9, 
  3.64835260458965*^9, 3.6491725385064754`*^9, 3.649172666716655*^9, 
  3.7282104736514893`*^9, 3.7287931374424295`*^9, 3.95619292847604*^9, 
  3.9561938306622124`*^9, 3.9754649406965733`*^9, 3.975464985448208*^9, 
  3.9754660272458143`*^9, 3.975467294573803*^9, 3.975467537041724*^9, 
  3.9754679354725437`*^9},
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"45a780f1-b50b-40a1-b8c3-312373f72876"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Adding rules for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"TwistCDe", "[", "chi00", "]"}], "}"}]}],
  SequenceForm["Adding rules for ", {
    $CellContext`TwistCDe[$CellContext`chi00]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6481831654354744`*^9, 3.648188504595818*^9, 
  3.648191671640502*^9, 3.64819330645835*^9, 3.6482098734196606`*^9, 
  3.6482102148572917`*^9, 3.6482640184242473`*^9, 3.6482642984772263`*^9, 
  3.6482651094482193`*^9, 3.648349873543826*^9, 3.6483509185962896`*^9, 
  3.64835260458965*^9, 3.6491725385064754`*^9, 3.649172666716655*^9, 
  3.7282104736514893`*^9, 3.7287931374424295`*^9, 3.95619292847604*^9, 
  3.9561938306622124`*^9, 3.9754649406965733`*^9, 3.975464985448208*^9, 
  3.9754660272458143`*^9, 3.975467294573803*^9, 3.975467537041724*^9, 
  3.975467935478202*^9},
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"1ca402a2-0f52-498e-b5df-192beee68b56"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[ScriptCapitalD]", 
      RowBox[{
       TagBox["1",
        DisplayForm], ",", 
       TagBox["1",
        DisplayForm]}], ""], 
     RowBox[{
      SubsuperscriptBox["\[ScriptCapitalT]", 
       RowBox[{
        TagBox["0",
         DisplayForm], ",", 
        TagBox["0",
         DisplayForm]}], ""], "\[Chi]"}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`DivCDe[
    $CellContext`TwistCDe[$CellContext`chi00]][],
   Editable->False], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.6478510152324915`*^9, 3.6478510441201878`*^9}, 
   3.6481831656229897`*^9, 3.648188504783325*^9, 3.6481916716873803`*^9, 
   3.6481933066302366`*^9, 3.648209873482164*^9, 3.6482102149197903`*^9, 
   3.6482640185961285`*^9, 3.648264298649108*^9, 3.648265109635729*^9, 
   3.648349873583826*^9, 3.6483509186362896`*^9, 3.64835260462965*^9, 
   3.6491725385564756`*^9, 3.649172666766655*^9, 3.7282104737507715`*^9, 
   3.728793137476431*^9, 3.956192928503992*^9, 3.9561938306851463`*^9, 
   3.975464940702503*^9, 3.975464985454513*^9, 3.975466027252357*^9, 
   3.975467294579709*^9, 3.975467537047974*^9, 3.975467935479804*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"f8994c46-2170-4c92-8e8b-963fc0b3ced9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToGHP", "[", 
  RowBox[{"%", ",", "Dyad"}], "]"}]], "Input",
 CellChangeTimes->{{3.644213600939067*^9, 3.6442136073769107`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"703ec6db-9ca0-463f-9d89-7cf597507e4a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", 
   RowBox[{"DivCDe", "[", 
    RowBox[{"TwistCDe", "[", "chi00", "]"}], "]"}], 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm["GHP weights for ", 
   $CellContext`DivCDe[
    $CellContext`TwistCDe[$CellContext`chi00]], " components are generated, ",
    "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9754675370837803`*^9, 3.975467935509427*^9},
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"aea41fe8-82f1-4d60-9165-4dc21985880f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating the \"\>", "\[InvisibleSpace]", "Dyad", 
   "\[InvisibleSpace]", "\<\"components of \"\>", "\[InvisibleSpace]", 
   RowBox[{"DivCDe", "[", 
    RowBox[{"TwistCDe", "[", "chi00", "]"}], "]"}], 
   "\[InvisibleSpace]", "\<\" in GHP form. (Improved code)\"\>"}],
  SequenceForm["Calculating the ", $CellContext`Dyad, "components of ", 
   $CellContext`DivCDe[
    $CellContext`TwistCDe[$CellContext`chi00]], 
   " in GHP form. (Improved code)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9754675370837803`*^9, 3.975467935514633*^9},
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"92066c28-af15-4562-8fa1-2fb1545a92ef"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Rho]", "'"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Rho]pDyad[],
      Editable->False]}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Rho]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "+", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[Thorn]", 
      RowBox[{"\[Thorn]", "'"}], "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
      $CellContext`chi00[]]],
    Editable->False], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Rho]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Rho]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "+", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      RowBox[{"\[Thorn]", "'"}], "\[Thorn]", "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
      $CellContext`chi00[]]],
    Editable->False], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Tau]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Tau]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[Eth]", 
      RowBox[{"\[Eth]", "'"}], "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
      $CellContext`chi00[]]],
    Editable->False], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Tau]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Tau]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], "\[Chi]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`chi00[]],
      Editable->False], ")"}]}], "-", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      RowBox[{"\[Eth]", "'"}], "\[Eth]", "\[Chi]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
      $CellContext`chi00[]]],
    Editable->False]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBwAOLv/My6J9VeO1q8Y399DUg/YXr/AUQvMTvOcR1In8ws
WvQLSHM4LVsPotlXymwD0VGcaZm/gfT/7b35IDrJ5Fc9iM75bt8KosM7lhzV
1njtOD3p4z8QnR05iUsHSL869V4YRGeGbez0BtIT08VzfIH05S5VXj8gHb0l
URhEd3CdcgTRTrFdXiA6bHZLIIhOWZYdBaL3OFyrANHX78hPAdE6Z66d5dN+
7digtK5mq85rR+Pu829ANI/NI9FdQHpBEKcziN786LIXiPZy+rhyD5COYtLh
LtR97fiiv9G3A0hXPKuaD6KtKlYJdwLpCf7LbKcC6UdtW27OBtK7rtT3z9EF
+eeQy04gveH9vvxoPaD/BU2444A0f/3PafFA2mF1XnICkH6Ta1SVAaR/5D1Y
AqKXT45/1QSk17gm8jYDab4bB4pAtKCd6bU1QHrWw+sRa4F0ydZp2uuAtBhP
SLudwWvHM+LR00H0jj4r1//HXjtW/Tc8Jn3itSOLtNCVa5VvHRUmXHO5DqSX
HZj+d8a8t45+T/SZZwLp3S6ZrSA6hOuK8iwgfeuZkhOIDuv6UAyiASXz/Bw=

  "],
 CellLabel->"Out[41]=",ExpressionUUID->"e676f735-d1c2-4e51-a539-83b881ba58c1"]
}, Open  ]],

Cell["\<\
Lower order terms, computed during the calculation are stored :\
\>", "Text",
 CellChangeTimes->{{3.6478512377654395`*^9, 3.647851273251666*^9}, {
  3.648194295520177*^9, 
  3.6481942956764307`*^9}},ExpressionUUID->"8ff1a23c-86cb-4b1e-8f02-\
f0aed6985e49"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GHPComponentRules", "[", 
  RowBox[{
   RowBox[{"TwistCDe", "[", "chi00", "]"}], ",", "Dyad"}], "]"}]], "Input",
 CellChangeTimes->{{3.647851072996703*^9, 3.6478511166036615`*^9}, {
  3.6478512151158657`*^9, 3.6478512238741217`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"93524057-5abf-43f8-9a3b-72965c67f70f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox[
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalT]", 
         RowBox[{
          TagBox["0",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], ""], "\[Chi]"}], 
       RowBox[{"00", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TwistCDe[$CellContext`chi00][{0, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Thorn]", "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
      $CellContext`chi00[]],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox[
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalT]", 
         RowBox[{
          TagBox["0",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], ""], "\[Chi]"}], 
       RowBox[{"10", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TwistCDe[$CellContext`chi00][{1, -$CellContext`Dyad}, {
      0, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{"\[Eth]", "'"}], "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
      $CellContext`chi00[]],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox[
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalT]", 
         RowBox[{
          TagBox["0",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], ""], "\[Chi]"}], 
       RowBox[{"01", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TwistCDe[$CellContext`chi00][{0, -$CellContext`Dyad}, {
      1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Eth]", "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
      $CellContext`chi00[]],
     Editable->False]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox[
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalT]", 
         RowBox[{
          TagBox["0",
           DisplayForm], ",", 
          TagBox["0",
           DisplayForm]}], ""], "\[Chi]"}], 
       RowBox[{"11", "'"}]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`TwistCDe[$CellContext`chi00][{1, -$CellContext`Dyad}, {
      1, -$CellContext`Dyad\[Dagger]}],
     Editable->False], "\[Rule]", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{"\[Thorn]", "'"}], "\[Chi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
      $CellContext`chi00[]],
     Editable->False]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.647851087825592*^9, 3.647851117384926*^9}, {
   3.647851219530113*^9, 3.6478512244991226`*^9}, 3.648183166185514*^9, 
   3.6481885057521276`*^9, 3.6481916718123856`*^9, 3.648193307520907*^9, 
   3.64820987360717*^9, 3.6482102150447984`*^9, 3.6482640191899066`*^9, 
   3.6482642991960135`*^9, 3.6482651103232594`*^9, 3.6483498736738267`*^9, 
   3.6483509187462893`*^9, 3.6483526047196503`*^9, 3.6491725386364756`*^9, 
   3.649172666856655*^9, 3.728210473852067*^9, 3.728793137578437*^9, 
   3.95619292860672*^9, 3.9561938307110786`*^9, 3.9754649407767553`*^9, 
   3.97546498554067*^9, 3.975466027320037*^9, 3.9754672946749363`*^9, 
   3.975467537127104*^9, 3.975467935546898*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"3536b411-0282-49d1-b87c-f01986fec4bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "$GHPExtraRules"}]], "Input",
 CellChangeTimes->{{3.644213685209197*^9, 3.644213688146884*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"9ad8bb77-8451-4dfa-8474-a86863174712"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$GHPExtraRules is a user defined list of extra \
rules used for the conversion of an expression into GHP formalism.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Assignment\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"OwnValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "OwnValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{"$GHPExtraRules", "=", 
                    RowBox[{"{", "}"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`SpinFrames`$GHPExtraRules\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$GHPExtraRules is a user defined list of extra \
rules used for the conversion of an expression into GHP formalism.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{12.5, {3.34375, 9.15625}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{12.5, {3.34375, 9.15625}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "$GHPExtraRules is a user defined list of extra rules used for the \
conversion of an expression into GHP formalism.", "Documentation" -> None, 
    "OwnValues" -> 
    Information`InformationValueForm[
     OwnValues, xAct`SpinFrames`$GHPExtraRules, {
      xAct`SpinFrames`$GHPExtraRules -> {}}], "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`SpinFrames`$GHPExtraRules"|>, 
   False]]], "Output",
 CellChangeTimes->{3.956192936727009*^9, 3.9561938307739086`*^9, 
  3.975464940833095*^9, 3.975464985596014*^9, 3.975466027423216*^9, 
  3.9754672947258873`*^9, 3.975467537182557*^9, 3.97546793560357*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"c43c2aa4-5743-4dd9-ac56-068cc90a65ba"]
}, Open  ]],

Cell["GHP form of higher derivatives and commutators", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
  3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
  3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
  3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
  3.6442142665173736`*^9}},ExpressionUUID->"f807e079-0e4a-4f33-9ed2-\
472775928942"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DivCDe", "[", 
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], "]"}], "//", 
  "GiveIndicesToTensor"}]], "Input",
 CellChangeTimes->{{3.6441231899835453`*^9, 3.6441232067203493`*^9}, {
   3.644213851885685*^9, 3.644213864683243*^9}, 3.644214181845275*^9, {
   3.6442142134875917`*^9, 3.644214240098358*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"613ff9b7-9203-41e2-a8bc-5c5e16357f88"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[ScriptCapitalD]", 
     RowBox[{
      TagBox["1",
       DisplayForm], ",", 
      TagBox["1",
       DisplayForm]}], ""], 
    RowBox[{
     SubsuperscriptBox["\[ScriptCapitalC]", 
      RowBox[{
       TagBox["2",
        DisplayForm], ",", 
       TagBox["0",
        DisplayForm]}], "\[Dagger]"], "\[Phi]"}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`DivCDe[
   $CellContext`CurlDgCDe[$CellContext`phi20]][],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.644123207434825*^9, 3.6441234702190804`*^9, 3.6441237835407305`*^9, 
   3.644211223016741*^9, 3.644213865136363*^9, 3.644214183314072*^9, {
   3.644214223159952*^9, 3.6442142408015203`*^9}, 3.6442417524978447`*^9, 
   3.6442417997034917`*^9, 3.644241990537939*^9, {3.6442420818223753`*^9, 
   3.6442421330282383`*^9}, 3.6442422918609643`*^9, 3.644314899695413*^9, 
   3.6443150052755613`*^9, 3.6443150570356336`*^9, 3.6443164912686415`*^9, 
   3.6443165405087104`*^9, 3.6443166796889052`*^9, 3.6443167140789537`*^9, 
   3.644939821251643*^9, 3.6449402796232853`*^9, 3.644940372663415*^9, 
   3.6449404475735197`*^9, 3.6450048776317983`*^9, 3.6450087368513927`*^9, 
   3.6450100252531967`*^9, 3.645010075133266*^9, 3.645010446503786*^9, 
   3.645010516403884*^9, 3.645010572223962*^9, 3.6450106434840617`*^9, 
   3.6450108867854023`*^9, 3.6450111050857077`*^9, 3.6464533588985524`*^9, 
   3.6473190137229767`*^9, 3.6473199107670097`*^9, 3.6473202395407906`*^9, 
   3.6473284350098352`*^9, 3.647328792371336*^9, 3.647328854701423*^9, 
   3.6473337118685617`*^9, 3.6477031297125125`*^9, 3.647750764343011*^9, 
   3.6477514201218987`*^9, 3.647752349616371*^9, 3.6477772614784765`*^9, 
   3.647790798169819*^9, 3.647792252479041*^9, 3.6481831670761857`*^9, 
   3.648188507158452*^9, 3.6481916721874065`*^9, 3.648193308918652*^9, 
   3.6481945803896503`*^9, 3.6482098739353104`*^9, 3.6482102152791862`*^9, 
   3.648264020252466*^9, 3.6482643000398145`*^9, 3.6482651111670585`*^9, 
   3.6483498737738266`*^9, 3.64835091882629*^9, 3.64835260483965*^9, 
   3.6491725387164755`*^9, 3.649172666936655*^9, 3.728210473930205*^9, 
   3.7287931377514467`*^9, 3.956192943707884*^9, 3.9561938307858887`*^9, 
   3.9754649408665648`*^9, 3.97546498563559*^9, 3.975466027452969*^9, 
   3.975467294773857*^9, 3.9754675372180023`*^9, 3.975467935631863*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"eb8c1076-3ef5-4317-9905-775b6ea40d35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "\[Equal]", 
  RowBox[{"ToGHP", "[", 
   RowBox[{"%", ",", "Dyad"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.644123209826421*^9, 3.644123214105278*^9}, 
   3.6442112071721773`*^9, {3.644213870871043*^9, 3.6442138718085966`*^9}, 
   3.6442421265747986`*^9},
 CellLabel->"In[45]:=",ExpressionUUID->"bdecdca1-b4b7-4490-83c9-2d48fec3bc3f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", 
   RowBox[{"DivCDe", "[", 
    RowBox[{"CurlDgCDe", "[", "phi20", "]"}], "]"}], 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm["GHP weights for ", 
   $CellContext`DivCDe[
    $CellContext`CurlDgCDe[$CellContext`phi20]], 
   " components are generated, ", "components are formatted, ", 
   "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.975467537257616*^9, 3.9754679356640797`*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"69ee2fef-0729-422b-b865-f936fefb21dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating the \"\>", "\[InvisibleSpace]", "Dyad", 
   "\[InvisibleSpace]", "\<\"components of \"\>", "\[InvisibleSpace]", 
   RowBox[{"DivCDe", "[", 
    RowBox[{"CurlDgCDe", "[", "phi20", "]"}], "]"}], 
   "\[InvisibleSpace]", "\<\" in GHP form. (Improved code)\"\>"}],
  SequenceForm["Calculating the ", $CellContext`Dyad, "components of ", 
   $CellContext`DivCDe[
    $CellContext`CurlDgCDe[$CellContext`phi20]], 
   " in GHP form. (Improved code)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.975467537257616*^9, 3.97546793566884*^9},
 CellLabel->
  "During evaluation of \
In[45]:=",ExpressionUUID->"358a213e-eead-4ece-81d8-2a53bed760ed"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[ScriptCapitalD]", 
      RowBox[{
       TagBox["1",
        DisplayForm], ",", 
       TagBox["1",
        DisplayForm]}], ""], 
     RowBox[{
      SubsuperscriptBox["\[ScriptCapitalC]", 
       RowBox[{
        TagBox["2",
         DisplayForm], ",", 
        TagBox["0",
         DisplayForm]}], "\[Dagger]"], "\[Phi]"}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`DivCDe[
    $CellContext`CurlDgCDe[$CellContext`phi20]][],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       SubscriptBox["\[Phi]", "0"],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
      Editable->False]}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Kappa]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]pDyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Rho]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Kappa]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]pDyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Rho]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad\[Dagger][],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Rho]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad[],
     Editable->False]}], "+", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Rho]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad\[Dagger][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Rho]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Rho]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad\[Dagger][],
     Editable->False]}], "-", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Rho]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Rho]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad\[Dagger][],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Rho]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad\[Dagger][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Tau]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Sigma]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]pDyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Tau]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Rho]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Tau]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad\[Dagger][],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Sigma]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Tau]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad\[Dagger][],
     Editable->False]}], "+", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Tau]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Tau]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad\[Dagger][],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Rho]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad\[Dagger][],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Tau]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Sigma]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Tau]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["\[Rho]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Tau]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad\[Dagger][],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Sigma]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]pDyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Tau]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad\[Dagger][],
     Editable->False]}], "-", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Tau]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Tau]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad\[Dagger][],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Kappa]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]pDyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        SubscriptBox["\[Phi]", "0"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Rho]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Rho]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Tau]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        SubscriptBox["\[Phi]", "2"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        RowBox[{"\[Kappa]", "'"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`\[Kappa]pDyad[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", 
        RowBox[{"\[Rho]", "'"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`\[Rho]pDyad[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Thorn]", "\[Tau]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
       $CellContext`\[Tau]Dyad[]],
      Editable->False], ")"}]}], "+", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[Thorn]", 
      RowBox[{"\[Thorn]", "'"}], 
      SubscriptBox["\[Phi]", "1"]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
      $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]]],
    Editable->False], "-", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[Thorn]", "\[Eth]", 
      SubscriptBox["\[Phi]", "2"]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
      $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]]],
    Editable->False], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Tau]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], 
        SubscriptBox["\[Phi]", "0"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Rho]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Rho]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Kappa]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]Dyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], 
        SubscriptBox["\[Phi]", "2"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], "\[Kappa]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`\[Kappa]Dyad[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], "\[Rho]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`\[Rho]Dyad[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Thorn]", "'"}], 
        RowBox[{"\[Tau]", "'"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
       $CellContext`\[Tau]pDyad[]],
      Editable->False], ")"}]}], "-", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      RowBox[{"\[Thorn]", "'"}], "\[Thorn]", 
      SubscriptBox["\[Phi]", "1"]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
      $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]]],
    Editable->False], "+", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      RowBox[{"\[Thorn]", "'"}], 
      RowBox[{"\[Eth]", "'"}], 
      SubscriptBox["\[Phi]", "0"]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
      $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]]],
    Editable->False], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Sigma]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]pDyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        SubscriptBox["\[Phi]", "0"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Tau]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Tau]", "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Rho]", "_"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        SubscriptBox["\[Phi]", "2"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", "\[Rho]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`\[Rho]Dyad[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        RowBox[{"\[Sigma]", "'"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`\[Sigma]pDyad[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{"\[Eth]", 
        RowBox[{"\[Tau]", "'"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
       $CellContext`\[Tau]pDyad[]],
      Editable->False], ")"}]}], "+", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[Eth]", "\[Thorn]", 
      SubscriptBox["\[Phi]", "2"]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
      $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]]],
    Editable->False], "-", 
   InterpretationBox[
    StyleBox[
     RowBox[{"\[Eth]", 
      RowBox[{"\[Eth]", "'"}], 
      SubscriptBox["\[Phi]", "1"]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
      $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]]],
    Editable->False], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Rho]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        SubscriptBox["\[Phi]", "0"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Tau]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Tau]", "_"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyad\[Dagger][],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        SubscriptBox["\[Phi]", "1"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox["\[Sigma]",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]Dyad[],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        SubscriptBox["\[Phi]", "2"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "0"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        RowBox[{"\[Rho]", "'"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`\[Rho]pDyad[]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "2"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], "\[Sigma]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`\[Sigma]Dyad[]],
      Editable->False], ")"}]}], "-", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", "1"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], "\[Tau]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`\[Tau]Dyad[]],
      Editable->False], ")"}]}], "-", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      RowBox[{"\[Eth]", "'"}], 
      RowBox[{"\[Thorn]", "'"}], 
      SubscriptBox["\[Phi]", "0"]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{2, -$CellContext`NP}][
      $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]]],
    Editable->False], "+", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      RowBox[{"\[Eth]", "'"}], "\[Eth]", 
      SubscriptBox["\[Phi]", "1"]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
     $CellContext`\[CapitalTheta]Dyad[{3, -$CellContext`NP}][
      $CellContext`phi20[{0, -$CellContext`Dyad}, {1, -$CellContext`Dyad}]]],
    Editable->False]}]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGCwB+Jlz3dIXVd77RjRO1kPRO+bVLboF5CeybJmPYiWCVfZ
BqJfnc7O/A2kF2lMzgfRMev5GkG0UIZrK4he6bD6qLbGa0d11e//QPSz3Blc
OkC6qverMIh+krW90xtEy8vl+ALp8t9avH5AmkE1XRhEWwRddgTRl+QneIHo
Z7FdgSA6bVlxFFg+9E4FiA76qDoFRBcovzrLp/3aca3S7pqtOq8dE7jvvgHR
U87xi20D0p/uV4ntAtL6ovzOIDo8+KYXiK7YyLBqD5Detsiau1D3teOxZf2+
HUB6WVrHfBCtbrtDuBNIHzq/2XYqkP6ae+rmbCC9S3JK/xwgHVDwIT9a77Wj
1aRi7jgg7f6fc3o8kD79dHVyApCO+bGEKRFIK+Q5VmUAafn3b5aA6LQp0141
AWm3Y328zUB6Z8SXIhBdscT62hogrb3kbsRaIL1p/1ztdUB62bnIdjuD144e
OonTQfSJnw6u/4+9dpy10vqY9InXjj++fr96rfKtYwvTLZfrQLood97fGfPe
Oj5iNWOeCaRVHue3guhrZbeUZwFp5nYNJxD9p+NrMYgGADn7+fU=
  "],
 CellLabel->"Out[45]=",ExpressionUUID->"cd8c102a-0ed6-42ac-b9c5-76e2aff974f2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"GHPCommutatorsForward", "[", "Dyad", "]"}]}], "/.", 
   RowBox[{"GHPRicciRules", "[", "Dyad", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6441232661468625`*^9, 3.644123335995208*^9}, {
   3.644123462201731*^9, 3.6441234641170087`*^9}, {3.644123775543039*^9, 
   3.644123776577729*^9}, {3.6442139885190744`*^9, 3.6442139931599464`*^9}, {
   3.6442140232709303`*^9, 3.6442140349278035`*^9}, {3.644214248110108*^9, 
   3.644214248422656*^9}, 3.647328813391365*^9, 3.648194354682955*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"1e2e13ea-4225-4414-8694-c904795d1088"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[ScriptCapitalD]", 
      RowBox[{
       TagBox["1",
        DisplayForm], ",", 
       TagBox["1",
        DisplayForm]}], ""], 
     RowBox[{
      SubsuperscriptBox["\[ScriptCapitalC]", 
       RowBox[{
        TagBox["2",
         DisplayForm], ",", 
        TagBox["0",
         DisplayForm]}], "\[Dagger]"], "\[Phi]"}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`DivCDe[
    $CellContext`CurlDgCDe[$CellContext`phi20]][],
   Editable->False], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwVzn0o3HEcwPGT0tp15+GWdBhG183vLKVQHtbXQ9PpVk6hGzfnIVueNzEX
83iM2mych/NwV7pS86xhw/jHLspK5HDbKf645OuGP/zGhH0+f7x7/fv2yyqW
5zpwOJw4aL7rUDAgosTZt5ZBNbtDcpTn56hcBdkp72w0qUlYjdYUeVEzKG5w
OEOPZyx3tsG8w1MhWmipGPwHNqaMjKNeqQEz6JZ3wcsr8IO6oxgNT35ch15/
i9egne3DPxgxJTcrf2/QjaWeuxJQ/f5cgK4vzLYkoqX3C2RglozhPQVpeZ4A
5bObBN3w+ShFbRmtSWiktEyBulz+foNGx4q06CRLf/IZSr48WKyalsA/d+8Y
3Uv3iJ0DnfoOpGjrJf/zAlhfIeeWBlHydd8oewfu23QGVKlaE7SAbuurUZ3g
ssK62wfqDca2flByFlTy7BEl9zqmuEqwusaj+zk4YfuTnQmKimLUL0Dxid2I
qrS6o3ow3aTlNYDfd9hXaA4bYR4B3Vlr2iiod9UzY2C7r6I5OpiSkLeqbvRo
kMTfmihxjYo0ea5QYpy82DJX2kmCxhK3DYo/Ga579HaS/yTMUQc2/irRoIGF
Vv9eUDj9MAYNLWNfo/8BAP8QPw==
  "],
 CellLabel->"Out[46]=",ExpressionUUID->"bca5dc35-a1bd-41cc-9ee9-5dc125296c97"]
}, Open  ]],

Cell["\<\
For comparison, we calculate this directly from the covariant commutators:\
\>", "Text",
 CellChangeTimes->{{3.647852145504464*^9, 3.6478522073940983`*^9}, {
  3.647852331393736*^9, 3.64785234380064*^9}, {3.6481943577299776`*^9, 
  3.648194359167532*^9}},ExpressionUUID->"fa3a3cf7-f567-4c8c-8cd6-\
7d8b427ec0fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DivCDe", "[", 
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], "]"}], "[", "]"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"610c90f7-d8c5-4e5d-a8ba-a4e4eef7d9f4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubsuperscriptBox["\[ScriptCapitalD]", 
     RowBox[{
      TagBox["1",
       DisplayForm], ",", 
      TagBox["1",
       DisplayForm]}], ""], 
    RowBox[{
     SubsuperscriptBox["\[ScriptCapitalC]", 
      RowBox[{
       TagBox["2",
        DisplayForm], ",", 
       TagBox["0",
        DisplayForm]}], "\[Dagger]"], "\[Phi]"}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`DivCDe[
   $CellContext`CurlDgCDe[$CellContext`phi20]][],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.6478515482590756`*^9, {3.6478522231655226`*^9, 3.6478522627338715`*^9}, 
   3.6481831695138264`*^9, 3.6481885096898327`*^9, 3.648191672796812*^9, 
   3.6481933115906754`*^9, 3.648209874091571*^9, 3.6482102154510703`*^9, 
   3.6482640208618665`*^9, 3.6482643007273474`*^9, 3.6482651117764616`*^9, 
   3.6483498738838267`*^9, 3.64835091893629*^9, 3.6483526049496503`*^9, 
   3.649172538826476*^9, 3.649172667046655*^9, 3.72821047405214*^9, 
   3.728793137897455*^9, 3.9561929437887173`*^9, 3.9561938308327255`*^9, 
   3.9754649410236464`*^9, 3.975464985773312*^9, 3.9754660275605516`*^9, 
   3.975467294967227*^9, 3.975467537311161*^9, 3.975467935735126*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"04992472-3bde-4ca7-8aab-ad9f596d7fd0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "\[Equal]", 
  RowBox[{"ExpandBox", "[", 
   RowBox[{"%", "/.", 
    RowBox[{"CommuteFundSpinOp", "[", 
     RowBox[{"DivCDe", ",", "CurlDgCDe"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6478514846463823`*^9, 3.647851554165636*^9}, {
  3.647852217227904*^9, 3.647852261171322*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"49ee988d-1581-4ef5-80ea-f41cfee971d3"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[ScriptCapitalD]", 
      RowBox[{
       TagBox["1",
        DisplayForm], ",", 
       TagBox["1",
        DisplayForm]}], ""], 
     RowBox[{
      SubsuperscriptBox["\[ScriptCapitalC]", 
       RowBox[{
        TagBox["2",
         DisplayForm], ",", 
        TagBox["0",
         DisplayForm]}], "\[Dagger]"], "\[Phi]"}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`DivCDe[
    $CellContext`CurlDgCDe[$CellContext`phi20]][],
   Editable->False], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.6478515277110987`*^9, 3.6478515548375187`*^9}, {
   3.647852223991193*^9, 3.6478522634526615`*^9}, 3.6481831696544447`*^9, 
   3.6481885098304653`*^9, 3.648191672828064*^9, 3.648193311731301*^9, 
   3.6482098741384473`*^9, 3.6482102154979467`*^9, 3.6482640210024977`*^9, 
   3.648264300852355*^9, 3.6482651119170976`*^9, 3.6483498739038267`*^9, 
   3.64835091896629*^9, 3.6483526049796505`*^9, 3.6491725388464756`*^9, 
   3.649172667066655*^9, 3.7282104740836*^9, 3.7287931379224567`*^9, 
   3.956192943808609*^9, 3.9561938308507023`*^9, 3.975464941061211*^9, 
   3.975464985823509*^9, 3.975466027594569*^9, 3.975467295018301*^9, 
   3.9754675373470488`*^9, 3.975467935770382*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"a2a33898-af17-409f-bab0-9be25e1e0ab0"]
}, Open  ]],

Cell["Tex output is generated as usual:", "Text",
 CellChangeTimes->{{3.6481943684297495`*^9, 3.648194383883686*^9}, 
   3.648194615861515*^9},ExpressionUUID->"54544585-f386-4c2b-94e3-\
c14d55bd1545"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrintAlignedEquations", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DivCDe", "[", 
     RowBox[{"CurlDgCDe", "[", "phi20", "]"}], "]"}], "[", "]"}], "==", 
   RowBox[{"ToGHP", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DivCDe", "[", 
       RowBox[{"CurlDgCDe", "[", "phi20", "]"}], "]"}], "[", "]"}], ",", 
     "Dyad"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.647320232212283*^9, 3.647320236415627*^9}, {
  3.6481944116706696`*^9, 3.648194499926704*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"f72e709d-7c7e-4152-bc7d-3c01e8e0f622"],

Cell[BoxData["\<\"\\\\begin{align}\\n(\\\\sDiv_{1,1} \\\\sCurlDagger_{2,0} \\\
\\phi)={}&- \\\\phi_{0} \\\\kappa ' \\\\rho\\n -  \\\\phi_{0} \\\\kappa ' \
\\\\bar{\\\\rho}\\n + \\\\phi_{2} \\\\kappa \\\\rho '\\n + 2 \\\\phi_{1} \
\\\\bar{\\\\rho} \\\\rho '\\n + \\\\phi_{2} \\\\kappa \\\\bar{\\\\rho}'\\n - \
2 \\\\phi_{1} \\\\rho \\\\bar{\\\\rho}'\\n -  \\\\phi_{2} \\\\bar{\\\\rho} \\\
\\tau\\\\nonumber\\\\\\\\\\n& + \\\\phi_{0} \\\\sigma ' \\\\tau\\n -  \
\\\\phi_{0} \\\\rho ' \\\\bar{\\\\tau}\\n -  \\\\phi_{2} \\\\sigma \\\\bar{\\\
\\tau}\\n + 2 \\\\phi_{1} \\\\tau \\\\bar{\\\\tau}\\n + \\\\phi_{0} \
\\\\bar{\\\\rho}' \\\\tau '\\n -  \\\\phi_{2} \\\\sigma \\\\tau '\\n + \
\\\\phi_{2} \\\\rho \\\\bar{\\\\tau}'\\\\nonumber\\\\\\\\\\n& + \\\\phi_{0} \
\\\\sigma ' \\\\bar{\\\\tau}'\\n - 2 \\\\phi_{1} \\\\tau ' \
\\\\bar{\\\\tau}'\\n + \\\\kappa ' \\\\tho \\\\phi_{0}\\n -  \\\\rho ' \
\\\\tho \\\\phi_{1}\\n + \\\\bar{\\\\rho}' \\\\tho \\\\phi_{1}\\n -  \\\\bar{\
\\\\tau}' \\\\tho \\\\phi_{2}\\\\nonumber\\\\\\\\\\n& + \\\\phi_{0} \\\\tho \
\\\\kappa '\\n - 2 \\\\phi_{1} \\\\tho \\\\rho '\\n + \\\\phi_{2} \\\\tho \
\\\\tau\\n + \\\\tho \\\\thop \\\\phi_{1}\\n -  \\\\tho \\\\edt \
\\\\phi_{2}\\n + \\\\bar{\\\\tau} \\\\thop \\\\phi_{0}\\n + \\\\rho \\\\thop \
\\\\phi_{1}\\\\nonumber\\\\\\\\\\n& -  \\\\bar{\\\\rho} \\\\thop \
\\\\phi_{1}\\n -  \\\\kappa \\\\thop \\\\phi_{2}\\n -  \\\\phi_{2} \\\\thop \
\\\\kappa\\n + 2 \\\\phi_{1} \\\\thop \\\\rho\\n -  \\\\phi_{0} \\\\thop \
\\\\tau '\\n -  \\\\thop \\\\tho \\\\phi_{1}\\n + \\\\thop \\\\edtp \
\\\\phi_{0}\\\\nonumber\\\\\\\\\\n& -  \\\\sigma ' \\\\edt \\\\phi_{0}\\n -  \
\\\\bar{\\\\tau} \\\\edt \\\\phi_{1}\\n + \\\\tau ' \\\\edt \\\\phi_{1}\\n + \
\\\\bar{\\\\rho} \\\\edt \\\\phi_{2}\\n -  \\\\phi_{2} \\\\edt \\\\rho\\n -  \
\\\\phi_{0} \\\\edt \\\\sigma '\\n + 2 \\\\phi_{1} \\\\edt \\\\tau \
'\\\\nonumber\\\\\\\\\\n& + \\\\edt \\\\tho \\\\phi_{2}\\n -  \\\\edt \
\\\\edtp \\\\phi_{1}\\n -  \\\\bar{\\\\rho}' \\\\edtp \\\\phi_{0}\\n -  \
\\\\tau \\\\edtp \\\\phi_{1}\\n + \\\\bar{\\\\tau}' \\\\edtp \\\\phi_{1}\\n + \
\\\\sigma \\\\edtp \\\\phi_{2}\\n + \\\\phi_{0} \\\\edtp \\\\rho \
'\\\\nonumber\\\\\\\\\\n& + \\\\phi_{2} \\\\edtp \\\\sigma\\n - 2 \\\\phi_{1} \
\\\\edtp \\\\tau\\n -  \\\\edtp \\\\thop \\\\phi_{0}\\n + \\\\edtp \\\\edt \\\
\\phi_{1}.\\n\\\\end{align}\"\>"], "Output",
 CellChangeTimes->{3.97546753760585*^9, 3.9754679360377607`*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"b1658595-bf2b-429e-b7a1-b945e0c59364"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Factorization", "Subsection",
 CellChangeTimes->{{3.6426527404398746`*^9, 3.6426527428598785`*^9}, {
  3.644123828893369*^9, 
  3.6441238315594783`*^9}},ExpressionUUID->"a34cc35f-7d59-4126-a611-\
887a3b309655"],

Cell[TextData[{
 "Sometimes NP/GHP equations become very long and a factorized form improves \
the presentation. The function InertScalarOp prevents ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from expanding factors. The function does not factor automatically and an \
Ansatz for a factorization needs to be compared to actual results."
}], "Text",
 CellChangeTimes->{{3.648193962277698*^9, 3.6481941656529446`*^9}, {
  3.6481941984978456`*^9, 
  3.6481942277218113`*^9}},ExpressionUUID->"f903c78a-a1ae-4d0a-8244-\
5183df13531f"],

Cell["\<\
With InertScalarOp one can give operators in factored form that can be \
printed without expanding it.\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
  3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
  3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
  3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
  3.6442142665173736`*^9}, {3.645008837831534*^9, 
  3.64500893492167*^9}},ExpressionUUID->"d4bde1bb-be20-48b5-83a4-\
edf30e2a8a6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InertScalarOp", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"\[CapitalTheta]Dyad", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", "x", "]"}], "+", 
     RowBox[{"3", 
      RowBox[{"\[Rho]Dyad", "[", "]"}], "*", "x"}]}]}], "]"}], "@", 
  RowBox[{
   RowBox[{"InertScalarOp", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"\[CapitalTheta]Dyad", "[", 
        RowBox[{"{", 
         RowBox[{"4", ",", 
          RowBox[{"-", "NP"}]}], "}"}], "]"}], "[", "x", "]"}], "+", " ", 
      RowBox[{
       RowBox[{"\[Tau]pDyad", "[", "]"}], "*", "x"}]}]}], "]"}], "[", 
   RowBox[{"phi20", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "Dyad"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "Dyad"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.64403503540394*^9, 3.644035045853955*^9}, {
   3.6440351158140526`*^9, 3.6440351435640917`*^9}, {3.644035201054172*^9, 
   3.6440352084041824`*^9}, {3.6440352488642387`*^9, 3.644035250844242*^9}, {
   3.6440355245846252`*^9, 3.644035551004662*^9}, {3.644035626094767*^9, 
   3.644035636554782*^9}, {3.6440364362869015`*^9, 3.6440364768569584`*^9}, 
   3.644122914253016*^9, {3.644242029899448*^9, 3.644242031977685*^9}, {
   3.6442421634986467`*^9, 3.644242186968651*^9}, {3.6442422577966723`*^9, 
   3.6442422638282137`*^9}, 3.6442423070336475`*^9},
 CellLabel->"In[50]:=",ExpressionUUID->"e2afd375-a979-42d7-95bb-aabe2f151cc3"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      InterpretationBox[
       StyleBox["\[Thorn]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][$CellContext`x],
       Editable->False], "+", 
      RowBox[{"3", " ", 
       InterpretationBox[
        StyleBox["\[Rho]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[Rho]Dyad[],
        Editable->False]}]}], ")"}], 
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         InterpretationBox[
          StyleBox[
           RowBox[{"\[Eth]", "'"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[CapitalTheta]Dyad[{
           4, -$CellContext`NP}][$CellContext`x],
          Editable->False], "+", 
         InterpretationBox[
          StyleBox[
           RowBox[{"\[Tau]", "'"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`\[Tau]pDyad[],
          Editable->False]}], ")"}], 
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Phi]", "0"],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
        Editable->False]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`SpinFrames`InertScalarOp[$CellContext`x, $CellContext`\
\[CapitalTheta]Dyad[{
        4, -$CellContext`NP}][$CellContext`x] + $CellContext`\[Tau]pDyad[] \
$CellContext`x][
      $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
     Editable->False]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`SpinFrames`InertScalarOp[$CellContext`x, \
$CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][$CellContext`x] + 
   3 $CellContext`\[Rho]Dyad[] $CellContext`x][
   xAct`SpinFrames`InertScalarOp[$CellContext`x, \
$CellContext`\[CapitalTheta]Dyad[{
      4, -$CellContext`NP}][$CellContext`x] + $CellContext`\[Tau]pDyad[] \
$CellContext`x][
    $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]]],
  Editable->False]], "Output",
 CellChangeTimes->{{3.6440351314240746`*^9, 3.6440352089441833`*^9}, {
   3.6440352512542424`*^9, 3.6440352755642767`*^9}, 3.6440353193443375`*^9, 
   3.6440353527443843`*^9, {3.6440355434046516`*^9, 3.6440355513346624`*^9}, {
   3.6440356301447725`*^9, 3.6440356370347824`*^9}, 3.644036438796905*^9, {
   3.644036477376959*^9, 3.6440364907269773`*^9}, 3.6440367408073277`*^9, {
   3.644122887328826*^9, 3.6441229156079206`*^9}, 3.644241752904113*^9, 
   3.6442418000472603`*^9, 3.6442419908660808`*^9, 3.6442420328839493`*^9, {
   3.6442421455757833`*^9, 3.6442421650611973`*^9}, 3.644242308189962*^9, 
   3.6443148997654133`*^9, 3.644315005395561*^9, 3.6443150571456337`*^9, 
   3.6443164913886414`*^9, 3.6443165406087103`*^9, 3.6443167141889534`*^9, 
   3.644939821371643*^9, 3.6449402797532854`*^9, 3.6449403727834153`*^9, 
   3.6449404476835203`*^9, 3.6450048777617984`*^9, 3.645008736961393*^9, 
   3.6450100253631964`*^9, 3.645010075243266*^9, 3.6450104466437864`*^9, 
   3.645010516513884*^9, 3.6450105723339624`*^9, 3.6450106436540623`*^9, 
   3.6450108869254026`*^9, 3.6450111052057085`*^9, 3.6464533593958793`*^9, 
   3.64731901397299*^9, 3.6473199109857683`*^9, 3.6473287927713366`*^9, 
   3.647328855091424*^9, 3.6473337125099893`*^9, 3.6477031306191177`*^9, 
   3.6477507651885767`*^9, 3.647751420840685*^9, 3.6477523504289117`*^9, 
   3.647777262353524*^9, 3.647790798956889*^9, 3.647792253181508*^9, 
   3.64818316973258*^9, 3.648188509908589*^9, 3.6481916728593316`*^9, 
   3.648193311825059*^9, 3.648209874544718*^9, 3.6482102159198427`*^9, 
   3.6482640225182047`*^9, 3.6482643021024294`*^9, 3.6482651133859186`*^9, 
   3.648349874743828*^9, 3.64835091924629*^9, 3.648352605299651*^9, 
   3.6491725517864943`*^9, 3.6491726673366556`*^9, 3.728210474804183*^9, 
   3.728793138286477*^9, 3.9561929546251717`*^9, 3.9561938312954884`*^9, 
   3.975464941355907*^9, 3.9754649861141644`*^9, 3.9754660278483*^9, 
   3.9754675376301117`*^9, 3.975467936071*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"0681dc4f-fd35-4c67-b9ab-43eaa1042002"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TexPrint", "@", "%"}]], "Input",
 CellChangeTimes->{{3.6440353682744064`*^9, 3.644035371594411*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"191581be-3498-4d2c-8593-6edb44eb991f"],

Cell[BoxData["\<\"(\\\\tho + 3 \\\\rho)(\\\\edtp + \\\\tau \
')\\\\phi_{0}\"\>"], "Output",
 CellChangeTimes->{
  3.6440353717344112`*^9, 3.644035553264665*^9, {3.6440364786869607`*^9, 
   3.6440364914969788`*^9}, 3.6440367408473277`*^9, {3.644122891199411*^9, 
   3.644122917745345*^9}, 3.6442417532166295`*^9, 3.644241800359775*^9, 
   3.6442419912098475`*^9, 3.6442420347590528`*^9, 3.6442421463102283`*^9, 
   3.6442423101431894`*^9, 3.6443148997654133`*^9, 3.6443150054055614`*^9, 
   3.644315057155634*^9, 3.6443164913986416`*^9, 3.6443165406187105`*^9, 
   3.6443167141889534`*^9, 3.644939821371643*^9, 3.6449402797532854`*^9, 
   3.644940372793415*^9, 3.6449404476935205`*^9, 3.645004877771798*^9, 
   3.6450087369713926`*^9, 3.6450100253731966`*^9, 3.645010075243266*^9, 
   3.645010446673786*^9, 3.645010516523884*^9, 3.645010572343962*^9, 
   3.645010643684062*^9, 3.645010886945403*^9, 3.6450111052157087`*^9, 
   3.6464533596960783`*^9, 3.647319014019866*^9, 3.64731991101702*^9, 
   3.6473287927713366`*^9, 3.6473288551014237`*^9, 3.6473337125500174`*^9, 
   3.647703130663146*^9, 3.6477507652143817`*^9, 3.6477514208719354`*^9, 
   3.6477523504659357`*^9, 3.647777262384776*^9, 3.6477907989969163`*^9, 
   3.647792253219534*^9, 3.648183169810704*^9, 3.648188509971095*^9, 
   3.648191672874943*^9, 3.6481933119031925`*^9, 3.6482098745603456`*^9, 
   3.648210215951113*^9, 3.6482640225963316`*^9, 3.6482643021649213`*^9, 
   3.6482651134484277`*^9, 3.648349874743828*^9, 3.64835091924629*^9, 
   3.648352605309651*^9, 3.6491725518064938`*^9, 3.6491726673366556`*^9, 
   3.728210474804183*^9, 3.7287931383034782`*^9, 3.9561929546440945`*^9, 
   3.956193831307455*^9, 3.975464941388933*^9, 3.975464986156396*^9, 
   3.975466027881213*^9, 3.975467537669723*^9, 3.975467936103519*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"dfc0ceb7-ef44-405a-8785-7c785c56342c"]
}, Open  ]],

Cell["\<\
The InertScalarOp can be expanded by replacing it with Function.\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
  3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
  3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
  3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
  3.6442142665173736`*^9}, {3.645008837831534*^9, 3.645008901571623*^9}, {
  3.645008940691678*^9, 
  3.645008968761717*^9}},ExpressionUUID->"3cf9dd14-f121-4d1e-8ee9-\
31880c28911b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%%", "/.", 
  RowBox[{"InertScalarOp", "\[Rule]", "Function"}]}]], "Input",
 CellChangeTimes->{{3.6440364921969795`*^9, 3.644036506757*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"801b6fa0-d0c1-4c1c-a1a7-48ef25887498"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"\[Tau]", "'"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Tau]pDyad[],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Thorn]", 
       SubscriptBox["\[Phi]", "0"]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
      $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     SubscriptBox["\[Phi]", "0"],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{"\[Thorn]", 
       RowBox[{"\[Tau]", "'"}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
      $CellContext`\[Tau]pDyad[]],
     Editable->False], ")"}]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{"\[Thorn]", 
     RowBox[{"\[Eth]", "'"}], 
     SubscriptBox["\[Phi]", "0"]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[CapitalTheta]Dyad[{1, -$CellContext`NP}][
    $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
     $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]]],
   Editable->False], "+", 
  RowBox[{"3", " ", 
   InterpretationBox[
    StyleBox["\[Rho]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[Rho]Dyad[],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", "0"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[Tau]", "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyad[],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{"\[Eth]", "'"}], 
        SubscriptBox["\[Phi]", "0"]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyad[{4, -$CellContext`NP}][
       $CellContext`phi20[{0, -$CellContext`Dyad}, {0, -$CellContext`Dyad}]],
      Editable->False]}], ")"}]}]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBwBOJtJ5I2F6m9dhQSnnMBRP8TmfV0DpBekqf++hqQ9mrm
+QiiJcxfcFwHyXs184Ho4twEGRB9ZOoLAxAtrVS56BeQdvdZux5Ef/mlsg1E
zxDOzfwNpNPkpuSD6Cuxbq0gOsdszVFtjdeOV3N+/APRDeyzuHSAdJDhN2EQ
Xceys9MbSE9Kl8/xBdKqzjq8fkD6kFSGMIhuML7mCKKniE70AtF7GbsDQfTa
9rIosPiTexUgmtFSfQqIZn/07Syf9mvHfUoHa7bqvHYs6H74BkRvY5B03gWk
79o99gLRnJ+EVu0B0qYVYdyFuq8dbe4s9+0A0q/S5s4H0QICF4Q7gbREwFnb
qUB6yZW3N2cD6Z2mK/rnAOmsj9YF0XqvHT0mH+SOA9Jd/2WmxwNp7ee8KQlA
uvFdUFUGkE55/28JiLaZevVVE5DmPn6ctxlI90UaFIPoGPmIa2uA9JyHzyPW
AukpVqu01wHpHQq/OuwMXjueE8+eDqK/2US5/j/22lE5yeuY9InXjmvOhly/
VvnWccr3ly7XgbT7xLV/Z8x763h+shvzTCC9zbO2FUSL3TNzmgWki8NZSkA0
AK7G/ZE=
  "],
 CellLabel->"Out[52]=",ExpressionUUID->"e1a513e4-f17b-4b02-ab59-5715faad0ba2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Several dyads", "Subsection",
 CellChangeTimes->{{3.6449397872815957`*^9, 
  3.644939800971615*^9}},ExpressionUUID->"95aac77b-f4ce-4af9-b48e-\
67223debf492"],

Cell["\<\
The package allows several tetrads and dyads simultaneously. The display form \
and Tex output for all symbols can be modified with SymbolFormattingFunction \
and SymbolTexFunction as shown below.  \
\>", "Text",
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
   3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
   3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
   3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
   3.6442142665173736`*^9}, {3.645008837831534*^9, 3.645008901571623*^9}, {
   3.645008940691678*^9, 3.6450090333518076`*^9}, {3.6450090854018803`*^9, 
   3.6450092097520547`*^9}, 3.647779339069558*^9, {3.648186857141139*^9, 
   3.6481869118109217`*^9}},ExpressionUUID->"9fe13ca8-f439-41b9-8c27-\
df49f7505d76"],

Cell["\<\
Define a new tetrad (NPt) and Dyad (Dyadt) with a formatting function which \
adds a tilde on top of all quantities projected wrt. to these frames.\
\[LineSeparator]Since version 0.5.6 DefSpinDyad has separate formatting \
functions for the base symbols and the indices.\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
   3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
   3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
   3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
   3.6442142665173736`*^9}, {3.645008837831534*^9, 3.645008901571623*^9}, {
   3.645008940691678*^9, 3.6450090333518076`*^9}, {3.6450090854018803`*^9, 
   3.6450092097520547`*^9}, 3.647779339069558*^9, {3.648187327140538*^9, 
   3.648187432516127*^9}, 3.9754650744113092`*^9, {3.9754651909289627`*^9, 
   3.9754652380270357`*^9}},ExpressionUUID->"7d9d7452-2d41-43d3-94e6-\
a9afc24fde52"],

Cell[BoxData[
 RowBox[{"DefNPTetrad", "[", 
  RowBox[{"NPt", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"lNPt", "[", "a", "]"}], ",", 
     RowBox[{"nNPt", "[", "a", "]"}], ",", 
     RowBox[{"mNPt", "[", "a", "]"}]}], "}"}], ",", 
   RowBox[{"SymbolFormattingFunction", "\[Rule]", "TildeString"}], ",", 
   RowBox[{"SymbolTexFunction", "\[Rule]", "TexTilde"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6449398819917283`*^9, 3.64493989033174*^9}, {
   3.6449400242129273`*^9, 3.6449400612129793`*^9}, {3.6473198752070055`*^9, 
   3.6473198821917114`*^9}, 3.6473288243613806`*^9},
 CellLabel->"In[53]:=",ExpressionUUID->"2452c513-9c27-464c-abf7-49c86c2ffeb7"],

Cell[BoxData[
 RowBox[{"DefSpinDyad", "[", 
  RowBox[{"Dyadt", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ot", "[", "A", "]"}], ",", 
     RowBox[{"\[Iota]t", "[", "A", "]"}]}], "}"}], ",", "NPt", ",", 
   RowBox[{"SymbolFormattingFunction", "\[Rule]", "TildeString"}], ",", 
   RowBox[{"IndexFormattingFunction", "\[Rule]", "TildeString"}], ",", 
   RowBox[{"SymbolTexFunction", "\[Rule]", "TexTilde"}], ",", 
   RowBox[{"IndexTexFunction", "\[Rule]", "TexTilde"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6070931774224405`*^9, 3.6070931911724596`*^9}, {
   3.644940284493292*^9, 3.644940297993311*^9}, {3.6473198888014636`*^9, 
   3.6473198889733477`*^9}, 3.647328829001387*^9, {3.975465030255147*^9, 
   3.975465052532188*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"dd0d8167-66b7-4946-a8c1-157eae7e2822"],

Cell["\<\
Define another new tetrad (NPg) and Dyad (Dyadg) with a formatting function \
which colors quantities projected wrt. to these frames in green.\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
   3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
   3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
   3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
   3.6442142665173736`*^9}, {3.645008837831534*^9, 3.645008901571623*^9}, {
   3.645008940691678*^9, 3.6450090333518076`*^9}, {3.6450090854018803`*^9, 
   3.6450092097520547`*^9}, 3.647779339069558*^9, {3.648187327140538*^9, 
   3.6481875180821576`*^9}},ExpressionUUID->"f081c2c5-edd0-4da9-bf76-\
11454eecafc9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EnableTexColor", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.6481930423863616`*^9, 3.648193045433426*^9}, 
   3.64819324854432*^9},
 CellLabel->"In[55]:=",ExpressionUUID->"5ddb2257-3947-4cc8-8c19-599639b6c62a"],

Cell[BoxData[
 RowBox[{"DefNPTetrad", "[", 
  RowBox[{"NPg", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"lNPg", "[", "a", "]"}], ",", 
     RowBox[{"nNPg", "[", "a", "]"}], ",", 
     RowBox[{"mNPg", "[", "a", "]"}]}], "}"}], ",", 
   RowBox[{"SymbolFormattingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ColorString", "[", 
       RowBox[{"#", ",", "Green"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"SymbolTexFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"TexColor", "[", 
       RowBox[{"#", ",", "Green"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6477032030984983`*^9, 3.6477032133593493`*^9}, {
   3.6477034579479356`*^9, 3.647703497023388*^9}, {3.647704078541627*^9, 
   3.6477040996463876`*^9}, {3.6477056905621614`*^9, 
   3.6477057174164686`*^9}, {3.6477505993693886`*^9, 
   3.6477506406252003`*^9}, {3.6477522716005697`*^9, 
   3.6477522733506303`*^9}, {3.648187261896317*^9, 3.648187268224774*^9}, {
   3.648187455009198*^9, 3.6481874607990522`*^9}, 3.6481926068504443`*^9, {
   3.6482101463271923`*^9, 3.648210169964353*^9}, {3.6483511359665937`*^9, 
   3.648351138066597*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"f1d2690b-2576-49cd-8d85-135087aab299"],

Cell[BoxData[
 RowBox[{"DefSpinDyad", "[", 
  RowBox[{"Dyadg", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"og", "[", "A", "]"}], ",", 
     RowBox[{"\[Iota]g", "[", "A", "]"}]}], "}"}], ",", "NPg", ",", 
   RowBox[{"SymbolFormattingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ColorString", "[", 
       RowBox[{"#", ",", "Green"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"IndexFormattingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ColorString", "[", 
       RowBox[{"#", ",", "Green"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"SymbolTexFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"TexColor", "[", 
       RowBox[{"#", ",", "Green"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"IndexTexFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"TexColor", "[", 
       RowBox[{"#", ",", "Green"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6070931774224405`*^9, 3.6070931911724596`*^9}, {
   3.644940284493292*^9, 3.644940297993311*^9}, {3.6473198888014636`*^9, 
   3.6473198889733477`*^9}, 3.647328829001387*^9, {3.6477506899497347`*^9, 
   3.6477507013253193`*^9}, {3.6477522756789083`*^9, 
   3.6477522775070972`*^9}, {3.6481872726468782`*^9, 3.648187279294857*^9}, {
   3.648187466471201*^9, 3.648187472424659*^9}, {3.648192572178027*^9, 
   3.6481925918581*^9}, 3.6482101976845493`*^9, {3.6483511416066017`*^9, 
   3.6483511427666035`*^9}, {3.975465284479342*^9, 3.975465303068561*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"d7b49cae-f4f2-4a9b-8805-b160dac72081"],

Cell["\<\
The index formatting functions are applied to all indices in the \
corresponding dyad. These functions can be changed by changing the following \
functions.\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
   3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
   3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
   3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
   3.6442142665173736`*^9}, {3.645008837831534*^9, 3.645008901571623*^9}, {
   3.645008940691678*^9, 3.6450090333518076`*^9}, {3.6450090854018803`*^9, 
   3.6450092097520547`*^9}, 3.647779339069558*^9, {3.648187327140538*^9, 
   3.6481875180821576`*^9}, {3.6481875842243357`*^9, 3.648187625179743*^9}, {
   3.9754656262352552`*^9, 3.975465653018458*^9}, {3.9754656910584707`*^9, 
   3.975465692602172*^9}, {3.975465867265374*^9, 3.975465896064926*^9}, {
   3.975465927752466*^9, 3.9754659756723003`*^9}, {3.975466068135133*^9, 
   3.975466093992999*^9}, {3.975467264355505*^9, 3.975467264827314*^9}, {
   3.9754676092114267`*^9, 3.975467633242811*^9}, {3.9754676734747953`*^9, 
   3.975467745786584*^9}, {3.975467839090333*^9, 
   3.975467908009932*^9}},ExpressionUUID->"2203c66a-b3ef-4f46-9c5e-\
29b7a23cd769"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DyadIndexFormattingFunction", "[", "Dyadt", "]"}], ",", 
   RowBox[{"DyadIndexTexFunction", "[", "Dyadt", "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.644940728063913*^9, 3.6449407467139387`*^9}, {
  3.6477032565581846`*^9, 3.647703258097211*^9}, {3.6477507391710434`*^9, 
  3.6477507403898892`*^9}, {3.6481875299962997`*^9, 3.6481875301056814`*^9}, {
  3.648187562278304*^9, 3.648187562387682*^9}, {3.975467758419305*^9, 
  3.97546781272329*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"4d48469b-2313-435c-90c9-3de399045149"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"TildeString", ",", "TexTilde"}], "}"}]], "Output",
 CellChangeTimes->{{3.6449407442039356`*^9, 3.6449407471139393`*^9}, 
   3.645004879571801*^9, 3.645008738461395*^9, 3.645010026933199*^9, 
   3.6450104481437883`*^9, 3.645010517893886*^9, 3.645010573783964*^9, 
   3.6450106450940638`*^9, 3.6450108885554047`*^9, 3.6450111066757107`*^9, 
   3.646453361960589*^9, 3.6473190165043716`*^9, 3.6473199135640297`*^9, 
   3.6473200665543747`*^9, 3.647328794581339*^9, 3.6473288565414257`*^9, 
   3.647333714250152*^9, 3.647703132753542*^9, 3.6477032593970795`*^9, 
   3.647750768464553*^9, 3.647751424465874*^9, 3.647752354026313*^9, 
   3.647777265759951*^9, 3.6477908039053087`*^9, 3.6477922571854124`*^9, 
   3.64818318137381*^9, 3.6481885221039543`*^9, 3.648191676328247*^9, 
   3.6481933274352474`*^9, 3.6482098782636633`*^9, 3.6482102191231337`*^9, 
   3.6482640339632835`*^9, 3.6482643135561433`*^9, 3.6482651249871197`*^9, 
   3.6483498773538313`*^9, 3.6483509218562937`*^9, 3.648352608049655*^9, 
   3.649172572956524*^9, 3.6491726699666595`*^9, 3.7282104772027774`*^9, 
   3.728793140966631*^9, 3.9561929669681664`*^9, 3.9561938332911816`*^9, 
   3.975465316608124*^9, 3.97546602963413*^9, 3.97546753956266*^9, {
   3.975467796920475*^9, 3.975467813339408*^9}, 3.975467937881507*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"0eab92d9-0bde-4304-9882-9cfe626c216b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DyadIndexFormattingFunction", "[", "Dyadg", "]"}], ",", 
   RowBox[{"DyadIndexTexFunction", "[", "Dyadg", "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.975467821115189*^9, 3.975467822387033*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"45df25f6-0220-461f-8b8c-941af85558e6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"ColorString", "[", 
     RowBox[{"#1", ",", "Green"}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{"TexColor", "[", 
     RowBox[{"#1", ",", "Green"}], "]"}], "&"}]}], "}"}]], "Output",
 CellChangeTimes->{3.97546782269624*^9, 3.975467937911497*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"7496d56f-b3ae-404e-9116-78fe51e766f1"]
}, Open  ]],

Cell["\<\
An expansion of a valence (2,0)-spinor into the new dyads looks like this:\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
   3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
   3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
   3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
   3.6442142665173736`*^9}, {3.645008837831534*^9, 3.645008901571623*^9}, {
   3.645008940691678*^9, 3.6450090333518076`*^9}, {3.6450090854018803`*^9, 
   3.6450092097520547`*^9}, 3.647779339069558*^9, {3.648187327140538*^9, 
   3.6481875180821576`*^9}, {3.6481875842243357`*^9, 3.648187625179743*^9}, {
   3.9754656262352552`*^9, 3.975465653018458*^9}, {3.9754656910584707`*^9, 
   3.975465692602172*^9}, {3.975465867265374*^9, 3.975465896064926*^9}, {
   3.975465927752466*^9, 3.9754659756723003`*^9}, {3.975466068135133*^9, 
   3.975466093992999*^9}, {3.975467264355505*^9, 3.975467264827314*^9}, {
   3.9754676092114267`*^9, 3.975467633242811*^9}, {3.9754676734747953`*^9, 
   3.975467715034634*^9}},ExpressionUUID->"a3cdc653-fbf0-4cfa-9d02-\
5528dd6d8910"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DyadExpansionEq", "[", 
  RowBox[{"phi20", ",", "Dyadt"}], "]"}]], "Input",
 CellChangeTimes->{{3.644940728063913*^9, 3.6449407467139387`*^9}, {
  3.6477032565581846`*^9, 3.647703258097211*^9}, {3.6477507391710434`*^9, 
  3.6477507403898892`*^9}, {3.6481875299962997`*^9, 3.6481875301056814`*^9}, {
  3.648187562278304*^9, 3.648187562387682*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"611f0f1b-4e85-4486-89fd-8620aab325f1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", "phi20", 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm[
  "GHP weights for ", $CellContext`phi20, " components are generated, ", 
   "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.647328794391339*^9, 3.6473288564714255`*^9, 
  3.6473337141911106`*^9, 3.647703132679492*^9, 3.6477032593430424`*^9, 
  3.6477507684176736`*^9, 3.647751424418996*^9, 3.6477523539772816`*^9, 
  3.6477772657130737`*^9, 3.647790803687165*^9, 3.6477922571373816`*^9, 
  3.6481831812175517`*^9, 3.6481885219476967`*^9, 3.648191676281371*^9, 
  3.6481933272633576`*^9, 3.6482098782011585`*^9, 3.6482102190606337`*^9, 
  3.6482640337601433`*^9, 3.6482643133373766`*^9, 3.6482651247683563`*^9, 
  3.6483498773038316`*^9, 3.648350921806294*^9, 3.648352607999655*^9, 
  3.6491725728965235`*^9, 3.6491726699366593`*^9, 3.728210477139268*^9, 
  3.728793140900627*^9, 3.9561929669132843`*^9, 3.9561938332492905`*^9, 
  3.975465316549129*^9, 3.975466029581299*^9, 3.9754675394923153`*^9, 
  3.975467937942717*^9},
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"f9421142-1d21-4f99-95db-0f4d3aee4517"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "phi20", "\[InvisibleSpace]", "\<\" is expanded into \"\>", "\[InvisibleSpace]",
    "Dyadt"}],
  SequenceForm[$CellContext`phi20, " is expanded into ", $CellContext`Dyadt],
  Editable->False]], "Print",
 CellChangeTimes->{3.647328794391339*^9, 3.6473288564714255`*^9, 
  3.6473337141911106`*^9, 3.647703132679492*^9, 3.6477032593430424`*^9, 
  3.6477507684176736`*^9, 3.647751424418996*^9, 3.6477523539772816`*^9, 
  3.6477772657130737`*^9, 3.647790803687165*^9, 3.6477922571373816`*^9, 
  3.6481831812175517`*^9, 3.6481885219476967`*^9, 3.648191676281371*^9, 
  3.6481933272633576`*^9, 3.6482098782011585`*^9, 3.6482102190606337`*^9, 
  3.6482640337601433`*^9, 3.6482643133373766`*^9, 3.6482651247683563`*^9, 
  3.6483498773038316`*^9, 3.648350921806294*^9, 3.648352607999655*^9, 
  3.6491725728965235`*^9, 3.6491726699366593`*^9, 3.728210477139268*^9, 
  3.728793140900627*^9, 3.9561929669132843`*^9, 3.9561938332492905`*^9, 
  3.975465316549129*^9, 3.975466029581299*^9, 3.9754675394923153`*^9, 
  3.9754679379713783`*^9},
 CellLabel->
  "During evaluation of \
In[60]:=",ExpressionUUID->"f8fe1532-9ba3-4f7f-9023-fc4a9c3459d2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Phi]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`phi20[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["2", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["1", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["1", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`B],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["0", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`B],
     Editable->False]}]}]}]], "Output",
 CellChangeTimes->{{3.6449407442039356`*^9, 3.6449407471139393`*^9}, 
   3.645004879571801*^9, 3.645008738461395*^9, 3.645010026933199*^9, 
   3.6450104481437883`*^9, 3.645010517893886*^9, 3.645010573783964*^9, 
   3.6450106450940638`*^9, 3.6450108885554047`*^9, 3.6450111066757107`*^9, 
   3.646453361960589*^9, 3.6473190165043716`*^9, 3.6473199135640297`*^9, 
   3.6473200665543747`*^9, 3.647328794581339*^9, 3.6473288565414257`*^9, 
   3.647333714250152*^9, 3.647703132753542*^9, 3.6477032593970795`*^9, 
   3.647750768464553*^9, 3.647751424465874*^9, 3.647752354026313*^9, 
   3.647777265759951*^9, 3.6477908039053087`*^9, 3.6477922571854124`*^9, 
   3.64818318137381*^9, 3.6481885221039543`*^9, 3.648191676328247*^9, 
   3.6481933274352474`*^9, 3.6482098782636633`*^9, 3.6482102191231337`*^9, 
   3.6482640339632835`*^9, 3.6482643135561433`*^9, 3.6482651249871197`*^9, 
   3.6483498773538313`*^9, 3.6483509218562937`*^9, 3.648352608049655*^9, 
   3.649172572956524*^9, 3.6491726699666595`*^9, 3.7282104772027774`*^9, 
   3.728793140966631*^9, 3.9561929669681664`*^9, 3.9561938332911816`*^9, 
   3.975465316608124*^9, 3.97546602963413*^9, 3.97546753956266*^9, 
   3.975467938172035*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"6ea281b2-ed20-4ef0-888a-68ce191a0c35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DyadExpansionEq", "[", 
  RowBox[{"phi20", ",", "Dyadg"}], "]"}]], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"a6e4de44-da99-4188-89eb-a16cc01bf9e9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", "phi20", 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm[
  "GHP weights for ", $CellContext`phi20, " components are generated, ", 
   "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6481885222133365`*^9, 3.6481916763595*^9, 
  3.648193327544634*^9, 3.6482098782949142`*^9, 3.648210219154386*^9, 
  3.6482640340570335`*^9, 3.648264313618641*^9, 3.6482651250652504`*^9, 
  3.6483498773638315`*^9, 3.648350921866294*^9, 3.6483526080796547`*^9, 
  3.649172572996524*^9, 3.6491726699766593`*^9, 3.7282104772082925`*^9, 
  3.728793140992632*^9, 3.9561929669771137`*^9, 3.956193833326084*^9, 
  3.975466111535598*^9, 3.975467539656172*^9, 3.975467938209073*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"2ebb5173-1bb5-481e-b3c3-20d2148b2628"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "phi20", "\[InvisibleSpace]", "\<\" is expanded into \"\>", "\[InvisibleSpace]",
    "Dyadg"}],
  SequenceForm[$CellContext`phi20, " is expanded into ", $CellContext`Dyadg],
  Editable->False]], "Print",
 CellChangeTimes->{3.6481885222133365`*^9, 3.6481916763595*^9, 
  3.648193327544634*^9, 3.6482098782949142`*^9, 3.648210219154386*^9, 
  3.6482640340570335`*^9, 3.648264313618641*^9, 3.6482651250652504`*^9, 
  3.6483498773638315`*^9, 3.648350921866294*^9, 3.6483526080796547`*^9, 
  3.649172572996524*^9, 3.6491726699766593`*^9, 3.7282104772082925`*^9, 
  3.728793140992632*^9, 3.9561929669771137`*^9, 3.956193833326084*^9, 
  3.975466111535598*^9, 3.975467539656172*^9, 3.975467938215788*^9},
 CellLabel->
  "During evaluation of \
In[61]:=",ExpressionUUID->"ca7fead2-2bc3-460e-bac2-133a61e1e45e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Phi]", 
       StyleBox[GridBox[{
          {" ", " "},
          {"A", "B"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`phi20[-$CellContext`A, -$CellContext`B],
   Editable->False], "\[Equal]", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         StyleBox["o",
          FontColor->RGBColor[0., 1., 0.]], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`og[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         StyleBox["o",
          FontColor->RGBColor[0., 1., 0.]], 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`og[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       StyleBox["2",
        FontColor->RGBColor[0., 1., 0.]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         StyleBox["o",
          FontColor->RGBColor[0., 1., 0.]], 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`og[-$CellContext`B],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       StyleBox["1",
        FontColor->RGBColor[0., 1., 0.]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         StyleBox["\[Iota]",
          FontColor->RGBColor[0., 1., 0.]], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]g[-$CellContext`A],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         StyleBox["o",
          FontColor->RGBColor[0., 1., 0.]], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`og[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       StyleBox["1",
        FontColor->RGBColor[0., 1., 0.]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         StyleBox["\[Iota]",
          FontColor->RGBColor[0., 1., 0.]], 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]g[-$CellContext`B],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       StyleBox["0",
        FontColor->RGBColor[0., 1., 0.]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         StyleBox["\[Iota]",
          FontColor->RGBColor[0., 1., 0.]], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]g[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         StyleBox["\[Iota]",
          FontColor->RGBColor[0., 1., 0.]], 
         StyleBox[GridBox[{
            {" "},
            {"B"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]g[-$CellContext`B],
     Editable->False]}]}]}]], "Output",
 CellChangeTimes->{3.6481885223695936`*^9, 3.648191676406378*^9, 
  3.6481933277165127`*^9, 3.648209878638683*^9, 3.648210219216889*^9, 
  3.648264034260169*^9, 3.6482643138530264`*^9, 3.6482651252840137`*^9, 
  3.6483498774138317`*^9, 3.648350921916294*^9, 3.648352608109655*^9, 
  3.649172573036524*^9, 3.6491726700366597`*^9, 3.728210477252616*^9, 
  3.7287931410556355`*^9, 3.9561929670499477`*^9, 3.9561938333679733`*^9, 
  3.975466111629644*^9, 3.9754675397213697`*^9, 3.9754679382425423`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"5eaf3cc6-3b3e-4b2e-b5a0-0be2005321c8"]
}, Open  ]],

Cell["\<\
Also full spinorial differential equations can be expanded directly(here the \
vacuum Maxwell equations):\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
   3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
   3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
   3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
   3.6442142665173736`*^9}, {3.645008837831534*^9, 3.645008901571623*^9}, {
   3.645008940691678*^9, 3.6450090333518076`*^9}, {3.6450090854018803`*^9, 
   3.6450092097520547`*^9}, 3.647779339069558*^9, {3.648187327140538*^9, 
   3.6481875180821576`*^9}, {3.6481875842243357`*^9, 3.648187625179743*^9}, {
   3.6481876875576143`*^9, 3.648187687854514*^9}, {3.648187719551789*^9, 
   3.6481877434266224`*^9}, {3.6481879656853275`*^9, 
   3.6481879668416357`*^9}},ExpressionUUID->"04007b84-f2d5-4f1b-b369-\
0d35441390cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToGHP", "[", 
  RowBox[{
   RowBox[{"0", "==", 
    RowBox[{
     RowBox[{"CurlDgCDe", "[", "phi20", "]"}], "[", 
     RowBox[{
      RowBox[{"-", "A"}], ",", 
      RowBox[{"-", "A\[Dagger]"}]}], "]"}]}], ",", "Dyadt"}], "]"}]], "Input",
 CellChangeTimes->{{3.644213458763792*^9, 3.644213464529729*^9}, {
   3.644213525111124*^9, 3.6442135252830057`*^9}, 3.6449405420036526`*^9, {
   3.6449405884337173`*^9, 3.644940593463724*^9}, 3.645008754521417*^9, 
   3.6450110747756653`*^9, 3.6477778666687922`*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"99d795c8-f495-4890-9107-ea048f402494"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", 
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm["GHP weights for ", 
   $CellContext`CurlDgCDe[$CellContext`phi20], " components are generated, ", 
   "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6477778676844406`*^9, 3.647790808548966*^9, 
  3.647792258798489*^9, 3.64818318719341*^9, 3.6481885224477267`*^9, 
  3.648191676422003*^9, 3.6481933278102617`*^9, 3.6482098786855583`*^9, 
  3.648210219232518*^9, 3.6482640344164276`*^9, 3.648264313931168*^9, 
  3.6482651253465157`*^9, 3.6483498774338317`*^9, 3.6483509219262943`*^9, 
  3.648352608139655*^9, 3.6491725730465236`*^9, 3.6491726700466595`*^9, 
  3.7282104772838297`*^9, 3.7287931410726366`*^9, 3.9561929725621796`*^9, 
  3.956193833408865*^9, 3.9754675397615557`*^9, 3.9754679382712727`*^9},
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"4a9e9b32-6d30-488d-b4ff-b5627ecd2377"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], 
   "\[InvisibleSpace]", "\<\" is expanded into \"\>", "\[InvisibleSpace]", 
   "Dyadt"}],
  SequenceForm[
   $CellContext`CurlDgCDe[$CellContext`phi20], 
   " is expanded into ", $CellContext`Dyadt],
  Editable->False]], "Print",
 CellChangeTimes->{3.6477778676844406`*^9, 3.647790808548966*^9, 
  3.647792258798489*^9, 3.64818318719341*^9, 3.6481885224477267`*^9, 
  3.648191676422003*^9, 3.6481933278102617`*^9, 3.6482098786855583`*^9, 
  3.648210219232518*^9, 3.6482640344164276`*^9, 3.648264313931168*^9, 
  3.6482651253465157`*^9, 3.6483498774338317`*^9, 3.6483509219262943`*^9, 
  3.648352608139655*^9, 3.6491725730465236`*^9, 3.6491726700466595`*^9, 
  3.7282104772838297`*^9, 3.7287931410726366`*^9, 3.9561929725621796`*^9, 
  3.956193833408865*^9, 3.9754675397615557`*^9, 3.975467938282694*^9},
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"79f450d6-573f-4ee3-9aab-fe8d15571edd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating the \"\>", "\[InvisibleSpace]", "Dyadt", 
   "\[InvisibleSpace]", "\<\"components of \"\>", "\[InvisibleSpace]", 
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], 
   "\[InvisibleSpace]", "\<\" in GHP form. (Improved code)\"\>"}],
  SequenceForm["Calculating the ", $CellContext`Dyadt, "components of ", 
   $CellContext`CurlDgCDe[$CellContext`phi20], 
   " in GHP form. (Improved code)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6477778676844406`*^9, 3.647790808548966*^9, 
  3.647792258798489*^9, 3.64818318719341*^9, 3.6481885224477267`*^9, 
  3.648191676422003*^9, 3.6481933278102617`*^9, 3.6482098786855583`*^9, 
  3.648210219232518*^9, 3.6482640344164276`*^9, 3.648264313931168*^9, 
  3.6482651253465157`*^9, 3.6483498774338317`*^9, 3.6483509219262943`*^9, 
  3.648352608139655*^9, 3.6491725730465236`*^9, 3.6491726700466595`*^9, 
  3.7282104772838297`*^9, 3.7287931410726366`*^9, 3.9561929725621796`*^9, 
  3.956193833408865*^9, 3.9754675397615557`*^9, 3.97546793830689*^9},
 CellLabel->
  "During evaluation of \
In[62]:=",ExpressionUUID->"762d5de9-b962-4928-b1f6-2d57e47e2f21"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     InterpretationBox[
      StyleBox[
       SubscriptBox["\[Phi]", 
        OverscriptBox["2", "~"]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
      Editable->False]}], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Kappa]", "~"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]Dyadt[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["0", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Kappa]", "~"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Kappa]pDyadt[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["2", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Rho]", "~"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyadt[],
     Editable->False]}], "+", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["1", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Rho]", "~"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]Dyadt[],
     Editable->False]}], "-", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["1", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Rho]", "~"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyadt[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["0", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Rho]", "~"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Rho]pDyadt[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["2", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Sigma]", "~"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]Dyadt[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["0", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Sigma]", "~"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Sigma]pDyadt[],
     Editable->False]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["2", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Tau]", "~"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyadt[],
     Editable->False]}], "-", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["1", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["\[Tau]", "~"],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]Dyadt[],
     Editable->False]}], "+", 
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["1", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Tau]", "~"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyadt[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      SubscriptBox["\[Phi]", 
       OverscriptBox["0", "~"]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Tau]", "~"], "'"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Tau]pDyadt[],
     Editable->False]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["2", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["0", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["o", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["2", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False], ")"}]}], "+", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["\[Iota]", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Eth]", "~"], "'"}], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["0", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}]],
      Editable->False], ")"}]}], "-", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox["o", "~"], 
         StyleBox[GridBox[{
            {" "},
            {"A"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`ot[-$CellContext`A],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         OverscriptBox[
          OverscriptBox["\[Iota]", "~"], "_"], 
         StyleBox[GridBox[{
            {" "},
            {
             RowBox[{"A", "'"}]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[Iota]t\[Dagger][-$CellContext`A\[Dagger]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Eth]", "~"], "'"}], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False], ")"}]}]}]}]], "Output",
 CellChangeTimes->{
  3.644213465701663*^9, 3.644213527642473*^9, 3.644241751966564*^9, 
   3.6442417992347155`*^9, 3.6442419900535374`*^9, 3.644314899545413*^9, 
   3.644315005005561*^9, 3.644315056775633*^9, 3.6443164909786415`*^9, 
   3.64431654019871*^9, 3.644316663408882*^9, 3.644316713758953*^9, 
   3.644939820911643*^9, 3.6449402792932844`*^9, 3.6449403723134146`*^9, 
   3.6449404472535195`*^9, 3.6449405483536615`*^9, {3.644940588863718*^9, 
   3.6449405996737328`*^9}, 3.6450048803018017`*^9, 3.645004959591913*^9, {
   3.645008738751395*^9, 3.6450087548314176`*^9}, 3.645010027393199*^9, 
   3.6450104486437893`*^9, 3.6450105183138866`*^9, 3.645010574243965*^9, 
   3.645010645534065*^9, 3.645010888985406*^9, 3.645011107075711*^9, 
   3.6464533628241644`*^9, 3.6473190174575443`*^9, 3.6473199144703255`*^9, 
   3.64732008256608*^9, 3.64732879519134*^9, 3.6473288569414263`*^9, 
   3.6473337148735723`*^9, 3.6477031332999067`*^9, 3.6477507690739565`*^9, 
   3.647751425575307*^9, 3.6477523553141727`*^9, 3.647777267228777*^9, 
   3.6477778680438347`*^9, 3.647790808953895*^9, 3.6477922591787443`*^9, 
   3.6481831884747257`*^9, 3.64818852343215*^9, 3.6481916767188945`*^9, 
   3.648193328801403*^9, 3.6482098789668236`*^9, 3.6482102195294056`*^9, 
   3.648264035385235*^9, 3.648264315009342*^9, 3.648265126393446*^9, 
   3.6483498776638317`*^9, 3.648350922166294*^9, 3.648352608369655*^9, 
   3.649172573296524*^9, 3.64917267028666*^9, 3.7282104775091*^9, 
   3.728793141335652*^9, 3.956192972795582*^9, 3.9561938335255527`*^9, 
   3.9754675398616962`*^9, 3.975467938342284*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"7f008244-af15-44c6-80c8-b2a6873aa2e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DyadComponents", "[", 
  RowBox[{"%", ",", "Dyadt"}], "]"}]], "Input",
 CellChangeTimes->{{3.644040319568876*^9, 3.6440403223139224`*^9}, {
   3.6443165247086887`*^9, 3.6443165283386936`*^9}, 3.645004969741927*^9, 
   3.6450087562114196`*^9, 3.6477778644030495`*^9},
 CellLabel->"In[63]:=",ExpressionUUID->"33ef013e-4915-4669-9f1c-1b0a463331f1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Phi]", 
          OverscriptBox["0", "~"]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["0", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["2", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Phi]", 
          OverscriptBox["2", "~"]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Eth]", "~"], "'"}], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["0", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}]],
      Editable->False]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Sigma]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["2", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`phi20[{1, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Eth]", "~"], "'"}], 
        SubscriptBox["\[Phi]", 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
       $CellContext`phi20[{0, -$CellContext`Dyadt}, {1, -$CellContext`Dyadt}]],
      Editable->False]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.644040323472694*^9, 3.6440555201608133`*^9, 3.6440560482939353`*^9, 
   3.644211198609189*^9, 3.644213486437147*^9, 3.6442135293925667`*^9, 
   3.6442417519821887`*^9, 3.6442417992503405`*^9, 3.6442419900847874`*^9, 
   3.644314899565413*^9, 3.644315005045561*^9, 3.6443150568156333`*^9, 
   3.6443164910986414`*^9, 3.64431654027871*^9, 3.6443166644188843`*^9, 
   3.644316713908953*^9, 3.644939821051643*^9, 3.6449402793832846`*^9, 
   3.644940372473415*^9, 3.6449404474035196`*^9, 3.645004880391802*^9, 
   3.645004970371928*^9, {3.6450087388413954`*^9, 3.6450087565314198`*^9}, 
   3.645010027483199*^9, 3.645010448723789*^9, 3.6450105183938866`*^9, 
   3.645010574323965*^9, 3.6450106456240644`*^9, 3.6450108890754056`*^9, 
   3.645011107155711*^9, 3.646453362938243*^9, 3.64731901758255*^9, 
   3.647319914595333*^9, 3.6473200899214244`*^9, 3.64732879527134*^9, 
   3.647328857021426*^9, 3.647333715001653*^9, 3.6477031334159837`*^9, 
   3.647750769198962*^9, 3.6477514257003117`*^9, 3.647752355446262*^9, 
   3.6477772673537846`*^9, 3.647777869606417*^9, 3.647790809329566*^9, 
   3.64779225951497*^9, 3.6481831893028903`*^9, 3.648188524213441*^9, 
   3.648191676828274*^9, 3.648193329676443*^9, 3.64820987909184*^9, 
   3.6482102196387854`*^9, 3.648264035900879*^9, 3.64826431550937*^9, 
   3.6482651270341043`*^9, 3.6483498777438326`*^9, 3.6483509222462945`*^9, 
   3.6483526084496555`*^9, 3.649172573366524*^9, 3.64917267035666*^9, 
   3.7282104776044383`*^9, 3.7287931414186563`*^9, 3.956192972934208*^9, 
   3.956193833594364*^9, 3.975467539915593*^9, 3.975467938400893*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"e48788d7-92be-44a8-ac69-d8282fce0de6"]
}, Open  ]],

Cell["The GHP form of the Bianchi identities in the dyad Dyadt:", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
   3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
   3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
   3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
   3.6442142665173736`*^9}, {3.645008837831534*^9, 3.645008901571623*^9}, {
   3.645008940691678*^9, 3.6450090333518076`*^9}, {3.6450090854018803`*^9, 
   3.6450092097520547`*^9}, 3.647779339069558*^9, {3.648187327140538*^9, 
   3.6481875180821576`*^9}, {3.6481875842243357`*^9, 3.648187625179743*^9}, {
   3.6481876875576143`*^9, 3.648187687854514*^9}, {3.648187719551789*^9, 
   3.6481877434266224`*^9}, {3.64818790599888*^9, 3.648187940233678*^9}, {
   3.6483511855466633`*^9, 
   3.648351185616663*^9}},ExpressionUUID->"e503a0d9-6bbc-4481-98f0-\
af00cdea42ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GHPBianchiRules", "[", "Dyadt", "]"}]], "Input",
 CellChangeTimes->{
  3.647792406251917*^9, 3.647792478173212*^9, {3.648187933601516*^9, 
   3.6481879337109256`*^9}, {3.648351189696669*^9, 3.6483511897666693`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"0a55cf75-202b-4dcb-8387-ebc5777b4a40"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Eth]", "~"], 
       SubscriptBox[
        OverscriptBox["\[CapitalPsi]", "~"], 
        OverscriptBox["1", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
      $CellContext`PsiCDe1Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe02Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe0Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe02Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["0", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PsiCDe0Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe01Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Eth]", "~"], 
       SubscriptBox[
        OverscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], "_"], 
        OverscriptBox["1", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
      $CellContext`PsiCDe1Dyadt\[Dagger][]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe0Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          OverscriptBox["\[Thorn]", "~"], "\[CapitalLambda]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
         $CellContext`LambdaCDe[]],
        Editable->False], ")"}]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PsiCDe2Dyadt\[Dagger][]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe00Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe10Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Eth]", "~"], 
       SubscriptBox[
        OverscriptBox["\[CapitalPsi]", "~"], 
        OverscriptBox["2", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
      $CellContext`PsiCDe2Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe0Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe02Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe12Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PsiCDe1Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "\[CapitalLambda]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`LambdaCDe[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe11Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Eth]", "~"], 
       SubscriptBox[
        OverscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], "_"], 
        OverscriptBox["2", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
      $CellContext`PsiCDe2Dyadt\[Dagger][]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["4", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe4Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe02Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["3", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PsiCDe3Dyadt\[Dagger][]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe01Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "\[CapitalLambda]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`LambdaCDe[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe11Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Eth]", "~"], 
       SubscriptBox[
        OverscriptBox["\[CapitalPsi]", "~"], 
        OverscriptBox["3", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
      $CellContext`PsiCDe3Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["4", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe4Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe22Dyadt[]],
      Editable->False], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           OverscriptBox["\[Thorn]", "~"], "'"}], "\[CapitalLambda]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
         $CellContext`LambdaCDe[]],
        Editable->False], ")"}]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PsiCDe2Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe21Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       OverscriptBox["\[Eth]", "~"], 
       SubscriptBox[
        OverscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], "_"], 
        OverscriptBox["3", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
      $CellContext`PsiCDe3Dyadt\[Dagger][]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["4", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe4Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe02Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["4", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PsiCDe4Dyadt\[Dagger][]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe02Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe12Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPhi]", "~"], 
        RowBox[{
         OverscriptBox["0", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], "'"}]}]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PhiCDe00Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Sigma]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe0Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe10Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PsiCDe1Dyadt\[Dagger][]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["0", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PsiCDe0Dyadt\[Dagger][]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPhi]", "~"], 
        RowBox[{
         OverscriptBox["0", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], "'"}]}]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PhiCDe01Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe02Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Sigma]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          OverscriptBox["\[Thorn]", "~"], "\[CapitalLambda]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
         $CellContext`LambdaCDe[]],
        Editable->False], ")"}]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe11Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe00Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe10Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPhi]", "~"], 
        RowBox[{
         OverscriptBox["0", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], "'"}]}]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PhiCDe02Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe02Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe02Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe12Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe01Dyadt[]],
      Editable->False], "+", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          OverscriptBox["\[Eth]", "~"], "\[CapitalLambda]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
         $CellContext`LambdaCDe[]],
        Editable->False], ")"}]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe11Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPhi]", "~"], 
        RowBox[{
         OverscriptBox["1", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], "'"}]}]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PhiCDe11Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Sigma]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Sigma]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe21Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe10Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe20Dyadt[]],
      Editable->False], "+", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           OverscriptBox["\[Eth]", "~"], "'"}], "\[CapitalLambda]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
         $CellContext`LambdaCDe[]],
        Editable->False], ")"}]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPhi]", "~"], 
        RowBox[{
         OverscriptBox["1", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], "'"}]}]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PhiCDe12Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe02Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Sigma]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe22Dyadt[]],
      Editable->False], "+", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           OverscriptBox["\[Thorn]", "~"], "'"}], "\[CapitalLambda]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
         $CellContext`LambdaCDe[]],
        Editable->False], ")"}]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe11Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe21Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPhi]", "~"], 
        RowBox[{
         OverscriptBox["2", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], "'"}]}]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PhiCDe22Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Sigma]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["4", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe4Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe21Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["3", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PsiCDe3Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["4", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PsiCDe4Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPsi]", "~"], 
        OverscriptBox["0", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PsiCDe0Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe02Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe0Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe01Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PsiCDe1Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe00Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPsi]", "~"], 
        OverscriptBox["1", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PsiCDe1Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox[
          OverscriptBox["\[CapitalPhi]", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], 
           RowBox[{
            OverscriptBox["1", "~"], "'"}]}]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PhiCDe21Dyadt[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Sigma]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe0Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Sigma]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe01Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], "\[CapitalLambda]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`LambdaCDe[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe11Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PsiCDe2Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe10Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], "_"], 
        OverscriptBox["1", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PsiCDe1Dyadt\[Dagger][]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe0Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Sigma]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Sigma]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["0", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe00Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Sigma]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe20Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["0", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PsiCDe0Dyadt\[Dagger][]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Eth]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
       $CellContext`PhiCDe10Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPsi]", "~"], 
        OverscriptBox["2", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PsiCDe2Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["4", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe4Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Kappa]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Kappa]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Sigma]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Tau]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PhiCDe21Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["3", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PsiCDe3Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe20Dyadt[]],
      Editable->False], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           OverscriptBox["\[Eth]", "~"], "'"}], "\[CapitalLambda]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
         $CellContext`LambdaCDe[]],
        Editable->False], ")"}]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], "_"], 
        OverscriptBox["2", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PsiCDe2Dyadt\[Dagger][]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox[
          OverscriptBox["\[CapitalPhi]", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], 
           RowBox[{
            OverscriptBox["0", "~"], "'"}]}]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PhiCDe00Dyadt[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["0", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe0Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Sigma]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe10Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["1", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PsiCDe1Dyadt\[Dagger][]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe20Dyadt[]],
      Editable->False], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           OverscriptBox["\[Eth]", "~"], "'"}], "\[CapitalLambda]"}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
         $CellContext`LambdaCDe[]],
        Editable->False], ")"}]}]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox["\[CapitalPsi]", "~"], 
        OverscriptBox["3", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PsiCDe3Dyadt[]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["4", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe4Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Rho]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Sigma]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Sigma]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Sigma]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Tau]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadt[],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Thorn]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], 
         OverscriptBox["4", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{1, -$CellContext`NPt}][
       $CellContext`PsiCDe4Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe20Dyadt[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Eth]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
       $CellContext`PhiCDe21Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], "_"], 
        OverscriptBox["3", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PsiCDe3Dyadt\[Dagger][]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox[
          OverscriptBox["\[CapitalPhi]", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], 
           RowBox[{
            OverscriptBox["1", "~"], "'"}]}]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PhiCDe01Dyadt[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe10Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["1", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe1Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Rho]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["4", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe4Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Sigma]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe20Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], "\[CapitalLambda]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`LambdaCDe[]],
      Editable->False], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe11Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PsiCDe2Dyadt\[Dagger][]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe21Dyadt[]],
      Editable->False]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{
        OverscriptBox["\[Eth]", "~"], "'"}], 
       SubscriptBox[
        OverscriptBox[
         OverscriptBox["\[CapitalPsi]", "~"], "_"], 
        OverscriptBox["4", "~"]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`\[CapitalTheta]Dyadt[{4, -$CellContext`NPt}][
      $CellContext`PsiCDe4Dyadt\[Dagger][]],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox[
          OverscriptBox["\[CapitalPhi]", "~"], 
          RowBox[{
           OverscriptBox["0", "~"], 
           RowBox[{
            OverscriptBox["2", "~"], "'"}]}]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PhiCDe02Dyadt[],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Kappa]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe11Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["2", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe2Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Kappa]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe12Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox["\[Rho]", "~"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt[],
       Editable->False]}], "-", 
     RowBox[{"4", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["3", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe3Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Rho]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadt\[Dagger][],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["1", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe21Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         OverscriptBox[
          OverscriptBox["\[Sigma]", "~"], "_"], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadt\[Dagger][],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PhiCDe22Dyadt[],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox["\[Tau]", "~"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["4", "~"]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`PsiCDe4Dyadt\[Dagger][],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         OverscriptBox["\[Tau]", "~"], "_"],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]Dyadt\[Dagger][],
       Editable->False]}], "-", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["1", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PhiCDe12Dyadt[]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        RowBox[{
         OverscriptBox["\[Thorn]", "~"], "'"}], 
        SubscriptBox[
         OverscriptBox[
          OverscriptBox["\[CapitalPsi]", "~"], "_"], 
         OverscriptBox["3", "~"]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{2, -$CellContext`NPt}][
       $CellContext`PsiCDe3Dyadt\[Dagger][]],
      Editable->False], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        OverscriptBox["\[Eth]", "~"], 
        SubscriptBox[
         OverscriptBox["\[CapitalPhi]", "~"], 
         RowBox[{
          OverscriptBox["2", "~"], 
          RowBox[{
           OverscriptBox["2", "~"], "'"}]}]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalTheta]Dyadt[{3, -$CellContext`NPt}][
       $CellContext`PhiCDe22Dyadt[]],
      Editable->False]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.64779240698841*^9, 3.647792479479085*^9, 
  3.6481831905842037`*^9, 3.648188524588459*^9, 3.6481916769376526`*^9, 
  3.6481933300827184`*^9, 3.6481938249493456`*^9, 3.648209879232463*^9, 
  3.648210219748168*^9, 3.6482640364165373`*^9, 3.6482643158531375`*^9, 
  3.6482651273934946`*^9, 3.6483498778838325`*^9, 3.648350922346295*^9, 
  3.6483526085096555`*^9, 3.6491725734465246`*^9, 3.64917267042666*^9, 
  3.728210477787121*^9, 3.728793141496661*^9, 3.956192973049904*^9, 
  3.956193833656206*^9, 3.975467539979349*^9, 3.975467938449718*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"ef8ece32-5030-44b7-bee6-03ecb89364e9"]
}, Open  ]],

Cell["\<\
It is also possible to expand an equation into on dyad and look at the \
components in another one (red is the default color for Dyad components and \
was not set in this notebook- only the green color and the tilde contain the \
dyad information):\
\>", "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellChangeTimes->{{3.6442122654334283`*^9, 3.6442122895753756`*^9}, {
   3.644212606380419*^9, 3.6442126423058653`*^9}, {3.644213147099469*^9, 
   3.644213159334499*^9}, {3.6442135544251876`*^9, 3.644213559796273*^9}, {
   3.6442138365723653`*^9, 3.6442138393850183`*^9}, {3.6442142636109686`*^9, 
   3.6442142665173736`*^9}, {3.645008837831534*^9, 3.645008901571623*^9}, {
   3.645008940691678*^9, 3.6450090333518076`*^9}, {3.6450090854018803`*^9, 
   3.6450092097520547`*^9}, 3.647779339069558*^9, {3.648187327140538*^9, 
   3.6481875180821576`*^9}, {3.6481875842243357`*^9, 3.648187625179743*^9}, {
   3.6481876875576143`*^9, 3.648187687854514*^9}, {3.648187719551789*^9, 
   3.6481877434266224`*^9}, {3.64818790599888*^9, 3.648187940233678*^9}, {
   3.648188098535614*^9, 3.648188129596885*^9}, {3.648210296767843*^9, 
   3.648210374987688*^9}},ExpressionUUID->"fb162883-1946-4428-943c-\
a0011fc50e51"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DyadComponents", "[", 
  RowBox[{
   RowBox[{"ToGHP", "[", 
    RowBox[{
     RowBox[{"0", "==", 
      RowBox[{
       RowBox[{"CurlDgCDe", "[", "phi20", "]"}], "[", 
       RowBox[{
        RowBox[{"-", "A"}], ",", 
        RowBox[{"-", "A\[Dagger]"}]}], "]"}]}], ",", "Dyadg"}], "]"}], ",", 
   "Dyadt"}], "]"}]], "Input",
 CellChangeTimes->{{3.644213458763792*^9, 3.644213464529729*^9}, {
   3.644213525111124*^9, 3.6442135252830057`*^9}, 3.6449405420036526`*^9, {
   3.6449405884337173`*^9, 3.644940593463724*^9}, {3.647750851011447*^9, 
   3.647750851152081*^9}, {3.6481880409686527`*^9, 3.648188056531935*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"25dadde0-f764-4cdf-b96d-4ab17a95c398"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GHP weights for \"\>", "\[InvisibleSpace]", 
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], 
   "\[InvisibleSpace]", "\<\" components are generated, \"\>", 
   "\[InvisibleSpace]", "\<\"components are formatted, \"\>", 
   "\[InvisibleSpace]", "\<\"Tex components are set.\"\>"}],
  SequenceForm["GHP weights for ", 
   $CellContext`CurlDgCDe[$CellContext`phi20], " components are generated, ", 
   "components are formatted, ", "Tex components are set."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6481885250416093`*^9, 3.6481916769689045`*^9, 
  3.64819333064525*^9, 3.6482098794043474`*^9, 3.648210219779421*^9, 
  3.648264036932189*^9, 3.648264315978139*^9, 3.64826512775289*^9, 
  3.6483498779838324`*^9, 3.6483509223562946`*^9, 3.6483526085396557`*^9, 
  3.6491725734965243`*^9, 3.64917267043666*^9, 3.7282104778714314`*^9, 
  3.728793141522662*^9, 3.956192973137642*^9, 3.9561938336871204`*^9, 
  3.9754675400167303`*^9, 3.975467938487795*^9},
 CellLabel->
  "During evaluation of \
In[65]:=",ExpressionUUID->"077893a8-9dcd-4ef4-a605-5e0d090b132c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], 
   "\[InvisibleSpace]", "\<\" is expanded into \"\>", "\[InvisibleSpace]", 
   "Dyadg"}],
  SequenceForm[
   $CellContext`CurlDgCDe[$CellContext`phi20], 
   " is expanded into ", $CellContext`Dyadg],
  Editable->False]], "Print",
 CellChangeTimes->{3.6481885250416093`*^9, 3.6481916769689045`*^9, 
  3.64819333064525*^9, 3.6482098794043474`*^9, 3.648210219779421*^9, 
  3.648264036932189*^9, 3.648264315978139*^9, 3.64826512775289*^9, 
  3.6483498779838324`*^9, 3.6483509223562946`*^9, 3.6483526085396557`*^9, 
  3.6491725734965243`*^9, 3.64917267043666*^9, 3.7282104778714314`*^9, 
  3.728793141522662*^9, 3.956192973137642*^9, 3.9561938336871204`*^9, 
  3.9754675400167303`*^9, 3.975467938595598*^9},
 CellLabel->
  "During evaluation of \
In[65]:=",ExpressionUUID->"382ad9e1-f971-4cab-b294-0c9d366d1a1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating the \"\>", "\[InvisibleSpace]", "Dyadg", 
   "\[InvisibleSpace]", "\<\"components of \"\>", "\[InvisibleSpace]", 
   RowBox[{"CurlDgCDe", "[", "phi20", "]"}], 
   "\[InvisibleSpace]", "\<\" in GHP form. (Improved code)\"\>"}],
  SequenceForm["Calculating the ", $CellContext`Dyadg, "components of ", 
   $CellContext`CurlDgCDe[$CellContext`phi20], 
   " in GHP form. (Improved code)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6481885250416093`*^9, 3.6481916769689045`*^9, 
  3.64819333064525*^9, 3.6482098794043474`*^9, 3.648210219779421*^9, 
  3.648264036932189*^9, 3.648264315978139*^9, 3.64826512775289*^9, 
  3.6483498779838324`*^9, 3.6483509223562946`*^9, 3.6483526085396557`*^9, 
  3.6491725734965243`*^9, 3.64917267043666*^9, 3.7282104778714314`*^9, 
  3.728793141522662*^9, 3.956192973137642*^9, 3.9561938336871204`*^9, 
  3.9754675400167303`*^9, 3.975467938601368*^9},
 CellLabel->
  "During evaluation of \
In[65]:=",ExpressionUUID->"d643d50d-134d-4fd3-ae66-966ef0b540e4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Phi]", 
          StyleBox["2",
           FontColor->RGBColor[0., 1., 0.]]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Kappa]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Kappa]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Kappa]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Rho]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Rho]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Rho]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Rho]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Sigma]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Sigma]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Sigma]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Tau]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Tau]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Tau]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Tau]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Thorn]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{1, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Thorn]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{1, -$CellContext`NPg}][
         $CellContext`phi20[{1, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Thorn]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["0",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{2, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          0, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Thorn]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{2, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Eth]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{3, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Eth]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{3, -$CellContext`NPg}][
         $CellContext`phi20[{1, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Eth]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["0",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{4, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          0, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Eth]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{4, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Phi]", 
          StyleBox["2",
           FontColor->RGBColor[0., 1., 0.]]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Kappa]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Kappa]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Kappa]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Rho]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Rho]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Rho]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Rho]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Sigma]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Sigma]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Sigma]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Tau]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Tau]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Tau]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Tau]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Thorn]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{1, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Thorn]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{1, -$CellContext`NPg}][
         $CellContext`phi20[{1, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Thorn]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["0",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{2, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          0, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Thorn]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{2, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Eth]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{3, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Eth]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{3, -$CellContext`NPg}][
         $CellContext`phi20[{1, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Eth]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["0",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{4, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          0, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["0", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{0, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Eth]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{4, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Phi]", 
          StyleBox["2",
           FontColor->RGBColor[0., 1., 0.]]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Kappa]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Kappa]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Kappa]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Rho]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Rho]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Rho]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Rho]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Sigma]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Sigma]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Sigma]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Tau]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Tau]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Tau]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Tau]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Thorn]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{1, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Thorn]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{1, -$CellContext`NPg}][
         $CellContext`phi20[{1, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Thorn]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["0",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{2, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          0, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Thorn]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{2, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Eth]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{3, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Eth]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{3, -$CellContext`NPg}][
         $CellContext`phi20[{1, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Eth]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["0",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{4, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          0, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["0", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{0, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          RowBox[{
           StyleBox["\[Eth]",
            FontColor->RGBColor[0., 1., 0.]], "'"}], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{4, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[
         SubscriptBox["\[Phi]", 
          StyleBox["2",
           FontColor->RGBColor[0., 1., 0.]]],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Kappa]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Kappa]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Kappa]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Kappa]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Rho]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Rho]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Rho]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Rho]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Rho]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Rho]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Sigma]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Sigma]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Sigma]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Sigma]pDyadg[],
       Editable->False]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["2",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{1, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Tau]Dyadg[],
       Editable->False]}], "-", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[Tau]",
        ShowAutoStyles->False,
        AutoSpacing->False,
        FontColor->RGBColor[0., 1., 0.]],
       $CellContext`\[Tau]Dyadg[],
       Editable->False]}], "+", 
     RowBox[{"2", " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["1",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {1, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Tau]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[
        SubscriptBox["\[Phi]", 
         StyleBox["0",
          FontColor->RGBColor[0., 1., 0.]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`phi20[{0, -$CellContext`Dyadg}, {0, -$CellContext`Dyadg}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["\[Tau]",
          FontColor->RGBColor[0., 1., 0.]], "'"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Tau]pDyadg[],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["\[Iota]",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Thorn]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["1",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{1, -$CellContext`NPg}][
         $CellContext`phi20[{0, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "+", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           StyleBox["o",
            FontColor->RGBColor[0., 1., 0.]], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                OverscriptBox["1", "~"],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`og[{1, -$CellContext`Dyadt}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["\[Iota]",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[Iota]g\[Dagger][{1, -$CellContext`Dyadt\[Dagger]}],
       Editable->False], " ", 
      RowBox[{"(", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          StyleBox["\[Thorn]",
           FontColor->RGBColor[0., 1., 0.]], 
          SubscriptBox["\[Phi]", 
           StyleBox["2",
            FontColor->RGBColor[0., 1., 0.]]]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalTheta]Dyadg[{1, -$CellContext`NPg}][
         $CellContext`phi20[{1, -$CellContext`Dyadg}, {
          1, -$CellContext`Dyadg}]],
        Editable->False], ")"}]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           OverscriptBox[
            StyleBox["o",
             FontColor->RGBColor[0., 1., 0.]], "_"], 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox[
                RowBox[{
                 OverscriptBox["1", "~"], "'"}],
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.2799999999999